/*
 * This file was generated by running ./tools/make-manuf.py.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * The data below has been assembled from the following sources:
 *
 * The IEEE public OUI listings available from:
 * <http://standards-oui.ieee.org/oui/oui.csv>
 * <http://standards-oui.ieee.org/cid/cid.csv>
 * <http://standards-oui.ieee.org/iab/iab.csv>
 * <http://standards-oui.ieee.org/oui28/mam.csv>
 * <http://standards-oui.ieee.org/oui36/oui36.csv>
 *
 */

static const manuf_registry_t ieee_registry_table[] = {
    { { 0x00, 0x1B, 0xC5 }, MA_S },
    { { 0x00, 0x50, 0xC2 }, MA_S },
    { { 0x00, 0x55, 0xDA }, MA_M },
    { { 0x00, 0x69, 0x67 }, MA_M },
    { { 0x00, 0x8D, 0xF4 }, MA_M },
    { { 0x04, 0x11, 0x19 }, MA_M },
    { { 0x04, 0x71, 0x4B }, MA_M },
    { { 0x04, 0xC3, 0xE6 }, MA_M },
    { { 0x04, 0xD1, 0x6E }, MA_M },
    { { 0x04, 0xEE, 0xE8 }, MA_M },
    { { 0x08, 0x26, 0xAE }, MA_M },
    { { 0x08, 0x63, 0x32 }, MA_M },
    { { 0x08, 0xDA, 0x33 }, MA_M },
    { { 0x08, 0xED, 0x02 }, MA_M },
    { { 0x08, 0xF8, 0x0D }, MA_M },
    { { 0x0C, 0x5C, 0xB5 }, MA_M },
    { { 0x0C, 0x73, 0xEB }, MA_M },
    { { 0x0C, 0x7F, 0xED }, MA_M },
    { { 0x0C, 0x86, 0x29 }, MA_M },
    { { 0x0C, 0xCC, 0x47 }, MA_M },
    { { 0x0C, 0xEF, 0xAF }, MA_M },
    { { 0x0C, 0xFE, 0x5D }, MA_M },
    { { 0x10, 0x06, 0x48 }, MA_M },
    { { 0x10, 0x07, 0x23 }, MA_M },
    { { 0x10, 0x54, 0xD2 }, MA_M },
    { { 0x10, 0x63, 0xA3 }, MA_M },
    { { 0x10, 0xDC, 0xB6 }, MA_M },
    { { 0x14, 0x1F, 0xBA }, MA_M },
    { { 0x14, 0x4F, 0xD7 }, MA_M },
    { { 0x14, 0xAE, 0x85 }, MA_M },
    { { 0x18, 0x45, 0xB3 }, MA_M },
    { { 0x18, 0x74, 0xE2 }, MA_M },
    { { 0x18, 0x9B, 0xA5 }, MA_M },
    { { 0x18, 0xA5, 0x9C }, MA_M },
    { { 0x18, 0xC3, 0xF4 }, MA_M },
    { { 0x18, 0xD7, 0x93 }, MA_M },
    { { 0x18, 0xFD, 0xCB }, MA_M },
    { { 0x1C, 0x21, 0xD1 }, MA_M },
    { { 0x1C, 0x59, 0x74 }, MA_M },
    { { 0x1C, 0x82, 0x59 }, MA_M },
    { { 0x1C, 0x87, 0x74 }, MA_M },
    { { 0x1C, 0x87, 0x76 }, MA_M },
    { { 0x1C, 0x87, 0x79 }, MA_M },
    { { 0x1C, 0x88, 0x79 }, MA_M },
    { { 0x1C, 0xA0, 0xD3 }, MA_M },
    { { 0x1C, 0xA0, 0xEF }, MA_M },
    { { 0x1C, 0xAE, 0x3E }, MA_M },
    { { 0x1C, 0xC0, 0xE1 }, MA_M },
    { { 0x1C, 0xCA, 0xE3 }, MA_M },
    { { 0x1C, 0xFD, 0x08 }, MA_M },
    { { 0x20, 0x0A, 0x0D }, MA_M },
    { { 0x20, 0x85, 0x93 }, MA_M },
    { { 0x20, 0xCE, 0x2A }, MA_M },
    { { 0x24, 0x15, 0x10 }, MA_M },
    { { 0x24, 0x4E, 0x7B }, MA_M },
    { { 0x24, 0x5D, 0xFC }, MA_M },
    { { 0x24, 0x86, 0x25 }, MA_M },
    { { 0x28, 0x2C, 0x02 }, MA_M },
    { { 0x28, 0x36, 0x13 }, MA_M },
    { { 0x28, 0x36, 0x38 }, MA_M },
    { { 0x28, 0xB7, 0x7C }, MA_M },
    { { 0x28, 0xF5, 0x37 }, MA_M },
    { { 0x28, 0xF8, 0xC6 }, MA_M },
    { { 0x28, 0xFD, 0x80 }, MA_M },
    { { 0x2C, 0x16, 0xBD }, MA_M },
    { { 0x2C, 0x26, 0x5F }, MA_M },
    { { 0x2C, 0x27, 0x9E }, MA_M },
    { { 0x2C, 0x48, 0x35 }, MA_M },
    { { 0x2C, 0x69, 0x1D }, MA_M },
    { { 0x2C, 0x6A, 0x6F }, MA_M },
    { { 0x2C, 0xC4, 0x4F }, MA_M },
    { { 0x2C, 0xD1, 0x41 }, MA_M },
    { { 0x30, 0x09, 0xF9 }, MA_M },
    { { 0x30, 0x0A, 0x60 }, MA_M },
    { { 0x30, 0x1F, 0x9A }, MA_M },
    { { 0x30, 0x3D, 0x51 }, MA_M },
    { { 0x30, 0x43, 0xD7 }, MA_M },
    { { 0x30, 0x49, 0x50 }, MA_M },
    { { 0x34, 0x00, 0x8A }, MA_M },
    { { 0x34, 0x04, 0x9E }, MA_M },
    { { 0x34, 0x29, 0x8F }, MA_M },
    { { 0x34, 0x46, 0x63 }, MA_M },
    { { 0x34, 0xC8, 0xD6 }, MA_M },
    { { 0x34, 0xD0, 0xB8 }, MA_M },
    { { 0x34, 0xE1, 0xD1 }, MA_M },
    { { 0x38, 0x1F, 0x26 }, MA_M },
    { { 0x38, 0x3A, 0x21 }, MA_M },
    { { 0x38, 0x73, 0xEA }, MA_M },
    { { 0x38, 0xA8, 0xCD }, MA_M },
    { { 0x38, 0xB1, 0x9E }, MA_M },
    { { 0x38, 0xB8, 0xEB }, MA_M },
    { { 0x38, 0xF7, 0xCD }, MA_M },
    { { 0x38, 0xFD, 0xFE }, MA_M },
    { { 0x3C, 0x24, 0xF0 }, MA_M },
    { { 0x3C, 0x39, 0xE7 }, MA_M },
    { { 0x3C, 0x42, 0x7E }, MA_M },
    { { 0x3C, 0x6A, 0x2C }, MA_M },
    { { 0x3C, 0xFA, 0xD3 }, MA_M },
    { { 0x40, 0x11, 0x75 }, MA_M },
    { { 0x40, 0x2C, 0x76 }, MA_M },
    { { 0x40, 0x48, 0xFD }, MA_M },
    { { 0x40, 0xA3, 0x6B }, MA_M },
    { { 0x40, 0xD8, 0x55 }, MA_S },
    { { 0x40, 0xED, 0x98 }, MA_M },
    { { 0x40, 0xF3, 0x85 }, MA_M },
    { { 0x44, 0x03, 0x77 }, MA_M },
    { { 0x44, 0x6F, 0xD8 }, MA_M },
    { { 0x44, 0xA9, 0x2C }, MA_M },
    { { 0x44, 0xD5, 0xF2 }, MA_M },
    { { 0x48, 0x0B, 0xB2 }, MA_M },
    { { 0x48, 0x5E, 0x0E }, MA_M },
    { { 0x48, 0x65, 0xEE }, MA_M },
    { { 0x48, 0xDA, 0x35 }, MA_M },
    { { 0x48, 0xE6, 0x63 }, MA_M },
    { { 0x48, 0xE6, 0xC6 }, MA_M },
    { { 0x4C, 0x4B, 0xF9 }, MA_M },
    { { 0x4C, 0x65, 0xA8 }, MA_M },
    { { 0x4C, 0x74, 0xA7 }, MA_M },
    { { 0x4C, 0x91, 0x7A }, MA_M },
    { { 0x4C, 0x93, 0xA6 }, MA_M },
    { { 0x4C, 0xBC, 0x98 }, MA_M },
    { { 0x4C, 0xE1, 0x73 }, MA_M },
    { { 0x4C, 0xEA, 0x41 }, MA_M },
    { { 0x50, 0x0B, 0x91 }, MA_M },
    { { 0x50, 0x48, 0x2C }, MA_M },
    { { 0x50, 0x62, 0x55 }, MA_M },
    { { 0x50, 0xA0, 0x30 }, MA_M },
    { { 0x50, 0xA4, 0xD0 }, MA_M },
    { { 0x50, 0xDE, 0x19 }, MA_M },
    { { 0x50, 0xFF, 0x99 }, MA_M },
    { { 0x54, 0x08, 0x3B }, MA_M },
    { { 0x54, 0x91, 0xAF }, MA_M },
    { { 0x54, 0x9A, 0x11 }, MA_M },
    { { 0x54, 0xA4, 0x93 }, MA_M },
    { { 0x58, 0x20, 0x8A }, MA_M },
    { { 0x58, 0x47, 0xCA }, MA_M },
    { { 0x58, 0x48, 0x49 }, MA_M },
    { { 0x58, 0x95, 0xD8 }, MA_M },
    { { 0x58, 0xC4, 0x1E }, MA_M },
    { { 0x58, 0xE8, 0x76 }, MA_M },
    { { 0x58, 0xFC, 0xDB }, MA_M },
    { { 0x5C, 0x5A, 0x4C }, MA_M },
    { { 0x5C, 0x6A, 0xEC }, MA_M },
    { { 0x5C, 0x85, 0x7E }, MA_M },
    { { 0x5C, 0x87, 0xD8 }, MA_M },
    { { 0x5C, 0xF2, 0x86 }, MA_M },
    { { 0x5C, 0xF8, 0x38 }, MA_M },
    { { 0x60, 0x15, 0x92 }, MA_M },
    { { 0x60, 0x95, 0xCE }, MA_M },
    { { 0x60, 0xA4, 0x34 }, MA_M },
    { { 0x60, 0xD7, 0xE3 }, MA_M },
    { { 0x64, 0x31, 0x39 }, MA_M },
    { { 0x64, 0x33, 0xB5 }, MA_M },
    { { 0x64, 0x62, 0x66 }, MA_M },
    { { 0x64, 0xFB, 0x81 }, MA_M },
    { { 0x68, 0x79, 0x12 }, MA_M },
    { { 0x68, 0x91, 0xD0 }, MA_M },
    { { 0x68, 0xDA, 0x73 }, MA_M },
    { { 0x6C, 0x15, 0x24 }, MA_M },
    { { 0x6C, 0x2A, 0xDF }, MA_M },
    { { 0x6C, 0x5C, 0x3D }, MA_M },
    { { 0x6C, 0x93, 0x08 }, MA_M },
    { { 0x6C, 0xDF, 0xFB }, MA_M },
    { { 0x70, 0x06, 0x92 }, MA_M },
    { { 0x70, 0x50, 0xE7 }, MA_M },
    { { 0x70, 0x5A, 0x6F }, MA_M },
    { { 0x70, 0x69, 0x79 }, MA_M },
    { { 0x70, 0x88, 0x6B }, MA_M },
    { { 0x70, 0xB3, 0xD5 }, MA_S },
    { { 0x70, 0xF8, 0xE7 }, MA_M },
    { { 0x74, 0x19, 0xF8 }, MA_M },
    { { 0x74, 0x1A, 0xE0 }, MA_M },
    { { 0x74, 0x5B, 0xC5 }, MA_M },
    { { 0x74, 0xE1, 0x4A }, MA_M },
    { { 0x74, 0xF8, 0xDB }, MA_M },
    { { 0x78, 0x13, 0x05 }, MA_M },
    { { 0x78, 0x39, 0x2D }, MA_M },
    { { 0x78, 0x5E, 0xE8 }, MA_M },
    { { 0x78, 0x72, 0x64 }, MA_M },
    { { 0x78, 0xC2, 0xC0 }, MA_M },
    { { 0x78, 0xCA, 0x83 }, MA_M },
    { { 0x78, 0xD4, 0xF1 }, MA_M },
    { { 0x78, 0xD8, 0x00 }, MA_M },
    { { 0x78, 0xE9, 0x96 }, MA_M },
    { { 0x7C, 0x45, 0xF9 }, MA_M },
    { { 0x7C, 0x47, 0x7C }, MA_M },
    { { 0x7C, 0x70, 0xBC }, MA_M },
    { { 0x7C, 0x83, 0x34 }, MA_M },
    { { 0x7C, 0xBA, 0xCC }, MA_M },
    { { 0x7C, 0xBC, 0x84 }, MA_M },
    { { 0x7C, 0xCB, 0xE2 }, MA_M },
    { { 0x80, 0x02, 0xF4 }, MA_M },
    { { 0x80, 0x0A, 0x80 }, MA_M },
    { { 0x80, 0x7B, 0x85 }, MA_M },
    { { 0x80, 0xA5, 0x79 }, MA_M },
    { { 0x80, 0xE4, 0xDA }, MA_M },
    { { 0x84, 0x11, 0xC2 }, MA_M },
    { { 0x84, 0x39, 0xBE }, MA_M },
    { { 0x84, 0x89, 0xEC }, MA_M },
    { { 0x84, 0x8B, 0xCD }, MA_M },
    { { 0x84, 0xB3, 0x86 }, MA_M },
    { { 0x84, 0xE0, 0xF4 }, MA_M },
    { { 0x88, 0x3C, 0xC5 }, MA_M },
    { { 0x88, 0x5D, 0x90 }, MA_M },
    { { 0x88, 0x5F, 0xE8 }, MA_M },
    { { 0x88, 0xA6, 0xEF }, MA_M },
    { { 0x88, 0xA9, 0xA7 }, MA_M },
    { { 0x88, 0xC9, 0xB3 }, MA_M },
    { { 0x8C, 0x14, 0x7D }, MA_M },
    { { 0x8C, 0x19, 0x2D }, MA_M },
    { { 0x8C, 0x1C, 0xDA }, MA_M },
    { { 0x8C, 0x1F, 0x64 }, MA_S },
    { { 0x8C, 0x47, 0x6E }, MA_M },
    { { 0x8C, 0x51, 0x09 }, MA_M },
    { { 0x8C, 0x55, 0x70 }, MA_M },
    { { 0x8C, 0x59, 0x3C }, MA_M },
    { { 0x8C, 0x5D, 0xB2 }, MA_M },
    { { 0x8C, 0xA6, 0x82 }, MA_M },
    { { 0x8C, 0xAE, 0x49 }, MA_M },
    { { 0x8C, 0xC8, 0xF4 }, MA_M },
    { { 0x90, 0x15, 0x64 }, MA_M },
    { { 0x90, 0x4E, 0x91 }, MA_M },
    { { 0x90, 0xA9, 0xF7 }, MA_M },
    { { 0x90, 0xC6, 0x82 }, MA_M },
    { { 0x90, 0xE2, 0xFC }, MA_M },
    { { 0x90, 0xF4, 0x21 }, MA_M },
    { { 0x94, 0x05, 0xBB }, MA_M },
    { { 0x94, 0xC9, 0xB7 }, MA_M },
    { { 0x94, 0xCC, 0x04 }, MA_M },
    { { 0x94, 0xFB, 0xA7 }, MA_M },
    { { 0x98, 0x02, 0xD8 }, MA_M },
    { { 0x98, 0x06, 0x37 }, MA_M },
    { { 0x98, 0x27, 0x82 }, MA_M },
    { { 0x98, 0x6D, 0x35 }, MA_M },
    { { 0x98, 0x6E, 0xE8 }, MA_M },
    { { 0x98, 0x80, 0xBB }, MA_M },
    { { 0x98, 0x8F, 0xE0 }, MA_M },
    { { 0x98, 0xAA, 0xFC }, MA_M },
    { { 0x98, 0xF9, 0xC7 }, MA_M },
    { { 0x98, 0xFC, 0x84 }, MA_M },
    { { 0x9C, 0x43, 0x1E }, MA_M },
    { { 0x9C, 0x69, 0xB4 }, MA_M },
    { { 0x9C, 0xF6, 0xDD }, MA_M },
    { { 0xA0, 0x02, 0x4A }, MA_M },
    { { 0xA0, 0x19, 0xB2 }, MA_M },
    { { 0xA0, 0x22, 0x4E }, MA_M },
    { { 0xA0, 0x28, 0x33 }, MA_M },
    { { 0xA0, 0x3E, 0x6B }, MA_M },
    { { 0xA0, 0xBB, 0x3E }, MA_M },
    { { 0xA0, 0xC5, 0xF2 }, MA_M },
    { { 0xA4, 0x11, 0x63 }, MA_M },
    { { 0xA4, 0x3B, 0xFA }, MA_M },
    { { 0xA4, 0x4F, 0x29 }, MA_M },
    { { 0xA4, 0x53, 0xEE }, MA_M },
    { { 0xA4, 0x58, 0x0F }, MA_M },
    { { 0xA4, 0xDA, 0x22 }, MA_M },
    { { 0xA4, 0xED, 0x43 }, MA_M },
    { { 0xA8, 0x3F, 0xA1 }, MA_M },
    { { 0xA8, 0x5B, 0x36 }, MA_M },
    { { 0xAC, 0x1D, 0xDF }, MA_M },
    { { 0xAC, 0x64, 0xDD }, MA_M },
    { { 0xAC, 0x86, 0xD1 }, MA_M },
    { { 0xB0, 0x1F, 0x81 }, MA_M },
    { { 0xB0, 0xB3, 0x53 }, MA_M },
    { { 0xB0, 0xC5, 0xCA }, MA_M },
    { { 0xB0, 0xFD, 0x0B }, MA_M },
    { { 0xB0, 0xFF, 0x72 }, MA_M },
    { { 0xB4, 0x37, 0xD1 }, MA_M },
    { { 0xB4, 0x4B, 0xD6 }, MA_M },
    { { 0xB4, 0x4D, 0x43 }, MA_M },
    { { 0xB4, 0xA2, 0xEB }, MA_M },
    { { 0xB8, 0x4C, 0x87 }, MA_M },
    { { 0xB8, 0xD8, 0x12 }, MA_M },
    { { 0xBC, 0x31, 0x98 }, MA_M },
    { { 0xBC, 0x34, 0x00 }, MA_M },
    { { 0xBC, 0x66, 0x41 }, MA_M },
    { { 0xBC, 0x97, 0x40 }, MA_M },
    { { 0xC0, 0x22, 0xF1 }, MA_M },
    { { 0xC0, 0x61, 0x9A }, MA_M },
    { { 0xC0, 0x83, 0x59 }, MA_M },
    { { 0xC0, 0x9B, 0xF4 }, MA_M },
    { { 0xC0, 0xD3, 0x91 }, MA_M },
    { { 0xC0, 0xEA, 0xC3 }, MA_M },
    { { 0xC0, 0xFB, 0xF9 }, MA_M },
    { { 0xC4, 0x7C, 0x8D }, MA_M },
    { { 0xC4, 0x83, 0x72 }, MA_M },
    { { 0xC4, 0x95, 0x4D }, MA_M },
    { { 0xC4, 0x98, 0x94 }, MA_M },
    { { 0xC4, 0xA1, 0x0E }, MA_M },
    { { 0xC4, 0xA5, 0x59 }, MA_M },
    { { 0xC4, 0xCC, 0x37 }, MA_M },
    { { 0xC4, 0xFF, 0x84 }, MA_M },
    { { 0xC4, 0xFF, 0xBC }, MA_M },
    { { 0xC8, 0x2C, 0x2B }, MA_M },
    { { 0xC8, 0x5C, 0xE2 }, MA_M },
    { { 0xC8, 0x63, 0x14 }, MA_M },
    { { 0xC8, 0x6B, 0xBC }, MA_M },
    { { 0xC8, 0x8E, 0xD1 }, MA_M },
    { { 0xC8, 0x98, 0xDB }, MA_M },
    { { 0xC8, 0xF5, 0xD6 }, MA_M },
    { { 0xC8, 0xFF, 0xBF }, MA_M },
    { { 0xCC, 0x1B, 0xE0 }, MA_M },
    { { 0xCC, 0x22, 0x37 }, MA_M },
    { { 0xCC, 0x4F, 0x5C }, MA_M },
    { { 0xCC, 0xC2, 0x61 }, MA_M },
    { { 0xCC, 0xD3, 0x1E }, MA_M },
    { { 0xCC, 0xD3, 0x9D }, MA_M },
    { { 0xD0, 0x14, 0x11 }, MA_M },
    { { 0xD0, 0x15, 0xBB }, MA_M },
    { { 0xD0, 0x16, 0xF0 }, MA_M },
    { { 0xD0, 0x22, 0x12 }, MA_M },
    { { 0xD0, 0x5F, 0x64 }, MA_M },
    { { 0xD0, 0x76, 0x50 }, MA_M },
    { { 0xD0, 0x93, 0x95 }, MA_M },
    { { 0xD0, 0x96, 0x86 }, MA_M },
    { { 0xD0, 0x9F, 0xD9 }, MA_M },
    { { 0xD0, 0xA0, 0x11 }, MA_M },
    { { 0xD0, 0xC8, 0x57 }, MA_M },
    { { 0xD0, 0xD9, 0x4F }, MA_M },
    { { 0xD4, 0x20, 0x00 }, MA_M },
    { { 0xD4, 0x25, 0xCC }, MA_M },
    { { 0xD4, 0x61, 0x37 }, MA_M },
    { { 0xD4, 0x7C, 0x44 }, MA_M },
    { { 0xD4, 0xBA, 0xBA }, MA_M },
    { { 0xD8, 0x86, 0x0B }, MA_M },
    { { 0xDC, 0x36, 0x43 }, MA_M },
    { { 0xDC, 0x44, 0x27 }, MA_M },
    { { 0xDC, 0x4A, 0x9E }, MA_M },
    { { 0xDC, 0xE5, 0x33 }, MA_M },
    { { 0xE0, 0x38, 0x2D }, MA_M },
    { { 0xE0, 0x3C, 0x1C }, MA_M },
    { { 0xE0, 0x5A, 0x9F }, MA_M },
    { { 0xE0, 0xB6, 0xF5 }, MA_M },
    { { 0xE4, 0x1E, 0x0A }, MA_M },
    { { 0xE4, 0x4C, 0xC7 }, MA_M },
    { { 0xE4, 0x95, 0x6E }, MA_M },
    { { 0xE8, 0x18, 0x63 }, MA_M },
    { { 0xE8, 0x6C, 0xC7 }, MA_M },
    { { 0xE8, 0x78, 0x29 }, MA_M },
    { { 0xE8, 0xB4, 0x70 }, MA_M },
    { { 0xE8, 0xFF, 0x1E }, MA_M },
    { { 0xEC, 0x5B, 0xCD }, MA_M },
    { { 0xEC, 0x9A, 0x0C }, MA_M },
    { { 0xEC, 0x9F, 0x0D }, MA_M },
    { { 0xF0, 0x22, 0x1D }, MA_M },
    { { 0xF0, 0x23, 0xB9 }, MA_M },
    { { 0xF0, 0x2A, 0x2B }, MA_M },
    { { 0xF0, 0x41, 0xC8 }, MA_M },
    { { 0xF0, 0xAC, 0xD7 }, MA_M },
    { { 0xF0, 0xD7, 0xAF }, MA_M },
    { { 0xF4, 0x0E, 0x11 }, MA_M },
    { { 0xF4, 0x1A, 0x79 }, MA_M },
    { { 0xF4, 0x20, 0x55 }, MA_M },
    { { 0xF4, 0x69, 0xD5 }, MA_M },
    { { 0xF4, 0x70, 0x0C }, MA_M },
    { { 0xF4, 0x90, 0xCB }, MA_M },
    { { 0xF4, 0xA4, 0x54 }, MA_M },
    { { 0xF8, 0x02, 0x78 }, MA_M },
    { { 0xF8, 0x1D, 0x78 }, MA_M },
    { { 0xF8, 0x7A, 0x39 }, MA_M },
    { { 0xF8, 0x8A, 0x3C }, MA_M },
    { { 0xF8, 0xB5, 0x68 }, MA_M },
    { { 0xFC, 0x61, 0x79 }, MA_M },
    { { 0xFC, 0xA4, 0x7A }, MA_M },
    { { 0xFC, 0xCD, 0x2F }, MA_M },
    { { 0xFC, 0xD2, 0xB6 }, MA_M },
};

static const manuf_oui24_t global_manuf_oui24_table[] = {
    { { 0x00, 0x00, 0x00 }, "00:00:00",     "Officially Xerox, but 0:0:0:0:0:0 is more common" },
    { { 0x00, 0x00, 0x01 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x02 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x03 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x04 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x05 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x06 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x07 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x08 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x09 }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0x0A }, "OmronTateisi", "Omron Tateisi Electronics Co." },
    { { 0x00, 0x00, 0x0B }, "Matrix",       "Matrix Corporation" },
    { { 0x00, 0x00, 0x0C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x00, 0x0D }, "Fibronics",    "Fibronics Ltd." },
    { { 0x00, 0x00, 0x0E }, "Fujitsu",      "Fujitsu Limited" },
    { { 0x00, 0x00, 0x0F }, "Next",         "Next, Inc." },
    { { 0x00, 0x00, 0x10 }, "Sytek",        "Sytek Inc." },
    { { 0x00, 0x00, 0x11 }, "NormerelSyst", "Normerel Systemes" },
    { { 0x00, 0x00, 0x12 }, "InformationT", "Information Technology Limited" },
    { { 0x00, 0x00, 0x13 }, "Camex",        "Camex" },
    { { 0x00, 0x00, 0x14 }, "Netronix",     "Netronix" },
    { { 0x00, 0x00, 0x15 }, "Datapoint",    "Datapoint Corporation" },
    { { 0x00, 0x00, 0x16 }, "DuPontPixel",  "Du Pont Pixel Systems." },
    { { 0x00, 0x00, 0x17 }, "Oracle",       "Oracle" },
    { { 0x00, 0x00, 0x18 }, "WebsterCompu", "Webster Computer Corporation" },
    { { 0x00, 0x00, 0x19 }, "AppliedDynam", "Applied Dynamics International" },
    { { 0x00, 0x00, 0x1A }, "AMD",          "Advanced Micro Devices" },
    { { 0x00, 0x00, 0x1B }, "Novell",       "Novell, Inc." },
    { { 0x00, 0x00, 0x1C }, "BellTechnolo", "Bell Technologies" },
    { { 0x00, 0x00, 0x1D }, "Cabletron",    "Cabletron Systems, Inc." },
    { { 0x00, 0x00, 0x1E }, "TelsistIndus", "Telsist Industria Electronica" },
    { { 0x00, 0x00, 0x1F }, "Telco",        "Telco Systems, Inc." },
    { { 0x00, 0x00, 0x20 }, "Dataindustri", "Dataindustrier Diab Ab" },
    { { 0x00, 0x00, 0x21 }, "SuremanCompC", "Sureman Comp. & Commun. Corp." },
    { { 0x00, 0x00, 0x22 }, "VisualTechno", "Visual Technology Inc." },
    { { 0x00, 0x00, 0x23 }, "AbbIndustria", "Abb Industrial Systems Ab" },
    { { 0x00, 0x00, 0x24 }, "ConnectAs",    "Connect As" },
    { { 0x00, 0x00, 0x25 }, "Ramtek",       "Ramtek Corp." },
    { { 0x00, 0x00, 0x26 }, "ShaKen",       "Sha-Ken Co., Ltd." },
    { { 0x00, 0x00, 0x27 }, "JapanRadio",   "Japan Radio Company" },
    { { 0x00, 0x00, 0x28 }, "Prodigy",      "Prodigy Systems Corporation" },
    { { 0x00, 0x00, 0x29 }, "ImcNetworks",  "Imc Networks Corp." },
    { { 0x00, 0x00, 0x2A }, "TrwSeddInp",   "Trw - Sedd/Inp" },
    { { 0x00, 0x00, 0x2B }, "CrispAutomat", "Crisp Automation, Inc" },
    { { 0x00, 0x00, 0x2C }, "Autotote",     "Autotote Limited" },
    { { 0x00, 0x00, 0x2D }, "Chromatics",   "Chromatics Inc" },
    { { 0x00, 0x00, 0x2E }, "SocieteEvira", "Societe Evira" },
    { { 0x00, 0x00, 0x2F }, "Timeplex",     "Timeplex Inc." },
    { { 0x00, 0x00, 0x30 }, "VgLaboratory", "Vg Laboratory Systems Ltd" },
    { { 0x00, 0x00, 0x31 }, "QpsxCommunic", "Qpsx Communications, Ltd." },
    { { 0x00, 0x00, 0x32 }, "Marconi",      "Marconi plc" },
    { { 0x00, 0x00, 0x33 }, "EganMachiner", "Egan Machinery Company" },
    { { 0x00, 0x00, 0x34 }, "NetworkResou", "Network Resources Corporation" },
    { { 0x00, 0x00, 0x35 }, "Spectragraph", "Spectragraphics Corporation" },
    { { 0x00, 0x00, 0x36 }, "Atari",        "Atari Corporation" },
    { { 0x00, 0x00, 0x37 }, "OxfordMetric", "Oxford Metrics Limited" },
    { { 0x00, 0x00, 0x38 }, "CssLabs",      "Css Labs" },
    { { 0x00, 0x00, 0x39 }, "Toshiba",      "Toshiba Corporation" },
    { { 0x00, 0x00, 0x3A }, "Chyron",       "Chyron Corporation" },
    { { 0x00, 0x00, 0x3B }, "iControls",    "i Controls, Inc." },
    { { 0x00, 0x00, 0x3C }, "Auspex",       "Auspex Systems Inc." },
    { { 0x00, 0x00, 0x3D }, "Unisys",       "Unisys" },
    { { 0x00, 0x00, 0x3E }, "Simpact",      "Simpact" },
    { { 0x00, 0x00, 0x3F }, "Syntrex",      "Syntrex, Inc." },
    { { 0x00, 0x00, 0x40 }, "Applicon",     "Applicon, Inc." },
    { { 0x00, 0x00, 0x41 }, "Ice",          "Ice Corporation" },
    { { 0x00, 0x00, 0x42 }, "MetierManage", "Metier Management Systems Ltd." },
    { { 0x00, 0x00, 0x43 }, "MicroTechnol", "Micro Technology" },
    { { 0x00, 0x00, 0x44 }, "Castelle",     "Castelle Corporation" },
    { { 0x00, 0x00, 0x45 }, "FordAerospac", "Ford Aerospace & Comm. Corp." },
    { { 0x00, 0x00, 0x46 }, "OlivettiNort", "Olivetti North America" },
    { { 0x00, 0x00, 0x47 }, "NicoletInstr", "Nicolet Instruments Corp." },
    { { 0x00, 0x00, 0x48 }, "SeikoEpson",   "Seiko Epson Corporation" },
    { { 0x00, 0x00, 0x49 }, "ApricotCompu", "Apricot Computers, Ltd" },
    { { 0x00, 0x00, 0x4A }, "AdcCodenollT", "Adc Codenoll Technology Corp." },
    { { 0x00, 0x00, 0x4B }, "IclData",      "Icl Data Oy" },
    { { 0x00, 0x00, 0x4C }, "NEC",          "NEC Corporation" },
    { { 0x00, 0x00, 0x4D }, "Dci",          "Dci Corporation" },
    { { 0x00, 0x00, 0x4E }, "Ampex",        "Ampex Corporation" },
    { { 0x00, 0x00, 0x4F }, "Logicraft",    "Logicraft, Inc." },
    { { 0x00, 0x00, 0x50 }, "Radisys",      "Radisys Corporation" },
    { { 0x00, 0x00, 0x51 }, "HobElectroni", "Hob Electronic Gmbh & Co. Kg" },
    { { 0x00, 0x00, 0x52 }, "Intrusioncom", "Intrusion.com, Inc." },
    { { 0x00, 0x00, 0x53 }, "Compucorp",    "Compucorp" },
    { { 0x00, 0x00, 0x54 }, "SchneiderEle", "Schneider Electric" },
    { { 0x00, 0x00, 0x55 }, "Commissariat", "Commissariat A L`Energie Atom." },
    { { 0x00, 0x00, 0x56 }, "DrBStruck",    "Dr. B. Struck" },
    { { 0x00, 0x00, 0x57 }, "Scitex",       "Scitex Corporation Ltd." },
    { { 0x00, 0x00, 0x58 }, "RacoreComput", "Racore Computer Products Inc." },
    { { 0x00, 0x00, 0x59 }, "Hellige",      "Hellige GMBH" },
    { { 0x00, 0x00, 0x5A }, "SysKonnect",   "SysKonnect GmbH" },
    { { 0x00, 0x00, 0x5B }, "EltecElektro", "Eltec Elektronik Ag" },
    { { 0x00, 0x00, 0x5C }, "TelematicsIn", "Telematics International Inc." },
    { { 0x00, 0x00, 0x5D }, "CsTelecom",    "Cs Telecom" },
    { { 0x00, 0x00, 0x5E }, "ICANNIANADep", "ICANN, IANA Department" },
    { { 0x00, 0x00, 0x5F }, "SumitomoElec", "Sumitomo Electric Industries, Ltd" },
    { { 0x00, 0x00, 0x60 }, "KontronEurop", "Kontron Europe GmbH" },
    { { 0x00, 0x00, 0x61 }, "GatewayCommu", "Gateway Communications" },
    { { 0x00, 0x00, 0x62 }, "BullHnInform", "Bull Hn Information Systems" },
    { { 0x00, 0x00, 0x63 }, "BarcoControl", "Barco Control Rooms Gmbh" },
    { { 0x00, 0x00, 0x64 }, "YokogawaDigi", "Yokogawa Digital Computer Corporation" },
    { { 0x00, 0x00, 0x65 }, "NetworkGener", "Network General Corporation" },
    { { 0x00, 0x00, 0x66 }, "Talaris",      "Talaris Systems, Inc." },
    { { 0x00, 0x00, 0x67 }, "Soft*Rite",    "Soft * Rite, Inc." },
    { { 0x00, 0x00, 0x68 }, "RosemountCon", "Rosemount Controls" },
    { { 0x00, 0x00, 0x69 }, "ConcordCommu", "Concord Communications Inc" },
    { { 0x00, 0x00, 0x6A }, "ComputerCons", "Computer Consoles Inc." },
    { { 0x00, 0x00, 0x6B }, "SiliconGraph", "Silicon Graphics" },
    { { 0x00, 0x00, 0x6C }, "Private",      "Private" },
    { { 0x00, 0x00, 0x6D }, "CrayCommunic", "Cray Communications, Ltd." },
    { { 0x00, 0x00, 0x6E }, "Artisoft",     "Artisoft Inc." },
    { { 0x00, 0x00, 0x6F }, "Madge",        "Madge Ltd." },
    { { 0x00, 0x00, 0x70 }, "Hcl",          "Hcl Limited" },
    { { 0x00, 0x00, 0x71 }, "Adra",         "Adra Systems Inc." },
    { { 0x00, 0x00, 0x72 }, "MiniwareTech", "Miniware Technology" },
    { { 0x00, 0x00, 0x73 }, "Siecor",       "Siecor Corporation" },
    { { 0x00, 0x00, 0x74 }, "Ricoh",        "Ricoh Company Ltd." },
    { { 0x00, 0x00, 0x75 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x00, 0x76 }, "AbekasVideoS", "Abekas Video System" },
    { { 0x00, 0x00, 0x77 }, "Interphase",   "Interphase Corporation" },
    { { 0x00, 0x00, 0x78 }, "Labtam",       "Labtam Limited" },
    { { 0x00, 0x00, 0x79 }, "Networth",     "Networth Incorporated" },
    { { 0x00, 0x00, 0x7A }, "DanaComputer", "Dana Computer Inc." },
    { { 0x00, 0x00, 0x7B }, "ResearchMach", "Research Machines" },
    { { 0x00, 0x00, 0x7C }, "Ampere",       "Ampere Incorporated" },
    { { 0x00, 0x00, 0x7D }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x00, 0x7E }, "Clustrix",     "Clustrix Corporation" },
    { { 0x00, 0x00, 0x7F }, "LinotypeHell", "Linotype-Hell Ag" },
    { { 0x00, 0x00, 0x80 }, "CrayCommunic", "Cray Communications A/S" },
    { { 0x00, 0x00, 0x81 }, "BayNetworks",  "Bay Networks" },
    { { 0x00, 0x00, 0x82 }, "LectraSystem", "Lectra Systemes Sa" },
    { { 0x00, 0x00, 0x83 }, "TadpoleTechn", "Tadpole Technology Plc" },
    { { 0x00, 0x00, 0x84 }, "Supernet",     "Supernet" },
    { { 0x00, 0x00, 0x85 }, "Canon",        "Canon Inc." },
    { { 0x00, 0x00, 0x86 }, "Megahertz",    "Megahertz Corporation" },
    { { 0x00, 0x00, 0x87 }, "Hitachi",      "Hitachi, Ltd." },
    { { 0x00, 0x00, 0x88 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x00, 0x89 }, "Cayman",       "Cayman Systems Inc." },
    { { 0x00, 0x00, 0x8A }, "DatahouseInf", "Datahouse Information Systems" },
    { { 0x00, 0x00, 0x8B }, "Infotron",     "Infotron" },
    { { 0x00, 0x00, 0x8C }, "AlloyCompute", "Alloy Computer Products (Australia) Pty Ltd" },
    { { 0x00, 0x00, 0x8D }, "Cryptek",      "Cryptek Inc." },
    { { 0x00, 0x00, 0x8E }, "SolbourneCom", "Solbourne Computer, Inc." },
    { { 0x00, 0x00, 0x8F }, "Raytheon",     "Raytheon" },
    { { 0x00, 0x00, 0x90 }, "Microcom",     "Microcom" },
    { { 0x00, 0x00, 0x91 }, "Anritsu",      "Anritsu Corporation" },
    { { 0x00, 0x00, 0x92 }, "CogentDataTe", "Cogent Data Technologies" },
    { { 0x00, 0x00, 0x93 }, "Proteon",      "Proteon Inc." },
    { { 0x00, 0x00, 0x94 }, "AsanteTechno", "Asante Technologies" },
    { { 0x00, 0x00, 0x95 }, "SonyTektroni", "Sony Tektronix Corp." },
    { { 0x00, 0x00, 0x96 }, "MarconiElect", "Marconi Electronics Ltd." },
    { { 0x00, 0x00, 0x97 }, "DellEMC",      "Dell EMC" },
    { { 0x00, 0x00, 0x98 }, "Crosscomm",    "Crosscomm Corporation" },
    { { 0x00, 0x00, 0x99 }, "Mtx",          "Mtx, Inc." },
    { { 0x00, 0x00, 0x9A }, "RcComputer",   "Rc Computer A/S" },
    { { 0x00, 0x00, 0x9B }, "InformationI", "Information International, Inc" },
    { { 0x00, 0x00, 0x9C }, "RolmMilSpecC", "Rolm Mil-Spec Computers" },
    { { 0x00, 0x00, 0x9D }, "LocusComputi", "Locus Computing Corporation" },
    { { 0x00, 0x00, 0x9E }, "Marli",        "Marli S.A." },
    { { 0x00, 0x00, 0x9F }, "AmeristarTec", "Ameristar Technologies Inc." },
    { { 0x00, 0x00, 0xA0 }, "SANYOElectri", "SANYO Electric Co., Ltd." },
    { { 0x00, 0x00, 0xA1 }, "MarquetteEle", "Marquette Electric Co." },
    { { 0x00, 0x00, 0xA2 }, "BayNetworks",  "Bay Networks" },
    { { 0x00, 0x00, 0xA3 }, "NetworkAppli", "Network Application Technology" },
    { { 0x00, 0x00, 0xA4 }, "AcornCompute", "Acorn Computers Limited" },
    { { 0x00, 0x00, 0xA5 }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x00, 0xA6 }, "NetworkGener", "Network General Corporation" },
    { { 0x00, 0x00, 0xA7 }, "NetworkCompu", "Network Computing Devices Inc." },
    { { 0x00, 0x00, 0xA8 }, "StratusTechn", "Stratus Technologies" },
    { { 0x00, 0x00, 0xA9 }, "Network",      "Network Systems Corp." },
    { { 0x00, 0x00, 0xAA }, "Xerox",        "Xerox Corporation" },
    { { 0x00, 0x00, 0xAB }, "LogicModelin", "Logic Modeling Corporation" },
    { { 0x00, 0x00, 0xAC }, "ConwareCompu", "Conware Computer Consulting" },
    { { 0x00, 0x00, 0xAD }, "BrukerInstru", "Bruker Instruments Inc." },
    { { 0x00, 0x00, 0xAE }, "DassaultElec", "Dassault Electronique" },
    { { 0x00, 0x00, 0xAF }, "CanberraIndu", "Canberra Industries, Inc." },
    { { 0x00, 0x00, 0xB0 }, "RndRadNetwor", "Rnd-Rad Network Devices" },
    { { 0x00, 0x00, 0xB1 }, "AlphaMicro",   "Alpha Micro" },
    { { 0x00, 0x00, 0xB2 }, "Televideo",    "Televideo Systems, Inc." },
    { { 0x00, 0x00, 0xB3 }, "Cimlinc",      "Cimlinc Incorporated" },
    { { 0x00, 0x00, 0xB4 }, "EdimaxTechno", "Edimax Technology Co. Ltd." },
    { { 0x00, 0x00, 0xB5 }, "DatabilitySo", "Datability Software Sys. Inc." },
    { { 0x00, 0x00, 0xB6 }, "MicroMaticRe", "Micro-Matic Research" },
    { { 0x00, 0x00, 0xB7 }, "DoveComputer", "Dove Computer Corporation" },
    { { 0x00, 0x00, 0xB8 }, "Seikosha",     "Seikosha Co., Ltd." },
    { { 0x00, 0x00, 0xB9 }, "McdonnellDou", "Mcdonnell Douglas Computer Sys" },
    { { 0x00, 0x00, 0xBA }, "Siig",         "Siig, Inc." },
    { { 0x00, 0x00, 0xBB }, "TriData",      "Tri-Data" },
    { { 0x00, 0x00, 0xBC }, "RockwellAuto", "Rockwell Automation" },
    { { 0x00, 0x00, 0xBD }, "RYOSEI",       "RYOSEI, Ltd." },
    { { 0x00, 0x00, 0xBE }, "NtiGroup",     "The Nti Group" },
    { { 0x00, 0x00, 0xBF }, "SymmetricCom", "Symmetric Computer Systems" },
    { { 0x00, 0x00, 0xC0 }, "WesternDigit", "Western Digital Corporation" },
    { { 0x00, 0x00, 0xC1 }, "Madge",        "Madge Ltd." },
    { { 0x00, 0x00, 0xC2 }, "InformationP", "Information Presentation Tech." },
    { { 0x00, 0x00, 0xC3 }, "Harris",       "Harris Corporation" },
    { { 0x00, 0x00, 0xC4 }, "WatersDivMil", "Waters Div. Of Millipore" },
    { { 0x00, 0x00, 0xC5 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x00, 0xC6 }, "Eon",          "Eon Systems" },
    { { 0x00, 0x00, 0xC7 }, "Arix",         "Arix Corporation" },
    { { 0x00, 0x00, 0xC8 }, "AltosCompute", "Altos Computer Systems" },
    { { 0x00, 0x00, 0xC9 }, "Emulex",       "Emulex Corporation" },
    { { 0x00, 0x00, 0xCA }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x00, 0xCB }, "CompuShackEl", "Compu-Shack Electronic Gmbh" },
    { { 0x00, 0x00, 0xCC }, "Densan",       "Densan Co., Ltd." },
    { { 0x00, 0x00, 0xCD }, "AlliedTelesi", "Allied Telesis Labs Ltd" },
    { { 0x00, 0x00, 0xCE }, "Megadata",     "Megadata Corp." },
    { { 0x00, 0x00, 0xCF }, "HayesMicroco", "Hayes Microcomputer Products" },
    { { 0x00, 0x00, 0xD0 }, "DevelconElec", "Develcon Electronics Ltd." },
    { { 0x00, 0x00, 0xD1 }, "Adaptec",      "Adaptec Incorporated" },
    { { 0x00, 0x00, 0xD2 }, "Sbe",          "Sbe, Inc." },
    { { 0x00, 0x00, 0xD3 }, "WangLaborato", "Wang Laboratories Inc." },
    { { 0x00, 0x00, 0xD4 }, "PureData",     "Pure Data Ltd." },
    { { 0x00, 0x00, 0xD5 }, "MicrognosisI", "Micrognosis International" },
    { { 0x00, 0x00, 0xD6 }, "PunchLine",    "Punch Line Holding" },
    { { 0x00, 0x00, 0xD7 }, "DartmouthCol", "Dartmouth College" },
    { { 0x00, 0x00, 0xD8 }, "Novell",       "Novell, Inc." },
    { { 0x00, 0x00, 0xD9 }, "NipponTelegr", "Nippon Telegraph & Telephone" },
    { { 0x00, 0x00, 0xDA }, "Atex",         "Atex" },
    { { 0x00, 0x00, 0xDB }, "BritishTelec", "British Telecommunications plc" },
    { { 0x00, 0x00, 0xDC }, "HayesMicroco", "Hayes Microcomputer Products" },
    { { 0x00, 0x00, 0xDD }, "Tcl",          "Tcl Incorporated" },
    { { 0x00, 0x00, 0xDE }, "Cetia",        "Cetia" },
    { { 0x00, 0x00, 0xDF }, "BellHowellPu", "Bell & Howell Pub Sys Div" },
    { { 0x00, 0x00, 0xE0 }, "Quadram",      "Quadram Corp." },
    { { 0x00, 0x00, 0xE1 }, "Grid",         "Grid Systems" },
    { { 0x00, 0x00, 0xE2 }, "AcerTechnolo", "Acer Technologies Corp." },
    { { 0x00, 0x00, 0xE3 }, "IntegratedMi", "Integrated Micro Products Ltd" },
    { { 0x00, 0x00, 0xE4 }, "In2GroupeInt", "In2 Groupe Intertechnique" },
    { { 0x00, 0x00, 0xE5 }, "Sigmex",       "Sigmex Ltd." },
    { { 0x00, 0x00, 0xE6 }, "AptorProduit", "Aptor Produits De Comm Indust" },
    { { 0x00, 0x00, 0xE7 }, "StarGateTech", "Star Gate Technologies" },
    { { 0x00, 0x00, 0xE8 }, "AcctonTechno", "Accton Technology Corp." },
    { { 0x00, 0x00, 0xE9 }, "Isicad",       "Isicad, Inc." },
    { { 0x00, 0x00, 0xEA }, "Upnod",        "Upnod Ab" },
    { { 0x00, 0x00, 0xEB }, "MatsushitaCo", "Matsushita Comm. Ind. Co. Ltd." },
    { { 0x00, 0x00, 0xEC }, "Microprocess", "Microprocess" },
    { { 0x00, 0x00, 0xED }, "April",        "April" },
    { { 0x00, 0x00, 0xEE }, "NetworkDesig", "Network Designers, Ltd." },
    { { 0x00, 0x00, 0xEF }, "Kti",          "Kti" },
    { { 0x00, 0x00, 0xF0 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x00, 0xF1 }, "MagnaCompute", "Magna Computer Corporation" },
    { { 0x00, 0x00, 0xF2 }, "SpiderCommun", "Spider Communications" },
    { { 0x00, 0x00, 0xF3 }, "GandalfData",  "Gandalf Data Limited" },
    { { 0x00, 0x00, 0xF4 }, "AlliedTelesi", "Allied Telesis, Inc." },
    { { 0x00, 0x00, 0xF5 }, "DiamondSales", "Diamond Sales Limited" },
    { { 0x00, 0x00, 0xF6 }, "AppliedMicro", "Applied Microsystems Corp." },
    { { 0x00, 0x00, 0xF7 }, "YouthKeepEnt", "Youth Keep Enterprise Co Ltd" },
    { { 0x00, 0x00, 0xF8 }, "DigitalEquip", "Digital Equipment Corporation" },
    { { 0x00, 0x00, 0xF9 }, "Quotron",      "Quotron Systems Inc." },
    { { 0x00, 0x00, 0xFA }, "MicrosageCom", "Microsage Computer Systems Inc" },
    { { 0x00, 0x00, 0xFB }, "RechnerZurKo", "Rechner Zur Kommunikation" },
    { { 0x00, 0x00, 0xFC }, "Meiko",        "Meiko" },
    { { 0x00, 0x00, 0xFD }, "HighLevelHar", "High Level Hardware" },
    { { 0x00, 0x00, 0xFE }, "AnnapolisMic", "Annapolis Micro Systems, Inc." },
    { { 0x00, 0x00, 0xFF }, "CamtecElectr", "Camtec Electronics Ltd." },
    { { 0x00, 0x01, 0x00 }, "EquipTrans",   "Equip'Trans" },
    { { 0x00, 0x01, 0x01 }, "Private",      "Private" },
    { { 0x00, 0x01, 0x02 }, "3Com",         "3Com" },
    { { 0x00, 0x01, 0x03 }, "3Com",         "3Com" },
    { { 0x00, 0x01, 0x04 }, "DVICO",        "DVICO Co., Ltd." },
    { { 0x00, 0x01, 0x05 }, "BeckhoffAuto", "Beckhoff Automation GmbH" },
    { { 0x00, 0x01, 0x06 }, "TewsDatentec", "Tews Datentechnik GmbH" },
    { { 0x00, 0x01, 0x07 }, "Leiser",       "Leiser GmbH" },
    { { 0x00, 0x01, 0x08 }, "AVLABTechnol", "AVLAB Technology, Inc." },
    { { 0x00, 0x01, 0x09 }, "NaganoJapanR", "Nagano Japan Radio Co., Ltd." },
    { { 0x00, 0x01, 0x0A }, "CisTechnolog", "Cis Technology Inc." },
    { { 0x00, 0x01, 0x0B }, "SpaceCyberLi", "Space CyberLink, Inc." },
    { { 0x00, 0x01, 0x0C }, "SystemTalks",  "System Talks Inc." },
    { { 0x00, 0x01, 0x0D }, "TeledyneDALS", "Teledyne DALSA Inc." },
    { { 0x00, 0x01, 0x0E }, "BriLinkTechn", "Bri-Link Technologies Co., Ltd" },
    { { 0x00, 0x01, 0x0F }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x01, 0x10 }, "GothamNetwor", "Gotham Networks" },
    { { 0x00, 0x01, 0x11 }, "iDigm",        "iDigm Inc." },
    { { 0x00, 0x01, 0x12 }, "SharkMultime", "Shark Multimedia Inc." },
    { { 0x00, 0x01, 0x13 }, "Olympus",      "Olympus Corporation" },
    { { 0x00, 0x01, 0x14 }, "KandaTsushin", "Kanda Tsushin Kogyo Co., Ltd." },
    { { 0x00, 0x01, 0x15 }, "Extratech",    "Extratech Corporation" },
    { { 0x00, 0x01, 0x16 }, "NetspectTech", "Netspect Technologies, Inc." },
    { { 0x00, 0x01, 0x17 }, "Canal",        "Canal +" },
    { { 0x00, 0x01, 0x18 }, "EZDigital",    "EZ Digital Co., Ltd." },
    { { 0x00, 0x01, 0x19 }, "RTUnet",       "RTUnet (Australia)" },
    { { 0x00, 0x01, 0x1A }, "HoffmannundB", "Hoffmann und Burmeister GbR" },
    { { 0x00, 0x01, 0x1B }, "UnizoneTechn", "Unizone Technologies, Inc." },
    { { 0x00, 0x01, 0x1C }, "UniversalTal", "Universal Talkware Corporation" },
    { { 0x00, 0x01, 0x1D }, "CentilliumCo", "Centillium Communications" },
    { { 0x00, 0x01, 0x1E }, "PrecidiaTech", "Precidia Technologies, Inc." },
    { { 0x00, 0x01, 0x1F }, "RCNetworks",   "RC Networks, Inc." },
    { { 0x00, 0x01, 0x20 }, "Oscilloquart", "Oscilloquartz S.A." },
    { { 0x00, 0x01, 0x21 }, "WatchGuardTe", "WatchGuard Technologies, Inc." },
    { { 0x00, 0x01, 0x22 }, "TrendCommuni", "Trend Communications, Ltd." },
    { { 0x00, 0x01, 0x23 }, "SchneiderEle", "Schneider Electric Japan Holdings Ltd." },
    { { 0x00, 0x01, 0x24 }, "Acer",         "Acer Incorporated" },
    { { 0x00, 0x01, 0x25 }, "YaesuMusen",   "Yaesu Musen Co., Ltd." },
    { { 0x00, 0x01, 0x26 }, "PACLabs",      "PAC Labs" },
    { { 0x00, 0x01, 0x27 }, "OPENNetworks", "OPEN Networks Pty Ltd" },
    { { 0x00, 0x01, 0x28 }, "EnjoyWeb",     "EnjoyWeb, Inc." },
    { { 0x00, 0x01, 0x29 }, "DFI",          "DFI Inc." },
    { { 0x00, 0x01, 0x2A }, "TelematicaSi", "Telematica Sistems Inteligente" },
    { { 0x00, 0x01, 0x2B }, "TELENET",      "TELENET Co., Ltd." },
    { { 0x00, 0x01, 0x2C }, "AravoxTechno", "Aravox Technologies, Inc." },
    { { 0x00, 0x01, 0x2D }, "KomodoTechno", "Komodo Technology" },
    { { 0x00, 0x01, 0x2E }, "PCPartner",    "PC Partner Ltd." },
    { { 0x00, 0x01, 0x2F }, "TwinheadInte", "Twinhead International Corp" },
    { { 0x00, 0x01, 0x30 }, "ExtremeNetwo", "Extreme Networks Headquarters" },
    { { 0x00, 0x01, 0x31 }, "BoschSecurit", "Bosch Security Systems, Inc." },
    { { 0x00, 0x01, 0x32 }, "DranetzBMI",   "Dranetz - BMI" },
    { { 0x00, 0x01, 0x33 }, "KYOWAElectro", "KYOWA Electronic Instruments C" },
    { { 0x00, 0x01, 0x34 }, "Selectron",    "Selectron Systems AG" },
    { { 0x00, 0x01, 0x35 }, "KDC",          "KDC Corp." },
    { { 0x00, 0x01, 0x36 }, "CyberTANTech", "CyberTAN Technology Inc." },
    { { 0x00, 0x01, 0x37 }, "ITFarm",       "IT Farm Corporation" },
    { { 0x00, 0x01, 0x38 }, "XAViTechnolo", "XAVi Technologies Corp." },
    { { 0x00, 0x01, 0x39 }, "PointMultime", "Point Multimedia Systems" },
    { { 0x00, 0x01, 0x3A }, "ShelcadCommu", "Shelcad Communications, Ltd." },
    { { 0x00, 0x01, 0x3B }, "Bna",          "Bna Systems" },
    { { 0x00, 0x01, 0x3C }, "Tiw",          "Tiw Systems" },
    { { 0x00, 0x01, 0x3D }, "RiscStation",  "RiscStation Ltd." },
    { { 0x00, 0x01, 0x3E }, "AscomTateco",  "Ascom Tateco AB" },
    { { 0x00, 0x01, 0x3F }, "NeighborWorl", "Neighbor World Co., Ltd." },
    { { 0x00, 0x01, 0x40 }, "Sendtek",      "Sendtek Corporation" },
    { { 0x00, 0x01, 0x41 }, "CablePrint",   "Cable Print" },
    { { 0x00, 0x01, 0x42 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0x43 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0x44 }, "DellEMC",      "Dell EMC" },
    { { 0x00, 0x01, 0x45 }, "Winsystems",   "Winsystems, Inc." },
    { { 0x00, 0x01, 0x46 }, "TescoControl", "Tesco Controls, Inc." },
    { { 0x00, 0x01, 0x47 }, "DZS",          "DZS Inc." },
    { { 0x00, 0x01, 0x48 }, "XtraWeb",      "X-traWeb Inc." },
    { { 0x00, 0x01, 0x49 }, "Tdt",          "Tdt Ag" },
    { { 0x00, 0x01, 0x4A }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x01, 0x4B }, "EnnovateNetw", "Ennovate Networks, Inc." },
    { { 0x00, 0x01, 0x4C }, "BerkeleyProc", "Berkeley Process Control" },
    { { 0x00, 0x01, 0x4D }, "ShinKinEnter", "Shin Kin Enterprises Co., Ltd" },
    { { 0x00, 0x01, 0x4E }, "WINEnterpris", "WIN Enterprises, Inc." },
    { { 0x00, 0x01, 0x4F }, "Adtran",       "Adtran Inc" },
    { { 0x00, 0x01, 0x50 }, "GilatCommuni", "Gilat Communications, Ltd." },
    { { 0x00, 0x01, 0x51 }, "EnsembleComm", "Ensemble Communications" },
    { { 0x00, 0x01, 0x52 }, "Chromatek",    "Chromatek Inc." },
    { { 0x00, 0x01, 0x53 }, "ArchtekTelec", "Archtek Telecom Corporation" },
    { { 0x00, 0x01, 0x54 }, "G3M",          "G3M Corporation" },
    { { 0x00, 0x01, 0x55 }, "PromiseTechn", "Promise Technology, Inc." },
    { { 0x00, 0x01, 0x56 }, "Firewiredire", "Firewiredirect.Com, Inc." },
    { { 0x00, 0x01, 0x57 }, "Syswave",      "Syswave Co., Ltd" },
    { { 0x00, 0x01, 0x58 }, "ElectroIndus", "Electro Industries/Gauge Tech" },
    { { 0x00, 0x01, 0x59 }, "S1",           "S1 Corporation" },
    { { 0x00, 0x01, 0x5A }, "DigitalVideo", "Digital Video Broadcasting" },
    { { 0x00, 0x01, 0x5B }, "ITALTELRFUPI", "ITALTEL S.p.A/RF-UP-I" },
    { { 0x00, 0x01, 0x5C }, "Cadant",       "Cadant Inc." },
    { { 0x00, 0x01, 0x5D }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x01, 0x5E }, "BestTechnolo", "Best Technology Co., Ltd." },
    { { 0x00, 0x01, 0x5F }, "DIGITALDESIG", "DIGITAL DESIGN GmbH" },
    { { 0x00, 0x01, 0x60 }, "ELMEX",        "ELMEX Co., LTD." },
    { { 0x00, 0x01, 0x61 }, "MetaMachineT", "Meta Machine Technology" },
    { { 0x00, 0x01, 0x62 }, "CygnetTechno", "Cygnet Technologies, Inc." },
    { { 0x00, 0x01, 0x63 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0x64 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0x65 }, "AirSwitch",    "AirSwitch Corporation" },
    { { 0x00, 0x01, 0x66 }, "TcGroup",      "Tc Group A/S" },
    { { 0x00, 0x01, 0x67 }, "HiokiEE",      "Hioki E.E. Corporation" },
    { { 0x00, 0x01, 0x68 }, "Vitana",       "Vitana Corporation" },
    { { 0x00, 0x01, 0x69 }, "CelestixNetw", "Celestix Networks Pte Ltd." },
    { { 0x00, 0x01, 0x6A }, "Alitec",       "Alitec" },
    { { 0x00, 0x01, 0x6B }, "LightChip",    "LightChip, Inc." },
    { { 0x00, 0x01, 0x6C }, "Foxconn",      "Foxconn" },
    { { 0x00, 0x01, 0x6D }, "CarrierComm",  "CarrierComm Inc." },
    { { 0x00, 0x01, 0x6E }, "Conklin",      "Conklin Corporation" },
    { { 0x00, 0x01, 0x6F }, "Inkel",        "Inkel Corp." },
    { { 0x00, 0x01, 0x70 }, "ESEEmbeddedS", "ESE Embedded System Engineer'g" },
    { { 0x00, 0x01, 0x71 }, "AlliedDataTe", "Allied Data Technologies" },
    { { 0x00, 0x01, 0x72 }, "TechnoLand",   "TechnoLand Co., LTD." },
    { { 0x00, 0x01, 0x73 }, "Amcc",         "Amcc" },
    { { 0x00, 0x01, 0x74 }, "CyberOptics",  "CyberOptics Corporation" },
    { { 0x00, 0x01, 0x75 }, "RadiantCommu", "Radiant Communications Corp." },
    { { 0x00, 0x01, 0x76 }, "OrientSilver", "Orient Silver Enterprises" },
    { { 0x00, 0x01, 0x77 }, "Edsl",         "Edsl" },
    { { 0x00, 0x01, 0x78 }, "MARGI",        "MARGI Systems, Inc." },
    { { 0x00, 0x01, 0x79 }, "WirelessTech", "Wireless Technology, Inc." },
    { { 0x00, 0x01, 0x7A }, "MaipuElectri", "Chengdu Maipu Electric Industrial Co., Ltd." },
    { { 0x00, 0x01, 0x7B }, "Heidelberger", "Heidelberger Druckmaschinen AG" },
    { { 0x00, 0x01, 0x7C }, "AGE",          "AG-E GmbH" },
    { { 0x00, 0x01, 0x7D }, "ThermoQuest",  "ThermoQuest" },
    { { 0x00, 0x01, 0x7E }, "ADTEKSystemS", "ADTEK System Science Co., Ltd." },
    { { 0x00, 0x01, 0x7F }, "ExperienceMu", "Experience Music Project" },
    { { 0x00, 0x01, 0x80 }, "AOpen",        "AOpen, Inc." },
    { { 0x00, 0x01, 0x81 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x01, 0x82 }, "DicaTechnolo", "Dica Technologies Ag" },
    { { 0x00, 0x01, 0x83 }, "AniteTelecom", "Anite Telecoms" },
    { { 0x00, 0x01, 0x84 }, "SiebMeyer",    "Sieb & Meyer Ag" },
    { { 0x00, 0x01, 0x85 }, "HitachiAloka", "Hitachi Aloka Medical, Ltd." },
    { { 0x00, 0x01, 0x86 }, "UweDisch",     "Uwe Disch" },
    { { 0x00, 0x01, 0x87 }, "I2SE",         "I2SE GmbH" },
    { { 0x00, 0x01, 0x88 }, "LXCOTechnolo", "LXCO Technologies ag" },
    { { 0x00, 0x01, 0x89 }, "RefractionTe", "Refraction Technology, Inc." },
    { { 0x00, 0x01, 0x8A }, "RoiComputer",  "Roi Computer Ag" },
    { { 0x00, 0x01, 0x8B }, "NetLinks",     "NetLinks Co., Ltd." },
    { { 0x00, 0x01, 0x8C }, "MegaVision",   "Mega Vision" },
    { { 0x00, 0x01, 0x8D }, "AudeSiTechno", "AudeSi Technologies" },
    { { 0x00, 0x01, 0x8E }, "Logitec",      "Logitec Corporation" },
    { { 0x00, 0x01, 0x8F }, "Kenetec",      "Kenetec, Inc." },
    { { 0x00, 0x01, 0x90 }, "SmkM",         "Smk-M" },
    { { 0x00, 0x01, 0x91 }, "SYREDData",    "SYRED Data Systems" },
    { { 0x00, 0x01, 0x92 }, "TexasDigital", "Texas Digital Systems" },
    { { 0x00, 0x01, 0x93 }, "HanbyulTelec", "Hanbyul Telecom Co., Ltd." },
    { { 0x00, 0x01, 0x94 }, "CapitalEquip", "Capital Equipment Corporation" },
    { { 0x00, 0x01, 0x95 }, "SenaTechnolo", "Sena Technologies, Inc." },
    { { 0x00, 0x01, 0x96 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0x97 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0x98 }, "DarimVision",  "Darim Vision" },
    { { 0x00, 0x01, 0x99 }, "HeiSeiElectr", "HeiSei Electronics" },
    { { 0x00, 0x01, 0x9A }, "LEUNIG",       "LEUNIG GmbH" },
    { { 0x00, 0x01, 0x9B }, "KyotoMicroco", "Kyoto Microcomputer Co., Ltd." },
    { { 0x00, 0x01, 0x9C }, "Lumentum",     "Lumentum" },
    { { 0x00, 0x01, 0x9D }, "EControl",     "E-Control Systems, Inc." },
    { { 0x00, 0x01, 0x9E }, "ESSTechnolog", "ESS Technology, Inc." },
    { { 0x00, 0x01, 0x9F }, "ReadyNet",     "ReadyNet" },
    { { 0x00, 0x01, 0xA0 }, "Infinilink",   "Infinilink Corporation" },
    { { 0x00, 0x01, 0xA1 }, "MagTek",       "Mag-Tek, Inc." },
    { { 0x00, 0x01, 0xA2 }, "Logical",      "Logical Co., Ltd." },
    { { 0x00, 0x01, 0xA3 }, "GenesysLogic", "Genesys Logic, Inc." },
    { { 0x00, 0x01, 0xA4 }, "Microlink",    "Microlink Corporation" },
    { { 0x00, 0x01, 0xA5 }, "Nextcomm",     "Nextcomm, Inc." },
    { { 0x00, 0x01, 0xA6 }, "ScientificAt", "Scientific-Atlanta Arcodan A/S" },
    { { 0x00, 0x01, 0xA7 }, "UnexTechnolo", "Unex Technology Corporation" },
    { { 0x00, 0x01, 0xA8 }, "WelltechComp", "Welltech Computer Co., Ltd." },
    { { 0x00, 0x01, 0xA9 }, "Bmw",          "Bmw Ag" },
    { { 0x00, 0x01, 0xAA }, "AirspanCommu", "Airspan Communications, Ltd." },
    { { 0x00, 0x01, 0xAB }, "MainStreetNe", "Main Street Networks" },
    { { 0x00, 0x01, 0xAC }, "SitaraNetwor", "Sitara Networks, Inc." },
    { { 0x00, 0x01, 0xAD }, "CoachMasterI", "Coach Master International d.b.a. CMI Worldwide, Inc." },
    { { 0x00, 0x01, 0xAE }, "TrexEnterpri", "Trex Enterprises" },
    { { 0x00, 0x01, 0xAF }, "ArtesynEmbed", "Artesyn Embedded Technologies" },
    { { 0x00, 0x01, 0xB0 }, "FulltekTechn", "Fulltek Technology Co., Ltd." },
    { { 0x00, 0x01, 0xB1 }, "GeneralBandw", "General Bandwidth" },
    { { 0x00, 0x01, 0xB2 }, "DigitalProce", "Digital Processing Systems, Inc." },
    { { 0x00, 0x01, 0xB3 }, "PrecisionEle", "Precision Electronic Manufacturing" },
    { { 0x00, 0x01, 0xB4 }, "Wayport",      "Wayport, Inc." },
    { { 0x00, 0x01, 0xB5 }, "TurinNetwork", "Turin Networks, Inc." },
    { { 0x00, 0x01, 0xB6 }, "SAEJINT&M",    "SAEJIN T&M Co., Ltd." },
    { { 0x00, 0x01, 0xB7 }, "Centos",       "Centos, Inc." },
    { { 0x00, 0x01, 0xB8 }, "Netsensity",   "Netsensity, Inc." },
    { { 0x00, 0x01, 0xB9 }, "SKF",          "SKF (U.K.) Limited" },
    { { 0x00, 0x01, 0xBA }, "ICNet",        "IC-Net, Inc." },
    { { 0x00, 0x01, 0xBB }, "Frequentis",   "Frequentis" },
    { { 0x00, 0x01, 0xBC }, "Brains",       "Brains Corporation" },
    { { 0x00, 0x01, 0xBD }, "PetersonElec", "Peterson Electro-Musical Products, Inc." },
    { { 0x00, 0x01, 0xBE }, "Gigalink",     "Gigalink Co., Ltd." },
    { { 0x00, 0x01, 0xBF }, "Teleforce",    "Teleforce Co., Ltd." },
    { { 0x00, 0x01, 0xC0 }, "CompuLab",     "CompuLab, Ltd." },
    { { 0x00, 0x01, 0xC1 }, "VitesseSemic", "Vitesse Semiconductor Corporation" },
    { { 0x00, 0x01, 0xC2 }, "ARKResearch",  "ARK Research Corp." },
    { { 0x00, 0x01, 0xC3 }, "Acromag",      "Acromag, Inc." },
    { { 0x00, 0x01, 0xC4 }, "NeoWave",      "NeoWave, Inc." },
    { { 0x00, 0x01, 0xC5 }, "SimplerNetwo", "Simpler Networks" },
    { { 0x00, 0x01, 0xC6 }, "QuarryTechno", "Quarry Technologies" },
    { { 0x00, 0x01, 0xC7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0xC8 }, "ThomasConrad", "Thomas Conrad Corp." },
    { { 0x00, 0x01, 0xC9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x01, 0xCA }, "GeocastNetwo", "Geocast Network Systems, Inc." },
    { { 0x00, 0x01, 0xCB }, "Evr",          "Evr" },
    { { 0x00, 0x01, 0xCC }, "JapanTotalDe", "Japan Total Design Communication Co., Ltd." },
    { { 0x00, 0x01, 0xCD }, "ARtem",        "ARtem" },
    { { 0x00, 0x01, 0xCE }, "CustomMicroP", "Custom Micro Products, Ltd." },
    { { 0x00, 0x01, 0xCF }, "AlphaDataPar", "Alpha Data Parallel Systems, Ltd." },
    { { 0x00, 0x01, 0xD0 }, "VitalPoint",   "VitalPoint, Inc." },
    { { 0x00, 0x01, 0xD1 }, "CoNetCommuni", "CoNet Communications, Inc." },
    { { 0x00, 0x01, 0xD2 }, "inXtron",      "inXtron, Inc." },
    { { 0x00, 0x01, 0xD3 }, "PAXCOMM",      "PAXCOMM, Inc." },
    { { 0x00, 0x01, 0xD4 }, "LeisureTime",  "Leisure Time, Inc." },
    { { 0x00, 0x01, 0xD5 }, "HaedongInfoC", "Haedong Info & Comm Co., Ltd" },
    { { 0x00, 0x01, 0xD6 }, "manroland",    "manroland AG" },
    { { 0x00, 0x01, 0xD7 }, "F5Networks",   "F5 Networks, Inc." },
    { { 0x00, 0x01, 0xD8 }, "Teltronics",   "Teltronics, Inc." },
    { { 0x00, 0x01, 0xD9 }, "Sigma",        "Sigma, Inc." },
    { { 0x00, 0x01, 0xDA }, "WINCOMM",      "WINCOMM Corporation" },
    { { 0x00, 0x01, 0xDB }, "FreecomTechn", "Freecom Technologies GmbH" },
    { { 0x00, 0x01, 0xDC }, "Activetelco",  "Activetelco" },
    { { 0x00, 0x01, 0xDD }, "AvailNetwork", "Avail Networks" },
    { { 0x00, 0x01, 0xDE }, "Trango",       "Trango Systems, Inc." },
    { { 0x00, 0x01, 0xDF }, "ISDNCommunic", "ISDN Communications, Ltd." },
    { { 0x00, 0x01, 0xE0 }, "Fast",         "Fast Systems, Inc." },
    { { 0x00, 0x01, 0xE1 }, "KinpoElectro", "Kinpo Electronics, Inc." },
    { { 0x00, 0x01, 0xE2 }, "AndoElectric", "Ando Electric Corporation" },
    { { 0x00, 0x01, 0xE3 }, "Siemens",      "Siemens AG" },
    { { 0x00, 0x01, 0xE4 }, "Sitera",       "Sitera, Inc." },
    { { 0x00, 0x01, 0xE5 }, "Supernet",     "Supernet, Inc." },
    { { 0x00, 0x01, 0xE6 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x01, 0xE7 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x01, 0xE8 }, "Force10Netwo", "Force10 Networks, Inc." },
    { { 0x00, 0x01, 0xE9 }, "LittonMarine", "Litton Marine Systems B.V." },
    { { 0x00, 0x01, 0xEA }, "Cirilium",     "Cirilium Corp." },
    { { 0x00, 0x01, 0xEB }, "CCOM",         "C-COM Corporation" },
    { { 0x00, 0x01, 0xEC }, "EricssonGrou", "Ericsson Group" },
    { { 0x00, 0x01, 0xED }, "SETA",         "SETA Corp." },
    { { 0x00, 0x01, 0xEE }, "ComtrolEurop", "Comtrol Europe, Ltd." },
    { { 0x00, 0x01, 0xEF }, "CamtelTechno", "Camtel Technology Corp." },
    { { 0x00, 0x01, 0xF0 }, "Tridium",      "Tridium, Inc." },
    { { 0x00, 0x01, 0xF1 }, "InnovativeCo", "Innovative Concepts, Inc." },
    { { 0x00, 0x01, 0xF2 }, "MarkUnicorn",  "Mark of the Unicorn, Inc." },
    { { 0x00, 0x01, 0xF3 }, "QPS",          "QPS, Inc." },
    { { 0x00, 0x01, 0xF4 }, "Enterasys",    "Enterasys" },
    { { 0x00, 0x01, 0xF5 }, "Erim",         "Erim S.A." },
    { { 0x00, 0x01, 0xF6 }, "AssociationM", "Association of Musical Electronics Industry" },
    { { 0x00, 0x01, 0xF7 }, "ImageDisplay", "Image Display Systems, Inc." },
    { { 0x00, 0x01, 0xF8 }, "TexioTechnol", "Texio Technology Corporation" },
    { { 0x00, 0x01, 0xF9 }, "TeraGlobalCo", "TeraGlobal Communications Corp." },
    { { 0x00, 0x01, 0xFA }, "Horoscas",     "Horoscas" },
    { { 0x00, 0x01, 0xFB }, "DoTopTechnol", "DoTop Technology, Inc." },
    { { 0x00, 0x01, 0xFC }, "Keyence",      "Keyence Corporation" },
    { { 0x00, 0x01, 0xFD }, "DigitalVoice", "Digital Voice Systems, Inc." },
    { { 0x00, 0x01, 0xFE }, "DigitalEquip", "Digital Equipment Corporation" },
    { { 0x00, 0x01, 0xFF }, "DataDirectNe", "Data Direct Networks, Inc." },
    { { 0x00, 0x02, 0x00 }, "NetSys",       "Net & Sys Co., Ltd." },
    { { 0x00, 0x02, 0x01 }, "IFMElectroni", "IFM Electronic gmbh" },
    { { 0x00, 0x02, 0x02 }, "AminoCommuni", "Amino Communications, Ltd." },
    { { 0x00, 0x02, 0x03 }, "WoonsangTele", "Woonsang Telecom, Inc." },
    { { 0x00, 0x02, 0x04 }, "BodmannIndus", "Bodmann Industries Elektronik GmbH" },
    { { 0x00, 0x02, 0x05 }, "HitachiDensh", "Hitachi Denshi, Ltd." },
    { { 0x00, 0x02, 0x06 }, "TelitalR&DDe", "Telital R&D Denmark A/S" },
    { { 0x00, 0x02, 0x07 }, "VisionGlobal", "VisionGlobal Network Corp." },
    { { 0x00, 0x02, 0x08 }, "UnifyNetwork", "Unify Networks, Inc." },
    { { 0x00, 0x02, 0x09 }, "SEDInformati", "Shenzhen SED Information Technology Co., Ltd." },
    { { 0x00, 0x02, 0x0A }, "Gefran",       "Gefran Spa" },
    { { 0x00, 0x02, 0x0B }, "NativeNetwor", "Native Networks, Inc." },
    { { 0x00, 0x02, 0x0C }, "MetroOptix",   "Metro-Optix" },
    { { 0x00, 0x02, 0x0D }, "Micronpccom",  "Micronpc.com" },
    { { 0x00, 0x02, 0x0E }, "ECITelecom",   "ECI Telecom Ltd." },
    { { 0x00, 0x02, 0x0F }, "Aatr",         "Aatr" },
    { { 0x00, 0x02, 0x10 }, "Fenecom",      "Fenecom" },
    { { 0x00, 0x02, 0x11 }, "NatureWorldw", "Nature Worldwide Technology Corp." },
    { { 0x00, 0x02, 0x12 }, "SierraCom",    "SierraCom" },
    { { 0x00, 0x02, 0x13 }, "SDEL",         "S.D.E.L." },
    { { 0x00, 0x02, 0x14 }, "Dtvro",        "Dtvro" },
    { { 0x00, 0x02, 0x15 }, "CotasCompute", "Cotas Computer Technology A/B" },
    { { 0x00, 0x02, 0x16 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0x17 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0x18 }, "AdvancedScie", "Advanced Scientific Corp" },
    { { 0x00, 0x02, 0x19 }, "ParalonTechn", "Paralon Technologies" },
    { { 0x00, 0x02, 0x1A }, "ZumaNetworks", "Zuma Networks" },
    { { 0x00, 0x02, 0x1B }, "KollmorgenSe", "Kollmorgen-Servotronix" },
    { { 0x00, 0x02, 0x1C }, "NetworkEleme", "Network Elements, Inc." },
    { { 0x00, 0x02, 0x1D }, "DataGeneralC", "Data General Communication Ltd." },
    { { 0x00, 0x02, 0x1E }, "Simtel",       "Simtel S.R.L." },
    { { 0x00, 0x02, 0x1F }, "Aculab",       "Aculab PLC" },
    { { 0x00, 0x02, 0x20 }, "CanonFinetec", "Canon Finetech Inc." },
    { { 0x00, 0x02, 0x21 }, "DSPApplicati", "DSP Application, Ltd." },
    { { 0x00, 0x02, 0x22 }, "Chromisys",    "Chromisys, Inc." },
    { { 0x00, 0x02, 0x23 }, "ClickTV",      "ClickTV" },
    { { 0x00, 0x02, 0x24 }, "CCor",         "C-Cor" },
    { { 0x00, 0x02, 0x25 }, "OneStop",      "One Stop Systems" },
    { { 0x00, 0x02, 0x26 }, "XESystems",    "XESystems, Inc." },
    { { 0x00, 0x02, 0x27 }, "ESDElectroni", "ESD Electronic System Design GmbH" },
    { { 0x00, 0x02, 0x28 }, "Necsom",       "Necsom, Ltd." },
    { { 0x00, 0x02, 0x29 }, "Adtec",        "Adtec Corporation" },
    { { 0x00, 0x02, 0x2A }, "AsoundElectr", "Asound Electronic" },
    { { 0x00, 0x02, 0x2B }, "SAXA",         "SAXA, Inc." },
    { { 0x00, 0x02, 0x2C }, "ABBBomem",     "ABB Bomem, Inc." },
    { { 0x00, 0x02, 0x2D }, "Agere",        "Agere Systems" },
    { { 0x00, 0x02, 0x2E }, "TEACR&D",      "TEAC Corp. R& D" },
    { { 0x00, 0x02, 0x2F }, "PCube",        "P-Cube, Ltd." },
    { { 0x00, 0x02, 0x30 }, "IntersoftEle", "Intersoft Electronics" },
    { { 0x00, 0x02, 0x31 }, "IngersollRan", "Ingersoll-Rand" },
    { { 0x00, 0x02, 0x32 }, "Avision",      "Avision, Inc." },
    { { 0x00, 0x02, 0x33 }, "MantraCommun", "Mantra Communications, Inc." },
    { { 0x00, 0x02, 0x34 }, "ImperialTech", "Imperial Technology, Inc." },
    { { 0x00, 0x02, 0x35 }, "ParagonNetwo", "Paragon Networks International" },
    { { 0x00, 0x02, 0x36 }, "INIT",         "INIT GmbH" },
    { { 0x00, 0x02, 0x37 }, "CosmoResearc", "Cosmo Research Corp." },
    { { 0x00, 0x02, 0x38 }, "SeromeTechno", "Serome Technology, Inc." },
    { { 0x00, 0x02, 0x39 }, "Visicom",      "Visicom" },
    { { 0x00, 0x02, 0x3A }, "ZSKStickmasc", "ZSK Stickmaschinen GmbH" },
    { { 0x00, 0x02, 0x3B }, "Ericsson",     "Ericsson" },
    { { 0x00, 0x02, 0x3C }, "CreativeTech", "Creative Technology, Ltd." },
    { { 0x00, 0x02, 0x3D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0x3E }, "SeltaTelemat", "Selta Telematica S.p.a" },
    { { 0x00, 0x02, 0x3F }, "CompalElectr", "Compal Electronics INC." },
    { { 0x00, 0x02, 0x40 }, "Seedek",       "Seedek Co., Ltd." },
    { { 0x00, 0x02, 0x41 }, "Amercom",      "Amer.com" },
    { { 0x00, 0x02, 0x42 }, "Videoframe",   "Videoframe Systems" },
    { { 0x00, 0x02, 0x43 }, "Raysis",       "Raysis Co., Ltd." },
    { { 0x00, 0x02, 0x44 }, "SURECOMTechn", "SURECOM Technology Co." },
    { { 0x00, 0x02, 0x45 }, "Lampus",       "Lampus Co, Ltd." },
    { { 0x00, 0x02, 0x46 }, "AllWinTech",   "All-Win Tech Co., Ltd." },
    { { 0x00, 0x02, 0x47 }, "GreatDragonI", "Great Dragon Information Technology (Group) Co., Ltd." },
    { { 0x00, 0x02, 0x48 }, "Pilz",         "Pilz GmbH & Co." },
    { { 0x00, 0x02, 0x49 }, "AvivInfocom",  "Aviv Infocom Co, Ltd." },
    { { 0x00, 0x02, 0x4A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0x4B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0x4C }, "SiByte",       "SiByte, Inc." },
    { { 0x00, 0x02, 0x4D }, "MannesmanDem", "Mannesman Dematic Colby Pty. Ltd." },
    { { 0x00, 0x02, 0x4E }, "DatacardGrou", "Datacard Group" },
    { { 0x00, 0x02, 0x4F }, "IPMDatacom",   "IPM Datacom S.R.L." },
    { { 0x00, 0x02, 0x50 }, "GeyserNetwor", "Geyser Networks, Inc." },
    { { 0x00, 0x02, 0x51 }, "SomaNetworks", "Soma Networks, Inc." },
    { { 0x00, 0x02, 0x52 }, "Carrier",      "Carrier Corporation" },
    { { 0x00, 0x02, 0x53 }, "Televideo",    "Televideo, Inc." },
    { { 0x00, 0x02, 0x54 }, "WorldGate",    "WorldGate" },
    { { 0x00, 0x02, 0x55 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x02, 0x56 }, "AlphaProcess", "Alpha Processor, Inc." },
    { { 0x00, 0x02, 0x57 }, "Microcom",     "Microcom Corp." },
    { { 0x00, 0x02, 0x58 }, "FlyingPacket", "Flying Packets Communications" },
    { { 0x00, 0x02, 0x59 }, "TsannKuenChi", "Tsann Kuen China (Shanghai)Enterprise Co., Ltd. IT Group" },
    { { 0x00, 0x02, 0x5A }, "CatenaNetwor", "Catena Networks" },
    { { 0x00, 0x02, 0x5B }, "CambridgeSil", "Cambridge Silicon Radio" },
    { { 0x00, 0x02, 0x5C }, "SCI",          "SCI Systems (Kunshan) Co., Ltd." },
    { { 0x00, 0x02, 0x5D }, "CalixNetwork", "Calix Networks" },
    { { 0x00, 0x02, 0x5E }, "HighTechnolo", "High Technology Ltd" },
    { { 0x00, 0x02, 0x5F }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x02, 0x60 }, "AccordionNet", "Accordion Networks, Inc." },
    { { 0x00, 0x02, 0x61 }, "Tilgin",       "Tilgin AB" },
    { { 0x00, 0x02, 0x62 }, "SoyoGroupSoy", "Soyo Group Soyo Com Tech Co., Ltd" },
    { { 0x00, 0x02, 0x63 }, "RPS",          "RPS S.p.A." },
    { { 0x00, 0x02, 0x64 }, "AudioRampcom", "AudioRamp.com" },
    { { 0x00, 0x02, 0x65 }, "Virditech",    "Virditech Co. Ltd." },
    { { 0x00, 0x02, 0x66 }, "Thermalogic",  "Thermalogic Corporation" },
    { { 0x00, 0x02, 0x67 }, "NodeRunner",   "Node Runner, Inc." },
    { { 0x00, 0x02, 0x68 }, "HarrisGovern", "Harris Government Communications" },
    { { 0x00, 0x02, 0x69 }, "Nadatel",      "Nadatel Co., Ltd" },
    { { 0x00, 0x02, 0x6A }, "CocessTeleco", "Cocess Telecom Co., Ltd." },
    { { 0x00, 0x02, 0x6B }, "BCMComputers", "BCM Computers Co., Ltd." },
    { { 0x00, 0x02, 0x6C }, "PhilipsCFT",   "Philips CFT" },
    { { 0x00, 0x02, 0x6D }, "AdeptTelecom", "Adept Telecom" },
    { { 0x00, 0x02, 0x6E }, "NeGeNAccess",  "NeGeN Access, Inc." },
    { { 0x00, 0x02, 0x6F }, "SenaoInterna", "Senao International Co., Ltd." },
    { { 0x00, 0x02, 0x70 }, "Crewave",      "Crewave Co., Ltd." },
    { { 0x00, 0x02, 0x71 }, "DZS",          "DZS Inc." },
    { { 0x00, 0x02, 0x72 }, "CC&CTechnolo", "CC&C Technologies, Inc." },
    { { 0x00, 0x02, 0x73 }, "CoriolisNetw", "Coriolis Networks" },
    { { 0x00, 0x02, 0x74 }, "TommyTechnol", "Tommy Technologies Corp." },
    { { 0x00, 0x02, 0x75 }, "SMARTTechnol", "SMART Technologies, Inc." },
    { { 0x00, 0x02, 0x76 }, "PrimaxElectr", "Primax Electronics Ltd." },
    { { 0x00, 0x02, 0x77 }, "CashSystemes", "Cash Systemes Industrie" },
    { { 0x00, 0x02, 0x78 }, "SamsungElect", "Samsung Electro Mechanics Co., Ltd." },
    { { 0x00, 0x02, 0x79 }, "ControlAppli", "Control Applications, Ltd." },
    { { 0x00, 0x02, 0x7A }, "IOITechnolog", "IOI Technology Corporation" },
    { { 0x00, 0x02, 0x7B }, "AmplifyNet",   "Amplify Net, Inc." },
    { { 0x00, 0x02, 0x7C }, "Trilithic",    "Trilithic, Inc." },
    { { 0x00, 0x02, 0x7D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0x7E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0x7F }, "asktechnolog", "ask-technologies.com" },
    { { 0x00, 0x02, 0x80 }, "MuNet",        "Mu Net, Inc." },
    { { 0x00, 0x02, 0x81 }, "Madge",        "Madge Ltd." },
    { { 0x00, 0x02, 0x82 }, "ViaClix",      "ViaClix, Inc." },
    { { 0x00, 0x02, 0x83 }, "SpectrumCont", "Spectrum Controls, Inc." },
    { { 0x00, 0x02, 0x84 }, "UKGridSoluti", "UK Grid Solutions Limited" },
    { { 0x00, 0x02, 0x85 }, "RiverstoneNe", "Riverstone Networks" },
    { { 0x00, 0x02, 0x86 }, "OccamNetwork", "Occam Networks" },
    { { 0x00, 0x02, 0x87 }, "Adapcom",      "Adapcom" },
    { { 0x00, 0x02, 0x88 }, "GlobalVillag", "Global Village Communication" },
    { { 0x00, 0x02, 0x89 }, "DNETechnolog", "DNE Technologies" },
    { { 0x00, 0x02, 0x8A }, "AmbitMicrosy", "Ambit Microsystems Corporation" },
    { { 0x00, 0x02, 0x8B }, "VDSL",         "VDSL Systems OY" },
    { { 0x00, 0x02, 0x8C }, "MicrelSynerg", "Micrel-Synergy Semiconductor" },
    { { 0x00, 0x02, 0x8D }, "MovitaTechno", "Movita Technologies, Inc." },
    { { 0x00, 0x02, 0x8E }, "Rapid5Networ", "Rapid 5 Networks, Inc." },
    { { 0x00, 0x02, 0x8F }, "Globetek",     "Globetek, Inc." },
    { { 0x00, 0x02, 0x90 }, "Woorigisool",  "Woorigisool, Inc." },
    { { 0x00, 0x02, 0x91 }, "OpenNetwork",  "Open Network Co., Ltd." },
    { { 0x00, 0x02, 0x92 }, "LogicInnovat", "Logic Innovations, Inc." },
    { { 0x00, 0x02, 0x93 }, "SolidData",    "Solid Data Systems" },
    { { 0x00, 0x02, 0x94 }, "TokyoSokushi", "Tokyo Sokushin Co., Ltd." },
    { { 0x00, 0x02, 0x95 }, "MavenirIpaUk", "Mavenir Ipa Uk Ltd" },
    { { 0x00, 0x02, 0x96 }, "Lectron",      "Lectron Co,. Ltd." },
    { { 0x00, 0x02, 0x97 }, "CCORnet",      "C-COR.net" },
    { { 0x00, 0x02, 0x98 }, "Broadframe",   "Broadframe Corporation" },
    { { 0x00, 0x02, 0x99 }, "Apex",         "Apex, Inc." },
    { { 0x00, 0x02, 0x9A }, "StorageApps",  "Storage Apps" },
    { { 0x00, 0x02, 0x9B }, "KreatelCommu", "Kreatel Communications AB" },
    { { 0x00, 0x02, 0x9C }, "3Com",         "3Com" },
    { { 0x00, 0x02, 0x9D }, "Merix",        "Merix Corp." },
    { { 0x00, 0x02, 0x9E }, "InformationE", "Information Equipment Co., Ltd." },
    { { 0x00, 0x02, 0x9F }, "L3Communicat", "L-3 Communication Aviation Recorders" },
    { { 0x00, 0x02, 0xA0 }, "Flatstack",    "Flatstack Ltd." },
    { { 0x00, 0x02, 0xA1 }, "WorldWidePac", "World Wide Packets" },
    { { 0x00, 0x02, 0xA2 }, "Hilscher",     "Hilscher GmbH" },
    { { 0x00, 0x02, 0xA3 }, "HitachiEnerg", "Hitachi Energy Switzerland Ltd" },
    { { 0x00, 0x02, 0xA4 }, "AddPacTechno", "AddPac Technology Co., Ltd." },
    { { 0x00, 0x02, 0xA5 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x02, 0xA6 }, "Effinet",      "Effinet Systems Co., Ltd." },
    { { 0x00, 0x02, 0xA7 }, "VivaceNetwor", "Vivace Networks" },
    { { 0x00, 0x02, 0xA8 }, "AirLinkTechn", "Air Link Technology" },
    { { 0x00, 0x02, 0xA9 }, "RACOMsro",     "RACOM, s.r.o." },
    { { 0x00, 0x02, 0xAA }, "PLcom",        "PLcom Co., Ltd." },
    { { 0x00, 0x02, 0xAB }, "CTCUnionTech", "CTC Union Technologies Co., Ltd." },
    { { 0x00, 0x02, 0xAC }, "3PARdata",     "3PAR data" },
    { { 0x00, 0x02, 0xAD }, "HOYA",         "HOYA Corporation" },
    { { 0x00, 0x02, 0xAE }, "ScannexElect", "Scannex Electronics Ltd." },
    { { 0x00, 0x02, 0xAF }, "TeleCruzTech", "TeleCruz Technology, Inc." },
    { { 0x00, 0x02, 0xB0 }, "HokubuCommun", "Hokubu Communication & Industrial Co., Ltd." },
    { { 0x00, 0x02, 0xB1 }, "Anritsu",      "Anritsu, Ltd." },
    { { 0x00, 0x02, 0xB2 }, "Cablevision",  "Cablevision" },
    { { 0x00, 0x02, 0xB3 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x02, 0xB4 }, "Daphne",       "Daphne" },
    { { 0x00, 0x02, 0xB5 }, "Avnet",        "Avnet, Inc." },
    { { 0x00, 0x02, 0xB6 }, "AcrosserTech", "Acrosser Technology Co., Ltd." },
    { { 0x00, 0x02, 0xB7 }, "WatanabeElec", "Watanabe Electric Industry Co., Ltd." },
    { { 0x00, 0x02, 0xB8 }, "WhiKonsult",   "Whi Konsult Ab" },
    { { 0x00, 0x02, 0xB9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0xBA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0xBB }, "ContinuousCo", "Continuous Computing Corp" },
    { { 0x00, 0x02, 0xBC }, "LVL7",         "LVL 7 Systems, Inc." },
    { { 0x00, 0x02, 0xBD }, "Bionet",       "Bionet Co., Ltd." },
    { { 0x00, 0x02, 0xBE }, "TotsuEnginee", "Totsu Engineering, Inc." },
    { { 0x00, 0x02, 0xBF }, "dotRocket",    "dotRocket, Inc." },
    { { 0x00, 0x02, 0xC0 }, "BencentTzeng", "Bencent Tzeng Industry Co., Ltd." },
    { { 0x00, 0x02, 0xC1 }, "InnovativeEl", "Innovative Electronic Designs, Inc." },
    { { 0x00, 0x02, 0xC2 }, "NetVisionTel", "Net Vision Telecom" },
    { { 0x00, 0x02, 0xC3 }, "Arelnet",      "Arelnet Ltd." },
    { { 0x00, 0x02, 0xC4 }, "OPTMachineVi", "OPT Machine Vision Tech Co., Ltd" },
    { { 0x00, 0x02, 0xC5 }, "EvertzMicros", "Evertz Microsystems Ltd." },
    { { 0x00, 0x02, 0xC6 }, "DataTrackTec", "Data Track Technology PLC" },
    { { 0x00, 0x02, 0xC7 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x02, 0xC8 }, "TechnocomCom", "Technocom Communications Technology (pte) Ltd" },
    { { 0x00, 0x02, 0xC9 }, "MellanoxTech", "Mellanox Technologies, Inc." },
    { { 0x00, 0x02, 0xCA }, "EndPoints",    "EndPoints, Inc." },
    { { 0x00, 0x02, 0xCB }, "TriState",     "TriState Ltd." },
    { { 0x00, 0x02, 0xCC }, "MCCI",         "M.C.C.I" },
    { { 0x00, 0x02, 0xCD }, "TeleDream",    "TeleDream, Inc." },
    { { 0x00, 0x02, 0xCE }, "FoxJet",       "FoxJet, Inc." },
    { { 0x00, 0x02, 0xCF }, "ZyGateCommun", "ZyGate Communications, Inc." },
    { { 0x00, 0x02, 0xD0 }, "Comdial",      "Comdial Corporation" },
    { { 0x00, 0x02, 0xD1 }, "Vivotek",      "Vivotek, Inc." },
    { { 0x00, 0x02, 0xD2 }, "Workstation",  "Workstation AG" },
    { { 0x00, 0x02, 0xD3 }, "NetBotz",      "NetBotz, Inc." },
    { { 0x00, 0x02, 0xD4 }, "PDAPeriphera", "PDA Peripherals, Inc." },
    { { 0x00, 0x02, 0xD5 }, "Acr",          "Acr" },
    { { 0x00, 0x02, 0xD6 }, "NICE",         "NICE Systems" },
    { { 0x00, 0x02, 0xD7 }, "EMPEG",        "EMPEG Ltd" },
    { { 0x00, 0x02, 0xD8 }, "BRECISCommun", "BRECIS Communications Corporation" },
    { { 0x00, 0x02, 0xD9 }, "ReliableCont", "Reliable Controls" },
    { { 0x00, 0x02, 0xDA }, "ExiOCommunic", "ExiO Communications, Inc." },
    { { 0x00, 0x02, 0xDB }, "Netsec",       "Netsec" },
    { { 0x00, 0x02, 0xDC }, "FujitsuGener", "Fujitsu General Limited" },
    { { 0x00, 0x02, 0xDD }, "BromaxCommun", "Bromax Communications, Ltd." },
    { { 0x00, 0x02, 0xDE }, "Astrodesign",  "Astrodesign, Inc." },
    { { 0x00, 0x02, 0xDF }, "NetCom",       "Net Com Systems, Inc." },
    { { 0x00, 0x02, 0xE0 }, "ETAS",         "ETAS GmbH" },
    { { 0x00, 0x02, 0xE1 }, "IntegratedNe", "Integrated Network Corporation" },
    { { 0x00, 0x02, 0xE2 }, "NDCInfaredEn", "NDC Infared Engineering" },
    { { 0x00, 0x02, 0xE3 }, "LITEONCommun", "LITE-ON Communications, Inc." },
    { { 0x00, 0x02, 0xE4 }, "JCHYUN",       "JC HYUN Systems, Inc." },
    { { 0x00, 0x02, 0xE5 }, "Timeware",     "Timeware Ltd." },
    { { 0x00, 0x02, 0xE6 }, "GouldInstrum", "Gould Instrument Systems, Inc." },
    { { 0x00, 0x02, 0xE7 }, "CAB",          "CAB GmbH & Co KG" },
    { { 0x00, 0x02, 0xE8 }, "ED&A",         "E.D.&A." },
    { { 0x00, 0x02, 0xE9 }, "CSSystemesDe", "CS Systemes De Securite - C3S" },
    { { 0x00, 0x02, 0xEA }, "FocusEnhance", "Focus Enhancements" },
    { { 0x00, 0x02, 0xEB }, "PicoCommunic", "Pico Communications" },
    { { 0x00, 0x02, 0xEC }, "MaschoffDesi", "Maschoff Design Engineering" },
    { { 0x00, 0x02, 0xED }, "DXOTelecom",   "DXO Telecom Co., Ltd." },
    { { 0x00, 0x02, 0xEE }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x02, 0xEF }, "CCCNetworkGr", "CCC Network Systems Group Ltd." },
    { { 0x00, 0x02, 0xF0 }, "AMEOptimedia", "AME Optimedia Technology Co., Ltd." },
    { { 0x00, 0x02, 0xF1 }, "Pinetron",     "Pinetron Co., Ltd." },
    { { 0x00, 0x02, 0xF2 }, "eDevice",      "eDevice, Inc." },
    { { 0x00, 0x02, 0xF3 }, "MediaServe",   "Media Serve Co., Ltd." },
    { { 0x00, 0x02, 0xF4 }, "PCTEL",        "PCTEL, Inc." },
    { { 0x00, 0x02, 0xF5 }, "VIVESynergie", "VIVE Synergies, Inc." },
    { { 0x00, 0x02, 0xF6 }, "EquipeCommun", "Equipe Communications" },
    { { 0x00, 0x02, 0xF7 }, "Arm",          "Arm" },
    { { 0x00, 0x02, 0xF8 }, "SEAKREnginee", "SEAKR Engineering, Inc." },
    { { 0x00, 0x02, 0xF9 }, "MIMOSBerhad",  "MIMOS Berhad" },
    { { 0x00, 0x02, 0xFA }, "DXAntenna",    "DX Antenna Co., Ltd." },
    { { 0x00, 0x02, 0xFB }, "BaumullerAul", "Baumuller Aulugen-Systemtechnik GmbH" },
    { { 0x00, 0x02, 0xFC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0xFD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x02, 0xFE }, "Viditec",      "Viditec, Inc." },
    { { 0x00, 0x02, 0xFF }, "HandanBroadI", "Handan BroadInfoCom" },
    { { 0x00, 0x03, 0x00 }, "BarracudaNet", "Barracuda Networks, Inc." },
    { { 0x00, 0x03, 0x01 }, "Exfo",         "Exfo" },
    { { 0x00, 0x03, 0x02 }, "CharlesIndus", "Charles Industries, Ltd." },
    { { 0x00, 0x03, 0x03 }, "JAMAElectron", "JAMA Electronics Co., Ltd." },
    { { 0x00, 0x03, 0x04 }, "PacificBroad", "Pacific Broadband Communications" },
    { { 0x00, 0x03, 0x05 }, "MSCVertriebs", "MSC Vertriebs GmbH" },
    { { 0x00, 0x03, 0x06 }, "FusionInTech", "Fusion In Tech Co., Ltd." },
    { { 0x00, 0x03, 0x07 }, "SecureWorks",  "Secure Works, Inc." },
    { { 0x00, 0x03, 0x08 }, "AMCommunicat", "AM Communications, Inc." },
    { { 0x00, 0x03, 0x09 }, "TexcelTechno", "Texcel Technology PLC" },
    { { 0x00, 0x03, 0x0A }, "ArgusTechnol", "Argus Technologies" },
    { { 0x00, 0x03, 0x0B }, "HunterTechno", "Hunter Technology, Inc." },
    { { 0x00, 0x03, 0x0C }, "TelesoftTech", "Telesoft Technologies Ltd." },
    { { 0x00, 0x03, 0x0D }, "UniwillCompu", "Uniwill Computer Corp." },
    { { 0x00, 0x03, 0x0E }, "CoreCommunic", "Core Communications Co., Ltd." },
    { { 0x00, 0x03, 0x0F }, "DigitalChina", "Digital China (Shanghai) Networks Ltd." },
    { { 0x00, 0x03, 0x10 }, "EGlobaledge",  "E-Globaledge Corporation" },
    { { 0x00, 0x03, 0x11 }, "MicroTechnol", "Micro Technology Co., Ltd." },
    { { 0x00, 0x03, 0x12 }, "TRsystems",    "TRsystems GmbH" },
    { { 0x00, 0x03, 0x13 }, "AccessMedia",  "Access Media SPA" },
    { { 0x00, 0x03, 0x14 }, "TelewareNetw", "Teleware Network Systems" },
    { { 0x00, 0x03, 0x15 }, "Cidco",        "Cidco Incorporated" },
    { { 0x00, 0x03, 0x16 }, "NobellCommun", "Nobell Communications, Inc." },
    { { 0x00, 0x03, 0x17 }, "Merlin",       "Merlin Systems, Inc." },
    { { 0x00, 0x03, 0x18 }, "Cyras",        "Cyras Systems, Inc." },
    { { 0x00, 0x03, 0x19 }, "Infineon",     "Infineon AG" },
    { { 0x00, 0x03, 0x1A }, "BroadTelecom", "Beijing Broad Telecom Ltd., China" },
    { { 0x00, 0x03, 0x1B }, "Cellvision",   "Cellvision Systems, Inc." },
    { { 0x00, 0x03, 0x1C }, "SvenskaHardv", "Svenska Hardvarufabriken AB" },
    { { 0x00, 0x03, 0x1D }, "TaiwanCommat", "Taiwan Commate Computer, Inc." },
    { { 0x00, 0x03, 0x1E }, "Optranet",     "Optranet, Inc." },
    { { 0x00, 0x03, 0x1F }, "Condev",       "Condev Ltd." },
    { { 0x00, 0x03, 0x20 }, "Xpeed",        "Xpeed, Inc." },
    { { 0x00, 0x03, 0x21 }, "RecoResearch", "Reco Research Co., Ltd." },
    { { 0x00, 0x03, 0x22 }, "IDIS",         "IDIS Co., Ltd." },
    { { 0x00, 0x03, 0x23 }, "CornetTechno", "Cornet Technology, Inc." },
    { { 0x00, 0x03, 0x24 }, "LIMNO",        "LIMNO Co., Ltd." },
    { { 0x00, 0x03, 0x25 }, "ArimaCompute", "Arima Computer Corp." },
    { { 0x00, 0x03, 0x26 }, "IwasakiInfor", "Iwasaki Information Systems Co., Ltd." },
    { { 0x00, 0x03, 0x27 }, "HMSIndustria", "HMS Industrial Networks" },
    { { 0x00, 0x03, 0x28 }, "MaceGroup",    "Mace Group, Inc." },
    { { 0x00, 0x03, 0x29 }, "F3",           "F3, Inc." },
    { { 0x00, 0x03, 0x2A }, "UniDataCommu", "UniData Communication Systems, Inc." },
    { { 0x00, 0x03, 0x2B }, "GAIDatenfunk", "GAI Datenfunksysteme GmbH" },
    { { 0x00, 0x03, 0x2C }, "ABBSwitzerla", "ABB Switzerland Ltd" },
    { { 0x00, 0x03, 0x2D }, "IBASETechnol", "IBASE Technology, Inc." },
    { { 0x00, 0x03, 0x2E }, "ScopeInforma", "Scope Information Management, Ltd." },
    { { 0x00, 0x03, 0x2F }, "GlobalSunTec", "Global Sun Technology, Inc." },
    { { 0x00, 0x03, 0x30 }, "Imagenics",    "Imagenics, Co., Ltd." },
    { { 0x00, 0x03, 0x31 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0x32 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0x33 }, "Digitel",      "Digitel Co., Ltd." },
    { { 0x00, 0x03, 0x34 }, "OmegaEnginee", "Omega Engineering Inc." },
    { { 0x00, 0x03, 0x35 }, "MiraeTechnol", "Mirae Technology" },
    { { 0x00, 0x03, 0x36 }, "ZetesTechnol", "Zetes Technologies" },
    { { 0x00, 0x03, 0x37 }, "Vaone",        "Vaone, Inc." },
    { { 0x00, 0x03, 0x38 }, "OakTechnolog", "Oak Technology" },
    { { 0x00, 0x03, 0x39 }, "Eurologic",    "Eurologic Systems, Ltd." },
    { { 0x00, 0x03, 0x3A }, "SiliconWave",  "Silicon Wave, Inc." },
    { { 0x00, 0x03, 0x3B }, "TAMITech",     "TAMI Tech Co., Ltd." },
    { { 0x00, 0x03, 0x3C }, "Daiden",       "Daiden Co., Ltd." },
    { { 0x00, 0x03, 0x3D }, "ILSHinLab",    "ILSHin Lab" },
    { { 0x00, 0x03, 0x3E }, "TateyamaSyst", "Tateyama System Laboratory Co., Ltd." },
    { { 0x00, 0x03, 0x3F }, "BigBandNetwo", "BigBand Networks, Ltd." },
    { { 0x00, 0x03, 0x40 }, "FlowareWirel", "Floware Wireless Systems, Ltd." },
    { { 0x00, 0x03, 0x41 }, "AxonDigitalD", "Axon Digital Design" },
    { { 0x00, 0x03, 0x42 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x03, 0x43 }, "MartinProfes", "Martin Professional A/S" },
    { { 0x00, 0x03, 0x44 }, "Tietech",      "Tietech.Co., Ltd." },
    { { 0x00, 0x03, 0x45 }, "RoutrekNetwo", "Routrek Networks Corporation" },
    { { 0x00, 0x03, 0x46 }, "HitachiKokus", "Hitachi Kokusai Electric, Inc." },
    { { 0x00, 0x03, 0x47 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x03, 0x48 }, "NorscanInstr", "Norscan Instruments, Ltd." },
    { { 0x00, 0x03, 0x49 }, "VidicodeData", "Vidicode Datacommunicatie B.V." },
    { { 0x00, 0x03, 0x4A }, "RIAS",         "RIAS Corporation" },
    { { 0x00, 0x03, 0x4B }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x03, 0x4C }, "DigiVisionTe", "Shanghai DigiVision Technology Co., Ltd." },
    { { 0x00, 0x03, 0x4D }, "ChiaroNetwor", "Chiaro Networks, Ltd." },
    { { 0x00, 0x03, 0x4E }, "PosData",      "Pos Data Company, Ltd." },
    { { 0x00, 0x03, 0x4F }, "SurGardSecur", "Sur-Gard Security" },
    { { 0x00, 0x03, 0x50 }, "Bticino",      "Bticino Spa" },
    { { 0x00, 0x03, 0x51 }, "DieboldNixdo", "Diebold Nixdorf" },
    { { 0x00, 0x03, 0x52 }, "ColubrisNetw", "Colubris Networks" },
    { { 0x00, 0x03, 0x53 }, "Mitac",        "Mitac, Inc." },
    { { 0x00, 0x03, 0x54 }, "FiberLogicCo", "Fiber Logic Communications" },
    { { 0x00, 0x03, 0x55 }, "TeraBeamInte", "TeraBeam Internet Systems" },
    { { 0x00, 0x03, 0x56 }, "DieboldNixdo", "Diebold Nixdorf" },
    { { 0x00, 0x03, 0x57 }, "IntervoiceBr", "Intervoice-Brite, Inc." },
    { { 0x00, 0x03, 0x58 }, "HanyangDigit", "Hanyang Digitech Co.Ltd" },
    { { 0x00, 0x03, 0x59 }, "DigitalSis",   "DigitalSis" },
    { { 0x00, 0x03, 0x5A }, "Photron",      "Photron Limited" },
    { { 0x00, 0x03, 0x5B }, "BridgeWaveCo", "BridgeWave Communications" },
    { { 0x00, 0x03, 0x5C }, "SaintSong",    "Saint Song Corp." },
    { { 0x00, 0x03, 0x5D }, "BosungHiNet",  "Bosung Hi-Net Co., Ltd." },
    { { 0x00, 0x03, 0x5E }, "Metropolitan", "Metropolitan Area Networks, Inc." },
    { { 0x00, 0x03, 0x5F }, "PrüftechnikC", "Prüftechnik Condition Monitoring GmbH & Co. KG" },
    { { 0x00, 0x03, 0x60 }, "PACInteracti", "PAC Interactive Technology, Inc." },
    { { 0x00, 0x03, 0x61 }, "Widcomm",      "Widcomm, Inc." },
    { { 0x00, 0x03, 0x62 }, "VodtelCommun", "Vodtel Communications, Inc." },
    { { 0x00, 0x03, 0x63 }, "Miraesys",     "Miraesys Co., Ltd." },
    { { 0x00, 0x03, 0x64 }, "ScenixSemico", "Scenix Semiconductor, Inc." },
    { { 0x00, 0x03, 0x65 }, "KiraInformat", "Kira Information & Communications, Ltd." },
    { { 0x00, 0x03, 0x66 }, "ASMPacificTe", "ASM Pacific Technology" },
    { { 0x00, 0x03, 0x67 }, "JasmineNetwo", "Jasmine Networks, Inc." },
    { { 0x00, 0x03, 0x68 }, "Embedone",     "Embedone Co., Ltd." },
    { { 0x00, 0x03, 0x69 }, "NipponAntenn", "Nippon Antenna Co., Ltd." },
    { { 0x00, 0x03, 0x6A }, "Mainnet",      "Mainnet, Ltd." },
    { { 0x00, 0x03, 0x6B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0x6C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0x6D }, "Runtop",       "Runtop, Inc." },
    { { 0x00, 0x03, 0x6E }, "Nicon",        "Nicon Systems (Pty) Limited" },
    { { 0x00, 0x03, 0x6F }, "Telsey",       "Telsey SPA" },
    { { 0x00, 0x03, 0x70 }, "NXTV",         "NXTV, Inc." },
    { { 0x00, 0x03, 0x71 }, "AcomzNetwork", "Acomz Networks Corp." },
    { { 0x00, 0x03, 0x72 }, "Ulan",         "Ulan" },
    { { 0x00, 0x03, 0x73 }, "Aselsan",      "Aselsan A.S" },
    { { 0x00, 0x03, 0x74 }, "ControlMicro", "Control Microsystems" },
    { { 0x00, 0x03, 0x75 }, "NetMedia",     "NetMedia, Inc." },
    { { 0x00, 0x03, 0x76 }, "GraphtecTech", "Graphtec Technology, Inc." },
    { { 0x00, 0x03, 0x77 }, "GigabitWirel", "Gigabit Wireless" },
    { { 0x00, 0x03, 0x78 }, "HUMAX",        "HUMAX Co., Ltd." },
    { { 0x00, 0x03, 0x79 }, "ProscendComm", "Proscend Communications, Inc." },
    { { 0x00, 0x03, 0x7A }, "TaiyoYuden",   "Taiyo Yuden Co., Ltd." },
    { { 0x00, 0x03, 0x7B }, "IDECIZUMI",    "IDEC IZUMI Corporation" },
    { { 0x00, 0x03, 0x7C }, "CoaxMedia",    "Coax Media" },
    { { 0x00, 0x03, 0x7D }, "Stellcom",     "Stellcom" },
    { { 0x00, 0x03, 0x7E }, "PORTechCommu", "PORTech Communications, Inc." },
    { { 0x00, 0x03, 0x7F }, "AtherosCommu", "Atheros Communications, Inc." },
    { { 0x00, 0x03, 0x80 }, "SSHCommunica", "SSH Communications Security Corp." },
    { { 0x00, 0x03, 0x81 }, "IngenicoInte", "Ingenico International" },
    { { 0x00, 0x03, 0x82 }, "AOne",         "A-One Co., Ltd." },
    { { 0x00, 0x03, 0x83 }, "MeteraNetwor", "Metera Networks, Inc." },
    { { 0x00, 0x03, 0x84 }, "Aeta",         "Aeta" },
    { { 0x00, 0x03, 0x85 }, "ActelisNetwo", "Actelis Networks, Inc." },
    { { 0x00, 0x03, 0x86 }, "HoNet",        "Ho Net, Inc." },
    { { 0x00, 0x03, 0x87 }, "BlazeNetwork", "Blaze Network Products" },
    { { 0x00, 0x03, 0x88 }, "FastfameTech", "Fastfame Technology Co., Ltd." },
    { { 0x00, 0x03, 0x89 }, "Plantronics",  "Plantronics, Inc." },
    { { 0x00, 0x03, 0x8A }, "AmericaOnlin", "America Online, Inc." },
    { { 0x00, 0x03, 0x8B }, "PLUSONEI&T",   "PLUS-ONE I&T, Inc." },
    { { 0x00, 0x03, 0x8C }, "TotalImpact",  "Total Impact" },
    { { 0x00, 0x03, 0x8D }, "PCSRevenueCo", "PCS Revenue Control Systems, Inc." },
    { { 0x00, 0x03, 0x8E }, "Atoga",        "Atoga Systems, Inc." },
    { { 0x00, 0x03, 0x8F }, "Weinschel",    "Weinschel Corporation" },
    { { 0x00, 0x03, 0x90 }, "DigitalVideo", "Digital Video Communications, Inc." },
    { { 0x00, 0x03, 0x91 }, "AdvancedDigi", "Advanced Digital Broadcast, Ltd." },
    { { 0x00, 0x03, 0x92 }, "HyundaiTelet", "Hyundai Teletek Co., Ltd." },
    { { 0x00, 0x03, 0x93 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x03, 0x94 }, "ConnectOne",   "Connect One" },
    { { 0x00, 0x03, 0x95 }, "CaliforniaAm", "California Amplifier" },
    { { 0x00, 0x03, 0x96 }, "EZCast",       "EZ Cast Co., Ltd." },
    { { 0x00, 0x03, 0x97 }, "FireBrick",    "FireBrick Limited" },
    { { 0x00, 0x03, 0x98 }, "Wisi",         "Wisi" },
    { { 0x00, 0x03, 0x99 }, "DongjuInform", "Dongju Informations & Communications Co., Ltd." },
    { { 0x00, 0x03, 0x9A }, "SiConnect",    "SiConnect" },
    { { 0x00, 0x03, 0x9B }, "NetChipTechn", "NetChip Technology, Inc." },
    { { 0x00, 0x03, 0x9C }, "OptiMightCom", "OptiMight Communications, Inc." },
    { { 0x00, 0x03, 0x9D }, "Qisda",        "Qisda Corporation" },
    { { 0x00, 0x03, 0x9E }, "TeraSystem",   "Tera System Co., Ltd." },
    { { 0x00, 0x03, 0x9F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0xA0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0xA1 }, "HIPERInforma", "HIPER Information & Communication, Inc." },
    { { 0x00, 0x03, 0xA2 }, "CatapultComm", "Catapult Communications" },
    { { 0x00, 0x03, 0xA3 }, "MAVIX",        "MAVIX, Ltd." },
    { { 0x00, 0x03, 0xA4 }, "Imation",      "Imation Corp." },
    { { 0x00, 0x03, 0xA5 }, "Medea",        "Medea Corporation" },
    { { 0x00, 0x03, 0xA6 }, "TraxitTechno", "Traxit Technology, Inc." },
    { { 0x00, 0x03, 0xA7 }, "UnixtarTechn", "Unixtar Technology, Inc." },
    { { 0x00, 0x03, 0xA8 }, "IDOTComputer", "IDOT Computers, Inc." },
    { { 0x00, 0x03, 0xA9 }, "AXCENTMedia",  "AXCENT Media AG" },
    { { 0x00, 0x03, 0xAA }, "Watlow",       "Watlow" },
    { { 0x00, 0x03, 0xAB }, "BridgeInform", "Bridge Information Systems" },
    { { 0x00, 0x03, 0xAC }, "FroniusSchwe", "Fronius Schweissmaschinen" },
    { { 0x00, 0x03, 0xAD }, "EmersonEnerg", "Emerson Energy Systems AB" },
    { { 0x00, 0x03, 0xAE }, "AlliedAdvanc", "Allied Advanced Manufacturing Pte, Ltd." },
    { { 0x00, 0x03, 0xAF }, "ParageaCommu", "Paragea Communications" },
    { { 0x00, 0x03, 0xB0 }, "XsenseTechno", "Xsense Technology Corp." },
    { { 0x00, 0x03, 0xB1 }, "ICUMedical",   "ICU Medical, Inc." },
    { { 0x00, 0x03, 0xB2 }, "Radware",      "Radware" },
    { { 0x00, 0x03, 0xB3 }, "IALink",       "IA Link Systems Co., Ltd." },
    { { 0x00, 0x03, 0xB4 }, "MacrotekInte", "Macrotek International Corp." },
    { { 0x00, 0x03, 0xB5 }, "EntraTechnol", "Entra Technology Co." },
    { { 0x00, 0x03, 0xB6 }, "QSI",          "QSI Corporation" },
    { { 0x00, 0x03, 0xB7 }, "ZACCESS",      "ZACCESS Systems" },
    { { 0x00, 0x03, 0xB8 }, "NetKitSoluti", "NetKit Solutions, LLC" },
    { { 0x00, 0x03, 0xB9 }, "HualongTelec", "Hualong Telecom Co., Ltd." },
    { { 0x00, 0x03, 0xBA }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x03, 0xBB }, "SignalCommun", "Signal Communications Limited" },
    { { 0x00, 0x03, 0xBC }, "COT",          "COT GmbH" },
    { { 0x00, 0x03, 0xBD }, "OmniClusterT", "OmniCluster Technologies, Inc." },
    { { 0x00, 0x03, 0xBE }, "Netility",     "Netility" },
    { { 0x00, 0x03, 0xBF }, "CenterpointB", "Centerpoint Broadband Technologies, Inc." },
    { { 0x00, 0x03, 0xC0 }, "RFTNC",        "RFTNC Co., Ltd." },
    { { 0x00, 0x03, 0xC1 }, "PacketDynami", "Packet Dynamics Ltd" },
    { { 0x00, 0x03, 0xC2 }, "Solphone",     "Solphone K.K." },
    { { 0x00, 0x03, 0xC3 }, "MicronikMult", "Micronik Multimedia" },
    { { 0x00, 0x03, 0xC4 }, "TomraASA",     "Tomra Systems ASA" },
    { { 0x00, 0x03, 0xC5 }, "Mobotix",      "Mobotix AG" },
    { { 0x00, 0x03, 0xC6 }, "ICUE",         "ICUE Systems, Inc." },
    { { 0x00, 0x03, 0xC7 }, "hopfElektron", "hopf Elektronik GmbH" },
    { { 0x00, 0x03, 0xC8 }, "CMLEmergency", "CML Emergency Services" },
    { { 0x00, 0x03, 0xC9 }, "TECOM",        "TECOM Co., Ltd." },
    { { 0x00, 0x03, 0xCA }, "MTS",          "MTS Systems Corp." },
    { { 0x00, 0x03, 0xCB }, "SystemGear",   "SystemGear Co., Ltd." },
    { { 0x00, 0x03, 0xCC }, "MomentumComp", "Momentum Computer, Inc." },
    { { 0x00, 0x03, 0xCD }, "Clovertech",   "Clovertech, Inc." },
    { { 0x00, 0x03, 0xCE }, "ETENTechnolo", "ETEN Technologies, Inc." },
    { { 0x00, 0x03, 0xCF }, "Muxcom",       "Muxcom, Inc." },
    { { 0x00, 0x03, 0xD0 }, "KOANKEISO",    "KOANKEISO Co., Ltd." },
    { { 0x00, 0x03, 0xD1 }, "Takaya",       "Takaya Corporation" },
    { { 0x00, 0x03, 0xD2 }, "Crossbeam",    "Crossbeam Systems, Inc." },
    { { 0x00, 0x03, 0xD3 }, "InternetEner", "Internet Energy Systems, Inc." },
    { { 0x00, 0x03, 0xD4 }, "Alloptic",     "Alloptic, Inc." },
    { { 0x00, 0x03, 0xD5 }, "AdvancedComm", "Advanced Communications Co., Ltd." },
    { { 0x00, 0x03, 0xD6 }, "RADVision",    "RADVision, Ltd." },
    { { 0x00, 0x03, 0xD7 }, "NextNetWirel", "NextNet Wireless, Inc." },
    { { 0x00, 0x03, 0xD8 }, "iMPathNetwor", "iMPath Networks, Inc." },
    { { 0x00, 0x03, 0xD9 }, "Secheron",     "Secheron SA" },
    { { 0x00, 0x03, 0xDA }, "TakamisawaCy", "Takamisawa Cybernetics Co., Ltd." },
    { { 0x00, 0x03, 0xDB }, "ApogeeElectr", "Apogee Electronics Corp." },
    { { 0x00, 0x03, 0xDC }, "LexarMedia",   "Lexar Media, Inc." },
    { { 0x00, 0x03, 0xDD }, "ComarkIntera", "Comark Interactive Solutions" },
    { { 0x00, 0x03, 0xDE }, "OTCWireless",  "OTC Wireless" },
    { { 0x00, 0x03, 0xDF }, "Desana",       "Desana Systems" },
    { { 0x00, 0x03, 0xE0 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x03, 0xE1 }, "WinmateCommu", "Winmate Communication, Inc." },
    { { 0x00, 0x03, 0xE2 }, "Comspace",     "Comspace Corporation" },
    { { 0x00, 0x03, 0xE3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0xE4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0xE5 }, "HermstedtSG",  "Hermstedt SG" },
    { { 0x00, 0x03, 0xE6 }, "Entone",       "Entone, Inc." },
    { { 0x00, 0x03, 0xE7 }, "Logostek",     "Logostek Co. Ltd." },
    { { 0x00, 0x03, 0xE8 }, "Wavesight",    "Wavesight Limited" },
    { { 0x00, 0x03, 0xE9 }, "AkaraCanada",  "Akara Canada, Inc." },
    { { 0x00, 0x03, 0xEA }, "MegaSystemTe", "Mega System Technologies, Inc." },
    { { 0x00, 0x03, 0xEB }, "Atrica",       "Atrica" },
    { { 0x00, 0x03, 0xEC }, "ICGResearch",  "ICG Research, Inc." },
    { { 0x00, 0x03, 0xED }, "ShinkawaElec", "Shinkawa Electric Co., Ltd." },
    { { 0x00, 0x03, 0xEE }, "MKNet",        "MKNet Corporation" },
    { { 0x00, 0x03, 0xEF }, "Oneline",      "Oneline AG" },
    { { 0x00, 0x03, 0xF0 }, "RedfernBroad", "Redfern Broadband Networks" },
    { { 0x00, 0x03, 0xF1 }, "CicadaSemico", "Cicada Semiconductor, Inc." },
    { { 0x00, 0x03, 0xF2 }, "SenecaNetwor", "Seneca Networks" },
    { { 0x00, 0x03, 0xF3 }, "DazzleMultim", "Dazzle Multimedia, Inc." },
    { { 0x00, 0x03, 0xF4 }, "NetBurner",    "NetBurner" },
    { { 0x00, 0x03, 0xF5 }, "Chip2Chip",    "Chip2Chip" },
    { { 0x00, 0x03, 0xF6 }, "AllegroNetwo", "Allegro Networks, Inc." },
    { { 0x00, 0x03, 0xF7 }, "PlastControl", "Plast-Control GmbH" },
    { { 0x00, 0x03, 0xF8 }, "SanCastleTec", "SanCastle Technologies, Inc." },
    { { 0x00, 0x03, 0xF9 }, "PleiadesComm", "Pleiades Communications, Inc." },
    { { 0x00, 0x03, 0xFA }, "TiMetraNetwo", "TiMetra Networks" },
    { { 0x00, 0x03, 0xFB }, "ENEGATE",      "ENEGATE Co.,Ltd." },
    { { 0x00, 0x03, 0xFC }, "IntertexData", "Intertex Data AB" },
    { { 0x00, 0x03, 0xFD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0xFE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x03, 0xFF }, "Microsoft",    "Microsoft Corporation" },
    { { 0x00, 0x04, 0x00 }, "LexmarkInter", "Lexmark International, Inc." },
    { { 0x00, 0x04, 0x01 }, "OsakiElectri", "Osaki Electric Co., Ltd." },
    { { 0x00, 0x04, 0x02 }, "NexsanTechno", "Nexsan Technologies, Ltd." },
    { { 0x00, 0x04, 0x03 }, "Nexsi",        "Nexsi Corporation" },
    { { 0x00, 0x04, 0x04 }, "MakinoMillin", "Makino Milling Machine Co., Ltd." },
    { { 0x00, 0x04, 0x05 }, "ACNTechnolog", "ACN Technologies" },
    { { 0x00, 0x04, 0x06 }, "FaMetabox",    "Fa. Metabox AG" },
    { { 0x00, 0x04, 0x07 }, "TopconPositi", "Topcon Positioning Systems, Inc." },
    { { 0x00, 0x04, 0x08 }, "SankoElectro", "Sanko Electronics Co., Ltd." },
    { { 0x00, 0x04, 0x09 }, "CratosNetwor", "Cratos Networks" },
    { { 0x00, 0x04, 0x0A }, "Sage",         "Sage Systems" },
    { { 0x00, 0x04, 0x0B }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x04, 0x0C }, "KannoWorks",   "Kanno Works, Ltd." },
    { { 0x00, 0x04, 0x0D }, "Avaya",        "Avaya Inc" },
    { { 0x00, 0x04, 0x0E }, "AVM",          "AVM GmbH" },
    { { 0x00, 0x04, 0x0F }, "AsusNetworkT", "Asus Network Technologies, Inc." },
    { { 0x00, 0x04, 0x10 }, "SpinnakerNet", "Spinnaker Networks, Inc." },
    { { 0x00, 0x04, 0x11 }, "InkraNetwork", "Inkra Networks, Inc." },
    { { 0x00, 0x04, 0x12 }, "WaveSmithNet", "WaveSmith Networks, Inc." },
    { { 0x00, 0x04, 0x13 }, "snomtechnolo", "snom technology GmbH" },
    { { 0x00, 0x04, 0x14 }, "UmezawaMusen", "Umezawa Musen Denki Co., Ltd." },
    { { 0x00, 0x04, 0x15 }, "Rasteme",      "Rasteme Systems Co., Ltd." },
    { { 0x00, 0x04, 0x16 }, "ParksComunic", "Parks S/A Comunicacoes Digitais" },
    { { 0x00, 0x04, 0x17 }, "SchneiderEle", "Schneider Electric" },
    { { 0x00, 0x04, 0x18 }, "TeltronicU",   "Teltronic S.A.U." },
    { { 0x00, 0x04, 0x19 }, "FibercycleNe", "Fibercycle Networks, Inc." },
    { { 0x00, 0x04, 0x1A }, "InesTestandM", "Ines Test and Measurement GmbH & CoKG" },
    { { 0x00, 0x04, 0x1B }, "Bridgeworks",  "Bridgeworks Ltd." },
    { { 0x00, 0x04, 0x1C }, "ipDialog",     "ipDialog, Inc." },
    { { 0x00, 0x04, 0x1D }, "CoregaAmeric", "Corega of America" },
    { { 0x00, 0x04, 0x1E }, "ShikokuInstr", "Shikoku Instrumentation Co., Ltd." },
    { { 0x00, 0x04, 0x1F }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0x04, 0x20 }, "SlimDevices",  "Slim Devices, Inc." },
    { { 0x00, 0x04, 0x21 }, "OcularNetwor", "Ocular Networks" },
    { { 0x00, 0x04, 0x22 }, "StudioTechno", "Studio Technologies, Inc" },
    { { 0x00, 0x04, 0x23 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x04, 0x24 }, "TMC",          "TMC s.r.l." },
    { { 0x00, 0x04, 0x25 }, "Atmel",        "Atmel Corporation" },
    { { 0x00, 0x04, 0x26 }, "Autosys",      "Autosys" },
    { { 0x00, 0x04, 0x27 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x28 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x29 }, "Pixord",       "Pixord Corporation" },
    { { 0x00, 0x04, 0x2A }, "WirelessNetw", "Wireless Networks, Inc." },
    { { 0x00, 0x04, 0x2B }, "ITAccess",     "IT Access Co., Ltd." },
    { { 0x00, 0x04, 0x2C }, "Minet",        "Minet, Inc." },
    { { 0x00, 0x04, 0x2D }, "Sarian",       "Sarian Systems, Ltd." },
    { { 0x00, 0x04, 0x2E }, "NetousTechno", "Netous Technologies, Ltd." },
    { { 0x00, 0x04, 0x2F }, "Internationa", "International Communications Products, Inc." },
    { { 0x00, 0x04, 0x30 }, "Netgem",       "Netgem" },
    { { 0x00, 0x04, 0x31 }, "GlobalStream", "GlobalStreams, Inc." },
    { { 0x00, 0x04, 0x32 }, "VoyetraTurtl", "Voyetra Turtle Beach, Inc." },
    { { 0x00, 0x04, 0x33 }, "Cyberboard",   "Cyberboard A/S" },
    { { 0x00, 0x04, 0x34 }, "Accelent",     "Accelent Systems, Inc." },
    { { 0x00, 0x04, 0x35 }, "InfiNet",      "InfiNet LLC" },
    { { 0x00, 0x04, 0x36 }, "ELANsatTechn", "ELANsat Technologies, Inc." },
    { { 0x00, 0x04, 0x37 }, "PowinInforma", "Powin Information Technology, Inc." },
    { { 0x00, 0x04, 0x38 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x04, 0x39 }, "RoscoEnterta", "Rosco Entertainment Technology, Inc." },
    { { 0x00, 0x04, 0x3A }, "IntelligentT", "Intelligent Telecommunications, Inc." },
    { { 0x00, 0x04, 0x3B }, "LavaComputer", "Lava Computer Mfg., Inc." },
    { { 0x00, 0x04, 0x3C }, "SONOS",        "SONOS Co., Ltd." },
    { { 0x00, 0x04, 0x3D }, "Indel",        "Indel Ag" },
    { { 0x00, 0x04, 0x3E }, "Telencomm",    "Telencomm" },
    { { 0x00, 0x04, 0x3F }, "ESTeemWirele", "ESTeem Wireless Modems, Inc" },
    { { 0x00, 0x04, 0x40 }, "cyberPIXIE",   "cyberPIXIE, Inc." },
    { { 0x00, 0x04, 0x41 }, "HalfDome",     "Half Dome Systems, Inc." },
    { { 0x00, 0x04, 0x42 }, "Nact",         "Nact" },
    { { 0x00, 0x04, 0x43 }, "AgilentTechn", "Agilent Technologies, Inc." },
    { { 0x00, 0x04, 0x44 }, "WesternMulti", "Western Multiplex Corporation" },
    { { 0x00, 0x04, 0x45 }, "LMSSkalarIns", "LMS Skalar Instruments GmbH" },
    { { 0x00, 0x04, 0x46 }, "CYZENTECH",    "CYZENTECH Co., Ltd." },
    { { 0x00, 0x04, 0x47 }, "Acrowave",     "Acrowave Systems Co., Ltd." },
    { { 0x00, 0x04, 0x48 }, "Polaroid",     "Polaroid Corporation" },
    { { 0x00, 0x04, 0x49 }, "MapletreeNet", "Mapletree Networks" },
    { { 0x00, 0x04, 0x4A }, "iPolicyNetwo", "iPolicy Networks, Inc." },
    { { 0x00, 0x04, 0x4B }, "Nvidia",       "Nvidia" },
    { { 0x00, 0x04, 0x4C }, "Jenoptik",     "Jenoptik" },
    { { 0x00, 0x04, 0x4D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x4E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x4F }, "SchubertSyst", "Schubert System Elektronik Gmbh" },
    { { 0x00, 0x04, 0x50 }, "DMDComputers", "DMD Computers SRL" },
    { { 0x00, 0x04, 0x51 }, "Medrad",       "Medrad, Inc." },
    { { 0x00, 0x04, 0x52 }, "RocketLogix",  "RocketLogix, Inc." },
    { { 0x00, 0x04, 0x53 }, "YottaYotta",   "YottaYotta, Inc." },
    { { 0x00, 0x04, 0x54 }, "QuadrigaUK",   "Quadriga UK" },
    { { 0x00, 0x04, 0x55 }, "ANTARAnet",    "ANTARA.net" },
    { { 0x00, 0x04, 0x56 }, "CambiumNetwo", "Cambium Networks Limited" },
    { { 0x00, 0x04, 0x57 }, "UniversalAcc", "Universal Access Technology, Inc." },
    { { 0x00, 0x04, 0x58 }, "FusionX",      "Fusion X Co., Ltd." },
    { { 0x00, 0x04, 0x59 }, "Veristar",     "Veristar Corporation" },
    { { 0x00, 0x04, 0x5A }, "LinksysGroup", "The Linksys Group, Inc." },
    { { 0x00, 0x04, 0x5B }, "TechsanElect", "Techsan Electronics Co., Ltd." },
    { { 0x00, 0x04, 0x5C }, "MobiwavePte",  "Mobiwave Pte Ltd" },
    { { 0x00, 0x04, 0x5D }, "BEKAElektron", "BEKA Elektronik" },
    { { 0x00, 0x04, 0x5E }, "PolyTraxInfo", "PolyTrax Information Technology AG" },
    { { 0x00, 0x04, 0x5F }, "AvalueTechno", "Avalue Technology, Inc." },
    { { 0x00, 0x04, 0x60 }, "KnilinkTechn", "Knilink Technology, Inc." },
    { { 0x00, 0x04, 0x61 }, "EPOXComputer", "EPOX Computer Co., Ltd." },
    { { 0x00, 0x04, 0x62 }, "DAKOSDataCom", "DAKOS Data & Communication Co., Ltd." },
    { { 0x00, 0x04, 0x63 }, "BoschSecurit", "Bosch Security Systems" },
    { { 0x00, 0x04, 0x64 }, "PulseLink",    "Pulse-Link Inc" },
    { { 0x00, 0x04, 0x65 }, "istisdnsuppo", "i.s.t isdn-support technik GmbH" },
    { { 0x00, 0x04, 0x66 }, "ARMITEL",      "ARMITEL Co." },
    { { 0x00, 0x04, 0x67 }, "ResearchInst", "Wuhan Research Institute of MII" },
    { { 0x00, 0x04, 0x68 }, "Vivity",       "Vivity, Inc." },
    { { 0x00, 0x04, 0x69 }, "Innocom",      "Innocom, Inc." },
    { { 0x00, 0x04, 0x6A }, "NaviniNetwor", "Navini Networks" },
    { { 0x00, 0x04, 0x6B }, "PalmWireless", "Palm Wireless, Inc." },
    { { 0x00, 0x04, 0x6C }, "CyberTechnol", "Cyber Technology Co., Ltd." },
    { { 0x00, 0x04, 0x6D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x6E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x6F }, "DigitelIndus", "Digitel S/A Industria Eletronica" },
    { { 0x00, 0x04, 0x70 }, "ipUnplugged",  "ipUnplugged AB" },
    { { 0x00, 0x04, 0x71 }, "IPrad",        "IPrad" },
    { { 0x00, 0x04, 0x72 }, "Telelynx",     "Telelynx, Inc." },
    { { 0x00, 0x04, 0x73 }, "Photonex",     "Photonex Corporation" },
    { { 0x00, 0x04, 0x74 }, "Legrand",      "Legrand" },
    { { 0x00, 0x04, 0x75 }, "3Com",         "3Com" },
    { { 0x00, 0x04, 0x76 }, "3Com",         "3Com" },
    { { 0x00, 0x04, 0x77 }, "Scalant",      "Scalant Systems, Inc." },
    { { 0x00, 0x04, 0x78 }, "GStarTechnol", "G. Star Technology Corporation" },
    { { 0x00, 0x04, 0x79 }, "Radius",       "Radius Co., Ltd." },
    { { 0x00, 0x04, 0x7A }, "AxxessitAsa",  "Axxessit Asa" },
    { { 0x00, 0x04, 0x7B }, "Schlumberger", "Schlumberger" },
    { { 0x00, 0x04, 0x7C }, "Skidata",      "Skidata AG" },
    { { 0x00, 0x04, 0x7D }, "MotorolaSolu", "Motorola Solutions Inc." },
    { { 0x00, 0x04, 0x7E }, "Siqura",       "Siqura B.V." },
    { { 0x00, 0x04, 0x7F }, "ChrMayr",      "Chr. Mayr GmbH & Co. KG" },
    { { 0x00, 0x04, 0x80 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x04, 0x81 }, "EconoliteCon", "Econolite Control Products, Inc." },
    { { 0x00, 0x04, 0x82 }, "Medialogic",   "Medialogic Corp." },
    { { 0x00, 0x04, 0x83 }, "DeltronTechn", "Deltron Technology, Inc." },
    { { 0x00, 0x04, 0x84 }, "Amann",        "Amann GmbH" },
    { { 0x00, 0x04, 0x85 }, "PicoLight",    "PicoLight" },
    { { 0x00, 0x04, 0x86 }, "ITTCUniversi", "ITTC, University of Kansas" },
    { { 0x00, 0x04, 0x87 }, "CogencySemic", "Cogency Semiconductor, Inc." },
    { { 0x00, 0x04, 0x88 }, "EurothermCon", "Eurotherm Controls" },
    { { 0x00, 0x04, 0x89 }, "YAFONetworks", "YAFO Networks, Inc." },
    { { 0x00, 0x04, 0x8A }, "TemiaVertrie", "Temia Vertriebs GmbH" },
    { { 0x00, 0x04, 0x8B }, "Poscon",       "Poscon Corporation" },
    { { 0x00, 0x04, 0x8C }, "NaynaNetwork", "Nayna Networks, Inc." },
    { { 0x00, 0x04, 0x8D }, "TeoTechnolog", "Teo Technologies, Inc" },
    { { 0x00, 0x04, 0x8E }, "OhmTechLabs",  "Ohm Tech Labs, Inc." },
    { { 0x00, 0x04, 0x8F }, "TD",           "TD Systems Corporation" },
    { { 0x00, 0x04, 0x90 }, "OpticalAcces", "Optical Access" },
    { { 0x00, 0x04, 0x91 }, "Technovision", "Technovision, Inc." },
    { { 0x00, 0x04, 0x92 }, "HiveInternet", "Hive Internet, Ltd." },
    { { 0x00, 0x04, 0x93 }, "TsinghuaUnis", "Tsinghua Unisplendour Co., Ltd." },
    { { 0x00, 0x04, 0x94 }, "Breezecom",    "Breezecom, Ltd." },
    { { 0x00, 0x04, 0x95 }, "TejasNetwork", "Tejas Networks India Limited" },
    { { 0x00, 0x04, 0x96 }, "ExtremeNetwo", "Extreme Networks Headquarters" },
    { { 0x00, 0x04, 0x97 }, "MacroSystemD", "MacroSystem Digital Video AG" },
    { { 0x00, 0x04, 0x98 }, "MahiNetworks", "Mahi Networks" },
    { { 0x00, 0x04, 0x99 }, "Chino",        "Chino Corporation" },
    { { 0x00, 0x04, 0x9A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x9B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0x9C }, "SurgientNetw", "Surgient Networks, Inc." },
    { { 0x00, 0x04, 0x9D }, "IpanemaTechn", "Ipanema Technologies" },
    { { 0x00, 0x04, 0x9E }, "Wirelink",     "Wirelink Co., Ltd." },
    { { 0x00, 0x04, 0x9F }, "FreescaleSem", "Freescale Semiconductor" },
    { { 0x00, 0x04, 0xA0 }, "VerityInstru", "Verity Instruments, Inc." },
    { { 0x00, 0x04, 0xA1 }, "PathwayConne", "Pathway Connectivity" },
    { { 0x00, 0x04, 0xA2 }, "LSIJapan",     "L.S.I. Japan Co., Ltd." },
    { { 0x00, 0x04, 0xA3 }, "MicrochipTec", "Microchip Technology Inc." },
    { { 0x00, 0x04, 0xA4 }, "NetEnabled",   "NetEnabled, Inc." },
    { { 0x00, 0x04, 0xA5 }, "Barco",        "Barco NV" },
    { { 0x00, 0x04, 0xA6 }, "SAFTehnika",   "SAF Tehnika Ltd." },
    { { 0x00, 0x04, 0xA7 }, "FabiaTech",    "FabiaTech Corporation" },
    { { 0x00, 0x04, 0xA8 }, "BroadmaxTech", "Broadmax Technologies, Inc." },
    { { 0x00, 0x04, 0xA9 }, "SandStreamTe", "SandStream Technologies, Inc." },
    { { 0x00, 0x04, 0xAA }, "JetstreamCom", "Jetstream Communications" },
    { { 0x00, 0x04, 0xAB }, "Mavenir",      "Mavenir Inc." },
    { { 0x00, 0x04, 0xAC }, "IBM",          "IBM Corp" },
    { { 0x00, 0x04, 0xAD }, "MalibuNetwor", "Malibu Networks" },
    { { 0x00, 0x04, 0xAE }, "Sullair",      "Sullair Corporation" },
    { { 0x00, 0x04, 0xAF }, "DigitalFount", "Digital Fountain, Inc." },
    { { 0x00, 0x04, 0xB0 }, "ELESIGN",      "ELESIGN Co., Ltd." },
    { { 0x00, 0x04, 0xB1 }, "SignalTechno", "Signal Technology, Inc." },
    { { 0x00, 0x04, 0xB2 }, "Essegi",       "Essegi Srl" },
    { { 0x00, 0x04, 0xB3 }, "Videotek",     "Videotek, Inc." },
    { { 0x00, 0x04, 0xB4 }, "Ciac",         "Ciac" },
    { { 0x00, 0x04, 0xB5 }, "Equitrac",     "Equitrac Corporation" },
    { { 0x00, 0x04, 0xB6 }, "StratexNetwo", "Stratex Networks, Inc." },
    { { 0x00, 0x04, 0xB7 }, "AMBit",        "AMB i.t. Holding" },
    { { 0x00, 0x04, 0xB8 }, "Kumahira",     "Kumahira Co., Ltd." },
    { { 0x00, 0x04, 0xB9 }, "SISoubou",     "S.I. Soubou, Inc." },
    { { 0x00, 0x04, 0xBA }, "KDDMediaWill", "KDD Media Will Corporation" },
    { { 0x00, 0x04, 0xBB }, "Bardac",       "Bardac Corporation" },
    { { 0x00, 0x04, 0xBC }, "Giantec",      "Giantec, Inc." },
    { { 0x00, 0x04, 0xBD }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x04, 0xBE }, "OptXCon",      "OptXCon, Inc." },
    { { 0x00, 0x04, 0xBF }, "VersaLogic",   "VersaLogic Corp." },
    { { 0x00, 0x04, 0xC0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0xC1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0xC2 }, "Magnipix",     "Magnipix, Inc." },
    { { 0x00, 0x04, 0xC3 }, "CASTORInform", "CASTOR Informatique" },
    { { 0x00, 0x04, 0xC4 }, "AudiotonixGr", "Audiotonix Group Limited" },
    { { 0x00, 0x04, 0xC5 }, "ASETechnolog", "ASE Technologies, USA" },
    { { 0x00, 0x04, 0xC6 }, "YamahaMotor",  "Yamaha Motor Co.,Ltd" },
    { { 0x00, 0x04, 0xC7 }, "NetMount",     "NetMount" },
    { { 0x00, 0x04, 0xC8 }, "LIBAMaschine", "LIBA Maschinenfabrik GmbH" },
    { { 0x00, 0x04, 0xC9 }, "MicroElectro", "Micro Electron Co., Ltd." },
    { { 0x00, 0x04, 0xCA }, "FreeMs",       "FreeMs Corp." },
    { { 0x00, 0x04, 0xCB }, "TdsoftCommun", "Tdsoft Communication, Ltd." },
    { { 0x00, 0x04, 0xCC }, "PeekTraffic",  "Peek Traffic B.V." },
    { { 0x00, 0x04, 0xCD }, "ExtenwaySolu", "Extenway Solutions Inc" },
    { { 0x00, 0x04, 0xCE }, "PatriaAilon",  "Patria Ailon" },
    { { 0x00, 0x04, 0xCF }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x04, 0xD0 }, "Softlinksro",  "Softlink s.r.o." },
    { { 0x00, 0x04, 0xD1 }, "DrewTechnolo", "Drew Technologies, Inc." },
    { { 0x00, 0x04, 0xD2 }, "AdconTelemet", "Adcon Telemetry GmbH" },
    { { 0x00, 0x04, 0xD3 }, "Toyokeiki",    "Toyokeiki Co., Ltd." },
    { { 0x00, 0x04, 0xD4 }, "ProviewElect", "Proview Electronics Co., Ltd." },
    { { 0x00, 0x04, 0xD5 }, "HitachiInfor", "Hitachi Information & Communication Engineering, Ltd." },
    { { 0x00, 0x04, 0xD6 }, "TakagiIndust", "Takagi Industrial Co., Ltd." },
    { { 0x00, 0x04, 0xD7 }, "OmitecInstru", "Omitec Instrumentation Ltd." },
    { { 0x00, 0x04, 0xD8 }, "IPWireless",   "IPWireless, Inc." },
    { { 0x00, 0x04, 0xD9 }, "TitanElectro", "Titan Electronics, Inc." },
    { { 0x00, 0x04, 0xDA }, "RelaxTechnol", "Relax Technology, Inc." },
    { { 0x00, 0x04, 0xDB }, "TellusGroup",  "Tellus Group Corp." },
    { { 0x00, 0x04, 0xDC }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x04, 0xDD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0xDE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x04, 0xDF }, "TeracomTelem", "Teracom Telematica S.A" },
    { { 0x00, 0x04, 0xE0 }, "ProcketNetwo", "Procket Networks" },
    { { 0x00, 0x04, 0xE1 }, "InfiniorMicr", "Infinior Microsystems" },
    { { 0x00, 0x04, 0xE2 }, "SMCNetworks",  "SMC Networks, Inc." },
    { { 0x00, 0x04, 0xE3 }, "AcctonTechno", "Accton Technology Corp" },
    { { 0x00, 0x04, 0xE4 }, "DaeryungInd",  "Daeryung Ind., Inc." },
    { { 0x00, 0x04, 0xE5 }, "Glonet",       "Glonet Systems, Inc." },
    { { 0x00, 0x04, 0xE6 }, "BanyanNetwor", "Banyan Network Private Limited" },
    { { 0x00, 0x04, 0xE7 }, "LightpointeC", "Lightpointe Communications, Inc" },
    { { 0x00, 0x04, 0xE8 }, "IER",          "IER, Inc." },
    { { 0x00, 0x04, 0xE9 }, "Infiniswitch", "Infiniswitch Corporation" },
    { { 0x00, 0x04, 0xEA }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x04, 0xEB }, "PaxonetCommu", "Paxonet Communications, Inc." },
    { { 0x00, 0x04, 0xEC }, "Memobox",      "Memobox SA" },
    { { 0x00, 0x04, 0xED }, "BillionElect", "Billion Electric Co., Ltd." },
    { { 0x00, 0x04, 0xEE }, "LincolnElect", "Lincoln Electric Company" },
    { { 0x00, 0x04, 0xEF }, "Polestar",     "Polestar Corp." },
    { { 0x00, 0x04, 0xF0 }, "Internationa", "International Computers, Ltd" },
    { { 0x00, 0x04, 0xF1 }, "WhereNet",     "WhereNet" },
    { { 0x00, 0x04, 0xF2 }, "Polycom",      "Polycom" },
    { { 0x00, 0x04, 0xF3 }, "FSFORTHSYSTE", "FS FORTH-SYSTEME GmbH" },
    { { 0x00, 0x04, 0xF4 }, "InfiniteElec", "Infinite Electronics Inc." },
    { { 0x00, 0x04, 0xF5 }, "SnowShoreNet", "SnowShore Networks, Inc." },
    { { 0x00, 0x04, 0xF6 }, "Amphus",       "Amphus" },
    { { 0x00, 0x04, 0xF7 }, "OmegaBand",    "Omega Band, Inc." },
    { { 0x00, 0x04, 0xF8 }, "QUALICABLETV", "QUALICABLE TV Industria E Com., Ltda" },
    { { 0x00, 0x04, 0xF9 }, "XteraCommuni", "Xtera Communications, Inc." },
    { { 0x00, 0x04, 0xFA }, "NBSTechnolog", "NBS Technologies Inc." },
    { { 0x00, 0x04, 0xFB }, "Commtech",     "Commtech, Inc." },
    { { 0x00, 0x04, 0xFC }, "StratusTechn", "Stratus Technologies" },
    { { 0x00, 0x04, 0xFD }, "JapanControl", "Japan Control Engineering Co., Ltd." },
    { { 0x00, 0x04, 0xFE }, "PelagoNetwor", "Pelago Networks" },
    { { 0x00, 0x04, 0xFF }, "Acronet",      "Acronet Co., Ltd." },
    { { 0x00, 0x05, 0x00 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x01 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x02 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x05, 0x03 }, "Iconag",       "Iconag" },
    { { 0x00, 0x05, 0x04 }, "NarayInforma", "Naray Information & Communication Enterprise" },
    { { 0x00, 0x05, 0x05 }, "SystemsInteg", "Systems Integration Solutions, Inc." },
    { { 0x00, 0x05, 0x06 }, "ReddoNetwork", "Reddo Networks AB" },
    { { 0x00, 0x05, 0x07 }, "FineApplianc", "Fine Appliance Corp." },
    { { 0x00, 0x05, 0x08 }, "Inetcam",      "Inetcam, Inc." },
    { { 0x00, 0x05, 0x09 }, "AVOCNishimur", "AVOC Nishimura Ltd." },
    { { 0x00, 0x05, 0x0A }, "ICS",          "ICS Spa" },
    { { 0x00, 0x05, 0x0B }, "SICOM",        "SICOM Systems, Inc." },
    { { 0x00, 0x05, 0x0C }, "NetworkPhoto", "Network Photonics, Inc." },
    { { 0x00, 0x05, 0x0D }, "MidstreamTec", "Midstream Technologies, Inc." },
    { { 0x00, 0x05, 0x0E }, "3ware",        "3ware, Inc." },
    { { 0x00, 0x05, 0x0F }, "TanakaSS",     "Tanaka S/S Ltd." },
    { { 0x00, 0x05, 0x10 }, "InfiniteShan", "Infinite Shanghai Communication Terminals Ltd." },
    { { 0x00, 0x05, 0x11 }, "Complementar", "Complementary Technologies Ltd" },
    { { 0x00, 0x05, 0x12 }, "ZebraTechnol", "Zebra Technologies Inc" },
    { { 0x00, 0x05, 0x13 }, "VTLinxMultim", "VTLinx Multimedia Systems, Inc." },
    { { 0x00, 0x05, 0x14 }, "KDT",          "KDT Systems Co., Ltd." },
    { { 0x00, 0x05, 0x15 }, "Nuark",        "Nuark Co., Ltd." },
    { { 0x00, 0x05, 0x16 }, "SMARTModular", "SMART Modular Technologies" },
    { { 0x00, 0x05, 0x17 }, "Shellcomm",    "Shellcomm, Inc." },
    { { 0x00, 0x05, 0x18 }, "JupitersTech", "Jupiters Technology" },
    { { 0x00, 0x05, 0x19 }, "SiemensBuild", "Siemens Building Technologies AG," },
    { { 0x00, 0x05, 0x1A }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x05, 0x1B }, "MagicControl", "Magic Control Technology Corporation" },
    { { 0x00, 0x05, 0x1C }, "XnetTechnolo", "Xnet Technology Corp." },
    { { 0x00, 0x05, 0x1D }, "Airocon",      "Airocon, Inc." },
    { { 0x00, 0x05, 0x1E }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x05, 0x1F }, "TaijinMedia",  "Taijin Media Co., Ltd." },
    { { 0x00, 0x05, 0x20 }, "Smartronix",   "Smartronix, Inc." },
    { { 0x00, 0x05, 0x21 }, "ControlMicro", "Control Microsystems" },
    { { 0x00, 0x05, 0x22 }, "LEA*D",        "LEA*D Corporation, Inc." },
    { { 0x00, 0x05, 0x23 }, "AVLList",      "AVL List GmbH" },
    { { 0x00, 0x05, 0x24 }, "BTLSystem",    "BTL System (HK) Limited" },
    { { 0x00, 0x05, 0x25 }, "PuretekIndus", "Puretek Industrial Co., Ltd." },
    { { 0x00, 0x05, 0x26 }, "IPAS",         "IPAS GmbH" },
    { { 0x00, 0x05, 0x27 }, "SJTek",        "SJ Tek Co. Ltd" },
    { { 0x00, 0x05, 0x28 }, "NewFocus",     "New Focus, Inc." },
    { { 0x00, 0x05, 0x29 }, "BroadanCommu", "Shanghai Broadan Communication Technology Co., Ltd" },
    { { 0x00, 0x05, 0x2A }, "IkegamiTsush", "Ikegami Tsushinki Co., Ltd." },
    { { 0x00, 0x05, 0x2B }, "HORIBA",       "HORIBA, Ltd." },
    { { 0x00, 0x05, 0x2C }, "SupremeMagic", "Supreme Magic Corporation" },
    { { 0x00, 0x05, 0x2D }, "ZoltrixInter", "Zoltrix International Limited" },
    { { 0x00, 0x05, 0x2E }, "CintaNetwork", "Cinta Networks" },
    { { 0x00, 0x05, 0x2F }, "LevitonNetwo", "Leviton Network Solutions" },
    { { 0x00, 0x05, 0x30 }, "Andiamo",      "Andiamo Systems, Inc." },
    { { 0x00, 0x05, 0x31 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x32 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x33 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x05, 0x34 }, "NorthstarEng", "Northstar Engineering Ltd." },
    { { 0x00, 0x05, 0x35 }, "ChipPC",       "Chip PC Ltd." },
    { { 0x00, 0x05, 0x36 }, "DanamCommuni", "Danam Communications, Inc." },
    { { 0x00, 0x05, 0x37 }, "NetsTechnolo", "Nets Technology Co., Ltd." },
    { { 0x00, 0x05, 0x38 }, "Merilus",      "Merilus, Inc." },
    { { 0x00, 0x05, 0x39 }, "ABrandNewWor", "A Brand New World in Sweden AB" },
    { { 0x00, 0x05, 0x3A }, "WillowglenSe", "Willowglen Services Pte Ltd" },
    { { 0x00, 0x05, 0x3B }, "HarbourNetwo", "Harbour Networks Ltd., Co. Beijing" },
    { { 0x00, 0x05, 0x3C }, "Xircom",       "Xircom" },
    { { 0x00, 0x05, 0x3D }, "Agere",        "Agere Systems" },
    { { 0x00, 0x05, 0x3E }, "KIDSysteme",   "KID Systeme GmbH" },
    { { 0x00, 0x05, 0x3F }, "VisionTek",    "VisionTek, Inc." },
    { { 0x00, 0x05, 0x40 }, "FAST",         "FAST Corporation" },
    { { 0x00, 0x05, 0x41 }, "Advanced",     "Advanced Systems Co., Ltd." },
    { { 0x00, 0x05, 0x42 }, "Otari",        "Otari, Inc." },
    { { 0x00, 0x05, 0x43 }, "IQWireless",   "IQ Wireless GmbH" },
    { { 0x00, 0x05, 0x44 }, "ValleyTechno", "Valley Technologies, Inc." },
    { { 0x00, 0x05, 0x45 }, "InternetPhot", "Internet Photonics" },
    { { 0x00, 0x05, 0x46 }, "KDDINetworkS", "KDDI Network & Solultions Inc." },
    { { 0x00, 0x05, 0x47 }, "StarentNetwo", "Starent Networks" },
    { { 0x00, 0x05, 0x48 }, "Disco",        "Disco Corporation" },
    { { 0x00, 0x05, 0x49 }, "SaliraOptica", "Salira Optical Network Systems" },
    { { 0x00, 0x05, 0x4A }, "ArioDataNetw", "Ario Data Networks, Inc." },
    { { 0x00, 0x05, 0x4B }, "EatonAutomat", "Eaton Automation AG" },
    { { 0x00, 0x05, 0x4C }, "RFInnovation", "RF Innovations Pty Ltd" },
    { { 0x00, 0x05, 0x4D }, "BransTechnol", "Brans Technologies, Inc." },
    { { 0x00, 0x05, 0x4E }, "Philips",      "Philips" },
    { { 0x00, 0x05, 0x4F }, "GarminIntern", "Garmin International" },
    { { 0x00, 0x05, 0x50 }, "VcommsConnec", "Vcomms Connect Limited" },
    { { 0x00, 0x05, 0x51 }, "FSElektronik", "F & S Elektronik Systeme GmbH" },
    { { 0x00, 0x05, 0x52 }, "XycotecCompu", "Xycotec Computer GmbH" },
    { { 0x00, 0x05, 0x53 }, "DVC",          "DVC Company, Inc." },
    { { 0x00, 0x05, 0x54 }, "RangestarWir", "Rangestar Wireless" },
    { { 0x00, 0x05, 0x55 }, "JapanCashMac", "Japan Cash Machine Co., Ltd." },
    { { 0x00, 0x05, 0x56 }, "360",          "360 Systems" },
    { { 0x00, 0x05, 0x57 }, "AgileTV",      "Agile TV Corporation" },
    { { 0x00, 0x05, 0x58 }, "Synchronous",  "Synchronous, Inc." },
    { { 0x00, 0x05, 0x59 }, "Intracom",     "Intracom S.A." },
    { { 0x00, 0x05, 0x5A }, "PowerDsine",   "Power Dsine Ltd." },
    { { 0x00, 0x05, 0x5B }, "CharlesIndus", "Charles Industries, Ltd." },
    { { 0x00, 0x05, 0x5C }, "Kowa",         "Kowa Company, Ltd." },
    { { 0x00, 0x05, 0x5D }, "DLink",        "D-Link Systems, Inc." },
    { { 0x00, 0x05, 0x5E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x5F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x60 }, "LeaderComm",   "Leader Comm.Co., Ltd" },
    { { 0x00, 0x05, 0x61 }, "nacImageTech", "nac Image Technology, Inc." },
    { { 0x00, 0x05, 0x62 }, "DigitalView",  "Digital View Limited" },
    { { 0x00, 0x05, 0x63 }, "JWorks",       "J-Works, Inc." },
    { { 0x00, 0x05, 0x64 }, "TsinghuaBitw", "Tsinghua Bitway Co., Ltd." },
    { { 0x00, 0x05, 0x65 }, "TailynCommun", "Tailyn Communication Company Ltd." },
    { { 0x00, 0x05, 0x66 }, "Secuicom",     "Secui.com Corporation" },
    { { 0x00, 0x05, 0x67 }, "EtymonicDesi", "Etymonic Design, Inc." },
    { { 0x00, 0x05, 0x68 }, "PiltofishNet", "Piltofish Networks AB" },
    { { 0x00, 0x05, 0x69 }, "VMware",       "VMware, Inc." },
    { { 0x00, 0x05, 0x6A }, "HeuftSystemt", "Heuft Systemtechnik GmbH" },
    { { 0x00, 0x05, 0x6B }, "CPTechnology", "C.P. Technology Co., Ltd." },
    { { 0x00, 0x05, 0x6C }, "HungChang",    "Hung Chang Co., Ltd." },
    { { 0x00, 0x05, 0x6D }, "Pacific",      "Pacific Corporation" },
    { { 0x00, 0x05, 0x6E }, "NationalEnha", "National Enhance Technology, Inc." },
    { { 0x00, 0x05, 0x6F }, "InnomediaTec", "Innomedia Technologies Pvt. Ltd." },
    { { 0x00, 0x05, 0x70 }, "Baydel",       "Baydel Ltd." },
    { { 0x00, 0x05, 0x71 }, "SeiwaElectro", "Seiwa Electronics Co." },
    { { 0x00, 0x05, 0x72 }, "Deonet",       "Deonet Co., Ltd." },
    { { 0x00, 0x05, 0x73 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x74 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x75 }, "CDSElectroni", "CDS-Electronics BV" },
    { { 0x00, 0x05, 0x76 }, "NSMTechnolog", "NSM Technology Ltd." },
    { { 0x00, 0x05, 0x77 }, "SMInformatio", "SM Information & Communication" },
    { { 0x00, 0x05, 0x78 }, "Private",      "Private" },
    { { 0x00, 0x05, 0x79 }, "UniversalCon", "Universal Control Solution Corp." },
    { { 0x00, 0x05, 0x7A }, "OvertureNetw", "Overture Networks" },
    { { 0x00, 0x05, 0x7B }, "ChungNamElec", "Chung Nam Electronic Co., Ltd." },
    { { 0x00, 0x05, 0x7C }, "RCOSecurity",  "RCO Security AB" },
    { { 0x00, 0x05, 0x7D }, "SunCommunica", "Sun Communications, Inc." },
    { { 0x00, 0x05, 0x7E }, "Eckelmann",    "Eckelmann AG" },
    { { 0x00, 0x05, 0x7F }, "AcqisTechnol", "Acqis Technology" },
    { { 0x00, 0x05, 0x80 }, "FibroLAN",     "FibroLAN Ltd." },
    { { 0x00, 0x05, 0x81 }, "Snell",        "Snell" },
    { { 0x00, 0x05, 0x82 }, "ClearCubeTec", "ClearCube Technology" },
    { { 0x00, 0x05, 0x83 }, "ImageCom",     "ImageCom Limited" },
    { { 0x00, 0x05, 0x84 }, "AbsoluteValu", "AbsoluteValue Systems, Inc." },
    { { 0x00, 0x05, 0x85 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x05, 0x86 }, "LucentTechno", "Lucent Technologies" },
    { { 0x00, 0x05, 0x87 }, "Locus",        "Locus, Incorporated" },
    { { 0x00, 0x05, 0x88 }, "Sensoria",     "Sensoria Corp." },
    { { 0x00, 0x05, 0x89 }, "NationalData", "National Datacomputer" },
    { { 0x00, 0x05, 0x8A }, "Netcom",       "Netcom Co., Ltd." },
    { { 0x00, 0x05, 0x8B }, "IPmental",     "IPmental, Inc." },
    { { 0x00, 0x05, 0x8C }, "Opentech",     "Opentech Inc." },
    { { 0x00, 0x05, 0x8D }, "LynxPhotonic", "Lynx Photonic Networks, Inc." },
    { { 0x00, 0x05, 0x8E }, "FlextronicsI", "Flextronics International GmbH & Co. Nfg. KG" },
    { { 0x00, 0x05, 0x8F }, "CLCsoft",      "CLCsoft co." },
    { { 0x00, 0x05, 0x90 }, "Swissvoice",   "Swissvoice Ltd." },
    { { 0x00, 0x05, 0x91 }, "ActiveSilico", "Active Silicon Ltd" },
    { { 0x00, 0x05, 0x92 }, "Pultek",       "Pultek Corp." },
    { { 0x00, 0x05, 0x93 }, "GrammarEngin", "Grammar Engine Inc." },
    { { 0x00, 0x05, 0x94 }, "HMSIndustria", "HMS Industrial Networks" },
    { { 0x00, 0x05, 0x95 }, "Alesis",       "Alesis Corporation" },
    { { 0x00, 0x05, 0x96 }, "Genotech",     "Genotech Co., Ltd." },
    { { 0x00, 0x05, 0x97 }, "EagleTraffic", "Eagle Traffic Control Systems" },
    { { 0x00, 0x05, 0x98 }, "CRONOS",       "CRONOS S.r.l." },
    { { 0x00, 0x05, 0x99 }, "DRSTestandEn", "DRS Test and Energy Management or DRS-TEM" },
    { { 0x00, 0x05, 0x9A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x9B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0x9C }, "KleinknechtI", "Kleinknecht GmbH, Ing. Büro" },
    { { 0x00, 0x05, 0x9D }, "DanielComput", "Daniel Computing Systems, Inc." },
    { { 0x00, 0x05, 0x9E }, "Zinwell",      "Zinwell Corporation" },
    { { 0x00, 0x05, 0x9F }, "YottaNetwork", "Yotta Networks, Inc." },
    { { 0x00, 0x05, 0xA0 }, "MOBILINEKft",  "MOBILINE Kft." },
    { { 0x00, 0x05, 0xA1 }, "Zenocom",      "Zenocom" },
    { { 0x00, 0x05, 0xA2 }, "CELOXNetwork", "CELOX Networks" },
    { { 0x00, 0x05, 0xA3 }, "QEI",          "QEI, Inc." },
    { { 0x00, 0x05, 0xA4 }, "LucidVoice",   "Lucid Voice Ltd." },
    { { 0x00, 0x05, 0xA5 }, "Kott",         "Kott" },
    { { 0x00, 0x05, 0xA6 }, "ExtronElectr", "Extron Electronics" },
    { { 0x00, 0x05, 0xA7 }, "HYPERCHIP",    "HYPERCHIP Inc." },
    { { 0x00, 0x05, 0xA8 }, "WyleElectron", "Wyle Electronics" },
    { { 0x00, 0x05, 0xA9 }, "PrincetonNet", "Princeton Networks, Inc." },
    { { 0x00, 0x05, 0xAA }, "MooreIndustr", "Moore Industries International Inc." },
    { { 0x00, 0x05, 0xAB }, "CyberFone",    "Cyber Fone, Inc." },
    { { 0x00, 0x05, 0xAC }, "NorthernDigi", "Northern Digital, Inc." },
    { { 0x00, 0x05, 0xAD }, "TopspinCommu", "Topspin Communications, Inc." },
    { { 0x00, 0x05, 0xAE }, "MediaportUSA", "Mediaport USA" },
    { { 0x00, 0x05, 0xAF }, "InnoScanComp", "InnoScan Computing A/S" },
    { { 0x00, 0x05, 0xB0 }, "KoreaCompute", "Korea Computer Technology Co., Ltd." },
    { { 0x00, 0x05, 0xB1 }, "ASBTechnolog", "ASB Technology BV" },
    { { 0x00, 0x05, 0xB2 }, "Medison",      "Medison Co., Ltd." },
    { { 0x00, 0x05, 0xB3 }, "AsahiEnginee", "Asahi-Engineering Co., Ltd." },
    { { 0x00, 0x05, 0xB4 }, "Aceex",        "Aceex Corporation" },
    { { 0x00, 0x05, 0xB5 }, "BroadcomTech", "Broadcom Technologies" },
    { { 0x00, 0x05, 0xB6 }, "INSYSMicroel", "INSYS Microelectronics GmbH" },
    { { 0x00, 0x05, 0xB7 }, "ArborTechnol", "Arbor Technology Corp." },
    { { 0x00, 0x05, 0xB8 }, "ElectronicDe", "Electronic Design Associates, Inc." },
    { { 0x00, 0x05, 0xB9 }, "Airvana",      "Airvana, Inc." },
    { { 0x00, 0x05, 0xBA }, "AreaNetwoeks", "Area Netwoeks, Inc." },
    { { 0x00, 0x05, 0xBB }, "Myspace",      "Myspace AB" },
    { { 0x00, 0x05, 0xBC }, "ResourceData", "Resource Data Management Ltd" },
    { { 0x00, 0x05, 0xBD }, "Roax",         "Roax Bv" },
    { { 0x00, 0x05, 0xBE }, "KongsbergSea", "Kongsberg Seatex AS" },
    { { 0x00, 0x05, 0xBF }, "JustEzyTechn", "JustEzy Technology, Inc." },
    { { 0x00, 0x05, 0xC0 }, "DigitalNetwo", "Digital Network Alacarte Co., Ltd." },
    { { 0x00, 0x05, 0xC1 }, "AKyungMotion", "A-Kyung Motion, Inc." },
    { { 0x00, 0x05, 0xC2 }, "Soronti",      "Soronti, Inc." },
    { { 0x00, 0x05, 0xC3 }, "PacificInstr", "Pacific Instruments, Inc." },
    { { 0x00, 0x05, 0xC4 }, "Telect",       "Telect, Inc." },
    { { 0x00, 0x05, 0xC5 }, "FlagaHF",      "Flaga HF" },
    { { 0x00, 0x05, 0xC6 }, "TrizCommunic", "Triz Communications" },
    { { 0x00, 0x05, 0xC7 }, "IFCom",        "I/F-Com A/S" },
    { { 0x00, 0x05, 0xC8 }, "Verytech",     "Verytech" },
    { { 0x00, 0x05, 0xC9 }, "LGInnotek",    "LG Innotek" },
    { { 0x00, 0x05, 0xCA }, "HitronTechno", "Hitron Technology, Inc." },
    { { 0x00, 0x05, 0xCB }, "ROISTechnolo", "ROIS Technologies, Inc." },
    { { 0x00, 0x05, 0xCC }, "SumtelCommun", "Sumtel Communications, Inc." },
    { { 0x00, 0x05, 0xCD }, "D&MHoldings",  "D&M Holdings Inc." },
    { { 0x00, 0x05, 0xCE }, "ProlinkMicro", "Prolink Microsystems Corporation" },
    { { 0x00, 0x05, 0xCF }, "ThunderRiver", "Thunder River Technologies, Inc." },
    { { 0x00, 0x05, 0xD0 }, "Solinet",      "Solinet Systems" },
    { { 0x00, 0x05, 0xD1 }, "MetavectorTe", "Metavector Technologies" },
    { { 0x00, 0x05, 0xD2 }, "DAPTechnolog", "DAP Technologies" },
    { { 0x00, 0x05, 0xD3 }, "eProductionS", "eProduction Solutions, Inc." },
    { { 0x00, 0x05, 0xD4 }, "FutureSmartN", "FutureSmart Networks, Inc." },
    { { 0x00, 0x05, 0xD5 }, "SpeedcomWire", "Speedcom Wireless" },
    { { 0x00, 0x05, 0xD6 }, "L3Linkabit",   "L-3 Linkabit" },
    { { 0x00, 0x05, 0xD7 }, "VistaImaging", "Vista Imaging, Inc." },
    { { 0x00, 0x05, 0xD8 }, "Arescom",      "Arescom, Inc." },
    { { 0x00, 0x05, 0xD9 }, "TechnoValley", "Techno Valley, Inc." },
    { { 0x00, 0x05, 0xDA }, "ApexAutomati", "Apex Automationstechnik" },
    { { 0x00, 0x05, 0xDB }, "PSINentec",    "PSI Nentec GmbH" },
    { { 0x00, 0x05, 0xDC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0xDD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x05, 0xDE }, "GiFoneKorea",  "Gi Fone Korea, Inc." },
    { { 0x00, 0x05, 0xDF }, "ElectronicIn", "Electronic Innovation, Inc." },
    { { 0x00, 0x05, 0xE0 }, "Empirix",      "Empirix Corp." },
    { { 0x00, 0x05, 0xE1 }, "TrellisPhoto", "Trellis Photonics, Ltd." },
    { { 0x00, 0x05, 0xE2 }, "CreativNetwo", "Creativ Network Technologies" },
    { { 0x00, 0x05, 0xE3 }, "LightSandCom", "LightSand Communications, Inc." },
    { { 0x00, 0x05, 0xE4 }, "RedLionContr", "Red Lion Controls Inc." },
    { { 0x00, 0x05, 0xE5 }, "Renishaw",     "Renishaw PLC" },
    { { 0x00, 0x05, 0xE6 }, "Egenera",      "Egenera, Inc." },
    { { 0x00, 0x05, 0xE7 }, "NetrakeanAud", "Netrake an AudioCodes Company" },
    { { 0x00, 0x05, 0xE8 }, "TurboWave",    "TurboWave, Inc." },
    { { 0x00, 0x05, 0xE9 }, "UnicessNetwo", "Unicess Network, Inc." },
    { { 0x00, 0x05, 0xEA }, "Rednix",       "Rednix" },
    { { 0x00, 0x05, 0xEB }, "BlueRidgeNet", "Blue Ridge Networks, Inc." },
    { { 0x00, 0x05, 0xEC }, "Mosaic",       "Mosaic Systems Inc." },
    { { 0x00, 0x05, 0xED }, "TechnikumJoa", "Technikum Joanneum GmbH" },
    { { 0x00, 0x05, 0xEE }, "VanderbiltIn", "Vanderbilt International (SWE) AB" },
    { { 0x00, 0x05, 0xEF }, "ADOIRDigital", "ADOIR Digital Technology" },
    { { 0x00, 0x05, 0xF0 }, "Satec",        "Satec" },
    { { 0x00, 0x05, 0xF1 }, "Vrcom",        "Vrcom, Inc." },
    { { 0x00, 0x05, 0xF2 }, "PowerR",       "Power R, Inc." },
    { { 0x00, 0x05, 0xF3 }, "Webyn",        "Webyn" },
    { { 0x00, 0x05, 0xF4 }, "SystemBase",   "System Base Co., Ltd." },
    { { 0x00, 0x05, 0xF5 }, "GeospaceTech", "Geospace Technologies" },
    { { 0x00, 0x05, 0xF6 }, "YoungChang",   "Young Chang Co. Ltd." },
    { { 0x00, 0x05, 0xF7 }, "AnalogDevice", "Analog Devices, Inc." },
    { { 0x00, 0x05, 0xF8 }, "RealTimeAcce", "Real Time Access, Inc." },
    { { 0x00, 0x05, 0xF9 }, "TOA",          "TOA Corporation" },
    { { 0x00, 0x05, 0xFA }, "IPOptical",    "IPOptical, Inc." },
    { { 0x00, 0x05, 0xFB }, "ShareGate",    "ShareGate, Inc." },
    { { 0x00, 0x05, 0xFC }, "SchenckPegas", "Schenck Pegasus Corp." },
    { { 0x00, 0x05, 0xFD }, "PacketLightN", "PacketLight Networks Ltd." },
    { { 0x00, 0x05, 0xFE }, "Traficon",     "Traficon N.V." },
    { { 0x00, 0x05, 0xFF }, "SNSSolutions", "SNS Solutions, Inc." },
    { { 0x00, 0x06, 0x00 }, "ToshibaTeli",  "Toshiba Teli Corporation" },
    { { 0x00, 0x06, 0x01 }, "Otanikeiki",   "Otanikeiki Co., Ltd." },
    { { 0x00, 0x06, 0x02 }, "CirkitechEle", "Cirkitech Electronics Co." },
    { { 0x00, 0x06, 0x03 }, "BakerHughes",  "Baker Hughes Inc." },
    { { 0x00, 0x06, 0x04 }, "@TrackCommun", "@Track Communications, Inc." },
    { { 0x00, 0x06, 0x05 }, "InncomIntern", "Inncom International, Inc." },
    { { 0x00, 0x06, 0x06 }, "RapidWAN",     "RapidWAN, Inc." },
    { { 0x00, 0x06, 0x07 }, "OmniDirectio", "Omni Directional Control Technology Inc." },
    { { 0x00, 0x06, 0x08 }, "AtSkySAS",     "At-Sky SAS" },
    { { 0x00, 0x06, 0x09 }, "Crossport",    "Crossport Systems" },
    { { 0x00, 0x06, 0x0A }, "Blue2space",   "Blue2space" },
    { { 0x00, 0x06, 0x0B }, "ArtesynEmbed", "Artesyn Embedded Technologies" },
    { { 0x00, 0x06, 0x0C }, "MelcoIndustr", "Melco Industries, Inc." },
    { { 0x00, 0x06, 0x0D }, "Wave7Optics",  "Wave7 Optics" },
    { { 0x00, 0x06, 0x0E }, "IGYS",         "IGYS Systems, Inc." },
    { { 0x00, 0x06, 0x0F }, "NaradNetwork", "Narad Networks Inc" },
    { { 0x00, 0x06, 0x10 }, "AbeonaNetwor", "Abeona Networks Inc" },
    { { 0x00, 0x06, 0x11 }, "ZeusWireless", "Zeus Wireless, Inc." },
    { { 0x00, 0x06, 0x12 }, "Accusys",      "Accusys, Inc." },
    { { 0x00, 0x06, 0x13 }, "KawasakiMicr", "Kawasaki Microelectronics Incorporated" },
    { { 0x00, 0x06, 0x14 }, "PrismHolding", "Prism Holdings" },
    { { 0x00, 0x06, 0x15 }, "KimotoElectr", "Kimoto Electric Co., Ltd." },
    { { 0x00, 0x06, 0x16 }, "TelNet",       "Tel Net Co., Ltd." },
    { { 0x00, 0x06, 0x17 }, "Redswitch",    "Redswitch Inc." },
    { { 0x00, 0x06, 0x18 }, "DigiPowerMan", "DigiPower Manufacturing Inc." },
    { { 0x00, 0x06, 0x19 }, "ConnectionTe", "Connection Technology Systems" },
    { { 0x00, 0x06, 0x1A }, "Zetari",       "Zetari Inc." },
    { { 0x00, 0x06, 0x1B }, "NotebookDeve", "Notebook Development Lab. Lenovo Japan Ltd." },
    { { 0x00, 0x06, 0x1C }, "HoshinoMetal", "Hoshino Metal Industries, Ltd." },
    { { 0x00, 0x06, 0x1D }, "MIPTelecom",   "MIP Telecom, Inc." },
    { { 0x00, 0x06, 0x1E }, "Maxan",        "Maxan Systems" },
    { { 0x00, 0x06, 0x1F }, "VisionCompon", "Vision Components GmbH" },
    { { 0x00, 0x06, 0x20 }, "SerialSystem", "Serial System Ltd." },
    { { 0x00, 0x06, 0x21 }, "Hinox",        "Hinox, Co., Ltd." },
    { { 0x00, 0x06, 0x22 }, "ChungFuChenY", "Chung Fu Chen Yeh Enterprise Corp." },
    { { 0x00, 0x06, 0x23 }, "MGEUPSFrance", "MGE UPS Systems France" },
    { { 0x00, 0x06, 0x24 }, "GentnerCommu", "Gentner Communications Corp." },
    { { 0x00, 0x06, 0x25 }, "LinksysGroup", "The Linksys Group, Inc." },
    { { 0x00, 0x06, 0x26 }, "MWE",          "MWE GmbH" },
    { { 0x00, 0x06, 0x27 }, "UniwideTechn", "Uniwide Technologies, Inc." },
    { { 0x00, 0x06, 0x28 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0x29 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x06, 0x2A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0x2B }, "IntraserverT", "Intraserver Technology" },
    { { 0x00, 0x06, 0x2C }, "BivioNetwork", "Bivio Networks" },
    { { 0x00, 0x06, 0x2D }, "TouchStarTec", "TouchStar Technologies, L.L.C." },
    { { 0x00, 0x06, 0x2E }, "AristosLogic", "Aristos Logic Corp." },
    { { 0x00, 0x06, 0x2F }, "Pivotech",     "Pivotech Systems Inc." },
    { { 0x00, 0x06, 0x30 }, "AdtranzSwede", "Adtranz Sweden" },
    { { 0x00, 0x06, 0x31 }, "Calix",        "Calix Inc." },
    { { 0x00, 0x06, 0x32 }, "MescoEnginee", "Mesco Engineering GmbH" },
    { { 0x00, 0x06, 0x33 }, "CrossmatchTe", "Crossmatch Technologies/HID Global" },
    { { 0x00, 0x06, 0x34 }, "GTEAirfone",   "GTE Airfone Inc." },
    { { 0x00, 0x06, 0x35 }, "PacketAirNet", "PacketAir Networks, Inc." },
    { { 0x00, 0x06, 0x36 }, "JedaiBroadba", "Jedai Broadband Networks" },
    { { 0x00, 0x06, 0x37 }, "ToptrendMeta", "Toptrend-Meta Information (ShenZhen) Inc." },
    { { 0x00, 0x06, 0x38 }, "SungjinC&C",   "Sungjin C&C Co., Ltd." },
    { { 0x00, 0x06, 0x39 }, "Newtec",       "Newtec" },
    { { 0x00, 0x06, 0x3A }, "DuraMicro",    "Dura Micro, Inc." },
    { { 0x00, 0x06, 0x3B }, "ArcturusNetw", "Arcturus Networks Inc." },
    { { 0x00, 0x06, 0x3C }, "IntrinsycSof", "Intrinsyc Software International Inc." },
    { { 0x00, 0x06, 0x3D }, "MicrowaveDat", "Microwave Data Systems Inc." },
    { { 0x00, 0x06, 0x3E }, "Opthos",       "Opthos Inc." },
    { { 0x00, 0x06, 0x3F }, "EverexCommun", "Everex Communications Inc." },
    { { 0x00, 0x06, 0x40 }, "WhiteRockNet", "White Rock Networks" },
    { { 0x00, 0x06, 0x41 }, "Itcn",         "Itcn" },
    { { 0x00, 0x06, 0x42 }, "Genetel",      "Genetel Systems Inc." },
    { { 0x00, 0x06, 0x43 }, "SONOComputer", "SONO Computer Co., Ltd." },
    { { 0x00, 0x06, 0x44 }, "NextGenBusin", "NextGen Business Solutions, Inc" },
    { { 0x00, 0x06, 0x45 }, "MeiseiElectr", "Meisei Electric Co. Ltd." },
    { { 0x00, 0x06, 0x46 }, "XunBaoNetwor", "ShenZhen XunBao Network Technology Co Ltd" },
    { { 0x00, 0x06, 0x47 }, "Etrali",       "Etrali S.A." },
    { { 0x00, 0x06, 0x48 }, "Seedsware",    "Seedsware, Inc." },
    { { 0x00, 0x06, 0x49 }, "3MDeutschlan", "3M Deutschland GmbH" },
    { { 0x00, 0x06, 0x4A }, "Honeywell",    "Honeywell Co., Ltd. (KOREA)" },
    { { 0x00, 0x06, 0x4B }, "Alexon",       "Alexon Co., Ltd." },
    { { 0x00, 0x06, 0x4C }, "InvictaNetwo", "Invicta Networks, Inc." },
    { { 0x00, 0x06, 0x4D }, "Sencore",      "Sencore" },
    { { 0x00, 0x06, 0x4E }, "BroadNetTech", "Broad Net Technology Inc." },
    { { 0x00, 0x06, 0x4F }, "PRONETSTechn", "PRO-NETS Technology Corporation" },
    { { 0x00, 0x06, 0x50 }, "TiburonNetwo", "Tiburon Networks, Inc." },
    { { 0x00, 0x06, 0x51 }, "AspenNetwork", "Aspen Networks Inc." },
    { { 0x00, 0x06, 0x52 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0x53 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0x54 }, "WinpresaBuil", "Winpresa Building Automation Technologies GmbH" },
    { { 0x00, 0x06, 0x55 }, "Yipee",        "Yipee, Inc." },
    { { 0x00, 0x06, 0x56 }, "Tactel",       "Tactel AB" },
    { { 0x00, 0x06, 0x57 }, "MarketCentra", "Market Central, Inc." },
    { { 0x00, 0x06, 0x58 }, "HelmutFische", "Helmut Fischer GmbH Institut für Elektronik und Messtechnik" },
    { { 0x00, 0x06, 0x59 }, "EAL",          "EAL (Apeldoorn) B.V." },
    { { 0x00, 0x06, 0x5A }, "Strix",        "Strix Systems" },
    { { 0x00, 0x06, 0x5B }, "Dell",         "Dell Inc." },
    { { 0x00, 0x06, 0x5C }, "MalachiteTec", "Malachite Technologies, Inc." },
    { { 0x00, 0x06, 0x5D }, "HeidelbergWe", "Heidelberg Web Systems" },
    { { 0x00, 0x06, 0x5E }, "Photuris",     "Photuris, Inc." },
    { { 0x00, 0x06, 0x5F }, "ECITelecom",   "ECI Telecom Ltd." },
    { { 0x00, 0x06, 0x60 }, "NADEX",        "NADEX Co., Ltd." },
    { { 0x00, 0x06, 0x61 }, "NIAHomeTechn", "NIA Home Technologies Corp." },
    { { 0x00, 0x06, 0x62 }, "MBMTechnolog", "MBM Technology Ltd." },
    { { 0x00, 0x06, 0x63 }, "HumanTechnol", "Human Technology Co., Ltd." },
    { { 0x00, 0x06, 0x64 }, "Fostex",       "Fostex Corporation" },
    { { 0x00, 0x06, 0x65 }, "SunnyGiken",   "Sunny Giken, Inc." },
    { { 0x00, 0x06, 0x66 }, "RovingNetwor", "Roving Networks" },
    { { 0x00, 0x06, 0x67 }, "TrippLite",    "Tripp Lite" },
    { { 0x00, 0x06, 0x68 }, "ViconIndustr", "Vicon Industries Inc." },
    { { 0x00, 0x06, 0x69 }, "DatasoundLab", "Datasound Laboratories Ltd" },
    { { 0x00, 0x06, 0x6A }, "InfiniCon",    "InfiniCon Systems, Inc." },
    { { 0x00, 0x06, 0x6B }, "Sysmex",       "Sysmex Corporation" },
    { { 0x00, 0x06, 0x6C }, "Robinson",     "Robinson Corporation" },
    { { 0x00, 0x06, 0x6D }, "Compuprint",   "Compuprint S.P.A." },
    { { 0x00, 0x06, 0x6E }, "DeltaElectro", "Delta Electronics, Inc." },
    { { 0x00, 0x06, 0x6F }, "KoreaData",    "Korea Data Systems" },
    { { 0x00, 0x06, 0x70 }, "Upponetti",    "Upponetti Oy" },
    { { 0x00, 0x06, 0x71 }, "Softing",      "Softing AG" },
    { { 0x00, 0x06, 0x72 }, "Netezza",      "Netezza" },
    { { 0x00, 0x06, 0x73 }, "TKHSecurityS", "TKH Security Solutions USA" },
    { { 0x00, 0x06, 0x74 }, "SpectrumCont", "Spectrum Control, Inc." },
    { { 0x00, 0x06, 0x75 }, "Banderacom",   "Banderacom, Inc." },
    { { 0x00, 0x06, 0x76 }, "NovraTechnol", "Novra Technologies Inc." },
    { { 0x00, 0x06, 0x77 }, "Sick",         "Sick Ag" },
    { { 0x00, 0x06, 0x78 }, "D&MHoldings",  "D&M Holdings Inc." },
    { { 0x00, 0x06, 0x79 }, "Konami",       "Konami Corporation" },
    { { 0x00, 0x06, 0x7A }, "JMP",          "JMP Systems" },
    { { 0x00, 0x06, 0x7B }, "ToplinkC&C",   "Toplink C&C Corporation" },
    { { 0x00, 0x06, 0x7C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0x7D }, "Takasago",     "Takasago Ltd." },
    { { 0x00, 0x06, 0x7E }, "WinCom",       "WinCom Systems, Inc." },
    { { 0x00, 0x06, 0x7F }, "Digeo",        "Digeo, Inc." },
    { { 0x00, 0x06, 0x80 }, "CardAccess",   "Card Access, Inc." },
    { { 0x00, 0x06, 0x81 }, "GoepelElectr", "Goepel Electronic GmbH" },
    { { 0x00, 0x06, 0x82 }, "Convedia",     "Convedia" },
    { { 0x00, 0x06, 0x83 }, "BravaraCommu", "Bravara Communications, Inc." },
    { { 0x00, 0x06, 0x84 }, "Biacore",      "Biacore AB" },
    { { 0x00, 0x06, 0x85 }, "NetNearU",     "NetNearU Corporation" },
    { { 0x00, 0x06, 0x86 }, "ZARDCOM",      "ZARDCOM Co., Ltd." },
    { { 0x00, 0x06, 0x87 }, "OmnitronTech", "Omnitron Systems Technology, Inc." },
    { { 0x00, 0x06, 0x88 }, "TelwaysCommu", "Telways Communication Co., Ltd." },
    { { 0x00, 0x06, 0x89 }, "yLezTechnolo", "yLez Technologies Pte Ltd" },
    { { 0x00, 0x06, 0x8A }, "NeuronNetR&D", "NeuronNet Co. Ltd. R&D Center" },
    { { 0x00, 0x06, 0x8B }, "AirRunnerTec", "AirRunner Technologies, Inc." },
    { { 0x00, 0x06, 0x8C }, "3Com",         "3Com" },
    { { 0x00, 0x06, 0x8D }, "SEPATON",      "SEPATON, Inc." },
    { { 0x00, 0x06, 0x8E }, "HID",          "HID Corporation" },
    { { 0x00, 0x06, 0x8F }, "Telemonitor",  "Telemonitor, Inc." },
    { { 0x00, 0x06, 0x90 }, "EuracomCommu", "Euracom Communication GmbH" },
    { { 0x00, 0x06, 0x91 }, "PTInovacao",   "PT Inovacao" },
    { { 0x00, 0x06, 0x92 }, "IntruvertNet", "Intruvert Networks, Inc." },
    { { 0x00, 0x06, 0x93 }, "FlexusComput", "Flexus Computer Technology, Inc." },
    { { 0x00, 0x06, 0x94 }, "Mobillian",    "Mobillian Corporation" },
    { { 0x00, 0x06, 0x95 }, "EnsureTechno", "Ensure Technologies, Inc." },
    { { 0x00, 0x06, 0x96 }, "AdventNetwor", "Advent Networks" },
    { { 0x00, 0x06, 0x97 }, "RDCenter",     "R & D Center" },
    { { 0x00, 0x06, 0x98 }, "egnite",       "egnite GmbH" },
    { { 0x00, 0x06, 0x99 }, "VidaDesign",   "Vida Design Co." },
    { { 0x00, 0x06, 0x9A }, "eTel",         "e & Tel" },
    { { 0x00, 0x06, 0x9B }, "AVTAudioVide", "AVT Audio Video Technologies GmbH" },
    { { 0x00, 0x06, 0x9C }, "Transmode",    "Transmode Systems AB" },
    { { 0x00, 0x06, 0x9D }, "Petards",      "Petards Ltd" },
    { { 0x00, 0x06, 0x9E }, "UNIQA",        "UNIQA, Inc." },
    { { 0x00, 0x06, 0x9F }, "KuokoaNetwor", "Kuokoa Networks" },
    { { 0x00, 0x06, 0xA0 }, "MxImaging",    "Mx Imaging" },
    { { 0x00, 0x06, 0xA1 }, "CelsianTechn", "Celsian Technologies, Inc." },
    { { 0x00, 0x06, 0xA2 }, "Microtune",    "Microtune, Inc." },
    { { 0x00, 0x06, 0xA3 }, "Bitran",       "Bitran Corporation" },
    { { 0x00, 0x06, 0xA4 }, "INNOWELL",     "INNOWELL Corp." },
    { { 0x00, 0x06, 0xA5 }, "PINON",        "PINON Corp." },
    { { 0x00, 0x06, 0xA6 }, "ArtisticLice", "Artistic Licence Engineering Ltd" },
    { { 0x00, 0x06, 0xA7 }, "Primarion",    "Primarion" },
    { { 0x00, 0x06, 0xA8 }, "KCTechnology", "KC Technology, Inc." },
    { { 0x00, 0x06, 0xA9 }, "UniversalIns", "Universal Instruments Corp." },
    { { 0x00, 0x06, 0xAA }, "VTMiltope",    "VT Miltope" },
    { { 0x00, 0x06, 0xAB }, "WLink",        "W-Link Systems, Inc." },
    { { 0x00, 0x06, 0xAC }, "Intersoft",    "Intersoft Co." },
    { { 0x00, 0x06, 0xAD }, "KBElectronic", "KB Electronics Ltd." },
    { { 0x00, 0x06, 0xAE }, "HimachalFutu", "Himachal Futuristic Communications Ltd" },
    { { 0x00, 0x06, 0xAF }, "XaltedNetwor", "Xalted Networks" },
    { { 0x00, 0x06, 0xB0 }, "ComtechEFDat", "Comtech EF Data Corp." },
    { { 0x00, 0x06, 0xB1 }, "Sonicwall",    "Sonicwall" },
    { { 0x00, 0x06, 0xB2 }, "Linxtek",      "Linxtek Co." },
    { { 0x00, 0x06, 0xB3 }, "Diagraph",     "Diagraph Corporation" },
    { { 0x00, 0x06, 0xB4 }, "VorneIndustr", "Vorne Industries, Inc." },
    { { 0x00, 0x06, 0xB5 }, "SourcePhoton", "Source Photonics, Inc." },
    { { 0x00, 0x06, 0xB6 }, "NirOrIsrael",  "Nir-Or Israel Ltd." },
    { { 0x00, 0x06, 0xB7 }, "TELEM",        "TELEM GmbH" },
    { { 0x00, 0x06, 0xB8 }, "Bandspeed",    "Bandspeed Pty Ltd" },
    { { 0x00, 0x06, 0xB9 }, "A5TEK",        "A5TEK Corp." },
    { { 0x00, 0x06, 0xBA }, "WestwaveComm", "Westwave Communications" },
    { { 0x00, 0x06, 0xBB }, "ATITechnolog", "ATI Technologies Inc." },
    { { 0x00, 0x06, 0xBC }, "Macrolink",    "Macrolink, Inc." },
    { { 0x00, 0x06, 0xBD }, "BNTECHNOLOGY", "BNTECHNOLOGY Co., Ltd." },
    { { 0x00, 0x06, 0xBE }, "BaumerOptron", "Baumer Optronic GmbH" },
    { { 0x00, 0x06, 0xBF }, "AccellaTechn", "Accella Technologies Co., Ltd." },
    { { 0x00, 0x06, 0xC0 }, "UnitedIntern", "United Internetworks, Inc." },
    { { 0x00, 0x06, 0xC1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0xC2 }, "Smartmatic",   "Smartmatic Corporation" },
    { { 0x00, 0x06, 0xC3 }, "SchindlerEle", "Schindler Elevator Ltd." },
    { { 0x00, 0x06, 0xC4 }, "Piolink",      "Piolink Inc." },
    { { 0x00, 0x06, 0xC5 }, "INNOVITechno", "INNOVI Technologies Limited" },
    { { 0x00, 0x06, 0xC6 }, "lesswire",     "lesswire AG" },
    { { 0x00, 0x06, 0xC7 }, "RFNETTechnol", "RFNET Technologies Pte Ltd (S)" },
    { { 0x00, 0x06, 0xC8 }, "SumitomoMeta", "Sumitomo Metal Micro Devices, Inc." },
    { { 0x00, 0x06, 0xC9 }, "TechnicalMar", "Technical Marketing Research, Inc." },
    { { 0x00, 0x06, 0xCA }, "AmericanComp", "American Computer & Digital Components, Inc. (ACDC)" },
    { { 0x00, 0x06, 0xCB }, "JotronElectr", "Jotron Electronics A/S" },
    { { 0x00, 0x06, 0xCC }, "JMIElectroni", "JMI Electronics Co., Ltd." },
    { { 0x00, 0x06, 0xCD }, "LeafImaging",  "Leaf Imaging Ltd." },
    { { 0x00, 0x06, 0xCE }, "Dateno",       "Dateno" },
    { { 0x00, 0x06, 0xCF }, "ThalesAvioni", "Thales Avionics In-Flight Systems, LLC" },
    { { 0x00, 0x06, 0xD0 }, "ElgarElectro", "Elgar Electronics Corp." },
    { { 0x00, 0x06, 0xD1 }, "TahoeNetwork", "Tahoe Networks, Inc." },
    { { 0x00, 0x06, 0xD2 }, "TundraSemico", "Tundra Semiconductor Corp." },
    { { 0x00, 0x06, 0xD3 }, "AlphaTelecom", "Alpha Telecom, Inc. U.S.A." },
    { { 0x00, 0x06, 0xD4 }, "InteractiveO", "Interactive Objects, Inc." },
    { { 0x00, 0x06, 0xD5 }, "Diamond",      "Diamond Systems Corp." },
    { { 0x00, 0x06, 0xD6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0xD7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0xD8 }, "MapleOptical", "Maple Optical Systems" },
    { { 0x00, 0x06, 0xD9 }, "IPMNet",       "IPM-Net S.p.A." },
    { { 0x00, 0x06, 0xDA }, "ITRANCommuni", "ITRAN Communications Ltd." },
    { { 0x00, 0x06, 0xDB }, "ICHIPS",       "ICHIPS Co., Ltd." },
    { { 0x00, 0x06, 0xDC }, "SyabasTechno", "Syabas Technology (Amquest)" },
    { { 0x00, 0x06, 0xDD }, "ATTLaborator", "AT & T Laboratories - Cambridge Ltd" },
    { { 0x00, 0x06, 0xDE }, "FlashTechnol", "Flash Technology" },
    { { 0x00, 0x06, 0xDF }, "AIDONIC",      "AIDONIC Corporation" },
    { { 0x00, 0x06, 0xE0 }, "MAT",          "MAT Co., Ltd." },
    { { 0x00, 0x06, 0xE1 }, "TechnoTrade",  "Techno Trade s.a" },
    { { 0x00, 0x06, 0xE2 }, "CeemaxTechno", "Ceemax Technology Co., Ltd." },
    { { 0x00, 0x06, 0xE3 }, "Quantitative", "Quantitative Imaging Corporation" },
    { { 0x00, 0x06, 0xE4 }, "CitelTechnol", "Citel Technologies Ltd." },
    { { 0x00, 0x06, 0xE5 }, "FujianNewlan", "Fujian Newland Computer Ltd. Co." },
    { { 0x00, 0x06, 0xE6 }, "DongYangTele", "DongYang Telecom Co., Ltd." },
    { { 0x00, 0x06, 0xE7 }, "BitBlitzComm", "Bit Blitz Communications Inc." },
    { { 0x00, 0x06, 0xE8 }, "OpticalNetwo", "Optical Network Testing, Inc." },
    { { 0x00, 0x06, 0xE9 }, "Intime",       "Intime Corp." },
    { { 0x00, 0x06, 0xEA }, "ELZET80Mikro", "ELZET80 Mikrocomputer GmbH&Co. KG" },
    { { 0x00, 0x06, 0xEB }, "GlobalData",   "Global Data" },
    { { 0x00, 0x06, 0xEC }, "Harris",       "Harris Corporation" },
    { { 0x00, 0x06, 0xED }, "InaraNetwork", "Inara Networks" },
    { { 0x00, 0x06, 0xEE }, "ShenyangNeue", "Shenyang Neu-era Information & Technology Stock Co., Ltd" },
    { { 0x00, 0x06, 0xEF }, "Maxxan",       "Maxxan Systems, Inc." },
    { { 0x00, 0x06, 0xF0 }, "Digeo",        "Digeo, Inc." },
    { { 0x00, 0x06, 0xF1 }, "Optillion",    "Optillion" },
    { { 0x00, 0x06, 0xF2 }, "PlatysCommun", "Platys Communications" },
    { { 0x00, 0x06, 0xF3 }, "AcceLightNet", "AcceLight Networks" },
    { { 0x00, 0x06, 0xF4 }, "PrimeElectro", "Prime Electronics & Satellitics Inc." },
    { { 0x00, 0x06, 0xF5 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x06, 0xF6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x06, 0xF7 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x06, 0xF8 }, "Boeing",       "The Boeing Company" },
    { { 0x00, 0x06, 0xF9 }, "MitsuiZosenR", "Mitsui Zosen Systems Research Inc." },
    { { 0x00, 0x06, 0xFA }, "IPSQUARE",     "IP SQUARE Co, Ltd." },
    { { 0x00, 0x06, 0xFB }, "HitachiPrint", "Hitachi Printing Solutions, Ltd." },
    { { 0x00, 0x06, 0xFC }, "Fnet",         "Fnet Co., Ltd." },
    { { 0x00, 0x06, 0xFD }, "ComjetInform", "Comjet Information Systems Corp." },
    { { 0x00, 0x06, 0xFE }, "Ambrado",      "Ambrado, Inc" },
    { { 0x00, 0x06, 0xFF }, "Sheba",        "Sheba Systems Co., Ltd." },
    { { 0x00, 0x07, 0x00 }, "ZettamediaKo", "Zettamedia Korea" },
    { { 0x00, 0x07, 0x01 }, "RacalDatacom", "Racal-Datacom" },
    { { 0x00, 0x07, 0x02 }, "VarexImaging", "Varex Imaging" },
    { { 0x00, 0x07, 0x03 }, "CSEETranspor", "CSEE Transport" },
    { { 0x00, 0x07, 0x04 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x07, 0x05 }, "EndressHause", "Endress & Hauser GmbH & Co" },
    { { 0x00, 0x07, 0x06 }, "Sanritz",      "Sanritz Corporation" },
    { { 0x00, 0x07, 0x07 }, "Interalia",    "Interalia Inc." },
    { { 0x00, 0x07, 0x08 }, "Bitrage",      "Bitrage Inc." },
    { { 0x00, 0x07, 0x09 }, "Westerstrand", "Westerstrand Urfabrik AB" },
    { { 0x00, 0x07, 0x0A }, "UnicomAutoma", "Unicom Automation Co., Ltd." },
    { { 0x00, 0x07, 0x0B }, "NovabaseSGPS", "Novabase SGPS, SA" },
    { { 0x00, 0x07, 0x0C }, "SVAIntrusion", "SVA-Intrusion.com Co. Ltd." },
    { { 0x00, 0x07, 0x0D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0x0E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0x0F }, "Fujant",       "Fujant, Inc." },
    { { 0x00, 0x07, 0x10 }, "Adax",         "Adax, Inc." },
    { { 0x00, 0x07, 0x11 }, "Acterna",      "Acterna" },
    { { 0x00, 0x07, 0x12 }, "JALInformati", "JAL Information Technology" },
    { { 0x00, 0x07, 0x13 }, "IPOne",        "IP One, Inc." },
    { { 0x00, 0x07, 0x14 }, "Brightcom",    "Brightcom" },
    { { 0x00, 0x07, 0x15 }, "GeneralResea", "General Research of Electronics, Inc." },
    { { 0x00, 0x07, 0x16 }, "JSMarine",     "J & S Marine Ltd." },
    { { 0x00, 0x07, 0x17 }, "WielandElect", "Wieland Electric GmbH" },
    { { 0x00, 0x07, 0x18 }, "iCanTek",      "iCanTek Co., Ltd." },
    { { 0x00, 0x07, 0x19 }, "Mobiis",       "Mobiis Co., Ltd." },
    { { 0x00, 0x07, 0x1A }, "Finedigital",  "Finedigital Inc." },
    { { 0x00, 0x07, 0x1B }, "CDVIAmericas", "CDVI Americas Ltd" },
    { { 0x00, 0x07, 0x1C }, "At&T",         "At&T" },
    { { 0x00, 0x07, 0x1D }, "SatelsaSiste", "Satelsa Sistemas Y Aplicaciones De Telecomunicaciones, S.A." },
    { { 0x00, 0x07, 0x1E }, "TriMEngineer", "Tri-M Engineering / Nupak Dev. Corp." },
    { { 0x00, 0x07, 0x1F }, "EuropeanInte", "European Systems Integration" },
    { { 0x00, 0x07, 0x20 }, "Trutzschler",  "Trutzschler GmbH & Co. KG" },
    { { 0x00, 0x07, 0x21 }, "FormacElektr", "Formac Elektronik GmbH" },
    { { 0x00, 0x07, 0x22 }, "Nielsen",      "The Nielsen Company" },
    { { 0x00, 0x07, 0x23 }, "ELCONSystemt", "ELCON Systemtechnik GmbH" },
    { { 0x00, 0x07, 0x24 }, "Telemax",      "Telemax Co., Ltd." },
    { { 0x00, 0x07, 0x25 }, "BematechInte", "Bematech International Corp." },
    { { 0x00, 0x07, 0x26 }, "GongjinElect", "Shenzhen Gongjin Electronics Co.,Lt" },
    { { 0x00, 0x07, 0x27 }, "Zi",           "Zi Corporation (HK) Ltd." },
    { { 0x00, 0x07, 0x28 }, "NeoTelecom",   "Neo Telecom" },
    { { 0x00, 0x07, 0x29 }, "KistlerInstr", "Kistler Instrumente AG" },
    { { 0x00, 0x07, 0x2A }, "InnovanceNet", "Innovance Networks" },
    { { 0x00, 0x07, 0x2B }, "JungMyungTel", "Jung Myung Telecom Co., Ltd." },
    { { 0x00, 0x07, 0x2C }, "Fabricom",     "Fabricom" },
    { { 0x00, 0x07, 0x2D }, "CNSystems",    "CNSystems" },
    { { 0x00, 0x07, 0x2E }, "NorthNode",    "North Node AB" },
    { { 0x00, 0x07, 0x2F }, "Intransa",     "Intransa, Inc." },
    { { 0x00, 0x07, 0x30 }, "HutchisonOPT", "Hutchison OPTEL Telecom Technology Co., Ltd." },
    { { 0x00, 0x07, 0x31 }, "OphirSpirico", "Ophir-Spiricon LLC" },
    { { 0x00, 0x07, 0x32 }, "AAEONTechnol", "AAEON Technology Inc." },
    { { 0x00, 0x07, 0x33 }, "DANCONTROLEn", "DANCONTROL Engineering" },
    { { 0x00, 0x07, 0x34 }, "ONStor",       "ONStor, Inc." },
    { { 0x00, 0x07, 0x35 }, "FlarionTechn", "Flarion Technologies, Inc." },
    { { 0x00, 0x07, 0x36 }, "DataVideoTec", "Data Video Technologies Co., Ltd." },
    { { 0x00, 0x07, 0x37 }, "Soriya",       "Soriya Co. Ltd." },
    { { 0x00, 0x07, 0x38 }, "YoungTechnol", "Young Technology Co., Ltd." },
    { { 0x00, 0x07, 0x39 }, "ScottyGroupA", "Scotty Group Austria Gmbh" },
    { { 0x00, 0x07, 0x3A }, "Inventel",     "Inventel" },
    { { 0x00, 0x07, 0x3B }, "Tenovis",      "Tenovis GmbH & Co KG" },
    { { 0x00, 0x07, 0x3C }, "TelecomDesig", "Telecom Design" },
    { { 0x00, 0x07, 0x3D }, "NanjingPoste", "Nanjing Postel Telecommunications Co., Ltd." },
    { { 0x00, 0x07, 0x3E }, "ChinaGreatWa", "China Great-Wall Computer Shenzhen Co., Ltd." },
    { { 0x00, 0x07, 0x3F }, "WoojyunSyste", "Woojyun Systec Co., Ltd." },
    { { 0x00, 0x07, 0x40 }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0x07, 0x41 }, "SierraAutoma", "Sierra Automated Systems" },
    { { 0x00, 0x07, 0x42 }, "Ormazabal",    "Ormazabal" },
    { { 0x00, 0x07, 0x43 }, "ChelsioCommu", "Chelsio Communications" },
    { { 0x00, 0x07, 0x44 }, "Unico",        "Unico, Inc." },
    { { 0x00, 0x07, 0x45 }, "RadlanComput", "Radlan Computer Communications Ltd." },
    { { 0x00, 0x07, 0x46 }, "TURCK",        "TURCK, Inc." },
    { { 0x00, 0x07, 0x47 }, "Mecalc",       "Mecalc" },
    { { 0x00, 0x07, 0x48 }, "ImagingSourc", "The Imaging Source Europe" },
    { { 0x00, 0x07, 0x49 }, "CENiX",        "CENiX Inc." },
    { { 0x00, 0x07, 0x4A }, "CarlValentin", "Carl Valentin GmbH" },
    { { 0x00, 0x07, 0x4B }, "Daihen",       "Daihen Corporation" },
    { { 0x00, 0x07, 0x4C }, "Beicom",       "Beicom Inc." },
    { { 0x00, 0x07, 0x4D }, "ZebraTechnol", "Zebra Technologies Corp." },
    { { 0x00, 0x07, 0x4E }, "IPFRONT",      "IPFRONT Inc" },
    { { 0x00, 0x07, 0x4F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0x50 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0x51 }, "mut",          "m-u-t AG" },
    { { 0x00, 0x07, 0x52 }, "RhythmWatch",  "Rhythm Watch Co., Ltd." },
    { { 0x00, 0x07, 0x53 }, "QxcommTechno", "Beijing Qxcomm Technology Co., Ltd." },
    { { 0x00, 0x07, 0x54 }, "XyterraCompu", "Xyterra Computing, Inc." },
    { { 0x00, 0x07, 0x55 }, "Lafon",        "Lafon" },
    { { 0x00, 0x07, 0x56 }, "JuyoungTelec", "Juyoung Telecom" },
    { { 0x00, 0x07, 0x57 }, "TopcallInter", "Topcall International AG" },
    { { 0x00, 0x07, 0x58 }, "DragonWave",   "DragonWave Inc." },
    { { 0x00, 0x07, 0x59 }, "BorisManufac", "Boris Manufacturing Corp." },
    { { 0x00, 0x07, 0x5A }, "AirProductsa", "Air Products and Chemicals, Inc." },
    { { 0x00, 0x07, 0x5B }, "GibsonGuitar", "Gibson Guitars" },
    { { 0x00, 0x07, 0x5C }, "EastmanKodak", "Eastman Kodak Company" },
    { { 0x00, 0x07, 0x5D }, "Celleritas",   "Celleritas Inc." },
    { { 0x00, 0x07, 0x5E }, "AmetekPowerI", "Ametek Power Instruments" },
    { { 0x00, 0x07, 0x5F }, "VCSVideoComm", "VCS Video Communication Systems AG" },
    { { 0x00, 0x07, 0x60 }, "TOMISInforma", "TOMIS Information & Telecom Corp." },
    { { 0x00, 0x07, 0x61 }, "29530",        "29530" },
    { { 0x00, 0x07, 0x62 }, "GroupSense",   "Group Sense Limited" },
    { { 0x00, 0x07, 0x63 }, "SunniwellCyb", "Sunniwell Cyber Tech. Co., Ltd." },
    { { 0x00, 0x07, 0x64 }, "YoungWooTele", "YoungWoo Telecom Co. Ltd." },
    { { 0x00, 0x07, 0x65 }, "JadeQuantumT", "Jade Quantum Technologies, Inc." },
    { { 0x00, 0x07, 0x66 }, "ChouChinIndu", "Chou Chin Industrial Co., Ltd." },
    { { 0x00, 0x07, 0x67 }, "YuxingElectr", "Yuxing Electronics Company Limited" },
    { { 0x00, 0x07, 0x68 }, "Danfoss",      "Danfoss A/S" },
    { { 0x00, 0x07, 0x69 }, "ItalianaMacc", "Italiana Macchi SpA" },
    { { 0x00, 0x07, 0x6A }, "NEXTEYE",      "NEXTEYE Co., Ltd." },
    { { 0x00, 0x07, 0x6B }, "Stralfors",    "Stralfors AB" },
    { { 0x00, 0x07, 0x6C }, "Daehanet",     "Daehanet, Inc." },
    { { 0x00, 0x07, 0x6D }, "FlexlightNet", "Flexlight Networks" },
    { { 0x00, 0x07, 0x6E }, "Sinetica",     "Sinetica Corporation Limited" },
    { { 0x00, 0x07, 0x6F }, "Synoptics",    "Synoptics Limited" },
    { { 0x00, 0x07, 0x70 }, "Ubiquoss",     "Ubiquoss Inc" },
    { { 0x00, 0x07, 0x71 }, "EmbeddedSyst", "Embedded System Corporation" },
    { { 0x00, 0x07, 0x72 }, "AlcatelLucen", "Alcatel-Lucent Shanghai Bell Co., Ltd" },
    { { 0x00, 0x07, 0x73 }, "AscomPowerli", "Ascom Powerline Communications Ltd." },
    { { 0x00, 0x07, 0x74 }, "GuangZhouThi", "GuangZhou Thinker Technology Co. Ltd." },
    { { 0x00, 0x07, 0x75 }, "ValenceSemic", "Valence Semiconductor, Inc." },
    { { 0x00, 0x07, 0x76 }, "FederalAPD",   "Federal APD" },
    { { 0x00, 0x07, 0x77 }, "Motah",        "Motah Ltd." },
    { { 0x00, 0x07, 0x78 }, "GERSTEL",      "GERSTEL GmbH & Co. KG" },
    { { 0x00, 0x07, 0x79 }, "SungilTeleco", "Sungil Telecom Co., Ltd." },
    { { 0x00, 0x07, 0x7A }, "InfowareSyst", "Infoware System Co., Ltd." },
    { { 0x00, 0x07, 0x7B }, "MillimetrixB", "Millimetrix Broadband Networks" },
    { { 0x00, 0x07, 0x7C }, "WestermoNetw", "Westermo Network Technologies AB" },
    { { 0x00, 0x07, 0x7D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0x7E }, "Elrest",       "Elrest GmbH" },
    { { 0x00, 0x07, 0x7F }, "JCommunicati", "J Communications Co., Ltd." },
    { { 0x00, 0x07, 0x80 }, "BluegigaTech", "Bluegiga Technologies OY" },
    { { 0x00, 0x07, 0x81 }, "Itron",        "Itron Inc." },
    { { 0x00, 0x07, 0x82 }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x07, 0x83 }, "SynComNetwor", "SynCom Network, Inc." },
    { { 0x00, 0x07, 0x84 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0x85 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0x86 }, "WirelessNetw", "Wireless Networks Inc." },
    { { 0x00, 0x07, 0x87 }, "IdeaSystem",   "Idea System Co., Ltd." },
    { { 0x00, 0x07, 0x88 }, "Clipcomm",     "Clipcomm, Inc." },
    { { 0x00, 0x07, 0x89 }, "Allradio",     "Allradio Co., Ltd" },
    { { 0x00, 0x07, 0x8A }, "MentorDataSy", "Mentor Data System Inc." },
    { { 0x00, 0x07, 0x8B }, "WegenerCommu", "Wegener Communications, Inc." },
    { { 0x00, 0x07, 0x8C }, "Elektroniksp", "Elektronikspecialisten i Borlange AB" },
    { { 0x00, 0x07, 0x8D }, "NetEngines",   "NetEngines Ltd." },
    { { 0x00, 0x07, 0x8E }, "GarzFricke",   "Garz & Fricke GmbH" },
    { { 0x00, 0x07, 0x8F }, "EmkayInnovat", "Emkay Innovative Products" },
    { { 0x00, 0x07, 0x90 }, "TriMTechnolo", "Tri-M Technologies (s) Limited" },
    { { 0x00, 0x07, 0x91 }, "Internationa", "International Data Communications, Inc." },
    { { 0x00, 0x07, 0x92 }, "SütronElectr", "Sütron Electronic GmbH" },
    { { 0x00, 0x07, 0x93 }, "ShinSatellit", "Shin Satellite Public Company Limited" },
    { { 0x00, 0x07, 0x94 }, "SimpleDevice", "Simple Devices, Inc." },
    { { 0x00, 0x07, 0x95 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x07, 0x96 }, "LSI",          "LSI Systems, Inc." },
    { { 0x00, 0x07, 0x97 }, "Netpower",     "Netpower Co., Ltd." },
    { { 0x00, 0x07, 0x98 }, "Selea",        "Selea SRL" },
    { { 0x00, 0x07, 0x99 }, "TippingPoint", "Tipping Point Technologies, Inc." },
    { { 0x00, 0x07, 0x9A }, "Verint",       "Verint Systems Inc" },
    { { 0x00, 0x07, 0x9B }, "AuroraNetwor", "Aurora Networks" },
    { { 0x00, 0x07, 0x9C }, "GoldenElectr", "Golden Electronics Technology Co., Ltd." },
    { { 0x00, 0x07, 0x9D }, "Musashi",      "Musashi Co., Ltd." },
    { { 0x00, 0x07, 0x9E }, "Ilinx",        "Ilinx Co., Ltd." },
    { { 0x00, 0x07, 0x9F }, "ActionDigita", "Action Digital Inc." },
    { { 0x00, 0x07, 0xA0 }, "eWatch",       "e-Watch Inc." },
    { { 0x00, 0x07, 0xA1 }, "VIASYSHealth", "VIASYS Healthcare GmbH" },
    { { 0x00, 0x07, 0xA2 }, "Opteon",       "Opteon Corporation" },
    { { 0x00, 0x07, 0xA3 }, "OsitisSoftwa", "Ositis Software, Inc." },
    { { 0x00, 0x07, 0xA4 }, "GNNetcom",     "GN Netcom Ltd." },
    { { 0x00, 0x07, 0xA5 }, "YDK",          "Y.D.K Co. Ltd." },
    { { 0x00, 0x07, 0xA6 }, "LevitonManuf", "Leviton Manufacturing Co., Inc." },
    { { 0x00, 0x07, 0xA7 }, "AZ",           "A-Z Inc." },
    { { 0x00, 0x07, 0xA8 }, "HaierGroupTe", "Haier Group Technologies Ltd" },
    { { 0x00, 0x07, 0xA9 }, "Novasonics",   "Novasonics" },
    { { 0x00, 0x07, 0xAA }, "QuantumData",  "Quantum Data Inc." },
    { { 0x00, 0x07, 0xAB }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x07, 0xAC }, "Eolring",      "Eolring" },
    { { 0x00, 0x07, 0xAD }, "PentaconFoto", "Pentacon GmbH Foto-und Feinwerktechnik" },
    { { 0x00, 0x07, 0xAE }, "BritestreamN", "Britestream Networks, Inc." },
    { { 0x00, 0x07, 0xAF }, "RedLionContr", "Red Lion Controls, LP" },
    { { 0x00, 0x07, 0xB0 }, "OfficeDetail", "Office Details, Inc." },
    { { 0x00, 0x07, 0xB1 }, "EquatorTechn", "Equator Technologies" },
    { { 0x00, 0x07, 0xB2 }, "Transaccess",  "Transaccess S.A." },
    { { 0x00, 0x07, 0xB3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0xB4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0xB5 }, "AnyOneWirele", "Any One Wireless Ltd." },
    { { 0x00, 0x07, 0xB6 }, "TelecomTechn", "Telecom Technology Ltd." },
    { { 0x00, 0x07, 0xB7 }, "SamuraiIndPr", "Samurai Ind. Prods Eletronicos Ltda" },
    { { 0x00, 0x07, 0xB8 }, "Corvalent",    "Corvalent Corporation" },
    { { 0x00, 0x07, 0xB9 }, "Ginganet",     "Ginganet Corporation" },
    { { 0x00, 0x07, 0xBA }, "UTStarcom",    "UTStarcom Inc" },
    { { 0x00, 0x07, 0xBB }, "Candera",      "Candera Inc." },
    { { 0x00, 0x07, 0xBC }, "Identix",      "Identix Inc." },
    { { 0x00, 0x07, 0xBD }, "Radionet",     "Radionet Ltd." },
    { { 0x00, 0x07, 0xBE }, "DataLogic",    "DataLogic SpA" },
    { { 0x00, 0x07, 0xBF }, "ArmillaireTe", "Armillaire Technologies, Inc." },
    { { 0x00, 0x07, 0xC0 }, "NetZerver",    "NetZerver Inc." },
    { { 0x00, 0x07, 0xC1 }, "OvertureNetw", "Overture Networks, Inc." },
    { { 0x00, 0x07, 0xC2 }, "NetsysTeleco", "Netsys Telecom" },
    { { 0x00, 0x07, 0xC3 }, "Thomson",      "Thomson" },
    { { 0x00, 0x07, 0xC4 }, "JEAN",         "JEAN Co. Ltd." },
    { { 0x00, 0x07, 0xC5 }, "Gcom",         "Gcom, Inc." },
    { { 0x00, 0x07, 0xC6 }, "VDSVosskuhle", "VDS Vosskuhler GmbH" },
    { { 0x00, 0x07, 0xC7 }, "Synectics",    "Synectics Systems Limited" },
    { { 0x00, 0x07, 0xC8 }, "Brain21",      "Brain21, Inc." },
    { { 0x00, 0x07, 0xC9 }, "TechnolSeven", "Technol Seven Co., Ltd." },
    { { 0x00, 0x07, 0xCA }, "CreatixPolym", "Creatix Polymedia Ges Fur Kommunikaitonssysteme" },
    { { 0x00, 0x07, 0xCB }, "FreeboxSas",   "Freebox Sas" },
    { { 0x00, 0x07, 0xCC }, "KabaBenzing",  "Kaba Benzing GmbH" },
    { { 0x00, 0x07, 0xCD }, "KumohElectro", "Kumoh Electronic Co, Ltd" },
    { { 0x00, 0x07, 0xCE }, "Cabletime",    "Cabletime Limited" },
    { { 0x00, 0x07, 0xCF }, "Anoto",        "Anoto AB" },
    { { 0x00, 0x07, 0xD0 }, "AutomatEngen", "Automat Engenharia de Automação Ltda." },
    { { 0x00, 0x07, 0xD1 }, "SpectrumSign", "Spectrum Signal Processing Inc." },
    { { 0x00, 0x07, 0xD2 }, "LogopakSyste", "Logopak Systeme GmbH & Co. KG" },
    { { 0x00, 0x07, 0xD3 }, "SPGPrints",    "SPGPrints B.V." },
    { { 0x00, 0x07, 0xD4 }, "ZhejiangYuto", "Zhejiang Yutong Network Communication Co Ltd." },
    { { 0x00, 0x07, 0xD5 }, "3eTechnologi", "3e Technologies Int;., Inc." },
    { { 0x00, 0x07, 0xD6 }, "Commil",       "Commil Ltd." },
    { { 0x00, 0x07, 0xD7 }, "CaporisNetwo", "Caporis Networks AG" },
    { { 0x00, 0x07, 0xD8 }, "HitronTechno", "Hitron Technologies. Inc" },
    { { 0x00, 0x07, 0xD9 }, "Splicecom",    "Splicecom" },
    { { 0x00, 0x07, 0xDA }, "NeuroTelecom", "Neuro Telecom Co., Ltd." },
    { { 0x00, 0x07, 0xDB }, "KiranaNetwor", "Kirana Networks, Inc." },
    { { 0x00, 0x07, 0xDC }, "Atek",         "Atek Co, Ltd." },
    { { 0x00, 0x07, 0xDD }, "CradleTechno", "Cradle Technologies" },
    { { 0x00, 0x07, 0xDE }, "eCopilt",      "eCopilt AB" },
    { { 0x00, 0x07, 0xDF }, "Vbrick",       "Vbrick Systems Inc." },
    { { 0x00, 0x07, 0xE0 }, "Palm",         "Palm Inc." },
    { { 0x00, 0x07, 0xE1 }, "WISCommunica", "WIS Communications Co. Ltd." },
    { { 0x00, 0x07, 0xE2 }, "Bitworks",     "Bitworks, Inc." },
    { { 0x00, 0x07, 0xE3 }, "NavcomTechno", "Navcom Technology, Inc." },
    { { 0x00, 0x07, 0xE4 }, "SoftRadio",    "SoftRadio Co., Ltd." },
    { { 0x00, 0x07, 0xE5 }, "Coup",         "Coup Corporation" },
    { { 0x00, 0x07, 0xE6 }, "edgeflowCana", "edgeflow Canada Inc." },
    { { 0x00, 0x07, 0xE7 }, "FreeWaveTech", "FreeWave Technologies" },
    { { 0x00, 0x07, 0xE8 }, "EdgeWave",     "EdgeWave" },
    { { 0x00, 0x07, 0xE9 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x07, 0xEA }, "Massana",      "Massana, Inc." },
    { { 0x00, 0x07, 0xEB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0xEC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x07, 0xED }, "Altera",       "Altera Corporation" },
    { { 0x00, 0x07, 0xEE }, "telcoInforma", "telco Informationssysteme GmbH" },
    { { 0x00, 0x07, 0xEF }, "LockheedMart", "Lockheed Martin Tactical Systems" },
    { { 0x00, 0x07, 0xF0 }, "LogiSync",     "LogiSync LLC" },
    { { 0x00, 0x07, 0xF1 }, "TeraBurstNet", "TeraBurst Networks Inc." },
    { { 0x00, 0x07, 0xF2 }, "IOA",          "IOA Corporation" },
    { { 0x00, 0x07, 0xF3 }, "ThinkengineN", "Thinkengine Networks" },
    { { 0x00, 0x07, 0xF4 }, "Eletex",       "Eletex Co., Ltd." },
    { { 0x00, 0x07, 0xF5 }, "Bridgeco",     "Bridgeco Co AG" },
    { { 0x00, 0x07, 0xF6 }, "QqestSoftwar", "Qqest Software Systems" },
    { { 0x00, 0x07, 0xF7 }, "Galtronics",   "Galtronics" },
    { { 0x00, 0x07, 0xF8 }, "ITDevices",    "ITDevices, Inc." },
    { { 0x00, 0x07, 0xF9 }, "Sensaphone",   "Sensaphone" },
    { { 0x00, 0x07, 0xFA }, "ITT",          "ITT Co., Ltd." },
    { { 0x00, 0x07, 0xFB }, "GigaStreamUM", "Giga Stream UMTS Technologies GmbH" },
    { { 0x00, 0x07, 0xFC }, "Adept",        "Adept Systems Inc." },
    { { 0x00, 0x07, 0xFD }, "LANergy",      "LANergy Ltd." },
    { { 0x00, 0x07, 0xFE }, "Rigaku",       "Rigaku Corporation" },
    { { 0x00, 0x07, 0xFF }, "GluonNetwork", "Gluon Networks" },
    { { 0x00, 0x08, 0x00 }, "Multitech",    "Multitech Systems, Inc." },
    { { 0x00, 0x08, 0x01 }, "HighSpeedSur", "HighSpeed Surfing Inc." },
    { { 0x00, 0x08, 0x02 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x08, 0x03 }, "CosTron",      "Cos Tron" },
    { { 0x00, 0x08, 0x04 }, "ICA",          "ICA Inc." },
    { { 0x00, 0x08, 0x05 }, "TechnoHolon",  "Techno-Holon Corporation" },
    { { 0x00, 0x08, 0x06 }, "Raonet",       "Raonet Systems, Inc." },
    { { 0x00, 0x08, 0x07 }, "AccessDevice", "Access Devices Limited" },
    { { 0x00, 0x08, 0x08 }, "PPTVision",    "PPT Vision, Inc." },
    { { 0x00, 0x08, 0x09 }, "Systemonic",   "Systemonic AG" },
    { { 0x00, 0x08, 0x0A }, "EsperaWerke",  "Espera-Werke GmbH" },
    { { 0x00, 0x08, 0x0B }, "BirkaBPAInfo", "Birka BPA Informationssystem AB" },
    { { 0x00, 0x08, 0x0C }, "VDAGroup",     "VDA Group S.p.a." },
    { { 0x00, 0x08, 0x0D }, "Toshiba",      "Toshiba" },
    { { 0x00, 0x08, 0x0E }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x08, 0x0F }, "ProximionFib", "Proximion Fiber Optics AB" },
    { { 0x00, 0x08, 0x10 }, "KeyTechnolog", "Key Technology, Inc." },
    { { 0x00, 0x08, 0x11 }, "VOIX",         "VOIX Corporation" },
    { { 0x00, 0x08, 0x12 }, "GM2",          "GM-2 Corporation" },
    { { 0x00, 0x08, 0x13 }, "Diskbank",     "Diskbank, Inc." },
    { { 0x00, 0x08, 0x14 }, "TILTechnolog", "TIL Technologies" },
    { { 0x00, 0x08, 0x15 }, "CATS",         "CATS Co., Ltd." },
    { { 0x00, 0x08, 0x16 }, "BluelonApS",   "Bluelon ApS" },
    { { 0x00, 0x08, 0x17 }, "EmergeCoreNe", "EmergeCore Networks LLC" },
    { { 0x00, 0x08, 0x18 }, "Pixelworks",   "Pixelworks, Inc." },
    { { 0x00, 0x08, 0x19 }, "Banksys",      "Banksys" },
    { { 0x00, 0x08, 0x1A }, "SanradIntell", "Sanrad Intelligence Storage Communications (2000) Ltd." },
    { { 0x00, 0x08, 0x1B }, "Windigo",      "Windigo Systems" },
    { { 0x00, 0x08, 0x1C }, "@poscom",      "@pos.com" },
    { { 0x00, 0x08, 0x1D }, "Ipsil",        "Ipsil, Incorporated" },
    { { 0x00, 0x08, 0x1E }, "Repeatit",     "Repeatit AB" },
    { { 0x00, 0x08, 0x1F }, "PouYuenTech",  "Pou Yuen Tech Corp. Ltd." },
    { { 0x00, 0x08, 0x20 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x21 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x22 }, "InProComm",    "InPro Comm" },
    { { 0x00, 0x08, 0x23 }, "Texa",         "Texa Corp." },
    { { 0x00, 0x08, 0x24 }, "NuanceDocume", "Nuance Document Imaging" },
    { { 0x00, 0x08, 0x25 }, "AcmePacket",   "Acme Packet" },
    { { 0x00, 0x08, 0x26 }, "ColoradoMedT", "Colorado Med Tech" },
    { { 0x00, 0x08, 0x27 }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x08, 0x28 }, "KoeiEngineer", "Koei Engineering Ltd." },
    { { 0x00, 0x08, 0x29 }, "TokyoElectro", "Tokyo Electron Device Nagasaki Limited" },
    { { 0x00, 0x08, 0x2A }, "PowerwallzNe", "Powerwallz Network Security" },
    { { 0x00, 0x08, 0x2B }, "WooksungElec", "Wooksung Electronics, Inc." },
    { { 0x00, 0x08, 0x2C }, "Homag",        "Homag AG" },
    { { 0x00, 0x08, 0x2D }, "IndusTeqsite", "Indus Teqsite Private Limited" },
    { { 0x00, 0x08, 0x2E }, "MultitoneEle", "Multitone Electronics PLC" },
    { { 0x00, 0x08, 0x2F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x30 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x31 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x32 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x4E }, "DivergeNet",   "DivergeNet, Inc." },
    { { 0x00, 0x08, 0x4F }, "Qualstar",     "Qualstar Corporation" },
    { { 0x00, 0x08, 0x50 }, "ArizonaInstr", "Arizona Instrument Corp." },
    { { 0x00, 0x08, 0x51 }, "CanadianBank", "Canadian Bank Note Company, Ltd." },
    { { 0x00, 0x08, 0x52 }, "Davolink",     "Davolink Co. Inc." },
    { { 0x00, 0x08, 0x53 }, "SchleicherRe", "Schleicher GmbH & Co. Relaiswerke KG" },
    { { 0x00, 0x08, 0x54 }, "Netronix",     "Netronix, Inc." },
    { { 0x00, 0x08, 0x55 }, "NASAGoddardS", "NASA-Goddard Space Flight Center" },
    { { 0x00, 0x08, 0x56 }, "GamatronicEl", "Gamatronic Electronic Industries Ltd." },
    { { 0x00, 0x08, 0x57 }, "PolarisNetwo", "Polaris Networks, Inc." },
    { { 0x00, 0x08, 0x58 }, "Novatechnolo", "Novatechnology Inc." },
    { { 0x00, 0x08, 0x59 }, "UnitoneElect", "ShenZhen Unitone Electronics Co., Ltd." },
    { { 0x00, 0x08, 0x5A }, "IntiGate",     "IntiGate Inc." },
    { { 0x00, 0x08, 0x5B }, "HanbitElectr", "Hanbit Electronics Co., Ltd." },
    { { 0x00, 0x08, 0x5C }, "DareTechnolo", "Shanghai Dare Technologies Co. Ltd." },
    { { 0x00, 0x08, 0x5D }, "Mitel",        "Mitel Corporation" },
    { { 0x00, 0x08, 0x5E }, "Pco",          "Pco Ag" },
    { { 0x00, 0x08, 0x5F }, "Picanol",      "Picanol N.V." },
    { { 0x00, 0x08, 0x60 }, "LodgeNetEnte", "LodgeNet Entertainment Corp." },
    { { 0x00, 0x08, 0x61 }, "SoftEnergy",   "SoftEnergy Co., Ltd." },
    { { 0x00, 0x08, 0x62 }, "NECEluminant", "NEC Eluminant Technologies, Inc." },
    { { 0x00, 0x08, 0x63 }, "Entrisphere",  "Entrisphere Inc." },
    { { 0x00, 0x08, 0x64 }, "Fasy",         "Fasy S.p.A." },
    { { 0x00, 0x08, 0x65 }, "Jascom",       "Jascom Co., Ltd" },
    { { 0x00, 0x08, 0x66 }, "DSXAccess",    "DSX Access Systems, Inc." },
    { { 0x00, 0x08, 0x67 }, "UptimeDevice", "Uptime Devices" },
    { { 0x00, 0x08, 0x68 }, "PurOptix",     "PurOptix" },
    { { 0x00, 0x08, 0x69 }, "CommandeTech", "Command-e Technology Co.,Ltd." },
    { { 0x00, 0x08, 0x6A }, "Securiton",    "Securiton Gmbh" },
    { { 0x00, 0x08, 0x6B }, "Mipsys",       "Mipsys" },
    { { 0x00, 0x08, 0x6C }, "PlasmonLMS",   "Plasmon LMS" },
    { { 0x00, 0x08, 0x6D }, "MissouriFree", "Missouri FreeNet" },
    { { 0x00, 0x08, 0x6E }, "Hyglo",        "Hyglo AB" },
    { { 0x00, 0x08, 0x6F }, "ResourcesCom", "Resources Computer Network Ltd." },
    { { 0x00, 0x08, 0x70 }, "Rasvia",       "Rasvia Systems, Inc." },
    { { 0x00, 0x08, 0x71 }, "NORTHDATA",    "NORTHDATA Co., Ltd." },
    { { 0x00, 0x08, 0x72 }, "SorensonComm", "Sorenson Communications" },
    { { 0x00, 0x08, 0x73 }, "DapTechnolog", "DapTechnology B.V." },
    { { 0x00, 0x08, 0x74 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x08, 0x75 }, "AcorpElectro", "Acorp Electronics Corp." },
    { { 0x00, 0x08, 0x76 }, "SDSystem",     "SDSystem" },
    { { 0x00, 0x08, 0x77 }, "LiebertHiros", "Liebert-Hiross Spa" },
    { { 0x00, 0x08, 0x78 }, "BenchmarkSto", "Benchmark Storage Innovations" },
    { { 0x00, 0x08, 0x79 }, "CEM",          "CEM Corporation" },
    { { 0x00, 0x08, 0x7A }, "Wipotec",      "Wipotec GmbH" },
    { { 0x00, 0x08, 0x7B }, "RTXTelecom",   "RTX Telecom A/S" },
    { { 0x00, 0x08, 0x7C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x7D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0x7E }, "BonElectroTe", "Bon Electro-Telecom Inc." },
    { { 0x00, 0x08, 0x7F }, "SPAUNelectro", "SPAUN electronic GmbH & Co. KG" },
    { { 0x00, 0x08, 0x80 }, "BroadTelCana", "BroadTel Canada Communications inc." },
    { { 0x00, 0x08, 0x81 }, "DigitalHands", "Digital Hands Co.,Ltd." },
    { { 0x00, 0x08, 0x82 }, "Sigma",        "Sigma Corporation" },
    { { 0x00, 0x08, 0x83 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x08, 0x84 }, "IndexBraille", "Index Braille AB" },
    { { 0x00, 0x08, 0x85 }, "EMSDrThomasW", "EMS Dr. Thomas Wünsche" },
    { { 0x00, 0x08, 0x86 }, "HansungTelia", "Hansung Teliann, Inc." },
    { { 0x00, 0x08, 0x87 }, "Maschinenfab", "Maschinenfabrik Reinhausen GmbH" },
    { { 0x00, 0x08, 0x88 }, "OULLIMInform", "OULLIM Information Technology Inc,." },
    { { 0x00, 0x08, 0x89 }, "DishTechnolo", "Dish Technologies Corp" },
    { { 0x00, 0x08, 0x8A }, "Minds@Work",   "Minds@Work" },
    { { 0x00, 0x08, 0x8B }, "TropicNetwor", "Tropic Networks Inc." },
    { { 0x00, 0x08, 0x8C }, "QuantaNetwor", "Quanta Network Systems Inc." },
    { { 0x00, 0x08, 0x8D }, "SigmaLinks",   "Sigma-Links Inc." },
    { { 0x00, 0x08, 0x8E }, "NihonCompute", "Nihon Computer Co., Ltd." },
    { { 0x00, 0x08, 0x8F }, "AdvancedDigi", "Advanced Digital Technology" },
    { { 0x00, 0x08, 0x90 }, "Avilinks",     "Avilinks Sa" },
    { { 0x00, 0x08, 0x91 }, "Lyan",         "Lyan Inc." },
    { { 0x00, 0x08, 0x92 }, "EMSolutions",  "EM Solutions" },
    { { 0x00, 0x08, 0x93 }, "LeInformatio", "Le Information Communication Inc." },
    { { 0x00, 0x08, 0x94 }, "InnoVISIONMu", "InnoVISION Multimedia Ltd." },
    { { 0x00, 0x08, 0x95 }, "DIRCTechnolo", "DIRC Technologie GmbH & Co.KG" },
    { { 0x00, 0x08, 0x96 }, "Printronix",   "Printronix, Inc." },
    { { 0x00, 0x08, 0x97 }, "QuakeTechnol", "Quake Technologies" },
    { { 0x00, 0x08, 0x98 }, "GigabitOptic", "Gigabit Optics Corporation" },
    { { 0x00, 0x08, 0x99 }, "Netbind",      "Netbind, Inc." },
    { { 0x00, 0x08, 0x9A }, "AlcatelMicro", "Alcatel Microelectronics" },
    { { 0x00, 0x08, 0x9B }, "ICPElectroni", "ICP Electronics Inc." },
    { { 0x00, 0x08, 0x9C }, "ElecsIndustr", "Elecs Industry Co., Ltd." },
    { { 0x00, 0x08, 0x9D }, "UHDElektroni", "UHD-Elektronik" },
    { { 0x00, 0x08, 0x9E }, "EnterNet",     "Beijing Enter-Net co.LTD" },
    { { 0x00, 0x08, 0x9F }, "EFMNetworks",  "EFM Networks" },
    { { 0x00, 0x08, 0xA0 }, "StotzFeinmes", "Stotz Feinmesstechnik GmbH" },
    { { 0x00, 0x08, 0xA1 }, "CNetTechnolo", "CNet Technology Inc." },
    { { 0x00, 0x08, 0xA2 }, "ADIEngineeri", "ADI Engineering, Inc." },
    { { 0x00, 0x08, 0xA3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0xA4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0xA5 }, "Peninsula",    "Peninsula Systems Inc." },
    { { 0x00, 0x08, 0xA6 }, "MultiwareIma", "Multiware & Image Co., Ltd." },
    { { 0x00, 0x08, 0xA7 }, "iLogic",       "iLogic Inc." },
    { { 0x00, 0x08, 0xA8 }, "Systec",       "Systec Co., Ltd." },
    { { 0x00, 0x08, 0xA9 }, "SangSangTech", "SangSang Technology, Inc." },
    { { 0x00, 0x08, 0xAA }, "Karam",        "Karam" },
    { { 0x00, 0x08, 0xAB }, "EnerLinxcom",  "EnerLinx.com, Inc." },
    { { 0x00, 0x08, 0xAC }, "BST",          "BST GmbH" },
    { { 0x00, 0x08, 0xAD }, "ToyoLinx",     "Toyo-Linx Co., Ltd." },
    { { 0x00, 0x08, 0xAE }, "PacketFrontN", "PacketFront Network Products AB" },
    { { 0x00, 0x08, 0xAF }, "Novatec",      "Novatec Corporation" },
    { { 0x00, 0x08, 0xB0 }, "HUBERSUHNERB", "HUBER+SUHNER BKtel GmbH" },
    { { 0x00, 0x08, 0xB1 }, "ProQuent",     "ProQuent Systems" },
    { { 0x00, 0x08, 0xB2 }, "CompassTechn", "Shenzhen Compass Technology Development Co.,Ltd" },
    { { 0x00, 0x08, 0xB3 }, "Fastwel",      "Fastwel" },
    { { 0x00, 0x08, 0xB4 }, "Syspol",       "Syspol" },
    { { 0x00, 0x08, 0xB5 }, "TaiGuenEnter", "Tai Guen Enterprise Co., Ltd" },
    { { 0x00, 0x08, 0xB6 }, "RouteFree",    "RouteFree, Inc." },
    { { 0x00, 0x08, 0xB7 }, "HIT",          "HIT Incorporated" },
    { { 0x00, 0x08, 0xB8 }, "EFJohnson",    "E.F. Johnson" },
    { { 0x00, 0x08, 0xB9 }, "KaonGroup",    "Kaon Group Co., Ltd." },
    { { 0x00, 0x08, 0xBA }, "Erskine",      "Erskine Systems Ltd" },
    { { 0x00, 0x08, 0xBB }, "NetExcell",    "NetExcell" },
    { { 0x00, 0x08, 0xBC }, "Ilevo",        "Ilevo AB" },
    { { 0x00, 0x08, 0xBD }, "TepgUs",       "Tepg-Us" },
    { { 0x00, 0x08, 0xBE }, "XENPAKMSAGro", "XENPAK MSA Group" },
    { { 0x00, 0x08, 0xBF }, "AptusElektro", "Aptus Elektronik AB" },
    { { 0x00, 0x08, 0xC0 }, "Asa",          "Asa Systems" },
    { { 0x00, 0x08, 0xC1 }, "AvistarCommu", "Avistar Communications Corporation" },
    { { 0x00, 0x08, 0xC2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0xC3 }, "Contex",       "Contex A/S" },
    { { 0x00, 0x08, 0xC4 }, "Hikari",       "Hikari Co.,Ltd." },
    { { 0x00, 0x08, 0xC5 }, "Liontech",     "Liontech Co., Ltd." },
    { { 0x00, 0x08, 0xC6 }, "PhilipsConsu", "Philips Consumer Communications" },
    { { 0x00, 0x08, 0xC7 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x08, 0xC8 }, "Soneticom",    "Soneticom, Inc." },
    { { 0x00, 0x08, 0xC9 }, "TechniSatDig", "TechniSat Digital GmbH Daun" },
    { { 0x00, 0x08, 0xCA }, "TwinHanTechn", "TwinHan Technology Co.,Ltd" },
    { { 0x00, 0x08, 0xCB }, "ZetaBroadban", "Zeta Broadband Inc." },
    { { 0x00, 0x08, 0xCC }, "Remotec",      "Remotec, Inc." },
    { { 0x00, 0x08, 0xCD }, "WithNet",      "With-Net Inc" },
    { { 0x00, 0x08, 0xCE }, "IPMobileNet",  "IPMobileNet Inc." },
    { { 0x00, 0x08, 0xCF }, "NipponKoeiPo", "Nippon Koei Power Systems Co., Ltd." },
    { { 0x00, 0x08, 0xD0 }, "MusashiEngin", "Musashi Engineering Co., LTD." },
    { { 0x00, 0x08, 0xD1 }, "Karel",        "Karel Inc." },
    { { 0x00, 0x08, 0xD2 }, "ZOOMNetworks", "ZOOM Networks Inc." },
    { { 0x00, 0x08, 0xD3 }, "HerculesTech", "Hercules Technologies S.A.S." },
    { { 0x00, 0x08, 0xD4 }, "IneoQuestTec", "IneoQuest Technologies, Inc" },
    { { 0x00, 0x08, 0xD5 }, "VanguardNetw", "Vanguard Networks Solutions, LLC" },
    { { 0x00, 0x08, 0xD6 }, "HASSNET",      "HASSNET Inc." },
    { { 0x00, 0x08, 0xD7 }, "How",          "How Corporation" },
    { { 0x00, 0x08, 0xD8 }, "DowkeyMicrow", "Dowkey Microwave" },
    { { 0x00, 0x08, 0xD9 }, "Mitadenshi",   "Mitadenshi Co.,LTD" },
    { { 0x00, 0x08, 0xDA }, "SofaWareTech", "SofaWare Technologies Ltd." },
    { { 0x00, 0x08, 0xDB }, "Corrigent",    "Corrigent Systems" },
    { { 0x00, 0x08, 0xDC }, "Wiznet",       "Wiznet" },
    { { 0x00, 0x08, 0xDD }, "TelenaCommun", "Telena Communications, Inc." },
    { { 0x00, 0x08, 0xDE }, "3UP",          "3UP Systems" },
    { { 0x00, 0x08, 0xDF }, "Alistel",      "Alistel Inc." },
    { { 0x00, 0x08, 0xE0 }, "ATOTechnolog", "ATO Technology Ltd." },
    { { 0x00, 0x08, 0xE1 }, "Barix",        "Barix AG" },
    { { 0x00, 0x08, 0xE2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0xE3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x08, 0xE4 }, "Envenergy",    "Envenergy Inc" },
    { { 0x00, 0x08, 0xE5 }, "IDK",          "IDK Corporation" },
    { { 0x00, 0x08, 0xE6 }, "Littlefeet",   "Littlefeet" },
    { { 0x00, 0x08, 0xE7 }, "SHIControlSy", "SHI ControlSystems,Ltd." },
    { { 0x00, 0x08, 0xE8 }, "ExcelMaster",  "Excel Master Ltd." },
    { { 0x00, 0x08, 0xE9 }, "NextGig",      "NextGig" },
    { { 0x00, 0x08, 0xEA }, "MotionContro", "Motion Control Engineering, Inc" },
    { { 0x00, 0x08, 0xEB }, "ROMWin",       "ROMWin Co.,Ltd." },
    { { 0x00, 0x08, 0xEC }, "OpticalZonu",  "Optical Zonu Corporation" },
    { { 0x00, 0x08, 0xED }, "ST&TInstrume", "ST&T Instrument Corp." },
    { { 0x00, 0x08, 0xEE }, "LogicProduct", "Logic Product Development" },
    { { 0x00, 0x08, 0xEF }, "Dibal",        "Dibal,S.A." },
    { { 0x00, 0x08, 0xF0 }, "NextGenerati", "Next Generation Systems, Inc." },
    { { 0x00, 0x08, 0xF1 }, "Voltaire",     "Voltaire" },
    { { 0x00, 0x08, 0xF2 }, "C&STechnolog", "C&S Technology" },
    { { 0x00, 0x08, 0xF3 }, "Wany",         "Wany" },
    { { 0x00, 0x08, 0xF4 }, "BluetakeTech", "Bluetake Technology Co., Ltd." },
    { { 0x00, 0x08, 0xF5 }, "YESTECHNOLOG", "YESTECHNOLOGY Co.,Ltd." },
    { { 0x00, 0x08, 0xF6 }, "SumitomoElec", "Sumitomo Electric Industries, Ltd" },
    { { 0x00, 0x08, 0xF7 }, "HitachiSemic", "Hitachi Ltd, Semiconductor & Integrated Circuits Gr" },
    { { 0x00, 0x08, 0xF8 }, "UtcCcs",       "Utc Ccs" },
    { { 0x00, 0x08, 0xF9 }, "ArtesynEmbed", "Artesyn Embedded Technologies" },
    { { 0x00, 0x08, 0xFA }, "KEBAutomatio", "KEB Automation KG" },
    { { 0x00, 0x08, 0xFB }, "SonoSite",     "SonoSite, Inc." },
    { { 0x00, 0x08, 0xFC }, "Gigaphoton",   "Gigaphoton Inc." },
    { { 0x00, 0x08, 0xFD }, "BlueKorea",    "BlueKorea Co., Ltd." },
    { { 0x00, 0x08, 0xFE }, "UNIKC&C",      "UNIK C&C Co.,Ltd." },
    { { 0x00, 0x08, 0xFF }, "TrilogyCommu", "Trilogy Communications Ltd" },
    { { 0x00, 0x09, 0x00 }, "Tmt",          "Tmt" },
    { { 0x00, 0x09, 0x01 }, "ShixuntongIn", "Shenzhen Shixuntong Information & Technoligy Co" },
    { { 0x00, 0x09, 0x02 }, "RedlineCommu", "Redline Communications Inc." },
    { { 0x00, 0x09, 0x03 }, "Panasas",      "Panasas, Inc" },
    { { 0x00, 0x09, 0x04 }, "MONDIALelect", "MONDIAL electronic" },
    { { 0x00, 0x09, 0x05 }, "iTECTechnolo", "iTEC Technologies Ltd." },
    { { 0x00, 0x09, 0x06 }, "EsteemNetwor", "Esteem Networks" },
    { { 0x00, 0x09, 0x07 }, "ChrysalisDev", "Chrysalis Development" },
    { { 0x00, 0x09, 0x08 }, "VTechTechnol", "VTech Technology Corp." },
    { { 0x00, 0x09, 0x09 }, "TelenorConne", "Telenor Connect A/S" },
    { { 0x00, 0x09, 0x0A }, "SnedFarTechn", "SnedFar Technology Co., Ltd." },
    { { 0x00, 0x09, 0x0B }, "MTLInstrumen", "MTL Instruments PLC" },
    { { 0x00, 0x09, 0x0C }, "MayekawaMfg",  "Mayekawa Mfg. Co. Ltd." },
    { { 0x00, 0x09, 0x0D }, "LeaderElectr", "Leader Electronics Corp." },
    { { 0x00, 0x09, 0x0E }, "HelixTechnol", "Helix Technology Inc." },
    { { 0x00, 0x09, 0x0F }, "Fortinet",     "Fortinet, Inc." },
    { { 0x00, 0x09, 0x10 }, "SimpleAccess", "Simple Access Inc." },
    { { 0x00, 0x09, 0x11 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0x12 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0x13 }, "SystemK",      "SystemK Corporation" },
    { { 0x00, 0x09, 0x14 }, "Computrols",   "Computrols Inc." },
    { { 0x00, 0x09, 0x15 }, "CAS",          "CAS Corp." },
    { { 0x00, 0x09, 0x16 }, "ListmanHomeT", "Listman Home Technologies, Inc." },
    { { 0x00, 0x09, 0x17 }, "WEMTechnolog", "WEM Technology Inc" },
    { { 0x00, 0x09, 0x18 }, "SamsungTechw", "Samsung Techwin Co.,Ltd" },
    { { 0x00, 0x09, 0x19 }, "MDSGateways",  "MDS Gateways" },
    { { 0x00, 0x09, 0x1A }, "MacatOpticsE", "Macat Optics & Electronics Co., Ltd." },
    { { 0x00, 0x09, 0x1B }, "DigitalGener", "Digital Generation Inc." },
    { { 0x00, 0x09, 0x1C }, "CacheVision",  "CacheVision, Inc" },
    { { 0x00, 0x09, 0x1D }, "ProteamCompu", "Proteam Computer Corporation" },
    { { 0x00, 0x09, 0x1E }, "FirstechTech", "Firstech Technology Corp." },
    { { 0x00, 0x09, 0x1F }, "A&D",          "A&D Co., Ltd." },
    { { 0x00, 0x09, 0x20 }, "EpoXCOMPUTER", "EpoX COMPUTER CO.,LTD." },
    { { 0x00, 0x09, 0x21 }, "Planmeca",     "Planmeca Oy" },
    { { 0x00, 0x09, 0x22 }, "TSTBiometric", "TST Biometrics GmbH" },
    { { 0x00, 0x09, 0x23 }, "HeamanSystem", "Heaman System Co., Ltd" },
    { { 0x00, 0x09, 0x24 }, "Telebau",      "Telebau GmbH" },
    { { 0x00, 0x09, 0x25 }, "VSNSystemen",  "VSN Systemen BV" },
    { { 0x00, 0x09, 0x26 }, "YodaCommunic", "Yoda Communications, Inc." },
    { { 0x00, 0x09, 0x27 }, "Toyokeiki",    "Toyokeiki Co.,Ltd." },
    { { 0x00, 0x09, 0x28 }, "Telecore",     "Telecore" },
    { { 0x00, 0x09, 0x29 }, "SanyoIndustr", "Sanyo Industries (UK) Limited" },
    { { 0x00, 0x09, 0x2A }, "MYTECS",       "MYTECS Co.,Ltd." },
    { { 0x00, 0x09, 0x2B }, "iQstorNetwor", "iQstor Networks, Inc." },
    { { 0x00, 0x09, 0x2C }, "Hitpoint",     "Hitpoint Inc." },
    { { 0x00, 0x09, 0x2D }, "HTC",          "HTC Corporation" },
    { { 0x00, 0x09, 0x2E }, "B&TechSystem", "B&Tech System Inc." },
    { { 0x00, 0x09, 0x2F }, "AkomTechnolo", "Akom Technology Corporation" },
    { { 0x00, 0x09, 0x30 }, "AeroConcierg", "AeroConcierge Inc." },
    { { 0x00, 0x09, 0x31 }, "FutureIntern", "Future Internet, Inc." },
    { { 0x00, 0x09, 0x32 }, "Omnilux",      "Omnilux" },
    { { 0x00, 0x09, 0x33 }, "Ophit",        "Ophit Co.Ltd." },
    { { 0x00, 0x09, 0x34 }, "DreamMultime", "Dream-Multimedia-Tv GmbH" },
    { { 0x00, 0x09, 0x35 }, "Sandvine",     "Sandvine Incorporated" },
    { { 0x00, 0x09, 0x36 }, "Ipetronik",    "Ipetronik GmbH & Co. KG" },
    { { 0x00, 0x09, 0x37 }, "InventecAppl", "Inventec Appliance Corp" },
    { { 0x00, 0x09, 0x38 }, "AllotCommuni", "Allot Communications" },
    { { 0x00, 0x09, 0x39 }, "ShibaSoku",    "ShibaSoku Co.,Ltd." },
    { { 0x00, 0x09, 0x3A }, "MolexCMS",     "Molex CMS" },
    { { 0x00, 0x09, 0x3B }, "HyundaiNetwo", "Hyundai Networks Inc." },
    { { 0x00, 0x09, 0x3C }, "JacquesTechn", "Jacques Technologies P/L" },
    { { 0x00, 0x09, 0x3D }, "Newisys",      "Newisys,Inc." },
    { { 0x00, 0x09, 0x3E }, "C&ITechnolog", "C&I Technologies" },
    { { 0x00, 0x09, 0x3F }, "DoubleWinEnt", "Double-Win Enterpirse CO., LTD" },
    { { 0x00, 0x09, 0x40 }, "AGFEO",        "AGFEO GmbH & Co. KG" },
    { { 0x00, 0x09, 0x41 }, "AlliedTelesi", "Allied Telesis K.K." },
    { { 0x00, 0x09, 0x42 }, "WirelessTech", "Wireless Technologies, Inc" },
    { { 0x00, 0x09, 0x43 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0x44 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0x45 }, "PalmmicroCom", "Palmmicro Communications Inc" },
    { { 0x00, 0x09, 0x46 }, "ClusterLabs",  "Cluster Labs GmbH" },
    { { 0x00, 0x09, 0x47 }, "Aztek",        "Aztek, Inc." },
    { { 0x00, 0x09, 0x48 }, "VistaControl", "Vista Control Systems, Corp." },
    { { 0x00, 0x09, 0x49 }, "GlyphTechnol", "Glyph Technologies Inc." },
    { { 0x00, 0x09, 0x4A }, "HomenetCommu", "Homenet Communications" },
    { { 0x00, 0x09, 0x4B }, "FillFactory",  "FillFactory NV" },
    { { 0x00, 0x09, 0x4C }, "Communicatio", "Communication Weaver Co.,Ltd." },
    { { 0x00, 0x09, 0x4D }, "BraintreeCom", "Braintree Communications Pty Ltd" },
    { { 0x00, 0x09, 0x4E }, "BartechInter", "Bartech Systems International, Inc" },
    { { 0x00, 0x09, 0x4F }, "elmegt",       "elmegt GmbH & Co. KG" },
    { { 0x00, 0x09, 0x50 }, "IndependentS", "Independent Storage Corporation" },
    { { 0x00, 0x09, 0x51 }, "ApogeeImagin", "Apogee Imaging Systems" },
    { { 0x00, 0x09, 0x52 }, "Auerswald",    "Auerswald GmbH & Co. KG" },
    { { 0x00, 0x09, 0x53 }, "LinkageSyste", "Linkage System Integration Co.Ltd." },
    { { 0x00, 0x09, 0x54 }, "AMiTspolsro",  "AMiT spol. s. r. o." },
    { { 0x00, 0x09, 0x55 }, "YoungGenerat", "Young Generation International Corp." },
    { { 0x00, 0x09, 0x56 }, "NetworkGroup", "Network Systems Group, Ltd. (NSG)" },
    { { 0x00, 0x09, 0x57 }, "Supercaller",  "Supercaller, Inc." },
    { { 0x00, 0x09, 0x58 }, "Intelnet",     "Intelnet S.A." },
    { { 0x00, 0x09, 0x59 }, "Sitecsoft",    "Sitecsoft" },
    { { 0x00, 0x09, 0x5A }, "RacewoodTech", "Racewood Technology" },
    { { 0x00, 0x09, 0x5B }, "Netgear",      "Netgear" },
    { { 0x00, 0x09, 0x5C }, "PhilipsMedic", "Philips Medical Systems - Cardiac and Monitoring Systems (CM" },
    { { 0x00, 0x09, 0x5D }, "DialogueTech", "Dialogue Technology Corp." },
    { { 0x00, 0x09, 0x5E }, "MasstechGrou", "Masstech Group Inc." },
    { { 0x00, 0x09, 0x5F }, "Telebyte",     "Telebyte, Inc." },
    { { 0x00, 0x09, 0x60 }, "YOZAN",        "YOZAN Inc." },
    { { 0x00, 0x09, 0x61 }, "Switchgearan", "Switchgear and Instrumentation Ltd" },
    { { 0x00, 0x09, 0x62 }, "SonitorTechn", "Sonitor Technologies AS" },
    { { 0x00, 0x09, 0x63 }, "DominionLase", "Dominion Lasercom Inc." },
    { { 0x00, 0x09, 0x64 }, "HiTechniques", "Hi-Techniques, Inc." },
    { { 0x00, 0x09, 0x65 }, "HyunJuComput", "HyunJu Computer Co., Ltd." },
    { { 0x00, 0x09, 0x66 }, "TrimbleEurop", "Trimble Europe Bv" },
    { { 0x00, 0x09, 0x67 }, "Tachyon",      "Tachyon, Inc" },
    { { 0x00, 0x09, 0x68 }, "Technoventur", "Technoventure, Inc." },
    { { 0x00, 0x09, 0x69 }, "MeretOptical", "Meret Optical Communications" },
    { { 0x00, 0x09, 0x6A }, "CloverleafCo", "Cloverleaf Communications Inc." },
    { { 0x00, 0x09, 0x6B }, "IBM",          "IBM Corp" },
    { { 0x00, 0x09, 0x6C }, "ImediaSemico", "Imedia Semiconductor Corp." },
    { { 0x00, 0x09, 0x6D }, "PowernetTech", "Powernet Technologies Corp." },
    { { 0x00, 0x09, 0x6E }, "GiantElectro", "Giant Electronics Ltd." },
    { { 0x00, 0x09, 0x6F }, "ZhongqingEle", "Beijing Zhongqing Elegant Tech. Corp.,Limited" },
    { { 0x00, 0x09, 0x70 }, "VibrationRes", "Vibration Research Corporation" },
    { { 0x00, 0x09, 0x71 }, "TimeManageme", "Time Management, Inc." },
    { { 0x00, 0x09, 0x72 }, "Securebase",   "Securebase,Inc" },
    { { 0x00, 0x09, 0x73 }, "LentenTechno", "Lenten Technology Co., Ltd." },
    { { 0x00, 0x09, 0x74 }, "InnopiaTechn", "Innopia Technologies, Inc." },
    { { 0x00, 0x09, 0x75 }, "fSONACommuni", "fSONA Communications Corporation" },
    { { 0x00, 0x09, 0x76 }, "DatasoftISDN", "Datasoft ISDN Systems GmbH" },
    { { 0x00, 0x09, 0x77 }, "BrunnerElekt", "Brunner Elektronik AG" },
    { { 0x00, 0x09, 0x78 }, "AIJISystem",   "AIJI System Co., Ltd." },
    { { 0x00, 0x09, 0x79 }, "AdvancedTele", "Advanced Television Systems Committee, Inc." },
    { { 0x00, 0x09, 0x7A }, "LouisDesignL", "Louis Design Labs." },
    { { 0x00, 0x09, 0x7B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0x7C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0x7D }, "SecWellNetwo", "SecWell Networks Oy" },
    { { 0x00, 0x09, 0x7E }, "ImiTechnolog", "Imi Technology Co., Ltd" },
    { { 0x00, 0x09, 0x7F }, "Vsecure2000",  "Vsecure 2000 LTD." },
    { { 0x00, 0x09, 0x80 }, "PowerZenith",  "Power Zenith Inc." },
    { { 0x00, 0x09, 0x81 }, "NewportNetwo", "Newport Networks" },
    { { 0x00, 0x09, 0x82 }, "LoeweOpta",    "Loewe Opta GmbH" },
    { { 0x00, 0x09, 0x83 }, "GlobalTopTec", "GlobalTop Technology, Inc." },
    { { 0x00, 0x09, 0x84 }, "MyCasaNetwor", "MyCasa Network Inc." },
    { { 0x00, 0x09, 0x85 }, "AutoTelecom",  "Auto Telecom Company" },
    { { 0x00, 0x09, 0x86 }, "Metalink",     "Metalink LTD." },
    { { 0x00, 0x09, 0x87 }, "NishiNipponE", "Nishi Nippon Electric Wire & Cable Co.,Ltd." },
    { { 0x00, 0x09, 0x88 }, "NudianElectr", "Nudian Electron Co., Ltd." },
    { { 0x00, 0x09, 0x89 }, "VividLogic",   "VividLogic Inc." },
    { { 0x00, 0x09, 0x8A }, "EqualLogic",   "EqualLogic Inc" },
    { { 0x00, 0x09, 0x8B }, "EntropicComm", "Entropic Communications, Inc." },
    { { 0x00, 0x09, 0x8C }, "OptionWirele", "Option Wireless Sweden" },
    { { 0x00, 0x09, 0x8D }, "VelocitySemi", "Velocity Semiconductor" },
    { { 0x00, 0x09, 0x8E }, "ipcas",        "ipcas GmbH" },
    { { 0x00, 0x09, 0x8F }, "CetaceanNetw", "Cetacean Networks" },
    { { 0x00, 0x09, 0x90 }, "ACKSYSCommun", "ACKSYS Communications & systems" },
    { { 0x00, 0x09, 0x91 }, "IntelligentP", "Intelligent Platforms, LLC." },
    { { 0x00, 0x09, 0x92 }, "InterEpochTe", "InterEpoch Technology,INC." },
    { { 0x00, 0x09, 0x93 }, "Visteon",      "Visteon Corporation" },
    { { 0x00, 0x09, 0x94 }, "CronyxEngine", "Cronyx Engineering" },
    { { 0x00, 0x09, 0x95 }, "CastleTechno", "Castle Technology Ltd" },
    { { 0x00, 0x09, 0x96 }, "Rdi",          "Rdi" },
    { { 0x00, 0x09, 0x97 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x09, 0x98 }, "Capinfo",      "Capinfo Company Limited" },
    { { 0x00, 0x09, 0x99 }, "CpGeorgesRen", "Cp Georges Renault" },
    { { 0x00, 0x09, 0x9A }, "Elmo",         "Elmo Company, Limited" },
    { { 0x00, 0x09, 0x9B }, "WesternTelem", "Western Telematic Inc." },
    { { 0x00, 0x09, 0x9C }, "NavalResearc", "Naval Research Laboratory" },
    { { 0x00, 0x09, 0x9D }, "HaliplexComm", "Haliplex Communications" },
    { { 0x00, 0x09, 0x9E }, "Testech",      "Testech, Inc." },
    { { 0x00, 0x09, 0x9F }, "Videx",        "Videx Inc." },
    { { 0x00, 0x09, 0xA0 }, "Microtechno",  "Microtechno Corporation" },
    { { 0x00, 0x09, 0xA1 }, "TelewiseComm", "Telewise Communications, Inc." },
    { { 0x00, 0x09, 0xA2 }, "Interface",    "Interface Co., Ltd." },
    { { 0x00, 0x09, 0xA3 }, "LeadflyTecho", "Leadfly Techologies Corp. Ltd." },
    { { 0x00, 0x09, 0xA4 }, "HARTEC",       "HARTEC Corporation" },
    { { 0x00, 0x09, 0xA5 }, "HansungEletr", "Hansung Eletronic Industries Development Co., Ltd" },
    { { 0x00, 0x09, 0xA6 }, "IgnisOptics",  "Ignis Optics, Inc." },
    { { 0x00, 0x09, 0xA7 }, "BangOlufsen",  "Bang & Olufsen A/S" },
    { { 0x00, 0x09, 0xA8 }, "EastmodePte",  "Eastmode Pte Ltd" },
    { { 0x00, 0x09, 0xA9 }, "IkanosCommun", "Ikanos Communications" },
    { { 0x00, 0x09, 0xAA }, "DataCommforB", "Data Comm for Business, Inc." },
    { { 0x00, 0x09, 0xAB }, "Netcontrol",   "Netcontrol Oy" },
    { { 0x00, 0x09, 0xAC }, "Lanvoice",     "Lanvoice" },
    { { 0x00, 0x09, 0xAD }, "HyundaiSysco", "Hyundai Syscomm, Inc." },
    { { 0x00, 0x09, 0xAE }, "OkanoElectri", "Okano Electric Co.,Ltd" },
    { { 0x00, 0x09, 0xAF }, "egeneris",     "e-generis" },
    { { 0x00, 0x09, 0xB0 }, "OnkyoTechnol", "Onkyo Technology K.K." },
    { { 0x00, 0x09, 0xB1 }, "KanematsuEle", "Kanematsu Electronics, Ltd." },
    { { 0x00, 0x09, 0xB2 }, "L&F",          "L&F Inc." },
    { { 0x00, 0x09, 0xB3 }, "MCM",          "MCM Systems Ltd" },
    { { 0x00, 0x09, 0xB4 }, "KisanTelecom", "Kisan Telecom Co., Ltd." },
    { { 0x00, 0x09, 0xB5 }, "3JTech",       "3J Tech. Co., Ltd." },
    { { 0x00, 0x09, 0xB6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0xB7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0xB8 }, "Entise",       "Entise Systems" },
    { { 0x00, 0x09, 0xB9 }, "ActionImagin", "Action Imaging Solutions" },
    { { 0x00, 0x09, 0xBA }, "MAKUInformat", "MAKU Informationstechik GmbH" },
    { { 0x00, 0x09, 0xBB }, "MathStar",     "MathStar, Inc." },
    { { 0x00, 0x09, 0xBC }, "Utility",      "Utility, Inc" },
    { { 0x00, 0x09, 0xBD }, "EpygiTechnol", "Epygi Technologies, Ltd." },
    { { 0x00, 0x09, 0xBE }, "MamiyaOP",     "Mamiya-OP Co.,Ltd." },
    { { 0x00, 0x09, 0xBF }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x09, 0xC0 }, "6Wind",        "6Wind" },
    { { 0x00, 0x09, 0xC1 }, "ProcesData",   "Proces-Data A/S" },
    { { 0x00, 0x09, 0xC2 }, "Onity",        "Onity, Inc." },
    { { 0x00, 0x09, 0xC3 }, "Netas",        "Netas" },
    { { 0x00, 0x09, 0xC4 }, "Medicore",     "Medicore Co., Ltd" },
    { { 0x00, 0x09, 0xC5 }, "KINGENETechn", "KINGENE Technology Corporation" },
    { { 0x00, 0x09, 0xC6 }, "Visionics",    "Visionics Corporation" },
    { { 0x00, 0x09, 0xC7 }, "Movistec",     "Movistec" },
    { { 0x00, 0x09, 0xC8 }, "SinagawaTsus", "Sinagawa Tsushin Keisou Service" },
    { { 0x00, 0x09, 0xC9 }, "BlueWINC",     "BlueWINC Co., Ltd." },
    { { 0x00, 0x09, 0xCA }, "iMaxNetworks", "iMaxNetworks(Shenzhen)Limited." },
    { { 0x00, 0x09, 0xCB }, "HBrain",       "HBrain" },
    { { 0x00, 0x09, 0xCC }, "Moog",         "Moog GmbH" },
    { { 0x00, 0x09, 0xCD }, "HudsonSoft",   "Hudson Soft Co.,Ltd." },
    { { 0x00, 0x09, 0xCE }, "SpaceBridgeS", "SpaceBridge Semiconductor Corp." },
    { { 0x00, 0x09, 0xCF }, "iAd",          "iAd GmbH" },
    { { 0x00, 0x09, 0xD0 }, "SolacomTechn", "Solacom Technologies Inc." },
    { { 0x00, 0x09, 0xD1 }, "SeranoaNetwo", "Seranoa Networks Inc" },
    { { 0x00, 0x09, 0xD2 }, "MaiLogic",     "Mai Logic Inc." },
    { { 0x00, 0x09, 0xD3 }, "WesternDataC", "Western DataCom Co., Inc." },
    { { 0x00, 0x09, 0xD4 }, "TranstechNet", "Transtech Networks" },
    { { 0x00, 0x09, 0xD5 }, "SignalCommun", "Signal Communication, Inc." },
    { { 0x00, 0x09, 0xD6 }, "KNCOne",       "KNC One GmbH" },
    { { 0x00, 0x09, 0xD7 }, "DCSecurityPr", "DC Security Products" },
    { { 0x00, 0x09, 0xD8 }, "FältCommunic", "Fält Communications AB" },
    { { 0x00, 0x09, 0xD9 }, "Neoscale",     "Neoscale Systems, Inc" },
    { { 0x00, 0x09, 0xDA }, "ControlModul", "Control Module Inc." },
    { { 0x00, 0x09, 0xDB }, "eSpace",       "eSpace" },
    { { 0x00, 0x09, 0xDC }, "GalaxisTechn", "Galaxis Technology AG" },
    { { 0x00, 0x09, 0xDD }, "MavinTechnol", "Mavin Technology Inc." },
    { { 0x00, 0x09, 0xDE }, "SamjinInform", "Samjin Information & Communications Co., Ltd." },
    { { 0x00, 0x09, 0xDF }, "VestelElektr", "Vestel Elektronik San ve Tic. A.S." },
    { { 0x00, 0x09, 0xE0 }, "Xemics",       "Xemics S.A." },
    { { 0x00, 0x09, 0xE1 }, "GemtekTechno", "Gemtek Technology Co., Ltd." },
    { { 0x00, 0x09, 0xE2 }, "SinbonElectr", "Sinbon Electronics Co., Ltd." },
    { { 0x00, 0x09, 0xE3 }, "AngelIglesia", "Angel Iglesias S.A." },
    { { 0x00, 0x09, 0xE4 }, "KTechInfosys", "K Tech Infosystem Inc." },
    { { 0x00, 0x09, 0xE5 }, "HottingerBrü", "Hottinger Brüel & Kjaer GmbH" },
    { { 0x00, 0x09, 0xE6 }, "CyberSwitchi", "Cyber Switching Inc." },
    { { 0x00, 0x09, 0xE7 }, "ADCTechonolo", "ADC Techonology" },
    { { 0x00, 0x09, 0xE8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0xE9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x09, 0xEA }, "YEM",          "YEM Inc." },
    { { 0x00, 0x09, 0xEB }, "HuMANDATA",    "HuMANDATA LTD." },
    { { 0x00, 0x09, 0xEC }, "Daktronics",   "Daktronics, Inc." },
    { { 0x00, 0x09, 0xED }, "CipherOptics", "CipherOptics" },
    { { 0x00, 0x09, 0xEE }, "MeikyoElectr", "Meikyo Electric Co.,Ltd" },
    { { 0x00, 0x09, 0xEF }, "VoceraCommun", "Vocera Communications" },
    { { 0x00, 0x09, 0xF0 }, "ShimizuTechn", "Shimizu Technology Inc." },
    { { 0x00, 0x09, 0xF1 }, "YamakiElectr", "Yamaki Electric Corporation" },
    { { 0x00, 0x09, 0xF2 }, "CohuElectron", "Cohu, Inc., Electronics Division" },
    { { 0x00, 0x09, 0xF3 }, "WELLCommunic", "WELL Communication Corp." },
    { { 0x00, 0x09, 0xF4 }, "AlconLaborat", "Alcon Laboratories, Inc." },
    { { 0x00, 0x09, 0xF5 }, "EmersonNetwo", "Emerson Network Power Co.,Ltd" },
    { { 0x00, 0x09, 0xF6 }, "EasternDigit", "Shenzhen Eastern Digital Tech Ltd." },
    { { 0x00, 0x09, 0xF7 }, "CalianAdvanc", "Calian Advanced Technologies" },
    { { 0x00, 0x09, 0xF8 }, "UnimoTechnol", "Unimo Technology Co., Ltd." },
    { { 0x00, 0x09, 0xF9 }, "ArtJapan",     "Art Japan Co., Ltd." },
    { { 0x00, 0x09, 0xFB }, "PhilipsPatie", "Philips Patient Monitoring" },
    { { 0x00, 0x09, 0xFC }, "IPFLEX",       "IPFLEX Inc." },
    { { 0x00, 0x09, 0xFD }, "Ubinetics",    "Ubinetics Limited" },
    { { 0x00, 0x09, 0xFE }, "DaisyTechnol", "Daisy Technologies, Inc." },
    { { 0x00, 0x09, 0xFF }, "Xnet2000",     "X.net 2000 GmbH" },
    { { 0x00, 0x0A, 0x00 }, "Mediatek",     "Mediatek Corp." },
    { { 0x00, 0x0A, 0x01 }, "SOHOware",     "SOHOware, Inc." },
    { { 0x00, 0x0A, 0x02 }, "Annso",        "Annso Co., Ltd." },
    { { 0x00, 0x0A, 0x03 }, "EndesaServic", "Endesa Servicios, S.L." },
    { { 0x00, 0x0A, 0x04 }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x0A, 0x05 }, "Widax",        "Widax Corp." },
    { { 0x00, 0x0A, 0x06 }, "Teledex",      "Teledex LLC" },
    { { 0x00, 0x0A, 0x07 }, "WebWayOne",    "WebWayOne Ltd" },
    { { 0x00, 0x0A, 0x08 }, "AlpsAlpine",   "Alps Alpine" },
    { { 0x00, 0x0A, 0x09 }, "TaraComInteg", "TaraCom Integrated Products, Inc." },
    { { 0x00, 0x0A, 0x0A }, "SUNIX",        "SUNIX Co., Ltd." },
    { { 0x00, 0x0A, 0x0B }, "Sealevel",     "Sealevel Systems, Inc." },
    { { 0x00, 0x0A, 0x0C }, "ScientificRe", "Scientific Research Corporation" },
    { { 0x00, 0x0A, 0x0D }, "Amphenol",     "Amphenol" },
    { { 0x00, 0x0A, 0x0E }, "InvivoResear", "Invivo Research Inc." },
    { { 0x00, 0x0A, 0x0F }, "IlryungTeles", "Ilryung Telesys, Inc" },
    { { 0x00, 0x0A, 0x10 }, "FASTmediaint", "FAST media integrations AG" },
    { { 0x00, 0x0A, 0x11 }, "ExPetTechnol", "ExPet Technologies, Inc" },
    { { 0x00, 0x0A, 0x12 }, "AzylexTechno", "Azylex Technology, Inc" },
    { { 0x00, 0x0A, 0x13 }, "HoneywellVid", "Honeywell Video Systems" },
    { { 0x00, 0x0A, 0x14 }, "TECO",         "TECO a.s." },
    { { 0x00, 0x0A, 0x15 }, "SiliconData",  "Silicon Data, Inc" },
    { { 0x00, 0x0A, 0x16 }, "LassenResear", "Lassen Research" },
    { { 0x00, 0x0A, 0x17 }, "NestarCommun", "Nestar Communications, Inc" },
    { { 0x00, 0x0A, 0x18 }, "Vichel",       "Vichel Inc." },
    { { 0x00, 0x0A, 0x19 }, "ValerePower",  "Valere Power, Inc." },
    { { 0x00, 0x0A, 0x1A }, "Imerge",       "Imerge Ltd" },
    { { 0x00, 0x0A, 0x1B }, "StreamLabs",   "Stream Labs" },
    { { 0x00, 0x0A, 0x1C }, "BridgeInform", "Bridge Information Co., Ltd." },
    { { 0x00, 0x0A, 0x1D }, "OpticalCommu", "Optical Communications Products Inc." },
    { { 0x00, 0x0A, 0x1E }, "RedMProducts", "Red-M Products Limited" },
    { { 0x00, 0x0A, 0x1F }, "ARTWARETelec", "ART WARE Telecommunication Co., Ltd." },
    { { 0x00, 0x0A, 0x20 }, "SVANetworks",  "SVA Networks, Inc." },
    { { 0x00, 0x0A, 0x21 }, "IntegraTelec", "Integra Telecom Co. Ltd" },
    { { 0x00, 0x0A, 0x22 }, "Amperion",     "Amperion Inc" },
    { { 0x00, 0x0A, 0x23 }, "ParamaNetwor", "Parama Networks Inc" },
    { { 0x00, 0x0A, 0x24 }, "OctaveCommun", "Octave Communications" },
    { { 0x00, 0x0A, 0x25 }, "CeragonNetwo", "Ceragon Networks" },
    { { 0x00, 0x0A, 0x26 }, "CEIA",         "CEIA S.p.A." },
    { { 0x00, 0x0A, 0x27 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x0A, 0x28 }, "Motorola",     "Motorola" },
    { { 0x00, 0x0A, 0x29 }, "PanDacomNetw", "Pan Dacom Networking AG" },
    { { 0x00, 0x0A, 0x2A }, "QSI",          "QSI Systems Inc." },
    { { 0x00, 0x0A, 0x2B }, "Etherstuff",   "Etherstuff" },
    { { 0x00, 0x0A, 0x2C }, "ActiveTchnol", "Active Tchnology Corporation" },
    { { 0x00, 0x0A, 0x2D }, "CabotCommuni", "Cabot Communications Limited" },
    { { 0x00, 0x0A, 0x2E }, "MapleNetwork", "Maple Networks Co., Ltd" },
    { { 0x00, 0x0A, 0x2F }, "Artnix",       "Artnix Inc." },
    { { 0x00, 0x0A, 0x30 }, "Visteon",      "Visteon Corporation" },
    { { 0x00, 0x0A, 0x31 }, "HCVConsultin", "HCV Consulting" },
    { { 0x00, 0x0A, 0x32 }, "Xsido",        "Xsido Corporation" },
    { { 0x00, 0x0A, 0x33 }, "Emulex",       "Emulex Corporation" },
    { { 0x00, 0x0A, 0x34 }, "Identicard",   "Identicard Systems Incorporated" },
    { { 0x00, 0x0A, 0x35 }, "Xilinx",       "Xilinx" },
    { { 0x00, 0x0A, 0x36 }, "SynelecTelec", "Synelec Telecom Multimedia" },
    { { 0x00, 0x0A, 0x37 }, "ProceraNetwo", "Procera Networks, Inc." },
    { { 0x00, 0x0A, 0x38 }, "ApaniNetwork", "Apani Networks" },
    { { 0x00, 0x0A, 0x39 }, "LoPAInformat", "LoPA Information Technology" },
    { { 0x00, 0x0A, 0x3A }, "JTHREEINTERN", "J-THREE INTERNATIONAL Holding Co., Ltd." },
    { { 0x00, 0x0A, 0x3B }, "GCTSemicondu", "GCT Semiconductor, Inc" },
    { { 0x00, 0x0A, 0x3C }, "Enerpoint",    "Enerpoint Ltd." },
    { { 0x00, 0x0A, 0x3D }, "EloSistemasE", "Elo Sistemas Eletronicos S.A." },
    { { 0x00, 0x0A, 0x3E }, "EADSTelecom",  "EADS Telecom" },
    { { 0x00, 0x0A, 0x3F }, "DataEast",     "Data East Corporation" },
    { { 0x00, 0x0A, 0x40 }, "CrownAudioHa", "Crown Audio -- Harmanm International" },
    { { 0x00, 0x0A, 0x41 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0x42 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0x43 }, "ChunghwaTele", "Chunghwa Telecom Co., Ltd." },
    { { 0x00, 0x0A, 0x44 }, "AveryDenniso", "Avery Dennison Deutschland GmbH" },
    { { 0x00, 0x0A, 0x45 }, "AudioTechnic", "Audio-Technica Corp." },
    { { 0x00, 0x0A, 0x46 }, "AroWeldingTe", "Aro Welding Technologies Sas" },
    { { 0x00, 0x0A, 0x47 }, "AlliedVision", "Allied Vision Technologies" },
    { { 0x00, 0x0A, 0x48 }, "AlbatronTech", "Albatron Technology" },
    { { 0x00, 0x0A, 0x49 }, "F5Networks",   "F5 Networks, Inc." },
    { { 0x00, 0x0A, 0x4A }, "Targa",        "Targa Systems Ltd." },
    { { 0x00, 0x0A, 0x4B }, "DataPowerTec", "DataPower Technology, Inc." },
    { { 0x00, 0x0A, 0x4C }, "MolecularDev", "Molecular Devices Corporation" },
    { { 0x00, 0x0A, 0x4D }, "Noritz",       "Noritz Corporation" },
    { { 0x00, 0x0A, 0x4E }, "UNITEKElectr", "UNITEK Electronics INC." },
    { { 0x00, 0x0A, 0x4F }, "BrainBoxes",   "Brain Boxes Limited" },
    { { 0x00, 0x0A, 0x50 }, "Remotek",      "Remotek Corporation" },
    { { 0x00, 0x0A, 0x51 }, "GyroSignalTe", "GyroSignal Technology Co., Ltd." },
    { { 0x00, 0x0A, 0x52 }, "AsiaRF",       "AsiaRF Ltd." },
    { { 0x00, 0x0A, 0x53 }, "Intronics",    "Intronics, Incorporated" },
    { { 0x00, 0x0A, 0x54 }, "LagunaHills",  "Laguna Hills, Inc." },
    { { 0x00, 0x0A, 0x55 }, "MARKEM",       "MARKEM Corporation" },
    { { 0x00, 0x0A, 0x56 }, "HITACHIMaxel", "HITACHI Maxell Ltd." },
    { { 0x00, 0x0A, 0x57 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x0A, 0x58 }, "FreyerSiegel", "Freyer & Siegel Elektronik GmbH & Co. KG" },
    { { 0x00, 0x0A, 0x59 }, "HWserver",     "HW server" },
    { { 0x00, 0x0A, 0x5A }, "GreenNETTech", "GreenNET Technologies Co.,Ltd." },
    { { 0x00, 0x0A, 0x5B }, "PowerOneas",   "Power-One as" },
    { { 0x00, 0x0A, 0x5C }, "Carel",        "Carel s.p.a." },
    { { 0x00, 0x0A, 0x5D }, "FingerTecWor", "FingerTec Worldwide Sdn Bhd" },
    { { 0x00, 0x0A, 0x5E }, "3Com",         "3Com" },
    { { 0x00, 0x0A, 0x5F }, "almedio",      "almedio inc." },
    { { 0x00, 0x0A, 0x60 }, "AutostarTech", "Autostar Technology Pte Ltd" },
    { { 0x00, 0x0A, 0x61 }, "Cellinx",      "Cellinx Systems Inc." },
    { { 0x00, 0x0A, 0x62 }, "CrinisNetwor", "Crinis Networks, Inc." },
    { { 0x00, 0x0A, 0x63 }, "DHD",          "DHD GmbH" },
    { { 0x00, 0x0A, 0x64 }, "EracomTechno", "Eracom Technologies" },
    { { 0x00, 0x0A, 0x65 }, "GentechMedia", "GentechMedia.co.,ltd." },
    { { 0x00, 0x0A, 0x66 }, "MitsubishiEl", "Mitsubishi Electric System & Service Co.,Ltd." },
    { { 0x00, 0x0A, 0x67 }, "OngCorp",      "OngCorp" },
    { { 0x00, 0x0A, 0x68 }, "SolarflareCo", "Solarflare Communications Inc." },
    { { 0x00, 0x0A, 0x69 }, "SUNNYbellTec", "SUNNY bell Technology Co., Ltd." },
    { { 0x00, 0x0A, 0x6A }, "SVMMicrowave", "SVM Microwaves s.r.o." },
    { { 0x00, 0x0A, 0x6B }, "TadiranTelec", "Tadiran Telecom Business Systems LTD" },
    { { 0x00, 0x0A, 0x6C }, "Walchem",      "Walchem Corporation" },
    { { 0x00, 0x0A, 0x6D }, "EKSElektroni", "EKS Elektronikservice GmbH" },
    { { 0x00, 0x0A, 0x6E }, "Harmonic",     "Harmonic, Inc" },
    { { 0x00, 0x0A, 0x6F }, "ZyFLEXTechno", "ZyFLEX Technologies Inc" },
    { { 0x00, 0x0A, 0x70 }, "MPLSForum",    "MPLS Forum" },
    { { 0x00, 0x0A, 0x71 }, "AvrioTechnol", "Avrio Technologies, Inc" },
    { { 0x00, 0x0A, 0x72 }, "Stec",         "Stec, Inc." },
    { { 0x00, 0x0A, 0x73 }, "ScientificAt", "Scientific Atlanta" },
    { { 0x00, 0x0A, 0x74 }, "ManticomNetw", "Manticom Networks Inc." },
    { { 0x00, 0x0A, 0x75 }, "Caterpillar",  "Caterpillar, Inc" },
    { { 0x00, 0x0A, 0x76 }, "BeidaJadeBir", "Beida Jade Bird Huaguang Technology Co.,Ltd" },
    { { 0x00, 0x0A, 0x77 }, "BluewireTech", "Bluewire Technologies LLC" },
    { { 0x00, 0x0A, 0x78 }, "Olitec",       "Olitec" },
    { { 0x00, 0x0A, 0x79 }, "corega",       "corega K.K" },
    { { 0x00, 0x0A, 0x7A }, "KyoritsuElec", "Kyoritsu Electric Co., Ltd." },
    { { 0x00, 0x0A, 0x7B }, "CorneliusCon", "Cornelius Consult" },
    { { 0x00, 0x0A, 0x7C }, "Tecton",       "Tecton Ltd" },
    { { 0x00, 0x0A, 0x7D }, "Valo",         "Valo, Inc." },
    { { 0x00, 0x0A, 0x7E }, "AdvantageGro", "The Advantage Group" },
    { { 0x00, 0x0A, 0x7F }, "TeradonIndus", "Teradon Industries, Inc" },
    { { 0x00, 0x0A, 0x80 }, "Telkonet",     "Telkonet Inc." },
    { { 0x00, 0x0A, 0x81 }, "TEIMAAudiote", "TEIMA Audiotex S.L." },
    { { 0x00, 0x0A, 0x82 }, "TatsutaSyste", "Tatsuta System Electronics Co.,Ltd." },
    { { 0x00, 0x0A, 0x83 }, "SaltoSL",      "Salto Systems S.L." },
    { { 0x00, 0x0A, 0x84 }, "RainsunEnter", "Rainsun Enterprise Co., Ltd." },
    { { 0x00, 0x0A, 0x85 }, "PLATC2",       "PLAT'C2,Inc" },
    { { 0x00, 0x0A, 0x86 }, "Lenze",        "Lenze" },
    { { 0x00, 0x0A, 0x87 }, "IntegratedMi", "Integrated Micromachines Inc." },
    { { 0x00, 0x0A, 0x88 }, "InCypher",     "InCypher S.A." },
    { { 0x00, 0x0A, 0x89 }, "Creval",       "Creval Systems, Inc." },
    { { 0x00, 0x0A, 0x8A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0x8B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0x8C }, "Guardware",    "Guardware Systems Ltd." },
    { { 0x00, 0x0A, 0x8D }, "Eurotherm",    "Eurotherm Limited" },
    { { 0x00, 0x0A, 0x8E }, "Invacom",      "Invacom Ltd" },
    { { 0x00, 0x0A, 0x8F }, "AskaInternat", "Aska International Inc." },
    { { 0x00, 0x0A, 0x90 }, "BaysideInter", "Bayside Interactive, Inc." },
    { { 0x00, 0x0A, 0x91 }, "HemoCue",      "HemoCue AB" },
    { { 0x00, 0x0A, 0x92 }, "Presonus",     "Presonus Corporation" },
    { { 0x00, 0x0A, 0x93 }, "W2Networks",   "W2 Networks, Inc." },
    { { 0x00, 0x0A, 0x94 }, "cellink",      "ShangHai cellink CO., LTD" },
    { { 0x00, 0x0A, 0x95 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x0A, 0x96 }, "MewtelTechno", "Mewtel Technology Inc." },
    { { 0x00, 0x0A, 0x97 }, "SONICblue",    "SONICblue, Inc." },
    { { 0x00, 0x0A, 0x98 }, "MFGwinner",    "M+F Gwinner GmbH & Co" },
    { { 0x00, 0x0A, 0x99 }, "CalampWirele", "Calamp Wireless Networks Inc" },
    { { 0x00, 0x0A, 0x9A }, "AiptekIntern", "Aiptek International Inc" },
    { { 0x00, 0x0A, 0x9B }, "TBGroup",      "TB Group Inc" },
    { { 0x00, 0x0A, 0x9C }, "ServerTechno", "Server Technology, Inc." },
    { { 0x00, 0x0A, 0x9D }, "KingYoungTec", "King Young Technology Co. Ltd." },
    { { 0x00, 0x0A, 0x9E }, "BroadWebCorp", "BroadWeb Corportation" },
    { { 0x00, 0x0A, 0x9F }, "PannawayTech", "Pannaway Technologies, Inc." },
    { { 0x00, 0x0A, 0xA0 }, "CedarPointCo", "Cedar Point Communications" },
    { { 0x00, 0x0A, 0xA1 }, "VVS",          "V V S Limited" },
    { { 0x00, 0x0A, 0xA2 }, "Systek",       "Systek Inc." },
    { { 0x00, 0x0A, 0xA3 }, "ShimafujiEle", "Shimafuji Electric Co.,Ltd." },
    { { 0x00, 0x0A, 0xA4 }, "Surveillance", "Shanghai Surveillance Technology Co,Ltd" },
    { { 0x00, 0x0A, 0xA5 }, "MaxlinkIndus", "Maxlink Industries Limited" },
    { { 0x00, 0x0A, 0xA6 }, "Hochiki",      "Hochiki Corporation" },
    { { 0x00, 0x0A, 0xA7 }, "FEIElectronO", "FEI Electron Optics" },
    { { 0x00, 0x0A, 0xA8 }, "ePipe",        "ePipe Pty. Ltd." },
    { { 0x00, 0x0A, 0xA9 }, "BrooksAutoma", "Brooks Automation GmbH" },
    { { 0x00, 0x0A, 0xAA }, "AltiGenCommu", "AltiGen Communications Inc." },
    { { 0x00, 0x0A, 0xAB }, "ToyotaTechni", "Toyota Technical Development Corporation" },
    { { 0x00, 0x0A, 0xAC }, "TerraTecElec", "TerraTec Electronic GmbH" },
    { { 0x00, 0x0A, 0xAD }, "Stargames",    "Stargames Corporation" },
    { { 0x00, 0x0A, 0xAE }, "RosemountPro", "Rosemount Process Analytical" },
    { { 0x00, 0x0A, 0xAF }, "Pipal",        "Pipal Systems" },
    { { 0x00, 0x0A, 0xB0 }, "LOYTECelectr", "LOYTEC electronics GmbH" },
    { { 0x00, 0x0A, 0xB1 }, "GENETEC",      "GENETEC Corporation" },
    { { 0x00, 0x0A, 0xB2 }, "FresnelWirel", "Fresnel Wireless Systems" },
    { { 0x00, 0x0A, 0xB3 }, "FaGIRA",       "Fa. GIRA" },
    { { 0x00, 0x0A, 0xB4 }, "ETICTelecomm", "ETIC Telecommunications" },
    { { 0x00, 0x0A, 0xB5 }, "DigitalElect", "Digital Electronic Network" },
    { { 0x00, 0x0A, 0xB6 }, "Compunetix",   "Compunetix, Inc" },
    { { 0x00, 0x0A, 0xB7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0xB8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0xB9 }, "AsteraTechno", "Astera Technologies Corp." },
    { { 0x00, 0x0A, 0xBA }, "ArconTechnol", "Arcon Technology Limited" },
    { { 0x00, 0x0A, 0xBB }, "TaiwanSecom",  "Taiwan Secom Co,. Ltd" },
    { { 0x00, 0x0A, 0xBC }, "Seabridge",    "Seabridge Ltd." },
    { { 0x00, 0x0A, 0xBD }, "RupprechtPat", "Rupprecht & Patashnick Co." },
    { { 0x00, 0x0A, 0xBE }, "OPNETTechnol", "OPNET Technologies CO., LTD." },
    { { 0x00, 0x0A, 0xBF }, "HirotaSs",     "Hirota Ss" },
    { { 0x00, 0x0A, 0xC0 }, "FuyohVideoIn", "Fuyoh Video Industry CO., LTD." },
    { { 0x00, 0x0A, 0xC1 }, "Futuretel",    "Futuretel" },
    { { 0x00, 0x0A, 0xC2 }, "FiberHomeDig", "Wuhan FiberHome Digital Technology Co.,Ltd." },
    { { 0x00, 0x0A, 0xC3 }, "eMTechnics",   "eM Technics Co., Ltd." },
    { { 0x00, 0x0A, 0xC4 }, "DaewooTelete", "Daewoo Teletech Co., Ltd" },
    { { 0x00, 0x0A, 0xC5 }, "ColorKinetic", "Color Kinetics" },
    { { 0x00, 0x0A, 0xC6 }, "OvertureNetw", "Overture Networks." },
    { { 0x00, 0x0A, 0xC7 }, "UnicationGro", "Unication Group" },
    { { 0x00, 0x0A, 0xC8 }, "ZPSYS",        "ZPSYS CO.,LTD. (Planning&Management)" },
    { { 0x00, 0x0A, 0xC9 }, "Zambeel",      "Zambeel Inc" },
    { { 0x00, 0x0A, 0xCA }, "YOKOYAMASHOK", "YOKOYAMA SHOKAI CO.,Ltd." },
    { { 0x00, 0x0A, 0xCB }, "XPAKMSAGroup", "XPAK MSA Group" },
    { { 0x00, 0x0A, 0xCC }, "WinnowNetwor", "Winnow Networks, Inc." },
    { { 0x00, 0x0A, 0xCD }, "SunrichTechn", "Sunrich Technology Limited" },
    { { 0x00, 0x0A, 0xCE }, "Radiantech",   "Radiantech, Inc." },
    { { 0x00, 0x0A, 0xCF }, "PROVIDEOMult", "PROVIDEO Multimedia Co. Ltd." },
    { { 0x00, 0x0A, 0xD0 }, "NiigataDevel", "Niigata Develoment Center, F.I.T. Co., Ltd." },
    { { 0x00, 0x0A, 0xD1 }, "Mws",          "Mws" },
    { { 0x00, 0x0A, 0xD2 }, "JEPICO",       "JEPICO Corporation" },
    { { 0x00, 0x0A, 0xD3 }, "INITECH",      "INITECH Co., Ltd" },
    { { 0x00, 0x0A, 0xD4 }, "CoreBell",     "CoreBell Systems Inc." },
    { { 0x00, 0x0A, 0xD5 }, "BrainchildEl", "Brainchild Electronic Co., Ltd." },
    { { 0x00, 0x0A, 0xD6 }, "BeamReachNet", "BeamReach Networks" },
    { { 0x00, 0x0A, 0xD7 }, "Origin",       "Origin Co., Ltd." },
    { { 0x00, 0x0A, 0xD8 }, "IPCservTechn", "IPCserv Technology Corp." },
    { { 0x00, 0x0A, 0xD9 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x0A, 0xDA }, "VindicatorTe", "Vindicator Technologies" },
    { { 0x00, 0x0A, 0xDB }, "Trilliant",    "Trilliant" },
    { { 0x00, 0x0A, 0xDC }, "RuggedCom",    "RuggedCom Inc." },
    { { 0x00, 0x0A, 0xDD }, "Allworx",      "Allworx Corp." },
    { { 0x00, 0x0A, 0xDE }, "HappyCommuni", "Happy Communication Co., Ltd." },
    { { 0x00, 0x0A, 0xDF }, "Gennum",       "Gennum Corporation" },
    { { 0x00, 0x0A, 0xE0 }, "FujitsuSofte", "Fujitsu Softek" },
    { { 0x00, 0x0A, 0xE1 }, "EGTechnology", "EG Technology" },
    { { 0x00, 0x0A, 0xE2 }, "BinatoneElec", "Binatone Electronics International, Ltd" },
    { { 0x00, 0x0A, 0xE3 }, "YangMeiTechn", "Yang Mei Technology Co., Ltd" },
    { { 0x00, 0x0A, 0xE4 }, "Wistron",      "Wistron Corporation" },
    { { 0x00, 0x0A, 0xE5 }, "ScottCare",    "ScottCare Corporation" },
    { { 0x00, 0x0A, 0xE6 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x0A, 0xE7 }, "Eliop",        "Eliop S.A." },
    { { 0x00, 0x0A, 0xE8 }, "CathayRoxusI", "Cathay Roxus Information Technology Co. LTD" },
    { { 0x00, 0x0A, 0xE9 }, "AirVastTechn", "AirVast Technology Inc." },
    { { 0x00, 0x0A, 0xEA }, "AdamElektron", "Adam Elektronik Ltd. Şti" },
    { { 0x00, 0x0A, 0xEB }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x0A, 0xEC }, "KoatsuGasKog", "Koatsu Gas Kogyo Co., Ltd." },
    { { 0x00, 0x0A, 0xED }, "HARTINGElect", "HARTING Electronics GmbH" },
    { { 0x00, 0x0A, 0xEE }, "GCDHardSoftw", "GCD Hard- & Software GmbH" },
    { { 0x00, 0x0A, 0xEF }, "OtrumAsa",     "Otrum Asa" },
    { { 0x00, 0x0A, 0xF0 }, "ShinOhElectr", "Shin-Oh Electronics Co., Ltd. R&D" },
    { { 0x00, 0x0A, 0xF1 }, "ClarityDesig", "Clarity Design, Inc." },
    { { 0x00, 0x0A, 0xF2 }, "NeoAxiom",     "NeoAxiom Corp." },
    { { 0x00, 0x0A, 0xF3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0xF4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0A, 0xF5 }, "AirgoNetwork", "Airgo Networks, Inc." },
    { { 0x00, 0x0A, 0xF6 }, "CopelandLP",   "Copeland LP" },
    { { 0x00, 0x0A, 0xF7 }, "Broadcom",     "Broadcom" },
    { { 0x00, 0x0A, 0xF8 }, "AmericanTele", "American Telecare Inc." },
    { { 0x00, 0x0A, 0xF9 }, "HiConnect",    "HiConnect, Inc." },
    { { 0x00, 0x0A, 0xFA }, "TraverseTech", "Traverse Technologies Australia" },
    { { 0x00, 0x0A, 0xFB }, "Ambri",        "Ambri Limited" },
    { { 0x00, 0x0A, 0xFC }, "CoreTecCommu", "Core Tec Communications, LLC" },
    { { 0x00, 0x0A, 0xFD }, "KentecElectr", "Kentec Electronics" },
    { { 0x00, 0x0A, 0xFE }, "NovaPal",      "NovaPal Ltd" },
    { { 0x00, 0x0A, 0xFF }, "KilchherrEle", "Kilchherr Elektronik AG" },
    { { 0x00, 0x0B, 0x00 }, "FujianStartC", "Fujian Start Computer Equipment Co.,Ltd" },
    { { 0x00, 0x0B, 0x01 }, "DaiichiElect", "Daiichi Electronics Co., Ltd." },
    { { 0x00, 0x0B, 0x02 }, "Dallmeierele", "Dallmeier electronic" },
    { { 0x00, 0x0B, 0x03 }, "TaekwangIndu", "Taekwang Industrial Co., Ltd" },
    { { 0x00, 0x0B, 0x04 }, "Volktek",      "Volktek Corporation" },
    { { 0x00, 0x0B, 0x05 }, "PacificBroad", "Pacific Broadband Networks" },
    { { 0x00, 0x0B, 0x06 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x0B, 0x07 }, "VoxpathNetwo", "Voxpath Networks" },
    { { 0x00, 0x0B, 0x08 }, "PillarData",   "Pillar Data Systems" },
    { { 0x00, 0x0B, 0x09 }, "IfoundrySing", "Ifoundry Systems Singapore" },
    { { 0x00, 0x0B, 0x0A }, "dBmOptics",    "dBm Optics" },
    { { 0x00, 0x0B, 0x0B }, "Corrent",      "Corrent Corporation" },
    { { 0x00, 0x0B, 0x0C }, "Agile",        "Agile Systems Inc." },
    { { 0x00, 0x0B, 0x0D }, "Air2U",        "Air2U, Inc." },
    { { 0x00, 0x0B, 0x0E }, "TrapezeNetwo", "Trapeze Networks" },
    { { 0x00, 0x0B, 0x0F }, "BoschRexroth", "Bosch Rexroth" },
    { { 0x00, 0x0B, 0x10 }, "11waveTechno", "11wave Technonlogy Co.,Ltd" },
    { { 0x00, 0x0B, 0x11 }, "HimejiAbcTra", "Himeji Abc Trading Co.,Ltd." },
    { { 0x00, 0x0B, 0x12 }, "NURITelecom",  "NURI Telecom Co., Ltd." },
    { { 0x00, 0x0B, 0x13 }, "Zetron",       "Zetron Inc" },
    { { 0x00, 0x0B, 0x14 }, "ViewSonic",    "ViewSonic Corporation" },
    { { 0x00, 0x0B, 0x15 }, "PlatypusTech", "Platypus Technology" },
    { { 0x00, 0x0B, 0x16 }, "Communicatio", "Communication Machinery Corporation" },
    { { 0x00, 0x0B, 0x17 }, "MKSInstrumen", "MKS Instruments" },
    { { 0x00, 0x0B, 0x18 }, "Private",      "Private" },
    { { 0x00, 0x0B, 0x19 }, "VernierNetwo", "Vernier Networks, Inc." },
    { { 0x00, 0x0B, 0x1A }, "IndustrialDe", "Industrial Defender, Inc." },
    { { 0x00, 0x0B, 0x1B }, "Systronix",    "Systronix, Inc." },
    { { 0x00, 0x0B, 0x1C }, "SIBCO",        "SIBCO bv" },
    { { 0x00, 0x0B, 0x1D }, "LayerZeroPow", "LayerZero Power Systems, Inc." },
    { { 0x00, 0x0B, 0x1E }, "KAPPAoptoele", "KAPPA opto-electronics GmbH" },
    { { 0x00, 0x0B, 0x1F }, "ICONComputer", "I CON Computer Co." },
    { { 0x00, 0x0B, 0x20 }, "Hirata",       "Hirata corporation" },
    { { 0x00, 0x0B, 0x21 }, "GStarCommuni", "G-Star Communications Inc." },
    { { 0x00, 0x0B, 0x22 }, "Environmenta", "Environmental Systems and Services" },
    { { 0x00, 0x0B, 0x23 }, "SiemensHomeO", "Siemens Home & Office Comm. Devices" },
    { { 0x00, 0x0B, 0x24 }, "AirLogic",     "AirLogic" },
    { { 0x00, 0x0B, 0x25 }, "Aeluros",      "Aeluros" },
    { { 0x00, 0x0B, 0x26 }, "Wetek",        "Wetek Corporation" },
    { { 0x00, 0x0B, 0x27 }, "Scion",        "Scion Corporation" },
    { { 0x00, 0x0B, 0x28 }, "Quatech",      "Quatech Inc." },
    { { 0x00, 0x0B, 0x29 }, "LSIndustrial", "LS(LG) Industrial Systems co.,Ltd" },
    { { 0x00, 0x0B, 0x2A }, "HOWTEL",       "HOWTEL Co., Ltd." },
    { { 0x00, 0x0B, 0x2B }, "Hostnet",      "Hostnet Corporation" },
    { { 0x00, 0x0B, 0x2C }, "EikiIndustri", "Eiki Industrial Co. Ltd." },
    { { 0x00, 0x0B, 0x2D }, "Danfoss",      "Danfoss Inc." },
    { { 0x00, 0x0B, 0x2E }, "CalCompElect", "Cal-Comp Electronics & Communications Company Ltd." },
    { { 0x00, 0x0B, 0x2F }, "bplan",        "bplan GmbH" },
    { { 0x00, 0x0B, 0x30 }, "GongyeScienc", "Beijing Gongye Science & Technology Co.,Ltd" },
    { { 0x00, 0x0B, 0x31 }, "YantaiZhiYan", "Yantai ZhiYang Scientific and technology industry CO., LTD" },
    { { 0x00, 0x0B, 0x32 }, "Vormetric",    "Vormetric, Inc." },
    { { 0x00, 0x0B, 0x33 }, "VivatoTechno", "Vivato Technologies" },
    { { 0x00, 0x0B, 0x34 }, "BroadbandTec", "ShangHai Broadband Technologies CO.LTD" },
    { { 0x00, 0x0B, 0x35 }, "QuadBitSyste", "Quad Bit System co., Ltd." },
    { { 0x00, 0x0B, 0x36 }, "Productivity", "Productivity Systems, Inc." },
    { { 0x00, 0x0B, 0x37 }, "ManufactureD", "Manufacture Des Montres Rolex Sa" },
    { { 0x00, 0x0B, 0x38 }, "Knürr",        "Knürr GmbH" },
    { { 0x00, 0x0B, 0x39 }, "KeisokuGiken", "Keisoku Giken Co.,Ltd." },
    { { 0x00, 0x0B, 0x3A }, "PESA",         "PESA Inc." },
    { { 0x00, 0x0B, 0x3B }, "devolo",       "devolo AG" },
    { { 0x00, 0x0B, 0x3C }, "CygnalIntegr", "Cygnal Integrated Products, Inc." },
    { { 0x00, 0x0B, 0x3D }, "CONTALOK",     "CONTAL OK Ltd." },
    { { 0x00, 0x0B, 0x3E }, "BittWare",     "BittWare, Inc" },
    { { 0x00, 0x0B, 0x3F }, "AnthologySol", "Anthology Solutions Inc." },
    { { 0x00, 0x0B, 0x40 }, "CambridgeInd", "Cambridge Industries Group (CIG)" },
    { { 0x00, 0x0B, 0x41 }, "IngBüroDrBeu", "Ing. Büro Dr. Beutlhauser" },
    { { 0x00, 0x0B, 0x42 }, "commax",       "commax Co., Ltd." },
    { { 0x00, 0x0B, 0x43 }, "Microscan",    "Microscan Systems, Inc." },
    { { 0x00, 0x0B, 0x44 }, "ConcordIdea",  "Concord Idea Corp." },
    { { 0x00, 0x0B, 0x45 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0x46 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0x47 }, "AdvancedEner", "Advanced Energy" },
    { { 0x00, 0x0B, 0x48 }, "sofrel",       "sofrel" },
    { { 0x00, 0x0B, 0x49 }, "RFLinkSystem", "RF-Link System Inc." },
    { { 0x00, 0x0B, 0x4A }, "Visimetrics",  "Visimetrics (UK) Ltd" },
    { { 0x00, 0x0B, 0x4B }, "Visiowave",    "Visiowave Sa" },
    { { 0x00, 0x0B, 0x4C }, "ClarionSdnBh", "Clarion (M) Sdn Bhd" },
    { { 0x00, 0x0B, 0x4D }, "Emuzed",       "Emuzed" },
    { { 0x00, 0x0B, 0x4E }, "Communicatio", "Communications & Power Industries" },
    { { 0x00, 0x0B, 0x4F }, "Verifone",     "Verifone" },
    { { 0x00, 0x0B, 0x50 }, "Oxygnet",      "Oxygnet" },
    { { 0x00, 0x0B, 0x51 }, "MicetekInter", "Micetek International Inc." },
    { { 0x00, 0x0B, 0x52 }, "JoymaxElectr", "Joymax Electronics Co. Ltd." },
    { { 0x00, 0x0B, 0x53 }, "INITIUM",      "INITIUM Co., Ltd." },
    { { 0x00, 0x0B, 0x54 }, "BiTMICRONetw", "BiTMICRO Networks, Inc." },
    { { 0x00, 0x0B, 0x55 }, "ADInstrument", "ADInstruments" },
    { { 0x00, 0x0B, 0x56 }, "Cybernetics",  "Cybernetics" },
    { { 0x00, 0x0B, 0x57 }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x00, 0x0B, 0x58 }, "Astronautics", "Astronautics C.A LTD" },
    { { 0x00, 0x0B, 0x59 }, "ScriptPro",    "ScriptPro, LLC" },
    { { 0x00, 0x0B, 0x5A }, "HyperEdge",    "HyperEdge" },
    { { 0x00, 0x0B, 0x5B }, "RinconResear", "Rincon Research Corporation" },
    { { 0x00, 0x0B, 0x5C }, "Newtech",      "Newtech Co.,Ltd" },
    { { 0x00, 0x0B, 0x5D }, "Fujitsu",      "Fujitsu Limited" },
    { { 0x00, 0x0B, 0x5E }, "AudioEnginee", "Audio Engineering Society Inc." },
    { { 0x00, 0x0B, 0x5F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0x60 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0x61 }, "FriedrichLüt", "Friedrich Lütze GmbH & Co. KG" },
    { { 0x00, 0x0B, 0x62 }, "ibmohnen",     "ib-mohnen KG" },
    { { 0x00, 0x0B, 0x63 }, "Kaleidescape", "Kaleidescape" },
    { { 0x00, 0x0B, 0x64 }, "KiebackPeter", "Kieback & Peter GmbH & Co KG" },
    { { 0x00, 0x0B, 0x65 }, "SyAC",         "Sy.A.C. srl" },
    { { 0x00, 0x0B, 0x66 }, "TeralinkComm", "Teralink Communications" },
    { { 0x00, 0x0B, 0x67 }, "TopviewTechn", "Topview Technology Corporation" },
    { { 0x00, 0x0B, 0x68 }, "AddvalueComm", "Addvalue Communications Pte Ltd" },
    { { 0x00, 0x0B, 0x69 }, "FrankeFinlan", "Franke Finland Oy" },
    { { 0x00, 0x0B, 0x6A }, "AsiarockTech", "Asiarock Technology Limited" },
    { { 0x00, 0x0B, 0x6B }, "WistronNeweb", "Wistron Neweb Corporation" },
    { { 0x00, 0x0B, 0x6C }, "Sychip",       "Sychip Inc." },
    { { 0x00, 0x0B, 0x6D }, "SolectronJap", "Solectron Japan Nakaniida" },
    { { 0x00, 0x0B, 0x6E }, "NeffInstrume", "Neff Instrument Corp." },
    { { 0x00, 0x0B, 0x6F }, "MediaStreami", "Media Streaming Networks Inc" },
    { { 0x00, 0x0B, 0x70 }, "LoadTechnolo", "Load Technology, Inc." },
    { { 0x00, 0x0B, 0x71 }, "LitchfieldCo", "Litchfield Communications Inc." },
    { { 0x00, 0x0B, 0x72 }, "Lawo",         "Lawo AG" },
    { { 0x00, 0x0B, 0x73 }, "KodeosCommun", "Kodeos Communications" },
    { { 0x00, 0x0B, 0x74 }, "KingwaveTech", "Kingwave Technology Co., Ltd." },
    { { 0x00, 0x0B, 0x75 }, "Iosoft",       "Iosoft Ltd." },
    { { 0x00, 0x0B, 0x76 }, "ET&TTechnolo", "ET&T Technology Co. Ltd." },
    { { 0x00, 0x0B, 0x77 }, "Cogent",       "Cogent Systems, Inc." },
    { { 0x00, 0x0B, 0x78 }, "Taifatech",    "Taifatech Inc." },
    { { 0x00, 0x0B, 0x79 }, "XCOM",         "X-COM, Inc." },
    { { 0x00, 0x0B, 0x7A }, "L3Linkabit",   "L-3 Linkabit" },
    { { 0x00, 0x0B, 0x7B }, "TestUm",       "Test-Um Inc." },
    { { 0x00, 0x0B, 0x7C }, "TelexCommuni", "Telex Communications" },
    { { 0x00, 0x0B, 0x7D }, "SolomonExtre", "Solomon Extreme International Ltd." },
    { { 0x00, 0x0B, 0x7E }, "SAGINOMIYASe", "SAGINOMIYA Seisakusho Inc." },
    { { 0x00, 0x0B, 0x7F }, "AlignEnginee", "Align Engineering LLC" },
    { { 0x00, 0x0B, 0x80 }, "LyciumNetwor", "Lycium Networks" },
    { { 0x00, 0x0B, 0x81 }, "Kaparel",      "Kaparel Corporation" },
    { { 0x00, 0x0B, 0x82 }, "GrandstreamN", "Grandstream Networks, Inc." },
    { { 0x00, 0x0B, 0x83 }, "Datawatt",     "Datawatt B.V." },
    { { 0x00, 0x0B, 0x84 }, "Bodet",        "Bodet" },
    { { 0x00, 0x0B, 0x85 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0x86 }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x00, 0x0B, 0x87 }, "AmericanReli", "American Reliance Inc." },
    { { 0x00, 0x0B, 0x88 }, "Vidisco",      "Vidisco ltd." },
    { { 0x00, 0x0B, 0x89 }, "TopGlobalTec", "Top Global Technology, Ltd." },
    { { 0x00, 0x0B, 0x8A }, "MITEQ",        "MITEQ Inc." },
    { { 0x00, 0x0B, 0x8B }, "Kerajet",      "Kerajet, S.A." },
    { { 0x00, 0x0B, 0x8C }, "Flextronics",  "Flextronics" },
    { { 0x00, 0x0B, 0x8D }, "AvvioNetwork", "Avvio Networks" },
    { { 0x00, 0x0B, 0x8E }, "Ascent",       "Ascent Corporation" },
    { { 0x00, 0x0B, 0x8F }, "AkitaElectro", "Akita Electronics Systems Co.,Ltd." },
    { { 0x00, 0x0B, 0x90 }, "ADVAOpticalN", "ADVA Optical Networking Ltd." },
    { { 0x00, 0x0B, 0x91 }, "AglaiaGesell", "Aglaia Gesellschaft für Bildverarbeitung und Kommunikation mbH" },
    { { 0x00, 0x0B, 0x92 }, "AscomDanmark", "Ascom Danmark A/S" },
    { { 0x00, 0x0B, 0x93 }, "RitterElektr", "Ritter Elektronik" },
    { { 0x00, 0x0B, 0x94 }, "DigitalMonit", "Digital Monitoring Products, Inc." },
    { { 0x00, 0x0B, 0x95 }, "eBetGaming",   "eBet Gaming Systems Pty Ltd" },
    { { 0x00, 0x0B, 0x96 }, "InnotracDiag", "Innotrac Diagnostics Oy" },
    { { 0x00, 0x0B, 0x97 }, "MatsushitaEl", "Matsushita Electric Industrial Co.,Ltd." },
    { { 0x00, 0x0B, 0x98 }, "NiceTechVisi", "NiceTechVision" },
    { { 0x00, 0x0B, 0x99 }, "SensAbleTech", "SensAble Technologies, Inc." },
    { { 0x00, 0x0B, 0x9A }, "UlinkTelecom", "Shanghai Ulink Telecom Equipment Co. Ltd." },
    { { 0x00, 0x0B, 0x9B }, "SiriusSystem", "Sirius System Co, Ltd." },
    { { 0x00, 0x0B, 0x9C }, "TriBeamTechn", "TriBeam Technologies, Inc." },
    { { 0x00, 0x0B, 0x9D }, "TwinMOSTechn", "TwinMOS Technologies Inc." },
    { { 0x00, 0x0B, 0x9E }, "YasingTechno", "Yasing Technology Corp." },
    { { 0x00, 0x0B, 0x9F }, "NeueELSA",     "Neue ELSA GmbH" },
    { { 0x00, 0x0B, 0xA0 }, "T&LInformati", "T&L Information Inc." },
    { { 0x00, 0x0B, 0xA1 }, "FujikuraSolu", "Fujikura Solutions Ltd." },
    { { 0x00, 0x0B, 0xA2 }, "SumitomoElec", "Sumitomo Electric Industries, Ltd" },
    { { 0x00, 0x0B, 0xA3 }, "Siemens",      "Siemens AG" },
    { { 0x00, 0x0B, 0xA4 }, "ShironSatell", "Shiron Satellite Communications Ltd. (1996)" },
    { { 0x00, 0x0B, 0xA5 }, "QuasarCiptaM", "Quasar Cipta Mandiri, PT" },
    { { 0x00, 0x0B, 0xA6 }, "MiyakawaElec", "Miyakawa Electric Works Ltd." },
    { { 0x00, 0x0B, 0xA7 }, "MarantiNetwo", "Maranti Networks" },
    { { 0x00, 0x0B, 0xA8 }, "HanbackElect", "Hanback Electronics Co., Ltd." },
    { { 0x00, 0x0B, 0xA9 }, "CloudShieldT", "CloudShield Technologies, Inc." },
    { { 0x00, 0x0B, 0xAA }, "Aiphone",      "Aiphone co.,Ltd" },
    { { 0x00, 0x0B, 0xAB }, "AdvantechTec", "Advantech Technology (CHINA) Co., Ltd." },
    { { 0x00, 0x0B, 0xAC }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x0B, 0xAD }, "PCPoS",        "PC-PoS Inc." },
    { { 0x00, 0x0B, 0xAE }, "VitalsSystem", "Vitals System Inc." },
    { { 0x00, 0x0B, 0xAF }, "WOOJUCOMMUNI", "WOOJU COMMUNICATIONS Co,.Ltd" },
    { { 0x00, 0x0B, 0xB0 }, "SysnetTelema", "Sysnet Telematica srl" },
    { { 0x00, 0x0B, 0xB1 }, "SuperStarTec", "Super Star Technology Co., Ltd." },
    { { 0x00, 0x0B, 0xB2 }, "SmallbigTech", "Smallbig Technology" },
    { { 0x00, 0x0B, 0xB3 }, "RiTtechnolog", "RiT technologies Ltd." },
    { { 0x00, 0x0B, 0xB4 }, "RDCSemicondu", "RDC Semiconductor Inc.," },
    { { 0x00, 0x0B, 0xB5 }, "nStorTechnol", "nStor Technologies, Inc." },
    { { 0x00, 0x0B, 0xB6 }, "Metalligence", "Metalligence Technology Corp." },
    { { 0x00, 0x0B, 0xB7 }, "Micro",        "Micro Systems Co.,Ltd." },
    { { 0x00, 0x0B, 0xB8 }, "KihokuElectr", "Kihoku Electronic Co." },
    { { 0x00, 0x0B, 0xB9 }, "Imsys",        "Imsys AB" },
    { { 0x00, 0x0B, 0xBA }, "Harmonic",     "Harmonic, Inc" },
    { { 0x00, 0x0B, 0xBB }, "Etin",         "Etin Systems Co., Ltd" },
    { { 0x00, 0x0B, 0xBC }, "EnGarde",      "En Garde Systems, Inc." },
    { { 0x00, 0x0B, 0xBD }, "Connexionz",   "Connexionz Limited" },
    { { 0x00, 0x0B, 0xBE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0xBF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0xC0 }, "ChinaIWNComm", "China IWNComm Co., Ltd." },
    { { 0x00, 0x0B, 0xC1 }, "BayMicrosyst", "Bay Microsystems, Inc." },
    { { 0x00, 0x0B, 0xC2 }, "CorinexCommu", "Corinex Communication Corp." },
    { { 0x00, 0x0B, 0xC3 }, "Multiplex",    "Multiplex, Inc." },
    { { 0x00, 0x0B, 0xC4 }, "BIOTRONIK",    "BIOTRONIK GmbH & Co" },
    { { 0x00, 0x0B, 0xC5 }, "SMCNetworks",  "SMC Networks, Inc." },
    { { 0x00, 0x0B, 0xC6 }, "ISAC",         "ISAC, Inc." },
    { { 0x00, 0x0B, 0xC7 }, "ICET",         "ICET S.p.A." },
    { { 0x00, 0x0B, 0xC8 }, "AirFlowNetwo", "AirFlow Networks" },
    { { 0x00, 0x0B, 0xC9 }, "ElectrolineE", "Electroline Equipment" },
    { { 0x00, 0x0B, 0xCA }, "DatavanTc",    "Datavan Tc" },
    { { 0x00, 0x0B, 0xCB }, "FagorAutomat", "Fagor Automation , S. Coop" },
    { { 0x00, 0x0B, 0xCC }, "Jusan",        "Jusan, S.A." },
    { { 0x00, 0x0B, 0xCD }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x0B, 0xCE }, "Free2move",    "Free2move AB" },
    { { 0x00, 0x0B, 0xCF }, "AgfaNdt",      "Agfa Ndt Inc." },
    { { 0x00, 0x0B, 0xD0 }, "XiMetaTechno", "XiMeta Technology Americas Inc." },
    { { 0x00, 0x0B, 0xD1 }, "Aeronix",      "Aeronix, Inc." },
    { { 0x00, 0x0B, 0xD2 }, "RemoproTechn", "Remopro Technology Inc." },
    { { 0x00, 0x0B, 0xD3 }, "cd3o",         "cd3o" },
    { { 0x00, 0x0B, 0xD4 }, "WiseTechnolo", "Beijing Wise Technology & Science Development Co.Ltd" },
    { { 0x00, 0x0B, 0xD5 }, "Nvergence",    "Nvergence, Inc." },
    { { 0x00, 0x0B, 0xD6 }, "PaxtonAccess", "Paxton Access Ltd" },
    { { 0x00, 0x0B, 0xD7 }, "DORMATimeAcc", "DORMA Time + Access GmbH" },
    { { 0x00, 0x0B, 0xD8 }, "IndustrialSc", "Industrial Scientific Corp." },
    { { 0x00, 0x0B, 0xD9 }, "GeneralHydro", "General Hydrogen" },
    { { 0x00, 0x0B, 0xDA }, "EyeCross",     "EyeCross Co.,Inc." },
    { { 0x00, 0x0B, 0xDB }, "Dell",         "Dell Inc." },
    { { 0x00, 0x0B, 0xDC }, "Akcp",         "Akcp" },
    { { 0x00, 0x0B, 0xDD }, "TOHOKURICOH",  "TOHOKU RICOH Co., LTD." },
    { { 0x00, 0x0B, 0xDE }, "TELDIX",       "TELDIX GmbH" },
    { { 0x00, 0x0B, 0xDF }, "RouterDNetwo", "Shenzhen RouterD Networks Limited" },
    { { 0x00, 0x0B, 0xE0 }, "SercoNet",     "SercoNet Ltd." },
    { { 0x00, 0x0B, 0xE1 }, "NokiaNETProd", "Nokia NET Product Operations" },
    { { 0x00, 0x0B, 0xE2 }, "Lumenera",     "Lumenera Corporation" },
    { { 0x00, 0x0B, 0xE3 }, "KeyStream",    "Key Stream Co., Ltd." },
    { { 0x00, 0x0B, 0xE4 }, "Hosiden",      "Hosiden Corporation" },
    { { 0x00, 0x0B, 0xE5 }, "HIMSInternat", "HIMS International Corporation" },
    { { 0x00, 0x0B, 0xE6 }, "DatelElectro", "Datel Electronics" },
    { { 0x00, 0x0B, 0xE7 }, "ComfluxTechn", "Comflux Technology Inc." },
    { { 0x00, 0x0B, 0xE8 }, "Aoip",         "Aoip" },
    { { 0x00, 0x0B, 0xE9 }, "Actel",        "Actel Corporation" },
    { { 0x00, 0x0B, 0xEA }, "ZultysTechno", "Zultys Technologies" },
    { { 0x00, 0x0B, 0xEB }, "Systegra",     "Systegra AG" },
    { { 0x00, 0x0B, 0xEC }, "NipponElectr", "Nippon Electric Instrument, Inc." },
    { { 0x00, 0x0B, 0xED }, "ELM",          "ELM Inc." },
    { { 0x00, 0x0B, 0xEE }, "incjet",       "inc.jet, Incorporated" },
    { { 0x00, 0x0B, 0xEF }, "Code",         "Code Corporation" },
    { { 0x00, 0x0B, 0xF0 }, "MoTEXProduct", "MoTEX Products Co., Ltd." },
    { { 0x00, 0x0B, 0xF1 }, "LAPLaserAppl", "LAP Laser Applikations" },
    { { 0x00, 0x0B, 0xF2 }, "ChihKanTechn", "Chih-Kan Technology Co., Ltd." },
    { { 0x00, 0x0B, 0xF3 }, "Bae",          "Bae Systems" },
    { { 0x00, 0x0B, 0xF4 }, "Private",      "Private" },
    { { 0x00, 0x0B, 0xF5 }, "SiboTelecomT", "Shanghai Sibo Telecom Technology Co.,Ltd" },
    { { 0x00, 0x0B, 0xF6 }, "Nitgen",       "Nitgen Co., Ltd" },
    { { 0x00, 0x0B, 0xF7 }, "Nidek",        "Nidek Co.,Ltd" },
    { { 0x00, 0x0B, 0xF8 }, "Infinera",     "Infinera, Inc." },
    { { 0x00, 0x0B, 0xF9 }, "GemstoneComm", "Gemstone Communications, Inc." },
    { { 0x00, 0x0B, 0xFA }, "Exemys",       "Exemys Srl" },
    { { 0x00, 0x0B, 0xFB }, "DNETInternat", "D-NET International Corporation" },
    { { 0x00, 0x0B, 0xFC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0xFD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0B, 0xFE }, "CASTELBroadb", "CASTEL Broadband Limited" },
    { { 0x00, 0x0B, 0xFF }, "BerkeleyCame", "Berkeley Camera Engineering" },
    { { 0x00, 0x0C, 0x00 }, "BEBIndustrie", "BEB Industrie-Elektronik AG" },
    { { 0x00, 0x0C, 0x01 }, "Abatron",      "Abatron AG" },
    { { 0x00, 0x0C, 0x02 }, "ABB",          "ABB Oy" },
    { { 0x00, 0x0C, 0x03 }, "HDMILicensin", "HDMI Licensing, LLC" },
    { { 0x00, 0x0C, 0x04 }, "Tecnova",      "Tecnova" },
    { { 0x00, 0x0C, 0x05 }, "RPAReserch",   "RPA Reserch Co., Ltd." },
    { { 0x00, 0x0C, 0x06 }, "NixvuePte",    "Nixvue Systems Pte Ltd" },
    { { 0x00, 0x0C, 0x07 }, "Iftest",       "Iftest AG" },
    { { 0x00, 0x0C, 0x08 }, "HUMEXTechnol", "HUMEX Technologies Corp." },
    { { 0x00, 0x0C, 0x09 }, "HitachiIE",    "Hitachi IE Systems Co., Ltd" },
    { { 0x00, 0x0C, 0x0A }, "ProvinceElec", "Guangdong Province Electronic Technology Research Institute" },
    { { 0x00, 0x0C, 0x0B }, "BroadbusTech", "Broadbus Technologies" },
    { { 0x00, 0x0C, 0x0C }, "ApproTechnol", "Appro Technology Inc." },
    { { 0x00, 0x0C, 0x0D }, "Communicatio", "Communications & Power Industries / Satcom Division" },
    { { 0x00, 0x0C, 0x0E }, "XtremeSpectr", "XtremeSpectrum, Inc." },
    { { 0x00, 0x0C, 0x0F }, "TechnoOne",    "Techno-One Co., Ltd" },
    { { 0x00, 0x0C, 0x10 }, "PNI",          "PNI Corporation" },
    { { 0x00, 0x0C, 0x11 }, "NipponDempa",  "Nippon Dempa Co.,Ltd." },
    { { 0x00, 0x0C, 0x12 }, "MicroOptroni", "Micro-Optronic-Messtechnik GmbH" },
    { { 0x00, 0x0C, 0x13 }, "MediaQ",       "MediaQ" },
    { { 0x00, 0x0C, 0x14 }, "DiagnosticIn", "Diagnostic Instruments, Inc." },
    { { 0x00, 0x0C, 0x15 }, "CyberPower",   "CyberPower Systems, Inc." },
    { { 0x00, 0x0C, 0x16 }, "ConcordeMicr", "Concorde Microsystems Inc." },
    { { 0x00, 0x0C, 0x17 }, "AJAVideo",     "AJA Video Systems Inc" },
    { { 0x00, 0x0C, 0x18 }, "ZenisuKeisok", "Zenisu Keisoku Inc." },
    { { 0x00, 0x0C, 0x19 }, "TelioCommuni", "Telio Communications GmbH" },
    { { 0x00, 0x0C, 0x1A }, "QuestTechnic", "Quest Technical Solutions Inc." },
    { { 0x00, 0x0C, 0x1B }, "ORACOM",       "ORACOM Co, Ltd." },
    { { 0x00, 0x0C, 0x1C }, "MicroWeb",     "MicroWeb Co., Ltd." },
    { { 0x00, 0x0C, 0x1D }, "MettlerFuchs", "Mettler & Fuchs AG" },
    { { 0x00, 0x0C, 0x1E }, "GlobalCache",  "Global Cache" },
    { { 0x00, 0x0C, 0x1F }, "Glimmerglass", "Glimmerglass Networks" },
    { { 0x00, 0x0C, 0x20 }, "FiWIn",        "Fi WIn, Inc." },
    { { 0x00, 0x0C, 0x21 }, "FacultyScien", "Faculty of Science and Technology, Keio University" },
    { { 0x00, 0x0C, 0x22 }, "DoubleDElect", "Double D Electronics Ltd" },
    { { 0x00, 0x0C, 0x23 }, "LanchuanTech", "Beijing Lanchuan Tech. Co., Ltd." },
    { { 0x00, 0x0C, 0x24 }, "Anator",       "Anator" },
    { { 0x00, 0x0C, 0x25 }, "AlliedTelesi", "Allied Telesis Labs, Inc." },
    { { 0x00, 0x0C, 0x26 }, "WeintekLabs",  "Weintek Labs. Inc." },
    { { 0x00, 0x0C, 0x27 }, "Sammy",        "Sammy Corporation" },
    { { 0x00, 0x0C, 0x28 }, "Rifatron",     "Rifatron" },
    { { 0x00, 0x0C, 0x29 }, "VMware",       "VMware, Inc." },
    { { 0x00, 0x0C, 0x2A }, "OCTTELCommun", "OCTTEL Communication Co., Ltd." },
    { { 0x00, 0x0C, 0x2B }, "ELIASTechnol", "ELIAS Technology, Inc." },
    { { 0x00, 0x0C, 0x2C }, "Enwiser",      "Enwiser Inc." },
    { { 0x00, 0x0C, 0x2D }, "FullWaveTech", "FullWave Technology Co., Ltd." },
    { { 0x00, 0x0C, 0x2E }, "Openetinform", "Openet information technology(shenzhen) Co., Ltd." },
    { { 0x00, 0x0C, 0x2F }, "SeorimTechno", "SeorimTechnology Co.,Ltd." },
    { { 0x00, 0x0C, 0x30 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0C, 0x31 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0C, 0x32 }, "AvionicDesig", "Avionic Design GmbH" },
    { { 0x00, 0x0C, 0x33 }, "CompucaseEnt", "Compucase Enterprise Co. Ltd." },
    { { 0x00, 0x0C, 0x34 }, "Vixen",        "Vixen Co., Ltd." },
    { { 0x00, 0x0C, 0x35 }, "KaVoDental",   "KaVo Dental GmbH & Co. KG" },
    { { 0x00, 0x0C, 0x36 }, "STakayaElect", "S-Takaya Electronics Industry Co.,Ltd." },
    { { 0x00, 0x0C, 0x37 }, "Geomation",    "Geomation, Inc." },
    { { 0x00, 0x0C, 0x38 }, "TelcoBridges", "TelcoBridges Inc." },
    { { 0x00, 0x0C, 0x39 }, "SentinelWire", "Sentinel Wireless Inc." },
    { { 0x00, 0x0C, 0x3A }, "Oxance",       "Oxance" },
    { { 0x00, 0x0C, 0x3B }, "OrionElectri", "Orion Electric Co., Ltd." },
    { { 0x00, 0x0C, 0x3C }, "MediaChorus",  "MediaChorus, Inc." },
    { { 0x00, 0x0C, 0x3D }, "Glsystech",    "Glsystech Co., Ltd." },
    { { 0x00, 0x0C, 0x3E }, "CrestAudio",   "Crest Audio" },
    { { 0x00, 0x0C, 0x3F }, "CogentDefenc", "Cogent Defence & Security Networks," },
    { { 0x00, 0x0C, 0x40 }, "AltechContro", "Altech Controls" },
    { { 0x00, 0x0C, 0x41 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x0C, 0x42 }, "Routerboardc", "Routerboard.com" },
    { { 0x00, 0x0C, 0x43 }, "RalinkTechno", "Ralink Technology, Corp." },
    { { 0x00, 0x0C, 0x44 }, "AutomatedInt", "Automated Interfaces, Inc." },
    { { 0x00, 0x0C, 0x45 }, "AnimationTec", "Animation Technologies Inc." },
    { { 0x00, 0x0C, 0x46 }, "AlliedTelesy", "Allied Telesyn Inc." },
    { { 0x00, 0x0C, 0x47 }, "SKTeletech",   "SK Teletech(R&D Planning Team)" },
    { { 0x00, 0x0C, 0x48 }, "QoStek",       "QoStek Corporation" },
    { { 0x00, 0x0C, 0x49 }, "DangaardTele", "Dangaard Telecom Denmark A/S" },
    { { 0x00, 0x0C, 0x4A }, "CygnusMicros", "Cygnus Microsystems (P) Limited" },
    { { 0x00, 0x0C, 0x4B }, "CheopsElektr", "Cheops Elektronik" },
    { { 0x00, 0x0C, 0x4C }, "Arcor&Co",     "Arcor AG&Co." },
    { { 0x00, 0x0C, 0x4D }, "CurtissWrigh", "Curtiss-Wright Controls Avionics & Electronics" },
    { { 0x00, 0x0C, 0x4E }, "WinbestTechn", "Winbest Technology CO,LT" },
    { { 0x00, 0x0C, 0x4F }, "UDTechJapan",  "UDTech Japan Corporation" },
    { { 0x00, 0x0C, 0x50 }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x0C, 0x51 }, "ScientificTe", "Scientific Technologies Inc." },
    { { 0x00, 0x0C, 0x52 }, "Roll",         "Roll Systems Inc." },
    { { 0x00, 0x0C, 0x53 }, "Private",      "Private" },
    { { 0x00, 0x0C, 0x54 }, "PedestalNetw", "Pedestal Networks, Inc" },
    { { 0x00, 0x0C, 0x55 }, "MicrolinkCom", "Microlink Communications Inc." },
    { { 0x00, 0x0C, 0x56 }, "MegatelCompu", "Megatel Computer (1986) Corp." },
    { { 0x00, 0x0C, 0x57 }, "MACKIEEngine", "MACKIE Engineering Services Belgium BVBA" },
    { { 0x00, 0x0C, 0x58 }, "M&S",          "M&S Systems" },
    { { 0x00, 0x0C, 0x59 }, "IndymeElectr", "Indyme Electronics, Inc." },
    { { 0x00, 0x0C, 0x5A }, "IBSmmEmbedde", "IBSmm Embedded Electronics Consulting" },
    { { 0x00, 0x0C, 0x5B }, "HanwangTechn", "Hanwang Technology Co.,Ltd" },
    { { 0x00, 0x0C, 0x5C }, "GTN",          "GTN Systems B.V." },
    { { 0x00, 0x0C, 0x5D }, "ChicTechnolo", "Chic Technology (China) Corp." },
    { { 0x00, 0x0C, 0x5E }, "CalypsoMedic", "Calypso Medical" },
    { { 0x00, 0x0C, 0x5F }, "Avtec",        "Avtec, Inc." },
    { { 0x00, 0x0C, 0x60 }, "ACM",          "ACM Systems" },
    { { 0x00, 0x0C, 0x61 }, "ACTechDBAAdv", "AC Tech corporation DBA Advanced Digital" },
    { { 0x00, 0x0C, 0x62 }, "ABBCeweContr", "ABB AB, Cewe-Control" },
    { { 0x00, 0x0C, 0x63 }, "ZenithElectr", "Zenith Electronics Corporation" },
    { { 0x00, 0x0C, 0x64 }, "X2MSAGroup",   "X2 MSA Group" },
    { { 0x00, 0x0C, 0x65 }, "SuninTelecom", "Sunin Telecom" },
    { { 0x00, 0x0C, 0x66 }, "ProntoNetwor", "Pronto Networks Inc" },
    { { 0x00, 0x0C, 0x67 }, "OyoElectric",  "Oyo Electric Co.,Ltd" },
    { { 0x00, 0x0C, 0x68 }, "SigmaTel",     "SigmaTel, Inc." },
    { { 0x00, 0x0C, 0x69 }, "NationalRadi", "National Radio Astronomy Observatory" },
    { { 0x00, 0x0C, 0x6A }, "Mbari",        "Mbari" },
    { { 0x00, 0x0C, 0x6B }, "KurzIndustri", "Kurz Industrie-Elektronik GmbH" },
    { { 0x00, 0x0C, 0x6C }, "Eve",          "Eve Systems GmbH" },
    { { 0x00, 0x0C, 0x6D }, "Edwards",      "Edwards Ltd." },
    { { 0x00, 0x0C, 0x6E }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x0C, 0x6F }, "Amteksystem",  "Amtek system co.,LTD." },
    { { 0x00, 0x0C, 0x70 }, "ACC",          "ACC GmbH" },
    { { 0x00, 0x0C, 0x71 }, "Wybron",       "Wybron, Inc" },
    { { 0x00, 0x0C, 0x72 }, "TempearlIndu", "Tempearl Industrial Co., Ltd." },
    { { 0x00, 0x0C, 0x73 }, "TelsonElectr", "Telson Electronics Co., Ltd" },
    { { 0x00, 0x0C, 0x74 }, "Rivertec",     "Rivertec Corporation" },
    { { 0x00, 0x0C, 0x75 }, "Orientalinte", "Oriental integrated electronics. LTD" },
    { { 0x00, 0x0C, 0x76 }, "MicroStarInt", "Micro-Star International Co., Ltd." },
    { { 0x00, 0x0C, 0x77 }, "LifeRacing",   "Life Racing Ltd" },
    { { 0x00, 0x0C, 0x78 }, "InTechElectr", "In-Tech Electronics Limited" },
    { { 0x00, 0x0C, 0x79 }, "ExtelCommuni", "Extel Communications P/L" },
    { { 0x00, 0x0C, 0x7A }, "DaTARIUSTech", "DaTARIUS Technologies GmbH" },
    { { 0x00, 0x0C, 0x7B }, "ALPHAPROJECT", "ALPHA PROJECT Co.,Ltd." },
    { { 0x00, 0x0C, 0x7C }, "InternetInfo", "Internet Information Image Inc." },
    { { 0x00, 0x0C, 0x7D }, "TeikokuElect", "Teikoku Electric Mfg. Co., Ltd" },
    { { 0x00, 0x0C, 0x7E }, "Tellium",      "Tellium Incorporated" },
    { { 0x00, 0x0C, 0x7F }, "synertronixx", "synertronixx GmbH" },
    { { 0x00, 0x0C, 0x80 }, "Opelcomm",     "Opelcomm Inc." },
    { { 0x00, 0x0C, 0x81 }, "SchneiderEle", "Schneider Electric (Australia)" },
    { { 0x00, 0x0C, 0x82 }, "NetworkTechn", "Network Technologies Inc" },
    { { 0x00, 0x0C, 0x83 }, "LogicalSolut", "Logical Solutions" },
    { { 0x00, 0x0C, 0x84 }, "Eazix",        "Eazix, Inc." },
    { { 0x00, 0x0C, 0x85 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0C, 0x86 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0C, 0x87 }, "Amd",          "Amd" },
    { { 0x00, 0x0C, 0x88 }, "ApacheMicroP", "Apache Micro Peripherals, Inc." },
    { { 0x00, 0x0C, 0x89 }, "ACElectricVe", "AC Electric Vehicles, Ltd." },
    { { 0x00, 0x0C, 0x8A }, "Bose",         "Bose Corporation" },
    { { 0x00, 0x0C, 0x8B }, "ConnectTech",  "Connect Tech Inc" },
    { { 0x00, 0x0C, 0x8C }, "Kodicom",      "Kodicom Co.,Ltd." },
    { { 0x00, 0x0C, 0x8D }, "BalluffMV",    "Balluff MV GmbH" },
    { { 0x00, 0x0C, 0x8E }, "MentorEngine", "Mentor Engineering Inc" },
    { { 0x00, 0x0C, 0x8F }, "Nergal",       "Nergal s.r.l." },
    { { 0x00, 0x0C, 0x90 }, "Octasic",      "Octasic Inc." },
    { { 0x00, 0x0C, 0x91 }, "RiverheadNet", "Riverhead Networks Inc." },
    { { 0x00, 0x0C, 0x92 }, "WolfVision",   "WolfVision Gmbh" },
    { { 0x00, 0x0C, 0x93 }, "Xeline",       "Xeline Co., Ltd." },
    { { 0x00, 0x0C, 0x94 }, "UnitedElectr", "United Electronic Industries, Inc. (EUI)" },
    { { 0x00, 0x0C, 0x95 }, "PrimeNet",     "PrimeNet" },
    { { 0x00, 0x0C, 0x96 }, "OQO",          "OQO, Inc." },
    { { 0x00, 0x0C, 0x97 }, "NVADBTTVTech", "NV ADB TTV Technologies SA" },
    { { 0x00, 0x0C, 0x98 }, "LETEKCommuni", "LETEK Communications Inc." },
    { { 0x00, 0x0C, 0x99 }, "HITELLINK",    "HITEL LINK Co.,Ltd" },
    { { 0x00, 0x0C, 0x9A }, "HitechElectr", "Hitech Electronics Corp." },
    { { 0x00, 0x0C, 0x9B }, "EESolutions",  "EE Solutions, Inc" },
    { { 0x00, 0x0C, 0x9C }, "Chonghoinfor", "Chongho information & communications" },
    { { 0x00, 0x0C, 0x9D }, "UbeeAirWalk",  "UbeeAirWalk, Inc." },
    { { 0x00, 0x0C, 0x9E }, "MemoryLink",   "MemoryLink Corp." },
    { { 0x00, 0x0C, 0x9F }, "NKE",          "NKE Corporation" },
    { { 0x00, 0x0C, 0xA0 }, "StorCaseTech", "StorCase Technology, Inc." },
    { { 0x00, 0x0C, 0xA1 }, "SIGMACOM",     "SIGMACOM Co., LTD." },
    { { 0x00, 0x0C, 0xA2 }, "HarmonicVide", "Harmonic Video Network" },
    { { 0x00, 0x0C, 0xA3 }, "RanchoTechno", "Rancho Technology, Inc." },
    { { 0x00, 0x0C, 0xA4 }, "PrompttecPro", "Prompttec Product Management GmbH" },
    { { 0x00, 0x0C, 0xA5 }, "NamanNZ",      "Naman NZ LTd" },
    { { 0x00, 0x0C, 0xA6 }, "Mintera",      "Mintera Corporation" },
    { { 0x00, 0x0C, 0xA7 }, "MetroTechnol", "Metro (Suzhou) Technologies Co., Ltd." },
    { { 0x00, 0x0C, 0xA8 }, "GarudaNetwor", "Garuda Networks Corporation" },
    { { 0x00, 0x0C, 0xA9 }, "Ebtron",       "Ebtron Inc." },
    { { 0x00, 0x0C, 0xAA }, "CubicTranspo", "Cubic Transportation Systems Inc" },
    { { 0x00, 0x0C, 0xAB }, "CommendInter", "Commend International GmbH" },
    { { 0x00, 0x0C, 0xAC }, "CitizenWatch", "Citizen Watch Co., Ltd." },
    { { 0x00, 0x0C, 0xAD }, "BTUInternati", "BTU International" },
    { { 0x00, 0x0C, 0xAE }, "Ailocom",      "Ailocom Oy" },
    { { 0x00, 0x0C, 0xAF }, "TriTerm",      "Tri Term Co.,Ltd." },
    { { 0x00, 0x0C, 0xB0 }, "StarSemicond", "Star Semiconductor Corporation" },
    { { 0x00, 0x0C, 0xB1 }, "SallandEngin", "Salland Engineering (Europe) BV" },
    { { 0x00, 0x0C, 0xB2 }, "UNION",        "UNION co., ltd." },
    { { 0x00, 0x0C, 0xB3 }, "ROUND",        "ROUND Co.,Ltd." },
    { { 0x00, 0x0C, 0xB4 }, "AutoCellLabo", "AutoCell Laboratories, Inc." },
    { { 0x00, 0x0C, 0xB5 }, "PremierTechn", "Premier Technolgies, Inc" },
    { { 0x00, 0x0C, 0xB6 }, "NanjingSeuMo", "Nanjing Seu Mobile & Internet Technology Co.,Ltd" },
    { { 0x00, 0x0C, 0xB7 }, "NanjingHuazh", "Nanjing Huazhuo Electronics Co., Ltd." },
    { { 0x00, 0x0C, 0xB8 }, "Medion",       "Medion Ag" },
    { { 0x00, 0x0C, 0xB9 }, "Lea",          "Lea" },
    { { 0x00, 0x0C, 0xBA }, "Jamex",        "Jamex, Inc." },
    { { 0x00, 0x0C, 0xBB }, "Iskraemeco",   "Iskraemeco" },
    { { 0x00, 0x0C, 0xBC }, "Iscutum",      "Iscutum" },
    { { 0x00, 0x0C, 0xBD }, "InterfaceMas", "Interface Masters, Inc" },
    { { 0x00, 0x0C, 0xBE }, "InnominateSe", "Innominate Security Technologies AG" },
    { { 0x00, 0x0C, 0xBF }, "HolyStoneEnt", "Holy Stone Ent. Co., Ltd." },
    { { 0x00, 0x0C, 0xC0 }, "Genera",       "Genera Oy" },
    { { 0x00, 0x0C, 0xC1 }, "Eaton",        "Eaton Corporation" },
    { { 0x00, 0x0C, 0xC2 }, "ControlNetPr", "ControlNet (India) Private Limited" },
    { { 0x00, 0x0C, 0xC3 }, "BeWAN",        "BeWAN systems" },
    { { 0x00, 0x0C, 0xC4 }, "Tiptel",       "Tiptel AG" },
    { { 0x00, 0x0C, 0xC5 }, "Nextlink",     "Nextlink Co., Ltd." },
    { { 0x00, 0x0C, 0xC6 }, "KaRoelectron", "Ka-Ro electronics GmbH" },
    { { 0x00, 0x0C, 0xC7 }, "IntelligentC", "Intelligent Computer Solutions Inc." },
    { { 0x00, 0x0C, 0xC8 }, "XytronixRese", "Xytronix Research & Design, Inc." },
    { { 0x00, 0x0C, 0xC9 }, "IlwooDataTec", "Ilwoo Data & Technology Co.,Ltd" },
    { { 0x00, 0x0C, 0xCA }, "HGSTWesternD", "HGST a Western Digital Company" },
    { { 0x00, 0x0C, 0xCB }, "DesignCombus", "Design Combus Ltd" },
    { { 0x00, 0x0C, 0xCC }, "Aeroscout",    "Aeroscout Ltd." },
    { { 0x00, 0x0C, 0xCD }, "IecTc57",      "Iec - Tc57" },
    { { 0x00, 0x0C, 0xCE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0C, 0xCF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0C, 0xD0 }, "Symetrix",     "Symetrix" },
    { { 0x00, 0x0C, 0xD1 }, "SFOMTechnolo", "SFOM Technology Corp." },
    { { 0x00, 0x0C, 0xD2 }, "SchaffnerEMV", "Schaffner EMV AG" },
    { { 0x00, 0x0C, 0xD3 }, "PrettlElektr", "Prettl Elektronik Radeberg GmbH" },
    { { 0x00, 0x0C, 0xD4 }, "PositronPubl", "Positron Public Safety Systems inc." },
    { { 0x00, 0x0C, 0xD5 }, "Passave",      "Passave Inc." },
    { { 0x00, 0x0C, 0xD6 }, "PartnerTech",  "Partner Tech" },
    { { 0x00, 0x0C, 0xD7 }, "Nallatech",    "Nallatech Ltd" },
    { { 0x00, 0x0C, 0xD8 }, "MKJuchheim",   "M. K. Juchheim GmbH & Co" },
    { { 0x00, 0x0C, 0xD9 }, "Itcare",       "Itcare Co., Ltd" },
    { { 0x00, 0x0C, 0xDA }, "FreeHand",     "FreeHand Systems, Inc." },
    { { 0x00, 0x0C, 0xDB }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x0C, 0xDC }, "BECSTechnolo", "BECS Technology, Inc" },
    { { 0x00, 0x0C, 0xDD }, "AOStechnolog", "AOS technologies AG" },
    { { 0x00, 0x0C, 0xDE }, "ABBSTOTZKONT", "ABB STOTZ-KONTAKT GmbH" },
    { { 0x00, 0x0C, 0xDF }, "JAIManufactu", "JAI Manufacturing" },
    { { 0x00, 0x0C, 0xE0 }, "TrekDiagnost", "Trek Diagnostics Inc." },
    { { 0x00, 0x0C, 0xE1 }, "OpenGroup",    "The Open Group" },
    { { 0x00, 0x0C, 0xE2 }, "RollsRoyce",   "Rolls-Royce" },
    { { 0x00, 0x0C, 0xE3 }, "OptionIntern", "Option International N.V." },
    { { 0x00, 0x0C, 0xE4 }, "NeuroComInte", "NeuroCom International, Inc." },
    { { 0x00, 0x0C, 0xE5 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x0C, 0xE6 }, "Fortinet",     "Fortinet, Inc." },
    { { 0x00, 0x0C, 0xE7 }, "MediaTek",     "MediaTek Inc." },
    { { 0x00, 0x0C, 0xE8 }, "GuangZhouAnJ", "GuangZhou AnJuBao Co., Ltd" },
    { { 0x00, 0x0C, 0xE9 }, "BloombergLP",  "Bloomberg L.P." },
    { { 0x00, 0x0C, 0xEA }, "aphonaKommun", "aphona Kommunikationssysteme" },
    { { 0x00, 0x0C, 0xEB }, "CNMPNetworks", "CNMP Networks, Inc." },
    { { 0x00, 0x0C, 0xEC }, "SafranTruste", "Safran Trusted 4D Inc." },
    { { 0x00, 0x0C, 0xED }, "RealDigitalM", "Real Digital Media" },
    { { 0x00, 0x0C, 0xEE }, "jpembedded",   "jp-embedded" },
    { { 0x00, 0x0C, 0xEF }, "ONEInvestmen", "ONE Investment Group Limited" },
    { { 0x00, 0x0C, 0xF0 }, "MN",           "M & N GmbH" },
    { { 0x00, 0x0C, 0xF1 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x0C, 0xF2 }, "GAMESAEólica", "GAMESA Eólica" },
    { { 0x00, 0x0C, 0xF3 }, "CallImage",    "Call Image Sa" },
    { { 0x00, 0x0C, 0xF4 }, "AkatsukiElec", "Akatsuki Electric Mfg.Co.,Ltd." },
    { { 0x00, 0x0C, 0xF5 }, "InfoExpress",  "InfoExpress" },
    { { 0x00, 0x0C, 0xF6 }, "SitecomEurop", "Sitecom Europe BV" },
    { { 0x00, 0x0C, 0xF7 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0C, 0xF8 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0C, 0xF9 }, "XylemWaterSo", "Xylem Water Solutions" },
    { { 0x00, 0x0C, 0xFA }, "Digital",      "Digital Systems Corp" },
    { { 0x00, 0x0C, 0xFB }, "KoreaNetwork", "Korea Network Systems" },
    { { 0x00, 0x0C, 0xFC }, "S2ioTechnolo", "S2io Technologies Corp" },
    { { 0x00, 0x0C, 0xFD }, "HyundaiImage", "Hyundai ImageQuest Co.,Ltd." },
    { { 0x00, 0x0C, 0xFE }, "GrandElectro", "Grand Electronic Co., Ltd" },
    { { 0x00, 0x0C, 0xFF }, "MROTEKRealty", "MRO-TEK Realty Limited" },
    { { 0x00, 0x0D, 0x00 }, "SeawayNetwor", "Seaway Networks Inc." },
    { { 0x00, 0x0D, 0x01 }, "P&EMicrocomp", "P&E Microcomputer Systems, Inc." },
    { { 0x00, 0x0D, 0x02 }, "NECPlatforms", "NEC Platforms, Ltd." },
    { { 0x00, 0x0D, 0x03 }, "Matrics",      "Matrics, Inc." },
    { { 0x00, 0x0D, 0x04 }, "FoxboroEckar", "Foxboro Eckardt Development GmbH" },
    { { 0x00, 0x0D, 0x05 }, "cybernetmanu", "cybernet manufacturing inc." },
    { { 0x00, 0x0D, 0x06 }, "Compulogic",   "Compulogic Limited" },
    { { 0x00, 0x0D, 0x07 }, "CalrecAudio",  "Calrec Audio Ltd" },
    { { 0x00, 0x0D, 0x08 }, "AboveCable",   "AboveCable, Inc." },
    { { 0x00, 0x0D, 0x09 }, "YuehuaElectr", "Yuehua(Zhuhai) Electronic CO. LTD" },
    { { 0x00, 0x0D, 0x0A }, "BarcoProject", "Barco Projection Systems NV" },
    { { 0x00, 0x0D, 0x0B }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0x0D, 0x0C }, "MDISecurity",  "MDI Security Systems" },
    { { 0x00, 0x0D, 0x0D }, "ITSupported",  "ITSupported, LLC" },
    { { 0x00, 0x0D, 0x0E }, "Inqnet",       "Inqnet Systems, Inc." },
    { { 0x00, 0x0D, 0x0F }, "Finlux",       "Finlux Ltd" },
    { { 0x00, 0x0D, 0x10 }, "Embedtronics", "Embedtronics Oy" },
    { { 0x00, 0x0D, 0x11 }, "DENTSPLYGend", "DENTSPLY - Gendex" },
    { { 0x00, 0x0D, 0x12 }, "AXELL",        "AXELL Corporation" },
    { { 0x00, 0x0D, 0x13 }, "WilhelmRuten", "Wilhelm Rutenbeck GmbH&Co.KG" },
    { { 0x00, 0x0D, 0x14 }, "VtechInnovat", "Vtech Innovation LP dba Advanced American Telephones" },
    { { 0x00, 0x0D, 0x15 }, "Voipacsro",    "Voipac s.r.o." },
    { { 0x00, 0x0D, 0x16 }, "UHS",          "UHS Systems Pty Ltd" },
    { { 0x00, 0x0D, 0x17 }, "TurboNetwork", "Turbo Networks Co.Ltd" },
    { { 0x00, 0x0D, 0x18 }, "MegaTrendEle", "Mega-Trend Electronics CO., LTD." },
    { { 0x00, 0x0D, 0x19 }, "ROBEShowligh", "ROBE Show lighting" },
    { { 0x00, 0x0D, 0x1A }, "MustekSystem", "Mustek System Inc." },
    { { 0x00, 0x0D, 0x1B }, "KyotoElectro", "Kyoto Electronics Manufacturing Co., Ltd." },
    { { 0x00, 0x0D, 0x1C }, "AmesysDefens", "Amesys Defense" },
    { { 0x00, 0x0D, 0x1D }, "HighTekHarne", "High-Tek Harness Ent. Co., Ltd." },
    { { 0x00, 0x0D, 0x1E }, "ControlTechn", "Control Techniques" },
    { { 0x00, 0x0D, 0x1F }, "AVDigital",    "AV Digital" },
    { { 0x00, 0x0D, 0x20 }, "AsahikaseiTe", "Asahikasei Technosystem Co.,Ltd." },
    { { 0x00, 0x0D, 0x21 }, "WISCORE",      "WISCORE Inc." },
    { { 0x00, 0x0D, 0x22 }, "Unitronics",   "Unitronics LTD" },
    { { 0x00, 0x0D, 0x23 }, "SmartSolutio", "Smart Solution, Inc" },
    { { 0x00, 0x0D, 0x24 }, "SentecE&E",    "Sentec E&E Co., Ltd." },
    { { 0x00, 0x0D, 0x25 }, "Sanden",       "Sanden Corporation" },
    { { 0x00, 0x0D, 0x26 }, "Primagraphic", "Primagraphics Limited" },
    { { 0x00, 0x0D, 0x27 }, "MICROPLEXPri", "MICROPLEX Printware AG" },
    { { 0x00, 0x0D, 0x28 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0x29 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0x2A }, "ScanmaticAS",  "Scanmatic AS" },
    { { 0x00, 0x0D, 0x2B }, "RacalInstrum", "Racal Instruments" },
    { { 0x00, 0x0D, 0x2C }, "Lantronix",    "Lantronix" },
    { { 0x00, 0x0D, 0x2D }, "NCTDeutschla", "NCT Deutschland GmbH" },
    { { 0x00, 0x0D, 0x2E }, "MatsushitaAv", "Matsushita Avionics Systems Corporation" },
    { { 0x00, 0x0D, 0x2F }, "AINCommTech",  "AIN Comm.Tech.Co., LTD" },
    { { 0x00, 0x0D, 0x30 }, "IceFyreSemic", "IceFyre Semiconductor" },
    { { 0x00, 0x0D, 0x31 }, "CompellentTe", "Compellent Technologies, Inc." },
    { { 0x00, 0x0D, 0x32 }, "DispenseSour", "DispenseSource, Inc." },
    { { 0x00, 0x0D, 0x33 }, "Prediwave",    "Prediwave Corp." },
    { { 0x00, 0x0D, 0x34 }, "ShellInterna", "Shell International Exploration and Production, Inc." },
    { { 0x00, 0x0D, 0x35 }, "PACInternati", "PAC International Ltd" },
    { { 0x00, 0x0D, 0x36 }, "WuHanRoutonE", "Wu Han Routon Electronic Co., Ltd" },
    { { 0x00, 0x0D, 0x37 }, "Wiplug",       "Wiplug" },
    { { 0x00, 0x0D, 0x38 }, "Nissin",       "Nissin Inc." },
    { { 0x00, 0x0D, 0x39 }, "Nevion",       "Nevion" },
    { { 0x00, 0x0D, 0x3A }, "Microsoft",    "Microsoft Corp." },
    { { 0x00, 0x0D, 0x3B }, "Microelectro", "Microelectronics Technology Inc." },
    { { 0x00, 0x0D, 0x3C }, "iTechDynamic", "i.Tech Dynamic Ltd" },
    { { 0x00, 0x0D, 0x3D }, "Hammerhead",   "Hammerhead Systems, Inc." },
    { { 0x00, 0x0D, 0x3E }, "APLUXCommuni", "APLUX Communications Ltd." },
    { { 0x00, 0x0D, 0x3F }, "VTIInstrumen", "VTI Instruments Corporation" },
    { { 0x00, 0x0D, 0x40 }, "VerintLoroni", "Verint Loronix Video Solutions" },
    { { 0x00, 0x0D, 0x41 }, "SiemensICMMP", "Siemens AG ICM MP UC RD IT KLF1" },
    { { 0x00, 0x0D, 0x42 }, "NewbestDevel", "Newbest Development Limited" },
    { { 0x00, 0x0D, 0x43 }, "DRSTactical",  "DRS Tactical Systems Inc." },
    { { 0x00, 0x0D, 0x44 }, "AudioBULogit", "Audio BU - Logitech" },
    { { 0x00, 0x0D, 0x45 }, "TottoriSANYO", "Tottori SANYO Electric Co., Ltd." },
    { { 0x00, 0x0D, 0x46 }, "ParkerSSDDri", "Parker SSD Drives" },
    { { 0x00, 0x0D, 0x47 }, "Collex",       "Collex" },
    { { 0x00, 0x0D, 0x48 }, "AEWINTechnol", "AEWIN Technologies Co., Ltd." },
    { { 0x00, 0x0D, 0x49 }, "TritonDelawa", "Triton Systems of Delaware, Inc." },
    { { 0x00, 0x0D, 0x4A }, "SteagETAOpti", "Steag ETA-Optik" },
    { { 0x00, 0x0D, 0x4B }, "Roku",         "Roku, Inc." },
    { { 0x00, 0x0D, 0x4C }, "OutlineElect", "Outline Electronics Ltd." },
    { { 0x00, 0x0D, 0x4D }, "Ninelanes",    "Ninelanes" },
    { { 0x00, 0x0D, 0x4E }, "NDR",          "NDR Co.,LTD." },
    { { 0x00, 0x0D, 0x4F }, "Kenwood",      "Kenwood Corporation" },
    { { 0x00, 0x0D, 0x50 }, "GalazarNetwo", "Galazar Networks" },
    { { 0x00, 0x0D, 0x51 }, "DIVR",         "DIVR Systems, Inc." },
    { { 0x00, 0x0D, 0x52 }, "Comartsystem", "Comart system" },
    { { 0x00, 0x0D, 0x53 }, "5wCommunicat", "Beijing 5w Communication Corp." },
    { { 0x00, 0x0D, 0x54 }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x0D, 0x55 }, "SANYCOMTechn", "SANYCOM Technology Co.,Ltd" },
    { { 0x00, 0x0D, 0x56 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x0D, 0x57 }, "FujitsuINetw", "Fujitsu I-Network Systems Limited." },
    { { 0x00, 0x0D, 0x58 }, "Private",      "Private" },
    { { 0x00, 0x0D, 0x59 }, "Amity",        "Amity Systems, Inc." },
    { { 0x00, 0x0D, 0x5A }, "Tiesse",       "Tiesse SpA" },
    { { 0x00, 0x0D, 0x5B }, "SmartEmpireI", "Smart Empire Investments Limited" },
    { { 0x00, 0x0D, 0x5C }, "RobertBoschV", "Robert Bosch GmbH, VT-ATMO" },
    { { 0x00, 0x0D, 0x5D }, "RaritanCompu", "Raritan Computer, Inc" },
    { { 0x00, 0x0D, 0x5E }, "NECPersonalP", "NEC Personal Products" },
    { { 0x00, 0x0D, 0x5F }, "Minds",        "Minds Inc" },
    { { 0x00, 0x0D, 0x60 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x0D, 0x61 }, "GigaByteTech", "Giga-Byte Technology Co., Ltd." },
    { { 0x00, 0x0D, 0x62 }, "FunkwerkDabe", "Funkwerk Dabendorf GmbH" },
    { { 0x00, 0x0D, 0x63 }, "DENTInstrume", "DENT Instruments, Inc." },
    { { 0x00, 0x0D, 0x64 }, "COMAGHandels", "COMAG Handels AG" },
    { { 0x00, 0x0D, 0x65 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0x66 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0x67 }, "Ericsson",     "Ericsson" },
    { { 0x00, 0x0D, 0x68 }, "Vinci",        "Vinci Systems, Inc." },
    { { 0x00, 0x0D, 0x69 }, "TMT&D",        "TMT&D Corporation" },
    { { 0x00, 0x0D, 0x6A }, "RedwoodTechn", "Redwood Technologies LTD" },
    { { 0x00, 0x0D, 0x6B }, "MitaTeknik",   "Mita-Teknik A/S" },
    { { 0x00, 0x0D, 0x6C }, "MAudio",       "M-Audio" },
    { { 0x00, 0x0D, 0x6D }, "KTechDevices", "K-Tech Devices Corp." },
    { { 0x00, 0x0D, 0x6E }, "KPatents",     "K-Patents Oy" },
    { { 0x00, 0x0D, 0x6F }, "Ember",        "Ember Corporation" },
    { { 0x00, 0x0D, 0x70 }, "Datamax",      "Datamax Corporation" },
    { { 0x00, 0x0D, 0x71 }, "boca",         "boca systems" },
    { { 0x00, 0x0D, 0x72 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x0D, 0x73 }, "TechnicalSup", "Technical Support, Inc." },
    { { 0x00, 0x0D, 0x74 }, "SandNetwork",  "Sand Network Systems, Inc." },
    { { 0x00, 0x0D, 0x75 }, "KobianPteTai", "Kobian Pte Ltd - Taiwan Branch" },
    { { 0x00, 0x0D, 0x76 }, "HokutoDenshi", "Hokuto Denshi Co,. Ltd." },
    { { 0x00, 0x0D, 0x77 }, "FalconStorSo", "FalconStor Software" },
    { { 0x00, 0x0D, 0x78 }, "EngineeringS", "Engineering & Security" },
    { { 0x00, 0x0D, 0x79 }, "DynamicSolut", "Dynamic Solutions Co,.Ltd." },
    { { 0x00, 0x0D, 0x7A }, "DiGATTOAsiaP", "DiGATTO Asia Pacific Pte Ltd" },
    { { 0x00, 0x0D, 0x7B }, "ConsensysCom", "Consensys Computers Inc." },
    { { 0x00, 0x0D, 0x7C }, "Codian",       "Codian Ltd" },
    { { 0x00, 0x0D, 0x7D }, "Afco",         "Afco Systems" },
    { { 0x00, 0x0D, 0x7E }, "AxiowaveNetw", "Axiowave Networks, Inc." },
    { { 0x00, 0x0D, 0x7F }, "MIDASCOMMUNI", "MIDAS COMMUNICATION TECHNOLOGIES PTE LTD ( Foreign Branch)" },
    { { 0x00, 0x0D, 0x80 }, "OnlineDevelo", "Online Development Inc" },
    { { 0x00, 0x0D, 0x81 }, "PepperlFuchs", "Pepperl+Fuchs GmbH" },
    { { 0x00, 0x0D, 0x82 }, "Phsnet",       "Phsnet" },
    { { 0x00, 0x0D, 0x83 }, "SanminaSCIHu", "Sanmina-SCI Hungary Ltd." },
    { { 0x00, 0x0D, 0x84 }, "Makus",        "Makus Inc." },
    { { 0x00, 0x0D, 0x85 }, "Tapwave",      "Tapwave, Inc." },
    { { 0x00, 0x0D, 0x86 }, "HuberSuhner",  "Huber + Suhner AG" },
    { { 0x00, 0x0D, 0x87 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x0D, 0x88 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x0D, 0x89 }, "BilsTechnolo", "Bils Technology Inc" },
    { { 0x00, 0x0D, 0x8A }, "WinnersElect", "Winners Electronics Co., Ltd." },
    { { 0x00, 0x0D, 0x8B }, "T&D",          "T&D Corporation" },
    { { 0x00, 0x0D, 0x8C }, "WedoneDigita", "Shanghai Wedone Digital Ltd. CO." },
    { { 0x00, 0x0D, 0x8D }, "ProsoftTechn", "Prosoft Technology, Inc" },
    { { 0x00, 0x0D, 0x8E }, "KodenElectro", "Koden Electronics Co., Ltd." },
    { { 0x00, 0x0D, 0x8F }, "KingTsushinK", "King Tsushin Kogyo Co., LTD." },
    { { 0x00, 0x0D, 0x90 }, "FactumElectr", "Factum Electronics AB" },
    { { 0x00, 0x0D, 0x91 }, "EclipseSL",    "Eclipse (HQ Espana) S.L." },
    { { 0x00, 0x0D, 0x92 }, "ARIMACommuni", "ARIMA Communications Corp." },
    { { 0x00, 0x0D, 0x93 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x0D, 0x94 }, "AFARCommunic", "AFAR Communications,Inc" },
    { { 0x00, 0x0D, 0x95 }, "Opticell",     "Opti-cell, Inc." },
    { { 0x00, 0x0D, 0x96 }, "VteraTechnol", "Vtera Technology Inc." },
    { { 0x00, 0x0D, 0x97 }, "HitachiEnerg", "Hitachi Energy USA Inc." },
    { { 0x00, 0x0D, 0x98 }, "SWACSchmittW", "S.W.A.C. Schmitt-Walter Automation Consult GmbH" },
    { { 0x00, 0x0D, 0x99 }, "OrbitalScien", "Orbital Sciences Corp.; Launch Systems Group" },
    { { 0x00, 0x0D, 0x9A }, "Infotec",      "Infotec Ltd" },
    { { 0x00, 0x0D, 0x9B }, "HeraeusElect", "Heraeus Electro-Nite International N.V." },
    { { 0x00, 0x0D, 0x9C }, "KASchmersal",  "K.A. Schmersal GmbH & Co. KG" },
    { { 0x00, 0x0D, 0x9D }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x0D, 0x9E }, "TOKUDENOHIZU", "TOKUDEN OHIZUMI SEISAKUSYO Co.,Ltd." },
    { { 0x00, 0x0D, 0x9F }, "RFMicroDevic", "RF Micro Devices" },
    { { 0x00, 0x0D, 0xA0 }, "Nedap",        "Nedap N.V." },
    { { 0x00, 0x0D, 0xA1 }, "MIRAEITS",     "MIRAE ITS Co.,LTD." },
    { { 0x00, 0x0D, 0xA2 }, "InfrantTechn", "Infrant Technologies, Inc." },
    { { 0x00, 0x0D, 0xA3 }, "EmergingTech", "Emerging Technologies Limited" },
    { { 0x00, 0x0D, 0xA4 }, "DoschAmand",   "Dosch & Amand Systems Ag" },
    { { 0x00, 0x0D, 0xA5 }, "Fabric7",      "Fabric7 Systems, Inc" },
    { { 0x00, 0x0D, 0xA6 }, "UniversalSwi", "Universal Switching Corporation" },
    { { 0x00, 0x0D, 0xA7 }, "Private",      "Private" },
    { { 0x00, 0x0D, 0xA8 }, "TeletronicsT", "Teletronics Technology Corporation" },
    { { 0x00, 0x0D, 0xA9 }, "Ingeteam",     "Ingeteam" },
    { { 0x00, 0x0D, 0xAA }, "SATehnology",  "S.A.Tehnology co.,Ltd." },
    { { 0x00, 0x0D, 0xAB }, "ParkerHannif", "Parker Hannifin GmbH Electromechanical Division Europe" },
    { { 0x00, 0x0D, 0xAC }, "JapanCBM",     "Japan CBM Corporation" },
    { { 0x00, 0x0D, 0xAD }, "Dataprobe",    "Dataprobe, Inc." },
    { { 0x00, 0x0D, 0xAE }, "SamsungHeavy", "Samsung Heavy Industries Co., Ltd." },
    { { 0x00, 0x0D, 0xAF }, "Plexus",       "Plexus Corp (UK) Ltd" },
    { { 0x00, 0x0D, 0xB0 }, "Olymtech",     "Olym-tech Co.,Ltd." },
    { { 0x00, 0x0D, 0xB1 }, "JapanNetwork", "Japan Network Service Co., Ltd." },
    { { 0x00, 0x0D, 0xB2 }, "Ammasso",      "Ammasso, Inc." },
    { { 0x00, 0x0D, 0xB3 }, "SDOCommunica", "SDO Communication Corperation" },
    { { 0x00, 0x0D, 0xB4 }, "Stormshield",  "Stormshield" },
    { { 0x00, 0x0D, 0xB5 }, "GlobalsatTec", "Globalsat Technology Corporation" },
    { { 0x00, 0x0D, 0xB6 }, "Broadcom",     "Broadcom" },
    { { 0x00, 0x0D, 0xB7 }, "SankoElectri", "Sanko Electric Co,.Ltd" },
    { { 0x00, 0x0D, 0xB8 }, "Schiller",     "Schiller Ag" },
    { { 0x00, 0x0D, 0xB9 }, "PCEngines",    "PC Engines GmbH" },
    { { 0x00, 0x0D, 0xBA }, "OcéDocumentT", "Océ Document Technologies GmbH" },
    { { 0x00, 0x0D, 0xBB }, "NipponDentsu", "Nippon Dentsu Co.,Ltd." },
    { { 0x00, 0x0D, 0xBC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0xBD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0xBE }, "BelFuseEurop", "Bel Fuse Europe Ltd.,UK" },
    { { 0x00, 0x0D, 0xBF }, "TekToneSound", "TekTone Sound & Signal Mfg., Inc." },
    { { 0x00, 0x0D, 0xC0 }, "SpagatAS",     "Spagat AS" },
    { { 0x00, 0x0D, 0xC1 }, "SafeWeb",      "SafeWeb Inc" },
    { { 0x00, 0x0D, 0xC2 }, "Private",      "Private" },
    { { 0x00, 0x0D, 0xC3 }, "FirstCommuni", "First Communication, Inc." },
    { { 0x00, 0x0D, 0xC4 }, "Emcore",       "Emcore Corporation" },
    { { 0x00, 0x0D, 0xC5 }, "EchoStarGlob", "EchoStar Global B.V." },
    { { 0x00, 0x0D, 0xC6 }, "DigiRoseTech", "DigiRose Technology Co., Ltd." },
    { { 0x00, 0x0D, 0xC7 }, "CosmicEngine", "Cosmic Engineering Inc." },
    { { 0x00, 0x0D, 0xC8 }, "AirMagnet",    "AirMagnet, Inc" },
    { { 0x00, 0x0D, 0xC9 }, "THALESElektr", "THALES Elektronik Systeme GmbH" },
    { { 0x00, 0x0D, 0xCA }, "TaitElectron", "Tait Electronics" },
    { { 0x00, 0x0D, 0xCB }, "Petcomkorea",  "Petcomkorea Co., Ltd." },
    { { 0x00, 0x0D, 0xCC }, "NEOSMART",     "NEOSMART Corp." },
    { { 0x00, 0x0D, 0xCD }, "GroupeTxcom",  "Groupe Txcom" },
    { { 0x00, 0x0D, 0xCE }, "DynavacTechn", "Dynavac Technology Pte Ltd" },
    { { 0x00, 0x0D, 0xCF }, "Cidra",        "Cidra Corp." },
    { { 0x00, 0x0D, 0xD0 }, "TetraTecInst", "TetraTec Instruments GmbH" },
    { { 0x00, 0x0D, 0xD1 }, "Stryker",      "Stryker Corporation" },
    { { 0x00, 0x0D, 0xD2 }, "SimradOptron", "Simrad Optronics ASA" },
    { { 0x00, 0x0D, 0xD3 }, "SAMWOOTeleco", "SAMWOO Telecommunication Co.,Ltd." },
    { { 0x00, 0x0D, 0xD4 }, "Symantec",     "Symantec Corporation" },
    { { 0x00, 0x0D, 0xD5 }, "ORiteTechnol", "O'Rite Technology Co.,Ltd" },
    { { 0x00, 0x0D, 0xD6 }, "Iti",          "Iti Ltd" },
    { { 0x00, 0x0D, 0xD7 }, "Bright",       "Bright" },
    { { 0x00, 0x0D, 0xD8 }, "Bbn",          "Bbn" },
    { { 0x00, 0x0D, 0xD9 }, "AntonPaar",    "Anton Paar GmbH" },
    { { 0x00, 0x0D, 0xDA }, "AlliedTelesi", "Allied Telesis K.K." },
    { { 0x00, 0x0D, 0xDB }, "AirwaveTechn", "Airwave Technologies Inc." },
    { { 0x00, 0x0D, 0xDC }, "Vac",          "Vac" },
    { { 0x00, 0x0D, 0xDD }, "ProfiloTelra", "Profilo Telra Elektronik Sanayi ve Ticaret. A.Ş" },
    { { 0x00, 0x0D, 0xDE }, "Joyteck",      "Joyteck Co., Ltd." },
    { { 0x00, 0x0D, 0xDF }, "JapanImageNe", "Japan Image & Network Inc." },
    { { 0x00, 0x0D, 0xE0 }, "ICPDAS",       "ICPDAS Co.,LTD" },
    { { 0x00, 0x0D, 0xE1 }, "ControlProdu", "Control Products, Inc." },
    { { 0x00, 0x0D, 0xE2 }, "CMZSistemiEl", "CMZ Sistemi Elettronici" },
    { { 0x00, 0x0D, 0xE3 }, "ATSweden",     "AT Sweden AB" },
    { { 0x00, 0x0D, 0xE4 }, "DIGINICS",     "DIGINICS, Inc." },
    { { 0x00, 0x0D, 0xE5 }, "SamsungThale", "Samsung Thales" },
    { { 0x00, 0x0D, 0xE6 }, "YoungboEngin", "Youngbo Engineering Co.,Ltd" },
    { { 0x00, 0x0D, 0xE7 }, "SnaponOEMGro", "Snap-on OEM Group" },
    { { 0x00, 0x0D, 0xE8 }, "NasacoElectr", "Nasaco Electronics Pte. Ltd" },
    { { 0x00, 0x0D, 0xE9 }, "NapatechAps",  "Napatech Aps" },
    { { 0x00, 0x0D, 0xEA }, "KingtelTelec", "Kingtel Telecommunication Corp." },
    { { 0x00, 0x0D, 0xEB }, "CompXs",       "CompXs Limited" },
    { { 0x00, 0x0D, 0xEC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0xED }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0D, 0xEE }, "AndrewRFPowe", "Andrew RF Power Amplifier Group" },
    { { 0x00, 0x0D, 0xEF }, "SocCoopBilan", "Soc. Coop. Bilanciai" },
    { { 0x00, 0x0D, 0xF0 }, "QcomTechnolo", "Qcom Technology Inc." },
    { { 0x00, 0x0D, 0xF1 }, "Ionix",        "Ionix Inc." },
    { { 0x00, 0x0D, 0xF2 }, "Private",      "Private" },
    { { 0x00, 0x0D, 0xF3 }, "AsmaxSolutio", "Asmax Solutions" },
    { { 0x00, 0x0D, 0xF4 }, "Watertek",     "Watertek Co." },
    { { 0x00, 0x0D, 0xF5 }, "TeletronicsI", "Teletronics International Inc." },
    { { 0x00, 0x0D, 0xF6 }, "TechnologyTh", "Technology Thesaurus Corp." },
    { { 0x00, 0x0D, 0xF7 }, "SpaceDynamic", "Space Dynamics Lab" },
    { { 0x00, 0x0D, 0xF8 }, "ORGAKartensy", "ORGA Kartensysteme GmbH" },
    { { 0x00, 0x0D, 0xF9 }, "NDS",          "NDS Limited" },
    { { 0x00, 0x0D, 0xFA }, "MicroControl", "Micro Control Systems Ltd." },
    { { 0x00, 0x0D, 0xFB }, "Komax",        "Komax AG" },
    { { 0x00, 0x0D, 0xFC }, "ITFOR",        "ITFOR Inc." },
    { { 0x00, 0x0D, 0xFD }, "HugesHiTech",  "Huges Hi-Tech Inc.," },
    { { 0x00, 0x0D, 0xFE }, "HauppaugeCom", "Hauppauge Computer Works, Inc." },
    { { 0x00, 0x0D, 0xFF }, "ChenmingMold", "Chenming Mold Industry Corp." },
    { { 0x00, 0x0E, 0x00 }, "Atrie",        "Atrie" },
    { { 0x00, 0x0E, 0x01 }, "ASIPTechnolo", "ASIP Technologies Inc." },
    { { 0x00, 0x0E, 0x02 }, "AdvantechAMT", "Advantech AMT Inc." },
    { { 0x00, 0x0E, 0x03 }, "Emulex",       "Emulex Corporation" },
    { { 0x00, 0x0E, 0x04 }, "CMAMicrodial", "CMA/Microdialysis AB" },
    { { 0x00, 0x0E, 0x05 }, "WirelessMatr", "Wireless Matrix Corp." },
    { { 0x00, 0x0E, 0x06 }, "TeamSimoco",   "Team Simoco Ltd" },
    { { 0x00, 0x0E, 0x07 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x0E, 0x08 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x0E, 0x09 }, "CoshipSoftwa", "Shenzhen Coship Software Co.,LTD." },
    { { 0x00, 0x0E, 0x0A }, "SakumaDesign", "Sakuma Design Office" },
    { { 0x00, 0x0E, 0x0B }, "NetacTechnol", "Netac Technology Co., Ltd." },
    { { 0x00, 0x0E, 0x0C }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x0E, 0x0D }, "HeschSchröde", "Hesch Schröder GmbH" },
    { { 0x00, 0x0E, 0x0E }, "ESAelettroni", "ESA elettronica S.P.A." },
    { { 0x00, 0x0E, 0x0F }, "Ermme",        "Ermme" },
    { { 0x00, 0x0E, 0x10 }, "Cguys",        "C-guys, Inc." },
    { { 0x00, 0x0E, 0x11 }, "BDTBüroundDa", "BDT Büro und Datentechnik GmbH & Co.KG" },
    { { 0x00, 0x0E, 0x12 }, "AdaptiveMicr", "Adaptive Micro Systems Inc." },
    { { 0x00, 0x0E, 0x13 }, "AccuSort",     "Accu-Sort Systems inc." },
    { { 0x00, 0x0E, 0x14 }, "VisionarySol", "Visionary Solutions, Inc." },
    { { 0x00, 0x0E, 0x15 }, "Tadlys",       "Tadlys LTD" },
    { { 0x00, 0x0E, 0x16 }, "SouthWingSL",  "SouthWing S.L." },
    { { 0x00, 0x0E, 0x17 }, "Private",      "Private" },
    { { 0x00, 0x0E, 0x18 }, "MyATechnolog", "MyA Technology" },
    { { 0x00, 0x0E, 0x19 }, "LogicaCMG",    "LogicaCMG Pty Ltd" },
    { { 0x00, 0x0E, 0x1A }, "JPSCommunica", "JPS Communications" },
    { { 0x00, 0x0E, 0x1B }, "IAV",          "IAV GmbH" },
    { { 0x00, 0x0E, 0x1C }, "Hach",         "Hach Company" },
    { { 0x00, 0x0E, 0x1D }, "ARIONTechnol", "ARION Technology Inc." },
    { { 0x00, 0x0E, 0x1E }, "QLogic",       "QLogic Corporation" },
    { { 0x00, 0x0E, 0x1F }, "TCLNetworksE", "TCL Networks Equipment Co., Ltd." },
    { { 0x00, 0x0E, 0x20 }, "ACCESSAmeric", "ACCESS Systems Americas, Inc." },
    { { 0x00, 0x0E, 0x21 }, "MTUFriedrich", "MTU Friedrichshafen GmbH" },
    { { 0x00, 0x0E, 0x22 }, "Private",      "Private" },
    { { 0x00, 0x0E, 0x23 }, "Incipient",    "Incipient, Inc." },
    { { 0x00, 0x0E, 0x24 }, "HuwellTechno", "Huwell Technology Inc." },
    { { 0x00, 0x0E, 0x25 }, "HannaeTechno", "Hannae Technology Co., Ltd" },
    { { 0x00, 0x0E, 0x26 }, "GincomTechno", "Gincom Technology Corp." },
    { { 0x00, 0x0E, 0x27 }, "CrereNetwork", "Crere Networks, Inc." },
    { { 0x00, 0x0E, 0x28 }, "DynamicRatin", "Dynamic Ratings P/L" },
    { { 0x00, 0x0E, 0x29 }, "ShesterCommu", "Shester Communications Inc" },
    { { 0x00, 0x0E, 0x2A }, "dormakabaUSA", "dormakaba USA Inc." },
    { { 0x00, 0x0E, 0x2B }, "SafariTechno", "Safari Technologies" },
    { { 0x00, 0x0E, 0x2C }, "Netcodec",     "Netcodec co." },
    { { 0x00, 0x0E, 0x2D }, "HyundaiDigit", "Hyundai Digital Technology Co.,Ltd." },
    { { 0x00, 0x0E, 0x2E }, "EdimaxTechno", "Edimax Technology Co. Ltd." },
    { { 0x00, 0x0E, 0x2F }, "RocheDiagnos", "Roche Diagnostics GmbH" },
    { { 0x00, 0x0E, 0x30 }, "AERASNetwork", "AERAS Networks, Inc." },
    { { 0x00, 0x0E, 0x31 }, "OlympusSoftI", "Olympus Soft Imaging Solutions GmbH" },
    { { 0x00, 0x0E, 0x32 }, "KontronMedic", "Kontron Medical" },
    { { 0x00, 0x0E, 0x33 }, "ShukoElectro", "Shuko Electronics Co.,Ltd" },
    { { 0x00, 0x0E, 0x34 }, "NexGenCityLP", "NexGen City, LP" },
    { { 0x00, 0x0E, 0x35 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x0E, 0x36 }, "HEINESYS",     "HEINESYS, Inc." },
    { { 0x00, 0x0E, 0x37 }, "HarmsWende",   "Harms & Wende GmbH & Co.KG" },
    { { 0x00, 0x0E, 0x38 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0E, 0x39 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0E, 0x3A }, "CirrusLogic",  "Cirrus Logic" },
    { { 0x00, 0x0E, 0x3B }, "HawkingTechn", "Hawking Technologies, Inc." },
    { { 0x00, 0x0E, 0x3C }, "TransactTech", "Transact Technologies Inc" },
    { { 0x00, 0x0E, 0x3D }, "Televic",      "Televic N.V." },
    { { 0x00, 0x0E, 0x3E }, "SunOptronics", "Sun Optronics Inc" },
    { { 0x00, 0x0E, 0x3F }, "Soronti",      "Soronti, Inc." },
    { { 0x00, 0x0E, 0x40 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0E, 0x41 }, "NihonMechatr", "Nihon Mechatronics Co.,Ltd." },
    { { 0x00, 0x0E, 0x42 }, "MoticIncopor", "Motic Incoporation Ltd." },
    { { 0x00, 0x0E, 0x43 }, "GTekElectron", "G-Tek Electronics Sdn. Bhd." },
    { { 0x00, 0x0E, 0x44 }, "Digital5",     "Digital 5, Inc." },
    { { 0x00, 0x0E, 0x45 }, "NewtryElectr", "Beijing Newtry Electronic Technology Ltd" },
    { { 0x00, 0x0E, 0x46 }, "NiigataSeimi", "Niigata Seimitsu Co.,Ltd." },
    { { 0x00, 0x0E, 0x47 }, "NCISystem",    "NCI System Co.,Ltd." },
    { { 0x00, 0x0E, 0x48 }, "LipmanTransA", "Lipman TransAction Solutions" },
    { { 0x00, 0x0E, 0x49 }, "ForswayScand", "Forsway Scandinavia AB" },
    { { 0x00, 0x0E, 0x4A }, "ChangchunHua", "Changchun Huayu WEBPAD Co.,LTD" },
    { { 0x00, 0x0E, 0x4B }, "atriumcandi",  "atrium c and i" },
    { { 0x00, 0x0E, 0x4C }, "Bermai",       "Bermai Inc." },
    { { 0x00, 0x0E, 0x4D }, "Numesa",       "Numesa Inc." },
    { { 0x00, 0x0E, 0x4E }, "WaveplusTech", "Waveplus Technology Co., Ltd." },
    { { 0x00, 0x0E, 0x4F }, "Trajet",       "Trajet GmbH" },
    { { 0x00, 0x0E, 0x50 }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x0E, 0x51 }, "TECNA",        "TECNA SpA" },
    { { 0x00, 0x0E, 0x52 }, "Optium",       "Optium Corporation" },
    { { 0x00, 0x0E, 0x53 }, "AvTech",       "Av Tech Corporation" },
    { { 0x00, 0x0E, 0x54 }, "AlphaCellWir", "AlphaCell Wireless Ltd." },
    { { 0x00, 0x0E, 0x55 }, "Auvitran",     "Auvitran" },
    { { 0x00, 0x0E, 0x56 }, "4G",           "4G Systems GmbH & Co. KG" },
    { { 0x00, 0x0E, 0x57 }, "IworldNetwor", "Iworld Networking, Inc." },
    { { 0x00, 0x0E, 0x58 }, "Sonos",        "Sonos, Inc." },
    { { 0x00, 0x0E, 0x59 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x0E, 0x5A }, "TELEFIELD",    "TELEFIELD inc." },
    { { 0x00, 0x0E, 0x5B }, "ParkerVision", "ParkerVision - Direct2Data" },
    { { 0x00, 0x0E, 0x5C }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x0E, 0x5D }, "TriplePlayTe", "Triple Play Technologies A/S" },
    { { 0x00, 0x0E, 0x5E }, "RaisecomTech", "Raisecom Technology CO., LTD" },
    { { 0x00, 0x0E, 0x5F }, "activnet",     "activ-net GmbH & Co. KG" },
    { { 0x00, 0x0E, 0x60 }, "360SUNDigita", "360SUN Digital Broadband Corporation" },
    { { 0x00, 0x0E, 0x61 }, "Microtrol",    "Microtrol Limited" },
    { { 0x00, 0x0E, 0x62 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0E, 0x63 }, "LemkeDiagnos", "Lemke Diagnostics GmbH" },
    { { 0x00, 0x0E, 0x64 }, "Elphel",       "Elphel, Inc" },
    { { 0x00, 0x0E, 0x65 }, "TransCore",    "TransCore" },
    { { 0x00, 0x0E, 0x66 }, "HitachiIndus", "Hitachi Industry & Control Solutions, Ltd." },
    { { 0x00, 0x0E, 0x67 }, "EltisMicroel", "Eltis Microelectronics Ltd." },
    { { 0x00, 0x0E, 0x68 }, "ETOPNetworkT", "E-TOP Network Technology Inc." },
    { { 0x00, 0x0E, 0x69 }, "ChinaElectri", "China Electric Power Research Institute" },
    { { 0x00, 0x0E, 0x6A }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x0E, 0x6B }, "Janitzaelect", "Janitza electronics GmbH" },
    { { 0x00, 0x0E, 0x6C }, "DeviceDriver", "Device Drivers Limited" },
    { { 0x00, 0x0E, 0x6D }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0x0E, 0x6E }, "MAT",          "MAT S.A. (Mircrelec Advanced Technology)" },
    { { 0x00, 0x0E, 0x6F }, "IRISBerhad",   "IRIS Corporation Berhad" },
    { { 0x00, 0x0E, 0x70 }, "in2Networks",  "in2 Networks" },
    { { 0x00, 0x0E, 0x71 }, "GemstarTechn", "Gemstar Technology Development Ltd." },
    { { 0x00, 0x0E, 0x72 }, "ArcaTechnolo", "Arca Technologies S.r.l." },
    { { 0x00, 0x0E, 0x73 }, "Tpack",        "Tpack A/S" },
    { { 0x00, 0x0E, 0x74 }, "SolarTelecom", "Solar Telecom. Tech" },
    { { 0x00, 0x0E, 0x75 }, "NewYorkAirBr", "New York Air Brake Corp." },
    { { 0x00, 0x0E, 0x76 }, "GemsocInnovi", "Gemsoc Innovision Inc." },
    { { 0x00, 0x0E, 0x77 }, "Decru",        "Decru, Inc." },
    { { 0x00, 0x0E, 0x78 }, "Amtelco",      "Amtelco" },
    { { 0x00, 0x0E, 0x79 }, "AmpleCommuni", "Ample Communications Inc." },
    { { 0x00, 0x0E, 0x7A }, "GemWonCommun", "GemWon Communications Co., Ltd." },
    { { 0x00, 0x0E, 0x7B }, "Toshiba",      "Toshiba" },
    { { 0x00, 0x0E, 0x7C }, "Televes",      "Televes S.A." },
    { { 0x00, 0x0E, 0x7D }, "ElectronicsL", "Electronics Line 3000 Ltd." },
    { { 0x00, 0x0E, 0x7E }, "ionSign",      "ionSign Oy" },
    { { 0x00, 0x0E, 0x7F }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x0E, 0x80 }, "ThomsonTechn", "Thomson Technology Inc" },
    { { 0x00, 0x0E, 0x81 }, "DevicescapeS", "Devicescape Software, Inc." },
    { { 0x00, 0x0E, 0x82 }, "InfinityTech", "Infinity Tech" },
    { { 0x00, 0x0E, 0x83 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0E, 0x84 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0E, 0x85 }, "CatalystEnte", "Catalyst Enterprises, Inc." },
    { { 0x00, 0x0E, 0x86 }, "AlcatelNorth", "Alcatel North America" },
    { { 0x00, 0x0E, 0x87 }, "adpGauselman", "adp Gauselmann GmbH" },
    { { 0x00, 0x0E, 0x88 }, "Videotron",    "Videotron Corp." },
    { { 0x00, 0x0E, 0x89 }, "Clematic",     "Clematic" },
    { { 0x00, 0x0E, 0x8A }, "AvaraTechnol", "Avara Technologies Pty. Ltd." },
    { { 0x00, 0x0E, 0x8B }, "AstarteTechn", "Astarte Technology Co, Ltd." },
    { { 0x00, 0x0E, 0x8C }, "Siemens",      "Siemens AG" },
    { { 0x00, 0x0E, 0x8D }, "SystemsinPro", "Systems in Progress Holding GmbH" },
    { { 0x00, 0x0E, 0x8E }, "SparkLANComm", "SparkLAN Communications, Inc." },
    { { 0x00, 0x0E, 0x8F }, "Sercomm",      "Sercomm Corporation." },
    { { 0x00, 0x0E, 0x90 }, "Ponico",       "Ponico Corp." },
    { { 0x00, 0x0E, 0x91 }, "NavicoAuckla", "Navico Auckland Ltd" },
    { { 0x00, 0x0E, 0x92 }, "OpenTelecom",  "Open Telecom" },
    { { 0x00, 0x0E, 0x93 }, "Milénio3Sist", "Milénio 3 Sistemas Electrónicos, Lda." },
    { { 0x00, 0x0E, 0x94 }, "MaasInternat", "Maas International BV" },
    { { 0x00, 0x0E, 0x95 }, "FujiyaDenkiS", "Fujiya Denki Seisakusho Co.,Ltd." },
    { { 0x00, 0x0E, 0x96 }, "CubicDefense", "Cubic Defense Applications, Inc." },
    { { 0x00, 0x0E, 0x97 }, "UltrackerTec", "Ultracker Technology CO., Inc" },
    { { 0x00, 0x0E, 0x98 }, "HMEClearCom",  "HME Clear-Com LTD." },
    { { 0x00, 0x0E, 0x99 }, "SpectrumDigi", "Spectrum Digital, Inc" },
    { { 0x00, 0x0E, 0x9A }, "BoeTechnolog", "Boe Technology Group Co.,Ltd" },
    { { 0x00, 0x0E, 0x9B }, "AmbitMicrosy", "Ambit Microsystems Corporation" },
    { { 0x00, 0x0E, 0x9C }, "BenchmarkEle", "Benchmark Electronics" },
    { { 0x00, 0x0E, 0x9D }, "TiscaliUK",    "Tiscali UK Ltd" },
    { { 0x00, 0x0E, 0x9E }, "Topfield",     "Topfield Co., Ltd" },
    { { 0x00, 0x0E, 0x9F }, "TEMICSDS",     "TEMIC SDS GmbH" },
    { { 0x00, 0x0E, 0xA0 }, "NetKlassTech", "NetKlass Technology Inc." },
    { { 0x00, 0x0E, 0xA1 }, "FormosaTelet", "Formosa Teletek Corporation" },
    { { 0x00, 0x0E, 0xA2 }, "McAfee",       "McAfee, Inc" },
    { { 0x00, 0x0E, 0xA3 }, "CNCRITHangZh", "CNCR-IT CO.,LTD,HangZhou P.R.CHINA" },
    { { 0x00, 0x0E, 0xA4 }, "Quantum",      "Quantum Corp." },
    { { 0x00, 0x0E, 0xA5 }, "BLIP",         "BLIP Systems" },
    { { 0x00, 0x0E, 0xA6 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x0E, 0xA7 }, "EndaceTechno", "Endace Technology" },
    { { 0x00, 0x0E, 0xA8 }, "UnitedTechno", "United Technologists Europe Limited" },
    { { 0x00, 0x0E, 0xA9 }, "XunShiCommun", "Shanghai Xun Shi Communications Equipment Ltd. Co." },
    { { 0x00, 0x0E, 0xAA }, "Scalent",      "Scalent Systems, Inc." },
    { { 0x00, 0x0E, 0xAB }, "Cray",         "Cray Inc" },
    { { 0x00, 0x0E, 0xAC }, "MintronEnter", "Mintron Enterprise Co., Ltd." },
    { { 0x00, 0x0E, 0xAD }, "MetanoiaTech", "Metanoia Technologies, Inc." },
    { { 0x00, 0x0E, 0xAE }, "GawellTechno", "Gawell Technologies Corp." },
    { { 0x00, 0x0E, 0xAF }, "Castel",       "Castel" },
    { { 0x00, 0x0E, 0xB0 }, "SolutionsRad", "Solutions Radio BV" },
    { { 0x00, 0x0E, 0xB1 }, "Newcotech",    "Newcotech,Ltd" },
    { { 0x00, 0x0E, 0xB2 }, "MicroResearc", "Micro-Research Finland Oy" },
    { { 0x00, 0x0E, 0xB3 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x0E, 0xB4 }, "GuangzhouGao", "Guangzhou Gaoke Communications Technology Co.Ltd." },
    { { 0x00, 0x0E, 0xB5 }, "EcastleElect", "Ecastle Electronics Co., Ltd." },
    { { 0x00, 0x0E, 0xB6 }, "RiverbedTech", "Riverbed Technology, Inc." },
    { { 0x00, 0x0E, 0xB7 }, "Knovative",    "Knovative, Inc." },
    { { 0x00, 0x0E, 0xB8 }, "Iiga",         "Iiga co.,Ltd" },
    { { 0x00, 0x0E, 0xB9 }, "HASHIMOTOEle", "HASHIMOTO Electronics Industry Co.,Ltd." },
    { { 0x00, 0x0E, 0xBA }, "HanmiSemicon", "Hanmi Semiconductor Co., Ltd." },
    { { 0x00, 0x0E, 0xBB }, "EverbeeNetwo", "Everbee Networks" },
    { { 0x00, 0x0E, 0xBC }, "ParagonFidel", "Paragon Fidelity GmbH" },
    { { 0x00, 0x0E, 0xBD }, "BurdickQuint", "Burdick, a Quinton Compny" },
    { { 0x00, 0x0E, 0xBE }, "B&BElectroni", "B&B Electronics Manufacturing Co." },
    { { 0x00, 0x0E, 0xBF }, "Remsdaq",      "Remsdaq Limited" },
    { { 0x00, 0x0E, 0xC0 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0E, 0xC1 }, "MYNAHTechnol", "MYNAH Technologies" },
    { { 0x00, 0x0E, 0xC2 }, "LowranceElec", "Lowrance Electronics, Inc." },
    { { 0x00, 0x0E, 0xC3 }, "LogicControl", "Logic Controls, Inc." },
    { { 0x00, 0x0E, 0xC4 }, "IskraTransmi", "Iskra Transmission d.d." },
    { { 0x00, 0x0E, 0xC5 }, "DigitalMulti", "Digital Multitools Inc" },
    { { 0x00, 0x0E, 0xC6 }, "AsixElectron", "Asix Electronics Corp." },
    { { 0x00, 0x0E, 0xC7 }, "MotorolaKore", "Motorola Korea" },
    { { 0x00, 0x0E, 0xC8 }, "Zoran",        "Zoran Corporation" },
    { { 0x00, 0x0E, 0xC9 }, "YOKOTechnolo", "YOKO Technology Corp." },
    { { 0x00, 0x0E, 0xCA }, "WTSS",         "WTSS Inc" },
    { { 0x00, 0x0E, 0xCB }, "VineSysTechn", "VineSys Technology" },
    { { 0x00, 0x0E, 0xCC }, "Tableau",      "Tableau, LLC" },
    { { 0x00, 0x0E, 0xCD }, "Skov",         "Skov A/S" },
    { { 0x00, 0x0E, 0xCE }, "SITTI",        "S.I.T.T.I. S.p.A." },
    { { 0x00, 0x0E, 0xCF }, "PROFIBUSNutz", "PROFIBUS Nutzerorganisation e.V." },
    { { 0x00, 0x0E, 0xD0 }, "Privaris",     "Privaris, Inc." },
    { { 0x00, 0x0E, 0xD1 }, "OsakaMicroCo", "Osaka Micro Computer." },
    { { 0x00, 0x0E, 0xD2 }, "Filtronic",    "Filtronic plc" },
    { { 0x00, 0x0E, 0xD3 }, "Epicenter",    "Epicenter, Inc." },
    { { 0x00, 0x0E, 0xD4 }, "CresittIndus", "Cresitt Industrie" },
    { { 0x00, 0x0E, 0xD5 }, "COPAN",        "COPAN Systems Inc." },
    { { 0x00, 0x0E, 0xD6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0E, 0xD7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0E, 0xD8 }, "PositronAcce", "Positron Access Solutions Corp" },
    { { 0x00, 0x0E, 0xD9 }, "Aksys",        "Aksys, Ltd." },
    { { 0x00, 0x0E, 0xDA }, "CTechUnited",  "C-Tech United Corp." },
    { { 0x00, 0x0E, 0xDB }, "XiNCOM",       "XiNCOM Corp." },
    { { 0x00, 0x0E, 0xDC }, "Tellion",      "Tellion INC." },
    { { 0x00, 0x0E, 0xDD }, "Shure",        "Shure Incorporated" },
    { { 0x00, 0x0E, 0xDE }, "REMEC",        "REMEC, Inc." },
    { { 0x00, 0x0E, 0xDF }, "PLXTechnolog", "PLX Technology" },
    { { 0x00, 0x0E, 0xE0 }, "Mcharge",      "Mcharge" },
    { { 0x00, 0x0E, 0xE1 }, "ExtremeSpeed", "ExtremeSpeed Inc." },
    { { 0x00, 0x0E, 0xE2 }, "CustomEngine", "Custom Engineering" },
    { { 0x00, 0x0E, 0xE3 }, "ChiyuTechnol", "Chiyu Technology Co.,Ltd" },
    { { 0x00, 0x0E, 0xE4 }, "BoeTechnolog", "Boe Technology Group Co.,Ltd" },
    { { 0x00, 0x0E, 0xE5 }, "bitWallet",    "bitWallet, Inc." },
    { { 0x00, 0x0E, 0xE6 }, "Adimos",       "Adimos Systems LTD" },
    { { 0x00, 0x0E, 0xE7 }, "AacElectroni", "Aac Electronics Corp." },
    { { 0x00, 0x0E, 0xE8 }, "ZioncomElect", "Zioncom Electronics (Shenzhen) Ltd." },
    { { 0x00, 0x0E, 0xE9 }, "WayTechDevel", "WayTech Development, Inc." },
    { { 0x00, 0x0E, 0xEA }, "ShadongLunen", "Shadong Luneng Jicheng Electronics,Co.,Ltd" },
    { { 0x00, 0x0E, 0xEB }, "SandmartinEl", "Sandmartin(zhong shan)Electronics Co.,Ltd" },
    { { 0x00, 0x0E, 0xEC }, "Orban",        "Orban" },
    { { 0x00, 0x0E, 0xED }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x0E, 0xEE }, "MucoIndustri", "Muco Industrie BV" },
    { { 0x00, 0x0E, 0xEF }, "Private",      "Private" },
    { { 0x00, 0x0E, 0xF0 }, "Festo",        "Festo AG & Co. KG" },
    { { 0x00, 0x0E, 0xF1 }, "Ezquest",      "Ezquest Inc." },
    { { 0x00, 0x0E, 0xF2 }, "Infinico",     "Infinico Corporation" },
    { { 0x00, 0x0E, 0xF3 }, "Smartlabs",    "Smartlabs, Inc." },
    { { 0x00, 0x0E, 0xF4 }, "KasdaNetwork", "Kasda Networks Inc" },
    { { 0x00, 0x0E, 0xF5 }, "iPACTechnolo", "iPAC Technology Co., Ltd." },
    { { 0x00, 0x0E, 0xF6 }, "ETENInformat", "E-TEN Information Systems Co., Ltd." },
    { { 0x00, 0x0E, 0xF7 }, "VulcanPortal", "Vulcan Portals Inc" },
    { { 0x00, 0x0E, 0xF8 }, "SbcAsi",       "Sbc Asi" },
    { { 0x00, 0x0E, 0xF9 }, "REAElektroni", "REA Elektronik GmbH" },
    { { 0x00, 0x0E, 0xFA }, "OptowayTechn", "Optoway Technology Incorporation" },
    { { 0x00, 0x0E, 0xFB }, "MaceyEnterpr", "Macey Enterprises" },
    { { 0x00, 0x0E, 0xFC }, "JTAGTechnolo", "JTAG Technologies B.V." },
    { { 0x00, 0x0E, 0xFD }, "Fujinon",      "Fujinon Corporation" },
    { { 0x00, 0x0E, 0xFE }, "EndRunTechno", "EndRun Technologies LLC" },
    { { 0x00, 0x0E, 0xFF }, "Megasolution", "Megasolution,Inc." },
    { { 0x00, 0x0F, 0x00 }, "Legra",        "Legra Systems, Inc." },
    { { 0x00, 0x0F, 0x01 }, "Digitalks",    "Digitalks Inc" },
    { { 0x00, 0x0F, 0x02 }, "DigicubeTech", "Digicube Technology Co., Ltd" },
    { { 0x00, 0x0F, 0x03 }, "Com&C",        "Com&C Co., Ltd" },
    { { 0x00, 0x0F, 0x04 }, "cimusa",       "cim-usa inc" },
    { { 0x00, 0x0F, 0x05 }, "3BSystem",     "3B System Inc." },
    { { 0x00, 0x0F, 0x06 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0F, 0x07 }, "Mangrove",     "Mangrove Systems, Inc." },
    { { 0x00, 0x0F, 0x08 }, "Indagon",      "Indagon Oy" },
    { { 0x00, 0x0F, 0x09 }, "Private",      "Private" },
    { { 0x00, 0x0F, 0x0A }, "ClearEdgeNet", "Clear Edge Networks" },
    { { 0x00, 0x0F, 0x0B }, "KentimaTechn", "Kentima Technologies AB" },
    { { 0x00, 0x0F, 0x0C }, "SynchronicEn", "Synchronic Engineering" },
    { { 0x00, 0x0F, 0x0D }, "HuntElectron", "Hunt Electronic Co., Ltd." },
    { { 0x00, 0x0F, 0x0E }, "WaveSplitter", "WaveSplitter Technologies, Inc." },
    { { 0x00, 0x0F, 0x0F }, "RealIDTechno", "Real ID Technology Co., Ltd." },
    { { 0x00, 0x0F, 0x10 }, "RDM",          "RDM Corporation" },
    { { 0x00, 0x0F, 0x11 }, "Prodrive",     "Prodrive B.V." },
    { { 0x00, 0x0F, 0x12 }, "PanasonicEur", "Panasonic Europe Ltd." },
    { { 0x00, 0x0F, 0x13 }, "Nisca",        "Nisca corporation" },
    { { 0x00, 0x0F, 0x14 }, "Mindray",      "Mindray Co., Ltd." },
    { { 0x00, 0x0F, 0x15 }, "Icotera",      "Icotera A/S" },
    { { 0x00, 0x0F, 0x16 }, "JayHowTechno", "Jay How Technology Co.," },
    { { 0x00, 0x0F, 0x17 }, "InstaElektro", "Insta Elektro GmbH" },
    { { 0x00, 0x0F, 0x18 }, "IndustrialCo", "Industrial Control Systems" },
    { { 0x00, 0x0F, 0x19 }, "BostonScient", "Boston Scientific" },
    { { 0x00, 0x0F, 0x1A }, "GamingSuppor", "Gaming Support B.V." },
    { { 0x00, 0x0F, 0x1B }, "Ego",          "Ego Systems Inc." },
    { { 0x00, 0x0F, 0x1C }, "DigitAllWorl", "DigitAll World Co., Ltd" },
    { { 0x00, 0x0F, 0x1D }, "CosmoTechs",   "Cosmo Techs Co., Ltd." },
    { { 0x00, 0x0F, 0x1E }, "KTElectricHi", "Chengdu KT Electric Co.of High & New Technology" },
    { { 0x00, 0x0F, 0x1F }, "Dell",         "Dell Inc." },
    { { 0x00, 0x0F, 0x20 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x0F, 0x21 }, "ScientificAt", "Scientific Atlanta, Inc" },
    { { 0x00, 0x0F, 0x22 }, "Helius",       "Helius, Inc." },
    { { 0x00, 0x0F, 0x23 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0x24 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0x25 }, "AimValley",    "AimValley B.V." },
    { { 0x00, 0x0F, 0x26 }, "WorldAccxx",   "WorldAccxx LLC" },
    { { 0x00, 0x0F, 0x27 }, "TEALElectron", "TEAL Electronics, Inc." },
    { { 0x00, 0x0F, 0x28 }, "Itronix",      "Itronix Corporation" },
    { { 0x00, 0x0F, 0x29 }, "Augmentix",    "Augmentix Corporation" },
    { { 0x00, 0x0F, 0x2A }, "CablewareEle", "Cableware Electronics" },
    { { 0x00, 0x0F, 0x2B }, "Greenbell",    "Greenbell Systems" },
    { { 0x00, 0x0F, 0x2C }, "Lantronix",    "Lantronix" },
    { { 0x00, 0x0F, 0x2D }, "ChungHsinEle", "Chung-Hsin Electric & Machinery Mfg.Corp." },
    { { 0x00, 0x0F, 0x2E }, "MegapowerInt", "Megapower International Corp." },
    { { 0x00, 0x0F, 0x2F }, "WLinxTechnol", "W-Linx Technology Co., Ltd." },
    { { 0x00, 0x0F, 0x30 }, "RazaMicroele", "Raza Microelectronics Inc" },
    { { 0x00, 0x0F, 0x31 }, "AlliedVision", "Allied Vision Technologies Canada Inc" },
    { { 0x00, 0x0F, 0x32 }, "LootomTelcov", "Lootom Telcovideo Network (Wuxi) Co Ltd" },
    { { 0x00, 0x0F, 0x33 }, "DUALi",        "DUALi Inc." },
    { { 0x00, 0x0F, 0x34 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0x35 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0x36 }, "AccurateTech", "Accurate Techhnologies, Inc." },
    { { 0x00, 0x0F, 0x37 }, "Xambala",      "Xambala Incorporated" },
    { { 0x00, 0x0F, 0x38 }, "Netstar",      "Netstar" },
    { { 0x00, 0x0F, 0x39 }, "IrisSensors",  "Iris Sensors" },
    { { 0x00, 0x0F, 0x3A }, "Hisharp",      "Hisharp" },
    { { 0x00, 0x0F, 0x3B }, "FujiSystemMa", "Fuji System Machines Co., Ltd." },
    { { 0x00, 0x0F, 0x3C }, "Endeleo",      "Endeleo Limited" },
    { { 0x00, 0x0F, 0x3D }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x0F, 0x3E }, "CardioNet",    "CardioNet, Inc" },
    { { 0x00, 0x0F, 0x3F }, "BigBearNetwo", "Big Bear Networks" },
    { { 0x00, 0x0F, 0x40 }, "OpticalInter", "Optical Internetworking Forum" },
    { { 0x00, 0x0F, 0x41 }, "Zipher",       "Zipher Ltd" },
    { { 0x00, 0x0F, 0x42 }, "Xalyo",        "Xalyo Systems" },
    { { 0x00, 0x0F, 0x43 }, "Wasabi",       "Wasabi Systems Inc." },
    { { 0x00, 0x0F, 0x44 }, "Tivella",      "Tivella Inc." },
    { { 0x00, 0x0F, 0x45 }, "Stretch",      "Stretch, Inc." },
    { { 0x00, 0x0F, 0x46 }, "Sinar",        "Sinar Ag" },
    { { 0x00, 0x0F, 0x47 }, "Robox",        "Robox Spa" },
    { { 0x00, 0x0F, 0x48 }, "Polypix",      "Polypix Inc." },
    { { 0x00, 0x0F, 0x49 }, "NorthoverSol", "Northover Solutions Limited" },
    { { 0x00, 0x0F, 0x4A }, "Kyushukyohan", "Kyushu-kyohan co.,ltd" },
    { { 0x00, 0x0F, 0x4B }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x0F, 0x4C }, "Elextech",     "Elextech INC" },
    { { 0x00, 0x0F, 0x4D }, "TalkSwitch",   "TalkSwitch" },
    { { 0x00, 0x0F, 0x4E }, "Cellink",      "Cellink" },
    { { 0x00, 0x0F, 0x4F }, "PCSSystemtec", "PCS Systemtechnik GmbH" },
    { { 0x00, 0x0F, 0x50 }, "StreamScale",  "StreamScale Limited" },
    { { 0x00, 0x0F, 0x51 }, "Azul",         "Azul Systems, Inc." },
    { { 0x00, 0x0F, 0x52 }, "YORKRefriger", "YORK Refrigeration, Marine & Controls" },
    { { 0x00, 0x0F, 0x53 }, "SolarflareCo", "Solarflare Communications Inc." },
    { { 0x00, 0x0F, 0x54 }, "Entrelogic",   "Entrelogic Corporation" },
    { { 0x00, 0x0F, 0x55 }, "DatawireComm", "Datawire Communication Networks Inc." },
    { { 0x00, 0x0F, 0x56 }, "ContinuumPho", "Continuum Photonics Inc" },
    { { 0x00, 0x0F, 0x57 }, "CABLELOGIC",   "CABLELOGIC Co., Ltd." },
    { { 0x00, 0x0F, 0x58 }, "AdderTechnol", "Adder Technology Limited" },
    { { 0x00, 0x0F, 0x59 }, "Phonak",       "Phonak AG" },
    { { 0x00, 0x0F, 0x5A }, "PeribitNetwo", "Peribit Networks" },
    { { 0x00, 0x0F, 0x5B }, "DeltaInforma", "Delta Information Systems, Inc." },
    { { 0x00, 0x0F, 0x5C }, "DayOneDigita", "Day One Digital Media Limited" },
    { { 0x00, 0x0F, 0x5D }, "Genexis",      "Genexis BV" },
    { { 0x00, 0x0F, 0x5E }, "Veo",          "Veo" },
    { { 0x00, 0x0F, 0x5F }, "NicetyTechno", "Nicety Technologies Inc. (NTS)" },
    { { 0x00, 0x0F, 0x60 }, "Lifetron",     "Lifetron Co.,Ltd" },
    { { 0x00, 0x0F, 0x61 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x0F, 0x62 }, "AlcatelBellS", "Alcatel Bell Space N.V." },
    { { 0x00, 0x0F, 0x63 }, "ObzervTechno", "Obzerv Technologies" },
    { { 0x00, 0x0F, 0x64 }, "D&RElectroni", "D&R Electronica Weesp BV" },
    { { 0x00, 0x0F, 0x65 }, "icube",        "icube Corp." },
    { { 0x00, 0x0F, 0x66 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x0F, 0x67 }, "WestInstrume", "West Instruments" },
    { { 0x00, 0x0F, 0x68 }, "VavicNetwork", "Vavic Network Technology, Inc." },
    { { 0x00, 0x0F, 0x69 }, "SEWEurodrive", "SEW Eurodrive GmbH & Co. KG" },
    { { 0x00, 0x0F, 0x6A }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0F, 0x6B }, "GateWareComm", "GateWare Communications GmbH" },
    { { 0x00, 0x0F, 0x6C }, "ADDIDATA",     "ADDI-DATA GmbH" },
    { { 0x00, 0x0F, 0x6D }, "MidasEnginee", "Midas Engineering" },
    { { 0x00, 0x0F, 0x6E }, "BBox",         "BBox" },
    { { 0x00, 0x0F, 0x6F }, "FTACommunica", "FTA Communication Technologies" },
    { { 0x00, 0x0F, 0x70 }, "WintecIndust", "Wintec Industries, inc." },
    { { 0x00, 0x0F, 0x71 }, "SanmeiElectr", "Sanmei Electronics Co.,Ltd" },
    { { 0x00, 0x0F, 0x72 }, "Sandburst",    "Sandburst" },
    { { 0x00, 0x0F, 0x73 }, "RSAutomation", "RS Automation Co., Ltd" },
    { { 0x00, 0x0F, 0x74 }, "QamcomTechno", "Qamcom Technology AB" },
    { { 0x00, 0x0F, 0x75 }, "FirstSilicon", "First Silicon Solutions" },
    { { 0x00, 0x0F, 0x76 }, "DigitalKeyst", "Digital Keystone, Inc." },
    { { 0x00, 0x0F, 0x77 }, "Dentum",       "Dentum Co.,Ltd" },
    { { 0x00, 0x0F, 0x78 }, "Datacap",      "Datacap Systems Inc" },
    { { 0x00, 0x0F, 0x79 }, "BluetoothInt", "Bluetooth Interest Group Inc." },
    { { 0x00, 0x0F, 0x7A }, "NuQXTechnolo", "BeiJing NuQX Technology CO.,LTD" },
    { { 0x00, 0x0F, 0x7B }, "ArceSistemas", "Arce Sistemas, S.A." },
    { { 0x00, 0x0F, 0x7C }, "ACTi",         "ACTi Corporation" },
    { { 0x00, 0x0F, 0x7D }, "Xirrus",       "Xirrus" },
    { { 0x00, 0x0F, 0x7E }, "AblerexElect", "Ablerex Electronics Co., LTD" },
    { { 0x00, 0x0F, 0x7F }, "UBSTORAGE",    "UBSTORAGE Co.,Ltd." },
    { { 0x00, 0x0F, 0x80 }, "TrinitySecur", "Trinity Security Systems,Inc." },
    { { 0x00, 0x0F, 0x81 }, "PALPacific",   "PAL Pacific Inc." },
    { { 0x00, 0x0F, 0x82 }, "MortaraInstr", "Mortara Instrument, Inc." },
    { { 0x00, 0x0F, 0x83 }, "BrainiumTech", "Brainium Technologies Inc." },
    { { 0x00, 0x0F, 0x84 }, "AstuteNetwor", "Astute Networks, Inc." },
    { { 0x00, 0x0F, 0x85 }, "ADDOJapan",    "ADDO-Japan Corporation" },
    { { 0x00, 0x0F, 0x86 }, "BlackBerryRT", "BlackBerry RTS" },
    { { 0x00, 0x0F, 0x87 }, "MaxcessInter", "Maxcess International" },
    { { 0x00, 0x0F, 0x88 }, "AMETEK",       "AMETEK, Inc." },
    { { 0x00, 0x0F, 0x89 }, "WinnertecSys", "Winnertec System Co., Ltd." },
    { { 0x00, 0x0F, 0x8A }, "WideView",     "WideView" },
    { { 0x00, 0x0F, 0x8B }, "OrionMultiSy", "Orion MultiSystems Inc" },
    { { 0x00, 0x0F, 0x8C }, "Gigawavetech", "Gigawavetech Pte Ltd" },
    { { 0x00, 0x0F, 0x8D }, "FASTTVServer", "FAST TV-Server AG" },
    { { 0x00, 0x0F, 0x8E }, "DongyangTele", "Dongyang Telecom Co.,Ltd." },
    { { 0x00, 0x0F, 0x8F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0x90 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0x91 }, "Aerotelecom",  "Aerotelecom Co.,Ltd." },
    { { 0x00, 0x0F, 0x92 }, "Microhard",    "Microhard Systems Inc." },
    { { 0x00, 0x0F, 0x93 }, "LandisGyr",    "Landis+Gyr Ltd." },
    { { 0x00, 0x0F, 0x94 }, "Genexis",      "Genexis BV" },
    { { 0x00, 0x0F, 0x95 }, "ELECOMLaneed", "ELECOM Co.,LTD Laneed Division" },
    { { 0x00, 0x0F, 0x96 }, "Telco",        "Telco Systems, Inc." },
    { { 0x00, 0x0F, 0x97 }, "Avanex",       "Avanex Corporation" },
    { { 0x00, 0x0F, 0x98 }, "Avamax",       "Avamax Co. Ltd." },
    { { 0x00, 0x0F, 0x99 }, "APACoptoElec", "APAC opto Electronics Inc." },
    { { 0x00, 0x0F, 0x9A }, "Synchrony",    "Synchrony, Inc." },
    { { 0x00, 0x0F, 0x9B }, "RossVideo",    "Ross Video Limited" },
    { { 0x00, 0x0F, 0x9C }, "Panduit",      "Panduit Corp" },
    { { 0x00, 0x0F, 0x9D }, "DisplayLink",  "DisplayLink (UK) Ltd" },
    { { 0x00, 0x0F, 0x9E }, "Murrelektron", "Murrelektronik GmbH" },
    { { 0x00, 0x0F, 0x9F }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x0F, 0xA0 }, "CanonKorea",   "Canon Korea Inc." },
    { { 0x00, 0x0F, 0xA1 }, "Gigabit",      "Gigabit Systems Inc." },
    { { 0x00, 0x0F, 0xA2 }, "2xWireless",   "2xWireless" },
    { { 0x00, 0x0F, 0xA3 }, "AlphaNetwork", "Alpha Networks Inc." },
    { { 0x00, 0x0F, 0xA4 }, "SprecherAuto", "Sprecher Automation GmbH" },
    { { 0x00, 0x0F, 0xA5 }, "BWATechnolog", "BWA Technology GmbH" },
    { { 0x00, 0x0F, 0xA6 }, "S2Security",   "S2 Security Corporation" },
    { { 0x00, 0x0F, 0xA7 }, "RaptorNetwor", "Raptor Networks Technology" },
    { { 0x00, 0x0F, 0xA8 }, "Photometrics", "Photometrics, Inc." },
    { { 0x00, 0x0F, 0xA9 }, "PCFabrik",     "PC Fabrik" },
    { { 0x00, 0x0F, 0xAA }, "NexusTechnol", "Nexus Technologies" },
    { { 0x00, 0x0F, 0xAB }, "KyushuElectr", "Kyushu Electronics Systems Inc." },
    { { 0x00, 0x0F, 0xAC }, "Ieee80211",    "Ieee 802.11" },
    { { 0x00, 0x0F, 0xAD }, "FMNcommunica", "FMN communications GmbH" },
    { { 0x00, 0x0F, 0xAE }, "E2OCommunica", "E2O Communications" },
    { { 0x00, 0x0F, 0xAF }, "Dialog",       "Dialog Inc." },
    { { 0x00, 0x0F, 0xB0 }, "CompalElectr", "Compal Electronics INC." },
    { { 0x00, 0x0F, 0xB1 }, "Cognio",       "Cognio Inc." },
    { { 0x00, 0x0F, 0xB2 }, "BroadbandPac", "Broadband Pacenet (India) Pvt. Ltd." },
    { { 0x00, 0x0F, 0xB3 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x0F, 0xB4 }, "TimespaceTec", "Timespace Technology" },
    { { 0x00, 0x0F, 0xB5 }, "Netgear",      "Netgear" },
    { { 0x00, 0x0F, 0xB6 }, "EuroplexTech", "Europlex Technologies" },
    { { 0x00, 0x0F, 0xB7 }, "Cavium",       "Cavium" },
    { { 0x00, 0x0F, 0xB8 }, "CallURL",      "CallURL Inc." },
    { { 0x00, 0x0F, 0xB9 }, "AdaptiveInst", "Adaptive Instruments" },
    { { 0x00, 0x0F, 0xBA }, "Tevebox",      "Tevebox AB" },
    { { 0x00, 0x0F, 0xBB }, "NokiaSiemens", "Nokia Siemens Networks GmbH & Co. KG." },
    { { 0x00, 0x0F, 0xBC }, "OnkeyTechnol", "Onkey Technologies, Inc." },
    { { 0x00, 0x0F, 0xBD }, "MRVCommunica", "MRV Communications (Networks) LTD" },
    { { 0x00, 0x0F, 0xBE }, "ewyou",        "e-w/you Inc." },
    { { 0x00, 0x0F, 0xBF }, "DGTSp",        "DGT Sp. z o.o." },
    { { 0x00, 0x0F, 0xC0 }, "DELCOMp",      "DELCOMp" },
    { { 0x00, 0x0F, 0xC1 }, "WAVE",         "WAVE Corporation" },
    { { 0x00, 0x0F, 0xC2 }, "Uniwell",      "Uniwell Corporation" },
    { { 0x00, 0x0F, 0xC3 }, "PalmPalmTech", "PalmPalm Technology, Inc." },
    { { 0x00, 0x0F, 0xC4 }, "NST",          "NST co.,LTD." },
    { { 0x00, 0x0F, 0xC5 }, "KeyMed",       "KeyMed Ltd" },
    { { 0x00, 0x0F, 0xC6 }, "EurocomIndus", "Eurocom Industries A/S" },
    { { 0x00, 0x0F, 0xC7 }, "DionicaR&D",   "Dionica R&D Ltd." },
    { { 0x00, 0x0F, 0xC8 }, "ChantryNetwo", "Chantry Networks" },
    { { 0x00, 0x0F, 0xC9 }, "Allnet",       "Allnet GmbH" },
    { { 0x00, 0x0F, 0xCA }, "AJinTechline", "A-Jin Techline Co, Ltd" },
    { { 0x00, 0x0F, 0xCB }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x0F, 0xCC }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x0F, 0xCD }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x0F, 0xCE }, "KikusuiElect", "Kikusui Electronics Corp." },
    { { 0x00, 0x0F, 0xCF }, "DataWindRese", "DataWind Research" },
    { { 0x00, 0x0F, 0xD0 }, "Astri",        "Astri" },
    { { 0x00, 0x0F, 0xD1 }, "AppliedWirel", "Applied Wireless Identifications Group, Inc." },
    { { 0x00, 0x0F, 0xD2 }, "EWATechnolog", "EWA Technologies, Inc." },
    { { 0x00, 0x0F, 0xD3 }, "Digium",       "Digium" },
    { { 0x00, 0x0F, 0xD4 }, "Soundcraft",   "Soundcraft" },
    { { 0x00, 0x0F, 0xD5 }, "SchwechatRIS", "Schwechat - RISE" },
    { { 0x00, 0x0F, 0xD6 }, "Sarotech",     "Sarotech Co., Ltd" },
    { { 0x00, 0x0F, 0xD7 }, "HarmanMusicG", "Harman Music Group" },
    { { 0x00, 0x0F, 0xD8 }, "Force",        "Force, Inc." },
    { { 0x00, 0x0F, 0xD9 }, "FlexDSLTelec", "FlexDSL Telecommunications AG" },
    { { 0x00, 0x0F, 0xDA }, "Yazaki",       "Yazaki Corporation" },
    { { 0x00, 0x0F, 0xDB }, "WestellTechn", "Westell Technologies Inc." },
    { { 0x00, 0x0F, 0xDC }, "UedaJapanRad", "Ueda Japan Radio Co., Ltd." },
    { { 0x00, 0x0F, 0xDD }, "Sordin",       "Sordin Ab" },
    { { 0x00, 0x0F, 0xDE }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x0F, 0xDF }, "SOLOMONTechn", "SOLOMON Technology Corp." },
    { { 0x00, 0x0F, 0xE0 }, "NComputing",   "NComputing Co.,Ltd." },
    { { 0x00, 0x0F, 0xE1 }, "IdDigital",    "Id Digital Corporation" },
    { { 0x00, 0x0F, 0xE2 }, "H3CTechnolog", "Hangzhou H3C Technologies Co., Limited" },
    { { 0x00, 0x0F, 0xE3 }, "DammCellular", "Damm Cellular Systems A/S" },
    { { 0x00, 0x0F, 0xE4 }, "Pantech",      "Pantech Co.,Ltd" },
    { { 0x00, 0x0F, 0xE5 }, "MercurySecur", "Mercury Security Corporation" },
    { { 0x00, 0x0F, 0xE6 }, "MBTech",       "MBTech Systems, Inc." },
    { { 0x00, 0x0F, 0xE7 }, "LutronElectr", "Lutron Electronics Co., Inc." },
    { { 0x00, 0x0F, 0xE8 }, "Lobos",        "Lobos, Inc." },
    { { 0x00, 0x0F, 0xE9 }, "GwTechnologi", "Gw Technologies Co.,Ltd." },
    { { 0x00, 0x0F, 0xEA }, "GigaByteTech", "Giga-Byte Technology Co.,Ltd." },
    { { 0x00, 0x0F, 0xEB }, "CylonControl", "Cylon Controls" },
    { { 0x00, 0x0F, 0xEC }, "ARKUS",        "ARKUS Inc." },
    { { 0x00, 0x0F, 0xED }, "AnamElectron", "Anam Electronics Co., Ltd" },
    { { 0x00, 0x0F, 0xEE }, "XTec",         "XTec, Incorporated" },
    { { 0x00, 0x0F, 0xEF }, "ThaleseTrans", "Thales e-Transactions GmbH" },
    { { 0x00, 0x0F, 0xF0 }, "Sunray",       "Sunray Co. Ltd." },
    { { 0x00, 0x0F, 0xF1 }, "nexGPte",      "nex-G Systems Pte.Ltd" },
    { { 0x00, 0x0F, 0xF2 }, "LoudTechnolo", "Loud Technologies Inc." },
    { { 0x00, 0x0F, 0xF3 }, "JungMyoungCo", "Jung Myoung Communications&Technology" },
    { { 0x00, 0x0F, 0xF4 }, "GuntermannDr", "Guntermann & Drunck GmbH" },
    { { 0x00, 0x0F, 0xF5 }, "GN&S",         "GN&S company" },
    { { 0x00, 0x0F, 0xF6 }, "DarfonLighti", "Darfon Lighting Corp" },
    { { 0x00, 0x0F, 0xF7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0xF8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x0F, 0xF9 }, "Valcretec",    "Valcretec, Inc." },
    { { 0x00, 0x0F, 0xFA }, "Optinel",      "Optinel Systems, Inc." },
    { { 0x00, 0x0F, 0xFB }, "NipponDensoI", "Nippon Denso Industry Co., Ltd." },
    { { 0x00, 0x0F, 0xFC }, "MeritLiLinEn", "Merit Li-Lin Ent." },
    { { 0x00, 0x0F, 0xFD }, "GlorytekNetw", "Glorytek Network Inc." },
    { { 0x00, 0x0F, 0xFE }, "GProComputer", "G-Pro Computer" },
    { { 0x00, 0x0F, 0xFF }, "Control4",     "Control4" },
    { { 0x00, 0x10, 0x00 }, "CableTelevis", "Cable Television Laboratories, Inc." },
    { { 0x00, 0x10, 0x01 }, "Citel",        "Citel" },
    { { 0x00, 0x10, 0x02 }, "Actia",        "Actia" },
    { { 0x00, 0x10, 0x03 }, "Imatron",      "Imatron, Inc." },
    { { 0x00, 0x10, 0x04 }, "BrantleyCoil", "The Brantley Coile Company,Inc" },
    { { 0x00, 0x10, 0x05 }, "UecCommercia", "Uec Commercial" },
    { { 0x00, 0x10, 0x06 }, "ThalesContac", "Thales Contact Solutions Ltd." },
    { { 0x00, 0x10, 0x07 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x08 }, "Vienna",       "Vienna Systems Corporation" },
    { { 0x00, 0x10, 0x09 }, "Horanet",      "Horanet" },
    { { 0x00, 0x10, 0x0A }, "WilliamsComm", "Williams Communications Group" },
    { { 0x00, 0x10, 0x0B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x0C }, "Ito",          "Ito Co., Ltd." },
    { { 0x00, 0x10, 0x0D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x0E }, "MicroLinearC", "Micro Linear Coporation" },
    { { 0x00, 0x10, 0x0F }, "IndustrialCp", "Industrial Cpu Systems" },
    { { 0x00, 0x10, 0x10 }, "Initio",       "Initio Corporation" },
    { { 0x00, 0x10, 0x11 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x12 }, "Processor",    "Processor Systems (I) Pvt Ltd" },
    { { 0x00, 0x10, 0x13 }, "KontronAmeri", "Kontron America, Inc." },
    { { 0x00, 0x10, 0x14 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x15 }, "OOmon",        "OOmon Inc." },
    { { 0x00, 0x10, 0x16 }, "TSqware",      "T.Sqware" },
    { { 0x00, 0x10, 0x17 }, "BoschAccess",  "Bosch Access Systems GmbH" },
    { { 0x00, 0x10, 0x18 }, "Broadcom",     "Broadcom" },
    { { 0x00, 0x10, 0x19 }, "SIRONADENTAL", "SIRONA DENTAL SYSTEMS GmbH & Co. KG" },
    { { 0x00, 0x10, 0x1A }, "PictureTel",   "PictureTel Corp." },
    { { 0x00, 0x10, 0x1B }, "CornetTechno", "Cornet Technology, Inc." },
    { { 0x00, 0x10, 0x1C }, "OhmTechnolog", "Ohm Technologies Intl, Llc" },
    { { 0x00, 0x10, 0x1D }, "WinbondElect", "Winbond Electronics Corp." },
    { { 0x00, 0x10, 0x1E }, "MatsushitaEl", "Matsushita Electronic Instruments Corp." },
    { { 0x00, 0x10, 0x1F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x20 }, "HandHeldProd", "Hand Held Products Inc" },
    { { 0x00, 0x10, 0x21 }, "EncantoNetwo", "Encanto Networks, Inc." },
    { { 0x00, 0x10, 0x22 }, "SatComMedia",  "SatCom Media Corporation" },
    { { 0x00, 0x10, 0x23 }, "NetworkEquip", "Network Equipment Technologies" },
    { { 0x00, 0x10, 0x24 }, "NagoyaElectr", "Nagoya Electric Works Co., Ltd" },
    { { 0x00, 0x10, 0x25 }, "Grayhill",     "Grayhill, Inc" },
    { { 0x00, 0x10, 0x26 }, "AcceleratedN", "Accelerated Networks, Inc." },
    { { 0x00, 0x10, 0x27 }, "L3Communicat", "L-3 Communications East" },
    { { 0x00, 0x10, 0x28 }, "ComputerTech", "Computer Technica, Inc." },
    { { 0x00, 0x10, 0x29 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x2A }, "ZfMicrosyste", "Zf Microsystems, Inc." },
    { { 0x00, 0x10, 0x2B }, "UmaxData",     "Umax Data Systems, Inc." },
    { { 0x00, 0x10, 0x2C }, "LasatNetwork", "Lasat Networks A/S" },
    { { 0x00, 0x10, 0x2D }, "HitachiSoftw", "Hitachi Software Engineering" },
    { { 0x00, 0x10, 0x2E }, "NetworkTechn", "Network Systems & Technologies Pvt. Ltd." },
    { { 0x00, 0x10, 0x2F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x30 }, "EION",         "EION Inc." },
    { { 0x00, 0x10, 0x31 }, "ObjectiveCom", "Objective Communications, Inc." },
    { { 0x00, 0x10, 0x32 }, "AltaTechnolo", "Alta Technology" },
    { { 0x00, 0x10, 0x33 }, "AccesslanCom", "Accesslan Communications, Inc." },
    { { 0x00, 0x10, 0x34 }, "GNPComputers", "GNP Computers" },
    { { 0x00, 0x10, 0x35 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x10, 0x36 }, "InterTelInte", "Inter-Tel Integrated Systems" },
    { { 0x00, 0x10, 0x37 }, "CYQveTechnol", "CYQ've Technology Co., Ltd." },
    { { 0x00, 0x10, 0x38 }, "MicroResearc", "Micro Research Ltd." },
    { { 0x00, 0x10, 0x39 }, "Vectron",      "Vectron Systems AG" },
    { { 0x00, 0x10, 0x3A }, "DiamondNetwo", "Diamond Network Tech" },
    { { 0x00, 0x10, 0x3B }, "HippiNetwork", "Hippi Networking Forum" },
    { { 0x00, 0x10, 0x3C }, "IcEnsemble",   "Ic Ensemble, Inc." },
    { { 0x00, 0x10, 0x3D }, "Phasecom",     "Phasecom, Ltd." },
    { { 0x00, 0x10, 0x3E }, "Netschools",   "Netschools Corporation" },
    { { 0x00, 0x10, 0x3F }, "TollgradeCom", "Tollgrade Communications, Inc." },
    { { 0x00, 0x10, 0x40 }, "Intermec",     "Intermec Corporation" },
    { { 0x00, 0x10, 0x41 }, "BristolBabco", "Bristol Babcock, Inc." },
    { { 0x00, 0x10, 0x42 }, "Alacritech",   "Alacritech, Inc." },
    { { 0x00, 0x10, 0x43 }, "A2",           "A2 Corporation" },
    { { 0x00, 0x10, 0x44 }, "InnoLabs",     "InnoLabs Corporation" },
    { { 0x00, 0x10, 0x45 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x10, 0x46 }, "AlcornMcbrid", "Alcorn Mcbride Inc." },
    { { 0x00, 0x10, 0x47 }, "EchoEletric",  "Echo Eletric Co. Ltd." },
    { { 0x00, 0x10, 0x48 }, "HtrcAutomati", "Htrc Automation, Inc." },
    { { 0x00, 0x10, 0x49 }, "ShoreTel",     "ShoreTel, Inc" },
    { { 0x00, 0x10, 0x4A }, "Parvus",       "The Parvus Corporation" },
    { { 0x00, 0x10, 0x4B }, "3Com",         "3Com" },
    { { 0x00, 0x10, 0x4C }, "TeledyneLeCr", "Teledyne LeCroy, Inc" },
    { { 0x00, 0x10, 0x4D }, "SurtecIndust", "Surtec Industries, Inc." },
    { { 0x00, 0x10, 0x4E }, "Ceologic",     "Ceologic" },
    { { 0x00, 0x10, 0x4F }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x10, 0x50 }, "Rion",         "Rion Co., Ltd." },
    { { 0x00, 0x10, 0x51 }, "Cmicro",       "Cmicro Corporation" },
    { { 0x00, 0x10, 0x52 }, "MettlerToled", "Mettler-Toledo (Albstadt) Gmbh" },
    { { 0x00, 0x10, 0x53 }, "ComputerTech", "Computer Technology Corp." },
    { { 0x00, 0x10, 0x54 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x55 }, "FujitsuMicro", "Fujitsu Microelectronics, Inc." },
    { { 0x00, 0x10, 0x56 }, "Sodick",       "Sodick Co., Ltd." },
    { { 0x00, 0x10, 0x57 }, "Rebelcom",     "Rebel.com, Inc." },
    { { 0x00, 0x10, 0x58 }, "ArrowPointCo", "ArrowPoint Communications" },
    { { 0x00, 0x10, 0x59 }, "DiabloResear", "Diablo Research Co. Llc" },
    { { 0x00, 0x10, 0x5A }, "3Com",         "3Com" },
    { { 0x00, 0x10, 0x5B }, "NetInsight",   "Net Insight Ab" },
    { { 0x00, 0x10, 0x5C }, "QuantumDesig", "Quantum Designs (H.K.) Ltd." },
    { { 0x00, 0x10, 0x5D }, "DraegerMedic", "Draeger Medical" },
    { { 0x00, 0x10, 0x5E }, "SpirentServi", "Spirent plc, Service Assurance Broadband" },
    { { 0x00, 0x10, 0x5F }, "ZodiacData",   "Zodiac Data Systems" },
    { { 0x00, 0x10, 0x60 }, "Billionton",   "Billionton Systems, Inc." },
    { { 0x00, 0x10, 0x61 }, "Hostlink",     "Hostlink Corp." },
    { { 0x00, 0x10, 0x62 }, "NxServerIlnc", "Nx Server, Ilnc." },
    { { 0x00, 0x10, 0x63 }, "StarguideDig", "Starguide Digital Networks" },
    { { 0x00, 0x10, 0x64 }, "Dnpg",         "Dnpg, Llc" },
    { { 0x00, 0x10, 0x65 }, "Radyne",       "Radyne Corporation" },
    { { 0x00, 0x10, 0x66 }, "AdvancedCont", "Advanced Control Systems, Inc." },
    { { 0x00, 0x10, 0x67 }, "Ericsson",     "Ericsson" },
    { { 0x00, 0x10, 0x68 }, "ComosTelecom", "Comos Telecom" },
    { { 0x00, 0x10, 0x69 }, "HeliossCommu", "Helioss Communications, Inc." },
    { { 0x00, 0x10, 0x6A }, "DigitalMicro", "Digital Microwave Corporation" },
    { { 0x00, 0x10, 0x6B }, "SonusNetwork", "Sonus Networks, Inc." },
    { { 0x00, 0x10, 0x6C }, "EDNT",         "EDNT GmbH" },
    { { 0x00, 0x10, 0x6D }, "AxxceleraBro", "Axxcelera Broadband Wireless" },
    { { 0x00, 0x10, 0x6E }, "TadiranCom",   "Tadiran Com. Ltd." },
    { { 0x00, 0x10, 0x6F }, "TrentonTechn", "Trenton Technology Inc." },
    { { 0x00, 0x10, 0x70 }, "CaradonTrend", "Caradon Trend Ltd." },
    { { 0x00, 0x10, 0x71 }, "Advanet",      "Advanet Inc." },
    { { 0x00, 0x10, 0x72 }, "GvnTechnolog", "Gvn Technologies, Inc." },
    { { 0x00, 0x10, 0x73 }, "Technobox",    "Technobox, Inc." },
    { { 0x00, 0x10, 0x74 }, "AtenInternat", "Aten International Co., Ltd." },
    { { 0x00, 0x10, 0x75 }, "SegateTechno", "Segate Technology LLC" },
    { { 0x00, 0x10, 0x76 }, "EUREM",        "EUREM GmbH" },
    { { 0x00, 0x10, 0x77 }, "SafDrive",     "Saf Drive Systems, Ltd." },
    { { 0x00, 0x10, 0x78 }, "NueraCommuni", "Nuera Communications, Inc." },
    { { 0x00, 0x10, 0x79 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x7A }, "AmbiCom",      "AmbiCom, Inc." },
    { { 0x00, 0x10, 0x7B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0x7C }, "PCom",         "P-Com, Inc." },
    { { 0x00, 0x10, 0x7D }, "AuroraCommun", "Aurora Communications, Ltd." },
    { { 0x00, 0x10, 0x7E }, "BACHMANNELEC", "BACHMANN ELECTRONIC GmbH" },
    { { 0x00, 0x10, 0x7F }, "CrestronElec", "Crestron Electronics, Inc." },
    { { 0x00, 0x10, 0x80 }, "MetawaveComm", "Metawave Communications" },
    { { 0x00, 0x10, 0x81 }, "Dps",          "Dps, Inc." },
    { { 0x00, 0x10, 0x82 }, "JnaTelecommu", "Jna Telecommunications Limited" },
    { { 0x00, 0x10, 0x83 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x10, 0x84 }, "KBotCommunic", "K-Bot Communications" },
    { { 0x00, 0x10, 0x85 }, "PolarisCommu", "Polaris Communications, Inc." },
    { { 0x00, 0x10, 0x86 }, "ATTOTechnolo", "ATTO Technology, Inc." },
    { { 0x00, 0x10, 0x87 }, "Xstreamis",    "Xstreamis Plc" },
    { { 0x00, 0x10, 0x88 }, "AmericanNetw", "American Networks Inc." },
    { { 0x00, 0x10, 0x89 }, "WebSonic",     "WebSonic" },
    { { 0x00, 0x10, 0x8A }, "TeraLogic",    "TeraLogic, Inc." },
    { { 0x00, 0x10, 0x8B }, "Laseranimati", "Laseranimation Sollinger Gmbh" },
    { { 0x00, 0x10, 0x8C }, "FujitsuServi", "Fujitsu Services Ltd" },
    { { 0x00, 0x10, 0x8D }, "JohnsonContr", "Johnson Controls, Inc." },
    { { 0x00, 0x10, 0x8E }, "HUGHSYMONSCO", "HUGH SYMONS CONCEPT Technologies Ltd." },
    { { 0x00, 0x10, 0x8F }, "Raptor",       "Raptor Systems" },
    { { 0x00, 0x10, 0x90 }, "Cimetrics",    "Cimetrics, Inc." },
    { { 0x00, 0x10, 0x91 }, "NoWiresNeede", "No Wires Needed Bv" },
    { { 0x00, 0x10, 0x92 }, "Netcore",      "Netcore Inc." },
    { { 0x00, 0x10, 0x93 }, "CmsComputers", "Cms Computers, Ltd." },
    { { 0x00, 0x10, 0x94 }, "PerformanceA", "Performance Analysis Broadband, Spirent plc" },
    { { 0x00, 0x10, 0x95 }, "Thomson",      "Thomson Inc." },
    { { 0x00, 0x10, 0x96 }, "Tracewell",    "Tracewell Systems, Inc." },
    { { 0x00, 0x10, 0x97 }, "WinNetMetrop", "WinNet Metropolitan Communications Systems, Inc." },
    { { 0x00, 0x10, 0x98 }, "StarnetTechn", "Starnet Technologies, Inc." },
    { { 0x00, 0x10, 0x99 }, "InnoMedia",    "InnoMedia, Inc." },
    { { 0x00, 0x10, 0x9A }, "Netline",      "Netline" },
    { { 0x00, 0x10, 0x9B }, "Emulex",       "Emulex Corporation" },
    { { 0x00, 0x10, 0x9C }, "MG",           "MG Co., Ltd." },
    { { 0x00, 0x10, 0x9D }, "Clarinet",     "Clarinet Systems, Inc." },
    { { 0x00, 0x10, 0x9E }, "Aware",        "Aware, Inc." },
    { { 0x00, 0x10, 0x9F }, "Pavo",         "Pavo, Inc." },
    { { 0x00, 0x10, 0xA0 }, "InnovexTechn", "Innovex Technologies, Inc." },
    { { 0x00, 0x10, 0xA1 }, "KendinSemico", "Kendin Semiconductor, Inc." },
    { { 0x00, 0x10, 0xA2 }, "Tns",          "Tns" },
    { { 0x00, 0x10, 0xA3 }, "Omnitronix",   "Omnitronix, Inc." },
    { { 0x00, 0x10, 0xA4 }, "Xircom",       "Xircom" },
    { { 0x00, 0x10, 0xA5 }, "OxfordInstru", "Oxford Instruments" },
    { { 0x00, 0x10, 0xA6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0xA7 }, "UnexTechnolo", "Unex Technology Corporation" },
    { { 0x00, 0x10, 0xA8 }, "RelianceComp", "Reliance Computer Corp." },
    { { 0x00, 0x10, 0xA9 }, "AdhocTechnol", "Adhoc Technologies" },
    { { 0x00, 0x10, 0xAA }, "Media4",       "Media4, Inc." },
    { { 0x00, 0x10, 0xAB }, "KoitoElectri", "Koito Electric Industries, Ltd." },
    { { 0x00, 0x10, 0xAC }, "ImciTechnolo", "Imci Technologies" },
    { { 0x00, 0x10, 0xAD }, "SoftronicsUs", "Softronics Usb, Inc." },
    { { 0x00, 0x10, 0xAE }, "ShinkoElectr", "Shinko Electric Industries Co." },
    { { 0x00, 0x10, 0xAF }, "Tac",          "Tac Systems, Inc." },
    { { 0x00, 0x10, 0xB0 }, "MeridianTech", "Meridian Technology Corp." },
    { { 0x00, 0x10, 0xB1 }, "ForA",         "For-A Co., Ltd." },
    { { 0x00, 0x10, 0xB2 }, "CoactiveAest", "Coactive Aesthetics" },
    { { 0x00, 0x10, 0xB3 }, "NokiaMultime", "Nokia Multimedia Terminals" },
    { { 0x00, 0x10, 0xB4 }, "AtmosphereNe", "Atmosphere Networks" },
    { { 0x00, 0x10, 0xB5 }, "AcctonTechno", "Accton Technology Corp" },
    { { 0x00, 0x10, 0xB6 }, "EntrataCommu", "Entrata Communications Corp." },
    { { 0x00, 0x10, 0xB7 }, "CoyoteTechno", "Coyote Technologies, Llc" },
    { { 0x00, 0x10, 0xB8 }, "IshigakiComp", "Ishigaki Computer System Co." },
    { { 0x00, 0x10, 0xB9 }, "Maxtor",       "Maxtor Corp." },
    { { 0x00, 0x10, 0xBA }, "MartinhoDavi", "Martinho-Davis Systems, Inc." },
    { { 0x00, 0x10, 0xBB }, "DataInformat", "Data & Information Technology" },
    { { 0x00, 0x10, 0xBC }, "AastraTeleco", "Aastra Telecom" },
    { { 0x00, 0x10, 0xBD }, "Telecommunic", "The Telecommunication Technology Committee (Ttc)" },
    { { 0x00, 0x10, 0xBE }, "MarchNetwork", "March Networks Corporation" },
    { { 0x00, 0x10, 0xBF }, "InterAirWire", "InterAir Wireless" },
    { { 0x00, 0x10, 0xC0 }, "ARMA",         "ARMA, Inc." },
    { { 0x00, 0x10, 0xC1 }, "OiElectric",   "Oi Electric Co.,Ltd" },
    { { 0x00, 0x10, 0xC2 }, "Willnet",      "Willnet, Inc." },
    { { 0x00, 0x10, 0xC3 }, "CsiControl",   "Csi-Control Systems" },
    { { 0x00, 0x10, 0xC4 }, "MediaGlobalL", "Media Global Links Co., Ltd." },
    { { 0x00, 0x10, 0xC5 }, "ProtocolTech", "Protocol Technologies, Inc." },
    { { 0x00, 0x10, 0xC6 }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x00, 0x10, 0xC7 }, "DataTransmis", "Data Transmission Network" },
    { { 0x00, 0x10, 0xC8 }, "Communicatio", "Communications Electronics Security Group" },
    { { 0x00, 0x10, 0xC9 }, "MitsubishiEl", "Mitsubishi Electronics Logistic Support Co." },
    { { 0x00, 0x10, 0xCA }, "Telco",        "Telco Systems, Inc." },
    { { 0x00, 0x10, 0xCB }, "Facit",        "Facit K.K." },
    { { 0x00, 0x10, 0xCC }, "CLPCOMPUTERL", "CLP COMPUTER LOGISTIK PLANUNG GmbH" },
    { { 0x00, 0x10, 0xCD }, "InterfaceCon", "Interface Concept" },
    { { 0x00, 0x10, 0xCE }, "Volamp",       "Volamp, Ltd." },
    { { 0x00, 0x10, 0xCF }, "FiberlaneCom", "Fiberlane Communications" },
    { { 0x00, 0x10, 0xD0 }, "Witcom",       "Witcom, Ltd." },
    { { 0x00, 0x10, 0xD1 }, "TopLayerNetw", "Top Layer Networks, Inc." },
    { { 0x00, 0x10, 0xD2 }, "NittoTsushin", "Nitto Tsushinki Co., Ltd" },
    { { 0x00, 0x10, 0xD3 }, "GripsElectro", "Grips Electronic Gmbh" },
    { { 0x00, 0x10, 0xD4 }, "StorageCompu", "Storage Computer Corporation" },
    { { 0x00, 0x10, 0xD5 }, "ImasdeCanari", "Imasde Canarias, S.A." },
    { { 0x00, 0x10, 0xD6 }, "Exelis",       "Exelis" },
    { { 0x00, 0x10, 0xD7 }, "ArgosyResear", "Argosy Research Inc." },
    { { 0x00, 0x10, 0xD8 }, "Calista",      "Calista" },
    { { 0x00, 0x10, 0xD9 }, "IbmJapanFuji", "Ibm Japan, Fujisawa Mt+D" },
    { { 0x00, 0x10, 0xDA }, "Kollmorgen",   "Kollmorgen Corp" },
    { { 0x00, 0x10, 0xDB }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x10, 0xDC }, "MicroStarInt", "Micro-Star International Co., Ltd." },
    { { 0x00, 0x10, 0xDD }, "EnableSemico", "Enable Semiconductor, Inc." },
    { { 0x00, 0x10, 0xDE }, "Internationa", "International Datacasting Corporation" },
    { { 0x00, 0x10, 0xDF }, "RiseComputer", "Rise Computer Inc." },
    { { 0x00, 0x10, 0xE0 }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x10, 0xE1 }, "SITech",       "S.I. Tech, Inc." },
    { { 0x00, 0x10, 0xE2 }, "ArrayComm",    "ArrayComm, Inc." },
    { { 0x00, 0x10, 0xE3 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x10, 0xE4 }, "Nsi",          "Nsi Corporation" },
    { { 0x00, 0x10, 0xE5 }, "SolectronTex", "Solectron Texas" },
    { { 0x00, 0x10, 0xE6 }, "AppliedIntel", "Applied Intelligent Systems, Inc." },
    { { 0x00, 0x10, 0xE7 }, "Breezecom",    "Breezecom, Ltd." },
    { { 0x00, 0x10, 0xE8 }, "Telocity",     "Telocity, Incorporated" },
    { { 0x00, 0x10, 0xE9 }, "Raidtec",      "Raidtec Ltd." },
    { { 0x00, 0x10, 0xEA }, "AdeptTechnol", "Adept Technology" },
    { { 0x00, 0x10, 0xEB }, "Selsius",      "Selsius Systems, Inc." },
    { { 0x00, 0x10, 0xEC }, "EmbeddedPlan", "Embedded Planet" },
    { { 0x00, 0x10, 0xED }, "SundanceTech", "Sundance Technology, Inc." },
    { { 0x00, 0x10, 0xEE }, "CtiProducts",  "Cti Products, Inc." },
    { { 0x00, 0x10, 0xEF }, "Dbtel",        "Dbtel Incorporated" },
    { { 0x00, 0x10, 0xF0 }, "RITTALWERKRU", "RITTAL-WERK RUDOLF LOH GmbH & Co." },
    { { 0x00, 0x10, 0xF1 }, "IO",           "I-O Corporation" },
    { { 0x00, 0x10, 0xF2 }, "Antec",        "Antec" },
    { { 0x00, 0x10, 0xF3 }, "NexcomIntern", "Nexcom International Co., Ltd." },
    { { 0x00, 0x10, 0xF4 }, "VerticalComm", "Vertical Communications" },
    { { 0x00, 0x10, 0xF5 }, "Amherst",      "Amherst Systems, Inc." },
    { { 0x00, 0x10, 0xF6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x10, 0xF7 }, "IRIICHITECHN", "IRIICHI TECHNOLOGIES Inc." },
    { { 0x00, 0x10, 0xF8 }, "TexioTechnol", "Texio Technology Corporation" },
    { { 0x00, 0x10, 0xF9 }, "Unique",       "Unique Systems, Inc." },
    { { 0x00, 0x10, 0xFA }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x10, 0xFB }, "ZidaTechnolo", "Zida Technologies Limited" },
    { { 0x00, 0x10, 0xFC }, "BroadbandNet", "Broadband Networks, Inc." },
    { { 0x00, 0x10, 0xFD }, "Cocom",        "Cocom A/S" },
    { { 0x00, 0x10, 0xFE }, "DigitalEquip", "Digital Equipment Corporation" },
    { { 0x00, 0x10, 0xFF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0x00 }, "SchneiderEle", "Schneider Electric" },
    { { 0x00, 0x11, 0x01 }, "CETTechnolog", "CET Technologies Pte Ltd" },
    { { 0x00, 0x11, 0x02 }, "AuroraMultim", "Aurora Multimedia Corp." },
    { { 0x00, 0x11, 0x03 }, "kawamuraelec", "kawamura electric inc." },
    { { 0x00, 0x11, 0x04 }, "Telexy",       "Telexy" },
    { { 0x00, 0x11, 0x05 }, "SunplusTechn", "Sunplus Technology Co., Ltd." },
    { { 0x00, 0x11, 0x06 }, "Siemens",      "Siemens NV (Belgium)" },
    { { 0x00, 0x11, 0x07 }, "RGBNetworks",  "RGB Networks Inc." },
    { { 0x00, 0x11, 0x08 }, "OrbitalData",  "Orbital Data Corporation" },
    { { 0x00, 0x11, 0x09 }, "MicroStarInt", "Micro-Star International" },
    { { 0x00, 0x11, 0x0A }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x11, 0x0B }, "FranklinTech", "Franklin Technology Systems" },
    { { 0x00, 0x11, 0x0C }, "AtmarkTechno", "Atmark Techno, Inc." },
    { { 0x00, 0x11, 0x0D }, "SANBlazeTech", "SANBlaze Technology, Inc." },
    { { 0x00, 0x11, 0x0E }, "TsurusakiSea", "Tsurusaki Sealand Transportation Co. Ltd." },
    { { 0x00, 0x11, 0x0F }, "netplat",      "netplat,Inc." },
    { { 0x00, 0x11, 0x10 }, "MaxannaTechn", "Maxanna Technology Co., Ltd." },
    { { 0x00, 0x11, 0x11 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x11, 0x12 }, "HoneywellCMS", "Honeywell CMSS" },
    { { 0x00, 0x11, 0x13 }, "FraunhoferFO", "Fraunhofer FOKUS" },
    { { 0x00, 0x11, 0x14 }, "EverFocusEle", "EverFocus Electronics Corp." },
    { { 0x00, 0x11, 0x15 }, "EPINTechnolo", "EPIN Technologies, Inc." },
    { { 0x00, 0x11, 0x16 }, "CoteauVert",   "Coteau Vert Co., Ltd." },
    { { 0x00, 0x11, 0x17 }, "Cesnet",       "Cesnet" },
    { { 0x00, 0x11, 0x18 }, "BLXICDesign",  "BLX IC Design Corp., Ltd." },
    { { 0x00, 0x11, 0x19 }, "Solteras",     "Solteras, Inc." },
    { { 0x00, 0x11, 0x1A }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x11, 0x1B }, "TargaDivL3Co", "Targa Systems Div L-3 Communications" },
    { { 0x00, 0x11, 0x1C }, "PleoraTechno", "Pleora Technologies Inc." },
    { { 0x00, 0x11, 0x1D }, "Hectrix",      "Hectrix Limited" },
    { { 0x00, 0x11, 0x1E }, "ETHERNETPowe", "ETHERNET Powerlink Standarization Group (EPSG)" },
    { { 0x00, 0x11, 0x1F }, "DoremiLabs",   "Doremi Labs, Inc." },
    { { 0x00, 0x11, 0x20 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0x21 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0x22 }, "CIMSYS",       "CIMSYS Inc" },
    { { 0x00, 0x11, 0x23 }, "Appointech",   "Appointech, Inc." },
    { { 0x00, 0x11, 0x24 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x11, 0x25 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x11, 0x26 }, "Venstar",      "Venstar Inc." },
    { { 0x00, 0x11, 0x27 }, "TASI",         "TASI, Inc" },
    { { 0x00, 0x11, 0x28 }, "Streamit",     "Streamit" },
    { { 0x00, 0x11, 0x29 }, "ParadiseData", "Paradise Datacom Ltd." },
    { { 0x00, 0x11, 0x2A }, "Niko",         "Niko NV" },
    { { 0x00, 0x11, 0x2B }, "NetModule",    "NetModule AG" },
    { { 0x00, 0x11, 0x2C }, "IZT",          "IZT GmbH" },
    { { 0x00, 0x11, 0x2D }, "iPulse",       "iPulse Systems" },
    { { 0x00, 0x11, 0x2E }, "Ceicom",       "Ceicom" },
    { { 0x00, 0x11, 0x2F }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x11, 0x30 }, "AlliedTelesi", "Allied Telesis (Hong Kong) Ltd." },
    { { 0x00, 0x11, 0x31 }, "Unatech",      "Unatech. Co.,Ltd" },
    { { 0x00, 0x11, 0x32 }, "Synology",     "Synology Incorporated" },
    { { 0x00, 0x11, 0x33 }, "SiemensAustr", "Siemens AG Austria" },
    { { 0x00, 0x11, 0x34 }, "MediaCell",    "MediaCell, Inc." },
    { { 0x00, 0x11, 0x35 }, "Grandeye",     "Grandeye Ltd" },
    { { 0x00, 0x11, 0x36 }, "GoodrichSens", "Goodrich Sensor Systems" },
    { { 0x00, 0x11, 0x37 }, "AichiElectri", "Aichi Electric Co., Ltd." },
    { { 0x00, 0x11, 0x38 }, "Taishin",      "Taishin Co., Ltd." },
    { { 0x00, 0x11, 0x39 }, "STOEBERANTRI", "STOEBER ANTRIEBSTECHNIK GmbH + Co. KG." },
    { { 0x00, 0x11, 0x3A }, "Shinboram",    "Shinboram" },
    { { 0x00, 0x11, 0x3B }, "MicronetComm", "Micronet Communications Inc." },
    { { 0x00, 0x11, 0x3C }, "Micronas",     "Micronas GmbH" },
    { { 0x00, 0x11, 0x3D }, "KnSoltec",     "Kn Soltec Co.,Ltd." },
    { { 0x00, 0x11, 0x3E }, "JL",           "JL Corporation" },
    { { 0x00, 0x11, 0x3F }, "AlcatelDI",    "Alcatel DI" },
    { { 0x00, 0x11, 0x40 }, "Nanometrics",  "Nanometrics Inc." },
    { { 0x00, 0x11, 0x41 }, "GoodMan",      "GoodMan Corporation" },
    { { 0x00, 0x11, 0x42 }, "eSMARTCOM",    "e-SMARTCOM INC." },
    { { 0x00, 0x11, 0x43 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x11, 0x44 }, "AssuranceTec", "Assurance Technology Corp" },
    { { 0x00, 0x11, 0x45 }, "ValuePointNe", "ValuePoint Networks" },
    { { 0x00, 0x11, 0x46 }, "TelecardPrib", "Telecard-Pribor Ltd" },
    { { 0x00, 0x11, 0x47 }, "SecomIndustr", "Secom-Industry co.LTD." },
    { { 0x00, 0x11, 0x48 }, "ProlonContro", "Prolon Control Systems" },
    { { 0x00, 0x11, 0x49 }, "Proliphix",    "Proliphix Inc." },
    { { 0x00, 0x11, 0x4A }, "KAYABAINDUST", "KAYABA INDUSTRY Co,.Ltd." },
    { { 0x00, 0x11, 0x4B }, "FrancotypPos", "Francotyp-Postalia GmbH" },
    { { 0x00, 0x11, 0x4C }, "caffeinaappl", "caffeina applied research ltd." },
    { { 0x00, 0x11, 0x4D }, "AtsumiElectr", "Atsumi Electric Co.,LTD." },
    { { 0x00, 0x11, 0x4E }, "690885Ontari", "690885 Ontario Inc." },
    { { 0x00, 0x11, 0x4F }, "USDigitalTel", "US Digital Television, Inc" },
    { { 0x00, 0x11, 0x50 }, "Belkin",       "Belkin Corporation" },
    { { 0x00, 0x11, 0x51 }, "Mykotronx",    "Mykotronx" },
    { { 0x00, 0x11, 0x52 }, "EidsvollElec", "Eidsvoll Electronics AS" },
    { { 0x00, 0x11, 0x53 }, "TridentTek",   "Trident Tek, Inc." },
    { { 0x00, 0x11, 0x54 }, "WebproTechno", "Webpro Technologies Inc." },
    { { 0x00, 0x11, 0x55 }, "Sevis",        "Sevis Systems" },
    { { 0x00, 0x11, 0x56 }, "PharosNZ",     "Pharos Systems NZ" },
    { { 0x00, 0x11, 0x57 }, "OkiElectricI", "Oki Electric Industry Co., Ltd." },
    { { 0x00, 0x11, 0x58 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x11, 0x59 }, "MatisseNetwo", "Matisse Networks Inc" },
    { { 0x00, 0x11, 0x5A }, "IvoclarVivad", "Ivoclar Vivadent AG" },
    { { 0x00, 0x11, 0x5B }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x11, 0x5C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0x5D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0x5E }, "ProMinentDos", "ProMinent Dosiertechnik GmbH" },
    { { 0x00, 0x11, 0x5F }, "ITXSecurity",  "ITX Security Co., Ltd." },
    { { 0x00, 0x11, 0x60 }, "ARTDIO",       "ARTDIO Company Co., LTD" },
    { { 0x00, 0x11, 0x61 }, "NetStreams",   "NetStreams, LLC" },
    { { 0x00, 0x11, 0x62 }, "StarMicronic", "Star Micronics Co.,Ltd." },
    { { 0x00, 0x11, 0x63 }, "SystemDeptEl", "System Spa Dept. Electronics" },
    { { 0x00, 0x11, 0x64 }, "ACARDTechnol", "ACARD Technology Corp." },
    { { 0x00, 0x11, 0x65 }, "ZNYXNetworks", "ZNYX Networks, Inc." },
    { { 0x00, 0x11, 0x66 }, "TaelimElectr", "Taelim Electronics Co., Ltd." },
    { { 0x00, 0x11, 0x67 }, "IntegratedSy", "Integrated System Solution Corp." },
    { { 0x00, 0x11, 0x68 }, "HomeLogic",    "HomeLogic LLC" },
    { { 0x00, 0x11, 0x69 }, "EMSSatcom",    "EMS Satcom" },
    { { 0x00, 0x11, 0x6A }, "Domo",         "Domo Ltd" },
    { { 0x00, 0x11, 0x6B }, "DigitalDataC", "Digital Data Communications Asia Co.,Ltd" },
    { { 0x00, 0x11, 0x6C }, "NanwangMulti", "Nanwang Multimedia Inc.,Ltd" },
    { { 0x00, 0x11, 0x6D }, "AmericanTime", "American Time and Signal" },
    { { 0x00, 0x11, 0x6E }, "PeplinkInter", "Peplink International Ltd." },
    { { 0x00, 0x11, 0x6F }, "Netforyou",    "Netforyou Co., LTD." },
    { { 0x00, 0x11, 0x70 }, "Gsc",          "Gsc Srl" },
    { { 0x00, 0x11, 0x71 }, "DEXTERCommun", "DEXTER Communications, Inc." },
    { { 0x00, 0x11, 0x72 }, "Cotron",       "Cotron Corporation" },
    { { 0x00, 0x11, 0x73 }, "SMARTStorage", "SMART Storage Systems" },
    { { 0x00, 0x11, 0x74 }, "MojoNetworks", "Mojo Networks, Inc." },
    { { 0x00, 0x11, 0x75 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x11, 0x76 }, "Intellambda",  "Intellambda Systems, Inc." },
    { { 0x00, 0x11, 0x77 }, "CoaxialNetwo", "Coaxial Networks, Inc." },
    { { 0x00, 0x11, 0x78 }, "ChironTechno", "Chiron Technology Ltd" },
    { { 0x00, 0x11, 0x79 }, "SingularTech", "Singular Technology Co. Ltd." },
    { { 0x00, 0x11, 0x7A }, "SingimIntern", "Singim International Corp." },
    { { 0x00, 0x11, 0x7B }, "BüchiLaborte", "Büchi Labortechnik AG" },
    { { 0x00, 0x11, 0x7C }, "ezynet",       "e-zy.net" },
    { { 0x00, 0x11, 0x7D }, "ZMDAmerica",   "ZMD America, Inc." },
    { { 0x00, 0x11, 0x7E }, "Midmark",      "Midmark Corp" },
    { { 0x00, 0x11, 0x7F }, "NeotuneInfor", "Neotune Information Technology Corporation,.LTD" },
    { { 0x00, 0x11, 0x80 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x11, 0x81 }, "InterEnergy",  "InterEnergy Co.Ltd," },
    { { 0x00, 0x11, 0x82 }, "IMINorgren",   "IMI Norgren Ltd" },
    { { 0x00, 0x11, 0x83 }, "DatalogicADC", "Datalogic ADC, Inc." },
    { { 0x00, 0x11, 0x84 }, "HumoLaborato", "Humo Laboratory,Ltd." },
    { { 0x00, 0x11, 0x85 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x11, 0x86 }, "Prime",        "Prime Systems, Inc." },
    { { 0x00, 0x11, 0x87 }, "CategorySolu", "Category Solutions, Inc" },
    { { 0x00, 0x11, 0x88 }, "Enterasys",    "Enterasys" },
    { { 0x00, 0x11, 0x89 }, "Aerotech",     "Aerotech Inc" },
    { { 0x00, 0x11, 0x8A }, "ViewtranTech", "Viewtran Technology Limited" },
    { { 0x00, 0x11, 0x8B }, "AlcatelLucen", "Alcatel-Lucent Enterprise" },
    { { 0x00, 0x11, 0x8C }, "MissouriDepa", "Missouri Department of Transportation" },
    { { 0x00, 0x11, 0x8D }, "HanchangSyst", "Hanchang System Corp." },
    { { 0x00, 0x11, 0x8E }, "HalytechMace", "Halytech Mace" },
    { { 0x00, 0x11, 0x8F }, "EutechInstru", "Eutech Instruments Pte. Ltd." },
    { { 0x00, 0x11, 0x90 }, "DigitalDesig", "Digital Design Corporation" },
    { { 0x00, 0x11, 0x91 }, "CTSClimaTemp", "CTS-Clima Temperatur Systeme GmbH" },
    { { 0x00, 0x11, 0x92 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0x93 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0x94 }, "ChiMeiCommun", "Chi Mei Communication Systems, Inc." },
    { { 0x00, 0x11, 0x95 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x11, 0x96 }, "Actuality",    "Actuality Systems, Inc." },
    { { 0x00, 0x11, 0x97 }, "MonitoringTe", "Monitoring Technologies Limited" },
    { { 0x00, 0x11, 0x98 }, "PrismMediaPr", "Prism Media Products Limited" },
    { { 0x00, 0x11, 0x99 }, "2wcom",        "2wcom Systems GmbH" },
    { { 0x00, 0x11, 0x9A }, "Alkeria",      "Alkeria srl" },
    { { 0x00, 0x11, 0x9B }, "TelesynergyR", "Telesynergy Research Inc." },
    { { 0x00, 0x11, 0x9C }, "EP&TEnergy",   "EP&T Energy" },
    { { 0x00, 0x11, 0x9D }, "DiginfoTechn", "Diginfo Technology Corporation" },
    { { 0x00, 0x11, 0x9E }, "SolectronBra", "Solectron Brazil" },
    { { 0x00, 0x11, 0x9F }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x11, 0xA0 }, "VtechEnginee", "Vtech Engineering Canada Ltd" },
    { { 0x00, 0x11, 0xA1 }, "VisionNetwar", "Vision Netware Co.,Ltd" },
    { { 0x00, 0x11, 0xA2 }, "Manufacturin", "Manufacturing Technology Inc" },
    { { 0x00, 0x11, 0xA3 }, "LanReadyTech", "LanReady Technologies Inc." },
    { { 0x00, 0x11, 0xA4 }, "JStreamTechn", "JStream Technologies Inc." },
    { { 0x00, 0x11, 0xA5 }, "FortunaElect", "Fortuna Electronic Corp." },
    { { 0x00, 0x11, 0xA6 }, "SypixxNetwor", "Sypixx Networks" },
    { { 0x00, 0x11, 0xA7 }, "InfilcoDegre", "Infilco Degremont Inc." },
    { { 0x00, 0x11, 0xA8 }, "QuestTechnol", "Quest Technologies" },
    { { 0x00, 0x11, 0xA9 }, "Nurivoice",    "Nurivoice Co., Ltd" },
    { { 0x00, 0x11, 0xAA }, "UniclassTech", "Uniclass Technology, Co., LTD" },
    { { 0x00, 0x11, 0xAB }, "TrustableTec", "Trustable Technology Co.,Ltd." },
    { { 0x00, 0x11, 0xAC }, "SimtecElectr", "Simtec Electronics" },
    { { 0x00, 0x11, 0xAD }, "RuijieTechno", "Shanghai Ruijie Technology" },
    { { 0x00, 0x11, 0xAE }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x11, 0xAF }, "Medialinki",   "Medialink-i,Inc" },
    { { 0x00, 0x11, 0xB0 }, "Fortelink",    "Fortelink Inc." },
    { { 0x00, 0x11, 0xB1 }, "BlueExpertTe", "BlueExpert Technology Corp." },
    { { 0x00, 0x11, 0xB2 }, "2001Technolo", "2001 Technology Inc." },
    { { 0x00, 0x11, 0xB3 }, "Yoshimiya",    "Yoshimiya Co.,Ltd." },
    { { 0x00, 0x11, 0xB4 }, "WestermoNetw", "Westermo Network Technologies AB" },
    { { 0x00, 0x11, 0xB5 }, "Powercom",     "Shenzhen Powercom Co.,Ltd" },
    { { 0x00, 0x11, 0xB6 }, "OpenInternat", "Open Systems International" },
    { { 0x00, 0x11, 0xB7 }, "Octalix",      "Octalix B.V." },
    { { 0x00, 0x11, 0xB8 }, "LiebherrElek", "Liebherr - Elektronik GmbH" },
    { { 0x00, 0x11, 0xB9 }, "InnerRange",   "Inner Range Pty. Ltd." },
    { { 0x00, 0x11, 0xBA }, "Elexol",       "Elexol Pty Ltd" },
    { { 0x00, 0x11, 0xBB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0xBC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x11, 0xBD }, "BombardierTr", "Bombardier Transportation" },
    { { 0x00, 0x11, 0xBE }, "AGPTelecom",   "AGP Telecom Co. Ltd" },
    { { 0x00, 0x11, 0xBF }, "AESYS",        "AESYS S.p.A." },
    { { 0x00, 0x11, 0xC0 }, "AdayTechnolo", "Aday Technology Inc" },
    { { 0x00, 0x11, 0xC1 }, "4PMobileData", "4P Mobile Data Processing" },
    { { 0x00, 0x11, 0xC2 }, "UnitedFiberO", "United Fiber Optic Communication" },
    { { 0x00, 0x11, 0xC3 }, "Transceiving", "Transceiving System Technology Corporation" },
    { { 0x00, 0x11, 0xC4 }, "Terminalesde", "Terminales de Telecomunicacion Terrestre, S.L." },
    { { 0x00, 0x11, 0xC5 }, "TENTechnolog", "TEN Technology" },
    { { 0x00, 0x11, 0xC6 }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x11, 0xC7 }, "RaymarineUK",  "Raymarine UK Ltd" },
    { { 0x00, 0x11, 0xC8 }, "Powercom",     "Powercom Co., Ltd." },
    { { 0x00, 0x11, 0xC9 }, "MTT",          "MTT Corporation" },
    { { 0x00, 0x11, 0xCA }, "LongRange",    "Long Range Systems, Inc." },
    { { 0x00, 0x11, 0xCB }, "Jacobsons",    "Jacobsons AB" },
    { { 0x00, 0x11, 0xCC }, "GuangzhouJin", "Guangzhou Jinpeng Group Co.,Ltd." },
    { { 0x00, 0x11, 0xCD }, "AxsunTechnol", "Axsun Technologies" },
    { { 0x00, 0x11, 0xCE }, "Ubisense",     "Ubisense Limited" },
    { { 0x00, 0x11, 0xCF }, "ThraneThrane", "Thrane & Thrane A/S" },
    { { 0x00, 0x11, 0xD0 }, "TandbergData", "Tandberg Data ASA" },
    { { 0x00, 0x11, 0xD1 }, "SoftImagingS", "Soft Imaging System GmbH" },
    { { 0x00, 0x11, 0xD2 }, "PerceptionDi", "Perception Digital Ltd" },
    { { 0x00, 0x11, 0xD3 }, "NextGenTelAS", "NextGenTel Holding ASA" },
    { { 0x00, 0x11, 0xD4 }, "NetEnrich",    "NetEnrich, Inc" },
    { { 0x00, 0x11, 0xD5 }, "SunyardSyste", "Hangzhou Sunyard System Engineering Co.,Ltd." },
    { { 0x00, 0x11, 0xD6 }, "HandEra",      "HandEra, Inc." },
    { { 0x00, 0x11, 0xD7 }, "eWerks",       "eWerks Inc" },
    { { 0x00, 0x11, 0xD8 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x11, 0xD9 }, "TiVo",         "TiVo" },
    { { 0x00, 0x11, 0xDA }, "VivaasTechno", "Vivaas Technology Inc." },
    { { 0x00, 0x11, 0xDB }, "LandCellular", "Land-Cellular Corporation" },
    { { 0x00, 0x11, 0xDC }, "GlunzJensen",  "Glunz & Jensen" },
    { { 0x00, 0x11, 0xDD }, "FROMUSTEC",    "FROMUS TEC. Co., Ltd." },
    { { 0x00, 0x11, 0xDE }, "Eurilogic",    "Eurilogic" },
    { { 0x00, 0x11, 0xDF }, "CurrentEnerg", "Current Energy" },
    { { 0x00, 0x11, 0xE0 }, "UMEDIACommun", "U-MEDIA Communications, Inc." },
    { { 0x00, 0x11, 0xE1 }, "Arcelik",      "Arcelik A.S" },
    { { 0x00, 0x11, 0xE2 }, "HuaJungCompo", "Hua Jung Components Co., Ltd." },
    { { 0x00, 0x11, 0xE3 }, "Thomson",      "Thomson, Inc." },
    { { 0x00, 0x11, 0xE4 }, "DanelecElect", "Danelec Electronics A/S" },
    { { 0x00, 0x11, 0xE5 }, "KCodes",       "KCodes Corporation" },
    { { 0x00, 0x11, 0xE6 }, "ScientificAt", "Scientific Atlanta" },
    { { 0x00, 0x11, 0xE7 }, "WORLDSATTexa", "WORLDSAT - Texas de France" },
    { { 0x00, 0x11, 0xE8 }, "TixiCom",      "Tixi.Com" },
    { { 0x00, 0x11, 0xE9 }, "Starnex",      "Starnex Co., Ltd." },
    { { 0x00, 0x11, 0xEA }, "IWICS",        "IWICS Inc." },
    { { 0x00, 0x11, 0xEB }, "InnovativeIn", "Innovative Integration" },
    { { 0x00, 0x11, 0xEC }, "Avix",         "Avix Inc." },
    { { 0x00, 0x11, 0xED }, "802Global",    "802 Global" },
    { { 0x00, 0x11, 0xEE }, "Estari",       "Estari, Inc." },
    { { 0x00, 0x11, 0xEF }, "ConitecDaten", "Conitec Datensysteme GmbH" },
    { { 0x00, 0x11, 0xF0 }, "Wideful",      "Wideful Limited" },
    { { 0x00, 0x11, 0xF1 }, "QinetiQ",      "QinetiQ Ltd" },
    { { 0x00, 0x11, 0xF2 }, "InstituteNet", "Institute of Network Technologies" },
    { { 0x00, 0x11, 0xF3 }, "NeoMediaEuro", "NeoMedia Europe AG" },
    { { 0x00, 0x11, 0xF4 }, "woorinet",     "woori-net" },
    { { 0x00, 0x11, 0xF5 }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x00, 0x11, 0xF6 }, "AsiaPacificM", "Asia Pacific Microsystems , Inc." },
    { { 0x00, 0x11, 0xF7 }, "ForwardIndus", "Shenzhen Forward Industry Co., Ltd" },
    { { 0x00, 0x11, 0xF8 }, "AIRAYA",       "AIRAYA Corp" },
    { { 0x00, 0x11, 0xF9 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x11, 0xFA }, "Rane",         "Rane Corporation" },
    { { 0x00, 0x11, 0xFB }, "HeidelbergEn", "Heidelberg Engineering GmbH" },
    { { 0x00, 0x11, 0xFC }, "HARTINGElect", "HARTING Electronics GmbH" },
    { { 0x00, 0x11, 0xFD }, "Korg",         "Korg Inc." },
    { { 0x00, 0x11, 0xFE }, "KeiyoSystemR", "Keiyo System Research, Inc." },
    { { 0x00, 0x11, 0xFF }, "DigitroTecno", "Digitro Tecnologia Ltda" },
    { { 0x00, 0x12, 0x00 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0x01 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0x02 }, "DecraneAeros", "Decrane Aerospace - Audio International Inc." },
    { { 0x00, 0x12, 0x03 }, "ActivNetwork", "ActivNetworks" },
    { { 0x00, 0x12, 0x04 }, "u10Networks",  "u10 Networks, Inc." },
    { { 0x00, 0x12, 0x05 }, "TerrasatComm", "Terrasat Communications, Inc." },
    { { 0x00, 0x12, 0x06 }, "iQuest",       "iQuest (NZ) Ltd" },
    { { 0x00, 0x12, 0x07 }, "HeadStrongIn", "Head Strong International Limited" },
    { { 0x00, 0x12, 0x08 }, "GantnerInstr", "Gantner Instruments GmbH" },
    { { 0x00, 0x12, 0x09 }, "Fastrax",      "Fastrax Ltd" },
    { { 0x00, 0x12, 0x0A }, "EmersonClima", "Emerson Climate Technologies GmbH" },
    { { 0x00, 0x12, 0x0B }, "ChinasysTech", "Chinasys Technologies Limited" },
    { { 0x00, 0x12, 0x0C }, "CEInfosysPte", "CE-Infosys Pte Ltd" },
    { { 0x00, 0x12, 0x0D }, "AdvancedTele", "Advanced Telecommunication Technologies, Inc." },
    { { 0x00, 0x12, 0x0E }, "AboCom",       "AboCom" },
    { { 0x00, 0x12, 0x0F }, "Ieee8023",     "Ieee 802.3" },
    { { 0x00, 0x12, 0x10 }, "WideRay",      "WideRay Corp" },
    { { 0x00, 0x12, 0x11 }, "ProtechnaHer", "Protechna Herbst GmbH & Co. KG" },
    { { 0x00, 0x12, 0x12 }, "PLUS",         "PLUS Corporation" },
    { { 0x00, 0x12, 0x13 }, "Metrohm",      "Metrohm AG" },
    { { 0x00, 0x12, 0x14 }, "KoenigBauer",  "Koenig & Bauer AG" },
    { { 0x00, 0x12, 0x15 }, "iStorNetwork", "iStor Networks, Inc." },
    { { 0x00, 0x12, 0x16 }, "ICPInternetC", "ICP Internet Communication Payment AG" },
    { { 0x00, 0x12, 0x17 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x12, 0x18 }, "ARUZE",        "ARUZE Corporation" },
    { { 0x00, 0x12, 0x19 }, "GeneralDatac", "General Datacomm LLC" },
    { { 0x00, 0x12, 0x1A }, "TechnoSoftSy", "Techno Soft Systemnics Inc." },
    { { 0x00, 0x12, 0x1B }, "SoundDevices", "Sound Devices, LLC" },
    { { 0x00, 0x12, 0x1C }, "Parrot",       "Parrot Sa" },
    { { 0x00, 0x12, 0x1D }, "Netfabric",    "Netfabric Corporation" },
    { { 0x00, 0x12, 0x1E }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x12, 0x1F }, "HardingInstr", "Harding Instruments" },
    { { 0x00, 0x12, 0x20 }, "Cadco",        "Cadco Systems" },
    { { 0x00, 0x12, 0x21 }, "BBraunMelsun", "B.Braun Melsungen AG" },
    { { 0x00, 0x12, 0x22 }, "Skardin",      "Skardin (UK) Ltd" },
    { { 0x00, 0x12, 0x23 }, "Pixim",        "Pixim" },
    { { 0x00, 0x12, 0x24 }, "NexQL",        "NexQL Corporation" },
    { { 0x00, 0x12, 0x25 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x12, 0x26 }, "JapanDirex",   "Japan Direx Corporation" },
    { { 0x00, 0x12, 0x27 }, "FranklinElec", "Franklin Electric Co., Inc." },
    { { 0x00, 0x12, 0x28 }, "Data",         "Data Ltd." },
    { { 0x00, 0x12, 0x29 }, "BroadEasyTec", "BroadEasy Technologies Co.,Ltd" },
    { { 0x00, 0x12, 0x2A }, "VTechTelecom", "VTech Telecommunications Ltd." },
    { { 0x00, 0x12, 0x2B }, "Virbiage",     "Virbiage Pty Ltd" },
    { { 0x00, 0x12, 0x2C }, "SoenenContro", "Soenen Controls N.V." },
    { { 0x00, 0x12, 0x2D }, "SiNett",       "SiNett Corporation" },
    { { 0x00, 0x12, 0x2E }, "SignalTechno", "Signal Technology - AISD" },
    { { 0x00, 0x12, 0x2F }, "SaneiElectri", "Sanei Electric Inc." },
    { { 0x00, 0x12, 0x30 }, "PicasoInfoco", "Picaso Infocommunication CO., LTD." },
    { { 0x00, 0x12, 0x31 }, "MotionContro", "Motion Control Systems, Inc." },
    { { 0x00, 0x12, 0x32 }, "LeWizCommuni", "LeWiz Communications Inc." },
    { { 0x00, 0x12, 0x33 }, "JRCTOKKI",     "JRC TOKKI Co.,Ltd." },
    { { 0x00, 0x12, 0x34 }, "CamilleBauer", "Camille Bauer" },
    { { 0x00, 0x12, 0x35 }, "Andrew",       "Andrew Corporation" },
    { { 0x00, 0x12, 0x36 }, "ConSentryNet", "ConSentry Networks" },
    { { 0x00, 0x12, 0x37 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x12, 0x38 }, "SetaBoxTechn", "SetaBox Technology Co., Ltd." },
    { { 0x00, 0x12, 0x39 }, "SNet",         "S Net Systems Inc." },
    { { 0x00, 0x12, 0x3A }, "Posystech",    "Posystech Inc., Co." },
    { { 0x00, 0x12, 0x3B }, "KeRoApS",      "KeRo Systems ApS" },
    { { 0x00, 0x12, 0x3C }, "SecondRule",   "Second Rule LLC" },
    { { 0x00, 0x12, 0x3D }, "GES",          "GES Co, Ltd" },
    { { 0x00, 0x12, 0x3E }, "ERUNEtechnol", "ERUNE technology Co., Ltd." },
    { { 0x00, 0x12, 0x3F }, "Dell",         "Dell Inc." },
    { { 0x00, 0x12, 0x40 }, "AmoiElectron", "Amoi Electronics Co.,Ltd" },
    { { 0x00, 0x12, 0x41 }, "a2imarketing", "a2i marketing center" },
    { { 0x00, 0x12, 0x42 }, "MillennialNe", "Millennial Net" },
    { { 0x00, 0x12, 0x43 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0x44 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0x45 }, "ZellwegerAna", "Zellweger Analytics, Inc." },
    { { 0x00, 0x12, 0x46 }, "TOMTechnolog", "T.O.M Technology Inc.." },
    { { 0x00, 0x12, 0x47 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x12, 0x48 }, "DellEMC",      "Dell EMC" },
    { { 0x00, 0x12, 0x49 }, "DeltaElettro", "Delta Elettronica S.p.A." },
    { { 0x00, 0x12, 0x4A }, "DedicatedDev", "Dedicated Devices, Inc." },
    { { 0x00, 0x12, 0x4B }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x12, 0x4C }, "BBWM",         "BBWM Corporation" },
    { { 0x00, 0x12, 0x4D }, "Inducon",      "Inducon BV" },
    { { 0x00, 0x12, 0x4E }, "XacAutomatio", "Xac Automation Corp." },
    { { 0x00, 0x12, 0x4F }, "nVent",        "nVent" },
    { { 0x00, 0x12, 0x50 }, "TokyoAircaft", "Tokyo Aircaft Instrument Co., Ltd." },
    { { 0x00, 0x12, 0x51 }, "Silink",       "Silink" },
    { { 0x00, 0x12, 0x52 }, "Citronix",     "Citronix, LLC" },
    { { 0x00, 0x12, 0x53 }, "AudioDev",     "AudioDev AB" },
    { { 0x00, 0x12, 0x54 }, "SpectraTechn", "Spectra Technologies Holdings Company Ltd" },
    { { 0x00, 0x12, 0x55 }, "NetEffect",    "NetEffect Incorporated" },
    { { 0x00, 0x12, 0x56 }, "LgInformatio", "Lg Information & Comm." },
    { { 0x00, 0x12, 0x57 }, "LeapCommComm", "LeapComm Communication Technologies Inc." },
    { { 0x00, 0x12, 0x58 }, "TechVoIPSp",   "TechVoIP Sp z o.o." },
    { { 0x00, 0x12, 0x59 }, "ThermoElectr", "Thermo Electron Karlsruhe" },
    { { 0x00, 0x12, 0x5A }, "Microsoft",    "Microsoft Corporation" },
    { { 0x00, 0x12, 0x5B }, "KaimeiElectr", "Kaimei Electroni" },
    { { 0x00, 0x12, 0x5C }, "GreenHillsSo", "Green Hills Software, Inc." },
    { { 0x00, 0x12, 0x5D }, "CyberNet",     "CyberNet Inc." },
    { { 0x00, 0x12, 0x5E }, "Caen",         "Caen" },
    { { 0x00, 0x12, 0x5F }, "AWIND",        "AWIND Inc." },
    { { 0x00, 0x12, 0x60 }, "StantonMagne", "Stanton Magnetics,inc." },
    { { 0x00, 0x12, 0x61 }, "Adaptix",      "Adaptix, Inc" },
    { { 0x00, 0x12, 0x62 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x12, 0x63 }, "DataVoiceTec", "Data Voice Technologies GmbH" },
    { { 0x00, 0x12, 0x64 }, "daumelectron", "daum electronic gmbh" },
    { { 0x00, 0x12, 0x65 }, "EnerdyneTech", "Enerdyne Technologies, Inc." },
    { { 0x00, 0x12, 0x66 }, "SwisscomHosp", "Swisscom Hospitality Services SA" },
    { { 0x00, 0x12, 0x67 }, "Panasonic",    "Panasonic Corporation" },
    { { 0x00, 0x12, 0x68 }, "IPSdoo",       "IPS d.o.o." },
    { { 0x00, 0x12, 0x69 }, "ValueElectro", "Value Electronics" },
    { { 0x00, 0x12, 0x6A }, "OPTOELECTRON", "OPTOELECTRONICS Co., Ltd." },
    { { 0x00, 0x12, 0x6B }, "AscaladeComm", "Ascalade Communications Limited" },
    { { 0x00, 0x12, 0x6C }, "VisonicTechn", "Visonic Technologies 1993 Ltd." },
    { { 0x00, 0x12, 0x6D }, "UniversityCa", "University of California, Berkeley" },
    { { 0x00, 0x12, 0x6E }, "SeidelElektr", "Seidel Elektronik GmbH Nfg.KG" },
    { { 0x00, 0x12, 0x6F }, "RaysonTechno", "Rayson Technology Co., Ltd." },
    { { 0x00, 0x12, 0x70 }, "NGESDenro",    "NGES Denro Systems" },
    { { 0x00, 0x12, 0x71 }, "MeasurementC", "Measurement Computing Corp" },
    { { 0x00, 0x12, 0x72 }, "ReduxCommuni", "Redux Communications Ltd." },
    { { 0x00, 0x12, 0x73 }, "Stoke",        "Stoke Inc" },
    { { 0x00, 0x12, 0x74 }, "NITlab",       "NIT lab" },
    { { 0x00, 0x12, 0x75 }, "Sentilla",     "Sentilla Corporation" },
    { { 0x00, 0x12, 0x76 }, "CGPowerIrela", "CG Power Systems Ireland Limited" },
    { { 0x00, 0x12, 0x77 }, "BeijerElectr", "Beijer Electronics Corp." },
    { { 0x00, 0x12, 0x78 }, "Internationa", "International Bar Code" },
    { { 0x00, 0x12, 0x79 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x12, 0x7A }, "SanyuIndustr", "Sanyu Industry Co.,Ltd." },
    { { 0x00, 0x12, 0x7B }, "VIANetworkin", "VIA Networking Technologies, Inc." },
    { { 0x00, 0x12, 0x7C }, "Swegon",       "Swegon Ab" },
    { { 0x00, 0x12, 0x7D }, "MobileAria",   "MobileAria" },
    { { 0x00, 0x12, 0x7E }, "DigitalLifes", "Digital Lifestyles Group, Inc." },
    { { 0x00, 0x12, 0x7F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0x80 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0x81 }, "MarchNetwork", "March Networks S.p.A." },
    { { 0x00, 0x12, 0x82 }, "Qovia",        "Qovia" },
    { { 0x00, 0x12, 0x83 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x12, 0x84 }, "Lab33",        "Lab33 Srl" },
    { { 0x00, 0x12, 0x85 }, "GizmondoEuro", "Gizmondo Europe Ltd" },
    { { 0x00, 0x12, 0x86 }, "Endevco",      "Endevco Corp" },
    { { 0x00, 0x12, 0x87 }, "DigitalEvery", "Digital Everywhere Unterhaltungselektronik GmbH" },
    { { 0x00, 0x12, 0x88 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x12, 0x89 }, "AdvanceSteri", "Advance Sterilization Products" },
    { { 0x00, 0x12, 0x8A }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x12, 0x8B }, "SensoryNetwo", "Sensory Networks Inc" },
    { { 0x00, 0x12, 0x8C }, "WoodwardGove", "Woodward Governor" },
    { { 0x00, 0x12, 0x8D }, "STBDatenserv", "STB Datenservice GmbH" },
    { { 0x00, 0x12, 0x8E }, "QFreeASA",     "Q-Free ASA" },
    { { 0x00, 0x12, 0x8F }, "Montilio",     "Montilio" },
    { { 0x00, 0x12, 0x90 }, "KYOWAElectri", "KYOWA Electric & Machinery Corp." },
    { { 0x00, 0x12, 0x91 }, "KWSComputers", "KWS Computersysteme GmbH" },
    { { 0x00, 0x12, 0x92 }, "GriffinTechn", "Griffin Technology" },
    { { 0x00, 0x12, 0x93 }, "ABBSwitzerla", "ABB Switzerland Ltd." },
    { { 0x00, 0x12, 0x94 }, "SumitomoElec", "Sumitomo Electric Device Innovations, Inc" },
    { { 0x00, 0x12, 0x95 }, "Aiware",       "Aiware Inc." },
    { { 0x00, 0x12, 0x96 }, "Addlogix",     "Addlogix" },
    { { 0x00, 0x12, 0x97 }, "O2Micro",      "O2Micro, Inc." },
    { { 0x00, 0x12, 0x98 }, "MicoElectric", "Mico Electric(Shenzhen) Limited" },
    { { 0x00, 0x12, 0x99 }, "KtechTelecom", "Ktech Telecommunications Inc" },
    { { 0x00, 0x12, 0x9A }, "IRTElectroni", "IRT Electronics Pty Ltd" },
    { { 0x00, 0x12, 0x9B }, "E2SElectroni", "E2S Electronic Engineering Solutions, S.L." },
    { { 0x00, 0x12, 0x9C }, "Yulinet",      "Yulinet" },
    { { 0x00, 0x12, 0x9D }, "FirstInterna", "First International Computer do Brasil" },
    { { 0x00, 0x12, 0x9E }, "SurfCommunic", "Surf Communications Inc." },
    { { 0x00, 0x12, 0x9F }, "RAE",          "RAE Systems" },
    { { 0x00, 0x12, 0xA0 }, "NeoMeridianS", "NeoMeridian Sdn Bhd" },
    { { 0x00, 0x12, 0xA1 }, "BluePacketCo", "BluePacket Communications Co., Ltd." },
    { { 0x00, 0x12, 0xA2 }, "Vita",         "Vita" },
    { { 0x00, 0x12, 0xA3 }, "TrustInterna", "Trust International B.V." },
    { { 0x00, 0x12, 0xA4 }, "ThingMagic",   "ThingMagic, LLC" },
    { { 0x00, 0x12, 0xA5 }, "DolphinInter", "Dolphin Interconnect Solutions AS" },
    { { 0x00, 0x12, 0xA6 }, "DolbyAustral", "Dolby Australia" },
    { { 0x00, 0x12, 0xA7 }, "ISRTECHNOLOG", "ISR TECHNOLOGIES Inc" },
    { { 0x00, 0x12, 0xA8 }, "intec",        "intec GmbH" },
    { { 0x00, 0x12, 0xA9 }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x12, 0xAA }, "IEE",          "IEE, Inc." },
    { { 0x00, 0x12, 0xAB }, "WiLife",       "WiLife, Inc." },
    { { 0x00, 0x12, 0xAC }, "Ontimetek",    "Ontimetek Inc." },
    { { 0x00, 0x12, 0xAD }, "Vivavis",      "Vivavis Ag" },
    { { 0x00, 0x12, 0xAE }, "HLSHARDLINES", "HLS HARD-LINE Solutions Inc." },
    { { 0x00, 0x12, 0xAF }, "ELPROTechnol", "ELPRO Technologies" },
    { { 0x00, 0x12, 0xB0 }, "Efore",        "Efore Oyj (Plc)" },
    { { 0x00, 0x12, 0xB1 }, "DaiNipponPri", "Dai Nippon Printing Co., Ltd" },
    { { 0x00, 0x12, 0xB2 }, "Avolites",     "Avolites Ltd." },
    { { 0x00, 0x12, 0xB3 }, "AdvanceWirel", "Advance Wireless Technology Corp." },
    { { 0x00, 0x12, 0xB4 }, "WorkMicrowav", "Work Microwave GmbH" },
    { { 0x00, 0x12, 0xB5 }, "Vialta",       "Vialta, Inc." },
    { { 0x00, 0x12, 0xB6 }, "SantaBarbara", "Santa Barbara Infrared, Inc." },
    { { 0x00, 0x12, 0xB7 }, "PTWFreiburg",  "PTW Freiburg" },
    { { 0x00, 0x12, 0xB8 }, "G2Microsyste", "G2 Microsystems" },
    { { 0x00, 0x12, 0xB9 }, "FusionDigita", "Fusion Digital Technology" },
    { { 0x00, 0x12, 0xBA }, "FSI",          "FSI Systems, Inc." },
    { { 0x00, 0x12, 0xBB }, "Telecommunic", "Telecommunications Industry Association TR-41 Committee" },
    { { 0x00, 0x12, 0xBC }, "Echolab",      "Echolab LLC" },
    { { 0x00, 0x12, 0xBD }, "AvantecManuf", "Avantec Manufacturing Limited" },
    { { 0x00, 0x12, 0xBE }, "Astek",        "Astek Corporation" },
    { { 0x00, 0x12, 0xBF }, "ArcadyanTech", "Arcadyan Technology Corporation" },
    { { 0x00, 0x12, 0xC0 }, "HotLava",      "HotLava Systems, Inc." },
    { { 0x00, 0x12, 0xC1 }, "CheckPointSo", "Check Point Software Technologies" },
    { { 0x00, 0x12, 0xC2 }, "ApexElectron", "Apex Electronics Factory" },
    { { 0x00, 0x12, 0xC3 }, "Wit",          "Wit S.A." },
    { { 0x00, 0x12, 0xC4 }, "Viseon",       "Viseon, Inc." },
    { { 0x00, 0x12, 0xC5 }, "VShowTechnol", "V-Show Technology (China) Co.,Ltd" },
    { { 0x00, 0x12, 0xC6 }, "TGCAmerica",   "TGC America, Inc" },
    { { 0x00, 0x12, 0xC7 }, "SECURAYTechn", "SECURAY Technologies Ltd.Co." },
    { { 0x00, 0x12, 0xC8 }, "Perfecttech",  "Perfect tech" },
    { { 0x00, 0x12, 0xC9 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x12, 0xCA }, "MechatronicB", "Mechatronic Brick Aps" },
    { { 0x00, 0x12, 0xCB }, "CSS",          "CSS Inc." },
    { { 0x00, 0x12, 0xCC }, "Bitatek",      "Bitatek CO., LTD" },
    { { 0x00, 0x12, 0xCD }, "ASEM",         "ASEM SpA" },
    { { 0x00, 0x12, 0xCE }, "AdvancedCybe", "Advanced Cybernetics Group" },
    { { 0x00, 0x12, 0xCF }, "AcctonTechno", "Accton Technology Corp" },
    { { 0x00, 0x12, 0xD0 }, "GossenMetraw", "Gossen-Metrawatt-GmbH" },
    { { 0x00, 0x12, 0xD1 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x12, 0xD2 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x12, 0xD3 }, "Zetta",        "Zetta Systems, Inc." },
    { { 0x00, 0x12, 0xD4 }, "PrincetonTec", "Princeton Technology, Ltd" },
    { { 0x00, 0x12, 0xD5 }, "MotionRealit", "Motion Reality Inc." },
    { { 0x00, 0x12, 0xD6 }, "JiangsuYiton", "Jiangsu Yitong High-Tech Co.,Ltd" },
    { { 0x00, 0x12, 0xD7 }, "InventoNetwo", "Invento Networks, Inc." },
    { { 0x00, 0x12, 0xD8 }, "Internationa", "International Games System Co., Ltd." },
    { { 0x00, 0x12, 0xD9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0xDA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x12, 0xDB }, "ZIEHLindustr", "ZIEHL industrie-elektronik GmbH + Co KG" },
    { { 0x00, 0x12, 0xDC }, "SunCorpIndus", "SunCorp Industrial Limited" },
    { { 0x00, 0x12, 0xDD }, "ShengquInfor", "Shengqu Information Technology (Shanghai) Co., Ltd." },
    { { 0x00, 0x12, 0xDE }, "RadioCompone", "Radio Components Sweden AB" },
    { { 0x00, 0x12, 0xDF }, "Novomatic",    "Novomatic AG" },
    { { 0x00, 0x12, 0xE0 }, "Codan",        "Codan Limited" },
    { { 0x00, 0x12, 0xE1 }, "AlliantNetwo", "Alliant Networks, Inc" },
    { { 0x00, 0x12, 0xE2 }, "ALAXALANetwo", "ALAXALA Networks Corporation" },
    { { 0x00, 0x12, 0xE3 }, "AgatSoft",     "Agat Soft LLC" },
    { { 0x00, 0x12, 0xE4 }, "ZIEHLindustr", "ZIEHL industrie-electronik GmbH + Co KG" },
    { { 0x00, 0x12, 0xE5 }, "TimeAmerica",  "Time America, Inc." },
    { { 0x00, 0x12, 0xE6 }, "SpectecCompu", "Spectec Computer Co., Ltd." },
    { { 0x00, 0x12, 0xE7 }, "ProjectekNet", "Projectek Networking Electronics Corp." },
    { { 0x00, 0x12, 0xE8 }, "FraunhoferIM", "Fraunhofer IMS" },
    { { 0x00, 0x12, 0xE9 }, "Abbey",        "Abbey Systems Ltd" },
    { { 0x00, 0x12, 0xEA }, "Trane",        "Trane" },
    { { 0x00, 0x12, 0xEB }, "PDHSolutions", "PDH Solutions, LLC" },
    { { 0x00, 0x12, 0xEC }, "Movacolor",    "Movacolor b.v." },
    { { 0x00, 0x12, 0xED }, "AVGAdvancedT", "AVG Advanced Technologies" },
    { { 0x00, 0x12, 0xEE }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x12, 0xEF }, "OneAccess",    "OneAccess SA" },
    { { 0x00, 0x12, 0xF0 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x12, 0xF1 }, "Ifotec",       "Ifotec" },
    { { 0x00, 0x12, 0xF2 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x12, 0xF3 }, "ublox",        "u-blox AG" },
    { { 0x00, 0x12, 0xF4 }, "BelcoInterna", "Belco International Co.,Ltd." },
    { { 0x00, 0x12, 0xF5 }, "ImardaNewZea", "Imarda New Zealand Limited" },
    { { 0x00, 0x12, 0xF6 }, "Mdk",          "Mdk Co.,Ltd." },
    { { 0x00, 0x12, 0xF7 }, "XiamenXingli", "Xiamen Xinglian Electronics Co., Ltd." },
    { { 0x00, 0x12, 0xF8 }, "WNIResources", "WNI Resources, LLC" },
    { { 0x00, 0x12, 0xF9 }, "UryuSeisaku",  "Uryu Seisaku, Ltd." },
    { { 0x00, 0x12, 0xFA }, "Thx",          "Thx Ltd" },
    { { 0x00, 0x12, 0xFB }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x12, 0xFC }, "PLANETSystem", "PLANET System Co.,LTD" },
    { { 0x00, 0x12, 0xFD }, "OptimusIc",    "Optimus Ic S.A." },
    { { 0x00, 0x12, 0xFE }, "LenovoMobile", "Lenovo Mobile Communication Technology Ltd." },
    { { 0x00, 0x12, 0xFF }, "LelyIndustri", "Lely Industries N.V." },
    { { 0x00, 0x13, 0x00 }, "ItFactory",    "It-Factory, Inc." },
    { { 0x00, 0x13, 0x01 }, "IronGateSL",   "IronGate S.L." },
    { { 0x00, 0x13, 0x02 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x13, 0x03 }, "GateConnect",  "GateConnect" },
    { { 0x00, 0x13, 0x04 }, "FlaircommTec", "Flaircomm Technologies Co. LTD" },
    { { 0x00, 0x13, 0x05 }, "Epicom",       "Epicom, Inc." },
    { { 0x00, 0x13, 0x06 }, "AlwaysOnWire", "Always On Wireless" },
    { { 0x00, 0x13, 0x07 }, "Paravirtual",  "Paravirtual Corporation" },
    { { 0x00, 0x13, 0x08 }, "NuveraFuelCe", "Nuvera Fuel Cells" },
    { { 0x00, 0x13, 0x09 }, "OceanBroadba", "Ocean Broadband Networks" },
    { { 0x00, 0x13, 0x0A }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x13, 0x0B }, "Mextal",       "Mextal B.V." },
    { { 0x00, 0x13, 0x0C }, "HFSystem",     "HF System Corporation" },
    { { 0x00, 0x13, 0x0D }, "GalileoAvion", "Galileo Avionica" },
    { { 0x00, 0x13, 0x0E }, "FocusriteAud", "Focusrite Audio Engineering Limited" },
    { { 0x00, 0x13, 0x0F }, "EGEMENBilgis", "EGEMEN Bilgisayar Muh San ve Tic LTD STI" },
    { { 0x00, 0x13, 0x10 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x13, 0x11 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x13, 0x12 }, "AmediaNetwor", "Amedia Networks Inc." },
    { { 0x00, 0x13, 0x13 }, "GuangZhouPos", "GuangZhou Post & Telecom Equipment ltd" },
    { { 0x00, 0x13, 0x14 }, "Asiamajor",    "Asiamajor Inc." },
    { { 0x00, 0x13, 0x15 }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0x13, 0x16 }, "LSBBroadcast", "L-S-B Broadcast Technologies GmbH" },
    { { 0x00, 0x13, 0x17 }, "GNNetcom",     "GN Netcom A/S" },
    { { 0x00, 0x13, 0x18 }, "DGSTATION",    "DGSTATION Co., Ltd." },
    { { 0x00, 0x13, 0x19 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0x1A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0x1B }, "BeCellInnova", "BeCell Innovations Corp." },
    { { 0x00, 0x13, 0x1C }, "LiteTouch",    "LiteTouch, Inc." },
    { { 0x00, 0x13, 0x1D }, "ScanvaegtInt", "Scanvaegt International A/S" },
    { { 0x00, 0x13, 0x1E }, "peikeracusti", "peiker acustic GmbH" },
    { { 0x00, 0x13, 0x1F }, "NxtPhaseT&D",  "NxtPhase T&D, Corp." },
    { { 0x00, 0x13, 0x20 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x13, 0x21 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x13, 0x22 }, "DAQElectroni", "DAQ Electronics, Inc." },
    { { 0x00, 0x13, 0x23 }, "Cap",          "Cap Co., Ltd." },
    { { 0x00, 0x13, 0x24 }, "SchneiderEle", "Schneider Electric Ultra Terminal" },
    { { 0x00, 0x13, 0x25 }, "Cortina",      "Cortina Systems Inc" },
    { { 0x00, 0x13, 0x26 }, "ECM",          "ECM Systems Ltd" },
    { { 0x00, 0x13, 0x27 }, "DataAcquisit", "Data Acquisitions limited" },
    { { 0x00, 0x13, 0x28 }, "WestechKorea", "Westech Korea Inc.," },
    { { 0x00, 0x13, 0x29 }, "VSST",         "VSST Co., LTD" },
    { { 0x00, 0x13, 0x2A }, "SitronicsTel", "Sitronics Telecom Solutions" },
    { { 0x00, 0x13, 0x2B }, "PhoenixDigit", "Phoenix Digital" },
    { { 0x00, 0x13, 0x2C }, "MAZBrandenbu", "MAZ Brandenburg GmbH" },
    { { 0x00, 0x13, 0x2D }, "iWiseCommuni", "iWise Communications" },
    { { 0x00, 0x13, 0x2E }, "ITianCoporat", "ITian Coporation" },
    { { 0x00, 0x13, 0x2F }, "Interactek",   "Interactek" },
    { { 0x00, 0x13, 0x30 }, "EuroProtecti", "Euro Protection Surveillance" },
    { { 0x00, 0x13, 0x31 }, "CellPointCon", "CellPoint Connect" },
    { { 0x00, 0x13, 0x32 }, "TopsecNetwor", "Beijing Topsec Network Security Technology Co., Ltd." },
    { { 0x00, 0x13, 0x33 }, "BaudTec",      "BaudTec Corporation" },
    { { 0x00, 0x13, 0x34 }, "Arkados",      "Arkados, Inc." },
    { { 0x00, 0x13, 0x35 }, "VSIndustryBe", "VS Industry Berhad" },
    { { 0x00, 0x13, 0x36 }, "Tianjin712Co", "Tianjin 712 Communication Broadcasting co., ltd." },
    { { 0x00, 0x13, 0x37 }, "OrientPowerH", "Orient Power Home Network Ltd." },
    { { 0x00, 0x13, 0x38 }, "FreseniusVia", "Fresenius-Vial" },
    { { 0x00, 0x13, 0x39 }, "CCVDeutschla", "CCV Deutschland GmbH" },
    { { 0x00, 0x13, 0x3A }, "VadaTech",     "VadaTech Inc." },
    { { 0x00, 0x13, 0x3B }, "SpeedDragonM", "Speed Dragon Multimedia Limited" },
    { { 0x00, 0x13, 0x3C }, "Quintron",     "Quintron Systems Inc." },
    { { 0x00, 0x13, 0x3D }, "MicroMemoryC", "Micro Memory Curtiss Wright Co" },
    { { 0x00, 0x13, 0x3E }, "MetaSwitch",   "MetaSwitch" },
    { { 0x00, 0x13, 0x3F }, "EppendorfIns", "Eppendorf Instrumente GmbH" },
    { { 0x00, 0x13, 0x40 }, "ADEL",         "AD.EL s.r.l." },
    { { 0x00, 0x13, 0x41 }, "ShandongNewB", "Shandong New Beiyang Information Technology Co.,Ltd" },
    { { 0x00, 0x13, 0x42 }, "VisionResear", "Vision Research, Inc." },
    { { 0x00, 0x13, 0x43 }, "MatsushitaEl", "Matsushita Electronic Components (Europe) GmbH" },
    { { 0x00, 0x13, 0x44 }, "FargoElectro", "Fargo Electronics Inc." },
    { { 0x00, 0x13, 0x45 }, "Eaton",        "Eaton Corporation" },
    { { 0x00, 0x13, 0x46 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x13, 0x47 }, "RedLionContr", "Red Lion Controls, LP" },
    { { 0x00, 0x13, 0x48 }, "ArtilaElectr", "Artila Electronics Co., Ltd." },
    { { 0x00, 0x13, 0x49 }, "ZyxelCommuni", "Zyxel Communications Corporation" },
    { { 0x00, 0x13, 0x4A }, "Engim",        "Engim, Inc." },
    { { 0x00, 0x13, 0x4B }, "ToGoldenNetT", "ToGoldenNet Technology Inc." },
    { { 0x00, 0x13, 0x4C }, "YDTTechnolog", "YDT Technology International" },
    { { 0x00, 0x13, 0x4D }, "Inepro",       "Inepro BV" },
    { { 0x00, 0x13, 0x4E }, "Valox",        "Valox Systems, Inc." },
    { { 0x00, 0x13, 0x4F }, "RapidusWirel", "Rapidus Wireless Networks Inc." },
    { { 0x00, 0x13, 0x50 }, "SilverSpring", "Silver Spring Networks, Inc" },
    { { 0x00, 0x13, 0x51 }, "NilesAudio",   "Niles Audio Corporation" },
    { { 0x00, 0x13, 0x52 }, "Naztec",       "Naztec, Inc." },
    { { 0x00, 0x13, 0x53 }, "HYDACFiltert", "HYDAC Filtertechnik GMBH" },
    { { 0x00, 0x13, 0x54 }, "ZcomaxTechno", "Zcomax Technologies, Inc." },
    { { 0x00, 0x13, 0x55 }, "TOMENCyberbu", "TOMEN Cyber-business Solutions, Inc." },
    { { 0x00, 0x13, 0x56 }, "FLIRRadiatio", "FLIR Radiation Inc" },
    { { 0x00, 0x13, 0x57 }, "SoyalTechnol", "Soyal Technology Co., Ltd." },
    { { 0x00, 0x13, 0x58 }, "Realm",        "Realm Systems, Inc." },
    { { 0x00, 0x13, 0x59 }, "ProTelevisio", "ProTelevision Technologies A/S" },
    { { 0x00, 0x13, 0x5A }, "ProjectT&E",   "Project T&E Limited" },
    { { 0x00, 0x13, 0x5B }, "PanelLinkCin", "PanelLink Cinema, LLC" },
    { { 0x00, 0x13, 0x5C }, "OnSite",       "OnSite Systems, Inc." },
    { { 0x00, 0x13, 0x5D }, "NTTPCCommuni", "NTTPC Communications, Inc." },
    { { 0x00, 0x13, 0x5E }, "EabRwiK",      "Eab/Rwi/K" },
    { { 0x00, 0x13, 0x5F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0x60 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0x61 }, "Biospace",     "Biospace Co., Ltd." },
    { { 0x00, 0x13, 0x62 }, "ShinHeungPre", "ShinHeung Precision Co., Ltd." },
    { { 0x00, 0x13, 0x63 }, "Verascape",    "Verascape, Inc." },
    { { 0x00, 0x13, 0x64 }, "ParadigmTech", "Paradigm Technology Inc.." },
    { { 0x00, 0x13, 0x65 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x13, 0x66 }, "NeturityTech", "Neturity Technologies Inc." },
    { { 0x00, 0x13, 0x67 }, "Narayon",      "Narayon. Co., Ltd." },
    { { 0x00, 0x13, 0x68 }, "SaabDanmark",  "Saab Danmark A/S" },
    { { 0x00, 0x13, 0x69 }, "HondaElectro", "Honda Electron Co., LED." },
    { { 0x00, 0x13, 0x6A }, "HachLange",    "Hach Lange Sarl" },
    { { 0x00, 0x13, 0x6B }, "ETec",         "E-Tec" },
    { { 0x00, 0x13, 0x6C }, "TomTom",       "TomTom" },
    { { 0x00, 0x13, 0x6D }, "Tentaculus",   "Tentaculus AB" },
    { { 0x00, 0x13, 0x6E }, "Techmetro",    "Techmetro Corp." },
    { { 0x00, 0x13, 0x6F }, "PacketMotion", "PacketMotion, Inc." },
    { { 0x00, 0x13, 0x70 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x13, 0x71 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x13, 0x72 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x13, 0x73 }, "BLwaveElectr", "BLwave Electronics Co., Ltd" },
    { { 0x00, 0x13, 0x74 }, "AtherosCommu", "Atheros Communications, Inc." },
    { { 0x00, 0x13, 0x75 }, "AmericanSecu", "American Security Products Co." },
    { { 0x00, 0x13, 0x76 }, "TaborElectro", "Tabor Electronics Ltd." },
    { { 0x00, 0x13, 0x77 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x13, 0x78 }, "QsanTechnolo", "Qsan Technology, Inc." },
    { { 0x00, 0x13, 0x79 }, "PonderInform", "Ponder Information Industries Ltd." },
    { { 0x00, 0x13, 0x7A }, "NetvoxTechno", "Netvox Technology Co., Ltd." },
    { { 0x00, 0x13, 0x7B }, "Movon",        "Movon Corporation" },
    { { 0x00, 0x13, 0x7C }, "Kaicom",       "Kaicom co., Ltd." },
    { { 0x00, 0x13, 0x7D }, "Dynalab",      "Dynalab, Inc." },
    { { 0x00, 0x13, 0x7E }, "CorEdgeNetwo", "CorEdge Networks, Inc." },
    { { 0x00, 0x13, 0x7F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0x80 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0x81 }, "CHIPS",        "CHIPS & Systems, Inc." },
    { { 0x00, 0x13, 0x82 }, "CetaceaNetwo", "Cetacea Networks Corporation" },
    { { 0x00, 0x13, 0x83 }, "ApplicationT", "Application Technologies and Engineering Research Laboratory" },
    { { 0x00, 0x13, 0x84 }, "AdvancedMoti", "Advanced Motion Controls" },
    { { 0x00, 0x13, 0x85 }, "AddOnTechnol", "Add-On Technology Co., LTD." },
    { { 0x00, 0x13, 0x86 }, "ABBTotalflow", "ABB Inc/Totalflow" },
    { { 0x00, 0x13, 0x87 }, "27MTechnolog", "27M Technologies AB" },
    { { 0x00, 0x13, 0x88 }, "WiMediaAllia", "WiMedia Alliance" },
    { { 0x00, 0x13, 0x89 }, "RedesdeTelef", "Redes de Telefonía Móvil S.A." },
    { { 0x00, 0x13, 0x8A }, "QingdaoGoerT", "Qingdao GoerTek Technology Co., Ltd." },
    { { 0x00, 0x13, 0x8B }, "PhantomTechn", "Phantom Technologies LLC" },
    { { 0x00, 0x13, 0x8C }, "Kumyoung",     "Kumyoung.Co.Ltd" },
    { { 0x00, 0x13, 0x8D }, "Kinghold",     "Kinghold" },
    { { 0x00, 0x13, 0x8E }, "FOABElektron", "FOAB Elektronik AB" },
    { { 0x00, 0x13, 0x8F }, "AsiarockTech", "Asiarock Technology Limited" },
    { { 0x00, 0x13, 0x90 }, "TermtekCompu", "Termtek Computer Co., Ltd" },
    { { 0x00, 0x13, 0x91 }, "Ouen",         "Ouen Co.,Ltd." },
    { { 0x00, 0x13, 0x92 }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0x13, 0x93 }, "Panta",        "Panta Systems, Inc." },
    { { 0x00, 0x13, 0x94 }, "Infohand",     "Infohand Co.,Ltd" },
    { { 0x00, 0x13, 0x95 }, "congatec",     "congatec GmbH" },
    { { 0x00, 0x13, 0x96 }, "AcbelPolytec", "Acbel Polytech Inc." },
    { { 0x00, 0x13, 0x97 }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x13, 0x98 }, "TrafficSim",   "TrafficSim Co.,Ltd" },
    { { 0x00, 0x13, 0x99 }, "STAC",         "STAC Corporation." },
    { { 0x00, 0x13, 0x9A }, "KubiqueID",    "K-ubique ID Corp." },
    { { 0x00, 0x13, 0x9B }, "ioIMAGE",      "ioIMAGE Ltd." },
    { { 0x00, 0x13, 0x9C }, "ExaveraTechn", "Exavera Technologies, Inc." },
    { { 0x00, 0x13, 0x9D }, "MaxLinearHis", "MaxLinear Hispania S.L.U." },
    { { 0x00, 0x13, 0x9E }, "CiaraTechnol", "Ciara Technologies Inc." },
    { { 0x00, 0x13, 0x9F }, "ElectronicsD", "Electronics Design Services, Co., Ltd." },
    { { 0x00, 0x13, 0xA0 }, "ALGOSYSTEM",   "ALGOSYSTEM Co., Ltd." },
    { { 0x00, 0x13, 0xA1 }, "CrowElectron", "Crow Electronic Engeneering" },
    { { 0x00, 0x13, 0xA2 }, "MaxStream",    "MaxStream, Inc" },
    { { 0x00, 0x13, 0xA3 }, "SiemensHomeO", "Siemens Home & Office Comm. Devices" },
    { { 0x00, 0x13, 0xA4 }, "KeyEyeCommun", "KeyEye Communications" },
    { { 0x00, 0x13, 0xA5 }, "GeneralSolut", "General Solutions, LTD." },
    { { 0x00, 0x13, 0xA6 }, "Extricom",     "Extricom Ltd" },
    { { 0x00, 0x13, 0xA7 }, "BattelleMemo", "Battelle Memorial Institute" },
    { { 0x00, 0x13, 0xA8 }, "TanisysTechn", "Tanisys Technology" },
    { { 0x00, 0x13, 0xA9 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x13, 0xAA }, "ALSTEC",       "ALS & TEC Ltd." },
    { { 0x00, 0x13, 0xAB }, "Telemotive",   "Telemotive AG" },
    { { 0x00, 0x13, 0xAC }, "SunmyungElec", "Sunmyung Electronics Co., LTD" },
    { { 0x00, 0x13, 0xAD }, "Sendo",        "Sendo Ltd" },
    { { 0x00, 0x13, 0xAE }, "RadianceTech", "Radiance Technologies, Inc." },
    { { 0x00, 0x13, 0xAF }, "NUMATechnolo", "NUMA Technology,Inc." },
    { { 0x00, 0x13, 0xB0 }, "Jablotron",    "Jablotron" },
    { { 0x00, 0x13, 0xB1 }, "IntelligentC", "Intelligent Control Systems (Asia) Pte Ltd" },
    { { 0x00, 0x13, 0xB2 }, "Carallon",     "Carallon Limited" },
    { { 0x00, 0x13, 0xB3 }, "EcomCommunic", "Ecom Communications Technology Co., Ltd." },
    { { 0x00, 0x13, 0xB4 }, "AppearAS",     "Appear AS" },
    { { 0x00, 0x13, 0xB5 }, "Wavesat",      "Wavesat" },
    { { 0x00, 0x13, 0xB6 }, "SlingMedia",   "Sling Media, Inc." },
    { { 0x00, 0x13, 0xB7 }, "ScantechID",   "Scantech ID" },
    { { 0x00, 0x13, 0xB8 }, "RyCoElectron", "RyCo Electronic Systems Limited" },
    { { 0x00, 0x13, 0xB9 }, "Bm",           "Bm Spa" },
    { { 0x00, 0x13, 0xBA }, "ReadyLinks",   "ReadyLinks Inc" },
    { { 0x00, 0x13, 0xBB }, "Smartvue",     "Smartvue Corporation" },
    { { 0x00, 0x13, 0xBC }, "Artimi",       "Artimi Ltd" },
    { { 0x00, 0x13, 0xBD }, "Hymatom",      "Hymatom Sa" },
    { { 0x00, 0x13, 0xBE }, "VirtualConex", "Virtual Conexions" },
    { { 0x00, 0x13, 0xBF }, "MediaSystemP", "Media System Planning Corp." },
    { { 0x00, 0x13, 0xC0 }, "TrixTecnolog", "Trix Tecnologia Ltda." },
    { { 0x00, 0x13, 0xC1 }, "AsokaUSA",     "Asoka USA Corporation" },
    { { 0x00, 0x13, 0xC2 }, "WACOM",        "WACOM Co.,Ltd" },
    { { 0x00, 0x13, 0xC3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0xC4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x13, 0xC5 }, "LightronFibe", "Lightron Fiber-Optic Devices Inc." },
    { { 0x00, 0x13, 0xC6 }, "OpenGear",     "OpenGear, Inc" },
    { { 0x00, 0x13, 0xC7 }, "IONOS",        "IONOS Co.,Ltd." },
    { { 0x00, 0x13, 0xC8 }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x13, 0xC9 }, "BeyondAchiev", "Beyond Achieve Enterprises Ltd." },
    { { 0x00, 0x13, 0xCA }, "Atx",          "Atx" },
    { { 0x00, 0x13, 0xCB }, "ZenitelNorwa", "Zenitel Norway AS" },
    { { 0x00, 0x13, 0xCC }, "TallMaple",    "Tall Maple Systems" },
    { { 0x00, 0x13, 0xCD }, "MTI",          "MTI co. LTD" },
    { { 0x00, 0x13, 0xCE }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x13, 0xCF }, "4AccessCommu", "4Access Communications" },
    { { 0x00, 0x13, 0xD0 }, "tMedical",     "t+ Medical Ltd" },
    { { 0x00, 0x13, 0xD1 }, "KIRKtelecom",  "KIRK telecom A/S" },
    { { 0x00, 0x13, 0xD2 }, "PageIberica",  "Page Iberica, S.A." },
    { { 0x00, 0x13, 0xD3 }, "MicroStarInt", "Micro-Star International Co., Ltd." },
    { { 0x00, 0x13, 0xD4 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x13, 0xD5 }, "RuggedCom",    "RuggedCom" },
    { { 0x00, 0x13, 0xD6 }, "TiiNetworkTe", "Tii Network Technologies, Inc." },
    { { 0x00, 0x13, 0xD7 }, "SPIDCOMTechn", "SPIDCOM Technologies SA" },
    { { 0x00, 0x13, 0xD8 }, "PrincetonIns", "Princeton Instruments" },
    { { 0x00, 0x13, 0xD9 }, "MatrixProduc", "Matrix Product Development, Inc." },
    { { 0x00, 0x13, 0xDA }, "Diskware",     "Diskware Co., Ltd" },
    { { 0x00, 0x13, 0xDB }, "SHOEIElectri", "SHOEI Electric Co.,Ltd" },
    { { 0x00, 0x13, 0xDC }, "Ibtek",        "Ibtek Inc." },
    { { 0x00, 0x13, 0xDD }, "AbbottDiagno", "Abbott Diagnostics" },
    { { 0x00, 0x13, 0xDE }, "Adapt4",       "Adapt4, LLC" },
    { { 0x00, 0x13, 0xDF }, "Ryvor",        "Ryvor Corp." },
    { { 0x00, 0x13, 0xE0 }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0x13, 0xE1 }, "Iprobe",       "Iprobe AB" },
    { { 0x00, 0x13, 0xE2 }, "GeoVision",    "GeoVision Inc." },
    { { 0x00, 0x13, 0xE3 }, "CoViTechnolo", "CoVi Technologies, Inc." },
    { { 0x00, 0x13, 0xE4 }, "Yangjae",      "Yangjae Systems Corp." },
    { { 0x00, 0x13, 0xE5 }, "Tenosys",      "Tenosys, Inc." },
    { { 0x00, 0x13, 0xE6 }, "Technolution", "Technolution" },
    { { 0x00, 0x13, 0xE7 }, "Halcro",       "Halcro" },
    { { 0x00, 0x13, 0xE8 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x13, 0xE9 }, "VeriWave",     "VeriWave, Inc." },
    { { 0x00, 0x13, 0xEA }, "Kamstrup",     "Kamstrup A/S" },
    { { 0x00, 0x13, 0xEB }, "Sysmaster",    "Sysmaster Corporation" },
    { { 0x00, 0x13, 0xEC }, "NetsnapperTe", "Netsnapper Technologies SARL" },
    { { 0x00, 0x13, 0xED }, "Psia",         "Psia" },
    { { 0x00, 0x13, 0xEE }, "JBXDesigns",   "JBX Designs Inc." },
    { { 0x00, 0x13, 0xEF }, "KingjonDigit", "Kingjon Digital Technology Co.,Ltd" },
    { { 0x00, 0x13, 0xF0 }, "WavefrontSem", "Wavefront Semiconductor" },
    { { 0x00, 0x13, 0xF1 }, "AMODTechnolo", "AMOD Technology Co., Ltd." },
    { { 0x00, 0x13, 0xF2 }, "Klas",         "Klas Ltd" },
    { { 0x00, 0x13, 0xF3 }, "GigabyteComm", "Giga-byte Communications Inc." },
    { { 0x00, 0x13, 0xF4 }, "Psitek",       "Psitek (Pty) Ltd" },
    { { 0x00, 0x13, 0xF5 }, "Akimbi",       "Akimbi Systems" },
    { { 0x00, 0x13, 0xF6 }, "Cintech",      "Cintech" },
    { { 0x00, 0x13, 0xF7 }, "SMCNetworks",  "SMC Networks, Inc." },
    { { 0x00, 0x13, 0xF8 }, "DexSecurityS", "Dex Security Solutions" },
    { { 0x00, 0x13, 0xF9 }, "Cavera",       "Cavera Systems" },
    { { 0x00, 0x13, 0xFA }, "LifeSizeComm", "LifeSize Communications, Inc" },
    { { 0x00, 0x13, 0xFB }, "RkcInstrumen", "Rkc Instrument Inc." },
    { { 0x00, 0x13, 0xFC }, "SiCortex",     "SiCortex, Inc" },
    { { 0x00, 0x13, 0xFD }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x13, 0xFE }, "GrandtecElec", "Grandtec Electronic Corp." },
    { { 0x00, 0x13, 0xFF }, "DageMTIMC",    "Dage-MTI of MC, Inc." },
    { { 0x00, 0x14, 0x00 }, "MinervaKorea", "Minerva Korea Co., Ltd" },
    { { 0x00, 0x14, 0x01 }, "RivertreeNet", "Rivertree Networks Corp." },
    { { 0x00, 0x14, 0x02 }, "kkelectronic", "kk-electronic a/s" },
    { { 0x00, 0x14, 0x03 }, "Renasis",      "Renasis, LLC" },
    { { 0x00, 0x14, 0x04 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x14, 0x05 }, "OpenIB",       "OpenIB, Inc." },
    { { 0x00, 0x14, 0x06 }, "GoNetworks",   "Go Networks" },
    { { 0x00, 0x14, 0x07 }, "SperianProte", "Sperian Protection Instrumentation" },
    { { 0x00, 0x14, 0x08 }, "Eka",          "Eka Systems Inc." },
    { { 0x00, 0x14, 0x09 }, "MAGNETIMAREL", "MAGNETI MARELLI S.E. S.p.A." },
    { { 0x00, 0x14, 0x0A }, "WEPIO",        "WEPIO Co., Ltd." },
    { { 0x00, 0x14, 0x0B }, "FirstInterna", "First International Computer, Inc." },
    { { 0x00, 0x14, 0x0C }, "GkbCctv",      "Gkb Cctv Co., Ltd." },
    { { 0x00, 0x14, 0x0D }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x14, 0x0E }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x14, 0x0F }, "FederalState", "Federal State Unitary Enterprise Leningrad R&D Institute of" },
    { { 0x00, 0x14, 0x10 }, "SuzhouKedaTe", "Suzhou Keda Technology CO.,Ltd" },
    { { 0x00, 0x14, 0x11 }, "DeutschmannA", "Deutschmann Automation GmbH & Co. KG" },
    { { 0x00, 0x14, 0x12 }, "STECelectron", "S-TEC electronics AG" },
    { { 0x00, 0x14, 0x13 }, "TrebingHimst", "Trebing & Himstedt Prozeßautomation GmbH & Co. KG" },
    { { 0x00, 0x14, 0x14 }, "Jumpnode",     "Jumpnode Systems LLC." },
    { { 0x00, 0x14, 0x15 }, "IntecAutomat", "Intec Automation inc." },
    { { 0x00, 0x14, 0x16 }, "ScoscheIndus", "Scosche Industries, Inc." },
    { { 0x00, 0x14, 0x17 }, "RSEInformati", "RSE Informations Technologie GmbH" },
    { { 0x00, 0x14, 0x18 }, "C4Line",       "C4Line" },
    { { 0x00, 0x14, 0x19 }, "Sidsa",        "Sidsa" },
    { { 0x00, 0x14, 0x1A }, "Deicy",        "Deicy Corporation" },
    { { 0x00, 0x14, 0x1B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0x1C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0x1D }, "KEBAIndustri", "KEBA Industrial Automation Germany GmbH" },
    { { 0x00, 0x14, 0x1E }, "PASemi",       "P.A. Semi, Inc." },
    { { 0x00, 0x14, 0x1F }, "SunKwangElec", "SunKwang Electronics Co., Ltd" },
    { { 0x00, 0x14, 0x20 }, "GLinksnetwor", "G-Links networking company" },
    { { 0x00, 0x14, 0x21 }, "TotalWireles", "Total Wireless Technologies Pte. Ltd." },
    { { 0x00, 0x14, 0x22 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x14, 0x23 }, "JSNEUROCOM",   "J-S Co. NEUROCOM" },
    { { 0x00, 0x14, 0x24 }, "MerryElectri", "Merry Electrics CO., LTD." },
    { { 0x00, 0x14, 0x25 }, "GalacticComp", "Galactic Computing Corp." },
    { { 0x00, 0x14, 0x26 }, "NLTechnology", "NL Technology" },
    { { 0x00, 0x14, 0x27 }, "JazzMutant",   "JazzMutant" },
    { { 0x00, 0x14, 0x28 }, "Vocollect",    "Vocollect Inc" },
    { { 0x00, 0x14, 0x29 }, "VCenterTechn", "V Center Technologies Co., Ltd." },
    { { 0x00, 0x14, 0x2A }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x14, 0x2B }, "EdataCommuni", "Edata Communication Inc." },
    { { 0x00, 0x14, 0x2C }, "KonceptInter", "Koncept International, Inc." },
    { { 0x00, 0x14, 0x2D }, "Toradex",      "Toradex AG" },
    { { 0x00, 0x14, 0x2E }, "77Elektronik", "77 Elektronika Kft." },
    { { 0x00, 0x14, 0x2F }, "Savvius",      "Savvius" },
    { { 0x00, 0x14, 0x30 }, "ViPowER",      "ViPowER, Inc" },
    { { 0x00, 0x14, 0x31 }, "PDLElectroni", "PDL Electronics Ltd" },
    { { 0x00, 0x14, 0x32 }, "TarallaxWire", "Tarallax Wireless, Inc." },
    { { 0x00, 0x14, 0x33 }, "EmpowerTechn", "Empower Technologies(Canada) Inc." },
    { { 0x00, 0x14, 0x34 }, "Keri",         "Keri Systems, Inc" },
    { { 0x00, 0x14, 0x35 }, "CityCom",      "CityCom Corp." },
    { { 0x00, 0x14, 0x36 }, "QwertyElektr", "Qwerty Elektronik AB" },
    { { 0x00, 0x14, 0x37 }, "GSTeletech",   "GSTeletech Co.,Ltd." },
    { { 0x00, 0x14, 0x38 }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x00, 0x14, 0x39 }, "BlonderTongu", "Blonder Tongue Laboratories, Inc" },
    { { 0x00, 0x14, 0x3A }, "RaytalkInter", "Raytalk International Srl" },
    { { 0x00, 0x14, 0x3B }, "Sensovation",  "Sensovation AG" },
    { { 0x00, 0x14, 0x3C }, "RheinmetallC", "Rheinmetall Canada Inc." },
    { { 0x00, 0x14, 0x3D }, "Aevoe",        "Aevoe Inc." },
    { { 0x00, 0x14, 0x3E }, "AirLinkCommu", "AirLink Communications, Inc." },
    { { 0x00, 0x14, 0x3F }, "HotwayTechno", "Hotway Technology Corporation" },
    { { 0x00, 0x14, 0x40 }, "ATOMIC",       "ATOMIC Corporation" },
    { { 0x00, 0x14, 0x41 }, "InnovationSo", "Innovation Sound Technology Co., LTD." },
    { { 0x00, 0x14, 0x42 }, "Atto",         "Atto Corporation" },
    { { 0x00, 0x14, 0x43 }, "Consultronic", "Consultronics Europe Ltd" },
    { { 0x00, 0x14, 0x44 }, "Grundfos",     "Grundfos Holding" },
    { { 0x00, 0x14, 0x45 }, "TelefonGradn", "Telefon-Gradnja d.o.o." },
    { { 0x00, 0x14, 0x46 }, "SuperVisionS", "SuperVision Solutions LLC" },
    { { 0x00, 0x14, 0x47 }, "BOAZ",         "BOAZ Inc." },
    { { 0x00, 0x14, 0x48 }, "InventecMult", "Inventec Multimedia & Telecom Corporation" },
    { { 0x00, 0x14, 0x49 }, "SichuanChang", "Sichuan Changhong Electric Ltd." },
    { { 0x00, 0x14, 0x4A }, "TaiwanThickF", "Taiwan Thick-Film Ind. Corp." },
    { { 0x00, 0x14, 0x4B }, "Hifn",         "Hifn, Inc." },
    { { 0x00, 0x14, 0x4C }, "GeneralMeter", "General Meters Corp." },
    { { 0x00, 0x14, 0x4D }, "Intelligent",  "Intelligent Systems" },
    { { 0x00, 0x14, 0x4E }, "Srisa",        "Srisa" },
    { { 0x00, 0x14, 0x4F }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x14, 0x50 }, "Heim",         "Heim Systems GmbH" },
    { { 0x00, 0x14, 0x51 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x14, 0x52 }, "Calculex",     "Calculex,Inc." },
    { { 0x00, 0x14, 0x53 }, "AdvantechTec", "Advantech Technologies Co.,Ltd" },
    { { 0x00, 0x14, 0x54 }, "Symwave",      "Symwave" },
    { { 0x00, 0x14, 0x55 }, "CoderElectro", "Coder Electronics Corporation" },
    { { 0x00, 0x14, 0x56 }, "EdgeProducts", "Edge Products" },
    { { 0x00, 0x14, 0x57 }, "Nevion",       "Nevion" },
    { { 0x00, 0x14, 0x58 }, "HSAutomaticA", "HS Automatic ApS" },
    { { 0x00, 0x14, 0x59 }, "Moram",        "Moram Co., Ltd." },
    { { 0x00, 0x14, 0x5A }, "WestermoNera", "Westermo Neratec AG" },
    { { 0x00, 0x14, 0x5B }, "SeekerNet",    "SeekerNet Inc." },
    { { 0x00, 0x14, 0x5C }, "Intronics",    "Intronics B.V." },
    { { 0x00, 0x14, 0x5D }, "WJCommunicat", "WJ Communications, Inc." },
    { { 0x00, 0x14, 0x5E }, "IBM",          "IBM Corp" },
    { { 0x00, 0x14, 0x5F }, "Aditec",       "Aditec Co. Ltd" },
    { { 0x00, 0x14, 0x60 }, "KyoceraWirel", "Kyocera Wireless Corp." },
    { { 0x00, 0x14, 0x61 }, "Corona",       "Corona Corporation" },
    { { 0x00, 0x14, 0x62 }, "DigiwellTech", "Digiwell Technology, inc" },
    { { 0x00, 0x14, 0x63 }, "Idcs",         "Idcs N.V." },
    { { 0x00, 0x14, 0x64 }, "Cryptosoft",   "Cryptosoft" },
    { { 0x00, 0x14, 0x65 }, "NovoNordisk",  "Novo Nordisk A/S" },
    { { 0x00, 0x14, 0x66 }, "KleinhenzEle", "Kleinhenz Elektronik GmbH" },
    { { 0x00, 0x14, 0x67 }, "ArrowSpan",    "ArrowSpan Inc." },
    { { 0x00, 0x14, 0x68 }, "CelPlanInter", "CelPlan International, Inc." },
    { { 0x00, 0x14, 0x69 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0x6A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0x6B }, "Anagran",      "Anagran, Inc." },
    { { 0x00, 0x14, 0x6C }, "Netgear",      "Netgear" },
    { { 0x00, 0x14, 0x6D }, "RFTechnologi", "RF Technologies" },
    { { 0x00, 0x14, 0x6E }, "HStoll",       "H. Stoll GmbH & Co. KG" },
    { { 0x00, 0x14, 0x6F }, "Kohler",       "Kohler Co" },
    { { 0x00, 0x14, 0x70 }, "ProkomSoftwa", "Prokom Software SA" },
    { { 0x00, 0x14, 0x71 }, "EasternAsiaT", "Eastern Asia Technology Limited" },
    { { 0x00, 0x14, 0x72 }, "ChinaBroadba", "China Broadband Wireless IP Standard group(ChinaBWIPS)" },
    { { 0x00, 0x14, 0x73 }, "Bookham",      "Bookham Inc" },
    { { 0x00, 0x14, 0x74 }, "K40Electroni", "K40 Electronics" },
    { { 0x00, 0x14, 0x75 }, "WilineNetwor", "Wiline Networks, Inc." },
    { { 0x00, 0x14, 0x76 }, "MultiComIndu", "MultiCom Industries Limited" },
    { { 0x00, 0x14, 0x77 }, "Trilliant",    "Trilliant" },
    { { 0x00, 0x14, 0x78 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x14, 0x79 }, "NECMagnusCom", "NEC Magnus Communications,Ltd." },
    { { 0x00, 0x14, 0x7A }, "Eubus",        "Eubus GmbH" },
    { { 0x00, 0x14, 0x7B }, "Iteris",       "Iteris, Inc." },
    { { 0x00, 0x14, 0x7C }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x14, 0x7D }, "AeonDigitalI", "Aeon Digital International" },
    { { 0x00, 0x14, 0x7E }, "InnerWireles", "InnerWireless" },
    { { 0x00, 0x14, 0x7F }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x14, 0x80 }, "HitachiLGDat", "Hitachi-LG Data Storage Korea, Inc" },
    { { 0x00, 0x14, 0x81 }, "Multilink",    "Multilink Inc" },
    { { 0x00, 0x14, 0x82 }, "AuroraNetwor", "Aurora Networks" },
    { { 0x00, 0x14, 0x83 }, "eXS",          "eXS Inc." },
    { { 0x00, 0x14, 0x84 }, "CermateTechn", "Cermate Technologies Inc." },
    { { 0x00, 0x14, 0x85 }, "GigaByte",     "Giga-Byte" },
    { { 0x00, 0x14, 0x86 }, "EchoDigitalA", "Echo Digital Audio Corporation" },
    { { 0x00, 0x14, 0x87 }, "AmericanTech", "American Technology Integrators" },
    { { 0x00, 0x14, 0x88 }, "Akorri",       "Akorri" },
    { { 0x00, 0x14, 0x89 }, "B15402100Jan", "B15402100 - Jandei, S.L." },
    { { 0x00, 0x14, 0x8A }, "ElinEbgTract", "Elin Ebg Traction Gmbh" },
    { { 0x00, 0x14, 0x8B }, "GloboElectro", "Globo Electronic GmbH & Co. KG" },
    { { 0x00, 0x14, 0x8C }, "GeneralDynam", "General Dynamics Mission Systems" },
    { { 0x00, 0x14, 0x8D }, "CubicDefense", "Cubic Defense Simulation Systems" },
    { { 0x00, 0x14, 0x8E }, "TelePower",    "Tele Power Inc." },
    { { 0x00, 0x14, 0x8F }, "Protronic",    "Protronic (Far East) Ltd." },
    { { 0x00, 0x14, 0x90 }, "ASP",          "ASP Corporation" },
    { { 0x00, 0x14, 0x91 }, "DanielsElect", "Daniels Electronics Ltd. dba Codan Radio Communications" },
    { { 0x00, 0x14, 0x92 }, "LiteonMobile", "Liteon, Mobile Media Solution SBU" },
    { { 0x00, 0x14, 0x93 }, "SystimaxSolu", "Systimax Solutions" },
    { { 0x00, 0x14, 0x94 }, "Esu",          "Esu Ag" },
    { { 0x00, 0x14, 0x95 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x14, 0x96 }, "Phonic",       "Phonic Corp." },
    { { 0x00, 0x14, 0x97 }, "ZHIYUANEletr", "ZHIYUAN Eletronics co.,ltd." },
    { { 0x00, 0x14, 0x98 }, "VikingDesign", "Viking Design Technology" },
    { { 0x00, 0x14, 0x99 }, "Helicomm",     "Helicomm Inc" },
    { { 0x00, 0x14, 0x9A }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x14, 0x9B }, "NokotaCommun", "Nokota Communications, LLC" },
    { { 0x00, 0x14, 0x9C }, "HF",           "HF Company" },
    { { 0x00, 0x14, 0x9D }, "SoundID",      "Sound ID Inc." },
    { { 0x00, 0x14, 0x9E }, "UbONE",        "UbONE Co., Ltd" },
    { { 0x00, 0x14, 0x9F }, "SystemandChi", "System and Chips, Inc." },
    { { 0x00, 0x14, 0xA0 }, "Accsense",     "Accsense, Inc." },
    { { 0x00, 0x14, 0xA1 }, "SynchronousC", "Synchronous Communication Corp" },
    { { 0x00, 0x14, 0xA2 }, "CoreMicro",    "Core Micro Systems Inc." },
    { { 0x00, 0x14, 0xA3 }, "Vitelec",      "Vitelec BV" },
    { { 0x00, 0x14, 0xA4 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x14, 0xA5 }, "GemtekTechno", "Gemtek Technology Co., Ltd." },
    { { 0x00, 0x14, 0xA6 }, "Teranetics",   "Teranetics, Inc." },
    { { 0x00, 0x14, 0xA7 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x14, 0xA8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0xA9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0xAA }, "AshlyAudio",   "Ashly Audio, Inc." },
    { { 0x00, 0x14, 0xAB }, "SenhaiElectr", "Senhai Electronic Technology Co., Ltd." },
    { { 0x00, 0x14, 0xAC }, "BountifulWiF", "Bountiful WiFi" },
    { { 0x00, 0x14, 0xAD }, "GassnerWiege", "Gassner Wiege- und Meßtechnik GmbH" },
    { { 0x00, 0x14, 0xAE }, "Wizlogics",    "Wizlogics Co., Ltd." },
    { { 0x00, 0x14, 0xAF }, "DatasymPOS",   "Datasym POS Inc." },
    { { 0x00, 0x14, 0xB0 }, "NaeilCommuni", "Naeil Community" },
    { { 0x00, 0x14, 0xB1 }, "AxellWireles", "Axell Wireless Limited" },
    { { 0x00, 0x14, 0xB2 }, "mCubelogics",  "mCubelogics Corporation" },
    { { 0x00, 0x14, 0xB3 }, "CoreStarInte", "CoreStar International Corp" },
    { { 0x00, 0x14, 0xB4 }, "GeneralDynam", "General Dynamics United Kingdom Ltd" },
    { { 0x00, 0x14, 0xB5 }, "Physiometrix", "Physiometrix,Inc" },
    { { 0x00, 0x14, 0xB6 }, "EnswerTechno", "Enswer Technology Inc." },
    { { 0x00, 0x14, 0xB7 }, "ARInfotek",    "AR Infotek Inc." },
    { { 0x00, 0x14, 0xB8 }, "HillRom",      "Hill-Rom" },
    { { 0x00, 0x14, 0xB9 }, "MstarSemicon", "Mstar Semiconductor" },
    { { 0x00, 0x14, 0xBA }, "Carvers",      "Carvers SA de CV" },
    { { 0x00, 0x14, 0xBB }, "OpenInterfac", "Open Interface North America" },
    { { 0x00, 0x14, 0xBC }, "SynecticTele", "Synectic Telecom Exports Pvt. Ltd." },
    { { 0x00, 0x14, 0xBD }, "incNETWORKS",  "incNETWORKS, Inc" },
    { { 0x00, 0x14, 0xBE }, "Winkcommunic", "Wink communication technology CO.LTD" },
    { { 0x00, 0x14, 0xBF }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x14, 0xC0 }, "SymstreamTec", "Symstream Technology Group Ltd" },
    { { 0x00, 0x14, 0xC1 }, "USRobotics",   "U.S. Robotics Corporation" },
    { { 0x00, 0x14, 0xC2 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x14, 0xC3 }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x14, 0xC4 }, "VitelcomMobi", "Vitelcom Mobile Technology" },
    { { 0x00, 0x14, 0xC5 }, "AliveTechnol", "Alive Technologies Pty Ltd" },
    { { 0x00, 0x14, 0xC6 }, "Quixant",      "Quixant Ltd" },
    { { 0x00, 0x14, 0xC7 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x14, 0xC8 }, "Contemporary", "Contemporary Research Corp" },
    { { 0x00, 0x14, 0xC9 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x14, 0xCA }, "KeyRadio",     "Key Radio Systems Limited" },
    { { 0x00, 0x14, 0xCB }, "LifeSync",     "LifeSync Corporation" },
    { { 0x00, 0x14, 0xCC }, "Zetec",        "Zetec, Inc." },
    { { 0x00, 0x14, 0xCD }, "DigitalZone",  "DigitalZone Co., Ltd." },
    { { 0x00, 0x14, 0xCE }, "Nf",           "Nf Corporation" },
    { { 0x00, 0x14, 0xCF }, "INVISIOCommu", "INVISIO Communications" },
    { { 0x00, 0x14, 0xD0 }, "BTI",          "BTI Systems Inc." },
    { { 0x00, 0x14, 0xD1 }, "TRENDnet",     "TRENDnet, Inc." },
    { { 0x00, 0x14, 0xD2 }, "KyudenTechno", "Kyuden Technosystems Corporation" },
    { { 0x00, 0x14, 0xD3 }, "Sepsa",        "Sepsa" },
    { { 0x00, 0x14, 0xD4 }, "KTechnology",  "K Technology Corporation" },
    { { 0x00, 0x14, 0xD5 }, "DatangTeleco", "Datang Telecom Technology CO. , LCD,Optical Communication Br" },
    { { 0x00, 0x14, 0xD6 }, "JeongminElec", "Jeongmin Electronics Co.,Ltd." },
    { { 0x00, 0x14, 0xD7 }, "DatastoreTec", "Datastore Technology Corp" },
    { { 0x00, 0x14, 0xD8 }, "biologic",     "bio-logic SA" },
    { { 0x00, 0x14, 0xD9 }, "IPFabrics",    "IP Fabrics, Inc." },
    { { 0x00, 0x14, 0xDA }, "HuntleighHea", "Huntleigh Healthcare" },
    { { 0x00, 0x14, 0xDB }, "ElmaTrenewEl", "Elma Trenew Electronic GmbH" },
    { { 0x00, 0x14, 0xDC }, "Communicatio", "Communication System Design & Manufacturing (CSDM)" },
    { { 0x00, 0x14, 0xDD }, "Covergence",   "Covergence Inc." },
    { { 0x00, 0x14, 0xDE }, "SageInstrume", "Sage Instruments Inc." },
    { { 0x00, 0x14, 0xDF }, "HIPTech",      "HI-P Tech Corporation" },
    { { 0x00, 0x14, 0xE0 }, "LETS",         "LET'S Corporation" },
    { { 0x00, 0x14, 0xE1 }, "DataDisplay",  "Data Display AG" },
    { { 0x00, 0x14, 0xE2 }, "datacom",      "datacom systems inc." },
    { { 0x00, 0x14, 0xE3 }, "mmlab",        "mm-lab GmbH" },
    { { 0x00, 0x14, 0xE4 }, "infinias",     "infinias, LLC" },
    { { 0x00, 0x14, 0xE5 }, "Alticast",     "Alticast" },
    { { 0x00, 0x14, 0xE6 }, "AIMInfrarotm", "AIM Infrarotmodule GmbH" },
    { { 0x00, 0x14, 0xE7 }, "Stolinx",      "Stolinx,. Inc" },
    { { 0x00, 0x14, 0xE8 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x14, 0xE9 }, "NortechInter", "Nortech International" },
    { { 0x00, 0x14, 0xEA }, "SDigm",        "S Digm Inc. (Safe Paradigm Inc.)" },
    { { 0x00, 0x14, 0xEB }, "AwarePoint",   "AwarePoint Corporation" },
    { { 0x00, 0x14, 0xEC }, "AcroTelecom",  "Acro Telecom" },
    { { 0x00, 0x14, 0xED }, "Airak",        "Airak, Inc." },
    { { 0x00, 0x14, 0xEE }, "WesternDigit", "Western Digital Technologies, Inc." },
    { { 0x00, 0x14, 0xEF }, "TZeroTechnol", "TZero Technologies, Inc." },
    { { 0x00, 0x14, 0xF0 }, "BusinessSecu", "Business Security OL AB" },
    { { 0x00, 0x14, 0xF1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0xF2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x14, 0xF3 }, "ViXS",         "ViXS Systems Inc" },
    { { 0x00, 0x14, 0xF4 }, "DekTecDigita", "DekTec Digital Video B.V." },
    { { 0x00, 0x14, 0xF5 }, "OSISecurityD", "OSI Security Devices" },
    { { 0x00, 0x14, 0xF6 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x14, 0xF7 }, "CREVIS",       "CREVIS Co., LTD" },
    { { 0x00, 0x14, 0xF8 }, "ScientificAt", "Scientific Atlanta" },
    { { 0x00, 0x14, 0xF9 }, "VantageContr", "Vantage Controls" },
    { { 0x00, 0x14, 0xFA }, "AsGa",         "AsGa S.A." },
    { { 0x00, 0x14, 0xFB }, "TechnicalSol", "Technical Solutions Inc." },
    { { 0x00, 0x14, 0xFC }, "Extandon",     "Extandon, Inc." },
    { { 0x00, 0x14, 0xFD }, "ThecusTechno", "Thecus Technology Corp." },
    { { 0x00, 0x14, 0xFE }, "ArtechElectr", "Artech Electronics" },
    { { 0x00, 0x14, 0xFF }, "PreciseAutom", "Precise Automation, Inc." },
    { { 0x00, 0x15, 0x00 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x15, 0x01 }, "LexBox",       "LexBox" },
    { { 0x00, 0x15, 0x02 }, "BETAtech",     "BETA tech" },
    { { 0x00, 0x15, 0x03 }, "PROFIcommssr", "PROFIcomms s.r.o." },
    { { 0x00, 0x15, 0x04 }, "GamePlus",     "Game Plus Co., Ltd." },
    { { 0x00, 0x15, 0x05 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x15, 0x06 }, "NeoPhotonics", "Neo Photonics" },
    { { 0x00, 0x15, 0x07 }, "RenaissanceL", "Renaissance Learning Inc" },
    { { 0x00, 0x15, 0x08 }, "GlobalTarget", "Global Target Enterprise Inc" },
    { { 0x00, 0x15, 0x09 }, "PlusTechnolo", "Plus Technology Co., Ltd" },
    { { 0x00, 0x15, 0x0A }, "Sonoa",        "Sonoa Systems, Inc" },
    { { 0x00, 0x15, 0x0B }, "SageInfotech", "Sage Infotech Ltd." },
    { { 0x00, 0x15, 0x0C }, "AVM",          "AVM GmbH" },
    { { 0x00, 0x15, 0x0D }, "HoanaMedical", "Hoana Medical, Inc." },
    { { 0x00, 0x15, 0x0E }, "OpenbrainTec", "Openbrain Technologies Co., Ltd." },
    { { 0x00, 0x15, 0x0F }, "mingjong",     "mingjong" },
    { { 0x00, 0x15, 0x10 }, "Techsphere",   "Techsphere Co., Ltd" },
    { { 0x00, 0x15, 0x11 }, "DataCenter",   "Data Center Systems" },
    { { 0x00, 0x15, 0x12 }, "ZurichUniver", "Zurich University of Applied Sciences" },
    { { 0x00, 0x15, 0x13 }, "EFSsas",       "EFS sas" },
    { { 0x00, 0x15, 0x14 }, "HuZhouNAVANe", "Hu Zhou NAVA Networks&Electronics Ltd." },
    { { 0x00, 0x15, 0x15 }, "Leipold",      "Leipold+Co.GmbH" },
    { { 0x00, 0x15, 0x16 }, "Uriel",        "Uriel Systems Inc." },
    { { 0x00, 0x15, 0x17 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x15, 0x18 }, "10MOONSTechn", "Shenzhen 10MOONS Technology Development CO.,Ltd" },
    { { 0x00, 0x15, 0x19 }, "StoreAgeNetw", "StoreAge Networking Technologies" },
    { { 0x00, 0x15, 0x1A }, "HunterEngine", "Hunter Engineering Company" },
    { { 0x00, 0x15, 0x1B }, "Isilon",       "Isilon Systems Inc." },
    { { 0x00, 0x15, 0x1C }, "Leneco",       "Leneco" },
    { { 0x00, 0x15, 0x1D }, "M2I",          "M2I Corporation" },
    { { 0x00, 0x15, 0x1E }, "ETHERNETPowe", "ETHERNET Powerlink Standarization Group (EPSG)" },
    { { 0x00, 0x15, 0x1F }, "MultivisionI", "Multivision Intelligent Surveillance (Hong Kong) Ltd" },
    { { 0x00, 0x15, 0x20 }, "RadiocraftsA", "Radiocrafts AS" },
    { { 0x00, 0x15, 0x21 }, "Horoquartz",   "Horoquartz" },
    { { 0x00, 0x15, 0x22 }, "DeaSecurity",  "Dea Security" },
    { { 0x00, 0x15, 0x23 }, "MeteorCommun", "Meteor Communications Corporation" },
    { { 0x00, 0x15, 0x24 }, "Numatics",     "Numatics, Inc." },
    { { 0x00, 0x15, 0x25 }, "ChamberlainA", "Chamberlain Access Solutions" },
    { { 0x00, 0x15, 0x26 }, "RemoteTechno", "Remote Technologies Inc" },
    { { 0x00, 0x15, 0x27 }, "BalboaInstru", "Balboa Instruments" },
    { { 0x00, 0x15, 0x28 }, "BeaconMedica", "Beacon Medical Products LLC d.b.a. BeaconMedaes" },
    { { 0x00, 0x15, 0x29 }, "N3",           "N3 Corporation" },
    { { 0x00, 0x15, 0x2A }, "Nokia",        "Nokia Corporation" },
    { { 0x00, 0x15, 0x2B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0x2C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0x2D }, "TenXNetworks", "TenX Networks, LLC" },
    { { 0x00, 0x15, 0x2E }, "PacketHop",    "PacketHop, Inc." },
    { { 0x00, 0x15, 0x2F }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0x30 }, "DellEMC",      "Dell EMC" },
    { { 0x00, 0x15, 0x31 }, "Kocom",        "Kocom" },
    { { 0x00, 0x15, 0x32 }, "ConsumerTech", "Consumer Technologies Group, LLC" },
    { { 0x00, 0x15, 0x33 }, "Nadam",        "Nadam.Co.,Ltd" },
    { { 0x00, 0x15, 0x34 }, "ABeltrónicaC", "A Beltrónica-Companhia de Comunicações, Lda" },
    { { 0x00, 0x15, 0x35 }, "OTE",          "OTE Spa" },
    { { 0x00, 0x15, 0x36 }, "Powertech",    "Powertech co.,Ltd" },
    { { 0x00, 0x15, 0x37 }, "VentusNetwor", "Ventus Networks" },
    { { 0x00, 0x15, 0x38 }, "RFID",         "RFID, Inc." },
    { { 0x00, 0x15, 0x39 }, "Technodrive",  "Technodrive srl" },
    { { 0x00, 0x15, 0x3A }, "SyscanTechno", "Shenzhen Syscan Technology Co.,Ltd." },
    { { 0x00, 0x15, 0x3B }, "EMHMetering",  "EMH Metering GmbH & Co. KG" },
    { { 0x00, 0x15, 0x3C }, "Kprotech",     "Kprotech Co., Ltd." },
    { { 0x00, 0x15, 0x3D }, "ElimProduct",  "Elim Product Co." },
    { { 0x00, 0x15, 0x3E }, "QMaticSweden", "Q-Matic Sweden AB" },
    { { 0x00, 0x15, 0x3F }, "AlcatelAleni", "Alcatel Alenia Space Italia" },
    { { 0x00, 0x15, 0x40 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x15, 0x41 }, "StrataLightC", "StrataLight Communications, Inc." },
    { { 0x00, 0x15, 0x42 }, "Microhard",    "Microhard S.R.L." },
    { { 0x00, 0x15, 0x43 }, "AberdeenTest", "Aberdeen Test Center" },
    { { 0x00, 0x15, 0x44 }, "coMt",         "coM.s.a.t. AG" },
    { { 0x00, 0x15, 0x45 }, "SEECODE",      "SEECODE Co., Ltd." },
    { { 0x00, 0x15, 0x46 }, "ITGWorldwide", "ITG Worldwide Sdn Bhd" },
    { { 0x00, 0x15, 0x47 }, "AiZenSolutio", "AiZen Solutions Inc." },
    { { 0x00, 0x15, 0x48 }, "CubeTechnolo", "Cube Technologies" },
    { { 0x00, 0x15, 0x49 }, "DixtalBiomed", "Dixtal Biomedica Ind. Com. Ltda" },
    { { 0x00, 0x15, 0x4A }, "WanshihElect", "Wanshih Electronic Co., Ltd" },
    { { 0x00, 0x15, 0x4B }, "WondeProudTe", "Wonde Proud Technology Co., Ltd" },
    { { 0x00, 0x15, 0x4C }, "SaundersElec", "Saunders Electronics" },
    { { 0x00, 0x15, 0x4D }, "Netronome",    "Netronome Systems, Inc." },
    { { 0x00, 0x15, 0x4E }, "Iec",          "Iec" },
    { { 0x00, 0x15, 0x4F }, "oneRFTechnol", "one RF Technology" },
    { { 0x00, 0x15, 0x50 }, "NitsTechnolo", "Nits Technology Inc" },
    { { 0x00, 0x15, 0x51 }, "RadioPulse",   "RadioPulse Inc." },
    { { 0x00, 0x15, 0x52 }, "WiGear",       "Wi-Gear Inc." },
    { { 0x00, 0x15, 0x53 }, "Cytyc",        "Cytyc Corporation" },
    { { 0x00, 0x15, 0x54 }, "AtalumWirele", "Atalum Wireless S.A." },
    { { 0x00, 0x15, 0x55 }, "DFM",          "DFM GmbH" },
    { { 0x00, 0x15, 0x56 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x15, 0x57 }, "Olivetti",     "Olivetti" },
    { { 0x00, 0x15, 0x58 }, "Foxconn",      "Foxconn" },
    { { 0x00, 0x15, 0x59 }, "SecuraplaneT", "Securaplane Technologies, Inc." },
    { { 0x00, 0x15, 0x5A }, "DainipponPha", "Dainippon Pharmaceutical Co., Ltd." },
    { { 0x00, 0x15, 0x5B }, "Sampo",        "Sampo Corporation" },
    { { 0x00, 0x15, 0x5C }, "DresserWayne", "Dresser Wayne" },
    { { 0x00, 0x15, 0x5D }, "Microsoft",    "Microsoft Corporation" },
    { { 0x00, 0x15, 0x5E }, "MorganStanle", "Morgan Stanley" },
    { { 0x00, 0x15, 0x5F }, "GreenPeakTec", "GreenPeak Technologies" },
    { { 0x00, 0x15, 0x60 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x15, 0x61 }, "JJPlus",       "JJPlus Corporation" },
    { { 0x00, 0x15, 0x62 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0x63 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0x64 }, "BEHRINGERSpe", "BEHRINGER Spezielle Studiotechnik GmbH" },
    { { 0x00, 0x15, 0x65 }, "XiamenYealin", "Xiamen Yealink Network Technology Co.,Ltd" },
    { { 0x00, 0x15, 0x66 }, "AFirstTechno", "A-First Technology Co., Ltd." },
    { { 0x00, 0x15, 0x67 }, "RADWIN",       "RADWIN Inc." },
    { { 0x00, 0x15, 0x68 }, "DilithiumNet", "Dilithium Networks" },
    { { 0x00, 0x15, 0x69 }, "PECOII",       "PECO II, Inc." },
    { { 0x00, 0x15, 0x6A }, "DG2LTechnolo", "DG2L Technologies Pvt. Ltd." },
    { { 0x00, 0x15, 0x6B }, "PerfisansNet", "Perfisans Networks Corp." },
    { { 0x00, 0x15, 0x6C }, "SaneSystem",   "Sane System Co., Ltd" },
    { { 0x00, 0x15, 0x6D }, "Ubiquiti",     "Ubiquiti Inc" },
    { { 0x00, 0x15, 0x6E }, "AWCommunicat", "A. W. Communication Systems Ltd" },
    { { 0x00, 0x15, 0x6F }, "XiranetCommu", "Xiranet Communications GmbH" },
    { { 0x00, 0x15, 0x70 }, "ZebraTechnol", "Zebra Technologies Inc" },
    { { 0x00, 0x15, 0x71 }, "Nolan",        "Nolan Systems" },
    { { 0x00, 0x15, 0x72 }, "RedLemon",     "Red-Lemon" },
    { { 0x00, 0x15, 0x73 }, "NewSoftTechn", "NewSoft Technology Corporation" },
    { { 0x00, 0x15, 0x74 }, "HorizonSemic", "Horizon Semiconductors Ltd." },
    { { 0x00, 0x15, 0x75 }, "NevisNetwork", "Nevis Networks Inc." },
    { { 0x00, 0x15, 0x76 }, "LABiTecLabor", "LABiTec - Labor Biomedical Technologies GmbH" },
    { { 0x00, 0x15, 0x77 }, "AlliedTelesi", "Allied Telesis, Inc." },
    { { 0x00, 0x15, 0x78 }, "AudioVideoIn", "Audio / Video Innovations" },
    { { 0x00, 0x15, 0x79 }, "LunatoneIndu", "Lunatone Industrielle Elektronik GmbH" },
    { { 0x00, 0x15, 0x7A }, "Telefin",      "Telefin S.p.A." },
    { { 0x00, 0x15, 0x7B }, "Leuzeelectro", "Leuze electronic GmbH + Co. KG" },
    { { 0x00, 0x15, 0x7C }, "DaveNetworks", "Dave Networks, Inc." },
    { { 0x00, 0x15, 0x7D }, "Posdata",      "Posdata" },
    { { 0x00, 0x15, 0x7E }, "WeidmüllerIn", "Weidmüller Interface GmbH & Co. KG" },
    { { 0x00, 0x15, 0x7F }, "ChuanGIntern", "ChuanG International Holding CO.,LTD." },
    { { 0x00, 0x15, 0x80 }, "UWay",         "U-Way Corporation" },
    { { 0x00, 0x15, 0x81 }, "MAKUS",        "MAKUS Inc." },
    { { 0x00, 0x15, 0x82 }, "PulseEight",   "Pulse Eight Limited" },
    { { 0x00, 0x15, 0x83 }, "IVT",          "IVT corporation" },
    { { 0x00, 0x15, 0x84 }, "SchenckProce", "Schenck Process GmbH" },
    { { 0x00, 0x15, 0x85 }, "AonvisionTec", "Aonvision Technolopy Corp." },
    { { 0x00, 0x15, 0x86 }, "XiamenOverse", "Xiamen Overseas Chinese Electronic Co., Ltd." },
    { { 0x00, 0x15, 0x87 }, "TakenakaSeis", "Takenaka Seisakusho Co.,Ltd" },
    { { 0x00, 0x15, 0x88 }, "SaluticaAlli", "Salutica Allied Solutions Sdn Bhd" },
    { { 0x00, 0x15, 0x89 }, "DMAXTechnolo", "D-MAX Technology Co.,Ltd" },
    { { 0x00, 0x15, 0x8A }, "SURECOMTechn", "SURECOM Technology Corp." },
    { { 0x00, 0x15, 0x8B }, "ParkAir",      "Park Air Systems Ltd" },
    { { 0x00, 0x15, 0x8C }, "LiabApS",      "Liab ApS" },
    { { 0x00, 0x15, 0x8D }, "Jennic",       "Jennic Ltd" },
    { { 0x00, 0x15, 0x8E }, "Plustek",      "Plustek.INC" },
    { { 0x00, 0x15, 0x8F }, "NTTAdvancedT", "NTT Advanced Technology Corporation" },
    { { 0x00, 0x15, 0x90 }, "Hectronic",    "Hectronic GmbH" },
    { { 0x00, 0x15, 0x91 }, "RLW",          "RLW Inc." },
    { { 0x00, 0x15, 0x92 }, "FacomUK",      "Facom UK Ltd (Melksham)" },
    { { 0x00, 0x15, 0x93 }, "U4EATechnolo", "U4EA Technologies Inc." },
    { { 0x00, 0x15, 0x94 }, "Bixolon",      "Bixolon Co.,Ltd" },
    { { 0x00, 0x15, 0x95 }, "QuesterTange", "Quester Tangent Corporation" },
    { { 0x00, 0x15, 0x96 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0x97 }, "AetaAudio",    "Aeta Audio Systems" },
    { { 0x00, 0x15, 0x98 }, "Kolektorgrou", "Kolektor group" },
    { { 0x00, 0x15, 0x99 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x15, 0x9A }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0x9B }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x15, 0x9C }, "BKYUNGSYSTEM", "B-KYUNG SYSTEM Co.,Ltd." },
    { { 0x00, 0x15, 0x9D }, "TrippLite",    "Tripp Lite" },
    { { 0x00, 0x15, 0x9E }, "MadCatzInter", "Mad Catz Interactive Inc" },
    { { 0x00, 0x15, 0x9F }, "Terascala",    "Terascala, Inc." },
    { { 0x00, 0x15, 0xA0 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x15, 0xA1 }, "EcaSinters",   "Eca-Sinters" },
    { { 0x00, 0x15, 0xA2 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xA3 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xA4 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xA5 }, "DCI",          "DCI Co., Ltd." },
    { { 0x00, 0x15, 0xA6 }, "DigitalElect", "Digital Electronics Products Ltd." },
    { { 0x00, 0x15, 0xA7 }, "Robatech",     "Robatech AG" },
    { { 0x00, 0x15, 0xA8 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xA9 }, "KwangWooI&C",  "Kwang Woo I&C Co.,Ltd" },
    { { 0x00, 0x15, 0xAA }, "RextechnikIn", "Rextechnik International Co.," },
    { { 0x00, 0x15, 0xAB }, "ProSound",     "Pro Co Sound Inc" },
    { { 0x00, 0x15, 0xAC }, "Capelon",      "Capelon AB" },
    { { 0x00, 0x15, 0xAD }, "AccedianNetw", "Accedian Networks" },
    { { 0x00, 0x15, 0xAE }, "kyungil",      "kyung il" },
    { { 0x00, 0x15, 0xAF }, "AzureWaveTec", "AzureWave Technology Inc." },
    { { 0x00, 0x15, 0xB0 }, "Autotelenet",  "Autotelenet Co.,Ltd" },
    { { 0x00, 0x15, 0xB1 }, "Ambient",      "Ambient Corporation" },
    { { 0x00, 0x15, 0xB2 }, "AdvancedIndu", "Advanced Industrial Computer, Inc." },
    { { 0x00, 0x15, 0xB3 }, "Caretech",     "Caretech AB" },
    { { 0x00, 0x15, 0xB4 }, "PolymapWirel", "Polymap Wireless LLC" },
    { { 0x00, 0x15, 0xB5 }, "CINetwork",    "CI Network Corp." },
    { { 0x00, 0x15, 0xB6 }, "ShinMaywaInd", "ShinMaywa Industries, Ltd." },
    { { 0x00, 0x15, 0xB7 }, "Toshiba",      "Toshiba" },
    { { 0x00, 0x15, 0xB8 }, "Tahoe",        "Tahoe" },
    { { 0x00, 0x15, 0xB9 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x15, 0xBA }, "iba",          "iba AG" },
    { { 0x00, 0x15, 0xBB }, "SMASolarTech", "SMA Solar Technology AG" },
    { { 0x00, 0x15, 0xBC }, "Develco",      "Develco" },
    { { 0x00, 0x15, 0xBD }, "Group4Techno", "Group 4 Technology Ltd" },
    { { 0x00, 0x15, 0xBE }, "Iqua",         "Iqua Ltd." },
    { { 0x00, 0x15, 0xBF }, "technicob",    "technicob" },
    { { 0x00, 0x15, 0xC0 }, "DigitalTelem", "Digital Telemedia Co.,Ltd." },
    { { 0x00, 0x15, 0xC1 }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0x15, 0xC2 }, "3MGermany",    "3M Germany" },
    { { 0x00, 0x15, 0xC3 }, "RufTelematik", "Ruf Telematik AG" },
    { { 0x00, 0x15, 0xC4 }, "Flovel",       "Flovel Co., Ltd." },
    { { 0x00, 0x15, 0xC5 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x15, 0xC6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0xC7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0xC8 }, "FlexiPanel",   "FlexiPanel Ltd" },
    { { 0x00, 0x15, 0xC9 }, "Gumstix",      "Gumstix, Inc" },
    { { 0x00, 0x15, 0xCA }, "TeraRecon",    "TeraRecon, Inc." },
    { { 0x00, 0x15, 0xCB }, "SurfCommunic", "Surf Communication Solutions Ltd." },
    { { 0x00, 0x15, 0xCC }, "Uquest",       "Uquest, Ltd." },
    { { 0x00, 0x15, 0xCD }, "ExartechInte", "Exartech International Corp." },
    { { 0x00, 0x15, 0xCE }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xCF }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xD0 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xD1 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x15, 0xD2 }, "Xantech",      "Xantech Corporation" },
    { { 0x00, 0x15, 0xD3 }, "Pantech&Curi", "Pantech&Curitel Communications, Inc." },
    { { 0x00, 0x15, 0xD4 }, "Emitor",       "Emitor AB" },
    { { 0x00, 0x15, 0xD5 }, "Nicevt",       "Nicevt" },
    { { 0x00, 0x15, 0xD6 }, "OSLiNKSp",     "OSLiNK Sp. z o.o." },
    { { 0x00, 0x15, 0xD7 }, "Reti",         "Reti Corporation" },
    { { 0x00, 0x15, 0xD8 }, "InterlinkEle", "Interlink Electronics" },
    { { 0x00, 0x15, 0xD9 }, "PKCElectroni", "PKC Electronics Oy" },
    { { 0x00, 0x15, 0xDA }, "IritelAD",     "Iritel A.D." },
    { { 0x00, 0x15, 0xDB }, "Canesta",      "Canesta Inc." },
    { { 0x00, 0x15, 0xDC }, "KT&C",         "KT&C Co., Ltd." },
    { { 0x00, 0x15, 0xDD }, "IPControl",    "IP Control Systems Ltd." },
    { { 0x00, 0x15, 0xDE }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x15, 0xDF }, "Clivet",       "Clivet S.p.A." },
    { { 0x00, 0x15, 0xE0 }, "Ericsson",     "Ericsson" },
    { { 0x00, 0x15, 0xE1 }, "Picochip",     "Picochip Ltd" },
    { { 0x00, 0x15, 0xE2 }, "DrIngHerbert", "Dr.Ing. Herbert Knauer GmbH" },
    { { 0x00, 0x15, 0xE3 }, "DreamTechnol", "Dream Technologies Corporation" },
    { { 0x00, 0x15, 0xE4 }, "ZimmerElektr", "Zimmer Elektromedizin" },
    { { 0x00, 0x15, 0xE5 }, "Cheertek",     "Cheertek Inc." },
    { { 0x00, 0x15, 0xE6 }, "MOBILETECHNI", "MOBILE TECHNIKA Inc." },
    { { 0x00, 0x15, 0xE7 }, "QuantecTonte", "Quantec Tontechnik" },
    { { 0x00, 0x15, 0xE8 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x15, 0xE9 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x15, 0xEA }, "Tellumat",     "Tellumat (Pty) Ltd" },
    { { 0x00, 0x15, 0xEB }, "zte",          "zte corporation" },
    { { 0x00, 0x15, 0xEC }, "BocaDevices",  "Boca Devices LLC" },
    { { 0x00, 0x15, 0xED }, "FulcrumMicro", "Fulcrum Microsystems, Inc." },
    { { 0x00, 0x15, 0xEE }, "OmnexControl", "Omnex Control Systems" },
    { { 0x00, 0x15, 0xEF }, "NECTOKIN",     "NEC TOKIN Corporation" },
    { { 0x00, 0x15, 0xF0 }, "Ego",          "Ego Bv" },
    { { 0x00, 0x15, 0xF1 }, "KYLINKCommun", "KYLINK Communications Corp." },
    { { 0x00, 0x15, 0xF2 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x15, 0xF3 }, "Peltor",       "Peltor Ab" },
    { { 0x00, 0x15, 0xF4 }, "Eventide",     "Eventide" },
    { { 0x00, 0x15, 0xF5 }, "SustainableE", "Sustainable Energy Systems" },
    { { 0x00, 0x15, 0xF6 }, "ScienceAndEn", "Science And Engineering Services, Inc." },
    { { 0x00, 0x15, 0xF7 }, "Wintecronics", "Wintecronics Ltd." },
    { { 0x00, 0x15, 0xF8 }, "KingtronicsI", "Kingtronics Industrial Co. Ltd." },
    { { 0x00, 0x15, 0xF9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0xFA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x15, 0xFB }, "setexschermu", "setex schermuly textile computer gmbh" },
    { { 0x00, 0x15, 0xFC }, "LittelfuseSt", "Littelfuse Startco" },
    { { 0x00, 0x15, 0xFD }, "CompleteMedi", "Complete Media Systems" },
    { { 0x00, 0x15, 0xFE }, "SchillingRob", "Schilling Robotics Llc" },
    { { 0x00, 0x15, 0xFF }, "NovatelWirel", "Novatel Wireless Solutions, Inc." },
    { { 0x00, 0x16, 0x00 }, "CelleBriteMo", "CelleBrite Mobile Synchronization" },
    { { 0x00, 0x16, 0x01 }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0x16, 0x02 }, "CeyonTechnol", "Ceyon Technology Co.,Ltd." },
    { { 0x00, 0x16, 0x03 }, "COOLKSKY",     "COOLKSKY Co., LTD" },
    { { 0x00, 0x16, 0x04 }, "Sigpro",       "Sigpro" },
    { { 0x00, 0x16, 0x05 }, "YorkvilleSou", "Yorkville Sound Inc." },
    { { 0x00, 0x16, 0x06 }, "IdealIndustr", "Ideal Industries" },
    { { 0x00, 0x16, 0x07 }, "CurvesIntern", "Curves International Inc." },
    { { 0x00, 0x16, 0x08 }, "SequansCommu", "Sequans Communications" },
    { { 0x00, 0x16, 0x09 }, "Unitechelect", "Unitech electronics co., ltd." },
    { { 0x00, 0x16, 0x0A }, "SWEEXEurope",  "SWEEX Europe BV" },
    { { 0x00, 0x16, 0x0B }, "TVWorks",      "TVWorks LLC" },
    { { 0x00, 0x16, 0x0C }, "LplDevelopme", "Lpl Development S.A. De C.V" },
    { { 0x00, 0x16, 0x0D }, "BeHere",       "Be Here Corporation" },
    { { 0x00, 0x16, 0x0E }, "OpticaTechno", "Optica Technologies Inc." },
    { { 0x00, 0x16, 0x0F }, "BadgerMeter",  "Badger Meter Inc" },
    { { 0x00, 0x16, 0x10 }, "CarinaTechno", "Carina Technology" },
    { { 0x00, 0x16, 0x11 }, "Altecon",      "Altecon Srl" },
    { { 0x00, 0x16, 0x12 }, "OtsukaElectr", "Otsuka Electronics Co., Ltd." },
    { { 0x00, 0x16, 0x13 }, "LibreStreamT", "LibreStream Technologies Inc." },
    { { 0x00, 0x16, 0x14 }, "PicosecondPu", "Picosecond Pulse Labs" },
    { { 0x00, 0x16, 0x15 }, "Nittan",       "Nittan Company, Limited" },
    { { 0x00, 0x16, 0x16 }, "BrowanCommun", "Browan Communications Incorporation" },
    { { 0x00, 0x16, 0x17 }, "Msi",          "Msi" },
    { { 0x00, 0x16, 0x18 }, "HIVION",       "HIVION Co., Ltd." },
    { { 0x00, 0x16, 0x19 }, "LancelanTech", "Lancelan Technologies S.L." },
    { { 0x00, 0x16, 0x1A }, "Dametric",     "Dametric AB" },
    { { 0x00, 0x16, 0x1B }, "Micronet",     "Micronet Corporation" },
    { { 0x00, 0x16, 0x1C }, "ecue",         "e:cue" },
    { { 0x00, 0x16, 0x1D }, "InnovativeWi", "Innovative Wireless Technologies, Inc." },
    { { 0x00, 0x16, 0x1E }, "Woojinnet",    "Woojinnet" },
    { { 0x00, 0x16, 0x1F }, "SUNWAVETEC",   "SUNWAVETEC Co., Ltd." },
    { { 0x00, 0x16, 0x20 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x16, 0x21 }, "ColoradoVnet", "Colorado Vnet" },
    { { 0x00, 0x16, 0x22 }, "Bbh",          "Bbh Systems Gmbh" },
    { { 0x00, 0x16, 0x23 }, "IntervalMedi", "Interval Media" },
    { { 0x00, 0x16, 0x24 }, "Teneros",      "Teneros, Inc." },
    { { 0x00, 0x16, 0x25 }, "Impinj",       "Impinj, Inc." },
    { { 0x00, 0x16, 0x26 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x16, 0x27 }, "embeddedlogi", "embedded-logic DESIGN AND MORE GmbH" },
    { { 0x00, 0x16, 0x28 }, "Magicard",     "Magicard Ltd" },
    { { 0x00, 0x16, 0x29 }, "Nivus",        "Nivus GmbH" },
    { { 0x00, 0x16, 0x2A }, "Antikcompute", "Antik computers & communications s.r.o." },
    { { 0x00, 0x16, 0x2B }, "TogamiElectr", "Togami Electric Mfg.co.,Ltd." },
    { { 0x00, 0x16, 0x2C }, "Xanboo",       "Xanboo" },
    { { 0x00, 0x16, 0x2D }, "STNet",        "STNet Co., Ltd." },
    { { 0x00, 0x16, 0x2E }, "SpaceShuttle", "Space Shuttle Hi-Tech Co., Ltd." },
    { { 0x00, 0x16, 0x2F }, "Geutebrück",   "Geutebrück GmbH" },
    { { 0x00, 0x16, 0x30 }, "VativTechnol", "Vativ Technologies" },
    { { 0x00, 0x16, 0x31 }, "Xteam",        "Xteam" },
    { { 0x00, 0x16, 0x32 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x16, 0x33 }, "OxfordDiagno", "Oxford Diagnostics Ltd." },
    { { 0x00, 0x16, 0x34 }, "Mathtech",     "Mathtech, Inc." },
    { { 0x00, 0x16, 0x35 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x16, 0x36 }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x00, 0x16, 0x37 }, "CITEL",        "CITEL SpA" },
    { { 0x00, 0x16, 0x38 }, "TECOM",        "TECOM Co., Ltd." },
    { { 0x00, 0x16, 0x39 }, "Ubiquam",      "Ubiquam Co., Ltd." },
    { { 0x00, 0x16, 0x3A }, "YvesTechnolo", "Yves Technology Co., Ltd." },
    { { 0x00, 0x16, 0x3B }, "Communicatio", "Communications & Power Industries" },
    { { 0x00, 0x16, 0x3C }, "Rebox",        "Rebox B.V." },
    { { 0x00, 0x16, 0x3D }, "TsinghuaTong", "Tsinghua Tongfang Legend Silicon Tech. Co., Ltd." },
    { { 0x00, 0x16, 0x3E }, "Xensource",    "Xensource, Inc." },
    { { 0x00, 0x16, 0x3F }, "CReTE",        "CReTE SYSTEMS Inc." },
    { { 0x00, 0x16, 0x40 }, "AsmobileComm", "Asmobile Communication Inc." },
    { { 0x00, 0x16, 0x41 }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x00, 0x16, 0x42 }, "Pangolin",     "Pangolin" },
    { { 0x00, 0x16, 0x43 }, "Sunhillo",     "Sunhillo Corporation" },
    { { 0x00, 0x16, 0x44 }, "LITEONTechno", "LITE-ON Technology Corp." },
    { { 0x00, 0x16, 0x45 }, "PowerDistrib", "Power Distribution, Inc." },
    { { 0x00, 0x16, 0x46 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x16, 0x47 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x16, 0x48 }, "SSD",          "SSD Company Limited" },
    { { 0x00, 0x16, 0x49 }, "SetOne",       "SetOne GmbH" },
    { { 0x00, 0x16, 0x4A }, "VibrationTec", "Vibration Technology Limited" },
    { { 0x00, 0x16, 0x4B }, "QuorionData",  "Quorion Data Systems GmbH" },
    { { 0x00, 0x16, 0x4C }, "PLANETINT",    "PLANET INT Co., Ltd" },
    { { 0x00, 0x16, 0x4D }, "AlcatelLucen", "Alcatel-Lucent IPD" },
    { { 0x00, 0x16, 0x4E }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x16, 0x4F }, "WorldEthnicB", "World Ethnic Broadcastin Inc." },
    { { 0x00, 0x16, 0x50 }, "KratosEPD",    "Kratos EPD" },
    { { 0x00, 0x16, 0x51 }, "Exeo",         "Exeo Systems" },
    { { 0x00, 0x16, 0x52 }, "HoatechTechn", "Hoatech Technologies, Inc." },
    { { 0x00, 0x16, 0x53 }, "LEGOSystemIE", "LEGO System A/S IE Electronics Division" },
    { { 0x00, 0x16, 0x54 }, "FlexPIndustr", "Flex-P Industries Sdn. Bhd." },
    { { 0x00, 0x16, 0x55 }, "FUHOTECHNOLO", "FUHO TECHNOLOGY Co., LTD" },
    { { 0x00, 0x16, 0x56 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x16, 0x57 }, "Aegate",       "Aegate Ltd" },
    { { 0x00, 0x16, 0x58 }, "FusiontechTe", "Fusiontech Technologies Inc." },
    { { 0x00, 0x16, 0x59 }, "ZMPRadwag",    "Z.M.P. Radwag" },
    { { 0x00, 0x16, 0x5A }, "HarmanSpecia", "Harman Specialty Group" },
    { { 0x00, 0x16, 0x5B }, "GripAudio",    "Grip Audio" },
    { { 0x00, 0x16, 0x5C }, "Trackflow",    "Trackflow Ltd." },
    { { 0x00, 0x16, 0x5D }, "AirDefense",   "AirDefense, Inc." },
    { { 0x00, 0x16, 0x5E }, "PrecisionIO",  "Precision I/O" },
    { { 0x00, 0x16, 0x5F }, "FairmountAut", "Fairmount Automation" },
    { { 0x00, 0x16, 0x60 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x16, 0x61 }, "NovatiumSolu", "Novatium Solutions (P) Ltd" },
    { { 0x00, 0x16, 0x62 }, "LiyuhTechnol", "Liyuh Technology Ltd." },
    { { 0x00, 0x16, 0x63 }, "KBTMobile",    "KBT Mobile" },
    { { 0x00, 0x16, 0x64 }, "ProdEl",       "Prod-El SpA" },
    { { 0x00, 0x16, 0x65 }, "CellonFrance", "Cellon France" },
    { { 0x00, 0x16, 0x66 }, "QuantierComm", "Quantier Communication Inc." },
    { { 0x00, 0x16, 0x67 }, "ATECSubsyste", "A-TEC Subsystem INC." },
    { { 0x00, 0x16, 0x68 }, "EishinElectr", "Eishin Electronics" },
    { { 0x00, 0x16, 0x69 }, "MRVCommunica", "MRV Communication (Networks) LTD" },
    { { 0x00, 0x16, 0x6A }, "Tps",          "Tps" },
    { { 0x00, 0x16, 0x6B }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x16, 0x6C }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x16, 0x6D }, "YulongComput", "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd" },
    { { 0x00, 0x16, 0x6E }, "Arbitron",     "Arbitron Inc." },
    { { 0x00, 0x16, 0x6F }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x16, 0x70 }, "SKNET",        "SKNET Corporation" },
    { { 0x00, 0x16, 0x71 }, "SymphoxInfor", "Symphox Information Co." },
    { { 0x00, 0x16, 0x72 }, "Zenwayenterp", "Zenway enterprise ltd" },
    { { 0x00, 0x16, 0x73 }, "Bury",         "Bury GmbH & Co. KG" },
    { { 0x00, 0x16, 0x74 }, "EuroCB",       "EuroCB (Phils.), Inc." },
    { { 0x00, 0x16, 0x75 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x16, 0x76 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x16, 0x77 }, "BihlWiedeman", "Bihl + Wiedemann GmbH" },
    { { 0x00, 0x16, 0x78 }, "BaoanGaokeEl", "Shenzhen Baoan Gaoke Electronics Co., Ltd" },
    { { 0x00, 0x16, 0x79 }, "eOnCommunica", "eOn Communications" },
    { { 0x00, 0x16, 0x7A }, "SkyworthOver", "Skyworth Overseas Development Ltd." },
    { { 0x00, 0x16, 0x7B }, "Haver&Boecke", "Haver&Boecker" },
    { { 0x00, 0x16, 0x7C }, "iRexTechnolo", "iRex Technologies BV" },
    { { 0x00, 0x16, 0x7D }, "SkyLineInfor", "Sky-Line Information Co., Ltd." },
    { { 0x00, 0x16, 0x7E }, "Diboss",       "Diboss.Co.,Ltd" },
    { { 0x00, 0x16, 0x7F }, "BluebirdSoft", "Bluebird Soft Inc." },
    { { 0x00, 0x16, 0x80 }, "BallyGaming",  "Bally Gaming + Systems" },
    { { 0x00, 0x16, 0x81 }, "VectorInform", "Vector Informatik GmbH" },
    { { 0x00, 0x16, 0x82 }, "OMSMotion",    "OMS Motion" },
    { { 0x00, 0x16, 0x83 }, "WEBIOInterna", "WEBIO International Co.,.Ltd." },
    { { 0x00, 0x16, 0x84 }, "Donjin",       "Donjin Co.,Ltd." },
    { { 0x00, 0x16, 0x85 }, "Elisa",        "Elisa Oyj" },
    { { 0x00, 0x16, 0x86 }, "KarlStorzIma", "Karl Storz Imaging" },
    { { 0x00, 0x16, 0x87 }, "ChubbCSCVend", "Chubb CSC-Vendor AP" },
    { { 0x00, 0x16, 0x88 }, "ServerEngine", "ServerEngines LLC" },
    { { 0x00, 0x16, 0x89 }, "PilkorElectr", "Pilkor Electronics Co., Ltd" },
    { { 0x00, 0x16, 0x8A }, "idConfirm",    "id-Confirm Inc" },
    { { 0x00, 0x16, 0x8B }, "Paralan",      "Paralan Corporation" },
    { { 0x00, 0x16, 0x8C }, "DSLPartnerAS", "DSL Partner AS" },
    { { 0x00, 0x16, 0x8D }, "KORWIN",       "KORWIN CO., Ltd." },
    { { 0x00, 0x16, 0x8E }, "Vimicro",      "Vimicro corporation" },
    { { 0x00, 0x16, 0x8F }, "GNNetcom",     "GN Netcom A/S" },
    { { 0x00, 0x16, 0x90 }, "JTekIncorpor", "J-Tek Incorporation" },
    { { 0x00, 0x16, 0x91 }, "MoserBaer",    "Moser-Baer AG" },
    { { 0x00, 0x16, 0x92 }, "ScientificAt", "Scientific-Atlanta, Inc." },
    { { 0x00, 0x16, 0x93 }, "PowerLinkTec", "PowerLink Technology Inc." },
    { { 0x00, 0x16, 0x94 }, "SennheiserCo", "Sennheiser Communications A/S" },
    { { 0x00, 0x16, 0x95 }, "AVCTechnolog", "AVC Technology (International) Limited" },
    { { 0x00, 0x16, 0x96 }, "QDITechnolog", "QDI Technology (H.K.) Limited" },
    { { 0x00, 0x16, 0x97 }, "NEC",          "NEC Corporation" },
    { { 0x00, 0x16, 0x98 }, "T&AMobilePho", "T&A Mobile Phones" },
    { { 0x00, 0x16, 0x99 }, "TonicDVBMark", "Tonic DVB Marketing Ltd" },
    { { 0x00, 0x16, 0x9A }, "Quadrics",     "Quadrics Ltd" },
    { { 0x00, 0x16, 0x9B }, "AlstomTransp", "Alstom Transport" },
    { { 0x00, 0x16, 0x9C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x16, 0x9D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x16, 0x9E }, "TVOne",        "TV One Ltd" },
    { { 0x00, 0x16, 0x9F }, "VimtronElect", "Vimtron Electronics Co., Ltd." },
    { { 0x00, 0x16, 0xA0 }, "AutoMaskin",   "Auto-Maskin" },
    { { 0x00, 0x16, 0xA1 }, "3LeafNetwork", "3Leaf Networks" },
    { { 0x00, 0x16, 0xA2 }, "CentraLite",   "CentraLite Systems, Inc." },
    { { 0x00, 0x16, 0xA3 }, "Ingeteam",     "Ingeteam" },
    { { 0x00, 0x16, 0xA4 }, "Ezurio",       "Ezurio Ltd" },
    { { 0x00, 0x16, 0xA5 }, "TandbergStor", "Tandberg Storage ASA" },
    { { 0x00, 0x16, 0xA6 }, "DovadoFZ",     "Dovado FZ-LLC" },
    { { 0x00, 0x16, 0xA7 }, "AwetaG&P",     "Aweta G&P" },
    { { 0x00, 0x16, 0xA8 }, "Cwt",          "Cwt Co., Ltd." },
    { { 0x00, 0x16, 0xA9 }, "2Ei",          "2Ei" },
    { { 0x00, 0x16, 0xAA }, "KeiCommunica", "Kei Communication Technology Inc." },
    { { 0x00, 0x16, 0xAB }, "Dansensor",    "Dansensor A/S" },
    { { 0x00, 0x16, 0xAC }, "TohoTechnolo", "Toho Technology Corp." },
    { { 0x00, 0x16, 0xAD }, "BTLinks",      "BT-Links Company Limited" },
    { { 0x00, 0x16, 0xAE }, "Inventel",     "Inventel" },
    { { 0x00, 0x16, 0xAF }, "UnionNetwork", "Shenzhen Union Networks Equipment Co.,Ltd." },
    { { 0x00, 0x16, 0xB0 }, "VK",           "VK Corporation" },
    { { 0x00, 0x16, 0xB1 }, "Kbs",          "Kbs" },
    { { 0x00, 0x16, 0xB2 }, "DriveCam",     "DriveCam Inc" },
    { { 0x00, 0x16, 0xB3 }, "Photonicbrid", "Photonicbridges (China) Co., Ltd." },
    { { 0x00, 0x16, 0xB4 }, "Private",      "Private" },
    { { 0x00, 0x16, 0xB5 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x16, 0xB6 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x16, 0xB7 }, "SeoulCommtec", "Seoul Commtech" },
    { { 0x00, 0x16, 0xB8 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x16, 0xB9 }, "ProCurveNetw", "ProCurve Networking by HP" },
    { { 0x00, 0x16, 0xBA }, "Weathernews",  "Weathernews Inc." },
    { { 0x00, 0x16, 0xBB }, "LawChainComp", "Law-Chain Computer Technology Co Ltd" },
    { { 0x00, 0x16, 0xBC }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x16, 0xBD }, "ATIIndustria", "ATI Industrial Automation" },
    { { 0x00, 0x16, 0xBE }, "INFRANET",     "INFRANET, Inc." },
    { { 0x00, 0x16, 0xBF }, "PaloDExGroup", "PaloDEx Group Oy" },
    { { 0x00, 0x16, 0xC0 }, "Semtech",      "Semtech Corporation" },
    { { 0x00, 0x16, 0xC1 }, "Eleksen",      "Eleksen Ltd" },
    { { 0x00, 0x16, 0xC2 }, "Avtec",        "Avtec Systems Inc" },
    { { 0x00, 0x16, 0xC3 }, "BA",           "BA Systems Inc" },
    { { 0x00, 0x16, 0xC4 }, "SiRFTechnolo", "SiRF Technology, Inc." },
    { { 0x00, 0x16, 0xC5 }, "XingFengIndu", "Shenzhen Xing Feng Industry Co.,Ltd" },
    { { 0x00, 0x16, 0xC6 }, "NorthAtlanti", "North Atlantic Industries" },
    { { 0x00, 0x16, 0xC7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x16, 0xC8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x16, 0xC9 }, "NATSeattle",   "NAT Seattle, Inc." },
    { { 0x00, 0x16, 0xCA }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x16, 0xCB }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x16, 0xCC }, "XcuteMobile",  "Xcute Mobile Corp." },
    { { 0x00, 0x16, 0xCD }, "HijiHighTech", "Hiji High-Tech Co., Ltd." },
    { { 0x00, 0x16, 0xCE }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x16, 0xCF }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x16, 0xD0 }, "ATechelektro", "ATech elektronika d.o.o." },
    { { 0x00, 0x16, 0xD1 }, "ZAT",          "ZAT a.s." },
    { { 0x00, 0x16, 0xD2 }, "Caspian",      "Caspian" },
    { { 0x00, 0x16, 0xD3 }, "Wistron",      "Wistron Corporation" },
    { { 0x00, 0x16, 0xD4 }, "CompalCommun", "Compal Communications, Inc." },
    { { 0x00, 0x16, 0xD5 }, "Synccom",      "Synccom Co., Ltd" },
    { { 0x00, 0x16, 0xD6 }, "TDATech",      "TDA Tech Pty Ltd" },
    { { 0x00, 0x16, 0xD7 }, "Sunways",      "Sunways AG" },
    { { 0x00, 0x16, 0xD8 }, "Senea",        "Senea AB" },
    { { 0x00, 0x16, 0xD9 }, "NingboBird",   "Ningbo Bird Co.,Ltd." },
    { { 0x00, 0x16, 0xDA }, "FutronicTech", "Futronic Technology Co. Ltd." },
    { { 0x00, 0x16, 0xDB }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x16, 0xDC }, "Archos",       "Archos" },
    { { 0x00, 0x16, 0xDD }, "Gigabeam",     "Gigabeam Corporation" },
    { { 0x00, 0x16, 0xDE }, "FAST",         "FAST Inc" },
    { { 0x00, 0x16, 0xDF }, "Lundinova",    "Lundinova AB" },
    { { 0x00, 0x16, 0xE0 }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x16, 0xE1 }, "SiliconStor",  "SiliconStor, Inc." },
    { { 0x00, 0x16, 0xE2 }, "AmericanFibe", "American Fibertek, Inc." },
    { { 0x00, 0x16, 0xE3 }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x00, 0x16, 0xE4 }, "VanguardSecu", "Vanguard Security Engineering Corp." },
    { { 0x00, 0x16, 0xE5 }, "FordleyDevel", "Fordley Development Limited" },
    { { 0x00, 0x16, 0xE6 }, "GigaByteTech", "Giga-Byte Technology Co.,Ltd." },
    { { 0x00, 0x16, 0xE7 }, "DynamixPromo", "Dynamix Promotions Limited" },
    { { 0x00, 0x16, 0xE8 }, "LumissilMicr", "Lumissil Microsystems" },
    { { 0x00, 0x16, 0xE9 }, "TibaMedical",  "Tiba Medical Inc" },
    { { 0x00, 0x16, 0xEA }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x16, 0xEB }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x16, 0xEC }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x16, 0xED }, "Utility",      "Utility, Inc" },
    { { 0x00, 0x16, 0xEE }, "Royaldigital", "Royaldigital Inc." },
    { { 0x00, 0x16, 0xEF }, "KokoFitness",  "Koko Fitness, Inc." },
    { { 0x00, 0x16, 0xF0 }, "Dell",         "Dell" },
    { { 0x00, 0x16, 0xF1 }, "OmniSense",    "OmniSense, LLC" },
    { { 0x00, 0x16, 0xF2 }, "DmobileSyste", "Dmobile System Co., Ltd." },
    { { 0x00, 0x16, 0xF3 }, "CASTInformat", "CAST Information Co., Ltd" },
    { { 0x00, 0x16, 0xF4 }, "Eidicom",      "Eidicom Co., Ltd." },
    { { 0x00, 0x16, 0xF5 }, "DalianGolden", "Dalian Golden Hualu Digital Technology Co.,Ltd" },
    { { 0x00, 0x16, 0xF6 }, "Nevion",       "Nevion" },
    { { 0x00, 0x16, 0xF7 }, "L3Communicat", "L-3 Communications, Aviation Recorders" },
    { { 0x00, 0x16, 0xF8 }, "AviqtechTech", "Aviqtech Technology Co., Ltd." },
    { { 0x00, 0x16, 0xF9 }, "CETRTAPOTdoo", "CETRTA POT, d.o.o., Kranj" },
    { { 0x00, 0x16, 0xFA }, "ECITelecom",   "ECI Telecom Ltd." },
    { { 0x00, 0x16, 0xFB }, "Mtc",          "Shenzhen Mtc Co Ltd" },
    { { 0x00, 0x16, 0xFC }, "Tohken",       "Tohken Co.,Ltd." },
    { { 0x00, 0x16, 0xFD }, "JatyElectron", "Jaty Electronics" },
    { { 0x00, 0x16, 0xFE }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x16, 0xFF }, "WaminOptocom", "Wamin Optocomm Mfg Corp" },
    { { 0x00, 0x17, 0x00 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x17, 0x01 }, "KDE",          "KDE, Inc." },
    { { 0x00, 0x17, 0x02 }, "OsungMidicom", "Osung Midicom Co., Ltd" },
    { { 0x00, 0x17, 0x03 }, "MOSDANIntern", "MOSDAN Internation Co.,Ltd" },
    { { 0x00, 0x17, 0x04 }, "ShincoElectr", "Shinco Electronics Group Co.,Ltd" },
    { { 0x00, 0x17, 0x05 }, "MethodeElect", "Methode Electronics" },
    { { 0x00, 0x17, 0x06 }, "Techfaithwir", "Techfaithwireless Communication Technology Limited." },
    { { 0x00, 0x17, 0x07 }, "InGrid",       "InGrid, Inc" },
    { { 0x00, 0x17, 0x08 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x17, 0x09 }, "ExaltCommuni", "Exalt Communications" },
    { { 0x00, 0x17, 0x0A }, "InewDigital",  "Inew Digital Company" },
    { { 0x00, 0x17, 0x0B }, "Contela",      "Contela, Inc." },
    { { 0x00, 0x17, 0x0C }, "TwigCom",      "Twig Com Ltd." },
    { { 0x00, 0x17, 0x0D }, "DustNetworks", "Dust Networks Inc." },
    { { 0x00, 0x17, 0x0E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0x0F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0x10 }, "AxyomCore",    "AxyomCore Inc." },
    { { 0x00, 0x17, 0x11 }, "CytivaSweden", "Cytiva Sweden AB" },
    { { 0x00, 0x17, 0x12 }, "ISCOInternat", "ISCO International" },
    { { 0x00, 0x17, 0x13 }, "TigerNetCom",  "Tiger NetCom" },
    { { 0x00, 0x17, 0x14 }, "BRControlsNe", "BR Controls Nederland bv" },
    { { 0x00, 0x17, 0x15 }, "Qstik",        "Qstik" },
    { { 0x00, 0x17, 0x16 }, "QnoTechnolog", "Qno Technology Inc." },
    { { 0x00, 0x17, 0x17 }, "LeicaGeosyst", "Leica Geosystems AG" },
    { { 0x00, 0x17, 0x18 }, "VanscoElectr", "Vansco Electronics Oy" },
    { { 0x00, 0x17, 0x19 }, "AudiocodesUS", "Audiocodes USA, Inc" },
    { { 0x00, 0x17, 0x1A }, "Winegard",     "Winegard Company" },
    { { 0x00, 0x17, 0x1B }, "InnovationLa", "Innovation Lab Corp." },
    { { 0x00, 0x17, 0x1C }, "NTMicroSyste", "NT MicroSystems, Inc." },
    { { 0x00, 0x17, 0x1D }, "Digit",        "Digit" },
    { { 0x00, 0x17, 0x1E }, "TheoBenning",  "Theo Benning GmbH & Co. KG" },
    { { 0x00, 0x17, 0x1F }, "IMV",          "IMV Corporation" },
    { { 0x00, 0x17, 0x20 }, "ImageSensing", "Image Sensing Systems, Inc." },
    { { 0x00, 0x17, 0x21 }, "FITRE",        "FITRE S.p.A." },
    { { 0x00, 0x17, 0x22 }, "HanazederEle", "Hanazeder Electronic GmbH" },
    { { 0x00, 0x17, 0x23 }, "SummitDataCo", "Summit Data Communications" },
    { { 0x00, 0x17, 0x24 }, "StuderProfes", "Studer Professional Audio GmbH" },
    { { 0x00, 0x17, 0x25 }, "LiquidComput", "Liquid Computing" },
    { { 0x00, 0x17, 0x26 }, "m2cElectroni", "m2c Electronic Technology Ltd." },
    { { 0x00, 0x17, 0x27 }, "ThermoRamsey", "Thermo Ramsey Italia s.r.l." },
    { { 0x00, 0x17, 0x28 }, "SelexCommuni", "Selex Communications" },
    { { 0x00, 0x17, 0x29 }, "Ubicod",       "Ubicod Co.LTD" },
    { { 0x00, 0x17, 0x2A }, "ProwareTechn", "Proware Technology Corp.(By Unifosa)" },
    { { 0x00, 0x17, 0x2B }, "GlobalTechno", "Global Technologies Inc." },
    { { 0x00, 0x17, 0x2C }, "TaejinInfote", "Taejin Infotech" },
    { { 0x00, 0x17, 0x2D }, "AxcenPhotoni", "Axcen Photonics Corporation" },
    { { 0x00, 0x17, 0x2E }, "FXC",          "FXC Inc." },
    { { 0x00, 0x17, 0x2F }, "NeuLion",      "NeuLion Incorporated" },
    { { 0x00, 0x17, 0x30 }, "AutomationEl", "Automation Electronics" },
    { { 0x00, 0x17, 0x31 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x17, 0x32 }, "ScienceTechn", "Science-Technical Center \"RISSA\"" },
    { { 0x00, 0x17, 0x33 }, "Sfr",          "Sfr" },
    { { 0x00, 0x17, 0x34 }, "ADCTelecommu", "ADC Telecommunications" },
    { { 0x00, 0x17, 0x35 }, "IntelWireles", "Intel Wireless Network Group" },
    { { 0x00, 0x17, 0x36 }, "iiTron",       "iiTron Inc." },
    { { 0x00, 0x17, 0x37 }, "IndustrieDia", "Industrie Dial Face S.p.A." },
    { { 0x00, 0x17, 0x38 }, "Internationa", "International Business Machines" },
    { { 0x00, 0x17, 0x39 }, "BrightHeadph", "Bright Headphone Electronics Company" },
    { { 0x00, 0x17, 0x3A }, "Cloudastruct", "Cloudastructure Inc" },
    { { 0x00, 0x17, 0x3B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0x3C }, "ExtremeEngin", "Extreme Engineering Solutions" },
    { { 0x00, 0x17, 0x3D }, "Neology",      "Neology" },
    { { 0x00, 0x17, 0x3E }, "LeucotronEqu", "LeucotronEquipamentos Ltda." },
    { { 0x00, 0x17, 0x3F }, "BelkinIntern", "Belkin International Inc." },
    { { 0x00, 0x17, 0x40 }, "BluberiGamin", "Bluberi Gaming Technologies Inc" },
    { { 0x00, 0x17, 0x41 }, "Defidev",      "Defidev" },
    { { 0x00, 0x17, 0x42 }, "Fujitsu",      "Fujitsu Limited" },
    { { 0x00, 0x17, 0x43 }, "Deck",         "Deck Srl" },
    { { 0x00, 0x17, 0x44 }, "Araneo",       "Araneo Ltd." },
    { { 0x00, 0x17, 0x45 }, "INNOTZ",       "INNOTZ CO., Ltd" },
    { { 0x00, 0x17, 0x46 }, "Freedom9",     "Freedom9 Inc." },
    { { 0x00, 0x17, 0x47 }, "Trimble",      "Trimble" },
    { { 0x00, 0x17, 0x48 }, "NeokorosBras", "Neokoros Brasil Ltda" },
    { { 0x00, 0x17, 0x49 }, "HyundaeYongO", "Hyundae Yong-O-Sa Co.,Ltd" },
    { { 0x00, 0x17, 0x4A }, "Socomec",      "Socomec" },
    { { 0x00, 0x17, 0x4B }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x17, 0x4C }, "Millipore",    "Millipore" },
    { { 0x00, 0x17, 0x4D }, "DynamicNetwo", "Dynamic Network Factory, Inc." },
    { { 0x00, 0x17, 0x4E }, "Paramatech",   "Parama-tech Co.,Ltd." },
    { { 0x00, 0x17, 0x4F }, "iCatch",       "iCatch Inc." },
    { { 0x00, 0x17, 0x50 }, "GSIGroupMicr", "GSI Group, MicroE Systems" },
    { { 0x00, 0x17, 0x51 }, "Online",       "Online Corporation" },
    { { 0x00, 0x17, 0x52 }, "DAGS",         "DAGS, Inc" },
    { { 0x00, 0x17, 0x53 }, "nForeTechnol", "nFore Technology Inc." },
    { { 0x00, 0x17, 0x54 }, "ArkinoHiTOP",  "Arkino HiTOP Corporation Limited" },
    { { 0x00, 0x17, 0x55 }, "GESecurity",   "GE Security" },
    { { 0x00, 0x17, 0x56 }, "VinciLabs",    "Vinci Labs Oy" },
    { { 0x00, 0x17, 0x57 }, "RixTechnolog", "Rix Technology Limited" },
    { { 0x00, 0x17, 0x58 }, "ThruVision",   "ThruVision Ltd" },
    { { 0x00, 0x17, 0x59 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0x5A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0x5B }, "ACSSolutions", "ACS Solutions Switzerland Ltd." },
    { { 0x00, 0x17, 0x5C }, "Sharp",        "Sharp Corporation" },
    { { 0x00, 0x17, 0x5D }, "Dongseosyste", "Dongseo system." },
    { { 0x00, 0x17, 0x5E }, "Zed3",         "Zed-3" },
    { { 0x00, 0x17, 0x5F }, "XENOLINKComm", "XENOLINK Communications Co., Ltd." },
    { { 0x00, 0x17, 0x60 }, "NaitoDenseiM", "Naito Densei Machida MFG.CO.,LTD" },
    { { 0x00, 0x17, 0x61 }, "Private",      "Private" },
    { { 0x00, 0x17, 0x62 }, "SolarTechnol", "Solar Technology, Inc." },
    { { 0x00, 0x17, 0x63 }, "Essentia",     "Essentia S.p.A." },
    { { 0x00, 0x17, 0x64 }, "ATMedia",      "ATMedia GmbH" },
    { { 0x00, 0x17, 0x65 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x17, 0x66 }, "AccenseTechn", "Accense Technology, Inc." },
    { { 0x00, 0x17, 0x67 }, "EarforceAS",   "Earforce AS" },
    { { 0x00, 0x17, 0x68 }, "Zinwave",      "Zinwave Ltd" },
    { { 0x00, 0x17, 0x69 }, "Cymphonix",    "Cymphonix Corp" },
    { { 0x00, 0x17, 0x6A }, "AvagoTechnol", "Avago Technologies" },
    { { 0x00, 0x17, 0x6B }, "Kiyon",        "Kiyon, Inc." },
    { { 0x00, 0x17, 0x6C }, "Pivot3",       "Pivot3, Inc." },
    { { 0x00, 0x17, 0x6D }, "Core",         "Core Corporation" },
    { { 0x00, 0x17, 0x6E }, "DucatiSistem", "Ducati Sistemi" },
    { { 0x00, 0x17, 0x6F }, "PAXComputerT", "PAX Computer Technology(Shenzhen) Ltd." },
    { { 0x00, 0x17, 0x70 }, "ArtiIndustri", "Arti Industrial Electronics Ltd." },
    { { 0x00, 0x17, 0x71 }, "APDCommunica", "APD Communications Ltd" },
    { { 0x00, 0x17, 0x72 }, "ASTROStrobel", "ASTRO Strobel Kommunikationssysteme GmbH" },
    { { 0x00, 0x17, 0x73 }, "LaketuneTech", "Laketune Technologies Co. Ltd" },
    { { 0x00, 0x17, 0x74 }, "Elesta",       "Elesta GmbH" },
    { { 0x00, 0x17, 0x75 }, "TTEGermany",   "TTE Germany GmbH" },
    { { 0x00, 0x17, 0x76 }, "MesoScaleDia", "Meso Scale Diagnostics, LLC" },
    { { 0x00, 0x17, 0x77 }, "ObsidianRese", "Obsidian Research Corporation" },
    { { 0x00, 0x17, 0x78 }, "CentralMusic", "Central Music Co." },
    { { 0x00, 0x17, 0x79 }, "QuickTel",     "QuickTel" },
    { { 0x00, 0x17, 0x7A }, "AssaAbloy",    "Assa Abloy Ab" },
    { { 0x00, 0x17, 0x7B }, "AzaleaNetwor", "Azalea Networks inc" },
    { { 0x00, 0x17, 0x7C }, "SmartlinkNet", "Smartlink Network Systems Limited" },
    { { 0x00, 0x17, 0x7D }, "IDTTechnolog", "IDT Technology Limited" },
    { { 0x00, 0x17, 0x7E }, "MeshcomTechn", "Meshcom Technologies Inc." },
    { { 0x00, 0x17, 0x7F }, "WorldsmartRe", "Worldsmart Retech" },
    { { 0x00, 0x17, 0x80 }, "AppliedBiosy", "Applied Biosystems B.V." },
    { { 0x00, 0x17, 0x81 }, "GreystoneDat", "Greystone Data System, Inc." },
    { { 0x00, 0x17, 0x82 }, "LoBenn",       "LoBenn Inc." },
    { { 0x00, 0x17, 0x83 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0x84 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x17, 0x85 }, "SparrElectro", "Sparr Electronics Ltd" },
    { { 0x00, 0x17, 0x86 }, "wisembed",     "wisembed" },
    { { 0x00, 0x17, 0x87 }, "BrotherBroth", "Brother, Brother & Sons ApS" },
    { { 0x00, 0x17, 0x88 }, "PhilipsLight", "Philips Lighting BV" },
    { { 0x00, 0x17, 0x89 }, "Zenitron",     "Zenitron Corporation" },
    { { 0x00, 0x17, 0x8A }, "DartsTechnol", "Darts Technologies Corp." },
    { { 0x00, 0x17, 0x8B }, "TeledyneTech", "Teledyne Technologies Incorporated" },
    { { 0x00, 0x17, 0x8C }, "IndependentW", "Independent Witness, Inc" },
    { { 0x00, 0x17, 0x8D }, "Checkpoint",   "Checkpoint Systems, Inc." },
    { { 0x00, 0x17, 0x8E }, "GunneboCashA", "Gunnebo Cash Automation AB" },
    { { 0x00, 0x17, 0x8F }, "NingboYidong", "Ningbo Yidong Electronic Co.,Ltd." },
    { { 0x00, 0x17, 0x90 }, "HYUNDAIDIGIT", "HYUNDAI DIGITECH Co, Ltd." },
    { { 0x00, 0x17, 0x91 }, "LinTech",      "LinTech GmbH" },
    { { 0x00, 0x17, 0x92 }, "FalcomWirele", "Falcom Wireless Comunications Gmbh" },
    { { 0x00, 0x17, 0x93 }, "Tigi",         "Tigi Corporation" },
    { { 0x00, 0x17, 0x94 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0x95 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0x96 }, "Rittmeyer",    "Rittmeyer AG" },
    { { 0x00, 0x17, 0x97 }, "TelsyElettro", "Telsy Elettronica S.p.A." },
    { { 0x00, 0x17, 0x98 }, "AzonicTechno", "Azonic Technology Co., LTD" },
    { { 0x00, 0x17, 0x99 }, "SmarTire",     "SmarTire Systems Inc." },
    { { 0x00, 0x17, 0x9A }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x17, 0x9B }, "ChantSincere", "Chant Sincere Co.,Ltd" },
    { { 0x00, 0x17, 0x9C }, "DEPRAGSCHULZ", "DEPRAG SCHULZ GMBH u. CO." },
    { { 0x00, 0x17, 0x9D }, "Kelman",       "Kelman Limited" },
    { { 0x00, 0x17, 0x9E }, "Sirit",        "Sirit Inc" },
    { { 0x00, 0x17, 0x9F }, "Apricorn",     "Apricorn" },
    { { 0x00, 0x17, 0xA0 }, "RoboTech",     "RoboTech srl" },
    { { 0x00, 0x17, 0xA1 }, "3soft",        "3soft inc." },
    { { 0x00, 0x17, 0xA2 }, "Camrivox",     "Camrivox Ltd." },
    { { 0x00, 0x17, 0xA3 }, "MIX",          "MIX s.r.l." },
    { { 0x00, 0x17, 0xA4 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x17, 0xA5 }, "RalinkTechno", "Ralink Technology Corp" },
    { { 0x00, 0x17, 0xA6 }, "YosinElectro", "Yosin Electronics Co., Ltd." },
    { { 0x00, 0x17, 0xA7 }, "MobileComput", "Mobile Computing Promotion Consortium" },
    { { 0x00, 0x17, 0xA8 }, "EDM",          "EDM Corporation" },
    { { 0x00, 0x17, 0xA9 }, "Sentivision",  "Sentivision" },
    { { 0x00, 0x17, 0xAA }, "elabexperien", "elab-experience inc." },
    { { 0x00, 0x17, 0xAB }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x17, 0xAC }, "ONeilProduct", "O'Neil Product Development Inc." },
    { { 0x00, 0x17, 0xAD }, "AceNet",       "AceNet Corporation" },
    { { 0x00, 0x17, 0xAE }, "GAITronics",   "GAI-Tronics" },
    { { 0x00, 0x17, 0xAF }, "Enermet",      "Enermet" },
    { { 0x00, 0x17, 0xB0 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x17, 0xB1 }, "ACISTMedical", "ACIST Medical Systems, Inc." },
    { { 0x00, 0x17, 0xB2 }, "SKTelesys",    "SK Telesys" },
    { { 0x00, 0x17, 0xB3 }, "AftekInfosys", "Aftek Infosys Limited" },
    { { 0x00, 0x17, 0xB4 }, "RemoteSecuri", "Remote Security Systems, LLC" },
    { { 0x00, 0x17, 0xB5 }, "Peerless",     "Peerless Systems Corporation" },
    { { 0x00, 0x17, 0xB6 }, "Aquantia",     "Aquantia Corporation" },
    { { 0x00, 0x17, 0xB7 }, "TonzeTechnol", "Tonze Technology Co." },
    { { 0x00, 0x17, 0xB8 }, "Novatron",     "Novatron Co., Ltd." },
    { { 0x00, 0x17, 0xB9 }, "GambroLundia", "Gambro Lundia AB" },
    { { 0x00, 0x17, 0xBA }, "Sedo",         "Sedo Co., Ltd." },
    { { 0x00, 0x17, 0xBB }, "SyrinxIndust", "Syrinx Industrial Electronics" },
    { { 0x00, 0x17, 0xBC }, "TouchtunesMu", "Touchtunes Music Corporation" },
    { { 0x00, 0x17, 0xBD }, "Tibetsystem",  "Tibetsystem" },
    { { 0x00, 0x17, 0xBE }, "TratecTeleco", "Tratec Telecom B.V." },
    { { 0x00, 0x17, 0xBF }, "CoherentRese", "Coherent Research Limited" },
    { { 0x00, 0x17, 0xC0 }, "PureTech",     "PureTech Systems, Inc." },
    { { 0x00, 0x17, 0xC1 }, "CMPrecisionT", "CM Precision Technology LTD." },
    { { 0x00, 0x17, 0xC2 }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x17, 0xC3 }, "KTFTechnolog", "KTF Technologies Inc." },
    { { 0x00, 0x17, 0xC4 }, "QuantaMicros", "Quanta Microsystems, INC." },
    { { 0x00, 0x17, 0xC5 }, "SonicWALL",    "SonicWALL" },
    { { 0x00, 0x17, 0xC6 }, "CrossMatchTe", "Cross Match Technologies Inc" },
    { { 0x00, 0x17, 0xC7 }, "MARAConsulti", "MARA Systems Consulting AB" },
    { { 0x00, 0x17, 0xC8 }, "KYOCERADispl", "KYOCERA Display Corporation" },
    { { 0x00, 0x17, 0xC9 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x17, 0xCA }, "Qisda",        "Qisda Corporation" },
    { { 0x00, 0x17, 0xCB }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x17, 0xCC }, "AlcatelLucen", "Alcatel-Lucent" },
    { { 0x00, 0x17, 0xCD }, "CECWirelessR", "CEC Wireless R&D Ltd." },
    { { 0x00, 0x17, 0xCE }, "ScreenServic", "Screen Service Spa" },
    { { 0x00, 0x17, 0xCF }, "iMCA",         "iMCA-GmbH" },
    { { 0x00, 0x17, 0xD0 }, "OpticomCommu", "Opticom Communications, LLC" },
    { { 0x00, 0x17, 0xD1 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x17, 0xD2 }, "Thinlinx",     "Thinlinx Pty Ltd" },
    { { 0x00, 0x17, 0xD3 }, "EtymoticRese", "Etymotic Research, Inc." },
    { { 0x00, 0x17, 0xD4 }, "MonsoonMulti", "Monsoon Multimedia, Inc" },
    { { 0x00, 0x17, 0xD5 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x17, 0xD6 }, "BluechipsMic", "Bluechips Microhouse Co.,Ltd." },
    { { 0x00, 0x17, 0xD7 }, "IONGeophysic", "ION Geophysical Corporation Inc." },
    { { 0x00, 0x17, 0xD8 }, "MagnumSemico", "Magnum Semiconductor, Inc." },
    { { 0x00, 0x17, 0xD9 }, "AAI",          "AAI Corporation" },
    { { 0x00, 0x17, 0xDA }, "SpansLogic",   "Spans Logic" },
    { { 0x00, 0x17, 0xDB }, "CankoTechnol", "Canko Technologies Inc." },
    { { 0x00, 0x17, 0xDC }, "DaemyungZero", "Daemyung Zero1" },
    { { 0x00, 0x17, 0xDD }, "ClipsalAustr", "Clipsal Australia" },
    { { 0x00, 0x17, 0xDE }, "AdvantageSix", "Advantage Six Ltd" },
    { { 0x00, 0x17, 0xDF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0xE0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x17, 0xE1 }, "DACOSTechnol", "DACOS Technologies Co., Ltd." },
    { { 0x00, 0x17, 0xE2 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x17, 0xE3 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xE4 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xE5 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xE6 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xE7 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xE8 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xE9 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xEA }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xEB }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xEC }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x17, 0xED }, "WooJooIT",     "WooJooIT Ltd." },
    { { 0x00, 0x17, 0xEE }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x17, 0xEF }, "IBM",          "IBM Corp" },
    { { 0x00, 0x17, 0xF0 }, "SZCOMBroadba", "SZCOM Broadband Network Technology Co.,Ltd" },
    { { 0x00, 0x17, 0xF1 }, "RenuElectron", "Renu Electronics Pvt Ltd" },
    { { 0x00, 0x17, 0xF2 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x17, 0xF3 }, "Harris",       "Harris Corporation" },
    { { 0x00, 0x17, 0xF4 }, "ZeronAllianc", "Zeron Alliance" },
    { { 0x00, 0x17, 0xF5 }, "LigNeoptek",   "Lig Neoptek" },
    { { 0x00, 0x17, 0xF6 }, "PyramidMerid", "Pyramid Meriden Inc." },
    { { 0x00, 0x17, 0xF7 }, "CEMSolutions", "CEM Solutions Pvt Ltd" },
    { { 0x00, 0x17, 0xF8 }, "MotechIndust", "Motech Industries Inc." },
    { { 0x00, 0x17, 0xF9 }, "ForcomSp",     "Forcom Sp. z o.o." },
    { { 0x00, 0x17, 0xFA }, "Microsoft",    "Microsoft Corporation" },
    { { 0x00, 0x17, 0xFB }, "Fa",           "Fa" },
    { { 0x00, 0x17, 0xFC }, "Suprema",      "Suprema Inc." },
    { { 0x00, 0x17, 0xFD }, "AmuletHotkey", "Amulet Hotkey" },
    { { 0x00, 0x17, 0xFE }, "TalosSystem",  "Talos System Inc." },
    { { 0x00, 0x17, 0xFF }, "PLAYLINE",     "PLAYLINE Co.,Ltd." },
    { { 0x00, 0x18, 0x00 }, "Unigrand",     "Unigrand Ltd" },
    { { 0x00, 0x18, 0x01 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x18, 0x02 }, "AlphaNetwork", "Alpha Networks Inc." },
    { { 0x00, 0x18, 0x03 }, "ArcSoftShang", "ArcSoft Shanghai Co. LTD" },
    { { 0x00, 0x18, 0x04 }, "ETekDigitalT", "E-Tek Digital Technology Limited" },
    { { 0x00, 0x18, 0x05 }, "InHandNetwor", "Beijing InHand Networking Technology Co.,Ltd." },
    { { 0x00, 0x18, 0x06 }, "HokkeiIndust", "Hokkei Industries Co., Ltd." },
    { { 0x00, 0x18, 0x07 }, "Fanstel",      "Fanstel Corp." },
    { { 0x00, 0x18, 0x08 }, "SightLogix",   "SightLogix, Inc." },
    { { 0x00, 0x18, 0x09 }, "Cresyn",       "Cresyn" },
    { { 0x00, 0x18, 0x0A }, "CiscoMeraki",  "Cisco Meraki" },
    { { 0x00, 0x18, 0x0B }, "BrilliantTel", "Brilliant Telecommunications" },
    { { 0x00, 0x18, 0x0C }, "DZS",          "DZS Inc." },
    { { 0x00, 0x18, 0x0D }, "TerabytesSer", "Terabytes Server Storage Tech Corp" },
    { { 0x00, 0x18, 0x0E }, "Avega",        "Avega Systems" },
    { { 0x00, 0x18, 0x0F }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x18, 0x10 }, "IPTrade",      "IPTrade S.A." },
    { { 0x00, 0x18, 0x11 }, "NeurosTechno", "Neuros Technology International, LLC." },
    { { 0x00, 0x18, 0x12 }, "XinweiTeleco", "Beijing Xinwei Telecom Technology Co., Ltd." },
    { { 0x00, 0x18, 0x13 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x18, 0x14 }, "Mitutoyo",     "Mitutoyo Corporation" },
    { { 0x00, 0x18, 0x15 }, "GZTechnologi", "GZ Technologies, Inc." },
    { { 0x00, 0x18, 0x16 }, "Ubixon",       "Ubixon Co., Ltd." },
    { { 0x00, 0x18, 0x17 }, "DEShawResear", "D. E. Shaw Research, LLC" },
    { { 0x00, 0x18, 0x18 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x18, 0x19 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x18, 0x1A }, "AVerMediaInf", "AVerMedia Information Inc." },
    { { 0x00, 0x18, 0x1B }, "TaiJinMetal",  "TaiJin Metal Co., Ltd." },
    { { 0x00, 0x18, 0x1C }, "Vitec",        "Vitec" },
    { { 0x00, 0x18, 0x1D }, "AsiaElectron", "Asia Electronics Co.,Ltd" },
    { { 0x00, 0x18, 0x1E }, "GDXTechnolog", "GDX Technologies Ltd." },
    { { 0x00, 0x18, 0x1F }, "PalmmicroCom", "Palmmicro Communications" },
    { { 0x00, 0x18, 0x20 }, "w5networks",   "w5networks" },
    { { 0x00, 0x18, 0x21 }, "Sindoricoh",   "Sindoricoh" },
    { { 0x00, 0x18, 0x22 }, "CecTelecom",   "Cec Telecom Co.,Ltd." },
    { { 0x00, 0x18, 0x23 }, "DeltaElectro", "Delta Electronics, Inc." },
    { { 0x00, 0x18, 0x24 }, "KimaldiElect", "Kimaldi Electronics, S.L." },
    { { 0x00, 0x18, 0x25 }, "Private",      "Private" },
    { { 0x00, 0x18, 0x26 }, "CaleAccess",   "Cale Access AB" },
    { { 0x00, 0x18, 0x27 }, "NecUnifiedSo", "Nec Unified Solutions Nederland B.V." },
    { { 0x00, 0x18, 0x28 }, "e2vtechnolog", "e2v technologies (UK) ltd." },
    { { 0x00, 0x18, 0x29 }, "Gatsometer",   "Gatsometer" },
    { { 0x00, 0x18, 0x2A }, "TaiwanVideoM", "Taiwan Video & Monitor" },
    { { 0x00, 0x18, 0x2B }, "Softier",      "Softier" },
    { { 0x00, 0x18, 0x2C }, "AscendNetwor", "Ascend Networks, Inc." },
    { { 0x00, 0x18, 0x2D }, "ArtecDesign",  "Artec Design" },
    { { 0x00, 0x18, 0x2E }, "XStreamHD",    "XStreamHD" },
    { { 0x00, 0x18, 0x2F }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x18, 0x30 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x18, 0x31 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x18, 0x32 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x18, 0x33 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x18, 0x34 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x18, 0x35 }, "ThoratecITC",  "Thoratec / ITC" },
    { { 0x00, 0x18, 0x36 }, "REJ",          "REJ Co.,Ltd" },
    { { 0x00, 0x18, 0x37 }, "UniversalABI", "Universal ABIT Co., Ltd." },
    { { 0x00, 0x18, 0x38 }, "PanAccessCom", "PanAccess Communications,Inc." },
    { { 0x00, 0x18, 0x39 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x18, 0x3A }, "WestellTechn", "Westell Technologies Inc." },
    { { 0x00, 0x18, 0x3B }, "CENITS",       "CENITS Co., Ltd." },
    { { 0x00, 0x18, 0x3C }, "EncoreSoftwa", "Encore Software Limited" },
    { { 0x00, 0x18, 0x3D }, "VertexLink",   "Vertex Link Corporation" },
    { { 0x00, 0x18, 0x3E }, "Digilent",     "Digilent, Inc" },
    { { 0x00, 0x18, 0x3F }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x18, 0x40 }, "3Phoenix",     "3 Phoenix, Inc." },
    { { 0x00, 0x18, 0x41 }, "HighTechComp", "High Tech Computer Corp" },
    { { 0x00, 0x18, 0x42 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x18, 0x43 }, "Dawevision",   "Dawevision Ltd" },
    { { 0x00, 0x18, 0x44 }, "HeadsUpTechn", "Heads Up Technologies, Inc." },
    { { 0x00, 0x18, 0x45 }, "PulsarTeleco", "Pulsar-Telecom LLC." },
    { { 0x00, 0x18, 0x46 }, "Crypto",       "Crypto S.A." },
    { { 0x00, 0x18, 0x47 }, "AceNetTechno", "AceNet Technology Inc." },
    { { 0x00, 0x18, 0x48 }, "VecimaNetwor", "Vecima Networks Inc." },
    { { 0x00, 0x18, 0x49 }, "nVentSchroff", "nVent, Schroff GmbH" },
    { { 0x00, 0x18, 0x4A }, "Catcher",      "Catcher, Inc." },
    { { 0x00, 0x18, 0x4B }, "LasVegasGami", "Las Vegas Gaming, Inc." },
    { { 0x00, 0x18, 0x4C }, "BogenCommuni", "Bogen Communications" },
    { { 0x00, 0x18, 0x4D }, "Netgear",      "Netgear" },
    { { 0x00, 0x18, 0x4E }, "LianheTechno", "Lianhe Technologies, Inc." },
    { { 0x00, 0x18, 0x4F }, "8WaysTechnol", "8 Ways Technology Corp." },
    { { 0x00, 0x18, 0x50 }, "SecfoneKft",   "Secfone Kft" },
    { { 0x00, 0x18, 0x51 }, "SWsoft",       "SWsoft" },
    { { 0x00, 0x18, 0x52 }, "StorLinkSemi", "StorLink Semiconductors, Inc." },
    { { 0x00, 0x18, 0x53 }, "AteraNetwork", "Atera Networks LTD." },
    { { 0x00, 0x18, 0x54 }, "Argard",       "Argard Co., Ltd" },
    { { 0x00, 0x18, 0x55 }, "Aeromaritime", "Aeromaritime Systembau GmbH" },
    { { 0x00, 0x18, 0x56 }, "EyeFi",        "EyeFi, Inc" },
    { { 0x00, 0x18, 0x57 }, "UnileverR&D",  "Unilever R&D" },
    { { 0x00, 0x18, 0x58 }, "TagMaster",    "TagMaster AB" },
    { { 0x00, 0x18, 0x59 }, "StrawberryLi", "Strawberry Linux Co.,Ltd." },
    { { 0x00, 0x18, 0x5A }, "uControl",     "uControl, Inc." },
    { { 0x00, 0x18, 0x5B }, "NetworkChemi", "Network Chemistry, Inc" },
    { { 0x00, 0x18, 0x5C }, "EDSLABTechno", "EDSLAB Technologies" },
    { { 0x00, 0x18, 0x5D }, "TaiguenTechn", "Taiguen Technology (Shen-Zhen) Co., Ltd." },
    { { 0x00, 0x18, 0x5E }, "Nexterm",      "Nexterm Inc." },
    { { 0x00, 0x18, 0x5F }, "TAC",          "TAC Inc." },
    { { 0x00, 0x18, 0x60 }, "SIMTechnolog", "SIM Technology Group Shanghai Simcom Ltd.," },
    { { 0x00, 0x18, 0x61 }, "Ooma",         "Ooma, Inc." },
    { { 0x00, 0x18, 0x62 }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x18, 0x63 }, "VeritechElec", "Veritech Electronics Limited" },
    { { 0x00, 0x18, 0x64 }, "Eaton",        "Eaton Corporation" },
    { { 0x00, 0x18, 0x65 }, "SiemensHealt", "Siemens Healthcare Diagnostics Manufacturing Ltd" },
    { { 0x00, 0x18, 0x66 }, "LeutronVisio", "Leutron Vision" },
    { { 0x00, 0x18, 0x67 }, "DatalogicADC", "Datalogic ADC" },
    { { 0x00, 0x18, 0x68 }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x18, 0x69 }, "Kingjim",      "Kingjim" },
    { { 0x00, 0x18, 0x6A }, "GlobalLinkDi", "Global Link Digital Technology Co,.LTD" },
    { { 0x00, 0x18, 0x6B }, "SambuCommuni", "Sambu Communics CO., LTD." },
    { { 0x00, 0x18, 0x6C }, "Neonode",      "Neonode AB" },
    { { 0x00, 0x18, 0x6D }, "ZhenjiangSap", "Zhenjiang Sapphire Electronic Industry CO." },
    { { 0x00, 0x18, 0x6E }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x18, 0x6F }, "SethaIndustr", "Setha Industria Eletronica LTDA" },
    { { 0x00, 0x18, 0x70 }, "E28Shanghai",  "E28 Shanghai Limited" },
    { { 0x00, 0x18, 0x71 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x18, 0x72 }, "ExpertiseEng", "Expertise Engineering" },
    { { 0x00, 0x18, 0x73 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x18, 0x74 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x18, 0x75 }, "AnaCiseTestn", "AnaCise Testnology Pte Ltd" },
    { { 0x00, 0x18, 0x76 }, "WowWee",       "WowWee Ltd." },
    { { 0x00, 0x18, 0x77 }, "Amplex",       "Amplex A/S" },
    { { 0x00, 0x18, 0x78 }, "Mackware",     "Mackware GmbH" },
    { { 0x00, 0x18, 0x79 }, "dSys",         "dSys" },
    { { 0x00, 0x18, 0x7A }, "Wiremold",     "Wiremold" },
    { { 0x00, 0x18, 0x7B }, "4NSYS",        "4NSYS Co. Ltd." },
    { { 0x00, 0x18, 0x7C }, "Intercross",   "Intercross, Llc" },
    { { 0x00, 0x18, 0x7D }, "Armorlink",    "Armorlink Co.Ltd" },
    { { 0x00, 0x18, 0x7E }, "RGBSpectrum",  "RGB Spectrum" },
    { { 0x00, 0x18, 0x7F }, "Zodianet",     "Zodianet" },
    { { 0x00, 0x18, 0x80 }, "MaximIntegra", "Maxim Integrated Products" },
    { { 0x00, 0x18, 0x81 }, "BuyangElectr", "Buyang Electronics Industrial Co., Ltd" },
    { { 0x00, 0x18, 0x82 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x18, 0x83 }, "Formosa21",    "Formosa21 Inc." },
    { { 0x00, 0x18, 0x84 }, "FonTechnolog", "Fon Technology S.L." },
    { { 0x00, 0x18, 0x85 }, "MotorolaSolu", "Motorola Solutions Inc." },
    { { 0x00, 0x18, 0x86 }, "ElTech",       "El-Tech, Inc." },
    { { 0x00, 0x18, 0x87 }, "Metasystem",   "Metasystem SpA" },
    { { 0x00, 0x18, 0x88 }, "GOTIVE",       "GOTIVE a.s." },
    { { 0x00, 0x18, 0x89 }, "WinNetSoluti", "WinNet Solutions Limited" },
    { { 0x00, 0x18, 0x8A }, "Infinova",     "Infinova LLC" },
    { { 0x00, 0x18, 0x8B }, "Dell",         "Dell Inc." },
    { { 0x00, 0x18, 0x8C }, "MobileAction", "Mobile Action Technology Inc." },
    { { 0x00, 0x18, 0x8D }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x18, 0x8E }, "Ekahau",       "Ekahau, Inc." },
    { { 0x00, 0x18, 0x8F }, "MontgomeryTe", "Montgomery Technology, Inc." },
    { { 0x00, 0x18, 0x90 }, "RadioCOMsro",  "RadioCOM, s.r.o." },
    { { 0x00, 0x18, 0x91 }, "ZhongshanGen", "Zhongshan General K-mate Electronics Co., Ltd" },
    { { 0x00, 0x18, 0x92 }, "adstec",       "ads-tec GmbH" },
    { { 0x00, 0x18, 0x93 }, "PhotonBroadb", "Shenzhen Photon Broadband Technology Co.,Ltd" },
    { { 0x00, 0x18, 0x94 }, "NPCore",       "NPCore, Inc." },
    { { 0x00, 0x18, 0x95 }, "HansunTechno", "Hansun Technologies Inc." },
    { { 0x00, 0x18, 0x96 }, "GreatWellEle", "Great Well Electronic LTD" },
    { { 0x00, 0x18, 0x97 }, "JESSLINKPROD", "JESS-LINK PRODUCTS Co., LTD" },
    { { 0x00, 0x18, 0x98 }, "KingstateEle", "Kingstate Electronics Corporation" },
    { { 0x00, 0x18, 0x99 }, "jieshunScien", "ShenZhen jieshun Science&Technology Industry CO,LTD." },
    { { 0x00, 0x18, 0x9A }, "HANAMicron",   "HANA Micron Inc." },
    { { 0x00, 0x18, 0x9B }, "Thomson",      "Thomson Inc." },
    { { 0x00, 0x18, 0x9C }, "Weldex",       "Weldex Corporation" },
    { { 0x00, 0x18, 0x9D }, "Navcast",      "Navcast Inc." },
    { { 0x00, 0x18, 0x9E }, "OMNIKEY",      "OMNIKEY GmbH." },
    { { 0x00, 0x18, 0x9F }, "Lenntek",      "Lenntek Corporation" },
    { { 0x00, 0x18, 0xA0 }, "CiermaAscens", "Cierma Ascenseurs" },
    { { 0x00, 0x18, 0xA1 }, "TiqitCompute", "Tiqit Computers, Inc." },
    { { 0x00, 0x18, 0xA2 }, "XIPTechnolog", "XIP Technology AB" },
    { { 0x00, 0x18, 0xA3 }, "ZippyTechnol", "Zippy Technology Corp." },
    { { 0x00, 0x18, 0xA4 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x18, 0xA5 }, "ADigitTechno", "ADigit Technologies Corp." },
    { { 0x00, 0x18, 0xA6 }, "Persistent",   "Persistent Systems, LLC" },
    { { 0x00, 0x18, 0xA7 }, "YoggieSecuri", "Yoggie Security Systems LTD." },
    { { 0x00, 0x18, 0xA8 }, "AnNealTechno", "AnNeal Technology Inc." },
    { { 0x00, 0x18, 0xA9 }, "EthernetDire", "Ethernet Direct Corporation" },
    { { 0x00, 0x18, 0xAA }, "ProtecFireDe", "Protec Fire Detection plc" },
    { { 0x00, 0x18, 0xAB }, "LhwtMicroele", "Beijing Lhwt Microelectronics Inc." },
    { { 0x00, 0x18, 0xAC }, "JiaoDaHISYST", "Shanghai Jiao Da HISYS Technology Co. Ltd." },
    { { 0x00, 0x18, 0xAD }, "NidecInstrum", "Nidec Instruments Corporation" },
    { { 0x00, 0x18, 0xAE }, "Tvt",          "Tvt Co.,Ltd" },
    { { 0x00, 0x18, 0xAF }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x18, 0xB0 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x18, 0xB1 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x18, 0xB2 }, "AdeunisRf",    "Adeunis Rf" },
    { { 0x00, 0x18, 0xB3 }, "TECWizHome",   "TEC WizHome Co., Ltd." },
    { { 0x00, 0x18, 0xB4 }, "DawonMedia",   "Dawon Media Inc." },
    { { 0x00, 0x18, 0xB5 }, "MagnaCarta",   "Magna Carta" },
    { { 0x00, 0x18, 0xB6 }, "S3C",          "S3C, Inc." },
    { { 0x00, 0x18, 0xB7 }, "D3Led",        "D3 Led, Llc" },
    { { 0x00, 0x18, 0xB8 }, "NewVoiceInte", "New Voice International AG" },
    { { 0x00, 0x18, 0xB9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x18, 0xBA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x18, 0xBB }, "EliwellContr", "Eliwell Controls srl" },
    { { 0x00, 0x18, 0xBC }, "ZAONVPBolid",  "ZAO NVP Bolid" },
    { { 0x00, 0x18, 0xBD }, "DvbworldTech", "Shenzhen Dvbworld Technology Co., Ltd." },
    { { 0x00, 0x18, 0xBE }, "ANSA",         "ANSA Corporation" },
    { { 0x00, 0x18, 0xBF }, "EssenceTechn", "Essence Technology Solution, Inc." },
    { { 0x00, 0x18, 0xC0 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x18, 0xC1 }, "AlmitecInfor", "Almitec Informática e Comércio" },
    { { 0x00, 0x18, 0xC2 }, "Firetide",     "Firetide, Inc" },
    { { 0x00, 0x18, 0xC3 }, "CS",           "CS Corporation" },
    { { 0x00, 0x18, 0xC4 }, "RabaTechnolo", "Raba Technologies LLC" },
    { { 0x00, 0x18, 0xC5 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x18, 0xC6 }, "OPWFuelManag", "OPW Fuel Management Systems" },
    { { 0x00, 0x18, 0xC7 }, "RealTimeAuto", "Real Time Automation" },
    { { 0x00, 0x18, 0xC8 }, "ISONAS",       "ISONAS Inc." },
    { { 0x00, 0x18, 0xC9 }, "EOpsTechnolo", "EOps Technology Limited" },
    { { 0x00, 0x18, 0xCA }, "Viprinet",     "Viprinet GmbH" },
    { { 0x00, 0x18, 0xCB }, "TecobestTech", "Tecobest Technology Limited" },
    { { 0x00, 0x18, 0xCC }, "AxiohmSas",    "Axiohm Sas" },
    { { 0x00, 0x18, 0xCD }, "EraeElectron", "Erae Electronics Industry Co., Ltd" },
    { { 0x00, 0x18, 0xCE }, "Dreamtech",    "Dreamtech Co., Ltd" },
    { { 0x00, 0x18, 0xCF }, "BaldorElectr", "Baldor Electric Company" },
    { { 0x00, 0x18, 0xD0 }, "AtRoadATrimb", "AtRoad, A Trimble Company" },
    { { 0x00, 0x18, 0xD1 }, "SiemensHomeO", "Siemens Home & Office Comm. Devices" },
    { { 0x00, 0x18, 0xD2 }, "HighGainAnte", "High-Gain Antennas LLC" },
    { { 0x00, 0x18, 0xD3 }, "Teamcast",     "Teamcast" },
    { { 0x00, 0x18, 0xD4 }, "UnifiedDispl", "Unified Display Interface SIG" },
    { { 0x00, 0x18, 0xD5 }, "Reigncom",     "Reigncom" },
    { { 0x00, 0x18, 0xD6 }, "Swirlnet",     "Swirlnet A/S" },
    { { 0x00, 0x18, 0xD7 }, "JAVADGNSS",    "JAVAD GNSS, Inc." },
    { { 0x00, 0x18, 0xD8 }, "ARCHMETER",    "ARCH METER Corporation" },
    { { 0x00, 0x18, 0xD9 }, "SantoshaInte", "Santosha Internatonal, Inc" },
    { { 0x00, 0x18, 0xDA }, "WürthElektro", "Würth Elektronik eiSos GmbH & Co. KG" },
    { { 0x00, 0x18, 0xDB }, "EPLTechnolog", "EPL Technology Ltd" },
    { { 0x00, 0x18, 0xDC }, "Prostar",      "Prostar Co., Ltd." },
    { { 0x00, 0x18, 0xDD }, "SilicondustE", "Silicondust Engineering Ltd" },
    { { 0x00, 0x18, 0xDE }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x18, 0xDF }, "Morey",        "The Morey Corporation" },
    { { 0x00, 0x18, 0xE0 }, "Anaveo",       "Anaveo" },
    { { 0x00, 0x18, 0xE1 }, "VerkerkServi", "Verkerk Service Systemen" },
    { { 0x00, 0x18, 0xE2 }, "TopdataSiste", "Topdata Sistemas de Automacao Ltda" },
    { { 0x00, 0x18, 0xE3 }, "Visualgate",   "Visualgate Systems, Inc." },
    { { 0x00, 0x18, 0xE4 }, "Yiguang",      "Yiguang" },
    { { 0x00, 0x18, 0xE5 }, "Adhoco",       "Adhoco AG" },
    { { 0x00, 0x18, 0xE6 }, "ComputerHard", "Computer Hardware Design SIA" },
    { { 0x00, 0x18, 0xE7 }, "CameoCommuni", "Cameo Communications, INC." },
    { { 0x00, 0x18, 0xE8 }, "Hacetron",     "Hacetron Corporation" },
    { { 0x00, 0x18, 0xE9 }, "Numata",       "Numata Corporation" },
    { { 0x00, 0x18, 0xEA }, "Alltec",       "Alltec GmbH" },
    { { 0x00, 0x18, 0xEB }, "BlueZenEnter", "Blue Zen Enterprises Private Limited" },
    { { 0x00, 0x18, 0xEC }, "WeldingTechn", "Welding Technology Corporation" },
    { { 0x00, 0x18, 0xED }, "AccutechUltr", "Accutech Ultrasystems Co., Ltd." },
    { { 0x00, 0x18, 0xEE }, "VideologyIma", "Videology Imaging Solutions, Inc." },
    { { 0x00, 0x18, 0xEF }, "EscapeCommun", "Escape Communications, Inc." },
    { { 0x00, 0x18, 0xF0 }, "JOYTOTO",      "JOYTOTO Co., Ltd." },
    { { 0x00, 0x18, 0xF1 }, "ChunichiDens", "Chunichi Denshi Co.,LTD." },
    { { 0x00, 0x18, 0xF2 }, "TianyuCommun", "Beijing Tianyu Communication Equipment Co., Ltd" },
    { { 0x00, 0x18, 0xF3 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x18, 0xF4 }, "EOTECHNICS",   "EO TECHNICS Co., Ltd." },
    { { 0x00, 0x18, 0xF5 }, "StreamingVid", "Shenzhen Streaming Video Technology Company Limited" },
    { { 0x00, 0x18, 0xF6 }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x18, 0xF7 }, "KameleonTech", "Kameleon Technologies" },
    { { 0x00, 0x18, 0xF8 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x18, 0xF9 }, "VVOND",        "VVOND, Inc." },
    { { 0x00, 0x18, 0xFA }, "YushinPrecis", "Yushin Precision Equipment Co.,Ltd." },
    { { 0x00, 0x18, 0xFB }, "ComproTechno", "Compro Technology" },
    { { 0x00, 0x18, 0xFC }, "AltecElectro", "Altec Electronic AG" },
    { { 0x00, 0x18, 0xFD }, "OptimalTechn", "Optimal Technologies International Inc." },
    { { 0x00, 0x18, 0xFE }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x18, 0xFF }, "PowerQuattro", "PowerQuattro Co." },
    { { 0x00, 0x19, 0x00 }, "Intelliveres", "Intelliverese - DBA Voicecom" },
    { { 0x00, 0x19, 0x01 }, "F1Media",      "F1Media" },
    { { 0x00, 0x19, 0x02 }, "CambridgeCon", "Cambridge Consultants Ltd" },
    { { 0x00, 0x19, 0x03 }, "BigfootNetwo", "Bigfoot Networks Inc" },
    { { 0x00, 0x19, 0x04 }, "WBElectronic", "WB Electronics Sp. z o.o." },
    { { 0x00, 0x19, 0x05 }, "SCHRACKSecon", "SCHRACK Seconet AG" },
    { { 0x00, 0x19, 0x06 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0x07 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0x08 }, "Duaxes",       "Duaxes Corporation" },
    { { 0x00, 0x19, 0x09 }, "DEVIDanfoss",  "DEVI - Danfoss A/S" },
    { { 0x00, 0x19, 0x0A }, "Hasware",      "Hasware Inc." },
    { { 0x00, 0x19, 0x0B }, "SouthernVisi", "Southern Vision Systems, Inc." },
    { { 0x00, 0x19, 0x0C }, "EncoreElectr", "Encore Electronics, Inc." },
    { { 0x00, 0x19, 0x0D }, "IEEE1394c",    "IEEE 1394c" },
    { { 0x00, 0x19, 0x0E }, "AtechTechnol", "Atech Technology Co., Ltd." },
    { { 0x00, 0x19, 0x0F }, "Advansus",     "Advansus Corp." },
    { { 0x00, 0x19, 0x10 }, "KnickElektro", "Knick Elektronische Messgeraete GmbH & Co. KG" },
    { { 0x00, 0x19, 0x11 }, "JustInMobile", "Just In Mobile Information Technologies (Shanghai) Co., Ltd." },
    { { 0x00, 0x19, 0x12 }, "Welcat",       "Welcat Inc" },
    { { 0x00, 0x19, 0x13 }, "ChuangYiNetw", "Chuang-Yi Network Equipment Co.Ltd." },
    { { 0x00, 0x19, 0x14 }, "Winix",        "Winix Co., Ltd" },
    { { 0x00, 0x19, 0x15 }, "TECOM",        "TECOM Co., Ltd." },
    { { 0x00, 0x19, 0x16 }, "PayTec",       "PayTec AG" },
    { { 0x00, 0x19, 0x17 }, "Posiflex",     "Posiflex Inc." },
    { { 0x00, 0x19, 0x18 }, "InteractiveW", "Interactive Wear AG" },
    { { 0x00, 0x19, 0x19 }, "ASTEL",        "ASTEL Inc." },
    { { 0x00, 0x19, 0x1A }, "Irlink",       "Irlink" },
    { { 0x00, 0x19, 0x1B }, "SputnikEngin", "Sputnik Engineering AG" },
    { { 0x00, 0x19, 0x1C }, "Sensicast",    "Sensicast Systems" },
    { { 0x00, 0x19, 0x1D }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x19, 0x1E }, "Beyondwiz",    "Beyondwiz Co., Ltd." },
    { { 0x00, 0x19, 0x1F }, "Microlinkcom", "Microlink communications Inc." },
    { { 0x00, 0x19, 0x20 }, "KUMEelectric", "KUME electric Co.,Ltd." },
    { { 0x00, 0x19, 0x21 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x19, 0x22 }, "CMComandosLi", "CM Comandos Lineares" },
    { { 0x00, 0x19, 0x23 }, "PhonexKorea",  "Phonex Korea Co., LTD." },
    { { 0x00, 0x19, 0x24 }, "LBNLEngineer", "LBNL Engineering" },
    { { 0x00, 0x19, 0x25 }, "Intelicis",    "Intelicis Corporation" },
    { { 0x00, 0x19, 0x26 }, "BitsGen",      "BitsGen Co., Ltd." },
    { { 0x00, 0x19, 0x27 }, "ImCoSys",      "ImCoSys Ltd" },
    { { 0x00, 0x19, 0x28 }, "SiemensTrans", "Siemens AG, Transportation Systems" },
    { { 0x00, 0x19, 0x29 }, "2M2BMontador", "2M2B Montadora de Maquinas Bahia Brasil LTDA" },
    { { 0x00, 0x19, 0x2A }, "AntiopeAssoc", "Antiope Associates" },
    { { 0x00, 0x19, 0x2B }, "AclaraRF",     "Aclara RF Systems Inc." },
    { { 0x00, 0x19, 0x2C }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x19, 0x2D }, "Nokia",        "Nokia Corporation" },
    { { 0x00, 0x19, 0x2E }, "SpectralInst", "Spectral Instruments, Inc." },
    { { 0x00, 0x19, 0x2F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0x30 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0x31 }, "Balluff",      "Balluff GmbH" },
    { { 0x00, 0x19, 0x32 }, "Gude",         "Gude Systems GmbH" },
    { { 0x00, 0x19, 0x33 }, "Strix",        "Strix Systems, Inc." },
    { { 0x00, 0x19, 0x34 }, "TrendonTouch", "Trendon Touch Technology Corp." },
    { { 0x00, 0x19, 0x35 }, "DuerrDental",  "Duerr Dental Ag" },
    { { 0x00, 0x19, 0x36 }, "SterliteOpti", "Sterlite Optical Technologies Limited" },
    { { 0x00, 0x19, 0x37 }, "CommerceGuar", "CommerceGuard AB" },
    { { 0x00, 0x19, 0x38 }, "UMBCommunica", "UMB Communications Co., Ltd." },
    { { 0x00, 0x19, 0x39 }, "Gigamips",     "Gigamips" },
    { { 0x00, 0x19, 0x3A }, "Oesolutions",  "Oesolutions" },
    { { 0x00, 0x19, 0x3B }, "LigoWave",     "LigoWave" },
    { { 0x00, 0x19, 0x3C }, "HighPointTec", "HighPoint Technologies Incorporated" },
    { { 0x00, 0x19, 0x3D }, "GMCGuardianM", "GMC Guardian Mobility Corp." },
    { { 0x00, 0x19, 0x3E }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x19, 0x3F }, "RDItechnolog", "RDI technology(Shenzhen) Co.,LTD" },
    { { 0x00, 0x19, 0x40 }, "Rackable",     "Rackable Systems" },
    { { 0x00, 0x19, 0x41 }, "PitneyBowes",  "Pitney Bowes, Inc" },
    { { 0x00, 0x19, 0x42 }, "OnSoftwareIn", "On Software International Limited" },
    { { 0x00, 0x19, 0x43 }, "Belden",       "Belden" },
    { { 0x00, 0x19, 0x44 }, "FossilPartne", "Fossil Partners, L.P." },
    { { 0x00, 0x19, 0x45 }, "RFCOncepts",   "RF COncepts, LLC" },
    { { 0x00, 0x19, 0x46 }, "CianetIndust", "Cianet Industria e Comercio S/A" },
    { { 0x00, 0x19, 0x47 }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x19, 0x48 }, "AireSpiderNe", "AireSpider Networks" },
    { { 0x00, 0x19, 0x49 }, "TentelComtec", "Tentel Comtech Co., Ltd." },
    { { 0x00, 0x19, 0x4A }, "Testo",        "Testo Ag" },
    { { 0x00, 0x19, 0x4B }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x19, 0x4C }, "FujianStelco", "Fujian Stelcom information & Technology CO.,Ltd" },
    { { 0x00, 0x19, 0x4D }, "AvagoTechnol", "Avago Technologies Sdn Bhd" },
    { { 0x00, 0x19, 0x4E }, "UltraElectro", "Ultra Electronics - TCS (Tactical Communication Systems)" },
    { { 0x00, 0x19, 0x4F }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x19, 0x50 }, "HarmanMultim", "Harman Multimedia" },
    { { 0x00, 0x19, 0x51 }, "NETCONSsro",   "NETCONS, s.r.o." },
    { { 0x00, 0x19, 0x52 }, "ACOGITO",      "ACOGITO Co., Ltd" },
    { { 0x00, 0x19, 0x53 }, "ChainleaderC", "Chainleader Communications Corp." },
    { { 0x00, 0x19, 0x54 }, "Leaf",         "Leaf Corporation." },
    { { 0x00, 0x19, 0x55 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0x56 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0x57 }, "SaafnetCanad", "Saafnet Canada Inc." },
    { { 0x00, 0x19, 0x58 }, "BluetoothSIG", "Bluetooth SIG, Inc." },
    { { 0x00, 0x19, 0x59 }, "StaccatoComm", "Staccato Communications Inc." },
    { { 0x00, 0x19, 0x5A }, "JenaerAntrie", "Jenaer Antriebstechnik GmbH" },
    { { 0x00, 0x19, 0x5B }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x19, 0x5C }, "Innotech",     "Innotech Corporation" },
    { { 0x00, 0x19, 0x5D }, "XinHuaTongOp", "ShenZhen XinHuaTong Opto Electronics Co.,Ltd" },
    { { 0x00, 0x19, 0x5E }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x19, 0x5F }, "ValemountNet", "Valemount Networks Corporation" },
    { { 0x00, 0x19, 0x60 }, "DoCoMo",       "DoCoMo Systems, Inc." },
    { { 0x00, 0x19, 0x61 }, "BlaupunktEmb", "Blaupunkt Embedded Systems GmbH" },
    { { 0x00, 0x19, 0x62 }, "CommerciantL", "Commerciant, LP" },
    { { 0x00, 0x19, 0x63 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x19, 0x64 }, "Doorking",     "Doorking Inc." },
    { { 0x00, 0x19, 0x65 }, "YuHuaTelTech", "YuHua TelTech (ShangHai) Co., Ltd." },
    { { 0x00, 0x19, 0x66 }, "AsiarockTech", "Asiarock Technology Limited" },
    { { 0x00, 0x19, 0x67 }, "TELDATSpJ",    "TELDAT Sp.J." },
    { { 0x00, 0x19, 0x68 }, "DigitalVideo", "Digital Video Networks(Shanghai) CO. LTD." },
    { { 0x00, 0x19, 0x69 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x19, 0x6A }, "MikroM",       "MikroM GmbH" },
    { { 0x00, 0x19, 0x6B }, "Danpex",       "Danpex Corporation" },
    { { 0x00, 0x19, 0x6C }, "EtrovisionTe", "Etrovision Technology" },
    { { 0x00, 0x19, 0x6D }, "RaybitKorea",  "Raybit Systems Korea, Inc" },
    { { 0x00, 0x19, 0x6E }, "Metacom",      "Metacom (Pty) Ltd." },
    { { 0x00, 0x19, 0x6F }, "SensoPart",    "SensoPart GmbH" },
    { { 0x00, 0x19, 0x70 }, "ZCom",         "Z-Com, Inc." },
    { { 0x00, 0x19, 0x71 }, "GuangzhouUni", "Guangzhou Unicomp Technology Co.,Ltd" },
    { { 0x00, 0x19, 0x72 }, "Plexus",       "Plexus (Xiamen) Co.,ltd." },
    { { 0x00, 0x19, 0x73 }, "Zeugma",       "Zeugma Systems" },
    { { 0x00, 0x19, 0x74 }, "16063",        "16063" },
    { { 0x00, 0x19, 0x75 }, "Huisennetwor", "Beijing Huisen networks technology Inc" },
    { { 0x00, 0x19, 0x76 }, "XipherTechno", "Xipher Technologies, LLC" },
    { { 0x00, 0x19, 0x77 }, "ExtremeNetwo", "Extreme Networks Headquarters" },
    { { 0x00, 0x19, 0x78 }, "Datum",        "Datum Systems, Inc." },
    { { 0x00, 0x19, 0x79 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x19, 0x7A }, "MAZeT",        "MAZeT GmbH" },
    { { 0x00, 0x19, 0x7B }, "Picotest",     "Picotest Corp." },
    { { 0x00, 0x19, 0x7C }, "RiedelCommun", "Riedel Communications GmbH" },
    { { 0x00, 0x19, 0x7D }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x19, 0x7E }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x19, 0x7F }, "Plantronics",  "Plantronics, Inc." },
    { { 0x00, 0x19, 0x80 }, "Gridpoint",    "Gridpoint Systems" },
    { { 0x00, 0x19, 0x81 }, "Vivox",        "Vivox Inc" },
    { { 0x00, 0x19, 0x82 }, "SmarDTV",      "SmarDTV Corporation" },
    { { 0x00, 0x19, 0x83 }, "CCTR&D",       "CCT R&D Limited" },
    { { 0x00, 0x19, 0x84 }, "ESTIC",        "ESTIC Corporation" },
    { { 0x00, 0x19, 0x85 }, "ITWatchdogs",  "IT Watchdogs, Inc" },
    { { 0x00, 0x19, 0x86 }, "ChengHongjia", "Cheng Hongjian" },
    { { 0x00, 0x19, 0x87 }, "PanasonicMob", "Panasonic Mobile Communications Co.,Ltd." },
    { { 0x00, 0x19, 0x88 }, "Wi2Wi",        "Wi2Wi, Inc" },
    { { 0x00, 0x19, 0x89 }, "Sonitrol",     "Sonitrol Corporation" },
    { { 0x00, 0x19, 0x8A }, "NorthropGrum", "Northrop Grumman Systems Corp." },
    { { 0x00, 0x19, 0x8B }, "NoveraOptics", "Novera Optics Korea, Inc." },
    { { 0x00, 0x19, 0x8C }, "iXSea",        "iXSea" },
    { { 0x00, 0x19, 0x8D }, "OceanOptics",  "Ocean Optics, Inc." },
    { { 0x00, 0x19, 0x8E }, "Demant",       "Demant A/S" },
    { { 0x00, 0x19, 0x8F }, "NokiaBell",    "Nokia Bell N.V." },
    { { 0x00, 0x19, 0x90 }, "ELMDATA",      "ELM DATA Co., Ltd." },
    { { 0x00, 0x19, 0x91 }, "avinfo",       "avinfo" },
    { { 0x00, 0x19, 0x92 }, "Adtran",       "Adtran Inc" },
    { { 0x00, 0x19, 0x93 }, "ChangshuSwit", "Changshu Switchgear MFG. Co.,Ltd. (Former Changshu Switchgea" },
    { { 0x00, 0x19, 0x94 }, "JorjinTechno", "Jorjin Technologies Inc." },
    { { 0x00, 0x19, 0x95 }, "JurongHiTech", "Jurong Hi-Tech (Suzhou)Co.ltd" },
    { { 0x00, 0x19, 0x96 }, "TurboChefTec", "TurboChef Technologies Inc." },
    { { 0x00, 0x19, 0x97 }, "SoftDeviceSd", "Soft Device Sdn Bhd" },
    { { 0x00, 0x19, 0x98 }, "Sato",         "Sato Corporation" },
    { { 0x00, 0x19, 0x99 }, "FujitsuTechn", "Fujitsu Technology Solutions GmbH" },
    { { 0x00, 0x19, 0x9A }, "EdoEvi",       "Edo-Evi" },
    { { 0x00, 0x19, 0x9B }, "DiversifiedT", "Diversified Technical Systems, Inc." },
    { { 0x00, 0x19, 0x9C }, "Ctring",       "Ctring" },
    { { 0x00, 0x19, 0x9D }, "Vizio",        "Vizio, Inc" },
    { { 0x00, 0x19, 0x9E }, "Nifty",        "Nifty" },
    { { 0x00, 0x19, 0x9F }, "Dkt",          "Dkt A/S" },
    { { 0x00, 0x19, 0xA0 }, "NihonDataSys", "Nihon Data Systens, Inc." },
    { { 0x00, 0x19, 0xA1 }, "LgInformatio", "Lg Information & Comm." },
    { { 0x00, 0x19, 0xA2 }, "OrdynTechnol", "Ordyn Technologies" },
    { { 0x00, 0x19, 0xA3 }, "asteelelectr", "asteel electronique atlantique" },
    { { 0x00, 0x19, 0xA4 }, "AustarTechno", "Austar Technology (hang zhou) Co.,Ltd" },
    { { 0x00, 0x19, 0xA5 }, "RadarFind",    "RadarFind Corporation" },
    { { 0x00, 0x19, 0xA6 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x19, 0xA7 }, "ItuT",         "Itu-T" },
    { { 0x00, 0x19, 0xA8 }, "WiQuestCommu", "WiQuest Communications" },
    { { 0x00, 0x19, 0xA9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0xAA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0xAB }, "Raycom",       "Raycom CO., LTD" },
    { { 0x00, 0x19, 0xAC }, "GSP",          "GSP SYSTEMS Inc." },
    { { 0x00, 0x19, 0xAD }, "Bobst",        "Bobst Sa" },
    { { 0x00, 0x19, 0xAE }, "HoplingTechn", "Hopling Technologies b.v." },
    { { 0x00, 0x19, 0xAF }, "RigolTechnol", "Rigol Technologies, Inc." },
    { { 0x00, 0x19, 0xB0 }, "HanYangSyste", "HanYang System" },
    { { 0x00, 0x19, 0xB1 }, "Arrow7",       "Arrow7 Corporation" },
    { { 0x00, 0x19, 0xB2 }, "XYnetsoft",    "XYnetsoft Co.,Ltd" },
    { { 0x00, 0x19, 0xB3 }, "StanfordRese", "Stanford Research Systems" },
    { { 0x00, 0x19, 0xB4 }, "Intellio",     "Intellio Ltd" },
    { { 0x00, 0x19, 0xB5 }, "FamarFueguin", "Famar Fueguina S.A." },
    { { 0x00, 0x19, 0xB6 }, "EuroEmme",     "Euro Emme s.r.l." },
    { { 0x00, 0x19, 0xB7 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x19, 0xB8 }, "BoundaryDevi", "Boundary Devices" },
    { { 0x00, 0x19, 0xB9 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x19, 0xBA }, "ParadoxSecur", "Paradox Security Systems Ltd" },
    { { 0x00, 0x19, 0xBB }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x19, 0xBC }, "ElectroChanc", "Electro Chance Srl" },
    { { 0x00, 0x19, 0xBD }, "NewMediaLife", "New Media Life" },
    { { 0x00, 0x19, 0xBE }, "AltaiTechnol", "Altai Technologies Limited" },
    { { 0x00, 0x19, 0xBF }, "Citiwaytechn", "Citiway technology Co.,ltd" },
    { { 0x00, 0x19, 0xC0 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x19, 0xC1 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x19, 0xC2 }, "EquustekSolu", "Equustek Solutions, Inc." },
    { { 0x00, 0x19, 0xC3 }, "Qualitrol",    "Qualitrol" },
    { { 0x00, 0x19, 0xC4 }, "Infocrypt",    "Infocrypt Inc." },
    { { 0x00, 0x19, 0xC5 }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0x19, 0xC6 }, "zte",          "zte corporation" },
    { { 0x00, 0x19, 0xC7 }, "CambridgeInd", "Cambridge Industries(Group) Co.,Ltd." },
    { { 0x00, 0x19, 0xC8 }, "AnyDATA",      "AnyDATA Corporation" },
    { { 0x00, 0x19, 0xC9 }, "S&CElectric",  "S&C Electric Company" },
    { { 0x00, 0x19, 0xCA }, "BroadataComm", "Broadata Communications, Inc" },
    { { 0x00, 0x19, 0xCB }, "ZyxelCommuni", "Zyxel Communications Corporation" },
    { { 0x00, 0x19, 0xCC }, "RCG",          "RCG (HK) Ltd" },
    { { 0x00, 0x19, 0xCD }, "ethercominfo", "Chengdu ethercom information technology Ltd." },
    { { 0x00, 0x19, 0xCE }, "ProgressiveG", "Progressive Gaming International" },
    { { 0x00, 0x19, 0xCF }, "Salicru",      "Salicru, S.A." },
    { { 0x00, 0x19, 0xD0 }, "Cathexis",     "Cathexis" },
    { { 0x00, 0x19, 0xD1 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x19, 0xD2 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x19, 0xD3 }, "TRAKMicrowav", "TRAK Microwave" },
    { { 0x00, 0x19, 0xD4 }, "ICXTechnolog", "ICX Technologies" },
    { { 0x00, 0x19, 0xD5 }, "IPInnovation", "IP Innovations, Inc." },
    { { 0x00, 0x19, 0xD6 }, "LSCableandSy", "LS Cable and System Ltd." },
    { { 0x00, 0x19, 0xD7 }, "Fortunetek",   "Fortunetek Co., Ltd" },
    { { 0x00, 0x19, 0xD8 }, "Maxfor",       "Maxfor" },
    { { 0x00, 0x19, 0xD9 }, "Zeutschel",    "Zeutschel GmbH" },
    { { 0x00, 0x19, 0xDA }, "WelltransO&E", "Welltrans O&E Technology Co. , Ltd." },
    { { 0x00, 0x19, 0xDB }, "MicroStarInt", "Micro-Star International Co., Ltd." },
    { { 0x00, 0x19, 0xDC }, "ENENSYSTechn", "ENENSYS Technologies" },
    { { 0x00, 0x19, 0xDD }, "FEIZyfer",     "FEI-Zyfer, Inc." },
    { { 0x00, 0x19, 0xDE }, "Mobitek",      "Mobitek" },
    { { 0x00, 0x19, 0xDF }, "Thomson",      "Thomson Inc." },
    { { 0x00, 0x19, 0xE0 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x19, 0xE1 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x19, 0xE2 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x19, 0xE3 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x19, 0xE4 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x19, 0xE5 }, "LynxStudioTe", "Lynx Studio Technology, Inc." },
    { { 0x00, 0x19, 0xE6 }, "ToyoMedic",    "Toyo Medic Co.,Ltd." },
    { { 0x00, 0x19, 0xE7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0xE8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x19, 0xE9 }, "SInformation", "S-Information Technolgy, Co., Ltd." },
    { { 0x00, 0x19, 0xEA }, "TeraMageTech", "TeraMage Technologies Co., Ltd." },
    { { 0x00, 0x19, 0xEB }, "Pyronix",      "Pyronix Ltd" },
    { { 0x00, 0x19, 0xEC }, "Sagamore",     "Sagamore Systems, Inc." },
    { { 0x00, 0x19, 0xED }, "Axesstel",     "Axesstel Inc." },
    { { 0x00, 0x19, 0xEE }, "CARLOGAVAZZI", "CARLO GAVAZZI CONTROLS SPA-Controls Division" },
    { { 0x00, 0x19, 0xEF }, "LinnkingElec", "Shenzhen Linnking Electronics Co.,Ltd" },
    { { 0x00, 0x19, 0xF0 }, "UnionManTech", "Union Man Technology Co.,Ltd" },
    { { 0x00, 0x19, 0xF1 }, "StarCommunic", "Star Communication Network Technology Co.,Ltd" },
    { { 0x00, 0x19, 0xF2 }, "Teradyne",     "Teradyne K.K." },
    { { 0x00, 0x19, 0xF3 }, "Cetis",        "Cetis, Inc" },
    { { 0x00, 0x19, 0xF4 }, "Convergens",   "Convergens Oy Ltd" },
    { { 0x00, 0x19, 0xF5 }, "ImaginationT", "Imagination Technologies Ltd" },
    { { 0x00, 0x19, 0xF6 }, "Acconet",      "Acconet (PTE) Ltd" },
    { { 0x00, 0x19, 0xF7 }, "OnsetCompute", "Onset Computer Corporation" },
    { { 0x00, 0x19, 0xF8 }, "EmbeddedDesi", "Embedded Systems Design, Inc." },
    { { 0x00, 0x19, 0xF9 }, "TDKLambda",    "TDK-Lambda" },
    { { 0x00, 0x19, 0xFA }, "CableVisionE", "Cable Vision Electronics CO., LTD." },
    { { 0x00, 0x19, 0xFB }, "SkyUk",        "Sky Uk Limited" },
    { { 0x00, 0x19, 0xFC }, "PTUfoaksesSu", "PT. Ufoakses Sukses Luarbiasa" },
    { { 0x00, 0x19, 0xFD }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x19, 0xFE }, "SeecommTechn", "Shenzhen Seecomm Technology Co.,Ltd." },
    { { 0x00, 0x19, 0xFF }, "Finnzymes",    "Finnzymes" },
    { { 0x00, 0x1A, 0x00 }, "Matrix",       "Matrix Inc." },
    { { 0x00, 0x1A, 0x01 }, "SmithsMedica", "Smiths Medical" },
    { { 0x00, 0x1A, 0x02 }, "SecureCarePr", "Secure Care Products, Inc" },
    { { 0x00, 0x1A, 0x03 }, "AngelElectro", "Angel Electronics Co., Ltd." },
    { { 0x00, 0x1A, 0x04 }, "InteraySolut", "Interay Solutions BV" },
    { { 0x00, 0x1A, 0x05 }, "Optibase",     "Optibase Ltd" },
    { { 0x00, 0x1A, 0x06 }, "OpVista",      "OpVista, Inc." },
    { { 0x00, 0x1A, 0x07 }, "ArecontVisio", "Arecont Vision" },
    { { 0x00, 0x1A, 0x08 }, "Simoco",       "Simoco Ltd." },
    { { 0x00, 0x1A, 0x09 }, "WayfarerTran", "Wayfarer Transit Systems Ltd" },
    { { 0x00, 0x1A, 0x0A }, "AdaptiveMicr", "Adaptive Micro-Ware Inc." },
    { { 0x00, 0x1A, 0x0B }, "BonaTechnolo", "Bona Technology Inc." },
    { { 0x00, 0x1A, 0x0C }, "SweDishSatel", "Swe-Dish Satellite Systems AB" },
    { { 0x00, 0x1A, 0x0D }, "HandHeldente", "HandHeld entertainment, Inc." },
    { { 0x00, 0x1A, 0x0E }, "ChengUeiPrec", "Cheng Uei Precision Industry Co.,Ltd" },
    { { 0x00, 0x1A, 0x0F }, "ArtecheGroup", "Arteche Group" },
    { { 0x00, 0x1A, 0x10 }, "LucentTransE", "Lucent Trans Electronics Co.,Ltd" },
    { { 0x00, 0x1A, 0x11 }, "Google",       "Google, Inc." },
    { { 0x00, 0x1A, 0x12 }, "Essilor",      "Essilor" },
    { { 0x00, 0x1A, 0x13 }, "WanlidaGroup", "Wanlida Group Co., LTD" },
    { { 0x00, 0x1A, 0x14 }, "XinHuaContro", "Xin Hua Control Engineering Co.,Ltd." },
    { { 0x00, 0x1A, 0x15 }, "gemaltoePaym", "gemalto e-Payment" },
    { { 0x00, 0x1A, 0x16 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1A, 0x17 }, "TeakTechnolo", "Teak Technologies, Inc." },
    { { 0x00, 0x1A, 0x18 }, "AdvancedSimu", "Advanced Simulation Technology inc." },
    { { 0x00, 0x1A, 0x19 }, "ComputerEngi", "Computer Engineering Limited" },
    { { 0x00, 0x1A, 0x1A }, "GentexElectr", "Gentex Corporation/Electro-Acoustic Products" },
    { { 0x00, 0x1A, 0x1B }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1A, 0x1C }, "GT&TEngineer", "GT&T Engineering Pte Ltd" },
    { { 0x00, 0x1A, 0x1D }, "PChomeOnline", "PChome Online Inc." },
    { { 0x00, 0x1A, 0x1E }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x00, 0x1A, 0x1F }, "CoastalEnvir", "Coastal Environmental Systems" },
    { { 0x00, 0x1A, 0x20 }, "CMOTECH",      "CMOTECH Co. Ltd." },
    { { 0x00, 0x1A, 0x21 }, "BrookhuisApp", "Brookhuis Applied Technologies BV" },
    { { 0x00, 0x1A, 0x22 }, "eQ3Entwicklu", "eQ-3 Entwicklung GmbH" },
    { { 0x00, 0x1A, 0x23 }, "IceQube",      "Ice Qube, Inc" },
    { { 0x00, 0x1A, 0x24 }, "GalaxyTeleco", "Galaxy Telecom Technologies Ltd" },
    { { 0x00, 0x1A, 0x25 }, "DeltaDore",    "Delta Dore" },
    { { 0x00, 0x1A, 0x26 }, "DeltanodeSol", "Deltanode Solutions AB" },
    { { 0x00, 0x1A, 0x27 }, "Ubistar",      "Ubistar" },
    { { 0x00, 0x1A, 0x28 }, "ASWTTaiwanBr", "ASWT Co., LTD. Taiwan Branch H.K." },
    { { 0x00, 0x1A, 0x29 }, "JohnsonOutdo", "Johnson Outdoors Marine Electronics d/b/a Minnkota" },
    { { 0x00, 0x1A, 0x2A }, "ArcadyanTech", "Arcadyan Technology Corporation" },
    { { 0x00, 0x1A, 0x2B }, "AyecomTechno", "Ayecom Technology Co., Ltd." },
    { { 0x00, 0x1A, 0x2C }, "SATEC",        "SATEC Co.,LTD" },
    { { 0x00, 0x1A, 0x2D }, "NavvoGroup",   "The Navvo Group" },
    { { 0x00, 0x1A, 0x2E }, "ZiovaCoporat", "Ziova Coporation" },
    { { 0x00, 0x1A, 0x2F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0x30 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0x31 }, "ScanCoin",     "Scan Coin Ab" },
    { { 0x00, 0x1A, 0x32 }, "ActivaMultim", "Activa Multimedia" },
    { { 0x00, 0x1A, 0x33 }, "ASICommunica", "ASI Communications, Inc." },
    { { 0x00, 0x1A, 0x34 }, "KonkaGroup",   "Konka Group Co., Ltd." },
    { { 0x00, 0x1A, 0x35 }, "BARTEC",       "BARTEC GmbH" },
    { { 0x00, 0x1A, 0x36 }, "Aipermon",     "Aipermon GmbH & Co. KG" },
    { { 0x00, 0x1A, 0x37 }, "Lear",         "Lear Corporation" },
    { { 0x00, 0x1A, 0x38 }, "SanminaSCI",   "Sanmina-SCI" },
    { { 0x00, 0x1A, 0x39 }, "Merten&CoKG",  "Merten GmbH&CoKG" },
    { { 0x00, 0x1A, 0x3A }, "Dongahelecom", "Dongahelecomm" },
    { { 0x00, 0x1A, 0x3B }, "DoahElecom",   "Doah Elecom Inc." },
    { { 0x00, 0x1A, 0x3C }, "Technowave",   "Technowave Ltd." },
    { { 0x00, 0x1A, 0x3D }, "AjinVision",   "Ajin Vision Co.,Ltd" },
    { { 0x00, 0x1A, 0x3E }, "FasterTechno", "Faster Technology LLC" },
    { { 0x00, 0x1A, 0x3F }, "Intelbras",    "Intelbras" },
    { { 0x00, 0x1A, 0x40 }, "AFourTech",    "A-Four Tech Co., Ltd." },
    { { 0x00, 0x1A, 0x41 }, "INOCOVA",      "INOCOVA Co.,Ltd" },
    { { 0x00, 0x1A, 0x42 }, "TechcityTech", "Techcity Technology co., Ltd." },
    { { 0x00, 0x1A, 0x43 }, "LogicalLinkC", "Logical Link Communications" },
    { { 0x00, 0x1A, 0x44 }, "JWTrading",    "JWTrading Co., Ltd" },
    { { 0x00, 0x1A, 0x45 }, "GNNetcom",     "GN Netcom A/S" },
    { { 0x00, 0x1A, 0x46 }, "DigitalMulti", "Digital Multimedia Technology Co., Ltd" },
    { { 0x00, 0x1A, 0x47 }, "Agami",        "Agami Systems, Inc." },
    { { 0x00, 0x1A, 0x48 }, "Takacom",      "Takacom Corporation" },
    { { 0x00, 0x1A, 0x49 }, "MicroVision",  "Micro Vision Co.,LTD" },
    { { 0x00, 0x1A, 0x4A }, "Qumranet",     "Qumranet Inc." },
    { { 0x00, 0x1A, 0x4B }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x1A, 0x4C }, "CrossbowTech", "Crossbow Technology, Inc" },
    { { 0x00, 0x1A, 0x4D }, "GigaByteTech", "Giga-Byte Technology Co.,Ltd." },
    { { 0x00, 0x1A, 0x4E }, "NTILinMot",    "NTI AG / LinMot" },
    { { 0x00, 0x1A, 0x4F }, "AVM",          "AVM GmbH" },
    { { 0x00, 0x1A, 0x50 }, "PheeNetTechn", "PheeNet Technology Corp." },
    { { 0x00, 0x1A, 0x51 }, "AlfredMannFo", "Alfred Mann Foundation" },
    { { 0x00, 0x1A, 0x52 }, "MeshlinxWire", "Meshlinx Wireless Inc." },
    { { 0x00, 0x1A, 0x53 }, "Zylaya",       "Zylaya" },
    { { 0x00, 0x1A, 0x54 }, "HipShingElec", "Hip Shing Electronics Ltd." },
    { { 0x00, 0x1A, 0x55 }, "ACADigital",   "ACA-Digital Corporation" },
    { { 0x00, 0x1A, 0x56 }, "ViewTel",      "ViewTel Co,. Ltd." },
    { { 0x00, 0x1A, 0x57 }, "MatrixDesign", "Matrix Design Group, LLC" },
    { { 0x00, 0x1A, 0x58 }, "CCVDeutschla", "CCV Deutschland GmbH - Celectronic eHealth Div." },
    { { 0x00, 0x1A, 0x59 }, "Ircona",       "Ircona" },
    { { 0x00, 0x1A, 0x5A }, "KoreaElectri", "Korea Electric Power Data Network (KDN) Co., Ltd" },
    { { 0x00, 0x1A, 0x5B }, "NetCareServi", "NetCare Service Co., Ltd." },
    { { 0x00, 0x1A, 0x5C }, "Euchner",      "Euchner GmbH+Co. KG" },
    { { 0x00, 0x1A, 0x5D }, "Mobinnova",    "Mobinnova Corp." },
    { { 0x00, 0x1A, 0x5E }, "ThincomTechn", "Thincom Technology Co.,Ltd" },
    { { 0x00, 0x1A, 0x5F }, "KitWorksfi",   "KitWorks.fi Ltd." },
    { { 0x00, 0x1A, 0x60 }, "WaveElectron", "Wave Electronics Co.,Ltd." },
    { { 0x00, 0x1A, 0x61 }, "PacStar",      "PacStar Corp." },
    { { 0x00, 0x1A, 0x62 }, "DataRobotics", "Data Robotics, Incorporated" },
    { { 0x00, 0x1A, 0x63 }, "ElsterSoluti", "Elster Solutions, LLC," },
    { { 0x00, 0x1A, 0x64 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x1A, 0x65 }, "Seluxit",      "Seluxit" },
    { { 0x00, 0x1A, 0x66 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1A, 0x67 }, "InfiniteQLSd", "Infinite QL Sdn Bhd" },
    { { 0x00, 0x1A, 0x68 }, "WeltecEnterp", "Weltec Enterprise Co., Ltd." },
    { { 0x00, 0x1A, 0x69 }, "YangtzeOptic", "Wuhan Yangtze Optical Technology CO.,Ltd." },
    { { 0x00, 0x1A, 0x6A }, "Tranzas",      "Tranzas, Inc." },
    { { 0x00, 0x1A, 0x6B }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x00, 0x1A, 0x6C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0x6D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0x6E }, "ImproTechnol", "Impro Technologies" },
    { { 0x00, 0x1A, 0x6F }, "MITEL",        "MI.TEL s.r.l." },
    { { 0x00, 0x1A, 0x70 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x1A, 0x71 }, "Diostech",     "Diostech Co., Ltd." },
    { { 0x00, 0x1A, 0x72 }, "MosartSemico", "Mosart Semiconductor Corp." },
    { { 0x00, 0x1A, 0x73 }, "GemtekTechno", "Gemtek Technology Co., Ltd." },
    { { 0x00, 0x1A, 0x74 }, "ProcareInter", "Procare International Co" },
    { { 0x00, 0x1A, 0x75 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1A, 0x76 }, "SDTinformati", "SDT information Technology Co.,LTD." },
    { { 0x00, 0x1A, 0x77 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1A, 0x78 }, "ubtos",        "ubtos" },
    { { 0x00, 0x1A, 0x79 }, "Telecomunica", "Telecomunication Technologies Ltd." },
    { { 0x00, 0x1A, 0x7A }, "LismoreInstr", "Lismore Instruments Limited" },
    { { 0x00, 0x1A, 0x7B }, "Teleco",       "Teleco, Inc." },
    { { 0x00, 0x1A, 0x7C }, "HirschmannMu", "Hirschmann Multimedia B.V." },
    { { 0x00, 0x1A, 0x7D }, "cyberblueLtd", "cyber-blue(HK)Ltd" },
    { { 0x00, 0x1A, 0x7E }, "LNSrithaiCom", "LN Srithai Comm Ltd." },
    { { 0x00, 0x1A, 0x7F }, "GCIScienceTe", "GCI Science & Technology Co.,LTD" },
    { { 0x00, 0x1A, 0x80 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1A, 0x81 }, "Zelax",        "Zelax" },
    { { 0x00, 0x1A, 0x82 }, "PROBABuildin", "PROBA Building Automation Co.,LTD" },
    { { 0x00, 0x1A, 0x83 }, "PegasusTechn", "Pegasus Technologies Inc." },
    { { 0x00, 0x1A, 0x84 }, "VOneMultimed", "V One Multimedia Pte Ltd" },
    { { 0x00, 0x1A, 0x85 }, "NVMichelVand", "NV Michel Van de Wiele" },
    { { 0x00, 0x1A, 0x86 }, "NewWaveDesig", "New Wave Design & Verification" },
    { { 0x00, 0x1A, 0x87 }, "CanholdInter", "Canhold International Limited" },
    { { 0x00, 0x1A, 0x88 }, "Venergy",      "Venergy,Co,Ltd" },
    { { 0x00, 0x1A, 0x89 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1A, 0x8A }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1A, 0x8B }, "ChunilElectr", "Chunil Electric Ind., Co." },
    { { 0x00, 0x1A, 0x8C }, "Sophos",       "Sophos Ltd" },
    { { 0x00, 0x1A, 0x8D }, "AVECSBergen",  "AVECS Bergen GmbH" },
    { { 0x00, 0x1A, 0x8E }, "3WayNetworks", "3Way Networks Ltd" },
    { { 0x00, 0x1A, 0x8F }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1A, 0x90 }, "TrópicoSiste", "Trópico Sistemas e Telecomunicações da Amazônia LTDA." },
    { { 0x00, 0x1A, 0x91 }, "FusionDynami", "FusionDynamic Ltd." },
    { { 0x00, 0x1A, 0x92 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x1A, 0x93 }, "ERCOLeuchten", "ERCO Leuchten GmbH" },
    { { 0x00, 0x1A, 0x94 }, "Votronic",     "Votronic GmbH" },
    { { 0x00, 0x1A, 0x95 }, "HisenseMobil", "Hisense Mobile Communications Technoligy Co.,Ltd." },
    { { 0x00, 0x1A, 0x96 }, "Ecler",        "Ecler S.A." },
    { { 0x00, 0x1A, 0x97 }, "fitivisionte", "fitivision technology Inc." },
    { { 0x00, 0x1A, 0x98 }, "AsotelCommun", "Asotel Communication Limited Taiwan Branch" },
    { { 0x00, 0x1A, 0x99 }, "SmartyInform", "Smarty (HZ) Information Electronics Co., Ltd" },
    { { 0x00, 0x1A, 0x9A }, "SkyworthDigi", "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
    { { 0x00, 0x1A, 0x9B }, "ADECParter",   "ADEC & Parter AG" },
    { { 0x00, 0x1A, 0x9C }, "RightHandTec", "RightHand Technologies, Inc." },
    { { 0x00, 0x1A, 0x9D }, "SkipperWirel", "Skipper Wireless, Inc." },
    { { 0x00, 0x1A, 0x9E }, "ICONDigitalI", "ICON Digital International Limited" },
    { { 0x00, 0x1A, 0x9F }, "ALink",        "A-Link Ltd" },
    { { 0x00, 0x1A, 0xA0 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x1A, 0xA1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0xA2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0xA3 }, "Delorme",      "Delorme" },
    { { 0x00, 0x1A, 0xA4 }, "FutureUniver", "Future University-Hakodate" },
    { { 0x00, 0x1A, 0xA5 }, "BRNPhoenix",   "BRN Phoenix" },
    { { 0x00, 0x1A, 0xA6 }, "ElbitDeutsch", "Elbit Systems Deutschland GmbH & Co. KG" },
    { { 0x00, 0x1A, 0xA7 }, "TorianWirele", "Torian Wireless" },
    { { 0x00, 0x1A, 0xA8 }, "MamiyaDigita", "Mamiya Digital Imaging Co., Ltd." },
    { { 0x00, 0x1A, 0xA9 }, "FujianStarNe", "Fujian Star-Net Communication Co.,Ltd" },
    { { 0x00, 0x1A, 0xAA }, "Analogic",     "Analogic Corp." },
    { { 0x00, 0x1A, 0xAB }, "eWings",       "eWings s.r.l." },
    { { 0x00, 0x1A, 0xAC }, "Corelatus",    "Corelatus AB" },
    { { 0x00, 0x1A, 0xAD }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1A, 0xAE }, "Savant",       "Savant Systems LLC" },
    { { 0x00, 0x1A, 0xAF }, "BlusensTechn", "Blusens Technology" },
    { { 0x00, 0x1A, 0xB0 }, "SignalNetwor", "Signal Networks Pvt. Ltd.," },
    { { 0x00, 0x1A, 0xB1 }, "AsiaPacificS", "Asia Pacific Satellite Industries Co., Ltd." },
    { { 0x00, 0x1A, 0xB2 }, "CyberSolutio", "Cyber Solutions Inc." },
    { { 0x00, 0x1A, 0xB3 }, "Visionite",    "Visionite Inc." },
    { { 0x00, 0x1A, 0xB4 }, "FFEI",         "FFEI Ltd." },
    { { 0x00, 0x1A, 0xB5 }, "HomeNetworkS", "Home Network System" },
    { { 0x00, 0x1A, 0xB6 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x1A, 0xB7 }, "EthosNetwork", "Ethos Networks LTD." },
    { { 0x00, 0x1A, 0xB8 }, "Anseri",       "Anseri Corporation" },
    { { 0x00, 0x1A, 0xB9 }, "Pmc",          "Pmc" },
    { { 0x00, 0x1A, 0xBA }, "CatonOversea", "Caton Overseas Limited" },
    { { 0x00, 0x1A, 0xBB }, "FontalTechno", "Fontal Technology Incorporation" },
    { { 0x00, 0x1A, 0xBC }, "U4EATechnolo", "U4EA Technologies Ltd" },
    { { 0x00, 0x1A, 0xBD }, "Impatica",     "Impatica Inc." },
    { { 0x00, 0x1A, 0xBE }, "ComputerHiTe", "Computer Hi-Tech Inc." },
    { { 0x00, 0x1A, 0xBF }, "TRUMPFLaserM", "TRUMPF Laser Marking Systems AG" },
    { { 0x00, 0x1A, 0xC0 }, "JoybienTechn", "Joybien Technologies Co., Ltd." },
    { { 0x00, 0x1A, 0xC1 }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x1A, 0xC2 }, "YEC",          "YEC Co.,Ltd." },
    { { 0x00, 0x1A, 0xC3 }, "ScientificAt", "Scientific-Atlanta, Inc" },
    { { 0x00, 0x1A, 0xC4 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x1A, 0xC5 }, "KeysightTech", "Keysight Technologies, Inc." },
    { { 0x00, 0x1A, 0xC6 }, "MicroControl", "Micro Control Designs" },
    { { 0x00, 0x1A, 0xC7 }, "Unipoint",     "Unipoint" },
    { { 0x00, 0x1A, 0xC8 }, "ISL",          "ISL (Instrumentation Scientifique de Laboratoire)" },
    { { 0x00, 0x1A, 0xC9 }, "Suzuken",      "Suzuken Co.,Ltd" },
    { { 0x00, 0x1A, 0xCA }, "Tilera",       "Tilera Corporation" },
    { { 0x00, 0x1A, 0xCB }, "AutocomProdu", "Autocom Products Ltd" },
    { { 0x00, 0x1A, 0xCC }, "CelestialSem", "Celestial Semiconductor, Ltd" },
    { { 0x00, 0x1A, 0xCD }, "TidelEnginee", "Tidel Engineering LP" },
    { { 0x00, 0x1A, 0xCE }, "Yupiteru",     "Yupiteru Corporation" },
    { { 0x00, 0x1A, 0xCF }, "CTElettronic", "C.T. Elettronica" },
    { { 0x00, 0x1A, 0xD0 }, "AlbisTechnol", "Albis Technologies AG" },
    { { 0x00, 0x1A, 0xD1 }, "Fargo",        "Fargo Co., Ltd." },
    { { 0x00, 0x1A, 0xD2 }, "EletronicaNi", "Eletronica Nitron Ltda" },
    { { 0x00, 0x1A, 0xD3 }, "Vamp",         "Vamp Ltd." },
    { { 0x00, 0x1A, 0xD4 }, "iPOXTechnolo", "iPOX Technology Co., Ltd." },
    { { 0x00, 0x1A, 0xD5 }, "KmcChainIndu", "Kmc Chain Industrial Co., Ltd." },
    { { 0x00, 0x1A, 0xD6 }, "JiagnsuAetna", "Jiagnsu Aetna Electric Co.,Ltd" },
    { { 0x00, 0x1A, 0xD7 }, "ChristieDigi", "Christie Digital Systems, Inc." },
    { { 0x00, 0x1A, 0xD8 }, "AlsterAero",   "AlsterAero GmbH" },
    { { 0x00, 0x1A, 0xD9 }, "Internationa", "International Broadband Electric Communications, Inc." },
    { { 0x00, 0x1A, 0xDA }, "Biz2Me",       "Biz-2-Me Inc." },
    { { 0x00, 0x1A, 0xDB }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1A, 0xDC }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1A, 0xDD }, "PePWave",      "PePWave Ltd" },
    { { 0x00, 0x1A, 0xDE }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1A, 0xDF }, "Interactivet", "Interactivetv Pty Limited" },
    { { 0x00, 0x1A, 0xE0 }, "MythologyTec", "Mythology Tech Express Inc." },
    { { 0x00, 0x1A, 0xE1 }, "EdgeAccess",   "Edge Access Inc" },
    { { 0x00, 0x1A, 0xE2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0xE3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1A, 0xE4 }, "MedicisTechn", "Medicis Technologies Corporation" },
    { { 0x00, 0x1A, 0xE5 }, "MvoxTechnolo", "Mvox Technologies Inc." },
    { { 0x00, 0x1A, 0xE6 }, "AtlantaAdvan", "Atlanta Advanced Communications Holdings Limited" },
    { { 0x00, 0x1A, 0xE7 }, "AztekNetwork", "Aztek Networks, Inc." },
    { { 0x00, 0x1A, 0xE8 }, "UnifySoftwar", "Unify Software and Solutions GmbH & Co. KG" },
    { { 0x00, 0x1A, 0xE9 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1A, 0xEA }, "RadioTermina", "Radio Terminal Systems Pty Ltd" },
    { { 0x00, 0x1A, 0xEB }, "AlliedTelesi", "Allied Telesis K.K." },
    { { 0x00, 0x1A, 0xEC }, "KeumbeeElect", "Keumbee Electronics Co.,Ltd." },
    { { 0x00, 0x1A, 0xED }, "INCOTEC",      "INCOTEC GmbH" },
    { { 0x00, 0x1A, 0xEE }, "Shenztech",    "Shenztech Ltd" },
    { { 0x00, 0x1A, 0xEF }, "LoopcommTech", "Loopcomm Technology, Inc." },
    { { 0x00, 0x1A, 0xF0 }, "AlcatelLucen", "Alcatel-Lucent IPD" },
    { { 0x00, 0x1A, 0xF1 }, "EmbeddedArti", "Embedded Artists AB" },
    { { 0x00, 0x1A, 0xF2 }, "DynavisionsS", "Dynavisions Schweiz AG" },
    { { 0x00, 0x1A, 0xF3 }, "SamyoungElec", "Samyoung Electronics" },
    { { 0x00, 0x1A, 0xF4 }, "Handreamnet",  "Handreamnet" },
    { { 0x00, 0x1A, 0xF5 }, "Pentaone",     "Pentaone. Co., Ltd." },
    { { 0x00, 0x1A, 0xF6 }, "Woven",        "Woven Systems, Inc." },
    { { 0x00, 0x1A, 0xF7 }, "dataschaltea", "dataschalt e+a GmbH" },
    { { 0x00, 0x1A, 0xF8 }, "CopleyContro", "Copley Controls Corporation" },
    { { 0x00, 0x1A, 0xF9 }, "AeroVIronmen", "AeroVIronment (AV Inc)" },
    { { 0x00, 0x1A, 0xFA }, "WelchAllyn",   "Welch Allyn, Inc." },
    { { 0x00, 0x1A, 0xFB }, "Joby",         "Joby Inc." },
    { { 0x00, 0x1A, 0xFC }, "ModusLink",    "ModusLink Corporation" },
    { { 0x00, 0x1A, 0xFD }, "Evolis",       "Evolis" },
    { { 0x00, 0x1A, 0xFE }, "Sofacreal",    "Sofacreal" },
    { { 0x00, 0x1A, 0xFF }, "WizyoungTech", "Wizyoung Tech." },
    { { 0x00, 0x1B, 0x00 }, "NeopostTechn", "Neopost Technologies" },
    { { 0x00, 0x1B, 0x01 }, "AppliedRadio", "Applied Radio Technologies" },
    { { 0x00, 0x1B, 0x02 }, "ED",           "ED Co.Ltd" },
    { { 0x00, 0x1B, 0x03 }, "ActionTechno", "Action Technology (SZ) Co., Ltd" },
    { { 0x00, 0x1B, 0x04 }, "AffinityInte", "Affinity International S.p.a" },
    { { 0x00, 0x1B, 0x05 }, "Ymc",          "Ymc Ag" },
    { { 0x00, 0x1B, 0x06 }, "AteliersRLAU", "Ateliers R. LAUMONIER" },
    { { 0x00, 0x1B, 0x07 }, "MendocinoSof", "Mendocino Software" },
    { { 0x00, 0x1B, 0x08 }, "DanfossDrive", "Danfoss Drives A/S" },
    { { 0x00, 0x1B, 0x09 }, "MatrixComsec", "Matrix Comsec Private Limited" },
    { { 0x00, 0x1B, 0x0A }, "IntelligentD", "Intelligent Distributed Controls Ltd" },
    { { 0x00, 0x1B, 0x0B }, "Phidgets",     "Phidgets Inc." },
    { { 0x00, 0x1B, 0x0C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x0D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x0E }, "InoTecOrgani", "InoTec GmbH Organisationssysteme" },
    { { 0x00, 0x1B, 0x0F }, "Petratec",     "Petratec" },
    { { 0x00, 0x1B, 0x10 }, "KangHuiTechn", "ShenZhen Kang Hui Technology Co.,ltd" },
    { { 0x00, 0x1B, 0x11 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x1B, 0x12 }, "Apprion",      "Apprion" },
    { { 0x00, 0x1B, 0x13 }, "IcronTechnol", "Icron Technologies Corporation" },
    { { 0x00, 0x1B, 0x14 }, "CarexLightin", "Carex Lighting Equipment Factory" },
    { { 0x00, 0x1B, 0x15 }, "Voxtel",       "Voxtel, Inc." },
    { { 0x00, 0x1B, 0x16 }, "Celtro",       "Celtro Ltd." },
    { { 0x00, 0x1B, 0x17 }, "PaloAltoNetw", "Palo Alto Networks" },
    { { 0x00, 0x1B, 0x18 }, "TsukenElectr", "Tsuken Electric Ind. Co.,Ltd" },
    { { 0x00, 0x1B, 0x19 }, "IEEEI&MSocie", "IEEE I&M Society TC9" },
    { { 0x00, 0x1B, 0x1A }, "etreesJapan",  "e-trees Japan, Inc." },
    { { 0x00, 0x1B, 0x1B }, "Siemens",      "Siemens AG," },
    { { 0x00, 0x1B, 0x1C }, "Coherent",     "Coherent" },
    { { 0x00, 0x1B, 0x1D }, "PhoenixInter", "Phoenix International Co., Ltd" },
    { { 0x00, 0x1B, 0x1E }, "HARTCommunic", "HART Communication Foundation" },
    { { 0x00, 0x1B, 0x1F }, "FORCETechnol", "FORCE Technology" },
    { { 0x00, 0x1B, 0x20 }, "TPineTechnol", "TPine Technology" },
    { { 0x00, 0x1B, 0x21 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1B, 0x22 }, "PalitMicrosy", "Palit Microsystems ( H.K.) Ltd." },
    { { 0x00, 0x1B, 0x23 }, "SimpleComToo", "SimpleComTools" },
    { { 0x00, 0x1B, 0x24 }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x00, 0x1B, 0x25 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1B, 0x26 }, "RONTelecom",   "RON-Telecom ZAO" },
    { { 0x00, 0x1B, 0x27 }, "MerlinCSI",    "Merlin CSI" },
    { { 0x00, 0x1B, 0x28 }, "Polygon",      "Polygon, Jsc" },
    { { 0x00, 0x1B, 0x29 }, "Avantis",      "Avantis.Co.,Ltd" },
    { { 0x00, 0x1B, 0x2A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x2B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x2C }, "ATRONelectro", "ATRON electronic GmbH" },
    { { 0x00, 0x1B, 0x2D }, "MedEng",       "Med-Eng Systems Inc." },
    { { 0x00, 0x1B, 0x2E }, "SinkyoElectr", "Sinkyo Electron Inc" },
    { { 0x00, 0x1B, 0x2F }, "Netgear",      "Netgear" },
    { { 0x00, 0x1B, 0x30 }, "Solitech",     "Solitech Inc." },
    { { 0x00, 0x1B, 0x31 }, "NeuralImage",  "Neural Image. Co. Ltd." },
    { { 0x00, 0x1B, 0x32 }, "QLogic",       "QLogic Corporation" },
    { { 0x00, 0x1B, 0x33 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1B, 0x34 }, "FocusSystem",  "Focus System Inc." },
    { { 0x00, 0x1B, 0x35 }, "ChongQingJIN", "ChongQing JINOU Science & Technology Development CO.,Ltd" },
    { { 0x00, 0x1B, 0x36 }, "TsubataEngin", "Tsubata Engineering Co.,Ltd. (Head Office)" },
    { { 0x00, 0x1B, 0x37 }, "Computec",     "Computec Oy" },
    { { 0x00, 0x1B, 0x38 }, "CompalInform", "Compal Information (Kunshan) Co., Ltd." },
    { { 0x00, 0x1B, 0x39 }, "Proxicast",    "Proxicast" },
    { { 0x00, 0x1B, 0x3A }, "SIMS",         "SIMS Corp." },
    { { 0x00, 0x1B, 0x3B }, "YiQing",       "Yi-Qing CO., LTD" },
    { { 0x00, 0x1B, 0x3C }, "SoftwareTech", "Software Technologies Group,Inc." },
    { { 0x00, 0x1B, 0x3D }, "EuroTel",      "EuroTel Spa" },
    { { 0x00, 0x1B, 0x3E }, "Curtis",       "Curtis, Inc." },
    { { 0x00, 0x1B, 0x3F }, "ProCurveNetw", "ProCurve Networking by HP" },
    { { 0x00, 0x1B, 0x40 }, "NetworkAutom", "Network Automation mxc AB" },
    { { 0x00, 0x1B, 0x41 }, "GeneralInfin", "General Infinity Co.,Ltd." },
    { { 0x00, 0x1B, 0x42 }, "WiseBlue",     "Wise & Blue" },
    { { 0x00, 0x1B, 0x43 }, "DGTelecommun", "Beijing DG Telecommunications equipment Co.,Ltd" },
    { { 0x00, 0x1B, 0x44 }, "SanDisk",      "SanDisk Corporation" },
    { { 0x00, 0x1B, 0x45 }, "ABBASDivisio", "ABB AS, Division Automation Products" },
    { { 0x00, 0x1B, 0x46 }, "BlueoneTechn", "Blueone Technology Co.,Ltd" },
    { { 0x00, 0x1B, 0x47 }, "Futarque",     "Futarque A/S" },
    { { 0x00, 0x1B, 0x48 }, "LantechElect", "Shenzhen Lantech Electronics Co., Ltd." },
    { { 0x00, 0x1B, 0x49 }, "RobertsRadio", "Roberts Radio limited" },
    { { 0x00, 0x1B, 0x4A }, "W&WCommunica", "W&W Communications, Inc." },
    { { 0x00, 0x1B, 0x4B }, "SANION",       "SANION Co., Ltd." },
    { { 0x00, 0x1B, 0x4C }, "Signtech",     "Signtech" },
    { { 0x00, 0x1B, 0x4D }, "ArecaTechnol", "Areca Technology Corporation" },
    { { 0x00, 0x1B, 0x4E }, "NavmanNewZea", "Navman New Zealand" },
    { { 0x00, 0x1B, 0x4F }, "Avaya",        "Avaya Inc" },
    { { 0x00, 0x1B, 0x50 }, "NizhnyNovgor", "Nizhny Novgorod Factory named after M.Frunze, FSUE (NZiF)" },
    { { 0x00, 0x1B, 0x51 }, "VectorTechno", "Vector Technology Corp." },
    { { 0x00, 0x1B, 0x52 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1B, 0x53 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x54 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x55 }, "HurcoAutomat", "Hurco Automation Ltd." },
    { { 0x00, 0x1B, 0x56 }, "TehutiNetwor", "Tehuti Networks Ltd." },
    { { 0x00, 0x1B, 0x57 }, "SemindiaPriv", "Semindia Systems Private Limited" },
    { { 0x00, 0x1B, 0x58 }, "ACECADEnterp", "ACE CAD Enterprise Co., Ltd." },
    { { 0x00, 0x1B, 0x59 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1B, 0x5A }, "ApolloImagin", "Apollo Imaging Technologies, Inc." },
    { { 0x00, 0x1B, 0x5B }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x1B, 0x5C }, "Azuretec",     "Azuretec Co., Ltd." },
    { { 0x00, 0x1B, 0x5D }, "Vololink",     "Vololink Pty Ltd" },
    { { 0x00, 0x1B, 0x5E }, "BPL",          "BPL Limited" },
    { { 0x00, 0x1B, 0x5F }, "AlienTechnol", "Alien Technology" },
    { { 0x00, 0x1B, 0x60 }, "Navigon",      "Navigon Ag" },
    { { 0x00, 0x1B, 0x61 }, "DigitalAcous", "Digital Acoustics, LLC" },
    { { 0x00, 0x1B, 0x62 }, "JHTOptoelect", "JHT Optoelectronics Co.,Ltd." },
    { { 0x00, 0x1B, 0x63 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x1B, 0x64 }, "IsaacLandKor", "IsaacLandKorea Co., Ltd," },
    { { 0x00, 0x1B, 0x65 }, "ChinaGridcom", "China Gridcom Co., Ltd" },
    { { 0x00, 0x1B, 0x66 }, "Sennheiserel", "Sennheiser electronic GmbH & Co. KG" },
    { { 0x00, 0x1B, 0x67 }, "Cisco",        "Cisco Systems Inc" },
    { { 0x00, 0x1B, 0x68 }, "Modnnet",      "Modnnet Co., Ltd" },
    { { 0x00, 0x1B, 0x69 }, "Equaline",     "Equaline Corporation" },
    { { 0x00, 0x1B, 0x6A }, "PowerwaveTec", "Powerwave Technologies Sweden AB" },
    { { 0x00, 0x1B, 0x6B }, "SwyxSolution", "Swyx Solutions AG" },
    { { 0x00, 0x1B, 0x6C }, "LookXDigital", "LookX Digital Media BV" },
    { { 0x00, 0x1B, 0x6D }, "Midtronics",   "Midtronics, Inc." },
    { { 0x00, 0x1B, 0x6E }, "KeysightTech", "Keysight Technologies, Inc." },
    { { 0x00, 0x1B, 0x6F }, "Teletrak",     "Teletrak Ltd" },
    { { 0x00, 0x1B, 0x70 }, "IRIUbiteq",    "IRI Ubiteq, INC." },
    { { 0x00, 0x1B, 0x71 }, "Telular",      "Telular Corp." },
    { { 0x00, 0x1B, 0x72 }, "Sicep",        "Sicep s.p.a." },
    { { 0x00, 0x1B, 0x73 }, "DTLBroadcast", "DTL Broadcast Ltd" },
    { { 0x00, 0x1B, 0x74 }, "MiraLink",     "MiraLink Corporation" },
    { { 0x00, 0x1B, 0x75 }, "Hypermedia",   "Hypermedia Systems" },
    { { 0x00, 0x1B, 0x76 }, "Ripcode",      "Ripcode, Inc." },
    { { 0x00, 0x1B, 0x77 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1B, 0x78 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x1B, 0x79 }, "FaiveleyTran", "Faiveley Transport" },
    { { 0x00, 0x1B, 0x7A }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1B, 0x7B }, "Tintometer",   "The Tintometer Ltd" },
    { { 0x00, 0x1B, 0x7C }, "ARCambridge",  "A & R Cambridge" },
    { { 0x00, 0x1B, 0x7D }, "CXRAndersonJ", "CXR Anderson Jacobson" },
    { { 0x00, 0x1B, 0x7E }, "Beckmann",     "Beckmann GmbH" },
    { { 0x00, 0x1B, 0x7F }, "TMNTechnolog", "TMN Technologies Telecomunicacoes Ltda" },
    { { 0x00, 0x1B, 0x80 }, "LORD",         "LORD Corporation" },
    { { 0x00, 0x1B, 0x81 }, "DATAQInstrum", "DATAQ Instruments, Inc." },
    { { 0x00, 0x1B, 0x82 }, "TaiwanSemico", "Taiwan Semiconductor Co., Ltd." },
    { { 0x00, 0x1B, 0x83 }, "Finsoft",      "Finsoft Ltd" },
    { { 0x00, 0x1B, 0x84 }, "ScanEngineer", "Scan Engineering Telecom" },
    { { 0x00, 0x1B, 0x85 }, "MANEnergySol", "MAN Energy Solutions" },
    { { 0x00, 0x1B, 0x86 }, "BoschAccess",  "Bosch Access Systems GmbH" },
    { { 0x00, 0x1B, 0x87 }, "DeepsoundTec", "Deepsound Tech. Co., Ltd" },
    { { 0x00, 0x1B, 0x88 }, "DivinetAcces", "Divinet Access Technologies Ltd" },
    { { 0x00, 0x1B, 0x89 }, "EMZAVisualSe", "EMZA Visual Sense Ltd." },
    { { 0x00, 0x1B, 0x8A }, "2MElectronic", "2M Electronic A/S" },
    { { 0x00, 0x1B, 0x8B }, "NECPlatforms", "NEC Platforms, Ltd." },
    { { 0x00, 0x1B, 0x8C }, "JMicronTechn", "JMicron Technology Corp." },
    { { 0x00, 0x1B, 0x8D }, "ElectronicCo", "Electronic Computer Systems, Inc." },
    { { 0x00, 0x1B, 0x8E }, "HuluSweden",   "Hulu Sweden AB" },
    { { 0x00, 0x1B, 0x8F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x90 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0x91 }, "Efkon",        "Efkon Ag" },
    { { 0x00, 0x1B, 0x92 }, "lacoustics",   "l-acoustics" },
    { { 0x00, 0x1B, 0x93 }, "JCDecauxDNT",  "JC Decaux SA DNT" },
    { { 0x00, 0x1B, 0x94 }, "TEMpA",        "T.E.M.A. S.p.A." },
    { { 0x00, 0x1B, 0x95 }, "Video",        "Video Systems Srl" },
    { { 0x00, 0x1B, 0x96 }, "GeneralSensi", "General Sensing" },
    { { 0x00, 0x1B, 0x97 }, "ViolinTechno", "Violin Technologies" },
    { { 0x00, 0x1B, 0x98 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1B, 0x99 }, "KSSystem",     "KS System GmbH" },
    { { 0x00, 0x1B, 0x9A }, "ApolloFireDe", "Apollo Fire Detectors Ltd" },
    { { 0x00, 0x1B, 0x9B }, "HoseMcCannCo", "Hose-McCann Communications" },
    { { 0x00, 0x1B, 0x9C }, "SATELsp",      "SATEL sp. z o.o." },
    { { 0x00, 0x1B, 0x9D }, "NovusSecurit", "Novus Security Sp. z o.o." },
    { { 0x00, 0x1B, 0x9E }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x00, 0x1B, 0x9F }, "Calyptech",    "Calyptech Pty Ltd" },
    { { 0x00, 0x1B, 0xA0 }, "Awox",         "Awox" },
    { { 0x00, 0x1B, 0xA1 }, "Åmic",         "Åmic AB" },
    { { 0x00, 0x1B, 0xA2 }, "IDSImagingDe", "IDS Imaging Development Systems GmbH" },
    { { 0x00, 0x1B, 0xA3 }, "FlexitGroup",  "Flexit Group GmbH" },
    { { 0x00, 0x1B, 0xA4 }, "SAEAfikim",    "S.A.E Afikim" },
    { { 0x00, 0x1B, 0xA5 }, "MyungMin",     "MyungMin Systems, Inc." },
    { { 0x00, 0x1B, 0xA6 }, "intotech",     "intotech inc." },
    { { 0x00, 0x1B, 0xA7 }, "LoricaSoluti", "Lorica Solutions" },
    { { 0x00, 0x1B, 0xA8 }, "UBI&MOBI",     "UBI&MOBI,.Inc" },
    { { 0x00, 0x1B, 0xA9 }, "Brotherindus", "Brother industries, LTD." },
    { { 0x00, 0x1B, 0xAA }, "XenICs",       "XenICs nv" },
    { { 0x00, 0x1B, 0xAB }, "Telchemy",     "Telchemy, Incorporated" },
    { { 0x00, 0x1B, 0xAC }, "CurtissWrigh", "Curtiss Wright Controls Embedded Computing" },
    { { 0x00, 0x1B, 0xAD }, "iControl",     "iControl Incorporated" },
    { { 0x00, 0x1B, 0xAE }, "MicroControl", "Micro Control Systems, Inc" },
    { { 0x00, 0x1B, 0xAF }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1B, 0xB0 }, "BharatElectr", "Bharat Electronics Limited" },
    { { 0x00, 0x1B, 0xB1 }, "WistronNeweb", "Wistron Neweb Corporation" },
    { { 0x00, 0x1B, 0xB2 }, "IntellectInt", "Intellect International NV" },
    { { 0x00, 0x1B, 0xB3 }, "Condalo",      "Condalo GmbH" },
    { { 0x00, 0x1B, 0xB4 }, "Airvod",       "Airvod Limited" },
    { { 0x00, 0x1B, 0xB5 }, "Cherry",       "Cherry GmbH" },
    { { 0x00, 0x1B, 0xB6 }, "BirdElectron", "Bird Electronic Corp." },
    { { 0x00, 0x1B, 0xB7 }, "AltaHeightsT", "Alta Heights Technology Corp." },
    { { 0x00, 0x1B, 0xB8 }, "BluewayElect", "Blueway Electronic Co;Ltd" },
    { { 0x00, 0x1B, 0xB9 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x1B, 0xBA }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1B, 0xBB }, "RFTech",       "RFTech Co.,Ltd" },
    { { 0x00, 0x1B, 0xBC }, "SilverPeak",   "Silver Peak Systems, Inc." },
    { { 0x00, 0x1B, 0xBD }, "FMCKongsberg", "FMC Kongsberg Subsea AS" },
    { { 0x00, 0x1B, 0xBE }, "ICOPDigital",  "ICOP Digital" },
    { { 0x00, 0x1B, 0xBF }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x1B, 0xC0 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x1B, 0xC1 }, "HOLUXTechnol", "HOLUX Technology, Inc." },
    { { 0x00, 0x1B, 0xC2 }, "IntegratedCo", "Integrated Control Technology Limitied" },
    { { 0x00, 0x1B, 0xC3 }, "Mobisolution", "Mobisolution Co.,Ltd" },
    { { 0x00, 0x1B, 0xC4 }, "Ultratec",     "Ultratec, Inc." },
    { { 0x00, 0x1B, 0xC6 }, "StratoRechen", "Strato Rechenzentrum AG" },
    { { 0x00, 0x1B, 0xC7 }, "StarVediaTec", "StarVedia Technology Inc." },
    { { 0x00, 0x1B, 0xC8 }, "Miura",        "Miura Co.,Ltd" },
    { { 0x00, 0x1B, 0xC9 }, "FsnDisplay",   "Fsn Display Inc" },
    { { 0x00, 0x1B, 0xCA }, "RunTechnolog", "Beijing Run Technology LTD. Company" },
    { { 0x00, 0x1B, 0xCB }, "Pempek",       "Pempek Systems Pty Ltd" },
    { { 0x00, 0x1B, 0xCC }, "KingtekCctvA", "Kingtek Cctv Alliance Co., Ltd." },
    { { 0x00, 0x1B, 0xCD }, "DaviscommsPt", "Daviscomms (S) Pte Ltd" },
    { { 0x00, 0x1B, 0xCE }, "MeasurementD", "Measurement Devices Ltd" },
    { { 0x00, 0x1B, 0xCF }, "Dataupia",     "Dataupia Corporation" },
    { { 0x00, 0x1B, 0xD0 }, "IdentecSolut", "Identec Solutions" },
    { { 0x00, 0x1B, 0xD1 }, "Sogestmatic",  "Sogestmatic" },
    { { 0x00, 0x1B, 0xD2 }, "ULTRAXASIAPA", "ULTRA-X ASIA PACIFIC Inc." },
    { { 0x00, 0x1B, 0xD3 }, "PanasonicAVC", "Panasonic Corporation AVC Networks Company" },
    { { 0x00, 0x1B, 0xD4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0xD5 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1B, 0xD6 }, "KelvinHughes", "Kelvin Hughes Ltd" },
    { { 0x00, 0x1B, 0xD7 }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x1B, 0xD8 }, "FLIR",         "FLIR Systems Inc" },
    { { 0x00, 0x1B, 0xD9 }, "EdgewaterWir", "Edgewater Wireless Systems Inc" },
    { { 0x00, 0x1B, 0xDA }, "UTStarcom",    "UTStarcom Inc" },
    { { 0x00, 0x1B, 0xDB }, "ValeoVECS",    "Valeo VECS" },
    { { 0x00, 0x1B, 0xDC }, "Vencer",       "Vencer Co., Ltd." },
    { { 0x00, 0x1B, 0xDD }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1B, 0xDE }, "RenkusHeinz",  "Renkus-Heinz, Inc." },
    { { 0x00, 0x1B, 0xDF }, "IskraSistemi", "Iskra Sistemi d.d." },
    { { 0x00, 0x1B, 0xE0 }, "TELENOTELECT", "TELENOT ELECTRONIC GmbH" },
    { { 0x00, 0x1B, 0xE1 }, "ViaLogy",      "ViaLogy" },
    { { 0x00, 0x1B, 0xE2 }, "AhnLab",       "AhnLab,Inc." },
    { { 0x00, 0x1B, 0xE3 }, "HealthHeroNe", "Health Hero Network, Inc." },
    { { 0x00, 0x1B, 0xE4 }, "Townet",       "Townet Srl" },
    { { 0x00, 0x1B, 0xE5 }, "802automatio", "802automation Limited" },
    { { 0x00, 0x1B, 0xE6 }, "Vr",           "Vr Ag" },
    { { 0x00, 0x1B, 0xE7 }, "PostekElectr", "Postek Electronics Co., Ltd." },
    { { 0x00, 0x1B, 0xE8 }, "Ultratronik",  "Ultratronik GmbH" },
    { { 0x00, 0x1B, 0xE9 }, "Broadcom",     "Broadcom" },
    { { 0x00, 0x1B, 0xEA }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1B, 0xEB }, "DMPElectroni", "DMP Electronics INC." },
    { { 0x00, 0x1B, 0xEC }, "NetioTechnol", "Netio Technologies Co., Ltd" },
    { { 0x00, 0x1B, 0xED }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x1B, 0xEE }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1B, 0xEF }, "BlossomsDigi", "Blossoms Digital Technology Co.,Ltd." },
    { { 0x00, 0x1B, 0xF0 }, "ValuePlatfor", "Value Platforms Limited" },
    { { 0x00, 0x1B, 0xF1 }, "NanjingSilve", "Nanjing SilverNet Software Co., Ltd." },
    { { 0x00, 0x1B, 0xF2 }, "KworldComput", "Kworld Computer Co., Ltd" },
    { { 0x00, 0x1B, 0xF3 }, "TRANSRADIOSe", "TRANSRADIO SenderSysteme Berlin AG" },
    { { 0x00, 0x1B, 0xF4 }, "KenwinIndust", "Kenwin Industrial(Hk) Ltd." },
    { { 0x00, 0x1B, 0xF5 }, "TellinkSiste", "Tellink Sistemas de Telecomunicación S.L." },
    { { 0x00, 0x1B, 0xF6 }, "CONWISETechn", "CONWISE Technology Corporation Ltd." },
    { { 0x00, 0x1B, 0xF7 }, "LundIPProduc", "Lund IP Products AB" },
    { { 0x00, 0x1B, 0xF8 }, "Digitrax",     "Digitrax Inc." },
    { { 0x00, 0x1B, 0xF9 }, "IntellitectW", "Intellitect Water Ltd" },
    { { 0x00, 0x1B, 0xFA }, "GiNmbH",       "G.i.N. mbH" },
    { { 0x00, 0x1B, 0xFB }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x1B, 0xFC }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x1B, 0xFD }, "Dignsys",      "Dignsys Inc." },
    { { 0x00, 0x1B, 0xFE }, "Zavio",        "Zavio Inc." },
    { { 0x00, 0x1B, 0xFF }, "MillenniaMed", "Millennia Media inc." },
    { { 0x00, 0x1C, 0x00 }, "EntryPoint",   "Entry Point, LLC" },
    { { 0x00, 0x1C, 0x01 }, "ABBDrives",    "ABB Oy Drives" },
    { { 0x00, 0x1C, 0x02 }, "PanoLogic",    "Pano Logic" },
    { { 0x00, 0x1C, 0x03 }, "BettyTVTechn", "Betty TV Technology AG" },
    { { 0x00, 0x1C, 0x04 }, "Airgain",      "Airgain, Inc." },
    { { 0x00, 0x1C, 0x05 }, "NoninMedical", "Nonin Medical Inc." },
    { { 0x00, 0x1C, 0x06 }, "SiemensNumer", "Siemens Numerical Control Ltd., Nanjing" },
    { { 0x00, 0x1C, 0x07 }, "Cwlinux",      "Cwlinux Limited" },
    { { 0x00, 0x1C, 0x08 }, "Echo360",      "Echo360, Inc." },
    { { 0x00, 0x1C, 0x09 }, "SAEElectroni", "SAE Electronic Co.,Ltd." },
    { { 0x00, 0x1C, 0x0A }, "AEETechnolog", "Shenzhen AEE Technology Co.,Ltd." },
    { { 0x00, 0x1C, 0x0B }, "SmartAntTele", "SmartAnt Telecom" },
    { { 0x00, 0x1C, 0x0C }, "TANITA",       "TANITA Corporation" },
    { { 0x00, 0x1C, 0x0D }, "GTechnology",  "G-Technology, Inc." },
    { { 0x00, 0x1C, 0x0E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0x0F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0x10 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x1C, 0x11 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1C, 0x12 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1C, 0x13 }, "OptsysTechno", "Optsys Technology Co., Ltd." },
    { { 0x00, 0x1C, 0x14 }, "VMware",       "VMware, Inc." },
    { { 0x00, 0x1C, 0x15 }, "iPhotonix",    "iPhotonix LLC" },
    { { 0x00, 0x1C, 0x16 }, "ThyssenKrupp", "ThyssenKrupp Elevator" },
    { { 0x00, 0x1C, 0x17 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1C, 0x18 }, "Sicert",       "Sicert S.r.L." },
    { { 0x00, 0x1C, 0x19 }, "secunetSecur", "secunet Security Networks AG" },
    { { 0x00, 0x1C, 0x1A }, "ThomasInstru", "Thomas Instrumentation, Inc" },
    { { 0x00, 0x1C, 0x1B }, "Hyperstone",   "Hyperstone GmbH" },
    { { 0x00, 0x1C, 0x1C }, "CenterCommun", "Center Communication Systems GmbH" },
    { { 0x00, 0x1C, 0x1D }, "ChenzhouGosp", "Chenzhou Gospell Digital Technology Co.,Ltd" },
    { { 0x00, 0x1C, 0x1E }, "emtrion",      "emtrion GmbH" },
    { { 0x00, 0x1C, 0x1F }, "QuestRetailT", "Quest Retail Technology Pty Ltd" },
    { { 0x00, 0x1C, 0x20 }, "CLBBenelux",   "CLB Benelux" },
    { { 0x00, 0x1C, 0x21 }, "Nucsafe",      "Nucsafe Inc." },
    { { 0x00, 0x1C, 0x22 }, "AerisElettro", "Aeris Elettronica s.r.l." },
    { { 0x00, 0x1C, 0x23 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x1C, 0x24 }, "FormosaWirel", "Formosa Wireless Systems Corp." },
    { { 0x00, 0x1C, 0x25 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x1C, 0x26 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x1C, 0x27 }, "SunellElectr", "Sunell Electronics Co." },
    { { 0x00, 0x1C, 0x28 }, "SphaironTech", "Sphairon Technologies GmbH" },
    { { 0x00, 0x1C, 0x29 }, "CoreDigitalE", "Core Digital Electronics Co., Ltd" },
    { { 0x00, 0x1C, 0x2A }, "EnvisacorTec", "Envisacor Technologies Inc." },
    { { 0x00, 0x1C, 0x2B }, "Alertmecom",   "Alertme.com Limited" },
    { { 0x00, 0x1C, 0x2C }, "Synapse",      "Synapse" },
    { { 0x00, 0x1C, 0x2D }, "FlexRadio",    "FlexRadio Systems" },
    { { 0x00, 0x1C, 0x2E }, "HPNSupplyCha", "HPN Supply Chain" },
    { { 0x00, 0x1C, 0x2F }, "Pfister",      "Pfister GmbH" },
    { { 0x00, 0x1C, 0x30 }, "ModeLighting", "Mode Lighting (UK ) Ltd." },
    { { 0x00, 0x1C, 0x31 }, "MobileXPTech", "Mobile XP Technology Co., LTD" },
    { { 0x00, 0x1C, 0x32 }, "Telian",       "Telian Corporation" },
    { { 0x00, 0x1C, 0x33 }, "Sutron",       "Sutron" },
    { { 0x00, 0x1C, 0x34 }, "HueyChiaoInt", "Huey Chiao International Co., Ltd." },
    { { 0x00, 0x1C, 0x35 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1C, 0x36 }, "iNEWiT",       "iNEWiT NV" },
    { { 0x00, 0x1C, 0x37 }, "Callpod",      "Callpod, Inc." },
    { { 0x00, 0x1C, 0x38 }, "BioRadLabora", "Bio-Rad Laboratories, Inc." },
    { { 0x00, 0x1C, 0x39 }, "SNetsystems",  "S Netsystems Inc." },
    { { 0x00, 0x1C, 0x3A }, "ElementLabs",  "Element Labs, Inc." },
    { { 0x00, 0x1C, 0x3B }, "AmRoadTechno", "AmRoad Technology Inc." },
    { { 0x00, 0x1C, 0x3C }, "SeonDesign",   "Seon Design Inc." },
    { { 0x00, 0x1C, 0x3D }, "WaveStorm",    "WaveStorm" },
    { { 0x00, 0x1C, 0x3E }, "ECKey",        "ECKey Corporation" },
    { { 0x00, 0x1C, 0x3F }, "Internationa", "International Police Technologies, Inc." },
    { { 0x00, 0x1C, 0x40 }, "VDGSecurity",  "VDG-Security bv" },
    { { 0x00, 0x1C, 0x41 }, "scemtecTrans", "scemtec Transponder Technology GmbH" },
    { { 0x00, 0x1C, 0x42 }, "Parallels",    "Parallels, Inc." },
    { { 0x00, 0x1C, 0x43 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1C, 0x44 }, "BoschSecurit", "Bosch Security Systems BV" },
    { { 0x00, 0x1C, 0x45 }, "ChenbroMicom", "Chenbro Micom Co., Ltd." },
    { { 0x00, 0x1C, 0x46 }, "Qtum",         "Qtum" },
    { { 0x00, 0x1C, 0x47 }, "HollysysAuto", "Hangzhou Hollysys Automation Co., Ltd" },
    { { 0x00, 0x1C, 0x48 }, "WiDeFi",       "WiDeFi, Inc." },
    { { 0x00, 0x1C, 0x49 }, "ZoltanTechno", "Zoltan Technology Inc." },
    { { 0x00, 0x1C, 0x4A }, "AVM",          "AVM GmbH" },
    { { 0x00, 0x1C, 0x4B }, "Gener8",       "Gener8, Inc." },
    { { 0x00, 0x1C, 0x4C }, "PetrotestIns", "Petrotest Instruments" },
    { { 0x00, 0x1C, 0x4D }, "AplixIPHoldi", "Aplix IP Holdings Corporation" },
    { { 0x00, 0x1C, 0x4E }, "TASAInternat", "TASA International Limited" },
    { { 0x00, 0x1C, 0x4F }, "Macab",        "Macab Ab" },
    { { 0x00, 0x1C, 0x50 }, "TCLTechnolyE", "TCL Technoly Electronics (Huizhou) Co., Ltd." },
    { { 0x00, 0x1C, 0x51 }, "CelenoCommun", "Celeno Communications" },
    { { 0x00, 0x1C, 0x52 }, "Visionee",     "Visionee Srl" },
    { { 0x00, 0x1C, 0x53 }, "SynergyLight", "Synergy Lighting Controls" },
    { { 0x00, 0x1C, 0x54 }, "HillstoneNet", "Hillstone Networks Inc" },
    { { 0x00, 0x1C, 0x55 }, "KaifaTechnol", "Shenzhen Kaifa Technology Co." },
    { { 0x00, 0x1C, 0x56 }, "Pado",         "Pado Systems, Inc." },
    { { 0x00, 0x1C, 0x57 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0x58 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0x59 }, "DevonIt",      "Devon It" },
    { { 0x00, 0x1C, 0x5A }, "AdvancedRela", "Advanced Relay Corporation" },
    { { 0x00, 0x1C, 0x5B }, "ChubbElectro", "Chubb Electronic Security Systems Ltd" },
    { { 0x00, 0x1C, 0x5C }, "IntegratedMe", "Integrated Medical Systems, Inc." },
    { { 0x00, 0x1C, 0x5D }, "LeicaMicrosy", "Leica Microsystems" },
    { { 0x00, 0x1C, 0x5E }, "ASTONFrance",  "ASTON France" },
    { { 0x00, 0x1C, 0x5F }, "WinlandElect", "Winland Electronics, Inc." },
    { { 0x00, 0x1C, 0x60 }, "CSPFrontierT", "CSP Frontier Technologies,Inc." },
    { { 0x00, 0x1C, 0x61 }, "GalaxyMicros", "Galaxy Microsystems LImited" },
    { { 0x00, 0x1C, 0x62 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x1C, 0x63 }, "Truen",        "Truen" },
    { { 0x00, 0x1C, 0x64 }, "LandisGyr",    "Landis+Gyr" },
    { { 0x00, 0x1C, 0x65 }, "JoeScan",      "JoeScan, Inc." },
    { { 0x00, 0x1C, 0x66 }, "Ucamp",        "Ucamp Co.,Ltd" },
    { { 0x00, 0x1C, 0x67 }, "PumpkinNetwo", "Pumpkin Networks, Inc." },
    { { 0x00, 0x1C, 0x68 }, "AnhuiSunCrea", "Anhui Sun Create Electronics Co., Ltd" },
    { { 0x00, 0x1C, 0x69 }, "PacketVision", "Packet Vision Ltd" },
    { { 0x00, 0x1C, 0x6A }, "WeissEnginee", "Weiss Engineering Ltd." },
    { { 0x00, 0x1C, 0x6B }, "COVAX",        "COVAX Co. Ltd" },
    { { 0x00, 0x1C, 0x6C }, "30805",        "30805" },
    { { 0x00, 0x1C, 0x6D }, "KyohritsuEle", "Kyohritsu Electronic Industry Co., Ltd." },
    { { 0x00, 0x1C, 0x6E }, "NewburyNetwo", "Newbury Networks, Inc." },
    { { 0x00, 0x1C, 0x6F }, "Emfit",        "Emfit Ltd" },
    { { 0x00, 0x1C, 0x70 }, "NovacommLtda", "Novacomm Ltda" },
    { { 0x00, 0x1C, 0x71 }, "EmergentElec", "Emergent Electronics" },
    { { 0x00, 0x1C, 0x72 }, "MayerCie",     "Mayer & Cie GmbH & Co KG" },
    { { 0x00, 0x1C, 0x73 }, "AristaNetwor", "Arista Networks" },
    { { 0x00, 0x1C, 0x74 }, "SyswanTechno", "Syswan Technologies Inc." },
    { { 0x00, 0x1C, 0x75 }, "Segnet",       "Segnet Ltd." },
    { { 0x00, 0x1C, 0x76 }, "WandsworthGr", "The Wandsworth Group Ltd" },
    { { 0x00, 0x1C, 0x77 }, "Prodys",       "Prodys" },
    { { 0x00, 0x1C, 0x78 }, "WyplaySas",    "Wyplay Sas" },
    { { 0x00, 0x1C, 0x79 }, "CohesiveFina", "Cohesive Financial Technologies LLC" },
    { { 0x00, 0x1C, 0x7A }, "PerfectoneNe", "Perfectone Netware Company Ltd" },
    { { 0x00, 0x1C, 0x7B }, "CastlenetTec", "Castlenet Technology Inc." },
    { { 0x00, 0x1C, 0x7C }, "Perq",         "Perq Systems Corporation" },
    { { 0x00, 0x1C, 0x7D }, "ExcelpointMa", "Excelpoint Manufacturing Pte Ltd" },
    { { 0x00, 0x1C, 0x7E }, "Toshiba",      "Toshiba" },
    { { 0x00, 0x1C, 0x7F }, "CheckPointSo", "Check Point Software Technologies" },
    { { 0x00, 0x1C, 0x80 }, "NewBusinessD", "New Business Division/Rhea-Information CO., LTD." },
    { { 0x00, 0x1C, 0x81 }, "NextGenVentu", "NextGen Venturi LTD" },
    { { 0x00, 0x1C, 0x82 }, "GenewTechnol", "Genew Technologies" },
    { { 0x00, 0x1C, 0x83 }, "NewLevelTele", "New Level Telecom Co., Ltd." },
    { { 0x00, 0x1C, 0x84 }, "STLSolution",  "STL Solution Co.,Ltd." },
    { { 0x00, 0x1C, 0x85 }, "Eunicorn",     "Eunicorn" },
    { { 0x00, 0x1C, 0x86 }, "Cranite",      "Cranite Systems, Inc." },
    { { 0x00, 0x1C, 0x87 }, "Uriver",       "Uriver Inc." },
    { { 0x00, 0x1C, 0x88 }, "Transystem",   "Transystem Inc." },
    { { 0x00, 0x1C, 0x89 }, "ForceCommuni", "Force Communications, Inc." },
    { { 0x00, 0x1C, 0x8A }, "Cirrascale",   "Cirrascale Corporation" },
    { { 0x00, 0x1C, 0x8B }, "MJInnovation", "MJ Innovations Ltd." },
    { { 0x00, 0x1C, 0x8C }, "DialTechnolo", "Dial Technology Ltd." },
    { { 0x00, 0x1C, 0x8D }, "MesaImaging",  "Mesa Imaging" },
    { { 0x00, 0x1C, 0x8E }, "AlcatelLucen", "Alcatel-Lucent IPD" },
    { { 0x00, 0x1C, 0x8F }, "AdvancedElec", "Advanced Electronic Design, Inc." },
    { { 0x00, 0x1C, 0x90 }, "Empacket",     "Empacket Corporation" },
    { { 0x00, 0x1C, 0x91 }, "Gefen",        "Gefen LLC" },
    { { 0x00, 0x1C, 0x92 }, "Tervela",      "Tervela" },
    { { 0x00, 0x1C, 0x93 }, "ExaDigm",      "ExaDigm Inc" },
    { { 0x00, 0x1C, 0x94 }, "LICORBioscie", "LI-COR Biosciences" },
    { { 0x00, 0x1C, 0x95 }, "Opticomm",     "Opticomm Corporation" },
    { { 0x00, 0x1C, 0x96 }, "LinkwiseTech", "Linkwise Technology Pte Ltd" },
    { { 0x00, 0x1C, 0x97 }, "EnzytekTechn", "Enzytek Technology Inc.," },
    { { 0x00, 0x1C, 0x98 }, "LuckyTechnol", "Lucky Technology (Hk) Company Limited" },
    { { 0x00, 0x1C, 0x99 }, "ShunraSoftwa", "Shunra Software Ltd." },
    { { 0x00, 0x1C, 0x9A }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1C, 0x9B }, "FEIGELECTRON", "FEIG ELECTRONIC GmbH" },
    { { 0x00, 0x1C, 0x9C }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1C, 0x9D }, "Liecthi",      "Liecthi AG" },
    { { 0x00, 0x1C, 0x9E }, "DualtechIT",   "Dualtech IT AB" },
    { { 0x00, 0x1C, 0x9F }, "Razorstream",  "Razorstream, LLC" },
    { { 0x00, 0x1C, 0xA0 }, "ProductionRe", "Production Resource Group, LLC" },
    { { 0x00, 0x1C, 0xA1 }, "AkamaiTechno", "Akamai Technologies Inc." },
    { { 0x00, 0x1C, 0xA2 }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x1C, 0xA3 }, "Terra",        "Terra" },
    { { 0x00, 0x1C, 0xA4 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1C, 0xA5 }, "Zygo",         "Zygo Corporation" },
    { { 0x00, 0x1C, 0xA6 }, "Win4NET",      "Win4NET" },
    { { 0x00, 0x1C, 0xA7 }, "Internationa", "International Quartz Limited" },
    { { 0x00, 0x1C, 0xA8 }, "AirTiesWirel", "AirTies Wireless Networks" },
    { { 0x00, 0x1C, 0xA9 }, "Audiomatica",  "Audiomatica Srl" },
    { { 0x00, 0x1C, 0xAA }, "Bellon",       "Bellon Pty Ltd" },
    { { 0x00, 0x1C, 0xAB }, "MeyerSoundLa", "Meyer Sound Laboratories, Inc." },
    { { 0x00, 0x1C, 0xAC }, "QniqTechnolo", "Qniq Technology Corp." },
    { { 0x00, 0x1C, 0xAD }, "Telecommunic", "Wuhan Telecommunication Devices Co.,Ltd" },
    { { 0x00, 0x1C, 0xAE }, "WiChorus",     "WiChorus, Inc." },
    { { 0x00, 0x1C, 0xAF }, "PlatoNetwork", "Plato Networks Inc." },
    { { 0x00, 0x1C, 0xB0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0xB1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0xB2 }, "Bpt",          "Bpt Spa" },
    { { 0x00, 0x1C, 0xB3 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x1C, 0xB4 }, "IridiumSatel", "Iridium Satellite LLC" },
    { { 0x00, 0x1C, 0xB5 }, "NeihuaNetwor", "Neihua Network Technology Co.,LTD.(NHN)" },
    { { 0x00, 0x1C, 0xB6 }, "DuzonCNT",     "Duzon CNT Co., Ltd." },
    { { 0x00, 0x1C, 0xB7 }, "USCDigiArk",   "USC DigiArk Corporation" },
    { { 0x00, 0x1C, 0xB8 }, "CBC",          "CBC Co., Ltd" },
    { { 0x00, 0x1C, 0xB9 }, "KwangSungEle", "Kwang Sung Electronics Co., Ltd." },
    { { 0x00, 0x1C, 0xBA }, "VerScient",    "VerScient, Inc." },
    { { 0x00, 0x1C, 0xBB }, "MusicianLink", "MusicianLink" },
    { { 0x00, 0x1C, 0xBC }, "CastGrabber",  "CastGrabber, LLC" },
    { { 0x00, 0x1C, 0xBD }, "EzzeMobileTe", "Ezze Mobile Tech., Inc." },
    { { 0x00, 0x1C, 0xBE }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1C, 0xBF }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1C, 0xC0 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1C, 0xC1 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1C, 0xC2 }, "PartIIResear", "Part II Research, Inc." },
    { { 0x00, 0x1C, 0xC3 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1C, 0xC4 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x1C, 0xC5 }, "3Com",         "3Com Ltd" },
    { { 0x00, 0x1C, 0xC6 }, "ProStor",      "ProStor Systems" },
    { { 0x00, 0x1C, 0xC7 }, "RembrandtTec", "Rembrandt Technologies, LLC d/b/a REMSTREAM" },
    { { 0x00, 0x1C, 0xC8 }, "INDUSTRONICI", "INDUSTRONIC Industrie-Electronic GmbH & Co. KG" },
    { { 0x00, 0x1C, 0xC9 }, "KaiseElectro", "Kaise Electronic Technology Co., Ltd." },
    { { 0x00, 0x1C, 0xCA }, "GaozhiScienc", "Shanghai Gaozhi Science & Technology Development Co." },
    { { 0x00, 0x1C, 0xCB }, "ForthPublic",  "Forth Corporation Public Company Limited" },
    { { 0x00, 0x1C, 0xCC }, "BlackBerryRT", "BlackBerry RTS" },
    { { 0x00, 0x1C, 0xCD }, "Alektrona",    "Alektrona Corporation" },
    { { 0x00, 0x1C, 0xCE }, "ByTechdesign", "By Techdesign" },
    { { 0x00, 0x1C, 0xCF }, "Limetek",      "Limetek" },
    { { 0x00, 0x1C, 0xD0 }, "Circleone",    "Circleone Co.,Ltd." },
    { { 0x00, 0x1C, 0xD1 }, "WavesAudio",   "Waves Audio LTD" },
    { { 0x00, 0x1C, 0xD2 }, "KingChampion", "King Champion (Hong Kong) Limited" },
    { { 0x00, 0x1C, 0xD3 }, "ZPEngineerin", "ZP Engineering SEL" },
    { { 0x00, 0x1C, 0xD4 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1C, 0xD5 }, "ZeeVee",       "ZeeVee, Inc." },
    { { 0x00, 0x1C, 0xD6 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1C, 0xD7 }, "HarmanBecker", "Harman/Becker Automotive Systems GmbH" },
    { { 0x00, 0x1C, 0xD8 }, "BlueAntWirel", "BlueAnt Wireless" },
    { { 0x00, 0x1C, 0xD9 }, "GlobalTopTec", "GlobalTop Technology Inc." },
    { { 0x00, 0x1C, 0xDA }, "ExeginTechno", "Exegin Technologies Limited" },
    { { 0x00, 0x1C, 0xDB }, "Carpoint",     "Carpoint Co.,Ltd" },
    { { 0x00, 0x1C, 0xDC }, "CustomComput", "Custom Computer Services, Inc." },
    { { 0x00, 0x1C, 0xDD }, "CowbellEngin", "Cowbell Engineering Co., Ltd." },
    { { 0x00, 0x1C, 0xDE }, "InteractiveM", "Interactive Multimedia eXchange Inc." },
    { { 0x00, 0x1C, 0xDF }, "BelkinIntern", "Belkin International Inc." },
    { { 0x00, 0x1C, 0xE0 }, "DasanTps",     "Dasan Tps" },
    { { 0x00, 0x1C, 0xE1 }, "IndraSistema", "Indra Sistemas, S.A." },
    { { 0x00, 0x1C, 0xE2 }, "AtteroTech",   "Attero Tech, LLC." },
    { { 0x00, 0x1C, 0xE3 }, "Optimedical",  "Optimedical Systems" },
    { { 0x00, 0x1C, 0xE4 }, "EleSy",        "EleSy JSC" },
    { { 0x00, 0x1C, 0xE5 }, "MBSElectroni", "MBS Electronic Systems GmbH" },
    { { 0x00, 0x1C, 0xE6 }, "Innes",        "Innes" },
    { { 0x00, 0x1C, 0xE7 }, "RoconResearc", "Rocon PLC Research Centre" },
    { { 0x00, 0x1C, 0xE8 }, "Cummins",      "Cummins Inc" },
    { { 0x00, 0x1C, 0xE9 }, "GalaxyTechno", "Galaxy Technology Limited" },
    { { 0x00, 0x1C, 0xEA }, "ScientificAt", "Scientific-Atlanta, Inc" },
    { { 0x00, 0x1C, 0xEB }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1C, 0xEC }, "Mobilesoft",   "Mobilesoft (Aust.) Pty Ltd" },
    { { 0x00, 0x1C, 0xED }, "Environnemen", "Environnement Sa" },
    { { 0x00, 0x1C, 0xEE }, "SHARP",        "SHARP Corporation" },
    { { 0x00, 0x1C, 0xEF }, "PrimaxElectr", "Primax Electronics Ltd." },
    { { 0x00, 0x1C, 0xF0 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x1C, 0xF1 }, "SUPoXTechnol", "SUPoX Technology Co. , LTD." },
    { { 0x00, 0x1C, 0xF2 }, "TenlonTechno", "Tenlon Technology Co.,Ltd." },
    { { 0x00, 0x1C, 0xF3 }, "EvsBroadcast", "Evs Broadcast Equipment" },
    { { 0x00, 0x1C, 0xF4 }, "MediaTechnol", "Media Technology Systems Inc" },
    { { 0x00, 0x1C, 0xF5 }, "WiseblueTech", "Wiseblue Technology Limited" },
    { { 0x00, 0x1C, 0xF6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0xF7 }, "AudioScience", "AudioScience" },
    { { 0x00, 0x1C, 0xF8 }, "ParadeTechno", "Parade Technologies, Ltd." },
    { { 0x00, 0x1C, 0xF9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1C, 0xFA }, "Alarmcom",     "Alarm.com" },
    { { 0x00, 0x1C, 0xFB }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1C, 0xFC }, "SumitomoElec", "Sumitomo Electric Industries, Ltd" },
    { { 0x00, 0x1C, 0xFD }, "UniversalEle", "Universal Electronics, Inc." },
    { { 0x00, 0x1C, 0xFE }, "Quartics",     "Quartics Inc" },
    { { 0x00, 0x1C, 0xFF }, "NaperaNetwor", "Napera Networks Inc" },
    { { 0x00, 0x1D, 0x00 }, "Brivo",        "Brivo Systems, LLC" },
    { { 0x00, 0x1D, 0x01 }, "NeptuneDigit", "Neptune Digital" },
    { { 0x00, 0x1D, 0x02 }, "CybertechTel", "Cybertech Telecom Development" },
    { { 0x00, 0x1D, 0x03 }, "DesignSoluti", "Design Solutions Inc." },
    { { 0x00, 0x1D, 0x04 }, "ZipitWireles", "Zipit Wireless, Inc." },
    { { 0x00, 0x1D, 0x05 }, "CooperLighti", "Cooper Lighting Solutions" },
    { { 0x00, 0x1D, 0x06 }, "HMElectronic", "HM Electronics, Inc." },
    { { 0x00, 0x1D, 0x07 }, "SangFeiConsu", "Shenzhen Sang Fei Consumer Communications Co.,Ltd" },
    { { 0x00, 0x1D, 0x08 }, "JiangsuYinhe", "Jiangsu Yinhe Electronics Co.,Ltd." },
    { { 0x00, 0x1D, 0x09 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x1D, 0x0A }, "DavisInstrum", "Davis Instruments, Inc." },
    { { 0x00, 0x1D, 0x0B }, "PowerStandar", "Power Standards Lab" },
    { { 0x00, 0x1D, 0x0C }, "MobileCompia", "MobileCompia" },
    { { 0x00, 0x1D, 0x0D }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0x1D, 0x0E }, "AgaphaTechno", "Agapha Technology co., Ltd." },
    { { 0x00, 0x1D, 0x0F }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x1D, 0x10 }, "LightHausLog", "LightHaus Logic, Inc." },
    { { 0x00, 0x1D, 0x11 }, "AnalogueMicr", "Analogue & Micro Ltd" },
    { { 0x00, 0x1D, 0x12 }, "Rohm",         "Rohm Co., Ltd." },
    { { 0x00, 0x1D, 0x13 }, "NextGTV",      "NextGTV" },
    { { 0x00, 0x1D, 0x14 }, "SperadtoneIn", "Speradtone Information Technology Limited" },
    { { 0x00, 0x1D, 0x15 }, "DolphinElect", "Shenzhen Dolphin Electronic Co., Ltd" },
    { { 0x00, 0x1D, 0x16 }, "Sfr",          "Sfr" },
    { { 0x00, 0x1D, 0x17 }, "DigitalSky",   "Digital Sky Corporation" },
    { { 0x00, 0x1D, 0x18 }, "PowerInnovat", "Power Innovation GmbH" },
    { { 0x00, 0x1D, 0x19 }, "ArcadyanTech", "Arcadyan Technology Corporation" },
    { { 0x00, 0x1D, 0x1A }, "OvisLink",     "OvisLink S.A." },
    { { 0x00, 0x1D, 0x1B }, "SangeanElect", "Sangean Electronics Inc." },
    { { 0x00, 0x1D, 0x1C }, "Gennet",       "Gennet s.a." },
    { { 0x00, 0x1D, 0x1D }, "InterM",       "Inter-M Corporation" },
    { { 0x00, 0x1D, 0x1E }, "KyushuTen",    "Kyushu Ten Co.,Ltd" },
    { { 0x00, 0x1D, 0x1F }, "SiauliuTauro", "Siauliu Tauro Televizoriai, JSC" },
    { { 0x00, 0x1D, 0x20 }, "Comtrend",     "Comtrend Corporation" },
    { { 0x00, 0x1D, 0x21 }, "AlcadSL",      "Alcad SL" },
    { { 0x00, 0x1D, 0x22 }, "FossAnalytic", "Foss Analytical A/S" },
    { { 0x00, 0x1D, 0x23 }, "Sensus",       "Sensus" },
    { { 0x00, 0x1D, 0x24 }, "AclaraPowerL", "Aclara Power-Line Systems Inc." },
    { { 0x00, 0x1D, 0x25 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1D, 0x26 }, "Rockridgesou", "Rockridgesound Technology Co." },
    { { 0x00, 0x1D, 0x27 }, "NacIntercom",  "Nac-Intercom" },
    { { 0x00, 0x1D, 0x28 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1D, 0x29 }, "Doro",         "Doro AB" },
    { { 0x00, 0x1D, 0x2A }, "BulTech",      "Shenzhen Bul-Tech Co.,Ltd." },
    { { 0x00, 0x1D, 0x2B }, "PontTechnolo", "Wuhan Pont Technology CO. , LTD" },
    { { 0x00, 0x1D, 0x2C }, "WavetrendTec", "Wavetrend Technologies (Pty) Limited" },
    { { 0x00, 0x1D, 0x2D }, "Pylone",       "Pylone, Inc." },
    { { 0x00, 0x1D, 0x2E }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0x1D, 0x2F }, "QuantumVisio", "QuantumVision Corporation" },
    { { 0x00, 0x1D, 0x30 }, "YXWireless",   "YX Wireless S.A." },
    { { 0x00, 0x1D, 0x31 }, "HighproInter", "Highpro International R&D Co,.Ltd." },
    { { 0x00, 0x1D, 0x32 }, "LongkayCommu", "Longkay Communication & Technology (Shanghai) Co. Ltd" },
    { { 0x00, 0x1D, 0x33 }, "Maverick",     "Maverick Systems Inc." },
    { { 0x00, 0x1D, 0x34 }, "SYRISTechnol", "SYRIS Technology Corp" },
    { { 0x00, 0x1D, 0x35 }, "ViconicsElec", "Viconics Electronics Inc." },
    { { 0x00, 0x1D, 0x36 }, "ElectronicsI", "Electronics Corporation Of India Limited" },
    { { 0x00, 0x1D, 0x37 }, "ThalesPandaT", "Thales-Panda Transportation System" },
    { { 0x00, 0x1D, 0x38 }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x1D, 0x39 }, "Moohadigital", "Moohadigital Co., Ltd" },
    { { 0x00, 0x1D, 0x3A }, "mhacoustics",  "mh acoustics LLC" },
    { { 0x00, 0x1D, 0x3B }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1D, 0x3C }, "Muscle",       "Muscle Corporation" },
    { { 0x00, 0x1D, 0x3D }, "Avidyne",      "Avidyne Corporation" },
    { { 0x00, 0x1D, 0x3E }, "SakaTechnoSc", "Saka Techno Science Co.,Ltd" },
    { { 0x00, 0x1D, 0x3F }, "Mitron",       "Mitron Pty Ltd" },
    { { 0x00, 0x1D, 0x40 }, "Intel–GECare", "Intel – GE Care Innovations LLC" },
    { { 0x00, 0x1D, 0x41 }, "HardyInstrum", "Hardy Instruments" },
    { { 0x00, 0x1D, 0x42 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1D, 0x43 }, "GlinkDigital", "Shenzhen G-link Digital Technology Co., Ltd." },
    { { 0x00, 0x1D, 0x44 }, "Krohne",       "Krohne" },
    { { 0x00, 0x1D, 0x45 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0x46 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0x47 }, "Covote",       "Covote GmbH & Co KG" },
    { { 0x00, 0x1D, 0x48 }, "SensorTechni", "Sensor-Technik Wiedemann GmbH" },
    { { 0x00, 0x1D, 0x49 }, "InnovationWi", "Innovation Wireless Inc." },
    { { 0x00, 0x1D, 0x4A }, "CarestreamHe", "Carestream Health, Inc." },
    { { 0x00, 0x1D, 0x4B }, "GridConnect",  "Grid Connect Inc." },
    { { 0x00, 0x1D, 0x4C }, "AlcatelLucen", "Alcatel-Lucent" },
    { { 0x00, 0x1D, 0x4D }, "AdaptiveReco", "Adaptive Recognition Hungary, Inc" },
    { { 0x00, 0x1D, 0x4E }, "TCMMobile",    "TCM Mobile LLC" },
    { { 0x00, 0x1D, 0x4F }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x1D, 0x50 }, "Spinetix",     "Spinetix Sa" },
    { { 0x00, 0x1D, 0x51 }, "BabcockWilco", "Babcock & Wilcox Power Generation Group, Inc" },
    { { 0x00, 0x1D, 0x52 }, "Defzone",      "Defzone B.V." },
    { { 0x00, 0x1D, 0x53 }, "S&OElectroni", "S&O Electronics (Malaysia) Sdn. Bhd." },
    { { 0x00, 0x1D, 0x54 }, "SunnicTechno", "Sunnic Technology & Merchandise INC." },
    { { 0x00, 0x1D, 0x55 }, "ZANTAZ",       "ZANTAZ, Inc" },
    { { 0x00, 0x1D, 0x56 }, "KramerElectr", "Kramer Electronics Ltd." },
    { { 0x00, 0x1D, 0x57 }, "CAETECMesste", "CAETEC Messtechnik" },
    { { 0x00, 0x1D, 0x58 }, "CQ",           "CQ Inc" },
    { { 0x00, 0x1D, 0x59 }, "MitraEnergyI", "Mitra Energy & Infrastructure" },
    { { 0x00, 0x1D, 0x5A }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x1D, 0x5B }, "TecvanInform", "Tecvan Informatica Ltda" },
    { { 0x00, 0x1D, 0x5C }, "TomCommunica", "Tom Communication Industrial Co.,Ltd." },
    { { 0x00, 0x1D, 0x5D }, "ControlDynam", "Control Dynamics Pty. Ltd." },
    { { 0x00, 0x1D, 0x5E }, "ComingMedia",  "Coming Media Corp." },
    { { 0x00, 0x1D, 0x5F }, "OverSpeed",    "OverSpeed SARL" },
    { { 0x00, 0x1D, 0x60 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x1D, 0x61 }, "BIJ",          "BIJ Corporation" },
    { { 0x00, 0x1D, 0x62 }, "InPhaseTechn", "InPhase Technologies" },
    { { 0x00, 0x1D, 0x63 }, "MieleCie",     "Miele & Cie. KG" },
    { { 0x00, 0x1D, 0x64 }, "AdamCommunic", "Adam Communications Systems Int Ltd" },
    { { 0x00, 0x1D, 0x65 }, "MicrowaveRad", "Microwave Radio Communications" },
    { { 0x00, 0x1D, 0x66 }, "HyundaiTelec", "Hyundai Telecom" },
    { { 0x00, 0x1D, 0x67 }, "Amec",         "Amec" },
    { { 0x00, 0x1D, 0x68 }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x1D, 0x69 }, "KnorrBremseI", "Knorr-Bremse IT-Services GmbH" },
    { { 0x00, 0x1D, 0x6A }, "AlphaNetwork", "Alpha Networks Inc." },
    { { 0x00, 0x1D, 0x6B }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0x6C }, "ClariPhyComm", "ClariPhy Communications, Inc." },
    { { 0x00, 0x1D, 0x6D }, "ConfidantInt", "Confidant International LLC" },
    { { 0x00, 0x1D, 0x6E }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1D, 0x6F }, "ChainzoneTec", "Chainzone Technology Co., Ltd" },
    { { 0x00, 0x1D, 0x70 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0x71 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0x72 }, "Wistron",      "Wistron Corporation" },
    { { 0x00, 0x1D, 0x73 }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0x1D, 0x74 }, "TianjinChina", "Tianjin China-Silicon Microelectronics Co., Ltd." },
    { { 0x00, 0x1D, 0x75 }, "Radioscape",   "Radioscape PLC" },
    { { 0x00, 0x1D, 0x76 }, "Eyeheight",    "Eyeheight Ltd." },
    { { 0x00, 0x1D, 0x77 }, "NSGate",       "NSGate" },
    { { 0x00, 0x1D, 0x78 }, "InvengoInfor", "Invengo Information Technology Co.,Ltd" },
    { { 0x00, 0x1D, 0x79 }, "Signamax",     "Signamax Llc" },
    { { 0x00, 0x1D, 0x7A }, "WidebandSemi", "Wideband Semiconductor, Inc." },
    { { 0x00, 0x1D, 0x7B }, "IceEnergy",    "Ice Energy, Inc." },
    { { 0x00, 0x1D, 0x7C }, "ABEElettroni", "ABE Elettronica S.p.A." },
    { { 0x00, 0x1D, 0x7D }, "GigaByteTech", "Giga-Byte Technology Co.,Ltd." },
    { { 0x00, 0x1D, 0x7E }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x1D, 0x7F }, "TekronIntern", "Tekron International Ltd" },
    { { 0x00, 0x1D, 0x80 }, "HuahuanEletr", "Beijing Huahuan Eletronics Co.,Ltd" },
    { { 0x00, 0x1D, 0x81 }, "GuangzhouGat", "Guangzhou Gateway Electronics Co., Ltd" },
    { { 0x00, 0x1D, 0x82 }, "GNNetcom",     "GN Netcom A/S" },
    { { 0x00, 0x1D, 0x83 }, "Emitech",      "Emitech Corporation" },
    { { 0x00, 0x1D, 0x84 }, "Gateway",      "Gateway, Inc." },
    { { 0x00, 0x1D, 0x85 }, "CallDirectCe", "Call Direct Cellular Solutions" },
    { { 0x00, 0x1D, 0x86 }, "ShinwaIndust", "Shinwa Industries(China) Ltd." },
    { { 0x00, 0x1D, 0x87 }, "VigTechLabsS", "VigTech Labs Sdn Bhd" },
    { { 0x00, 0x1D, 0x88 }, "Clearwire",    "Clearwire" },
    { { 0x00, 0x1D, 0x89 }, "VaultStor",    "VaultStor Corporation" },
    { { 0x00, 0x1D, 0x8A }, "TechTrex",     "TechTrex Inc" },
    { { 0x00, 0x1D, 0x8B }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x1D, 0x8C }, "LaCrosseTech", "La Crosse Technology LTD" },
    { { 0x00, 0x1D, 0x8D }, "FlukeProcess", "Fluke Process Instruments GmbH" },
    { { 0x00, 0x1D, 0x8E }, "Alereon",      "Alereon, Inc." },
    { { 0x00, 0x1D, 0x8F }, "PureWaveNetw", "PureWave Networks" },
    { { 0x00, 0x1D, 0x90 }, "EMCOFlow",     "EMCO Flow Systems" },
    { { 0x00, 0x1D, 0x91 }, "Digitize",     "Digitize, Inc" },
    { { 0x00, 0x1D, 0x92 }, "MicroStarInt", "Micro-Star Int'L Co.,Ltd." },
    { { 0x00, 0x1D, 0x93 }, "Modacom",      "Modacom" },
    { { 0x00, 0x1D, 0x94 }, "ClimaxTechno", "Climax Technology Co., Ltd" },
    { { 0x00, 0x1D, 0x95 }, "Flash",        "Flash, Inc." },
    { { 0x00, 0x1D, 0x96 }, "WatchGuardVi", "WatchGuard Video" },
    { { 0x00, 0x1D, 0x97 }, "AlertusTechn", "Alertus Technologies LLC" },
    { { 0x00, 0x1D, 0x98 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1D, 0x99 }, "CyanOptic",    "Cyan Optic, Inc." },
    { { 0x00, 0x1D, 0x9A }, "GodexInterna", "Godex International Co., Ltd" },
    { { 0x00, 0x1D, 0x9B }, "HokuyoAutoma", "Hokuyo Automatic Co., Ltd." },
    { { 0x00, 0x1D, 0x9C }, "RockwellAuto", "Rockwell Automation" },
    { { 0x00, 0x1D, 0x9D }, "ArtjoyIntern", "Artjoy International Limited" },
    { { 0x00, 0x1D, 0x9E }, "AxionTechnol", "Axion Technologies" },
    { { 0x00, 0x1D, 0x9F }, "MATTRPTraczy", "MATT R.P.Traczynscy Sp.J." },
    { { 0x00, 0x1D, 0xA0 }, "HengYuElectr", "Heng Yu Electronic Manufacturing Company Limited" },
    { { 0x00, 0x1D, 0xA1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0xA2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0xA3 }, "SabiOso",      "SabiOso" },
    { { 0x00, 0x1D, 0xA4 }, "SystemTechno", "Hangzhou System Technology CO., LTD" },
    { { 0x00, 0x1D, 0xA5 }, "WBElectronic", "WB Electronics" },
    { { 0x00, 0x1D, 0xA6 }, "MediaNumeric", "Media Numerics Limited" },
    { { 0x00, 0x1D, 0xA7 }, "SeamlessInte", "Seamless Internet" },
    { { 0x00, 0x1D, 0xA8 }, "TakahataElec", "Takahata Electronics Co.,Ltd" },
    { { 0x00, 0x1D, 0xA9 }, "CastlesTechn", "Castles Technology, Co., LTD" },
    { { 0x00, 0x1D, 0xAA }, "DrayTek",      "DrayTek Corp." },
    { { 0x00, 0x1D, 0xAB }, "SwissQualLic", "SwissQual License AG" },
    { { 0x00, 0x1D, 0xAC }, "Gigamon",      "Gigamon Systems LLC" },
    { { 0x00, 0x1D, 0xAD }, "SinotechEngi", "Sinotech Engineering Consultants, Inc. Geotechnical Enginee" },
    { { 0x00, 0x1D, 0xAE }, "ChangTsengTe", "Chang Tseng Technology Co., Ltd" },
    { { 0x00, 0x1D, 0xAF }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1D, 0xB0 }, "FuJianHengTo", "FuJian HengTong Information Technology Co.,Ltd" },
    { { 0x00, 0x1D, 0xB1 }, "CrescendoNet", "Crescendo Networks" },
    { { 0x00, 0x1D, 0xB2 }, "HokkaidoElec", "Hokkaido Electric Engineering Co.,Ltd." },
    { { 0x00, 0x1D, 0xB3 }, "HPNSupplyCha", "HPN Supply Chain" },
    { { 0x00, 0x1D, 0xB4 }, "KumhoEng",     "Kumho Eng Co.,Ltd" },
    { { 0x00, 0x1D, 0xB5 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x1D, 0xB6 }, "BestCommNetw", "BestComm Networks, Inc." },
    { { 0x00, 0x1D, 0xB7 }, "TendrilNetwo", "Tendril Networks, Inc." },
    { { 0x00, 0x1D, 0xB8 }, "Intoto",       "Intoto Inc." },
    { { 0x00, 0x1D, 0xB9 }, "WellspringWi", "Wellspring Wireless" },
    { { 0x00, 0x1D, 0xBA }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1D, 0xBB }, "DynamicSyste", "Dynamic System Electronics Corp." },
    { { 0x00, 0x1D, 0xBC }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1D, 0xBD }, "Versamed",     "Versamed Inc." },
    { { 0x00, 0x1D, 0xBE }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xBF }, "RadiientTech", "Radiient Technologies, Inc." },
    { { 0x00, 0x1D, 0xC0 }, "EnphaseEnerg", "Enphase Energy" },
    { { 0x00, 0x1D, 0xC1 }, "AudinateL",    "Audinate Pty L" },
    { { 0x00, 0x1D, 0xC2 }, "Xortec",       "Xortec Oy" },
    { { 0x00, 0x1D, 0xC3 }, "RIKORTV",      "RIKOR TV, Ltd" },
    { { 0x00, 0x1D, 0xC4 }, "AIOI",         "AIOI Systems Co., Ltd." },
    { { 0x00, 0x1D, 0xC5 }, "JiaxunFeihon", "Beijing Jiaxun Feihong Electricial Co., Ltd." },
    { { 0x00, 0x1D, 0xC6 }, "SNR",          "SNR Inc." },
    { { 0x00, 0x1D, 0xC7 }, "L3Communicat", "L-3 Communications Geneva Aerospace" },
    { { 0x00, 0x1D, 0xC8 }, "NavionicsRes", "Navionics Research Inc., dba SCADAmetrics" },
    { { 0x00, 0x1D, 0xC9 }, "GainSpan",     "GainSpan Corp." },
    { { 0x00, 0x1D, 0xCA }, "PAVElectroni", "PAV Electronics Limited" },
    { { 0x00, 0x1D, 0xCB }, "ExénsDevelop", "Exéns Development Oy" },
    { { 0x00, 0x1D, 0xCC }, "AyonCyberSec", "Ayon Cyber Security, Inc" },
    { { 0x00, 0x1D, 0xCD }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xCE }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xCF }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD0 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD1 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD2 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD3 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD4 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD5 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD6 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1D, 0xD7 }, "Algolith",     "Algolith" },
    { { 0x00, 0x1D, 0xD8 }, "Microsoft",    "Microsoft Corporation" },
    { { 0x00, 0x1D, 0xD9 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x1D, 0xDA }, "Mikroelektro", "Mikroelektronika spol. s r. o." },
    { { 0x00, 0x1D, 0xDB }, "CBEL",         "C-BEL Corporation" },
    { { 0x00, 0x1D, 0xDC }, "DeChangLongT", "HangZhou DeChangLong Tech&Info Co.,Ltd" },
    { { 0x00, 0x1D, 0xDD }, "DatHK",        "Dat H.K. Limited" },
    { { 0x00, 0x1D, 0xDE }, "ZhejiangBroa", "Zhejiang Broadcast&Television Technology Co.,Ltd." },
    { { 0x00, 0x1D, 0xDF }, "SunitecEnter", "Sunitec Enterprise Co.,Ltd" },
    { { 0x00, 0x1D, 0xE0 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1D, 0xE1 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1D, 0xE2 }, "RadionorComm", "Radionor Communications" },
    { { 0x00, 0x1D, 0xE3 }, "Intuicom",     "Intuicom" },
    { { 0x00, 0x1D, 0xE4 }, "VisioneeredI", "Visioneered Image Systems" },
    { { 0x00, 0x1D, 0xE5 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0xE6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1D, 0xE7 }, "MarineSonicT", "Marine Sonic Technology, Ltd." },
    { { 0x00, 0x1D, 0xE8 }, "NikkoDenkiTs", "Nikko Denki Tsushin Corporation(NDTC)" },
    { { 0x00, 0x1D, 0xE9 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1D, 0xEA }, "CommtestInst", "Commtest Instruments Ltd" },
    { { 0x00, 0x1D, 0xEB }, "DINECInterna", "DINEC International" },
    { { 0x00, 0x1D, 0xEC }, "Marusys",      "Marusys" },
    { { 0x00, 0x1D, 0xED }, "GridNet",      "Grid Net, Inc." },
    { { 0x00, 0x1D, 0xEE }, "NextvisionSi", "Nextvision Sistemas Digitais De Televisão Ltda." },
    { { 0x00, 0x1D, 0xEF }, "Trimm",        "Trimm, Inc." },
    { { 0x00, 0x1D, 0xF0 }, "Vidient",      "Vidient Systems, Inc." },
    { { 0x00, 0x1D, 0xF1 }, "Intego",       "Intego Systems, Inc." },
    { { 0x00, 0x1D, 0xF2 }, "Netflix",      "Netflix, Inc." },
    { { 0x00, 0x1D, 0xF3 }, "SBSScienceTe", "SBS Science & Technology Co., Ltd" },
    { { 0x00, 0x1D, 0xF4 }, "MagellanTech", "Magellan Technology Pty Limited" },
    { { 0x00, 0x1D, 0xF5 }, "Sunshine",     "Sunshine Co,LTD" },
    { { 0x00, 0x1D, 0xF6 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1D, 0xF7 }, "RSTAHLSchalt", "R. STAHL Schaltgeräte GmbH" },
    { { 0x00, 0x1D, 0xF8 }, "WebproVision", "Webpro Vision Technology Corporation" },
    { { 0x00, 0x1D, 0xF9 }, "Cybiotronics", "Cybiotronics (Far East) Limited" },
    { { 0x00, 0x1D, 0xFA }, "FujianLANDIC", "Fujian LANDI Commercial Equipment Co.,Ltd" },
    { { 0x00, 0x1D, 0xFB }, "NETCLEUS",     "NETCLEUS Systems Corporation" },
    { { 0x00, 0x1D, 0xFC }, "Ksic",         "Ksic" },
    { { 0x00, 0x1D, 0xFD }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1D, 0xFE }, "Palm",         "Palm, Inc" },
    { { 0x00, 0x1D, 0xFF }, "NetworkCriti", "Network Critical Solutions Ltd" },
    { { 0x00, 0x1E, 0x00 }, "ShantouInsti", "Shantou Institute of Ultrasonic Instruments" },
    { { 0x00, 0x1E, 0x01 }, "RenesasTechn", "Renesas Technology Sales Co., Ltd." },
    { { 0x00, 0x1E, 0x02 }, "SougouKeikak", "Sougou Keikaku Kougyou Co.,Ltd." },
    { { 0x00, 0x1E, 0x03 }, "LiComm",       "LiComm Co., Ltd." },
    { { 0x00, 0x1E, 0x04 }, "HansonResear", "Hanson Research Corporation" },
    { { 0x00, 0x1E, 0x05 }, "XseedTechnol", "Xseed Technologies & Computing" },
    { { 0x00, 0x1E, 0x06 }, "Wibrain",      "Wibrain" },
    { { 0x00, 0x1E, 0x07 }, "WinyTechnolo", "Winy Technology Co., Ltd." },
    { { 0x00, 0x1E, 0x08 }, "CentecNetwor", "Centec Networks Inc" },
    { { 0x00, 0x1E, 0x09 }, "ZEFATEK",      "ZEFATEK Co.,LTD" },
    { { 0x00, 0x1E, 0x0A }, "SybaTech",     "Syba Tech Limited" },
    { { 0x00, 0x1E, 0x0B }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x1E, 0x0C }, "SherwoodInfo", "Sherwood Information Partners, Inc." },
    { { 0x00, 0x1E, 0x0D }, "Micran",       "Micran Ltd." },
    { { 0x00, 0x1E, 0x0E }, "MaxiViewHold", "Maxi View Holdings Limited" },
    { { 0x00, 0x1E, 0x0F }, "BriotInterna", "Briot International" },
    { { 0x00, 0x1E, 0x10 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x1E, 0x11 }, "EleluxIntern", "Elelux International Ltd" },
    { { 0x00, 0x1E, 0x12 }, "Ecolab",       "Ecolab" },
    { { 0x00, 0x1E, 0x13 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0x14 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0x15 }, "BeechHillEle", "Beech Hill Electronics" },
    { { 0x00, 0x1E, 0x16 }, "Keytronix",    "Keytronix" },
    { { 0x00, 0x1E, 0x17 }, "Stn",          "Stn Bv" },
    { { 0x00, 0x1E, 0x18 }, "RadioActivit", "Radio Activity srl" },
    { { 0x00, 0x1E, 0x19 }, "Gtri",         "Gtri" },
    { { 0x00, 0x1E, 0x1A }, "BestSourceTa", "Best Source Taiwan Inc." },
    { { 0x00, 0x1E, 0x1B }, "DigitalStrea", "Digital Stream Technology, Inc." },
    { { 0x00, 0x1E, 0x1C }, "SWSAustralia", "SWS Australia Pty Limited" },
    { { 0x00, 0x1E, 0x1D }, "EastCoastDat", "East Coast Datacom, Inc." },
    { { 0x00, 0x1E, 0x1E }, "HoneywellLif", "Honeywell Life Safety" },
    { { 0x00, 0x1E, 0x1F }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1E, 0x20 }, "Intertain",    "Intertain Inc." },
    { { 0x00, 0x1E, 0x21 }, "Qisda",        "Qisda Corporation" },
    { { 0x00, 0x1E, 0x22 }, "ARVOOImaging", "ARVOO Imaging Products BV" },
    { { 0x00, 0x1E, 0x23 }, "ElectronicEd", "Electronic Educational Devices, Inc" },
    { { 0x00, 0x1E, 0x24 }, "ZhejiangBell", "Zhejiang Bell Technology Co.,ltd" },
    { { 0x00, 0x1E, 0x25 }, "IntekDigital", "Intek Digital" },
    { { 0x00, 0x1E, 0x26 }, "Digifriends",  "Digifriends Co. Ltd" },
    { { 0x00, 0x1E, 0x27 }, "SBNTECH",      "SBN TECH Co.,Ltd." },
    { { 0x00, 0x1E, 0x28 }, "Lumexis",      "Lumexis Corporation" },
    { { 0x00, 0x1E, 0x29 }, "Hypertherm",   "Hypertherm Inc" },
    { { 0x00, 0x1E, 0x2A }, "Netgear",      "Netgear" },
    { { 0x00, 0x1E, 0x2B }, "RadioDesign",  "Radio Systems Design, Inc." },
    { { 0x00, 0x1E, 0x2C }, "CyVerse",      "CyVerse Corporation" },
    { { 0x00, 0x1E, 0x2D }, "Stim",         "Stim" },
    { { 0x00, 0x1E, 0x2E }, "SIRTI",        "SIRTI S.p.A." },
    { { 0x00, 0x1E, 0x2F }, "DiMoto",       "DiMoto Pty Ltd" },
    { { 0x00, 0x1E, 0x30 }, "Shireen",      "Shireen Inc" },
    { { 0x00, 0x1E, 0x31 }, "infomark",     "infomark" },
    { { 0x00, 0x1E, 0x32 }, "Zensys",       "Zensys" },
    { { 0x00, 0x1E, 0x33 }, "Inventec",     "Inventec Corporation" },
    { { 0x00, 0x1E, 0x34 }, "CryptoMetric", "CryptoMetrics" },
    { { 0x00, 0x1E, 0x35 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1E, 0x36 }, "Ipte",         "Ipte" },
    { { 0x00, 0x1E, 0x37 }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x00, 0x1E, 0x38 }, "BluecardSoft", "Bluecard Software Technology Co., Ltd." },
    { { 0x00, 0x1E, 0x39 }, "ComsysCommun", "Comsys Communication Ltd." },
    { { 0x00, 0x1E, 0x3A }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1E, 0x3B }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1E, 0x3C }, "LyngboxMedia", "Lyngbox Media AB" },
    { { 0x00, 0x1E, 0x3D }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x1E, 0x3E }, "KMW",          "KMW Inc." },
    { { 0x00, 0x1E, 0x3F }, "TrellisWareT", "TrellisWare Technologies, Inc." },
    { { 0x00, 0x1E, 0x40 }, "DareGlobalTe", "Shanghai DareGlobal Technologies Co.,Ltd" },
    { { 0x00, 0x1E, 0x41 }, "MicrowaveCom", "Microwave Communication & Component, Inc." },
    { { 0x00, 0x1E, 0x42 }, "Teltonika",    "Teltonika" },
    { { 0x00, 0x1E, 0x43 }, "Aisin",        "Aisin Corporation" },
    { { 0x00, 0x1E, 0x44 }, "Santec",       "Santec" },
    { { 0x00, 0x1E, 0x45 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1E, 0x46 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1E, 0x47 }, "PTHariffDaya", "PT. Hariff Daya Tunggal Engineering" },
    { { 0x00, 0x1E, 0x48 }, "WiLinks",      "Wi-Links" },
    { { 0x00, 0x1E, 0x49 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0x4A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0x4B }, "CityTheatric", "City Theatrical" },
    { { 0x00, 0x1E, 0x4C }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x1E, 0x4D }, "WelkinScienc", "Welkin Sciences, LLC" },
    { { 0x00, 0x1E, 0x4E }, "DAKOEDVIngen", "DAKO EDV-Ingenieur- und Systemhaus GmbH" },
    { { 0x00, 0x1E, 0x4F }, "Dell",         "Dell Inc." },
    { { 0x00, 0x1E, 0x50 }, "BattistoniRe", "Battistoni Research" },
    { { 0x00, 0x1E, 0x51 }, "ConverterInd", "Converter Industry Srl" },
    { { 0x00, 0x1E, 0x52 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x1E, 0x53 }, "FurtherTech",  "Further Tech Co., LTD" },
    { { 0x00, 0x1E, 0x54 }, "TOYOELECTRIC", "TOYO ELECTRIC Corporation" },
    { { 0x00, 0x1E, 0x55 }, "COWON",        "COWON SYSTEMS,Inc." },
    { { 0x00, 0x1E, 0x56 }, "BallyWulffEn", "Bally Wulff Entertainment GmbH" },
    { { 0x00, 0x1E, 0x57 }, "ALCOMAspolsr", "ALCOMA, spol. s r.o." },
    { { 0x00, 0x1E, 0x58 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x1E, 0x59 }, "SiliconTurnk", "Silicon Turnkey Express, LLC" },
    { { 0x00, 0x1E, 0x5A }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1E, 0x5B }, "Unitron",      "Unitron Company, Inc." },
    { { 0x00, 0x1E, 0x5C }, "RBGeneralEko", "RB GeneralEkonomik" },
    { { 0x00, 0x1E, 0x5D }, "Holosysdoo",   "Holosys d.o.o." },
    { { 0x00, 0x1E, 0x5E }, "COmputime",    "COmputime Ltd." },
    { { 0x00, 0x1E, 0x5F }, "KwikByte",     "KwikByte, LLC" },
    { { 0x00, 0x1E, 0x60 }, "DigitalLight", "Digital Lighting Systems, Inc" },
    { { 0x00, 0x1E, 0x61 }, "ITEC",         "ITEC GmbH" },
    { { 0x00, 0x1E, 0x62 }, "Siemon",       "Siemon" },
    { { 0x00, 0x1E, 0x63 }, "VibroMeter",   "Vibro-Meter SA" },
    { { 0x00, 0x1E, 0x64 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1E, 0x65 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1E, 0x66 }, "RESOLElektro", "RESOL Elektronische Regelungen GmbH" },
    { { 0x00, 0x1E, 0x67 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1E, 0x68 }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x00, 0x1E, 0x69 }, "Thomson",      "Thomson Inc." },
    { { 0x00, 0x1E, 0x6A }, "BluexonTechn", "Beijing Bluexon Technology Co.,Ltd" },
    { { 0x00, 0x1E, 0x6B }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x1E, 0x6C }, "Opaque",       "Opaque Systems" },
    { { 0x00, 0x1E, 0x6D }, "ITR&DCenter",  "IT R&D Center" },
    { { 0x00, 0x1E, 0x6E }, "FirstMileCom", "Shenzhen First Mile Communications Ltd" },
    { { 0x00, 0x1E, 0x6F }, "MagnaPowerEl", "Magna-Power Electronics, Inc." },
    { { 0x00, 0x1E, 0x70 }, "Chelton",      "Chelton Limited" },
    { { 0x00, 0x1E, 0x71 }, "MIrcomGroupC", "MIrcom Group of Companies" },
    { { 0x00, 0x1E, 0x72 }, "Pcs",          "Pcs" },
    { { 0x00, 0x1E, 0x73 }, "zte",          "zte corporation" },
    { { 0x00, 0x1E, 0x74 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x1E, 0x75 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x1E, 0x76 }, "ThermoFisher", "Thermo Fisher Scientific" },
    { { 0x00, 0x1E, 0x77 }, "Air2App",      "Air2App" },
    { { 0x00, 0x1E, 0x78 }, "OwitekTechno", "Owitek Technology Ltd.," },
    { { 0x00, 0x1E, 0x79 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0x7A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0x7B }, "RI",           "R.I.CO. S.r.l." },
    { { 0x00, 0x1E, 0x7C }, "Taiwick",      "Taiwick Limited" },
    { { 0x00, 0x1E, 0x7D }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1E, 0x7E }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1E, 0x7F }, "CBMAmerica",   "CBM of America" },
    { { 0x00, 0x1E, 0x80 }, "Icotera",      "Icotera A/S" },
    { { 0x00, 0x1E, 0x81 }, "CNBTechnolog", "CNB Technology Inc." },
    { { 0x00, 0x1E, 0x82 }, "SanDisk",      "SanDisk Corporation" },
    { { 0x00, 0x1E, 0x83 }, "LANMANStanda", "LAN/MAN Standards Association (LMSC)" },
    { { 0x00, 0x1E, 0x84 }, "PikaTechnolo", "Pika Technologies Inc." },
    { { 0x00, 0x1E, 0x85 }, "Lagotek",      "Lagotek Corporation" },
    { { 0x00, 0x1E, 0x86 }, "MEL",          "MEL Co.,Ltd." },
    { { 0x00, 0x1E, 0x87 }, "Realease",     "Realease Limited" },
    { { 0x00, 0x1E, 0x88 }, "AndorSystemS", "Andor System Support Co., Ltd." },
    { { 0x00, 0x1E, 0x89 }, "CRFS",         "CRFS Limited" },
    { { 0x00, 0x1E, 0x8A }, "eCopy",        "eCopy, Inc" },
    { { 0x00, 0x1E, 0x8B }, "InfraAccessK", "Infra Access Korea Co., Ltd." },
    { { 0x00, 0x1E, 0x8C }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x1E, 0x8D }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1E, 0x8E }, "Hunkeler",     "Hunkeler AG" },
    { { 0x00, 0x1E, 0x8F }, "Canon",        "Canon Inc." },
    { { 0x00, 0x1E, 0x90 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x1E, 0x91 }, "KIMINElectro", "KIMIN Electronic Co., Ltd." },
    { { 0x00, 0x1E, 0x92 }, "Jeulin",       "Jeulin S.A." },
    { { 0x00, 0x1E, 0x93 }, "CiriTech",     "CiriTech Systems Inc" },
    { { 0x00, 0x1E, 0x94 }, "SupercomTech", "Supercom Technology Corporation" },
    { { 0x00, 0x1E, 0x95 }, "Sigmalink",    "Sigmalink" },
    { { 0x00, 0x1E, 0x96 }, "Sepura",       "Sepura Limited" },
    { { 0x00, 0x1E, 0x97 }, "MediumLinkSy", "Medium Link System Technology CO., LTD," },
    { { 0x00, 0x1E, 0x98 }, "GreenLineCom", "GreenLine Communications" },
    { { 0x00, 0x1E, 0x99 }, "VantanolIndu", "Vantanol Industrial Corporation" },
    { { 0x00, 0x1E, 0x9A }, "HAMILTONBona", "HAMILTON Bonaduz AG" },
    { { 0x00, 0x1E, 0x9B }, "SanEisha",     "San-Eisha, Ltd." },
    { { 0x00, 0x1E, 0x9C }, "Fidustron",    "Fidustron INC" },
    { { 0x00, 0x1E, 0x9D }, "RecallTechno", "Recall Technologies, Inc." },
    { { 0x00, 0x1E, 0x9E }, "ddmhoptschul", "ddm hopt + schuler Gmbh + Co. KG" },
    { { 0x00, 0x1E, 0x9F }, "Visioneering", "Visioneering Systems, Inc." },
    { { 0x00, 0x1E, 0xA0 }, "XLNt",         "XLN-t" },
    { { 0x00, 0x1E, 0xA1 }, "Brunata",      "Brunata a/s" },
    { { 0x00, 0x1E, 0xA2 }, "Symx",         "Symx Systems, Inc." },
    { { 0x00, 0x1E, 0xA3 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1E, 0xA4 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1E, 0xA5 }, "ROBOTOUS",     "ROBOTOUS, Inc." },
    { { 0x00, 0x1E, 0xA6 }, "BestITWorld",  "Best IT World (India) Pvt. Ltd." },
    { { 0x00, 0x1E, 0xA7 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x1E, 0xA8 }, "DatangMobile", "Datang Mobile Communications Equipment CO.,LTD" },
    { { 0x00, 0x1E, 0xA9 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1E, 0xAA }, "ESenzaTechno", "E-Senza Technologies GmbH" },
    { { 0x00, 0x1E, 0xAB }, "TeleWell",     "TeleWell Oy" },
    { { 0x00, 0x1E, 0xAC }, "Armadeus",     "Armadeus Systems" },
    { { 0x00, 0x1E, 0xAD }, "WingtechGrou", "Wingtech Group Limited" },
    { { 0x00, 0x1E, 0xAE }, "ContinentalA", "Continental Automotive Systems Inc." },
    { { 0x00, 0x1E, 0xAF }, "OphirOptroni", "Ophir Optronics Ltd" },
    { { 0x00, 0x1E, 0xB0 }, "ImesDElectro", "ImesD Electronica S.L." },
    { { 0x00, 0x1E, 0xB1 }, "Cryptsoft",    "Cryptsoft Pty Ltd" },
    { { 0x00, 0x1E, 0xB2 }, "LGInnotek",    "LG Innotek" },
    { { 0x00, 0x1E, 0xB3 }, "PrimexWirele", "Primex Wireless" },
    { { 0x00, 0x1E, 0xB4 }, "UnifatTechno", "Unifat Technology Ltd." },
    { { 0x00, 0x1E, 0xB5 }, "EverSparkleT", "Ever Sparkle Technologies Ltd" },
    { { 0x00, 0x1E, 0xB6 }, "TAGHeuer",     "TAG Heuer SA" },
    { { 0x00, 0x1E, 0xB7 }, "TBTech",       "TBTech, Co., Ltd." },
    { { 0x00, 0x1E, 0xB8 }, "Aloys",        "Aloys, Inc" },
    { { 0x00, 0x1E, 0xB9 }, "SingFaiTechn", "Sing Fai Technology Limited" },
    { { 0x00, 0x1E, 0xBA }, "HighDensityD", "High Density Devices AS" },
    { { 0x00, 0x1E, 0xBB }, "BluelightTec", "Bluelight Technology Inc." },
    { { 0x00, 0x1E, 0xBC }, "WintechAutom", "Wintech Automation Co.,Ltd." },
    { { 0x00, 0x1E, 0xBD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0xBE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0xBF }, "HaasAutomati", "Haas Automation Inc." },
    { { 0x00, 0x1E, 0xC0 }, "MicrochipTec", "Microchip Technology Inc." },
    { { 0x00, 0x1E, 0xC1 }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x1E, 0xC2 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x1E, 0xC3 }, "Kozio",        "Kozio, Inc." },
    { { 0x00, 0x1E, 0xC4 }, "Celio",        "Celio Corp" },
    { { 0x00, 0x1E, 0xC5 }, "MiddleAtlant", "Middle Atlantic Products Inc" },
    { { 0x00, 0x1E, 0xC6 }, "LevitonManuf", "Leviton Manufacturing Co., Inc" },
    { { 0x00, 0x1E, 0xC7 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x1E, 0xC8 }, "RapidMobile",  "Rapid Mobile (Pty) Ltd" },
    { { 0x00, 0x1E, 0xC9 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x1E, 0xCA }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1E, 0xCB }, "RPCEnergoaut", "\"RPC \"Energoautomatika\" Ltd" },
    { { 0x00, 0x1E, 0xCC }, "Cdvi",         "Cdvi" },
    { { 0x00, 0x1E, 0xCD }, "KYLANDTechno", "KYLAND Technology Co. LTD" },
    { { 0x00, 0x1E, 0xCE }, "BISATechnolo", "BISA Technologies (Hong Kong) Limited" },
    { { 0x00, 0x1E, 0xCF }, "PhilipsElect", "Philips Electronics Uk Ltd" },
    { { 0x00, 0x1E, 0xD0 }, "Ingespace",    "Ingespace" },
    { { 0x00, 0x1E, 0xD1 }, "Keyprocessor", "Keyprocessor B.V." },
    { { 0x00, 0x1E, 0xD2 }, "RayShineVide", "Ray Shine Video Technology Inc" },
    { { 0x00, 0x1E, 0xD3 }, "DotTechnolog", "Dot Technology Int'l Co., Ltd." },
    { { 0x00, 0x1E, 0xD4 }, "DobleEnginee", "Doble Engineering" },
    { { 0x00, 0x1E, 0xD5 }, "TekonAutomat", "Tekon-Automatics" },
    { { 0x00, 0x1E, 0xD6 }, "AlentecOrion", "Alentec & Orion AB" },
    { { 0x00, 0x1E, 0xD7 }, "HStreamWirel", "H-Stream Wireless, Inc." },
    { { 0x00, 0x1E, 0xD8 }, "DigitalUnite", "Digital United Inc." },
    { { 0x00, 0x1E, 0xD9 }, "MitsubishiPr", "Mitsubishi Precision Co.,LTd." },
    { { 0x00, 0x1E, 0xDA }, "WesemannElek", "Wesemann Elektrotechniek B.V." },
    { { 0x00, 0x1E, 0xDB }, "GikenTrastem", "Giken Trastem Co., Ltd." },
    { { 0x00, 0x1E, 0xDC }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1E, 0xDD }, "Wasko",        "Wasko S.A." },
    { { 0x00, 0x1E, 0xDE }, "Byd",          "Byd Company Limited" },
    { { 0x00, 0x1E, 0xDF }, "MasterIndust", "Master Industrialization Center Kista" },
    { { 0x00, 0x1E, 0xE0 }, "Urmet",        "Urmet SpA" },
    { { 0x00, 0x1E, 0xE1 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1E, 0xE2 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1E, 0xE3 }, "T&WElectroni", "T&W Electronics (ShenZhen) Co.,Ltd" },
    { { 0x00, 0x1E, 0xE4 }, "ACSSolutions", "ACS Solutions France" },
    { { 0x00, 0x1E, 0xE5 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x1E, 0xE6 }, "AdvancedVide", "Shenzhen Advanced Video Info-Tech Co., Ltd." },
    { { 0x00, 0x1E, 0xE7 }, "Epic",         "Epic Systems Inc" },
    { { 0x00, 0x1E, 0xE8 }, "Mytek",        "Mytek" },
    { { 0x00, 0x1E, 0xE9 }, "StoneridgeEl", "Stoneridge Electronics AB" },
    { { 0x00, 0x1E, 0xEA }, "SensorSwitch", "Sensor Switch, Inc." },
    { { 0x00, 0x1E, 0xEB }, "TalkAPhone",   "Talk-A-Phone Co." },
    { { 0x00, 0x1E, 0xEC }, "CompalInform", "Compal Information (Kunshan) Co., Ltd." },
    { { 0x00, 0x1E, 0xED }, "Adventiq",     "Adventiq Ltd." },
    { { 0x00, 0x1E, 0xEE }, "ETL",          "ETL Systems Ltd" },
    { { 0x00, 0x1E, 0xEF }, "CantronicInt", "Cantronic International Limited" },
    { { 0x00, 0x1E, 0xF0 }, "GigafinNetwo", "Gigafin Networks" },
    { { 0x00, 0x1E, 0xF1 }, "Servimat",     "Servimat" },
    { { 0x00, 0x1E, 0xF2 }, "MicroMotion",  "Micro Motion Inc" },
    { { 0x00, 0x1E, 0xF3 }, "From2",        "From2" },
    { { 0x00, 0x1E, 0xF4 }, "L3Communicat", "L-3 Communications Display Systems" },
    { { 0x00, 0x1E, 0xF5 }, "HitekAutomat", "Hitek Automated Inc." },
    { { 0x00, 0x1E, 0xF6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0xF7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1E, 0xF8 }, "Emfinity",     "Emfinity Inc." },
    { { 0x00, 0x1E, 0xF9 }, "PascomKommun", "Pascom Kommunikations systeme GmbH." },
    { { 0x00, 0x1E, 0xFA }, "PROTEI",       "PROTEI Ltd." },
    { { 0x00, 0x1E, 0xFB }, "TrioMotionTe", "Trio Motion Technology Ltd" },
    { { 0x00, 0x1E, 0xFC }, "JscMassaK",    "Jsc \"Massa-K\"" },
    { { 0x00, 0x1E, 0xFD }, "Microbit20",   "Microbit 2.0 AB" },
    { { 0x00, 0x1E, 0xFE }, "LEVELsro",     "LEVEL s.r.o." },
    { { 0x00, 0x1E, 0xFF }, "MuellerElekt", "Mueller-Elektronik GmbH & Co. KG" },
    { { 0x00, 0x1F, 0x00 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1F, 0x01 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1F, 0x02 }, "PixelmetrixP", "Pixelmetrix Corporation Pte Ltd" },
    { { 0x00, 0x1F, 0x03 }, "Num",          "Num Ag" },
    { { 0x00, 0x1F, 0x04 }, "Granch",       "Granch Ltd." },
    { { 0x00, 0x1F, 0x05 }, "iTASTechnolo", "iTAS Technology Corp." },
    { { 0x00, 0x1F, 0x06 }, "IntegratedDi", "Integrated Dispatch Solutions" },
    { { 0x00, 0x1F, 0x07 }, "AZTEQMobile",  "AZTEQ Mobile" },
    { { 0x00, 0x1F, 0x08 }, "Risco",        "Risco Ltd" },
    { { 0x00, 0x1F, 0x09 }, "Jastec",       "Jastec" },
    { { 0x00, 0x1F, 0x0A }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1F, 0x0B }, "FederalState", "Federal State Unitary Enterprise Industrial Union\"Electropribor\"" },
    { { 0x00, 0x1F, 0x0C }, "IntelligentD", "Intelligent Digital Services GmbH" },
    { { 0x00, 0x1F, 0x0D }, "L3Communicat", "L3 Communications - Telemetry West" },
    { { 0x00, 0x1F, 0x0E }, "JapanKyastem", "Japan Kyastem Co., Ltd" },
    { { 0x00, 0x1F, 0x0F }, "SelectEngine", "Select Engineered Systems" },
    { { 0x00, 0x1F, 0x10 }, "ToledoDoBras", "Toledo Do Brasil Industria De Balancas Ltda" },
    { { 0x00, 0x1F, 0x11 }, "Openmoko",     "Openmoko, Inc." },
    { { 0x00, 0x1F, 0x12 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x1F, 0x13 }, "S",            "S.& A.S. Ltd." },
    { { 0x00, 0x1F, 0x14 }, "NexG",         "NexG" },
    { { 0x00, 0x1F, 0x15 }, "Bioscrypt",    "Bioscrypt Inc" },
    { { 0x00, 0x1F, 0x16 }, "Wistron",      "Wistron Corporation" },
    { { 0x00, 0x1F, 0x17 }, "IDX",          "IDX Company, Ltd." },
    { { 0x00, 0x1F, 0x18 }, "HakusanMfg",   "Hakusan.Mfg.Co,.Ltd" },
    { { 0x00, 0x1F, 0x19 }, "BenRiElectro", "Ben-Ri Electronica S.A." },
    { { 0x00, 0x1F, 0x1A }, "Prominvest",   "Prominvest" },
    { { 0x00, 0x1F, 0x1B }, "RoyalTek",     "RoyalTek Company Ltd." },
    { { 0x00, 0x1F, 0x1C }, "KOBISHIELECT", "KOBISHI ELECTRIC Co.,Ltd." },
    { { 0x00, 0x1F, 0x1D }, "AtlasMateria", "Atlas Material Testing Technology LLC" },
    { { 0x00, 0x1F, 0x1E }, "AstecTechnol", "Astec Technology Co., Ltd" },
    { { 0x00, 0x1F, 0x1F }, "EdimaxTechno", "Edimax Technology Co. Ltd." },
    { { 0x00, 0x1F, 0x20 }, "LogitechEuro", "Logitech Europe SA" },
    { { 0x00, 0x1F, 0x21 }, "InnerMongoli", "Inner Mongolia Yin An Science & Technology Development Co.,L" },
    { { 0x00, 0x1F, 0x22 }, "SourcePhoton", "Source Photonics, Inc." },
    { { 0x00, 0x1F, 0x23 }, "Interacousti", "Interacoustics" },
    { { 0x00, 0x1F, 0x24 }, "DigitviewTec", "Digitview Technology Co., Ltd." },
    { { 0x00, 0x1F, 0x25 }, "MBS",          "MBS GmbH" },
    { { 0x00, 0x1F, 0x26 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0x27 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0x28 }, "HPNSupplyCha", "HPN Supply Chain" },
    { { 0x00, 0x1F, 0x29 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x1F, 0x2A }, "Accm",         "Accm" },
    { { 0x00, 0x1F, 0x2B }, "OrangeLogic",  "Orange Logic" },
    { { 0x00, 0x1F, 0x2C }, "StarbridgeNe", "Starbridge Networks" },
    { { 0x00, 0x1F, 0x2D }, "ElectroOptic", "Electro-Optical Imaging, Inc." },
    { { 0x00, 0x1F, 0x2E }, "TriangleRese", "Triangle Research Int'l Pte Ltd" },
    { { 0x00, 0x1F, 0x2F }, "Berker",       "Berker GmbH & Co. KG" },
    { { 0x00, 0x1F, 0x30 }, "Travelping",   "Travelping" },
    { { 0x00, 0x1F, 0x31 }, "Radiocomp",    "Radiocomp" },
    { { 0x00, 0x1F, 0x32 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1F, 0x33 }, "Netgear",      "Netgear" },
    { { 0x00, 0x1F, 0x34 }, "LungHwaElect", "Lung Hwa Electronics Co., Ltd." },
    { { 0x00, 0x1F, 0x35 }, "Air802",       "Air802 Llc" },
    { { 0x00, 0x1F, 0x36 }, "BellwinInfor", "Bellwin Information Co. Ltd.," },
    { { 0x00, 0x1F, 0x37 }, "GenesisI&C",   "Genesis I&C" },
    { { 0x00, 0x1F, 0x38 }, "Positron",     "Positron" },
    { { 0x00, 0x1F, 0x39 }, "Construccion", "Construcciones y Auxiliar de Ferrocarriles, S.A." },
    { { 0x00, 0x1F, 0x3A }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x1F, 0x3B }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1F, 0x3C }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x1F, 0x3D }, "Qbit",         "Qbit GmbH" },
    { { 0x00, 0x1F, 0x3E }, "RPTechnikeK",  "RP-Technik e.K." },
    { { 0x00, 0x1F, 0x3F }, "AVM",          "AVM GmbH" },
    { { 0x00, 0x1F, 0x40 }, "Speakercraft", "Speakercraft Inc." },
    { { 0x00, 0x1F, 0x41 }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0x1F, 0x42 }, "Etherstack",   "Etherstack plc" },
    { { 0x00, 0x1F, 0x43 }, "EntesElektro", "Entes Elektronik" },
    { { 0x00, 0x1F, 0x44 }, "GETransporta", "GE Transportation Systems" },
    { { 0x00, 0x1F, 0x45 }, "Enterasys",    "Enterasys" },
    { { 0x00, 0x1F, 0x46 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1F, 0x47 }, "MCSLogic",     "MCS Logic Inc." },
    { { 0x00, 0x1F, 0x48 }, "Mojix",        "Mojix Inc." },
    { { 0x00, 0x1F, 0x49 }, "ManhattanTV",  "Manhattan TV Ltd" },
    { { 0x00, 0x1F, 0x4A }, "Albentia",     "Albentia Systems S.A." },
    { { 0x00, 0x1F, 0x4B }, "LineagePower", "Lineage Power" },
    { { 0x00, 0x1F, 0x4C }, "RosemanEngin", "Roseman Engineering Ltd" },
    { { 0x00, 0x1F, 0x4D }, "Segnetics",    "Segnetics LLC" },
    { { 0x00, 0x1F, 0x4E }, "ConMedLinvat", "ConMed Linvatec" },
    { { 0x00, 0x1F, 0x4F }, "Thinkware",    "Thinkware Co. Ltd." },
    { { 0x00, 0x1F, 0x50 }, "Swissdis",     "Swissdis AG" },
    { { 0x00, 0x1F, 0x51 }, "HDCommunicat", "HD Communications Corp" },
    { { 0x00, 0x1F, 0x52 }, "UVTUnternehm", "UVT Unternehmensberatung fur Verkehr und Technik GmbH" },
    { { 0x00, 0x1F, 0x53 }, "GEMACChemnit", "GEMAC Chemnitz GmbH" },
    { { 0x00, 0x1F, 0x54 }, "LorexTechnol", "Lorex Technology Inc." },
    { { 0x00, 0x1F, 0x55 }, "HoneywellSec", "Honeywell Security (China) Co., Ltd." },
    { { 0x00, 0x1F, 0x56 }, "DigitalForec", "Digital Forecast" },
    { { 0x00, 0x1F, 0x57 }, "PhonikInnova", "Phonik Innovation Co.,LTD" },
    { { 0x00, 0x1F, 0x58 }, "EMHEnergieme", "EMH Energiemesstechnik GmbH" },
    { { 0x00, 0x1F, 0x59 }, "KronbackTrac", "Kronback Tracers" },
    { { 0x00, 0x1F, 0x5A }, "BeckwithElec", "Beckwith Electric Co." },
    { { 0x00, 0x1F, 0x5B }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x1F, 0x5C }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1F, 0x5D }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1F, 0x5E }, "DynaTechnolo", "Dyna Technology Co.,Ltd." },
    { { 0x00, 0x1F, 0x5F }, "Blatand",      "Blatand GmbH" },
    { { 0x00, 0x1F, 0x60 }, "Compass",      "Compass Systems Corp." },
    { { 0x00, 0x1F, 0x61 }, "TalentCommun", "Talent Communication Networks Inc." },
    { { 0x00, 0x1F, 0x62 }, "JSCStilsoft",  "JSC \"Stilsoft\"" },
    { { 0x00, 0x1F, 0x63 }, "JSCGoodwinEu", "JSC Goodwin-Europa" },
    { { 0x00, 0x1F, 0x64 }, "AutelanTechn", "Beijing Autelan Technology Inc." },
    { { 0x00, 0x1F, 0x65 }, "KoreaElectri", "Korea Electric Terminal Co., Ltd." },
    { { 0x00, 0x1F, 0x66 }, "Planar",       "Planar Llc" },
    { { 0x00, 0x1F, 0x67 }, "Hitachi",      "Hitachi,Ltd." },
    { { 0x00, 0x1F, 0x68 }, "MartinssonEl", "Martinsson Elektronik AB" },
    { { 0x00, 0x1F, 0x69 }, "PingoodTechn", "Pingood Technology Co., Ltd." },
    { { 0x00, 0x1F, 0x6A }, "PacketFluxTe", "PacketFlux Technologies, Inc." },
    { { 0x00, 0x1F, 0x6B }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x1F, 0x6C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0x6D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0x6E }, "VtechEnginee", "Vtech Engineering Corporation" },
    { { 0x00, 0x1F, 0x6F }, "FujianSunnad", "Fujian Sunnada Communication Co.,Ltd." },
    { { 0x00, 0x1F, 0x70 }, "BotikTechnol", "Botik Technologies LTD" },
    { { 0x00, 0x1F, 0x71 }, "xGTechnology", "xG Technology, Inc." },
    { { 0x00, 0x1F, 0x72 }, "QingDaoHipho", "QingDao Hiphone Technology Co,.Ltd" },
    { { 0x00, 0x1F, 0x73 }, "TeraviewTech", "Teraview Technology Co., Ltd." },
    { { 0x00, 0x1F, 0x74 }, "EigenDevelop", "Eigen Development" },
    { { 0x00, 0x1F, 0x75 }, "GiBahnMedia",  "GiBahn Media" },
    { { 0x00, 0x1F, 0x76 }, "AirLogic",     "AirLogic Systems Inc." },
    { { 0x00, 0x1F, 0x77 }, "HeolDesign",   "Heol Design" },
    { { 0x00, 0x1F, 0x78 }, "BlueFoxPorin", "Blue Fox Porini Textile" },
    { { 0x00, 0x1F, 0x79 }, "LodamElectro", "Lodam Electronics A/S" },
    { { 0x00, 0x1F, 0x7A }, "WiWide",       "WiWide Inc." },
    { { 0x00, 0x1F, 0x7B }, "TechNexion",   "TechNexion Ltd." },
    { { 0x00, 0x1F, 0x7C }, "WitelcomAS",   "Witelcom AS" },
    { { 0x00, 0x1F, 0x7D }, "EmbeddedWire", "Embedded Wireless GmbH" },
    { { 0x00, 0x1F, 0x7E }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1F, 0x7F }, "Phabrix",      "Phabrix Limited" },
    { { 0x00, 0x1F, 0x80 }, "Lucas",        "Lucas Holding bv" },
    { { 0x00, 0x1F, 0x81 }, "AccelSemicon", "Accel Semiconductor Corp" },
    { { 0x00, 0x1F, 0x82 }, "CalCompElect", "Cal-Comp Electronics & Communications Company Ltd." },
    { { 0x00, 0x1F, 0x83 }, "TeleplanTech", "Teleplan Technology Services Sdn Bhd" },
    { { 0x00, 0x1F, 0x84 }, "GigleSemicon", "Gigle Semiconductor" },
    { { 0x00, 0x1F, 0x85 }, "AprivaISS",    "Apriva ISS, LLC" },
    { { 0x00, 0x1F, 0x86 }, "digEcor",      "digEcor" },
    { { 0x00, 0x1F, 0x87 }, "Skydigital",   "Skydigital Inc." },
    { { 0x00, 0x1F, 0x88 }, "FMSForceMeas", "FMS Force Measuring Systems AG" },
    { { 0x00, 0x1F, 0x89 }, "Signalion",    "Signalion GmbH" },
    { { 0x00, 0x1F, 0x8A }, "EllionDigita", "Ellion Digital Inc." },
    { { 0x00, 0x1F, 0x8B }, "CacheIQ",      "Cache IQ" },
    { { 0x00, 0x1F, 0x8C }, "CCS",          "CCS Inc." },
    { { 0x00, 0x1F, 0x8D }, "Ingenieurbue", "Ingenieurbuero Stark GmbH und Ko. KG" },
    { { 0x00, 0x1F, 0x8E }, "MetrisUSA",    "Metris USA Inc." },
    { { 0x00, 0x1F, 0x8F }, "BellmannDigi", "Shanghai Bellmann Digital Source Co.,Ltd." },
    { { 0x00, 0x1F, 0x90 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x1F, 0x91 }, "DBSLodgingTe", "DBS Lodging Technologies, LLC" },
    { { 0x00, 0x1F, 0x92 }, "MotorolaSolu", "Motorola Solutions Inc." },
    { { 0x00, 0x1F, 0x93 }, "Xiotech",      "Xiotech Corporation" },
    { { 0x00, 0x1F, 0x94 }, "LascarElectr", "Lascar Electronics Ltd" },
    { { 0x00, 0x1F, 0x95 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x1F, 0x96 }, "Aprotech",     "Aprotech Co.Ltd" },
    { { 0x00, 0x1F, 0x97 }, "BERTANA",      "BERTANA srl" },
    { { 0x00, 0x1F, 0x98 }, "DaiichiDents", "Daiichi-Dentsu Ltd." },
    { { 0x00, 0x1F, 0x99 }, "SERONICS",     "SERONICS co.ltd" },
    { { 0x00, 0x1F, 0x9A }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1F, 0x9B }, "Posbro",       "Posbro" },
    { { 0x00, 0x1F, 0x9C }, "Havis",        "Havis Inc." },
    { { 0x00, 0x1F, 0x9D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0x9E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0x9F }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x1F, 0xA0 }, "A10Networks",  "A10 Networks" },
    { { 0x00, 0x1F, 0xA1 }, "Gtran",        "Gtran Inc" },
    { { 0x00, 0x1F, 0xA2 }, "DatronWorldC", "Datron World Communications, Inc." },
    { { 0x00, 0x1F, 0xA3 }, "T&WElectroni", "T&W Electronics(Shenzhen)Co.,Ltd." },
    { { 0x00, 0x1F, 0xA4 }, "GongjinElect", "Shenzhen Gongjin Electronics Co.,Lt" },
    { { 0x00, 0x1F, 0xA5 }, "BlueWhiteInd", "Blue-White Industries" },
    { { 0x00, 0x1F, 0xA6 }, "Stilo",        "Stilo srl" },
    { { 0x00, 0x1F, 0xA7 }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0x1F, 0xA8 }, "SmartEnergyI", "Smart Energy Instruments Inc." },
    { { 0x00, 0x1F, 0xA9 }, "AtlantaDTH",   "Atlanta DTH, Inc." },
    { { 0x00, 0x1F, 0xAA }, "Taseon",       "Taseon, Inc." },
    { { 0x00, 0x1F, 0xAB }, "ISHighTech",   "I.S High Tech.Inc" },
    { { 0x00, 0x1F, 0xAC }, "Goodmill",     "Goodmill Systems Ltd" },
    { { 0x00, 0x1F, 0xAD }, "BrownInnovat", "Brown Innovations, Inc" },
    { { 0x00, 0x1F, 0xAE }, "BlickSouthAf", "Blick South Africa (Pty) Ltd" },
    { { 0x00, 0x1F, 0xAF }, "NextIO",       "NextIO, Inc." },
    { { 0x00, 0x1F, 0xB0 }, "TimeIPS",      "TimeIPS, Inc." },
    { { 0x00, 0x1F, 0xB1 }, "Cybertech",    "Cybertech Inc." },
    { { 0x00, 0x1F, 0xB2 }, "SontheimIndu", "Sontheim Industrie Elektronik GmbH" },
    { { 0x00, 0x1F, 0xB3 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x1F, 0xB4 }, "SmartShare",   "SmartShare Systems" },
    { { 0x00, 0x1F, 0xB5 }, "IOInterconne", "I/O Interconnect Inc." },
    { { 0x00, 0x1F, 0xB6 }, "ChiLinTechno", "Chi Lin Technology Co., Ltd." },
    { { 0x00, 0x1F, 0xB7 }, "WiMateTechno", "WiMate Technologies Corp." },
    { { 0x00, 0x1F, 0xB8 }, "UniversalRem", "Universal Remote Control, Inc." },
    { { 0x00, 0x1F, 0xB9 }, "Paltronics",   "Paltronics" },
    { { 0x00, 0x1F, 0xBA }, "BoyoungTech",  "Boyoung Tech" },
    { { 0x00, 0x1F, 0xBB }, "Xenatech",     "Xenatech Co.,LTD" },
    { { 0x00, 0x1F, 0xBC }, "EVGA",         "EVGA Corporation" },
    { { 0x00, 0x1F, 0xBD }, "KyoceraWirel", "Kyocera Wireless Corp." },
    { { 0x00, 0x1F, 0xBE }, "MopnetIndust", "Shenzhen Mopnet Industrial Co.,Ltd" },
    { { 0x00, 0x1F, 0xBF }, "FulhuaMicroe", "Fulhua Microelectronics Corp. Taiwan Branch" },
    { { 0x00, 0x1F, 0xC0 }, "ControlExpre", "Control Express Finland Oy" },
    { { 0x00, 0x1F, 0xC1 }, "HanlongTechn", "Hanlong Technology Co.,LTD" },
    { { 0x00, 0x1F, 0xC2 }, "JowTongTechn", "Jow Tong Technology Co Ltd" },
    { { 0x00, 0x1F, 0xC3 }, "SmartSynch",   "SmartSynch, Inc" },
    { { 0x00, 0x1F, 0xC4 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x1F, 0xC5 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x1F, 0xC6 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x1F, 0xC7 }, "CasioHitachi", "Casio Hitachi Mobile Communications Co., Ltd." },
    { { 0x00, 0x1F, 0xC8 }, "UpTodayIndus", "Up-Today Industrial Co., Ltd." },
    { { 0x00, 0x1F, 0xC9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0xCA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x1F, 0xCB }, "NIWSolutions", "NIW Solutions" },
    { { 0x00, 0x1F, 0xCC }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1F, 0xCD }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x1F, 0xCE }, "Qtech",        "Qtech Llc" },
    { { 0x00, 0x1F, 0xCF }, "MSITechnolog", "MSI Technology GmbH" },
    { { 0x00, 0x1F, 0xD0 }, "GigaByteTech", "Giga-Byte Technology Co.,Ltd." },
    { { 0x00, 0x1F, 0xD1 }, "Optex",        "Optex Co.,Ltd." },
    { { 0x00, 0x1F, 0xD2 }, "CommtechTech", "Commtech Technology Macao Commercial Offshore Ltd." },
    { { 0x00, 0x1F, 0xD3 }, "RIVANetworks", "RIVA Networks Inc." },
    { { 0x00, 0x1F, 0xD4 }, "4Ipnet",       "4Ipnet, Inc." },
    { { 0x00, 0x1F, 0xD5 }, "MICRORISCsro", "MICRORISC s.r.o." },
    { { 0x00, 0x1F, 0xD6 }, "Allywll",      "Shenzhen Allywll" },
    { { 0x00, 0x1F, 0xD7 }, "Telerad",      "Telerad Sa" },
    { { 0x00, 0x1F, 0xD8 }, "ATrustComput", "A-Trust Computer Corporation" },
    { { 0x00, 0x1F, 0xD9 }, "RSDCommunica", "RSD Communications Ltd" },
    { { 0x00, 0x1F, 0xDA }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x1F, 0xDB }, "NetworkSuppl", "Network Supply Corp.," },
    { { 0x00, 0x1F, 0xDC }, "MobileSafeTr", "Mobile Safe Track Ltd" },
    { { 0x00, 0x1F, 0xDD }, "Gdi",          "Gdi Llc" },
    { { 0x00, 0x1F, 0xDE }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1F, 0xDF }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x1F, 0xE0 }, "EdgeVelocity", "EdgeVelocity Corp" },
    { { 0x00, 0x1F, 0xE1 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x1F, 0xE2 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x1F, 0xE3 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x1F, 0xE4 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x1F, 0xE5 }, "InCircuit",    "In-Circuit GmbH" },
    { { 0x00, 0x1F, 0xE6 }, "Alphion",      "Alphion Corporation" },
    { { 0x00, 0x1F, 0xE7 }, "Simet",        "Simet" },
    { { 0x00, 0x1F, 0xE8 }, "KURUSUGAWAEl", "KURUSUGAWA Electronics Industry Inc,." },
    { { 0x00, 0x1F, 0xE9 }, "Printrex",     "Printrex, Inc." },
    { { 0x00, 0x1F, 0xEA }, "AppliedMedia", "Applied Media Technologies Corporation" },
    { { 0x00, 0x1F, 0xEB }, "TrioDatacom",  "Trio Datacom Pty Ltd" },
    { { 0x00, 0x1F, 0xEC }, "SynapseÉlect", "Synapse Électronique" },
    { { 0x00, 0x1F, 0xED }, "Tecan",        "Tecan Systems Inc." },
    { { 0x00, 0x1F, 0xEE }, "ubisystechno", "ubisys technologies GmbH" },
    { { 0x00, 0x1F, 0xEF }, "ShinseiIndus", "Shinsei Industries Co.,Ltd" },
    { { 0x00, 0x1F, 0xF0 }, "AudioPartner", "Audio Partnership" },
    { { 0x00, 0x1F, 0xF1 }, "ParadoxHella", "Paradox Hellas S.A." },
    { { 0x00, 0x1F, 0xF2 }, "VIATechnolog", "VIA Technologies, Inc." },
    { { 0x00, 0x1F, 0xF3 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x1F, 0xF4 }, "PowerMonitor", "Power Monitors, Inc." },
    { { 0x00, 0x1F, 0xF5 }, "KongsbergDef", "Kongsberg Defence & Aerospace" },
    { { 0x00, 0x1F, 0xF6 }, "PSAudioInter", "PS Audio International" },
    { { 0x00, 0x1F, 0xF7 }, "NakajimaAllP", "Nakajima All Precision Co., Ltd." },
    { { 0x00, 0x1F, 0xF8 }, "SiemensSecto", "Siemens AG, Sector Industry, Drive Technologies, Motion Control Systems" },
    { { 0x00, 0x1F, 0xF9 }, "AdvancedKnow", "Advanced Knowledge Associates" },
    { { 0x00, 0x1F, 0xFA }, "Coretree",     "Coretree, Co, Ltd" },
    { { 0x00, 0x1F, 0xFB }, "GreenPacketB", "Green Packet Bhd" },
    { { 0x00, 0x1F, 0xFC }, "RicciusSohn",  "Riccius+Sohn GmbH" },
    { { 0x00, 0x1F, 0xFD }, "IndigoMobile", "Indigo Mobile Technologies Corp." },
    { { 0x00, 0x1F, 0xFE }, "HPNSupplyCha", "HPN Supply Chain" },
    { { 0x00, 0x1F, 0xFF }, "Respironics",  "Respironics, Inc." },
    { { 0x00, 0x20, 0x00 }, "LexmarkInter", "Lexmark International, Inc." },
    { { 0x00, 0x20, 0x01 }, "DspSolutions", "Dsp Solutions, Inc." },
    { { 0x00, 0x20, 0x02 }, "SeritechEnte", "Seritech Enterprise Co., Ltd." },
    { { 0x00, 0x20, 0x03 }, "PixelPower",   "Pixel Power Ltd." },
    { { 0x00, 0x20, 0x04 }, "YamatakeHone", "Yamatake-Honeywell Co., Ltd." },
    { { 0x00, 0x20, 0x05 }, "SimpleTechno", "Simple Technology" },
    { { 0x00, 0x20, 0x06 }, "GarrettCommu", "Garrett Communications, Inc." },
    { { 0x00, 0x20, 0x07 }, "Sfa",          "Sfa, Inc." },
    { { 0x00, 0x20, 0x08 }, "CableCompute", "Cable & Computer Technology" },
    { { 0x00, 0x20, 0x09 }, "PackardBellE", "Packard Bell Elec., Inc." },
    { { 0x00, 0x20, 0x0A }, "SourceComm",   "Source-Comm Corp." },
    { { 0x00, 0x20, 0x0B }, "Octagon",      "Octagon Systems Corp." },
    { { 0x00, 0x20, 0x0C }, "Adastra",      "Adastra Systems Corp." },
    { { 0x00, 0x20, 0x0D }, "CarlZeiss",    "Carl Zeiss" },
    { { 0x00, 0x20, 0x0E }, "NSSLGlobalTe", "NSSLGlobal Technologies AS" },
    { { 0x00, 0x20, 0x0F }, "EBRAINS",      "EBRAINS Inc" },
    { { 0x00, 0x20, 0x10 }, "JeolSystemTe", "Jeol System Technology Co. Ltd" },
    { { 0x00, 0x20, 0x11 }, "Canopus",      "Canopus Co., Ltd." },
    { { 0x00, 0x20, 0x12 }, "CamtronicsMe", "Camtronics Medical Systems" },
    { { 0x00, 0x20, 0x13 }, "DiversifiedT", "Diversified Technology, Inc." },
    { { 0x00, 0x20, 0x14 }, "GlobalView",   "Global View Co., Ltd." },
    { { 0x00, 0x20, 0x15 }, "ActisCompute", "Actis Computer Sa" },
    { { 0x00, 0x20, 0x16 }, "ShowaElectri", "Showa Electric Wire & Cable Co" },
    { { 0x00, 0x20, 0x17 }, "Orbotech",     "Orbotech" },
    { { 0x00, 0x20, 0x18 }, "CisTechnolog", "Cis Technology Inc." },
    { { 0x00, 0x20, 0x19 }, "Ohler",        "Ohler Gmbh" },
    { { 0x00, 0x20, 0x1A }, "MRVCommunica", "MRV Communications, Inc." },
    { { 0x00, 0x20, 0x1B }, "NorthernTele", "Northern Telecom/Network" },
    { { 0x00, 0x20, 0x1C }, "Excel",        "Excel, Inc." },
    { { 0x00, 0x20, 0x1D }, "KatanaProduc", "Katana Products" },
    { { 0x00, 0x20, 0x1E }, "Netquest",     "Netquest Corporation" },
    { { 0x00, 0x20, 0x1F }, "BestPowerTec", "Best Power Technology, Inc." },
    { { 0x00, 0x20, 0x20 }, "MegatronComp", "Megatron Computer Industries Pty, Ltd." },
    { { 0x00, 0x20, 0x21 }, "AlgorithmsSo", "Algorithms Software Pvt. Ltd." },
    { { 0x00, 0x20, 0x22 }, "NMSCommunica", "NMS Communications" },
    { { 0x00, 0x20, 0x23 }, "TCTechnologi", "T.C. Technologies Pty. Ltd" },
    { { 0x00, 0x20, 0x24 }, "PacificCommu", "Pacific Communication Sciences" },
    { { 0x00, 0x20, 0x25 }, "ControlTechn", "Control Technology, Inc." },
    { { 0x00, 0x20, 0x26 }, "Amkly",        "Amkly Systems, Inc." },
    { { 0x00, 0x20, 0x27 }, "MingFortuneI", "Ming Fortune Industry Co., Ltd" },
    { { 0x00, 0x20, 0x28 }, "WestEgg",      "West Egg Systems, Inc." },
    { { 0x00, 0x20, 0x29 }, "Teleprocessi", "Teleprocessing Products, Inc." },
    { { 0x00, 0x20, 0x2A }, "NVDzine",      "N.V. Dzine" },
    { { 0x00, 0x20, 0x2B }, "AdvancedTele", "Advanced Telecommunications Modules, Ltd." },
    { { 0x00, 0x20, 0x2C }, "Welltronix",   "Welltronix Co., Ltd." },
    { { 0x00, 0x20, 0x2D }, "Taiyo",        "Taiyo Corporation" },
    { { 0x00, 0x20, 0x2E }, "DaystarDigit", "Daystar Digital" },
    { { 0x00, 0x20, 0x2F }, "ZetaCommunic", "Zeta Communications, Ltd." },
    { { 0x00, 0x20, 0x30 }, "AnalogDigita", "Analog & Digital Systems" },
    { { 0x00, 0x20, 0x31 }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x20, 0x32 }, "AlcatelTaise", "Alcatel Taisel" },
    { { 0x00, 0x20, 0x33 }, "SynapseTechn", "Synapse Technologies, Inc." },
    { { 0x00, 0x20, 0x34 }, "RotecIndustr", "Rotec Industrieautomation Gmbh" },
    { { 0x00, 0x20, 0x35 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x20, 0x36 }, "BmcSoftware",  "Bmc Software" },
    { { 0x00, 0x20, 0x37 }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x20, 0x38 }, "VmeMicrosyst", "Vme Microsystems International Corporation" },
    { { 0x00, 0x20, 0x39 }, "Scinets",      "Scinets" },
    { { 0x00, 0x20, 0x3A }, "DigitalBi0Me", "Digital Bi0Metrics Inc." },
    { { 0x00, 0x20, 0x3B }, "Wisdm",        "Wisdm Ltd." },
    { { 0x00, 0x20, 0x3C }, "Eurotime",     "Eurotime Ab" },
    { { 0x00, 0x20, 0x3D }, "HoneywellEnv", "Honeywell Environmental & Combustion Controls" },
    { { 0x00, 0x20, 0x3E }, "LogiCanTechn", "LogiCan Technologies, Inc." },
    { { 0x00, 0x20, 0x3F }, "Juki",         "Juki Corporation" },
    { { 0x00, 0x20, 0x40 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x20, 0x41 }, "DataNet",      "Data Net" },
    { { 0x00, 0x20, 0x42 }, "Datametrics",  "Datametrics Corp." },
    { { 0x00, 0x20, 0x43 }, "Neuron",       "Neuron Company Limited" },
    { { 0x00, 0x20, 0x44 }, "Genitech",     "Genitech Pty Ltd" },
    { { 0x00, 0x20, 0x45 }, "IONNetworks",  "ION Networks, Inc." },
    { { 0x00, 0x20, 0x46 }, "Ciprico",      "Ciprico, Inc." },
    { { 0x00, 0x20, 0x47 }, "Steinbrecher", "Steinbrecher Corp." },
    { { 0x00, 0x20, 0x48 }, "MarconiCommu", "Marconi Communications" },
    { { 0x00, 0x20, 0x49 }, "Comtron",      "Comtron, Inc." },
    { { 0x00, 0x20, 0x4A }, "Pronet",       "Pronet Gmbh" },
    { { 0x00, 0x20, 0x4B }, "Autocomputer", "Autocomputer Co., Ltd." },
    { { 0x00, 0x20, 0x4C }, "MitronComput", "Mitron Computer Pte Ltd." },
    { { 0x00, 0x20, 0x4D }, "Inovis",       "Inovis Gmbh" },
    { { 0x00, 0x20, 0x4E }, "NetworkSecur", "Network Security Systems, Inc." },
    { { 0x00, 0x20, 0x4F }, "DeutscheAero", "Deutsche Aerospace Ag" },
    { { 0x00, 0x20, 0x50 }, "KoreaCompute", "Korea Computer Inc." },
    { { 0x00, 0x20, 0x51 }, "Verilink",     "Verilink Corporation" },
    { { 0x00, 0x20, 0x52 }, "Ragula",       "Ragula Systems" },
    { { 0x00, 0x20, 0x53 }, "HuntsvilleMi", "Huntsville Microsystems, Inc." },
    { { 0x00, 0x20, 0x54 }, "SycamoreNetw", "Sycamore Networks" },
    { { 0x00, 0x20, 0x55 }, "Altech",       "Altech Co., Ltd." },
    { { 0x00, 0x20, 0x56 }, "Neoproducts",  "Neoproducts" },
    { { 0x00, 0x20, 0x57 }, "TITZEDATENTE", "TITZE DATENTECHNIK GmbH" },
    { { 0x00, 0x20, 0x58 }, "AlliedSignal", "Allied Signal Inc." },
    { { 0x00, 0x20, 0x59 }, "MiroComputer", "Miro Computer Products Ag" },
    { { 0x00, 0x20, 0x5A }, "ComputerIden", "Computer Identics" },
    { { 0x00, 0x20, 0x5B }, "Kentrox",      "Kentrox, LLC" },
    { { 0x00, 0x20, 0x5C }, "InterNetFlor", "InterNet Systems of Florida, Inc." },
    { { 0x00, 0x20, 0x5D }, "Nanomatic",    "Nanomatic Oy" },
    { { 0x00, 0x20, 0x5E }, "CastleRock",   "Castle Rock, Inc." },
    { { 0x00, 0x20, 0x5F }, "GammadataCom", "Gammadata Computer Gmbh" },
    { { 0x00, 0x20, 0x60 }, "ALCATELITALI", "ALCATEL ITALIA S.p.A." },
    { { 0x00, 0x20, 0x61 }, "GarrettCom",   "GarrettCom, Inc." },
    { { 0x00, 0x20, 0x62 }, "ScorpionLogi", "Scorpion Logic, Ltd." },
    { { 0x00, 0x20, 0x63 }, "WiproInfotec", "Wipro Infotech Ltd." },
    { { 0x00, 0x20, 0x64 }, "ProtecMicros", "Protec Microsystems, Inc." },
    { { 0x00, 0x20, 0x65 }, "SupernetNetw", "Supernet Networking Inc." },
    { { 0x00, 0x20, 0x66 }, "GeneralMagic", "General Magic, Inc." },
    { { 0x00, 0x20, 0x67 }, "Private",      "Private" },
    { { 0x00, 0x20, 0x68 }, "Isdyne",       "Isdyne" },
    { { 0x00, 0x20, 0x69 }, "Isdn",         "Isdn Systems Corporation" },
    { { 0x00, 0x20, 0x6A }, "OsakaCompute", "Osaka Computer Corp." },
    { { 0x00, 0x20, 0x6B }, "KonicaMinolt", "Konica Minolta Holdings, Inc." },
    { { 0x00, 0x20, 0x6C }, "EvergreenTec", "Evergreen Technology Corp." },
    { { 0x00, 0x20, 0x6D }, "DataRace",     "Data Race, Inc." },
    { { 0x00, 0x20, 0x6E }, "Xact",         "Xact, Inc." },
    { { 0x00, 0x20, 0x6F }, "Flowpoint",    "Flowpoint Corporation" },
    { { 0x00, 0x20, 0x70 }, "Hynet",        "Hynet, Ltd." },
    { { 0x00, 0x20, 0x71 }, "Ibr",          "Ibr Gmbh" },
    { { 0x00, 0x20, 0x72 }, "WorklinkInno", "Worklink Innovations" },
    { { 0x00, 0x20, 0x73 }, "Fusion",       "Fusion Systems Corporation" },
    { { 0x00, 0x20, 0x74 }, "Sungwoon",     "Sungwoon Systems" },
    { { 0x00, 0x20, 0x75 }, "MotorolaComm", "Motorola Communication Israel" },
    { { 0x00, 0x20, 0x76 }, "Reudo",        "Reudo Corporation" },
    { { 0x00, 0x20, 0x77 }, "Kardios",      "Kardios Systems Corp." },
    { { 0x00, 0x20, 0x78 }, "Runtop",       "Runtop, Inc." },
    { { 0x00, 0x20, 0x79 }, "Mikron",       "Mikron Gmbh" },
    { { 0x00, 0x20, 0x7A }, "WiSECommunic", "WiSE Communications, Inc." },
    { { 0x00, 0x20, 0x7B }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x20, 0x7C }, "Autec",        "Autec Gmbh" },
    { { 0x00, 0x20, 0x7D }, "AdvancedComp", "Advanced Computer Applications" },
    { { 0x00, 0x20, 0x7E }, "Finecom",      "Finecom Co., Ltd." },
    { { 0x00, 0x20, 0x7F }, "KyoeiSangyo",  "Kyoei Sangyo Co., Ltd." },
    { { 0x00, 0x20, 0x80 }, "Synergy",      "Synergy (Uk) Ltd." },
    { { 0x00, 0x20, 0x81 }, "TitanElectro", "Titan Electronics" },
    { { 0x00, 0x20, 0x82 }, "Oneac",        "Oneac Corporation" },
    { { 0x00, 0x20, 0x83 }, "Presticom",    "Presticom Incorporated" },
    { { 0x00, 0x20, 0x84 }, "OcePrinting",  "Oce Printing Systems, Gmbh" },
    { { 0x00, 0x20, 0x85 }, "Eaton",        "Eaton Corporation" },
    { { 0x00, 0x20, 0x86 }, "MicrotechEle", "Microtech Electronics Limited" },
    { { 0x00, 0x20, 0x87 }, "Memotec",      "Memotec, Inc." },
    { { 0x00, 0x20, 0x88 }, "GlobalVillag", "Global Village Communication" },
    { { 0x00, 0x20, 0x89 }, "T3PlusNetwor", "T3Plus Networking, Inc." },
    { { 0x00, 0x20, 0x8A }, "SonixCommuni", "Sonix Communications, Ltd." },
    { { 0x00, 0x20, 0x8B }, "LapisTechnol", "Lapis Technologies, Inc." },
    { { 0x00, 0x20, 0x8C }, "GalaxyNetwor", "Galaxy Networks, Inc." },
    { { 0x00, 0x20, 0x8D }, "CmdTechnolog", "Cmd Technology" },
    { { 0x00, 0x20, 0x8E }, "ChevinSoftwa", "Chevin Software Eng. Ltd." },
    { { 0x00, 0x20, 0x8F }, "ECITelecom",   "ECI Telecom Ltd." },
    { { 0x00, 0x20, 0x90 }, "AdvancedComp", "Advanced Compression Technology, Inc." },
    { { 0x00, 0x20, 0x91 }, "J125National", "J125, National Security Agency" },
    { { 0x00, 0x20, 0x92 }, "ChessEnginee", "Chess Engineering B.V." },
    { { 0x00, 0x20, 0x93 }, "LandingsTech", "Landings Technology Corp." },
    { { 0x00, 0x20, 0x94 }, "Cubix",        "Cubix Corporation" },
    { { 0x00, 0x20, 0x95 }, "RivaElectron", "Riva Electronics" },
    { { 0x00, 0x20, 0x96 }, "Invensys",     "Invensys" },
    { { 0x00, 0x20, 0x97 }, "AppliedSigna", "Applied Signal Technology" },
    { { 0x00, 0x20, 0x98 }, "Hectronic",    "Hectronic Ab" },
    { { 0x00, 0x20, 0x99 }, "BonElectric",  "Bon Electric Co., Ltd." },
    { { 0x00, 0x20, 0x9A }, "3Do",          "The 3Do Company" },
    { { 0x00, 0x20, 0x9B }, "ErsatElectro", "Ersat Electronic Gmbh" },
    { { 0x00, 0x20, 0x9C }, "PrimaryAcces", "Primary Access Corp." },
    { { 0x00, 0x20, 0x9D }, "LippertAutom", "Lippert Automationstechnik" },
    { { 0x00, 0x20, 0x9E }, "BrownSOperat", "Brown'S Operating System Services, Ltd." },
    { { 0x00, 0x20, 0x9F }, "MercuryCompu", "Mercury Computer Systems, Inc." },
    { { 0x00, 0x20, 0xA0 }, "OaLaboratory", "Oa Laboratory Co., Ltd." },
    { { 0x00, 0x20, 0xA1 }, "Dovatron",     "Dovatron" },
    { { 0x00, 0x20, 0xA2 }, "GalcomNetwor", "Galcom Networking Ltd." },
    { { 0x00, 0x20, 0xA3 }, "Harmonic",     "Harmonic, Inc" },
    { { 0x00, 0x20, 0xA4 }, "MultipointNe", "Multipoint Networks" },
    { { 0x00, 0x20, 0xA5 }, "ApiEngineeri", "Api Engineering" },
    { { 0x00, 0x20, 0xA6 }, "ProximWirele", "Proxim Wireless" },
    { { 0x00, 0x20, 0xA7 }, "PairgainTech", "Pairgain Technologies, Inc." },
    { { 0x00, 0x20, 0xA8 }, "SastTechnolo", "Sast Technology Corp." },
    { { 0x00, 0x20, 0xA9 }, "WhiteHorseIn", "White Horse Industrial" },
    { { 0x00, 0x20, 0xAA }, "EricssonTele", "Ericsson Television Limited" },
    { { 0x00, 0x20, 0xAB }, "MicroIndustr", "Micro Industries Corp." },
    { { 0x00, 0x20, 0xAC }, "InterflexDat", "Interflex Datensysteme Gmbh" },
    { { 0x00, 0x20, 0xAD }, "Linq",         "Linq Systems" },
    { { 0x00, 0x20, 0xAE }, "OrnetDataCom", "Ornet Data Communication Tech." },
    { { 0x00, 0x20, 0xAF }, "3Com",         "3Com" },
    { { 0x00, 0x20, 0xB0 }, "GatewayDevic", "Gateway Devices, Inc." },
    { { 0x00, 0x20, 0xB1 }, "ComtechResea", "Comtech Research Inc." },
    { { 0x00, 0x20, 0xB2 }, "GKDGesellsch", "GKD Gesellschaft Fur Kommunikation Und Datentechnik" },
    { { 0x00, 0x20, 0xB3 }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x20, 0xB4 }, "TermaElektro", "Terma Elektronik As" },
    { { 0x00, 0x20, 0xB5 }, "YaskawaElect", "Yaskawa Electric Corporation" },
    { { 0x00, 0x20, 0xB6 }, "AgileNetwork", "Agile Networks, Inc." },
    { { 0x00, 0x20, 0xB7 }, "NamaquaCompu", "Namaqua Computerware" },
    { { 0x00, 0x20, 0xB8 }, "PrimeOption",  "Prime Option, Inc." },
    { { 0x00, 0x20, 0xB9 }, "Metricom",     "Metricom, Inc." },
    { { 0x00, 0x20, 0xBA }, "CenterForHig", "Center For High Performance" },
    { { 0x00, 0x20, 0xBB }, "Zax",          "Zax Corporation" },
    { { 0x00, 0x20, 0xBC }, "LongReachNet", "Long Reach Networks Pty Ltd" },
    { { 0x00, 0x20, 0xBD }, "NiobraraRD",   "Niobrara R & D Corporation" },
    { { 0x00, 0x20, 0xBE }, "LanAccess",    "Lan Access Corp." },
    { { 0x00, 0x20, 0xBF }, "AehrTest",     "Aehr Test Systems" },
    { { 0x00, 0x20, 0xC0 }, "PulseElectro", "Pulse Electronics, Inc." },
    { { 0x00, 0x20, 0xC1 }, "SAXA",         "SAXA, Inc." },
    { { 0x00, 0x20, 0xC2 }, "TexasMemory",  "Texas Memory Systems, Inc." },
    { { 0x00, 0x20, 0xC3 }, "CounterSolut", "Counter Solutions Ltd." },
    { { 0x00, 0x20, 0xC4 }, "Inet",         "Inet,Inc." },
    { { 0x00, 0x20, 0xC5 }, "EagleTechnol", "Eagle Technology" },
    { { 0x00, 0x20, 0xC6 }, "Nectec",       "Nectec" },
    { { 0x00, 0x20, 0xC7 }, "AKAIProfessi", "AKAI Professional M.I. Corp." },
    { { 0x00, 0x20, 0xC8 }, "Larscom",      "Larscom Incorporated" },
    { { 0x00, 0x20, 0xC9 }, "Victron",      "Victron Bv" },
    { { 0x00, 0x20, 0xCA }, "DigitalOcean", "Digital Ocean" },
    { { 0x00, 0x20, 0xCB }, "PretecElectr", "Pretec Electronics Corp." },
    { { 0x00, 0x20, 0xCC }, "DigitalServi", "Digital Services, Ltd." },
    { { 0x00, 0x20, 0xCD }, "HybridNetwor", "Hybrid Networks, Inc." },
    { { 0x00, 0x20, 0xCE }, "LogicalDesig", "Logical Design Group, Inc." },
    { { 0x00, 0x20, 0xCF }, "TestMeasurem", "Test & Measurement Systems Inc" },
    { { 0x00, 0x20, 0xD0 }, "Versalynx",    "Versalynx Corporation" },
    { { 0x00, 0x20, 0xD1 }, "Microcompute", "Microcomputer Systems (M) Sdn." },
    { { 0x00, 0x20, 0xD2 }, "RadDataCommu", "Rad Data Communications, Ltd." },
    { { 0x00, 0x20, 0xD3 }, "OstOuestStan", "Ost (Ouest Standard Telematiqu" },
    { { 0x00, 0x20, 0xD4 }, "Cabletron",    "Cabletron Systems, Inc." },
    { { 0x00, 0x20, 0xD5 }, "Vipa",         "Vipa Gmbh" },
    { { 0x00, 0x20, 0xD6 }, "Breezecom",    "Breezecom, Ltd." },
    { { 0x00, 0x20, 0xD7 }, "JAPANMINICOM", "JAPAN MINICOMPUTER SYSTEMS CO., Ltd." },
    { { 0x00, 0x20, 0xD8 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x20, 0xD9 }, "PanasonicTec", "Panasonic Technologies, Inc./Mieco-Us" },
    { { 0x00, 0x20, 0xDA }, "AlcatelLucen", "Alcatel-Lucent Enterprise" },
    { { 0x00, 0x20, 0xDB }, "XnetTechnolo", "Xnet Technology, Inc." },
    { { 0x00, 0x20, 0xDC }, "DensitronTai", "Densitron Taiwan Ltd." },
    { { 0x00, 0x20, 0xDD }, "Cybertec",     "Cybertec Pty Ltd" },
    { { 0x00, 0x20, 0xDE }, "JapanDigital", "Japan Digital Laborat'Y Co.Ltd" },
    { { 0x00, 0x20, 0xDF }, "KyosanElectr", "Kyosan Electric Mfg. Co., Ltd." },
    { { 0x00, 0x20, 0xE0 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x20, 0xE1 }, "AlamarElectr", "Alamar Electronics" },
    { { 0x00, 0x20, 0xE2 }, "InformationR", "Information Resource Engineering" },
    { { 0x00, 0x20, 0xE3 }, "McdKencom",    "Mcd Kencom Corporation" },
    { { 0x00, 0x20, 0xE4 }, "HsingTechEnt", "Hsing Tech Enterprise Co., Ltd" },
    { { 0x00, 0x20, 0xE5 }, "ApexData",     "Apex Data, Inc." },
    { { 0x00, 0x20, 0xE6 }, "LidkopingMac", "Lidkoping Machine Tools Ab" },
    { { 0x00, 0x20, 0xE7 }, "B&WNuclearSe", "B&W Nuclear Service Company" },
    { { 0x00, 0x20, 0xE8 }, "Datatrek",     "Datatrek Corporation" },
    { { 0x00, 0x20, 0xE9 }, "Dantel",       "Dantel" },
    { { 0x00, 0x20, 0xEA }, "EfficientNet", "Efficient Networks, Inc." },
    { { 0x00, 0x20, 0xEB }, "CincinnatiMi", "Cincinnati Microwave, Inc." },
    { { 0x00, 0x20, 0xEC }, "Techware",     "Techware Systems Corp." },
    { { 0x00, 0x20, 0xED }, "GigaByteTech", "Giga-Byte Technology Co., Ltd." },
    { { 0x00, 0x20, 0xEE }, "Gtech",        "Gtech Corporation" },
    { { 0x00, 0x20, 0xEF }, "Usc",          "Usc Corporation" },
    { { 0x00, 0x20, 0xF0 }, "UniversalMic", "Universal Microelectronics Co." },
    { { 0x00, 0x20, 0xF1 }, "AltosIndia",   "Altos India Limited" },
    { { 0x00, 0x20, 0xF2 }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x20, 0xF3 }, "Raynet",       "Raynet Corporation" },
    { { 0x00, 0x20, 0xF4 }, "Spectrix",     "Spectrix Corporation" },
    { { 0x00, 0x20, 0xF5 }, "Pandatel",     "Pandatel Ag" },
    { { 0x00, 0x20, 0xF6 }, "NetTekAndKar", "Net Tek And Karlnet, Inc." },
    { { 0x00, 0x20, 0xF7 }, "Cyberdata",    "Cyberdata Corporation" },
    { { 0x00, 0x20, 0xF8 }, "CarreraCompu", "Carrera Computers, Inc." },
    { { 0x00, 0x20, 0xF9 }, "ParalinkNetw", "Paralink Networks, Inc." },
    { { 0x00, 0x20, 0xFA }, "Gde",          "Gde Systems, Inc." },
    { { 0x00, 0x20, 0xFB }, "OctelCommuni", "Octel Communications Corp." },
    { { 0x00, 0x20, 0xFC }, "MatroxCentra", "Matrox Central Services Inc" },
    { { 0x00, 0x20, 0xFD }, "ItvTechnolog", "Itv Technologies, Inc." },
    { { 0x00, 0x20, 0xFE }, "TopwareGrand", "Topware Inc. / Grand Computer" },
    { { 0x00, 0x20, 0xFF }, "SymmetricalT", "Symmetrical Technologies" },
    { { 0x00, 0x21, 0x00 }, "GemtekTechno", "Gemtek Technology Co., Ltd." },
    { { 0x00, 0x21, 0x01 }, "Aplicaciones", "Aplicaciones Electronicas Quasar (AEQ)" },
    { { 0x00, 0x21, 0x02 }, "UpdateLogic",  "UpdateLogic Inc." },
    { { 0x00, 0x21, 0x03 }, "GHIElectroni", "GHI Electronics, LLC" },
    { { 0x00, 0x21, 0x04 }, "GigasetCommu", "Gigaset Communications GmbH" },
    { { 0x00, 0x21, 0x05 }, "AlcatelLucen", "Alcatel-Lucent IPD" },
    { { 0x00, 0x21, 0x06 }, "RIMTestingSe", "RIM Testing Services" },
    { { 0x00, 0x21, 0x07 }, "Seowonintech", "Seowonintech Co Ltd." },
    { { 0x00, 0x21, 0x08 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x21, 0x09 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x21, 0x0A }, "bydsign",      "byd:sign Corporation" },
    { { 0x00, 0x21, 0x0B }, "GeminiTrazeR", "Gemini Traze Rfid Pvt. Ltd." },
    { { 0x00, 0x21, 0x0C }, "Cymtec",       "Cymtec Systems, Inc." },
    { { 0x00, 0x21, 0x0D }, "SamsinInnote", "Samsin Innotec" },
    { { 0x00, 0x21, 0x0E }, "OrpakLTD",     "Orpak Systems L.T.D." },
    { { 0x00, 0x21, 0x0F }, "Cernium",      "Cernium Corp" },
    { { 0x00, 0x21, 0x10 }, "Clearbox",     "Clearbox Systems" },
    { { 0x00, 0x21, 0x11 }, "Uniphone",     "Uniphone Inc." },
    { { 0x00, 0x21, 0x12 }, "WiscomSystem", "Wiscom System Co.,Ltd" },
    { { 0x00, 0x21, 0x13 }, "Padtec",       "Padtec S/A" },
    { { 0x00, 0x21, 0x14 }, "HylabTechnol", "Hylab Technology Inc." },
    { { 0x00, 0x21, 0x15 }, "PHYWESysteme", "PHYWE Systeme GmbH & Co. KG" },
    { { 0x00, 0x21, 0x16 }, "TransconElec", "Transcon Electronic Systems, spol. s r. o." },
    { { 0x00, 0x21, 0x17 }, "Tellord",      "Tellord" },
    { { 0x00, 0x21, 0x18 }, "AthenaTech",   "Athena Tech, Inc." },
    { { 0x00, 0x21, 0x19 }, "SamsungElect", "Samsung Electro Mechanics Co., Ltd." },
    { { 0x00, 0x21, 0x1A }, "LInTech",      "LInTech Corporation" },
    { { 0x00, 0x21, 0x1B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0x1C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0x1D }, "Dataline",     "Dataline AB" },
    { { 0x00, 0x21, 0x1E }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x21, 0x1F }, "ShinsungDelt", "Shinsung Deltatech Co.,Ltd." },
    { { 0x00, 0x21, 0x20 }, "SequelTechno", "Sequel Technologies" },
    { { 0x00, 0x21, 0x21 }, "VRmagic",      "VRmagic GmbH" },
    { { 0x00, 0x21, 0x22 }, "Chippro",      "Chip-pro Ltd." },
    { { 0x00, 0x21, 0x23 }, "AerosatAvion", "Aerosat Avionics" },
    { { 0x00, 0x21, 0x24 }, "Optos",        "Optos Plc" },
    { { 0x00, 0x21, 0x25 }, "KUKJETONGSHI", "KUK JE TONG SHIN Co.,LTD" },
    { { 0x00, 0x21, 0x26 }, "TorchEquipme", "Shenzhen Torch Equipment Co., Ltd." },
    { { 0x00, 0x21, 0x27 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x21, 0x28 }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x21, 0x29 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x21, 0x2A }, "Audiovox",     "Audiovox Corporation" },
    { { 0x00, 0x21, 0x2B }, "MSAAuer",      "MSA Auer" },
    { { 0x00, 0x21, 0x2C }, "SemIndiaSyst", "SemIndia System Private Limited" },
    { { 0x00, 0x21, 0x2D }, "Scimolex",     "Scimolex Corporation" },
    { { 0x00, 0x21, 0x2E }, "dresdenelekt", "dresden-elektronik" },
    { { 0x00, 0x21, 0x2F }, "PhoebeMicro",  "Phoebe Micro Inc." },
    { { 0x00, 0x21, 0x30 }, "KeicoHightec", "Keico Hightech Inc." },
    { { 0x00, 0x21, 0x31 }, "Blynke",       "Blynke Inc." },
    { { 0x00, 0x21, 0x32 }, "Masterclock",  "Masterclock, Inc." },
    { { 0x00, 0x21, 0x33 }, "BuildingB",    "Building B, Inc" },
    { { 0x00, 0x21, 0x34 }, "BrandywineCo", "Brandywine Communications" },
    { { 0x00, 0x21, 0x35 }, "AlcatelLucen", "Alcatel-Lucent" },
    { { 0x00, 0x21, 0x36 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x21, 0x37 }, "BayControls",  "Bay Controls, LLC" },
    { { 0x00, 0x21, 0x38 }, "Cepheid",      "Cepheid" },
    { { 0x00, 0x21, 0x39 }, "Escherlogic",  "Escherlogic Inc." },
    { { 0x00, 0x21, 0x3A }, "Winchester",   "Winchester Systems Inc." },
    { { 0x00, 0x21, 0x3B }, "BerkshirePro", "Berkshire Products, Inc" },
    { { 0x00, 0x21, 0x3C }, "AliphCom",     "AliphCom" },
    { { 0x00, 0x21, 0x3D }, "CermetekMicr", "Cermetek Microelectronics, Inc." },
    { { 0x00, 0x21, 0x3E }, "TomTomIntern", "TomTom International BV" },
    { { 0x00, 0x21, 0x3F }, "ATeamTechnol", "A-Team Technology Ltd." },
    { { 0x00, 0x21, 0x40 }, "ENTechnologi", "EN Technologies Inc." },
    { { 0x00, 0x21, 0x41 }, "Radlive",      "Radlive" },
    { { 0x00, 0x21, 0x42 }, "AdvancedCont", "Advanced Control Systems doo" },
    { { 0x00, 0x21, 0x43 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x21, 0x44 }, "SSTelecoms",   "SS Telecoms" },
    { { 0x00, 0x21, 0x45 }, "SemptianTech", "Semptian Technologies Ltd." },
    { { 0x00, 0x21, 0x46 }, "SanminaSCI",   "Sanmina-SCI" },
    { { 0x00, 0x21, 0x47 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x21, 0x48 }, "KacoSolarKor", "Kaco Solar Korea" },
    { { 0x00, 0x21, 0x49 }, "ChinaDahengG", "China Daheng Group ,Inc." },
    { { 0x00, 0x21, 0x4A }, "PixelVelocit", "Pixel Velocity, Inc" },
    { { 0x00, 0x21, 0x4B }, "HAMPScienceT", "Shenzhen HAMP Science & Technology Co.,Ltd" },
    { { 0x00, 0x21, 0x4C }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x21, 0x4D }, "GuangzhouSky", "Guangzhou Skytone Transmission Technology Com. Ltd." },
    { { 0x00, 0x21, 0x4E }, "GSYuasaPower", "GS Yuasa Power Supply Ltd." },
    { { 0x00, 0x21, 0x4F }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x21, 0x50 }, "EyeviewElect", "Eyeview Electronics" },
    { { 0x00, 0x21, 0x51 }, "Millinet",     "Millinet Co., Ltd." },
    { { 0x00, 0x21, 0x52 }, "GeneralSatel", "General Satellite Research & Development Limited" },
    { { 0x00, 0x21, 0x53 }, "SeaMicro",     "SeaMicro Inc." },
    { { 0x00, 0x21, 0x54 }, "DTACQSolutio", "D-TACQ Solutions Ltd" },
    { { 0x00, 0x21, 0x55 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0x56 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0x57 }, "NationalData", "National Datacast, Inc." },
    { { 0x00, 0x21, 0x58 }, "StyleFlyingT", "Style Flying Technology Co." },
    { { 0x00, 0x21, 0x59 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x21, 0x5A }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x21, 0x5B }, "SenseAnywher", "SenseAnywhere" },
    { { 0x00, 0x21, 0x5C }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x21, 0x5D }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x21, 0x5E }, "IBM",          "IBM Corp" },
    { { 0x00, 0x21, 0x5F }, "IHSE",         "IHSE GmbH" },
    { { 0x00, 0x21, 0x60 }, "HideaSolutio", "Hidea Solutions Co. Ltd." },
    { { 0x00, 0x21, 0x61 }, "Yournet",      "Yournet Inc." },
    { { 0x00, 0x21, 0x62 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x21, 0x63 }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x00, 0x21, 0x64 }, "SpecialDesig", "Special Design Bureau for Seismic Instrumentation" },
    { { 0x00, 0x21, 0x65 }, "Presstek",     "Presstek Inc." },
    { { 0x00, 0x21, 0x66 }, "NovAtel",      "NovAtel Inc." },
    { { 0x00, 0x21, 0x67 }, "HWAJINT&I",    "HWA JIN T&I Corp." },
    { { 0x00, 0x21, 0x68 }, "iVeia",        "iVeia, LLC" },
    { { 0x00, 0x21, 0x69 }, "Prologix",     "Prologix, LLC." },
    { { 0x00, 0x21, 0x6A }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x21, 0x6B }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x21, 0x6C }, "Odva",         "Odva" },
    { { 0x00, 0x21, 0x6D }, "Soltech",      "Soltech Co., Ltd." },
    { { 0x00, 0x21, 0x6E }, "FunctionATIT", "Function ATI (Huizhou) Telecommunications Co., Ltd." },
    { { 0x00, 0x21, 0x6F }, "SymCom",       "SymCom, Inc." },
    { { 0x00, 0x21, 0x70 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x21, 0x71 }, "WesungTNC",    "Wesung TNC Co., Ltd." },
    { { 0x00, 0x21, 0x72 }, "SeoultekVall", "Seoultek Valley" },
    { { 0x00, 0x21, 0x73 }, "IonTorrent",   "Ion Torrent Systems, Inc." },
    { { 0x00, 0x21, 0x74 }, "AvaLANWirele", "AvaLAN Wireless" },
    { { 0x00, 0x21, 0x75 }, "PacificSatel", "Pacific Satellite International Ltd." },
    { { 0x00, 0x21, 0x76 }, "YMaxTelecom",  "YMax Telecom Ltd." },
    { { 0x00, 0x21, 0x77 }, "WLGoreAssoci", "W. L. Gore & Associates" },
    { { 0x00, 0x21, 0x78 }, "MatuschekMes", "Matuschek Messtechnik GmbH" },
    { { 0x00, 0x21, 0x79 }, "IOGEAR",       "IOGEAR, Inc." },
    { { 0x00, 0x21, 0x7A }, "SejinElectro", "Sejin Electron, Inc." },
    { { 0x00, 0x21, 0x7B }, "Bastec",       "Bastec AB" },
    { { 0x00, 0x21, 0x7C }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x21, 0x7D }, "Pyxis",        "Pyxis S.R.L." },
    { { 0x00, 0x21, 0x7E }, "TelitCommuni", "Telit Communication s.p.a" },
    { { 0x00, 0x21, 0x7F }, "IntracoTechn", "Intraco Technology Pte Ltd" },
    { { 0x00, 0x21, 0x80 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x21, 0x81 }, "Si2Microsyst", "Si2 Microsystems Limited" },
    { { 0x00, 0x21, 0x82 }, "SandLinks",    "SandLinks Systems, Ltd." },
    { { 0x00, 0x21, 0x83 }, "ANDRITZHYDRO", "ANDRITZ HYDRO GmbH" },
    { { 0x00, 0x21, 0x84 }, "Powersoft",    "Powersoft Srl" },
    { { 0x00, 0x21, 0x85 }, "MicroStarInt", "Micro-Star Int'L Co.,Ltd." },
    { { 0x00, 0x21, 0x86 }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x00, 0x21, 0x87 }, "Imacs",        "Imacs GmbH" },
    { { 0x00, 0x21, 0x88 }, "EMC",          "EMC Corporation" },
    { { 0x00, 0x21, 0x89 }, "AppTech",      "AppTech, Inc." },
    { { 0x00, 0x21, 0x8A }, "ElectronicDe", "Electronic Design and Manufacturing Company" },
    { { 0x00, 0x21, 0x8B }, "WesconTechno", "Wescon Technology, Inc." },
    { { 0x00, 0x21, 0x8C }, "TopControl",   "TopControl GMBH" },
    { { 0x00, 0x21, 0x8D }, "APRouterIndE", "AP Router Ind. Eletronica LTDA" },
    { { 0x00, 0x21, 0x8E }, "Mekics",       "Mekics Co., Ltd." },
    { { 0x00, 0x21, 0x8F }, "AvantgardeAc", "Avantgarde Acoustic Lautsprechersysteme GmbH" },
    { { 0x00, 0x21, 0x90 }, "GoliathSolut", "Goliath Solutions" },
    { { 0x00, 0x21, 0x91 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x21, 0x92 }, "BaodingGalax", "Baoding Galaxy Electronic Technology Co.,Ltd" },
    { { 0x00, 0x21, 0x93 }, "VideofonMV",   "Videofon MV" },
    { { 0x00, 0x21, 0x94 }, "PingCommunic", "Ping Communication" },
    { { 0x00, 0x21, 0x95 }, "GWDMedia",     "GWD Media Limited" },
    { { 0x00, 0x21, 0x96 }, "Telsey",       "Telsey S.p.A." },
    { { 0x00, 0x21, 0x97 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x21, 0x98 }, "ThaiRadio",    "Thai Radio Co, LTD" },
    { { 0x00, 0x21, 0x99 }, "Vacon",        "Vacon Plc" },
    { { 0x00, 0x21, 0x9A }, "CambridgeVis", "Cambridge Visual Networks Ltd" },
    { { 0x00, 0x21, 0x9B }, "Dell",         "Dell Inc." },
    { { 0x00, 0x21, 0x9C }, "HoneywldTech", "Honeywld Technology Corp." },
    { { 0x00, 0x21, 0x9D }, "Adesys",       "Adesys BV" },
    { { 0x00, 0x21, 0x9E }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x21, 0x9F }, "Satel",        "Satel Oy" },
    { { 0x00, 0x21, 0xA0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0xA1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0xA2 }, "EKEElectroni", "EKE-Electronics Ltd." },
    { { 0x00, 0x21, 0xA3 }, "Micromint",    "Micromint" },
    { { 0x00, 0x21, 0xA4 }, "DbiiNetworks", "Dbii Networks" },
    { { 0x00, 0x21, 0xA5 }, "ERLPhasePowe", "ERLPhase Power Technologies Ltd." },
    { { 0x00, 0x21, 0xA6 }, "Videotec",     "Videotec Spa" },
    { { 0x00, 0x21, 0xA7 }, "HantleSystem", "Hantle System Co., Ltd." },
    { { 0x00, 0x21, 0xA8 }, "Telephonics",  "Telephonics Corporation" },
    { { 0x00, 0x21, 0xA9 }, "MobilinkTele", "Mobilink Telecom Co.,Ltd" },
    { { 0x00, 0x21, 0xAA }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x21, 0xAB }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x21, 0xAC }, "InfraredInte", "Infrared Integrated Systems Ltd" },
    { { 0x00, 0x21, 0xAD }, "NordicID",     "Nordic ID Oy" },
    { { 0x00, 0x21, 0xAE }, "AlcatelLucen", "Alcatel-Lucent France - Wtd" },
    { { 0x00, 0x21, 0xAF }, "RadioFrequen", "Radio Frequency Systems" },
    { { 0x00, 0x21, 0xB0 }, "TycoTelecomm", "Tyco Telecommunications" },
    { { 0x00, 0x21, 0xB1 }, "DigitalSolut", "Digital Solutions Ltd" },
    { { 0x00, 0x21, 0xB2 }, "Fiberblaze",   "Fiberblaze A/S" },
    { { 0x00, 0x21, 0xB3 }, "RossControls", "Ross Controls" },
    { { 0x00, 0x21, 0xB4 }, "AproMedia",    "Apro Media Co., Ltd" },
    { { 0x00, 0x21, 0xB5 }, "Galvanic",     "Galvanic Ltd" },
    { { 0x00, 0x21, 0xB6 }, "TriactaPower", "Triacta Power Technologies Inc." },
    { { 0x00, 0x21, 0xB7 }, "LexmarkInter", "Lexmark International, Inc." },
    { { 0x00, 0x21, 0xB8 }, "Inphi",        "Inphi Corporation" },
    { { 0x00, 0x21, 0xB9 }, "UniversalDev", "Universal Devices Inc." },
    { { 0x00, 0x21, 0xBA }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x21, 0xBB }, "RikenKeiki",   "Riken Keiki Co., Ltd." },
    { { 0x00, 0x21, 0xBC }, "ZalaComputer", "Zala Computer" },
    { { 0x00, 0x21, 0xBD }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x21, 0xBE }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x21, 0xBF }, "HitachiHighT", "Hitachi High-Tech Control Systems Corporation" },
    { { 0x00, 0x21, 0xC0 }, "MobileApplia", "Mobile Appliance, Inc." },
    { { 0x00, 0x21, 0xC1 }, "ABBMediumVol", "ABB Oy / Medium Voltage Products" },
    { { 0x00, 0x21, 0xC2 }, "GLCommunicat", "GL Communications Inc" },
    { { 0x00, 0x21, 0xC3 }, "CORNELLCommu", "CORNELL Communications, Inc." },
    { { 0x00, 0x21, 0xC4 }, "Consilium",    "Consilium AB" },
    { { 0x00, 0x21, 0xC5 }, "3DSP",         "3DSP Corp" },
    { { 0x00, 0x21, 0xC6 }, "CSJGlobal",    "CSJ Global, Inc." },
    { { 0x00, 0x21, 0xC7 }, "Russound",     "Russound" },
    { { 0x00, 0x21, 0xC8 }, "LOHUISNetwor", "LOHUIS Networks" },
    { { 0x00, 0x21, 0xC9 }, "WavecomAsiaP", "Wavecom Asia Pacific Limited" },
    { { 0x00, 0x21, 0xCA }, "ARTSystem",    "ART System Co., Ltd." },
    { { 0x00, 0x21, 0xCB }, "SmsTecnologi", "Sms Tecnologia Eletronica Ltda" },
    { { 0x00, 0x21, 0xCC }, "FlextronicsI", "Flextronics International" },
    { { 0x00, 0x21, 0xCD }, "LiveTV",       "LiveTV" },
    { { 0x00, 0x21, 0xCE }, "NTCMetrotek",  "NTC-Metrotek" },
    { { 0x00, 0x21, 0xCF }, "CryptoGroup",  "The Crypto Group" },
    { { 0x00, 0x21, 0xD0 }, "GlobalDispla", "Global Display Solutions Spa" },
    { { 0x00, 0x21, 0xD1 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x21, 0xD2 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x21, 0xD3 }, "BocomSecurit", "Bocom Security(Asia Pacific) Limited" },
    { { 0x00, 0x21, 0xD4 }, "VollmerWerke", "Vollmer Werke GmbH" },
    { { 0x00, 0x21, 0xD5 }, "X2E",          "X2E GmbH" },
    { { 0x00, 0x21, 0xD6 }, "LXIConsortiu", "LXI Consortium" },
    { { 0x00, 0x21, 0xD7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0xD8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x21, 0xD9 }, "Sekonic",      "Sekonic Corporation" },
    { { 0x00, 0x21, 0xDA }, "AutomationPr", "Automation Products Group Inc." },
    { { 0x00, 0x21, 0xDB }, "SantachiVide", "Santachi Video Technology (Shenzhen) Co., Ltd." },
    { { 0x00, 0x21, 0xDC }, "TECNOALARM",   "TECNOALARM S.r.l." },
    { { 0x00, 0x21, 0xDD }, "Northstar",    "Northstar Systems Corp" },
    { { 0x00, 0x21, 0xDE }, "FireproWirel", "Firepro Wireless" },
    { { 0x00, 0x21, 0xDF }, "MartinChrist", "Martin Christ GmbH" },
    { { 0x00, 0x21, 0xE0 }, "CommAgility",  "CommAgility Ltd" },
    { { 0x00, 0x21, 0xE1 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x21, 0xE2 }, "visagoContro", "visago Systems & Controls GmbH & Co. KG" },
    { { 0x00, 0x21, 0xE3 }, "SerialTek",    "SerialTek LLC" },
    { { 0x00, 0x21, 0xE4 }, "IWin",         "I-Win" },
    { { 0x00, 0x21, 0xE5 }, "DisplaySolut", "Display Solution AG" },
    { { 0x00, 0x21, 0xE6 }, "StarlightVid", "Starlight Video Limited" },
    { { 0x00, 0x21, 0xE7 }, "InformaticsS", "Informatics Services Corporation" },
    { { 0x00, 0x21, 0xE8 }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0x21, 0xE9 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x21, 0xEA }, "BystronicLas", "Bystronic Laser AG" },
    { { 0x00, 0x21, 0xEB }, "Esp",          "Esp Systems, Llc" },
    { { 0x00, 0x21, 0xEC }, "Solutronic",   "Solutronic GmbH" },
    { { 0x00, 0x21, 0xED }, "Telegesis",    "Telegesis" },
    { { 0x00, 0x21, 0xEE }, "FullSpectrum", "Full Spectrum Inc." },
    { { 0x00, 0x21, 0xEF }, "Kapsys",       "Kapsys" },
    { { 0x00, 0x21, 0xF0 }, "EW3Technolog", "EW3 Technologies LLC" },
    { { 0x00, 0x21, 0xF1 }, "TutusData",    "Tutus Data AB" },
    { { 0x00, 0x21, 0xF2 }, "EASY3CALLTec", "EASY3CALL Technology Limited" },
    { { 0x00, 0x21, 0xF3 }, "Si14",         "Si14 SpA" },
    { { 0x00, 0x21, 0xF4 }, "INRange",      "INRange Systems, Inc" },
    { { 0x00, 0x21, 0xF5 }, "WesternEngra", "Western Engravers Supply, Inc." },
    { { 0x00, 0x21, 0xF6 }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0x21, 0xF7 }, "HPNSupplyCha", "HPN Supply Chain" },
    { { 0x00, 0x21, 0xF8 }, "Enseo",        "Enseo, Inc." },
    { { 0x00, 0x21, 0xF9 }, "WIRECOMTechn", "WIRECOM Technologies" },
    { { 0x00, 0x21, 0xFA }, "A4SPTechnolo", "A4SP Technologies Ltd." },
    { { 0x00, 0x21, 0xFB }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x21, 0xFC }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x21, 0xFD }, "LacroixTraff", "Lacroix Traffic S.A.U" },
    { { 0x00, 0x21, 0xFE }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x21, 0xFF }, "CyfrowyPolsa", "Cyfrowy Polsat SA" },
    { { 0x00, 0x22, 0x00 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x22, 0x01 }, "AksysNetwork", "Aksys Networks Inc" },
    { { 0x00, 0x22, 0x02 }, "ExcitoElektr", "Excito Elektronik i Skåne AB" },
    { { 0x00, 0x22, 0x03 }, "GlensoundEle", "Glensound Electronics Ltd" },
    { { 0x00, 0x22, 0x04 }, "Koratek",      "Koratek" },
    { { 0x00, 0x22, 0x05 }, "WeLinkSoluti", "WeLink Solutions, Inc." },
    { { 0x00, 0x22, 0x06 }, "Cyberdyne",    "Cyberdyne Inc." },
    { { 0x00, 0x22, 0x07 }, "IntenoBroadb", "Inteno Broadband Technology AB" },
    { { 0x00, 0x22, 0x08 }, "Certicom",     "Certicom Corp" },
    { { 0x00, 0x22, 0x09 }, "OmronHealthc", "Omron Healthcare Co., Ltd" },
    { { 0x00, 0x22, 0x0A }, "OnLive",       "OnLive, Inc" },
    { { 0x00, 0x22, 0x0B }, "NationalSour", "National Source Coding Center" },
    { { 0x00, 0x22, 0x0C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0x0D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0x0E }, "IndigoSecuri", "Indigo Security Co., Ltd." },
    { { 0x00, 0x22, 0x0F }, "MoCA",         "MoCA (Multimedia over Coax Alliance)" },
    { { 0x00, 0x22, 0x10 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x22, 0x11 }, "Rohati",       "Rohati Systems" },
    { { 0x00, 0x22, 0x12 }, "CAINetworks",  "CAI Networks, Inc." },
    { { 0x00, 0x22, 0x13 }, "Pci",          "Pci Corporation" },
    { { 0x00, 0x22, 0x14 }, "RinnaiKorea",  "Rinnai Korea" },
    { { 0x00, 0x22, 0x15 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x22, 0x16 }, "ShibauraVend", "Shibaura Vending Machine Corporation" },
    { { 0x00, 0x22, 0x17 }, "NeatElectron", "Neat Electronics" },
    { { 0x00, 0x22, 0x18 }, "AkamaiTechno", "Akamai Technologies Inc." },
    { { 0x00, 0x22, 0x19 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x22, 0x1A }, "AudioPrecisi", "Audio Precision" },
    { { 0x00, 0x22, 0x1B }, "Morega",       "Morega Systems" },
    { { 0x00, 0x22, 0x1C }, "Private",      "Private" },
    { { 0x00, 0x22, 0x1D }, "FreegeneTech", "Freegene Technology LTD" },
    { { 0x00, 0x22, 0x1E }, "MediaDevices", "Media Devices Co., Ltd." },
    { { 0x00, 0x22, 0x1F }, "eSangTechnol", "eSang Technologies Co., Ltd." },
    { { 0x00, 0x22, 0x20 }, "MitacTechnol", "Mitac Technology Corp" },
    { { 0x00, 0x22, 0x21 }, "ItohDenki",    "Itoh Denki Co,Ltd." },
    { { 0x00, 0x22, 0x22 }, "SchaffnerDeu", "Schaffner Deutschland GmbH" },
    { { 0x00, 0x22, 0x23 }, "TimeKeeping",  "TimeKeeping Systems, Inc." },
    { { 0x00, 0x22, 0x24 }, "GoodWillInst", "Good Will Instrument Co., Ltd." },
    { { 0x00, 0x22, 0x25 }, "ThalesAvioni", "Thales Avionics Ltd" },
    { { 0x00, 0x22, 0x26 }, "Avaak",        "Avaak, Inc." },
    { { 0x00, 0x22, 0x27 }, "uvelectronic", "uv-electronic GmbH" },
    { { 0x00, 0x22, 0x28 }, "BreezeInnova", "Breeze Innovations Ltd." },
    { { 0x00, 0x22, 0x29 }, "Compumedics",  "Compumedics Ltd" },
    { { 0x00, 0x22, 0x2A }, "SoundEar",     "SoundEar A/S" },
    { { 0x00, 0x22, 0x2B }, "Nucomm",       "Nucomm, Inc." },
    { { 0x00, 0x22, 0x2C }, "Ceton",        "Ceton Corp" },
    { { 0x00, 0x22, 0x2D }, "SMCNetworks",  "SMC Networks Inc." },
    { { 0x00, 0x22, 0x2E }, "maintech",     "maintech GmbH" },
    { { 0x00, 0x22, 0x2F }, "OpenGridComp", "Open Grid Computing, Inc." },
    { { 0x00, 0x22, 0x30 }, "FutureLogic",  "FutureLogic Inc." },
    { { 0x00, 0x22, 0x31 }, "SMT&C",        "SMT&C Co., Ltd." },
    { { 0x00, 0x22, 0x32 }, "DesignDesign", "Design Design Technology Ltd" },
    { { 0x00, 0x22, 0x33 }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x22, 0x34 }, "Corventis",    "Corventis Inc." },
    { { 0x00, 0x22, 0x35 }, "Strukton",     "Strukton Systems bv" },
    { { 0x00, 0x22, 0x36 }, "VectorSp",     "Vector Sp. Z O.O." },
    { { 0x00, 0x22, 0x37 }, "ShinhintGrou", "Shinhint Group" },
    { { 0x00, 0x22, 0x38 }, "Logiplus",     "Logiplus" },
    { { 0x00, 0x22, 0x39 }, "IndianaLifeS", "Indiana Life Sciences Incorporated" },
    { { 0x00, 0x22, 0x3A }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x22, 0x3B }, "Communicatio", "Communication Networks, LLC" },
    { { 0x00, 0x22, 0x3C }, "RATIOEntwick", "RATIO Entwicklungen GmbH" },
    { { 0x00, 0x22, 0x3D }, "JumpGen",      "JumpGen Systems, LLC" },
    { { 0x00, 0x22, 0x3E }, "IRTrans",      "IRTrans GmbH" },
    { { 0x00, 0x22, 0x3F }, "Netgear",      "Netgear" },
    { { 0x00, 0x22, 0x40 }, "UniversalTel", "Universal Telecom S/A" },
    { { 0x00, 0x22, 0x41 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x22, 0x42 }, "Alacron",      "Alacron Inc." },
    { { 0x00, 0x22, 0x43 }, "AzureWaveTec", "AzureWave Technology Inc." },
    { { 0x00, 0x22, 0x44 }, "LinkonCommun", "Chengdu Linkon Communications Device Co., Ltd" },
    { { 0x00, 0x22, 0x45 }, "LeineLinde",   "Leine & Linde AB" },
    { { 0x00, 0x22, 0x46 }, "EvocIntellig", "Evoc Intelligent Technology Co.,Ltd." },
    { { 0x00, 0x22, 0x47 }, "DacEngineeri", "Dac Engineering Co., Ltd." },
    { { 0x00, 0x22, 0x48 }, "Microsoft",    "Microsoft Corporation" },
    { { 0x00, 0x22, 0x49 }, "HomeMultiene", "Home Multienergy Sl" },
    { { 0x00, 0x22, 0x4A }, "Raylase",      "Raylase Ag" },
    { { 0x00, 0x22, 0x4B }, "AirtechTechn", "Airtech Technologies, Inc." },
    { { 0x00, 0x22, 0x4C }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x22, 0x4D }, "MitacInterna", "Mitac International Corp." },
    { { 0x00, 0x22, 0x4E }, "SEEnergy",     "SEEnergy Corp." },
    { { 0x00, 0x22, 0x4F }, "ByzoroNetwor", "Byzoro Networks Ltd." },
    { { 0x00, 0x22, 0x50 }, "PointSixWire", "Point Six Wireless, LLC" },
    { { 0x00, 0x22, 0x51 }, "LumasenseTec", "Lumasense Technologies" },
    { { 0x00, 0x22, 0x52 }, "ZOLLLifecor",  "ZOLL Lifecor Corporation" },
    { { 0x00, 0x22, 0x53 }, "EntorianTech", "Entorian Technologies" },
    { { 0x00, 0x22, 0x54 }, "BigelowAeros", "Bigelow Aerospace" },
    { { 0x00, 0x22, 0x55 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0x56 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0x57 }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x22, 0x58 }, "TaiyoYuden",   "Taiyo Yuden Co., Ltd." },
    { { 0x00, 0x22, 0x59 }, "GuangzhouNew", "Guangzhou New Postcom Equipment Co.,Ltd." },
    { { 0x00, 0x22, 0x5A }, "GardeSecurit", "Garde Security AB" },
    { { 0x00, 0x22, 0x5B }, "Teradici",     "Teradici Corporation" },
    { { 0x00, 0x22, 0x5C }, "MultimediaCo", "Multimedia & Communication Technology" },
    { { 0x00, 0x22, 0x5D }, "DigicableNet", "Digicable Network India Pvt. Ltd." },
    { { 0x00, 0x22, 0x5E }, "UwinTechnolo", "Uwin Technologies Co.,LTD" },
    { { 0x00, 0x22, 0x5F }, "LiteonTechno", "Liteon Technology Corporation" },
    { { 0x00, 0x22, 0x60 }, "AFREEY",       "AFREEY Inc." },
    { { 0x00, 0x22, 0x61 }, "FrontierSili", "Frontier Silicon Ltd" },
    { { 0x00, 0x22, 0x62 }, "BEPMarine",    "BEP Marine" },
    { { 0x00, 0x22, 0x63 }, "KoosTechnica", "Koos Technical Services, Inc." },
    { { 0x00, 0x22, 0x64 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x22, 0x65 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x22, 0x66 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x22, 0x67 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x22, 0x68 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x22, 0x69 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x22, 0x6A }, "Honeywell",    "Honeywell" },
    { { 0x00, 0x22, 0x6B }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x22, 0x6C }, "LinkSpriteTe", "LinkSprite Technologies, Inc." },
    { { 0x00, 0x22, 0x6D }, "GIECElectron", "Shenzhen GIEC Electronics Co., Ltd." },
    { { 0x00, 0x22, 0x6E }, "GowellElectr", "Gowell Electronic Limited" },
    { { 0x00, 0x22, 0x6F }, "3onedataTech", "3onedata Technology Co. Ltd." },
    { { 0x00, 0x22, 0x70 }, "ABKNorthAmer", "ABK North America, LLC" },
    { { 0x00, 0x22, 0x71 }, "JägerCompute", "Jäger Computergesteuerte Meßtechnik GmbH." },
    { { 0x00, 0x22, 0x72 }, "AmericanMicr", "American Micro-Fuel Device Corp." },
    { { 0x00, 0x22, 0x73 }, "Techway",      "Techway" },
    { { 0x00, 0x22, 0x74 }, "FamilyPhone",  "FamilyPhone AB" },
    { { 0x00, 0x22, 0x75 }, "BelkinIntern", "Belkin International Inc." },
    { { 0x00, 0x22, 0x76 }, "TripleEYE",    "Triple EYE B.V." },
    { { 0x00, 0x22, 0x77 }, "NECAustralia", "NEC Australia Pty Ltd" },
    { { 0x00, 0x22, 0x78 }, "TongfangMult", "Shenzhen Tongfang Multimedia Technology Co.,Ltd." },
    { { 0x00, 0x22, 0x79 }, "NipponConlux", "Nippon Conlux Co., Ltd." },
    { { 0x00, 0x22, 0x7A }, "TelecomDesig", "Telecom Design" },
    { { 0x00, 0x22, 0x7B }, "ApogeeLabs",   "Apogee Labs, Inc." },
    { { 0x00, 0x22, 0x7C }, "WooriSMT",     "Woori SMT Co.,ltd" },
    { { 0x00, 0x22, 0x7D }, "YeData",       "Ye Data Inc." },
    { { 0x00, 0x22, 0x7E }, "30KaitianCom", "Chengdu 30Kaitian Communication Industry Co.Ltd" },
    { { 0x00, 0x22, 0x7F }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0x22, 0x80 }, "A2BElectroni", "A2B Electronics AB" },
    { { 0x00, 0x22, 0x81 }, "DaintreeNetw", "Daintree Networks Pty" },
    { { 0x00, 0x22, 0x82 }, "8086Consulta", "8086 Consultancy" },
    { { 0x00, 0x22, 0x83 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x22, 0x84 }, "DesayA&VScie", "Desay A&V Science And Technology Co.,Ltd" },
    { { 0x00, 0x22, 0x85 }, "NomusComm",    "Nomus Comm Systems" },
    { { 0x00, 0x22, 0x86 }, "Astron",       "Astron" },
    { { 0x00, 0x22, 0x87 }, "TitanWireles", "Titan Wireless LLC" },
    { { 0x00, 0x22, 0x88 }, "Sagrad",       "Sagrad, Inc." },
    { { 0x00, 0x22, 0x89 }, "VanderlandeA", "Vanderlande APC inc." },
    { { 0x00, 0x22, 0x8A }, "Teratronikel", "Teratronik elektronische systeme gmbh" },
    { { 0x00, 0x22, 0x8B }, "KensingtonCo", "Kensington Computer Products Group" },
    { { 0x00, 0x22, 0x8C }, "PhotonEurope", "Photon Europe GmbH" },
    { { 0x00, 0x22, 0x8D }, "GBSLaborator", "GBS Laboratories LLC" },
    { { 0x00, 0x22, 0x8E }, "TvNumeric",    "Tv-Numeric" },
    { { 0x00, 0x22, 0x8F }, "Cnrs",         "Cnrs" },
    { { 0x00, 0x22, 0x90 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0x91 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0x92 }, "Cinetal",      "Cinetal" },
    { { 0x00, 0x22, 0x93 }, "zte",          "zte corporation" },
    { { 0x00, 0x22, 0x94 }, "Kyocera",      "Kyocera Corporation" },
    { { 0x00, 0x22, 0x95 }, "SGMTechnolog", "SGM Technology for lighting spa" },
    { { 0x00, 0x22, 0x96 }, "LinoWave",     "LinoWave Corporation" },
    { { 0x00, 0x22, 0x97 }, "XMOSSemicond", "XMOS Semiconductor" },
    { { 0x00, 0x22, 0x98 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x22, 0x99 }, "SeaMicro",     "SeaMicro Inc." },
    { { 0x00, 0x22, 0x9A }, "Lastar",       "Lastar, Inc." },
    { { 0x00, 0x22, 0x9B }, "AverLogicTec", "AverLogic Technologies, Inc." },
    { { 0x00, 0x22, 0x9C }, "VerismoNetwo", "Verismo Networks Inc" },
    { { 0x00, 0x22, 0x9D }, "PyungHwaInd",  "Pyung-Hwa Ind.Co.,Ltd" },
    { { 0x00, 0x22, 0x9E }, "SocialAidRes", "Social Aid Research Co., Ltd." },
    { { 0x00, 0x22, 0x9F }, "SensysTraffi", "Sensys Traffic AB" },
    { { 0x00, 0x22, 0xA0 }, "AptivService", "Aptiv Services Us, Llc" },
    { { 0x00, 0x22, 0xA1 }, "HuaweiSymant", "Huawei Symantec Technologies Co.,Ltd." },
    { { 0x00, 0x22, 0xA2 }, "XtramusTechn", "Xtramus Technologies" },
    { { 0x00, 0x22, 0xA3 }, "CaliforniaEa", "California Eastern Laboratories" },
    { { 0x00, 0x22, 0xA4 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x22, 0xA5 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x22, 0xA6 }, "SonyComputer", "Sony Computer Entertainment America" },
    { { 0x00, 0x22, 0xA7 }, "TycoElectron", "Tyco Electronics AMP GmbH" },
    { { 0x00, 0x22, 0xA8 }, "Ouman",        "Ouman Oy" },
    { { 0x00, 0x22, 0xA9 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x22, 0xAA }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x22, 0xAB }, "TurbosightTe", "Shenzhen Turbosight Technology Ltd" },
    { { 0x00, 0x22, 0xAC }, "SiyuanTech",   "Hangzhou Siyuan Tech. Co., Ltd" },
    { { 0x00, 0x22, 0xAD }, "TelesisTechn", "Telesis Technologies, Inc." },
    { { 0x00, 0x22, 0xAE }, "Mattel",       "Mattel Inc." },
    { { 0x00, 0x22, 0xAF }, "SafetyVision", "Safety Vision, LLC" },
    { { 0x00, 0x22, 0xB0 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x22, 0xB1 }, "Elbit",        "Elbit Systems Ltd." },
    { { 0x00, 0x22, 0xB2 }, "4RFCommunica", "4RF Communications Ltd" },
    { { 0x00, 0x22, 0xB3 }, "Sei",          "Sei S.p.A." },
    { { 0x00, 0x22, 0xB4 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x22, 0xB5 }, "Novita",       "Novita" },
    { { 0x00, 0x22, 0xB6 }, "SuperflowTec", "Superflow Technologies Group" },
    { { 0x00, 0x22, 0xB7 }, "GSSGrundigSA", "GSS Grundig SAT-Systems GmbH" },
    { { 0x00, 0x22, 0xB8 }, "Norcott",      "Norcott" },
    { { 0x00, 0x22, 0xB9 }, "AnalogixSemi", "Analogix Seminconductor, Inc" },
    { { 0x00, 0x22, 0xBA }, "HUTHElektron", "HUTH Elektronik Systeme GmbH" },
    { { 0x00, 0x22, 0xBB }, "beyerdynamic", "beyerdynamic GmbH & Co. KG" },
    { { 0x00, 0x22, 0xBC }, "JDSUFranceSA", "JDSU France SAS" },
    { { 0x00, 0x22, 0xBD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0xBE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x22, 0xBF }, "SieAmpGroupC", "SieAmp Group of Companies" },
    { { 0x00, 0x22, 0xC0 }, "ForcelinkEle", "Shenzhen Forcelink Electronic Co, Ltd" },
    { { 0x00, 0x22, 0xC1 }, "ActiveStorag", "Active Storage Inc." },
    { { 0x00, 0x22, 0xC2 }, "ProviewEletr", "Proview Eletrônica do Brasil LTDA" },
    { { 0x00, 0x22, 0xC3 }, "ZeeportTechn", "Zeeport Technology Inc." },
    { { 0x00, 0x22, 0xC4 }, "epro",         "epro GmbH" },
    { { 0x00, 0x22, 0xC5 }, "INFORSON",     "INFORSON Co,Ltd." },
    { { 0x00, 0x22, 0xC6 }, "Sutus",        "Sutus Inc" },
    { { 0x00, 0x22, 0xC7 }, "SEGGERMicroc", "SEGGER Microcontroller GmbH & Co. KG" },
    { { 0x00, 0x22, 0xC8 }, "AppliedInstr", "Applied Instruments B.V." },
    { { 0x00, 0x22, 0xC9 }, "LenordBauer",  "Lenord, Bauer & Co GmbH" },
    { { 0x00, 0x22, 0xCA }, "AnvizBiometr", "Anviz Biometric Tech. Co., Ltd." },
    { { 0x00, 0x22, 0xCB }, "IONODES",      "IONODES Inc." },
    { { 0x00, 0x22, 0xCC }, "SciLog",       "SciLog, Inc." },
    { { 0x00, 0x22, 0xCD }, "AredTechnolo", "Ared Technology Co., Ltd." },
    { { 0x00, 0x22, 0xCE }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x22, 0xCF }, "PlanexCommun", "Planex Communications Inc." },
    { { 0x00, 0x22, 0xD0 }, "PolarElectro", "Polar Electro Oy" },
    { { 0x00, 0x22, 0xD1 }, "AlbrechtJung", "Albrecht Jung GmbH & Co. KG" },
    { { 0x00, 0x22, 0xD2 }, "AllEarthComé", "All Earth Comércio de Eletrônicos LTDA." },
    { { 0x00, 0x22, 0xD3 }, "HubTech",      "Hub-Tech" },
    { { 0x00, 0x22, 0xD4 }, "ComWorth",     "ComWorth Co., Ltd." },
    { { 0x00, 0x22, 0xD5 }, "EatonElectri", "Eaton Corp. Electrical Group Data Center Solutions - Pulizzi" },
    { { 0x00, 0x22, 0xD6 }, "Cypak",        "Cypak AB" },
    { { 0x00, 0x22, 0xD7 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x22, 0xD8 }, "GSTSecuritya", "Shenzhen GST Security and Safety Technology Limited" },
    { { 0x00, 0x22, 0xD9 }, "FortexIndust", "Fortex Industrial Ltd." },
    { { 0x00, 0x22, 0xDA }, "Anatek",       "Anatek, Llc" },
    { { 0x00, 0x22, 0xDB }, "Translogic",   "Translogic Corporation" },
    { { 0x00, 0x22, 0xDC }, "VigilHealthS", "Vigil Health Solutions Inc." },
    { { 0x00, 0x22, 0xDD }, "ProtectaElec", "Protecta Electronics Ltd" },
    { { 0x00, 0x22, 0xDE }, "OPPODigital",  "OPPO Digital, Inc." },
    { { 0x00, 0x22, 0xDF }, "TAMUZMonitor", "TAMUZ Monitors" },
    { { 0x00, 0x22, 0xE0 }, "AtlanticSoft", "Atlantic Software Technologies S.r.L." },
    { { 0x00, 0x22, 0xE1 }, "ZORTLabs",     "ZORT Labs, LLC." },
    { { 0x00, 0x22, 0xE2 }, "WABTECTransi", "WABTEC Transit Division" },
    { { 0x00, 0x22, 0xE3 }, "Amerigon",     "Amerigon" },
    { { 0x00, 0x22, 0xE4 }, "ApassTechnol", "Apass Technology Co., Ltd." },
    { { 0x00, 0x22, 0xE5 }, "FisherRosemo", "Fisher-Rosemount Systems Inc." },
    { { 0x00, 0x22, 0xE6 }, "IntelligentD", "Intelligent Data" },
    { { 0x00, 0x22, 0xE7 }, "WPSParking",   "WPS Parking Systems" },
    { { 0x00, 0x22, 0xE8 }, "Applition",    "Applition Co., Ltd." },
    { { 0x00, 0x22, 0xE9 }, "ProVisionCom", "ProVision Communications" },
    { { 0x00, 0x22, 0xEA }, "Rustelcom",    "Rustelcom Inc." },
    { { 0x00, 0x22, 0xEB }, "DataRespons",  "Data Respons A/S" },
    { { 0x00, 0x22, 0xEC }, "IdealbtTechn", "Idealbt Technology Corporation" },
    { { 0x00, 0x22, 0xED }, "TSIPower",     "TSI Power Corporation" },
    { { 0x00, 0x22, 0xEE }, "AlgoCommunic", "Algo Communication Products Ltd" },
    { { 0x00, 0x22, 0xEF }, "iWDLTechnolo", "iWDL Technologies" },
    { { 0x00, 0x22, 0xF0 }, "3GreensAviat", "3 Greens Aviation Limited" },
    { { 0x00, 0x22, 0xF1 }, "Private",      "Private" },
    { { 0x00, 0x22, 0xF2 }, "SunPower",     "SunPower Corp" },
    { { 0x00, 0x22, 0xF3 }, "SHARP",        "SHARP Corporation" },
    { { 0x00, 0x22, 0xF4 }, "AMPAKTechnol", "AMPAK Technology, Inc." },
    { { 0x00, 0x22, 0xF5 }, "AdvancedReal", "Advanced Realtime Tracking GmbH" },
    { { 0x00, 0x22, 0xF6 }, "SyracuseRese", "Syracuse Research Corporation" },
    { { 0x00, 0x22, 0xF7 }, "Conceptronic", "Conceptronic" },
    { { 0x00, 0x22, 0xF8 }, "PIMAElectron", "PIMA Electronic Systems Ltd." },
    { { 0x00, 0x22, 0xF9 }, "PollinElectr", "Pollin Electronic GmbH" },
    { { 0x00, 0x22, 0xFA }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x22, 0xFB }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x22, 0xFC }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x22, 0xFD }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x22, 0xFE }, "AdvancedIllu", "Advanced Illumination" },
    { { 0x00, 0x22, 0xFF }, "Nivis",        "Nivis Llc" },
    { { 0x00, 0x23, 0x00 }, "CayeeCompute", "Cayee Computer Ltd." },
    { { 0x00, 0x23, 0x01 }, "WitronTechno", "Witron Technology Limited" },
    { { 0x00, 0x23, 0x02 }, "CobaltDigita", "Cobalt Digital, Inc." },
    { { 0x00, 0x23, 0x03 }, "LITEONIT",     "LITE-ON IT Corporation" },
    { { 0x00, 0x23, 0x04 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0x05 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0x06 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x23, 0x07 }, "FutureInnova", "Future Innovation Tech Co.,Ltd" },
    { { 0x00, 0x23, 0x08 }, "ArcadyanTech", "Arcadyan Technology Corporation" },
    { { 0x00, 0x23, 0x09 }, "JanamTechnol", "Janam Technologies LLC" },
    { { 0x00, 0x23, 0x0A }, "ARBURG",       "ARBURG GmbH & Co KG" },
    { { 0x00, 0x23, 0x0B }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0x0C }, "CloverElectr", "Clover Electronics Co.,Ltd." },
    { { 0x00, 0x23, 0x0D }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x23, 0x0E }, "Gorba",        "Gorba AG" },
    { { 0x00, 0x23, 0x0F }, "HirschElectr", "Hirsch Electronics Corporation" },
    { { 0x00, 0x23, 0x10 }, "LNCTechnolog", "LNC Technology Co., Ltd." },
    { { 0x00, 0x23, 0x11 }, "Gloscom",      "Gloscom Co., Ltd." },
    { { 0x00, 0x23, 0x12 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x23, 0x13 }, "QoolTechnolo", "Qool Technologies Ltd." },
    { { 0x00, 0x23, 0x14 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x23, 0x15 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x23, 0x16 }, "KisanElectro", "Kisan Electronics Co" },
    { { 0x00, 0x23, 0x17 }, "Lasercraft",   "Lasercraft Inc" },
    { { 0x00, 0x23, 0x18 }, "Toshiba",      "Toshiba" },
    { { 0x00, 0x23, 0x19 }, "Sielox",       "Sielox LLC" },
    { { 0x00, 0x23, 0x1A }, "ITF",          "ITF Co., Ltd." },
    { { 0x00, 0x23, 0x1B }, "DanaherMotio", "Danaher Motion - Kollmorgen" },
    { { 0x00, 0x23, 0x1C }, "Fourier",      "Fourier Systems Ltd." },
    { { 0x00, 0x23, 0x1D }, "DeltacomElec", "Deltacom Electronics Ltd" },
    { { 0x00, 0x23, 0x1E }, "CezzerMultim", "Cezzer Multimedia Technologies" },
    { { 0x00, 0x23, 0x1F }, "GuangdaElect", "Guangda Electronic & Telecommunication Technology Development Co., Ltd." },
    { { 0x00, 0x23, 0x20 }, "NiciraNetwor", "Nicira Networks" },
    { { 0x00, 0x23, 0x21 }, "AvitechInter", "Avitech International Corp" },
    { { 0x00, 0x23, 0x22 }, "KISSTeknical", "KISS Teknical Solutions, Inc." },
    { { 0x00, 0x23, 0x23 }, "ZylinAS",      "Zylin AS" },
    { { 0x00, 0x23, 0x24 }, "GProComputer", "G-Pro Computer" },
    { { 0x00, 0x23, 0x25 }, "IOLAN",        "IOLAN Holding" },
    { { 0x00, 0x23, 0x26 }, "Fujitsu",      "Fujitsu Limited" },
    { { 0x00, 0x23, 0x27 }, "ShouyoElectr", "Shouyo Electronics CO., LTD" },
    { { 0x00, 0x23, 0x28 }, "AlconTelecom", "Alcon Telecommunications Co., Ltd." },
    { { 0x00, 0x23, 0x29 }, "DDRdrive",     "DDRdrive LLC" },
    { { 0x00, 0x23, 0x2A }, "eonasITBerat", "eonas IT-Beratung und -Entwicklung GmbH" },
    { { 0x00, 0x23, 0x2B }, "Ird",          "Ird A/S" },
    { { 0x00, 0x23, 0x2C }, "Senticare",    "Senticare" },
    { { 0x00, 0x23, 0x2D }, "SandForce",    "SandForce" },
    { { 0x00, 0x23, 0x2E }, "KedahElectro", "Kedah Electronics Engineering, LLC" },
    { { 0x00, 0x23, 0x2F }, "AdvancedCard", "Advanced Card Systems Ltd." },
    { { 0x00, 0x23, 0x30 }, "Dizipia",      "Dizipia, Inc." },
    { { 0x00, 0x23, 0x31 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x23, 0x32 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x23, 0x33 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0x34 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0x35 }, "Linkflex",     "Linkflex Co.,Ltd" },
    { { 0x00, 0x23, 0x36 }, "METELsro",     "METEL s.r.o." },
    { { 0x00, 0x23, 0x37 }, "GlobalStarSo", "Global Star Solutions ULC" },
    { { 0x00, 0x23, 0x38 }, "OJElectronic", "OJ-Electronics A/S" },
    { { 0x00, 0x23, 0x39 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x23, 0x3A }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x23, 0x3B }, "CMatic",       "C-Matic Systems Ltd" },
    { { 0x00, 0x23, 0x3C }, "Alflex",       "Alflex" },
    { { 0x00, 0x23, 0x3D }, "LairdTechnol", "Laird Technologies" },
    { { 0x00, 0x23, 0x3E }, "AlcatelLucen", "Alcatel-Lucent IPD" },
    { { 0x00, 0x23, 0x3F }, "Purechoice",   "Purechoice Inc" },
    { { 0x00, 0x23, 0x40 }, "MiXTelematic", "MiXTelematics" },
    { { 0x00, 0x23, 0x41 }, "VanderbiltIn", "Vanderbilt International (SWE) AB" },
    { { 0x00, 0x23, 0x42 }, "CoffeeEquipm", "Coffee Equipment Company" },
    { { 0x00, 0x23, 0x43 }, "Tem",          "Tem Ag" },
    { { 0x00, 0x23, 0x44 }, "ObjectiveInt", "Objective Interface Systems, Inc." },
    { { 0x00, 0x23, 0x45 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x23, 0x46 }, "Vestac",       "Vestac" },
    { { 0x00, 0x23, 0x47 }, "ProCurveNetw", "ProCurve Networking by HP" },
    { { 0x00, 0x23, 0x48 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x23, 0x49 }, "HelmholtzCen", "Helmholtz Centre Berlin for Material and Energy" },
    { { 0x00, 0x23, 0x4A }, "Private",      "Private" },
    { { 0x00, 0x23, 0x4B }, "InyuanTechno", "Inyuan Technology Inc." },
    { { 0x00, 0x23, 0x4C }, "Ktc",          "Ktc Ab" },
    { { 0x00, 0x23, 0x4D }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x23, 0x4E }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x23, 0x4F }, "LuminousPowe", "Luminous Power Technologies Pvt. Ltd." },
    { { 0x00, 0x23, 0x50 }, "RDCdbaLynTec", "RDC, Inc. dba LynTec" },
    { { 0x00, 0x23, 0x51 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x23, 0x52 }, "DATASENSOR",   "DATASENSOR S.p.A." },
    { { 0x00, 0x23, 0x53 }, "FETElettroni", "F E T Elettronica snc" },
    { { 0x00, 0x23, 0x54 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x23, 0x55 }, "KincoAutomat", "Kinco Automation(Shanghai) Ltd." },
    { { 0x00, 0x23, 0x56 }, "PacketForens", "Packet Forensics LLC" },
    { { 0x00, 0x23, 0x57 }, "PitronotTech", "Pitronot Technologies and Engineering P.T.E. Ltd." },
    { { 0x00, 0x23, 0x58 }, "Systel",       "Systel Sa" },
    { { 0x00, 0x23, 0x59 }, "BenchmarkEle", "Benchmark Electronics ( Thailand ) Public Company Limited" },
    { { 0x00, 0x23, 0x5A }, "CompalInform", "Compal Information (Kunshan) Co., Ltd." },
    { { 0x00, 0x23, 0x5B }, "Gulfstream",   "Gulfstream" },
    { { 0x00, 0x23, 0x5C }, "Aprius",       "Aprius, Inc." },
    { { 0x00, 0x23, 0x5D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0x5E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0x5F }, "SiliconMicro", "Silicon Micro Sensors GmbH" },
    { { 0x00, 0x23, 0x60 }, "LookitTechno", "Lookit Technology Co., Ltd" },
    { { 0x00, 0x23, 0x61 }, "Unigen",       "Unigen Corporation" },
    { { 0x00, 0x23, 0x62 }, "GoldlineCont", "Goldline Controls" },
    { { 0x00, 0x23, 0x63 }, "ZhuhaiRaysha", "Zhuhai Raysharp Technology Co.,Ltd" },
    { { 0x00, 0x23, 0x64 }, "PowerInstrum", "Power Instruments Pte Ltd" },
    { { 0x00, 0x23, 0x65 }, "InstaElektro", "Insta Elektro GmbH" },
    { { 0x00, 0x23, 0x66 }, "SiasunElectr", "Beijing Siasun Electronic System Co.,Ltd." },
    { { 0x00, 0x23, 0x67 }, "UniControls",  "UniControls a.s." },
    { { 0x00, 0x23, 0x68 }, "ZebraTechnol", "Zebra Technologies Inc" },
    { { 0x00, 0x23, 0x69 }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x23, 0x6A }, "SmartRG",      "SmartRG Inc" },
    { { 0x00, 0x23, 0x6B }, "Xembedded",    "Xembedded, Inc." },
    { { 0x00, 0x23, 0x6C }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x23, 0x6D }, "ResMed",       "ResMed Ltd" },
    { { 0x00, 0x23, 0x6E }, "Burster",      "Burster GmbH & Co KG" },
    { { 0x00, 0x23, 0x6F }, "DAQSystem",    "DAQ System" },
    { { 0x00, 0x23, 0x70 }, "Snell",        "Snell" },
    { { 0x00, 0x23, 0x71 }, "SOAMSystel",   "SOAM Systel" },
    { { 0x00, 0x23, 0x72 }, "MoreStarIndu", "More Star Industrial Group Limited" },
    { { 0x00, 0x23, 0x73 }, "GridIron",     "GridIron Systems, Inc." },
    { { 0x00, 0x23, 0x74 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0x75 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0x76 }, "HTC",          "HTC Corporation" },
    { { 0x00, 0x23, 0x77 }, "IsotekElectr", "Isotek Electronics Ltd" },
    { { 0x00, 0x23, 0x78 }, "GNNetcom",     "GN Netcom A/S" },
    { { 0x00, 0x23, 0x79 }, "UnionBusines", "Union Business Machines Co. Ltd." },
    { { 0x00, 0x23, 0x7A }, "Rim",          "Rim" },
    { { 0x00, 0x23, 0x7B }, "Whdi",         "Whdi Llc" },
    { { 0x00, 0x23, 0x7C }, "Neotion",      "Neotion" },
    { { 0x00, 0x23, 0x7D }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x23, 0x7E }, "Elster",       "Elster Gmbh" },
    { { 0x00, 0x23, 0x7F }, "Plantronics",  "Plantronics, Inc." },
    { { 0x00, 0x23, 0x80 }, "Nanoteq",      "Nanoteq" },
    { { 0x00, 0x23, 0x81 }, "LengdaTechno", "Lengda Technology(Xiamen) Co.,Ltd." },
    { { 0x00, 0x23, 0x82 }, "LihRongelect", "Lih Rong electronic Enterprise Co., Ltd." },
    { { 0x00, 0x23, 0x83 }, "InMage",       "InMage Systems Inc" },
    { { 0x00, 0x23, 0x84 }, "GGHEngineeri", "GGH Engineering s.r.l." },
    { { 0x00, 0x23, 0x85 }, "Antipode",     "Antipode" },
    { { 0x00, 0x23, 0x86 }, "IMIHydronicE", "IMI Hydronic Engineering international SA" },
    { { 0x00, 0x23, 0x87 }, "ThinkFlood",   "ThinkFlood, Inc." },
    { { 0x00, 0x23, 0x88 }, "VTTelematica", "V.T. Telematica S.p.a." },
    { { 0x00, 0x23, 0x89 }, "H3CTechnolog", "Hangzhou H3C Technologies Co., Limited" },
    { { 0x00, 0x23, 0x8A }, "Ciena",        "Ciena Corporation" },
    { { 0x00, 0x23, 0x8B }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x00, 0x23, 0x8C }, "Private",      "Private" },
    { { 0x00, 0x23, 0x8D }, "TechnoDesign", "Techno Design Co., Ltd." },
    { { 0x00, 0x23, 0x8E }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x23, 0x8F }, "NidecCopal",   "Nidec Copal Corporation" },
    { { 0x00, 0x23, 0x90 }, "Algolware",    "Algolware Corporation" },
    { { 0x00, 0x23, 0x91 }, "Maxian",       "Maxian" },
    { { 0x00, 0x23, 0x92 }, "ProteusIndus", "Proteus Industries Inc." },
    { { 0x00, 0x23, 0x93 }, "Ajinextek",    "Ajinextek" },
    { { 0x00, 0x23, 0x94 }, "Samjeon",      "Samjeon" },
    { { 0x00, 0x23, 0x95 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0x96 }, "AndesTechnol", "Andes Technology Corporation" },
    { { 0x00, 0x23, 0x97 }, "WestellTechn", "Westell Technologies Inc." },
    { { 0x00, 0x23, 0x98 }, "Vutlansro",    "Vutlan sro" },
    { { 0x00, 0x23, 0x99 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x23, 0x9A }, "EasyDataHard", "EasyData Hardware GmbH" },
    { { 0x00, 0x23, 0x9B }, "ElsterSoluti", "Elster Solutions, LLC" },
    { { 0x00, 0x23, 0x9C }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x23, 0x9D }, "MapowerElect", "Mapower Electronics Co., Ltd" },
    { { 0x00, 0x23, 0x9E }, "JiangsuLemot", "Jiangsu Lemote Technology Corporation Limited" },
    { { 0x00, 0x23, 0x9F }, "InstitutfürP", "Institut für Prüftechnik" },
    { { 0x00, 0x23, 0xA0 }, "HanaCNS",      "Hana CNS Co., LTD." },
    { { 0x00, 0x23, 0xA1 }, "TrendElectro", "Trend Electronics Ltd" },
    { { 0x00, 0x23, 0xA2 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0xA3 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0xA4 }, "NewConceptsD", "New Concepts Development Corp." },
    { { 0x00, 0x23, 0xA5 }, "SageTV",       "SageTV, LLC" },
    { { 0x00, 0x23, 0xA6 }, "EMon",         "E-Mon" },
    { { 0x00, 0x23, 0xA7 }, "RedpineSigna", "Redpine Signals, Inc." },
    { { 0x00, 0x23, 0xA8 }, "MarshallElec", "Marshall Electronics" },
    { { 0x00, 0x23, 0xA9 }, "DetianquanEl", "Beijing Detianquan Electromechanical Equipment Co., Ltd" },
    { { 0x00, 0x23, 0xAA }, "HFR",          "HFR, Inc." },
    { { 0x00, 0x23, 0xAB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0xAC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0xAD }, "Xmark",        "Xmark Corporation" },
    { { 0x00, 0x23, 0xAE }, "Dell",         "Dell Inc." },
    { { 0x00, 0x23, 0xAF }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0xB0 }, "COMXIONTechn", "COMXION Technology Inc." },
    { { 0x00, 0x23, 0xB1 }, "LongcheerTec", "Longcheer Technology (Singapore) Pte Ltd" },
    { { 0x00, 0x23, 0xB2 }, "IntelligentM", "Intelligent Mechatronic Systems Inc" },
    { { 0x00, 0x23, 0xB3 }, "Lyyn",         "Lyyn AB" },
    { { 0x00, 0x23, 0xB4 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x23, 0xB5 }, "Ortana",       "Ortana Ltd" },
    { { 0x00, 0x23, 0xB6 }, "SecuriteComm", "Securite Communications / Honeywell" },
    { { 0x00, 0x23, 0xB7 }, "QLight",       "Q-Light Co., Ltd." },
    { { 0x00, 0x23, 0xB8 }, "SichuanJiuzh", "Sichuan Jiuzhou Electronic Technology Co.,Ltd" },
    { { 0x00, 0x23, 0xB9 }, "AirbusDefenc", "Airbus Defence and Space Deutschland GmbH" },
    { { 0x00, 0x23, 0xBA }, "Chroma",       "Chroma" },
    { { 0x00, 0x23, 0xBB }, "AccretechSBS", "Accretech SBS, Inc." },
    { { 0x00, 0x23, 0xBC }, "EQSYS",        "EQ-SYS GmbH" },
    { { 0x00, 0x23, 0xBD }, "DigitalAlly",  "Digital Ally, Inc." },
    { { 0x00, 0x23, 0xBE }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x23, 0xBF }, "Mainpine",     "Mainpine, Inc." },
    { { 0x00, 0x23, 0xC0 }, "BroadwayNetw", "Broadway Networks" },
    { { 0x00, 0x23, 0xC1 }, "SecuritasDir", "Securitas Direct AB" },
    { { 0x00, 0x23, 0xC2 }, "SAMSUNGElect", "SAMSUNG Electronics. Co. LTD" },
    { { 0x00, 0x23, 0xC3 }, "LogMeIn",      "LogMeIn, Inc." },
    { { 0x00, 0x23, 0xC4 }, "LuxLumen",     "Lux Lumen" },
    { { 0x00, 0x23, 0xC5 }, "RadiationSaf", "Radiation Safety and Control Services Inc" },
    { { 0x00, 0x23, 0xC6 }, "SMC",          "SMC Corporation" },
    { { 0x00, 0x23, 0xC7 }, "AVSystemspzo", "AVSystem sp. z o. o." },
    { { 0x00, 0x23, 0xC8 }, "TeamR",        "Team-R" },
    { { 0x00, 0x23, 0xC9 }, "SichuanTiany", "Sichuan Tianyi Information Science & Technology Stock CO.,LTD" },
    { { 0x00, 0x23, 0xCA }, "BehindSet",    "Behind The Set, LLC" },
    { { 0x00, 0x23, 0xCB }, "FulljoinTech", "Shenzhen Full-join Technology Co.,Ltd" },
    { { 0x00, 0x23, 0xCC }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x23, 0xCD }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x23, 0xCE }, "KitaDenshi",   "Kita Denshi Corporation" },
    { { 0x00, 0x23, 0xCF }, "CumminsAllis", "Cummins-Allison Corp." },
    { { 0x00, 0x23, 0xD0 }, "UnilocUSA",    "Uniloc USA Inc." },
    { { 0x00, 0x23, 0xD1 }, "Trg",          "Trg" },
    { { 0x00, 0x23, 0xD2 }, "InhandElectr", "Inhand Electronics, Inc." },
    { { 0x00, 0x23, 0xD3 }, "AirLinkWiFiN", "AirLink WiFi Networking Corp." },
    { { 0x00, 0x23, 0xD4 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x23, 0xD5 }, "WAREMARenkho", "WAREMA Renkhoff SE" },
    { { 0x00, 0x23, 0xD6 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x23, 0xD7 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x23, 0xD8 }, "BallIt",       "Ball-It Oy" },
    { { 0x00, 0x23, 0xD9 }, "BannerEngine", "Banner Engineering" },
    { { 0x00, 0x23, 0xDA }, "IndustrialCo", "Industrial Computer Source (Deutschland)GmbH" },
    { { 0x00, 0x23, 0xDB }, "saxnet",       "saxnet gmbh" },
    { { 0x00, 0x23, 0xDC }, "Benein",       "Benein, Inc" },
    { { 0x00, 0x23, 0xDD }, "Elgin",        "Elgin S.A." },
    { { 0x00, 0x23, 0xDE }, "Ansync",       "Ansync Inc." },
    { { 0x00, 0x23, 0xDF }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x23, 0xE0 }, "INOTherapeut", "INO Therapeutics LLC" },
    { { 0x00, 0x23, 0xE1 }, "CavenaImageP", "Cavena Image Products AB" },
    { { 0x00, 0x23, 0xE2 }, "SEASignalisa", "SEA Signalisation" },
    { { 0x00, 0x23, 0xE3 }, "Microtronic",  "Microtronic AG" },
    { { 0x00, 0x23, 0xE4 }, "IPnect",       "IPnect co. ltd." },
    { { 0x00, 0x23, 0xE5 }, "IPaXiomNetwo", "IPaXiom Networks" },
    { { 0x00, 0x23, 0xE6 }, "InnovationFa", "Innovation Farm, Inc." },
    { { 0x00, 0x23, 0xE7 }, "Hinke",        "Hinke A/S" },
    { { 0x00, 0x23, 0xE8 }, "Demco",        "Demco Corp." },
    { { 0x00, 0x23, 0xE9 }, "F5Networks",   "F5 Networks, Inc." },
    { { 0x00, 0x23, 0xEA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0xEB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x23, 0xEC }, "Algorithmix",  "Algorithmix GmbH" },
    { { 0x00, 0x23, 0xED }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0xEE }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x23, 0xEF }, "ZuendSystemt", "Zuend Systemtechnik AG" },
    { { 0x00, 0x23, 0xF0 }, "JinghanWeigh", "Shanghai Jinghan Weighing Apparatus Co. Ltd." },
    { { 0x00, 0x23, 0xF1 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x23, 0xF2 }, "TVLogic",      "TVLogic" },
    { { 0x00, 0x23, 0xF3 }, "Glocom",       "Glocom, Inc." },
    { { 0x00, 0x23, 0xF4 }, "Masternaut",   "Masternaut" },
    { { 0x00, 0x23, 0xF5 }, "WiloSe",       "Wilo Se" },
    { { 0x00, 0x23, 0xF6 }, "SoftwellTech", "Softwell Technology Co., Ltd." },
    { { 0x00, 0x23, 0xF7 }, "Private",      "Private" },
    { { 0x00, 0x23, 0xF8 }, "ZyxelCommuni", "Zyxel Communications Corporation" },
    { { 0x00, 0x23, 0xF9 }, "DoubleTakeSo", "Double-Take Software, INC." },
    { { 0x00, 0x23, 0xFA }, "RGNets",       "RG Nets, Inc." },
    { { 0x00, 0x23, 0xFB }, "IPDatatel",    "IP Datatel, LLC." },
    { { 0x00, 0x23, 0xFC }, "UltraStereoL", "Ultra Stereo Labs, Inc" },
    { { 0x00, 0x23, 0xFD }, "AFTAtlasFahr", "AFT Atlas Fahrzeugtechnik GmbH" },
    { { 0x00, 0x23, 0xFE }, "Biodevices",   "Biodevices, SA" },
    { { 0x00, 0x23, 0xFF }, "HTTCTechnolo", "Beijing HTTC Technology Ltd." },
    { { 0x00, 0x24, 0x00 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x24, 0x01 }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x24, 0x02 }, "OpTection",    "Op-Tection GmbH" },
    { { 0x00, 0x24, 0x03 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x24, 0x04 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x24, 0x05 }, "DilogNordic",  "Dilog Nordic AB" },
    { { 0x00, 0x24, 0x06 }, "Pointmobile",  "Pointmobile" },
    { { 0x00, 0x24, 0x07 }, "TelemSas",     "Telem Sas" },
    { { 0x00, 0x24, 0x08 }, "PacificBiosc", "Pacific Biosciences" },
    { { 0x00, 0x24, 0x09 }, "Toro",         "The Toro Company" },
    { { 0x00, 0x24, 0x0A }, "USBeverageNe", "US Beverage Net" },
    { { 0x00, 0x24, 0x0B }, "VirtualCompu", "Virtual Computer Inc." },
    { { 0x00, 0x24, 0x0C }, "DELEC",        "DELEC GmbH" },
    { { 0x00, 0x24, 0x0D }, "OnePathNetwo", "OnePath Networks LTD." },
    { { 0x00, 0x24, 0x0E }, "InventecBest", "Inventec Besta Co., Ltd." },
    { { 0x00, 0x24, 0x0F }, "IshiiToolEng", "Ishii Tool & Engineering Corporation" },
    { { 0x00, 0x24, 0x10 }, "NUETEQTechno", "NUETEQ Technology,Inc." },
    { { 0x00, 0x24, 0x11 }, "PharmaSmart",  "PharmaSmart LLC" },
    { { 0x00, 0x24, 0x12 }, "BenignTechno", "Benign Technologies Co, Ltd." },
    { { 0x00, 0x24, 0x13 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0x14 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0x15 }, "MagneticAuto", "Magnetic Autocontrol GmbH" },
    { { 0x00, 0x24, 0x16 }, "AnyUse",       "Any Use" },
    { { 0x00, 0x24, 0x17 }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x24, 0x18 }, "NextwaveSemi", "Nextwave Semiconductor" },
    { { 0x00, 0x24, 0x19 }, "Private",      "Private" },
    { { 0x00, 0x24, 0x1A }, "RedBeetle",    "Red Beetle Inc." },
    { { 0x00, 0x24, 0x1B }, "iWOWCommunic", "iWOW Communications Pte Ltd" },
    { { 0x00, 0x24, 0x1C }, "FuGangElectr", "FuGang Electronic (DG) Co.,Ltd" },
    { { 0x00, 0x24, 0x1D }, "GigaByteTech", "Giga-Byte Technology Co.,Ltd." },
    { { 0x00, 0x24, 0x1E }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x24, 0x1F }, "DCTDelta",     "DCT-Delta GmbH" },
    { { 0x00, 0x24, 0x20 }, "NetUP",        "NetUP Inc." },
    { { 0x00, 0x24, 0x21 }, "MicroStarInt", "Micro-Star Int'L Co., Ltd." },
    { { 0x00, 0x24, 0x22 }, "KnappLogisti", "Knapp Logistik Automation GmbH" },
    { { 0x00, 0x24, 0x23 }, "AzureWaveTec", "AzureWave Technologies (Shanghai) Inc." },
    { { 0x00, 0x24, 0x24 }, "AceAxis",      "Ace Axis Limited" },
    { { 0x00, 0x24, 0x25 }, "Shenzhenshic", "Shenzhenshi chuangzhicheng Technology Co.,Ltd" },
    { { 0x00, 0x24, 0x26 }, "NohmiBosai",   "Nohmi Bosai Ltd." },
    { { 0x00, 0x24, 0x27 }, "SsiComputer",  "Ssi Computer Corp" },
    { { 0x00, 0x24, 0x28 }, "EnergyICT",    "EnergyICT" },
    { { 0x00, 0x24, 0x29 }, "MkMaster",     "Mk Master Inc." },
    { { 0x00, 0x24, 0x2A }, "HittiteMicro", "Hittite Microwave Corporation" },
    { { 0x00, 0x24, 0x2B }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x24, 0x2C }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x24, 0x2E }, "Datastrip",    "Datastrip Inc." },
    { { 0x00, 0x24, 0x2F }, "Micron",       "Micron" },
    { { 0x00, 0x24, 0x30 }, "RubyTech",     "Ruby Tech Corp." },
    { { 0x00, 0x24, 0x31 }, "Univ",         "Uni-v co.,ltd" },
    { { 0x00, 0x24, 0x32 }, "NeostarTechn", "Neostar Technology Co.,LTD" },
    { { 0x00, 0x24, 0x33 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x24, 0x34 }, "Lectrosonics", "Lectrosonics, Inc." },
    { { 0x00, 0x24, 0x35 }, "Wide",         "Wide Corporation" },
    { { 0x00, 0x24, 0x36 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x24, 0x37 }, "MotorolaBSG",  "Motorola - BSG" },
    { { 0x00, 0x24, 0x38 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x24, 0x39 }, "DigitalBarri", "Digital Barriers Advanced Technologies" },
    { { 0x00, 0x24, 0x3A }, "LudlElectron", "Ludl Electronic Products" },
    { { 0x00, 0x24, 0x3B }, "CSSIPte",      "CSSI (S) Pte Ltd" },
    { { 0x00, 0x24, 0x3C }, "SAAA",         "S.A.A.A." },
    { { 0x00, 0x24, 0x3D }, "EmersonAppli", "Emerson Appliance Motors and Controls" },
    { { 0x00, 0x24, 0x3F }, "Storwize",     "Storwize, Inc." },
    { { 0x00, 0x24, 0x40 }, "HaloMonitori", "Halo Monitoring, Inc." },
    { { 0x00, 0x24, 0x41 }, "WanzlMetallw", "Wanzl Metallwarenfabrik GmbH" },
    { { 0x00, 0x24, 0x42 }, "Axona",        "Axona Limited" },
    { { 0x00, 0x24, 0x43 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x24, 0x44 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x24, 0x45 }, "Adtran",       "Adtran Inc" },
    { { 0x00, 0x24, 0x46 }, "MMBResearch",  "MMB Research Inc." },
    { { 0x00, 0x24, 0x47 }, "Kaztek",       "Kaztek Systems" },
    { { 0x00, 0x24, 0x48 }, "SpiderCloudW", "SpiderCloud Wireless, Inc" },
    { { 0x00, 0x24, 0x49 }, "ShenZhenLite", "Shen Zhen Lite Star Electronics Technology Co., Ltd" },
    { { 0x00, 0x24, 0x4A }, "VoyantIntern", "Voyant International" },
    { { 0x00, 0x24, 0x4B }, "Perceptron",   "Perceptron Inc" },
    { { 0x00, 0x24, 0x4C }, "SolartronMet", "Solartron Metrology Ltd" },
    { { 0x00, 0x24, 0x4D }, "HokkaidoElec", "Hokkaido Electronics Corporation" },
    { { 0x00, 0x24, 0x4E }, "RadChips",     "RadChips, Inc." },
    { { 0x00, 0x24, 0x4F }, "AsantronTech", "Asantron Technologies Ltd." },
    { { 0x00, 0x24, 0x50 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0x51 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0x52 }, "SiliconSoftw", "Silicon Software GmbH" },
    { { 0x00, 0x24, 0x53 }, "Initradoo",    "Initra d.o.o." },
    { { 0x00, 0x24, 0x54 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x24, 0x55 }, "MuLogic",      "MuLogic BV" },
    { { 0x00, 0x24, 0x56 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x24, 0x58 }, "PABastionCC",  "PA Bastion CC" },
    { { 0x00, 0x24, 0x59 }, "ABBAutomatio", "ABB Automation products GmbH" },
    { { 0x00, 0x24, 0x5A }, "NanjingPanda", "Nanjing Panda Electronics Company Limited" },
    { { 0x00, 0x24, 0x5B }, "RaidonTechno", "Raidon Technology, Inc." },
    { { 0x00, 0x24, 0x5C }, "DesignComTec", "Design-Com Technologies Pty. Ltd." },
    { { 0x00, 0x24, 0x5D }, "Terbergbestu", "Terberg besturingstechniek B.V." },
    { { 0x00, 0x24, 0x5E }, "Hivision",     "Hivision Co.,ltd" },
    { { 0x00, 0x24, 0x5F }, "VineTelecom",  "Vine Telecom CO.,Ltd." },
    { { 0x00, 0x24, 0x60 }, "GiavalScienc", "Giaval Science Development Co. Ltd." },
    { { 0x00, 0x24, 0x61 }, "ShinWangTech", "Shin Wang Tech." },
    { { 0x00, 0x24, 0x62 }, "Rayzone",      "Rayzone Corporation" },
    { { 0x00, 0x24, 0x63 }, "Phybridge",    "Phybridge Inc" },
    { { 0x00, 0x24, 0x64 }, "BridgeTechno", "Bridge Technologies Co AS" },
    { { 0x00, 0x24, 0x65 }, "Elentec",      "Elentec" },
    { { 0x00, 0x24, 0x66 }, "Unitron",      "Unitron nv" },
    { { 0x00, 0x24, 0x67 }, "AOCInternati", "AOC International (Europe) GmbH" },
    { { 0x00, 0x24, 0x68 }, "SumavisionTe", "Sumavision Technologies Co.,Ltd" },
    { { 0x00, 0x24, 0x69 }, "FasttelSmart", "Fasttel - Smart Doorphones" },
    { { 0x00, 0x24, 0x6A }, "SolidYear",    "Solid Year Co., Ltd." },
    { { 0x00, 0x24, 0x6B }, "Covia",        "Covia, Inc." },
    { { 0x00, 0x24, 0x6C }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x00, 0x24, 0x6D }, "WeinzierlEng", "Weinzierl Engineering GmbH" },
    { { 0x00, 0x24, 0x6E }, "PhihongUSA",   "Phihong USA Corp." },
    { { 0x00, 0x24, 0x6F }, "OndaCommunic", "Onda Communication spa" },
    { { 0x00, 0x24, 0x70 }, "AUROTECHultr", "AUROTECH ultrasound AS." },
    { { 0x00, 0x24, 0x71 }, "FusionMultiS", "Fusion MultiSystems dba Fusion-io" },
    { { 0x00, 0x24, 0x72 }, "ReDrivenPowe", "ReDriven Power Inc." },
    { { 0x00, 0x24, 0x73 }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x24, 0x74 }, "AutronicaFir", "Autronica Fire And Securirty" },
    { { 0x00, 0x24, 0x75 }, "CompassSyste", "Compass System(Embedded Dept.)" },
    { { 0x00, 0x24, 0x76 }, "TAPtv",        "TAP.tv" },
    { { 0x00, 0x24, 0x77 }, "TibboTechnol", "Tibbo Technology" },
    { { 0x00, 0x24, 0x78 }, "MagTechElect", "Mag Tech Electronics Co Limited" },
    { { 0x00, 0x24, 0x79 }, "OptecDisplay", "Optec Displays, Inc." },
    { { 0x00, 0x24, 0x7A }, "FUYICHENGTec", "FU YI CHENG Technology Co., Ltd." },
    { { 0x00, 0x24, 0x7B }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x24, 0x7C }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x24, 0x7D }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x24, 0x7E }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x00, 0x24, 0x7F }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x24, 0x80 }, "Meteocontrol", "Meteocontrol GmbH" },
    { { 0x00, 0x24, 0x81 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x24, 0x82 }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0x24, 0x83 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x24, 0x84 }, "BangandOlufs", "Bang and Olufsen Medicom a/s" },
    { { 0x00, 0x24, 0x85 }, "ConteXtream",  "ConteXtream Ltd" },
    { { 0x00, 0x24, 0x86 }, "DesignArtNet", "DesignArt Networks" },
    { { 0x00, 0x24, 0x87 }, "TransactCamp", "Transact Campus, Inc." },
    { { 0x00, 0x24, 0x88 }, "CentreForDev", "Centre For Development Of Telematics" },
    { { 0x00, 0x24, 0x89 }, "VodafoneOmni", "Vodafone Omnitel N.V." },
    { { 0x00, 0x24, 0x8A }, "KagaElectron", "Kaga Electronics Co., Ltd." },
    { { 0x00, 0x24, 0x8B }, "Hybus",        "Hybus Co., Ltd." },
    { { 0x00, 0x24, 0x8C }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x24, 0x8D }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0x24, 0x8E }, "InfowareZRt",  "Infoware ZRt." },
    { { 0x00, 0x24, 0x8F }, "DoMonix",      "Do-Monix" },
    { { 0x00, 0x24, 0x90 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x24, 0x91 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x24, 0x92 }, "MotorolaBroa", "Motorola, Broadband Solutions Group" },
    { { 0x00, 0x24, 0x93 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x24, 0x94 }, "BaoxinTech",   "Shenzhen Baoxin Tech CO., Ltd." },
    { { 0x00, 0x24, 0x95 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x24, 0x96 }, "Ginzingerele", "Ginzinger electronic systems" },
    { { 0x00, 0x24, 0x97 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0x98 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0x99 }, "AquilaTechno", "Aquila Technologies" },
    { { 0x00, 0x24, 0x9A }, "ZhongchuangT", "Beijing Zhongchuang Telecommunication Test Co., Ltd." },
    { { 0x00, 0x24, 0x9B }, "ActionStarEn", "Action Star Enterprise Co., Ltd." },
    { { 0x00, 0x24, 0x9C }, "BimengComuni", "Bimeng Comunication System Co. Ltd" },
    { { 0x00, 0x24, 0x9D }, "NESTechnolog", "NES Technology Inc." },
    { { 0x00, 0x24, 0x9E }, "ADCElektroni", "ADC-Elektronik GmbH" },
    { { 0x00, 0x24, 0x9F }, "RIMTestingSe", "RIM Testing Services" },
    { { 0x00, 0x24, 0xA0 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x24, 0xA1 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x24, 0xA2 }, "HongKongMidd", "Hong Kong Middleware Technology Limited" },
    { { 0x00, 0x24, 0xA3 }, "SonimTechnol", "Sonim Technologies Inc" },
    { { 0x00, 0x24, 0xA4 }, "SikluCommuni", "Siklu Communication" },
    { { 0x00, 0x24, 0xA5 }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0x24, 0xA6 }, "TELESTARDIGI", "TELESTAR DIGITAL GmbH" },
    { { 0x00, 0x24, 0xA7 }, "AdvancedVide", "Advanced Video Communications Inc." },
    { { 0x00, 0x24, 0xA8 }, "ProCurveNetw", "ProCurve Networking by HP" },
    { { 0x00, 0x24, 0xA9 }, "AgLeaderTech", "Ag Leader Technology" },
    { { 0x00, 0x24, 0xAA }, "DycorTechnol", "Dycor Technologies Ltd." },
    { { 0x00, 0x24, 0xAB }, "A7Engineerin", "A7 Engineering, Inc." },
    { { 0x00, 0x24, 0xAC }, "DPtechTechno", "Hangzhou DPtech Technologies Co., Ltd." },
    { { 0x00, 0x24, 0xAD }, "AdolfThies",   "Adolf Thies Gmbh & Co. KG" },
    { { 0x00, 0x24, 0xAE }, "Idemia",       "Idemia" },
    { { 0x00, 0x24, 0xAF }, "DishTechnolo", "Dish Technologies Corp" },
    { { 0x00, 0x24, 0xB0 }, "Esab",         "Esab Ab" },
    { { 0x00, 0x24, 0xB1 }, "CoulombTechn", "Coulomb Technologies" },
    { { 0x00, 0x24, 0xB2 }, "Netgear",      "Netgear" },
    { { 0x00, 0x24, 0xB3 }, "GrafSyteco",   "Graf-Syteco GmbH & Co. KG" },
    { { 0x00, 0x24, 0xB4 }, "ESCATRONIC",   "ESCATRONIC GmbH" },
    { { 0x00, 0x24, 0xB5 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x24, 0xB6 }, "SeagateTechn", "Seagate Technology" },
    { { 0x00, 0x24, 0xB7 }, "GridPoint",    "GridPoint, Inc." },
    { { 0x00, 0x24, 0xB8 }, "freealliance", "free alliance sdn bhd" },
    { { 0x00, 0x24, 0xB9 }, "HigheasyElec", "Wuhan Higheasy Electronic Technology Development Co.Ltd" },
    { { 0x00, 0x24, 0xBA }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x24, 0xBB }, "CENTRAL",      "CENTRAL Corporation" },
    { { 0x00, 0x24, 0xBC }, "HuRob",        "HuRob Co.,Ltd" },
    { { 0x00, 0x24, 0xBD }, "HainzlIndust", "Hainzl Industriesysteme GmbH" },
    { { 0x00, 0x24, 0xBE }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x24, 0xBF }, "CarrierCuloz", "Carrier Culoz SA" },
    { { 0x00, 0x24, 0xC0 }, "NtiComodo",    "Nti Comodo Inc" },
    { { 0x00, 0x24, 0xC1 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x24, 0xC2 }, "Asumo",        "Asumo Co.,Ltd." },
    { { 0x00, 0x24, 0xC3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0xC4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0xC5 }, "MeridianAudi", "Meridian Audio Limited" },
    { { 0x00, 0x24, 0xC6 }, "HagerElectro", "Hager Electro SAS" },
    { { 0x00, 0x24, 0xC7 }, "Mobilarm",     "Mobilarm Ltd" },
    { { 0x00, 0x24, 0xC8 }, "BroadbandSol", "Broadband Solutions Group" },
    { { 0x00, 0x24, 0xC9 }, "BroadbandSol", "Broadband Solutions Group" },
    { { 0x00, 0x24, 0xCA }, "TobiiTechnol", "Tobii Technology AB" },
    { { 0x00, 0x24, 0xCB }, "AutonetMobil", "Autonet Mobile" },
    { { 0x00, 0x24, 0xCC }, "Fascinations", "Fascinations Toys and Gifts, Inc." },
    { { 0x00, 0x24, 0xCD }, "WillowGarage", "Willow Garage, Inc." },
    { { 0x00, 0x24, 0xCE }, "Exeltech",     "Exeltech Inc" },
    { { 0x00, 0x24, 0xCF }, "InscapeData",  "Inscape Data Corporation" },
    { { 0x00, 0x24, 0xD0 }, "SOGOODIndust", "Shenzhen SOGOOD Industry CO.,LTD." },
    { { 0x00, 0x24, 0xD1 }, "Thomson",      "Thomson Inc." },
    { { 0x00, 0x24, 0xD2 }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x00, 0x24, 0xD3 }, "QUALICA",      "QUALICA Inc." },
    { { 0x00, 0x24, 0xD4 }, "FreeboxSas",   "Freebox Sas" },
    { { 0x00, 0x24, 0xD5 }, "WinwardIndus", "Winward Industrial Limited" },
    { { 0x00, 0x24, 0xD6 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x24, 0xD7 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x24, 0xD8 }, "IlSungPrecis", "IlSung Precision" },
    { { 0x00, 0x24, 0xD9 }, "BICOM",        "BICOM, Inc." },
    { { 0x00, 0x24, 0xDA }, "Innovar",      "Innovar Systems Limited" },
    { { 0x00, 0x24, 0xDB }, "AlcoholMonit", "Alcohol Monitoring Systems" },
    { { 0x00, 0x24, 0xDC }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x24, 0xDD }, "Centrak",      "Centrak, Inc." },
    { { 0x00, 0x24, 0xDE }, "GLOBALTechno", "GLOBAL Technology Inc." },
    { { 0x00, 0x24, 0xDF }, "DigitalboxEu", "Digitalbox Europe GmbH" },
    { { 0x00, 0x24, 0xE0 }, "DSTech",       "DS Tech, LLC" },
    { { 0x00, 0x24, 0xE1 }, "ConveyComput", "Convey Computer Corp." },
    { { 0x00, 0x24, 0xE2 }, "HasegawaElec", "Hasegawa Electric Co.,Ltd." },
    { { 0x00, 0x24, 0xE3 }, "CAOGroup",     "CAO Group" },
    { { 0x00, 0x24, 0xE4 }, "Withings",     "Withings" },
    { { 0x00, 0x24, 0xE5 }, "SeerTechnolo", "Seer Technology, Inc" },
    { { 0x00, 0x24, 0xE6 }, "InMotionTech", "In Motion Technology Inc." },
    { { 0x00, 0x24, 0xE7 }, "PlasterNetwo", "Plaster Networks" },
    { { 0x00, 0x24, 0xE8 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x24, 0xE9 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x24, 0xEA }, "irisinfrared", "iris-GmbH infrared & intelligent sensors" },
    { { 0x00, 0x24, 0xEB }, "ClearPathNet", "ClearPath Networks, Inc." },
    { { 0x00, 0x24, 0xEC }, "UnitedInform", "United Information Technology Co.,Ltd." },
    { { 0x00, 0x24, 0xED }, "YTElec",       "YT Elec. Co,.Ltd." },
    { { 0x00, 0x24, 0xEE }, "Wynmax",       "Wynmax Inc." },
    { { 0x00, 0x24, 0xEF }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x24, 0xF0 }, "Seanodes",     "Seanodes" },
    { { 0x00, 0x24, 0xF1 }, "FanhaiSanjia", "Shenzhen Fanhai Sanjiang Electronics Co., Ltd." },
    { { 0x00, 0x24, 0xF2 }, "UniphoneTele", "Uniphone Telecommunication Co., Ltd." },
    { { 0x00, 0x24, 0xF3 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x24, 0xF4 }, "Kaminario",    "Kaminario, Ltd." },
    { { 0x00, 0x24, 0xF5 }, "NDSSurgicalI", "NDS Surgical Imaging" },
    { { 0x00, 0x24, 0xF6 }, "MiyoshiElect", "Miyoshi Electronics Corporation" },
    { { 0x00, 0x24, 0xF7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0xF8 }, "TechnicalSol", "Technical Solutions Company Ltd." },
    { { 0x00, 0x24, 0xF9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x24, 0xFA }, "HilgeruKern",  "Hilger u. Kern GMBH" },
    { { 0x00, 0x24, 0xFB }, "Private",      "Private" },
    { { 0x00, 0x24, 0xFC }, "QuoPin",       "QuoPin Co., Ltd." },
    { { 0x00, 0x24, 0xFD }, "AccedianNetw", "Accedian Networks Inc" },
    { { 0x00, 0x24, 0xFE }, "AVM",          "AVM GmbH" },
    { { 0x00, 0x24, 0xFF }, "QLogic",       "QLogic Corporation" },
    { { 0x00, 0x25, 0x00 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x25, 0x01 }, "JSCSupertel",  "JSC \"Supertel\"" },
    { { 0x00, 0x25, 0x02 }, "NaturalPoint", "NaturalPoint" },
    { { 0x00, 0x25, 0x03 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x25, 0x04 }, "ValiantCommu", "Valiant Communications Limited" },
    { { 0x00, 0x25, 0x05 }, "eksEngel",     "eks Engel GmbH & Co. KG" },
    { { 0x00, 0x25, 0x06 }, "AIAntitacche", "A.I. Antitaccheggio Italia Srl" },
    { { 0x00, 0x25, 0x07 }, "ASTAK",        "ASTAK Inc." },
    { { 0x00, 0x25, 0x08 }, "MaquetCardio", "Maquet Cardiopulmonary AG" },
    { { 0x00, 0x25, 0x09 }, "SHARETRONICG", "SHARETRONIC Group LTD" },
    { { 0x00, 0x25, 0x0A }, "SecurityExpe", "Security Expert Co. Ltd" },
    { { 0x00, 0x25, 0x0B }, "Centrofactor", "Centrofactor Inc" },
    { { 0x00, 0x25, 0x0C }, "Senet",        "Senet Inc" },
    { { 0x00, 0x25, 0x0D }, "GZTTelkomTel", "GZT Telkom-Telmor sp. z o.o." },
    { { 0x00, 0x25, 0x0E }, "gtgermantele", "gt german telematics gmbh" },
    { { 0x00, 0x25, 0x0F }, "OnRampWirele", "On-Ramp Wireless, Inc." },
    { { 0x00, 0x25, 0x10 }, "PicoTeslaMag", "Pico-Tesla Magnetic Therapies" },
    { { 0x00, 0x25, 0x11 }, "ElitegroupCo", "Elitegroup Computer Systems Co.,Ltd." },
    { { 0x00, 0x25, 0x12 }, "zte",          "zte corporation" },
    { { 0x00, 0x25, 0x13 }, "CxpDigital",   "Cxp Digital Bv" },
    { { 0x00, 0x25, 0x14 }, "PCWorthIntl",  "PC Worth Int'l Co., Ltd." },
    { { 0x00, 0x25, 0x15 }, "Sfr",          "Sfr" },
    { { 0x00, 0x25, 0x16 }, "IntegratedDe", "Integrated Design Tools, Inc." },
    { { 0x00, 0x25, 0x17 }, "Venntis",      "Venntis, LLC" },
    { { 0x00, 0x25, 0x18 }, "PowerPLUSCom", "Power PLUS Communications AG" },
    { { 0x00, 0x25, 0x19 }, "Viaas",        "Viaas Inc" },
    { { 0x00, 0x25, 0x1A }, "PsiberData",   "Psiber Data Systems Inc." },
    { { 0x00, 0x25, 0x1B }, "PhilipsCareS", "Philips CareServant" },
    { { 0x00, 0x25, 0x1C }, "Edt",          "Edt" },
    { { 0x00, 0x25, 0x1D }, "DSAEncore",    "DSA Encore, LLC" },
    { { 0x00, 0x25, 0x1E }, "RotelTechnol", "Rotel Technologies" },
    { { 0x00, 0x25, 0x1F }, "ZynusVision",  "Zynus Vision Inc." },
    { { 0x00, 0x25, 0x20 }, "SMARailwayTe", "SMA Railway Technology GmbH" },
    { { 0x00, 0x25, 0x21 }, "LogitekElect", "Logitek Electronic Systems, Inc." },
    { { 0x00, 0x25, 0x22 }, "ASRockIncorp", "ASRock Incorporation" },
    { { 0x00, 0x25, 0x23 }, "OCP",          "OCP Inc." },
    { { 0x00, 0x25, 0x24 }, "LightcommTec", "Lightcomm Technology Co., Ltd" },
    { { 0x00, 0x25, 0x25 }, "CTERANetwork", "CTERA Networks Ltd." },
    { { 0x00, 0x25, 0x26 }, "GenuineTechn", "Genuine Technologies Co., Ltd." },
    { { 0x00, 0x25, 0x27 }, "Bitrode",      "Bitrode Corp." },
    { { 0x00, 0x25, 0x28 }, "DaidoSignal",  "Daido Signal Co., Ltd." },
    { { 0x00, 0x25, 0x29 }, "ComelitGroup", "Comelit Group S.P.A" },
    { { 0x00, 0x25, 0x2A }, "GeeYaTechnol", "Chengdu GeeYa Technology Co.,LTD" },
    { { 0x00, 0x25, 0x2B }, "StirlingEner", "Stirling Energy Systems" },
    { { 0x00, 0x25, 0x2C }, "Entourage",    "Entourage Systems, Inc." },
    { { 0x00, 0x25, 0x2D }, "KiryungElect", "Kiryung Electronics" },
    { { 0x00, 0x25, 0x2E }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x00, 0x25, 0x2F }, "Energy",       "Energy, Inc." },
    { { 0x00, 0x25, 0x30 }, "Aetas",        "Aetas Systems Inc." },
    { { 0x00, 0x25, 0x31 }, "CloudEngines", "Cloud Engines, Inc." },
    { { 0x00, 0x25, 0x32 }, "DigitalRecor", "Digital Recorders" },
    { { 0x00, 0x25, 0x33 }, "Wittenstein",  "Wittenstein Ag" },
    { { 0x00, 0x25, 0x35 }, "Minimax",      "Minimax GmbH & Co KG" },
    { { 0x00, 0x25, 0x36 }, "OkiElectricI", "Oki Electric Industry Co., Ltd." },
    { { 0x00, 0x25, 0x37 }, "RuncomTechno", "Runcom Technologies Ltd." },
    { { 0x00, 0x25, 0x38 }, "SamsungElect", "Samsung Electronics Co., Ltd., Memory Division" },
    { { 0x00, 0x25, 0x39 }, "IfTA",         "IfTA GmbH" },
    { { 0x00, 0x25, 0x3A }, "CEVA",         "CEVA, Ltd." },
    { { 0x00, 0x25, 0x3B }, "dinDietmarNo", "din Dietmar Nocker Facilitymanagement GmbH" },
    { { 0x00, 0x25, 0x3C }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x25, 0x3D }, "DRSConsolida", "DRS Consolidated Controls" },
    { { 0x00, 0x25, 0x3E }, "SensusMeteri", "Sensus Metering Systems" },
    { { 0x00, 0x25, 0x40 }, "QuasarTechno", "Quasar Technologies, Inc." },
    { { 0x00, 0x25, 0x41 }, "MaquetCritic", "Maquet Critical Care AB" },
    { { 0x00, 0x25, 0x42 }, "Pittasoft",    "Pittasoft" },
    { { 0x00, 0x25, 0x43 }, "Moneytech",    "Moneytech" },
    { { 0x00, 0x25, 0x44 }, "LoJack",       "LoJack Corporation" },
    { { 0x00, 0x25, 0x45 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x25, 0x46 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x25, 0x47 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x25, 0x48 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x25, 0x49 }, "JeorichTech",  "Jeorich Tech. Co.,Ltd." },
    { { 0x00, 0x25, 0x4A }, "RingCubeTech", "RingCube Technologies, Inc." },
    { { 0x00, 0x25, 0x4B }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x25, 0x4C }, "VideonCentra", "Videon Central, Inc." },
    { { 0x00, 0x25, 0x4D }, "SingaporeTec", "Singapore Technologies Electronics Limited" },
    { { 0x00, 0x25, 0x4E }, "VertexWirele", "Vertex Wireless Co., Ltd." },
    { { 0x00, 0x25, 0x4F }, "ELETTROLAB",   "ELETTROLAB Srl" },
    { { 0x00, 0x25, 0x50 }, "RiverbedTech", "Riverbed Technology, Inc." },
    { { 0x00, 0x25, 0x51 }, "SEElektronic", "SE-Elektronic GmbH" },
    { { 0x00, 0x25, 0x52 }, "VXi",          "VXi Corporation" },
    { { 0x00, 0x25, 0x53 }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x25, 0x54 }, "Pixel8Networ", "Pixel8 Networks" },
    { { 0x00, 0x25, 0x55 }, "VisonicTechn", "Visonic Technologies 1993 Ltd." },
    { { 0x00, 0x25, 0x56 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x25, 0x57 }, "BlackBerryRT", "BlackBerry RTS" },
    { { 0x00, 0x25, 0x58 }, "Mpedia",       "Mpedia" },
    { { 0x00, 0x25, 0x59 }, "SyphanTechno", "Syphan Technologies Ltd" },
    { { 0x00, 0x25, 0x5A }, "Tantalus",     "Tantalus Systems Corp." },
    { { 0x00, 0x25, 0x5B }, "CoachComm",    "CoachComm, LLC" },
    { { 0x00, 0x25, 0x5C }, "NEC",          "NEC Corporation" },
    { { 0x00, 0x25, 0x5D }, "Morningstar",  "Morningstar Corporation" },
    { { 0x00, 0x25, 0x5E }, "DareTechnolo", "Shanghai Dare Technologies Co.,Ltd." },
    { { 0x00, 0x25, 0x5F }, "SenTec",       "SenTec AG" },
    { { 0x00, 0x25, 0x60 }, "IbridgeNetwo", "Ibridge Networks & Communications Ltd." },
    { { 0x00, 0x25, 0x61 }, "ProCurveNetw", "ProCurve Networking by HP" },
    { { 0x00, 0x25, 0x62 }, "interbro",     "interbro Co. Ltd." },
    { { 0x00, 0x25, 0x63 }, "Luxtera",      "Luxtera Inc" },
    { { 0x00, 0x25, 0x64 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x25, 0x65 }, "Vizimax",      "Vizimax Inc." },
    { { 0x00, 0x25, 0x66 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x25, 0x67 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x25, 0x68 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x25, 0x69 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x25, 0x6A }, "inITInstitut", "inIT - Institut Industrial IT" },
    { { 0x00, 0x25, 0x6B }, "ATENIXEE",     "ATENIX E.E. s.r.l." },
    { { 0x00, 0x25, 0x6C }, "AzimutProduc", "\"Azimut\" Production Association JSC" },
    { { 0x00, 0x25, 0x6D }, "BroadbandFor", "Broadband Forum" },
    { { 0x00, 0x25, 0x6E }, "VanBreda",     "Van Breda B.V." },
    { { 0x00, 0x25, 0x6F }, "DanthermPowe", "Dantherm Power" },
    { { 0x00, 0x25, 0x70 }, "EasternCommu", "Eastern Communications Company Limited" },
    { { 0x00, 0x25, 0x71 }, "ZhejiangTian", "Zhejiang Tianle Digital Electric Co.,Ltd" },
    { { 0x00, 0x25, 0x72 }, "NemoQInterna", "Nemo-Q International AB" },
    { { 0x00, 0x25, 0x73 }, "STElectronic", "ST Electronics (Info-Security) Pte Ltd" },
    { { 0x00, 0x25, 0x74 }, "KUNIMIMEDIAD", "KUNIMI MEDIA DEVICE Co., Ltd." },
    { { 0x00, 0x25, 0x75 }, "FiberPlexTec", "FiberPlex Technologies, LLC" },
    { { 0x00, 0x25, 0x76 }, "NeliTechnolo", "Neli Technologies" },
    { { 0x00, 0x25, 0x77 }, "DBOXTechnolo", "D-BOX Technologies" },
    { { 0x00, 0x25, 0x78 }, "JSCConcernSo", "JSC \"Concern \"Sozvezdie\"" },
    { { 0x00, 0x25, 0x79 }, "JFLabs",       "J & F Labs" },
    { { 0x00, 0x25, 0x7A }, "CAMCOProdukt", "CAMCO Produktions- und Vertriebs-GmbH für Beschallungs- und Beleuchtungsanlagen" },
    { { 0x00, 0x25, 0x7B }, "StjElectroni", "Stj Electronics Pvt Ltd" },
    { { 0x00, 0x25, 0x7C }, "HuachentelTe", "Huachentel Technology Development Co., Ltd" },
    { { 0x00, 0x25, 0x7D }, "PointRedTele", "PointRed Telecom Private Ltd." },
    { { 0x00, 0x25, 0x7E }, "NewPosTechno", "New Pos Technology Limited" },
    { { 0x00, 0x25, 0x7F }, "CallTechSolu", "CallTechSolution Co.,Ltd" },
    { { 0x00, 0x25, 0x80 }, "Equipson",     "Equipson S.A." },
    { { 0x00, 0x25, 0x81 }, "xstarnetwork", "x-star networks Inc." },
    { { 0x00, 0x25, 0x82 }, "MaksatTechno", "Maksat Technologies (P) Ltd" },
    { { 0x00, 0x25, 0x83 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x25, 0x84 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x25, 0x85 }, "KOKUYOS&T",    "KOKUYO S&T Co., Ltd." },
    { { 0x00, 0x25, 0x86 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x25, 0x87 }, "Vitality",     "Vitality, Inc." },
    { { 0x00, 0x25, 0x88 }, "GenieIndustr", "Genie Industries, Inc." },
    { { 0x00, 0x25, 0x89 }, "HillsIndustr", "Hills Industries Limited" },
    { { 0x00, 0x25, 0x8A }, "PoleZero",     "Pole/Zero Corporation" },
    { { 0x00, 0x25, 0x8B }, "MellanoxTech", "Mellanox Technologies, Inc." },
    { { 0x00, 0x25, 0x8C }, "EsusElektron", "Esus Elektronik San. Ve Dis. Tic. Ltd. Sti." },
    { { 0x00, 0x25, 0x8D }, "Haier",        "Haier" },
    { { 0x00, 0x25, 0x8E }, "WeatherChann", "The Weather Channel" },
    { { 0x00, 0x25, 0x8F }, "TridentMicro", "Trident Microsystems, Inc." },
    { { 0x00, 0x25, 0x90 }, "SuperMicroCo", "Super Micro Computer, Inc." },
    { { 0x00, 0x25, 0x91 }, "NEXTEK",       "NEXTEK, Inc." },
    { { 0x00, 0x25, 0x92 }, "GuangzhouShi", "Guangzhou Shirui Electronic Co., Ltd" },
    { { 0x00, 0x25, 0x93 }, "DatNetInform", "DatNet Informatikai Kft." },
    { { 0x00, 0x25, 0x94 }, "EurodesignBG", "Eurodesign BG LTD" },
    { { 0x00, 0x25, 0x95 }, "NorthwestSig", "Northwest Signal Supply, Inc" },
    { { 0x00, 0x25, 0x96 }, "GIGAVISION",   "GIGAVISION srl" },
    { { 0x00, 0x25, 0x97 }, "KalkiCommuni", "Kalki Communication Technologies" },
    { { 0x00, 0x25, 0x98 }, "ZhongShanCit", "Zhong Shan City Litai Electronic Industrial Co. Ltd" },
    { { 0x00, 0x25, 0x99 }, "Hedoned",      "Hedon e.d. B.V." },
    { { 0x00, 0x25, 0x9A }, "CEStronics",   "CEStronics GmbH" },
    { { 0x00, 0x25, 0x9B }, "PKUNITYMicro", "Beijing PKUNITY Microsystems Technology Co., Ltd" },
    { { 0x00, 0x25, 0x9C }, "CiscoLinksys", "Cisco-Linksys, LLC" },
    { { 0x00, 0x25, 0x9D }, "Private",      "Private" },
    { { 0x00, 0x25, 0x9E }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x25, 0x9F }, "TechnoDigita", "TechnoDigital Technologies GmbH" },
    { { 0x00, 0x25, 0xA0 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x25, 0xA1 }, "Enalasys",     "Enalasys" },
    { { 0x00, 0x25, 0xA2 }, "AltaDefinici", "Alta Definicion LINCEO S.L." },
    { { 0x00, 0x25, 0xA3 }, "TrimaxWirele", "Trimax Wireless, Inc." },
    { { 0x00, 0x25, 0xA4 }, "EuroDesignem", "EuroDesign embedded technologies GmbH" },
    { { 0x00, 0x25, 0xA5 }, "WalnutMediaN", "Walnut Media Network" },
    { { 0x00, 0x25, 0xA6 }, "CentralNetwo", "Central Network Solution Co., Ltd." },
    { { 0x00, 0x25, 0xA7 }, "itron",        "itron" },
    { { 0x00, 0x25, 0xA8 }, "KontronTechn", "Kontron (BeiJing) Technology Co.,Ltd" },
    { { 0x00, 0x25, 0xA9 }, "EmbedwayInfo", "Shanghai Embedway Information Technologies Co.,Ltd" },
    { { 0x00, 0x25, 0xAA }, "SoulTechnolo", "Beijing Soul Technology Co.,Ltd." },
    { { 0x00, 0x25, 0xAB }, "AioLcdPcBuTp", "Aio Lcd Pc Bu / Tpv" },
    { { 0x00, 0x25, 0xAC }, "ITech",        "I-Tech corporation" },
    { { 0x00, 0x25, 0xAD }, "Manufacturin", "Manufacturing Resources International" },
    { { 0x00, 0x25, 0xAE }, "Microsoft",    "Microsoft Corporation" },
    { { 0x00, 0x25, 0xAF }, "COMFILETechn", "COMFILE Technology" },
    { { 0x00, 0x25, 0xB0 }, "Schmartz",     "Schmartz Inc" },
    { { 0x00, 0x25, 0xB1 }, "MayaCreation", "Maya-Creation Corporation" },
    { { 0x00, 0x25, 0xB2 }, "MBDADeutschl", "MBDA Deutschland GmbH" },
    { { 0x00, 0x25, 0xB3 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x25, 0xB4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x25, 0xB5 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x25, 0xB6 }, "TelecomFM",    "Telecom FM" },
    { { 0x00, 0x25, 0xB7 }, "Costarelectr", "Costar electronics, inc.," },
    { { 0x00, 0x25, 0xB8 }, "AgileCommuni", "Agile Communications, Inc." },
    { { 0x00, 0x25, 0xB9 }, "CypressSolut", "Cypress Solutions Inc" },
    { { 0x00, 0x25, 0xBA }, "AlcatelLucen", "Alcatel-Lucent IPD" },
    { { 0x00, 0x25, 0xBB }, "INNERINT",     "INNERINT Co., Ltd." },
    { { 0x00, 0x25, 0xBC }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x25, 0xBD }, "ItaldataInge", "Italdata Ingegneria dell'Idea S.p.A." },
    { { 0x00, 0x25, 0xBE }, "Tektrap",      "Tektrap Systems Inc." },
    { { 0x00, 0x25, 0xBF }, "WirelessCabl", "Wireless Cables Inc." },
    { { 0x00, 0x25, 0xC0 }, "ZillionTV",    "ZillionTV Corporation" },
    { { 0x00, 0x25, 0xC1 }, "NawooKorea",   "Nawoo Korea Corp." },
    { { 0x00, 0x25, 0xC2 }, "RingBell",     "RingBell Co.,Ltd." },
    { { 0x00, 0x25, 0xC3 }, "21168",        "21168" },
    { { 0x00, 0x25, 0xC4 }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0x25, 0xC5 }, "StarLinkComm", "Star Link Communication Pvt. Ltd." },
    { { 0x00, 0x25, 0xC6 }, "kasercorp",    "kasercorp, ltd" },
    { { 0x00, 0x25, 0xC7 }, "altek",        "altek Corporation" },
    { { 0x00, 0x25, 0xC8 }, "SAccess",      "S-Access GmbH" },
    { { 0x00, 0x25, 0xC9 }, "HuapuDigital", "Shenzhen Huapu Digital Co., Ltd" },
    { { 0x00, 0x25, 0xCA }, "LairdConnect", "Laird Connectivity" },
    { { 0x00, 0x25, 0xCB }, "ReinerSCT",    "Reiner SCT" },
    { { 0x00, 0x25, 0xCC }, "MobileCommun", "Mobile Communications Korea Incorporated" },
    { { 0x00, 0x25, 0xCD }, "SkylaneOptic", "Skylane Optics" },
    { { 0x00, 0x25, 0xCE }, "InnerSpace",   "InnerSpace" },
    { { 0x00, 0x25, 0xCF }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x25, 0xD0 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x25, 0xD1 }, "EasternAsiaT", "Eastern Asia Technology Limited" },
    { { 0x00, 0x25, 0xD2 }, "InpegVision",  "InpegVision Co., Ltd" },
    { { 0x00, 0x25, 0xD3 }, "AzureWaveTec", "AzureWave Technology Inc." },
    { { 0x00, 0x25, 0xD4 }, "GeneralDynam", "General Dynamics Mission Systems" },
    { { 0x00, 0x25, 0xD5 }, "Robonica",     "Robonica (Pty) Ltd" },
    { { 0x00, 0x25, 0xD6 }, "Kroger",       "The Kroger Co." },
    { { 0x00, 0x25, 0xD7 }, "Cedo",         "Cedo" },
    { { 0x00, 0x25, 0xD8 }, "KoreaMainten", "Korea Maintenance" },
    { { 0x00, 0x25, 0xD9 }, "DataFab",      "DataFab Systems Inc." },
    { { 0x00, 0x25, 0xDA }, "SecuraKey",    "Secura Key" },
    { { 0x00, 0x25, 0xDB }, "ATIElectroni", "ATI Electronics(Shenzhen) Co., LTD" },
    { { 0x00, 0x25, 0xDC }, "SumitomoElec", "Sumitomo Electric Industries, Ltd" },
    { { 0x00, 0x25, 0xDD }, "SunnytekInfo", "Sunnytek Information Co., Ltd." },
    { { 0x00, 0x25, 0xDE }, "Probits",      "Probits Co., LTD." },
    { { 0x00, 0x25, 0xDF }, "TaserInterna", "Taser International Inc." },
    { { 0x00, 0x25, 0xE0 }, "CeedTecSdnBh", "CeedTec Sdn Bhd" },
    { { 0x00, 0x25, 0xE1 }, "SeeyooElectr", "Shanghai Seeyoo Electronic & Technology Co., Ltd" },
    { { 0x00, 0x25, 0xE2 }, "EverspringIn", "Everspring Industry Co., Ltd." },
    { { 0x00, 0x25, 0xE3 }, "Hanshinit",    "Hanshinit Inc." },
    { { 0x00, 0x25, 0xE4 }, "OMNIWiFi",     "OMNI-WiFi, LLC" },
    { { 0x00, 0x25, 0xE5 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x25, 0xE6 }, "BelgianMonit", "Belgian Monitoring Systems bvba" },
    { { 0x00, 0x25, 0xE7 }, "Sony",         "Sony Corporation" },
    { { 0x00, 0x25, 0xE8 }, "IdahoTechnol", "Idaho Technology" },
    { { 0x00, 0x25, 0xE9 }, "imateDevelop", "i-mate Development, Inc." },
    { { 0x00, 0x25, 0xEA }, "Iphion",       "Iphion BV" },
    { { 0x00, 0x25, 0xEB }, "ReutechRadar", "Reutech Radar Systems (PTY) Ltd" },
    { { 0x00, 0x25, 0xEC }, "Humanware",    "Humanware" },
    { { 0x00, 0x25, 0xED }, "NuVoTechnolo", "NuVo Technologies LLC" },
    { { 0x00, 0x25, 0xEE }, "Avtex",        "Avtex Ltd" },
    { { 0x00, 0x25, 0xEF }, "ITEC",         "I-TEC Co., Ltd." },
    { { 0x00, 0x25, 0xF0 }, "SugaElectron", "Suga Electronics Limited" },
    { { 0x00, 0x25, 0xF1 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x25, 0xF2 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x25, 0xF3 }, "Nordwestdeut", "Nordwestdeutsche Zählerrevision" },
    { { 0x00, 0x25, 0xF4 }, "KoCoConnecto", "KoCo Connector AG" },
    { { 0x00, 0x25, 0xF5 }, "DVSKorea",     "DVS Korea, Co., Ltd" },
    { { 0x00, 0x25, 0xF6 }, "netTALKcom",   "netTALK.com, Inc." },
    { { 0x00, 0x25, 0xF7 }, "AnsaldoSTSUS", "Ansaldo STS USA" },
    { { 0x00, 0x25, 0xF9 }, "GMKelectroni", "GMK electronic design GmbH" },
    { { 0x00, 0x25, 0xFA }, "J&MAnalytik",  "J&M Analytik AG" },
    { { 0x00, 0x25, 0xFB }, "TunstallHeal", "Tunstall Healthcare A/S" },
    { { 0x00, 0x25, 0xFC }, "Enda",         "Enda" },
    { { 0x00, 0x25, 0xFD }, "OBRCentrumTe", "OBR Centrum Techniki Morskiej S.A." },
    { { 0x00, 0x25, 0xFE }, "PilotElectro", "Pilot Electronics Corporation" },
    { { 0x00, 0x25, 0xFF }, "CreNovaMulti", "CreNova Multimedia Co., Ltd" },
    { { 0x00, 0x26, 0x00 }, "TEACAustrali", "TEAC Australia Pty Ltd." },
    { { 0x00, 0x26, 0x01 }, "Cutera",       "Cutera Inc" },
    { { 0x00, 0x26, 0x02 }, "SMARTTemps",   "SMART Temps LLC" },
    { { 0x00, 0x26, 0x03 }, "WistarTechno", "Shenzhen Wistar Technology Co., Ltd" },
    { { 0x00, 0x26, 0x04 }, "WorldCast",    "WorldCast Systems" },
    { { 0x00, 0x26, 0x05 }, "CC",           "CC Systems AB" },
    { { 0x00, 0x26, 0x06 }, "RAUMFELD",     "RAUMFELD GmbH" },
    { { 0x00, 0x26, 0x07 }, "EnablingTech", "Enabling Technology Pty Ltd" },
    { { 0x00, 0x26, 0x08 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x26, 0x09 }, "Phyllis",      "Phyllis Co., Ltd." },
    { { 0x00, 0x26, 0x0A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0x0B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0x0C }, "Dataram",      "Dataram" },
    { { 0x00, 0x26, 0x0D }, "Mercury",      "Mercury Systems, Inc." },
    { { 0x00, 0x26, 0x0E }, "Ablaze",       "Ablaze Systems, LLC" },
    { { 0x00, 0x26, 0x0F }, "LinnProducts", "Linn Products Ltd" },
    { { 0x00, 0x26, 0x10 }, "ApacewaveTec", "Apacewave Technologies" },
    { { 0x00, 0x26, 0x11 }, "Licera",       "Licera AB" },
    { { 0x00, 0x26, 0x12 }, "SpaceExplora", "Space Exploration Technologies" },
    { { 0x00, 0x26, 0x13 }, "EngelAxilSL",  "Engel Axil S.L." },
    { { 0x00, 0x26, 0x14 }, "Ktnf",         "Ktnf" },
    { { 0x00, 0x26, 0x15 }, "Teracom",      "Teracom Limited" },
    { { 0x00, 0x26, 0x16 }, "Rosemount",    "Rosemount Inc." },
    { { 0x00, 0x26, 0x17 }, "OEMWorldwide", "OEM Worldwide" },
    { { 0x00, 0x26, 0x18 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0x26, 0x19 }, "Frc",          "Frc" },
    { { 0x00, 0x26, 0x1A }, "FemtocommSys", "Femtocomm System Technology Corp." },
    { { 0x00, 0x26, 0x1B }, "LaurelBankMa", "Laurel Bank Machines Co., Ltd." },
    { { 0x00, 0x26, 0x1C }, "Neovia",       "Neovia Inc." },
    { { 0x00, 0x26, 0x1D }, "CopSecurityS", "Cop Security System Corp." },
    { { 0x00, 0x26, 0x1E }, "QingbangElec", "Qingbang Elec(Sz) Co., Ltd" },
    { { 0x00, 0x26, 0x1F }, "SAEMagnetics", "SAE Magnetics (H.K.) Ltd." },
    { { 0x00, 0x26, 0x20 }, "ISGUS",        "ISGUS GmbH" },
    { { 0x00, 0x26, 0x21 }, "InteliCloudT", "InteliCloud Technology Inc." },
    { { 0x00, 0x26, 0x22 }, "CompalInform", "Compal Information (Kunshan) Co., Ltd." },
    { { 0x00, 0x26, 0x23 }, "JRDCommunica", "JRD Communication Inc" },
    { { 0x00, 0x26, 0x24 }, "Thomson",      "Thomson Inc." },
    { { 0x00, 0x26, 0x25 }, "MediaSputnik", "MediaSputnik" },
    { { 0x00, 0x26, 0x26 }, "GeophysicalS", "Geophysical Survey Systems, Inc." },
    { { 0x00, 0x26, 0x27 }, "Truesell",     "Truesell" },
    { { 0x00, 0x26, 0x28 }, "companytecau", "companytec automação e controle ltda." },
    { { 0x00, 0x26, 0x29 }, "JuphoonSyste", "Juphoon System Software Inc." },
    { { 0x00, 0x26, 0x2A }, "Proxense",     "Proxense, LLC" },
    { { 0x00, 0x26, 0x2B }, "WongsElectro", "Wongs Electronics Co. Ltd." },
    { { 0x00, 0x26, 0x2C }, "IKTAdvancedT", "IKT Advanced Technologies s.r.o." },
    { { 0x00, 0x26, 0x2D }, "Wistron",      "Wistron Corporation" },
    { { 0x00, 0x26, 0x2E }, "JiuzhouElect", "Chengdu Jiuzhou Electronic Technology Inc" },
    { { 0x00, 0x26, 0x2F }, "HamamatsuToa", "Hamamatsu Toa Electronics" },
    { { 0x00, 0x26, 0x30 }, "AcorelS",      "Acorel S.A.S" },
    { { 0x00, 0x26, 0x31 }, "Commtact",     "Commtact Ltd" },
    { { 0x00, 0x26, 0x32 }, "Instrumentat", "Instrumentation Technologies d.d." },
    { { 0x00, 0x26, 0x33 }, "MIRMedicalIn", "MIR - Medical International Research" },
    { { 0x00, 0x26, 0x34 }, "Infineta",     "Infineta Systems, Inc" },
    { { 0x00, 0x26, 0x35 }, "Bluetechnix",  "Bluetechnix GmbH" },
    { { 0x00, 0x26, 0x36 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x26, 0x37 }, "SamsungElect", "Samsung Electro Mechanics Co., Ltd." },
    { { 0x00, 0x26, 0x38 }, "XiaMenJoyate", "Xia Men Joyatech Co., Ltd." },
    { { 0x00, 0x26, 0x39 }, "TMElectronic", "T.M. Electronics, Inc." },
    { { 0x00, 0x26, 0x3A }, "Digitec",      "Digitec Systems" },
    { { 0x00, 0x26, 0x3B }, "Onbnetech",    "Onbnetech" },
    { { 0x00, 0x26, 0x3C }, "BachmannTech", "Bachmann Technology GmbH & Co. KG" },
    { { 0x00, 0x26, 0x3D }, "MIA",          "MIA Corporation" },
    { { 0x00, 0x26, 0x3E }, "TrapezeNetwo", "Trapeze Networks" },
    { { 0x00, 0x26, 0x3F }, "LIOSTechnolo", "LIOS Technology GmbH" },
    { { 0x00, 0x26, 0x40 }, "BaustemBroad", "Baustem Broadband Technologies, Ltd." },
    { { 0x00, 0x26, 0x41 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x26, 0x42 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x26, 0x43 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x00, 0x26, 0x44 }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x26, 0x45 }, "Circontrol",   "Circontrol S.A." },
    { { 0x00, 0x26, 0x46 }, "ShenyangTong", "Shenyang Tongfang Multimedia Technology Company Limited" },
    { { 0x00, 0x26, 0x47 }, "WfeTechnolog", "Wfe Technology Corp." },
    { { 0x00, 0x26, 0x48 }, "Emitech",      "Emitech Corp." },
    { { 0x00, 0x26, 0x4A }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x26, 0x4C }, "DigiVisionTe", "Shanghai DigiVision Technology Co., Ltd." },
    { { 0x00, 0x26, 0x4D }, "ArcadyanTech", "Arcadyan Technology Corporation" },
    { { 0x00, 0x26, 0x4E }, "r2p",          "r2p GmbH" },
    { { 0x00, 0x26, 0x4F }, "Krüger&Gothe", "Krüger &Gothe GmbH" },
    { { 0x00, 0x26, 0x50 }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0x26, 0x51 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0x52 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0x53 }, "DaySequerra",  "DaySequerra Corporation" },
    { { 0x00, 0x26, 0x54 }, "3Com",         "3Com" },
    { { 0x00, 0x26, 0x55 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x26, 0x56 }, "SansonicElec", "Sansonic Electronics USA" },
    { { 0x00, 0x26, 0x57 }, "OooNppEkra",   "Ooo Npp Ekra" },
    { { 0x00, 0x26, 0x58 }, "TPlatforms",   "T-Platforms (Cyprus) Limited" },
    { { 0x00, 0x26, 0x59 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x26, 0x5A }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x26, 0x5B }, "HitronTechno", "Hitron Technologies. Inc" },
    { { 0x00, 0x26, 0x5C }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x26, 0x5D }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x26, 0x5E }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x26, 0x5F }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x26, 0x60 }, "Logiways",     "Logiways" },
    { { 0x00, 0x26, 0x61 }, "Irumtek",      "Irumtek Co., Ltd." },
    { { 0x00, 0x26, 0x62 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x26, 0x63 }, "HuitaiweiTec", "Shenzhen Huitaiwei Tech. Ltd, co." },
    { { 0x00, 0x26, 0x64 }, "CoreSystemJa", "Core System Japan" },
    { { 0x00, 0x26, 0x65 }, "ProtectedLog", "ProtectedLogic Corporation" },
    { { 0x00, 0x26, 0x66 }, "EFMNetworks",  "EFM Networks" },
    { { 0x00, 0x26, 0x67 }, "Carecom",      "Carecom Co.,Ltd." },
    { { 0x00, 0x26, 0x68 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x26, 0x69 }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x26, 0x6A }, "Essensium",    "Essensium Nv" },
    { { 0x00, 0x26, 0x6B }, "ShineUnionEn", "Shine Union Enterprise Limited" },
    { { 0x00, 0x26, 0x6C }, "Inventec",     "Inventec Corporation" },
    { { 0x00, 0x26, 0x6D }, "MobileAccess", "MobileAccess Networks" },
    { { 0x00, 0x26, 0x6E }, "Nisshodenki",  "Nissho-denki Co.,LTD." },
    { { 0x00, 0x26, 0x6F }, "CoordiwiseTe", "Coordiwise Technology Corp." },
    { { 0x00, 0x26, 0x70 }, "CinchConnect", "Cinch Connectors" },
    { { 0x00, 0x26, 0x71 }, "AUTOVISION",   "AUTOVISION Co., Ltd" },
    { { 0x00, 0x26, 0x72 }, "AAMPAmerica",  "AAMP of America" },
    { { 0x00, 0x26, 0x73 }, "Ricoh",        "Ricoh Company,Ltd." },
    { { 0x00, 0x26, 0x74 }, "HunterDougla", "Hunter Douglas" },
    { { 0x00, 0x26, 0x75 }, "AztechElectr", "Aztech Electronics Pte Ltd" },
    { { 0x00, 0x26, 0x76 }, "COMMidtAS",    "COMMidt AS" },
    { { 0x00, 0x26, 0x77 }, "Deif",         "Deif A/S" },
    { { 0x00, 0x26, 0x78 }, "LogicInstrum", "Logic Instrument SA" },
    { { 0x00, 0x26, 0x79 }, "EuphonicTech", "Euphonic Technologies, Inc." },
    { { 0x00, 0x26, 0x7A }, "hongxintelec", "wuhan hongxin telecommunication technologies co.,ltd" },
    { { 0x00, 0x26, 0x7B }, "GSIHelmholtz", "GSI Helmholtzzentrum für Schwerionenforschung GmbH" },
    { { 0x00, 0x26, 0x7C }, "MetzWerke",    "Metz-Werke GmbH & Co KG" },
    { { 0x00, 0x26, 0x7D }, "AMaxTechnolo", "A-Max Technology Macao Commercial Offshore Company Limited" },
    { { 0x00, 0x26, 0x7E }, "Parrot",       "Parrot Sa" },
    { { 0x00, 0x26, 0x7F }, "OreganNetwor", "Oregan Networks Ltd." },
    { { 0x00, 0x26, 0x80 }, "SIL3",         "SIL3 Pty.Ltd" },
    { { 0x00, 0x26, 0x81 }, "Interspiro",   "Interspiro AB" },
    { { 0x00, 0x26, 0x82 }, "GemtekTechno", "Gemtek Technology Co., Ltd." },
    { { 0x00, 0x26, 0x83 }, "AjohoEnterpr", "Ajoho Enterprise Co., Ltd." },
    { { 0x00, 0x26, 0x84 }, "KisanSystem",  "Kisan System" },
    { { 0x00, 0x26, 0x85 }, "DigitalInnov", "Digital Innovation" },
    { { 0x00, 0x26, 0x86 }, "QuantennaCom", "Quantenna Communcations, Inc." },
    { { 0x00, 0x26, 0x87 }, "corega",       "corega K.K" },
    { { 0x00, 0x26, 0x88 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x26, 0x89 }, "GeneralDynam", "General Dynamics Robotic Systems" },
    { { 0x00, 0x26, 0x8A }, "TerrierSC",    "Terrier SC Ltd" },
    { { 0x00, 0x26, 0x8B }, "GuangzhouEsc", "Guangzhou Escene Computer Technology Limited" },
    { { 0x00, 0x26, 0x8C }, "StarLeaf",     "StarLeaf Ltd." },
    { { 0x00, 0x26, 0x8D }, "CellTel",      "CellTel S.p.A." },
    { { 0x00, 0x26, 0x8E }, "AltaSolution", "Alta Solutions, Inc." },
    { { 0x00, 0x26, 0x8F }, "MTA",          "MTA SpA" },
    { { 0x00, 0x26, 0x90 }, "IDoIt",        "I Do It" },
    { { 0x00, 0x26, 0x91 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x26, 0x92 }, "MitsubishiEl", "Mitsubishi Electric Corporation" },
    { { 0x00, 0x26, 0x93 }, "QVidiumTechn", "QVidium Technologies, Inc." },
    { { 0x00, 0x26, 0x94 }, "Senscient",    "Senscient Ltd" },
    { { 0x00, 0x26, 0x95 }, "ZTGroupIntl",  "ZT Group Int'l Inc" },
    { { 0x00, 0x26, 0x96 }, "NOOLIX",       "NOOLIX Co., Ltd" },
    { { 0x00, 0x26, 0x97 }, "AlphaTechnol", "Alpha Technologies Inc." },
    { { 0x00, 0x26, 0x98 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0x99 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0x9A }, "CarinaSystem", "Carina System Co., Ltd." },
    { { 0x00, 0x26, 0x9B }, "SOKRAT",       "SOKRAT Ltd." },
    { { 0x00, 0x26, 0x9C }, "ItusJapan",    "Itus Japan Co. Ltd" },
    { { 0x00, 0x26, 0x9D }, "M2Mnet",       "M2Mnet Co., Ltd." },
    { { 0x00, 0x26, 0x9E }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x00, 0x26, 0x9F }, "Private",      "Private" },
    { { 0x00, 0x26, 0xA0 }, "moblic",       "moblic" },
    { { 0x00, 0x26, 0xA1 }, "Megger",       "Megger" },
    { { 0x00, 0x26, 0xA2 }, "Instrumentat", "Instrumentation Technology Systems" },
    { { 0x00, 0x26, 0xA3 }, "FQIngenieria", "FQ Ingenieria Electronica S.A." },
    { { 0x00, 0x26, 0xA4 }, "NovusProduto", "Novus Produtos Eletronicos Ltda" },
    { { 0x00, 0x26, 0xA5 }, "Microrobot",   "Microrobot.Co.,Ltd" },
    { { 0x00, 0x26, 0xA6 }, "Trixell",      "Trixell" },
    { { 0x00, 0x26, 0xA7 }, "Connect",      "Connect Srl" },
    { { 0x00, 0x26, 0xA8 }, "DaehapHyperT", "Daehap Hyper-Tech" },
    { { 0x00, 0x26, 0xA9 }, "StrongTechno", "Strong Technologies Pty Ltd" },
    { { 0x00, 0x26, 0xAA }, "KenmecMechan", "Kenmec Mechanical Engineering Co., Ltd." },
    { { 0x00, 0x26, 0xAB }, "SeikoEpson",   "Seiko Epson Corporation" },
    { { 0x00, 0x26, 0xAC }, "LUSTERTeraba", "Shanghai LUSTER Teraband photonic Co., Ltd." },
    { { 0x00, 0x26, 0xAD }, "Arada",        "Arada Systems, Inc." },
    { { 0x00, 0x26, 0xAE }, "WirelessMeas", "Wireless Measurement Ltd" },
    { { 0x00, 0x26, 0xAF }, "Duelco",       "Duelco A/S" },
    { { 0x00, 0x26, 0xB0 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x26, 0xB1 }, "NavisAutoMot", "Navis Auto Motive Systems, Inc." },
    { { 0x00, 0x26, 0xB2 }, "Setrix",       "Setrix GmbH" },
    { { 0x00, 0x26, 0xB3 }, "ThalesCommun", "Thales Communications Inc" },
    { { 0x00, 0x26, 0xB4 }, "FordMotor",    "Ford Motor Company" },
    { { 0x00, 0x26, 0xB5 }, "ICOMMTele",    "ICOMM Tele Ltd" },
    { { 0x00, 0x26, 0xB6 }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x00, 0x26, 0xB7 }, "KingstonTech", "Kingston Technology Company, Inc." },
    { { 0x00, 0x26, 0xB8 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x26, 0xB9 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x26, 0xBA }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x26, 0xBB }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x26, 0xBC }, "GeneralJackT", "General Jack Technology Ltd." },
    { { 0x00, 0x26, 0xBD }, "JTECCardComm", "JTEC Card & Communication Co., Ltd" },
    { { 0x00, 0x26, 0xBE }, "Schoonderbee", "Schoonderbeek Elektronica Systemen B.V." },
    { { 0x00, 0x26, 0xBF }, "TemobiScienc", "ShenZhen Temobi Science&Tech Development Co.,Ltd" },
    { { 0x00, 0x26, 0xC0 }, "EnergyHub",    "EnergyHub" },
    { { 0x00, 0x26, 0xC1 }, "Artray",       "Artray Co., Ltd." },
    { { 0x00, 0x26, 0xC2 }, "SCDI",         "SCDI Co. LTD" },
    { { 0x00, 0x26, 0xC3 }, "Insightek",    "Insightek Corp." },
    { { 0x00, 0x26, 0xC4 }, "Cadmosmicros", "Cadmos microsystems S.r.l." },
    { { 0x00, 0x26, 0xC5 }, "GosunTelecom", "Guangdong Gosun Telecommunications Co.,Ltd" },
    { { 0x00, 0x26, 0xC6 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x26, 0xC7 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x26, 0xC8 }, "SystemSensor", "System Sensor" },
    { { 0x00, 0x26, 0xC9 }, "Proventix",    "Proventix Systems, Inc." },
    { { 0x00, 0x26, 0xCA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0xCB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x26, 0xCC }, "NokiaDanmark", "Nokia Danmark A/S" },
    { { 0x00, 0x26, 0xCD }, "PurpleComm",   "PurpleComm, Inc." },
    { { 0x00, 0x26, 0xCE }, "KozumiUSA",    "Kozumi USA Corp." },
    { { 0x00, 0x26, 0xCF }, "DekaR&D",      "Deka R&D" },
    { { 0x00, 0x26, 0xD0 }, "Semihalf",     "Semihalf" },
    { { 0x00, 0x26, 0xD1 }, "SSquaredInno", "S Squared Innovations Inc." },
    { { 0x00, 0x26, 0xD2 }, "Pcube",        "Pcube Systems, Inc." },
    { { 0x00, 0x26, 0xD3 }, "ZenoInformat", "Zeno Information System" },
    { { 0x00, 0x26, 0xD4 }, "IRCA",         "IRCA SpA" },
    { { 0x00, 0x26, 0xD5 }, "OrySolucoese", "Ory Solucoes em Comercio de Informatica Ltda." },
    { { 0x00, 0x26, 0xD6 }, "NingboAndyOp", "Ningbo Andy Optoelectronic Co., Ltd." },
    { { 0x00, 0x26, 0xD7 }, "KMElectornic", "KM Electornic Technology Co., Ltd." },
    { { 0x00, 0x26, 0xD8 }, "MagicPoint",   "Magic Point Inc." },
    { { 0x00, 0x26, 0xD9 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x26, 0xDA }, "UniversalMed", "Universal Media Corporation /Slovakia/ s.r.o." },
    { { 0x00, 0x26, 0xDB }, "IonicsEMS",    "Ionics EMS Inc." },
    { { 0x00, 0x26, 0xDC }, "OpticalDesig", "Optical Systems Design" },
    { { 0x00, 0x26, 0xDD }, "FivalScience", "Fival Science & Technology Co.,Ltd." },
    { { 0x00, 0x26, 0xDE }, "FdiMatelec",   "Fdi Matelec" },
    { { 0x00, 0x26, 0xDF }, "TaiDocTechno", "TaiDoc Technology Corp." },
    { { 0x00, 0x26, 0xE0 }, "Asiteq",       "Asiteq" },
    { { 0x00, 0x26, 0xE1 }, "StanfordUniv", "Stanford University, OpenFlow Group" },
    { { 0x00, 0x26, 0xE2 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x26, 0xE3 }, "Dti",          "Dti" },
    { { 0x00, 0x26, 0xE4 }, "Canal",        "Canal +" },
    { { 0x00, 0x26, 0xE5 }, "AEGPowerSolu", "AEG Power Solutions" },
    { { 0x00, 0x26, 0xE6 }, "Visionhitech", "Visionhitech Co., Ltd." },
    { { 0x00, 0x26, 0xE7 }, "ONLANCommuni", "Shanghai ONLAN Communication Tech. Co., Ltd." },
    { { 0x00, 0x26, 0xE8 }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0x26, 0xE9 }, "SP",           "SP Corp" },
    { { 0x00, 0x26, 0xEA }, "CheerchipEle", "Cheerchip Electronic Technology (ShangHai) Co., Ltd." },
    { { 0x00, 0x26, 0xEB }, "AdvancedSpec", "Advanced Spectrum Technology Co., Ltd." },
    { { 0x00, 0x26, 0xEC }, "LegrandHome",  "Legrand Home Systems, Inc" },
    { { 0x00, 0x26, 0xED }, "zte",          "zte corporation" },
    { { 0x00, 0x26, 0xEE }, "TKM",          "TKM GmbH" },
    { { 0x00, 0x26, 0xEF }, "TechnologyAd", "Technology Advancement Group, Inc." },
    { { 0x00, 0x26, 0xF0 }, "cTrixsIntern", "cTrixs International GmbH." },
    { { 0x00, 0x26, 0xF1 }, "ProCurveNetw", "ProCurve Networking by HP" },
    { { 0x00, 0x26, 0xF2 }, "Netgear",      "Netgear" },
    { { 0x00, 0x26, 0xF3 }, "SMCNetworks",  "SMC Networks" },
    { { 0x00, 0x26, 0xF4 }, "Nesslab",      "Nesslab" },
    { { 0x00, 0x26, 0xF5 }, "XRPLUS",       "XRPLUS Inc." },
    { { 0x00, 0x26, 0xF6 }, "MilitaryComm", "Military Communication Institute" },
    { { 0x00, 0x26, 0xF7 }, "Nivetti",      "Nivetti Systems Pvt. Ltd." },
    { { 0x00, 0x26, 0xF8 }, "GoldenHighwa", "Golden Highway Industry Development Co., Ltd." },
    { { 0x00, 0x26, 0xF9 }, "SEM",          "S.E.M. srl" },
    { { 0x00, 0x26, 0xFA }, "BandRich",     "BandRich Inc." },
    { { 0x00, 0x26, 0xFB }, "AirDioWirele", "AirDio Wireless, Inc." },
    { { 0x00, 0x26, 0xFC }, "AcSiPTechnol", "AcSiP Technology Corp." },
    { { 0x00, 0x26, 0xFD }, "InteractiveI", "Interactive Intelligence" },
    { { 0x00, 0x26, 0xFE }, "MKDTechnolog", "MKD Technology Inc." },
    { { 0x00, 0x26, 0xFF }, "BlackBerryRT", "BlackBerry RTS" },
    { { 0x00, 0x27, 0x00 }, "SiglentTechn", "Shenzhen Siglent Technology Co., Ltd." },
    { { 0x00, 0x27, 0x01 }, "INCOstartec",  "INCOstartec GmbH" },
    { { 0x00, 0x27, 0x02 }, "SolarEdgeTec", "SolarEdge Technologies" },
    { { 0x00, 0x27, 0x03 }, "TestechElect", "Testech Electronics Pte Ltd" },
    { { 0x00, 0x27, 0x04 }, "AcceleratedC", "Accelerated Concepts, Inc" },
    { { 0x00, 0x27, 0x05 }, "Sectronic",    "Sectronic" },
    { { 0x00, 0x27, 0x06 }, "Yoisys",       "Yoisys" },
    { { 0x00, 0x27, 0x07 }, "LiftComplexD", "Lift Complex DS, JSC" },
    { { 0x00, 0x27, 0x08 }, "NordiagASA",   "Nordiag ASA" },
    { { 0x00, 0x27, 0x09 }, "Nintendo",     "Nintendo Co., Ltd." },
    { { 0x00, 0x27, 0x0A }, "Iee",          "Iee S.A." },
    { { 0x00, 0x27, 0x0B }, "AduraTechnol", "Adura Technologies" },
    { { 0x00, 0x27, 0x0C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x27, 0x0D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x27, 0x0E }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x27, 0x0F }, "Envisionnova", "Envisionnovation Inc" },
    { { 0x00, 0x27, 0x10 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x27, 0x11 }, "LanPro",       "LanPro Inc" },
    { { 0x00, 0x27, 0x12 }, "MaxVision",    "MaxVision LLC" },
    { { 0x00, 0x27, 0x13 }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x00, 0x27, 0x14 }, "Grainmustard", "Grainmustards, Co,ltd." },
    { { 0x00, 0x27, 0x15 }, "ReboundTelec", "Rebound Telecom. Co., Ltd" },
    { { 0x00, 0x27, 0x16 }, "AdachiSyokai", "Adachi-Syokai Co., Ltd." },
    { { 0x00, 0x27, 0x17 }, "CEDigitalCo",  "CE Digital(Zhenjiang)Co.,Ltd" },
    { { 0x00, 0x27, 0x18 }, "SuzhouNEWSEA", "Suzhou NEW SEAUNION Video Technology Co.,Ltd" },
    { { 0x00, 0x27, 0x19 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x00, 0x27, 0x1A }, "GeenovoTechn", "Geenovo Technology Ltd." },
    { { 0x00, 0x27, 0x1B }, "AlecSicherhe", "Alec Sicherheitssysteme GmbH" },
    { { 0x00, 0x27, 0x1C }, "Mercury",      "Mercury Corporation" },
    { { 0x00, 0x27, 0x1D }, "CombaTelecom", "Comba Telecom Systems (China) Ltd." },
    { { 0x00, 0x27, 0x1E }, "XagylCommuni", "Xagyl Communications" },
    { { 0x00, 0x27, 0x1F }, "MIPROElectro", "MIPRO Electronics Co., Ltd" },
    { { 0x00, 0x27, 0x20 }, "NewSolCom",    "New-Sol Com" },
    { { 0x00, 0x27, 0x21 }, "BaoanFendaIn", "Shenzhen Baoan Fenda Industrial Co., Ltd" },
    { { 0x00, 0x27, 0x22 }, "Ubiquiti",     "Ubiquiti Inc" },
    { { 0x00, 0x27, 0x90 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x27, 0xE3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x27, 0xF8 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x28, 0x9F }, "Semptian",     "Semptian Co., Ltd." },
    { { 0x00, 0x28, 0xF8 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x29, 0x26 }, "AppliedOptoe", "Applied Optoelectronics, Inc Taiwan Branch" },
    { { 0x00, 0x29, 0xC2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x2A, 0x10 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x2A, 0x6A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x2A, 0xAF }, "LARsysAutoma", "LARsys-Automation GmbH" },
    { { 0x00, 0x2B, 0x67 }, "LCFCElectron", "LCFC(Hefei) Electronics Technology co., ltd" },
    { { 0x00, 0x2B, 0x70 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x2B, 0xF5 }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0x2C, 0xC8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x2D, 0x76 }, "TITECH",       "TITECH GmbH" },
    { { 0x00, 0x2D, 0xB3 }, "AMPAKTechnol", "AMPAK Technology,Inc." },
    { { 0x00, 0x2E, 0xC7 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x2F, 0x5C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x2F, 0xD9 }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x00, 0x30, 0x00 }, "AllwellTechn", "Allwell Technology Corp." },
    { { 0x00, 0x30, 0x01 }, "Smp",          "Smp" },
    { { 0x00, 0x30, 0x02 }, "ExpandNetwor", "Expand Networks" },
    { { 0x00, 0x30, 0x03 }, "Phasys",       "Phasys Ltd." },
    { { 0x00, 0x30, 0x04 }, "LeadtekResea", "Leadtek Research Inc." },
    { { 0x00, 0x30, 0x05 }, "FujitsuSieme", "Fujitsu Siemens Computers" },
    { { 0x00, 0x30, 0x06 }, "SuperpowerCo", "Superpower Computer" },
    { { 0x00, 0x30, 0x07 }, "Opti",         "Opti, Inc." },
    { { 0x00, 0x30, 0x08 }, "AvioDigital",  "Avio Digital, Inc." },
    { { 0x00, 0x30, 0x09 }, "TachionNetwo", "Tachion Networks, Inc." },
    { { 0x00, 0x30, 0x0A }, "AztechElectr", "Aztech Electronics Pte Ltd" },
    { { 0x00, 0x30, 0x0B }, "mPHASETechno", "mPHASE Technologies, Inc." },
    { { 0x00, 0x30, 0x0C }, "Congruency",   "Congruency, Ltd." },
    { { 0x00, 0x30, 0x0D }, "MMCTechnolog", "MMC Technology, Inc." },
    { { 0x00, 0x30, 0x0E }, "KlotzDigital", "Klotz Digital AG" },
    { { 0x00, 0x30, 0x0F }, "IMTInformati", "IMT - Information Management T" },
    { { 0x00, 0x30, 0x10 }, "VisioneticsI", "Visionetics International" },
    { { 0x00, 0x30, 0x11 }, "HMSIndustria", "HMS Industrial Networks" },
    { { 0x00, 0x30, 0x12 }, "DigitalEngin", "Digital Engineering Ltd." },
    { { 0x00, 0x30, 0x13 }, "NEC",          "NEC Corporation" },
    { { 0x00, 0x30, 0x14 }, "Divio",        "Divio, Inc." },
    { { 0x00, 0x30, 0x15 }, "CpClare",      "Cp Clare Corp." },
    { { 0x00, 0x30, 0x16 }, "Ishida",       "Ishida Co., Ltd." },
    { { 0x00, 0x30, 0x17 }, "BlueArcUK",    "BlueArc UK Ltd" },
    { { 0x00, 0x30, 0x18 }, "JetwayInform", "Jetway Information Co., Ltd." },
    { { 0x00, 0x30, 0x19 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x1A }, "Smartbridges", "Smartbridges Pte. Ltd." },
    { { 0x00, 0x30, 0x1B }, "Shuttle",      "Shuttle, Inc." },
    { { 0x00, 0x30, 0x1C }, "AltvaterAird", "Altvater Airdata Systems" },
    { { 0x00, 0x30, 0x1D }, "Skystream",    "Skystream, Inc." },
    { { 0x00, 0x30, 0x1E }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x30, 0x1F }, "OpticalNetwo", "Optical Networks, Inc." },
    { { 0x00, 0x30, 0x20 }, "TSI",          "TSI, Inc.." },
    { { 0x00, 0x30, 0x21 }, "HsingTechEnt", "Hsing Tech. Enterprise Co.,Ltd" },
    { { 0x00, 0x30, 0x22 }, "FongKaiIndus", "Fong Kai Industrial Co., Ltd." },
    { { 0x00, 0x30, 0x23 }, "CogentComput", "Cogent Computer Systems, Inc." },
    { { 0x00, 0x30, 0x24 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x25 }, "CheckoutComp", "Checkout Computer Systems, Ltd" },
    { { 0x00, 0x30, 0x26 }, "HeiTelDigita", "HeiTel Digital Video GmbH" },
    { { 0x00, 0x30, 0x27 }, "Kerbango",     "Kerbango, Inc." },
    { { 0x00, 0x30, 0x28 }, "FASESaldatur", "FASE Saldatura srl" },
    { { 0x00, 0x30, 0x29 }, "Opicom",       "Opicom" },
    { { 0x00, 0x30, 0x2A }, "SouthernInfo", "Southern Information" },
    { { 0x00, 0x30, 0x2B }, "InalpSolutio", "Inalp Solutions AG" },
    { { 0x00, 0x30, 0x2C }, "Sylantro",     "Sylantro Systems Corporation" },
    { { 0x00, 0x30, 0x2D }, "QuantumBridg", "Quantum Bridge Communications" },
    { { 0x00, 0x30, 0x2E }, "HoftWessel",   "Hoft & Wessel AG" },
    { { 0x00, 0x30, 0x2F }, "GEAviationSy", "GE Aviation System" },
    { { 0x00, 0x30, 0x30 }, "Harmonix",     "Harmonix Corporation" },
    { { 0x00, 0x30, 0x31 }, "LightwaveCom", "Lightwave Communications, Inc." },
    { { 0x00, 0x30, 0x32 }, "MagicRam",     "MagicRam, Inc." },
    { { 0x00, 0x30, 0x33 }, "OrientTeleco", "Orient Telecom Co., Ltd." },
    { { 0x00, 0x30, 0x34 }, "SetEngineeri", "Set Engineering" },
    { { 0x00, 0x30, 0x35 }, "Corning",      "Corning Incorporated" },
    { { 0x00, 0x30, 0x36 }, "RmpElektroni", "Rmp Elektroniksysteme Gmbh" },
    { { 0x00, 0x30, 0x37 }, "PackardBellN", "Packard Bell Nec Services" },
    { { 0x00, 0x30, 0x38 }, "Xcp",          "Xcp, Inc." },
    { { 0x00, 0x30, 0x39 }, "SoftbookPres", "Softbook Press" },
    { { 0x00, 0x30, 0x3A }, "Maatel",       "Maatel" },
    { { 0x00, 0x30, 0x3B }, "PowerComTech", "PowerCom Technology" },
    { { 0x00, 0x30, 0x3C }, "Onnto",        "Onnto Corp." },
    { { 0x00, 0x30, 0x3D }, "Iva",          "Iva Corporation" },
    { { 0x00, 0x30, 0x3E }, "Radcom",       "Radcom Ltd." },
    { { 0x00, 0x30, 0x3F }, "TurboCommTec", "TurboComm Tech Inc." },
    { { 0x00, 0x30, 0x40 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x41 }, "SaejinTM",     "Saejin T & M Co., Ltd." },
    { { 0x00, 0x30, 0x42 }, "DeTeWeDeutsc", "DeTeWe-Deutsche Telephonwerke" },
    { { 0x00, 0x30, 0x43 }, "IdreamTechno", "Idream Technologies, Pte. Ltd." },
    { { 0x00, 0x30, 0x44 }, "CradlePoint",  "CradlePoint, Inc" },
    { { 0x00, 0x30, 0x45 }, "VillageNetwo", "Village Networks, Inc. (VNI)" },
    { { 0x00, 0x30, 0x46 }, "ControlledEl", "Controlled Electronic Manageme" },
    { { 0x00, 0x30, 0x47 }, "NisseiElectr", "Nissei Electric Co., Ltd." },
    { { 0x00, 0x30, 0x48 }, "SuperMicroCo", "Super Micro Computer, Inc." },
    { { 0x00, 0x30, 0x49 }, "BryantTechno", "Bryant Technology, Ltd." },
    { { 0x00, 0x30, 0x4A }, "FraunhoferIP", "Fraunhofer IPMS" },
    { { 0x00, 0x30, 0x4B }, "Orbacom",      "Orbacom Systems, Inc." },
    { { 0x00, 0x30, 0x4C }, "AppianCommun", "Appian Communications, Inc." },
    { { 0x00, 0x30, 0x4D }, "Esi",          "Esi" },
    { { 0x00, 0x30, 0x4E }, "BustecProduc", "Bustec Production Ltd." },
    { { 0x00, 0x30, 0x4F }, "PLANETTechno", "PLANET Technology Corporation" },
    { { 0x00, 0x30, 0x50 }, "VersaTechnol", "Versa Technology" },
    { { 0x00, 0x30, 0x51 }, "OrbitAvionic", "Orbit Avionic & Communication" },
    { { 0x00, 0x30, 0x52 }, "DZS",          "DZS Inc." },
    { { 0x00, 0x30, 0x53 }, "Basler",       "Basler AG" },
    { { 0x00, 0x30, 0x54 }, "CastlenetTec", "Castlenet Technology Inc." },
    { { 0x00, 0x30, 0x55 }, "RenesasTechn", "Renesas Technology America, Inc." },
    { { 0x00, 0x30, 0x56 }, "HMSIndustria", "HMS Industrial Networks" },
    { { 0x00, 0x30, 0x57 }, "QTelNet",      "QTelNet, Inc." },
    { { 0x00, 0x30, 0x58 }, "ApiMotion",    "Api Motion" },
    { { 0x00, 0x30, 0x59 }, "KontronEurop", "Kontron Europe GmbH" },
    { { 0x00, 0x30, 0x5A }, "Telgen",       "Telgen Corporation" },
    { { 0x00, 0x30, 0x5B }, "Toko",         "Toko Inc." },
    { { 0x00, 0x30, 0x5C }, "SMARLaborato", "SMAR Laboratories Corp." },
    { { 0x00, 0x30, 0x5D }, "Digitra",      "Digitra Systems, Inc." },
    { { 0x00, 0x30, 0x5E }, "AbelkoInnova", "Abelko Innovation" },
    { { 0x00, 0x30, 0x5F }, "Hasselblad",   "Hasselblad" },
    { { 0x00, 0x30, 0x60 }, "Powerfile",    "Powerfile, Inc." },
    { { 0x00, 0x30, 0x61 }, "MobyTEL",      "MobyTEL" },
    { { 0x00, 0x30, 0x62 }, "IPVideoNetwo", "IP Video Networks Inc" },
    { { 0x00, 0x30, 0x63 }, "Santera",      "Santera Systems, Inc." },
    { { 0x00, 0x30, 0x64 }, "AdlinkTechno", "Adlink Technology, Inc." },
    { { 0x00, 0x30, 0x65 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x30, 0x66 }, "Rfm",          "Rfm" },
    { { 0x00, 0x30, 0x67 }, "BIOSTARMicro", "BIOSTAR Microtech Int'l Corp." },
    { { 0x00, 0x30, 0x68 }, "CyberneticsT", "Cybernetics Tech. Co., Ltd." },
    { { 0x00, 0x30, 0x69 }, "ImpacctTechn", "Impacct Technology Corp." },
    { { 0x00, 0x30, 0x6A }, "PentaMedia",   "Penta Media Co., Ltd." },
    { { 0x00, 0x30, 0x6B }, "Cmos",         "Cmos Systems, Inc." },
    { { 0x00, 0x30, 0x6C }, "Hitex",        "Hitex Holding GmbH" },
    { { 0x00, 0x30, 0x6D }, "LucentTechno", "Lucent Technologies" },
    { { 0x00, 0x30, 0x6E }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x30, 0x6F }, "SeyeonTech",   "Seyeon Tech. Co., Ltd." },
    { { 0x00, 0x30, 0x70 }, "1Net",         "1Net Corporation" },
    { { 0x00, 0x30, 0x71 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x72 }, "Intellibyte",  "Intellibyte Inc." },
    { { 0x00, 0x30, 0x73 }, "Internationa", "International Microsystems, In" },
    { { 0x00, 0x30, 0x74 }, "Equiinet",     "Equiinet Ltd." },
    { { 0x00, 0x30, 0x75 }, "Adtech",       "Adtech" },
    { { 0x00, 0x30, 0x76 }, "Akamba",       "Akamba Corporation" },
    { { 0x00, 0x30, 0x77 }, "OnpremNetwor", "Onprem Networks" },
    { { 0x00, 0x30, 0x78 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x79 }, "Cqos",         "Cqos, Inc." },
    { { 0x00, 0x30, 0x7A }, "AdvancedTech", "Advanced Technology & Systems" },
    { { 0x00, 0x30, 0x7B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x7C }, "Adid",         "Adid Sa" },
    { { 0x00, 0x30, 0x7D }, "GreAmerica",   "Gre America, Inc." },
    { { 0x00, 0x30, 0x7E }, "RedflexCommu", "Redflex Communication Systems" },
    { { 0x00, 0x30, 0x7F }, "Irlan",        "Irlan Ltd." },
    { { 0x00, 0x30, 0x80 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x81 }, "AltosC&C",     "Altos C&C" },
    { { 0x00, 0x30, 0x82 }, "TaihanElectr", "Taihan Electric Wire Co., Ltd." },
    { { 0x00, 0x30, 0x83 }, "Ivron",        "Ivron Systems" },
    { { 0x00, 0x30, 0x84 }, "AlliedTelesy", "Allied Telesyn Internaional" },
    { { 0x00, 0x30, 0x85 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x86 }, "TransistorDe", "Transistor Devices, Inc." },
    { { 0x00, 0x30, 0x87 }, "VegaGrieshab", "Vega Grieshaber Kg" },
    { { 0x00, 0x30, 0x88 }, "Ericsson",     "Ericsson" },
    { { 0x00, 0x30, 0x89 }, "Spectrapoint", "Spectrapoint Wireless, LLC" },
    { { 0x00, 0x30, 0x8A }, "NicotraSiste", "Nicotra Sistemi S.P.A" },
    { { 0x00, 0x30, 0x8B }, "BrixNetworks", "Brix Networks" },
    { { 0x00, 0x30, 0x8C }, "Quantum",      "Quantum Corporation" },
    { { 0x00, 0x30, 0x8D }, "Pinnacle",     "Pinnacle Systems, Inc." },
    { { 0x00, 0x30, 0x8E }, "CrossmatchTe", "Crossmatch Technologies/HID Global" },
    { { 0x00, 0x30, 0x8F }, "MICRILOR",     "MICRILOR, Inc." },
    { { 0x00, 0x30, 0x90 }, "CyraTechnolo", "Cyra Technologies, Inc." },
    { { 0x00, 0x30, 0x91 }, "TaiwanFirstL", "Taiwan First Line Elec. Corp." },
    { { 0x00, 0x30, 0x92 }, "KontronElect", "Kontron Electronics AG" },
    { { 0x00, 0x30, 0x93 }, "SonnetTechno", "Sonnet Technologies, Inc" },
    { { 0x00, 0x30, 0x94 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x95 }, "ProcompInfor", "Procomp Informatics, Ltd." },
    { { 0x00, 0x30, 0x96 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0x97 }, "ABRegin",      "AB Regin" },
    { { 0x00, 0x30, 0x98 }, "GlobalConver", "Global Converging Technologies" },
    { { 0x00, 0x30, 0x99 }, "BoenigUndKal", "Boenig Und Kallenbach Ohg" },
    { { 0x00, 0x30, 0x9A }, "AstroTerra",   "Astro Terra Corp." },
    { { 0x00, 0x30, 0x9B }, "Smartware",    "Smartware" },
    { { 0x00, 0x30, 0x9C }, "TimingApplic", "Timing Applications, Inc." },
    { { 0x00, 0x30, 0x9D }, "NimbleMicros", "Nimble Microsystems, Inc." },
    { { 0x00, 0x30, 0x9E }, "Workbit",      "Workbit Corporation." },
    { { 0x00, 0x30, 0x9F }, "AmberNetwork", "Amber Networks" },
    { { 0x00, 0x30, 0xA0 }, "TycoSubmarin", "Tyco Submarine Systems, Ltd." },
    { { 0x00, 0x30, 0xA1 }, "WEBGATE",      "WEBGATE Inc." },
    { { 0x00, 0x30, 0xA2 }, "LightnerEngi", "Lightner Engineering" },
    { { 0x00, 0x30, 0xA3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0xA4 }, "WoodwindComm", "Woodwind Communications System" },
    { { 0x00, 0x30, 0xA5 }, "ActivePower",  "Active Power" },
    { { 0x00, 0x30, 0xA6 }, "VianetTechno", "Vianet Technologies, Ltd." },
    { { 0x00, 0x30, 0xA7 }, "SchweitzerEn", "Schweitzer Engineering" },
    { { 0x00, 0x30, 0xA8 }, "OlECommunica", "Ol'E Communications, Inc." },
    { { 0x00, 0x30, 0xA9 }, "Netiverse",    "Netiverse, Inc." },
    { { 0x00, 0x30, 0xAA }, "AxusMicrosys", "Axus Microsystems, Inc." },
    { { 0x00, 0x30, 0xAB }, "DeltaNetwork", "Delta Networks, Inc." },
    { { 0x00, 0x30, 0xAC }, "SystemeLauer", "Systeme Lauer GmbH & Co., Ltd." },
    { { 0x00, 0x30, 0xAD }, "Communicatio", "Shanghai Communication" },
    { { 0x00, 0x30, 0xAE }, "TimesNSystem", "Times N System, Inc." },
    { { 0x00, 0x30, 0xAF }, "Honeywell",    "Honeywell GmbH" },
    { { 0x00, 0x30, 0xB0 }, "ConvergenetT", "Convergenet Technologies" },
    { { 0x00, 0x30, 0xB1 }, "TrunkNet",     "TrunkNet" },
    { { 0x00, 0x30, 0xB2 }, "L3SonomaEO",   "L-3 Sonoma EO" },
    { { 0x00, 0x30, 0xB3 }, "SanValley",    "San Valley Systems, Inc." },
    { { 0x00, 0x30, 0xB4 }, "Intersil",     "Intersil Corp." },
    { { 0x00, 0x30, 0xB5 }, "TadiranMicro", "Tadiran Microwave Networks" },
    { { 0x00, 0x30, 0xB6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0xB7 }, "Teletrol",     "Teletrol Systems, Inc." },
    { { 0x00, 0x30, 0xB8 }, "RiverDeltaNe", "RiverDelta Networks" },
    { { 0x00, 0x30, 0xB9 }, "Ectel",        "Ectel" },
    { { 0x00, 0x30, 0xBA }, "Ac&TSystem",   "Ac&T System Co., Ltd." },
    { { 0x00, 0x30, 0xBB }, "CacheFlow",    "CacheFlow, Inc." },
    { { 0x00, 0x30, 0xBC }, "Optronic",     "Optronic AG" },
    { { 0x00, 0x30, 0xBD }, "BelkinCompon", "Belkin Components" },
    { { 0x00, 0x30, 0xBE }, "CityNetTechn", "City-Net Technology, Inc." },
    { { 0x00, 0x30, 0xBF }, "Multidata",    "Multidata Gmbh" },
    { { 0x00, 0x30, 0xC0 }, "LaraTechnolo", "Lara Technology, Inc." },
    { { 0x00, 0x30, 0xC1 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x30, 0xC2 }, "Comone",       "Comone" },
    { { 0x00, 0x30, 0xC3 }, "FlueckigerEl", "Flueckiger Elektronik Ag" },
    { { 0x00, 0x30, 0xC4 }, "CanonImaging", "Canon Imaging Systems Inc." },
    { { 0x00, 0x30, 0xC5 }, "CadenceDesig", "Cadence Design Systems, Inc." },
    { { 0x00, 0x30, 0xC6 }, "ControlSolut", "Control Solutions, Inc." },
    { { 0x00, 0x30, 0xC7 }, "Macromate",    "Macromate Corp." },
    { { 0x00, 0x30, 0xC8 }, "GadLine",      "Gad Line, Ltd." },
    { { 0x00, 0x30, 0xC9 }, "LuxNN",        "LuxN, N" },
    { { 0x00, 0x30, 0xCA }, "DiscoveryCom", "Discovery Com" },
    { { 0x00, 0x30, 0xCB }, "OmniFlowComp", "Omni Flow Computers, Inc." },
    { { 0x00, 0x30, 0xCC }, "TenorNetwork", "Tenor Networks, Inc." },
    { { 0x00, 0x30, 0xCD }, "Conexant",     "Conexant Systems, Inc." },
    { { 0x00, 0x30, 0xCE }, "Zaffire",      "Zaffire" },
    { { 0x00, 0x30, 0xCF }, "TwoTechnolog", "Two Technologies, Inc." },
    { { 0x00, 0x30, 0xD0 }, "Tellabs",      "Tellabs" },
    { { 0x00, 0x30, 0xD1 }, "Inova",        "Inova Corporation" },
    { { 0x00, 0x30, 0xD2 }, "WinTechnolog", "Win Technologies, Co., Ltd." },
    { { 0x00, 0x30, 0xD3 }, "AgilentTechn", "Agilent Technologies, Inc." },
    { { 0x00, 0x30, 0xD4 }, "AAE",          "AAE Systems, Inc." },
    { { 0x00, 0x30, 0xD5 }, "DResearch",    "DResearch GmbH" },
    { { 0x00, 0x30, 0xD6 }, "MscVertriebs", "Msc Vertriebs Gmbh" },
    { { 0x00, 0x30, 0xD7 }, "InnovativeLL", "Innovative Systems, L.L.C." },
    { { 0x00, 0x30, 0xD8 }, "Sitek",        "Sitek" },
    { { 0x00, 0x30, 0xD9 }, "DatacoreSoft", "Datacore Software Corp." },
    { { 0x00, 0x30, 0xDA }, "Comtrend",     "Comtrend Corporation" },
    { { 0x00, 0x30, 0xDB }, "MindreadySol", "Mindready Solutions, Inc." },
    { { 0x00, 0x30, 0xDC }, "Rightech",     "Rightech Corporation" },
    { { 0x00, 0x30, 0xDD }, "Indigita",     "Indigita Corporation" },
    { { 0x00, 0x30, 0xDE }, "WAGOKontaktt", "WAGO Kontakttechnik GmbH" },
    { { 0x00, 0x30, 0xDF }, "KbTelTelecom", "Kb/Tel Telecomunicaciones" },
    { { 0x00, 0x30, 0xE0 }, "OxfordSemico", "Oxford Semiconductor Ltd." },
    { { 0x00, 0x30, 0xE1 }, "NetworkEquip", "Network Equipment Technologies, Inc." },
    { { 0x00, 0x30, 0xE2 }, "Garnet",       "Garnet Systems Co., Ltd." },
    { { 0x00, 0x30, 0xE3 }, "SedonaNetwor", "Sedona Networks Corp." },
    { { 0x00, 0x30, 0xE4 }, "ChiyodaSyste", "Chiyoda System Riken" },
    { { 0x00, 0x30, 0xE5 }, "AmperDatos",   "Amper Datos S.A." },
    { { 0x00, 0x30, 0xE6 }, "DraegerMedic", "Draeger Medical Systems, Inc." },
    { { 0x00, 0x30, 0xE7 }, "CnfMobileSol", "Cnf Mobile Solutions, Inc." },
    { { 0x00, 0x30, 0xE8 }, "Ensim",        "Ensim Corp." },
    { { 0x00, 0x30, 0xE9 }, "GmaCommunica", "Gma Communication Manufact'G" },
    { { 0x00, 0x30, 0xEA }, "TeraForceTec", "TeraForce Technology Corporation" },
    { { 0x00, 0x30, 0xEB }, "TurbonetComm", "Turbonet Communications, Inc." },
    { { 0x00, 0x30, 0xEC }, "Borgardt",     "Borgardt" },
    { { 0x00, 0x30, 0xED }, "ExpertMagnet", "Expert Magnetics Corp." },
    { { 0x00, 0x30, 0xEE }, "DSGTechnolog", "DSG Technology, Inc." },
    { { 0x00, 0x30, 0xEF }, "NeonTechnolo", "Neon Technology, Inc." },
    { { 0x00, 0x30, 0xF0 }, "UniformIndus", "Uniform Industrial Corp." },
    { { 0x00, 0x30, 0xF1 }, "AcctonTechno", "Accton Technology Corp" },
    { { 0x00, 0x30, 0xF2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x30, 0xF3 }, "AtWorkComput", "At Work Computers" },
    { { 0x00, 0x30, 0xF4 }, "StardotTechn", "Stardot Technologies" },
    { { 0x00, 0x30, 0xF5 }, "WildLab",      "Wild Lab. Ltd." },
    { { 0x00, 0x30, 0xF6 }, "Securelogix",  "Securelogix Corporation" },
    { { 0x00, 0x30, 0xF7 }, "Ramix",        "Ramix Inc." },
    { { 0x00, 0x30, 0xF8 }, "Dynapro",      "Dynapro Systems, Inc." },
    { { 0x00, 0x30, 0xF9 }, "Sollae",       "Sollae Systems Co., Ltd." },
    { { 0x00, 0x30, 0xFA }, "Telica",       "Telica, Inc." },
    { { 0x00, 0x30, 0xFB }, "AZSTechnolog", "AZS Technology AG" },
    { { 0x00, 0x30, 0xFC }, "TerawaveComm", "Terawave Communications, Inc." },
    { { 0x00, 0x30, 0xFD }, "IntegratedDe", "Integrated Systems Design" },
    { { 0x00, 0x30, 0xFE }, "DSA",          "DSA GmbH" },
    { { 0x00, 0x30, 0xFF }, "DataFab",      "DataFab Systems Inc." },
    { { 0x00, 0x31, 0x26 }, "Nokia",        "Nokia" },
    { { 0x00, 0x31, 0x46 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x31, 0x92 }, "TPLink",       "TP-Link Corporation Limited" },
    { { 0x00, 0x32, 0x17 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x32, 0x3A }, "sologic",      "so-logic" },
    { { 0x00, 0x33, 0x58 }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0x33, 0x6C }, "SynapSense",   "SynapSense Corporation" },
    { { 0x00, 0x34, 0xA1 }, "RfLambdaUsa",  "Rf-Lambda Usa Inc." },
    { { 0x00, 0x34, 0xDA }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x34, 0xF1 }, "RadicomResea", "Radicom Research, Inc." },
    { { 0x00, 0x34, 0xFE }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x35, 0x1A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x35, 0x32 }, "ElectroMetri", "Electro-Metrics Corporation" },
    { { 0x00, 0x35, 0x60 }, "RosenAviatio", "Rosen Aviation" },
    { { 0x00, 0x35, 0xFF }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x36, 0x76 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x36, 0xBE }, "NorthwestTow", "Northwest Towers" },
    { { 0x00, 0x36, 0xD7 }, "KeltronIOT",   "Keltron IOT Corp." },
    { { 0x00, 0x36, 0xF8 }, "ContiTemicmi", "Conti Temic microelectronic GmbH" },
    { { 0x00, 0x36, 0xFE }, "SuperVision",  "SuperVision" },
    { { 0x00, 0x37, 0x6D }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0x37, 0xB7 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x38, 0xDF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x39, 0x69 }, "AirWeigh",     "Air-Weigh Incorporated" },
    { { 0x00, 0x3A, 0x7D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x3A, 0x98 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x3A, 0x99 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x3A, 0x9A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x3A, 0x9B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x3A, 0x9C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x3A, 0x9D }, "NECPlatforms", "NEC Platforms, Ltd." },
    { { 0x00, 0x3A, 0xAF }, "BlueBit",      "BlueBit Ltd." },
    { { 0x00, 0x3C, 0x10 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x3C, 0x84 }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x00, 0x3C, 0xC5 }, "WONWOOEngine", "WONWOO Engineering Co., Ltd" },
    { { 0x00, 0x3D, 0x41 }, "HattelandCom", "Hatteland Computer AS" },
    { { 0x00, 0x3D, 0xE1 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0x3D, 0xE8 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x3E, 0x73 }, "Mist",         "Mist Systems, Inc." },
    { { 0x00, 0x3E, 0xE1 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x3F, 0x10 }, "GainStrongTe", "Shenzhen GainStrong Technology Co., Ltd." },
    { { 0x00, 0x40, 0x00 }, "PciComponent", "Pci Componentes Da Amzonia Ltd" },
    { { 0x00, 0x40, 0x01 }, "ZeroOneTechn", "Zero One Technology Co. Ltd." },
    { { 0x00, 0x40, 0x02 }, "Perle",        "Perle Systems Limited" },
    { { 0x00, 0x40, 0x03 }, "EmersonProce", "Emerson Process Management Power & Water Solutions, Inc." },
    { { 0x00, 0x40, 0x04 }, "Icm",          "Icm Co. Ltd." },
    { { 0x00, 0x40, 0x05 }, "AniCommunica", "Ani Communications Inc." },
    { { 0x00, 0x40, 0x06 }, "SampoTechnol", "Sampo Technology Corporation" },
    { { 0x00, 0x40, 0x07 }, "TelmatInform", "Telmat Informatique" },
    { { 0x00, 0x40, 0x08 }, "APlusInfo",    "A Plus Info Corporation" },
    { { 0x00, 0x40, 0x09 }, "TachibanaTec", "Tachibana Tectron Co., Ltd." },
    { { 0x00, 0x40, 0x0A }, "PivotalTechn", "Pivotal Technologies, Inc." },
    { { 0x00, 0x40, 0x0B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x40, 0x0C }, "GeneralMicro", "General Micro Systems, Inc." },
    { { 0x00, 0x40, 0x0D }, "LannetDataCo", "Lannet Data Communications,Ltd" },
    { { 0x00, 0x40, 0x0E }, "Memotec",      "Memotec, Inc." },
    { { 0x00, 0x40, 0x0F }, "DatacomTechn", "Datacom Technologies" },
    { { 0x00, 0x40, 0x10 }, "Sonic",        "Sonic Systems, Inc." },
    { { 0x00, 0x40, 0x11 }, "AndoverContr", "Andover Controls Corporation" },
    { { 0x00, 0x40, 0x12 }, "Windata",      "Windata, Inc." },
    { { 0x00, 0x40, 0x13 }, "NttDataComm",  "Ntt Data Comm. Systems Corp." },
    { { 0x00, 0x40, 0x14 }, "Comsoft",      "Comsoft Gmbh" },
    { { 0x00, 0x40, 0x15 }, "AscomInfrasy", "Ascom Infrasys Ag" },
    { { 0x00, 0x40, 0x16 }, "ADCGlobalCon", "ADC - Global Connectivity Solutions Division" },
    { { 0x00, 0x40, 0x17 }, "SilexTechnol", "Silex Technology America" },
    { { 0x00, 0x40, 0x18 }, "Adobe",        "Adobe Systems, Inc." },
    { { 0x00, 0x40, 0x19 }, "Aeon",         "Aeon Systems, Inc." },
    { { 0x00, 0x40, 0x1A }, "FujiElectric", "Fuji Electric Co., Ltd." },
    { { 0x00, 0x40, 0x1B }, "Printer",      "Printer Systems Corp." },
    { { 0x00, 0x40, 0x1C }, "AstResearch",  "Ast Research, Inc." },
    { { 0x00, 0x40, 0x1D }, "InvisibleSof", "Invisible Software, Inc." },
    { { 0x00, 0x40, 0x1E }, "Icc",          "Icc" },
    { { 0x00, 0x40, 0x1F }, "Colorgraph",   "Colorgraph Ltd" },
    { { 0x00, 0x40, 0x20 }, "CommScope",    "CommScope Inc" },
    { { 0x00, 0x40, 0x21 }, "RasterGraphi", "Raster Graphics" },
    { { 0x00, 0x40, 0x22 }, "KleverComput", "Klever Computers, Inc." },
    { { 0x00, 0x40, 0x23 }, "Logic",        "Logic Corporation" },
    { { 0x00, 0x40, 0x24 }, "Compac",       "Compac Inc." },
    { { 0x00, 0x40, 0x25 }, "MolecularDyn", "Molecular Dynamics" },
    { { 0x00, 0x40, 0x26 }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0x40, 0x27 }, "SmcMassachus", "Smc Massachusetts, Inc." },
    { { 0x00, 0x40, 0x28 }, "Netcomm",      "Netcomm Limited" },
    { { 0x00, 0x40, 0x29 }, "Compex",       "Compex" },
    { { 0x00, 0x40, 0x2A }, "CanogaPerkin", "Canoga Perkins Corporation" },
    { { 0x00, 0x40, 0x2B }, "TrigemComput", "Trigem Computer, Inc." },
    { { 0x00, 0x40, 0x2C }, "IsisDistribu", "Isis Distributed Systems, Inc." },
    { { 0x00, 0x40, 0x2D }, "HarrisAdacom", "Harris Adacom Corporation" },
    { { 0x00, 0x40, 0x2E }, "PrecisionSof", "Precision Software, Inc." },
    { { 0x00, 0x40, 0x2F }, "XlntDesigns",  "Xlnt Designs Inc." },
    { { 0x00, 0x40, 0x30 }, "GkComputer",   "Gk Computer" },
    { { 0x00, 0x40, 0x31 }, "KokusaiElect", "Kokusai Electric Co., Ltd" },
    { { 0x00, 0x40, 0x32 }, "DigitalCommu", "Digital Communications" },
    { { 0x00, 0x40, 0x33 }, "AddtronTechn", "Addtron Technology Co., Ltd." },
    { { 0x00, 0x40, 0x34 }, "Bustek",       "Bustek Corporation" },
    { { 0x00, 0x40, 0x35 }, "Opcom",        "Opcom" },
    { { 0x00, 0x40, 0x36 }, "Minim",        "Minim Inc." },
    { { 0x00, 0x40, 0x37 }, "SeaIlan",      "Sea-Ilan, Inc." },
    { { 0x00, 0x40, 0x38 }, "TalentElectr", "Talent Electric Incorporated" },
    { { 0x00, 0x40, 0x39 }, "OptecDaiichi", "Optec Daiichi Denko Co., Ltd." },
    { { 0x00, 0x40, 0x3A }, "ImpactTechno", "Impact Technologies" },
    { { 0x00, 0x40, 0x3B }, "SynerjetInte", "Synerjet International Corp." },
    { { 0x00, 0x40, 0x3C }, "Forks",        "Forks, Inc." },
    { { 0x00, 0x40, 0x3D }, "Teradata",     "Teradata Corporation" },
    { { 0x00, 0x40, 0x3E }, "RasterOps",    "Raster Ops Corporation" },
    { { 0x00, 0x40, 0x3F }, "SsangyongCom", "Ssangyong Computer Systems" },
    { { 0x00, 0x40, 0x40 }, "RingAccess",   "Ring Access, Inc." },
    { { 0x00, 0x40, 0x41 }, "Fujikura",     "Fujikura Ltd." },
    { { 0x00, 0x40, 0x42 }, "NAT",          "N.A.T. Gmbh" },
    { { 0x00, 0x40, 0x43 }, "NokiaSiemens", "Nokia Siemens Networks GmbH & Co. KG." },
    { { 0x00, 0x40, 0x44 }, "QnixComputer", "Qnix Computer Co., Ltd." },
    { { 0x00, 0x40, 0x45 }, "Twinhead",     "Twinhead Corporation" },
    { { 0x00, 0x40, 0x46 }, "UdcResearch",  "Udc Research Limited" },
    { { 0x00, 0x40, 0x47 }, "WindRiver",    "Wind River Systems" },
    { { 0x00, 0x40, 0x48 }, "SmdInformati", "Smd Informatica S.A." },
    { { 0x00, 0x40, 0x49 }, "RocheDiagnos", "Roche Diagnostics International Ltd." },
    { { 0x00, 0x40, 0x4A }, "WestAustrali", "West Australian Department" },
    { { 0x00, 0x40, 0x4B }, "MapleCompute", "Maple Computer Systems" },
    { { 0x00, 0x40, 0x4C }, "Hypertec",     "Hypertec Pty Ltd." },
    { { 0x00, 0x40, 0x4D }, "Telecommunic", "Telecommunications Techniques" },
    { { 0x00, 0x40, 0x4E }, "Fluent",       "Fluent, Inc." },
    { { 0x00, 0x40, 0x4F }, "SpaceNavalWa", "Space & Naval Warfare Systems" },
    { { 0x00, 0x40, 0x50 }, "Ironics",      "Ironics, Incorporated" },
    { { 0x00, 0x40, 0x51 }, "GarbeeandGar", "Garbee and Garbee" },
    { { 0x00, 0x40, 0x52 }, "StarTechnolo", "Star Technologies, Inc." },
    { { 0x00, 0x40, 0x53 }, "AmproCompute", "Ampro Computers" },
    { { 0x00, 0x40, 0x54 }, "ConnectionMa", "Connection Machines Services" },
    { { 0x00, 0x40, 0x55 }, "Metronix",     "Metronix Gmbh" },
    { { 0x00, 0x40, 0x56 }, "McmJapan",     "Mcm Japan Ltd." },
    { { 0x00, 0x40, 0x57 }, "LockheedSand", "Lockheed - Sanders" },
    { { 0x00, 0x40, 0x58 }, "Ukg",          "Ukg" },
    { { 0x00, 0x40, 0x59 }, "YoshidaKogyo", "Yoshida Kogyo K. K." },
    { { 0x00, 0x40, 0x5A }, "GoldstarInfo", "Goldstar Information & Comm." },
    { { 0x00, 0x40, 0x5B }, "Funasset",     "Funasset Limited" },
    { { 0x00, 0x40, 0x5C }, "Future",       "Future Systems, Inc." },
    { { 0x00, 0x40, 0x5D }, "StarTek",      "Star-Tek, Inc." },
    { { 0x00, 0x40, 0x5E }, "NorthHillsIs", "North Hills Israel" },
    { { 0x00, 0x40, 0x5F }, "AfeComputers", "Afe Computers Ltd." },
    { { 0x00, 0x40, 0x60 }, "Comendec",     "Comendec Ltd" },
    { { 0x00, 0x40, 0x61 }, "DatatechEnte", "Datatech Enterprises Co., Ltd." },
    { { 0x00, 0x40, 0x62 }, "EGarlandDiv",  "E-Systems, Inc./Garland Div." },
    { { 0x00, 0x40, 0x63 }, "ViaTechnolog", "Via Technologies, Inc." },
    { { 0x00, 0x40, 0x64 }, "KlaInstrumen", "Kla Instruments Corporation" },
    { { 0x00, 0x40, 0x65 }, "GteSpacenet",  "Gte Spacenet" },
    { { 0x00, 0x40, 0x66 }, "APRESIA",      "APRESIA Systems Ltd" },
    { { 0x00, 0x40, 0x67 }, "Omnibyte",     "Omnibyte Corporation" },
    { { 0x00, 0x40, 0x68 }, "Extended",     "Extended Systems" },
    { { 0x00, 0x40, 0x69 }, "Lemcom",       "Lemcom Systems, Inc." },
    { { 0x00, 0x40, 0x6A }, "KentekInform", "Kentek Information Systems,Inc" },
    { { 0x00, 0x40, 0x6B }, "Sysgen",       "Sysgen" },
    { { 0x00, 0x40, 0x6C }, "Copernique",   "Copernique" },
    { { 0x00, 0x40, 0x6D }, "Lanco",        "Lanco, Inc." },
    { { 0x00, 0x40, 0x6E }, "Corollary",    "Corollary, Inc." },
    { { 0x00, 0x40, 0x6F }, "SyncResearch", "Sync Research Inc." },
    { { 0x00, 0x40, 0x70 }, "Interware",    "Interware Co., Ltd." },
    { { 0x00, 0x40, 0x71 }, "AtmComputer",  "Atm Computer Gmbh" },
    { { 0x00, 0x40, 0x72 }, "AppliedInnov", "Applied Innovation Inc." },
    { { 0x00, 0x40, 0x73 }, "BassAssociat", "Bass Associates" },
    { { 0x00, 0x40, 0x74 }, "CableAndWire", "Cable And Wireless" },
    { { 0x00, 0x40, 0x75 }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x40, 0x76 }, "SunConversio", "Sun Conversion Technologies" },
    { { 0x00, 0x40, 0x77 }, "MaxtonTechno", "Maxton Technology Corporation" },
    { { 0x00, 0x40, 0x78 }, "WearnesAutom", "Wearnes Automation Pte Ltd" },
    { { 0x00, 0x40, 0x79 }, "JukoManufact", "Juko Manufacture Company, Ltd." },
    { { 0x00, 0x40, 0x7A }, "SocieteDExpl", "Societe D'Exploitation Du Cnit" },
    { { 0x00, 0x40, 0x7B }, "ScientificAt", "Scientific Atlanta" },
    { { 0x00, 0x40, 0x7C }, "Qume",         "Qume Corporation" },
    { { 0x00, 0x40, 0x7D }, "ExtensionTec", "Extension Technology Corp." },
    { { 0x00, 0x40, 0x7E }, "Evergreen",    "Evergreen Systems, Inc." },
    { { 0x00, 0x40, 0x7F }, "FLIR",         "FLIR Systems" },
    { { 0x00, 0x40, 0x80 }, "Athenix",      "Athenix Corporation" },
    { { 0x00, 0x40, 0x81 }, "MannesmannSc", "Mannesmann Scangraphic Gmbh" },
    { { 0x00, 0x40, 0x82 }, "LaboratoryEq", "Laboratory Equipment Corp." },
    { { 0x00, 0x40, 0x83 }, "TdaIndustria", "Tda Industria De Produtos" },
    { { 0x00, 0x40, 0x84 }, "Honeywell",    "Honeywell" },
    { { 0x00, 0x40, 0x85 }, "SaabInstrume", "Saab Instruments Ab" },
    { { 0x00, 0x40, 0x86 }, "MichelsKlebe", "Michels & Kleberhoff Computer" },
    { { 0x00, 0x40, 0x87 }, "Ubitrex",      "Ubitrex Corporation" },
    { { 0x00, 0x40, 0x88 }, "MobiusTechno", "Mobius Technologies, Inc." },
    { { 0x00, 0x40, 0x89 }, "Meidensha",    "Meidensha Corporation" },
    { { 0x00, 0x40, 0x8A }, "TpsTeleproce", "Tps Teleprocessing Sys. Gmbh" },
    { { 0x00, 0x40, 0x8B }, "Raylan",       "Raylan Corporation" },
    { { 0x00, 0x40, 0x8C }, "AxisCommunic", "Axis Communications AB" },
    { { 0x00, 0x40, 0x8D }, "GoodyearTire", "The Goodyear Tire & Rubber Co." },
    { { 0x00, 0x40, 0x8E }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x40, 0x8F }, "WmDataMinfo",  "Wm-Data Minfo Ab" },
    { { 0x00, 0x40, 0x90 }, "AnselCommuni", "Ansel Communications" },
    { { 0x00, 0x40, 0x91 }, "ProcompIndus", "Procomp Industria Eletronica" },
    { { 0x00, 0x40, 0x92 }, "AspComputerP", "Asp Computer Products, Inc." },
    { { 0x00, 0x40, 0x93 }, "PaxdataNetwo", "Paxdata Networks Ltd." },
    { { 0x00, 0x40, 0x94 }, "Shographics",  "Shographics, Inc." },
    { { 0x00, 0x40, 0x95 }, "RPTIntergrou", "R.P.T. Intergroups Int'L Ltd." },
    { { 0x00, 0x40, 0x96 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x40, 0x97 }, "DatexDivisio", "Datex Division Of" },
    { { 0x00, 0x40, 0x98 }, "Dressler",     "Dressler Gmbh & Co." },
    { { 0x00, 0x40, 0x99 }, "Newgen",       "Newgen Systems Corp." },
    { { 0x00, 0x40, 0x9A }, "NetworkExpre", "Network Express, Inc." },
    { { 0x00, 0x40, 0x9B }, "HalComputer",  "Hal Computer Systems Inc." },
    { { 0x00, 0x40, 0x9C }, "Transware",    "Transware" },
    { { 0x00, 0x40, 0x9D }, "DigiBoard",    "DigiBoard" },
    { { 0x00, 0x40, 0x9E }, "ConcurrentTe", "Concurrent Technologies Ltd." },
    { { 0x00, 0x40, 0x9F }, "Telco",        "Telco Systems, Inc." },
    { { 0x00, 0x40, 0xA0 }, "Goldstar",     "Goldstar Co., Ltd." },
    { { 0x00, 0x40, 0xA1 }, "ErgoComputin", "Ergo Computing" },
    { { 0x00, 0x40, 0xA2 }, "KingstarTech", "Kingstar Technology Inc." },
    { { 0x00, 0x40, 0xA3 }, "MicrounityEn", "Microunity Systems Engineering" },
    { { 0x00, 0x40, 0xA4 }, "RoseElectron", "Rose Electronics" },
    { { 0x00, 0x40, 0xA5 }, "ClinicompInt", "Clinicomp Intl." },
    { { 0x00, 0x40, 0xA6 }, "Cray",         "Cray, Inc." },
    { { 0x00, 0x40, 0xA7 }, "ItautecPhilc", "Itautec Philco S.A." },
    { { 0x00, 0x40, 0xA8 }, "ImfInternati", "Imf International Ltd." },
    { { 0x00, 0x40, 0xA9 }, "Datacom",      "Datacom Inc." },
    { { 0x00, 0x40, 0xAA }, "ValmetAutoma", "Valmet Automation" },
    { { 0x00, 0x40, 0xAB }, "RolandDg",     "Roland Dg Corporation" },
    { { 0x00, 0x40, 0xAC }, "SuperWorksta", "Super Workstation, Inc." },
    { { 0x00, 0x40, 0xAD }, "SmaRegelsyst", "Sma Regelsysteme Gmbh" },
    { { 0x00, 0x40, 0xAE }, "DeltaControl", "Delta Controls, Inc." },
    { { 0x00, 0x40, 0xAF }, "DigitalProdu", "Digital Products, Inc." },
    { { 0x00, 0x40, 0xB0 }, "BytexEnginee", "Bytex Corporation, Engineering" },
    { { 0x00, 0x40, 0xB1 }, "Codonics",     "Codonics Inc." },
    { { 0x00, 0x40, 0xB2 }, "Systemforsch", "Systemforschung" },
    { { 0x00, 0x40, 0xB3 }, "ParTech",      "ParTech Inc." },
    { { 0x00, 0x40, 0xB4 }, "Nextcom",      "Nextcom K.K." },
    { { 0x00, 0x40, 0xB5 }, "VideoTechnol", "Video Technology Computers Ltd" },
    { { 0x00, 0x40, 0xB6 }, "Computerm",    "Computerm Corporation" },
    { { 0x00, 0x40, 0xB7 }, "StealthCompu", "Stealth Computer Systems" },
    { { 0x00, 0x40, 0xB8 }, "IdeaAssociat", "Idea Associates" },
    { { 0x00, 0x40, 0xB9 }, "MacqElectron", "Macq Electronique Sa" },
    { { 0x00, 0x40, 0xBA }, "AlliantCompu", "Alliant Computer Systems Corp." },
    { { 0x00, 0x40, 0xBB }, "GoldstarCabl", "Goldstar Cable Co., Ltd." },
    { { 0x00, 0x40, 0xBC }, "Algorithmics", "Algorithmics Ltd." },
    { { 0x00, 0x40, 0xBD }, "StarlightNet", "Starlight Networks, Inc." },
    { { 0x00, 0x40, 0xBE }, "BoeingDefens", "Boeing Defense & Space" },
    { { 0x00, 0x40, 0xBF }, "ChannelInter", "Channel Systems Intern'L Inc." },
    { { 0x00, 0x40, 0xC0 }, "VistaControl", "Vista Controls Corporation" },
    { { 0x00, 0x40, 0xC1 }, "BizerbaWerke", "Bizerba-Werke Wilheim Kraut" },
    { { 0x00, 0x40, 0xC2 }, "AppliedCompu", "Applied Computing Devices" },
    { { 0x00, 0x40, 0xC3 }, "FischerAndPo", "Fischer And Porter Co." },
    { { 0x00, 0x40, 0xC4 }, "KinkeiSystem", "Kinkei System Corporation" },
    { { 0x00, 0x40, 0xC5 }, "MicomCommuni", "Micom Communications Inc." },
    { { 0x00, 0x40, 0xC6 }, "FibernetRese", "Fibernet Research, Inc." },
    { { 0x00, 0x40, 0xC7 }, "RubyTech",     "Ruby Tech Corporation" },
    { { 0x00, 0x40, 0xC8 }, "MilanTechnol", "Milan Technology Corporation" },
    { { 0x00, 0x40, 0xC9 }, "Ncube",        "Ncube" },
    { { 0x00, 0x40, 0xCA }, "FirstInterna", "First Internat'L Computer, Inc" },
    { { 0x00, 0x40, 0xCB }, "LanwanTechno", "Lanwan Technologies" },
    { { 0x00, 0x40, 0xCC }, "SilcomManufG", "Silcom Manuf'G Technology Inc." },
    { { 0x00, 0x40, 0xCD }, "TeraMicrosys", "Tera Microsystems, Inc." },
    { { 0x00, 0x40, 0xCE }, "NetSource",    "Net-Source, Inc." },
    { { 0x00, 0x40, 0xCF }, "StrawberryTr", "Strawberry Tree, Inc." },
    { { 0x00, 0x40, 0xD0 }, "MitacInterna", "Mitac International Corp." },
    { { 0x00, 0x40, 0xD1 }, "FukudaDenshi", "Fukuda Denshi Co., Ltd." },
    { { 0x00, 0x40, 0xD2 }, "Pagine",       "Pagine Corporation" },
    { { 0x00, 0x40, 0xD3 }, "KimpsionInte", "Kimpsion International Corp." },
    { { 0x00, 0x40, 0xD4 }, "GageTalker",   "Gage Talker Corp." },
    { { 0x00, 0x40, 0xD5 }, "SartoriusMec", "Sartorius Mechatronics T&H GmbH" },
    { { 0x00, 0x40, 0xD6 }, "Locamation",   "Locamation B.V." },
    { { 0x00, 0x40, 0xD7 }, "StudioGen",    "Studio Gen Inc." },
    { { 0x00, 0x40, 0xD8 }, "OceanOfficeA", "Ocean Office Automation Ltd." },
    { { 0x00, 0x40, 0xD9 }, "AmericanMega", "American Megatrends Inc." },
    { { 0x00, 0x40, 0xDA }, "Telspec",      "Telspec Ltd" },
    { { 0x00, 0x40, 0xDB }, "AdvancedTech", "Advanced Technical Solutions" },
    { { 0x00, 0x40, 0xDC }, "TritecElectr", "Tritec Electronic Gmbh" },
    { { 0x00, 0x40, 0xDD }, "HongTechnolo", "Hong Technologies" },
    { { 0x00, 0x40, 0xDE }, "ElsagDatamat", "Elsag Datamat spa" },
    { { 0x00, 0x40, 0xDF }, "Digalog",      "Digalog Systems, Inc." },
    { { 0x00, 0x40, 0xE0 }, "Atomwide",     "Atomwide Ltd." },
    { { 0x00, 0x40, 0xE1 }, "MarnerIntern", "Marner International, Inc." },
    { { 0x00, 0x40, 0xE2 }, "MesaRidgeTec", "Mesa Ridge Technologies, Inc." },
    { { 0x00, 0x40, 0xE3 }, "Quin",         "Quin Systems Ltd" },
    { { 0x00, 0x40, 0xE4 }, "EMTechnology", "E-M Technology, Inc." },
    { { 0x00, 0x40, 0xE5 }, "Sybus",        "Sybus Corporation" },
    { { 0x00, 0x40, 0xE6 }, "CAEN",         "C.A.E.N." },
    { { 0x00, 0x40, 0xE7 }, "ArnosInstrum", "Arnos Instruments & Computer" },
    { { 0x00, 0x40, 0xE8 }, "CharlesRiver", "Charles River Data Systems,Inc" },
    { { 0x00, 0x40, 0xE9 }, "Accord",       "Accord Systems, Inc." },
    { { 0x00, 0x40, 0xEA }, "PlainTree",    "Plain Tree Systems Inc" },
    { { 0x00, 0x40, 0xEB }, "MartinMariet", "Martin Marietta Corporation" },
    { { 0x00, 0x40, 0xEC }, "MikasaSystem", "Mikasa System Engineering" },
    { { 0x00, 0x40, 0xED }, "NetworkContr", "Network Controls Int'Natl Inc." },
    { { 0x00, 0x40, 0xEE }, "Optimem",      "Optimem" },
    { { 0x00, 0x40, 0xEF }, "Hypercom",     "Hypercom, Inc." },
    { { 0x00, 0x40, 0xF0 }, "MicroBrain",   "MicroBrain,Inc." },
    { { 0x00, 0x40, 0xF1 }, "ChuoElectron", "Chuo Electronics Co., Ltd." },
    { { 0x00, 0x40, 0xF2 }, "JanichKlassC", "Janich & Klass Computertechnik" },
    { { 0x00, 0x40, 0xF3 }, "Netcor",       "Netcor" },
    { { 0x00, 0x40, 0xF4 }, "CameoCommuni", "Cameo Communications, Inc." },
    { { 0x00, 0x40, 0xF5 }, "OemEngines",   "Oem Engines" },
    { { 0x00, 0x40, 0xF6 }, "KatronComput", "Katron Computers Inc." },
    { { 0x00, 0x40, 0xF7 }, "Polaroid",     "Polaroid Corporation" },
    { { 0x00, 0x40, 0xF8 }, "SystemhausDi", "Systemhaus Discom" },
    { { 0x00, 0x40, 0xF9 }, "Combinet",     "Combinet" },
    { { 0x00, 0x40, 0xFA }, "Microboards",  "Microboards, Inc." },
    { { 0x00, 0x40, 0xFB }, "CascadeCommu", "Cascade Communications" },
    { { 0x00, 0x40, 0xFC }, "IbrComputerT", "Ibr Computer Technik Gmbh" },
    { { 0x00, 0x40, 0xFD }, "Lxe",          "Lxe" },
    { { 0x00, 0x40, 0xFE }, "SymplexCommu", "Symplex Communications" },
    { { 0x00, 0x40, 0xFF }, "Telebit",      "Telebit Corporation" },
    { { 0x00, 0x41, 0x0E }, "CloudNetwork", "Cloud Network Technology Singapore Pte. Ltd." },
    { { 0x00, 0x41, 0xB4 }, "WuxiZhongxin", "Wuxi Zhongxing Optoelectronics Technology Co.,Ltd." },
    { { 0x00, 0x41, 0xD2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x42, 0x38 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x42, 0x52 }, "RLXTechnolog", "RLX Technologies" },
    { { 0x00, 0x42, 0x5A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x42, 0x68 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x42, 0x79 }, "SunitecEnter", "Sunitec Enterprise Co.,Ltd" },
    { { 0x00, 0x43, 0xFF }, "Ketron",       "Ketron S.R.L." },
    { { 0x00, 0x45, 0x01 }, "MidmarkRTLS",  "Midmark RTLS" },
    { { 0x00, 0x45, 0x1D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x45, 0xE2 }, "CyberTANTech", "CyberTAN Technology Inc." },
    { { 0x00, 0x46, 0x4B }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x4A, 0x77 }, "zte",          "zte corporation" },
    { { 0x00, 0x4B, 0xF3 }, "MercuryCommu", "Shenzhen Mercury Communication Technologies Co.,Ltd." },
    { { 0x00, 0x4C, 0xE5 }, "SichuanTiany", "Sichuan Tianyi Comheart Telecom Co.,LTD" },
    { { 0x00, 0x4D, 0x32 }, "AndonHealth",  "Andon Health Co.,Ltd." },
    { { 0x00, 0x4E, 0x01 }, "Dell",         "Dell Inc." },
    { { 0x00, 0x4E, 0x35 }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x00, 0x4F, 0x1A }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x50, 0x00 }, "NexoCommunic", "Nexo Communications, Inc." },
    { { 0x00, 0x50, 0x01 }, "Yamashita",    "Yamashita Systems Corp." },
    { { 0x00, 0x50, 0x02 }, "Omnisec",      "Omnisec Ag" },
    { { 0x00, 0x50, 0x03 }, "Xrite",        "Xrite Inc" },
    { { 0x00, 0x50, 0x04 }, "3Com",         "3Com" },
    { { 0x00, 0x50, 0x06 }, "Tac",          "Tac Ab" },
    { { 0x00, 0x50, 0x07 }, "SiemensTelec", "Siemens Telecommunication Systems Limited" },
    { { 0x00, 0x50, 0x08 }, "TivaMicrocom", "Tiva Microcomputer Corp. (Tmc)" },
    { { 0x00, 0x50, 0x09 }, "PhilipsBroad", "Philips Broadband Networks" },
    { { 0x00, 0x50, 0x0A }, "IrisTechnolo", "Iris Technologies, Inc." },
    { { 0x00, 0x50, 0x0B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x0C }, "eTekLabs",     "e-Tek Labs, Inc." },
    { { 0x00, 0x50, 0x0D }, "SatoriElecto", "Satori Electoric Co., Ltd." },
    { { 0x00, 0x50, 0x0E }, "ChromatisNet", "Chromatis Networks, Inc." },
    { { 0x00, 0x50, 0x0F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x10 }, "NovaNETLearn", "NovaNET Learning, Inc." },
    { { 0x00, 0x50, 0x12 }, "Cbl",          "Cbl - Gmbh" },
    { { 0x00, 0x50, 0x13 }, "SeagateCloud", "Seagate Cloud Systems Inc" },
    { { 0x00, 0x50, 0x14 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x15 }, "BrightStarEn", "Bright Star Engineering" },
    { { 0x00, 0x50, 0x16 }, "MolexCanada",  "Molex Canada Ltd" },
    { { 0x00, 0x50, 0x17 }, "Rsr",          "Rsr S.R.L." },
    { { 0x00, 0x50, 0x18 }, "AMIT",         "AMIT, Inc." },
    { { 0x00, 0x50, 0x19 }, "SpringTideNe", "Spring Tide Networks, Inc." },
    { { 0x00, 0x50, 0x1A }, "IQinVision",   "IQinVision" },
    { { 0x00, 0x50, 0x1B }, "AblCanada",    "Abl Canada, Inc." },
    { { 0x00, 0x50, 0x1C }, "Jatom",        "Jatom Systems, Inc." },
    { { 0x00, 0x50, 0x1E }, "GrassValleyA", "Grass Valley, A Belden Brand" },
    { { 0x00, 0x50, 0x1F }, "Mrg",          "Mrg Systems, Ltd." },
    { { 0x00, 0x50, 0x20 }, "Mediastar",    "Mediastar Co., Ltd." },
    { { 0x00, 0x50, 0x21 }, "EisInternati", "Eis International, Inc." },
    { { 0x00, 0x50, 0x22 }, "ZonetTechnol", "Zonet Technology, Inc." },
    { { 0x00, 0x50, 0x23 }, "PgDesignElec", "Pg Design Electronics, Inc." },
    { { 0x00, 0x50, 0x24 }, "Navic",        "Navic Systems, Inc." },
    { { 0x00, 0x50, 0x26 }, "Cosystems",    "Cosystems, Inc." },
    { { 0x00, 0x50, 0x27 }, "Genicom",      "Genicom Corporation" },
    { { 0x00, 0x50, 0x28 }, "AvalCommunic", "Aval Communications" },
    { { 0x00, 0x50, 0x29 }, "1394PrinterW", "1394 Printer Working Group" },
    { { 0x00, 0x50, 0x2A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x2B }, "Genrad",       "Genrad Ltd." },
    { { 0x00, 0x50, 0x2C }, "SoyoComputer", "Soyo Computer, Inc." },
    { { 0x00, 0x50, 0x2D }, "Accel",        "Accel, Inc." },
    { { 0x00, 0x50, 0x2E }, "Cambex",       "Cambex Corporation" },
    { { 0x00, 0x50, 0x2F }, "TollBridgeTe", "TollBridge Technologies, Inc." },
    { { 0x00, 0x50, 0x30 }, "FuturePlus",   "Future Plus Systems" },
    { { 0x00, 0x50, 0x31 }, "AeroflexLabo", "Aeroflex Laboratories, Inc." },
    { { 0x00, 0x50, 0x32 }, "PicazoCommun", "Picazo Communications, Inc." },
    { { 0x00, 0x50, 0x33 }, "MayanNetwork", "Mayan Networks" },
    { { 0x00, 0x50, 0x36 }, "Netcam",       "Netcam, Ltd." },
    { { 0x00, 0x50, 0x37 }, "KogaElectron", "Koga Electronics Co." },
    { { 0x00, 0x50, 0x38 }, "DainTelecom",  "Dain Telecom Co., Ltd." },
    { { 0x00, 0x50, 0x39 }, "MarinerNetwo", "Mariner Networks" },
    { { 0x00, 0x50, 0x3A }, "DatongElectr", "Datong Electronics Ltd." },
    { { 0x00, 0x50, 0x3B }, "Mediafire",    "Mediafire Corporation" },
    { { 0x00, 0x50, 0x3C }, "TsinghuaNove", "Tsinghua Novel Electronics" },
    { { 0x00, 0x50, 0x3E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x3F }, "AnchorGames",  "Anchor Games" },
    { { 0x00, 0x50, 0x40 }, "PanasonicEle", "Panasonic Electric Works Co., Ltd." },
    { { 0x00, 0x50, 0x41 }, "Coretronic",   "Coretronic Corporation" },
    { { 0x00, 0x50, 0x42 }, "SciManufactu", "Sci Manufacturing Singapore Pte, Ltd." },
    { { 0x00, 0x50, 0x43 }, "MarvellSemic", "Marvell Semiconductor, Inc." },
    { { 0x00, 0x50, 0x44 }, "Asaca",        "Asaca Corporation" },
    { { 0x00, 0x50, 0x45 }, "RioworksSolu", "Rioworks Solutions, Inc." },
    { { 0x00, 0x50, 0x46 }, "MenicxIntern", "Menicx International Co., Ltd." },
    { { 0x00, 0x50, 0x47 }, "Private",      "Private" },
    { { 0x00, 0x50, 0x48 }, "Infolibria",   "Infolibria" },
    { { 0x00, 0x50, 0x49 }, "ArborNetwork", "Arbor Networks Inc" },
    { { 0x00, 0x50, 0x4A }, "Elteco",       "Elteco A.S." },
    { { 0x00, 0x50, 0x4B }, "Barconet",     "Barconet N.V." },
    { { 0x00, 0x50, 0x4C }, "GalilMotionC", "Galil Motion Control" },
    { { 0x00, 0x50, 0x4D }, "TokyoElectro", "Tokyo Electron Device Limited" },
    { { 0x00, 0x50, 0x4E }, "SierraMonito", "Sierra Monitor Corp." },
    { { 0x00, 0x50, 0x4F }, "OlencomElect", "Olencom Electronics" },
    { { 0x00, 0x50, 0x50 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x51 }, "IwatsuElectr", "Iwatsu Electric Co., Ltd." },
    { { 0x00, 0x50, 0x52 }, "TiaraNetwork", "Tiara Networks, Inc." },
    { { 0x00, 0x50, 0x53 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x54 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x55 }, "Doms",         "Doms A/S" },
    { { 0x00, 0x50, 0x56 }, "VMware",       "VMware, Inc." },
    { { 0x00, 0x50, 0x57 }, "BroadbandAcc", "Broadband Access Systems" },
    { { 0x00, 0x50, 0x58 }, "SangomaTechn", "Sangoma Technologies" },
    { { 0x00, 0x50, 0x59 }, "iBAHN",        "iBAHN" },
    { { 0x00, 0x50, 0x5A }, "NetworkAlche", "Network Alchemy, Inc." },
    { { 0x00, 0x50, 0x5B }, "KawasakiLsiU", "Kawasaki Lsi U.S.A., Inc." },
    { { 0x00, 0x50, 0x5C }, "Tundo",        "Tundo Corporation" },
    { { 0x00, 0x50, 0x5E }, "DigitekMicro", "Digitek Micrologic S.A." },
    { { 0x00, 0x50, 0x5F }, "BrandInnovat", "Brand Innovators" },
    { { 0x00, 0x50, 0x60 }, "TandbergTele", "Tandberg Telecom As" },
    { { 0x00, 0x50, 0x62 }, "KouwellElect", "Kouwell Electronics Corp. **" },
    { { 0x00, 0x50, 0x63 }, "OyComselSyst", "Oy Comsel System Ab" },
    { { 0x00, 0x50, 0x64 }, "CaeElectroni", "Cae Electronics" },
    { { 0x00, 0x50, 0x65 }, "TDKLambda",    "TDK-Lambda Corporation" },
    { { 0x00, 0x50, 0x66 }, "AtecoMadvanc", "AtecoM GmbH advanced telecomunication modules" },
    { { 0x00, 0x50, 0x67 }, "Aerocomm",     "Aerocomm, Inc." },
    { { 0x00, 0x50, 0x68 }, "ElectronicIn", "Electronic Industries Association" },
    { { 0x00, 0x50, 0x69 }, "PixStream",    "PixStream Incorporated" },
    { { 0x00, 0x50, 0x6A }, "Edeva",        "Edeva, Inc." },
    { { 0x00, 0x50, 0x6B }, "SpxAteg",      "Spx-Ateg" },
    { { 0x00, 0x50, 0x6C }, "BeijerElectr", "Beijer Electronics Products AB" },
    { { 0x00, 0x50, 0x6D }, "Videojet",     "Videojet Systems" },
    { { 0x00, 0x50, 0x6E }, "CorderEngine", "Corder Engineering Corporation" },
    { { 0x00, 0x50, 0x6F }, "GConnect",     "G-Connect" },
    { { 0x00, 0x50, 0x70 }, "ChaintechCom", "Chaintech Computer Co., Ltd." },
    { { 0x00, 0x50, 0x71 }, "Aiwa",         "Aiwa Co., Ltd." },
    { { 0x00, 0x50, 0x72 }, "Corvis",       "Corvis Corporation" },
    { { 0x00, 0x50, 0x73 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x74 }, "AdvancedHiTe", "Advanced Hi-Tech Corp." },
    { { 0x00, 0x50, 0x75 }, "KestrelSolut", "Kestrel Solutions" },
    { { 0x00, 0x50, 0x76 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x50, 0x77 }, "ProlificTech", "Prolific Technology, Inc." },
    { { 0x00, 0x50, 0x78 }, "MegatonHouse", "Megaton House, Ltd." },
    { { 0x00, 0x50, 0x79 }, "Private",      "Private" },
    { { 0x00, 0x50, 0x7A }, "Xpeed",        "Xpeed, Inc." },
    { { 0x00, 0x50, 0x7B }, "MerlotCommun", "Merlot Communications" },
    { { 0x00, 0x50, 0x7C }, "Videocon",     "Videocon Ag" },
    { { 0x00, 0x50, 0x7D }, "Ifp",          "Ifp" },
    { { 0x00, 0x50, 0x7E }, "NewerTechnol", "Newer Technology" },
    { { 0x00, 0x50, 0x7F }, "DrayTek",      "DrayTek Corp." },
    { { 0x00, 0x50, 0x80 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0x81 }, "MurataMachin", "Murata Machinery, Ltd." },
    { { 0x00, 0x50, 0x82 }, "Foresson",     "Foresson Corporation" },
    { { 0x00, 0x50, 0x83 }, "Gilbarco",     "Gilbarco, Inc." },
    { { 0x00, 0x50, 0x84 }, "Quantum",      "Quantum Corp." },
    { { 0x00, 0x50, 0x86 }, "Telkom",       "Telkom Sa, Ltd." },
    { { 0x00, 0x50, 0x87 }, "TerasakiElec", "Terasaki Electric Co., Ltd." },
    { { 0x00, 0x50, 0x88 }, "Amano",        "Amano Corporation" },
    { { 0x00, 0x50, 0x89 }, "SafetyManage", "Safety Management Systems" },
    { { 0x00, 0x50, 0x8B }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x50, 0x8C }, "Rsi",          "Rsi Systems" },
    { { 0x00, 0x50, 0x8D }, "AbitComputer", "Abit Computer Corporation" },
    { { 0x00, 0x50, 0x8E }, "Optimation",   "Optimation, Inc." },
    { { 0x00, 0x50, 0x8F }, "AsitaTechnol", "Asita Technologies Int'L Ltd." },
    { { 0x00, 0x50, 0x90 }, "Dctri",        "Dctri" },
    { { 0x00, 0x50, 0x91 }, "Netaccess",    "Netaccess, Inc." },
    { { 0x00, 0x50, 0x92 }, "RigakuOsakaP", "Rigaku Corporation Osaka Plant" },
    { { 0x00, 0x50, 0x93 }, "Boeing",       "Boeing" },
    { { 0x00, 0x50, 0x94 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x50, 0x95 }, "PeracomNetwo", "Peracom Networks" },
    { { 0x00, 0x50, 0x96 }, "SalixTechnol", "Salix Technologies, Inc." },
    { { 0x00, 0x50, 0x97 }, "MMCEMBEDDEDC", "MMC-EMBEDDED COMPUTERTECHNIK GmbH" },
    { { 0x00, 0x50, 0x98 }, "Globaloop",    "Globaloop, Ltd." },
    { { 0x00, 0x50, 0x99 }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x50, 0x9A }, "TagElectroni", "Tag Electronic Systems" },
    { { 0x00, 0x50, 0x9B }, "Switchcore",   "Switchcore Ab" },
    { { 0x00, 0x50, 0x9C }, "BetaResearch", "Beta Research" },
    { { 0x00, 0x50, 0x9D }, "Industree",    "The Industree B.V." },
    { { 0x00, 0x50, 0x9E }, "LesTechnolog", "Les Technologies SoftAcoustik Inc." },
    { { 0x00, 0x50, 0x9F }, "HorizonCompu", "Horizon Computer" },
    { { 0x00, 0x50, 0xA0 }, "DeltaCompute", "Delta Computer Systems, Inc." },
    { { 0x00, 0x50, 0xA1 }, "CarloGavazzi", "Carlo Gavazzi, Inc." },
    { { 0x00, 0x50, 0xA2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0xA3 }, "TransMediaCo", "TransMedia Communications, Inc." },
    { { 0x00, 0x50, 0xA4 }, "IoTech",       "Io Tech, Inc." },
    { { 0x00, 0x50, 0xA5 }, "CapitolBusin", "Capitol Business Systems, Ltd." },
    { { 0x00, 0x50, 0xA6 }, "Optronics",    "Optronics" },
    { { 0x00, 0x50, 0xA7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0xA8 }, "OpenCon",      "OpenCon Systems, Inc." },
    { { 0x00, 0x50, 0xA9 }, "MoldatWirele", "Moldat Wireless Technolgies" },
    { { 0x00, 0x50, 0xAA }, "KonicaMinolt", "Konica Minolta Holdings, Inc." },
    { { 0x00, 0x50, 0xAB }, "NALTEC",       "NALTEC, Inc." },
    { { 0x00, 0x50, 0xAC }, "MapleCompute", "Maple Computer Corporation" },
    { { 0x00, 0x50, 0xAD }, "CommUniqueWi", "CommUnique Wireless Corp." },
    { { 0x00, 0x50, 0xAE }, "FDK",          "FDK Co., Ltd" },
    { { 0x00, 0x50, 0xAF }, "Intergon",     "Intergon, Inc." },
    { { 0x00, 0x50, 0xB0 }, "TechnologyAt", "Technology Atlanta Corporation" },
    { { 0x00, 0x50, 0xB1 }, "GiddingsLewi", "Giddings & Lewis" },
    { { 0x00, 0x50, 0xB2 }, "BRODEL",       "BRODEL GmbH" },
    { { 0x00, 0x50, 0xB3 }, "Voiceboard",   "Voiceboard Corporation" },
    { { 0x00, 0x50, 0xB4 }, "SatchwellCon", "Satchwell Control Systems, Ltd" },
    { { 0x00, 0x50, 0xB5 }, "FichetSecuri", "Fichet Securite Electronique" },
    { { 0x00, 0x50, 0xB6 }, "GoodWayInd",   "Good Way Ind. Co., Ltd." },
    { { 0x00, 0x50, 0xB7 }, "BoserTechnol", "Boser Technology Co., Ltd." },
    { { 0x00, 0x50, 0xB8 }, "InovaCompute", "Inova Computers Gmbh & Co. Kg" },
    { { 0x00, 0x50, 0xB9 }, "XitronTechno", "Xitron Technologies, Inc." },
    { { 0x00, 0x50, 0xBA }, "DLink",        "D-Link Corporation" },
    { { 0x00, 0x50, 0xBB }, "CmsTechnolog", "Cms Technologies" },
    { { 0x00, 0x50, 0xBC }, "HammerStorag", "Hammer Storage Solutions" },
    { { 0x00, 0x50, 0xBD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0xBE }, "FastMultimed", "Fast Multimedia Ag" },
    { { 0x00, 0x50, 0xBF }, "Metalligence", "Metalligence Technology Corp." },
    { { 0x00, 0x50, 0xC0 }, "Gatan",        "Gatan, Inc." },
    { { 0x00, 0x50, 0xC1 }, "GemflexNetwo", "Gemflex Networks, Ltd." },
    { { 0x00, 0x50, 0xC4 }, "Imd",          "Imd" },
    { { 0x00, 0x50, 0xC5 }, "ADSTechnolog", "ADS Technologies, Inc" },
    { { 0x00, 0x50, 0xC6 }, "LoopTelecomm", "Loop Telecommunication International, Inc." },
    { { 0x00, 0x50, 0xC7 }, "Private",      "Private" },
    { { 0x00, 0x50, 0xC8 }, "AddonicsTech", "Addonics Technologies, Inc." },
    { { 0x00, 0x50, 0xC9 }, "MasproDenkoh", "Maspro Denkoh Corp." },
    { { 0x00, 0x50, 0xCA }, "DZS",          "DZS Inc." },
    { { 0x00, 0x50, 0xCB }, "BucherAutoma", "Bucher Automation AG" },
    { { 0x00, 0x50, 0xCC }, "SeagateCloud", "Seagate Cloud Systems Inc" },
    { { 0x00, 0x50, 0xCD }, "Digianswer",   "Digianswer A/S" },
    { { 0x00, 0x50, 0xCE }, "LgInternatio", "Lg International Corp." },
    { { 0x00, 0x50, 0xCF }, "VanlinkCommu", "Vanlink Communication Technology Research Institute" },
    { { 0x00, 0x50, 0xD0 }, "Minerva",      "Minerva Systems" },
    { { 0x00, 0x50, 0xD1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0xD2 }, "CMCElectroni", "CMC Electronics Inc" },
    { { 0x00, 0x50, 0xD3 }, "DigitalAudio", "Digital Audio Processing Pty. Ltd." },
    { { 0x00, 0x50, 0xD4 }, "JoohongInfor", "Joohong Information &" },
    { { 0x00, 0x50, 0xD5 }, "Ad",           "Ad Systems Corp." },
    { { 0x00, 0x50, 0xD6 }, "AtlasCopcoTo", "Atlas Copco Tools Ab" },
    { { 0x00, 0x50, 0xD7 }, "Telstrat",     "Telstrat" },
    { { 0x00, 0x50, 0xD8 }, "UnicornCompu", "Unicorn Computer Corp." },
    { { 0x00, 0x50, 0xD9 }, "ENGETRONENGE", "ENGETRON-ENGENHARIA ELETRONICA IND. e COM. LTDA" },
    { { 0x00, 0x50, 0xDA }, "3Com",         "3Com" },
    { { 0x00, 0x50, 0xDB }, "Contemporary", "Contemporary Control" },
    { { 0x00, 0x50, 0xDC }, "TasTelefonba", "Tas Telefonbau A. Schwabe Gmbh & Co. Kg" },
    { { 0x00, 0x50, 0xDD }, "SerraSoldadu", "Serra Soldadura, S.A." },
    { { 0x00, 0x50, 0xDE }, "Signum",       "Signum Systems Corp." },
    { { 0x00, 0x50, 0xDF }, "AirFiber",     "AirFiber, Inc." },
    { { 0x00, 0x50, 0xE1 }, "NsTechElectr", "Ns Tech Electronics Sdn Bhd" },
    { { 0x00, 0x50, 0xE2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0xE3 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x50, 0xE4 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x50, 0xE6 }, "Hakusan",      "Hakusan Corporation" },
    { { 0x00, 0x50, 0xE7 }, "ParadiseInno", "Paradise Innovations (Asia)" },
    { { 0x00, 0x50, 0xE8 }, "Nomadix",      "Nomadix, Inc" },
    { { 0x00, 0x50, 0xEA }, "XelCommunica", "Xel Communications, Inc." },
    { { 0x00, 0x50, 0xEB }, "AlphaTop",     "Alpha-Top Corporation" },
    { { 0x00, 0x50, 0xEC }, "Olicom",       "Olicom A/S" },
    { { 0x00, 0x50, 0xED }, "AndaNetworks", "Anda Networks" },
    { { 0x00, 0x50, 0xEE }, "TekDigitel",   "Tek Digitel Corporation" },
    { { 0x00, 0x50, 0xEF }, "SPESystemhau", "SPE Systemhaus GmbH" },
    { { 0x00, 0x50, 0xF0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x50, 0xF1 }, "Maxlinear",    "Maxlinear, Inc" },
    { { 0x00, 0x50, 0xF2 }, "Microsoft",    "Microsoft Corp." },
    { { 0x00, 0x50, 0xF3 }, "GLOBALNETINF", "GLOBAL NET INFORMATION CO., Ltd." },
    { { 0x00, 0x50, 0xF4 }, "Sigmatek",     "Sigmatek Gmbh & Co. Kg" },
    { { 0x00, 0x50, 0xF6 }, "PanInternati", "Pan-International Industrial Corp." },
    { { 0x00, 0x50, 0xF7 }, "VentureManuf", "Venture Manufacturing (Singapore) Ltd." },
    { { 0x00, 0x50, 0xF8 }, "EntregaTechn", "Entrega Technologies, Inc." },
    { { 0x00, 0x50, 0xF9 }, "SensormaticE", "Sensormatic Electronics LLC" },
    { { 0x00, 0x50, 0xFA }, "Oxtel",        "Oxtel, Ltd." },
    { { 0x00, 0x50, 0xFB }, "VskElectroni", "Vsk Electronics" },
    { { 0x00, 0x50, 0xFC }, "EdimaxTechno", "Edimax Technology Co. Ltd." },
    { { 0x00, 0x50, 0xFD }, "Visioncomm",   "Visioncomm Co., Ltd." },
    { { 0x00, 0x50, 0xFE }, "PCTVnetASA",   "PCTVnet ASA" },
    { { 0x00, 0x50, 0xFF }, "HakkoElectro", "Hakko Electronics Co., Ltd." },
    { { 0x00, 0x51, 0xED }, "LGInnotek",    "LG Innotek" },
    { { 0x00, 0x52, 0x18 }, "WuxiKebodaEl", "Wuxi Keboda Electron Co.Ltd" },
    { { 0x00, 0x52, 0xC2 }, "peikeracusti", "peiker acustic GmbH" },
    { { 0x00, 0x52, 0xC8 }, "MadeStudioDe", "Made Studio Design Ltd." },
    { { 0x00, 0x54, 0x9F }, "Avaya",        "Avaya Inc" },
    { { 0x00, 0x54, 0xAF }, "ContinentalA", "Continental Automotive Systems Inc." },
    { { 0x00, 0x54, 0xBD }, "Swelaser",     "Swelaser AB" },
    { { 0x00, 0x55, 0xB1 }, "BaudDataComm", "Shanghai Baud Data Communication Co.,Ltd." },
    { { 0x00, 0x56, 0x2B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x56, 0x6D }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0x56, 0xCD }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x56, 0xF1 }, "zte",          "zte corporation" },
    { { 0x00, 0x57, 0xC1 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0x57, 0xD2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x58, 0x28 }, "AxonNetworks", "Axon Networks Inc." },
    { { 0x00, 0x58, 0x3F }, "PCAquarius",   "PC Aquarius" },
    { { 0x00, 0x59, 0x07 }, "LenovoEMCPro", "LenovoEMC Products USA, LLC" },
    { { 0x00, 0x59, 0x79 }, "NetworkedEne", "Networked Energy Services" },
    { { 0x00, 0x59, 0xAC }, "Kpn",          "Kpn. B.V." },
    { { 0x00, 0x59, 0xDC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x5A, 0x13 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x5A, 0x39 }, "FastTechnolo", "Shenzhen Fast Technologies Co.,Ltd" },
    { { 0x00, 0x5B, 0x94 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x5B, 0xA1 }, "huayuanchuan", "shanghai huayuan chuangxin software CO., LTD." },
    { { 0x00, 0x5C, 0x86 }, "FastTechnolo", "Shenzhen Fast Technologies Co.,Ltd" },
    { { 0x00, 0x5C, 0xB1 }, "GospellDIGIT", "Gospell DIGITAL TECHNOLOGY CO., LTD" },
    { { 0x00, 0x5C, 0xC2 }, "MercuryCommu", "Shenzhen Mercury Communication Technologies Co.,Ltd." },
    { { 0x00, 0x5D, 0x03 }, "Xilinx",       "Xilinx, Inc" },
    { { 0x00, 0x5D, 0x73 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x5E, 0x0C }, "HMDGlobal",    "HMD Global Oy" },
    { { 0x00, 0x5F, 0x67 }, "TPLink",       "TP-Link Corporation Limited" },
    { { 0x00, 0x5F, 0x86 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x5F, 0xBF }, "Toshiba",      "Toshiba Corp." },
    { { 0x00, 0x60, 0x00 }, "Xycom",        "Xycom Inc." },
    { { 0x00, 0x60, 0x01 }, "InnoSys",      "InnoSys, Inc." },
    { { 0x00, 0x60, 0x02 }, "ScreenSubtit", "Screen Subtitling Systems, Ltd" },
    { { 0x00, 0x60, 0x03 }, "TeraokaWeigh", "Teraoka Weigh System Pte, Ltd." },
    { { 0x00, 0x60, 0x04 }, "Computadores", "Computadores Modulares Sa" },
    { { 0x00, 0x60, 0x05 }, "TouchstarATC", "Touchstar ATC Limited" },
    { { 0x00, 0x60, 0x06 }, "Sotec",        "Sotec Co., Ltd" },
    { { 0x00, 0x60, 0x07 }, "AcresGaming",  "Acres Gaming, Inc." },
    { { 0x00, 0x60, 0x08 }, "3Com",         "3Com" },
    { { 0x00, 0x60, 0x09 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x60, 0x0A }, "SordComputer", "Sord Computer Corporation" },
    { { 0x00, 0x60, 0x0B }, "LOGWARE",      "LOGWARE GmbH" },
    { { 0x00, 0x60, 0x0C }, "Eurotech",     "Eurotech Inc." },
    { { 0x00, 0x60, 0x0D }, "DigitalLogic", "Digital Logic GmbH" },
    { { 0x00, 0x60, 0x0E }, "WavenetInter", "Wavenet International, Inc." },
    { { 0x00, 0x60, 0x0F }, "WestellTechn", "Westell Technologies Inc." },
    { { 0x00, 0x60, 0x10 }, "NetworkMachi", "Network Machines, Inc." },
    { { 0x00, 0x60, 0x11 }, "CrystalSemic", "Crystal Semiconductor Corp." },
    { { 0x00, 0x60, 0x12 }, "PowerComputi", "Power Computing Corporation" },
    { { 0x00, 0x60, 0x13 }, "NetstalMasch", "Netstal Maschinen Ag" },
    { { 0x00, 0x60, 0x14 }, "Edec",         "Edec Co., Ltd." },
    { { 0x00, 0x60, 0x15 }, "Net2Net",      "Net2Net Corporation" },
    { { 0x00, 0x60, 0x16 }, "Clariion",     "Clariion" },
    { { 0x00, 0x60, 0x17 }, "Tokimec",      "Tokimec Inc." },
    { { 0x00, 0x60, 0x18 }, "StellarOne",   "Stellar One Corporation" },
    { { 0x00, 0x60, 0x19 }, "RocheDiagnos", "Roche Diagnostics" },
    { { 0x00, 0x60, 0x1A }, "KeithleyInst", "Keithley Instruments" },
    { { 0x00, 0x60, 0x1B }, "MesaElectron", "Mesa Electronics" },
    { { 0x00, 0x60, 0x1C }, "Telxon",       "Telxon Corporation" },
    { { 0x00, 0x60, 0x1D }, "LucentTechno", "Lucent Technologies" },
    { { 0x00, 0x60, 0x1E }, "Softlab",      "Softlab, Inc." },
    { { 0x00, 0x60, 0x1F }, "StallionTech", "Stallion Technologies" },
    { { 0x00, 0x60, 0x20 }, "PivotalNetwo", "Pivotal Networking, Inc." },
    { { 0x00, 0x60, 0x21 }, "Dsc",          "Dsc Corporation" },
    { { 0x00, 0x60, 0x22 }, "Vicom",        "Vicom Systems, Inc." },
    { { 0x00, 0x60, 0x23 }, "PericomSemic", "Pericom Semiconductor Corp." },
    { { 0x00, 0x60, 0x24 }, "GradientTech", "Gradient Technologies, Inc." },
    { { 0x00, 0x60, 0x25 }, "ActiveImagin", "Active Imaging Plc" },
    { { 0x00, 0x60, 0x26 }, "VIKINGModula", "VIKING Modular Solutions" },
    { { 0x00, 0x60, 0x27 }, "SuperiorModu", "Superior Modular Products" },
    { { 0x00, 0x60, 0x28 }, "Macrovision",  "Macrovision Corporation" },
    { { 0x00, 0x60, 0x29 }, "CaryPeripher", "Cary Peripherals Inc." },
    { { 0x00, 0x60, 0x2A }, "SymicronComp", "Symicron Computer Communications, Ltd." },
    { { 0x00, 0x60, 0x2B }, "PeakAudio",    "Peak Audio" },
    { { 0x00, 0x60, 0x2C }, "LINXDataTerm", "LINX Data Terminals, Inc." },
    { { 0x00, 0x60, 0x2D }, "AlertonTechn", "Alerton Technologies, Inc." },
    { { 0x00, 0x60, 0x2E }, "Cyclades",     "Cyclades Corporation" },
    { { 0x00, 0x60, 0x2F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x60, 0x30 }, "VillageTroni", "Village Tronic Entwicklung" },
    { { 0x00, 0x60, 0x31 }, "Hrk",          "Hrk Systems" },
    { { 0x00, 0x60, 0x32 }, "ICube",        "I-Cube, Inc." },
    { { 0x00, 0x60, 0x33 }, "AcuityImagin", "Acuity Imaging, Inc." },
    { { 0x00, 0x60, 0x34 }, "ROBERTBOSCH",  "ROBERT BOSCH GmbH" },
    { { 0x00, 0x60, 0x35 }, "DallasSemico", "Dallas Semiconductor, Inc." },
    { { 0x00, 0x60, 0x36 }, "AITAustrianI", "AIT Austrian Institute of Technology GmbH" },
    { { 0x00, 0x60, 0x37 }, "NXPSemicondu", "NXP Semiconductors" },
    { { 0x00, 0x60, 0x38 }, "NortelNetwor", "Nortel Networks" },
    { { 0x00, 0x60, 0x39 }, "SanComTechno", "SanCom Technology, Inc." },
    { { 0x00, 0x60, 0x3A }, "QuickControl", "Quick Controls Ltd." },
    { { 0x00, 0x60, 0x3B }, "AMTEC",        "AMTEC spa" },
    { { 0x00, 0x60, 0x3C }, "HagiwaraSysC", "Hagiwara Sys-Com Co., Ltd." },
    { { 0x00, 0x60, 0x3D }, "3Cx",          "3Cx" },
    { { 0x00, 0x60, 0x3E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x60, 0x3F }, "PatapscoDesi", "Patapsco Designs" },
    { { 0x00, 0x60, 0x40 }, "Netro",        "Netro Corp." },
    { { 0x00, 0x60, 0x41 }, "YokogawaDigi", "Yokogawa Digital Computer Corporation" },
    { { 0x00, 0x60, 0x42 }, "Tks",          "Tks (Usa), Inc." },
    { { 0x00, 0x60, 0x43 }, "iDirect",      "iDirect, INC." },
    { { 0x00, 0x60, 0x44 }, "LittonPolySc", "Litton/Poly-Scientific" },
    { { 0x00, 0x60, 0x45 }, "PathlightTec", "Pathlight Technologies" },
    { { 0x00, 0x60, 0x46 }, "Vmetro",       "Vmetro, Inc." },
    { { 0x00, 0x60, 0x47 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x60, 0x48 }, "DellEMC",      "Dell EMC" },
    { { 0x00, 0x60, 0x49 }, "VinaTechnolo", "Vina Technologies" },
    { { 0x00, 0x60, 0x4A }, "SaicIdeasGro", "Saic Ideas Group" },
    { { 0x00, 0x60, 0x4B }, "Safecom",      "Safe-com GmbH & Co. KG" },
    { { 0x00, 0x60, 0x4C }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x60, 0x4D }, "MmcNetworks",  "Mmc Networks, Inc." },
    { { 0x00, 0x60, 0x4E }, "CycleCompute", "Cycle Computer Corporation, Inc." },
    { { 0x00, 0x60, 0x4F }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x60, 0x50 }, "Internix",     "Internix Inc." },
    { { 0x00, 0x60, 0x51 }, "QualitySemic", "Quality Semiconductor" },
    { { 0x00, 0x60, 0x52 }, "PERIPHERALSE", "PERIPHERALS ENTERPRISE CO., Ltd." },
    { { 0x00, 0x60, 0x53 }, "ToyodaMachin", "Toyoda Machine Works, Ltd." },
    { { 0x00, 0x60, 0x54 }, "Controlware",  "Controlware Gmbh" },
    { { 0x00, 0x60, 0x55 }, "CornellUnive", "Cornell University" },
    { { 0x00, 0x60, 0x56 }, "NetworkTools", "Network Tools, Inc." },
    { { 0x00, 0x60, 0x57 }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0x60, 0x58 }, "CopperMounta", "Copper Mountain Communications, Inc." },
    { { 0x00, 0x60, 0x59 }, "TechnicalCom", "Technical Communications Corp." },
    { { 0x00, 0x60, 0x5A }, "Celcore",      "Celcore, Inc." },
    { { 0x00, 0x60, 0x5B }, "IntraServerT", "IntraServer Technology, Inc." },
    { { 0x00, 0x60, 0x5C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x60, 0x5D }, "Scanivalve",   "Scanivalve Corp." },
    { { 0x00, 0x60, 0x5E }, "LibertyTechn", "Liberty Technology Networking" },
    { { 0x00, 0x60, 0x5F }, "NipponUnisof", "Nippon Unisoft Corporation" },
    { { 0x00, 0x60, 0x60 }, "DataInnovati", "Data Innovations North America" },
    { { 0x00, 0x60, 0x61 }, "WhistleCommu", "Whistle Communications Corp." },
    { { 0x00, 0x60, 0x62 }, "Telesync",     "Telesync, Inc." },
    { { 0x00, 0x60, 0x63 }, "PsionDacom",   "Psion Dacom Plc." },
    { { 0x00, 0x60, 0x64 }, "Netcomm",      "Netcomm Limited" },
    { { 0x00, 0x60, 0x65 }, "B&RIndustria", "B&R Industrial Automation GmbH" },
    { { 0x00, 0x60, 0x66 }, "LACROIXTrafi", "LACROIX Trafic" },
    { { 0x00, 0x60, 0x67 }, "AcerNetxus",   "Acer Netxus Inc." },
    { { 0x00, 0x60, 0x68 }, "Dialogic",     "Dialogic Corporation" },
    { { 0x00, 0x60, 0x69 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x60, 0x6A }, "MitsubishiWi", "Mitsubishi Wireless Communications. Inc." },
    { { 0x00, 0x60, 0x6B }, "Synclayer",    "Synclayer Inc." },
    { { 0x00, 0x60, 0x6C }, "Arescom",      "Arescom" },
    { { 0x00, 0x60, 0x6D }, "DigitalEquip", "Digital Equipment Corp." },
    { { 0x00, 0x60, 0x6E }, "DavicomSemic", "Davicom Semiconductor, Inc." },
    { { 0x00, 0x60, 0x6F }, "ClarionAmeri", "Clarion Corporation Of America" },
    { { 0x00, 0x60, 0x70 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x60, 0x71 }, "MidasLab",     "Midas Lab, Inc." },
    { { 0x00, 0x60, 0x72 }, "VxlInstrumen", "Vxl Instruments, Limited" },
    { { 0x00, 0x60, 0x73 }, "RedcreekComm", "Redcreek Communications, Inc." },
    { { 0x00, 0x60, 0x74 }, "Qsc",          "Qsc Llc" },
    { { 0x00, 0x60, 0x75 }, "Pentek",       "Pentek, Inc." },
    { { 0x00, 0x60, 0x76 }, "Schlumberger", "Schlumberger Technologies Retail Petroleum Systems" },
    { { 0x00, 0x60, 0x77 }, "PrisaNetwork", "Prisa Networks" },
    { { 0x00, 0x60, 0x78 }, "PowerMeasure", "Power Measurement Ltd." },
    { { 0x00, 0x60, 0x79 }, "MainstreamDa", "Mainstream Data, Inc." },
    { { 0x00, 0x60, 0x7A }, "Dvs",          "Dvs Gmbh" },
    { { 0x00, 0x60, 0x7B }, "Fore",         "Fore Systems, Inc." },
    { { 0x00, 0x60, 0x7C }, "WaveAccess",   "WaveAccess, Ltd." },
    { { 0x00, 0x60, 0x7D }, "SentientNetw", "Sentient Networks Inc." },
    { { 0x00, 0x60, 0x7E }, "Gigalabs",     "Gigalabs, Inc." },
    { { 0x00, 0x60, 0x7F }, "AuroraTechno", "Aurora Technologies, Inc." },
    { { 0x00, 0x60, 0x80 }, "MicrotronixD", "Microtronix Datacom Ltd." },
    { { 0x00, 0x60, 0x81 }, "TvComInterna", "Tv/Com International" },
    { { 0x00, 0x60, 0x82 }, "NovalinkTech", "Novalink Technologies, Inc." },
    { { 0x00, 0x60, 0x83 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x60, 0x84 }, "DigitalVideo", "Digital Video" },
    { { 0x00, 0x60, 0x85 }, "StorageConce", "Storage Concepts" },
    { { 0x00, 0x60, 0x86 }, "LogicReplace", "Logic Replacement Tech. Ltd." },
    { { 0x00, 0x60, 0x87 }, "KansaiElectr", "Kansai Electric Co., Ltd." },
    { { 0x00, 0x60, 0x88 }, "AnalogDevice", "Analog Devices, Inc." },
    { { 0x00, 0x60, 0x89 }, "Xata",         "Xata" },
    { { 0x00, 0x60, 0x8A }, "CitadelCompu", "Citadel Computer" },
    { { 0x00, 0x60, 0x8B }, "ConferTechIn", "ConferTech International" },
    { { 0x00, 0x60, 0x8C }, "3Com",         "3Com" },
    { { 0x00, 0x60, 0x8D }, "Unipulse",     "Unipulse Corp." },
    { { 0x00, 0x60, 0x8E }, "HEELECTRONIC", "HE ELECTRONICS, TECHNOLOGIE & SYSTEMTECHNIK GmbH" },
    { { 0x00, 0x60, 0x8F }, "TekramTechno", "Tekram Technology Co., Ltd." },
    { { 0x00, 0x60, 0x90 }, "ArtizaNetwor", "Artiza Networks Inc" },
    { { 0x00, 0x60, 0x91 }, "FirstPacific", "First Pacific Networks, Inc." },
    { { 0x00, 0x60, 0x92 }, "MicroSys",     "Micro/Sys, Inc." },
    { { 0x00, 0x60, 0x93 }, "Varian",       "Varian" },
    { { 0x00, 0x60, 0x94 }, "IBM",          "IBM Corp" },
    { { 0x00, 0x60, 0x95 }, "AccuTime",     "Accu-Time Systems, Inc." },
    { { 0x00, 0x60, 0x96 }, "TSMicrotech",  "T.S. Microtech Inc." },
    { { 0x00, 0x60, 0x97 }, "3Com",         "3Com" },
    { { 0x00, 0x60, 0x98 }, "HtCommunicat", "Ht Communications" },
    { { 0x00, 0x60, 0x99 }, "SBE",          "SBE, Inc." },
    { { 0x00, 0x60, 0x9A }, "NjkTechno",    "Njk Techno Co." },
    { { 0x00, 0x60, 0x9B }, "AstroNova",    "AstroNova, Inc" },
    { { 0x00, 0x60, 0x9C }, "PerkinElmer",  "Perkin-Elmer Incorporated" },
    { { 0x00, 0x60, 0x9D }, "PmiFoodEquip", "Pmi Food Equipment Group" },
    { { 0x00, 0x60, 0x9E }, "AscX3Informa", "Asc X3 - Information Technology Standards Secretariats" },
    { { 0x00, 0x60, 0x9F }, "Phast",        "Phast Corporation" },
    { { 0x00, 0x60, 0xA0 }, "SwitchedNetw", "Switched Network Technologies, Inc." },
    { { 0x00, 0x60, 0xA1 }, "VPNet",        "VPNet, Inc." },
    { { 0x00, 0x60, 0xA2 }, "NihonUnisys",  "Nihon Unisys Limited Co." },
    { { 0x00, 0x60, 0xA3 }, "ContinuumTec", "Continuum Technology Corp." },
    { { 0x00, 0x60, 0xA4 }, "GEWTechnolog", "GEW Technologies (PTY)Ltd" },
    { { 0x00, 0x60, 0xA5 }, "PerformanceT", "Performance Telecom Corp." },
    { { 0x00, 0x60, 0xA6 }, "ParticleMeas", "Particle Measuring Systems" },
    { { 0x00, 0x60, 0xA7 }, "MICROSENS",    "MICROSENS GmbH & CO. KG" },
    { { 0x00, 0x60, 0xA8 }, "Tidomat",      "Tidomat Ab" },
    { { 0x00, 0x60, 0xA9 }, "GesytecMbh",   "Gesytec Mbh" },
    { { 0x00, 0x60, 0xAA }, "IntelligentD", "Intelligent Devices Inc. (Idi)" },
    { { 0x00, 0x60, 0xAB }, "Larscom",      "Larscom Incorporated" },
    { { 0x00, 0x60, 0xAC }, "Resilience",   "Resilience Corporation" },
    { { 0x00, 0x60, 0xAD }, "MegaChips",    "MegaChips Corporation" },
    { { 0x00, 0x60, 0xAE }, "TrioInformat", "Trio Information Systems Ab" },
    { { 0x00, 0x60, 0xAF }, "PacificMicro", "Pacific Micro Data, Inc." },
    { { 0x00, 0x60, 0xB0 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x60, 0xB1 }, "InputOutput",  "Input/Output, Inc." },
    { { 0x00, 0x60, 0xB2 }, "ProcessContr", "Process Control Corp." },
    { { 0x00, 0x60, 0xB3 }, "ZCom",         "Z-Com, Inc." },
    { { 0x00, 0x60, 0xB4 }, "GlenayreR&D",  "Glenayre R&D Inc." },
    { { 0x00, 0x60, 0xB5 }, "KEBA",         "KEBA GmbH" },
    { { 0x00, 0x60, 0xB6 }, "LandComputer", "Land Computer Co., Ltd." },
    { { 0x00, 0x60, 0xB7 }, "Channelmatic", "Channelmatic, Inc." },
    { { 0x00, 0x60, 0xB8 }, "CORELIS",      "CORELIS Inc." },
    { { 0x00, 0x60, 0xB9 }, "NECPlatforms", "NEC Platforms, Ltd" },
    { { 0x00, 0x60, 0xBA }, "SaharaNetwor", "Sahara Networks, Inc." },
    { { 0x00, 0x60, 0xBB }, "Cabletron",    "Cabletron Systems, Inc." },
    { { 0x00, 0x60, 0xBC }, "KeunYoungEle", "KeunYoung Electronics & Communication Co., Ltd." },
    { { 0x00, 0x60, 0xBD }, "EnginuityCom", "Enginuity Communications" },
    { { 0x00, 0x60, 0xBE }, "Webtronics",   "Webtronics" },
    { { 0x00, 0x60, 0xBF }, "Macraigor",    "Macraigor Systems, Inc." },
    { { 0x00, 0x60, 0xC0 }, "NeraNetworks", "Nera Networks AS" },
    { { 0x00, 0x60, 0xC1 }, "WaveSpan",     "WaveSpan Corporation" },
    { { 0x00, 0x60, 0xC2 }, "Mpl",          "Mpl Ag" },
    { { 0x00, 0x60, 0xC3 }, "Netvision",    "Netvision Corporation" },
    { { 0x00, 0x60, 0xC4 }, "Soliton",      "Soliton Systems K.K." },
    { { 0x00, 0x60, 0xC5 }, "Ancot",        "Ancot Corp." },
    { { 0x00, 0x60, 0xC6 }, "Dcs",          "Dcs Ag" },
    { { 0x00, 0x60, 0xC7 }, "AmatiCommuni", "Amati Communications Corp." },
    { { 0x00, 0x60, 0xC8 }, "KukaWeldingR", "Kuka Welding Systems & Robots" },
    { { 0x00, 0x60, 0xC9 }, "ControlNet",   "ControlNet, Inc." },
    { { 0x00, 0x60, 0xCA }, "Harmonic",     "Harmonic Systems Incorporated" },
    { { 0x00, 0x60, 0xCB }, "HitachiZosen", "Hitachi Zosen Corporation" },
    { { 0x00, 0x60, 0xCC }, "Emtrak",       "Emtrak, Incorporated" },
    { { 0x00, 0x60, 0xCD }, "VideoServer",  "VideoServer, Inc." },
    { { 0x00, 0x60, 0xCE }, "AcclaimCommu", "Acclaim Communications" },
    { { 0x00, 0x60, 0xCF }, "AlteonNetwor", "Alteon Networks, Inc." },
    { { 0x00, 0x60, 0xD0 }, "SnmpResearch", "Snmp Research Incorporated" },
    { { 0x00, 0x60, 0xD1 }, "CascadeCommu", "Cascade Communications" },
    { { 0x00, 0x60, 0xD2 }, "LucentTechno", "Lucent Technologies Taiwan Telecommunications Co., Ltd." },
    { { 0x00, 0x60, 0xD3 }, "At&T",         "At&T" },
    { { 0x00, 0x60, 0xD4 }, "EldatCommuni", "Eldat Communication Ltd." },
    { { 0x00, 0x60, 0xD5 }, "AMADAMIYACHI", "AMADA MIYACHI Co., Ltd" },
    { { 0x00, 0x60, 0xD6 }, "NovAtel",      "NovAtel Inc." },
    { { 0x00, 0x60, 0xD7 }, "EcolePolytec", "Ecole Polytechnique Federale De Lausanne (Epfl)" },
    { { 0x00, 0x60, 0xD8 }, "Elmic",        "Elmic Systems, Inc." },
    { { 0x00, 0x60, 0xD9 }, "TransysNetwo", "Transys Networks Inc." },
    { { 0x00, 0x60, 0xDA }, "RedLionContr", "Red Lion Controls, LP" },
    { { 0x00, 0x60, 0xDB }, "NtpElektroni", "Ntp Elektronik A/S" },
    { { 0x00, 0x60, 0xDC }, "NECMagnusCom", "NEC Magnus Communications,Ltd." },
    { { 0x00, 0x60, 0xDD }, "Myricom",      "Myricom, Inc." },
    { { 0x00, 0x60, 0xDE }, "KayserThrede", "Kayser-Threde GmbH" },
    { { 0x00, 0x60, 0xDF }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0x60, 0xE0 }, "AxiomTechnol", "Axiom Technology Co., Ltd." },
    { { 0x00, 0x60, 0xE1 }, "OrckitCommun", "Orckit Communications Ltd." },
    { { 0x00, 0x60, 0xE2 }, "QuestEnginee", "Quest Engineering & Development" },
    { { 0x00, 0x60, 0xE3 }, "ArbinInstrum", "Arbin Instruments" },
    { { 0x00, 0x60, 0xE4 }, "Compuserve",   "Compuserve, Inc." },
    { { 0x00, 0x60, 0xE5 }, "FujiAutomati", "Fuji Automation Co., Ltd." },
    { { 0x00, 0x60, 0xE6 }, "Shomiti",      "Shomiti Systems Incorporated" },
    { { 0x00, 0x60, 0xE7 }, "Randata",      "Randata" },
    { { 0x00, 0x60, 0xE8 }, "HitachiCompu", "Hitachi Computer Products (America), Inc." },
    { { 0x00, 0x60, 0xE9 }, "AtopTechnolo", "Atop Technologies, Inc." },
    { { 0x00, 0x60, 0xEA }, "StreamLogic",  "StreamLogic" },
    { { 0x00, 0x60, 0xEB }, "Fourthtrack",  "Fourthtrack Systems" },
    { { 0x00, 0x60, 0xEC }, "HermaryOptoE", "Hermary Opto Electronics Inc." },
    { { 0x00, 0x60, 0xED }, "RicardoTestA", "Ricardo Test Automation Ltd." },
    { { 0x00, 0x60, 0xEE }, "Apollo",       "Apollo" },
    { { 0x00, 0x60, 0xEF }, "FlytechTechn", "Flytech Technology Co., Ltd." },
    { { 0x00, 0x60, 0xF0 }, "JohnsonJohns", "Johnson & Johnson Medical, Inc" },
    { { 0x00, 0x60, 0xF1 }, "ExpComputer",  "Exp Computer, Inc." },
    { { 0x00, 0x60, 0xF2 }, "Lasergraphic", "Lasergraphics, Inc." },
    { { 0x00, 0x60, 0xF3 }, "PerformanceA", "Performance Analysis Broadband, Spirent plc" },
    { { 0x00, 0x60, 0xF4 }, "ADVANCEDCOMP", "ADVANCED COMPUTER SOLUTIONS, Inc." },
    { { 0x00, 0x60, 0xF5 }, "IconWest",     "Icon West, Inc." },
    { { 0x00, 0x60, 0xF6 }, "NextestCommu", "Nextest Communications Products, Inc." },
    { { 0x00, 0x60, 0xF7 }, "Datafusion",   "Datafusion Systems" },
    { { 0x00, 0x60, 0xF8 }, "LoranInterna", "Loran International Technologies Inc." },
    { { 0x00, 0x60, 0xF9 }, "DiamondLaneC", "Diamond Lane Communications" },
    { { 0x00, 0x60, 0xFA }, "EducationalT", "Educational Technology Resources, Inc." },
    { { 0x00, 0x60, 0xFB }, "Packeteer",    "Packeteer, Inc." },
    { { 0x00, 0x60, 0xFC }, "Conservation", "Conservation Through Innovation Ltd." },
    { { 0x00, 0x60, 0xFD }, "NetICs",       "NetICs, Inc." },
    { { 0x00, 0x60, 0xFE }, "LynxSystemDe", "Lynx System Developers, Inc." },
    { { 0x00, 0x60, 0xFF }, "QuVis",        "QuVis, Inc." },
    { { 0x00, 0x61, 0x51 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x61, 0x71 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x62, 0x0B }, "Broadcom",     "Broadcom Limited" },
    { { 0x00, 0x62, 0xEC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x63, 0xDE }, "CloudwalkTec", "Cloudwalk Technology Co.,Ltd" },
    { { 0x00, 0x64, 0x40 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x64, 0xA6 }, "MaquetCardio", "Maquet CardioVascular" },
    { { 0x00, 0x64, 0xAF }, "DishTechnolo", "Dish Technologies Corp" },
    { { 0x00, 0x65, 0x1E }, "AmcrestTechn", "Amcrest Technologies" },
    { { 0x00, 0x66, 0x19 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0x66, 0x4B }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x67, 0x62 }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x00, 0x68, 0x2B }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0x68, 0xEB }, "HP",           "HP Inc." },
    { { 0x00, 0x69, 0x2D }, "SunnovoInter", "Sunnovo International Limited" },
    { { 0x00, 0x6B, 0x6F }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x6B, 0x8E }, "FeixunCommun", "Shanghai Feixun Communication Co.,Ltd." },
    { { 0x00, 0x6B, 0x9E }, "Vizio",        "Vizio, Inc" },
    { { 0x00, 0x6B, 0xA0 }, "UniversalInt", "Shenzhen Universal Intellisys Pte Ltd" },
    { { 0x00, 0x6B, 0xF1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x6C, 0xBC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x6C, 0xFD }, "SichuanChang", "Sichuan Changhong Electric Ltd." },
    { { 0x00, 0x6D, 0x52 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x6D, 0x61 }, "GuangzhouVSO", "Guangzhou V-SOLUTION Electronic Technology Co., Ltd." },
    { { 0x00, 0x6D, 0xFB }, "VutrixTechno", "Vutrix Technologies Ltd" },
    { { 0x00, 0x6E, 0x02 }, "Xovis",        "Xovis AG" },
    { { 0x00, 0x6F, 0x64 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x6F, 0xF2 }, "MitsumiElect", "Mitsumi Electric Co.,Ltd." },
    { { 0x00, 0x70, 0xB0 }, "MAComCompani", "M/A-Com Inc. Companies" },
    { { 0x00, 0x70, 0xB3 }, "DataRecall",   "Data Recall Ltd." },
    { { 0x00, 0x71, 0x47 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x00, 0x71, 0xC2 }, "Pegatron",     "Pegatron Corporation" },
    { { 0x00, 0x71, 0xCC }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x00, 0x72, 0x04 }, "SamsungElect", "Samsung Electronics Co., Ltd. ARTIK" },
    { { 0x00, 0x72, 0x63 }, "NetisTechnol", "Netis Technology Co., Ltd." },
    { { 0x00, 0x72, 0x78 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x72, 0xEE }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x73, 0x8D }, "TINNOMobileT", "Shenzhen TINNO Mobile Technology Corp." },
    { { 0x00, 0x73, 0xE0 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x74, 0x9C }, "RuijieNetwor", "Ruijie Networks Co.,LTD" },
    { { 0x00, 0x75, 0x32 }, "Inid",         "Inid Bv" },
    { { 0x00, 0x75, 0xE1 }, "Ampt",         "Ampt, LLC" },
    { { 0x00, 0x76, 0x3D }, "Veea",         "Veea" },
    { { 0x00, 0x76, 0x86 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x76, 0xB1 }, "SomfyProtect", "Somfy-Protect By Myfox SAS" },
    { { 0x00, 0x77, 0x8D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x77, 0xE4 }, "NokiaSolutio", "Nokia Solutions and Networks GmbH & Co. KG" },
    { { 0x00, 0x78, 0x39 }, "Nokia",        "Nokia" },
    { { 0x00, 0x78, 0x88 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x78, 0x9E }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0x78, 0xCD }, "IgnitionDesi", "Ignition Design Labs" },
    { { 0x00, 0x7B, 0x18 }, "SENTRY",       "SENTRY Co., LTD." },
    { { 0x00, 0x7C, 0x2D }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x7D, 0x60 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x7D, 0xFA }, "VolkswagenGr", "Volkswagen Group of America" },
    { { 0x00, 0x7E, 0x56 }, "ChinaDragonT", "China Dragon Technology Limited" },
    { { 0x00, 0x7E, 0x95 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x7F, 0x28 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x00, 0x80, 0x00 }, "Multitech",    "Multitech Systems, Inc." },
    { { 0x00, 0x80, 0x01 }, "Periphonics",  "Periphonics Corporation" },
    { { 0x00, 0x80, 0x02 }, "Satelcom",     "Satelcom (Uk) Ltd" },
    { { 0x00, 0x80, 0x03 }, "HytecElectro", "Hytec Electronics Ltd." },
    { { 0x00, 0x80, 0x04 }, "AntlowCommun", "Antlow Communications, Ltd." },
    { { 0x00, 0x80, 0x05 }, "CactusComput", "Cactus Computer Inc." },
    { { 0x00, 0x80, 0x06 }, "Compuadd",     "Compuadd Corporation" },
    { { 0x00, 0x80, 0x07 }, "DlogNcSystem", "Dlog Nc-Systeme" },
    { { 0x00, 0x80, 0x08 }, "DynatechComp", "Dynatech Computer Systems" },
    { { 0x00, 0x80, 0x09 }, "Jupiter",      "Jupiter Systems, Inc." },
    { { 0x00, 0x80, 0x0A }, "JapanCompute", "Japan Computer Corp." },
    { { 0x00, 0x80, 0x0B }, "Csk",          "Csk Corporation" },
    { { 0x00, 0x80, 0x0C }, "Videcom",      "Videcom Limited" },
    { { 0x00, 0x80, 0x0D }, "VosswinkelFU", "Vosswinkel F.U." },
    { { 0x00, 0x80, 0x0E }, "Atlantix",     "Atlantix Corporation" },
    { { 0x00, 0x80, 0x0F }, "StandardMicr", "Standard Microsystems" },
    { { 0x00, 0x80, 0x10 }, "CommodoreInt", "Commodore International" },
    { { 0x00, 0x80, 0x11 }, "DigitalIntL",  "Digital Systems Int'L. Inc." },
    { { 0x00, 0x80, 0x12 }, "IntegratedMe", "Integrated Measurement Systems" },
    { { 0x00, 0x80, 0x13 }, "ThomasConrad", "Thomas-Conrad Corporation" },
    { { 0x00, 0x80, 0x14 }, "Esprit",       "Esprit Systems" },
    { { 0x00, 0x80, 0x15 }, "Seiko",        "Seiko Systems, Inc." },
    { { 0x00, 0x80, 0x16 }, "WandelAndGol", "Wandel And Goltermann" },
    { { 0x00, 0x80, 0x17 }, "Pfu",          "Pfu Limited" },
    { { 0x00, 0x80, 0x18 }, "KobeSteel",    "Kobe Steel, Ltd." },
    { { 0x00, 0x80, 0x19 }, "DaynaCommuni", "Dayna Communications, Inc." },
    { { 0x00, 0x80, 0x1A }, "BellAtlantic", "Bell Atlantic" },
    { { 0x00, 0x80, 0x1B }, "KodiakTechno", "Kodiak Technology" },
    { { 0x00, 0x80, 0x1C }, "NewportSolut", "Newport Systems Solutions" },
    { { 0x00, 0x80, 0x1D }, "IntegratedIn", "Integrated Inference Machines" },
    { { 0x00, 0x80, 0x1E }, "Xinetron",     "Xinetron, Inc." },
    { { 0x00, 0x80, 0x1F }, "KruppAtlasEl", "Krupp Atlas Electronik Gmbh" },
    { { 0x00, 0x80, 0x20 }, "NetworkProdu", "Network Products" },
    { { 0x00, 0x80, 0x21 }, "AlcatelCanad", "Alcatel Canada Inc." },
    { { 0x00, 0x80, 0x22 }, "ScanOptics",   "Scan-Optics" },
    { { 0x00, 0x80, 0x23 }, "IntegratedBu", "Integrated Business Networks" },
    { { 0x00, 0x80, 0x24 }, "Kalpana",      "Kalpana, Inc." },
    { { 0x00, 0x80, 0x25 }, "TelitWireles", "Telit Wireless Solutions GmbH" },
    { { 0x00, 0x80, 0x26 }, "NetworkProdu", "Network Products Corporation" },
    { { 0x00, 0x80, 0x27 }, "Adaptive",     "Adaptive Systems, Inc." },
    { { 0x00, 0x80, 0x28 }, "Tradpost",     "Tradpost (Hk) Ltd" },
    { { 0x00, 0x80, 0x29 }, "EagleTechnol", "Eagle Technology, Inc." },
    { { 0x00, 0x80, 0x2A }, "TestSimulati", "Test Systems & Simulations Inc" },
    { { 0x00, 0x80, 0x2B }, "IntegratedMa", "Integrated Marketing Co" },
    { { 0x00, 0x80, 0x2C }, "SageGroup",    "The Sage Group Plc" },
    { { 0x00, 0x80, 0x2D }, "Xylogics",     "Xylogics Inc" },
    { { 0x00, 0x80, 0x2E }, "CastleRockCo", "Castle Rock Computing" },
    { { 0x00, 0x80, 0x2F }, "NationalInst", "National Instruments Corp." },
    { { 0x00, 0x80, 0x30 }, "NexusElectro", "Nexus Electronics" },
    { { 0x00, 0x80, 0x31 }, "Basys",        "Basys, Corp." },
    { { 0x00, 0x80, 0x32 }, "Access",       "Access Co., Ltd." },
    { { 0x00, 0x80, 0x33 }, "EMSAviation",  "EMS Aviation, Inc." },
    { { 0x00, 0x80, 0x34 }, "SmtGoupil",    "Smt Goupil" },
    { { 0x00, 0x80, 0x35 }, "TechnologyWo", "Technology Works, Inc." },
    { { 0x00, 0x80, 0x36 }, "ReflexManufa", "Reflex Manufacturing Systems" },
    { { 0x00, 0x80, 0x37 }, "EricssonGrou", "Ericsson Group" },
    { { 0x00, 0x80, 0x38 }, "DataResearch", "Data Research & Applications" },
    { { 0x00, 0x80, 0x39 }, "AlcatelStcAu", "Alcatel Stc Australia" },
    { { 0x00, 0x80, 0x3A }, "Varityper",    "Varityper, Inc." },
    { { 0x00, 0x80, 0x3B }, "AptCommunica", "Apt Communications, Inc." },
    { { 0x00, 0x80, 0x3C }, "TvsElectroni", "Tvs Electronics Ltd" },
    { { 0x00, 0x80, 0x3D }, "Surigiken",    "Surigiken Co., Ltd." },
    { { 0x00, 0x80, 0x3E }, "Synernetics",  "Synernetics" },
    { { 0x00, 0x80, 0x3F }, "Tatung",       "Tatung Company" },
    { { 0x00, 0x80, 0x40 }, "JohnFlukeMan", "John Fluke Manufacturing Co." },
    { { 0x00, 0x80, 0x41 }, "VebKombinatR", "Veb Kombinat Robotron" },
    { { 0x00, 0x80, 0x42 }, "ArtesynEmbed", "Artesyn Embedded Technologies" },
    { { 0x00, 0x80, 0x43 }, "Networld",     "Networld, Inc." },
    { { 0x00, 0x80, 0x44 }, "SystechCompu", "Systech Computer Corp." },
    { { 0x00, 0x80, 0x45 }, "MatsushitaEl", "Matsushita Electric Ind. Co" },
    { { 0x00, 0x80, 0x46 }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x80, 0x47 }, "InNet",        "In-Net Corp." },
    { { 0x00, 0x80, 0x48 }, "Compex",       "Compex Incorporated" },
    { { 0x00, 0x80, 0x49 }, "NissinElectr", "Nissin Electric Co., Ltd." },
    { { 0x00, 0x80, 0x4A }, "ProLog",       "Pro-Log" },
    { { 0x00, 0x80, 0x4B }, "EagleTechnol", "Eagle Technologies Pty.Ltd." },
    { { 0x00, 0x80, 0x4C }, "Contec",       "Contec Co., Ltd." },
    { { 0x00, 0x80, 0x4D }, "CycloneMicro", "Cyclone Microsystems, Inc." },
    { { 0x00, 0x80, 0x4E }, "ApexComputer", "Apex Computer Company" },
    { { 0x00, 0x80, 0x4F }, "DaikinIndust", "Daikin Industries, Ltd." },
    { { 0x00, 0x80, 0x50 }, "Ziatech",      "Ziatech Corporation" },
    { { 0x00, 0x80, 0x51 }, "Fibermux",     "Fibermux" },
    { { 0x00, 0x80, 0x52 }, "TechnicallyE", "Technically Elite Concepts" },
    { { 0x00, 0x80, 0x53 }, "Intellicom",   "Intellicom, Inc." },
    { { 0x00, 0x80, 0x54 }, "FrontierTech", "Frontier Technologies Corp." },
    { { 0x00, 0x80, 0x55 }, "Fermilab",     "Fermilab" },
    { { 0x00, 0x80, 0x56 }, "SPHINXElectr", "SPHINX Electronics GmbH & Co KG" },
    { { 0x00, 0x80, 0x57 }, "Adsoft",       "Adsoft, Ltd." },
    { { 0x00, 0x80, 0x58 }, "Printer",      "Printer Systems Corp." },
    { { 0x00, 0x80, 0x59 }, "StanleyElect", "Stanley Electric Co., Ltd" },
    { { 0x00, 0x80, 0x5A }, "TulipCompute", "Tulip Computers Internat'L B.V" },
    { { 0x00, 0x80, 0x5B }, "Condor",       "Condor Systems, Inc." },
    { { 0x00, 0x80, 0x5C }, "Agilis",       "Agilis Corporation" },
    { { 0x00, 0x80, 0x5D }, "Canstar",      "Canstar" },
    { { 0x00, 0x80, 0x5E }, "LsiLogic",     "Lsi Logic Corporation" },
    { { 0x00, 0x80, 0x5F }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x80, 0x60 }, "NetworkInter", "Network Interface Corporation" },
    { { 0x00, 0x80, 0x61 }, "Litton",       "Litton Systems, Inc." },
    { { 0x00, 0x80, 0x62 }, "Interface",    "Interface Co." },
    { { 0x00, 0x80, 0x63 }, "HirschmannAu", "Hirschmann Automation and Control GmbH" },
    { { 0x00, 0x80, 0x64 }, "WyseTechnolo", "Wyse Technology Llc" },
    { { 0x00, 0x80, 0x65 }, "Cybergraphic", "Cybergraphic Systems Pty Ltd." },
    { { 0x00, 0x80, 0x66 }, "Eurotech",     "Eurotech S.p.A." },
    { { 0x00, 0x80, 0x67 }, "SquareD",      "Square D Company" },
    { { 0x00, 0x80, 0x68 }, "YamatechScie", "Yamatech Scientific Ltd." },
    { { 0x00, 0x80, 0x69 }, "Computone",    "Computone Systems" },
    { { 0x00, 0x80, 0x6A }, "Eri",          "Eri (Empac Research Inc.)" },
    { { 0x00, 0x80, 0x6B }, "SchmidTeleco", "Schmid Telecommunication" },
    { { 0x00, 0x80, 0x6C }, "SecureServic", "Secure Systems & Services" },
    { { 0x00, 0x80, 0x6D }, "Century",      "Century Systems Corp." },
    { { 0x00, 0x80, 0x6E }, "NipponSteel",  "Nippon Steel Corporation" },
    { { 0x00, 0x80, 0x6F }, "Onelan",       "Onelan Ltd." },
    { { 0x00, 0x80, 0x70 }, "Computadoras", "Computadoras Micron" },
    { { 0x00, 0x80, 0x71 }, "SaiTechnolog", "Sai Technology" },
    { { 0x00, 0x80, 0x72 }, "Microplex",    "Microplex Systems Ltd." },
    { { 0x00, 0x80, 0x73 }, "DwbAssociate", "Dwb Associates" },
    { { 0x00, 0x80, 0x74 }, "FisherContro", "Fisher Controls" },
    { { 0x00, 0x80, 0x75 }, "Parsytec",     "Parsytec Gmbh" },
    { { 0x00, 0x80, 0x76 }, "Mcnc",         "Mcnc" },
    { { 0x00, 0x80, 0x77 }, "Brotherindus", "Brother industries, LTD." },
    { { 0x00, 0x80, 0x78 }, "PracticalPer", "Practical Peripherals, Inc." },
    { { 0x00, 0x80, 0x79 }, "MicrobusDesi", "Microbus Designs Ltd." },
    { { 0x00, 0x80, 0x7A }, "Aitech",       "Aitech Systems Ltd." },
    { { 0x00, 0x80, 0x7B }, "ArtelCommuni", "Artel Communications Corp." },
    { { 0x00, 0x80, 0x7C }, "Fibercom",     "Fibercom, Inc." },
    { { 0x00, 0x80, 0x7D }, "Equinox",      "Equinox Systems Inc." },
    { { 0x00, 0x80, 0x7E }, "SouthernPaci", "Southern Pacific Ltd." },
    { { 0x00, 0x80, 0x7F }, "Dy4",          "Dy-4 Incorporated" },
    { { 0x00, 0x80, 0x80 }, "Datamedia",    "Datamedia Corporation" },
    { { 0x00, 0x80, 0x81 }, "KendallSquar", "Kendall Square Research Corp." },
    { { 0x00, 0x80, 0x82 }, "PepModularCo", "Pep Modular Computers Gmbh" },
    { { 0x00, 0x80, 0x83 }, "Amdahl",       "Amdahl" },
    { { 0x00, 0x80, 0x84 }, "Cloud",        "The Cloud Inc." },
    { { 0x00, 0x80, 0x85 }, "HThree",       "H-Three Systems Corporation" },
    { { 0x00, 0x80, 0x86 }, "ComputerGene", "Computer Generation Inc." },
    { { 0x00, 0x80, 0x87 }, "OkiElectricI", "Oki Electric Industry Co., Ltd" },
    { { 0x00, 0x80, 0x88 }, "VictorJapan",  "Victor Company Of Japan, Ltd." },
    { { 0x00, 0x80, 0x89 }, "Tecnetics",    "Tecnetics (Pty) Ltd." },
    { { 0x00, 0x80, 0x8A }, "SummitMicros", "Summit Microsystems Corp." },
    { { 0x00, 0x80, 0x8B }, "Dacoll",       "Dacoll Limited" },
    { { 0x00, 0x80, 0x8C }, "Netscout",     "Netscout Systems Inc" },
    { { 0x00, 0x80, 0x8D }, "WestcoastTec", "Westcoast Technology B.V." },
    { { 0x00, 0x80, 0x8E }, "RadstoneTech", "Radstone Technology" },
    { { 0x00, 0x80, 0x8F }, "CItohElectro", "C. Itoh Electronics, Inc." },
    { { 0x00, 0x80, 0x90 }, "MicrotekInte", "Microtek International, Inc." },
    { { 0x00, 0x80, 0x91 }, "TokyoElectri", "Tokyo Electric Co.,Ltd" },
    { { 0x00, 0x80, 0x92 }, "SilexTechnol", "Silex Technology, Inc." },
    { { 0x00, 0x80, 0x93 }, "Xyron",        "Xyron Corporation" },
    { { 0x00, 0x80, 0x94 }, "AlfaLavalAut", "Alfa Laval Automation Ab" },
    { { 0x00, 0x80, 0x95 }, "BasicMertonH", "Basic Merton Handelsges.M.B.H." },
    { { 0x00, 0x80, 0x96 }, "HumanDesigne", "Human Designed Systems, Inc." },
    { { 0x00, 0x80, 0x97 }, "CentralpAuto", "Centralp Automatismes" },
    { { 0x00, 0x80, 0x98 }, "Tdk",          "Tdk Corporation" },
    { { 0x00, 0x80, 0x99 }, "EatonIndustr", "Eaton Industries GmbH" },
    { { 0x00, 0x80, 0x9A }, "NovusNetwork", "Novus Networks Ltd" },
    { { 0x00, 0x80, 0x9B }, "Justsystem",   "Justsystem Corporation" },
    { { 0x00, 0x80, 0x9C }, "Luxcom",       "Luxcom, Inc." },
    { { 0x00, 0x80, 0x9D }, "Commscraft",   "Commscraft Ltd." },
    { { 0x00, 0x80, 0x9E }, "Datus",        "Datus Gmbh" },
    { { 0x00, 0x80, 0x9F }, "ALEInternati", "ALE International" },
    { { 0x00, 0x80, 0xA0 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x80, 0xA1 }, "Microtest",    "Microtest, Inc." },
    { { 0x00, 0x80, 0xA2 }, "CreativeElec", "Creative Electronic Systems" },
    { { 0x00, 0x80, 0xA3 }, "Lantronix",    "Lantronix" },
    { { 0x00, 0x80, 0xA4 }, "LibertyElect", "Liberty Electronics" },
    { { 0x00, 0x80, 0xA5 }, "SpeedInterna", "Speed International" },
    { { 0x00, 0x80, 0xA6 }, "RepublicTech", "Republic Technology, Inc." },
    { { 0x00, 0x80, 0xA7 }, "HoneywellInt", "Honeywell International Inc" },
    { { 0x00, 0x80, 0xA8 }, "Vitacom",      "Vitacom Corporation" },
    { { 0x00, 0x80, 0xA9 }, "ClearpointRe", "Clearpoint Research" },
    { { 0x00, 0x80, 0xAA }, "Maxpeed",      "Maxpeed" },
    { { 0x00, 0x80, 0xAB }, "DukaneNetwor", "Dukane Network Integration" },
    { { 0x00, 0x80, 0xAC }, "ImlogixDivis", "Imlogix, Division Of Genesys" },
    { { 0x00, 0x80, 0xAD }, "CnetTechnolo", "Cnet Technology, Inc." },
    { { 0x00, 0x80, 0xAE }, "HughesNetwor", "Hughes Network Systems" },
    { { 0x00, 0x80, 0xAF }, "Allumer",      "Allumer Co., Ltd." },
    { { 0x00, 0x80, 0xB0 }, "AdvancedInfo", "Advanced Information" },
    { { 0x00, 0x80, 0xB1 }, "Softcom",      "Softcom A/S" },
    { { 0x00, 0x80, 0xB2 }, "NetworkEquip", "Network Equipment Technologies" },
    { { 0x00, 0x80, 0xB3 }, "AvalData",     "Aval Data Corporation" },
    { { 0x00, 0x80, 0xB4 }, "Sophia",       "Sophia Systems" },
    { { 0x00, 0x80, 0xB5 }, "UnitedNetwor", "United Networks Inc." },
    { { 0x00, 0x80, 0xB6 }, "Mercury–Trus", "Mercury Systems – Trusted Mission Solutions, Inc." },
    { { 0x00, 0x80, 0xB7 }, "StellarCompu", "Stellar Computer" },
    { { 0x00, 0x80, 0xB8 }, "DMGMORIDigit", "DMG MORI Digital Co., LTD" },
    { { 0x00, 0x80, 0xB9 }, "ArcheTechnol", "Arche Technoligies Inc." },
    { { 0x00, 0x80, 0xBA }, "SpecialixPte", "Specialix (Asia) Pte, Ltd" },
    { { 0x00, 0x80, 0xBB }, "HughesLan",    "Hughes Lan Systems" },
    { { 0x00, 0x80, 0xBC }, "HitachiEngin", "Hitachi Engineering Co., Ltd" },
    { { 0x00, 0x80, 0xBD }, "FurukawaElec", "The Furukawa Electric Co., Ltd" },
    { { 0x00, 0x80, 0xBE }, "AriesResearc", "Aries Research" },
    { { 0x00, 0x80, 0xBF }, "TakaokaElect", "Takaoka Electric Mfg. Co. Ltd." },
    { { 0x00, 0x80, 0xC0 }, "PenrilDataco", "Penril Datacomm" },
    { { 0x00, 0x80, 0xC1 }, "Lanex",        "Lanex Corporation" },
    { { 0x00, 0x80, 0xC2 }, "IEEE8021Chai", "IEEE 802.1 Chair" },
    { { 0x00, 0x80, 0xC3 }, "BiccInformat", "Bicc Information Systems & Svc" },
    { { 0x00, 0x80, 0xC4 }, "DocumentTech", "Document Technologies, Inc." },
    { { 0x00, 0x80, 0xC5 }, "NovellcoDeMe", "Novellco De Mexico" },
    { { 0x00, 0x80, 0xC6 }, "NationalData", "National Datacomm Corporation" },
    { { 0x00, 0x80, 0xC7 }, "Xircom",       "Xircom" },
    { { 0x00, 0x80, 0xC8 }, "DLink",        "D-Link Systems, Inc." },
    { { 0x00, 0x80, 0xC9 }, "AlbertaMicro", "Alberta Microelectronic Centre" },
    { { 0x00, 0x80, 0xCA }, "NetcomResear", "Netcom Research Incorporated" },
    { { 0x00, 0x80, 0xCB }, "FalcoDataPro", "Falco Data Products" },
    { { 0x00, 0x80, 0xCC }, "MicrowaveByp", "Microwave Bypass Systems" },
    { { 0x00, 0x80, 0xCD }, "MicronicsCom", "Micronics Computer, Inc." },
    { { 0x00, 0x80, 0xCE }, "BroadcastTel", "Broadcast Television Systems" },
    { { 0x00, 0x80, 0xCF }, "EmbeddedPerf", "Embedded Performance Inc." },
    { { 0x00, 0x80, 0xD0 }, "ComputerPeri", "Computer Peripherals, Inc." },
    { { 0x00, 0x80, 0xD1 }, "Kimtron",      "Kimtron Corporation" },
    { { 0x00, 0x80, 0xD2 }, "Shinnihonden", "Shinnihondenko Co., Ltd." },
    { { 0x00, 0x80, 0xD3 }, "Shiva",        "Shiva Corp." },
    { { 0x00, 0x80, 0xD4 }, "ChaseResearc", "Chase Research Ltd." },
    { { 0x00, 0x80, 0xD5 }, "CadreTechnol", "Cadre Technologies" },
    { { 0x00, 0x80, 0xD6 }, "Nuvotech",     "Nuvotech, Inc." },
    { { 0x00, 0x80, 0xD7 }, "FantumEngine", "Fantum Engineering" },
    { { 0x00, 0x80, 0xD8 }, "NetworkPerip", "Network Peripherals Inc." },
    { { 0x00, 0x80, 0xD9 }, "EMKElektroni", "EMK Elektronik GmbH & Co. KG" },
    { { 0x00, 0x80, 0xDA }, "HottingerBrü", "Hottinger Brüel & Kjær A/S" },
    { { 0x00, 0x80, 0xDB }, "Graphon",      "Graphon Corporation" },
    { { 0x00, 0x80, 0xDC }, "PickerIntern", "Picker International" },
    { { 0x00, 0x80, 0xDD }, "GmxGimix",     "Gmx Inc/Gimix" },
    { { 0x00, 0x80, 0xDE }, "Gipsi",        "Gipsi S.A." },
    { { 0x00, 0x80, 0xDF }, "AdcCodenollT", "Adc Codenoll Technology Corp." },
    { { 0x00, 0x80, 0xE0 }, "Xtp",          "Xtp Systems, Inc." },
    { { 0x00, 0x80, 0xE1 }, "STMicroelect", "STMicroelectronics SRL" },
    { { 0x00, 0x80, 0xE2 }, "TDI",          "T.D.I. Co., Ltd." },
    { { 0x00, 0x80, 0xE3 }, "CoralNetwork", "Coral Network Corporation" },
    { { 0x00, 0x80, 0xE4 }, "NorthwestDig", "Northwest Digital Systems, Inc" },
    { { 0x00, 0x80, 0xE5 }, "NetApp",       "NetApp" },
    { { 0x00, 0x80, 0xE6 }, "PeerNetworks", "Peer Networks, Inc." },
    { { 0x00, 0x80, 0xE7 }, "LeonardoUK",   "Leonardo UK Ltd" },
    { { 0x00, 0x80, 0xE8 }, "CumulusCorpo", "Cumulus Corporatiion" },
    { { 0x00, 0x80, 0xE9 }, "Madge",        "Madge Ltd." },
    { { 0x00, 0x80, 0xEA }, "ADVAOpticalN", "ADVA Optical Networking Ltd." },
    { { 0x00, 0x80, 0xEB }, "Compcontrol",  "Compcontrol B.V." },
    { { 0x00, 0x80, 0xEC }, "Supercomputi", "Supercomputing Solutions, Inc." },
    { { 0x00, 0x80, 0xED }, "IqTechnologi", "Iq Technologies, Inc." },
    { { 0x00, 0x80, 0xEE }, "ThomsonCsf",   "Thomson Csf" },
    { { 0x00, 0x80, 0xEF }, "Rational",     "Rational" },
    { { 0x00, 0x80, 0xF0 }, "PanasonicCom", "Panasonic Communications Co., Ltd." },
    { { 0x00, 0x80, 0xF1 }, "Opus",         "Opus Systems" },
    { { 0x00, 0x80, 0xF2 }, "Raycom",       "Raycom Systems Inc" },
    { { 0x00, 0x80, 0xF3 }, "SunElectroni", "Sun Electronics Corp." },
    { { 0x00, 0x80, 0xF4 }, "Telemecaniqu", "Telemecanique Electrique" },
    { { 0x00, 0x80, 0xF5 }, "Quantel",      "Quantel Ltd" },
    { { 0x00, 0x80, 0xF6 }, "SynergyMicro", "Synergy Microsystems" },
    { { 0x00, 0x80, 0xF7 }, "ZenithElectr", "Zenith Electronics Corporation" },
    { { 0x00, 0x80, 0xF8 }, "Mizar",        "Mizar, Inc." },
    { { 0x00, 0x80, 0xF9 }, "Heurikon",     "Heurikon Corporation" },
    { { 0x00, 0x80, 0xFA }, "Rwt",          "Rwt Gmbh" },
    { { 0x00, 0x80, 0xFB }, "Bvm",          "Bvm Limited" },
    { { 0x00, 0x80, 0xFC }, "Avatar",       "Avatar Corporation" },
    { { 0x00, 0x80, 0xFD }, "ExsceedCorpr", "Exsceed Corpration" },
    { { 0x00, 0x80, 0xFE }, "AzureTechnol", "Azure Technologies, Inc." },
    { { 0x00, 0x80, 0xFF }, "SocDeTeleinf", "Soc. De Teleinformatique Rtc" },
    { { 0x00, 0x81, 0x2A }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x81, 0xC4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x81, 0xF9 }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0x83, 0x20 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0x84, 0x1E }, "CiscoMeraki",  "Cisco Meraki" },
    { { 0x00, 0x84, 0xED }, "LexmarkInter", "Lexmark International, Inc." },
    { { 0x00, 0x86, 0x9C }, "PaloAltoNetw", "Palo Alto Networks" },
    { { 0x00, 0x86, 0xA0 }, "Private",      "Private" },
    { { 0x00, 0x87, 0x01 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0x87, 0x31 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x87, 0x64 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x88, 0x65 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x88, 0xBA }, "Nc&C",         "Nc&C" },
    { { 0x00, 0x8A, 0x55 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0x8A, 0x76 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0x8A, 0x96 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x8B, 0x43 }, "Rftech",       "Rftech" },
    { { 0x00, 0x8B, 0xFC }, "mixi",         "mixi,Inc." },
    { { 0x00, 0x8C, 0x10 }, "BlackBox",     "Black Box Corp." },
    { { 0x00, 0x8C, 0x54 }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0x8C, 0xFA }, "Inventec",     "Inventec Corporation" },
    { { 0x00, 0x8D, 0x4E }, "CjscNiiStt",   "Cjsc Nii Stt" },
    { { 0x00, 0x8D, 0xDA }, "LinkOne",      "Link One Co., Ltd." },
    { { 0x00, 0x8E, 0x73 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x8E, 0xF2 }, "Netgear",      "Netgear" },
    { { 0x00, 0x90, 0x00 }, "DiamondMulti", "Diamond Multimedia" },
    { { 0x00, 0x90, 0x01 }, "NishimuElect", "Nishimu Electronics Industries Co., Ltd." },
    { { 0x00, 0x90, 0x02 }, "Allgon",       "Allgon Ab" },
    { { 0x00, 0x90, 0x03 }, "Aplio",        "Aplio" },
    { { 0x00, 0x90, 0x04 }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0x90, 0x05 }, "Protech",      "Protech Systems Co., Ltd." },
    { { 0x00, 0x90, 0x06 }, "HamamatsuPho", "Hamamatsu Photonics K.K." },
    { { 0x00, 0x90, 0x07 }, "DomexTechnol", "Domex Technology Corp." },
    { { 0x00, 0x90, 0x08 }, "HanA",         "HanA Systems Inc." },
    { { 0x00, 0x90, 0x09 }, "IControls",    "I Controls, Inc." },
    { { 0x00, 0x90, 0x0A }, "ProtonElectr", "Proton Electronic Industrial Co., Ltd." },
    { { 0x00, 0x90, 0x0B }, "LannerElectr", "Lanner Electronics, Inc." },
    { { 0x00, 0x90, 0x0C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x0D }, "OverlandStor", "Overland Storage Inc." },
    { { 0x00, 0x90, 0x0E }, "HandlinkTech", "Handlink Technologies, Inc." },
    { { 0x00, 0x90, 0x0F }, "KawasakiHeav", "Kawasaki Heavy Industries, Ltd" },
    { { 0x00, 0x90, 0x10 }, "SimulationLa", "Simulation Laboratories, Inc." },
    { { 0x00, 0x90, 0x11 }, "WAVTrace",     "WAVTrace, Inc." },
    { { 0x00, 0x90, 0x12 }, "GlobespanSem", "Globespan Semiconductor, Inc." },
    { { 0x00, 0x90, 0x13 }, "Samsan",       "Samsan Corp." },
    { { 0x00, 0x90, 0x14 }, "RotorkInstru", "Rotork Instruments, Ltd." },
    { { 0x00, 0x90, 0x15 }, "CentigramCom", "Centigram Communications Corp." },
    { { 0x00, 0x90, 0x16 }, "Zac",          "Zac" },
    { { 0x00, 0x90, 0x17 }, "Zypcom",       "Zypcom, Inc" },
    { { 0x00, 0x90, 0x18 }, "ItoElectricI", "Ito Electric Industry Co, Ltd." },
    { { 0x00, 0x90, 0x19 }, "HermesElectr", "Hermes Electronics Co., Ltd." },
    { { 0x00, 0x90, 0x1A }, "UnisphereSol", "Unisphere Solutions" },
    { { 0x00, 0x90, 0x1B }, "DigitalContr", "Digital Controls" },
    { { 0x00, 0x90, 0x1C }, "mpsSoftware",  "mps Software Gmbh" },
    { { 0x00, 0x90, 0x1D }, "Pec",          "Pec (Nz) Ltd." },
    { { 0x00, 0x90, 0x1E }, "SelestaIngeg", "Selesta Ingegneria S.p.A." },
    { { 0x00, 0x90, 0x1F }, "AdtecProduct", "Adtec Productions, Inc." },
    { { 0x00, 0x90, 0x20 }, "PhilipsAnaly", "Philips Analytical X-Ray B.V." },
    { { 0x00, 0x90, 0x21 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x22 }, "Ivex",         "Ivex" },
    { { 0x00, 0x90, 0x23 }, "Zilog",        "Zilog Inc." },
    { { 0x00, 0x90, 0x24 }, "Pipelinks",    "Pipelinks, Inc." },
    { { 0x00, 0x90, 0x25 }, "BAEAustralia", "BAE Systems Australia (Electronic Systems) Pty Ltd" },
    { { 0x00, 0x90, 0x26 }, "AdvancedSwit", "Advanced Switching Communications, Inc." },
    { { 0x00, 0x90, 0x27 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0x90, 0x28 }, "NipponSignal", "Nippon Signal Co., Ltd." },
    { { 0x00, 0x90, 0x29 }, "Crypto",       "Crypto Ag" },
    { { 0x00, 0x90, 0x2A }, "Communicatio", "Communication Devices, Inc." },
    { { 0x00, 0x90, 0x2B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x2C }, "DataControlE", "Data & Control Equipment Ltd." },
    { { 0x00, 0x90, 0x2D }, "DataElectron", "Data Electronics (Aust.) Pty, Ltd." },
    { { 0x00, 0x90, 0x2E }, "Namco",        "Namco Limited" },
    { { 0x00, 0x90, 0x2F }, "Netcore",      "Netcore Systems, Inc." },
    { { 0x00, 0x90, 0x30 }, "HoneywellDat", "Honeywell-Dating" },
    { { 0x00, 0x90, 0x31 }, "Mysticom",     "Mysticom, Ltd." },
    { { 0x00, 0x90, 0x32 }, "PelcombeGrou", "Pelcombe Group Ltd." },
    { { 0x00, 0x90, 0x33 }, "Innovaphone",  "Innovaphone Ag" },
    { { 0x00, 0x90, 0x34 }, "Imagic",       "Imagic, Inc." },
    { { 0x00, 0x90, 0x35 }, "AlphaTelecom", "Alpha Telecom, Inc." },
    { { 0x00, 0x90, 0x36 }, "ens",          "ens, inc." },
    { { 0x00, 0x90, 0x37 }, "Acucomm",      "Acucomm, Inc." },
    { { 0x00, 0x90, 0x38 }, "FountainTech", "Fountain Technologies, Inc." },
    { { 0x00, 0x90, 0x39 }, "ShastaNetwor", "Shasta Networks" },
    { { 0x00, 0x90, 0x3A }, "NihonMediaTo", "Nihon Media Tool Inc." },
    { { 0x00, 0x90, 0x3B }, "TriEMSResear", "TriEMS Research Lab, Inc." },
    { { 0x00, 0x90, 0x3C }, "AtlanticNetw", "Atlantic Network Systems" },
    { { 0x00, 0x90, 0x3D }, "Biopac",       "Biopac Systems, Inc." },
    { { 0x00, 0x90, 0x3E }, "NVPhilipsInd", "N.V. Philips Industrial Activities" },
    { { 0x00, 0x90, 0x3F }, "WorldCast",    "WorldCast Systems" },
    { { 0x00, 0x90, 0x40 }, "SiemensNetwo", "Siemens Network Convergence LLC" },
    { { 0x00, 0x90, 0x41 }, "AppliedDigit", "Applied Digital Access" },
    { { 0x00, 0x90, 0x42 }, "ECCS",         "ECCS, Inc." },
    { { 0x00, 0x90, 0x43 }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x90, 0x44 }, "AssuredDigit", "Assured Digital, Inc." },
    { { 0x00, 0x90, 0x45 }, "MarconiCommu", "Marconi Communications" },
    { { 0x00, 0x90, 0x46 }, "Dexdyne",      "Dexdyne, Ltd." },
    { { 0x00, 0x90, 0x47 }, "GigaFastE",    "Giga Fast E. Ltd." },
    { { 0x00, 0x90, 0x48 }, "Zeal",         "Zeal Corporation" },
    { { 0x00, 0x90, 0x49 }, "Entridia",     "Entridia Corporation" },
    { { 0x00, 0x90, 0x4A }, "ConcurSystem", "Concur System Technologies" },
    { { 0x00, 0x90, 0x4B }, "GemtekTechno", "Gemtek Technology Co., Ltd." },
    { { 0x00, 0x90, 0x4C }, "Epigram",      "Epigram, Inc." },
    { { 0x00, 0x90, 0x4D }, "Spec",         "Spec S.A." },
    { { 0x00, 0x90, 0x4E }, "Delem",        "Delem Bv" },
    { { 0x00, 0x90, 0x4F }, "AbbPowerT&D",  "Abb Power T&D Company, Inc." },
    { { 0x00, 0x90, 0x50 }, "Teleste",      "Teleste Corporation" },
    { { 0x00, 0x90, 0x51 }, "UltimateTech", "Ultimate Technology Corp." },
    { { 0x00, 0x90, 0x52 }, "SelcomElettr", "Selcom Elettronica S.R.L." },
    { { 0x00, 0x90, 0x53 }, "DaewooElectr", "Daewoo Electronics Co., Ltd." },
    { { 0x00, 0x90, 0x54 }, "InnovativeSe", "Innovative Semiconductors, Inc" },
    { { 0x00, 0x90, 0x55 }, "ParkerHannif", "Parker Hannifin Corporation Compumotor Division" },
    { { 0x00, 0x90, 0x56 }, "Telestream",   "Telestream, Inc." },
    { { 0x00, 0x90, 0x57 }, "AANetcom",     "AANetcom, Inc." },
    { { 0x00, 0x90, 0x58 }, "UltraElectro", "Ultra Electronics Command & Control Systems" },
    { { 0x00, 0x90, 0x59 }, "TelecomDevic", "Telecom Device K.K." },
    { { 0x00, 0x90, 0x5A }, "DearbornGrou", "Dearborn Group, Inc." },
    { { 0x00, 0x90, 0x5B }, "RaymondAndLa", "Raymond And Lae Engineering" },
    { { 0x00, 0x90, 0x5C }, "Edmi",         "Edmi" },
    { { 0x00, 0x90, 0x5D }, "NetcomSicher", "Netcom Sicherheitstechnik Gmbh" },
    { { 0x00, 0x90, 0x5E }, "RaulandBorg",  "Rauland-Borg Corporation" },
    { { 0x00, 0x90, 0x5F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x60 }, "SystemCreate", "System Create Corp." },
    { { 0x00, 0x90, 0x61 }, "PacificResea", "Pacific Research & Engineering Corporation" },
    { { 0x00, 0x90, 0x62 }, "ICPVORTEXCOM", "ICP VORTEX COMPUTERSYSTEME GmbH" },
    { { 0x00, 0x90, 0x63 }, "CoherentComm", "Coherent Communications Systems Corporation" },
    { { 0x00, 0x90, 0x64 }, "Thomson",      "Thomson Inc." },
    { { 0x00, 0x90, 0x65 }, "Finisar",      "Finisar Corporation" },
    { { 0x00, 0x90, 0x66 }, "TroikaNetwor", "Troika Networks, Inc." },
    { { 0x00, 0x90, 0x67 }, "WalkAboutCom", "WalkAbout Computers, Inc." },
    { { 0x00, 0x90, 0x68 }, "Dvt",          "Dvt Corp." },
    { { 0x00, 0x90, 0x69 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0x90, 0x6A }, "Turnstone",    "Turnstone Systems, Inc." },
    { { 0x00, 0x90, 0x6B }, "AppliedResou", "Applied Resources, Inc." },
    { { 0x00, 0x90, 0x6C }, "SartoriusHam", "Sartorius Hamburg GmbH" },
    { { 0x00, 0x90, 0x6D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x6E }, "Praxon",       "Praxon, Inc." },
    { { 0x00, 0x90, 0x6F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x70 }, "NeoNetworks",  "Neo Networks, Inc." },
    { { 0x00, 0x90, 0x71 }, "AppliedInnov", "Applied Innovation Inc." },
    { { 0x00, 0x90, 0x72 }, "SimradAs",     "Simrad As" },
    { { 0x00, 0x90, 0x73 }, "GaioTechnolo", "Gaio Technology" },
    { { 0x00, 0x90, 0x74 }, "ArgonNetwork", "Argon Networks, Inc." },
    { { 0x00, 0x90, 0x75 }, "NecDoBrasil",  "Nec Do Brasil S.A." },
    { { 0x00, 0x90, 0x76 }, "FmtAircraftG", "Fmt Aircraft Gate Support Systems Ab" },
    { { 0x00, 0x90, 0x77 }, "AdvancedFibr", "Advanced Fibre Communications" },
    { { 0x00, 0x90, 0x78 }, "MerTelemanag", "Mer Telemanagement Solutions, Ltd." },
    { { 0x00, 0x90, 0x79 }, "ClearOne",     "ClearOne, Inc." },
    { { 0x00, 0x90, 0x7A }, "Spectralink",  "Spectralink, Inc" },
    { { 0x00, 0x90, 0x7B }, "ETech",        "E-Tech, Inc." },
    { { 0x00, 0x90, 0x7C }, "Digitalcast",  "Digitalcast, Inc." },
    { { 0x00, 0x90, 0x7D }, "LakeCommunic", "Lake Communications" },
    { { 0x00, 0x90, 0x7E }, "Vetronix",     "Vetronix Corp." },
    { { 0x00, 0x90, 0x7F }, "WatchGuardTe", "WatchGuard Technologies, Inc." },
    { { 0x00, 0x90, 0x80 }, "Not",          "Not Limited, Inc." },
    { { 0x00, 0x90, 0x81 }, "AlohaNetwork", "Aloha Networks, Inc." },
    { { 0x00, 0x90, 0x82 }, "ForceInstitu", "Force Institute" },
    { { 0x00, 0x90, 0x83 }, "TurboCommuni", "Turbo Communication, Inc." },
    { { 0x00, 0x90, 0x84 }, "AtechSystem",  "Atech System" },
    { { 0x00, 0x90, 0x85 }, "GoldenEnterp", "Golden Enterprises, Inc." },
    { { 0x00, 0x90, 0x86 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x87 }, "Itis",         "Itis" },
    { { 0x00, 0x90, 0x88 }, "BaxallSecuri", "Baxall Security Ltd." },
    { { 0x00, 0x90, 0x89 }, "SoftcomMicro", "Softcom Microsystems, Inc." },
    { { 0x00, 0x90, 0x8A }, "BaylyCommuni", "Bayly Communications, Inc." },
    { { 0x00, 0x90, 0x8B }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0x90, 0x8C }, "EtrendElectr", "Etrend Electronics, Inc." },
    { { 0x00, 0x90, 0x8D }, "VickersElect", "Vickers Electronics Systems" },
    { { 0x00, 0x90, 0x8E }, "NortelNetwor", "Nortel Networks Broadband Access" },
    { { 0x00, 0x90, 0x8F }, "AudioCodes",   "Audio Codes Ltd." },
    { { 0x00, 0x90, 0x90 }, "IBus",         "I-Bus" },
    { { 0x00, 0x90, 0x91 }, "DigitalScape", "DigitalScape, Inc." },
    { { 0x00, 0x90, 0x92 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0x93 }, "EIZO",         "EIZO Corporation" },
    { { 0x00, 0x90, 0x94 }, "OspreyTechno", "Osprey Technologies, Inc." },
    { { 0x00, 0x90, 0x95 }, "UniversalAvi", "Universal Avionics" },
    { { 0x00, 0x90, 0x96 }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x00, 0x90, 0x97 }, "SycamoreNetw", "Sycamore Networks" },
    { { 0x00, 0x90, 0x98 }, "SbcDesigns",   "Sbc Designs, Inc." },
    { { 0x00, 0x90, 0x99 }, "AlliedTelesi", "Allied Telesis, K.K." },
    { { 0x00, 0x90, 0x9A }, "OneWorld",     "One World Systems, Inc." },
    { { 0x00, 0x90, 0x9B }, "MarkemImaje",  "Markem-Imaje" },
    { { 0x00, 0x90, 0x9C }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0x90, 0x9D }, "NovaTechProc", "NovaTech Process Solutions, LLC" },
    { { 0x00, 0x90, 0x9E }, "CriticalIO",   "Critical IO, LLC" },
    { { 0x00, 0x90, 0x9F }, "DigiData",     "Digi-Data Corporation" },
    { { 0x00, 0x90, 0xA0 }, "8X8",          "8X8 Inc." },
    { { 0x00, 0x90, 0xA1 }, "FlyingPigHig", "Flying Pig Systems/High End Systems Inc." },
    { { 0x00, 0x90, 0xA2 }, "CyberTANTech", "CyberTAN Technology Inc." },
    { { 0x00, 0x90, 0xA3 }, "Corecess",     "Corecess Inc." },
    { { 0x00, 0x90, 0xA4 }, "AltigaNetwor", "Altiga Networks" },
    { { 0x00, 0x90, 0xA5 }, "SpectraLogic", "Spectra Logic" },
    { { 0x00, 0x90, 0xA6 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0xA7 }, "Clientec",     "Clientec Corporation" },
    { { 0x00, 0x90, 0xA8 }, "NineTilesNet", "NineTiles Networks, Ltd." },
    { { 0x00, 0x90, 0xA9 }, "WesternDigit", "Western Digital" },
    { { 0x00, 0x90, 0xAA }, "IndigoActive", "Indigo Active Vision Systems Limited" },
    { { 0x00, 0x90, 0xAB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0xAC }, "Optivision",   "Optivision, Inc." },
    { { 0x00, 0x90, 0xAD }, "AspectElectr", "Aspect Electronics, Inc." },
    { { 0x00, 0x90, 0xAE }, "ITALTELRFUPI", "ITALTEL S.p.A/RF-UP-I" },
    { { 0x00, 0x90, 0xAF }, "JMoritaMfg",   "J. Morita Mfg. Corp." },
    { { 0x00, 0x90, 0xB0 }, "Vadem",        "Vadem" },
    { { 0x00, 0x90, 0xB1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0xB2 }, "Avici",        "Avici Systems Inc." },
    { { 0x00, 0x90, 0xB3 }, "Agranat",      "Agranat Systems" },
    { { 0x00, 0x90, 0xB4 }, "WillowbrookT", "Willowbrook Technologies" },
    { { 0x00, 0x90, 0xB5 }, "Nikon",        "Nikon Corporation" },
    { { 0x00, 0x90, 0xB6 }, "Fibex",        "Fibex Systems" },
    { { 0x00, 0x90, 0xB7 }, "DigitalLight", "Digital Lightwave, Inc." },
    { { 0x00, 0x90, 0xB8 }, "RohdeSchwarz", "Rohde & Schwarz Gmbh & Co. Kg" },
    { { 0x00, 0x90, 0xB9 }, "BeranInstrum", "Beran Instruments Ltd." },
    { { 0x00, 0x90, 0xBA }, "ValidNetwork", "Valid Networks, Inc." },
    { { 0x00, 0x90, 0xBB }, "TAINETCOMMUN", "TAINET COMMUNICATION SYSTEM Corp." },
    { { 0x00, 0x90, 0xBC }, "Telemann",     "Telemann Co., Ltd." },
    { { 0x00, 0x90, 0xBD }, "OmniaCommuni", "Omnia Communications, Inc." },
    { { 0x00, 0x90, 0xBE }, "IbcIntegrate", "Ibc/Integrated Business Computers" },
    { { 0x00, 0x90, 0xBF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0xC0 }, "KJLawEnginee", "K.J. Law Engineers, Inc." },
    { { 0x00, 0x90, 0xC1 }, "PecoII",       "Peco II, Inc." },
    { { 0x00, 0x90, 0xC2 }, "JKmicrosyste", "JK microsystems, Inc." },
    { { 0x00, 0x90, 0xC3 }, "TopicSemicon", "Topic Semiconductor Corp." },
    { { 0x00, 0x90, 0xC4 }, "Javelin",      "Javelin Systems, Inc." },
    { { 0x00, 0x90, 0xC5 }, "InternetMagi", "Internet Magic, Inc." },
    { { 0x00, 0x90, 0xC6 }, "Optim",        "Optim Systems, Inc." },
    { { 0x00, 0x90, 0xC7 }, "Icom",         "Icom Inc." },
    { { 0x00, 0x90, 0xC8 }, "WaveriderCom", "Waverider Communications (Canada) Inc." },
    { { 0x00, 0x90, 0xC9 }, "DPACTechnolo", "DPAC Technologies" },
    { { 0x00, 0x90, 0xCA }, "AccordVideoT", "Accord Video Telecommunications, Ltd." },
    { { 0x00, 0x90, 0xCB }, "WirelessOnLi", "Wireless OnLine, Inc." },
    { { 0x00, 0x90, 0xCC }, "PlanexCommun", "Planex Communications Inc." },
    { { 0x00, 0x90, 0xCD }, "EntEmpresaNa", "Ent-Empresa Nacional De Telecommunicacoes, S.A." },
    { { 0x00, 0x90, 0xCE }, "avateramedic", "avateramedical Mechatronics GmbH" },
    { { 0x00, 0x90, 0xCF }, "Nortel",       "Nortel" },
    { { 0x00, 0x90, 0xD0 }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x00, 0x90, 0xD1 }, "LeichuEnterp", "Leichu Enterprise Co., Ltd." },
    { { 0x00, 0x90, 0xD2 }, "ArtelVideo",   "Artel Video Systems" },
    { { 0x00, 0x90, 0xD3 }, "GIESECKEDEVR", "GIESECKE & DEVRIENT GmbH" },
    { { 0x00, 0x90, 0xD4 }, "BindViewDeve", "BindView Development Corp." },
    { { 0x00, 0x90, 0xD5 }, "Euphonix",     "Euphonix, Inc." },
    { { 0x00, 0x90, 0xD6 }, "CrystalGroup", "Crystal Group, Inc." },
    { { 0x00, 0x90, 0xD7 }, "NetBoost",     "NetBoost Corp." },
    { { 0x00, 0x90, 0xD8 }, "Whitecross",   "Whitecross Systems" },
    { { 0x00, 0x90, 0xD9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0xDA }, "Dynarc",       "Dynarc, Inc." },
    { { 0x00, 0x90, 0xDB }, "NextLevelCom", "Next Level Communications" },
    { { 0x00, 0x90, 0xDC }, "TecoInformat", "Teco Information Systems" },
    { { 0x00, 0x90, 0xDD }, "MIHARUCOMMUN", "MIHARU COMMUNICATIONS Inc" },
    { { 0x00, 0x90, 0xDE }, "Cardkey",      "Cardkey Systems, Inc." },
    { { 0x00, 0x90, 0xDF }, "MitsubishiCh", "Mitsubishi Chemical America, Inc." },
    { { 0x00, 0x90, 0xE0 }, "Systran",      "Systran Corp." },
    { { 0x00, 0x90, 0xE1 }, "Telena",       "Telena S.P.A." },
    { { 0x00, 0x90, 0xE2 }, "DistributedP", "Distributed Processing Technology" },
    { { 0x00, 0x90, 0xE3 }, "AvexElectron", "Avex Electronics Inc." },
    { { 0x00, 0x90, 0xE4 }, "NecAmerica",   "Nec America, Inc." },
    { { 0x00, 0x90, 0xE5 }, "Teknema",      "Teknema, Inc." },
    { { 0x00, 0x90, 0xE6 }, "ALi",          "ALi Corporation" },
    { { 0x00, 0x90, 0xE7 }, "HorschElektr", "Horsch Elektronik Ag" },
    { { 0x00, 0x90, 0xE8 }, "MoxaTechnolo", "Moxa Technologies Corp., Ltd." },
    { { 0x00, 0x90, 0xE9 }, "JanzComputer", "Janz Computer Ag" },
    { { 0x00, 0x90, 0xEA }, "AlphaTechnol", "Alpha Technologies, Inc." },
    { { 0x00, 0x90, 0xEB }, "SentryTeleco", "Sentry Telecom Systems" },
    { { 0x00, 0x90, 0xEC }, "Pyrescom",     "Pyrescom" },
    { { 0x00, 0x90, 0xED }, "CentralSyste", "Central System Research Co., Ltd." },
    { { 0x00, 0x90, 0xEE }, "PersonalComm", "Personal Communications Technologies" },
    { { 0x00, 0x90, 0xEF }, "Integrix",     "Integrix, Inc." },
    { { 0x00, 0x90, 0xF0 }, "HarmonicVide", "Harmonic Video Systems Ltd." },
    { { 0x00, 0x90, 0xF1 }, "SeagateCloud", "Seagate Cloud Systems Inc" },
    { { 0x00, 0x90, 0xF2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x90, 0xF3 }, "AspectCommun", "Aspect Communications" },
    { { 0x00, 0x90, 0xF4 }, "LightningIns", "Lightning Instrumentation" },
    { { 0x00, 0x90, 0xF5 }, "Clevo",        "Clevo Co." },
    { { 0x00, 0x90, 0xF6 }, "EscalateNetw", "Escalate Networks, Inc." },
    { { 0x00, 0x90, 0xF7 }, "NbaseCommuni", "Nbase Communications Ltd." },
    { { 0x00, 0x90, 0xF8 }, "MediatrixTel", "Mediatrix Telecom" },
    { { 0x00, 0x90, 0xF9 }, "ImagineCommu", "Imagine Communications" },
    { { 0x00, 0x90, 0xFA }, "Emulex",       "Emulex Corporation" },
    { { 0x00, 0x90, 0xFB }, "Portwell",     "Portwell, Inc." },
    { { 0x00, 0x90, 0xFC }, "NetworkCompu", "Network Computing Devices" },
    { { 0x00, 0x90, 0xFD }, "CopperCom",    "CopperCom, Inc." },
    { { 0x00, 0x90, 0xFE }, "Elecom",       "Elecom Co., Ltd. (Laneed Div.)" },
    { { 0x00, 0x90, 0xFF }, "TellusTechno", "Tellus Technology Inc." },
    { { 0x00, 0x91, 0x9E }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x91, 0xD6 }, "CrystalGroup", "Crystal Group, Inc." },
    { { 0x00, 0x91, 0xEB }, "RenesasElect", "Renesas Electronics (Penang) Sdn. Bhd." },
    { { 0x00, 0x91, 0xFA }, "SynapseProdu", "Synapse Product Development" },
    { { 0x00, 0x92, 0x7D }, "FicosaIntern", "Ficosa Internationa(Taicang) C0.,Ltd." },
    { { 0x00, 0x92, 0xA5 }, "LGInnotek",    "LG Innotek" },
    { { 0x00, 0x92, 0xFA }, "WiskyTechnol", "Shenzhen Wisky Technology Co.,Ltd" },
    { { 0x00, 0x93, 0x37 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0x93, 0x63 }, "UniLinkTechn", "Uni-Link Technology Co., Ltd." },
    { { 0x00, 0x94, 0xA1 }, "F5Networks",   "F5 Networks, Inc." },
    { { 0x00, 0x94, 0xEC }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0x95, 0x69 }, "LSDSciencean", "LSD Science and Technology Co.,Ltd." },
    { { 0x00, 0x97, 0xFF }, "HeimannSenso", "Heimann Sensor GmbH" },
    { { 0x00, 0x99, 0x1D }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x9A, 0xCD }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0x9A, 0xD2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x9C, 0x02 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x00, 0x9C, 0xC0 }, "vivoMobileCo", "vivo Mobile Communication Co., Ltd." },
    { { 0x00, 0x9D, 0x6B }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0x9D, 0x8E }, "CardiacRecor", "Cardiac Recorders, Inc." },
    { { 0x00, 0x9E, 0x1E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0x9E, 0xC8 }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x00, 0x9E, 0xEE }, "PositivoTecn", "Positivo Tecnologia S.A." },
    { { 0x00, 0xA0, 0x00 }, "CentillionNe", "Centillion Networks, Inc." },
    { { 0x00, 0xA0, 0x01 }, "DRSSignalSol", "DRS Signal Solutions" },
    { { 0x00, 0xA0, 0x02 }, "LeedsNorthru", "Leeds & Northrup Australia Pty Ltd" },
    { { 0x00, 0xA0, 0x03 }, "SiemensSwitz", "Siemens Switzerland Ltd., I B T HVP" },
    { { 0x00, 0xA0, 0x04 }, "Netpower",     "Netpower, Inc." },
    { { 0x00, 0xA0, 0x05 }, "DanielInstru", "Daniel Instruments, Ltd." },
    { { 0x00, 0xA0, 0x06 }, "ImageDataPro", "Image Data Processing System Group" },
    { { 0x00, 0xA0, 0x07 }, "ApexxTechnol", "Apexx Technology, Inc." },
    { { 0x00, 0xA0, 0x08 }, "Netcorp",      "Netcorp" },
    { { 0x00, 0xA0, 0x09 }, "WhitetreeNet", "Whitetree Network" },
    { { 0x00, 0xA0, 0x0A }, "Airspan",      "Airspan" },
    { { 0x00, 0xA0, 0x0B }, "Computex",     "Computex Co., Ltd." },
    { { 0x00, 0xA0, 0x0C }, "KingmaxTechn", "Kingmax Technology, Inc." },
    { { 0x00, 0xA0, 0x0D }, "PandaProject", "The Panda Project" },
    { { 0x00, 0xA0, 0x0E }, "Netscout",     "Netscout Systems Inc" },
    { { 0x00, 0xA0, 0x0F }, "BroadbandTec", "Broadband Technologies" },
    { { 0x00, 0xA0, 0x10 }, "SyslogicDate", "Syslogic Datentechnik Ag" },
    { { 0x00, 0xA0, 0x11 }, "MutohIndustr", "Mutoh Industries Ltd." },
    { { 0x00, 0xA0, 0x12 }, "Telco",        "Telco Systems, Inc." },
    { { 0x00, 0xA0, 0x13 }, "Teltrend",     "Teltrend Ltd." },
    { { 0x00, 0xA0, 0x14 }, "Csir",         "Csir" },
    { { 0x00, 0xA0, 0x15 }, "Wyle",         "Wyle" },
    { { 0x00, 0xA0, 0x16 }, "Micropolis",   "Micropolis Corp." },
    { { 0x00, 0xA0, 0x17 }, "JBM",          "J B M Corporation" },
    { { 0x00, 0xA0, 0x18 }, "CreativeCont", "Creative Controllers, Inc." },
    { { 0x00, 0xA0, 0x19 }, "NebulaConsul", "Nebula Consultants, Inc." },
    { { 0x00, 0xA0, 0x1A }, "BinarElektro", "Binar Elektronik Ab" },
    { { 0x00, 0xA0, 0x1B }, "DZS",          "DZS Inc." },
    { { 0x00, 0xA0, 0x1C }, "NascentNetwo", "Nascent Networks Corporation" },
    { { 0x00, 0xA0, 0x1D }, "RedLionContr", "Red Lion Controls, LP" },
    { { 0x00, 0xA0, 0x1E }, "Est",          "Est Corporation" },
    { { 0x00, 0xA0, 0x1F }, "Tricord",      "Tricord Systems, Inc." },
    { { 0x00, 0xA0, 0x20 }, "CiticorpTti",  "Citicorp/Tti" },
    { { 0x00, 0xA0, 0x21 }, "GeneralDynam", "General Dynamics Mission Systems" },
    { { 0x00, 0xA0, 0x22 }, "CentreForDev", "Centre For Development Of Advanced Computing" },
    { { 0x00, 0xA0, 0x23 }, "AppliedCreat", "Applied Creative Technology, Inc." },
    { { 0x00, 0xA0, 0x24 }, "3Com",         "3Com" },
    { { 0x00, 0xA0, 0x25 }, "RedcomLabs",   "Redcom Labs Inc." },
    { { 0x00, 0xA0, 0x26 }, "Teldat",       "Teldat, S.A." },
    { { 0x00, 0xA0, 0x27 }, "Firepower",    "Firepower Systems, Inc." },
    { { 0x00, 0xA0, 0x28 }, "ConnerPeriph", "Conner Peripherals" },
    { { 0x00, 0xA0, 0x29 }, "Coulter",      "Coulter Corporation" },
    { { 0x00, 0xA0, 0x2A }, "Trancell",     "Trancell Systems" },
    { { 0x00, 0xA0, 0x2B }, "TransitionsR", "Transitions Research Corp." },
    { { 0x00, 0xA0, 0x2C }, "interWAVECom", "interWAVE Communications" },
    { { 0x00, 0xA0, 0x2D }, "1394TradeAss", "1394 Trade Association" },
    { { 0x00, 0xA0, 0x2E }, "BrandCommuni", "Brand Communications, Ltd." },
    { { 0x00, 0xA0, 0x2F }, "ADBBroadband", "ADB Broadband Italia" },
    { { 0x00, 0xA0, 0x30 }, "Captor",       "Captor Nv/Sa" },
    { { 0x00, 0xA0, 0x31 }, "HazeltineMs1", "Hazeltine Corporation, Ms 1-17" },
    { { 0x00, 0xA0, 0x32 }, "GesSingapore", "Ges Singapore Pte. Ltd." },
    { { 0x00, 0xA0, 0x33 }, "imcMeBsystem", "imc MeBsysteme GmbH" },
    { { 0x00, 0xA0, 0x34 }, "Axel",         "Axel" },
    { { 0x00, 0xA0, 0x35 }, "Cylink",       "Cylink Corporation" },
    { { 0x00, 0xA0, 0x36 }, "AppliedNetwo", "Applied Network Technology" },
    { { 0x00, 0xA0, 0x37 }, "MindrayDSUSA", "Mindray DS USA, Inc." },
    { { 0x00, 0xA0, 0x38 }, "EmailElectro", "Email Electronics" },
    { { 0x00, 0xA0, 0x39 }, "RossTechnolo", "Ross Technology, Inc." },
    { { 0x00, 0xA0, 0x3A }, "Kubotek",      "Kubotek Corporation" },
    { { 0x00, 0xA0, 0x3B }, "ToshinElectr", "Toshin Electric Co., Ltd." },
    { { 0x00, 0xA0, 0x3C }, "Eg&GNuclearI", "Eg&G Nuclear Instruments" },
    { { 0x00, 0xA0, 0x3D }, "Opto22",       "Opto-22" },
    { { 0x00, 0xA0, 0x3E }, "AtmForum",     "Atm Forum" },
    { { 0x00, 0xA0, 0x3F }, "ComputerSoci", "Computer Society Microprocessor & Microprocessor Standards C" },
    { { 0x00, 0xA0, 0x40 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xA0, 0x41 }, "Inficon",      "Inficon" },
    { { 0x00, 0xA0, 0x42 }, "SpurProducts", "Spur Products Corp." },
    { { 0x00, 0xA0, 0x43 }, "AmericanTech", "American Technology Labs, Inc." },
    { { 0x00, 0xA0, 0x44 }, "NttIt",        "Ntt It Co., Ltd." },
    { { 0x00, 0xA0, 0x45 }, "PHOENIXCONTA", "PHOENIX CONTACT Electronics GmbH" },
    { { 0x00, 0xA0, 0x46 }, "Scitex",       "Scitex Corp. Ltd." },
    { { 0x00, 0xA0, 0x47 }, "IntegratedFi", "Integrated Fitness Corp." },
    { { 0x00, 0xA0, 0x48 }, "Questech",     "Questech, Ltd." },
    { { 0x00, 0xA0, 0x49 }, "DigitechIndu", "Digitech Industries, Inc." },
    { { 0x00, 0xA0, 0x4A }, "NisshinElect", "Nisshin Electric Co., Ltd." },
    { { 0x00, 0xA0, 0x4B }, "TflLan",       "Tfl Lan Inc." },
    { { 0x00, 0xA0, 0x4C }, "InnovativeTe", "Innovative Systems & Technologies, Inc." },
    { { 0x00, 0xA0, 0x4D }, "EdaInstrumen", "Eda Instruments, Inc." },
    { { 0x00, 0xA0, 0x4E }, "VoelkerTechn", "Voelker Technologies, Inc." },
    { { 0x00, 0xA0, 0x4F }, "Ameritec",     "Ameritec Corp." },
    { { 0x00, 0xA0, 0x50 }, "CypressSemic", "Cypress Semiconductor" },
    { { 0x00, 0xA0, 0x51 }, "AngiaCommuni", "Angia Communications. Inc." },
    { { 0x00, 0xA0, 0x52 }, "StaniliteEle", "Stanilite Electronics Pty. Ltd" },
    { { 0x00, 0xA0, 0x53 }, "CompactDevic", "Compact Devices, Inc." },
    { { 0x00, 0xA0, 0x54 }, "Private",      "Private" },
    { { 0x00, 0xA0, 0x55 }, "DataDevice",   "Data Device Corporation" },
    { { 0x00, 0xA0, 0x56 }, "Micropross",   "Micropross" },
    { { 0x00, 0xA0, 0x57 }, "LANCOM",       "LANCOM Systems GmbH" },
    { { 0x00, 0xA0, 0x58 }, "Glory",        "Glory, Ltd." },
    { { 0x00, 0xA0, 0x59 }, "HamiltonHall", "Hamilton Hallmark" },
    { { 0x00, 0xA0, 0x5A }, "KofaxImagePr", "Kofax Image Products" },
    { { 0x00, 0xA0, 0x5B }, "Marquip",      "Marquip, Inc." },
    { { 0x00, 0xA0, 0x5C }, "InventoryCon", "Inventory Conversion, Inc./" },
    { { 0x00, 0xA0, 0x5D }, "CSCOMPUTERSY", "CS COMPUTER SYSTEME GmbH" },
    { { 0x00, 0xA0, 0x5E }, "MyriadLogic",  "Myriad Logic Inc." },
    { { 0x00, 0xA0, 0x5F }, "BTGElectroni", "BTG Electronics Design BV" },
    { { 0x00, 0xA0, 0x60 }, "AcerPeripher", "Acer Peripherals, Inc." },
    { { 0x00, 0xA0, 0x61 }, "PuritanBenne", "Puritan Bennett" },
    { { 0x00, 0xA0, 0x62 }, "AesProdata",   "Aes Prodata" },
    { { 0x00, 0xA0, 0x63 }, "Jrl",          "Jrl Systems, Inc." },
    { { 0x00, 0xA0, 0x64 }, "KvbAnalect",   "Kvb/Analect" },
    { { 0x00, 0xA0, 0x65 }, "Symantec",     "Symantec Corporation" },
    { { 0x00, 0xA0, 0x66 }, "Isa",          "Isa Co., Ltd." },
    { { 0x00, 0xA0, 0x67 }, "NetworkServi", "Network Services Group" },
    { { 0x00, 0xA0, 0x68 }, "Bhp",          "Bhp Limited" },
    { { 0x00, 0xA0, 0x69 }, "Symmetricom",  "Symmetricom, Inc." },
    { { 0x00, 0xA0, 0x6A }, "Verilink",     "Verilink Corporation" },
    { { 0x00, 0xA0, 0x6B }, "DmsDorschMik", "Dms Dorsch Mikrosystem Gmbh" },
    { { 0x00, 0xA0, 0x6C }, "ShindengenEl", "Shindengen Electric Mfg. Co., Ltd." },
    { { 0x00, 0xA0, 0x6D }, "MannesmannTa", "Mannesmann Tally Corporation" },
    { { 0x00, 0xA0, 0x6E }, "Austron",      "Austron, Inc." },
    { { 0x00, 0xA0, 0x6F }, "ColorSentine", "Color Sentinel Systems, LLC" },
    { { 0x00, 0xA0, 0x70 }, "Coastcom",     "Coastcom" },
    { { 0x00, 0xA0, 0x71 }, "VideoLottery", "Video Lottery Technologies,Inc" },
    { { 0x00, 0xA0, 0x72 }, "Ovation",      "Ovation Systems Ltd." },
    { { 0x00, 0xA0, 0x73 }, "Com21",        "Com21, Inc." },
    { { 0x00, 0xA0, 0x74 }, "PerceptionTe", "Perception Technology" },
    { { 0x00, 0xA0, 0x75 }, "MicronTechno", "Micron Technology, Inc." },
    { { 0x00, 0xA0, 0x76 }, "CardwareLab",  "Cardware Lab, Inc." },
    { { 0x00, 0xA0, 0x77 }, "FujitsuNexio", "Fujitsu Nexion, Inc." },
    { { 0x00, 0xA0, 0x78 }, "MarconiCommu", "Marconi Communications" },
    { { 0x00, 0xA0, 0x79 }, "AlpsElectric", "Alps Electric (Usa), Inc." },
    { { 0x00, 0xA0, 0x7A }, "AdvancedPeri", "Advanced Peripherals Technologies, Inc." },
    { { 0x00, 0xA0, 0x7B }, "DawnComputer", "Dawn Computer Incorporation" },
    { { 0x00, 0xA0, 0x7C }, "TonyangNylon", "Tonyang Nylon Co., Ltd." },
    { { 0x00, 0xA0, 0x7D }, "SeeqTechnolo", "Seeq Technology, Inc." },
    { { 0x00, 0xA0, 0x7E }, "AvidTechnolo", "Avid Technology, Inc." },
    { { 0x00, 0xA0, 0x7F }, "GsmSyntel",    "Gsm-Syntel, Ltd." },
    { { 0x00, 0xA0, 0x80 }, "Tattile",      "Tattile SRL" },
    { { 0x00, 0xA0, 0x81 }, "AlcatelDataN", "Alcatel Data Networks" },
    { { 0x00, 0xA0, 0x82 }, "NktElektroni", "Nkt Elektronik A/S" },
    { { 0x00, 0xA0, 0x83 }, "AsimmphonyTu", "Asimmphony Turkey" },
    { { 0x00, 0xA0, 0x84 }, "Dataplex",     "Dataplex Pty Ltd" },
    { { 0x00, 0xA0, 0x85 }, "Private",      "Private" },
    { { 0x00, 0xA0, 0x86 }, "AmberWave",    "Amber Wave Systems, Inc." },
    { { 0x00, 0xA0, 0x87 }, "Microsemi",    "Microsemi Corporation" },
    { { 0x00, 0xA0, 0x88 }, "EssentialCom", "Essential Communications" },
    { { 0x00, 0xA0, 0x89 }, "XpointTechno", "Xpoint Technologies, Inc." },
    { { 0x00, 0xA0, 0x8A }, "BrooktroutTe", "Brooktrout Technology, Inc." },
    { { 0x00, 0xA0, 0x8B }, "AstonElectro", "Aston Electronic Designs Ltd." },
    { { 0x00, 0xA0, 0x8C }, "MultiMediaLA", "MultiMedia LANs, Inc." },
    { { 0x00, 0xA0, 0x8D }, "Jacomo",       "Jacomo Corporation" },
    { { 0x00, 0xA0, 0x8E }, "CheckPointSo", "Check Point Software Technologies" },
    { { 0x00, 0xA0, 0x8F }, "Desknet",      "Desknet Systems, Inc." },
    { { 0x00, 0xA0, 0x90 }, "TimeStep",     "TimeStep Corporation" },
    { { 0x00, 0xA0, 0x91 }, "ApplicomInte", "Applicom International" },
    { { 0x00, 0xA0, 0x92 }, "HBollmannMan", "H. Bollmann Manufacturers, Ltd" },
    { { 0x00, 0xA0, 0x93 }, "BEAEROSPACE",  "B/E AEROSPACE, Inc." },
    { { 0x00, 0xA0, 0x94 }, "Comsat",       "Comsat Corporation" },
    { { 0x00, 0xA0, 0x95 }, "AcaciaNetwor", "Acacia Networks, Inc." },
    { { 0x00, 0xA0, 0x96 }, "MitsumiElect", "Mitsumi Electric Co.,Ltd." },
    { { 0x00, 0xA0, 0x97 }, "JcInformatio", "Jc Information Systems" },
    { { 0x00, 0xA0, 0x98 }, "NetApp",       "NetApp" },
    { { 0x00, 0xA0, 0x99 }, "KNet",         "K-Net Ltd." },
    { { 0x00, 0xA0, 0x9A }, "NihonKohdenA", "Nihon Kohden America" },
    { { 0x00, 0xA0, 0x9B }, "QpsxCommunic", "Qpsx Communications, Ltd." },
    { { 0x00, 0xA0, 0x9C }, "Xyplex",       "Xyplex, Inc." },
    { { 0x00, 0xA0, 0x9D }, "JohnathonFre", "Johnathon Freeman Technologies" },
    { { 0x00, 0xA0, 0x9E }, "Ictv",         "Ictv" },
    { { 0x00, 0xA0, 0x9F }, "Commvision",   "Commvision Corp." },
    { { 0x00, 0xA0, 0xA0 }, "CompactData",  "Compact Data, Ltd." },
    { { 0x00, 0xA0, 0xA1 }, "EpicData",     "Epic Data Inc." },
    { { 0x00, 0xA0, 0xA2 }, "B810",         "B810 S.R.L." },
    { { 0x00, 0xA0, 0xA3 }, "ReliablePowe", "Reliable Power Meters" },
    { { 0x00, 0xA0, 0xA4 }, "Oracle",       "Oracle Corporation" },
    { { 0x00, 0xA0, 0xA5 }, "TeknorMicros", "Teknor Microsysteme, Inc." },
    { { 0x00, 0xA0, 0xA6 }, "MI",           "M.I. Systems, K.K." },
    { { 0x00, 0xA0, 0xA7 }, "Vorax",        "Vorax Corporation" },
    { { 0x00, 0xA0, 0xA8 }, "Renex",        "Renex Corporation" },
    { { 0x00, 0xA0, 0xA9 }, "NavtelCommun", "Navtel Communications Inc." },
    { { 0x00, 0xA0, 0xAA }, "SpacelabsMed", "Spacelabs Medical" },
    { { 0x00, 0xA0, 0xAB }, "NetcsInforma", "Netcs Informationstechnik Gmbh" },
    { { 0x00, 0xA0, 0xAC }, "GilatSatelli", "Gilat Satellite Networks, Ltd." },
    { { 0x00, 0xA0, 0xAD }, "Marconi",      "Marconi Spa" },
    { { 0x00, 0xA0, 0xAE }, "Nucom",        "Nucom Systems, Inc." },
    { { 0x00, 0xA0, 0xAF }, "WmsIndustrie", "Wms Industries" },
    { { 0x00, 0xA0, 0xB0 }, "IODataDevice", "I-O Data Device,Inc." },
    { { 0x00, 0xA0, 0xB1 }, "FirstVirtual", "First Virtual Corporation" },
    { { 0x00, 0xA0, 0xB2 }, "ShimaSeiki",   "Shima Seiki" },
    { { 0x00, 0xA0, 0xB3 }, "Zykronix",     "Zykronix" },
    { { 0x00, 0xA0, 0xB4 }, "TexasMicrosy", "Texas Microsystems, Inc." },
    { { 0x00, 0xA0, 0xB5 }, "3HTechnology", "3H Technology" },
    { { 0x00, 0xA0, 0xB6 }, "SanritzAutom", "Sanritz Automation Co., Ltd." },
    { { 0x00, 0xA0, 0xB7 }, "Cordant",      "Cordant, Inc." },
    { { 0x00, 0xA0, 0xB8 }, "NetApp",       "NetApp" },
    { { 0x00, 0xA0, 0xB9 }, "EagleTechnol", "Eagle Technology, Inc." },
    { { 0x00, 0xA0, 0xBA }, "PattonElectr", "Patton Electronics Co." },
    { { 0x00, 0xA0, 0xBB }, "Hilan",        "Hilan Gmbh" },
    { { 0x00, 0xA0, 0xBC }, "Viasat",       "Viasat, Incorporated" },
    { { 0x00, 0xA0, 0xBD }, "ITech",        "I-Tech Corp." },
    { { 0x00, 0xA0, 0xBE }, "IntegratedCi", "Integrated Circuit Systems, Inc. Communications Group" },
    { { 0x00, 0xA0, 0xBF }, "WirelessData", "Wireless Data Group Motorola" },
    { { 0x00, 0xA0, 0xC0 }, "DigitalLink",  "Digital Link Corp." },
    { { 0x00, 0xA0, 0xC1 }, "OrtivusMedic", "Ortivus Medical Ab" },
    { { 0x00, 0xA0, 0xC2 }, "RA",           "R.A. Systems Co., Ltd." },
    { { 0x00, 0xA0, 0xC3 }, "Unicomputer",  "Unicomputer Gmbh" },
    { { 0x00, 0xA0, 0xC4 }, "CristieElect", "Cristie Electronics Ltd." },
    { { 0x00, 0xA0, 0xC5 }, "ZyxelCommuni", "Zyxel Communications Corporation" },
    { { 0x00, 0xA0, 0xC6 }, "Qualcomm",     "Qualcomm Inc." },
    { { 0x00, 0xA0, 0xC7 }, "TadiranTelec", "Tadiran Telecommunications" },
    { { 0x00, 0xA0, 0xC8 }, "Adtran",       "Adtran Inc" },
    { { 0x00, 0xA0, 0xC9 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0xA0, 0xCA }, "FujitsuDenso", "Fujitsu Denso Ltd." },
    { { 0x00, 0xA0, 0xCB }, "ArkTelecommu", "Ark Telecommunications, Inc." },
    { { 0x00, 0xA0, 0xCC }, "LiteOnCommun", "Lite-On Communications, Inc." },
    { { 0x00, 0xA0, 0xCD }, "DRJOHANNESHE", "DR. JOHANNES HEIDENHAIN GmbH" },
    { { 0x00, 0xA0, 0xCE }, "Ecessa",       "Ecessa" },
    { { 0x00, 0xA0, 0xCF }, "Sotas",        "Sotas, Inc." },
    { { 0x00, 0xA0, 0xD0 }, "TenXTechnolo", "Ten X Technology, Inc." },
    { { 0x00, 0xA0, 0xD1 }, "Inventec",     "Inventec Corporation" },
    { { 0x00, 0xA0, 0xD2 }, "AlliedTelesi", "Allied Telesis International Corporation" },
    { { 0x00, 0xA0, 0xD3 }, "InstemComput", "Instem Computer Systems, Ltd." },
    { { 0x00, 0xA0, 0xD4 }, "Radiolan",     "Radiolan, Inc." },
    { { 0x00, 0xA0, 0xD5 }, "SierraWirele", "Sierra Wireless, ULC" },
    { { 0x00, 0xA0, 0xD6 }, "SBE",          "SBE, Inc." },
    { { 0x00, 0xA0, 0xD7 }, "KastenChaseA", "Kasten Chase Applied Research" },
    { { 0x00, 0xA0, 0xD8 }, "SpectraTek",   "Spectra - Tek" },
    { { 0x00, 0xA0, 0xD9 }, "ConvexComput", "Convex Computer Corporation" },
    { { 0x00, 0xA0, 0xDA }, "INTEGRATEDTe", "INTEGRATED SYSTEMS Technology, Inc." },
    { { 0x00, 0xA0, 0xDB }, "FisherPaykel", "Fisher & Paykel Production" },
    { { 0x00, 0xA0, 0xDC }, "ONElectronic", "O.N. Electronic Co., Ltd." },
    { { 0x00, 0xA0, 0xDD }, "Azonix",       "Azonix Corporation" },
    { { 0x00, 0xA0, 0xDE }, "Yamaha",       "Yamaha Corporation" },
    { { 0x00, 0xA0, 0xDF }, "StsTechnolog", "Sts Technologies, Inc." },
    { { 0x00, 0xA0, 0xE0 }, "TennysonTech", "Tennyson Technologies Pty Ltd" },
    { { 0x00, 0xA0, 0xE1 }, "WestportRese", "Westport Research Associates, Inc." },
    { { 0x00, 0xA0, 0xE2 }, "Keisokugiken", "Keisokugiken Corporation" },
    { { 0x00, 0xA0, 0xE3 }, "Xkl",          "Xkl Systems Corp." },
    { { 0x00, 0xA0, 0xE4 }, "Optiquest",    "Optiquest" },
    { { 0x00, 0xA0, 0xE5 }, "NhcCommunica", "Nhc Communications" },
    { { 0x00, 0xA0, 0xE6 }, "Dialogic",     "Dialogic Corporation" },
    { { 0x00, 0xA0, 0xE7 }, "CentralData",  "Central Data Corporation" },
    { { 0x00, 0xA0, 0xE8 }, "ReutersHoldi", "Reuters Holdings Plc" },
    { { 0x00, 0xA0, 0xE9 }, "ElectronicRe", "Electronic Retailing Systems International" },
    { { 0x00, 0xA0, 0xEA }, "Ethercom",     "Ethercom Corp." },
    { { 0x00, 0xA0, 0xEB }, "EncoreNetwor", "Encore Networks, Inc." },
    { { 0x00, 0xA0, 0xEC }, "Transmitton",  "Transmitton Ltd." },
    { { 0x00, 0xA0, 0xED }, "BrooksAutoma", "Brooks Automation, Inc." },
    { { 0x00, 0xA0, 0xEE }, "NashobaNetwo", "Nashoba Networks" },
    { { 0x00, 0xA0, 0xEF }, "Lucidata",     "Lucidata Ltd." },
    { { 0x00, 0xA0, 0xF0 }, "TorontoMicro", "Toronto Microelectronics Inc." },
    { { 0x00, 0xA0, 0xF1 }, "Mti",          "Mti" },
    { { 0x00, 0xA0, 0xF2 }, "InfotekCommu", "Infotek Communications, Inc." },
    { { 0x00, 0xA0, 0xF3 }, "Staubli",      "Staubli" },
    { { 0x00, 0xA0, 0xF4 }, "Ge",           "Ge" },
    { { 0x00, 0xA0, 0xF5 }, "Radguard",     "Radguard Ltd." },
    { { 0x00, 0xA0, 0xF6 }, "AutoGas",      "AutoGas Systems Inc." },
    { { 0x00, 0xA0, 0xF7 }, "VIComputer",   "V.I Computer Corp." },
    { { 0x00, 0xA0, 0xF8 }, "ZebraTechnol", "Zebra Technologies Inc" },
    { { 0x00, 0xA0, 0xF9 }, "BintecCommun", "Bintec Communications Gmbh" },
    { { 0x00, 0xA0, 0xFA }, "MarconiCommu", "Marconi Communication GmbH" },
    { { 0x00, 0xA0, 0xFB }, "TorayEnginee", "Toray Engineering D Solutions Co., Ltd." },
    { { 0x00, 0xA0, 0xFC }, "ImageScience", "Image Sciences, Inc." },
    { { 0x00, 0xA0, 0xFD }, "ScitexDigita", "Scitex Digital Printing, Inc." },
    { { 0x00, 0xA0, 0xFE }, "BostonTechno", "Boston Technology, Inc." },
    { { 0x00, 0xA0, 0xFF }, "TellabsOpera", "Tellabs Operations, Inc." },
    { { 0x00, 0xA1, 0x59 }, "LGElectronic", "LG Electronics" },
    { { 0x00, 0xA1, 0xDE }, "ShiHuaTechno", "ShenZhen ShiHua Technology CO.,LTD" },
    { { 0x00, 0xA2, 0x65 }, "M2MotiveTech", "M2Motive Technology Inc." },
    { { 0x00, 0xA2, 0x89 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xA2, 0xDA }, "INAT",         "INAT GmbH" },
    { { 0x00, 0xA2, 0xEE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xA2, 0xF5 }, "GuangzhouYua", "Guangzhou Yuanyun Network Technology Co.,Ltd" },
    { { 0x00, 0xA2, 0xFF }, "abatecgroup",  "abatec group AG" },
    { { 0x00, 0xA3, 0x88 }, "SkyUk",        "Sky Uk Limited" },
    { { 0x00, 0xA3, 0x8E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xA3, 0xD1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xA4, 0x1C }, "TonlyTechnol", "Tonly Technology Co. Ltd" },
    { { 0x00, 0xA4, 0x5F }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0xA5, 0x09 }, "WigWag",       "WigWag Inc." },
    { { 0x00, 0xA5, 0x54 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0xA5, 0xBF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xA6, 0xCA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xA7, 0x42 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xA7, 0x84 }, "ITXsecurity",  "ITX security" },
    { { 0x00, 0xA9, 0x1D }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0xAA, 0x00 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0xAA, 0x01 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0xAA, 0x02 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0xAA, 0x3C }, "OlivettiTele", "Olivetti Telecom Spa (Olteco)" },
    { { 0x00, 0xAA, 0x6E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xAA, 0x70 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x00, 0xAA, 0xFD }, "TexasInstrum", "Texas Instruments" },
    { { 0x00, 0xAB, 0x48 }, "eero",         "eero inc." },
    { { 0x00, 0xAC, 0xE0 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0xAD, 0x24 }, "DLinkInterna", "D-Link International" },
    { { 0x00, 0xAD, 0x63 }, "DedicatedMic", "Dedicated Micros Malta LTD" },
    { { 0x00, 0xAD, 0xD5 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0xAE, 0xCD }, "Pensando",     "Pensando Systems" },
    { { 0x00, 0xAE, 0xFA }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x00, 0xAF, 0x1F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB0, 0x09 }, "GrassValleyA", "Grass Valley, A Belden Brand" },
    { { 0x00, 0xB0, 0x17 }, "InfoGearTech", "InfoGear Technology Corp." },
    { { 0x00, 0xB0, 0x19 }, "UtcCcs",       "Utc Ccs" },
    { { 0x00, 0xB0, 0x1C }, "WestportTech", "Westport Technologies" },
    { { 0x00, 0xB0, 0x1E }, "RanticLabs",   "Rantic Labs, Inc." },
    { { 0x00, 0xB0, 0x2A }, "ORSYS",        "ORSYS GmbH" },
    { { 0x00, 0xB0, 0x2D }, "ViaGateTechn", "ViaGate Technologies, Inc." },
    { { 0x00, 0xB0, 0x33 }, "OAOIzhevskiy", "OAO \"Izhevskiy radiozavod\"" },
    { { 0x00, 0xB0, 0x3B }, "HiQNetworks",  "HiQ Networks" },
    { { 0x00, 0xB0, 0x48 }, "MarconiCommu", "Marconi Communications Inc." },
    { { 0x00, 0xB0, 0x4A }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB0, 0x52 }, "AtherosCommu", "Atheros Communications" },
    { { 0x00, 0xB0, 0x64 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB0, 0x69 }, "Honewell",     "Honewell Oy" },
    { { 0x00, 0xB0, 0x6D }, "JonesFuturex", "Jones Futurex Inc." },
    { { 0x00, 0xB0, 0x80 }, "MannesmannIp", "Mannesmann Ipulsys B.V." },
    { { 0x00, 0xB0, 0x86 }, "LocSoft",      "LocSoft Limited" },
    { { 0x00, 0xB0, 0x8E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB0, 0x91 }, "Transmeta",    "Transmeta Corp." },
    { { 0x00, 0xB0, 0x94 }, "Alaris",       "Alaris, Inc." },
    { { 0x00, 0xB0, 0x9A }, "MorrowTechno", "Morrow Technologies Corp." },
    { { 0x00, 0xB0, 0x9D }, "PointGreyRes", "Point Grey Research Inc." },
    { { 0x00, 0xB0, 0xAC }, "SIAEMicroele", "SIAE-Microelettronica S.p.A." },
    { { 0x00, 0xB0, 0xAE }, "Symmetricom",  "Symmetricom" },
    { { 0x00, 0xB0, 0xB3 }, "Xstreamis",    "Xstreamis Plc" },
    { { 0x00, 0xB0, 0xC2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB0, 0xC7 }, "TellabsOpera", "Tellabs Operations, Inc." },
    { { 0x00, 0xB0, 0xCE }, "ViverisTechn", "Viveris Technologies" },
    { { 0x00, 0xB0, 0xD0 }, "Dell",         "Dell Inc." },
    { { 0x00, 0xB0, 0xDB }, "Nextcell",     "Nextcell, Inc." },
    { { 0x00, 0xB0, 0xDF }, "StarboardSto", "Starboard Storage Systems" },
    { { 0x00, 0xB0, 0xE1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB0, 0xE7 }, "BritishFeder", "British Federal Ltd." },
    { { 0x00, 0xB0, 0xEC }, "Eacem",        "Eacem" },
    { { 0x00, 0xB0, 0xEE }, "Ajile",        "Ajile Systems, Inc." },
    { { 0x00, 0xB0, 0xF0 }, "CalyNetworks", "Caly Networks" },
    { { 0x00, 0xB0, 0xF5 }, "NetWorthTech", "NetWorth Technologies, Inc." },
    { { 0x00, 0xB1, 0xE3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB3, 0x38 }, "KontronAsiaP", "Kontron Asia Pacific Design Sdn. Bhd" },
    { { 0x00, 0xB3, 0x42 }, "MacroSANTech", "MacroSAN Technologies Co., Ltd." },
    { { 0x00, 0xB3, 0x62 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xB4, 0xF5 }, "DongGuanSiyo", "DongGuan Siyoto Electronics Co., Ltd" },
    { { 0x00, 0xB5, 0x6D }, "DavidElectro", "David Electronics Co., LTD." },
    { { 0x00, 0xB5, 0xD0 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0xB5, 0xD6 }, "Omnibit",      "Omnibit Inc." },
    { { 0x00, 0xB6, 0x00 }, "VOIM",         "VOIM Co., Ltd." },
    { { 0x00, 0xB6, 0x70 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB6, 0x9F }, "Latch",        "Latch" },
    { { 0x00, 0xB7, 0x71 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB7, 0x8D }, "NanjingShini", "Nanjing Shining Electric Automation Co., Ltd" },
    { { 0x00, 0xB7, 0xA8 }, "Heinzingerel", "Heinzinger electronic GmbH" },
    { { 0x00, 0xB8, 0x10 }, "YichipMicroe", "Yichip Microelectronics (Hangzhou) Co.,Ltd" },
    { { 0x00, 0xB8, 0x81 }, "Newplatforms", "New platforms LLC" },
    { { 0x00, 0xB8, 0xB3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xB8, 0xB6 }, "MotorolaMobi", "Motorola Mobility LLC, a Lenovo Company" },
    { { 0x00, 0xB8, 0xC2 }, "HeightsTelec", "Heights Telecom T ltd" },
    { { 0x00, 0xB9, 0xF6 }, "SuperRichEle", "Shenzhen Super Rich Electronics Co.,Ltd" },
    { { 0x00, 0xBA, 0xC0 }, "BiometricAcc", "Biometric Access Company" },
    { { 0x00, 0xBB, 0x01 }, "Octothorpe",   "Octothorpe Corp." },
    { { 0x00, 0xBB, 0x1C }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0xBB, 0x3A }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x00, 0xBB, 0x60 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0xBB, 0x8E }, "HME",          "HME Co., Ltd." },
    { { 0x00, 0xBB, 0xC1 }, "Canon",        "Canon Inc." },
    { { 0x00, 0xBB, 0xF0 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xBC, 0x60 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xBD, 0x27 }, "Exar",         "Exar Corp." },
    { { 0x00, 0xBD, 0x3A }, "Nokia",        "Nokia Corporation" },
    { { 0x00, 0xBD, 0x3E }, "Vizio",        "Vizio, Inc" },
    { { 0x00, 0xBD, 0x82 }, "YOUHUATechno", "Shenzhen YOUHUA Technology Co., Ltd" },
    { { 0x00, 0xBE, 0x3B }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0xBE, 0x43 }, "Dell",         "Dell Inc." },
    { { 0x00, 0xBE, 0x75 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xBE, 0x9E }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x00, 0xBE, 0xD5 }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x00, 0xBF, 0x15 }, "Genetec",      "Genetec Inc." },
    { { 0x00, 0xBF, 0x61 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0xBF, 0x77 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xBF, 0xAF }, "HuiZhouGaosh", "Hui Zhou Gaoshengda Technology Co.,LTD" },
    { { 0x00, 0xC0, 0x00 }, "Lanoptics",    "Lanoptics, Ltd." },
    { { 0x00, 0xC0, 0x01 }, "DiatekPatien", "Diatek Patient Managment" },
    { { 0x00, 0xC0, 0x02 }, "Sercomm",      "Sercomm Corporation." },
    { { 0x00, 0xC0, 0x03 }, "GlobalnetCom", "Globalnet Communications" },
    { { 0x00, 0xC0, 0x04 }, "JapanBusines", "Japan Business Computer Co.Ltd" },
    { { 0x00, 0xC0, 0x05 }, "LivingstonEn", "Livingston Enterprises, Inc." },
    { { 0x00, 0xC0, 0x06 }, "NipponAvioni", "Nippon Avionics Co., Ltd." },
    { { 0x00, 0xC0, 0x07 }, "PinnacleData", "Pinnacle Data Systems, Inc." },
    { { 0x00, 0xC0, 0x08 }, "Seco",         "Seco Srl" },
    { { 0x00, 0xC0, 0x09 }, "KtTechnology", "Kt Technology (S) Pte Ltd" },
    { { 0x00, 0xC0, 0x0A }, "MicroCraft",   "Micro Craft" },
    { { 0x00, 0xC0, 0x0B }, "Norcontrol",   "Norcontrol A.S." },
    { { 0x00, 0xC0, 0x0C }, "ReliaTechnol", "Relia Technolgies" },
    { { 0x00, 0xC0, 0x0D }, "AdvancedLogi", "Advanced Logic Research, Inc." },
    { { 0x00, 0xC0, 0x0E }, "Psitech",      "Psitech, Inc." },
    { { 0x00, 0xC0, 0x0F }, "QuantumSoftw", "Quantum Software Systems Ltd." },
    { { 0x00, 0xC0, 0x10 }, "HirakawaHewt", "Hirakawa Hewtech Corp." },
    { { 0x00, 0xC0, 0x11 }, "InteractiveC", "Interactive Computing Devices" },
    { { 0x00, 0xC0, 0x12 }, "Netspan",      "Netspan Corporation" },
    { { 0x00, 0xC0, 0x13 }, "Netrix",       "Netrix" },
    { { 0x00, 0xC0, 0x14 }, "TelematicsCa", "Telematics Calabasas Int'L,Inc" },
    { { 0x00, 0xC0, 0x15 }, "NewMedia",     "New Media Corporation" },
    { { 0x00, 0xC0, 0x16 }, "ElectronicTh", "Electronic Theatre Controls" },
    { { 0x00, 0xC0, 0x17 }, "NetAlly",      "NetAlly" },
    { { 0x00, 0xC0, 0x18 }, "Lanart",       "Lanart Corporation" },
    { { 0x00, 0xC0, 0x19 }, "LeapTechnolo", "Leap Technology, Inc." },
    { { 0x00, 0xC0, 0x1A }, "CorometricsM", "Corometrics Medical Systems" },
    { { 0x00, 0xC0, 0x1B }, "SocketCommun", "Socket Communications, Inc." },
    { { 0x00, 0xC0, 0x1C }, "InterlinkCom", "Interlink Communications Ltd." },
    { { 0x00, 0xC0, 0x1D }, "GrandJunctio", "Grand Junction Networks, Inc." },
    { { 0x00, 0xC0, 0x1E }, "LaFrancaiseD", "La Francaise Des Jeux" },
    { { 0x00, 0xC0, 0x1F }, "SERCEL",       "S.E.R.C.E.L." },
    { { 0x00, 0xC0, 0x20 }, "ArcoElectron", "Arco Electronic, Control Ltd." },
    { { 0x00, 0xC0, 0x21 }, "Netexpress",   "Netexpress" },
    { { 0x00, 0xC0, 0x22 }, "LasermasterT", "Lasermaster Technologies, Inc." },
    { { 0x00, 0xC0, 0x23 }, "TutankhamonE", "Tutankhamon Electronics" },
    { { 0x00, 0xC0, 0x24 }, "EdenSistemas", "Eden Sistemas De Computacao Sa" },
    { { 0x00, 0xC0, 0x25 }, "Dataproducts", "Dataproducts Corporation" },
    { { 0x00, 0xC0, 0x26 }, "LansTechnolo", "Lans Technology Co., Ltd." },
    { { 0x00, 0xC0, 0x27 }, "Cipher",       "Cipher Systems, Inc." },
    { { 0x00, 0xC0, 0x28 }, "Jasco",        "Jasco Corporation" },
    { { 0x00, 0xC0, 0x29 }, "NexansDeutsc", "Nexans Deutschland GmbH - ANS" },
    { { 0x00, 0xC0, 0x2A }, "OhkuraElectr", "Ohkura Electric Co., Ltd." },
    { { 0x00, 0xC0, 0x2B }, "GerloffGesel", "Gerloff Gesellschaft Fur" },
    { { 0x00, 0xC0, 0x2C }, "CentrumCommu", "Centrum Communications, Inc." },
    { { 0x00, 0xC0, 0x2D }, "FujiPhotoFil", "Fuji Photo Film Co., Ltd." },
    { { 0x00, 0xC0, 0x2E }, "Netwiz",       "Netwiz" },
    { { 0x00, 0xC0, 0x2F }, "Okuma",        "Okuma Corporation" },
    { { 0x00, 0xC0, 0x30 }, "IntegratedEn", "Integrated Engineering B. V." },
    { { 0x00, 0xC0, 0x31 }, "DesignResear", "Design Research Systems, Inc." },
    { { 0x00, 0xC0, 0x32 }, "ICubed",       "I-Cubed Limited" },
    { { 0x00, 0xC0, 0x33 }, "TelebitCommu", "Telebit Communications Aps" },
    { { 0x00, 0xC0, 0x34 }, "TransactionN", "Transaction Network" },
    { { 0x00, 0xC0, 0x35 }, "Quintar",      "Quintar Company" },
    { { 0x00, 0xC0, 0x36 }, "RaytechElect", "Raytech Electronic Corp." },
    { { 0x00, 0xC0, 0x37 }, "Dynatem",      "Dynatem" },
    { { 0x00, 0xC0, 0x38 }, "RasterImageP", "Raster Image Processing System" },
    { { 0x00, 0xC0, 0x39 }, "TeridianSemi", "Teridian Semiconductor Corporation" },
    { { 0x00, 0xC0, 0x3A }, "duagonGerman", "duagon Germany GmbH" },
    { { 0x00, 0xC0, 0x3B }, "MultiaccessC", "Multiaccess Computing Corp." },
    { { 0x00, 0xC0, 0x3C }, "TowerTech",    "Tower Tech S.R.L." },
    { { 0x00, 0xC0, 0x3D }, "WiesemannThe", "Wiesemann & Theis Gmbh" },
    { { 0x00, 0xC0, 0x3E }, "FaGebrHeller", "Fa. Gebr. Heller Gmbh" },
    { { 0x00, 0xC0, 0x3F }, "StoresAutoma", "Stores Automated Systems, Inc." },
    { { 0x00, 0xC0, 0x40 }, "Ecci",         "Ecci" },
    { { 0x00, 0xC0, 0x41 }, "DigitalTrans", "Digital Transmission Systems" },
    { { 0x00, 0xC0, 0x42 }, "Datalux",      "Datalux Corp." },
    { { 0x00, 0xC0, 0x43 }, "Stratacom",    "Stratacom" },
    { { 0x00, 0xC0, 0x44 }, "Emcom",        "Emcom Corporation" },
    { { 0x00, 0xC0, 0x45 }, "Isolation",    "Isolation Systems, Ltd." },
    { { 0x00, 0xC0, 0x46 }, "BlueChipTech", "Blue Chip Technology Ltd" },
    { { 0x00, 0xC0, 0x47 }, "Unimicro",     "Unimicro Systems, Inc." },
    { { 0x00, 0xC0, 0x48 }, "BayTechnical", "Bay Technical Associates" },
    { { 0x00, 0xC0, 0x49 }, "USRobotics",   "U.S. Robotics, Inc." },
    { { 0x00, 0xC0, 0x4A }, "Group2000",    "Group 2000 Ag" },
    { { 0x00, 0xC0, 0x4B }, "CreativeMicr", "Creative Microsystems" },
    { { 0x00, 0xC0, 0x4C }, "DepartmentFo", "Department Of Foreign Affairs" },
    { { 0x00, 0xC0, 0x4D }, "Mitec",        "Mitec, Inc." },
    { { 0x00, 0xC0, 0x4E }, "Comtrol",      "Comtrol Corporation" },
    { { 0x00, 0xC0, 0x4F }, "Dell",         "Dell Inc." },
    { { 0x00, 0xC0, 0x50 }, "ToyoDenkiSei", "Toyo Denki Seizo K.K." },
    { { 0x00, 0xC0, 0x51 }, "AdvancedInte", "Advanced Integration Research" },
    { { 0x00, 0xC0, 0x52 }, "BurrBrown",    "Burr-Brown" },
    { { 0x00, 0xC0, 0x53 }, "AspectSoftwa", "Aspect Software Inc." },
    { { 0x00, 0xC0, 0x54 }, "NetworkPerip", "Network Peripherals, Ltd." },
    { { 0x00, 0xC0, 0x55 }, "ModularCompu", "Modular Computing Technologies" },
    { { 0x00, 0xC0, 0x56 }, "Somelec",      "Somelec" },
    { { 0x00, 0xC0, 0x57 }, "MycoElectron", "Myco Electronics" },
    { { 0x00, 0xC0, 0x58 }, "Dataexpert",   "Dataexpert Corp." },
    { { 0x00, 0xC0, 0x59 }, "Denso",        "Denso Corporation" },
    { { 0x00, 0xC0, 0x5A }, "SemaphoreCom", "Semaphore Communications Corp." },
    { { 0x00, 0xC0, 0x5B }, "NetworksNort", "Networks Northwest, Inc." },
    { { 0x00, 0xC0, 0x5C }, "Elonex",       "Elonex Plc" },
    { { 0x00, 0xC0, 0x5D }, "L&NTechnolog", "L&N Technologies" },
    { { 0x00, 0xC0, 0x5E }, "VariLite",     "Vari-Lite, Inc." },
    { { 0x00, 0xC0, 0x5F }, "FinePal",      "Fine-Pal Company Limited" },
    { { 0x00, 0xC0, 0x60 }, "IdScandinavi", "Id Scandinavia As" },
    { { 0x00, 0xC0, 0x61 }, "Solectek",     "Solectek Corporation" },
    { { 0x00, 0xC0, 0x62 }, "ImpulseTechn", "Impulse Technology" },
    { { 0x00, 0xC0, 0x63 }, "MorningStarT", "Morning Star Technologies, Inc" },
    { { 0x00, 0xC0, 0x64 }, "GeneralDatac", "General Datacomm LLC" },
    { { 0x00, 0xC0, 0x65 }, "ScopeCommuni", "Scope Communications, Inc." },
    { { 0x00, 0xC0, 0x66 }, "Docupoint",    "Docupoint, Inc." },
    { { 0x00, 0xC0, 0x67 }, "UnitedBarcod", "United Barcode Industries" },
    { { 0x00, 0xC0, 0x68 }, "HMEClearCom",  "HME Clear-Com LTD." },
    { { 0x00, 0xC0, 0x69 }, "AxxceleraBro", "Axxcelera Broadband Wireless" },
    { { 0x00, 0xC0, 0x6A }, "ZahnerElektr", "Zahner-Elektrik Ingeborg Zahner-Schiller GmbH & Co. KG." },
    { { 0x00, 0xC0, 0x6B }, "OsiPlus",      "Osi Plus Corporation" },
    { { 0x00, 0xC0, 0x6C }, "SvecComputer", "Svec Computer Corp." },
    { { 0x00, 0xC0, 0x6D }, "BocaResearch", "Boca Research, Inc." },
    { { 0x00, 0xC0, 0x6E }, "HaftTechnolo", "Haft Technology, Inc." },
    { { 0x00, 0xC0, 0x6F }, "Komatsu",      "Komatsu Ltd." },
    { { 0x00, 0xC0, 0x70 }, "SectraSecure", "Sectra Secure-Transmission Ab" },
    { { 0x00, 0xC0, 0x71 }, "AreanexCommu", "Areanex Communications, Inc." },
    { { 0x00, 0xC0, 0x72 }, "Knx",          "Knx Ltd." },
    { { 0x00, 0xC0, 0x73 }, "Xedia",        "Xedia Corporation" },
    { { 0x00, 0xC0, 0x74 }, "ToyodaAutoma", "Toyoda Automatic Loom" },
    { { 0x00, 0xC0, 0x75 }, "Xante",        "Xante Corporation" },
    { { 0x00, 0xC0, 0x76 }, "IDataInterna", "I-Data International A-S" },
    { { 0x00, 0xC0, 0x77 }, "DaewooTeleco", "Daewoo Telecom Ltd." },
    { { 0x00, 0xC0, 0x78 }, "ComputerEngi", "Computer Systems Engineering" },
    { { 0x00, 0xC0, 0x79 }, "Fonsys",       "Fonsys Co.,Ltd." },
    { { 0x00, 0xC0, 0x7A }, "Priva",        "Priva B.V." },
    { { 0x00, 0xC0, 0x7B }, "AscendCommun", "Ascend Communications, Inc." },
    { { 0x00, 0xC0, 0x7C }, "HightechInfo", "Hightech Information" },
    { { 0x00, 0xC0, 0x7D }, "RiscDevelopm", "Risc Developments Ltd." },
    { { 0x00, 0xC0, 0x7E }, "KubotaElectr", "Kubota Corporation Electronic" },
    { { 0x00, 0xC0, 0x7F }, "NuponComputi", "Nupon Computing Corp." },
    { { 0x00, 0xC0, 0x80 }, "Netstar",      "Netstar, Inc." },
    { { 0x00, 0xC0, 0x81 }, "Metrodata",    "Metrodata Ltd." },
    { { 0x00, 0xC0, 0x82 }, "MooreProduct", "Moore Products Co." },
    { { 0x00, 0xC0, 0x83 }, "TraceMountai", "Trace Mountain Products, Inc." },
    { { 0x00, 0xC0, 0x84 }, "DataLink",     "Data Link Corp. Ltd." },
    { { 0x00, 0xC0, 0x85 }, "ElectronicsF", "Electronics For Imaging, Inc." },
    { { 0x00, 0xC0, 0x86 }, "Lynk",         "The Lynk Corporation" },
    { { 0x00, 0xC0, 0x87 }, "UunetTechnol", "Uunet Technologies, Inc." },
    { { 0x00, 0xC0, 0x88 }, "EkfElektroni", "Ekf Elektronik Gmbh" },
    { { 0x00, 0xC0, 0x89 }, "TelindusDist", "Telindus Distribution" },
    { { 0x00, 0xC0, 0x8A }, "Lauterbach",   "Lauterbach GmbH" },
    { { 0x00, 0xC0, 0x8B }, "RisqModular",  "Risq Modular Systems, Inc." },
    { { 0x00, 0xC0, 0x8C }, "PerformanceT", "Performance Technologies, Inc." },
    { { 0x00, 0xC0, 0x8D }, "TronixProduc", "Tronix Product Development" },
    { { 0x00, 0xC0, 0x8E }, "NetworkInfor", "Network Information Technology" },
    { { 0x00, 0xC0, 0x8F }, "PanasonicEle", "Panasonic Electric Works Co., Ltd." },
    { { 0x00, 0xC0, 0x90 }, "Praim",        "Praim S.R.L." },
    { { 0x00, 0xC0, 0x91 }, "JabilCircuit", "Jabil Circuit, Inc." },
    { { 0x00, 0xC0, 0x92 }, "MennenMedica", "Mennen Medical Inc." },
    { { 0x00, 0xC0, 0x93 }, "AltaResearch", "Alta Research Corp." },
    { { 0x00, 0xC0, 0x94 }, "Vmx",          "Vmx Inc." },
    { { 0x00, 0xC0, 0x95 }, "ZNYXNetworks", "ZNYX Networks, Inc." },
    { { 0x00, 0xC0, 0x96 }, "Tamura",       "Tamura Corporation" },
    { { 0x00, 0xC0, 0x97 }, "Archipel",     "Archipel Sa" },
    { { 0x00, 0xC0, 0x98 }, "ChuntexElect", "Chuntex Electronic Co., Ltd." },
    { { 0x00, 0xC0, 0x99 }, "YoshikiIndus", "Yoshiki Industrial Co.,Ltd." },
    { { 0x00, 0xC0, 0x9A }, "Photonics",    "Photonics Corporation" },
    { { 0x00, 0xC0, 0x9B }, "TellabsEnter", "Tellabs Enterprise, Inc." },
    { { 0x00, 0xC0, 0x9C }, "HiokiEE",      "Hioki E.E. Corporation" },
    { { 0x00, 0xC0, 0x9D }, "DistributedI", "Distributed Systems Int'L, Inc" },
    { { 0x00, 0xC0, 0x9E }, "CacheCompute", "Cache Computers, Inc." },
    { { 0x00, 0xC0, 0x9F }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x00, 0xC0, 0xA0 }, "AdvanceMicro", "Advance Micro Research, Inc." },
    { { 0x00, 0xC0, 0xA1 }, "TokyoDenshiS", "Tokyo Denshi Sekei Co." },
    { { 0x00, 0xC0, 0xA2 }, "Intermedium",  "Intermedium A/S" },
    { { 0x00, 0xC0, 0xA3 }, "DualEnterpri", "Dual Enterprises Corporation" },
    { { 0x00, 0xC0, 0xA4 }, "Unigraf",      "Unigraf Oy" },
    { { 0x00, 0xC0, 0xA5 }, "DickensData",  "Dickens Data Systems" },
    { { 0x00, 0xC0, 0xA6 }, "ExicomAustra", "Exicom Australia Pty. Ltd" },
    { { 0x00, 0xC0, 0xA7 }, "Seel",         "Seel Ltd." },
    { { 0x00, 0xC0, 0xA8 }, "Gvc",          "Gvc Corporation" },
    { { 0x00, 0xC0, 0xA9 }, "BarronMccann", "Barron Mccann Ltd." },
    { { 0x00, 0xC0, 0xAA }, "SiliconValle", "Silicon Valley Computer" },
    { { 0x00, 0xC0, 0xAB }, "Telco",        "Telco Systems, Inc." },
    { { 0x00, 0xC0, 0xAC }, "GambitComput", "Gambit Computer Communications" },
    { { 0x00, 0xC0, 0xAD }, "MarbenCommun", "Marben Communication Systems" },
    { { 0x00, 0xC0, 0xAE }, "TowercomDbaP", "Towercom Co. Inc. Dba Pc House" },
    { { 0x00, 0xC0, 0xAF }, "Teklogix",     "Teklogix Inc." },
    { { 0x00, 0xC0, 0xB0 }, "GccTechnolog", "Gcc Technologies,Inc." },
    { { 0x00, 0xC0, 0xB1 }, "GeniusNet",    "Genius Net Co." },
    { { 0x00, 0xC0, 0xB2 }, "Norand",       "Norand Corporation" },
    { { 0x00, 0xC0, 0xB3 }, "ComstatDatac", "Comstat Datacomm Corporation" },
    { { 0x00, 0xC0, 0xB4 }, "MysonTechnol", "Myson Technology, Inc." },
    { { 0x00, 0xC0, 0xB5 }, "CorporateNet", "Corporate Network Systems,Inc." },
    { { 0x00, 0xC0, 0xB6 }, "HVE",          "HVE, Inc." },
    { { 0x00, 0xC0, 0xB7 }, "AmericanPowe", "American Power Conversion Corp" },
    { { 0x00, 0xC0, 0xB8 }, "FraserSHill",  "Fraser'S Hill Ltd." },
    { { 0x00, 0xC0, 0xB9 }, "FunkSoftware", "Funk Software, Inc." },
    { { 0x00, 0xC0, 0xBA }, "Netvantage",   "Netvantage" },
    { { 0x00, 0xC0, 0xBB }, "ForvalCreati", "Forval Creative, Inc." },
    { { 0x00, 0xC0, 0xBC }, "TelecomAustr", "Telecom Australia/Cssc" },
    { { 0x00, 0xC0, 0xBD }, "InexTechnolo", "Inex Technologies, Inc." },
    { { 0x00, 0xC0, 0xBE }, "AlcatelSel",   "Alcatel - Sel" },
    { { 0x00, 0xC0, 0xBF }, "TechnologyCo", "Technology Concepts, Ltd." },
    { { 0x00, 0xC0, 0xC0 }, "ShoreMicrosy", "Shore Microsystems, Inc." },
    { { 0x00, 0xC0, 0xC1 }, "QuadGraphics", "Quad/Graphics, Inc." },
    { { 0x00, 0xC0, 0xC2 }, "InfiniteNetw", "Infinite Networks Ltd." },
    { { 0x00, 0xC0, 0xC3 }, "AcusonComput", "Acuson Computed Sonography" },
    { { 0x00, 0xC0, 0xC4 }, "ComputerOper", "Computer Operational" },
    { { 0x00, 0xC0, 0xC5 }, "SidInformati", "Sid Informatica" },
    { { 0x00, 0xC0, 0xC6 }, "PersonalMedi", "Personal Media Corp." },
    { { 0x00, 0xC0, 0xC7 }, "SparktrumMic", "Sparktrum Microsystems, Inc." },
    { { 0x00, 0xC0, 0xC8 }, "MicroByte",    "Micro Byte Pty. Ltd." },
    { { 0x00, 0xC0, 0xC9 }, "ElsagBaileyP", "Elsag Bailey Process" },
    { { 0x00, 0xC0, 0xCA }, "Alfa",         "Alfa, Inc." },
    { { 0x00, 0xC0, 0xCB }, "ControlTechn", "Control Technology Corporation" },
    { { 0x00, 0xC0, 0xCC }, "Telesciences", "Telesciences Co Systems, Inc." },
    { { 0x00, 0xC0, 0xCD }, "Comelta",      "Comelta, S.A." },
    { { 0x00, 0xC0, 0xCE }, "CeiEngineeri", "Cei Systems & Engineering Pte" },
    { { 0x00, 0xC0, 0xCF }, "ImatranVoima", "Imatran Voima Oy" },
    { { 0x00, 0xC0, 0xD0 }, "RatocSystem",  "Ratoc System Inc." },
    { { 0x00, 0xC0, 0xD1 }, "ComtreeTechn", "Comtree Technology Corporation" },
    { { 0x00, 0xC0, 0xD2 }, "Syntellect",   "Syntellect, Inc." },
    { { 0x00, 0xC0, 0xD3 }, "OlympusImage", "Olympus Image Systems, Inc." },
    { { 0x00, 0xC0, 0xD4 }, "AxonNetworks", "Axon Networks, Inc." },
    { { 0x00, 0xC0, 0xD5 }, "Werbeagentur", "Werbeagentur Jürgen Siebert" },
    { { 0x00, 0xC0, 0xD6 }, "J1",           "J1 Systems, Inc." },
    { { 0x00, 0xC0, 0xD7 }, "TaiwanTradin", "Taiwan Trading Center Dba" },
    { { 0x00, 0xC0, 0xD8 }, "UniversalDat", "Universal Data Systems" },
    { { 0x00, 0xC0, 0xD9 }, "QuinteNetwor", "Quinte Network Confidentiality" },
    { { 0x00, 0xC0, 0xDA }, "Nice",         "Nice Systems Ltd." },
    { { 0x00, 0xC0, 0xDB }, "Ipc",          "Ipc Corporation (Pte) Ltd." },
    { { 0x00, 0xC0, 0xDC }, "EosTechnolog", "Eos Technologies, Inc." },
    { { 0x00, 0xC0, 0xDD }, "QLogic",       "QLogic Corporation" },
    { { 0x00, 0xC0, 0xDE }, "Zcomm",        "Zcomm, Inc." },
    { { 0x00, 0xC0, 0xDF }, "KYE",          "KYE Systems Corp." },
    { { 0x00, 0xC0, 0xE0 }, "DscCommunica", "Dsc Communication Corp." },
    { { 0x00, 0xC0, 0xE1 }, "SonicSolutio", "Sonic Solutions" },
    { { 0x00, 0xC0, 0xE2 }, "Calcomp",      "Calcomp, Inc." },
    { { 0x00, 0xC0, 0xE3 }, "OsitechCommu", "Ositech Communications, Inc." },
    { { 0x00, 0xC0, 0xE4 }, "SiemensBuild", "Siemens Building" },
    { { 0x00, 0xC0, 0xE5 }, "Gespac",       "Gespac, S.A." },
    { { 0x00, 0xC0, 0xE6 }, "Verilink",     "Verilink Corporation" },
    { { 0x00, 0xC0, 0xE7 }, "Fiberdata",    "Fiberdata Ab" },
    { { 0x00, 0xC0, 0xE8 }, "Plexcom",      "Plexcom, Inc." },
    { { 0x00, 0xC0, 0xE9 }, "OakSolutions", "Oak Solutions, Ltd." },
    { { 0x00, 0xC0, 0xEA }, "ArrayTechnol", "Array Technology Ltd." },
    { { 0x00, 0xC0, 0xEB }, "SehComputert", "Seh Computertechnik Gmbh" },
    { { 0x00, 0xC0, 0xEC }, "DauphinTechn", "Dauphin Technology" },
    { { 0x00, 0xC0, 0xED }, "UsArmyElectr", "Us Army Electronic" },
    { { 0x00, 0xC0, 0xEE }, "KYOCERADispl", "KYOCERA Display Corporation" },
    { { 0x00, 0xC0, 0xEF }, "Abit",         "Abit Corporation" },
    { { 0x00, 0xC0, 0xF0 }, "KingstonTech", "Kingston Technology Company, Inc." },
    { { 0x00, 0xC0, 0xF1 }, "ShinkoElectr", "Shinko Electric Co., Ltd." },
    { { 0x00, 0xC0, 0xF2 }, "Lantronix",    "Lantronix" },
    { { 0x00, 0xC0, 0xF3 }, "NetworkCommu", "Network Communications Corp." },
    { { 0x00, 0xC0, 0xF4 }, "InterlinkSys", "Interlink System Co., Ltd." },
    { { 0x00, 0xC0, 0xF5 }, "Metacomp",     "Metacomp, Inc." },
    { { 0x00, 0xC0, 0xF6 }, "CelanTechnol", "Celan Technology Inc." },
    { { 0x00, 0xC0, 0xF7 }, "EngageCommun", "Engage Communication, Inc." },
    { { 0x00, 0xC0, 0xF8 }, "AboutComputi", "About Computing Inc." },
    { { 0x00, 0xC0, 0xF9 }, "ArtesynEmbed", "Artesyn Embedded Technologies" },
    { { 0x00, 0xC0, 0xFA }, "CanaryCommun", "Canary Communications, Inc." },
    { { 0x00, 0xC0, 0xFB }, "AdvancedTech", "Advanced Technology Labs" },
    { { 0x00, 0xC0, 0xFC }, "ElasticReali", "Elastic Reality, Inc." },
    { { 0x00, 0xC0, 0xFD }, "Prosum",       "Prosum" },
    { { 0x00, 0xC0, 0xFE }, "AptecCompute", "Aptec Computer Systems, Inc." },
    { { 0x00, 0xC0, 0xFF }, "SeagateCloud", "Seagate Cloud Systems Inc" },
    { { 0x00, 0xC1, 0x4F }, "DDL",          "DDL Co,.ltd." },
    { { 0x00, 0xC1, 0x64 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xC1, 0xB1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xC2, 0x8F }, "AlliedTelesi", "Allied Telesis K.K." },
    { { 0x00, 0xC2, 0xC6 }, "Intel",        "Intel Corporate" },
    { { 0x00, 0xC3, 0x0A }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x00, 0xC3, 0x43 }, "ETACircuitBr", "E-T-A Circuit Breakers Ltd" },
    { { 0x00, 0xC3, 0xF4 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0xC5, 0x2C }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0xC5, 0x85 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xC5, 0xDB }, "DatatechSist", "Datatech Sistemas Digitales Avanzados SL" },
    { { 0x00, 0xC6, 0x10 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xC7, 0x11 }, "ItelMobile",   "Itel Mobile Limited" },
    { { 0x00, 0xC8, 0x8B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xC8, 0x96 }, "CigShanghai",  "Cig Shanghai Co Ltd" },
    { { 0x00, 0xCA, 0xE0 }, "OppoMobileTe", "Guangdong Oppo Mobile Telecommunications Corp.,Ltd" },
    { { 0x00, 0xCA, 0xE5 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xCB, 0x00 }, "Private",      "Private" },
    { { 0x00, 0xCB, 0x51 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0xCB, 0x7A }, "VantivaUSA",   "Vantiva USA LLC" },
    { { 0x00, 0xCB, 0xB4 }, "AtekoPhotoel", "Shenzhen Ateko Photoelectricity Co.,Ltd" },
    { { 0x00, 0xCB, 0xBD }, "CambridgeBro", "Cambridge Broadband Networks Group" },
    { { 0x00, 0xCC, 0x34 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x00, 0xCC, 0x3F }, "UniversalEle", "Universal Electronics, Inc." },
    { { 0x00, 0xCC, 0xFC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xCD, 0x90 }, "MASElektroni", "MAS Elektronik AG" },
    { { 0x00, 0xCD, 0xFE }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xCE, 0x30 }, "ExpressLUCKI", "Express LUCK Industrial Ltd." },
    { { 0x00, 0xCF, 0x1C }, "Communicatio", "Communication Machinery Corporation" },
    { { 0x00, 0xCF, 0xC0 }, "ChinaMobileG", "China Mobile Group Device Co.,Ltd." },
    { { 0x00, 0xD0, 0x00 }, "FerranScient", "Ferran Scientific, Inc." },
    { { 0x00, 0xD0, 0x01 }, "VstTechnolog", "Vst Technologies, Inc." },
    { { 0x00, 0xD0, 0x02 }, "Ditech",       "Ditech Corporation" },
    { { 0x00, 0xD0, 0x03 }, "ComdaEnterpr", "Comda Enterprises Corp." },
    { { 0x00, 0xD0, 0x04 }, "Pentacom",     "Pentacom Ltd." },
    { { 0x00, 0xD0, 0x05 }, "ZhsZeitmanag", "Zhs Zeitmanagementsysteme" },
    { { 0x00, 0xD0, 0x06 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0x07 }, "MicAssociate", "Mic Associates, Inc." },
    { { 0x00, 0xD0, 0x08 }, "Mactell",      "Mactell Corporation" },
    { { 0x00, 0xD0, 0x09 }, "HsingTechEnt", "Hsing Tech. Enterprise Co. Ltd" },
    { { 0x00, 0xD0, 0x0A }, "LanaccessTel", "Lanaccess Telecom S.A." },
    { { 0x00, 0xD0, 0x0B }, "RhkTechnolog", "Rhk Technology, Inc." },
    { { 0x00, 0xD0, 0x0C }, "SnijderMicro", "Snijder Micro Systems" },
    { { 0x00, 0xD0, 0x0D }, "Micromeritic", "Micromeritics Instrument" },
    { { 0x00, 0xD0, 0x0E }, "Pluris",       "Pluris, Inc." },
    { { 0x00, 0xD0, 0x0F }, "SpeechDesign", "Speech Design Gmbh" },
    { { 0x00, 0xD0, 0x10 }, "ConvergentNe", "Convergent Networks, Inc." },
    { { 0x00, 0xD0, 0x11 }, "PrismVideo",   "Prism Video, Inc." },
    { { 0x00, 0xD0, 0x12 }, "Gateworks",    "Gateworks Corp." },
    { { 0x00, 0xD0, 0x13 }, "PrimexAerosp", "Primex Aerospace Company" },
    { { 0x00, 0xD0, 0x14 }, "Root",         "Root, Inc." },
    { { 0x00, 0xD0, 0x15 }, "UnivexMicrot", "Univex Microtechnology Corp." },
    { { 0x00, 0xD0, 0x16 }, "ScmMicrosyst", "Scm Microsystems, Inc." },
    { { 0x00, 0xD0, 0x17 }, "SyntechInfor", "Syntech Information Co., Ltd." },
    { { 0x00, 0xD0, 0x18 }, "QwesCom",      "Qwes. Com, Inc." },
    { { 0x00, 0xD0, 0x19 }, "DainipponScr", "Dainippon Screen Corporate" },
    { { 0x00, 0xD0, 0x1A }, "UrmetTlc",     "Urmet Tlc S.P.A." },
    { { 0x00, 0xD0, 0x1B }, "MimakiEngine", "Mimaki Engineering Co., Ltd." },
    { { 0x00, 0xD0, 0x1C }, "SbsTechnolog", "Sbs Technologies," },
    { { 0x00, 0xD0, 0x1D }, "FurunoElectr", "Furuno Electric Co., Ltd." },
    { { 0x00, 0xD0, 0x1E }, "Pingtel",      "Pingtel Corp." },
    { { 0x00, 0xD0, 0x1F }, "Senetas",      "Senetas Corporation Ltd" },
    { { 0x00, 0xD0, 0x20 }, "AimSystem",    "Aim System, Inc." },
    { { 0x00, 0xD0, 0x21 }, "RegentElectr", "Regent Electronics Corp." },
    { { 0x00, 0xD0, 0x22 }, "IncredibleTe", "Incredible Technologies, Inc." },
    { { 0x00, 0xD0, 0x23 }, "InfortrendTe", "Infortrend Technology, Inc." },
    { { 0x00, 0xD0, 0x24 }, "Cognex",       "Cognex Corporation" },
    { { 0x00, 0xD0, 0x25 }, "Xrosstech",    "Xrosstech, Inc." },
    { { 0x00, 0xD0, 0x26 }, "HirschmannAu", "Hirschmann Austria Gmbh" },
    { { 0x00, 0xD0, 0x27 }, "AppliedAutom", "Applied Automation, Inc." },
    { { 0x00, 0xD0, 0x28 }, "Harmonic",     "Harmonic, Inc" },
    { { 0x00, 0xD0, 0x29 }, "WakefernFood", "Wakefern Food Corporation" },
    { { 0x00, 0xD0, 0x2A }, "Voxent",       "Voxent Systems Ltd." },
    { { 0x00, 0xD0, 0x2B }, "Jetcell",      "Jetcell, Inc." },
    { { 0x00, 0xD0, 0x2C }, "CampbellScie", "Campbell Scientific, Inc." },
    { { 0x00, 0xD0, 0x2D }, "Resideo",      "Resideo" },
    { { 0x00, 0xD0, 0x2E }, "Communicatio", "Communication Automation Corp." },
    { { 0x00, 0xD0, 0x2F }, "VlsiTechnolo", "Vlsi Technology Inc." },
    { { 0x00, 0xD0, 0x30 }, "Safetran",     "Safetran Systems Corp" },
    { { 0x00, 0xD0, 0x31 }, "IndustrialLo", "Industrial Logic Corporation" },
    { { 0x00, 0xD0, 0x32 }, "YanoElectric", "Yano Electric Co., Ltd." },
    { { 0x00, 0xD0, 0x33 }, "DalianDaxian", "Dalian Daxian Network" },
    { { 0x00, 0xD0, 0x34 }, "Ormec",        "Ormec Systems Corp." },
    { { 0x00, 0xD0, 0x35 }, "BehaviorTech", "Behavior Tech. Computer Corp." },
    { { 0x00, 0xD0, 0x36 }, "TechnologyAt", "Technology Atlanta Corp." },
    { { 0x00, 0xD0, 0x37 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0xD0, 0x38 }, "Fivemere",     "Fivemere, Ltd." },
    { { 0x00, 0xD0, 0x39 }, "Utilicom",     "Utilicom, Inc." },
    { { 0x00, 0xD0, 0x3A }, "Zoneworx",     "Zoneworx, Inc." },
    { { 0x00, 0xD0, 0x3B }, "VisionProduc", "Vision Products Pty. Ltd." },
    { { 0x00, 0xD0, 0x3C }, "Vieo",         "Vieo, Inc." },
    { { 0x00, 0xD0, 0x3D }, "GalileoTechn", "Galileo Technology, Ltd." },
    { { 0x00, 0xD0, 0x3E }, "Rocketchips",  "Rocketchips, Inc." },
    { { 0x00, 0xD0, 0x3F }, "AmericanComm", "American Communication" },
    { { 0x00, 0xD0, 0x40 }, "Sysmate",      "Sysmate Co., Ltd." },
    { { 0x00, 0xD0, 0x41 }, "AmigoTechnol", "Amigo Technology Co., Ltd." },
    { { 0x00, 0xD0, 0x42 }, "MahloUg",      "Mahlo Gmbh & Co. Ug" },
    { { 0x00, 0xD0, 0x43 }, "ZonalRetailD", "Zonal Retail Data Systems" },
    { { 0x00, 0xD0, 0x44 }, "AlidianNetwo", "Alidian Networks, Inc." },
    { { 0x00, 0xD0, 0x45 }, "Kvaser",       "Kvaser Ab" },
    { { 0x00, 0xD0, 0x46 }, "DolbyLaborat", "Dolby Laboratories, Inc." },
    { { 0x00, 0xD0, 0x47 }, "XnTechnologi", "Xn Technologies" },
    { { 0x00, 0xD0, 0x48 }, "Ecton",        "Ecton, Inc." },
    { { 0x00, 0xD0, 0x49 }, "Impresstek",   "Impresstek Co., Ltd." },
    { { 0x00, 0xD0, 0x4A }, "PresenceTech", "Presence Technology Gmbh" },
    { { 0x00, 0xD0, 0x4B }, "LaCieGroup",   "La Cie Group S.A." },
    { { 0x00, 0xD0, 0x4C }, "EseyeDesign",  "Eseye Design Ltd" },
    { { 0x00, 0xD0, 0x4D }, "DivResearchS", "Div Of Research & Statistics" },
    { { 0x00, 0xD0, 0x4E }, "Logibag",      "Logibag" },
    { { 0x00, 0xD0, 0x4F }, "Bitronics",    "Bitronics, Inc." },
    { { 0x00, 0xD0, 0x50 }, "Iskrateldoo",  "Iskratel d.o.o." },
    { { 0x00, 0xD0, 0x51 }, "O2Micro",      "O2 Micro, Inc." },
    { { 0x00, 0xD0, 0x52 }, "AscendCommun", "Ascend Communications, Inc." },
    { { 0x00, 0xD0, 0x53 }, "Connected",    "Connected Systems" },
    { { 0x00, 0xD0, 0x54 }, "SasInstitute", "Sas Institute Inc." },
    { { 0x00, 0xD0, 0x55 }, "KathreinWerk", "Kathrein-Werke Kg" },
    { { 0x00, 0xD0, 0x56 }, "Somat",        "Somat Corporation" },
    { { 0x00, 0xD0, 0x57 }, "Ultrak",       "Ultrak, Inc." },
    { { 0x00, 0xD0, 0x58 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0x59 }, "AmbitMicrosy", "Ambit Microsystems Corp." },
    { { 0x00, 0xD0, 0x5A }, "Symbionics",   "Symbionics, Ltd." },
    { { 0x00, 0xD0, 0x5B }, "AcroloopMoti", "Acroloop Motion Control" },
    { { 0x00, 0xD0, 0x5C }, "KATHREINTech", "KATHREIN TechnoTrend GmbH" },
    { { 0x00, 0xD0, 0x5D }, "Intelliworxx", "Intelliworxx, Inc." },
    { { 0x00, 0xD0, 0x5E }, "StratabeamTe", "Stratabeam Technology, Inc." },
    { { 0x00, 0xD0, 0x5F }, "Valcom",       "Valcom, Inc." },
    { { 0x00, 0xD0, 0x60 }, "PanasonicEur", "Panasonic Europe Ltd." },
    { { 0x00, 0xD0, 0x61 }, "TremonEnterp", "Tremon Enterprises Co., Ltd." },
    { { 0x00, 0xD0, 0x62 }, "Digigram",     "Digigram" },
    { { 0x00, 0xD0, 0x63 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0x64 }, "Multitel",     "Multitel" },
    { { 0x00, 0xD0, 0x65 }, "TokoElectric", "Toko Electric" },
    { { 0x00, 0xD0, 0x66 }, "WintrissEngi", "Wintriss Engineering Corp." },
    { { 0x00, 0xD0, 0x67 }, "CampioCommun", "Campio Communications" },
    { { 0x00, 0xD0, 0x68 }, "Iwill",        "Iwill Corporation" },
    { { 0x00, 0xD0, 0x69 }, "Technologic",  "Technologic Systems" },
    { { 0x00, 0xD0, 0x6A }, "Linkup",       "Linkup Systems Corporation" },
    { { 0x00, 0xD0, 0x6B }, "SrTelecom",    "Sr Telecom Inc." },
    { { 0x00, 0xD0, 0x6C }, "Sharewave",    "Sharewave, Inc." },
    { { 0x00, 0xD0, 0x6D }, "Acrison",      "Acrison, Inc." },
    { { 0x00, 0xD0, 0x6E }, "TrendviewRec", "Trendview Recorders Ltd." },
    { { 0x00, 0xD0, 0x6F }, "KmcControls",  "Kmc Controls" },
    { { 0x00, 0xD0, 0x70 }, "LongWellElec", "Long Well Electronics Corp." },
    { { 0x00, 0xD0, 0x71 }, "Echelon",      "Echelon Corp." },
    { { 0x00, 0xD0, 0x72 }, "Broadlogic",   "Broadlogic" },
    { { 0x00, 0xD0, 0x73 }, "AcnAdvancedC", "Acn Advanced Communications" },
    { { 0x00, 0xD0, 0x74 }, "Taqua",        "Taqua Systems, Inc." },
    { { 0x00, 0xD0, 0x75 }, "AlarisMedica", "Alaris Medical Systems, Inc." },
    { { 0x00, 0xD0, 0x76 }, "BankAmerica",  "Bank of America" },
    { { 0x00, 0xD0, 0x77 }, "LucentTechno", "Lucent Technologies" },
    { { 0x00, 0xD0, 0x78 }, "EltexSweden",  "Eltex of Sweden AB" },
    { { 0x00, 0xD0, 0x79 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0x7A }, "AmaquestComp", "Amaquest Computer Corp." },
    { { 0x00, 0xD0, 0x7B }, "ComcamIntern", "Comcam International Inc" },
    { { 0x00, 0xD0, 0x7C }, "JtektElectro", "Jtekt Electronics Corporation" },
    { { 0x00, 0xD0, 0x7D }, "CosineCommun", "Cosine Communications" },
    { { 0x00, 0xD0, 0x7E }, "Keycorp",      "Keycorp Ltd." },
    { { 0x00, 0xD0, 0x7F }, "StrategyTech", "Strategy & Technology, Limited" },
    { { 0x00, 0xD0, 0x80 }, "Exabyte",      "Exabyte Corporation" },
    { { 0x00, 0xD0, 0x81 }, "RTDEmbeddedT", "RTD Embedded Technologies, Inc." },
    { { 0x00, 0xD0, 0x82 }, "Iowave",       "Iowave Inc." },
    { { 0x00, 0xD0, 0x83 }, "Invertex",     "Invertex, Inc." },
    { { 0x00, 0xD0, 0x84 }, "Nexcomm",      "Nexcomm Systems, Inc." },
    { { 0x00, 0xD0, 0x85 }, "OtisElevator", "Otis Elevator Company" },
    { { 0x00, 0xD0, 0x86 }, "Foveon",       "Foveon, Inc." },
    { { 0x00, 0xD0, 0x87 }, "Microfirst",   "Microfirst Inc." },
    { { 0x00, 0xD0, 0x88 }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0xD0, 0x89 }, "Dynacolor",    "Dynacolor, Inc." },
    { { 0x00, 0xD0, 0x8A }, "PhotronUsa",   "Photron Usa" },
    { { 0x00, 0xD0, 0x8B }, "ADVAOpticalN", "ADVA Optical Networking Ltd." },
    { { 0x00, 0xD0, 0x8C }, "GenoaTechnol", "Genoa Technology, Inc." },
    { { 0x00, 0xD0, 0x8D }, "PhoenixGroup", "Phoenix Group, Inc." },
    { { 0x00, 0xD0, 0x8E }, "GrassValleyA", "Grass Valley, A Belden Brand" },
    { { 0x00, 0xD0, 0x8F }, "ArdentTechno", "Ardent Technologies, Inc." },
    { { 0x00, 0xD0, 0x90 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0x91 }, "Smartsan",     "Smartsan Systems, Inc." },
    { { 0x00, 0xD0, 0x92 }, "GlenayreWest", "Glenayre Western Multiplex" },
    { { 0x00, 0xD0, 0x93 }, "TqComponents", "Tq - Components Gmbh" },
    { { 0x00, 0xD0, 0x94 }, "SeeionContro", "Seeion Control LLC" },
    { { 0x00, 0xD0, 0x95 }, "AlcatelLucen", "Alcatel-Lucent Enterprise" },
    { { 0x00, 0xD0, 0x96 }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x00, 0xD0, 0x97 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0x98 }, "PhotonDynami", "Photon Dynamics Canada Inc." },
    { { 0x00, 0xD0, 0x99 }, "ElcardWirele", "Elcard Wireless Systems Oy" },
    { { 0x00, 0xD0, 0x9A }, "Filanet",      "Filanet Corporation" },
    { { 0x00, 0xD0, 0x9B }, "Spectel",      "Spectel Ltd." },
    { { 0x00, 0xD0, 0x9C }, "KapadiaCommu", "Kapadia Communications" },
    { { 0x00, 0xD0, 0x9D }, "VerisIndustr", "Veris Industries" },
    { { 0x00, 0xD0, 0x9E }, "2Wire",        "2Wire Inc" },
    { { 0x00, 0xD0, 0x9F }, "NovtekTest",   "Novtek Test Systems" },
    { { 0x00, 0xD0, 0xA0 }, "MipsDenmark",  "Mips Denmark" },
    { { 0x00, 0xD0, 0xA1 }, "OskarVierlin", "Oskar Vierling Gmbh + Co. Kg" },
    { { 0x00, 0xD0, 0xA2 }, "IntegratedDe", "Integrated Device" },
    { { 0x00, 0xD0, 0xA3 }, "VocalData",    "Vocal Data, Inc." },
    { { 0x00, 0xD0, 0xA4 }, "AlantroCommu", "Alantro Communications" },
    { { 0x00, 0xD0, 0xA5 }, "AmericanAriu", "American Arium" },
    { { 0x00, 0xD0, 0xA6 }, "LanbirdTechn", "Lanbird Technology Co., Ltd." },
    { { 0x00, 0xD0, 0xA7 }, "TokyoSokkiKe", "Tokyo Sokki Kenkyujo Co., Ltd." },
    { { 0x00, 0xD0, 0xA8 }, "NetworkEngin", "Network Engines, Inc." },
    { { 0x00, 0xD0, 0xA9 }, "ShinanoKensh", "Shinano Kenshi Co., Ltd." },
    { { 0x00, 0xD0, 0xAA }, "ChaseCommuni", "Chase Communications" },
    { { 0x00, 0xD0, 0xAB }, "DeltakabelTe", "Deltakabel Telecom Cv" },
    { { 0x00, 0xD0, 0xAC }, "Commscope",    "Commscope, Inc" },
    { { 0x00, 0xD0, 0xAD }, "TlIndustries", "Tl Industries" },
    { { 0x00, 0xD0, 0xAE }, "OresisCommun", "Oresis Communications, Inc." },
    { { 0x00, 0xD0, 0xAF }, "CutlerHammer", "Cutler-Hammer, Inc." },
    { { 0x00, 0xD0, 0xB0 }, "Bitswitch",    "Bitswitch Ltd." },
    { { 0x00, 0xD0, 0xB1 }, "OmegaElectro", "Omega Electronics Sa" },
    { { 0x00, 0xD0, 0xB2 }, "Xiotech",      "Xiotech Corporation" },
    { { 0x00, 0xD0, 0xB3 }, "DRSTechnolog", "DRS Technologies Canada Ltd" },
    { { 0x00, 0xD0, 0xB4 }, "Katsujima",    "Katsujima Co., Ltd." },
    { { 0x00, 0xD0, 0xB5 }, "IPricotforme", "IPricot formerly DotCom" },
    { { 0x00, 0xD0, 0xB6 }, "CrescentNetw", "Crescent Networks, Inc." },
    { { 0x00, 0xD0, 0xB7 }, "Intel",        "Intel Corporation" },
    { { 0x00, 0xD0, 0xB8 }, "Iomega",       "Iomega Corporation" },
    { { 0x00, 0xD0, 0xB9 }, "MicrotekInte", "Microtek International, Inc." },
    { { 0x00, 0xD0, 0xBA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0xBB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0xBC }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0xBD }, "LatticeSemic", "Lattice Semiconductor Corp. (LPA)" },
    { { 0x00, 0xD0, 0xBE }, "Emutec",       "Emutec Inc." },
    { { 0x00, 0xD0, 0xBF }, "PivotalTechn", "Pivotal Technologies" },
    { { 0x00, 0xD0, 0xC0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0xC1 }, "HarmonicData", "Harmonic Data Systems, Ltd." },
    { { 0x00, 0xD0, 0xC2 }, "BalthazarTec", "Balthazar Technology Ab" },
    { { 0x00, 0xD0, 0xC3 }, "VividTechnol", "Vivid Technology Pte, Ltd." },
    { { 0x00, 0xD0, 0xC4 }, "Teratech",     "Teratech Corporation" },
    { { 0x00, 0xD0, 0xC5 }, "Computationa", "Computational Systems, Inc." },
    { { 0x00, 0xD0, 0xC6 }, "ThomasBetts",  "Thomas & Betts Corp." },
    { { 0x00, 0xD0, 0xC7 }, "Pathway",      "Pathway, Inc." },
    { { 0x00, 0xD0, 0xC8 }, "Prevas",       "Prevas A/S" },
    { { 0x00, 0xD0, 0xC9 }, "Advantech",    "Advantech Co., Ltd." },
    { { 0x00, 0xD0, 0xCA }, "IntrinsycSof", "Intrinsyc Software International Inc." },
    { { 0x00, 0xD0, 0xCB }, "Dasan",        "Dasan Co., Ltd." },
    { { 0x00, 0xD0, 0xCC }, "Technologies", "Technologies Lyre Inc." },
    { { 0x00, 0xD0, 0xCD }, "AtanTechnolo", "Atan Technology Inc." },
    { { 0x00, 0xD0, 0xCE }, "iSystemLabs",  "iSystem Labs" },
    { { 0x00, 0xD0, 0xCF }, "MoretonBay",   "Moreton Bay" },
    { { 0x00, 0xD0, 0xD0 }, "ZhongxingTel", "Zhongxing Telecom Ltd." },
    { { 0x00, 0xD0, 0xD1 }, "SycamoreNetw", "Sycamore Networks" },
    { { 0x00, 0xD0, 0xD2 }, "Epilog",       "Epilog Corporation" },
    { { 0x00, 0xD0, 0xD3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0xD4 }, "VBits",        "V-Bits, Inc." },
    { { 0x00, 0xD0, 0xD5 }, "Grundig",      "Grundig Ag" },
    { { 0x00, 0xD0, 0xD6 }, "AethraTeleco", "Aethra Telecomunicazioni" },
    { { 0x00, 0xD0, 0xD7 }, "B2C2",         "B2C2, Inc." },
    { { 0x00, 0xD0, 0xD8 }, "3Com",         "3Com" },
    { { 0x00, 0xD0, 0xD9 }, "DedicatedMic", "Dedicated Microcomputers" },
    { { 0x00, 0xD0, 0xDA }, "TaicomData",   "Taicom Data Systems Co., Ltd." },
    { { 0x00, 0xD0, 0xDB }, "McquayIntern", "Mcquay International" },
    { { 0x00, 0xD0, 0xDC }, "ModularMinin", "Modular Mining Systems, Inc." },
    { { 0x00, 0xD0, 0xDD }, "SunriseTelec", "Sunrise Telecom, Inc." },
    { { 0x00, 0xD0, 0xDE }, "PhilipsMulti", "Philips Multimedia Network" },
    { { 0x00, 0xD0, 0xDF }, "KuzumiElectr", "Kuzumi Electronics, Inc." },
    { { 0x00, 0xD0, 0xE0 }, "DooinElectro", "Dooin Electronics Co." },
    { { 0x00, 0xD0, 0xE1 }, "AvionitekIsr", "Avionitek Israel Inc." },
    { { 0x00, 0xD0, 0xE2 }, "MrtMicro",     "Mrt Micro, Inc." },
    { { 0x00, 0xD0, 0xE3 }, "EleChemEngin", "Ele-Chem Engineering Co., Ltd." },
    { { 0x00, 0xD0, 0xE4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD0, 0xE5 }, "Solidum",      "Solidum Systems Corp." },
    { { 0x00, 0xD0, 0xE6 }, "Ibond",        "Ibond Inc." },
    { { 0x00, 0xD0, 0xE7 }, "VconTelecomm", "Vcon Telecommunication Ltd." },
    { { 0x00, 0xD0, 0xE8 }, "MacSystem",    "Mac System Co., Ltd." },
    { { 0x00, 0xD0, 0xE9 }, "AdvantageCen", "Advantage Century Telecommunication Corp." },
    { { 0x00, 0xD0, 0xEA }, "NextoneCommu", "Nextone Communications, Inc." },
    { { 0x00, 0xD0, 0xEB }, "LighteraNetw", "Lightera Networks, Inc." },
    { { 0x00, 0xD0, 0xEC }, "NAKAYO",       "NAKAYO Inc" },
    { { 0x00, 0xD0, 0xED }, "Xiox",         "Xiox" },
    { { 0x00, 0xD0, 0xEE }, "Dictaphone",   "Dictaphone Corporation" },
    { { 0x00, 0xD0, 0xEF }, "Igt",          "Igt" },
    { { 0x00, 0xD0, 0xF0 }, "ConvisionTec", "Convision Technology Gmbh" },
    { { 0x00, 0xD0, 0xF1 }, "SegaEnterpri", "Sega Enterprises, Ltd." },
    { { 0x00, 0xD0, 0xF2 }, "MontereyNetw", "Monterey Networks" },
    { { 0x00, 0xD0, 0xF3 }, "SolariDiUdin", "Solari Di Udine Spa" },
    { { 0x00, 0xD0, 0xF4 }, "CarinthianTe", "Carinthian Tech Institute" },
    { { 0x00, 0xD0, 0xF5 }, "OrangeMicro",  "Orange Micro, Inc." },
    { { 0x00, 0xD0, 0xF6 }, "Nokia",        "Nokia" },
    { { 0x00, 0xD0, 0xF7 }, "NextNets",     "Next Nets Corporation" },
    { { 0x00, 0xD0, 0xF8 }, "FujianStarTe", "Fujian Star Terminal" },
    { { 0x00, 0xD0, 0xF9 }, "AcuteCommuni", "Acute Communications Corp." },
    { { 0x00, 0xD0, 0xFA }, "ThaleseSecur", "Thales e-Security Ltd." },
    { { 0x00, 0xD0, 0xFB }, "TekMicrosyst", "Tek Microsystems, Incorporated" },
    { { 0x00, 0xD0, 0xFC }, "GraniteMicro", "Granite Microsystems" },
    { { 0x00, 0xD0, 0xFD }, "OptimaTeleCo", "Optima Tele.Com, Inc." },
    { { 0x00, 0xD0, 0xFE }, "AstralPoint",  "Astral Point" },
    { { 0x00, 0xD0, 0xFF }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD1, 0x1C }, "Acetel",       "Acetel" },
    { { 0x00, 0xD2, 0x79 }, "VingroupJoin", "Vingroup Joint Stock Company" },
    { { 0x00, 0xD2, 0xB1 }, "TPVDisplayTe", "TPV Display Technology (Xiamen) Co.,Ltd." },
    { { 0x00, 0xD3, 0x18 }, "SPGControls",  "SPG Controls" },
    { { 0x00, 0xD3, 0x8D }, "HotelTechnol", "Hotel Technology Next Generation" },
    { { 0x00, 0xD4, 0x9E }, "Intel",        "Intel Corporate" },
    { { 0x00, 0xD5, 0x98 }, "BopelMobileT", "Bopel Mobile Technology Co.,Limited" },
    { { 0x00, 0xD6, 0x32 }, "GEEnergy",     "GE Energy" },
    { { 0x00, 0xD6, 0xCB }, "QuectelWirel", "Quectel Wireless Solutions Co.,Ltd." },
    { { 0x00, 0xD6, 0xFE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD7, 0x6D }, "Intel",        "Intel Corporate" },
    { { 0x00, 0xD7, 0x8F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xD8, 0x61 }, "MicroStarINT", "Micro-Star INTL CO., LTD." },
    { { 0x00, 0xD8, 0xA2 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x00, 0xD9, 0xD1 }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0xDA, 0x55 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xDB, 0x1E }, "AlbedoTeleco", "Albedo Telecom SL" },
    { { 0x00, 0xDB, 0x45 }, "Thamway",      "Thamway Co.,Ltd." },
    { { 0x00, 0xDB, 0x70 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xDB, 0xDF }, "Intel",        "Intel Corporate" },
    { { 0x00, 0xDC, 0xB2 }, "ExtremeNetwo", "Extreme Networks Headquarters" },
    { { 0x00, 0xDD, 0x00 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x01 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x02 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x03 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x04 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x05 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x06 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x07 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x08 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x09 }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x0A }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x0B }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x0C }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x0D }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x0E }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x0F }, "UngermannBas", "Ungermann-Bass Inc." },
    { { 0x00, 0xDD, 0x25 }, "hechengdongT", "Shenzhen hechengdong Technology Co., Ltd" },
    { { 0x00, 0xDD, 0xB6 }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x00, 0xDE, 0xFB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xDF, 0x1D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0x00 }, "Fujitsu",      "Fujitsu Limited" },
    { { 0x00, 0xE0, 0x01 }, "StrandLighti", "Strand Lighting Limited" },
    { { 0x00, 0xE0, 0x02 }, "Crossroads",   "Crossroads Systems, Inc." },
    { { 0x00, 0xE0, 0x03 }, "NokiaWireles", "Nokia Wireless Business Commun" },
    { { 0x00, 0xE0, 0x04 }, "PmcSierra",    "Pmc-Sierra, Inc." },
    { { 0x00, 0xE0, 0x05 }, "Technical",    "Technical Corp." },
    { { 0x00, 0xE0, 0x06 }, "SiliconInteg", "Silicon Integrated Sys. Corp." },
    { { 0x00, 0xE0, 0x07 }, "AvayaECS",     "Avaya ECS Ltd" },
    { { 0x00, 0xE0, 0x08 }, "AmazingContr", "Amazing Controls! Inc." },
    { { 0x00, 0xE0, 0x09 }, "StratusTechn", "Stratus Technologies" },
    { { 0x00, 0xE0, 0x0A }, "Diba",         "Diba, Inc." },
    { { 0x00, 0xE0, 0x0B }, "RooftopCommu", "Rooftop Communications Corp." },
    { { 0x00, 0xE0, 0x0C }, "Motorola",     "Motorola" },
    { { 0x00, 0xE0, 0x0D }, "Radiant",      "Radiant Systems" },
    { { 0x00, 0xE0, 0x0E }, "AvalonImagin", "Avalon Imaging Systems, Inc." },
    { { 0x00, 0xE0, 0x0F }, "BaudDataComm", "Shanghai Baud Data Communication Co.,Ltd." },
    { { 0x00, 0xE0, 0x10 }, "HESSSBAUTOMA", "HESS SB-AUTOMATENBAU GmbH" },
    { { 0x00, 0xE0, 0x11 }, "Uniden",       "Uniden Corporation" },
    { { 0x00, 0xE0, 0x12 }, "PlutoTechnol", "Pluto Technologies International Inc." },
    { { 0x00, 0xE0, 0x13 }, "EasternElect", "Eastern Electronic Co., Ltd." },
    { { 0x00, 0xE0, 0x14 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0x15 }, "Heiwa",        "Heiwa Corporation" },
    { { 0x00, 0xE0, 0x16 }, "RapidCityCom", "Rapid City Communications" },
    { { 0x00, 0xE0, 0x17 }, "EXXACT",       "EXXACT GmbH" },
    { { 0x00, 0xE0, 0x18 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x00, 0xE0, 0x19 }, "IngGiordanoE", "Ing. Giordano Elettronica" },
    { { 0x00, 0xE0, 0x1A }, "Comtec",       "Comtec Systems. Co., Ltd." },
    { { 0x00, 0xE0, 0x1B }, "SphereCommun", "Sphere Communications, Inc." },
    { { 0x00, 0xE0, 0x1C }, "CradlePoint",  "CradlePoint, Inc" },
    { { 0x00, 0xE0, 0x1D }, "WebTVNETWORK", "WebTV NETWORKS, INC." },
    { { 0x00, 0xE0, 0x1E }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0x1F }, "AVIDIA",       "AVIDIA Systems, Inc." },
    { { 0x00, 0xE0, 0x20 }, "Tecnomen",     "Tecnomen Oy" },
    { { 0x00, 0xE0, 0x21 }, "Freegate",     "Freegate Corp." },
    { { 0x00, 0xE0, 0x22 }, "AnalogDevice", "Analog Devices, Inc." },
    { { 0x00, 0xE0, 0x23 }, "Telrad",       "Telrad" },
    { { 0x00, 0xE0, 0x24 }, "GadzooxNetwo", "Gadzoox Networks" },
    { { 0x00, 0xE0, 0x25 }, "dit",          "dit Co., Ltd." },
    { { 0x00, 0xE0, 0x26 }, "RedlakeMASD",  "Redlake MASD LLC" },
    { { 0x00, 0xE0, 0x27 }, "Dux",          "Dux, Inc." },
    { { 0x00, 0xE0, 0x28 }, "Aptix",        "Aptix Corporation" },
    { { 0x00, 0xE0, 0x29 }, "StandardMicr", "Standard Microsystems Corp." },
    { { 0x00, 0xE0, 0x2A }, "TandbergTele", "Tandberg Television As" },
    { { 0x00, 0xE0, 0x2B }, "ExtremeNetwo", "Extreme Networks Headquarters" },
    { { 0x00, 0xE0, 0x2C }, "AstComputer",  "Ast Computer" },
    { { 0x00, 0xE0, 0x2D }, "InnoMediaLog", "InnoMediaLogic, Inc." },
    { { 0x00, 0xE0, 0x2E }, "SpcElectroni", "Spc Electronics Corporation" },
    { { 0x00, 0xE0, 0x2F }, "McnsHoldings", "Mcns Holdings, L.P." },
    { { 0x00, 0xE0, 0x30 }, "MelitaIntern", "Melita International Corp." },
    { { 0x00, 0xE0, 0x31 }, "HagiwaraElec", "Hagiwara Electric Co., Ltd." },
    { { 0x00, 0xE0, 0x32 }, "MisysFinanci", "Misys Financial Systems, Ltd." },
    { { 0x00, 0xE0, 0x33 }, "EEPD",         "E.E.P.D. GmbH" },
    { { 0x00, 0xE0, 0x34 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0x35 }, "ArtesynEmbed", "Artesyn Embedded Technologies" },
    { { 0x00, 0xE0, 0x36 }, "Pioneer",      "Pioneer Corporation" },
    { { 0x00, 0xE0, 0x37 }, "Century",      "Century Corporation" },
    { { 0x00, 0xE0, 0x38 }, "Proxima",      "Proxima Corporation" },
    { { 0x00, 0xE0, 0x39 }, "Paradyne",     "Paradyne Corp." },
    { { 0x00, 0xE0, 0x3A }, "Cabletron",    "Cabletron Systems, Inc." },
    { { 0x00, 0xE0, 0x3B }, "Prominet",     "Prominet Corporation" },
    { { 0x00, 0xE0, 0x3C }, "AdvanSys",     "AdvanSys" },
    { { 0x00, 0xE0, 0x3D }, "FoconElectro", "Focon Electronic Systems A/S" },
    { { 0x00, 0xE0, 0x3E }, "Alfatech",     "Alfatech, Inc." },
    { { 0x00, 0xE0, 0x3F }, "Jaton",        "Jaton Corporation" },
    { { 0x00, 0xE0, 0x40 }, "DeskStationT", "DeskStation Technology, Inc." },
    { { 0x00, 0xE0, 0x41 }, "Cspi",         "Cspi" },
    { { 0x00, 0xE0, 0x42 }, "Pacom",        "Pacom Systems Ltd." },
    { { 0x00, 0xE0, 0x43 }, "VitalCom",     "VitalCom" },
    { { 0x00, 0xE0, 0x44 }, "Lsics",        "Lsics Corporation" },
    { { 0x00, 0xE0, 0x45 }, "Touchwave",    "Touchwave, Inc." },
    { { 0x00, 0xE0, 0x46 }, "BentlyNevada", "Bently Nevada Corp." },
    { { 0x00, 0xE0, 0x47 }, "InFocus",      "InFocus Corporation" },
    { { 0x00, 0xE0, 0x48 }, "SdlCommunica", "Sdl Communications, Inc." },
    { { 0x00, 0xE0, 0x49 }, "MICROWIELECT", "MICROWI ELECTRONIC GmbH" },
    { { 0x00, 0xE0, 0x4A }, "ZXTechnologi", "ZX Technologies, Inc" },
    { { 0x00, 0xE0, 0x4B }, "JUMPINDUSTRI", "JUMP INDUSTRIELLE COMPUTERTECHNIK GmbH" },
    { { 0x00, 0xE0, 0x4C }, "RealtekSemic", "Realtek Semiconductor Corp." },
    { { 0x00, 0xE0, 0x4D }, "InternetInit", "Internet Initiative Japan, Inc" },
    { { 0x00, 0xE0, 0x4E }, "SanyoDenki",   "Sanyo Denki Co., Ltd." },
    { { 0x00, 0xE0, 0x4F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0x50 }, "ExecutoneInf", "Executone Information Systems, Inc." },
    { { 0x00, 0xE0, 0x51 }, "Talx",         "Talx Corporation" },
    { { 0x00, 0xE0, 0x52 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x00, 0xE0, 0x53 }, "CellportLabs", "Cellport Labs, Inc." },
    { { 0x00, 0xE0, 0x54 }, "KodaiHitec",   "Kodai Hitec Co., Ltd." },
    { { 0x00, 0xE0, 0x55 }, "IngenieriaEl", "Ingenieria Electronica Comercial Inelcom S.A." },
    { { 0x00, 0xE0, 0x56 }, "Holontech",    "Holontech Corporation" },
    { { 0x00, 0xE0, 0x57 }, "HanMicrotele", "Han Microtelecom. Co., Ltd." },
    { { 0x00, 0xE0, 0x58 }, "PhaseOneDenm", "Phase One Denmark A/S" },
    { { 0x00, 0xE0, 0x59 }, "ControlledEn", "Controlled Environments, Ltd." },
    { { 0x00, 0xE0, 0x5A }, "GaleaNetwork", "Galea Network Security" },
    { { 0x00, 0xE0, 0x5B }, "WestEnd",      "West End Systems Corp." },
    { { 0x00, 0xE0, 0x5C }, "PHC",          "PHC Corporation" },
    { { 0x00, 0xE0, 0x5D }, "Unitec",       "Unitec Co., Ltd." },
    { { 0x00, 0xE0, 0x5E }, "JapanAviatio", "Japan Aviation Electronics Industry, Ltd." },
    { { 0x00, 0xE0, 0x5F }, "eNet",         "e-Net, Inc." },
    { { 0x00, 0xE0, 0x60 }, "Sherwood",     "Sherwood" },
    { { 0x00, 0xE0, 0x61 }, "EdgePointNet", "EdgePoint Networks, Inc." },
    { { 0x00, 0xE0, 0x62 }, "HostEngineer", "Host Engineering" },
    { { 0x00, 0xE0, 0x63 }, "Cabletron",    "Cabletron Systems, Inc." },
    { { 0x00, 0xE0, 0x64 }, "SamsungElect", "Samsung Electronics" },
    { { 0x00, 0xE0, 0x65 }, "OpticalAcces", "Optical Access International" },
    { { 0x00, 0xE0, 0x66 }, "ProMax",       "ProMax Systems, Inc." },
    { { 0x00, 0xE0, 0x67 }, "eacAUTOMATIO", "eac AUTOMATION-CONSULTING GmbH" },
    { { 0x00, 0xE0, 0x68 }, "Merrimac",     "Merrimac Systems Inc." },
    { { 0x00, 0xE0, 0x69 }, "Jaycor",       "Jaycor" },
    { { 0x00, 0xE0, 0x6A }, "Kapsch",       "Kapsch Ag" },
    { { 0x00, 0xE0, 0x6B }, "W&GSpecialPr", "W&G Special Products" },
    { { 0x00, 0xE0, 0x6C }, "UltraElectro", "Ultra Electronics Command & Control Systems" },
    { { 0x00, 0xE0, 0x6D }, "Compuware",    "Compuware Corporation" },
    { { 0x00, 0xE0, 0x6E }, "FAR",          "FAR SYSTEMS S.p.A." },
    { { 0x00, 0xE0, 0x6F }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x00, 0xE0, 0x70 }, "DhTechnology", "Dh Technology" },
    { { 0x00, 0xE0, 0x71 }, "EpisMicrocom", "Epis Microcomputer" },
    { { 0x00, 0xE0, 0x72 }, "Lynk",         "Lynk" },
    { { 0x00, 0xE0, 0x73 }, "NationalAmus", "National Amusement Network, Inc." },
    { { 0x00, 0xE0, 0x74 }, "TiernanCommu", "Tiernan Communications, Inc." },
    { { 0x00, 0xE0, 0x75 }, "Verilink",     "Verilink Corporation" },
    { { 0x00, 0xE0, 0x76 }, "DevelopmentC", "Development Concepts, Inc." },
    { { 0x00, 0xE0, 0x77 }, "Webgear",      "Webgear, Inc." },
    { { 0x00, 0xE0, 0x78 }, "BerkeleyNetw", "Berkeley Networks" },
    { { 0x00, 0xE0, 0x79 }, "ATNR",         "A.T.N.R." },
    { { 0x00, 0xE0, 0x7A }, "Mikrodidakt",  "Mikrodidakt Ab" },
    { { 0x00, 0xE0, 0x7B }, "BayNetworks",  "Bay Networks" },
    { { 0x00, 0xE0, 0x7C }, "MettlerToled", "Mettler-Toledo, Inc." },
    { { 0x00, 0xE0, 0x7D }, "Netronix",     "Netronix, Inc." },
    { { 0x00, 0xE0, 0x7E }, "WaltDisneyIm", "Walt Disney Imagineering" },
    { { 0x00, 0xE0, 0x7F }, "LOGISTISTEM",  "LOGISTISTEM s.r.l." },
    { { 0x00, 0xE0, 0x80 }, "ControlResou", "Control Resources Corporation" },
    { { 0x00, 0xE0, 0x81 }, "TyanComputer", "Tyan Computer Corp." },
    { { 0x00, 0xE0, 0x82 }, "Anerma",       "Anerma" },
    { { 0x00, 0xE0, 0x83 }, "JatoTechnolo", "Jato Technologies, Inc." },
    { { 0x00, 0xE0, 0x84 }, "CompuliteR&D", "Compulite R&D" },
    { { 0x00, 0xE0, 0x85 }, "GlobalMainte", "Global Maintech, Inc." },
    { { 0x00, 0xE0, 0x86 }, "EmersonNetwo", "Emerson Network Power, Avocent Division" },
    { { 0x00, 0xE0, 0x87 }, "LeCroyNetwor", "LeCroy - Networking Productions Division" },
    { { 0x00, 0xE0, 0x88 }, "LTXCredence",  "LTX-Credence CORPORATION" },
    { { 0x00, 0xE0, 0x89 }, "IONNetworks",  "ION Networks, Inc." },
    { { 0x00, 0xE0, 0x8A }, "GecAvery",     "Gec Avery, Ltd." },
    { { 0x00, 0xE0, 0x8B }, "QLogic",       "QLogic Corporation" },
    { { 0x00, 0xE0, 0x8C }, "NeoparadigmL", "Neoparadigm Labs, Inc." },
    { { 0x00, 0xE0, 0x8D }, "Pressure",     "Pressure Systems, Inc." },
    { { 0x00, 0xE0, 0x8E }, "Utstarcom",    "Utstarcom" },
    { { 0x00, 0xE0, 0x8F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0x90 }, "BeckmanLabAu", "Beckman Lab. Automation Div." },
    { { 0x00, 0xE0, 0x91 }, "LGElectronic", "LG Electronics" },
    { { 0x00, 0xE0, 0x92 }, "Admtek",       "Admtek Incorporated" },
    { { 0x00, 0xE0, 0x93 }, "AckfinNetwor", "Ackfin Networks" },
    { { 0x00, 0xE0, 0x94 }, "Osai",         "Osai Srl" },
    { { 0x00, 0xE0, 0x95 }, "AdvancedVisi", "Advanced-Vision Technolgies Corp." },
    { { 0x00, 0xE0, 0x96 }, "Shimadzu",     "Shimadzu Corporation" },
    { { 0x00, 0xE0, 0x97 }, "CarrierAcces", "Carrier Access Corporation" },
    { { 0x00, 0xE0, 0x98 }, "AboCom",       "AboCom" },
    { { 0x00, 0xE0, 0x99 }, "Samson",       "Samson Ag" },
    { { 0x00, 0xE0, 0x9A }, "Positron",     "Positron Inc." },
    { { 0x00, 0xE0, 0x9B }, "EngageNetwor", "Engage Networks, Inc." },
    { { 0x00, 0xE0, 0x9C }, "Mii",          "Mii" },
    { { 0x00, 0xE0, 0x9D }, "Sarnoff",      "Sarnoff Corporation" },
    { { 0x00, 0xE0, 0x9E }, "Quantum",      "Quantum Corporation" },
    { { 0x00, 0xE0, 0x9F }, "PixelVision",  "Pixel Vision" },
    { { 0x00, 0xE0, 0xA0 }, "Wiltron",      "Wiltron Co." },
    { { 0x00, 0xE0, 0xA1 }, "HIMAPAULHILD", "HIMA PAUL HILDEBRANDT GmbH Co. KG" },
    { { 0x00, 0xE0, 0xA2 }, "Microslate",   "Microslate Inc." },
    { { 0x00, 0xE0, 0xA3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0xA4 }, "ESAOTE",       "ESAOTE S.p.A." },
    { { 0x00, 0xE0, 0xA5 }, "ComCoreSemic", "ComCore Semiconductor, Inc." },
    { { 0x00, 0xE0, 0xA6 }, "TelogyNetwor", "Telogy Networks, Inc." },
    { { 0x00, 0xE0, 0xA7 }, "IpcInformati", "Ipc Information Systems, Inc." },
    { { 0x00, 0xE0, 0xA8 }, "SAT",          "SAT GmbH & Co." },
    { { 0x00, 0xE0, 0xA9 }, "FunaiElectri", "Funai Electric Co., Ltd." },
    { { 0x00, 0xE0, 0xAA }, "Electrosonic", "Electrosonic Ltd." },
    { { 0x00, 0xE0, 0xAB }, "Dimat",        "Dimat S.A." },
    { { 0x00, 0xE0, 0xAC }, "Midsco",       "Midsco, Inc." },
    { { 0x00, 0xE0, 0xAD }, "EesTechnolog", "Ees Technology, Ltd." },
    { { 0x00, 0xE0, 0xAE }, "Xaqti",        "Xaqti Corporation" },
    { { 0x00, 0xE0, 0xAF }, "GeneralDynam", "General Dynamics Information Systems" },
    { { 0x00, 0xE0, 0xB0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0xB1 }, "AlcatelLucen", "Alcatel-Lucent Enterprise" },
    { { 0x00, 0xE0, 0xB2 }, "TelmaxCommun", "Telmax Communications Corp." },
    { { 0x00, 0xE0, 0xB3 }, "EtherWAN",     "EtherWAN Systems, Inc." },
    { { 0x00, 0xE0, 0xB4 }, "TechnoScope",  "Techno Scope Co., Ltd." },
    { { 0x00, 0xE0, 0xB5 }, "ArdentCommun", "Ardent Communications Corp." },
    { { 0x00, 0xE0, 0xB6 }, "EntradaNetwo", "Entrada Networks" },
    { { 0x00, 0xE0, 0xB7 }, "CosworthElec", "Cosworth Electronics Ltd" },
    { { 0x00, 0xE0, 0xB8 }, "Gateway2000",  "Gateway 2000" },
    { { 0x00, 0xE0, 0xB9 }, "Byas",         "Byas Systems" },
    { { 0x00, 0xE0, 0xBA }, "BERGHOFAUTOM", "BERGHOF AUTOMATIONSTECHNIK GmbH" },
    { { 0x00, 0xE0, 0xBB }, "Nbx",          "Nbx Corporation" },
    { { 0x00, 0xE0, 0xBC }, "SymonCommuni", "Symon Communications, Inc." },
    { { 0x00, 0xE0, 0xBD }, "Interface",    "Interface Systems, Inc." },
    { { 0x00, 0xE0, 0xBE }, "GenrocoInter", "Genroco International, Inc." },
    { { 0x00, 0xE0, 0xBF }, "TorrentNetwo", "Torrent Networking Technologies Corp." },
    { { 0x00, 0xE0, 0xC0 }, "SeiwaElectri", "Seiwa Electric Mfg. Co., Ltd." },
    { { 0x00, 0xE0, 0xC1 }, "MemorexTelex", "Memorex Telex Japan, Ltd." },
    { { 0x00, 0xE0, 0xC2 }, "NECSY",        "NECSY S.p.A." },
    { { 0x00, 0xE0, 0xC3 }, "SakaiSystemD", "Sakai System Development Corp." },
    { { 0x00, 0xE0, 0xC4 }, "HornerElectr", "Horner Electric, Inc." },
    { { 0x00, 0xE0, 0xC5 }, "BcomElectron", "Bcom Electronics Inc." },
    { { 0x00, 0xE0, 0xC6 }, "Link2ItLLC",   "Link2It, L.L.C." },
    { { 0x00, 0xE0, 0xC7 }, "Eurotech",     "Eurotech Srl" },
    { { 0x00, 0xE0, 0xC8 }, "VirtualAcces", "Virtual Access, Ltd." },
    { { 0x00, 0xE0, 0xC9 }, "AutomatedLog", "AutomatedLogic Corporation" },
    { { 0x00, 0xE0, 0xCA }, "BestDataProd", "Best Data Products" },
    { { 0x00, 0xE0, 0xCB }, "Reson",        "Reson, Inc." },
    { { 0x00, 0xE0, 0xCC }, "Hero",         "Hero Systems, Ltd." },
    { { 0x00, 0xE0, 0xCD }, "SaabSensis",   "Saab Sensis Corporation" },
    { { 0x00, 0xE0, 0xCE }, "Arn",          "Arn" },
    { { 0x00, 0xE0, 0xCF }, "IntegratedDe", "Integrated Device" },
    { { 0x00, 0xE0, 0xD0 }, "Netspeed",     "Netspeed, Inc." },
    { { 0x00, 0xE0, 0xD1 }, "Telsis",       "Telsis Limited" },
    { { 0x00, 0xE0, 0xD2 }, "VersanetComm", "Versanet Communications, Inc." },
    { { 0x00, 0xE0, 0xD3 }, "DATENTECHNIK", "DATENTECHNIK GmbH" },
    { { 0x00, 0xE0, 0xD4 }, "ExcellentCom", "Excellent Computer" },
    { { 0x00, 0xE0, 0xD5 }, "Emulex",       "Emulex Corporation" },
    { { 0x00, 0xE0, 0xD6 }, "ComputerComm", "Computer & Communication Research Lab." },
    { { 0x00, 0xE0, 0xD7 }, "SunshineElec", "Sunshine Electronics, Inc." },
    { { 0x00, 0xE0, 0xD8 }, "LANBitComput", "LANBit Computer, Inc." },
    { { 0x00, 0xE0, 0xD9 }, "Tazmo",        "Tazmo Co., Ltd." },
    { { 0x00, 0xE0, 0xDA }, "AlcatelLucen", "Alcatel-Lucent Enterprise" },
    { { 0x00, 0xE0, 0xDB }, "ViaVideoComm", "ViaVideo Communications, Inc." },
    { { 0x00, 0xE0, 0xDC }, "Nexware",      "Nexware Corp." },
    { { 0x00, 0xE0, 0xDD }, "ZenithElectr", "Zenith Electronics Corporation" },
    { { 0x00, 0xE0, 0xDE }, "Datax",        "Datax Nv" },
    { { 0x00, 0xE0, 0xDF }, "DZS",          "DZS Inc." },
    { { 0x00, 0xE0, 0xE0 }, "SiElectronic", "Si Electronics, Ltd." },
    { { 0x00, 0xE0, 0xE1 }, "G2Networks",   "G2 Networks, Inc." },
    { { 0x00, 0xE0, 0xE2 }, "Innova",       "Innova Corp." },
    { { 0x00, 0xE0, 0xE3 }, "SkElektronik", "Sk-Elektronik Gmbh" },
    { { 0x00, 0xE0, 0xE4 }, "FANUCROBOTIC", "FANUC ROBOTICS NORTH AMERICA, Inc." },
    { { 0x00, 0xE0, 0xE5 }, "CincoNetwork", "Cinco Networks, Inc." },
    { { 0x00, 0xE0, 0xE6 }, "INCAACompute", "INCAA Computers" },
    { { 0x00, 0xE0, 0xE7 }, "RaytheonE",    "Raytheon E-Systems, Inc." },
    { { 0x00, 0xE0, 0xE8 }, "GRETACODERDa", "GRETACODER Data Systems AG" },
    { { 0x00, 0xE0, 0xE9 }, "DataLabs",     "Data Labs, Inc." },
    { { 0x00, 0xE0, 0xEA }, "InnovatCommu", "Innovat Communications, Inc." },
    { { 0x00, 0xE0, 0xEB }, "Digicom",      "Digicom Systems, Incorporated" },
    { { 0x00, 0xE0, 0xEC }, "Celestica",    "Celestica Inc." },
    { { 0x00, 0xE0, 0xED }, "Silicom",      "Silicom, Ltd." },
    { { 0x00, 0xE0, 0xEE }, "MarelHf",      "Marel Hf" },
    { { 0x00, 0xE0, 0xEF }, "Dionex",       "Dionex" },
    { { 0x00, 0xE0, 0xF0 }, "AblerTechnol", "Abler Technology, Inc." },
    { { 0x00, 0xE0, 0xF1 }, "That",         "That Corporation" },
    { { 0x00, 0xE0, 0xF2 }, "ArlottoComne", "Arlotto Comnet, Inc." },
    { { 0x00, 0xE0, 0xF3 }, "WebSprintCom", "WebSprint Communications, Inc." },
    { { 0x00, 0xE0, 0xF4 }, "INSIDETechno", "INSIDE Technology A/S" },
    { { 0x00, 0xE0, 0xF5 }, "Teles",        "Teles Ag" },
    { { 0x00, 0xE0, 0xF6 }, "DecisionEuro", "Decision Europe" },
    { { 0x00, 0xE0, 0xF7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0xF8 }, "DicnaControl", "Dicna Control Ab" },
    { { 0x00, 0xE0, 0xF9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0xFA }, "TrlTechnolog", "Trl Technology, Ltd." },
    { { 0x00, 0xE0, 0xFB }, "Leightronix",  "Leightronix, Inc." },
    { { 0x00, 0xE0, 0xFC }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0xE0, 0xFD }, "ATrendTechno", "A-Trend Technology Co., Ltd." },
    { { 0x00, 0xE0, 0xFE }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE0, 0xFF }, "SECURITYDYNA", "SECURITY DYNAMICS TECHNOLOGIES, Inc." },
    { { 0x00, 0xE1, 0x6D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xE1, 0x75 }, "AK",           "AK-Systems Ltd" },
    { { 0x00, 0xE1, 0x8C }, "Intel",        "Intel Corporate" },
    { { 0x00, 0xE2, 0x2C }, "ChinaMobileG", "China Mobile Group Device Co.,Ltd." },
    { { 0x00, 0xE3, 0xB2 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0xE4, 0x00 }, "SichuanChang", "Sichuan Changhong Electric Ltd." },
    { { 0x00, 0xE4, 0x06 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0xE4, 0x21 }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x00, 0xE5, 0xE4 }, "SichuanTiany", "Sichuan Tianyi Comheart Telecom Co.,LTD" },
    { { 0x00, 0xE5, 0xF1 }, "Buffalo",      "Buffalo.Inc" },
    { { 0x00, 0xE6, 0x0E }, "ExtremeNetwo", "Extreme Networks Headquarters" },
    { { 0x00, 0xE6, 0x3A }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x00, 0xE6, 0x66 }, "ARIMACommuni", "ARIMA Communications Corp." },
    { { 0x00, 0xE6, 0xD3 }, "NixdorfCompu", "Nixdorf Computer Corp." },
    { { 0x00, 0xE6, 0xE8 }, "NetzinTechno", "Netzin Technology Corporation,.Ltd." },
    { { 0x00, 0xE7, 0xE3 }, "zte",          "zte corporation" },
    { { 0x00, 0xE8, 0xAB }, "MeggittTrain", "Meggitt Training Systems, Inc." },
    { { 0x00, 0xE9, 0x3A }, "AzureWaveTec", "AzureWave Technology Inc." },
    { { 0x00, 0xEA, 0xBD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xEB, 0x2D }, "Sony",         "Sony Corporation" },
    { { 0x00, 0xEB, 0xD5 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xEB, 0xD8 }, "MercusysTech", "Mercusys Technologies Co., Ltd." },
    { { 0x00, 0xEC, 0x0A }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x00, 0xED, 0xB8 }, "KYOCERA",      "KYOCERA Corporation" },
    { { 0x00, 0xEE, 0x01 }, "EnablersSolu", "Enablers Solucoes e Consultoria em Dispositivos" },
    { { 0x00, 0xEE, 0xAB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xEE, 0xBD }, "HTC",          "HTC Corporation" },
    { { 0x00, 0xF0, 0x51 }, "KWB",          "KWB Gmbh" },
    { { 0x00, 0xF2, 0x2C }, "BstarTechnol", "Shanghai B-star Technology Co.,Ltd." },
    { { 0x00, 0xF2, 0x8B }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xF3, 0x61 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x00, 0xF3, 0x9F }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xF3, 0xDB }, "WOOSports",    "WOO Sports" },
    { { 0x00, 0xF4, 0x03 }, "Orbis",        "Orbis Systems Oy" },
    { { 0x00, 0xF4, 0x6F }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0xF4, 0x8D }, "LiteonTechno", "Liteon Technology Corporation" },
    { { 0x00, 0xF4, 0xB9 }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xF6, 0x20 }, "Google",       "Google, Inc." },
    { { 0x00, 0xF6, 0x63 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xF7, 0x6F }, "Apple",        "Apple, Inc." },
    { { 0x00, 0xF7, 0xAD }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0xF8, 0x1C }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0xF8, 0x2C }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xF8, 0x60 }, "PTPanggungEl", "PT. Panggung Electric Citrabuana" },
    { { 0x00, 0xF8, 0x71 }, "Demant",       "Demant A/S" },
    { { 0x00, 0xF8, 0xCC }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x00, 0xF9, 0x52 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x00, 0xFA, 0x21 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x00, 0xFA, 0x3B }, "CloosElectro", "Cloos Electronic Gmbh" },
    { { 0x00, 0xFA, 0xB6 }, "KontaktMicro", "Kontakt Micro-Location Sp z o.o." },
    { { 0x00, 0xFB, 0xF9 }, "Axiado",       "Axiado Corporation" },
    { { 0x00, 0xFC, 0x58 }, "WebSilicon",   "WebSilicon Ltd." },
    { { 0x00, 0xFC, 0x70 }, "IntrepidCont", "Intrepid Control Systems, Inc." },
    { { 0x00, 0xFC, 0x8B }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x00, 0xFC, 0x8D }, "HitronTechno", "Hitron Technologies. Inc" },
    { { 0x00, 0xFC, 0xBA }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xFD, 0x22 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x00, 0xFD, 0x45 }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x00, 0xFD, 0x4C }, "Nevatec",      "Nevatec" },
    { { 0x00, 0xFE, 0xC8 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x02, 0x07, 0x01 }, "RacalDatacom", "Racal-Datacom" },
    { { 0x02, 0x1C, 0x7C }, "Perq",         "Perq Systems Corporation" },
    { { 0x02, 0x60, 0x86 }, "LogicReplace", "Logic Replacement Tech. Ltd." },
    { { 0x02, 0x60, 0x8C }, "3Com",         "3Com" },
    { { 0x02, 0x70, 0x01 }, "RacalDatacom", "Racal-Datacom" },
    { { 0x02, 0x70, 0xB0 }, "MAComCompani", "M/A-Com Inc. Companies" },
    { { 0x02, 0x70, 0xB3 }, "DataRecall",   "Data Recall Ltd." },
    { { 0x02, 0x9D, 0x8E }, "CardiacRecor", "Cardiac Recorders, Inc." },
    { { 0x02, 0xAA, 0x3C }, "OlivettiTele", "Olivetti Telecomm Spa (Olteco)" },
    { { 0x02, 0xBB, 0x01 }, "Octothorpe",   "Octothorpe Corp." },
    { { 0x02, 0xC0, 0x8C }, "3Com",         "3Com" },
    { { 0x02, 0xCF, 0x1C }, "Communicatio", "Communication Machinery Corporation" },
    { { 0x02, 0xE6, 0xD3 }, "NixdorfCompu", "Nixdorf Computer Corp." },
    { { 0x04, 0x00, 0x67 }, "StanleyBlack", "Stanley Black & Decker" },
    { { 0x04, 0x01, 0xA1 }, "Fortinet",     "Fortinet, Inc." },
    { { 0x04, 0x01, 0xBB }, "TecnoMobile",  "Tecno Mobile Limited" },
    { { 0x04, 0x02, 0x1F }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x02, 0xCA }, "Vtsonic",      "Shenzhen Vtsonic Co.,ltd" },
    { { 0x04, 0x03, 0x12 }, "HikvisionDig", "Hangzhou Hikvision Digital Technology Co.,Ltd." },
    { { 0x04, 0x03, 0xD6 }, "Nintendo",     "Nintendo Co.,Ltd" },
    { { 0x04, 0x04, 0xB8 }, "ChinaHualuPa", "China Hualu Panasonic AVC Networks Co., LTD." },
    { { 0x04, 0x04, 0xEA }, "ValensSemico", "Valens Semiconductor Ltd." },
    { { 0x04, 0x05, 0xDD }, "CultraviewDi", "Shenzhen Cultraview Digital Technology Co., Ltd" },
    { { 0x04, 0x07, 0x2E }, "VTechElectro", "VTech Electronics Ltd." },
    { { 0x04, 0x09, 0x73 }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x04, 0x09, 0x86 }, "Arcadyan",     "Arcadyan Corporation" },
    { { 0x04, 0x09, 0xA5 }, "HFR",          "HFR, Inc." },
    { { 0x04, 0x0A, 0x83 }, "AlcatelLucen", "Alcatel-Lucent" },
    { { 0x04, 0x0A, 0xE0 }, "XmitComputer", "Xmit Ag Computer Networks" },
    { { 0x04, 0x0C, 0xCE }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x0D, 0x84 }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x04, 0x0E, 0x3C }, "HP",           "HP Inc." },
    { { 0x04, 0x0E, 0xC2 }, "ViewSonicMob", "ViewSonic Mobile China Limited" },
    { { 0x04, 0x10, 0x6B }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x04, 0x13, 0x7A }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x14, 0x71 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x15, 0x52 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x15, 0xD9 }, "Viwone",       "Viwone" },
    { { 0x04, 0x17, 0xB6 }, "SmartInnovat", "Smart Innovation LLC" },
    { { 0x04, 0x18, 0x0F }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0x18, 0x92 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x18, 0xB6 }, "Private",      "Private" },
    { { 0x04, 0x18, 0xD6 }, "Ubiquiti",     "Ubiquiti Inc" },
    { { 0x04, 0x19, 0x7F }, "GrasphereJap", "Grasphere Japan" },
    { { 0x04, 0x1A, 0x04 }, "WaveIP",       "WaveIP" },
    { { 0x04, 0x1B, 0x6D }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x04, 0x1B, 0x94 }, "HostMobility", "Host Mobility AB" },
    { { 0x04, 0x1B, 0xBA }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0x1D, 0x10 }, "DreamWare",    "Dream Ware Inc." },
    { { 0x04, 0x1D, 0xC7 }, "zte",          "zte corporation" },
    { { 0x04, 0x1E, 0x64 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x1E, 0x7A }, "DSPWorks",     "DSPWorks" },
    { { 0x04, 0x1E, 0xFA }, "BISSELLHomec", "BISSELL Homecare, Inc." },
    { { 0x04, 0x20, 0x84 }, "zte",          "zte corporation" },
    { { 0x04, 0x20, 0x9A }, "PanasonicAVC", "Panasonic Corporation AVC Networks Company" },
    { { 0x04, 0x21, 0x44 }, "SunitecEnter", "Sunitec Enterprise Co.,Ltd" },
    { { 0x04, 0x21, 0x4C }, "InsightEnerg", "Insight Energy Ventures LLC" },
    { { 0x04, 0x22, 0x34 }, "WirelessStan", "Wireless Standard Extensions" },
    { { 0x04, 0x23, 0x22 }, "TexasInstrum", "Texas Instruments" },
    { { 0x04, 0x25, 0xC5 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x25, 0xE0 }, "TaicangT&WEl", "Taicang T&W Electronics" },
    { { 0x04, 0x25, 0xE8 }, "TexasInstrum", "Texas Instruments" },
    { { 0x04, 0x25, 0xF0 }, "Nokia",        "Nokia" },
    { { 0x04, 0x26, 0x05 }, "BoschBuildin", "Bosch Building Automation GmbH" },
    { { 0x04, 0x26, 0x65 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x27, 0x28 }, "Microsoft",    "Microsoft Corporation" },
    { { 0x04, 0x27, 0x58 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x29, 0x2E }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0x2A, 0xE2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0x2B, 0x58 }, "HanzsungTech", "Shenzhen Hanzsung Technology Co.,Ltd" },
    { { 0x04, 0x2B, 0xBB }, "PicoCELA",     "PicoCELA, Inc." },
    { { 0x04, 0x2D, 0xAD }, "Areus",        "Areus GmbH" },
    { { 0x04, 0x2D, 0xB4 }, "FirstPropert", "First Property (Beijing) Co., Ltd Modern MOMA Branch" },
    { { 0x04, 0x2F, 0x56 }, "ATOCS",        "ATOCS (Shenzhen) LTD" },
    { { 0x04, 0x31, 0x10 }, "InspurGroup",  "Inspur Group Co., Ltd." },
    { { 0x04, 0x32, 0x01 }, "Broadcom",     "Broadcom Limited" },
    { { 0x04, 0x32, 0xF4 }, "Partron",      "Partron" },
    { { 0x04, 0x33, 0x1F }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0x33, 0x85 }, "NanchangBlac", "Nanchang BlackShark Co.,Ltd." },
    { { 0x04, 0x33, 0x89 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x33, 0xC2 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0x34, 0xF6 }, "MotorolaMobi", "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
    { { 0x04, 0x36, 0x04 }, "GyeyoungI&T",  "Gyeyoung I&T" },
    { { 0x04, 0x36, 0xB8 }, "I&CTechnolog", "I&C Technology" },
    { { 0x04, 0x38, 0x55 }, "ScopusIntern", "Scopus International Pvt. Ltd." },
    { { 0x04, 0x38, 0xDC }, "ChinaUnicomO", "China Unicom Online Information Technology Co.,Ltd" },
    { { 0x04, 0x39, 0x26 }, "ChinaDragonT", "China Dragon Technology Limited" },
    { { 0x04, 0x3A, 0x0D }, "SMOptics",     "SM Optics S.r.l." },
    { { 0x04, 0x3C, 0xE8 }, "SuperElectro", "Shenzhen SuperElectron Technology Co.,Ltd." },
    { { 0x04, 0x3D, 0x98 }, "ChongQingQin", "ChongQing QingJia Electronics CO.,LTD" },
    { { 0x04, 0x3F, 0x72 }, "MellanoxTech", "Mellanox Technologies, Inc." },
    { { 0x04, 0x40, 0xA9 }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x04, 0x41, 0x69 }, "GoPro",        "GoPro" },
    { { 0x04, 0x41, 0xA5 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x42, 0x1A }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x04, 0x43, 0xFD }, "SichuanTiany", "Sichuan Tianyi Comheart Telecom Co.,LTD" },
    { { 0x04, 0x44, 0xA1 }, "TeleconGalic", "Telecon Galicia,S.A." },
    { { 0x04, 0x45, 0x62 }, "ANDRASpzoo",   "ANDRA Sp. z o. o." },
    { { 0x04, 0x45, 0xA1 }, "NIRITXinweiT", "NIRIT- Xinwei Telecom Technology Co., Ltd." },
    { { 0x04, 0x46, 0x65 }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x04, 0x46, 0xCF }, "VenustechCyb", "Beijing Venustech Cybervision Co.,Ltd." },
    { { 0x04, 0x47, 0x07 }, "TexasInstrum", "Texas Instruments" },
    { { 0x04, 0x47, 0x2A }, "PaloAltoNetw", "Palo Alto Networks" },
    { { 0x04, 0x48, 0x9A }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x49, 0x5D }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0x4A, 0x50 }, "RamaxelTechn", "Ramaxel Technology (Shenzhen) limited company" },
    { { 0x04, 0x4A, 0x6A }, "niliwinanjin", "niliwi nanjing big data Co,.Ltd" },
    { { 0x04, 0x4A, 0x6C }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x4A, 0xC6 }, "AiponElectro", "Aipon Electronics Co., Ltd" },
    { { 0x04, 0x4B, 0xA5 }, "MercuryCommu", "Shenzhen Mercury Communication Technologies Co.,Ltd." },
    { { 0x04, 0x4B, 0xB1 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0x4B, 0xED }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x4B, 0xFF }, "GuangZhouHed", "GuangZhou Hedy Digital Technology Co., Ltd" },
    { { 0x04, 0x4C, 0xEF }, "FujianSanaoT", "Fujian Sanao Technology Co.,Ltd" },
    { { 0x04, 0x4E, 0x06 }, "Ericsson",     "Ericsson AB" },
    { { 0x04, 0x4E, 0x5A }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x04, 0x4E, 0xAF }, "LGInnotek",    "LG Innotek" },
    { { 0x04, 0x4F, 0x17 }, "HUMAX",        "HUMAX Co., Ltd." },
    { { 0x04, 0x4F, 0x4C }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x4F, 0x7A }, "ChinaMobileG", "China Mobile Group Device Co.,Ltd." },
    { { 0x04, 0x4F, 0x8B }, "Adapteva",     "Adapteva, Inc." },
    { { 0x04, 0x4F, 0xAA }, "RuckusWirele", "Ruckus Wireless" },
    { { 0x04, 0x50, 0xDA }, "QikuInternet", "Qiku Internet Network Scientific (Shenzhen) Co., Ltd" },
    { { 0x04, 0x51, 0x70 }, "ZhongshanKma", "Zhongshan K-mate General Electronics Co.,Ltd" },
    { { 0x04, 0x52, 0xC7 }, "Bose",         "Bose Corporation" },
    { { 0x04, 0x52, 0xF3 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x53, 0xD5 }, "SysorexGloba", "Sysorex Global Holdings" },
    { { 0x04, 0x54, 0x53 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x55, 0xCA }, "BriView",      "BriView (Xiamen) Corp." },
    { { 0x04, 0x56, 0x04 }, "GioneeCommun", "Gionee Communication Equipment Co.,Ltd." },
    { { 0x04, 0x56, 0x65 }, "NokiaShangha", "Nokia Shanghai Bell Co., Ltd." },
    { { 0x04, 0x56, 0xE5 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0x57, 0x2F }, "SertelElectr", "Sertel Electronics UK Ltd" },
    { { 0x04, 0x57, 0x47 }, "GoPro",        "GoPro" },
    { { 0x04, 0x57, 0x91 }, "ShenzhenshiX", "Shenzhenshi Xinzhongxin Technology Co.Ltd" },
    { { 0x04, 0x58, 0x6F }, "SichuanWhaye", "Sichuan Whayer information industry Co.,LTD" },
    { { 0x04, 0x5A, 0x95 }, "Nokia",        "Nokia Corporation" },
    { { 0x04, 0x5C, 0x06 }, "ZmodoTechnol", "Zmodo Technology Corporation" },
    { { 0x04, 0x5C, 0x6C }, "JuniperNetwo", "Juniper Networks" },
    { { 0x04, 0x5C, 0x8E }, "gosundGROUP",  "gosund GROUP CO.,LTD" },
    { { 0x04, 0x5D, 0x4B }, "Sony",         "Sony Corporation" },
    { { 0x04, 0x5D, 0x56 }, "camtronindus", "camtron industrial inc." },
    { { 0x04, 0x5E, 0xA4 }, "NetisTechnol", "Netis Technology Co., Ltd." },
    { { 0x04, 0x5F, 0xA7 }, "YichenTechno", "Shenzhen Yichen Technology Development Co.,LTD" },
    { { 0x04, 0x5F, 0xB9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0x61, 0x69 }, "MediaGlobalL", "Media Global Links Co., Ltd." },
    { { 0x04, 0x62, 0x73 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0x62, 0xD7 }, "AlstomHydroF", "Alstom Hydro France" },
    { { 0x04, 0x63, 0xD0 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0x63, 0xE0 }, "Nome",         "Nome Oy" },
    { { 0x04, 0x65, 0x65 }, "Testop",       "Testop" },
    { { 0x04, 0x67, 0x85 }, "scemtecHardu", "scemtec Hard- und Software fuer Mess- und Steuerungstechnik GmbH" },
    { { 0x04, 0x68, 0x65 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x68, 0x74 }, "CloudNetwork", "Cloud Network Technology Singapore Pte. Ltd." },
    { { 0x04, 0x69, 0x8F }, "JuniperNetwo", "Juniper Networks" },
    { { 0x04, 0x69, 0xF8 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x6B, 0x1B }, "SYSDINE",      "SYSDINE Co., Ltd." },
    { { 0x04, 0x6B, 0x25 }, "SichuanTiany", "Sichuan Tianyi Comheart Telecom Co.,LTD" },
    { { 0x04, 0x6C, 0x59 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0x6C, 0x9D }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0x6D, 0x42 }, "Bryston",      "Bryston Ltd." },
    { { 0x04, 0x6E, 0x02 }, "OpenRTLSGrou", "OpenRTLS Group" },
    { { 0x04, 0x6E, 0x49 }, "TaiYearElect", "TaiYear Electronic Technology (Suzhou) Co., Ltd" },
    { { 0x04, 0x6E, 0xCB }, "zte",          "zte corporation" },
    { { 0x04, 0x70, 0x56 }, "Arcadyan",     "Arcadyan Corporation" },
    { { 0x04, 0x70, 0xBC }, "Globalstar",   "Globalstar Inc." },
    { { 0x04, 0x71, 0x53 }, "SernetTechno", "Sernet (Suzhou) Technologies Corporation" },
    { { 0x04, 0x72, 0x95 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x74, 0xA1 }, "AligeraEquip", "Aligera Equipamentos Digitais Ltda" },
    { { 0x04, 0x75, 0x03 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x75, 0xF5 }, "Csst",         "Csst" },
    { { 0x04, 0x75, 0xF9 }, "TaicangT&WEl", "Taicang T&W Electronics" },
    { { 0x04, 0x76, 0x6E }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x04, 0x76, 0xB0 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0x78, 0x63 }, "MXCHIPInform", "Shanghai MXCHIP Information Technology Co., Ltd." },
    { { 0x04, 0x79, 0x70 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x79, 0x75 }, "HonorDevice",  "Honor Device Co., Ltd." },
    { { 0x04, 0x79, 0xB7 }, "TexasInstrum", "Texas Instruments" },
    { { 0x04, 0x79, 0xFD }, "Ciena",        "Ciena Corporation" },
    { { 0x04, 0x7A, 0x0B }, "XiaomiElectr", "Beijing Xiaomi Electronics Co., Ltd." },
    { { 0x04, 0x7A, 0xAE }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0x7B, 0xCB }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x04, 0x7C, 0x16 }, "MicroStarINT", "Micro-Star INTL CO., LTD." },
    { { 0x04, 0x7D, 0x50 }, "KangYingTech", "Shenzhen Kang Ying Technology Co.Ltd." },
    { { 0x04, 0x7D, 0x7B }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x04, 0x7E, 0x23 }, "ChinaMobileI", "China Mobile IOT Company Limited" },
    { { 0x04, 0x7E, 0x4A }, "moobox",       "moobox CO., Ltd." },
    { { 0x04, 0x7F, 0x0E }, "BarrotTechno", "Barrot Technology Co.,LTD" },
    { { 0x04, 0x80, 0xA7 }, "TianGangMicr", "ShenZhen TianGang Micro Technology CO.LTD" },
    { { 0x04, 0x81, 0x9B }, "SkyUk",        "Sky Uk Limited" },
    { { 0x04, 0x81, 0xAE }, "Clack",        "Clack Corporation" },
    { { 0x04, 0x84, 0x8A }, "7InovaTechno", "7Inova Technology Limited" },
    { { 0x04, 0x86, 0x80 }, "QuectelWirel", "Quectel Wireless Solutions Co.,Ltd." },
    { { 0x04, 0x87, 0x27 }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x04, 0x88, 0x5F }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x88, 0x8C }, "EifelwerkBut", "Eifelwerk Butler Systeme GmbH" },
    { { 0x04, 0x88, 0xE2 }, "BeatsElectro", "Beats Electronics LLC" },
    { { 0x04, 0x8A, 0x15 }, "Avaya",        "Avaya Inc" },
    { { 0x04, 0x8A, 0xE1 }, "FlextronicsM", "Flextronics Manufacturing(Zhuhai)Co.,Ltd." },
    { { 0x04, 0x8B, 0x42 }, "SkspruceTech", "Skspruce Technologies" },
    { { 0x04, 0x8C, 0x03 }, "ThinPADTechn", "ThinPAD Technology (Shenzhen)CO.,LTD" },
    { { 0x04, 0x8C, 0x16 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0x8C, 0x9A }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0x8D, 0x38 }, "NetisTechnol", "Netis Technology Co., Ltd." },
    { { 0x04, 0x90, 0x81 }, "Pensando",     "Pensando Systems, Inc." },
    { { 0x04, 0x91, 0x62 }, "MicrochipTec", "Microchip Technology Inc." },
    { { 0x04, 0x92, 0x26 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x04, 0x92, 0xEE }, "iway",         "iway AG" },
    { { 0x04, 0x94, 0x6B }, "TecnoMobile",  "Tecno Mobile Limited" },
    { { 0x04, 0x94, 0xA1 }, "CatchWind",    "Catch The Wind Inc" },
    { { 0x04, 0x94, 0xE9 }, "FAXedgeTechn", "FAXedge Technologies, LLC" },
    { { 0x04, 0x95, 0x73 }, "zte",          "zte corporation" },
    { { 0x04, 0x95, 0xE6 }, "TendaTechnol", "Tenda Technology Co.,Ltd.Dongguan branch" },
    { { 0x04, 0x96, 0x45 }, "WuxiSkyChipI", "Wuxi Sky Chip Interconnection Technology Co.,Ltd." },
    { { 0x04, 0x97, 0x90 }, "Lartechtelec", "Lartech telecom LLC" },
    { { 0x04, 0x98, 0xF3 }, "Alpsalpine",   "Alpsalpine Co,.Ltd" },
    { { 0x04, 0x99, 0xB9 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x99, 0xBB }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x99, 0xE6 }, "YoostarTechn", "Shenzhen Yoostar Technology Co., Ltd" },
    { { 0x04, 0x9B, 0x9C }, "EadingcoreIn", "Eadingcore Intelligent Technology Co., Ltd." },
    { { 0x04, 0x9C, 0x62 }, "BMTMedicalTe", "BMT Medical Technology s.r.o." },
    { { 0x04, 0x9D, 0x05 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0x9D, 0xFE }, "Hivesystem",   "Hivesystem" },
    { { 0x04, 0x9F, 0x06 }, "Smobile",      "Smobile Co., Ltd." },
    { { 0x04, 0x9F, 0x15 }, "Humane",       "Humane" },
    { { 0x04, 0x9F, 0x81 }, "Netscout",     "Netscout Systems Inc" },
    { { 0x04, 0x9F, 0xCA }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xA1, 0x51 }, "Netgear",      "Netgear" },
    { { 0x04, 0xA2, 0x22 }, "Arcadyan",     "Arcadyan Corporation" },
    { { 0x04, 0xA2, 0xF3 }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x04, 0xA3, 0x16 }, "TexasInstrum", "Texas Instruments" },
    { { 0x04, 0xA3, 0xF3 }, "Emicon",       "Emicon" },
    { { 0x04, 0xA5, 0x26 }, "Nokia",        "Nokia" },
    { { 0x04, 0xA7, 0x41 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0xA8, 0x1C }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xA8, 0x2A }, "Nokia",        "Nokia Corporation" },
    { { 0x04, 0xA9, 0x59 }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x04, 0xAA, 0xE1 }, "MicrovisionT", "Beijing Microvision Technology Co.,Ltd" },
    { { 0x04, 0xAB, 0x08 }, "SkyworthDigi", "Shenzhen Skyworth Digital Technology CO., Ltd" },
    { { 0x04, 0xAB, 0x18 }, "Elecom",       "Elecom Co.,Ltd." },
    { { 0x04, 0xAB, 0x6A }, "Chunil",       "Chun-il Co.,Ltd." },
    { { 0x04, 0xAC, 0x44 }, "HoltekSemico", "Holtek Semiconductor Inc." },
    { { 0x04, 0xAE, 0xC7 }, "Marquardt",    "Marquardt" },
    { { 0x04, 0xB0, 0xE7 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xB1, 0x67 }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x04, 0xB1, 0xA1 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0xB3, 0xB6 }, "Seamap",       "Seamap (UK) Ltd" },
    { { 0x04, 0xB4, 0x29 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0xB4, 0x66 }, "BSP",          "BSP Co., Ltd." },
    { { 0x04, 0xB4, 0xFE }, "AVMAudiovisu", "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
    { { 0x04, 0xB6, 0x48 }, "Zenner",       "Zenner" },
    { { 0x04, 0xB6, 0xBE }, "CigShanghai",  "Cig Shanghai Co Ltd" },
    { { 0x04, 0xB8, 0x6A }, "SkyUk",        "Sky Uk Limited" },
    { { 0x04, 0xB9, 0x7D }, "AiVISItd",     "AiVIS Co., Itd." },
    { { 0x04, 0xB9, 0xE3 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0xBA, 0x1C }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0xBA, 0x36 }, "LiSengTechno", "Li Seng Technology Ltd" },
    { { 0x04, 0xBA, 0x8D }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0xBA, 0xD6 }, "DLink",        "D-Link Corporation" },
    { { 0x04, 0xBB, 0xF9 }, "PavilionData", "Pavilion Data Systems Inc" },
    { { 0x04, 0xBC, 0x6D }, "Apple",        "Apple, Inc." },
    { { 0x04, 0xBC, 0x87 }, "JustLinkTech", "Shenzhen JustLink Technology Co., LTD" },
    { { 0x04, 0xBC, 0x9F }, "Calix",        "Calix Inc." },
    { { 0x04, 0xBD, 0x70 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xBD, 0x88 }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x04, 0xBD, 0x97 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0xBD, 0xBF }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0xBF, 0x1B }, "Dell",         "Dell Inc." },
    { { 0x04, 0xBF, 0x6D }, "ZyxelCommuni", "Zyxel Communications Corporation" },
    { { 0x04, 0xBF, 0xA8 }, "ISB",          "ISB Corporation" },
    { { 0x04, 0xC0, 0x5B }, "TigoEnergy",   "Tigo Energy" },
    { { 0x04, 0xC0, 0x6F }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xC0, 0x9C }, "Tellabs",      "Tellabs Inc." },
    { { 0x04, 0xC1, 0x03 }, "CloverNetwor", "Clover Network, Inc." },
    { { 0x04, 0xC1, 0xB9 }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x04, 0xC1, 0xD8 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0xC2, 0x3E }, "HTC",          "HTC Corporation" },
    { { 0x04, 0xC2, 0x41 }, "Nokia",        "Nokia" },
    { { 0x04, 0xC2, 0x9B }, "AuraHome",     "Aura Home, Inc." },
    { { 0x04, 0xC4, 0x61 }, "MurataManufa", "Murata Manufacturing Co., Ltd." },
    { { 0x04, 0xC5, 0xA4 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0xC8, 0x07 }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x04, 0xC8, 0x80 }, "Samtec",       "Samtec Inc" },
    { { 0x04, 0xC9, 0x91 }, "Phistek",      "Phistek INC." },
    { { 0x04, 0xC9, 0xD9 }, "DishTechnolo", "Dish Technologies Corp" },
    { { 0x04, 0xCA, 0xED }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xCB, 0x1D }, "Traka",        "Traka plc" },
    { { 0x04, 0xCB, 0x88 }, "JingxunSoftw", "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd" },
    { { 0x04, 0xCC, 0xBC }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xCD, 0x15 }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x04, 0xCE, 0x09 }, "SkyworthDigi", "Shenzhen Skyworth Digital Technology CO., Ltd" },
    { { 0x04, 0xCE, 0x14 }, "Wilocity",     "Wilocity LTD." },
    { { 0x04, 0xCE, 0x7E }, "NXPFranceSem", "NXP France Semiconductors France" },
    { { 0x04, 0xCF, 0x25 }, "Manycolors",   "Manycolors, Inc." },
    { { 0x04, 0xCF, 0x4B }, "Intel",        "Intel Corporate" },
    { { 0x04, 0xCF, 0x8C }, "XIAOMIElectr", "XIAOMI Electronics,CO.,LTD" },
    { { 0x04, 0xD1, 0x3A }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x04, 0xD1, 0x68 }, "SunplusTechn", "Sunplus Technology Co., Ltd." },
    { { 0x04, 0xD3, 0x20 }, "ItelMobile",   "Itel Mobile Limited" },
    { { 0x04, 0xD3, 0x95 }, "MotorolaMobi", "Motorola Mobility LLC, a Lenovo Company" },
    { { 0x04, 0xD3, 0xB0 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0xD3, 0xB5 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0xD3, 0xCF }, "Apple",        "Apple, Inc." },
    { { 0x04, 0xD4, 0x37 }, "Znv",          "Znv" },
    { { 0x04, 0xD4, 0x42 }, "GeniusTechno", "Guangdong Genius Technology Co., Ltd." },
    { { 0x04, 0xD4, 0xC4 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x04, 0xD5, 0x90 }, "Fortinet",     "Fortinet, Inc." },
    { { 0x04, 0xD6, 0x0E }, "FunaiElectri", "Funai Electric Co., Ltd." },
    { { 0x04, 0xD6, 0xAA }, "SamsungElect", "Samsung Electro-Mechanics(Thailand)" },
    { { 0x04, 0xD6, 0xF4 }, "GDMideaAirCo", "GD Midea Air-Conditioning Equipment Co.,Ltd." },
    { { 0x04, 0xD7, 0x83 }, "Y&HE&C",       "Y&H E&C Co.,LTD." },
    { { 0x04, 0xD7, 0xA5 }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x04, 0xD9, 0x21 }, "Occuspace",    "Occuspace" },
    { { 0x04, 0xD9, 0xC8 }, "HonHaiPrecis", "Hon Hai Precision Industry Co., Ltd." },
    { { 0x04, 0xD9, 0xF5 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x04, 0xDA, 0x28 }, "ChongqingZho", "Chongqing Zhouhai Intelligent Technology Co., Ltd" },
    { { 0x04, 0xDA, 0xD2 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0xDB, 0x56 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0xDB, 0x8A }, "SuntechInter", "Suntech International Ltd." },
    { { 0x04, 0xDD, 0x4C }, "Velocytech",   "Velocytech" },
    { { 0x04, 0xDE, 0xDB }, "RockportNetw", "Rockport Networks Inc" },
    { { 0x04, 0xDE, 0xF2 }, "ECOMTechnolo", "Shenzhen ECOM Technology Co. Ltd" },
    { { 0x04, 0xDF, 0x69 }, "CarConnectiv", "Car Connectivity Consortium" },
    { { 0x04, 0xE0, 0xB0 }, "YOUHUATechno", "Shenzhen YOUHUA Technology Co., Ltd" },
    { { 0x04, 0xE0, 0xC4 }, "TriumphAdler", "Triumph-Adler Ag" },
    { { 0x04, 0xE1, 0xC8 }, "IMSSoluçõese", "IMS Soluções em Energia Ltda." },
    { { 0x04, 0xE2, 0x29 }, "QingdaoHaier", "Qingdao Haier Technology Co.,Ltd" },
    { { 0x04, 0xE2, 0xF8 }, "AEPTicketing", "AEP Ticketing solutions srl" },
    { { 0x04, 0xE3, 0x1A }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x04, 0xE3, 0x87 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0xE4, 0x51 }, "TexasInstrum", "Texas Instruments" },
    { { 0x04, 0xE4, 0xB6 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0xE5, 0x36 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0xE5, 0x48 }, "CohdaWireles", "Cohda Wireless Pty Ltd" },
    { { 0x04, 0xE5, 0x6E }, "THUB",         "THUB Co., ltd." },
    { { 0x04, 0xE5, 0x98 }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x04, 0xE6, 0x62 }, "Acroname",     "Acroname Inc." },
    { { 0x04, 0xE6, 0x76 }, "AMPAKTechnol", "AMPAK Technology, Inc." },
    { { 0x04, 0xE6, 0x9E }, "Zhongguancun", "Zhongguancun Xinhaizeyou Technology Co.,Ltd" },
    { { 0x04, 0xE7, 0x7E }, "We",           "We Corporation Inc." },
    { { 0x04, 0xE7, 0x95 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xE8, 0x92 }, "ShennanCircu", "Shennan Circuits Co.,Ltd" },
    { { 0x04, 0xE8, 0xB9 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0xE9, 0xE5 }, "PjrcCom",      "Pjrc.Com, Llc" },
    { { 0x04, 0xEA, 0x56 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0xEB, 0x40 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0xEC, 0xBB }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x04, 0xEC, 0xD8 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0xED, 0x33 }, "Intel",        "Intel Corporate" },
    { { 0x04, 0xEE, 0x03 }, "TexasInstrum", "Texas Instruments" },
    { { 0x04, 0xEE, 0x91 }, "xfabric",      "x-fabric GmbH" },
    { { 0x04, 0xEE, 0xEE }, "LaplaceSyste", "Laplace System Co., Ltd." },
    { { 0x04, 0xF0, 0x21 }, "CompexPte",    "Compex Systems Pte Ltd" },
    { { 0x04, 0xF0, 0x3E }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0xF0, 0xE4 }, "HosecomElect", "ShenZhen Hosecom Electronic Technology Co.,LTD" },
    { { 0x04, 0xF1, 0x28 }, "HMDGlobal",    "HMD Global Oy" },
    { { 0x04, 0xF1, 0x3E }, "Apple",        "Apple, Inc." },
    { { 0x04, 0xF1, 0x69 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0xF1, 0x7D }, "TaranaWirele", "Tarana Wireless" },
    { { 0x04, 0xF3, 0x52 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xF4, 0xBC }, "XenaNetworks", "Xena Networks" },
    { { 0x04, 0xF4, 0xD8 }, "HuiZhouGaosh", "Hui Zhou Gaoshengda Technology Co.,LTD" },
    { { 0x04, 0xF5, 0xF4 }, "ProximWirele", "Proxim Wireless" },
    { { 0x04, 0xF7, 0x78 }, "SonyInteract", "Sony Interactive Entertainment Inc." },
    { { 0x04, 0xF7, 0xE4 }, "Apple",        "Apple, Inc." },
    { { 0x04, 0xF8, 0xC2 }, "FlaircommMic", "Flaircomm Microelectronics, Inc." },
    { { 0x04, 0xF8, 0xF8 }, "EdgecoreNetw", "Edgecore Networks Corporation" },
    { { 0x04, 0xF9, 0x38 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xF9, 0x93 }, "Infinixmobil", "Infinix mobility limited" },
    { { 0x04, 0xF9, 0xD9 }, "SpeakerElect", "Speaker Electronic(Jiashan) Co.,Ltd" },
    { { 0x04, 0xF9, 0xF8 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x04, 0xFA, 0x3F }, "OptiCore",     "OptiCore Inc." },
    { { 0x04, 0xFA, 0x83 }, "QingdaoHaier", "Qingdao Haier Technology Co.,Ltd" },
    { { 0x04, 0xFE, 0x31 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x04, 0xFE, 0x7F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x04, 0xFE, 0x8D }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x04, 0xFE, 0xA1 }, "Fihonestcomm", "Fihonest communication co.,Ltd" },
    { { 0x04, 0xFF, 0x08 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x04, 0xFF, 0x51 }, "NovamediaInn", "Novamedia Innovision Sp. Z O.O." },
    { { 0x08, 0x00, 0x01 }, "Computervisi", "Computervision Corporation" },
    { { 0x08, 0x00, 0x02 }, "BridgeCommun", "Bridge Communications Inc." },
    { { 0x08, 0x00, 0x03 }, "AdvancedComp", "Advanced Computer Comm." },
    { { 0x08, 0x00, 0x04 }, "Cromemco",     "Cromemco Incorporated" },
    { { 0x08, 0x00, 0x05 }, "Symbolics",    "Symbolics Inc." },
    { { 0x08, 0x00, 0x06 }, "Siemens",      "Siemens Ag" },
    { { 0x08, 0x00, 0x07 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x00, 0x08 }, "BoltBeranekA", "Bolt Beranek And Newman Inc." },
    { { 0x08, 0x00, 0x09 }, "HewlettPacka", "Hewlett Packard" },
    { { 0x08, 0x00, 0x0A }, "Nestar",       "Nestar Systems Incorporated" },
    { { 0x08, 0x00, 0x0B }, "Unisys",       "Unisys Corporation" },
    { { 0x08, 0x00, 0x0C }, "MiklynDevelo", "Miklyn Development Co." },
    { { 0x08, 0x00, 0x0D }, "Internationa", "International Computers, Ltd" },
    { { 0x08, 0x00, 0x0E }, "Ncr",          "Ncr Corporation" },
    { { 0x08, 0x00, 0x0F }, "Mitel",        "Mitel Corporation" },
    { { 0x08, 0x00, 0x11 }, "Tektronix",    "Tektronix Inc." },
    { { 0x08, 0x00, 0x12 }, "BellAtlantic", "Bell Atlantic Integrated Syst." },
    { { 0x08, 0x00, 0x13 }, "Exxon",        "Exxon" },
    { { 0x08, 0x00, 0x14 }, "Excelan",      "Excelan" },
    { { 0x08, 0x00, 0x15 }, "StcBusiness",  "Stc Business Systems" },
    { { 0x08, 0x00, 0x16 }, "BarristerInf", "Barrister Info Sys Corp" },
    { { 0x08, 0x00, 0x17 }, "NationalSemi", "National Semiconductor" },
    { { 0x08, 0x00, 0x18 }, "PirelliFocom", "Pirelli Focom Networks" },
    { { 0x08, 0x00, 0x19 }, "GeneralElect", "General Electric Corporation" },
    { { 0x08, 0x00, 0x1A }, "Tiara10Net",   "Tiara/ 10Net" },
    { { 0x08, 0x00, 0x1B }, "DellEMC",      "Dell EMC" },
    { { 0x08, 0x00, 0x1C }, "KddKokusaiDe", "Kdd-Kokusai Debnsin Denwa Co." },
    { { 0x08, 0x00, 0x1D }, "AbleCommunic", "Able Communications Inc." },
    { { 0x08, 0x00, 0x1E }, "ApolloComput", "Apollo Computer Inc." },
    { { 0x08, 0x00, 0x1F }, "Sharp",        "Sharp Corporation" },
    { { 0x08, 0x00, 0x20 }, "Oracle",       "Oracle Corporation" },
    { { 0x08, 0x00, 0x21 }, "3M",           "3M Company" },
    { { 0x08, 0x00, 0x22 }, "Nbi",          "Nbi Inc." },
    { { 0x08, 0x00, 0x23 }, "PanasonicCom", "Panasonic Communications Co., Ltd." },
    { { 0x08, 0x00, 0x24 }, "10NetCommuni", "10Net Communications/Dca" },
    { { 0x08, 0x00, 0x25 }, "ControlData",  "Control Data" },
    { { 0x08, 0x00, 0x26 }, "NorskData",    "Norsk Data A.S." },
    { { 0x08, 0x00, 0x27 }, "PCSSystemtec", "PCS Systemtechnik GmbH" },
    { { 0x08, 0x00, 0x28 }, "TexasInstrum", "Texas Instruments" },
    { { 0x08, 0x00, 0x29 }, "Megatek",      "Megatek Corporation" },
    { { 0x08, 0x00, 0x2A }, "MosaicTechno", "Mosaic Technologies Inc." },
    { { 0x08, 0x00, 0x2B }, "DigitalEquip", "Digital Equipment Corporation" },
    { { 0x08, 0x00, 0x2C }, "BrittonLee",   "Britton Lee Inc." },
    { { 0x08, 0x00, 0x2D }, "LanTec",       "Lan-Tec Inc." },
    { { 0x08, 0x00, 0x2E }, "MetaphorComp", "Metaphor Computer Systems" },
    { { 0x08, 0x00, 0x2F }, "PrimeCompute", "Prime Computer Inc." },
    { { 0x08, 0x00, 0x30 }, "NetworkResea", "Network Research Corporation" },
    { { 0x08, 0x00, 0x31 }, "LittleMachin", "Little Machines Inc." },
    { { 0x08, 0x00, 0x32 }, "Tigan",        "Tigan Incorporated" },
    { { 0x08, 0x00, 0x33 }, "BauschLomb",   "Bausch & Lomb" },
    { { 0x08, 0x00, 0x34 }, "Filenet",      "Filenet Corporation" },
    { { 0x08, 0x00, 0x35 }, "Microfive",    "Microfive Corporation" },
    { { 0x08, 0x00, 0x36 }, "Intergraph",   "Intergraph Corporation" },
    { { 0x08, 0x00, 0x37 }, "FUJIFILMBusi", "FUJIFILM Business Innovation Corp." },
    { { 0x08, 0x00, 0x38 }, "BullS",        "Bull S.A.S." },
    { { 0x08, 0x00, 0x39 }, "Spider",       "Spider Systems Limited" },
    { { 0x08, 0x00, 0x3A }, "Orcatech",     "Orcatech Inc." },
    { { 0x08, 0x00, 0x3B }, "Torus",        "Torus Systems Limited" },
    { { 0x08, 0x00, 0x3C }, "Schlumberger", "Schlumberger Well Services" },
    { { 0x08, 0x00, 0x3D }, "CadnetixCorp", "Cadnetix Corporations" },
    { { 0x08, 0x00, 0x3E }, "Codex",        "Codex Corporation" },
    { { 0x08, 0x00, 0x3F }, "FredKoschara", "Fred Koschara Enterprises" },
    { { 0x08, 0x00, 0x40 }, "FerrantiComp", "Ferranti Computer Sys. Limited" },
    { { 0x08, 0x00, 0x41 }, "RacalMilgoIn", "Racal-Milgo Information Sys.." },
    { { 0x08, 0x00, 0x42 }, "MACNICA",      "MACNICA, Inc." },
    { { 0x08, 0x00, 0x43 }, "PixelCompute", "Pixel Computer Inc." },
    { { 0x08, 0x00, 0x44 }, "David",        "David Systems Inc." },
    { { 0x08, 0x00, 0x45 }, "ConcurrentCo", "Concurrent Computer Corp." },
    { { 0x08, 0x00, 0x46 }, "Sony",         "Sony Corporation" },
    { { 0x08, 0x00, 0x47 }, "SequentCompu", "Sequent Computer Systems Inc." },
    { { 0x08, 0x00, 0x48 }, "EurothermGau", "Eurotherm Gauging Systems" },
    { { 0x08, 0x00, 0x49 }, "Univation",    "Univation" },
    { { 0x08, 0x00, 0x4A }, "Banyan",       "Banyan Systems Inc." },
    { { 0x08, 0x00, 0x4B }, "PlanningRese", "Planning Research Corp." },
    { { 0x08, 0x00, 0x4C }, "HydraCompute", "Hydra Computer Systems Inc." },
    { { 0x08, 0x00, 0x4D }, "Corvus",       "Corvus Systems Inc." },
    { { 0x08, 0x00, 0x4E }, "3ComEurope",   "3Com Europe Ltd" },
    { { 0x08, 0x00, 0x4F }, "Cygnet",       "Cygnet Systems" },
    { { 0x08, 0x00, 0x50 }, "Daisy",        "Daisy Systems Corp." },
    { { 0x08, 0x00, 0x51 }, "ExperData",    "ExperData" },
    { { 0x08, 0x00, 0x52 }, "Insystec",     "Insystec" },
    { { 0x08, 0x00, 0x53 }, "MiddleEastTe", "Middle East Tech. University" },
    { { 0x08, 0x00, 0x55 }, "StanfordTele", "Stanford Telecomm. Inc." },
    { { 0x08, 0x00, 0x56 }, "StanfordLine", "Stanford Linear Accel. Center" },
    { { 0x08, 0x00, 0x57 }, "EvansSutherl", "Evans & Sutherland" },
    { { 0x08, 0x00, 0x58 }, "SystemsConce", "Systems Concepts" },
    { { 0x08, 0x00, 0x59 }, "ASMycron",     "A/S Mycron" },
    { { 0x08, 0x00, 0x5A }, "IBM",          "IBM Corp" },
    { { 0x08, 0x00, 0x5B }, "VtaTechnolog", "Vta Technologies Inc." },
    { { 0x08, 0x00, 0x5C }, "FourPhase",    "Four Phase Systems" },
    { { 0x08, 0x00, 0x5D }, "Gould",        "Gould Inc." },
    { { 0x08, 0x00, 0x5E }, "Counterpoint", "Counterpoint Computer Inc." },
    { { 0x08, 0x00, 0x5F }, "SaberTechnol", "Saber Technology Corp." },
    { { 0x08, 0x00, 0x60 }, "IndustrialNe", "Industrial Networking Inc." },
    { { 0x08, 0x00, 0x61 }, "Jarogate",     "Jarogate Ltd." },
    { { 0x08, 0x00, 0x62 }, "GeneralDynam", "General Dynamics" },
    { { 0x08, 0x00, 0x63 }, "Plessey",      "Plessey" },
    { { 0x08, 0x00, 0x64 }, "Sitasys",      "Sitasys AG" },
    { { 0x08, 0x00, 0x65 }, "Genrad",       "Genrad Inc." },
    { { 0x08, 0x00, 0x66 }, "Agfa",         "Agfa Corporation" },
    { { 0x08, 0x00, 0x67 }, "ComDesign",    "ComDesign" },
    { { 0x08, 0x00, 0x68 }, "RidgeCompute", "Ridge Computers" },
    { { 0x08, 0x00, 0x69 }, "SiliconGraph", "Silicon Graphics" },
    { { 0x08, 0x00, 0x6A }, "At&T",         "At&T" },
    { { 0x08, 0x00, 0x6B }, "AccelTechnol", "Accel Technologies Inc." },
    { { 0x08, 0x00, 0x6C }, "SuntekTechno", "Suntek Technology Int'L" },
    { { 0x08, 0x00, 0x6D }, "WhitechapelC", "Whitechapel Computer Works" },
    { { 0x08, 0x00, 0x6E }, "Masscomp",     "Masscomp" },
    { { 0x08, 0x00, 0x6F }, "PhilipsApeld", "Philips Apeldoorn B.V." },
    { { 0x08, 0x00, 0x70 }, "MitsubishiPr", "Mitsubishi Precision Co.,LTd." },
    { { 0x08, 0x00, 0x71 }, "Matra",        "Matra (Dsie)" },
    { { 0x08, 0x00, 0x72 }, "XeroxUnivGra", "Xerox Corp Univ Grant Program" },
    { { 0x08, 0x00, 0x73 }, "Tecmar",       "Tecmar Inc." },
    { { 0x08, 0x00, 0x74 }, "CasioCompute", "Casio Computer Co. Ltd." },
    { { 0x08, 0x00, 0x75 }, "DanskDataEle", "Dansk Data Electronik" },
    { { 0x08, 0x00, 0x76 }, "PcLanTechnol", "Pc Lan Technologies" },
    { { 0x08, 0x00, 0x77 }, "TslCommunica", "Tsl Communications Ltd." },
    { { 0x08, 0x00, 0x78 }, "Accell",       "Accell Corporation" },
    { { 0x08, 0x00, 0x79 }, "DroidWorks",   "The Droid Works" },
    { { 0x08, 0x00, 0x7A }, "Indata",       "Indata" },
    { { 0x08, 0x00, 0x7B }, "SanyoElectri", "Sanyo Electric Co. Ltd." },
    { { 0x08, 0x00, 0x7C }, "VitalinkComm", "Vitalink Communications Corp." },
    { { 0x08, 0x00, 0x7E }, "AmalgamatedW", "Amalgamated Wireless(Aus) Ltd" },
    { { 0x08, 0x00, 0x7F }, "CarnegieMell", "Carnegie-Mellon University" },
    { { 0x08, 0x00, 0x80 }, "AesData",      "Aes Data Inc." },
    { { 0x08, 0x00, 0x81 }, "Astech",       "Astech Inc." },
    { { 0x08, 0x00, 0x82 }, "VeritasSoftw", "Veritas Software" },
    { { 0x08, 0x00, 0x83 }, "SeikoInstrum", "Seiko Instruments Inc." },
    { { 0x08, 0x00, 0x84 }, "TomenElectro", "Tomen Electronics Corp." },
    { { 0x08, 0x00, 0x85 }, "Elxsi",        "Elxsi" },
    { { 0x08, 0x00, 0x86 }, "KonicaMinolt", "Konica Minolta Holdings, Inc." },
    { { 0x08, 0x00, 0x87 }, "Xyplex",       "Xyplex, Inc." },
    { { 0x08, 0x00, 0x88 }, "BrocadeCommu", "Brocade Communications Systems LLC" },
    { { 0x08, 0x00, 0x89 }, "Kinetics",     "Kinetics" },
    { { 0x08, 0x00, 0x8A }, "PerfTech",     "PerfTech, Inc." },
    { { 0x08, 0x00, 0x8B }, "PyramidTechn", "Pyramid Technology Corp." },
    { { 0x08, 0x00, 0x8C }, "NetworkResea", "Network Research Corporation" },
    { { 0x08, 0x00, 0x8D }, "Xyvision",     "Xyvision Inc." },
    { { 0x08, 0x00, 0x8E }, "TandemComput", "Tandem Computers" },
    { { 0x08, 0x00, 0x8F }, "Chipcom",      "Chipcom Corporation" },
    { { 0x08, 0x00, 0x90 }, "Sonoma",       "Sonoma Systems" },
    { { 0x08, 0x01, 0x0F }, "SichuanTiany", "Sichuan Tianyi Comheart Telecom Co.,LTD" },
    { { 0x08, 0x02, 0x05 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x02, 0x3C }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0x02, 0x8E }, "Netgear",      "Netgear" },
    { { 0x08, 0x03, 0x42 }, "PaloAltoNetw", "Palo Alto Networks" },
    { { 0x08, 0x03, 0x71 }, "Krg",          "Krg Corporate" },
    { { 0x08, 0x04, 0xB4 }, "TexasInstrum", "Texas Instruments" },
    { { 0x08, 0x05, 0x81 }, "Roku",         "Roku, Inc." },
    { { 0x08, 0x05, 0xCD }, "DongGuangEnM", "DongGuang EnMai Electronic Product Co.Ltd." },
    { { 0x08, 0x05, 0xE2 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x08, 0x08, 0x5C }, "LunaProducts", "Luna Products" },
    { { 0x08, 0x08, 0xC2 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0x08, 0xEA }, "Amsc",         "Amsc" },
    { { 0x08, 0x09, 0xB6 }, "Masimo",       "Masimo Corp" },
    { { 0x08, 0x09, 0xC7 }, "ZhuhaiUnitec", "Zhuhai Unitech Power Technology Co., Ltd." },
    { { 0x08, 0x0A, 0x4E }, "PlanetBingo®", "Planet Bingo® — 3rd Rock Gaming®" },
    { { 0x08, 0x0C, 0x0B }, "SysMikDresde", "SysMik GmbH Dresden" },
    { { 0x08, 0x0C, 0xC9 }, "MissionTechn", "Mission Technology Group, dba Magma" },
    { { 0x08, 0x0D, 0x84 }, "GECO",         "GECO, Inc." },
    { { 0x08, 0x0E, 0xA8 }, "Velex",        "Velex s.r.l." },
    { { 0x08, 0x0F, 0xFA }, "Ksp",          "Ksp Inc." },
    { { 0x08, 0x10, 0x31 }, "LithiunalEne", "Lithiunal Energy" },
    { { 0x08, 0x10, 0x86 }, "NECPlatforms", "NEC Platforms, Ltd." },
    { { 0x08, 0x11, 0x5E }, "Bitel",        "Bitel Co., Ltd." },
    { { 0x08, 0x11, 0x96 }, "Intel",        "Intel Corporate" },
    { { 0x08, 0x12, 0x87 }, "JiangxiRisou", "Jiangxi Risound Electronics Co., LTD" },
    { { 0x08, 0x12, 0xA5 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0x14, 0x43 }, "Unibrain",     "Unibrain S.A." },
    { { 0x08, 0x15, 0x2F }, "SamsungElect", "Samsung Electronics Co., Ltd. ARTIK" },
    { { 0x08, 0x15, 0xAE }, "ChinaMobileG", "China Mobile Group Device Co.,Ltd." },
    { { 0x08, 0x16, 0x05 }, "VodafoneItal", "Vodafone Italia S.p.A." },
    { { 0x08, 0x16, 0x51 }, "SeaStarTechn", "Shenzhen Sea Star Technology Co.,Ltd" },
    { { 0x08, 0x16, 0xD5 }, "Goertek",      "Goertek Inc." },
    { { 0x08, 0x17, 0x35 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0x17, 0xF4 }, "IBM",          "IBM Corp" },
    { { 0x08, 0x18, 0x1A }, "zte",          "zte corporation" },
    { { 0x08, 0x18, 0x4C }, "ASThomas",     "A. S. Thomas, Inc." },
    { { 0x08, 0x19, 0xA6 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x1A, 0x1E }, "iCommSemicon", "Shenzhen iComm Semiconductor CO.,LTD" },
    { { 0x08, 0x1A, 0xFD }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0x1C, 0x6E }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x08, 0x1D, 0xC4 }, "ThermoFisher", "Thermo Fisher Scientific Messtechnik GmbH" },
    { { 0x08, 0x1D, 0xFB }, "MexonCommuni", "Shanghai Mexon Communication Technology Co.,Ltd" },
    { { 0x08, 0x1F, 0x3F }, "WondaLink",    "WondaLink Inc." },
    { { 0x08, 0x1F, 0x71 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x08, 0x1F, 0xEB }, "BinCube",      "BinCube" },
    { { 0x08, 0x1F, 0xF3 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0x21, 0xEF }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0x23, 0xB2 }, "vivoMobileCo", "vivo Mobile Communication Co., Ltd." },
    { { 0x08, 0x23, 0xC6 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x25, 0x22 }, "Advansee",     "Advansee" },
    { { 0x08, 0x25, 0x25 }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x08, 0x25, 0x73 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x26, 0x97 }, "ZyxelCommuni", "Zyxel Communications Corporation" },
    { { 0x08, 0x27, 0x19 }, "APSelectroni", "APS systems/electronic AG" },
    { { 0x08, 0x27, 0x6B }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0x27, 0xCE }, "NaganoKeiki",  "Nagano Keiki Co., Ltd." },
    { { 0x08, 0x28, 0x02 }, "ChuangweiRgb", "Shenzhen Chuangwei-Rgb Electronics Co.,Ltd" },
    { { 0x08, 0x2A, 0xD0 }, "SRDInnovatio", "SRD Innovations Inc." },
    { { 0x08, 0x2C, 0xB0 }, "NetworkInstr", "Network Instruments" },
    { { 0x08, 0x2C, 0xB6 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x2C, 0xED }, "TechnitySolu", "Technity Solutions Inc." },
    { { 0x08, 0x2E, 0x36 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0x2E, 0x5F }, "HewlettPacka", "Hewlett Packard" },
    { { 0x08, 0x2F, 0xE9 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x30, 0x6B }, "PaloAltoNetw", "Palo Alto Networks" },
    { { 0x08, 0x30, 0xCE }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x08, 0x31, 0x8B }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x31, 0xA4 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0x33, 0xED }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x08, 0x35, 0x1B }, "JialihuaElec", "Shenzhen Jialihua Electronic Technology Co., Ltd" },
    { { 0x08, 0x35, 0x71 }, "CASwell",      "CASwell INC." },
    { { 0x08, 0x35, 0xB2 }, "CoreEdgeNetw", "CoreEdge Networks Co., Ltd" },
    { { 0x08, 0x36, 0xC9 }, "Netgear",      "Netgear" },
    { { 0x08, 0x37, 0x3D }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0x37, 0x9C }, "Topaz",        "Topaz Co. LTD." },
    { { 0x08, 0x38, 0x69 }, "HongKongAMob", "Hong Kong AMobile Intelligent Corp. Limited Taiwan Branch" },
    { { 0x08, 0x38, 0xA5 }, "Funkwerkplet", "Funkwerk plettac electronic GmbH" },
    { { 0x08, 0x38, 0xE6 }, "MotorolaMobi", "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
    { { 0x08, 0x3A, 0x2F }, "GuangzhouJua", "Guangzhou Juan Intelligent Tech Joint Stock Co.,Ltd" },
    { { 0x08, 0x3A, 0x38 }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x08, 0x3A, 0x5C }, "Junilab",      "Junilab, Inc." },
    { { 0x08, 0x3A, 0x88 }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x08, 0x3A, 0x8D }, "Espressif",    "Espressif Inc." },
    { { 0x08, 0x3A, 0xB8 }, "ShinodaPlasm", "Shinoda Plasma Co., Ltd." },
    { { 0x08, 0x3A, 0xF2 }, "Espressif",    "Espressif Inc." },
    { { 0x08, 0x3B, 0xE9 }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x08, 0x3D, 0x88 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0x3E, 0x0C }, "ARRISGroup",   "ARRIS Group, Inc." },
    { { 0x08, 0x3E, 0x5D }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x08, 0x3E, 0x8E }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x08, 0x3F, 0x3E }, "WSH",          "WSH GmbH" },
    { { 0x08, 0x3F, 0x76 }, "IntellianTec", "Intellian Technologies, Inc." },
    { { 0x08, 0x3F, 0xBC }, "zte",          "zte corporation" },
    { { 0x08, 0x40, 0x27 }, "Gridstore",    "Gridstore Inc." },
    { { 0x08, 0x40, 0xF3 }, "TendaTechnol", "Tenda Technology Co.,Ltd.Dongguan branch" },
    { { 0x08, 0x42, 0x18 }, "Asyril",       "Asyril SA" },
    { { 0x08, 0x42, 0x96 }, "MobileTechno", "Mobile Technology Solutions LLC" },
    { { 0x08, 0x44, 0x73 }, "zte",          "zte corporation" },
    { { 0x08, 0x45, 0xD1 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0x46, 0x56 }, "VeoLabs",      "Veo-Labs" },
    { { 0x08, 0x46, 0xC7 }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x08, 0x47, 0x4C }, "Nokia",        "Nokia" },
    { { 0x08, 0x47, 0xD0 }, "NokiaShangha", "Nokia Shanghai Bell Co., Ltd." },
    { { 0x08, 0x48, 0x2C }, "RaycoreTaiwa", "Raycore Taiwan Co., LTD." },
    { { 0x08, 0x48, 0x57 }, "SutengInnova", "Suteng Innovation Technology Co., Ltd." },
    { { 0x08, 0x4A, 0xCF }, "OppoMobileTe", "Guangdong Oppo Mobile Telecommunications Corp.,Ltd" },
    { { 0x08, 0x4E, 0x1C }, "H2A",          "H2A Systems, LLC" },
    { { 0x08, 0x4E, 0xBF }, "SumitomoElec", "Sumitomo Electric Industries, Ltd" },
    { { 0x08, 0x4F, 0x0A }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x4F, 0x66 }, "SkyworthDigi", "Shenzhen Skyworth Digital Technology CO., Ltd" },
    { { 0x08, 0x4F, 0xA9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0x4F, 0xF9 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0x51, 0x04 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0x51, 0x14 }, "QingdaoTopsc", "Qingdao Topscomm Communication Co., Ltd" },
    { { 0x08, 0x51, 0x2E }, "OrionDiagnos", "Orion Diagnostica Oy" },
    { { 0x08, 0x52, 0x40 }, "EbVElektroni", "EbV Elektronikbau- und Vertriebs GmbH" },
    { { 0x08, 0x52, 0x4E }, "FangchengBai", "Shenzhen Fangcheng Baiyi Technology Co., Ltd." },
    { { 0x08, 0x54, 0x11 }, "HikvisionDig", "Hangzhou Hikvision Digital Technology Co.,Ltd." },
    { { 0x08, 0x54, 0xBB }, "ChuangweiRgb", "Shenzhen Chuangwei-Rgb Electronics Co.,Ltd" },
    { { 0x08, 0x55, 0x31 }, "Routerboardc", "Routerboard.com" },
    { { 0x08, 0x56, 0x9B }, "WiZ",          "WiZ" },
    { { 0x08, 0x57, 0x00 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x08, 0x57, 0xFB }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0x58, 0xA5 }, "VrvSoftwareC", "Beijing Vrv Software Corpoaration Limited." },
    { { 0x08, 0x5A, 0x11 }, "DLinkInterna", "D-Link International" },
    { { 0x08, 0x5A, 0xE0 }, "RecovisionTe", "Recovision Technology Co., Ltd." },
    { { 0x08, 0x5B, 0x0E }, "Fortinet",     "Fortinet, Inc." },
    { { 0x08, 0x5B, 0xD6 }, "Intel",        "Intel Corporate" },
    { { 0x08, 0x5B, 0xDA }, "CliniCare",    "CliniCare LTD" },
    { { 0x08, 0x5C, 0x1B }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x5D, 0xDD }, "Mercury",      "Mercury Corporation" },
    { { 0x08, 0x60, 0x6E }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x08, 0x60, 0x83 }, "zte",          "zte corporation" },
    { { 0x08, 0x61, 0x95 }, "RockwellAuto", "Rockwell Automation" },
    { { 0x08, 0x62, 0x66 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x08, 0x63, 0x61 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x65, 0x18 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x65, 0xF0 }, "JMZengge",     "JM Zengge Co., Ltd" },
    { { 0x08, 0x66, 0x1F }, "PaloAltoNetw", "Palo Alto Networks" },
    { { 0x08, 0x66, 0x98 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x67, 0x4E }, "Hisensebroad", "Hisense broadband multimedia technology Co.,Ltd" },
    { { 0x08, 0x68, 0x8D }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x08, 0x68, 0xD0 }, "JapanSystemD", "Japan System Design" },
    { { 0x08, 0x68, 0xEA }, "EitoElectron", "Eito Electronics Co., Ltd." },
    { { 0x08, 0x6A, 0x0A }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x08, 0x6A, 0xC5 }, "Intel",        "Intel Corporate" },
    { { 0x08, 0x6A, 0xE5 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0x6B, 0xD1 }, "SuperElectro", "Shenzhen SuperElectron Technology Co.,Ltd." },
    { { 0x08, 0x6B, 0xD7 }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x08, 0x6D, 0x41 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x6D, 0xF2 }, "MIMOWAVETech", "Shenzhen MIMOWAVE Technology Co.,Ltd" },
    { { 0x08, 0x6E, 0x9C }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0x6F, 0x48 }, "iCommSemicon", "Shenzhen iComm Semiconductor CO.,LTD" },
    { { 0x08, 0x70, 0x45 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x70, 0x73 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x71, 0x90 }, "Intel",        "Intel Corporate" },
    { { 0x08, 0x74, 0x02 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x74, 0x58 }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x08, 0x74, 0xF6 }, "Winterhalter", "Winterhalter Gastronom GmbH" },
    { { 0x08, 0x75, 0x72 }, "Obelux",       "Obelux Oy" },
    { { 0x08, 0x76, 0x18 }, "ViETechnolog", "ViE Technologies Sdn. Bhd." },
    { { 0x08, 0x76, 0x95 }, "AutoIndustri", "Auto Industrial Co., Ltd." },
    { { 0x08, 0x76, 0xFF }, "ThomsonTelec", "Thomson Telecom Belgium" },
    { { 0x08, 0x78, 0x08 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0x79, 0x8C }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x79, 0x99 }, "AIM",          "AIM GmbH" },
    { { 0x08, 0x7A, 0x4C }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x7B, 0x12 }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x08, 0x7B, 0x87 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0x7B, 0xAA }, "Svyazkomplek", "Svyazkomplektservice, Llc" },
    { { 0x08, 0x7C, 0x39 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0x7C, 0xBE }, "Quintic",      "Quintic Corp." },
    { { 0x08, 0x7D, 0x21 }, "Altasectechn", "Altasec technology corporation" },
    { { 0x08, 0x7E, 0x64 }, "VantivaUSA",   "Vantiva USA LLC" },
    { { 0x08, 0x7F, 0x98 }, "vivoMobileCo", "vivo Mobile Communication Co., Ltd." },
    { { 0x08, 0x80, 0x39 }, "CiscoSPVTG",   "Cisco SPVTG" },
    { { 0x08, 0x81, 0xB2 }, "LogitechTech", "Logitech (China) Technology Co., Ltd" },
    { { 0x08, 0x81, 0xBC }, "HongKongIpro", "HongKong Ipro Technology Co., Limited" },
    { { 0x08, 0x81, 0xF4 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x08, 0x84, 0x66 }, "NovartisPhar", "Novartis Pharma AG" },
    { { 0x08, 0x84, 0x9D }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0x84, 0xFB }, "HonorDevice",  "Honor Device Co., Ltd." },
    { { 0x08, 0x85, 0x5B }, "KontronEurop", "Kontron Europe GmbH" },
    { { 0x08, 0x86, 0x20 }, "TecnoMobile",  "Tecno Mobile Limited" },
    { { 0x08, 0x86, 0x3B }, "BelkinIntern", "Belkin International Inc." },
    { { 0x08, 0x87, 0xC6 }, "IngramMicroS", "Ingram Micro Services" },
    { { 0x08, 0x87, 0xC7 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x8B, 0xC8 }, "Google",       "Google, Inc." },
    { { 0x08, 0x8C, 0x2C }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0x8D, 0xC8 }, "RyowaElectro", "Ryowa Electronics Co.,Ltd" },
    { { 0x08, 0x8E, 0x4F }, "SFSoftwareSo", "SF Software Solutions" },
    { { 0x08, 0x8E, 0x90 }, "Intel",        "Intel Corporate" },
    { { 0x08, 0x8E, 0xDC }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x8F, 0x2C }, "AmberTechnol", "Amber Technology Ltd." },
    { { 0x08, 0x8F, 0xC3 }, "CompalInform", "Compal Information (Kunshan) Co., Ltd." },
    { { 0x08, 0x90, 0xBA }, "Danlaw",       "Danlaw Inc" },
    { { 0x08, 0x91, 0x15 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0x91, 0xA3 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0x92, 0x04 }, "Dell",         "Dell Inc." },
    { { 0x08, 0x93, 0x56 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x94, 0xEF }, "WistronInfoc", "Wistron Infocomm (Zhongshan) Corporation" },
    { { 0x08, 0x95, 0x2A }, "VantivaUSA",   "Vantiva USA LLC" },
    { { 0x08, 0x95, 0x42 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0x96, 0xAD }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0x96, 0xD7 }, "AVM",          "AVM GmbH" },
    { { 0x08, 0x97, 0x34 }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x08, 0x97, 0x58 }, "StrongRising", "Shenzhen Strong Rising Electronics Co.,Ltd DongGuan Subsidiary" },
    { { 0x08, 0x97, 0x98 }, "CompalInform", "Compal Information (Kunshan) Co., Ltd." },
    { { 0x08, 0x99, 0xE8 }, "KEMAS",        "KEMAS GmbH" },
    { { 0x08, 0x9A, 0xC7 }, "zte",          "zte corporation" },
    { { 0x08, 0x9B, 0x4B }, "iKuaiNetwork", "iKuai Networks" },
    { { 0x08, 0x9B, 0xB9 }, "NokiaSolutio", "Nokia Solutions and Networks GmbH & Co. KG" },
    { { 0x08, 0x9B, 0xF1 }, "eero",         "eero inc." },
    { { 0x08, 0x9C, 0x86 }, "NokiaShangha", "Nokia Shanghai Bell Co., Ltd." },
    { { 0x08, 0x9D, 0xF4 }, "Intel",        "Intel Corporate" },
    { { 0x08, 0x9E, 0x01 }, "QuantaComput", "Quanta Computer Inc." },
    { { 0x08, 0x9E, 0x08 }, "Google",       "Google, Inc." },
    { { 0x08, 0x9E, 0x84 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0x9F, 0x97 }, "LeroyAutomat", "Leroy Automation" },
    { { 0x08, 0xA1, 0x2B }, "EZLTechnolog", "ShenZhen EZL Technology Co., Ltd" },
    { { 0x08, 0xA1, 0x89 }, "HikvisionDig", "Hangzhou Hikvision Digital Technology Co.,Ltd." },
    { { 0x08, 0xA5, 0xC8 }, "SunnovoInter", "Sunnovo International Limited" },
    { { 0x08, 0xA5, 0xDF }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xA6, 0xBC }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0xA6, 0xF7 }, "Espressif",    "Espressif Inc." },
    { { 0x08, 0xA7, 0xC0 }, "VantivaUSA",   "Vantiva USA LLC" },
    { { 0x08, 0xA8, 0x42 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0xA8, 0xA1 }, "Cyclotronics", "Cyclotronics Power Concepts, Inc" },
    { { 0x08, 0xA9, 0x5A }, "AzureWaveTec", "AzureWave Technology Inc." },
    { { 0x08, 0xAA, 0x55 }, "MotorolaMobi", "Motorola Mobility LLC, a Lenovo Company" },
    { { 0x08, 0xAA, 0x89 }, "zte",          "zte corporation" },
    { { 0x08, 0xAC, 0xA5 }, "BenuVideo",    "Benu Video, Inc." },
    { { 0x08, 0xAC, 0xC4 }, "FMTech",       "FMTech" },
    { { 0x08, 0xAE, 0xD6 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xAF, 0x78 }, "TotusSolutio", "Totus Solutions, Inc." },
    { { 0x08, 0xB0, 0x55 }, "AskeyCompute", "Askey Computer Corp" },
    { { 0x08, 0xB0, 0xA7 }, "Truebeyond",   "Truebeyond Co., Ltd" },
    { { 0x08, 0xB2, 0x58 }, "JuniperNetwo", "Juniper Networks" },
    { { 0x08, 0xB2, 0xA3 }, "CynnyItalia",  "Cynny Italia S.r.L." },
    { { 0x08, 0xB3, 0xAF }, "vivoMobileCo", "vivo Mobile Communication Co., Ltd." },
    { { 0x08, 0xB4, 0x9D }, "TecnoMobile",  "Tecno Mobile Limited" },
    { { 0x08, 0xB4, 0xB1 }, "Google",       "Google, Inc." },
    { { 0x08, 0xB4, 0xCF }, "AbicomIntern", "Abicom International" },
    { { 0x08, 0xB4, 0xD2 }, "Intel",        "Intel Corporate" },
    { { 0x08, 0xB6, 0x1F }, "Espressif",    "Espressif Inc." },
    { { 0x08, 0xB7, 0x38 }, "LiteOnTechno", "Lite-On Technogy Corp." },
    { { 0x08, 0xB7, 0xEC }, "WirelessSeis", "Wireless Seismic" },
    { { 0x08, 0xBA, 0x22 }, "Swaive",       "Swaive Corporation" },
    { { 0x08, 0xBA, 0x5F }, "QingdaoHisen", "Qingdao Hisense Electronics Co.,Ltd." },
    { { 0x08, 0xBA, 0xB7 }, "CeragonNetwo", "Ceragon Networks Ltd." },
    { { 0x08, 0xBB, 0x3C }, "FlextronicsT", "Flextronics Tech.(Ind) Pvt Ltd" },
    { { 0x08, 0xBB, 0xCC }, "AKNORDEDVVER", "AK-NORD EDV VERTRIEBSGES. mbH" },
    { { 0x08, 0xBC, 0x20 }, "RoyalCloudTe", "Hangzhou Royal Cloud Technology Co., Ltd" },
    { { 0x08, 0xBD, 0x43 }, "Netgear",      "Netgear" },
    { { 0x08, 0xBE, 0x09 }, "AstrolElectr", "Astrol Electronic AG" },
    { { 0x08, 0xBE, 0x77 }, "GreenElectro", "Green Electronics" },
    { { 0x08, 0xBE, 0xAC }, "EdimaxTechno", "Edimax Technology Co. Ltd." },
    { { 0x08, 0xBF, 0xA0 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xBF, 0xB8 }, "ASUSTekCOMPU", "ASUSTek COMPUTER INC." },
    { { 0x08, 0xC0, 0x21 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0xC0, 0x6C }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0xC0, 0xEB }, "MellanoxTech", "Mellanox Technologies, Inc." },
    { { 0x08, 0xC2, 0x24 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x08, 0xC3, 0xB3 }, "TCLKingElect", "TCL King Electrical Appliances(Huizhou)Co.,Ltd" },
    { { 0x08, 0xC5, 0xE1 }, "SamsungElect", "Samsung Electro-Mechanics(Thailand)" },
    { { 0x08, 0xC6, 0xB3 }, "Qtech",        "Qtech Llc" },
    { { 0x08, 0xC7, 0x29 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0xC7, 0xF5 }, "VantivaConne", "Vantiva Connected Home - Technologies Telco" },
    { { 0x08, 0xC8, 0xC2 }, "GNAudio",      "GN Audio A/S" },
    { { 0x08, 0xCA, 0x45 }, "ToyouFeijiEl", "Toyou Feiji Electronics Co., Ltd." },
    { { 0x08, 0xCB, 0xE5 }, "R3Solutions",  "R3 Solutions GmbH" },
    { { 0x08, 0xCC, 0x27 }, "MotorolaMobi", "Motorola Mobility LLC, a Lenovo Company" },
    { { 0x08, 0xCC, 0x68 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0xCC, 0x81 }, "HikvisionDig", "Hangzhou Hikvision Digital Technology Co.,Ltd." },
    { { 0x08, 0xCC, 0xA7 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0xCD, 0x9B }, "samtecautomo", "samtec automotive electronics & software GmbH" },
    { { 0x08, 0xD0, 0x9F }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0xD0, 0xB7 }, "QingdaoHisen", "Qingdao Hisense Communications Co.,Ltd." },
    { { 0x08, 0xD1, 0xF9 }, "Espressif",    "Espressif Inc." },
    { { 0x08, 0xD2, 0x3E }, "Intel",        "Intel Corporate" },
    { { 0x08, 0xD2, 0x9A }, "Proformatiqu", "Proformatique" },
    { { 0x08, 0xD3, 0x4B }, "TechmanElect", "Techman Electronics (Changshu) Co., Ltd." },
    { { 0x08, 0xD4, 0x0C }, "Intel",        "Intel Corporate" },
    { { 0x08, 0xD4, 0x2B }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xD4, 0x6A }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x08, 0xD5, 0x9D }, "SagemcomBroa", "Sagemcom Broadband SAS" },
    { { 0x08, 0xD5, 0xC0 }, "SeersTechnol", "Seers Technology Co., Ltd" },
    { { 0x08, 0xD8, 0x33 }, "RFTechnology", "Shenzhen RF Technology Co., Ltd" },
    { { 0x08, 0xDD, 0xEB }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x08, 0xDF, 0x1F }, "Bose",         "Bose Corporation" },
    { { 0x08, 0xDF, 0xCB }, "SystromeNetw", "Systrome Networks" },
    { { 0x08, 0xE0, 0x21 }, "HonorDevice",  "Honor Device Co., Ltd." },
    { { 0x08, 0xE3, 0x42 }, "Cear",         "Cear, Inc." },
    { { 0x08, 0xE4, 0xDF }, "SandeDacomEl", "Shenzhen Sande Dacom Electronics Co., Ltd" },
    { { 0x08, 0xE5, 0xDA }, "NanjingFujit", "Nanjing Fujitsu Computer Products Co.,Ltd." },
    { { 0x08, 0xE6, 0x3B }, "zte",          "zte corporation" },
    { { 0x08, 0xE6, 0x72 }, "JebseeElectr", "Jebsee Electronics Co.,Ltd." },
    { { 0x08, 0xE6, 0x89 }, "Apple",        "Apple, Inc." },
    { { 0x08, 0xE6, 0xC9 }, "Businessinte", "Business-intelligence of Oriental Nations Corporation Ltd." },
    { { 0x08, 0xE7, 0xE5 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0xE8, 0x4F }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0xE9, 0xF6 }, "AMPAKTechnol", "AMPAK Technology,Inc." },
    { { 0x08, 0xEA, 0x40 }, "BilianElectr", "Shenzhen Bilian Electronic Co.，Ltd" },
    { { 0x08, 0xEA, 0x44 }, "ExtremeNetwo", "Extreme Networks Headquarters" },
    { { 0x08, 0xEB, 0x29 }, "JiangsuHuito", "Jiangsu Huitong Group Co.,Ltd." },
    { { 0x08, 0xEB, 0x74 }, "HUMAX",        "HUMAX Co., Ltd." },
    { { 0x08, 0xEB, 0xED }, "WorldEliteTe", "World Elite Technology Co.,LTD" },
    { { 0x08, 0xEB, 0xF6 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0xEC, 0xA9 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xEC, 0xF5 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0xED, 0x9D }, "TecnoMobile",  "Tecno Mobile Limited" },
    { { 0x08, 0xED, 0xB9 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x08, 0xED, 0xED }, "ZhejiangDahu", "Zhejiang Dahua Technology Co., Ltd." },
    { { 0x08, 0xEE, 0x8B }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xEF, 0x3B }, "MCSLogic",     "MCS Logic Inc." },
    { { 0x08, 0xEF, 0xAB }, "SaymeWireles", "Sayme Wireless Sensor Network" },
    { { 0x08, 0xF0, 0x1E }, "eero",         "eero inc." },
    { { 0x08, 0xF0, 0xB6 }, "EdifierInter", "Edifier International" },
    { { 0x08, 0xF1, 0xB3 }, "CiscoMeraki",  "Cisco Meraki" },
    { { 0x08, 0xF1, 0xB7 }, "TowerstreamC", "Towerstream Corpration" },
    { { 0x08, 0xF1, 0xEA }, "HewlettPacka", "Hewlett Packard Enterprise" },
    { { 0x08, 0xF2, 0xF4 }, "NetOnePartne", "Net One Partners Co.,Ltd." },
    { { 0x08, 0xF3, 0xFB }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x08, 0xF4, 0x58 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x08, 0xF4, 0xAB }, "Apple",        "Apple, Inc." },
    { { 0x08, 0xF6, 0x06 }, "zte",          "zte corporation" },
    { { 0x08, 0xF6, 0x9C }, "Apple",        "Apple, Inc." },
    { { 0x08, 0xF6, 0xF8 }, "GETEngineeri", "GET Engineering" },
    { { 0x08, 0xF7, 0x28 }, "GLOBOMultime", "GLOBO Multimedia Sp. z o.o. Sp.k." },
    { { 0x08, 0xF7, 0xE9 }, "HRCPResearch", "HRCP Research and Development Partnership" },
    { { 0x08, 0xF8, 0xBC }, "Apple",        "Apple, Inc." },
    { { 0x08, 0xF9, 0xE0 }, "Espressif",    "Espressif Inc." },
    { { 0x08, 0xFA, 0x28 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x08, 0xFA, 0x79 }, "vivoMobileCo", "vivo Mobile Communication Co., Ltd." },
    { { 0x08, 0xFA, 0xE0 }, "FohhnAudio",   "Fohhn Audio AG" },
    { { 0x08, 0xFB, 0xEA }, "AMPAKTechnol", "AMPAK Technology,Inc." },
    { { 0x08, 0xFC, 0x52 }, "OpenXS",       "OpenXS BV" },
    { { 0x08, 0xFC, 0x88 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xFD, 0x0E }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x08, 0xFF, 0x24 }, "SkyworthDigi", "Shenzhen Skyworth Digital Technology CO., Ltd" },
    { { 0x08, 0xFF, 0x44 }, "Apple",        "Apple, Inc." },
    { { 0x0A, 0x2A, 0x33 }, "Digistor",     "Digistor" },
    { { 0x0A, 0x35, 0xF2 }, "IntegratedTe", "Integrated Technical Vision Ltd" },
    { { 0x0A, 0x36, 0x1C }, "Smardii",      "Smardii" },
    { { 0x0A, 0x87, 0x36 }, "IEEE1901Work", "IEEE 1901 Working Group" },
    { { 0x0A, 0x8E, 0x62 }, "DeltaSolutio", "Delta Solutions LLC" },
    { { 0x0A, 0xA2, 0x3B }, "Vitex",        "Vitex LLC" },
    { { 0x0A, 0xAB, 0x8C }, "MidwestMicro", "Midwest Microwave Solutions Inc." },
    { { 0x0A, 0xCD, 0x8F }, "CiscoNorway",  "Cisco Systems Norway" },
    { { 0x0A, 0xD9, 0xC4 }, "CraftDesigns", "Craft Designs, Inc" },
    { { 0x0A, 0xE4, 0x71 }, "Caterpillar",  "Caterpillar Inc." },
    { { 0x0A, 0xE9, 0x1B }, "PADLSoftware", "PADL Software Pty Ltd" },
    { { 0x0C, 0x01, 0x4B }, "zte",          "zte corporation" },
    { { 0x0C, 0x01, 0xA5 }, "zte",          "zte corporation" },
    { { 0x0C, 0x01, 0xC8 }, "DENSO",        "DENSO Co.,Ltd" },
    { { 0x0C, 0x01, 0xDB }, "Infinixmobil", "Infinix mobility limited" },
    { { 0x0C, 0x02, 0x27 }, "VantivaUSA",   "Vantiva USA LLC" },
    { { 0x0C, 0x02, 0xBD }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x0C, 0x04, 0x00 }, "Jantardoo",    "Jantar d.o.o." },
    { { 0x0C, 0x05, 0x35 }, "Juniper",      "Juniper Systems" },
    { { 0x0C, 0x07, 0xDF }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x0C, 0x08, 0xB4 }, "HUMAX",        "HUMAX Co., Ltd." },
    { { 0x0C, 0x0A, 0xDF }, "TexasInstrum", "Texas Instruments" },
    { { 0x0C, 0x0E, 0x76 }, "DLinkInterna", "D-Link International" },
    { { 0x0C, 0x11, 0x05 }, "AkuvoxNetwor", "Akuvox (Xiamen) Networks Co., Ltd" },
    { { 0x0C, 0x11, 0x67 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x0C, 0x12, 0x62 }, "zte",          "zte corporation" },
    { { 0x0C, 0x13, 0x0B }, "Uniqoteq",     "Uniqoteq Ltd." },
    { { 0x0C, 0x14, 0x20 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x0C, 0x14, 0xD2 }, "ChinaMobileG", "China Mobile Group Device Co.,Ltd." },
    { { 0x0C, 0x15, 0x39 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x15, 0xC5 }, "SDTEC",        "SDTEC Co., Ltd." },
    { { 0x0C, 0x17, 0x73 }, "HuaweiDevice", "Huawei Device Co., Ltd." },
    { { 0x0C, 0x17, 0xF1 }, "Telecsys",     "Telecsys" },
    { { 0x0C, 0x18, 0x4E }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x19, 0x1F }, "InformElectr", "Inform Electronik" },
    { { 0x0C, 0x19, 0xF8 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x1A, 0x10 }, "AcousticStre", "Acoustic Stream" },
    { { 0x0C, 0x1C, 0x19 }, "LongconnElec", "Longconn Electronics(Shenzhen) Co.,Ltd" },
    { { 0x0C, 0x1C, 0x1A }, "eero",         "eero inc." },
    { { 0x0C, 0x1C, 0x20 }, "Kakao",        "Kakao Corp" },
    { { 0x0C, 0x1C, 0x57 }, "TexasInstrum", "Texas Instruments" },
    { { 0x0C, 0x1D, 0xAF }, "XiaomiCommun", "Xiaomi Communications Co Ltd" },
    { { 0x0C, 0x1D, 0xC2 }, "SeAHNetworks", "SeAH Networks" },
    { { 0x0C, 0x1E, 0xF7 }, "OmniID",       "Omni-ID" },
    { { 0x0C, 0x20, 0x26 }, "noaxTechnolo", "noax Technologies AG" },
    { { 0x0C, 0x20, 0xD3 }, "vivoMobileCo", "vivo Mobile Communication Co., Ltd." },
    { { 0x0C, 0x21, 0x38 }, "Hengstler",    "Hengstler GmbH" },
    { { 0x0C, 0x23, 0x69 }, "HoneywellSPS", "Honeywell SPS" },
    { { 0x0C, 0x23, 0x8D }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x25, 0x76 }, "LongcheerTel", "Longcheer Telecommunication Limited" },
    { { 0x0C, 0x27, 0x24 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x0C, 0x27, 0x55 }, "ValuableTech", "Valuable Techologies Limited" },
    { { 0x0C, 0x29, 0x8F }, "Tesla",        "Tesla,Inc." },
    { { 0x0C, 0x29, 0xEF }, "Dell",         "Dell Inc." },
    { { 0x0C, 0x2A, 0x69 }, "electricimp",  "electric imp, incorporated" },
    { { 0x0C, 0x2A, 0x6F }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x0C, 0x2A, 0x86 }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x0C, 0x2A, 0xE7 }, "GeneralResea", "Beijing General Research Institute of Mining and Metallurgy" },
    { { 0x0C, 0x2C, 0x54 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x2D, 0x89 }, "QiiQCommunic", "QiiQ Communications Inc." },
    { { 0x0C, 0x2E, 0x57 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x2F, 0xB0 }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x0C, 0x30, 0x21 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x31, 0xDC }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x32, 0x3A }, "SamsungElect", "Samsung Electronics Co.,Ltd" },
    { { 0x0C, 0x35, 0x26 }, "Microsoft",    "Microsoft Corporation" },
    { { 0x0C, 0x35, 0x4F }, "Nokia",        "Nokia" },
    { { 0x0C, 0x35, 0xFE }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x0C, 0x37, 0x47 }, "zte",          "zte corporation" },
    { { 0x0C, 0x37, 0x96 }, "BizlinkTechn", "Bizlink Technology, Inc." },
    { { 0x0C, 0x37, 0xDC }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x38, 0x3E }, "FanvilTechno", "Fanvil Technology Co., Ltd." },
    { { 0x0C, 0x39, 0x56 }, "Observatorin", "Observator instruments" },
    { { 0x0C, 0x3A, 0xFA }, "NewH3CTechno", "New H3C Technologies Co., Ltd" },
    { { 0x0C, 0x3B, 0x50 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x3C, 0x65 }, "DomeImaging",  "Dome Imaging Inc" },
    { { 0x0C, 0x3C, 0xCD }, "UniversalGlo", "Universal Global Scientific Industrial Co., Ltd." },
    { { 0x0C, 0x3E, 0x9F }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x41, 0x01 }, "RuichiAutoTe", "Ruichi Auto Technology (Guangzhou) Co., Ltd." },
    { { 0x0C, 0x41, 0x3E }, "Microsoft",    "Microsoft Corporation" },
    { { 0x0C, 0x41, 0xE9 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x42, 0xA1 }, "MellanoxTech", "Mellanox Technologies, Inc." },
    { { 0x0C, 0x43, 0x14 }, "SiliconLabor", "Silicon Laboratories" },
    { { 0x0C, 0x43, 0xF9 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x0C, 0x45, 0xBA }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x46, 0x9D }, "MSSedco",      "MS Sedco" },
    { { 0x0C, 0x47, 0x3D }, "HitronTechno", "Hitron Technologies. Inc" },
    { { 0x0C, 0x47, 0xC9 }, "AmazonTechno", "Amazon Technologies Inc." },
    { { 0x0C, 0x48, 0x85 }, "LGElectronic", "LG Electronics (Mobile Communications)" },
    { { 0x0C, 0x48, 0xC6 }, "Celestica",    "Celestica Inc." },
    { { 0x0C, 0x49, 0x33 }, "SichuanJiuzh", "Sichuan Jiuzhou Electronic Technology Co., Ltd." },
    { { 0x0C, 0x4B, 0x48 }, "Nokia",        "Nokia" },
    { { 0x0C, 0x4B, 0x54 }, "TpLinkTechno", "Tp-Link Technologies Co.,Ltd." },
    { { 0x0C, 0x4B, 0xEE }, "TexasInstrum", "Texas Instruments" },
    { { 0x0C, 0x4C, 0x39 }, "MitraStarTec", "MitraStar Technology Corp." },
    { { 0x0C, 0x4D, 0xE9 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x4E, 0xC0 }, "Maxlinear",    "Maxlinear Inc" },
    { { 0x0C, 0x4F, 0x5A }, "ASART",        "ASA-RT s.r.l." },
    { { 0x0C, 0x4F, 0x9B }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x51, 0x01 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x51, 0x7E }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x51, 0xF7 }, "ChauvinArnou", "Chauvin Arnoux" },
    { { 0x0C, 0x52, 0x03 }, "AgmGroup",     "Agm Group Limited" },
    { { 0x0C, 0x53, 0x31 }, "ETHZurich",    "ETH Zurich" },
    { { 0x0C, 0x53, 0xB7 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x54, 0x15 }, "Intel",        "Intel Corporate" },
    { { 0x0C, 0x54, 0xA5 }, "Pegatron",     "Pegatron Corporation" },
    { { 0x0C, 0x54, 0xB9 }, "Nokia",        "Nokia" },
    { { 0x0C, 0x55, 0x21 }, "Axiros",       "Axiros GmbH" },
    { { 0x0C, 0x56, 0x5C }, "HyBroadVisio", "HyBroad Vision (Hong Kong) Technology Co Ltd" },
    { { 0x0C, 0x57, 0xEB }, "Mueller",      "Mueller Systems" },
    { { 0x0C, 0x58, 0x42 }, "DMEMicro",     "DME Micro" },
    { { 0x0C, 0x59, 0x9C }, "JuniperNetwo", "Juniper Networks" },
    { { 0x0C, 0x5A, 0x19 }, "AxtionSdnBhd", "Axtion Sdn Bhd" },
    { { 0x0C, 0x5A, 0x9E }, "WiSUNAllianc", "Wi-SUN Alliance" },
    { { 0x0C, 0x5C, 0xD8 }, "DOLIElektron", "DOLI Elektronik GmbH" },
    { { 0x0C, 0x5F, 0x35 }, "NiagaraVideo", "Niagara Video Corporation" },
    { { 0x0C, 0x60, 0x46 }, "vivoMobileCo", "vivo Mobile Communication Co., Ltd." },
    { { 0x0C, 0x60, 0x76 }, "HonHaiPrecis", "Hon Hai Precision Ind. Co.,Ltd." },
    { { 0x0C, 0x61, 0x11 }, "AndaTechnolo", "Anda Technologies SAC" },
    { { 0x0C, 0x61, 0x27 }, "ActiontecEle", "Actiontec Electronics, Inc" },
    { { 0x0C, 0x61, 0xCF }, "TexasInstrum", "Texas Instruments" },
    { { 0x0C, 0x62, 0xA6 }, "HuiZhouGaosh", "Hui Zhou Gaoshengda Technology Co.,LTD" },
    { { 0x0C, 0x63, 0xFC }, "NanjingSignw", "Nanjing Signway Technology Co., Ltd" },
    { { 0x0C, 0x64, 0x22 }, "WiseasyTechn", "Beijing Wiseasy Technology Co.,Ltd." },
    { { 0x0C, 0x65, 0x9A }, "PanasonicAut", "Panasonic Automotive Systems Company of America" },
    { { 0x0C, 0x67, 0x14 }, "SernetTechno", "Sernet (Suzhou) Technologies Corporation" },
    { { 0x0C, 0x67, 0x43 }, "HuaweiTechno", "Huawei Technologies Co.,Ltd" },
    { { 0x0C, 0x68, 0x03 }, "Cisco",        "Cisco Systems, Inc" },
    { { 0x0C, 0x68, 0x25 }, "SuzhouHYCtec", "Suzhou HYC technology Co., Ltd." },
    { { 0x0C, 0x6A, 0xBC }, "FiberhomeTel", "Fiberhome Telecommunication Technologies Co.,LTD" },
    { { 0x0C, 0x6A, 0xC4 }, "Apple",        "Apple, Inc." },
    { { 0x0C, 0x6A, 0xE6 }, "StanleySecur", "Stanley Security Solutions" },
    { { 0x0C, 0x6E, 0x4F }, "PrimeV