/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-xnap.c                                                              */
/* asn2wrs.py -q -L -p xnap -c ./xnap.cnf -s ./packet-xnap-template -D . -O ../.. XnAP-CommonDataTypes.asn XnAP-Constants.asn XnAP-Containers.asn XnAP-IEs.asn XnAP-PDU-Contents.asn XnAP-PDU-Descriptions.asn */

/* packet-xnap.c
 * Routines for dissecting NG-RAN Xn application protocol (XnAP)
 * 3GPP TS 38.423 packet dissection
 * Copyright 2018-2024, Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Ref:
 * 3GPP TS 38.423 V18.2.0 (2024-06)
 */

#include "config.h"

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/prefs.h>
#include <epan/sctpppids.h>
#include <epan/proto_data.h>
#include <epan/conversation.h>

#include "packet-xnap.h"
#include "packet-per.h"
#include "packet-lte-rrc.h"
#include "packet-nr-rrc.h"
#include "packet-e212.h"
#include "packet-ngap.h"
#include "packet-s1ap.h"
#include "packet-ranap.h"
#include "packet-ntp.h"
#include "packet-f1ap.h"
#include "packet-nrppa.h"

#ifdef _MSC_VER
/* disable: "warning C4146: unary minus operator applied to unsigned type, result still unsigned" */
#pragma warning(disable:4146)
#endif

#define PNAME  "NG-RAN Xn Application Protocol (XnAP)"
#define PSNAME "XnAP"
#define PFNAME "xnap"

/* Dissector will use SCTP PPID 61 or SCTP port. IANA assigned port = 38422 */
#define SCTP_PORT_XnAP	38422

#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxEARFCN                      262143
#define maxnoofAllowedAreas            16
#define maxnoofAMFRegions              16
#define maxnoofAoIs                    64
#define maxnoofBluetoothName           4
#define maxnoofBPLMNs                  12
#define maxnoofCAGs                    12
#define maxnoofCAGsperPLMN             256
#define maxnoofCellIDforMDT            32
#define maxnoofCellsinAoI              256
#define maxnoofCellsinUEHistoryInfo    16
#define maxnoofCellsinNG_RANnode       16384
#define maxnoofCellsinRNA              32
#define maxnoofCellsUEMovingTrajectory 16
#define maxnoofDRBs                    32
#define maxnoofEUTRABands              16
#define maxnoofEUTRABPLMNs             6
#define maxnoofEPLMNs                  15
#define maxnoofExtSliceItems           65535
#define maxnoofEPLMNsplus1             16
#define maxnoofForbiddenTACs           4096
#define maxnoofFreqforMDT              8
#define maxnoofMBSFNEUTRA              8
#define maxnoofMDTPLMNs                16
#define maxnoofMultiConnectivityMinusOne 3
#define maxnoofNeighbours              1024
#define maxnoofNeighPCIforMDT          32
#define maxnoofNIDs                    12
#define maxnoofNRCellBands             32
#define maxnoofPLMNs                   16
#define maxnoofPDUSessions             256
#define maxnoofProtectedResourcePatterns 16
#define maxnoofQoSFlows                64
#define maxnoofQoSParaSets             8
#define maxnoofRANAreaCodes            32
#define maxnoofRANAreasinRNA           16
#define maxnoofRANNodesinAoI           64
#define maxnoofSCellGroups             3
#define maxnoofSCellGroupsplus1        4
#define maxnoofSensorName              3
#define maxnoofSliceItems              1024
#define maxnoofSNPNIDs                 12
#define maxnoofsupportedPLMNs          12
#define maxnoofsupportedTACs           256
#define maxnoofTAforMDT                8
#define maxnoofTAI                     16
#define maxnoofTAIsinAoI               16
#define maxnooftimeperiods             2
#define maxnoofTNLAssociations         32
#define maxnoofUEContexts              8192
#define maxNRARFCN                     3279165
#define maxNrOfErrors                  256
#define maxnoofslots                   5120
#define maxnoofExtTLAs                 16
#define maxnoofGTPTLAs                 16
#define maxnoofCHOcells                8
#define maxnoofPC5QoSFlows             2064
#define maxnoofSSBAreas                64
#define maxnoofRAReports               64
#define maxnoofNRSCSs                  5
#define maxnoofPhysicalResourceBlocks  275
#define maxnoofAdditionalPDCPDuplicationTNL 2
#define maxnoofRLCDuplicationstate     3
#define maxnoofWLANName                4
#define maxnoofNonAnchorCarrierFreqConfig 15
#define maxnoofDataForwardingTunneltoE_UTRAN 256
#define maxnoofMBSFSAs                 256
#define maxnoofUEIDIndicesforMBSPaging 4096
#define maxnoofMBSQoSFlows             64
#define maxnoofMRBs                    32
#define maxnoofCellsforMBS             8192
#define maxnoofMBSServiceAreaInformation 256
#define maxnoofTAIforMBS               1024
#define maxnoofAssociatedMBSSessions   32
#define maxnoofMBSSessions             256
#define maxnoofSuccessfulHOReports     64
#define maxnoofPSCellsPerSN            8
#define maxnoofNR_UChannelIDs          16
#define maxnoofCellsinCHO              8
#define maxnoofCHOexecutioncond        2
#define maxnoofServedCellsIAB          512
#define maxnoofServingCells            32
#define maxnoofBHInfo                  1024
#define maxnoofTrafficIndexEntries     1024
#define maxnoofTLAsIAB                 1024
#define maxnoofBAPControlPDURLCCHs     2
#define maxnoofIABSTCInfo              45
#define maxnoofSymbols                 14
#define maxnoofDUFSlots                320
#define maxnoofHSNASlots               5120
#define maxnoofRBsetsPerCell           8
#define maxnoofRBsetsPerCell1          7
#define maxnoofChildIABNodes           1024
#define maxnoofPSCellCandidates        8
#define maxnoofTargetSNs               8
#define maxnoofUEAppLayerMeas          16
#define maxnoofSNSSAIforQMC            16
#define maxnoofCellIDforQMC            32
#define maxnoofPLMNforQMC              16
#define maxnoofTAforQMC                8
#define maxnoofMTCItems                16
#define maxnoofCSIRSconfigurations     96
#define maxnoofCSIRSneighbourCells     16
#define maxnoofCSIRSneighbourCellsInMTC 16
#define maxnoofNeighbour_NG_RAN_Nodes  256
#define maxnoofSRBs                    5
#define maxnoofSMBR                    8
#define maxnoofNSAGs                   256
#define maxnoofTargetSNsMinusOne       7
#define maxnoofThresholdsForExcessPacketDelay 255
#define maxnoofESNPNs                  15
#define maxnoofSuccessfulPSCellChangeReports 64
#define maxnoofUEsforRAReportIndications 64
#define maxnoofPSCellsinCPAC           8
#define maxnoofCPACexecutioncond       2
#define maxnoofLBTFailureInformation   64
#define maxnoofCellsTrajectoryPredict  16
#define maxnoofCellsTrajectory         16
#define maxFailedCellMeasObjects       124
#define maxFailedMeasPerNode           124
#define maxnoofUEReports               16
#define maxnoofCandidateRelayUEs       32
#define maxnoofCAGforMDT               256
#define maxnoofMDTSNPNs                16
#define maxnoofSecurityConfigurations  8
#define maxnoofRSPPQoSFlows            2048

typedef enum _ProcedureCode_enum {
  id_handoverPreparation =   0,
  id_sNStatusTransfer =   1,
  id_handoverCancel =   2,
  id_retrieveUEContext =   3,
  id_rANPaging =   4,
  id_xnUAddressIndication =   5,
  id_uEContextRelease =   6,
  id_sNGRANnodeAdditionPreparation =   7,
  id_sNGRANnodeReconfigurationCompletion =   8,
  id_mNGRANnodeinitiatedSNGRANnodeModificationPreparation =   9,
  id_sNGRANnodeinitiatedSNGRANnodeModificationPreparation =  10,
  id_mNGRANnodeinitiatedSNGRANnodeRelease =  11,
  id_sNGRANnodeinitiatedSNGRANnodeRelease =  12,
  id_sNGRANnodeCounterCheck =  13,
  id_sNGRANnodeChange =  14,
  id_rRCTransfer =  15,
  id_xnRemoval =  16,
  id_xnSetup   =  17,
  id_nGRANnodeConfigurationUpdate =  18,
  id_cellActivation =  19,
  id_reset     =  20,
  id_errorIndication =  21,
  id_privateMessage =  22,
  id_notificationControl =  23,
  id_activityNotification =  24,
  id_e_UTRA_NR_CellResourceCoordination =  25,
  id_secondaryRATDataUsageReport =  26,
  id_deactivateTrace =  27,
  id_traceStart =  28,
  id_handoverSuccess =  29,
  id_conditionalHandoverCancel =  30,
  id_earlyStatusTransfer =  31,
  id_failureIndication =  32,
  id_handoverReport =  33,
  id_resourceStatusReportingInitiation =  34,
  id_resourceStatusReporting =  35,
  id_mobilitySettingsChange =  36,
  id_accessAndMobilityIndication =  37,
  id_cellTrafficTrace =  38,
  id_RANMulticastGroupPaging =  39,
  id_scgFailureInformationReport =  40,
  id_ProcedureCode41_NotToBeUsed =  41,
  id_scgFailureTransfer =  42,
  id_f1CTrafficTransfer =  43,
  id_iABTransportMigrationManagement =  44,
  id_iABTransportMigrationModification =  45,
  id_iABResourceCoordination =  46,
  id_retrieveUEContextConfirm =  47,
  id_cPCCancel =  48,
  id_partialUEContextTransfer =  49,
  id_rachIndication =  50,
  id_dataCollectionReportingInitiation =  51,
  id_dataCollectionReporting =  52
} ProcedureCode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_ActivatedServedCells =   0,
  id_ActivationIDforCellActivation =   1,
  id_admittedSplitSRB =   2,
  id_admittedSplitSRBrelease =   3,
  id_AMF_Region_Information =   4,
  id_AssistanceDataForRANPaging =   5,
  id_BearersSubjectToCounterCheck =   6,
  id_Cause     =   7,
  id_cellAssistanceInfo_NR =   8,
  id_ConfigurationUpdateInitiatingNodeChoice =   9,
  id_CriticalityDiagnostics =  10,
  id_XnUAddressInfoperPDUSession_List =  11,
  id_DRBsSubjectToStatusTransfer_List =  12,
  id_ExpectedUEBehaviour =  13,
  id_GlobalNG_RAN_node_ID =  14,
  id_GUAMI     =  15,
  id_indexToRatFrequSelectionPriority =  16,
  id_initiatingNodeType_ResourceCoordRequest =  17,
  id_List_of_served_cells_E_UTRA =  18,
  id_List_of_served_cells_NR =  19,
  id_LocationReportingInformation =  20,
  id_MAC_I     =  21,
  id_MaskedIMEISV =  22,
  id_M_NG_RANnodeUEXnAPID =  23,
  id_MN_to_SN_Container =  24,
  id_MobilityRestrictionList =  25,
  id_new_NG_RAN_Cell_Identity =  26,
  id_newNG_RANnodeUEXnAPID =  27,
  id_UEReportRRCTransfer =  28,
  id_oldNG_RANnodeUEXnAPID =  29,
  id_OldtoNewNG_RANnodeResumeContainer =  30,
  id_PagingDRX =  31,
  id_PCellID   =  32,
  id_PDCPChangeIndication =  33,
  id_PDUSessionAdmittedAddedAddReqAck =  34,
  id_PDUSessionAdmittedModSNModConfirm =  35,
  id_PDUSessionAdmitted_SNModResponse =  36,
  id_PDUSessionNotAdmittedAddReqAck =  37,
  id_PDUSessionNotAdmitted_SNModResponse =  38,
  id_PDUSessionReleasedList_RelConf =  39,
  id_PDUSessionReleasedSNModConfirm =  40,
  id_PDUSessionResourcesActivityNotifyList =  41,
  id_PDUSessionResourcesAdmitted_List =  42,
  id_PDUSessionResourcesNotAdmitted_List =  43,
  id_PDUSessionResourcesNotifyList =  44,
  id_PDUSession_SNChangeConfirm_List =  45,
  id_PDUSession_SNChangeRequired_List =  46,
  id_PDUSessionToBeAddedAddReq =  47,
  id_PDUSessionToBeModifiedSNModRequired =  48,
  id_PDUSessionToBeReleasedList_RelRqd =  49,
  id_PDUSessionToBeReleased_RelReq =  50,
  id_PDUSessionToBeReleasedSNModRequired =  51,
  id_RANPagingArea =  52,
  id_PagingPriority =  53,
  id_requestedSplitSRB =  54,
  id_requestedSplitSRBrelease =  55,
  id_ResetRequestTypeInfo =  56,
  id_ResetResponseTypeInfo =  57,
  id_RespondingNodeTypeConfigUpdateAck =  58,
  id_respondingNodeType_ResourceCoordResponse =  59,
  id_ResponseInfo_ReconfCompl =  60,
  id_RRCConfigIndication =  61,
  id_RRCResumeCause =  62,
  id_SCGConfigurationQuery =  63,
  id_selectedPLMN =  64,
  id_ServedCellsToActivate =  65,
  id_servedCellsToUpdate_E_UTRA =  66,
  id_ServedCellsToUpdateInitiatingNodeChoice =  67,
  id_servedCellsToUpdate_NR =  68,
  id_s_ng_RANnode_SecurityKey =  69,
  id_S_NG_RANnodeUE_AMBR =  70,
  id_S_NG_RANnodeUEXnAPID =  71,
  id_SN_to_MN_Container =  72,
  id_sourceNG_RANnodeUEXnAPID =  73,
  id_SplitSRB_RRCTransfer =  74,
  id_TAISupport_list =  75,
  id_TimeToWait =  76,
  id_Target2SourceNG_RANnodeTranspContainer =  77,
  id_targetCellGlobalID =  78,
  id_targetNG_RANnodeUEXnAPID =  79,
  id_target_S_NG_RANnodeID =  80,
  id_TraceActivation =  81,
  id_UEContextID =  82,
  id_UEContextInfoHORequest =  83,
  id_UEContextInfoRetrUECtxtResp =  84,
  id_UEContextInfo_SNModRequest =  85,
  id_UEContextKeptIndicator =  86,
  id_UEContextRefAtSN_HORequest =  87,
  id_UEHistoryInformation =  88,
  id_UEIdentityIndexValue =  89,
  id_UERANPagingIdentity =  90,
  id_UESecurityCapabilities =  91,
  id_UserPlaneTrafficActivityReport =  92,
  id_XnRemovalThreshold =  93,
  id_DesiredActNotificationLevel =  94,
  id_AvailableDRBIDs =  95,
  id_AdditionalDRBIDs =  96,
  id_SpareDRBIDs =  97,
  id_RequiredNumberOfDRBIDs =  98,
  id_TNLA_To_Add_List =  99,
  id_TNLA_To_Update_List = 100,
  id_TNLA_To_Remove_List = 101,
  id_TNLA_Setup_List = 102,
  id_TNLA_Failed_To_Setup_List = 103,
  id_PDUSessionToBeReleased_RelReqAck = 104,
  id_S_NG_RANnodeMaxIPDataRate_UL = 105,
  id_Unknown_106 = 106,
  id_PDUSessionResourceSecondaryRATUsageList = 107,
  id_Additional_UL_NG_U_TNLatUPF_List = 108,
  id_SecondarydataForwardingInfoFromTarget_List = 109,
  id_LocationInformationSNReporting = 110,
  id_LocationInformationSN = 111,
  id_LastE_UTRANPLMNIdentity = 112,
  id_S_NG_RANnodeMaxIPDataRate_DL = 113,
  id_MaxIPrate_DL = 114,
  id_SecurityResult = 115,
  id_S_NSSAI   = 116,
  id_MR_DC_ResourceCoordinationInfo = 117,
  id_AMF_Region_Information_To_Add = 118,
  id_AMF_Region_Information_To_Delete = 119,
  id_OldQoSFlowMap_ULendmarkerexpected = 120,
  id_RANPagingFailure = 121,
  id_UERadioCapabilityForPaging = 122,
  id_PDUSessionDataForwarding_SNModResponse = 123,
  id_DRBsNotAdmittedSetupModifyList = 124,
  id_Secondary_MN_Xn_U_TNLInfoatM = 125,
  id_NE_DC_TDM_Pattern = 126,
  id_PDUSessionCommonNetworkInstance = 127,
  id_BPLMN_ID_Info_EUTRA = 128,
  id_BPLMN_ID_Info_NR = 129,
  id_InterfaceInstanceIndication = 130,
  id_S_NG_RANnode_Addition_Trigger_Ind = 131,
  id_DefaultDRB_Allowed = 132,
  id_DRB_IDs_takenintouse = 133,
  id_SplitSessionIndicator = 134,
  id_CNTypeRestrictionsForEquivalent = 135,
  id_CNTypeRestrictionsForServing = 136,
  id_DRBs_transferred_to_MN = 137,
  id_ULForwardingProposal = 138,
  id_EndpointIPAddressAndPort = 139,
  id_IntendedTDD_DL_ULConfiguration_NR = 140,
  id_TNLConfigurationInfo = 141,
  id_PartialListIndicator_NR = 142,
  id_MessageOversizeNotification = 143,
  id_CellAndCapacityAssistanceInfo_NR = 144,
  id_NG_RANTraceID = 145,
  id_NonGBRResources_Offered = 146,
  id_FastMCGRecoveryRRCTransfer_SN_to_MN = 147,
  id_RequestedFastMCGRecoveryViaSRB3 = 148,
  id_AvailableFastMCGRecoveryViaSRB3 = 149,
  id_RequestedFastMCGRecoveryViaSRB3Release = 150,
  id_ReleaseFastMCGRecoveryViaSRB3 = 151,
  id_FastMCGRecoveryRRCTransfer_MN_to_SN = 152,
  id_ExtendedRATRestrictionInformation = 153,
  id_QoSMonitoringRequest = 154,
  id_FiveGCMobilityRestrictionListContainer = 155,
  id_PartialListIndicator_EUTRA = 156,
  id_CellAndCapacityAssistanceInfo_EUTRA = 157,
  id_CHOinformation_Req = 158,
  id_CHOinformation_Ack = 159,
  id_targetCellsToCancel = 160,
  id_requestedTargetCellGlobalID = 161,
  id_procedureStage = 162,
  id_DAPSRequestInfo = 163,
  id_DAPSResponseInfo_List = 164,
  id_CHO_MRDC_Indicator = 165,
  id_OffsetOfNbiotChannelNumberToDL_EARFCN = 166,
  id_OffsetOfNbiotChannelNumberToUL_EARFCN = 167,
  id_NBIoT_UL_DL_AlignmentOffset = 168,
  id_LTEV2XServicesAuthorized = 169,
  id_NRV2XServicesAuthorized = 170,
  id_LTEUESidelinkAggregateMaximumBitRate = 171,
  id_NRUESidelinkAggregateMaximumBitRate = 172,
  id_PC5QoSParameters = 173,
  id_AlternativeQoSParaSetList = 174,
  id_CurrentQoSParaSetIndex = 175,
  id_MobilityInformation = 176,
  id_InitiatingCondition_FailureIndication = 177,
  id_UEHistoryInformationFromTheUE = 178,
  id_HandoverReportType = 179,
  id_HandoverCause = 180,
  id_SourceCellCGI = 181,
  id_TargetCellCGI = 182,
  id_ReEstablishmentCellCGI = 183,
  id_TargetCellinEUTRAN = 184,
  id_SourceCellCRNTI = 185,
  id_UERLFReportContainer = 186,
  id_NGRAN_Node1_Measurement_ID = 187,
  id_NGRAN_Node2_Measurement_ID = 188,
  id_RegistrationRequest = 189,
  id_ReportCharacteristics = 190,
  id_CellToReport = 191,
  id_ReportingPeriodicity = 192,
  id_CellMeasurementResult = 193,
  id_NG_RANnode1CellID = 194,
  id_NG_RANnode2CellID = 195,
  id_NG_RANnode1MobilityParameters = 196,
  id_NG_RANnode2ProposedMobilityParameters = 197,
  id_MobilityParametersModificationRange = 198,
  id_TDDULDLConfigurationCommonNR = 199,
  id_CarrierList = 200,
  id_ULCarrierList = 201,
  id_FrequencyShift7p5khz = 202,
  id_SSB_PositionsInBurst = 203,
  id_NRCellPRACHConfig = 204,
  id_RAReport  = 205,
  id_IABNodeIndication = 206,
  id_Redundant_UL_NG_U_TNLatUPF = 207,
  id_CNPacketDelayBudgetDownlink = 208,
  id_CNPacketDelayBudgetUplink = 209,
  id_Additional_Redundant_UL_NG_U_TNLatUPF_List = 210,
  id_RedundantCommonNetworkInstance = 211,
  id_TSCTrafficCharacteristics = 212,
  id_RedundantQoSFlowIndicator = 213,
  id_Redundant_DL_NG_U_TNLatNG_RAN = 214,
  id_ExtendedPacketDelayBudget = 215,
  id_Additional_PDCP_Duplication_TNL_List = 216,
  id_RedundantPDUSessionInformation = 217,
  id_UsedRSNInformation = 218,
  id_RLCDuplicationInformation = 219,
  id_NPN_Broadcast_Information = 220,
  id_NPNPagingAssistanceInformation = 221,
  id_NPNMobilityInformation = 222,
  id_NPN_Support = 223,
  id_MDT_Configuration = 224,
  id_MDTPLMNList = 225,
  id_TraceCollectionEntityURI = 226,
  id_UERadioCapabilityID = 227,
  id_CSI_RSTransmissionIndication = 228,
  id_SNTriggered = 229,
  id_DLCarrierList = 230,
  id_ExtendedTAISliceSupportList = 231,
  id_cellAssistanceInfo_EUTRA = 232,
  id_ConfiguredTACIndication = 233,
  id_secondary_SN_UL_PDCP_UP_TNLInfo = 234,
  id_pdcpDuplicationConfiguration = 235,
  id_duplicationActivation = 236,
  id_NPRACHConfiguration = 237,
  id_QosMonitoringReportingFrequency = 238,
  id_QoSFlowsMappedtoDRB_SetupResponse_MNterminated = 239,
  id_DL_scheduling_PDCCH_CCE_usage = 240,
  id_UL_scheduling_PDCCH_CCE_usage = 241,
  id_SFN_Offset = 242,
  id_QoSMonitoringDisabled = 243,
  id_ExtendedUEIdentityIndexValue = 244,
  id_EUTRAPagingeDRXInformation = 245,
  id_CHO_MRDC_EarlyDataForwarding = 246,
  id_SCGIndicator = 247,
  id_UESpecificDRX = 248,
  id_PDUSessionExpectedUEActivityBehaviour = 249,
  id_QoS_Mapping_Information = 250,
  id_AdditionLocationInformation = 251,
  id_dataForwardingInfoFromTargetE_UTRANnode = 252,
  id_DirectForwardingPathAvailability = 253,
  id_SourceNG_RAN_node_ID = 254,
  id_SourceDLForwardingIPAddress = 255,
  id_SourceNodeDLForwardingIPAddress = 256,
  id_ExtendedReportIntervalMDT = 257,
  id_SecurityIndication = 258,
  id_RRCConnReestab_Indicator = 259,
  id_TargetNodeID = 260,
  id_ManagementBasedMDTPLMNList = 261,
  id_PrivacyIndicator = 262,
  id_TraceCollectionEntityIPAddress = 263,
  id_M4ReportAmount = 264,
  id_M5ReportAmount = 265,
  id_M6ReportAmount = 266,
  id_M7ReportAmount = 267,
  id_BeamMeasurementIndicationM1 = 268,
  id_MBS_Session_ID = 269,
  id_UEIdentityIndexList_MBSGroupPaging = 270,
  id_MulticastRANPagingArea = 271,
  id_Supported_MBS_FSA_ID_List = 272,
  id_MBS_SessionInformation_List = 273,
  id_MBS_SessionInformationResponse_List = 274,
  id_MBS_SessionAssociatedInformation = 275,
  id_SuccessfulHOReportInformation = 276,
  id_SliceRadioResourceStatus_List = 277,
  id_CompositeAvailableCapacitySupplementaryUplink = 278,
  id_SCGUEHistoryInformation = 279,
  id_SSBOffsets_List = 280,
  id_NG_RANnode2SSBOffsetModificationRange = 281,
  id_Coverage_Modification_List = 282,
  id_NR_U_Channel_List = 283,
  id_SourcePSCellCGI = 284,
  id_FailedPSCellCGI = 285,
  id_SCGFailureReportContainer = 286,
  id_SNMobilityInformation = 287,
  id_SourcePSCellID = 288,
  id_SuitablePSCellCGI = 289,
  id_PSCellChangeHistory = 290,
  id_CHOConfiguration = 291,
  id_NR_U_ChannelInfo_List = 292,
  id_PSCellHistoryInformationRetrieve = 293,
  id_NG_RANnode2SSBOffsetsModificationRange = 294,
  id_MIMOPRBusageInformation = 295,
  id_F1CTrafficContainer = 296,
  id_IAB_MT_Cell_List = 297,
  id_NoPDUSessionIndication = 298,
  id_IAB_TNL_Address_Request = 299,
  id_IAB_TNL_Address_Response = 300,
  id_TrafficToBeAddedList = 301,
  id_TrafficToBeModifiedList = 302,
  id_TrafficToBeReleaseInformation = 303,
  id_TrafficAddedList = 304,
  id_TrafficModifiedList = 305,
  id_TrafficNotAddedList = 306,
  id_TrafficNotModifiedList = 307,
  id_TrafficRequiredToBeModifiedList = 308,
  id_TrafficRequiredModifiedList = 309,
  id_TrafficReleasedList = 310,
  id_IABTNLAddressToBeAdded = 311,
  id_IABTNLAddressToBeReleasedList = 312,
  id_nonF1_Terminating_IAB_DonorUEXnAPID = 313,
  id_F1_Terminating_IAB_DonorUEXnAPID = 314,
  id_BoundaryNodeCellsList = 315,
  id_ParentNodeCellsList = 316,
  id_tdd_GNB_DU_Cell_Resource_Configuration = 317,
  id_UL_GNB_DU_Cell_Resource_Configuration = 318,
  id_DL_GNB_DU_Cell_Resource_Configuration = 319,
  id_permutation = 320,
  id_IABTNLAddressException = 321,
  id_CHOinformation_AddReq = 322,
  id_CHOinformation_ModReq = 323,
  id_SurvivalTime = 324,
  id_TimeSynchronizationAssistanceInformation = 325,
  id_SCGActivationRequest = 326,
  id_SCGActivationStatus = 327,
  id_CPAInformationRequest = 328,
  id_CPAInformationAck = 329,
  id_CPCInformationRequired = 330,
  id_CPCInformationConfirm = 331,
  id_CPAInformationModReq = 332,
  id_CPAInformationModReqAck = 333,
  id_CPC_DataForwarding_Indicator = 334,
  id_CPCInformationUpdate = 335,
  id_CPACInformationModRequired = 336,
  id_QMCConfigInfo = 337,
  id_ProtocolIE_ID338_NotToBeUsed = 338,
  id_Additional_Measurement_Timing_Configuration_List = 339,
  id_PDUSession_PairID = 340,
  id_Local_NG_RAN_Node_Identifier = 341,
  id_Neighbour_NG_RAN_Node_List = 342,
  id_Local_NG_RAN_Node_Identifier_Removal = 343,
  id_FiveGProSeAuthorized = 344,
  id_FiveGProSePC5QoSParameters = 345,
  id_FiveGProSeUEPC5AggregateMaximumBitRate = 346,
  id_ServedCellSpecificInfoReq_NR = 347,
  id_NRPagingeDRXInformation = 348,
  id_NRPagingeDRXInformationforRRCINACTIVE = 349,
  id_Redcap_Bcast_Information = 350,
  id_SDTSupportRequest = 351,
  id_SDT_SRB_between_NewNode_OldNode = 352,
  id_SDT_Termination_Request = 353,
  id_SDTPartialUEContextInfo = 354,
  id_SDTDataForwardingDRBList = 355,
  id_PagingCause = 356,
  id_PEIPSassistanceInformation = 357,
  id_UESliceMaximumBitRateList = 358,
  id_S_NG_RANnodeUE_Slice_MBR = 359,
  id_PositioningInformation = 360,
  id_UEAssistantIdentifier = 361,
  id_ManagementBasedMDTPLMNModificationList = 362,
  id_F1_terminatingIAB_donorIndicator = 363,
  id_TAINSAGSupportList = 364,
  id_SCGreconfigNotification = 365,
  id_earlyMeasurement = 366,
  id_BeamMeasurementsReportConfiguration = 367,
  id_CoverageModificationCause = 368,
  id_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated = 369,
  id_UERLFReportContainerLTEExtension = 370,
  id_ExcessPacketDelayThresholdConfiguration = 371,
  id_HashedUEIdentityIndexValue = 372,
  id_QosFlowMappingIndication = 373,
  id_Full_and_Short_I_RNTI_Profile_List = 374,
  id_MBS_DataForwarding_Indicator = 375,
  id_IABAuthorizationStatus = 376,
  id_EquivalentSNPNs = 377,
  id_SelectedNID = 378,
  id_MT_SDT_Information = 379,
  id_PosPartialUEContextInfo = 380,
  id_SRSConfiguration = 381,
  id_CHOTimeBasedInformation = 382,
  id_ChannelOccupancyTimePercentageUL = 383,
  id_EnergyDetectionThresholdUL = 384,
  id_SuccessfulPSCellChangeReportInformation = 385,
  id_PSCellListContainer = 386,
  id_RadioResourceStatusNR_U = 387,
  id_CPACConfiguration = 388,
  id_RaReportIndicationList = 389,
  id_SPRAvailability = 390,
  id_DLLBTFailureInformationRequest = 391,
  id_DLLBTFailureInformationList = 392,
  id_TargetCellCRNTI = 393,
  id_TimeSinceFailure = 394,
  id_AerialUESubscriptionInformation = 395,
  id_LTEA2XServicesAuthorized = 396,
  id_NRA2XServicesAuthorized = 397,
  id_LTEA2XUEPC5AggregateMaximumBitRate = 398,
  id_NRA2XUEPC5AggregateMaximumBitRate = 399,
  id_A2XPC5QoSParameters = 400,
  id_CellBasedUETrajectoryPrediction = 401,
  id_DataCollectionID = 402,
  id_RequestedPredictionTime = 403,
  id_NodeMeasurementInitiationResult_List = 404,
  id_CellMeasurementInitiationResult_List = 405,
  id_UEAssociatedInfoResult_List = 406,
  id_ProtocolIE_ID_407_not_to_be_used = 407,
  id_UETrajectoryCollectionConfiguration = 408,
  id_UEPerformanceCollectionConfiguration = 409,
  id_CellMeasurementResultForDataCollection_List = 410,
  id_CellToReportForDataCollection_List = 411,
  id_FiveGProSeLayer2Multipath = 412,
  id_FiveGProSeLayer2UEtoUERelay = 413,
  id_FiveGProSeLayer2UEtoUERemote = 414,
  id_CandidateRelayUEInfoList = 415,
  id_NRCellsAndSSBsList = 416,
  id_ActivatedNRCellsAndSSBsList = 417,
  id_ClockQualityReportingControlInfo = 418,
  id_CapabilityForBATAdaptation = 419,
  id_PNI_NPN_AreaScopeofMDT = 420,
  id_PNI_NPNBasedMDT = 421,
  id_SNPN_CellBasedMDT = 422,
  id_SNPN_TAIBasedMDT = 423,
  id_SNPN_BasedMDT = 424,
  id_S_CPAC_Request = 425,
  id_S_CPAC_Request_Info = 426,
  id_S_CPAC_ReferenceConfigRequest = 427,
  id_S_CPAC_InterSN_ExecutionNotify = 428,
  id_S_CPAC_dataforwardinginfofromSource = 429,
  id_CPACcandidatePSCells_wotherInfo_list = 430,
  id_eRedcap_Bcast_Information = 431,
  id_NRPagingLongeDRXInformationforRRCINACTIVE = 432,
  id_MBS_AssistanceInformation = 433,
  id_QMCCoordinationRequest = 434,
  id_QMCCoordinationResponse = 435,
  id_QoE_Measurement_Results = 436,
  id_MBSCommServiceType = 437,
  id_AssistanceInformationQoE_Meas = 438,
  id_ProtocolIE_ID_439_not_to_be_used = 439,
  id_QoERVQoEReportingPaths = 440,
  id_Src_SN_to_Tgt_SNQMCInfoInquiry = 441,
  id_DirectForwardingPathAvailabilityWithSourceMN = 442,
  id_CHO_Maxnoof_CondReconfig = 443,
  id_accessed_PSCellID = 444,
  id_conditional_Reconfig_ToCancel_List = 445,
  id_CHOinformation_AddReqAck = 446,
  id_CHO_CPAC_Info = 447,
  id_PDUSetQoSParameters = 448,
  id_N6JitterInformation = 449,
  id_ECNMarkingorCongestionInformationReportingRequest = 450,
  id_PDUSetbasedHandlingIndicator = 451,
  id_TAISliceUnavailableCellList = 452,
  id_MobileIAB_AuthorizationStatus = 453,
  id_MIAB_MT_BAP_Address = 454,
  id_MobileIABCell = 455,
  id_sk_Counter = 456,
  id_Source_M_NG_RANnodeID = 457,
  id_S_CPAC_CompleteConfig_Indicator = 458,
  id_SourceSN_to_TargetSN_QMCInfo = 459,
  id_RegistrationRequestForDataCollection = 460,
  id_ReportCharacteristicsForDataCollection = 461,
  id_ReportingPeriodicityForDataCollection = 462,
  id_NodeAssociatedInfoResult = 463,
  id_SLPositioning_Ranging_Services_Info = 464,
  id_XR_Bcast_Information = 465,
  id_PDUSessionsListToBeReleased_UPError = 466,
  id_MaximumDataBurstVolume = 467,
  id_CPAC_Preparation_Type = 468,
  id_UserPlaneFailureIndication = 469,
  id_MN_only_MDT_collection = 470
} ProtocolIE_ID_enum;

typedef enum _GlobalNG_RANNode_ID_enum {
  GlobalNG_RANNode_ID_gNB =   0,
  GlobalNG_RANNode_ID_ng_eNB =   1,
  GlobalNG_RANNode_ID_choice_extension =   2
} GlobalNG_RANNode_ID_enum;

/* Initialize the protocol and registered fields */
static int proto_xnap;
static int hf_xnap_transportLayerAddressIPv4;
static int hf_xnap_transportLayerAddressIPv6;
static int hf_xnap_NG_RANTraceID_TraceID;
static int hf_xnap_NG_RANTraceID_TraceRecordingSessionReference;
static int hf_xnap_primaryRATRestriction_e_UTRA;
static int hf_xnap_primaryRATRestriction_nR;
static int hf_xnap_primaryRATRestriction_nR_unlicensed;
static int hf_xnap_primaryRATRestriction_nR_LEO;
static int hf_xnap_primaryRATRestriction_nR_MEO;
static int hf_xnap_primaryRATRestriction_nR_GEO;
static int hf_xnap_primaryRATRestriction_nR_OTHERSAT;
static int hf_xnap_primaryRATRestriction_e_UTRA_LEO;
static int hf_xnap_primaryRATRestriction_e_UTRA_MEO;
static int hf_xnap_primaryRATRestriction_e_UTRA_GEO;
static int hf_xnap_primaryRATRestriction_e_UTRA_OTHERSAT;
static int hf_xnap_primaryRATRestriction_reserved;
static int hf_xnap_secondaryRATRestriction_e_UTRA;
static int hf_xnap_secondaryRATRestriction_nR;
static int hf_xnap_secondaryRATRestriction_e_UTRA_unlicensed;
static int hf_xnap_secondaryRATRestriction_nR_unlicensed;
static int hf_xnap_secondaryRATRestriction_reserved;
static int hf_xnap_MDT_Location_Info_GNSS;
static int hf_xnap_MDT_Location_Info_reserved;
static int hf_xnap_MeasurementsToActivate_M1;
static int hf_xnap_MeasurementsToActivate_M2;
static int hf_xnap_MeasurementsToActivate_M3;
static int hf_xnap_MeasurementsToActivate_M4;
static int hf_xnap_MeasurementsToActivate_M5;
static int hf_xnap_MeasurementsToActivate_LoggingM1FromEventTriggered;
static int hf_xnap_MeasurementsToActivate_M6;
static int hf_xnap_MeasurementsToActivate_M7;
static int hf_xnap_ReportCharacteristics_PRBPeriodic;
static int hf_xnap_ReportCharacteristics_TNLCapacityIndPeriodic;
static int hf_xnap_ReportCharacteristics_CompositeAvailableCapacityPeriodic;
static int hf_xnap_ReportCharacteristics_NumberOfActiveUEsPeriodic;
static int hf_xnap_ReportCharacteristics_RRCconnectionsPeriodic;
static int hf_xnap_ReportCharacteristics_NR_UChannelListPeriodic;
static int hf_xnap_ReportCharacteristics_Reserved;
static int hf_xnap_ReportCharacteristicsForDataCollection_PredictedRadioResourceStatus;
static int hf_xnap_ReportCharacteristicsForDataCollection_PredictedNumberofActiveUEs;
static int hf_xnap_ReportCharacteristicsForDataCollection_PredictedRRCConnections;
static int hf_xnap_ReportCharacteristicsForDataCollection_AverageUEThroughputDL;
static int hf_xnap_ReportCharacteristicsForDataCollection_AverageUEThroughputUL;
static int hf_xnap_ReportCharacteristicsForDataCollection_AveragePacketDelay;
static int hf_xnap_ReportCharacteristicsForDataCollection_AveragePacketLossDL;
static int hf_xnap_ReportCharacteristicsForDataCollection_EnergyCost;
static int hf_xnap_ReportCharacteristicsForDataCollection_MeasuredUETrajectory;
static int hf_xnap_ReportCharacteristicsForDataCollection_Reserved;
static int hf_xnap_cellmeasurementFailedReportCharacteristics_PredictedRadioResourceStatus;
static int hf_xnap_cellmeasurementFailedReportCharacteristics_PredictedNumberofActiveUEs;
static int hf_xnap_cellmeasurementFailedReportCharacteristics_PredictedRRCConnections;
static int hf_xnap_cellmeasurementFailedReportCharacteristics_Reserved;
static int hf_xnap_nodemeasurementFailedReportCharacteristics_EnergyCost;
static int hf_xnap_nodemeasurementFailedReportCharacteristics_AverageUEThroughputDL;
static int hf_xnap_nodemeasurementFailedReportCharacteristics_AverageUEThroughputUL;
static int hf_xnap_nodemeasurementFailedReportCharacteristics_AveragePacketDelay;
static int hf_xnap_nodemeasurementFailedReportCharacteristics_AveragePacketLossDL;
static int hf_xnap_nodemeasurementFailedReportCharacteristics_MeasuredUETrajectory;
static int hf_xnap_nodemeasurementFailedReportCharacteristics_Reserved;
static int hf_xnap_A2XPC5QoSParameters_PDU;       /* A2XPC5QoSParameters */
static int hf_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_PDU;  /* AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated */
static int hf_xnap_AdditionLocationInformation_PDU;  /* AdditionLocationInformation */
static int hf_xnap_Additional_PDCP_Duplication_TNL_List_PDU;  /* Additional_PDCP_Duplication_TNL_List */
static int hf_xnap_Additional_UL_NG_U_TNLatUPF_List_PDU;  /* Additional_UL_NG_U_TNLatUPF_List */
static int hf_xnap_Additional_Measurement_Timing_Configuration_List_PDU;  /* Additional_Measurement_Timing_Configuration_List */
static int hf_xnap_ActivationIDforCellActivation_PDU;  /* ActivationIDforCellActivation */
static int hf_xnap_DataCollectionID_PDU;          /* DataCollectionID */
static int hf_xnap_AerialUESubscriptionInformation_PDU;  /* AerialUESubscriptionInformation */
static int hf_xnap_AlternativeQoSParaSetList_PDU;  /* AlternativeQoSParaSetList */
static int hf_xnap_AMF_Region_Information_PDU;    /* AMF_Region_Information */
static int hf_xnap_AssistanceDataForRANPaging_PDU;  /* AssistanceDataForRANPaging */
static int hf_xnap_AssistanceInformationQoE_Meas_PDU;  /* AssistanceInformationQoE_Meas */
static int hf_xnap_BAPAddress_PDU;                /* BAPAddress */
static int hf_xnap_BeamMeasurementIndicationM1_PDU;  /* BeamMeasurementIndicationM1 */
static int hf_xnap_BeamMeasurementsReportConfiguration_PDU;  /* BeamMeasurementsReportConfiguration */
static int hf_xnap_BPLMN_ID_Info_EUTRA_PDU;       /* BPLMN_ID_Info_EUTRA */
static int hf_xnap_BPLMN_ID_Info_NR_PDU;          /* BPLMN_ID_Info_NR */
static int hf_xnap_BitRate_PDU;                   /* BitRate */
static int hf_xnap_CandidateRelayUEInfoList_PDU;  /* CandidateRelayUEInfoList */
static int hf_xnap_Cause_PDU;                     /* Cause */
static int hf_xnap_CellAssistanceInfo_NR_PDU;     /* CellAssistanceInfo_NR */
static int hf_xnap_CellAndCapacityAssistanceInfo_NR_PDU;  /* CellAndCapacityAssistanceInfo_NR */
static int hf_xnap_CellAndCapacityAssistanceInfo_EUTRA_PDU;  /* CellAndCapacityAssistanceInfo_EUTRA */
static int hf_xnap_CellAssistanceInfo_EUTRA_PDU;  /* CellAssistanceInfo_EUTRA */
static int hf_xnap_CellMeasurementResult_PDU;     /* CellMeasurementResult */
static int hf_xnap_CellToReport_PDU;              /* CellToReport */
static int hf_xnap_CellToReportForDataCollection_List_PDU;  /* CellToReportForDataCollection_List */
static int hf_xnap_CellBasedUETrajectoryPrediction_PDU;  /* CellBasedUETrajectoryPrediction */
static int hf_xnap_CellMeasurementInitiationResult_List_PDU;  /* CellMeasurementInitiationResult_List */
static int hf_xnap_CellMeasurementResultForDataCollection_List_PDU;  /* CellMeasurementResultForDataCollection_List */
static int hf_xnap_CHOConfiguration_PDU;          /* CHOConfiguration */
static int hf_xnap_ClockQualityReportingControlInfo_PDU;  /* ClockQualityReportingControlInfo */
static int hf_xnap_CapabilityForBATAdaptation_PDU;  /* CapabilityForBATAdaptation */
static int hf_xnap_CompositeAvailableCapacity_PDU;  /* CompositeAvailableCapacity */
static int hf_xnap_CHO_MRDC_EarlyDataForwarding_PDU;  /* CHO_MRDC_EarlyDataForwarding */
static int hf_xnap_CHO_MRDC_Indicator_PDU;        /* CHO_MRDC_Indicator */
static int hf_xnap_CHOinformation_Req_PDU;        /* CHOinformation_Req */
static int hf_xnap_CHOTimeBasedInformation_PDU;   /* CHOTimeBasedInformation */
static int hf_xnap_CHOinformation_Ack_PDU;        /* CHOinformation_Ack */
static int hf_xnap_CHOinformation_AddReq_PDU;     /* CHOinformation_AddReq */
static int hf_xnap_CHOinformation_AddReqAck_PDU;  /* CHOinformation_AddReqAck */
static int hf_xnap_CHOinformation_ModReq_PDU;     /* CHOinformation_ModReq */
static int hf_xnap_CHO_Maxnoof_CondReconfig_PDU;  /* CHO_Maxnoof_CondReconfig */
static int hf_xnap_CHO_CPAC_Information_PDU;      /* CHO_CPAC_Information */
static int hf_xnap_CompleteConfig_Indicator_PDU;  /* CompleteConfig_Indicator */
static int hf_xnap_Conditional_Reconfig_List_PDU;  /* Conditional_Reconfig_List */
static int hf_xnap_ConfiguredTACIndication_PDU;   /* ConfiguredTACIndication */
static int hf_xnap_CoverageModificationCause_PDU;  /* CoverageModificationCause */
static int hf_xnap_Coverage_Modification_List_PDU;  /* Coverage_Modification_List */
static int hf_xnap_CPACcandidatePSCells_wotherInfo_list_PDU;  /* CPACcandidatePSCells_wotherInfo_list */
static int hf_xnap_CPACConfiguration_PDU;         /* CPACConfiguration */
static int hf_xnap_CPAInformationRequest_PDU;     /* CPAInformationRequest */
static int hf_xnap_CPAInformationAck_PDU;         /* CPAInformationAck */
static int hf_xnap_CPCInformationRequired_PDU;    /* CPCInformationRequired */
static int hf_xnap_CPCInformationConfirm_PDU;     /* CPCInformationConfirm */
static int hf_xnap_CPAInformationModReq_PDU;      /* CPAInformationModReq */
static int hf_xnap_CPAInformationModReqAck_PDU;   /* CPAInformationModReqAck */
static int hf_xnap_CPC_DataForwarding_Indicator_PDU;  /* CPC_DataForwarding_Indicator */
static int hf_xnap_CPAC_Preparation_Type_PDU;     /* CPAC_Preparation_Type */
static int hf_xnap_CPACInformationModRequired_PDU;  /* CPACInformationModRequired */
static int hf_xnap_CPCInformationUpdate_PDU;      /* CPCInformationUpdate */
static int hf_xnap_CriticalityDiagnostics_PDU;    /* CriticalityDiagnostics */
static int hf_xnap_C_RNTI_PDU;                    /* C_RNTI */
static int hf_xnap_CSI_RSTransmissionIndication_PDU;  /* CSI_RSTransmissionIndication */
static int hf_xnap_XnUAddressInfoperPDUSession_List_PDU;  /* XnUAddressInfoperPDUSession_List */
static int hf_xnap_DataForwardingInfoFromTargetE_UTRANnode_PDU;  /* DataForwardingInfoFromTargetE_UTRANnode */
static int hf_xnap_DataforwardingandOffloadingInfofromSource_PDU;  /* DataforwardingandOffloadingInfofromSource */
static int hf_xnap_DAPSRequestInfo_PDU;           /* DAPSRequestInfo */
static int hf_xnap_DAPSResponseInfo_List_PDU;     /* DAPSResponseInfo_List */
static int hf_xnap_DesiredActNotificationLevel_PDU;  /* DesiredActNotificationLevel */
static int hf_xnap_DefaultDRB_Allowed_PDU;        /* DefaultDRB_Allowed */
static int hf_xnap_DirectForwardingPathAvailability_PDU;  /* DirectForwardingPathAvailability */
static int hf_xnap_DirectForwardingPathAvailabilityWithSourceMN_PDU;  /* DirectForwardingPathAvailabilityWithSourceMN */
static int hf_xnap_DLLBTFailureInformationRequest_PDU;  /* DLLBTFailureInformationRequest */
static int hf_xnap_DLLBTFailureInformationList_PDU;  /* DLLBTFailureInformationList */
static int hf_xnap_DRB_List_PDU;                  /* DRB_List */
static int hf_xnap_DRB_List_withCause_PDU;        /* DRB_List_withCause */
static int hf_xnap_DRB_Number_PDU;                /* DRB_Number */
static int hf_xnap_DRBsSubjectToStatusTransfer_List_PDU;  /* DRBsSubjectToStatusTransfer_List */
static int hf_xnap_DuplicationActivation_PDU;     /* DuplicationActivation */
static int hf_xnap_EarlyMeasurement_PDU;          /* EarlyMeasurement */
static int hf_xnap_ECNMarkingorCongestionInformationReportingRequest_PDU;  /* ECNMarkingorCongestionInformationReportingRequest */
static int hf_xnap_EquivalentSNPNs_PDU;           /* EquivalentSNPNs */
static int hf_xnap_ERedcap_Bcast_Information_PDU;  /* ERedcap_Bcast_Information */
static int hf_xnap_EUTRAPagingeDRXInformation_PDU;  /* EUTRAPagingeDRXInformation */
static int hf_xnap_EndpointIPAddressAndPort_PDU;  /* EndpointIPAddressAndPort */
static int hf_xnap_ExcessPacketDelayThresholdConfiguration_PDU;  /* ExcessPacketDelayThresholdConfiguration */
static int hf_xnap_ExpectedUEActivityBehaviour_PDU;  /* ExpectedUEActivityBehaviour */
static int hf_xnap_ExpectedUEBehaviour_PDU;       /* ExpectedUEBehaviour */
static int hf_xnap_ExtendedRATRestrictionInformation_PDU;  /* ExtendedRATRestrictionInformation */
static int hf_xnap_ExtendedPacketDelayBudget_PDU;  /* ExtendedPacketDelayBudget */
static int hf_xnap_ExtendedSliceSupportList_PDU;  /* ExtendedSliceSupportList */
static int hf_xnap_ExtendedUEIdentityIndexValue_PDU;  /* ExtendedUEIdentityIndexValue */
static int hf_xnap_F1CTrafficContainer_PDU;       /* F1CTrafficContainer */
static int hf_xnap_F1_terminatingIAB_donorIndicator_PDU;  /* F1_terminatingIAB_donorIndicator */
static int hf_xnap_FiveGCMobilityRestrictionListContainer_PDU;  /* FiveGCMobilityRestrictionListContainer */
static int hf_xnap_FiveGProSeAuthorized_PDU;      /* FiveGProSeAuthorized */
static int hf_xnap_FiveGProSeLayer2Multipath_PDU;  /* FiveGProSeLayer2Multipath */
static int hf_xnap_FiveGProSeLayer2UEtoUERelay_PDU;  /* FiveGProSeLayer2UEtoUERelay */
static int hf_xnap_FiveGProSeLayer2UEtoUERemote_PDU;  /* FiveGProSeLayer2UEtoUERemote */
static int hf_xnap_FiveGProSePC5QoSParameters_PDU;  /* FiveGProSePC5QoSParameters */
static int hf_xnap_FrequencyShift7p5khz_PDU;      /* FrequencyShift7p5khz */
static int hf_xnap_GNB_DU_Cell_Resource_Configuration_PDU;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_GlobalCell_ID_PDU;             /* GlobalCell_ID */
static int hf_xnap_GlobalNG_RANCell_ID_PDU;       /* GlobalNG_RANCell_ID */
static int hf_xnap_GlobalNG_RANNode_ID_PDU;       /* GlobalNG_RANNode_ID */
static int hf_xnap_GUAMI_PDU;                     /* GUAMI */
static int hf_xnap_HandoverReportType_PDU;        /* HandoverReportType */
static int hf_xnap_HashedUEIdentityIndexValue_PDU;  /* HashedUEIdentityIndexValue */
static int hf_xnap_IABNodeIndication_PDU;         /* IABNodeIndication */
static int hf_xnap_IAB_TNL_Address_Request_PDU;   /* IAB_TNL_Address_Request */
static int hf_xnap_IAB_TNL_Address_Response_PDU;  /* IAB_TNL_Address_Response */
static int hf_xnap_IABTNLAddressException_PDU;    /* IABTNLAddressException */
static int hf_xnap_InitiatingCondition_FailureIndication_PDU;  /* InitiatingCondition_FailureIndication */
static int hf_xnap_xnap_IntendedTDD_DL_ULConfiguration_NR_PDU;  /* IntendedTDD_DL_ULConfiguration_NR */
static int hf_xnap_InterfaceInstanceIndication_PDU;  /* InterfaceInstanceIndication */
static int hf_xnap_IABAuthorizationStatus_PDU;    /* IABAuthorizationStatus */
static int hf_xnap_Local_NG_RAN_Node_Identifier_PDU;  /* Local_NG_RAN_Node_Identifier */
static int hf_xnap_Full_and_Short_I_RNTI_Profile_List_PDU;  /* Full_and_Short_I_RNTI_Profile_List */
static int hf_xnap_SCGUEHistoryInformation_PDU;   /* SCGUEHistoryInformation */
static int hf_xnap_LocationInformationSNReporting_PDU;  /* LocationInformationSNReporting */
static int hf_xnap_LocationReportingInformation_PDU;  /* LocationReportingInformation */
static int hf_xnap_LTEA2XServicesAuthorized_PDU;  /* LTEA2XServicesAuthorized */
static int hf_xnap_LTEV2XServicesAuthorized_PDU;  /* LTEV2XServicesAuthorized */
static int hf_xnap_LTEUESidelinkAggregateMaximumBitRate_PDU;  /* LTEUESidelinkAggregateMaximumBitRate */
static int hf_xnap_MBSCommServiceType_PDU;        /* MBSCommServiceType */
static int hf_xnap_M4ReportAmountMDT_PDU;         /* M4ReportAmountMDT */
static int hf_xnap_M5ReportAmountMDT_PDU;         /* M5ReportAmountMDT */
static int hf_xnap_M6ReportAmountMDT_PDU;         /* M6ReportAmountMDT */
static int hf_xnap_M7ReportAmountMDT_PDU;         /* M7ReportAmountMDT */
static int hf_xnap_MAC_I_PDU;                     /* MAC_I */
static int hf_xnap_MaskedIMEISV_PDU;              /* MaskedIMEISV */
static int hf_xnap_MaximumDataBurstVolume_PDU;    /* MaximumDataBurstVolume */
static int hf_xnap_MaxIPrate_PDU;                 /* MaxIPrate */
static int hf_xnap_MBS_DataForwarding_Indicator_PDU;  /* MBS_DataForwarding_Indicator */
static int hf_xnap_MBS_Session_ID_PDU;            /* MBS_Session_ID */
static int hf_xnap_MBS_AssistanceInformation_PDU;  /* MBS_AssistanceInformation */
static int hf_xnap_MBS_SessionAssociatedInformation_PDU;  /* MBS_SessionAssociatedInformation */
static int hf_xnap_MBS_SessionInformation_List_PDU;  /* MBS_SessionInformation_List */
static int hf_xnap_MBS_SessionInformationResponse_List_PDU;  /* MBS_SessionInformationResponse_List */
static int hf_xnap_MDT_Configuration_PDU;         /* MDT_Configuration */
static int hf_xnap_MN_only_MDT_collection_PDU;    /* MN_only_MDT_collection */
static int hf_xnap_MDTPLMNList_PDU;               /* MDTPLMNList */
static int hf_xnap_MDTPLMNModificationList_PDU;   /* MDTPLMNModificationList */
static int hf_xnap_Measurement_ID_PDU;            /* Measurement_ID */
static int hf_xnap_MIMOPRBusageInformation_PDU;   /* MIMOPRBusageInformation */
static int hf_xnap_MobileIAB_AuthorizationStatus_PDU;  /* MobileIAB_AuthorizationStatus */
static int hf_xnap_MobileIABCell_PDU;             /* MobileIABCell */
static int hf_xnap_MobilityInformation_PDU;       /* MobilityInformation */
static int hf_xnap_MobilityParametersModificationRange_PDU;  /* MobilityParametersModificationRange */
static int hf_xnap_MobilityParametersInformation_PDU;  /* MobilityParametersInformation */
static int hf_xnap_MobilityRestrictionList_PDU;   /* MobilityRestrictionList */
static int hf_xnap_CNTypeRestrictionsForEquivalent_PDU;  /* CNTypeRestrictionsForEquivalent */
static int hf_xnap_CNTypeRestrictionsForServing_PDU;  /* CNTypeRestrictionsForServing */
static int hf_xnap_MR_DC_ResourceCoordinationInfo_PDU;  /* MR_DC_ResourceCoordinationInfo */
static int hf_xnap_MessageOversizeNotification_PDU;  /* MessageOversizeNotification */
static int hf_xnap_MT_SDT_Information_PDU;        /* MT_SDT_Information */
static int hf_xnap_N6JitterInformation_PDU;       /* N6JitterInformation */
static int hf_xnap_NBIoT_UL_DL_AlignmentOffset_PDU;  /* NBIoT_UL_DL_AlignmentOffset */
static int hf_xnap_NE_DC_TDM_Pattern_PDU;         /* NE_DC_TDM_Pattern */
static int hf_xnap_Neighbour_NG_RAN_Node_List_PDU;  /* Neighbour_NG_RAN_Node_List */
static int hf_xnap_NID_PDU;                       /* NID */
static int hf_xnap_NRCarrierList_PDU;             /* NRCarrierList */
static int hf_xnap_NRCellPRACHConfig_PDU;         /* NRCellPRACHConfig */
static int hf_xnap_NG_RAN_Cell_Identity_PDU;      /* NG_RAN_Cell_Identity */
static int hf_xnap_NG_RANnode2SSBOffsetsModificationRange_PDU;  /* NG_RANnode2SSBOffsetsModificationRange */
static int hf_xnap_NG_RANnodeUEXnAPID_PDU;        /* NG_RANnodeUEXnAPID */
static int hf_xnap_NodeAssociatedInfoResult_PDU;  /* NodeAssociatedInfoResult */
static int hf_xnap_NodeMeasurementInitiationResult_List_PDU;  /* NodeMeasurementInitiationResult_List */
static int hf_xnap_DL_scheduling_PDCCH_CCE_usage_PDU;  /* DL_scheduling_PDCCH_CCE_usage */
static int hf_xnap_UL_scheduling_PDCCH_CCE_usage_PDU;  /* UL_scheduling_PDCCH_CCE_usage */
static int hf_xnap_NoPDUSessionIndication_PDU;    /* NoPDUSessionIndication */
static int hf_xnap_NPN_Broadcast_Information_PDU;  /* NPN_Broadcast_Information */
static int hf_xnap_NPNMobilityInformation_PDU;    /* NPNMobilityInformation */
static int hf_xnap_NPNPagingAssistanceInformation_PDU;  /* NPNPagingAssistanceInformation */
static int hf_xnap_NPN_Support_PDU;               /* NPN_Support */
static int hf_xnap_NPRACHConfiguration_PDU;       /* NPRACHConfiguration */
static int hf_xnap_NR_CGI_PDU;                    /* NR_CGI */
static int hf_xnap_NR_U_Channel_List_PDU;         /* NR_U_Channel_List */
static int hf_xnap_ChannelOccupancyTimePercentage_PDU;  /* ChannelOccupancyTimePercentage */
static int hf_xnap_EnergyDetectionThreshold_PDU;  /* EnergyDetectionThreshold */
static int hf_xnap_NR_U_ChannelInfo_List_PDU;     /* NR_U_ChannelInfo_List */
static int hf_xnap_NRA2XServicesAuthorized_PDU;   /* NRA2XServicesAuthorized */
static int hf_xnap_NRPagingeDRXInformation_PDU;   /* NRPagingeDRXInformation */
static int hf_xnap_NRPagingeDRXInformationforRRCINACTIVE_PDU;  /* NRPagingeDRXInformationforRRCINACTIVE */
static int hf_xnap_NRPagingLongeDRXInformationforRRCINACTIVE_PDU;  /* NRPagingLongeDRXInformationforRRCINACTIVE */
static int hf_xnap_NG_RANTraceID_PDU;             /* NG_RANTraceID */
static int hf_xnap_NonGBRResources_Offered_PDU;   /* NonGBRResources_Offered */
static int hf_xnap_NRV2XServicesAuthorized_PDU;   /* NRV2XServicesAuthorized */
static int hf_xnap_NRUESidelinkAggregateMaximumBitRate_PDU;  /* NRUESidelinkAggregateMaximumBitRate */
static int hf_xnap_OffsetOfNbiotChannelNumberToEARFCN_PDU;  /* OffsetOfNbiotChannelNumberToEARFCN */
static int hf_xnap_PositioningInformation_PDU;    /* PositioningInformation */
static int hf_xnap_PagingCause_PDU;               /* PagingCause */
static int hf_xnap_PEIPSassistanceInformation_PDU;  /* PEIPSassistanceInformation */
static int hf_xnap_PagingDRX_PDU;                 /* PagingDRX */
static int hf_xnap_PagingPriority_PDU;            /* PagingPriority */
static int hf_xnap_PartialListIndicator_PDU;      /* PartialListIndicator */
static int hf_xnap_PC5QoSParameters_PDU;          /* PC5QoSParameters */
static int hf_xnap_PDCPChangeIndication_PDU;      /* PDCPChangeIndication */
static int hf_xnap_PDCPDuplicationConfiguration_PDU;  /* PDCPDuplicationConfiguration */
static int hf_xnap_PDUSetQoSParameters_PDU;       /* PDUSetQoSParameters */
static int hf_xnap_PDUSetbasedHandlingIndicator_PDU;  /* PDUSetbasedHandlingIndicator */
static int hf_xnap_PDUSession_List_withCause_PDU;  /* PDUSession_List_withCause */
static int hf_xnap_PDUSessionsListToBeReleased_UPError_PDU;  /* PDUSessionsListToBeReleased_UPError */
static int hf_xnap_PDUSessionResourcesAdmitted_List_PDU;  /* PDUSessionResourcesAdmitted_List */
static int hf_xnap_PDUSessionResourcesNotAdmitted_List_PDU;  /* PDUSessionResourcesNotAdmitted_List */
static int hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_PDU;  /* QoSFlowsMappedtoDRB_SetupResponse_MNterminated */
static int hf_xnap_PDUSessionResourceSecondaryRATUsageList_PDU;  /* PDUSessionResourceSecondaryRATUsageList */
static int hf_xnap_PDUSessionCommonNetworkInstance_PDU;  /* PDUSessionCommonNetworkInstance */
static int hf_xnap_PDUSession_PairID_PDU;         /* PDUSession_PairID */
static int hf_xnap_Permutation_PDU;               /* Permutation */
static int hf_xnap_PLMN_Identity_PDU;             /* PLMN_Identity */
static int hf_xnap_PosPartialUEContextInfo_PDU;   /* PosPartialUEContextInfo */
static int hf_xnap_PrivacyIndicator_PDU;          /* PrivacyIndicator */
static int hf_xnap_PSCellChangeHistory_PDU;       /* PSCellChangeHistory */
static int hf_xnap_PSCellHistoryInformationRetrieve_PDU;  /* PSCellHistoryInformationRetrieve */
static int hf_xnap_PSCellListContainer_PDU;       /* PSCellListContainer */
static int hf_xnap_PNI_NPN_AreaScopeofMDT_PDU;    /* PNI_NPN_AreaScopeofMDT */
static int hf_xnap_PNI_NPNBasedMDT_PDU;           /* PNI_NPNBasedMDT */
static int hf_xnap_QMCConfigInfo_PDU;             /* QMCConfigInfo */
static int hf_xnap_QMCCoordinationRequest_PDU;    /* QMCCoordinationRequest */
static int hf_xnap_QMCCoordinationResponse_PDU;   /* QMCCoordinationResponse */
static int hf_xnap_QoERVQoEReportingPaths_PDU;    /* QoERVQoEReportingPaths */
static int hf_xnap_QoSFlowMappingIndication_PDU;  /* QoSFlowMappingIndication */
static int hf_xnap_QoSFlows_List_PDU;             /* QoSFlows_List */
static int hf_xnap_QoS_Mapping_Information_PDU;   /* QoS_Mapping_Information */
static int hf_xnap_QoSParaSetNotifyIndex_PDU;     /* QoSParaSetNotifyIndex */
static int hf_xnap_QosMonitoringRequest_PDU;      /* QosMonitoringRequest */
static int hf_xnap_QoSMonitoringDisabled_PDU;     /* QoSMonitoringDisabled */
static int hf_xnap_QosMonitoringReportingFrequency_PDU;  /* QosMonitoringReportingFrequency */
static int hf_xnap_RAReport_PDU;                  /* RAReport */
static int hf_xnap_RANPagingArea_PDU;             /* RANPagingArea */
static int hf_xnap_RANPagingFailure_PDU;          /* RANPagingFailure */
static int hf_xnap_Redcap_Bcast_Information_PDU;  /* Redcap_Bcast_Information */
static int hf_xnap_RedundantQoSFlowIndicator_PDU;  /* RedundantQoSFlowIndicator */
static int hf_xnap_RedundantPDUSessionInformation_PDU;  /* RedundantPDUSessionInformation */
static int hf_xnap_ExtendedReportIntervalMDT_PDU;  /* ExtendedReportIntervalMDT */
static int hf_xnap_ReportCharacteristics_PDU;     /* ReportCharacteristics */
static int hf_xnap_ReportCharacteristicsForDataCollection_PDU;  /* ReportCharacteristicsForDataCollection */
static int hf_xnap_ReportingPeriodicity_PDU;      /* ReportingPeriodicity */
static int hf_xnap_ReportingPeriodicityForDataCollection_PDU;  /* ReportingPeriodicityForDataCollection */
static int hf_xnap_RequestedPredictionTime_PDU;   /* RequestedPredictionTime */
static int hf_xnap_RegistrationRequest_PDU;       /* RegistrationRequest */
static int hf_xnap_RegistrationRequestForDataCollection_PDU;  /* RegistrationRequestForDataCollection */
static int hf_xnap_ResetRequestTypeInfo_PDU;      /* ResetRequestTypeInfo */
static int hf_xnap_ResetResponseTypeInfo_PDU;     /* ResetResponseTypeInfo */
static int hf_xnap_RLCDuplicationInformation_PDU;  /* RLCDuplicationInformation */
static int hf_xnap_RFSP_Index_PDU;                /* RFSP_Index */
static int hf_xnap_RRCConfigIndication_PDU;       /* RRCConfigIndication */
static int hf_xnap_RRCConnReestab_Indicator_PDU;  /* RRCConnReestab_Indicator */
static int hf_xnap_RRCResumeCause_PDU;            /* RRCResumeCause */
static int hf_xnap_RaReportIndicationList_PDU;    /* RaReportIndicationList */
static int hf_xnap_RadioResourceStatusNR_U_PDU;   /* RadioResourceStatusNR_U */
static int hf_xnap_SCGreconfigNotification_PDU;   /* SCGreconfigNotification */
static int hf_xnap_S_CPAC_Request_PDU;            /* S_CPAC_Request */
static int hf_xnap_S_CPAC_Request_Info_PDU;       /* S_CPAC_Request_Info */
static int hf_xnap_S_CPAC_ReferenceConfig_Request_PDU;  /* S_CPAC_ReferenceConfig_Request */
static int hf_xnap_S_CPAC_InterSN_ExecutionNotify_PDU;  /* S_CPAC_InterSN_ExecutionNotify */
static int hf_xnap_SecondarydataForwardingInfoFromTarget_List_PDU;  /* SecondarydataForwardingInfoFromTarget_List */
static int hf_xnap_SCGActivationRequest_PDU;      /* SCGActivationRequest */
static int hf_xnap_SCGActivationStatus_PDU;       /* SCGActivationStatus */
static int hf_xnap_SCGConfigurationQuery_PDU;     /* SCGConfigurationQuery */
static int hf_xnap_SCGIndicator_PDU;              /* SCGIndicator */
static int hf_xnap_SCGFailureReportContainer_PDU;  /* SCGFailureReportContainer */
static int hf_xnap_SDTSupportRequest_PDU;         /* SDTSupportRequest */
static int hf_xnap_SDT_Termination_Request_PDU;   /* SDT_Termination_Request */
static int hf_xnap_SDTPartialUEContextInfo_PDU;   /* SDTPartialUEContextInfo */
static int hf_xnap_SDTDataForwardingDRBList_PDU;  /* SDTDataForwardingDRBList */
static int hf_xnap_SecurityIndication_PDU;        /* SecurityIndication */
static int hf_xnap_SecurityResult_PDU;            /* SecurityResult */
static int hf_xnap_ServedCells_E_UTRA_PDU;        /* ServedCells_E_UTRA */
static int hf_xnap_ServedCellsToUpdate_E_UTRA_PDU;  /* ServedCellsToUpdate_E_UTRA */
static int hf_xnap_SFN_Offset_PDU;                /* SFN_Offset */
static int hf_xnap_ServedCells_NR_PDU;            /* ServedCells_NR */
static int hf_xnap_ServedCellSpecificInfoReq_NR_PDU;  /* ServedCellSpecificInfoReq_NR */
static int hf_xnap_ServedCellsToUpdate_NR_PDU;    /* ServedCellsToUpdate_NR */
static int hf_xnap_SK_COUNTER_PDU;                /* SK_COUNTER */
static int hf_xnap_SliceRadioResourceStatus_List_PDU;  /* SliceRadioResourceStatus_List */
static int hf_xnap_SLPositioning_Ranging_Services_Info_PDU;  /* SLPositioning_Ranging_Services_Info */
static int hf_xnap_S_NG_RANnode_SecurityKey_PDU;  /* S_NG_RANnode_SecurityKey */
static int hf_xnap_S_NG_RANnode_Addition_Trigger_Ind_PDU;  /* S_NG_RANnode_Addition_Trigger_Ind */
static int hf_xnap_S_NSSAI_PDU;                   /* S_NSSAI */
static int hf_xnap_SNMobilityInformation_PDU;     /* SNMobilityInformation */
static int hf_xnap_SNTriggered_PDU;               /* SNTriggered */
static int hf_xnap_SplitSessionIndicator_PDU;     /* SplitSessionIndicator */
static int hf_xnap_SplitSRBsTypes_PDU;            /* SplitSRBsTypes */
static int hf_xnap_SPRAvailability_PDU;           /* SPRAvailability */
static int hf_xnap_SRSConfiguration_PDU;          /* SRSConfiguration */
static int hf_xnap_SSB_PositionsInBurst_PDU;      /* SSB_PositionsInBurst */
static int hf_xnap_SSBOffsets_List_PDU;           /* SSBOffsets_List */
static int hf_xnap_SuccessfulHOReportInformation_PDU;  /* SuccessfulHOReportInformation */
static int hf_xnap_SuccessfulPSCellChangeReportInformation_PDU;  /* SuccessfulPSCellChangeReportInformation */
static int hf_xnap_Supported_MBS_FSA_ID_List_PDU;  /* Supported_MBS_FSA_ID_List */
static int hf_xnap_SurvivalTime_PDU;              /* SurvivalTime */
static int hf_xnap_SNPN_CellBasedMDT_PDU;         /* SNPN_CellBasedMDT */
static int hf_xnap_SNPN_TAIBasedMDT_PDU;          /* SNPN_TAIBasedMDT */
static int hf_xnap_SNPN_BasedMDT_PDU;             /* SNPN_BasedMDT */
static int hf_xnap_TAINSAGSupportList_PDU;        /* TAINSAGSupportList */
static int hf_xnap_TAISliceUnavailableCellList_PDU;  /* TAISliceUnavailableCellList */
static int hf_xnap_TAISupport_List_PDU;           /* TAISupport_List */
static int hf_xnap_TargetCellinEUTRAN_PDU;        /* TargetCellinEUTRAN */
static int hf_xnap_Target_CGI_PDU;                /* Target_CGI */
static int hf_xnap_TDDULDLConfigurationCommonNR_PDU;  /* TDDULDLConfigurationCommonNR */
static int hf_xnap_TargetCellList_PDU;            /* TargetCellList */
static int hf_xnap_TimeSinceFailure_PDU;          /* TimeSinceFailure */
static int hf_xnap_TimeSynchronizationAssistanceInformation_PDU;  /* TimeSynchronizationAssistanceInformation */
static int hf_xnap_TimeToWait_PDU;                /* TimeToWait */
static int hf_xnap_TNLConfigurationInfo_PDU;      /* TNLConfigurationInfo */
static int hf_xnap_TNLA_To_Add_List_PDU;          /* TNLA_To_Add_List */
static int hf_xnap_TNLA_To_Update_List_PDU;       /* TNLA_To_Update_List */
static int hf_xnap_TNLA_To_Remove_List_PDU;       /* TNLA_To_Remove_List */
static int hf_xnap_TNLA_Setup_List_PDU;           /* TNLA_Setup_List */
static int hf_xnap_TNLA_Failed_To_Setup_List_PDU;  /* TNLA_Failed_To_Setup_List */
static int hf_xnap_TransportLayerAddress_PDU;     /* TransportLayerAddress */
static int hf_xnap_TraceActivation_PDU;           /* TraceActivation */
static int hf_xnap_TrafficToBeReleaseInformation_PDU;  /* TrafficToBeReleaseInformation */
static int hf_xnap_TSCTrafficCharacteristics_PDU;  /* TSCTrafficCharacteristics */
static int hf_xnap_UEAggregateMaximumBitRate_PDU;  /* UEAggregateMaximumBitRate */
static int hf_xnap_UEContextKeptIndicator_PDU;    /* UEContextKeptIndicator */
static int hf_xnap_UEContextID_PDU;               /* UEContextID */
static int hf_xnap_UEContextInfoRetrUECtxtResp_PDU;  /* UEContextInfoRetrUECtxtResp */
static int hf_xnap_UEHistoryInformation_PDU;      /* UEHistoryInformation */
static int hf_xnap_UEHistoryInformationFromTheUE_PDU;  /* UEHistoryInformationFromTheUE */
static int hf_xnap_UEIdentityIndexValue_PDU;      /* UEIdentityIndexValue */
static int hf_xnap_UEIdentityIndexList_MBSGroupPaging_PDU;  /* UEIdentityIndexList_MBSGroupPaging */
static int hf_xnap_UERadioCapabilityForPaging_PDU;  /* UERadioCapabilityForPaging */
static int hf_xnap_UERadioCapabilityID_PDU;       /* UERadioCapabilityID */
static int hf_xnap_UERANPagingIdentity_PDU;       /* UERANPagingIdentity */
static int hf_xnap_UERLFReportContainer_PDU;      /* UERLFReportContainer */
static int hf_xnap_UERLFReportContainerLTEExtension_PDU;  /* UERLFReportContainerLTEExtension */
static int hf_xnap_UESliceMaximumBitRateList_PDU;  /* UESliceMaximumBitRateList */
static int hf_xnap_UESecurityCapabilities_PDU;    /* UESecurityCapabilities */
static int hf_xnap_UESpecificDRX_PDU;             /* UESpecificDRX */
static int hf_xnap_ULForwardingProposal_PDU;      /* ULForwardingProposal */
static int hf_xnap_UPTransportLayerInformation_PDU;  /* UPTransportLayerInformation */
static int hf_xnap_UPTransportParameters_PDU;     /* UPTransportParameters */
static int hf_xnap_UserPlaneTrafficActivityReport_PDU;  /* UserPlaneTrafficActivityReport */
static int hf_xnap_UserPlaneFailureIndication_PDU;  /* UserPlaneFailureIndication */
static int hf_xnap_URIaddress_PDU;                /* URIaddress */
static int hf_xnap_UEAssociatedInfoResult_List_PDU;  /* UEAssociatedInfoResult_List */
static int hf_xnap_UEPerformanceCollectionConfiguration_PDU;  /* UEPerformanceCollectionConfiguration */
static int hf_xnap_UETrajectoryCollectionConfiguration_PDU;  /* UETrajectoryCollectionConfiguration */
static int hf_xnap_XnBenefitValue_PDU;            /* XnBenefitValue */
static int hf_xnap_XR_Bcast_Information_PDU;      /* XR_Bcast_Information */
static int hf_xnap_HandoverRequest_PDU;           /* HandoverRequest */
static int hf_xnap_UEContextInfoHORequest_PDU;    /* UEContextInfoHORequest */
static int hf_xnap_UEContextRefAtSN_HORequest_PDU;  /* UEContextRefAtSN_HORequest */
static int hf_xnap_HandoverRequestAcknowledge_PDU;  /* HandoverRequestAcknowledge */
static int hf_xnap_Target2SourceNG_RANnodeTranspContainer_PDU;  /* Target2SourceNG_RANnodeTranspContainer */
static int hf_xnap_HandoverPreparationFailure_PDU;  /* HandoverPreparationFailure */
static int hf_xnap_SNStatusTransfer_PDU;          /* SNStatusTransfer */
static int hf_xnap_UEContextRelease_PDU;          /* UEContextRelease */
static int hf_xnap_HandoverCancel_PDU;            /* HandoverCancel */
static int hf_xnap_HandoverSuccess_PDU;           /* HandoverSuccess */
static int hf_xnap_ConditionalHandoverCancel_PDU;  /* ConditionalHandoverCancel */
static int hf_xnap_EarlyStatusTransfer_PDU;       /* EarlyStatusTransfer */
static int hf_xnap_ProcedureStageChoice_PDU;      /* ProcedureStageChoice */
static int hf_xnap_RANPaging_PDU;                 /* RANPaging */
static int hf_xnap_RetrieveUEContextRequest_PDU;  /* RetrieveUEContextRequest */
static int hf_xnap_RetrieveUEContextResponse_PDU;  /* RetrieveUEContextResponse */
static int hf_xnap_RetrieveUEContextConfirm_PDU;  /* RetrieveUEContextConfirm */
static int hf_xnap_RetrieveUEContextFailure_PDU;  /* RetrieveUEContextFailure */
static int hf_xnap_OldtoNewNG_RANnodeResumeContainer_PDU;  /* OldtoNewNG_RANnodeResumeContainer */
static int hf_xnap_XnUAddressIndication_PDU;      /* XnUAddressIndication */
static int hf_xnap_SNodeAdditionRequest_PDU;      /* SNodeAdditionRequest */
static int hf_xnap_MN_to_SN_Container_PDU;        /* MN_to_SN_Container */
static int hf_xnap_PDUSessionToBeAddedAddReq_PDU;  /* PDUSessionToBeAddedAddReq */
static int hf_xnap_RequestedFastMCGRecoveryViaSRB3_PDU;  /* RequestedFastMCGRecoveryViaSRB3 */
static int hf_xnap_SNodeAdditionRequestAcknowledge_PDU;  /* SNodeAdditionRequestAcknowledge */
static int hf_xnap_SN_to_MN_Container_PDU;        /* SN_to_MN_Container */
static int hf_xnap_PDUSessionAdmittedAddedAddReqAck_PDU;  /* PDUSessionAdmittedAddedAddReqAck */
static int hf_xnap_PDUSessionNotAdmittedAddReqAck_PDU;  /* PDUSessionNotAdmittedAddReqAck */
static int hf_xnap_AvailableFastMCGRecoveryViaSRB3_PDU;  /* AvailableFastMCGRecoveryViaSRB3 */
static int hf_xnap_SNodeAdditionRequestReject_PDU;  /* SNodeAdditionRequestReject */
static int hf_xnap_SNodeReconfigurationComplete_PDU;  /* SNodeReconfigurationComplete */
static int hf_xnap_ResponseInfo_ReconfCompl_PDU;  /* ResponseInfo_ReconfCompl */
static int hf_xnap_SNodeModificationRequest_PDU;  /* SNodeModificationRequest */
static int hf_xnap_UEContextInfo_SNModRequest_PDU;  /* UEContextInfo_SNModRequest */
static int hf_xnap_RequestedFastMCGRecoveryViaSRB3Release_PDU;  /* RequestedFastMCGRecoveryViaSRB3Release */
static int hf_xnap_Src_SN_to_Tgt_SNQMCInfoInquiry_PDU;  /* Src_SN_to_Tgt_SNQMCInfoInquiry */
static int hf_xnap_SNodeModificationRequestAcknowledge_PDU;  /* SNodeModificationRequestAcknowledge */
static int hf_xnap_PDUSessionAdmitted_SNModResponse_PDU;  /* PDUSessionAdmitted_SNModResponse */
static int hf_xnap_PDUSessionNotAdmitted_SNModResponse_PDU;  /* PDUSessionNotAdmitted_SNModResponse */
static int hf_xnap_PDUSessionDataForwarding_SNModResponse_PDU;  /* PDUSessionDataForwarding_SNModResponse */
static int hf_xnap_ReleaseFastMCGRecoveryViaSRB3_PDU;  /* ReleaseFastMCGRecoveryViaSRB3 */
static int hf_xnap_SNodeModificationRequestReject_PDU;  /* SNodeModificationRequestReject */
static int hf_xnap_SNodeModificationRequired_PDU;  /* SNodeModificationRequired */
static int hf_xnap_PDUSessionToBeModifiedSNModRequired_PDU;  /* PDUSessionToBeModifiedSNModRequired */
static int hf_xnap_PDUSessionToBeReleasedSNModRequired_PDU;  /* PDUSessionToBeReleasedSNModRequired */
static int hf_xnap_SNodeModificationConfirm_PDU;  /* SNodeModificationConfirm */
static int hf_xnap_PDUSessionAdmittedModSNModConfirm_PDU;  /* PDUSessionAdmittedModSNModConfirm */
static int hf_xnap_PDUSessionReleasedSNModConfirm_PDU;  /* PDUSessionReleasedSNModConfirm */
static int hf_xnap_SNodeModificationRefuse_PDU;   /* SNodeModificationRefuse */
static int hf_xnap_SNodeReleaseRequest_PDU;       /* SNodeReleaseRequest */
static int hf_xnap_SNodeReleaseRequestAcknowledge_PDU;  /* SNodeReleaseRequestAcknowledge */
static int hf_xnap_PDUSessionToBeReleasedList_RelReqAck_PDU;  /* PDUSessionToBeReleasedList_RelReqAck */
static int hf_xnap_SNodeReleaseReject_PDU;        /* SNodeReleaseReject */
static int hf_xnap_SNodeReleaseRequired_PDU;      /* SNodeReleaseRequired */
static int hf_xnap_PDUSessionToBeReleasedList_RelRqd_PDU;  /* PDUSessionToBeReleasedList_RelRqd */
static int hf_xnap_SNodeReleaseConfirm_PDU;       /* SNodeReleaseConfirm */
static int hf_xnap_PDUSessionReleasedList_RelConf_PDU;  /* PDUSessionReleasedList_RelConf */
static int hf_xnap_SNodeCounterCheckRequest_PDU;  /* SNodeCounterCheckRequest */
static int hf_xnap_BearersSubjectToCounterCheck_List_PDU;  /* BearersSubjectToCounterCheck_List */
static int hf_xnap_SNodeChangeRequired_PDU;       /* SNodeChangeRequired */
static int hf_xnap_PDUSession_SNChangeRequired_List_PDU;  /* PDUSession_SNChangeRequired_List */
static int hf_xnap_SNodeChangeConfirm_PDU;        /* SNodeChangeConfirm */
static int hf_xnap_PDUSession_SNChangeConfirm_List_PDU;  /* PDUSession_SNChangeConfirm_List */
static int hf_xnap_SNodeChangeRefuse_PDU;         /* SNodeChangeRefuse */
static int hf_xnap_RRCTransfer_PDU;               /* RRCTransfer */
static int hf_xnap_SplitSRB_RRCTransfer_PDU;      /* SplitSRB_RRCTransfer */
static int hf_xnap_UEReportRRCTransfer_PDU;       /* UEReportRRCTransfer */
static int hf_xnap_FastMCGRecoveryRRCTransfer_PDU;  /* FastMCGRecoveryRRCTransfer */
static int hf_xnap_SDT_SRB_between_NewNode_OldNode_PDU;  /* SDT_SRB_between_NewNode_OldNode */
static int hf_xnap_QoE_Measurement_Results_PDU;   /* QoE_Measurement_Results */
static int hf_xnap_NotificationControlIndication_PDU;  /* NotificationControlIndication */
static int hf_xnap_PDUSessionResourcesNotifyList_PDU;  /* PDUSessionResourcesNotifyList */
static int hf_xnap_ActivityNotification_PDU;      /* ActivityNotification */
static int hf_xnap_PDUSessionResourcesActivityNotifyList_PDU;  /* PDUSessionResourcesActivityNotifyList */
static int hf_xnap_XnSetupRequest_PDU;            /* XnSetupRequest */
static int hf_xnap_XnSetupResponse_PDU;           /* XnSetupResponse */
static int hf_xnap_XnSetupFailure_PDU;            /* XnSetupFailure */
static int hf_xnap_NGRANNodeConfigurationUpdate_PDU;  /* NGRANNodeConfigurationUpdate */
static int hf_xnap_ConfigurationUpdateInitiatingNodeChoice_PDU;  /* ConfigurationUpdateInitiatingNodeChoice */
static int hf_xnap_NGRANNodeConfigurationUpdateAcknowledge_PDU;  /* NGRANNodeConfigurationUpdateAcknowledge */
static int hf_xnap_RespondingNodeTypeConfigUpdateAck_PDU;  /* RespondingNodeTypeConfigUpdateAck */
static int hf_xnap_NGRANNodeConfigurationUpdateFailure_PDU;  /* NGRANNodeConfigurationUpdateFailure */
static int hf_xnap_E_UTRA_NR_CellResourceCoordinationRequest_PDU;  /* E_UTRA_NR_CellResourceCoordinationRequest */
static int hf_xnap_InitiatingNodeType_ResourceCoordRequest_PDU;  /* InitiatingNodeType_ResourceCoordRequest */
static int hf_xnap_E_UTRA_NR_CellResourceCoordinationResponse_PDU;  /* E_UTRA_NR_CellResourceCoordinationResponse */
static int hf_xnap_RespondingNodeType_ResourceCoordResponse_PDU;  /* RespondingNodeType_ResourceCoordResponse */
static int hf_xnap_SecondaryRATDataUsageReport_PDU;  /* SecondaryRATDataUsageReport */
static int hf_xnap_XnRemovalRequest_PDU;          /* XnRemovalRequest */
static int hf_xnap_XnRemovalResponse_PDU;         /* XnRemovalResponse */
static int hf_xnap_XnRemovalFailure_PDU;          /* XnRemovalFailure */
static int hf_xnap_CellActivationRequest_PDU;     /* CellActivationRequest */
static int hf_xnap_ServedCellsToActivate_PDU;     /* ServedCellsToActivate */
static int hf_xnap_ToBeActivatedNRCellsAndSSBsList_PDU;  /* ToBeActivatedNRCellsAndSSBsList */
static int hf_xnap_CellActivationResponse_PDU;    /* CellActivationResponse */
static int hf_xnap_ActivatedServedCells_PDU;      /* ActivatedServedCells */
static int hf_xnap_ActivatedNRCellsAndSSBsList_PDU;  /* ActivatedNRCellsAndSSBsList */
static int hf_xnap_CellActivationFailure_PDU;     /* CellActivationFailure */
static int hf_xnap_ResetRequest_PDU;              /* ResetRequest */
static int hf_xnap_ResetResponse_PDU;             /* ResetResponse */
static int hf_xnap_ErrorIndication_PDU;           /* ErrorIndication */
static int hf_xnap_PrivateMessage_PDU;            /* PrivateMessage */
static int hf_xnap_TraceStart_PDU;                /* TraceStart */
static int hf_xnap_DeactivateTrace_PDU;           /* DeactivateTrace */
static int hf_xnap_FailureIndication_PDU;         /* FailureIndication */
static int hf_xnap_HandoverReport_PDU;            /* HandoverReport */
static int hf_xnap_ResourceStatusRequest_PDU;     /* ResourceStatusRequest */
static int hf_xnap_ResourceStatusResponse_PDU;    /* ResourceStatusResponse */
static int hf_xnap_ResourceStatusFailure_PDU;     /* ResourceStatusFailure */
static int hf_xnap_ResourceStatusUpdate_PDU;      /* ResourceStatusUpdate */
static int hf_xnap_MobilityChangeRequest_PDU;     /* MobilityChangeRequest */
static int hf_xnap_MobilityChangeAcknowledge_PDU;  /* MobilityChangeAcknowledge */
static int hf_xnap_MobilityChangeFailure_PDU;     /* MobilityChangeFailure */
static int hf_xnap_AccessAndMobilityIndication_PDU;  /* AccessAndMobilityIndication */
static int hf_xnap_CellTrafficTrace_PDU;          /* CellTrafficTrace */
static int hf_xnap_RANMulticastGroupPaging_PDU;   /* RANMulticastGroupPaging */
static int hf_xnap_ScgFailureInformationReport_PDU;  /* ScgFailureInformationReport */
static int hf_xnap_ScgFailureTransfer_PDU;        /* ScgFailureTransfer */
static int hf_xnap_F1CTrafficTransfer_PDU;        /* F1CTrafficTransfer */
static int hf_xnap_IABTransportMigrationManagementRequest_PDU;  /* IABTransportMigrationManagementRequest */
static int hf_xnap_TrafficToBeAddedList_PDU;      /* TrafficToBeAddedList */
static int hf_xnap_TrafficToBeModifiedList_PDU;   /* TrafficToBeModifiedList */
static int hf_xnap_IABTransportMigrationManagementResponse_PDU;  /* IABTransportMigrationManagementResponse */
static int hf_xnap_TrafficAddedList_PDU;          /* TrafficAddedList */
static int hf_xnap_TrafficModifiedList_PDU;       /* TrafficModifiedList */
static int hf_xnap_TrafficNotAddedList_PDU;       /* TrafficNotAddedList */
static int hf_xnap_TrafficNotModifiedList_PDU;    /* TrafficNotModifiedList */
static int hf_xnap_TrafficReleasedList_PDU;       /* TrafficReleasedList */
static int hf_xnap_IABTransportMigrationManagementReject_PDU;  /* IABTransportMigrationManagementReject */
static int hf_xnap_IABTransportMigrationModificationRequest_PDU;  /* IABTransportMigrationModificationRequest */
static int hf_xnap_TrafficRequiredToBeModifiedList_PDU;  /* TrafficRequiredToBeModifiedList */
static int hf_xnap_IABTNLAddressToBeReleasedList_PDU;  /* IABTNLAddressToBeReleasedList */
static int hf_xnap_IABTransportMigrationModificationResponse_PDU;  /* IABTransportMigrationModificationResponse */
static int hf_xnap_TrafficRequiredModifiedList_PDU;  /* TrafficRequiredModifiedList */
static int hf_xnap_IABResourceCoordinationRequest_PDU;  /* IABResourceCoordinationRequest */
static int hf_xnap_BoundaryNodeCellsList_PDU;     /* BoundaryNodeCellsList */
static int hf_xnap_ParentNodeCellsList_PDU;       /* ParentNodeCellsList */
static int hf_xnap_IABResourceCoordinationResponse_PDU;  /* IABResourceCoordinationResponse */
static int hf_xnap_CPCCancel_PDU;                 /* CPCCancel */
static int hf_xnap_PartialUEContextTransfer_PDU;  /* PartialUEContextTransfer */
static int hf_xnap_PartialUEContextTransferAcknowledge_PDU;  /* PartialUEContextTransferAcknowledge */
static int hf_xnap_PartialUEContextTransferFailure_PDU;  /* PartialUEContextTransferFailure */
static int hf_xnap_RachIndication_PDU;            /* RachIndication */
static int hf_xnap_DataCollectionRequest_PDU;     /* DataCollectionRequest */
static int hf_xnap_DataCollectionResponse_PDU;    /* DataCollectionResponse */
static int hf_xnap_DataCollectionFailure_PDU;     /* DataCollectionFailure */
static int hf_xnap_DataCollectionUpdate_PDU;      /* DataCollectionUpdate */
static int hf_xnap_XnAP_PDU_PDU;                  /* XnAP_PDU */
static int hf_xnap_local;                         /* INTEGER_0_maxPrivateIEs */
static int hf_xnap_global;                        /* OBJECT_IDENTIFIER */
static int hf_xnap_ProtocolIE_Container_item;     /* ProtocolIE_Field */
static int hf_xnap_id;                            /* ProtocolIE_ID */
static int hf_xnap_criticality;                   /* Criticality */
static int hf_xnap_protocolIE_Field_value;        /* ProtocolIE_Field_value */
static int hf_xnap_ProtocolExtensionContainer_item;  /* ProtocolExtensionField */
static int hf_xnap_extension_id;                  /* ProtocolIE_ID */
static int hf_xnap_extensionValue;                /* T_extensionValue */
static int hf_xnap_PrivateIE_Container_item;      /* PrivateIE_Field */
static int hf_xnap_private_id;                    /* PrivateIE_ID */
static int hf_xnap_privateIE_Field_value;         /* PrivateIE_Field_value */
static int hf_xnap_a2XPC5QoSFlowList;             /* A2XPC5QoSFlowList */
static int hf_xnap_aA2XPC5LinkAggregateBitRates;  /* BitRate */
static int hf_xnap_iE_Extensions;                 /* ProtocolExtensionContainer */
static int hf_xnap_A2XPC5QoSFlowList_item;        /* A2XPC5QoSFlowItem */
static int hf_xnap_a2XpQI;                        /* FiveQI */
static int hf_xnap_a2Xpc5FlowBitRates;            /* A2XPC5FlowBitRates */
static int hf_xnap_a2Xrange;                      /* Range */
static int hf_xnap_a2XguaranteedFlowBitRate;      /* BitRate */
static int hf_xnap_a2XmaximumFlowBitRate;         /* BitRate */
static int hf_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_item;  /* AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item */
static int hf_xnap_pDUSessionResourceChangeConfirmInfo_SNterminated;  /* PDUSessionResourceChangeConfirmInfo_SNterminated */
static int hf_xnap_uL_AveragePacketDelay;         /* AveragePacketDelayValue */
static int hf_xnap_dL_AveragePacketDelay;         /* AveragePacketDelayValue */
static int hf_xnap_Additional_PDCP_Duplication_TNL_List_item;  /* Additional_PDCP_Duplication_TNL_Item */
static int hf_xnap_additional_PDCP_Duplication_UP_TNL_Information;  /* UPTransportLayerInformation */
static int hf_xnap_additional_UL_NG_U_TNLatUPF;   /* UPTransportLayerInformation */
static int hf_xnap_Additional_UL_NG_U_TNLatUPF_List_item;  /* Additional_UL_NG_U_TNLatUPF_Item */
static int hf_xnap_Additional_Measurement_Timing_Configuration_List_item;  /* Additional_Measurement_Timing_Configuration_Item */
static int hf_xnap_additionalMeasurementTimingConfigurationIndex;  /* INTEGER_0_16 */
static int hf_xnap_csi_RS_MTC_Configuration_List;  /* CSI_RS_MTC_Configuration_List */
static int hf_xnap_mBS_QoSFlowsToAdd_List;        /* MBS_QoSFlowsToAdd_List */
static int hf_xnap_mBS_ServiceArea;               /* MBS_ServiceArea */
static int hf_xnap_mBS_MappingandDataForwardingRequestInfofromSource;  /* MBS_MappingandDataForwardingRequestInfofromSource */
static int hf_xnap_nGRAN_Node1_Measurement_ID;    /* Measurement_ID */
static int hf_xnap_nGRAN_Node2_Measurement_ID;    /* Measurement_ID */
static int hf_xnap_priorityLevel;                 /* INTEGER_0_15_ */
static int hf_xnap_pre_emption_capability;        /* T_pre_emption_capability */
static int hf_xnap_pre_emption_vulnerability;     /* T_pre_emption_vulnerability */
static int hf_xnap_AllowedCAG_ID_List_perPLMN_item;  /* CAG_Identifier */
static int hf_xnap_AllowedPNI_NPN_ID_List_item;   /* AllowedPNI_NPN_ID_Item */
static int hf_xnap_plmn_id;                       /* PLMN_Identity */
static int hf_xnap_pni_npn_restricted_information;  /* PNI_NPN_Restricted_Information */
static int hf_xnap_allowed_CAG_id_list_per_plmn;  /* AllowedCAG_ID_List_perPLMN */
static int hf_xnap_AlternativeQoSParaSetList_item;  /* AlternativeQoSParaSetItem */
static int hf_xnap_alternativeQoSParaSetIndex;    /* QoSParaSetIndex */
static int hf_xnap_guaranteedFlowBitRateDL;       /* BitRate */
static int hf_xnap_guaranteedFlowBitRateUL;       /* BitRate */
static int hf_xnap_packetDelayBudget;             /* PacketDelayBudget */
static int hf_xnap_packetErrorRate;               /* PacketErrorRate */
static int hf_xnap_AMF_Region_Information_item;   /* GlobalAMF_Region_Information */
static int hf_xnap_plmn_ID;                       /* PLMN_Identity */
static int hf_xnap_amf_region_id;                 /* BIT_STRING_SIZE_8 */
static int hf_xnap_AreaOfInterestInformation_item;  /* AreaOfInterest_Item */
static int hf_xnap_listOfTAIsinAoI;               /* ListOfTAIsinAoI */
static int hf_xnap_listOfCellsinAoI;              /* ListOfCells */
static int hf_xnap_listOfRANNodesinAoI;           /* ListOfRANNodesinAoI */
static int hf_xnap_requestReferenceID;            /* RequestReferenceID */
static int hf_xnap_cellBased;                     /* CellBasedMDT_NR */
static int hf_xnap_tABased;                       /* TABasedMDT */
static int hf_xnap_tAIBased;                      /* TAIBasedMDT */
static int hf_xnap_choice_extension;              /* ProtocolIE_Single_Container */
static int hf_xnap_cellBased_01;                  /* CellBasedMDT_EUTRA */
static int hf_xnap_AreaScopeOfNeighCellsList_item;  /* AreaScopeOfNeighCellsItem */
static int hf_xnap_nrFrequencyInfo;               /* NRFrequencyInfo */
static int hf_xnap_pciListForMDT;                 /* PCIListForMDT */
static int hf_xnap_cellBased_02;                  /* CellBasedQMC */
static int hf_xnap_tABased_01;                    /* TABasedQMC */
static int hf_xnap_tAIBased_01;                   /* TAIBasedQMC */
static int hf_xnap_pLMNAreaBased;                 /* PLMNAreaBasedQMC */
static int hf_xnap_key_NG_RAN_Star;               /* BIT_STRING_SIZE_256 */
static int hf_xnap_ncc;                           /* INTEGER_0_7 */
static int hf_xnap_ran_paging_attempt_info;       /* RANPagingAttemptInfo */
static int hf_xnap_Associated_QoSFlowInfo_List_item;  /* Associated_QoSFlowInfo_Item */
static int hf_xnap_mBS_QoSFlowIdentifier;         /* QoSFlowIdentifier */
static int hf_xnap_associatedUnicastQoSFlowIdentifier;  /* QoSFlowIdentifier */
static int hf_xnap_applicationLayerBufferLevelList;  /* T_applicationLayerBufferLevelList */
static int hf_xnap_playoutDelayForMediaStartup;   /* T_playoutDelayForMediaStartup */
static int hf_xnap_bAPAddress;                    /* BAPAddress */
static int hf_xnap_bAPPathID;                     /* BAPPathID */
static int hf_xnap_beamMeasurementsReportQuantity;  /* BeamMeasurementsReportQuantity */
static int hf_xnap_maxNrofRS_IndexesToReport;     /* MaxNrofRS_IndexesToReport */
static int hf_xnap_rSRP;                          /* T_rSRP */
static int hf_xnap_rSRQ;                          /* T_rSRQ */
static int hf_xnap_sINR;                          /* T_sINR */
static int hf_xnap_BHInfoList_item;               /* BHInfo_Item */
static int hf_xnap_bHInfoIndex;                   /* BHInfoIndex */
static int hf_xnap_BAPControlPDURLCCH_List_item;  /* BAPControlPDURLCCH_Item */
static int hf_xnap_bHRLCCHID;                     /* BHRLCChannelID */
static int hf_xnap_nexthopBAPAddress;             /* BAPAddress */
static int hf_xnap_bluetoothMeasConfig;           /* BluetoothMeasConfig */
static int hf_xnap_bluetoothMeasConfigNameList;   /* BluetoothMeasConfigNameList */
static int hf_xnap_bt_rssi;                       /* T_bt_rssi */
static int hf_xnap_BluetoothMeasConfigNameList_item;  /* BluetoothName */
static int hf_xnap_BPLMN_ID_Info_EUTRA_item;      /* BPLMN_ID_Info_EUTRA_Item */
static int hf_xnap_broadcastPLMNs;                /* BroadcastEUTRAPLMNs */
static int hf_xnap_tac;                           /* TAC */
static int hf_xnap_e_utraCI;                      /* E_UTRA_Cell_Identity */
static int hf_xnap_ranac;                         /* RANAC */
static int hf_xnap_iE_Extension;                  /* ProtocolExtensionContainer */
static int hf_xnap_BPLMN_ID_Info_NR_item;         /* BPLMN_ID_Info_NR_Item */
static int hf_xnap_broadcastPLMNs_01;             /* BroadcastPLMNs */
static int hf_xnap_nr_CI;                         /* NR_Cell_Identity */
static int hf_xnap_BroadcastCAG_Identifier_List_item;  /* BroadcastCAG_Identifier_Item */
static int hf_xnap_cag_Identifier;                /* CAG_Identifier */
static int hf_xnap_BroadcastNID_List_item;        /* BroadcastNID_Item */
static int hf_xnap_nid;                           /* NID */
static int hf_xnap_BroadcastPLMNs_item;           /* PLMN_Identity */
static int hf_xnap_BroadcastEUTRAPLMNs_item;      /* PLMN_Identity */
static int hf_xnap_tAISliceSupport_List;          /* SliceSupport_List */
static int hf_xnap_BroadcastPNI_NPN_ID_Information_item;  /* BroadcastPNI_NPN_ID_Information_Item */
static int hf_xnap_broadcastCAG_Identifier_List;  /* BroadcastCAG_Identifier_List */
static int hf_xnap_BroadcastSNPNID_List_item;     /* BroadcastSNPNID */
static int hf_xnap_broadcastNID_List;             /* BroadcastNID_List */
static int hf_xnap_CandidateRelayUEInfoList_item;  /* CandidateRelayUEInfoItem */
static int hf_xnap_candidateRelayUEID;            /* BIT_STRING_SIZE_24 */
static int hf_xnap_capacityValue;                 /* CapacityValue */
static int hf_xnap_ssbAreaCapacityValueList;      /* SSBAreaCapacityValue_List */
static int hf_xnap_radioNetwork;                  /* CauseRadioNetworkLayer */
static int hf_xnap_transport;                     /* CauseTransportLayer */
static int hf_xnap_protocol;                      /* CauseProtocol */
static int hf_xnap_misc;                          /* CauseMisc */
static int hf_xnap_limitedNR_List;                /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_limitedNR_List_item;           /* NR_CGI */
static int hf_xnap_full_List;                     /* T_full_List */
static int hf_xnap_maximumCellListSize;           /* MaximumCellListSize */
static int hf_xnap_cellAssistanceInfo_NR;         /* CellAssistanceInfo_NR */
static int hf_xnap_cellAssistanceInfo_EUTRA;      /* CellAssistanceInfo_EUTRA */
static int hf_xnap_limitedEUTRA_List;             /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_limitedEUTRA_List_item;        /* E_UTRA_CGI */
static int hf_xnap_full_List_01;                  /* T_full_List_01 */
static int hf_xnap_cellIdListforMDT_NR;           /* CellIdListforMDT_NR */
static int hf_xnap_CellIdListforMDT_NR_item;      /* NR_CGI */
static int hf_xnap_cellIdListforQMC;              /* CellIdListforQMC */
static int hf_xnap_CellIdListforQMC_item;         /* GlobalNG_RANCell_ID */
static int hf_xnap_cellIdListforMDT_EUTRA;        /* CellIdListforMDT_EUTRA */
static int hf_xnap_CellIdListforMDT_EUTRA_item;   /* E_UTRA_CGI */
static int hf_xnap_CellMeasurementResult_item;    /* CellMeasurementResult_Item */
static int hf_xnap_cell_ID;                       /* GlobalNG_RANCell_ID */
static int hf_xnap_radioResourceStatus;           /* RadioResourceStatus */
static int hf_xnap_tNLCapacityIndicator;          /* TNLCapacityIndicator */
static int hf_xnap_compositeAvailableCapacityGroup;  /* CompositeAvailableCapacityGroup */
static int hf_xnap_sliceAvailableCapacity;        /* SliceAvailableCapacity */
static int hf_xnap_numberofActiveUEs;             /* NumberofActiveUEs */
static int hf_xnap_rRCConnections;                /* RRCConnections */
static int hf_xnap_replacingCells;                /* ReplacingCells */
static int hf_xnap_CellToReport_item;             /* CellToReport_Item */
static int hf_xnap_sSBToReport_List;              /* SSBToReport_List */
static int hf_xnap_sliceToReport_List;            /* SliceToReport_List */
static int hf_xnap_CellToReportForDataCollection_List_item;  /* CellToReportForDataCollection_Item */
static int hf_xnap_CellBasedUETrajectoryPrediction_item;  /* PredictedUETrajectory_Item */
static int hf_xnap_CellMeasurementInitiationResult_List_item;  /* CellMeasurementInitiationResult_Item */
static int hf_xnap_cellID;                        /* GlobalNG_RANCell_ID */
static int hf_xnap_cellMeasurementFailureCause_List;  /* CellMeasurementFailureCause_List */
static int hf_xnap_CellMeasurementResultForDataCollection_List_item;  /* CellInfoResultForDataCollection_Item */
static int hf_xnap_predictedRadioResourceStatus;  /* RadioResourceStatus */
static int hf_xnap_predictedNumberofActiveUEs;    /* NumberofActiveUEs */
static int hf_xnap_predictedRRCConnections;       /* RRCConnections */
static int hf_xnap_ng_ran_e_utra;                 /* E_UTRA_Cell_Identity */
static int hf_xnap_ng_ran_nr;                     /* NR_Cell_Identity */
static int hf_xnap_e_utran;                       /* E_UTRA_Cell_Identity */
static int hf_xnap_CellMeasurementFailureCause_List_item;  /* CellMeasurementFailureCause_Item */
static int hf_xnap_cellmeasurementFailedReportCharacteristics;  /* T_cellmeasurementFailedReportCharacteristics */
static int hf_xnap_cause;                         /* Cause */
static int hf_xnap_choCandidateCell_List;         /* CHOCandidateCell_List */
static int hf_xnap_CHOCandidateCell_List_item;    /* CHOCandidateCell_Item */
static int hf_xnap_choCandidateCellID;            /* GlobalNG_RANCell_ID */
static int hf_xnap_choExecutionCondition_List;    /* CHOExecutionCondition_List */
static int hf_xnap_CHOExecutionCondition_List_item;  /* CHOExecutionCondition_Item */
static int hf_xnap_measObjectContainer;           /* MeasObjectContainer */
static int hf_xnap_reportConfigContainer;         /* ReportConfigContainer */
static int hf_xnap_synchronisationState;          /* BIT_STRING_SIZE_8_ */
static int hf_xnap_traceabletoUTC;                /* T_traceabletoUTC */
static int hf_xnap_traceabletoGNSS;               /* T_traceabletoGNSS */
static int hf_xnap_clockFrequencyStability;       /* BIT_STRING_SIZE_16 */
static int hf_xnap_clockAccuracy;                 /* INTEGER_1_40000000_ */
static int hf_xnap_parentTimeSource;              /* BIT_STRING_SIZE_16_ */
static int hf_xnap_clockQualityDetailLevel;       /* ClockQualityDetailLevel */
static int hf_xnap_clockQualityMetrics;           /* NULL */
static int hf_xnap_acceptanceIndication;          /* ClockQualityAcceptanceCriteria */
static int hf_xnap_compositeAvailableCapacityDownlink;  /* CompositeAvailableCapacity */
static int hf_xnap_compositeAvailableCapacityUplink;  /* CompositeAvailableCapacity */
static int hf_xnap_cellCapacityClassValue;        /* CellCapacityClassValue */
static int hf_xnap_capacityValueInfo;             /* CapacityValueInfo */
static int hf_xnap_cho_trigger;                   /* CHOtrigger */
static int hf_xnap_targetNG_RANnodeUEXnAPID;      /* NG_RANnodeUEXnAPID */
static int hf_xnap_cHO_EstimatedArrivalProbability;  /* CHO_Probability */
static int hf_xnap_cHO_HOWindowStart;             /* CHO_HandoverWindowStart */
static int hf_xnap_cHO_HOWindowDuration;          /* CHO_HandoverWindowDuration */
static int hf_xnap_requestedTargetCellGlobalID;   /* Target_CGI */
static int hf_xnap_maxCHOoperations;              /* MaxCHOpreparations */
static int hf_xnap_source_M_NGRAN_node_ID;        /* GlobalNG_RANNode_ID */
static int hf_xnap_source_M_NGRAN_node_UE_XnAP_ID;  /* NG_RANnodeUEXnAPID */
static int hf_xnap_pCell_ID;                      /* GlobalNG_RANCell_ID */
static int hf_xnap_conditionalReconfig;           /* T_conditionalReconfig */
static int hf_xnap_cHO_CPAC_config_indicator;     /* CHO_CPAC_Config_Indicator */
static int hf_xnap_cHO_target_SN_node_list;       /* CHO_target_SN_node_list */
static int hf_xnap_CHO_target_SN_node_list_item;  /* CHO_target_SN_node_Item */
static int hf_xnap_target_S_NG_RANnodeID;         /* GlobalNG_RANNode_ID */
static int hf_xnap_pduSessionResourcesAdmittedList;  /* PDUSessionResourcesAdmitted_List */
static int hf_xnap_cho_Candidate_PSCells_list;    /* CHO_Candidate_PSCells_list */
static int hf_xnap_CHO_Candidate_PSCells_list_item;  /* CHO_Candidate_PSCells_Item */
static int hf_xnap_pscell_id;                     /* NR_CGI */
static int hf_xnap_target2source_NG_RANNode_Container;  /* OCTET_STRING */
static int hf_xnap_Conditional_Reconfig_List_item;  /* Conditional_Reconfig_Item */
static int hf_xnap_pCell_ID_01;                   /* Target_CGI */
static int hf_xnap_pSCell_ID;                     /* NR_CGI */
static int hf_xnap_eNDC_Support;                  /* T_eNDC_Support */
static int hf_xnap_pdcp_SN12;                     /* INTEGER_0_4095 */
static int hf_xnap_hfn_PDCP_SN12;                 /* INTEGER_0_1048575 */
static int hf_xnap_pdcp_SN18;                     /* INTEGER_0_262143 */
static int hf_xnap_hfn_PDCP_SN18;                 /* INTEGER_0_16383 */
static int hf_xnap_Coverage_Modification_List_item;  /* Coverage_Modification_List_Item */
static int hf_xnap_globalNG_RANCell_ID;           /* GlobalCell_ID */
static int hf_xnap_cellCoverageState;             /* INTEGER_0_63_ */
static int hf_xnap_cellDeploymentStatusIndicator;  /* CellDeploymentStatusIndicator */
static int hf_xnap_cellReplacingInfo;             /* CellReplacingInfo */
static int hf_xnap_sSB_Coverage_Modification_List;  /* SSB_Coverage_Modification_List */
static int hf_xnap_endpointIPAddress;             /* TransportLayerAddress */
static int hf_xnap_CPACcandidatePSCells_list_item;  /* CPACcandidatePSCells_item */
static int hf_xnap_CPACcandidatePSCells_wotherInfo_list_item;  /* CPACcandidatePSCells_wotherInfo_item */
static int hf_xnap_s_CPAC_CompleteConfig_Indicator;  /* CompleteConfig_Indicator */
static int hf_xnap_cpacCandidateCell_List;        /* CPACCandidateCell_List */
static int hf_xnap_CPACCandidateCell_List_item;   /* CPACCandidateCell_Item */
static int hf_xnap_cpacCandidateCellID;           /* GlobalNG_RANCell_ID */
static int hf_xnap_cpacExecutionCondition_List;   /* CPACExecutionCondition_List */
static int hf_xnap_CPACExecutionCondition_List_item;  /* CPACExecutionCondition_Item */
static int hf_xnap_max_no_of_pscells;             /* INTEGER_1_maxnoofPSCellCandidates_ */
static int hf_xnap_cpac_EstimatedArrivalProbability;  /* CHO_Probability */
static int hf_xnap_candidate_pscells;             /* CPACcandidatePSCells_list */
static int hf_xnap_cpc_target_sn_required_list;   /* CPC_target_SN_required_list */
static int hf_xnap_CPC_target_SN_required_list_item;  /* CPC_target_SN_required_list_Item */
static int hf_xnap_cpc_indicator;                 /* CPCindicator */
static int hf_xnap_sN_to_MN_Container;            /* T_sN_to_MN_Container */
static int hf_xnap_cpc_target_sn_confirm_list;    /* CPC_target_SN_confirm_list */
static int hf_xnap_CPC_target_SN_confirm_list_item;  /* CPC_target_SN_confirm_list_Item */
static int hf_xnap_max_no_of_pscells_01;          /* INTEGER_1_8_ */
static int hf_xnap_cpc_target_sn_list;            /* CPC_target_SN_mod_list */
static int hf_xnap_CPC_target_SN_mod_list_item;   /* CPC_target_SN_mod_item */
static int hf_xnap_candidate_pscells_01;          /* CPCInformationUpdatePSCells_list */
static int hf_xnap_CPCInformationUpdatePSCells_list_item;  /* CPCInformationUpdatePSCells_item */
static int hf_xnap_procedureCode;                 /* ProcedureCode */
static int hf_xnap_triggeringMessage;             /* TriggeringMessage */
static int hf_xnap_procedureCriticality;          /* Criticality */
static int hf_xnap_iEsCriticalityDiagnostics;     /* CriticalityDiagnostics_IE_List */
static int hf_xnap_CriticalityDiagnostics_IE_List_item;  /* CriticalityDiagnostics_IE_List_item */
static int hf_xnap_iECriticality;                 /* Criticality */
static int hf_xnap_iE_ID;                         /* ProtocolIE_ID */
static int hf_xnap_typeOfError;                   /* TypeOfError */
static int hf_xnap_CSI_RS_MTC_Configuration_List_item;  /* CSI_RS_MTC_Configuration_Item */
static int hf_xnap_csi_RS_Index;                  /* INTEGER_0_95 */
static int hf_xnap_csi_RS_Status;                 /* T_csi_RS_Status */
static int hf_xnap_csi_RS_Neighbour_List;         /* CSI_RS_Neighbour_List */
static int hf_xnap_CSI_RS_Neighbour_List_item;    /* CSI_RS_Neighbour_Item */
static int hf_xnap_nr_cgi;                        /* NR_CGI */
static int hf_xnap_csi_RS_MTC_Neighbour_List;     /* CSI_RS_MTC_Neighbour_List */
static int hf_xnap_CSI_RS_MTC_Neighbour_List_item;  /* CSI_RS_MTC_Neighbour_Item */
static int hf_xnap_CAGListforMDT_item;            /* CAGListforMDTItem */
static int hf_xnap_plmnID;                        /* PLMN_Identity */
static int hf_xnap_cAGID;                         /* CAG_Identifier */
static int hf_xnap_XnUAddressInfoperPDUSession_List_item;  /* XnUAddressInfoperPDUSession_Item */
static int hf_xnap_pduSession_ID;                 /* PDUSession_ID */
static int hf_xnap_dataForwardingInfoFromTargetNGRANnode;  /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_pduSessionResourceSetupCompleteInfo_SNterm;  /* PDUSessionResourceBearerSetupCompleteInfo_SNterminated */
static int hf_xnap_dataForwardingInfoFromTargetE_UTRANnode_List;  /* DataForwardingInfoFromTargetE_UTRANnode_List */
static int hf_xnap_DataForwardingInfoFromTargetE_UTRANnode_List_item;  /* DataForwardingInfoFromTargetE_UTRANnode_Item */
static int hf_xnap_dlForwardingUPTNLInformation;  /* UPTransportLayerInformation */
static int hf_xnap_qosFlowsToBeForwarded_List;    /* QoSFlowsToBeForwarded_List */
static int hf_xnap_QoSFlowsToBeForwarded_List_item;  /* QoSFlowsToBeForwarded_Item */
static int hf_xnap_qosFlowIdentifier;             /* QoSFlowIdentifier */
static int hf_xnap_qosFlowsAcceptedForDataForwarding_List;  /* QoSFLowsAcceptedToBeForwarded_List */
static int hf_xnap_pduSessionLevelDLDataForwardingInfo;  /* UPTransportLayerInformation */
static int hf_xnap_pduSessionLevelULDataForwardingInfo;  /* UPTransportLayerInformation */
static int hf_xnap_dataForwardingResponseDRBItemList;  /* DataForwardingResponseDRBItemList */
static int hf_xnap_QoSFLowsAcceptedToBeForwarded_List_item;  /* QoSFLowsAcceptedToBeForwarded_Item */
static int hf_xnap_qosFlowsToBeForwarded;         /* QoSFLowsToBeForwarded_List */
static int hf_xnap_sourceDRBtoQoSFlowMapping;     /* DRBToQoSFlowMapping_List */
static int hf_xnap_QoSFLowsToBeForwarded_List_item;  /* QoSFLowsToBeForwarded_Item */
static int hf_xnap_dl_dataforwarding;             /* DLForwarding */
static int hf_xnap_ul_dataforwarding;             /* ULForwarding */
static int hf_xnap_DataForwardingResponseDRBItemList_item;  /* DataForwardingResponseDRBItem */
static int hf_xnap_drb_ID;                        /* DRB_ID */
static int hf_xnap_dlForwardingUPTNL;             /* UPTransportLayerInformation */
static int hf_xnap_ulForwardingUPTNL;             /* UPTransportLayerInformation */
static int hf_xnap_activationSFN;                 /* ActivationSFN */
static int hf_xnap_sharedResourceType;            /* SharedResourceType */
static int hf_xnap_reservedSubframePattern;       /* ReservedSubframePattern */
static int hf_xnap_dapsIndicator;                 /* T_dapsIndicator */
static int hf_xnap_DAPSResponseInfo_List_item;    /* DAPSResponseInfo_Item */
static int hf_xnap_drbID;                         /* DRB_ID */
static int hf_xnap_dapsResponseIndicator;         /* T_dapsResponseIndicator */
static int hf_xnap_count12bits;                   /* COUNT_PDCP_SN12 */
static int hf_xnap_count18bits;                   /* COUNT_PDCP_SN18 */
static int hf_xnap_egressBAPRoutingID;            /* BAPRoutingID */
static int hf_xnap_egressBHRLCCHID;               /* BHRLCChannelID */
static int hf_xnap_DLLBTFailureInformationList_item;  /* DLLBTFailureInformationList_Item */
static int hf_xnap_uEAssistantIdentifier;         /* NG_RANnodeUEXnAPID */
static int hf_xnap_numberOfDLLBTFailures;         /* INTEGER_1_1000_ */
static int hf_xnap_ingressBAPRoutingID;           /* BAPRoutingID */
static int hf_xnap_ingressBHRLCCHID;              /* BHRLCChannelID */
static int hf_xnap_priorhopBAPAddress;            /* BAPAddress */
static int hf_xnap_iabqosMappingInformation;      /* IAB_QoS_Mapping_Information */
static int hf_xnap_DRB_List_item;                 /* DRB_ID */
static int hf_xnap_DRB_List_withCause_item;       /* DRB_List_withCause_Item */
static int hf_xnap_drb_id;                        /* DRB_ID */
static int hf_xnap_rLC_Mode;                      /* RLCMode */
static int hf_xnap_DRBsSubjectToDLDiscarding_List_item;  /* DRBsSubjectToDLDiscarding_Item */
static int hf_xnap_dlCount;                       /* DLCountChoice */
static int hf_xnap_DRBsSubjectToEarlyStatusTransfer_List_item;  /* DRBsSubjectToEarlyStatusTransfer_Item */
static int hf_xnap_DRBsSubjectToStatusTransfer_List_item;  /* DRBsSubjectToStatusTransfer_Item */
static int hf_xnap_pdcpStatusTransfer_UL;         /* DRBBStatusTransferChoice */
static int hf_xnap_pdcpStatusTransfer_DL;         /* DRBBStatusTransferChoice */
static int hf_xnap_pdcp_sn_12bits;                /* DRBBStatusTransfer12bitsSN */
static int hf_xnap_pdcp_sn_18bits;                /* DRBBStatusTransfer18bitsSN */
static int hf_xnap_receiveStatusofPDCPSDU;        /* BIT_STRING_SIZE_1_2048 */
static int hf_xnap_cOUNTValue;                    /* COUNT_PDCP_SN12 */
static int hf_xnap_receiveStatusofPDCPSDU_01;     /* BIT_STRING_SIZE_1_131072 */
static int hf_xnap_cOUNTValue_01;                 /* COUNT_PDCP_SN18 */
static int hf_xnap_DRBToQoSFlowMapping_List_item;  /* DRBToQoSFlowMapping_Item */
static int hf_xnap_qosFlows_List;                 /* QoSFlows_List */
static int hf_xnap_DUF_Slot_Config_List_item;     /* DUF_Slot_Config_Item */
static int hf_xnap_explicitFormat;                /* ExplicitFormat */
static int hf_xnap_implicitFormat;                /* ImplicitFormat */
static int hf_xnap_priorityLevelQoS;              /* PriorityLevelQoS */
static int hf_xnap_fiveQI;                        /* FiveQI */
static int hf_xnap_delayCritical;                 /* T_delayCritical */
static int hf_xnap_averagingWindow;               /* AveragingWindow */
static int hf_xnap_maximumDataBurstVolume;        /* MaximumDataBurstVolume */
static int hf_xnap_eCNMarkingAtRANRequest;        /* ECNMarkingAtRANRequest */
static int hf_xnap_eCNMarkingAtUPFRequest;        /* ECNMarkingAtUPFRequest */
static int hf_xnap_congestionInformationRequest;  /* CongestionInformationRequest */
static int hf_xnap_choice_Extensions;             /* ProtocolIE_Single_Container */
static int hf_xnap_EquivalentSNPNs_item;          /* SNPNIdentity */
static int hf_xnap_e_utra_CI;                     /* E_UTRA_Cell_Identity */
static int hf_xnap_E_UTRAMultibandInfoList_item;  /* E_UTRAFrequencyBandIndicator */
static int hf_xnap_eutrapaging_eDRX_Cycle;        /* EUTRAPaging_eDRX_Cycle */
static int hf_xnap_eutrapaging_Time_Window;       /* EUTRAPaging_Time_Window */
static int hf_xnap_rootSequenceIndex;             /* INTEGER_0_837 */
static int hf_xnap_zeroCorrelationIndex;          /* INTEGER_0_15 */
static int hf_xnap_highSpeedFlag;                 /* T_highSpeedFlag */
static int hf_xnap_prach_FreqOffset;              /* INTEGER_0_94 */
static int hf_xnap_prach_ConfigIndex;             /* INTEGER_0_63 */
static int hf_xnap_portNumber;                    /* PortNumber */
static int hf_xnap_loggedEventTriggeredConfig;    /* LoggedEventTriggeredConfig */
static int hf_xnap_outOfCoverage;                 /* T_outOfCoverage */
static int hf_xnap_eventL1;                       /* EventL1 */
static int hf_xnap_l1Threshold;                   /* MeasurementThresholdL1LoggedMDT */
static int hf_xnap_hysteresis;                    /* Hysteresis */
static int hf_xnap_timeToTrigger;                 /* TimeToTrigger */
static int hf_xnap_threshold_RSRP;                /* Threshold_RSRP */
static int hf_xnap_threshold_RSRQ;                /* Threshold_RSRQ */
static int hf_xnap_ExcessPacketDelayThresholdConfiguration_item;  /* ExcessPacketDelayThresholdItem */
static int hf_xnap_excessPacketDelayThresholdValue;  /* ExcessPacketDelayThresholdValue */
static int hf_xnap_expectedActivityPeriod;        /* ExpectedActivityPeriod */
static int hf_xnap_expectedIdlePeriod;            /* ExpectedIdlePeriod */
static int hf_xnap_sourceOfUEActivityBehaviourInformation;  /* SourceOfUEActivityBehaviourInformation */
static int hf_xnap_expectedUEActivityBehaviour;   /* ExpectedUEActivityBehaviour */
static int hf_xnap_expectedHOInterval;            /* ExpectedHOInterval */
static int hf_xnap_expectedUEMobility;            /* ExpectedUEMobility */
static int hf_xnap_expectedUEMovingTrajectory;    /* ExpectedUEMovingTrajectory */
static int hf_xnap_ExpectedUEMovingTrajectory_item;  /* ExpectedUEMovingTrajectoryItem */
static int hf_xnap_nGRAN_CGI;                     /* GlobalNG_RANCell_ID */
static int hf_xnap_timeStayedInCell;              /* INTEGER_0_4095 */
static int hf_xnap_permutation;                   /* Permutation */
static int hf_xnap_noofDownlinkSymbols;           /* INTEGER_0_14 */
static int hf_xnap_noofUplinkSymbols;             /* INTEGER_0_14 */
static int hf_xnap_primaryRATRestriction;         /* T_primaryRATRestriction */
static int hf_xnap_secondaryRATRestriction;       /* T_secondaryRATRestriction */
static int hf_xnap_ExtendedSliceSupportList_item;  /* S_NSSAI */
static int hf_xnap_ExtTLAs_item;                  /* ExtTLA_Item */
static int hf_xnap_iPsecTLA;                      /* TransportLayerAddress */
static int hf_xnap_gTPTransportLayerAddresses;    /* GTPTLAs */
static int hf_xnap_GTPTLAs_item;                  /* GTPTLA_Item */
static int hf_xnap_gTPTransportLayerAddresses_01;  /* TransportLayerAddress */
static int hf_xnap_f1TerminatingBHInformation_List;  /* F1TerminatingBHInformation_List */
static int hf_xnap_F1TerminatingBHInformation_List_item;  /* F1TerminatingBHInformation_Item */
static int hf_xnap_dLTNLAddress;                  /* IABTNLAddress */
static int hf_xnap_dlF1TerminatingBHInfo;         /* DLF1Terminating_BHInfo */
static int hf_xnap_ulF1TerminatingBHInfo;         /* ULF1Terminating_BHInfo */
static int hf_xnap_fiveGproSeDirectDiscovery;     /* FiveGProSeDirectDiscovery */
static int hf_xnap_fiveGproSeDirectCommunication;  /* FiveGProSeDirectCommunication */
static int hf_xnap_fiveGnrProSeLayer2UEtoNetworkRelay;  /* FiveGProSeLayer2UEtoNetworkRelay */
static int hf_xnap_fiveGnrProSeLayer3UEtoNetworkRelay;  /* FiveGProSeLayer3UEtoNetworkRelay */
static int hf_xnap_fiveGnrProSeLayer2RemoteUE;    /* FiveGProSeLayer2RemoteUE */
static int hf_xnap_fiveGProSepc5QoSFlowList;      /* FiveGProSePC5QoSFlowList */
static int hf_xnap_fiveGproSepc5LinkAggregateBitRates;  /* BitRate */
static int hf_xnap_FiveGProSePC5QoSFlowList_item;  /* FiveGProSePC5QoSFlowItem */
static int hf_xnap_fiveGproSepQI;                 /* FiveQI */
static int hf_xnap_fiveGproSepc5FlowBitRates;     /* FiveGProSePC5FlowBitRates */
static int hf_xnap_fiveGproSerange;               /* Range */
static int hf_xnap_fiveGproSeguaranteedFlowBitRate;  /* BitRate */
static int hf_xnap_fiveGproSemaximumFlowBitRate;  /* BitRate */
static int hf_xnap_Flows_Mapped_To_DRB_List_item;  /* Flows_Mapped_To_DRB_Item */
static int hf_xnap_qoSFlowIdentifier;             /* QoSFlowIdentifier */
static int hf_xnap_qoSFlowLevelQoSParameters;     /* QoSFlowLevelQoSParameters */
static int hf_xnap_qoSFlowMappingIndication;      /* QoSFlowMappingIndication */
static int hf_xnap_FreqDomainHSNAconfiguration_List_item;  /* FreqDomainHSNAconfiguration_List_Item */
static int hf_xnap_rBsetIndex;                    /* INTEGER_0_maxnoofRBsetsPerCell1_ */
static int hf_xnap_freqDomainSlotHSNAconfiguration_List;  /* FreqDomainSlotHSNAconfiguration_List */
static int hf_xnap_FreqDomainSlotHSNAconfiguration_List_item;  /* FreqDomainSlotHSNAconfiguration_List_Item */
static int hf_xnap_slotIndex;                     /* INTEGER_1_maxnoofHSNASlots */
static int hf_xnap_hSNADownlink;                  /* HSNADownlink */
static int hf_xnap_hSNAUplink;                    /* HSNAUplink */
static int hf_xnap_hSNAFlexible;                  /* HSNAFlexible */
static int hf_xnap_maxFlowBitRateDL;              /* BitRate */
static int hf_xnap_maxFlowBitRateUL;              /* BitRate */
static int hf_xnap_notificationControl;           /* T_notificationControl */
static int hf_xnap_maxPacketLossRateDL;           /* PacketLossRate */
static int hf_xnap_maxPacketLossRateUL;           /* PacketLossRate */
static int hf_xnap_gnb_id;                        /* GNB_ID_Choice */
static int hf_xnap_subcarrierSpacing;             /* SSB_subcarrierSpacing */
static int hf_xnap_dUFTransmissionPeriodicity;    /* DUFTransmissionPeriodicity */
static int hf_xnap_dUF_Slot_Config_List;          /* DUF_Slot_Config_List */
static int hf_xnap_hSNATransmissionPeriodicity;   /* HSNATransmissionPeriodicity */
static int hf_xnap_hNSASlotConfigList;            /* HSNASlotConfigList */
static int hf_xnap_rBsetConfiguration;            /* RBsetConfiguration */
static int hf_xnap_freqDomainHSNAconfiguration_List;  /* FreqDomainHSNAconfiguration_List */
static int hf_xnap_nACellResourceConfigurationList;  /* NACellResourceConfigurationList */
static int hf_xnap_gnb_ID;                        /* BIT_STRING_SIZE_22_32 */
static int hf_xnap_ssbAreaRadioResourceStatus_List;  /* SSBAreaRadioResourceStatus_List */
static int hf_xnap_cell_type;                     /* Cell_Type_Choice */
static int hf_xnap_enb_id;                        /* ENB_ID_Choice */
static int hf_xnap_enb_ID_macro;                  /* BIT_STRING_SIZE_20 */
static int hf_xnap_enb_ID_shortmacro;             /* BIT_STRING_SIZE_18 */
static int hf_xnap_enb_ID_longmacro;              /* BIT_STRING_SIZE_21 */
static int hf_xnap_ng_RAN_Cell_id;                /* NG_RAN_Cell_Identity */
static int hf_xnap_gNB;                           /* GlobalgNB_ID */
static int hf_xnap_ng_eNB;                        /* GlobalngeNB_ID */
static int hf_xnap_tnl_address;                   /* TransportLayerAddress */
static int hf_xnap_gtp_teid;                      /* GTP_TEID */
static int hf_xnap_amf_set_id;                    /* BIT_STRING_SIZE_10 */
static int hf_xnap_amf_pointer;                   /* BIT_STRING_SIZE_6 */
static int hf_xnap_HSNASlotConfigList_item;       /* HSNASlotConfigItem */
static int hf_xnap_nRCGI;                         /* NR_CGI */
static int hf_xnap_iAB_DU_Cell_Resource_Configuration_Mode_Info;  /* IAB_DU_Cell_Resource_Configuration_Mode_Info */
static int hf_xnap_iAB_STC_Info;                  /* IAB_STC_Info */
static int hf_xnap_rACH_Config_Common;            /* RACH_Config_Common */
static int hf_xnap_rACH_Config_Common_IAB;        /* RACH_Config_Common_IAB */
static int hf_xnap_cSI_RS_Configuration;          /* T_cSI_RS_Configuration */
static int hf_xnap_sR_Configuration;              /* T_sR_Configuration */
static int hf_xnap_pDCCH_ConfigSIB1;              /* T_pDCCH_ConfigSIB1 */
static int hf_xnap_sCS_Common;                    /* T_sCS_Common */
static int hf_xnap_multiplexingInfo;              /* MultiplexingInfo */
static int hf_xnap_tDD;                           /* IAB_DU_Cell_Resource_Configuration_TDD_Info */
static int hf_xnap_fDD;                           /* IAB_DU_Cell_Resource_Configuration_FDD_Info */
static int hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_UL;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_DL;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_uLFrequencyInfo;               /* NRFrequencyInfo */
static int hf_xnap_dLFrequencyInfo;               /* NRFrequencyInfo */
static int hf_xnap_uLTransmissionBandwidth;       /* NRTransmissionBandwidth */
static int hf_xnap_dlTransmissionBandwidth;       /* NRTransmissionBandwidth */
static int hf_xnap_uLCarrierList;                 /* NRCarrierList */
static int hf_xnap_dlCarrierList;                 /* NRCarrierList */
static int hf_xnap_gNB_DU_Cell_Resource_Configuration_TDD;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_frequencyInfo;                 /* NRFrequencyInfo */
static int hf_xnap_transmissionBandwidth;         /* NRTransmissionBandwidth */
static int hf_xnap_carrierList;                   /* NRCarrierList */
static int hf_xnap_IAB_MT_Cell_List_item;         /* IAB_MT_Cell_List_Item */
static int hf_xnap_nRCellIdentity;                /* NR_Cell_Identity */
static int hf_xnap_dU_RX_MT_RX;                   /* DU_RX_MT_RX */
static int hf_xnap_dU_TX_MT_TX;                   /* DU_TX_MT_TX */
static int hf_xnap_dU_RX_MT_TX;                   /* DU_RX_MT_TX */
static int hf_xnap_dU_TX_MT_RX;                   /* DU_TX_MT_RX */
static int hf_xnap_dscp;                          /* BIT_STRING_SIZE_6 */
static int hf_xnap_flow_label;                    /* BIT_STRING_SIZE_20 */
static int hf_xnap_iAB_STC_Info_List;             /* IAB_STC_Info_List */
static int hf_xnap_IAB_STC_Info_List_item;        /* IAB_STC_Info_Item */
static int hf_xnap_sSB_freqInfo;                  /* SSB_freqInfo */
static int hf_xnap_sSB_subcarrierSpacing;         /* SSB_subcarrierSpacing */
static int hf_xnap_sSB_transmissionPeriodicity;   /* SSB_transmissionPeriodicity */
static int hf_xnap_sSB_transmissionTimingOffset;  /* SSB_transmissionTimingOffset */
static int hf_xnap_sSB_transmissionBitmap;        /* SSB_transmissionBitmap */
static int hf_xnap_iABIPv4AddressesRequested;     /* IABTNLAddressesRequested */
static int hf_xnap_iABIPv6RequestType;            /* IABIPv6RequestType */
static int hf_xnap_iABTNLAddressToRemove_List;    /* IABTNLAddressToRemove_List */
static int hf_xnap_iPv6Address;                   /* IABTNLAddressesRequested */
static int hf_xnap_iPv6Prefix;                    /* IABTNLAddressesRequested */
static int hf_xnap_iABAllocatedTNLAddress_List;   /* IABAllocatedTNLAddress_List */
static int hf_xnap_IABAllocatedTNLAddress_List_item;  /* IABAllocatedTNLAddress_Item */
static int hf_xnap_iABTNLAddress;                 /* IABTNLAddress */
static int hf_xnap_iABTNLAddressUsage;            /* IABTNLAddressUsage */
static int hf_xnap_associatedDonorDUAddress;      /* BAPAddress */
static int hf_xnap_iPv4Address;                   /* T_iPv4Address */
static int hf_xnap_iPv6Address_01;                /* T_iPv6Address */
static int hf_xnap_iPv6Prefix_01;                 /* T_iPv6Prefix */
static int hf_xnap_tNLAddressesOrPrefixesRequestedAllTraffic;  /* INTEGER_1_256 */
static int hf_xnap_tNLAddressesOrPrefixesRequestedF1_C;  /* INTEGER_1_256 */
static int hf_xnap_tNLAddressesOrPrefixesRequestedF1_U;  /* INTEGER_1_256 */
static int hf_xnap_tNLAddressesOrPrefixesRequestedNoNF1;  /* INTEGER_1_256 */
static int hf_xnap_IABTNLAddressToRemove_List_item;  /* IABTNLAddressToRemove_Item */
static int hf_xnap_IABTNLAddressException_item;   /* IABTNLAddress_Item */
static int hf_xnap_measurementsToActivate;        /* MeasurementsToActivate */
static int hf_xnap_m1Configuration;               /* M1Configuration */
static int hf_xnap_m4Configuration;               /* M4Configuration */
static int hf_xnap_m5Configuration;               /* M5Configuration */
static int hf_xnap_mDT_Location_Info;             /* MDT_Location_Info */
static int hf_xnap_m6Configuration;               /* M6Configuration */
static int hf_xnap_m7Configuration;               /* M7Configuration */
static int hf_xnap_bluetoothMeasurementConfiguration;  /* BluetoothMeasurementConfiguration */
static int hf_xnap_wLANMeasurementConfiguration;  /* WLANMeasurementConfiguration */
static int hf_xnap_sensorMeasurementConfiguration;  /* SensorMeasurementConfiguration */
static int hf_xnap_dUFSlotformatIndex;            /* DUFSlotformatIndex */
static int hf_xnap_rRCReestab;                    /* RRCReestab_initiated */
static int hf_xnap_rRCSetup;                      /* RRCSetup_initiated */
static int hf_xnap_nrscs;                         /* NRSCS */
static int hf_xnap_nrCyclicPrefix;                /* NRCyclicPrefix */
static int hf_xnap_nrDL_ULTransmissionPeriodicity;  /* NRDL_ULTransmissionPeriodicity */
static int hf_xnap_slotConfiguration_List;        /* SlotConfiguration_List */
static int hf_xnap_i_RNTI_full;                   /* BIT_STRING_SIZE_40 */
static int hf_xnap_i_RNTI_short;                  /* BIT_STRING_SIZE_24 */
static int hf_xnap_full_I_RNTI_Profile_List;      /* Full_I_RNTI_Profile_List */
static int hf_xnap_short_I_RNTI_Profile_List;     /* Short_I_RNTI_Profile_List */
static int hf_xnap_full_I_RNTI_Profile_0;         /* BIT_STRING_SIZE_21 */
static int hf_xnap_full_I_RNTI_Profile_1;         /* BIT_STRING_SIZE_18 */
static int hf_xnap_full_I_RNTI_Profile_2;         /* BIT_STRING_SIZE_15 */
static int hf_xnap_full_I_RNTI_Profile_3;         /* BIT_STRING_SIZE_12 */
static int hf_xnap_short_I_RNTI_Profile_0;        /* BIT_STRING_SIZE_8 */
static int hf_xnap_short_I_RNTI_Profile_1;        /* BIT_STRING_SIZE_6 */
static int hf_xnap_nG_RAN_Cell;                   /* LastVisitedNGRANCellInformation */
static int hf_xnap_e_UTRAN_Cell;                  /* LastVisitedEUTRANCellInformation */
static int hf_xnap_uTRAN_Cell;                    /* LastVisitedUTRANCellInformation */
static int hf_xnap_gERAN_Cell;                    /* LastVisitedGERANCellInformation */
static int hf_xnap_LastVisitedPSCellList_item;    /* LastVisitedPSCellList_Item */
static int hf_xnap_lastVisitedPSCellInformation;  /* LastVisitedPSCellInformation */
static int hf_xnap_lastVisitedPSCellList;         /* LastVisitedPSCellList */
static int hf_xnap_ListOfCells_item;              /* CellsinAoI_Item */
static int hf_xnap_pLMN_Identity;                 /* PLMN_Identity */
static int hf_xnap_ng_ran_cell_id;                /* NG_RAN_Cell_Identity */
static int hf_xnap_ListOfRANNodesinAoI_item;      /* GlobalNG_RANNodesinAoI_Item */
static int hf_xnap_global_NG_RAN_Node_ID;         /* GlobalNG_RANNode_ID */
static int hf_xnap_ListOfTAIsinAoI_item;          /* TAIsinAoI_Item */
static int hf_xnap_tAC;                           /* TAC */
static int hf_xnap_eventType;                     /* EventType */
static int hf_xnap_reportArea;                    /* ReportArea */
static int hf_xnap_areaOfInterest;                /* AreaOfInterestInformation */
static int hf_xnap_eventTypeTrigger;              /* EventTypeTrigger */
static int hf_xnap_loggingInterval;               /* LoggingInterval */
static int hf_xnap_loggingDuration;               /* LoggingDuration */
static int hf_xnap_reportType;                    /* ReportType */
static int hf_xnap_areaScopeOfNeighCellsList;     /* AreaScopeOfNeighCellsList */
static int hf_xnap_aerialUE;                      /* AerialUE */
static int hf_xnap_aerialControllerUE;            /* AerialControllerUE */
static int hf_xnap_vehicleUE;                     /* VehicleUE */
static int hf_xnap_pedestrianUE;                  /* PedestrianUE */
static int hf_xnap_uESidelinkAggregateMaximumBitRate;  /* BitRate */
static int hf_xnap_s_BasedMDT;                    /* S_BasedMDT */
static int hf_xnap_m1reportingTrigger;            /* M1ReportingTrigger */
static int hf_xnap_m1thresholdeventA2;            /* M1ThresholdEventA2 */
static int hf_xnap_m1periodicReporting;           /* M1PeriodicReporting */
static int hf_xnap_reportInterval;                /* ReportIntervalMDT */
static int hf_xnap_reportAmount;                  /* ReportAmountMDT */
static int hf_xnap_measurementThreshold;          /* MeasurementThresholdA2 */
static int hf_xnap_m4period;                      /* M4period */
static int hf_xnap_m4_links_to_log;               /* Links_to_log */
static int hf_xnap_m5period;                      /* M5period */
static int hf_xnap_m5_links_to_log;               /* Links_to_log */
static int hf_xnap_m6report_Interval;             /* M6report_Interval */
static int hf_xnap_m6_links_to_log;               /* Links_to_log */
static int hf_xnap_m7period;                      /* M7period */
static int hf_xnap_m7_links_to_log;               /* Links_to_log */
static int hf_xnap_maxIPrate_UL;                  /* MaxIPrate */
static int hf_xnap_oneframe;                      /* BIT_STRING_SIZE_6 */
static int hf_xnap_fourframes;                    /* BIT_STRING_SIZE_24 */
static int hf_xnap_MBSFNSubframeInfo_E_UTRA_item;  /* MBSFNSubframeInfo_E_UTRA_Item */
static int hf_xnap_radioframeAllocationPeriod;    /* T_radioframeAllocationPeriod */
static int hf_xnap_radioframeAllocationOffset;    /* INTEGER_0_7_ */
static int hf_xnap_subframeAllocation;            /* MBSFNSubframeAllocation_E_UTRA */
static int hf_xnap_MBS_MappingandDataForwardingRequestInfofromSource_item;  /* MBS_MappingandDataForwardingRequestInfofromSource_Item */
static int hf_xnap_mRB_ID;                        /* MRB_ID */
static int hf_xnap_mBS_QoSFlow_List;              /* MBS_QoSFlow_List */
static int hf_xnap_mRB_ProgressInformation;       /* MRB_ProgressInformation */
static int hf_xnap_MBS_DataForwardingResponseInfofromTarget_item;  /* MBS_DataForwardingResponseInfofromTarget_Item */
static int hf_xnap_MBS_QoSFlow_List_item;         /* QoSFlowIdentifier */
static int hf_xnap_MBS_QoSFlowsToAdd_List_item;   /* MBS_QoSFlowsToAdd_Item */
static int hf_xnap_mBS_QosFlowIdentifier;         /* QoSFlowIdentifier */
static int hf_xnap_mBS_QosFlowLevelQosParameters;  /* QoSFlowLevelQoSParameters */
static int hf_xnap_locationindependent;           /* MBS_ServiceAreaInformation */
static int hf_xnap_locationdependent;             /* MBS_ServiceAreaInformationList */
static int hf_xnap_MBS_ServiceAreaCell_List_item;  /* NR_CGI */
static int hf_xnap_mBS_ServiceAreaCell_List;      /* MBS_ServiceAreaCell_List */
static int hf_xnap_mBS_ServiceAreaTAI_List;       /* MBS_ServiceAreaTAI_List */
static int hf_xnap_MBS_ServiceAreaInformationList_item;  /* MBS_ServiceAreaInformation_Item */
static int hf_xnap_mBS_Area_Session_ID;           /* MBS_Area_Session_ID */
static int hf_xnap_mBS_ServiceAreaInformation;    /* MBS_ServiceAreaInformation */
static int hf_xnap_MBS_ServiceAreaTAI_List_item;  /* MBS_ServiceAreaTAI_Item */
static int hf_xnap_tMGI;                          /* TMGI */
static int hf_xnap_nID;                           /* NID */
static int hf_xnap_MBS_SessionAssociatedInformation_item;  /* MBS_SessionAssociatedInformation_Item */
static int hf_xnap_mBS_Session_ID;                /* MBS_Session_ID */
static int hf_xnap_associated_QoSFlowInfo_List;   /* Associated_QoSFlowInfo_List */
static int hf_xnap_MBS_SessionInformation_List_item;  /* MBS_SessionInformation_Item */
static int hf_xnap_active_MBS_SessioInformation;  /* Active_MBS_SessionInformation */
static int hf_xnap_MBS_SessionInformationResponse_List_item;  /* MBS_SessionInformationResponse_Item */
static int hf_xnap_mBS_DataForwardingResponseInfofromTarget;  /* MBS_DataForwardingResponseInfofromTarget */
static int hf_xnap_mDT_Configuration_NR;          /* MDT_Configuration_NR */
static int hf_xnap_mDT_Configuration_EUTRA;       /* MDT_Configuration_EUTRA */
static int hf_xnap_mdt_Activation;                /* MDT_Activation */
static int hf_xnap_areaScopeOfMDT_NR;             /* AreaScopeOfMDT_NR */
static int hf_xnap_mDTMode_NR;                    /* MDTMode_NR */
static int hf_xnap_signallingBasedMDTPLMNList;    /* MDTPLMNList */
static int hf_xnap_areaScopeOfMDT_EUTRA;          /* AreaScopeOfMDT_EUTRA */
static int hf_xnap_mDTMode_EUTRA;                 /* MDTMode_EUTRA */
static int hf_xnap_MDTPLMNList_item;              /* PLMN_Identity */
static int hf_xnap_MDTPLMNModificationList_item;  /* PLMN_Identity */
static int hf_xnap_immediateMDT;                  /* ImmediateMDT_NR */
static int hf_xnap_loggedMDT;                     /* LoggedMDT_NR */
static int hf_xnap_mDTMode_NR_Extension;          /* MDTMode_NR_Extension */
static int hf_xnap_threshold_SINR;                /* Threshold_SINR */
static int hf_xnap_dl_GBR_PRB_usage_for_MIMO;     /* DL_GBR_PRB_usage_for_MIMO */
static int hf_xnap_ul_GBR_PRB_usage_for_MIMO;     /* UL_GBR_PRB_usage_for_MIMO */
static int hf_xnap_dl_non_GBR_PRB_usage_for_MIMO;  /* DL_non_GBR_PRB_usage_for_MIMO */
static int hf_xnap_ul_non_GBR_PRB_usage_for_MIMO;  /* UL_non_GBR_PRB_usage_for_MIMO */
static int hf_xnap_dl_Total_PRB_usage_for_MIMO;   /* DL_Total_PRB_usage_for_MIMO */
static int hf_xnap_ul_Total_PRB_usage_for_MIMO;   /* UL_Total_PRB_usage_for_MIMO */
static int hf_xnap_handoverTriggerChangeLowerLimit;  /* INTEGER_M20_20 */
static int hf_xnap_handoverTriggerChangeUpperLimit;  /* INTEGER_M20_20 */
static int hf_xnap_handoverTriggerChange;         /* INTEGER_M20_20 */
static int hf_xnap_serving_PLMN;                  /* PLMN_Identity */
static int hf_xnap_equivalent_PLMNs;              /* SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity */
static int hf_xnap_equivalent_PLMNs_item;         /* PLMN_Identity */
static int hf_xnap_rat_Restrictions;              /* RAT_RestrictionsList */
static int hf_xnap_forbiddenAreaInformation;      /* ForbiddenAreaList */
static int hf_xnap_serviceAreaInformation;        /* ServiceAreaList */
static int hf_xnap_CNTypeRestrictionsForEquivalent_item;  /* CNTypeRestrictionsForEquivalentItem */
static int hf_xnap_plmn_Identity;                 /* PLMN_Identity */
static int hf_xnap_cn_Type;                       /* T_cn_Type */
static int hf_xnap_RAT_RestrictionsList_item;     /* RAT_RestrictionsItem */
static int hf_xnap_rat_RestrictionInformation;    /* RAT_RestrictionInformation */
static int hf_xnap_ForbiddenAreaList_item;        /* ForbiddenAreaItem */
static int hf_xnap_forbidden_TACs;                /* SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC */
static int hf_xnap_forbidden_TACs_item;           /* TAC */
static int hf_xnap_ServiceAreaList_item;          /* ServiceAreaItem */
static int hf_xnap_allowed_TACs_ServiceArea;      /* SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC */
static int hf_xnap_allowed_TACs_ServiceArea_item;  /* TAC */
static int hf_xnap_not_allowed_TACs_ServiceArea;  /* SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC */
static int hf_xnap_not_allowed_TACs_ServiceArea_item;  /* TAC */
static int hf_xnap_ng_RAN_Node_ResourceCoordinationInfo;  /* NG_RAN_Node_ResourceCoordinationInfo */
static int hf_xnap_eutra_resource_coordination_info;  /* E_UTRA_ResourceCoordinationInfo */
static int hf_xnap_nr_resource_coordination_info;  /* NR_ResourceCoordinationInfo */
static int hf_xnap_e_utra_cell;                   /* E_UTRA_CGI */
static int hf_xnap_ul_coordination_info;          /* BIT_STRING_SIZE_6_4400 */
static int hf_xnap_dl_coordination_info;          /* BIT_STRING_SIZE_6_4400 */
static int hf_xnap_nr_cell;                       /* NR_CGI */
static int hf_xnap_e_utra_coordination_assistance_info;  /* E_UTRA_CoordinationAssistanceInfo */
static int hf_xnap_nr_coordination_assistance_info;  /* NR_CoordinationAssistanceInfo */
static int hf_xnap_mT_SDT_Indicator;              /* MT_SDT_Indicator */
static int hf_xnap_mT_SDT_DataSize;               /* MT_SDT_DataSize */
static int hf_xnap_iAB_MT_Cell_List;              /* IAB_MT_Cell_List */
static int hf_xnap_MeasuredUETrajectory_item;     /* MeasuredUETrajectory_Item */
static int hf_xnap_measuredtrajectoryCellInfo;    /* MeasuredTrajectoryCellInfo */
static int hf_xnap_nG_RAN_Cell_01;                /* MeasuredTrajectoryNGRANCellInfo */
static int hf_xnap_globalNG_RANCell_ID_01;        /* GlobalNG_RANCell_ID */
static int hf_xnap_timeUEStaysInCell;             /* INTEGER_0_4095 */
static int hf_xnap_n6JitterLowerBound;            /* INTEGER_M127_127 */
static int hf_xnap_n6JitterUpperBound;            /* INTEGER_M127_127 */
static int hf_xnap_NACellResourceConfigurationList_item;  /* NACellResourceConfiguration_Item */
static int hf_xnap_nAdownlink;                    /* T_nAdownlink */
static int hf_xnap_nAuplink;                      /* T_nAuplink */
static int hf_xnap_nAflexible;                    /* T_nAflexible */
static int hf_xnap_subframeAssignment;            /* T_subframeAssignment */
static int hf_xnap_harqOffset;                    /* INTEGER_0_9 */
static int hf_xnap_NeighbourInformation_E_UTRA_item;  /* NeighbourInformation_E_UTRA_Item */
static int hf_xnap_e_utra_PCI;                    /* E_UTRAPCI */
static int hf_xnap_e_utra_cgi;                    /* E_UTRA_CGI */
static int hf_xnap_earfcn;                        /* E_UTRAARFCN */
static int hf_xnap_NeighbourInformation_NR_item;  /* NeighbourInformation_NR_Item */
static int hf_xnap_nr_PCI;                        /* NRPCI */
static int hf_xnap_nr_mode_info;                  /* NeighbourInformation_NR_ModeInfo */
static int hf_xnap_connectivitySupport;           /* Connectivity_Support */
static int hf_xnap_measurementTimingConfiguration;  /* T_measurementTimingConfiguration */
static int hf_xnap_fdd_info;                      /* NeighbourInformation_NR_ModeFDDInfo */
static int hf_xnap_tdd_info;                      /* NeighbourInformation_NR_ModeTDDInfo */
static int hf_xnap_ul_NR_FreqInfo;                /* NRFrequencyInfo */
static int hf_xnap_dl_NR_FequInfo;                /* NRFrequencyInfo */
static int hf_xnap_ie_Extensions;                 /* ProtocolExtensionContainer */
static int hf_xnap_nr_FreqInfo;                   /* NRFrequencyInfo */
static int hf_xnap_Neighbour_NG_RAN_Node_List_item;  /* Neighbour_NG_RAN_Node_Item */
static int hf_xnap_globalNG_RANNodeID;            /* GlobalNG_RANNode_ID */
static int hf_xnap_local_NG_RAN_Node_Identifier;  /* Local_NG_RAN_Node_Identifier */
static int hf_xnap_NRCarrierList_item;            /* NRCarrierItem */
static int hf_xnap_carrierSCS;                    /* NRSCS */
static int hf_xnap_offsetToCarrier;               /* INTEGER_0_2199_ */
static int hf_xnap_carrierBandwidth;              /* INTEGER_0_maxnoofPhysicalResourceBlocks_ */
static int hf_xnap_nr;                            /* NR_Cell_Identity */
static int hf_xnap_e_utra;                        /* E_UTRA_Cell_Identity */
static int hf_xnap_nr_01;                         /* NRPCI */
static int hf_xnap_e_utra_01;                     /* E_UTRAPCI */
static int hf_xnap_NG_RANnode2SSBOffsetsModificationRange_item;  /* SSBOffsetModificationRange */
static int hf_xnap_energyCost;                    /* EnergyCost */
static int hf_xnap_NodeMeasurementInitiationResult_List_item;  /* NodeMeasurementInitiationResult_Item */
static int hf_xnap_nodemeasurementFailedReportCharacteristics;  /* T_nodemeasurementFailedReportCharacteristics */
static int hf_xnap_dL_GBR_PRB_usage;              /* DL_GBR_PRB_usage */
static int hf_xnap_uL_GBR_PRB_usage;              /* UL_GBR_PRB_usage */
static int hf_xnap_dL_non_GBR_PRB_usage;          /* DL_non_GBR_PRB_usage */
static int hf_xnap_uL_non_GBR_PRB_usage;          /* UL_non_GBR_PRB_usage */
static int hf_xnap_dL_Total_PRB_usage;            /* DL_Total_PRB_usage */
static int hf_xnap_uL_Total_PRB_usage;            /* UL_Total_PRB_usage */
static int hf_xnap_dLTNLOfferedCapacity;          /* OfferedCapacity */
static int hf_xnap_dLTNLAvailableCapacity;        /* AvailableCapacity */
static int hf_xnap_uLTNLOfferedCapacity;          /* OfferedCapacity */
static int hf_xnap_uLTNLAvailableCapacity;        /* AvailableCapacity */
static int hf_xnap_nonF1TerminatingBHInformation_List;  /* NonF1TerminatingBHInformation_List */
static int hf_xnap_bAPControlPDURLCCH_List;       /* BAPControlPDURLCCH_List */
static int hf_xnap_NonF1TerminatingBHInformation_List_item;  /* NonF1TerminatingBHInformation_Item */
static int hf_xnap_dlNon_F1TerminatingBHInfo;     /* DLNonF1Terminating_BHInfo */
static int hf_xnap_ulNon_F1TerminatingBHInfo;     /* ULNonF1Terminating_BHInfo */
static int hf_xnap_nonUPTrafficType;              /* NonUPTrafficType */
static int hf_xnap_controlPlaneTrafficType;       /* ControlPlaneTrafficType */
static int hf_xnap_snpn_Information;              /* NPN_Broadcast_Information_SNPN */
static int hf_xnap_pni_npn_Information;           /* NPN_Broadcast_Information_PNI_NPN */
static int hf_xnap_broadcastSNPNID_List;          /* BroadcastSNPNID_List */
static int hf_xnap_broadcastPNI_NPN_ID_Information;  /* BroadcastPNI_NPN_ID_Information */
static int hf_xnap_snpn_mobility_information;     /* NPNMobilityInformation_SNPN */
static int hf_xnap_pni_npn_mobility_information;  /* NPNMobilityInformation_PNI_NPN */
static int hf_xnap_serving_NID;                   /* NID */
static int hf_xnap_allowedPNI_NPN_ID_List;        /* AllowedPNI_NPN_ID_List */
static int hf_xnap_pni_npn_Information_01;        /* NPNPagingAssistanceInformation_PNI_NPN */
static int hf_xnap_sNPN;                          /* NPN_Support_SNPN */
static int hf_xnap_ie_Extension;                  /* ProtocolExtensionContainer */
static int hf_xnap_fdd_or_tdd;                    /* T_fdd_or_tdd */
static int hf_xnap_fdd;                           /* NPRACHConfiguration_FDD */
static int hf_xnap_tdd;                           /* NPRACHConfiguration_TDD */
static int hf_xnap_nprach_CP_length;              /* NPRACH_CP_Length */
static int hf_xnap_anchorCarrier_NPRACHConfig;    /* T_anchorCarrier_NPRACHConfig */
static int hf_xnap_anchorCarrier_EDT_NPRACHConfig;  /* T_anchorCarrier_EDT_NPRACHConfig */
static int hf_xnap_anchorCarrier_Format2_NPRACHConfig;  /* T_anchorCarrier_Format2_NPRACHConfig */
static int hf_xnap_anchorCarrier_Format2_EDT_NPRACHConfig;  /* T_anchorCarrier_Format2_EDT_NPRACHConfig */
static int hf_xnap_non_anchorCarrier_NPRACHConfig;  /* T_non_anchorCarrier_NPRACHConfig */
static int hf_xnap_non_anchorCarrier_Format2_NPRACHConfig;  /* T_non_anchorCarrier_Format2_NPRACHConfig */
static int hf_xnap_nprach_preambleFormat;         /* NPRACH_preambleFormat */
static int hf_xnap_anchorCarrier_NPRACHConfigTDD;  /* T_anchorCarrier_NPRACHConfigTDD */
static int hf_xnap_non_anchorCarrierFequencyConfiglist;  /* Non_AnchorCarrierFrequencylist */
static int hf_xnap_non_anchorCarrier_NPRACHConfigTDD;  /* T_non_anchorCarrier_NPRACHConfigTDD */
static int hf_xnap_Non_AnchorCarrierFrequencylist_item;  /* Non_AnchorCarrierFrequencylist_item */
static int hf_xnap_non_anchorCarrierFrquency;     /* T_non_anchorCarrierFrquency */
static int hf_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea_item;  /* NG_RAN_Cell_Identity */
static int hf_xnap_NR_U_Channel_List_item;        /* NR_U_Channel_Item */
static int hf_xnap_nR_U_ChannelID;                /* NR_U_ChannelID */
static int hf_xnap_channelOccupancyTimePercentageDL;  /* ChannelOccupancyTimePercentage */
static int hf_xnap_energyDetectionThresholdDL;    /* EnergyDetectionThreshold */
static int hf_xnap_NR_U_ChannelInfo_List_item;    /* NR_U_ChannelInfo_Item */
static int hf_xnap_nRARFCN;                       /* NRARFCN */
static int hf_xnap_bandwidth;                     /* Bandwidth */
static int hf_xnap_NRFrequencyBand_List_item;     /* NRFrequencyBandItem */
static int hf_xnap_nr_frequency_band;             /* NRFrequencyBand */
static int hf_xnap_supported_SUL_Band_List;       /* SupportedSULBandList */
static int hf_xnap_nrARFCN;                       /* NRARFCN */
static int hf_xnap_sul_information;               /* SUL_Information */
static int hf_xnap_frequencyBand_List;            /* NRFrequencyBand_List */
static int hf_xnap_fdd_01;                        /* NRModeInfoFDD */
static int hf_xnap_tdd_01;                        /* NRModeInfoTDD */
static int hf_xnap_ulNRFrequencyInfo;             /* NRFrequencyInfo */
static int hf_xnap_dlNRFrequencyInfo;             /* NRFrequencyInfo */
static int hf_xnap_ulNRTransmissonBandwidth;      /* NRTransmissionBandwidth */
static int hf_xnap_dlNRTransmissonBandwidth;      /* NRTransmissionBandwidth */
static int hf_xnap_nrTransmissonBandwidth;        /* NRTransmissionBandwidth */
static int hf_xnap_nRPaging_eDRX_Cycle;           /* NRPaging_eDRX_Cycle */
static int hf_xnap_nRPaging_Time_Window;          /* NRPaging_Time_Window */
static int hf_xnap_nRPaging_eDRX_Cycle_Inactive;  /* NRPaging_eDRX_Cycle_Inactive */
static int hf_xnap_nRPaging_long_eDRX_Cycle_Inactive;  /* NRPaging_long_eDRX_Cycle_Inactive */
static int hf_xnap_nRPaging_Time_Window_Inactive;  /* NRPaging_Time_Window_Inactive */
static int hf_xnap_nRSCS;                         /* NRSCS */
static int hf_xnap_nRNRB;                         /* NRNRB */
static int hf_xnap_requestedSRSTransmissionCharacteristics;  /* RequestedSRSTransmissionCharacteristics */
static int hf_xnap_routingID;                     /* RoutingID */
static int hf_xnap_nRPPaTransactionID;            /* INTEGER_0_32767 */
static int hf_xnap_pER_Scalar;                    /* PER_Scalar */
static int hf_xnap_pER_Exponent;                  /* PER_Exponent */
static int hf_xnap_cNsubgroupID;                  /* CNsubgroupID */
static int hf_xnap_pc5QoSFlowList;                /* PC5QoSFlowList */
static int hf_xnap_pc5LinkAggregateBitRates;      /* BitRate */
static int hf_xnap_PC5QoSFlowList_item;           /* PC5QoSFlowItem */
static int hf_xnap_pQI;                           /* FiveQI */
static int hf_xnap_pc5FlowBitRates;               /* PC5FlowBitRates */
static int hf_xnap_range;                         /* Range */
static int hf_xnap_guaranteedFlowBitRate;         /* BitRate */
static int hf_xnap_maximumFlowBitRate;            /* BitRate */
static int hf_xnap_from_S_NG_RAN_node;            /* T_from_S_NG_RAN_node */
static int hf_xnap_from_M_NG_RAN_node;            /* T_from_M_NG_RAN_node */
static int hf_xnap_ulPDCPSNLength;                /* T_ulPDCPSNLength */
static int hf_xnap_dlPDCPSNLength;                /* T_dlPDCPSNLength */
static int hf_xnap_ulPDUSetQoSInformation;        /* PDUSetQoSInformation */
static int hf_xnap_dlPDUSetQoSInformation;        /* PDUSetQoSInformation */
static int hf_xnap_pduSetDelayBudget;             /* ExtendedPacketDelayBudget */
static int hf_xnap_pduSetErrorRate;               /* PacketErrorRate */
static int hf_xnap_pduSetIntegratedHandlingInformation;  /* T_pduSetIntegratedHandlingInformation */
static int hf_xnap_downlink_session_AMBR;         /* BitRate */
static int hf_xnap_uplink_session_AMBR;           /* BitRate */
static int hf_xnap_PDUSession_List_item;          /* PDUSession_ID */
static int hf_xnap_PDUSession_List_withCause_item;  /* PDUSession_List_withCause_Item */
static int hf_xnap_pduSessionId;                  /* PDUSession_ID */
static int hf_xnap_PDUSession_List_withDataForwardingFromTarget_item;  /* PDUSession_List_withDataForwardingFromTarget_Item */
static int hf_xnap_dataforwardinginfoTarget;      /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_PDUSession_List_withDataForwardingRequest_item;  /* PDUSession_List_withDataForwardingRequest_Item */
static int hf_xnap_dataforwardingInfofromSource;  /* DataforwardingandOffloadingInfofromSource */
static int hf_xnap_dRBtoBeReleasedList;           /* DRBToQoSFlowMapping_List */
static int hf_xnap_PDUSessionsListToBeReleased_UPError_item;  /* PDUSessionsListToBeReleased_UPError_Item */
static int hf_xnap_userPlaneErrorIndicator;       /* UserPlaneErrorIndicator */
static int hf_xnap_PDUSessionResourcesAdmitted_List_item;  /* PDUSessionResourcesAdmitted_Item */
static int hf_xnap_pduSessionResourceAdmittedInfo;  /* PDUSessionResourceAdmittedInfo */
static int hf_xnap_dL_NG_U_TNL_Information_Unchanged;  /* T_dL_NG_U_TNL_Information_Unchanged */
static int hf_xnap_qosFlowsAdmitted_List;         /* QoSFlowsAdmitted_List */
static int hf_xnap_qosFlowsNotAdmitted_List;      /* QoSFlows_List_withCause */
static int hf_xnap_dataForwardingInfoFromTarget;  /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_PDUSessionResourcesNotAdmitted_List_item;  /* PDUSessionResourcesNotAdmitted_Item */
static int hf_xnap_PDUSessionResourcesToBeSetup_List_item;  /* PDUSessionResourcesToBeSetup_Item */
static int hf_xnap_s_NSSAI;                       /* S_NSSAI */
static int hf_xnap_pduSessionAMBR;                /* PDUSessionAggregateMaximumBitRate */
static int hf_xnap_uL_NG_U_TNLatUPF;              /* UPTransportLayerInformation */
static int hf_xnap_source_DL_NG_U_TNL_Information;  /* UPTransportLayerInformation */
static int hf_xnap_securityIndication;            /* SecurityIndication */
static int hf_xnap_pduSessionType;                /* PDUSessionType */
static int hf_xnap_pduSessionNetworkInstance;     /* PDUSessionNetworkInstance */
static int hf_xnap_qosFlowsToBeSetup_List;        /* QoSFlowsToBeSetup_List */
static int hf_xnap_dataforwardinginfofromSource;  /* DataforwardingandOffloadingInfofromSource */
static int hf_xnap_qosFlowsToBeSetup_List_01;     /* QoSFlowsToBeSetup_List_Setup_SNterminated */
static int hf_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_item;  /* QoSFlowsToBeSetup_List_Setup_SNterminated_Item */
static int hf_xnap_qfi;                           /* QoSFlowIdentifier */
static int hf_xnap_qosFlowLevelQoSParameters;     /* QoSFlowLevelQoSParameters */
static int hf_xnap_offeredGBRQoSFlowInfo;         /* GBRQoSFlowInfo */
static int hf_xnap_dL_NG_U_TNLatNG_RAN;           /* UPTransportLayerInformation */
static int hf_xnap_dRBsToBeSetup;                 /* DRBsToBeSetupList_SetupResponse_SNterminated */
static int hf_xnap_qosFlowsNotAdmittedList;       /* QoSFlows_List_withCause */
static int hf_xnap_securityResult;                /* SecurityResult */
static int hf_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_item;  /* DRBsToBeSetupList_SetupResponse_SNterminated_Item */
static int hf_xnap_sN_UL_PDCP_UP_TNLInfo;         /* UPTransportParameters */
static int hf_xnap_dRB_QoS;                       /* QoSFlowLevelQoSParameters */
static int hf_xnap_pDCP_SNLength;                 /* PDCPSNLength */
static int hf_xnap_uL_Configuration;              /* ULConfiguration */
static int hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo;  /* UPTransportParameters */
static int hf_xnap_duplicationActivation;         /* DuplicationActivation */
static int hf_xnap_qoSFlowsMappedtoDRB_SetupResponse_SNterminated;  /* QoSFlowsMappedtoDRB_SetupResponse_SNterminated */
static int hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_item;  /* QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item */
static int hf_xnap_mCGRequestedGBRQoSFlowInfo;    /* GBRQoSFlowInfo */
static int hf_xnap_qosFlowMappingIndication;      /* QoSFlowMappingIndication */
static int hf_xnap_dRBsToBeSetup_01;              /* DRBsToBeSetupList_Setup_MNterminated */
static int hf_xnap_DRBsToBeSetupList_Setup_MNterminated_item;  /* DRBsToBeSetupList_Setup_MNterminated_Item */
static int hf_xnap_mN_UL_PDCP_UP_TNLInfo;         /* UPTransportParameters */
static int hf_xnap_secondary_MN_UL_PDCP_UP_TNLInfo;  /* UPTransportParameters */
static int hf_xnap_qoSFlowsMappedtoDRB_Setup_MNterminated;  /* QoSFlowsMappedtoDRB_Setup_MNterminated */
static int hf_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_item;  /* QoSFlowsMappedtoDRB_Setup_MNterminated_Item */
static int hf_xnap_dRBsAdmittedList;              /* DRBsAdmittedList_SetupResponse_MNterminated */
static int hf_xnap_DRBsAdmittedList_SetupResponse_MNterminated_item;  /* DRBsAdmittedList_SetupResponse_MNterminated_Item */
static int hf_xnap_sN_DL_SCG_UP_TNLInfo;          /* UPTransportParameters */
static int hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo;  /* UPTransportParameters */
static int hf_xnap_lCID;                          /* LCID */
static int hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_item;  /* QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item */
static int hf_xnap_currentQoSParaSetIndex;        /* QoSParaSetIndex */
static int hf_xnap_qosFlowsToBeModified_List;     /* QoSFlowsToBeSetup_List_Modified_SNterminated */
static int hf_xnap_qoSFlowsToBeReleased_List;     /* QoSFlows_List_withCause */
static int hf_xnap_drbsToBeModifiedList;          /* DRBsToBeModified_List_Modified_SNterminated */
static int hf_xnap_dRBsToBeReleased;              /* DRB_List_withCause */
static int hf_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_item;  /* QoSFlowsToBeSetup_List_Modified_SNterminated_Item */
static int hf_xnap_DRBsToBeModified_List_Modified_SNterminated_item;  /* DRBsToBeModified_List_Modified_SNterminated_Item */
static int hf_xnap_mN_DL_SCG_UP_TNLInfo;          /* UPTransportParameters */
static int hf_xnap_secondary_MN_DL_SCG_UP_TNLInfo;  /* UPTransportParameters */
static int hf_xnap_rlc_status;                    /* RLC_Status */
static int hf_xnap_dRBsToBeModified;              /* DRBsToBeModifiedList_ModificationResponse_SNterminated */
static int hf_xnap_qosFlowsNotAdmittedTBAdded;    /* QoSFlows_List_withCause */
static int hf_xnap_qosFlowsReleased;              /* QoSFlows_List_withCause */
static int hf_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_item;  /* DRBsToBeModifiedList_ModificationResponse_SNterminated_Item */
static int hf_xnap_dRBsToBeModified_01;           /* DRBsToBeModifiedList_Modification_MNterminated */
static int hf_xnap_DRBsToBeModifiedList_Modification_MNterminated_item;  /* DRBsToBeModifiedList_Modification_MNterminated_Item */
static int hf_xnap_pdcpDuplicationConfiguration;  /* PDCPDuplicationConfiguration */
static int hf_xnap_dRBsAdmittedList_01;           /* DRBsAdmittedList_ModificationResponse_MNterminated */
static int hf_xnap_dRBsReleasedList;              /* DRB_List */
static int hf_xnap_dRBsNotAdmittedSetupModifyList;  /* DRB_List_withCause */
static int hf_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_item;  /* DRBsAdmittedList_ModificationResponse_MNterminated_Item */
static int hf_xnap_drbsToBeSetupList;             /* DRBsToBeSetup_List_ModRqd_SNterminated */
static int hf_xnap_drbsToBeModifiedList_01;       /* DRBsToBeModified_List_ModRqd_SNterminated */
static int hf_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_item;  /* DRBsToBeSetup_List_ModRqd_SNterminated_Item */
static int hf_xnap_sn_UL_PDCP_UPTNLinfo;          /* UPTransportParameters */
static int hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated;  /* QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated */
static int hf_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_item;  /* QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item */
static int hf_xnap_DRBsToBeModified_List_ModRqd_SNterminated_item;  /* DRBsToBeModified_List_ModRqd_SNterminated_Item */
static int hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated_01;  /* QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated */
static int hf_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_item;  /* QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item */
static int hf_xnap_dRBsAdmittedList_02;           /* DRBsAdmittedList_ModConfirm_SNterminated */
static int hf_xnap_DRBsAdmittedList_ModConfirm_SNterminated_item;  /* DRBsAdmittedList_ModConfirm_SNterminated_Item */
static int hf_xnap_mN_DL_CG_UP_TNLInfo;           /* UPTransportParameters */
static int hf_xnap_secondary_MN_DL_CG_UP_TNLInfo;  /* UPTransportParameters */
static int hf_xnap_dRBsToBeModified_02;           /* DRBsToBeModified_List_ModRqd_MNterminated */
static int hf_xnap_DRBsToBeModified_List_ModRqd_MNterminated_item;  /* DRBsToBeModified_List_ModRqd_MNterminated_Item */
static int hf_xnap_sN_DL_SCG_UP_TNLInfo_01;       /* UPTransportLayerInformation */
static int hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo_01;  /* UPTransportLayerInformation */
static int hf_xnap_dRBsToBeSetupList;             /* SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item */
static int hf_xnap_dRBsToBeSetupList_item;        /* DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item */
static int hf_xnap_dRB_ID;                        /* DRB_ID */
static int hf_xnap_mN_Xn_U_TNLInfoatM;            /* UPTransportLayerInformation */
static int hf_xnap_PDUSessionResourceSecondaryRATUsageList_item;  /* PDUSessionResourceSecondaryRATUsageItem */
static int hf_xnap_pDUSessionID;                  /* PDUSession_ID */
static int hf_xnap_secondaryRATUsageInformation;  /* SecondaryRATUsageInformation */
static int hf_xnap_rATType;                       /* T_rATType */
static int hf_xnap_pDUSessionTimedReportList;     /* VolumeTimedReportList */
static int hf_xnap_plmnListforQMC;                /* PLMNListforQMC */
static int hf_xnap_PLMNListforQMC_item;           /* PLMN_Identity */
static int hf_xnap_PCIListForMDT_item;            /* NRPCI */
static int hf_xnap_predictedtrajectoryCellInfo;   /* PredictedTrajectoryCellInfo */
static int hf_xnap_nG_RAN_Cell_Predicted;         /* PredictedTrajectoryNGRANCellInfo */
static int hf_xnap_predictedTimeUEStaysInCell;    /* INTEGER_0_4095 */
static int hf_xnap_protectedResourceList;         /* ProtectedE_UTRAResourceList */
static int hf_xnap_mbsfnControlRegionLength;      /* MBSFNControlRegionLength */
static int hf_xnap_pDCCHRegionLength;             /* INTEGER_1_3 */
static int hf_xnap_ProtectedE_UTRAResourceList_item;  /* ProtectedE_UTRAResource_Item */
static int hf_xnap_resourceType;                  /* T_resourceType */
static int hf_xnap_intra_PRBProtectedResourceFootprint;  /* BIT_STRING_SIZE_84_ */
static int hf_xnap_protectedFootprintFrequencyPattern;  /* BIT_STRING_SIZE_6_110_ */
static int hf_xnap_protectedFootprintTimePattern;  /* ProtectedE_UTRAFootprintTimePattern */
static int hf_xnap_protectedFootprintTimeperiodicity;  /* INTEGER_1_320_ */
static int hf_xnap_protectedFootrpintStartTime;   /* INTEGER_1_20_ */
static int hf_xnap_cAGListforMDT;                 /* CAGListforMDT */
static int hf_xnap_uEAppLayerMeasInfoList;        /* UEAppLayerMeasInfoList */
static int hf_xnap_UEAppLayerMeasInfoList_item;   /* UEAppLayerMeasInfo_Item */
static int hf_xnap_uEAppLayerMeasConfigInfo;      /* UEAppLayerMeasConfigInfo */
static int hf_xnap_mN_to_SN_QMCCoordRequestList;  /* MN_to_SN_QMCCoordRequestList */
static int hf_xnap_sN_to_MN_QMCCoordRequestList;  /* SN_to_MN_QMCCoordRequestList */
static int hf_xnap_MN_to_SN_QMCCoordRequestList_item;  /* MN_to_SN_QMCCoordRequestList_Item */
static int hf_xnap_qOEReference;                  /* QOEReference */
static int hf_xnap_qOEMeasConfigAppLayerID;       /* QOEMeasConfAppLayerID */
static int hf_xnap_measCollectionEntityIPAddress;  /* MeasCollectionEntityIPAddress */
static int hf_xnap_qoEReportingPathRequest;       /* T_qoEReportingPathRequest */
static int hf_xnap_rVQoEReportingPathRequest;     /* T_rVQoEReportingPathRequest */
static int hf_xnap_furtherRVQoEInterestInquiry;   /* T_furtherRVQoEInterestInquiry */
static int hf_xnap_furtherRVQoEReportingPathInquiry;  /* T_furtherRVQoEReportingPathInquiry */
static int hf_xnap_currentRVQoEConfig;            /* RVQoEConfig */
static int hf_xnap_availableRVQoEMetrics;         /* AvailableRVQoEMetrics */
static int hf_xnap_configReleaseIndication;       /* T_configReleaseIndication */
static int hf_xnap_SN_to_MN_QMCCoordRequestList_item;  /* SN_to_MN_QMCCoordRequestList_Item */
static int hf_xnap_qoEReportingPathRequest_01;    /* T_qoEReportingPathRequest_01 */
static int hf_xnap_rVQoEReportingPathRequest_01;  /* T_rVQoEReportingPathRequest_01 */
static int hf_xnap_furtherRVQoEInterestInquiry_01;  /* T_furtherRVQoEInterestInquiry_01 */
static int hf_xnap_furtherRVQoEReportingPathInquiry_01;  /* T_furtherRVQoEReportingPathInquiry_01 */
static int hf_xnap_configReleaseIndication_01;    /* T_configReleaseIndication_01 */
static int hf_xnap_mN_to_SN_QMCCoordResponseList;  /* MN_to_SN_QMCCoordResponseList */
static int hf_xnap_sN_to_MN_QMCCoordResponseList;  /* SN_to_MN_QMCCoordResponseList */
static int hf_xnap_MN_to_SN_QMCCoordResponseList_item;  /* MN_to_SN_QMCCoordResponseList_Item */
static int hf_xnap_qoEConfigSendingPath;          /* T_qoEConfigSendingPath */
static int hf_xnap_qoEReportingPathResponse;      /* T_qoEReportingPathResponse */
static int hf_xnap_rVQoEReportingPathResponse;    /* T_rVQoEReportingPathResponse */
static int hf_xnap_furtherRVQoEInterestResponse;  /* T_furtherRVQoEInterestResponse */
static int hf_xnap_furtherRVQoEReportingPathResponse;  /* T_furtherRVQoEReportingPathResponse */
static int hf_xnap_preferredRVQoEConfig;          /* RVQoEConfig */
static int hf_xnap_SN_to_MN_QMCCoordResponseList_item;  /* SN_to_MN_QMCCoordResponseList_Item */
static int hf_xnap_qoEReportingPathResponse_01;   /* T_qoEReportingPathResponse_01 */
static int hf_xnap_rVQoEReportingPathResponse_01;  /* T_rVQoEReportingPathResponse_01 */
static int hf_xnap_furtherRVQoEInterestResponse_01;  /* T_furtherRVQoEInterestResponse_01 */
static int hf_xnap_furtherRVQoEReportingPathResponse_01;  /* T_furtherRVQoEReportingPathResponse_01 */
static int hf_xnap_qoEReportingPath;              /* T_qoEReportingPath */
static int hf_xnap_rVQoEReportingPath;            /* T_rVQoEReportingPath */
static int hf_xnap_availableRANVisibleQoEMetrics;  /* AvailableRVQoEMetrics */
static int hf_xnap_reportingPeriodicity;          /* RVQoEReportingPeriodicity */
static int hf_xnap_non_dynamic;                   /* NonDynamic5QIDescriptor */
static int hf_xnap_dynamic;                       /* Dynamic5QIDescriptor */
static int hf_xnap_qos_characteristics;           /* QoSCharacteristics */
static int hf_xnap_allocationAndRetentionPrio;    /* AllocationandRetentionPriority */
static int hf_xnap_gBRQoSFlowInfo;                /* GBRQoSFlowInfo */
static int hf_xnap_reflectiveQoS;                 /* ReflectiveQoSAttribute */
static int hf_xnap_additionalQoSflowInfo;         /* T_additionalQoSflowInfo */
static int hf_xnap_QoSFlowNotificationControlIndicationInfo_item;  /* QoSFlowNotify_Item */
static int hf_xnap_notificationInformation;       /* T_notificationInformation */
static int hf_xnap_QoSFlows_List_item;            /* QoSFlow_Item */
static int hf_xnap_QoSFlows_List_withCause_item;  /* QoSFlowwithCause_Item */
static int hf_xnap_QoSFlowsAdmitted_List_item;    /* QoSFlowsAdmitted_Item */
static int hf_xnap_QoSFlowsToBeSetup_List_item;   /* QoSFlowsToBeSetup_Item */
static int hf_xnap_e_RAB_ID;                      /* E_RAB_ID */
static int hf_xnap_QoSFlowsUsageReportList_item;  /* QoSFlowsUsageReport_Item */
static int hf_xnap_rATType_01;                    /* T_rATType_01 */
static int hf_xnap_qoSFlowsTimedReportList;       /* VolumeTimedReportList */
static int hf_xnap_RAReport_item;                 /* RAReportList_Item */
static int hf_xnap_rAReport;                      /* RAReportContainer */
static int hf_xnap_ng_eNB_RadioResourceStatus;    /* NG_eNB_RadioResourceStatus */
static int hf_xnap_gNB_RadioResourceStatus;       /* GNB_RadioResourceStatus */
static int hf_xnap_rANAC;                         /* RANAC */
static int hf_xnap_RANAreaID_List_item;           /* RANAreaID */
static int hf_xnap_rANPagingAreaChoice;           /* RANPagingAreaChoice */
static int hf_xnap_cell_List;                     /* NG_RAN_Cell_Identity_ListinRANPagingArea */
static int hf_xnap_rANAreaID_List;                /* RANAreaID_List */
static int hf_xnap_pagingAttemptCount;            /* INTEGER_1_16_ */
static int hf_xnap_intendedNumberOfPagingAttempts;  /* INTEGER_1_16_ */
static int hf_xnap_nextPagingAreaScope;           /* T_nextPagingAreaScope */
static int hf_xnap_rBsetSize;                     /* T_rBsetSize */
static int hf_xnap_numberofRBSets;                /* INTEGER_1_maxnoofRBsetsPerCell */
static int hf_xnap_rSN;                           /* RSN */
static int hf_xnap_ReplacingCells_item;           /* ReplacingCells_Item */
static int hf_xnap_periodical;                    /* Periodical */
static int hf_xnap_eventTriggered;                /* EventTriggered */
static int hf_xnap_subframeType;                  /* T_subframeType */
static int hf_xnap_reservedSubframePattern_01;    /* BIT_STRING_SIZE_10_160 */
static int hf_xnap_fullReset;                     /* ResetRequestTypeInfo_Full */
static int hf_xnap_partialReset;                  /* ResetRequestTypeInfo_Partial */
static int hf_xnap_ue_contexts_ToBeReleasedList;  /* ResetRequestPartialReleaseList */
static int hf_xnap_ResetRequestPartialReleaseList_item;  /* ResetRequestPartialReleaseItem */
static int hf_xnap_ng_ran_node1UEXnAPID;          /* NG_RANnodeUEXnAPID */
static int hf_xnap_ng_ran_node2UEXnAPID;          /* NG_RANnodeUEXnAPID */
static int hf_xnap_fullReset_01;                  /* ResetResponseTypeInfo_Full */
static int hf_xnap_partialReset_01;               /* ResetResponseTypeInfo_Partial */
static int hf_xnap_ue_contexts_AdmittedToBeReleasedList;  /* ResetResponsePartialReleaseList */
static int hf_xnap_ResetResponsePartialReleaseList_item;  /* ResetResponsePartialReleaseItem */
static int hf_xnap_reestablishment_Indication;    /* Reestablishment_Indication */
static int hf_xnap_rLCDuplicationStateList;       /* RLCDuplicationStateList */
static int hf_xnap_rLC_PrimaryIndicator;          /* T_rLC_PrimaryIndicator */
static int hf_xnap_RLCDuplicationStateList_item;  /* RLCDuplicationState_Item */
static int hf_xnap_duplicationState;              /* T_duplicationState */
static int hf_xnap_noofRRCConnections;            /* NoofRRCConnections */
static int hf_xnap_availableRRCConnectionCapacityValue;  /* AvailableRRCConnectionCapacityValue */
static int hf_xnap_rRRCReestab_initiated_reporting;  /* RRCReestab_Initiated_Reporting */
static int hf_xnap_rRCReestab_reporting_wo_UERLFReport;  /* RRCReestab_Initiated_Reporting_wo_UERLFReport */
static int hf_xnap_rRCReestab_reporting_with_UERLFReport;  /* RRCReestab_Initiated_Reporting_with_UERLFReport */
static int hf_xnap_failureCellPCI;                /* NG_RAN_CellPCI */
static int hf_xnap_reestabCellCGI;                /* GlobalNG_RANCell_ID */
static int hf_xnap_c_RNTI;                        /* C_RNTI */
static int hf_xnap_shortMAC_I;                    /* MAC_I */
static int hf_xnap_uERLFReportContainer;          /* UERLFReportContainer */
static int hf_xnap_rRRCSetup_Initiated_Reporting;  /* RRCSetup_Initiated_Reporting */
static int hf_xnap_rRCSetup_reporting_with_UERLFReport;  /* RRCSetup_Initiated_Reporting_with_UERLFReport */
static int hf_xnap_RaReportIndicationList_item;   /* RaReportIndicationList_Item */
static int hf_xnap_m_NG_RAN_node_UE_XnAP_ID;      /* NG_RANnodeUEXnAPID */
static int hf_xnap_dL_Total_PRB_usage_01;         /* INTEGER_0_100 */
static int hf_xnap_uL_Total_PRB_usage_01;         /* INTEGER_0_100 */
static int hf_xnap_S_NSSAIListQoE_item;           /* S_NSSAI */
static int hf_xnap_ng_ran_TraceID;                /* NG_RANTraceID */
static int hf_xnap_s_CPAC_Security_Config_List;   /* S_CPAC_SecurityConfig_List */
static int hf_xnap_s_CPAC_MultiTargetSN_List;     /* S_CPAC_MultiTargetSN_List */
static int hf_xnap_S_CPAC_SecurityConfig_List_item;  /* S_CPAC_SecurityConfig_Item */
static int hf_xnap_s_ng_RANnode_SecurityKey;      /* S_NG_RANnode_SecurityKey */
static int hf_xnap_sk_counter;                    /* SK_COUNTER */
static int hf_xnap_S_CPAC_MultiTargetSN_List_item;  /* S_CPAC_MultiTargetSN_Item */
static int hf_xnap_recommendedCandidatePSCells;   /* OCTET_STRING */
static int hf_xnap_secondarydataForwardingInfoFromTarget;  /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_SecondarydataForwardingInfoFromTarget_List_item;  /* SecondarydataForwardingInfoFromTarget_Item */
static int hf_xnap_sdtindicator;                  /* SDTIndicator */
static int hf_xnap_sdtAssistantInfo;              /* SDTAssistantInfo */
static int hf_xnap_dRBsToBeSetup_02;              /* SDT_DRBsToBeSetupList */
static int hf_xnap_sRBsToBeSetup;                 /* SDT_SRBsToBeSetupList */
static int hf_xnap_SDT_DRBsToBeSetupList_item;    /* SDT_DRBsToBeSetupList_Item */
static int hf_xnap_uL_TNLInfo;                    /* UPTransportLayerInformation */
static int hf_xnap_dRB_RLC_Bearer_Configuration;  /* T_dRB_RLC_Bearer_Configuration */
static int hf_xnap_s_nssai;                       /* S_NSSAI */
static int hf_xnap_flows_Mapped_To_DRB_List;      /* Flows_Mapped_To_DRB_List */
static int hf_xnap_SDT_SRBsToBeSetupList_item;    /* SDT_SRBsToBeSetupList_Item */
static int hf_xnap_srb_ID;                        /* SRB_ID */
static int hf_xnap_sRB_RLC_Bearer_Configuration;  /* T_sRB_RLC_Bearer_Configuration */
static int hf_xnap_SDTDataForwardingDRBList_item;  /* SDTDataForwardingDRBList_Item */
static int hf_xnap_dL_TNLInfo;                    /* UPTransportLayerInformation */
static int hf_xnap_pDUSessionUsageReport;         /* PDUSessionUsageReport */
static int hf_xnap_qosFlowsUsageReportList;       /* QoSFlowsUsageReportList */
static int hf_xnap_integrityProtectionIndication;  /* T_integrityProtectionIndication */
static int hf_xnap_confidentialityProtectionIndication;  /* T_confidentialityProtectionIndication */
static int hf_xnap_maximumIPdatarate;             /* MaximumIPdatarate */
static int hf_xnap_integrityProtectionResult;     /* T_integrityProtectionResult */
static int hf_xnap_confidentialityProtectionResult;  /* T_confidentialityProtectionResult */
static int hf_xnap_sensorMeasConfig;              /* SensorMeasConfig */
static int hf_xnap_sensorMeasConfigNameList;      /* SensorMeasConfigNameList */
static int hf_xnap_SensorMeasConfigNameList_item;  /* SensorName */
static int hf_xnap_uncompensatedBarometricConfig;  /* T_uncompensatedBarometricConfig */
static int hf_xnap_ueSpeedConfig;                 /* T_ueSpeedConfig */
static int hf_xnap_ueOrientationConfig;           /* T_ueOrientationConfig */
static int hf_xnap_e_utra_pci;                    /* E_UTRAPCI */
static int hf_xnap_broadcastPLMNs_02;             /* SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN */
static int hf_xnap_broadcastPLMNs_item;           /* ServedCellInformation_E_UTRA_perBPLMN */
static int hf_xnap_e_utra_mode_info;              /* ServedCellInformation_E_UTRA_ModeInfo */
static int hf_xnap_numberofAntennaPorts;          /* NumberOfAntennaPorts_E_UTRA */
static int hf_xnap_prach_configuration;           /* E_UTRAPRACHConfiguration */
static int hf_xnap_mBSFNsubframeInfo;             /* MBSFNSubframeInfo_E_UTRA */
static int hf_xnap_multibandInfo;                 /* E_UTRAMultibandInfoList */
static int hf_xnap_freqBandIndicatorPriority;     /* T_freqBandIndicatorPriority */
static int hf_xnap_bandwidthReducedSI;            /* T_bandwidthReducedSI */
static int hf_xnap_protectedE_UTRAResourceIndication;  /* ProtectedE_UTRAResourceIndication */
static int hf_xnap_fdd_02;                        /* ServedCellInformation_E_UTRA_FDDInfo */
static int hf_xnap_tdd_02;                        /* ServedCellInformation_E_UTRA_TDDInfo */
static int hf_xnap_ul_earfcn;                     /* E_UTRAARFCN */
static int hf_xnap_dl_earfcn;                     /* E_UTRAARFCN */
static int hf_xnap_ul_e_utraTxBW;                 /* E_UTRATransmissionBandwidth */
static int hf_xnap_dl_e_utraTxBW;                 /* E_UTRATransmissionBandwidth */
static int hf_xnap_e_utraTxBW;                    /* E_UTRATransmissionBandwidth */
static int hf_xnap_subframeAssignmnet;            /* T_subframeAssignmnet */
static int hf_xnap_specialSubframeInfo;           /* SpecialSubframeInfo_E_UTRA */
static int hf_xnap_ServedCells_E_UTRA_item;       /* ServedCells_E_UTRA_Item */
static int hf_xnap_served_cell_info_E_UTRA;       /* ServedCellInformation_E_UTRA */
static int hf_xnap_neighbour_info_NR;             /* NeighbourInformation_NR */
static int hf_xnap_neighbour_info_E_UTRA;         /* NeighbourInformation_E_UTRA */
static int hf_xnap_served_Cells_ToAdd_E_UTRA;     /* ServedCells_E_UTRA */
static int hf_xnap_served_Cells_ToModify_E_UTRA;  /* ServedCells_ToModify_E_UTRA */
static int hf_xnap_served_Cells_ToDelete_E_UTRA;  /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_served_Cells_ToDelete_E_UTRA_item;  /* E_UTRA_CGI */
static int hf_xnap_ServedCells_ToModify_E_UTRA_item;  /* ServedCells_ToModify_E_UTRA_Item */
static int hf_xnap_old_ECGI;                      /* E_UTRA_CGI */
static int hf_xnap_deactivation_indication;       /* T_deactivation_indication */
static int hf_xnap_nrPCI;                         /* NRPCI */
static int hf_xnap_cellID_01;                     /* NR_CGI */
static int hf_xnap_broadcastPLMN;                 /* BroadcastPLMNs */
static int hf_xnap_nrModeInfo;                    /* NRModeInfo */
static int hf_xnap_measurementTimingConfiguration_01;  /* T_measurementTimingConfiguration_01 */
static int hf_xnap_sFN_Time_Offset;               /* BIT_STRING_SIZE_24 */
static int hf_xnap_ServedCells_NR_item;           /* ServedCells_NR_Item */
static int hf_xnap_served_cell_info_NR;           /* ServedCellInformation_NR */
static int hf_xnap_ServedCells_ToModify_NR_item;  /* ServedCells_ToModify_NR_Item */
static int hf_xnap_old_NR_CGI;                    /* NR_CGI */
static int hf_xnap_deactivation_indication_01;    /* T_deactivation_indication_01 */
static int hf_xnap_ServedCellSpecificInfoReq_NR_item;  /* ServedCellSpecificInfoReq_NR_Item */
static int hf_xnap_additionalMTCListRequestIndicator;  /* T_additionalMTCListRequestIndicator */
static int hf_xnap_served_Cells_ToAdd_NR;         /* ServedCells_NR */
static int hf_xnap_served_Cells_ToModify_NR;      /* ServedCells_ToModify_NR */
static int hf_xnap_served_Cells_ToDelete_NR;      /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_served_Cells_ToDelete_NR_item;  /* NR_CGI */
static int hf_xnap_ul_onlySharing;                /* SharedResourceType_UL_OnlySharing */
static int hf_xnap_ul_and_dl_Sharing;             /* SharedResourceType_ULDL_Sharing */
static int hf_xnap_ul_resourceBitmap;             /* DataTrafficResources */
static int hf_xnap_ul_resources;                  /* SharedResourceType_ULDL_Sharing_UL_Resources */
static int hf_xnap_dl_resources;                  /* SharedResourceType_ULDL_Sharing_DL_Resources */
static int hf_xnap_unchanged;                     /* NULL */
static int hf_xnap_changed;                       /* SharedResourceType_ULDL_Sharing_UL_ResourcesChanged */
static int hf_xnap_changed_01;                    /* SharedResourceType_ULDL_Sharing_DL_ResourcesChanged */
static int hf_xnap_dl_resourceBitmap;             /* DataTrafficResources */
static int hf_xnap_SliceAvailableCapacity_item;   /* SliceAvailableCapacity_Item */
static int hf_xnap_pLMNIdentity;                  /* PLMN_Identity */
static int hf_xnap_sNSSAIAvailableCapacity_List;  /* SNSSAIAvailableCapacity_List */
static int hf_xnap_SNSSAIAvailableCapacity_List_item;  /* SNSSAIAvailableCapacity_Item */
static int hf_xnap_sNSSAI;                        /* S_NSSAI */
static int hf_xnap_sliceAvailableCapacityValueDownlink;  /* INTEGER_0_100 */
static int hf_xnap_sliceAvailableCapacityValueUplink;  /* INTEGER_0_100 */
static int hf_xnap_SliceRadioResourceStatus_List_item;  /* SliceRadioResourceStatus_Item */
static int hf_xnap_sNSSAIRadioResourceStatus_List;  /* SNSSAIRadioResourceStatus_List */
static int hf_xnap_sLPositioning_Ranging_Authorized;  /* SLPositioning_Ranging_Authorized */
static int hf_xnap_rSPP_transport_QoS_parameters;  /* RSPP_transport_QoS_parameters */
static int hf_xnap_rSPPQoSFlowList;               /* RSPPQoSFlowList */
static int hf_xnap_rSPPLinkAggregateBitRates;     /* BitRate */
static int hf_xnap_RSPPQoSFlowList_item;          /* RSPPQoSFlowItem */
static int hf_xnap_rSPPFlowBitRates;              /* RSPPFlowBitRates */
static int hf_xnap_SNSSAIRadioResourceStatus_List_item;  /* SNSSAIRadioResourceStatus_Item */
static int hf_xnap_slice_DL_GBR_PRB_Usage;        /* Slice_DL_GBR_PRB_Usage */
static int hf_xnap_slice_UL_GBR_PRB_Usage;        /* Slice_UL_GBR_PRB_Usage */
static int hf_xnap_slice_DL_non_GBR_PRB_Usage;    /* Slice_DL_non_GBR_PRB_Usage */
static int hf_xnap_slice_UL_non_GBR_PRB_Usage;    /* Slice_UL_non_GBR_PRB_Usage */
static int hf_xnap_slice_DL_Total_PRB_Allocation;  /* Slice_DL_Total_PRB_Allocation */
static int hf_xnap_slice_UL_Total_PRB_Allocation;  /* Slice_UL_Total_PRB_Allocation */
static int hf_xnap_SliceSupport_List_item;        /* S_NSSAI */
static int hf_xnap_SliceToReport_List_item;       /* SliceToReport_List_Item */
static int hf_xnap_sNSSAIlist;                    /* SNSSAI_list */
static int hf_xnap_SNSSAI_list_item;              /* SNSSAI_Item */
static int hf_xnap_SlotConfiguration_List_item;   /* SlotConfiguration_List_Item */
static int hf_xnap_slotIndex_01;                  /* INTEGER_0_5119 */
static int hf_xnap_symbolAllocation_in_Slot;      /* SymbolAllocation_in_Slot */
static int hf_xnap_sst;                           /* OCTET_STRING_SIZE_1 */
static int hf_xnap_sd;                            /* OCTET_STRING_SIZE_3 */
static int hf_xnap_specialSubframePattern;        /* SpecialSubframePatterns_E_UTRA */
static int hf_xnap_cyclicPrefixDL;                /* CyclicPrefix_E_UTRA_DL */
static int hf_xnap_cyclicPrefixUL;                /* CyclicPrefix_E_UTRA_UL */
static int hf_xnap_SSBAreaCapacityValue_List_item;  /* SSBAreaCapacityValue_List_Item */
static int hf_xnap_sSBIndex;                      /* INTEGER_0_63 */
static int hf_xnap_ssbAreaCapacityValue;          /* INTEGER_0_100 */
static int hf_xnap_SSBAreaRadioResourceStatus_List_item;  /* SSBAreaRadioResourceStatus_List_Item */
static int hf_xnap_ssb_Area_DL_GBR_PRB_usage;     /* DL_GBR_PRB_usage */
static int hf_xnap_ssb_Area_UL_GBR_PRB_usage;     /* UL_GBR_PRB_usage */
static int hf_xnap_ssb_Area_dL_non_GBR_PRB_usage;  /* DL_non_GBR_PRB_usage */
static int hf_xnap_ssb_Area_uL_non_GBR_PRB_usage;  /* UL_non_GBR_PRB_usage */
static int hf_xnap_ssb_Area_dL_Total_PRB_usage;   /* DL_Total_PRB_usage */
static int hf_xnap_ssb_Area_uL_Total_PRB_usage;   /* UL_Total_PRB_usage */
static int hf_xnap_SSB_Coverage_Modification_List_item;  /* SSB_Coverage_Modification_List_Item */
static int hf_xnap_sSBCoverageState;              /* INTEGER_0_15_ */
static int hf_xnap_shortBitmap;                   /* BIT_STRING_SIZE_4 */
static int hf_xnap_mediumBitmap;                  /* BIT_STRING_SIZE_8 */
static int hf_xnap_longBitmap;                    /* BIT_STRING_SIZE_64 */
static int hf_xnap_SSBOffsets_List_item;          /* SSBOffsets_Item */
static int hf_xnap_nG_RANnode1SSBOffsets;         /* SSBOffsetInformation */
static int hf_xnap_nG_RANnode2ProposedSSBOffsets;  /* SSBOffsetInformation */
static int hf_xnap_sSBTriggeringOffset;           /* MobilityParametersInformation */
static int hf_xnap_sSBobilityParametersModificationRange;  /* MobilityParametersModificationRange */
static int hf_xnap_SSBToReport_List_item;         /* SSBToReport_List_Item */
static int hf_xnap_SuccessfulHOReportInformation_item;  /* SuccessfulHOReportList_Item */
static int hf_xnap_successfulHOReport;            /* SuccessfulHOReportContainer */
static int hf_xnap_SuccessfulPSCellChangeReportInformation_item;  /* SuccessfulPSCellChangeReportList_Item */
static int hf_xnap_successfulPSCellChangeReport;  /* SuccessfulPSCellChangeReportContainer */
static int hf_xnap_sNMobilityInformation;         /* SNMobilityInformation */
static int hf_xnap_sulFrequencyInfo;              /* NRARFCN */
static int hf_xnap_sulTransmissionBandwidth;      /* NRTransmissionBandwidth */
static int hf_xnap_Supported_MBS_FSA_ID_List_item;  /* MBS_FrequencySelectionArea_Identity */
static int hf_xnap_SupportedSULBandList_item;     /* SupportedSULBandItem */
static int hf_xnap_sulBandItem;                   /* SUL_FrequencyBand */
static int hf_xnap_allDL;                         /* SymbolAllocation_in_Slot_AllDL */
static int hf_xnap_allUL;                         /* SymbolAllocation_in_Slot_AllUL */
static int hf_xnap_bothDLandUL;                   /* SymbolAllocation_in_Slot_BothDLandUL */
static int hf_xnap_numberofDLSymbols;             /* INTEGER_0_13 */
static int hf_xnap_numberofULSymbols;             /* INTEGER_0_13 */
static int hf_xnap_sNPN_CellIdListforMDT;         /* SNPN_CellIdListforMDT */
static int hf_xnap_SNPN_CellIdListforMDT_item;    /* SNPN_CellIdforMDT_Item */
static int hf_xnap_sNPN_TAIListforMDT;            /* SNPN_TAIListforMDT */
static int hf_xnap_SNPN_TAIListforMDT_item;       /* SNPN_TAIforMDT_Item */
static int hf_xnap_sNPNListforMDT;                /* SNPNListforMDT */
static int hf_xnap_SNPNListforMDT_item;           /* SNPNforMDT_Item */
static int hf_xnap_tAListforMDT;                  /* TAListforMDT */
static int hf_xnap_tAIListforMDT;                 /* TAIListforMDT */
static int hf_xnap_TAIListforMDT_item;            /* TAIforMDT_Item */
static int hf_xnap_TAINSAGSupportList_item;       /* TAINSAGSupportItem */
static int hf_xnap_nSAG_ID;                       /* NSAG_ID */
static int hf_xnap_nSAGSliceSupportList;          /* ExtendedSliceSupportList */
static int hf_xnap_TAISliceUnavailableCellList_item;  /* TAISliceUnavailableCellItem */
static int hf_xnap_sliceAvailabilityList;         /* SliceAvailabilityList */
static int hf_xnap_unavailableCellList;           /* UnavailableCellList */
static int hf_xnap_availableCellList;             /* AvailableCellList */
static int hf_xnap_availableNRCellList;           /* AvailableNRCellList */
static int hf_xnap_AvailableNRCellList_item;      /* NR_CGI */
static int hf_xnap_unavailableNRCellList;         /* UnavailableNRCellList */
static int hf_xnap_UnavailableNRCellList_item;    /* NR_CGI */
static int hf_xnap_TAISupport_List_item;          /* TAISupport_Item */
static int hf_xnap_broadcastPLMNs_03;             /* SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item */
static int hf_xnap_broadcastPLMNs_item_01;        /* BroadcastPLMNinTAISupport_Item */
static int hf_xnap_TAListforMDT_item;             /* TAC */
static int hf_xnap_tAListforQMC;                  /* TAListforQMC */
static int hf_xnap_TAListforQMC_item;             /* TAC */
static int hf_xnap_tAIListforQMC;                 /* TAIListforQMC */
static int hf_xnap_TAIListforQMC_item;            /* TAI_Item */
static int hf_xnap_nr_02;                         /* NR_CGI */
static int hf_xnap_e_utra_02;                     /* E_UTRA_CGI */
static int hf_xnap_TargetCellList_item;           /* TargetCellList_Item */
static int hf_xnap_target_cell;                   /* Target_CGI */
static int hf_xnap_timeDistributionIndication;    /* T_timeDistributionIndication */
static int hf_xnap_uuTimeSynchronizationErrorBudget;  /* INTEGER_0_1000000_ */
static int hf_xnap_extendedUPTransportLayerAddressesToAdd;  /* ExtTLAs */
static int hf_xnap_extendedUPTransportLayerAddressesToRemove;  /* ExtTLAs */
static int hf_xnap_TNLA_To_Add_List_item;         /* TNLA_To_Add_Item */
static int hf_xnap_tNLAssociationTransportLayerAddress;  /* CPTransportLayerInformation */
static int hf_xnap_tNLAssociationUsage;           /* TNLAssociationUsage */
static int hf_xnap_TNLA_To_Update_List_item;      /* TNLA_To_Update_Item */
static int hf_xnap_TNLA_To_Remove_List_item;      /* TNLA_To_Remove_Item */
static int hf_xnap_TNLA_Setup_List_item;          /* TNLA_Setup_Item */
static int hf_xnap_TNLA_Failed_To_Setup_List_item;  /* TNLA_Failed_To_Setup_Item */
static int hf_xnap_interfaces_to_trace;           /* T_interfaces_to_trace */
static int hf_xnap_trace_depth;                   /* Trace_Depth */
static int hf_xnap_trace_coll_address;            /* TransportLayerAddress */
static int hf_xnap_uPTraffic;                     /* QoSFlowLevelQoSParameters */
static int hf_xnap_nonUPTraffic;                  /* NonUPTraffic */
static int hf_xnap_fullRelease;                   /* AllTrafficIndication */
static int hf_xnap_partialRelease;                /* TrafficToBeRelease_List */
static int hf_xnap_releaseType;                   /* TrafficReleaseType */
static int hf_xnap_TrafficToBeRelease_List_item;  /* TrafficToBeRelease_Item */
static int hf_xnap_trafficIndex;                  /* TrafficIndex */
static int hf_xnap_bHInfoList;                    /* BHInfoList */
static int hf_xnap_tSCAssistanceInformationDownlink;  /* TSCAssistanceInformation */
static int hf_xnap_tSCAssistanceInformationUplink;  /* TSCAssistanceInformation */
static int hf_xnap_periodicity;                   /* INTEGER_0_640000_ */
static int hf_xnap_burstArrivalTime;              /* T_burstArrivalTime */
static int hf_xnap_dl_UE_AMBR;                    /* BitRate */
static int hf_xnap_ul_UE_AMBR;                    /* BitRate */
static int hf_xnap_serviceType;                   /* ServiceType */
static int hf_xnap_qOEMeasStatus;                 /* QOEMeasStatus */
static int hf_xnap_containerAppLayerMeasConfig;   /* ContainerAppLayerMeasConfig */
static int hf_xnap_mDTAlignmentInfo;              /* MDTAlignmentInfo */
static int hf_xnap_areaScopeOfQMC;                /* AreaScopeOfQMC */
static int hf_xnap_s_NSSAIListQoE;                /* S_NSSAIListQoE */
static int hf_xnap_rRCResume;                     /* UEContextIDforRRCResume */
static int hf_xnap_rRRCReestablishment;           /* UEContextIDforRRCReestablishment */
static int hf_xnap_i_rnti;                        /* I_RNTI */
static int hf_xnap_allocated_c_rnti;              /* C_RNTI */
static int hf_xnap_accessPCI;                     /* NG_RAN_CellPCI */
static int hf_xnap_c_rnti;                        /* C_RNTI */
static int hf_xnap_ng_c_UE_signalling_ref;        /* AMF_UE_NGAP_ID */
static int hf_xnap_signalling_TNL_at_source;      /* CPTransportLayerInformation */
static int hf_xnap_ueSecurityCapabilities;        /* UESecurityCapabilities */
static int hf_xnap_securityInformation;           /* AS_SecurityInformation */
static int hf_xnap_ue_AMBR;                       /* UEAggregateMaximumBitRate */
static int hf_xnap_pduSessionResourcesToBeSetup_List;  /* PDUSessionResourcesToBeSetup_List */
static int hf_xnap_rrc_Context;                   /* T_rrc_Context */
static int hf_xnap_mobilityRestrictionList;       /* MobilityRestrictionList */
static int hf_xnap_indexToRatFrequencySelectionPriority;  /* RFSP_Index */
static int hf_xnap_UEHistoryInformation_item;     /* LastVisitedCell_Item */
static int hf_xnap_nR;                            /* NRMobilityHistoryReport */
static int hf_xnap_indexLength10;                 /* BIT_STRING_SIZE_10 */
static int hf_xnap_UEIdentityIndexList_MBSGroupPaging_item;  /* UEIdentityIndexList_MBSGroupPaging_Item */
static int hf_xnap_ueIdentityIndexList_MBSGroupPagingValue;  /* UEIdentityIndexList_MBSGroupPagingValue */
static int hf_xnap_pagingDRX;                     /* UESpecificDRX */
static int hf_xnap_uEIdentityIndexValueMBSGroupPaging;  /* BIT_STRING_SIZE_10 */
static int hf_xnap_uERadioCapabilityForPagingOfNR;  /* UERadioCapabilityForPagingOfNR */
static int hf_xnap_uERadioCapabilityForPagingOfEUTRA;  /* UERadioCapabilityForPagingOfEUTRA */
static int hf_xnap_nR_UERLFReportContainer;       /* UERLFReportContainerNR */
static int hf_xnap_lTE_UERLFReportContainer;      /* UERLFReportContainerLTE */
static int hf_xnap_choice_Extension;              /* ProtocolIE_Single_Container */
static int hf_xnap_ueRLFReportContainerLTE;       /* UERLFReportContainerLTE */
static int hf_xnap_ueRLFReportContainerLTEExtendBand;  /* UERLFReportContainerLTEExtendBand */
static int hf_xnap_UESliceMaximumBitRateList_item;  /* UESliceMaximumBitRate_Item */
static int hf_xnap_dl_UE_Slice_MBR;               /* BitRate */
static int hf_xnap_ul_UE_Slice_MBR;               /* BitRate */
static int hf_xnap_nr_EncyptionAlgorithms;        /* T_nr_EncyptionAlgorithms */
static int hf_xnap_nr_IntegrityProtectionAlgorithms;  /* T_nr_IntegrityProtectionAlgorithms */
static int hf_xnap_e_utra_EncyptionAlgorithms;    /* T_e_utra_EncyptionAlgorithms */
static int hf_xnap_e_utra_IntegrityProtectionAlgorithms;  /* T_e_utra_IntegrityProtectionAlgorithms */
static int hf_xnap_uL_PDCP;                       /* UL_UE_Configuration */
static int hf_xnap_gtpTunnel;                     /* GTPtunnelTransportLayerInformation */
static int hf_xnap_UPTransportParameters_item;    /* UPTransportParametersItem */
static int hf_xnap_upTNLInfo;                     /* UPTransportLayerInformation */
static int hf_xnap_cellGroupID;                   /* CellGroupID */
static int hf_xnap_userPlaneFailureType;          /* UserPlaneFailureType */
static int hf_xnap_uL_NG_U_TNLatNG_RAN;           /* UPTransportLayerInformation */
static int hf_xnap_UEAssociatedInfoResult_List_item;  /* UEAssociatedInfoResult_Item */
static int hf_xnap_uEPerformance;                 /* UEPerformance */
static int hf_xnap_measuredUETrajectory;          /* MeasuredUETrajectory */
static int hf_xnap_dL_UE_AverageThroughput;       /* BitRate */
static int hf_xnap_uL_UE_AverageThroughput;       /* BitRate */
static int hf_xnap_uE_AveragePacketDelay;         /* AveragePacketDelay */
static int hf_xnap_uE_AveragePacketLossDL;        /* PacketLossRate */
static int hf_xnap_collectionTimeDurationForUEPerformance;  /* INTEGER_1_5000_ */
static int hf_xnap_collectionTimeDurationForUETrajectory;  /* INTEGER_1_4096_ */
static int hf_xnap_numberOfVisitedCells;          /* INTEGER_1_16_ */
static int hf_xnap_VolumeTimedReportList_item;    /* VolumeTimedReport_Item */
static int hf_xnap_startTimeStamp;                /* T_startTimeStamp */
static int hf_xnap_endTimeStamp;                  /* T_endTimeStamp */
static int hf_xnap_usageCountUL;                  /* INTEGER_0_18446744073709551615 */
static int hf_xnap_usageCountDL;                  /* INTEGER_0_18446744073709551615 */
static int hf_xnap_wlanMeasConfig;                /* WLANMeasConfig */
static int hf_xnap_wlanMeasConfigNameList;        /* WLANMeasConfigNameList */
static int hf_xnap_wlan_rssi;                     /* T_wlan_rssi */
static int hf_xnap_wlan_rtt;                      /* T_wlan_rtt */
static int hf_xnap_WLANMeasConfigNameList_item;   /* WLANName */
static int hf_xnap_protocolIEs;                   /* ProtocolIE_Container */
static int hf_xnap_ng_c_UE_reference;             /* AMF_UE_NGAP_ID */
static int hf_xnap_cp_TNL_info_source;            /* CPTransportLayerInformation */
static int hf_xnap_rrc_Context_01;                /* T_rrc_Context_01 */
static int hf_xnap_locationReportingInformation;  /* LocationReportingInformation */
static int hf_xnap_mrl;                           /* MobilityRestrictionList */
static int hf_xnap_globalNG_RANNode_ID;           /* GlobalNG_RANNode_ID */
static int hf_xnap_sN_NG_RANnodeUEXnAPID;         /* NG_RANnodeUEXnAPID */
static int hf_xnap_first_dl_count;                /* FirstDLCount */
static int hf_xnap_dl_discarding;                 /* DLDiscarding */
static int hf_xnap_dRBsSubjectToEarlyStatusTransfer;  /* DRBsSubjectToEarlyStatusTransfer_List */
static int hf_xnap_dRBsSubjectToDLDiscarding;     /* DRBsSubjectToDLDiscarding_List */
static int hf_xnap_PDUSessionToBeAddedAddReq_item;  /* PDUSessionToBeAddedAddReq_Item */
static int hf_xnap_sN_PDUSessionAMBR;             /* PDUSessionAggregateMaximumBitRate */
static int hf_xnap_sn_terminated;                 /* PDUSessionResourceSetupInfo_SNterminated */
static int hf_xnap_mn_terminated;                 /* PDUSessionResourceSetupInfo_MNterminated */
static int hf_xnap_PDUSessionAdmittedAddedAddReqAck_item;  /* PDUSessionAdmittedAddedAddReqAck_Item */
static int hf_xnap_sn_terminated_01;              /* PDUSessionResourceSetupResponseInfo_SNterminated */
static int hf_xnap_mn_terminated_01;              /* PDUSessionResourceSetupResponseInfo_MNterminated */
static int hf_xnap_pduSessionResourcesNotAdmitted_SNterminated;  /* PDUSessionResourcesNotAdmitted_List */
static int hf_xnap_pduSessionResourcesNotAdmitted_MNterminated;  /* PDUSessionResourcesNotAdmitted_List */
static int hf_xnap_responseType_ReconfComplete;   /* ResponseType_ReconfComplete */
static int hf_xnap_configuration_successfully_applied;  /* Configuration_successfully_applied */
static int hf_xnap_configuration_rejected_by_M_NG_RANNode;  /* Configuration_rejected_by_M_NG_RANNode */
static int hf_xnap_m_NG_RANNode_to_S_NG_RANNode_Container;  /* T_m_NG_RANNode_to_S_NG_RANNode_Container */
static int hf_xnap_m_NG_RANNode_to_S_NG_RANNode_Container_01;  /* T_m_NG_RANNode_to_S_NG_RANNode_Container_01 */
static int hf_xnap_s_ng_RANnodeUE_AMBR;           /* UEAggregateMaximumBitRate */
static int hf_xnap_lowerLayerPresenceStatusChange;  /* LowerLayerPresenceStatusChange */
static int hf_xnap_pduSessionResourceToBeAdded;   /* PDUSessionsToBeAdded_SNModRequest_List */
static int hf_xnap_pduSessionResourceToBeModified;  /* PDUSessionsToBeModified_SNModRequest_List */
static int hf_xnap_pduSessionResourceToBeReleased;  /* PDUSessionsToBeReleased_SNModRequest_List */
static int hf_xnap_PDUSessionsToBeAdded_SNModRequest_List_item;  /* PDUSessionsToBeAdded_SNModRequest_Item */
static int hf_xnap_PDUSessionsToBeModified_SNModRequest_List_item;  /* PDUSessionsToBeModified_SNModRequest_Item */
static int hf_xnap_sn_terminated_02;              /* PDUSessionResourceModificationInfo_SNterminated */
static int hf_xnap_mn_terminated_02;              /* PDUSessionResourceModificationInfo_MNterminated */
static int hf_xnap_pdu_session_list;              /* PDUSession_List_withCause */
static int hf_xnap_pduSessionResourcesAdmittedToBeAdded;  /* PDUSessionAdmittedToBeAddedSNModResponse */
static int hf_xnap_pduSessionResourcesAdmittedToBeModified;  /* PDUSessionAdmittedToBeModifiedSNModResponse */
static int hf_xnap_pduSessionResourcesAdmittedToBeReleased;  /* PDUSessionAdmittedToBeReleasedSNModResponse */
static int hf_xnap_PDUSessionAdmittedToBeAddedSNModResponse_item;  /* PDUSessionAdmittedToBeAddedSNModResponse_Item */
static int hf_xnap_PDUSessionAdmittedToBeModifiedSNModResponse_item;  /* PDUSessionAdmittedToBeModifiedSNModResponse_Item */
static int hf_xnap_sn_terminated_03;              /* PDUSessionResourceModificationResponseInfo_SNterminated */
static int hf_xnap_mn_terminated_03;              /* PDUSessionResourceModificationResponseInfo_MNterminated */
static int hf_xnap_sn_terminated_04;              /* PDUSession_List_withDataForwardingRequest */
static int hf_xnap_mn_terminated_04;              /* PDUSession_List_withCause */
static int hf_xnap_pdu_Session_List;              /* PDUSession_List */
static int hf_xnap_PDUSessionToBeModifiedSNModRequired_item;  /* PDUSessionToBeModifiedSNModRequired_Item */
static int hf_xnap_sn_terminated_05;              /* PDUSessionResourceModRqdInfo_SNterminated */
static int hf_xnap_mn_terminated_05;              /* PDUSessionResourceModRqdInfo_MNterminated */
static int hf_xnap_PDUSessionAdmittedModSNModConfirm_item;  /* PDUSessionAdmittedModSNModConfirm_Item */
static int hf_xnap_sn_terminated_06;              /* PDUSessionResourceModConfirmInfo_SNterminated */
static int hf_xnap_mn_terminated_06;              /* PDUSessionResourceModConfirmInfo_MNterminated */
static int hf_xnap_sn_terminated_07;              /* PDUSession_List_withDataForwardingFromTarget */
static int hf_xnap_mn_terminated_07;              /* PDUSession_List */
static int hf_xnap_pduSessionsToBeReleasedList_SNterminated;  /* PDUSession_List_withDataForwardingRequest */
static int hf_xnap_pduSessionsReleasedList_SNterminated;  /* PDUSession_List_withDataForwardingFromTarget */
static int hf_xnap_BearersSubjectToCounterCheck_List_item;  /* BearersSubjectToCounterCheck_Item */
static int hf_xnap_ul_count;                      /* INTEGER_0_4294967295 */
static int hf_xnap_dl_count;                      /* INTEGER_0_4294967295 */
static int hf_xnap_PDUSession_SNChangeRequired_List_item;  /* PDUSession_SNChangeRequired_Item */
static int hf_xnap_sn_terminated_08;              /* PDUSessionResourceChangeRequiredInfo_SNterminated */
static int hf_xnap_mn_terminated_08;              /* PDUSessionResourceChangeRequiredInfo_MNterminated */
static int hf_xnap_PDUSession_SNChangeConfirm_List_item;  /* PDUSession_SNChangeConfirm_Item */
static int hf_xnap_sn_terminated_09;              /* PDUSessionResourceChangeConfirmInfo_SNterminated */
static int hf_xnap_mn_terminated_09;              /* PDUSessionResourceChangeConfirmInfo_MNterminated */
static int hf_xnap_rrcContainer;                  /* OCTET_STRING */
static int hf_xnap_srbType;                       /* T_srbType */
static int hf_xnap_deliveryStatus;                /* DeliveryStatus */
static int hf_xnap_qOEReference_01;               /* OCTET_STRING_SIZE_6 */
static int hf_xnap_rrcContainerForRVQoEReport;    /* OCTET_STRING */
static int hf_xnap_rrcContainerForQoEReport;      /* OCTET_STRING */
static int hf_xnap_appLayerSessionStatus;         /* T_appLayerSessionStatus */
static int hf_xnap_PDUSessionResourcesNotifyList_item;  /* PDUSessionResourcesNotify_Item */
static int hf_xnap_qosFlowsNotificationContrIndInfo;  /* QoSFlowNotificationControlIndicationInfo */
static int hf_xnap_PDUSessionResourcesActivityNotifyList_item;  /* PDUSessionResourcesActivityNotify_Item */
static int hf_xnap_pduSessionLevelUPactivityreport;  /* UserPlaneTrafficActivityReport */
static int hf_xnap_qosFlowsActivityNotifyList;    /* QoSFlowsActivityNotifyList */
static int hf_xnap_QoSFlowsActivityNotifyList_item;  /* QoSFlowsActivityNotifyItem */
static int hf_xnap_gNB_01;                        /* ProtocolIE_Container */
static int hf_xnap_ng_eNB_01;                     /* ProtocolIE_Container */
static int hf_xnap_ng_eNB_02;                     /* RespondingNodeTypeConfigUpdateAck_ng_eNB */
static int hf_xnap_gNB_02;                        /* RespondingNodeTypeConfigUpdateAck_gNB */
static int hf_xnap_served_NR_Cells;               /* ServedCells_NR */
static int hf_xnap_ng_eNB_03;                     /* ResourceCoordRequest_ng_eNB_initiated */
static int hf_xnap_gNB_03;                        /* ResourceCoordRequest_gNB_initiated */
static int hf_xnap_dataTrafficResourceIndication;  /* DataTrafficResourceIndication */
static int hf_xnap_spectrumSharingGroupID;        /* SpectrumSharingGroupID */
static int hf_xnap_listofE_UTRACells;             /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_listofE_UTRACells_item;        /* E_UTRA_CGI */
static int hf_xnap_listofNRCells;                 /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_listofNRCells_item;            /* NR_CGI */
static int hf_xnap_ng_eNB_04;                     /* ResourceCoordResponse_ng_eNB_initiated */
static int hf_xnap_gNB_04;                        /* ResourceCoordResponse_gNB_initiated */
static int hf_xnap_nr_cells;                      /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_nr_cells_item;                 /* NR_CGI */
static int hf_xnap_e_utra_cells;                  /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_e_utra_cells_item;             /* E_UTRA_CGI */
static int hf_xnap_ToBeActivatedNRCellsAndSSBsList_item;  /* ToBeActivatedNRCellsAndSSBs_Item */
static int hf_xnap_nrCGI;                         /* NR_CGI */
static int hf_xnap_sSBstobeActivatedList;         /* SEQUENCE_SIZE_1_maxnoofSSBAreas_OF_SSBsToBeActivated_Item */
static int hf_xnap_sSBstobeActivatedList_item;    /* SSBsToBeActivated_Item */
static int hf_xnap_ssbIndex;                      /* INTEGER_0_63 */
static int hf_xnap_ActivatedNRCellsAndSSBsList_item;  /* ActivatedNRCellsAndSSBs_Item */
static int hf_xnap_sSBsActivatedList;             /* SEQUENCE_SIZE_1_maxnoofSSBAreas_OF_SSBsActivated_Item */
static int hf_xnap_sSBsActivatedList_item;        /* SSBsActivated_Item */
static int hf_xnap_privateIEs;                    /* PrivateIE_Container */
static int hf_xnap_TrafficToBeAddedList_item;     /* TrafficToBeAdded_Item */
static int hf_xnap_trafficProfile;                /* TrafficProfile */
static int hf_xnap_f1_TerminatingTopologyBHInformation;  /* F1_TerminatingTopologyBHInformation */
static int hf_xnap_TrafficToBeModifiedList_item;  /* TrafficToBeModified_Item */
static int hf_xnap_TrafficAddedList_item;         /* TrafficAdded_Item */
static int hf_xnap_non_F1_TerminatingTopologyBHInformation;  /* Non_F1_TerminatingTopologyBHInformation */
static int hf_xnap_TrafficModifiedList_item;      /* TrafficModified_Item */
static int hf_xnap_TrafficNotAddedList_item;      /* TrafficNotAdded_Item */
static int hf_xnap_casue;                         /* Cause */
static int hf_xnap_TrafficNotModifiedList_item;   /* TrafficNotModified_Item */
static int hf_xnap_TrafficReleasedList_item;      /* TrafficReleased_Item */
static int hf_xnap_TrafficRequiredToBeModifiedList_item;  /* TrafficRequiredToBeModified_Item */
static int hf_xnap_non_f1_TerminatingTopologyBHInformation;  /* Non_F1_TerminatingTopologyBHInformation */
static int hf_xnap_IABTNLAddressToBeReleasedList_item;  /* IABTNLAddressToBeReleased_Item */
static int hf_xnap_iabTNLAddress;                 /* IABTNLAddress */
static int hf_xnap_TrafficRequiredModifiedList_item;  /* TrafficRequiredModified_Item */
static int hf_xnap_BoundaryNodeCellsList_item;    /* BoundaryNodeCellsList_Item */
static int hf_xnap_boundaryNodeCellInformation;   /* IABCellInformation */
static int hf_xnap_ParentNodeCellsList_item;      /* ParentNodeCellsList_Item */
static int hf_xnap_parentNodeCellInformation;     /* IABCellInformation */
static int hf_xnap_initiatingMessage;             /* InitiatingMessage */
static int hf_xnap_successfulOutcome;             /* SuccessfulOutcome */
static int hf_xnap_unsuccessfulOutcome;           /* UnsuccessfulOutcome */
static int hf_xnap_initiatingMessage_value;       /* InitiatingMessage_value */
static int hf_xnap_successfulOutcome_value;       /* SuccessfulOutcome_value */
static int hf_xnap_value;                         /* UnsuccessfulOutcome_value */
/* named bits */
static int hf_xnap_RAT_RestrictionInformation_e_UTRA;
static int hf_xnap_RAT_RestrictionInformation_nR;
static int hf_xnap_RAT_RestrictionInformation_nR_unlicensed;
static int hf_xnap_RAT_RestrictionInformation_nR_LEO;
static int hf_xnap_RAT_RestrictionInformation_nR_MEO;
static int hf_xnap_RAT_RestrictionInformation_nR_GEO;
static int hf_xnap_RAT_RestrictionInformation_nR_OTHERSAT;
static int hf_xnap_T_interfaces_to_trace_ng_c;
static int hf_xnap_T_interfaces_to_trace_x_nc;
static int hf_xnap_T_interfaces_to_trace_uu;
static int hf_xnap_T_interfaces_to_trace_f1_c;
static int hf_xnap_T_interfaces_to_trace_e1;
static int hf_xnap_T_nr_EncyptionAlgorithms_spare_bit0;
static int hf_xnap_T_nr_EncyptionAlgorithms_nea1_128;
static int hf_xnap_T_nr_EncyptionAlgorithms_nea2_128;
static int hf_xnap_T_nr_EncyptionAlgorithms_nea3_128;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_spare_bit0;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia1_128;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia2_128;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia3_128;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_spare_bit0;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_eea1_128;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_eea2_128;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_eea3_128;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_spare_bit0;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia1_128;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia2_128;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia3_128;

/* Initialize the subtree pointers */
static int ett_xnap;
static int ett_xnap_RRC_Context;
static int ett_xnap_container;
static int ett_xnap_PLMN_Identity;
static int ett_xnap_measurementTimingConfiguration;
static int ett_xnap_TransportLayerAddress;
static int ett_xnap_NG_RANTraceID;
static int ett_xnap_LastVisitedEUTRANCellInformation;
static int ett_xnap_LastVisitedNGRANCellInformation;
static int ett_xnap_LastVisitedUTRANCellInformation;
static int ett_xnap_LastVisitedGERANCellInformation;
static int ett_xnap_UERadioCapabilityForPagingOfNR;
static int ett_xnap_UERadioCapabilityForPagingOfEUTRA;
static int ett_xnap_FiveGCMobilityRestrictionListContainer;
static int ett_xnap_primaryRATRestriction;
static int ett_xnap_secondaryRATRestriction;
static int ett_xnap_ImmediateMDT_EUTRA;
static int ett_xnap_MDT_Location_Info;
static int ett_xnap_MeasurementsToActivate;
static int ett_xnap_NRMobilityHistoryReport;
static int ett_xnap_RAReportContainer;
static int ett_xnap_TargetCellinEUTRAN;
static int ett_xnap_TDDULDLConfigurationCommonNR;
static int ett_xnap_UERLFReportContainerLTE;
static int ett_xnap_UERLFReportContainerNR;
static int ett_xnap_burstArrivalTime;
static int ett_xnap_ReportCharacteristics;
static int ett_xnap_NRCellPRACHConfig;
static int ett_xnap_anchorCarrier_NPRACHConfig;
static int ett_xnap_anchorCarrier_EDT_NPRACHConfig;
static int ett_xnap_anchorCarrier_Format2_NPRACHConfig;
static int ett_xnap_anchorCarrier_Format2_EDT_NPRACHConfig;
static int ett_xnap_non_anchorCarrier_NPRACHConfig;
static int ett_xnap_non_anchorCarrier_Format2_NPRACHConfig;
static int ett_xnap_anchorCarrier_NPRACHConfigTDD;
static int ett_xnap_non_anchorCarrier_NPRACHConfigTDD;
static int ett_xnap_non_anchorCarrierFrequency;
static int ett_xnap_cSI_RS_Configuration;
static int ett_xnap_sR_Configuration;
static int ett_xnap_pDCCH_ConfigSIB1;
static int ett_xnap_sCS_Common;
static int ett_xnap_LastVisitedPSCellInformation;
static int ett_xnap_MeasObjectContainer;
static int ett_xnap_RACH_Config_Common;
static int ett_xnap_RACH_Config_Common_IAB;
static int ett_xnap_ReportConfigContainer;
static int ett_xnap_RLC_Bearer_Configuration;
static int ett_xnap_SuccessfulHOReportContainer;
static int ett_xnap_UERLFReportContainerLTEExtendBand;
static int ett_xnap_MDTMode_EUTRA;
static int ett_xnap_cellmeasurementFailedReportCharacteristics;
static int ett_xnap_nodemeasurementFailedReportCharacteristics;
static int ett_xnap_ReportCharacteristicsForDataCollection;
static int ett_xnap_SRSConfiguration;
static int ett_xnap_PSCellListContainer;
static int ett_xnap_SuccessfulPSCellChangeReportContainer;
static int ett_xnap_PrivateIE_ID;
static int ett_xnap_ProtocolIE_Container;
static int ett_xnap_ProtocolIE_Field;
static int ett_xnap_ProtocolExtensionContainer;
static int ett_xnap_ProtocolExtensionField;
static int ett_xnap_PrivateIE_Container;
static int ett_xnap_PrivateIE_Field;
static int ett_xnap_A2XPC5QoSParameters;
static int ett_xnap_A2XPC5QoSFlowList;
static int ett_xnap_A2XPC5QoSFlowItem;
static int ett_xnap_A2XPC5FlowBitRates;
static int ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated;
static int ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item;
static int ett_xnap_AveragePacketDelay;
static int ett_xnap_Additional_PDCP_Duplication_TNL_List;
static int ett_xnap_Additional_PDCP_Duplication_TNL_Item;
static int ett_xnap_Additional_UL_NG_U_TNLatUPF_Item;
static int ett_xnap_Additional_UL_NG_U_TNLatUPF_List;
static int ett_xnap_Additional_Measurement_Timing_Configuration_List;
static int ett_xnap_Additional_Measurement_Timing_Configuration_Item;
static int ett_xnap_Active_MBS_SessionInformation;
static int ett_xnap_DataCollectionID;
static int ett_xnap_AllocationandRetentionPriority;
static int ett_xnap_AllowedCAG_ID_List_perPLMN;
static int ett_xnap_AllowedPNI_NPN_ID_List;
static int ett_xnap_AllowedPNI_NPN_ID_Item;
static int ett_xnap_AlternativeQoSParaSetList;
static int ett_xnap_AlternativeQoSParaSetItem;
static int ett_xnap_AMF_Region_Information;
static int ett_xnap_GlobalAMF_Region_Information;
static int ett_xnap_AreaOfInterestInformation;
static int ett_xnap_AreaOfInterest_Item;
static int ett_xnap_AreaScopeOfMDT_NR;
static int ett_xnap_AreaScopeOfMDT_EUTRA;
static int ett_xnap_AreaScopeOfNeighCellsList;
static int ett_xnap_AreaScopeOfNeighCellsItem;
static int ett_xnap_AreaScopeOfQMC;
static int ett_xnap_AS_SecurityInformation;
static int ett_xnap_AssistanceDataForRANPaging;
static int ett_xnap_Associated_QoSFlowInfo_List;
static int ett_xnap_Associated_QoSFlowInfo_Item;
static int ett_xnap_AvailableRVQoEMetrics;
static int ett_xnap_BAPRoutingID;
static int ett_xnap_BeamMeasurementsReportConfiguration;
static int ett_xnap_BeamMeasurementsReportQuantity;
static int ett_xnap_BHInfoList;
static int ett_xnap_BHInfo_Item;
static int ett_xnap_BAPControlPDURLCCH_List;
static int ett_xnap_BAPControlPDURLCCH_Item;
static int ett_xnap_BluetoothMeasurementConfiguration;
static int ett_xnap_BluetoothMeasConfigNameList;
static int ett_xnap_BPLMN_ID_Info_EUTRA;
static int ett_xnap_BPLMN_ID_Info_EUTRA_Item;
static int ett_xnap_BPLMN_ID_Info_NR;
static int ett_xnap_BPLMN_ID_Info_NR_Item;
static int ett_xnap_BroadcastCAG_Identifier_List;
static int ett_xnap_BroadcastCAG_Identifier_Item;
static int ett_xnap_BroadcastNID_List;
static int ett_xnap_BroadcastNID_Item;
static int ett_xnap_BroadcastPLMNs;
static int ett_xnap_BroadcastEUTRAPLMNs;
static int ett_xnap_BroadcastPLMNinTAISupport_Item;
static int ett_xnap_BroadcastPNI_NPN_ID_Information;
static int ett_xnap_BroadcastPNI_NPN_ID_Information_Item;
static int ett_xnap_BroadcastSNPNID_List;
static int ett_xnap_BroadcastSNPNID;
static int ett_xnap_CandidateRelayUEInfoList;
static int ett_xnap_CandidateRelayUEInfoItem;
static int ett_xnap_CapacityValueInfo;
static int ett_xnap_Cause;
static int ett_xnap_CellAssistanceInfo_NR;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI;
static int ett_xnap_CellAndCapacityAssistanceInfo_NR;
static int ett_xnap_CellAndCapacityAssistanceInfo_EUTRA;
static int ett_xnap_CellAssistanceInfo_EUTRA;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI;
static int ett_xnap_CellBasedMDT_NR;
static int ett_xnap_CellIdListforMDT_NR;
static int ett_xnap_CellBasedQMC;
static int ett_xnap_CellIdListforQMC;
static int ett_xnap_CellBasedMDT_EUTRA;
static int ett_xnap_CellIdListforMDT_EUTRA;
static int ett_xnap_CellMeasurementResult;
static int ett_xnap_CellMeasurementResult_Item;
static int ett_xnap_CellReplacingInfo;
static int ett_xnap_CellToReport;
static int ett_xnap_CellToReport_Item;
static int ett_xnap_CellToReportForDataCollection_List;
static int ett_xnap_CellToReportForDataCollection_Item;
static int ett_xnap_CellBasedUETrajectoryPrediction;
static int ett_xnap_CellMeasurementInitiationResult_List;
static int ett_xnap_CellMeasurementInitiationResult_Item;
static int ett_xnap_CellMeasurementResultForDataCollection_List;
static int ett_xnap_CellInfoResultForDataCollection_Item;
static int ett_xnap_Cell_Type_Choice;
static int ett_xnap_CellMeasurementFailureCause_List;
static int ett_xnap_CellMeasurementFailureCause_Item;
static int ett_xnap_CHOConfiguration;
static int ett_xnap_CHOCandidateCell_List;
static int ett_xnap_CHOCandidateCell_Item;
static int ett_xnap_CHOExecutionCondition_List;
static int ett_xnap_CHOExecutionCondition_Item;
static int ett_xnap_ClockQualityAcceptanceCriteria;
static int ett_xnap_ClockQualityReportingControlInfo;
static int ett_xnap_ClockQualityDetailLevel;
static int ett_xnap_CompositeAvailableCapacityGroup;
static int ett_xnap_CompositeAvailableCapacity;
static int ett_xnap_CHOinformation_Req;
static int ett_xnap_CHOTimeBasedInformation;
static int ett_xnap_CHOinformation_Ack;
static int ett_xnap_CHOinformation_AddReq;
static int ett_xnap_CHOinformation_AddReqAck;
static int ett_xnap_CHOinformation_ModReq;
static int ett_xnap_CHO_CPAC_Information;
static int ett_xnap_CHO_target_SN_node_list;
static int ett_xnap_CHO_target_SN_node_Item;
static int ett_xnap_CHO_Candidate_PSCells_list;
static int ett_xnap_CHO_Candidate_PSCells_Item;
static int ett_xnap_Conditional_Reconfig_List;
static int ett_xnap_Conditional_Reconfig_Item;
static int ett_xnap_Connectivity_Support;
static int ett_xnap_COUNT_PDCP_SN12;
static int ett_xnap_COUNT_PDCP_SN18;
static int ett_xnap_Coverage_Modification_List;
static int ett_xnap_Coverage_Modification_List_Item;
static int ett_xnap_CPTransportLayerInformation;
static int ett_xnap_CPACcandidatePSCells_list;
static int ett_xnap_CPACcandidatePSCells_item;
static int ett_xnap_CPACcandidatePSCells_wotherInfo_list;
static int ett_xnap_CPACcandidatePSCells_wotherInfo_item;
static int ett_xnap_CPACConfiguration;
static int ett_xnap_CPACCandidateCell_List;
static int ett_xnap_CPACCandidateCell_Item;
static int ett_xnap_CPACExecutionCondition_List;
static int ett_xnap_CPACExecutionCondition_Item;
static int ett_xnap_CPAInformationRequest;
static int ett_xnap_CPAInformationAck;
static int ett_xnap_CPCInformationRequired;
static int ett_xnap_CPC_target_SN_required_list;
static int ett_xnap_CPC_target_SN_required_list_Item;
static int ett_xnap_CPCInformationConfirm;
static int ett_xnap_CPC_target_SN_confirm_list;
static int ett_xnap_CPC_target_SN_confirm_list_Item;
static int ett_xnap_CPAInformationModReq;
static int ett_xnap_CPAInformationModReqAck;
static int ett_xnap_CPACInformationModRequired;
static int ett_xnap_CPCInformationUpdate;
static int ett_xnap_CPC_target_SN_mod_list;
static int ett_xnap_CPC_target_SN_mod_item;
static int ett_xnap_CPCInformationUpdatePSCells_list;
static int ett_xnap_CPCInformationUpdatePSCells_item;
static int ett_xnap_CriticalityDiagnostics;
static int ett_xnap_CriticalityDiagnostics_IE_List;
static int ett_xnap_CriticalityDiagnostics_IE_List_item;
static int ett_xnap_CSI_RS_MTC_Configuration_List;
static int ett_xnap_CSI_RS_MTC_Configuration_Item;
static int ett_xnap_CSI_RS_Neighbour_List;
static int ett_xnap_CSI_RS_Neighbour_Item;
static int ett_xnap_CSI_RS_MTC_Neighbour_List;
static int ett_xnap_CSI_RS_MTC_Neighbour_Item;
static int ett_xnap_CAGListforMDT;
static int ett_xnap_CAGListforMDTItem;
static int ett_xnap_XnUAddressInfoperPDUSession_List;
static int ett_xnap_XnUAddressInfoperPDUSession_Item;
static int ett_xnap_DataForwardingInfoFromTargetE_UTRANnode;
static int ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_List;
static int ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item;
static int ett_xnap_QoSFlowsToBeForwarded_List;
static int ett_xnap_QoSFlowsToBeForwarded_Item;
static int ett_xnap_DataForwardingInfoFromTargetNGRANnode;
static int ett_xnap_QoSFLowsAcceptedToBeForwarded_List;
static int ett_xnap_QoSFLowsAcceptedToBeForwarded_Item;
static int ett_xnap_DataforwardingandOffloadingInfofromSource;
static int ett_xnap_QoSFLowsToBeForwarded_List;
static int ett_xnap_QoSFLowsToBeForwarded_Item;
static int ett_xnap_DataForwardingResponseDRBItemList;
static int ett_xnap_DataForwardingResponseDRBItem;
static int ett_xnap_DataTrafficResourceIndication;
static int ett_xnap_DAPSRequestInfo;
static int ett_xnap_DAPSResponseInfo_List;
static int ett_xnap_DAPSResponseInfo_Item;
static int ett_xnap_DLCountChoice;
static int ett_xnap_DLF1Terminating_BHInfo;
static int ett_xnap_DLLBTFailureInformationList;
static int ett_xnap_DLLBTFailureInformationList_Item;
static int ett_xnap_DLNonF1Terminating_BHInfo;
static int ett_xnap_DRB_List;
static int ett_xnap_DRB_List_withCause;
static int ett_xnap_DRB_List_withCause_Item;
static int ett_xnap_DRBsSubjectToDLDiscarding_List;
static int ett_xnap_DRBsSubjectToDLDiscarding_Item;
static int ett_xnap_DRBsSubjectToEarlyStatusTransfer_List;
static int ett_xnap_DRBsSubjectToEarlyStatusTransfer_Item;
static int ett_xnap_DRBsSubjectToStatusTransfer_List;
static int ett_xnap_DRBsSubjectToStatusTransfer_Item;
static int ett_xnap_DRBBStatusTransferChoice;
static int ett_xnap_DRBBStatusTransfer12bitsSN;
static int ett_xnap_DRBBStatusTransfer18bitsSN;
static int ett_xnap_DRBToQoSFlowMapping_List;
static int ett_xnap_DRBToQoSFlowMapping_Item;
static int ett_xnap_DUF_Slot_Config_List;
static int ett_xnap_DUF_Slot_Config_Item;
static int ett_xnap_Dynamic5QIDescriptor;
static int ett_xnap_ECNMarkingorCongestionInformationReportingRequest;
static int ett_xnap_EquivalentSNPNs;
static int ett_xnap_E_UTRA_CGI;
static int ett_xnap_E_UTRAMultibandInfoList;
static int ett_xnap_EUTRAPagingeDRXInformation;
static int ett_xnap_E_UTRAPRACHConfiguration;
static int ett_xnap_EndpointIPAddressAndPort;
static int ett_xnap_EventTriggered;
static int ett_xnap_EventTypeTrigger;
static int ett_xnap_EventL1;
static int ett_xnap_MeasurementThresholdL1LoggedMDT;
static int ett_xnap_ExcessPacketDelayThresholdConfiguration;
static int ett_xnap_ExcessPacketDelayThresholdItem;
static int ett_xnap_ExpectedUEActivityBehaviour;
static int ett_xnap_ExpectedUEBehaviour;
static int ett_xnap_ExpectedUEMovingTrajectory;
static int ett_xnap_ExpectedUEMovingTrajectoryItem;
static int ett_xnap_ExplicitFormat;
static int ett_xnap_ExtendedRATRestrictionInformation;
static int ett_xnap_ExtendedSliceSupportList;
static int ett_xnap_ExtTLAs;
static int ett_xnap_ExtTLA_Item;
static int ett_xnap_GTPTLAs;
static int ett_xnap_GTPTLA_Item;
static int ett_xnap_F1_TerminatingTopologyBHInformation;
static int ett_xnap_F1TerminatingBHInformation_List;
static int ett_xnap_F1TerminatingBHInformation_Item;
static int ett_xnap_FiveGProSeAuthorized;
static int ett_xnap_FiveGProSePC5QoSParameters;
static int ett_xnap_FiveGProSePC5QoSFlowList;
static int ett_xnap_FiveGProSePC5QoSFlowItem;
static int ett_xnap_FiveGProSePC5FlowBitRates;
static int ett_xnap_Flows_Mapped_To_DRB_List;
static int ett_xnap_Flows_Mapped_To_DRB_Item;
static int ett_xnap_FreqDomainHSNAconfiguration_List;
static int ett_xnap_FreqDomainHSNAconfiguration_List_Item;
static int ett_xnap_FreqDomainSlotHSNAconfiguration_List;
static int ett_xnap_FreqDomainSlotHSNAconfiguration_List_Item;
static int ett_xnap_GBRQoSFlowInfo;
static int ett_xnap_GlobalgNB_ID;
static int ett_xnap_GNB_DU_Cell_Resource_Configuration;
static int ett_xnap_GNB_ID_Choice;
static int ett_xnap_GNB_RadioResourceStatus;
static int ett_xnap_GlobalCell_ID;
static int ett_xnap_GlobalngeNB_ID;
static int ett_xnap_ENB_ID_Choice;
static int ett_xnap_GlobalNG_RANCell_ID;
static int ett_xnap_GlobalNG_RANNode_ID;
static int ett_xnap_GTPtunnelTransportLayerInformation;
static int ett_xnap_GUAMI;
static int ett_xnap_HSNASlotConfigList;
static int ett_xnap_HSNASlotConfigItem;
static int ett_xnap_IABCellInformation;
static int ett_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info;
static int ett_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info;
static int ett_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info;
static int ett_xnap_IAB_MT_Cell_List;
static int ett_xnap_IAB_MT_Cell_List_Item;
static int ett_xnap_IAB_QoS_Mapping_Information;
static int ett_xnap_IAB_STC_Info;
static int ett_xnap_IAB_STC_Info_List;
static int ett_xnap_IAB_STC_Info_Item;
static int ett_xnap_IAB_TNL_Address_Request;
static int ett_xnap_IABIPv6RequestType;
static int ett_xnap_IAB_TNL_Address_Response;
static int ett_xnap_IABAllocatedTNLAddress_List;
static int ett_xnap_IABAllocatedTNLAddress_Item;
static int ett_xnap_IABTNLAddress;
static int ett_xnap_IABTNLAddressesRequested;
static int ett_xnap_IABTNLAddressToRemove_List;
static int ett_xnap_IABTNLAddressToRemove_Item;
static int ett_xnap_IABTNLAddressException;
static int ett_xnap_IABTNLAddress_Item;
static int ett_xnap_ImmediateMDT_NR;
static int ett_xnap_ImplicitFormat;
static int ett_xnap_InitiatingCondition_FailureIndication;
static int ett_xnap_IntendedTDD_DL_ULConfiguration_NR;
static int ett_xnap_I_RNTI;
static int ett_xnap_Local_NG_RAN_Node_Identifier;
static int ett_xnap_Full_and_Short_I_RNTI_Profile_List;
static int ett_xnap_Full_I_RNTI_Profile_List;
static int ett_xnap_Short_I_RNTI_Profile_List;
static int ett_xnap_LastVisitedCell_Item;
static int ett_xnap_LastVisitedPSCellList;
static int ett_xnap_LastVisitedPSCellList_Item;
static int ett_xnap_SCGUEHistoryInformation;
static int ett_xnap_ListOfCells;
static int ett_xnap_CellsinAoI_Item;
static int ett_xnap_ListOfRANNodesinAoI;
static int ett_xnap_GlobalNG_RANNodesinAoI_Item;
static int ett_xnap_ListOfTAIsinAoI;
static int ett_xnap_TAIsinAoI_Item;
static int ett_xnap_LocationReportingInformation;
static int ett_xnap_LoggedEventTriggeredConfig;
static int ett_xnap_LoggedMDT_NR;
static int ett_xnap_LTEA2XServicesAuthorized;
static int ett_xnap_LTEV2XServicesAuthorized;
static int ett_xnap_LTEUESidelinkAggregateMaximumBitRate;
static int ett_xnap_MDTAlignmentInfo;
static int ett_xnap_M1Configuration;
static int ett_xnap_M1PeriodicReporting;
static int ett_xnap_M1ThresholdEventA2;
static int ett_xnap_M4Configuration;
static int ett_xnap_M5Configuration;
static int ett_xnap_M6Configuration;
static int ett_xnap_M7Configuration;
static int ett_xnap_MaximumIPdatarate;
static int ett_xnap_MBSFNSubframeAllocation_E_UTRA;
static int ett_xnap_MBSFNSubframeInfo_E_UTRA;
static int ett_xnap_MBSFNSubframeInfo_E_UTRA_Item;
static int ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource;
static int ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item;
static int ett_xnap_MBS_DataForwardingResponseInfofromTarget;
static int ett_xnap_MBS_DataForwardingResponseInfofromTarget_Item;
static int ett_xnap_MBS_QoSFlow_List;
static int ett_xnap_MBS_QoSFlowsToAdd_List;
static int ett_xnap_MBS_QoSFlowsToAdd_Item;
static int ett_xnap_MBS_ServiceArea;
static int ett_xnap_MBS_ServiceAreaCell_List;
static int ett_xnap_MBS_ServiceAreaInformation;
static int ett_xnap_MBS_ServiceAreaInformationList;
static int ett_xnap_MBS_ServiceAreaInformation_Item;
static int ett_xnap_MBS_ServiceAreaTAI_List;
static int ett_xnap_MBS_ServiceAreaTAI_Item;
static int ett_xnap_MBS_Session_ID;
static int ett_xnap_MBS_SessionAssociatedInformation;
static int ett_xnap_MBS_SessionAssociatedInformation_Item;
static int ett_xnap_MBS_SessionInformation_List;
static int ett_xnap_MBS_SessionInformation_Item;
static int ett_xnap_MBS_SessionInformationResponse_List;
static int ett_xnap_MBS_SessionInformationResponse_Item;
static int ett_xnap_MRB_ProgressInformation;
static int ett_xnap_MDT_Configuration;
static int ett_xnap_MDT_Configuration_NR;
static int ett_xnap_MDT_Configuration_EUTRA;
static int ett_xnap_MDTPLMNList;
static int ett_xnap_MDTPLMNModificationList;
static int ett_xnap_MDTMode_NR;
static int ett_xnap_MeasurementThresholdA2;
static int ett_xnap_MIMOPRBusageInformation;
static int ett_xnap_MobilityParametersModificationRange;
static int ett_xnap_MobilityParametersInformation;
static int ett_xnap_MobilityRestrictionList;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity;
static int ett_xnap_CNTypeRestrictionsForEquivalent;
static int ett_xnap_CNTypeRestrictionsForEquivalentItem;
static int ett_xnap_RAT_RestrictionsList;
static int ett_xnap_RAT_RestrictionsItem;
static int ett_xnap_RAT_RestrictionInformation;
static int ett_xnap_ForbiddenAreaList;
static int ett_xnap_ForbiddenAreaItem;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC;
static int ett_xnap_ServiceAreaList;
static int ett_xnap_ServiceAreaItem;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC;
static int ett_xnap_MR_DC_ResourceCoordinationInfo;
static int ett_xnap_NG_RAN_Node_ResourceCoordinationInfo;
static int ett_xnap_E_UTRA_ResourceCoordinationInfo;
static int ett_xnap_NR_ResourceCoordinationInfo;
static int ett_xnap_MessageOversizeNotification;
static int ett_xnap_MT_SDT_Information;
static int ett_xnap_MultiplexingInfo;
static int ett_xnap_MeasuredUETrajectory;
static int ett_xnap_MeasuredUETrajectory_Item;
static int ett_xnap_MeasuredTrajectoryCellInfo;
static int ett_xnap_MeasuredTrajectoryNGRANCellInfo;
static int ett_xnap_N6JitterInformation;
static int ett_xnap_NACellResourceConfigurationList;
static int ett_xnap_NACellResourceConfiguration_Item;
static int ett_xnap_NE_DC_TDM_Pattern;
static int ett_xnap_NeighbourInformation_E_UTRA;
static int ett_xnap_NeighbourInformation_E_UTRA_Item;
static int ett_xnap_NeighbourInformation_NR;
static int ett_xnap_NeighbourInformation_NR_Item;
static int ett_xnap_NeighbourInformation_NR_ModeInfo;
static int ett_xnap_NeighbourInformation_NR_ModeFDDInfo;
static int ett_xnap_NeighbourInformation_NR_ModeTDDInfo;
static int ett_xnap_Neighbour_NG_RAN_Node_List;
static int ett_xnap_Neighbour_NG_RAN_Node_Item;
static int ett_xnap_NRCarrierList;
static int ett_xnap_NRCarrierItem;
static int ett_xnap_NG_RAN_Cell_Identity;
static int ett_xnap_NG_RAN_CellPCI;
static int ett_xnap_NG_RANnode2SSBOffsetsModificationRange;
static int ett_xnap_NodeAssociatedInfoResult;
static int ett_xnap_NodeMeasurementInitiationResult_List;
static int ett_xnap_NodeMeasurementInitiationResult_Item;
static int ett_xnap_NonDynamic5QIDescriptor;
static int ett_xnap_NG_eNB_RadioResourceStatus;
static int ett_xnap_TNLCapacityIndicator;
static int ett_xnap_Non_F1_TerminatingTopologyBHInformation;
static int ett_xnap_NonF1TerminatingBHInformation_List;
static int ett_xnap_NonF1TerminatingBHInformation_Item;
static int ett_xnap_NonUPTraffic;
static int ett_xnap_NPN_Broadcast_Information;
static int ett_xnap_NPN_Broadcast_Information_SNPN;
static int ett_xnap_NPN_Broadcast_Information_PNI_NPN;
static int ett_xnap_NPNMobilityInformation;
static int ett_xnap_NPNMobilityInformation_SNPN;
static int ett_xnap_NPNMobilityInformation_PNI_NPN;
static int ett_xnap_NPNPagingAssistanceInformation;
static int ett_xnap_NPNPagingAssistanceInformation_PNI_NPN;
static int ett_xnap_NPN_Support;
static int ett_xnap_NPN_Support_SNPN;
static int ett_xnap_NPRACHConfiguration;
static int ett_xnap_T_fdd_or_tdd;
static int ett_xnap_NPRACHConfiguration_FDD;
static int ett_xnap_NPRACHConfiguration_TDD;
static int ett_xnap_Non_AnchorCarrierFrequencylist;
static int ett_xnap_Non_AnchorCarrierFrequencylist_item;
static int ett_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea;
static int ett_xnap_NR_CGI;
static int ett_xnap_NR_U_Channel_List;
static int ett_xnap_NR_U_Channel_Item;
static int ett_xnap_NR_U_ChannelInfo_List;
static int ett_xnap_NR_U_ChannelInfo_Item;
static int ett_xnap_NRA2XServicesAuthorized;
static int ett_xnap_NRFrequencyBand_List;
static int ett_xnap_NRFrequencyBandItem;
static int ett_xnap_NRFrequencyInfo;
static int ett_xnap_NRModeInfo;
static int ett_xnap_NRModeInfoFDD;
static int ett_xnap_NRModeInfoTDD;
static int ett_xnap_NRPagingeDRXInformation;
static int ett_xnap_NRPagingeDRXInformationforRRCINACTIVE;
static int ett_xnap_NRPagingLongeDRXInformationforRRCINACTIVE;
static int ett_xnap_NRTransmissionBandwidth;
static int ett_xnap_NRV2XServicesAuthorized;
static int ett_xnap_NRUESidelinkAggregateMaximumBitRate;
static int ett_xnap_PositioningInformation;
static int ett_xnap_PacketErrorRate;
static int ett_xnap_PEIPSassistanceInformation;
static int ett_xnap_PC5QoSParameters;
static int ett_xnap_PC5QoSFlowList;
static int ett_xnap_PC5QoSFlowItem;
static int ett_xnap_PC5FlowBitRates;
static int ett_xnap_PDCPChangeIndication;
static int ett_xnap_PDCPSNLength;
static int ett_xnap_PDUSetQoSParameters;
static int ett_xnap_PDUSetQoSInformation;
static int ett_xnap_PDUSessionAggregateMaximumBitRate;
static int ett_xnap_PDUSession_List;
static int ett_xnap_PDUSession_List_withCause;
static int ett_xnap_PDUSession_List_withCause_Item;
static int ett_xnap_PDUSession_List_withDataForwardingFromTarget;
static int ett_xnap_PDUSession_List_withDataForwardingFromTarget_Item;
static int ett_xnap_PDUSession_List_withDataForwardingRequest;
static int ett_xnap_PDUSession_List_withDataForwardingRequest_Item;
static int ett_xnap_PDUSessionsListToBeReleased_UPError;
static int ett_xnap_PDUSessionsListToBeReleased_UPError_Item;
static int ett_xnap_PDUSessionResourcesAdmitted_List;
static int ett_xnap_PDUSessionResourcesAdmitted_Item;
static int ett_xnap_PDUSessionResourceAdmittedInfo;
static int ett_xnap_PDUSessionResourcesNotAdmitted_List;
static int ett_xnap_PDUSessionResourcesNotAdmitted_Item;
static int ett_xnap_PDUSessionResourcesToBeSetup_List;
static int ett_xnap_PDUSessionResourcesToBeSetup_Item;
static int ett_xnap_PDUSessionResourceSetupInfo_SNterminated;
static int ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated;
static int ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item;
static int ett_xnap_PDUSessionResourceSetupResponseInfo_SNterminated;
static int ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated;
static int ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item;
static int ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated;
static int ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item;
static int ett_xnap_PDUSessionResourceSetupInfo_MNterminated;
static int ett_xnap_DRBsToBeSetupList_Setup_MNterminated;
static int ett_xnap_DRBsToBeSetupList_Setup_MNterminated_Item;
static int ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated;
static int ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item;
static int ett_xnap_PDUSessionResourceSetupResponseInfo_MNterminated;
static int ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated;
static int ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item;
static int ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated;
static int ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item;
static int ett_xnap_PDUSessionResourceModificationInfo_SNterminated;
static int ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated;
static int ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item;
static int ett_xnap_DRBsToBeModified_List_Modified_SNterminated;
static int ett_xnap_DRBsToBeModified_List_Modified_SNterminated_Item;
static int ett_xnap_PDUSessionResourceModificationResponseInfo_SNterminated;
static int ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated;
static int ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item;
static int ett_xnap_PDUSessionResourceModificationInfo_MNterminated;
static int ett_xnap_DRBsToBeModifiedList_Modification_MNterminated;
static int ett_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item;
static int ett_xnap_PDUSessionResourceModificationResponseInfo_MNterminated;
static int ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated;
static int ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item;
static int ett_xnap_PDUSessionResourceChangeRequiredInfo_SNterminated;
static int ett_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated;
static int ett_xnap_PDUSessionResourceChangeRequiredInfo_MNterminated;
static int ett_xnap_PDUSessionResourceChangeConfirmInfo_MNterminated;
static int ett_xnap_PDUSessionResourceModRqdInfo_SNterminated;
static int ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated;
static int ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item;
static int ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated;
static int ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item;
static int ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated;
static int ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item;
static int ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated;
static int ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item;
static int ett_xnap_PDUSessionResourceModConfirmInfo_SNterminated;
static int ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated;
static int ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item;
static int ett_xnap_PDUSessionResourceModRqdInfo_MNterminated;
static int ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated;
static int ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item;
static int ett_xnap_PDUSessionResourceModConfirmInfo_MNterminated;
static int ett_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item;
static int ett_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item;
static int ett_xnap_PDUSessionResourceSecondaryRATUsageList;
static int ett_xnap_PDUSessionResourceSecondaryRATUsageItem;
static int ett_xnap_PDUSessionUsageReport;
static int ett_xnap_Periodical;
static int ett_xnap_PLMNAreaBasedQMC;
static int ett_xnap_PLMNListforQMC;
static int ett_xnap_PCIListForMDT;
static int ett_xnap_PosPartialUEContextInfo;
static int ett_xnap_PredictedUETrajectory_Item;
static int ett_xnap_PredictedTrajectoryCellInfo;
static int ett_xnap_PredictedTrajectoryNGRANCellInfo;
static int ett_xnap_ProtectedE_UTRAResourceIndication;
static int ett_xnap_ProtectedE_UTRAResourceList;
static int ett_xnap_ProtectedE_UTRAResource_Item;
static int ett_xnap_ProtectedE_UTRAFootprintTimePattern;
static int ett_xnap_PNI_NPN_AreaScopeofMDT;
static int ett_xnap_PNI_NPNBasedMDT;
static int ett_xnap_QMCConfigInfo;
static int ett_xnap_UEAppLayerMeasInfoList;
static int ett_xnap_UEAppLayerMeasInfo_Item;
static int ett_xnap_QMCCoordinationRequest;
static int ett_xnap_MN_to_SN_QMCCoordRequestList;
static int ett_xnap_MN_to_SN_QMCCoordRequestList_Item;
static int ett_xnap_SN_to_MN_QMCCoordRequestList;
static int ett_xnap_SN_to_MN_QMCCoordRequestList_Item;
static int ett_xnap_QMCCoordinationResponse;
static int ett_xnap_MN_to_SN_QMCCoordResponseList;
static int ett_xnap_MN_to_SN_QMCCoordResponseList_Item;
static int ett_xnap_SN_to_MN_QMCCoordResponseList;
static int ett_xnap_SN_to_MN_QMCCoordResponseList_Item;
static int ett_xnap_QoERVQoEReportingPaths;
static int ett_xnap_RVQoEConfig;
static int ett_xnap_QoSCharacteristics;
static int ett_xnap_QoSFlowLevelQoSParameters;
static int ett_xnap_QoSFlowNotificationControlIndicationInfo;
static int ett_xnap_QoSFlowNotify_Item;
static int ett_xnap_QoSFlows_List;
static int ett_xnap_QoSFlow_Item;
static int ett_xnap_QoSFlows_List_withCause;
static int ett_xnap_QoSFlowwithCause_Item;
static int ett_xnap_QoS_Mapping_Information;
static int ett_xnap_QoSFlowsAdmitted_List;
static int ett_xnap_QoSFlowsAdmitted_Item;
static int ett_xnap_QoSFlowsToBeSetup_List;
static int ett_xnap_QoSFlowsToBeSetup_Item;
static int ett_xnap_QoSFlowsUsageReportList;
static int ett_xnap_QoSFlowsUsageReport_Item;
static int ett_xnap_RAReport;
static int ett_xnap_RAReportList_Item;
static int ett_xnap_RadioResourceStatus;
static int ett_xnap_RANAreaID;
static int ett_xnap_RANAreaID_List;
static int ett_xnap_RANPagingArea;
static int ett_xnap_RANPagingAreaChoice;
static int ett_xnap_RANPagingAttemptInfo;
static int ett_xnap_RBsetConfiguration;
static int ett_xnap_RedundantPDUSessionInformation;
static int ett_xnap_ReplacingCells;
static int ett_xnap_ReplacingCells_Item;
static int ett_xnap_ReportType;
static int ett_xnap_ReservedSubframePattern;
static int ett_xnap_ResetRequestTypeInfo;
static int ett_xnap_ResetRequestTypeInfo_Full;
static int ett_xnap_ResetRequestTypeInfo_Partial;
static int ett_xnap_ResetRequestPartialReleaseList;
static int ett_xnap_ResetRequestPartialReleaseItem;
static int ett_xnap_ResetResponseTypeInfo;
static int ett_xnap_ResetResponseTypeInfo_Full;
static int ett_xnap_ResetResponseTypeInfo_Partial;
static int ett_xnap_ResetResponsePartialReleaseList;
static int ett_xnap_ResetResponsePartialReleaseItem;
static int ett_xnap_RLC_Status;
static int ett_xnap_RLCDuplicationInformation;
static int ett_xnap_RLCDuplicationStateList;
static int ett_xnap_RLCDuplicationState_Item;
static int ett_xnap_RRCConnections;
static int ett_xnap_RRCReestab_initiated;
static int ett_xnap_RRCReestab_Initiated_Reporting;
static int ett_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport;
static int ett_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport;
static int ett_xnap_RRCSetup_initiated;
static int ett_xnap_RRCSetup_Initiated_Reporting;
static int ett_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport;
static int ett_xnap_RaReportIndicationList;
static int ett_xnap_RaReportIndicationList_Item;
static int ett_xnap_RadioResourceStatusNR_U;
static int ett_xnap_S_NSSAIListQoE;
static int ett_xnap_S_BasedMDT;
static int ett_xnap_S_CPAC_Request_Info;
static int ett_xnap_S_CPAC_SecurityConfig_List;
static int ett_xnap_S_CPAC_SecurityConfig_Item;
static int ett_xnap_S_CPAC_MultiTargetSN_List;
static int ett_xnap_S_CPAC_MultiTargetSN_Item;
static int ett_xnap_SecondarydataForwardingInfoFromTarget_Item;
static int ett_xnap_SecondarydataForwardingInfoFromTarget_List;
static int ett_xnap_SDTSupportRequest;
static int ett_xnap_SDTPartialUEContextInfo;
static int ett_xnap_SDT_DRBsToBeSetupList;
static int ett_xnap_SDT_DRBsToBeSetupList_Item;
static int ett_xnap_SDT_SRBsToBeSetupList;
static int ett_xnap_SDT_SRBsToBeSetupList_Item;
static int ett_xnap_SDTDataForwardingDRBList;
static int ett_xnap_SDTDataForwardingDRBList_Item;
static int ett_xnap_SecondaryRATUsageInformation;
static int ett_xnap_SecurityIndication;
static int ett_xnap_SecurityResult;
static int ett_xnap_SensorMeasurementConfiguration;
static int ett_xnap_SensorMeasConfigNameList;
static int ett_xnap_SensorName;
static int ett_xnap_ServedCellInformation_E_UTRA;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN;
static int ett_xnap_ServedCellInformation_E_UTRA_perBPLMN;
static int ett_xnap_ServedCellInformation_E_UTRA_ModeInfo;
static int ett_xnap_ServedCellInformation_E_UTRA_FDDInfo;
static int ett_xnap_ServedCellInformation_E_UTRA_TDDInfo;
static int ett_xnap_ServedCells_E_UTRA;
static int ett_xnap_ServedCells_E_UTRA_Item;
static int ett_xnap_ServedCellsToUpdate_E_UTRA;
static int ett_xnap_ServedCells_ToModify_E_UTRA;
static int ett_xnap_ServedCells_ToModify_E_UTRA_Item;
static int ett_xnap_ServedCellInformation_NR;
static int ett_xnap_SFN_Offset;
static int ett_xnap_ServedCells_NR;
static int ett_xnap_ServedCells_NR_Item;
static int ett_xnap_ServedCells_ToModify_NR;
static int ett_xnap_ServedCells_ToModify_NR_Item;
static int ett_xnap_ServedCellSpecificInfoReq_NR;
static int ett_xnap_ServedCellSpecificInfoReq_NR_Item;
static int ett_xnap_ServedCellsToUpdate_NR;
static int ett_xnap_SharedResourceType;
static int ett_xnap_SharedResourceType_UL_OnlySharing;
static int ett_xnap_SharedResourceType_ULDL_Sharing;
static int ett_xnap_SharedResourceType_ULDL_Sharing_UL_Resources;
static int ett_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged;
static int ett_xnap_SharedResourceType_ULDL_Sharing_DL_Resources;
static int ett_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged;
static int ett_xnap_SliceAvailableCapacity;
static int ett_xnap_SliceAvailableCapacity_Item;
static int ett_xnap_SNSSAIAvailableCapacity_List;
static int ett_xnap_SNSSAIAvailableCapacity_Item;
static int ett_xnap_SliceRadioResourceStatus_List;
static int ett_xnap_SliceRadioResourceStatus_Item;
static int ett_xnap_SLPositioning_Ranging_Services_Info;
static int ett_xnap_RSPP_transport_QoS_parameters;
static int ett_xnap_RSPPQoSFlowList;
static int ett_xnap_RSPPQoSFlowItem;
static int ett_xnap_RSPPFlowBitRates;
static int ett_xnap_SNSSAIRadioResourceStatus_List;
static int ett_xnap_SNSSAIRadioResourceStatus_Item;
static int ett_xnap_SliceSupport_List;
static int ett_xnap_SliceToReport_List;
static int ett_xnap_SliceToReport_List_Item;
static int ett_xnap_SNSSAI_list;
static int ett_xnap_SNSSAI_Item;
static int ett_xnap_SlotConfiguration_List;
static int ett_xnap_SlotConfiguration_List_Item;
static int ett_xnap_S_NSSAI;
static int ett_xnap_SNPNIdentity;
static int ett_xnap_SpecialSubframeInfo_E_UTRA;
static int ett_xnap_SSBAreaCapacityValue_List;
static int ett_xnap_SSBAreaCapacityValue_List_Item;
static int ett_xnap_SSBAreaRadioResourceStatus_List;
static int ett_xnap_SSBAreaRadioResourceStatus_List_Item;
static int ett_xnap_SSB_Coverage_Modification_List;
static int ett_xnap_SSB_Coverage_Modification_List_Item;
static int ett_xnap_SSB_PositionsInBurst;
static int ett_xnap_SSBOffsets_List;
static int ett_xnap_SSBOffsets_Item;
static int ett_xnap_SSBOffsetInformation;
static int ett_xnap_SSBOffsetModificationRange;
static int ett_xnap_SSBToReport_List;
static int ett_xnap_SSBToReport_List_Item;
static int ett_xnap_SSB_transmissionBitmap;
static int ett_xnap_SuccessfulHOReportInformation;
static int ett_xnap_SuccessfulHOReportList_Item;
static int ett_xnap_SuccessfulPSCellChangeReportInformation;
static int ett_xnap_SuccessfulPSCellChangeReportList_Item;
static int ett_xnap_SUL_Information;
static int ett_xnap_Supported_MBS_FSA_ID_List;
static int ett_xnap_SupportedSULBandList;
static int ett_xnap_SupportedSULBandItem;
static int ett_xnap_SymbolAllocation_in_Slot;
static int ett_xnap_SymbolAllocation_in_Slot_AllDL;
static int ett_xnap_SymbolAllocation_in_Slot_AllUL;
static int ett_xnap_SymbolAllocation_in_Slot_BothDLandUL;
static int ett_xnap_SNPN_CellBasedMDT;
static int ett_xnap_SNPN_CellIdListforMDT;
static int ett_xnap_SNPN_CellIdforMDT_Item;
static int ett_xnap_SNPN_TAIBasedMDT;
static int ett_xnap_SNPN_TAIListforMDT;
static int ett_xnap_SNPN_TAIforMDT_Item;
static int ett_xnap_SNPN_BasedMDT;
static int ett_xnap_SNPNListforMDT;
static int ett_xnap_SNPNforMDT_Item;
static int ett_xnap_TABasedMDT;
static int ett_xnap_TAIBasedMDT;
static int ett_xnap_TAIListforMDT;
static int ett_xnap_TAIforMDT_Item;
static int ett_xnap_TAINSAGSupportList;
static int ett_xnap_TAINSAGSupportItem;
static int ett_xnap_TAISliceUnavailableCellList;
static int ett_xnap_TAISliceUnavailableCellItem;
static int ett_xnap_SliceAvailabilityList;
static int ett_xnap_AvailableCellList;
static int ett_xnap_AvailableNRCellList;
static int ett_xnap_UnavailableCellList;
static int ett_xnap_UnavailableNRCellList;
static int ett_xnap_TAISupport_List;
static int ett_xnap_TAISupport_Item;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item;
static int ett_xnap_TAListforMDT;
static int ett_xnap_TABasedQMC;
static int ett_xnap_TAListforQMC;
static int ett_xnap_TAIBasedQMC;
static int ett_xnap_TAIListforQMC;
static int ett_xnap_TAI_Item;
static int ett_xnap_Target_CGI;
static int ett_xnap_TargetCellList;
static int ett_xnap_TargetCellList_Item;
static int ett_xnap_TimeSynchronizationAssistanceInformation;
static int ett_xnap_TNLConfigurationInfo;
static int ett_xnap_TNLA_To_Add_List;
static int ett_xnap_TNLA_To_Add_Item;
static int ett_xnap_TNLA_To_Update_List;
static int ett_xnap_TNLA_To_Update_Item;
static int ett_xnap_TNLA_To_Remove_List;
static int ett_xnap_TNLA_To_Remove_Item;
static int ett_xnap_TNLA_Setup_List;
static int ett_xnap_TNLA_Setup_Item;
static int ett_xnap_TNLA_Failed_To_Setup_List;
static int ett_xnap_TNLA_Failed_To_Setup_Item;
static int ett_xnap_TraceActivation;
static int ett_xnap_T_interfaces_to_trace;
static int ett_xnap_TrafficProfile;
static int ett_xnap_TrafficReleaseType;
static int ett_xnap_TrafficToBeReleaseInformation;
static int ett_xnap_TrafficToBeRelease_List;
static int ett_xnap_TrafficToBeRelease_Item;
static int ett_xnap_TSCTrafficCharacteristics;
static int ett_xnap_TSCAssistanceInformation;
static int ett_xnap_UEAggregateMaximumBitRate;
static int ett_xnap_UEAppLayerMeasConfigInfo;
static int ett_xnap_UEContextID;
static int ett_xnap_UEContextIDforRRCResume;
static int ett_xnap_UEContextIDforRRCReestablishment;
static int ett_xnap_UEContextInfoRetrUECtxtResp;
static int ett_xnap_UEHistoryInformation;
static int ett_xnap_UEHistoryInformationFromTheUE;
static int ett_xnap_UEIdentityIndexValue;
static int ett_xnap_UEIdentityIndexList_MBSGroupPaging;
static int ett_xnap_UEIdentityIndexList_MBSGroupPaging_Item;
static int ett_xnap_UEIdentityIndexList_MBSGroupPagingValue;
static int ett_xnap_UERadioCapabilityForPaging;
static int ett_xnap_UERANPagingIdentity;
static int ett_xnap_UERLFReportContainer;
static int ett_xnap_UERLFReportContainerLTEExtension;
static int ett_xnap_UESliceMaximumBitRateList;
static int ett_xnap_UESliceMaximumBitRate_Item;
static int ett_xnap_UESecurityCapabilities;
static int ett_xnap_T_nr_EncyptionAlgorithms;
static int ett_xnap_T_nr_IntegrityProtectionAlgorithms;
static int ett_xnap_T_e_utra_EncyptionAlgorithms;
static int ett_xnap_T_e_utra_IntegrityProtectionAlgorithms;
static int ett_xnap_ULConfiguration;
static int ett_xnap_ULF1Terminating_BHInfo;
static int ett_xnap_ULNonF1Terminating_BHInfo;
static int ett_xnap_UPTransportLayerInformation;
static int ett_xnap_UPTransportParameters;
static int ett_xnap_UPTransportParametersItem;
static int ett_xnap_UserPlaneFailureIndication;
static int ett_xnap_UEAssociatedInfoResult_List;
static int ett_xnap_UEAssociatedInfoResult_Item;
static int ett_xnap_UEPerformance;
static int ett_xnap_UEPerformanceCollectionConfiguration;
static int ett_xnap_UETrajectoryCollectionConfiguration;
static int ett_xnap_VolumeTimedReportList;
static int ett_xnap_VolumeTimedReport_Item;
static int ett_xnap_WLANMeasurementConfiguration;
static int ett_xnap_WLANMeasConfigNameList;
static int ett_xnap_HandoverRequest;
static int ett_xnap_UEContextInfoHORequest;
static int ett_xnap_UEContextRefAtSN_HORequest;
static int ett_xnap_HandoverRequestAcknowledge;
static int ett_xnap_HandoverPreparationFailure;
static int ett_xnap_SNStatusTransfer;
static int ett_xnap_UEContextRelease;
static int ett_xnap_HandoverCancel;
static int ett_xnap_HandoverSuccess;
static int ett_xnap_ConditionalHandoverCancel;
static int ett_xnap_EarlyStatusTransfer;
static int ett_xnap_ProcedureStageChoice;
static int ett_xnap_FirstDLCount;
static int ett_xnap_DLDiscarding;
static int ett_xnap_RANPaging;
static int ett_xnap_RetrieveUEContextRequest;
static int ett_xnap_RetrieveUEContextResponse;
static int ett_xnap_RetrieveUEContextConfirm;
static int ett_xnap_RetrieveUEContextFailure;
static int ett_xnap_XnUAddressIndication;
static int ett_xnap_SNodeAdditionRequest;
static int ett_xnap_PDUSessionToBeAddedAddReq;
static int ett_xnap_PDUSessionToBeAddedAddReq_Item;
static int ett_xnap_SNodeAdditionRequestAcknowledge;
static int ett_xnap_PDUSessionAdmittedAddedAddReqAck;
static int ett_xnap_PDUSessionAdmittedAddedAddReqAck_Item;
static int ett_xnap_PDUSessionNotAdmittedAddReqAck;
static int ett_xnap_SNodeAdditionRequestReject;
static int ett_xnap_SNodeReconfigurationComplete;
static int ett_xnap_ResponseInfo_ReconfCompl;
static int ett_xnap_ResponseType_ReconfComplete;
static int ett_xnap_Configuration_successfully_applied;
static int ett_xnap_Configuration_rejected_by_M_NG_RANNode;
static int ett_xnap_SNodeModificationRequest;
static int ett_xnap_UEContextInfo_SNModRequest;
static int ett_xnap_PDUSessionsToBeAdded_SNModRequest_List;
static int ett_xnap_PDUSessionsToBeAdded_SNModRequest_Item;
static int ett_xnap_PDUSessionsToBeModified_SNModRequest_List;
static int ett_xnap_PDUSessionsToBeModified_SNModRequest_Item;
static int ett_xnap_PDUSessionsToBeReleased_SNModRequest_List;
static int ett_xnap_SNodeModificationRequestAcknowledge;
static int ett_xnap_PDUSessionAdmitted_SNModResponse;
static int ett_xnap_PDUSessionAdmittedToBeAddedSNModResponse;
static int ett_xnap_PDUSessionAdmittedToBeAddedSNModResponse_Item;
static int ett_xnap_PDUSessionAdmittedToBeModifiedSNModResponse;
static int ett_xnap_PDUSessionAdmittedToBeModifiedSNModResponse_Item;
static int ett_xnap_PDUSessionAdmittedToBeReleasedSNModResponse;
static int ett_xnap_PDUSessionNotAdmitted_SNModResponse;
static int ett_xnap_PDUSessionDataForwarding_SNModResponse;
static int ett_xnap_SNodeModificationRequestReject;
static int ett_xnap_SNodeModificationRequired;
static int ett_xnap_PDUSessionToBeModifiedSNModRequired;
static int ett_xnap_PDUSessionToBeModifiedSNModRequired_Item;
static int ett_xnap_PDUSessionToBeReleasedSNModRequired;
static int ett_xnap_SNodeModificationConfirm;
static int ett_xnap_PDUSessionAdmittedModSNModConfirm;
static int ett_xnap_PDUSessionAdmittedModSNModConfirm_Item;
static int ett_xnap_PDUSessionReleasedSNModConfirm;
static int ett_xnap_SNodeModificationRefuse;
static int ett_xnap_SNodeReleaseRequest;
static int ett_xnap_SNodeReleaseRequestAcknowledge;
static int ett_xnap_PDUSessionToBeReleasedList_RelReqAck;
static int ett_xnap_SNodeReleaseReject;
static int ett_xnap_SNodeReleaseRequired;
static int ett_xnap_PDUSessionToBeReleasedList_RelRqd;
static int ett_xnap_SNodeReleaseConfirm;
static int ett_xnap_PDUSessionReleasedList_RelConf;
static int ett_xnap_SNodeCounterCheckRequest;
static int ett_xnap_BearersSubjectToCounterCheck_List;
static int ett_xnap_BearersSubjectToCounterCheck_Item;
static int ett_xnap_SNodeChangeRequired;
static int ett_xnap_PDUSession_SNChangeRequired_List;
static int ett_xnap_PDUSession_SNChangeRequired_Item;
static int ett_xnap_SNodeChangeConfirm;
static int ett_xnap_PDUSession_SNChangeConfirm_List;
static int ett_xnap_PDUSession_SNChangeConfirm_Item;
static int ett_xnap_SNodeChangeRefuse;
static int ett_xnap_RRCTransfer;
static int ett_xnap_SplitSRB_RRCTransfer;
static int ett_xnap_UEReportRRCTransfer;
static int ett_xnap_FastMCGRecoveryRRCTransfer;
static int ett_xnap_SDT_SRB_between_NewNode_OldNode;
static int ett_xnap_QoE_Measurement_Results;
static int ett_xnap_NotificationControlIndication;
static int ett_xnap_PDUSessionResourcesNotifyList;
static int ett_xnap_PDUSessionResourcesNotify_Item;
static int ett_xnap_ActivityNotification;
static int ett_xnap_PDUSessionResourcesActivityNotifyList;
static int ett_xnap_PDUSessionResourcesActivityNotify_Item;
static int ett_xnap_QoSFlowsActivityNotifyList;
static int ett_xnap_QoSFlowsActivityNotifyItem;
static int ett_xnap_XnSetupRequest;
static int ett_xnap_XnSetupResponse;
static int ett_xnap_XnSetupFailure;
static int ett_xnap_NGRANNodeConfigurationUpdate;
static int ett_xnap_ConfigurationUpdateInitiatingNodeChoice;
static int ett_xnap_NGRANNodeConfigurationUpdateAcknowledge;
static int ett_xnap_RespondingNodeTypeConfigUpdateAck;
static int ett_xnap_RespondingNodeTypeConfigUpdateAck_ng_eNB;
static int ett_xnap_RespondingNodeTypeConfigUpdateAck_gNB;
static int ett_xnap_NGRANNodeConfigurationUpdateFailure;
static int ett_xnap_E_UTRA_NR_CellResourceCoordinationRequest;
static int ett_xnap_InitiatingNodeType_ResourceCoordRequest;
static int ett_xnap_ResourceCoordRequest_ng_eNB_initiated;
static int ett_xnap_ResourceCoordRequest_gNB_initiated;
static int ett_xnap_E_UTRA_NR_CellResourceCoordinationResponse;
static int ett_xnap_RespondingNodeType_ResourceCoordResponse;
static int ett_xnap_ResourceCoordResponse_ng_eNB_initiated;
static int ett_xnap_ResourceCoordResponse_gNB_initiated;
static int ett_xnap_SecondaryRATDataUsageReport;
static int ett_xnap_XnRemovalRequest;
static int ett_xnap_XnRemovalResponse;
static int ett_xnap_XnRemovalFailure;
static int ett_xnap_CellActivationRequest;
static int ett_xnap_ServedCellsToActivate;
static int ett_xnap_ToBeActivatedNRCellsAndSSBsList;
static int ett_xnap_ToBeActivatedNRCellsAndSSBs_Item;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofSSBAreas_OF_SSBsToBeActivated_Item;
static int ett_xnap_SSBsToBeActivated_Item;
static int ett_xnap_CellActivationResponse;
static int ett_xnap_ActivatedServedCells;
static int ett_xnap_ActivatedNRCellsAndSSBsList;
static int ett_xnap_ActivatedNRCellsAndSSBs_Item;
static int ett_xnap_SEQUENCE_SIZE_1_maxnoofSSBAreas_OF_SSBsActivated_Item;
static int ett_xnap_SSBsActivated_Item;
static int ett_xnap_CellActivationFailure;
static int ett_xnap_ResetRequest;
static int ett_xnap_ResetResponse;
static int ett_xnap_ErrorIndication;
static int ett_xnap_PrivateMessage;
static int ett_xnap_TraceStart;
static int ett_xnap_DeactivateTrace;
static int ett_xnap_FailureIndication;
static int ett_xnap_HandoverReport;
static int ett_xnap_ResourceStatusRequest;
static int ett_xnap_ResourceStatusResponse;
static int ett_xnap_ResourceStatusFailure;
static int ett_xnap_ResourceStatusUpdate;
static int ett_xnap_MobilityChangeRequest;
static int ett_xnap_MobilityChangeAcknowledge;
static int ett_xnap_MobilityChangeFailure;
static int ett_xnap_AccessAndMobilityIndication;
static int ett_xnap_CellTrafficTrace;
static int ett_xnap_RANMulticastGroupPaging;
static int ett_xnap_ScgFailureInformationReport;
static int ett_xnap_ScgFailureTransfer;
static int ett_xnap_F1CTrafficTransfer;
static int ett_xnap_IABTransportMigrationManagementRequest;
static int ett_xnap_TrafficToBeAddedList;
static int ett_xnap_TrafficToBeAdded_Item;
static int ett_xnap_TrafficToBeModifiedList;
static int ett_xnap_TrafficToBeModified_Item;
static int ett_xnap_IABTransportMigrationManagementResponse;
static int ett_xnap_TrafficAddedList;
static int ett_xnap_TrafficAdded_Item;
static int ett_xnap_TrafficModifiedList;
static int ett_xnap_TrafficModified_Item;
static int ett_xnap_TrafficNotAddedList;
static int ett_xnap_TrafficNotAdded_Item;
static int ett_xnap_TrafficNotModifiedList;
static int ett_xnap_TrafficNotModified_Item;
static int ett_xnap_TrafficReleasedList;
static int ett_xnap_TrafficReleased_Item;
static int ett_xnap_IABTransportMigrationManagementReject;
static int ett_xnap_IABTransportMigrationModificationRequest;
static int ett_xnap_TrafficRequiredToBeModifiedList;
static int ett_xnap_TrafficRequiredToBeModified_Item;
static int ett_xnap_IABTNLAddressToBeReleasedList;
static int ett_xnap_IABTNLAddressToBeReleased_Item;
static int ett_xnap_IABTransportMigrationModificationResponse;
static int ett_xnap_TrafficRequiredModifiedList;
static int ett_xnap_TrafficRequiredModified_Item;
static int ett_xnap_IABResourceCoordinationRequest;
static int ett_xnap_BoundaryNodeCellsList;
static int ett_xnap_BoundaryNodeCellsList_Item;
static int ett_xnap_ParentNodeCellsList;
static int ett_xnap_ParentNodeCellsList_Item;
static int ett_xnap_IABResourceCoordinationResponse;
static int ett_xnap_CPCCancel;
static int ett_xnap_PartialUEContextTransfer;
static int ett_xnap_PartialUEContextTransferAcknowledge;
static int ett_xnap_PartialUEContextTransferFailure;
static int ett_xnap_RachIndication;
static int ett_xnap_DataCollectionRequest;
static int ett_xnap_DataCollectionResponse;
static int ett_xnap_DataCollectionFailure;
static int ett_xnap_DataCollectionUpdate;
static int ett_xnap_XnAP_PDU;
static int ett_xnap_InitiatingMessage;
static int ett_xnap_SuccessfulOutcome;
static int ett_xnap_UnsuccessfulOutcome;

enum {
  XNAP_NG_RAN_CONTAINER_AUTOMATIC,
  XNAP_NG_RAN_CONTAINER_GNB,
  XNAP_NG_RAN_CONTAINER_NG_ENB
};

static const enum_val_t xnap_target_ng_ran_container_vals[] = {
  {"automatic", "automatic", XNAP_NG_RAN_CONTAINER_AUTOMATIC},
  {"gnb", "gNB", XNAP_NG_RAN_CONTAINER_GNB},
  {"ng-enb","ng-eNB", XNAP_NG_RAN_CONTAINER_NG_ENB},
  {NULL, NULL, -1}
};

enum {
  XNAP_LTE_RRC_CONTEXT_LTE,
  XNAP_LTE_RRC_CONTEXT_NBIOT
};

static const enum_val_t xnap_lte_rrc_context_vals[] = {
  {"lte", "LTE", XNAP_LTE_RRC_CONTEXT_LTE},
  {"nb-iot","NB-IoT", XNAP_LTE_RRC_CONTEXT_NBIOT},
  {NULL, NULL, -1}
};

/* Global variables */
static int xnap_dissect_target_ng_ran_container_as = XNAP_NG_RAN_CONTAINER_AUTOMATIC;
static int xnap_dissect_lte_rrc_context_as = XNAP_LTE_RRC_CONTEXT_LTE;

/* Dissector tables */
static dissector_table_t xnap_ies_dissector_table;
static dissector_table_t xnap_extension_dissector_table;
static dissector_table_t xnap_proc_imsg_dissector_table;
static dissector_table_t xnap_proc_sout_dissector_table;
static dissector_table_t xnap_proc_uout_dissector_table;

void proto_register_xnap(void);
void proto_reg_handoff_xnap(void);
static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_XnAP_PDU_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);

static dissector_handle_t xnap_handle;

static void
xnap_PacketLossRate_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1f%% (%u)", (float)v/10, v);
}

static void
xnap_PacketDelayBudget_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/2, v);
}

static void
xnap_ExtendedPacketDelayBudget_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.2fms (%u)", (float)v/100, v);
}

static void
xnap_handoverTriggerChange_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%d)", ((float)v)/2, (int32_t)v);
}

static void
xnap_Threshold_RSRP_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%u)", (int32_t)v-156, v);
}

static void
xnap_Threshold_RSRQ_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", ((float)v/2)-43, v);
}

static void
xnap_Threshold_SINR_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", ((float)v/2)-23, v);
}

static void
xnap_AveragePacketDelayValue_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/10, v);
}

static void
xnap_N6Jitter_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%d)", (float)v/2, (int32_t)v);
}

typedef enum {
  INITIATING_MESSAGE,
  SUCCESSFUL_OUTCOME,
  UNSUCCESSFUL_OUTCOME
} xnap_message_type;

struct xnap_conv_info {
  address addr_a;
  uint32_t port_a;
  GlobalNG_RANNode_ID_enum ranmode_id_a;
  address addr_b;
  uint32_t port_b;
  GlobalNG_RANNode_ID_enum ranmode_id_b;
};

struct xnap_private_data {
  struct xnap_conv_info *xnap_conv;
  xnap_message_type message_type;
  uint32_t procedure_code;
  uint32_t protocol_ie_id;
  e212_number_type_t number_type;
};

static struct xnap_private_data*
xnap_get_private_data(packet_info *pinfo)
{
  struct xnap_private_data *xnap_data = (struct xnap_private_data*)p_get_proto_data(pinfo->pool, pinfo, proto_xnap, 0);
  if (!xnap_data) {
    xnap_data = wmem_new0(pinfo->pool, struct xnap_private_data);
    p_add_proto_data(pinfo->pool, pinfo, proto_xnap, 0, xnap_data);
  }
  return xnap_data;
}

static GlobalNG_RANNode_ID_enum
xnap_get_ranmode_id(address *addr, uint32_t port, packet_info *pinfo)
{
  struct xnap_private_data *xnap_data = xnap_get_private_data(pinfo);
  GlobalNG_RANNode_ID_enum ranmode_id = (GlobalNG_RANNode_ID_enum)-1;

  if (xnap_data->xnap_conv) {
    if (addresses_equal(addr, &xnap_data->xnap_conv->addr_a) && port == xnap_data->xnap_conv->port_a) {
      ranmode_id = xnap_data->xnap_conv->ranmode_id_a;
    } else if (addresses_equal(addr, &xnap_data->xnap_conv->addr_b) && port == xnap_data->xnap_conv->port_b) {
      ranmode_id = xnap_data->xnap_conv->ranmode_id_b;
    }
  }
  return ranmode_id;
}


static const value_string xnap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_xnap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_maxPrivateIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxPrivateIEs, NULL, false);

  return offset;
}



static int
dissect_xnap_OBJECT_IDENTIFIER(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_object_identifier(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string xnap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_xnap_local          , ASN1_NO_EXTENSIONS     , dissect_xnap_INTEGER_0_maxPrivateIEs },
  {   1, &hf_xnap_global         , ASN1_NO_EXTENSIONS     , dissect_xnap_OBJECT_IDENTIFIER },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_ProcedureCode_vals[] = {
  { id_handoverPreparation, "id-handoverPreparation" },
  { id_sNStatusTransfer, "id-sNStatusTransfer" },
  { id_handoverCancel, "id-handoverCancel" },
  { id_retrieveUEContext, "id-retrieveUEContext" },
  { id_rANPaging, "id-rANPaging" },
  { id_xnUAddressIndication, "id-xnUAddressIndication" },
  { id_uEContextRelease, "id-uEContextRelease" },
  { id_sNGRANnodeAdditionPreparation, "id-sNGRANnodeAdditionPreparation" },
  { id_sNGRANnodeReconfigurationCompletion, "id-sNGRANnodeReconfigurationCompletion" },
  { id_mNGRANnodeinitiatedSNGRANnodeModificationPreparation, "id-mNGRANnodeinitiatedSNGRANnodeModificationPreparation" },
  { id_sNGRANnodeinitiatedSNGRANnodeModificationPreparation, "id-sNGRANnodeinitiatedSNGRANnodeModificationPreparation" },
  { id_mNGRANnodeinitiatedSNGRANnodeRelease, "id-mNGRANnodeinitiatedSNGRANnodeRelease" },
  { id_sNGRANnodeinitiatedSNGRANnodeRelease, "id-sNGRANnodeinitiatedSNGRANnodeRelease" },
  { id_sNGRANnodeCounterCheck, "id-sNGRANnodeCounterCheck" },
  { id_sNGRANnodeChange, "id-sNGRANnodeChange" },
  { id_rRCTransfer, "id-rRCTransfer" },
  { id_xnRemoval, "id-xnRemoval" },
  { id_xnSetup, "id-xnSetup" },
  { id_nGRANnodeConfigurationUpdate, "id-nGRANnodeConfigurationUpdate" },
  { id_cellActivation, "id-cellActivation" },
  { id_reset, "id-reset" },
  { id_errorIndication, "id-errorIndication" },
  { id_privateMessage, "id-privateMessage" },
  { id_notificationControl, "id-notificationControl" },
  { id_activityNotification, "id-activityNotification" },
  { id_e_UTRA_NR_CellResourceCoordination, "id-e-UTRA-NR-CellResourceCoordination" },
  { id_secondaryRATDataUsageReport, "id-secondaryRATDataUsageReport" },
  { id_deactivateTrace, "id-deactivateTrace" },
  { id_traceStart, "id-traceStart" },
  { id_handoverSuccess, "id-handoverSuccess" },
  { id_conditionalHandoverCancel, "id-conditionalHandoverCancel" },
  { id_earlyStatusTransfer, "id-earlyStatusTransfer" },
  { id_failureIndication, "id-failureIndication" },
  { id_handoverReport, "id-handoverReport" },
  { id_resourceStatusReportingInitiation, "id-resourceStatusReportingInitiation" },
  { id_resourceStatusReporting, "id-resourceStatusReporting" },
  { id_mobilitySettingsChange, "id-mobilitySettingsChange" },
  { id_accessAndMobilityIndication, "id-accessAndMobilityIndication" },
  { id_cellTrafficTrace, "id-cellTrafficTrace" },
  { id_RANMulticastGroupPaging, "id-RANMulticastGroupPaging" },
  { id_scgFailureInformationReport, "id-scgFailureInformationReport" },
  { id_ProcedureCode41_NotToBeUsed, "id-ProcedureCode41-NotToBeUsed" },
  { id_scgFailureTransfer, "id-scgFailureTransfer" },
  { id_f1CTrafficTransfer, "id-f1CTrafficTransfer" },
  { id_iABTransportMigrationManagement, "id-iABTransportMigrationManagement" },
  { id_iABTransportMigrationModification, "id-iABTransportMigrationModification" },
  { id_iABResourceCoordination, "id-iABResourceCoordination" },
  { id_retrieveUEContextConfirm, "id-retrieveUEContextConfirm" },
  { id_cPCCancel, "id-cPCCancel" },
  { id_partialUEContextTransfer, "id-partialUEContextTransfer" },
  { id_rachIndication, "id-rachIndication" },
  { id_dataCollectionReportingInitiation, "id-dataCollectionReportingInitiation" },
  { id_dataCollectionReporting, "id-dataCollectionReporting" },
  { 0, NULL }
};

static value_string_ext xnap_ProcedureCode_vals_ext = VALUE_STRING_EXT_INIT(xnap_ProcedureCode_vals);


static int
dissect_xnap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &xnap_data->procedure_code, false);



  return offset;
}


static const value_string xnap_ProtocolIE_ID_vals[] = {
  { id_ActivatedServedCells, "id-ActivatedServedCells" },
  { id_ActivationIDforCellActivation, "id-ActivationIDforCellActivation" },
  { id_admittedSplitSRB, "id-admittedSplitSRB" },
  { id_admittedSplitSRBrelease, "id-admittedSplitSRBrelease" },
  { id_AMF_Region_Information, "id-AMF-Region-Information" },
  { id_AssistanceDataForRANPaging, "id-AssistanceDataForRANPaging" },
  { id_BearersSubjectToCounterCheck, "id-BearersSubjectToCounterCheck" },
  { id_Cause, "id-Cause" },
  { id_cellAssistanceInfo_NR, "id-cellAssistanceInfo-NR" },
  { id_ConfigurationUpdateInitiatingNodeChoice, "id-ConfigurationUpdateInitiatingNodeChoice" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_XnUAddressInfoperPDUSession_List, "id-XnUAddressInfoperPDUSession-List" },
  { id_DRBsSubjectToStatusTransfer_List, "id-DRBsSubjectToStatusTransfer-List" },
  { id_ExpectedUEBehaviour, "id-ExpectedUEBehaviour" },
  { id_GlobalNG_RAN_node_ID, "id-GlobalNG-RAN-node-ID" },
  { id_GUAMI, "id-GUAMI" },
  { id_indexToRatFrequSelectionPriority, "id-indexToRatFrequSelectionPriority" },
  { id_initiatingNodeType_ResourceCoordRequest, "id-initiatingNodeType-ResourceCoordRequest" },
  { id_List_of_served_cells_E_UTRA, "id-List-of-served-cells-E-UTRA" },
  { id_List_of_served_cells_NR, "id-List-of-served-cells-NR" },
  { id_LocationReportingInformation, "id-LocationReportingInformation" },
  { id_MAC_I, "id-MAC-I" },
  { id_MaskedIMEISV, "id-MaskedIMEISV" },
  { id_M_NG_RANnodeUEXnAPID, "id-M-NG-RANnodeUEXnAPID" },
  { id_MN_to_SN_Container, "id-MN-to-SN-Container" },
  { id_MobilityRestrictionList, "id-MobilityRestrictionList" },
  { id_new_NG_RAN_Cell_Identity, "id-new-NG-RAN-Cell-Identity" },
  { id_newNG_RANnodeUEXnAPID, "id-newNG-RANnodeUEXnAPID" },
  { id_UEReportRRCTransfer, "id-UEReportRRCTransfer" },
  { id_oldNG_RANnodeUEXnAPID, "id-oldNG-RANnodeUEXnAPID" },
  { id_OldtoNewNG_RANnodeResumeContainer, "id-OldtoNewNG-RANnodeResumeContainer" },
  { id_PagingDRX, "id-PagingDRX" },
  { id_PCellID, "id-PCellID" },
  { id_PDCPChangeIndication, "id-PDCPChangeIndication" },
  { id_PDUSessionAdmittedAddedAddReqAck, "id-PDUSessionAdmittedAddedAddReqAck" },
  { id_PDUSessionAdmittedModSNModConfirm, "id-PDUSessionAdmittedModSNModConfirm" },
  { id_PDUSessionAdmitted_SNModResponse, "id-PDUSessionAdmitted-SNModResponse" },
  { id_PDUSessionNotAdmittedAddReqAck, "id-PDUSessionNotAdmittedAddReqAck" },
  { id_PDUSessionNotAdmitted_SNModResponse, "id-PDUSessionNotAdmitted-SNModResponse" },
  { id_PDUSessionReleasedList_RelConf, "id-PDUSessionReleasedList-RelConf" },
  { id_PDUSessionReleasedSNModConfirm, "id-PDUSessionReleasedSNModConfirm" },
  { id_PDUSessionResourcesActivityNotifyList, "id-PDUSessionResourcesActivityNotifyList" },
  { id_PDUSessionResourcesAdmitted_List, "id-PDUSessionResourcesAdmitted-List" },
  { id_PDUSessionResourcesNotAdmitted_List, "id-PDUSessionResourcesNotAdmitted-List" },
  { id_PDUSessionResourcesNotifyList, "id-PDUSessionResourcesNotifyList" },
  { id_PDUSession_SNChangeConfirm_List, "id-PDUSession-SNChangeConfirm-List" },
  { id_PDUSession_SNChangeRequired_List, "id-PDUSession-SNChangeRequired-List" },
  { id_PDUSessionToBeAddedAddReq, "id-PDUSessionToBeAddedAddReq" },
  { id_PDUSessionToBeModifiedSNModRequired, "id-PDUSessionToBeModifiedSNModRequired" },
  { id_PDUSessionToBeReleasedList_RelRqd, "id-PDUSessionToBeReleasedList-RelRqd" },
  { id_PDUSessionToBeReleased_RelReq, "id-PDUSessionToBeReleased-RelReq" },
  { id_PDUSessionToBeReleasedSNModRequired, "id-PDUSessionToBeReleasedSNModRequired" },
  { id_RANPagingArea, "id-RANPagingArea" },
  { id_PagingPriority, "id-PagingPriority" },
  { id_requestedSplitSRB, "id-requestedSplitSRB" },
  { id_requestedSplitSRBrelease, "id-requestedSplitSRBrelease" },
  { id_ResetRequestTypeInfo, "id-ResetRequestTypeInfo" },
  { id_ResetResponseTypeInfo, "id-ResetResponseTypeInfo" },
  { id_RespondingNodeTypeConfigUpdateAck, "id-RespondingNodeTypeConfigUpdateAck" },
  { id_respondingNodeType_ResourceCoordResponse, "id-respondingNodeType-ResourceCoordResponse" },
  { id_ResponseInfo_ReconfCompl, "id-ResponseInfo-ReconfCompl" },
  { id_RRCConfigIndication, "id-RRCConfigIndication" },
  { id_RRCResumeCause, "id-RRCResumeCause" },
  { id_SCGConfigurationQuery, "id-SCGConfigurationQuery" },
  { id_selectedPLMN, "id-selectedPLMN" },
  { id_ServedCellsToActivate, "id-ServedCellsToActivate" },
  { id_servedCellsToUpdate_E_UTRA, "id-servedCellsToUpdate-E-UTRA" },
  { id_ServedCellsToUpdateInitiatingNodeChoice, "id-ServedCellsToUpdateInitiatingNodeChoice" },
  { id_servedCellsToUpdate_NR, "id-servedCellsToUpdate-NR" },
  { id_s_ng_RANnode_SecurityKey, "id-s-ng-RANnode-SecurityKey" },
  { id_S_NG_RANnodeUE_AMBR, "id-S-NG-RANnodeUE-AMBR" },
  { id_S_NG_RANnodeUEXnAPID, "id-S-NG-RANnodeUEXnAPID" },
  { id_SN_to_MN_Container, "id-SN-to-MN-Container" },
  { id_sourceNG_RANnodeUEXnAPID, "id-sourceNG-RANnodeUEXnAPID" },
  { id_SplitSRB_RRCTransfer, "id-SplitSRB-RRCTransfer" },
  { id_TAISupport_list, "id-TAISupport-list" },
  { id_TimeToWait, "id-TimeToWait" },
  { id_Target2SourceNG_RANnodeTranspContainer, "id-Target2SourceNG-RANnodeTranspContainer" },
  { id_targetCellGlobalID, "id-targetCellGlobalID" },
  { id_targetNG_RANnodeUEXnAPID, "id-targetNG-RANnodeUEXnAPID" },
  { id_target_S_NG_RANnodeID, "id-target-S-NG-RANnodeID" },
  { id_TraceActivation, "id-TraceActivation" },
  { id_UEContextID, "id-UEContextID" },
  { id_UEContextInfoHORequest, "id-UEContextInfoHORequest" },
  { id_UEContextInfoRetrUECtxtResp, "id-UEContextInfoRetrUECtxtResp" },
  { id_UEContextInfo_SNModRequest, "id-UEContextInfo-SNModRequest" },
  { id_UEContextKeptIndicator, "id-UEContextKeptIndicator" },
  { id_UEContextRefAtSN_HORequest, "id-UEContextRefAtSN-HORequest" },
  { id_UEHistoryInformation, "id-UEHistoryInformation" },
  { id_UEIdentityIndexValue, "id-UEIdentityIndexValue" },
  { id_UERANPagingIdentity, "id-UERANPagingIdentity" },
  { id_UESecurityCapabilities, "id-UESecurityCapabilities" },
  { id_UserPlaneTrafficActivityReport, "id-UserPlaneTrafficActivityReport" },
  { id_XnRemovalThreshold, "id-XnRemovalThreshold" },
  { id_DesiredActNotificationLevel, "id-DesiredActNotificationLevel" },
  { id_AvailableDRBIDs, "id-AvailableDRBIDs" },
  { id_AdditionalDRBIDs, "id-AdditionalDRBIDs" },
  { id_SpareDRBIDs, "id-SpareDRBIDs" },
  { id_RequiredNumberOfDRBIDs, "id-RequiredNumberOfDRBIDs" },
  { id_TNLA_To_Add_List, "id-TNLA-To-Add-List" },
  { id_TNLA_To_Update_List, "id-TNLA-To-Update-List" },
  { id_TNLA_To_Remove_List, "id-TNLA-To-Remove-List" },
  { id_TNLA_Setup_List, "id-TNLA-Setup-List" },
  { id_TNLA_Failed_To_Setup_List, "id-TNLA-Failed-To-Setup-List" },
  { id_PDUSessionToBeReleased_RelReqAck, "id-PDUSessionToBeReleased-RelReqAck" },
  { id_S_NG_RANnodeMaxIPDataRate_UL, "id-S-NG-RANnodeMaxIPDataRate-UL" },
  { id_Unknown_106, "id-Unknown-106" },
  { id_PDUSessionResourceSecondaryRATUsageList, "id-PDUSessionResourceSecondaryRATUsageList" },
  { id_Additional_UL_NG_U_TNLatUPF_List, "id-Additional-UL-NG-U-TNLatUPF-List" },
  { id_SecondarydataForwardingInfoFromTarget_List, "id-SecondarydataForwardingInfoFromTarget-List" },
  { id_LocationInformationSNReporting, "id-LocationInformationSNReporting" },
  { id_LocationInformationSN, "id-LocationInformationSN" },
  { id_LastE_UTRANPLMNIdentity, "id-LastE-UTRANPLMNIdentity" },
  { id_S_NG_RANnodeMaxIPDataRate_DL, "id-S-NG-RANnodeMaxIPDataRate-DL" },
  { id_MaxIPrate_DL, "id-MaxIPrate-DL" },
  { id_SecurityResult, "id-SecurityResult" },
  { id_S_NSSAI, "id-S-NSSAI" },
  { id_MR_DC_ResourceCoordinationInfo, "id-MR-DC-ResourceCoordinationInfo" },
  { id_AMF_Region_Information_To_Add, "id-AMF-Region-Information-To-Add" },
  { id_AMF_Region_Information_To_Delete, "id-AMF-Region-Information-To-Delete" },
  { id_OldQoSFlowMap_ULendmarkerexpected, "id-OldQoSFlowMap-ULendmarkerexpected" },
  { id_RANPagingFailure, "id-RANPagingFailure" },
  { id_UERadioCapabilityForPaging, "id-UERadioCapabilityForPaging" },
  { id_PDUSessionDataForwarding_SNModResponse, "id-PDUSessionDataForwarding-SNModResponse" },
  { id_DRBsNotAdmittedSetupModifyList, "id-DRBsNotAdmittedSetupModifyList" },
  { id_Secondary_MN_Xn_U_TNLInfoatM, "id-Secondary-MN-Xn-U-TNLInfoatM" },
  { id_NE_DC_TDM_Pattern, "id-NE-DC-TDM-Pattern" },
  { id_PDUSessionCommonNetworkInstance, "id-PDUSessionCommonNetworkInstance" },
  { id_BPLMN_ID_Info_EUTRA, "id-BPLMN-ID-Info-EUTRA" },
  { id_BPLMN_ID_Info_NR, "id-BPLMN-ID-Info-NR" },
  { id_InterfaceInstanceIndication, "id-InterfaceInstanceIndication" },
  { id_S_NG_RANnode_Addition_Trigger_Ind, "id-S-NG-RANnode-Addition-Trigger-Ind" },
  { id_DefaultDRB_Allowed, "id-DefaultDRB-Allowed" },
  { id_DRB_IDs_takenintouse, "id-DRB-IDs-takenintouse" },
  { id_SplitSessionIndicator, "id-SplitSessionIndicator" },
  { id_CNTypeRestrictionsForEquivalent, "id-CNTypeRestrictionsForEquivalent" },
  { id_CNTypeRestrictionsForServing, "id-CNTypeRestrictionsForServing" },
  { id_DRBs_transferred_to_MN, "id-DRBs-transferred-to-MN" },
  { id_ULForwardingProposal, "id-ULForwardingProposal" },
  { id_EndpointIPAddressAndPort, "id-EndpointIPAddressAndPort" },
  { id_IntendedTDD_DL_ULConfiguration_NR, "id-IntendedTDD-DL-ULConfiguration-NR" },
  { id_TNLConfigurationInfo, "id-TNLConfigurationInfo" },
  { id_PartialListIndicator_NR, "id-PartialListIndicator-NR" },
  { id_MessageOversizeNotification, "id-MessageOversizeNotification" },
  { id_CellAndCapacityAssistanceInfo_NR, "id-CellAndCapacityAssistanceInfo-NR" },
  { id_NG_RANTraceID, "id-NG-RANTraceID" },
  { id_NonGBRResources_Offered, "id-NonGBRResources-Offered" },
  { id_FastMCGRecoveryRRCTransfer_SN_to_MN, "id-FastMCGRecoveryRRCTransfer-SN-to-MN" },
  { id_RequestedFastMCGRecoveryViaSRB3, "id-RequestedFastMCGRecoveryViaSRB3" },
  { id_AvailableFastMCGRecoveryViaSRB3, "id-AvailableFastMCGRecoveryViaSRB3" },
  { id_RequestedFastMCGRecoveryViaSRB3Release, "id-RequestedFastMCGRecoveryViaSRB3Release" },
  { id_ReleaseFastMCGRecoveryViaSRB3, "id-ReleaseFastMCGRecoveryViaSRB3" },
  { id_FastMCGRecoveryRRCTransfer_MN_to_SN, "id-FastMCGRecoveryRRCTransfer-MN-to-SN" },
  { id_ExtendedRATRestrictionInformation, "id-ExtendedRATRestrictionInformation" },
  { id_QoSMonitoringRequest, "id-QoSMonitoringRequest" },
  { id_FiveGCMobilityRestrictionListContainer, "id-FiveGCMobilityRestrictionListContainer" },
  { id_PartialListIndicator_EUTRA, "id-PartialListIndicator-EUTRA" },
  { id_CellAndCapacityAssistanceInfo_EUTRA, "id-CellAndCapacityAssistanceInfo-EUTRA" },
  { id_CHOinformation_Req, "id-CHOinformation-Req" },
  { id_CHOinformation_Ack, "id-CHOinformation-Ack" },
  { id_targetCellsToCancel, "id-targetCellsToCancel" },
  { id_requestedTargetCellGlobalID, "id-requestedTargetCellGlobalID" },
  { id_procedureStage, "id-procedureStage" },
  { id_DAPSRequestInfo, "id-DAPSRequestInfo" },
  { id_DAPSResponseInfo_List, "id-DAPSResponseInfo-List" },
  { id_CHO_MRDC_Indicator, "id-CHO-MRDC-Indicator" },
  { id_OffsetOfNbiotChannelNumberToDL_EARFCN, "id-OffsetOfNbiotChannelNumberToDL-EARFCN" },
  { id_OffsetOfNbiotChannelNumberToUL_EARFCN, "id-OffsetOfNbiotChannelNumberToUL-EARFCN" },
  { id_NBIoT_UL_DL_AlignmentOffset, "id-NBIoT-UL-DL-AlignmentOffset" },
  { id_LTEV2XServicesAuthorized, "id-LTEV2XServicesAuthorized" },
  { id_NRV2XServicesAuthorized, "id-NRV2XServicesAuthorized" },
  { id_LTEUESidelinkAggregateMaximumBitRate, "id-LTEUESidelinkAggregateMaximumBitRate" },
  { id_NRUESidelinkAggregateMaximumBitRate, "id-NRUESidelinkAggregateMaximumBitRate" },
  { id_PC5QoSParameters, "id-PC5QoSParameters" },
  { id_AlternativeQoSParaSetList, "id-AlternativeQoSParaSetList" },
  { id_CurrentQoSParaSetIndex, "id-CurrentQoSParaSetIndex" },
  { id_MobilityInformation, "id-MobilityInformation" },
  { id_InitiatingCondition_FailureIndication, "id-InitiatingCondition-FailureIndication" },
  { id_UEHistoryInformationFromTheUE, "id-UEHistoryInformationFromTheUE" },
  { id_HandoverReportType, "id-HandoverReportType" },
  { id_HandoverCause, "id-HandoverCause" },
  { id_SourceCellCGI, "id-SourceCellCGI" },
  { id_TargetCellCGI, "id-TargetCellCGI" },
  { id_ReEstablishmentCellCGI, "id-ReEstablishmentCellCGI" },
  { id_TargetCellinEUTRAN, "id-TargetCellinEUTRAN" },
  { id_SourceCellCRNTI, "id-SourceCellCRNTI" },
  { id_UERLFReportContainer, "id-UERLFReportContainer" },
  { id_NGRAN_Node1_Measurement_ID, "id-NGRAN-Node1-Measurement-ID" },
  { id_NGRAN_Node2_Measurement_ID, "id-NGRAN-Node2-Measurement-ID" },
  { id_RegistrationRequest, "id-RegistrationRequest" },
  { id_ReportCharacteristics, "id-ReportCharacteristics" },
  { id_CellToReport, "id-CellToReport" },
  { id_ReportingPeriodicity, "id-ReportingPeriodicity" },
  { id_CellMeasurementResult, "id-CellMeasurementResult" },
  { id_NG_RANnode1CellID, "id-NG-RANnode1CellID" },
  { id_NG_RANnode2CellID, "id-NG-RANnode2CellID" },
  { id_NG_RANnode1MobilityParameters, "id-NG-RANnode1MobilityParameters" },
  { id_NG_RANnode2ProposedMobilityParameters, "id-NG-RANnode2ProposedMobilityParameters" },
  { id_MobilityParametersModificationRange, "id-MobilityParametersModificationRange" },
  { id_TDDULDLConfigurationCommonNR, "id-TDDULDLConfigurationCommonNR" },
  { id_CarrierList, "id-CarrierList" },
  { id_ULCarrierList, "id-ULCarrierList" },
  { id_FrequencyShift7p5khz, "id-FrequencyShift7p5khz" },
  { id_SSB_PositionsInBurst, "id-SSB-PositionsInBurst" },
  { id_NRCellPRACHConfig, "id-NRCellPRACHConfig" },
  { id_RAReport, "id-RAReport" },
  { id_IABNodeIndication, "id-IABNodeIndication" },
  { id_Redundant_UL_NG_U_TNLatUPF, "id-Redundant-UL-NG-U-TNLatUPF" },
  { id_CNPacketDelayBudgetDownlink, "id-CNPacketDelayBudgetDownlink" },
  { id_CNPacketDelayBudgetUplink, "id-CNPacketDelayBudgetUplink" },
  { id_Additional_Redundant_UL_NG_U_TNLatUPF_List, "id-Additional-Redundant-UL-NG-U-TNLatUPF-List" },
  { id_RedundantCommonNetworkInstance, "id-RedundantCommonNetworkInstance" },
  { id_TSCTrafficCharacteristics, "id-TSCTrafficCharacteristics" },
  { id_RedundantQoSFlowIndicator, "id-RedundantQoSFlowIndicator" },
  { id_Redundant_DL_NG_U_TNLatNG_RAN, "id-Redundant-DL-NG-U-TNLatNG-RAN" },
  { id_ExtendedPacketDelayBudget, "id-ExtendedPacketDelayBudget" },
  { id_Additional_PDCP_Duplication_TNL_List, "id-Additional-PDCP-Duplication-TNL-List" },
  { id_RedundantPDUSessionInformation, "id-RedundantPDUSessionInformation" },
  { id_UsedRSNInformation, "id-UsedRSNInformation" },
  { id_RLCDuplicationInformation, "id-RLCDuplicationInformation" },
  { id_NPN_Broadcast_Information, "id-NPN-Broadcast-Information" },
  { id_NPNPagingAssistanceInformation, "id-NPNPagingAssistanceInformation" },
  { id_NPNMobilityInformation, "id-NPNMobilityInformation" },
  { id_NPN_Support, "id-NPN-Support" },
  { id_MDT_Configuration, "id-MDT-Configuration" },
  { id_MDTPLMNList, "id-MDTPLMNList" },
  { id_TraceCollectionEntityURI, "id-TraceCollectionEntityURI" },
  { id_UERadioCapabilityID, "id-UERadioCapabilityID" },
  { id_CSI_RSTransmissionIndication, "id-CSI-RSTransmissionIndication" },
  { id_SNTriggered, "id-SNTriggered" },
  { id_DLCarrierList, "id-DLCarrierList" },
  { id_ExtendedTAISliceSupportList, "id-ExtendedTAISliceSupportList" },
  { id_cellAssistanceInfo_EUTRA, "id-cellAssistanceInfo-EUTRA" },
  { id_ConfiguredTACIndication, "id-ConfiguredTACIndication" },
  { id_secondary_SN_UL_PDCP_UP_TNLInfo, "id-secondary-SN-UL-PDCP-UP-TNLInfo" },
  { id_pdcpDuplicationConfiguration, "id-pdcpDuplicationConfiguration" },
  { id_duplicationActivation, "id-duplicationActivation" },
  { id_NPRACHConfiguration, "id-NPRACHConfiguration" },
  { id_QosMonitoringReportingFrequency, "id-QosMonitoringReportingFrequency" },
  { id_QoSFlowsMappedtoDRB_SetupResponse_MNterminated, "id-QoSFlowsMappedtoDRB-SetupResponse-MNterminated" },
  { id_DL_scheduling_PDCCH_CCE_usage, "id-DL-scheduling-PDCCH-CCE-usage" },
  { id_UL_scheduling_PDCCH_CCE_usage, "id-UL-scheduling-PDCCH-CCE-usage" },
  { id_SFN_Offset, "id-SFN-Offset" },
  { id_QoSMonitoringDisabled, "id-QoSMonitoringDisabled" },
  { id_ExtendedUEIdentityIndexValue, "id-ExtendedUEIdentityIndexValue" },
  { id_EUTRAPagingeDRXInformation, "id-EUTRAPagingeDRXInformation" },
  { id_CHO_MRDC_EarlyDataForwarding, "id-CHO-MRDC-EarlyDataForwarding" },
  { id_SCGIndicator, "id-SCGIndicator" },
  { id_UESpecificDRX, "id-UESpecificDRX" },
  { id_PDUSessionExpectedUEActivityBehaviour, "id-PDUSessionExpectedUEActivityBehaviour" },
  { id_QoS_Mapping_Information, "id-QoS-Mapping-Information" },
  { id_AdditionLocationInformation, "id-AdditionLocationInformation" },
  { id_dataForwardingInfoFromTargetE_UTRANnode, "id-dataForwardingInfoFromTargetE-UTRANnode" },
  { id_DirectForwardingPathAvailability, "id-DirectForwardingPathAvailability" },
  { id_SourceNG_RAN_node_ID, "id-SourceNG-RAN-node-ID" },
  { id_SourceDLForwardingIPAddress, "id-SourceDLForwardingIPAddress" },
  { id_SourceNodeDLForwardingIPAddress, "id-SourceNodeDLForwardingIPAddress" },
  { id_ExtendedReportIntervalMDT, "id-ExtendedReportIntervalMDT" },
  { id_SecurityIndication, "id-SecurityIndication" },
  { id_RRCConnReestab_Indicator, "id-RRCConnReestab-Indicator" },
  { id_TargetNodeID, "id-TargetNodeID" },
  { id_ManagementBasedMDTPLMNList, "id-ManagementBasedMDTPLMNList" },
  { id_PrivacyIndicator, "id-PrivacyIndicator" },
  { id_TraceCollectionEntityIPAddress, "id-TraceCollectionEntityIPAddress" },
  { id_M4ReportAmount, "id-M4ReportAmount" },
  { id_M5ReportAmount, "id-M5ReportAmount" },
  { id_M6ReportAmount, "id-M6ReportAmount" },
  { id_M7ReportAmount, "id-M7ReportAmount" },
  { id_BeamMeasurementIndicationM1, "id-BeamMeasurementIndicationM1" },
  { id_MBS_Session_ID, "id-MBS-Session-ID" },
  { id_UEIdentityIndexList_MBSGroupPaging, "id-UEIdentityIndexList-MBSGroupPaging" },
  { id_MulticastRANPagingArea, "id-MulticastRANPagingArea" },
  { id_Supported_MBS_FSA_ID_List, "id-Supported-MBS-FSA-ID-List" },
  { id_MBS_SessionInformation_List, "id-MBS-SessionInformation-List" },
  { id_MBS_SessionInformationResponse_List, "id-MBS-SessionInformationResponse-List" },
  { id_MBS_SessionAssociatedInformation, "id-MBS-SessionAssociatedInformation" },
  { id_SuccessfulHOReportInformation, "id-SuccessfulHOReportInformation" },
  { id_SliceRadioResourceStatus_List, "id-SliceRadioResourceStatus-List" },
  { id_CompositeAvailableCapacitySupplementaryUplink, "id-CompositeAvailableCapacitySupplementaryUplink" },
  { id_SCGUEHistoryInformation, "id-SCGUEHistoryInformation" },
  { id_SSBOffsets_List, "id-SSBOffsets-List" },
  { id_NG_RANnode2SSBOffsetModificationRange, "id-NG-RANnode2SSBOffsetModificationRange" },
  { id_Coverage_Modification_List, "id-Coverage-Modification-List" },
  { id_NR_U_Channel_List, "id-NR-U-Channel-List" },
  { id_SourcePSCellCGI, "id-SourcePSCellCGI" },
  { id_FailedPSCellCGI, "id-FailedPSCellCGI" },
  { id_SCGFailureReportContainer, "id-SCGFailureReportContainer" },
  { id_SNMobilityInformation, "id-SNMobilityInformation" },
  { id_SourcePSCellID, "id-SourcePSCellID" },
  { id_SuitablePSCellCGI, "id-SuitablePSCellCGI" },
  { id_PSCellChangeHistory, "id-PSCellChangeHistory" },
  { id_CHOConfiguration, "id-CHOConfiguration" },
  { id_NR_U_ChannelInfo_List, "id-NR-U-ChannelInfo-List" },
  { id_PSCellHistoryInformationRetrieve, "id-PSCellHistoryInformationRetrieve" },
  { id_NG_RANnode2SSBOffsetsModificationRange, "id-NG-RANnode2SSBOffsetsModificationRange" },
  { id_MIMOPRBusageInformation, "id-MIMOPRBusageInformation" },
  { id_F1CTrafficContainer, "id-F1CTrafficContainer" },
  { id_IAB_MT_Cell_List, "id-IAB-MT-Cell-List" },
  { id_NoPDUSessionIndication, "id-NoPDUSessionIndication" },
  { id_IAB_TNL_Address_Request, "id-IAB-TNL-Address-Request" },
  { id_IAB_TNL_Address_Response, "id-IAB-TNL-Address-Response" },
  { id_TrafficToBeAddedList, "id-TrafficToBeAddedList" },
  { id_TrafficToBeModifiedList, "id-TrafficToBeModifiedList" },
  { id_TrafficToBeReleaseInformation, "id-TrafficToBeReleaseInformation" },
  { id_TrafficAddedList, "id-TrafficAddedList" },
  { id_TrafficModifiedList, "id-TrafficModifiedList" },
  { id_TrafficNotAddedList, "id-TrafficNotAddedList" },
  { id_TrafficNotModifiedList, "id-TrafficNotModifiedList" },
  { id_TrafficRequiredToBeModifiedList, "id-TrafficRequiredToBeModifiedList" },
  { id_TrafficRequiredModifiedList, "id-TrafficRequiredModifiedList" },
  { id_TrafficReleasedList, "id-TrafficReleasedList" },
  { id_IABTNLAddressToBeAdded, "id-IABTNLAddressToBeAdded" },
  { id_IABTNLAddressToBeReleasedList, "id-IABTNLAddressToBeReleasedList" },
  { id_nonF1_Terminating_IAB_DonorUEXnAPID, "id-nonF1-Terminating-IAB-DonorUEXnAPID" },
  { id_F1_Terminating_IAB_DonorUEXnAPID, "id-F1-Terminating-IAB-DonorUEXnAPID" },
  { id_BoundaryNodeCellsList, "id-BoundaryNodeCellsList" },
  { id_ParentNodeCellsList, "id-ParentNodeCellsList" },
  { id_tdd_GNB_DU_Cell_Resource_Configuration, "id-tdd-GNB-DU-Cell-Resource-Configuration" },
  { id_UL_GNB_DU_Cell_Resource_Configuration, "id-UL-GNB-DU-Cell-Resource-Configuration" },
  { id_DL_GNB_DU_Cell_Resource_Configuration, "id-DL-GNB-DU-Cell-Resource-Configuration" },
  { id_permutation, "id-permutation" },
  { id_IABTNLAddressException, "id-IABTNLAddressException" },
  { id_CHOinformation_AddReq, "id-CHOinformation-AddReq" },
  { id_CHOinformation_ModReq, "id-CHOinformation-ModReq" },
  { id_SurvivalTime, "id-SurvivalTime" },
  { id_TimeSynchronizationAssistanceInformation, "id-TimeSynchronizationAssistanceInformation" },
  { id_SCGActivationRequest, "id-SCGActivationRequest" },
  { id_SCGActivationStatus, "id-SCGActivationStatus" },
  { id_CPAInformationRequest, "id-CPAInformationRequest" },
  { id_CPAInformationAck, "id-CPAInformationAck" },
  { id_CPCInformationRequired, "id-CPCInformationRequired" },
  { id_CPCInformationConfirm, "id-CPCInformationConfirm" },
  { id_CPAInformationModReq, "id-CPAInformationModReq" },
  { id_CPAInformationModReqAck, "id-CPAInformationModReqAck" },
  { id_CPC_DataForwarding_Indicator, "id-CPC-DataForwarding-Indicator" },
  { id_CPCInformationUpdate, "id-CPCInformationUpdate" },
  { id_CPACInformationModRequired, "id-CPACInformationModRequired" },
  { id_QMCConfigInfo, "id-QMCConfigInfo" },
  { id_ProtocolIE_ID338_NotToBeUsed, "id-ProtocolIE-ID338-NotToBeUsed" },
  { id_Additional_Measurement_Timing_Configuration_List, "id-Additional-Measurement-Timing-Configuration-List" },
  { id_PDUSession_PairID, "id-PDUSession-PairID" },
  { id_Local_NG_RAN_Node_Identifier, "id-Local-NG-RAN-Node-Identifier" },
  { id_Neighbour_NG_RAN_Node_List, "id-Neighbour-NG-RAN-Node-List" },
  { id_Local_NG_RAN_Node_Identifier_Removal, "id-Local-NG-RAN-Node-Identifier-Removal" },
  { id_FiveGProSeAuthorized, "id-FiveGProSeAuthorized" },
  { id_FiveGProSePC5QoSParameters, "id-FiveGProSePC5QoSParameters" },
  { id_FiveGProSeUEPC5AggregateMaximumBitRate, "id-FiveGProSeUEPC5AggregateMaximumBitRate" },
  { id_ServedCellSpecificInfoReq_NR, "id-ServedCellSpecificInfoReq-NR" },
  { id_NRPagingeDRXInformation, "id-NRPagingeDRXInformation" },
  { id_NRPagingeDRXInformationforRRCINACTIVE, "id-NRPagingeDRXInformationforRRCINACTIVE" },
  { id_Redcap_Bcast_Information, "id-Redcap-Bcast-Information" },
  { id_SDTSupportRequest, "id-SDTSupportRequest" },
  { id_SDT_SRB_between_NewNode_OldNode, "id-SDT-SRB-between-NewNode-OldNode" },
  { id_SDT_Termination_Request, "id-SDT-Termination-Request" },
  { id_SDTPartialUEContextInfo, "id-SDTPartialUEContextInfo" },
  { id_SDTDataForwardingDRBList, "id-SDTDataForwardingDRBList" },
  { id_PagingCause, "id-PagingCause" },
  { id_PEIPSassistanceInformation, "id-PEIPSassistanceInformation" },
  { id_UESliceMaximumBitRateList, "id-UESliceMaximumBitRateList" },
  { id_S_NG_RANnodeUE_Slice_MBR, "id-S-NG-RANnodeUE-Slice-MBR" },
  { id_PositioningInformation, "id-PositioningInformation" },
  { id_UEAssistantIdentifier, "id-UEAssistantIdentifier" },
  { id_ManagementBasedMDTPLMNModificationList, "id-ManagementBasedMDTPLMNModificationList" },
  { id_F1_terminatingIAB_donorIndicator, "id-F1-terminatingIAB-donorIndicator" },
  { id_TAINSAGSupportList, "id-TAINSAGSupportList" },
  { id_SCGreconfigNotification, "id-SCGreconfigNotification" },
  { id_earlyMeasurement, "id-earlyMeasurement" },
  { id_BeamMeasurementsReportConfiguration, "id-BeamMeasurementsReportConfiguration" },
  { id_CoverageModificationCause, "id-CoverageModificationCause" },
  { id_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated, "id-AdditionalListofPDUSessionResourceChangeConfirmInfo-SNterminated" },
  { id_UERLFReportContainerLTEExtension, "id-UERLFReportContainerLTEExtension" },
  { id_ExcessPacketDelayThresholdConfiguration, "id-ExcessPacketDelayThresholdConfiguration" },
  { id_HashedUEIdentityIndexValue, "id-HashedUEIdentityIndexValue" },
  { id_QosFlowMappingIndication, "id-QosFlowMappingIndication" },
  { id_Full_and_Short_I_RNTI_Profile_List, "id-Full-and-Short-I-RNTI-Profile-List" },
  { id_MBS_DataForwarding_Indicator, "id-MBS-DataForwarding-Indicator" },
  { id_IABAuthorizationStatus, "id-IABAuthorizationStatus" },
  { id_EquivalentSNPNs, "id-EquivalentSNPNs" },
  { id_SelectedNID, "id-SelectedNID" },
  { id_MT_SDT_Information, "id-MT-SDT-Information" },
  { id_PosPartialUEContextInfo, "id-PosPartialUEContextInfo" },
  { id_SRSConfiguration, "id-SRSConfiguration" },
  { id_CHOTimeBasedInformation, "id-CHOTimeBasedInformation" },
  { id_ChannelOccupancyTimePercentageUL, "id-ChannelOccupancyTimePercentageUL" },
  { id_EnergyDetectionThresholdUL, "id-EnergyDetectionThresholdUL" },
  { id_SuccessfulPSCellChangeReportInformation, "id-SuccessfulPSCellChangeReportInformation" },
  { id_PSCellListContainer, "id-PSCellListContainer" },
  { id_RadioResourceStatusNR_U, "id-RadioResourceStatusNR-U" },
  { id_CPACConfiguration, "id-CPACConfiguration" },
  { id_RaReportIndicationList, "id-RaReportIndicationList" },
  { id_SPRAvailability, "id-SPRAvailability" },
  { id_DLLBTFailureInformationRequest, "id-DLLBTFailureInformationRequest" },
  { id_DLLBTFailureInformationList, "id-DLLBTFailureInformationList" },
  { id_TargetCellCRNTI, "id-TargetCellCRNTI" },
  { id_TimeSinceFailure, "id-TimeSinceFailure" },
  { id_AerialUESubscriptionInformation, "id-AerialUESubscriptionInformation" },
  { id_LTEA2XServicesAuthorized, "id-LTEA2XServicesAuthorized" },
  { id_NRA2XServicesAuthorized, "id-NRA2XServicesAuthorized" },
  { id_LTEA2XUEPC5AggregateMaximumBitRate, "id-LTEA2XUEPC5AggregateMaximumBitRate" },
  { id_NRA2XUEPC5AggregateMaximumBitRate, "id-NRA2XUEPC5AggregateMaximumBitRate" },
  { id_A2XPC5QoSParameters, "id-A2XPC5QoSParameters" },
  { id_CellBasedUETrajectoryPrediction, "id-CellBasedUETrajectoryPrediction" },
  { id_DataCollectionID, "id-DataCollectionID" },
  { id_RequestedPredictionTime, "id-RequestedPredictionTime" },
  { id_NodeMeasurementInitiationResult_List, "id-NodeMeasurementInitiationResult-List" },
  { id_CellMeasurementInitiationResult_List, "id-CellMeasurementInitiationResult-List" },
  { id_UEAssociatedInfoResult_List, "id-UEAssociatedInfoResult-List" },
  { id_ProtocolIE_ID_407_not_to_be_used, "id-ProtocolIE-ID-407-not-to-be-used" },
  { id_UETrajectoryCollectionConfiguration, "id-UETrajectoryCollectionConfiguration" },
  { id_UEPerformanceCollectionConfiguration, "id-UEPerformanceCollectionConfiguration" },
  { id_CellMeasurementResultForDataCollection_List, "id-CellMeasurementResultForDataCollection-List" },
  { id_CellToReportForDataCollection_List, "id-CellToReportForDataCollection-List" },
  { id_FiveGProSeLayer2Multipath, "id-FiveGProSeLayer2Multipath" },
  { id_FiveGProSeLayer2UEtoUERelay, "id-FiveGProSeLayer2UEtoUERelay" },
  { id_FiveGProSeLayer2UEtoUERemote, "id-FiveGProSeLayer2UEtoUERemote" },
  { id_CandidateRelayUEInfoList, "id-CandidateRelayUEInfoList" },
  { id_NRCellsAndSSBsList, "id-NRCellsAndSSBsList" },
  { id_ActivatedNRCellsAndSSBsList, "id-ActivatedNRCellsAndSSBsList" },
  { id_ClockQualityReportingControlInfo, "id-ClockQualityReportingControlInfo" },
  { id_CapabilityForBATAdaptation, "id-CapabilityForBATAdaptation" },
  { id_PNI_NPN_AreaScopeofMDT, "id-PNI-NPN-AreaScopeofMDT" },
  { id_PNI_NPNBasedMDT, "id-PNI-NPNBasedMDT" },
  { id_SNPN_CellBasedMDT, "id-SNPN-CellBasedMDT" },
  { id_SNPN_TAIBasedMDT, "id-SNPN-TAIBasedMDT" },
  { id_SNPN_BasedMDT, "id-SNPN-BasedMDT" },
  { id_S_CPAC_Request, "id-S-CPAC-Request" },
  { id_S_CPAC_Request_Info, "id-S-CPAC-Request-Info" },
  { id_S_CPAC_ReferenceConfigRequest, "id-S-CPAC-ReferenceConfigRequest" },
  { id_S_CPAC_InterSN_ExecutionNotify, "id-S-CPAC-InterSN-ExecutionNotify" },
  { id_S_CPAC_dataforwardinginfofromSource, "id-S-CPAC-dataforwardinginfofromSource" },
  { id_CPACcandidatePSCells_wotherInfo_list, "id-CPACcandidatePSCells-wotherInfo-list" },
  { id_eRedcap_Bcast_Information, "id-eRedcap-Bcast-Information" },
  { id_NRPagingLongeDRXInformationforRRCINACTIVE, "id-NRPagingLongeDRXInformationforRRCINACTIVE" },
  { id_MBS_AssistanceInformation, "id-MBS-AssistanceInformation" },
  { id_QMCCoordinationRequest, "id-QMCCoordinationRequest" },
  { id_QMCCoordinationResponse, "id-QMCCoordinationResponse" },
  { id_QoE_Measurement_Results, "id-QoE-Measurement-Results" },
  { id_MBSCommServiceType, "id-MBSCommServiceType" },
  { id_AssistanceInformationQoE_Meas, "id-AssistanceInformationQoE-Meas" },
  { id_ProtocolIE_ID_439_not_to_be_used, "id-ProtocolIE-ID-439-not-to-be-used" },
  { id_QoERVQoEReportingPaths, "id-QoERVQoEReportingPaths" },
  { id_Src_SN_to_Tgt_SNQMCInfoInquiry, "id-Src-SN-to-Tgt-SNQMCInfoInquiry" },
  { id_DirectForwardingPathAvailabilityWithSourceMN, "id-DirectForwardingPathAvailabilityWithSourceMN" },
  { id_CHO_Maxnoof_CondReconfig, "id-CHO-Maxnoof-CondReconfig" },
  { id_accessed_PSCellID, "id-accessed-PSCellID" },
  { id_conditional_Reconfig_ToCancel_List, "id-conditional-Reconfig-ToCancel-List" },
  { id_CHOinformation_AddReqAck, "id-CHOinformation-AddReqAck" },
  { id_CHO_CPAC_Info, "id-CHO-CPAC-Info" },
  { id_PDUSetQoSParameters, "id-PDUSetQoSParameters" },
  { id_N6JitterInformation, "id-N6JitterInformation" },
  { id_ECNMarkingorCongestionInformationReportingRequest, "id-ECNMarkingorCongestionInformationReportingRequest" },
  { id_PDUSetbasedHandlingIndicator, "id-PDUSetbasedHandlingIndicator" },
  { id_TAISliceUnavailableCellList, "id-TAISliceUnavailableCellList" },
  { id_MobileIAB_AuthorizationStatus, "id-MobileIAB-AuthorizationStatus" },
  { id_MIAB_MT_BAP_Address, "id-MIAB-MT-BAP-Address" },
  { id_MobileIABCell, "id-MobileIABCell" },
  { id_sk_Counter, "id-sk-Counter" },
  { id_Source_M_NG_RANnodeID, "id-Source-M-NG-RANnodeID" },
  { id_S_CPAC_CompleteConfig_Indicator, "id-S-CPAC-CompleteConfig-Indicator" },
  { id_SourceSN_to_TargetSN_QMCInfo, "id-SourceSN-to-TargetSN-QMCInfo" },
  { id_RegistrationRequestForDataCollection, "id-RegistrationRequestForDataCollection" },
  { id_ReportCharacteristicsForDataCollection, "id-ReportCharacteristicsForDataCollection" },
  { id_ReportingPeriodicityForDataCollection, "id-ReportingPeriodicityForDataCollection" },
  { id_NodeAssociatedInfoResult, "id-NodeAssociatedInfoResult" },
  { id_SLPositioning_Ranging_Services_Info, "id-SLPositioning-Ranging-Services-Info" },
  { id_XR_Bcast_Information, "id-XR-Bcast-Information" },
  { id_PDUSessionsListToBeReleased_UPError, "id-PDUSessionsListToBeReleased-UPError" },
  { id_MaximumDataBurstVolume, "id-MaximumDataBurstVolume" },
  { id_CPAC_Preparation_Type, "id-CPAC-Preparation-Type" },
  { id_UserPlaneFailureIndication, "id-UserPlaneFailureIndication" },
  { id_MN_only_MDT_collection, "id-MN-only-MDT-collection" },
  { 0, NULL }
};

static value_string_ext xnap_ProtocolIE_ID_vals_ext = VALUE_STRING_EXT_INIT(xnap_ProtocolIE_ID_vals);


static int
dissect_xnap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxProtocolIEs, &xnap_data->protocol_ie_id, false);


  if (tree) {
    proto_item_append_text(proto_item_get_parent_nth(actx->created_item, 2), ": %s", val_to_str_ext(xnap_data->protocol_ie_id, &xnap_ProtocolIE_ID_vals_ext, "unknown (%d)"));
  }
  return offset;
}


static const value_string xnap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  { 0, NULL }
};


static int
dissect_xnap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_xnap_ProtocolIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_xnap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_ID },
  { &hf_xnap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_protocolIE_Field_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_xnap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_Field },
};

static int
dissect_xnap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs, false);

  return offset;
}



static int
dissect_xnap_ProtocolIE_Single_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_xnap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_xnap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_xnap_extension_id   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_ID },
  { &hf_xnap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_extensionValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_xnap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolExtensionField },
};

static int
dissect_xnap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions, false);

  return offset;
}



static int
dissect_xnap_PrivateIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_xnap_private_id     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PrivateIE_ID },
  { &hf_xnap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_privateIE_Field_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PrivateIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_xnap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PrivateIE_Field },
};

static int
dissect_xnap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs, false);

  return offset;
}



static int
dissect_xnap_FiveQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}



static int
dissect_xnap_BitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(4000000000000), NULL, true);

  return offset;
}


static const per_sequence_t A2XPC5FlowBitRates_sequence[] = {
  { &hf_xnap_a2XguaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_a2XmaximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_A2XPC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_A2XPC5FlowBitRates, A2XPC5FlowBitRates_sequence);

  return offset;
}


static const value_string xnap_Range_vals[] = {
  {   0, "m50" },
  {   1, "m80" },
  {   2, "m180" },
  {   3, "m200" },
  {   4, "m350" },
  {   5, "m400" },
  {   6, "m500" },
  {   7, "m700" },
  {   8, "m1000" },
  { 0, NULL }
};


static int
dissect_xnap_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t A2XPC5QoSFlowItem_sequence[] = {
  { &hf_xnap_a2XpQI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_a2Xpc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_A2XPC5FlowBitRates },
  { &hf_xnap_a2Xrange       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Range },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_A2XPC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_A2XPC5QoSFlowItem, A2XPC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t A2XPC5QoSFlowList_sequence_of[1] = {
  { &hf_xnap_A2XPC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_A2XPC5QoSFlowItem },
};

static int
dissect_xnap_A2XPC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_A2XPC5QoSFlowList, A2XPC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, false);

  return offset;
}


static const per_sequence_t A2XPC5QoSParameters_sequence[] = {
  { &hf_xnap_a2XPC5QoSFlowList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_A2XPC5QoSFlowList },
  { &hf_xnap_aA2XPC5LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_A2XPC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_A2XPC5QoSParameters, A2XPC5QoSParameters_sequence);

  return offset;
}



static int
dissect_xnap_QoSFlowIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, true);

  return offset;
}


static const per_sequence_t QoSFLowsAcceptedToBeForwarded_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFLowsAcceptedToBeForwarded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFLowsAcceptedToBeForwarded_Item, QoSFLowsAcceptedToBeForwarded_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFLowsAcceptedToBeForwarded_List_sequence_of[1] = {
  { &hf_xnap_QoSFLowsAcceptedToBeForwarded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsAcceptedToBeForwarded_Item },
};

static int
dissect_xnap_QoSFLowsAcceptedToBeForwarded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFLowsAcceptedToBeForwarded_List, QoSFLowsAcceptedToBeForwarded_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}



static int
dissect_xnap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  int len;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, true, NULL, 0, &parameter_tvb, &len);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_xnap_TransportLayerAddress);
  if (len == 32) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
  } else if (len == 128) {
    /* IPv6 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv6, parameter_tvb, 0, 16, ENC_NA);
  } else if (len == 160) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
    /* IPv6 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv6, parameter_tvb, 4, 16, ENC_NA);
  }


  return offset;
}



static int
dissect_xnap_GTP_TEID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, NULL);

  return offset;
}


static const per_sequence_t GTPtunnelTransportLayerInformation_sequence[] = {
  { &hf_xnap_tnl_address    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TransportLayerAddress },
  { &hf_xnap_gtp_teid       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GTP_TEID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GTPtunnelTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GTPtunnelTransportLayerInformation, GTPtunnelTransportLayerInformation_sequence);

  return offset;
}


static const value_string xnap_UPTransportLayerInformation_vals[] = {
  {   0, "gtpTunnel" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UPTransportLayerInformation_choice[] = {
  {   0, &hf_xnap_gtpTunnel      , ASN1_NO_EXTENSIONS     , dissect_xnap_GTPtunnelTransportLayerInformation },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UPTransportLayerInformation, UPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_DRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, true);

  return offset;
}


static const per_sequence_t DataForwardingResponseDRBItem_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dlForwardingUPTNL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_ulForwardingUPTNL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingResponseDRBItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingResponseDRBItem, DataForwardingResponseDRBItem_sequence);

  return offset;
}


static const per_sequence_t DataForwardingResponseDRBItemList_sequence_of[1] = {
  { &hf_xnap_DataForwardingResponseDRBItemList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingResponseDRBItem },
};

static int
dissect_xnap_DataForwardingResponseDRBItemList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DataForwardingResponseDRBItemList, DataForwardingResponseDRBItemList_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetNGRANnode_sequence[] = {
  { &hf_xnap_qosFlowsAcceptedForDataForwarding_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsAcceptedToBeForwarded_List },
  { &hf_xnap_pduSessionLevelDLDataForwardingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_pduSessionLevelULDataForwardingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dataForwardingResponseDRBItemList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingResponseDRBItemList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingInfoFromTargetNGRANnode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingInfoFromTargetNGRANnode, DataForwardingInfoFromTargetNGRANnode_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeConfirmInfo_SNterminated_sequence[] = {
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated, PDUSessionResourceChangeConfirmInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item_sequence[] = {
  { &hf_xnap_pDUSessionResourceChangeConfirmInfo_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item, AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_sequence_of[1] = {
  { &hf_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item },
};

static int
dissect_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated, AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_sequence_of,
                                                  1, maxnoofTargetSNsMinusOne, false);

  return offset;
}



static int
dissect_xnap_AveragePacketDelayValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10000U, NULL, false);

  return offset;
}


static const per_sequence_t AveragePacketDelay_sequence[] = {
  { &hf_xnap_uL_AveragePacketDelay, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AveragePacketDelayValue },
  { &hf_xnap_dL_AveragePacketDelay, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AveragePacketDelayValue },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AveragePacketDelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AveragePacketDelay, AveragePacketDelay_sequence);

  return offset;
}


static const value_string xnap_AdditionLocationInformation_vals[] = {
  {   0, "includePSCell" },
  { 0, NULL }
};


static int
dissect_xnap_AdditionLocationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Additional_PDCP_Duplication_TNL_Item_sequence[] = {
  { &hf_xnap_additional_PDCP_Duplication_UP_TNL_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Additional_PDCP_Duplication_TNL_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Additional_PDCP_Duplication_TNL_Item, Additional_PDCP_Duplication_TNL_Item_sequence);

  return offset;
}


static const per_sequence_t Additional_PDCP_Duplication_TNL_List_sequence_of[1] = {
  { &hf_xnap_Additional_PDCP_Duplication_TNL_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Additional_PDCP_Duplication_TNL_Item },
};

static int
dissect_xnap_Additional_PDCP_Duplication_TNL_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Additional_PDCP_Duplication_TNL_List, Additional_PDCP_Duplication_TNL_List_sequence_of,
                                                  1, maxnoofAdditionalPDCPDuplicationTNL, false);

  return offset;
}


static const per_sequence_t Additional_UL_NG_U_TNLatUPF_Item_sequence[] = {
  { &hf_xnap_additional_UL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Additional_UL_NG_U_TNLatUPF_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Additional_UL_NG_U_TNLatUPF_Item, Additional_UL_NG_U_TNLatUPF_Item_sequence);

  return offset;
}


static const per_sequence_t Additional_UL_NG_U_TNLatUPF_List_sequence_of[1] = {
  { &hf_xnap_Additional_UL_NG_U_TNLatUPF_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Additional_UL_NG_U_TNLatUPF_Item },
};

static int
dissect_xnap_Additional_UL_NG_U_TNLatUPF_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Additional_UL_NG_U_TNLatUPF_List, Additional_UL_NG_U_TNLatUPF_List_sequence_of,
                                                  1, maxnoofMultiConnectivityMinusOne, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16U, NULL, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_95(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 95U, NULL, false);

  return offset;
}


static const value_string xnap_T_csi_RS_Status_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_xnap_T_csi_RS_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  e212_number_type_t number_type = xnap_data->number_type;
  xnap_data->number_type = E212_NONE;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, &parameter_tvb);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_xnap_PLMN_Identity);
  dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, number_type, false);


  return offset;
}



static int
dissect_xnap_NR_Cell_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cell_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     36, 36, false, NULL, 0, &cell_id_tvb, NULL);

  if (cell_id_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, cell_id_tvb, 0, 5, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t NR_CGI_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_nr_CI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_Cell_Identity },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_NRCGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_CGI, NR_CGI_sequence);



  return offset;
}


static const per_sequence_t CSI_RS_MTC_Neighbour_Item_sequence[] = {
  { &hf_xnap_csi_RS_Index   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_95 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CSI_RS_MTC_Neighbour_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CSI_RS_MTC_Neighbour_Item, CSI_RS_MTC_Neighbour_Item_sequence);

  return offset;
}


static const per_sequence_t CSI_RS_MTC_Neighbour_List_sequence_of[1] = {
  { &hf_xnap_CSI_RS_MTC_Neighbour_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_MTC_Neighbour_Item },
};

static int
dissect_xnap_CSI_RS_MTC_Neighbour_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CSI_RS_MTC_Neighbour_List, CSI_RS_MTC_Neighbour_List_sequence_of,
                                                  1, maxnoofCSIRSneighbourCellsInMTC, false);

  return offset;
}


static const per_sequence_t CSI_RS_Neighbour_Item_sequence[] = {
  { &hf_xnap_nr_cgi         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_csi_RS_MTC_Neighbour_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CSI_RS_MTC_Neighbour_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CSI_RS_Neighbour_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CSI_RS_Neighbour_Item, CSI_RS_Neighbour_Item_sequence);

  return offset;
}


static const per_sequence_t CSI_RS_Neighbour_List_sequence_of[1] = {
  { &hf_xnap_CSI_RS_Neighbour_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_Neighbour_Item },
};

static int
dissect_xnap_CSI_RS_Neighbour_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CSI_RS_Neighbour_List, CSI_RS_Neighbour_List_sequence_of,
                                                  1, maxnoofCSIRSneighbourCells, false);

  return offset;
}


static const per_sequence_t CSI_RS_MTC_Configuration_Item_sequence[] = {
  { &hf_xnap_csi_RS_Index   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_95 },
  { &hf_xnap_csi_RS_Status  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_csi_RS_Status },
  { &hf_xnap_csi_RS_Neighbour_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CSI_RS_Neighbour_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CSI_RS_MTC_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CSI_RS_MTC_Configuration_Item, CSI_RS_MTC_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t CSI_RS_MTC_Configuration_List_sequence_of[1] = {
  { &hf_xnap_CSI_RS_MTC_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_MTC_Configuration_Item },
};

static int
dissect_xnap_CSI_RS_MTC_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CSI_RS_MTC_Configuration_List, CSI_RS_MTC_Configuration_List_sequence_of,
                                                  1, maxnoofCSIRSconfigurations, false);

  return offset;
}


static const per_sequence_t Additional_Measurement_Timing_Configuration_Item_sequence[] = {
  { &hf_xnap_additionalMeasurementTimingConfigurationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_16 },
  { &hf_xnap_csi_RS_MTC_Configuration_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_MTC_Configuration_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Additional_Measurement_Timing_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Additional_Measurement_Timing_Configuration_Item, Additional_Measurement_Timing_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t Additional_Measurement_Timing_Configuration_List_sequence_of[1] = {
  { &hf_xnap_Additional_Measurement_Timing_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Additional_Measurement_Timing_Configuration_Item },
};

static int
dissect_xnap_Additional_Measurement_Timing_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Additional_Measurement_Timing_Configuration_List, Additional_Measurement_Timing_Configuration_List_sequence_of,
                                                  1, maxnoofMTCItems, false);

  return offset;
}



static int
dissect_xnap_ActivationIDforCellActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static int
dissect_xnap_PriorityLevelQoS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, true);

  return offset;
}



static int
dissect_xnap_AveragingWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}



static int
dissect_xnap_MaximumDataBurstVolume(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}


static const per_sequence_t NonDynamic5QIDescriptor_sequence[] = {
  { &hf_xnap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_priorityLevelQoS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PriorityLevelQoS },
  { &hf_xnap_averagingWindow, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AveragingWindow },
  { &hf_xnap_maximumDataBurstVolume, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumDataBurstVolume },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NonDynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NonDynamic5QIDescriptor, NonDynamic5QIDescriptor_sequence);

  return offset;
}



static int
dissect_xnap_PacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, true);

  return offset;
}



static int
dissect_xnap_PER_Scalar(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, true);

  return offset;
}



static int
dissect_xnap_PER_Exponent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, true);

  return offset;
}


static const per_sequence_t PacketErrorRate_sequence[] = {
  { &hf_xnap_pER_Scalar     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PER_Scalar },
  { &hf_xnap_pER_Exponent   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PER_Exponent },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PacketErrorRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PacketErrorRate, PacketErrorRate_sequence);

  return offset;
}


static const value_string xnap_T_delayCritical_vals[] = {
  {   0, "delay-critical" },
  {   1, "non-delay-critical" },
  { 0, NULL }
};


static int
dissect_xnap_T_delayCritical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Dynamic5QIDescriptor_sequence[] = {
  { &hf_xnap_priorityLevelQoS, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PriorityLevelQoS },
  { &hf_xnap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PacketDelayBudget },
  { &hf_xnap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PacketErrorRate },
  { &hf_xnap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveQI },
  { &hf_xnap_delayCritical  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_delayCritical },
  { &hf_xnap_averagingWindow, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AveragingWindow },
  { &hf_xnap_maximumDataBurstVolume, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumDataBurstVolume },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Dynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Dynamic5QIDescriptor, Dynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string xnap_QoSCharacteristics_vals[] = {
  {   0, "non-dynamic" },
  {   1, "dynamic" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t QoSCharacteristics_choice[] = {
  {   0, &hf_xnap_non_dynamic    , ASN1_NO_EXTENSIONS     , dissect_xnap_NonDynamic5QIDescriptor },
  {   1, &hf_xnap_dynamic        , ASN1_NO_EXTENSIONS     , dissect_xnap_Dynamic5QIDescriptor },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_QoSCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_QoSCharacteristics, QoSCharacteristics_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_15_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}


static const value_string xnap_T_pre_emption_capability_vals[] = {
  {   0, "shall-not-trigger-preemption" },
  {   1, "may-trigger-preemption" },
  { 0, NULL }
};


static int
dissect_xnap_T_pre_emption_capability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_pre_emption_vulnerability_vals[] = {
  {   0, "not-preemptable" },
  {   1, "preemptable" },
  { 0, NULL }
};


static int
dissect_xnap_T_pre_emption_vulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationandRetentionPriority_sequence[] = {
  { &hf_xnap_priorityLevel  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_15_ },
  { &hf_xnap_pre_emption_capability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_pre_emption_capability },
  { &hf_xnap_pre_emption_vulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_pre_emption_vulnerability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AllocationandRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AllocationandRetentionPriority, AllocationandRetentionPriority_sequence);

  return offset;
}


static const value_string xnap_T_notificationControl_vals[] = {
  {   0, "notification-requested" },
  { 0, NULL }
};


static int
dissect_xnap_T_notificationControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_PacketLossRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000U, NULL, true);

  return offset;
}


static const per_sequence_t GBRQoSFlowInfo_sequence[] = {
  { &hf_xnap_maxFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_maxFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_notificationControl, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_notificationControl },
  { &hf_xnap_maxPacketLossRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketLossRate },
  { &hf_xnap_maxPacketLossRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketLossRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GBRQoSFlowInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GBRQoSFlowInfo, GBRQoSFlowInfo_sequence);

  return offset;
}


static const value_string xnap_ReflectiveQoSAttribute_vals[] = {
  {   0, "subject-to-reflective-QoS" },
  { 0, NULL }
};


static int
dissect_xnap_ReflectiveQoSAttribute(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_additionalQoSflowInfo_vals[] = {
  {   0, "more-likely" },
  { 0, NULL }
};


static int
dissect_xnap_T_additionalQoSflowInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlowLevelQoSParameters_sequence[] = {
  { &hf_xnap_qos_characteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSCharacteristics },
  { &hf_xnap_allocationAndRetentionPrio, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllocationandRetentionPriority },
  { &hf_xnap_gBRQoSFlowInfo , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_reflectiveQoS  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ReflectiveQoSAttribute },
  { &hf_xnap_additionalQoSflowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_additionalQoSflowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowLevelQoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowLevelQoSParameters, QoSFlowLevelQoSParameters_sequence);

  return offset;
}


static const per_sequence_t MBS_QoSFlowsToAdd_Item_sequence[] = {
  { &hf_xnap_mBS_QosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mBS_QosFlowLevelQosParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_QoSFlowsToAdd_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_QoSFlowsToAdd_Item, MBS_QoSFlowsToAdd_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_QoSFlowsToAdd_List_sequence_of[1] = {
  { &hf_xnap_MBS_QoSFlowsToAdd_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_QoSFlowsToAdd_Item },
};

static int
dissect_xnap_MBS_QoSFlowsToAdd_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_QoSFlowsToAdd_List, MBS_QoSFlowsToAdd_List_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaCell_List_sequence_of[1] = {
  { &hf_xnap_MBS_ServiceAreaCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
};

static int
dissect_xnap_MBS_ServiceAreaCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_ServiceAreaCell_List, MBS_ServiceAreaCell_List_sequence_of,
                                                  1, maxnoofCellsforMBS, false);

  return offset;
}



static int
dissect_xnap_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       3, 3, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 3, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t MBS_ServiceAreaTAI_Item_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceAreaTAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_ServiceAreaTAI_Item, MBS_ServiceAreaTAI_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaTAI_List_sequence_of[1] = {
  { &hf_xnap_MBS_ServiceAreaTAI_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_ServiceAreaTAI_Item },
};

static int
dissect_xnap_MBS_ServiceAreaTAI_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_ServiceAreaTAI_List, MBS_ServiceAreaTAI_List_sequence_of,
                                                  1, maxnoofTAIforMBS, false);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformation_sequence[] = {
  { &hf_xnap_mBS_ServiceAreaCell_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_ServiceAreaCell_List },
  { &hf_xnap_mBS_ServiceAreaTAI_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_ServiceAreaTAI_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceAreaInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_ServiceAreaInformation, MBS_ServiceAreaInformation_sequence);

  return offset;
}



static int
dissect_xnap_MBS_Area_Session_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, true);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformation_Item_sequence[] = {
  { &hf_xnap_mBS_Area_Session_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Area_Session_ID },
  { &hf_xnap_mBS_ServiceAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_ServiceAreaInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceAreaInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_ServiceAreaInformation_Item, MBS_ServiceAreaInformation_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformationList_sequence_of[1] = {
  { &hf_xnap_MBS_ServiceAreaInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_ServiceAreaInformation_Item },
};

static int
dissect_xnap_MBS_ServiceAreaInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_ServiceAreaInformationList, MBS_ServiceAreaInformationList_sequence_of,
                                                  1, maxnoofMBSServiceAreaInformation, false);

  return offset;
}


static const value_string xnap_MBS_ServiceArea_vals[] = {
  {   0, "locationindependent" },
  {   1, "locationdependent" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MBS_ServiceArea_choice[] = {
  {   0, &hf_xnap_locationindependent, ASN1_NO_EXTENSIONS     , dissect_xnap_MBS_ServiceAreaInformation },
  {   1, &hf_xnap_locationdependent, ASN1_NO_EXTENSIONS     , dissect_xnap_MBS_ServiceAreaInformationList },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MBS_ServiceArea, MBS_ServiceArea_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 512U, NULL, true);

  return offset;
}


static const per_sequence_t MBS_QoSFlow_List_sequence_of[1] = {
  { &hf_xnap_MBS_QoSFlow_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
};

static int
dissect_xnap_MBS_QoSFlow_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_QoSFlow_List, MBS_QoSFlow_List_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_262143(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 262143U, NULL, false);

  return offset;
}


static const value_string xnap_MRB_ProgressInformation_vals[] = {
  {   0, "pdcp-SN12" },
  {   1, "pdcp-SN18" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MRB_ProgressInformation_choice[] = {
  {   0, &hf_xnap_pdcp_SN12      , ASN1_NO_EXTENSIONS     , dissect_xnap_INTEGER_0_4095 },
  {   1, &hf_xnap_pdcp_SN18      , ASN1_NO_EXTENSIONS     , dissect_xnap_INTEGER_0_262143 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MRB_ProgressInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MRB_ProgressInformation, MRB_ProgressInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBS_MappingandDataForwardingRequestInfofromSource_Item_sequence[] = {
  { &hf_xnap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MRB_ID },
  { &hf_xnap_mBS_QoSFlow_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_QoSFlow_List },
  { &hf_xnap_mRB_ProgressInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MRB_ProgressInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item, MBS_MappingandDataForwardingRequestInfofromSource_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_MappingandDataForwardingRequestInfofromSource_sequence_of[1] = {
  { &hf_xnap_MBS_MappingandDataForwardingRequestInfofromSource_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item },
};

static int
dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource, MBS_MappingandDataForwardingRequestInfofromSource_sequence_of,
                                                  1, maxnoofMRBs, false);

  return offset;
}


static const per_sequence_t Active_MBS_SessionInformation_sequence[] = {
  { &hf_xnap_mBS_QoSFlowsToAdd_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_QoSFlowsToAdd_List },
  { &hf_xnap_mBS_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_ServiceArea },
  { &hf_xnap_mBS_MappingandDataForwardingRequestInfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Active_MBS_SessionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Active_MBS_SessionInformation, Active_MBS_SessionInformation_sequence);

  return offset;
}



static int
dissect_xnap_Measurement_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4095U, NULL, true);

  return offset;
}


static const per_sequence_t DataCollectionID_sequence[] = {
  { &hf_xnap_nGRAN_Node1_Measurement_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Measurement_ID },
  { &hf_xnap_nGRAN_Node2_Measurement_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Measurement_ID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataCollectionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataCollectionID, DataCollectionID_sequence);

  return offset;
}


static const value_string xnap_AerialControllerUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_AerialControllerUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_AerialUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_AerialUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_AerialUESubscriptionInformation_vals[] = {
  {   0, "allowed" },
  {   1, "not-allowed" },
  { 0, NULL }
};


static int
dissect_xnap_AerialUESubscriptionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_ActivationSFN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, false);

  return offset;
}



static int
dissect_xnap_CAG_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t AllowedCAG_ID_List_perPLMN_sequence_of[1] = {
  { &hf_xnap_AllowedCAG_ID_List_perPLMN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CAG_Identifier },
};

static int
dissect_xnap_AllowedCAG_ID_List_perPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AllowedCAG_ID_List_perPLMN, AllowedCAG_ID_List_perPLMN_sequence_of,
                                                  1, maxnoofCAGsperPLMN, false);

  return offset;
}


static const value_string xnap_PNI_NPN_Restricted_Information_vals[] = {
  {   0, "restriced" },
  {   1, "not-restricted" },
  { 0, NULL }
};


static int
dissect_xnap_PNI_NPN_Restricted_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AllowedPNI_NPN_ID_Item_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_pni_npn_restricted_information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PNI_NPN_Restricted_Information },
  { &hf_xnap_allowed_CAG_id_list_per_plmn, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedCAG_ID_List_perPLMN },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AllowedPNI_NPN_ID_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AllowedPNI_NPN_ID_Item, AllowedPNI_NPN_ID_Item_sequence);

  return offset;
}


static const per_sequence_t AllowedPNI_NPN_ID_List_sequence_of[1] = {
  { &hf_xnap_AllowedPNI_NPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedPNI_NPN_ID_Item },
};

static int
dissect_xnap_AllowedPNI_NPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AllowedPNI_NPN_ID_List, AllowedPNI_NPN_ID_List_sequence_of,
                                                  1, maxnoofEPLMNsplus1, false);

  return offset;
}


static const value_string xnap_AllTrafficIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_AllTrafficIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_QoSParaSetIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetItem_sequence[] = {
  { &hf_xnap_alternativeQoSParaSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSParaSetIndex },
  { &hf_xnap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketDelayBudget },
  { &hf_xnap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketErrorRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AlternativeQoSParaSetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AlternativeQoSParaSetItem, AlternativeQoSParaSetItem_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetList_sequence_of[1] = {
  { &hf_xnap_AlternativeQoSParaSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AlternativeQoSParaSetItem },
};

static int
dissect_xnap_AlternativeQoSParaSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AlternativeQoSParaSetList, AlternativeQoSParaSetList_sequence_of,
                                                  1, maxnoofQoSParaSets, false);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GlobalAMF_Region_Information_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_amf_region_id  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_8 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalAMF_Region_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalAMF_Region_Information, GlobalAMF_Region_Information_sequence);

  return offset;
}


static const per_sequence_t AMF_Region_Information_sequence_of[1] = {
  { &hf_xnap_AMF_Region_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalAMF_Region_Information },
};

static int
dissect_xnap_AMF_Region_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AMF_Region_Information, AMF_Region_Information_sequence_of,
                                                  1, maxnoofAMFRegions, false);

  return offset;
}



static int
dissect_xnap_AMF_UE_NGAP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(1099511627775), NULL, false);

  return offset;
}


static const per_sequence_t TAIsinAoI_Item_sequence[] = {
  { &hf_xnap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIsinAoI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_5GSTAI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIsinAoI_Item, TAIsinAoI_Item_sequence);



  return offset;
}


static const per_sequence_t ListOfTAIsinAoI_sequence_of[1] = {
  { &hf_xnap_ListOfTAIsinAoI_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAIsinAoI_Item },
};

static int
dissect_xnap_ListOfTAIsinAoI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ListOfTAIsinAoI, ListOfTAIsinAoI_sequence_of,
                                                  1, maxnoofTAIsinAoI, false);

  return offset;
}



static int
dissect_xnap_E_UTRA_Cell_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cell_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     28, 28, false, NULL, 0, &cell_id_tvb, NULL);

  if (cell_id_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, cell_id_tvb, 0, 4, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string xnap_NG_RAN_Cell_Identity_vals[] = {
  {   0, "nr" },
  {   1, "e-utra" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NG_RAN_Cell_Identity_choice[] = {
  {   0, &hf_xnap_nr             , ASN1_NO_EXTENSIONS     , dissect_xnap_NR_Cell_Identity },
  {   1, &hf_xnap_e_utra         , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_Cell_Identity },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NG_RAN_Cell_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NG_RAN_Cell_Identity, NG_RAN_Cell_Identity_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellsinAoI_Item_sequence[] = {
  { &hf_xnap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_ng_ran_cell_id , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Cell_Identity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellsinAoI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellsinAoI_Item, CellsinAoI_Item_sequence);

  return offset;
}


static const per_sequence_t ListOfCells_sequence_of[1] = {
  { &hf_xnap_ListOfCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellsinAoI_Item },
};

static int
dissect_xnap_ListOfCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ListOfCells, ListOfCells_sequence_of,
                                                  1, maxnoofCellsinAoI, false);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_22_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_GNB_ID_Choice_vals[] = {
  {   0, "gnb-ID" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t GNB_ID_Choice_choice[] = {
  {   0, &hf_xnap_gnb_ID         , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_22_32 },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_GNB_ID_Choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_GNB_ID_Choice, GNB_ID_Choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalgNB_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_gnb_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_ID_Choice },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalgNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalgNB_ID, GlobalgNB_ID_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     18, 18, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     21, 21, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_ENB_ID_Choice_vals[] = {
  {   0, "enb-ID-macro" },
  {   1, "enb-ID-shortmacro" },
  {   2, "enb-ID-longmacro" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ENB_ID_Choice_choice[] = {
  {   0, &hf_xnap_enb_ID_macro   , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_20 },
  {   1, &hf_xnap_enb_ID_shortmacro, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_18 },
  {   2, &hf_xnap_enb_ID_longmacro, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_21 },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ENB_ID_Choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ENB_ID_Choice, ENB_ID_Choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalngeNB_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_enb_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ENB_ID_Choice },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalngeNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalngeNB_ID, GlobalngeNB_ID_sequence);

  return offset;
}


static const value_string xnap_GlobalNG_RANNode_ID_vals[] = {
  { GlobalNG_RANNode_ID_gNB, "gNB" },
  { GlobalNG_RANNode_ID_ng_eNB, "ng-eNB" },
  { GlobalNG_RANNode_ID_choice_extension, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t GlobalNG_RANNode_ID_choice[] = {
  { GlobalNG_RANNode_ID_gNB, &hf_xnap_gNB            , ASN1_NO_EXTENSIONS     , dissect_xnap_GlobalgNB_ID },
  { GlobalNG_RANNode_ID_ng_eNB, &hf_xnap_ng_eNB         , ASN1_NO_EXTENSIONS     , dissect_xnap_GlobalngeNB_ID },
  { GlobalNG_RANNode_ID_choice_extension, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_GlobalNG_RANNode_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  int value;
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);

  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_GlobalNG_RANNode_ID, GlobalNG_RANNode_ID_choice,
                                 &value);

  if (xnap_data->xnap_conv && xnap_data->procedure_code == id_xnSetup) {
    if (addresses_equal(&actx->pinfo->src, &xnap_data->xnap_conv->addr_a) &&
        actx->pinfo->srcport == xnap_data->xnap_conv->port_a) {
      xnap_data->xnap_conv->ranmode_id_a = (GlobalNG_RANNode_ID_enum)value;
    } else if (addresses_equal(&actx->pinfo->src, &xnap_data->xnap_conv->addr_b) &&
               actx->pinfo->srcport == xnap_data->xnap_conv->port_b) {
      xnap_data->xnap_conv->ranmode_id_b = (GlobalNG_RANNode_ID_enum)value;
    }
  }


  return offset;
}


static const per_sequence_t GlobalNG_RANNodesinAoI_Item_sequence[] = {
  { &hf_xnap_global_NG_RAN_Node_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalNG_RANNodesinAoI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalNG_RANNodesinAoI_Item, GlobalNG_RANNodesinAoI_Item_sequence);

  return offset;
}


static const per_sequence_t ListOfRANNodesinAoI_sequence_of[1] = {
  { &hf_xnap_ListOfRANNodesinAoI_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNodesinAoI_Item },
};

static int
dissect_xnap_ListOfRANNodesinAoI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ListOfRANNodesinAoI, ListOfRANNodesinAoI_sequence_of,
                                                  1, maxnoofRANNodesinAoI, false);

  return offset;
}



static int
dissect_xnap_RequestReferenceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, true);

  return offset;
}


static const per_sequence_t AreaOfInterest_Item_sequence[] = {
  { &hf_xnap_listOfTAIsinAoI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ListOfTAIsinAoI },
  { &hf_xnap_listOfCellsinAoI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ListOfCells },
  { &hf_xnap_listOfRANNodesinAoI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ListOfRANNodesinAoI },
  { &hf_xnap_requestReferenceID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RequestReferenceID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AreaOfInterest_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AreaOfInterest_Item, AreaOfInterest_Item_sequence);

  return offset;
}


static const per_sequence_t AreaOfInterestInformation_sequence_of[1] = {
  { &hf_xnap_AreaOfInterestInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AreaOfInterest_Item },
};

static int
dissect_xnap_AreaOfInterestInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AreaOfInterestInformation, AreaOfInterestInformation_sequence_of,
                                                  1, maxnoofAoIs, false);

  return offset;
}


static const per_sequence_t CellIdListforMDT_NR_sequence_of[1] = {
  { &hf_xnap_CellIdListforMDT_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
};

static int
dissect_xnap_CellIdListforMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellIdListforMDT_NR, CellIdListforMDT_NR_sequence_of,
                                                  1, maxnoofCellIDforMDT, false);

  return offset;
}


static const per_sequence_t CellBasedMDT_NR_sequence[] = {
  { &hf_xnap_cellIdListforMDT_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellIdListforMDT_NR },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellBasedMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellBasedMDT_NR, CellBasedMDT_NR_sequence);

  return offset;
}


static const per_sequence_t TAListforMDT_sequence_of[1] = {
  { &hf_xnap_TAListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_TAListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAListforMDT, TAListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, false);

  return offset;
}


static const per_sequence_t TABasedMDT_sequence[] = {
  { &hf_xnap_tAListforMDT   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAListforMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TABasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TABasedMDT, TABasedMDT_sequence);

  return offset;
}


static const per_sequence_t TAIforMDT_Item_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIforMDT_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_5GSTAI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIforMDT_Item, TAIforMDT_Item_sequence);



  return offset;
}


static const per_sequence_t TAIListforMDT_sequence_of[1] = {
  { &hf_xnap_TAIListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAIforMDT_Item },
};

static int
dissect_xnap_TAIListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAIListforMDT, TAIListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, false);

  return offset;
}


static const per_sequence_t TAIBasedMDT_sequence[] = {
  { &hf_xnap_tAIListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAIListforMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIBasedMDT, TAIBasedMDT_sequence);

  return offset;
}


static const value_string xnap_AreaScopeOfMDT_NR_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfMDT_NR_choice[] = {
  {   0, &hf_xnap_cellBased      , ASN1_EXTENSION_ROOT    , dissect_xnap_CellBasedMDT_NR },
  {   1, &hf_xnap_tABased        , ASN1_EXTENSION_ROOT    , dissect_xnap_TABasedMDT },
  {   2, &hf_xnap_tAIBased       , ASN1_EXTENSION_ROOT    , dissect_xnap_TAIBasedMDT },
  {   3, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_AreaScopeOfMDT_NR, AreaScopeOfMDT_NR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_UTRA_CGI_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_e_utra_CI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_Cell_Identity },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_E_UTRA_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_ECGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_E_UTRA_CGI, E_UTRA_CGI_sequence);



  return offset;
}


static const per_sequence_t CellIdListforMDT_EUTRA_sequence_of[1] = {
  { &hf_xnap_CellIdListforMDT_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
};

static int
dissect_xnap_CellIdListforMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellIdListforMDT_EUTRA, CellIdListforMDT_EUTRA_sequence_of,
                                                  1, maxnoofCellIDforMDT, false);

  return offset;
}


static const per_sequence_t CellBasedMDT_EUTRA_sequence[] = {
  { &hf_xnap_cellIdListforMDT_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellIdListforMDT_EUTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellBasedMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellBasedMDT_EUTRA, CellBasedMDT_EUTRA_sequence);

  return offset;
}


static const value_string xnap_AreaScopeOfMDT_EUTRA_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfMDT_EUTRA_choice[] = {
  {   0, &hf_xnap_cellBased_01   , ASN1_EXTENSION_ROOT    , dissect_xnap_CellBasedMDT_EUTRA },
  {   1, &hf_xnap_tABased        , ASN1_EXTENSION_ROOT    , dissect_xnap_TABasedMDT },
  {   2, &hf_xnap_tAIBased       , ASN1_EXTENSION_ROOT    , dissect_xnap_TAIBasedMDT },
  {   3, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_AreaScopeOfMDT_EUTRA, AreaScopeOfMDT_EUTRA_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_NRARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, false);

  return offset;
}


static const value_string xnap_NRSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  {   4, "scs480" },
  {   5, "scs960" },
  { 0, NULL }
};


static int
dissect_xnap_NRSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 2, NULL);

  return offset;
}


static const value_string xnap_NRNRB_vals[] = {
  {   0, "nrb11" },
  {   1, "nrb18" },
  {   2, "nrb24" },
  {   3, "nrb25" },
  {   4, "nrb31" },
  {   5, "nrb32" },
  {   6, "nrb38" },
  {   7, "nrb51" },
  {   8, "nrb52" },
  {   9, "nrb65" },
  {  10, "nrb66" },
  {  11, "nrb78" },
  {  12, "nrb79" },
  {  13, "nrb93" },
  {  14, "nrb106" },
  {  15, "nrb107" },
  {  16, "nrb121" },
  {  17, "nrb132" },
  {  18, "nrb133" },
  {  19, "nrb135" },
  {  20, "nrb160" },
  {  21, "nrb162" },
  {  22, "nrb189" },
  {  23, "nrb216" },
  {  24, "nrb217" },
  {  25, "nrb245" },
  {  26, "nrb264" },
  {  27, "nrb270" },
  {  28, "nrb273" },
  {  29, "nrb33" },
  {  30, "nrb62" },
  {  31, "nrb124" },
  {  32, "nrb148" },
  {  33, "nrb248" },
  {  34, "nrb44" },
  {  35, "nrb58" },
  {  36, "nrb92" },
  {  37, "nrb119" },
  {  38, "nrb188" },
  {  39, "nrb242" },
  {  40, "nrb15" },
  { 0, NULL }
};

static value_string_ext xnap_NRNRB_vals_ext = VALUE_STRING_EXT_INIT(xnap_NRNRB_vals);


static int
dissect_xnap_NRNRB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     29, NULL, true, 12, NULL);

  return offset;
}


static const per_sequence_t NRTransmissionBandwidth_sequence[] = {
  { &hf_xnap_nRSCS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRSCS },
  { &hf_xnap_nRNRB          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRNRB },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRTransmissionBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRTransmissionBandwidth, NRTransmissionBandwidth_sequence);

  return offset;
}


static const per_sequence_t SUL_Information_sequence[] = {
  { &hf_xnap_sulFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRARFCN },
  { &hf_xnap_sulTransmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SUL_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SUL_Information, SUL_Information_sequence);

  return offset;
}



static int
dissect_xnap_NRFrequencyBand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, true);

  return offset;
}



static int
dissect_xnap_SUL_FrequencyBand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, false);

  return offset;
}


static const per_sequence_t SupportedSULBandItem_sequence[] = {
  { &hf_xnap_sulBandItem    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SUL_FrequencyBand },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SupportedSULBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SupportedSULBandItem, SupportedSULBandItem_sequence);

  return offset;
}


static const per_sequence_t SupportedSULBandList_sequence_of[1] = {
  { &hf_xnap_SupportedSULBandList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SupportedSULBandItem },
};

static int
dissect_xnap_SupportedSULBandList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SupportedSULBandList, SupportedSULBandList_sequence_of,
                                                  1, maxnoofNRCellBands, false);

  return offset;
}


static const per_sequence_t NRFrequencyBandItem_sequence[] = {
  { &hf_xnap_nr_frequency_band, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyBand },
  { &hf_xnap_supported_SUL_Band_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SupportedSULBandList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRFrequencyBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRFrequencyBandItem, NRFrequencyBandItem_sequence);

  return offset;
}


static const per_sequence_t NRFrequencyBand_List_sequence_of[1] = {
  { &hf_xnap_NRFrequencyBand_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyBandItem },
};

static int
dissect_xnap_NRFrequencyBand_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NRFrequencyBand_List, NRFrequencyBand_List_sequence_of,
                                                  1, maxnoofNRCellBands, false);

  return offset;
}


static const per_sequence_t NRFrequencyInfo_sequence[] = {
  { &hf_xnap_nrARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRARFCN },
  { &hf_xnap_sul_information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SUL_Information },
  { &hf_xnap_frequencyBand_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyBand_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRFrequencyInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRFrequencyInfo, NRFrequencyInfo_sequence);

  return offset;
}



static int
dissect_xnap_NRPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, true);

  return offset;
}


static const per_sequence_t PCIListForMDT_sequence_of[1] = {
  { &hf_xnap_PCIListForMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NRPCI },
};

static int
dissect_xnap_PCIListForMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PCIListForMDT, PCIListForMDT_sequence_of,
                                                  1, maxnoofNeighPCIforMDT, false);

  return offset;
}


static const per_sequence_t AreaScopeOfNeighCellsItem_sequence[] = {
  { &hf_xnap_nrFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_pciListForMDT  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PCIListForMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfNeighCellsItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AreaScopeOfNeighCellsItem, AreaScopeOfNeighCellsItem_sequence);

  return offset;
}


static const per_sequence_t AreaScopeOfNeighCellsList_sequence_of[1] = {
  { &hf_xnap_AreaScopeOfNeighCellsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AreaScopeOfNeighCellsItem },
};

static int
dissect_xnap_AreaScopeOfNeighCellsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AreaScopeOfNeighCellsList, AreaScopeOfNeighCellsList_sequence_of,
                                                  1, maxnoofFreqforMDT, false);

  return offset;
}


static const per_sequence_t GlobalNG_RANCell_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_ng_RAN_Cell_id , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Cell_Identity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalNG_RANCell_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalNG_RANCell_ID, GlobalNG_RANCell_ID_sequence);

  return offset;
}


static const per_sequence_t CellIdListforQMC_sequence_of[1] = {
  { &hf_xnap_CellIdListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
};

static int
dissect_xnap_CellIdListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellIdListforQMC, CellIdListforQMC_sequence_of,
                                                  1, maxnoofCellIDforQMC, false);

  return offset;
}


static const per_sequence_t CellBasedQMC_sequence[] = {
  { &hf_xnap_cellIdListforQMC, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellIdListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellBasedQMC, CellBasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAListforQMC_sequence_of[1] = {
  { &hf_xnap_TAListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_TAListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAListforQMC, TAListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, false);

  return offset;
}


static const per_sequence_t TABasedQMC_sequence[] = {
  { &hf_xnap_tAListforQMC   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TABasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TABasedQMC, TABasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAI_Item_sequence[] = {
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAI_Item, TAI_Item_sequence);

  return offset;
}


static const per_sequence_t TAIListforQMC_sequence_of[1] = {
  { &hf_xnap_TAIListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAI_Item },
};

static int
dissect_xnap_TAIListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAIListforQMC, TAIListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, false);

  return offset;
}


static const per_sequence_t TAIBasedQMC_sequence[] = {
  { &hf_xnap_tAIListforQMC  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAIListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIBasedQMC, TAIBasedQMC_sequence);

  return offset;
}


static const per_sequence_t PLMNListforQMC_sequence_of[1] = {
  { &hf_xnap_PLMNListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_PLMNListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PLMNListforQMC, PLMNListforQMC_sequence_of,
                                                  1, maxnoofPLMNforQMC, false);

  return offset;
}


static const per_sequence_t PLMNAreaBasedQMC_sequence[] = {
  { &hf_xnap_plmnListforQMC , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMNListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PLMNAreaBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PLMNAreaBasedQMC, PLMNAreaBasedQMC_sequence);

  return offset;
}


static const value_string xnap_AreaScopeOfQMC_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "pLMNAreaBased" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfQMC_choice[] = {
  {   0, &hf_xnap_cellBased_02   , ASN1_NO_EXTENSIONS     , dissect_xnap_CellBasedQMC },
  {   1, &hf_xnap_tABased_01     , ASN1_NO_EXTENSIONS     , dissect_xnap_TABasedQMC },
  {   2, &hf_xnap_tAIBased_01    , ASN1_NO_EXTENSIONS     , dissect_xnap_TAIBasedQMC },
  {   3, &hf_xnap_pLMNAreaBased  , ASN1_NO_EXTENSIONS     , dissect_xnap_PLMNAreaBasedQMC },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_AreaScopeOfQMC, AreaScopeOfQMC_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t AS_SecurityInformation_sequence[] = {
  { &hf_xnap_key_NG_RAN_Star, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_256 },
  { &hf_xnap_ncc            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_7 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AS_SecurityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AS_SecurityInformation, AS_SecurityInformation_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_1_16_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, true);

  return offset;
}


static const value_string xnap_T_nextPagingAreaScope_vals[] = {
  {   0, "same" },
  {   1, "changed" },
  { 0, NULL }
};


static int
dissect_xnap_T_nextPagingAreaScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RANPagingAttemptInfo_sequence[] = {
  { &hf_xnap_pagingAttemptCount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_16_ },
  { &hf_xnap_intendedNumberOfPagingAttempts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_16_ },
  { &hf_xnap_nextPagingAreaScope, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nextPagingAreaScope },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RANPagingAttemptInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RANPagingAttemptInfo, RANPagingAttemptInfo_sequence);

  return offset;
}


static const per_sequence_t AssistanceDataForRANPaging_sequence[] = {
  { &hf_xnap_ran_paging_attempt_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANPagingAttemptInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AssistanceDataForRANPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AssistanceDataForRANPaging, AssistanceDataForRANPaging_sequence);

  return offset;
}



static int
dissect_xnap_AssistanceInformationQoE_Meas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, true);

  return offset;
}


static const per_sequence_t Associated_QoSFlowInfo_Item_sequence[] = {
  { &hf_xnap_mBS_QoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_associatedUnicastQoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Associated_QoSFlowInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Associated_QoSFlowInfo_Item, Associated_QoSFlowInfo_Item_sequence);

  return offset;
}


static const per_sequence_t Associated_QoSFlowInfo_List_sequence_of[1] = {
  { &hf_xnap_Associated_QoSFlowInfo_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Associated_QoSFlowInfo_Item },
};

static int
dissect_xnap_Associated_QoSFlowInfo_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Associated_QoSFlowInfo_List, Associated_QoSFlowInfo_List_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}



static int
dissect_xnap_AvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, true);

  return offset;
}



static int
dissect_xnap_AvailableRRCConnectionCapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const value_string xnap_T_applicationLayerBufferLevelList_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_applicationLayerBufferLevelList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_playoutDelayForMediaStartup_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_playoutDelayForMediaStartup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AvailableRVQoEMetrics_sequence[] = {
  { &hf_xnap_applicationLayerBufferLevelList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_applicationLayerBufferLevelList },
  { &hf_xnap_playoutDelayForMediaStartup, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_playoutDelayForMediaStartup },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AvailableRVQoEMetrics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AvailableRVQoEMetrics, AvailableRVQoEMetrics_sequence);

  return offset;
}



static int
dissect_xnap_BAPAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BAPPathID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPRoutingID_sequence[] = {
  { &hf_xnap_bAPAddress     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_bAPPathID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPPathID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BAPRoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BAPRoutingID, BAPRoutingID_sequence);

  return offset;
}


static const value_string xnap_BeamMeasurementIndicationM1_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_BeamMeasurementIndicationM1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_rSRP_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_rSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_rSRQ_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_rSRQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_sINR_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_sINR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t BeamMeasurementsReportQuantity_sequence[] = {
  { &hf_xnap_rSRP           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rSRP },
  { &hf_xnap_rSRQ           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rSRQ },
  { &hf_xnap_sINR           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_sINR },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BeamMeasurementsReportQuantity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BeamMeasurementsReportQuantity, BeamMeasurementsReportQuantity_sequence);

  return offset;
}



static int
dissect_xnap_MaxNrofRS_IndexesToReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, true);

  return offset;
}


static const per_sequence_t BeamMeasurementsReportConfiguration_sequence[] = {
  { &hf_xnap_beamMeasurementsReportQuantity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BeamMeasurementsReportQuantity },
  { &hf_xnap_maxNrofRS_IndexesToReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaxNrofRS_IndexesToReport },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BeamMeasurementsReportConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BeamMeasurementsReportConfiguration, BeamMeasurementsReportConfiguration_sequence);

  return offset;
}



static int
dissect_xnap_BHInfoIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofBHInfo, NULL, false);

  return offset;
}


static const per_sequence_t BHInfo_Item_sequence[] = {
  { &hf_xnap_bHInfoIndex    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfoIndex },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BHInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BHInfo_Item, BHInfo_Item_sequence);

  return offset;
}


static const per_sequence_t BHInfoList_sequence_of[1] = {
  { &hf_xnap_BHInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfo_Item },
};

static int
dissect_xnap_BHInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BHInfoList, BHInfoList_sequence_of,
                                                  1, maxnoofBHInfo, false);

  return offset;
}



static int
dissect_xnap_BHRLCChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPControlPDURLCCH_Item_sequence[] = {
  { &hf_xnap_bHRLCCHID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_nexthopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BAPControlPDURLCCH_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BAPControlPDURLCCH_Item, BAPControlPDURLCCH_Item_sequence);

  return offset;
}


static const per_sequence_t BAPControlPDURLCCH_List_sequence_of[1] = {
  { &hf_xnap_BAPControlPDURLCCH_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BAPControlPDURLCCH_Item },
};

static int
dissect_xnap_BAPControlPDURLCCH_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BAPControlPDURLCCH_List, BAPControlPDURLCCH_List_sequence_of,
                                                  1, maxnoofBAPControlPDURLCCHs, false);

  return offset;
}


static const value_string xnap_BluetoothMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_xnap_BluetoothMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_BluetoothName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 248, false, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);


  return offset;
}


static const per_sequence_t BluetoothMeasConfigNameList_sequence_of[1] = {
  { &hf_xnap_BluetoothMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BluetoothName },
};

static int
dissect_xnap_BluetoothMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BluetoothMeasConfigNameList, BluetoothMeasConfigNameList_sequence_of,
                                                  1, maxnoofBluetoothName, false);

  return offset;
}


static const value_string xnap_T_bt_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_bt_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t BluetoothMeasurementConfiguration_sequence[] = {
  { &hf_xnap_bluetoothMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BluetoothMeasConfig },
  { &hf_xnap_bluetoothMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BluetoothMeasConfigNameList },
  { &hf_xnap_bt_rssi        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_bt_rssi },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BluetoothMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BluetoothMeasurementConfiguration, BluetoothMeasurementConfiguration_sequence);

  return offset;
}


static const per_sequence_t BroadcastEUTRAPLMNs_sequence_of[1] = {
  { &hf_xnap_BroadcastEUTRAPLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_BroadcastEUTRAPLMNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastEUTRAPLMNs, BroadcastEUTRAPLMNs_sequence_of,
                                                  1, maxnoofEUTRABPLMNs, false);

  return offset;
}



static int
dissect_xnap_RANAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_EUTRA_Item_sequence[] = {
  { &hf_xnap_broadcastPLMNs , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastEUTRAPLMNs },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_e_utraCI       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_Cell_Identity },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BPLMN_ID_Info_EUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BPLMN_ID_Info_EUTRA_Item, BPLMN_ID_Info_EUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_EUTRA_sequence_of[1] = {
  { &hf_xnap_BPLMN_ID_Info_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BPLMN_ID_Info_EUTRA_Item },
};

static int
dissect_xnap_BPLMN_ID_Info_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BPLMN_ID_Info_EUTRA, BPLMN_ID_Info_EUTRA_sequence_of,
                                                  1, maxnoofEUTRABPLMNs, false);

  return offset;
}


static const per_sequence_t BroadcastPLMNs_sequence_of[1] = {
  { &hf_xnap_BroadcastPLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_BroadcastPLMNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastPLMNs, BroadcastPLMNs_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_NR_Item_sequence[] = {
  { &hf_xnap_broadcastPLMNs_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPLMNs },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_nr_CI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_Cell_Identity },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BPLMN_ID_Info_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BPLMN_ID_Info_NR_Item, BPLMN_ID_Info_NR_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_NR_sequence_of[1] = {
  { &hf_xnap_BPLMN_ID_Info_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BPLMN_ID_Info_NR_Item },
};

static int
dissect_xnap_BPLMN_ID_Info_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BPLMN_ID_Info_NR, BPLMN_ID_Info_NR_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}


static const per_sequence_t BroadcastCAG_Identifier_Item_sequence[] = {
  { &hf_xnap_cag_Identifier , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CAG_Identifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastCAG_Identifier_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastCAG_Identifier_Item, BroadcastCAG_Identifier_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastCAG_Identifier_List_sequence_of[1] = {
  { &hf_xnap_BroadcastCAG_Identifier_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastCAG_Identifier_Item },
};

static int
dissect_xnap_BroadcastCAG_Identifier_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastCAG_Identifier_List, BroadcastCAG_Identifier_List_sequence_of,
                                                  1, maxnoofCAGs, false);

  return offset;
}



static int
dissect_xnap_NID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     44, 44, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BroadcastNID_Item_sequence[] = {
  { &hf_xnap_nid            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastNID_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastNID_Item, BroadcastNID_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastNID_List_sequence_of[1] = {
  { &hf_xnap_BroadcastNID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastNID_Item },
};

static int
dissect_xnap_BroadcastNID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastNID_List, BroadcastNID_List_sequence_of,
                                                  1, maxnoofNIDs, false);

  return offset;
}



static int
dissect_xnap_OCTET_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, false, NULL);

  return offset;
}



static int
dissect_xnap_OCTET_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, NULL);

  return offset;
}


static const per_sequence_t S_NSSAI_sequence[] = {
  { &hf_xnap_sst            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_OCTET_STRING_SIZE_1 },
  { &hf_xnap_sd             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_OCTET_STRING_SIZE_3 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_S_NSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_S_NSSAI, S_NSSAI_sequence);

  return offset;
}


static const per_sequence_t SliceSupport_List_sequence_of[1] = {
  { &hf_xnap_SliceSupport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
};

static int
dissect_xnap_SliceSupport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SliceSupport_List, SliceSupport_List_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t BroadcastPLMNinTAISupport_Item_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAISliceSupport_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SliceSupport_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastPLMNinTAISupport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastPLMNinTAISupport_Item, BroadcastPLMNinTAISupport_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_Information_Item_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_broadcastCAG_Identifier_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastCAG_Identifier_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastPNI_NPN_ID_Information_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastPNI_NPN_ID_Information_Item, BroadcastPNI_NPN_ID_Information_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_Information_sequence_of[1] = {
  { &hf_xnap_BroadcastPNI_NPN_ID_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPNI_NPN_ID_Information_Item },
};

static int
dissect_xnap_BroadcastPNI_NPN_ID_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastPNI_NPN_ID_Information, BroadcastPNI_NPN_ID_Information_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}


static const per_sequence_t BroadcastSNPNID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_broadcastNID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastNID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastSNPNID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastSNPNID, BroadcastSNPNID_sequence);

  return offset;
}


static const per_sequence_t BroadcastSNPNID_List_sequence_of[1] = {
  { &hf_xnap_BroadcastSNPNID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastSNPNID },
};

static int
dissect_xnap_BroadcastSNPNID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastSNPNID_List, BroadcastSNPNID_List_sequence_of,
                                                  1, maxnoofSNPNIDs, false);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t CandidateRelayUEInfoItem_sequence[] = {
  { &hf_xnap_candidateRelayUEID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_24 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CandidateRelayUEInfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CandidateRelayUEInfoItem, CandidateRelayUEInfoItem_sequence);

  return offset;
}


static const per_sequence_t CandidateRelayUEInfoList_sequence_of[1] = {
  { &hf_xnap_CandidateRelayUEInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CandidateRelayUEInfoItem },
};

static int
dissect_xnap_CandidateRelayUEInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CandidateRelayUEInfoList, CandidateRelayUEInfoList_sequence_of,
                                                  1, maxnoofCandidateRelayUEs, false);

  return offset;
}



static int
dissect_xnap_CapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValue_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_ssbAreaCapacityValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_100 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBAreaCapacityValue_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBAreaCapacityValue_List_Item, SSBAreaCapacityValue_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValue_List_sequence_of[1] = {
  { &hf_xnap_SSBAreaCapacityValue_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBAreaCapacityValue_List_Item },
};

static int
dissect_xnap_SSBAreaCapacityValue_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSBAreaCapacityValue_List, SSBAreaCapacityValue_List_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t CapacityValueInfo_sequence[] = {
  { &hf_xnap_capacityValue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CapacityValue },
  { &hf_xnap_ssbAreaCapacityValueList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SSBAreaCapacityValue_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CapacityValueInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CapacityValueInfo, CapacityValueInfo_sequence);

  return offset;
}


static const value_string xnap_CauseRadioNetworkLayer_vals[] = {
  {   0, "cell-not-available" },
  {   1, "handover-desirable-for-radio-reasons" },
  {   2, "handover-target-not-allowed" },
  {   3, "invalid-AMF-Set-ID" },
  {   4, "no-radio-resources-available-in-target-cell" },
  {   5, "partial-handover" },
  {   6, "reduce-load-in-serving-cell" },
  {   7, "resource-optimisation-handover" },
  {   8, "time-critical-handover" },
  {   9, "tXnRELOCoverall-expiry" },
  {  10, "tXnRELOCprep-expiry" },
  {  11, "unknown-GUAMI-ID" },
  {  12, "unknown-local-NG-RAN-node-UE-XnAP-ID" },
  {  13, "inconsistent-remote-NG-RAN-node-UE-XnAP-ID" },
  {  14, "encryption-and-or-integrity-protection-algorithms-not-supported" },
  {  15, "not-used-causes-value-1" },
  {  16, "multiple-PDU-session-ID-instances" },
  {  17, "unknown-PDU-session-ID" },
  {  18, "unknown-QoS-Flow-ID" },
  {  19, "multiple-QoS-Flow-ID-instances" },
  {  20, "switch-off-ongoing" },
  {  21, "not-supported-5QI-value" },
  {  22, "tXnDCoverall-expiry" },
  {  23, "tXnDCprep-expiry" },
  {  24, "action-desirable-for-radio-reasons" },
  {  25, "reduce-load" },
  {  26, "resource-optimisation" },
  {  27, "time-critical-action" },
  {  28, "target-not-allowed" },
  {  29, "no-radio-resources-available" },
  {  30, "invalid-QoS-combination" },
  {  31, "encryption-algorithms-not-supported" },
  {  32, "procedure-cancelled" },
  {  33, "rRM-purpose" },
  {  34, "improve-user-bit-rate" },
  {  35, "user-inactivity" },
  {  36, "radio-connection-with-UE-lost" },
  {  37, "failure-in-the-radio-interface-procedure" },
  {  38, "bearer-option-not-supported" },
  {  39, "up-integrity-protection-not-possible" },
  {  40, "up-confidentiality-protection-not-possible" },
  {  41, "resources-not-available-for-the-slice-s" },
  {  42, "ue-max-IP-data-rate-reason" },
  {  43, "cP-integrity-protection-failure" },
  {  44, "uP-integrity-protection-failure" },
  {  45, "slice-not-supported-by-NG-RAN" },
  {  46, "mN-Mobility" },
  {  47, "sN-Mobility" },
  {  48, "count-reaches-max-value" },
  {  49, "unknown-old-NG-RAN-node-UE-XnAP-ID" },
  {  50, "pDCP-Overload" },
  {  51, "drb-id-not-available" },
  {  52, "unspecified" },
  {  53, "ue-context-id-not-known" },
  {  54, "non-relocation-of-context" },
  {  55, "cho-cpc-resources-tobechanged" },
  {  56, "rSN-not-available-for-the-UP" },
  {  57, "npn-access-denied" },
  {  58, "report-characteristics-empty" },
  {  59, "existing-measurement-ID" },
  {  60, "measurement-temporarily-not-available" },
  {  61, "measurement-not-supported-for-the-object" },
  {  62, "ue-power-saving" },
  {  63, "not-existing-NG-RAN-node2-Measurement-ID" },
  {  64, "insufficient-ue-capabilities" },
  {  65, "normal-release" },
  {  66, "value-out-of-allowed-range" },
  {  67, "scg-activation-deactivation-failure" },
  {  68, "scg-deactivation-failure-due-to-data-transmission" },
  {  69, "ssb-not-available" },
  {  70, "lTM-triggered" },
  {  71, "no-Backhaul-Resource" },
  {  72, "mIAB-node-not-authorized" },
  {  73, "iAB-not-authorized" },
  { 0, NULL }
};

static value_string_ext xnap_CauseRadioNetworkLayer_vals_ext = VALUE_STRING_EXT_INIT(xnap_CauseRadioNetworkLayer_vals);


static int
dissect_xnap_CauseRadioNetworkLayer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     53, NULL, true, 21, NULL);

  return offset;
}


static const value_string xnap_CauseTransportLayer_vals[] = {
  {   0, "transport-resource-unavailable" },
  {   1, "unspecified" },
  { 0, NULL }
};


static int
dissect_xnap_CauseTransportLayer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "abstract-syntax-error-falsely-constructed-message" },
  {   6, "unspecified" },
  { 0, NULL }
};


static int
dissect_xnap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "hardware-failure" },
  {   2, "o-and-M-intervention" },
  {   3, "not-enough-user-plane-processing-resources" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_xnap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_xnap_radioNetwork   , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseRadioNetworkLayer },
  {   1, &hf_xnap_transport      , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseTransportLayer },
  {   2, &hf_xnap_protocol       , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseProtocol },
  {   3, &hf_xnap_misc           , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseMisc },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Cause, Cause_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI_sequence_of[1] = {
  { &hf_xnap_limitedNR_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI, SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const value_string xnap_T_full_List_vals[] = {
  {   0, "all-served-cells-NR" },
  { 0, NULL }
};


static int
dissect_xnap_T_full_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CellAssistanceInfo_NR_vals[] = {
  {   0, "limitedNR-List" },
  {   1, "full-List" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CellAssistanceInfo_NR_choice[] = {
  {   0, &hf_xnap_limitedNR_List , ASN1_NO_EXTENSIONS     , dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI },
  {   1, &hf_xnap_full_List      , ASN1_NO_EXTENSIONS     , dissect_xnap_T_full_List },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_CellAssistanceInfo_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_CellAssistanceInfo_NR, CellAssistanceInfo_NR_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MaximumCellListSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16384U, NULL, true);

  return offset;
}


static const per_sequence_t CellAndCapacityAssistanceInfo_NR_sequence[] = {
  { &hf_xnap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumCellListSize },
  { &hf_xnap_cellAssistanceInfo_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellAssistanceInfo_NR },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellAndCapacityAssistanceInfo_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellAndCapacityAssistanceInfo_NR, CellAndCapacityAssistanceInfo_NR_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI_sequence_of[1] = {
  { &hf_xnap_limitedEUTRA_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI, SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const value_string xnap_T_full_List_01_vals[] = {
  {   0, "all-served-cells-E-UTRA" },
  { 0, NULL }
};


static int
dissect_xnap_T_full_List_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CellAssistanceInfo_EUTRA_vals[] = {
  {   0, "limitedEUTRA-List" },
  {   1, "full-List" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CellAssistanceInfo_EUTRA_choice[] = {
  {   0, &hf_xnap_limitedEUTRA_List, ASN1_NO_EXTENSIONS     , dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI },
  {   1, &hf_xnap_full_List_01   , ASN1_NO_EXTENSIONS     , dissect_xnap_T_full_List_01 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_CellAssistanceInfo_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_CellAssistanceInfo_EUTRA, CellAssistanceInfo_EUTRA_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellAndCapacityAssistanceInfo_EUTRA_sequence[] = {
  { &hf_xnap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumCellListSize },
  { &hf_xnap_cellAssistanceInfo_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellAssistanceInfo_EUTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellAndCapacityAssistanceInfo_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellAndCapacityAssistanceInfo_EUTRA, CellAndCapacityAssistanceInfo_EUTRA_sequence);

  return offset;
}



static int
dissect_xnap_CellCapacityClassValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, true);

  return offset;
}


static const value_string xnap_CellDeploymentStatusIndicator_vals[] = {
  {   0, "pre-change-notification" },
  { 0, NULL }
};


static int
dissect_xnap_CellDeploymentStatusIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_CellGroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofSCellGroups, NULL, false);

  return offset;
}



static int
dissect_xnap_DL_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_UL_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_DL_non_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_UL_non_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_DL_Total_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_UL_Total_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t NG_eNB_RadioResourceStatus_sequence[] = {
  { &hf_xnap_dL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_GBR_PRB_usage },
  { &hf_xnap_uL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_GBR_PRB_usage },
  { &hf_xnap_dL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_non_GBR_PRB_usage },
  { &hf_xnap_uL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_non_GBR_PRB_usage },
  { &hf_xnap_dL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_Total_PRB_usage },
  { &hf_xnap_uL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_Total_PRB_usage },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NG_eNB_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NG_eNB_RadioResourceStatus, NG_eNB_RadioResourceStatus_sequence);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatus_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_ssb_Area_DL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_UL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_dL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_non_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_uL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_non_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_dL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_Total_PRB_usage },
  { &hf_xnap_ssb_Area_uL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_Total_PRB_usage },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBAreaRadioResourceStatus_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBAreaRadioResourceStatus_List_Item, SSBAreaRadioResourceStatus_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatus_List_sequence_of[1] = {
  { &hf_xnap_SSBAreaRadioResourceStatus_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBAreaRadioResourceStatus_List_Item },
};

static int
dissect_xnap_SSBAreaRadioResourceStatus_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSBAreaRadioResourceStatus_List, SSBAreaRadioResourceStatus_List_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t GNB_RadioResourceStatus_sequence[] = {
  { &hf_xnap_ssbAreaRadioResourceStatus_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSBAreaRadioResourceStatus_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GNB_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GNB_RadioResourceStatus, GNB_RadioResourceStatus_sequence);

  return offset;
}


static const value_string xnap_RadioResourceStatus_vals[] = {
  {   0, "ng-eNB-RadioResourceStatus" },
  {   1, "gNB-RadioResourceStatus" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RadioResourceStatus_choice[] = {
  {   0, &hf_xnap_ng_eNB_RadioResourceStatus, ASN1_NO_EXTENSIONS     , dissect_xnap_NG_eNB_RadioResourceStatus },
  {   1, &hf_xnap_gNB_RadioResourceStatus, ASN1_NO_EXTENSIONS     , dissect_xnap_GNB_RadioResourceStatus },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_RadioResourceStatus, RadioResourceStatus_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_OfferedCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16777216U, NULL, true);

  return offset;
}


static const per_sequence_t TNLCapacityIndicator_sequence[] = {
  { &hf_xnap_dLTNLOfferedCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_OfferedCapacity },
  { &hf_xnap_dLTNLAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AvailableCapacity },
  { &hf_xnap_uLTNLOfferedCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_OfferedCapacity },
  { &hf_xnap_uLTNLAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AvailableCapacity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLCapacityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLCapacityIndicator, TNLCapacityIndicator_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacity_sequence[] = {
  { &hf_xnap_cellCapacityClassValue, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellCapacityClassValue },
  { &hf_xnap_capacityValueInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CapacityValueInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CompositeAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CompositeAvailableCapacity, CompositeAvailableCapacity_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacityGroup_sequence[] = {
  { &hf_xnap_compositeAvailableCapacityDownlink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CompositeAvailableCapacity },
  { &hf_xnap_compositeAvailableCapacityUplink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CompositeAvailableCapacity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CompositeAvailableCapacityGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CompositeAvailableCapacityGroup, CompositeAvailableCapacityGroup_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_Item_sequence[] = {
  { &hf_xnap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_sliceAvailableCapacityValueDownlink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_100 },
  { &hf_xnap_sliceAvailableCapacityValueUplink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_100 },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SNSSAIAvailableCapacity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SNSSAIAvailableCapacity_Item, SNSSAIAvailableCapacity_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_List_sequence_of[1] = {
  { &hf_xnap_SNSSAIAvailableCapacity_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAIAvailableCapacity_Item },
};

static int
dissect_xnap_SNSSAIAvailableCapacity_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SNSSAIAvailableCapacity_List, SNSSAIAvailableCapacity_List_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t SliceAvailableCapacity_Item_sequence[] = {
  { &hf_xnap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_sNSSAIAvailableCapacity_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAIAvailableCapacity_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SliceAvailableCapacity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SliceAvailableCapacity_Item, SliceAvailableCapacity_Item_sequence);

  return offset;
}


static const per_sequence_t SliceAvailableCapacity_sequence_of[1] = {
  { &hf_xnap_SliceAvailableCapacity_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SliceAvailableCapacity_Item },
};

static int
dissect_xnap_SliceAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SliceAvailableCapacity, SliceAvailableCapacity_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}



static int
dissect_xnap_NumberofActiveUEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, true);

  return offset;
}



static int
dissect_xnap_NoofRRCConnections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65536U, NULL, true);

  return offset;
}


static const per_sequence_t RRCConnections_sequence[] = {
  { &hf_xnap_noofRRCConnections, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NoofRRCConnections },
  { &hf_xnap_availableRRCConnectionCapacityValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AvailableRRCConnectionCapacityValue },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCConnections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCConnections, RRCConnections_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResult_Item_sequence[] = {
  { &hf_xnap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_radioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RadioResourceStatus },
  { &hf_xnap_tNLCapacityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TNLCapacityIndicator },
  { &hf_xnap_compositeAvailableCapacityGroup, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CompositeAvailableCapacityGroup },
  { &hf_xnap_sliceAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SliceAvailableCapacity },
  { &hf_xnap_numberofActiveUEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NumberofActiveUEs },
  { &hf_xnap_rRCConnections , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RRCConnections },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellMeasurementResult_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellMeasurementResult_Item, CellMeasurementResult_Item_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResult_sequence_of[1] = {
  { &hf_xnap_CellMeasurementResult_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellMeasurementResult_Item },
};

static int
dissect_xnap_CellMeasurementResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellMeasurementResult, CellMeasurementResult_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const value_string xnap_Cell_Type_Choice_vals[] = {
  {   0, "ng-ran-e-utra" },
  {   1, "ng-ran-nr" },
  {   2, "e-utran" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Cell_Type_Choice_choice[] = {
  {   0, &hf_xnap_ng_ran_e_utra  , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_Cell_Identity },
  {   1, &hf_xnap_ng_ran_nr      , ASN1_NO_EXTENSIONS     , dissect_xnap_NR_Cell_Identity },
  {   2, &hf_xnap_e_utran        , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_Cell_Identity },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Cell_Type_Choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Cell_Type_Choice, Cell_Type_Choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalCell_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_cell_type      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Cell_Type_Choice },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalCell_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalCell_ID, GlobalCell_ID_sequence);

  return offset;
}


static const per_sequence_t ReplacingCells_Item_sequence[] = {
  { &hf_xnap_globalNG_RANCell_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalCell_ID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ReplacingCells_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ReplacingCells_Item, ReplacingCells_Item_sequence);

  return offset;
}


static const per_sequence_t ReplacingCells_sequence_of[1] = {
  { &hf_xnap_ReplacingCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ReplacingCells_Item },
};

static int
dissect_xnap_ReplacingCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ReplacingCells, ReplacingCells_sequence_of,
                                                  0, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const per_sequence_t CellReplacingInfo_sequence[] = {
  { &hf_xnap_replacingCells , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReplacingCells },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellReplacingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellReplacingInfo, CellReplacingInfo_sequence);

  return offset;
}


static const per_sequence_t SSBToReport_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBToReport_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBToReport_List_Item, SSBToReport_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSBToReport_List_sequence_of[1] = {
  { &hf_xnap_SSBToReport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBToReport_List_Item },
};

static int
dissect_xnap_SSBToReport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSBToReport_List, SSBToReport_List_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t SNSSAI_Item_sequence[] = {
  { &hf_xnap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SNSSAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SNSSAI_Item, SNSSAI_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAI_list_sequence_of[1] = {
  { &hf_xnap_SNSSAI_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAI_Item },
};

static int
dissect_xnap_SNSSAI_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SNSSAI_list, SNSSAI_list_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t SliceToReport_List_Item_sequence[] = {
  { &hf_xnap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_sNSSAIlist     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAI_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SliceToReport_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SliceToReport_List_Item, SliceToReport_List_Item_sequence);

  return offset;
}


static const per_sequence_t SliceToReport_List_sequence_of[1] = {
  { &hf_xnap_SliceToReport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SliceToReport_List_Item },
};

static int
dissect_xnap_SliceToReport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SliceToReport_List, SliceToReport_List_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}


static const per_sequence_t CellToReport_Item_sequence[] = {
  { &hf_xnap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_sSBToReport_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SSBToReport_List },
  { &hf_xnap_sliceToReport_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SliceToReport_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellToReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellToReport_Item, CellToReport_Item_sequence);

  return offset;
}


static const per_sequence_t CellToReport_sequence_of[1] = {
  { &hf_xnap_CellToReport_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellToReport_Item },
};

static int
dissect_xnap_CellToReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellToReport, CellToReport_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const per_sequence_t CellToReportForDataCollection_Item_sequence[] = {
  { &hf_xnap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellToReportForDataCollection_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellToReportForDataCollection_Item, CellToReportForDataCollection_Item_sequence);

  return offset;
}


static const per_sequence_t CellToReportForDataCollection_List_sequence_of[1] = {
  { &hf_xnap_CellToReportForDataCollection_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellToReportForDataCollection_Item },
};

static int
dissect_xnap_CellToReportForDataCollection_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellToReportForDataCollection_List, CellToReportForDataCollection_List_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const per_sequence_t PredictedTrajectoryNGRANCellInfo_sequence[] = {
  { &hf_xnap_globalNG_RANCell_ID_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_predictedTimeUEStaysInCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_4095 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PredictedTrajectoryNGRANCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PredictedTrajectoryNGRANCellInfo, PredictedTrajectoryNGRANCellInfo_sequence);

  return offset;
}


static const value_string xnap_PredictedTrajectoryCellInfo_vals[] = {
  {   0, "nG-RAN-Cell-Predicted" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PredictedTrajectoryCellInfo_choice[] = {
  {   0, &hf_xnap_nG_RAN_Cell_Predicted, ASN1_NO_EXTENSIONS     , dissect_xnap_PredictedTrajectoryNGRANCellInfo },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_PredictedTrajectoryCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_PredictedTrajectoryCellInfo, PredictedTrajectoryCellInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PredictedUETrajectory_Item_sequence[] = {
  { &hf_xnap_predictedtrajectoryCellInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PredictedTrajectoryCellInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PredictedUETrajectory_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PredictedUETrajectory_Item, PredictedUETrajectory_Item_sequence);

  return offset;
}


static const per_sequence_t CellBasedUETrajectoryPrediction_sequence_of[1] = {
  { &hf_xnap_CellBasedUETrajectoryPrediction_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PredictedUETrajectory_Item },
};

static int
dissect_xnap_CellBasedUETrajectoryPrediction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellBasedUETrajectoryPrediction, CellBasedUETrajectoryPrediction_sequence_of,
                                                  1, maxnoofCellsTrajectoryPredict, false);

  return offset;
}



static int
dissect_xnap_T_cellmeasurementFailedReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_xnap_cellmeasurementFailedReportCharacteristics_PredictedRadioResourceStatus,
      &hf_xnap_cellmeasurementFailedReportCharacteristics_PredictedNumberofActiveUEs,
      &hf_xnap_cellmeasurementFailedReportCharacteristics_PredictedRRCConnections,
      &hf_xnap_cellmeasurementFailedReportCharacteristics_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_cellmeasurementFailedReportCharacteristics);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 4, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t CellMeasurementFailureCause_Item_sequence[] = {
  { &hf_xnap_cellmeasurementFailedReportCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_cellmeasurementFailedReportCharacteristics },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Cause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellMeasurementFailureCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellMeasurementFailureCause_Item, CellMeasurementFailureCause_Item_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementFailureCause_List_sequence_of[1] = {
  { &hf_xnap_CellMeasurementFailureCause_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellMeasurementFailureCause_Item },
};

static int
dissect_xnap_CellMeasurementFailureCause_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellMeasurementFailureCause_List, CellMeasurementFailureCause_List_sequence_of,
                                                  1, maxFailedCellMeasObjects, false);

  return offset;
}


static const per_sequence_t CellMeasurementInitiationResult_Item_sequence[] = {
  { &hf_xnap_cellID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_cellMeasurementFailureCause_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellMeasurementFailureCause_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellMeasurementInitiationResult_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellMeasurementInitiationResult_Item, CellMeasurementInitiationResult_Item_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementInitiationResult_List_sequence_of[1] = {
  { &hf_xnap_CellMeasurementInitiationResult_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellMeasurementInitiationResult_Item },
};

static int
dissect_xnap_CellMeasurementInitiationResult_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellMeasurementInitiationResult_List, CellMeasurementInitiationResult_List_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const per_sequence_t CellInfoResultForDataCollection_Item_sequence[] = {
  { &hf_xnap_cellID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_predictedRadioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RadioResourceStatus },
  { &hf_xnap_predictedNumberofActiveUEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NumberofActiveUEs },
  { &hf_xnap_predictedRRCConnections, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RRCConnections },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellInfoResultForDataCollection_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellInfoResultForDataCollection_Item, CellInfoResultForDataCollection_Item_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResultForDataCollection_List_sequence_of[1] = {
  { &hf_xnap_CellMeasurementResultForDataCollection_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellInfoResultForDataCollection_Item },
};

static int
dissect_xnap_CellMeasurementResultForDataCollection_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellMeasurementResultForDataCollection_List, CellMeasurementResultForDataCollection_List_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, false);

  return offset;
}



static int
dissect_xnap_MeasObjectContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MeasObjectContainer);
    dissect_nr_rrc_MeasObjectToAddMod_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_ReportConfigContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_ReportConfigContainer);
    dissect_nr_rrc_ReportConfigToAddMod_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CHOExecutionCondition_Item_sequence[] = {
  { &hf_xnap_measObjectContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasObjectContainer },
  { &hf_xnap_reportConfigContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportConfigContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOExecutionCondition_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOExecutionCondition_Item, CHOExecutionCondition_Item_sequence);

  return offset;
}


static const per_sequence_t CHOExecutionCondition_List_sequence_of[1] = {
  { &hf_xnap_CHOExecutionCondition_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CHOExecutionCondition_Item },
};

static int
dissect_xnap_CHOExecutionCondition_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CHOExecutionCondition_List, CHOExecutionCondition_List_sequence_of,
                                                  1, maxnoofCHOexecutioncond, false);

  return offset;
}


static const per_sequence_t CHOCandidateCell_Item_sequence[] = {
  { &hf_xnap_choCandidateCellID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_choExecutionCondition_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHOExecutionCondition_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOCandidateCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOCandidateCell_Item, CHOCandidateCell_Item_sequence);

  return offset;
}


static const per_sequence_t CHOCandidateCell_List_sequence_of[1] = {
  { &hf_xnap_CHOCandidateCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CHOCandidateCell_Item },
};

static int
dissect_xnap_CHOCandidateCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CHOCandidateCell_List, CHOCandidateCell_List_sequence_of,
                                                  1, maxnoofCellsinCHO, false);

  return offset;
}


static const per_sequence_t CHOConfiguration_sequence[] = {
  { &hf_xnap_choCandidateCell_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHOCandidateCell_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOConfiguration, CHOConfiguration_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_T_traceabletoUTC_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_traceabletoUTC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_traceabletoGNSS_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_traceabletoGNSS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_40000000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 40000000U, NULL, true);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_16_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, true, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t ClockQualityAcceptanceCriteria_sequence[] = {
  { &hf_xnap_synchronisationState, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_8_ },
  { &hf_xnap_traceabletoUTC , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_traceabletoUTC },
  { &hf_xnap_traceabletoGNSS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_traceabletoGNSS },
  { &hf_xnap_clockFrequencyStability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_16 },
  { &hf_xnap_clockAccuracy  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_40000000_ },
  { &hf_xnap_parentTimeSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_16_ },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ClockQualityAcceptanceCriteria(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ClockQualityAcceptanceCriteria, ClockQualityAcceptanceCriteria_sequence);

  return offset;
}



static int
dissect_xnap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string xnap_ClockQualityDetailLevel_vals[] = {
  {   0, "clockQualityMetrics" },
  {   1, "acceptanceIndication" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ClockQualityDetailLevel_choice[] = {
  {   0, &hf_xnap_clockQualityMetrics, ASN1_NO_EXTENSIONS     , dissect_xnap_NULL },
  {   1, &hf_xnap_acceptanceIndication, ASN1_NO_EXTENSIONS     , dissect_xnap_ClockQualityAcceptanceCriteria },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ClockQualityDetailLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ClockQualityDetailLevel, ClockQualityDetailLevel_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ClockQualityReportingControlInfo_sequence[] = {
  { &hf_xnap_clockQualityDetailLevel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ClockQualityDetailLevel },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ClockQualityReportingControlInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ClockQualityReportingControlInfo, ClockQualityReportingControlInfo_sequence);

  return offset;
}


static const value_string xnap_CapabilityForBATAdaptation_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_CapabilityForBATAdaptation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_ControlPlaneTrafficType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, true);

  return offset;
}


static const value_string xnap_CHO_MRDC_EarlyDataForwarding_vals[] = {
  {   0, "stop" },
  { 0, NULL }
};


static int
dissect_xnap_CHO_MRDC_EarlyDataForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CHO_MRDC_Indicator_vals[] = {
  {   0, "true" },
  {   1, "coordination-only" },
  { 0, NULL }
};


static int
dissect_xnap_CHO_MRDC_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 1, NULL);

  return offset;
}


static const value_string xnap_CHOtrigger_vals[] = {
  {   0, "cho-initiation" },
  {   1, "cho-replace" },
  { 0, NULL }
};


static int
dissect_xnap_CHOtrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_NG_RANnodeUEXnAPID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}



static int
dissect_xnap_CHO_Probability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t CHOinformation_Req_sequence[] = {
  { &hf_xnap_cho_trigger    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHOtrigger },
  { &hf_xnap_targetNG_RANnodeUEXnAPID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_cHO_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_Req(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_Req, CHOinformation_Req_sequence);

  return offset;
}



static int
dissect_xnap_CHO_HandoverWindowStart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(549755813887), NULL, false);

  return offset;
}



static int
dissect_xnap_CHO_HandoverWindowDuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 6000U, NULL, false);

  return offset;
}


static const per_sequence_t CHOTimeBasedInformation_sequence[] = {
  { &hf_xnap_cHO_HOWindowStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHO_HandoverWindowStart },
  { &hf_xnap_cHO_HOWindowDuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHO_HandoverWindowDuration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOTimeBasedInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOTimeBasedInformation, CHOTimeBasedInformation_sequence);

  return offset;
}


static const value_string xnap_Target_CGI_vals[] = {
  {   0, "nr" },
  {   1, "e-utra" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Target_CGI_choice[] = {
  {   0, &hf_xnap_nr_02          , ASN1_NO_EXTENSIONS     , dissect_xnap_NR_CGI },
  {   1, &hf_xnap_e_utra_02      , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_CGI },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Target_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Target_CGI, Target_CGI_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MaxCHOpreparations(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}


static const per_sequence_t CHOinformation_Ack_sequence[] = {
  { &hf_xnap_requestedTargetCellGlobalID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Target_CGI },
  { &hf_xnap_maxCHOoperations, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaxCHOpreparations },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_Ack(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_Ack, CHOinformation_Ack_sequence);

  return offset;
}


static const per_sequence_t CHOinformation_AddReq_sequence[] = {
  { &hf_xnap_source_M_NGRAN_node_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_source_M_NGRAN_node_UE_XnAP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_cHO_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_AddReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_AddReq, CHOinformation_AddReq_sequence);

  return offset;
}


static const per_sequence_t CHOinformation_AddReqAck_sequence[] = {
  { &hf_xnap_pCell_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_AddReqAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_AddReqAck, CHOinformation_AddReqAck_sequence);

  return offset;
}


static const value_string xnap_T_conditionalReconfig_vals[] = {
  {   0, "intra-mn-cho" },
  { 0, NULL }
};


static int
dissect_xnap_T_conditionalReconfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CHOinformation_ModReq_sequence[] = {
  { &hf_xnap_conditionalReconfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_conditionalReconfig },
  { &hf_xnap_cHO_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_ModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_ModReq, CHOinformation_ModReq_sequence);

  return offset;
}



static int
dissect_xnap_CHO_Maxnoof_CondReconfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}


static const value_string xnap_CHO_CPAC_Config_Indicator_vals[] = {
  {   0, "cho-only-not-prepared" },
  { 0, NULL }
};


static int
dissect_xnap_CHO_CPAC_Config_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_PDUSession_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string xnap_T_dL_NG_U_TNL_Information_Unchanged_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_dL_NG_U_TNL_Information_Unchanged(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlowsAdmitted_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsAdmitted_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsAdmitted_Item, QoSFlowsAdmitted_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsAdmitted_List_sequence_of[1] = {
  { &hf_xnap_QoSFlowsAdmitted_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsAdmitted_Item },
};

static int
dissect_xnap_QoSFlowsAdmitted_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsAdmitted_List, QoSFlowsAdmitted_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t QoSFlowwithCause_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Cause },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowwithCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowwithCause_Item, QoSFlowwithCause_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlows_List_withCause_sequence_of[1] = {
  { &hf_xnap_QoSFlows_List_withCause_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowwithCause_Item },
};

static int
dissect_xnap_QoSFlows_List_withCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlows_List_withCause, QoSFlows_List_withCause_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceAdmittedInfo_sequence[] = {
  { &hf_xnap_dL_NG_U_TNL_Information_Unchanged, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_dL_NG_U_TNL_Information_Unchanged },
  { &hf_xnap_qosFlowsAdmitted_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsAdmitted_List },
  { &hf_xnap_qosFlowsNotAdmitted_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_dataForwardingInfoFromTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceAdmittedInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceAdmittedInfo, PDUSessionResourceAdmittedInfo_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesAdmitted_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_pduSessionResourceAdmittedInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourceAdmittedInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourcesAdmitted_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourcesAdmitted_Item, PDUSessionResourcesAdmitted_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesAdmitted_List_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourcesAdmitted_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesAdmitted_Item },
};

static int
dissect_xnap_PDUSessionResourcesAdmitted_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourcesAdmitted_List, PDUSessionResourcesAdmitted_List_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_xnap_OCTET_STRING(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const per_sequence_t CHO_Candidate_PSCells_Item_sequence[] = {
  { &hf_xnap_pscell_id      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_target2source_NG_RANNode_Container, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_OCTET_STRING },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHO_Candidate_PSCells_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHO_Candidate_PSCells_Item, CHO_Candidate_PSCells_Item_sequence);

  return offset;
}


static const per_sequence_t CHO_Candidate_PSCells_list_sequence_of[1] = {
  { &hf_xnap_CHO_Candidate_PSCells_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CHO_Candidate_PSCells_Item },
};

static int
dissect_xnap_CHO_Candidate_PSCells_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CHO_Candidate_PSCells_list, CHO_Candidate_PSCells_list_sequence_of,
                                                  1, maxnoofPSCellCandidates, false);

  return offset;
}


static const per_sequence_t CHO_target_SN_node_Item_sequence[] = {
  { &hf_xnap_target_S_NG_RANnodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_pduSessionResourcesAdmittedList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesAdmitted_List },
  { &hf_xnap_cho_Candidate_PSCells_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHO_Candidate_PSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHO_target_SN_node_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHO_target_SN_node_Item, CHO_target_SN_node_Item_sequence);

  return offset;
}


static const per_sequence_t CHO_target_SN_node_list_sequence_of[1] = {
  { &hf_xnap_CHO_target_SN_node_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CHO_target_SN_node_Item },
};

static int
dissect_xnap_CHO_target_SN_node_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CHO_target_SN_node_list, CHO_target_SN_node_list_sequence_of,
                                                  1, maxnoofTargetSNs, false);

  return offset;
}


static const per_sequence_t CHO_CPAC_Information_sequence[] = {
  { &hf_xnap_cHO_CPAC_config_indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_CPAC_Config_Indicator },
  { &hf_xnap_cHO_target_SN_node_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHO_target_SN_node_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHO_CPAC_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHO_CPAC_Information, CHO_CPAC_Information_sequence);

  return offset;
}



static int
dissect_xnap_CNsubgroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}


static const value_string xnap_CompleteConfig_Indicator_vals[] = {
  {   0, "complete-config" },
  { 0, NULL }
};


static int
dissect_xnap_CompleteConfig_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Conditional_Reconfig_Item_sequence[] = {
  { &hf_xnap_pCell_ID_01    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Target_CGI },
  { &hf_xnap_pSCell_ID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NR_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Conditional_Reconfig_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Conditional_Reconfig_Item, Conditional_Reconfig_Item_sequence);

  return offset;
}


static const per_sequence_t Conditional_Reconfig_List_sequence_of[1] = {
  { &hf_xnap_Conditional_Reconfig_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Conditional_Reconfig_Item },
};

static int
dissect_xnap_Conditional_Reconfig_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Conditional_Reconfig_List, Conditional_Reconfig_List_sequence_of,
                                                  1, maxnoofPSCellCandidates, false);

  return offset;
}


static const value_string xnap_ConfiguredTACIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_ConfiguredTACIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_eNDC_Support_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_xnap_T_eNDC_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Connectivity_Support_sequence[] = {
  { &hf_xnap_eNDC_Support   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_eNDC_Support },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Connectivity_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Connectivity_Support, Connectivity_Support_sequence);

  return offset;
}



static int
dissect_xnap_ContainerAppLayerMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 8000, false, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_1048575(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, false);

  return offset;
}


static const per_sequence_t COUNT_PDCP_SN12_sequence[] = {
  { &hf_xnap_pdcp_SN12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_4095 },
  { &hf_xnap_hfn_PDCP_SN12  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_1048575 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_COUNT_PDCP_SN12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_COUNT_PDCP_SN12, COUNT_PDCP_SN12_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_0_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, false);

  return offset;
}


static const per_sequence_t COUNT_PDCP_SN18_sequence[] = {
  { &hf_xnap_pdcp_SN18      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_262143 },
  { &hf_xnap_hfn_PDCP_SN18  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_16383 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_COUNT_PDCP_SN18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_COUNT_PDCP_SN18, COUNT_PDCP_SN18_sequence);

  return offset;
}


static const value_string xnap_CoverageModificationCause_vals[] = {
  {   0, "coverage" },
  {   1, "cell-edge-capacity" },
  {   2, "network-energy-saving" },
  { 0, NULL }
};


static int
dissect_xnap_CoverageModificationCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 1, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_63_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, true);

  return offset;
}


static const per_sequence_t SSB_Coverage_Modification_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_sSBCoverageState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_15_ },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSB_Coverage_Modification_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSB_Coverage_Modification_List_Item, SSB_Coverage_Modification_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSB_Coverage_Modification_List_sequence_of[1] = {
  { &hf_xnap_SSB_Coverage_Modification_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_Coverage_Modification_List_Item },
};

static int
dissect_xnap_SSB_Coverage_Modification_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSB_Coverage_Modification_List, SSB_Coverage_Modification_List_sequence_of,
                                                  0, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t Coverage_Modification_List_Item_sequence[] = {
  { &hf_xnap_globalNG_RANCell_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalCell_ID },
  { &hf_xnap_cellCoverageState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63_ },
  { &hf_xnap_cellDeploymentStatusIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellDeploymentStatusIndicator },
  { &hf_xnap_cellReplacingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellReplacingInfo },
  { &hf_xnap_sSB_Coverage_Modification_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_Coverage_Modification_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Coverage_Modification_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Coverage_Modification_List_Item, Coverage_Modification_List_Item_sequence);

  return offset;
}


static const per_sequence_t Coverage_Modification_List_sequence_of[1] = {
  { &hf_xnap_Coverage_Modification_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Coverage_Modification_List_Item },
};

static int
dissect_xnap_Coverage_Modification_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Coverage_Modification_List, Coverage_Modification_List_sequence_of,
                                                  0, maxnoofCellsinNG_RANnode, false);

  return offset;
}


static const value_string xnap_CPTransportLayerInformation_vals[] = {
  {   0, "endpointIPAddress" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CPTransportLayerInformation_choice[] = {
  {   0, &hf_xnap_endpointIPAddress, ASN1_NO_EXTENSIONS     , dissect_xnap_TransportLayerAddress },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_CPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_CPTransportLayerInformation, CPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CPACcandidatePSCells_item_sequence[] = {
  { &hf_xnap_pscell_id      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACcandidatePSCells_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACcandidatePSCells_item, CPACcandidatePSCells_item_sequence);

  return offset;
}


static const per_sequence_t CPACcandidatePSCells_list_sequence_of[1] = {
  { &hf_xnap_CPACcandidatePSCells_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_item },
};

static int
dissect_xnap_CPACcandidatePSCells_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPACcandidatePSCells_list, CPACcandidatePSCells_list_sequence_of,
                                                  1, maxnoofPSCellCandidates, false);

  return offset;
}


static const per_sequence_t CPACcandidatePSCells_wotherInfo_item_sequence[] = {
  { &hf_xnap_pscell_id      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_s_CPAC_CompleteConfig_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CompleteConfig_Indicator },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACcandidatePSCells_wotherInfo_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACcandidatePSCells_wotherInfo_item, CPACcandidatePSCells_wotherInfo_item_sequence);

  return offset;
}


static const per_sequence_t CPACcandidatePSCells_wotherInfo_list_sequence_of[1] = {
  { &hf_xnap_CPACcandidatePSCells_wotherInfo_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_wotherInfo_item },
};

static int
dissect_xnap_CPACcandidatePSCells_wotherInfo_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPACcandidatePSCells_wotherInfo_list, CPACcandidatePSCells_wotherInfo_list_sequence_of,
                                                  1, maxnoofPSCellCandidates, false);

  return offset;
}


static const per_sequence_t CPACExecutionCondition_Item_sequence[] = {
  { &hf_xnap_measObjectContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasObjectContainer },
  { &hf_xnap_reportConfigContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportConfigContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACExecutionCondition_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACExecutionCondition_Item, CPACExecutionCondition_Item_sequence);

  return offset;
}


static const per_sequence_t CPACExecutionCondition_List_sequence_of[1] = {
  { &hf_xnap_CPACExecutionCondition_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPACExecutionCondition_Item },
};

static int
dissect_xnap_CPACExecutionCondition_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPACExecutionCondition_List, CPACExecutionCondition_List_sequence_of,
                                                  1, maxnoofCPACexecutioncond, false);

  return offset;
}


static const per_sequence_t CPACCandidateCell_Item_sequence[] = {
  { &hf_xnap_cpacCandidateCellID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_cpacExecutionCondition_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACExecutionCondition_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACCandidateCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACCandidateCell_Item, CPACCandidateCell_Item_sequence);

  return offset;
}


static const per_sequence_t CPACCandidateCell_List_sequence_of[1] = {
  { &hf_xnap_CPACCandidateCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPACCandidateCell_Item },
};

static int
dissect_xnap_CPACCandidateCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPACCandidateCell_List, CPACCandidateCell_List_sequence_of,
                                                  1, maxnoofPSCellsinCPAC, false);

  return offset;
}


static const per_sequence_t CPACConfiguration_sequence[] = {
  { &hf_xnap_cpacCandidateCell_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACCandidateCell_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACConfiguration, CPACConfiguration_sequence);

  return offset;
}


static const value_string xnap_CPCindicator_vals[] = {
  {   0, "cpc-initiation" },
  {   1, "cpc-modification" },
  {   2, "cpc-cancellation" },
  { 0, NULL }
};


static int
dissect_xnap_CPCindicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_maxnoofPSCellCandidates_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofPSCellCandidates, NULL, true);

  return offset;
}


static const per_sequence_t CPAInformationRequest_sequence[] = {
  { &hf_xnap_max_no_of_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofPSCellCandidates_ },
  { &hf_xnap_cpac_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationRequest, CPAInformationRequest_sequence);

  return offset;
}


static const per_sequence_t CPAInformationAck_sequence[] = {
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationAck, CPAInformationAck_sequence);

  return offset;
}



static int
dissect_xnap_T_sN_to_MN_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree;

    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_container);
    dissect_nr_rrc_CG_ConfigInfo_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CPC_target_SN_required_list_Item_sequence[] = {
  { &hf_xnap_target_S_NG_RANnodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_cpc_indicator  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPCindicator },
  { &hf_xnap_max_no_of_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofPSCellCandidates_ },
  { &hf_xnap_cpac_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_sN_to_MN_Container, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_sN_to_MN_Container },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPC_target_SN_required_list_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPC_target_SN_required_list_Item, CPC_target_SN_required_list_Item_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_required_list_sequence_of[1] = {
  { &hf_xnap_CPC_target_SN_required_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_required_list_Item },
};

static int
dissect_xnap_CPC_target_SN_required_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPC_target_SN_required_list, CPC_target_SN_required_list_sequence_of,
                                                  1, maxnoofTargetSNs, false);

  return offset;
}


static const per_sequence_t CPCInformationRequired_sequence[] = {
  { &hf_xnap_cpc_target_sn_required_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_required_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationRequired, CPCInformationRequired_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_confirm_list_Item_sequence[] = {
  { &hf_xnap_target_S_NG_RANnodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPC_target_SN_confirm_list_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPC_target_SN_confirm_list_Item, CPC_target_SN_confirm_list_Item_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_confirm_list_sequence_of[1] = {
  { &hf_xnap_CPC_target_SN_confirm_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_confirm_list_Item },
};

static int
dissect_xnap_CPC_target_SN_confirm_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPC_target_SN_confirm_list, CPC_target_SN_confirm_list_sequence_of,
                                                  1, maxnoofTargetSNs, false);

  return offset;
}


static const per_sequence_t CPCInformationConfirm_sequence[] = {
  { &hf_xnap_cpc_target_sn_confirm_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_confirm_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationConfirm, CPCInformationConfirm_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_1_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}


static const per_sequence_t CPAInformationModReq_sequence[] = {
  { &hf_xnap_max_no_of_pscells_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_8_ },
  { &hf_xnap_cpac_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationModReq, CPAInformationModReq_sequence);

  return offset;
}


static const per_sequence_t CPAInformationModReqAck_sequence[] = {
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationModReqAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationModReqAck, CPAInformationModReqAck_sequence);

  return offset;
}


static const value_string xnap_CPC_DataForwarding_Indicator_vals[] = {
  {   0, "triggered" },
  {   1, "early-data-transmission-stop" },
  {   2, "coordination-only" },
  { 0, NULL }
};


static int
dissect_xnap_CPC_DataForwarding_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 1, NULL);

  return offset;
}


static const value_string xnap_CPAC_Preparation_Type_vals[] = {
  {   0, "s-cpac" },
  { 0, NULL }
};


static int
dissect_xnap_CPAC_Preparation_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CPACInformationModRequired_sequence[] = {
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACInformationModRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACInformationModRequired, CPACInformationModRequired_sequence);

  return offset;
}


static const per_sequence_t CPCInformationUpdatePSCells_item_sequence[] = {
  { &hf_xnap_pscell_id      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationUpdatePSCells_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationUpdatePSCells_item, CPCInformationUpdatePSCells_item_sequence);

  return offset;
}


static const per_sequence_t CPCInformationUpdatePSCells_list_sequence_of[1] = {
  { &hf_xnap_CPCInformationUpdatePSCells_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPCInformationUpdatePSCells_item },
};

static int
dissect_xnap_CPCInformationUpdatePSCells_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPCInformationUpdatePSCells_list, CPCInformationUpdatePSCells_list_sequence_of,
                                                  1, maxnoofPSCellCandidates, false);

  return offset;
}


static const per_sequence_t CPC_target_SN_mod_item_sequence[] = {
  { &hf_xnap_target_S_NG_RANnodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_candidate_pscells_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPCInformationUpdatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPC_target_SN_mod_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPC_target_SN_mod_item, CPC_target_SN_mod_item_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_mod_list_sequence_of[1] = {
  { &hf_xnap_CPC_target_SN_mod_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_mod_item },
};

static int
dissect_xnap_CPC_target_SN_mod_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPC_target_SN_mod_list, CPC_target_SN_mod_list_sequence_of,
                                                  1, maxnoofTargetSNs, false);

  return offset;
}


static const per_sequence_t CPCInformationUpdate_sequence[] = {
  { &hf_xnap_cpc_target_sn_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_mod_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationUpdate, CPCInformationUpdate_sequence);

  return offset;
}


static const value_string xnap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_xnap_TypeOfError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_item_sequence[] = {
  { &hf_xnap_iECriticality  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_iE_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_ID },
  { &hf_xnap_typeOfError    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TypeOfError },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CriticalityDiagnostics_IE_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CriticalityDiagnostics_IE_List_item, CriticalityDiagnostics_IE_List_item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_xnap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CriticalityDiagnostics_IE_List_item },
};

static int
dissect_xnap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxNrOfErrors, false);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_xnap_procedureCode  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProcedureCode },
  { &hf_xnap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TriggeringMessage },
  { &hf_xnap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Criticality },
  { &hf_xnap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CriticalityDiagnostics_IE_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}



static int
dissect_xnap_C_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_CyclicPrefix_E_UTRA_DL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_xnap_CyclicPrefix_E_UTRA_DL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CyclicPrefix_E_UTRA_UL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_xnap_CyclicPrefix_E_UTRA_UL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CSI_RSTransmissionIndication_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_xnap_CSI_RSTransmissionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CAGListforMDTItem_sequence[] = {
  { &hf_xnap_plmnID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_cAGID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CAG_Identifier },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CAGListforMDTItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CAGListforMDTItem, CAGListforMDTItem_sequence);

  return offset;
}


static const per_sequence_t CAGListforMDT_sequence_of[1] = {
  { &hf_xnap_CAGListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CAGListforMDTItem },
};

static int
dissect_xnap_CAGListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CAGListforMDT, CAGListforMDT_sequence_of,
                                                  1, maxnoofCAGforMDT, false);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence[] = {
  { &hf_xnap_dRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_Xn_U_TNLInfoatM, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item, DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence_of[1] = {
  { &hf_xnap_dRBsToBeSetupList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item, SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceBearerSetupCompleteInfo_SNterminated_sequence[] = {
  { &hf_xnap_dRBsToBeSetupList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated, PDUSessionResourceBearerSetupCompleteInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t XnUAddressInfoperPDUSession_Item_sequence[] = {
  { &hf_xnap_pduSession_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_dataForwardingInfoFromTargetNGRANnode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_pduSessionResourceSetupCompleteInfo_SNterm, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_XnUAddressInfoperPDUSession_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_XnUAddressInfoperPDUSession_Item, XnUAddressInfoperPDUSession_Item_sequence);

  return offset;
}


static const per_sequence_t XnUAddressInfoperPDUSession_List_sequence_of[1] = {
  { &hf_xnap_XnUAddressInfoperPDUSession_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_XnUAddressInfoperPDUSession_Item },
};

static int
dissect_xnap_XnUAddressInfoperPDUSession_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_XnUAddressInfoperPDUSession_List, XnUAddressInfoperPDUSession_List_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t QoSFlowsToBeForwarded_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeForwarded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeForwarded_Item, QoSFlowsToBeForwarded_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeForwarded_List_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeForwarded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeForwarded_Item },
};

static int
dissect_xnap_QoSFlowsToBeForwarded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeForwarded_List, QoSFlowsToBeForwarded_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetE_UTRANnode_Item_sequence[] = {
  { &hf_xnap_dlForwardingUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_qosFlowsToBeForwarded_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeForwarded_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item, DataForwardingInfoFromTargetE_UTRANnode_Item_sequence);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetE_UTRANnode_List_sequence_of[1] = {
  { &hf_xnap_DataForwardingInfoFromTargetE_UTRANnode_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item },
};

static int
dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_List, DataForwardingInfoFromTargetE_UTRANnode_List_sequence_of,
                                                  1, maxnoofDataForwardingTunneltoE_UTRAN, false);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetE_UTRANnode_sequence[] = {
  { &hf_xnap_dataForwardingInfoFromTargetE_UTRANnode_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingInfoFromTargetE_UTRANnode, DataForwardingInfoFromTargetE_UTRANnode_sequence);

  return offset;
}


static const value_string xnap_DLForwarding_vals[] = {
  {   0, "dl-forwarding-proposed" },
  { 0, NULL }
};


static int
dissect_xnap_DLForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_ULForwarding_vals[] = {
  {   0, "ul-forwarding-proposed" },
  { 0, NULL }
};


static int
dissect_xnap_ULForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFLowsToBeForwarded_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_dl_dataforwarding, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DLForwarding },
  { &hf_xnap_ul_dataforwarding, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ULForwarding },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFLowsToBeForwarded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFLowsToBeForwarded_Item, QoSFLowsToBeForwarded_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFLowsToBeForwarded_List_sequence_of[1] = {
  { &hf_xnap_QoSFLowsToBeForwarded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsToBeForwarded_Item },
};

static int
dissect_xnap_QoSFLowsToBeForwarded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFLowsToBeForwarded_List, QoSFLowsToBeForwarded_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const value_string xnap_QoSFlowMappingIndication_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  { 0, NULL }
};


static int
dissect_xnap_QoSFlowMappingIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlow_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlow_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlow_Item, QoSFlow_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlows_List_sequence_of[1] = {
  { &hf_xnap_QoSFlows_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlow_Item },
};

static int
dissect_xnap_QoSFlows_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlows_List, QoSFlows_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const value_string xnap_RLCMode_vals[] = {
  {   0, "rlc-am" },
  {   1, "rlc-um-bidirectional" },
  {   2, "rlc-um-unidirectional-ul" },
  {   3, "rlc-um-unidirectional-dl" },
  { 0, NULL }
};


static int
dissect_xnap_RLCMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DRBToQoSFlowMapping_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_qosFlows_List  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlows_List },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLCMode },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBToQoSFlowMapping_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBToQoSFlowMapping_Item, DRBToQoSFlowMapping_Item_sequence);

  return offset;
}


static const per_sequence_t DRBToQoSFlowMapping_List_sequence_of[1] = {
  { &hf_xnap_DRBToQoSFlowMapping_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBToQoSFlowMapping_Item },
};

static int
dissect_xnap_DRBToQoSFlowMapping_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBToQoSFlowMapping_List, DRBToQoSFlowMapping_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t DataforwardingandOffloadingInfofromSource_sequence[] = {
  { &hf_xnap_qosFlowsToBeForwarded, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsToBeForwarded_List },
  { &hf_xnap_sourceDRBtoQoSFlowMapping, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBToQoSFlowMapping_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataforwardingandOffloadingInfofromSource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataforwardingandOffloadingInfofromSource, DataforwardingandOffloadingInfofromSource_sequence);

  return offset;
}



static int
dissect_xnap_DataTrafficResources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 17600, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SharedResourceType_UL_OnlySharing_sequence[] = {
  { &hf_xnap_ul_resourceBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataTrafficResources },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_UL_OnlySharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SharedResourceType_UL_OnlySharing, SharedResourceType_UL_OnlySharing_sequence);

  return offset;
}


static const per_sequence_t SharedResourceType_ULDL_Sharing_UL_ResourcesChanged_sequence[] = {
  { &hf_xnap_ul_resourceBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataTrafficResources },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged, SharedResourceType_ULDL_Sharing_UL_ResourcesChanged_sequence);

  return offset;
}


static const value_string xnap_SharedResourceType_ULDL_Sharing_UL_Resources_vals[] = {
  {   0, "unchanged" },
  {   1, "changed" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_ULDL_Sharing_UL_Resources_choice[] = {
  {   0, &hf_xnap_unchanged      , ASN1_NO_EXTENSIONS     , dissect_xnap_NULL },
  {   1, &hf_xnap_changed        , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_UL_Resources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType_ULDL_Sharing_UL_Resources, SharedResourceType_ULDL_Sharing_UL_Resources_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SharedResourceType_ULDL_Sharing_DL_ResourcesChanged_sequence[] = {
  { &hf_xnap_dl_resourceBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataTrafficResources },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged, SharedResourceType_ULDL_Sharing_DL_ResourcesChanged_sequence);

  return offset;
}


static const value_string xnap_SharedResourceType_ULDL_Sharing_DL_Resources_vals[] = {
  {   0, "unchanged" },
  {   1, "changed" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_ULDL_Sharing_DL_Resources_choice[] = {
  {   0, &hf_xnap_unchanged      , ASN1_NO_EXTENSIONS     , dissect_xnap_NULL },
  {   1, &hf_xnap_changed_01     , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_DL_Resources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType_ULDL_Sharing_DL_Resources, SharedResourceType_ULDL_Sharing_DL_Resources_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_SharedResourceType_ULDL_Sharing_vals[] = {
  {   0, "ul-resources" },
  {   1, "dl-resources" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_ULDL_Sharing_choice[] = {
  {   0, &hf_xnap_ul_resources   , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_UL_Resources },
  {   1, &hf_xnap_dl_resources   , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_DL_Resources },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType_ULDL_Sharing, SharedResourceType_ULDL_Sharing_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_SharedResourceType_vals[] = {
  {   0, "ul-onlySharing" },
  {   1, "ul-and-dl-Sharing" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_choice[] = {
  {   0, &hf_xnap_ul_onlySharing , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_UL_OnlySharing },
  {   1, &hf_xnap_ul_and_dl_Sharing, ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType, SharedResourceType_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_T_subframeType_vals[] = {
  {   0, "mbsfn" },
  {   1, "non-mbsfn" },
  { 0, NULL }
};


static int
dissect_xnap_T_subframeType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_10_160(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 160, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_MBSFNControlRegionLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}


static const per_sequence_t ReservedSubframePattern_sequence[] = {
  { &hf_xnap_subframeType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_subframeType },
  { &hf_xnap_reservedSubframePattern_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_10_160 },
  { &hf_xnap_mbsfnControlRegionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBSFNControlRegionLength },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ReservedSubframePattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ReservedSubframePattern, ReservedSubframePattern_sequence);

  return offset;
}


static const per_sequence_t DataTrafficResourceIndication_sequence[] = {
  { &hf_xnap_activationSFN  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ActivationSFN },
  { &hf_xnap_sharedResourceType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SharedResourceType },
  { &hf_xnap_reservedSubframePattern, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ReservedSubframePattern },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataTrafficResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataTrafficResourceIndication, DataTrafficResourceIndication_sequence);

  return offset;
}


static const value_string xnap_T_dapsIndicator_vals[] = {
  {   0, "daps-HO-required" },
  { 0, NULL }
};


static int
dissect_xnap_T_dapsIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSRequestInfo_sequence[] = {
  { &hf_xnap_dapsIndicator  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_dapsIndicator },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DAPSRequestInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DAPSRequestInfo, DAPSRequestInfo_sequence);

  return offset;
}


static const value_string xnap_T_dapsResponseIndicator_vals[] = {
  {   0, "daps-HO-accepted" },
  {   1, "daps-HO-not-accepted" },
  { 0, NULL }
};


static int
dissect_xnap_T_dapsResponseIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSResponseInfo_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dapsResponseIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_dapsResponseIndicator },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DAPSResponseInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DAPSResponseInfo_Item, DAPSResponseInfo_Item_sequence);

  return offset;
}


static const per_sequence_t DAPSResponseInfo_List_sequence_of[1] = {
  { &hf_xnap_DAPSResponseInfo_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DAPSResponseInfo_Item },
};

static int
dissect_xnap_DAPSResponseInfo_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DAPSResponseInfo_List, DAPSResponseInfo_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}



static int
dissect_xnap_DeliveryStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}


static const value_string xnap_DesiredActNotificationLevel_vals[] = {
  {   0, "none" },
  {   1, "qos-flow" },
  {   2, "pdu-session" },
  {   3, "ue-level" },
  { 0, NULL }
};


static int
dissect_xnap_DesiredActNotificationLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DefaultDRB_Allowed_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_DefaultDRB_Allowed(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DirectForwardingPathAvailability_vals[] = {
  {   0, "direct-path-available" },
  { 0, NULL }
};


static int
dissect_xnap_DirectForwardingPathAvailability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DirectForwardingPathAvailabilityWithSourceMN_vals[] = {
  {   0, "direct-path-available" },
  { 0, NULL }
};


static int
dissect_xnap_DirectForwardingPathAvailabilityWithSourceMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DLCountChoice_vals[] = {
  {   0, "count12bits" },
  {   1, "count18bits" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DLCountChoice_choice[] = {
  {   0, &hf_xnap_count12bits    , ASN1_NO_EXTENSIONS     , dissect_xnap_COUNT_PDCP_SN12 },
  {   1, &hf_xnap_count18bits    , ASN1_NO_EXTENSIONS     , dissect_xnap_COUNT_PDCP_SN18 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_DLCountChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_DLCountChoice, DLCountChoice_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_DL_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_DL_non_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t DLF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_egressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_egressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DLF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DLF1Terminating_BHInfo, DLF1Terminating_BHInfo_sequence);

  return offset;
}


static const value_string xnap_DLLBTFailureInformationRequest_vals[] = {
  {   0, "inquiry" },
  { 0, NULL }
};


static int
dissect_xnap_DLLBTFailureInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_1000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1000U, NULL, true);

  return offset;
}


static const per_sequence_t DLLBTFailureInformationList_Item_sequence[] = {
  { &hf_xnap_uEAssistantIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_numberOfDLLBTFailures, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_1000_ },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DLLBTFailureInformationList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DLLBTFailureInformationList_Item, DLLBTFailureInformationList_Item_sequence);

  return offset;
}


static const per_sequence_t DLLBTFailureInformationList_sequence_of[1] = {
  { &hf_xnap_DLLBTFailureInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DLLBTFailureInformationList_Item },
};

static int
dissect_xnap_DLLBTFailureInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DLLBTFailureInformationList, DLLBTFailureInformationList_sequence_of,
                                                  1, maxnoofLBTFailureInformation, false);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t IAB_QoS_Mapping_Information_sequence[] = {
  { &hf_xnap_dscp           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_6 },
  { &hf_xnap_flow_label     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_20 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_QoS_Mapping_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_QoS_Mapping_Information, IAB_QoS_Mapping_Information_sequence);

  return offset;
}


static const per_sequence_t DLNonF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_ingressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_ingressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_priorhopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_iabqosMappingInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_QoS_Mapping_Information },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DLNonF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DLNonF1Terminating_BHInfo, DLNonF1Terminating_BHInfo_sequence);

  return offset;
}



static int
dissect_xnap_DL_Total_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t DRB_List_sequence_of[1] = {
  { &hf_xnap_DRB_List_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
};

static int
dissect_xnap_DRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRB_List, DRB_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t DRB_List_withCause_Item_sequence[] = {
  { &hf_xnap_drb_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Cause },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLCMode },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRB_List_withCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRB_List_withCause_Item, DRB_List_withCause_Item_sequence);

  return offset;
}


static const per_sequence_t DRB_List_withCause_sequence_of[1] = {
  { &hf_xnap_DRB_List_withCause_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_List_withCause_Item },
};

static int
dissect_xnap_DRB_List_withCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRB_List_withCause, DRB_List_withCause_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}



static int
dissect_xnap_DRB_Number(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, true);

  return offset;
}


static const per_sequence_t DRBsSubjectToDLDiscarding_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dlCount        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DLCountChoice },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsSubjectToDLDiscarding_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsSubjectToDLDiscarding_Item, DRBsSubjectToDLDiscarding_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToDLDiscarding_List_sequence_of[1] = {
  { &hf_xnap_DRBsSubjectToDLDiscarding_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsSubjectToDLDiscarding_Item },
};

static int
dissect_xnap_DRBsSubjectToDLDiscarding_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsSubjectToDLDiscarding_List, DRBsSubjectToDLDiscarding_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t DRBsSubjectToEarlyStatusTransfer_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dlCount        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DLCountChoice },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsSubjectToEarlyStatusTransfer_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsSubjectToEarlyStatusTransfer_Item, DRBsSubjectToEarlyStatusTransfer_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToEarlyStatusTransfer_List_sequence_of[1] = {
  { &hf_xnap_DRBsSubjectToEarlyStatusTransfer_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsSubjectToEarlyStatusTransfer_Item },
};

static int
dissect_xnap_DRBsSubjectToEarlyStatusTransfer_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsSubjectToEarlyStatusTransfer_List, DRBsSubjectToEarlyStatusTransfer_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_1_2048(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 2048, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DRBBStatusTransfer12bitsSN_sequence[] = {
  { &hf_xnap_receiveStatusofPDCPSDU, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_1_2048 },
  { &hf_xnap_cOUNTValue     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_COUNT_PDCP_SN12 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBBStatusTransfer12bitsSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBBStatusTransfer12bitsSN, DRBBStatusTransfer12bitsSN_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_1_131072(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 131072, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DRBBStatusTransfer18bitsSN_sequence[] = {
  { &hf_xnap_receiveStatusofPDCPSDU_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_1_131072 },
  { &hf_xnap_cOUNTValue_01  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_COUNT_PDCP_SN18 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBBStatusTransfer18bitsSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBBStatusTransfer18bitsSN, DRBBStatusTransfer18bitsSN_sequence);

  return offset;
}


static const value_string xnap_DRBBStatusTransferChoice_vals[] = {
  {   0, "pdcp-sn-12bits" },
  {   1, "pdcp-sn-18bits" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DRBBStatusTransferChoice_choice[] = {
  {   0, &hf_xnap_pdcp_sn_12bits , ASN1_NO_EXTENSIONS     , dissect_xnap_DRBBStatusTransfer12bitsSN },
  {   1, &hf_xnap_pdcp_sn_18bits , ASN1_NO_EXTENSIONS     , dissect_xnap_DRBBStatusTransfer18bitsSN },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_DRBBStatusTransferChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_DRBBStatusTransferChoice, DRBBStatusTransferChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRBsSubjectToStatusTransfer_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_pdcpStatusTransfer_UL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBBStatusTransferChoice },
  { &hf_xnap_pdcpStatusTransfer_DL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBBStatusTransferChoice },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsSubjectToStatusTransfer_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsSubjectToStatusTransfer_Item, DRBsSubjectToStatusTransfer_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToStatusTransfer_List_sequence_of[1] = {
  { &hf_xnap_DRBsSubjectToStatusTransfer_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsSubjectToStatusTransfer_Item },
};

static int
dissect_xnap_DRBsSubjectToStatusTransfer_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsSubjectToStatusTransfer_List, DRBsSubjectToStatusTransfer_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const value_string xnap_Permutation_vals[] = {
  {   0, "dfu" },
  {   1, "ufd" },
  { 0, NULL }
};


static int
dissect_xnap_Permutation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, false);

  return offset;
}


static const per_sequence_t ExplicitFormat_sequence[] = {
  { &hf_xnap_permutation    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Permutation },
  { &hf_xnap_noofDownlinkSymbols, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_14 },
  { &hf_xnap_noofUplinkSymbols, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_14 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExplicitFormat, ExplicitFormat_sequence);

  return offset;
}



static int
dissect_xnap_DUFSlotformatIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 254U, NULL, false);

  return offset;
}


static const per_sequence_t ImplicitFormat_sequence[] = {
  { &hf_xnap_dUFSlotformatIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DUFSlotformatIndex },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ImplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ImplicitFormat, ImplicitFormat_sequence);

  return offset;
}


static const value_string xnap_DUF_Slot_Config_Item_vals[] = {
  {   0, "explicitFormat" },
  {   1, "implicitFormat" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DUF_Slot_Config_Item_choice[] = {
  {   0, &hf_xnap_explicitFormat , ASN1_NO_EXTENSIONS     , dissect_xnap_ExplicitFormat },
  {   1, &hf_xnap_implicitFormat , ASN1_NO_EXTENSIONS     , dissect_xnap_ImplicitFormat },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_DUF_Slot_Config_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_DUF_Slot_Config_Item, DUF_Slot_Config_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DUF_Slot_Config_List_sequence_of[1] = {
  { &hf_xnap_DUF_Slot_Config_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DUF_Slot_Config_Item },
};

static int
dissect_xnap_DUF_Slot_Config_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DUF_Slot_Config_List, DUF_Slot_Config_List_sequence_of,
                                                  1, maxnoofDUFSlots, false);

  return offset;
}


static const value_string xnap_DUFTransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  { 0, NULL }
};


static int
dissect_xnap_DUFTransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DU_RX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_RX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DU_TX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_TX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DU_RX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_RX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DU_TX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_TX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_DuplicationActivation_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_xnap_DuplicationActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_EarlyMeasurement_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_EarlyMeasurement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_ECNMarkingAtRANRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_xnap_ECNMarkingAtRANRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_ECNMarkingAtUPFRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_xnap_ECNMarkingAtUPFRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_CongestionInformationRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_xnap_CongestionInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_ECNMarkingorCongestionInformationReportingRequest_vals[] = {
  {   0, "eCNMarkingAtRANRequest" },
  {   1, "eCNMarkingAtUPFRequest" },
  {   2, "congestionInformationRequest" },
  {   3, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ECNMarkingorCongestionInformationReportingRequest_choice[] = {
  {   0, &hf_xnap_eCNMarkingAtRANRequest, ASN1_NO_EXTENSIONS     , dissect_xnap_ECNMarkingAtRANRequest },
  {   1, &hf_xnap_eCNMarkingAtUPFRequest, ASN1_NO_EXTENSIONS     , dissect_xnap_ECNMarkingAtUPFRequest },
  {   2, &hf_xnap_congestionInformationRequest, ASN1_NO_EXTENSIONS     , dissect_xnap_CongestionInformationRequest },
  {   3, &hf_xnap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ECNMarkingorCongestionInformationReportingRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ECNMarkingorCongestionInformationReportingRequest, ECNMarkingorCongestionInformationReportingRequest_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_EnergyCost(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10000U, NULL, true);

  return offset;
}


static const per_sequence_t SNPNIdentity_sequence[] = {
  { &hf_xnap_plmnID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_nid            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SNPNIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SNPNIdentity, SNPNIdentity_sequence);

  return offset;
}


static const per_sequence_t EquivalentSNPNs_sequence_of[1] = {
  { &hf_xnap_EquivalentSNPNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SNPNIdentity },
};

static int
dissect_xnap_EquivalentSNPNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_EquivalentSNPNs, EquivalentSNPNs_sequence_of,
                                                  1, maxnoofESNPNs, false);

  return offset;
}



static int
dissect_xnap_E_RAB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}



static int
dissect_xnap_E_UTRAARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, false);

  return offset;
}



static int
dissect_xnap_ERedcap_Bcast_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_E_UTRAFrequencyBandIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, true);

  return offset;
}


static const per_sequence_t E_UTRAMultibandInfoList_sequence_of[1] = {
  { &hf_xnap_E_UTRAMultibandInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAFrequencyBandIndicator },
};

static int
dissect_xnap_E_UTRAMultibandInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_E_UTRAMultibandInfoList, E_UTRAMultibandInfoList_sequence_of,
                                                  1, maxnoofEUTRABands, false);

  return offset;
}


static const value_string xnap_EUTRAPaging_eDRX_Cycle_vals[] = {
  {   0, "hfhalf" },
  {   1, "hf1" },
  {   2, "hf2" },
  {   3, "hf4" },
  {   4, "hf6" },
  {   5, "hf8" },
  {   6, "hf10" },
  {   7, "hf12" },
  {   8, "hf14" },
  {   9, "hf16" },
  {  10, "hf32" },
  {  11, "hf64" },
  {  12, "hf128" },
  {  13, "hf256" },
  { 0, NULL }
};


static int
dissect_xnap_EUTRAPaging_eDRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_EUTRAPaging_Time_Window_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  { 0, NULL }
};


static int
dissect_xnap_EUTRAPaging_Time_Window(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRAPagingeDRXInformation_sequence[] = {
  { &hf_xnap_eutrapaging_eDRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EUTRAPaging_eDRX_Cycle },
  { &hf_xnap_eutrapaging_Time_Window, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_EUTRAPaging_Time_Window },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EUTRAPagingeDRXInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EUTRAPagingeDRXInformation, EUTRAPagingeDRXInformation_sequence);

  return offset;
}



static int
dissect_xnap_E_UTRAPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, true);

  return offset;
}



static int
dissect_xnap_INTEGER_0_837(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 837U, NULL, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string xnap_T_highSpeedFlag_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_highSpeedFlag(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_94(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 94U, NULL, false);

  return offset;
}


static const per_sequence_t E_UTRAPRACHConfiguration_sequence[] = {
  { &hf_xnap_rootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_837 },
  { &hf_xnap_zeroCorrelationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_15 },
  { &hf_xnap_highSpeedFlag  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_highSpeedFlag },
  { &hf_xnap_prach_FreqOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_94 },
  { &hf_xnap_prach_ConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_E_UTRAPRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_E_UTRAPRACHConfiguration, E_UTRAPRACHConfiguration_sequence);

  return offset;
}


static const value_string xnap_E_UTRATransmissionBandwidth_vals[] = {
  {   0, "bw6" },
  {   1, "bw15" },
  {   2, "bw25" },
  {   3, "bw50" },
  {   4, "bw75" },
  {   5, "bw100" },
  {   6, "bw1" },
  { 0, NULL }
};


static int
dissect_xnap_E_UTRATransmissionBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 1, NULL);

  return offset;
}



static int
dissect_xnap_PortNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     16, 16, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t EndpointIPAddressAndPort_sequence[] = {
  { &hf_xnap_endpointIPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TransportLayerAddress },
  { &hf_xnap_portNumber     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PortNumber },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EndpointIPAddressAndPort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EndpointIPAddressAndPort, EndpointIPAddressAndPort_sequence);

  return offset;
}


static const value_string xnap_T_outOfCoverage_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_outOfCoverage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_Threshold_RSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}



static int
dissect_xnap_Threshold_RSRQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const value_string xnap_MeasurementThresholdL1LoggedMDT_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MeasurementThresholdL1LoggedMDT_choice[] = {
  {   0, &hf_xnap_threshold_RSRP , ASN1_EXTENSION_ROOT    , dissect_xnap_Threshold_RSRP },
  {   1, &hf_xnap_threshold_RSRQ , ASN1_EXTENSION_ROOT    , dissect_xnap_Threshold_RSRQ },
  {   2, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MeasurementThresholdL1LoggedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MeasurementThresholdL1LoggedMDT, MeasurementThresholdL1LoggedMDT_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_Hysteresis(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, false);

  return offset;
}


static const value_string xnap_TimeToTrigger_vals[] = {
  {   0, "ms0" },
  {   1, "ms40" },
  {   2, "ms64" },
  {   3, "ms80" },
  {   4, "ms100" },
  {   5, "ms128" },
  {   6, "ms160" },
  {   7, "ms256" },
  {   8, "ms320" },
  {   9, "ms480" },
  {  10, "ms512" },
  {  11, "ms640" },
  {  12, "ms1024" },
  {  13, "ms1280" },
  {  14, "ms2560" },
  {  15, "ms5120" },
  { 0, NULL }
};


static int
dissect_xnap_TimeToTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t EventL1_sequence[] = {
  { &hf_xnap_l1Threshold    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasurementThresholdL1LoggedMDT },
  { &hf_xnap_hysteresis     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Hysteresis },
  { &hf_xnap_timeToTrigger  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TimeToTrigger },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EventL1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EventL1, EventL1_sequence);

  return offset;
}


static const value_string xnap_EventTypeTrigger_vals[] = {
  {   0, "outOfCoverage" },
  {   1, "eventL1" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t EventTypeTrigger_choice[] = {
  {   0, &hf_xnap_outOfCoverage  , ASN1_NO_EXTENSIONS     , dissect_xnap_T_outOfCoverage },
  {   1, &hf_xnap_eventL1        , ASN1_NO_EXTENSIONS     , dissect_xnap_EventL1 },
  {   2, &hf_xnap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_EventTypeTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_EventTypeTrigger, EventTypeTrigger_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LoggedEventTriggeredConfig_sequence[] = {
  { &hf_xnap_eventTypeTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EventTypeTrigger },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LoggedEventTriggeredConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LoggedEventTriggeredConfig, LoggedEventTriggeredConfig_sequence);

  return offset;
}


static const per_sequence_t EventTriggered_sequence[] = {
  { &hf_xnap_loggedEventTriggeredConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LoggedEventTriggeredConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EventTriggered(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EventTriggered, EventTriggered_sequence);

  return offset;
}


static const value_string xnap_EventType_vals[] = {
  {   0, "report-upon-change-of-serving-cell" },
  {   1, "report-UE-moving-presence-into-or-out-of-the-Area-of-Interest" },
  {   2, "report-upon-change-of-serving-cell-and-Area-of-Interest" },
  { 0, NULL }
};


static int
dissect_xnap_EventType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 1, NULL);

  return offset;
}


static const value_string xnap_ExcessPacketDelayThresholdValue_vals[] = {
  {   0, "ms0dot25" },
  {   1, "ms0dot5" },
  {   2, "ms1" },
  {   3, "ms2" },
  {   4, "ms4" },
  {   5, "ms5" },
  {   6, "ms10" },
  {   7, "ms20" },
  {   8, "ms30" },
  {   9, "ms40" },
  {  10, "ms50" },
  {  11, "ms60" },
  {  12, "ms70" },
  {  13, "ms80" },
  {  14, "ms90" },
  {  15, "ms100" },
  {  16, "ms150" },
  {  17, "ms300" },
  {  18, "ms500" },
  { 0, NULL }
};


static int
dissect_xnap_ExcessPacketDelayThresholdValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     19, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ExcessPacketDelayThresholdItem_sequence[] = {
  { &hf_xnap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_excessPacketDelayThresholdValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ExcessPacketDelayThresholdValue },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExcessPacketDelayThresholdItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExcessPacketDelayThresholdItem, ExcessPacketDelayThresholdItem_sequence);

  return offset;
}


static const per_sequence_t ExcessPacketDelayThresholdConfiguration_sequence_of[1] = {
  { &hf_xnap_ExcessPacketDelayThresholdConfiguration_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ExcessPacketDelayThresholdItem },
};

static int
dissect_xnap_ExcessPacketDelayThresholdConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExcessPacketDelayThresholdConfiguration, ExcessPacketDelayThresholdConfiguration_sequence_of,
                                                  1, maxnoofThresholdsForExcessPacketDelay, false);

  return offset;
}



static int
dissect_xnap_ExpectedActivityPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, true);

  return offset;
}


static const value_string xnap_ExpectedHOInterval_vals[] = {
  {   0, "sec15" },
  {   1, "sec30" },
  {   2, "sec60" },
  {   3, "sec90" },
  {   4, "sec120" },
  {   5, "sec180" },
  {   6, "long-time" },
  { 0, NULL }
};


static int
dissect_xnap_ExpectedHOInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_ExpectedIdlePeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, true);

  return offset;
}


static const value_string xnap_SourceOfUEActivityBehaviourInformation_vals[] = {
  {   0, "subscription-information" },
  {   1, "statistics" },
  { 0, NULL }
};


static int
dissect_xnap_SourceOfUEActivityBehaviourInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEActivityBehaviour_sequence[] = {
  { &hf_xnap_expectedActivityPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedActivityPeriod },
  { &hf_xnap_expectedIdlePeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedIdlePeriod },
  { &hf_xnap_sourceOfUEActivityBehaviourInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SourceOfUEActivityBehaviourInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExpectedUEActivityBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExpectedUEActivityBehaviour, ExpectedUEActivityBehaviour_sequence);

  return offset;
}


static const value_string xnap_ExpectedUEMobility_vals[] = {
  {   0, "stationary" },
  {   1, "mobile" },
  { 0, NULL }
};


static int
dissect_xnap_ExpectedUEMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEMovingTrajectoryItem_sequence[] = {
  { &hf_xnap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_timeStayedInCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_4095 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExpectedUEMovingTrajectoryItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExpectedUEMovingTrajectoryItem, ExpectedUEMovingTrajectoryItem_sequence);

  return offset;
}


static const per_sequence_t ExpectedUEMovingTrajectory_sequence_of[1] = {
  { &hf_xnap_ExpectedUEMovingTrajectory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ExpectedUEMovingTrajectoryItem },
};

static int
dissect_xnap_ExpectedUEMovingTrajectory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExpectedUEMovingTrajectory, ExpectedUEMovingTrajectory_sequence_of,
                                                  1, maxnoofCellsUEMovingTrajectory, false);

  return offset;
}


static const per_sequence_t ExpectedUEBehaviour_sequence[] = {
  { &hf_xnap_expectedUEActivityBehaviour, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedUEActivityBehaviour },
  { &hf_xnap_expectedHOInterval, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedHOInterval },
  { &hf_xnap_expectedUEMobility, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedUEMobility },
  { &hf_xnap_expectedUEMovingTrajectory, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedUEMovingTrajectory },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExpectedUEBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExpectedUEBehaviour, ExpectedUEBehaviour_sequence);

  return offset;
}



static int
dissect_xnap_T_primaryRATRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_xnap_primaryRATRestriction_e_UTRA,
      &hf_xnap_primaryRATRestriction_nR,
      &hf_xnap_primaryRATRestriction_nR_unlicensed,
      &hf_xnap_primaryRATRestriction_nR_LEO,
      &hf_xnap_primaryRATRestriction_nR_MEO,
      &hf_xnap_primaryRATRestriction_nR_GEO,
      &hf_xnap_primaryRATRestriction_nR_OTHERSAT,
      &hf_xnap_primaryRATRestriction_e_UTRA_LEO,
      NULL
    };
    static int * const fields2[] = {
      &hf_xnap_primaryRATRestriction_e_UTRA_MEO,
      &hf_xnap_primaryRATRestriction_e_UTRA_GEO,
      &hf_xnap_primaryRATRestriction_e_UTRA_OTHERSAT,
      &hf_xnap_primaryRATRestriction_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_primaryRATRestriction);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
    if (tvb_reported_length(parameter_tvb) >= 2)
      proto_tree_add_bitmask_list(subtree, parameter_tvb, 1, 1, fields2, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_xnap_T_secondaryRATRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_xnap_secondaryRATRestriction_e_UTRA,
      &hf_xnap_secondaryRATRestriction_nR,
      &hf_xnap_secondaryRATRestriction_e_UTRA_unlicensed,
      &hf_xnap_secondaryRATRestriction_nR_unlicensed,
      &hf_xnap_secondaryRATRestriction_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_secondaryRATRestriction);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t ExtendedRATRestrictionInformation_sequence[] = {
  { &hf_xnap_primaryRATRestriction, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_primaryRATRestriction },
  { &hf_xnap_secondaryRATRestriction, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_secondaryRATRestriction },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExtendedRATRestrictionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExtendedRATRestrictionInformation, ExtendedRATRestrictionInformation_sequence);

  return offset;
}



static int
dissect_xnap_ExtendedPacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, true);

  return offset;
}


static const per_sequence_t ExtendedSliceSupportList_sequence_of[1] = {
  { &hf_xnap_ExtendedSliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
};

static int
dissect_xnap_ExtendedSliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExtendedSliceSupportList, ExtendedSliceSupportList_sequence_of,
                                                  1, maxnoofExtSliceItems, false);

  return offset;
}



static int
dissect_xnap_ExtendedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GTPTLA_Item_sequence[] = {
  { &hf_xnap_gTPTransportLayerAddresses_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TransportLayerAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GTPTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GTPTLA_Item, GTPTLA_Item_sequence);

  return offset;
}


static const per_sequence_t GTPTLAs_sequence_of[1] = {
  { &hf_xnap_GTPTLAs_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GTPTLA_Item },
};

static int
dissect_xnap_GTPTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_GTPTLAs, GTPTLAs_sequence_of,
                                                  1, maxnoofGTPTLAs, false);

  return offset;
}


static const per_sequence_t ExtTLA_Item_sequence[] = {
  { &hf_xnap_iPsecTLA       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TransportLayerAddress },
  { &hf_xnap_gTPTransportLayerAddresses, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GTPTLAs },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExtTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExtTLA_Item, ExtTLA_Item_sequence);

  return offset;
}


static const per_sequence_t ExtTLAs_sequence_of[1] = {
  { &hf_xnap_ExtTLAs_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ExtTLA_Item },
};

static int
dissect_xnap_ExtTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExtTLAs, ExtTLAs_sequence_of,
                                                  1, maxnoofExtTLAs, false);

  return offset;
}



static int
dissect_xnap_F1CTrafficContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const value_string xnap_F1_terminatingIAB_donorIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_F1_terminatingIAB_donorIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_T_iPv4Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     32, 32, false, NULL, 0, &parameter_tvb, NULL);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);


  return offset;
}



static int
dissect_xnap_T_iPv6Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     128, 128, false, NULL, 0, &parameter_tvb, NULL);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 16, ENC_BIG_ENDIAN);


  return offset;
}



static int
dissect_xnap_T_iPv6Prefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     64, 64, false, NULL, 0, &parameter_tvb, NULL);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 8, ENC_NA);


  return offset;
}


static const value_string xnap_IABTNLAddress_vals[] = {
  {   0, "iPv4Address" },
  {   1, "iPv6Address" },
  {   2, "iPv6Prefix" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABTNLAddress_choice[] = {
  {   0, &hf_xnap_iPv4Address    , ASN1_NO_EXTENSIONS     , dissect_xnap_T_iPv4Address },
  {   1, &hf_xnap_iPv6Address_01 , ASN1_NO_EXTENSIONS     , dissect_xnap_T_iPv6Address },
  {   2, &hf_xnap_iPv6Prefix_01  , ASN1_NO_EXTENSIONS     , dissect_xnap_T_iPv6Prefix },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_IABTNLAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_IABTNLAddress, IABTNLAddress_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ULF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_ingressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_ingressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ULF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ULF1Terminating_BHInfo, ULF1Terminating_BHInfo_sequence);

  return offset;
}


static const per_sequence_t F1TerminatingBHInformation_Item_sequence[] = {
  { &hf_xnap_bHInfoIndex    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfoIndex },
  { &hf_xnap_dLTNLAddress   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_dlF1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DLF1Terminating_BHInfo },
  { &hf_xnap_ulF1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULF1Terminating_BHInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_F1TerminatingBHInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_F1TerminatingBHInformation_Item, F1TerminatingBHInformation_Item_sequence);

  return offset;
}


static const per_sequence_t F1TerminatingBHInformation_List_sequence_of[1] = {
  { &hf_xnap_F1TerminatingBHInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_F1TerminatingBHInformation_Item },
};

static int
dissect_xnap_F1TerminatingBHInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_F1TerminatingBHInformation_List, F1TerminatingBHInformation_List_sequence_of,
                                                  1, maxnoofBHInfo, false);

  return offset;
}


static const per_sequence_t F1_TerminatingTopologyBHInformation_sequence[] = {
  { &hf_xnap_f1TerminatingBHInformation_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_F1TerminatingBHInformation_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_F1_TerminatingTopologyBHInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_F1_TerminatingTopologyBHInformation, F1_TerminatingTopologyBHInformation_sequence);

  return offset;
}



static int
dissect_xnap_FiveGCMobilityRestrictionListContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_FiveGCMobilityRestrictionListContainer);
    dissect_ngap_MobilityRestrictionList_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string xnap_FiveGProSeDirectDiscovery_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeDirectDiscovery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeDirectCommunication_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeDirectCommunication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer2UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer2UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer3UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer3UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer2RemoteUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer2RemoteUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t FiveGProSeAuthorized_sequence[] = {
  { &hf_xnap_fiveGproSeDirectDiscovery, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeDirectDiscovery },
  { &hf_xnap_fiveGproSeDirectCommunication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeDirectCommunication },
  { &hf_xnap_fiveGnrProSeLayer2UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeLayer2UEtoNetworkRelay },
  { &hf_xnap_fiveGnrProSeLayer3UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeLayer3UEtoNetworkRelay },
  { &hf_xnap_fiveGnrProSeLayer2RemoteUE, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeLayer2RemoteUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSeAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSeAuthorized, FiveGProSeAuthorized_sequence);

  return offset;
}


static const value_string xnap_FiveGProSeLayer2Multipath_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer2Multipath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer2UEtoUERelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer2UEtoUERelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer2UEtoUERemote_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer2UEtoUERemote(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t FiveGProSePC5FlowBitRates_sequence[] = {
  { &hf_xnap_fiveGproSeguaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_fiveGproSemaximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSePC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSePC5FlowBitRates, FiveGProSePC5FlowBitRates_sequence);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSFlowItem_sequence[] = {
  { &hf_xnap_fiveGproSepQI  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_fiveGproSepc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSePC5FlowBitRates },
  { &hf_xnap_fiveGproSerange, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Range },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSePC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSePC5QoSFlowItem, FiveGProSePC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSFlowList_sequence_of[1] = {
  { &hf_xnap_FiveGProSePC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_FiveGProSePC5QoSFlowItem },
};

static int
dissect_xnap_FiveGProSePC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_FiveGProSePC5QoSFlowList, FiveGProSePC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, false);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSParameters_sequence[] = {
  { &hf_xnap_fiveGProSepc5QoSFlowList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveGProSePC5QoSFlowList },
  { &hf_xnap_fiveGproSepc5LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSePC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSePC5QoSParameters, FiveGProSePC5QoSParameters_sequence);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qoSFlowLevelQoSParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_qoSFlowMappingIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Flows_Mapped_To_DRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Flows_Mapped_To_DRB_Item, Flows_Mapped_To_DRB_Item_sequence);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_List_sequence_of[1] = {
  { &hf_xnap_Flows_Mapped_To_DRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Flows_Mapped_To_DRB_Item },
};

static int
dissect_xnap_Flows_Mapped_To_DRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Flows_Mapped_To_DRB_List, Flows_Mapped_To_DRB_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}



static int
dissect_xnap_INTEGER_0_maxnoofRBsetsPerCell1_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofRBsetsPerCell1, NULL, true);

  return offset;
}



static int
dissect_xnap_INTEGER_1_maxnoofHSNASlots(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofHSNASlots, NULL, false);

  return offset;
}


static const value_string xnap_HSNADownlink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_xnap_HSNADownlink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string xnap_HSNAUplink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_xnap_HSNAUplink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string xnap_HSNAFlexible_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_xnap_HSNAFlexible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t FreqDomainSlotHSNAconfiguration_List_Item_sequence[] = {
  { &hf_xnap_slotIndex      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofHSNASlots },
  { &hf_xnap_hSNADownlink   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNADownlink },
  { &hf_xnap_hSNAUplink     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAUplink },
  { &hf_xnap_hSNAFlexible   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAFlexible },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FreqDomainSlotHSNAconfiguration_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FreqDomainSlotHSNAconfiguration_List_Item, FreqDomainSlotHSNAconfiguration_List_Item_sequence);

  return offset;
}


static const per_sequence_t FreqDomainSlotHSNAconfiguration_List_sequence_of[1] = {
  { &hf_xnap_FreqDomainSlotHSNAconfiguration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_FreqDomainSlotHSNAconfiguration_List_Item },
};

static int
dissect_xnap_FreqDomainSlotHSNAconfiguration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_FreqDomainSlotHSNAconfiguration_List, FreqDomainSlotHSNAconfiguration_List_sequence_of,
                                                  1, maxnoofHSNASlots, false);

  return offset;
}


static const per_sequence_t FreqDomainHSNAconfiguration_List_Item_sequence[] = {
  { &hf_xnap_rBsetIndex     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_maxnoofRBsetsPerCell1_ },
  { &hf_xnap_freqDomainSlotHSNAconfiguration_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FreqDomainSlotHSNAconfiguration_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FreqDomainHSNAconfiguration_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FreqDomainHSNAconfiguration_List_Item, FreqDomainHSNAconfiguration_List_Item_sequence);

  return offset;
}


static const per_sequence_t FreqDomainHSNAconfiguration_List_sequence_of[1] = {
  { &hf_xnap_FreqDomainHSNAconfiguration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_FreqDomainHSNAconfiguration_List_Item },
};

static int
dissect_xnap_FreqDomainHSNAconfiguration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_FreqDomainHSNAconfiguration_List, FreqDomainHSNAconfiguration_List_sequence_of,
                                                  1, maxnoofHSNASlots, false);

  return offset;
}


static const value_string xnap_FrequencyShift7p5khz_vals[] = {
  {   0, "false" },
  {   1, "true" },
  { 0, NULL }
};


static int
dissect_xnap_FrequencyShift7p5khz(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_SSB_subcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz120" },
  {   3, "kHz240" },
  {   4, "spare3" },
  {   5, "spare2" },
  {   6, "spare1" },
  { 0, NULL }
};


static int
dissect_xnap_SSB_subcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_HSNATransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  {   8, "ms20" },
  {   9, "ms40" },
  {  10, "ms80" },
  {  11, "ms160" },
  { 0, NULL }
};


static int
dissect_xnap_HSNATransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t HSNASlotConfigItem_sequence[] = {
  { &hf_xnap_hSNADownlink   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNADownlink },
  { &hf_xnap_hSNAUplink     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAUplink },
  { &hf_xnap_hSNAFlexible   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAFlexible },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_HSNASlotConfigItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_HSNASlotConfigItem, HSNASlotConfigItem_sequence);

  return offset;
}


static const per_sequence_t HSNASlotConfigList_sequence_of[1] = {
  { &hf_xnap_HSNASlotConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_HSNASlotConfigItem },
};

static int
dissect_xnap_HSNASlotConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_HSNASlotConfigList, HSNASlotConfigList_sequence_of,
                                                  1, maxnoofHSNASlots, false);

  return offset;
}


static const value_string xnap_T_rBsetSize_vals[] = {
  {   0, "rb2" },
  {   1, "rb4" },
  {   2, "rb8" },
  {   3, "rb16" },
  {   4, "rb32" },
  {   5, "rb64" },
  { 0, NULL }
};


static int
dissect_xnap_T_rBsetSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_maxnoofRBsetsPerCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofRBsetsPerCell, NULL, false);

  return offset;
}


static const per_sequence_t RBsetConfiguration_sequence[] = {
  { &hf_xnap_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_subcarrierSpacing },
  { &hf_xnap_rBsetSize      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rBsetSize },
  { &hf_xnap_numberofRBSets , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofRBsetsPerCell },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RBsetConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RBsetConfiguration, RBsetConfiguration_sequence);

  return offset;
}


static const value_string xnap_T_nAdownlink_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_nAdownlink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_nAuplink_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_nAuplink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_nAflexible_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_nAflexible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NACellResourceConfiguration_Item_sequence[] = {
  { &hf_xnap_nAdownlink     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nAdownlink },
  { &hf_xnap_nAuplink       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nAuplink },
  { &hf_xnap_nAflexible     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nAflexible },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NACellResourceConfiguration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NACellResourceConfiguration_Item, NACellResourceConfiguration_Item_sequence);

  return offset;
}


static const per_sequence_t NACellResourceConfigurationList_sequence_of[1] = {
  { &hf_xnap_NACellResourceConfigurationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NACellResourceConfiguration_Item },
};

static int
dissect_xnap_NACellResourceConfigurationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NACellResourceConfigurationList, NACellResourceConfigurationList_sequence_of,
                                                  1, maxnoofHSNASlots, false);

  return offset;
}


static const per_sequence_t GNB_DU_Cell_Resource_Configuration_sequence[] = {
  { &hf_xnap_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_subcarrierSpacing },
  { &hf_xnap_dUFTransmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DUFTransmissionPeriodicity },
  { &hf_xnap_dUF_Slot_Config_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DUF_Slot_Config_List },
  { &hf_xnap_hSNATransmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_HSNATransmissionPeriodicity },
  { &hf_xnap_hNSASlotConfigList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNASlotConfigList },
  { &hf_xnap_rBsetConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RBsetConfiguration },
  { &hf_xnap_freqDomainHSNAconfiguration_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FreqDomainHSNAconfiguration_List },
  { &hf_xnap_nACellResourceConfigurationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NACellResourceConfigurationList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GNB_DU_Cell_Resource_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GNB_DU_Cell_Resource_Configuration, GNB_DU_Cell_Resource_Configuration_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GUAMI_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_amf_region_id  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_8 },
  { &hf_xnap_amf_set_id     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_10 },
  { &hf_xnap_amf_pointer    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GUAMI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_GUAMI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GUAMI, GUAMI_sequence);



  return offset;
}


static const value_string xnap_HandoverReportType_vals[] = {
  {   0, "hoTooEarly" },
  {   1, "hoToWrongCell" },
  {   2, "intersystempingpong" },
  { 0, NULL }
};


static int
dissect_xnap_HandoverReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_HashedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     13, 13, true, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_2199_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, true);

  return offset;
}



static int
dissect_xnap_INTEGER_0_maxnoofPhysicalResourceBlocks_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofPhysicalResourceBlocks, NULL, true);

  return offset;
}


static const per_sequence_t NRCarrierItem_sequence[] = {
  { &hf_xnap_carrierSCS     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRSCS },
  { &hf_xnap_offsetToCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_2199_ },
  { &hf_xnap_carrierBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_maxnoofPhysicalResourceBlocks_ },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRCarrierItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRCarrierItem, NRCarrierItem_sequence);

  return offset;
}


static const per_sequence_t NRCarrierList_sequence_of[1] = {
  { &hf_xnap_NRCarrierList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NRCarrierItem },
};

static int
dissect_xnap_NRCarrierList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NRCarrierList, NRCarrierList_sequence_of,
                                                  1, maxnoofNRSCSs, false);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence[] = {
  { &hf_xnap_gNB_DU_Cell_Resource_Configuration_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_DU_Cell_Resource_Configuration },
  { &hf_xnap_frequencyInfo  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_transmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_carrierList    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRCarrierList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info, IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence[] = {
  { &hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_UL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_DU_Cell_Resource_Configuration },
  { &hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_DL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_DU_Cell_Resource_Configuration },
  { &hf_xnap_uLFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_dLFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_uLTransmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_dlTransmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_uLCarrierList  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRCarrierList },
  { &hf_xnap_dlCarrierList  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRCarrierList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info, IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence);

  return offset;
}


static const value_string xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info_vals[] = {
  {   0, "tDD" },
  {   1, "fDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IAB_DU_Cell_Resource_Configuration_Mode_Info_choice[] = {
  {   0, &hf_xnap_tDD            , ASN1_NO_EXTENSIONS     , dissect_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info },
  {   1, &hf_xnap_fDD            , ASN1_NO_EXTENSIONS     , dissect_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info, IAB_DU_Cell_Resource_Configuration_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_SSB_freqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, false);

  return offset;
}


static const value_string xnap_SSB_transmissionPeriodicity_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf40" },
  {   3, "sf80" },
  {   4, "sf160" },
  {   5, "sf320" },
  {   6, "sf640" },
  { 0, NULL }
};


static int
dissect_xnap_SSB_transmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_SSB_transmissionTimingOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, true);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_SSB_transmissionBitmap_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_transmissionBitmap_choice[] = {
  {   0, &hf_xnap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_4 },
  {   1, &hf_xnap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_8 },
  {   2, &hf_xnap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_64 },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SSB_transmissionBitmap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SSB_transmissionBitmap, SSB_transmissionBitmap_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IAB_STC_Info_Item_sequence[] = {
  { &hf_xnap_sSB_freqInfo   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_freqInfo },
  { &hf_xnap_sSB_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_subcarrierSpacing },
  { &hf_xnap_sSB_transmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_transmissionPeriodicity },
  { &hf_xnap_sSB_transmissionTimingOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_transmissionTimingOffset },
  { &hf_xnap_sSB_transmissionBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_transmissionBitmap },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_STC_Info_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_STC_Info_Item, IAB_STC_Info_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_STC_Info_List_sequence_of[1] = {
  { &hf_xnap_IAB_STC_Info_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_STC_Info_Item },
};

static int
dissect_xnap_IAB_STC_Info_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IAB_STC_Info_List, IAB_STC_Info_List_sequence_of,
                                                  1, maxnoofIABSTCInfo, false);

  return offset;
}


static const per_sequence_t IAB_STC_Info_sequence[] = {
  { &hf_xnap_iAB_STC_Info_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_STC_Info_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_STC_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_STC_Info, IAB_STC_Info_sequence);

  return offset;
}



static int
dissect_xnap_RACH_Config_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RACH_Config_Common);
    dissect_nr_rrc_RACH_ConfigCommon_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_RACH_Config_Common_IAB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RACH_Config_Common_IAB);
    dissect_nr_rrc_rach_ConfigCommonIAB_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_cSI_RS_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_cSI_RS_Configuration);
    dissect_nr_rrc_NZP_CSI_RS_Resource_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_sR_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_sR_Configuration);
    dissect_nr_rrc_SchedulingRequestResourceConfig_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_pDCCH_ConfigSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_pDCCH_ConfigSIB1);
    dissect_nr_rrc_PDCCH_ConfigSIB1_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_sCS_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_sCS_Common);
    dissect_nr_rrc_subCarrierSpacingCommon_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_Item_sequence[] = {
  { &hf_xnap_nRCellIdentity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_Cell_Identity },
  { &hf_xnap_dU_RX_MT_RX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_RX_MT_RX },
  { &hf_xnap_dU_TX_MT_TX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_TX_MT_TX },
  { &hf_xnap_dU_RX_MT_TX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_RX_MT_TX },
  { &hf_xnap_dU_TX_MT_RX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_TX_MT_RX },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_MT_Cell_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_MT_Cell_List_Item, IAB_MT_Cell_List_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_sequence_of[1] = {
  { &hf_xnap_IAB_MT_Cell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_MT_Cell_List_Item },
};

static int
dissect_xnap_IAB_MT_Cell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IAB_MT_Cell_List, IAB_MT_Cell_List_sequence_of,
                                                  1, maxnoofServingCells, false);

  return offset;
}


static const per_sequence_t MultiplexingInfo_sequence[] = {
  { &hf_xnap_iAB_MT_Cell_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_MT_Cell_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MultiplexingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MultiplexingInfo, MultiplexingInfo_sequence);

  return offset;
}


static const per_sequence_t IABCellInformation_sequence[] = {
  { &hf_xnap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_iAB_DU_Cell_Resource_Configuration_Mode_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info },
  { &hf_xnap_iAB_STC_Info   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_IAB_STC_Info },
  { &hf_xnap_rACH_Config_Common, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RACH_Config_Common },
  { &hf_xnap_rACH_Config_Common_IAB, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RACH_Config_Common_IAB },
  { &hf_xnap_cSI_RS_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_cSI_RS_Configuration },
  { &hf_xnap_sR_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_sR_Configuration },
  { &hf_xnap_pDCCH_ConfigSIB1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_pDCCH_ConfigSIB1 },
  { &hf_xnap_sCS_Common     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_sCS_Common },
  { &hf_xnap_multiplexingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MultiplexingInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABCellInformation, IABCellInformation_sequence);

  return offset;
}


static const value_string xnap_IABNodeIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_IABNodeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, false);

  return offset;
}


static const per_sequence_t IABTNLAddressesRequested_sequence[] = {
  { &hf_xnap_tNLAddressesOrPrefixesRequestedAllTraffic, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_tNLAddressesOrPrefixesRequestedF1_C, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_tNLAddressesOrPrefixesRequestedF1_U, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_tNLAddressesOrPrefixesRequestedNoNF1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABTNLAddressesRequested(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABTNLAddressesRequested, IABTNLAddressesRequested_sequence);

  return offset;
}


static const value_string xnap_IABIPv6RequestType_vals[] = {
  {   0, "iPv6Address" },
  {   1, "iPv6Prefix" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABIPv6RequestType_choice[] = {
  {   0, &hf_xnap_iPv6Address    , ASN1_NO_EXTENSIONS     , dissect_xnap_IABTNLAddressesRequested },
  {   1, &hf_xnap_iPv6Prefix     , ASN1_NO_EXTENSIONS     , dissect_xnap_IABTNLAddressesRequested },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_IABIPv6RequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_IABIPv6RequestType, IABIPv6RequestType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IABTNLAddressToRemove_Item_sequence[] = {
  { &hf_xnap_iABTNLAddress  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABTNLAddressToRemove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABTNLAddressToRemove_Item, IABTNLAddressToRemove_Item_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddressToRemove_List_sequence_of[1] = {
  { &hf_xnap_IABTNLAddressToRemove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddressToRemove_Item },
};

static int
dissect_xnap_IABTNLAddressToRemove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IABTNLAddressToRemove_List, IABTNLAddressToRemove_List_sequence_of,
                                                  1, maxnoofTLAsIAB, false);

  return offset;
}


static const per_sequence_t IAB_TNL_Address_Request_sequence[] = {
  { &hf_xnap_iABIPv4AddressesRequested, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddressesRequested },
  { &hf_xnap_iABIPv6RequestType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABIPv6RequestType },
  { &hf_xnap_iABTNLAddressToRemove_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddressToRemove_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_TNL_Address_Request(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_TNL_Address_Request, IAB_TNL_Address_Request_sequence);

  return offset;
}


static const value_string xnap_IABTNLAddressUsage_vals[] = {
  {   0, "f1-c" },
  {   1, "f1-u" },
  {   2, "non-f1" },
  {   3, "all" },
  { 0, NULL }
};


static int
dissect_xnap_IABTNLAddressUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t IABAllocatedTNLAddress_Item_sequence[] = {
  { &hf_xnap_iABTNLAddress  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_iABTNLAddressUsage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_IABTNLAddressUsage },
  { &hf_xnap_associatedDonorDUAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BAPAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABAllocatedTNLAddress_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABAllocatedTNLAddress_Item, IABAllocatedTNLAddress_Item_sequence);

  return offset;
}


static const per_sequence_t IABAllocatedTNLAddress_List_sequence_of[1] = {
  { &hf_xnap_IABAllocatedTNLAddress_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IABAllocatedTNLAddress_Item },
};

static int
dissect_xnap_IABAllocatedTNLAddress_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IABAllocatedTNLAddress_List, IABAllocatedTNLAddress_List_sequence_of,
                                                  1, maxnoofTLAsIAB, false);

  return offset;
}


static const per_sequence_t IAB_TNL_Address_Response_sequence[] = {
  { &hf_xnap_iABAllocatedTNLAddress_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABAllocatedTNLAddress_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_TNL_Address_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_TNL_Address_Response, IAB_TNL_Address_Response_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddress_Item_sequence[] = {
  { &hf_xnap_iABTNLAddress  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABTNLAddress_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABTNLAddress_Item, IABTNLAddress_Item_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddressException_sequence_of[1] = {
  { &hf_xnap_IABTNLAddressException_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress_Item },
};

static int
dissect_xnap_IABTNLAddressException(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IABTNLAddressException, IABTNLAddressException_sequence_of,
                                                  1, maxnoofTLAsIAB, false);

  return offset;
}



static int
dissect_xnap_MeasurementsToActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_xnap_MeasurementsToActivate_M1,
      &hf_xnap_MeasurementsToActivate_M2,
      &hf_xnap_MeasurementsToActivate_M3,
      &hf_xnap_MeasurementsToActivate_M4,
      &hf_xnap_MeasurementsToActivate_M5,
      &hf_xnap_MeasurementsToActivate_LoggingM1FromEventTriggered,
      &hf_xnap_MeasurementsToActivate_M6,
      &hf_xnap_MeasurementsToActivate_M7,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MeasurementsToActivate);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string xnap_M1ReportingTrigger_vals[] = {
  {   0, "periodic" },
  {   1, "a2eventtriggered" },
  {   2, "a2eventtriggered-periodic" },
  { 0, NULL }
};


static int
dissect_xnap_M1ReportingTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_Threshold_SINR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const value_string xnap_MeasurementThresholdA2_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  {   2, "threshold-SINR" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MeasurementThresholdA2_choice[] = {
  {   0, &hf_xnap_threshold_RSRP , ASN1_NO_EXTENSIONS     , dissect_xnap_Threshold_RSRP },
  {   1, &hf_xnap_threshold_RSRQ , ASN1_NO_EXTENSIONS     , dissect_xnap_Threshold_RSRQ },
  {   2, &hf_xnap_threshold_SINR , ASN1_NO_EXTENSIONS     , dissect_xnap_Threshold_SINR },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MeasurementThresholdA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MeasurementThresholdA2, MeasurementThresholdA2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t M1ThresholdEventA2_sequence[] = {
  { &hf_xnap_measurementThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasurementThresholdA2 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M1ThresholdEventA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M1ThresholdEventA2, M1ThresholdEventA2_sequence);

  return offset;
}


static const value_string xnap_ReportIntervalMDT_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "min1" },
  {   9, "min6" },
  {  10, "min12" },
  {  11, "min30" },
  {  12, "min60" },
  { 0, NULL }
};


static int
dissect_xnap_ReportIntervalMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t M1PeriodicReporting_sequence[] = {
  { &hf_xnap_reportInterval , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportIntervalMDT },
  { &hf_xnap_reportAmount   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportAmountMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M1PeriodicReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M1PeriodicReporting, M1PeriodicReporting_sequence);

  return offset;
}


static const per_sequence_t M1Configuration_sequence[] = {
  { &hf_xnap_m1reportingTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M1ReportingTrigger },
  { &hf_xnap_m1thresholdeventA2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M1ThresholdEventA2 },
  { &hf_xnap_m1periodicReporting, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M1PeriodicReporting },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M1Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M1Configuration, M1Configuration_sequence);

  return offset;
}


static const value_string xnap_M4period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_xnap_M4period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_Links_to_log_vals[] = {
  {   0, "uplink" },
  {   1, "downlink" },
  {   2, "both-uplink-and-downlink" },
  { 0, NULL }
};


static int
dissect_xnap_Links_to_log(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t M4Configuration_sequence[] = {
  { &hf_xnap_m4period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M4period },
  { &hf_xnap_m4_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M4Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M4Configuration, M4Configuration_sequence);

  return offset;
}


static const value_string xnap_M5period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_xnap_M5period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t M5Configuration_sequence[] = {
  { &hf_xnap_m5period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M5period },
  { &hf_xnap_m5_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M5Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M5Configuration, M5Configuration_sequence);

  return offset;
}



static int
dissect_xnap_MDT_Location_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_xnap_MDT_Location_Info_GNSS,
      &hf_xnap_MDT_Location_Info_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MDT_Location_Info);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string xnap_M6report_Interval_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "ms20480" },
  {   9, "ms40960" },
  {  10, "min1" },
  {  11, "min6" },
  {  12, "min12" },
  {  13, "min30" },
  { 0, NULL }
};


static int
dissect_xnap_M6report_Interval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t M6Configuration_sequence[] = {
  { &hf_xnap_m6report_Interval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M6report_Interval },
  { &hf_xnap_m6_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M6Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M6Configuration, M6Configuration_sequence);

  return offset;
}



static int
dissect_xnap_M7period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 60U, NULL, true);

  return offset;
}


static const per_sequence_t M7Configuration_sequence[] = {
  { &hf_xnap_m7period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M7period },
  { &hf_xnap_m7_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M7Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M7Configuration, M7Configuration_sequence);

  return offset;
}


static const value_string xnap_WLANMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_xnap_WLANMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_WLANName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 32, false, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);


  return offset;
}


static const per_sequence_t WLANMeasConfigNameList_sequence_of[1] = {
  { &hf_xnap_WLANMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_WLANName },
};

static int
dissect_xnap_WLANMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_WLANMeasConfigNameList, WLANMeasConfigNameList_sequence_of,
                                                  1, maxnoofWLANName, false);

  return offset;
}


static const value_string xnap_T_wlan_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_wlan_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_wlan_rtt_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_wlan_rtt(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t WLANMeasurementConfiguration_sequence[] = {
  { &hf_xnap_wlanMeasConfig , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_WLANMeasConfig },
  { &hf_xnap_wlanMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_WLANMeasConfigNameList },
  { &hf_xnap_wlan_rssi      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_wlan_rssi },
  { &hf_xnap_wlan_rtt       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_wlan_rtt },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_WLANMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_WLANMeasurementConfiguration, WLANMeasurementConfiguration_sequence);

  return offset;
}


static const value_string xnap_SensorMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_xnap_SensorMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_uncompensatedBarometricConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_uncompensatedBarometricConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_ueSpeedConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_ueSpeedConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_ueOrientationConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_ueOrientationConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SensorName_sequence[] = {
  { &hf_xnap_uncompensatedBarometricConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_uncompensatedBarometricConfig },
  { &hf_xnap_ueSpeedConfig  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_ueSpeedConfig },
  { &hf_xnap_ueOrientationConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_ueOrientationConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SensorName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SensorName, SensorName_sequence);

  return offset;
}


static const per_sequence_t SensorMeasConfigNameList_sequence_of[1] = {
  { &hf_xnap_SensorMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SensorName },
};

static int
dissect_xnap_SensorMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SensorMeasConfigNameList, SensorMeasConfigNameList_sequence_of,
                                                  1, maxnoofSensorName, false);

  return offset;
}


static const per_sequence_t SensorMeasurementConfiguration_sequence[] = {
  { &hf_xnap_sensorMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SensorMeasConfig },
  { &hf_xnap_sensorMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SensorMeasConfigNameList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SensorMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SensorMeasurementConfiguration, SensorMeasurementConfiguration_sequence);

  return offset;
}


static const per_sequence_t ImmediateMDT_NR_sequence[] = {
  { &hf_xnap_measurementsToActivate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasurementsToActivate },
  { &hf_xnap_m1Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M1Configuration },
  { &hf_xnap_m4Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M4Configuration },
  { &hf_xnap_m5Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M5Configuration },
  { &hf_xnap_mDT_Location_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDT_Location_Info },
  { &hf_xnap_m6Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M6Configuration },
  { &hf_xnap_m7Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M7Configuration },
  { &hf_xnap_bluetoothMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BluetoothMeasurementConfiguration },
  { &hf_xnap_wLANMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_WLANMeasurementConfiguration },
  { &hf_xnap_sensorMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SensorMeasurementConfiguration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ImmediateMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ImmediateMDT_NR, ImmediateMDT_NR_sequence);

  return offset;
}


static const value_string xnap_NG_RAN_CellPCI_vals[] = {
  {   0, "nr" },
  {   1, "e-utra" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NG_RAN_CellPCI_choice[] = {
  {   0, &hf_xnap_nr_01          , ASN1_NO_EXTENSIONS     , dissect_xnap_NRPCI },
  {   1, &hf_xnap_e_utra_01      , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRAPCI },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NG_RAN_CellPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NG_RAN_CellPCI, NG_RAN_CellPCI_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MAC_I(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t RRCReestab_Initiated_Reporting_wo_UERLFReport_sequence[] = {
  { &hf_xnap_failureCellPCI , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_CellPCI },
  { &hf_xnap_reestabCellCGI , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_c_RNTI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_C_RNTI },
  { &hf_xnap_shortMAC_I     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MAC_I },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport, RRCReestab_Initiated_Reporting_wo_UERLFReport_sequence);

  return offset;
}



static int
dissect_xnap_UERLFReportContainerNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_UERLFReportContainerNR);
    dissect_nr_rrc_nr_RLF_Report_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_UERLFReportContainerLTE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_UERLFReportContainerLTE);
    dissect_lte_rrc_RLF_Report_r9_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string xnap_UERLFReportContainer_vals[] = {
  {   0, "nR-UERLFReportContainer" },
  {   1, "lTE-UERLFReportContainer" },
  {   2, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t UERLFReportContainer_choice[] = {
  {   0, &hf_xnap_nR_UERLFReportContainer, ASN1_NO_EXTENSIONS     , dissect_xnap_UERLFReportContainerNR },
  {   1, &hf_xnap_lTE_UERLFReportContainer, ASN1_NO_EXTENSIONS     , dissect_xnap_UERLFReportContainerLTE },
  {   2, &hf_xnap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UERLFReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UERLFReportContainer, UERLFReportContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReestab_Initiated_Reporting_with_UERLFReport_sequence[] = {
  { &hf_xnap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UERLFReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport, RRCReestab_Initiated_Reporting_with_UERLFReport_sequence);

  return offset;
}


static const value_string xnap_RRCReestab_Initiated_Reporting_vals[] = {
  {   0, "rRCReestab-reporting-wo-UERLFReport" },
  {   1, "rRCReestab-reporting-with-UERLFReport" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RRCReestab_Initiated_Reporting_choice[] = {
  {   0, &hf_xnap_rRCReestab_reporting_wo_UERLFReport, ASN1_NO_EXTENSIONS     , dissect_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport },
  {   1, &hf_xnap_rRCReestab_reporting_with_UERLFReport, ASN1_NO_EXTENSIONS     , dissect_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_RRCReestab_Initiated_Reporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_RRCReestab_Initiated_Reporting, RRCReestab_Initiated_Reporting_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReestab_initiated_sequence[] = {
  { &hf_xnap_rRRCReestab_initiated_reporting, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RRCReestab_Initiated_Reporting },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCReestab_initiated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCReestab_initiated, RRCReestab_initiated_sequence);

  return offset;
}


static const per_sequence_t RRCSetup_Initiated_Reporting_with_UERLFReport_sequence[] = {
  { &hf_xnap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UERLFReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport, RRCSetup_Initiated_Reporting_with_UERLFReport_sequence);

  return offset;
}


static const value_string xnap_RRCSetup_Initiated_Reporting_vals[] = {
  {   0, "rRCSetup-reporting-with-UERLFReport" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RRCSetup_Initiated_Reporting_choice[] = {
  {   0, &hf_xnap_rRCSetup_reporting_with_UERLFReport, ASN1_NO_EXTENSIONS     , dissect_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_RRCSetup_Initiated_Reporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_RRCSetup_Initiated_Reporting, RRCSetup_Initiated_Reporting_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCSetup_initiated_sequence[] = {
  { &hf_xnap_rRRCSetup_Initiated_Reporting, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RRCSetup_Initiated_Reporting },
  { &hf_xnap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UERLFReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCSetup_initiated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCSetup_initiated, RRCSetup_initiated_sequence);

  return offset;
}


static const value_string xnap_InitiatingCondition_FailureIndication_vals[] = {
  {   0, "rRCReestab" },
  {   1, "rRCSetup" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t InitiatingCondition_FailureIndication_choice[] = {
  {   0, &hf_xnap_rRCReestab     , ASN1_NO_EXTENSIONS     , dissect_xnap_RRCReestab_initiated },
  {   1, &hf_xnap_rRCSetup       , ASN1_NO_EXTENSIONS     , dissect_xnap_RRCSetup_initiated },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_InitiatingCondition_FailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_InitiatingCondition_FailureIndication, InitiatingCondition_FailureIndication_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NRCyclicPrefix_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_xnap_NRCyclicPrefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_NRDL_ULTransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms3" },
  {   7, "ms4" },
  {   8, "ms5" },
  {   9, "ms10" },
  {  10, "ms20" },
  {  11, "ms40" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms120" },
  {  16, "ms140" },
  {  17, "ms160" },
  { 0, NULL }
};


static int
dissect_xnap_NRDL_ULTransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_5119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5119U, NULL, false);

  return offset;
}


static const per_sequence_t SymbolAllocation_in_Slot_AllDL_sequence[] = {
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot_AllDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SymbolAllocation_in_Slot_AllDL, SymbolAllocation_in_Slot_AllDL_sequence);

  return offset;
}


static const per_sequence_t SymbolAllocation_in_Slot_AllUL_sequence[] = {
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot_AllUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SymbolAllocation_in_Slot_AllUL, SymbolAllocation_in_Slot_AllUL_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_0_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, false);

  return offset;
}


static const per_sequence_t SymbolAllocation_in_Slot_BothDLandUL_sequence[] = {
  { &hf_xnap_numberofDLSymbols, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_13 },
  { &hf_xnap_numberofULSymbols, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_13 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot_BothDLandUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SymbolAllocation_in_Slot_BothDLandUL, SymbolAllocation_in_Slot_BothDLandUL_sequence);

  return offset;
}


static const value_string xnap_SymbolAllocation_in_Slot_vals[] = {
  {   0, "allDL" },
  {   1, "allUL" },
  {   2, "bothDLandUL" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SymbolAllocation_in_Slot_choice[] = {
  {   0, &hf_xnap_allDL          , ASN1_NO_EXTENSIONS     , dissect_xnap_SymbolAllocation_in_Slot_AllDL },
  {   1, &hf_xnap_allUL          , ASN1_NO_EXTENSIONS     , dissect_xnap_SymbolAllocation_in_Slot_AllUL },
  {   2, &hf_xnap_bothDLandUL    , ASN1_NO_EXTENSIONS     , dissect_xnap_SymbolAllocation_in_Slot_BothDLandUL },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SymbolAllocation_in_Slot, SymbolAllocation_in_Slot_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SlotConfiguration_List_Item_sequence[] = {
  { &hf_xnap_slotIndex_01   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_5119 },
  { &hf_xnap_symbolAllocation_in_Slot, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SymbolAllocation_in_Slot },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SlotConfiguration_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SlotConfiguration_List_Item, SlotConfiguration_List_Item_sequence);

  return offset;
}


static const per_sequence_t SlotConfiguration_List_sequence_of[1] = {
  { &hf_xnap_SlotConfiguration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SlotConfiguration_List_Item },
};

static int
dissect_xnap_SlotConfiguration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SlotConfiguration_List, SlotConfiguration_List_sequence_of,
                                                  1, maxnoofslots, false);

  return offset;
}


static const per_sequence_t IntendedTDD_DL_ULConfiguration_NR_sequence[] = {
  { &hf_xnap_nrscs          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRSCS },
  { &hf_xnap_nrCyclicPrefix , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRCyclicPrefix },
  { &hf_xnap_nrDL_ULTransmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRDL_ULTransmissionPeriodicity },
  { &hf_xnap_slotConfiguration_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SlotConfiguration_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IntendedTDD_DL_ULConfiguration_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IntendedTDD_DL_ULConfiguration_NR, IntendedTDD_DL_ULConfiguration_NR_sequence);

  return offset;
}



static int
dissect_xnap_InterfaceInstanceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_40(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     40, 40, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_I_RNTI_vals[] = {
  {   0, "i-RNTI-full" },
  {   1, "i-RNTI-short" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t I_RNTI_choice[] = {
  {   0, &hf_xnap_i_RNTI_full    , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_40 },
  {   1, &hf_xnap_i_RNTI_short   , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_24 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_I_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_I_RNTI, I_RNTI_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_IABAuthorizationStatus_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_IABAuthorizationStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     15, 15, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 12, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_Full_I_RNTI_Profile_List_vals[] = {
  {   0, "full-I-RNTI-Profile-0" },
  {   1, "full-I-RNTI-Profile-1" },
  {   2, "full-I-RNTI-Profile-2" },
  {   3, "full-I-RNTI-Profile-3" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Full_I_RNTI_Profile_List_choice[] = {
  {   0, &hf_xnap_full_I_RNTI_Profile_0, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_21 },
  {   1, &hf_xnap_full_I_RNTI_Profile_1, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_18 },
  {   2, &hf_xnap_full_I_RNTI_Profile_2, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_15 },
  {   3, &hf_xnap_full_I_RNTI_Profile_3, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_12 },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Full_I_RNTI_Profile_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Full_I_RNTI_Profile_List, Full_I_RNTI_Profile_List_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_Short_I_RNTI_Profile_List_vals[] = {
  {   0, "short-I-RNTI-Profile-0" },
  {   1, "short-I-RNTI-Profile-1" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Short_I_RNTI_Profile_List_choice[] = {
  {   0, &hf_xnap_short_I_RNTI_Profile_0, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_8 },
  {   1, &hf_xnap_short_I_RNTI_Profile_1, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_6 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Short_I_RNTI_Profile_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Short_I_RNTI_Profile_List, Short_I_RNTI_Profile_List_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_Local_NG_RAN_Node_Identifier_vals[] = {
  {   0, "full-I-RNTI-Profile-List" },
  {   1, "short-I-RNTI-Profile-List" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Local_NG_RAN_Node_Identifier_choice[] = {
  {   0, &hf_xnap_full_I_RNTI_Profile_List, ASN1_NO_EXTENSIONS     , dissect_xnap_Full_I_RNTI_Profile_List },
  {   1, &hf_xnap_short_I_RNTI_Profile_List, ASN1_NO_EXTENSIONS     , dissect_xnap_Short_I_RNTI_Profile_List },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Local_NG_RAN_Node_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Local_NG_RAN_Node_Identifier, Local_NG_RAN_Node_Identifier_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Full_and_Short_I_RNTI_Profile_List_sequence[] = {
  { &hf_xnap_full_I_RNTI_Profile_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Full_I_RNTI_Profile_List },
  { &hf_xnap_short_I_RNTI_Profile_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Short_I_RNTI_Profile_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Full_and_Short_I_RNTI_Profile_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Full_and_Short_I_RNTI_Profile_List, Full_and_Short_I_RNTI_Profile_List_sequence);

  return offset;
}



static int
dissect_xnap_LastVisitedNGRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedNGRANCellInformation);
    dissect_ngap_LastVisitedNGRANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_LastVisitedEUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedEUTRANCellInformation);
    dissect_s1ap_LastVisitedEUTRANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_LastVisitedUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedUTRANCellInformation);
    dissect_ranap_LastVisitedUTRANCell_Item_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_LastVisitedGERANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedGERANCellInformation);
    dissect_s1ap_LastVisitedGERANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string xnap_LastVisitedCell_Item_vals[] = {
  {   0, "nG-RAN-Cell" },
  {   1, "e-UTRAN-Cell" },
  {   2, "uTRAN-Cell" },
  {   3, "gERAN-Cell" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t LastVisitedCell_Item_choice[] = {
  {   0, &hf_xnap_nG_RAN_Cell    , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedNGRANCellInformation },
  {   1, &hf_xnap_e_UTRAN_Cell   , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedEUTRANCellInformation },
  {   2, &hf_xnap_uTRAN_Cell     , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedUTRANCellInformation },
  {   3, &hf_xnap_gERAN_Cell     , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedGERANCellInformation },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_LastVisitedCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_LastVisitedCell_Item, LastVisitedCell_Item_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_LastVisitedPSCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedPSCellInformation);
    dissect_ngap_LastVisitedPSCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t LastVisitedPSCellList_Item_sequence[] = {
  { &hf_xnap_lastVisitedPSCellInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LastVisitedPSCellInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LastVisitedPSCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LastVisitedPSCellList_Item, LastVisitedPSCellList_Item_sequence);

  return offset;
}


static const per_sequence_t LastVisitedPSCellList_sequence_of[1] = {
  { &hf_xnap_LastVisitedPSCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_LastVisitedPSCellList_Item },
};

static int
dissect_xnap_LastVisitedPSCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_LastVisitedPSCellList, LastVisitedPSCellList_sequence_of,
                                                  1, maxnoofPSCellsPerSN, false);

  return offset;
}


static const per_sequence_t SCGUEHistoryInformation_sequence[] = {
  { &hf_xnap_lastVisitedPSCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LastVisitedPSCellList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SCGUEHistoryInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SCGUEHistoryInformation, SCGUEHistoryInformation_sequence);

  return offset;
}



static int
dissect_xnap_LCID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, true);

  return offset;
}


static const value_string xnap_LocationInformationSNReporting_vals[] = {
  {   0, "pSCell" },
  { 0, NULL }
};


static int
dissect_xnap_LocationInformationSNReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_ReportArea_vals[] = {
  {   0, "cell" },
  { 0, NULL }
};


static int
dissect_xnap_ReportArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LocationReportingInformation_sequence[] = {
  { &hf_xnap_eventType      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EventType },
  { &hf_xnap_reportArea     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportArea },
  { &hf_xnap_areaOfInterest , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaOfInterestInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LocationReportingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LocationReportingInformation, LocationReportingInformation_sequence);

  return offset;
}


static const value_string xnap_LoggingInterval_vals[] = {
  {   0, "ms320" },
  {   1, "ms640" },
  {   2, "ms1280" },
  {   3, "ms2560" },
  {   4, "ms5120" },
  {   5, "ms10240" },
  {   6, "ms20480" },
  {   7, "ms30720" },
  {   8, "ms40960" },
  {   9, "ms61440" },
  {  10, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_LoggingInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_LoggingDuration_vals[] = {
  {   0, "m10" },
  {   1, "m20" },
  {   2, "m40" },
  {   3, "m60" },
  {   4, "m90" },
  {   5, "m120" },
  { 0, NULL }
};


static int
dissect_xnap_LoggingDuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t Periodical_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Periodical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Periodical, Periodical_sequence);

  return offset;
}


static const value_string xnap_ReportType_vals[] = {
  {   0, "periodical" },
  {   1, "eventTriggered" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ReportType_choice[] = {
  {   0, &hf_xnap_periodical     , ASN1_EXTENSION_ROOT    , dissect_xnap_Periodical },
  {   1, &hf_xnap_eventTriggered , ASN1_EXTENSION_ROOT    , dissect_xnap_EventTriggered },
  {   2, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ReportType, ReportType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LoggedMDT_NR_sequence[] = {
  { &hf_xnap_loggingInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LoggingInterval },
  { &hf_xnap_loggingDuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LoggingDuration },
  { &hf_xnap_reportType     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportType },
  { &hf_xnap_bluetoothMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BluetoothMeasurementConfiguration },
  { &hf_xnap_wLANMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_WLANMeasurementConfiguration },
  { &hf_xnap_sensorMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SensorMeasurementConfiguration },
  { &hf_xnap_areaScopeOfNeighCellsList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfNeighCellsList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LoggedMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LoggedMDT_NR, LoggedMDT_NR_sequence);

  return offset;
}


static const value_string xnap_LowerLayerPresenceStatusChange_vals[] = {
  {   0, "release-lower-layers" },
  {   1, "re-establish-lower-layers" },
  {   2, "suspend-lower-layers" },
  {   3, "resume-lower-layers" },
  { 0, NULL }
};


static int
dissect_xnap_LowerLayerPresenceStatusChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 2, NULL);

  return offset;
}


static const per_sequence_t LTEA2XServicesAuthorized_sequence[] = {
  { &hf_xnap_aerialUE       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AerialUE },
  { &hf_xnap_aerialControllerUE, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AerialControllerUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LTEA2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LTEA2XServicesAuthorized, LTEA2XServicesAuthorized_sequence);

  return offset;
}


static const value_string xnap_VehicleUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_VehicleUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_PedestrianUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_PedestrianUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LTEV2XServicesAuthorized_sequence[] = {
  { &hf_xnap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_VehicleUE },
  { &hf_xnap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PedestrianUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LTEV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LTEV2XServicesAuthorized, LTEV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t LTEUESidelinkAggregateMaximumBitRate_sequence[] = {
  { &hf_xnap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LTEUESidelinkAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LTEUESidelinkAggregateMaximumBitRate, LTEUESidelinkAggregateMaximumBitRate_sequence);

  return offset;
}


static const value_string xnap_MBSCommServiceType_vals[] = {
  {   0, "multicast" },
  {   1, "broadcast" },
  { 0, NULL }
};


static int
dissect_xnap_MBSCommServiceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_NG_RANTraceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb;
  proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, false, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_xnap_NG_RANTraceID);
  dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, E212_NONE, false);
  proto_tree_add_item(subtree, hf_xnap_NG_RANTraceID_TraceID, parameter_tvb, 3, 3, ENC_BIG_ENDIAN);
  proto_tree_add_item(subtree, hf_xnap_NG_RANTraceID_TraceRecordingSessionReference, parameter_tvb, 6, 2, ENC_BIG_ENDIAN);


  return offset;
}


static const per_sequence_t S_BasedMDT_sequence[] = {
  { &hf_xnap_ng_ran_TraceID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RANTraceID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_S_BasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_S_BasedMDT, S_BasedMDT_sequence);

  return offset;
}


static const value_string xnap_MDTAlignmentInfo_vals[] = {
  {   0, "s-BasedMDT" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MDTAlignmentInfo_choice[] = {
  {   0, &hf_xnap_s_BasedMDT     , ASN1_NO_EXTENSIONS     , dissect_xnap_S_BasedMDT },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MDTAlignmentInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MDTAlignmentInfo, MDTAlignmentInfo_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MeasCollectionEntityIPAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_xnap_TransportLayerAddress(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string xnap_M4ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M4ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_M5ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M5ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_M6ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M6ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_M7ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M7ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_MaskedIMEISV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_MaxIPrate_vals[] = {
  {   0, "bitrate64kbs" },
  {   1, "max-UErate" },
  { 0, NULL }
};


static int
dissect_xnap_MaxIPrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MaximumIPdatarate_sequence[] = {
  { &hf_xnap_maxIPrate_UL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MaxIPrate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MaximumIPdatarate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MaximumIPdatarate, MaximumIPdatarate_sequence);

  return offset;
}


static const value_string xnap_MBSFNSubframeAllocation_E_UTRA_vals[] = {
  {   0, "oneframe" },
  {   1, "fourframes" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MBSFNSubframeAllocation_E_UTRA_choice[] = {
  {   0, &hf_xnap_oneframe       , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_6 },
  {   1, &hf_xnap_fourframes     , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_24 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MBSFNSubframeAllocation_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MBSFNSubframeAllocation_E_UTRA, MBSFNSubframeAllocation_E_UTRA_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_T_radioframeAllocationPeriod_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  { 0, NULL }
};


static int
dissect_xnap_T_radioframeAllocationPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_7_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}


static const per_sequence_t MBSFNSubframeInfo_E_UTRA_Item_sequence[] = {
  { &hf_xnap_radioframeAllocationPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_radioframeAllocationPeriod },
  { &hf_xnap_radioframeAllocationOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_7_ },
  { &hf_xnap_subframeAllocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBSFNSubframeAllocation_E_UTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBSFNSubframeInfo_E_UTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBSFNSubframeInfo_E_UTRA_Item, MBSFNSubframeInfo_E_UTRA_Item_sequence);

  return offset;
}


static const per_sequence_t MBSFNSubframeInfo_E_UTRA_sequence_of[1] = {
  { &hf_xnap_MBSFNSubframeInfo_E_UTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBSFNSubframeInfo_E_UTRA_Item },
};

static int
dissect_xnap_MBSFNSubframeInfo_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBSFNSubframeInfo_E_UTRA, MBSFNSubframeInfo_E_UTRA_sequence_of,
                                                  1, maxnoofMBSFNEUTRA, false);

  return offset;
}



static int
dissect_xnap_MBS_FrequencySelectionArea_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, NULL);

  return offset;
}


static const value_string xnap_MBS_DataForwarding_Indicator_vals[] = {
  {   0, "mbs-only" },
  { 0, NULL }
};


static int
dissect_xnap_MBS_DataForwarding_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBS_DataForwardingResponseInfofromTarget_Item_sequence[] = {
  { &hf_xnap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MRB_ID },
  { &hf_xnap_dlForwardingUPTNL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_mRB_ProgressInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MRB_ProgressInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_DataForwardingResponseInfofromTarget_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_DataForwardingResponseInfofromTarget_Item, MBS_DataForwardingResponseInfofromTarget_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_DataForwardingResponseInfofromTarget_sequence_of[1] = {
  { &hf_xnap_MBS_DataForwardingResponseInfofromTarget_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_DataForwardingResponseInfofromTarget_Item },
};

static int
dissect_xnap_MBS_DataForwardingResponseInfofromTarget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_DataForwardingResponseInfofromTarget, MBS_DataForwardingResponseInfofromTarget_sequence_of,
                                                  1, maxnoofMRBs, false);

  return offset;
}



static int
dissect_xnap_TMGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, false, NULL);

  return offset;
}


static const per_sequence_t MBS_Session_ID_sequence[] = {
  { &hf_xnap_tMGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TMGI },
  { &hf_xnap_nID            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_Session_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_Session_ID, MBS_Session_ID_sequence);

  return offset;
}


static const value_string xnap_MBS_AssistanceInformation_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_MBS_AssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBS_SessionAssociatedInformation_Item_sequence[] = {
  { &hf_xnap_mBS_Session_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Session_ID },
  { &hf_xnap_associated_QoSFlowInfo_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Associated_QoSFlowInfo_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_SessionAssociatedInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_SessionAssociatedInformation_Item, MBS_SessionAssociatedInformation_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionAssociatedInformation_sequence_of[1] = {
  { &hf_xnap_MBS_SessionAssociatedInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_SessionAssociatedInformation_Item },
};

static int
dissect_xnap_MBS_SessionAssociatedInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_SessionAssociatedInformation, MBS_SessionAssociatedInformation_sequence_of,
                                                  1, maxnoofAssociatedMBSSessions, false);

  return offset;
}


static const per_sequence_t MBS_SessionInformation_Item_sequence[] = {
  { &hf_xnap_mBS_Session_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Session_ID },
  { &hf_xnap_mBS_Area_Session_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_Area_Session_ID },
  { &hf_xnap_active_MBS_SessioInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Active_MBS_SessionInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_SessionInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_SessionInformation_Item, MBS_SessionInformation_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionInformation_List_sequence_of[1] = {
  { &hf_xnap_MBS_SessionInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_SessionInformation_Item },
};

static int
dissect_xnap_MBS_SessionInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_SessionInformation_List, MBS_SessionInformation_List_sequence_of,
                                                  1, maxnoofMBSSessions, false);

  return offset;
}


static const per_sequence_t MBS_SessionInformationResponse_Item_sequence[] = {
  { &hf_xnap_mBS_Session_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Session_ID },
  { &hf_xnap_mBS_DataForwardingResponseInfofromTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_DataForwardingResponseInfofromTarget },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_SessionInformationResponse_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_SessionInformationResponse_Item, MBS_SessionInformationResponse_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionInformationResponse_List_sequence_of[1] = {
  { &hf_xnap_MBS_SessionInformationResponse_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_SessionInformationResponse_Item },
};

static int
dissect_xnap_MBS_SessionInformationResponse_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_SessionInformationResponse_List, MBS_SessionInformationResponse_List_sequence_of,
                                                  1, maxnoofMBSSessions, false);

  return offset;
}


static const value_string xnap_MDT_Activation_vals[] = {
  {   0, "immediate-MDT-only" },
  {   1, "immediate-MDT-and-Trace" },
  {   2, "logged-MDT-only" },
  { 0, NULL }
};


static int
dissect_xnap_MDT_Activation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_MDTMode_NR_Extension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_xnap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string xnap_MDTMode_NR_vals[] = {
  {   0, "immediateMDT" },
  {   1, "loggedMDT" },
  {   2, "mDTMode-NR-Extension" },
  { 0, NULL }
};

static const per_choice_t MDTMode_NR_choice[] = {
  {   0, &hf_xnap_immediateMDT   , ASN1_EXTENSION_ROOT    , dissect_xnap_ImmediateMDT_NR },
  {   1, &hf_xnap_loggedMDT      , ASN1_EXTENSION_ROOT    , dissect_xnap_LoggedMDT_NR },
  {   2, &hf_xnap_mDTMode_NR_Extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_MDTMode_NR_Extension },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MDTMode_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MDTMode_NR, MDTMode_NR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MDTPLMNList_sequence_of[1] = {
  { &hf_xnap_MDTPLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_MDTPLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MDTPLMNList, MDTPLMNList_sequence_of,
                                                  1, maxnoofMDTPLMNs, false);

  return offset;
}


static const per_sequence_t MDT_Configuration_NR_sequence[] = {
  { &hf_xnap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDT_Activation },
  { &hf_xnap_areaScopeOfMDT_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfMDT_NR },
  { &hf_xnap_mDTMode_NR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDTMode_NR },
  { &hf_xnap_signallingBasedMDTPLMNList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDTPLMNList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MDT_Configuration_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MDT_Configuration_NR, MDT_Configuration_NR_sequence);

  return offset;
}



static int
dissect_xnap_MDTMode_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *mdt_mode_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &mdt_mode_eutra_tvb);

  if (mdt_mode_eutra_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MDTMode_EUTRA);
    dissect_s1ap_MDTMode_PDU(mdt_mode_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t MDT_Configuration_EUTRA_sequence[] = {
  { &hf_xnap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDT_Activation },
  { &hf_xnap_areaScopeOfMDT_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfMDT_EUTRA },
  { &hf_xnap_mDTMode_EUTRA  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDTMode_EUTRA },
  { &hf_xnap_signallingBasedMDTPLMNList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDTPLMNList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MDT_Configuration_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MDT_Configuration_EUTRA, MDT_Configuration_EUTRA_sequence);

  return offset;
}


static const per_sequence_t MDT_Configuration_sequence[] = {
  { &hf_xnap_mDT_Configuration_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDT_Configuration_NR },
  { &hf_xnap_mDT_Configuration_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDT_Configuration_EUTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MDT_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MDT_Configuration, MDT_Configuration_sequence);

  return offset;
}


static const value_string xnap_MN_only_MDT_collection_vals[] = {
  {   0, "mN-Only" },
  { 0, NULL }
};


static int
dissect_xnap_MN_only_MDT_collection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MDTPLMNModificationList_sequence_of[1] = {
  { &hf_xnap_MDTPLMNModificationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_MDTPLMNModificationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MDTPLMNModificationList, MDTPLMNModificationList_sequence_of,
                                                  0, maxnoofMDTPLMNs, false);

  return offset;
}



static int
dissect_xnap_UL_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_UL_non_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_UL_Total_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t MIMOPRBusageInformation_sequence[] = {
  { &hf_xnap_dl_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_ul_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_dl_non_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_non_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_ul_non_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_non_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_dl_Total_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_Total_PRB_usage_for_MIMO },
  { &hf_xnap_ul_Total_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_Total_PRB_usage_for_MIMO },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MIMOPRBusageInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MIMOPRBusageInformation, MIMOPRBusageInformation_sequence);

  return offset;
}


static const value_string xnap_MobileIAB_AuthorizationStatus_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_MobileIAB_AuthorizationStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_MobileIABCell_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_MobileIABCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_MobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_M20_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -20, 20U, NULL, false);

  return offset;
}


static const per_sequence_t MobilityParametersModificationRange_sequence[] = {
  { &hf_xnap_handoverTriggerChangeLowerLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M20_20 },
  { &hf_xnap_handoverTriggerChangeUpperLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M20_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MobilityParametersModificationRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MobilityParametersModificationRange, MobilityParametersModificationRange_sequence);

  return offset;
}


static const per_sequence_t MobilityParametersInformation_sequence[] = {
  { &hf_xnap_handoverTriggerChange, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M20_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MobilityParametersInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MobilityParametersInformation, MobilityParametersInformation_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity_sequence_of[1] = {
  { &hf_xnap_equivalent_PLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity, SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity_sequence_of,
                                                  1, maxnoofEPLMNs, false);

  return offset;
}


static int * const RAT_RestrictionInformation_bits[] = {
  &hf_xnap_RAT_RestrictionInformation_e_UTRA,
  &hf_xnap_RAT_RestrictionInformation_nR,
  &hf_xnap_RAT_RestrictionInformation_nR_unlicensed,
  &hf_xnap_RAT_RestrictionInformation_nR_LEO,
  &hf_xnap_RAT_RestrictionInformation_nR_MEO,
  &hf_xnap_RAT_RestrictionInformation_nR_GEO,
  &hf_xnap_RAT_RestrictionInformation_nR_OTHERSAT,
  NULL
};

static int
dissect_xnap_RAT_RestrictionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, RAT_RestrictionInformation_bits, 7, NULL, NULL);

  return offset;
}


static const per_sequence_t RAT_RestrictionsItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_rat_RestrictionInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RAT_RestrictionInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RAT_RestrictionsItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RAT_RestrictionsItem, RAT_RestrictionsItem_sequence);

  return offset;
}


static const per_sequence_t RAT_RestrictionsList_sequence_of[1] = {
  { &hf_xnap_RAT_RestrictionsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_RAT_RestrictionsItem },
};

static int
dissect_xnap_RAT_RestrictionsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_RAT_RestrictionsList, RAT_RestrictionsList_sequence_of,
                                                  1, maxnoofPLMNs, false);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC_sequence_of[1] = {
  { &hf_xnap_forbidden_TACs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC, SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC_sequence_of,
                                                  1, maxnoofForbiddenTACs, false);

  return offset;
}


static const per_sequence_t ForbiddenAreaItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_forbidden_TACs , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ForbiddenAreaItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ForbiddenAreaItem, ForbiddenAreaItem_sequence);

  return offset;
}


static const per_sequence_t ForbiddenAreaList_sequence_of[1] = {
  { &hf_xnap_ForbiddenAreaList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ForbiddenAreaItem },
};

static int
dissect_xnap_ForbiddenAreaList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ForbiddenAreaList, ForbiddenAreaList_sequence_of,
                                                  1, maxnoofPLMNs, false);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC_sequence_of[1] = {
  { &hf_xnap_allowed_TACs_ServiceArea_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC, SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC_sequence_of,
                                                  1, maxnoofAllowedAreas, false);

  return offset;
}


static const per_sequence_t ServiceAreaItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_allowed_TACs_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC },
  { &hf_xnap_not_allowed_TACs_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServiceAreaItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServiceAreaItem, ServiceAreaItem_sequence);

  return offset;
}


static const per_sequence_t ServiceAreaList_sequence_of[1] = {
  { &hf_xnap_ServiceAreaList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServiceAreaItem },
};

static int
dissect_xnap_ServiceAreaList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ServiceAreaList, ServiceAreaList_sequence_of,
                                                  1, maxnoofPLMNs, false);

  return offset;
}


static const per_sequence_t MobilityRestrictionList_sequence[] = {
  { &hf_xnap_serving_PLMN   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_equivalent_PLMNs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity },
  { &hf_xnap_rat_Restrictions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RAT_RestrictionsList },
  { &hf_xnap_forbiddenAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ForbiddenAreaList },
  { &hf_xnap_serviceAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ServiceAreaList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MobilityRestrictionList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MobilityRestrictionList, MobilityRestrictionList_sequence);

  return offset;
}


static const value_string xnap_T_cn_Type_vals[] = {
  {   0, "epc-forbidden" },
  {   1, "fiveGC-forbidden" },
  { 0, NULL }
};


static int
dissect_xnap_T_cn_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CNTypeRestrictionsForEquivalentItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_cn_Type        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_cn_Type },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CNTypeRestrictionsForEquivalentItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CNTypeRestrictionsForEquivalentItem, CNTypeRestrictionsForEquivalentItem_sequence);

  return offset;
}


static const per_sequence_t CNTypeRestrictionsForEquivalent_sequence_of[1] = {
  { &hf_xnap_CNTypeRestrictionsForEquivalent_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CNTypeRestrictionsForEquivalentItem },
};

static int
dissect_xnap_CNTypeRestrictionsForEquivalent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CNTypeRestrictionsForEquivalent, CNTypeRestrictionsForEquivalent_sequence_of,
                                                  1, maxnoofEPLMNs, false);

  return offset;
}


static const value_string xnap_CNTypeRestrictionsForServing_vals[] = {
  {   0, "epc-forbidden" },
  { 0, NULL }
};


static int
dissect_xnap_CNTypeRestrictionsForServing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_6_4400(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 4400, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_E_UTRA_CoordinationAssistanceInfo_vals[] = {
  {   0, "coordination-not-required" },
  { 0, NULL }
};


static int
dissect_xnap_E_UTRA_CoordinationAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t E_UTRA_ResourceCoordinationInfo_sequence[] = {
  { &hf_xnap_e_utra_cell    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_ul_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_dl_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_nr_cell        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NR_CGI },
  { &hf_xnap_e_utra_coordination_assistance_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_UTRA_CoordinationAssistanceInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_E_UTRA_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_E_UTRA_ResourceCoordinationInfo, E_UTRA_ResourceCoordinationInfo_sequence);

  return offset;
}


static const value_string xnap_NR_CoordinationAssistanceInfo_vals[] = {
  {   0, "coordination-not-required" },
  { 0, NULL }
};


static int
dissect_xnap_NR_CoordinationAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NR_ResourceCoordinationInfo_sequence[] = {
  { &hf_xnap_nr_cell        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_ul_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_dl_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_e_utra_cell    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_nr_coordination_assistance_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NR_CoordinationAssistanceInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_ResourceCoordinationInfo, NR_ResourceCoordinationInfo_sequence);

  return offset;
}


static const value_string xnap_NG_RAN_Node_ResourceCoordinationInfo_vals[] = {
  {   0, "eutra-resource-coordination-info" },
  {   1, "nr-resource-coordination-info" },
  { 0, NULL }
};

static const per_choice_t NG_RAN_Node_ResourceCoordinationInfo_choice[] = {
  {   0, &hf_xnap_eutra_resource_coordination_info, ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_ResourceCoordinationInfo },
  {   1, &hf_xnap_nr_resource_coordination_info, ASN1_NO_EXTENSIONS     , dissect_xnap_NR_ResourceCoordinationInfo },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NG_RAN_Node_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NG_RAN_Node_ResourceCoordinationInfo, NG_RAN_Node_ResourceCoordinationInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MR_DC_ResourceCoordinationInfo_sequence[] = {
  { &hf_xnap_ng_RAN_Node_ResourceCoordinationInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Node_ResourceCoordinationInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MR_DC_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MR_DC_ResourceCoordinationInfo, MR_DC_ResourceCoordinationInfo_sequence);

  return offset;
}


static const per_sequence_t MessageOversizeNotification_sequence[] = {
  { &hf_xnap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MaximumCellListSize },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MessageOversizeNotification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MessageOversizeNotification, MessageOversizeNotification_sequence);

  return offset;
}


static const value_string xnap_MT_SDT_Indicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_MT_SDT_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_MT_SDT_DataSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 96000U, NULL, true);

  return offset;
}


static const per_sequence_t MT_SDT_Information_sequence[] = {
  { &hf_xnap_mT_SDT_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MT_SDT_Indicator },
  { &hf_xnap_mT_SDT_DataSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MT_SDT_DataSize },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MT_SDT_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MT_SDT_Information, MT_SDT_Information_sequence);

  return offset;
}


static const per_sequence_t MeasuredTrajectoryNGRANCellInfo_sequence[] = {
  { &hf_xnap_globalNG_RANCell_ID_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_timeUEStaysInCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_4095 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MeasuredTrajectoryNGRANCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MeasuredTrajectoryNGRANCellInfo, MeasuredTrajectoryNGRANCellInfo_sequence);

  return offset;
}


static const value_string xnap_MeasuredTrajectoryCellInfo_vals[] = {
  {   0, "nG-RAN-Cell" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MeasuredTrajectoryCellInfo_choice[] = {
  {   0, &hf_xnap_nG_RAN_Cell_01 , ASN1_NO_EXTENSIONS     , dissect_xnap_MeasuredTrajectoryNGRANCellInfo },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MeasuredTrajectoryCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MeasuredTrajectoryCellInfo, MeasuredTrajectoryCellInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasuredUETrajectory_Item_sequence[] = {
  { &hf_xnap_measuredtrajectoryCellInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasuredTrajectoryCellInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MeasuredUETrajectory_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MeasuredUETrajectory_Item, MeasuredUETrajectory_Item_sequence);

  return offset;
}


static const per_sequence_t MeasuredUETrajectory_sequence_of[1] = {
  { &hf_xnap_MeasuredUETrajectory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MeasuredUETrajectory_Item },
};

static int
dissect_xnap_MeasuredUETrajectory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MeasuredUETrajectory, MeasuredUETrajectory_sequence_of,
                                                  1, maxnoofCellsTrajectory, false);

  return offset;
}



static int
dissect_xnap_INTEGER_M127_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 127U, NULL, false);

  return offset;
}


static const per_sequence_t N6JitterInformation_sequence[] = {
  { &hf_xnap_n6JitterLowerBound, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M127_127 },
  { &hf_xnap_n6JitterUpperBound, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M127_127 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_N6JitterInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_N6JitterInformation, N6JitterInformation_sequence);

  return offset;
}


static const value_string xnap_NBIoT_UL_DL_AlignmentOffset_vals[] = {
  {   0, "khz-7dot5" },
  {   1, "khz0" },
  {   2, "khz7dot5" },
  { 0, NULL }
};


static int
dissect_xnap_NBIoT_UL_DL_AlignmentOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_subframeAssignment_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_xnap_T_subframeAssignment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, false);

  return offset;
}


static const per_sequence_t NE_DC_TDM_Pattern_sequence[] = {
  { &hf_xnap_subframeAssignment, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_subframeAssignment },
  { &hf_xnap_harqOffset     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_9 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NE_DC_TDM_Pattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NE_DC_TDM_Pattern, NE_DC_TDM_Pattern_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_E_UTRA_Item_sequence[] = {
  { &hf_xnap_e_utra_PCI     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAPCI },
  { &hf_xnap_e_utra_cgi     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_earfcn         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAARFCN },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_E_UTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_E_UTRA_Item, NeighbourInformation_E_UTRA_Item_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_E_UTRA_sequence_of[1] = {
  { &hf_xnap_NeighbourInformation_E_UTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NeighbourInformation_E_UTRA_Item },
};

static int
dissect_xnap_NeighbourInformation_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NeighbourInformation_E_UTRA, NeighbourInformation_E_UTRA_sequence_of,
                                                  1, maxnoofNeighbours, false);

  return offset;
}


static const per_sequence_t NeighbourInformation_NR_ModeFDDInfo_sequence[] = {
  { &hf_xnap_ul_NR_FreqInfo , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_dl_NR_FequInfo , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_ModeFDDInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_NR_ModeFDDInfo, NeighbourInformation_NR_ModeFDDInfo_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_NR_ModeTDDInfo_sequence[] = {
  { &hf_xnap_nr_FreqInfo    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_ModeTDDInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_NR_ModeTDDInfo, NeighbourInformation_NR_ModeTDDInfo_sequence);

  return offset;
}


static const value_string xnap_NeighbourInformation_NR_ModeInfo_vals[] = {
  {   0, "fdd-info" },
  {   1, "tdd-info" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NeighbourInformation_NR_ModeInfo_choice[] = {
  {   0, &hf_xnap_fdd_info       , ASN1_NO_EXTENSIONS     , dissect_xnap_NeighbourInformation_NR_ModeFDDInfo },
  {   1, &hf_xnap_tdd_info       , ASN1_NO_EXTENSIONS     , dissect_xnap_NeighbourInformation_NR_ModeTDDInfo },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_ModeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NeighbourInformation_NR_ModeInfo, NeighbourInformation_NR_ModeInfo_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_T_measurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NeighbourInformation_NR_Item_sequence[] = {
  { &hf_xnap_nr_PCI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPCI },
  { &hf_xnap_nr_cgi         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_nr_mode_info   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NeighbourInformation_NR_ModeInfo },
  { &hf_xnap_connectivitySupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Connectivity_Support },
  { &hf_xnap_measurementTimingConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_measurementTimingConfiguration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_NR_Item, NeighbourInformation_NR_Item_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_NR_sequence_of[1] = {
  { &hf_xnap_NeighbourInformation_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NeighbourInformation_NR_Item },
};

static int
dissect_xnap_NeighbourInformation_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NeighbourInformation_NR, NeighbourInformation_NR_sequence_of,
                                                  1, maxnoofNeighbours, false);

  return offset;
}


static const per_sequence_t Neighbour_NG_RAN_Node_Item_sequence[] = {
  { &hf_xnap_globalNG_RANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_local_NG_RAN_Node_Identifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Local_NG_RAN_Node_Identifier },
  { &hf_xnap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Neighbour_NG_RAN_Node_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Neighbour_NG_RAN_Node_Item, Neighbour_NG_RAN_Node_Item_sequence);

  return offset;
}


static const per_sequence_t Neighbour_NG_RAN_Node_List_sequence_of[1] = {
  { &hf_xnap_Neighbour_NG_RAN_Node_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Neighbour_NG_RAN_Node_Item },
};

static int
dissect_xnap_Neighbour_NG_RAN_Node_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Neighbour_NG_RAN_Node_List, Neighbour_NG_RAN_Node_List_sequence_of,
                                                  0, maxnoofNeighbour_NG_RAN_Nodes, false);

  return offset;
}



static int
dissect_xnap_NRCellPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_NRCellPRACHConfig);
    dissect_f1ap_NRPRACHConfig_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t SSBOffsetModificationRange_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_sSBobilityParametersModificationRange, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MobilityParametersModificationRange },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBOffsetModificationRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBOffsetModificationRange, SSBOffsetModificationRange_sequence);

  return offset;
}


static const per_sequence_t NG_RANnode2SSBOffsetsModificationRange_sequence_of[1] = {
  { &hf_xnap_NG_RANnode2SSBOffsetsModificationRange_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBOffsetModificationRange },
};

static int
dissect_xnap_NG_RANnode2SSBOffsetsModificationRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NG_RANnode2SSBOffsetsModificationRange, NG_RANnode2SSBOffsetsModificationRange_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t NodeAssociatedInfoResult_sequence[] = {
  { &hf_xnap_energyCost     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_EnergyCost },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NodeAssociatedInfoResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NodeAssociatedInfoResult, NodeAssociatedInfoResult_sequence);

  return offset;
}



static int
dissect_xnap_T_nodemeasurementFailedReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_xnap_nodemeasurementFailedReportCharacteristics_EnergyCost,
      &hf_xnap_nodemeasurementFailedReportCharacteristics_AverageUEThroughputDL,
      &hf_xnap_nodemeasurementFailedReportCharacteristics_AverageUEThroughputUL,
      &hf_xnap_nodemeasurementFailedReportCharacteristics_AveragePacketDelay,
      &hf_xnap_nodemeasurementFailedReportCharacteristics_AveragePacketLossDL,
      &hf_xnap_nodemeasurementFailedReportCharacteristics_MeasuredUETrajectory,
      &hf_xnap_nodemeasurementFailedReportCharacteristics_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_nodemeasurementFailedReportCharacteristics);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 4, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t NodeMeasurementInitiationResult_Item_sequence[] = {
  { &hf_xnap_nodemeasurementFailedReportCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_nodemeasurementFailedReportCharacteristics },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Cause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NodeMeasurementInitiationResult_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NodeMeasurementInitiationResult_Item, NodeMeasurementInitiationResult_Item_sequence);

  return offset;
}


static const per_sequence_t NodeMeasurementInitiationResult_List_sequence_of[1] = {
  { &hf_xnap_NodeMeasurementInitiationResult_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NodeMeasurementInitiationResult_Item },
};

static int
dissect_xnap_NodeMeasurementInitiationResult_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NodeMeasurementInitiationResult_List, NodeMeasurementInitiationResult_List_sequence_of,
                                                  1, maxFailedMeasPerNode, false);

  return offset;
}



static int
dissect_xnap_DL_scheduling_PDCCH_CCE_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static int
dissect_xnap_UL_scheduling_PDCCH_CCE_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t ULNonF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_egressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_egressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_nexthopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ULNonF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ULNonF1Terminating_BHInfo, ULNonF1Terminating_BHInfo_sequence);

  return offset;
}


static const per_sequence_t NonF1TerminatingBHInformation_Item_sequence[] = {
  { &hf_xnap_bHInfoIndex    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfoIndex },
  { &hf_xnap_dlNon_F1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DLNonF1Terminating_BHInfo },
  { &hf_xnap_ulNon_F1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULNonF1Terminating_BHInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NonF1TerminatingBHInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NonF1TerminatingBHInformation_Item, NonF1TerminatingBHInformation_Item_sequence);

  return offset;
}


static const per_sequence_t NonF1TerminatingBHInformation_List_sequence_of[1] = {
  { &hf_xnap_NonF1TerminatingBHInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NonF1TerminatingBHInformation_Item },
};

static int
dissect_xnap_NonF1TerminatingBHInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NonF1TerminatingBHInformation_List, NonF1TerminatingBHInformation_List_sequence_of,
                                                  1, maxnoofBHInfo, false);

  return offset;
}


static const per_sequence_t Non_F1_TerminatingTopologyBHInformation_sequence[] = {
  { &hf_xnap_nonF1TerminatingBHInformation_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NonF1TerminatingBHInformation_List },
  { &hf_xnap_bAPControlPDURLCCH_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BAPControlPDURLCCH_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Non_F1_TerminatingTopologyBHInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Non_F1_TerminatingTopologyBHInformation, Non_F1_TerminatingTopologyBHInformation_sequence);

  return offset;
}


static const value_string xnap_NonUPTrafficType_vals[] = {
  {   0, "ueassociatedf1ap" },
  {   1, "nonueassociatedf1ap" },
  {   2, "nonf1" },
  { 0, NULL }
};


static int
dissect_xnap_NonUPTrafficType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_NonUPTraffic_vals[] = {
  {   0, "nonUPTrafficType" },
  {   1, "controlPlaneTrafficType" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NonUPTraffic_choice[] = {
  {   0, &hf_xnap_nonUPTrafficType, ASN1_NO_EXTENSIONS     , dissect_xnap_NonUPTrafficType },
  {   1, &hf_xnap_controlPlaneTrafficType, ASN1_NO_EXTENSIONS     , dissect_xnap_ControlPlaneTrafficType },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NonUPTraffic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NonUPTraffic, NonUPTraffic_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NoPDUSessionIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_NoPDUSessionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NPN_Broadcast_Information_SNPN_sequence[] = {
  { &hf_xnap_broadcastSNPNID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastSNPNID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPN_Broadcast_Information_SNPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPN_Broadcast_Information_SNPN, NPN_Broadcast_Information_SNPN_sequence);

  return offset;
}


static const per_sequence_t NPN_Broadcast_Information_PNI_NPN_sequence[] = {
  { &hf_xnap_broadcastPNI_NPN_ID_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPNI_NPN_ID_Information },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPN_Broadcast_Information_PNI_NPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPN_Broadcast_Information_PNI_NPN, NPN_Broadcast_Information_PNI_NPN_sequence);

  return offset;
}


static const value_string xnap_NPN_Broadcast_Information_vals[] = {
  {   0, "snpn-Information" },
  {   1, "pni-npn-Information" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPN_Broadcast_Information_choice[] = {
  {   0, &hf_xnap_snpn_Information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPN_Broadcast_Information_SNPN },
  {   1, &hf_xnap_pni_npn_Information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPN_Broadcast_Information_PNI_NPN },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPN_Broadcast_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPN_Broadcast_Information, NPN_Broadcast_Information_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPNMobilityInformation_SNPN_sequence[] = {
  { &hf_xnap_serving_NID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPNMobilityInformation_SNPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPNMobilityInformation_SNPN, NPNMobilityInformation_SNPN_sequence);

  return offset;
}


static const per_sequence_t NPNMobilityInformation_PNI_NPN_sequence[] = {
  { &hf_xnap_allowedPNI_NPN_ID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedPNI_NPN_ID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPNMobilityInformation_PNI_NPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPNMobilityInformation_PNI_NPN, NPNMobilityInformation_PNI_NPN_sequence);

  return offset;
}


static const value_string xnap_NPNMobilityInformation_vals[] = {
  {   0, "snpn-mobility-information" },
  {   1, "pni-npn-mobility-information" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPNMobilityInformation_choice[] = {
  {   0, &hf_xnap_snpn_mobility_information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPNMobilityInformation_SNPN },
  {   1, &hf_xnap_pni_npn_mobility_information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPNMobilityInformation_PNI_NPN },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPNMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPNMobilityInformation, NPNMobilityInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPNPagingAssistanceInformation_PNI_NPN_sequence[] = {
  { &hf_xnap_allowedPNI_NPN_ID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedPNI_NPN_ID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPNPagingAssistanceInformation_PNI_NPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPNPagingAssistanceInformation_PNI_NPN, NPNPagingAssistanceInformation_PNI_NPN_sequence);

  return offset;
}


static const value_string xnap_NPNPagingAssistanceInformation_vals[] = {
  {   0, "pni-npn-Information" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPNPagingAssistanceInformation_choice[] = {
  {   0, &hf_xnap_pni_npn_Information_01, ASN1_NO_EXTENSIONS     , dissect_xnap_NPNPagingAssistanceInformation_PNI_NPN },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPNPagingAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPNPagingAssistanceInformation, NPNPagingAssistanceInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPN_Support_SNPN_sequence[] = {
  { &hf_xnap_nid            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NID },
  { &hf_xnap_ie_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPN_Support_SNPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPN_Support_SNPN, NPN_Support_SNPN_sequence);

  return offset;
}


static const value_string xnap_NPN_Support_vals[] = {
  {   0, "sNPN" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NPN_Support_choice[] = {
  {   0, &hf_xnap_sNPN           , ASN1_NO_EXTENSIONS     , dissect_xnap_NPN_Support_SNPN },
  {   1, &hf_xnap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPN_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPN_Support, NPN_Support_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NPRACH_CP_Length_vals[] = {
  {   0, "us66dot7" },
  {   1, "us266dot7" },
  { 0, NULL }
};


static int
dissect_xnap_NPRACH_CP_Length(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_T_anchorCarrier_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersList_NB_r13_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_anchorCarrier_EDT_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_EDT_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersList_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_anchorCarrier_Format2_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_Format2_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_anchorCarrier_Format2_EDT_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_Format2_EDT_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_non_anchorCarrier_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrier_NPRACHConfig);
    dissect_lte_rrc_UL_ConfigCommonList_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_non_anchorCarrier_Format2_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrier_Format2_NPRACHConfig);
    dissect_lte_rrc_UL_ConfigCommonList_NB_v1530_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NPRACHConfiguration_FDD_sequence[] = {
  { &hf_xnap_nprach_CP_length, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NPRACH_CP_Length },
  { &hf_xnap_anchorCarrier_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_anchorCarrier_NPRACHConfig },
  { &hf_xnap_anchorCarrier_EDT_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_anchorCarrier_EDT_NPRACHConfig },
  { &hf_xnap_anchorCarrier_Format2_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_anchorCarrier_Format2_NPRACHConfig },
  { &hf_xnap_anchorCarrier_Format2_EDT_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_anchorCarrier_Format2_EDT_NPRACHConfig },
  { &hf_xnap_non_anchorCarrier_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_non_anchorCarrier_NPRACHConfig },
  { &hf_xnap_non_anchorCarrier_Format2_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_non_anchorCarrier_Format2_NPRACHConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPRACHConfiguration_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPRACHConfiguration_FDD, NPRACHConfiguration_FDD_sequence);

  return offset;
}


static const value_string xnap_NPRACH_preambleFormat_vals[] = {
  {   0, "fmt0" },
  {   1, "fmt1" },
  {   2, "fmt2" },
  {   3, "fmt0a" },
  {   4, "fmt1a" },
  { 0, NULL }
};


static int
dissect_xnap_NPRACH_preambleFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_T_anchorCarrier_NPRACHConfigTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_NPRACHConfigTDD);
    dissect_lte_rrc_NPRACH_ParametersListTDD_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_non_anchorCarrierFrquency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrierFrequency);
    dissect_lte_rrc_DL_CarrierConfigCommon_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t Non_AnchorCarrierFrequencylist_item_sequence[] = {
  { &hf_xnap_non_anchorCarrierFrquency, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_non_anchorCarrierFrquency },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Non_AnchorCarrierFrequencylist_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Non_AnchorCarrierFrequencylist_item, Non_AnchorCarrierFrequencylist_item_sequence);

  return offset;
}


static const per_sequence_t Non_AnchorCarrierFrequencylist_sequence_of[1] = {
  { &hf_xnap_Non_AnchorCarrierFrequencylist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Non_AnchorCarrierFrequencylist_item },
};

static int
dissect_xnap_Non_AnchorCarrierFrequencylist(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Non_AnchorCarrierFrequencylist, Non_AnchorCarrierFrequencylist_sequence_of,
                                                  1, maxnoofNonAnchorCarrierFreqConfig, false);

  return offset;
}



static int
dissect_xnap_T_non_anchorCarrier_NPRACHConfigTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrier_NPRACHConfigTDD);
    dissect_lte_rrc_UL_ConfigCommonListTDD_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NPRACHConfiguration_TDD_sequence[] = {
  { &hf_xnap_nprach_preambleFormat, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NPRACH_preambleFormat },
  { &hf_xnap_anchorCarrier_NPRACHConfigTDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_anchorCarrier_NPRACHConfigTDD },
  { &hf_xnap_non_anchorCarrierFequencyConfiglist, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Non_AnchorCarrierFrequencylist },
  { &hf_xnap_non_anchorCarrier_NPRACHConfigTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_non_anchorCarrier_NPRACHConfigTDD },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPRACHConfiguration_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPRACHConfiguration_TDD, NPRACHConfiguration_TDD_sequence);

  return offset;
}


static const value_string xnap_T_fdd_or_tdd_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t T_fdd_or_tdd_choice[] = {
  {   0, &hf_xnap_fdd            , ASN1_NO_EXTENSIONS     , dissect_xnap_NPRACHConfiguration_FDD },
  {   1, &hf_xnap_tdd            , ASN1_NO_EXTENSIONS     , dissect_xnap_NPRACHConfiguration_TDD },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_T_fdd_or_tdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_T_fdd_or_tdd, T_fdd_or_tdd_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPRACHConfiguration_sequence[] = {
  { &hf_xnap_fdd_or_tdd     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_fdd_or_tdd },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPRACHConfiguration, NPRACHConfiguration_sequence);

  return offset;
}


static const per_sequence_t NG_RAN_Cell_Identity_ListinRANPagingArea_sequence_of[1] = {
  { &hf_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Cell_Identity },
};

static int
dissect_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea, NG_RAN_Cell_Identity_ListinRANPagingArea_sequence_of,
                                                  1, maxnoofCellsinRNA, false);

  return offset;
}



static int
dissect_xnap_NR_U_ChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofNR_UChannelIDs, NULL, true);

  return offset;
}



static int
dissect_xnap_ChannelOccupancyTimePercentage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, true);

  return offset;
}



static int
dissect_xnap_EnergyDetectionThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100, -50, NULL, true);

  return offset;
}


static const per_sequence_t NR_U_Channel_Item_sequence[] = {
  { &hf_xnap_nR_U_ChannelID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_ChannelID },
  { &hf_xnap_channelOccupancyTimePercentageDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ChannelOccupancyTimePercentage },
  { &hf_xnap_energyDetectionThresholdDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EnergyDetectionThreshold },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_U_Channel_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_U_Channel_Item, NR_U_Channel_Item_sequence);

  return offset;
}


static const per_sequence_t NR_U_Channel_List_sequence_of[1] = {
  { &hf_xnap_NR_U_Channel_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_Channel_Item },
};

static int
dissect_xnap_NR_U_Channel_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NR_U_Channel_List, NR_U_Channel_List_sequence_of,
                                                  1, maxnoofNR_UChannelIDs, false);

  return offset;
}


static const value_string xnap_Bandwidth_vals[] = {
  {   0, "mhz10" },
  {   1, "mhz20" },
  {   2, "mhz40" },
  {   3, "mhz60" },
  {   4, "mhz80" },
  {   5, "mhz100" },
  { 0, NULL }
};


static int
dissect_xnap_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t NR_U_ChannelInfo_Item_sequence[] = {
  { &hf_xnap_nR_U_ChannelID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_ChannelID },
  { &hf_xnap_nRARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRARFCN },
  { &hf_xnap_bandwidth      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Bandwidth },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_U_ChannelInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_U_ChannelInfo_Item, NR_U_ChannelInfo_Item_sequence);

  return offset;
}


static const per_sequence_t NR_U_ChannelInfo_List_sequence_of[1] = {
  { &hf_xnap_NR_U_ChannelInfo_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_ChannelInfo_Item },
};

static int
dissect_xnap_NR_U_ChannelInfo_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NR_U_ChannelInfo_List, NR_U_ChannelInfo_List_sequence_of,
                                                  1, maxnoofNR_UChannelIDs, false);

  return offset;
}


static const per_sequence_t NRA2XServicesAuthorized_sequence[] = {
  { &hf_xnap_aerialUE       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AerialUE },
  { &hf_xnap_aerialControllerUE, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AerialControllerUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRA2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRA2XServicesAuthorized, NRA2XServicesAuthorized_sequence);

  return offset;
}



static int
dissect_xnap_NRMobilityHistoryReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_NRMobilityHistoryReport);
    dissect_nr_rrc_VisitedCellInfoList_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NRModeInfoFDD_sequence[] = {
  { &hf_xnap_ulNRFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_dlNRFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_ulNRTransmissonBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_dlNRTransmissonBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRModeInfoFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRModeInfoFDD, NRModeInfoFDD_sequence);

  return offset;
}


static const per_sequence_t NRModeInfoTDD_sequence[] = {
  { &hf_xnap_nrFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_nrTransmissonBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRModeInfoTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRModeInfoTDD, NRModeInfoTDD_sequence);

  return offset;
}


static const value_string xnap_NRModeInfo_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NRModeInfo_choice[] = {
  {   0, &hf_xnap_fdd_01         , ASN1_NO_EXTENSIONS     , dissect_xnap_NRModeInfoFDD },
  {   1, &hf_xnap_tdd_01         , ASN1_NO_EXTENSIONS     , dissect_xnap_NRModeInfoTDD },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NRModeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NRModeInfo, NRModeInfo_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NRPaging_eDRX_Cycle_vals[] = {
  {   0, "hfquarter" },
  {   1, "hfhalf" },
  {   2, "hf1" },
  {   3, "hf2" },
  {   4, "hf4" },
  {   5, "hf8" },
  {   6, "hf16" },
  {   7, "hf32" },
  {   8, "hf64" },
  {   9, "hf128" },
  {  10, "hf256" },
  {  11, "hf512" },
  {  12, "hf1024" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_eDRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_NRPaging_Time_Window_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  {  16, "s17" },
  {  17, "s18" },
  {  18, "s19" },
  {  19, "s20" },
  {  20, "s21" },
  {  21, "s22" },
  {  22, "s23" },
  {  23, "s24" },
  {  24, "s25" },
  {  25, "s26" },
  {  26, "s27" },
  {  27, "s28" },
  {  28, "s29" },
  {  29, "s30" },
  {  30, "s31" },
  {  31, "s32" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_Time_Window(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, true, 16, NULL);

  return offset;
}


static const per_sequence_t NRPagingeDRXInformation_sequence[] = {
  { &hf_xnap_nRPaging_eDRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPaging_eDRX_Cycle },
  { &hf_xnap_nRPaging_Time_Window, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRPaging_Time_Window },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRPagingeDRXInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRPagingeDRXInformation, NRPagingeDRXInformation_sequence);

  return offset;
}


static const value_string xnap_NRPaging_eDRX_Cycle_Inactive_vals[] = {
  {   0, "hfquarter" },
  {   1, "hfhalf" },
  {   2, "hf1" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_eDRX_Cycle_Inactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NRPagingeDRXInformationforRRCINACTIVE_sequence[] = {
  { &hf_xnap_nRPaging_eDRX_Cycle_Inactive, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPaging_eDRX_Cycle_Inactive },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRPagingeDRXInformationforRRCINACTIVE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRPagingeDRXInformationforRRCINACTIVE, NRPagingeDRXInformationforRRCINACTIVE_sequence);

  return offset;
}


static const value_string xnap_NRPaging_long_eDRX_Cycle_Inactive_vals[] = {
  {   0, "hf2" },
  {   1, "hf4" },
  {   2, "hf8" },
  {   3, "hf16" },
  {   4, "hf32" },
  {   5, "hf64" },
  {   6, "hf128" },
  {   7, "hf256" },
  {   8, "hf512" },
  {   9, "hf1024" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_long_eDRX_Cycle_Inactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_NRPaging_Time_Window_Inactive_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  {  16, "s17" },
  {  17, "s18" },
  {  18, "s19" },
  {  19, "s20" },
  {  20, "s21" },
  {  21, "s22" },
  {  22, "s23" },
  {  23, "s24" },
  {  24, "s25" },
  {  25, "s26" },
  {  26, "s27" },
  {  27, "s28" },
  {  28, "s29" },
  {  29, "s30" },
  {  30, "s31" },
  {  31, "s32" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_Time_Window_Inactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NRPagingLongeDRXInformationforRRCINACTIVE_sequence[] = {
  { &hf_xnap_nRPaging_long_eDRX_Cycle_Inactive, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPaging_long_eDRX_Cycle_Inactive },
  { &hf_xnap_nRPaging_Time_Window_Inactive, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPaging_Time_Window_Inactive },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRPagingLongeDRXInformationforRRCINACTIVE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRPagingLongeDRXInformationforRRCINACTIVE, NRPagingLongeDRXInformationforRRCINACTIVE_sequence);

  return offset;
}


static const value_string xnap_NumberOfAntennaPorts_E_UTRA_vals[] = {
  {   0, "an1" },
  {   1, "an2" },
  {   2, "an4" },
  { 0, NULL }
};


static int
dissect_xnap_NumberOfAntennaPorts_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_NonGBRResources_Offered_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_NonGBRResources_Offered(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NRV2XServicesAuthorized_sequence[] = {
  { &hf_xnap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_VehicleUE },
  { &hf_xnap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PedestrianUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRV2XServicesAuthorized, NRV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t NRUESidelinkAggregateMaximumBitRate_sequence[] = {
  { &hf_xnap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRUESidelinkAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRUESidelinkAggregateMaximumBitRate, NRUESidelinkAggregateMaximumBitRate_sequence);

  return offset;
}



static int
dissect_xnap_NSAG_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}


static const value_string xnap_OffsetOfNbiotChannelNumberToEARFCN_vals[] = {
  {   0, "minusTen" },
  {   1, "minusNine" },
  {   2, "minusEightDotFive" },
  {   3, "minusEight" },
  {   4, "minusSeven" },
  {   5, "minusSix" },
  {   6, "minusFive" },
  {   7, "minusFourDotFive" },
  {   8, "minusFour" },
  {   9, "minusThree" },
  {  10, "minusTwo" },
  {  11, "minusOne" },
  {  12, "minusZeroDotFive" },
  {  13, "zero" },
  {  14, "one" },
  {  15, "two" },
  {  16, "three" },
  {  17, "threeDotFive" },
  {  18, "four" },
  {  19, "five" },
  {  20, "six" },
  {  21, "seven" },
  {  22, "sevenDotFive" },
  {  23, "eight" },
  {  24, "nine" },
  { 0, NULL }
};


static int
dissect_xnap_OffsetOfNbiotChannelNumberToEARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     25, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_RequestedSRSTransmissionCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}



static int
dissect_xnap_RoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, false);

  return offset;
}


static const per_sequence_t PositioningInformation_sequence[] = {
  { &hf_xnap_requestedSRSTransmissionCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RequestedSRSTransmissionCharacteristics },
  { &hf_xnap_routingID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RoutingID },
  { &hf_xnap_nRPPaTransactionID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_32767 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PositioningInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PositioningInformation, PositioningInformation_sequence);

  return offset;
}


static const value_string xnap_PagingCause_vals[] = {
  {   0, "voice" },
  { 0, NULL }
};


static int
dissect_xnap_PagingCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PEIPSassistanceInformation_sequence[] = {
  { &hf_xnap_cNsubgroupID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CNsubgroupID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PEIPSassistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PEIPSassistanceInformation, PEIPSassistanceInformation_sequence);

  return offset;
}


static const value_string xnap_PagingDRX_vals[] = {
  {   0, "v32" },
  {   1, "v64" },
  {   2, "v128" },
  {   3, "v256" },
  {   4, "v512" },
  {   5, "v1024" },
  { 0, NULL }
};


static int
dissect_xnap_PagingDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 2, NULL);

  return offset;
}


static const value_string xnap_PagingPriority_vals[] = {
  {   0, "priolevel1" },
  {   1, "priolevel2" },
  {   2, "priolevel3" },
  {   3, "priolevel4" },
  {   4, "priolevel5" },
  {   5, "priolevel6" },
  {   6, "priolevel7" },
  {   7, "priolevel8" },
  { 0, NULL }
};


static int
dissect_xnap_PagingPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_PartialListIndicator_vals[] = {
  {   0, "partial" },
  { 0, NULL }
};


static int
dissect_xnap_PartialListIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PC5FlowBitRates_sequence[] = {
  { &hf_xnap_guaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_maximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PC5FlowBitRates, PC5FlowBitRates_sequence);

  return offset;
}


static const per_sequence_t PC5QoSFlowItem_sequence[] = {
  { &hf_xnap_pQI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_pc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PC5FlowBitRates },
  { &hf_xnap_range          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Range },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PC5QoSFlowItem, PC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t PC5QoSFlowList_sequence_of[1] = {
  { &hf_xnap_PC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PC5QoSFlowItem },
};

static int
dissect_xnap_PC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PC5QoSFlowList, PC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, false);

  return offset;
}


static const per_sequence_t PC5QoSParameters_sequence[] = {
  { &hf_xnap_pc5QoSFlowList , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PC5QoSFlowList },
  { &hf_xnap_pc5LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PC5QoSParameters, PC5QoSParameters_sequence);

  return offset;
}


static const value_string xnap_T_from_S_NG_RAN_node_vals[] = {
  {   0, "s-ng-ran-node-key-update-required" },
  {   1, "pdcp-data-recovery-required" },
  { 0, NULL }
};


static int
dissect_xnap_T_from_S_NG_RAN_node(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_from_M_NG_RAN_node_vals[] = {
  {   0, "pdcp-data-recovery-required" },
  { 0, NULL }
};


static int
dissect_xnap_T_from_M_NG_RAN_node(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_PDCPChangeIndication_vals[] = {
  {   0, "from-S-NG-RAN-node" },
  {   1, "from-M-NG-RAN-node" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PDCPChangeIndication_choice[] = {
  {   0, &hf_xnap_from_S_NG_RAN_node, ASN1_NO_EXTENSIONS     , dissect_xnap_T_from_S_NG_RAN_node },
  {   1, &hf_xnap_from_M_NG_RAN_node, ASN1_NO_EXTENSIONS     , dissect_xnap_T_from_M_NG_RAN_node },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_PDCPChangeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_PDCPChangeIndication, PDCPChangeIndication_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_PDCPDuplicationConfiguration_vals[] = {
  {   0, "configured" },
  {   1, "de-configured" },
  { 0, NULL }
};


static int
dissect_xnap_PDCPDuplicationConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_ulPDCPSNLength_vals[] = {
  {   0, "v12bits" },
  {   1, "v18bits" },
  { 0, NULL }
};


static int
dissect_xnap_T_ulPDCPSNLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_dlPDCPSNLength_vals[] = {
  {   0, "v12bits" },
  {   1, "v18bits" },
  { 0, NULL }
};


static int
dissect_xnap_T_dlPDCPSNLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PDCPSNLength_sequence[] = {
  { &hf_xnap_ulPDCPSNLength , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_ulPDCPSNLength },
  { &hf_xnap_dlPDCPSNLength , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_dlPDCPSNLength },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDCPSNLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDCPSNLength, PDCPSNLength_sequence);

  return offset;
}


static const value_string xnap_T_pduSetIntegratedHandlingInformation_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_pduSetIntegratedHandlingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PDUSetQoSInformation_sequence[] = {
  { &hf_xnap_pduSetDelayBudget, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ExtendedPacketDelayBudget },
  { &hf_xnap_pduSetErrorRate, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_PacketErrorRate },
  { &hf_xnap_pduSetIntegratedHandlingInformation, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_T_pduSetIntegratedHandlingInformation },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSetQoSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSetQoSInformation, PDUSetQoSInformation_sequence);

  return offset;
}


static const per_sequence_t PDUSetQoSParameters_sequence[] = {
  { &hf_xnap_ulPDUSetQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_PDUSetQoSInformation },
  { &hf_xnap_dlPDUSetQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_PDUSetQoSInformation },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSetQoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSetQoSParameters, PDUSetQoSParameters_sequence);

  return offset;
}


static const value_string xnap_PDUSetbasedHandlingIndicator_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_xnap_PDUSetbasedHandlingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PDUSessionAggregateMaximumBitRate_sequence[] = {
  { &hf_xnap_downlink_session_AMBR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_uplink_session_AMBR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionAggregateMaximumBitRate, PDUSessionAggregateMaximumBitRate_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
};

static int
dissect_xnap_PDUSession_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List, PDUSession_List_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSession_List_withCause_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Cause },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSession_List_withCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSession_List_withCause_Item, PDUSession_List_withCause_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_withCause_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_withCause_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_List_withCause_Item },
};

static int
dissect_xnap_PDUSession_List_withCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List_withCause, PDUSession_List_withCause_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingFromTarget_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSession_List_withDataForwardingFromTarget_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSession_List_withDataForwardingFromTarget_Item, PDUSession_List_withDataForwardingFromTarget_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingFromTarget_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_withDataForwardingFromTarget_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_List_withDataForwardingFromTarget_Item },
};

static int
dissect_xnap_PDUSession_List_withDataForwardingFromTarget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List_withDataForwardingFromTarget, PDUSession_List_withDataForwardingFromTarget_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingRequest_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_dataforwardingInfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_dRBtoBeReleasedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBToQoSFlowMapping_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSession_List_withDataForwardingRequest_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSession_List_withDataForwardingRequest_Item, PDUSession_List_withDataForwardingRequest_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingRequest_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_withDataForwardingRequest_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_List_withDataForwardingRequest_Item },
};

static int
dissect_xnap_PDUSession_List_withDataForwardingRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List_withDataForwardingRequest, PDUSession_List_withDataForwardingRequest_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const value_string xnap_UserPlaneErrorIndicator_vals[] = {
  {   0, "gtpu-error-indication-received" },
  { 0, NULL }
};


static int
dissect_xnap_UserPlaneErrorIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PDUSessionsListToBeReleased_UPError_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_userPlaneErrorIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UserPlaneErrorIndicator },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionsListToBeReleased_UPError_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionsListToBeReleased_UPError_Item, PDUSessionsListToBeReleased_UPError_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionsListToBeReleased_UPError_sequence_of[1] = {
  { &hf_xnap_PDUSessionsListToBeReleased_UPError_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionsListToBeReleased_UPError_Item },
};

static int
dissect_xnap_PDUSessionsListToBeReleased_UPError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionsListToBeReleased_UPError, PDUSessionsListToBeReleased_UPError_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourcesNotAdmitted_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Cause },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourcesNotAdmitted_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourcesNotAdmitted_Item, PDUSessionResourcesNotAdmitted_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesNotAdmitted_List_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourcesNotAdmitted_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesNotAdmitted_Item },
};

static int
dissect_xnap_PDUSessionResourcesNotAdmitted_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourcesNotAdmitted_List, PDUSessionResourcesNotAdmitted_List_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const value_string xnap_T_integrityProtectionIndication_vals[] = {
  {   0, "required" },
  {   1, "preferred" },
  {   2, "not-needed" },
  { 0, NULL }
};


static int
dissect_xnap_T_integrityProtectionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_confidentialityProtectionIndication_vals[] = {
  {   0, "required" },
  {   1, "preferred" },
  {   2, "not-needed" },
  { 0, NULL }
};


static int
dissect_xnap_T_confidentialityProtectionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityIndication_sequence[] = {
  { &hf_xnap_integrityProtectionIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_integrityProtectionIndication },
  { &hf_xnap_confidentialityProtectionIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_confidentialityProtectionIndication },
  { &hf_xnap_maximumIPdatarate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumIPdatarate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SecurityIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SecurityIndication, SecurityIndication_sequence);

  return offset;
}


static const value_string xnap_PDUSessionType_vals[] = {
  {   0, "ipv4" },
  {   1, "ipv6" },
  {   2, "ipv4v6" },
  {   3, "ethernet" },
  {   4, "unstructured" },
  { 0, NULL }
};


static int
dissect_xnap_PDUSessionType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_PDUSessionNetworkInstance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, true);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_RAB_ID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeSetup_Item, QoSFlowsToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_Item },
};

static int
dissect_xnap_QoSFlowsToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeSetup_List, QoSFlowsToBeSetup_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t PDUSessionResourcesToBeSetup_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_pduSessionAMBR , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionAggregateMaximumBitRate },
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_source_DL_NG_U_TNL_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_securityIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SecurityIndication },
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_pduSessionNetworkInstance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionNetworkInstance },
  { &hf_xnap_qosFlowsToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourcesToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourcesToBeSetup_Item, PDUSessionResourcesToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesToBeSetup_List_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourcesToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesToBeSetup_Item },
};

static int
dissect_xnap_PDUSessionResourcesToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourcesToBeSetup_List, PDUSessionResourcesToBeSetup_List_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Setup_SNterminated_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_offeredGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item, QoSFlowsToBeSetup_List_Setup_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Setup_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated, QoSFlowsToBeSetup_List_Setup_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupInfo_SNterminated_sequence[] = {
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_pduSessionNetworkInstance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionNetworkInstance },
  { &hf_xnap_qosFlowsToBeSetup_List_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_securityIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SecurityIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupInfo_SNterminated, PDUSessionResourceSetupInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t UPTransportParametersItem_sequence[] = {
  { &hf_xnap_upTNLInfo      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_cellGroupID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellGroupID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UPTransportParametersItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UPTransportParametersItem, UPTransportParametersItem_sequence);

  return offset;
}


static const per_sequence_t UPTransportParameters_sequence_of[1] = {
  { &hf_xnap_UPTransportParameters_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParametersItem },
};

static int
dissect_xnap_UPTransportParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_UPTransportParameters, UPTransportParameters_sequence_of,
                                                  1, maxnoofSCellGroupsplus1, false);

  return offset;
}


static const value_string xnap_UL_UE_Configuration_vals[] = {
  {   0, "no-data" },
  {   1, "shared" },
  {   2, "only" },
  { 0, NULL }
};


static int
dissect_xnap_UL_UE_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ULConfiguration_sequence[] = {
  { &hf_xnap_uL_PDCP        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_UE_Configuration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ULConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ULConfiguration, ULConfiguration_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mCGRequestedGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item, QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated, QoSFlowsMappedtoDRB_SetupResponse_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_SetupResponse_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_pDCP_SNLength  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPSNLength },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RLCMode },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_SetupResponse_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item, DRBsToBeSetupList_SetupResponse_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_SetupResponse_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated, DRBsToBeSetupList_SetupResponse_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const value_string xnap_T_integrityProtectionResult_vals[] = {
  {   0, "performed" },
  {   1, "not-performed" },
  { 0, NULL }
};


static int
dissect_xnap_T_integrityProtectionResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_confidentialityProtectionResult_vals[] = {
  {   0, "performed" },
  {   1, "not-performed" },
  { 0, NULL }
};


static int
dissect_xnap_T_confidentialityProtectionResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityResult_sequence[] = {
  { &hf_xnap_integrityProtectionResult, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_integrityProtectionResult },
  { &hf_xnap_confidentialityProtectionResult, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_confidentialityProtectionResult },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SecurityResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SecurityResult, SecurityResult_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupResponseInfo_SNterminated_sequence[] = {
  { &hf_xnap_dL_NG_U_TNLatNG_RAN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dRBsToBeSetup  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_qosFlowsNotAdmittedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_securityResult , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SecurityResult },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupResponseInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupResponseInfo_SNterminated, PDUSessionResourceSetupResponseInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_Setup_MNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qoSFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item, QoSFlowsMappedtoDRB_Setup_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_Setup_MNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item },
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated, QoSFlowsMappedtoDRB_Setup_MNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_Setup_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RLCMode },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_pDCP_SNLength  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPSNLength },
  { &hf_xnap_secondary_MN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_Setup_MNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetupList_Setup_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetupList_Setup_MNterminated_Item, DRBsToBeSetupList_Setup_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_Setup_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeSetupList_Setup_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_Setup_MNterminated_Item },
};

static int
dissect_xnap_DRBsToBeSetupList_Setup_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeSetupList_Setup_MNterminated, DRBsToBeSetupList_Setup_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupInfo_MNterminated_sequence[] = {
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_dRBsToBeSetup_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_Setup_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupInfo_MNterminated, PDUSessionResourceSetupInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_SetupResponse_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item, DRBsAdmittedList_SetupResponse_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_SetupResponse_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsAdmittedList_SetupResponse_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item },
};

static int
dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated, DRBsAdmittedList_SetupResponse_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupResponseInfo_MNterminated_sequence[] = {
  { &hf_xnap_dRBsAdmittedList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupResponseInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupResponseInfo_MNterminated, PDUSessionResourceSetupResponseInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_currentQoSParaSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSParaSetIndex },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item, QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_MNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item },
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated, QoSFlowsMappedtoDRB_SetupResponse_MNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Modified_SNterminated_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_offeredGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item, QoSFlowsToBeSetup_List_Modified_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Modified_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated, QoSFlowsToBeSetup_List_Modified_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const value_string xnap_Reestablishment_Indication_vals[] = {
  {   0, "reestablished" },
  { 0, NULL }
};


static int
dissect_xnap_Reestablishment_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RLC_Status_sequence[] = {
  { &hf_xnap_reestablishment_Indication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Reestablishment_Indication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RLC_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RLC_Status, RLC_Status_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_Modified_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_MN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_rlc_status     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLC_Status },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModified_List_Modified_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModified_List_Modified_SNterminated_Item, DRBsToBeModified_List_Modified_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_Modified_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModified_List_Modified_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModified_List_Modified_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModified_List_Modified_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModified_List_Modified_SNterminated, DRBsToBeModified_List_Modified_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationInfo_SNterminated_sequence[] = {
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_pduSessionNetworkInstance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionNetworkInstance },
  { &hf_xnap_qosFlowsToBeSetup_List_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_qosFlowsToBeModified_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated },
  { &hf_xnap_qoSFlowsToBeReleased_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_drbsToBeModifiedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModified_List_Modified_SNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationInfo_SNterminated, PDUSessionResourceModificationInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_ModificationResponse_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_qoSFlowsMappedtoDRB_SetupResponse_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item, DRBsToBeModifiedList_ModificationResponse_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_ModificationResponse_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated, DRBsToBeModifiedList_ModificationResponse_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationResponseInfo_SNterminated_sequence[] = {
  { &hf_xnap_dL_NG_U_TNLatNG_RAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dRBsToBeSetup  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_dRBsToBeModified, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_qosFlowsNotAdmittedTBAdded, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_qosFlowsReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationResponseInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationResponseInfo_SNterminated, PDUSessionResourceModificationResponseInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_Modification_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_secondary_MN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_pdcpDuplicationConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPDuplicationConfiguration },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_Setup_MNterminated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item, DRBsToBeModifiedList_Modification_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_Modification_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModifiedList_Modification_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModifiedList_Modification_MNterminated, DRBsToBeModifiedList_Modification_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationInfo_MNterminated_sequence[] = {
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_dRBsToBeSetup_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetupList_Setup_MNterminated },
  { &hf_xnap_dRBsToBeModified_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationInfo_MNterminated, PDUSessionResourceModificationInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModificationResponse_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item, DRBsAdmittedList_ModificationResponse_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModificationResponse_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item },
};

static int
dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated, DRBsAdmittedList_ModificationResponse_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationResponseInfo_MNterminated_sequence[] = {
  { &hf_xnap_dRBsAdmittedList_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated },
  { &hf_xnap_dRBsReleasedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List },
  { &hf_xnap_dRBsNotAdmittedSetupModifyList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationResponseInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationResponseInfo_MNterminated, PDUSessionResourceModificationResponseInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeRequiredInfo_SNterminated_sequence[] = {
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeRequiredInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeRequiredInfo_SNterminated, PDUSessionResourceChangeRequiredInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeRequiredInfo_MNterminated_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeRequiredInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeRequiredInfo_MNterminated, PDUSessionResourceChangeRequiredInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeConfirmInfo_MNterminated_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeConfirmInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeConfirmInfo_MNterminated, PDUSessionResourceChangeConfirmInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mCGRequestedGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item, QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated, QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t DRBsToBeSetup_List_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_pDCP_SNLength  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPSNLength },
  { &hf_xnap_sn_UL_PDCP_UPTNLinfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RLCMode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item, DRBsToBeSetup_List_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeSetup_List_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated, DRBsToBeSetup_List_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mCGRequestedGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item, QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated, QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_pdcpDuplicationConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPDuplicationConfiguration },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item, DRBsToBeModified_List_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModified_List_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated, DRBsToBeModified_List_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModRqdInfo_SNterminated_sequence[] = {
  { &hf_xnap_dL_NG_U_TNLatNG_RAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_qoSFlowsToBeReleased_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_drbsToBeSetupList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated },
  { &hf_xnap_drbsToBeModifiedList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModRqdInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModRqdInfo_SNterminated, PDUSessionResourceModRqdInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModConfirm_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_DL_CG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_MN_DL_CG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item, DRBsAdmittedList_ModConfirm_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModConfirm_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsAdmittedList_ModConfirm_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item },
};

static int
dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated, DRBsAdmittedList_ModConfirm_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModConfirmInfo_SNterminated_sequence[] = {
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dRBsAdmittedList_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated },
  { &hf_xnap_dRBsNotAdmittedSetupModifyList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModConfirmInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModConfirmInfo_SNterminated, PDUSessionResourceModConfirmInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_DL_SCG_UP_TNLInfo_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_rlc_status     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLC_Status },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item, DRBsToBeModified_List_ModRqd_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModified_List_ModRqd_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated, DRBsToBeModified_List_ModRqd_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModRqdInfo_MNterminated_sequence[] = {
  { &hf_xnap_dRBsToBeModified_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModRqdInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModRqdInfo_MNterminated, PDUSessionResourceModRqdInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModConfirmInfo_MNterminated_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModConfirmInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModConfirmInfo_MNterminated, PDUSessionResourceModConfirmInfo_MNterminated_sequence);

  return offset;
}


static const value_string xnap_T_rATType_vals[] = {
  {   0, "nr" },
  {   1, "eutra" },
  {   2, "nr-unlicensed" },
  {   3, "e-utra-unlicensed" },
  { 0, NULL }
};


static int
dissect_xnap_T_rATType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 2, NULL);

  return offset;
}



static int
dissect_xnap_T_startTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, &timestamp_tvb);



  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }

  return offset;
}



static int
dissect_xnap_T_endTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, &timestamp_tvb);



  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }

  return offset;
}



static int
dissect_xnap_INTEGER_0_18446744073709551615(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(18446744073709551615), NULL, false);

  return offset;
}


static const per_sequence_t VolumeTimedReport_Item_sequence[] = {
  { &hf_xnap_startTimeStamp , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_startTimeStamp },
  { &hf_xnap_endTimeStamp   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_endTimeStamp },
  { &hf_xnap_usageCountUL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_18446744073709551615 },
  { &hf_xnap_usageCountDL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_18446744073709551615 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_VolumeTimedReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_VolumeTimedReport_Item, VolumeTimedReport_Item_sequence);

  return offset;
}


static const per_sequence_t VolumeTimedReportList_sequence_of[1] = {
  { &hf_xnap_VolumeTimedReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_VolumeTimedReport_Item },
};

static int
dissect_xnap_VolumeTimedReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_VolumeTimedReportList, VolumeTimedReportList_sequence_of,
                                                  1, maxnooftimeperiods, false);

  return offset;
}


static const per_sequence_t PDUSessionUsageReport_sequence[] = {
  { &hf_xnap_rATType        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rATType },
  { &hf_xnap_pDUSessionTimedReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_VolumeTimedReportList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionUsageReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionUsageReport, PDUSessionUsageReport_sequence);

  return offset;
}


static const value_string xnap_T_rATType_01_vals[] = {
  {   0, "nr" },
  {   1, "eutra" },
  {   2, "nr-unlicensed" },
  {   3, "e-utra-unlicensed" },
  { 0, NULL }
};


static int
dissect_xnap_T_rATType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 2, NULL);

  return offset;
}


static const per_sequence_t QoSFlowsUsageReport_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_rATType_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rATType_01 },
  { &hf_xnap_qoSFlowsTimedReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_VolumeTimedReportList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsUsageReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsUsageReport_Item, QoSFlowsUsageReport_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsUsageReportList_sequence_of[1] = {
  { &hf_xnap_QoSFlowsUsageReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsUsageReport_Item },
};

static int
dissect_xnap_QoSFlowsUsageReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsUsageReportList, QoSFlowsUsageReportList_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t SecondaryRATUsageInformation_sequence[] = {
  { &hf_xnap_pDUSessionUsageReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionUsageReport },
  { &hf_xnap_qosFlowsUsageReportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsUsageReportList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SecondaryRATUsageInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SecondaryRATUsageInformation, SecondaryRATUsageInformation_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSecondaryRATUsageItem_sequence[] = {
  { &hf_xnap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_secondaryRATUsageInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SecondaryRATUsageInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSecondaryRATUsageItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSecondaryRATUsageItem, PDUSessionResourceSecondaryRATUsageItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSecondaryRATUsageList_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourceSecondaryRATUsageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourceSecondaryRATUsageItem },
};

static int
dissect_xnap_PDUSessionResourceSecondaryRATUsageList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourceSecondaryRATUsageList, PDUSessionResourceSecondaryRATUsageList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_xnap_PDUSessionCommonNetworkInstance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}



static int
dissect_xnap_PDUSession_PairID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}


static const per_sequence_t PosPartialUEContextInfo_sequence[] = {
  { &hf_xnap_requestedSRSTransmissionCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RequestedSRSTransmissionCharacteristics },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PosPartialUEContextInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PosPartialUEContextInfo, PosPartialUEContextInfo_sequence);

  return offset;
}


static const value_string xnap_T_resourceType_vals[] = {
  {   0, "downlinknonCRS" },
  {   1, "cRS" },
  {   2, "uplink" },
  { 0, NULL }
};


static int
dissect_xnap_T_resourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_84_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     84, 84, true, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_6_110_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 110, true, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_320_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 320U, NULL, true);

  return offset;
}



static int
dissect_xnap_INTEGER_1_20_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 20U, NULL, true);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAFootprintTimePattern_sequence[] = {
  { &hf_xnap_protectedFootprintTimeperiodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_320_ },
  { &hf_xnap_protectedFootrpintStartTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_20_ },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtectedE_UTRAFootprintTimePattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtectedE_UTRAFootprintTimePattern, ProtectedE_UTRAFootprintTimePattern_sequence);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAResource_Item_sequence[] = {
  { &hf_xnap_resourceType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_resourceType },
  { &hf_xnap_intra_PRBProtectedResourceFootprint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_84_ },
  { &hf_xnap_protectedFootprintFrequencyPattern, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6_110_ },
  { &hf_xnap_protectedFootprintTimePattern, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtectedE_UTRAFootprintTimePattern },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtectedE_UTRAResource_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtectedE_UTRAResource_Item, ProtectedE_UTRAResource_Item_sequence);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAResourceList_sequence_of[1] = {
  { &hf_xnap_ProtectedE_UTRAResourceList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtectedE_UTRAResource_Item },
};

static int
dissect_xnap_ProtectedE_UTRAResourceList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ProtectedE_UTRAResourceList, ProtectedE_UTRAResourceList_sequence_of,
                                                  1, maxnoofProtectedResourcePatterns, false);

  return offset;
}



static int
dissect_xnap_INTEGER_1_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, false);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAResourceIndication_sequence[] = {
  { &hf_xnap_activationSFN  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ActivationSFN },
  { &hf_xnap_protectedResourceList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtectedE_UTRAResourceList },
  { &hf_xnap_mbsfnControlRegionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBSFNControlRegionLength },
  { &hf_xnap_pDCCHRegionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_3 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtectedE_UTRAResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtectedE_UTRAResourceIndication, ProtectedE_UTRAResourceIndication_sequence);

  return offset;
}


static const value_string xnap_PrivacyIndicator_vals[] = {
  {   0, "immediate-MDT" },
  {   1, "logged-MDT" },
  { 0, NULL }
};


static int
dissect_xnap_PrivacyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_PSCellChangeHistory_vals[] = {
  {   0, "reporting-full-history" },
  { 0, NULL }
};


static int
dissect_xnap_PSCellChangeHistory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_PSCellHistoryInformationRetrieve_vals[] = {
  {   0, "query" },
  { 0, NULL }
};


static int
dissect_xnap_PSCellHistoryInformationRetrieve(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_xnap_PSCellListContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_PSCellListContainer);
    dissect_lte_rrc_CellIdListNR_r18_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t PNI_NPN_AreaScopeofMDT_sequence[] = {
  { &hf_xnap_cAGListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CAGListforMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PNI_NPN_AreaScopeofMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PNI_NPN_AreaScopeofMDT, PNI_NPN_AreaScopeofMDT_sequence);

  return offset;
}


static const per_sequence_t PNI_NPNBasedMDT_sequence[] = {
  { &hf_xnap_cAGListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CAGListforMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PNI_NPNBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PNI_NPNBasedMDT, PNI_NPNBasedMDT_sequence);

  return offset;
}



static int
dissect_xnap_QOEReference(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, false, NULL);

  return offset;
}



static int
dissect_xnap_QOEMeasConfAppLayerID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}


static const value_string xnap_ServiceType_vals[] = {
  {   0, "qMC-for-streaming-service" },
  {   1, "qMC-for-MTSI-service" },
  {   2, "qMC-for-VR-service" },
  { 0, NULL }
};


static int
dissect_xnap_ServiceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_QOEMeasStatus_vals[] = {
  {   0, "ongoing" },
  { 0, NULL }
};


static int
dissect_xnap_QOEMeasStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t S_NSSAIListQoE_sequence_of[1] = {
  { &hf_xnap_S_NSSAIListQoE_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
};

static int
dissect_xnap_S_NSSAIListQoE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_S_NSSAIListQoE, S_NSSAIListQoE_sequence_of,
                                                  1, maxnoofSNSSAIforQMC, false);

  return offset;
}


static const per_sequence_t UEAppLayerMeasConfigInfo_sequence[] = {
  { &hf_xnap_qOEReference   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QOEReference },
  { &hf_xnap_qOEMeasConfigAppLayerID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QOEMeasConfAppLayerID },
  { &hf_xnap_serviceType    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ServiceType },
  { &hf_xnap_qOEMeasStatus  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QOEMeasStatus },
  { &hf_xnap_containerAppLayerMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ContainerAppLayerMeasConfig },
  { &hf_xnap_mDTAlignmentInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDTAlignmentInfo },
  { &hf_xnap_measCollectionEntityIPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MeasCollectionEntityIPAddress },
  { &hf_xnap_areaScopeOfQMC , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfQMC },
  { &hf_xnap_s_NSSAIListQoE , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_S_NSSAIListQoE },
  { &hf_xnap_availableRVQoEMetrics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AvailableRVQoEMetrics },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEAppLayerMeasConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEAppLayerMeasConfigInfo, UEAppLayerMeasConfigInfo_sequence);

  return offset;
}


static const per_sequence_t UEAppLayerMeasInfo_Item_sequence[] = {
  { &hf_xnap_uEAppLayerMeasConfigInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UEAppLayerMeasConfigInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEAppLayerMeasInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEAppLayerMeasInfo_Item, UEAppLayerMeasInfo_Item_sequence);

  return offset;
}


static const per_sequence_t UEAppLayerMeasInfoList_sequence_of[1] = {
  { &hf_xnap_UEAppLayerMeasInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_UEAppLayerMeasInfo_Item },
};

static int
dissect_xnap_UEAppLayerMeasInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_UEAppLayerMeasInfoList, UEAppLayerMeasInfoList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, false);

  return offset;
}


static const per_sequence_t QMCConfigInfo_sequence[] = {
  { &hf_xnap_uEAppLayerMeasInfoList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UEAppLayerMeasInfoList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QMCConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QMCConfigInfo, QMCConfigInfo_sequence);

  return offset;
}


static const value_string xnap_T_qoEReportingPathRequest_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_xnap_T_qoEReportingPathRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_rVQoEReportingPathRequest_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_xnap_T_rVQoEReportingPathRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEInterestInquiry_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEInterestInquiry(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEReportingPathInquiry_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEReportingPathInquiry(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_RVQoEReportingPeriodicity_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  { 0, NULL }
};


static int
dissect_xnap_RVQoEReportingPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RVQoEConfig_sequence[] = {
  { &hf_xnap_availableRANVisibleQoEMetrics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AvailableRVQoEMetrics },
  { &hf_xnap_reportingPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RVQoEReportingPeriodicity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RVQoEConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RVQoEConfig, RVQoEConfig_sequence);

  return offset;
}


static const value_string xnap_T_configReleaseIndication_vals[] = {
  {   0, "rvqoe" },
  {   1, "qoe-and-rvqoe" },
  { 0, NULL }
};


static int
dissect_xnap_T_configReleaseIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MN_to_SN_QMCCoordRequestList_Item_sequence[] = {
  { &hf_xnap_qOEReference   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QOEReference },
  { &hf_xnap_qOEMeasConfigAppLayerID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QOEMeasConfAppLayerID },
  { &hf_xnap_measCollectionEntityIPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MeasCollectionEntityIPAddress },
  { &hf_xnap_qoEReportingPathRequest, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_qoEReportingPathRequest },
  { &hf_xnap_rVQoEReportingPathRequest, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_rVQoEReportingPathRequest },
  { &hf_xnap_furtherRVQoEInterestInquiry, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEInterestInquiry },
  { &hf_xnap_furtherRVQoEReportingPathInquiry, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEReportingPathInquiry },
  { &hf_xnap_currentRVQoEConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RVQoEConfig },
  { &hf_xnap_availableRVQoEMetrics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AvailableRVQoEMetrics },
  { &hf_xnap_configReleaseIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_configReleaseIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MN_to_SN_QMCCoordRequestList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MN_to_SN_QMCCoordRequestList_Item, MN_to_SN_QMCCoordRequestList_Item_sequence);

  return offset;
}


static const per_sequence_t MN_to_SN_QMCCoordRequestList_sequence_of[1] = {
  { &hf_xnap_MN_to_SN_QMCCoordRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MN_to_SN_QMCCoordRequestList_Item },
};

static int
dissect_xnap_MN_to_SN_QMCCoordRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MN_to_SN_QMCCoordRequestList, MN_to_SN_QMCCoordRequestList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, false);

  return offset;
}


static const value_string xnap_T_qoEReportingPathRequest_01_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_xnap_T_qoEReportingPathRequest_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_rVQoEReportingPathRequest_01_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_xnap_T_rVQoEReportingPathRequest_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEInterestInquiry_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEInterestInquiry_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEReportingPathInquiry_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEReportingPathInquiry_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_configReleaseIndication_01_vals[] = {
  {   0, "rvqoe" },
  {   1, "qoe-and-rvqoe" },
  { 0, NULL }
};


static int
dissect_xnap_T_configReleaseIndication_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SN_to_MN_QMCCoordRequestList_Item_sequence[] = {
  { &hf_xnap_qOEReference   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QOEReference },
  { &hf_xnap_measCollectionEntityIPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MeasCollectionEntityIPAddress },
  { &hf_xnap_qoEReportingPathRequest_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_qoEReportingPathRequest_01 },
  { &hf_xnap_rVQoEReportingPathRequest_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_rVQoEReportingPathRequest_01 },
  { &hf_xnap_furtherRVQoEInterestInquiry_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEInterestInquiry_01 },
  { &hf_xnap_furtherRVQoEReportingPathInquiry_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEReportingPathInquiry_01 },
  { &hf_xnap_currentRVQoEConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RVQoEConfig },
  { &hf_xnap_availableRVQoEMetrics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AvailableRVQoEMetrics },
  { &hf_xnap_configReleaseIndication_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_configReleaseIndication_01 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SN_to_MN_QMCCoordRequestList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SN_to_MN_QMCCoordRequestList_Item, SN_to_MN_QMCCoordRequestList_Item_sequence);

  return offset;
}


static const per_sequence_t SN_to_MN_QMCCoordRequestList_sequence_of[1] = {
  { &hf_xnap_SN_to_MN_QMCCoordRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SN_to_MN_QMCCoordRequestList_Item },
};

static int
dissect_xnap_SN_to_MN_QMCCoordRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SN_to_MN_QMCCoordRequestList, SN_to_MN_QMCCoordRequestList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, false);

  return offset;
}


static const per_sequence_t QMCCoordinationRequest_sequence[] = {
  { &hf_xnap_mN_to_SN_QMCCoordRequestList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MN_to_SN_QMCCoordRequestList },
  { &hf_xnap_sN_to_MN_QMCCoordRequestList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SN_to_MN_QMCCoordRequestList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QMCCoordinationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QMCCoordinationRequest, QMCCoordinationRequest_sequence);

  return offset;
}


static const value_string xnap_T_qoEConfigSendingPath_vals[] = {
  {   0, "mn" },
  {   1, "sn" },
  { 0, NULL }
};


static int
dissect_xnap_T_qoEConfigSendingPath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_qoEReportingPathResponse_vals[] = {
  {   0, "accepted" },
  {   1, "rejected" },
  { 0, NULL }
};


static int
dissect_xnap_T_qoEReportingPathResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_rVQoEReportingPathResponse_vals[] = {
  {   0, "accepted" },
  {   1, "rejected" },
  { 0, NULL }
};


static int
dissect_xnap_T_rVQoEReportingPathResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEInterestResponse_vals[] = {
  {   0, "interested" },
  {   1, "not-interested" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEInterestResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEReportingPathResponse_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEReportingPathResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MN_to_SN_QMCCoordResponseList_Item_sequence[] = {
  { &hf_xnap_qOEReference   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QOEReference },
  { &hf_xnap_qOEMeasConfigAppLayerID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QOEMeasConfAppLayerID },
  { &hf_xnap_qoEConfigSendingPath, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_qoEConfigSendingPath },
  { &hf_xnap_qoEReportingPathResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_qoEReportingPathResponse },
  { &hf_xnap_rVQoEReportingPathResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_rVQoEReportingPathResponse },
  { &hf_xnap_furtherRVQoEInterestResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEInterestResponse },
  { &hf_xnap_furtherRVQoEReportingPathResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEReportingPathResponse },
  { &hf_xnap_preferredRVQoEConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RVQoEConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MN_to_SN_QMCCoordResponseList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MN_to_SN_QMCCoordResponseList_Item, MN_to_SN_QMCCoordResponseList_Item_sequence);

  return offset;
}


static const per_sequence_t MN_to_SN_QMCCoordResponseList_sequence_of[1] = {
  { &hf_xnap_MN_to_SN_QMCCoordResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MN_to_SN_QMCCoordResponseList_Item },
};

static int
dissect_xnap_MN_to_SN_QMCCoordResponseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MN_to_SN_QMCCoordResponseList, MN_to_SN_QMCCoordResponseList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, false);

  return offset;
}


static const value_string xnap_T_qoEReportingPathResponse_01_vals[] = {
  {   0, "accepted" },
  {   1, "rejected" },
  { 0, NULL }
};


static int
dissect_xnap_T_qoEReportingPathResponse_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_rVQoEReportingPathResponse_01_vals[] = {
  {   0, "accepted" },
  {   1, "rejected" },
  { 0, NULL }
};


static int
dissect_xnap_T_rVQoEReportingPathResponse_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEInterestResponse_01_vals[] = {
  {   0, "interested" },
  {   1, "not-interested" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEInterestResponse_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string xnap_T_furtherRVQoEReportingPathResponse_01_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_xnap_T_furtherRVQoEReportingPathResponse_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SN_to_MN_QMCCoordResponseList_Item_sequence[] = {
  { &hf_xnap_qOEReference   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QOEReference },
  { &hf_xnap_qoEReportingPathResponse_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_qoEReportingPathResponse_01 },
  { &hf_xnap_rVQoEReportingPathResponse_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_rVQoEReportingPathResponse_01 },
  { &hf_xnap_furtherRVQoEInterestResponse_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEInterestResponse_01 },
  { &hf_xnap_furtherRVQoEReportingPathResponse_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_furtherRVQoEReportingPathResponse_01 },
  { &hf_xnap_preferredRVQoEConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RVQoEConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SN_to_MN_QMCCoordResponseList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SN_to_MN_QMCCoordResponseList_Item, SN_to_MN_QMCCoordResponseList_Item_sequence);

  return offset;
}


static const per_sequence_t SN_to_MN_QMCCoordResponseList_sequence_of[1] = {
  { &hf_xnap_SN_to_MN_QMCCoordResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SN_to_MN_QMCCoordResponseList_Item },
};

static int
dissect_xnap_SN_to_MN_QMCCoordResponseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SN_to_MN_QMCCoordResponseList, SN_to_MN_QMCCoordResponseList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, false);

  return offset;
}


static const per_sequence_t QMCCoordinationResponse_sequence[] = {
  { &hf_xnap_mN_to_SN_QMCCoordResponseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MN_to_SN_QMCCoordResponseList },
  { &hf_xnap_sN_to_MN_QMCCoordResponseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SN_to_MN_QMCCoordResponseList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OP