/*
 * This file was generated by running ./tools/make-isobus.py.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * The ISOBUS public listings available from:
 * <https://www.isobus.net/isobus/attachments/isoExport_csv.zip>
 *
 */

#ifndef __PACKET_ISOBUS_PARAMETERS_H__
#define __PACKET_ISOBUS_PARAMETERS_H__

static const value_string _isobus_industry_groups[] = {
    { 0, "Global, applies to all" },
    { 1, "On-Highway Equipment" },
    { 2, "Agricultural and Forestry Equipment" },
    { 3, "Construction Equipment" },
    { 4, "Marine" },
    { 5, "Industrial-Process Control-Stationary (Gen-Sets)" },
    { 6, "Reserved for future assignment by SAE" },
    { 7, "Reserved for future assignment by SAE" },
    { 0, NULL }
};
static value_string_ext isobus_industry_groups_ext = VALUE_STRING_EXT_INIT(_isobus_industry_groups);

/* key: 256 * Industry-Group-ID + Vehicle-Group-ID */
static const value_string _isobus_vehicle_systems[] = {
    { 0x0, "Non-specific System" },
    { 0x7f, "Not Available" },
    { 0x100, "Non-specific System" },
    { 0x101, "Tractor" },
    { 0x102, "Trailer" },
    { 0x17f, "Not Available" },
    { 0x200, "Non-specific System" },
    { 0x201, "Tractor" },
    { 0x202, "Tillage" },
    { 0x203, "Secondary Tillage" },
    { 0x204, "Planters/Seeders" },
    { 0x205, "Fertilizers" },
    { 0x206, "Sprayers" },
    { 0x207, "Harvesters" },
    { 0x208, "Root Harvesters" },
    { 0x209, "Forage" },
    { 0x20a, "Irrigation" },
    { 0x20b, "Transport/Trailer" },
    { 0x20c, "Farm Yard Operations" },
    { 0x20d, "Powered Auxiliary Devices" },
    { 0x20e, "Special Crops" },
    { 0x20f, "Earth Work" },
    { 0x210, "Skidder" },
    { 0x211, "Sensor Systems" },
    { 0x213, "Timber Harvesters" },
    { 0x214, "Forwarders" },
    { 0x215, "Timber Loaders" },
    { 0x216, "Timber Processing Machines" },
    { 0x217, "Mulchers" },
    { 0x218, "Utility Vehicles" },
    { 0x219, "Slurry/Manure Applicators" },
    { 0x21a, "Feeders/Mixers" },
    { 0x21b, "Weeders - Non-chemical weed control." },
    { 0x21c, "Turf and Lawn Care Mowers" },
    { 0x21d, "Product/Material Handling" },
    { 0x27f, "Not Available" },
    { 0x300, "Non-specific system" },
    { 0x301, "Skid Steer Loader" },
    { 0x302, "Articulated Dump Truck" },
    { 0x303, "Backhoe" },
    { 0x304, "Crawler" },
    { 0x305, "Excavator" },
    { 0x306, "Forklift" },
    { 0x307, "Four Wheel Drive Loader" },
    { 0x308, "Grader" },
    { 0x309, "Milling Machine" },
    { 0x30a, "Recycler and Soil Stabilizer" },
    { 0x30b, "Binding Agent Spreader" },
    { 0x30c, "Paver" },
    { 0x30d, "Feeder" },
    { 0x30e, "Screening Plant" },
    { 0x30f, "Stacker" },
    { 0x310, "Roller" },
    { 0x311, "Crusher" },
    { 0x37f, "Not Available" },
    { 0x400, "Non-specific System" },
    { 0x40a, "System tools" },
    { 0x414, "Safety systems" },
    { 0x419, "Gateway" },
    { 0x41e, "Power management and lighting systems" },
    { 0x428, "Steering systems" },
    { 0x432, "Propulsion systems" },
    { 0x43c, "Navigation systems" },
    { 0x446, "Communications systems" },
    { 0x450, "Instrumentation/general systems" },
    { 0x45a, "Environmental (HVAC) systems" },
    { 0x464, "Deck, cargo, and fishing equipment systems" },
    { 0x47f, "Not Available" },
    { 0x500, "Industrial-Process Control-Stationary (Gen-Sets)" },
    { 0x57f, "Not Available" },
    { 0, NULL }
};
static value_string_ext isobus_vehicle_systems_ext = VALUE_STRING_EXT_INIT(_isobus_vehicle_systems);

static const value_string _isobus_global_name_functions[] = {
    { 0, "Engine" },
    { 1, "Auxiliary Power Unit (APU)" },
    { 2, "Electric Propulsion Control" },
    { 3, "Transmission" },
    { 4, "Battery Pack Monitor" },
    { 5, "Shift Control/Console" },
    { 6, "Power TakeOff - (Main or Rear)" },
    { 7, "Axle - Steering" },
    { 8, "Axle - Drive" },
    { 9, "Brakes - System Controller" },
    { 10, "Brakes - Steer Axle" },
    { 11, "Brakes - Drive axle" },
    { 12, "Retarder - Engine" },
    { 13, "Retarder - Driveline" },
    { 14, "Cruise Control" },
    { 15, "Fuel System" },
    { 16, "Steering Controller" },
    { 17, "Suspension - Steer Axle" },
    { 18, "Suspension - Drive Axle" },
    { 19, "Instrument Cluster" },
    { 20, "Trip Recorder" },
    { 21, "Cab Climate Control" },
    { 22, "Aerodynamic Control" },
    { 23, "Vehicle Navigation" },
    { 24, "Vehicle Security" },
    { 25, "Network Interconnect ECU" },
    { 26, "Body Controller" },
    { 27, "Power TakeOff (Secondary or Front)" },
    { 28, "Off Vehicle Gateway" },
    { 29, "Virtual Terminal (in cab)" },
    { 30, "Management Computer" },
    { 31, "Propulsion Battery Charger" },
    { 32, "Headway Controller" },
    { 33, "System Monitor" },
    { 34, "Hydraulic Pump Controller" },
    { 35, "Suspension - System Controller" },
    { 36, "Pneumatic - System Controller" },
    { 37, "Cab Controller" },
    { 38, "Tire Pressure Control" },
    { 39, "Ignition Control Module" },
    { 40, "Seat Control" },
    { 41, "Lighting - Operator Controls" },
    { 42, "Water Pump Control" },
    { 43, "Transmission Display" },
    { 44, "Exhaust Emission Control" },
    { 45, "Vehicle Dynamic Stability Control" },
    { 46, "Oil Sensor Unit" },
    { 47, "Information System Controller" },
    { 48, "Ramp Control" },
    { 49, "Clutch/Converter Control" },
    { 50, "Auxiliary Heater" },
    { 51, "Forward-Looking Collision Warning System" },
    { 52, "Chassis Controller" },
    { 53, "Alternator/Charging System" },
    { 54, "Communications Unit, Cellular" },
    { 55, "Communications Unit, Satellite" },
    { 56, "Communications Unit, Radio" },
    { 57, "Steering Column Unit" },
    { 58, "Fan Drive Control" },
    { 59, "Starter" },
    { 60, "Cab Display" },
    { 61, "File Server / Printer" },
    { 62, "On-Board Diagnostic Unit" },
    { 63, "Engine Valve Controller" },
    { 64, "Endurance Braking" },
    { 65, "Gas Flow Measurement" },
    { 66, "I/O Controller" },
    { 67, "Electrical System Controller" },
    { 68, "Aftertreatment system gas measurement" },
    { 69, "Engine Emission Aftertreatment System" },
    { 70, "Auxiliary Regeneration Device" },
    { 71, "Transfer Case Control" },
    { 72, "Coolant Valve Controller" },
    { 73, "Rollover Detection Control" },
    { 74, "Lubrication System" },
    { 75, "Supplemental Fan" },
    { 76, "Temperature Sensor" },
    { 77, "Fuel Properties Sensor" },
    { 78, "Fire Suppression System" },
    { 79, "Power Systems Manager" },
    { 80, "Electric Powertrain" },
    { 81, "Hydraulic Powertrain" },
    { 82, "File Server" },
    { 83, "Printer" },
    { 84, "Start Aid Device" },
    { 85, "Engine Injection Control Module" },
    { 86, "EV Communication Controller" },
    { 87, "Driver Impairment Device" },
    { 88, "Electric Power Converter" },
    { 89, "Supply Equipment Communication Controller (SECC)" },
    { 90, "Vehicle Adapter Communication Controller (VACC)" },
    { 91, "Accessory Electric Motor Controller" },
    { 92, "Current Sensor" },
    { 93, "" },
    { 0, NULL }
};
static value_string_ext isobus_global_name_functions_ext = VALUE_STRING_EXT_INIT(_isobus_global_name_functions);

/* key: 65536 * Industry-Group-ID + 256 * Vehicle-System-ID + Function-ID */
static const value_string _isobus_ig_specific_name_functions[] = {
    { 0x80, "Reserved" },
    { 0x81, "Off-board diagnostic-service tool" },
    { 0x82, "On-board data logger" },
    { 0x83, "PC Keyboard" },
    { 0x84, "Safety Restraint System" },
    { 0x85, "Turbocharger" },
    { 0x86, "Ground based speed sensor" },
    { 0x87, "Keypad" },
    { 0x88, "Humidity sensor" },
    { 0x89, "Thermal Management System Controller" },
    { 0x8a, "Brake Stroke Alert" },
    { 0x8b, "On-board axle group scale" },
    { 0x8c, "On-board axle group display" },
    { 0x8d, "Battery Charger" },
    { 0x8e, "Turbocharger Compressor Bypass" },
    { 0x8f, "Turbocharger Wastegate" },
    { 0x90, "Throttle" },
    { 0x91, "Inertial Sensor" },
    { 0x92, "Fuel Actuator" },
    { 0x93, "Engine Exhaust Gas Recirculation" },
    { 0x94, "Engine Exhaust Backpressure" },
    { 0x95, "On-board bin weighing scale" },
    { 0x96, "On-board bin weighing scale display" },
    { 0x97, "Engine Cylinder Pressure Monitoring System" },
    { 0x98, "Object Detection" },
    { 0x99, "Object Detection Display" },
    { 0x9a, "Object Detection Sensor" },
    { 0x9b, "Personnel Detection Device" },
    { 0xff, "Not Available" },
    { 0x7fff, "Not Available" },
    { 0x10080, "Tachograph" },
    { 0x10081, "Door Controller" },
    { 0x10082, "Articulation Turntable Control" },
    { 0x10083, "Body-to-Vehicle Interface Control" },
    { 0x10084, "Slope Sensor" },
    { 0x10086, "Retarder Display" },
    { 0x10087, "Differential Lock Controller" },
    { 0x10088, "Low-Voltage Disconnect" },
    { 0x10089, "Roadway Information" },
    { 0x1008a, "Automated Driving" },
    { 0x100ff, "Not Available" },
    { 0x10180, "Forward Road Image Processing" },
    { 0x10181, "Fifth Wheel Smart System" },
    { 0x10182, "Catalyst Fluid Sensor" },
    { 0x10183, "Adaptive Front Lighting System" },
    { 0x10184, "Idle Control System" },
    { 0x10185, "User Interface System" },
    { 0x101ff, "Not Available" },
    { 0x102ff, "Not Available" },
    { 0x17fff, "Not Available" },
    { 0x20080, "Non Virtual Terminal Display" },
    { 0x20081, "Operator Controls - Machine Specific" },
    { 0x20082, "Task Controller (Mapping Computer)" },
    { 0x20083, "Position Control" },
    { 0x20084, "Machine Control" },
    { 0x20085, "Foreign Object Detection" },
    { 0x20086, "Tractor ECU" },
    { 0x20087, "Sequence Control Master" },
    { 0x20088, "Product Dosing" },
    { 0x20089, "Product Treatment" },
    { 0x2008a, "reserved" },
    { 0x2008b, "Data Logger" },
    { 0x2008c, "Decision Support" },
    { 0x2008d, "Lighting Controller" },
    { 0x2008e, "TIM Server" },
    { 0x200ff, "Not Available" },
    { 0x20181, "Auxiliary Valve Control" },
    { 0x20182, "Rear Hitch Control" },
    { 0x20183, "Front Hitch Control" },
    { 0x20184, "Tractor Machine Control" },
    { 0x20186, "Center Hitch Control" },
    { 0x201ff, "Not Available" },
    { 0x20284, "Tillage Machine Control" },
    { 0x20287, "Tillage Depth Control" },
    { 0x20288, "Frame Control" },
    { 0x202ff, "Not Available" },
    { 0x20384, "Secondary Tillage Machine Control" },
    { 0x20387, "Secondary Tillage Depth Control" },
    { 0x20388, "Frame Control" },
    { 0x203ff, "Not Available" },
    { 0x20480, "Seed Rate Control" },
    { 0x20481, "Section On/Off Control" },
    { 0x20483, "Position Control" },
    { 0x20484, "Planters/ Seeders Machine Control" },
    { 0x20485, "Product Flow" },
    { 0x20486, "Product Level" },
    { 0x20487, "Depth Control" },
    { 0x20488, "Frame Control" },
    { 0x20489, "Down Pressure" },
    { 0x204ff, "Not Available" },
    { 0x20580, "Fertilize Rate Control" },
    { 0x20581, "Section On/Off Control" },
    { 0x20582, "Product Pressure" },
    { 0x20583, "Position Control" },
    { 0x20584, "Fertilizers Machine Control" },
    { 0x20585, "Product Flow" },
    { 0x20586, "Product Level" },
    { 0x20587, "Height/Depth Control" },
    { 0x20588, "Frame Control" },
    { 0x205ff, "Not Available" },
    { 0x20680, "Spray Rate Control" },
    { 0x20681, "Section On/Off Control" },
    { 0x20682, "Product Pressure" },
    { 0x20683, "Position Control" },
    { 0x20684, "Sprayers Machine Control" },
    { 0x20685, "Product Flow" },
    { 0x20686, "Product Level" },
    { 0x20687, "Boom Height Control" },
    { 0x20688, "Frame Control" },
    { 0x206ff, "Not Available" },
    { 0x20780, "Tailing Monitor" },
    { 0x20781, "Header Control" },
    { 0x20782, "Product Loss Monitor" },
    { 0x20783, "Product Moisture" },
    { 0x20784, "Harvester Machine Control" },
    { 0x20785, "Product Flow" },
    { 0x20786, "Product Level" },
    { 0x20787, "Header Height Control" },
    { 0x207ff, "Not Available" },
    { 0x20884, "Root Harvesters Machine Control" },
    { 0x20885, "Product Flow" },
    { 0x20886, "Product Level" },
    { 0x20887, "Depth Control" },
    { 0x208ff, "Not Available" },
    { 0x20980, "Twine Wrapper Control" },
    { 0x20981, "Product Packaging Control" },
    { 0x20983, "Product Moisture" },
    { 0x20984, "Forage Machine Control" },
    { 0x20985, "Product Flow" },
    { 0x20987, "Working Height Control" },
    { 0x209ff, "Not Available" },
    { 0x20aff, "Not Available" },
    { 0x20b84, "Transport Machine Control" },
    { 0x20b88, "Unload Control" },
    { 0x20bff, "Not Available" },
    { 0x20cff, "Not Available" },
    { 0x20d84, "Powered Devices Machine Control" },
    { 0x20dff, "Not Available" },
    { 0x20e84, "Special Crop Machine Control" },
    { 0x20eff, "Not Available" },
    { 0x20f80, "Material Rate Control" },
    { 0x20f84, "Earthworks Machine Control" },
    { 0x20f85, "Material Flow" },
    { 0x20f86, "Material Level" },
    { 0x20f87, "Depth Control" },
    { 0x20fff, "Not Available" },
    { 0x21084, "Skidder Machine Control" },
    { 0x210ff, "Not Available" },
    { 0x21180, "Guidance Feeler" },
    { 0x21181, "Camera System" },
    { 0x21182, "Crop Scouting " },
    { 0x21183, "Material Properties Sensing" },
    { 0x21184, "Inertial Measurement Unit (IMU)" },
    { 0x21185, "Product flow" },
    { 0x21186, "Product Level " },
    { 0x21187, "Product Mass" },
    { 0x21188, "Vibration/Knock" },
    { 0x21189, "Weather Instruments" },
    { 0x2118a, "Soil Scouting" },
    { 0x21384, "Timber Harvestors Machine Control" },
    { 0x21484, "Forwarders Machine Control" },
    { 0x21584, "Timber Loaders Machine Control" },
    { 0x21684, "Timber Processing Machine Control" },
    { 0x21784, "Mulcher Machine Control" },
    { 0x21884, "Utility Machine Control" },
    { 0x21980, "Slurry/Manure Rate Control" },
    { 0x21981, "Section On/Off Control" },
    { 0x21982, "Product Pressure" },
    { 0x21984, "Slurry/Manure Machine Control" },
    { 0x21985, "Product Flow" },
    { 0x21986, "Product Level" },
    { 0x21987, "Boom Height Control" },
    { 0x21a80, "Feeder/Mixer Rate Control" },
    { 0x21a81, "Section On/Off Control" },
    { 0x21a82, "Product Pressure" },
    { 0x21a84, "Feeder/Mixer Machine Control" },
    { 0x21a85, "Product Flow" },
    { 0x21a86, "Product Level" },
    { 0x21a87, "Boom Height Control" },
    { 0x21b84, "Weeder Machine Control" },
    { 0x21c84, "Turf and Lawn Care Mowers Machine Control" },
    { 0x21d84, "Product/Material Handling Machine Control" },
    { 0x21d85, "Product/Material Handling Product Flow" },
    { 0x21d86, "Product/Material Handling Product Level" },
    { 0x27fff, "Not Available" },
    { 0x30080, "Supplemental Engine Control Sensing" },
    { 0x30081, "Laser Receiver" },
    { 0x30082, "Land Leveling System Operator Interface" },
    { 0x30083, "Land Leveling Electric Mast" },
    { 0x30084, "Single Land Leveling System Supervisor" },
    { 0x30085, "Land Leveling System Display" },
    { 0x30086, "Laser Tracer" },
    { 0x30087, "Loader Control" },
    { 0x30088, "Slope Sensor" },
    { 0x30089, "Liftarm Control" },
    { 0x3008a, "Supplemental Sensor Processing Units" },
    { 0x3008b, "Hydraulic System Planner" },
    { 0x3008c, "Hydraulic Valve Controller" },
    { 0x3008d, "Joystick Control" },
    { 0x3008e, "Rotation Sensor" },
    { 0x3008f, "Sonic Sensor" },
    { 0x30090, "Survey Total Station Target" },
    { 0x30091, "Heading Sensor" },
    { 0x30092, "Alarm device" },
    { 0x300ff, "Not Available" },
    { 0x30180, "Main Controller" },
    { 0x301ff, "Not Available" },
    { 0x302ff, "Not Available" },
    { 0x303ff, "Not Available" },
    { 0x30480, "Blade Controller" },
    { 0x304ff, "Not Available" },
    { 0x30580, "Slope Sensor" },
    { 0x305ff, "Not Available" },
    { 0x306ff, "Not Available" },
    { 0x307ff, "Not Available" },
    { 0x30880, "HFWD Controller" },
    { 0x308ff, "Not Available" },
    { 0x309ff, "Not Available" },
    { 0x30aff, "Not Available" },
    { 0x30bff, "Not Available" },
    { 0x30cff, "Not Available" },
    { 0x30dff, "Not Available" },
    { 0x30eff, "Not Available" },
    { 0x30fff, "Not Available" },
    { 0x310ff, "Not Available" },
    { 0x311ff, "Not Available" },
    { 0x37fff, "Not Available" },
    { 0x40080, "Alarm System Control for Marine Engines" },
    { 0x40081, "Protection System for Marine Engines" },
    { 0x40082, "Display for Protection System for Marine Engines" },
    { 0x400ff, "Not Available" },
    { 0x40aff, "Not Available" },
    { 0x414ff, "Not Available" },
    { 0x41982, "" },
    { 0x41e82, "Switch " },
    { 0x41e8c, "Load " },
    { 0x42882, "Follow-up Controller" },
    { 0x4288c, "Mode Controller" },
    { 0x42896, "Automatic Steering Controller" },
    { 0x428a0, "Heading Sensors" },
    { 0x43282, "Engineroom monitoring" },
    { 0x4328c, "Engine Interface" },
    { 0x43296, "Engine Controller" },
    { 0x432a0, "Engine Gateway" },
    { 0x432aa, "Control Head" },
    { 0x432b4, "Actuator" },
    { 0x432be, "Gauge Interface" },
    { 0x432c8, "Gauge Large" },
    { 0x432d2, "Gauge Small" },
    { 0x432dc, "Propulsion Sensors & Gateway" },
    { 0x43c82, "Sounder, depth   " },
    { 0x43c8c, "" },
    { 0x43c91, "Global Navigation Satellite System (GNSS)" },
    { 0x43c96, "Loran C" },
    { 0x43c9b, "Speed Sensors" },
    { 0x43ca0, "Turn Rate Indicator" },
    { 0x43caa, "Integrated Navigation   " },
    { 0x43cc8, "Radar and/or Radar Plotting" },
    { 0x43ccd, "Electronic Chart Display & Information System (ECDIS)" },
    { 0x43cd2, "Electronic Chart System (ECS)" },
    { 0x43cdc, "Direction Finder" },
    { 0x44682, "Emergency Position Indicating Beacon (EPIRB)" },
    { 0x4468c, "Automatic Identification System" },
    { 0x44696, "Digital Selective Calling (DSC)" },
    { 0x446a0, "Data Receiver" },
    { 0x446aa, "Satellite" },
    { 0x446b4, "Radio-Telephone (MF/HF)" },
    { 0x446be, "Radio-Telephone (VHF)" },
    { 0x45082, "Time/Date systems" },
    { 0x4508c, "Voyage Data Recorder" },
    { 0x45096, "Integrated Instrumentation" },
    { 0x450a0, "General Purpose Displays" },
    { 0x450aa, "General Sensor Box" },
    { 0x450b4, "Weather Instruments" },
    { 0x450be, "Transducer/general" },
    { 0x450c8, "NMEA 0183 Converter" },
    { 0x45aff, "Not Available" },
    { 0x464ff, "Not Available" },
    { 0x47fff, "Not Available" },
    { 0x50080, "Supplemental Engine Control Sensing" },
    { 0x50081, "Generator Set Controller" },
    { 0x50082, "Generator Voltage Regulator" },
    { 0x50083, "Choke Actuator" },
    { 0x50084, "Well Stimulation Pump" },
    { 0x500ff, "Not Available" },
    { 0x57fff, "Not Available" },
    { 0, NULL }
};
static value_string_ext isobus_ig_specific_name_functions_ext = VALUE_STRING_EXT_INIT(_isobus_ig_specific_name_functions);

static const value_string _isobus_manufacturers[] = {
    { 0, "Reserved" },
    { 1, "Bendix Commercial Vehicle Systems LLC (formerly Allied Signal Inc.)" },
    { 2, "Allison Transmission, Inc." },
    { 3, "Ametek, US Gauge Division" },
    { 4, "Ametek-Dixson" },
    { 5, "AMP Inc." },
    { 6, "Berifors Electronics AB" },
    { 7, "Case Corp." },
    { 8, "Caterpillar Inc." },
    { 9, "Chrysler Corp." },
    { 10, "Cummins Inc (formerly Cummins Engine Co)" },
    { 11, "Dearborn Group Inc." },
    { 12, "Deere & Company, Precision Farming" },
    { 13, "Delco Electronics" },
    { 14, "Detroit Diesel Corporation" },
    { 15, "DICKEY-john Corporation" },
    { 16, "Eaton Corp" },
    { 17, "Eaton Corp, Corp Res & Dev" },
    { 18, "Eaton Corp, Transmission Div." },
    { 19, "Eaton Corp. Trucking Info Services" },
    { 20, "Eaton Ltd" },
    { 21, "Echlin Inc., Midland Brake Inc." },
    { 22, "Ford Motor Co., Electronic Concepts & Systems" },
    { 23, "Ford Motor Co., Heavy Truck" },
    { 24, "Ford Motor Co., Vehicle Controls" },
    { 25, "Daimler Trucks North America LLC (formerly Freightliner LLC)" },
    { 26, "General Motors Corp, Service Technology Grp" },
    { 27, "GMC" },
    { 28, "Grote Ind. Inc." },
    { 29, "Hino Motors Ltd." },
    { 30, "Isuzu Motors Ltd" },
    { 31, "J Pollak Corp" },
    { 32, "Jacobs Vehicle Systems" },
    { 33, "John Deere" },
    { 34, "Kelsey Hayes Co." },
    { 35, "Kenworth Truck Co." },
    { 36, "Lucas Ind." },
    { 37, "Mack Trucks Inc." },
    { 38, "Micro Processor Systems Inc." },
    { 39, "Microfirm Inc." },
    { 40, "Motorola AIEG Inc." },
    { 41, "Motorola Inc." },
    { 42, "International Truck and Engine Corporation - Engine Electronics  (formerly Navistar Intl Trans Co., Engine Electronics)" },
    { 43, "International Truck and Engine Corporation - Vehicle Electronics (formerly Navistar Intl Trans Corp.)" },
    { 44, "Nippondenso Co. Ltd." },
    { 45, "PACCAR" },
    { 46, "Noregon Systems, LLC  (formerly Noregon Systems, Inc)" },
    { 47, "Phillips Semiconductor" },
    { 48, "Pollak Alphabet" },
    { 49, "RE America Inc." },
    { 50, "Robert Bosch Corp" },
    { 51, "Robert Bosch GmbH" },
    { 52, "Meritor Automotive, Inc. (formerly Rockwell Automotive)" },
    { 53, "Continental Automotive Systems US, Inc. (formerly Rockwell Land Transportation)" },
    { 54, "Meritor Wabco" },
    { 55, "Ryder System Inc." },
    { 56, "SAIC" },
    { 57, "Danfoss  (formerly Sauer Sundstrand Co, then Sauer-Danfoss Co)" },
    { 58, "SPX Corporation, OTC Div" },
    { 59, "VES Inc." },
    { 60, "Volvo Trucks North America Inc." },
    { 61, "Volvo Truck Corp." },
    { 62, "Wabco" },
    { 63, "ZF Industries Inc." },
    { 64, "Unused (formerly SpectraPrecision Laserplane, then SpectraPhysics)" },
    { 65, "MAN Nutzfahrzeuge AG" },
    { 66, "John Deere Construction Equipment Division" },
    { 67, "John Deere Coffeyville Works (formerly Funk Manufacturing Company)" },
    { 68, "Scania" },
    { 69, "Trimble Navigation" },
    { 70, "Flex-coil Limited" },
    { 71, "Vansco Electronics Ltd." },
    { 72, "Sisu Corporation" },
    { 73, "LeTourneau, Inc." },
    { 74, "Eaton Axle-Brake Division" },
    { 75, "Deere & Co, Agricultural Division" },
    { 76, "unused (formerly Deere & Co, Construction Division)" },
    { 77, "Deere Power Systems Group" },
    { 78, "Frank W. Murphy Manufacturing, Inc" },
    { 79, "Daimler Benz AG - Engine Division (PBM)" },
    { 80, "Twin Disc, Inc." },
    { 81, "Fire Research Corp." },
    { 82, "Bobcat/Ingersoll-Rand (formerly Melroe/Ingersoll-Rand)" },
    { 83, "Bendix VORAD Technologies (formerly Eaton VORAD Technologies)" },
    { 84, "New Holland UK Limited" },
    { 85, "Kohler Co" },
    { 86, "C. E. Niehoff & Company" },
    { 87, "J.C. Bamford Excavators Ltd (JCB)" },
    { 88, "Hemisphere GPS Inc (formerly Satloc Precision GPS)" },
    { 89, "Kverneland Group, Electronics Division" },
    { 90, "Knorr-Bremse SfN GmbH" },
    { 91, "BSG Bodensee Steuergeraete GmbH" },
    { 92, "Ag-Chem Equipment Co., Inc." },
    { 93, "Perkins Engines Company Ltd." },
    { 94, "CNH Industrial N.V. (formerly CNH Global N.V.)" },
    { 95, "Pacific Insight Electronics Corp." },
    { 96, "Mech@tronic IT GmbH" },
    { 97, "Ag Leader Technology, Inc." },
    { 98, "Mueller-Elektronik GmbH & Co" },
    { 99, "International Transmissions Ltd (ITL)" },
    { 100, "VDO Technik AG" },
    { 101, "Sensoria" },
    { 102, "AGCO (formerly AGCO GmbH & Co.)" },
    { 103, "CLAAS E-Systems GmbH (formerly CLAAS E-Systems KGaA mbH & Co. KG)" },
    { 104, "CLAAS KGaA mbH (formerly CLAAS Selbstfahrende Erntemaschinen GmbH)" },
    { 105, "Kiepe Elektrik GmbH & Co. KG" },
    { 106, "BAE Systems Controls, Inc." },
    { 107, "Grimme Landmaschinen GmbH & Co. KG" },
    { 108, "WTK-Elecktronik GmbH" },
    { 109, "TeeJet Technologies Denmark (formerly LH Technologies ApS)" },
    { 110, "EPIQ Sensor-Nite" },
    { 111, "Bernard Krone Holding SE & Co. KG (formerly Maschinenfabrik Bernard Krone GmbH)" },
    { 112, "MECALAC" },
    { 113, "Stress-Tek, Inc." },
    { 114, "EControls, Inc." },
    { 115, "NACCO Materials Handling Group, Inc." },
    { 116, "BEELINE Technologies" },
    { 117, "HUSCO International" },
    { 118, "Intron GmbH" },
    { 119, "IntegriNautics  " },
    { 120, "RDS Technology Ltd" },
    { 121, "HED (Hydro Electronic Devices, Inc.)" },
    { 122, "FG Wilson (Engineering) Limited" },
    { 123, "Basler Electric" },
    { 124, "Hydac Electronic" },
    { 125, "Nevada Automotive Test Center" },
    { 126, "Driver Tech" },
    { 127, "Holland USA" },
    { 128, "Gerhard Duecker GmbH & Co. KG" },
    { 129, "OMNEX Control Systems Inc." },
    { 130, "Nido - Universal Machines B.V." },
    { 131, "ITT Industries" },
    { 132, "Mulag-Fahrzeugwerk" },
    { 133, "Bucher Schoerling GmbH" },
    { 134, "Iris Technology Ltd" },
    { 135, "Airmar Technology Corporation" },
    { 136, "Komatsu Ltd" },
    { 137, "Maretron" },
    { 138, "Georg Fritzmeier GmbH & Co. KG" },
    { 139, "Caterpillar Trimble Control Technologies (CTCT), LLC" },
    { 140, "Lowrance Electronics, Inc." },
    { 141, "Thales Navigation Ltd." },
    { 142, "TRW Automotive (Commercial Steering Systems)" },
    { 143, "W. Gmeiner GmbH & Co." },
    { 144, "Mercury Marine" },
    { 145, "MurCal Controls" },
    { 146, "Maxima Technologies" },
    { 147, "Nautibus electronic GmbH" },
    { 148, "Blue Water Data, Inc." },
    { 149, "Holset" },
    { 150, "Fleetguard" },
    { 151, "Raven Industries, Inc." },
    { 152, "elobau GmbH & Co. KG" },
    { 153, "Woodward, Industrial Controls Division" },
    { 154, "Westerbeke Corporation" },
    { 155, "Vetronix Corporation" },
    { 156, "ITT Industries - Cannon" },
    { 157, "ISSPRO Inc." },
    { 158, "Firestone Industrial Products Company" },
    { 159, "NTech Industries Inc" },
    { 160, "Nido" },
    { 161, "Offshore Systems (UK) Ltd" },
    { 162, "Axiomatic Technologies" },
    { 163, "BRP Inc." },
    { 164, "MTU Friedrichshafen GmbH (formerly DaimlerChrysler Off-Highway)" },
    { 165, "CPAC Systems AB" },
    { 166, "John Deere Electronic Solutions (formerly Phoenix International)" },
    { 167, "JLG Industries Inc" },
    { 168, "Xantrex" },
    { 169, "Marlin Technologies Inc." },
    { 170, "Computronics Corporation Ltd." },
    { 171, "Topcon Electronics GmbH & Co. KG (formerly Wachendorff Elektronik GmbH & Co. KG)" },
    { 172, "Yanmar Co., Ltd. (formerly Yanmar Marine USA)" },
    { 173, "Ryeso, Inc." },
    { 174, "AB Volvo Penta" },
    { 175, "Veris Technologies, Inc." },
    { 176, "Moritz Aerospace" },
    { 177, "Diagnostic Systems Associates" },
    { 178, "Continental Automotive GmbH (formerly Siemens VDO Automotive AG)" },
    { 179, "TeeJet Technologies Springfield (formerly Midwest Technologies Illinois, LLC)" },
    { 180, "Smart Power Systems" },
    { 181, "Coretronics, Inc." },
    { 182, "Vehicle Systems Engineering B.V." },
    { 183, "KDS Controls, Inc" },
    { 184, "EIA Electronics" },
    { 185, "Beede Electrical Instrument Company" },
    { 186, "Altronic, Inc" },
    { 187, "Air-Weigh" },
    { 188, "EMP Corp" },
    { 189, "QUALCOMM" },
    { 190, "Hella KGaA Hueck & Co" },
    { 191, "XRS Corporation (formerly XATA Corporation)" },
    { 192, "Floscan" },
    { 193, "Jeppesen Marine" },
    { 194, "TriMark Corporation" },
    { 195, "General Engine Products" },
    { 196, "LEMKEN GmbH & Co KG" },
    { 197, "Mechron Power Systems" },
    { 198, "Mystic Valley Communications" },
    { 199, "ACTIA Group (formerly Actia Corp)" },
    { 200, "MGM Brakes" },
    { 201, "Disenos y Tecnologia S.A." },
    { 202, "Curtis Instruments, Inc" },
    { 203, "MILtronik GmbH" },
    { 204, "The Morey Corporation" },
    { 205, "SmarTire Systems Inc" },
    { 206, "port GmbH" },
    { 207, "Otto Engineering" },
    { 208, "Drew Technologies, Inc" },
    { 209, "Bell Equip. Co. SA (PTY) LTD" },
    { 210, "Iteris, Inc." },
    { 211, "DNA Group" },
    { 212, "Sure Power Industries, Inc" },
    { 213, "CNH Belgium N.V." },
    { 214, "MC elettronica Srl" },
    { 215, "Aetna Engineering/Fireboy-Xintex" },
    { 216, "Paneltronics Inc." },
    { 217, "RM Michaelides Software & Elektronik GmbH" },
    { 218, "Gits Manufacturing Company" },
    { 219, "Cat OEM Solutions" },
    { 220, "Beede Electrical Instrument Company, Inc" },
    { 221, "SiE" },
    { 222, "Generac Power Systems, Inc." },
    { 223, "Vaueo Retarder Co., Ltd." },
    { 224, "EMMI Network, S.L." },
    { 225, "SKF" },
    { 226, "Monaco Coach Corporation" },
    { 227, "Lykketronic A/S" },
    { 228, "Unused (formerly ZF Marine Electronics)" },
    { 229, "Garmin International Inc." },
    { 230, "Saucon Technologies" },
    { 231, "Topcon Positioning Systems, Inc." },
    { 232, "TSD Integrated Controls" },
    { 233, "Yacht Monitoring Solutions Inc." },
    { 234, "Mondial electronic GmbH" },
    { 235, "SailorMade Marine Telemetry - Tetra Technology Ltd." },
    { 236, "NORAC Systems International Inc" },
    { 237, "Agtron Enterprises Inc" },
    { 238, "ZF Friedrichshafen AG" },
    { 239, "May & Scofield Ltd" },
    { 240, "Vanair Mfg" },
    { 241, "Schneider Automation SAS" },
    { 242, "Kokusandenki Co. Ltd" },
    { 243, "eRide, Inc." },
    { 244, "Techno-Matic" },
    { 245, "Capstan Ag Systems, Inc." },
    { 246, "Class 1, Inc" },
    { 247, "ePULSE" },
    { 248, "Cooper Standard Automotive Active Systems Group" },
    { 249, "Schaltbau GmbH" },
    { 250, "Kuhn Group" },
    { 251, "German Agricultural Society, Test Center (DLG)" },
    { 252, "Sensor-Technik Wiedemann GmbH" },
    { 253, "Mobile Control Systems" },
    { 254, "GE Sensing" },
    { 255, "MEAS France" },
    { 256, "Tyco Electronics AMP" },
    { 257, "Honda Motor Co., Ltd" },
    { 258, "ARAG" },
    { 259, "Bucher Automation AG (formerly Jetter AG)" },
    { 260, "Reichhardt GmbH Steuerungstechnik" },
    { 261, "Red Dot Corporation" },
    { 262, "HydraForce, Inc" },
    { 263, "IMMI" },
    { 264, "Autolync" },
    { 265, "MTS Sensor Technologie GmbH" },
    { 266, "International Thermal Research Ltd" },
    { 267, "Red Lion Controls, Inc" },
    { 268, "Accurate Technologies" },
    { 269, "Saft America Inc.,  Space & Defense Division" },
    { 270, "Tennant" },
    { 271, "Cole Hersee" },
    { 272, "Gross Mechanical Laboratories, Inc" },
    { 273, "Active Research Limited" },
    { 274, "LTW Technology Co., LTD" },
    { 275, "Navico Egersund AS" },
    { 276, "Aqua-Hot Heating Systems" },
    { 277, "LHP Telematics" },
    { 278, "Takata Electronics" },
    { 279, "Geometris LP" },
    { 280, "Leica Geosystems Pty Ltd" },
    { 281, "Precision Governors LLC" },
    { 282, "Medallion Instrumentation Systems" },
    { 283, "CWF Hamilton & Co Ltd" },
    { 284, "Mobile Tech Chile" },
    { 285, "Sea Recovery Corp" },
    { 286, "Coelmo srl" },
    { 287, "NTech Industries, Inc" },
    { 288, "Mitsubishi FUSO Truck & Bus Corp." },
    { 289, "Watlow" },
    { 290, "Kuebler GmbH" },
    { 291, "Groeneveld Transport Efficiency BV" },
    { 292, "IKUSI - Angel Iglesias S.A." },
    { 293, "Spyder Controls Corp." },
    { 294, "Grayhill Inc." },
    { 295, "BEP Marine" },
    { 296, "micro dynamics GmbH" },
    { 297, "Zonar Systems Inc" },
    { 298, "Holley Performance" },
    { 299, "Rauch" },
    { 300, "Systron Donner Automotive" },
    { 301, "Parker Hannifin (UK) Ltd FDE group" },
    { 302, "Nissin Kogyo Co., LTD" },
    { 303, "CTS Corporation" },
    { 304, "EmpirBus AB" },
    { 305, "NovAtel Inc" },
    { 306, "Sleipner Motor AB" },
    { 307, "MAS Technologies" },
    { 308, "Cyntrx" },
    { 309, "Krauss-Maffei Wegmann GmbH & Co. KG" },
    { 310, "TECNORD srl" },
    { 311, "Patrick Power Products" },
    { 312, "Lectronix, Inc." },
    { 313, "Ilmor Engineering, Inc." },
    { 314, "CSM GmbH" },
    { 315, "Icom Incorporated" },
    { 316, "ITT Flow Control" },
    { 317, "Navtronics Bvba" },
    { 318, "SAT Plan" },
    { 319, "Cadec Global" },
    { 320, "Miedema Landbouwwerktuigenfabriek B.V." },
    { 321, "Ultra Electronics, Electrics" },
    { 322, "MICHENKA s.r.o." },
    { 323, "Mobileye Vision Technologies Ltd." },
    { 324, "Snap-on Diagnostics" },
    { 325, "ASM Automation Sensorik Messtechnik GmbH" },
    { 326, "Akron Brass Company" },
    { 327, "Sonceboz SA" },
    { 328, "Qwerty Electronik AB" },
    { 329, "Deif A/S" },
    { 330, "Kidde Aerospace and Defense" },
    { 331, "Horton, Inc." },
    { 332, "HWH Corporation" },
    { 333, "Link Manufacturing, Ltd. (formerly Hadley Products Corporation)" },
    { 334, "Takata-Petri AG" },
    { 335, "Evo Electric Ltd" },
    { 336, "APE s.r.o." },
    { 337, "Carraro S.p.A." },
    { 338, "GRAF-SYTECO" },
    { 339, "Competence Center ISOBUS e.V." },
    { 340, "Continental AG" },
    { 341, "Boning GmbH & Co" },
    { 342, "THOMAS MAGNETE GmbH" },
    { 343, "Baumer Group" },
    { 344, "Parvus Corporation" },
    { 345, "Korean Maritime University" },
    { 346, "Control Solutions" },
    { 347, "Honeywell" },
    { 348, "Amazonen Werke H. Dreyer" },
    { 349, "Suonentieto" },
    { 350, "Noris Marine Systems GmbH & Co KG" },
    { 351, "Thrane & Thrane" },
    { 352, "SAME DEUTZ-FAHR GROUP S.p.A." },
    { 353, "Hegemon Electronics, Inc." },
    { 354, "Junkkari OY" },
    { 355, "Mastervolt International B.V." },
    { 356, "Fischer Panda Generators, Inc" },
    { 357, "Hardi International A/S" },
    { 358, "Victron Energy B.V." },
    { 359, "Ludwig Bergmann GmbH" },
    { 360, "HJS Emission Technology GmbH & Co KG   (formerly HJS Fahrzeugtechnik GmbH & Co KG)" },
    { 361, "InMach" },
    { 362, "Poettinger Landtechnik GmbH (formerly Alois Poettinger Maschinenfabrik GmbH)" },
    { 363, "BEI Duncan" },
    { 364, "OEM Controls Inc." },
    { 365, "Digi-Star, LLC" },
    { 366, "Viewnyx Corp." },
    { 367, "Fliegl Agrartechnik" },
    { 368, "HANSENHOF_electronic" },
    { 369, "Power Torque Engineering Ltd" },
    { 370, "Rolls-Royce Marine AS" },
    { 371, "Heinzmann GmbH & Co. KG" },
    { 372, "Delphi" },
    { 373, "Electronic Design Inc." },
    { 374, "Northern Lights, Inc." },
    { 375, "Williams Controls Inc." },
    { 376, "Quake Global" },
    { 377, "ifm electronic gmbh" },
    { 378, "Glendinning Marine Products" },
    { 379, "Yamabiko Corporation" },
    { 380, "Suntech International Ltd." },
    { 381, "B & G" },
    { 382, "National Agriculture and Food Research Organization" },
    { 383, "MCL Industries" },
    { 384, "Camano Light" },
    { 385, "Johnson Outdoor Marine Electronics" },
    { 386, "JLG Automation BVBA" },
    { 387, "Orscheln Products, LLC" },
    { 388, "Innomatix, LLC" },
    { 389, "Benchmark Electronics, Minnesota Division" },
    { 390, "Partech Inc." },
    { 391, "Electronic Design for Industry, Inc" },
    { 392, "Tianyuan Technology Co Ltd." },
    { 393, "Harvest Tec, Inc" },
    { 394, "Capi 2 Nederland B.V." },
    { 395, "GENTEC S.R.L." },
    { 396, "Beyond Measure" },
    { 397, "Sanyo-kiki Co Ltd." },
    { 398, "Hilite International" },
    { 399, "ISEKI & Co., Ltd." },
    { 400, "Livorsi Marine" },
    { 401, "Torqeedo GmbH" },
    { 402, "Simma Software, Inc." },
    { 403, "Trackwell ADS, Inc." },
    { 404, "Com Nav Marine Ltd" },
    { 405, "Wema System AS" },
    { 406, "Vecima Networks Inc." },
    { 407, "Comtech Mobile Datacom" },
    { 408, "Corvus Energy Ltd." },
    { 409, "Transfluid S.r.L." },
    { 410, "COBO S.p.A. Divisione 3B6" },
    { 411, "Hy-Drive Technologies Ltd." },
    { 412, "WebTech Wireless Inc." },
    { 413, "Datapross Nijbroek bv" },
    { 414, "Cattron Group International" },
    { 415, "Valid Manufacturing Ltd." },
    { 416, "Kubota Corporation" },
    { 417, "KZValve" },
    { 418, "Intellistick Inc" },
    { 419, "Fusion Electronics Ltd" },
    { 420, "Vermeer Corporation, ACS Group" },
    { 421, "Vertex Standard Co, Ltd" },
    { 422, "True Heading AB" },
    { 423, "BSM Wireless, Inc." },
    { 424, "Odyne LLC" },
    { 425, "Methode Electronics Inc, MDI" },
    { 429, "Rota Engineering Ltd." },
    { 430, "Auteq Telematica S.A." },
    { 431, "Tohatsu Corporation" },
    { 432, "S&A Systems, Inc." },
    { 433, "Rowe Electronics" },
    { 434, "Stored Energy Systems" },
    { 435, "Zunhammer GmbH" },
    { 436, "Kinze Manufacturing" },
    { 437, "Digital Yacht Limited" },
    { 438, "Comar Systems Ltd" },
    { 439, "Hyundai Heavy Industries" },
    { 440, "Cummins Power Generation" },
    { 441, "PTG Reifendruckregelsysteme GmbH" },
    { 442, "Horsch Maschinen GmbH" },
    { 443, "SignalQuest, Inc." },
    { 444, "ITT Power Solutions" },
    { 445, "KAT MECHATRONIC, Electronic Product Division" },
    { 446, "CertTech, L.L.C." },
    { 447, "Great Plains Mfg." },
    { 448, "Stanadyne Corporation, Electronics Systems" },
    { 449, "Polaris Industries Inc" },
    { 450, "Dycor Technologies Ltd." },
    { 451, "Parker Hannifin Corp" },
    { 452, "WIKA Alexander Wiegand SE & Co. KG" },
    { 453, "Cooper Bussmann" },
    { 454, "NGK Spark Plug Co. Ltd" },
    { 455, "ADZ NAGANO GmbH" },
    { 456, "General Kinetics" },
    { 457, "RUSELPROM-ElectricDrive Ltd" },
    { 458, "Control Solutions, Inc." },
    { 459, "Alltek Marine Electronics Corp" },
    { 460, "San Giorgio S.E.I.N." },
    { 461, "HAWE Hydraulik SE" },
    { 462, "IHI Shibaura Machinery Corporation" },
    { 463, "PROBOTIQ" },
    { 464, "Leach International Corporation" },
    { 465, "Ashcroft Inc" },
    { 466, "Veethree Electronics and Marine LLC" },
    { 467, "Lely Industries N.V." },
    { 468, "Tyco Fire Protection Products" },
    { 469, "RA Consulting GmbH" },
    { 470, "SI-TEX Marine Electronics" },
    { 471, "Sea Cross Marine AB" },
    { 472, "Tenneco Inc." },
    { 473, "Boss Industries, Inc." },
    { 474, "Persen Technologies Inc." },
    { 475, "GME" },
    { 476, "Hummingbird Marine Electronics" },
    { 477, "OilQuick AB" },
    { 478, "OceanSat B.V." },
    { 479, "Vapor Bus International" },
    { 480, "EnerDel, Inc." },
    { 481, "Chetco Digital Instruments" },
    { 482, "Tricon Electronics" },
    { 483, "Valeo" },
    { 484, "Headsight Inc." },
    { 485, "MATT automotive" },
    { 486, "Westport Innovations Inc." },
    { 487, "DSE Test Solutions A/S" },
    { 488, "The Charles Machine Works, Inc." },
    { 489, "Appareo Systems, LLC" },
    { 490, "QuikQ" },
    { 491, "Penny and Giles Ltd" },
    { 492, "Inergy Automotive Systems" },
    { 493, "Watcheye" },
    { 494, "Synerject" },
    { 495, "HOLMER Maschinenbau GmbH" },
    { 496, "W. Gessmann GmbH" },
    { 497, "SENTRON Sistemas Embarcados" },
    { 498, "Innovative Design Solutions, Inc." },
    { 499, "LCJ Capteurs" },
    { 500, "Oxbo International Corporation" },
    { 501, "Agrotronix S.A." },
    { 502, "Attwood Corporation" },
    { 503, "Naviop S.R.L." },
    { 504, "Vesper Marine" },
    { 505, "Yetter Farm Equipment" },
    { 506, "IHI STAR Machinery Corporation" },
    { 507, "ISOBUS Test Center" },
    { 508, "Transtech Innovations" },
    { 509, "MOTORTECH GmbH" },
    { 510, "Marinesoft Co. Ltd" },
    { 511, "Sulky" },
    { 512, "Inpower LLC" },
    { 513, "Precision Technology" },
    { 514, "DISTek Integration, Inc." },
    { 515, "GINAF Trucks Nederland B.V." },
    { 516, "AVAT Automation GmbH" },
    { 517, "Noland Engineering" },
    { 518, "Transas USA Inc." },
    { 519, "Peeters Landbouwmachines b.v." },
    { 520, "Trapeze" },
    { 521, "Clever Devices Ltd." },
    { 522, "Nebraska Tractor Test Laboratory" },
    { 523, "Reggio Emilia Innovazione" },
    { 524, "Vomax Instrumentation Pty. Ltd." },
    { 525, "Rust Sales INC" },
    { 526, "LOFA Industries, Inc" },
    { 527, "GKN Walterscheid GmbH" },
    { 528, "Hoganas AB, Electric Drive Systems" },
    { 529, "National Instruments Korea" },
    { 530, "NMEA" },
    { 531, "Genge & Thoma AG" },
    { 532, "Onwa Marine Electronics Co Ltd." },
    { 533, "Doran Manufacturing, LLC" },
    { 534, "Webasto Thermo & Comfort SE" },
    { 535, "MOTORPAL, a.s." },
    { 536, "SSI Technologies" },
    { 537, "Schrader Electronics Ltd." },
    { 538, "Crop Ventures, Inc." },
    { 539, "Mobileview" },
    { 540, "Dinex A/S" },
    { 541, "Total Fire Systems, Inc." },
    { 542, "Dinamica Generale s.p.a." },
    { 543, "BAUER Maschinen GmbH" },
    { 544, "Au Group Electronics" },
    { 545, "GS Global Resources (formerly GS Hydraulics)" },
    { 546, "Maruyama Mfg Co, Inc." },
    { 547, "Thomson Linear LLC" },
    { 548, "TM4 Inc." },
    { 549, "ROAD Deutschland GmbH" },
    { 550, "SUN-A Corporation" },
    { 551, "Wexler CSD Ltd." },
    { 552, "Matsuyama Plow Mfg Co, Ltd" },
    { 553, "KIB Electronics" },
    { 554, "iris-GmbH infrared & intelligent sensors" },
    { 555, "Sasaki Corporation" },
    { 556, "Doosan Infracore Norway" },
    { 557, "Rockson Automation GmbH" },
    { 558, "Davis Instruments Corp." },
    { 559, "Four Peaks Navigation" },
    { 560, "Iowa State University, Agricultural and Biosystems Engineering" },
    { 561, "b-plus GmbH" },
    { 562, "Bombardier Transportation GmbH" },
    { 563, "LOHR Sistemas Eletronicos LTDA" },
    { 564, "Auto Power Electronic" },
    { 565, "Micro-Trak Systems, Inc." },
    { 566, "Geode Technology, Inc." },
    { 567, "Lithiumstart LLC" },
    { 568, "Makersan Ltd. Co." },
    { 569, "LORD MicroStrain Sensing Systems" },
    { 570, "frenzel + berg electronic GmbH & Co. KG" },
    { 571, "Marinecraft Co., Ltd." },
    { 572, "Fasse Valves" },
    { 573, "Orolia Ltd" },
    { 574, "Vishay Precision Group" },
    { 575, "Lytx" },
    { 576, "Vectia" },
    { 577, "Denchi Power Ltd  (formerly ABSL Power Solutions Limited)" },
    { 578, "advanSea" },
    { 579, "KVH Industries, Inc." },
    { 580, "San Jose Technology, Inc." },
    { 581, "Väderstad AB" },
    { 582, "Innovative Software Engineering" },
    { 583, "Yachtcontrol" },
    { 584, "CarMedialab GmbH" },
    { 585, "Industrial Electronic Controls" },
    { 586, "Suzuki Motor Corp" },
    { 587, "JCA Electronics" },
    { 588, "Vignal Systems" },
    { 589, "MICO, Inc." },
    { 590, "ARGO-HYTOS GMBH" },
    { 591, "United States Coast Guard" },
    { 592, "tecsis GmbH" },
    { 593, "Sensata Technologies" },
    { 594, "Kongsberg Automotive" },
    { 595, "CustomWare" },
    { 596, "Brunelco Electronic Innovators B.V." },
    { 597, "Hydac Filter Systems GmbH" },
    { 598, "ABB Turbo Systems Ltd" },
    { 599, "Spudnik Equipment Co, LLC" },
    { 600, "Aquatic AV" },
    { 601, "Navitas Systems" },
    { 602, "Nomad Digital Ltd." },
    { 603, "Kereval" },
    { 604, "Rototilt Group AB (formerly Indexator Rototilt Systems AB)" },
    { 605, "Aventics GmbH" },
    { 606, "Intellian Technologies" },
    { 607, "Knappco/Civacon" },
    { 608, "Gale Banks Engineering" },
    { 609, "Walvoil S.p.A." },
    { 610, "Trail Tech" },
    { 611, "Esterline" },
    { 612, "Samwon IT" },
    { 613, "HKS Co., Ltd." },
    { 614, "ARLT Technologies GmbH" },
    { 615, "Networkfleet, Verizon Telematics" },
    { 616, "SMART-TEC s.r.o." },
    { 617, "Zero Emission Vehicles" },
    { 618, "Evrard SA" },
    { 619, "Right Weigh Load Scales" },
    { 620, "BorgWarner Inc. (formerly Sevcon Ltd.)" },
    { 621, "Hagie Manufacturing Company" },
    { 622, "Floyd Bell Inc" },
    { 623, "Xirgo Technologies" },
    { 624, "Blackbox Machine Control Pty Ltd" },
    { 625, "Global MRV Inc." },
    { 626, "AVL DiTEST GmbH" },
    { 627, "Radio Ocean" },
    { 628, "Falck Schmidt Defence Systems" },
    { 629, "Agri Info Design, Ltd." },
    { 630, "SmartDrive Systems Inc." },
    { 631, "Reltima" },
    { 632, "Pepperl+Fuchs GmbH" },
    { 633, "TORC Robotics" },
    { 634, "Rocky Research" },
    { 635, "Argo Tractors S.p.A." },
    { 636, "Divelbiss Corporation" },
    { 637, "Bavaria Yachtbau GmbH" },
    { 638, "KVH Industries, Inc." },
    { 639, "Startec s.r.l." },
    { 640, "Power Solutions International" },
    { 641, "Diverse Yacht Services" },
    { 642, "Moog / Aspen Motion Technologies" },
    { 643, "Bogballe A/S" },
    { 644, "KUS USA" },
    { 645, "esd electronic system design gmbh" },
    { 646, "Veenhuis Machines B.V." },
    { 647, "Siloking" },
    { 648, "OJSC Ekran" },
    { 649, "Control-Q B.V." },
    { 650, "Seiko Epson Corp." },
    { 651, "Takakita Co, Ltd." },
    { 652, "MicroControl GmbH & Co. KG" },
    { 653, "AEV, spol. s r. o." },
    { 654, "Kohler Power Systems, Detroit Engine Development Center (DEDC)" },
    { 655, "Genge & Thoma AG" },
    { 656, "PRO SOLUS do Brasil" },
    { 657, "Terzo Power Systems" },
    { 658, "Shenzhen Jiuzhou Himunication Technology Co., Ltd" },
    { 659, "Data Panel Corp." },
    { 660, "Auto-Gaz Centrum" },
    { 661, "SPAL Automotive S.r.l." },
    { 662, "Kissling Elektrotechnik GmbH" },
    { 663, "Delta Systems, Inc" },
    { 664, "Level Developments Ltd" },
    { 665, "Gebr. Bode GmbH & Co. KG" },
    { 666, "Schaeffler Technologies AG & Co., KG" },
    { 667, "Bartec" },
    { 668, "MacDon Industries Ltd." },
    { 669, "Quantum Fuel Systems Technologies Worldwide, Inc" },
    { 670, "STEMCO LP" },
    { 671, "Innovative Controls Inc." },
    { 672, "OPTIMA Concept" },
    { 673, "Caruelle Nicolas" },
    { 674, "Yara International ASA" },
    { 675, "Kawasaki Motors Corp., USA" },
    { 676, "Danfoss IXA A/S" },
    { 677, "DSA Daten- und Systemtechnik GmbH" },
    { 678, "KeepTruckin, Inc." },
    { 679, "OXE Marine AB (formerly Cimco Marine AB)" },
    { 680, "AMVAC Chemical Corporation" },
    { 681, "BEDIA Motorentechnik GmbH & Co. KG" },
    { 682, "Eckelmann AG" },
    { 683, "Fosen Elektro" },
    { 684, "KEB" },
    { 685, "ANEDO (formerly ANEDO Ltd.)" },
    { 686, "Taigene Electric Machinery Corp." },
    { 687, "Flight Systems, Inc." },
    { 688, "Rockford Corp" },
    { 689, "Aarcomm Systems Inc" },
    { 690, "LINAK A/S" },
    { 691, "Digitroll Agricultural Electronics" },
    { 692, "Tanhay Corporation" },
    { 693, "Agility Fuel Solutions (formerly Agility Fuel Systems)" },
    { 694, "GasTOPS Ltd." },
    { 695, "Weldon Technologies" },
    { 696, "DRS Network & Imaging Systems, LLC (DRS Technologies)" },
    { 697, "Ålö AB" },
    { 698, "Scorpion Technologies Ltd." },
    { 699, "Harman International (formerly Harman International Industries)" },
    { 700, "K-Tec Earthmovers Inc." },
    { 701, "BigRoad Inc." },
    { 702, "Weichai Power Co., Ltd." },
    { 703, "Hydro Tab Marine Engineering" },
    { 704, "JL Audio, Inc." },
    { 705, "SVAB Hydraulik AB" },
    { 706, "Shanghai Diesel Engine Corporation Limited" },
    { 707, "Rochester Gauges Inc" },
    { 708, "Lars Thrane A/S" },
    { 709, "Marquardt GmbH" },
    { 710, "Greentronics Ltd." },
    { 711, "DAS Co., LTD" },
    { 712, "LOR Manufacturing Company Inc." },
    { 713, "US Hybrid Corporation" },
    { 714, "Kobashi Kogyo Co., Ltd." },
    { 715, "Autonnic Research Ltd" },
    { 716, "Eaton Control & Power Conversion Division (CPCD)" },
    { 717, "Yacht Devices Ltd" },
    { 718, "Micronet Inc" },
    { 719, "Cojali S. L." },
    { 720, "WITZ Corporation" },
    { 721, "Hypro" },
    { 722, "Contelec AG" },
    { 723, "Jabil Inc." },
    { 724, "Electronic Applications, Inc." },
    { 725, "Hitachi Construction Machinery Co., Ltd." },
    { 726, "MIDORI PRECISIONS" },
    { 727, "Dhoot Transmission Pvt Ltd." },
    { 728, "Streumaster (formerly Streumaster / Panien)" },
    { 729, "Liebherr" },
    { 730, "BERTHOUD AGRICOLE" },
    { 731, "Modine Manufacturing Company" },
    { 732, "Gefran S.p.A." },
    { 733, "Intendia S.L." },
    { 734, "REAPsystems" },
    { 735, "AEM Performance Electronics" },
    { 736, "Terex Aerial Work Platforms - Genie" },
    { 737, "Balluff GmbH" },
    { 738, "Blue Ink Technologies" },
    { 739, "LXNAV d.o.o." },
    { 740, "e-Traction" },
    { 741, "Carling Technologies" },
    { 742, "EROAD" },
    { 743, "Daemyung Elevator Co., Ltd." },
    { 744, "Woosung Engineering Co., Ltd." },
    { 745, "Cidra Corporate Services Inc." },
    { 746, "SurePoint Ag Systems (formerly SureFire Ag Systems, Inc.)" },
    { 747, "Agratronix" },
    { 748, "ISOTTA" },
    { 749, "Chart Inc." },
    { 750, "Joskin SA" },
    { 751, "Pacific Track" },
    { 752, "Deep Sea Electronics Plc" },
    { 753, "AIROD Technologies" },
    { 754, "Parker Hannifin Corp., Automation Group" },
    { 755, "Firefly Integrations" },
    { 756, "Maschio Gaspardo S.P.A." },
    { 757, "IMPCO Technologies" },
    { 758, "Banner Engineering Corp." },
    { 759, "Hydro-Gear" },
    { 760, "Bernecker + Rainer Industrie Elektronik GmbH" },
    { 761, "MITA OLEODINAMICA S.p.A." },
    { 762, "ROJ s.r.l." },
    { 763, "AT-Systems BVBA" },
    { 764, "Bednar FMT s.r.o." },
    { 765, "GIGAVAC" },
    { 766, "Epec Oy" },
    { 767, "Alliance Wireless Technologies Inc." },
    { 768, "Flores Automation, LLC" },
    { 769, "Trombetta" },
    { 770, "MONOSEM" },
    { 771, "Shaw Development, LLC" },
    { 772, "Blink Marine" },
    { 773, "Clarion Corporation of America" },
    { 774, "Taisho Corporation" },
    { 775, "ZIEHL-ABEGG Automotive GmbH" },
    { 776, "HMI Systems LLC" },
    { 777, "Ocean Signal Ltd" },
    { 778, "Seakeeper Inc." },
    { 779, "RLC Electronic Systems" },
    { 780, "Turntide Transport Limited (formerly AVID Technology Ltd)" },
    { 781, "Poly-Planar LLC" },
    { 782, "AVR nv" },
    { 783, "Loup Electronics Inc." },
    { 784, "CM Automotive Systems, Inc." },
    { 785, "Fischer Panda GmbH" },
    { 786, "Johnson Matthey Battery Systems" },
    { 787, "Abertax Technologies Limited" },
    { 788, "MoTeC Pty Ltd" },
    { 789, "GRADALL" },
    { 790, "VACALL" },
    { 791, "AUTEC" },
    { 792, "Kostal Mexicana" },
    { 793, "James Fisher Prolec" },
    { 794, "Shihlin Electric & Engineering Corporation" },
    { 795, "Broyda Enterprises Pty Ltd" },
    { 796, "Canadian Automotive Industries Ltd" },
    { 797, "Tides Marine" },
    { 798, "Lumishore Ltd" },
    { 799, "Stillwater Designs and Audio, Inc. - KICKER" },
    { 800, "Delta-Q Technologies" },
    { 801, "LOR Manufacturing Company Inc." },
    { 802, "SPBI (Bj Technologie)" },
    { 803, "Gill Sensors & Controls Limited" },
    { 804, "ASA Electronics" },
    { 805, "Gundersen & Løken AS" },
    { 806, "Charge Automotive Ltd" },
    { 807, "Schneider-Electric" },
    { 808, "RIMEX Supply Ltd." },
    { 809, "HMS Industrial Networks AB" },
    { 810, "Dutch Power Company" },
    { 811, "Blue Water Desalination" },
    { 812, "Torch Technologies" },
    { 813, "Thales Suisse SA" },
    { 814, "Kronotech Srl (formerly Soltec Soluzioni Tecnologiche Srl)" },
    { 815, "FLIR Systems, Inc." },
    { 816, "UniStrong" },
    { 817, "TE Connectivity Sensor Solutions" },
    { 818, "HGNSS" },
    { 819, "Preco Electronics" },
    { 820, "DIaLOGIKa Gesellschaft fuer angewandte Informatik mbH" },
    { 821, "Thorsen Teknik A/S" },
    { 822, "Bren-Tronics, Inc." },
    { 823, "ACEINNA, Inc (formerly MEMSIC, Inc)" },
    { 824, "Undheim Systems AS" },
    { 825, "BPW Hungária" },
    { 826, "Lewmar Marine Inc" },
    { 827, "INmatix Technology Group Ltd" },
    { 828, "AgriBrink Inc." },
    { 829, "Drov Technologies, Inc." },
    { 830, "Ultra Motion LLC" },
    { 831, "DOK-ING Ltd." },
    { 832, "Heizomat Gerätebau-Energiesysteme GmbH" },
    { 833, "Electrum Automation AB" },
    { 834, "Pioneer Microsystems, Inc." },
    { 835, "PetTrack Ltd." },
    { 836, "Signature4" },
    { 837, "Famic Technologies Inc." },
    { 838, "Teamsurv Ltd" },
    { 839, "Indexator Rotator Systems AB" },
    { 840, "E.S.T.E. srl" },
    { 841, "Agra-GPS" },
    { 842, "DigiDevice Srl" },
    { 843, "Hendrickson Truck Commercial Vehicle Systems" },
    { 844, "FELL AS" },
    { 845, "GMB Güstrower Maschinenbau GmbH" },
    { 846, "L3 Magnet-Motor" },
    { 847, "Oceanvolt" },
    { 848, "ningupex" },
    { 849, "MTS Maschinentechnik Schrode AG" },
    { 850, "Geoprospectors GmbH" },
    { 851, "Novotechnik Messwertaufnehmer OHG" },
    { 852, "Velvac Inc" },
    { 853, "Teledyne RESON B.V." },
    { 854, "GEMAC Chemnitz GmbH" },
    { 855, "Toshiba Infrastructure Systems & Solutions Corporation" },
    { 856, "FarmFacts GmbH" },
    { 857, "Zoomlion Heavy Industry NA, Inc" },
    { 858, "Littelfuse" },
    { 859, "Valor" },
    { 860, "Michelin" },
    { 861, "Adel System S.r.l." },
    { 862, "Prospec Electronics" },
    { 863, "SMAG" },
    { 864, "Streamline Transportation Technologies Inc." },
    { 865, "MyEasyFarm" },
    { 866, "Netradyne, Inc." },
    { 867, "Skeleton Technologies" },
    { 868, "Data Panel Corp" },
    { 869, "Intercomp" },
    { 870, "Textron Fleet Management" },
    { 871, "Agri-Fab (formerly Superior Tech Inc)" },
    { 872, "Kählig Antriebstechnik GmbH" },
    { 873, "Garnet Instruments Ltd." },
    { 874, "MTA S.p.A." },
    { 875, "Salvarani S.r.l." },
    { 876, "SUCO Robert Scheuffele GmbH & Co. KG" },
    { 877, "SICK ATech GmbH" },
    { 878, "FOTON" },
    { 879, "PG Trionic, Inc." },
    { 880, "Revision Military" },
    { 881, "Sovema" },
    { 882, "BHTronik GmbH & Co. KG" },
    { 883, "Swift Navigation, Inc." },
    { 884, "Sure Grip Controls Inc." },
    { 885, "SICK AG (formerly SICK Stegmann GmbH)" },
    { 886, "Hitachi Zosen Corporation" },
    { 887, "Turntide Transport Limited (formerly Hyperdrive Innovation Limited)" },
    { 888, "Carma Systems Inc" },
    { 889, "SANY America Inc" },
    { 890, "L3 Technologies, Inc." },
    { 891, "CarrierWeb" },
    { 892, "Mectronx Corp" },
    { 893, "KlinkTechnics Ltd." },
    { 894, "Rhodan Marine Systems of Florida LLC" },
    { 895, "Peloton Technology" },
    { 896, "NextFour Solutions Ltd" },
    { 897, "Dot Technology Corp." },
    { 898, "Josef Kotte Landtechnik GmbH & Co. KG" },
    { 899, "Lippert Components, Inc" },
    { 900, "OSB connagtive GmbH (formerly OSB AG)" },
    { 901, "Zivan Srl" },
    { 902, "Bucher Hydraulics" },
    { 903, "InMotion" },
    { 904, "Equipment Safety Systems Pty. Ltd. (EQSS)" },
    { 905, "ASA Electronics" },
    { 906, "MOBA AG" },
    { 907, "strautmann" },
    { 908, "Chonbuk National University Department of Electronics" },
    { 909, "Marines Co., Ltd." },
    { 910, "Hermann Paus Maschinenfabrik GmbH" },
    { 911, "Nautic-On" },
    { 912, "Steyr Motors GmbH" },
    { 913, "Toyota Motor Corporation" },
    { 914, "ZETOR TRACTORS a.s." },
    { 915, "Dosificacion y sistemas electronicos S.L. (DSE)" },
    { 916, "Hans Turck GmbH & Co. KG (formerly Turck Inc.)" },
    { 917, "Sentinel d.o.o." },
    { 918, "AMW Machine Control, Inc" },
    { 919, "Furrion LLC" },
    { 920, "MTD Consumer Group Inc." },
    { 921, "ROPA Fahrzeug- und Maschinenbau GmbH" },
    { 922, "Terberg Benschop B.V." },
    { 923, "ELTEK S.p.A." },
    { 924, "PAS Peschak Autonome Systeme GmbH" },
    { 925, "GW Lisk Company" },
    { 926, "Buhler Industries Inc." },
    { 927, "Saicon" },
    { 928, "EAO Automotive GmbH & Co. KG" },
    { 929, "Jl Marine Systems, Inc." },
    { 930, "Ecotronix Corp." },
    { 931, "Enertec Marine Ltd" },
    { 932, "Discover Battery" },
    { 933, "Delta Mobile Systems, Inc." },
    { 934, "Farmobile, Inc." },
    { 935, "Meels GmbH & Co. KG" },
    { 936, "Hi-tech Millennium" },
    { 937, "Precision Circuits Inc" },
    { 938, "LEVEL Systems" },
    { 939, "Warn Industries, Inc." },
    { 940, "Dometal Oy" },
    { 941, "Navya" },
    { 942, "Vogelsang GmbH & Co. KG" },
    { 943, "FISCHER AG Präzisionspindeln" },
    { 944, "ZONTISA Marine SL" },
    { 945, "Equalizer AG" },
    { 946, "Hydac Tecnologia Ltda" },
    { 947, "Gerd Bär GmbH" },
    { 948, "Donix" },
    { 949, "Škoda Electric a.s." },
    { 950, "RE:Lab s.r.l." },
    { 951, "Exor International S.p.A." },
    { 952, "Tan Delta Systems Ltd" },
    { 953, "Curtiss-Wright" },
    { 954, "Setec Pty Ltd" },
    { 955, "Hottinger Baldwin (Suzhou) Electronic Measurement Technology Co., Ltd." },
    { 956, "Piher Sensors & Controls S.A." },
    { 957, "Sierra Wireless Inc" },
    { 958, "NHK MEC Corporation" },
    { 959, "Cascade Corporation" },
    { 960, "Vemcon GmbH" },
    { 961, "POK SAS" },
    { 962, "Timbolier Industries, Inc." },
    { 963, "Thomason Jones Company, LLC" },
    { 964, "AgroVIR Kft" },
    { 965, "Ro-Sys Software" },
    { 966, "VisibleFarm" },
    { 967, "Moteck Electric Corp." },
    { 968, "Cox Powertrain Limited" },
    { 969, "Blue Sea Systems" },
    { 970, "Jaboni Power Products, LLC" },
    { 971, "B+B Smartworx" },
    { 972, "Axion AG" },
    { 973, "Zasso GmbH" },
    { 974, "Pico Technology Limited" },
    { 975, "Siemens AG" },
    { 976, "Derive Systems, Inc." },
    { 977, "Copeland LP (formerly Emerson Electric Co.)" },
    { 978, "Canfield Connector" },
    { 979, "McHale" },
    { 980, "Gussi Italia S.R.L." },
    { 981, "Kobelt Manufacturing Co. Ltd" },
    { 982, "Briggs & Stratton Corporation" },
    { 983, "Dezwaef NV" },
    { 984, "E-T-A Elektrotechnische Apparate GmbH" },
    { 985, "NLR, LLC" },
    { 986, "AAMP Global" },
    { 987, "Baltic Car Equipment" },
    { 988, "Voith Turbo" },
    { 989, "Flux-Geräte GmbH" },
    { 990, "SAMSUNG SDI Co., Ltd." },
    { 991, "Deutronic Elektronik GmbH" },
    { 992, "MarineIOT LLC" },
    { 993, "Alelion Energy Systems AB" },
    { 994, "Morris Industries Ltd." },
    { 995, "Circuitlink Pty Ltd." },
    { 996, "Eniquest Pty Ltd" },
    { 997, "Xenta Systems Srl" },
    { 998, "Transcell Technology Inc" },
    { 999, "TerraTroniq B.V." },
    { 1000, "Landmaschinen Wienhoff GmbH" },
    { 1001, "Cleral Inc." },
    { 1002, "Kussmaul Electronics Co." },
    { 1003, "technotrans SE" },
    { 1004, "Ultraflex SpA" },
    { 1005, "TSE Brakes, Inc." },
    { 1006, "Proterra" },
    { 1007, "Maschinenfabrik Meyer-Lohne GmbH" },
    { 1008, "Lintest Systems LLC" },
    { 1009, "TouchTronics, Inc." },
    { 1010, "Agricultural Industry Electronics Foundation e.V." },
    { 1011, "Soundmax Electronics Ltd" },
    { 1012, "Rhodan Marine Systems of Florida LLC" },
    { 1013, "Allochis E-Tec" },
    { 1014, "Briri Maschinenbau GmbH" },
    { 1015, "SECURITAG SAS" },
    { 1016, "Röhren- und Pumpenwerk BAUER GmbH" },
    { 1017, "Caldaro AB" },
    { 1018, "Flex TTS" },
    { 1019, "Codek Foundries" },
    { 1020, "Onyx Marine Automation s.r.l." },
    { 1021, "Entratech Systems LLC" },
    { 1022, "ITC Inc" },
    { 1023, "PEAK-System Technik GmbH" },
    { 1024, "Inventus Power" },
    { 1025, "eze System, Inc." },
    { 1026, "ZTR Control Systems, LLC" },
    { 1027, "Goldacres PTY LTD" },
    { 1028, "Autel Intelligent Technology Corp., Ltd" },
    { 1029, "The Marine Guardian LLC" },
    { 1030, "Tume-Agri Oy" },
    { 1031, "Flintec UK Ltd." },
    { 1032, "SIMOL S.p.A." },
    { 1033, "ECCO Safety Group" },
    { 1034, "Siren Marine" },
    { 1035, "Agres" },
    { 1036, "Bender GmbH & Co. KG" },
    { 1037, "Dragonfly Energy Corp." },
    { 1038, "EMIT Technologies, Inc." },
    { 1039, "Liugong Dressta Machinery" },
    { 1040, "BPE Electronics Srl" },
    { 1041, "EZ Lynk" },
    { 1042, "engcon group" },
    { 1043, "Hyva" },
    { 1044, "Xee" },
    { 1045, "CMR Group" },
    { 1046, "Praxidyn" },
    { 1047, "Sonic Corporation" },
    { 1048, "Agrivation UG" },
    { 1049, "S&S Cycle" },
    { 1050, "Spacenus GmbH" },
    { 1051, "ProNav AS" },
    { 1052, "Pfreundt" },
    { 1053, "Vetus Maxwell, Inc." },
    { 1054, "Schmotzer Hacktechnik GmbH & Co. KG" },
    { 1055, "EXA Computing GmbH" },
    { 1056, "Lithium Pros" },
    { 1057, "EquipmentShare" },
    { 1058, "Bondioli & Pavesi SpA" },
    { 1059, "Boatrax" },
    { 1060, "Scale-Tec" },
    { 1061, "Volvo Construction Equipment" },
    { 1062, "Marol Co Ltd" },
    { 1063, "SolSteer" },
    { 1064, "Omnitech Robotics Inc." },
    { 1065, "CALYPSO Instruments" },
    { 1066, "Spot Zero Water" },
    { 1067, "Tecomec S.r.l." },
    { 1068, "Zapi S.p.A." },
    { 1069, "Lithionics Battery LLC" },
    { 1070, "Quick-teck Electronics Ltd" },
    { 1071, "MACH SYSTEMS s.r.o." },
    { 1072, "La Marche Manufacturing Company" },
    { 1073, "Manitou Equipment America LLC" },
    { 1074, "Kindhelm / Navigs Oy" },
    { 1075, "Uniden America Corporation" },
    { 1076, "DOGA S.A." },
    { 1077, "Ymer Technology" },
    { 1078, "GE Appliances" },
    { 1079, "Carl Zeiss Spectroscopy GmbH" },
    { 1080, "Epsilor-Electric Fuel Ltd." },
    { 1081, "Imcon Electronics, s.r.o." },
    { 1082, "TÜMOSAN Engine and Tractor Co." },
    { 1083, "Nauticoncept" },
    { 1084, "Shadow-Caster LED lighting LLC" },
    { 1085, "Wet Sounds, LLC" },
    { 1086, "Life Racing Ltd" },
    { 1087, "ITPhotonics S.r.l." },
    { 1088, "E-T-A Circuit Breakers" },
    { 1089, "Carrosserie HESS AG" },
    { 1090, "E-T-A Circuit Breakers Ltd" },
    { 1091, "Wheel Monitor Inc." },
    { 1092, "Scheiber" },
    { 1093, "innolectric" },
    { 1094, "Tokushu Denki" },
    { 1095, "WEG Drives and Controls - Automação Ltda" },
    { 1096, "Texense Sensors" },
    { 1097, "M2M Craft Co., Ltd" },
    { 1098, "Preh GmbH" },
    { 1099, "MadgeTech, Inc" },
    { 1100, "Smart Yachts International Limited" },
    { 1101, "DIS Sensors B.V." },
    { 1102, "Carl Geringhoff GmbH & Co. KG" },
    { 1103, "Diesel Laptops" },
    { 1104, "The Toro Company" },
    { 1105, "Redekop Manufacturing" },
    { 1106, "Great Dane LLC" },
    { 1107, "Dräger Safety" },
    { 1108, "ORBCOMM" },
    { 1109, "Dockmate" },
    { 1110, "Analytic Systems Ware (1993) Ltd." },
    { 1111, "SEPPI M." },
    { 1112, "Bollinger Motors" },
    { 1113, "iVolve Pty Ltd" },
    { 1114, "Bob's Machine" },
    { 1115, "Gems Sensors & Controls" },
    { 1116, "HR Agrartechnik GmbH" },
    { 1117, "LG Chem, Ltd" },
    { 1118, "L3Harris ASV" },
    { 1119, "Balmar LLC" },
    { 1120, "Elettromedia s.r.l." },
    { 1121, "Platform Science" },
    { 1122, "GT Inc." },
    { 1123, "QP Hydraulics" },
    { 1124, "Fortron Agriculture" },
    { 1125, "Griffith-Elder & Co. Ltd." },
    { 1126, "Auralix" },
    { 1127, "ElectroMaax" },
    { 1128, "Citoon Electronic Technology (Tianjin) Co., Ltd." },
    { 1129, "Spectrolytic GmbH" },
    { 1130, "Vitesco Technologies" },
    { 1131, "Guliwer electronics s.r.o." },
    { 1132, "Tokachi Zaidan" },
    { 1133, "MEGATRON Elektronik GmbH & Co. KG" },
    { 1134, "Master Schools at Ostbahnhof" },
    { 1135, "Japan Aviation Electronics Industry, Limited" },
    { 1136, "Primosensor GmbH" },
    { 1137, "SIKO GmbH" },
    { 1138, "Micro-Sensor GmbH" },
    { 1139, "ASP Technology" },
    { 1140, "Across Oceans Systems Ltd." },
    { 1141, "MRS Electronic GmbH & Co. KG" },
    { 1142, "Truma" },
    { 1143, "Elektro-Szoft 2000" },
    { 1144, "Troo Corporation" },
    { 1145, "Kiwi Yachting" },
    { 1146, "Rometron" },
    { 1147, "Dana Inc." },
    { 1148, "Stercom Power Solutions GmbH" },
    { 1149, "Wuxi Shengbang Electronics Co., Ltd" },
    { 1150, "BSB Artificial Intelligence GmbH" },
    { 1151, "Orca Technologies AS" },
    { 1152, "Vredo Dodewaard B.V." },
    { 1153, "Kawasaki Heavy Industries, Ltd." },
    { 1154, "TBS Electronics BV" },
    { 1155, "LACOS GmbH (formerly LACOS Computerservice GmbH)" },
    { 1156, "Nokian Tyres" },
    { 1157, "Carriergistics" },
    { 1158, "Technoton Electronics" },
    { 1159, "Bel Power Solutions" },
    { 1160, "MG Energy Systems B.V." },
    { 1161, "Griessbach GmbH" },
    { 1162, "PEL-tuote Oy" },
    { 1163, "DFX Technologies LLC" },
    { 1164, "SEG Automotive" },
    { 1165, "InnoTotal AB" },
    { 1166, "Wachendorff Automation GmbH & Co. KG" },
    { 1167, "Tevva Motors" },
    { 1168, "Masats S.A." },
    { 1169, "Sea Machine Robotics Inc." },
    { 1170, "Poseidon Ocean Systems Ltd." },
    { 1171, "Vista Manufacturing" },
    { 1172, "Hyzon Motors" },
    { 1173, "philippi elektrische systeme gmbh" },
    { 1174, "Agricon GmbH" },
    { 1175, "MAGTEC Products, Inc." },
    { 1176, "Asuns Corp." },
    { 1177, "RNG International Inc." },
    { 1178, "ERO GmbH" },
    { 1179, "QS Control srl" },
    { 1180, "Murata Power Solutions Inc." },
    { 1181, "Banjo Corporation" },
    { 1182, "Rottmann Automation" },
    { 1183, "Zipwake AB" },
    { 1184, "AMA S.p.A." },
    { 1185, "WFCO Electronics" },
    { 1186, "Sailmon BV" },
    { 1187, "TiTAN-Project LLC" },
    { 1188, "G-SNS" },
    { 1189, "Autotrasporti Cavallo G&V" },
    { 1190, "Sirros IoT" },
    { 1191, "Pacoma USA, Inc." },
    { 1192, "Airmoniq Pro Kft." },
    { 1193, "emotas embedded communication GmbH" },
    { 1194, "Sierra Marine" },
    { 1195, "düvelsdorf" },
    { 1196, "Terra Care GmbH" },
    { 1197, "SOLGE Corporation" },
    { 1198, "ComLink Equipamentos Eletrônicos Ltda" },
    { 1199, "ELEO Technologies B.V." },
    { 1200, "Xinuo Information Technology (Xiamen) Corporation Limited" },
    { 1201, "Emisense Technologies, LLC" },
    { 1202, "OSCAR ELECTRONICS SRL (formerly OSCAR Elettronica)" },
    { 1203, "Equipment Technologies, Inc." },
    { 1204, "Miller Technology Incorporated" },
    { 1205, "Carbon Autonomous Robotic Systems" },
    { 1206, "STE Solutions B.V." },
    { 1207, "UEC Electronics" },
    { 1208, "Afflield Kft. (MachineryGuide)" },
    { 1209, "Bauser GmbH & Co. KG" },
    { 1210, "Ambra Solutions" },
    { 1211, "Kiwon Electronics Co., Ltd." },
    { 1212, "TAO Performance Limited" },
    { 1213, "Apollo Tyres Ltd" },
    { 1214, "Element 1" },
    { 1215, "Power Control Systems" },
    { 1216, "SMP Poland sp. z o.o." },
    { 1217, "FSG Fernsteuergeräte Kurt Oelsch GmbH" },
    { 1218, "Septentrio" },
    { 1219, "Weidmueller Interface GmbH & Co. KG" },
    { 1220, "Catamaran Electronics LLC" },
    { 1221, "Norcold Inc." },
    { 1222, "Tough Tech Ltd." },
    { 1223, "Toyo Agricultural Machinery Manufacturing Co., Ltd." },
    { 1224, "Neuser Elektrotechnik GmbH" },
    { 1225, "SeedMaster Manufacturing Ltd." },
    { 1226, "Piippo Hydraulic" },
    { 1227, "YAHATA Co., Ltd." },
    { 1228, "INTILION GmbH" },
    { 1229, "Arcon Designs, LLC" },
    { 1230, "Nick Abbey Digital Agriculture Ltd" },
    { 1231, "Excidor AB" },
    { 1232, "Treffler Maschinenbau GmbH & Co. KG" },
    { 1233, "nke Marine Electronics" },
    { 1234, "American Battery Solutions" },
    { 1235, "NESAN Automotive Inc." },
    { 1236, "Agrosystem" },
    { 1237, "Changzhou Lambda Electronic Co., Ltd" },
    { 1238, "Honda Electronics Co., Ltd" },
    { 1239, "SuperTrack Aps" },
    { 1240, "TiMOTION" },
    { 1241, "Ineo Systrans" },
    { 1242, "Super Start Batteries" },
    { 1243, "AvMap S.r.l." },
    { 1244, "Planti Center" },
    { 1245, "Raritan Engineering Company, Inc" },
    { 1246, "Rother Industries & Technology" },
    { 1247, "GRIFA" },
    { 1248, "O.M.F.B. S.p.A. Hydraulic Components" },
    { 1249, "Integrated Power Solutions AG" },
    { 1250, "ELHO" },
    { 1251, "Valmet Automotive EV Power Ltd" },
    { 1252, "APV - Technische Produkte GmbH" },
    { 1253, "Trafag AG" },
    { 1254, "ARADEX AG" },
    { 1255, "Altec Industries, Inc." },
    { 1256, "Dimensions Agri Technologies AS" },
    { 1257, "KOSTAL" },
    { 1258, "AGC Technologies" },
    { 1259, "Grayson Automotive Services Limited" },
    { 1260, "Interactive Technologies, Inc." },
    { 1261, "AgXeed" },
    { 1262, "Fort Robotics" },
    { 1263, "BOS Balance of Storage Systems AG" },
    { 1264, "Microelect" },
    { 1265, "IPETRONIK GmbH & Co KG" },
    { 1266, "Hyundai Doosan Infracore" },
    { 1267, "Wacker Neuson SE" },
    { 1268, "Back 40 Precision Inc." },
    { 1269, "VIS Hydraulics s.r.l." },
    { 1270, "Versalift Denmark A/S" },
    { 1271, "Raven Connected" },
    { 1272, "Samsara Inc." },
    { 1273, "Clearflame Engines Inc" },
    { 1274, "LDL Technology" },
    { 1275, "O.M.P. Officine Mazzocco Pagnoni S.r.l." },
    { 1276, "Aspin Kemp & Associates" },
    { 1277, "BMZ Germany GmbH" },
    { 1278, "Comrod Communication Group" },
    { 1279, "Ognibene Power S.p.A." },
    { 1280, "SANTEST CO., LTD." },
    { 1281, "iQuus" },
    { 1282, "COTEK ELECTRONIC IND. CO., LTD" },
    { 1283, "LTG Tech" },
    { 1284, "Robot Makers GmbH" },
    { 1285, "Graco Inc." },
    { 1286, "NEXAT GmbH" },
    { 1287, "Spartan Radar" },
    { 1288, "ANELLO Photonics" },
    { 1289, "Loadrite (Auckland) Ltd." },
    { 1290, "WaveTamer Partners LLC" },
    { 1291, "Forward Thinking Systems LLC" },
    { 1292, "SUMITOMO CONSTRUCTION MACHINERY Co., Ltd." },
    { 1293, "POSITAL" },
    { 1294, "TR-Electronic GmbH" },
    { 1295, "SIP d.d." },
    { 1296, "Hexagon" },
    { 1297, "Micro-Epsilon Messtechnik GmbH & Co. KG" },
    { 1298, "SFOGGIA Agriculture Division S.r.l." },
    { 1299, "Energy Solutions" },
    { 1300, "Watt Fuel Cell Corporation" },
    { 1301, "Tecumseh do Brasil Ltda" },
    { 1302, "ProMariner" },
    { 1303, "Carbon Bee AgTech" },
    { 1304, "Palfinger Europe GmbH" },
    { 1305, "dragonfly Energy" },
    { 1306, "Koden Electronics Co., Ltd." },
    { 1307, "Smart AG Systems" },
    { 1308, "Agtecnic" },
    { 1309, "Shanghai Zhichuan Electronic Tech Co., Ltd." },
    { 1310, "LPL Systems (formerly Loughborough Projects Ltd)" },
    { 1311, "Humphree AB" },
    { 1312, "Control Devices Pty Ltd" },
    { 1313, "United States Army - Ground Vehicle Systems Center" },
    { 1314, "Newton Crouch Company, LLC" },
    { 1315, "SMPC Technologies Ltd." },
    { 1316, "Hinkley Yachts" },
    { 1317, "GMM - Global Maritime Management GmbH" },
    { 1318, "Atlis Motor Vehicles" },
    { 1319, "I/O Controls Corporation" },
    { 1320, "Triskel Marine Ltd" },
    { 1321, "PATLITE Corporation" },
    { 1322, "Movimatica" },
    { 1323, "Briter Products, Inc." },
    { 1324, "Bourgault Industries" },
    { 1325, "BASE Engineering Inc." },
    { 1326, "HBC-radiomatic GmbH" },
    { 1327, "Frans Vervaet B.V." },
    { 1328, "PerPlant ApS" },
    { 1329, "IDM S.r.l." },
    { 1330, "Warwick Control Technologies" },
    { 1331, "Dolphin Charger" },
    { 1332, "Fairbanks Scales, Inc." },
    { 1333, "xFarm Technologies SA" },
    { 1334, "Greer Company" },
    { 1335, "CPDEVICE" },
    { 1336, "Aegis Power Systems, Inc." },
    { 1337, "Barnacle Systems Inc." },
    { 1338, "Volta Trucks AB" },
    { 1339, "Tillett and Hague Technology Limited" },
    { 1340, "ORELTEK Elektronik ve Yazılım Teknolojileri" },
    { 1341, "Ag Express Electronics" },
    { 1342, "DKE-Data GmbH & Co. KG" },
    { 1343, "Heavy Data GmbH" },
    { 1344, "Haulotte Group" },
    { 1345, "PRIGNITZ Mikrosystemtechnik GmbH" },
    { 1346, "Einboeck GmbH" },
    { 1347, "Munckhof Fruit Tech Innovators" },
    { 1348, "Radian IoT, Inc." },
    { 1349, "ANNABURGER Nutzfahrzeug GmbH" },
    { 1350, "AGRONETIC" },
    { 1351, "Motorenfabrik Hatz GmbH & Co. KG" },
    { 1352, "NISHIYAMA Corporation" },
    { 1353, "Ocean LED Marine Ltd" },
    { 1354, "Técnicas de Electrónica y Automatismos, S.A." },
    { 1355, "DROP Agricultura Ltda" },
    { 1356, "Nordic Lights Ltd" },
    { 1357, "TireCheck" },
    { 1358, "Fontaine Fifth Wheel" },
    { 1359, "BlueNav" },
    { 1360, "Lemca Vision" },
    { 1361, "Nantong Saiyang Electronics Co., Ltd." },
    { 1362, "Zparq AB" },
    { 1363, "Calix AB" },
    { 1364, "Yashu Systems" },
    { 1365, "JVCKENWOOD Corporation" },
    { 1366, "Telemecanique Sensors & Switches" },
    { 1367, "Dewulf NV" },
    { 1368, "RAD Propulsion Ltd" },
    { 1369, "Electric Yacht" },
    { 1370, "Emtech S.A." },
    { 1371, "First Mode" },
    { 1372, "Elco Motor Yachts" },
    { 1373, "Centek Industries" },
    { 1374, "CASAPPA S.p.A." },
    { 1375, "ŠKODA ELECTRIC a.s." },
    { 1376, "SUNS International, LLC" },
    { 1377, "ABD Solutions" },
    { 1378, "Bertini SA" },
    { 1379, "Novag SAS" },
    { 1380, "ADVES GmbH & Co. KG" },
    { 1381, "Dr. Diesel Technologies" },
    { 1382, "Thornwave Labs Inc." },
    { 1383, "Alpego S.p.A." },
    { 1384, "Tecnoseal Foundry S.r.l." },
    { 1385, "Pro Charging Systems, LLC" },
    { 1386, "Smart Eye AB" },
    { 1387, "Radel (Pty) Ltd" },
    { 1388, "Nira Technology" },
    { 1389, "EVEX Co., LTD" },
    { 1390, "FJ Dynamics International Limited" },
    { 1391, "AriensCo" },
    { 1392, "Phoenix America LLC" },
    { 1393, "Powerland Technology Inc" },
    { 1394, "Zhejiang Ruixing Electromechanical Technology Co., Ltd." },
    { 1395, "MLB Industrial" },
    { 1396, "Fast Ag Solutions, LLC" },
    { 1397, "SaMASZ Sp. Z o.o." },
    { 1398, "Gobius Sensor Technology AB" },
    { 1399, "Hans Brantner & Sohn Fahrzeugbaugesellschaft mbH" },
    { 1400, "IWN GmbH & Co. KG" },
    { 1401, "ROM Communications Inc." },
    { 1402, "ComNav Technology Ltd." },
    { 1403, "Arco Marine" },
    { 1404, "BRUSA HyPower AG" },
    { 1405, "TELIG Electronics" },
    { 1406, "Lumilex ALT SRL" },
    { 1407, "Open-Agriculture" },
    { 1408, "Lenco Marine Inc." },
    { 1409, "Z Elektronika Kft." },
    { 1410, "Allan Equipment Manufacturing Ltd." },
    { 1411, "Shanghai Huace Navigation Technology Ltd." },
    { 1412, "Naocontrol S.L." },
    { 1413, "OHNOH2O LLC" },
    { 1414, "INTRACOM DEFENSE S.A." },
    { 1415, "Máquinas Agrícolas Jacto S.A." },
    { 1416, "Wavetronix LLC" },
    { 1417, "Revatek LLC" },
    { 1418, "Karluna Engineering" },
    { 1419, "iPatch Marine" },
    { 1420, "TALOS - Precision Measurement Technologies" },
    { 1421, "Clarios, LLC" },
    { 1422, "xTCU AG" },
    { 1423, "AC S.A." },
    { 1424, "Bewis" },
    { 1425, "Electronics in Agriculture, School of Engineering, University of Galway" },
    { 1426, "Samson Group" },
    { 1427, "REITER RESPIRO" },
    { 1428, "Samo Maschinenbau GmbH" },
    { 1429, "Nikola Corporation" },
    { 1430, "Mantracourt Electronics Ltd" },
    { 1431, "Nauto Inc." },
    { 1432, "MDH Defence Ltd." },
    { 1433, "Unicontrol ApS" },
    { 1434, "eSurvey GNSS Ltd." },
    { 1435, "Heilongjiang Huida Technology Co., Ltd" },
    { 1436, "M-extend" },
    { 1437, "DOKEN Technology Co. Ltd." },
    { 1438, "Aeolionics" },
    { 1439, "PredictWind Ltd" },
    { 1440, "Egis Mobile Electric" },
    { 1441, "Shanghai Allynav Technology Co.,Ltd." },
    { 1442, "EVYTRA GmbH" },
    { 1443, "SoilEssentials Limited" },
    { 1444, "Micropower Group" },
    { 1445, "Starboard Yacht Group" },
    { 1446, "Roswell Marine" },
    { 1447, "Innotag Distributions Inc." },
    { 1448, "Elmer's Manufacturing" },
    { 1449, "Bontaz Centre" },
    { 1450, "Agrivaux" },
    { 1451, "Guangdong ePropulsion Technology Ltd." },
    { 1452, "Micro-Air LLC" },
    { 1453, "Vital Battery" },
    { 1454, "QTIS B.V." },
    { 1455, "Eberspächer Climate Control Systems International GmbH" },
    { 1456, "Krampe Fahrzeugbau GmbH" },
    { 1457, "Albach Maschinenbau AG" },
    { 1569, "621 Technologies Inc." },
    { 1850, "Seastar Solutions (formerly Teleflex)" },
    { 1851, "RayMarine" },
    { 1852, "Navionics" },
    { 1853, "Japan Radio Co" },
    { 1854, "Northstar Technologies" },
    { 1855, "Furuno USA" },
    { 1856, "Trimble" },
    { 1857, "Simrad" },
    { 1858, "Litton" },
    { 1859, "Kvasar AB" },
    { 1860, "MMP" },
    { 1861, "Vector North America (formerly Vector Cantech)" },
    { 1862, "Sanshin" },
    { 1863, "Thomas G. Faria Co." },
    { 0, NULL }
};
static value_string_ext isobus_manufacturers_ext = VALUE_STRING_EXT_INIT(_isobus_manufacturers);

static const value_string _isobus_pgn_names[] = {
    { 0, "Torque/Speed Control 1" },
    { 256, "Transmission Control 1" },
    { 512, "Electronic Brake System #1/1" },
    { 768, "Electronic Brake System #2/1" },
    { 1024, "External Brake Request" },
    { 1280, "CANopen Application Message #1/1" },
    { 1536, "CANopen Application Message #2/1" },
    { 1792, "General Purpose Valve Pressure" },
    { 2048, "Auxiliary Input/Output Status 5" },
    { 2304, "Static Roll Angle Sensor Information" },
    { 2560, "Cruise Control / Vehicle Speed 2" },
    { 2816, "Advanced Emergency Braking System 2" },
    { 3072, "Electronic Engine Controller 16" },
    { 3328, "Transmission Control 2" },
    { 3584, "Safety Header Message" },
    { 3840, "High Voltage Energy Storage Pack 11 Control 1" },
    { 4096, "High Voltage Energy Storage Pack 12 Control 1" },
    { 4352, "High Voltage Energy Storage Pack 13 Control 1" },
    { 4608, "High Voltage Energy Storage Pack 14 Control 1" },
    { 4864, "High Voltage Energy Storage Pack 15 Control 1" },
    { 5120, "High Voltage Energy Storage Pack 16 Control 1" },
    { 5376, "High Voltage Energy Storage Pack 17 Control 1" },
    { 5632, "High Voltage Energy Storage Pack 18 Control 1" },
    { 5888, "High Voltage Energy Storage Pack 19 Control 1" },
    { 6144, "High Voltage Energy Storage Pack 20 Control 1" },
    { 6400, "High Voltage Energy Storage Pack 21 Control 1" },
    { 6656, "High Voltage Energy Storage Pack 22 Control 1" },
    { 6912, "High Voltage Energy Storage System Control 1" },
    { 7168, "Transmission Control 3 (Obsolete, see PGN 16896)" },
    { 7424, "Engine Ignition Controller" },
    { 7680, "Alternator Control" },
    { 7936, "High Voltage Energy Storage Pack 23 Control 1" },
    { 8192, "High Voltage Energy Storage Pack 24 Control 1" },
    { 8448, "High Voltage Energy Storage Pack 25 Control 1" },
    { 8704, "High Voltage Energy Storage Pack 26 Control 1" },
    { 8960, "Tractor Implement Management (TIM) Server to TIM Client" },
    { 9216, "Tractor Implement Management (TIM) Client to TIM Server" },
    { 9472, "Multi-PG" },
    { 9728, "Motor/Generator 1 Inverter Control" },
    { 9984, "Motor/Generator 2 Inverter Control" },
    { 10240, "Motor/Generator 1 Inverter Rate Limits Request 1" },
    { 10496, "Motor/Generator 2 Inverter Rate Limits Request 1" },
    { 10752, "High Voltage Energy Storage Pack 1 Control 1" },
    { 11008, "High Voltage Energy Storage Pack 2 Control 1" },
    { 11264, "High Voltage Energy Storage Pack 3 Control 1" },
    { 11520, "High Voltage Energy Storage Pack 4 Control 1" },
    { 11776, "High Voltage Energy Storage Pack 5 Control 1" },
    { 12032, "High Voltage Energy Storage Pack 6 Control 1" },
    { 12288, "High Voltage Energy Storage Pack 7 Control 1" },
    { 12544, "High Voltage Energy Storage Pack 8 Control 1" },
    { 12800, "High Voltage Energy Storage Pack 9 Control 1" },
    { 13056, "High Voltage Energy Storage Pack 10 Control 1" },
    { 13312, "Reliable Long Message" },
    { 13568, "Reliable Short Message" },
    { 13824, "Unreliable Message" },
    { 14080, "Message Acknowledbement" },
    { 14336, "Version Negotiation Section" },
    { 14592, "External ACC Acceleration Request" },
    { 14848, "Battery Charger 1 Command 1" },
    { 15104, "Battery Charger 2 Command 1" },
    { 15360, "Tractor Implement Management (TIM) Server to TIM Client - Control Status" },
    { 15616, "Tractor Implement Management (TIM) Client to TIM Server - Control Status" },
    { 15872, "Fuel Cell System Control Command" },
    { 16128, "Fuel Cell System Power Limit Command" },
    { 16384, "Fuel Cell System Current Limit Command" },
    { 16640, "Hydrogen Storage System Control Command" },
    { 16896, "Transmission Control 4" },
    { 17920, "API Select" },
    { 18432, "Tractor Implement Management (TIM) Server to Client - Initialization & Parameterization" },
    { 18688, "Tractor Implement Management (TIM) Client to Server - Initialization & Parameterization" },
    { 18944, "EV Multi-Connection DC Status 1" },
    { 19200, "EV Multi-Connection DC Charging Limits 1" },
    { 19456, "Electrified Accessory Engine Coolant Pump Command" },
    { 19712, "FD Transport Protocol - Connection Mgmt" },
    { 19968, "FD Transport Protocol - Data Transfer" },
    { 20224, "Data Transfer Support" },
    { 20480, "Monthly Data Transfer" },
    { 20736, "Weekly Data Transfer" },
    { 20992, "Daily Data Transfer" },
    { 21248, "EVSE Control 1" },
    { 21504, "Winch Information 3" },
    { 21760, "Air Suspension Control 8" },
    { 22016, "Motor/Generator 2 Inverter Control 2" },
    { 22272, "Motor/Generator 1 Inverter Control 2" },
    { 22528, "Hoist Command Information" },
    { 22784, "Motor/Generator 2 Inverter Isolation Integrity Request" },
    { 23040, "Motor/Generator 1 Inverter Isolation Integrity Request" },
    { 23296, "Motor/Generator 2 Inverter Limits Request Power" },
    { 23552, "Motor/Generator 2 Inverter Limits Request Mechanical" },
    { 23808, "Motor/Generator 2 Inverter Limits Request DC Side" },
    { 24064, "Motor/Generator 1 Inverter Limits Request DC Side" },
    { 24320, "Motor/Generator 1 Inverter Limits Request Mechanical" },
    { 24576, "Motor/Generator 1 Inverter Limits Request Power" },
    { 24832, "Personnel Detect Interlock" },
    { 25088, "Engine Cylinder Combustion Configuration Feedback" },
    { 25344, "Engine Cylinder Combustion Configuration" },
    { 25600, "Engine Cylinder Pressure Timing Feedback" },
    { 25856, "Engine Cylinder Pressure Timing Configuration" },
    { 26112, "Electrified Accessory Generator Coolant Pump Command " },
    { 26368, "Electrified Accessory Generator Coolant Fan Command " },
    { 26624, "On Board Programming 1" },
    { 26880, "Marine Control Information Configuration 1" },
    { 27136, "Marine Control Information 2" },
    { 27392, "Well Stimulation Pump Sensor Calibration Command" },
    { 27648, "CiA 602-2 XCP" },
    { 27904, "Well Stimulation Pump System Configuration Command" },
    { 28160, "Configurable Receive SPNs Command" },
    { 28416, "Authentication Client to Authentication Server" },
    { 28672, "Authentication Server to Authentication Client" },
    { 28928, "Configurable Transmit PGNs Command" },
    { 29184, "Oil Debris Monitor Configuration Command" },
    { 29440, "Electrified Accessory Propulsion Motor Coolant Fan 3 Command" },
    { 29696, "Electrified Accessory Propulsion Motor Coolant Fan 2 Command" },
    { 29952, "Electrified Accessory Propulsion Motor Coolant Fan 1 Command" },
    { 30208, "Electrified Accessory Power Electronics Coolant Fan 3 Command" },
    { 30464, "Electrified Accessory Power Electronics Coolant Fan 2 Command" },
    { 30720, "Electrified Accessory Power Electronics Coolant Fan 1 Command" },
    { 30976, "Electrified Accessory Propulsion Motor Oil Pump Command" },
    { 31232, "Electrified Accessory Propulsion Motor Coolant Pump Command" },
    { 31488, "Electrified Accessory Power Electronics Coolant Pump Command" },
    { 32000, "Electrified Accessory Motor Command" },
    { 32256, "Engine Speed Ramp Rate Boundary Request" },
    { 32512, "Tire Sensor Identification Command" },
    { 32768, "Hybrid or EV System Control 1" },
    { 33024, "Aftertreatment System Control" },
    { 33280, "Tire Configuration Command Information" },
    { 33536, "Payload Calibration Information Command" },
    { 33792, "Aftertreatment 1 Particulate Sensor Control" },
    { 34048, "Cab Message 2" },
    { 34304, "Switched Power Outputs Command" },
    { 34560, "Engine State Requests" },
    { 34816, "Radio Beacon Request" },
    { 35072, "Running Gear Equipment #2/4" },
    { 35328, "Running Gear Equipment #1/2" },
    { 35584, "CCP Data Transmission Object" },
    { 35840, "CCP Command Receive Object" },
    { 36096, "Sequence Control Client-to-Sequence Control Master" },
    { 36352, "Sequence Control Master-to-Sequence Control Client" },
    { 36608, "Engine Configuration Commands" },
    { 36864, "Supplemental Fan Command" },
    { 37120, "Vehicle/Chassis Lubrication System 1" },
    { 37376, "Aftertreatment 1 Hydrocarbon Doser Information 1" },
    { 37632, "NAME Management Message" },
    { 37888, "Aftertreatment 1 Diesel Particulate Filter Soot Sensor Calibration" },
    { 38144, "Aftertreatment 2 Diesel Particulate Filter Soot Sensor Calibration" },
    { 38400, "Low Voltage Disconnect Set Operating Mode" },
    { 38656, "Noise Control Status" },
    { 38912, "Noise Control 1" },
    { 39168, "Joystick Lamp Command Message" },
    { 39424, "General Purpose Message #1/8" },
    { 39680, "Proprietary Method Identification" },
    { 39936, "Auxiliary Input/Output Status 7" },
    { 40192, "Auxiliary Input/Output Status 6" },
    { 40448, "DTC Counts" },
    { 40704, "Immediate Fault Status" },
    { 40960, "NTE Status" },
    { 41216, "Emission Increasing Auxiliary Emission Control Device Active Time" },
    { 41472, "Regulated Exhaust Emission Level Exceedance" },
    { 41728, "DTC To Lamp Association" },
    { 41984, "Scaled Test Results" },
    { 42240, "Auxiliary Input/Output Status 4" },
    { 42496, "Auxiliary Input/Output Status 3" },
    { 42752, "Auxiliary Input/Output Status 2" },
    { 43008, "Text Display" },
    { 43264, "Forward Lane Image Command" },
    { 43520, "Client (ECU) to File Server message" },
    { 43776, "File Server to Client (ECU) message" },
    { 44032, "Agricultural Guidance Machine Info" },
    { 44288, "Agricultural Guidance System command" },
    { 44544, "Tire Pressure Reference Setting" },
    { 44800, "Parameter Locate Message" },
    { 45056, "Configuration Identification Message" },
    { 45312, "Proprietarily Configurable Message #1" },
    { 45568, "Proprietarily Configurable Message #2" },
    { 45824, "Proprietarily Configurable Message #3" },
    { 46080, "Proprietarily Configurable Message #4" },
    { 46336, "Proprietarily Configurable Message #5" },
    { 46592, "Proprietarily Configurable Message #6" },
    { 46848, "Proprietarily Configurable Message #7" },
    { 47104, "Proprietarily Configurable Message #8" },
    { 47360, "Proprietarily Configurable Message #9" },
    { 47616, "Proprietarily Configurable Message #10" },
    { 47872, "Proprietarily Configurable Message #11" },
    { 48128, "Proprietarily Configurable Message #12" },
    { 48384, "Proprietarily Configurable Message #13" },
    { 48640, "Proprietarily Configurable Message #14" },
    { 48896, "Proprietarily Configurable Message #15" },
    { 49152, "Proprietarily Configurable Message #16" },
    { 49408, "Diagnostic Readiness 2" },
    { 49664, "Monitor Performance Ratio" },
    { 49920, "Individual Clear/Reset Of Active And Previously Active DTC" },
    { 50176, "General Purpose Valve command" },
    { 50432, "General Purpose Valve measured flow" },
    { 50688, "General Purpose Valve estimated flow" },
    { 50944, "Extended Transport Protocol - Data Transfer" },
    { 51200, "Extended Transport Protocol - Connection Management" },
    { 51456, "Request 2" },
    { 51712, "Transfer" },
    { 51968, "Process Data Message" },
    { 52224, "Request for Repetition Rate" },
    { 52480, "Reserved for ISO 15765-2" },
    { 52736, "Reserved for ISO 15765-2" },
    { 52992, "Continuous Torque & Speed Limit Request" },
    { 53248, "Background lighting level command" },
    { 53504, "Air Suspension Control 6" },
    { 53760, "Air Suspension Control 2" },
    { 54016, "Calibration Information" },
    { 54272, "Data Security" },
    { 54528, "Time/Date Adjust" },
    { 54784, "Boot Load Data" },
    { 55040, "Binary Data Transfer" },
    { 55296, "Memory Access Response" },
    { 55552, "Memory Access Request" },
    { 55808, "Reserved for ISO 15765-2" },
    { 56064, "Reserved for ISO 15765-2" },
    { 56320, "Anti-theft Status" },
    { 56576, "Anti-theft Request" },
    { 56832, "Reset" },
    { 57088, "Stop Start Broadcast" },
    { 57344, "Cab Message 1" },
    { 57600, "General Purpose Message #2/1" },
    { 57856, "General Purpose Message #1/1" },
    { 58112, "Command Non-continuously Monitored Test" },
    { 58368, "Running Gear Equipment #1/1" },
    { 58624, "Running Gear Equipment #2/1" },
    { 58880, "Virtual Terminal-to-Node" },
    { 59136, "Node-to-Virtual Terminal" },
    { 59392, "Acknowledgment Message" },
    { 59904, "Request" },
    { 60160, "Transport Protocol - Data Transfer" },
    { 60416, "Transport Protocol - Connection Mgmt" },
    { 60672, "Network Message" },
    { 60928, "Address Claimed" },
    { 61184, "Proprietary A" },
    { 61440, "Electronic Retarder Controller 1" },
    { 61441, "Electronic Brake Controller 1" },
    { 61442, "Electronic Transmission Controller 1" },
    { 61443, "Electronic Engine Controller 2" },
    { 61444, "Electronic Engine Controller 1" },
    { 61445, "Electronic Transmission Controller 2" },
    { 61446, "Electronic Axle Controller 1" },
    { 61447, "Forward Lane Image 1" },
    { 61448, "Hydraulic Pressure Governor Info" },
    { 61449, "Vehicle Dynamic Stability Control 2" },
    { 61450, "Engine Gas Flow Rate" },
    { 61451, "Electronic Steering Control" },
    { 61452, "Electronic Transmission Controller #8" },
    { 61453, "Land Leveling System Operational Information" },
    { 61454, "Aftertreatment 1 Intake Gas 1" },
    { 61455, "Aftertreatment 1 Outlet Gas 1" },
    { 61456, "Aftertreatment 2 Intake Gas 1" },
    { 61457, "Aftertreatment 2 Outlet Gas 1" },
    { 61458, "Fifth Wheel Smart Systems 1" },
    { 61459, "Slope Sensor Information" },
    { 61460, "Blade Information" },
    { 61461, "Requested Generator Total AC Reactive Power" },
    { 61462, "Cylinder Combustion Status" },
    { 61463, "Engine Knock Level #1" },
    { 61464, "Engine Knock Level #2" },
    { 61465, "Engine Knock Level #3" },
    { 61466, "Engine Throttle / Fuel Actuator Control Command" },
    { 61467, "General Purpose Message #1/7" },
    { 61468, "Requested Generator Average Basic AC Quantities" },
    { 61469, "Steering Angle Sensor Information" },
    { 61470, "Generator Control 2" },
    { 61471, "Electronic Brake System #2/6" },
    { 61472, "Electronic Brake System #2/5" },
    { 61473, "Engine Speed Sensor Information 1" },
    { 61474, "Machine Selected Speed" },
    { 61475, "Aftertreatment 1 SCR Dosing System Information 1" },
    { 61476, "Aftertreatment 1 SCR Dosing System Requests 1" },
    { 61477, "Aftertreatment 1 SCR Ammonia Information" },
    { 61478, "Aftertreatment 2 SCR Dosing System Information 1" },
    { 61479, "Aftertreatment 2 SCR Dosing System Requests 1" },
    { 61480, "Aftertreatment 2 SCR Ammonia Information" },
    { 61481, "Slope Sensor Information 2" },
    { 61482, "Angular Rate Information" },
    { 61483, "Crash Notification" },
    { 61484, "Magnet Status Information 2" },
    { 61485, "Acceleration Sensor" },
    { 61486, "Engine Turbocharger Control 1" },
    { 61487, "Advanced Emergency Braking System 1" },
    { 61488, "Wireless Status" },
    { 61489, "Wand Sensor" },
    { 61490, "Linear Displacement Sensor" },
    { 61491, "Aftertreatment 1 SCR Ammonia Information 2" },
    { 61492, "Aftertreatment 2 SCR Ammonia Information 2" },
    { 61494, "High Voltage Energy Storage System Status 2" },
    { 61495, "Engine Turbocharger Blowoff Actuator 1" },
    { 61496, "Engine Torque / Fuel Request" },
    { 61497, "Engine Air System Information" },
    { 61498, "Engine Cylinder 1 Combustion Information" },
    { 61499, "Engine Cylinder 2 Combustion Information" },
    { 61500, "Engine Cylinder 3 Combustion Information" },
    { 61501, "Engine Cylinder 4 Combustion Information" },
    { 61502, "Engine Cylinder 5 Combustion Information" },
    { 61503, "Engine Cylinder 6 Combustion Information" },
    { 61504, "Engine Cylinder 7 Combustion Information" },
    { 61505, "Engine Cylinder 8 Combustion Information" },
    { 61506, "Engine Cylinder 9 Combustion Information" },
    { 61507, "Engine Cylinder 10 Combustion Information" },
    { 61508, "Engine Cylinder 11 Combustion Information" },
    { 61509, "Engine Cylinder 12 Combustion Information" },
    { 61510, "Engine Cylinder 13 Combustion Information" },
    { 61511, "Engine Cylinder 14 Combustion Information" },
    { 61512, "Engine Cylinder 15 Combustion Information" },
    { 61513, "Engine Cylinder 16 Combustion Information" },
    { 61514, "Engine Cylinder 17 Combustion Information" },
    { 61515, "Engine Cylinder 18 Combustion Information" },
    { 61516, "Engine Cylinder 19 Combustion Information" },
    { 61517, "Engine Cylinder 20 Combustion Information" },
    { 61518, "Engine Cylinder 1 Combustion Average Information" },
    { 61519, "Engine Cylinder 2 Combustion Average Information" },
    { 61520, "Engine Cylinder 3 Combustion Average Information" },
    { 61521, "Engine Cylinder 4 Combustion Average Information" },
    { 61522, "Engine Cylinder 5 Combustion Average Information" },
    { 61523, "Engine Cylinder 6 Combustion Average Information" },
    { 61524, "Engine Cylinder 7 Combustion Average Information" },
    { 61525, "Engine Cylinder 8 Combustion Average Information" },
    { 61526, "Engine Cylinder 9 Combustion Average Information" },
    { 61527, "Engine Cylinder 10 Combustion Average Information" },
    { 61528, "Engine Cylinder 11 Combustion Average Information" },
    { 61529, "Engine Cylinder 12 Combustion Average Information" },
    { 61530, "Engine Cylinder 13 Combustion Average Information" },
    { 61531, "Engine Cylinder 14 Combustion Average Information" },
    { 61532, "Engine Cylinder 15 Combustion Average Information" },
    { 61533, "Engine Cylinder 16 Combustion Average Information" },
    { 61534, "Engine Cylinder 17 Combustion Average Information" },
    { 61535, "Engine Cylinder 18 Combustion Average Information" },
    { 61536, "Engine Cylinder 19 Combustion Average Information" },
    { 61537, "Engine Cylinder 20 Combustion Average Information" },
    { 61538, "Electronic Transmission Controller #12" },
    { 61539, "Fuel Information 5 (Gaseous)" },
    { 61540, "Engine Gaseous Fuel Valve Duration Command 1" },
    { 61541, "Engine Gaseous Fuel Valve Duration Command 2" },
    { 61542, "Engine Gaseous Fuel Valve Duration Command 3" },
    { 61543, "Engine Gaseous Fuel Valve Duration Command 4" },
    { 61544, "Engine Gaseous Fuel Valve Duration Command 5" },
    { 61545, "Engine Gaseous Fuel Valve Start of Actuation Command 1" },
    { 61546, "Engine Gaseous Fuel Valve Start of Actuation Command 2" },
    { 61547, "Engine Gaseous Fuel Valve Start of Actuation Command 3" },
    { 61548, "Engine Gaseous Fuel Valve Start of Actuation Command 4" },
    { 61549, "Engine Gaseous Fuel Valve Start of Actuation Command 5" },
    { 61550, "Fuel Pump Actuator Control Command" },
    { 61551, "Power Converter 1 Control 1" },
    { 61552, "Power Converter 2 Control 1" },
    { 61553, "Power Converter 1 Rate Limits Request 1" },
    { 61554, "Power Converter 2 Rate Limits Request 1" },
    { 61555, "Power Converter 2 Control 2" },
    { 61556, "Power Converter 1 Control 2" },
    { 61557, "Power Converter 1 Mode Feedback 1" },
    { 61558, "Power Converter 1 Limits Active Power" },
    { 61559, "Power Converter 1 Limits Active Electrical" },
    { 61560, "Power Converter 1 Limits Active DC Energy Source 1" },
    { 61561, "Power Converter 1 Low Voltage" },
    { 61562, "Power Converter 2 Mode Feedback 1" },
    { 61563, "Power Converter 2 Limits Active Power" },
    { 61564, "Power Converter 2 Limits Active Electrical" },
    { 61565, "Power Converter 2 Limits Active DC Energy Source 1" },
    { 61566, "Power Converter 2 Low Voltage" },
    { 61567, "Power Converter 1 Status 2" },
    { 61568, "Power Converter 1 Rate Limits Active 1" },
    { 61569, "Power Converter 2 Status 2" },
    { 61570, "Power Converter 2 Rate Limits Active 1" },
    { 61571, "Power Converter 2 Isolation Integrity" },
    { 61572, "Power Converter 1 Isolation Integrity" },
    { 61573, "Power Converter 2 Status 1" },
    { 61574, "Power Converter 1 Status 1" },
    { 61575, "Wireless Charger System Status 1" },
    { 61576, "Wireless Charger Alignment Quality Status" },
    { 61577, "Motor/Generator 1 Inverter Control Status 3" },
    { 61578, "Motor/Generator 2 Inverter Control Status 3" },
    { 61579, "Motor/Generator 3 Inverter Control Status 3" },
    { 61580, "Motor/Generator 4 Inverter Control Status 3" },
    { 61581, "Motor/Generator 5 Inverter Control Status 3" },
    { 61582, "Motor/Generator 6 Inverter Control Status 3" },
    { 61584, "High Voltage Energy Storage System Data 1" },
    { 61585, "High Voltage Energy Storage System Data 2" },
    { 61586, "High Voltage Energy Storage System Data 3" },
    { 61587, "High Voltage Energy Storage System Data 4" },
    { 61588, "High Voltage Energy Storage System Data 5" },
    { 61589, "High Voltage Energy Storage System Data 6" },
    { 61590, "High Voltage Energy Storage System Status 1" },
    { 61591, "Motor/Generator 1 Inverter Thermal Performance Status  " },
    { 61592, "Motor/Generator 2 Inverter Thermal Performance Status  " },
    { 61593, "Motor/Generator 3 Inverter Thermal Performance Status  " },
    { 61594, "Motor/Generator 4 Inverter Thermal Performance Status  " },
    { 61595, "Motor/Generator 5 Inverter Thermal Performance Status  " },
    { 61596, "Motor/Generator 6 Inverter Thermal Performance Status  " },
    { 61600, "High Voltage Energy Storage System Data 7" },
    { 61640, "DC/AC Accessory Inverter 1 Status 2" },
    { 61641, "DC/AC Accessory Inverter 1 Voltage" },
    { 61642, "DC/AC Accessory Inverter 1 Feedback 2" },
    { 61643, "DC/AC Accessory Inverter 2 Status 2" },
    { 61644, "DC/AC Accessory Inverter 2 Voltage" },
    { 61645, "DC/AC Accessory Inverter 2 Feedback 2" },
    { 61646, "Engine Turbocharger Control 4" },
    { 61647, "Engine Turbocharger Wastegate Actuator and Exhaust Back Pressure Regulator Information 2" },
    { 61648, "Engine Cylinder Combustion Request" },
    { 61649, "Engine Cylinder Head Bypass Actuator 1" },
    { 61650, "Engine Electronic Controller 18" },
    { 61651, "Predictive Cruise Control 1" },
    { 61654, "DC/AC Accessory Inverter 1 Command" },
    { 61655, "DC/AC Accessory Inverter 1 Feedback" },
    { 61658, "DC/AC Accessory Inverter 2 Command" },
    { 61659, "DC/AC Accessory Inverter 2 Feedback" },
    { 61662, "DC/AC Accessory Inverter 3 Command" },
    { 61663, "DC/AC Accessory Inverter 3 Feedback" },
    { 61666, "DC/AC Accessory Inverter 4 Command" },
    { 61667, "DC/AC Accessory Inverter 4 Feedback" },
    { 61668, "Heartbeat Message" },
    { 61669, "Engine Ignition Timing Offset 1" },
    { 61670, "Engine Ignition Timing Offset 2" },
    { 61671, "Engine Ignition Timing Offset 3" },
    { 61672, "Engine Throttle / Fuel Actuator Control Command 2" },
    { 61673, "Aftertreatment 1 Intake Gas 3" },
    { 61674, "Aftertreatment 1 Outlet Gas 3" },
    { 61675, "Aftertreatment 2 Intake Gas 3" },
    { 61676, "Aftertreatment 2 Outlet Gas 3" },
    { 61677, "Engine Start Control" },
    { 61684, "Genset Reactive Power and Supporting Functions" },
    { 61685, "Engine Start Arbitrator" },
    { 61686, "Advanced Driver Assistance Systems Interface Specification 1" },
    { 61687, "Advanced Driver Assistance Systems Interface Specification 2" },
    { 61688, "Advanced Driver Assistance Systems Interface Specification 3" },
    { 61689, "Engine Valve Controller" },
    { 61690, "Electronic Transmission Controller 13" },
    { 61691, "Aftertreatment 1 SCR Dosing System Requests 3" },
    { 61692, "Aftertreatment 2 SCR Dosing System Requests 3" },
    { 61693, "Aftertreatment 1 SCR Dosing System Information 4" },
    { 61694, "Aftertreatment 2 SCR Dosing System Information 4" },
    { 61695, "Secondary or Front Hitch Roll and Pitch" },
    { 61696, "Secondary or Front Hitch Roll and Pitch command" },
    { 61697, "Primary or Rear Hitch Roll and Pitch" },
    { 61698, "Primary or Rear Hitch Roll and Pitch command" },
    { 61699, "Generator Trip Energy" },
    { 61700, "Engine Speed Sensor Information 2" },
    { 61701, "Hydraulic Pressure Displacement" },
    { 61702, "Well Stimulation Pump System 1" },
    { 61703, "Well Stimulation Pump System 2" },
    { 61704, "High Voltage Energy Storage System Module Status 1" },
    { 61705, "High Voltage Energy Storage System Thermal Management System Status 1" },
    { 61706, "High Voltage Energy Storage System Data 8" },
    { 61707, "High Voltage Energy Storage System Data 9" },
    { 61708, "High Voltage Energy Storage System Data 10" },
    { 61709, "Fuel Information 6 (Gaseous)" },
    { 61710, "Dump Truck Body Information" },
    { 61711, "Engine Operating Information 2" },
    { 61712, "Brakes 2" },
    { 61713, "Gaseous Fuel Pressure 3" },
    { 61714, "DC/DC Converter 1 Control" },
    { 61715, "DC/DC Converter 1 Operating Status" },
    { 61716, "DC/DC Converter 1 Voltage and Current" },
    { 61717, "DC/DC Converter 1 SLI Battery Status" },
    { 61718, "Well Stimulation Pump System 3" },
    { 61719, "DC/DC Converter 1 Status 2" },
    { 61720, "DC/DC Converter 2 Control" },
    { 61721, "DC/DC Converter 2 Operating Status" },
    { 61722, "DC/DC Converter 2 Voltage and Current" },
    { 61723, "DC/DC Converter 2 SLI Battery Status" },
    { 61724, "DC/DC Converter 2 Status 2" },
    { 61725, "DC/DC Converter 3 Control" },
    { 61726, "DC/DC Converter 3 Operating Status" },
    { 61727, "DC/DC Converter 3 Voltage and Current" },
    { 61728, "DC/DC Converter 3 SLI Battery Status" },
    { 61729, "DC/DC Converter 3 Status 2" },
    { 61730, "DC/DC Converter 4 Control" },
    { 61731, "DC/DC Converter 4 Operating Status" },
    { 61732, "DC/DC Converter 4 Voltage and Current" },
    { 61733, "DC/DC Converter 4 SLI Battery Status" },
    { 61734, "DC/DC Converter 4 Status 2" },
    { 61735, "Slope Sensor Information 3" },
    { 61736, "DC/AC Accessory Inverter 3 Status 2" },
    { 61737, "DC/AC Accessory Inverter 3 Voltage" },
    { 61738, "DC/AC Accessory Inverter 3 Feedback 2" },
    { 61739, "DC/AC Accessory Inverter 4 Status 2" },
    { 61740, "DC/AC Accessory Inverter 4 Voltage" },
    { 61741, "DC/AC Accessory Inverter 4 Feedback 2" },
    { 61742, "DC/AC Accessory Inverter 5 Command" },
    { 61743, "DC/AC Accessory Inverter 5 Feedback" },
    { 61744, "DC/AC Accessory Inverter 5 Status 2" },
    { 61745, "DC/AC Accessory Inverter 5 Voltage" },
    { 61746, "DC/AC Accessory Inverter 5 Feedback 2" },
    { 61747, "Engine Pre-Chamber Fuel Valve Duration Command 1" },
    { 61748, "Engine Pre-Chamber Fuel Valve Duration Command 2" },
    { 61749, "Engine Pre-Chamber Fuel Valve Duration Command 3" },
    { 61750, "Engine Pre-Chamber Fuel Valve Duration Command 4" },
    { 61751, "Engine Pre-Chamber Fuel Valve Duration Command 5" },
    { 61752, "Engine Pre-Chamber Fuel Valve Start of Actuation Command 1" },
    { 61753, "Engine Pre-Chamber Fuel Valve Start of Actuation Command 2" },
    { 61754, "Engine Pre-Chamber Fuel Valve Start of Actuation Command 3" },
    { 61755, "Engine Pre-Chamber Fuel Valve Start of Actuation Command 4" },
    { 61756, "Engine Pre-Chamber Fuel Valve Start of Actuation Command 5" },
    { 61757, "Active Steering System Controls 1" },
    { 61758, "Secondary or Front Hitch Yaw command" },
    { 61759, "Primary or Rear Hitch Yaw command" },
    { 61760, "Stationary Inverter Average Basic AC Quantities" },
    { 61761, "Stationary Inverter Total AC Reactive Power" },
    { 61762, "Stationary Inverter Total AC Power" },
    { 61763, "Stationary Inverter Control" },
    { 61764, "Stationary Inverter to Bus Sync Check Status" },
    { 61765, "Engine Cylinder 1 Combustion Pressures" },
    { 61766, "Engine Cylinder 2 Combustion Pressures" },
    { 61767, "Engine Cylinder 3 Combustion Pressures" },
    { 61768, "Engine Cylinder 4 Combustion Pressures" },
    { 61769, "Engine Cylinder 5 Combustion Pressures" },
    { 61770, "Engine Cylinder 6 Combustion Pressures" },
    { 61771, "Engine Cylinder 7 Combustion Pressures" },
    { 61772, "Engine Cylinder 8 Combustion Pressures" },
    { 61773, "Engine Cylinder 9 Combustion Pressures" },
    { 61774, "Engine Cylinder 10 Combustion Pressures" },
    { 61775, "Engine Cylinder 11 Combustion Pressures" },
    { 61776, "Engine Cylinder 12 Combustion Pressures" },
    { 61777, "Engine Cylinder 13 Combustion Pressures" },
    { 61778, "Engine Cylinder 14 Combustion Pressures" },
    { 61779, "Engine Cylinder 15 Combustion Pressures" },
    { 61780, "Engine Cylinder 16 Combustion Pressures" },
    { 61781, "Engine Cylinder 17 Combustion Pressures" },
    { 61782, "Engine Cylinder 18 Combustion Pressures" },
    { 61783, "Engine Cylinder 19 Combustion Pressures" },
    { 61784, "Engine Cylinder 20 Combustion Pressures" },
    { 61785, "Engine Cylinder 1 Combustion Timing" },
    { 61786, "Engine Cylinder 2 Combustion Timing" },
    { 61787, "Engine Cylinder 3 Combustion Timing" },
    { 61788, "Engine Cylinder 4 Combustion Timing" },
    { 61789, "Engine Cylinder 5 Combustion Timing" },
    { 61790, "Engine Cylinder 6 Combustion Timing" },
    { 61791, "Engine Cylinder 7 Combustion Timing" },
    { 61792, "Engine Cylinder 8 Combustion Timing" },
    { 61793, "Engine Cylinder 9 Combustion Timing" },
    { 61794, "Engine Cylinder 10 Combustion Timing" },
    { 61795, "Engine Cylinder 11 Combustion Timing" },
    { 61796, "Engine Cylinder 12 Combustion Timing" },
    { 61797, "Engine Cylinder 13 Combustion Timing" },
    { 61798, "Engine Cylinder 14 Combustion Timing" },
    { 61799, "Engine Cylinder 15 Combustion Timing" },
    { 61800, "Engine Cylinder 16 Combustion Timing" },
    { 61801, "Engine Cylinder 17 Combustion Timing" },
    { 61802, "Engine Cylinder 18 Combustion Timing" },
    { 61803, "Engine Cylinder 19 Combustion Timing" },
    { 61804, "Engine Cylinder 20 Combustion Timing" },
    { 61805, "Engine Cylinder 1 Combustion Metrics" },
    { 61806, "Engine Cylinder 2 Combustion Metrics" },
    { 61807, "Engine Cylinder 3 Combustion Metrics" },
    { 61808, "Engine Cylinder 4 Combustion Metrics" },
    { 61809, "Engine Cylinder 5 Combustion Metrics" },
    { 61810, "Engine Cylinder 6 Combustion Metrics" },
    { 61811, "Engine Cylinder 7 Combustion Metrics" },
    { 61812, "Engine Cylinder 8 Combustion Metrics" },
    { 61813, "Engine Cylinder 9 Combustion Metrics" },
    { 61814, "Engine Cylinder 10 Combustion Metrics" },
    { 61815, "Engine Cylinder 11 Combustion Metrics" },
    { 61816, "Engine Cylinder 12 Combustion Metrics" },
    { 61817, "Engine Cylinder 13 Combustion Metrics" },
    { 61818, "Engine Cylinder 14 Combustion Metrics" },
    { 61819, "Engine Cylinder 15 Combustion Metrics" },
    { 61820, "Engine Cylinder 16 Combustion Metrics" },
    { 61821, "Engine Cylinder 17 Combustion Metrics" },
    { 61822, "Engine Cylinder 18 Combustion Metrics" },
    { 61823, "Engine Cylinder 19 Combustion Metrics" },
    { 61824, "Engine Cylinder 20 Combustion Metrics" },
    { 61825, "Motor/Generator 1 Inverter Mode Feedback 1" },
    { 61826, "Motor/Generator 1 Inverter Limits Active Power" },
    { 61827, "Motor/Generator 1 Inverter Limits Active Mechanical" },
    { 61828, "Motor/Generator 1 Inverter Limits Active DC Side" },
    { 61829, "Motor/Generator 1 Inverter Low Voltage" },
    { 61830, "Motor/Generator 2 Inverter Mode Feedback 1" },
    { 61831, "Motor/Generator 2 Inverter Limits Active Power" },
    { 61832, "Motor/Generator 2 Inverter Limits Active Mechanical" },
    { 61833, "Motor/Generator 2 Inverter Limits Active DC Side" },
    { 61834, "Motor/Generator 2 Inverter Low Voltage" },
    { 61835, "Motor/Generator 1 Inverter Status 2" },
    { 61836, "Motor/Generator 1 Inverter Rate Limits Active 1" },
    { 61837, "Motor/Generator 2 Inverter Status 2" },
    { 61838, "Motor/Generator 2 Inverter Rate Limits Active 1" },
    { 61839, "Impostor PG Alert" },
    { 61840, "High Voltage Energy Storage Pack 1 Status 2" },
    { 61841, "High Voltage Energy Storage Pack 1 Data 1" },
    { 61842, "High Voltage Energy Storage Pack 1 Data 2" },
    { 61843, "High Voltage Energy Storage Pack 1 Data 3" },
    { 61844, "High Voltage Energy Storage Pack 1 Data 4" },
    { 61845, "High Voltage Energy Storage Pack 1 Data 5" },
    { 61846, "High Voltage Energy Storage Pack 1 Data 6" },
    { 61847, "High Voltage Energy Storage Pack 1 Status 1" },
    { 61848, "High Voltage Energy Storage Pack 1 Data 7" },
    { 61849, "High Voltage Energy Storage Pack 1 Module Status 1" },
    { 61850, "High Voltage Energy Storage Pack 1 Thermal Management System Status 1" },
    { 61851, "High Voltage Energy Storage Pack 1 Data 8" },
    { 61852, "High Voltage Energy Storage Pack 1 Data 9" },
    { 61853, "High Voltage Energy Storage Pack 1 Data 10" },
    { 61854, "High Voltage Energy Storage Pack 1 Data 11" },
    { 61855, "High Voltage Energy Storage Pack 2 Status 2" },
    { 61856, "High Voltage Energy Storage Pack 2 Data 1" },
    { 61857, "High Voltage Energy Storage Pack 2 Data 2" },
    { 61858, "High Voltage Energy Storage Pack 2 Data 3" },
    { 61859, "High Voltage Energy Storage Pack 2 Data 4" },
    { 61860, "High Voltage Energy Storage Pack 2 Data 5" },
    { 61861, "High Voltage Energy Storage Pack 2 Data 6" },
    { 61862, "High Voltage Energy Storage Pack 2 Status 1" },
    { 61863, "High Voltage Energy Storage Pack 2 Data 7" },
    { 61864, "High Voltage Energy Storage Pack 2 Module Status 1" },
    { 61865, "High Voltage Energy Storage Pack 2 Thermal Management System Status 1" },
    { 61866, "High Voltage Energy Storage Pack 2 Data 8" },
    { 61867, "High Voltage Energy Storage Pack 2 Data 9" },
    { 61868, "High Voltage Energy Storage Pack 2 Data 10" },
    { 61869, "High Voltage Energy Storage Pack 2 Data 11" },
    { 61870, "High Voltage Energy Storage Pack 3 Status 2" },
    { 61871, "High Voltage Energy Storage Pack 3 Data 1" },
    { 61872, "High Voltage Energy Storage Pack 3 Data 2" },
    { 61873, "High Voltage Energy Storage Pack 3 Data 3" },
    { 61874, "High Voltage Energy Storage Pack 3 Data 4" },
    { 61875, "High Voltage Energy Storage Pack 3 Data 5" },
    { 61876, "High Voltage Energy Storage Pack 3 Data 6" },
    { 61877, "High Voltage Energy Storage Pack 3 Status 1" },
    { 61878, "High Voltage Energy Storage Pack 3 Data 7" },
    { 61879, "High Voltage Energy Storage Pack 3 Module Status 1" },
    { 61880, "High Voltage Energy Storage Pack 3 Thermal Management System Status 1" },
    { 61881, "High Voltage Energy Storage Pack 3 Data 8" },
    { 61882, "High Voltage Energy Storage Pack 3 Data 9" },
    { 61883, "High Voltage Energy Storage Pack 3 Data 10" },
    { 61884, "High Voltage Energy Storage Pack 3 Data 11" },
    { 61885, "High Voltage Energy Storage Pack 4 Status 2" },
    { 61886, "High Voltage Energy Storage Pack 4 Data 1" },
    { 61887, "High Voltage Energy Storage Pack 4 Data 2" },
    { 61888, "High Voltage Energy Storage Pack 4 Data 3" },
    { 61889, "High Voltage Energy Storage Pack 4 Data 4" },
    { 61890, "High Voltage Energy Storage Pack 4 Data 5" },
    { 61891, "High Voltage Energy Storage Pack 4 Data 6" },
    { 61892, "High Voltage Energy Storage Pack 4 Status 1" },
    { 61893, "High Voltage Energy Storage Pack 4 Data 7" },
    { 61894, "High Voltage Energy Storage Pack 4 Module Status 1" },
    { 61895, "High Voltage Energy Storage Pack 4 Thermal Management System Status 1" },
    { 61896, "High Voltage Energy Storage Pack 4 Data 8" },
    { 61897, "High Voltage Energy Storage Pack 4 Data 9" },
    { 61898, "High Voltage Energy Storage Pack 4 Data 10" },
    { 61899, "High Voltage Energy Storage Pack 4 Data 11" },
    { 61900, "High Voltage Energy Storage Pack 5 Status 2" },
    { 61901, "High Voltage Energy Storage Pack 5 Data 1" },
    { 61902, "High Voltage Energy Storage Pack 5 Data 2" },
    { 61903, "High Voltage Energy Storage Pack 5 Data 3" },
    { 61904, "High Voltage Energy Storage Pack 5 Data 4" },
    { 61905, "High Voltage Energy Storage Pack 5 Data 5" },
    { 61906, "High Voltage Energy Storage Pack 5 Data 6" },
    { 61907, "High Voltage Energy Storage Pack 5 Status 1" },
    { 61908, "High Voltage Energy Storage Pack 5 Data 7" },
    { 61909, "High Voltage Energy Storage Pack 5 Module Status 1" },
    { 61910, "High Voltage Energy Storage Pack 5 Thermal Management System Status 1" },
    { 61911, "High Voltage Energy Storage Pack 5 Data 8" },
    { 61912, "High Voltage Energy Storage Pack 5 Data 9" },
    { 61913, "High Voltage Energy Storage Pack 5 Data 10" },
    { 61914, "High Voltage Energy Storage Pack 5 Data 11" },
    { 61915, "High Voltage Energy Storage Pack 6 Status 2" },
    { 61916, "High Voltage Energy Storage Pack 6 Data 1" },
    { 61917, "High Voltage Energy Storage Pack 6 Data 2" },
    { 61918, "High Voltage Energy Storage Pack 6 Data 3" },
    { 61919, "High Voltage Energy Storage Pack 6 Data 4" },
    { 61920, "High Voltage Energy Storage Pack 6 Data 5" },
    { 61921, "High Voltage Energy Storage Pack 6 Data 6" },
    { 61922, "High Voltage Energy Storage Pack 6 Status 1" },
    { 61923, "High Voltage Energy Storage Pack 6 Data 7" },
    { 61924, "High Voltage Energy Storage Pack 6 Module Status 1" },
    { 61925, "High Voltage Energy Storage Pack 6 Thermal Management System Status 1" },
    { 61926, "High Voltage Energy Storage Pack 6 Data 8" },
    { 61927, "High Voltage Energy Storage Pack 6 Data 9" },
    { 61928, "High Voltage Energy Storage Pack 6 Data 10" },
    { 61929, "High Voltage Energy Storage Pack 6 Data 11" },
    { 61930, "Motor/Generator 3 Inverter Mode Feedback 1" },
    { 61931, "Motor/Generator 3 Inverter Limits Active Power" },
    { 61932, "Motor/Generator 3 Inverter Limits Active Mechanical" },
    { 61933, "Motor/Generator 3 Inverter Limits Active DC Side" },
    { 61934, "Motor/Generator 3 Inverter Low Voltage" },
    { 61935, "Motor/Generator 3 Inverter Status 2" },
    { 61936, "Motor/Generator 3 Inverter Rate Limits Active 1" },
    { 61937, "Motor/Generator 4 Inverter Mode Feedback 1" },
    { 61938, "Motor/Generator 4 Inverter Limits Active Power" },
    { 61939, "Motor/Generator 4 Inverter Limits Active Mechanical" },
    { 61940, "Motor/Generator 4 Inverter Limits Active DC Side" },
    { 61941, "Motor/Generator 4 Inverter Low Voltage" },
    { 61942, "Motor/Generator 4 Inverter Status 2" },
    { 61943, "Motor/Generator 4 Inverter Rate Limits Active 1" },
    { 61944, "Motor/Generator 5 Inverter Mode Feedback 1" },
    { 61945, "Motor/Generator 5 Inverter Limits Active Power" },
    { 61946, "Motor/Generator 5 Inverter Limits Active Mechanical" },
    { 61947, "Motor/Generator 5 Inverter Limits Active DC Side" },
    { 61948, "Motor/Generator 5 Inverter Low Voltage" },
    { 61949, "Motor/Generator 5 Inverter Status 2" },
    { 61950, "Motor/Generator 5 Inverter Rate Limits Active 1" },
    { 61951, "Motor/Generator 6 Inverter Mode Feedback 1" },
    { 61952, "Motor/Generator 6 Inverter Limits Active Power" },
    { 61953, "Motor/Generator 6 Inverter Limits Active Mechanical" },
    { 61954, "Motor/Generator 6 Inverter Limits Active DC Side" },
    { 61955, "Motor/Generator 6 Inverter Low Voltage" },
    { 61956, "Motor/Generator 6 Inverter Status 2" },
    { 61957, "Motor/Generator 6 Inverter Rate Limits Active 1" },
    { 61958, "Blind Spot Detection 1" },
    { 61959, "Winch Information 1" },
    { 61960, "Motor/Generator 3 Inverter Control" },
    { 61961, "Motor/Generator 3 Inverter Rate Limits Request 1" },
    { 61962, "Motor/Generator 4 Inverter Control" },
    { 61963, "Motor/Generator 4 Inverter Rate Limits Request 1" },
    { 61964, "Motor/Generator 5 Inverter Control" },
    { 61965, "Motor/Generator 5 Inverter Rate Limits Request 1" },
    { 61966, "Motor/Generator 6 Inverter Control" },
    { 61967, "Motor/Generator 6 Inverter Rate Limits Request 1" },
    { 61968, "Collision Avoidance System 1" },
    { 61969, "Collision Avoidance System 2" },
    { 61972, "High Voltage Energy Storage Pack 7 Status 2" },
    { 61973, "High Voltage Energy Storage Pack 7 Data 1" },
    { 61974, "High Voltage Energy Storage Pack 7 Data 2" },
    { 61975, "High Voltage Energy Storage Pack 7 Data 3" },
    { 61976, "High Voltage Energy Storage Pack 7 Data 4" },
    { 61977, "High Voltage Energy Storage Pack 7 Data 5" },
    { 61978, "High Voltage Energy Storage Pack 7 Data 6" },
    { 61979, "High Voltage Energy Storage Pack 7 Status 1" },
    { 61980, "High Voltage Energy Storage Pack 7 Data 7" },
    { 61981, "High Voltage Energy Storage Pack 7 Module Status 1" },
    { 61982, "High Voltage Energy Storage Pack 7 Thermal Management System Status 1" },
    { 61983, "High Voltage Energy Storage Pack 7 Data 8" },
    { 61984, "High Voltage Energy Storage Pack 7 Data 9" },
    { 61985, "High Voltage Energy Storage Pack 7 Data 10" },
    { 61986, "High Voltage Energy Storage Pack 7 Data 11" },
    { 61987, "High Voltage Energy Storage Pack 8 Status 2" },
    { 61988, "High Voltage Energy Storage Pack 8 Data 1" },
    { 61989, "High Voltage Energy Storage Pack 8 Data 2" },
    { 61990, "High Voltage Energy Storage Pack 8 Data 3" },
    { 61991, "High Voltage Energy Storage Pack 8 Data 4" },
    { 61992, "High Voltage Energy Storage Pack 8 Data 5" },
    { 61993, "High Voltage Energy Storage Pack 8 Data 6" },
    { 61994, "High Voltage Energy Storage Pack 8 Status 1" },
    { 61995, "High Voltage Energy Storage Pack 8 Data 7" },
    { 61996, "High Voltage Energy Storage Pack 8 Module Status 1" },
    { 61997, "High Voltage Energy Storage Pack 8 Thermal Management System Status 1" },
    { 61998, "High Voltage Energy Storage Pack 8 Data 8" },
    { 61999, "High Voltage Energy Storage Pack 8 Data 9" },
    { 62000, "High Voltage Energy Storage Pack 8 Data 10" },
    { 62001, "High Voltage Energy Storage Pack 8 Data 11" },
    { 62002, "High Voltage Energy Storage Pack 9 Status 2" },
    { 62003, "High Voltage Energy Storage Pack 9 Data 1" },
    { 62004, "High Voltage Energy Storage Pack 9 Data 2" },
    { 62005, "High Voltage Energy Storage Pack 9 Data 3" },
    { 62006, "High Voltage Energy Storage Pack 9 Data 4" },
    { 62007, "High Voltage Energy Storage Pack 9 Data 5" },
    { 62008, "High Voltage Energy Storage Pack 9 Data 6" },
    { 62009, "High Voltage Energy Storage Pack 9 Status 1" },
    { 62010, "High Voltage Energy Storage Pack 9 Data 7" },
    { 62011, "High Voltage Energy Storage Pack 9 Module Status 1" },
    { 62012, "High Voltage Energy Storage Pack 9 Thermal Management System Status 1" },
    { 62013, "High Voltage Energy Storage Pack 9 Data 8" },
    { 62014, "High Voltage Energy Storage Pack 9 Data 9" },
    { 62015, "High Voltage Energy Storage Pack 9 Data 10" },
    { 62016, "High Voltage Energy Storage Pack 9 Data 11" },
    { 62017, "High Voltage Energy Storage Pack 10 Status 2" },
    { 62018, "High Voltage Energy Storage Pack 10 Data 1" },
    { 62019, "High Voltage Energy Storage Pack 10 Data 2" },
    { 62020, "High Voltage Energy Storage Pack 10 Data 3" },
    { 62021, "High Voltage Energy Storage Pack 10 Data 4" },
    { 62022, "High Voltage Energy Storage Pack 10 Data 5" },
    { 62023, "High Voltage Energy Storage Pack 10 Data 6" },
    { 62024, "High Voltage Energy Storage Pack 10 Status 1" },
    { 62025, "High Voltage Energy Storage Pack 10 Data 7" },
    { 62026, "High Voltage Energy Storage Pack 10 Module Status 1" },
    { 62027, "High Voltage Energy Storage Pack 10 Thermal Management System Status 1" },
    { 62028, "High Voltage Energy Storage Pack 10 Data 8" },
    { 62029, "High Voltage Energy Storage Pack 10 Data 9" },
    { 62030, "High Voltage Energy Storage Pack 10 Data 10" },
    { 62031, "High Voltage Energy Storage Pack 10 Data 11" },
    { 62032, "Electronic Auxiliary Transmission Controller 1" },
    { 62033, "High Voltage Energy Storage Pack 11 Status 2" },
    { 62034, "High Voltage Energy Storage Pack 11 Data 1" },
    { 62035, "High Voltage Energy Storage Pack 11 Data 2" },
    { 62036, "High Voltage Energy Storage Pack 11 Data 3" },
    { 62037, "High Voltage Energy Storage Pack 11 Data 4" },
    { 62038, "High Voltage Energy Storage Pack 11 Data 5" },
    { 62039, "High Voltage Energy Storage Pack 11 Data 6" },
    { 62040, "High Voltage Energy Storage Pack 11 Status 1" },
    { 62041, "High Voltage Energy Storage Pack 11 Data 7" },
    { 62042, "High Voltage Energy Storage Pack 11 Module Status 1" },
    { 62043, "High Voltage Energy Storage Pack 11 Thermal Management System Status 1" },
    { 62044, "High Voltage Energy Storage Pack 11 Data 8" },
    { 62045, "High Voltage Energy Storage Pack 11 Data 9" },
    { 62046, "High Voltage Energy Storage Pack 11 Data 10" },
    { 62047, "High Voltage Energy Storage Pack 11 Data 11" },
    { 62048, "High Voltage Energy Storage Pack 12 Status 2" },
    { 62049, "High Voltage Energy Storage Pack 12 Data 1" },
    { 62050, "High Voltage Energy Storage Pack 12 Data 2" },
    { 62051, "High Voltage Energy Storage Pack 12 Data 3" },
    { 62052, "High Voltage Energy Storage Pack 12 Data 4" },
    { 62053, "High Voltage Energy Storage Pack 12 Data 5" },
    { 62054, "High Voltage Energy Storage Pack 12 Data 6" },
    { 62055, "High Voltage Energy Storage Pack 12 Status 1" },
    { 62056, "High Voltage Energy Storage Pack 12 Data 7" },
    { 62057, "High Voltage Energy Storage Pack 12 Module Status 1" },
    { 62058, "High Voltage Energy Storage Pack 12 Thermal Management System Status 1" },
    { 62059, "High Voltage Energy Storage Pack 12 Data 8" },
    { 62060, "High Voltage Energy Storage Pack 12 Data 9" },
    { 62061, "High Voltage Energy Storage Pack 12 Data 10" },
    { 62062, "High Voltage Energy Storage Pack 12 Data 11" },
    { 62063, "High Voltage Energy Storage Pack 13 Status 2" },
    { 62064, "High Voltage Energy Storage Pack 13 Data 1" },
    { 62065, "High Voltage Energy Storage Pack 13 Data 2" },
    { 62066, "High Voltage Energy Storage Pack 13 Data 3" },
    { 62067, "High Voltage Energy Storage Pack 13 Data 4" },
    { 62068, "High Voltage Energy Storage Pack 13 Data 5" },
    { 62069, "High Voltage Energy Storage Pack 13 Data 6" },
    { 62070, "High Voltage Energy Storage Pack 13 Status 1" },
    { 62071, "High Voltage Energy Storage Pack 13 Data 7" },
    { 62072, "High Voltage Energy Storage Pack 13 Module Status 1" },
    { 62073, "High Voltage Energy Storage Pack 13 Thermal Management System Status 1" },
    { 62074, "High Voltage Energy Storage Pack 13 Data 8" },
    { 62075, "High Voltage Energy Storage Pack 13 Data 9" },
    { 62076, "High Voltage Energy Storage Pack 13 Data 10" },
    { 62077, "High Voltage Energy Storage Pack 13 Data 11" },
    { 62078, "High Voltage Energy Storage Pack 14 Status 2" },
    { 62079, "High Voltage Energy Storage Pack 14 Data 1" },
    { 62080, "High Voltage Energy Storage Pack 14 Data 2" },
    { 62081, "High Voltage Energy Storage Pack 14 Data 3" },
    { 62082, "High Voltage Energy Storage Pack 14 Data 4" },
    { 62083, "High Voltage Energy Storage Pack 14 Data 5" },
    { 62084, "High Voltage Energy Storage Pack 14 Data 6" },
    { 62085, "High Voltage Energy Storage Pack 14 Status 1" },
    { 62086, "High Voltage Energy Storage Pack 14 Data 7" },
    { 62087, "High Voltage Energy Storage Pack 14 Module Status 1" },
    { 62088, "High Voltage Energy Storage Pack 14 Thermal Management System Status 1" },
    { 62089, "High Voltage Energy Storage Pack 14 Data 8" },
    { 62090, "High Voltage Energy Storage Pack 14 Data 9" },
    { 62091, "High Voltage Energy Storage Pack 14 Data 10" },
    { 62092, "High Voltage Energy Storage Pack 14 Data 11" },
    { 62093, "High Voltage Energy Storage Pack 15 Status 2" },
    { 62094, "High Voltage Energy Storage Pack 15 Data 1" },
    { 62095, "High Voltage Energy Storage Pack 15 Data 2" },
    { 62096, "High Voltage Energy Storage Pack 15 Data 3" },
    { 62097, "High Voltage Energy Storage Pack 15 Data 4" },
    { 62098, "High Voltage Energy Storage Pack 15 Data 5" },
    { 62099, "High Voltage Energy Storage Pack 15 Data 6" },
    { 62100, "High Voltage Energy Storage Pack 15 Status 1" },
    { 62101, "High Voltage Energy Storage Pack 15 Data 7" },
    { 62102, "High Voltage Energy Storage Pack 15 Module Status 1" },
    { 62103, "High Voltage Energy Storage Pack 15 Thermal Management System Status 1" },
    { 62104, "High Voltage Energy Storage Pack 15 Data 8" },
    { 62105, "High Voltage Energy Storage Pack 15 Data 9" },
    { 62106, "High Voltage Energy Storage Pack 15 Data 10" },
    { 62107, "High Voltage Energy Storage Pack 15 Data 11" },
    { 62108, "High Voltage Energy Storage Pack 16 Status 2" },
    { 62109, "High Voltage Energy Storage Pack 16 Data 1" },
    { 62110, "High Voltage Energy Storage Pack 16 Data 2" },
    { 62111, "High Voltage Energy Storage Pack 16 Data 3" },
    { 62112, "High Voltage Energy Storage Pack 16 Data 4" },
    { 62113, "High Voltage Energy Storage Pack 16 Data 5" },
    { 62114, "High Voltage Energy Storage Pack 16 Data 6" },
    { 62115, "High Voltage Energy Storage Pack 16 Status 1" },
    { 62116, "High Voltage Energy Storage Pack 16 Data 7" },
    { 62117, "High Voltage Energy Storage Pack 16 Module Status 1" },
    { 62118, "High Voltage Energy Storage Pack 16 Thermal Management System Status 1" },
    { 62119, "High Voltage Energy Storage Pack 16 Data 8" },
    { 62120, "High Voltage Energy Storage Pack 16 Data 9" },
    { 62121, "High Voltage Energy Storage Pack 16 Data 10" },
    { 62122, "High Voltage Energy Storage Pack 16 Data 11" },
    { 62123, "High Voltage Energy Storage Pack 17 Status 2" },
    { 62124, "High Voltage Energy Storage Pack 17 Data 1" },
    { 62125, "High Voltage Energy Storage Pack 17 Data 2" },
    { 62126, "High Voltage Energy Storage Pack 17 Data 3" },
    { 62127, "High Voltage Energy Storage Pack 17 Data 4" },
    { 62128, "High Voltage Energy Storage Pack 17 Data 5" },
    { 62129, "High Voltage Energy Storage Pack 17 Data 6" },
    { 62130, "High Voltage Energy Storage Pack 17 Status 1" },
    { 62131, "High Voltage Energy Storage Pack 17 Data 7" },
    { 62132, "High Voltage Energy Storage Pack 17 Module Status 1" },
    { 62133, "High Voltage Energy Storage Pack 17 Thermal Management System Status 1" },
    { 62134, "High Voltage Energy Storage Pack 17 Data 8" },
    { 62135, "High Voltage Energy Storage Pack 17 Data 9" },
    { 62136, "High Voltage Energy Storage Pack 17 Data 10" },
    { 62137, "High Voltage Energy Storage Pack 17 Data 11" },
    { 62138, "High Voltage Energy Storage Pack 18 Status 2" },
    { 62139, "High Voltage Energy Storage Pack 18 Data 1" },
    { 62140, "High Voltage Energy Storage Pack 18 Data 2" },
    { 62141, "High Voltage Energy Storage Pack 18 Data 3" },
    { 62142, "High Voltage Energy Storage Pack 18 Data 4" },
    { 62143, "High Voltage Energy Storage Pack 18 Data 5" },
    { 62144, "High Voltage Energy Storage Pack 18 Data 6" },
    { 62145, "High Voltage Energy Storage Pack 18 Status 1" },
    { 62146, "High Voltage Energy Storage Pack 18 Data 7" },
    { 62147, "High Voltage Energy Storage Pack 18 Module Status 1" },
    { 62148, "High Voltage Energy Storage Pack 18 Thermal Management System Status 1" },
    { 62149, "High Voltage Energy Storage Pack 18 Data 8" },
    { 62150, "High Voltage Energy Storage Pack 18 Data 9" },
    { 62151, "High Voltage Energy Storage Pack 18 Data 10" },
    { 62152, "High Voltage Energy Storage Pack 18 Data 11" },
    { 62153, "High Voltage Energy Storage Pack 19 Status 2" },
    { 62154, "High Voltage Energy Storage Pack 19 Data 1" },
    { 62155, "High Voltage Energy Storage Pack 19 Data 2" },
    { 62156, "High Voltage Energy Storage Pack 19 Data 3" },
    { 62157, "High Voltage Energy Storage Pack 19 Data 4" },
    { 62158, "High Voltage Energy Storage Pack 19 Data 5" },
    { 62159, "High Voltage Energy Storage Pack 19 Data 6" },
    { 62160, "High Voltage Energy Storage Pack 19 Status 1" },
    { 62161, "High Voltage Energy Storage Pack 19 Data 7" },
    { 62162, "High Voltage Energy Storage Pack 19 Module Status 1" },
    { 62163, "High Voltage Energy Storage Pack 19 Thermal Management System Status 1" },
    { 62164, "High Voltage Energy Storage Pack 19 Data 8" },
    { 62165, "High Voltage Energy Storage Pack 19 Data 9" },
    { 62166, "High Voltage Energy Storage Pack 19 Data 10" },
    { 62167, "High Voltage Energy Storage Pack 19 Data 11" },
    { 62168, "High Voltage Energy Storage Pack 20 Status 2" },
    { 62169, "High Voltage Energy Storage Pack 20 Data 1" },
    { 62170, "High Voltage Energy Storage Pack 20 Data 2" },
    { 62171, "High Voltage Energy Storage Pack 20 Data 3" },
    { 62172, "High Voltage Energy Storage Pack 20 Data 4" },
    { 62173, "High Voltage Energy Storage Pack 20 Data 5" },
    { 62174, "High Voltage Energy Storage Pack 20 Data 6" },
    { 62175, "High Voltage Energy Storage Pack 20 Status 1" },
    { 62176, "High Voltage Energy Storage Pack 20 Data 7" },
    { 62177, "High Voltage Energy Storage Pack 20 Module Status 1" },
    { 62178, "High Voltage Energy Storage Pack 20 Thermal Management System Status 1" },
    { 62179, "High Voltage Energy Storage Pack 20 Data 8" },
    { 62180, "High Voltage Energy Storage Pack 20 Data 9" },
    { 62181, "High Voltage Energy Storage Pack 20 Data 10" },
    { 62182, "High Voltage Energy Storage Pack 20 Data 11" },
    { 62183, "High Voltage Energy Storage Pack 21 Status 2" },
    { 62184, "High Voltage Energy Storage Pack 21 Data 1" },
    { 62185, "High Voltage Energy Storage Pack 21 Data 2" },
    { 62186, "High Voltage Energy Storage Pack 21 Data 3" },
    { 62187, "High Voltage Energy Storage Pack 21 Data 4" },
    { 62188, "High Voltage Energy Storage Pack 21 Data 5" },
    { 62189, "High Voltage Energy Storage Pack 21 Data 6" },
    { 62190, "High Voltage Energy Storage Pack 21 Status 1" },
    { 62191, "High Voltage Energy Storage Pack 21 Data 7" },
    { 62192, "High Voltage Energy Storage Pack 21 Module Status 1" },
    { 62193, "High Voltage Energy Storage Pack 21 Thermal Management System Status 1" },
    { 62194, "High Voltage Energy Storage Pack 21 Data 8" },
    { 62195, "High Voltage Energy Storage Pack 21 Data 9" },
    { 62196, "High Voltage Energy Storage Pack 21 Data 10" },
    { 62197, "High Voltage Energy Storage Pack 21 Data 11" },
    { 62198, "High Voltage Energy Storage Pack 22 Status 2" },
    { 62199, "High Voltage Energy Storage Pack 22 Data 1" },
    { 62200, "High Voltage Energy Storage Pack 22 Data 2" },
    { 62201, "High Voltage Energy Storage Pack 22 Data 3" },
    { 62202, "High Voltage Energy Storage Pack 22 Data 4" },
    { 62203, "High Voltage Energy Storage Pack 22 Data 5" },
    { 62204, "High Voltage Energy Storage Pack 22 Data 6" },
    { 62205, "High Voltage Energy Storage Pack 22 Status 1" },
    { 62206, "High Voltage Energy Storage Pack 22 Data 7" },
    { 62207, "High Voltage Energy Storage Pack 22 Module Status 1" },
    { 62208, "High Voltage Energy Storage Pack 22 Thermal Management System Status 1" },
    { 62209, "High Voltage Energy Storage Pack 22 Data 8" },
    { 62210, "High Voltage Energy Storage Pack 22 Data 9" },
    { 62211, "High Voltage Energy Storage Pack 22 Data 10" },
    { 62212, "High Voltage Energy Storage Pack 22 Data 11" },
    { 62213, "High Voltage Energy Storage Pack 23 Status 2" },
    { 62214, "High Voltage Energy Storage Pack 23 Data 1" },
    { 62215, "High Voltage Energy Storage Pack 23 Data 2" },
    { 62216, "High Voltage Energy Storage Pack 23 Data 3" },
    { 62217, "High Voltage Energy Storage Pack 23 Data 4" },
    { 62218, "High Voltage Energy Storage Pack 23 Data 5" },
    { 62219, "High Voltage Energy Storage Pack 23 Data 6" },
    { 62220, "High Voltage Energy Storage Pack 23 Status 1" },
    { 62221, "High Voltage Energy Storage Pack 23 Data 7" },
    { 62222, "High Voltage Energy Storage Pack 23 Module Status 1" },
    { 62223, "High Voltage Energy Storage Pack 23 Thermal Management System Status 1" },
    { 62224, "High Voltage Energy Storage Pack 23 Data 8" },
    { 62225, "High Voltage Energy Storage Pack 23 Data 9" },
    { 62226, "High Voltage Energy Storage Pack 23 Data 10" },
    { 62227, "High Voltage Energy Storage Pack 23 Data 11" },
    { 62228, "High Voltage Energy Storage Pack 24 Status 2" },
    { 62229, "High Voltage Energy Storage Pack 24 Data 1" },
    { 62230, "High Voltage Energy Storage Pack 24 Data 2" },
    { 62231, "High Voltage Energy Storage Pack 24 Data 3" },
    { 62232, "High Voltage Energy Storage Pack 24 Data 4" },
    { 62233, "High Voltage Energy Storage Pack 24 Data 5" },
    { 62234, "High Voltage Energy Storage Pack 24 Data 6" },
    { 62235, "High Voltage Energy Storage Pack 24 Status 1" },
    { 62236, "High Voltage Energy Storage Pack 24 Data 7" },
    { 62237, "High Voltage Energy Storage Pack 24 Module Status 1" },
    { 62238, "High Voltage Energy Storage Pack 24 Thermal Management System Status 1" },
    { 62239, "High Voltage Energy Storage Pack 24 Data 8" },
    { 62240, "High Voltage Energy Storage Pack 24 Data 9" },
    { 62241, "High Voltage Energy Storage Pack 24 Data 10" },
    { 62242, "High Voltage Energy Storage Pack 24 Data 11" },
    { 62243, "High Voltage Energy Storage Pack 25 Status 2" },
    { 62244, "High Voltage Energy Storage Pack 25 Data 1" },
    { 62245, "High Voltage Energy Storage Pack 25 Data 2" },
    { 62246, "High Voltage Energy Storage Pack 25 Data 3" },
    { 62247, "High Voltage Energy Storage Pack 25 Data 4" },
    { 62248, "High Voltage Energy Storage Pack 25 Data 5" },
    { 62249, "High Voltage Energy Storage Pack 25 Data 6" },
    { 62250, "High Voltage Energy Storage Pack 25 Status 1" },
    { 62251, "High Voltage Energy Storage Pack 25 Data 7" },
    { 62252, "High Voltage Energy Storage Pack 25 Module Status 1" },
    { 62253, "High Voltage Energy Storage Pack 25 Thermal Management System Status 1" },
    { 62254, "High Voltage Energy Storage Pack 25 Data 8" },
    { 62255, "High Voltage Energy Storage Pack 25 Data 9" },
    { 62256, "High Voltage Energy Storage Pack 25 Data 10" },
    { 62257, "High Voltage Energy Storage Pack 25 Data 11" },
    { 62258, "High Voltage Energy Storage Pack 26 Status 2" },
    { 62259, "High Voltage Energy Storage Pack 26 Data 1" },
    { 62260, "High Voltage Energy Storage Pack 26 Data 2" },
    { 62261, "High Voltage Energy Storage Pack 26 Data 3" },
    { 62262, "High Voltage Energy Storage Pack 26 Data 4" },
    { 62263, "High Voltage Energy Storage Pack 26 Data 5" },
    { 62264, "High Voltage Energy Storage Pack 26 Data 6" },
    { 62265, "High Voltage Energy Storage Pack 26 Status 1" },
    { 62266, "High Voltage Energy Storage Pack 26 Data 7" },
    { 62267, "High Voltage Energy Storage Pack 26 Module Status 1" },
    { 62268, "High Voltage Energy Storage Pack 26 Thermal Management System Status 1" },
    { 62269, "High Voltage Energy Storage Pack 26 Data 8" },
    { 62270, "High Voltage Energy Storage Pack 26 Data 9" },
    { 62271, "High Voltage Energy Storage Pack 26 Data 10" },
    { 62272, "High Voltage Energy Storage Pack 26 Data 11" },
    { 62273, "External Steering Request" },
    { 62274, "Active Steering System Controller 2" },
    { 62275, "Electronic Park Brake Controller 1" },
    { 62276, "Electronic Park Brake Controller 2" },
    { 62277, "Genset Frequency Limitation" },
    { 62278, "Genset Power Limitation" },
    { 62279, "Genset Real Power Control" },
    { 62280, "Genset Reactive Power" },
    { 62281, "Fuel Cell Compartment Information" },
    { 62282, "Genset Real Power Setpoint Demand" },
    { 62283, "Genset Real Power Control 2" },
    { 62284, "High Voltage Energy Storage Pack 1 Data 12" },
    { 62285, "High Voltage Energy Storage Pack 1 Data 13" },
    { 62286, "High Voltage Energy Storage Pack 2 Data 12" },
    { 62287, "High Voltage Energy Storage Pack 2 Data 13" },
    { 62288, "High Voltage Energy Storage Pack 3 Data 12" },
    { 62289, "High Voltage Energy Storage Pack 3 Data 13" },
    { 62290, "High Voltage Energy Storage Pack 4 Data 12" },
    { 62291, "High Voltage Energy Storage Pack 4 Data 13" },
    { 62292, "High Voltage Energy Storage Pack 5 Data 12" },
    { 62293, "High Voltage Energy Storage Pack 5 Data 13" },
    { 62294, "High Voltage Energy Storage Pack 6 Data 12" },
    { 62295, "High Voltage Energy Storage Pack 6 Data 13" },
    { 62296, "High Voltage Energy Storage Pack 7 Data 12" },
    { 62297, "High Voltage Energy Storage Pack 7 Data 13" },
    { 62298, "High Voltage Energy Storage Pack 8 Data 12" },
    { 62299, "High Voltage Energy Storage Pack 8 Data 13" },
    { 62300, "High Voltage Energy Storage Pack 9 Data 12" },
    { 62301, "High Voltage Energy Storage Pack 9 Data 13" },
    { 62302, "High Voltage Energy Storage Pack 10 Data 12" },
    { 62303, "High Voltage Energy Storage Pack 10 Data 13" },
    { 62304, "High Voltage Energy Storage Pack 11 Data 12" },
    { 62305, "High Voltage Energy Storage Pack 11 Data 13" },
    { 62306, "High Voltage Energy Storage Pack 12 Data 12" },
    { 62307, "High Voltage Energy Storage Pack 12 Data 13" },
    { 62308, "Tracked Vehicle Data" },
    { 62309, "Electrified Accessory Propulsion Motor Coolant Fan 3 Status 2" },
    { 62310, "Electrified Accessory Propulsion Motor Coolant Fan 2 Status 2" },
    { 62311, "Electrified Accessory Propulsion Motor Coolant Fan 1 Status 2" },
    { 62312, "Electrified Accessory Power Electronics Coolant Fan 3 Status 2" },
    { 62313, "Electrified Accessory Power Electronics Coolant Fan 2 Status 2" },
    { 62314, "Electrified Accessory Power Electronics Coolant Fan 1 Status 2" },
    { 62315, "Electrified Accessory Propulsion Motor Oil Pump Status 2" },
    { 62316, "Electrified Accessory Propulsion Motor Coolant Pump Status 2" },
    { 62317, "Electrified Accessory Power Electronics Coolant Pump Status 2" },
    { 62318, "Electrified Accessory Generator Coolant Pump Status 2" },
    { 62319, "Electrified Accessory Generator Coolant Fan Status 2" },
    { 62320, "Electrified Accessory Motor Status 2" },
    { 62321, "Fuel Cell System Controller Information" },
    { 62322, "Fuel Cell System Minimum Power Information" },
    { 62323, "Fuel Cell System Maximum Power Information" },
    { 62324, "Fuel Cell System Minimum Current Information" },
    { 62325, "Fuel Cell System Maximum Current Information" },
    { 62326, "Hydrogen Storage System Information" },
    { 62327, "Fuel Cell System Operating State" },
    { 62328, "Fuel Cell System Operations Request" },
    { 62329, "Fuel Cell Stack Information " },
    { 62330, "Fuel Cell System Coolant Fan 1 Status 2" },
    { 62331, "Fuel Cell System Coolant Fan 2 Status 2" },
    { 62332, "Fuel Cell System Coolant Fan 3 Status 2" },
    { 62333, "Fuel Cell System Coolant Fan 4 Status 2" },
    { 62334, "HVESS Coolant Pump 1 Status 2" },
    { 62335, "HVESS Coolant Pump 2 Status 2" },
    { 62336, "High Voltage Energy Storage System Fan Status 2" },
    { 63935, "Enrichment Information" },
    { 63936, "Fuel Cell System Voltage Limit Command" },
    { 63939, "Auxiliary Input/Output Status 17" },
    { 63940, "Auxiliary Input/Output Status 16" },
    { 63941, "Auxiliary Input/Output Status 15" },
    { 63942, "Auxiliary Input/Output Status 14" },
    { 63943, "Auxiliary Input/Output Status 13" },
    { 63944, "Auxiliary Input/Output Status 12" },
    { 63945, "Auxiliary Input/Output Status 11" },
    { 63946, "Auxiliary Input/Output Status 10" },
    { 63947, "Auxiliary Input/Output Status 9" },
    { 63948, "Auxiliary Input/Output Status 8" },
    { 63949, "Aftertreatment System Information 8" },
    { 63950, "Brake Temperature 6" },
    { 63951, "Brake Temperature 5" },
    { 63952, "Brake Temperature 4" },
    { 63953, "Brake Temperature 3" },
    { 63954, "Brake Temperature 2" },
    { 63955, "Brake Temperature 1" },
    { 63956, "Wheel Brake Lining Remaining Information 3" },
    { 63957, "Wheel Brake Lining Remaining Information 2" },
    { 63958, "High Voltage Bus Contactor Status 3" },
    { 63959, "High Voltage Bus Contactor Status 2" },
    { 63960, "High Voltage Bus Connection Command 2" },
    { 63961, "Cab Illumination Data" },
    { 63962, "Service Needed DTC Information" },
    { 63963, "EVSE Status 2" },
    { 63964, "High Voltage Energy Storage System Thermal Management System Chiller 1" },
    { 63965, "High Voltage Energy Storage System Thermal Management System Chiller 2" },
    { 63966, "High Voltage Energy Storage System Thermal Management System Chiller 3" },
    { 63967, "HVESS Coolant Pump 1 Status 1" },
    { 63968, "HVESS Coolant Pump 1 Command" },
    { 63969, "HVESS Coolant Pump 2 Status 1" },
    { 63970, "HVESS Coolant Pump 2 Command" },
    { 63971, "Hydrogen Information" },
    { 63972, "Operator Inducement Information 2" },
    { 63973, "Operator Inducement Vehicle Speed Information 1" },
    { 63974, "Operator Inducement Vehicle Speed Information 2" },
    { 63975, "Engine Protection Speed Derate Information" },
    { 63976, "Engine Protection Torque Derate Information" },
    { 63977, "Aftertreatment System Information 7" },
    { 63978, "SAE J2012 3-Byte DTC Display" },
    { 63979, "High Voltage Energy Storage System Internal Status 5" },
    { 63980, "High Voltage Energy Storage System Internal Status 6" },
    { 63981, "High Voltage Energy Storage System Internal Status 7" },
    { 63982, "Engine Cylinder Average Ignition Delay Angle 1" },
    { 63983, "Engine Cylinder Average Ignition Delay Angle 2" },
    { 63984, "Engine Cylinder Average Ignition Delay Angle 3" },
    { 63985, "Engine Cylinder Average Ignition Delay Angle 4" },
    { 63986, "Engine Cylinder Average Ignition Delay Angle 5" },
    { 63987, " Engine Indicated Mean Effective Pressure Information 1" },
    { 63988, " Engine Indicated Mean Effective Pressure Information 2" },
    { 63989, " Engine Indicated Mean Effective Pressure Information 3" },
    { 63990, "Fuel Cell System Coolant Fan 1 Command" },
    { 63991, "Fuel Cell System Coolant Fan 1 Status 1" },
    { 63992, "Fuel Cell System Coolant Fan 2 Command" },
    { 63993, "Fuel Cell System Coolant Fan 2 Status 1" },
    { 63994, "Fuel Cell System Coolant Fan 3 Command" },
    { 63995, "Fuel Cell System Coolant Fan 3 Status 1" },
    { 63996, "Fuel Cell System Coolant Fan 4 Command" },
    { 63997, "Fuel Cell System Coolant Fan 4 Status 1" },
    { 63998, "APIs Supported" },
    { 63999, "Fuel Cell System Configuration" },
    { 64000, "Fuel Cell System Coolant Information 1" },
    { 64001, "Fuel Cell System Coolant Information 2" },
    { 64006, "Dash Display 3" },
    { 64007, "Vehicle Speed Profile" },
    { 64008, "Reference Time" },
    { 64009, "Software History" },
    { 64010, "Motor/Generator 1 Thermal Performance Status  " },
    { 64011, "Motor/Generator 2 Thermal Performance Status  " },
    { 64012, "Motor/Generator 3 Thermal Performance Status  " },
    { 64013, "Motor/Generator 4 Thermal Performance Status  " },
    { 64014, "Motor/Generator 5 Thermal Performance Status  " },
    { 64015, "Motor/Generator 6 Thermal Performance Status  " },
    { 64016, "On Board Programming Event Time/Date " },
    { 64017, "Aftertreatment 1 Light Off SCR Service Information 1" },
    { 64018, "Motor/Generator Location Extended" },
    { 64019, "Cold Start Emissions Reduction Strategy Current Operating Cycle Data" },
    { 64020, "Cold Start Emissions Reduction Strategy Average Data" },
    { 64021, "Genset Supporting Functions" },
    { 64022, "High Voltage Energy Storage System Internal Status 1 " },
    { 64023, "High Voltage Energy Storage System Internal Status 2" },
    { 64024, "High Voltage Energy Storage System Internal Status 3" },
    { 64025, "High Voltage Energy Storage System Internal Status 4" },
    { 64026, "Electronic Engine Controller 23" },
    { 64027, "Electronic Engine Controller 24" },
    { 64028, "Electronic Engine Controller 25" },
    { 64029, "High Voltage Bus Connection Command 1" },
    { 64030, "High Voltage Bus Contactor Status 1" },
    { 64031, "Aftertreatment System Information 6" },
    { 64032, "EV Multi-Connection DC Charging Limits 2" },
    { 64033, "EV Multi-Connection Charging In Progress" },
    { 64034, "Sensor Supply Voltage" },
    { 64035, "Motor/Generator Location (obsolete, use PGN 64018)" },
    { 64036, "High Voltage Energy Storage System Data 12" },
    { 64037, "High Voltage Energy Storage System Data 13" },
    { 64038, "High Voltage Energy Storage System Data 14" },
    { 64039, "High Voltage Energy Storage Pack 1 Internal Status 1" },
    { 64040, "High Voltage Energy Storage Pack 2 Internal Status 1" },
    { 64041, "High Voltage Energy Storage Pack 3 Internal Status 1" },
    { 64042, "High Voltage Energy Storage Pack 4 Internal Status 1" },
    { 64043, "High Voltage Energy Storage Pack 5 Internal Status 1" },
    { 64044, "High Voltage Energy Storage Pack 6 Internal Status 1" },
    { 64045, "High Voltage Energy Storage Pack 7 Internal Status 1" },
    { 64046, "High Voltage Energy Storage Pack 8 Internal Status 1" },
    { 64047, "High Voltage Energy Storage Pack 9 Internal Status 1" },
    { 64048, "High Voltage Energy Storage Pack 10 Internal Status 1" },
    { 64049, "High Voltage Energy Storage Pack 11 Internal Status 1" },
    { 64050, "High Voltage Energy Storage Pack 12 Internal Status 1" },
    { 64051, "Multi-Color Indicator Lamp Command" },
    { 64052, "Multi-Color Indicator Lamp Status" },
    { 64053, "Refuse Truck Body Information" },
    { 64054, "Engine Fluid Level/Pressure 14" },
    { 64055, "Well Stimulation Transmission Control" },
    { 64056, "Well Stimulation Pump Protection System Configuration Command 1" },
    { 64057, "Well Stimulation Pump Protection System Configuration Command 2" },
    { 64058, "Electric PTO Drive Engagement 1" },
    { 64059, "Electric PTO 1 Information" },
    { 64060, "Engine Exhaust O2 Sensor  Information" },
    { 64061, "Gaseous Fuel Supply Pressure 3" },
    { 64062, "Traffic Signage" },
    { 64063, "Engine Configuration 4" },
    { 64064, "Electronic Transmission Controller 15" },
    { 64065, "Automated Driving System Network Configuration 2" },
    { 64066, "Automated Driving System Network Configuration 1" },
    { 64067, "Hybrid System Inputs 2" },
    { 64068, "Engine Speed/Load Factor Information 2" },
    { 64069, "Generator Trip Energy 2" },
    { 64070, "Security System Machine Operation Information" },
    { 64071, "Engine Fuel Actuator Service Mode" },
    { 64072, "Steering Wheel Controls" },
    { 64073, "Park Assist" },
    { 64074, "Extended DTC information" },
    { 64075, "Aftertreatment 2 SCR Dosing System Information 5" },
    { 64076, "Aftertreatment 1 SCR Dosing System Information 5" },
    { 64077, "EV Economy Information" },
    { 64078, "Automated Driving System Status 2" },
    { 64079, "Automated Driving System Control 3" },
    { 64080, "Aftercooler Valve" },
    { 64081, "Engine Radiator 1" },
    { 64082, "Engine Radiator 2" },
    { 64083, "Genset Enclosure Ventilation" },
    { 64084, "Heat Exchanger 1" },
    { 64085, "Heat Exchanger 2" },
    { 64086, "Heat Exchanger 3" },
    { 64087, "Heat Exchanger 4" },
    { 64088, "Engine Exhaust Gas Heat Exchanger" },
    { 64089, "Genset Enclosure Ventilation Louver" },
    { 64090, "Genset External Coolant System" },
    { 64091, "EV DC Status 1" },
    { 64092, "EVSE DC Charging Limits 3" },
    { 64093, "EVSE Power Max Schedule" },
    { 64094, "EV Charge Profile" },
    { 64095, "EV DC Charging Limits 2" },
    { 64096, "EV DC Charging In Progress" },
    { 64098, "Lighting Data 2" },
    { 64099, "Lighting Command 2" },
    { 64100, "Aftertreatment System Information 5" },
    { 64101, "Aftertreatment System Information 4" },
    { 64102, "Aftertreatment System Information 3" },
    { 64103, "Fluid Resistance 1" },
    { 64104, "Power Converter 2 Isolation Integrity Request" },
    { 64105, "Power Converter 1 Isolation Integrity Request" },
    { 64106, "Power Converter 2 Limits Request Power" },
    { 64107, "Power Converter 2 Limits Request Electrical" },
    { 64108, "Power Converter 2 Limits Request DC Energy Source 1" },
    { 64109, "Power Converter 1 Limits Request DC Energy Source 1" },
    { 64110, "Power Converter 1 Limits Request Electrical" },
    { 64111, "Power Converter 1 Limits Request Power" },
    { 64112, "Inverter 1 Lifetime Data" },
    { 64113, "Inverter 2 Lifetime Data" },
    { 64114, "Power Converter 2 Active Power Limits" },
    { 64115, "Power Converter 1 Active Power Limits" },
    { 64116, "Power Converter 2 Reference 1" },
    { 64117, "Power Converter 2 Reference 2" },
    { 64118, "Power Converter 2 Temperature" },
    { 64119, "Power Converter 1 Temperature" },
    { 64120, "Power Converter 1 Reference 2" },
    { 64121, "Power Converter 1 Reference 1" },
    { 64122, "Power Converter 1 Phase Current" },
    { 64123, "Power Converter 2 Phase Current" },
    { 64124, "Power Converter 1 Phase Voltage" },
    { 64125, "Power Converter 2 Phase Voltage" },
    { 64126, "Power Converter Power Module Switch Temperatures" },
    { 64127, "Power Converter 1 Power Module Switch Power Supply Voltage" },
    { 64128, "Power Converter 2 Power Module Switch Power Supply Voltage" },
    { 64129, "Power Converter Totals 1" },
    { 64130, "Transformer Temperatures" },
    { 64131, "Electrified Accessory Engine Coolant Pump Status" },
    { 64132, "High Voltage Energy Storage Pack 11 History" },
    { 64133, "High Voltage Energy Storage Pack 11 Configuration" },
    { 64134, "High Voltage Energy Storage Pack 12 History" },
    { 64135, "High Voltage Energy Storage Pack 12 Configuration" },
    { 64136, "High Voltage Energy Storage Pack 13 History" },
    { 64137, "High Voltage Energy Storage Pack 13 Configuration" },
    { 64138, "High Voltage Energy Storage Pack 14 History" },
    { 64139, "High Voltage Energy Storage Pack 14 Configuration" },
    { 64140, "High Voltage Energy Storage Pack 15 History" },
    { 64141, "High Voltage Energy Storage Pack 15 Configuration" },
    { 64142, "High Voltage Energy Storage Pack 16 History" },
    { 64143, "High Voltage Energy Storage Pack 16 Configuration" },
    { 64144, "High Voltage Energy Storage Pack 17 History" },
    { 64145, "High Voltage Energy Storage Pack 17 Configuration" },
    { 64146, "High Voltage Energy Storage Pack 18 History" },
    { 64147, "High Voltage Energy Storage Pack 18 Configuration" },
    { 64148, "High Voltage Energy Storage Pack 19 History" },
    { 64149, "High Voltage Energy Storage Pack 19 Configuration" },
    { 64150, "High Voltage Energy Storage Pack 20 History" },
    { 64151, "High Voltage Energy Storage Pack 20 Configuration" },
    { 64152, "High Voltage Energy Storage Pack 21 History" },
    { 64153, "High Voltage Energy Storage Pack 21 Configuration" },
    { 64154, "High Voltage Energy Storage Pack 22 History" },
    { 64155, "High Voltage Energy Storage Pack 22 Configuration" },
    { 64156, "High Voltage Energy Storage Pack 23 History" },
    { 64157, "High Voltage Energy Storage Pack 23 Configuration" },
    { 64158, "High Voltage Energy Storage Pack 24 History" },
    { 64159, "High Voltage Energy Storage Pack 24 Configuration" },
    { 64160, "High Voltage Energy Storage Pack 25 History" },
    { 64161, "High Voltage Energy Storage Pack 25 Configuration" },
    { 64162, "High Voltage Energy Storage Pack 26 History" },
    { 64163, "High Voltage Energy Storage Pack 26 Configuration" },
    { 64164, "Automated Driving System Control 2" },
    { 64165, "Dual Fuel Mode 3" },
    { 64166, "Dual Fuel Mode 2" },
    { 64167, "Dual Fuel Mode 1" },
    { 64168, "Transmission 1 History" },
    { 64169, "Transmission Shaft Twist Information" },
    { 64170, "Electronic Auxiliary Transmission Controller 2" },
    { 64171, "High Voltage Energy Storage Pack 10 Configuration" },
    { 64172, "High Voltage Energy Storage Pack 10 History" },
    { 64173, "High Voltage Energy Storage Pack 9 Configuration" },
    { 64174, "High Voltage Energy Storage Pack 9 History" },
    { 64175, "High Voltage Energy Storage Pack 8 Configuration" },
    { 64176, "High Voltage Energy Storage Pack 8 History" },
    { 64177, "High Voltage Energy Storage Pack 7 Configuration" },
    { 64178, "High Voltage Energy Storage Pack 7 History" },
    { 64179, "AUTOSAR Time Synchronization" },
    { 64180, "EV DC Charging Limits 1" },
    { 64181, "EVSE DC Charging Limits 1" },
    { 64182, "EVSE DC Charging Limits 2" },
    { 64183, "EV DC Charging Target" },
    { 64184, "EVSE DC Status 1" },
    { 64185, "EVSE 1 Contactor Cmd 1" },
    { 64186, "EVSE 1 Contactor Status 1" },
    { 64187, "Direct Lamp Control Command 3" },
    { 64188, "Direct Lamp Control Data 3" },
    { 64189, "Motor/Generator 1 Lifetime Data" },
    { 64190, "Motor/Generator 2 Lifetime Data" },
    { 64191, "Motor/Generator 3 Lifetime Data" },
    { 64192, "Motor/Generator 4 Lifetime Data" },
    { 64193, "Motor/Generator 5 Lifetime Data" },
    { 64194, "Motor/Generator 6 Lifetime Data" },
    { 64195, "Air Supply Pressure 3" },
    { 64196, "EVSE AC Supply Voltage" },
    { 64197, "EVSE AC 3-Phase Load" },
    { 64198, "Electronic Retarder Controller 3" },
    { 64200, "Electronic Transmission Controller 14" },
    { 64203, "Collision Avoidance System 4" },
    { 64204, "Collision Avoidance System 3" },
    { 64205, "Aftertreatment 1 SCR Exhaust Gas Pressures 2" },
    { 64206, "PTO Information 2" },
    { 64207, "EVCC Diagnostic Data 1" },
    { 64208, "Cab Door Control 2" },
    { 64209, "Engine Average Information 2" },
    { 64210, "Turbocharger Information 9" },
    { 64211, "Automated Driving System Control 1" },
    { 64212, "EVSE AC Status 2" },
    { 64213, "EVSE AC Status 1" },
    { 64214, "EVSE Status 1" },
    { 64215, "Object Detection Message #1/1" },
    { 64216, "Object Detection Message #2/1" },
    { 64217, "Object Detection Message #2/2" },
    { 64218, "Object Detection Message #2/3" },
    { 64219, "Object Detection Message #2/4" },
    { 64220, "Object Detection Message #2/5" },
    { 64221, "Object Detection Message #2/6" },
    { 64222, "Object Detection Message #2/7" },
    { 64223, "Object Detection Message #2/8" },
    { 64224, "Object Detection Message #2/9" },
    { 64225, "Object Detection Message #2/10" },
    { 64226, "Object Detection Message #2/11" },
    { 64227, "Object Detection Message #2/12" },
    { 64228, "Object Detection Message #2/13" },
    { 64229, "Object Detection Message #2/14" },
    { 64230, "Object Detection Message #2/15" },
    { 64231, "Object Detection Message #2/16" },
    { 64232, "Object Detection Message #2/17" },
    { 64233, "Object Detection Message #2/18" },
    { 64234, "Object Detection Message #2/19" },
    { 64235, "Object Detection Message #2/20" },
    { 64236, "Object Detection Message #2/21" },
    { 64237, "Temperature Sensing Module 1" },
    { 64238, "Temperature Sensing Module 2" },
    { 64239, "Aftertreatment 2 SCR Service Information 3" },
    { 64240, "Aftertreatment 1 SCR Service Information 3" },
    { 64241, "PSA Times Lifetime Hours" },
    { 64242, "PSA Times Stored 100 Hours" },
    { 64243, "PSA Times Active 100 Hours" },
    { 64244, "Hybrid Charge Depleting or Increasing Operation Lifetime Hours" },
    { 64245, "Hybrid Charge Depleting or Increasing Operation Stored 100 Hours" },
    { 64246, "Hybrid Charge Depleting or Increasing Operation Active 100 Hours" },
    { 64247, "Aftertreatment 1 Historical Information 3" },
    { 64248, "Engine Maximum Net Torque Map" },
    { 64249, "Aftertreatment 1 SCR 2 NOx Mass and NH3 Storage" },
    { 64250, "Aftertreatment 1 SCR 1 NOx Mass and NH3 Storage" },
    { 64251, "Evaporative System Pressure and Control" },
    { 64252, "GHG Tracking Lifetime Array Data" },
    { 64253, "GHG Tracking Stored 100 Hour Array Data" },
    { 64254, "GHG Tracking Active 100 Hour Array Data" },
    { 64255, "Green House Gas Stored 100 Hour Active Technology Tracking " },
    { 64256, "Green House Gas Active 100 Hour Active Technology Tracking " },
    { 64257, "Green House Gas Lifetime Active Technology Tracking " },
    { 64258, "NOx Tracking Engine Activity Lifetime Fuel Consumption Bins " },
    { 64259, "NOx Tracking Engine Activity Lifetime Engine Run Time Bins " },
    { 64260, "NOx Tracking Engine Activity Lifetime Vehicle Distance Bins " },
    { 64261, "NOx Tracking Engine Activity Lifetime Engine Output Energy Bins " },
    { 64262, "NOx Tracking Valid NOx Lifetime Fuel Consumption Bins " },
    { 64263, "NOx Tracking Valid NOx Lifetime Engine Run Time Bins " },
    { 64264, "NOx Tracking Valid NOx Lifetime Vehicle Distance Bins " },
    { 64265, "NOx Tracking Valid NOx Lifetime Engine Output Energy Bins " },
    { 64266, "NOx Tracking Valid NOx Lifetime Engine Out NOx Mass Bins " },
    { 64267, "NOx Tracking Valid NOx Lifetime System Out NOx Mass Bins " },
    { 64268, "NOx Tracking Stored 100 Hour Fuel Consumption Bins " },
    { 64269, "NOx Tracking Stored 100 Hour Engine Run Time Bins " },
    { 64270, "NOx Tracking Stored 100 Hour Vehicle Distance Bins " },
    { 64271, "NOx Tracking Stored 100 Hour Engine Output Energy Bins " },
    { 64272, "NOx Tracking Stored 100 Hour Engine Out NOx Mass Bins " },
    { 64273, "NOx Tracking Stored 100 Hour System Out NOx Mass Bins " },
    { 64274, "NOx Tracking Active 100 Hour Fuel Consumption Bins " },
    { 64275, "NOx Tracking Active 100 Hour Engine Run Time Bins " },
    { 64276, "NOx Tracking Active 100 Hour Vehicle Distance Bins " },
    { 64277, "NOx Tracking Active 100 Hour Engine Output Energy Bins " },
    { 64278, "NOx Tracking Active 100 Hour Engine Out NOx Mass Bins " },
    { 64279, "NOx Tracking Active 100 Hour System Out NOx Mass Bins " },
    { 64280, "Motor/Generator 6 Inverter Control 2" },
    { 64281, "Motor/Generator 6 Inverter Limits Request Power" },
    { 64282, "Motor/Generator 6 Inverter Limits Request Mechanical" },
    { 64283, "Motor/Generator 6 Inverter Limits Request DC Side" },
    { 64284, "Motor/Generator 6 Inverter Isolation Integrity Request" },
    { 64285, "Motor/Generator 5 Inverter Control 2" },
    { 64286, "Motor/Generator 5 Inverter Limits Request Power" },
    { 64287, "Motor/Generator 5 Inverter Limits Request Mechanical" },
    { 64288, "Motor/Generator 5 Inverter Limits Request DC Side" },
    { 64289, "Motor/Generator 5 Inverter Isolation Integrity Request" },
    { 64290, "Motor/Generator 4 Inverter Control 2" },
    { 64291, "Motor/Generator 4 Inverter Limits Request Power" },
    { 64292, "Motor/Generator 4 Inverter Limits Request Mechanical" },
    { 64293, "Motor/Generator 4 Inverter Limits Request DC Side" },
    { 64294, "Motor/Generator 4 Inverter Isolation Integrity Request" },
    { 64295, "Motor/Generator 3 Inverter Control 2" },
    { 64296, "Motor/Generator 3 Inverter Limits Request Power" },
    { 64297, "Motor/Generator 3 Inverter Limits Request Mechanical" },
    { 64298, "Motor/Generator 3 Inverter Limits Request DC Side" },
    { 64299, "Motor/Generator 3 Inverter Isolation Integrity Request" },
    { 64300, "Diagnostic Readiness 4" },
    { 64301, "Turbocharger Information 8" },
    { 64302, "Winch Information 2" },
    { 64303, "Motor/Generator 6 Inverter Reference 1" },
    { 64304, "Motor/Generator 6 Inverter Status 1" },
    { 64305, "Motor/Generator 6 Inverter Reference 2" },
    { 64306, "Motor/Generator 6 Inverter Temperature" },
    { 64307, "Motor/Generator 6 Inverter Motor Temperature" },
    { 64308, "Motor/Generator 6 Inverter Isolation Integrity" },
    { 64309, "Motor/Generator 6 Inverter Active Power Limits" },
    { 64310, "Motor/Generator 5 Inverter Reference 1" },
    { 64311, "Motor/Generator 5 Inverter Status 1" },
    { 64312, "Motor/Generator 5 Inverter Reference 2" },
    { 64313, "Motor/Generator 5 Inverter Temperature" },
    { 64314, "Motor/Generator 5 Inverter Motor Temperature" },
    { 64315, "Motor/Generator 5 Inverter Isolation Integrity" },
    { 64316, "Motor/Generator 5 Inverter Active Power Limits" },
    { 64317, "Motor/Generator 4 Inverter Reference 1" },
    { 64318, "Motor/Generator 4 Inverter Status 1" },
    { 64319, "Motor/Generator 4 Inverter Reference 2" },
    { 64320, "Motor/Generator 4 Inverter Temperature" },
    { 64321, "Motor/Generator 4 Inverter Motor Temperature" },
    { 64322, "Motor/Generator 4 Inverter Isolation Integrity" },
    { 64323, "Motor/Generator 4 Inverter Active Power Limits" },
    { 64324, "Motor/Generator 3 Inverter Reference 1" },
    { 64325, "Motor/Generator 3 Inverter Status 1" },
    { 64326, "Motor/Generator 3 Inverter Reference 2" },
    { 64327, "Motor/Generator 3 Inverter Temperature" },
    { 64328, "Motor/Generator 3 Inverter Motor Temperature" },
    { 64329, "Motor/Generator 3 Inverter Isolation Integrity" },
    { 64330, "Motor/Generator 3 Inverter Active Power Limits" },
    { 64331, "Automated Driving System Status 1" },
    { 64332, "Cab Climate System Information 2" },
    { 64333, "Maintenance Information" },
    { 64334, "Hoist Control Information" },
    { 64335, "High Voltage Energy Storage Pack 6 History" },
    { 64336, "High Voltage Energy Storage Pack 6 Configuration" },
    { 64337, "High Voltage Energy Storage Pack 5 History" },
    { 64338, "High Voltage Energy Storage Pack 5 Configuration" },
    { 64339, "High Voltage Energy Storage Pack 4 History" },
    { 64340, "High Voltage Energy Storage Pack 4 Configuration" },
    { 64341, "High Voltage Energy Storage Pack 3 History" },
    { 64342, "High Voltage Energy Storage Pack 3 Configuration" },
    { 64343, "High Voltage Energy Storage Pack 2 History" },
    { 64344, "High Voltage Energy Storage Pack 2 Configuration" },
    { 64345, "High Voltage Energy Storage Pack 1 History" },
    { 64346, "High Voltage Energy Storage Pack 1 Configuration" },
    { 64347, "Vehicle Fire Suppression System Module 1 Detector Data" },
    { 64348, "Vehicle Fire Suppression System Module 2 Detector Data" },
    { 64349, "Vehicle Fire Suppression System Module 3 Detector Data" },
    { 64350, "Vehicle Fire Suppression System Module 4 Detector Data" },
    { 64351, "Vehicle Fire Suppression System Module 1 Auxiliary Data" },
    { 64352, "Vehicle Fire Suppression System Module 2 Auxiliary Data" },
    { 64353, "Vehicle Fire Suppression System Module 3 Auxiliary Data" },
    { 64354, "Vehicle Fire Suppression System Module 4 Auxiliary Data" },
    { 64355, "Vehicle Fire Suppression System Module 1 Names" },
    { 64356, "Vehicle Fire Suppression System Module 2 Names" },
    { 64357, "Vehicle Fire Suppression System Module 3 Names" },
    { 64358, "Vehicle Fire Suppression System Module 4 Names" },
    { 64359, "Motor/Generator 2 Inverter Active Power Limits" },
    { 64360, "Motor/Generator 2 Inverter Isolation Integrity" },
    { 64361, "Motor/Generator 1 Inverter Active Power Limits" },
    { 64362, "Motor/Generator 1 Inverter Isolation Integrity" },
    { 64363, "High Voltage Bus Information" },
    { 64364, "Motor/Generator 2 Inverter Reference 1" },
    { 64365, "Motor/Generator 2 Inverter Status 1" },
    { 64366, "Motor/Generator 2 Inverter Reference 2" },
    { 64367, "Motor/Generator 2 Inverter Temperature" },
    { 64368, "Motor/Generator 2 Inverter Motor Temperature" },
    { 64369, "Motor/Generator 1 Inverter Motor Temperature" },
    { 64370, "Motor/Generator 1 Inverter Temperature" },
    { 64371, "Motor/Generator 1 Inverter Reference 2" },
    { 64372, "Motor/Generator 1 Inverter Status 1" },
    { 64373, "Motor/Generator 1 Inverter Reference 1" },
    { 64374, "Personnel Detect Status" },
    { 64375, "Engine Cylinder Pressure Gamma 1" },
    { 64376, "Engine Cylinder Pressure Gamma 2" },
    { 64377, "Engine Cylinder Pressure Gamma 3" },
    { 64378, "Engine Cylinder Pressure Gamma 4" },
    { 64379, "Engine Cylinder Pressure Gamma 5" },
    { 64380, "Reserved for Network Operation Mode" },
    { 64381, "Electrified Accessory Generator Coolant Pump Status 1" },
    { 64382, "Electrified Accessory Generator Coolant Fan Status 1" },
    { 64383, "Well Stimulation Pump System Filter Information" },
    { 64384, "PTO Governor Configuration" },
    { 64385, "On Board Programming 2" },
    { 64386, "Primary or Rear Hitch Yaw" },
    { 64387, "Secondary or Front Hitch Yaw" },
    { 64388, "Operator Status" },
    { 64389, "Engine Idle Management Information" },
    { 64390, "Alcohol Interlock To Vehicle" },
    { 64391, "Vehicle To Alcohol Interlock" },
    { 64392, "Marine Control Information 3" },
    { 64393, "Engine Fluid Level/Pressure 13" },
    { 64394, "High Voltage Energy Storage System Data 11" },
    { 64395, "Economy Mode Inactive Hours" },
    { 64396, "Economy Mode Estimated Instantaneous Fuel Savings Rate" },
    { 64397, "Economy Mode Active Hours" },
    { 64398, "Economy Mode Fuel Used" },
    { 64399, "Economy Mode Estimated Fuel Savings" },
    { 64400, "DC/DC Converter 4 Voltage" },
    { 64401, "DC/DC Converter 3 Voltage" },
    { 64402, "DC/DC Converter 2 Voltage" },
    { 64403, "DC/DC Converter 1 Voltage" },
    { 64404, "Electronic Engine Controller 22" },
    { 64405, "Engine Hours 2" },
    { 64406, "Engine Information 3" },
    { 64407, "Vehicle Electrical Power 15" },
    { 64408, "Exhaust Oxygen 2" },
    { 64409, "DC/AC Accessory Inverter 1 Temperatures" },
    { 64410, "DC/AC Accessory Inverter 1 DC Side Limits " },
    { 64411, "DC/AC Accessory Inverter 1 AC Side Limits " },
    { 64412, "DC/AC Accessory Inverter 1 Configuration 1" },
    { 64413, "DC/AC Accessory Inverter 1 Lifetime Data" },
    { 64414, "DC/AC Accessory Inverter 2 Temperatures" },
    { 64415, "DC/AC Accessory Inverter 2 DC Side Limits " },
    { 64416, "DC/AC Accessory Inverter 2 AC Side Limits " },
    { 64417, "DC/AC Accessory Inverter 2 Configuration 1" },
    { 64418, "DC/AC Accessory Inverter 2 Lifetime Data" },
    { 64419, "DC/AC Accessory Inverter 3 Temperatures" },
    { 64420, "DC/AC Accessory Inverter 3 DC Side Limits " },
    { 64421, "DC/AC Accessory Inverter 3 AC Side Limits " },
    { 64422, "DC/AC Accessory Inverter 3 Configuration 1" },
    { 64423, "DC/AC Accessory Inverter 3 Lifetime Data" },
    { 64424, "DC/AC Accessory Inverter 4 Temperatures" },
    { 64425, "DC/AC Accessory Inverter 4 DC Side Limits " },
    { 64426, "DC/AC Accessory Inverter 4 AC Side Limits " },
    { 64427, "DC/AC Accessory Inverter 4 Configuration 1" },
    { 64428, "DC/AC Accessory Inverter 4 Lifetime Data" },
    { 64429, "DC/AC Accessory Inverter 5 Temperatures" },
    { 64430, "DC/AC Accessory Inverter 5 DC Side Limits " },
    { 64431, "DC/AC Accessory Inverter 5 AC Side Limits " },
    { 64432, "DC/AC Accessory Inverter 5 Configuration 1" },
    { 64433, "DC/AC Accessory Inverter 5 Lifetime Data" },
    { 64434, "Well Stimulation Pump Sensor Calibration Status" },
    { 64435, "Well Stimulation Pump Fluid Volume" },
    { 64436, "Well Stimulation Pump Serial Number" },
    { 64437, "Well Stimulation Pump Trip Hours" },
    { 64438, "Aftertreatment 1 Outlet Gas 4" },
    { 64439, "Aftertreatment 1 Intake Gas 4" },
    { 64440, "DC/DC Converter 4 Lifetime Data" },
    { 64441, "DC/DC Converter 4 Configuration 1" },
    { 64442, "DC/DC Converter 4 SLI Battery Limits" },
    { 64443, "DC/DC Converter 4 Temperatures" },
    { 64444, "DC/DC Converter 4 Low Side Limits" },
    { 64445, "DC/DC Converter 4 High Side Limits" },
    { 64446, "DC/DC Converter 3 Lifetime Data" },
    { 64447, "DC/DC Converter 3 Configuration 1" },
    { 64448, "DC/DC Converter 3 SLI Battery Limits" },
    { 64449, "DC/DC Converter 3 Temperatures" },
    { 64450, "DC/DC Converter 3 Low Side Limits" },
    { 64451, "DC/DC Converter 3 High Side Limits" },
    { 64452, "DC/DC Converter 2 Lifetime Data" },
    { 64453, "DC/DC Converter 2 Configuration 1" },
    { 64454, "DC/DC Converter 2 SLI Battery Limits" },
    { 64455, "DC/DC Converter 2 Temperatures" },
    { 64456, "DC/DC Converter 2 Low Side Limits" },
    { 64457, "DC/DC Converter 2 High Side Limits" },
    { 64458, "CiA 602-2 AUTOSAR CAN-NM" },
    { 64459, "Engine Exhaust Particulate Control System Info" },
    { 64460, "Well Stimulation Pump Hours" },
    { 64461, "Well Stimulation Pump System Configuration Status" },
    { 64462, "Configurable Receive SPNs Status" },
    { 64463, "DC/DC Converter 1 Lifetime Data" },
    { 64464, "DC/DC Converter 1 Configuration 1" },
    { 64465, "DC/DC Converter 1 SLI Battery Limits" },
    { 64466, "Pump Oil Message" },
    { 64467, "Well Stimulation Pump System Lifetime Totals" },
    { 64468, "Well Stimulation Pump System Configuration" },
    { 64469, "Aftercooler and Oil Cooler Fluids 2" },
    { 64470, "Electronic Engine Controller 21" },
    { 64471, "Configurable Transmit PGNs Status" },
    { 64472, "DC/DC Converter 1 Temperatures" },
    { 64473, "DC/DC Converter 1 Low Side Limits" },
    { 64474, "DC/DC Converter 1 High Side Limits" },
    { 64475, "Reserved for Diagnostic Message" },
    { 64476, "Door Control 4" },
    { 64477, "Door Control 3" },
    { 64478, "Engine Temperature 6" },
    { 64479, "Intake/Exhaust Conditions 3" },
    { 64480, "Aftercooler and Oil Cooler Fluids 1" },
    { 64481, "Diode Temperature 2" },
    { 64482, "Diode Temperature 1" },
    { 64483, "Alternator Temperature 2" },
    { 64484, "Fuel Information 7 (Gaseous)" },
    { 64485, "High Voltage Energy Storage System Fan Status 1" },
    { 64486, "High Voltage Energy Storage System Fan Commands" },
    { 64487, "SCR Operator Inducement Information 5" },
    { 64488, "Aftertreatment System Information 2" },
    { 64489, "Ethernet 1 Connection Information 2" },
    { 64490, "Ethernet 1 Connection Information 1" },
    { 64491, "Oil Debris Monitor Counts Ferrous Bins 1 & 2" },
    { 64492, "Oil Debris Monitor Counts Ferrous Bins 3 & 4" },
    { 64493, "Oil Debris Monitor Counts Ferrous Bins 5 & 6" },
    { 64494, "Oil Debris Monitor Counts Non-Ferrous Bins 1 & 2" },
    { 64495, "Oil Debris Monitor Counts Non-Ferrous Bins 3 & 4" },
    { 64496, "Oil Debris Monitor Counts Non-Ferrous Bins 5 & 6" },
    { 64497, "Oil Debris Monitoring System Status" },
    { 64498, "Engine Fuel/Lube Systems 3" },
    { 64499, "Cruise Control / Vehicle Speed 5" },
    { 64500, "Aftertreatment 2 Diesel Oxidation Catalyst 2" },
    { 64501, "Aftertreatment 1 Diesel Oxidation Catalyst 2" },
    { 64502, "Vehicle Position 2" },
    { 64503, "Electrified Accessory Propulsion Motor Coolant Fan 3 Status 1" },
    { 64504, "Electrified Accessory Propulsion Motor Coolant Fan 2 Status 1" },
    { 64505, "Electrified Accessory Propulsion Motor Coolant Fan 1 Status 1" },
    { 64506, "Electrified Accessory Power Electronics Coolant Fan 3 Status 1" },
    { 64507, "Electrified Accessory Power Electronics Coolant Fan 2 Status 1" },
    { 64508, "Electrified Accessory Power Electronics Coolant Fan 1 Status 1" },
    { 64509, "Electrified Accessory Propulsion Motor Oil Pump Status 1" },
    { 64510, "Electrified Accessory Propulsion Motor Coolant Pump Status 1" },
    { 64511, "Electrified Accessory Power Electronics Coolant Pump Status 1" },
    { 64512, "Trailer Wheel Brake Wear Life Remaining Information" },
    { 64513, "Electrified Accessory Motor Status 1" },
    { 64514, "SCR System Information" },
    { 64515, "Vehicle Electrical Power 14" },
    { 64516, "Vehicle Electrical Power 13" },
    { 64517, "Vehicle Electrical Power 12" },
    { 64518, "Vehicle Electrical Power 11" },
    { 64519, "Vehicle Electrical Power 10" },
    { 64520, "Vehicle Electrical Power 9" },
    { 64521, "Vehicle Electrical Power 8" },
    { 64522, "Vehicle Electrical Power 7" },
    { 64523, "Electronic Engine Controller 20" },
    { 64524, "Evaporative Systems" },
    { 64525, "Fire Pump Statistics 1" },
    { 64526, "Primary or Rear Hitch Roll and Pitch Sensitivity" },
    { 64527, "Secondary or Front Hitch Roll and Pitch Sensitivity" },
    { 64528, "Ambient Conditions 3" },
    { 64529, "Total Gaseous Fuel Information" },
    { 64530, "Cab Door Control 1" },
    { 64531, "Door Latch Status" },
    { 64532, "Vehicle Electrical Power 3 (obsolete, use PGN 65106)" },
    { 64533, "Vehicle Electrical Power 6" },
    { 64534, "Payload Temperature 2" },
    { 64535, "Payload Temperature 1" },
    { 64536, "Payload System Totals 2" },
    { 64537, "Payload System Totals 1" },
    { 64538, "HVESS Thermal Management System Control 1" },
    { 64539, "HVESS Thermal Management System Control 2" },
    { 64540, "Refrigeration Compartment Information 1" },
    { 64541, "Refrigeration Compartment Information 2" },
    { 64542, "Vehicle Electrical Power 16" },
    { 64543, "Vehicle Electrical Power 17" },
    { 64544, "High Voltage Energy Storage System Module Status 2" },
    { 64545, "High Voltage Energy Storage System Module Status 3" },
    { 64546, "Electronic Engine Controller 19" },
    { 64547, "Fuel Consumption (Liquid) 2" },
    { 64548, "Aftertreatment 2 Diesel Exhaust Fluid Tank 1 Information 2" },
    { 64549, "Aftertreatment 1 Diesel Exhaust Fluid Tank 1 Information 2" },
    { 64550, "Aftertreatment 2 Diesel Exhaust Fluid Information 2" },
    { 64551, "Aftertreatment 1 Diesel Exhaust Fluid Information 2" },
    { 64552, "Cruise Control / Vehicle Speed 6" },
    { 64553, "Forward Lane Image 3" },
    { 64554, "Operator Inducement Information 1" },
    { 64555, "Cruise Control / Vehicle Speed 4" },
    { 64556, "Brake Caliper Lining Clearance" },
    { 64557, "Alternate Fuel 5" },
    { 64558, "Engine Turbocharger Control 3" },
    { 64559, "Fire Suppression Agent Status" },
    { 64560, "SCR Operator Inducement Information 4" },
    { 64561, "Aftertreatment System Information 1" },
    { 64562, "Aftertreatment 1 Particulate Sensor Information 3" },
    { 64563, "Engine Fuel Injector Metering Rail Pressure Information 3" },
    { 64564, "Engine Fuel Injector Metering Rail Pressure Information 2" },
    { 64565, "Aftertreatment 2 Diesel Exhaust Fluid Pump 1 Information" },
    { 64566, "Gaseous Fuel Supply Valve Information" },
    { 64567, "Engine Oil Mist Detection Information 2" },
    { 64568, "Engine Oil Mist Detection Information 1" },
    { 64569, "Gaseous Fuel Supply Pressure 2" },
    { 64570, "Gaseous Fuel Supply Pressure 1" },
    { 64571, "Engine End Bearing Temperature 3" },
    { 64572, "Engine End Bearing Temperature 2" },
    { 64573, "Engine End Bearing Temperature 1" },
    { 64574, "Heat Exchanger Debris Purge Information" },
    { 64575, "Engine Turbocharger Control 2" },
    { 64576, "Engine Hydraulic Fuel 2 Pump Status" },
    { 64577, "Alternate Fuel 4" },
    { 64578, "Tire Condition Message 2" },
    { 64579, "Tire Configuration Status Information" },
    { 64580, "High Voltage Energy Storage System Data 15" },
    { 64581, "Tire Wireless Signal Strength Indicator" },
    { 64582, "Tire Sensor Identification Status" },
    { 64583, "Monitored Tire Information" },
    { 64584, "Aftertreatment 2 Historical Information 2" },
    { 64585, "Aftertreatment 1 Historical Information 2" },
    { 64586, "SCR System Cleaning" },
    { 64587, "Electronic Engine Controller 17" },
    { 64588, "SCR Operator Inducement Information 3" },
    { 64589, "Aftertreatment 2 SCR Dosing System Information 3" },
    { 64590, "Aftertreatment 1 SCR Dosing System Information 3" },
    { 64591, "Payload Weight Sensor Information" },
    { 64592, "Payload System Status" },
    { 64593, "Air Suspension Control 7" },
    { 64594, "Bin Weight and Lift Count" },
    { 64595, "Engine Gaseous Leakage Information" },
    { 64596, "Driving and Rest Times Driver 2" },
    { 64597, "Driving and Rest Times Driver 1" },
    { 64598, "SCR Operator Inducement Information 2" },
    { 64599, "SCR Operator Inducement Information 1" },
    { 64600, "Turbocharger Information 7" },
    { 64601, "Engine Load Sharing Information" },
    { 64602, "Synchronized Service Distance Information" },
    { 64603, "Synchronized Service Delay/Operational Time Based Information" },
    { 64604, "Synchronized Service Delay/Calendar Time Based Information" },
    { 64605, "High Voltage Energy Storage System Configuration" },
    { 64606, "High Voltage Energy Storage System History" },
    { 64607, "Encoder Position" },
    { 64608, "Encoder High Resolution Position" },
    { 64609, "Encoder Speed" },
    { 64610, "Encoder Acceleration" },
    { 64611, "Encoder Position with Speed and Acceleration" },
    { 64612, "Inclinometer Slope Longitudinal (16 bit)" },
    { 64613, "Inclinometer Slope Longitudinal (32 bit)" },
    { 64614, "Inclinometer Slope Lateral (16 bit)" },
    { 64615, "Inclinometer Slope Lateral (32 bit)" },
    { 64616, "CANopen Emergency Message" },
    { 64617, "EV Operator Indicators 1" },
    { 64618, "System Identification" },
    { 64619, "Engine Maximum Net Torque Map (obsolete, use PGN 64248)" },
    { 64620, "Alarm" },
    { 64621, "Acoustic Warning Request" },
    { 64622, "Acoustic Warning State" },
    { 64623, "Vehicle Load" },
    { 64624, "Body Application Unit 1" },
    { 64625, "Body Application Unit 2" },
    { 64626, "Body Application Unit 3" },
    { 64627, "Body Application Unit 4" },
    { 64628, "Body Application Unit 5" },
    { 64629, "Body Application Unit 6" },
    { 64630, "Body Application Unit 7" },
    { 64631, "Body Application Unit 8" },
    { 64632, "Electronic Control Unit" },
    { 64633, "ECU Power Supply" },
    { 64634, "ECU Temperature" },
    { 64635, "Error" },
    { 64636, "Heating And Refrigerating Unit 1" },
    { 64637, "Heating And Refrigerating Unit 2" },
    { 64638, "Heating And Refrigerating Unit 3" },
    { 64639, "Heating And Refrigerating Unit 4" },
    { 64640, "HRU Temperature Setpoint" },
    { 64641, "Lifting Unit 1" },
    { 64642, "Tail-Lift Unit 1" },
    { 64643, "Vehicle Status" },
    { 64644, "Windshield Wiper Request" },
    { 64645, "Fuel Cell Auxiliary Heater Control" },
    { 64646, "Fuel Cell Auxiliary Heater Information" },
    { 64647, "Fuel Cell Coolant Pump 1 Command" },
    { 64648, "Fuel Cell Coolant Pump 2 Command" },
    { 64649, "Fuel Cell Coolant Pump 1 Status" },
    { 64650, "Fuel Cell Coolant Pump 2 Status" },
    { 64651, "Aftertreatment 1 Particulate Sensor Information 2" },
    { 64652, "Aftertreatment 1 Particulate Sensor Information 1" },
    { 64653, "Product Identification Information" },
    { 64654, "Control Function Functionalities" },
    { 64655, "Alternate Fuel 3" },
    { 64656, "Engine Fuel Injector Metering Rail Pressure Information 1" },
    { 64657, "Engine Exhaust NOx" },
    { 64658, "Air Fuel Ratio" },
    { 64659, "Gaseous Fuel Pressure 2" },
    { 64660, "Aftertreatment System Abuse Information" },
    { 64661, "Engine Cylinder Pressure Monitor Status Information" },
    { 64662, "Engine Information 2" },
    { 64663, "Electronic Steering Control 2" },
    { 64664, "Vehicle Speed Limiter" },
    { 64665, "Assembly Unit Identification" },
    { 64666, "Joystick 3 Lamp Status" },
    { 64667, "Joystick 2 Lamp Status" },
    { 64668, "Joystick 1 Lamp Status" },
    { 64669, "Engine Timing Actuator Position Command" },
    { 64670, "Engine Timing Actuator Position" },
    { 64671, "Dash Display 2" },
    { 64672, "Multi-fuel Engine Hours" },
    { 64673, "Engine Spark Misfire Rate 3" },
    { 64674, "Engine Spark Misfire Rate 2" },
    { 64675, "Engine Spark Misfire Rate 1" },
    { 64676, "Engine Spark Maximum Voltage 6" },
    { 64677, "Engine Spark Maximum Voltage 5" },
    { 64678, "Engine Spark Maximum Voltage 4" },
    { 64679, "Engine Spark Maximum Voltage 3" },
    { 64680, "Engine Spark Maximum Voltage 2" },
    { 64681, "Engine Spark Maximum Voltage 1" },
    { 64682, "Engine Spark Minimum Voltage 6" },
    { 64683, "Engine Spark Minimum Voltage 5" },
    { 64684, "Engine Spark Minimum Voltage 4" },
    { 64685, "Engine Spark Minimum Voltage 3" },
    { 64686, "Engine Spark Minimum Voltage 2" },
    { 64687, "Engine Spark Minimum Voltage 1" },
    { 64688, "Engine Ignition Controller Maintenance Hours" },
    { 64689, "Engine Ignition Control Module Status" },
    { 64690, "Switched Power Output Current" },
    { 64691, "Fused Power Output Current" },
    { 64692, "Switched Power Output Status" },
    { 64693, "Fused Power Output Status" },
    { 64694, "Vehicle Electrical Power 5" },
    { 64695, "Hybrid System Status 2" },
    { 64696, "Aftertreatment 2 Service 2" },
    { 64697, "Aftertreatment 1 Service 2" },
    { 64698, "Aftertreatment 2 SCR Electronic Control Module Information" },
    { 64699, "Aftertreatment 1 SCR Electronic Control Module Information" },
    { 64700, "Aftertreatment 2 SCR Service Information 2" },
    { 64701, "Aftertreatment 1 SCR Service Information 2" },
    { 64702, "Electronic Transmission Controller #9" },
    { 64703, "Electronic Transmission Controller #10" },
    { 64704, "Electronic Transmission Controller #11" },
    { 64705, "Transmission Fluids 3" },
    { 64706, "Hybrid or EV System Status 1" },
    { 64707, "Fuel Information 4 (Gaseous)" },
    { 64708, "Aftertreatment 2 SCR Exhaust Gas Temperature 2" },
    { 64709, "Aftertreatment 1 SCR Exhaust Gas Temperature 2" },
    { 64710, "OBD Information" },
    { 64711, "Model Year and Certification Engine Family" },
    { 64712, "Electronic Engine Controller 13" },
    { 64713, "Engine Fuel/Throttle Valve Information 2" },
    { 64714, "Engine Exhaust Gas Recirculation 2 Actuator" },
    { 64715, "Engine Exhaust Gas Recirculation 1 Actuator" },
    { 64716, "Electronic Engine Controller 12" },
    { 64717, "Drive Strategy Status" },
    { 64718, "Drive Strategy command" },
    { 64719, "NOx Sensor Self-Diagnosis Request" },
    { 64720, "Engine Particulate Sensor Information" },
    { 64721, "Active Service Only DTCs" },
    { 64722, "Previously Active Service Only DTCs" },
    { 64723, "Diagnostic Data Clear/Reset for All Service Only DTCs" },
    { 64724, "XCP Get Slave ID" },
    { 64725, "Aftertreatment 1 Diesel Exhaust Fluid Pump 1 Information" },
    { 64726, "Aftertreatment 1 Diesel Particulate Filter 2 Soot 5" },
    { 64727, "Aftertreatment 1 Diesel Particulate Filter 2 Soot 4" },
    { 64728, "Aftertreatment 1 Diesel Particulate Filter 2 Soot 3" },
    { 64729, "Aftertreatment 1 Diesel Particulate Filter 1 Soot 5" },
    { 64730, "Aftertreatment 1 Diesel Particulate Filter 1 Soot 4" },
    { 64731, "Aftertreatment 1 Diesel Particulate Filter 1 Soot 3" },
    { 64732, "Cruise Control / Vehicle Speed 3" },
    { 64733, "Aftertreatment 2 Air Control 3" },
    { 64734, "Aftertreatment 1 Air Control 3" },
    { 64735, "Engine Fluid Level/Pressure 12" },
    { 64736, "Diesel Particulate Filter Control 2" },
    { 64737, "Fuel Economy 2 (Liquid)" },
    { 64738, "Supplemental Fan Status" },
    { 64739, "Engine Exhaust Brake Control" },
    { 64740, "Engine Fuel Properties" },
    { 64741, "Hydraulic Oil Properties" },
    { 64742, "Vehicle/Chassis Lubrication System 2" },
    { 64743, "Engine Configuration 3" },
    { 64744, "Intake Valve Actuation Control" },
    { 64745, "Armrest Switch Matrix Commands" },
    { 64746, "Vehicle Electrical Power 4 (obsolete, use PGN 64695)" },
    { 64747, "Aftertreatment 2 NOx Adsorber Information" },
    { 64748, "Aftertreatment 1 NOx Adsorber Information" },
    { 64749, "Aftertreatment 2 Warm Up Diesel Oxidation Catalyst Information" },
    { 64750, "Land Leveling System Reference Elevation Data" },
    { 64751, "Engine Fluid Level/Pressure 11" },
    { 64752, "Engine Fuel/Lube _x000D_Systems 2" },
    { 64753, "Engine Turbocharger Wastegate Actuator and Exhaust Back Pressure Regulator Information 1" },
    { 64754, "Engine Fuel/Throttle Valve Information 1" },
    { 64755, "Engine Turbocharger Compressor Bypass Information" },
    { 64756, "Charge Air Cooler 2" },
    { 64757, "Charge Air Cooler 2 Precooler" },
    { 64758, "Charge Air Cooler 1" },
    { 64759, "Charge Air Cooler 1 Precooler" },
    { 64760, "Diesel Particulate Filter 2 Soot 2" },
    { 64761, "Diesel Particulate Filter 1 Soot 2" },
    { 64762, "Electronic Engine Controller 11" },
    { 64763, "Engine Manifold Actuator Position" },
    { 64764, "Engine Manifold Actuator Control" },
    { 64765, "Electronic Engine Controller 9" },
    { 64766, "Electronic Engine Controller 10" },
    { 64767, "Engine Temperature 5" },
    { 64768, "Engine Fluid Level/Pressure 10" },
    { 64769, "Low Voltage Disconnect  Status" },
    { 64770, "All implements stop operations switch state" },
    { 64771, "Implement Operating state command" },
    { 64772, "Direct Lamp Control Data 2" },
    { 64773, "Direct Lamp Control Data 1" },
    { 64774, "Direct Lamp Control Command 2" },
    { 64775, "Direct Lamp Control Command 1" },
    { 64776, "Engine oil message" },
    { 64777, "High Resolution Fuel Consumption (Liquid)" },
    { 64778, "Aftertreatment 2 Outlet Gas NOx Sensor Correction Data 2" },
    { 64779, "Aftertreatment 2 Outlet Gas NOx Sensor Correction Data 1" },
    { 64780, "Aftertreatment 2 Intake Gas NOx Sensor Correction Data 2" },
    { 64781, "Aftertreatment 2 Intake Gas NOx Sensor Correction Data 1" },
    { 64782, "Aftertreatment 1 Outlet Gas NOx Sensor Correction Data 2" },
    { 64783, "Aftertreatment 1 Outlet Gas NOx Sensor Correction Data 1" },
    { 64784, "Aftertreatment 1 Intake Gas NOx Sensor Correction Data 2" },
    { 64785, "Aftertreatment 1 Intake Gas NOx Sensor Correction Data 1" },
    { 64786, "Magnet Status Information 1" },
    { 64787, "Magnet System Configuration Information" },
    { 64788, "Battery Charger 2" },
    { 64789, "Battery Charger 1" },
    { 64790, "Occupant Classification System Information" },
    { 64791, "Beltlock and Airbag Deactivation Switch Information" },
    { 64792, "Collision Sensor Information" },
    { 64793, "Ignitor Loop Information" },
    { 64794, "Aftertreatment 1 Warm Up Diesel Oxidation Catalyst Information" },
    { 64795, "Diesel Particulate Filter 2 Soot" },
    { 64796, "Diesel Particulate Filter 1 Soot" },
    { 64797, "Aftertreatment Differential Temperature 2 " },
    { 64798, "Aftertreatment Differential Temperature 1 " },
    { 64799, "Aftertreatment 2 Diesel Oxidation Catalyst 1" },
    { 64800, "Aftertreatment 1 Diesel Oxidation Catalyst 1" },
    { 64801, "Aftertreatment 2 Gas Oxidation Catalyst" },
    { 64802, "Aftertreatment 1 Gas Oxidation Catalyst" },
    { 64803, "Extended Joystick Message 10" },
    { 64804, "Basic Joystick Message 10" },
    { 64805, "Extended Joystick Message 9" },
    { 64806, "Basic Joystick Message 9" },
    { 64807, "Extended Joystick Message 8" },
    { 64808, "Basic Joystick Message 8" },
    { 64809, "Extended Joystick Message 7" },
    { 64810, "Basic Joystick Message 7" },
    { 64811, "Extended Joystick Message 6" },
    { 64812, "Basic Joystick Message 6" },
    { 64813, "Extended Joystick Message 5" },
    { 64814, "Basic Joystick Message 5" },
    { 64815, "Extended Joystick Message 4" },
    { 64816, "Basic Joystick Message 4" },
    { 64817, "Fan Drive #2" },
    { 64818, "ECU diagnostic protocol" },
    { 64819, "Aftertreatment 2 Diesel Exhaust Fluid Supply Information" },
    { 64820, "Aftertreatment 2 SCR Reagant Tank 2 Information" },
    { 64821, "Aftertreatment 2 Diesel Exhaust Fluid Tank 1 Information 1" },
    { 64822, "Aftertreatment 2 Diesel Exhaust Fluid Information 1" },
    { 64823, "Aftertreatment 2 SCR Service Information 1" },
    { 64824, "Aftertreatment 2 SCR Exhaust Gas Temperature 1" },
    { 64825, "Aftertreatment 2 SCR Exhaust Gas Pressures" },
    { 64826, "Aftertreatment 2 SCR Dosing System Requests 2" },
    { 64827, "Aftertreatment 2 SCR Dosing System Information 2" },
    { 64828, "Aftertreatment 1 Diesel Exhaust Fluid Supply Information" },
    { 64829, "Aftertreatment 1 SCR Reagant Tank 2 Information" },
    { 64830, "Aftertreatment 1 SCR Exhaust Gas Temperature 1" },
    { 64831, "Aftertreatment 1 SCR Exhaust Gas Pressures" },
    { 64832, "Aftertreatment 1 SCR Dosing System Requests 2" },
    { 64833, "Aftertreatment 1 SCR Dosing System Information 2" },
    { 64834, "ISOBUS compliance certification" },
    { 64835, "Machine Selected Speed command" },
    { 64836, "Aftertreatment 2 Fuel Control 2" },
    { 64837, "Aftertreatment 2 Three Way Catalyst" },
    { 64838, "Aftertreatment 1 Three Way Catalyst" },
    { 64839, "Transmission Mode Labels" },
    { 64840, "Engine Exhaust Bank 2 O2 Fuel Trim" },
    { 64841, "Engine Exhaust Bank 1 O2 Fuel Trim" },
    { 64842, "General Purpose Message #2/11" },
    { 64843, "General Purpose Message #2/10" },
    { 64844, "General Purpose Message #2/9" },
    { 64845, "General Purpose Message #2/8" },
    { 64846, "General Purpose Message #2/7" },
    { 64847, "General Purpose Message #2/6" },
    { 64848, "General Purpose Message #1/9" },
    { 64849, "Aftercooler Coolant Control Valve Command" },
    { 64850, "Engine Coolant Control Valve Command" },
    { 64851, "Engine Average Information" },
    { 64852, "DTCs - C, Previously Active" },
    { 64853, "DTCs - C, Confirmed and Active" },
    { 64854, "DTCs - C, Pending" },
    { 64855, "DTCs - B2, Previously Active" },
    { 64856, "DTCs - B2, Confirmed and Active" },
    { 64857, "DTCs - B2, Pending" },
    { 64858, "DTCs - B1, Previously Active" },
    { 64859, "DTCs - B1, Confirmed and Active" },
    { 64860, "DTCs - B1, Pending" },
    { 64861, "DTCs - A, Previously Active" },
    { 64862, "DTCs - A, Confirmed and Active" },
    { 64863, "DTCs - A, Pending" },
    { 64864, "Harmonized B1 Failure Counts" },
    { 64865, "Harmonized Cumulative Continuous Malfunction Indicator – System" },
    { 64866, "Harmonized Global Regulation Description" },
    { 64867, "Harmonized Roadworthiness – System" },
    { 64868, "Harmonized Roadworthiness - Vehicle" },
    { 64869, "Aftertreatment 1 Fuel Control 2" },
    { 64870, "Engine Temperature 4" },
    { 64871, "Zero Net Vehicle Weight Change" },
    { 64872, "Gross Combination Vehicle Weight" },
    { 64873, "Axle Group Calibration Weights" },
    { 64874, "Axle Group Weight" },
    { 64875, "Available Axle Group Weights" },
    { 64876, "Aftertreatment 2 Air Control 2" },
    { 64877, "Aftertreatment 1 Air Control 2" },
    { 64878, "Aftertreatment 1 SCR Service Information 1" },
    { 64879, "Electronic Engine Controller 8" },
    { 64880, "Door ramp control" },
    { 64881, "Brake actuator stroke status" },
    { 64882, "Engine Spark Voltage 6" },
    { 64883, "Engine Spark Voltage 5" },
    { 64884, "Engine Spark Voltage 4" },
    { 64885, "Engine Spark Voltage 3" },
    { 64886, "Engine Spark Voltage 2" },
    { 64887, "Engine Spark Voltage 1" },
    { 64888, "Aftertreatment 2 Trip Information" },
    { 64889, "Aftertreatment 1 Trip Information" },
    { 64890, "Aftertreatment 2 Service 1" },
    { 64891, "Aftertreatment 1 Service 1" },
    { 64892, "Diesel Particulate Filter Control 1" },
    { 64893, "Reserved for FMS Telltale status" },
    { 64894, "Adaptive Front-Lighting System Status" },
    { 64895, "Engine Configuration 2" },
    { 64896, "Emission-Related Permanent Diagnostic Trouble Codes" },
    { 64897, "EGR Cooler Bypass" },
    { 64898, "All Pending DTCs" },
    { 64899, "Transfer Case Information" },
    { 64900, "Engine Fluid Level/Pressure 9" },
    { 64901, "Engine Fluid Level/Pressure 8" },
    { 64902, "Engine Fluid Level/Pressure 7" },
    { 64903, "Engine Fluid Level/Pressure 6" },
    { 64904, "Engine Fluid Level/Pressure 5" },
    { 64905, "Vehicle Direction/Speed 2" },
    { 64906, "SAE J2012 2-Byte DTC Display" },
    { 64907, "Aftertreatment 2 Gas Parameters" },
    { 64908, "Aftertreatment 1 Gas Parameters" },
    { 64909, "Utility Total AC Reactive Energy" },
    { 64910, "Generator Total AC Reactive Energy" },
    { 64911, "Generator Total AC Percent Power" },
    { 64912, "Advertised Engine Torque Curve" },
    { 64913, "AC Switching Device Status" },
    { 64914, "Engine Operating Information" },
    { 64915, "Generator Control 1" },
    { 64916, "Electronic Engine Controller 7" },
    { 64917, "Transmission Fluids 2" },
    { 64918, "Fuel Information 2 (Liquid)" },
    { 64919, "Fuel Information 3 (Liquid)" },
    { 64920, "Aftertreatment 1 Historical Information 1" },
    { 64921, "Aftertreatment 2 Historical information 1" },
    { 64922, "Electronic Brake System #2/4" },
    { 64923, "Aftertreatment 1 Diesel Exhaust Fluid Information 1" },
    { 64924, "Sensor Electrical Power #2" },
    { 64925, "Sensor Electrical Power #1" },
    { 64926, "Aftertreatment 2 Air Control 1" },
    { 64927, "Aftertreatment 1 Air Control 1" },
    { 64928, "Aftertreatment 2 Fuel Control 1" },
    { 64929, "Aftertreatment 1 Fuel Control 1" },
    { 64930, "Fuel Information 3 (Gaseous)" },
    { 64931, "Electronic Engine Controller 6" },
    { 64932, "PTO Drive Engagement" },
    { 64933, "Door Control 2" },
    { 64934, "Voltage Regulator Excitation Status" },
    { 64935, "Voltage Regulator Operating Mode" },
    { 64936, "Wireless Communications Message 2" },
    { 64937, "Wireless Communications Message 1" },
    { 64938, "Engine Fluid Level/Pressure 4" },
    { 64939, "Request For Complete Configurable Message Set (no longer used)" },
    { 64940, "Engine Fuel Information" },
    { 64941, "Request For Complete Configurable Message Set" },
    { 64942, "Fifth Wheel Smart Systems 2" },
    { 64943, "Aftertreatment 2 Intermediate Gas" },
    { 64944, "Aftertreatment 2 Outlet Gas 2" },
    { 64945, "Aftertreatment 2 Intake Gas 2" },
    { 64946, "Aftertreatment 1 Intermediate Gas" },
    { 64947, "Aftertreatment 1 Outlet Gas 2" },
    { 64948, "Aftertreatment 1 Intake Gas 2" },
    { 64949, "Emission-Related Previously MIL-On Diagnostic Trouble Codes" },
    { 64950, "SPN Support" },
    { 64951, "Expanded Freeze Frame" },
    { 64952, "Diagnostic Readiness 3" },
    { 64953, "Tire Pressure Reference Information" },
    { 64954, "Farebox Status" },
    { 64955, "Farebox Point of Sale" },
    { 64956, "Farebox Service Detail" },
    { 64957, "Signal Preemption" },
    { 64958, "Transit Route" },
    { 64959, "Transit Milepost" },
    { 64960, "Passenger Counter" },
    { 64961, "Engine Fluid Level/Pressure 3" },
    { 64962, "Electronic Engine Controller 14" },
    { 64963, "Electronic Engine Controller 15" },
    { 64964, "Electronic Brake Controller 5" },
    { 64965, "ECU Identification Information" },
    { 64966, "Cold Start Aids" },
    { 64967, "Off-Highway Engine Control Selection States" },
    { 64968, "Operator Primary Intermediate Speed Control state" },
    { 64969, "Electronic Control Module Information" },
    { 64970, "Intermediate Speed Control" },
    { 64971, "Off-Highway Engine Control Selection" },
    { 64972, "Operators External Light Controls Message" },
    { 64973, "Operator Wiper and Washer Controls Message" },
    { 64974, "Working Set Member Message (Obsolete - See PGN 65088)" },
    { 64975, "Working Set Master Message  (Obsolete - See PGN 65089)" },
    { 64976, "Intake/Exhaust Conditions 2" },
    { 64977, "FMS-standard Interface Identity/Capabilities" },
    { 64978, "ECU Performance" },
    { 64979, "Turbocharger Information 6" },
    { 64980, "Cab Message 3" },
    { 64981, "Electronic Engine Controller 5" },
    { 64982, "Basic Joystick Message 1" },
    { 64983, "Extended Joystick Message 1" },
    { 64984, "Basic Joystick Message 2" },
    { 64985, "Extended Joystick Message 2" },
    { 64986, "Basic Joystick Message 3" },
    { 64987, "Extended Joystick Message 3" },
    { 64988, "Marine Control Information" },
    { 64989, "Military Application Message #1/1" },
    { 64990, "Military Application Message #2/1" },
    { 64991, "Front Wheel Drive Status" },
    { 64992, "Ambient Conditions 2" },
    { 64993, "Cab Climate System Information 1" },
    { 64994, "Supply Pressure Demand" },
    { 64995, "Equipment Operation and Control" },
    { 64996, "Equipment Performance Data" },
    { 64997, "Maximum Vehicle Speed Limit Status" },
    { 64998, "Hydraulic Braking System" },
    { 64999, "Bus #1/Utility Sync Check Status" },
    { 65000, "Bus #1/Generator Sync Check Status" },
    { 65001, "Bus #1 Phase C  Basic AC Quantities" },
    { 65002, "Bus #1 Phase B  Basic AC Quantities" },
    { 65003, "Bus #1 Phase A  Basic AC Quantities" },
    { 65004, "Bus #1 Average Basic AC Quantities" },
    { 65005, "Utility Total AC Energy" },
    { 65006, "Utility Phase C AC Reactive Power" },
    { 65007, "Utility Phase C AC Power" },
    { 65008, "Utility Phase C AC Basic Quantities" },
    { 65009, "Utility Phase B AC Reactive Power" },
    { 65010, "Utility Phase B AC Power" },
    { 65011, "Utility Phase B AC Basic Quantities" },
    { 65012, "Utility Phase A AC Reactive Power" },
    { 65013, "Utility Phase A AC Power" },
    { 65014, "Utility Phase A Basic AC Quantities" },
    { 65015, "Utility Total AC Reactive Power" },
    { 65016, "Utility Total AC Power" },
    { 65017, "Utility Average Basic AC Quantities" },
    { 65018, "Generator Total AC Energy" },
    { 65019, "Generator Phase C AC Reactive Power" },
    { 65020, "Generator Phase C AC Power" },
    { 65021, "Generator Phase C Basic AC Quantities" },
    { 65022, "Generator Phase B AC Reactive Power" },
    { 65023, "Generator Phase B AC Power" },
    { 65024, "Generator Phase B Basic AC Quantities" },
    { 65025, "Generator Phase A AC Reactive Power" },
    { 65026, "Generator Phase A AC Power" },
    { 65027, "Generator Phase A Basic AC Quantities" },
    { 65028, "Generator Total AC Reactive Power" },
    { 65029, "Generator Total AC Power" },
    { 65030, "Generator Average Basic AC Quantities" },
    { 65031, "Exhaust Temperature" },
    { 65032, "Required Tractor Facilities message" },
    { 65033, "Tractor Facilities response message" },
    { 65034, "Tractor control command tractor response" },
    { 65035, "Tractor control mode command" },
    { 65036, "Working Set Member " },
    { 65037, "Working Set Master " },
    { 65038, "Response for Repetition Rate" },
    { 65039, "Language command" },
    { 65040, "Auxiliary valve 0 estimated flow" },
    { 65041, "Auxiliary valve 1 estimated flow" },
    { 65042, "Auxiliary valve 2 estimated flow" },
    { 65043, "Auxiliary valve 3 estimated flow" },
    { 65044, "Auxiliary valve 4 estimated flow" },
    { 65045, "Auxiliary valve 5 estimated flow" },
    { 65046, "Auxiliary valve 6 estimated flow" },
    { 65047, "Auxiliary valve 7 estimated flow" },
    { 65048, "Auxiliary valve 8 estimated flow" },
    { 65049, "Auxiliary valve 9 estimated flow" },
    { 65050, "Auxiliary valve 10 estimated flow" },
    { 65051, "Auxiliary valve 11 estimated flow" },
    { 65052, "Auxiliary valve 12 estimated flow" },
    { 65053, "Auxiliary valve 13 estimated flow" },
    { 65054, "Auxiliary valve 14 estimated flow" },
    { 65055, "Auxiliary valve 15 estimated flow" },
    { 65056, "Auxiliary valve 0 measured flow" },
    { 65057, "Auxiliary valve 1 measured flow" },
    { 65058, "Auxiliary valve 2 measured flow" },
    { 65059, "Auxiliary valve 3 measured flow" },
    { 65060, "Auxiliary valve 4 measured flow" },
    { 65061, "Auxiliary valve 5 measured flow" },
    { 65062, "Auxiliary valve 6 measured flow" },
    { 65063, "Auxiliary valve 7 measured flow" },
    { 65064, "Auxiliary valve 8 measured flow" },
    { 65065, "Auxiliary valve 9 measured flow" },
    { 65066, "Auxiliary valve 10 measured flow" },
    { 65067, "Auxiliary valve 11 measured flow" },
    { 65068, "Auxiliary valve 12 measured flow" },
    { 65069, "Auxiliary valve 13 measured flow" },
    { 65070, "Auxiliary valve 14 measured flow" },
    { 65071, "Auxiliary valve 15 measured flow" },
    { 65072, "Auxiliary valve 0 command" },
    { 65073, "Auxiliary valve 1 command" },
    { 65074, "Auxiliary valve 2 command" },
    { 65075, "Auxiliary valve 3 command" },
    { 65076, "Auxiliary valve 4 command" },
    { 65077, "Auxiliary valve 5 command" },
    { 65078, "Auxiliary valve 6 command" },
    { 65079, "Auxiliary valve 7 command" },
    { 65080, "Auxiliary valve 8 command" },
    { 65081, "Auxiliary valve 9 command" },
    { 65082, "Auxiliary valve 10 command" },
    { 65083, "Auxiliary valve 11 command" },
    { 65084, "Auxiliary valve 12 command" },
    { 65085, "Auxiliary valve 13 command" },
    { 65086, "Auxiliary valve 14 command" },
    { 65087, "Auxiliary valve 15 command" },
    { 65088, "Lighting Data" },
    { 65089, "Lighting command" },
    { 65090, "Hitch and PTO commands" },
    { 65091, "Primary or Rear Power Take off Output Shaft" },
    { 65092, "Secondary or Front Power Take off Output Shaft" },
    { 65093, "Primary or Rear Hitch Status" },
    { 65094, "Secondary or Front Hitch Status" },
    { 65095, "Maintain Power" },
    { 65096, "Wheel-based Speed and Distance" },
    { 65097, "Ground-based Speed and Distance" },
    { 65098, "Electronic Transmission Controller 7" },
    { 65099, "Transmission Configuration 2" },
    { 65100, "Military Lighting Command" },
    { 65101, "Total Averaged Information" },
    { 65102, "Door Control 1" },
    { 65103, "Vehicle Dynamic Stability Control 1" },
    { 65104, "Battery Temperature" },
    { 65105, "Adaptive Cruise Control, Operator Input" },
    { 65106, "Vehicle Electrical Power 3" },
    { 65107, "Retarder Continuous Torque & Speed Limit" },
    { 65108, "Engine Continuous Torque & Speed Limit" },
    { 65109, "Gaseous Fuel Properties" },
    { 65110, "Aftertreatment 1 Diesel Exhaust Fluid Tank 1 Information 1" },
    { 65111, "Air Suspension Control 5" },
    { 65112, "Air Suspension Control 4" },
    { 65113, "Air Suspension Control 3" },
    { 65114, "Air Suspension Control 1" },
    { 65115, "Forward Lane Image 2" },
    { 65116, "Running Gear Equipment #2/2" },
    { 65117, "General Purpose Message #1/2" },
    { 65118, "Running Gear Equipment #2/3" },
    { 65119, "General Purpose Message #1/3" },
    { 65120, "General Purpose Message #2/3" },
    { 65121, "General Purpose Message #1/4" },
    { 65122, "General Purpose Message #2/4" },
    { 65123, "General Purpose Message #1/5" },
    { 65124, "General Purpose Message #2/5" },
    { 65125, "General Purpose Message #1/6" },
    { 65126, "Battery Main Switch Information" },
    { 65127, "Climate Control Configuration" },
    { 65128, "Vehicle Fluids" },
    { 65129, "Engine Temperature 3" },
    { 65130, "Engine Fuel/Lube Systems" },
    { 65131, "Driver's Identification" },
    { 65132, "Tachograph" },
    { 65133, "Heater Information" },
    { 65134, "High Resolution Wheel Speed" },
    { 65135, "Adaptive Cruise Control 1" },
    { 65136, "Combination Vehicle Weight" },
    { 65137, "Laser Tracer Position" },
    { 65138, "Laser Leveling System Blade Control" },
    { 65139, "Laser Receiver Mast Position" },
    { 65140, "Modify Leveling System Control Set Point" },
    { 65141, "Laser Leveling System Vertical Deviation" },
    { 65142, "Laser Leveling System Vertical Position Display Data" },
    { 65143, "Auxiliary Pressures" },
    { 65144, "Tire Pressure Control Unit Mode and Status" },
    { 65145, "Tire Pressure Control Unit Target Pressures" },
    { 65146, "Tire Pressure Control Unit Current Pressures" },
    { 65147, "Combustion Time 1" },
    { 65148, "Combustion Time 2" },
    { 65149, "Combustion Time 3" },
    { 65150, "Combustion Time 4" },
    { 65151, "Combustion Time 5" },
    { 65152, "Combustion Time 6" },
    { 65153, "Fuel Information 2 (Gaseous)" },
    { 65154, "Ignition Timing 1" },
    { 65155, "Ignition Timing 2" },
    { 65156, "Ignition Timing 3" },
    { 65157, "Ignition Timing 4" },
    { 65158, "Ignition Timing 5" },
    { 65159, "Ignition Timing 6" },
    { 65160, "Ignition Transformer Secondary Output 1" },
    { 65161, "Ignition Transformer Secondary Output 2" },
    { 65162, "Ignition Transformer Secondary Output 3" },
    { 65163, "Gaseous Fuel Pressure 1" },
    { 65164, "Auxiliary Analog Information" },
    { 65165, "Vehicle Electrical Power 2" },
    { 65166, "Service 2" },
    { 65167, "Supply Pressure 2" },
    { 65168, "Engine Torque History" },
    { 65169, "Fuel Leakage" },
    { 65170, "Engine Information 1" },
    { 65171, "Engine Electrical System/Module Information" },
    { 65172, "Engine Auxiliary Coolant" },
    { 65173, "Rebuild Information" },
    { 65174, "Turbocharger Wastegate" },
    { 65175, "Turbocharger Information 5" },
    { 65176, "Turbocharger Information 4" },
    { 65177, "Turbocharger Information 3" },
    { 65178, "Turbocharger Information 2" },
    { 65179, "Turbocharger Information 1" },
    { 65180, "Main Bearing Temperature 3" },
    { 65181, "Main Bearing Temperature 2" },
    { 65182, "Main Bearing Temperature 1" },
    { 65183, "Exhaust Port Temperature 5" },
    { 65184, "Exhaust Port Temperature 4" },
    { 65185, "Exhaust Port Temperature 3" },
    { 65186, "Exhaust Port Temperature 2" },
    { 65187, "Exhaust Port Temperature 1" },
    { 65188, "Engine Temperature 2" },
    { 65189, "Intake Manifold Information 2" },
    { 65190, "Intake Manifold Information 1" },
    { 65191, "Alternator Temperature 1" },
    { 65192, "Articulation Control" },
    { 65193, "Exhaust Oxygen 1" },
    { 65194, "Alternate Fuel 2" },
    { 65195, "Electronic Transmission Controller 6" },
    { 65196, "Wheel Brake Lining Remaining Information 1" },
    { 65197, "Wheel Application Pressure High Range Information" },
    { 65198, "Air Supply Pressure" },
    { 65199, "Fuel Consumption (Gaseous)" },
    { 65200, "Trip Time Information 2" },
    { 65201, "ECU History" },
    { 65202, "Fuel Information 1 (Gaseous)" },
    { 65203, "Fuel Information 1 (Liquid)" },
    { 65204, "Trip Time Information 1" },
    { 65205, "Trip Shutdown Information" },
    { 65206, "Trip Vehicle Speed/Cruise Distance Information" },
    { 65207, "Engine Speed/Load Factor Information 1" },
    { 65208, "Trip Fuel Information (Gaseous)" },
    { 65209, "Trip Fuel Information (Liquid)" },
    { 65210, "Trip Distance Information" },
    { 65211, "Trip Fan Information" },
    { 65212, "Compression/Service Brake Information" },
    { 65213, "Fan Drive #1" },
    { 65214, "Electronic Engine Controller 4" },
    { 65215, "Wheel Speed Information" },
    { 65216, "Service Information" },
    { 65217, "High Resolution Vehicle Distance" },
    { 65218, "Electronic Retarder Controller 2" },
    { 65219, "Electronic Transmission Controller 5" },
    { 65220, "Electronic Brake System #2/2" },
    { 65221, "Electronic Transmission Controller 4" },
    { 65222, "Electronic Brake System #2/3" },
    { 65223, "Electronic Transmission Controller 3" },
    { 65224, "General Purpose Message #2/2" },
    { 65225, "Electronic Brake System #1/2" },
    { 65226, "Active Diagnostic Trouble Codes" },
    { 65227, "Previously Active Diagnostic Trouble Codes" },
    { 65228, "Diagnostic Data Clear/Reset for Previously Active DTCs" },
    { 65229, "Freeze Frame Parameters" },
    { 65230, "Diagnostic Readiness 1" },
    { 65231, "Emission-Related Pending Diagnostic Trouble Codes" },
    { 65232, "Test Results for Non-continuously Monitored Systems" },
    { 65233, "Oxygen Sensor Test Results" },
    { 65234, "Non-Continuously Monitored Systems Test Identifiers Support" },
    { 65235, "Diagnostic Data Clear/Reset for Active DTCs" },
    { 65236, "Emission-Related MIL-On Diagnostic Trouble Codes" },
    { 65237, "Alternator Information" },
    { 65238, "Hybrid or EV System Inputs 1" },
    { 65240, "Commanded Address" },
    { 65241, "Auxiliary Input/Output Status 1" },
    { 65242, "Software Identification" },
    { 65243, "Engine Fluid Level/Pressure 2" },
    { 65244, "Idle Operation" },
    { 65245, "Turbocharger" },
    { 65246, "Engine Air Start Pressure" },
    { 65247, "Electronic Engine Controller 3" },
    { 65248, "Vehicle Distance" },
    { 65249, "Retarder Configuration" },
    { 65250, "Transmission Configuration" },
    { 65251, "Engine Configuration 1" },
    { 65252, "Shutdown" },
    { 65253, "Engine Hours, Revolutions" },
    { 65254, "Time/Date" },
    { 65255, "Vehicle Hours" },
    { 65256, "Vehicle Direction/Speed" },
    { 65257, "Fuel Consumption (Liquid) 1" },
    { 65258, "Vehicle Weight" },
    { 65259, "Component Identification" },
    { 65260, "Vehicle Identification" },
    { 65261, "Cruise Control/Vehicle Speed Setup" },
    { 65262, "Engine Temperature 1" },
    { 65263, "Engine Fluid Level/Pressure 1" },
    { 65264, "Power Takeoff Information 1" },
    { 65265, "Cruise Control/Vehicle Speed 1" },
    { 65266, "Fuel Economy (Liquid)" },
    { 65267, "Vehicle Position 1" },
    { 65268, "Tire Condition Message 1" },
    { 65269, "Ambient Conditions" },
    { 65270, "Intake/Exhaust Conditions 1" },
    { 65271, "Vehicle Electrical Power 1" },
    { 65272, "Transmission Fluids 1" },
    { 65273, "Axle Information" },
    { 65274, "Brakes 1" },
    { 65275, "Retarder fluids" },
    { 65276, "Dash Display 1" },
    { 65277, "Alternate Fuel 1" },
    { 65278, "Auxiliary Water Pump Pressure" },
    { 65279, "Operator indicators" },
    { 126208, "NMEA - Request/Command/Acknowledge group function" },
    { 126464, "PGN List - Transmit/Receive PGN's group function" },
    { 126720, "Proprietary A2" },
    { 126983, "Alert" },
    { 126984, "Alert Response" },
    { 126985, "Alert Text" },
    { 126986, "Alert Configuration" },
    { 126987, "Alert Threshold" },
    { 126988, "Alert Value" },
    { 126992, "System Time" },
    { 126993, "Heartbeat" },
    { 126996, "Product Information" },
    { 126998, "Configuration Information" },
    { 127001, "Cyclic Alert List - IEC 61924-2" },
    { 127002, "Responsibility Transfer Function - IEC 61924-2" },
    { 127233, "Man Overboard Notification (MOB)" },
    { 127237, "Heading/Track Control" },
    { 127245, "Rudder" },
    { 127250, "Vessel Heading" },
    { 127251, "Rate of Turn" },
    { 127252, "Heave" },
    { 127257, "Attitude" },
    { 127258, "Magnetic Variation" },
    { 127488, "Engine Parameters, Rapid Update" },
    { 127489, "Engine Parameters, Dynamic" },
    { 127490, "Electric Drive Status, Dynamic" },
    { 127491, "Electric Energy Storage Status, Dynamic" },
    { 127493, "Transmission Parameters, Dynamic" },
    { 127494, "Electric Drive Information" },
    { 127495, "Electric Energy Storage Information" },
    { 127496, "Trip Parameters, Vessel" },
    { 127497, "Trip Parameters, Small Craft" },
    { 127498, "Engine Parameters, Static" },
    { 127500, "Load Controller Connection State / Control" },
    { 127501, "Binary Switch Bank Status" },
    { 127502, "Switch Bank Control" },
    { 127503, "AC Input Status" },
    { 127504, "AC Output Status" },
    { 127505, "Fluid Level" },
    { 127506, "DC Detailed Status" },
    { 127507, "Charger Status" },
    { 127508, "Battery Status" },
    { 127509, "Inverter Status" },
    { 127510, "Charger Configuration Status" },
    { 127511, "Inverter Configuration Status" },
    { 127512, "AGS Configuration Status" },
    { 127513, "Battery Configuration Status" },
    { 127514, "AGS Status" },
    { 127744, "AC Power / Current - Phase A" },
    { 127745, "AC Power / Current - Phase B" },
    { 127746, "AC Power / Current - Phase C" },
    { 127747, "AC Voltage / Frequency - Phase A" },
    { 127748, "AC Voltage / Frequency - Phase B" },
    { 127749, "AC Voltage / Frequency-Phase C" },
    { 127750, "Converter (Inverter/Charger) Status" },
    { 127751, "DC Voltage / Current" },
    { 128000, "Nautical Leeway Angle" },
    { 128001, "Vessel Acceleration" },
    { 128002, "Electric Drive Status, Rapid Update" },
    { 128003, "Electric Energy Storage Status, Rapid Update" },
    { 128006, "Thruster Control Status" },
    { 128007, "Thruster Information" },
    { 128008, "Thruster Motor Status" },
    { 128259, "Speed" },
    { 128267, "Water Depth" },
    { 128275, "Distance Log" },
    { 128520, "Tracked Target Data" },
    { 128538, "Elevator Car Status" },
    { 128768, "Elevator Motor Control" },
    { 128769, "Elevator Deck Push Button" },
    { 128776, "Windlass Control Status" },
    { 128777, "Anchor Windlass Operating Status" },
    { 128778, "Anchor Windlass Monitoring Status" },
    { 128780, "Linear Actuator Control/Status" },
    { 129025, "Position, Rapid Update" },
    { 129026, "COG & SOG, Rapid Update" },
    { 129027, "Position Delta, High Precision Rapid Update" },
    { 129028, "Altitude Delta, High Precision Rapid Update" },
    { 129029, "GNSS Position Data" },
    { 129033, "Time & Date" },
    { 129038, "AIS Class A Position Report" },
    { 129039, "AIS Class B Position Report" },
    { 129040, "AIS Class B Extended Position Report" },
    { 129041, "AIS Aids to Navigation (AtoN) Report" },
    { 129044, "Datum" },
    { 129045, "User Datum Settings" },
    { 129283, "Cross Track Error" },
    { 129284, "Navigation Data" },
    { 129285, "Navigation - Route/WP information" },
    { 129291, "Set & Drift, Rapid Update" },
    { 129301, "Time to/from Mark" },
    { 129302, "Bearing and Distance between two Marks" },
    { 129538, "GNSS Control Status" },
    { 129539, "GNSS DOPs" },
    { 129540, "GNSS Sats in View" },
    { 129541, "GPS Almanac Data" },
    { 129542, "GNSS Pseudorange Noise Statistics" },
    { 129545, "GNSS RAIM Output" },
    { 129546, "GNSS RAIM Settings" },
    { 129547, "GNSS Pseudorange Error Statistics" },
    { 129549, "DGNSS Corrections" },
    { 129550, "GNSS Differential Correction Receiver Interface" },
    { 129551, "GNSS Differential Correction Receiver Signal" },
    { 129556, "GLONASS Almanac Data" },
    { 129792, "AIS DGNSS Broadcast Binary Message" },
    { 129793, "AIS UTC and Date Report" },
    { 129794, "AIS Class A Static and Voyage Related Data" },
    { 129795, "AIS Addressed Binary Message" },
    { 129796, "AIS Acknowledge" },
    { 129797, "AIS Binary Broadcast Message" },
    { 129798, "AIS SAR Aircraft Position Report" },
    { 129799, "Radio Frequency/Mode/Power" },
    { 129800, "AIS UTC/Date Inquiry" },
    { 129801, "AIS Addressed Safety Related Message" },
    { 129802, "AIS Safety Related Broadcast Message" },
    { 129803, "AIS Interrogation" },
    { 129804, "AIS Assignment Mode Command" },
    { 129805, "AIS Data Link Management Message" },
    { 129806, "AIS Channel Management" },
    { 129807, "AIS Class B Group Assignment" },
    { 129808, "DSC Call Information" },
    { 129809, "AIS Class B 'CS' Static Data Report, Part A" },
    { 129810, "AIS Class B 'CS' Static Data Report, Part B" },
    { 129811, "AIS Single Slot Binary Message - DEPRECATED" },
    { 129812, "AIS Multi Slot Binary Message - DEPRECATED" },
    { 129813, "AIS Long-Range Broadcast Message" },
    { 129814, "AIS Single Slot Binary Message" },
    { 129815, "AIS Multi Slot Binary Message" },
    { 129816, "AIS Acknowledge" },
    { 130052, "Loran-C TD Data" },
    { 130053, "Loran-C Range Data" },
    { 130054, "Loran-C Signal Data" },
    { 130060, "Label" },
    { 130061, "Channel Source Configuration" },
    { 130064, "Route and WP Service - Database List" },
    { 130065, "Route and WP Service - Route List" },
    { 130066, "Route and WP Service - Route/WP-List Attributes" },
    { 130067, "Route and WP Service - Route - WP Name & Position" },
    { 130068, "Route and WP Service - Route - WP Name" },
    { 130069, "Route and WP Service - XTE Limit & Navigation Method" },
    { 130070, "Route and WP Service - WP Comment" },
    { 130071, "Route and WP Service - Route Comment" },
    { 130072, "Route and WP Service - Database Comment" },
    { 130073, "Route and WP Service - Radius of Turn" },
    { 130074, "Route and WP Service - WP List - WP Name & Position" },
    { 130306, "Wind Data" },
    { 130310, "Environmental Parameters" },
    { 130311, "Environmental Parameters" },
    { 130312, "Temperature" },
    { 130313, "Humidity" },
    { 130314, "Actual Pressure" },
    { 130315, "Set Pressure" },
    { 130316, "Temperature- Extended Range" },
    { 130320, "Tide Station Data" },
    { 130321, "Salinity Station Data" },
    { 130322, "Current Station Data" },
    { 130323, "Meteorological Station Data" },
    { 130324, "Moored Buoy Station Data" },
    { 130330, "Lighting System Settings" },
    { 130560, "Payload Mass" },
    { 130561, "Lighting Zone" },
    { 130562, "Lighting Scene" },
    { 130563, "Lighting Device" },
    { 130564, "Lighting Device Enumeration" },
    { 130565, "Lighting Color Sequence" },
    { 130566, "Lighting Program" },
    { 130567, "Watermaker Input Setting and Status" },
    { 130568, "Entertainment - Diagnostic Status" },
    { 130569, "Entertainment - Current File and Status" },
    { 130570, "Entertainment - Library Data File" },
    { 130571, "Entertainment - Library Data Group" },
    { 130572, "Entertainment - Library Data Search" },
    { 130573, "Entertainment - Supported Source Data" },
    { 130574, "Entertainment - Supported Zone Data" },
    { 130575, "Entertainment - Parental Control Status" },
    { 130576, "Small Craft Status" },
    { 130577, "Direction Data" },
    { 130578, "Vessel Speed Components" },
    { 130579, "Entertainment - System Configuration" },
    { 130580, "Entertainment - System Configuration Status" },
    { 130581, "Entertainment - Zone Configuration Status - DEPRECATED" },
    { 130582, "Entertainment - Zone Volume" },
    { 130583, "Entertainment - Available Audio EQ Presets" },
    { 130584, "Entertainment - Bluetooth Devices" },
    { 130585, "Entertainment - Bluetooth Source Status" },
    { 130586, "Entertainment - Zone Configuration Status" },
    { 0, NULL }
};
static value_string_ext isobus_pgn_names_ext = VALUE_STRING_EXT_INIT(_isobus_pgn_names);

#endif /* __PACKET_ISOBUS_PARAMETERS_H__ */