// auto-generated by Georg Sauthoff's eti2wireshark.py

/* packet-eti.c
 * Routines for XTI dissection
 * Copyright 2021, Georg Sauthoff <mail@gms.tf>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/*
 * The Enhanced Cash Trading Interface 10.0 (XTI) is an electronic trading protocol
 * that is used by a few exchanges (Eurex, Xetra, ...).
 *
 * It's a Length-Tag based protocol consisting of mostly fix sized
 * request/response messages.
 *
 * Links:
 * https://en.wikipedia.org/wiki/List_of_electronic_trading_protocols#Europe
 * https://github.com/gsauthof/python-eti#protocol-descriptions
 * https://github.com/gsauthof/python-eti#protocol-introduction
 *
 */

#include <config.h>


#include <epan/packet.h>   // Should be first Wireshark include (other than config.h)
#include "packet-tcp.h"    // tcp_dissect_pdus()
#include <epan/expert.h>   // expert info

#include <inttypes.h>
#include <stdio.h>         // snprintf()


/* Prototypes */
/* (Required to prevent [-Wmissing-prototypes] warnings */
void proto_reg_handoff_xti(void);
void proto_register_xti(void);

static dissector_handle_t xti_handle;

static int proto_xti;
static expert_field ei_xti_counter_overflow;
static expert_field ei_xti_invalid_template;
static expert_field ei_xti_invalid_length;
static expert_field ei_xti_unaligned;
static expert_field ei_xti_missing;
static expert_field ei_xti_overused;

static int hf_xti[324];
static int hf_xti_dscp_exec_summary;
static int hf_xti_dscp_improved;
static int hf_xti_dscp_widened;
enum Field_Handle_Index {
      ACCOUNT_FH_IDX
    , ACCRUEDINTERESAMT_FH_IDX
    , AFFECTEDORDERID_FH_IDX
    , AFFECTEDORDERREQUESTID_FH_IDX
    , AFFECTEDORIGCLORDID_FH_IDX
    , ALLOCID_FH_IDX
    , ALLOCMETHOD_FH_IDX
    , ALLOCQTY_FH_IDX
    , APPLBEGMSGID_FH_IDX
    , APPLBEGSEQNUM_FH_IDX
    , APPLENDMSGID_FH_IDX
    , APPLENDSEQNUM_FH_IDX
    , APPLID_FH_IDX
    , APPLIDSTATUS_FH_IDX
    , APPLMSGID_FH_IDX
    , APPLRESENDFLAG_FH_IDX
    , APPLSEQINDICATOR_FH_IDX
    , APPLSEQNUM_FH_IDX
    , APPLSEQSTATUS_FH_IDX
    , APPLSEQTRADEDATE_FH_IDX
    , APPLSUBID_FH_IDX
    , APPLTOTALMESSAGECOUNT_FH_IDX
    , APPLUSAGEORDERS_FH_IDX
    , APPLUSAGEQUOTES_FH_IDX
    , APPLICATIONSYSTEMNAME_FH_IDX
    , APPLICATIONSYSTEMVENDOR_FH_IDX
    , APPLICATIONSYSTEMVERSION_FH_IDX
    , AUTOAPPROVALRULEID_FH_IDX
    , BESTBIDPX_FH_IDX
    , BESTBIDSIZE_FH_IDX
    , BESTOFFERPX_FH_IDX
    , BESTOFFERSIZE_FH_IDX
    , BIDPX_FH_IDX
    , BIDSIZE_FH_IDX
    , BODYLEN_FH_IDX
    , CLORDID_FH_IDX
    , CLEARINGINSTRUCTION_FH_IDX
    , COUPONRATE_FH_IDX
    , CROSSEDINDICATOR_FH_IDX
    , CUMQTY_FH_IDX
    , CURRENCY_FH_IDX
    , CXLQTY_FH_IDX
    , CXLSIZE_FH_IDX
    , DEFAULTCSTMAPPLVERID_FH_IDX
    , DEFAULTCSTMAPPLVERSUBID_FH_IDX
    , DELETEREASON_FH_IDX
    , DELIVERYTYPE_FH_IDX
    , DISPLAYHIGHQTY_FH_IDX
    , DISPLAYLOWQTY_FH_IDX
    , DISPLAYQTY_FH_IDX
    , ENRICHMENTRULEID_FH_IDX
    , EVENTDATE_FH_IDX
    , EVENTPX_FH_IDX
    , EVENTTYPE_FH_IDX
    , EXECID_FH_IDX
    , EXECINST_FH_IDX
    , EXECRESTATEMENTREASON_FH_IDX
    , EXECTYPE_FH_IDX
    , EXECUTINGTRADER_FH_IDX
    , EXECUTINGTRADERQUALIFIER_FH_IDX
    , EXPIREDATE_FH_IDX
    , EXPIRETIME_FH_IDX
    , FIXCLORDID_FH_IDX
    , FIXENGINENAME_FH_IDX
    , FIXENGINEVENDOR_FH_IDX
    , FIXENGINEVERSION_FH_IDX
    , FILLEXECID_FH_IDX
    , FILLLIQUIDITYIND_FH_IDX
    , FILLMATCHID_FH_IDX
    , FILLPX_FH_IDX
    , FILLQTY_FH_IDX
    , FIRMNEGOTIATIONID_FH_IDX
    , FIRMTRADEID_FH_IDX
    , FREETEXT1_FH_IDX
    , FREETEXT2_FH_IDX
    , FREETEXT4_FH_IDX
    , FREETEXT5_FH_IDX
    , HEADLINE_FH_IDX
    , HEARTBTINT_FH_IDX
    , IMBALANCEQTY_FH_IDX
    , INDIVIDUALALLOCID_FH_IDX
    , LASTCOUPONDEVIATIONINDICATOR_FH_IDX
    , LASTENTITYPROCESSED_FH_IDX
    , LASTFRAGMENT_FH_IDX
    , LASTMKT_FH_IDX
    , LASTPX_FH_IDX
    , LASTQTY_FH_IDX
    , LEAVESQTY_FH_IDX
    , LISTUPDATEACTION_FH_IDX
    , MDBOOKTYPE_FH_IDX
    , MDSUBBOOKTYPE_FH_IDX
    , MARKETID_FH_IDX
    , MARKETSEGMENTID_FH_IDX
    , MASSACTIONREASON_FH_IDX
    , MASSACTIONREPORTID_FH_IDX
    , MASSACTIONTYPE_FH_IDX
    , MATCHDATE_FH_IDX
    , MATCHINSTCROSSID_FH_IDX
    , MATCHSUBTYPE_FH_IDX
    , MATCHTYPE_FH_IDX
    , MATCHINGENGINESTATUS_FH_IDX
    , MATCHINGENGINETRADEDATE_FH_IDX
    , MESSAGEEVENTSOURCE_FH_IDX
    , MSGSEQNUM_FH_IDX
    , NEGOTIATIONID_FH_IDX
    , NEGOTIATIONSTARTTIME_FH_IDX
    , NETWORKMSGID_FH_IDX
    , NOAFFECTEDORDERREQUESTS_FH_IDX
    , NOAFFECTEDORDERS_FH_IDX
    , NOENRICHMENTRULES_FH_IDX
    , NOEVENTS_FH_IDX
    , NOFILLS_FH_IDX
    , NONOTAFFECTEDORDERS_FH_IDX
    , NONOTAFFECTEDSECURITIES_FH_IDX
    , NOORDERBOOKITEMS_FH_IDX
    , NOORDEREVENTS_FH_IDX
    , NOPARTYDETAILS_FH_IDX
    , NOQUOTEENTRIES_FH_IDX
    , NOQUOTEEVENTS_FH_IDX
    , NOQUOTESIDEENTRIES_FH_IDX
    , NOSESSIONS_FH_IDX
    , NOSIDEALLOCS_FH_IDX
    , NOTARGETPARTYIDS_FH_IDX
    , NOTAFFORIGCLORDID_FH_IDX
    , NOTAFFECTEDORDERID_FH_IDX
    , NOTAFFECTEDSECURITYID_FH_IDX
    , NOTIFICATIONIN_FH_IDX
    , NUMDAYSINTEREST_FH_IDX
    , NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX
    , NUMBEROFRESPONDENTS_FH_IDX
    , OFFERPX_FH_IDX
    , OFFERSIZE_FH_IDX
    , ORDSTATUS_FH_IDX
    , ORDTYPE_FH_IDX
    , ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX
    , ORDERCATEGORY_FH_IDX
    , ORDEREVENTMATCHID_FH_IDX
    , ORDEREVENTPX_FH_IDX
    , ORDEREVENTQTY_FH_IDX
    , ORDEREVENTREASON_FH_IDX
    , ORDEREVENTTYPE_FH_IDX
    , ORDERID_FH_IDX
    , ORDERIDSFX_FH_IDX
    , ORDERORIGINATION_FH_IDX
    , ORDERQTY_FH_IDX
    , ORDERROUTINGINDICATOR_FH_IDX
    , ORIGCLORDID_FH_IDX
    , ORIGTIME_FH_IDX
    , ORIGTRADEID_FH_IDX
    , OWNERSHIPINDICATOR_FH_IDX
    , PACKAGEID_FH_IDX
    , PARTITIONID_FH_IDX
    , PARTYACTIONTYPE_FH_IDX
    , PARTYDETAILDESKID_FH_IDX
    , PARTYDETAILEXECUTINGTRADER_FH_IDX
    , PARTYDETAILIDEXECUTINGTRADER_FH_IDX
    , PARTYDETAILIDEXECUTINGUNIT_FH_IDX
    , PARTYDETAILROLEQUALIFIER_FH_IDX
    , PARTYDETAILSTATUS_FH_IDX
    , PARTYENTERINGFIRM_FH_IDX
    , PARTYENTERINGTRADER_FH_IDX
    , PARTYEXECUTINGFIRM_FH_IDX
    , PARTYEXECUTINGTRADER_FH_IDX
    , PARTYIDCLIENTID_FH_IDX
    , PARTYIDENTERINGFIRM_FH_IDX
    , PARTYIDENTERINGTRADER_FH_IDX
    , PARTYIDEXECUTINGTRADER_FH_IDX
    , PARTYIDEXECUTINGUNIT_FH_IDX
    , PARTYIDSESSIONID_FH_IDX
    , PARTYIDSPECIALISTTRADER_FH_IDX
    , PARTYIDINVESTMENTDECISIONMAKER_FH_IDX
    , PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX
    , PARTYSPECIALISTFIRM_FH_IDX
    , PARTYSPECIALISTTRADER_FH_IDX
    , PASSWORD_FH_IDX
    , PEGOFFSETVALUEABS_FH_IDX
    , PEGOFFSETVALUEPCT_FH_IDX
    , POTENTIALEXECVOLUME_FH_IDX
    , PRICE_FH_IDX
    , PRICEVALIDITYCHECKTYPE_FH_IDX
    , QUOTECANCELTYPE_FH_IDX
    , QUOTEENTRYREJECTREASON_FH_IDX
    , QUOTEENTRYSTATUS_FH_IDX
    , QUOTEEVENTEXECID_FH_IDX
    , QUOTEEVENTLIQUIDITYIND_FH_IDX
    , QUOTEEVENTMATCHID_FH_IDX
    , QUOTEEVENTPX_FH_IDX
    , QUOTEEVENTQTY_FH_IDX
    , QUOTEEVENTREASON_FH_IDX
    , QUOTEEVENTSIDE_FH_IDX
    , QUOTEEVENTTYPE_FH_IDX
    , QUOTEID_FH_IDX
    , QUOTEMSGID_FH_IDX
    , QUOTEREQID_FH_IDX
    , QUOTEREQUESTREJECTREASON_FH_IDX
    , QUOTERESPONSEID_FH_IDX
    , QUOTESIZETYPE_FH_IDX
    , QUOTESTATUS_FH_IDX
    , QUOTETYPE_FH_IDX
    , QUOTINGSTATUS_FH_IDX
    , RFQPUBLISHINDICATOR_FH_IDX
    , RFQREQUESTERDISCLOSUREINSTRUCTION_FH_IDX
    , REFAPPLID_FH_IDX
    , REFAPPLLASTMSGID_FH_IDX
    , REFAPPLLASTSEQNUM_FH_IDX
    , REFAPPLSUBID_FH_IDX
    , REFINANCINGELIGIBILITYINDICATOR_FH_IDX
    , REGULATORYTRADEID_FH_IDX
    , REQUESTTIME_FH_IDX
    , REQUESTINGPARTYCLEARINGFIRM_FH_IDX
    , REQUESTINGPARTYENTERINGFIRM_FH_IDX
    , REQUESTINGPARTYIDENTERINGFIRM_FH_IDX
    , REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX
    , REQUESTINGPARTYIDEXECUTINGTRADER_FH_IDX
    , RESPONDENTTYPE_FH_IDX
    , RESPONSEIN_FH_IDX
    , ROOTPARTYCLEARINGFIRM_FH_IDX
    , ROOTPARTYCONTRAFIRM_FH_IDX
    , ROOTPARTYCONTRAFIRMKVNUMBER_FH_IDX
    , ROOTPARTYCONTRASETTLEMENTACCOUNT_FH_IDX
    , ROOTPARTYCONTRASETTLEMENTFIRM_FH_IDX
    , ROOTPARTYCONTRASETTLEMENTLOCATION_FH_IDX
    , ROOTPARTYENTERINGTRADER_FH_IDX
    , ROOTPARTYEXECUTINGFIRM_FH_IDX
    , ROOTPARTYEXECUTINGFIRMKVNUMBER_FH_IDX
    , ROOTPARTYEXECUTINGTRADER_FH_IDX
    , ROOTPARTYIDCLEARINGUNIT_FH_IDX
    , ROOTPARTYIDCLIENTID_FH_IDX
    , ROOTPARTYIDCONTRASETTLEMENTUNIT_FH_IDX
    , ROOTPARTYIDCONTRAUNIT_FH_IDX
    , ROOTPARTYIDEXECUTINGTRADER_FH_IDX
    , ROOTPARTYIDEXECUTINGUNIT_FH_IDX
    , ROOTPARTYIDEXECUTIONVENUE_FH_IDX
    , ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX
    , ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX
    , ROOTPARTYIDSESSIONID_FH_IDX
    , ROOTPARTYIDSETTLEMENTUNIT_FH_IDX
    , ROOTPARTYSETTLEMENTACCOUNT_FH_IDX
    , ROOTPARTYSETTLEMENTFIRM_FH_IDX
    , ROOTPARTYSETTLEMENTLOCATION_FH_IDX
    , SRQSRELATEDTRADEID_FH_IDX
    , SECONDARYQUOTEID_FH_IDX
    , SECONDARYTRADEID_FH_IDX
    , SECURITYID_FH_IDX
    , SECURITYSTATUS_FH_IDX
    , SECURITYSTATUSREPORTID_FH_IDX
    , SECURITYTRADINGSTATUS_FH_IDX
    , SELECTIVEREQUESTFORQUOTERTMSERVICESTATUS_FH_IDX
    , SELECTIVEREQUESTFORQUOTESERVICESTATUS_FH_IDX
    , SELECTIVEREQUESTFORQUOTESERVICETRADEDATE_FH_IDX
    , SENDERSUBID_FH_IDX
    , SENDINGTIME_FH_IDX
    , SESSIONINSTANCEID_FH_IDX
    , SESSIONMODE_FH_IDX
    , SESSIONREJECTREASON_FH_IDX
    , SESSIONSTATUS_FH_IDX
    , SESSIONSUBMODE_FH_IDX
    , SETTLCURRAMT_FH_IDX
    , SETTLCURRFXRATE_FH_IDX
    , SETTLCURRENCY_FH_IDX
    , SETTLDATE_FH_IDX
    , SIDE_FH_IDX
    , SIDEGROSSTRADEAMT_FH_IDX
    , SIDELASTQTY_FH_IDX
    , SIDELIQUIDITYIND_FH_IDX
    , SIDETRADEID_FH_IDX
    , SIDETRADEREPORTID_FH_IDX
    , SOLDOUTINDICATOR_FH_IDX
    , STOPPX_FH_IDX
    , STOPPXINDICATOR_FH_IDX
    , SUBSCRIPTIONSCOPE_FH_IDX
    , T7ENTRYSERVICERTMSTATUS_FH_IDX
    , T7ENTRYSERVICERTMTRADEDATE_FH_IDX
    , T7ENTRYSERVICESTATUS_FH_IDX
    , T7ENTRYSERVICETRADEDATE_FH_IDX
    , TESENRICHMENTRULEID_FH_IDX
    , TESEXECID_FH_IDX
    , TARGETPARTYENTERINGTRADER_FH_IDX
    , TARGETPARTYEXECUTINGFIRM_FH_IDX
    , TARGETPARTYEXECUTINGTRADER_FH_IDX
    , TARGETPARTYIDDESKID_FH_IDX
    , TARGETPARTYIDEXECUTINGTRADER_FH_IDX
    , TARGETPARTYIDSESSIONID_FH_IDX
    , TEMPLATEID_FH_IDX
    , THROTTLEDISCONNECTLIMIT_FH_IDX
    , THROTTLENOMSGS_FH_IDX
    , THROTTLETIMEINTERVAL_FH_IDX
    , TIMEINFORCE_FH_IDX
    , TRADSESEVENT_FH_IDX
    , TRADSESMODE_FH_IDX
    , TRADEALLOCSTATUS_FH_IDX
    , TRADEATCLOSEOPTIN_FH_IDX
    , TRADEDATE_FH_IDX
    , TRADEID_FH_IDX
    , TRADEMANAGERSTATUS_FH_IDX
    , TRADEMANAGERTRADEDATE_FH_IDX
    , TRADENUMBER_FH_IDX
    , TRADEPUBLISHINDICATOR_FH_IDX
    , TRADEREPORTID_FH_IDX
    , TRADEREPORTTEXT_FH_IDX
    , TRADEREPORTTYPE_FH_IDX
    , TRADINGCAPACITY_FH_IDX
    , TRADINGSESSIONSUBID_FH_IDX
    , TRANSBKDTIME_FH_IDX
    , TRANSACTTIME_FH_IDX
    , TRANSACTIONDELAYINDICATOR_FH_IDX
    , TRANSFERREASON_FH_IDX
    , TRDMATCHID_FH_IDX
    , TRDREGTSENTRYTIME_FH_IDX
    , TRDREGTSEXECUTIONTIME_FH_IDX
    , TRDREGTSTIMEIN_FH_IDX
    , TRDREGTSTIMEOUT_FH_IDX
    , TRDREGTSTIMEPRIORITY_FH_IDX
    , TRDRPTSTATUS_FH_IDX
    , TRDTYPE_FH_IDX
    , TRIGGERED_FH_IDX
    , USERSTATUS_FH_IDX
    , USERNAME_FH_IDX
    , VALIDUNTILTIME_FH_IDX
    , VALUECHECKTYPEQUANTITY_FH_IDX
    , VALUECHECKTYPEVALUE_FH_IDX
    , VARTEXT_FH_IDX
    , VARTEXTLEN_FH_IDX
    , VOLUMEDISCOVERYPRICE_FH_IDX
};
static const value_string template_id_vals[] = { // TemplateID
    { 10000, "LogonRequest" },
    { 10001, "LogonResponse" },
    { 10002, "LogoutRequest" },
    { 10003, "LogoutResponse" },
    { 10004, "Unknown" },
    { 10005, "SubscribeResponse" },
    { 10006, "UnsubscribeRequest" },
    { 10007, "UnsubscribeResponse" },
    { 10008, "RetransmitRequest" },
    { 10009, "RetransmitResponse" },
    { 10010, "Reject" },
    { 10011, "Heartbeat" },
    { 10012, "ForcedLogoutNotification" },
    { 10013, "Unknown" },
    { 10014, "Unknown" },
    { 10015, "Unknown" },
    { 10016, "Unknown" },
    { 10017, "Unknown" },
    { 10018, "UserLoginRequest" },
    { 10019, "UserLoginResponse" },
    { 10020, "Unknown" },
    { 10021, "Unknown" },
    { 10022, "Unknown" },
    { 10023, "HeartbeatNotification" },
    { 10024, "UserLogoutResponse" },
    { 10025, "SubscribeRequest" },
    { 10026, "RetransmitMEMessageRequest" },
    { 10027, "RetransmitMEMessageResponse" },
    { 10028, "ThrottleUpdateNotification" },
    { 10029, "UserLogoutRequest" },
    { 10030, "ServiceAvailabilityBroadcast" },
    { 10031, "NewsBroadcast" },
    { 10032, "BroadcastErrorNotification" },
    { 10033, "Unknown" },
    { 10034, "PartyEntitlementsUpdateReport" },
    { 10035, "InquireSessionListRequest" },
    { 10036, "InquireSessionListResponse" },
    { 10037, "LegalNotificationBroadcast" },
    { 10038, "InquireUserRequest" },
    { 10039, "InquireUserResponse" },
    { 10040, "InquireEnrichmentRuleIDListRequest" },
    { 10041, "InquireEnrichmentRuleIDListResponse" },
    { 10042, "PartyActionReport" },
    { 10043, "ForcedUserLogoutNotification" },
    { 10044, "ServiceAvailabilityMarketBroadcast" },
    { 10045, "Unknown" },
    { 10046, "Unknown" },
    { 10047, "Unknown" },
    { 10048, "Unknown" },
    { 10049, "Unknown" },
    { 10050, "Unknown" },
    { 10051, "Unknown" },
    { 10052, "Unknown" },
    { 10053, "Unknown" },
    { 10054, "Unknown" },
    { 10055, "Unknown" },
    { 10056, "Unknown" },
    { 10057, "Unknown" },
    { 10058, "Unknown" },
    { 10059, "Unknown" },
    { 10060, "Unknown" },
    { 10061, "Unknown" },
    { 10062, "Unknown" },
    { 10063, "Unknown" },
    { 10064, "Unknown" },
    { 10065, "Unknown" },
    { 10066, "Unknown" },
    { 10067, "Unknown" },
    { 10068, "Unknown" },
    { 10069, "Unknown" },
    { 10070, "Unknown" },
    { 10071, "Unknown" },
    { 10072, "Unknown" },
    { 10073, "Unknown" },
    { 10074, "Unknown" },
    { 10075, "Unknown" },
    { 10076, "Unknown" },
    { 10077, "Unknown" },
    { 10078, "Unknown" },
    { 10079, "Unknown" },
    { 10080, "Unknown" },
    { 10081, "Unknown" },
    { 10082, "Unknown" },
    { 10083, "Unknown" },
    { 10084, "Unknown" },
    { 10085, "Unknown" },
    { 10086, "Unknown" },
    { 10087, "Unknown" },
    { 10088, "Unknown" },
    { 10089, "Unknown" },
    { 10090, "Unknown" },
    { 10091, "Unknown" },
    { 10092, "Unknown" },
    { 10093, "Unknown" },
    { 10094, "Unknown" },
    { 10095, "Unknown" },
    { 10096, "Unknown" },
    { 10097, "Unknown" },
    { 10098, "Unknown" },
    { 10099, "Unknown" },
    { 10100, "NewOrderSingleRequest" },
    { 10101, "NewOrderResponse" },
    { 10102, "NewOrderNRResponse" },
    { 10103, "OrderExecResponse" },
    { 10104, "OrderExecNotification" },
    { 10105, "Unknown" },
    { 10106, "ModifyOrderSingleRequest" },
    { 10107, "ModifyOrderResponse" },
    { 10108, "ModifyOrderNRResponse" },
    { 10109, "DeleteOrderSingleRequest" },
    { 10110, "DeleteOrderResponse" },
    { 10111, "DeleteOrderNRResponse" },
    { 10112, "DeleteOrderBroadcast" },
    { 10113, "Unknown" },
    { 10114, "Unknown" },
    { 10115, "Unknown" },
    { 10116, "Unknown" },
    { 10117, "OrderExecReportBroadcast" },
    { 10118, "CrossRequest" },
    { 10119, "CrossRequestResponse" },
    { 10120, "DeleteAllOrderRequest" },
    { 10121, "DeleteAllOrderResponse" },
    { 10122, "DeleteAllOrderBroadcast" },
    { 10123, "Unknown" },
    { 10124, "DeleteAllOrderNRResponse" },
    { 10125, "NewOrderSingleShortRequest" },
    { 10126, "ModifyOrderSingleShortRequest" },
    { 10127, "TrailingStopUpdateNotification" },
    { 10128, "ExtendedDeletionReport" },
    { 10129, "Unknown" },
    { 10130, "Unknown" },
    { 10131, "Unknown" },
    { 10132, "Unknown" },
    { 10133, "Unknown" },
    { 10134, "Unknown" },
    { 10135, "Unknown" },
    { 10136, "SpecialistOrderBookNotification" },
    { 10137, "SpecialistDeleteAllOrderBroadcast" },
    { 10138, "Unknown" },
    { 10139, "Unknown" },
    { 10140, "Unknown" },
    { 10141, "Unknown" },
    { 10142, "Unknown" },
    { 10143, "Unknown" },
    { 10144, "Unknown" },
    { 10145, "Unknown" },
    { 10146, "Unknown" },
    { 10147, "Unknown" },
    { 10148, "Unknown" },
    { 10149, "Unknown" },
    { 10150, "Unknown" },
    { 10151, "Unknown" },
    { 10152, "Unknown" },
    { 10153, "Unknown" },
    { 10154, "Unknown" },
    { 10155, "Unknown" },
    { 10156, "Unknown" },
    { 10157, "Unknown" },
    { 10158, "Unknown" },
    { 10159, "Unknown" },
    { 10160, "Unknown" },
    { 10161, "Unknown" },
    { 10162, "Unknown" },
    { 10163, "Unknown" },
    { 10164, "Unknown" },
    { 10165, "Unknown" },
    { 10166, "Unknown" },
    { 10167, "Unknown" },
    { 10168, "Unknown" },
    { 10169, "Unknown" },
    { 10170, "Unknown" },
    { 10171, "Unknown" },
    { 10172, "Unknown" },
    { 10173, "Unknown" },
    { 10174, "Unknown" },
    { 10175, "Unknown" },
    { 10176, "Unknown" },
    { 10177, "Unknown" },
    { 10178, "Unknown" },
    { 10179, "Unknown" },
    { 10180, "Unknown" },
    { 10181, "Unknown" },
    { 10182, "Unknown" },
    { 10183, "Unknown" },
    { 10184, "Unknown" },
    { 10185, "Unknown" },
    { 10186, "Unknown" },
    { 10187, "Unknown" },
    { 10188, "Unknown" },
    { 10189, "Unknown" },
    { 10190, "Unknown" },
    { 10191, "Unknown" },
    { 10192, "Unknown" },
    { 10193, "Unknown" },
    { 10194, "Unknown" },
    { 10195, "Unknown" },
    { 10196, "Unknown" },
    { 10197, "Unknown" },
    { 10198, "Unknown" },
    { 10199, "Unknown" },
    { 10200, "Unknown" },
    { 10201, "Unknown" },
    { 10202, "Unknown" },
    { 10203, "Unknown" },
    { 10204, "Unknown" },
    { 10205, "Unknown" },
    { 10206, "Unknown" },
    { 10207, "Unknown" },
    { 10208, "Unknown" },
    { 10209, "Unknown" },
    { 10210, "Unknown" },
    { 10211, "Unknown" },
    { 10212, "Unknown" },
    { 10213, "Unknown" },
    { 10214, "Unknown" },
    { 10215, "Unknown" },
    { 10216, "Unknown" },
    { 10217, "Unknown" },
    { 10218, "Unknown" },
    { 10219, "Unknown" },
    { 10220, "Unknown" },
    { 10221, "Unknown" },
    { 10222, "Unknown" },
    { 10223, "Unknown" },
    { 10224, "Unknown" },
    { 10225, "Unknown" },
    { 10226, "Unknown" },
    { 10227, "Unknown" },
    { 10228, "Unknown" },
    { 10229, "Unknown" },
    { 10230, "Unknown" },
    { 10231, "Unknown" },
    { 10232, "Unknown" },
    { 10233, "Unknown" },
    { 10234, "Unknown" },
    { 10235, "Unknown" },
    { 10236, "Unknown" },
    { 10237, "Unknown" },
    { 10238, "Unknown" },
    { 10239, "Unknown" },
    { 10240, "Unknown" },
    { 10241, "Unknown" },
    { 10242, "Unknown" },
    { 10243, "Unknown" },
    { 10244, "Unknown" },
    { 10245, "Unknown" },
    { 10246, "Unknown" },
    { 10247, "Unknown" },
    { 10248, "Unknown" },
    { 10249, "Unknown" },
    { 10250, "Unknown" },
    { 10251, "Unknown" },
    { 10252, "Unknown" },
    { 10253, "Unknown" },
    { 10254, "Unknown" },
    { 10255, "Unknown" },
    { 10256, "Unknown" },
    { 10257, "Unknown" },
    { 10258, "Unknown" },
    { 10259, "Unknown" },
    { 10260, "Unknown" },
    { 10261, "Unknown" },
    { 10262, "Unknown" },
    { 10263, "Unknown" },
    { 10264, "Unknown" },
    { 10265, "Unknown" },
    { 10266, "Unknown" },
    { 10267, "Unknown" },
    { 10268, "Unknown" },
    { 10269, "Unknown" },
    { 10270, "Unknown" },
    { 10271, "Unknown" },
    { 10272, "Unknown" },
    { 10273, "Unknown" },
    { 10274, "Unknown" },
    { 10275, "Unknown" },
    { 10276, "Unknown" },
    { 10277, "Unknown" },
    { 10278, "Unknown" },
    { 10279, "Unknown" },
    { 10280, "Unknown" },
    { 10281, "Unknown" },
    { 10282, "Unknown" },
    { 10283, "Unknown" },
    { 10284, "Unknown" },
    { 10285, "Unknown" },
    { 10286, "Unknown" },
    { 10287, "Unknown" },
    { 10288, "Unknown" },
    { 10289, "Unknown" },
    { 10290, "Unknown" },
    { 10291, "Unknown" },
    { 10292, "Unknown" },
    { 10293, "Unknown" },
    { 10294, "Unknown" },
    { 10295, "Unknown" },
    { 10296, "Unknown" },
    { 10297, "Unknown" },
    { 10298, "Unknown" },
    { 10299, "Unknown" },
    { 10300, "Unknown" },
    { 10301, "Unknown" },
    { 10302, "Unknown" },
    { 10303, "Unknown" },
    { 10304, "Unknown" },
    { 10305, "Unknown" },
    { 10306, "Unknown" },
    { 10307, "TradingSessionStatusBroadcast" },
    { 10308, "DeleteAllOrderQuoteEventBroadcast" },
    { 10309, "Unknown" },
    { 10310, "Unknown" },
    { 10311, "Unknown" },
    { 10312, "Unknown" },
    { 10313, "Unknown" },
    { 10314, "IssuerSecurityStateChangeRequest" },
    { 10315, "IssuerSecurityStateChangeResponse" },
    { 10316, "IssuerNotification" },
    { 10317, "SpecialistSecurityStateChangeRequest" },
    { 10318, "SpecialistSecurityStateChangeResponse" },
    { 10319, "SpecialistInstrumentEventNotification" },
    { 10320, "PingRequest" },
    { 10321, "PingResponse" },
    { 10322, "Unknown" },
    { 10323, "Unknown" },
    { 10324, "Unknown" },
    { 10325, "Unknown" },
    { 10326, "Unknown" },
    { 10327, "Unknown" },
    { 10328, "Unknown" },
    { 10329, "Unknown" },
    { 10330, "Unknown" },
    { 10331, "Unknown" },
    { 10332, "Unknown" },
    { 10333, "Unknown" },
    { 10334, "Unknown" },
    { 10335, "Unknown" },
    { 10336, "Unknown" },
    { 10337, "Unknown" },
    { 10338, "Unknown" },
    { 10339, "Unknown" },
    { 10340, "Unknown" },
    { 10341, "Unknown" },
    { 10342, "Unknown" },
    { 10343, "Unknown" },
    { 10344, "Unknown" },
    { 10345, "Unknown" },
    { 10346, "Unknown" },
    { 10347, "Unknown" },
    { 10348, "Unknown" },
    { 10349, "Unknown" },
    { 10350, "Unknown" },
    { 10351, "Unknown" },
    { 10352, "Unknown" },
    { 10353, "Unknown" },
    { 10354, "Unknown" },
    { 10355, "Unknown" },
    { 10356, "Unknown" },
    { 10357, "Unknown" },
    { 10358, "Unknown" },
    { 10359, "Unknown" },
    { 10360, "Unknown" },
    { 10361, "Unknown" },
    { 10362, "Unknown" },
    { 10363, "Unknown" },
    { 10364, "Unknown" },
    { 10365, "Unknown" },
    { 10366, "Unknown" },
    { 10367, "Unknown" },
    { 10368, "Unknown" },
    { 10369, "Unknown" },
    { 10370, "Unknown" },
    { 10371, "Unknown" },
    { 10372, "Unknown" },
    { 10373, "Unknown" },
    { 10374, "Unknown" },
    { 10375, "Unknown" },
    { 10376, "Unknown" },
    { 10377, "Unknown" },
    { 10378, "Unknown" },
    { 10379, "Unknown" },
    { 10380, "Unknown" },
    { 10381, "Unknown" },
    { 10382, "Unknown" },
    { 10383, "Unknown" },
    { 10384, "Unknown" },
    { 10385, "Unknown" },
    { 10386, "Unknown" },
    { 10387, "Unknown" },
    { 10388, "Unknown" },
    { 10389, "Unknown" },
    { 10390, "Unknown" },
    { 10391, "Unknown" },
    { 10392, "Unknown" },
    { 10393, "Unknown" },
    { 10394, "Unknown" },
    { 10395, "Unknown" },
    { 10396, "Unknown" },
    { 10397, "Unknown" },
    { 10398, "Unknown" },
    { 10399, "Unknown" },
    { 10400, "Unknown" },
    { 10401, "RFQRequest" },
    { 10402, "RFQResponse" },
    { 10403, "QuoteActivationRequest" },
    { 10404, "QuoteActivationResponse" },
    { 10405, "MassQuoteRequest" },
    { 10406, "MassQuoteResponse" },
    { 10407, "QuoteExecutionReport" },
    { 10408, "DeleteAllQuoteRequest" },
    { 10409, "DeleteAllQuoteResponse" },
    { 10410, "DeleteAllQuoteBroadcast" },
    { 10411, "QuoteActivationNotification" },
    { 10412, "Unknown" },
    { 10413, "Unknown" },
    { 10414, "Unknown" },
    { 10415, "RFQBroadcast" },
    { 10416, "Unknown" },
    { 10417, "Unknown" },
    { 10418, "SingleQuoteRequest" },
    { 10419, "RFQSpecialistBroadcast" },
    { 10420, "RFQRejectNotification" },
    { 10421, "SpecialistRFQRejectRequest" },
    { 10422, "SpecialistRFQReplyRequest" },
    { 10423, "SpecialistRFQReplyResponse" },
    { 10424, "SpecialistRFQReplyNotification" },
    { 10425, "Unknown" },
    { 10426, "Unknown" },
    { 10427, "Unknown" },
    { 10428, "Unknown" },
    { 10429, "Unknown" },
    { 10430, "Unknown" },
    { 10431, "Unknown" },
    { 10432, "Unknown" },
    { 10433, "Unknown" },
    { 10434, "Unknown" },
    { 10435, "Unknown" },
    { 10436, "Unknown" },
    { 10437, "Unknown" },
    { 10438, "Unknown" },
    { 10439, "Unknown" },
    { 10440, "Unknown" },
    { 10441, "Unknown" },
    { 10442, "Unknown" },
    { 10443, "Unknown" },
    { 10444, "Unknown" },
    { 10445, "Unknown" },
    { 10446, "Unknown" },
    { 10447, "Unknown" },
    { 10448, "Unknown" },
    { 10449, "Unknown" },
    { 10450, "Unknown" },
    { 10451, "Unknown" },
    { 10452, "Unknown" },
    { 10453, "Unknown" },
    { 10454, "Unknown" },
    { 10455, "Unknown" },
    { 10456, "Unknown" },
    { 10457, "Unknown" },
    { 10458, "Unknown" },
    { 10459, "Unknown" },
    { 10460, "Unknown" },
    { 10461, "Unknown" },
    { 10462, "Unknown" },
    { 10463, "Unknown" },
    { 10464, "Unknown" },
    { 10465, "Unknown" },
    { 10466, "Unknown" },
    { 10467, "Unknown" },
    { 10468, "Unknown" },
    { 10469, "Unknown" },
    { 10470, "Unknown" },
    { 10471, "Unknown" },
    { 10472, "Unknown" },
    { 10473, "Unknown" },
    { 10474, "Unknown" },
    { 10475, "Unknown" },
    { 10476, "Unknown" },
    { 10477, "Unknown" },
    { 10478, "Unknown" },
    { 10479, "Unknown" },
    { 10480, "Unknown" },
    { 10481, "Unknown" },
    { 10482, "Unknown" },
    { 10483, "Unknown" },
    { 10484, "Unknown" },
    { 10485, "Unknown" },
    { 10486, "Unknown" },
    { 10487, "Unknown" },
    { 10488, "Unknown" },
    { 10489, "Unknown" },
    { 10490, "Unknown" },
    { 10491, "Unknown" },
    { 10492, "Unknown" },
    { 10493, "Unknown" },
    { 10494, "Unknown" },
    { 10495, "Unknown" },
    { 10496, "Unknown" },
    { 10497, "Unknown" },
    { 10498, "Unknown" },
    { 10499, "Unknown" },
    { 10500, "TradeBroadcast" },
    { 10501, "TMTradingSessionStatusBroadcast" },
    { 10502, "Unknown" },
    { 10503, "Unknown" },
    { 10504, "Unknown" },
    { 10505, "Unknown" },
    { 10506, "Unknown" },
    { 10507, "Unknown" },
    { 10508, "Unknown" },
    { 10509, "Unknown" },
    { 10510, "Unknown" },
    { 10511, "Unknown" },
    { 10512, "Unknown" },
    { 10513, "Unknown" },
    { 10514, "Unknown" },
    { 10515, "Unknown" },
    { 10516, "Unknown" },
    { 10517, "Unknown" },
    { 10518, "Unknown" },
    { 10519, "Unknown" },
    { 10520, "Unknown" },
    { 10521, "Unknown" },
    { 10522, "Unknown" },
    { 10523, "Unknown" },
    { 10524, "Unknown" },
    { 10525, "Unknown" },
    { 10526, "Unknown" },
    { 10527, "Unknown" },
    { 10528, "Unknown" },
    { 10529, "Unknown" },
    { 10530, "Unknown" },
    { 10531, "Unknown" },
    { 10532, "Unknown" },
    { 10533, "Unknown" },
    { 10534, "Unknown" },
    { 10535, "Unknown" },
    { 10536, "Unknown" },
    { 10537, "Unknown" },
    { 10538, "Unknown" },
    { 10539, "Unknown" },
    { 10540, "Unknown" },
    { 10541, "Unknown" },
    { 10542, "Unknown" },
    { 10543, "Unknown" },
    { 10544, "Unknown" },
    { 10545, "Unknown" },
    { 10546, "Unknown" },
    { 10547, "Unknown" },
    { 10548, "Unknown" },
    { 10549, "Unknown" },
    { 10550, "Unknown" },
    { 10551, "Unknown" },
    { 10552, "Unknown" },
    { 10553, "Unknown" },
    { 10554, "Unknown" },
    { 10555, "Unknown" },
    { 10556, "Unknown" },
    { 10557, "Unknown" },
    { 10558, "Unknown" },
    { 10559, "Unknown" },
    { 10560, "Unknown" },
    { 10561, "Unknown" },
    { 10562, "Unknown" },
    { 10563, "Unknown" },
    { 10564, "Unknown" },
    { 10565, "Unknown" },
    { 10566, "Unknown" },
    { 10567, "Unknown" },
    { 10568, "Unknown" },
    { 10569, "Unknown" },
    { 10570, "Unknown" },
    { 10571, "Unknown" },
    { 10572, "Unknown" },
    { 10573, "Unknown" },
    { 10574, "Unknown" },
    { 10575, "Unknown" },
    { 10576, "Unknown" },
    { 10577, "Unknown" },
    { 10578, "Unknown" },
    { 10579, "Unknown" },
    { 10580, "Unknown" },
    { 10581, "Unknown" },
    { 10582, "Unknown" },
    { 10583, "Unknown" },
    { 10584, "Unknown" },
    { 10585, "Unknown" },
    { 10586, "Unknown" },
    { 10587, "Unknown" },
    { 10588, "Unknown" },
    { 10589, "Unknown" },
    { 10590, "Unknown" },
    { 10591, "Unknown" },
    { 10592, "Unknown" },
    { 10593, "Unknown" },
    { 10594, "Unknown" },
    { 10595, "Unknown" },
    { 10596, "Unknown" },
    { 10597, "Unknown" },
    { 10598, "Unknown" },
    { 10599, "Unknown" },
    { 10600, "EnterTESTradeRequest" },
    { 10601, "ModifyTESTradeRequest" },
    { 10602, "DeleteTESTradeRequest" },
    { 10603, "ApproveTESTradeRequest" },
    { 10604, "TESBroadcast" },
    { 10605, "Unknown" },
    { 10606, "TESDeleteBroadcast" },
    { 10607, "TESApproveBroadcast" },
    { 10608, "Unknown" },
    { 10609, "Unknown" },
    { 10610, "TESExecutionBroadcast" },
    { 10611, "TESResponse" },
    { 10612, "Unknown" },
    { 10613, "Unknown" },
    { 10614, "TESTradeBroadcast" },
    { 10615, "TESTradingSessionStatusBroadcast" },
    { 10616, "Unknown" },
    { 10617, "Unknown" },
    { 10618, "Unknown" },
    { 10619, "Unknown" },
    { 10620, "Unknown" },
    { 10621, "Unknown" },
    { 10622, "Unknown" },
    { 10623, "Unknown" },
    { 10624, "Unknown" },
    { 10625, "Unknown" },
    { 10626, "Unknown" },
    { 10627, "Unknown" },
    { 10628, "Unknown" },
    { 10629, "Unknown" },
    { 10630, "Unknown" },
    { 10631, "Unknown" },
    { 10632, "Unknown" },
    { 10633, "Unknown" },
    { 10634, "Unknown" },
    { 10635, "Unknown" },
    { 10636, "Unknown" },
    { 10637, "Unknown" },
    { 10638, "Unknown" },
    { 10639, "Unknown" },
    { 10640, "Unknown" },
    { 10641, "Unknown" },
    { 10642, "Unknown" },
    { 10643, "Unknown" },
    { 10644, "Unknown" },
    { 10645, "Unknown" },
    { 10646, "Unknown" },
    { 10647, "Unknown" },
    { 10648, "Unknown" },
    { 10649, "Unknown" },
    { 10650, "Unknown" },
    { 10651, "Unknown" },
    { 10652, "Unknown" },
    { 10653, "Unknown" },
    { 10654, "Unknown" },
    { 10655, "Unknown" },
    { 10656, "Unknown" },
    { 10657, "Unknown" },
    { 10658, "Unknown" },
    { 10659, "Unknown" },
    { 10660, "Unknown" },
    { 10661, "Unknown" },
    { 10662, "Unknown" },
    { 10663, "Unknown" },
    { 10664, "Unknown" },
    { 10665, "Unknown" },
    { 10666, "Unknown" },
    { 10667, "Unknown" },
    { 10668, "Unknown" },
    { 10669, "Unknown" },
    { 10670, "Unknown" },
    { 10671, "Unknown" },
    { 10672, "Unknown" },
    { 10673, "Unknown" },
    { 10674, "Unknown" },
    { 10675, "Unknown" },
    { 10676, "Unknown" },
    { 10677, "Unknown" },
    { 10678, "Unknown" },
    { 10679, "Unknown" },
    { 10680, "Unknown" },
    { 10681, "Unknown" },
    { 10682, "Unknown" },
    { 10683, "Unknown" },
    { 10684, "Unknown" },
    { 10685, "Unknown" },
    { 10686, "Unknown" },
    { 10687, "Unknown" },
    { 10688, "Unknown" },
    { 10689, "Unknown" },
    { 10690, "Unknown" },
    { 10691, "Unknown" },
    { 10692, "Unknown" },
    { 10693, "Unknown" },
    { 10694, "Unknown" },
    { 10695, "Unknown" },
    { 10696, "Unknown" },
    { 10697, "Unknown" },
    { 10698, "Unknown" },
    { 10699, "Unknown" },
    { 10700, "Unknown" },
    { 10701, "Unknown" },
    { 10702, "Unknown" },
    { 10703, "Unknown" },
    { 10704, "Unknown" },
    { 10705, "Unknown" },
    { 10706, "Unknown" },
    { 10707, "Unknown" },
    { 10708, "Unknown" },
    { 10709, "Unknown" },
    { 10710, "Unknown" },
    { 10711, "Unknown" },
    { 10712, "Unknown" },
    { 10713, "Unknown" },
    { 10714, "Unknown" },
    { 10715, "Unknown" },
    { 10716, "Unknown" },
    { 10717, "Unknown" },
    { 10718, "Unknown" },
    { 10719, "Unknown" },
    { 10720, "Unknown" },
    { 10721, "Unknown" },
    { 10722, "Unknown" },
    { 10723, "Unknown" },
    { 10724, "Unknown" },
    { 10725, "Unknown" },
    { 10726, "Unknown" },
    { 10727, "Unknown" },
    { 10728, "Unknown" },
    { 10729, "Unknown" },
    { 10730, "Unknown" },
    { 10731, "Unknown" },
    { 10732, "Unknown" },
    { 10733, "Unknown" },
    { 10734, "Unknown" },
    { 10735, "Unknown" },
    { 10736, "Unknown" },
    { 10737, "Unknown" },
    { 10738, "Unknown" },
    { 10739, "Unknown" },
    { 10740, "Unknown" },
    { 10741, "Unknown" },
    { 10742, "Unknown" },
    { 10743, "Unknown" },
    { 10744, "Unknown" },
    { 10745, "Unknown" },
    { 10746, "Unknown" },
    { 10747, "Unknown" },
    { 10748, "Unknown" },
    { 10749, "Unknown" },
    { 10750, "Unknown" },
    { 10751, "Unknown" },
    { 10752, "Unknown" },
    { 10753, "Unknown" },
    { 10754, "Unknown" },
    { 10755, "Unknown" },
    { 10756, "Unknown" },
    { 10757, "Unknown" },
    { 10758, "Unknown" },
    { 10759, "Unknown" },
    { 10760, "Unknown" },
    { 10761, "Unknown" },
    { 10762, "Unknown" },
    { 10763, "Unknown" },
    { 10764, "Unknown" },
    { 10765, "Unknown" },
    { 10766, "Unknown" },
    { 10767, "Unknown" },
    { 10768, "Unknown" },
    { 10769, "Unknown" },
    { 10770, "Unknown" },
    { 10771, "Unknown" },
    { 10772, "Unknown" },
    { 10773, "Unknown" },
    { 10774, "Unknown" },
    { 10775, "Unknown" },
    { 10776, "Unknown" },
    { 10777, "Unknown" },
    { 10778, "Unknown" },
    { 10779, "Unknown" },
    { 10780, "Unknown" },
    { 10781, "Unknown" },
    { 10782, "Unknown" },
    { 10783, "Unknown" },
    { 10784, "Unknown" },
    { 10785, "Unknown" },
    { 10786, "Unknown" },
    { 10787, "Unknown" },
    { 10788, "Unknown" },
    { 10789, "Unknown" },
    { 10790, "Unknown" },
    { 10791, "Unknown" },
    { 10792, "Unknown" },
    { 10793, "Unknown" },
    { 10794, "Unknown" },
    { 10795, "Unknown" },
    { 10796, "Unknown" },
    { 10797, "Unknown" },
    { 10798, "Unknown" },
    { 10799, "Unknown" },
    { 10800, "XetraEnLightOpenNegotiationRequest" },
    { 10801, "XetraEnLightUpdateNegotiationRequest" },
    { 10802, "XetraEnLightEnterQuoteRequest" },
    { 10803, "XetraEnLightQuoteResponse" },
    { 10804, "XetraEnLightHitQuoteRequest" },
    { 10805, "XetraEnLightDealResponse" },
    { 10806, "Unknown" },
    { 10807, "XetraEnLightQuoteNotification" },
    { 10808, "XetraEnLightCreateDealNotification" },
    { 10809, "Unknown" },
    { 10810, "XetraEnLightOpenNegotiationRequesterNotification" },
    { 10811, "XetraEnLightOpenNegotiationNotification" },
    { 10812, "XetraEnLightNegotiationRequesterNotification" },
    { 10813, "XetraEnLightNegotiationNotification" },
    { 10814, "XetraEnLightStatusBroadcast" },
    { 10815, "XetraEnLightNegotiationStatusNotification" },
    { 10816, "XetraEnLightQuoteRequesterNotification" },
    { 10817, "XetraEnLightQuotingStatusRequest" },
    { 0, NULL }
};
static value_string_ext template_id_vals_ext = VALUE_STRING_EXT_INIT(template_id_vals);
static const value_string alloc_method_vals[] = { // AllocMethod
    { 1, "Automatic_Random" },
    { 3, "Manual" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_id_vals[] = { // ApplID
    { 1, "Trade" },
    { 2, "News" },
    { 3, "Service_availability" },
    { 4, "Session_data" },
    { 5, "Listener_data" },
    { 6, "RiskControl" },
    { 7, "TES_Maintenance" },
    { 8, "TES_Trade" },
    { 9, "SRQS_Maintenance" },
    { 10, "Service_Availability_Market" },
    { 11, "Specialist_Data" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext appl_id_vals_ext = VALUE_STRING_EXT_INIT(appl_id_vals);
static const value_string appl_idstatus_vals[] = { // ApplIDStatus
    { 105, "Outbound_conversion_error" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_resend_flag_vals[] = { // ApplResendFlag
    { 0, "False" },
    { 1, "True" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_seq_indicator_vals[] = { // ApplSeqIndicator
    { 0, "No_Recovery_Required" },
    { 1, "Recovery_Required" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_seq_status_vals[] = { // ApplSeqStatus
    { 0, "Unavailable" },
    { 1, "Available" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_usage_orders_vals[] = { // ApplUsageOrders
    { 0, "NO_VALUE" },
    { 'A', "Automated" },
    { 'B', "AutoSelect" },
    { 'M', "Manual" },
    { 'N', "None" },
    { 0, NULL }
};
// ApplUsageQuotes aliased by ApplUsageOrders
static const value_string clearing_instruction_vals[] = { // ClearingInstruction
    { 2, "Bilateral_netting_only" },
    { 13, "Self_clearing" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string crossed_indicator_vals[] = { // CrossedIndicator
    { 0, "No_crossing" },
    { 1, "Cross_rejected" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string delete_reason_vals[] = { // DeleteReason
    { 100, "No_special_reason" },
    { 101, "TAS_Change" },
    { 102, "Intraday_Expiration" },
    { 103, "Risk_Event" },
    { 104, "Stop_Trading" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string delivery_type_vals[] = { // DeliveryType
    { 1, "AKV" },
    { 2, "GS" },
    { 3, "STR" },
    { 4, "WPR" },
    { 5, "AKT" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string event_type_vals[] = { // EventType
    { 26, "Redemption" },
    { 100, "Delisting" },
    { 104, "Instrument_Assignment_Added" },
    { 105, "Instrument_Assignment_Removed" },
    { 106, "Closed" },
    { 107, "Restricted" },
    { 108, "Book" },
    { 109, "Continuous" },
    { 110, "Auction" },
    { 111, "Freeze" },
    { 112, "Cancel_Freeze" },
    { 113, "Pre_Call" },
    { 114, "End_of_Restatement" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext event_type_vals_ext = VALUE_STRING_EXT_INIT(event_type_vals);
static const value_string exec_inst_vals[] = { // ExecInst
    { 1, "H" },
    { 2, "Q" },
    { 3, "H_Q" },
    { 5, "H_6" },
    { 6, "Q_6" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string exec_restatement_reason_vals[] = { // ExecRestatementReason
    { 0, "Corporate_Action" },
    { 1, "Order_Book_Restatement" },
    { 8, "Exchange_Option" },
    { 101, "Order_Added" },
    { 102, "Order_Modified" },
    { 103, "Order_Cancelled" },
    { 105, "IOC_Order_Cancelled" },
    { 107, "FOK_Order_Cancelled" },
    { 108, "Book_Order_Executed" },
    { 114, "Changed_to_IOC" },
    { 119, "Change_of_Specialist" },
    { 122, "Instrument_State_Change" },
    { 138, "Pending_New" },
    { 139, "Pending_Replace" },
    { 141, "Pending_New_Applied" },
    { 142, "Pending_Replace_Applied" },
    { 146, "End_Of_Day_Processing" },
    { 148, "Order_Expiration" },
    { 149, "CAO_Order_Activated" },
    { 150, "CAO_Order_Inactivated" },
    { 151, "OAO_Order_Activated" },
    { 152, "OAO_Order_Inactivated" },
    { 153, "AAO_Order_Activated" },
    { 154, "AAO_Order_Inactivated" },
    { 155, "Order_Refreshed" },
    { 159, "IAO_Order_Activated" },
    { 160, "IAO_Order_Inactivated" },
    { 164, "OCO_Order_Triggered" },
    { 172, "Stop_Order_Triggered" },
    { 181, "Ownership_Changed" },
    { 197, "Order_Cancellation_Pending" },
    { 199, "Pending_Cancellation_Executed" },
    { 212, "BOC_Order_Cancelled" },
    { 213, "Trailing_Stop_Update" },
    { 237, "Exceeds_Maximum_Quantity" },
    { 238, "Invalid_Limit_Price" },
    { 241, "User_Does_Not_Exist" },
    { 242, "Session_Does_Not_Exist" },
    { 243, "Invalid_Stop_Price" },
    { 245, "Instrument_Does_Not_Exist" },
    { 246, "Business_Unit_Risk_Event" },
    { 261, "Panic_Cancel" },
    { 292, "Dividend_Payment" },
    { 294, "Last_Trading_Day" },
    { 295, "Trading_Parameter_Change" },
    { 296, "Currency_Change" },
    { 297, "Product_Assignment_Change" },
    { 298, "Reference_Price_Change" },
    { 300, "Tick_Rule_Change" },
    { 316, "QRS_Expiry" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext exec_restatement_reason_vals_ext = VALUE_STRING_EXT_INIT(exec_restatement_reason_vals);
static const value_string exec_type_vals[] = { // ExecType
    { 0, "NO_VALUE" },
    { '0', "New" },
    { '4', "Canceled" },
    { '5', "Replaced" },
    { '6', "Pending_Cancel_e" },
    { '9', "Suspended" },
    { 'A', "Pending_New" },
    { 'D', "Restated" },
    { 'E', "Pending_Replace" },
    { 'F', "Trade" },
    { 'L', "Triggered" },
    { 0, NULL }
};
static value_string_ext exec_type_vals_ext = VALUE_STRING_EXT_INIT(exec_type_vals);
static const value_string executing_trader_qualifier_vals[] = { // ExecutingTraderQualifier
    { 22, "Algo" },
    { 24, "Human" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string fill_liquidity_ind_vals[] = { // FillLiquidityInd
    { 1, "Added_Liquidity" },
    { 2, "Removed_Liquidity" },
    { 4, "Auction" },
    { 5, "Triggered_Stop_Order" },
    { 6, "Triggered_OCO_Order" },
    { 7, "Triggered_Market_Order" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string last_coupon_deviation_indicator_vals[] = { // LastCouponDeviationIndicator
    { 0, "None" },
    { 1, "Short_period" },
    { 2, "Long_period" },
    { 3, "Only_one_coupon" },
    { 4, "Short_two_interest_payments_due" },
    { 5, "Long_two_interest_payments_due" },
    { 6, "Perpetual" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext last_coupon_deviation_indicator_vals_ext = VALUE_STRING_EXT_INIT(last_coupon_deviation_indicator_vals);
static const value_string last_fragment_vals[] = { // LastFragment
    { 0, "Not_Last_Message" },
    { 1, "Last_Message" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string last_mkt_vals[] = { // LastMkt
    { 3, "XETR" },
    { 4, "XVIE" },
    { 6, "XMAL" },
    { 7, "XBUL" },
    { 8, "XBUD" },
    { 9, "XLJU" },
    { 10, "XPRA" },
    { 11, "XZAG" },
    { 13, "XFRA" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext last_mkt_vals_ext = VALUE_STRING_EXT_INIT(last_mkt_vals);
static const value_string list_update_action_vals[] = { // ListUpdateAction
    { 0, "NO_VALUE" },
    { 'A', "Add" },
    { 'D', "Delete" },
    { 0, NULL }
};
static const value_string mdbook_type_vals[] = { // MDBookType
    { 1, "TopOfBook" },
    { 2, "PriceDepth" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string mdsub_book_type_vals[] = { // MDSubBookType
    { 2, "VolumeWeightedAverage" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// MarketID aliased by LastMkt
static const value_string mass_action_reason_vals[] = { // MassActionReason
    { 0, "No_Special_Reason" },
    { 1, "Stop_Trading" },
    { 2, "Emergency" },
    { 6, "Session_Loss" },
    { 7, "Duplicate_Session_Login" },
    { 8, "Clearing_Risk_Control" },
    { 100, "Internal_Connection_Loss" },
    { 105, "Product_State_Halt" },
    { 106, "Product_State_Holiday" },
    { 107, "Instrument_Suspended" },
    { 110, "Volatility_Interruption" },
    { 111, "Product_temporarily_not_tradeable" },
    { 113, "Instrument_Stopped" },
    { 115, "Instrument_Knock_Out" },
    { 116, "Instrument_Sold_Out" },
    { 118, "Instrument_Knock_Out_Reverted" },
    { 119, "Automatic_Quote_Deletion" },
    { 120, "Outside_Quoting_Period" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext mass_action_reason_vals_ext = VALUE_STRING_EXT_INIT(mass_action_reason_vals);
static const value_string mass_action_type_vals[] = { // MassActionType
    { 1, "Suspend_quotes" },
    { 2, "Release_quotes" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string match_sub_type_vals[] = { // MatchSubType
    { 1, "Opening_Auction" },
    { 2, "Closing_Auction" },
    { 3, "Intraday_Auction" },
    { 4, "Circuit_Breaker_Auction" },
    { 5, "TRADE_AT_CLOSE" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string match_type_vals[] = { // MatchType
    { 3, "Confirmed_Trade_Report" },
    { 4, "Auto_match_incoming" },
    { 5, "Cross_Auction" },
    { 7, "Call_Auction" },
    { 11, "Auto_match_resting" },
    { 12, "Auto_match_at_mid_point" },
    { 14, "Continuous_Auction" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext match_type_vals_ext = VALUE_STRING_EXT_INIT(match_type_vals);
// MatchingEngineStatus aliased by ApplSeqStatus
static const value_string message_event_source_vals[] = { // MessageEventSource
    { 0, "NO_VALUE" },
    { 'A', "Broadcast_to_Approver" },
    { 'I', "Broadcast_to_Initiator" },
    { 'Q', "Broadcast_to_Quote_Submitter" },
    { 'R', "Broadcast_to_Requester" },
    { 0, NULL }
};
static const value_string number_of_resp_disclosure_instruction_vals[] = { // NumberOfRespDisclosureInstruction
    { 0, "No" },
    { 1, "Yes" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string ord_status_vals[] = { // OrdStatus
    { 0, "NO_VALUE" },
    { '0', "New" },
    { '1', "Partially_filled" },
    { '2', "Filled" },
    { '4', "Canceled" },
    { '6', "Pending_Cancel" },
    { '9', "Suspended" },
    { 'A', "Pending_New" },
    { 'E', "Pending_Replace" },
    { 0, NULL }
};
static value_string_ext ord_status_vals_ext = VALUE_STRING_EXT_INIT(ord_status_vals);
static const value_string ord_type_vals[] = { // OrdType
    { 1, "Market" },
    { 2, "Limit" },
    { 3, "Stop" },
    { 4, "Stop_Limit" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string order_attribute_liquidity_provision_vals[] = { // OrderAttributeLiquidityProvision
    { 0, "N" },
    { 1, "Y" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string order_category_vals[] = { // OrderCategory
    { 0, "NO_VALUE" },
    { '1', "Order" },
    { '2', "Quote" },
    { 0, NULL }
};
static const value_string order_event_reason_vals[] = { // OrderEventReason
    { 100, "SMP" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string order_event_type_vals[] = { // OrderEventType
    { 100, "Pending_requests_discarded" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string order_origination_vals[] = { // OrderOrigination
    { 5, "Direct_access_or_sponsored_access_customer" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string order_routing_indicator_vals[] = { // OrderRoutingIndicator
    { 0, "NO_VALUE" },
    { 'N', "No" },
    { 'Y', "Yes" },
    { 0, NULL }
};
static const value_string ownership_indicator_vals[] = { // OwnershipIndicator
    { 0, "No_Change_of_Ownership" },
    { 1, "Change_to_Executing_Trader" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_action_type_vals[] = { // PartyActionType
    { 1, "Halt_Trading" },
    { 2, "Reinstate" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_detail_role_qualifier_vals[] = { // PartyDetailRoleQualifier
    { 10, "Trader" },
    { 11, "Head_Trader" },
    { 12, "Supervisor" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_detail_status_vals[] = { // PartyDetailStatus
    { 0, "Active" },
    { 1, "Suspend" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_identering_firm_vals[] = { // PartyIDEnteringFirm
    { 1, "Participant" },
    { 2, "MarketSupervision" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// PartyIdInvestmentDecisionMakerQualifier aliased by ExecutingTraderQualifier
static const value_string price_validity_check_type_vals[] = { // PriceValidityCheckType
    { 0, "None" },
    { 2, "Mandatory" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_cancel_type_vals[] = { // QuoteCancelType
    { 4, "Cancel_All_Quotes" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_entry_reject_reason_vals[] = { // QuoteEntryRejectReason
    { 1, "Unknown_Security" },
    { 6, "Duplicate_Quote" },
    { 8, "Invalid_Price" },
    { 16, "No_Reference_Price_Available" },
    { 100, "No_Single_Sided_Quotes" },
    { 103, "Invalid_Quoting_Model" },
    { 106, "Invalid_Size" },
    { 108, "Bid_Price_Not_Reasonable" },
    { 109, "Ask_Price_Not_Reasonable" },
    { 110, "Bid_Price_Exceeds_Range" },
    { 111, "Ask_Price_Exceeds_Range" },
    { 115, "Instrument_State_Freeze" },
    { 116, "Deletion_Already_Pending" },
    { 120, "Bid_Value_Exceeds_Limit" },
    { 121, "Ask_Value_Exceeds_Limit" },
    { 122, "Not_Tradeable_For_BusinessUnit" },
    { 125, "Quantity_Limit_Exceeded" },
    { 126, "Value_Limit_Exceeded" },
    { 127, "Invalid_Quote_Spread" },
    { 131, "Cant_Proc_In_Curr_Instr_State" },
    { 134, "Invalid_Quote_Type" },
    { 135, "PWT_Quote_not_allowed_in_current_state" },
    { 136, "Standard_Quote_not_allowed_in_current_state" },
    { 137, "PWT_Quote_not_allowed_with_crossed_book" },
    { 138, "Ask_side_quote_not_allowed" },
    { 139, "Ask_side_quote_with_qty_not_allowed" },
    { 140, "Invalid_change_LP_session" },
    { 144, "On_Book_Trading_disabled_for_Instrument_Type" },
    { 145, "LP_licence_not_assigned" },
    { 146, "SP_licence_not_assigned" },
    { 147, "Liquidity_provider_protection_bid_side_cancelled" },
    { 148, "Liquidity_provider_protection_ask_side_cancelled" },
    { 149, "Quantity_Limit_Exceeded_Instrument" },
    { 150, "Value_Limit_Exceeded_Instrument" },
    { 151, "Issuer_Stopped" },
    { 152, "Partial_Exec_Of_QRS_Order" },
    { 153, "Matching_Quote_Not_Allowed_In_Current_State" },
    { 155, "Outside_Quoting_Period" },
    { 156, "Match_Price_Not_On_Price_Step" },
    { 161, "Quantity_Limit_Exceeds_TSL" },
    { 162, "Invalid_TradingSessionSubID_for_Instrument" },
    { 163, "Too_Many_Orders_and_Quotes_in_Order_Book" },
    { 164, "Inactive_Cover" },
    { 165, "Indicative_Quote_not_allowed_in_current_state" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext quote_entry_reject_reason_vals_ext = VALUE_STRING_EXT_INIT(quote_entry_reject_reason_vals);
static const value_string quote_entry_status_vals[] = { // QuoteEntryStatus
    { 0, "Accepted" },
    { 5, "Rejected" },
    { 6, "Removed_and_Rejected" },
    { 10, "Pending" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_event_liquidity_ind_vals[] = { // QuoteEventLiquidityInd
    { 1, "Added_Liquidity" },
    { 2, "Removed_Liquidity" },
    { 4, "Auction" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_event_reason_vals[] = { // QuoteEventReason
    { 14, "Pending_cancellation_executed" },
    { 15, "Invalid_price" },
    { 16, "Cross_rejected" },
    { 18, "PLP" },
    { 19, "Price_not_Top_of_Book" },
    { 20, "Random_Selection" },
    { 21, "Manual_Selection" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext quote_event_reason_vals_ext = VALUE_STRING_EXT_INIT(quote_event_reason_vals);
static const value_string quote_event_side_vals[] = { // QuoteEventSide
    { 1, "Buy" },
    { 2, "Sell" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_event_type_vals[] = { // QuoteEventType
    { 2, "Modified_quote_side" },
    { 3, "Removed_quote_side" },
    { 4, "Partially_filled" },
    { 5, "Filled" },
    { 6, "Removed_Quantity" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_request_reject_reason_vals[] = { // QuoteRequestRejectReason
    { 2, "Exchange_closed" },
    { 99, "Other" },
    { 100, "Requested_size_too_small" },
    { 101, "Requested_size_too_big" },
    { 102, "No_valid_quote_from_issuer" },
    { 103, "Sold_out" },
    { 104, "Trading_restriction" },
    { 105, "Pending_request_timed_out" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext quote_request_reject_reason_vals_ext = VALUE_STRING_EXT_INIT(quote_request_reject_reason_vals);
static const value_string quote_size_type_vals[] = { // QuoteSizeType
    { 1, "TotalSize" },
    { 2, "OpenSize" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_status_vals[] = { // QuoteStatus
    { 6, "Removed" },
    { 7, "Expired" },
    { 16, "Active" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_type_vals[] = { // QuoteType
    { 0, "Indicative" },
    { 1, "Tradeable" },
    { 101, "Tradeable_Matching" },
    { 102, "Tradeable_PWT" },
    { 103, "Special_Auction" },
    { 104, "PWT_within_Special_Auction" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quoting_status_vals[] = { // QuotingStatus
    { 1, "Open_Active" },
    { 2, "Open_Idle" },
    { 3, "Closed_Inactive" },
    { 4, "Open_Not_Responded" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string rfqpublish_indicator_vals[] = { // RFQPublishIndicator
    { 1, "Market_Data" },
    { 2, "Designated_Sponsor" },
    { 3, "Market_Data_and_Designated_Sponsor" },
    { 4, "Market_Maker_and_Designated_Sponsor" },
    { 5, "Market_Data_and_Market_Maker_and_Designated_Sponsor" },
    { 6, "Specialist" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// RFQRequesterDisclosureInstruction aliased by NumberOfRespDisclosureInstruction
// RefApplID aliased by ApplID
// RefinancingEligibilityIndicator aliased by NumberOfRespDisclosureInstruction
// RequestingPartyIDEnteringFirm aliased by PartyIDEnteringFirm
static const value_string requesting_party_idexecuting_system_vals[] = { // RequestingPartyIDExecutingSystem
    { 2, "T7" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string respondent_type_vals[] = { // RespondentType
    { 2, "Specified_market_participants" },
    { 100, "Specified_and_SmartRfQ_selected_participants" },
    { 101, "SmartRfQ_selected_participants" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// RootPartyIDInvestmentDecisionMakerQualifier aliased by ExecutingTraderQualifier
static const value_string security_status_vals[] = { // SecurityStatus
    { 6, "Knocked_out" },
    { 7, "Knock_out_revoked" },
    { 12, "Knocked_out_and_suspend" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string security_trading_status_vals[] = { // SecurityTradingStatus
    { 7, "Market_Imbalance_Buy" },
    { 8, "Market_Imbalance_Sell" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// SelectiveRequestForQuoteRtmServiceStatus aliased by ApplSeqStatus
// SelectiveRequestForQuoteServiceStatus aliased by ApplSeqStatus
static const value_string session_mode_vals[] = { // SessionMode
    { 1, "HF" },
    { 2, "LF" },
    { 3, "GUI" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string session_reject_reason_vals[] = { // SessionRejectReason
    { 1, "Required_Tag_Missing" },
    { 5, "Value_is_incorrect" },
    { 7, "Decryption_problem" },
    { 11, "Invalid_MsgID" },
    { 16, "Incorrect_NumInGroup_count" },
    { 99, "Other" },
    { 100, "Throttle_Limit_Exceeded" },
    { 101, "Exposure_Limit_Exceeded" },
    { 102, "Service_Temporarily_Not_Available" },
    { 103, "Service_Not_Available" },
    { 105, "Outbound_conversion_error" },
    { 152, "Heartbeat_Violation" },
    { 200, "Internal_technical_error" },
    { 210, "Validation_Error" },
    { 211, "User_Already_Logged_In" },
    { 216, "Gateway_Is_Standby" },
    { 217, "Session_Login_Limit_Reached" },
    { 223, "User_Entitlement_Data_Timeout" },
    { 224, "PSGateway_Session_Limit_Reached" },
    { 225, "User_Login_Limit_Reached" },
    { 226, "Outstanding_Logins_Bu_Limit_Reached" },
    { 227, "Outstanding_Logins_Session_Limit_Reached" },
    { 10000, "Order_Not_Found" },
    { 10001, "Price_Not_Reasonable" },
    { 10002, "ClientOrderID_Not_Unique" },
    { 10003, "Quote_Activation_In_Progress" },
    { 10006, "Stop_Bid_Price_Not_Reasonable" },
    { 10007, "Stop_Ask_Price_Not_Reasonable" },
    { 10008, "Order_Not_Executable_Within_Validity" },
    { 10009, "Invalid_Trading_Restriction_For_Instrument_State" },
    { 10011, "Transaction_Not_Allowed_In_Current_State" },
    { 10012, "Order_not_accepted_in_Volatility_Freeze" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext session_reject_reason_vals_ext = VALUE_STRING_EXT_INIT(session_reject_reason_vals);
static const value_string session_status_vals[] = { // SessionStatus
    { 0, "Active" },
    { 4, "Logout" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string session_sub_mode_vals[] = { // SessionSubMode
    { 0, "Regular_trading_session" },
    { 1, "FIX_trading_session" },
    { 2, "Regular_Back_Office_session" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// Side aliased by QuoteEventSide
// SideLiquidityInd aliased by QuoteEventLiquidityInd
static const value_string sold_out_indicator_vals[] = { // SoldOutIndicator
    { 0, "Revert_sold_out" },
    { 1, "Sold_out" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string stop_px_indicator_vals[] = { // StopPxIndicator
    { 0, "Do_not_overwrite" },
    { 1, "Overwrite" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// T7EntryServiceRtmStatus aliased by ApplSeqStatus
// T7EntryServiceStatus aliased by ApplSeqStatus
static const value_string time_in_force_vals[] = { // TimeInForce
    { 0, "Day" },
    { 1, "GTC" },
    { 3, "IOC" },
    { 4, "FOK" },
    { 5, "GTX" },
    { 6, "GTD" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trad_ses_event_vals[] = { // TradSesEvent
    { 101, "Start_of_Service" },
    { 102, "Market_Reset" },
    { 103, "End_of_Restatement" },
    { 104, "End_of_Day_Service" },
    { 105, "Service_Resumed" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trad_ses_mode_vals[] = { // TradSesMode
    { 1, "Testing" },
    { 2, "Simulated" },
    { 3, "Production" },
    { 4, "Acceptance" },
    { 5, "Disaster_Recovery" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trade_alloc_status_vals[] = { // TradeAllocStatus
    { 1, "Pending" },
    { 2, "Approved" },
    { 3, "Auto_Approved" },
    { 4, "Uploaded" },
    { 5, "Canceled" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// TradeAtCloseOptIn aliased by NumberOfRespDisclosureInstruction
// TradeManagerStatus aliased by ApplSeqStatus
static const value_string trade_publish_indicator_vals[] = { // TradePublishIndicator
    { 2, "Deferred_Publication" },
    { 3, "Published" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trade_report_type_vals[] = { // TradeReportType
    { 0, "Submit" },
    { 2, "Accept" },
    { 3, "Decline" },
    { 5, "No_Was_Replaced" },
    { 6, "Trade_Report_Cancel" },
    { 7, "Trade_Break" },
    { 11, "Alleged_New" },
    { 13, "Alleged_No_Was" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext trade_report_type_vals_ext = VALUE_STRING_EXT_INIT(trade_report_type_vals);
static const value_string trading_capacity_vals[] = { // TradingCapacity
    { 1, "Customer" },
    { 3, "Broker_dealer" },
    { 5, "Principal" },
    { 6, "Market_Maker" },
    { 9, "Riskless_Principal" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trading_session_sub_id_vals[] = { // TradingSessionSubID
    { 2, "Opening_auction" },
    { 4, "Closing_auction" },
    { 6, "Intraday_Auction" },
    { 8, "Any_Auction" },
    { 105, "Special_Auction" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string transaction_delay_indicator_vals[] = { // TransactionDelayIndicator
    { 0, "Not_delayed" },
    { 1, "Delayed" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string transfer_reason_vals[] = { // TransferReason
    { 1, "Owner" },
    { 2, "Clearer" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trd_rpt_status_vals[] = { // TrdRptStatus
    { 0, "Accepted" },
    { 1, "Rejected" },
    { 2, "Cancelled" },
    { 4, "Pending_New" },
    { 7, "Terminated" },
    { 9, "Deemed_Verified" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trd_type_vals[] = { // TrdType
    { 54, "OTC" },
    { 1005, "LIS" },
    { 1006, "Enlight" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string triggered_vals[] = { // Triggered
    { 0, "Not_triggered" },
    { 1, "Triggered_Stop" },
    { 2, "Triggered_OCO" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string user_status_vals[] = { // UserStatus
    { 7, "User_forced_logout" },
    { 10, "User_stopped" },
    { 11, "User_released" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string value_check_type_quantity_vals[] = { // ValueCheckTypeQuantity
    { 0, "Do_not_check" },
    { 1, "Check" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// ValueCheckTypeValue aliased by ValueCheckTypeQuantity

enum ETI_Type {
    ETI_EOF,
    ETI_PADDING,
    ETI_UINT,
    ETI_INT,
    ETI_UINT_ENUM,
    ETI_INT_ENUM,
    ETI_COUNTER,
    ETI_FIXED_POINT,
    ETI_TIMESTAMP_NS,
    ETI_CHAR,
    ETI_STRING,
    ETI_VAR_STRING,
    ETI_STRUCT,
    ETI_VAR_STRUCT,
    ETI_DSCP
};

struct ETI_Field {
    uint8_t  type;
    uint8_t  counter_off;      // offset into counter array
                               // if ETI_COUNTER => storage
                               // if ETI_VAR_STRING or ETI_VAR_STRUCT => load
                               // to get length or repeat count
                               // if ETI_FIXED_POINT: #fractional digits
    uint16_t size;             // or offset into struct_names if ETI_STRUCT/ETI_VAR_STRUCT
    uint16_t field_handle_idx; // or index into fields array if ETI_STRUCT/ETI_VAR_STRUT
    uint16_t ett_idx;          // index into ett array if ETI_STRUCT/ETI_VAR_STRUCT
                               // or max value if ETI_COUNTER
};

static gint ett_xti[32];
static gint ett_xti_dscp;
/* This method dissects fully reassembled messages */
static int
dissect_xti_message(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
    col_set_str(pinfo->cinfo, COL_PROTOCOL, "XTI");
    col_clear(pinfo->cinfo, COL_INFO);
    guint16 templateid = tvb_get_letohs(tvb, 4);
    const char *template_str = val_to_str_ext(templateid, &template_id_vals_ext, "Unknown XTI template: 0x%04x");
    col_add_str(pinfo->cinfo, COL_INFO, template_str);

    /* create display subtree for the protocol */
    proto_item *ti = proto_tree_add_item(tree, proto_xti, tvb, 0, -1, ENC_NA);
    guint32 bodylen= tvb_get_letohl(tvb, 0);
    proto_item_append_text(ti, ", %s (%" PRIu16 "), BodyLen: %u", template_str, templateid, bodylen);
    proto_tree *root = proto_item_add_subtree(ti, ett_xti[0]);

    static const char struct_names[] = "AffectedOrdGrp\0AffectedOrderRequestsGrp\0EnrichmentRulesGrp\0FillsGrp\0MessageHeaderIn\0MessageHeaderOut\0NRBCHeader\0NRResponseHeaderME\0NotAffectedOrdersGrp\0NotAffectedSecuritiesGrp\0NotifHeader\0OrderBookItemGrp\0OrderEventGrp\0PartyDetailsGrp\0QuoteEntryAckGrp\0QuoteEntryGrp\0QuoteEventGrp\0RBCHeader\0RBCHeaderME\0RequestHeader\0ResponseHeader\0ResponseHeaderME\0SRQSHitQuoteGrp\0SRQSQuoteEntryGrp\0SRQSQuoteGrp\0SRQSTargetPartyTrdGrp\0SecurityStatusEventGrp\0SessionsGrp\0SideAllocGrp\0SideAllocGrpBC\0XetraEnLightTargetParties";
    static const struct ETI_Field fields[] = {
        // AffectedOrdGrpComp@0
          { ETI_UINT, 0, 8, AFFECTEDORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, AFFECTEDORIGCLORDID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // AffectedOrderRequestsGrpComp@3
        , { ETI_UINT, 0, 4, AFFECTEDORDERREQUESTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // EnrichmentRulesGrpComp@6
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // FillsGrpComp@12
        , { ETI_FIXED_POINT, 8, 8, FILLPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, FILLQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, FILLMATCHID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, FILLEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, FILLLIQUIDITYIND_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // MessageHeaderInComp@19
        , { ETI_UINT, 0, 4, BODYLEN_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, TEMPLATEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 8, NETWORKMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // MessageHeaderOutComp@24
        , { ETI_UINT, 0, 4, BODYLEN_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, TEMPLATEID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NRBCHeaderComp@28
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NRResponseHeaderMEComp@34
        , { ETI_TIMESTAMP_NS, 0, 8, REQUESTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEOUT_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, RESPONSEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NotAffectedOrdersGrpComp@43
        , { ETI_UINT, 0, 8, NOTAFFECTEDORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, NOTAFFORIGCLORDID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NotAffectedSecuritiesGrpComp@46
        , { ETI_UINT, 0, 8, NOTAFFECTEDSECURITYID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NotifHeaderComp@48
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderBookItemGrpComp@50
        , { ETI_FIXED_POINT, 8, 8, BESTBIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BESTBIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BESTOFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BESTOFFERSIZE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MDBOOKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MDSUBBOOKTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderEventGrpComp@58
        , { ETI_FIXED_POINT, 8, 8, ORDEREVENTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDEREVENTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDEREVENTMATCHID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDEREVENTREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PartyDetailsGrpComp@64
        , { ETI_UINT, 0, 4, PARTYDETAILIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYDETAILEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILROLEQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, PARTYDETAILDESKID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteEntryAckGrpComp@71
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLSIZE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 4, QUOTEENTRYREJECTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEENTRYSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteEntryGrpComp@78
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteEventGrpComp@84
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEEVENTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, QUOTEEVENTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEMSGID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, QUOTEEVENTMATCHID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, QUOTEEVENTEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTSIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTLIQUIDITYIND_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RBCHeaderComp@96
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, APPLSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLRESENDFLAG_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RBCHeaderMEComp@105
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEOUT_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, NOTIFICATIONIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLMSGID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLRESENDFLAG_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RequestHeaderComp@116
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SENDERSUBID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ResponseHeaderComp@119
        , { ETI_TIMESTAMP_NS, 0, 8, REQUESTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ResponseHeaderMEComp@124
        , { ETI_TIMESTAMP_NS, 0, 8, REQUESTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEOUT_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, RESPONSEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLMSGID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSHitQuoteGrpComp@135
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSQuoteEntryGrpComp@140
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, SECONDARYQUOTEID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTINGSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSQuoteGrpComp@154
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSTargetPartyTrdGrpComp@156
        , { ETI_FIXED_POINT, 4, 8, SIDELASTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SecurityStatusEventGrpComp@164
        , { ETI_FIXED_POINT, 8, 8, EVENTPX_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EVENTDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EVENTTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SessionsGrpComp@169
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SESSIONMODE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SESSIONSUBMODE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SideAllocGrpComp@174
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, INDIVIDUALALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SideAllocGrpBCComp@182
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, INDIVIDUALALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEALLOCSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightTargetPartiesComp@191
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ApproveTESTradeRequest@196
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BroadcastErrorNotification@224
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 177, 48, 11 } // NotifHeader
        , { ETI_UINT_ENUM, 0, 4, APPLIDSTATUS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, REFAPPLSUBID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SESSIONSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // CrossRequest@234
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // CrossRequestResponse@241
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderBroadcast@245
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDORDERS_FH_IDX, 500 } // <- counter@0
        , { ETI_COUNTER, 1, 2, NOAFFECTEDORDERS_FH_IDX, 500 } // <- counter@1
        , { ETI_COUNTER, 2, 2, NOAFFECTEDORDERREQUESTS_FH_IDX, 500 } // <- counter@2
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 131, 43, 9 } // NotAffectedOrdersGrp
        , { ETI_VAR_STRUCT, 1, 0, 0, 1 } // AffectedOrdGrp
        , { ETI_VAR_STRUCT, 2, 15, 3, 2 } // AffectedOrderRequestsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderNRResponse@266
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderQuoteEventBroadcast@270
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderRequest@279
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderResponse@293
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 332, 124, 22 } // ResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDORDERS_FH_IDX, 500 } // <- counter@0
        , { ETI_COUNTER, 1, 2, NOAFFECTEDORDERS_FH_IDX, 500 } // <- counter@1
        , { ETI_COUNTER, 2, 2, NOAFFECTEDORDERREQUESTS_FH_IDX, 500 } // <- counter@2
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 131, 43, 9 } // NotAffectedOrdersGrp
        , { ETI_VAR_STRUCT, 1, 0, 0, 1 } // AffectedOrdGrp
        , { ETI_VAR_STRUCT, 2, 15, 3, 2 } // AffectedOrderRequestsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllQuoteBroadcast@304
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, TARGETPARTYIDDESKID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 152, 46, 10 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllQuoteRequest@319
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllQuoteResponse@329
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 152, 46, 10 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderBroadcast@336
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDEREVENTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderNRResponse@361
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderResponse@377
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 332, 124, 22 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderSingleRequest@393
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteTESTradeRequest@411
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // EnterTESTradeRequest@421
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRFXRATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@0
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 453, 174, 30 } // SideAllocGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ExtendedDeletionReport@437
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYLOWQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYHIGHQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, VOLUMEDISCOVERYPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PEGOFFSETVALUEABS_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, PEGOFFSETVALUEPCT_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ForcedLogoutNotification@487
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 177, 48, 11 } // NotifHeader
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ForcedUserLogoutNotification@493
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 177, 48, 11 } // NotifHeader
        , { ETI_UINT, 0, 4, USERNAME_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, USERSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // Heartbeat@501
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_EOF, 0, 0, 0, 0 }
        // HeartbeatNotification@503
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 177, 48, 11 } // NotifHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireEnrichmentRuleIDListRequest@506
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireEnrichmentRuleIDListResponse@510
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOENRICHMENTRULES_FH_IDX, 400 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 40, 6, 3 } // EnrichmentRulesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireSessionListRequest@517
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireSessionListResponse@520
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_COUNTER, 0, 2, NOSESSIONS_FH_IDX, 1000 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 441, 169, 28 } // SessionsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireUserRequest@526
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireUserResponse@530
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOPARTYDETAILS_FH_IDX, 1000 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 220, 64, 14 } // PartyDetailsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // IssuerNotification@537
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, POTENTIALEXECVOLUME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, IMBALANCEQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SECURITYTRADINGSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // IssuerSecurityStateChangeRequest@550
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOEVENTS_FH_IDX, 2 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, SECURITYSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SOLDOUTINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 418, 164, 27 } // SecurityStatusEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // IssuerSecurityStateChangeResponse@561
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, SECURITYSTATUSREPORTID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LegalNotificationBroadcast@565
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, USERSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogonRequest@573
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 4, HEARTBTINT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, DEFAULTCSTMAPPLVERID_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PASSWORD_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, APPLUSAGEORDERS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, APPLUSAGEQUOTES_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDERROUTINGINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, FIXENGINENAME_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, FIXENGINEVERSION_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, FIXENGINEVENDOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, APPLICATIONSYSTEMNAME_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, APPLICATIONSYSTEMVERSION_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, APPLICATIONSYSTEMVENDOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogonResponse@590
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_INT, 0, 8, THROTTLETIMEINTERVAL_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLENOMSGS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLEDISCONNECTLIMIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, HEARTBTINT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SESSIONINSTANCEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, MARKETID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESMODE_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, DEFAULTCSTMAPPLVERID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, DEFAULTCSTMAPPLVERSUBID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogoutRequest@603
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogoutResponse@606
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // MassQuoteRequest@609
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESIZETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOQUOTEENTRIES_FH_IDX, 100 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 253, 78, 16 } // QuoteEntryGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // MassQuoteResponse@630
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, QUOTERESPONSEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOQUOTESIDEENTRIES_FH_IDX, 200 } // <- counter@0
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 236, 71, 15 } // QuoteEntryAckGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderNRResponse@639
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 206, 58, 13 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderResponse@662
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 332, 124, 22 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 206, 58, 13 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderSingleRequest@686
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYLOWQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYHIGHQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, VOLUMEDISCOVERYPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PEGOFFSETVALUEABS_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, PEGOFFSETVALUEPCT_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, STOPPXINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, OWNERSHIPINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderSingleShortRequest@732
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyTESTradeRequest@758
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@0
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 453, 174, 30 } // SideAllocGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderNRResponse@774
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 206, 58, 13 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderResponse@793
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 332, 124, 22 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 206, 58, 13 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderSingleRequest@814
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYLOWQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYHIGHQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, VOLUMEDISCOVERYPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PEGOFFSETVALUEABS_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, PEGOFFSETVALUEPCT_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEATCLOSEOPTIN_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderSingleShortRequest@858
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewsBroadcast@883
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, ORIGTIME_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_STRING, 0, 256, HEADLINE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderExecNotification@891
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDEREVENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOFILLS_FH_IDX, 100 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@1
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 59, 12, 4 } // FillsGrp
        , { ETI_VAR_STRUCT, 1, 206, 58, 13 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderExecReportBroadcast@919
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYLOWQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYHIGHQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, VOLUMEDISCOVERYPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PEGOFFSETVALUEABS_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, PEGOFFSETVALUEPCT_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDEREVENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOFILLS_FH_IDX, 100 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEATCLOSEOPTIN_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 59, 12, 4 } // FillsGrp
        , { ETI_VAR_STRUCT, 1, 206, 58, 13 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderExecResponse@979
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 332, 124, 22 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DISPLAYQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOFILLS_FH_IDX, 100 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@1
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 59, 12, 4 } // FillsGrp
        , { ETI_VAR_STRUCT, 1, 206, 58, 13 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // PartyActionReport@1008
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, REQUESTINGPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 4, REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, MARKETID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYACTIONTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REQUESTINGPARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PartyEntitlementsUpdateReport@1020
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYDETAILIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 4, REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, MARKETID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, LISTUPDATEACTION_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, REQUESTINGPARTYENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, REQUESTINGPARTYCLEARINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PingRequest@1033
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PingResponse@1038
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteActivationNotification@1042
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 152, 46, 10 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteActivationRequest@1054
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteActivationResponse@1065
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 152, 46, 10 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteExecutionReport@1072
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOQUOTEEVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 267, 84, 17 } // QuoteEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // RFQBroadcast@1080
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RFQRejectNotification@1090
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEREQUESTREJECTREASON_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RFQRequest@1100
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RFQPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RFQREQUESTERDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RFQResponse@1111
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RFQSpecialistBroadcast@1115
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // Reject@1126
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_UINT_ENUM, 0, 4, SESSIONREJECTREASON_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, SESSIONSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitMEMessageRequest@1134
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 4, SUBSCRIPTIONSCOPE_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLBEGMSGID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLENDMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitMEMessageResponse@1143
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_UINT, 0, 2, APPLTOTALMESSAGECOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLENDMSGID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, REFAPPLLASTMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitRequest@1150
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, APPLBEGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, APPLENDSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitResponse@1158
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_UINT, 0, 8, APPLENDSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, REFAPPLLASTSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, APPLTOTALMESSAGECOUNT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ServiceAvailabilityBroadcast@1165
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 101, 28, 7 } // NRBCHeader
        , { ETI_UINT, 0, 4, MATCHINGENGINETRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEMANAGERTRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSEQTRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, T7ENTRYSERVICETRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, T7ENTRYSERVICERTMTRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHINGENGINESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEMANAGERSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, T7ENTRYSERVICESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, T7ENTRYSERVICERTMSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ServiceAvailabilityMarketBroadcast@1180
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 101, 28, 7 } // NRBCHeader
        , { ETI_UINT, 0, 4, SELECTIVEREQUESTFORQUOTESERVICETRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SELECTIVEREQUESTFORQUOTESERVICESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SELECTIVEREQUESTFORQUOTERTMSERVICESTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SingleQuoteRequest@1187
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRFXRATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESIZETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistDeleteAllOrderBroadcast@1214
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOAFFECTEDORDERS_FH_IDX, 500 } // <- counter@0
        , { ETI_COUNTER, 1, 2, NONOTAFFECTEDORDERS_FH_IDX, 500 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 0, 0, 1 } // AffectedOrdGrp
        , { ETI_VAR_STRUCT, 1, 131, 43, 9 } // NotAffectedOrdersGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistInstrumentEventNotification@1227
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EVENTTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistOrderBookNotification@1235
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOFILLS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDEREVENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_VAR_STRUCT, 0, 59, 12, 4 } // FillsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistRFQRejectRequest@1282
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEREQUESTREJECTREASON_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistRFQReplyNotification@1291
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistRFQReplyRequest@1304
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistRFQReplyResponse@1316
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistSecurityStateChangeRequest@1320
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EVENTTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SpecialistSecurityStateChangeResponse@1327
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 112, 34, 8 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, SECURITYSTATUSREPORTID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SubscribeRequest@1331
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 4, SUBSCRIPTIONSCOPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SubscribeResponse@1337
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESApproveBroadcast@1342
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRFXRATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, AUTOAPPROVALRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEALLOCSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESBroadcast@1380
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRFXRATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, AUTOAPPROVALRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@1
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 466, 182, 29 } // SideAllocGrpBC
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESDeleteBroadcast@1406
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, DELETEREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESExecutionBroadcast@1420
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESResponse@1434
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESTradeBroadcast@1439
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRAMT_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SIDEGROSSTRADEAMT_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRFXRATE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, ACCRUEDINTERESAMT_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 7, 8, COUPONRATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIDETRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDSETTLEMENTUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCONTRAUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCONTRASETTLEMENTUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORIGTRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCLEARINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMDAYSINTEREST_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SRQSRELATEDTRADEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, LASTMKT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSFERREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, DELIVERYTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTCOUPONDEVIATIONINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFINANCINGELIGIBILITYINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CLEARINGINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, SETTLCURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCLEARINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYEXECUTINGFIRMKVNUMBER_FH_IDX, 0 }
        , { ETI_STRING, 0, 35, ROOTPARTYSETTLEMENTACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, ROOTPARTYSETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYSETTLEMENTFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCONTRAFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCONTRASETTLEMENTFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYCONTRAFIRMKVNUMBER_FH_IDX, 0 }
        , { ETI_STRING, 0, 35, ROOTPARTYCONTRASETTLEMENTACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, ROOTPARTYCONTRASETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYIDEXECUTIONVENUE_FH_IDX, 0 }
        , { ETI_STRING, 0, 52, REGULATORYTRADEID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESTradingSessionStatusBroadcast@1506
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TMTradingSessionStatusBroadcast@1512
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ThrottleUpdateNotification@1517
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 177, 48, 11 } // NotifHeader
        , { ETI_INT, 0, 8, THROTTLETIMEINTERVAL_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLENOMSGS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLEDISCONNECTLIMIT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TradeBroadcast@1523
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRAMT_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SETTLCURRFXRATE_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SIDEGROSSTRADEAMT_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, ACCRUEDINTERESAMT_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 7, 8, COUPONRATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORIGTRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDSETTLEMENTUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCLEARINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCONTRAUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCONTRASETTLEMENTUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSPECIALISTTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIDETRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIDETRADEREPORTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADENUMBER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRDMATCHID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMDAYSINTEREST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, LASTMKT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSFERREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDELIQUIDITYIND_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, DELIVERYTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTCOUPONDEVIATIONINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFINANCINGELIGIBILITYINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CLEARINGINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, SETTLCURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, CURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDERCATEGORY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCLEARINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYEXECUTINGFIRMKVNUMBER_FH_IDX, 0 }
        , { ETI_STRING, 0, 35, ROOTPARTYSETTLEMENTACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, ROOTPARTYSETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYSETTLEMENTFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCONTRAFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCONTRASETTLEMENTFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYCONTRAFIRMKVNUMBER_FH_IDX, 0 }
        , { ETI_STRING, 0, 35, ROOTPARTYCONTRASETTLEMENTACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, ROOTPARTYCONTRASETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYSPECIALISTFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYSPECIALISTTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 52, REGULATORYTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYIDEXECUTIONVENUE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TradingSessionStatusBroadcast@1603
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, REFAPPLLASTMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TrailingStopUpdateNotification@1611
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 291, 105, 19 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDERIDSFX_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UnsubscribeRequest@1629
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 4, REFAPPLSUBID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UnsubscribeResponse@1634
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLoginRequest@1637
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 4, USERNAME_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PASSWORD_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLoginResponse@1643
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLogoutRequest@1646
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 4, USERNAME_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLogoutResponse@1651
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightCreateDealNotification@1654
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ALLOCMETHOD_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDERBOOKITEMS_FH_IDX, 26 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 189, 50, 12 } // OrderBookItemGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightDealResponse@1690
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SECONDARYTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightEnterQuoteRequest@1701
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightHitQuoteRequest@1725
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ALLOCMETHOD_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightNegotiationNotification@1751
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightNegotiationRequesterNotification@1771
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSEXECUTIONTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESTATUS_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 481, 191, 31 } // XetraEnLightTargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightNegotiationStatusNotification@1796
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightOpenNegotiationNotification@1804
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, NEGOTIATIONSTARTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXPIRETIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RESPONDENTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightOpenNegotiationRequest@1829
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, VALIDUNTILTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEQUANTITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RESPONDENTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, QUOTEREQID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 481, 191, 31 } // XetraEnLightTargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightOpenNegotiationRequesterNotification@1851
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXPIRETIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESTATUS_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RESPONDENTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 481, 191, 31 } // XetraEnLightTargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightQuoteNotification@1878
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, SECONDARYQUOTEID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTINGSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTREASON_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, QUOTEREQID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, FREETEXT4_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightQuoteRequesterNotification@1900
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, QUOTEREQID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOQUOTEENTRIES_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 365, 140, 24 } // SRQSQuoteEntryGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightQuoteResponse@1910
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 317, 119, 21 } // ResponseHeader
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, QUOTEREQID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightQuotingStatusRequest@1916
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTINGSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightStatusBroadcast@1925
        , { ETI_STRUCT, 0, 84, 24, 6 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 281, 96, 18 } // RBCHeader
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // XetraEnLightUpdateNegotiationRequest@1931
        , { ETI_STRUCT, 0, 68, 19, 5 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 303, 116, 20 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SETTLDATE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTECANCELTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 481, 191, 31 } // XetraEnLightTargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
    };
    static const int16_t tid2fidx[] = {
          573 /* LogonRequest */
        , 590 /* LogonResponse */
        , 603 /* LogoutRequest */
        , 606 /* LogoutResponse */
        , -1
        , 1337 /* SubscribeResponse */
        , 1629 /* UnsubscribeRequest */
        , 1634 /* UnsubscribeResponse */
        , 1150 /* RetransmitRequest */
        , 1158 /* RetransmitResponse */
        , 1126 /* Reject */
        , 501 /* Heartbeat */
        , 487 /* ForcedLogoutNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1637 /* UserLoginRequest */
        , 1643 /* UserLoginResponse */
        , -1
        , -1
        , -1
        , 503 /* HeartbeatNotification */
        , 1651 /* UserLogoutResponse */
        , 1331 /* SubscribeRequest */
        , 1134 /* RetransmitMEMessageRequest */
        , 1143 /* RetransmitMEMessageResponse */
        , 1517 /* ThrottleUpdateNotification */
        , 1646 /* UserLogoutRequest */
        , 1165 /* ServiceAvailabilityBroadcast */
        , 883 /* NewsBroadcast */
        , 224 /* BroadcastErrorNotification */
        , -1
        , 1020 /* PartyEntitlementsUpdateReport */
        , 517 /* InquireSessionListRequest */
        , 520 /* InquireSessionListResponse */
        , 565 /* LegalNotificationBroadcast */
        , 526 /* InquireUserRequest */
        , 530 /* InquireUserResponse */
        , 506 /* InquireEnrichmentRuleIDListRequest */
        , 510 /* InquireEnrichmentRuleIDListResponse */
        , 1008 /* PartyActionReport */
        , 493 /* ForcedUserLogoutNotification */
        , 1180 /* ServiceAvailabilityMarketBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 814 /* NewOrderSingleRequest */
        , 793 /* NewOrderResponse */
        , 774 /* NewOrderNRResponse */
        , 979 /* OrderExecResponse */
        , 891 /* OrderExecNotification */
        , -1
        , 686 /* ModifyOrderSingleRequest */
        , 662 /* ModifyOrderResponse */
        , 639 /* ModifyOrderNRResponse */
        , 393 /* DeleteOrderSingleRequest */
        , 377 /* DeleteOrderResponse */
        , 361 /* DeleteOrderNRResponse */
        , 336 /* DeleteOrderBroadcast */
        , -1
        , -1
        , -1
        , -1
        , 919 /* OrderExecReportBroadcast */
        , 234 /* CrossRequest */
        , 241 /* CrossRequestResponse */
        , 279 /* DeleteAllOrderRequest */
        , 293 /* DeleteAllOrderResponse */
        , 245 /* DeleteAllOrderBroadcast */
        , -1
        , 266 /* DeleteAllOrderNRResponse */
        , 858 /* NewOrderSingleShortRequest */
        , 732 /* ModifyOrderSingleShortRequest */
        , 1611 /* TrailingStopUpdateNotification */
        , 437 /* ExtendedDeletionReport */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1235 /* SpecialistOrderBookNotification */
        , 1214 /* SpecialistDeleteAllOrderBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1603 /* TradingSessionStatusBroadcast */
        , 270 /* DeleteAllOrderQuoteEventBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , 550 /* IssuerSecurityStateChangeRequest */
        , 561 /* IssuerSecurityStateChangeResponse */
        , 537 /* IssuerNotification */
        , 1320 /* SpecialistSecurityStateChangeRequest */
        , 1327 /* SpecialistSecurityStateChangeResponse */
        , 1227 /* SpecialistInstrumentEventNotification */
        , 1033 /* PingRequest */
        , 1038 /* PingResponse */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1100 /* RFQRequest */
        , 1111 /* RFQResponse */
        , 1054 /* QuoteActivationRequest */
        , 1065 /* QuoteActivationResponse */
        , 609 /* MassQuoteRequest */
        , 630 /* MassQuoteResponse */
        , 1072 /* QuoteExecutionReport */
        , 319 /* DeleteAllQuoteRequest */
        , 329 /* DeleteAllQuoteResponse */
        , 304 /* DeleteAllQuoteBroadcast */
        , 1042 /* QuoteActivationNotification */
        , -1
        , -1
        , -1
        , 1080 /* RFQBroadcast */
        , -1
        , -1
        , 1187 /* SingleQuoteRequest */
        , 1115 /* RFQSpecialistBroadcast */
        , 1090 /* RFQRejectNotification */
        , 1282 /* SpecialistRFQRejectRequest */
        , 1304 /* SpecialistRFQReplyRequest */
        , 1316 /* SpecialistRFQReplyResponse */
        , 1291 /* SpecialistRFQReplyNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1523 /* TradeBroadcast */
        , 1512 /* TMTradingSessionStatusBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 421 /* EnterTESTradeRequest */
        , 758 /* ModifyTESTradeRequest */
        , 411 /* DeleteTESTradeRequest */
        , 196 /* ApproveTESTradeRequest */
        , 1380 /* TESBroadcast */
        , -1
        , 1406 /* TESDeleteBroadcast */
        , 1342 /* TESApproveBroadcast */
        , -1
        , -1
        , 1420 /* TESExecutionBroadcast */
        , 1434 /* TESResponse */
        , -1
        , -1
        , 1439 /* TESTradeBroadcast */
        , 1506 /* TESTradingSessionStatusBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1829 /* XetraEnLightOpenNegotiationRequest */
        , 1931 /* XetraEnLightUpdateNegotiationRequest */
        , 1701 /* XetraEnLightEnterQuoteRequest */
        , 1910 /* XetraEnLightQuoteResponse */
        , 1725 /* XetraEnLightHitQuoteRequest */
        , 1690 /* XetraEnLightDealResponse */
        , -1
        , 1878 /* XetraEnLightQuoteNotification */
        , 1654 /* XetraEnLightCreateDealNotification */
        , -1
        , 1851 /* XetraEnLightOpenNegotiationRequesterNotification */
        , 1804 /* XetraEnLightOpenNegotiationNotification */
        , 1771 /* XetraEnLightNegotiationRequesterNotification */
        , 1751 /* XetraEnLightNegotiationNotification */
        , 1925 /* XetraEnLightStatusBroadcast */
        , 1796 /* XetraEnLightNegotiationStatusNotification */
        , 1900 /* XetraEnLightQuoteRequesterNotification */
        , 1916 /* XetraEnLightQuotingStatusRequest */
    };
    static const uint32_t tid2size[818][2] = {
          { 280, 280 } /* LogonRequest */
        , { 96, 96 } /* LogonResponse */
        , { 24, 24 } /* LogoutRequest */
        , { 32, 32 } /* LogoutResponse */
        , { 0, 0}
        , { 40, 40 } /* SubscribeResponse */
        , { 32, 32 } /* UnsubscribeRequest */
        , { 32, 32 } /* UnsubscribeResponse */
        , { 48, 48 } /* RetransmitRequest */
        , { 56, 56 } /* RetransmitResponse */
        , { 64, 2064 } /* Reject */
        , { 16, 16 } /* Heartbeat */
        , { 24, 2024 } /* ForcedLogoutNotification */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 64, 64 } /* UserLoginRequest */
        , { 32, 32 } /* UserLoginResponse */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 16, 16 } /* HeartbeatNotification */
        , { 32, 32 } /* UserLogoutResponse */
        , { 32, 32 } /* SubscribeRequest */
        , { 64, 64 } /* RetransmitMEMessageRequest */
        , { 72, 72 } /* RetransmitMEMessageResponse */
        , { 32, 32 } /* ThrottleUpdateNotification */
        , { 32, 32 } /* UserLogoutRequest */
        , { 56, 56 } /* ServiceAvailabilityBroadcast */
        , { 312, 2312 } /* NewsBroadcast */
        , { 32, 2032 } /* BroadcastErrorNotification */
        , { 0, 0}
        , { 88, 88 } /* PartyEntitlementsUpdateReport */
        , { 24, 24 } /* InquireSessionListRequest */
        , { 48, 8040 } /* InquireSessionListResponse */
        , { 56, 2056 } /* LegalNotificationBroadcast */
        , { 40, 40 } /* InquireUserRequest */
        , { 56, 16056 } /* InquireUserResponse */
        , { 40, 40 } /* InquireEnrichmentRuleIDListRequest */
        , { 56, 19256 } /* InquireEnrichmentRuleIDListResponse */
        , { 72, 72 } /* PartyActionReport */
        , { 24, 2024 } /* ForcedUserLogoutNotification */
        , { 32, 32 } /* ServiceAvailabilityMarketBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 248, 248 } /* NewOrderSingleRequest */
        , { 152, 2552 } /* NewOrderResponse */
        , { 120, 2520 } /* NewOrderNRResponse */
        , { 184, 5784 } /* OrderExecResponse */
        , { 176, 5776 } /* OrderExecNotification */
        , { 0, 0}
        , { 256, 256 } /* ModifyOrderSingleRequest */
        , { 176, 2576 } /* ModifyOrderResponse */
        , { 152, 2552 } /* ModifyOrderNRResponse */
        , { 120, 120 } /* DeleteOrderSingleRequest */
        , { 144, 144 } /* DeleteOrderResponse */
        , { 128, 128 } /* DeleteOrderNRResponse */
        , { 184, 184 } /* DeleteOrderBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 360, 5960 } /* OrderExecReportBroadcast */
        , { 48, 48 } /* CrossRequest */
        , { 64, 64 } /* CrossRequestResponse */
        , { 72, 72 } /* DeleteAllOrderRequest */
        , { 88, 20088 } /* DeleteAllOrderResponse */
        , { 120, 20120 } /* DeleteAllOrderBroadcast */
        , { 0, 0}
        , { 64, 64 } /* DeleteAllOrderNRResponse */
        , { 104, 104 } /* NewOrderSingleShortRequest */
        , { 112, 112 } /* ModifyOrderSingleShortRequest */
        , { 160, 160 } /* TrailingStopUpdateNotification */
        , { 344, 344 } /* ExtendedDeletionReport */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 264, 3464 } /* SpecialistOrderBookNotification */
        , { 88, 16088 } /* SpecialistDeleteAllOrderBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 96, 96 } /* TradingSessionStatusBroadcast */
        , { 88, 88 } /* DeleteAllOrderQuoteEventBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 48, 80 } /* IssuerSecurityStateChangeRequest */
        , { 64, 64 } /* IssuerSecurityStateChangeResponse */
        , { 128, 128 } /* IssuerNotification */
        , { 40, 40 } /* SpecialistSecurityStateChangeRequest */
        , { 64, 64 } /* SpecialistSecurityStateChangeResponse */
        , { 88, 88 } /* SpecialistInstrumentEventNotification */
        , { 32, 32 } /* PingRequest */
        , { 64, 64 } /* PingResponse */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 56, 56 } /* RFQRequest */
        , { 64, 64 } /* RFQResponse */
        , { 56, 56 } /* QuoteActivationRequest */
        , { 72, 4072 } /* QuoteActivationResponse */
        , { 72, 4072 } /* MassQuoteRequest */
        , { 80, 4880 } /* MassQuoteResponse */
        , { 128, 4880 } /* QuoteExecutionReport */
        , { 56, 56 } /* DeleteAllQuoteRequest */
        , { 72, 4072 } /* DeleteAllQuoteResponse */
        , { 104, 4104 } /* DeleteAllQuoteBroadcast */
        , { 88, 4088 } /* QuoteActivationNotification */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 104, 104 } /* RFQBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 160, 160 } /* SingleQuoteRequest */
        , { 112, 112 } /* RFQSpecialistBroadcast */
        , { 104, 104 } /* RFQRejectNotification */
        , { 56, 56 } /* SpecialistRFQRejectRequest */
        , { 88, 88 } /* SpecialistRFQReplyRequest */
        , { 64, 64 } /* SpecialistRFQReplyResponse */
        , { 136, 136 } /* SpecialistRFQReplyNotification */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 504, 504 } /* TradeBroadcast */
        , { 48, 48 } /* TMTradingSessionStatusBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 144, 3280 } /* EnterTESTradeRequest */
        , { 136, 3272 } /* ModifyTESTradeRequest */
        , { 64, 64 } /* DeleteTESTradeRequest */
        , { 160, 160 } /* ApproveTESTradeRequest */
        , { 192, 5328 } /* TESBroadcast */
        , { 0, 0}
        , { 88, 88 } /* TESDeleteBroadcast */
        , { 224, 2224 } /* TESApproveBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 72, 72 } /* TESExecutionBroadcast */
        , { 56, 56 } /* TESResponse */
        , { 0, 0}
        , { 0, 0}
        , { 440, 440 } /* TESTradeBroadcast */
        , { 48, 48 } /* TESTradingSessionStatusBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 248, 1048 } /* XetraEnLightOpenNegotiationRequest */
        , { 208, 1008 } /* XetraEnLightUpdateNegotiationRequest */
        , { 152, 152 } /* XetraEnLightEnterQuoteRequest */
        , { 64, 64 } /* XetraEnLightQuoteResponse */
        , { 160, 160 } /* XetraEnLightHitQuoteRequest */
        , { 104, 104 } /* XetraEnLightDealResponse */
        , { 0, 0}
        , { 184, 184 } /* XetraEnLightQuoteNotification */
        , { 240, 1280 } /* XetraEnLightCreateDealNotification */
        , { 0, 0}
        , { 296, 1096 } /* XetraEnLightOpenNegotiationRequesterNotification */
        , { 296, 296 } /* XetraEnLightOpenNegotiationNotification */
        , { 296, 1096 } /* XetraEnLightNegotiationRequesterNotification */
        , { 272, 272 } /* XetraEnLightNegotiationNotification */
        , { 48, 48 } /* XetraEnLightStatusBroadcast */
        , { 80, 80 } /* XetraEnLightNegotiationStatusNotification */
        , { 80, 8080 } /* XetraEnLightQuoteRequesterNotification */
        , { 48, 48 } /* XetraEnLightQuotingStatusRequest */
    };
    static const unsigned char usages[] = {
        // ApproveTESTradeRequest
        //// MessageHeaderInComp
          0 // BodyLen#0
        , 0 // TemplateID#1
        , 2 // NetworkMsgID#2
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#3
        , 0 // SenderSubID#4
        ///
        , 1 // PartyIDClientID#5
        , 1 // PartyIdInvestmentDecisionMaker#6
        , 1 // ExecutingTrader#7
        , 0 // AllocQty#8
        , 0 // PackageID#9
        , 0 // AllocID#10
        , 0 // TESExecID#11
        , 0 // MarketSegmentID#12
        , 0 // TrdType#13
        , 0 // TradingCapacity#14
        , 0 // TradeReportType#15
        , 0 // Side#16
        , 0 // ValueCheckTypeValue#17
        , 0 // ValueCheckTypeQuantity#18
        , 0 // OrderAttributeLiquidityProvision#19
        , 1 // PartyIdInvestmentDecisionMakerQualifier#20
        , 0 // ExecutingTraderQualifier#21
        , 1 // OrderOrigination#22
        , 1 // TradeReportID#23
        , 0 // PartyExecutingFirm#24
        , 0 // PartyExecutingTrader#25
        , 1 // FreeText1#26
        , 1 // FreeText2#27
        , 1 // FreeText4#28
        // BroadcastErrorNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#29
        , 0 // TemplateID#30
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#31
        ///
        , 0 // ApplIDStatus#32
        , 1 // RefApplSubID#33
        , 0 // VarTextLen#34
        , 0 // RefApplID#35
        , 0 // SessionStatus#36
        , 0 // VarText#37
        // CrossRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#38
        , 0 // TemplateID#39
        , 2 // NetworkMsgID#40
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#41
        , 0 // SenderSubID#42
        ///
        , 0 // SecurityID#43
        , 0 // OrderQty#44
        , 0 // MarketSegmentID#45
        // CrossRequestResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#46
        , 0 // TemplateID#47
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#48
        , 0 // TrdRegTSTimeIn#49
        , 0 // TrdRegTSTimeOut#50
        , 0 // ResponseIn#51
        , 0 // SendingTime#52
        , 0 // MsgSeqNum#53
        , 0 // LastFragment#54
        ///
        , 0 // ExecID#55
        // DeleteAllOrderBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#56
        , 0 // TemplateID#57
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#58
        , 1 // NotificationIn#59
        , 0 // SendingTime#60
        , 1 // ApplSubID#61
        , 0 // PartitionID#62
        , 0 // ApplMsgID#63
        , 0 // ApplID#64
        , 0 // ApplResendFlag#65
        , 0 // LastFragment#66
        ///
        , 0 // MassActionReportID#67
        , 1 // SecurityID#68
        , 1 // Price#69
        , 0 // MarketSegmentID#70
        , 0 // TargetPartyIDSessionID#71
        , 1 // TargetPartyIDExecutingTrader#72
        , 1 // PartyIDEnteringTrader#73
        , 0 // NoNotAffectedOrders#74
        , 0 // NoAffectedOrders#75
        , 0 // NoAffectedOrderRequests#76
        , 1 // PartyIDEnteringFirm#77
        , 0 // MassActionReason#78
        , 0 // ExecInst#79
        , 1 // Side#80
        //// NotAffectedOrdersGrpComp
        , 0 // NotAffectedOrderID#81
        , 1 // NotAffOrigClOrdID#82
        ///
        //// AffectedOrdGrpComp
        , 0 // AffectedOrderID#83
        , 1 // AffectedOrigClOrdID#84
        ///
        //// AffectedOrderRequestsGrpComp
        , 0 // AffectedOrderRequestID#85
        ///
        // DeleteAllOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#86
        , 0 // TemplateID#87
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#88
        , 0 // TrdRegTSTimeIn#89
        , 0 // TrdRegTSTimeOut#90
        , 0 // ResponseIn#91
        , 0 // SendingTime#92
        , 0 // MsgSeqNum#93
        , 0 // LastFragment#94
        ///
        , 0 // MassActionReportID#95
        // DeleteAllOrderQuoteEventBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#96
        , 0 // TemplateID#97
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#98
        , 1 // NotificationIn#99
        , 0 // SendingTime#100
        , 1 // ApplSubID#101
        , 0 // PartitionID#102
        , 1 // ApplMsgID#103
        , 0 // ApplID#104
        , 0 // ApplResendFlag#105
        , 0 // LastFragment#106
        ///
        , 0 // MassActionReportID#107
        , 1 // SecurityID#108
        , 0 // MarketSegmentID#109
        , 0 // MassActionReason#110
        , 1 // ExecInst#111
        // DeleteAllOrderRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#112
        , 0 // TemplateID#113
        , 2 // NetworkMsgID#114
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#115
        , 0 // SenderSubID#116
        ///
        , 1 // SecurityID#117
        , 1 // Price#118
        , 1 // PartyIdInvestmentDecisionMaker#119
        , 1 // ExecutingTrader#120
        , 0 // MarketSegmentID#121
        , 1 // TargetPartyIDSessionID#122
        , 1 // TargetPartyIDExecutingTrader#123
        , 1 // Side#124
        , 1 // OrderOrigination#125
        , 1 // PartyIdInvestmentDecisionMakerQualifier#126
        , 0 // ExecutingTraderQualifier#127
        // DeleteAllOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#128
        , 0 // TemplateID#129
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#130
        , 0 // TrdRegTSTimeIn#131
        , 0 // TrdRegTSTimeOut#132
        , 0 // ResponseIn#133
        , 0 // SendingTime#134
        , 0 // MsgSeqNum#135
        , 0 // PartitionID#136
        , 0 // ApplID#137
        , 0 // ApplMsgID#138
        , 0 // LastFragment#139
        ///
        , 0 // MassActionReportID#140
        , 0 // NoNotAffectedOrders#141
        , 0 // NoAffectedOrders#142
        , 0 // NoAffectedOrderRequests#143
        //// NotAffectedOrdersGrpComp
        , 0 // NotAffectedOrderID#144
        , 1 // NotAffOrigClOrdID#145
        ///
        //// AffectedOrdGrpComp
        , 0 // AffectedOrderID#146
        , 1 // AffectedOrigClOrdID#147
        ///
        //// AffectedOrderRequestsGrpComp
        , 0 // AffectedOrderRequestID#148
        ///
        // DeleteAllQuoteBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#149
        , 0 // TemplateID#150
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#151
        , 1 // NotificationIn#152
        , 0 // SendingTime#153
        , 2 // ApplSubID#154
        , 0 // PartitionID#155
        , 1 // ApplMsgID#156
        , 0 // ApplID#157
        , 0 // ApplResendFlag#158
        , 0 // LastFragment#159
        ///
        , 0 // MassActionReportID#160
        , 2 // SecurityID#161
        , 0 // MarketSegmentID#162
        , 0 // TargetPartyIDSessionID#163
        , 1 // PartyIDEnteringTrader#164
        , 1 // TargetPartyIDExecutingTrader#165
        , 0 // NoNotAffectedSecurities#166
        , 0 // MassActionReason#167
        , 1 // PartyIDEnteringFirm#168
        , 1 // TargetPartyIDDeskID#169
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#170
        ///
        // DeleteAllQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#171
        , 0 // TemplateID#172
        , 2 // NetworkMsgID#173
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#174
        , 0 // SenderSubID#175
        ///
        , 1 // PartyIdInvestmentDecisionMaker#176
        , 1 // ExecutingTrader#177
        , 0 // MarketSegmentID#178
        , 1 // TargetPartyIDSessionID#179
        , 1 // PartyIdInvestmentDecisionMakerQualifier#180
        , 0 // ExecutingTraderQualifier#181
        // DeleteAllQuoteResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#182
        , 0 // TemplateID#183
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#184
        , 1 // TrdRegTSTimeIn#185
        , 1 // TrdRegTSTimeOut#186
        , 0 // ResponseIn#187
        , 0 // SendingTime#188
        , 0 // MsgSeqNum#189
        , 0 // LastFragment#190
        ///
        , 0 // MassActionReportID#191
        , 0 // NoNotAffectedSecurities#192
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#193
        ///
        // DeleteOrderBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#194
        , 0 // TemplateID#195
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#196
        , 1 // NotificationIn#197
        , 0 // SendingTime#198
        , 1 // ApplSubID#199
        , 0 // PartitionID#200
        , 1 // ApplMsgID#201
        , 1 // ApplID#202
        , 0 // ApplResendFlag#203
        , 0 // LastFragment#204
        ///
        , 0 // OrderID#205
        , 1 // ClOrdID#206
        , 1 // OrigClOrdID#207
        , 0 // SecurityID#208
        , 0 // ExecID#209
        , 0 // CumQty#210
        , 0 // CxlQty#211
        , 1 // QuoteID#212
        , 0 // OrderIDSfx#213
        , 0 // MarketSegmentID#214
        , 1 // PartyIDEnteringTrader#215
        , 1 // PartyIDSessionID#216
        , 0 // ExecRestatementReason#217
        , 1 // PartyIDEnteringFirm#218
        , 0 // OrdStatus#219
        , 0 // ExecType#220
        , 0 // Side#221
        , 1 // OrderEventType#222
        , 1 // FIXClOrdID#223
        , 1 // PartyEnteringFirm#224
        , 1 // PartyEnteringTrader#225
        // DeleteOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#226
        , 0 // TemplateID#227
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#228
        , 0 // TrdRegTSTimeIn#229
        , 0 // TrdRegTSTimeOut#230
        , 0 // ResponseIn#231
        , 0 // SendingTime#232
        , 0 // MsgSeqNum#233
        , 0 // LastFragment#234
        ///
        , 0 // OrderID#235
        , 1 // ClOrdID#236
        , 1 // OrigClOrdID#237
        , 0 // SecurityID#238
        , 0 // ExecID#239
        , 0 // CumQty#240
        , 0 // CxlQty#241
        , 0 // OrderIDSfx#242
        , 0 // OrdStatus#243
        , 0 // ExecType#244
        , 0 // ExecRestatementReason#245
        , 0 // TransactionDelayIndicator#246
        // DeleteOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#247
        , 0 // TemplateID#248
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#249
        , 0 // TrdRegTSTimeIn#250
        , 0 // TrdRegTSTimeOut#251
        , 0 // ResponseIn#252
        , 0 // SendingTime#253
        , 0 // MsgSeqNum#254
        , 0 // PartitionID#255
        , 0 // ApplID#256
        , 1 // ApplMsgID#257
        , 0 // LastFragment#258
        ///
        , 0 // OrderID#259
        , 1 // ClOrdID#260
        , 1 // OrigClOrdID#261
        , 0 // SecurityID#262
        , 0 // ExecID#263
        , 0 // CumQty#264
        , 0 // CxlQty#265
        , 0 // OrderIDSfx#266
        , 0 // OrdStatus#267
        , 0 // ExecType#268
        , 0 // ExecRestatementReason#269
        , 0 // TransactionDelayIndicator#270
        // DeleteOrderSingleRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#271
        , 0 // TemplateID#272
        , 2 // NetworkMsgID#273
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#274
        , 0 // SenderSubID#275
        ///
        , 1 // OrderID#276
        , 1 // ClOrdID#277
        , 1 // OrigClOrdID#278
        , 0 // SecurityID#279
        , 1 // PartyIdInvestmentDecisionMaker#280
        , 1 // ExecutingTrader#281
        , 0 // MarketSegmentID#282
        , 1 // TargetPartyIDSessionID#283
        , 1 // OrderOrigination#284
        , 1 // PartyIdInvestmentDecisionMakerQualifier#285
        , 1 // ExecutingTraderQualifier#286
        , 1 // FIXClOrdID#287
        , 1 // PartyExecutingFirm#288
        , 1 // PartyExecutingTrader#289
        // DeleteTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#290
        , 0 // TemplateID#291
        , 2 // NetworkMsgID#292
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#293
        , 0 // SenderSubID#294
        ///
        , 0 // PackageID#295
        , 0 // MarketSegmentID#296
        , 0 // TESExecID#297
        , 0 // TrdType#298
        , 0 // TradeReportType#299
        , 1 // TradeReportID#300
        // EnterTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#301
        , 0 // TemplateID#302
        , 2 // NetworkMsgID#303
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#304
        , 0 // SenderSubID#305
        ///
        , 0 // SecurityID#306
        , 0 // LastPx#307
        , 1 // TransBkdTime#308
        , 1 // SettlCurrFxRate#309
        , 0 // MarketSegmentID#310
        , 1 // SettlDate#311
        , 0 // TrdType#312
        , 0 // TradeReportType#313
        , 0 // NoSideAllocs#314
        , 1 // TradeReportText#315
        , 1 // TradeReportID#316
        //// SideAllocGrpComp
        , 0 // AllocQty#317
        , 2 // IndividualAllocID#318
        , 1 // TESEnrichmentRuleID#319
        , 0 // Side#320
        , 0 // PartyExecutingFirm#321
        , 0 // PartyExecutingTrader#322
        ///
        // ExtendedDeletionReport
        //// MessageHeaderOutComp
        , 0 // BodyLen#323
        , 0 // TemplateID#324
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#325
        , 1 // NotificationIn#326
        , 0 // SendingTime#327
        , 1 // ApplSubID#328
        , 0 // PartitionID#329
        , 1 // ApplMsgID#330
        , 0 // ApplID#331
        , 0 // ApplResendFlag#332
        , 0 // LastFragment#333
        ///
        , 0 // OrderID#334
        , 1 // ClOrdID#335
        , 1 // OrigClOrdID#336
        , 0 // SecurityID#337
        , 0 // ExecID#338
        , 0 // TrdRegTSEntryTime#339
        , 1 // Price#340
        , 0 // LeavesQty#341
        , 0 // CumQty#342
        , 0 // CxlQty#343
        , 0 // OrderQty#344
        , 1 // DisplayQty#345
        , 1 // DisplayLowQty#346
        , 1 // DisplayHighQty#347
        , 1 // StopPx#348
        , 1 // VolumeDiscoveryPrice#349
        , 1 // PegOffsetValueAbs#350
        , 1 // PegOffsetValuePct#351
        , 1 // QuoteID#352
        , 0 // MarketSegmentID#353
        , 0 // OrderIDSfx#354
        , 1 // ExpireDate#355
        , 1 // MatchInstCrossID#356
        , 0 // PartyIDExecutingUnit#357
        , 0 // PartyIDSessionID#358
        , 0 // PartyIDExecutingTrader#359
        , 1 // PartyIDEnteringTrader#360
        , 0 // ExecRestatementReason#361
        , 0 // OrdStatus#362
        , 0 // ExecType#363
        , 0 // Side#364
        , 0 // OrdType#365
        , 0 // TradingCapacity#366
        , 1 // TimeInForce#367
        , 1 // ExecInst#368
        , 1 // TradingSessionSubID#369
        , 1 // ApplSeqIndicator#370
        , 1 // FreeText1#371
        , 1 // FreeText2#372
        , 1 // FreeText4#373
        , 1 // PartyEnteringFirm#374
        , 1 // PartyEnteringTrader#375
        , 0 // PartyExecutingFirm#376
        , 0 // PartyExecutingTrader#377
        , 1 // FIXClOrdID#378
        , 0 // Triggered#379
        // ForcedLogoutNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#380
        , 0 // TemplateID#381
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#382
        ///
        , 0 // VarTextLen#383
        , 0 // VarText#384
        // ForcedUserLogoutNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#385
        , 0 // TemplateID#386
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#387
        ///
        , 0 // Username#388
        , 0 // VarTextLen#389
        , 0 // UserStatus#390
        , 0 // VarText#391
        // Heartbeat
        //// MessageHeaderInComp
        , 0 // BodyLen#392
        , 0 // TemplateID#393
        , 2 // NetworkMsgID#394
        ///
        // HeartbeatNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#395
        , 0 // TemplateID#396
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#397
        ///
        // InquireEnrichmentRuleIDListRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#398
        , 0 // TemplateID#399
        , 2 // NetworkMsgID#400
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#401
        , 2 // SenderSubID#402
        ///
        , 1 // LastEntityProcessed#403
        // InquireEnrichmentRuleIDListResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#404
        , 0 // TemplateID#405
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#406
        , 0 // SendingTime#407
        , 0 // MsgSeqNum#408
        ///
        , 1 // LastEntityProcessed#409
        , 0 // NoEnrichmentRules#410
        //// EnrichmentRulesGrpComp
        , 0 // EnrichmentRuleID#411
        , 1 // FreeText1#412
        , 1 // FreeText2#413
        , 1 // FreeText4#414
        ///
        // InquireSessionListRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#415
        , 0 // TemplateID#416
        , 2 // NetworkMsgID#417
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#418
        , 2 // SenderSubID#419
        ///
        // InquireSessionListResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#420
        , 0 // TemplateID#421
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#422
        , 0 // SendingTime#423
        , 0 // MsgSeqNum#424
        ///
        , 0 // NoSessions#425
        //// SessionsGrpComp
        , 0 // PartyIDSessionID#426
        , 0 // SessionMode#427
        , 1 // SessionSubMode#428
        ///
        // InquireUserRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#429
        , 0 // TemplateID#430
        , 2 // NetworkMsgID#431
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#432
        , 2 // SenderSubID#433
        ///
        , 1 // LastEntityProcessed#434
        // InquireUserResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#435
        , 0 // TemplateID#436
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#437
        , 0 // SendingTime#438
        , 0 // MsgSeqNum#439
        ///
        , 1 // LastEntityProcessed#440
        , 0 // NoPartyDetails#441
        //// PartyDetailsGrpComp
        , 0 // PartyDetailIDExecutingTrader#442
        , 0 // PartyDetailExecutingTrader#443
        , 0 // PartyDetailRoleQualifier#444
        , 0 // PartyDetailStatus#445
        , 1 // PartyDetailDeskID#446
        ///
        // IssuerNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#447
        , 0 // TemplateID#448
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#449
        , 1 // NotificationIn#450
        , 0 // SendingTime#451
        , 2 // ApplSubID#452
        , 0 // PartitionID#453
        , 2 // ApplMsgID#454
        , 0 // ApplID#455
        , 0 // ApplResendFlag#456
        , 0 // LastFragment#457
        ///
        , 0 // SecurityID#458
        , 0 // TransactTime#459
        , 1 // LastPx#460
        , 1 // PotentialExecVolume#461
        , 1 // LastQty#462
        , 1 // ImbalanceQty#463
        , 0 // MarketSegmentID#464
        , 1 // PartyIDSessionID#465
        , 1 // SecurityTradingStatus#466
        // IssuerSecurityStateChangeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#467
        , 0 // TemplateID#468
        , 2 // NetworkMsgID#469
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#470
        , 0 // SenderSubID#471
        ///
        , 0 // SecurityID#472
        , 1 // TransactTime#473
        , 0 // MarketSegmentID#474
        , 1 // NoEvents#475
        , 1 // SecurityStatus#476
        , 1 // SoldOutIndicator#477
        //// SecurityStatusEventGrpComp
        , 1 // EventPx#478
        , 1 // EventDate#479
        , 0 // EventType#480
        ///
        // IssuerSecurityStateChangeResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#481
        , 0 // TemplateID#482
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#483
        , 0 // TrdRegTSTimeIn#484
        , 0 // TrdRegTSTimeOut#485
        , 0 // ResponseIn#486
        , 0 // SendingTime#487
        , 0 // MsgSeqNum#488
        , 0 // LastFragment#489
        ///
        , 0 // SecurityStatusReportID#490
        // LegalNotificationBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#491
        , 0 // TemplateID#492
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#493
        , 0 // ApplSeqNum#494
        , 2 // ApplSubID#495
        , 0 // PartitionID#496
        , 0 // ApplResendFlag#497
        , 0 // ApplID#498
        , 0 // LastFragment#499
        ///
        , 0 // TransactTime#500
        , 0 // VarTextLen#501
        , 0 // UserStatus#502
        , 0 // VarText#503
        // LogonRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#504
        , 0 // TemplateID#505
        , 2 // NetworkMsgID#506
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#507
        , 2 // SenderSubID#508
        ///
        , 1 // HeartBtInt#509
        , 0 // PartyIDSessionID#510
        , 0 // DefaultCstmApplVerID#511
        , 0 // Password#512
        , 0 // ApplUsageOrders#513
        , 0 // ApplUsageQuotes#514
        , 0 // OrderRoutingIndicator#515
        , 1 // FIXEngineName#516
        , 1 // FIXEngineVersion#517
        , 1 // FIXEngineVendor#518
        , 0 // ApplicationSystemName#519
        , 0 // ApplicationSystemVersion#520
        , 0 // ApplicationSystemVendor#521
        // LogonResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#522
        , 0 // TemplateID#523
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#524
        , 0 // SendingTime#525
        , 0 // MsgSeqNum#526
        ///
        , 0 // ThrottleTimeInterval#527
        , 0 // ThrottleNoMsgs#528
        , 0 // ThrottleDisconnectLimit#529
        , 0 // HeartBtInt#530
        , 0 // SessionInstanceID#531
        , 0 // MarketID#532
        , 0 // TradSesMode#533
        , 0 // DefaultCstmApplVerID#534
        , 0 // DefaultCstmApplVerSubID#535
        // LogoutRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#536
        , 0 // TemplateID#537
        , 2 // NetworkMsgID#538
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#539
        , 2 // SenderSubID#540
        ///
        // LogoutResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#541
        , 0 // TemplateID#542
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#543
        , 0 // SendingTime#544
        , 0 // MsgSeqNum#545
        ///
        // MassQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#546
        , 0 // TemplateID#547
        , 2 // NetworkMsgID#548
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#549
        , 0 // SenderSubID#550
        ///
        , 0 // QuoteID#551
        , 1 // PartyIdInvestmentDecisionMaker#552
        , 1 // ExecutingTrader#553
        , 0 // MarketSegmentID#554
        , 1 // MatchInstCrossID#555
        , 1 // EnrichmentRuleID#556
        , 0 // PriceValidityCheckType#557
        , 0 // ValueCheckTypeValue#558
        , 0 // ValueCheckTypeQuantity#559
        , 0 // QuoteSizeType#560
        , 0 // QuoteType#561
        , 0 // TradingCapacity#562
        , 0 // OrderAttributeLiquidityProvision#563
        , 0 // NoQuoteEntries#564
        , 1 // PartyIdInvestmentDecisionMakerQualifier#565
        , 0 // ExecutingTraderQualifier#566
        //// QuoteEntryGrpComp
        , 0 // SecurityID#567
        , 1 // BidPx#568
        , 1 // BidSize#569
        , 1 // OfferPx#570
        , 1 // OfferSize#571
        ///
        // MassQuoteResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#572
        , 0 // TemplateID#573
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#574
        , 0 // TrdRegTSTimeIn#575
        , 0 // TrdRegTSTimeOut#576
        , 0 // ResponseIn#577
        , 0 // SendingTime#578
        , 0 // MsgSeqNum#579
        , 0 // LastFragment#580
        ///
        , 0 // QuoteID#581
        , 0 // QuoteResponseID#582
        , 0 // MarketSegmentID#583
        , 0 // NoQuoteSideEntries#584
        //// QuoteEntryAckGrpComp
        , 0 // SecurityID#585
        , 1 // CxlSize#586
        , 1 // QuoteEntryRejectReason#587
        , 0 // QuoteEntryStatus#588
        , 0 // Side#589
        ///
        // ModifyOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#590
        , 0 // TemplateID#591
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#592
        , 0 // TrdRegTSTimeIn#593
        , 0 // TrdRegTSTimeOut#594
        , 0 // ResponseIn#595
        , 0 // SendingTime#596
        , 0 // MsgSeqNum#597
        , 0 // LastFragment#598
        ///
        , 0 // OrderID#599
        , 1 // ClOrdID#600
        , 1 // OrigClOrdID#601
        , 0 // SecurityID#602
        , 0 // ExecID#603
        , 1 // StopPx#604
        , 0 // LeavesQty#605
        , 0 // CumQty#606
        , 0 // CxlQty#607
        , 1 // DisplayQty#608
        , 0 // OrderIDSfx#609
        , 0 // OrdStatus#610
        , 0 // ExecType#611
        , 0 // ExecRestatementReason#612
        , 0 // CrossedIndicator#613
        , 0 // Triggered#614
        , 0 // TransactionDelayIndicator#615
        , 0 // NoOrderEvents#616
        //// OrderEventGrpComp
        , 0 // OrderEventPx#617
        , 0 // OrderEventQty#618
        , 0 // OrderEventMatchID#619
        , 0 // OrderEventReason#620
        ///
        // ModifyOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#621
        , 0 // TemplateID#622
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#623
        , 0 // TrdRegTSTimeIn#624
        , 0 // TrdRegTSTimeOut#625
        , 0 // ResponseIn#626
        , 0 // SendingTime#627
        , 0 // MsgSeqNum#628
        , 0 // PartitionID#629
        , 0 // ApplID#630
        , 1 // ApplMsgID#631
        , 0 // LastFragment#632
        ///
        , 0 // OrderID#633
        , 1 // ClOrdID#634
        , 1 // OrigClOrdID#635
        , 0 // SecurityID#636
        , 0 // ExecID#637
        , 1 // StopPx#638
        , 0 // LeavesQty#639
        , 0 // CumQty#640
        , 0 // CxlQty#641
        , 1 // DisplayQty#642
        , 0 // TrdRegTSTimePriority#643
        , 0 // OrderIDSfx#644
        , 0 // OrdStatus#645
        , 0 // ExecType#646
        , 0 // ExecRestatementReason#647
        , 0 // CrossedIndicator#648
        , 0 // Triggered#649
        , 0 // TransactionDelayIndicator#650
        , 0 // NoOrderEvents#651
        //// OrderEventGrpComp
        , 0 // OrderEventPx#652
        , 0 // OrderEventQty#653
        , 0 // OrderEventMatchID#654
        , 0 // OrderEventReason#655
        ///
        // ModifyOrderSingleRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#656
        , 0 // TemplateID#657
        , 2 // NetworkMsgID#658
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#659
        , 0 // SenderSubID#660
        ///
        , 1 // OrderID#661
        , 1 // ClOrdID#662
        , 1 // OrigClOrdID#663
        , 0 // SecurityID#664
        , 1 // Price#665
        , 0 // OrderQty#666
        , 1 // DisplayQty#667
        , 1 // DisplayLowQty#668
        , 1 // DisplayHighQty#669
        , 1 // StopPx#670
        , 1 // VolumeDiscoveryPrice#671
        , 1 // PegOffsetValueAbs#672
        , 1 // PegOffsetValuePct#673
        , 1 // PartyIDClientID#674
        , 1 // PartyIdInvestmentDecisionMaker#675
        , 1 // ExecutingTrader#676
        , 1 // ExpireDate#677
        , 0 // MarketSegmentID#678
        , 1 // MatchInstCrossID#679
        , 1 // TargetPartyIDSessionID#680
        , 0 // ApplSeqIndicator#681
        , 0 // Side#682
        , 0 // OrdType#683
        , 0 // PriceValidityCheckType#684
        , 0 // ValueCheckTypeValue#685
        , 0 // ValueCheckTypeQuantity#686
        , 0 // OrderAttributeLiquidityProvision#687
        , 0 // TimeInForce#688
        , 0 // ExecInst#689
        , 1 // TradingSessionSubID#690
        , 1 // StopPxIndicator#691
        , 0 // TradingCapacity#692
        , 1 // OrderOrigination#693
        , 1 // PartyIdInvestmentDecisionMakerQualifier#694
        , 1 // ExecutingTraderQualifier#695
        , 0 // OwnershipIndicator#696
        , 1 // PartyExecutingFirm#697
        , 1 // PartyExecutingTrader#698
        , 1 // FreeText1#699
        , 1 // FreeText2#700
        , 1 // FreeText4#701
        , 1 // FIXClOrdID#702
        // ModifyOrderSingleShortRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#703
        , 0 // TemplateID#704
        , 2 // NetworkMsgID#705
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#706
        , 0 // SenderSubID#707
        ///
        , 1 // ClOrdID#708
        , 0 // OrigClOrdID#709
        , 0 // SecurityID#710
        , 0 // Price#711
        , 0 // OrderQty#712
        , 1 // PartyIDClientID#713
        , 1 // PartyIdInvestmentDecisionMaker#714
        , 1 // ExecutingTrader#715
        , 1 // MatchInstCrossID#716
        , 1 // EnrichmentRuleID#717
        , 0 // Side#718
        , 0 // PriceValidityCheckType#719
        , 0 // ValueCheckTypeValue#720
        , 0 // ValueCheckTypeQuantity#721
        , 0 // OrderAttributeLiquidityProvision#722
        , 0 // TimeInForce#723
        , 0 // ApplSeqIndicator#724
        , 0 // ExecInst#725
        , 0 // TradingCapacity#726
        , 1 // OrderOrigination#727
        , 1 // PartyIdInvestmentDecisionMakerQualifier#728
        , 0 // ExecutingTraderQualifier#729
        // ModifyTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#730
        , 0 // TemplateID#731
        , 2 // NetworkMsgID#732
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#733
        , 0 // SenderSubID#734
        ///
        , 0 // LastPx#735
        , 1 // TransBkdTime#736
        , 0 // MarketSegmentID#737
        , 0 // PackageID#738
        , 0 // TESExecID#739
        , 1 // SettlDate#740
        , 0 // TrdType#741
        , 0 // TradeReportType#742
        , 0 // NoSideAllocs#743
        , 1 // TradeReportText#744
        , 1 // TradeReportID#745
        //// SideAllocGrpComp
        , 0 // AllocQty#746
        , 1 // IndividualAllocID#747
        , 1 // TESEnrichmentRuleID#748
        , 0 // Side#749
        , 0 // PartyExecutingFirm#750
        , 0 // PartyExecutingTrader#751
        ///
        // NewOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#752
        , 0 // TemplateID#753
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#754
        , 0 // TrdRegTSTimeIn#755
        , 0 // TrdRegTSTimeOut#756
        , 0 // ResponseIn#757
        , 0 // SendingTime#758
        , 0 // MsgSeqNum#759
        , 0 // LastFragment#760
        ///
        , 0 // OrderID#761
        , 1 // ClOrdID#762
        , 0 // SecurityID#763
        , 0 // ExecID#764
        , 0 // LeavesQty#765
        , 0 // CxlQty#766
        , 0 // OrderIDSfx#767
        , 0 // OrdStatus#768
        , 0 // ExecType#769
        , 0 // ExecRestatementReason#770
        , 0 // CrossedIndicator#771
        , 0 // Triggered#772
        , 0 // TransactionDelayIndicator#773
        , 0 // NoOrderEvents#774
        //// OrderEventGrpComp
        , 0 // OrderEventPx#775
        , 0 // OrderEventQty#776
        , 0 // OrderEventMatchID#777
        , 0 // OrderEventReason#778
        ///
        // NewOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#779
        , 0 // TemplateID#780
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#781
        , 0 // TrdRegTSTimeIn#782
        , 0 // TrdRegTSTimeOut#783
        , 0 // ResponseIn#784
        , 0 // SendingTime#785
        , 0 // MsgSeqNum#786
        , 0 // PartitionID#787
        , 0 // ApplID#788
        , 1 // ApplMsgID#789
        , 0 // LastFragment#790
        ///
        , 0 // OrderID#791
        , 1 // ClOrdID#792
        , 0 // SecurityID#793
        , 0 // ExecID#794
        , 0 // LeavesQty#795
        , 0 // CxlQty#796
        , 0 // TrdRegTSEntryTime#797
        , 0 // TrdRegTSTimePriority#798
        , 0 // OrderIDSfx#799
        , 0 // OrdStatus#800
        , 0 // ExecType#801
        , 0 // ExecRestatementReason#802
        , 0 // CrossedIndicator#803
        , 0 // Triggered#804
        , 0 // TransactionDelayIndicator#805
        , 0 // NoOrderEvents#806
        //// OrderEventGrpComp
        , 0 // OrderEventPx#807
        , 0 // OrderEventQty#808
        , 0 // OrderEventMatchID#809
        , 0 // OrderEventReason#810
        ///
        // NewOrderSingleRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#811
        , 0 // TemplateID#812
        , 2 // NetworkMsgID#813
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#814
        , 0 // SenderSubID#815
        ///
        , 1 // Price#816
        , 0 // OrderQty#817
        , 1 // DisplayQty#818
        , 1 // DisplayLowQty#819
        , 1 // DisplayHighQty#820
        , 1 // StopPx#821
        , 1 // VolumeDiscoveryPrice#822
        , 1 // PegOffsetValueAbs#823
        , 1 // PegOffsetValuePct#824
        , 1 // ClOrdID#825
        , 0 // SecurityID#826
        , 1 // PartyIDClientID#827
        , 1 // PartyIdInvestmentDecisionMaker#828
        , 1 // ExecutingTrader#829
        , 1 // QuoteID#830
        , 1 // ExpireDate#831
        , 0 // MarketSegmentID#832
        , 1 // TargetPartyIDSessionID#833
        , 1 // MatchInstCrossID#834
        , 0 // ApplSeqIndicator#835
        , 0 // Side#836
        , 0 // OrdType#837
        , 0 // PriceValidityCheckType#838
        , 0 // ValueCheckTypeValue#839
        , 0 // ValueCheckTypeQuantity#840
        , 0 // OrderAttributeLiquidityProvision#841
        , 0 // TimeInForce#842
        , 0 // ExecInst#843
        , 1 // TradingSessionSubID#844
        , 1 // TradeAtCloseOptIn#845
        , 0 // TradingCapacity#846
        , 1 // OrderOrigination#847
        , 1 // PartyIdInvestmentDecisionMakerQualifier#848
        , 0 // ExecutingTraderQualifier#849
        , 1 // PartyExecutingFirm#850
        , 1 // PartyExecutingTrader#851
        , 1 // FreeText1#852
        , 1 // FreeText2#853
        , 1 // FreeText4#854
        , 1 // FIXClOrdID#855
        // NewOrderSingleShortRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#856
        , 0 // TemplateID#857
        , 2 // NetworkMsgID#858
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#859
        , 0 // SenderSubID#860
        ///
        , 0 // SecurityID#861
        , 0 // Price#862
        , 0 // OrderQty#863
        , 0 // ClOrdID#864
        , 1 // PartyIDClientID#865
        , 1 // PartyIdInvestmentDecisionMaker#866
        , 1 // ExecutingTrader#867
        , 1 // MatchInstCrossID#868
        , 1 // EnrichmentRuleID#869
        , 0 // Side#870
        , 0 // ApplSeqIndicator#871
        , 0 // PriceValidityCheckType#872
        , 0 // ValueCheckTypeValue#873
        , 0 // ValueCheckTypeQuantity#874
        , 0 // OrderAttributeLiquidityProvision#875
        , 0 // TimeInForce#876
        , 0 // ExecInst#877
        , 0 // TradingCapacity#878
        , 1 // OrderOrigination#879
        , 1 // PartyIdInvestmentDecisionMakerQualifier#880
        , 0 // ExecutingTraderQualifier#881
        // NewsBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#882
        , 0 // TemplateID#883
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#884
        , 1 // ApplSeqNum#885
        , 1 // ApplSubID#886
        , 0 // PartitionID#887
        , 0 // ApplResendFlag#888
        , 0 // ApplID#889
        , 0 // LastFragment#890
        ///
        , 0 // OrigTime#891
        , 0 // VarTextLen#892
        , 0 // Headline#893
        , 1 // VarText#894
        // OrderExecNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#895
        , 0 // TemplateID#896
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#897
        , 1 // NotificationIn#898
        , 0 // SendingTime#899
        , 2 // ApplSubID#900
        , 0 // PartitionID#901
        , 0 // ApplMsgID#902
        , 0 // ApplID#903
        , 0 // ApplResendFlag#904
        , 0 // LastFragment#905
        ///
        , 0 // OrderID#906
        , 1 // ClOrdID#907
        , 1 // OrigClOrdID#908
        , 0 // SecurityID#909
        , 0 // ExecID#910
        , 0 // LeavesQty#911
        , 0 // CumQty#912
        , 0 // CxlQty#913
        , 1 // DisplayQty#914
        , 0 // MarketSegmentID#915
        , 0 // OrderIDSfx#916
        , 0 // ExecRestatementReason#917
        , 0 // Side#918
        , 0 // OrdStatus#919
        , 0 // ExecType#920
        , 1 // OrderEventType#921
        , 0 // MatchType#922
        , 0 // Triggered#923
        , 0 // CrossedIndicator#924
        , 1 // FIXClOrdID#925
        , 0 // NoFills#926
        , 0 // NoOrderEvents#927
        //// FillsGrpComp
        , 0 // FillPx#928
        , 0 // FillQty#929
        , 0 // FillMatchID#930
        , 0 // FillExecID#931
        , 1 // FillLiquidityInd#932
        ///
        //// OrderEventGrpComp
        , 0 // OrderEventPx#933
        , 0 // OrderEventQty#934
        , 0 // OrderEventMatchID#935
        , 0 // OrderEventReason#936
        ///
        // OrderExecReportBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#937
        , 0 // TemplateID#938
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#939
        , 1 // NotificationIn#940
        , 0 // SendingTime#941
        , 1 // ApplSubID#942
        , 0 // PartitionID#943
        , 1 // ApplMsgID#944
        , 0 // ApplID#945
        , 0 // ApplResendFlag#946
        , 0 // LastFragment#947
        ///
        , 0 // OrderID#948
        , 1 // ClOrdID#949
        , 1 // OrigClOrdID#950
        , 0 // SecurityID#951
        , 0 // ExecID#952
        , 0 // TrdRegTSEntryTime#953
        , 0 // TrdRegTSTimePriority#954
        , 1 // Price#955
        , 0 // LeavesQty#956
        , 0 // CumQty#957
        , 0 // CxlQty#958
        , 0 // OrderQty#959
        , 1 // DisplayQty#960
        , 1 // DisplayLowQty#961
        , 1 // DisplayHighQty#962
        , 1 // StopPx#963
        , 1 // VolumeDiscoveryPrice#964
        , 1 // PegOffsetValueAbs#965
        , 1 // PegOffsetValuePct#966
        , 1 // QuoteID#967
        , 0 // MarketSegmentID#968
        , 0 // OrderIDSfx#969
        , 1 // ExpireDate#970
        , 1 // MatchInstCrossID#971
        , 1 // PartyIDExecutingUnit#972
        , 1 // PartyIDSessionID#973
        , 1 // PartyIDExecutingTrader#974
        , 1 // PartyIDEnteringTrader#975
        , 0 // ExecRestatementReason#976
        , 1 // PartyIDEnteringFirm#977
        , 0 // OrdStatus#978
        , 0 // ExecType#979
        , 1 // OrderEventType#980
        , 1 // MatchType#981
        , 0 // Side#982
        , 0 // OrdType#983
        , 0 // TradingCapacity#984
        , 1 // TimeInForce#985
        , 1 // ExecInst#986
        , 1 // TradingSessionSubID#987
        , 1 // ApplSeqIndicator#988
        , 1 // PartyEnteringFirm#989
        , 1 // PartyEnteringTrader#990
        , 0 // PartyExecutingFirm#991
        , 0 // PartyExecutingTrader#992
        , 1 // FreeText1#993
        , 1 // FreeText2#994
        , 1 // FreeText4#995
        , 1 // FIXClOrdID#996
        , 0 // NoFills#997
        , 0 // NoOrderEvents#998
        , 0 // Triggered#999
        , 0 // CrossedIndicator#1000
        , 1 // TradeAtCloseOptIn#1001
        //// FillsGrpComp
        , 0 // FillPx#1002
        , 1 // FillQty#1003
        , 0 // FillMatchID#1004
        , 0 // FillExecID#1005
        , 1 // FillLiquidityInd#1006
        ///
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1007
        , 0 // OrderEventQty#1008
        , 0 // OrderEventMatchID#1009
        , 0 // OrderEventReason#1010
        ///
        // OrderExecResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1011
        , 0 // TemplateID#1012
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#1013
        , 0 // TrdRegTSTimeIn#1014
        , 0 // TrdRegTSTimeOut#1015
        , 0 // ResponseIn#1016
        , 0 // SendingTime#1017
        , 0 // MsgSeqNum#1018
        , 0 // PartitionID#1019
        , 0 // ApplID#1020
        , 1 // ApplMsgID#1021
        , 0 // LastFragment#1022
        ///
        , 0 // OrderID#1023
        , 1 // ClOrdID#1024
        , 1 // OrigClOrdID#1025
        , 0 // SecurityID#1026
        , 0 // ExecID#1027
        , 1 // TrdRegTSEntryTime#1028
        , 1 // TrdRegTSTimePriority#1029
        , 0 // LeavesQty#1030
        , 0 // CumQty#1031
        , 0 // CxlQty#1032
        , 1 // DisplayQty#1033
        , 0 // MarketSegmentID#1034
        , 0 // OrderIDSfx#1035
        , 0 // ExecRestatementReason#1036
        , 0 // Side#1037
        , 0 // OrdStatus#1038
        , 0 // ExecType#1039
        , 0 // MatchType#1040
        , 0 // Triggered#1041
        , 0 // CrossedIndicator#1042
        , 0 // TransactionDelayIndicator#1043
        , 0 // NoFills#1044
        , 0 // NoOrderEvents#1045
        //// FillsGrpComp
        , 0 // FillPx#1046
        , 0 // FillQty#1047
        , 0 // FillMatchID#1048
        , 0 // FillExecID#1049
        , 1 // FillLiquidityInd#1050
        ///
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1051
        , 0 // OrderEventQty#1052
        , 0 // OrderEventMatchID#1053
        , 0 // OrderEventReason#1054
        ///
        // PartyActionReport
        //// MessageHeaderOutComp
        , 0 // BodyLen#1055
        , 0 // TemplateID#1056
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1057
        , 0 // ApplSeqNum#1058
        , 2 // ApplSubID#1059
        , 0 // PartitionID#1060
        , 0 // ApplResendFlag#1061
        , 0 // ApplID#1062
        , 0 // LastFragment#1063
        ///
        , 0 // TransactTime#1064
        , 1 // TradeDate#1065
        , 1 // RequestingPartyIDExecutingTrader#1066
        , 0 // PartyIDExecutingUnit#1067
        , 1 // PartyIDExecutingTrader#1068
        , 0 // RequestingPartyIDExecutingSystem#1069
        , 1 // MarketID#1070
        , 0 // PartyActionType#1071
        , 0 // RequestingPartyIDEnteringFirm#1072
        // PartyEntitlementsUpdateReport
        //// MessageHeaderOutComp
        , 0 // BodyLen#1073
        , 0 // TemplateID#1074
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1075
        , 0 // ApplSeqNum#1076
        , 2 // ApplSubID#1077
        , 0 // PartitionID#1078
        , 0 // ApplResendFlag#1079
        , 0 // ApplID#1080
        , 0 // LastFragment#1081
        ///
        , 0 // TransactTime#1082
        , 0 // TradeDate#1083
        , 0 // PartyDetailIDExecutingUnit#1084
        , 0 // RequestingPartyIDExecutingSystem#1085
        , 1 // MarketID#1086
        , 0 // ListUpdateAction#1087
        , 0 // RequestingPartyEnteringFirm#1088
        , 1 // RequestingPartyClearingFirm#1089
        , 0 // PartyDetailStatus#1090
        // PingRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1091
        , 0 // TemplateID#1092
        , 2 // NetworkMsgID#1093
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1094
        , 0 // SenderSubID#1095
        ///
        , 0 // PartitionID#1096
        // PingResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1097
        , 0 // TemplateID#1098
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1099
        , 0 // TrdRegTSTimeIn#1100
        , 0 // TrdRegTSTimeOut#1101
        , 0 // ResponseIn#1102
        , 0 // SendingTime#1103
        , 0 // MsgSeqNum#1104
        , 0 // LastFragment#1105
        ///
        , 0 // TransactTime#1106
        // QuoteActivationNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1107
        , 0 // TemplateID#1108
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1109
        , 1 // NotificationIn#1110
        , 0 // SendingTime#1111
        , 2 // ApplSubID#1112
        , 0 // PartitionID#1113
        , 0 // ApplMsgID#1114
        , 0 // ApplID#1115
        , 0 // ApplResendFlag#1116
        , 0 // LastFragment#1117
        ///
        , 0 // MassActionReportID#1118
        , 0 // MarketSegmentID#1119
        , 1 // PartyIDEnteringTrader#1120
        , 0 // NoNotAffectedSecurities#1121
        , 1 // PartyIDEnteringFirm#1122
        , 0 // MassActionType#1123
        , 0 // MassActionReason#1124
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#1125
        ///
        // QuoteActivationRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1126
        , 0 // TemplateID#1127
        , 2 // NetworkMsgID#1128
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1129
        , 0 // SenderSubID#1130
        ///
        , 1 // PartyIdInvestmentDecisionMaker#1131
        , 1 // ExecutingTrader#1132
        , 0 // MarketSegmentID#1133
        , 0 // TargetPartyIDSessionID#1134
        , 0 // MassActionType#1135
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1136
        , 0 // ExecutingTraderQualifier#1137
        // QuoteActivationResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1138
        , 0 // TemplateID#1139
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1140
        , 1 // TrdRegTSTimeIn#1141
        , 1 // TrdRegTSTimeOut#1142
        , 0 // ResponseIn#1143
        , 0 // SendingTime#1144
        , 0 // MsgSeqNum#1145
        , 0 // LastFragment#1146
        ///
        , 0 // MassActionReportID#1147
        , 0 // NoNotAffectedSecurities#1148
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#1149
        ///
        // QuoteExecutionReport
        //// MessageHeaderOutComp
        , 0 // BodyLen#1150
        , 0 // TemplateID#1151
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1152
        , 1 // NotificationIn#1153
        , 0 // SendingTime#1154
        , 2 // ApplSubID#1155
        , 0 // PartitionID#1156
        , 1 // ApplMsgID#1157
        , 0 // ApplID#1158
        , 0 // ApplResendFlag#1159
        , 0 // LastFragment#1160
        ///
        , 0 // ExecID#1161
        , 0 // MarketSegmentID#1162
        , 0 // NoQuoteEvents#1163
        //// QuoteEventGrpComp
        , 0 // SecurityID#1164
        , 1 // QuoteEventPx#1165
        , 1 // QuoteEventQty#1166
        , 0 // QuoteMsgID#1167
        , 1 // QuoteEventMatchID#1168
        , 1 // QuoteEventExecID#1169
        , 0 // QuoteEventType#1170
        , 0 // QuoteEventSide#1171
        , 1 // QuoteEventLiquidityInd#1172
        , 1 // QuoteEventReason#1173
        ///
        // RFQBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1174
        , 0 // TemplateID#1175
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1176
        , 1 // NotificationIn#1177
        , 0 // SendingTime#1178
        , 2 // ApplSubID#1179
        , 0 // PartitionID#1180
        , 2 // ApplMsgID#1181
        , 0 // ApplID#1182
        , 0 // ApplResendFlag#1183
        , 0 // LastFragment#1184
        ///
        , 0 // SecurityID#1185
        , 0 // ExecID#1186
        , 1 // OrderQty#1187
        , 0 // MarketSegmentID#1188
        , 1 // Side#1189
        , 1 // PartyExecutingFirm#1190
        // RFQRejectNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1191
        , 0 // TemplateID#1192
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1193
        , 1 // NotificationIn#1194
        , 0 // SendingTime#1195
        , 2 // ApplSubID#1196
        , 0 // PartitionID#1197
        , 0 // ApplMsgID#1198
        , 0 // ApplID#1199
        , 0 // ApplResendFlag#1200
        , 0 // LastFragment#1201
        ///
        , 0 // SecurityID#1202
        , 0 // ExecID#1203
        , 1 // QuoteID#1204
        , 0 // MarketSegmentID#1205
        , 0 // QuoteRequestRejectReason#1206
        , 0 // PartyExecutingFirm#1207
        // RFQRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1208
        , 0 // TemplateID#1209
        , 2 // NetworkMsgID#1210
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1211
        , 0 // SenderSubID#1212
        ///
        , 0 // SecurityID#1213
        , 1 // OrderQty#1214
        , 1 // QuoteID#1215
        , 0 // MarketSegmentID#1216
        , 0 // RFQPublishIndicator#1217
        , 0 // RFQRequesterDisclosureInstruction#1218
        , 1 // Side#1219
        // RFQResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1220
        , 0 // TemplateID#1221
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1222
        , 0 // TrdRegTSTimeIn#1223
        , 0 // TrdRegTSTimeOut#1224
        , 0 // ResponseIn#1225
        , 0 // SendingTime#1226
        , 0 // MsgSeqNum#1227
        , 0 // LastFragment#1228
        ///
        , 0 // ExecID#1229
        // RFQSpecialistBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1230
        , 0 // TemplateID#1231
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1232
        , 1 // NotificationIn#1233
        , 0 // SendingTime#1234
        , 1 // ApplSubID#1235
        , 0 // PartitionID#1236
        , 0 // ApplMsgID#1237
        , 0 // ApplID#1238
        , 0 // ApplResendFlag#1239
        , 0 // LastFragment#1240
        ///
        , 0 // SecurityID#1241
        , 0 // ExecID#1242
        , 1 // OrderQty#1243
        , 1 // QuoteID#1244
        , 0 // MarketSegmentID#1245
        , 1 // Side#1246
        , 0 // PartyExecutingFirm#1247
        // Reject
        //// MessageHeaderOutComp
        , 0 // BodyLen#1248
        , 0 // TemplateID#1249
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1250
        , 1 // TrdRegTSTimeIn#1251
        , 1 // TrdRegTSTimeOut#1252
        , 1 // ResponseIn#1253
        , 0 // SendingTime#1254
        , 0 // MsgSeqNum#1255
        , 0 // LastFragment#1256
        ///
        , 0 // SessionRejectReason#1257
        , 0 // VarTextLen#1258
        , 0 // SessionStatus#1259
        , 0 // VarText#1260
        // RetransmitMEMessageRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1261
        , 0 // TemplateID#1262
        , 2 // NetworkMsgID#1263
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1264
        , 2 // SenderSubID#1265
        ///
        , 1 // SubscriptionScope#1266
        , 0 // PartitionID#1267
        , 0 // RefApplID#1268
        , 1 // ApplBegMsgID#1269
        , 1 // ApplEndMsgID#1270
        // RetransmitMEMessageResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1271
        , 0 // TemplateID#1272
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1273
        , 0 // SendingTime#1274
        , 0 // MsgSeqNum#1275
        ///
        , 0 // ApplTotalMessageCount#1276
        , 1 // ApplEndMsgID#1277
        , 1 // RefApplLastMsgID#1278
        // RetransmitRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1279
        , 0 // TemplateID#1280
        , 2 // NetworkMsgID#1281
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1282
        , 2 // SenderSubID#1283
        ///
        , 1 // ApplBegSeqNum#1284
        , 1 // ApplEndSeqNum#1285
        , 1 // PartitionID#1286
        , 0 // RefApplID#1287
        // RetransmitResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1288
        , 0 // TemplateID#1289
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1290
        , 0 // SendingTime#1291
        , 0 // MsgSeqNum#1292
        ///
        , 1 // ApplEndSeqNum#1293
        , 1 // RefApplLastSeqNum#1294
        , 0 // ApplTotalMessageCount#1295
        // ServiceAvailabilityBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1296
        , 0 // TemplateID#1297
        ///
        //// NRBCHeaderComp
        , 0 // SendingTime#1298
        , 0 // ApplSubID#1299
        , 0 // ApplID#1300
        , 0 // LastFragment#1301
        ///
        , 1 // MatchingEngineTradeDate#1302
        , 1 // TradeManagerTradeDate#1303
        , 1 // ApplSeqTradeDate#1304
        , 1 // T7EntryServiceTradeDate#1305
        , 1 // T7EntryServiceRtmTradeDate#1306
        , 0 // PartitionID#1307
        , 0 // MatchingEngineStatus#1308
        , 0 // TradeManagerStatus#1309
        , 0 // ApplSeqStatus#1310
        , 0 // T7EntryServiceStatus#1311
        , 0 // T7EntryServiceRtmStatus#1312
        // ServiceAvailabilityMarketBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1313
        , 0 // TemplateID#1314
        ///
        //// NRBCHeaderComp
        , 0 // SendingTime#1315
        , 0 // ApplSubID#1316
        , 0 // ApplID#1317
        , 0 // LastFragment#1318
        ///
        , 1 // SelectiveRequestForQuoteServiceTradeDate#1319
        , 0 // SelectiveRequestForQuoteServiceStatus#1320
        , 0 // SelectiveRequestForQuoteRtmServiceStatus#1321
        // SingleQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1322
        , 0 // TemplateID#1323
        , 2 // NetworkMsgID#1324
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1325
        , 0 // SenderSubID#1326
        ///
        , 0 // QuoteID#1327
        , 0 // SecurityID#1328
        , 1 // PartyIdInvestmentDecisionMaker#1329
        , 1 // ExecutingTrader#1330
        , 1 // BidPx#1331
        , 1 // BidSize#1332
        , 1 // OfferPx#1333
        , 1 // OfferSize#1334
        , 1 // SettlCurrFxRate#1335
        , 0 // MarketSegmentID#1336
        , 1 // MatchInstCrossID#1337
        , 0 // PriceValidityCheckType#1338
        , 0 // ValueCheckTypeValue#1339
        , 0 // ValueCheckTypeQuantity#1340
        , 0 // QuoteSizeType#1341
        , 0 // QuoteType#1342
        , 0 // TradingCapacity#1343
        , 0 // OrderAttributeLiquidityProvision#1344
        , 0 // ExecutingTraderQualifier#1345
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1346
        , 1 // FreeText1#1347
        , 1 // FreeText2#1348
        , 1 // FreeText4#1349
        // SpecialistDeleteAllOrderBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1350
        , 0 // TemplateID#1351
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1352
        , 1 // NotificationIn#1353
        , 0 // SendingTime#1354
        , 1 // ApplSubID#1355
        , 0 // PartitionID#1356
        , 0 // ApplMsgID#1357
        , 0 // ApplID#1358
        , 0 // ApplResendFlag#1359
        , 0 // LastFragment#1360
        ///
        , 0 // MassActionReportID#1361
        , 0 // MarketSegmentID#1362
        , 1 // PartyIDEnteringTrader#1363
        , 0 // NoAffectedOrders#1364
        , 0 // NoNotAffectedOrders#1365
        , 1 // PartyIDEnteringFirm#1366
        , 0 // MassActionReason#1367
        //// AffectedOrdGrpComp
        , 0 // AffectedOrderID#1368
        , 2 // AffectedOrigClOrdID#1369
        ///
        //// NotAffectedOrdersGrpComp
        , 0 // NotAffectedOrderID#1370
        , 1 // NotAffOrigClOrdID#1371
        ///
        // SpecialistInstrumentEventNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1372
        , 0 // TemplateID#1373
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1374
        , 1 // NotificationIn#1375
        , 0 // SendingTime#1376
        , 2 // ApplSubID#1377
        , 0 // PartitionID#1378
        , 2 // ApplMsgID#1379
        , 0 // ApplID#1380
        , 0 // ApplResendFlag#1381
        , 0 // LastFragment#1382
        ///
        , 0 // SecurityID#1383
        , 0 // TransactTime#1384
        , 0 // MarketSegmentID#1385
        , 0 // EventType#1386
        // SpecialistOrderBookNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1387
        , 0 // TemplateID#1388
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1389
        , 1 // NotificationIn#1390
        , 0 // SendingTime#1391
        , 1 // ApplSubID#1392
        , 0 // PartitionID#1393
        , 1 // ApplMsgID#1394
        , 0 // ApplID#1395
        , 0 // ApplResendFlag#1396
        , 0 // LastFragment#1397
        ///
        , 0 // OrderID#1398
        , 1 // ClOrdID#1399
        , 1 // OrigClOrdID#1400
        , 0 // SecurityID#1401
        , 0 // ExecID#1402
        , 0 // TrdRegTSEntryTime#1403
        , 0 // TrdRegTSTimePriority#1404
        , 1 // Price#1405
        , 0 // LeavesQty#1406
        , 0 // CumQty#1407
        , 0 // CxlQty#1408
        , 0 // OrderQty#1409
        , 1 // StopPx#1410
        , 1 // QuoteID#1411
        , 0 // MarketSegmentID#1412
        , 0 // OrderIDSfx#1413
        , 1 // ExpireDate#1414
        , 1 // PartyIDExecutingUnit#1415
        , 1 // PartyIDSessionID#1416
        , 1 // PartyIDExecutingTrader#1417
        , 1 // PartyIDEnteringTrader#1418
        , 0 // NoFills#1419
        , 0 // ExecRestatementReason#1420
        , 1 // PartyIDEnteringFirm#1421
        , 0 // OrdStatus#1422
        , 0 // ExecType#1423
        , 1 // OrderEventType#1424
        , 1 // MatchType#1425
        , 0 // Side#1426
        , 0 // OrdType#1427
        , 0 // TradingCapacity#1428
        , 1 // TimeInForce#1429
        , 1 // ExecInst#1430
        , 1 // TradingSessionSubID#1431
        , 1 // ApplSeqIndicator#1432
        , 0 // Triggered#1433
        , 0 // OrderAttributeLiquidityProvision#1434
        , 1 // PartyEnteringFirm#1435
        , 1 // PartyEnteringTrader#1436
        , 0 // PartyExecutingFirm#1437
        , 0 // PartyExecutingTrader#1438
        , 1 // FIXClOrdID#1439
        //// FillsGrpComp
        , 0 // FillPx#1440
        , 1 // FillQty#1441
        , 0 // FillMatchID#1442
        , 0 // FillExecID#1443
        , 1 // FillLiquidityInd#1444
        ///
        // SpecialistRFQRejectRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1445
        , 0 // TemplateID#1446
        , 2 // NetworkMsgID#1447
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1448
        , 0 // SenderSubID#1449
        ///
        , 0 // SecurityID#1450
        , 0 // QuoteID#1451
        , 0 // MarketSegmentID#1452
        , 0 // QuoteRequestRejectReason#1453
        , 0 // PartyExecutingFirm#1454
        // SpecialistRFQReplyNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1455
        , 0 // TemplateID#1456
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1457
        , 1 // NotificationIn#1458
        , 0 // SendingTime#1459
        , 2 // ApplSubID#1460
        , 0 // PartitionID#1461
        , 2 // ApplMsgID#1462
        , 0 // ApplID#1463
        , 0 // ApplResendFlag#1464
        , 0 // LastFragment#1465
        ///
        , 0 // SecurityID#1466
        , 0 // TransactTime#1467
        , 1 // QuoteID#1468
        , 1 // BidPx#1469
        , 1 // BidSize#1470
        , 1 // OfferPx#1471
        , 1 // OfferSize#1472
        , 0 // MarketSegmentID#1473
        , 0 // PartyExecutingFirm#1474
        // SpecialistRFQReplyRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1475
        , 0 // TemplateID#1476
        , 2 // NetworkMsgID#1477
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1478
        , 0 // SenderSubID#1479
        ///
        , 0 // SecurityID#1480
        , 0 // QuoteID#1481
        , 1 // BidPx#1482
        , 1 // BidSize#1483
        , 1 // OfferPx#1484
        , 1 // OfferSize#1485
        , 0 // MarketSegmentID#1486
        , 0 // PartyExecutingFirm#1487
        // SpecialistRFQReplyResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1488
        , 0 // TemplateID#1489
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1490
        , 0 // TrdRegTSTimeIn#1491
        , 0 // TrdRegTSTimeOut#1492
        , 0 // ResponseIn#1493
        , 0 // SendingTime#1494
        , 0 // MsgSeqNum#1495
        , 0 // LastFragment#1496
        ///
        , 0 // TransactTime#1497
        // SpecialistSecurityStateChangeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1498
        , 0 // TemplateID#1499
        , 2 // NetworkMsgID#1500
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1501
        , 0 // SenderSubID#1502
        ///
        , 0 // SecurityID#1503
        , 0 // MarketSegmentID#1504
        , 0 // EventType#1505
        // SpecialistSecurityStateChangeResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1506
        , 0 // TemplateID#1507
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1508
        , 0 // TrdRegTSTimeIn#1509
        , 0 // TrdRegTSTimeOut#1510
        , 0 // ResponseIn#1511
        , 0 // SendingTime#1512
        , 0 // MsgSeqNum#1513
        , 0 // LastFragment#1514
        ///
        , 0 // SecurityStatusReportID#1515
        // SubscribeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1516
        , 0 // TemplateID#1517
        , 2 // NetworkMsgID#1518
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1519
        , 2 // SenderSubID#1520
        ///
        , 1 // SubscriptionScope#1521
        , 0 // RefApplID#1522
        // SubscribeResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1523
        , 0 // TemplateID#1524
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1525
        , 0 // SendingTime#1526
        , 0 // MsgSeqNum#1527
        ///
        , 0 // ApplSubID#1528
        // TESApproveBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1529
        , 0 // TemplateID#1530
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1531
        , 0 // ApplSeqNum#1532
        , 1 // ApplSubID#1533
        , 0 // PartitionID#1534
        , 0 // ApplResendFlag#1535
        , 0 // ApplID#1536
        , 0 // LastFragment#1537
        ///
        , 0 // SecurityID#1538
        , 0 // LastPx#1539
        , 0 // AllocQty#1540
        , 0 // TransactTime#1541
        , 1 // TransBkdTime#1542
        , 1 // SettlCurrFxRate#1543
        , 0 // MarketSegmentID#1544
        , 0 // PackageID#1545
        , 0 // TESExecID#1546
        , 0 // AllocID#1547
        , 1 // SettlDate#1548
        , 1 // TESEnrichmentRuleID#1549
        , 1 // AutoApprovalRuleID#1550
        , 0 // TrdType#1551
        , 1 // VarTextLen#1552
        , 0 // Side#1553
        , 1 // ValueCheckTypeValue#1554
        , 1 // ValueCheckTypeQuantity#1555
        , 0 // TradeReportType#1556
        , 1 // TrdRptStatus#1557
        , 0 // TradingCapacity#1558
        , 0 // TradeAllocStatus#1559
        , 0 // MessageEventSource#1560
        , 1 // TradeReportID#1561
        , 0 // PartyExecutingFirm#1562
        , 0 // PartyExecutingTrader#1563
        , 0 // PartyIDEnteringFirm#1564
        , 0 // PartyEnteringTrader#1565
        , 1 // RootPartyExecutingFirm#1566
        , 1 // RootPartyExecutingTrader#1567
        , 1 // FreeText1#1568
        , 1 // FreeText2#1569
        , 1 // FreeText4#1570
        , 1 // VarText#1571
        // TESBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1572
        , 0 // TemplateID#1573
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1574
        , 0 // ApplSeqNum#1575
        , 1 // ApplSubID#1576
        , 0 // PartitionID#1577
        , 0 // ApplResendFlag#1578
        , 0 // ApplID#1579
        , 0 // LastFragment#1580
        ///
        , 0 // SecurityID#1581
        , 0 // LastPx#1582
        , 0 // TransactTime#1583
        , 1 // TransBkdTime#1584
        , 1 // SettlCurrFxRate#1585
        , 0 // MarketSegmentID#1586
        , 0 // PackageID#1587
        , 0 // TESExecID#1588
        , 1 // SettlDate#1589
        , 1 // AutoApprovalRuleID#1590
        , 0 // TrdType#1591
        , 1 // VarTextLen#1592
        , 0 // TradeReportType#1593
        , 1 // TrdRptStatus#1594
        , 0 // NoSideAllocs#1595
        , 0 // MessageEventSource#1596
        , 1 // TradeReportText#1597
        , 1 // TradeReportID#1598
        , 0 // RootPartyExecutingFirm#1599
        , 0 // RootPartyExecutingTrader#1600
        //// SideAllocGrpBCComp
        , 0 // AllocQty#1601
        , 0 // IndividualAllocID#1602
        , 1 // TESEnrichmentRuleID#1603
        , 0 // PartyExecutingFirm#1604
        , 0 // PartyExecutingTrader#1605
        , 0 // Side#1606
        , 0 // TradeAllocStatus#1607
        ///
        , 1 // VarText#1608
        // TESDeleteBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1609
        , 0 // TemplateID#1610
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1611
        , 0 // ApplSeqNum#1612
        , 1 // ApplSubID#1613
        , 0 // PartitionID#1614
        , 0 // ApplResendFlag#1615
        , 0 // ApplID#1616
        , 0 // LastFragment#1617
        ///
        , 0 // TransactTime#1618
        , 0 // MarketSegmentID#1619
        , 0 // PackageID#1620
        , 0 // TESExecID#1621
        , 0 // TrdType#1622
        , 0 // DeleteReason#1623
        , 0 // TradeReportType#1624
        , 1 // TrdRptStatus#1625
        , 0 // MessageEventSource#1626
        , 1 // TradeReportID#1627
        // TESExecutionBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1628
        , 0 // TemplateID#1629
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1630
        , 0 // ApplSeqNum#1631
        , 1 // ApplSubID#1632
        , 0 // PartitionID#1633
        , 0 // ApplResendFlag#1634
        , 0 // ApplID#1635
        , 0 // LastFragment#1636
        ///
        , 0 // TransactTime#1637
        , 0 // MarketSegmentID#1638
        , 0 // PackageID#1639
        , 0 // TESExecID#1640
        , 0 // AllocID#1641
        , 0 // TrdType#1642
        , 0 // TradeReportType#1643
        , 0 // Side#1644
        , 1 // TrdRptStatus#1645
        , 0 // MessageEventSource#1646
        // TESResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1647
        , 0 // TemplateID#1648
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1649
        , 0 // SendingTime#1650
        , 0 // MsgSeqNum#1651
        ///
        , 0 // TESExecID#1652
        , 0 // TradeReportID#1653
        // TESTradeBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1654
        , 0 // TemplateID#1655
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1656
        , 0 // ApplSeqNum#1657
        , 1 // ApplSubID#1658
        , 0 // PartitionID#1659
        , 0 // ApplResendFlag#1660
        , 0 // ApplID#1661
        , 0 // LastFragment#1662
        ///
        , 0 // SecurityID#1663
        , 0 // LastPx#1664
        , 0 // LastQty#1665
        , 0 // TransactTime#1666
        , 0 // SettlCurrAmt#1667
        , 1 // SideGrossTradeAmt#1668
        , 1 // SettlCurrFxRate#1669
        , 1 // AccruedInteresAmt#1670
        , 1 // CouponRate#1671
        , 1 // RootPartyIDClientID#1672
        , 1 // ExecutingTrader#1673
        , 1 // RootPartyIDInvestmentDecisionMaker#1674
        , 0 // PackageID#1675
        , 0 // MarketSegmentID#1676
        , 0 // TradeID#1677
        , 0 // TradeDate#1678
        , 0 // SideTradeID#1679
        , 1 // RootPartyIDSessionID#1680
        , 0 // RootPartyIDSettlementUnit#1681
        , 1 // RootPartyIDContraUnit#1682
        , 1 // RootPartyIDContraSettlementUnit#1683
        , 1 // OrigTradeID#1684
        , 0 // RootPartyIDExecutingUnit#1685
        , 0 // RootPartyIDExecutingTrader#1686
        , 0 // RootPartyIDClearingUnit#1687
        , 0 // SettlDate#1688
        , 1 // NumDaysInterest#1689
        , 1 // NegotiationID#1690
        , 1 // SRQSRelatedTradeID#1691
        , 1 // TrdType#1692
        , 0 // LastMkt#1693
        , 0 // Side#1694
        , 1 // TradingCapacity#1695
        , 0 // TradeReportType#1696
        , 0 // TransferReason#1697
        , 0 // TradePublishIndicator#1698
        , 0 // DeliveryType#1699
        , 1 // LastCouponDeviationIndicator#1700
        , 1 // RefinancingEligibilityIndicator#1701
        , 1 // ClearingInstruction#1702
        , 1 // OrderAttributeLiquidityProvision#1703
        , 1 // ExecutingTraderQualifier#1704
        , 1 // RootPartyIDInvestmentDecisionMakerQualifier#1705
        , 1 // OrderOrigination#1706
        , 1 // Account#1707
        , 1 // FreeText1#1708
        , 1 // FreeText2#1709
        , 1 // FreeText4#1710
        , 0 // SettlCurrency#1711
        , 0 // RootPartyExecutingFirm#1712
        , 0 // RootPartyExecutingTrader#1713
        , 0 // RootPartyClearingFirm#1714
        , 0 // RootPartyExecutingFirmKVNumber#1715
        , 0 // RootPartySettlementAccount#1716
        , 0 // RootPartySettlementLocation#1717
        , 0 // RootPartySettlementFirm#1718
        , 1 // RootPartyContraFirm#1719
        , 1 // RootPartyContraSettlementFirm#1720
        , 0 // RootPartyContraFirmKVNumber#1721
        , 0 // RootPartyContraSettlementAccount#1722
        , 1 // RootPartyContraSettlementLocation#1723
        , 1 // RootPartyIDExecutionVenue#1724
        , 1 // RegulatoryTradeID#1725
        // TESTradingSessionStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1726
        , 0 // TemplateID#1727
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1728
        , 0 // ApplSeqNum#1729
        , 1 // ApplSubID#1730
        , 0 // PartitionID#1731
        , 0 // ApplResendFlag#1732
        , 0 // ApplID#1733
        , 0 // LastFragment#1734
        ///
        , 0 // TradeDate#1735
        , 0 // TradSesEvent#1736
        // TMTradingSessionStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1737
        , 0 // TemplateID#1738
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1739
        , 0 // ApplSeqNum#1740
        , 1 // ApplSubID#1741
        , 0 // PartitionID#1742
        , 0 // ApplResendFlag#1743
        , 0 // ApplID#1744
        , 0 // LastFragment#1745
        ///
        , 0 // TradSesEvent#1746
        // ThrottleUpdateNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1747
        , 0 // TemplateID#1748
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#1749
        ///
        , 0 // ThrottleTimeInterval#1750
        , 0 // ThrottleNoMsgs#1751
        , 0 // ThrottleDisconnectLimit#1752
        // TradeBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1753
        , 0 // TemplateID#1754
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1755
        , 0 // ApplSeqNum#1756
        , 1 // ApplSubID#1757
        , 0 // PartitionID#1758
        , 0 // ApplResendFlag#1759
        , 0 // ApplID#1760
        , 0 // LastFragment#1761
        ///
        , 0 // SecurityID#1762
        , 1 // Price#1763
        , 0 // LastPx#1764
        , 0 // LastQty#1765
        , 0 // SettlCurrAmt#1766
        , 1 // SettlCurrFxRate#1767
        , 0 // TransactTime#1768
        , 1 // OrderID#1769
        , 1 // ClOrdID#1770
        , 1 // LeavesQty#1771
        , 1 // CumQty#1772
        , 1 // SideGrossTradeAmt#1773
        , 1 // AccruedInteresAmt#1774
        , 1 // CouponRate#1775
        , 1 // RootPartyIDClientID#1776
        , 1 // ExecutingTrader#1777
        , 1 // RootPartyIDInvestmentDecisionMaker#1778
        , 0 // TradeID#1779
        , 1 // OrigTradeID#1780
        , 0 // RootPartyIDExecutingUnit#1781
        , 1 // RootPartyIDSessionID#1782
        , 1 // RootPartyIDExecutingTrader#1783
        , 0 // RootPartyIDSettlementUnit#1784
        , 0 // RootPartyIDClearingUnit#1785
        , 1 // RootPartyIDContraUnit#1786
        , 1 // RootPartyIDContraSettlementUnit#1787
        , 1 // PartyIDSpecialistTrader#1788
        , 1 // OrderIDSfx#1789
        , 0 // MarketSegmentID#1790
        , 0 // SideTradeID#1791
        , 0 // SideTradeReportID#1792
        , 1 // TradeNumber#1793
        , 0 // MatchDate#1794
        , 0 // SettlDate#1795
        , 0 // TrdMatchID#1796
        , 1 // NumDaysInterest#1797
        , 0 // LastMkt#1798
        , 0 // TradeReportType#1799
        , 0 // TransferReason#1800
        , 1 // MatchType#1801
        , 1 // MatchSubType#1802
        , 0 // Side#1803
        , 1 // SideLiquidityInd#1804
        , 0 // DeliveryType#1805
        , 0 // TradingCapacity#1806
        , 1 // LastCouponDeviationIndicator#1807
        , 1 // RefinancingEligibilityIndicator#1808
        , 1 // ClearingInstruction#1809
        , 1 // OrderOrigination#1810
        , 1 // OrderAttributeLiquidityProvision#1811
        , 1 // ExecutingTraderQualifier#1812
        , 1 // RootPartyIDInvestmentDecisionMakerQualifier#1813
        , 1 // Account#1814
        , 0 // SettlCurrency#1815
        , 0 // Currency#1816
        , 1 // FreeText1#1817
        , 1 // FreeText2#1818
        , 1 // FreeText4#1819
        , 1 // OrderCategory#1820
        , 1 // OrdType#1821
        , 0 // RootPartyExecutingFirm#1822
        , 1 // RootPartyExecutingTrader#1823
        , 0 // RootPartyClearingFirm#1824
        , 0 // RootPartyExecutingFirmKVNumber#1825
        , 0 // RootPartySettlementAccount#1826
        , 0 // RootPartySettlementLocation#1827
        , 0 // RootPartySettlementFirm#1828
        , 1 // RootPartyContraFirm#1829
        , 1 // RootPartyContraSettlementFirm#1830
        , 0 // RootPartyContraFirmKVNumber#1831
        , 0 // RootPartyContraSettlementAccount#1832
        , 1 // RootPartyContraSettlementLocation#1833
        , 1 // PartySpecialistFirm#1834
        , 1 // PartySpecialistTrader#1835
        , 1 // RegulatoryTradeID#1836
        , 1 // RootPartyIDExecutionVenue#1837
        // TradingSessionStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1838
        , 0 // TemplateID#1839
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1840
        , 1 // NotificationIn#1841
        , 0 // SendingTime#1842
        , 1 // ApplSubID#1843
        , 0 // PartitionID#1844
        , 0 // ApplMsgID#1845
        , 0 // ApplID#1846
        , 0 // ApplResendFlag#1847
        , 0 // LastFragment#1848
        ///
        , 1 // MarketSegmentID#1849
        , 1 // TradeDate#1850
        , 0 // TradSesEvent#1851
        , 1 // RefApplLastMsgID#1852
        // TrailingStopUpdateNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1853
        , 0 // TemplateID#1854
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1855
        , 1 // NotificationIn#1856
        , 0 // SendingTime#1857
        , 1 // ApplSubID#1858
        , 0 // PartitionID#1859
        , 1 // ApplMsgID#1860
        , 1 // ApplID#1861
        , 0 // ApplResendFlag#1862
        , 0 // LastFragment#1863
        ///
        , 0 // OrderID#1864
        , 1 // ClOrdID#1865
        , 1 // OrigClOrdID#1866
        , 0 // SecurityID#1867
        , 0 // ExecID#1868
        , 0 // StopPx#1869
        , 0 // OrderQty#1870
        , 0 // OrderIDSfx#1871
        , 0 // MarketSegmentID#1872
        , 0 // ExecRestatementReason#1873
        , 0 // OrdStatus#1874
        , 0 // ExecType#1875
        , 0 // Side#1876
        , 1 // FIXClOrdID#1877
        // UnsubscribeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1878
        , 0 // TemplateID#1879
        , 2 // NetworkMsgID#1880
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1881
        , 2 // SenderSubID#1882
        ///
        , 0 // RefApplSubID#1883
        // UnsubscribeResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1884
        , 0 // TemplateID#1885
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1886
        , 0 // SendingTime#1887
        , 0 // MsgSeqNum#1888
        ///
        // UserLoginRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1889
        , 0 // TemplateID#1890
        , 2 // NetworkMsgID#1891
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1892
        , 2 // SenderSubID#1893
        ///
        , 0 // Username#1894
        , 0 // Password#1895
        // UserLoginResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1896
        , 0 // TemplateID#1897
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1898
        , 0 // SendingTime#1899
        , 0 // MsgSeqNum#1900
        ///
        // UserLogoutRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1901
        , 0 // TemplateID#1902
        , 2 // NetworkMsgID#1903
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1904
        , 2 // SenderSubID#1905
        ///
        , 0 // Username#1906
        // UserLogoutResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1907
        , 0 // TemplateID#1908
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1909
        , 0 // SendingTime#1910
        , 0 // MsgSeqNum#1911
        ///
        // XetraEnLightCreateDealNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1912
        , 0 // TemplateID#1913
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1914
        , 0 // ApplSeqNum#1915
        , 1 // ApplSubID#1916
        , 2 // PartitionID#1917
        , 0 // ApplResendFlag#1918
        , 0 // ApplID#1919
        , 0 // LastFragment#1920
        ///
        , 0 // TransactTime#1921
        , 0 // LastPx#1922
        , 0 // LastQty#1923
        , 0 // QuoteID#1924
        , 0 // SecurityID#1925
        , 1 // PartyIDClientID#1926
        , 1 // PartyIdInvestmentDecisionMaker#1927
        , 1 // ExecutingTrader#1928
        , 0 // NegotiationID#1929
        , 0 // TradeID#1930
        , 1 // SettlDate#1931
        , 0 // TradingCapacity#1932
        , 0 // TrdRptStatus#1933
        , 0 // MessageEventSource#1934
        , 0 // Side#1935
        , 0 // AllocMethod#1936
        , 0 // NoOrderBookItems#1937
        , 0 // OrderAttributeLiquidityProvision#1938
        , 0 // ExecutingTraderQualifier#1939
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1940
        , 1 // RootPartyExecutingFirm#1941
        , 1 // RootPartyExecutingTrader#1942
        , 1 // RootPartyEnteringTrader#1943
        , 1 // TargetPartyExecutingFirm#1944
        , 1 // TargetPartyExecutingTrader#1945
        , 1 // TargetPartyEnteringTrader#1946
        , 1 // FirmTradeID#1947
        , 1 // FirmNegotiationID#1948
        , 1 // FreeText1#1949
        , 1 // FreeText2#1950
        , 1 // FreeText4#1951
        //// OrderBookItemGrpComp
        , 1 // BestBidPx#1952
        , 1 // BestBidSize#1953
        , 1 // BestOfferPx#1954
        , 1 // BestOfferSize#1955
        , 0 // MDBookType#1956
        , 1 // MDSubBookType#1957
        ///
        // XetraEnLightDealResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1958
        , 0 // TemplateID#1959
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1960
        , 0 // SendingTime#1961
        , 0 // MsgSeqNum#1962
        ///
        , 0 // SecurityID#1963
        , 1 // QuoteID#1964
        , 0 // NegotiationID#1965
        , 1 // TradeID#1966
        , 1 // SecondaryTradeID#1967
        , 1 // FirmTradeID#1968
        , 1 // FirmNegotiationID#1969
        // XetraEnLightEnterQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1970
        , 0 // TemplateID#1971
        , 2 // NetworkMsgID#1972
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1973
        , 0 // SenderSubID#1974
        ///
        , 1 // BidPx#1975
        , 1 // OfferPx#1976
        , 1 // BidSize#1977
        , 1 // OfferSize#1978
        , 1 // PartyIDClientID#1979
        , 1 // PartyIdInvestmentDecisionMaker#1980
        , 1 // ExecutingTrader#1981
        , 0 // MarketSegmentID#1982
        , 0 // NegotiationID#1983
        , 0 // ValueCheckTypeQuantity#1984
        , 0 // ValueCheckTypeValue#1985
        , 0 // TradingCapacity#1986
        , 0 // OrderAttributeLiquidityProvision#1987
        , 0 // ExecutingTraderQualifier#1988
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1989
        , 0 // PartyExecutingFirm#1990
        , 0 // PartyExecutingTrader#1991
        , 1 // FreeText1#1992
        , 1 // FreeText2#1993
        , 1 // FreeText4#1994
        // XetraEnLightHitQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1995
        , 0 // TemplateID#1996
        , 2 // NetworkMsgID#1997
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1998
        , 0 // SenderSubID#1999
        ///
        , 1 // QuoteID#2000
        , 0 // OrderQty#2001
        , 1 // Price#2002
        , 1 // PartyIDClientID#2003
        , 1 // PartyIdInvestmentDecisionMaker#2004
        , 1 // ExecutingTrader#2005
        , 0 // MarketSegmentID#2006
        , 0 // NegotiationID#2007
        , 0 // Side#2008
        , 0 // ValueCheckTypeQuantity#2009
        , 0 // ValueCheckTypeValue#2010
        , 0 // TradingCapacity#2011
        , 0 // OrderAttributeLiquidityProvision#2012
        , 0 // ExecutingTraderQualifier#2013
        , 0 // AllocMethod#2014
        , 1 // PartyIdInvestmentDecisionMakerQualifier#2015
        , 1 // OrderOrigination#2016
        , 1 // PartyExecutingFirm#2017
        , 1 // PartyExecutingTrader#2018
        , 1 // FirmTradeID#2019
        , 1 // FreeText1#2020
        , 1 // FreeText2#2021
        , 1 // FreeText4#2022
        // XetraEnLightNegotiationNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2023
        , 0 // TemplateID#2024
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2025
        , 0 // ApplSeqNum#2026
        , 1 // ApplSubID#2027
        , 2 // PartitionID#2028
        , 0 // ApplResendFlag#2029
        , 0 // ApplID#2030
        , 0 // LastFragment#2031
        ///
        , 0 // TransactTime#2032
        , 1 // BidPx#2033
        , 1 // OfferPx#2034
        , 1 // LeavesQty#2035
        , 0 // NegotiationID#2036
        , 1 // NumberOfRespondents#2037
        , 1 // SettlDate#2038
        , 0 // QuoteStatus#2039
        , 1 // Side#2040
        , 1 // PartyExecutingFirm#2041
        , 1 // PartyExecutingTrader#2042
        , 1 // PartyEnteringTrader#2043
        , 0 // TargetPartyExecutingFirm#2044
        , 0 // TargetPartyExecutingTrader#2045
        , 1 // FirmNegotiationID#2046
        , 1 // FreeText5#2047
        // XetraEnLightNegotiationRequesterNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2048
        , 0 // TemplateID#2049
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2050
        , 0 // ApplSeqNum#2051
        , 1 // ApplSubID#2052
        , 2 // PartitionID#2053
        , 0 // ApplResendFlag#2054
        , 0 // ApplID#2055
        , 0 // LastFragment#2056
        ///
        , 0 // TransactTime#2057
        , 1 // TrdRegTSExecutionTime#2058
        , 1 // BidPx#2059
        , 1 // OfferPx#2060
        , 0 // OrderQty#2061
        , 1 // LastPx#2062
        , 1 // LeavesQty#2063
        , 1 // LastQty#2064
        , 0 // NegotiationID#2065
        , 1 // NumberOfRespondents#2066
        , 1 // SettlDate#2067
        , 0 // QuoteStatus#2068
        , 0 // NoTargetPartyIDs#2069
        , 0 // NumberOfRespDisclosureInstruction#2070
        , 1 // Side#2071
        , 0 // PartyExecutingFirm#2072
        , 0 // PartyExecutingTrader#2073
        , 0 // PartyEnteringTrader#2074
        , 1 // FirmNegotiationID#2075
        , 1 // FreeText5#2076
        //// XetraEnLightTargetPartiesComp
        , 1 // TargetPartyIDExecutingTrader#2077
        , 1 // TargetPartyExecutingFirm#2078
        , 1 // TargetPartyExecutingTrader#2079
        ///
        // XetraEnLightNegotiationStatusNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2080
        , 0 // TemplateID#2081
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2082
        , 0 // ApplSeqNum#2083
        , 1 // ApplSubID#2084
        , 2 // PartitionID#2085
        , 0 // ApplResendFlag#2086
        , 0 // ApplID#2087
        , 0 // LastFragment#2088
        ///
        , 0 // TransactTime#2089
        , 0 // NegotiationID#2090
        , 0 // QuoteStatus#2091
        , 1 // FirmNegotiationID#2092
        // XetraEnLightOpenNegotiationNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2093
        , 0 // TemplateID#2094
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2095
        , 0 // ApplSeqNum#2096
        , 1 // ApplSubID#2097
        , 2 // PartitionID#2098
        , 0 // ApplResendFlag#2099
        , 0 // ApplID#2100
        , 0 // LastFragment#2101
        ///
        , 0 // TransactTime#2102
        , 1 // NegotiationStartTime#2103
        , 0 // SecurityID#2104
        , 1 // BidPx#2105
        , 1 // OfferPx#2106
        , 1 // LeavesQty#2107
        , 1 // ExpireTime#2108
        , 0 // NegotiationID#2109
        , 0 // MarketSegmentID#2110
        , 1 // NumberOfRespondents#2111
        , 1 // SettlDate#2112
        , 0 // QuoteStatus#2113
        , 1 // Side#2114
        , 0 // RespondentType#2115
        , 1 // PartyExecutingFirm#2116
        , 1 // PartyExecutingTrader#2117
        , 1 // PartyEnteringTrader#2118
        , 0 // TargetPartyExecutingFirm#2119
        , 0 // TargetPartyExecutingTrader#2120
        , 1 // FirmNegotiationID#2121
        , 1 // FreeText5#2122
        // XetraEnLightOpenNegotiationRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2123
        , 0 // TemplateID#2124
        , 2 // NetworkMsgID#2125
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2126
        , 0 // SenderSubID#2127
        ///
        , 0 // SecurityID#2128
        , 1 // BidPx#2129
        , 1 // OfferPx#2130
        , 0 // OrderQty#2131
        , 1 // ValidUntilTime#2132
        , 0 // MarketSegmentID#2133
        , 1 // SettlDate#2134
        , 0 // NoTargetPartyIDs#2135
        , 0 // NumberOfRespDisclosureInstruction#2136
        , 1 // Side#2137
        , 0 // ValueCheckTypeValue#2138
        , 0 // ValueCheckTypeQuantity#2139
        , 0 // RespondentType#2140
        , 0 // PartyExecutingFirm#2141
        , 0 // PartyExecutingTrader#2142
        , 1 // FreeText5#2143
        , 1 // QuoteReqID#2144
        //// XetraEnLightTargetPartiesComp
        , 2 // TargetPartyIDExecutingTrader#2145
        , 1 // TargetPartyExecutingFirm#2146
        , 1 // TargetPartyExecutingTrader#2147
        ///
        // XetraEnLightOpenNegotiationRequesterNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2148
        , 0 // TemplateID#2149
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2150
        , 0 // ApplSeqNum#2151
        , 1 // ApplSubID#2152
        , 2 // PartitionID#2153
        , 0 // ApplResendFlag#2154
        , 0 // ApplID#2155
        , 0 // LastFragment#2156
        ///
        , 0 // TransactTime#2157
        , 0 // SecurityID#2158
        , 1 // BidPx#2159
        , 1 // OfferPx#2160
        , 0 // OrderQty#2161
        , 1 // LastPx#2162
        , 1 // LastQty#2163
        , 1 // ExpireTime#2164
        , 0 // NegotiationID#2165
        , 0 // MarketSegmentID#2166
        , 1 // NumberOfRespondents#2167
        , 1 // SettlDate#2168
        , 0 // QuoteStatus#2169
        , 0 // NoTargetPartyIDs#2170
        , 1 // Side#2171
        , 0 // NumberOfRespDisclosureInstruction#2172
        , 0 // RespondentType#2173
        , 0 // PartyExecutingFirm#2174
        , 0 // PartyExecutingTrader#2175
        , 0 // PartyEnteringTrader#2176
        , 1 // FirmNegotiationID#2177
        , 1 // FreeText5#2178
        //// XetraEnLightTargetPartiesComp
        , 1 // TargetPartyIDExecutingTrader#2179
        , 1 // TargetPartyExecutingFirm#2180
        , 1 // TargetPartyExecutingTrader#2181
        ///
        // XetraEnLightQuoteNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2182
        , 0 // TemplateID#2183
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2184
        , 0 // ApplSeqNum#2185
        , 1 // ApplSubID#2186
        , 2 // PartitionID#2187
        , 0 // ApplResendFlag#2188
        , 0 // ApplID#2189
        , 0 // LastFragment#2190
        ///
        , 0 // TransactTime#2191
        , 1 // QuoteID#2192
        , 1 // SecondaryQuoteID#2193
        , 1 // BidPx#2194
        , 1 // BidSize#2195
        , 1 // OfferPx#2196
        , 1 // OfferSize#2197
        , 0 // NegotiationID#2198
        , 1 // TradingCapacity#2199
        , 0 // QuotingStatus#2200
        , 1 // QuoteEventReason#2201
        , 0 // PartyExecutingFirm#2202
        , 0 // PartyExecutingTrader#2203
        , 0 // PartyEnteringTrader#2204
        , 1 // QuoteReqID#2205
        , 1 // FreeText1#2206
        , 1 // FreeText2#2207
        , 1 // FreeText4#2208
        // XetraEnLightQuoteRequesterNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2209
        , 0 // TemplateID#2210
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2211
        , 0 // ApplSeqNum#2212
        , 1 // ApplSubID#2213
        , 2 // PartitionID#2214
        , 0 // ApplResendFlag#2215
        , 0 // ApplID#2216
        , 0 // LastFragment#2217
        ///
        , 1 // TransactTime#2218
        , 0 // NegotiationID#2219
        , 1 // TradeID#2220
        , 1 // QuoteReqID#2221
        , 0 // NoQuoteEntries#2222
        //// SRQSQuoteEntryGrpComp
        , 1 // TransactTime#2223
        , 1 // QuoteID#2224
        , 1 // SecondaryQuoteID#2225
        , 1 // BidPx#2226
        , 1 // BidSize#2227
        , 1 // OfferPx#2228
        , 1 // OfferSize#2229
        , 1 // PartyIDExecutingTrader#2230
        , 0 // QuotingStatus#2231
        , 1 // PartyExecutingFirm#2232
        , 1 // PartyExecutingTrader#2233
        , 1 // PartyEnteringTrader#2234
        ///
        // XetraEnLightQuoteResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#2235
        , 0 // TemplateID#2236
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2237
        , 0 // SendingTime#2238
        , 0 // MsgSeqNum#2239
        ///
        , 1 // QuoteID#2240
        , 0 // NegotiationID#2241
        , 1 // QuoteReqID#2242
        // XetraEnLightQuotingStatusRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2243
        , 0 // TemplateID#2244
        , 2 // NetworkMsgID#2245
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2246
        , 0 // SenderSubID#2247
        ///
        , 0 // MarketSegmentID#2248
        , 0 // NegotiationID#2249
        , 0 // QuotingStatus#2250
        , 0 // PartyExecutingFirm#2251
        , 0 // PartyExecutingTrader#2252
        // XetraEnLightStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2253
        , 0 // TemplateID#2254
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2255
        , 0 // ApplSeqNum#2256
        , 1 // ApplSubID#2257
        , 2 // PartitionID#2258
        , 0 // ApplResendFlag#2259
        , 0 // ApplID#2260
        , 0 // LastFragment#2261
        ///
        , 1 // TradeDate#2262
        , 0 // TradSesEvent#2263
        // XetraEnLightUpdateNegotiationRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2264
        , 0 // TemplateID#2265
        , 2 // NetworkMsgID#2266
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2267
        , 0 // SenderSubID#2268
        ///
        , 1 // BidPx#2269
        , 1 // OfferPx#2270
        , 0 // OrderQty#2271
        , 0 // MarketSegmentID#2272
        , 0 // NegotiationID#2273
        , 1 // SettlDate#2274
        , 0 // NoTargetPartyIDs#2275
        , 0 // NumberOfRespDisclosureInstruction#2276
        , 1 // Side#2277
        , 1 // QuoteCancelType#2278
        , 0 // PartyExecutingFirm#2279
        , 0 // PartyExecutingTrader#2280
        , 1 // FreeText5#2281
        //// XetraEnLightTargetPartiesComp
        , 1 // TargetPartyIDExecutingTrader#2282
        , 1 // TargetPartyExecutingFirm#2283
        , 1 // TargetPartyExecutingTrader#2284
        ///
        , 0 // filler
    };
    static const int16_t tid2uidx[] = {
        504 /* LogonRequest */
        , 522 /* LogonResponse */
        , 536 /* LogoutRequest */
        , 541 /* LogoutResponse */
        , -1
        , 1523 /* SubscribeResponse */
        , 1878 /* UnsubscribeRequest */
        , 1884 /* UnsubscribeResponse */
        , 1279 /* RetransmitRequest */
        , 1288 /* RetransmitResponse */
        , 1248 /* Reject */
        , 392 /* Heartbeat */
        , 380 /* ForcedLogoutNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1889 /* UserLoginRequest */
        , 1896 /* UserLoginResponse */
        , -1
        , -1
        , -1
        , 395 /* HeartbeatNotification */
        , 1907 /* UserLogoutResponse */
        , 1516 /* SubscribeRequest */
        , 1261 /* RetransmitMEMessageRequest */
        , 1271 /* RetransmitMEMessageResponse */
        , 1747 /* ThrottleUpdateNotification */
        , 1901 /* UserLogoutRequest */
        , 1296 /* ServiceAvailabilityBroadcast */
        , 882 /* NewsBroadcast */
        , 29 /* BroadcastErrorNotification */
        , -1
        , 1073 /* PartyEntitlementsUpdateReport */
        , 415 /* InquireSessionListRequest */
        , 420 /* InquireSessionListResponse */
        , 491 /* LegalNotificationBroadcast */
        , 429 /* InquireUserRequest */
        , 435 /* InquireUserResponse */
        , 398 /* InquireEnrichmentRuleIDListRequest */
        , 404 /* InquireEnrichmentRuleIDListResponse */
        , 1055 /* PartyActionReport */
        , 385 /* ForcedUserLogoutNotification */
        , 1313 /* ServiceAvailabilityMarketBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 811 /* NewOrderSingleRequest */
        , 779 /* NewOrderResponse */
        , 752 /* NewOrderNRResponse */
        , 1011 /* OrderExecResponse */
        , 895 /* OrderExecNotification */
        , -1
        , 656 /* ModifyOrderSingleRequest */
        , 621 /* ModifyOrderResponse */
        , 590 /* ModifyOrderNRResponse */
        , 271 /* DeleteOrderSingleRequest */
        , 247 /* DeleteOrderResponse */
        , 226 /* DeleteOrderNRResponse */
        , 194 /* DeleteOrderBroadcast */
        , -1
        , -1
        , -1
        , -1
        , 937 /* OrderExecReportBroadcast */
        , 38 /* CrossRequest */
        , 46 /* CrossRequestResponse */
        , 112 /* DeleteAllOrderRequest */
        , 128 /* DeleteAllOrderResponse */
        , 56 /* DeleteAllOrderBroadcast */
        , -1
        , 86 /* DeleteAllOrderNRResponse */
        , 856 /* NewOrderSingleShortRequest */
        , 703 /* ModifyOrderSingleShortRequest */
        , 1853 /* TrailingStopUpdateNotification */
        , 323 /* ExtendedDeletionReport */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1387 /* SpecialistOrderBookNotification */
        , 1350 /* SpecialistDeleteAllOrderBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1838 /* TradingSessionStatusBroadcast */
        , 96 /* DeleteAllOrderQuoteEventBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , 467 /* IssuerSecurityStateChangeRequest */
        , 481 /* IssuerSecurityStateChangeResponse */
        , 447 /* IssuerNotification */
        , 1498 /* SpecialistSecurityStateChangeRequest */
        , 1506 /* SpecialistSecurityStateChangeResponse */
        , 1372 /* SpecialistInstrumentEventNotification */
        , 1091 /* PingRequest */
        , 1097 /* PingResponse */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1208 /* RFQRequest */
        , 1220 /* RFQResponse */
        , 1126 /* QuoteActivationRequest */
        , 1138 /* QuoteActivationResponse */
        , 546 /* MassQuoteRequest */
        , 572 /* MassQuoteResponse */
        , 1150 /* QuoteExecutionReport */
        , 171 /* DeleteAllQuoteRequest */
        , 182 /* DeleteAllQuoteResponse */
        , 149 /* DeleteAllQuoteBroadcast */
        , 1107 /* QuoteActivationNotification */
        , -1
        , -1
        , -1
        , 1174 /* RFQBroadcast */
        , -1
        , -1
        , 1322 /* SingleQuoteRequest */
        , 1230 /* RFQSpecialistBroadcast */
        , 1191 /* RFQRejectNotification */
        , 1445 /* SpecialistRFQRejectRequest */
        , 1475 /* SpecialistRFQReplyRequest */
        , 1488 /* SpecialistRFQReplyResponse */
        , 1455 /* SpecialistRFQReplyNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1753 /* TradeBroadcast */
        , 1737 /* TMTradingSessionStatusBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 301 /* EnterTESTradeRequest */
        , 730 /* ModifyTESTradeRequest */
        , 290 /* DeleteTESTradeRequest */
        , 0 /* ApproveTESTradeRequest */
        , 1572 /* TESBroadcast */
        , -1
        , 1609 /* TESDeleteBroadcast */
        , 1529 /* TESApproveBroadcast */
        , -1
        , -1
        , 1628 /* TESExecutionBroadcast */
        , 1647 /* TESResponse */
        , -1
        , -1
        , 1654 /* TESTradeBroadcast */
        , 1726 /* TESTradingSessionStatusBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 2123 /* XetraEnLightOpenNegotiationRequest */
        , 2264 /* XetraEnLightUpdateNegotiationRequest */
        , 1970 /* XetraEnLightEnterQuoteRequest */
        , 2235 /* XetraEnLightQuoteResponse */
        , 1995 /* XetraEnLightHitQuoteRequest */
        , 1958 /* XetraEnLightDealResponse */
        , -1
        , 2182 /* XetraEnLightQuoteNotification */
        , 1912 /* XetraEnLightCreateDealNotification */
        , -1
        , 2148 /* XetraEnLightOpenNegotiationRequesterNotification */
        , 2093 /* XetraEnLightOpenNegotiationNotification */
        , 2048 /* XetraEnLightNegotiationRequesterNotification */
        , 2023 /* XetraEnLightNegotiationNotification */
        , 2253 /* XetraEnLightStatusBroadcast */
        , 2080 /* XetraEnLightNegotiationStatusNotification */
        , 2209 /* XetraEnLightQuoteRequesterNotification */
        , 2243 /* XetraEnLightQuotingStatusRequest */
    };
    static int * const dscp_bits[] = {
        &hf_xti_dscp_exec_summary,
        &hf_xti_dscp_improved,
        &hf_xti_dscp_widened,
        NULL
    };
    if (templateid < 10000 || templateid > 10817) {
        proto_tree_add_expert_format(root, pinfo, &ei_xti_invalid_template, tvb, 4, 4,
            "Template ID out of range: %" PRIu16, templateid);
        return tvb_captured_length(tvb);
    }
    int fidx = tid2fidx[templateid - 10000];
    if (fidx == -1) {
        proto_tree_add_expert_format(root, pinfo, &ei_xti_invalid_template, tvb, 4, 4,
            "Unallocated Template ID: %" PRIu16, templateid);
        return tvb_captured_length(tvb);
    }
    if (bodylen < tid2size[templateid - 10000][0] || bodylen > tid2size[templateid - 10000][1]) {
        if (tid2size[templateid - 10000][0] != tid2size[templateid - 10000][1])
            proto_tree_add_expert_format(root, pinfo, &ei_xti_invalid_length, tvb, 0, 4,
                    "Unexpected BodyLen value of %" PRIu32 ", expected:  %" PRIu32 "..%" PRIu32, bodylen, tid2size[templateid - 10000][0], tid2size[templateid - 10000][1]);
        else
            proto_tree_add_expert_format(root, pinfo, &ei_xti_invalid_length, tvb, 0, 4,
                    "Unexpected BodyLen value of %" PRIu32 ", expected:  %" PRIu32, bodylen, tid2size[templateid - 10000][0]);
    }
    if (bodylen % 8)
        proto_tree_add_expert_format(root, pinfo, &ei_xti_unaligned, tvb, 0, 4,
                "BodyLen value of %" PRIu32 " is not divisible by 8", bodylen);

    int uidx = tid2uidx[templateid - 10000];
    DISSECTOR_ASSERT_CMPINT(uidx, >=, 0);
    DISSECTOR_ASSERT_CMPUINT(((size_t)uidx), <, array_length(usages));

    int old_fidx = 0;
    int old_uidx = 0;
    unsigned top = 1;
    unsigned counter[8] = {0};
    unsigned off = 0;
    unsigned struct_off = 0;
    unsigned repeats = 0;
    proto_tree *t = root;
    while (top) {
        DISSECTOR_ASSERT_CMPINT(fidx, >=, 0);
        DISSECTOR_ASSERT_CMPUINT(((size_t)fidx), <, array_length(fields));
        DISSECTOR_ASSERT_CMPINT(uidx, >=, 0);
        DISSECTOR_ASSERT_CMPUINT(((size_t)uidx), <, array_length(usages));

        switch (fields[fidx].type) {
            case ETI_EOF:
                DISSECTOR_ASSERT_CMPUINT(top, >=, 1);
                DISSECTOR_ASSERT_CMPUINT(top, <=, 2);
                if (t != root)
                    proto_item_set_len(t, off - struct_off);
                if (repeats) {
                    --repeats;
                    fidx = fields[old_fidx].field_handle_idx;
                    uidx = old_uidx;
                    t = proto_tree_add_subtree(root, tvb, off, -1, ett_xti[fields[old_fidx].ett_idx], NULL, &struct_names[fields[old_fidx].size]);
                    struct_off = off;
                } else {
                    fidx = old_fidx + 1;
                    t = root;
                    --top;
                }
                break;
            case ETI_VAR_STRUCT:
            case ETI_STRUCT:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <, array_length(counter));
                repeats = fields[fidx].type == ETI_VAR_STRUCT ? counter[fields[fidx].counter_off] : 1;
                if (repeats) {
                    --repeats;
                    t = proto_tree_add_subtree(root, tvb, off, -1, ett_xti[fields[fidx].ett_idx], NULL, &struct_names[fields[fidx].size]);
                    struct_off = off;
                    old_fidx = fidx;
                    old_uidx = uidx;
                    fidx = fields[fidx].field_handle_idx;
                    DISSECTOR_ASSERT_CMPUINT(top, ==, 1);
                    ++top;
                } else {
                    ++fidx;
                }
                break;
            case ETI_PADDING:
                off += fields[fidx].size;
                ++fidx;
                break;
            case ETI_CHAR:
                proto_tree_add_item(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_ASCII);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_STRING:
                {
                    guint8 c = tvb_get_guint8(tvb, off);
                    if (c)
                        proto_tree_add_item(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_ASCII);
                    else {
                        proto_item *e = proto_tree_add_string(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, "NO_VALUE ('0x00...')");
                        if (!usages[uidx])
                            expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                    }
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_VAR_STRING:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <, array_length(counter));
                proto_tree_add_item(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, counter[fields[fidx].counter_off], ENC_ASCII);
                off += counter[fields[fidx].counter_off];
                ++fidx;
                ++uidx;
                break;
            case ETI_COUNTER:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <, array_length(counter));
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, <=, 2);
                {
                    switch (fields[fidx].size) {
                        case 1:
                            {
                                guint8 x = tvb_get_guint8(tvb, off);
                                if (x == UINT8_MAX) {
                                    proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xff)");
                                    counter[fields[fidx].counter_off] = 0;
                                } else {
                                    proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu8, x);
                                    if (x > fields[fidx].ett_idx) {
                                        counter[fields[fidx].counter_off] = fields[fidx].ett_idx;
                                        expert_add_info_format(pinfo, e, &ei_xti_counter_overflow, "Counter overflow: %" PRIu8 " > %" PRIu16, x, fields[fidx].ett_idx);
                                    } else {
                                        counter[fields[fidx].counter_off] = x;
                                    }
                                }
                            }
                            break;
                        case 2:
                            {
                                guint16 x = tvb_get_letohs(tvb, off);
                                if (x == UINT16_MAX) {
                                    proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffff)");
                                    counter[fields[fidx].counter_off] = 0;
                                } else {
                                    proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu16, x);
                                    if (x > fields[fidx].ett_idx) {
                                        counter[fields[fidx].counter_off] = fields[fidx].ett_idx;
                                        expert_add_info_format(pinfo, e, &ei_xti_counter_overflow, "Counter overflow: %" PRIu16 " > %" PRIu16, x, fields[fidx].ett_idx);
                                    } else {
                                        counter[fields[fidx].counter_off] = x;
                                    }
                                }
                            }
                            break;
                    }
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_UINT:
                switch (fields[fidx].size) {
                    case 1:
                        {
                            guint8 x = tvb_get_guint8(tvb, off);
                            if (x == UINT8_MAX) {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu8, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 2:
                        {
                            guint16 x = tvb_get_letohs(tvb, off);
                            if (x == UINT16_MAX) {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu16, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 4:
                        {
                            guint32 x = tvb_get_letohl(tvb, off);
                            if (x == UINT32_MAX) {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffffffff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu32, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 8:
                        {
                            guint64 x = tvb_get_letoh64(tvb, off);
                            if (x == UINT64_MAX) {
                                proto_item *e = proto_tree_add_uint64_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffffffffffffffff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint64_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu64, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_INT:
                switch (fields[fidx].size) {
                    case 1:
                        {
                            gint8 x = tvb_get_gint8(tvb, off);
                            if (x == INT8_MIN) {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x80)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi8, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 2:
                        {
                            gint16 x = tvb_get_letohis(tvb, off);
                            if (x == INT16_MIN) {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x8000)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi16, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 4:
                        {
                            gint32 x = tvb_get_letohil(tvb, off);
                            if (x == INT32_MIN) {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x80000000)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi32, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 8:
                        {
                            gint64 x = tvb_get_letohi64(tvb, off);
                            if (x == INT64_MIN) {
                                proto_item *e = proto_tree_add_int64_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x8000000000000000)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int64_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi64, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_xti_overused, "unused value is set");
                            }
                        }
                        break;
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_UINT_ENUM:
            case ETI_INT_ENUM:
                proto_tree_add_item(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_LITTLE_ENDIAN);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_FIXED_POINT:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, ==, 8);
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, >, 0);
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <=, 16);
                {
                    gint64 x = tvb_get_letohi64(tvb, off);
                    if (x == INT64_MIN) {
                        proto_item *e = proto_tree_add_int64_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x8000000000000000)");
                        if (!usages[uidx])
                            expert_add_info_format(pinfo, e, &ei_xti_missing, "required value is missing");
                    } else {
                        unsigned slack = fields[fidx].counter_off + 1;
                        if (x < 0)
                            slack += 1;
                        char s[21];
                        int n = snprintf(s, sizeof s, "%0*" PRIi64, slack, x);
                        DISSECTOR_ASSERT_CMPUINT(n, >, 0);
                        unsigned k = n - fields[fidx].counter_off;
                        proto_tree_add_int64_format_value(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%.*s.%s", k, s, s + k);
                    }
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_TIMESTAMP_NS:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, ==, 8);
                proto_tree_add_item(t, hf_xti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_LITTLE_ENDIAN | ENC_TIME_NSECS);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_DSCP:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, ==, 1);
                proto_tree_add_bitmask(t, tvb, off, hf_xti[fields[fidx].field_handle_idx], ett_xti_dscp, dscp_bits, ENC_LITTLE_ENDIAN);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
        }
    }

    return tvb_captured_length(tvb);
}

/* determine PDU length of protocol XTI */
static guint
get_xti_message_len(packet_info *pinfo _U_, tvbuff_t *tvb, int offset, void *data _U_)
{
    return (guint)tvb_get_letohl(tvb, offset);
}

static int
dissect_xti(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree,
        void *data)
{
    tcp_dissect_pdus(tvb, pinfo, tree, TRUE, 4 /* bytes to read for bodylen */,
            get_xti_message_len, dissect_xti_message, data);
    return tvb_captured_length(tvb);
}

void
proto_register_xti(void)
{
    static hf_register_info hf[] ={
          { &hf_xti[ACCOUNT_FH_IDX],
              { "Account", "xti.account",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ACCRUEDINTERESAMT_FH_IDX],
              { "AccruedInteresAmt", "xti.accruedinteresamt",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[AFFECTEDORDERID_FH_IDX],
              { "AffectedOrderID", "xti.affectedorderid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[AFFECTEDORDERREQUESTID_FH_IDX],
              { "AffectedOrderRequestID", "xti.affectedorderrequestid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[AFFECTEDORIGCLORDID_FH_IDX],
              { "AffectedOrigClOrdID", "xti.affectedorigclordid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ALLOCID_FH_IDX],
              { "AllocID", "xti.allocid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ALLOCMETHOD_FH_IDX],
              { "AllocMethod", "xti.allocmethod",
                FT_UINT8, BASE_DEC, VALS(alloc_method_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ALLOCQTY_FH_IDX],
              { "AllocQty", "xti.allocqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLBEGMSGID_FH_IDX],
              { "ApplBegMsgID", "xti.applbegmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLBEGSEQNUM_FH_IDX],
              { "ApplBegSeqNum", "xti.applbegseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLENDMSGID_FH_IDX],
              { "ApplEndMsgID", "xti.applendmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLENDSEQNUM_FH_IDX],
              { "ApplEndSeqNum", "xti.applendseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLID_FH_IDX],
              { "ApplID", "xti.applid",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &appl_id_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLIDSTATUS_FH_IDX],
              { "ApplIDStatus", "xti.applidstatus",
                FT_UINT32, BASE_DEC, VALS(appl_idstatus_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLMSGID_FH_IDX],
              { "ApplMsgID", "xti.applmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLRESENDFLAG_FH_IDX],
              { "ApplResendFlag", "xti.applresendflag",
                FT_UINT8, BASE_DEC, VALS(appl_resend_flag_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLSEQINDICATOR_FH_IDX],
              { "ApplSeqIndicator", "xti.applseqindicator",
                FT_UINT8, BASE_DEC, VALS(appl_seq_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLSEQNUM_FH_IDX],
              { "ApplSeqNum", "xti.applseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLSEQSTATUS_FH_IDX],
              { "ApplSeqStatus", "xti.applseqstatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLSEQTRADEDATE_FH_IDX],
              { "ApplSeqTradeDate", "xti.applseqtradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLSUBID_FH_IDX],
              { "ApplSubID", "xti.applsubid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLTOTALMESSAGECOUNT_FH_IDX],
              { "ApplTotalMessageCount", "xti.appltotalmessagecount",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLUSAGEORDERS_FH_IDX],
              { "ApplUsageOrders", "xti.applusageorders",
                FT_CHAR, BASE_HEX, VALS(appl_usage_orders_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLUSAGEQUOTES_FH_IDX],
              { "ApplUsageQuotes", "xti.applusagequotes",
                FT_CHAR, BASE_HEX, VALS(appl_usage_orders_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLICATIONSYSTEMNAME_FH_IDX],
              { "ApplicationSystemName", "xti.applicationsystemname",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLICATIONSYSTEMVENDOR_FH_IDX],
              { "ApplicationSystemVendor", "xti.applicationsystemvendor",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[APPLICATIONSYSTEMVERSION_FH_IDX],
              { "ApplicationSystemVersion", "xti.applicationsystemversion",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[AUTOAPPROVALRULEID_FH_IDX],
              { "AutoApprovalRuleID", "xti.autoapprovalruleid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[BESTBIDPX_FH_IDX],
              { "BestBidPx", "xti.bestbidpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[BESTBIDSIZE_FH_IDX],
              { "BestBidSize", "xti.bestbidsize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[BESTOFFERPX_FH_IDX],
              { "BestOfferPx", "xti.bestofferpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[BESTOFFERSIZE_FH_IDX],
              { "BestOfferSize", "xti.bestoffersize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[BIDPX_FH_IDX],
              { "BidPx", "xti.bidpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[BIDSIZE_FH_IDX],
              { "BidSize", "xti.bidsize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[BODYLEN_FH_IDX],
              { "BodyLen", "xti.bodylen",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[CLORDID_FH_IDX],
              { "ClOrdID", "xti.clordid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[CLEARINGINSTRUCTION_FH_IDX],
              { "ClearingInstruction", "xti.clearinginstruction",
                FT_UINT8, BASE_DEC, VALS(clearing_instruction_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[COUPONRATE_FH_IDX],
              { "CouponRate", "xti.couponrate",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[CROSSEDINDICATOR_FH_IDX],
              { "CrossedIndicator", "xti.crossedindicator",
                FT_UINT8, BASE_DEC, VALS(crossed_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[CUMQTY_FH_IDX],
              { "CumQty", "xti.cumqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[CURRENCY_FH_IDX],
              { "Currency", "xti.currency",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[CXLQTY_FH_IDX],
              { "CxlQty", "xti.cxlqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[CXLSIZE_FH_IDX],
              { "CxlSize", "xti.cxlsize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[DEFAULTCSTMAPPLVERID_FH_IDX],
              { "DefaultCstmApplVerID", "xti.defaultcstmapplverid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[DEFAULTCSTMAPPLVERSUBID_FH_IDX],
              { "DefaultCstmApplVerSubID", "xti.defaultcstmapplversubid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[DELETEREASON_FH_IDX],
              { "DeleteReason", "xti.deletereason",
                FT_UINT8, BASE_DEC, VALS(delete_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[DELIVERYTYPE_FH_IDX],
              { "DeliveryType", "xti.deliverytype",
                FT_UINT8, BASE_DEC, VALS(delivery_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[DISPLAYHIGHQTY_FH_IDX],
              { "DisplayHighQty", "xti.displayhighqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[DISPLAYLOWQTY_FH_IDX],
              { "DisplayLowQty", "xti.displaylowqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[DISPLAYQTY_FH_IDX],
              { "DisplayQty", "xti.displayqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ENRICHMENTRULEID_FH_IDX],
              { "EnrichmentRuleID", "xti.enrichmentruleid",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EVENTDATE_FH_IDX],
              { "EventDate", "xti.eventdate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EVENTPX_FH_IDX],
              { "EventPx", "xti.eventpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EVENTTYPE_FH_IDX],
              { "EventType", "xti.eventtype",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &event_type_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXECID_FH_IDX],
              { "ExecID", "xti.execid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXECINST_FH_IDX],
              { "ExecInst", "xti.execinst",
                FT_UINT8, BASE_DEC, VALS(exec_inst_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXECRESTATEMENTREASON_FH_IDX],
              { "ExecRestatementReason", "xti.execrestatementreason",
                FT_UINT16, BASE_DEC| BASE_EXT_STRING, &exec_restatement_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXECTYPE_FH_IDX],
              { "ExecType", "xti.exectype",
                FT_CHAR, BASE_HEX| BASE_EXT_STRING, &exec_type_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXECUTINGTRADER_FH_IDX],
              { "ExecutingTrader", "xti.executingtrader",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXECUTINGTRADERQUALIFIER_FH_IDX],
              { "ExecutingTraderQualifier", "xti.executingtraderqualifier",
                FT_UINT8, BASE_DEC, VALS(executing_trader_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXPIREDATE_FH_IDX],
              { "ExpireDate", "xti.expiredate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[EXPIRETIME_FH_IDX],
              { "ExpireTime", "xti.expiretime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FIXCLORDID_FH_IDX],
              { "FIXClOrdID", "xti.fixclordid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FIXENGINENAME_FH_IDX],
              { "FIXEngineName", "xti.fixenginename",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FIXENGINEVENDOR_FH_IDX],
              { "FIXEngineVendor", "xti.fixenginevendor",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FIXENGINEVERSION_FH_IDX],
              { "FIXEngineVersion", "xti.fixengineversion",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FILLEXECID_FH_IDX],
              { "FillExecID", "xti.fillexecid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FILLLIQUIDITYIND_FH_IDX],
              { "FillLiquidityInd", "xti.fillliquidityind",
                FT_UINT8, BASE_DEC, VALS(fill_liquidity_ind_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FILLMATCHID_FH_IDX],
              { "FillMatchID", "xti.fillmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FILLPX_FH_IDX],
              { "FillPx", "xti.fillpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FILLQTY_FH_IDX],
              { "FillQty", "xti.fillqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FIRMNEGOTIATIONID_FH_IDX],
              { "FirmNegotiationID", "xti.firmnegotiationid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FIRMTRADEID_FH_IDX],
              { "FirmTradeID", "xti.firmtradeid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FREETEXT1_FH_IDX],
              { "FreeText1", "xti.freetext1",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FREETEXT2_FH_IDX],
              { "FreeText2", "xti.freetext2",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FREETEXT4_FH_IDX],
              { "FreeText4", "xti.freetext4",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[FREETEXT5_FH_IDX],
              { "FreeText5", "xti.freetext5",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[HEADLINE_FH_IDX],
              { "Headline", "xti.headline",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[HEARTBTINT_FH_IDX],
              { "HeartBtInt", "xti.heartbtint",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[IMBALANCEQTY_FH_IDX],
              { "ImbalanceQty", "xti.imbalanceqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[INDIVIDUALALLOCID_FH_IDX],
              { "IndividualAllocID", "xti.individualallocid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LASTCOUPONDEVIATIONINDICATOR_FH_IDX],
              { "LastCouponDeviationIndicator", "xti.lastcoupondeviationindicator",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &last_coupon_deviation_indicator_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LASTENTITYPROCESSED_FH_IDX],
              { "LastEntityProcessed", "xti.lastentityprocessed",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LASTFRAGMENT_FH_IDX],
              { "LastFragment", "xti.lastfragment",
                FT_UINT8, BASE_DEC, VALS(last_fragment_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LASTMKT_FH_IDX],
              { "LastMkt", "xti.lastmkt",
                FT_UINT16, BASE_DEC| BASE_EXT_STRING, &last_mkt_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LASTPX_FH_IDX],
              { "LastPx", "xti.lastpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LASTQTY_FH_IDX],
              { "LastQty", "xti.lastqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LEAVESQTY_FH_IDX],
              { "LeavesQty", "xti.leavesqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[LISTUPDATEACTION_FH_IDX],
              { "ListUpdateAction", "xti.listupdateaction",
                FT_CHAR, BASE_HEX, VALS(list_update_action_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MDBOOKTYPE_FH_IDX],
              { "MDBookType", "xti.mdbooktype",
                FT_UINT8, BASE_DEC, VALS(mdbook_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MDSUBBOOKTYPE_FH_IDX],
              { "MDSubBookType", "xti.mdsubbooktype",
                FT_UINT8, BASE_DEC, VALS(mdsub_book_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MARKETID_FH_IDX],
              { "MarketID", "xti.marketid",
                FT_UINT16, BASE_DEC| BASE_EXT_STRING, &last_mkt_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MARKETSEGMENTID_FH_IDX],
              { "MarketSegmentID", "xti.marketsegmentid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MASSACTIONREASON_FH_IDX],
              { "MassActionReason", "xti.massactionreason",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &mass_action_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MASSACTIONREPORTID_FH_IDX],
              { "MassActionReportID", "xti.massactionreportid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MASSACTIONTYPE_FH_IDX],
              { "MassActionType", "xti.massactiontype",
                FT_UINT8, BASE_DEC, VALS(mass_action_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MATCHDATE_FH_IDX],
              { "MatchDate", "xti.matchdate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MATCHINSTCROSSID_FH_IDX],
              { "MatchInstCrossID", "xti.matchinstcrossid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MATCHSUBTYPE_FH_IDX],
              { "MatchSubType", "xti.matchsubtype",
                FT_UINT8, BASE_DEC, VALS(match_sub_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MATCHTYPE_FH_IDX],
              { "MatchType", "xti.matchtype",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &match_type_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MATCHINGENGINESTATUS_FH_IDX],
              { "MatchingEngineStatus", "xti.matchingenginestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MATCHINGENGINETRADEDATE_FH_IDX],
              { "MatchingEngineTradeDate", "xti.matchingenginetradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MESSAGEEVENTSOURCE_FH_IDX],
              { "MessageEventSource", "xti.messageeventsource",
                FT_CHAR, BASE_HEX, VALS(message_event_source_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[MSGSEQNUM_FH_IDX],
              { "MsgSeqNum", "xti.msgseqnum",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NEGOTIATIONID_FH_IDX],
              { "NegotiationID", "xti.negotiationid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NEGOTIATIONSTARTTIME_FH_IDX],
              { "NegotiationStartTime", "xti.negotiationstarttime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NETWORKMSGID_FH_IDX],
              { "NetworkMsgID", "xti.networkmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOAFFECTEDORDERREQUESTS_FH_IDX],
              { "NoAffectedOrderRequests", "xti.noaffectedorderrequests",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOAFFECTEDORDERS_FH_IDX],
              { "NoAffectedOrders", "xti.noaffectedorders",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOENRICHMENTRULES_FH_IDX],
              { "NoEnrichmentRules", "xti.noenrichmentrules",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOEVENTS_FH_IDX],
              { "NoEvents", "xti.noevents",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOFILLS_FH_IDX],
              { "NoFills", "xti.nofills",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NONOTAFFECTEDORDERS_FH_IDX],
              { "NoNotAffectedOrders", "xti.nonotaffectedorders",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NONOTAFFECTEDSECURITIES_FH_IDX],
              { "NoNotAffectedSecurities", "xti.nonotaffectedsecurities",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOORDERBOOKITEMS_FH_IDX],
              { "NoOrderBookItems", "xti.noorderbookitems",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOORDEREVENTS_FH_IDX],
              { "NoOrderEvents", "xti.noorderevents",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOPARTYDETAILS_FH_IDX],
              { "NoPartyDetails", "xti.nopartydetails",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOQUOTEENTRIES_FH_IDX],
              { "NoQuoteEntries", "xti.noquoteentries",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOQUOTEEVENTS_FH_IDX],
              { "NoQuoteEvents", "xti.noquoteevents",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOQUOTESIDEENTRIES_FH_IDX],
              { "NoQuoteSideEntries", "xti.noquotesideentries",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOSESSIONS_FH_IDX],
              { "NoSessions", "xti.nosessions",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOSIDEALLOCS_FH_IDX],
              { "NoSideAllocs", "xti.nosideallocs",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOTARGETPARTYIDS_FH_IDX],
              { "NoTargetPartyIDs", "xti.notargetpartyids",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOTAFFORIGCLORDID_FH_IDX],
              { "NotAffOrigClOrdID", "xti.notafforigclordid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOTAFFECTEDORDERID_FH_IDX],
              { "NotAffectedOrderID", "xti.notaffectedorderid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOTAFFECTEDSECURITYID_FH_IDX],
              { "NotAffectedSecurityID", "xti.notaffectedsecurityid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NOTIFICATIONIN_FH_IDX],
              { "NotificationIn", "xti.notificationin",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NUMDAYSINTEREST_FH_IDX],
              { "NumDaysInterest", "xti.numdaysinterest",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX],
              { "NumberOfRespDisclosureInstruction", "xti.numberofrespdisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(number_of_resp_disclosure_instruction_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[NUMBEROFRESPONDENTS_FH_IDX],
              { "NumberOfRespondents", "xti.numberofrespondents",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[OFFERPX_FH_IDX],
              { "OfferPx", "xti.offerpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[OFFERSIZE_FH_IDX],
              { "OfferSize", "xti.offersize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDSTATUS_FH_IDX],
              { "OrdStatus", "xti.ordstatus",
                FT_CHAR, BASE_HEX| BASE_EXT_STRING, &ord_status_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDTYPE_FH_IDX],
              { "OrdType", "xti.ordtype",
                FT_UINT8, BASE_DEC, VALS(ord_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX],
              { "OrderAttributeLiquidityProvision", "xti.orderattributeliquidityprovision",
                FT_UINT8, BASE_DEC, VALS(order_attribute_liquidity_provision_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDERCATEGORY_FH_IDX],
              { "OrderCategory", "xti.ordercategory",
                FT_CHAR, BASE_HEX, VALS(order_category_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDEREVENTMATCHID_FH_IDX],
              { "OrderEventMatchID", "xti.ordereventmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDEREVENTPX_FH_IDX],
              { "OrderEventPx", "xti.ordereventpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDEREVENTQTY_FH_IDX],
              { "OrderEventQty", "xti.ordereventqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDEREVENTREASON_FH_IDX],
              { "OrderEventReason", "xti.ordereventreason",
                FT_UINT8, BASE_DEC, VALS(order_event_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDEREVENTTYPE_FH_IDX],
              { "OrderEventType", "xti.ordereventtype",
                FT_UINT8, BASE_DEC, VALS(order_event_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDERID_FH_IDX],
              { "OrderID", "xti.orderid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDERIDSFX_FH_IDX],
              { "OrderIDSfx", "xti.orderidsfx",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDERORIGINATION_FH_IDX],
              { "OrderOrigination", "xti.orderorigination",
                FT_UINT8, BASE_DEC, VALS(order_origination_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDERQTY_FH_IDX],
              { "OrderQty", "xti.orderqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORDERROUTINGINDICATOR_FH_IDX],
              { "OrderRoutingIndicator", "xti.orderroutingindicator",
                FT_CHAR, BASE_HEX, VALS(order_routing_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORIGCLORDID_FH_IDX],
              { "OrigClOrdID", "xti.origclordid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORIGTIME_FH_IDX],
              { "OrigTime", "xti.origtime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ORIGTRADEID_FH_IDX],
              { "OrigTradeID", "xti.origtradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[OWNERSHIPINDICATOR_FH_IDX],
              { "OwnershipIndicator", "xti.ownershipindicator",
                FT_UINT8, BASE_DEC, VALS(ownership_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PACKAGEID_FH_IDX],
              { "PackageID", "xti.packageid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTITIONID_FH_IDX],
              { "PartitionID", "xti.partitionid",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYACTIONTYPE_FH_IDX],
              { "PartyActionType", "xti.partyactiontype",
                FT_UINT8, BASE_DEC, VALS(party_action_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYDETAILDESKID_FH_IDX],
              { "PartyDetailDeskID", "xti.partydetaildeskid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYDETAILEXECUTINGTRADER_FH_IDX],
              { "PartyDetailExecutingTrader", "xti.partydetailexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYDETAILIDEXECUTINGTRADER_FH_IDX],
              { "PartyDetailIDExecutingTrader", "xti.partydetailidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYDETAILIDEXECUTINGUNIT_FH_IDX],
              { "PartyDetailIDExecutingUnit", "xti.partydetailidexecutingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYDETAILROLEQUALIFIER_FH_IDX],
              { "PartyDetailRoleQualifier", "xti.partydetailrolequalifier",
                FT_UINT8, BASE_DEC, VALS(party_detail_role_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYDETAILSTATUS_FH_IDX],
              { "PartyDetailStatus", "xti.partydetailstatus",
                FT_UINT8, BASE_DEC, VALS(party_detail_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYENTERINGFIRM_FH_IDX],
              { "PartyEnteringFirm", "xti.partyenteringfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYENTERINGTRADER_FH_IDX],
              { "PartyEnteringTrader", "xti.partyenteringtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYEXECUTINGFIRM_FH_IDX],
              { "PartyExecutingFirm", "xti.partyexecutingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYEXECUTINGTRADER_FH_IDX],
              { "PartyExecutingTrader", "xti.partyexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDCLIENTID_FH_IDX],
              { "PartyIDClientID", "xti.partyidclientid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDENTERINGFIRM_FH_IDX],
              { "PartyIDEnteringFirm", "xti.partyidenteringfirm",
                FT_UINT8, BASE_DEC, VALS(party_identering_firm_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDENTERINGTRADER_FH_IDX],
              { "PartyIDEnteringTrader", "xti.partyidenteringtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDEXECUTINGTRADER_FH_IDX],
              { "PartyIDExecutingTrader", "xti.partyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDEXECUTINGUNIT_FH_IDX],
              { "PartyIDExecutingUnit", "xti.partyidexecutingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDSESSIONID_FH_IDX],
              { "PartyIDSessionID", "xti.partyidsessionid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDSPECIALISTTRADER_FH_IDX],
              { "PartyIDSpecialistTrader", "xti.partyidspecialisttrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDINVESTMENTDECISIONMAKER_FH_IDX],
              { "PartyIdInvestmentDecisionMaker", "xti.partyidinvestmentdecisionmaker",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX],
              { "PartyIdInvestmentDecisionMakerQualifier", "xti.partyidinvestmentdecisionmakerqualifier",
                FT_UINT8, BASE_DEC, VALS(executing_trader_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYSPECIALISTFIRM_FH_IDX],
              { "PartySpecialistFirm", "xti.partyspecialistfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PARTYSPECIALISTTRADER_FH_IDX],
              { "PartySpecialistTrader", "xti.partyspecialisttrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PASSWORD_FH_IDX],
              { "Password", "xti.password",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PEGOFFSETVALUEABS_FH_IDX],
              { "PegOffsetValueAbs", "xti.pegoffsetvalueabs",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PEGOFFSETVALUEPCT_FH_IDX],
              { "PegOffsetValuePct", "xti.pegoffsetvaluepct",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[POTENTIALEXECVOLUME_FH_IDX],
              { "PotentialExecVolume", "xti.potentialexecvolume",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PRICE_FH_IDX],
              { "Price", "xti.price",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[PRICEVALIDITYCHECKTYPE_FH_IDX],
              { "PriceValidityCheckType", "xti.pricevaliditychecktype",
                FT_UINT8, BASE_DEC, VALS(price_validity_check_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTECANCELTYPE_FH_IDX],
              { "QuoteCancelType", "xti.quotecanceltype",
                FT_UINT8, BASE_DEC, VALS(quote_cancel_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEENTRYREJECTREASON_FH_IDX],
              { "QuoteEntryRejectReason", "xti.quoteentryrejectreason",
                FT_UINT32, BASE_DEC| BASE_EXT_STRING, &quote_entry_reject_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEENTRYSTATUS_FH_IDX],
              { "QuoteEntryStatus", "xti.quoteentrystatus",
                FT_UINT8, BASE_DEC, VALS(quote_entry_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTEXECID_FH_IDX],
              { "QuoteEventExecID", "xti.quoteeventexecid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTLIQUIDITYIND_FH_IDX],
              { "QuoteEventLiquidityInd", "xti.quoteeventliquidityind",
                FT_UINT8, BASE_DEC, VALS(quote_event_liquidity_ind_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTMATCHID_FH_IDX],
              { "QuoteEventMatchID", "xti.quoteeventmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTPX_FH_IDX],
              { "QuoteEventPx", "xti.quoteeventpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTQTY_FH_IDX],
              { "QuoteEventQty", "xti.quoteeventqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTREASON_FH_IDX],
              { "QuoteEventReason", "xti.quoteeventreason",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &quote_event_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTSIDE_FH_IDX],
              { "QuoteEventSide", "xti.quoteeventside",
                FT_UINT8, BASE_DEC, VALS(quote_event_side_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEEVENTTYPE_FH_IDX],
              { "QuoteEventType", "xti.quoteeventtype",
                FT_UINT8, BASE_DEC, VALS(quote_event_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEID_FH_IDX],
              { "QuoteID", "xti.quoteid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEMSGID_FH_IDX],
              { "QuoteMsgID", "xti.quotemsgid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEREQID_FH_IDX],
              { "QuoteReqID", "xti.quotereqid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTEREQUESTREJECTREASON_FH_IDX],
              { "QuoteRequestRejectReason", "xti.quoterequestrejectreason",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &quote_request_reject_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTERESPONSEID_FH_IDX],
              { "QuoteResponseID", "xti.quoteresponseid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTESIZETYPE_FH_IDX],
              { "QuoteSizeType", "xti.quotesizetype",
                FT_UINT8, BASE_DEC, VALS(quote_size_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTESTATUS_FH_IDX],
              { "QuoteStatus", "xti.quotestatus",
                FT_UINT8, BASE_DEC, VALS(quote_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTETYPE_FH_IDX],
              { "QuoteType", "xti.quotetype",
                FT_UINT8, BASE_DEC, VALS(quote_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[QUOTINGSTATUS_FH_IDX],
              { "QuotingStatus", "xti.quotingstatus",
                FT_UINT8, BASE_DEC, VALS(quoting_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[RFQPUBLISHINDICATOR_FH_IDX],
              { "RFQPublishIndicator", "xti.rfqpublishindicator",
                FT_UINT8, BASE_DEC, VALS(rfqpublish_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[RFQREQUESTERDISCLOSUREINSTRUCTION_FH_IDX],
              { "RFQRequesterDisclosureInstruction", "xti.rfqrequesterdisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(number_of_resp_disclosure_instruction_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REFAPPLID_FH_IDX],
              { "RefApplID", "xti.refapplid",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &appl_id_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REFAPPLLASTMSGID_FH_IDX],
              { "RefApplLastMsgID", "xti.refappllastmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REFAPPLLASTSEQNUM_FH_IDX],
              { "RefApplLastSeqNum", "xti.refappllastseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REFAPPLSUBID_FH_IDX],
              { "RefApplSubID", "xti.refapplsubid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REFINANCINGELIGIBILITYINDICATOR_FH_IDX],
              { "RefinancingEligibilityIndicator", "xti.refinancingeligibilityindicator",
                FT_UINT8, BASE_DEC, VALS(number_of_resp_disclosure_instruction_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REGULATORYTRADEID_FH_IDX],
              { "RegulatoryTradeID", "xti.regulatorytradeid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REQUESTTIME_FH_IDX],
              { "RequestTime", "xti.requesttime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REQUESTINGPARTYCLEARINGFIRM_FH_IDX],
              { "RequestingPartyClearingFirm", "xti.requestingpartyclearingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REQUESTINGPARTYENTERINGFIRM_FH_IDX],
              { "RequestingPartyEnteringFirm", "xti.requestingpartyenteringfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REQUESTINGPARTYIDENTERINGFIRM_FH_IDX],
              { "RequestingPartyIDEnteringFirm", "xti.requestingpartyidenteringfirm",
                FT_UINT8, BASE_DEC, VALS(party_identering_firm_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX],
              { "RequestingPartyIDExecutingSystem", "xti.requestingpartyidexecutingsystem",
                FT_UINT32, BASE_DEC, VALS(requesting_party_idexecuting_system_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[REQUESTINGPARTYIDEXECUTINGTRADER_FH_IDX],
              { "RequestingPartyIDExecutingTrader", "xti.requestingpartyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[RESPONDENTTYPE_FH_IDX],
              { "RespondentType", "xti.respondenttype",
                FT_UINT8, BASE_DEC, VALS(respondent_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[RESPONSEIN_FH_IDX],
              { "ResponseIn", "xti.responsein",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYCLEARINGFIRM_FH_IDX],
              { "RootPartyClearingFirm", "xti.rootpartyclearingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYCONTRAFIRM_FH_IDX],
              { "RootPartyContraFirm", "xti.rootpartycontrafirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYCONTRAFIRMKVNUMBER_FH_IDX],
              { "RootPartyContraFirmKVNumber", "xti.rootpartycontrafirmkvnumber",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYCONTRASETTLEMENTACCOUNT_FH_IDX],
              { "RootPartyContraSettlementAccount", "xti.rootpartycontrasettlementaccount",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYCONTRASETTLEMENTFIRM_FH_IDX],
              { "RootPartyContraSettlementFirm", "xti.rootpartycontrasettlementfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYCONTRASETTLEMENTLOCATION_FH_IDX],
              { "RootPartyContraSettlementLocation", "xti.rootpartycontrasettlementlocation",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYENTERINGTRADER_FH_IDX],
              { "RootPartyEnteringTrader", "xti.rootpartyenteringtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYEXECUTINGFIRM_FH_IDX],
              { "RootPartyExecutingFirm", "xti.rootpartyexecutingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYEXECUTINGFIRMKVNUMBER_FH_IDX],
              { "RootPartyExecutingFirmKVNumber", "xti.rootpartyexecutingfirmkvnumber",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYEXECUTINGTRADER_FH_IDX],
              { "RootPartyExecutingTrader", "xti.rootpartyexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDCLEARINGUNIT_FH_IDX],
              { "RootPartyIDClearingUnit", "xti.rootpartyidclearingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDCLIENTID_FH_IDX],
              { "RootPartyIDClientID", "xti.rootpartyidclientid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDCONTRASETTLEMENTUNIT_FH_IDX],
              { "RootPartyIDContraSettlementUnit", "xti.rootpartyidcontrasettlementunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDCONTRAUNIT_FH_IDX],
              { "RootPartyIDContraUnit", "xti.rootpartyidcontraunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDEXECUTINGTRADER_FH_IDX],
              { "RootPartyIDExecutingTrader", "xti.rootpartyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDEXECUTINGUNIT_FH_IDX],
              { "RootPartyIDExecutingUnit", "xti.rootpartyidexecutingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDEXECUTIONVENUE_FH_IDX],
              { "RootPartyIDExecutionVenue", "xti.rootpartyidexecutionvenue",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX],
              { "RootPartyIDInvestmentDecisionMaker", "xti.rootpartyidinvestmentdecisionmaker",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX],
              { "RootPartyIDInvestmentDecisionMakerQualifier", "xti.rootpartyidinvestmentdecisionmakerqualifier",
                FT_UINT8, BASE_DEC, VALS(executing_trader_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDSESSIONID_FH_IDX],
              { "RootPartyIDSessionID", "xti.rootpartyidsessionid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYIDSETTLEMENTUNIT_FH_IDX],
              { "RootPartyIDSettlementUnit", "xti.rootpartyidsettlementunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYSETTLEMENTACCOUNT_FH_IDX],
              { "RootPartySettlementAccount", "xti.rootpartysettlementaccount",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYSETTLEMENTFIRM_FH_IDX],
              { "RootPartySettlementFirm", "xti.rootpartysettlementfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[ROOTPARTYSETTLEMENTLOCATION_FH_IDX],
              { "RootPartySettlementLocation", "xti.rootpartysettlementlocation",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SRQSRELATEDTRADEID_FH_IDX],
              { "SRQSRelatedTradeID", "xti.srqsrelatedtradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SECONDARYQUOTEID_FH_IDX],
              { "SecondaryQuoteID", "xti.secondaryquoteid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SECONDARYTRADEID_FH_IDX],
              { "SecondaryTradeID", "xti.secondarytradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SECURITYID_FH_IDX],
              { "SecurityID", "xti.securityid",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SECURITYSTATUS_FH_IDX],
              { "SecurityStatus", "xti.securitystatus",
                FT_UINT8, BASE_DEC, VALS(security_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SECURITYSTATUSREPORTID_FH_IDX],
              { "SecurityStatusReportID", "xti.securitystatusreportid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SECURITYTRADINGSTATUS_FH_IDX],
              { "SecurityTradingStatus", "xti.securitytradingstatus",
                FT_UINT8, BASE_DEC, VALS(security_trading_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SELECTIVEREQUESTFORQUOTERTMSERVICESTATUS_FH_IDX],
              { "SelectiveRequestForQuoteRtmServiceStatus", "xti.selectiverequestforquotertmservicestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SELECTIVEREQUESTFORQUOTESERVICESTATUS_FH_IDX],
              { "SelectiveRequestForQuoteServiceStatus", "xti.selectiverequestforquoteservicestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SELECTIVEREQUESTFORQUOTESERVICETRADEDATE_FH_IDX],
              { "SelectiveRequestForQuoteServiceTradeDate", "xti.selectiverequestforquoteservicetradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SENDERSUBID_FH_IDX],
              { "SenderSubID", "xti.sendersubid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SENDINGTIME_FH_IDX],
              { "SendingTime", "xti.sendingtime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SESSIONINSTANCEID_FH_IDX],
              { "SessionInstanceID", "xti.sessioninstanceid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SESSIONMODE_FH_IDX],
              { "SessionMode", "xti.sessionmode",
                FT_UINT8, BASE_DEC, VALS(session_mode_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SESSIONREJECTREASON_FH_IDX],
              { "SessionRejectReason", "xti.sessionrejectreason",
                FT_UINT32, BASE_DEC| BASE_EXT_STRING, &session_reject_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SESSIONSTATUS_FH_IDX],
              { "SessionStatus", "xti.sessionstatus",
                FT_UINT8, BASE_DEC, VALS(session_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SESSIONSUBMODE_FH_IDX],
              { "SessionSubMode", "xti.sessionsubmode",
                FT_UINT8, BASE_DEC, VALS(session_sub_mode_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SETTLCURRAMT_FH_IDX],
              { "SettlCurrAmt", "xti.settlcurramt",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SETTLCURRFXRATE_FH_IDX],
              { "SettlCurrFxRate", "xti.settlcurrfxrate",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SETTLCURRENCY_FH_IDX],
              { "SettlCurrency", "xti.settlcurrency",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SETTLDATE_FH_IDX],
              { "SettlDate", "xti.settldate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SIDE_FH_IDX],
              { "Side", "xti.side",
                FT_UINT8, BASE_DEC, VALS(quote_event_side_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SIDEGROSSTRADEAMT_FH_IDX],
              { "SideGrossTradeAmt", "xti.sidegrosstradeamt",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SIDELASTQTY_FH_IDX],
              { "SideLastQty", "xti.sidelastqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SIDELIQUIDITYIND_FH_IDX],
              { "SideLiquidityInd", "xti.sideliquidityind",
                FT_UINT8, BASE_DEC, VALS(quote_event_liquidity_ind_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SIDETRADEID_FH_IDX],
              { "SideTradeID", "xti.sidetradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SIDETRADEREPORTID_FH_IDX],
              { "SideTradeReportID", "xti.sidetradereportid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SOLDOUTINDICATOR_FH_IDX],
              { "SoldOutIndicator", "xti.soldoutindicator",
                FT_UINT8, BASE_DEC, VALS(sold_out_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[STOPPX_FH_IDX],
              { "StopPx", "xti.stoppx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[STOPPXINDICATOR_FH_IDX],
              { "StopPxIndicator", "xti.stoppxindicator",
                FT_UINT8, BASE_DEC, VALS(stop_px_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[SUBSCRIPTIONSCOPE_FH_IDX],
              { "SubscriptionScope", "xti.subscriptionscope",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[T7ENTRYSERVICERTMSTATUS_FH_IDX],
              { "T7EntryServiceRtmStatus", "xti.t7entryservicertmstatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[T7ENTRYSERVICERTMTRADEDATE_FH_IDX],
              { "T7EntryServiceRtmTradeDate", "xti.t7entryservicertmtradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[T7ENTRYSERVICESTATUS_FH_IDX],
              { "T7EntryServiceStatus", "xti.t7entryservicestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[T7ENTRYSERVICETRADEDATE_FH_IDX],
              { "T7EntryServiceTradeDate", "xti.t7entryservicetradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TESENRICHMENTRULEID_FH_IDX],
              { "TESEnrichmentRuleID", "xti.tesenrichmentruleid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TESEXECID_FH_IDX],
              { "TESExecID", "xti.tesexecid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TARGETPARTYENTERINGTRADER_FH_IDX],
              { "TargetPartyEnteringTrader", "xti.targetpartyenteringtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TARGETPARTYEXECUTINGFIRM_FH_IDX],
              { "TargetPartyExecutingFirm", "xti.targetpartyexecutingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TARGETPARTYEXECUTINGTRADER_FH_IDX],
              { "TargetPartyExecutingTrader", "xti.targetpartyexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TARGETPARTYIDDESKID_FH_IDX],
              { "TargetPartyIDDeskID", "xti.targetpartyiddeskid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TARGETPARTYIDEXECUTINGTRADER_FH_IDX],
              { "TargetPartyIDExecutingTrader", "xti.targetpartyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TARGETPARTYIDSESSIONID_FH_IDX],
              { "TargetPartyIDSessionID", "xti.targetpartyidsessionid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TEMPLATEID_FH_IDX],
              { "TemplateID", "xti.templateid",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[THROTTLEDISCONNECTLIMIT_FH_IDX],
              { "ThrottleDisconnectLimit", "xti.throttledisconnectlimit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[THROTTLENOMSGS_FH_IDX],
              { "ThrottleNoMsgs", "xti.throttlenomsgs",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[THROTTLETIMEINTERVAL_FH_IDX],
              { "ThrottleTimeInterval", "xti.throttletimeinterval",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TIMEINFORCE_FH_IDX],
              { "TimeInForce", "xti.timeinforce",
                FT_UINT8, BASE_DEC, VALS(time_in_force_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADSESEVENT_FH_IDX],
              { "TradSesEvent", "xti.tradsesevent",
                FT_UINT8, BASE_DEC, VALS(trad_ses_event_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADSESMODE_FH_IDX],
              { "TradSesMode", "xti.tradsesmode",
                FT_UINT8, BASE_DEC, VALS(trad_ses_mode_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEALLOCSTATUS_FH_IDX],
              { "TradeAllocStatus", "xti.tradeallocstatus",
                FT_UINT8, BASE_DEC, VALS(trade_alloc_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEATCLOSEOPTIN_FH_IDX],
              { "TradeAtCloseOptIn", "xti.tradeatcloseoptin",
                FT_UINT8, BASE_DEC, VALS(number_of_resp_disclosure_instruction_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEDATE_FH_IDX],
              { "TradeDate", "xti.tradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEID_FH_IDX],
              { "TradeID", "xti.tradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEMANAGERSTATUS_FH_IDX],
              { "TradeManagerStatus", "xti.trademanagerstatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEMANAGERTRADEDATE_FH_IDX],
              { "TradeManagerTradeDate", "xti.trademanagertradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADENUMBER_FH_IDX],
              { "TradeNumber", "xti.tradenumber",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEPUBLISHINDICATOR_FH_IDX],
              { "TradePublishIndicator", "xti.tradepublishindicator",
                FT_UINT8, BASE_DEC, VALS(trade_publish_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEREPORTID_FH_IDX],
              { "TradeReportID", "xti.tradereportid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEREPORTTEXT_FH_IDX],
              { "TradeReportText", "xti.tradereporttext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADEREPORTTYPE_FH_IDX],
              { "TradeReportType", "xti.tradereporttype",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &trade_report_type_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADINGCAPACITY_FH_IDX],
              { "TradingCapacity", "xti.tradingcapacity",
                FT_UINT8, BASE_DEC, VALS(trading_capacity_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRADINGSESSIONSUBID_FH_IDX],
              { "TradingSessionSubID", "xti.tradingsessionsubid",
                FT_UINT8, BASE_DEC, VALS(trading_session_sub_id_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRANSBKDTIME_FH_IDX],
              { "TransBkdTime", "xti.transbkdtime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRANSACTTIME_FH_IDX],
              { "TransactTime", "xti.transacttime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRANSACTIONDELAYINDICATOR_FH_IDX],
              { "TransactionDelayIndicator", "xti.transactiondelayindicator",
                FT_UINT8, BASE_DEC, VALS(transaction_delay_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRANSFERREASON_FH_IDX],
              { "TransferReason", "xti.transferreason",
                FT_UINT8, BASE_DEC, VALS(transfer_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDMATCHID_FH_IDX],
              { "TrdMatchID", "xti.trdmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDREGTSENTRYTIME_FH_IDX],
              { "TrdRegTSEntryTime", "xti.trdregtsentrytime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDREGTSEXECUTIONTIME_FH_IDX],
              { "TrdRegTSExecutionTime", "xti.trdregtsexecutiontime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDREGTSTIMEIN_FH_IDX],
              { "TrdRegTSTimeIn", "xti.trdregtstimein",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDREGTSTIMEOUT_FH_IDX],
              { "TrdRegTSTimeOut", "xti.trdregtstimeout",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDREGTSTIMEPRIORITY_FH_IDX],
              { "TrdRegTSTimePriority", "xti.trdregtstimepriority",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDRPTSTATUS_FH_IDX],
              { "TrdRptStatus", "xti.trdrptstatus",
                FT_UINT8, BASE_DEC, VALS(trd_rpt_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRDTYPE_FH_IDX],
              { "TrdType", "xti.trdtype",
                FT_UINT16, BASE_DEC, VALS(trd_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[TRIGGERED_FH_IDX],
              { "Triggered", "xti.triggered",
                FT_UINT8, BASE_DEC, VALS(triggered_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[USERSTATUS_FH_IDX],
              { "UserStatus", "xti.userstatus",
                FT_UINT8, BASE_DEC, VALS(user_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[USERNAME_FH_IDX],
              { "Username", "xti.username",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[VALIDUNTILTIME_FH_IDX],
              { "ValidUntilTime", "xti.validuntiltime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[VALUECHECKTYPEQUANTITY_FH_IDX],
              { "ValueCheckTypeQuantity", "xti.valuechecktypequantity",
                FT_UINT8, BASE_DEC, VALS(value_check_type_quantity_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[VALUECHECKTYPEVALUE_FH_IDX],
              { "ValueCheckTypeValue", "xti.valuechecktypevalue",
                FT_UINT8, BASE_DEC, VALS(value_check_type_quantity_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[VARTEXT_FH_IDX],
              { "VarText", "xti.vartext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[VARTEXTLEN_FH_IDX],
              { "VarTextLen", "xti.vartextlen",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti[VOLUMEDISCOVERYPRICE_FH_IDX],
              { "VolumeDiscoveryPrice", "xti.volumediscoveryprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_xti_dscp_exec_summary,
              { "DSCP_ExecSummary", "xti.dscp_execsummary",
                FT_BOOLEAN, 8, NULL, 0x10,
                NULL, HFILL }
          }
        , { &hf_xti_dscp_improved,
              { "DSCP_Improved", "xti.dscp_improved",
                FT_BOOLEAN, 8, NULL, 0x20,
                NULL, HFILL }
          }
        , { &hf_xti_dscp_widened,
              { "DSCP_Widened", "xti.dscp_widened",
                FT_BOOLEAN, 8, NULL, 0x40,
                NULL, HFILL }
          }
    };
    static ei_register_info ei[] = {
        {
            &ei_xti_counter_overflow,
            { "xti.counter_overflow", PI_PROTOCOL, PI_WARN, "Counter Overflow", EXPFILL }
        },
        {
            &ei_xti_invalid_template,
            { "xti.invalid_template", PI_PROTOCOL, PI_ERROR, "Invalid Template ID", EXPFILL }
        },
        {
            &ei_xti_invalid_length,
            { "xti.invalid_length", PI_PROTOCOL, PI_ERROR, "Invalid Body Length", EXPFILL }
        },
        {
            &ei_xti_unaligned,
            { "xti.unaligned", PI_PROTOCOL, PI_ERROR, "A Body Length not divisible by 8 leads to unaligned followup messages", EXPFILL }
        },
        {
            &ei_xti_missing,
            { "xti.missing", PI_PROTOCOL, PI_WARN, "A required value is missing", EXPFILL }
        },
        {
            &ei_xti_overused,
            { "xti.overused", PI_PROTOCOL, PI_WARN, "An unused value is set", EXPFILL }
        }
    };
    proto_xti = proto_register_protocol("Enhanced Cash Trading Interface 10.0",
            "XTI", "xti");
    expert_module_t *expert_xti = expert_register_protocol(proto_xti);
    expert_register_field_array(expert_xti, ei, array_length(ei));
    proto_register_field_array(proto_xti, hf, array_length(hf));
    static gint * const ett[] = { &ett_xti[0], &ett_xti[1], &ett_xti[2], &ett_xti[3], &ett_xti[4], &ett_xti[5], &ett_xti[6], &ett_xti[7], &ett_xti[8], &ett_xti[9], &ett_xti[10], &ett_xti[11], &ett_xti[12], &ett_xti[13], &ett_xti[14], &ett_xti[15], &ett_xti[16], &ett_xti[17], &ett_xti[18], &ett_xti[19], &ett_xti[20], &ett_xti[21], &ett_xti[22], &ett_xti[23], &ett_xti[24], &ett_xti[25], &ett_xti[26], &ett_xti[27], &ett_xti[28], &ett_xti[29], &ett_xti[30], &ett_xti[31], &ett_xti_dscp };
    proto_register_subtree_array(ett, array_length(ett));
    xti_handle = register_dissector("xti", dissect_xti, proto_xti);
}

void
proto_reg_handoff_xti(void)
{
    // cf. N7 Network Access Guide, e.g.
    // https://www.xetra.com/xetra-en/technology/t7/system-documentation/release10-0/Release-10.0-2692700?frag=2692724
    // https://www.xetra.com/resource/blob/2762078/388b727972b5122945eedf0e63c36920/data/N7-Network-Access-Guide-v2.0.59.pdf


    // NB: unfortunately, Cash-ETI shares the same ports as Derivatives-ETI ...
    //     We thus can't really add a well-know port for XTI.
    //     Use Wireshark's `Decode As...` or tshark's `-d tcp.port=19043,xti` feature
    //     to switch from ETI to XTI dissection.
    dissector_add_uint_with_preference("tcp.port", 19042 /* dummy */, xti_handle);
}
