/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-x2ap.c                                                              */
/* asn2wrs.py -p x2ap -c ./x2ap.cnf -s ./packet-x2ap-template -D . -O ../.. X2AP-CommonDataTypes.asn X2AP-Constants.asn X2AP-Containers.asn X2AP-IEs.asn X2AP-PDU-Contents.asn X2AP-PDU-Descriptions.asn */

/* Input file: packet-x2ap-template.c */

#line 1 "./asn1/x2ap/packet-x2ap-template.c"
/* packet-x2ap.c
 * Routines for dissecting Evolved Universal Terrestrial Radio Access Network (EUTRAN);
 * X2 Application Protocol (X2AP);
 * 3GPP TS 36.423 packet dissection
 * Copyright 2007-2014, Anders Broman <anders.broman@ericsson.com>
 * Copyright 2016-2022, Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Ref:
 * 3GPP TS 36.423 V16.9.0 (2022-04)
 */

#include "config.h"

#include <epan/packet.h>
#include <epan/tfs.h>
#include <epan/asn1.h>
#include <epan/prefs.h>
#include <epan/sctpppids.h>
#include <epan/proto_data.h>

#include "packet-x2ap.h"
#include "packet-per.h"
#include "packet-e212.h"
#include "packet-lte-rrc.h"
#include "packet-nr-rrc.h"
#include "packet-ngap.h"
#include "packet-ranap.h"
#include "packet-ntp.h"
#include "packet-s1ap.h"
#include "packet-f1ap.h"
#include "packet-xnap.h"

#ifdef _MSC_VER
/* disable: "warning C4146: unary minus operator applied to unsigned type, result still unsigned" */
#pragma warning(disable:4146)
#endif

#define PNAME  "EUTRAN X2 Application Protocol (X2AP)"
#define PSNAME "X2AP"
#define PFNAME "x2ap"

void proto_register_x2ap(void);

/* Dissector will use SCTP PPID 27 or SCTP port. IANA assigned port = 36422 */
#define SCTP_PORT_X2AP	36422


/*--- Included file: packet-x2ap-val.h ---*/
#line 1 "./asn1/x2ap/packet-x2ap-val.h"
#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxEARFCN                      65535
#define maxEARFCNPlusOne               65536
#define newmaxEARFCN                   262143
#define maxInterfaces                  16
#define maxCellineNB                   256
#define maxnoofBands                   16
#define maxnoofBearers                 256
#define maxNrOfErrors                  256
#define maxnoofPDCP_SN                 16
#define maxnoofEPLMNs                  15
#define maxnoofEPLMNsPlusOne           16
#define maxnoofForbLACs                4096
#define maxnoofForbTACs                4096
#define maxnoofBPLMNs                  6
#define maxnoofAdditionalPLMNs         6
#define maxnoofNeighbours              512
#define maxnoofPRBs                    110
#define maxPools                       16
#define maxnoofCells                   16
#define maxnoofMBSFN                   8
#define maxFailedMeasObjects           32
#define maxnoofCellIDforMDT            32
#define maxnoofTAforMDT                8
#define maxnoofMBMSServiceAreaIdentities 256
#define maxnoofMDTPLMNs                16
#define maxnoofCoMPHypothesisSet       256
#define maxnoofCoMPCells               32
#define maxUEReport                    128
#define maxCellReport                  9
#define maxnoofPA                      3
#define maxCSIProcess                  4
#define maxCSIReport                   2
#define maxSubband                     14
#define maxofNRNeighbours              1024
#define maxCellinengNB                 16384
#define maxnooftimeperiods             2
#define maxnoofCellIDforQMC            32
#define maxnoofTAforQMC                8
#define maxnoofPLMNforQMC              16
#define maxUEsinengNBDU                8192
#define maxnoofProtectedResourcePatterns 16
#define maxnoNRcellsSpectrumSharingWithE_UTRA 64
#define maxnoofNrCellBands             32
#define maxnoofBluetoothName           4
#define maxnoofWLANName                4
#define maxnoofextBPLMNs               12
#define maxnoofTLAs                    16
#define maxnoofGTPTLAs                 16
#define maxnoofTNLAssociations         32
#define maxnoofCellsinCHO              8
#define maxnoofPC5QoSFlows             2048
#define maxnoofSSBAreas                64
#define maxnoofNRSCSs                  5
#define maxnoofNRPhysicalResourceBlocks 275
#define maxnoofNonAnchorCarrierFreqConfig 15

typedef enum _ProcedureCode_enum {
  id_handoverPreparation =   0,
  id_handoverCancel =   1,
  id_loadIndication =   2,
  id_errorIndication =   3,
  id_snStatusTransfer =   4,
  id_uEContextRelease =   5,
  id_x2Setup   =   6,
  id_reset     =   7,
  id_eNBConfigurationUpdate =   8,
  id_resourceStatusReportingInitiation =   9,
  id_resourceStatusReporting =  10,
  id_privateMessage =  11,
  id_mobilitySettingsChange =  12,
  id_rLFIndication =  13,
  id_handoverReport =  14,
  id_cellActivation =  15,
  id_x2Release =  16,
  id_x2APMessageTransfer =  17,
  id_x2Removal =  18,
  id_seNBAdditionPreparation =  19,
  id_seNBReconfigurationCompletion =  20,
  id_meNBinitiatedSeNBModificationPreparation =  21,
  id_seNBinitiatedSeNBModification =  22,
  id_meNBinitiatedSeNBRelease =  23,
  id_seNBinitiatedSeNBRelease =  24,
  id_seNBCounterCheck =  25,
  id_retrieveUEContext =  26,
  id_sgNBAdditionPreparation =  27,
  id_sgNBReconfigurationCompletion =  28,
  id_meNBinitiatedSgNBModificationPreparation =  29,
  id_sgNBinitiatedSgNBModification =  30,
  id_meNBinitiatedSgNBRelease =  31,
  id_sgNBinitiatedSgNBRelease =  32,
  id_sgNBCounterCheck =  33,
  id_sgNBChange =  34,
  id_rRCTransfer =  35,
  id_endcX2Setup =  36,
  id_endcConfigurationUpdate =  37,
  id_secondaryRATDataUsageReport =  38,
  id_endcCellActivation =  39,
  id_endcPartialReset =  40,
  id_eUTRANRCellResourceCoordination =  41,
  id_SgNBActivityNotification =  42,
  id_endcX2Removal =  43,
  id_dataForwardingAddressIndication =  44,
  id_gNBStatusIndication =  45,
  id_deactivateTrace =  46,
  id_traceStart =  47,
  id_endcConfigurationTransfer =  48,
  id_handoverSuccess =  49,
  id_conditionalHandoverCancel =  50,
  id_earlyStatusTransfer =  51,
  id_cellTrafficTrace =  52,
  id_endcresourceStatusReporting =  53,
  id_endcresourceStatusReportingInitiation =  54,
  id_f1CTrafficTransfer =  55,
  id_UERadioCapabilityIDMapping =  56
} ProcedureCode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_E_RABs_Admitted_Item =   0,
  id_E_RABs_Admitted_List =   1,
  id_E_RAB_Item =   2,
  id_E_RABs_NotAdmitted_List =   3,
  id_E_RABs_ToBeSetup_Item =   4,
  id_Cause     =   5,
  id_CellInformation =   6,
  id_CellInformation_Item =   7,
  id_Unknown_8 =   8,
  id_New_eNB_UE_X2AP_ID =   9,
  id_Old_eNB_UE_X2AP_ID =  10,
  id_TargetCell_ID =  11,
  id_TargeteNBtoSource_eNBTransparentContainer =  12,
  id_TraceActivation =  13,
  id_UE_ContextInformation =  14,
  id_UE_HistoryInformation =  15,
  id_UE_X2AP_ID =  16,
  id_CriticalityDiagnostics =  17,
  id_E_RABs_SubjectToStatusTransfer_List =  18,
  id_E_RABs_SubjectToStatusTransfer_Item =  19,
  id_ServedCells =  20,
  id_GlobalENB_ID =  21,
  id_TimeToWait =  22,
  id_GUMMEI_ID =  23,
  id_GUGroupIDList =  24,
  id_ServedCellsToAdd =  25,
  id_ServedCellsToModify =  26,
  id_ServedCellsToDelete =  27,
  id_Registration_Request =  28,
  id_CellToReport =  29,
  id_ReportingPeriodicity =  30,
  id_CellToReport_Item =  31,
  id_CellMeasurementResult =  32,
  id_CellMeasurementResult_Item =  33,
  id_GUGroupIDToAddList =  34,
  id_GUGroupIDToDeleteList =  35,
  id_SRVCCOperationPossible =  36,
  id_Measurement_ID =  37,
  id_ReportCharacteristics =  38,
  id_ENB1_Measurement_ID =  39,
  id_ENB2_Measurement_ID =  40,
  id_Number_of_Antennaports =  41,
  id_CompositeAvailableCapacityGroup =  42,
  id_ENB1_Cell_ID =  43,
  id_ENB2_Cell_ID =  44,
  id_ENB2_Proposed_Mobility_Parameters =  45,
  id_ENB1_Mobility_Parameters =  46,
  id_ENB2_Mobility_Parameters_Modification_Range =  47,
  id_FailureCellPCI =  48,
  id_Re_establishmentCellECGI =  49,
  id_FailureCellCRNTI =  50,
  id_ShortMAC_I =  51,
  id_SourceCellECGI =  52,
  id_FailureCellECGI =  53,
  id_HandoverReportType =  54,
  id_PRACH_Configuration =  55,
  id_MBSFN_Subframe_Info =  56,
  id_ServedCellsToActivate =  57,
  id_ActivatedCellList =  58,
  id_DeactivationIndication =  59,
  id_UE_RLF_Report_Container =  60,
  id_ABSInformation =  61,
  id_InvokeIndication =  62,
  id_ABS_Status =  63,
  id_PartialSuccessIndicator =  64,
  id_MeasurementInitiationResult_List =  65,
  id_MeasurementInitiationResult_Item =  66,
  id_MeasurementFailureCause_Item =  67,
  id_CompleteFailureCauseInformation_List =  68,
  id_CompleteFailureCauseInformation_Item =  69,
  id_CSG_Id    =  70,
  id_CSGMembershipStatus =  71,
  id_MDTConfiguration =  72,
  id_Unknown_73 =  73,
  id_ManagementBasedMDTallowed =  74,
  id_RRCConnSetupIndicator =  75,
  id_NeighbourTAC =  76,
  id_Time_UE_StayedInCell_EnhancedGranularity =  77,
  id_RRCConnReestabIndicator =  78,
  id_MBMS_Service_Area_List =  79,
  id_HO_cause  =  80,
  id_TargetCellInUTRAN =  81,
  id_MobilityInformation =  82,
  id_SourceCellCRNTI =  83,
  id_MultibandInfoList =  84,
  id_M3Configuration =  85,
  id_M4Configuration =  86,
  id_M5Configuration =  87,
  id_MDT_Location_Info =  88,
  id_ManagementBasedMDTPLMNList =  89,
  id_SignallingBasedMDTPLMNList =  90,
  id_ReceiveStatusOfULPDCPSDUsExtended =  91,
  id_ULCOUNTValueExtended =  92,
  id_DLCOUNTValueExtended =  93,
  id_eARFCNExtension =  94,
  id_UL_EARFCNExtension =  95,
  id_DL_EARFCNExtension =  96,
  id_AdditionalSpecialSubframe_Info =  97,
  id_Masked_IMEISV =  98,
  id_IntendedULDLConfiguration =  99,
  id_ExtendedULInterferenceOverloadInfo = 100,
  id_RNL_Header = 101,
  id_x2APMessage = 102,
  id_ProSeAuthorized = 103,
  id_ExpectedUEBehaviour = 104,
  id_UE_HistoryInformationFromTheUE = 105,
  id_DynamicDLTransmissionInformation = 106,
  id_UE_RLF_Report_Container_for_extended_bands = 107,
  id_CoMPInformation = 108,
  id_ReportingPeriodicityRSRPMR = 109,
  id_RSRPMRList = 110,
  id_MeNB_UE_X2AP_ID = 111,
  id_SeNB_UE_X2AP_ID = 112,
  id_UE_SecurityCapabilities = 113,
  id_SeNBSecurityKey = 114,
  id_SeNBUEAggregateMaximumBitRate = 115,
  id_ServingPLMN = 116,
  id_E_RABs_ToBeAdded_List = 117,
  id_E_RABs_ToBeAdded_Item = 118,
  id_MeNBtoSeNBContainer = 119,
  id_E_RABs_Admitted_ToBeAdded_List = 120,
  id_E_RABs_Admitted_ToBeAdded_Item = 121,
  id_SeNBtoMeNBContainer = 122,
  id_ResponseInformationSeNBReconfComp = 123,
  id_UE_ContextInformationSeNBModReq = 124,
  id_E_RABs_ToBeAdded_ModReqItem = 125,
  id_E_RABs_ToBeModified_ModReqItem = 126,
  id_E_RABs_ToBeReleased_ModReqItem = 127,
  id_E_RABs_Admitted_ToBeAdded_ModAckList = 128,
  id_E_RABs_Admitted_ToBeModified_ModAckList = 129,
  id_E_RABs_Admitted_ToBeReleased_ModAckList = 130,
  id_E_RABs_Admitted_ToBeAdded_ModAckItem = 131,
  id_E_RABs_Admitted_ToBeModified_ModAckItem = 132,
  id_E_RABs_Admitted_ToBeReleased_ModAckItem = 133,
  id_E_RABs_ToBeReleased_ModReqd = 134,
  id_E_RABs_ToBeReleased_ModReqdItem = 135,
  id_SCGChangeIndication = 136,
  id_E_RABs_ToBeReleased_List_RelReq = 137,
  id_E_RABs_ToBeReleased_RelReqItem = 138,
  id_E_RABs_ToBeReleased_List_RelConf = 139,
  id_E_RABs_ToBeReleased_RelConfItem = 140,
  id_E_RABs_SubjectToCounterCheck_List = 141,
  id_E_RABs_SubjectToCounterCheckItem = 142,
  id_CoverageModificationList = 143,
  id_Unknown_144 = 144,
  id_ReportingPeriodicityCSIR = 145,
  id_CSIReportList = 146,
  id_UEID      = 147,
  id_enhancedRNTP = 148,
  id_ProSeUEtoNetworkRelaying = 149,
  id_ReceiveStatusOfULPDCPSDUsPDCP_SNlength18 = 150,
  id_ULCOUNTValuePDCP_SNlength18 = 151,
  id_DLCOUNTValuePDCP_SNlength18 = 152,
  id_UE_ContextReferenceAtSeNB = 153,
  id_UE_ContextKeptIndicator = 154,
  id_New_eNB_UE_X2AP_ID_Extension = 155,
  id_Old_eNB_UE_X2AP_ID_Extension = 156,
  id_MeNB_UE_X2AP_ID_Extension = 157,
  id_SeNB_UE_X2AP_ID_Extension = 158,
  id_LHN_ID    = 159,
  id_FreqBandIndicatorPriority = 160,
  id_M6Configuration = 161,
  id_M7Configuration = 162,
  id_Tunnel_Information_for_BBF = 163,
  id_SIPTO_BearerDeactivationIndication = 164,
  id_GW_TransportLayerAddress = 165,
  id_Correlation_ID = 166,
  id_SIPTO_Correlation_ID = 167,
  id_SIPTO_L_GW_TransportLayerAddress = 168,
  id_X2RemovalThreshold = 169,
  id_CellReportingIndicator = 170,
  id_BearerType = 171,
  id_resumeID  = 172,
  id_UE_ContextInformationRetrieve = 173,
  id_E_RABs_ToBeSetupRetrieve_Item = 174,
  id_NewEUTRANCellIdentifier = 175,
  id_V2XServicesAuthorized = 176,
  id_OffsetOfNbiotChannelNumberToDL_EARFCN = 177,
  id_OffsetOfNbiotChannelNumberToUL_EARFCN = 178,
  id_AdditionalSpecialSubframeExtension_Info = 179,
  id_BandwidthReducedSI = 180,
  id_MakeBeforeBreakIndicator = 181,
  id_UE_ContextReferenceAtWT = 182,
  id_WT_UE_ContextKeptIndicator = 183,
  id_UESidelinkAggregateMaximumBitRate = 184,
  id_uL_GTPtunnelEndpoint = 185,
  id_Unknown_186 = 186,
  id_Unknown_187 = 187,
  id_Unknown_188 = 188,
  id_Unknown_189 = 189,
  id_Unknown_190 = 190,
  id_Unknown_191 = 191,
  id_Unknown_192 = 192,
  id_DL_scheduling_PDCCH_CCE_usage = 193,
  id_UL_scheduling_PDCCH_CCE_usage = 194,
  id_UEAppLayerMeasConfig = 195,
  id_extended_e_RAB_MaximumBitrateDL = 196,
  id_extended_e_RAB_MaximumBitrateUL = 197,
  id_extended_e_RAB_GuaranteedBitrateDL = 198,
  id_extended_e_RAB_GuaranteedBitrateUL = 199,
  id_extended_uEaggregateMaximumBitRateDownlink = 200,
  id_extended_uEaggregateMaximumBitRateUplink = 201,
  id_NRrestrictioninEPSasSecondaryRAT = 202,
  id_SgNBSecurityKey = 203,
  id_SgNBUEAggregateMaximumBitRate = 204,
  id_E_RABs_ToBeAdded_SgNBAddReqList = 205,
  id_MeNBtoSgNBContainer = 206,
  id_SgNB_UE_X2AP_ID = 207,
  id_RequestedSplitSRBs = 208,
  id_E_RABs_ToBeAdded_SgNBAddReq_Item = 209,
  id_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList = 210,
  id_SgNBtoMeNBContainer = 211,
  id_AdmittedSplitSRBs = 212,
  id_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item = 213,
  id_ResponseInformationSgNBReconfComp = 214,
  id_UE_ContextInformation_SgNBModReq = 215,
  id_E_RABs_ToBeAdded_SgNBModReq_Item = 216,
  id_E_RABs_ToBeModified_SgNBModReq_Item = 217,
  id_E_RABs_ToBeReleased_SgNBModReq_Item = 218,
  id_E_RABs_Admitted_ToBeAdded_SgNBModAckList = 219,
  id_E_RABs_Admitted_ToBeModified_SgNBModAckList = 220,
  id_E_RABs_Admitted_ToBeReleased_SgNBModAckList = 221,
  id_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item = 222,
  id_E_RABs_Admitted_ToBeModified_SgNBModAck_Item = 223,
  id_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item = 224,
  id_E_RABs_ToBeReleased_SgNBModReqdList = 225,
  id_E_RABs_ToBeModified_SgNBModReqdList = 226,
  id_E_RABs_ToBeReleased_SgNBModReqd_Item = 227,
  id_E_RABs_ToBeModified_SgNBModReqd_Item = 228,
  id_E_RABs_ToBeReleased_SgNBChaConfList = 229,
  id_E_RABs_ToBeReleased_SgNBChaConf_Item = 230,
  id_E_RABs_ToBeReleased_SgNBRelReqList = 231,
  id_E_RABs_ToBeReleased_SgNBRelReq_Item = 232,
  id_E_RABs_ToBeReleased_SgNBRelConfList = 233,
  id_E_RABs_ToBeReleased_SgNBRelConf_Item = 234,
  id_E_RABs_SubjectToSgNBCounterCheck_List = 235,
  id_E_RABs_SubjectToSgNBCounterCheck_Item = 236,
  id_RRCContainer = 237,
  id_SRBType   = 238,
  id_Target_SgNB_ID = 239,
  id_HandoverRestrictionList = 240,
  id_SCGConfigurationQuery = 241,
  id_SplitSRB  = 242,
  id_NRUeReport = 243,
  id_InitiatingNodeType_EndcX2Setup = 244,
  id_InitiatingNodeType_EndcConfigUpdate = 245,
  id_RespondingNodeType_EndcX2Setup = 246,
  id_RespondingNodeType_EndcConfigUpdate = 247,
  id_NRUESecurityCapabilities = 248,
  id_PDCPChangeIndication = 249,
  id_ServedEUTRAcellsENDCX2ManagementList = 250,
  id_CellAssistanceInformation = 251,
  id_Globalen_gNB_ID = 252,
  id_ServedNRcellsENDCX2ManagementList = 253,
  id_UE_ContextReferenceAtSgNB = 254,
  id_SecondaryRATUsageReport = 255,
  id_ActivationID = 256,
  id_MeNBResourceCoordinationInformation = 257,
  id_SgNBResourceCoordinationInformation = 258,
  id_ServedEUTRAcellsToModifyListENDCConfUpd = 259,
  id_ServedEUTRAcellsToDeleteListENDCConfUpd = 260,
  id_ServedNRcellsToModifyListENDCConfUpd = 261,
  id_ServedNRcellsToDeleteListENDCConfUpd = 262,
  id_E_RABUsageReport_Item = 263,
  id_Old_SgNB_UE_X2AP_ID = 264,
  id_SecondaryRATUsageReportList = 265,
  id_SecondaryRATUsageReport_Item = 266,
  id_ServedNRCellsToActivate = 267,
  id_ActivatedNRCellList = 268,
  id_SelectedPLMN = 269,
  id_UEs_ToBeReset = 270,
  id_UEs_Admitted_ToBeReset = 271,
  id_RRCConfigIndication = 272,
  id_DownlinkPacketLossRate = 273,
  id_UplinkPacketLossRate = 274,
  id_SubscriberProfileIDforRFP = 275,
  id_serviceType = 276,
  id_AerialUEsubscriptionInformation = 277,
  id_SGNB_Addition_Trigger_Ind = 278,
  id_MeNBCell_ID = 279,
  id_RequestedSplitSRBsrelease = 280,
  id_AdmittedSplitSRBsrelease = 281,
  id_NRS_NSSS_PowerOffset = 282,
  id_NSSS_NumOccasionDifferentPrecoder = 283,
  id_ProtectedEUTRAResourceIndication = 284,
  id_InitiatingNodeType_EutranrCellResourceCoordination = 285,
  id_RespondingNodeType_EutranrCellResourceCoordination = 286,
  id_DataTrafficResourceIndication = 287,
  id_SpectrumSharingGroupID = 288,
  id_ListofEUTRACellsinEUTRACoordinationReq = 289,
  id_ListofEUTRACellsinEUTRACoordinationResp = 290,
  id_ListofEUTRACellsinNRCoordinationReq = 291,
  id_ListofNRCellsinNRCoordinationReq = 292,
  id_ListofNRCellsinNRCoordinationResp = 293,
  id_E_RABs_AdmittedToBeModified_SgNBModConfList = 294,
  id_E_RABs_AdmittedToBeModified_SgNBModConf_Item = 295,
  id_UEContextLevelUserPlaneActivity = 296,
  id_ERABActivityNotifyItemList = 297,
  id_InitiatingNodeType_EndcX2Removal = 298,
  id_RespondingNodeType_EndcX2Removal = 299,
  id_RLC_Status = 300,
  id_CNTypeRestrictions = 301,
  id_uLpDCPSnLength = 302,
  id_BluetoothMeasurementConfiguration = 303,
  id_WLANMeasurementConfiguration = 304,
  id_NRrestrictionin5GS = 305,
  id_dL_Forwarding = 306,
  id_E_RABs_DataForwardingAddress_List = 307,
  id_E_RABs_DataForwardingAddress_Item = 308,
  id_Subscription_Based_UE_DifferentiationInfo = 309,
  id_GNBOverloadInformation = 310,
  id_dLPDCPSnLength = 311,
  id_secondarysgNBDLGTPTEIDatPDCP = 312,
  id_secondarymeNBULGTPTEIDatPDCP = 313,
  id_lCID      = 314,
  id_duplicationActivation = 315,
  id_ECGI      = 316,
  id_RLCMode_transferred = 317,
  id_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList = 318,
  id_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item = 319,
  id_E_RABs_ToBeReleased_SgNBRelReqdList = 320,
  id_E_RABs_ToBeReleased_SgNBRelReqd_Item = 321,
  id_NRCGI     = 322,
  id_MeNBCoordinationAssistanceInformation = 323,
  id_SgNBCoordinationAssistanceInformation = 324,
  id_new_drb_ID_req = 325,
  id_endcSONConfigurationTransfer = 326,
  id_NRNeighbourInfoToAdd = 327,
  id_NRNeighbourInfoToModify = 328,
  id_DesiredActNotificationLevel = 329,
  id_LocationInformationSgNBReporting = 330,
  id_LocationInformationSgNB = 331,
  id_LastNG_RANPLMNIdentity = 332,
  id_EUTRANTraceID = 333,
  id_additionalPLMNs_Item = 334,
  id_InterfaceInstanceIndication = 335,
  id_BPLMN_ID_Info_EUTRA = 336,
  id_BPLMN_ID_Info_NR = 337,
  id_NBIoT_UL_DL_AlignmentOffset = 338,
  id_ERABs_transferred_to_MeNB = 339,
  id_AdditionalRRMPriorityIndex = 340,
  id_LowerLayerPresenceStatusChange = 341,
  id_FastMCGRecovery_SN_to_MN = 342,
  id_RequestedFastMCGRecoveryViaSRB3 = 343,
  id_AvailableFastMCGRecoveryViaSRB3 = 344,
  id_RequestedFastMCGRecoveryViaSRB3Release = 345,
  id_ReleaseFastMCGRecoveryViaSRB3 = 346,
  id_FastMCGRecovery_MN_to_SN = 347,
  id_PartialListIndicator = 348,
  id_MaximumCellListSize = 349,
  id_MessageOversizeNotification = 350,
  id_CellandCapacityAssistInfo = 351,
  id_TNLConfigurationInfo = 352,
  id_TNLA_To_Add_List = 353,
  id_TNLA_To_Update_List = 354,
  id_TNLA_To_Remove_List = 355,
  id_TNLA_Setup_List = 356,
  id_TNLA_Failed_To_Setup_List = 357,
  id_UnlicensedSpectrumRestriction = 358,
  id_UEContextReferenceatSourceNGRAN = 359,
  id_EPCHandoverRestrictionListContainer = 360,
  id_CHOinformation_REQ = 361,
  id_CHOinformation_ACK = 362,
  id_DAPSRequestInfo = 363,
  id_RequestedTargetCellID = 364,
  id_CandidateCellsToBeCancelledList = 365,
  id_DAPSResponseInfo = 366,
  id_ProcedureStage = 367,
  id_CHO_DC_Indicator = 368,
  id_Ethernet_Type = 369,
  id_NRV2XServicesAuthorized = 370,
  id_NRUESidelinkAggregateMaximumBitRate = 371,
  id_PC5QoSParameters = 372,
  id_NPRACHConfiguration = 373,
  id_NBIoT_RLF_Report_Container = 374,
  id_MDTConfigurationNR = 375,
  id_PrivacyIndicator = 376,
  id_TraceCollectionEntityIPAddress = 377,
  id_UERadioCapabilityID = 378,
  id_SNtriggered = 379,
  id_CSI_RSTransmissionIndication = 380,
  id_DLCarrierList = 381,
  id_TargetCellInNGRAN = 382,
  id_E_UTRAN_Node1_Measurement_ID = 383,
  id_E_UTRAN_Node2_Measurement_ID = 384,
  id_TDDULDLConfigurationCommonNR = 385,
  id_CarrierList = 386,
  id_ULCarrierList = 387,
  id_FrequencyShift7p5khz = 388,
  id_SSB_PositionsInBurst = 389,
  id_NRCellPRACHConfig = 390,
  id_CellToReport_NR_ENDC = 391,
  id_CellToReport_NR_ENDC_Item = 392,
  id_CellMeasurementResult_NR_ENDC = 393,
  id_CellMeasurementResult_NR_ENDC_Item = 394,
  id_IABNodeIndication = 395,
  id_QoS_Mapping_Information = 396,
  id_F1CTrafficContainer = 397,
  id_Unknown_398 = 398,
  id_IntendedTDD_DL_ULConfiguration_NR = 399,
  id_UERadioCapability = 400,
  id_CellMeasurementResult_E_UTRA_ENDC = 401,
  id_CellMeasurementResult_E_UTRA_ENDC_Item = 402,
  id_CellToReport_E_UTRA_ENDC = 403,
  id_CellToReport_E_UTRA_ENDC_Item = 404,
  id_TraceCollectionEntityURI = 405,
  id_SFN_Offset = 406,
  id_CHO_DC_EarlyDataForwarding = 407,
  id_IMSvoiceEPSfallbackfrom5G = 408,
  id_AdditionLocationInformation = 409,
  id_DirectForwardingPathAvailability = 410,
  id_sourceNG_RAN_node_id = 411,
  id_SourceDLForwardingIPAddress = 412,
  id_SourceNodeDLForwardingIPAddress = 413
} ProtocolIE_ID_enum;

/*--- End of included file: packet-x2ap-val.h ---*/
#line 54 "./asn1/x2ap/packet-x2ap-template.c"

/* Initialize the protocol and registered fields */
static int proto_x2ap = -1;
static int hf_x2ap_transportLayerAddressIPv4 = -1;
static int hf_x2ap_transportLayerAddressIPv6 = -1;
static int hf_x2ap_ReportCharacteristics_PRBPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_TNLLoadIndPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_HWLoadIndPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_CompositeAvailableCapacityPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_ABSStatusPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_RSRPMeasurementReportPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_CSIReportPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_Reserved = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_PRBPeriodic = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_TNLLoadIndPeriodic = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_HWLoadIndPeriodic = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_CompositeAvailableCapacityPeriodic = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_ABSStatusPeriodic = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_RSRPMeasurementReportPeriodic = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_CSIReportPeriodic = -1;
static int hf_x2ap_measurementFailedReportCharacteristics_Reserved = -1;
static int hf_x2ap_eUTRANTraceID_TraceID = -1;
static int hf_x2ap_eUTRANTraceID_TraceRecordingSessionReference = -1;
static int hf_x2ap_interfacesToTrace_S1_MME = -1;
static int hf_x2ap_interfacesToTrace_X2 = -1;
static int hf_x2ap_interfacesToTrace_Uu = -1;
static int hf_x2ap_interfacesToTrace_F1_C = -1;
static int hf_x2ap_interfacesToTrace_E1 = -1;
static int hf_x2ap_interfacesToTrace_Reserved = -1;
static int hf_x2ap_traceCollectionEntityIPAddress_IPv4 = -1;
static int hf_x2ap_traceCollectionEntityIPAddress_IPv6 = -1;
static int hf_x2ap_encryptionAlgorithms_EEA1 = -1;
static int hf_x2ap_encryptionAlgorithms_EEA2 = -1;
static int hf_x2ap_encryptionAlgorithms_EEA3 = -1;
static int hf_x2ap_encryptionAlgorithms_Reserved = -1;
static int hf_x2ap_integrityProtectionAlgorithms_EIA1 = -1;
static int hf_x2ap_integrityProtectionAlgorithms_EIA2 = -1;
static int hf_x2ap_integrityProtectionAlgorithms_EIA3 = -1;
static int hf_x2ap_integrityProtectionAlgorithms_Reserved = -1;
static int hf_x2ap_measurementsToActivate_M1 = -1;
static int hf_x2ap_measurementsToActivate_M2 = -1;
static int hf_x2ap_measurementsToActivate_M3 = -1;
static int hf_x2ap_measurementsToActivate_M4 = -1;
static int hf_x2ap_measurementsToActivate_M5 = -1;
static int hf_x2ap_measurementsToActivate_LoggingM1FromEventTriggered = -1;
static int hf_x2ap_measurementsToActivate_M6 = -1;
static int hf_x2ap_measurementsToActivate_M7 = -1;
static int hf_x2ap_MDT_Location_Info_GNSS = -1;
static int hf_x2ap_MDT_Location_Info_E_CID = -1;
static int hf_x2ap_MDT_Location_Info_Reserved = -1;
static int hf_x2ap_MDT_transmissionModes_tm1 = -1;
static int hf_x2ap_MDT_transmissionModes_tm2 = -1;
static int hf_x2ap_MDT_transmissionModes_tm3 = -1;
static int hf_x2ap_MDT_transmissionModes_tm4 = -1;
static int hf_x2ap_MDT_transmissionModes_tm6 = -1;
static int hf_x2ap_MDT_transmissionModes_tm8 = -1;
static int hf_x2ap_MDT_transmissionModes_tm9 = -1;
static int hf_x2ap_MDT_transmissionModes_tm10 = -1;
static int hf_x2ap_NRencryptionAlgorithms_NEA1 = -1;
static int hf_x2ap_NRencryptionAlgorithms_NEA2 = -1;
static int hf_x2ap_NRencryptionAlgorithms_NEA3 = -1;
static int hf_x2ap_NRencryptionAlgorithms_Reserved = -1;
static int hf_x2ap_NRintegrityProtectionAlgorithms_NIA1 = -1;
static int hf_x2ap_NRintegrityProtectionAlgorithms_NIA2 = -1;
static int hf_x2ap_NRintegrityProtectionAlgorithms_NIA3 = -1;
static int hf_x2ap_NRintegrityProtectionAlgorithms_Reserved = -1;
static int hf_x2ap_ReportCharacteristics_ENDC_PRBPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_ENDC_TNLCapacityIndPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_ENDC_CompositeAvailableCapacityPeriodic = -1;
static int hf_x2ap_ReportCharacteristics_ENDC_NumberOfActiveUEs = -1;
static int hf_x2ap_ReportCharacteristics_ENDC_Reserved = -1;
static int hf_x2ap_Registration_Request_ENDC_PDU = -1;
static int hf_x2ap_ReportingPeriodicity_ENDC_PDU = -1;
static int hf_x2ap_ReportCharacteristics_ENDC_PDU = -1;

/*--- Included file: packet-x2ap-hf.c ---*/
#line 1 "./asn1/x2ap/packet-x2ap-hf.c"
static int hf_x2ap_ABSInformation_PDU = -1;       /* ABSInformation */
static int hf_x2ap_ABS_Status_PDU = -1;           /* ABS_Status */
static int hf_x2ap_ActivationID_PDU = -1;         /* ActivationID */
static int hf_x2ap_AdditionLocationInformation_PDU = -1;  /* AdditionLocationInformation */
static int hf_x2ap_AdditionalRRMPriorityIndex_PDU = -1;  /* AdditionalRRMPriorityIndex */
static int hf_x2ap_AdditionalSpecialSubframe_Info_PDU = -1;  /* AdditionalSpecialSubframe_Info */
static int hf_x2ap_AdditionalSpecialSubframeExtension_Info_PDU = -1;  /* AdditionalSpecialSubframeExtension_Info */
static int hf_x2ap_AvailableFastMCGRecoveryViaSRB3_PDU = -1;  /* AvailableFastMCGRecoveryViaSRB3 */
static int hf_x2ap_AerialUEsubscriptionInformation_PDU = -1;  /* AerialUEsubscriptionInformation */
static int hf_x2ap_AdditionalPLMNs_Item_PDU = -1;  /* AdditionalPLMNs_Item */
static int hf_x2ap_BandwidthReducedSI_PDU = -1;   /* BandwidthReducedSI */
static int hf_x2ap_BearerType_PDU = -1;           /* BearerType */
static int hf_x2ap_BluetoothMeasurementConfiguration_PDU = -1;  /* BluetoothMeasurementConfiguration */
static int hf_x2ap_BPLMN_ID_Info_EUTRA_PDU = -1;  /* BPLMN_ID_Info_EUTRA */
static int hf_x2ap_BPLMN_ID_Info_NR_PDU = -1;     /* BPLMN_ID_Info_NR */
static int hf_x2ap_Cause_PDU = -1;                /* Cause */
static int hf_x2ap_CellReportingIndicator_PDU = -1;  /* CellReportingIndicator */
static int hf_x2ap_CHO_DC_EarlyDataForwarding_PDU = -1;  /* CHO_DC_EarlyDataForwarding */
static int hf_x2ap_CHO_DC_Indicator_PDU = -1;     /* CHO_DC_Indicator */
static int hf_x2ap_CNTypeRestrictions_PDU = -1;   /* CNTypeRestrictions */
static int hf_x2ap_CoMPInformation_PDU = -1;      /* CoMPInformation */
static int hf_x2ap_CompositeAvailableCapacityGroup_PDU = -1;  /* CompositeAvailableCapacityGroup */
static int hf_x2ap_Correlation_ID_PDU = -1;       /* Correlation_ID */
static int hf_x2ap_COUNTValueExtended_PDU = -1;   /* COUNTValueExtended */
static int hf_x2ap_COUNTvaluePDCP_SNlength18_PDU = -1;  /* COUNTvaluePDCP_SNlength18 */
static int hf_x2ap_CoverageModificationList_PDU = -1;  /* CoverageModificationList */
static int hf_x2ap_CriticalityDiagnostics_PDU = -1;  /* CriticalityDiagnostics */
static int hf_x2ap_CRNTI_PDU = -1;                /* CRNTI */
static int hf_x2ap_CSGMembershipStatus_PDU = -1;  /* CSGMembershipStatus */
static int hf_x2ap_CSG_Id_PDU = -1;               /* CSG_Id */
static int hf_x2ap_CSIReportList_PDU = -1;        /* CSIReportList */
static int hf_x2ap_CHOinformation_REQ_PDU = -1;   /* CHOinformation_REQ */
static int hf_x2ap_CHOinformation_ACK_PDU = -1;   /* CHOinformation_ACK */
static int hf_x2ap_CandidateCellsToBeCancelledList_PDU = -1;  /* CandidateCellsToBeCancelledList */
static int hf_x2ap_CSI_RSTransmissionIndication_PDU = -1;  /* CSI_RSTransmissionIndication */
static int hf_x2ap_DataTrafficResourceIndication_PDU = -1;  /* DataTrafficResourceIndication */
static int hf_x2ap_DAPSRequestInfo_PDU = -1;      /* DAPSRequestInfo */
static int hf_x2ap_DAPSResponseInfo_PDU = -1;     /* DAPSResponseInfo */
static int hf_x2ap_DeactivationIndication_PDU = -1;  /* DeactivationIndication */
static int hf_x2ap_DesiredActNotificationLevel_PDU = -1;  /* DesiredActNotificationLevel */
static int hf_x2ap_DirectForwardingPathAvailability_PDU = -1;  /* DirectForwardingPathAvailability */
static int hf_x2ap_DL_Forwarding_PDU = -1;        /* DL_Forwarding */
static int hf_x2ap_DL_scheduling_PDCCH_CCE_usage_PDU = -1;  /* DL_scheduling_PDCCH_CCE_usage */
static int hf_x2ap_DuplicationActivation_PDU = -1;  /* DuplicationActivation */
static int hf_x2ap_DynamicDLTransmissionInformation_PDU = -1;  /* DynamicDLTransmissionInformation */
static int hf_x2ap_EARFCNExtension_PDU = -1;      /* EARFCNExtension */
static int hf_x2ap_ECGI_PDU = -1;                 /* ECGI */
static int hf_x2ap_EndcSONConfigurationTransfer_PDU = -1;  /* EndcSONConfigurationTransfer */
static int hf_x2ap_EnhancedRNTP_PDU = -1;         /* EnhancedRNTP */
static int hf_x2ap_EPCHandoverRestrictionListContainer_PDU = -1;  /* EPCHandoverRestrictionListContainer */
static int hf_x2ap_ERABActivityNotifyItemList_PDU = -1;  /* ERABActivityNotifyItemList */
static int hf_x2ap_E_RAB_List_PDU = -1;           /* E_RAB_List */
static int hf_x2ap_E_RAB_Item_PDU = -1;           /* E_RAB_Item */
static int hf_x2ap_E_RABUsageReport_Item_PDU = -1;  /* E_RABUsageReport_Item */
static int hf_x2ap_Ethernet_Type_PDU = -1;        /* Ethernet_Type */
static int hf_x2ap_EUTRANCellIdentifier_PDU = -1;  /* EUTRANCellIdentifier */
static int hf_x2ap_EUTRANTraceID_PDU = -1;        /* EUTRANTraceID */
static int hf_x2ap_ExpectedUEBehaviour_PDU = -1;  /* ExpectedUEBehaviour */
static int hf_x2ap_ExtendedULInterferenceOverloadInfo_PDU = -1;  /* ExtendedULInterferenceOverloadInfo */
static int hf_x2ap_ExtendedBitRate_PDU = -1;      /* ExtendedBitRate */
static int hf_x2ap_F1CTrafficContainer_PDU = -1;  /* F1CTrafficContainer */
static int hf_x2ap_FastMCGRecovery_PDU = -1;      /* FastMCGRecovery */
static int hf_x2ap_FreqBandIndicatorPriority_PDU = -1;  /* FreqBandIndicatorPriority */
static int hf_x2ap_FrequencyShift7p5khz_PDU = -1;  /* FrequencyShift7p5khz */
static int hf_x2ap_GlobalENB_ID_PDU = -1;         /* GlobalENB_ID */
static int hf_x2ap_GlobalGNB_ID_PDU = -1;         /* GlobalGNB_ID */
static int hf_x2ap_Global_RAN_NODE_ID_PDU = -1;   /* Global_RAN_NODE_ID */
static int hf_x2ap_GNBOverloadInformation_PDU = -1;  /* GNBOverloadInformation */
static int hf_x2ap_GTPtunnelEndpoint_PDU = -1;    /* GTPtunnelEndpoint */
static int hf_x2ap_GUGroupIDList_PDU = -1;        /* GUGroupIDList */
static int hf_x2ap_GUMMEI_PDU = -1;               /* GUMMEI */
static int hf_x2ap_HandoverReportType_PDU = -1;   /* HandoverReportType */
static int hf_x2ap_HandoverRestrictionList_PDU = -1;  /* HandoverRestrictionList */
static int hf_x2ap_IABNodeIndication_PDU = -1;    /* IABNodeIndication */
static int hf_x2ap_IMSvoiceEPSfallbackfrom5G_PDU = -1;  /* IMSvoiceEPSfallbackfrom5G */
static int hf_x2ap_IntendedTDD_DL_ULConfiguration_NR_PDU = -1;  /* IntendedTDD_DL_ULConfiguration_NR */
static int hf_x2ap_InterfaceInstanceIndication_PDU = -1;  /* InterfaceInstanceIndication */
static int hf_x2ap_InvokeIndication_PDU = -1;     /* InvokeIndication */
static int hf_x2ap_LCID_PDU = -1;                 /* LCID */
static int hf_x2ap_LHN_ID_PDU = -1;               /* LHN_ID */
static int hf_x2ap_LocationInformationSgNB_PDU = -1;  /* LocationInformationSgNB */
static int hf_x2ap_LocationInformationSgNBReporting_PDU = -1;  /* LocationInformationSgNBReporting */
static int hf_x2ap_LowerLayerPresenceStatusChange_PDU = -1;  /* LowerLayerPresenceStatusChange */
static int hf_x2ap_M3Configuration_PDU = -1;      /* M3Configuration */
static int hf_x2ap_M4Configuration_PDU = -1;      /* M4Configuration */
static int hf_x2ap_M5Configuration_PDU = -1;      /* M5Configuration */
static int hf_x2ap_M6Configuration_PDU = -1;      /* M6Configuration */
static int hf_x2ap_M7Configuration_PDU = -1;      /* M7Configuration */
static int hf_x2ap_MakeBeforeBreakIndicator_PDU = -1;  /* MakeBeforeBreakIndicator */
static int hf_x2ap_ManagementBasedMDTallowed_PDU = -1;  /* ManagementBasedMDTallowed */
static int hf_x2ap_Masked_IMEISV_PDU = -1;        /* Masked_IMEISV */
static int hf_x2ap_MDT_Configuration_PDU = -1;    /* MDT_Configuration */
static int hf_x2ap_MDTPLMNList_PDU = -1;          /* MDTPLMNList */
static int hf_x2ap_MDT_Location_Info_PDU = -1;    /* MDT_Location_Info */
static int hf_x2ap_Measurement_ID_PDU = -1;       /* Measurement_ID */
static int hf_x2ap_Measurement_ID_ENDC_PDU = -1;  /* Measurement_ID_ENDC */
static int hf_x2ap_MeNBCoordinationAssistanceInformation_PDU = -1;  /* MeNBCoordinationAssistanceInformation */
static int hf_x2ap_x2ap_MeNBResourceCoordinationInformation_PDU = -1;  /* MeNBResourceCoordinationInformation */
static int hf_x2ap_MeNBtoSeNBContainer_PDU = -1;  /* MeNBtoSeNBContainer */
static int hf_x2ap_MBMS_Service_Area_Identity_List_PDU = -1;  /* MBMS_Service_Area_Identity_List */
static int hf_x2ap_MBSFN_Subframe_Infolist_PDU = -1;  /* MBSFN_Subframe_Infolist */
static int hf_x2ap_MDT_ConfigurationNR_PDU = -1;  /* MDT_ConfigurationNR */
static int hf_x2ap_MobilityParametersModificationRange_PDU = -1;  /* MobilityParametersModificationRange */
static int hf_x2ap_MobilityParametersInformation_PDU = -1;  /* MobilityParametersInformation */
static int hf_x2ap_MultibandInfoList_PDU = -1;    /* MultibandInfoList */
static int hf_x2ap_MessageOversizeNotification_PDU = -1;  /* MessageOversizeNotification */
static int hf_x2ap_MeNBtoSgNBContainer_PDU = -1;  /* MeNBtoSgNBContainer */
static int hf_x2ap_SplitSRBs_PDU = -1;            /* SplitSRBs */
static int hf_x2ap_SplitSRB_PDU = -1;             /* SplitSRB */
static int hf_x2ap_NBIoT_UL_DL_AlignmentOffset_PDU = -1;  /* NBIoT_UL_DL_AlignmentOffset */
static int hf_x2ap_NBIoT_RLF_Report_Container_PDU = -1;  /* NBIoT_RLF_Report_Container */
static int hf_x2ap_NewDRBIDrequest_PDU = -1;      /* NewDRBIDrequest */
static int hf_x2ap_Number_of_Antennaports_PDU = -1;  /* Number_of_Antennaports */
static int hf_x2ap_NRCarrierList_PDU = -1;        /* NRCarrierList */
static int hf_x2ap_NRCellPRACHConfig_PDU = -1;    /* NRCellPRACHConfig */
static int hf_x2ap_NRCGI_PDU = -1;                /* NRCGI */
static int hf_x2ap_NRNeighbour_Information_PDU = -1;  /* NRNeighbour_Information */
static int hf_x2ap_NPRACHConfiguration_PDU = -1;  /* NPRACHConfiguration */
static int hf_x2ap_NRrestrictioninEPSasSecondaryRAT_PDU = -1;  /* NRrestrictioninEPSasSecondaryRAT */
static int hf_x2ap_NRrestrictionin5GS_PDU = -1;   /* NRrestrictionin5GS */
static int hf_x2ap_NRS_NSSS_PowerOffset_PDU = -1;  /* NRS_NSSS_PowerOffset */
static int hf_x2ap_NRUeReport_PDU = -1;           /* NRUeReport */
static int hf_x2ap_NRUESidelinkAggregateMaximumBitRate_PDU = -1;  /* NRUESidelinkAggregateMaximumBitRate */
static int hf_x2ap_NRUESecurityCapabilities_PDU = -1;  /* NRUESecurityCapabilities */
static int hf_x2ap_NSSS_NumOccasionDifferentPrecoder_PDU = -1;  /* NSSS_NumOccasionDifferentPrecoder */
static int hf_x2ap_NRV2XServicesAuthorized_PDU = -1;  /* NRV2XServicesAuthorized */
static int hf_x2ap_OffsetOfNbiotChannelNumberToEARFCN_PDU = -1;  /* OffsetOfNbiotChannelNumberToEARFCN */
static int hf_x2ap_Packet_LossRate_PDU = -1;      /* Packet_LossRate */
static int hf_x2ap_PC5QoSParameters_PDU = -1;     /* PC5QoSParameters */
static int hf_x2ap_PDCPChangeIndication_PDU = -1;  /* PDCPChangeIndication */
static int hf_x2ap_PDCPSnLength_PDU = -1;         /* PDCPSnLength */
static int hf_x2ap_PCI_PDU = -1;                  /* PCI */
static int hf_x2ap_PLMN_Identity_PDU = -1;        /* PLMN_Identity */
static int hf_x2ap_PRACH_Configuration_PDU = -1;  /* PRACH_Configuration */
static int hf_x2ap_ProSeAuthorized_PDU = -1;      /* ProSeAuthorized */
static int hf_x2ap_ProSeUEtoNetworkRelaying_PDU = -1;  /* ProSeUEtoNetworkRelaying */
static int hf_x2ap_x2ap_ProtectedEUTRAResourceIndication_PDU = -1;  /* ProtectedEUTRAResourceIndication */
static int hf_x2ap_PartialListIndicator_PDU = -1;  /* PartialListIndicator */
static int hf_x2ap_PrivacyIndicator_PDU = -1;     /* PrivacyIndicator */
static int hf_x2ap_QoS_Mapping_Information_PDU = -1;  /* QoS_Mapping_Information */
static int hf_x2ap_RAN_UE_NGAP_ID_PDU = -1;       /* RAN_UE_NGAP_ID */
static int hf_x2ap_ReceiveStatusOfULPDCPSDUsExtended_PDU = -1;  /* ReceiveStatusOfULPDCPSDUsExtended */
static int hf_x2ap_ReceiveStatusOfULPDCPSDUsPDCP_SNlength18_PDU = -1;  /* ReceiveStatusOfULPDCPSDUsPDCP_SNlength18 */
static int hf_x2ap_ReleaseFastMCGRecoveryViaSRB3_PDU = -1;  /* ReleaseFastMCGRecoveryViaSRB3 */
static int hf_x2ap_Registration_Request_PDU = -1;  /* Registration_Request */
static int hf_x2ap_ReportCharacteristics_PDU = -1;  /* ReportCharacteristics */
static int hf_x2ap_ReportingPeriodicityCSIR_PDU = -1;  /* ReportingPeriodicityCSIR */
static int hf_x2ap_ReportingPeriodicityRSRPMR_PDU = -1;  /* ReportingPeriodicityRSRPMR */
static int hf_x2ap_RequestedFastMCGRecoveryViaSRB3_PDU = -1;  /* RequestedFastMCGRecoveryViaSRB3 */
static int hf_x2ap_RequestedFastMCGRecoveryViaSRB3Release_PDU = -1;  /* RequestedFastMCGRecoveryViaSRB3Release */
static int hf_x2ap_ResumeID_PDU = -1;             /* ResumeID */
static int hf_x2ap_RLCMode_PDU = -1;              /* RLCMode */
static int hf_x2ap_RLC_Status_PDU = -1;           /* RLC_Status */
static int hf_x2ap_RRC_Config_Ind_PDU = -1;       /* RRC_Config_Ind */
static int hf_x2ap_RRCConnReestabIndicator_PDU = -1;  /* RRCConnReestabIndicator */
static int hf_x2ap_RRCConnSetupIndicator_PDU = -1;  /* RRCConnSetupIndicator */
static int hf_x2ap_RSRPMRList_PDU = -1;           /* RSRPMRList */
static int hf_x2ap_SCGChangeIndication_PDU = -1;  /* SCGChangeIndication */
static int hf_x2ap_SecondaryRATUsageReportList_PDU = -1;  /* SecondaryRATUsageReportList */
static int hf_x2ap_SecondaryRATUsageReport_Item_PDU = -1;  /* SecondaryRATUsageReport_Item */
static int hf_x2ap_SeNBSecurityKey_PDU = -1;      /* SeNBSecurityKey */
static int hf_x2ap_SeNBtoMeNBContainer_PDU = -1;  /* SeNBtoMeNBContainer */
static int hf_x2ap_ServedCells_PDU = -1;          /* ServedCells */
static int hf_x2ap_ServiceType_PDU = -1;          /* ServiceType */
static int hf_x2ap_SgNBCoordinationAssistanceInformation_PDU = -1;  /* SgNBCoordinationAssistanceInformation */
static int hf_x2ap_x2ap_SgNBResourceCoordinationInformation_PDU = -1;  /* SgNBResourceCoordinationInformation */
static int hf_x2ap_SgNB_UE_X2AP_ID_PDU = -1;      /* SgNB_UE_X2AP_ID */
static int hf_x2ap_SIPTOBearerDeactivationIndication_PDU = -1;  /* SIPTOBearerDeactivationIndication */
static int hf_x2ap_ShortMAC_I_PDU = -1;           /* ShortMAC_I */
static int hf_x2ap_SGNB_Addition_Trigger_Ind_PDU = -1;  /* SGNB_Addition_Trigger_Ind */
static int hf_x2ap_SNtriggered_PDU = -1;          /* SNtriggered */
static int hf_x2ap_SpectrumSharingGroupID_PDU = -1;  /* SpectrumSharingGroupID */
static int hf_x2ap_Subscription_Based_UE_DifferentiationInfo_PDU = -1;  /* Subscription_Based_UE_DifferentiationInfo */
static int hf_x2ap_SRVCCOperationPossible_PDU = -1;  /* SRVCCOperationPossible */
static int hf_x2ap_SSB_PositionsInBurst_PDU = -1;  /* SSB_PositionsInBurst */
static int hf_x2ap_SubscriberProfileIDforRFP_PDU = -1;  /* SubscriberProfileIDforRFP */
static int hf_x2ap_SubframeAssignment_PDU = -1;   /* SubframeAssignment */
static int hf_x2ap_SgNBSecurityKey_PDU = -1;      /* SgNBSecurityKey */
static int hf_x2ap_SgNBtoMeNBContainer_PDU = -1;  /* SgNBtoMeNBContainer */
static int hf_x2ap_SCGConfigurationQuery_PDU = -1;  /* SCGConfigurationQuery */
static int hf_x2ap_SFN_Offset_PDU = -1;           /* SFN_Offset */
static int hf_x2ap_TAC_PDU = -1;                  /* TAC */
static int hf_x2ap_TargetCellInNGRAN_PDU = -1;    /* TargetCellInNGRAN */
static int hf_x2ap_TargetCellInUTRAN_PDU = -1;    /* TargetCellInUTRAN */
static int hf_x2ap_TargeteNBtoSource_eNBTransparentContainer_PDU = -1;  /* TargeteNBtoSource_eNBTransparentContainer */
static int hf_x2ap_TDDULDLConfigurationCommonNR_PDU = -1;  /* TDDULDLConfigurationCommonNR */
static int hf_x2ap_TimeToWait_PDU = -1;           /* TimeToWait */
static int hf_x2ap_Time_UE_StayedInCell_EnhancedGranularity_PDU = -1;  /* Time_UE_StayedInCell_EnhancedGranularity */
static int hf_x2ap_TNLA_To_Add_List_PDU = -1;     /* TNLA_To_Add_List */
static int hf_x2ap_TNLA_To_Update_List_PDU = -1;  /* TNLA_To_Update_List */
static int hf_x2ap_TNLA_To_Remove_List_PDU = -1;  /* TNLA_To_Remove_List */
static int hf_x2ap_TNLA_Setup_List_PDU = -1;      /* TNLA_Setup_List */
static int hf_x2ap_TNLA_Failed_To_Setup_List_PDU = -1;  /* TNLA_Failed_To_Setup_List */
static int hf_x2ap_TNLConfigurationInfo_PDU = -1;  /* TNLConfigurationInfo */
static int hf_x2ap_TraceActivation_PDU = -1;      /* TraceActivation */
static int hf_x2ap_TransportLayerAddress_PDU = -1;  /* TransportLayerAddress */
static int hf_x2ap_TunnelInformation_PDU = -1;    /* TunnelInformation */
static int hf_x2ap_UEAggregateMaximumBitRate_PDU = -1;  /* UEAggregateMaximumBitRate */
static int hf_x2ap_UEAppLayerMeasConfig_PDU = -1;  /* UEAppLayerMeasConfig */
static int hf_x2ap_UE_ContextKeptIndicator_PDU = -1;  /* UE_ContextKeptIndicator */
static int hf_x2ap_UEID_PDU = -1;                 /* UEID */
static int hf_x2ap_UE_HistoryInformation_PDU = -1;  /* UE_HistoryInformation */
static int hf_x2ap_UE_HistoryInformationFromTheUE_PDU = -1;  /* UE_HistoryInformationFromTheUE */
static int hf_x2ap_UE_X2AP_ID_PDU = -1;           /* UE_X2AP_ID */
static int hf_x2ap_UE_X2AP_ID_Extension_PDU = -1;  /* UE_X2AP_ID_Extension */
static int hf_x2ap_UERadioCapability_PDU = -1;    /* UERadioCapability */
static int hf_x2ap_UERadioCapabilityID_PDU = -1;  /* UERadioCapabilityID */
static int hf_x2ap_UE_RLF_Report_Container_PDU = -1;  /* UE_RLF_Report_Container */
static int hf_x2ap_UE_RLF_Report_Container_for_extended_bands_PDU = -1;  /* UE_RLF_Report_Container_for_extended_bands */
static int hf_x2ap_UESecurityCapabilities_PDU = -1;  /* UESecurityCapabilities */
static int hf_x2ap_UESidelinkAggregateMaximumBitRate_PDU = -1;  /* UESidelinkAggregateMaximumBitRate */
static int hf_x2ap_UEsToBeResetList_PDU = -1;     /* UEsToBeResetList */
static int hf_x2ap_UL_scheduling_PDCCH_CCE_usage_PDU = -1;  /* UL_scheduling_PDCCH_CCE_usage */
static int hf_x2ap_UnlicensedSpectrumRestriction_PDU = -1;  /* UnlicensedSpectrumRestriction */
static int hf_x2ap_URI_Address_PDU = -1;          /* URI_Address */
static int hf_x2ap_UserPlaneTrafficActivityReport_PDU = -1;  /* UserPlaneTrafficActivityReport */
static int hf_x2ap_V2XServicesAuthorized_PDU = -1;  /* V2XServicesAuthorized */
static int hf_x2ap_WLANMeasurementConfiguration_PDU = -1;  /* WLANMeasurementConfiguration */
static int hf_x2ap_X2BenefitValue_PDU = -1;       /* X2BenefitValue */
static int hf_x2ap_HandoverRequest_PDU = -1;      /* HandoverRequest */
static int hf_x2ap_UE_ContextInformation_PDU = -1;  /* UE_ContextInformation */
static int hf_x2ap_E_RABs_ToBeSetup_Item_PDU = -1;  /* E_RABs_ToBeSetup_Item */
static int hf_x2ap_MobilityInformation_PDU = -1;  /* MobilityInformation */
static int hf_x2ap_UE_ContextReferenceAtSeNB_PDU = -1;  /* UE_ContextReferenceAtSeNB */
static int hf_x2ap_UE_ContextReferenceAtWT_PDU = -1;  /* UE_ContextReferenceAtWT */
static int hf_x2ap_UE_ContextReferenceAtSgNB_PDU = -1;  /* UE_ContextReferenceAtSgNB */
static int hf_x2ap_HandoverRequestAcknowledge_PDU = -1;  /* HandoverRequestAcknowledge */
static int hf_x2ap_E_RABs_Admitted_List_PDU = -1;  /* E_RABs_Admitted_List */
static int hf_x2ap_E_RABs_Admitted_Item_PDU = -1;  /* E_RABs_Admitted_Item */
static int hf_x2ap_HandoverPreparationFailure_PDU = -1;  /* HandoverPreparationFailure */
static int hf_x2ap_HandoverReport_PDU = -1;       /* HandoverReport */
static int hf_x2ap_EarlyStatusTransfer_PDU = -1;  /* EarlyStatusTransfer */
static int hf_x2ap_ProcedureStageChoice_PDU = -1;  /* ProcedureStageChoice */
static int hf_x2ap_SNStatusTransfer_PDU = -1;     /* SNStatusTransfer */
static int hf_x2ap_E_RABs_SubjectToStatusTransfer_List_PDU = -1;  /* E_RABs_SubjectToStatusTransfer_List */
static int hf_x2ap_E_RABs_SubjectToStatusTransfer_Item_PDU = -1;  /* E_RABs_SubjectToStatusTransfer_Item */
static int hf_x2ap_UEContextRelease_PDU = -1;     /* UEContextRelease */
static int hf_x2ap_HandoverCancel_PDU = -1;       /* HandoverCancel */
static int hf_x2ap_HandoverSuccess_PDU = -1;      /* HandoverSuccess */
static int hf_x2ap_ConditionalHandoverCancel_PDU = -1;  /* ConditionalHandoverCancel */
static int hf_x2ap_ErrorIndication_PDU = -1;      /* ErrorIndication */
static int hf_x2ap_ResetRequest_PDU = -1;         /* ResetRequest */
static int hf_x2ap_ResetResponse_PDU = -1;        /* ResetResponse */
static int hf_x2ap_X2SetupRequest_PDU = -1;       /* X2SetupRequest */
static int hf_x2ap_X2SetupResponse_PDU = -1;      /* X2SetupResponse */
static int hf_x2ap_X2SetupFailure_PDU = -1;       /* X2SetupFailure */
static int hf_x2ap_LoadInformation_PDU = -1;      /* LoadInformation */
static int hf_x2ap_CellInformation_List_PDU = -1;  /* CellInformation_List */
static int hf_x2ap_CellInformation_Item_PDU = -1;  /* CellInformation_Item */
static int hf_x2ap_ENBConfigurationUpdate_PDU = -1;  /* ENBConfigurationUpdate */
static int hf_x2ap_ServedCellsToModify_PDU = -1;  /* ServedCellsToModify */
static int hf_x2ap_Old_ECGIs_PDU = -1;            /* Old_ECGIs */
static int hf_x2ap_ENBConfigurationUpdateAcknowledge_PDU = -1;  /* ENBConfigurationUpdateAcknowledge */
static int hf_x2ap_ENBConfigurationUpdateFailure_PDU = -1;  /* ENBConfigurationUpdateFailure */
static int hf_x2ap_ResourceStatusRequest_PDU = -1;  /* ResourceStatusRequest */
static int hf_x2ap_CellToReport_List_PDU = -1;    /* CellToReport_List */
static int hf_x2ap_CellToReport_Item_PDU = -1;    /* CellToReport_Item */
static int hf_x2ap_ReportingPeriodicity_PDU = -1;  /* ReportingPeriodicity */
static int hf_x2ap_PartialSuccessIndicator_PDU = -1;  /* PartialSuccessIndicator */
static int hf_x2ap_ResourceStatusResponse_PDU = -1;  /* ResourceStatusResponse */
static int hf_x2ap_MeasurementInitiationResult_List_PDU = -1;  /* MeasurementInitiationResult_List */
static int hf_x2ap_MeasurementInitiationResult_Item_PDU = -1;  /* MeasurementInitiationResult_Item */
static int hf_x2ap_MeasurementFailureCause_Item_PDU = -1;  /* MeasurementFailureCause_Item */
static int hf_x2ap_ResourceStatusFailure_PDU = -1;  /* ResourceStatusFailure */
static int hf_x2ap_CompleteFailureCauseInformation_List_PDU = -1;  /* CompleteFailureCauseInformation_List */
static int hf_x2ap_CompleteFailureCauseInformation_Item_PDU = -1;  /* CompleteFailureCauseInformation_Item */
static int hf_x2ap_ResourceStatusUpdate_PDU = -1;  /* ResourceStatusUpdate */
static int hf_x2ap_CellMeasurementResult_List_PDU = -1;  /* CellMeasurementResult_List */
static int hf_x2ap_CellMeasurementResult_Item_PDU = -1;  /* CellMeasurementResult_Item */
static int hf_x2ap_PrivateMessage_PDU = -1;       /* PrivateMessage */
static int hf_x2ap_MobilityChangeRequest_PDU = -1;  /* MobilityChangeRequest */
static int hf_x2ap_MobilityChangeAcknowledge_PDU = -1;  /* MobilityChangeAcknowledge */
static int hf_x2ap_MobilityChangeFailure_PDU = -1;  /* MobilityChangeFailure */
static int hf_x2ap_RLFIndication_PDU = -1;        /* RLFIndication */
static int hf_x2ap_CellActivationRequest_PDU = -1;  /* CellActivationRequest */
static int hf_x2ap_ServedCellsToActivate_PDU = -1;  /* ServedCellsToActivate */
static int hf_x2ap_CellActivationResponse_PDU = -1;  /* CellActivationResponse */
static int hf_x2ap_ActivatedCellList_PDU = -1;    /* ActivatedCellList */
static int hf_x2ap_CellActivationFailure_PDU = -1;  /* CellActivationFailure */
static int hf_x2ap_X2Release_PDU = -1;            /* X2Release */
static int hf_x2ap_X2APMessageTransfer_PDU = -1;  /* X2APMessageTransfer */
static int hf_x2ap_RNL_Header_PDU = -1;           /* RNL_Header */
static int hf_x2ap_X2AP_Message_PDU = -1;         /* X2AP_Message */
static int hf_x2ap_SeNBAdditionRequest_PDU = -1;  /* SeNBAdditionRequest */
static int hf_x2ap_E_RABs_ToBeAdded_List_PDU = -1;  /* E_RABs_ToBeAdded_List */
static int hf_x2ap_E_RABs_ToBeAdded_Item_PDU = -1;  /* E_RABs_ToBeAdded_Item */
static int hf_x2ap_SeNBAdditionRequestAcknowledge_PDU = -1;  /* SeNBAdditionRequestAcknowledge */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_List_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_List */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_Item_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_Item */
static int hf_x2ap_SeNBAdditionRequestReject_PDU = -1;  /* SeNBAdditionRequestReject */
static int hf_x2ap_SeNBReconfigurationComplete_PDU = -1;  /* SeNBReconfigurationComplete */
static int hf_x2ap_ResponseInformationSeNBReconfComp_PDU = -1;  /* ResponseInformationSeNBReconfComp */
static int hf_x2ap_SeNBModificationRequest_PDU = -1;  /* SeNBModificationRequest */
static int hf_x2ap_UE_ContextInformationSeNBModReq_PDU = -1;  /* UE_ContextInformationSeNBModReq */
static int hf_x2ap_E_RABs_ToBeAdded_ModReqItem_PDU = -1;  /* E_RABs_ToBeAdded_ModReqItem */
static int hf_x2ap_E_RABs_ToBeModified_ModReqItem_PDU = -1;  /* E_RABs_ToBeModified_ModReqItem */
static int hf_x2ap_E_RABs_ToBeReleased_ModReqItem_PDU = -1;  /* E_RABs_ToBeReleased_ModReqItem */
static int hf_x2ap_SeNBModificationRequestAcknowledge_PDU = -1;  /* SeNBModificationRequestAcknowledge */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_ModAckList */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_ModAckItem */
static int hf_x2ap_E_RABs_Admitted_ToBeModified_ModAckList_PDU = -1;  /* E_RABs_Admitted_ToBeModified_ModAckList */
static int hf_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_PDU = -1;  /* E_RABs_Admitted_ToBeModified_ModAckItem */
static int hf_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList_PDU = -1;  /* E_RABs_Admitted_ToBeReleased_ModAckList */
static int hf_x2ap_E_RABs_Admitted_ToReleased_ModAckItem_PDU = -1;  /* E_RABs_Admitted_ToReleased_ModAckItem */
static int hf_x2ap_SeNBModificationRequestReject_PDU = -1;  /* SeNBModificationRequestReject */
static int hf_x2ap_SeNBModificationRequired_PDU = -1;  /* SeNBModificationRequired */
static int hf_x2ap_E_RABs_ToBeReleased_ModReqd_PDU = -1;  /* E_RABs_ToBeReleased_ModReqd */
static int hf_x2ap_E_RABs_ToBeReleased_ModReqdItem_PDU = -1;  /* E_RABs_ToBeReleased_ModReqdItem */
static int hf_x2ap_SeNBModificationConfirm_PDU = -1;  /* SeNBModificationConfirm */
static int hf_x2ap_SeNBModificationRefuse_PDU = -1;  /* SeNBModificationRefuse */
static int hf_x2ap_SeNBReleaseRequest_PDU = -1;   /* SeNBReleaseRequest */
static int hf_x2ap_E_RABs_ToBeReleased_List_RelReq_PDU = -1;  /* E_RABs_ToBeReleased_List_RelReq */
static int hf_x2ap_E_RABs_ToBeReleased_RelReqItem_PDU = -1;  /* E_RABs_ToBeReleased_RelReqItem */
static int hf_x2ap_SeNBReleaseRequired_PDU = -1;  /* SeNBReleaseRequired */
static int hf_x2ap_SeNBReleaseConfirm_PDU = -1;   /* SeNBReleaseConfirm */
static int hf_x2ap_E_RABs_ToBeReleased_List_RelConf_PDU = -1;  /* E_RABs_ToBeReleased_List_RelConf */
static int hf_x2ap_E_RABs_ToBeReleased_RelConfItem_PDU = -1;  /* E_RABs_ToBeReleased_RelConfItem */
static int hf_x2ap_SeNBCounterCheckRequest_PDU = -1;  /* SeNBCounterCheckRequest */
static int hf_x2ap_E_RABs_SubjectToCounterCheck_List_PDU = -1;  /* E_RABs_SubjectToCounterCheck_List */
static int hf_x2ap_E_RABs_SubjectToCounterCheckItem_PDU = -1;  /* E_RABs_SubjectToCounterCheckItem */
static int hf_x2ap_X2RemovalRequest_PDU = -1;     /* X2RemovalRequest */
static int hf_x2ap_X2RemovalResponse_PDU = -1;    /* X2RemovalResponse */
static int hf_x2ap_X2RemovalFailure_PDU = -1;     /* X2RemovalFailure */
static int hf_x2ap_RetrieveUEContextRequest_PDU = -1;  /* RetrieveUEContextRequest */
static int hf_x2ap_RetrieveUEContextResponse_PDU = -1;  /* RetrieveUEContextResponse */
static int hf_x2ap_UE_ContextInformationRetrieve_PDU = -1;  /* UE_ContextInformationRetrieve */
static int hf_x2ap_E_RABs_ToBeSetupRetrieve_Item_PDU = -1;  /* E_RABs_ToBeSetupRetrieve_Item */
static int hf_x2ap_RetrieveUEContextFailure_PDU = -1;  /* RetrieveUEContextFailure */
static int hf_x2ap_SgNBAdditionRequest_PDU = -1;  /* SgNBAdditionRequest */
static int hf_x2ap_E_RABs_ToBeAdded_SgNBAddReqList_PDU = -1;  /* E_RABs_ToBeAdded_SgNBAddReqList */
static int hf_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_PDU = -1;  /* E_RABs_ToBeAdded_SgNBAddReq_Item */
static int hf_x2ap_SgNBAdditionRequestAcknowledge_PDU = -1;  /* SgNBAdditionRequestAcknowledge */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item */
static int hf_x2ap_SgNBAdditionRequestReject_PDU = -1;  /* SgNBAdditionRequestReject */
static int hf_x2ap_SgNBReconfigurationComplete_PDU = -1;  /* SgNBReconfigurationComplete */
static int hf_x2ap_ResponseInformationSgNBReconfComp_PDU = -1;  /* ResponseInformationSgNBReconfComp */
static int hf_x2ap_SgNBModificationRequest_PDU = -1;  /* SgNBModificationRequest */
static int hf_x2ap_UE_ContextInformation_SgNBModReq_PDU = -1;  /* UE_ContextInformation_SgNBModReq */
static int hf_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_PDU = -1;  /* E_RABs_ToBeAdded_SgNBModReq_Item */
static int hf_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_PDU = -1;  /* E_RABs_ToBeModified_SgNBModReq_Item */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_PDU = -1;  /* E_RABs_ToBeReleased_SgNBModReq_Item */
static int hf_x2ap_SgNBModificationRequestAcknowledge_PDU = -1;  /* SgNBModificationRequestAcknowledge */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_SgNBModAckList */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_PDU = -1;  /* E_RABs_Admitted_ToBeAdded_SgNBModAck_Item */
static int hf_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList_PDU = -1;  /* E_RABs_Admitted_ToBeModified_SgNBModAckList */
static int hf_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_PDU = -1;  /* E_RABs_Admitted_ToBeModified_SgNBModAck_Item */
static int hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList_PDU = -1;  /* E_RABs_Admitted_ToBeReleased_SgNBModAckList */
static int hf_x2ap_E_RABs_Admitted_ToReleased_SgNBModAck_Item_PDU = -1;  /* E_RABs_Admitted_ToReleased_SgNBModAck_Item */
static int hf_x2ap_SgNBModificationRequestReject_PDU = -1;  /* SgNBModificationRequestReject */
static int hf_x2ap_SgNBModificationRequired_PDU = -1;  /* SgNBModificationRequired */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBModReqdList_PDU = -1;  /* E_RABs_ToBeReleased_SgNBModReqdList */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBModReqd_Item_PDU = -1;  /* E_RABs_ToBeReleased_SgNBModReqd_Item */
static int hf_x2ap_E_RABs_ToBeModified_SgNBModReqdList_PDU = -1;  /* E_RABs_ToBeModified_SgNBModReqdList */
static int hf_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_PDU = -1;  /* E_RABs_ToBeModified_SgNBModReqd_Item */
static int hf_x2ap_SgNBModificationConfirm_PDU = -1;  /* SgNBModificationConfirm */
static int hf_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList_PDU = -1;  /* E_RABs_AdmittedToBeModified_SgNBModConfList */
static int hf_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_PDU = -1;  /* E_RABs_AdmittedToBeModified_SgNBModConf_Item */
static int hf_x2ap_SgNBModificationRefuse_PDU = -1;  /* SgNBModificationRefuse */
static int hf_x2ap_SgNBReleaseRequest_PDU = -1;   /* SgNBReleaseRequest */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqList_PDU = -1;  /* E_RABs_ToBeReleased_SgNBRelReqList */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_PDU = -1;  /* E_RABs_ToBeReleased_SgNBRelReq_Item */
static int hf_x2ap_SgNBReleaseRequestAcknowledge_PDU = -1;  /* SgNBReleaseRequestAcknowledge */
static int hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList_PDU = -1;  /* E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList */
static int hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item_PDU = -1;  /* E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item */
static int hf_x2ap_SgNBReleaseRequestReject_PDU = -1;  /* SgNBReleaseRequestReject */
static int hf_x2ap_SgNBReleaseRequired_PDU = -1;  /* SgNBReleaseRequired */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList_PDU = -1;  /* E_RABs_ToBeReleased_SgNBRelReqdList */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqd_Item_PDU = -1;  /* E_RABs_ToBeReleased_SgNBRelReqd_Item */
static int hf_x2ap_SgNBReleaseConfirm_PDU = -1;   /* SgNBReleaseConfirm */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelConfList_PDU = -1;  /* E_RABs_ToBeReleased_SgNBRelConfList */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_PDU = -1;  /* E_RABs_ToBeReleased_SgNBRelConf_Item */
static int hf_x2ap_SgNBCounterCheckRequest_PDU = -1;  /* SgNBCounterCheckRequest */
static int hf_x2ap_E_RABs_SubjectToSgNBCounterCheck_List_PDU = -1;  /* E_RABs_SubjectToSgNBCounterCheck_List */
static int hf_x2ap_E_RABs_SubjectToSgNBCounterCheck_Item_PDU = -1;  /* E_RABs_SubjectToSgNBCounterCheck_Item */
static int hf_x2ap_SgNBChangeRequired_PDU = -1;   /* SgNBChangeRequired */
static int hf_x2ap_SgNBChangeConfirm_PDU = -1;    /* SgNBChangeConfirm */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBChaConfList_PDU = -1;  /* E_RABs_ToBeReleased_SgNBChaConfList */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_PDU = -1;  /* E_RABs_ToBeReleased_SgNBChaConf_Item */
static int hf_x2ap_RRCTransfer_PDU = -1;          /* RRCTransfer */
static int hf_x2ap_SgNBChangeRefuse_PDU = -1;     /* SgNBChangeRefuse */
static int hf_x2ap_ENDCX2SetupRequest_PDU = -1;   /* ENDCX2SetupRequest */
static int hf_x2ap_InitiatingNodeType_EndcX2Setup_PDU = -1;  /* InitiatingNodeType_EndcX2Setup */
static int hf_x2ap_ServedEUTRAcellsENDCX2ManagementList_PDU = -1;  /* ServedEUTRAcellsENDCX2ManagementList */
static int hf_x2ap_ServedNRcellsENDCX2ManagementList_PDU = -1;  /* ServedNRcellsENDCX2ManagementList */
static int hf_x2ap_CellandCapacityAssistInfo_PDU = -1;  /* CellandCapacityAssistInfo */
static int hf_x2ap_CellAssistanceInformation_PDU = -1;  /* CellAssistanceInformation */
static int hf_x2ap_ENDCX2SetupResponse_PDU = -1;  /* ENDCX2SetupResponse */
static int hf_x2ap_RespondingNodeType_EndcX2Setup_PDU = -1;  /* RespondingNodeType_EndcX2Setup */
static int hf_x2ap_ENDCX2SetupFailure_PDU = -1;   /* ENDCX2SetupFailure */
static int hf_x2ap_ENDCConfigurationUpdate_PDU = -1;  /* ENDCConfigurationUpdate */
static int hf_x2ap_InitiatingNodeType_EndcConfigUpdate_PDU = -1;  /* InitiatingNodeType_EndcConfigUpdate */
static int hf_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_PDU = -1;  /* ServedEUTRAcellsToModifyListENDCConfUpd */
static int hf_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd_PDU = -1;  /* ServedEUTRAcellsToDeleteListENDCConfUpd */
static int hf_x2ap_ServedNRcellsToModifyENDCConfUpdList_PDU = -1;  /* ServedNRcellsToModifyENDCConfUpdList */
static int hf_x2ap_ServedNRcellsToDeleteENDCConfUpdList_PDU = -1;  /* ServedNRcellsToDeleteENDCConfUpdList */
static int hf_x2ap_ENDCConfigurationUpdateAcknowledge_PDU = -1;  /* ENDCConfigurationUpdateAcknowledge */
static int hf_x2ap_RespondingNodeType_EndcConfigUpdate_PDU = -1;  /* RespondingNodeType_EndcConfigUpdate */
static int hf_x2ap_ENDCConfigurationUpdateFailure_PDU = -1;  /* ENDCConfigurationUpdateFailure */
static int hf_x2ap_ENDCCellActivationRequest_PDU = -1;  /* ENDCCellActivationRequest */
static int hf_x2ap_ServedNRCellsToActivate_PDU = -1;  /* ServedNRCellsToActivate */
static int hf_x2ap_ENDCCellActivationResponse_PDU = -1;  /* ENDCCellActivationResponse */
static int hf_x2ap_ActivatedNRCellList_PDU = -1;  /* ActivatedNRCellList */
static int hf_x2ap_ENDCCellActivationFailure_PDU = -1;  /* ENDCCellActivationFailure */
static int hf_x2ap_ENDCResourceStatusRequest_PDU = -1;  /* ENDCResourceStatusRequest */
static int hf_x2ap_CellToReport_NR_ENDC_List_PDU = -1;  /* CellToReport_NR_ENDC_List */
static int hf_x2ap_CellToReport_NR_ENDC_Item_PDU = -1;  /* CellToReport_NR_ENDC_Item */
static int hf_x2ap_CellToReport_E_UTRA_ENDC_List_PDU = -1;  /* CellToReport_E_UTRA_ENDC_List */
static int hf_x2ap_CellToReport_E_UTRA_ENDC_Item_PDU = -1;  /* CellToReport_E_UTRA_ENDC_Item */
static int hf_x2ap_ENDCResourceStatusResponse_PDU = -1;  /* ENDCResourceStatusResponse */
static int hf_x2ap_ENDCResourceStatusFailure_PDU = -1;  /* ENDCResourceStatusFailure */
static int hf_x2ap_ENDCResourceStatusUpdate_PDU = -1;  /* ENDCResourceStatusUpdate */
static int hf_x2ap_CellMeasurementResult_NR_ENDC_List_PDU = -1;  /* CellMeasurementResult_NR_ENDC_List */
static int hf_x2ap_CellMeasurementResult_NR_ENDC_Item_PDU = -1;  /* CellMeasurementResult_NR_ENDC_Item */
static int hf_x2ap_CellMeasurementResult_E_UTRA_ENDC_List_PDU = -1;  /* CellMeasurementResult_E_UTRA_ENDC_List */
static int hf_x2ap_CellMeasurementResult_E_UTRA_ENDC_Item_PDU = -1;  /* CellMeasurementResult_E_UTRA_ENDC_Item */
static int hf_x2ap_SecondaryRATDataUsageReport_PDU = -1;  /* SecondaryRATDataUsageReport */
static int hf_x2ap_SgNBActivityNotification_PDU = -1;  /* SgNBActivityNotification */
static int hf_x2ap_ENDCPartialResetRequired_PDU = -1;  /* ENDCPartialResetRequired */
static int hf_x2ap_ENDCPartialResetConfirm_PDU = -1;  /* ENDCPartialResetConfirm */
static int hf_x2ap_x2ap_EUTRANRCellResourceCoordinationRequest_PDU = -1;  /* EUTRANRCellResourceCoordinationRequest */
static int hf_x2ap_InitiatingNodeType_EutranrCellResourceCoordination_PDU = -1;  /* InitiatingNodeType_EutranrCellResourceCoordination */
static int hf_x2ap_ListofEUTRACellsinEUTRACoordinationReq_PDU = -1;  /* ListofEUTRACellsinEUTRACoordinationReq */
static int hf_x2ap_ListofEUTRACellsinNRCoordinationReq_PDU = -1;  /* ListofEUTRACellsinNRCoordinationReq */
static int hf_x2ap_ListofNRCellsinNRCoordinationReq_PDU = -1;  /* ListofNRCellsinNRCoordinationReq */
static int hf_x2ap_x2ap_EUTRANRCellResourceCoordinationResponse_PDU = -1;  /* EUTRANRCellResourceCoordinationResponse */
static int hf_x2ap_RespondingNodeType_EutranrCellResourceCoordination_PDU = -1;  /* RespondingNodeType_EutranrCellResourceCoordination */
static int hf_x2ap_ListofEUTRACellsinEUTRACoordinationResp_PDU = -1;  /* ListofEUTRACellsinEUTRACoordinationResp */
static int hf_x2ap_ListofNRCellsinNRCoordinationResp_PDU = -1;  /* ListofNRCellsinNRCoordinationResp */
static int hf_x2ap_ENDCX2RemovalRequest_PDU = -1;  /* ENDCX2RemovalRequest */
static int hf_x2ap_InitiatingNodeType_EndcX2Removal_PDU = -1;  /* InitiatingNodeType_EndcX2Removal */
static int hf_x2ap_ENDCX2RemovalResponse_PDU = -1;  /* ENDCX2RemovalResponse */
static int hf_x2ap_RespondingNodeType_EndcX2Removal_PDU = -1;  /* RespondingNodeType_EndcX2Removal */
static int hf_x2ap_ENDCX2RemovalFailure_PDU = -1;  /* ENDCX2RemovalFailure */
static int hf_x2ap_DataForwardingAddressIndication_PDU = -1;  /* DataForwardingAddressIndication */
static int hf_x2ap_E_RABs_DataForwardingAddress_List_PDU = -1;  /* E_RABs_DataForwardingAddress_List */
static int hf_x2ap_E_RABs_DataForwardingAddress_Item_PDU = -1;  /* E_RABs_DataForwardingAddress_Item */
static int hf_x2ap_GNBStatusIndication_PDU = -1;  /* GNBStatusIndication */
static int hf_x2ap_ENDCConfigurationTransfer_PDU = -1;  /* ENDCConfigurationTransfer */
static int hf_x2ap_TraceStart_PDU = -1;           /* TraceStart */
static int hf_x2ap_DeactivateTrace_PDU = -1;      /* DeactivateTrace */
static int hf_x2ap_CellTrafficTrace_PDU = -1;     /* CellTrafficTrace */
static int hf_x2ap_F1CTrafficTransfer_PDU = -1;   /* F1CTrafficTransfer */
static int hf_x2ap_UERadioCapabilityIDMappingRequest_PDU = -1;  /* UERadioCapabilityIDMappingRequest */
static int hf_x2ap_UERadioCapabilityIDMappingResponse_PDU = -1;  /* UERadioCapabilityIDMappingResponse */
static int hf_x2ap_X2AP_PDU_PDU = -1;             /* X2AP_PDU */
static int hf_x2ap_local = -1;                    /* INTEGER_0_maxPrivateIEs */
static int hf_x2ap_global = -1;                   /* OBJECT_IDENTIFIER */
static int hf_x2ap_ProtocolIE_Container_item = -1;  /* ProtocolIE_Field */
static int hf_x2ap_id = -1;                       /* ProtocolIE_ID */
static int hf_x2ap_criticality = -1;              /* Criticality */
static int hf_x2ap_protocolIE_Field_value = -1;   /* ProtocolIE_Field_value */
static int hf_x2ap_ProtocolExtensionContainer_item = -1;  /* ProtocolExtensionField */
static int hf_x2ap_extension_id = -1;             /* ProtocolIE_ID */
static int hf_x2ap_extensionValue = -1;           /* T_extensionValue */
static int hf_x2ap_PrivateIE_Container_item = -1;  /* PrivateIE_Field */
static int hf_x2ap_private_id = -1;               /* PrivateIE_ID */
static int hf_x2ap_privateIE_Field_value = -1;    /* PrivateIE_Field_value */
static int hf_x2ap_fdd = -1;                      /* ABSInformationFDD */
static int hf_x2ap_tdd = -1;                      /* ABSInformationTDD */
static int hf_x2ap_abs_inactive = -1;             /* NULL */
static int hf_x2ap_abs_pattern_info = -1;         /* BIT_STRING_SIZE_40 */
static int hf_x2ap_numberOfCellSpecificAntennaPorts = -1;  /* T_numberOfCellSpecificAntennaPorts */
static int hf_x2ap_measurement_subset = -1;       /* BIT_STRING_SIZE_40 */
static int hf_x2ap_iE_Extensions = -1;            /* ProtocolExtensionContainer */
static int hf_x2ap_abs_pattern_info_01 = -1;      /* BIT_STRING_SIZE_1_70_ */
static int hf_x2ap_numberOfCellSpecificAntennaPorts_01 = -1;  /* T_numberOfCellSpecificAntennaPorts_01 */
static int hf_x2ap_measurement_subset_01 = -1;    /* BIT_STRING_SIZE_1_70_ */
static int hf_x2ap_dL_ABS_status = -1;            /* DL_ABS_status */
static int hf_x2ap_usableABSInformation = -1;     /* UsableABSInformation */
static int hf_x2ap_additionalspecialSubframePatterns = -1;  /* AdditionalSpecialSubframePatterns */
static int hf_x2ap_cyclicPrefixDL = -1;           /* CyclicPrefixDL */
static int hf_x2ap_cyclicPrefixUL = -1;           /* CyclicPrefixUL */
static int hf_x2ap_additionalspecialSubframePatternsExtension = -1;  /* AdditionalSpecialSubframePatternsExtension */
static int hf_x2ap_priorityLevel = -1;            /* PriorityLevel */
static int hf_x2ap_pre_emptionCapability = -1;    /* Pre_emptionCapability */
static int hf_x2ap_pre_emptionVulnerability = -1;  /* Pre_emptionVulnerability */
static int hf_x2ap_cellBased = -1;                /* CellBasedMDT */
static int hf_x2ap_tABased = -1;                  /* TABasedMDT */
static int hf_x2ap_pLMNWide = -1;                 /* NULL */
static int hf_x2ap_tAIBased = -1;                 /* TAIBasedMDT */
static int hf_x2ap_cellBased_01 = -1;             /* CellBasedQMC */
static int hf_x2ap_tABased_01 = -1;               /* TABasedQMC */
static int hf_x2ap_tAIBased_01 = -1;              /* TAIBasedQMC */
static int hf_x2ap_pLMNAreaBased = -1;            /* PLMNAreaBasedQMC */
static int hf_x2ap_key_eNodeB_star = -1;          /* Key_eNodeB_Star */
static int hf_x2ap_nextHopChainingCount = -1;     /* NextHopChainingCount */
static int hf_x2ap_AdditionalPLMNs_Item_item = -1;  /* PLMN_Identity */
static int hf_x2ap_BroadcastPLMNs_Item_item = -1;  /* PLMN_Identity */
static int hf_x2ap_bluetoothMeasConfig = -1;      /* BluetoothMeasConfig */
static int hf_x2ap_bluetoothMeasConfigNameList = -1;  /* BluetoothMeasConfigNameList */
static int hf_x2ap_bt_rssi = -1;                  /* T_bt_rssi */
static int hf_x2ap_BluetoothMeasConfigNameList_item = -1;  /* BluetoothName */
static int hf_x2ap_BPLMN_ID_Info_EUTRA_item = -1;  /* BPLMN_ID_Info_EUTRA_Item */
static int hf_x2ap_broadcastPLMNs = -1;           /* BroadcastPLMNs_Item */
static int hf_x2ap_tac = -1;                      /* TAC */
static int hf_x2ap_e_utraCI = -1;                 /* EUTRANCellIdentifier */
static int hf_x2ap_iE_Extension = -1;             /* ProtocolExtensionContainer */
static int hf_x2ap_BPLMN_ID_Info_NR_item = -1;    /* BPLMN_ID_Info_NR_Item */
static int hf_x2ap_broadcastPLMNs_01 = -1;        /* BroadcastextPLMNs */
static int hf_x2ap_fiveGS_TAC = -1;               /* FiveGS_TAC */
static int hf_x2ap_nr_CI = -1;                    /* NRCellIdentifier */
static int hf_x2ap_BroadcastextPLMNs_item = -1;   /* PLMN_Identity */
static int hf_x2ap_radioNetwork = -1;             /* CauseRadioNetwork */
static int hf_x2ap_transport = -1;                /* CauseTransport */
static int hf_x2ap_protocol = -1;                 /* CauseProtocol */
static int hf_x2ap_misc = -1;                     /* CauseMisc */
static int hf_x2ap_cellIdListforMDT = -1;         /* CellIdListforMDT */
static int hf_x2ap_cellIdListforQMC = -1;         /* CellIdListforQMC */
static int hf_x2ap_CellIdListforMDT_item = -1;    /* ECGI */
static int hf_x2ap_CellIdListforQMC_item = -1;    /* ECGI */
static int hf_x2ap_replacingCellsList = -1;       /* ReplacingCellsList */
static int hf_x2ap_cell_Size = -1;                /* Cell_Size */
static int hf_x2ap_CNTypeRestrictions_item = -1;  /* CNTypeRestrictionsItem */
static int hf_x2ap_plmn_Id = -1;                  /* PLMN_Identity */
static int hf_x2ap_cn_type = -1;                  /* T_cn_type */
static int hf_x2ap_CoMPHypothesisSet_item = -1;   /* CoMPHypothesisSetItem */
static int hf_x2ap_coMPCellID = -1;               /* ECGI */
static int hf_x2ap_coMPHypothesis = -1;           /* BIT_STRING_SIZE_6_4400_ */
static int hf_x2ap_coMPInformationItem = -1;      /* CoMPInformationItem */
static int hf_x2ap_coMPInformationStartTime = -1;  /* CoMPInformationStartTime */
static int hf_x2ap_CoMPInformationItem_item = -1;  /* CoMPInformationItem_item */
static int hf_x2ap_coMPHypothesisSet = -1;        /* CoMPHypothesisSet */
static int hf_x2ap_benefitMetric = -1;            /* BenefitMetric */
static int hf_x2ap_CoMPInformationStartTime_item = -1;  /* CoMPInformationStartTime_item */
static int hf_x2ap_startSFN = -1;                 /* INTEGER_0_1023_ */
static int hf_x2ap_startSubframeNumber = -1;      /* INTEGER_0_9_ */
static int hf_x2ap_cellCapacityClassValue = -1;   /* CellCapacityClassValue */
static int hf_x2ap_capacityValue = -1;            /* CapacityValue */
static int hf_x2ap_dL_CompositeAvailableCapacity = -1;  /* CompositeAvailableCapacity */
static int hf_x2ap_uL_CompositeAvailableCapacity = -1;  /* CompositeAvailableCapacity */
static int hf_x2ap_pDCP_SN = -1;                  /* PDCP_SN */
static int hf_x2ap_hFN = -1;                      /* HFN */
static int hf_x2ap_pDCP_SNExtended = -1;          /* PDCP_SNExtended */
static int hf_x2ap_hFNModified = -1;              /* HFNModified */
static int hf_x2ap_pDCP_SNlength18 = -1;          /* PDCP_SNlength18 */
static int hf_x2ap_hFNforPDCP_SNlength18 = -1;    /* HFNforPDCP_SNlength18 */
static int hf_x2ap_CoverageModificationList_item = -1;  /* CoverageModification_Item */
static int hf_x2ap_eCGI = -1;                     /* ECGI */
static int hf_x2ap_coverageState = -1;            /* INTEGER_0_15_ */
static int hf_x2ap_cellDeploymentStatusIndicator = -1;  /* CellDeploymentStatusIndicator */
static int hf_x2ap_cellReplacingInfo = -1;        /* CellReplacingInfo */
static int hf_x2ap_endpointIPAddress = -1;        /* TransportLayerAddress */
static int hf_x2ap_endpointIPAddressAndPort = -1;  /* TransportLayerAddressAndPort */
static int hf_x2ap_procedureCode = -1;            /* ProcedureCode */
static int hf_x2ap_triggeringMessage = -1;        /* TriggeringMessage */
static int hf_x2ap_procedureCriticality = -1;     /* Criticality */
static int hf_x2ap_iEsCriticalityDiagnostics = -1;  /* CriticalityDiagnostics_IE_List */
static int hf_x2ap_CriticalityDiagnostics_IE_List_item = -1;  /* CriticalityDiagnostics_IE_List_item */
static int hf_x2ap_iECriticality = -1;            /* Criticality */
static int hf_x2ap_iE_ID = -1;                    /* ProtocolIE_ID */
static int hf_x2ap_typeOfError = -1;              /* TypeOfError */
static int hf_x2ap_CSIReportList_item = -1;       /* CSIReportList_item */
static int hf_x2ap_uEID = -1;                     /* UEID */
static int hf_x2ap_cSIReportPerCSIProcess = -1;   /* CSIReportPerCSIProcess */
static int hf_x2ap_CSIReportPerCSIProcess_item = -1;  /* CSIReportPerCSIProcess_item */
static int hf_x2ap_cSIProcessConfigurationIndex = -1;  /* INTEGER_1_7_ */
static int hf_x2ap_cSIReportPerCSIProcessItem = -1;  /* CSIReportPerCSIProcessItem */
static int hf_x2ap_CSIReportPerCSIProcessItem_item = -1;  /* CSIReportPerCSIProcessItem_item */
static int hf_x2ap_rI = -1;                       /* INTEGER_1_8_ */
static int hf_x2ap_widebandCQI = -1;              /* WidebandCQI */
static int hf_x2ap_subbandSize = -1;              /* SubbandSize */
static int hf_x2ap_subbandCQIList = -1;           /* SubbandCQIList */
static int hf_x2ap_cho_trigger = -1;              /* CHOtrigger */
static int hf_x2ap_new_eNB_UE_X2AP_ID = -1;       /* UE_X2AP_ID */
static int hf_x2ap_new_eNB_UE_X2AP_ID_Extension = -1;  /* UE_X2AP_ID_Extension */
static int hf_x2ap_cHO_EstimatedArrivalProbability = -1;  /* CHO_Probability */
static int hf_x2ap_requestedTargetCellID = -1;    /* ECGI */
static int hf_x2ap_maxCHOpreparations = -1;       /* MaxCHOpreparations */
static int hf_x2ap_CandidateCellsToBeCancelledList_item = -1;  /* ECGI */
static int hf_x2ap_activationSFN = -1;            /* INTEGER_0_1023 */
static int hf_x2ap_sharedResourceType = -1;       /* SharedResourceType */
static int hf_x2ap_reservedSubframePattern = -1;  /* ReservedSubframePattern */
static int hf_x2ap_dAPSIndicator = -1;            /* T_dAPSIndicator */
static int hf_x2ap_dAPSResponseIndicator = -1;    /* T_dAPSResponseIndicator */
static int hf_x2ap_highestSuccessDeliveredPDCPSN = -1;  /* INTEGER_0_4095 */
static int hf_x2ap_unchanged = -1;                /* NULL */
static int hf_x2ap_changed = -1;                  /* DLResourceBitmapULandDLSharing */
static int hf_x2ap_naics_active = -1;             /* DynamicNAICSInformation */
static int hf_x2ap_naics_inactive = -1;           /* NULL */
static int hf_x2ap_transmissionModes = -1;        /* T_transmissionModes */
static int hf_x2ap_pB_information = -1;           /* INTEGER_0_3 */
static int hf_x2ap_pA_list = -1;                  /* SEQUENCE_SIZE_0_maxnoofPA_OF_PA_Values */
static int hf_x2ap_pA_list_item = -1;             /* PA_Values */
static int hf_x2ap_pLMN_Identity = -1;            /* PLMN_Identity */
static int hf_x2ap_eUTRANcellIdentifier = -1;     /* EUTRANCellIdentifier */
static int hf_x2ap_enhancedRNTPBitmap = -1;       /* BIT_STRING_SIZE_12_8800_ */
static int hf_x2ap_rNTP_High_Power_Threshold = -1;  /* RNTP_Threshold */
static int hf_x2ap_enhancedRNTPStartTime = -1;    /* EnhancedRNTPStartTime */
static int hf_x2ap_macro_eNB_ID = -1;             /* BIT_STRING_SIZE_20 */
static int hf_x2ap_home_eNB_ID = -1;              /* BIT_STRING_SIZE_28 */
static int hf_x2ap_short_Macro_eNB_ID = -1;       /* BIT_STRING_SIZE_18 */
static int hf_x2ap_long_Macro_eNB_ID = -1;        /* BIT_STRING_SIZE_21 */
static int hf_x2ap_pDCPatSgNB = -1;               /* T_pDCPatSgNB */
static int hf_x2ap_mCGresources = -1;             /* T_mCGresources */
static int hf_x2ap_sCGresources = -1;             /* T_sCGresources */
static int hf_x2ap_EPLMNs_item = -1;              /* PLMN_Identity */
static int hf_x2ap_ERABActivityNotifyItemList_item = -1;  /* ERABActivityNotifyItem */
static int hf_x2ap_e_RAB_ID = -1;                 /* E_RAB_ID */
static int hf_x2ap_activityReport = -1;           /* UserPlaneTrafficActivityReport */
static int hf_x2ap_qCI = -1;                      /* QCI */
static int hf_x2ap_allocationAndRetentionPriority = -1;  /* AllocationAndRetentionPriority */
static int hf_x2ap_gbrQosInformation = -1;        /* GBR_QosInformation */
static int hf_x2ap_E_RAB_List_item = -1;          /* ProtocolIE_Single_Container */
static int hf_x2ap_cause = -1;                    /* Cause */
static int hf_x2ap_E_RABsSubjectToEarlyStatusTransfer_List_item = -1;  /* E_RABsSubjectToEarlyStatusTransfer_Item */
static int hf_x2ap_fIRST_DL_COUNTValue = -1;      /* COUNTvalue */
static int hf_x2ap_fIRST_DL_COUNTValueExtended = -1;  /* COUNTValueExtended */
static int hf_x2ap_fIRST_DL_COUNTValueforPDCPSNLength18 = -1;  /* COUNTvaluePDCP_SNlength18 */
static int hf_x2ap_E_RABsSubjectToDLDiscarding_List_item = -1;  /* E_RABsSubjectToDLDiscarding_Item */
static int hf_x2ap_dISCARD_DL_COUNTValue = -1;    /* COUNTvalue */
static int hf_x2ap_dISCARD_DL_COUNTValueExtended = -1;  /* COUNTValueExtended */
static int hf_x2ap_dISCARD_DL_COUNTValueforPDCPSNLength18 = -1;  /* COUNTvaluePDCP_SNlength18 */
static int hf_x2ap_E_RABUsageReportList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_startTimeStamp = -1;           /* T_startTimeStamp */
static int hf_x2ap_endTimeStamp = -1;             /* T_endTimeStamp */
static int hf_x2ap_usageCountUL = -1;             /* INTEGER_0_18446744073709551615 */
static int hf_x2ap_usageCountDL = -1;             /* INTEGER_0_18446744073709551615 */
static int hf_x2ap_fDD = -1;                      /* FDD_Info */
static int hf_x2ap_tDD = -1;                      /* TDD_Info */
static int hf_x2ap_expectedActivity = -1;         /* ExpectedUEActivityBehaviour */
static int hf_x2ap_expectedHOInterval = -1;       /* ExpectedHOInterval */
static int hf_x2ap_expectedActivityPeriod = -1;   /* ExpectedActivityPeriod */
static int hf_x2ap_expectedIdlePeriod = -1;       /* ExpectedIdlePeriod */
static int hf_x2ap_sourceofUEActivityBehaviourInformation = -1;  /* SourceOfUEActivityBehaviourInformation */
static int hf_x2ap_associatedSubframes = -1;      /* BIT_STRING_SIZE_5 */
static int hf_x2ap_extended_ul_InterferenceOverloadIndication = -1;  /* UL_InterferenceOverloadIndication */
static int hf_x2ap_rrcContainer = -1;             /* RRCContainer */
static int hf_x2ap_uL_EARFCN = -1;                /* EARFCN */
static int hf_x2ap_dL_EARFCN = -1;                /* EARFCN */
static int hf_x2ap_uL_Transmission_Bandwidth = -1;  /* Transmission_Bandwidth */
static int hf_x2ap_dL_Transmission_Bandwidth = -1;  /* Transmission_Bandwidth */
static int hf_x2ap_ul_NRFreqInfo = -1;            /* NRFreqInfo */
static int hf_x2ap_dl_NRFreqInfo = -1;            /* NRFreqInfo */
static int hf_x2ap_ForbiddenTAs_item = -1;        /* ForbiddenTAs_Item */
static int hf_x2ap_forbiddenTACs = -1;            /* ForbiddenTACs */
static int hf_x2ap_ForbiddenTACs_item = -1;       /* TAC */
static int hf_x2ap_ForbiddenLAs_item = -1;        /* ForbiddenLAs_Item */
static int hf_x2ap_forbiddenLACs = -1;            /* ForbiddenLACs */
static int hf_x2ap_ForbiddenLACs_item = -1;       /* LAC */
static int hf_x2ap_freqBandIndicatorNr = -1;      /* INTEGER_1_1024_ */
static int hf_x2ap_supportedSULBandList = -1;     /* SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem */
static int hf_x2ap_supportedSULBandList_item = -1;  /* SupportedSULFreqBandItem */
static int hf_x2ap_e_RAB_MaximumBitrateDL = -1;   /* BitRate */
static int hf_x2ap_e_RAB_MaximumBitrateUL = -1;   /* BitRate */
static int hf_x2ap_e_RAB_GuaranteedBitrateDL = -1;  /* BitRate */
static int hf_x2ap_e_RAB_GuaranteedBitrateUL = -1;  /* BitRate */
static int hf_x2ap_eNB_ID = -1;                   /* ENB_ID */
static int hf_x2ap_gNB_ID = -1;                   /* GNB_ID */
static int hf_x2ap_gNB = -1;                      /* GlobalGNB_ID */
static int hf_x2ap_choice_extension = -1;         /* ProtocolIE_Single_Container */
static int hf_x2ap_GTPTLAs_item = -1;             /* GTPTLA_Item */
static int hf_x2ap_gTPTransportLayerAddresses = -1;  /* TransportLayerAddress */
static int hf_x2ap_transportLayerAddress = -1;    /* TransportLayerAddress */
static int hf_x2ap_gTP_TEID = -1;                 /* GTP_TEI */
static int hf_x2ap_GUGroupIDList_item = -1;       /* GU_Group_ID */
static int hf_x2ap_mME_Group_ID = -1;             /* MME_Group_ID */
static int hf_x2ap_gU_Group_ID = -1;              /* GU_Group_ID */
static int hf_x2ap_mME_Code = -1;                 /* MME_Code */
static int hf_x2ap_gNB_ID_01 = -1;                /* BIT_STRING_SIZE_22_32 */
static int hf_x2ap_servingPLMN = -1;              /* PLMN_Identity */
static int hf_x2ap_equivalentPLMNs = -1;          /* EPLMNs */
static int hf_x2ap_forbiddenTAs = -1;             /* ForbiddenTAs */
static int hf_x2ap_forbiddenLAs = -1;             /* ForbiddenLAs */
static int hf_x2ap_forbiddenInterRATs = -1;       /* ForbiddenInterRATs */
static int hf_x2ap_dLHWLoadIndicator = -1;        /* LoadIndicator */
static int hf_x2ap_uLHWLoadIndicator = -1;        /* LoadIndicator */
static int hf_x2ap_e_UTRAN_Cell = -1;             /* LastVisitedEUTRANCellInformation */
static int hf_x2ap_uTRAN_Cell = -1;               /* LastVisitedUTRANCellInformation */
static int hf_x2ap_gERAN_Cell = -1;               /* LastVisitedGERANCellInformation */
static int hf_x2ap_nG_RAN_Cell = -1;              /* LastVisitedNGRANCellInformation */
static int hf_x2ap_global_Cell_ID = -1;           /* ECGI */
static int hf_x2ap_cellType = -1;                 /* CellType */
static int hf_x2ap_time_UE_StayedInCell = -1;     /* Time_UE_StayedInCell */
static int hf_x2ap_undefined = -1;                /* NULL */
static int hf_x2ap_pSCell_id = -1;                /* NRCGI */
static int hf_x2ap_eventType = -1;                /* EventType */
static int hf_x2ap_reportArea = -1;               /* ReportArea */
static int hf_x2ap_reportInterval = -1;           /* ReportIntervalMDT */
static int hf_x2ap_reportAmount = -1;             /* ReportAmountMDT */
static int hf_x2ap_measurementThreshold = -1;     /* MeasurementThresholdA2 */
static int hf_x2ap_m3period = -1;                 /* M3period */
static int hf_x2ap_m4period = -1;                 /* M4period */
static int hf_x2ap_m4_links_to_log = -1;          /* Links_to_log */
static int hf_x2ap_m5period = -1;                 /* M5period */
static int hf_x2ap_m5_links_to_log = -1;          /* Links_to_log */
static int hf_x2ap_m6report_interval = -1;        /* M6report_interval */
static int hf_x2ap_m6delay_threshold = -1;        /* M6delay_threshold */
static int hf_x2ap_m6_links_to_log = -1;          /* Links_to_log */
static int hf_x2ap_m7period = -1;                 /* M7period */
static int hf_x2ap_m7_links_to_log = -1;          /* Links_to_log */
static int hf_x2ap_mdt_Activation = -1;           /* MDT_Activation */
static int hf_x2ap_areaScopeOfMDT = -1;           /* AreaScopeOfMDT */
static int hf_x2ap_measurementsToActivate = -1;   /* MeasurementsToActivate */
static int hf_x2ap_m1reportingTrigger = -1;       /* M1ReportingTrigger */
static int hf_x2ap_m1thresholdeventA2 = -1;       /* M1ThresholdEventA2 */
static int hf_x2ap_m1periodicReporting = -1;      /* M1PeriodicReporting */
static int hf_x2ap_MDTPLMNList_item = -1;         /* PLMN_Identity */
static int hf_x2ap_threshold_RSRP = -1;           /* Threshold_RSRP */
static int hf_x2ap_threshold_RSRQ = -1;           /* Threshold_RSRQ */
static int hf_x2ap_eUTRA_Cell_ID = -1;            /* ECGI */
static int hf_x2ap_uLCoordinationInformation = -1;  /* BIT_STRING_SIZE_6_4400_ */
static int hf_x2ap_dLCoordinationInformation = -1;  /* BIT_STRING_SIZE_6_4400_ */
static int hf_x2ap_MBMS_Service_Area_Identity_List_item = -1;  /* MBMS_Service_Area_Identity */
static int hf_x2ap_MBSFN_Subframe_Infolist_item = -1;  /* MBSFN_Subframe_Info */
static int hf_x2ap_radioframeAllocationPeriod = -1;  /* RadioframeAllocationPeriod */
static int hf_x2ap_radioframeAllocationOffset = -1;  /* RadioframeAllocationOffset */
static int hf_x2ap_subframeAllocation = -1;       /* SubframeAllocation */
static int hf_x2ap_handoverTriggerChangeLowerLimit = -1;  /* INTEGER_M20_20 */
static int hf_x2ap_handoverTriggerChangeUpperLimit = -1;  /* INTEGER_M20_20 */
static int hf_x2ap_handoverTriggerChange = -1;    /* INTEGER_M20_20 */
static int hf_x2ap_MultibandInfoList_item = -1;   /* BandInfo */
static int hf_x2ap_maximumCellListSize = -1;      /* MaximumCellListSize */
static int hf_x2ap_freqBandIndicator = -1;        /* FreqBandIndicator */
static int hf_x2ap_rrcContainer_01 = -1;          /* T_rrcContainer */
static int hf_x2ap_srbType = -1;                  /* SRBType */
static int hf_x2ap_deliveryStatus = -1;           /* DeliveryStatus */
static int hf_x2ap_Neighbour_Information_item = -1;  /* Neighbour_Information_item */
static int hf_x2ap_pCI = -1;                      /* PCI */
static int hf_x2ap_eARFCN = -1;                   /* EARFCN */
static int hf_x2ap_capacityValue_01 = -1;         /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaCapacityValue_List = -1;  /* SSBAreaCapacityValue_List */
static int hf_x2ap_NRCarrierList_item = -1;       /* NRCarrierItem */
static int hf_x2ap_carrierSCS = -1;               /* NRSCS */
static int hf_x2ap_offsetToCarrier = -1;          /* INTEGER_0_2199_ */
static int hf_x2ap_carrierBandwidth = -1;         /* INTEGER_0_maxnoofNRPhysicalResourceBlocks_ */
static int hf_x2ap_compositeAvailableCapacityDL = -1;  /* NRCompositeAvailableCapacity */
static int hf_x2ap_compositeAvailableCapacityUL = -1;  /* NRCompositeAvailableCapacity */
static int hf_x2ap_cellCapacityClassValue_01 = -1;  /* NRCellCapacityClassValue */
static int hf_x2ap_capacityValue_02 = -1;         /* NRCapacityValue */
static int hf_x2ap_nRARFCN = -1;                  /* INTEGER_0_3279165 */
static int hf_x2ap_freqBandListNr = -1;           /* SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem */
static int hf_x2ap_freqBandListNr_item = -1;      /* FreqBandNrItem */
static int hf_x2ap_sULInformation = -1;           /* SULInformation */
static int hf_x2ap_nRcellIdentifier = -1;         /* NRCellIdentifier */
static int hf_x2ap_NRNeighbour_Information_item = -1;  /* NRNeighbour_Information_item */
static int hf_x2ap_nrpCI = -1;                    /* NRPCI */
static int hf_x2ap_nrCellID = -1;                 /* NRCGI */
static int hf_x2ap_configured_TAC = -1;           /* TAC */
static int hf_x2ap_measurementTimingConfiguration = -1;  /* T_measurementTimingConfiguration */
static int hf_x2ap_nRNeighbourModeInfo = -1;      /* T_nRNeighbourModeInfo */
static int hf_x2ap_fdd_01 = -1;                   /* FDD_InfoNeighbourServedNRCell_Information */
static int hf_x2ap_tdd_01 = -1;                   /* TDD_InfoNeighbourServedNRCell_Information */
static int hf_x2ap_fdd_or_tdd = -1;               /* T_fdd_or_tdd */
static int hf_x2ap_fdd_02 = -1;                   /* NPRACHConfiguration_FDD */
static int hf_x2ap_tdd_02 = -1;                   /* NPRACHConfiguration_TDD */
static int hf_x2ap_nprach_CP_length = -1;         /* NPRACH_CP_Length */
static int hf_x2ap_anchorCarrier_NPRACHConfig = -1;  /* T_anchorCarrier_NPRACHConfig */
static int hf_x2ap_anchorCarrier_EDT_NPRACHConfig = -1;  /* T_anchorCarrier_EDT_NPRACHConfig */
static int hf_x2ap_anchorCarrier_Format2_NPRACHConfig = -1;  /* T_anchorCarrier_Format2_NPRACHConfig */
static int hf_x2ap_anchorCarrier_Format2_EDT_NPRACHConfig = -1;  /* T_anchorCarrier_Format2_EDT_NPRACHConfig */
static int hf_x2ap_non_anchorCarrier_NPRACHConfig = -1;  /* T_non_anchorCarrier_NPRACHConfig */
static int hf_x2ap_non_anchorCarrier_Format2_NPRACHConfig = -1;  /* T_non_anchorCarrier_Format2_NPRACHConfig */
static int hf_x2ap_nprach_preambleFormat = -1;    /* NPRACH_preambleFormat */
static int hf_x2ap_anchorCarrier_NPRACHConfigTDD = -1;  /* T_anchorCarrier_NPRACHConfigTDD */
static int hf_x2ap_non_anchorCarrierFequencyConfiglist = -1;  /* Non_AnchorCarrierFrequencylist */
static int hf_x2ap_non_anchorCarrier_NPRACHConfigTDD = -1;  /* T_non_anchorCarrier_NPRACHConfigTDD */
static int hf_x2ap_Non_AnchorCarrierFrequencylist_item = -1;  /* Non_AnchorCarrierFrequencylist_item */
static int hf_x2ap_non_anchorCarrioerFrquency = -1;  /* Non_anchorCarrierFrequency */
static int hf_x2ap_ssbAreaRadioResourceStatus_List = -1;  /* SSBAreaRadioResourceStatus_List */
static int hf_x2ap_nRSCS = -1;                    /* NRSCS */
static int hf_x2ap_nRNRB = -1;                    /* NRNRB */
static int hf_x2ap_uENRMeasurements = -1;         /* T_uENRMeasurements */
static int hf_x2ap_uESidelinkAggregateMaximumBitRate = -1;  /* BitRate */
static int hf_x2ap_nRencryptionAlgorithms = -1;   /* NRencryptionAlgorithms */
static int hf_x2ap_nRintegrityProtectionAlgorithms = -1;  /* NRintegrityProtectionAlgorithms */
static int hf_x2ap_vehicleUE = -1;                /* VehicleUE */
static int hf_x2ap_pedestrianUE = -1;             /* PedestrianUE */
static int hf_x2ap_pc5QoSFlowList = -1;           /* PC5QoSFlowList */
static int hf_x2ap_pc5LinkAggregatedBitRates = -1;  /* BitRate */
static int hf_x2ap_PC5QoSFlowList_item = -1;      /* PC5QoSFlowItem */
static int hf_x2ap_pQI = -1;                      /* FiveQI */
static int hf_x2ap_pc5FlowBitRates = -1;          /* PC5FlowBitRates */
static int hf_x2ap_range = -1;                    /* Range */
static int hf_x2ap_guaranteedFlowBitRate = -1;    /* BitRate */
static int hf_x2ap_maximumFlowBitRate = -1;       /* BitRate */
static int hf_x2ap_rootSequenceIndex = -1;        /* INTEGER_0_837 */
static int hf_x2ap_zeroCorrelationIndex = -1;     /* INTEGER_0_15 */
static int hf_x2ap_highSpeedFlag = -1;            /* BOOLEAN */
static int hf_x2ap_prach_FreqOffset = -1;         /* INTEGER_0_94 */
static int hf_x2ap_prach_ConfigIndex = -1;        /* INTEGER_0_63 */
static int hf_x2ap_plmnListforQMC = -1;           /* PLMNListforQMC */
static int hf_x2ap_PLMNListforQMC_item = -1;      /* PLMN_Identity */
static int hf_x2ap_proSeDirectDiscovery = -1;     /* ProSeDirectDiscovery */
static int hf_x2ap_proSeDirectCommunication = -1;  /* ProSeDirectCommunication */
static int hf_x2ap_protectedResourceList = -1;    /* ProtectedResourceList */
static int hf_x2ap_mBSFNControlRegionLength = -1;  /* T_mBSFNControlRegionLength */
static int hf_x2ap_pDCCHRegionLength = -1;        /* T_pDCCHRegionLength */
static int hf_x2ap_protectedFootprintTimePeriodicity = -1;  /* INTEGER_1_320_ */
static int hf_x2ap_protectedFootprintStartTime = -1;  /* INTEGER_1_20_ */
static int hf_x2ap_ProtectedResourceList_item = -1;  /* ProtectedResourceList_Item */
static int hf_x2ap_resourceType = -1;             /* ResourceType */
static int hf_x2ap_intraPRBProtectedResourceFootprint = -1;  /* BIT_STRING_SIZE_84_ */
static int hf_x2ap_protectedFootprintFrequencyPattern = -1;  /* BIT_STRING_SIZE_6_110_ */
static int hf_x2ap_protectedFootprintTimePattern = -1;  /* ProtectedFootprintTimePattern */
static int hf_x2ap_dscp = -1;                     /* BIT_STRING_SIZE_6 */
static int hf_x2ap_flow_label = -1;               /* BIT_STRING_SIZE_20 */
static int hf_x2ap_dL_GBR_PRB_usage = -1;         /* DL_GBR_PRB_usage */
static int hf_x2ap_uL_GBR_PRB_usage = -1;         /* UL_GBR_PRB_usage */
static int hf_x2ap_dL_non_GBR_PRB_usage = -1;     /* DL_non_GBR_PRB_usage */
static int hf_x2ap_uL_non_GBR_PRB_usage = -1;     /* UL_non_GBR_PRB_usage */
static int hf_x2ap_dL_Total_PRB_usage = -1;       /* DL_Total_PRB_usage */
static int hf_x2ap_uL_Total_PRB_usage = -1;       /* UL_Total_PRB_usage */
static int hf_x2ap_rNTP_PerPRB = -1;              /* BIT_STRING_SIZE_6_110_ */
static int hf_x2ap_rNTP_Threshold = -1;           /* RNTP_Threshold */
static int hf_x2ap_numberOfCellSpecificAntennaPorts_02 = -1;  /* T_numberOfCellSpecificAntennaPorts_02 */
static int hf_x2ap_p_B = -1;                      /* INTEGER_0_3_ */
static int hf_x2ap_pDCCH_InterferenceImpact = -1;  /* INTEGER_0_4_ */
static int hf_x2ap_ReplacingCellsList_item = -1;  /* ReplacingCellsList_Item */
static int hf_x2ap_subframeType = -1;             /* SubframeType */
static int hf_x2ap_reservedSubframePattern_01 = -1;  /* BIT_STRING_SIZE_10_160 */
static int hf_x2ap_mBSFNControlRegionLength_01 = -1;  /* T_mBSFNControlRegionLength_01 */
static int hf_x2ap_non_truncated = -1;            /* BIT_STRING_SIZE_40 */
static int hf_x2ap_truncated = -1;                /* BIT_STRING_SIZE_24 */
static int hf_x2ap_reestablishment_Indication = -1;  /* Reestablishment_Indication */
static int hf_x2ap_RSRPMeasurementResult_item = -1;  /* RSRPMeasurementResult_item */
static int hf_x2ap_rSRPCellID = -1;               /* ECGI */
static int hf_x2ap_rSRPMeasured = -1;             /* INTEGER_0_97_ */
static int hf_x2ap_RSRPMRList_item = -1;          /* RSRPMRList_item */
static int hf_x2ap_rSRPMeasurementResult = -1;    /* RSRPMeasurementResult */
static int hf_x2ap_dLS1TNLLoadIndicator = -1;     /* LoadIndicator */
static int hf_x2ap_uLS1TNLLoadIndicator = -1;     /* LoadIndicator */
static int hf_x2ap_SecondaryRATUsageReportList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_secondaryRATType = -1;         /* T_secondaryRATType */
static int hf_x2ap_e_RABUsageReportList = -1;     /* E_RABUsageReportList */
static int hf_x2ap_ServedCells_item = -1;         /* ServedCells_item */
static int hf_x2ap_servedCellInfo = -1;           /* ServedCell_Information */
static int hf_x2ap_neighbour_Info = -1;           /* Neighbour_Information */
static int hf_x2ap_cellId = -1;                   /* ECGI */
static int hf_x2ap_tAC = -1;                      /* TAC */
static int hf_x2ap_eUTRA_Mode_Info = -1;          /* EUTRA_Mode_Info */
static int hf_x2ap_nR_CGI = -1;                   /* NRCGI */
static int hf_x2ap_uLOnlySharing = -1;            /* ULOnlySharing */
static int hf_x2ap_uLandDLSharing = -1;           /* ULandDLSharing */
static int hf_x2ap_specialSubframePatterns = -1;  /* SpecialSubframePatterns */
static int hf_x2ap_subbandCQICodeword0 = -1;      /* SubbandCQICodeword0 */
static int hf_x2ap_subbandCQICodeword1 = -1;      /* SubbandCQICodeword1 */
static int hf_x2ap_periodicCommunicationIndicator = -1;  /* T_periodicCommunicationIndicator */
static int hf_x2ap_periodicTime = -1;             /* INTEGER_1_3600_ */
static int hf_x2ap_scheduledCommunicationTime = -1;  /* ScheduledCommunicationTime */
static int hf_x2ap_stationaryIndication = -1;     /* T_stationaryIndication */
static int hf_x2ap_trafficProfile = -1;           /* T_trafficProfile */
static int hf_x2ap_batteryIndication = -1;        /* T_batteryIndication */
static int hf_x2ap_dayofWeek = -1;                /* BIT_STRING_SIZE_7 */
static int hf_x2ap_timeofDayStart = -1;           /* INTEGER_0_86399_ */
static int hf_x2ap_timeofDayEnd = -1;             /* INTEGER_0_86399_ */
static int hf_x2ap_SSBAreaCapacityValue_List_item = -1;  /* SSBAreaCapacityValue_Item */
static int hf_x2ap_ssbIndex = -1;                 /* SSBIndex */
static int hf_x2ap_ssbAreaCapacityValue = -1;     /* INTEGER_0_100 */
static int hf_x2ap_SSBAreaRadioResourceStatus_List_item = -1;  /* SSBAreaRadioResourceStatus_Item */
static int hf_x2ap_ssbAreaDLGBRPRBUsage = -1;     /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaULGBRPRBUsage = -1;     /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaDLNonGBRPRBUsage = -1;  /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaULNonGBRPRBUsage = -1;  /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaDLTotalPRBUsage = -1;   /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaULTotalPRBUsage = -1;   /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaDLSchedulingPDCCHCCEUsage = -1;  /* INTEGER_0_100 */
static int hf_x2ap_ssbAreaULSchedulingPDCCHCCEUsage = -1;  /* INTEGER_0_100 */
static int hf_x2ap_shortBitmap = -1;              /* BIT_STRING_SIZE_4 */
static int hf_x2ap_mediumBitmap = -1;             /* BIT_STRING_SIZE_8 */
static int hf_x2ap_longBitmap = -1;               /* BIT_STRING_SIZE_64 */
static int hf_x2ap_four_bitCQI = -1;              /* INTEGER_0_15_ */
static int hf_x2ap_two_bitSubbandDifferentialCQI = -1;  /* INTEGER_0_3_ */
static int hf_x2ap_two_bitDifferentialCQI = -1;   /* INTEGER_0_3_ */
static int hf_x2ap_three_bitSpatialDifferentialCQI = -1;  /* INTEGER_0_7_ */
static int hf_x2ap_SubbandCQIList_item = -1;      /* SubbandCQIItem */
static int hf_x2ap_subbandCQI = -1;               /* SubbandCQI */
static int hf_x2ap_subbandIndex = -1;             /* INTEGER_0_27_ */
static int hf_x2ap_oneframe = -1;                 /* Oneframe */
static int hf_x2ap_fourframes = -1;               /* Fourframes */
static int hf_x2ap_sUL_ARFCN = -1;                /* INTEGER_0_3279165 */
static int hf_x2ap_sUL_TxBW = -1;                 /* NR_TxBW */
static int hf_x2ap_sFN_Time_Offset = -1;          /* BIT_STRING_SIZE_24 */
static int hf_x2ap_tAListforMDT = -1;             /* TAListforMDT */
static int hf_x2ap_tAIListforMDT = -1;            /* TAIListforMDT */
static int hf_x2ap_TAIListforMDT_item = -1;       /* TAI_Item */
static int hf_x2ap_TAListforMDT_item = -1;        /* TAC */
static int hf_x2ap_tAListforQMC = -1;             /* TAListforQMC */
static int hf_x2ap_TAListforQMC_item = -1;        /* TAC */
static int hf_x2ap_tAIListforQMC = -1;            /* TAIListforQMC */
static int hf_x2ap_TAIListforQMC_item = -1;       /* TAI_Item */
static int hf_x2ap_transmission_Bandwidth = -1;   /* Transmission_Bandwidth */
static int hf_x2ap_subframeAssignment = -1;       /* SubframeAssignment */
static int hf_x2ap_specialSubframe_Info = -1;     /* SpecialSubframe_Info */
static int hf_x2ap_nRFreqInfo = -1;               /* NRFreqInfo */
static int hf_x2ap_TNLA_To_Add_List_item = -1;    /* TNLA_To_Add_Item */
static int hf_x2ap_tNLAssociationTransportLayerAddress = -1;  /* CPTransportLayerInformation */
static int hf_x2ap_tNLAssociationUsage = -1;      /* TNLAssociationUsage */
static int hf_x2ap_TNLA_To_Update_List_item = -1;  /* TNLA_To_Update_Item */
static int hf_x2ap_TNLA_To_Remove_List_item = -1;  /* TNLA_To_Remove_Item */
static int hf_x2ap_TNLA_Setup_List_item = -1;     /* TNLA_Setup_Item */
static int hf_x2ap_TNLA_Failed_To_Setup_List_item = -1;  /* TNLA_Failed_To_Setup_Item */
static int hf_x2ap_dlTNLMaximumOfferedCapacity = -1;  /* INTEGER_1_16777216_ */
static int hf_x2ap_dlTNLAvailableCapacity = -1;   /* INTEGER_0_100_ */
static int hf_x2ap_ulTNLMaximumOfferedCapacity = -1;  /* INTEGER_1_16777216_ */
static int hf_x2ap_ulTNLAvailableCapacity = -1;   /* INTEGER_0_100_ */
static int hf_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_List_item = -1;  /* Transport_UP_Layer_Addresses_Info_To_Add_Item */
static int hf_x2ap_iP_SecTransportLayerAddress = -1;  /* TransportLayerAddress */
static int hf_x2ap_gTPTransportLayerAddressesToAdd = -1;  /* GTPTLAs */
static int hf_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_List_item = -1;  /* Transport_UP_Layer_Addresses_Info_To_Remove_Item */
static int hf_x2ap_gTPTransportLayerAddressesToRemove = -1;  /* GTPTLAs */
static int hf_x2ap_transport_UP_Layer_Addresses_Info_To_Add_List = -1;  /* Transport_UP_Layer_Addresses_Info_To_Add_List */
static int hf_x2ap_transport_UP_Layer_Addresses_Info_To_Remove_List = -1;  /* Transport_UP_Layer_Addresses_Info_To_Remove_List */
static int hf_x2ap_eUTRANTraceID = -1;            /* EUTRANTraceID */
static int hf_x2ap_interfacesToTrace = -1;        /* InterfacesToTrace */
static int hf_x2ap_traceDepth = -1;               /* TraceDepth */
static int hf_x2ap_traceCollectionEntityIPAddress = -1;  /* TraceCollectionEntityIPAddress */
static int hf_x2ap_portnumber = -1;               /* Port_Number */
static int hf_x2ap_uDP_Port_Number = -1;          /* Port_Number */
static int hf_x2ap_uEaggregateMaximumBitRateDownlink = -1;  /* BitRate */
static int hf_x2ap_uEaggregateMaximumBitRateUplink = -1;  /* BitRate */
static int hf_x2ap_containerForAppLayerMeasConfig = -1;  /* OCTET_STRING_SIZE_1_1000 */
static int hf_x2ap_areaScopeOfQMC = -1;           /* AreaScopeOfQMC */
static int hf_x2ap_UE_HistoryInformation_item = -1;  /* LastVisitedCell_Item */
static int hf_x2ap_encryptionAlgorithms = -1;     /* EncryptionAlgorithms */
static int hf_x2ap_integrityProtectionAlgorithms = -1;  /* IntegrityProtectionAlgorithms */
static int hf_x2ap_UEsToBeResetList_item = -1;    /* UEsToBeResetList_Item */
static int hf_x2ap_meNB_ID = -1;                  /* UE_X2AP_ID */
static int hf_x2ap_meNB_ID_ext = -1;              /* UE_X2AP_ID_Extension */
static int hf_x2ap_sgNB_ID = -1;                  /* SgNB_UE_X2AP_ID */
static int hf_x2ap_uLResourcesULandDLSharing = -1;  /* ULResourcesULandDLSharing */
static int hf_x2ap_dLResourcesULandDLSharing = -1;  /* DLResourcesULandDLSharing */
static int hf_x2ap_uL_PDCP = -1;                  /* UL_UE_Configuration */
static int hf_x2ap_UL_HighInterferenceIndicationInfo_item = -1;  /* UL_HighInterferenceIndicationInfo_Item */
static int hf_x2ap_target_Cell_ID = -1;           /* ECGI */
static int hf_x2ap_ul_interferenceindication = -1;  /* UL_HighInterferenceIndication */
static int hf_x2ap_UL_InterferenceOverloadIndication_item = -1;  /* UL_InterferenceOverloadIndication_Item */
static int hf_x2ap_uLResourceBitmapULOnlySharing = -1;  /* DataTrafficResources */
static int hf_x2ap_changed_01 = -1;               /* ULResourceBitmapULandDLSharing */
static int hf_x2ap_fdd_03 = -1;                   /* UsableABSInformationFDD */
static int hf_x2ap_tdd_03 = -1;                   /* UsableABSInformationTDD */
static int hf_x2ap_usable_abs_pattern_info = -1;  /* BIT_STRING_SIZE_40 */
static int hf_x2ap_usaable_abs_pattern_info = -1;  /* BIT_STRING_SIZE_1_70_ */
static int hf_x2ap_widebandCQICodeword0 = -1;     /* INTEGER_0_15_ */
static int hf_x2ap_widebandCQICodeword1 = -1;     /* WidebandCQICodeword1 */
static int hf_x2ap_wlanMeasConfig = -1;           /* WLANMeasConfig */
static int hf_x2ap_wlanMeasConfigNameList = -1;   /* WLANMeasConfigNameList */
static int hf_x2ap_wlan_rssi = -1;                /* T_wlan_rssi */
static int hf_x2ap_wlan_rtt = -1;                 /* T_wlan_rtt */
static int hf_x2ap_WLANMeasConfigNameList_item = -1;  /* WLANName */
static int hf_x2ap_wTID_Type1 = -1;               /* WTID_Type1 */
static int hf_x2ap_wTID_Type2 = -1;               /* WTID_Long_Type2 */
static int hf_x2ap_shortWTID = -1;                /* BIT_STRING_SIZE_24 */
static int hf_x2ap_protocolIEs = -1;              /* ProtocolIE_Container */
static int hf_x2ap_mME_UE_S1AP_ID = -1;           /* UE_S1AP_ID */
static int hf_x2ap_uESecurityCapabilities = -1;   /* UESecurityCapabilities */
static int hf_x2ap_aS_SecurityInformation = -1;   /* AS_SecurityInformation */
static int hf_x2ap_uEaggregateMaximumBitRate = -1;  /* UEAggregateMaximumBitRate */
static int hf_x2ap_subscriberProfileIDforRFP = -1;  /* SubscriberProfileIDforRFP */
static int hf_x2ap_e_RABs_ToBeSetup_List = -1;    /* E_RABs_ToBeSetup_List */
static int hf_x2ap_rRC_Context = -1;              /* RRC_Context */
static int hf_x2ap_handoverRestrictionList = -1;  /* HandoverRestrictionList */
static int hf_x2ap_locationReportingInformation = -1;  /* LocationReportingInformation */
static int hf_x2ap_E_RABs_ToBeSetup_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_e_RAB_Level_QoS_Parameters = -1;  /* E_RAB_Level_QoS_Parameters */
static int hf_x2ap_dL_Forwarding = -1;            /* DL_Forwarding */
static int hf_x2ap_uL_GTPtunnelEndpoint = -1;     /* GTPtunnelEndpoint */
static int hf_x2ap_source_GlobalSeNB_ID = -1;     /* GlobalENB_ID */
static int hf_x2ap_seNB_UE_X2AP_ID = -1;          /* UE_X2AP_ID */
static int hf_x2ap_seNB_UE_X2AP_ID_Extension = -1;  /* UE_X2AP_ID_Extension */
static int hf_x2ap_wTID = -1;                     /* WTID */
static int hf_x2ap_wT_UE_XwAP_ID = -1;            /* WT_UE_XwAP_ID */
static int hf_x2ap_source_GlobalSgNB_ID = -1;     /* GlobalGNB_ID */
static int hf_x2ap_sgNB_UE_X2AP_ID = -1;          /* SgNB_UE_X2AP_ID */
static int hf_x2ap_E_RABs_Admitted_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_uL_GTP_TunnelEndpoint = -1;    /* GTPtunnelEndpoint */
static int hf_x2ap_dL_GTP_TunnelEndpoint = -1;    /* GTPtunnelEndpoint */
static int hf_x2ap_first_dl_count = -1;           /* FirstDLCount */
static int hf_x2ap_dl_discarding = -1;            /* DLDiscarding */
static int hf_x2ap_e_RABsSubjectToEarlyStatusTransfer = -1;  /* E_RABsSubjectToEarlyStatusTransfer_List */
static int hf_x2ap_e_RABsSubjectToDLDiscarding_List = -1;  /* E_RABsSubjectToDLDiscarding_List */
static int hf_x2ap_E_RABs_SubjectToStatusTransfer_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_receiveStatusofULPDCPSDUs = -1;  /* ReceiveStatusofULPDCPSDUs */
static int hf_x2ap_uL_COUNTvalue = -1;            /* COUNTvalue */
static int hf_x2ap_dL_COUNTvalue = -1;            /* COUNTvalue */
static int hf_x2ap_CellInformation_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_cell_ID = -1;                  /* ECGI */
static int hf_x2ap_ul_InterferenceOverloadIndication = -1;  /* UL_InterferenceOverloadIndication */
static int hf_x2ap_ul_HighInterferenceIndicationInfo = -1;  /* UL_HighInterferenceIndicationInfo */
static int hf_x2ap_relativeNarrowbandTxPower = -1;  /* RelativeNarrowbandTxPower */
static int hf_x2ap_ServedCellsToModify_item = -1;  /* ServedCellsToModify_Item */
static int hf_x2ap_old_ecgi = -1;                 /* ECGI */
static int hf_x2ap_Old_ECGIs_item = -1;           /* ECGI */
static int hf_x2ap_CellToReport_List_item = -1;   /* ProtocolIE_Single_Container */
static int hf_x2ap_MeasurementInitiationResult_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_measurementFailureCause_List = -1;  /* MeasurementFailureCause_List */
static int hf_x2ap_MeasurementFailureCause_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_measurementFailedReportCharacteristics = -1;  /* T_measurementFailedReportCharacteristics */
static int hf_x2ap_CompleteFailureCauseInformation_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_CellMeasurementResult_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_hWLoadIndicator = -1;          /* HWLoadIndicator */
static int hf_x2ap_s1TNLLoadIndicator = -1;       /* S1TNLLoadIndicator */
static int hf_x2ap_radioResourceStatus = -1;      /* RadioResourceStatus */
static int hf_x2ap_privateIEs = -1;               /* PrivateIE_Container */
static int hf_x2ap_ServedCellsToActivate_item = -1;  /* ServedCellsToActivate_Item */
static int hf_x2ap_ecgi = -1;                     /* ECGI */
static int hf_x2ap_ActivatedCellList_item = -1;   /* ActivatedCellList_Item */
static int hf_x2ap_source_GlobalENB_ID = -1;      /* GlobalENB_ID */
static int hf_x2ap_target_GlobalENB_ID = -1;      /* GlobalENB_ID */
static int hf_x2ap_E_RABs_ToBeAdded_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer = -1;               /* E_RABs_ToBeAdded_Item_SCG_Bearer */
static int hf_x2ap_split_Bearer = -1;             /* E_RABs_ToBeAdded_Item_Split_Bearer */
static int hf_x2ap_s1_UL_GTPtunnelEndpoint = -1;  /* GTPtunnelEndpoint */
static int hf_x2ap_meNB_GTPtunnelEndpoint = -1;   /* GTPtunnelEndpoint */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_01 = -1;            /* E_RABs_Admitted_ToBeAdded_Item_SCG_Bearer */
static int hf_x2ap_split_Bearer_01 = -1;          /* E_RABs_Admitted_ToBeAdded_Item_Split_Bearer */
static int hf_x2ap_s1_DL_GTPtunnelEndpoint = -1;  /* GTPtunnelEndpoint */
static int hf_x2ap_dL_Forwarding_GTPtunnelEndpoint = -1;  /* GTPtunnelEndpoint */
static int hf_x2ap_uL_Forwarding_GTPtunnelEndpoint = -1;  /* GTPtunnelEndpoint */
static int hf_x2ap_seNB_GTPtunnelEndpoint = -1;   /* GTPtunnelEndpoint */
static int hf_x2ap_success = -1;                  /* ResponseInformationSeNBReconfComp_SuccessItem */
static int hf_x2ap_reject_by_MeNB = -1;           /* ResponseInformationSeNBReconfComp_RejectByMeNBItem */
static int hf_x2ap_meNBtoSeNBContainer = -1;      /* MeNBtoSeNBContainer */
static int hf_x2ap_uE_SecurityCapabilities = -1;  /* UESecurityCapabilities */
static int hf_x2ap_seNB_SecurityKey = -1;         /* SeNBSecurityKey */
static int hf_x2ap_seNBUEAggregateMaximumBitRate = -1;  /* UEAggregateMaximumBitRate */
static int hf_x2ap_e_RABs_ToBeAdded = -1;         /* E_RABs_ToBeAdded_List_ModReq */
static int hf_x2ap_e_RABs_ToBeModified = -1;      /* E_RABs_ToBeModified_List_ModReq */
static int hf_x2ap_e_RABs_ToBeReleased = -1;      /* E_RABs_ToBeReleased_List_ModReq */
static int hf_x2ap_E_RABs_ToBeAdded_List_ModReq_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_02 = -1;            /* E_RABs_ToBeAdded_ModReqItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_02 = -1;          /* E_RABs_ToBeAdded_ModReqItem_Split_Bearer */
static int hf_x2ap_E_RABs_ToBeModified_List_ModReq_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_03 = -1;            /* E_RABs_ToBeModified_ModReqItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_03 = -1;          /* E_RABs_ToBeModified_ModReqItem_Split_Bearer */
static int hf_x2ap_E_RABs_ToBeReleased_List_ModReq_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_04 = -1;            /* E_RABs_ToBeReleased_ModReqItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_04 = -1;          /* E_RABs_ToBeReleased_ModReqItem_Split_Bearer */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_05 = -1;            /* E_RABs_Admitted_ToBeAdded_ModAckItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_05 = -1;          /* E_RABs_Admitted_ToBeAdded_ModAckItem_Split_Bearer */
static int hf_x2ap_E_RABs_Admitted_ToBeModified_ModAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_06 = -1;            /* E_RABs_Admitted_ToBeModified_ModAckItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_06 = -1;          /* E_RABs_Admitted_ToBeModified_ModAckItem_Split_Bearer */
static int hf_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_07 = -1;            /* E_RABs_Admitted_ToBeReleased_ModAckItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_07 = -1;          /* E_RABs_Admitted_ToBeReleased_ModAckItem_Split_Bearer */
static int hf_x2ap_E_RABs_ToBeReleased_ModReqd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_E_RABs_ToBeReleased_List_RelReq_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_08 = -1;            /* E_RABs_ToBeReleased_RelReqItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_08 = -1;          /* E_RABs_ToBeReleased_RelReqItem_Split_Bearer */
static int hf_x2ap_E_RABs_ToBeReleased_List_RelConf_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_sCG_Bearer_09 = -1;            /* E_RABs_ToBeReleased_RelConfItem_SCG_Bearer */
static int hf_x2ap_split_Bearer_09 = -1;          /* E_RABs_ToBeReleased_RelConfItem_Split_Bearer */
static int hf_x2ap_E_RABs_SubjectToCounterCheck_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_uL_Count = -1;                 /* INTEGER_0_4294967295 */
static int hf_x2ap_dL_Count = -1;                 /* INTEGER_0_4294967295 */
static int hf_x2ap_e_RABs_ToBeSetup_ListRetrieve = -1;  /* E_RABs_ToBeSetup_ListRetrieve */
static int hf_x2ap_managBasedMDTallowed = -1;     /* ManagementBasedMDTallowed */
static int hf_x2ap_managBasedMDTPLMNList = -1;    /* MDTPLMNList */
static int hf_x2ap_E_RABs_ToBeSetup_ListRetrieve_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_bearerType = -1;               /* BearerType */
static int hf_x2ap_E_RABs_ToBeAdded_SgNBAddReqList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_drb_ID = -1;                   /* DRB_ID */
static int hf_x2ap_en_DC_ResourceConfiguration = -1;  /* EN_DC_ResourceConfiguration */
static int hf_x2ap_resource_configuration = -1;   /* T_resource_configuration */
static int hf_x2ap_sgNBPDCPpresent = -1;          /* E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent = -1;       /* E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPnotpresent */
static int hf_x2ap_full_E_RAB_Level_QoS_Parameters = -1;  /* E_RAB_Level_QoS_Parameters */
static int hf_x2ap_max_MCG_admit_E_RAB_Level_QoS_Parameters = -1;  /* GBR_QosInformation */
static int hf_x2ap_meNB_DL_GTP_TEIDatMCG = -1;    /* GTPtunnelEndpoint */
static int hf_x2ap_requested_SCG_E_RAB_Level_QoS_Parameters = -1;  /* E_RAB_Level_QoS_Parameters */
static int hf_x2ap_meNB_UL_GTP_TEIDatPDCP = -1;   /* GTPtunnelEndpoint */
static int hf_x2ap_secondary_meNB_UL_GTP_TEIDatPDCP = -1;  /* GTPtunnelEndpoint */
static int hf_x2ap_rlc_Mode = -1;                 /* RLCMode */
static int hf_x2ap_uL_Configuration = -1;         /* ULConfiguration */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_01 = -1;  /* T_resource_configuration_01 */
static int hf_x2ap_sgNBPDCPpresent_01 = -1;       /* E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_01 = -1;    /* E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPnotpresent */
static int hf_x2ap_sgNB_UL_GTP_TEIDatPDCP = -1;   /* GTPtunnelEndpoint */
static int hf_x2ap_mCG_E_RAB_Level_QoS_Parameters = -1;  /* E_RAB_Level_QoS_Parameters */
static int hf_x2ap_sgNB_DL_GTP_TEIDatSCG = -1;    /* GTPtunnelEndpoint */
static int hf_x2ap_secondary_sgNB_DL_GTP_TEIDatSCG = -1;  /* GTPtunnelEndpoint */
static int hf_x2ap_success_SgNBReconfComp = -1;   /* ResponseInformationSgNBReconfComp_SuccessItem */
static int hf_x2ap_reject_by_MeNB_SgNBReconfComp = -1;  /* ResponseInformationSgNBReconfComp_RejectByMeNBItem */
static int hf_x2ap_meNBtoSgNBContainer = -1;      /* MeNBtoSgNBContainer */
static int hf_x2ap_nRUE_SecurityCapabilities = -1;  /* NRUESecurityCapabilities */
static int hf_x2ap_sgNB_SecurityKey = -1;         /* SgNBSecurityKey */
static int hf_x2ap_sgNBUEAggregateMaximumBitRate = -1;  /* UEAggregateMaximumBitRate */
static int hf_x2ap_e_RABs_ToBeAdded_01 = -1;      /* E_RABs_ToBeAdded_SgNBModReq_List */
static int hf_x2ap_e_RABs_ToBeModified_01 = -1;   /* E_RABs_ToBeModified_SgNBModReq_List */
static int hf_x2ap_e_RABs_ToBeReleased_01 = -1;   /* E_RABs_ToBeReleased_SgNBModReq_List */
static int hf_x2ap_E_RABs_ToBeAdded_SgNBModReq_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_02 = -1;  /* T_resource_configuration_02 */
static int hf_x2ap_sgNBPDCPpresent_02 = -1;       /* E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_02 = -1;    /* E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPnotpresent */
static int hf_x2ap_max_MN_admit_E_RAB_Level_QoS_Parameters = -1;  /* GBR_QosInformation */
static int hf_x2ap_E_RABs_ToBeModified_SgNBModReq_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_03 = -1;  /* T_resource_configuration_03 */
static int hf_x2ap_sgNBPDCPpresent_03 = -1;       /* E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_03 = -1;    /* E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPnotpresent */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBModReq_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_04 = -1;  /* T_resource_configuration_04 */
static int hf_x2ap_sgNBPDCPpresent_04 = -1;       /* E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_04 = -1;    /* E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPnotpresent */
static int hf_x2ap_dL_GTPtunnelEndpoint = -1;     /* GTPtunnelEndpoint */
static int hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_05 = -1;  /* T_resource_configuration_05 */
static int hf_x2ap_sgNBPDCPpresent_05 = -1;       /* E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_05 = -1;    /* E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPnotpresent */
static int hf_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_06 = -1;  /* T_resource_configuration_06 */
static int hf_x2ap_sgNBPDCPpresent_06 = -1;       /* E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_06 = -1;    /* E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPnotpresent */
static int hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_07 = -1;  /* T_resource_configuration_07 */
static int hf_x2ap_sgNBPDCPpresent_07 = -1;       /* E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_07 = -1;    /* E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPnotpresent */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBModReqdList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_E_RABs_ToBeModified_SgNBModReqdList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_08 = -1;  /* T_resource_configuration_08 */
static int hf_x2ap_sgNBPDCPpresent_08 = -1;       /* E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_08 = -1;    /* E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPnotpresent */
static int hf_x2ap_requested_MCG_E_RAB_Level_QoS_Parameters = -1;  /* E_RAB_Level_QoS_Parameters */
static int hf_x2ap_s1_DL_GTP_TEIDatSgNB = -1;     /* GTPtunnelEndpoint */
static int hf_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_09 = -1;  /* T_resource_configuration_09 */
static int hf_x2ap_sgNBPDCPpresent_09 = -1;       /* E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_09 = -1;    /* E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPnotpresent */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_10 = -1;  /* T_resource_configuration_10 */
static int hf_x2ap_sgNBPDCPpresent_10 = -1;       /* E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_10 = -1;    /* E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPnotpresent */
static int hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_rlc_Mode_transferred = -1;     /* RLCMode */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBRelConfList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_11 = -1;  /* T_resource_configuration_11 */
static int hf_x2ap_sgNBPDCPpresent_11 = -1;       /* E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_11 = -1;    /* E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPnotpresent */
static int hf_x2ap_E_RABs_SubjectToSgNBCounterCheck_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_E_RABs_ToBeReleased_SgNBChaConfList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_resource_configuration_12 = -1;  /* T_resource_configuration_12 */
static int hf_x2ap_sgNBPDCPpresent_12 = -1;       /* E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPpresent */
static int hf_x2ap_sgNBPDCPnotpresent_12 = -1;    /* E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPnotpresent */
static int hf_x2ap_init_eNB = -1;                 /* ProtocolIE_Container */
static int hf_x2ap_init_en_gNB = -1;              /* ProtocolIE_Container */
static int hf_x2ap_ServedEUTRAcellsENDCX2ManagementList_item = -1;  /* ServedEUTRAcellsENDCX2ManagementList_item */
static int hf_x2ap_servedEUTRACellInfo = -1;      /* ServedCell_Information */
static int hf_x2ap_nrNeighbourInfo = -1;          /* NRNeighbour_Information */
static int hf_x2ap_ServedNRcellsENDCX2ManagementList_item = -1;  /* ServedNRcellsENDCX2ManagementList_item */
static int hf_x2ap_servedNRCellInfo = -1;         /* ServedNRCell_Information */
static int hf_x2ap_nRNeighbourInfo = -1;          /* NRNeighbour_Information */
static int hf_x2ap_nrModeInfo = -1;               /* T_nrModeInfo */
static int hf_x2ap_fdd_04 = -1;                   /* FDD_InfoServedNRCell_Information */
static int hf_x2ap_tdd_04 = -1;                   /* TDD_InfoServedNRCell_Information */
static int hf_x2ap_measurementTimingConfiguration_01 = -1;  /* T_measurementTimingConfiguration_01 */
static int hf_x2ap_ul_NR_TxBW = -1;               /* NR_TxBW */
static int hf_x2ap_dl_NR_TxBW = -1;               /* NR_TxBW */
static int hf_x2ap_nR_TxBW = -1;                  /* NR_TxBW */
static int hf_x2ap_cellAssistanceInformation = -1;  /* CellAssistanceInformation */
static int hf_x2ap_limited_list = -1;             /* Limited_list */
static int hf_x2ap_full_list = -1;                /* T_full_list */
static int hf_x2ap_Limited_list_item = -1;        /* Limited_list_item */
static int hf_x2ap_respond_eNB = -1;              /* ProtocolIE_Container */
static int hf_x2ap_respond_en_gNB = -1;           /* ProtocolIE_Container */
static int hf_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_item = -1;  /* ServedEUTRAcellsToModifyListENDCConfUpd_item */
static int hf_x2ap_old_ECGI = -1;                 /* ECGI */
static int hf_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd_item = -1;  /* ECGI */
static int hf_x2ap_ServedNRcellsToModifyENDCConfUpdList_item = -1;  /* ServedNRCellsToModify_Item */
static int hf_x2ap_old_nrcgi = -1;                /* NRCGI */
static int hf_x2ap_servedNRCellInformation = -1;  /* ServedNRCell_Information */
static int hf_x2ap_nrNeighbourInformation = -1;   /* NRNeighbour_Information */
static int hf_x2ap_nrDeactivationIndication = -1;  /* DeactivationIndication */
static int hf_x2ap_ServedNRcellsToDeleteENDCConfUpdList_item = -1;  /* NRCGI */
static int hf_x2ap_ServedNRCellsToActivate_item = -1;  /* ServedNRCellsToActivate_Item */
static int hf_x2ap_ActivatedNRCellList_item = -1;  /* ActivatedNRCellList_Item */
static int hf_x2ap_CellToReport_NR_ENDC_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_nr_cell_ID = -1;               /* NRCGI */
static int hf_x2ap_ssbToReport_List = -1;         /* SSBToReport_List */
static int hf_x2ap_CellToReport_E_UTRA_ENDC_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_e_utra_cell_ID = -1;           /* ECGI */
static int hf_x2ap_SSBToReport_List_item = -1;    /* SSBToReport_Item */
static int hf_x2ap_CellMeasurementResult_NR_ENDC_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_nr_radioResourceStatus = -1;   /* NRRadioResourceStatus */
static int hf_x2ap_tnlCapacityIndicator = -1;     /* TNLCapacityIndicator */
static int hf_x2ap_nr_compositeAvailableCapacityGroup = -1;  /* NRCompositeAvailableCapacityGroup */
static int hf_x2ap_numberofActiveUEs = -1;        /* INTEGER_0_16777215_ */
static int hf_x2ap_CellMeasurementResult_E_UTRA_ENDC_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_compositeAvailableCapacityGroup = -1;  /* CompositeAvailableCapacityGroup */
static int hf_x2ap_initiate_eNB = -1;             /* ProtocolIE_Container */
static int hf_x2ap_initiate_en_gNB = -1;          /* ProtocolIE_Container */
static int hf_x2ap_ListofEUTRACellsinEUTRACoordinationReq_item = -1;  /* ECGI */
static int hf_x2ap_ListofEUTRACellsinNRCoordinationReq_item = -1;  /* ECGI */
static int hf_x2ap_ListofNRCellsinNRCoordinationReq_item = -1;  /* NRCGI */
static int hf_x2ap_ListofEUTRACellsinEUTRACoordinationResp_item = -1;  /* ECGI */
static int hf_x2ap_ListofNRCellsinNRCoordinationResp_item = -1;  /* NRCGI */
static int hf_x2ap_E_RABs_DataForwardingAddress_List_item = -1;  /* ProtocolIE_Single_Container */
static int hf_x2ap_dl_GTPtunnelEndpoint = -1;     /* GTPtunnelEndpoint */
static int hf_x2ap_initiatingMessage = -1;        /* InitiatingMessage */
static int hf_x2ap_successfulOutcome = -1;        /* SuccessfulOutcome */
static int hf_x2ap_unsuccessfulOutcome = -1;      /* UnsuccessfulOutcome */
static int hf_x2ap_initiatingMessage_value = -1;  /* InitiatingMessage_value */
static int hf_x2ap_successfulOutcome_value = -1;  /* SuccessfulOutcome_value */
static int hf_x2ap_value = -1;                    /* UnsuccessfulOutcome_value */

/*--- End of included file: packet-x2ap-hf.c ---*/
#line 129 "./asn1/x2ap/packet-x2ap-template.c"

/* Initialize the subtree pointers */
static int ett_x2ap = -1;
static int ett_x2ap_TransportLayerAddress = -1;
static int ett_x2ap_PLMN_Identity = -1;
static int ett_x2ap_TargeteNBtoSource_eNBTransparentContainer = -1;
static int ett_x2ap_RRC_Context = -1;
static int ett_x2ap_UE_HistoryInformationFromTheUE = -1;
static int ett_x2ap_ReportCharacteristics = -1;
static int ett_x2ap_measurementFailedReportCharacteristics = -1;
static int ett_x2ap_UE_RLF_Report_Container = -1;
static int ett_x2ap_UE_RLF_Report_Container_for_extended_bands = -1;
static int ett_x2ap_MeNBtoSeNBContainer = -1;
static int ett_x2ap_SeNBtoMeNBContainer = -1;
static int ett_x2ap_EUTRANTraceID = -1;
static int ett_x2ap_InterfacesToTrace = -1;
static int ett_x2ap_TraceCollectionEntityIPAddress = -1;
static int ett_x2ap_EncryptionAlgorithms = -1;
static int ett_x2ap_IntegrityProtectionAlgorithms = -1;
static int ett_x2ap_MeasurementsToActivate = -1;
static int ett_x2ap_MDT_Location_Info = -1;
static int ett_x2ap_transmissionModes = -1;
static int ett_x2ap_X2AP_Message = -1;
static int ett_x2ap_MeNBtoSgNBContainer = -1;
static int ett_x2ap_SgNBtoMeNBContainer = -1;
static int ett_x2ap_RRCContainer = -1;
static int ett_x2ap_NRencryptionAlgorithms = -1;
static int ett_x2ap_NRintegrityProtectionAlgorithms = -1;
static int ett_x2ap_measurementTimingConfiguration = -1;
static int ett_x2ap_LastVisitedNGRANCellInformation = -1;
static int ett_x2ap_LastVisitedUTRANCellInformation = -1;
static int ett_x2ap_EndcSONConfigurationTransfer = -1;
static int ett_x2ap_EPCHandoverRestrictionListContainer = -1;
static int ett_x2ap_NBIoT_RLF_Report_Container = -1;
static int ett_x2ap_anchorCarrier_NPRACHConfig = -1;
static int ett_x2ap_anchorCarrier_EDT_NPRACHConfig = -1;
static int ett_x2ap_anchorCarrier_Format2_NPRACHConfig = -1;
static int ett_x2ap_anchorCarrier_Format2_EDT_NPRACHConfig = -1;
static int ett_x2ap_non_anchorCarrier_NPRACHConfig = -1;
static int ett_x2ap_non_anchorCarrier_Format2_NPRACHConfig = -1;
static int ett_x2ap_anchorCarrier_NPRACHConfigTDD = -1;
static int ett_x2ap_non_anchorCarrier_NPRACHConfigTDD = -1;
static int ett_x2ap_Non_anchorCarrierFrequency = -1;
static int ett_x2ap_ReportCharacteristics_ENDC = -1;
static int ett_x2ap_TargetCellInNGRAN = -1;
static int ett_x2ap_TDDULDLConfigurationCommonNR = -1;
static int ett_x2ap_MDT_ConfigurationNR = -1;
static int ett_x2ap_NRCellPRACHConfig = -1;
static int ett_x2ap_IntendedTDD_DL_ULConfiguration_NR = -1;
static int ett_x2ap_UERadioCapability = -1;

/*--- Included file: packet-x2ap-ett.c ---*/
#line 1 "./asn1/x2ap/packet-x2ap-ett.c"
static gint ett_x2ap_PrivateIE_ID = -1;
static gint ett_x2ap_ProtocolIE_Container = -1;
static gint ett_x2ap_ProtocolIE_Field = -1;
static gint ett_x2ap_ProtocolExtensionContainer = -1;
static gint ett_x2ap_ProtocolExtensionField = -1;
static gint ett_x2ap_PrivateIE_Container = -1;
static gint ett_x2ap_PrivateIE_Field = -1;
static gint ett_x2ap_ABSInformation = -1;
static gint ett_x2ap_ABSInformationFDD = -1;
static gint ett_x2ap_ABSInformationTDD = -1;
static gint ett_x2ap_ABS_Status = -1;
static gint ett_x2ap_AdditionalSpecialSubframe_Info = -1;
static gint ett_x2ap_AdditionalSpecialSubframeExtension_Info = -1;
static gint ett_x2ap_AllocationAndRetentionPriority = -1;
static gint ett_x2ap_AreaScopeOfMDT = -1;
static gint ett_x2ap_AreaScopeOfQMC = -1;
static gint ett_x2ap_AS_SecurityInformation = -1;
static gint ett_x2ap_AdditionalPLMNs_Item = -1;
static gint ett_x2ap_BroadcastPLMNs_Item = -1;
static gint ett_x2ap_BluetoothMeasurementConfiguration = -1;
static gint ett_x2ap_BluetoothMeasConfigNameList = -1;
static gint ett_x2ap_BPLMN_ID_Info_EUTRA = -1;
static gint ett_x2ap_BPLMN_ID_Info_EUTRA_Item = -1;
static gint ett_x2ap_BPLMN_ID_Info_NR = -1;
static gint ett_x2ap_BPLMN_ID_Info_NR_Item = -1;
static gint ett_x2ap_BroadcastextPLMNs = -1;
static gint ett_x2ap_Cause = -1;
static gint ett_x2ap_CellBasedMDT = -1;
static gint ett_x2ap_CellBasedQMC = -1;
static gint ett_x2ap_CellIdListforMDT = -1;
static gint ett_x2ap_CellIdListforQMC = -1;
static gint ett_x2ap_CellReplacingInfo = -1;
static gint ett_x2ap_CellType = -1;
static gint ett_x2ap_CNTypeRestrictions = -1;
static gint ett_x2ap_CNTypeRestrictionsItem = -1;
static gint ett_x2ap_CoMPHypothesisSet = -1;
static gint ett_x2ap_CoMPHypothesisSetItem = -1;
static gint ett_x2ap_CoMPInformation = -1;
static gint ett_x2ap_CoMPInformationItem = -1;
static gint ett_x2ap_CoMPInformationItem_item = -1;
static gint ett_x2ap_CoMPInformationStartTime = -1;
static gint ett_x2ap_CoMPInformationStartTime_item = -1;
static gint ett_x2ap_CompositeAvailableCapacity = -1;
static gint ett_x2ap_CompositeAvailableCapacityGroup = -1;
static gint ett_x2ap_COUNTvalue = -1;
static gint ett_x2ap_COUNTValueExtended = -1;
static gint ett_x2ap_COUNTvaluePDCP_SNlength18 = -1;
static gint ett_x2ap_CoverageModificationList = -1;
static gint ett_x2ap_CoverageModification_Item = -1;
static gint ett_x2ap_CPTransportLayerInformation = -1;
static gint ett_x2ap_CriticalityDiagnostics = -1;
static gint ett_x2ap_CriticalityDiagnostics_IE_List = -1;
static gint ett_x2ap_CriticalityDiagnostics_IE_List_item = -1;
static gint ett_x2ap_CSIReportList = -1;
static gint ett_x2ap_CSIReportList_item = -1;
static gint ett_x2ap_CSIReportPerCSIProcess = -1;
static gint ett_x2ap_CSIReportPerCSIProcess_item = -1;
static gint ett_x2ap_CSIReportPerCSIProcessItem = -1;
static gint ett_x2ap_CSIReportPerCSIProcessItem_item = -1;
static gint ett_x2ap_CHOinformation_REQ = -1;
static gint ett_x2ap_CHOinformation_ACK = -1;
static gint ett_x2ap_CandidateCellsToBeCancelledList = -1;
static gint ett_x2ap_DataTrafficResourceIndication = -1;
static gint ett_x2ap_DAPSRequestInfo = -1;
static gint ett_x2ap_DAPSResponseInfo = -1;
static gint ett_x2ap_DeliveryStatus = -1;
static gint ett_x2ap_DLResourcesULandDLSharing = -1;
static gint ett_x2ap_DynamicDLTransmissionInformation = -1;
static gint ett_x2ap_DynamicNAICSInformation = -1;
static gint ett_x2ap_SEQUENCE_SIZE_0_maxnoofPA_OF_PA_Values = -1;
static gint ett_x2ap_ECGI = -1;
static gint ett_x2ap_EnhancedRNTP = -1;
static gint ett_x2ap_EnhancedRNTPStartTime = -1;
static gint ett_x2ap_ENB_ID = -1;
static gint ett_x2ap_EN_DC_ResourceConfiguration = -1;
static gint ett_x2ap_EPLMNs = -1;
static gint ett_x2ap_ERABActivityNotifyItemList = -1;
static gint ett_x2ap_ERABActivityNotifyItem = -1;
static gint ett_x2ap_E_RAB_Level_QoS_Parameters = -1;
static gint ett_x2ap_E_RAB_List = -1;
static gint ett_x2ap_E_RAB_Item = -1;
static gint ett_x2ap_E_RABsSubjectToEarlyStatusTransfer_List = -1;
static gint ett_x2ap_E_RABsSubjectToEarlyStatusTransfer_Item = -1;
static gint ett_x2ap_E_RABsSubjectToDLDiscarding_List = -1;
static gint ett_x2ap_E_RABsSubjectToDLDiscarding_Item = -1;
static gint ett_x2ap_E_RABUsageReportList = -1;
static gint ett_x2ap_E_RABUsageReport_Item = -1;
static gint ett_x2ap_EUTRA_Mode_Info = -1;
static gint ett_x2ap_ExpectedUEBehaviour = -1;
static gint ett_x2ap_ExpectedUEActivityBehaviour = -1;
static gint ett_x2ap_ExtendedULInterferenceOverloadInfo = -1;
static gint ett_x2ap_FastMCGRecovery = -1;
static gint ett_x2ap_FDD_Info = -1;
static gint ett_x2ap_FDD_InfoNeighbourServedNRCell_Information = -1;
static gint ett_x2ap_ForbiddenTAs = -1;
static gint ett_x2ap_ForbiddenTAs_Item = -1;
static gint ett_x2ap_ForbiddenTACs = -1;
static gint ett_x2ap_ForbiddenLAs = -1;
static gint ett_x2ap_ForbiddenLAs_Item = -1;
static gint ett_x2ap_ForbiddenLACs = -1;
static gint ett_x2ap_FreqBandNrItem = -1;
static gint ett_x2ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem = -1;
static gint ett_x2ap_GBR_QosInformation = -1;
static gint ett_x2ap_GlobalENB_ID = -1;
static gint ett_x2ap_GlobalGNB_ID = -1;
static gint ett_x2ap_Global_RAN_NODE_ID = -1;
static gint ett_x2ap_GTPTLAs = -1;
static gint ett_x2ap_GTPTLA_Item = -1;
static gint ett_x2ap_GTPtunnelEndpoint = -1;
static gint ett_x2ap_GUGroupIDList = -1;
static gint ett_x2ap_GU_Group_ID = -1;
static gint ett_x2ap_GUMMEI = -1;
static gint ett_x2ap_GNB_ID = -1;
static gint ett_x2ap_HandoverRestrictionList = -1;
static gint ett_x2ap_HWLoadIndicator = -1;
static gint ett_x2ap_LastVisitedCell_Item = -1;
static gint ett_x2ap_LastVisitedEUTRANCellInformation = -1;
static gint ett_x2ap_LastVisitedGERANCellInformation = -1;
static gint ett_x2ap_LocationInformationSgNB = -1;
static gint ett_x2ap_LocationReportingInformation = -1;
static gint ett_x2ap_M1PeriodicReporting = -1;
static gint ett_x2ap_M1ThresholdEventA2 = -1;
static gint ett_x2ap_M3Configuration = -1;
static gint ett_x2ap_M4Configuration = -1;
static gint ett_x2ap_M5Configuration = -1;
static gint ett_x2ap_M6Configuration = -1;
static gint ett_x2ap_M7Configuration = -1;
static gint ett_x2ap_MDT_Configuration = -1;
static gint ett_x2ap_MDTPLMNList = -1;
static gint ett_x2ap_MeasurementThresholdA2 = -1;
static gint ett_x2ap_MeNBResourceCoordinationInformation = -1;
static gint ett_x2ap_MBMS_Service_Area_Identity_List = -1;
static gint ett_x2ap_MBSFN_Subframe_Infolist = -1;
static gint ett_x2ap_MBSFN_Subframe_Info = -1;
static gint ett_x2ap_MobilityParametersModificationRange = -1;
static gint ett_x2ap_MobilityParametersInformation = -1;
static gint ett_x2ap_MultibandInfoList = -1;
static gint ett_x2ap_MessageOversizeNotification = -1;
static gint ett_x2ap_BandInfo = -1;
static gint ett_x2ap_SplitSRB = -1;
static gint ett_x2ap_Neighbour_Information = -1;
static gint ett_x2ap_Neighbour_Information_item = -1;
static gint ett_x2ap_NRCapacityValue = -1;
static gint ett_x2ap_NRCarrierList = -1;
static gint ett_x2ap_NRCarrierItem = -1;
static gint ett_x2ap_NRCompositeAvailableCapacityGroup = -1;
static gint ett_x2ap_NRCompositeAvailableCapacity = -1;
static gint ett_x2ap_NRFreqInfo = -1;
static gint ett_x2ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem = -1;
static gint ett_x2ap_NRCGI = -1;
static gint ett_x2ap_NRNeighbour_Information = -1;
static gint ett_x2ap_NRNeighbour_Information_item = -1;
static gint ett_x2ap_T_nRNeighbourModeInfo = -1;
static gint ett_x2ap_NPRACHConfiguration = -1;
static gint ett_x2ap_T_fdd_or_tdd = -1;
static gint ett_x2ap_NPRACHConfiguration_FDD = -1;
static gint ett_x2ap_NPRACHConfiguration_TDD = -1;
static gint ett_x2ap_Non_AnchorCarrierFrequencylist = -1;
static gint ett_x2ap_Non_AnchorCarrierFrequencylist_item = -1;
static gint ett_x2ap_NRRadioResourceStatus = -1;
static gint ett_x2ap_NR_TxBW = -1;
static gint ett_x2ap_NRUeReport = -1;
static gint ett_x2ap_NRUESidelinkAggregateMaximumBitRate = -1;
static gint ett_x2ap_NRUESecurityCapabilities = -1;
static gint ett_x2ap_NRV2XServicesAuthorized = -1;
static gint ett_x2ap_PC5QoSParameters = -1;
static gint ett_x2ap_PC5QoSFlowList = -1;
static gint ett_x2ap_PC5QoSFlowItem = -1;
static gint ett_x2ap_PC5FlowBitRates = -1;
static gint ett_x2ap_PRACH_Configuration = -1;
static gint ett_x2ap_PLMNAreaBasedQMC = -1;
static gint ett_x2ap_PLMNListforQMC = -1;
static gint ett_x2ap_ProSeAuthorized = -1;
static gint ett_x2ap_ProtectedEUTRAResourceIndication = -1;
static gint ett_x2ap_ProtectedFootprintTimePattern = -1;
static gint ett_x2ap_ProtectedResourceList = -1;
static gint ett_x2ap_ProtectedResourceList_Item = -1;
static gint ett_x2ap_QoS_Mapping_Information = -1;
static gint ett_x2ap_RadioResourceStatus = -1;
static gint ett_x2ap_RelativeNarrowbandTxPower = -1;
static gint ett_x2ap_ReplacingCellsList = -1;
static gint ett_x2ap_ReplacingCellsList_Item = -1;
static gint ett_x2ap_ReservedSubframePattern = -1;
static gint ett_x2ap_ResumeID = -1;
static gint ett_x2ap_RLC_Status = -1;
static gint ett_x2ap_RSRPMeasurementResult = -1;
static gint ett_x2ap_RSRPMeasurementResult_item = -1;
static gint ett_x2ap_RSRPMRList = -1;
static gint ett_x2ap_RSRPMRList_item = -1;
static gint ett_x2ap_S1TNLLoadIndicator = -1;
static gint ett_x2ap_SecondaryRATUsageReportList = -1;
static gint ett_x2ap_SecondaryRATUsageReport_Item = -1;
static gint ett_x2ap_ServedCells = -1;
static gint ett_x2ap_ServedCells_item = -1;
static gint ett_x2ap_ServedCell_Information = -1;
static gint ett_x2ap_SgNBResourceCoordinationInformation = -1;
static gint ett_x2ap_SharedResourceType = -1;
static gint ett_x2ap_SpecialSubframe_Info = -1;
static gint ett_x2ap_SubbandCQI = -1;
static gint ett_x2ap_Subscription_Based_UE_DifferentiationInfo = -1;
static gint ett_x2ap_ScheduledCommunicationTime = -1;
static gint ett_x2ap_SSBAreaCapacityValue_List = -1;
static gint ett_x2ap_SSBAreaCapacityValue_Item = -1;
static gint ett_x2ap_SSBAreaRadioResourceStatus_List = -1;
static gint ett_x2ap_SSBAreaRadioResourceStatus_Item = -1;
static gint ett_x2ap_SSB_PositionsInBurst = -1;
static gint ett_x2ap_SubbandCQICodeword0 = -1;
static gint ett_x2ap_SubbandCQICodeword1 = -1;
static gint ett_x2ap_SubbandCQIList = -1;
static gint ett_x2ap_SubbandCQIItem = -1;
static gint ett_x2ap_SubframeAllocation = -1;
static gint ett_x2ap_SULInformation = -1;
static gint ett_x2ap_SupportedSULFreqBandItem = -1;
static gint ett_x2ap_SFN_Offset = -1;
static gint ett_x2ap_TABasedMDT = -1;
static gint ett_x2ap_TAIBasedMDT = -1;
static gint ett_x2ap_TAIListforMDT = -1;
static gint ett_x2ap_TAI_Item = -1;
static gint ett_x2ap_TAListforMDT = -1;
static gint ett_x2ap_TABasedQMC = -1;
static gint ett_x2ap_TAListforQMC = -1;
static gint ett_x2ap_TAIBasedQMC = -1;
static gint ett_x2ap_TAIListforQMC = -1;
static gint ett_x2ap_TDD_Info = -1;
static gint ett_x2ap_TDD_InfoNeighbourServedNRCell_Information = -1;
static gint ett_x2ap_TNLA_To_Add_List = -1;
static gint ett_x2ap_TNLA_To_Add_Item = -1;
static gint ett_x2ap_TNLA_To_Update_List = -1;
static gint ett_x2ap_TNLA_To_Update_Item = -1;
static gint ett_x2ap_TNLA_To_Remove_List = -1;
static gint ett_x2ap_TNLA_To_Remove_Item = -1;
static gint ett_x2ap_TNLA_Setup_List = -1;
static gint ett_x2ap_TNLA_Setup_Item = -1;
static gint ett_x2ap_TNLA_Failed_To_Setup_List = -1;
static gint ett_x2ap_TNLA_Failed_To_Setup_Item = -1;
static gint ett_x2ap_TNLCapacityIndicator = -1;
static gint ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_List = -1;
static gint ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_Item = -1;
static gint ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_List = -1;
static gint ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_Item = -1;
static gint ett_x2ap_TNLConfigurationInfo = -1;
static gint ett_x2ap_TraceActivation = -1;
static gint ett_x2ap_TransportLayerAddressAndPort = -1;
static gint ett_x2ap_TunnelInformation = -1;
static gint ett_x2ap_UEAggregateMaximumBitRate = -1;
static gint ett_x2ap_UEAppLayerMeasConfig = -1;
static gint ett_x2ap_UE_HistoryInformation = -1;
static gint ett_x2ap_UESecurityCapabilities = -1;
static gint ett_x2ap_UESidelinkAggregateMaximumBitRate = -1;
static gint ett_x2ap_UEsToBeResetList = -1;
static gint ett_x2ap_UEsToBeResetList_Item = -1;
static gint ett_x2ap_ULandDLSharing = -1;
static gint ett_x2ap_ULConfiguration = -1;
static gint ett_x2ap_UL_HighInterferenceIndicationInfo = -1;
static gint ett_x2ap_UL_HighInterferenceIndicationInfo_Item = -1;
static gint ett_x2ap_UL_InterferenceOverloadIndication = -1;
static gint ett_x2ap_ULOnlySharing = -1;
static gint ett_x2ap_ULResourcesULandDLSharing = -1;
static gint ett_x2ap_UsableABSInformation = -1;
static gint ett_x2ap_UsableABSInformationFDD = -1;
static gint ett_x2ap_UsableABSInformationTDD = -1;
static gint ett_x2ap_V2XServicesAuthorized = -1;
static gint ett_x2ap_WidebandCQI = -1;
static gint ett_x2ap_WidebandCQICodeword1 = -1;
static gint ett_x2ap_WLANMeasurementConfiguration = -1;
static gint ett_x2ap_WLANMeasConfigNameList = -1;
static gint ett_x2ap_WTID = -1;
static gint ett_x2ap_WTID_Type1 = -1;
static gint ett_x2ap_HandoverRequest = -1;
static gint ett_x2ap_UE_ContextInformation = -1;
static gint ett_x2ap_E_RABs_ToBeSetup_List = -1;
static gint ett_x2ap_E_RABs_ToBeSetup_Item = -1;
static gint ett_x2ap_UE_ContextReferenceAtSeNB = -1;
static gint ett_x2ap_UE_ContextReferenceAtWT = -1;
static gint ett_x2ap_UE_ContextReferenceAtSgNB = -1;
static gint ett_x2ap_HandoverRequestAcknowledge = -1;
static gint ett_x2ap_E_RABs_Admitted_List = -1;
static gint ett_x2ap_E_RABs_Admitted_Item = -1;
static gint ett_x2ap_HandoverPreparationFailure = -1;
static gint ett_x2ap_HandoverReport = -1;
static gint ett_x2ap_EarlyStatusTransfer = -1;
static gint ett_x2ap_ProcedureStageChoice = -1;
static gint ett_x2ap_FirstDLCount = -1;
static gint ett_x2ap_DLDiscarding = -1;
static gint ett_x2ap_SNStatusTransfer = -1;
static gint ett_x2ap_E_RABs_SubjectToStatusTransfer_List = -1;
static gint ett_x2ap_E_RABs_SubjectToStatusTransfer_Item = -1;
static gint ett_x2ap_UEContextRelease = -1;
static gint ett_x2ap_HandoverCancel = -1;
static gint ett_x2ap_HandoverSuccess = -1;
static gint ett_x2ap_ConditionalHandoverCancel = -1;
static gint ett_x2ap_ErrorIndication = -1;
static gint ett_x2ap_ResetRequest = -1;
static gint ett_x2ap_ResetResponse = -1;
static gint ett_x2ap_X2SetupRequest = -1;
static gint ett_x2ap_X2SetupResponse = -1;
static gint ett_x2ap_X2SetupFailure = -1;
static gint ett_x2ap_LoadInformation = -1;
static gint ett_x2ap_CellInformation_List = -1;
static gint ett_x2ap_CellInformation_Item = -1;
static gint ett_x2ap_ENBConfigurationUpdate = -1;
static gint ett_x2ap_ServedCellsToModify = -1;
static gint ett_x2ap_ServedCellsToModify_Item = -1;
static gint ett_x2ap_Old_ECGIs = -1;
static gint ett_x2ap_ENBConfigurationUpdateAcknowledge = -1;
static gint ett_x2ap_ENBConfigurationUpdateFailure = -1;
static gint ett_x2ap_ResourceStatusRequest = -1;
static gint ett_x2ap_CellToReport_List = -1;
static gint ett_x2ap_CellToReport_Item = -1;
static gint ett_x2ap_ResourceStatusResponse = -1;
static gint ett_x2ap_MeasurementInitiationResult_List = -1;
static gint ett_x2ap_MeasurementInitiationResult_Item = -1;
static gint ett_x2ap_MeasurementFailureCause_List = -1;
static gint ett_x2ap_MeasurementFailureCause_Item = -1;
static gint ett_x2ap_ResourceStatusFailure = -1;
static gint ett_x2ap_CompleteFailureCauseInformation_List = -1;
static gint ett_x2ap_CompleteFailureCauseInformation_Item = -1;
static gint ett_x2ap_ResourceStatusUpdate = -1;
static gint ett_x2ap_CellMeasurementResult_List = -1;
static gint ett_x2ap_CellMeasurementResult_Item = -1;
static gint ett_x2ap_PrivateMessage = -1;
static gint ett_x2ap_MobilityChangeRequest = -1;
static gint ett_x2ap_MobilityChangeAcknowledge = -1;
static gint ett_x2ap_MobilityChangeFailure = -1;
static gint ett_x2ap_RLFIndication = -1;
static gint ett_x2ap_CellActivationRequest = -1;
static gint ett_x2ap_ServedCellsToActivate = -1;
static gint ett_x2ap_ServedCellsToActivate_Item = -1;
static gint ett_x2ap_CellActivationResponse = -1;
static gint ett_x2ap_ActivatedCellList = -1;
static gint ett_x2ap_ActivatedCellList_Item = -1;
static gint ett_x2ap_CellActivationFailure = -1;
static gint ett_x2ap_X2Release = -1;
static gint ett_x2ap_X2APMessageTransfer = -1;
static gint ett_x2ap_RNL_Header = -1;
static gint ett_x2ap_SeNBAdditionRequest = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_List = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_Item = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_Item_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_Item_Split_Bearer = -1;
static gint ett_x2ap_SeNBAdditionRequestAcknowledge = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_List = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_Item = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_Item_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_Item_Split_Bearer = -1;
static gint ett_x2ap_SeNBAdditionRequestReject = -1;
static gint ett_x2ap_SeNBReconfigurationComplete = -1;
static gint ett_x2ap_ResponseInformationSeNBReconfComp = -1;
static gint ett_x2ap_ResponseInformationSeNBReconfComp_SuccessItem = -1;
static gint ett_x2ap_ResponseInformationSeNBReconfComp_RejectByMeNBItem = -1;
static gint ett_x2ap_SeNBModificationRequest = -1;
static gint ett_x2ap_UE_ContextInformationSeNBModReq = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_List_ModReq = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_ModReqItem = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_ModReqItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_ModReqItem_Split_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeModified_List_ModReq = -1;
static gint ett_x2ap_E_RABs_ToBeModified_ModReqItem = -1;
static gint ett_x2ap_E_RABs_ToBeModified_ModReqItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeModified_ModReqItem_Split_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_List_ModReq = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_ModReqItem = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_ModReqItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_ModReqItem_Split_Bearer = -1;
static gint ett_x2ap_SeNBModificationRequestAcknowledge = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_Split_Bearer = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_Split_Bearer = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToReleased_ModAckItem = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_Split_Bearer = -1;
static gint ett_x2ap_SeNBModificationRequestReject = -1;
static gint ett_x2ap_SeNBModificationRequired = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_ModReqd = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_ModReqdItem = -1;
static gint ett_x2ap_SeNBModificationConfirm = -1;
static gint ett_x2ap_SeNBModificationRefuse = -1;
static gint ett_x2ap_SeNBReleaseRequest = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_List_RelReq = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_RelReqItem = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_RelReqItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_RelReqItem_Split_Bearer = -1;
static gint ett_x2ap_SeNBReleaseRequired = -1;
static gint ett_x2ap_SeNBReleaseConfirm = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_List_RelConf = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_RelConfItem = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_RelConfItem_SCG_Bearer = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_RelConfItem_Split_Bearer = -1;
static gint ett_x2ap_SeNBCounterCheckRequest = -1;
static gint ett_x2ap_E_RABs_SubjectToCounterCheck_List = -1;
static gint ett_x2ap_E_RABs_SubjectToCounterCheckItem = -1;
static gint ett_x2ap_X2RemovalRequest = -1;
static gint ett_x2ap_X2RemovalResponse = -1;
static gint ett_x2ap_X2RemovalFailure = -1;
static gint ett_x2ap_RetrieveUEContextRequest = -1;
static gint ett_x2ap_RetrieveUEContextResponse = -1;
static gint ett_x2ap_UE_ContextInformationRetrieve = -1;
static gint ett_x2ap_E_RABs_ToBeSetup_ListRetrieve = -1;
static gint ett_x2ap_E_RABs_ToBeSetupRetrieve_Item = -1;
static gint ett_x2ap_RetrieveUEContextFailure = -1;
static gint ett_x2ap_SgNBAdditionRequest = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBAddReqList = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item = -1;
static gint ett_x2ap_T_resource_configuration = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBAdditionRequestAcknowledge = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item = -1;
static gint ett_x2ap_T_resource_configuration_01 = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBAdditionRequestReject = -1;
static gint ett_x2ap_SgNBReconfigurationComplete = -1;
static gint ett_x2ap_ResponseInformationSgNBReconfComp = -1;
static gint ett_x2ap_ResponseInformationSgNBReconfComp_SuccessItem = -1;
static gint ett_x2ap_ResponseInformationSgNBReconfComp_RejectByMeNBItem = -1;
static gint ett_x2ap_SgNBModificationRequest = -1;
static gint ett_x2ap_UE_ContextInformation_SgNBModReq = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_List = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item = -1;
static gint ett_x2ap_T_resource_configuration_02 = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReq_List = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReq_Item = -1;
static gint ett_x2ap_T_resource_configuration_03 = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_List = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item = -1;
static gint ett_x2ap_T_resource_configuration_04 = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBModificationRequestAcknowledge = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item = -1;
static gint ett_x2ap_T_resource_configuration_05 = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item = -1;
static gint ett_x2ap_T_resource_configuration_06 = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToReleased_SgNBModAck_Item = -1;
static gint ett_x2ap_T_resource_configuration_07 = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBModificationRequestReject = -1;
static gint ett_x2ap_SgNBModificationRequired = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBModReqdList = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBModReqd_Item = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReqdList = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item = -1;
static gint ett_x2ap_T_resource_configuration_08 = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBModificationConfirm = -1;
static gint ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList = -1;
static gint ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item = -1;
static gint ett_x2ap_T_resource_configuration_09 = -1;
static gint ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBModificationRefuse = -1;
static gint ett_x2ap_SgNBReleaseRequest = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelReqList = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item = -1;
static gint ett_x2ap_T_resource_configuration_10 = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBReleaseRequestAcknowledge = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList = -1;
static gint ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item = -1;
static gint ett_x2ap_SgNBReleaseRequestReject = -1;
static gint ett_x2ap_SgNBReleaseRequired = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelReqd_Item = -1;
static gint ett_x2ap_SgNBReleaseConfirm = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelConfList = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item = -1;
static gint ett_x2ap_T_resource_configuration_11 = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_SgNBCounterCheckRequest = -1;
static gint ett_x2ap_E_RABs_SubjectToSgNBCounterCheck_List = -1;
static gint ett_x2ap_E_RABs_SubjectToSgNBCounterCheck_Item = -1;
static gint ett_x2ap_SgNBChangeRequired = -1;
static gint ett_x2ap_SgNBChangeConfirm = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBChaConfList = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item = -1;
static gint ett_x2ap_T_resource_configuration_12 = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPpresent = -1;
static gint ett_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPnotpresent = -1;
static gint ett_x2ap_RRCTransfer = -1;
static gint ett_x2ap_SgNBChangeRefuse = -1;
static gint ett_x2ap_ENDCX2SetupRequest = -1;
static gint ett_x2ap_InitiatingNodeType_EndcX2Setup = -1;
static gint ett_x2ap_ServedEUTRAcellsENDCX2ManagementList = -1;
static gint ett_x2ap_ServedEUTRAcellsENDCX2ManagementList_item = -1;
static gint ett_x2ap_ServedNRcellsENDCX2ManagementList = -1;
static gint ett_x2ap_ServedNRcellsENDCX2ManagementList_item = -1;
static gint ett_x2ap_ServedNRCell_Information = -1;
static gint ett_x2ap_T_nrModeInfo = -1;
static gint ett_x2ap_FDD_InfoServedNRCell_Information = -1;
static gint ett_x2ap_TDD_InfoServedNRCell_Information = -1;
static gint ett_x2ap_CellandCapacityAssistInfo = -1;
static gint ett_x2ap_CellAssistanceInformation = -1;
static gint ett_x2ap_Limited_list = -1;
static gint ett_x2ap_Limited_list_item = -1;
static gint ett_x2ap_ENDCX2SetupResponse = -1;
static gint ett_x2ap_RespondingNodeType_EndcX2Setup = -1;
static gint ett_x2ap_ENDCX2SetupFailure = -1;
static gint ett_x2ap_ENDCConfigurationUpdate = -1;
static gint ett_x2ap_InitiatingNodeType_EndcConfigUpdate = -1;
static gint ett_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd = -1;
static gint ett_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_item = -1;
static gint ett_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd = -1;
static gint ett_x2ap_ServedNRcellsToModifyENDCConfUpdList = -1;
static gint ett_x2ap_ServedNRCellsToModify_Item = -1;
static gint ett_x2ap_ServedNRcellsToDeleteENDCConfUpdList = -1;
static gint ett_x2ap_ENDCConfigurationUpdateAcknowledge = -1;
static gint ett_x2ap_RespondingNodeType_EndcConfigUpdate = -1;
static gint ett_x2ap_ENDCConfigurationUpdateFailure = -1;
static gint ett_x2ap_ENDCCellActivationRequest = -1;
static gint ett_x2ap_ServedNRCellsToActivate = -1;
static gint ett_x2ap_ServedNRCellsToActivate_Item = -1;
static gint ett_x2ap_ENDCCellActivationResponse = -1;
static gint ett_x2ap_ActivatedNRCellList = -1;
static gint ett_x2ap_ActivatedNRCellList_Item = -1;
static gint ett_x2ap_ENDCCellActivationFailure = -1;
static gint ett_x2ap_ENDCResourceStatusRequest = -1;
static gint ett_x2ap_CellToReport_NR_ENDC_List = -1;
static gint ett_x2ap_CellToReport_NR_ENDC_Item = -1;
static gint ett_x2ap_CellToReport_E_UTRA_ENDC_List = -1;
static gint ett_x2ap_CellToReport_E_UTRA_ENDC_Item = -1;
static gint ett_x2ap_SSBToReport_List = -1;
static gint ett_x2ap_SSBToReport_Item = -1;
static gint ett_x2ap_ENDCResourceStatusResponse = -1;
static gint ett_x2ap_ENDCResourceStatusFailure = -1;
static gint ett_x2ap_ENDCResourceStatusUpdate = -1;
static gint ett_x2ap_CellMeasurementResult_NR_ENDC_List = -1;
static gint ett_x2ap_CellMeasurementResult_NR_ENDC_Item = -1;
static gint ett_x2ap_CellMeasurementResult_E_UTRA_ENDC_List = -1;
static gint ett_x2ap_CellMeasurementResult_E_UTRA_ENDC_Item = -1;
static gint ett_x2ap_SecondaryRATDataUsageReport = -1;
static gint ett_x2ap_SgNBActivityNotification = -1;
static gint ett_x2ap_ENDCPartialResetRequired = -1;
static gint ett_x2ap_ENDCPartialResetConfirm = -1;
static gint ett_x2ap_EUTRANRCellResourceCoordinationRequest = -1;
static gint ett_x2ap_InitiatingNodeType_EutranrCellResourceCoordination = -1;
static gint ett_x2ap_ListofEUTRACellsinEUTRACoordinationReq = -1;
static gint ett_x2ap_ListofEUTRACellsinNRCoordinationReq = -1;
static gint ett_x2ap_ListofNRCellsinNRCoordinationReq = -1;
static gint ett_x2ap_EUTRANRCellResourceCoordinationResponse = -1;
static gint ett_x2ap_RespondingNodeType_EutranrCellResourceCoordination = -1;
static gint ett_x2ap_ListofEUTRACellsinEUTRACoordinationResp = -1;
static gint ett_x2ap_ListofNRCellsinNRCoordinationResp = -1;
static gint ett_x2ap_ENDCX2RemovalRequest = -1;
static gint ett_x2ap_InitiatingNodeType_EndcX2Removal = -1;
static gint ett_x2ap_ENDCX2RemovalResponse = -1;
static gint ett_x2ap_RespondingNodeType_EndcX2Removal = -1;
static gint ett_x2ap_ENDCX2RemovalFailure = -1;
static gint ett_x2ap_DataForwardingAddressIndication = -1;
static gint ett_x2ap_E_RABs_DataForwardingAddress_List = -1;
static gint ett_x2ap_E_RABs_DataForwardingAddress_Item = -1;
static gint ett_x2ap_GNBStatusIndication = -1;
static gint ett_x2ap_ENDCConfigurationTransfer = -1;
static gint ett_x2ap_TraceStart = -1;
static gint ett_x2ap_DeactivateTrace = -1;
static gint ett_x2ap_CellTrafficTrace = -1;
static gint ett_x2ap_F1CTrafficTransfer = -1;
static gint ett_x2ap_UERadioCapabilityIDMappingRequest = -1;
static gint ett_x2ap_UERadioCapabilityIDMappingResponse = -1;
static gint ett_x2ap_X2AP_PDU = -1;
static gint ett_x2ap_InitiatingMessage = -1;
static gint ett_x2ap_SuccessfulOutcome = -1;
static gint ett_x2ap_UnsuccessfulOutcome = -1;

/*--- End of included file: packet-x2ap-ett.c ---*/
#line 180 "./asn1/x2ap/packet-x2ap-template.c"

/* Forward declarations */
static int dissect_x2ap_Registration_Request_ENDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_);
static int dissect_x2ap_ReportCharacteristics_ENDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_);
static int dissect_x2ap_ReportingPeriodicity_ENDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_);

typedef enum {
  RRC_CONTAINER_TYPE_UNKNOWN,
  RRC_CONTAINER_TYPE_PDCP_C_PDU,
  RRC_CONTAINER_TYPE_NR_UE_MEAS_REPORT,
  RRC_CONTAINER_TYPE_FAST_MCG_RECOVERY_SgNB_TO_MeNB,
  RRC_CONTAINER_TYPE_FAST_MCG_RECOVERY_MeNB_TO_SgNB
} rrc_container_type_e;

enum{
  INITIATING_MESSAGE,
  SUCCESSFUL_OUTCOME,
  UNSUCCESSFUL_OUTCOME
};

struct x2ap_private_data {
  guint32 procedure_code;
  guint32 protocol_ie_id;
  guint32 message_type;
  rrc_container_type_e rrc_container_type;
  e212_number_type_t number_type;
};

enum {
  X2AP_RRC_CONTEXT_LTE,
  X2AP_RRC_CONTEXT_NBIOT
};

static const enum_val_t x2ap_rrc_context_vals[] = {
  {"lte", "LTE", X2AP_RRC_CONTEXT_LTE},
  {"nb-iot","NB-IoT", X2AP_RRC_CONTEXT_NBIOT},
  {NULL, NULL, -1}
};

/* Global variables */
static guint gbl_x2apSctpPort=SCTP_PORT_X2AP;
static gint g_x2ap_dissect_rrc_context_as = X2AP_RRC_CONTEXT_LTE;

/* Dissector tables */
static dissector_table_t x2ap_ies_dissector_table;
static dissector_table_t x2ap_extension_dissector_table;
static dissector_table_t x2ap_proc_imsg_dissector_table;
static dissector_table_t x2ap_proc_sout_dissector_table;
static dissector_table_t x2ap_proc_uout_dissector_table;

static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_X2AP_PDU_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
void proto_reg_handoff_x2ap(void);

static dissector_handle_t x2ap_handle;

static const true_false_string x2ap_tfs_failed_succeeded = {
  "Failed",
  "Succeeded"
};

static const true_false_string x2ap_tfs_interfacesToTrace = {
  "Should be traced",
  "Should not be traced"
};

static const true_false_string x2ap_tfs_activate_do_not_activate = {
  "Activate",
  "Do not activate"
};

static void
x2ap_Time_UE_StayedInCell_EnhancedGranularity_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fs", ((float)v)/10);
}

static void
x2ap_handoverTriggerChange_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%d)", ((float)v)/2, (gint32)v);
}

static void
x2ap_Threshold_RSRP_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%u)", (gint32)v-140, v);
}

static void
x2ap_Threshold_RSRQ_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", ((float)v/2)-20, v);
}

static void
x2ap_Packet_LossRate_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1f %% (%u)", (float)v/10, v);
}

static struct x2ap_private_data*
x2ap_get_private_data(packet_info *pinfo)
{
  struct x2ap_private_data *x2ap_data = (struct x2ap_private_data*)p_get_proto_data(pinfo->pool, pinfo, proto_x2ap, 0);
  if (!x2ap_data) {
    x2ap_data = wmem_new0(pinfo->pool, struct x2ap_private_data);
    p_add_proto_data(pinfo->pool, pinfo, proto_x2ap, 0, x2ap_data);
  }
  return x2ap_data;
}


/*--- Included file: packet-x2ap-fn.c ---*/
#line 1 "./asn1/x2ap/packet-x2ap-fn.c"

static const value_string x2ap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_x2ap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_maxPrivateIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxPrivateIEs, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_OBJECT_IDENTIFIER(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_object_identifier(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string x2ap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_x2ap_local          , ASN1_NO_EXTENSIONS     , dissect_x2ap_INTEGER_0_maxPrivateIEs },
  {   1, &hf_x2ap_global         , ASN1_NO_EXTENSIONS     , dissect_x2ap_OBJECT_IDENTIFIER },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string x2ap_ProcedureCode_vals[] = {
  { id_handoverPreparation, "id-handoverPreparation" },
  { id_handoverCancel, "id-handoverCancel" },
  { id_loadIndication, "id-loadIndication" },
  { id_errorIndication, "id-errorIndication" },
  { id_snStatusTransfer, "id-snStatusTransfer" },
  { id_uEContextRelease, "id-uEContextRelease" },
  { id_x2Setup, "id-x2Setup" },
  { id_reset, "id-reset" },
  { id_eNBConfigurationUpdate, "id-eNBConfigurationUpdate" },
  { id_resourceStatusReportingInitiation, "id-resourceStatusReportingInitiation" },
  { id_resourceStatusReporting, "id-resourceStatusReporting" },
  { id_privateMessage, "id-privateMessage" },
  { id_mobilitySettingsChange, "id-mobilitySettingsChange" },
  { id_rLFIndication, "id-rLFIndication" },
  { id_handoverReport, "id-handoverReport" },
  { id_cellActivation, "id-cellActivation" },
  { id_x2Release, "id-x2Release" },
  { id_x2APMessageTransfer, "id-x2APMessageTransfer" },
  { id_x2Removal, "id-x2Removal" },
  { id_seNBAdditionPreparation, "id-seNBAdditionPreparation" },
  { id_seNBReconfigurationCompletion, "id-seNBReconfigurationCompletion" },
  { id_meNBinitiatedSeNBModificationPreparation, "id-meNBinitiatedSeNBModificationPreparation" },
  { id_seNBinitiatedSeNBModification, "id-seNBinitiatedSeNBModification" },
  { id_meNBinitiatedSeNBRelease, "id-meNBinitiatedSeNBRelease" },
  { id_seNBinitiatedSeNBRelease, "id-seNBinitiatedSeNBRelease" },
  { id_seNBCounterCheck, "id-seNBCounterCheck" },
  { id_retrieveUEContext, "id-retrieveUEContext" },
  { id_sgNBAdditionPreparation, "id-sgNBAdditionPreparation" },
  { id_sgNBReconfigurationCompletion, "id-sgNBReconfigurationCompletion" },
  { id_meNBinitiatedSgNBModificationPreparation, "id-meNBinitiatedSgNBModificationPreparation" },
  { id_sgNBinitiatedSgNBModification, "id-sgNBinitiatedSgNBModification" },
  { id_meNBinitiatedSgNBRelease, "id-meNBinitiatedSgNBRelease" },
  { id_sgNBinitiatedSgNBRelease, "id-sgNBinitiatedSgNBRelease" },
  { id_sgNBCounterCheck, "id-sgNBCounterCheck" },
  { id_sgNBChange, "id-sgNBChange" },
  { id_rRCTransfer, "id-rRCTransfer" },
  { id_endcX2Setup, "id-endcX2Setup" },
  { id_endcConfigurationUpdate, "id-endcConfigurationUpdate" },
  { id_secondaryRATDataUsageReport, "id-secondaryRATDataUsageReport" },
  { id_endcCellActivation, "id-endcCellActivation" },
  { id_endcPartialReset, "id-endcPartialReset" },
  { id_eUTRANRCellResourceCoordination, "id-eUTRANRCellResourceCoordination" },
  { id_SgNBActivityNotification, "id-SgNBActivityNotification" },
  { id_endcX2Removal, "id-endcX2Removal" },
  { id_dataForwardingAddressIndication, "id-dataForwardingAddressIndication" },
  { id_gNBStatusIndication, "id-gNBStatusIndication" },
  { id_deactivateTrace, "id-deactivateTrace" },
  { id_traceStart, "id-traceStart" },
  { id_endcConfigurationTransfer, "id-endcConfigurationTransfer" },
  { id_handoverSuccess, "id-handoverSuccess" },
  { id_conditionalHandoverCancel, "id-conditionalHandoverCancel" },
  { id_earlyStatusTransfer, "id-earlyStatusTransfer" },
  { id_cellTrafficTrace, "id-cellTrafficTrace" },
  { id_endcresourceStatusReporting, "id-endcresourceStatusReporting" },
  { id_endcresourceStatusReportingInitiation, "id-endcresourceStatusReportingInitiation" },
  { id_f1CTrafficTransfer, "id-f1CTrafficTransfer" },
  { id_UERadioCapabilityIDMapping, "id-UERadioCapabilityIDMapping" },
  { 0, NULL }
};

static value_string_ext x2ap_ProcedureCode_vals_ext = VALUE_STRING_EXT_INIT(x2ap_ProcedureCode_vals);


static int
dissect_x2ap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 81 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &x2ap_data->procedure_code, FALSE);




  return offset;
}


static const value_string x2ap_ProtocolIE_ID_vals[] = {
  { id_E_RABs_Admitted_Item, "id-E-RABs-Admitted-Item" },
  { id_E_RABs_Admitted_List, "id-E-RABs-Admitted-List" },
  { id_E_RAB_Item, "id-E-RAB-Item" },
  { id_E_RABs_NotAdmitted_List, "id-E-RABs-NotAdmitted-List" },
  { id_E_RABs_ToBeSetup_Item, "id-E-RABs-ToBeSetup-Item" },
  { id_Cause, "id-Cause" },
  { id_CellInformation, "id-CellInformation" },
  { id_CellInformation_Item, "id-CellInformation-Item" },
  { id_Unknown_8, "id-Unknown-8" },
  { id_New_eNB_UE_X2AP_ID, "id-New-eNB-UE-X2AP-ID" },
  { id_Old_eNB_UE_X2AP_ID, "id-Old-eNB-UE-X2AP-ID" },
  { id_TargetCell_ID, "id-TargetCell-ID" },
  { id_TargeteNBtoSource_eNBTransparentContainer, "id-TargeteNBtoSource-eNBTransparentContainer" },
  { id_TraceActivation, "id-TraceActivation" },
  { id_UE_ContextInformation, "id-UE-ContextInformation" },
  { id_UE_HistoryInformation, "id-UE-HistoryInformation" },
  { id_UE_X2AP_ID, "id-UE-X2AP-ID" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_E_RABs_SubjectToStatusTransfer_List, "id-E-RABs-SubjectToStatusTransfer-List" },
  { id_E_RABs_SubjectToStatusTransfer_Item, "id-E-RABs-SubjectToStatusTransfer-Item" },
  { id_ServedCells, "id-ServedCells" },
  { id_GlobalENB_ID, "id-GlobalENB-ID" },
  { id_TimeToWait, "id-TimeToWait" },
  { id_GUMMEI_ID, "id-GUMMEI-ID" },
  { id_GUGroupIDList, "id-GUGroupIDList" },
  { id_ServedCellsToAdd, "id-ServedCellsToAdd" },
  { id_ServedCellsToModify, "id-ServedCellsToModify" },
  { id_ServedCellsToDelete, "id-ServedCellsToDelete" },
  { id_Registration_Request, "id-Registration-Request" },
  { id_CellToReport, "id-CellToReport" },
  { id_ReportingPeriodicity, "id-ReportingPeriodicity" },
  { id_CellToReport_Item, "id-CellToReport-Item" },
  { id_CellMeasurementResult, "id-CellMeasurementResult" },
  { id_CellMeasurementResult_Item, "id-CellMeasurementResult-Item" },
  { id_GUGroupIDToAddList, "id-GUGroupIDToAddList" },
  { id_GUGroupIDToDeleteList, "id-GUGroupIDToDeleteList" },
  { id_SRVCCOperationPossible, "id-SRVCCOperationPossible" },
  { id_Measurement_ID, "id-Measurement-ID" },
  { id_ReportCharacteristics, "id-ReportCharacteristics" },
  { id_ENB1_Measurement_ID, "id-ENB1-Measurement-ID" },
  { id_ENB2_Measurement_ID, "id-ENB2-Measurement-ID" },
  { id_Number_of_Antennaports, "id-Number-of-Antennaports" },
  { id_CompositeAvailableCapacityGroup, "id-CompositeAvailableCapacityGroup" },
  { id_ENB1_Cell_ID, "id-ENB1-Cell-ID" },
  { id_ENB2_Cell_ID, "id-ENB2-Cell-ID" },
  { id_ENB2_Proposed_Mobility_Parameters, "id-ENB2-Proposed-Mobility-Parameters" },
  { id_ENB1_Mobility_Parameters, "id-ENB1-Mobility-Parameters" },
  { id_ENB2_Mobility_Parameters_Modification_Range, "id-ENB2-Mobility-Parameters-Modification-Range" },
  { id_FailureCellPCI, "id-FailureCellPCI" },
  { id_Re_establishmentCellECGI, "id-Re-establishmentCellECGI" },
  { id_FailureCellCRNTI, "id-FailureCellCRNTI" },
  { id_ShortMAC_I, "id-ShortMAC-I" },
  { id_SourceCellECGI, "id-SourceCellECGI" },
  { id_FailureCellECGI, "id-FailureCellECGI" },
  { id_HandoverReportType, "id-HandoverReportType" },
  { id_PRACH_Configuration, "id-PRACH-Configuration" },
  { id_MBSFN_Subframe_Info, "id-MBSFN-Subframe-Info" },
  { id_ServedCellsToActivate, "id-ServedCellsToActivate" },
  { id_ActivatedCellList, "id-ActivatedCellList" },
  { id_DeactivationIndication, "id-DeactivationIndication" },
  { id_UE_RLF_Report_Container, "id-UE-RLF-Report-Container" },
  { id_ABSInformation, "id-ABSInformation" },
  { id_InvokeIndication, "id-InvokeIndication" },
  { id_ABS_Status, "id-ABS-Status" },
  { id_PartialSuccessIndicator, "id-PartialSuccessIndicator" },
  { id_MeasurementInitiationResult_List, "id-MeasurementInitiationResult-List" },
  { id_MeasurementInitiationResult_Item, "id-MeasurementInitiationResult-Item" },
  { id_MeasurementFailureCause_Item, "id-MeasurementFailureCause-Item" },
  { id_CompleteFailureCauseInformation_List, "id-CompleteFailureCauseInformation-List" },
  { id_CompleteFailureCauseInformation_Item, "id-CompleteFailureCauseInformation-Item" },
  { id_CSG_Id, "id-CSG-Id" },
  { id_CSGMembershipStatus, "id-CSGMembershipStatus" },
  { id_MDTConfiguration, "id-MDTConfiguration" },
  { id_Unknown_73, "id-Unknown-73" },
  { id_ManagementBasedMDTallowed, "id-ManagementBasedMDTallowed" },
  { id_RRCConnSetupIndicator, "id-RRCConnSetupIndicator" },
  { id_NeighbourTAC, "id-NeighbourTAC" },
  { id_Time_UE_StayedInCell_EnhancedGranularity, "id-Time-UE-StayedInCell-EnhancedGranularity" },
  { id_RRCConnReestabIndicator, "id-RRCConnReestabIndicator" },
  { id_MBMS_Service_Area_List, "id-MBMS-Service-Area-List" },
  { id_HO_cause, "id-HO-cause" },
  { id_TargetCellInUTRAN, "id-TargetCellInUTRAN" },
  { id_MobilityInformation, "id-MobilityInformation" },
  { id_SourceCellCRNTI, "id-SourceCellCRNTI" },
  { id_MultibandInfoList, "id-MultibandInfoList" },
  { id_M3Configuration, "id-M3Configuration" },
  { id_M4Configuration, "id-M4Configuration" },
  { id_M5Configuration, "id-M5Configuration" },
  { id_MDT_Location_Info, "id-MDT-Location-Info" },
  { id_ManagementBasedMDTPLMNList, "id-ManagementBasedMDTPLMNList" },
  { id_SignallingBasedMDTPLMNList, "id-SignallingBasedMDTPLMNList" },
  { id_ReceiveStatusOfULPDCPSDUsExtended, "id-ReceiveStatusOfULPDCPSDUsExtended" },
  { id_ULCOUNTValueExtended, "id-ULCOUNTValueExtended" },
  { id_DLCOUNTValueExtended, "id-DLCOUNTValueExtended" },
  { id_eARFCNExtension, "id-eARFCNExtension" },
  { id_UL_EARFCNExtension, "id-UL-EARFCNExtension" },
  { id_DL_EARFCNExtension, "id-DL-EARFCNExtension" },
  { id_AdditionalSpecialSubframe_Info, "id-AdditionalSpecialSubframe-Info" },
  { id_Masked_IMEISV, "id-Masked-IMEISV" },
  { id_IntendedULDLConfiguration, "id-IntendedULDLConfiguration" },
  { id_ExtendedULInterferenceOverloadInfo, "id-ExtendedULInterferenceOverloadInfo" },
  { id_RNL_Header, "id-RNL-Header" },
  { id_x2APMessage, "id-x2APMessage" },
  { id_ProSeAuthorized, "id-ProSeAuthorized" },
  { id_ExpectedUEBehaviour, "id-ExpectedUEBehaviour" },
  { id_UE_HistoryInformationFromTheUE, "id-UE-HistoryInformationFromTheUE" },
  { id_DynamicDLTransmissionInformation, "id-DynamicDLTransmissionInformation" },
  { id_UE_RLF_Report_Container_for_extended_bands, "id-UE-RLF-Report-Container-for-extended-bands" },
  { id_CoMPInformation, "id-CoMPInformation" },
  { id_ReportingPeriodicityRSRPMR, "id-ReportingPeriodicityRSRPMR" },
  { id_RSRPMRList, "id-RSRPMRList" },
  { id_MeNB_UE_X2AP_ID, "id-MeNB-UE-X2AP-ID" },
  { id_SeNB_UE_X2AP_ID, "id-SeNB-UE-X2AP-ID" },
  { id_UE_SecurityCapabilities, "id-UE-SecurityCapabilities" },
  { id_SeNBSecurityKey, "id-SeNBSecurityKey" },
  { id_SeNBUEAggregateMaximumBitRate, "id-SeNBUEAggregateMaximumBitRate" },
  { id_ServingPLMN, "id-ServingPLMN" },
  { id_E_RABs_ToBeAdded_List, "id-E-RABs-ToBeAdded-List" },
  { id_E_RABs_ToBeAdded_Item, "id-E-RABs-ToBeAdded-Item" },
  { id_MeNBtoSeNBContainer, "id-MeNBtoSeNBContainer" },
  { id_E_RABs_Admitted_ToBeAdded_List, "id-E-RABs-Admitted-ToBeAdded-List" },
  { id_E_RABs_Admitted_ToBeAdded_Item, "id-E-RABs-Admitted-ToBeAdded-Item" },
  { id_SeNBtoMeNBContainer, "id-SeNBtoMeNBContainer" },
  { id_ResponseInformationSeNBReconfComp, "id-ResponseInformationSeNBReconfComp" },
  { id_UE_ContextInformationSeNBModReq, "id-UE-ContextInformationSeNBModReq" },
  { id_E_RABs_ToBeAdded_ModReqItem, "id-E-RABs-ToBeAdded-ModReqItem" },
  { id_E_RABs_ToBeModified_ModReqItem, "id-E-RABs-ToBeModified-ModReqItem" },
  { id_E_RABs_ToBeReleased_ModReqItem, "id-E-RABs-ToBeReleased-ModReqItem" },
  { id_E_RABs_Admitted_ToBeAdded_ModAckList, "id-E-RABs-Admitted-ToBeAdded-ModAckList" },
  { id_E_RABs_Admitted_ToBeModified_ModAckList, "id-E-RABs-Admitted-ToBeModified-ModAckList" },
  { id_E_RABs_Admitted_ToBeReleased_ModAckList, "id-E-RABs-Admitted-ToBeReleased-ModAckList" },
  { id_E_RABs_Admitted_ToBeAdded_ModAckItem, "id-E-RABs-Admitted-ToBeAdded-ModAckItem" },
  { id_E_RABs_Admitted_ToBeModified_ModAckItem, "id-E-RABs-Admitted-ToBeModified-ModAckItem" },
  { id_E_RABs_Admitted_ToBeReleased_ModAckItem, "id-E-RABs-Admitted-ToBeReleased-ModAckItem" },
  { id_E_RABs_ToBeReleased_ModReqd, "id-E-RABs-ToBeReleased-ModReqd" },
  { id_E_RABs_ToBeReleased_ModReqdItem, "id-E-RABs-ToBeReleased-ModReqdItem" },
  { id_SCGChangeIndication, "id-SCGChangeIndication" },
  { id_E_RABs_ToBeReleased_List_RelReq, "id-E-RABs-ToBeReleased-List-RelReq" },
  { id_E_RABs_ToBeReleased_RelReqItem, "id-E-RABs-ToBeReleased-RelReqItem" },
  { id_E_RABs_ToBeReleased_List_RelConf, "id-E-RABs-ToBeReleased-List-RelConf" },
  { id_E_RABs_ToBeReleased_RelConfItem, "id-E-RABs-ToBeReleased-RelConfItem" },
  { id_E_RABs_SubjectToCounterCheck_List, "id-E-RABs-SubjectToCounterCheck-List" },
  { id_E_RABs_SubjectToCounterCheckItem, "id-E-RABs-SubjectToCounterCheckItem" },
  { id_CoverageModificationList, "id-CoverageModificationList" },
  { id_Unknown_144, "id-Unknown-144" },
  { id_ReportingPeriodicityCSIR, "id-ReportingPeriodicityCSIR" },
  { id_CSIReportList, "id-CSIReportList" },
  { id_UEID, "id-UEID" },
  { id_enhancedRNTP, "id-enhancedRNTP" },
  { id_ProSeUEtoNetworkRelaying, "id-ProSeUEtoNetworkRelaying" },
  { id_ReceiveStatusOfULPDCPSDUsPDCP_SNlength18, "id-ReceiveStatusOfULPDCPSDUsPDCP-SNlength18" },
  { id_ULCOUNTValuePDCP_SNlength18, "id-ULCOUNTValuePDCP-SNlength18" },
  { id_DLCOUNTValuePDCP_SNlength18, "id-DLCOUNTValuePDCP-SNlength18" },
  { id_UE_ContextReferenceAtSeNB, "id-UE-ContextReferenceAtSeNB" },
  { id_UE_ContextKeptIndicator, "id-UE-ContextKeptIndicator" },
  { id_New_eNB_UE_X2AP_ID_Extension, "id-New-eNB-UE-X2AP-ID-Extension" },
  { id_Old_eNB_UE_X2AP_ID_Extension, "id-Old-eNB-UE-X2AP-ID-Extension" },
  { id_MeNB_UE_X2AP_ID_Extension, "id-MeNB-UE-X2AP-ID-Extension" },
  { id_SeNB_UE_X2AP_ID_Extension, "id-SeNB-UE-X2AP-ID-Extension" },
  { id_LHN_ID, "id-LHN-ID" },
  { id_FreqBandIndicatorPriority, "id-FreqBandIndicatorPriority" },
  { id_M6Configuration, "id-M6Configuration" },
  { id_M7Configuration, "id-M7Configuration" },
  { id_Tunnel_Information_for_BBF, "id-Tunnel-Information-for-BBF" },
  { id_SIPTO_BearerDeactivationIndication, "id-SIPTO-BearerDeactivationIndication" },
  { id_GW_TransportLayerAddress, "id-GW-TransportLayerAddress" },
  { id_Correlation_ID, "id-Correlation-ID" },
  { id_SIPTO_Correlation_ID, "id-SIPTO-Correlation-ID" },
  { id_SIPTO_L_GW_TransportLayerAddress, "id-SIPTO-L-GW-TransportLayerAddress" },
  { id_X2RemovalThreshold, "id-X2RemovalThreshold" },
  { id_CellReportingIndicator, "id-CellReportingIndicator" },
  { id_BearerType, "id-BearerType" },
  { id_resumeID, "id-resumeID" },
  { id_UE_ContextInformationRetrieve, "id-UE-ContextInformationRetrieve" },
  { id_E_RABs_ToBeSetupRetrieve_Item, "id-E-RABs-ToBeSetupRetrieve-Item" },
  { id_NewEUTRANCellIdentifier, "id-NewEUTRANCellIdentifier" },
  { id_V2XServicesAuthorized, "id-V2XServicesAuthorized" },
  { id_OffsetOfNbiotChannelNumberToDL_EARFCN, "id-OffsetOfNbiotChannelNumberToDL-EARFCN" },
  { id_OffsetOfNbiotChannelNumberToUL_EARFCN, "id-OffsetOfNbiotChannelNumberToUL-EARFCN" },
  { id_AdditionalSpecialSubframeExtension_Info, "id-AdditionalSpecialSubframeExtension-Info" },
  { id_BandwidthReducedSI, "id-BandwidthReducedSI" },
  { id_MakeBeforeBreakIndicator, "id-MakeBeforeBreakIndicator" },
  { id_UE_ContextReferenceAtWT, "id-UE-ContextReferenceAtWT" },
  { id_WT_UE_ContextKeptIndicator, "id-WT-UE-ContextKeptIndicator" },
  { id_UESidelinkAggregateMaximumBitRate, "id-UESidelinkAggregateMaximumBitRate" },
  { id_uL_GTPtunnelEndpoint, "id-uL-GTPtunnelEndpoint" },
  { id_Unknown_186, "id-Unknown-186" },
  { id_Unknown_187, "id-Unknown-187" },
  { id_Unknown_188, "id-Unknown-188" },
  { id_Unknown_189, "id-Unknown-189" },
  { id_Unknown_190, "id-Unknown-190" },
  { id_Unknown_191, "id-Unknown-191" },
  { id_Unknown_192, "id-Unknown-192" },
  { id_DL_scheduling_PDCCH_CCE_usage, "id-DL-scheduling-PDCCH-CCE-usage" },
  { id_UL_scheduling_PDCCH_CCE_usage, "id-UL-scheduling-PDCCH-CCE-usage" },
  { id_UEAppLayerMeasConfig, "id-UEAppLayerMeasConfig" },
  { id_extended_e_RAB_MaximumBitrateDL, "id-extended-e-RAB-MaximumBitrateDL" },
  { id_extended_e_RAB_MaximumBitrateUL, "id-extended-e-RAB-MaximumBitrateUL" },
  { id_extended_e_RAB_GuaranteedBitrateDL, "id-extended-e-RAB-GuaranteedBitrateDL" },
  { id_extended_e_RAB_GuaranteedBitrateUL, "id-extended-e-RAB-GuaranteedBitrateUL" },
  { id_extended_uEaggregateMaximumBitRateDownlink, "id-extended-uEaggregateMaximumBitRateDownlink" },
  { id_extended_uEaggregateMaximumBitRateUplink, "id-extended-uEaggregateMaximumBitRateUplink" },
  { id_NRrestrictioninEPSasSecondaryRAT, "id-NRrestrictioninEPSasSecondaryRAT" },
  { id_SgNBSecurityKey, "id-SgNBSecurityKey" },
  { id_SgNBUEAggregateMaximumBitRate, "id-SgNBUEAggregateMaximumBitRate" },
  { id_E_RABs_ToBeAdded_SgNBAddReqList, "id-E-RABs-ToBeAdded-SgNBAddReqList" },
  { id_MeNBtoSgNBContainer, "id-MeNBtoSgNBContainer" },
  { id_SgNB_UE_X2AP_ID, "id-SgNB-UE-X2AP-ID" },
  { id_RequestedSplitSRBs, "id-RequestedSplitSRBs" },
  { id_E_RABs_ToBeAdded_SgNBAddReq_Item, "id-E-RABs-ToBeAdded-SgNBAddReq-Item" },
  { id_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList, "id-E-RABs-Admitted-ToBeAdded-SgNBAddReqAckList" },
  { id_SgNBtoMeNBContainer, "id-SgNBtoMeNBContainer" },
  { id_AdmittedSplitSRBs, "id-AdmittedSplitSRBs" },
  { id_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item, "id-E-RABs-Admitted-ToBeAdded-SgNBAddReqAck-Item" },
  { id_ResponseInformationSgNBReconfComp, "id-ResponseInformationSgNBReconfComp" },
  { id_UE_ContextInformation_SgNBModReq, "id-UE-ContextInformation-SgNBModReq" },
  { id_E_RABs_ToBeAdded_SgNBModReq_Item, "id-E-RABs-ToBeAdded-SgNBModReq-Item" },
  { id_E_RABs_ToBeModified_SgNBModReq_Item, "id-E-RABs-ToBeModified-SgNBModReq-Item" },
  { id_E_RABs_ToBeReleased_SgNBModReq_Item, "id-E-RABs-ToBeReleased-SgNBModReq-Item" },
  { id_E_RABs_Admitted_ToBeAdded_SgNBModAckList, "id-E-RABs-Admitted-ToBeAdded-SgNBModAckList" },
  { id_E_RABs_Admitted_ToBeModified_SgNBModAckList, "id-E-RABs-Admitted-ToBeModified-SgNBModAckList" },
  { id_E_RABs_Admitted_ToBeReleased_SgNBModAckList, "id-E-RABs-Admitted-ToBeReleased-SgNBModAckList" },
  { id_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item, "id-E-RABs-Admitted-ToBeAdded-SgNBModAck-Item" },
  { id_E_RABs_Admitted_ToBeModified_SgNBModAck_Item, "id-E-RABs-Admitted-ToBeModified-SgNBModAck-Item" },
  { id_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item, "id-E-RABs-Admitted-ToBeReleased-SgNBModAck-Item" },
  { id_E_RABs_ToBeReleased_SgNBModReqdList, "id-E-RABs-ToBeReleased-SgNBModReqdList" },
  { id_E_RABs_ToBeModified_SgNBModReqdList, "id-E-RABs-ToBeModified-SgNBModReqdList" },
  { id_E_RABs_ToBeReleased_SgNBModReqd_Item, "id-E-RABs-ToBeReleased-SgNBModReqd-Item" },
  { id_E_RABs_ToBeModified_SgNBModReqd_Item, "id-E-RABs-ToBeModified-SgNBModReqd-Item" },
  { id_E_RABs_ToBeReleased_SgNBChaConfList, "id-E-RABs-ToBeReleased-SgNBChaConfList" },
  { id_E_RABs_ToBeReleased_SgNBChaConf_Item, "id-E-RABs-ToBeReleased-SgNBChaConf-Item" },
  { id_E_RABs_ToBeReleased_SgNBRelReqList, "id-E-RABs-ToBeReleased-SgNBRelReqList" },
  { id_E_RABs_ToBeReleased_SgNBRelReq_Item, "id-E-RABs-ToBeReleased-SgNBRelReq-Item" },
  { id_E_RABs_ToBeReleased_SgNBRelConfList, "id-E-RABs-ToBeReleased-SgNBRelConfList" },
  { id_E_RABs_ToBeReleased_SgNBRelConf_Item, "id-E-RABs-ToBeReleased-SgNBRelConf-Item" },
  { id_E_RABs_SubjectToSgNBCounterCheck_List, "id-E-RABs-SubjectToSgNBCounterCheck-List" },
  { id_E_RABs_SubjectToSgNBCounterCheck_Item, "id-E-RABs-SubjectToSgNBCounterCheck-Item" },
  { id_RRCContainer, "id-RRCContainer" },
  { id_SRBType, "id-SRBType" },
  { id_Target_SgNB_ID, "id-Target-SgNB-ID" },
  { id_HandoverRestrictionList, "id-HandoverRestrictionList" },
  { id_SCGConfigurationQuery, "id-SCGConfigurationQuery" },
  { id_SplitSRB, "id-SplitSRB" },
  { id_NRUeReport, "id-NRUeReport" },
  { id_InitiatingNodeType_EndcX2Setup, "id-InitiatingNodeType-EndcX2Setup" },
  { id_InitiatingNodeType_EndcConfigUpdate, "id-InitiatingNodeType-EndcConfigUpdate" },
  { id_RespondingNodeType_EndcX2Setup, "id-RespondingNodeType-EndcX2Setup" },
  { id_RespondingNodeType_EndcConfigUpdate, "id-RespondingNodeType-EndcConfigUpdate" },
  { id_NRUESecurityCapabilities, "id-NRUESecurityCapabilities" },
  { id_PDCPChangeIndication, "id-PDCPChangeIndication" },
  { id_ServedEUTRAcellsENDCX2ManagementList, "id-ServedEUTRAcellsENDCX2ManagementList" },
  { id_CellAssistanceInformation, "id-CellAssistanceInformation" },
  { id_Globalen_gNB_ID, "id-Globalen-gNB-ID" },
  { id_ServedNRcellsENDCX2ManagementList, "id-ServedNRcellsENDCX2ManagementList" },
  { id_UE_ContextReferenceAtSgNB, "id-UE-ContextReferenceAtSgNB" },
  { id_SecondaryRATUsageReport, "id-SecondaryRATUsageReport" },
  { id_ActivationID, "id-ActivationID" },
  { id_MeNBResourceCoordinationInformation, "id-MeNBResourceCoordinationInformation" },
  { id_SgNBResourceCoordinationInformation, "id-SgNBResourceCoordinationInformation" },
  { id_ServedEUTRAcellsToModifyListENDCConfUpd, "id-ServedEUTRAcellsToModifyListENDCConfUpd" },
  { id_ServedEUTRAcellsToDeleteListENDCConfUpd, "id-ServedEUTRAcellsToDeleteListENDCConfUpd" },
  { id_ServedNRcellsToModifyListENDCConfUpd, "id-ServedNRcellsToModifyListENDCConfUpd" },
  { id_ServedNRcellsToDeleteListENDCConfUpd, "id-ServedNRcellsToDeleteListENDCConfUpd" },
  { id_E_RABUsageReport_Item, "id-E-RABUsageReport-Item" },
  { id_Old_SgNB_UE_X2AP_ID, "id-Old-SgNB-UE-X2AP-ID" },
  { id_SecondaryRATUsageReportList, "id-SecondaryRATUsageReportList" },
  { id_SecondaryRATUsageReport_Item, "id-SecondaryRATUsageReport-Item" },
  { id_ServedNRCellsToActivate, "id-ServedNRCellsToActivate" },
  { id_ActivatedNRCellList, "id-ActivatedNRCellList" },
  { id_SelectedPLMN, "id-SelectedPLMN" },
  { id_UEs_ToBeReset, "id-UEs-ToBeReset" },
  { id_UEs_Admitted_ToBeReset, "id-UEs-Admitted-ToBeReset" },
  { id_RRCConfigIndication, "id-RRCConfigIndication" },
  { id_DownlinkPacketLossRate, "id-DownlinkPacketLossRate" },
  { id_UplinkPacketLossRate, "id-UplinkPacketLossRate" },
  { id_SubscriberProfileIDforRFP, "id-SubscriberProfileIDforRFP" },
  { id_serviceType, "id-serviceType" },
  { id_AerialUEsubscriptionInformation, "id-AerialUEsubscriptionInformation" },
  { id_SGNB_Addition_Trigger_Ind, "id-SGNB-Addition-Trigger-Ind" },
  { id_MeNBCell_ID, "id-MeNBCell-ID" },
  { id_RequestedSplitSRBsrelease, "id-RequestedSplitSRBsrelease" },
  { id_AdmittedSplitSRBsrelease, "id-AdmittedSplitSRBsrelease" },
  { id_NRS_NSSS_PowerOffset, "id-NRS-NSSS-PowerOffset" },
  { id_NSSS_NumOccasionDifferentPrecoder, "id-NSSS-NumOccasionDifferentPrecoder" },
  { id_ProtectedEUTRAResourceIndication, "id-ProtectedEUTRAResourceIndication" },
  { id_InitiatingNodeType_EutranrCellResourceCoordination, "id-InitiatingNodeType-EutranrCellResourceCoordination" },
  { id_RespondingNodeType_EutranrCellResourceCoordination, "id-RespondingNodeType-EutranrCellResourceCoordination" },
  { id_DataTrafficResourceIndication, "id-DataTrafficResourceIndication" },
  { id_SpectrumSharingGroupID, "id-SpectrumSharingGroupID" },
  { id_ListofEUTRACellsinEUTRACoordinationReq, "id-ListofEUTRACellsinEUTRACoordinationReq" },
  { id_ListofEUTRACellsinEUTRACoordinationResp, "id-ListofEUTRACellsinEUTRACoordinationResp" },
  { id_ListofEUTRACellsinNRCoordinationReq, "id-ListofEUTRACellsinNRCoordinationReq" },
  { id_ListofNRCellsinNRCoordinationReq, "id-ListofNRCellsinNRCoordinationReq" },
  { id_ListofNRCellsinNRCoordinationResp, "id-ListofNRCellsinNRCoordinationResp" },
  { id_E_RABs_AdmittedToBeModified_SgNBModConfList, "id-E-RABs-AdmittedToBeModified-SgNBModConfList" },
  { id_E_RABs_AdmittedToBeModified_SgNBModConf_Item, "id-E-RABs-AdmittedToBeModified-SgNBModConf-Item" },
  { id_UEContextLevelUserPlaneActivity, "id-UEContextLevelUserPlaneActivity" },
  { id_ERABActivityNotifyItemList, "id-ERABActivityNotifyItemList" },
  { id_InitiatingNodeType_EndcX2Removal, "id-InitiatingNodeType-EndcX2Removal" },
  { id_RespondingNodeType_EndcX2Removal, "id-RespondingNodeType-EndcX2Removal" },
  { id_RLC_Status, "id-RLC-Status" },
  { id_CNTypeRestrictions, "id-CNTypeRestrictions" },
  { id_uLpDCPSnLength, "id-uLpDCPSnLength" },
  { id_BluetoothMeasurementConfiguration, "id-BluetoothMeasurementConfiguration" },
  { id_WLANMeasurementConfiguration, "id-WLANMeasurementConfiguration" },
  { id_NRrestrictionin5GS, "id-NRrestrictionin5GS" },
  { id_dL_Forwarding, "id-dL-Forwarding" },
  { id_E_RABs_DataForwardingAddress_List, "id-E-RABs-DataForwardingAddress-List" },
  { id_E_RABs_DataForwardingAddress_Item, "id-E-RABs-DataForwardingAddress-Item" },
  { id_Subscription_Based_UE_DifferentiationInfo, "id-Subscription-Based-UE-DifferentiationInfo" },
  { id_GNBOverloadInformation, "id-GNBOverloadInformation" },
  { id_dLPDCPSnLength, "id-dLPDCPSnLength" },
  { id_secondarysgNBDLGTPTEIDatPDCP, "id-secondarysgNBDLGTPTEIDatPDCP" },
  { id_secondarymeNBULGTPTEIDatPDCP, "id-secondarymeNBULGTPTEIDatPDCP" },
  { id_lCID, "id-lCID" },
  { id_duplicationActivation, "id-duplicationActivation" },
  { id_ECGI, "id-ECGI" },
  { id_RLCMode_transferred, "id-RLCMode-transferred" },
  { id_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList, "id-E-RABs-Admitted-ToBeReleased-SgNBRelReqAckList" },
  { id_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item, "id-E-RABs-Admitted-ToBeReleased-SgNBRelReqAck-Item" },
  { id_E_RABs_ToBeReleased_SgNBRelReqdList, "id-E-RABs-ToBeReleased-SgNBRelReqdList" },
  { id_E_RABs_ToBeReleased_SgNBRelReqd_Item, "id-E-RABs-ToBeReleased-SgNBRelReqd-Item" },
  { id_NRCGI, "id-NRCGI" },
  { id_MeNBCoordinationAssistanceInformation, "id-MeNBCoordinationAssistanceInformation" },
  { id_SgNBCoordinationAssistanceInformation, "id-SgNBCoordinationAssistanceInformation" },
  { id_new_drb_ID_req, "id-new-drb-ID-req" },
  { id_endcSONConfigurationTransfer, "id-endcSONConfigurationTransfer" },
  { id_NRNeighbourInfoToAdd, "id-NRNeighbourInfoToAdd" },
  { id_NRNeighbourInfoToModify, "id-NRNeighbourInfoToModify" },
  { id_DesiredActNotificationLevel, "id-DesiredActNotificationLevel" },
  { id_LocationInformationSgNBReporting, "id-LocationInformationSgNBReporting" },
  { id_LocationInformationSgNB, "id-LocationInformationSgNB" },
  { id_LastNG_RANPLMNIdentity, "id-LastNG-RANPLMNIdentity" },
  { id_EUTRANTraceID, "id-EUTRANTraceID" },
  { id_additionalPLMNs_Item, "id-additionalPLMNs-Item" },
  { id_InterfaceInstanceIndication, "id-InterfaceInstanceIndication" },
  { id_BPLMN_ID_Info_EUTRA, "id-BPLMN-ID-Info-EUTRA" },
  { id_BPLMN_ID_Info_NR, "id-BPLMN-ID-Info-NR" },
  { id_NBIoT_UL_DL_AlignmentOffset, "id-NBIoT-UL-DL-AlignmentOffset" },
  { id_ERABs_transferred_to_MeNB, "id-ERABs-transferred-to-MeNB" },
  { id_AdditionalRRMPriorityIndex, "id-AdditionalRRMPriorityIndex" },
  { id_LowerLayerPresenceStatusChange, "id-LowerLayerPresenceStatusChange" },
  { id_FastMCGRecovery_SN_to_MN, "id-FastMCGRecovery-SN-to-MN" },
  { id_RequestedFastMCGRecoveryViaSRB3, "id-RequestedFastMCGRecoveryViaSRB3" },
  { id_AvailableFastMCGRecoveryViaSRB3, "id-AvailableFastMCGRecoveryViaSRB3" },
  { id_RequestedFastMCGRecoveryViaSRB3Release, "id-RequestedFastMCGRecoveryViaSRB3Release" },
  { id_ReleaseFastMCGRecoveryViaSRB3, "id-ReleaseFastMCGRecoveryViaSRB3" },
  { id_FastMCGRecovery_MN_to_SN, "id-FastMCGRecovery-MN-to-SN" },
  { id_PartialListIndicator, "id-PartialListIndicator" },
  { id_MaximumCellListSize, "id-MaximumCellListSize" },
  { id_MessageOversizeNotification, "id-MessageOversizeNotification" },
  { id_CellandCapacityAssistInfo, "id-CellandCapacityAssistInfo" },
  { id_TNLConfigurationInfo, "id-TNLConfigurationInfo" },
  { id_TNLA_To_Add_List, "id-TNLA-To-Add-List" },
  { id_TNLA_To_Update_List, "id-TNLA-To-Update-List" },
  { id_TNLA_To_Remove_List, "id-TNLA-To-Remove-List" },
  { id_TNLA_Setup_List, "id-TNLA-Setup-List" },
  { id_TNLA_Failed_To_Setup_List, "id-TNLA-Failed-To-Setup-List" },
  { id_UnlicensedSpectrumRestriction, "id-UnlicensedSpectrumRestriction" },
  { id_UEContextReferenceatSourceNGRAN, "id-UEContextReferenceatSourceNGRAN" },
  { id_EPCHandoverRestrictionListContainer, "id-EPCHandoverRestrictionListContainer" },
  { id_CHOinformation_REQ, "id-CHOinformation-REQ" },
  { id_CHOinformation_ACK, "id-CHOinformation-ACK" },
  { id_DAPSRequestInfo, "id-DAPSRequestInfo" },
  { id_RequestedTargetCellID, "id-RequestedTargetCellID" },
  { id_CandidateCellsToBeCancelledList, "id-CandidateCellsToBeCancelledList" },
  { id_DAPSResponseInfo, "id-DAPSResponseInfo" },
  { id_ProcedureStage, "id-ProcedureStage" },
  { id_CHO_DC_Indicator, "id-CHO-DC-Indicator" },
  { id_Ethernet_Type, "id-Ethernet-Type" },
  { id_NRV2XServicesAuthorized, "id-NRV2XServicesAuthorized" },
  { id_NRUESidelinkAggregateMaximumBitRate, "id-NRUESidelinkAggregateMaximumBitRate" },
  { id_PC5QoSParameters, "id-PC5QoSParameters" },
  { id_NPRACHConfiguration, "id-NPRACHConfiguration" },
  { id_NBIoT_RLF_Report_Container, "id-NBIoT-RLF-Report-Container" },
  { id_MDTConfigurationNR, "id-MDTConfigurationNR" },
  { id_PrivacyIndicator, "id-PrivacyIndicator" },
  { id_TraceCollectionEntityIPAddress, "id-TraceCollectionEntityIPAddress" },
  { id_UERadioCapabilityID, "id-UERadioCapabilityID" },
  { id_SNtriggered, "id-SNtriggered" },
  { id_CSI_RSTransmissionIndication, "id-CSI-RSTransmissionIndication" },
  { id_DLCarrierList, "id-DLCarrierList" },
  { id_TargetCellInNGRAN, "id-TargetCellInNGRAN" },
  { id_E_UTRAN_Node1_Measurement_ID, "id-E-UTRAN-Node1-Measurement-ID" },
  { id_E_UTRAN_Node2_Measurement_ID, "id-E-UTRAN-Node2-Measurement-ID" },
  { id_TDDULDLConfigurationCommonNR, "id-TDDULDLConfigurationCommonNR" },
  { id_CarrierList, "id-CarrierList" },
  { id_ULCarrierList, "id-ULCarrierList" },
  { id_FrequencyShift7p5khz, "id-FrequencyShift7p5khz" },
  { id_SSB_PositionsInBurst, "id-SSB-PositionsInBurst" },
  { id_NRCellPRACHConfig, "id-NRCellPRACHConfig" },
  { id_CellToReport_NR_ENDC, "id-CellToReport-NR-ENDC" },
  { id_CellToReport_NR_ENDC_Item, "id-CellToReport-NR-ENDC-Item" },
  { id_CellMeasurementResult_NR_ENDC, "id-CellMeasurementResult-NR-ENDC" },
  { id_CellMeasurementResult_NR_ENDC_Item, "id-CellMeasurementResult-NR-ENDC-Item" },
  { id_IABNodeIndication, "id-IABNodeIndication" },
  { id_QoS_Mapping_Information, "id-QoS-Mapping-Information" },
  { id_F1CTrafficContainer, "id-F1CTrafficContainer" },
  { id_Unknown_398, "id-Unknown-398" },
  { id_IntendedTDD_DL_ULConfiguration_NR, "id-IntendedTDD-DL-ULConfiguration-NR" },
  { id_UERadioCapability, "id-UERadioCapability" },
  { id_CellMeasurementResult_E_UTRA_ENDC, "id-CellMeasurementResult-E-UTRA-ENDC" },
  { id_CellMeasurementResult_E_UTRA_ENDC_Item, "id-CellMeasurementResult-E-UTRA-ENDC-Item" },
  { id_CellToReport_E_UTRA_ENDC, "id-CellToReport-E-UTRA-ENDC" },
  { id_CellToReport_E_UTRA_ENDC_Item, "id-CellToReport-E-UTRA-ENDC-Item" },
  { id_TraceCollectionEntityURI, "id-TraceCollectionEntityURI" },
  { id_SFN_Offset, "id-SFN-Offset" },
  { id_CHO_DC_EarlyDataForwarding, "id-CHO-DC-EarlyDataForwarding" },
  { id_IMSvoiceEPSfallbackfrom5G, "id-IMSvoiceEPSfallbackfrom5G" },
  { id_AdditionLocationInformation, "id-AdditionLocationInformation" },
  { id_DirectForwardingPathAvailability, "id-DirectForwardingPathAvailability" },
  { id_sourceNG_RAN_node_id, "id-sourceNG-RAN-node-id" },
  { id_SourceDLForwardingIPAddress, "id-SourceDLForwardingIPAddress" },
  { id_SourceNodeDLForwardingIPAddress, "id-SourceNodeDLForwardingIPAddress" },
  { 0, NULL }
};

static value_string_ext x2ap_ProtocolIE_ID_vals_ext = VALUE_STRING_EXT_INIT(x2ap_ProtocolIE_ID_vals);


static int
dissect_x2ap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 68 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxProtocolIEs, &x2ap_data->protocol_ie_id, FALSE);



#line 71 "./asn1/x2ap/x2ap.cnf"
  if (tree) {
    proto_item_append_text(proto_item_get_parent_nth(actx->created_item, 2), ": %s", val_to_str_ext(x2ap_data->protocol_ie_id, &x2ap_ProtocolIE_ID_vals_ext, "unknown (%d)"));
  }

  return offset;
}


static const value_string x2ap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  { 0, NULL }
};


static int
dissect_x2ap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_ProtocolIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_x2ap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_ID },
  { &hf_x2ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Criticality },
  { &hf_x2ap_protocolIE_Field_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_x2ap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Field },
};

static int
dissect_x2ap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs, FALSE);

  return offset;
}



static int
dissect_x2ap_ProtocolIE_Single_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_x2ap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_x2ap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_x2ap_extension_id   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_ID },
  { &hf_x2ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Criticality },
  { &hf_x2ap_extensionValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_x2ap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolExtensionField },
};

static int
dissect_x2ap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions, FALSE);

  return offset;
}



static int
dissect_x2ap_PrivateIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_x2ap_private_id     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PrivateIE_ID },
  { &hf_x2ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Criticality },
  { &hf_x2ap_privateIE_Field_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PrivateIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_x2ap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PrivateIE_Field },
};

static int
dissect_x2ap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs, FALSE);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_40(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     40, 40, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_T_numberOfCellSpecificAntennaPorts_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "four" },
  { 0, NULL }
};


static int
dissect_x2ap_T_numberOfCellSpecificAntennaPorts(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ABSInformationFDD_sequence[] = {
  { &hf_x2ap_abs_pattern_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_40 },
  { &hf_x2ap_numberOfCellSpecificAntennaPorts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_numberOfCellSpecificAntennaPorts },
  { &hf_x2ap_measurement_subset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_40 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ABSInformationFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ABSInformationFDD, ABSInformationFDD_sequence);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_1_70_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 70, TRUE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_T_numberOfCellSpecificAntennaPorts_01_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "four" },
  { 0, NULL }
};


static int
dissect_x2ap_T_numberOfCellSpecificAntennaPorts_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ABSInformationTDD_sequence[] = {
  { &hf_x2ap_abs_pattern_info_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_1_70_ },
  { &hf_x2ap_numberOfCellSpecificAntennaPorts_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_numberOfCellSpecificAntennaPorts_01 },
  { &hf_x2ap_measurement_subset_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_1_70_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ABSInformationTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ABSInformationTDD, ABSInformationTDD_sequence);

  return offset;
}



static int
dissect_x2ap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string x2ap_ABSInformation_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  {   2, "abs-inactive" },
  { 0, NULL }
};

static const per_choice_t ABSInformation_choice[] = {
  {   0, &hf_x2ap_fdd            , ASN1_EXTENSION_ROOT    , dissect_x2ap_ABSInformationFDD },
  {   1, &hf_x2ap_tdd            , ASN1_EXTENSION_ROOT    , dissect_x2ap_ABSInformationTDD },
  {   2, &hf_x2ap_abs_inactive   , ASN1_EXTENSION_ROOT    , dissect_x2ap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_ABSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_ABSInformation, ABSInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_DL_ABS_status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t UsableABSInformationFDD_sequence[] = {
  { &hf_x2ap_usable_abs_pattern_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_40 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UsableABSInformationFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UsableABSInformationFDD, UsableABSInformationFDD_sequence);

  return offset;
}


static const per_sequence_t UsableABSInformationTDD_sequence[] = {
  { &hf_x2ap_usaable_abs_pattern_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_1_70_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UsableABSInformationTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UsableABSInformationTDD, UsableABSInformationTDD_sequence);

  return offset;
}


static const value_string x2ap_UsableABSInformation_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  { 0, NULL }
};

static const per_choice_t UsableABSInformation_choice[] = {
  {   0, &hf_x2ap_fdd_03         , ASN1_EXTENSION_ROOT    , dissect_x2ap_UsableABSInformationFDD },
  {   1, &hf_x2ap_tdd_03         , ASN1_EXTENSION_ROOT    , dissect_x2ap_UsableABSInformationTDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_UsableABSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_UsableABSInformation, UsableABSInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ABS_Status_sequence[] = {
  { &hf_x2ap_dL_ABS_status  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DL_ABS_status },
  { &hf_x2ap_usableABSInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UsableABSInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ABS_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ABS_Status, ABS_Status_sequence);

  return offset;
}



static int
dissect_x2ap_ActivationID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_AdditionLocationInformation_vals[] = {
  {   0, "includePSCell" },
  { 0, NULL }
};


static int
dissect_x2ap_AdditionLocationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_AdditionalRRMPriorityIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_AdditionalSpecialSubframePatterns_vals[] = {
  {   0, "ssp0" },
  {   1, "ssp1" },
  {   2, "ssp2" },
  {   3, "ssp3" },
  {   4, "ssp4" },
  {   5, "ssp5" },
  {   6, "ssp6" },
  {   7, "ssp7" },
  {   8, "ssp8" },
  {   9, "ssp9" },
  { 0, NULL }
};


static int
dissect_x2ap_AdditionalSpecialSubframePatterns(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_CyclicPrefixDL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_x2ap_CyclicPrefixDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_CyclicPrefixUL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_x2ap_CyclicPrefixUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t AdditionalSpecialSubframe_Info_sequence[] = {
  { &hf_x2ap_additionalspecialSubframePatterns, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_AdditionalSpecialSubframePatterns },
  { &hf_x2ap_cyclicPrefixDL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CyclicPrefixDL },
  { &hf_x2ap_cyclicPrefixUL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CyclicPrefixUL },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_AdditionalSpecialSubframe_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_AdditionalSpecialSubframe_Info, AdditionalSpecialSubframe_Info_sequence);

  return offset;
}


static const value_string x2ap_AdditionalSpecialSubframePatternsExtension_vals[] = {
  {   0, "ssp10" },
  { 0, NULL }
};


static int
dissect_x2ap_AdditionalSpecialSubframePatternsExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t AdditionalSpecialSubframeExtension_Info_sequence[] = {
  { &hf_x2ap_additionalspecialSubframePatternsExtension, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_AdditionalSpecialSubframePatternsExtension },
  { &hf_x2ap_cyclicPrefixDL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CyclicPrefixDL },
  { &hf_x2ap_cyclicPrefixUL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CyclicPrefixUL },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_AdditionalSpecialSubframeExtension_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_AdditionalSpecialSubframeExtension_Info, AdditionalSpecialSubframeExtension_Info_sequence);

  return offset;
}


static const value_string x2ap_AvailableFastMCGRecoveryViaSRB3_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_AvailableFastMCGRecoveryViaSRB3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_AerialUEsubscriptionInformation_vals[] = {
  {   0, "allowed" },
  {   1, "not-allowed" },
  { 0, NULL }
};


static int
dissect_x2ap_AerialUEsubscriptionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_PriorityLevel_vals[] = {
  {   0, "spare" },
  {   1, "highest" },
  {  14, "lowest" },
  {  15, "no-priority" },
  { 0, NULL }
};


static int
dissect_x2ap_PriorityLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_Pre_emptionCapability_vals[] = {
  {   0, "shall-not-trigger-pre-emption" },
  {   1, "may-trigger-pre-emption" },
  { 0, NULL }
};


static int
dissect_x2ap_Pre_emptionCapability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string x2ap_Pre_emptionVulnerability_vals[] = {
  {   0, "not-pre-emptable" },
  {   1, "pre-emptable" },
  { 0, NULL }
};


static int
dissect_x2ap_Pre_emptionVulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationAndRetentionPriority_sequence[] = {
  { &hf_x2ap_priorityLevel  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PriorityLevel },
  { &hf_x2ap_pre_emptionCapability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Pre_emptionCapability },
  { &hf_x2ap_pre_emptionVulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Pre_emptionVulnerability },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_AllocationAndRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_AllocationAndRetentionPriority, AllocationAndRetentionPriority_sequence);

  return offset;
}



static int
dissect_x2ap_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 418 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  e212_number_type_t number_type = x2ap_data->number_type;
  x2ap_data->number_type = E212_NONE;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, &parameter_tvb);


  if(tvb_reported_length(tvb)==0)
    return offset;

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_PLMN_Identity);
  dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, number_type, FALSE);



  return offset;
}



static int
dissect_x2ap_EUTRANCellIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t ECGI_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_eUTRANcellIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EUTRANCellIdentifier },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ECGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 376 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  x2ap_data->number_type = E212_ECGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ECGI, ECGI_sequence);




  return offset;
}


static const per_sequence_t CellIdListforMDT_sequence_of[1] = {
  { &hf_x2ap_CellIdListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_CellIdListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellIdListforMDT, CellIdListforMDT_sequence_of,
                                                  1, maxnoofCellIDforMDT, FALSE);

  return offset;
}


static const per_sequence_t CellBasedMDT_sequence[] = {
  { &hf_x2ap_cellIdListforMDT, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CellIdListforMDT },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellBasedMDT, CellBasedMDT_sequence);

  return offset;
}



static int
dissect_x2ap_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 393 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t TAListforMDT_sequence_of[1] = {
  { &hf_x2ap_TAListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TAC },
};

static int
dissect_x2ap_TAListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TAListforMDT, TAListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, FALSE);

  return offset;
}


static const per_sequence_t TABasedMDT_sequence[] = {
  { &hf_x2ap_tAListforMDT   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TAListforMDT },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TABasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TABasedMDT, TABasedMDT_sequence);

  return offset;
}


static const per_sequence_t TAI_Item_sequence[] = {
  { &hf_x2ap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TAC },
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 386 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  x2ap_data->number_type = E212_TAI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TAI_Item, TAI_Item_sequence);




  return offset;
}


static const per_sequence_t TAIListforMDT_sequence_of[1] = {
  { &hf_x2ap_TAIListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TAI_Item },
};

static int
dissect_x2ap_TAIListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TAIListforMDT, TAIListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, FALSE);

  return offset;
}


static const per_sequence_t TAIBasedMDT_sequence[] = {
  { &hf_x2ap_tAIListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TAIListforMDT },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TAIBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TAIBasedMDT, TAIBasedMDT_sequence);

  return offset;
}


static const value_string x2ap_AreaScopeOfMDT_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "pLMNWide" },
  {   3, "tAIBased" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfMDT_choice[] = {
  {   0, &hf_x2ap_cellBased      , ASN1_EXTENSION_ROOT    , dissect_x2ap_CellBasedMDT },
  {   1, &hf_x2ap_tABased        , ASN1_EXTENSION_ROOT    , dissect_x2ap_TABasedMDT },
  {   2, &hf_x2ap_pLMNWide       , ASN1_EXTENSION_ROOT    , dissect_x2ap_NULL },
  {   3, &hf_x2ap_tAIBased       , ASN1_NOT_EXTENSION_ROOT, dissect_x2ap_TAIBasedMDT },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_AreaScopeOfMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_AreaScopeOfMDT, AreaScopeOfMDT_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellIdListforQMC_sequence_of[1] = {
  { &hf_x2ap_CellIdListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_CellIdListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellIdListforQMC, CellIdListforQMC_sequence_of,
                                                  1, maxnoofCellIDforQMC, FALSE);

  return offset;
}


static const per_sequence_t CellBasedQMC_sequence[] = {
  { &hf_x2ap_cellIdListforQMC, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CellIdListforQMC },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellBasedQMC, CellBasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAListforQMC_sequence_of[1] = {
  { &hf_x2ap_TAListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TAC },
};

static int
dissect_x2ap_TAListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TAListforQMC, TAListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, FALSE);

  return offset;
}


static const per_sequence_t TABasedQMC_sequence[] = {
  { &hf_x2ap_tAListforQMC   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TAListforQMC },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TABasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TABasedQMC, TABasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAIListforQMC_sequence_of[1] = {
  { &hf_x2ap_TAIListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TAI_Item },
};

static int
dissect_x2ap_TAIListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TAIListforQMC, TAIListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, FALSE);

  return offset;
}


static const per_sequence_t TAIBasedQMC_sequence[] = {
  { &hf_x2ap_tAIListforQMC  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TAIListforQMC },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TAIBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TAIBasedQMC, TAIBasedQMC_sequence);

  return offset;
}


static const per_sequence_t PLMNListforQMC_sequence_of[1] = {
  { &hf_x2ap_PLMNListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
};

static int
dissect_x2ap_PLMNListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_PLMNListforQMC, PLMNListforQMC_sequence_of,
                                                  1, maxnoofPLMNforQMC, FALSE);

  return offset;
}


static const per_sequence_t PLMNAreaBasedQMC_sequence[] = {
  { &hf_x2ap_plmnListforQMC , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMNListforQMC },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_PLMNAreaBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_PLMNAreaBasedQMC, PLMNAreaBasedQMC_sequence);

  return offset;
}


static const value_string x2ap_AreaScopeOfQMC_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "pLMNAreaBased" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfQMC_choice[] = {
  {   0, &hf_x2ap_cellBased_01   , ASN1_EXTENSION_ROOT    , dissect_x2ap_CellBasedQMC },
  {   1, &hf_x2ap_tABased_01     , ASN1_EXTENSION_ROOT    , dissect_x2ap_TABasedQMC },
  {   2, &hf_x2ap_tAIBased_01    , ASN1_EXTENSION_ROOT    , dissect_x2ap_TAIBasedQMC },
  {   3, &hf_x2ap_pLMNAreaBased  , ASN1_EXTENSION_ROOT    , dissect_x2ap_PLMNAreaBasedQMC },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_AreaScopeOfQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_AreaScopeOfQMC, AreaScopeOfQMC_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_Key_eNodeB_Star(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_NextHopChainingCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t AS_SecurityInformation_sequence[] = {
  { &hf_x2ap_key_eNodeB_star, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Key_eNodeB_Star },
  { &hf_x2ap_nextHopChainingCount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NextHopChainingCount },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_AS_SecurityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_AS_SecurityInformation, AS_SecurityInformation_sequence);

  return offset;
}


static const per_sequence_t AdditionalPLMNs_Item_sequence_of[1] = {
  { &hf_x2ap_AdditionalPLMNs_Item_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
};

static int
dissect_x2ap_AdditionalPLMNs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_AdditionalPLMNs_Item, AdditionalPLMNs_Item_sequence_of,
                                                  1, maxnoofAdditionalPLMNs, FALSE);

  return offset;
}


static const value_string x2ap_BandwidthReducedSI_vals[] = {
  {   0, "scheduled" },
  { 0, NULL }
};


static int
dissect_x2ap_BandwidthReducedSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_BearerType_vals[] = {
  {   0, "non-IP" },
  { 0, NULL }
};


static int
dissect_x2ap_BearerType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_BenefitMetric(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -101, 100U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_BitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(10000000000), NULL, FALSE);

  return offset;
}


static const per_sequence_t BroadcastPLMNs_Item_sequence_of[1] = {
  { &hf_x2ap_BroadcastPLMNs_Item_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
};

static int
dissect_x2ap_BroadcastPLMNs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_BroadcastPLMNs_Item, BroadcastPLMNs_Item_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}


static const value_string x2ap_BluetoothMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_x2ap_BluetoothMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_BluetoothName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 676 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 248, FALSE, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);


  return offset;
}


static const per_sequence_t BluetoothMeasConfigNameList_sequence_of[1] = {
  { &hf_x2ap_BluetoothMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_BluetoothName },
};

static int
dissect_x2ap_BluetoothMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_BluetoothMeasConfigNameList, BluetoothMeasConfigNameList_sequence_of,
                                                  1, maxnoofBluetoothName, FALSE);

  return offset;
}


static const value_string x2ap_T_bt_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_T_bt_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t BluetoothMeasurementConfiguration_sequence[] = {
  { &hf_x2ap_bluetoothMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BluetoothMeasConfig },
  { &hf_x2ap_bluetoothMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BluetoothMeasConfigNameList },
  { &hf_x2ap_bt_rssi        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_bt_rssi },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_BluetoothMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_BluetoothMeasurementConfiguration, BluetoothMeasurementConfiguration_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_EUTRA_Item_sequence[] = {
  { &hf_x2ap_broadcastPLMNs , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BroadcastPLMNs_Item },
  { &hf_x2ap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TAC },
  { &hf_x2ap_e_utraCI       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EUTRANCellIdentifier },
  { &hf_x2ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_BPLMN_ID_Info_EUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_BPLMN_ID_Info_EUTRA_Item, BPLMN_ID_Info_EUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_EUTRA_sequence_of[1] = {
  { &hf_x2ap_BPLMN_ID_Info_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_BPLMN_ID_Info_EUTRA_Item },
};

static int
dissect_x2ap_BPLMN_ID_Info_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_BPLMN_ID_Info_EUTRA, BPLMN_ID_Info_EUTRA_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}


static const per_sequence_t BroadcastextPLMNs_sequence_of[1] = {
  { &hf_x2ap_BroadcastextPLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
};

static int
dissect_x2ap_BroadcastextPLMNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_BroadcastextPLMNs, BroadcastextPLMNs_sequence_of,
                                                  1, maxnoofextBPLMNs, FALSE);

  return offset;
}



static int
dissect_x2ap_FiveGS_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 411 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       3, 3, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 3, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_x2ap_NRCellIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_NR_Item_sequence[] = {
  { &hf_x2ap_broadcastPLMNs_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BroadcastextPLMNs },
  { &hf_x2ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_FiveGS_TAC },
  { &hf_x2ap_nr_CI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCellIdentifier },
  { &hf_x2ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_BPLMN_ID_Info_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_BPLMN_ID_Info_NR_Item, BPLMN_ID_Info_NR_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_NR_sequence_of[1] = {
  { &hf_x2ap_BPLMN_ID_Info_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_BPLMN_ID_Info_NR_Item },
};

static int
dissect_x2ap_BPLMN_ID_Info_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_BPLMN_ID_Info_NR, BPLMN_ID_Info_NR_sequence_of,
                                                  1, maxnoofextBPLMNs, FALSE);

  return offset;
}



static int
dissect_x2ap_CapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_CauseRadioNetwork_vals[] = {
  {   0, "handover-desirable-for-radio-reasons" },
  {   1, "time-critical-handover" },
  {   2, "resource-optimisation-handover" },
  {   3, "reduce-load-in-serving-cell" },
  {   4, "partial-handover" },
  {   5, "unknown-new-eNB-UE-X2AP-ID" },
  {   6, "unknown-old-eNB-UE-X2AP-ID" },
  {   7, "unknown-pair-of-UE-X2AP-ID" },
  {   8, "ho-target-not-allowed" },
  {   9, "tx2relocoverall-expiry" },
  {  10, "trelocprep-expiry" },
  {  11, "cell-not-available" },
  {  12, "no-radio-resources-available-in-target-cell" },
  {  13, "invalid-MME-GroupID" },
  {  14, "unknown-MME-Code" },
  {  15, "encryption-and-or-integrity-protection-algorithms-not-supported" },
  {  16, "reportCharacteristicsEmpty" },
  {  17, "noReportPeriodicity" },
  {  18, "existingMeasurementID" },
  {  19, "unknown-eNB-Measurement-ID" },
  {  20, "measurement-temporarily-not-available" },
  {  21, "unspecified" },
  {  22, "load-balancing" },
  {  23, "handover-optimisation" },
  {  24, "value-out-of-allowed-range" },
  {  25, "multiple-E-RAB-ID-instances" },
  {  26, "switch-off-ongoing" },
  {  27, "not-supported-QCI-value" },
  {  28, "measurement-not-supported-for-the-object" },
  {  29, "tDCoverall-expiry" },
  {  30, "tDCprep-expiry" },
  {  31, "action-desirable-for-radio-reasons" },
  {  32, "reduce-load" },
  {  33, "resource-optimisation" },
  {  34, "time-critical-action" },
  {  35, "target-not-allowed" },
  {  36, "no-radio-resources-available" },
  {  37, "invalid-QoS-combination" },
  {  38, "encryption-algorithms-not-supported" },
  {  39, "procedure-cancelled" },
  {  40, "rRM-purpose" },
  {  41, "improve-user-bit-rate" },
  {  42, "user-inactivity" },
  {  43, "radio-connection-with-UE-lost" },
  {  44, "failure-in-the-radio-interface-procedure" },
  {  45, "bearer-option-not-supported" },
  {  46, "mCG-Mobility" },
  {  47, "sCG-Mobility" },
  {  48, "count-reaches-max-value" },
  {  49, "unknown-old-en-gNB-UE-X2AP-ID" },
  {  50, "pDCP-Overload" },
  {  51, "cho-cpc-resources-tobechanged" },
  {  52, "ue-power-saving" },
  {  53, "insufficient-ue-capabilities" },
  {  54, "normal-release" },
  {  55, "unknown-E-UTRAN-Node-Measurement-ID" },
  { 0, NULL }
};

static value_string_ext x2ap_CauseRadioNetwork_vals_ext = VALUE_STRING_EXT_INIT(x2ap_CauseRadioNetwork_vals);


static int
dissect_x2ap_CauseRadioNetwork(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     22, NULL, TRUE, 34, NULL);

  return offset;
}


static const value_string x2ap_CauseTransport_vals[] = {
  {   0, "transport-resource-unavailable" },
  {   1, "unspecified" },
  { 0, NULL }
};


static int
dissect_x2ap_CauseTransport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "unspecified" },
  {   6, "abstract-syntax-error-falsely-constructed-message" },
  { 0, NULL }
};


static int
dissect_x2ap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "hardware-failure" },
  {   2, "om-intervention" },
  {   3, "not-enough-user-plane-processing-resources" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_x2ap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_x2ap_radioNetwork   , ASN1_EXTENSION_ROOT    , dissect_x2ap_CauseRadioNetwork },
  {   1, &hf_x2ap_transport      , ASN1_EXTENSION_ROOT    , dissect_x2ap_CauseTransport },
  {   2, &hf_x2ap_protocol       , ASN1_EXTENSION_ROOT    , dissect_x2ap_CauseProtocol },
  {   3, &hf_x2ap_misc           , ASN1_EXTENSION_ROOT    , dissect_x2ap_CauseMisc },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_Cause, Cause_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_CellCapacityClassValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_CellDeploymentStatusIndicator_vals[] = {
  {   0, "pre-change-notification" },
  { 0, NULL }
};


static int
dissect_x2ap_CellDeploymentStatusIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ReplacingCellsList_Item_sequence[] = {
  { &hf_x2ap_eCGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ReplacingCellsList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ReplacingCellsList_Item, ReplacingCellsList_Item_sequence);

  return offset;
}


static const per_sequence_t ReplacingCellsList_sequence_of[1] = {
  { &hf_x2ap_ReplacingCellsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ReplacingCellsList_Item },
};

static int
dissect_x2ap_ReplacingCellsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ReplacingCellsList, ReplacingCellsList_sequence_of,
                                                  0, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellReplacingInfo_sequence[] = {
  { &hf_x2ap_replacingCellsList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ReplacingCellsList },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellReplacingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellReplacingInfo, CellReplacingInfo_sequence);

  return offset;
}


static const value_string x2ap_CellReportingIndicator_vals[] = {
  {   0, "stop-request" },
  { 0, NULL }
};


static int
dissect_x2ap_CellReportingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_Cell_Size_vals[] = {
  {   0, "verysmall" },
  {   1, "small" },
  {   2, "medium" },
  {   3, "large" },
  { 0, NULL }
};


static int
dissect_x2ap_Cell_Size(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CellType_sequence[] = {
  { &hf_x2ap_cell_Size      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Cell_Size },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellType, CellType_sequence);

  return offset;
}


static const value_string x2ap_CHO_DC_EarlyDataForwarding_vals[] = {
  {   0, "stop" },
  { 0, NULL }
};


static int
dissect_x2ap_CHO_DC_EarlyDataForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_CHO_DC_Indicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_CHO_DC_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_T_cn_type_vals[] = {
  {   0, "fiveGC-forbidden" },
  {   1, "epc-forbidden" },
  { 0, NULL }
};


static int
dissect_x2ap_T_cn_type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 1, NULL);

  return offset;
}


static const per_sequence_t CNTypeRestrictionsItem_sequence[] = {
  { &hf_x2ap_plmn_Id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_cn_type        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_cn_type },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CNTypeRestrictionsItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CNTypeRestrictionsItem, CNTypeRestrictionsItem_sequence);

  return offset;
}


static const per_sequence_t CNTypeRestrictions_sequence_of[1] = {
  { &hf_x2ap_CNTypeRestrictions_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CNTypeRestrictionsItem },
};

static int
dissect_x2ap_CNTypeRestrictions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CNTypeRestrictions, CNTypeRestrictions_sequence_of,
                                                  1, maxnoofEPLMNsPlusOne, FALSE);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_6_4400_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 4400, TRUE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t CoMPHypothesisSetItem_sequence[] = {
  { &hf_x2ap_coMPCellID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_coMPHypothesis , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_6_4400_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CoMPHypothesisSetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CoMPHypothesisSetItem, CoMPHypothesisSetItem_sequence);

  return offset;
}


static const per_sequence_t CoMPHypothesisSet_sequence_of[1] = {
  { &hf_x2ap_CoMPHypothesisSet_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CoMPHypothesisSetItem },
};

static int
dissect_x2ap_CoMPHypothesisSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CoMPHypothesisSet, CoMPHypothesisSet_sequence_of,
                                                  1, maxnoofCoMPCells, FALSE);

  return offset;
}


static const per_sequence_t CoMPInformationItem_item_sequence[] = {
  { &hf_x2ap_coMPHypothesisSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CoMPHypothesisSet },
  { &hf_x2ap_benefitMetric  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BenefitMetric },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CoMPInformationItem_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CoMPInformationItem_item, CoMPInformationItem_item_sequence);

  return offset;
}


static const per_sequence_t CoMPInformationItem_sequence_of[1] = {
  { &hf_x2ap_CoMPInformationItem_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CoMPInformationItem_item },
};

static int
dissect_x2ap_CoMPInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CoMPInformationItem, CoMPInformationItem_sequence_of,
                                                  1, maxnoofCoMPHypothesisSet, FALSE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_1023_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_9_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CoMPInformationStartTime_item_sequence[] = {
  { &hf_x2ap_startSFN       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_1023_ },
  { &hf_x2ap_startSubframeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_9_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CoMPInformationStartTime_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CoMPInformationStartTime_item, CoMPInformationStartTime_item_sequence);

  return offset;
}


static const per_sequence_t CoMPInformationStartTime_sequence_of[1] = {
  { &hf_x2ap_CoMPInformationStartTime_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CoMPInformationStartTime_item },
};

static int
dissect_x2ap_CoMPInformationStartTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CoMPInformationStartTime, CoMPInformationStartTime_sequence_of,
                                                  0, 1, FALSE);

  return offset;
}


static const per_sequence_t CoMPInformation_sequence[] = {
  { &hf_x2ap_coMPInformationItem, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CoMPInformationItem },
  { &hf_x2ap_coMPInformationStartTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CoMPInformationStartTime },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CoMPInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CoMPInformation, CoMPInformation_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacity_sequence[] = {
  { &hf_x2ap_cellCapacityClassValue, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_CellCapacityClassValue },
  { &hf_x2ap_capacityValue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CapacityValue },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CompositeAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CompositeAvailableCapacity, CompositeAvailableCapacity_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacityGroup_sequence[] = {
  { &hf_x2ap_dL_CompositeAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CompositeAvailableCapacity },
  { &hf_x2ap_uL_CompositeAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CompositeAvailableCapacity },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CompositeAvailableCapacityGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CompositeAvailableCapacityGroup, CompositeAvailableCapacityGroup_sequence);

  return offset;
}



static int
dissect_x2ap_Correlation_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, NULL);

  return offset;
}



static int
dissect_x2ap_PDCP_SN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_HFN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, FALSE);

  return offset;
}


static const per_sequence_t COUNTvalue_sequence[] = {
  { &hf_x2ap_pDCP_SN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PDCP_SN },
  { &hf_x2ap_hFN            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_HFN },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_COUNTvalue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_COUNTvalue, COUNTvalue_sequence);

  return offset;
}



static int
dissect_x2ap_PDCP_SNExtended(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_HFNModified(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 131071U, NULL, FALSE);

  return offset;
}


static const per_sequence_t COUNTValueExtended_sequence[] = {
  { &hf_x2ap_pDCP_SNExtended, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PDCP_SNExtended },
  { &hf_x2ap_hFNModified    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_HFNModified },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_COUNTValueExtended(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_COUNTValueExtended, COUNTValueExtended_sequence);

  return offset;
}



static int
dissect_x2ap_PDCP_SNlength18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 262143U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_HFNforPDCP_SNlength18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, FALSE);

  return offset;
}


static const per_sequence_t COUNTvaluePDCP_SNlength18_sequence[] = {
  { &hf_x2ap_pDCP_SNlength18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PDCP_SNlength18 },
  { &hf_x2ap_hFNforPDCP_SNlength18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_HFNforPDCP_SNlength18 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_COUNTvaluePDCP_SNlength18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_COUNTvaluePDCP_SNlength18, COUNTvaluePDCP_SNlength18_sequence);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_15_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CoverageModification_Item_sequence[] = {
  { &hf_x2ap_eCGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_coverageState  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_15_ },
  { &hf_x2ap_cellDeploymentStatusIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_CellDeploymentStatusIndicator },
  { &hf_x2ap_cellReplacingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_CellReplacingInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CoverageModification_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CoverageModification_Item, CoverageModification_Item_sequence);

  return offset;
}


static const per_sequence_t CoverageModificationList_sequence_of[1] = {
  { &hf_x2ap_CoverageModificationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CoverageModification_Item },
};

static int
dissect_x2ap_CoverageModificationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CoverageModificationList, CoverageModificationList_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}



static int
dissect_x2ap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 110 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  int len;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, TRUE, NULL, 0, &parameter_tvb, &len);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_TransportLayerAddress);
  if (len == 32) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_x2ap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
  } else if (len == 128) {
    /* IPv6 */
     proto_tree_add_item(subtree, hf_x2ap_transportLayerAddressIPv6, parameter_tvb, 0, 16, ENC_NA);
  } else if (len == 160) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_x2ap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
    /* IPv6 */
     proto_tree_add_item(subtree, hf_x2ap_transportLayerAddressIPv6, parameter_tvb, 4, 16, ENC_NA);
  }



  return offset;
}



static int
dissect_x2ap_Port_Number(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 135 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t TransportLayerAddressAndPort_sequence[] = {
  { &hf_x2ap_endpointIPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TransportLayerAddress },
  { &hf_x2ap_portnumber     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Port_Number },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TransportLayerAddressAndPort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TransportLayerAddressAndPort, TransportLayerAddressAndPort_sequence);

  return offset;
}


static const value_string x2ap_CPTransportLayerInformation_vals[] = {
  {   0, "endpointIPAddress" },
  {   1, "endpointIPAddressAndPort" },
  { 0, NULL }
};

static const per_choice_t CPTransportLayerInformation_choice[] = {
  {   0, &hf_x2ap_endpointIPAddress, ASN1_EXTENSION_ROOT    , dissect_x2ap_TransportLayerAddress },
  {   1, &hf_x2ap_endpointIPAddressAndPort, ASN1_EXTENSION_ROOT    , dissect_x2ap_TransportLayerAddressAndPort },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_CPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_CPTransportLayerInformation, CPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}


static const value_string x2ap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_x2ap_TypeOfError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_item_sequence[] = {
  { &hf_x2ap_iECriticality  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Criticality },
  { &hf_x2ap_iE_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_ID },
  { &hf_x2ap_typeOfError    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TypeOfError },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CriticalityDiagnostics_IE_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CriticalityDiagnostics_IE_List_item, CriticalityDiagnostics_IE_List_item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_x2ap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CriticalityDiagnostics_IE_List_item },
};

static int
dissect_x2ap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxNrOfErrors, FALSE);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_x2ap_procedureCode  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProcedureCode },
  { &hf_x2ap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_TriggeringMessage },
  { &hf_x2ap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Criticality },
  { &hf_x2ap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_CriticalityDiagnostics_IE_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}



static int
dissect_x2ap_CRNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_CSGMembershipStatus_vals[] = {
  {   0, "member" },
  {   1, "not-member" },
  { 0, NULL }
};


static int
dissect_x2ap_CSGMembershipStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_CSG_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     27, 27, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_UEID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_1_7_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 7U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_INTEGER_1_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_7_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_WidebandCQICodeword1_vals[] = {
  {   0, "four-bitCQI" },
  {   1, "three-bitSpatialDifferentialCQI" },
  { 0, NULL }
};

static const per_choice_t WidebandCQICodeword1_choice[] = {
  {   0, &hf_x2ap_four_bitCQI    , ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_15_ },
  {   1, &hf_x2ap_three_bitSpatialDifferentialCQI, ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_7_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_WidebandCQICodeword1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_WidebandCQICodeword1, WidebandCQICodeword1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t WidebandCQI_sequence[] = {
  { &hf_x2ap_widebandCQICodeword0, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_15_ },
  { &hf_x2ap_widebandCQICodeword1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_WidebandCQICodeword1 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_WidebandCQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_WidebandCQI, WidebandCQI_sequence);

  return offset;
}


static const value_string x2ap_SubbandSize_vals[] = {
  {   0, "size2" },
  {   1, "size3" },
  {   2, "size4" },
  {   3, "size6" },
  {   4, "size8" },
  { 0, NULL }
};


static int
dissect_x2ap_SubbandSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_3_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_SubbandCQICodeword0_vals[] = {
  {   0, "four-bitCQI" },
  {   1, "two-bitSubbandDifferentialCQI" },
  {   2, "two-bitDifferentialCQI" },
  { 0, NULL }
};

static const per_choice_t SubbandCQICodeword0_choice[] = {
  {   0, &hf_x2ap_four_bitCQI    , ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_15_ },
  {   1, &hf_x2ap_two_bitSubbandDifferentialCQI, ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_3_ },
  {   2, &hf_x2ap_two_bitDifferentialCQI, ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_3_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_SubbandCQICodeword0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_SubbandCQICodeword0, SubbandCQICodeword0_choice,
                                 NULL);

  return offset;
}


static const value_string x2ap_SubbandCQICodeword1_vals[] = {
  {   0, "four-bitCQI" },
  {   1, "three-bitSpatialDifferentialCQI" },
  {   2, "two-bitSubbandDifferentialCQI" },
  {   3, "two-bitDifferentialCQI" },
  { 0, NULL }
};

static const per_choice_t SubbandCQICodeword1_choice[] = {
  {   0, &hf_x2ap_four_bitCQI    , ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_15_ },
  {   1, &hf_x2ap_three_bitSpatialDifferentialCQI, ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_7_ },
  {   2, &hf_x2ap_two_bitSubbandDifferentialCQI, ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_3_ },
  {   3, &hf_x2ap_two_bitDifferentialCQI, ASN1_EXTENSION_ROOT    , dissect_x2ap_INTEGER_0_3_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_SubbandCQICodeword1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_SubbandCQICodeword1, SubbandCQICodeword1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SubbandCQI_sequence[] = {
  { &hf_x2ap_subbandCQICodeword0, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SubbandCQICodeword0 },
  { &hf_x2ap_subbandCQICodeword1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SubbandCQICodeword1 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SubbandCQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SubbandCQI, SubbandCQI_sequence);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_27_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 27U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SubbandCQIItem_sequence[] = {
  { &hf_x2ap_subbandCQI     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SubbandCQI },
  { &hf_x2ap_subbandIndex   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_27_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SubbandCQIItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SubbandCQIItem, SubbandCQIItem_sequence);

  return offset;
}


static const per_sequence_t SubbandCQIList_sequence_of[1] = {
  { &hf_x2ap_SubbandCQIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_SubbandCQIItem },
};

static int
dissect_x2ap_SubbandCQIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SubbandCQIList, SubbandCQIList_sequence_of,
                                                  1, maxSubband, FALSE);

  return offset;
}


static const per_sequence_t CSIReportPerCSIProcessItem_item_sequence[] = {
  { &hf_x2ap_rI             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_8_ },
  { &hf_x2ap_widebandCQI    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_WidebandCQI },
  { &hf_x2ap_subbandSize    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SubbandSize },
  { &hf_x2ap_subbandCQIList , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SubbandCQIList },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CSIReportPerCSIProcessItem_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CSIReportPerCSIProcessItem_item, CSIReportPerCSIProcessItem_item_sequence);

  return offset;
}


static const per_sequence_t CSIReportPerCSIProcessItem_sequence_of[1] = {
  { &hf_x2ap_CSIReportPerCSIProcessItem_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CSIReportPerCSIProcessItem_item },
};

static int
dissect_x2ap_CSIReportPerCSIProcessItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CSIReportPerCSIProcessItem, CSIReportPerCSIProcessItem_sequence_of,
                                                  1, maxCSIReport, FALSE);

  return offset;
}


static const per_sequence_t CSIReportPerCSIProcess_item_sequence[] = {
  { &hf_x2ap_cSIProcessConfigurationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_7_ },
  { &hf_x2ap_cSIReportPerCSIProcessItem, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CSIReportPerCSIProcessItem },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CSIReportPerCSIProcess_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CSIReportPerCSIProcess_item, CSIReportPerCSIProcess_item_sequence);

  return offset;
}


static const per_sequence_t CSIReportPerCSIProcess_sequence_of[1] = {
  { &hf_x2ap_CSIReportPerCSIProcess_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CSIReportPerCSIProcess_item },
};

static int
dissect_x2ap_CSIReportPerCSIProcess(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CSIReportPerCSIProcess, CSIReportPerCSIProcess_sequence_of,
                                                  1, maxCSIProcess, FALSE);

  return offset;
}


static const per_sequence_t CSIReportList_item_sequence[] = {
  { &hf_x2ap_uEID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UEID },
  { &hf_x2ap_cSIReportPerCSIProcess, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CSIReportPerCSIProcess },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CSIReportList_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CSIReportList_item, CSIReportList_item_sequence);

  return offset;
}


static const per_sequence_t CSIReportList_sequence_of[1] = {
  { &hf_x2ap_CSIReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CSIReportList_item },
};

static int
dissect_x2ap_CSIReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CSIReportList, CSIReportList_sequence_of,
                                                  1, maxUEReport, FALSE);

  return offset;
}


static const value_string x2ap_CHOtrigger_vals[] = {
  {   0, "cho-initiation" },
  {   1, "cho-replace" },
  { 0, NULL }
};


static int
dissect_x2ap_CHOtrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_UE_X2AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_UE_X2AP_ID_Extension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_CHO_Probability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CHOinformation_REQ_sequence[] = {
  { &hf_x2ap_cho_trigger    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CHOtrigger },
  { &hf_x2ap_new_eNB_UE_X2AP_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UE_X2AP_ID },
  { &hf_x2ap_new_eNB_UE_X2AP_ID_Extension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UE_X2AP_ID_Extension },
  { &hf_x2ap_cHO_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_CHO_Probability },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CHOinformation_REQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CHOinformation_REQ, CHOinformation_REQ_sequence);

  return offset;
}



static int
dissect_x2ap_MaxCHOpreparations(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CHOinformation_ACK_sequence[] = {
  { &hf_x2ap_requestedTargetCellID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_maxCHOpreparations, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_MaxCHOpreparations },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CHOinformation_ACK(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CHOinformation_ACK, CHOinformation_ACK_sequence);

  return offset;
}


static const per_sequence_t CandidateCellsToBeCancelledList_sequence_of[1] = {
  { &hf_x2ap_CandidateCellsToBeCancelledList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_CandidateCellsToBeCancelledList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CandidateCellsToBeCancelledList, CandidateCellsToBeCancelledList_sequence_of,
                                                  1, maxnoofCellsinCHO, FALSE);

  return offset;
}


static const value_string x2ap_CSI_RSTransmissionIndication_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_x2ap_CSI_RSTransmissionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_DataTrafficResources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 17600, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ULOnlySharing_sequence[] = {
  { &hf_x2ap_uLResourceBitmapULOnlySharing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DataTrafficResources },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ULOnlySharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ULOnlySharing, ULOnlySharing_sequence);

  return offset;
}



static int
dissect_x2ap_ULResourceBitmapULandDLSharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_x2ap_DataTrafficResources(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string x2ap_ULResourcesULandDLSharing_vals[] = {
  {   0, "unchanged" },
  {   1, "changed" },
  { 0, NULL }
};

static const per_choice_t ULResourcesULandDLSharing_choice[] = {
  {   0, &hf_x2ap_unchanged      , ASN1_EXTENSION_ROOT    , dissect_x2ap_NULL },
  {   1, &hf_x2ap_changed_01     , ASN1_EXTENSION_ROOT    , dissect_x2ap_ULResourceBitmapULandDLSharing },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_ULResourcesULandDLSharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_ULResourcesULandDLSharing, ULResourcesULandDLSharing_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_DLResourceBitmapULandDLSharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_x2ap_DataTrafficResources(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string x2ap_DLResourcesULandDLSharing_vals[] = {
  {   0, "unchanged" },
  {   1, "changed" },
  { 0, NULL }
};

static const per_choice_t DLResourcesULandDLSharing_choice[] = {
  {   0, &hf_x2ap_unchanged      , ASN1_EXTENSION_ROOT    , dissect_x2ap_NULL },
  {   1, &hf_x2ap_changed        , ASN1_EXTENSION_ROOT    , dissect_x2ap_DLResourceBitmapULandDLSharing },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_DLResourcesULandDLSharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_DLResourcesULandDLSharing, DLResourcesULandDLSharing_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ULandDLSharing_sequence[] = {
  { &hf_x2ap_uLResourcesULandDLSharing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ULResourcesULandDLSharing },
  { &hf_x2ap_dLResourcesULandDLSharing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DLResourcesULandDLSharing },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ULandDLSharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ULandDLSharing, ULandDLSharing_sequence);

  return offset;
}


static const value_string x2ap_SharedResourceType_vals[] = {
  {   0, "uLOnlySharing" },
  {   1, "uLandDLSharing" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_choice[] = {
  {   0, &hf_x2ap_uLOnlySharing  , ASN1_EXTENSION_ROOT    , dissect_x2ap_ULOnlySharing },
  {   1, &hf_x2ap_uLandDLSharing , ASN1_EXTENSION_ROOT    , dissect_x2ap_ULandDLSharing },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_SharedResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_SharedResourceType, SharedResourceType_choice,
                                 NULL);

  return offset;
}


static const value_string x2ap_SubframeType_vals[] = {
  {   0, "mbsfn" },
  {   1, "nonmbsfn" },
  { 0, NULL }
};


static int
dissect_x2ap_SubframeType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_10_160(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 160, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_T_mBSFNControlRegionLength_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

#line 671 "./asn1/x2ap/x2ap.cnf"
  proto_item_append_text(actx->created_item, " REs");


  return offset;
}


static const per_sequence_t ReservedSubframePattern_sequence[] = {
  { &hf_x2ap_subframeType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SubframeType },
  { &hf_x2ap_reservedSubframePattern_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_10_160 },
  { &hf_x2ap_mBSFNControlRegionLength_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_mBSFNControlRegionLength_01 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ReservedSubframePattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ReservedSubframePattern, ReservedSubframePattern_sequence);

  return offset;
}


static const per_sequence_t DataTrafficResourceIndication_sequence[] = {
  { &hf_x2ap_activationSFN  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_1023 },
  { &hf_x2ap_sharedResourceType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SharedResourceType },
  { &hf_x2ap_reservedSubframePattern, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ReservedSubframePattern },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DataTrafficResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DataTrafficResourceIndication, DataTrafficResourceIndication_sequence);

  return offset;
}


static const value_string x2ap_T_dAPSIndicator_vals[] = {
  {   0, "daps-HO-required" },
  { 0, NULL }
};


static int
dissect_x2ap_T_dAPSIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSRequestInfo_sequence[] = {
  { &hf_x2ap_dAPSIndicator  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_dAPSIndicator },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DAPSRequestInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DAPSRequestInfo, DAPSRequestInfo_sequence);

  return offset;
}


static const value_string x2ap_T_dAPSResponseIndicator_vals[] = {
  {   0, "daps-HO-accepted" },
  {   1, "daps-HO-not-accepted" },
  { 0, NULL }
};


static int
dissect_x2ap_T_dAPSResponseIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSResponseInfo_sequence[] = {
  { &hf_x2ap_dAPSResponseIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_dAPSResponseIndicator },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DAPSResponseInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DAPSResponseInfo, DAPSResponseInfo_sequence);

  return offset;
}


static const value_string x2ap_DeactivationIndication_vals[] = {
  {   0, "deactivated" },
  { 0, NULL }
};


static int
dissect_x2ap_DeactivationIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DeliveryStatus_sequence[] = {
  { &hf_x2ap_highestSuccessDeliveredPDCPSN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_4095 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DeliveryStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DeliveryStatus, DeliveryStatus_sequence);

  return offset;
}


static const value_string x2ap_DesiredActNotificationLevel_vals[] = {
  {   0, "none" },
  {   1, "e-rab" },
  {   2, "ue-level" },
  { 0, NULL }
};


static int
dissect_x2ap_DesiredActNotificationLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_DirectForwardingPathAvailability_vals[] = {
  {   0, "direct-path-available" },
  { 0, NULL }
};


static int
dissect_x2ap_DirectForwardingPathAvailability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_DL_Forwarding_vals[] = {
  {   0, "dL-forwardingProposed" },
  { 0, NULL }
};


static int
dissect_x2ap_DL_Forwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_DL_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_DL_non_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_DL_scheduling_PDCCH_CCE_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_DL_Total_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_DRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_DuplicationActivation_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_x2ap_DuplicationActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_T_transmissionModes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 555 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_MDT_transmissionModes_tm1,
      &hf_x2ap_MDT_transmissionModes_tm2,
      &hf_x2ap_MDT_transmissionModes_tm3,
      &hf_x2ap_MDT_transmissionModes_tm4,
      &hf_x2ap_MDT_transmissionModes_tm6,
      &hf_x2ap_MDT_transmissionModes_tm8,
      &hf_x2ap_MDT_transmissionModes_tm9,
      &hf_x2ap_MDT_transmissionModes_tm10,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_transmissionModes);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_x2ap_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_PA_Values_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4dot77" },
  {   2, "dB-3" },
  {   3, "dB-1dot77" },
  {   4, "dB0" },
  {   5, "dB1" },
  {   6, "dB2" },
  {   7, "dB3" },
  { 0, NULL }
};


static int
dissect_x2ap_PA_Values(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_0_maxnoofPA_OF_PA_Values_sequence_of[1] = {
  { &hf_x2ap_pA_list_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PA_Values },
};

static int
dissect_x2ap_SEQUENCE_SIZE_0_maxnoofPA_OF_PA_Values(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SEQUENCE_SIZE_0_maxnoofPA_OF_PA_Values, SEQUENCE_SIZE_0_maxnoofPA_OF_PA_Values_sequence_of,
                                                  0, maxnoofPA, FALSE);

  return offset;
}


static const per_sequence_t DynamicNAICSInformation_sequence[] = {
  { &hf_x2ap_transmissionModes, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_transmissionModes },
  { &hf_x2ap_pB_information , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_0_3 },
  { &hf_x2ap_pA_list        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SEQUENCE_SIZE_0_maxnoofPA_OF_PA_Values },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DynamicNAICSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DynamicNAICSInformation, DynamicNAICSInformation_sequence);

  return offset;
}


static const value_string x2ap_DynamicDLTransmissionInformation_vals[] = {
  {   0, "naics-active" },
  {   1, "naics-inactive" },
  { 0, NULL }
};

static const per_choice_t DynamicDLTransmissionInformation_choice[] = {
  {   0, &hf_x2ap_naics_active   , ASN1_EXTENSION_ROOT    , dissect_x2ap_DynamicNAICSInformation },
  {   1, &hf_x2ap_naics_inactive , ASN1_EXTENSION_ROOT    , dissect_x2ap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_DynamicDLTransmissionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_DynamicDLTransmissionInformation, DynamicDLTransmissionInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_EARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_EARFCNExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            maxEARFCNPlusOne, newmaxEARFCN, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_EndcSONConfigurationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 717 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_EndcSONConfigurationTransfer);
    dissect_s1ap_EN_DCSONConfigurationTransfer_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_12_8800_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 8800, TRUE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_RNTP_Threshold_vals[] = {
  {   0, "minusInfinity" },
  {   1, "minusEleven" },
  {   2, "minusTen" },
  {   3, "minusNine" },
  {   4, "minusEight" },
  {   5, "minusSeven" },
  {   6, "minusSix" },
  {   7, "minusFive" },
  {   8, "minusFour" },
  {   9, "minusThree" },
  {  10, "minusTwo" },
  {  11, "minusOne" },
  {  12, "zero" },
  {  13, "one" },
  {  14, "two" },
  {  15, "three" },
  { 0, NULL }
};


static int
dissect_x2ap_RNTP_Threshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t EnhancedRNTPStartTime_sequence[] = {
  { &hf_x2ap_startSFN       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_1023_ },
  { &hf_x2ap_startSubframeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_9_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_EnhancedRNTPStartTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_EnhancedRNTPStartTime, EnhancedRNTPStartTime_sequence);

  return offset;
}


static const per_sequence_t EnhancedRNTP_sequence[] = {
  { &hf_x2ap_enhancedRNTPBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_12_8800_ },
  { &hf_x2ap_rNTP_High_Power_Threshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RNTP_Threshold },
  { &hf_x2ap_enhancedRNTPStartTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_EnhancedRNTPStartTime },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_EnhancedRNTP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_EnhancedRNTP, EnhancedRNTP_sequence);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     18, 18, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     21, 21, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_ENB_ID_vals[] = {
  {   0, "macro-eNB-ID" },
  {   1, "home-eNB-ID" },
  {   2, "short-Macro-eNB-ID" },
  {   3, "long-Macro-eNB-ID" },
  { 0, NULL }
};

static const per_choice_t ENB_ID_choice[] = {
  {   0, &hf_x2ap_macro_eNB_ID   , ASN1_EXTENSION_ROOT    , dissect_x2ap_BIT_STRING_SIZE_20 },
  {   1, &hf_x2ap_home_eNB_ID    , ASN1_EXTENSION_ROOT    , dissect_x2ap_BIT_STRING_SIZE_28 },
  {   2, &hf_x2ap_short_Macro_eNB_ID, ASN1_NOT_EXTENSION_ROOT, dissect_x2ap_BIT_STRING_SIZE_18 },
  {   3, &hf_x2ap_long_Macro_eNB_ID, ASN1_NOT_EXTENSION_ROOT, dissect_x2ap_BIT_STRING_SIZE_21 },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_ENB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_ENB_ID, ENB_ID_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_EncryptionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 462 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_encryptionAlgorithms_EEA1,
      &hf_x2ap_encryptionAlgorithms_EEA2,
      &hf_x2ap_encryptionAlgorithms_EEA3,
      &hf_x2ap_encryptionAlgorithms_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_EncryptionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const value_string x2ap_T_pDCPatSgNB_vals[] = {
  {   0, "present" },
  {   1, "not-present" },
  { 0, NULL }
};


static int
dissect_x2ap_T_pDCPatSgNB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_T_mCGresources_vals[] = {
  {   0, "present" },
  {   1, "not-present" },
  { 0, NULL }
};


static int
dissect_x2ap_T_mCGresources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_T_sCGresources_vals[] = {
  {   0, "present" },
  {   1, "not-present" },
  { 0, NULL }
};


static int
dissect_x2ap_T_sCGresources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t EN_DC_ResourceConfiguration_sequence[] = {
  { &hf_x2ap_pDCPatSgNB     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_pDCPatSgNB },
  { &hf_x2ap_mCGresources   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_mCGresources },
  { &hf_x2ap_sCGresources   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_sCGresources },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_EN_DC_ResourceConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_EN_DC_ResourceConfiguration, EN_DC_ResourceConfiguration_sequence);

  return offset;
}



static int
dissect_x2ap_EPCHandoverRestrictionListContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 726 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_EPCHandoverRestrictionListContainer);
    dissect_s1ap_HandoverRestrictionList_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t EPLMNs_sequence_of[1] = {
  { &hf_x2ap_EPLMNs_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
};

static int
dissect_x2ap_EPLMNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_EPLMNs, EPLMNs_sequence_of,
                                                  1, maxnoofEPLMNs, FALSE);

  return offset;
}



static int
dissect_x2ap_E_RAB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_UserPlaneTrafficActivityReport_vals[] = {
  {   0, "inactive" },
  {   1, "re-activated" },
  { 0, NULL }
};


static int
dissect_x2ap_UserPlaneTrafficActivityReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ERABActivityNotifyItem_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_activityReport , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UserPlaneTrafficActivityReport },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ERABActivityNotifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ERABActivityNotifyItem, ERABActivityNotifyItem_sequence);

  return offset;
}


static const per_sequence_t ERABActivityNotifyItemList_sequence_of[1] = {
  { &hf_x2ap_ERABActivityNotifyItemList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ERABActivityNotifyItem },
};

static int
dissect_x2ap_ERABActivityNotifyItemList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ERABActivityNotifyItemList, ERABActivityNotifyItemList_sequence_of,
                                                  0, maxnoofBearers, FALSE);

  return offset;
}



static int
dissect_x2ap_QCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GBR_QosInformation_sequence[] = {
  { &hf_x2ap_e_RAB_MaximumBitrateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_e_RAB_MaximumBitrateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_e_RAB_GuaranteedBitrateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_e_RAB_GuaranteedBitrateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GBR_QosInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GBR_QosInformation, GBR_QosInformation_sequence);

  return offset;
}


static const per_sequence_t E_RAB_Level_QoS_Parameters_sequence[] = {
  { &hf_x2ap_qCI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_QCI },
  { &hf_x2ap_allocationAndRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_AllocationAndRetentionPriority },
  { &hf_x2ap_gbrQosInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GBR_QosInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RAB_Level_QoS_Parameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RAB_Level_QoS_Parameters, E_RAB_Level_QoS_Parameters_sequence);

  return offset;
}


static const per_sequence_t E_RAB_List_sequence_of[1] = {
  { &hf_x2ap_E_RAB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RAB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RAB_List, E_RAB_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RAB_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Cause },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RAB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RAB_Item, E_RAB_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABsSubjectToEarlyStatusTransfer_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_fIRST_DL_COUNTValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_COUNTvalue },
  { &hf_x2ap_fIRST_DL_COUNTValueExtended, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_COUNTValueExtended },
  { &hf_x2ap_fIRST_DL_COUNTValueforPDCPSNLength18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_COUNTvaluePDCP_SNlength18 },
  { &hf_x2ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABsSubjectToEarlyStatusTransfer_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABsSubjectToEarlyStatusTransfer_Item, E_RABsSubjectToEarlyStatusTransfer_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABsSubjectToEarlyStatusTransfer_List_sequence_of[1] = {
  { &hf_x2ap_E_RABsSubjectToEarlyStatusTransfer_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RABsSubjectToEarlyStatusTransfer_Item },
};

static int
dissect_x2ap_E_RABsSubjectToEarlyStatusTransfer_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABsSubjectToEarlyStatusTransfer_List, E_RABsSubjectToEarlyStatusTransfer_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABsSubjectToDLDiscarding_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_dISCARD_DL_COUNTValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_COUNTvalue },
  { &hf_x2ap_dISCARD_DL_COUNTValueExtended, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_COUNTValueExtended },
  { &hf_x2ap_dISCARD_DL_COUNTValueforPDCPSNLength18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_COUNTvaluePDCP_SNlength18 },
  { &hf_x2ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABsSubjectToDLDiscarding_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABsSubjectToDLDiscarding_Item, E_RABsSubjectToDLDiscarding_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABsSubjectToDLDiscarding_List_sequence_of[1] = {
  { &hf_x2ap_E_RABsSubjectToDLDiscarding_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RABsSubjectToDLDiscarding_Item },
};

static int
dissect_x2ap_E_RABsSubjectToDLDiscarding_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABsSubjectToDLDiscarding_List, E_RABsSubjectToDLDiscarding_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABUsageReportList_sequence_of[1] = {
  { &hf_x2ap_E_RABUsageReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABUsageReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABUsageReportList, E_RABUsageReportList_sequence_of,
                                                  1, maxnooftimeperiods, FALSE);

  return offset;
}



static int
dissect_x2ap_T_startTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 622 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, &timestamp_tvb);




#line 626 "./asn1/x2ap/x2ap.cnf"
  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }


  return offset;
}



static int
dissect_x2ap_T_endTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 631 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, &timestamp_tvb);




#line 635 "./asn1/x2ap/x2ap.cnf"
  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }


  return offset;
}



static int
dissect_x2ap_INTEGER_0_18446744073709551615(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(18446744073709551615), NULL, FALSE);

  return offset;
}


static const per_sequence_t E_RABUsageReport_Item_sequence[] = {
  { &hf_x2ap_startTimeStamp , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_startTimeStamp },
  { &hf_x2ap_endTimeStamp   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_endTimeStamp },
  { &hf_x2ap_usageCountUL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_18446744073709551615 },
  { &hf_x2ap_usageCountDL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_18446744073709551615 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABUsageReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABUsageReport_Item, E_RABUsageReport_Item_sequence);

  return offset;
}


static const value_string x2ap_Ethernet_Type_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_Ethernet_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_Transmission_Bandwidth_vals[] = {
  {   0, "bw6" },
  {   1, "bw15" },
  {   2, "bw25" },
  {   3, "bw50" },
  {   4, "bw75" },
  {   5, "bw100" },
  {   6, "bw1" },
  { 0, NULL }
};


static int
dissect_x2ap_Transmission_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 1, NULL);

  return offset;
}


static const per_sequence_t FDD_Info_sequence[] = {
  { &hf_x2ap_uL_EARFCN      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EARFCN },
  { &hf_x2ap_dL_EARFCN      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EARFCN },
  { &hf_x2ap_uL_Transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Transmission_Bandwidth },
  { &hf_x2ap_dL_Transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Transmission_Bandwidth },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_FDD_Info, FDD_Info_sequence);

  return offset;
}


static const value_string x2ap_SubframeAssignment_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_x2ap_SubframeAssignment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_SpecialSubframePatterns_vals[] = {
  {   0, "ssp0" },
  {   1, "ssp1" },
  {   2, "ssp2" },
  {   3, "ssp3" },
  {   4, "ssp4" },
  {   5, "ssp5" },
  {   6, "ssp6" },
  {   7, "ssp7" },
  {   8, "ssp8" },
  { 0, NULL }
};


static int
dissect_x2ap_SpecialSubframePatterns(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SpecialSubframe_Info_sequence[] = {
  { &hf_x2ap_specialSubframePatterns, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SpecialSubframePatterns },
  { &hf_x2ap_cyclicPrefixDL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CyclicPrefixDL },
  { &hf_x2ap_cyclicPrefixUL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CyclicPrefixUL },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SpecialSubframe_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SpecialSubframe_Info, SpecialSubframe_Info_sequence);

  return offset;
}


static const per_sequence_t TDD_Info_sequence[] = {
  { &hf_x2ap_eARFCN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EARFCN },
  { &hf_x2ap_transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Transmission_Bandwidth },
  { &hf_x2ap_subframeAssignment, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SubframeAssignment },
  { &hf_x2ap_specialSubframe_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SpecialSubframe_Info },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TDD_Info, TDD_Info_sequence);

  return offset;
}


static const value_string x2ap_EUTRA_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  { 0, NULL }
};

static const per_choice_t EUTRA_Mode_Info_choice[] = {
  {   0, &hf_x2ap_fDD            , ASN1_EXTENSION_ROOT    , dissect_x2ap_FDD_Info },
  {   1, &hf_x2ap_tDD            , ASN1_EXTENSION_ROOT    , dissect_x2ap_TDD_Info },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_EUTRA_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_EUTRA_Mode_Info, EUTRA_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_EUTRANTraceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 325 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb;
  proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_EUTRANTraceID);
  dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, E212_NONE, FALSE);
  proto_tree_add_item(subtree, hf_x2ap_eUTRANTraceID_TraceID, parameter_tvb, 3, 3, ENC_BIG_ENDIAN);
  proto_tree_add_item(subtree, hf_x2ap_eUTRANTraceID_TraceRecordingSessionReference, parameter_tvb, 6, 2, ENC_BIG_ENDIAN);



  return offset;
}


static const value_string x2ap_EventType_vals[] = {
  {   0, "change-of-serving-cell" },
  { 0, NULL }
};


static int
dissect_x2ap_EventType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_ExpectedActivityPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_ExpectedIdlePeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_SourceOfUEActivityBehaviourInformation_vals[] = {
  {   0, "subscription-information" },
  {   1, "statistics" },
  { 0, NULL }
};


static int
dissect_x2ap_SourceOfUEActivityBehaviourInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEActivityBehaviour_sequence[] = {
  { &hf_x2ap_expectedActivityPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ExpectedActivityPeriod },
  { &hf_x2ap_expectedIdlePeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ExpectedIdlePeriod },
  { &hf_x2ap_sourceofUEActivityBehaviourInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SourceOfUEActivityBehaviourInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ExpectedUEActivityBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ExpectedUEActivityBehaviour, ExpectedUEActivityBehaviour_sequence);

  return offset;
}


static const value_string x2ap_ExpectedHOInterval_vals[] = {
  {   0, "sec15" },
  {   1, "sec30" },
  {   2, "sec60" },
  {   3, "sec90" },
  {   4, "sec120" },
  {   5, "sec180" },
  {   6, "long-time" },
  { 0, NULL }
};


static int
dissect_x2ap_ExpectedHOInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEBehaviour_sequence[] = {
  { &hf_x2ap_expectedActivity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ExpectedUEActivityBehaviour },
  { &hf_x2ap_expectedHOInterval, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ExpectedHOInterval },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ExpectedUEBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ExpectedUEBehaviour, ExpectedUEBehaviour_sequence);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     5, 5, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_UL_InterferenceOverloadIndication_Item_vals[] = {
  {   0, "high-interference" },
  {   1, "medium-interference" },
  {   2, "low-interference" },
  { 0, NULL }
};


static int
dissect_x2ap_UL_InterferenceOverloadIndication_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t UL_InterferenceOverloadIndication_sequence_of[1] = {
  { &hf_x2ap_UL_InterferenceOverloadIndication_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_InterferenceOverloadIndication_Item },
};

static int
dissect_x2ap_UL_InterferenceOverloadIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_UL_InterferenceOverloadIndication, UL_InterferenceOverloadIndication_sequence_of,
                                                  1, maxnoofPRBs, FALSE);

  return offset;
}


static const per_sequence_t ExtendedULInterferenceOverloadInfo_sequence[] = {
  { &hf_x2ap_associatedSubframes, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_5 },
  { &hf_x2ap_extended_ul_InterferenceOverloadIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_InterferenceOverloadIndication },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ExtendedULInterferenceOverloadInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ExtendedULInterferenceOverloadInfo, ExtendedULInterferenceOverloadInfo_sequence);

  return offset;
}



static int
dissect_x2ap_ExtendedBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            10000000001U, G_GUINT64_CONSTANT(4000000000000), NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_F1CTrafficContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_x2ap_RRCContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 300 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb;
  proto_tree *subtree = NULL;
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  switch (x2ap_data->rrc_container_type) {
    case RRC_CONTAINER_TYPE_NR_UE_MEAS_REPORT:
      subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_RRCContainer);
      dissect_nr_rrc_UL_DCCH_Message_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
      break;
    case RRC_CONTAINER_TYPE_FAST_MCG_RECOVERY_SgNB_TO_MeNB:
      subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_RRCContainer);
      dissect_lte_rrc_UL_DCCH_Message_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
      break;
    case RRC_CONTAINER_TYPE_FAST_MCG_RECOVERY_MeNB_TO_SgNB:
      subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_RRCContainer);
      dissect_lte_rrc_DL_DCCH_Message_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
  }
  x2ap_data->rrc_container_type = RRC_CONTAINER_TYPE_UNKNOWN;



  return offset;
}


static const per_sequence_t FastMCGRecovery_sequence[] = {
  { &hf_x2ap_rrcContainer   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_RRCContainer },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_FastMCGRecovery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 292 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);

  if (x2ap_data->protocol_ie_id == id_FastMCGRecovery_SN_to_MN)
    x2ap_data->rrc_container_type = RRC_CONTAINER_TYPE_FAST_MCG_RECOVERY_SgNB_TO_MeNB;
  else if (x2ap_data->protocol_ie_id == id_FastMCGRecovery_MN_to_SN)
    x2ap_data->rrc_container_type = RRC_CONTAINER_TYPE_FAST_MCG_RECOVERY_MeNB_TO_SgNB;


  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_FastMCGRecovery, FastMCGRecovery_sequence);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_3279165(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3279165U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_INTEGER_1_1024_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SupportedSULFreqBandItem_sequence[] = {
  { &hf_x2ap_freqBandIndicatorNr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_1024_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SupportedSULFreqBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SupportedSULFreqBandItem, SupportedSULFreqBandItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem_sequence_of[1] = {
  { &hf_x2ap_supportedSULBandList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_SupportedSULFreqBandItem },
};

static int
dissect_x2ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem, SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem_sequence_of,
                                                  0, maxnoofNrCellBands, FALSE);

  return offset;
}


static const per_sequence_t FreqBandNrItem_sequence[] = {
  { &hf_x2ap_freqBandIndicatorNr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_1024_ },
  { &hf_x2ap_supportedSULBandList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_FreqBandNrItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_FreqBandNrItem, FreqBandNrItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem_sequence_of[1] = {
  { &hf_x2ap_freqBandListNr_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_FreqBandNrItem },
};

static int
dissect_x2ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem, SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem_sequence_of,
                                                  1, maxnoofNrCellBands, FALSE);

  return offset;
}


static const value_string x2ap_NRSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  { 0, NULL }
};


static int
dissect_x2ap_NRSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_NRNRB_vals[] = {
  {   0, "nrb11" },
  {   1, "nrb18" },
  {   2, "nrb24" },
  {   3, "nrb25" },
  {   4, "nrb31" },
  {   5, "nrb32" },
  {   6, "nrb38" },
  {   7, "nrb51" },
  {   8, "nrb52" },
  {   9, "nrb65" },
  {  10, "nrb66" },
  {  11, "nrb78" },
  {  12, "nrb79" },
  {  13, "nrb93" },
  {  14, "nrb106" },
  {  15, "nrb107" },
  {  16, "nrb121" },
  {  17, "nrb132" },
  {  18, "nrb133" },
  {  19, "nrb135" },
  {  20, "nrb160" },
  {  21, "nrb162" },
  {  22, "nrb189" },
  {  23, "nrb216" },
  {  24, "nrb217" },
  {  25, "nrb245" },
  {  26, "nrb264" },
  {  27, "nrb270" },
  {  28, "nrb273" },
  { 0, NULL }
};

static value_string_ext x2ap_NRNRB_vals_ext = VALUE_STRING_EXT_INIT(x2ap_NRNRB_vals);


static int
dissect_x2ap_NRNRB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     29, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_TxBW_sequence[] = {
  { &hf_x2ap_nRSCS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRSCS },
  { &hf_x2ap_nRNRB          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRNRB },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NR_TxBW(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NR_TxBW, NR_TxBW_sequence);

  return offset;
}


static const per_sequence_t SULInformation_sequence[] = {
  { &hf_x2ap_sUL_ARFCN      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_3279165 },
  { &hf_x2ap_sUL_TxBW       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NR_TxBW },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SULInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SULInformation, SULInformation_sequence);

  return offset;
}


static const per_sequence_t NRFreqInfo_sequence[] = {
  { &hf_x2ap_nRARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_3279165 },
  { &hf_x2ap_freqBandListNr , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem },
  { &hf_x2ap_sULInformation , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SULInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRFreqInfo, NRFreqInfo_sequence);

  return offset;
}


static const per_sequence_t FDD_InfoNeighbourServedNRCell_Information_sequence[] = {
  { &hf_x2ap_ul_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRFreqInfo },
  { &hf_x2ap_dl_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRFreqInfo },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_FDD_InfoNeighbourServedNRCell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_FDD_InfoNeighbourServedNRCell_Information, FDD_InfoNeighbourServedNRCell_Information_sequence);

  return offset;
}



static int
dissect_x2ap_FiveQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_ForbiddenInterRATs_vals[] = {
  {   0, "all" },
  {   1, "geran" },
  {   2, "utran" },
  {   3, "cdma2000" },
  {   4, "geranandutran" },
  {   5, "cdma2000andutran" },
  { 0, NULL }
};


static int
dissect_x2ap_ForbiddenInterRATs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 2, NULL);

  return offset;
}


static const per_sequence_t ForbiddenTACs_sequence_of[1] = {
  { &hf_x2ap_ForbiddenTACs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TAC },
};

static int
dissect_x2ap_ForbiddenTACs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ForbiddenTACs, ForbiddenTACs_sequence_of,
                                                  1, maxnoofForbTACs, FALSE);

  return offset;
}


static const per_sequence_t ForbiddenTAs_Item_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_forbiddenTACs  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ForbiddenTACs },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ForbiddenTAs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ForbiddenTAs_Item, ForbiddenTAs_Item_sequence);

  return offset;
}


static const per_sequence_t ForbiddenTAs_sequence_of[1] = {
  { &hf_x2ap_ForbiddenTAs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ForbiddenTAs_Item },
};

static int
dissect_x2ap_ForbiddenTAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ForbiddenTAs, ForbiddenTAs_sequence_of,
                                                  1, maxnoofEPLMNsPlusOne, FALSE);

  return offset;
}



static int
dissect_x2ap_LAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 402 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t ForbiddenLACs_sequence_of[1] = {
  { &hf_x2ap_ForbiddenLACs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_LAC },
};

static int
dissect_x2ap_ForbiddenLACs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ForbiddenLACs, ForbiddenLACs_sequence_of,
                                                  1, maxnoofForbLACs, FALSE);

  return offset;
}


static const per_sequence_t ForbiddenLAs_Item_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_forbiddenLACs  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ForbiddenLACs },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ForbiddenLAs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ForbiddenLAs_Item, ForbiddenLAs_Item_sequence);

  return offset;
}


static const per_sequence_t ForbiddenLAs_sequence_of[1] = {
  { &hf_x2ap_ForbiddenLAs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ForbiddenLAs_Item },
};

static int
dissect_x2ap_ForbiddenLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ForbiddenLAs, ForbiddenLAs_sequence_of,
                                                  1, maxnoofEPLMNsPlusOne, FALSE);

  return offset;
}



static int
dissect_x2ap_Fourframes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_FreqBandIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_FreqBandIndicatorPriority_vals[] = {
  {   0, "not-broadcasted" },
  {   1, "broadcasted" },
  { 0, NULL }
};


static int
dissect_x2ap_FreqBandIndicatorPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_FrequencyShift7p5khz_vals[] = {
  {   0, "false" },
  {   1, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_FrequencyShift7p5khz(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t GlobalENB_ID_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_eNB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ENB_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GlobalENB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GlobalENB_ID, GlobalENB_ID_sequence);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_22_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_GNB_ID_vals[] = {
  {   0, "gNB-ID" },
  { 0, NULL }
};

static const per_choice_t GNB_ID_choice[] = {
  {   0, &hf_x2ap_gNB_ID_01      , ASN1_EXTENSION_ROOT    , dissect_x2ap_BIT_STRING_SIZE_22_32 },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_GNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_GNB_ID, GNB_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalGNB_ID_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_gNB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GNB_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GlobalGNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GlobalGNB_ID, GlobalGNB_ID_sequence);

  return offset;
}


static const value_string x2ap_Global_RAN_NODE_ID_vals[] = {
  {   0, "gNB" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Global_RAN_NODE_ID_choice[] = {
  {   0, &hf_x2ap_gNB            , ASN1_NO_EXTENSIONS     , dissect_x2ap_GlobalGNB_ID },
  {   1, &hf_x2ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_x2ap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_Global_RAN_NODE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_Global_RAN_NODE_ID, Global_RAN_NODE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string x2ap_GNBOverloadInformation_vals[] = {
  {   0, "overloaded" },
  {   1, "not-overloaded" },
  { 0, NULL }
};


static int
dissect_x2ap_GNBOverloadInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t GTPTLA_Item_sequence[] = {
  { &hf_x2ap_gTPTransportLayerAddresses, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TransportLayerAddress },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GTPTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GTPTLA_Item, GTPTLA_Item_sequence);

  return offset;
}


static const per_sequence_t GTPTLAs_sequence_of[1] = {
  { &hf_x2ap_GTPTLAs_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPTLA_Item },
};

static int
dissect_x2ap_GTPTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_GTPTLAs, GTPTLAs_sequence_of,
                                                  1, maxnoofGTPTLAs, FALSE);

  return offset;
}



static int
dissect_x2ap_GTP_TEI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, NULL);

  return offset;
}


static const per_sequence_t GTPtunnelEndpoint_sequence[] = {
  { &hf_x2ap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TransportLayerAddress },
  { &hf_x2ap_gTP_TEID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTP_TEI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GTPtunnelEndpoint(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GTPtunnelEndpoint, GTPtunnelEndpoint_sequence);

  return offset;
}



static int
dissect_x2ap_MME_Group_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 455 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t GU_Group_ID_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_mME_Group_ID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_MME_Group_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GU_Group_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GU_Group_ID, GU_Group_ID_sequence);

  return offset;
}


static const per_sequence_t GUGroupIDList_sequence_of[1] = {
  { &hf_x2ap_GUGroupIDList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_GU_Group_ID },
};

static int
dissect_x2ap_GUGroupIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_GUGroupIDList, GUGroupIDList_sequence_of,
                                                  1, maxPools, FALSE);

  return offset;
}



static int
dissect_x2ap_MME_Code(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 446 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 1, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 1, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t GUMMEI_sequence[] = {
  { &hf_x2ap_gU_Group_ID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GU_Group_ID },
  { &hf_x2ap_mME_Code       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_MME_Code },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GUMMEI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 439 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  x2ap_data->number_type = E212_GUMMEI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GUMMEI, GUMMEI_sequence);




  return offset;
}


static const value_string x2ap_HandoverReportType_vals[] = {
  {   0, "hoTooEarly" },
  {   1, "hoToWrongCell" },
  {   2, "interRATpingpong" },
  {   3, "interSystemPingpong" },
  { 0, NULL }
};


static int
dissect_x2ap_HandoverReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 2, NULL);

  return offset;
}


static const per_sequence_t HandoverRestrictionList_sequence[] = {
  { &hf_x2ap_servingPLMN    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_equivalentPLMNs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_EPLMNs },
  { &hf_x2ap_forbiddenTAs   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ForbiddenTAs },
  { &hf_x2ap_forbiddenLAs   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ForbiddenLAs },
  { &hf_x2ap_forbiddenInterRATs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ForbiddenInterRATs },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HandoverRestrictionList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HandoverRestrictionList, HandoverRestrictionList_sequence);

  return offset;
}


static const value_string x2ap_LoadIndicator_vals[] = {
  {   0, "lowLoad" },
  {   1, "mediumLoad" },
  {   2, "highLoad" },
  {   3, "overLoad" },
  { 0, NULL }
};


static int
dissect_x2ap_LoadIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t HWLoadIndicator_sequence[] = {
  { &hf_x2ap_dLHWLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_LoadIndicator },
  { &hf_x2ap_uLHWLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_LoadIndicator },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HWLoadIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HWLoadIndicator, HWLoadIndicator_sequence);

  return offset;
}


static const value_string x2ap_IABNodeIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_IABNodeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_IMSvoiceEPSfallbackfrom5G_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_IMSvoiceEPSfallbackfrom5G(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_IntegrityProtectionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 477 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_integrityProtectionAlgorithms_EIA1,
      &hf_x2ap_integrityProtectionAlgorithms_EIA2,
      &hf_x2ap_integrityProtectionAlgorithms_EIA3,
      &hf_x2ap_integrityProtectionAlgorithms_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_IntegrityProtectionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_x2ap_IntendedTDD_DL_ULConfiguration_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 883 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_IntendedTDD_DL_ULConfiguration_NR);
    dissect_xnap_IntendedTDD_DL_ULConfiguration_NR_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_InterfaceInstanceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_InterfacesToTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 336 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_interfacesToTrace_S1_MME,
      &hf_x2ap_interfacesToTrace_X2,
      &hf_x2ap_interfacesToTrace_Uu,
      &hf_x2ap_interfacesToTrace_F1_C,
      &hf_x2ap_interfacesToTrace_E1,
      &hf_x2ap_interfacesToTrace_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_InterfacesToTrace);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const value_string x2ap_InvokeIndication_vals[] = {
  {   0, "abs-information" },
  {   1, "naics-information-start" },
  {   2, "naics-information-stop" },
  { 0, NULL }
};


static int
dissect_x2ap_InvokeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 2, NULL);

  return offset;
}



static int
dissect_x2ap_Time_UE_StayedInCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const per_sequence_t LastVisitedEUTRANCellInformation_sequence[] = {
  { &hf_x2ap_global_Cell_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_cellType       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CellType },
  { &hf_x2ap_time_UE_StayedInCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Time_UE_StayedInCell },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_LastVisitedEUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_LastVisitedEUTRANCellInformation, LastVisitedEUTRANCellInformation_sequence);

  return offset;
}



static int
dissect_x2ap_LastVisitedUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 708 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_LastVisitedUTRANCellInformation);
    dissect_ranap_LastVisitedUTRANCell_Item_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string x2ap_LastVisitedGERANCellInformation_vals[] = {
  {   0, "undefined" },
  { 0, NULL }
};

static const per_choice_t LastVisitedGERANCellInformation_choice[] = {
  {   0, &hf_x2ap_undefined      , ASN1_EXTENSION_ROOT    , dissect_x2ap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_LastVisitedGERANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_LastVisitedGERANCellInformation, LastVisitedGERANCellInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_LastVisitedNGRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 699 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_LastVisitedNGRANCellInformation);
    dissect_ngap_LastVisitedNGRANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string x2ap_LastVisitedCell_Item_vals[] = {
  {   0, "e-UTRAN-Cell" },
  {   1, "uTRAN-Cell" },
  {   2, "gERAN-Cell" },
  {   3, "nG-RAN-Cell" },
  { 0, NULL }
};

static const per_choice_t LastVisitedCell_Item_choice[] = {
  {   0, &hf_x2ap_e_UTRAN_Cell   , ASN1_EXTENSION_ROOT    , dissect_x2ap_LastVisitedEUTRANCellInformation },
  {   1, &hf_x2ap_uTRAN_Cell     , ASN1_EXTENSION_ROOT    , dissect_x2ap_LastVisitedUTRANCellInformation },
  {   2, &hf_x2ap_gERAN_Cell     , ASN1_EXTENSION_ROOT    , dissect_x2ap_LastVisitedGERANCellInformation },
  {   3, &hf_x2ap_nG_RAN_Cell    , ASN1_NOT_EXTENSION_ROOT, dissect_x2ap_LastVisitedNGRANCellInformation },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_LastVisitedCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_LastVisitedCell_Item, LastVisitedCell_Item_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_LCID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_LHN_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 576 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       32, 256, FALSE, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);



  return offset;
}


static const value_string x2ap_Links_to_log_vals[] = {
  {   0, "uplink" },
  {   1, "downlink" },
  {   2, "both-uplink-and-downlink" },
  { 0, NULL }
};


static int
dissect_x2ap_Links_to_log(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NRCGI_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_nRcellIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCellIdentifier },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 381 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  x2ap_data->number_type = E212_NRCGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRCGI, NRCGI_sequence);




  return offset;
}


static const per_sequence_t LocationInformationSgNB_sequence[] = {
  { &hf_x2ap_pSCell_id      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_LocationInformationSgNB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_LocationInformationSgNB, LocationInformationSgNB_sequence);

  return offset;
}


static const value_string x2ap_LocationInformationSgNBReporting_vals[] = {
  {   0, "pSCell" },
  { 0, NULL }
};


static int
dissect_x2ap_LocationInformationSgNBReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_ReportArea_vals[] = {
  {   0, "ecgi" },
  { 0, NULL }
};


static int
dissect_x2ap_ReportArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t LocationReportingInformation_sequence[] = {
  { &hf_x2ap_eventType      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EventType },
  { &hf_x2ap_reportArea     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ReportArea },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_LocationReportingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_LocationReportingInformation, LocationReportingInformation_sequence);

  return offset;
}


static const value_string x2ap_LowerLayerPresenceStatusChange_vals[] = {
  {   0, "release-lower-layers" },
  {   1, "re-establish-lower-layers" },
  {   2, "suspend-lower-layers" },
  {   3, "resume-lower-layers" },
  { 0, NULL }
};


static int
dissect_x2ap_LowerLayerPresenceStatusChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_ReportIntervalMDT_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "min1" },
  {   9, "min6" },
  {  10, "min12" },
  {  11, "min30" },
  {  12, "min60" },
  { 0, NULL }
};


static int
dissect_x2ap_ReportIntervalMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string x2ap_ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "rinfinity" },
  { 0, NULL }
};


static int
dissect_x2ap_ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t M1PeriodicReporting_sequence[] = {
  { &hf_x2ap_reportInterval , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ReportIntervalMDT },
  { &hf_x2ap_reportAmount   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ReportAmountMDT },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_M1PeriodicReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_M1PeriodicReporting, M1PeriodicReporting_sequence);

  return offset;
}


static const value_string x2ap_M1ReportingTrigger_vals[] = {
  {   0, "periodic" },
  {   1, "a2eventtriggered" },
  {   2, "a2eventtriggered-periodic" },
  { 0, NULL }
};


static int
dissect_x2ap_M1ReportingTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_x2ap_Threshold_RSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 97U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_Threshold_RSRQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 34U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_MeasurementThresholdA2_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  { 0, NULL }
};

static const per_choice_t MeasurementThresholdA2_choice[] = {
  {   0, &hf_x2ap_threshold_RSRP , ASN1_EXTENSION_ROOT    , dissect_x2ap_Threshold_RSRP },
  {   1, &hf_x2ap_threshold_RSRQ , ASN1_EXTENSION_ROOT    , dissect_x2ap_Threshold_RSRQ },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_MeasurementThresholdA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_MeasurementThresholdA2, MeasurementThresholdA2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t M1ThresholdEventA2_sequence[] = {
  { &hf_x2ap_measurementThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_MeasurementThresholdA2 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_M1ThresholdEventA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_M1ThresholdEventA2, M1ThresholdEventA2_sequence);

  return offset;
}


static const value_string x2ap_M3period_vals[] = {
  {   0, "ms100" },
  {   1, "ms1000" },
  {   2, "ms10000" },
  { 0, NULL }
};


static int
dissect_x2ap_M3period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M3Configuration_sequence[] = {
  { &hf_x2ap_m3period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_M3period },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_M3Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_M3Configuration, M3Configuration_sequence);

  return offset;
}


static const value_string x2ap_M4period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_x2ap_M4period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M4Configuration_sequence[] = {
  { &hf_x2ap_m4period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_M4period },
  { &hf_x2ap_m4_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Links_to_log },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_M4Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_M4Configuration, M4Configuration_sequence);

  return offset;
}


static const value_string x2ap_M5period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_x2ap_M5period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M5Configuration_sequence[] = {
  { &hf_x2ap_m5period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_M5period },
  { &hf_x2ap_m5_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Links_to_log },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_M5Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_M5Configuration, M5Configuration_sequence);

  return offset;
}


static const value_string x2ap_M6report_interval_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  { 0, NULL }
};


static int
dissect_x2ap_M6report_interval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_M6delay_threshold_vals[] = {
  {   0, "ms30" },
  {   1, "ms40" },
  {   2, "ms50" },
  {   3, "ms60" },
  {   4, "ms70" },
  {   5, "ms80" },
  {   6, "ms90" },
  {   7, "ms100" },
  {   8, "ms150" },
  {   9, "ms300" },
  {  10, "ms500" },
  {  11, "ms750" },
  { 0, NULL }
};


static int
dissect_x2ap_M6delay_threshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M6Configuration_sequence[] = {
  { &hf_x2ap_m6report_interval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_M6report_interval },
  { &hf_x2ap_m6delay_threshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_M6delay_threshold },
  { &hf_x2ap_m6_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Links_to_log },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_M6Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_M6Configuration, M6Configuration_sequence);

  return offset;
}



static int
dissect_x2ap_M7period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 60U, NULL, TRUE);

  return offset;
}


static const per_sequence_t M7Configuration_sequence[] = {
  { &hf_x2ap_m7period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_M7period },
  { &hf_x2ap_m7_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Links_to_log },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_M7Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_M7Configuration, M7Configuration_sequence);

  return offset;
}


static const value_string x2ap_MakeBeforeBreakIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_MakeBeforeBreakIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_ManagementBasedMDTallowed_vals[] = {
  {   0, "allowed" },
  { 0, NULL }
};


static int
dissect_x2ap_ManagementBasedMDTallowed(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_Masked_IMEISV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_MDT_Activation_vals[] = {
  {   0, "immediate-MDT-only" },
  {   1, "immediate-MDT-and-Trace" },
  { 0, NULL }
};


static int
dissect_x2ap_MDT_Activation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_MeasurementsToActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 507 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_measurementsToActivate_M1,
      &hf_x2ap_measurementsToActivate_M2,
      &hf_x2ap_measurementsToActivate_M3,
      &hf_x2ap_measurementsToActivate_M4,
      &hf_x2ap_measurementsToActivate_M5,
      &hf_x2ap_measurementsToActivate_LoggingM1FromEventTriggered,
      &hf_x2ap_measurementsToActivate_M6,
      &hf_x2ap_measurementsToActivate_M7,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_MeasurementsToActivate);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t MDT_Configuration_sequence[] = {
  { &hf_x2ap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_MDT_Activation },
  { &hf_x2ap_areaScopeOfMDT , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_AreaScopeOfMDT },
  { &hf_x2ap_measurementsToActivate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_MeasurementsToActivate },
  { &hf_x2ap_m1reportingTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_M1ReportingTrigger },
  { &hf_x2ap_m1thresholdeventA2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_M1ThresholdEventA2 },
  { &hf_x2ap_m1periodicReporting, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_M1PeriodicReporting },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MDT_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MDT_Configuration, MDT_Configuration_sequence);

  return offset;
}


static const per_sequence_t MDTPLMNList_sequence_of[1] = {
  { &hf_x2ap_MDTPLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
};

static int
dissect_x2ap_MDTPLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_MDTPLMNList, MDTPLMNList_sequence_of,
                                                  1, maxnoofMDTPLMNs, FALSE);

  return offset;
}



static int
dissect_x2ap_MDT_Location_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 532 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_MDT_Location_Info_GNSS,
      &hf_x2ap_MDT_Location_Info_E_CID,
      &hf_x2ap_MDT_Location_Info_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_MDT_Location_Info);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_x2ap_Measurement_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4095U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_Measurement_ID_ENDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4095U, NULL, TRUE);

  return offset;
}


static const value_string x2ap_MeNBCoordinationAssistanceInformation_vals[] = {
  {   0, "coordination-not-required" },
  { 0, NULL }
};


static int
dissect_x2ap_MeNBCoordinationAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MeNBResourceCoordinationInformation_sequence[] = {
  { &hf_x2ap_eUTRA_Cell_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_uLCoordinationInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_6_4400_ },
  { &hf_x2ap_dLCoordinationInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BIT_STRING_SIZE_6_4400_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MeNBResourceCoordinationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MeNBResourceCoordinationInformation, MeNBResourceCoordinationInformation_sequence);

  return offset;
}



static int
dissect_x2ap_MeNBtoSeNBContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 238 "./asn1/x2ap/x2ap.cnf"
 tvbuff_t *parameter_tvb;
 proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_MeNBtoSeNBContainer);
  dissect_lte_rrc_SCG_ConfigInfo_r12_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}



static int
dissect_x2ap_MBMS_Service_Area_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, FALSE, NULL);

  return offset;
}


static const per_sequence_t MBMS_Service_Area_Identity_List_sequence_of[1] = {
  { &hf_x2ap_MBMS_Service_Area_Identity_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_MBMS_Service_Area_Identity },
};

static int
dissect_x2ap_MBMS_Service_Area_Identity_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_MBMS_Service_Area_Identity_List, MBMS_Service_Area_Identity_List_sequence_of,
                                                  1, maxnoofMBMSServiceAreaIdentities, FALSE);

  return offset;
}


static const value_string x2ap_RadioframeAllocationPeriod_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  { 0, NULL }
};


static int
dissect_x2ap_RadioframeAllocationPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_RadioframeAllocationOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_Oneframe(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_SubframeAllocation_vals[] = {
  {   0, "oneframe" },
  {   1, "fourframes" },
  { 0, NULL }
};

static const per_choice_t SubframeAllocation_choice[] = {
  {   0, &hf_x2ap_oneframe       , ASN1_EXTENSION_ROOT    , dissect_x2ap_Oneframe },
  {   1, &hf_x2ap_fourframes     , ASN1_EXTENSION_ROOT    , dissect_x2ap_Fourframes },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_SubframeAllocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_SubframeAllocation, SubframeAllocation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBSFN_Subframe_Info_sequence[] = {
  { &hf_x2ap_radioframeAllocationPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RadioframeAllocationPeriod },
  { &hf_x2ap_radioframeAllocationOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RadioframeAllocationOffset },
  { &hf_x2ap_subframeAllocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SubframeAllocation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MBSFN_Subframe_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MBSFN_Subframe_Info, MBSFN_Subframe_Info_sequence);

  return offset;
}


static const per_sequence_t MBSFN_Subframe_Infolist_sequence_of[1] = {
  { &hf_x2ap_MBSFN_Subframe_Infolist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_MBSFN_Subframe_Info },
};

static int
dissect_x2ap_MBSFN_Subframe_Infolist(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_MBSFN_Subframe_Infolist, MBSFN_Subframe_Infolist_sequence_of,
                                                  1, maxnoofMBSFN, FALSE);

  return offset;
}



static int
dissect_x2ap_MDT_ConfigurationNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 865 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_MDT_ConfigurationNR);
    dissect_ngap_MDT_Configuration_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_INTEGER_M20_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -20, 20U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MobilityParametersModificationRange_sequence[] = {
  { &hf_x2ap_handoverTriggerChangeLowerLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_M20_20 },
  { &hf_x2ap_handoverTriggerChangeUpperLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_M20_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MobilityParametersModificationRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MobilityParametersModificationRange, MobilityParametersModificationRange_sequence);

  return offset;
}


static const per_sequence_t MobilityParametersInformation_sequence[] = {
  { &hf_x2ap_handoverTriggerChange, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_M20_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MobilityParametersInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MobilityParametersInformation, MobilityParametersInformation_sequence);

  return offset;
}


static const per_sequence_t BandInfo_sequence[] = {
  { &hf_x2ap_freqBandIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_FreqBandIndicator },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_BandInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_BandInfo, BandInfo_sequence);

  return offset;
}


static const per_sequence_t MultibandInfoList_sequence_of[1] = {
  { &hf_x2ap_MultibandInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_BandInfo },
};

static int
dissect_x2ap_MultibandInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_MultibandInfoList, MultibandInfoList_sequence_of,
                                                  1, maxnoofBands, FALSE);

  return offset;
}



static int
dissect_x2ap_MaximumCellListSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16384U, NULL, TRUE);

  return offset;
}


static const per_sequence_t MessageOversizeNotification_sequence[] = {
  { &hf_x2ap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_MaximumCellListSize },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MessageOversizeNotification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MessageOversizeNotification, MessageOversizeNotification_sequence);

  return offset;
}



static int
dissect_x2ap_MeNBtoSgNBContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 256 "./asn1/x2ap/x2ap.cnf"
 tvbuff_t *parameter_tvb;
 proto_tree *subtree = NULL;
 struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_MeNBtoSgNBContainer);
  if ((x2ap_data->procedure_code == id_sgNBReconfigurationCompletion &&
       x2ap_data->message_type == INITIATING_MESSAGE) ||
      (x2ap_data->procedure_code == id_sgNBinitiatedSgNBModification &&
       x2ap_data->message_type == SUCCESSFUL_OUTCOME)) {
    dissect_nr_rrc_RRCReconfigurationComplete_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  } else {
    dissect_nr_rrc_CG_ConfigInfo_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string x2ap_SplitSRBs_vals[] = {
  {   0, "srb1" },
  {   1, "srb2" },
  {   2, "srb1and2" },
  { 0, NULL }
};


static int
dissect_x2ap_SplitSRBs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_T_rrcContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 282 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);

  x2ap_data->rrc_container_type = RRC_CONTAINER_TYPE_PDCP_C_PDU;


  offset = dissect_x2ap_RRCContainer(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string x2ap_SRBType_vals[] = {
  {   0, "srb1" },
  {   1, "srb2" },
  { 0, NULL }
};


static int
dissect_x2ap_SRBType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SplitSRB_sequence[] = {
  { &hf_x2ap_rrcContainer_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_rrcContainer },
  { &hf_x2ap_srbType        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SRBType },
  { &hf_x2ap_deliveryStatus , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_DeliveryStatus },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SplitSRB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SplitSRB, SplitSRB_sequence);

  return offset;
}


static const value_string x2ap_NBIoT_UL_DL_AlignmentOffset_vals[] = {
  {   0, "khz-7dot5" },
  {   1, "khz0" },
  {   2, "khz7dot5" },
  { 0, NULL }
};


static int
dissect_x2ap_NBIoT_UL_DL_AlignmentOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_NBIoT_RLF_Report_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 229 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_NBIoT_RLF_Report_Container);
  dissect_lte_rrc_RLF_Report_NB_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}



static int
dissect_x2ap_PCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Neighbour_Information_item_sequence[] = {
  { &hf_x2ap_eCGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_pCI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PCI },
  { &hf_x2ap_eARFCN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EARFCN },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_Neighbour_Information_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_Neighbour_Information_item, Neighbour_Information_item_sequence);

  return offset;
}


static const per_sequence_t Neighbour_Information_sequence_of[1] = {
  { &hf_x2ap_Neighbour_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Neighbour_Information_item },
};

static int
dissect_x2ap_Neighbour_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_Neighbour_Information, Neighbour_Information_sequence_of,
                                                  0, maxnoofNeighbours, FALSE);

  return offset;
}


static const value_string x2ap_NewDRBIDrequest_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_NewDRBIDrequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_Number_of_Antennaports_vals[] = {
  {   0, "an1" },
  {   1, "an2" },
  {   2, "an4" },
  { 0, NULL }
};


static int
dissect_x2ap_Number_of_Antennaports(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_SSBIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValue_Item_sequence[] = {
  { &hf_x2ap_ssbIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SSBIndex },
  { &hf_x2ap_ssbAreaCapacityValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SSBAreaCapacityValue_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SSBAreaCapacityValue_Item, SSBAreaCapacityValue_Item_sequence);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValue_List_sequence_of[1] = {
  { &hf_x2ap_SSBAreaCapacityValue_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_SSBAreaCapacityValue_Item },
};

static int
dissect_x2ap_SSBAreaCapacityValue_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SSBAreaCapacityValue_List, SSBAreaCapacityValue_List_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t NRCapacityValue_sequence[] = {
  { &hf_x2ap_capacityValue_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaCapacityValue_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SSBAreaCapacityValue_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRCapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRCapacityValue, NRCapacityValue_sequence);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_2199_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_maxnoofNRPhysicalResourceBlocks_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofNRPhysicalResourceBlocks, NULL, TRUE);

  return offset;
}


static const per_sequence_t NRCarrierItem_sequence[] = {
  { &hf_x2ap_carrierSCS     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRSCS },
  { &hf_x2ap_offsetToCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_2199_ },
  { &hf_x2ap_carrierBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_maxnoofNRPhysicalResourceBlocks_ },
  { &hf_x2ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRCarrierItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRCarrierItem, NRCarrierItem_sequence);

  return offset;
}


static const per_sequence_t NRCarrierList_sequence_of[1] = {
  { &hf_x2ap_NRCarrierList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCarrierItem },
};

static int
dissect_x2ap_NRCarrierList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_NRCarrierList, NRCarrierList_sequence_of,
                                                  1, maxnoofNRSCSs, FALSE);

  return offset;
}



static int
dissect_x2ap_NRCellCapacityClassValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_NRCellPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 874 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_NRCellPRACHConfig);
    dissect_f1ap_NRPRACHConfig_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t NRCompositeAvailableCapacity_sequence[] = {
  { &hf_x2ap_cellCapacityClassValue_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRCellCapacityClassValue },
  { &hf_x2ap_capacityValue_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCapacityValue },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRCompositeAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRCompositeAvailableCapacity, NRCompositeAvailableCapacity_sequence);

  return offset;
}


static const per_sequence_t NRCompositeAvailableCapacityGroup_sequence[] = {
  { &hf_x2ap_compositeAvailableCapacityDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCompositeAvailableCapacity },
  { &hf_x2ap_compositeAvailableCapacityUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCompositeAvailableCapacity },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRCompositeAvailableCapacityGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRCompositeAvailableCapacityGroup, NRCompositeAvailableCapacityGroup_sequence);

  return offset;
}



static int
dissect_x2ap_NRPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_T_measurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 654 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t TDD_InfoNeighbourServedNRCell_Information_sequence[] = {
  { &hf_x2ap_nRFreqInfo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRFreqInfo },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TDD_InfoNeighbourServedNRCell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TDD_InfoNeighbourServedNRCell_Information, TDD_InfoNeighbourServedNRCell_Information_sequence);

  return offset;
}


static const value_string x2ap_T_nRNeighbourModeInfo_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  { 0, NULL }
};

static const per_choice_t T_nRNeighbourModeInfo_choice[] = {
  {   0, &hf_x2ap_fdd_01         , ASN1_EXTENSION_ROOT    , dissect_x2ap_FDD_InfoNeighbourServedNRCell_Information },
  {   1, &hf_x2ap_tdd_01         , ASN1_EXTENSION_ROOT    , dissect_x2ap_TDD_InfoNeighbourServedNRCell_Information },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_nRNeighbourModeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_nRNeighbourModeInfo, T_nRNeighbourModeInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NRNeighbour_Information_item_sequence[] = {
  { &hf_x2ap_nrpCI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRPCI },
  { &hf_x2ap_nrCellID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_FiveGS_TAC },
  { &hf_x2ap_configured_TAC , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_TAC },
  { &hf_x2ap_measurementTimingConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_measurementTimingConfiguration },
  { &hf_x2ap_nRNeighbourModeInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_nRNeighbourModeInfo },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRNeighbour_Information_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRNeighbour_Information_item, NRNeighbour_Information_item_sequence);

  return offset;
}


static const per_sequence_t NRNeighbour_Information_sequence_of[1] = {
  { &hf_x2ap_NRNeighbour_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_NRNeighbour_Information_item },
};

static int
dissect_x2ap_NRNeighbour_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_NRNeighbour_Information, NRNeighbour_Information_sequence_of,
                                                  1, maxofNRNeighbours, FALSE);

  return offset;
}


static const value_string x2ap_NPRACH_CP_Length_vals[] = {
  {   0, "us66dot7" },
  {   1, "us266dot7" },
  { 0, NULL }
};


static int
dissect_x2ap_NPRACH_CP_Length(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_T_anchorCarrier_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 735 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_anchorCarrier_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersList_NB_r13_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_T_anchorCarrier_EDT_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 744 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_anchorCarrier_EDT_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersList_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_T_anchorCarrier_Format2_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 753 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_anchorCarrier_Format2_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_T_anchorCarrier_Format2_EDT_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 762 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_anchorCarrier_Format2_EDT_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_T_non_anchorCarrier_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 771 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_non_anchorCarrier_NPRACHConfig);
    dissect_lte_rrc_UL_ConfigCommonList_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_T_non_anchorCarrier_Format2_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 780 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_non_anchorCarrier_Format2_NPRACHConfig);
    dissect_lte_rrc_UL_ConfigCommonList_NB_v1530_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t NPRACHConfiguration_FDD_sequence[] = {
  { &hf_x2ap_nprach_CP_length, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NPRACH_CP_Length },
  { &hf_x2ap_anchorCarrier_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_anchorCarrier_NPRACHConfig },
  { &hf_x2ap_anchorCarrier_EDT_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_anchorCarrier_EDT_NPRACHConfig },
  { &hf_x2ap_anchorCarrier_Format2_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_anchorCarrier_Format2_NPRACHConfig },
  { &hf_x2ap_anchorCarrier_Format2_EDT_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_anchorCarrier_Format2_EDT_NPRACHConfig },
  { &hf_x2ap_non_anchorCarrier_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_non_anchorCarrier_NPRACHConfig },
  { &hf_x2ap_non_anchorCarrier_Format2_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_non_anchorCarrier_Format2_NPRACHConfig },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NPRACHConfiguration_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NPRACHConfiguration_FDD, NPRACHConfiguration_FDD_sequence);

  return offset;
}


static const value_string x2ap_NPRACH_preambleFormat_vals[] = {
  {   0, "fmt0" },
  {   1, "fmt1" },
  {   2, "fmt2" },
  {   3, "fmt0a" },
  {   4, "fmt1a" },
  { 0, NULL }
};


static int
dissect_x2ap_NPRACH_preambleFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_T_anchorCarrier_NPRACHConfigTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 789 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_anchorCarrier_NPRACHConfigTDD);
    dissect_lte_rrc_NPRACH_ParametersListTDD_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_Non_anchorCarrierFrequency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 807 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_Non_anchorCarrierFrequency);
    dissect_lte_rrc_DL_CarrierConfigCommon_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t Non_AnchorCarrierFrequencylist_item_sequence[] = {
  { &hf_x2ap_non_anchorCarrioerFrquency, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Non_anchorCarrierFrequency },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_Non_AnchorCarrierFrequencylist_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_Non_AnchorCarrierFrequencylist_item, Non_AnchorCarrierFrequencylist_item_sequence);

  return offset;
}


static const per_sequence_t Non_AnchorCarrierFrequencylist_sequence_of[1] = {
  { &hf_x2ap_Non_AnchorCarrierFrequencylist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Non_AnchorCarrierFrequencylist_item },
};

static int
dissect_x2ap_Non_AnchorCarrierFrequencylist(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_Non_AnchorCarrierFrequencylist, Non_AnchorCarrierFrequencylist_sequence_of,
                                                  1, maxnoofNonAnchorCarrierFreqConfig, FALSE);

  return offset;
}



static int
dissect_x2ap_T_non_anchorCarrier_NPRACHConfigTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 798 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_non_anchorCarrier_NPRACHConfigTDD);
    dissect_lte_rrc_UL_ConfigCommonListTDD_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t NPRACHConfiguration_TDD_sequence[] = {
  { &hf_x2ap_nprach_preambleFormat, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NPRACH_preambleFormat },
  { &hf_x2ap_anchorCarrier_NPRACHConfigTDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_anchorCarrier_NPRACHConfigTDD },
  { &hf_x2ap_non_anchorCarrierFequencyConfiglist, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Non_AnchorCarrierFrequencylist },
  { &hf_x2ap_non_anchorCarrier_NPRACHConfigTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_non_anchorCarrier_NPRACHConfigTDD },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NPRACHConfiguration_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NPRACHConfiguration_TDD, NPRACHConfiguration_TDD_sequence);

  return offset;
}


static const value_string x2ap_T_fdd_or_tdd_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  { 0, NULL }
};

static const per_choice_t T_fdd_or_tdd_choice[] = {
  {   0, &hf_x2ap_fdd_02         , ASN1_EXTENSION_ROOT    , dissect_x2ap_NPRACHConfiguration_FDD },
  {   1, &hf_x2ap_tdd_02         , ASN1_EXTENSION_ROOT    , dissect_x2ap_NPRACHConfiguration_TDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_fdd_or_tdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_fdd_or_tdd, T_fdd_or_tdd_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPRACHConfiguration_sequence[] = {
  { &hf_x2ap_fdd_or_tdd     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_fdd_or_tdd },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NPRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NPRACHConfiguration, NPRACHConfiguration_sequence);

  return offset;
}


static const value_string x2ap_NRrestrictioninEPSasSecondaryRAT_vals[] = {
  {   0, "nRrestrictedinEPSasSecondaryRAT" },
  { 0, NULL }
};


static int
dissect_x2ap_NRrestrictioninEPSasSecondaryRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatus_Item_sequence[] = {
  { &hf_x2ap_ssbIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SSBIndex },
  { &hf_x2ap_ssbAreaDLGBRPRBUsage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaULGBRPRBUsage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaDLNonGBRPRBUsage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaULNonGBRPRBUsage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaDLTotalPRBUsage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaULTotalPRBUsage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaDLSchedulingPDCCHCCEUsage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_ssbAreaULSchedulingPDCCHCCEUsage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_0_100 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SSBAreaRadioResourceStatus_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SSBAreaRadioResourceStatus_Item, SSBAreaRadioResourceStatus_Item_sequence);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatus_List_sequence_of[1] = {
  { &hf_x2ap_SSBAreaRadioResourceStatus_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_SSBAreaRadioResourceStatus_Item },
};

static int
dissect_x2ap_SSBAreaRadioResourceStatus_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SSBAreaRadioResourceStatus_List, SSBAreaRadioResourceStatus_List_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t NRRadioResourceStatus_sequence[] = {
  { &hf_x2ap_ssbAreaRadioResourceStatus_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SSBAreaRadioResourceStatus_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRRadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRRadioResourceStatus, NRRadioResourceStatus_sequence);

  return offset;
}


static const value_string x2ap_NRrestrictionin5GS_vals[] = {
  {   0, "nRrestrictedin5GS" },
  { 0, NULL }
};


static int
dissect_x2ap_NRrestrictionin5GS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_NRencryptionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 592 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_x2ap_NRencryptionAlgorithms_NEA1,
      &hf_x2ap_NRencryptionAlgorithms_NEA2,
      &hf_x2ap_NRencryptionAlgorithms_NEA3,
      &hf_x2ap_NRencryptionAlgorithms_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_NRencryptionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_x2ap_NRintegrityProtectionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 607 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_x2ap_NRintegrityProtectionAlgorithms_NIA1,
      &hf_x2ap_NRintegrityProtectionAlgorithms_NIA2,
      &hf_x2ap_NRintegrityProtectionAlgorithms_NIA3,
      &hf_x2ap_NRintegrityProtectionAlgorithms_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_NRintegrityProtectionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const value_string x2ap_NRS_NSSS_PowerOffset_vals[] = {
  {   0, "minusThree" },
  {   1, "zero" },
  {   2, "three" },
  { 0, NULL }
};


static int
dissect_x2ap_NRS_NSSS_PowerOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_T_uENRMeasurements(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 287 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);

  x2ap_data->rrc_container_type = RRC_CONTAINER_TYPE_NR_UE_MEAS_REPORT;


  offset = dissect_x2ap_RRCContainer(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t NRUeReport_sequence[] = {
  { &hf_x2ap_uENRMeasurements, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_uENRMeasurements },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRUeReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRUeReport, NRUeReport_sequence);

  return offset;
}


static const per_sequence_t NRUESidelinkAggregateMaximumBitRate_sequence[] = {
  { &hf_x2ap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRUESidelinkAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRUESidelinkAggregateMaximumBitRate, NRUESidelinkAggregateMaximumBitRate_sequence);

  return offset;
}


static const per_sequence_t NRUESecurityCapabilities_sequence[] = {
  { &hf_x2ap_nRencryptionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRencryptionAlgorithms },
  { &hf_x2ap_nRintegrityProtectionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRintegrityProtectionAlgorithms },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRUESecurityCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRUESecurityCapabilities, NRUESecurityCapabilities_sequence);

  return offset;
}


static const value_string x2ap_NSSS_NumOccasionDifferentPrecoder_vals[] = {
  {   0, "two" },
  {   1, "four" },
  {   2, "eight" },
  { 0, NULL }
};


static int
dissect_x2ap_NSSS_NumOccasionDifferentPrecoder(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_VehicleUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_x2ap_VehicleUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_PedestrianUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_x2ap_PedestrianUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NRV2XServicesAuthorized_sequence[] = {
  { &hf_x2ap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_VehicleUE },
  { &hf_x2ap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_PedestrianUE },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_NRV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_NRV2XServicesAuthorized, NRV2XServicesAuthorized_sequence);

  return offset;
}


static const value_string x2ap_OffsetOfNbiotChannelNumberToEARFCN_vals[] = {
  {   0, "minusTen" },
  {   1, "minusNine" },
  {   2, "minusEight" },
  {   3, "minusSeven" },
  {   4, "minusSix" },
  {   5, "minusFive" },
  {   6, "minusFour" },
  {   7, "minusThree" },
  {   8, "minusTwo" },
  {   9, "minusOne" },
  {  10, "minusZeroDotFive" },
  {  11, "zero" },
  {  12, "one" },
  {  13, "two" },
  {  14, "three" },
  {  15, "four" },
  {  16, "five" },
  {  17, "six" },
  {  18, "seven" },
  {  19, "eight" },
  {  20, "nine" },
  {  21, "minusEightDotFive" },
  {  22, "minusFourDotFive" },
  {  23, "threeDotFive" },
  {  24, "sevenDotFive" },
  { 0, NULL }
};

static value_string_ext x2ap_OffsetOfNbiotChannelNumberToEARFCN_vals_ext = VALUE_STRING_EXT_INIT(x2ap_OffsetOfNbiotChannelNumberToEARFCN_vals);


static int
dissect_x2ap_OffsetOfNbiotChannelNumberToEARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     21, NULL, TRUE, 4, NULL);

  return offset;
}



static int
dissect_x2ap_Packet_LossRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PC5FlowBitRates_sequence[] = {
  { &hf_x2ap_guaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_maximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_PC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_PC5FlowBitRates, PC5FlowBitRates_sequence);

  return offset;
}


static const value_string x2ap_Range_vals[] = {
  {   0, "m50" },
  {   1, "m80" },
  {   2, "m180" },
  {   3, "m200" },
  {   4, "m350" },
  {   5, "m400" },
  {   6, "m500" },
  {   7, "m700" },
  {   8, "m1000" },
  { 0, NULL }
};


static int
dissect_x2ap_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PC5QoSFlowItem_sequence[] = {
  { &hf_x2ap_pQI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_FiveQI },
  { &hf_x2ap_pc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_PC5FlowBitRates },
  { &hf_x2ap_range          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Range },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_PC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_PC5QoSFlowItem, PC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t PC5QoSFlowList_sequence_of[1] = {
  { &hf_x2ap_PC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_PC5QoSFlowItem },
};

static int
dissect_x2ap_PC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_PC5QoSFlowList, PC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, FALSE);

  return offset;
}


static const per_sequence_t PC5QoSParameters_sequence[] = {
  { &hf_x2ap_pc5QoSFlowList , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PC5QoSFlowList },
  { &hf_x2ap_pc5LinkAggregatedBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BitRate },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_PC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_PC5QoSParameters, PC5QoSParameters_sequence);

  return offset;
}


static const value_string x2ap_PDCPChangeIndication_vals[] = {
  {   0, "s-KgNB-update-required" },
  {   1, "pDCP-data-recovery-required" },
  { 0, NULL }
};


static int
dissect_x2ap_PDCPChangeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_PDCPSnLength_vals[] = {
  {   0, "twelve-bits" },
  {   1, "eighteen-bits" },
  { 0, NULL }
};


static int
dissect_x2ap_PDCPSnLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_837(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 837U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_94(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 94U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PRACH_Configuration_sequence[] = {
  { &hf_x2ap_rootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_837 },
  { &hf_x2ap_zeroCorrelationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_15 },
  { &hf_x2ap_highSpeedFlag  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BOOLEAN },
  { &hf_x2ap_prach_FreqOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_94 },
  { &hf_x2ap_prach_ConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_0_63 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_PRACH_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_PRACH_Configuration, PRACH_Configuration_sequence);

  return offset;
}


static const value_string x2ap_ProSeDirectDiscovery_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_x2ap_ProSeDirectDiscovery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_ProSeDirectCommunication_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_x2ap_ProSeDirectCommunication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ProSeAuthorized_sequence[] = {
  { &hf_x2ap_proSeDirectDiscovery, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProSeDirectDiscovery },
  { &hf_x2ap_proSeDirectCommunication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProSeDirectCommunication },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ProSeAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ProSeAuthorized, ProSeAuthorized_sequence);

  return offset;
}


static const value_string x2ap_ProSeUEtoNetworkRelaying_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_x2ap_ProSeUEtoNetworkRelaying(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_ResourceType_vals[] = {
  {   0, "downlinknonCRS" },
  {   1, "cRS" },
  {   2, "uplink" },
  { 0, NULL }
};


static int
dissect_x2ap_ResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_84_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     84, 84, TRUE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_6_110_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 110, TRUE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_1_320_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 320U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_INTEGER_1_20_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 20U, NULL, TRUE);

  return offset;
}


static const per_sequence_t ProtectedFootprintTimePattern_sequence[] = {
  { &hf_x2ap_protectedFootprintTimePeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_320_ },
  { &hf_x2ap_protectedFootprintStartTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_20_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ProtectedFootprintTimePattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ProtectedFootprintTimePattern, ProtectedFootprintTimePattern_sequence);

  return offset;
}


static const per_sequence_t ProtectedResourceList_Item_sequence[] = {
  { &hf_x2ap_resourceType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ResourceType },
  { &hf_x2ap_intraPRBProtectedResourceFootprint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_84_ },
  { &hf_x2ap_protectedFootprintFrequencyPattern, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_6_110_ },
  { &hf_x2ap_protectedFootprintTimePattern, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtectedFootprintTimePattern },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ProtectedResourceList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ProtectedResourceList_Item, ProtectedResourceList_Item_sequence);

  return offset;
}


static const per_sequence_t ProtectedResourceList_sequence_of[1] = {
  { &hf_x2ap_ProtectedResourceList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtectedResourceList_Item },
};

static int
dissect_x2ap_ProtectedResourceList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ProtectedResourceList, ProtectedResourceList_sequence_of,
                                                  1, maxnoofProtectedResourcePatterns, FALSE);

  return offset;
}



static int
dissect_x2ap_T_mBSFNControlRegionLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

#line 665 "./asn1/x2ap/x2ap.cnf"
  proto_item_append_text(actx->created_item, " REs");


  return offset;
}



static int
dissect_x2ap_T_pDCCHRegionLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, FALSE);

#line 668 "./asn1/x2ap/x2ap.cnf"
  proto_item_append_text(actx->created_item, " REs");


  return offset;
}


static const per_sequence_t ProtectedEUTRAResourceIndication_sequence[] = {
  { &hf_x2ap_activationSFN  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_1023 },
  { &hf_x2ap_protectedResourceList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtectedResourceList },
  { &hf_x2ap_mBSFNControlRegionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_mBSFNControlRegionLength },
  { &hf_x2ap_pDCCHRegionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_pDCCHRegionLength },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ProtectedEUTRAResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ProtectedEUTRAResourceIndication, ProtectedEUTRAResourceIndication_sequence);

  return offset;
}


static const value_string x2ap_PartialListIndicator_vals[] = {
  {   0, "partial" },
  { 0, NULL }
};


static int
dissect_x2ap_PartialListIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_PrivacyIndicator_vals[] = {
  {   0, "immediate-MDT" },
  {   1, "logged-MDT" },
  { 0, NULL }
};


static int
dissect_x2ap_PrivacyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t QoS_Mapping_Information_sequence[] = {
  { &hf_x2ap_dscp           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BIT_STRING_SIZE_6 },
  { &hf_x2ap_flow_label     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BIT_STRING_SIZE_20 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_QoS_Mapping_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_QoS_Mapping_Information, QoS_Mapping_Information_sequence);

  return offset;
}



static int
dissect_x2ap_UL_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_UL_non_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_UL_Total_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t RadioResourceStatus_sequence[] = {
  { &hf_x2ap_dL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DL_GBR_PRB_usage },
  { &hf_x2ap_uL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_GBR_PRB_usage },
  { &hf_x2ap_dL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DL_non_GBR_PRB_usage },
  { &hf_x2ap_uL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_non_GBR_PRB_usage },
  { &hf_x2ap_dL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DL_Total_PRB_usage },
  { &hf_x2ap_uL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_Total_PRB_usage },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RadioResourceStatus, RadioResourceStatus_sequence);

  return offset;
}



static int
dissect_x2ap_RAN_UE_NGAP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_ReceiveStatusofULPDCPSDUs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4096, 4096, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_ReceiveStatusOfULPDCPSDUsExtended(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 16384, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_ReceiveStatusOfULPDCPSDUsPDCP_SNlength18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 131072, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_ReleaseFastMCGRecoveryViaSRB3_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_ReleaseFastMCGRecoveryViaSRB3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_Reestablishment_Indication_vals[] = {
  {   0, "reestablished" },
  { 0, NULL }
};


static int
dissect_x2ap_Reestablishment_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_Registration_Request_vals[] = {
  {   0, "start" },
  {   1, "stop" },
  {   2, "partial-stop" },
  {   3, "add" },
  { 0, NULL }
};


static int
dissect_x2ap_Registration_Request(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 850 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  if (x2ap_data->procedure_code == id_endcresourceStatusReportingInitiation)
    return dissect_x2ap_Registration_Request_ENDC(tvb, offset, actx, tree, hf_x2ap_Registration_Request_ENDC_PDU);


  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 2, NULL);

  return offset;
}


static const value_string x2ap_Registration_Request_ENDC_vals[] = {
  {   0, "start" },
  {   1, "stop" },
  {   2, "add" },
  { 0, NULL }
};


static int
dissect_x2ap_Registration_Request_ENDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_T_numberOfCellSpecificAntennaPorts_02_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "four" },
  { 0, NULL }
};


static int
dissect_x2ap_T_numberOfCellSpecificAntennaPorts_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_4_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, TRUE);

  return offset;
}


static const per_sequence_t RelativeNarrowbandTxPower_sequence[] = {
  { &hf_x2ap_rNTP_PerPRB    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_6_110_ },
  { &hf_x2ap_rNTP_Threshold , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RNTP_Threshold },
  { &hf_x2ap_numberOfCellSpecificAntennaPorts_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_numberOfCellSpecificAntennaPorts_02 },
  { &hf_x2ap_p_B            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_3_ },
  { &hf_x2ap_pDCCH_InterferenceImpact, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_4_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RelativeNarrowbandTxPower(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RelativeNarrowbandTxPower, RelativeNarrowbandTxPower_sequence);

  return offset;
}



static int
dissect_x2ap_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 860 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  if (x2ap_data->procedure_code == id_endcresourceStatusReportingInitiation)
    return dissect_x2ap_ReportCharacteristics_ENDC(tvb, offset, actx, tree, hf_x2ap_ReportCharacteristics_ENDC_PDU);


#line 170 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_ReportCharacteristics_PRBPeriodic,
      &hf_x2ap_ReportCharacteristics_TNLLoadIndPeriodic,
      &hf_x2ap_ReportCharacteristics_HWLoadIndPeriodic,
      &hf_x2ap_ReportCharacteristics_CompositeAvailableCapacityPeriodic,
      &hf_x2ap_ReportCharacteristics_ABSStatusPeriodic,
      &hf_x2ap_ReportCharacteristics_RSRPMeasurementReportPeriodic,
      &hf_x2ap_ReportCharacteristics_CSIReportPeriodic,
      &hf_x2ap_ReportCharacteristics_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_ReportCharacteristics);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 4, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const value_string x2ap_ReportingPeriodicityCSIR_vals[] = {
  {   0, "ms5" },
  {   1, "ms10" },
  {   2, "ms20" },
  {   3, "ms40" },
  {   4, "ms80" },
  { 0, NULL }
};


static int
dissect_x2ap_ReportingPeriodicityCSIR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_ReportCharacteristics_ENDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 816 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_ReportCharacteristics_ENDC_PRBPeriodic,
      &hf_x2ap_ReportCharacteristics_ENDC_TNLCapacityIndPeriodic,
      &hf_x2ap_ReportCharacteristics_ENDC_CompositeAvailableCapacityPeriodic,
      &hf_x2ap_ReportCharacteristics_ENDC_NumberOfActiveUEs,
      &hf_x2ap_ReportCharacteristics_ENDC_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_ReportCharacteristics_ENDC);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 4, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const value_string x2ap_ReportingPeriodicityRSRPMR_vals[] = {
  {   0, "one-hundred-20-ms" },
  {   1, "two-hundred-40-ms" },
  {   2, "four-hundred-80-ms" },
  {   3, "six-hundred-40-ms" },
  { 0, NULL }
};


static int
dissect_x2ap_ReportingPeriodicityRSRPMR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_RequestedFastMCGRecoveryViaSRB3_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_RequestedFastMCGRecoveryViaSRB3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_RequestedFastMCGRecoveryViaSRB3Release_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_RequestedFastMCGRecoveryViaSRB3Release(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_ResumeID_vals[] = {
  {   0, "non-truncated" },
  {   1, "truncated" },
  { 0, NULL }
};

static const per_choice_t ResumeID_choice[] = {
  {   0, &hf_x2ap_non_truncated  , ASN1_EXTENSION_ROOT    , dissect_x2ap_BIT_STRING_SIZE_40 },
  {   1, &hf_x2ap_truncated      , ASN1_EXTENSION_ROOT    , dissect_x2ap_BIT_STRING_SIZE_24 },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_ResumeID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_ResumeID, ResumeID_choice,
                                 NULL);

  return offset;
}


static const value_string x2ap_RLCMode_vals[] = {
  {   0, "rlc-am" },
  {   1, "rlc-um-bidirectional" },
  {   2, "rlc-um-unidirectional-ul" },
  {   3, "rlc-um-unidirectional-dl" },
  { 0, NULL }
};


static int
dissect_x2ap_RLCMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t RLC_Status_sequence[] = {
  { &hf_x2ap_reestablishment_Indication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Reestablishment_Indication },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RLC_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RLC_Status, RLC_Status_sequence);

  return offset;
}


static const value_string x2ap_RRC_Config_Ind_vals[] = {
  {   0, "full-config" },
  {   1, "delta-config" },
  { 0, NULL }
};


static int
dissect_x2ap_RRC_Config_Ind(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_RRC_Context(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 146 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_RRC_Context);
  if (g_x2ap_dissect_rrc_context_as == X2AP_RRC_CONTEXT_NBIOT) {
    dissect_lte_rrc_HandoverPreparationInformation_NB_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  } else {
    dissect_lte_rrc_HandoverPreparationInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string x2ap_RRCConnReestabIndicator_vals[] = {
  {   0, "reconfigurationFailure" },
  {   1, "handoverFailure" },
  {   2, "otherFailure" },
  { 0, NULL }
};


static int
dissect_x2ap_RRCConnReestabIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_RRCConnSetupIndicator_vals[] = {
  {   0, "rrcConnSetup" },
  { 0, NULL }
};


static int
dissect_x2ap_RRCConnSetupIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_97_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 97U, NULL, TRUE);

  return offset;
}


static const per_sequence_t RSRPMeasurementResult_item_sequence[] = {
  { &hf_x2ap_rSRPCellID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_rSRPMeasured   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_97_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RSRPMeasurementResult_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RSRPMeasurementResult_item, RSRPMeasurementResult_item_sequence);

  return offset;
}


static const per_sequence_t RSRPMeasurementResult_sequence_of[1] = {
  { &hf_x2ap_RSRPMeasurementResult_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_RSRPMeasurementResult_item },
};

static int
dissect_x2ap_RSRPMeasurementResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_RSRPMeasurementResult, RSRPMeasurementResult_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}


static const per_sequence_t RSRPMRList_item_sequence[] = {
  { &hf_x2ap_rSRPMeasurementResult, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RSRPMeasurementResult },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RSRPMRList_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RSRPMRList_item, RSRPMRList_item_sequence);

  return offset;
}


static const per_sequence_t RSRPMRList_sequence_of[1] = {
  { &hf_x2ap_RSRPMRList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_RSRPMRList_item },
};

static int
dissect_x2ap_RSRPMRList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_RSRPMRList, RSRPMRList_sequence_of,
                                                  1, maxUEReport, FALSE);

  return offset;
}


static const per_sequence_t S1TNLLoadIndicator_sequence[] = {
  { &hf_x2ap_dLS1TNLLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_LoadIndicator },
  { &hf_x2ap_uLS1TNLLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_LoadIndicator },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_S1TNLLoadIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_S1TNLLoadIndicator, S1TNLLoadIndicator_sequence);

  return offset;
}


static const value_string x2ap_SCGChangeIndication_vals[] = {
  {   0, "pDCPCountWrapAround" },
  {   1, "pSCellChange" },
  {   2, "other" },
  { 0, NULL }
};


static int
dissect_x2ap_SCGChangeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SecondaryRATUsageReportList_sequence_of[1] = {
  { &hf_x2ap_SecondaryRATUsageReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_SecondaryRATUsageReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SecondaryRATUsageReportList, SecondaryRATUsageReportList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const value_string x2ap_T_secondaryRATType_vals[] = {
  {   0, "nr" },
  {   1, "nR-unlicensed" },
  { 0, NULL }
};


static int
dissect_x2ap_T_secondaryRATType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 1, NULL);

  return offset;
}


static const per_sequence_t SecondaryRATUsageReport_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_secondaryRATType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_secondaryRATType },
  { &hf_x2ap_e_RABUsageReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RABUsageReportList },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SecondaryRATUsageReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SecondaryRATUsageReport_Item, SecondaryRATUsageReport_Item_sequence);

  return offset;
}



static int
dissect_x2ap_SeNBSecurityKey(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_SeNBtoMeNBContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 247 "./asn1/x2ap/x2ap.cnf"
 tvbuff_t *parameter_tvb;
 proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_SeNBtoMeNBContainer);
  dissect_lte_rrc_SCG_Config_r12_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}


static const per_sequence_t ServedCell_Information_sequence[] = {
  { &hf_x2ap_pCI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PCI },
  { &hf_x2ap_cellId         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TAC },
  { &hf_x2ap_broadcastPLMNs , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BroadcastPLMNs_Item },
  { &hf_x2ap_eUTRA_Mode_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EUTRA_Mode_Info },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedCell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedCell_Information, ServedCell_Information_sequence);

  return offset;
}


static const per_sequence_t ServedCells_item_sequence[] = {
  { &hf_x2ap_servedCellInfo , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedCell_Information },
  { &hf_x2ap_neighbour_Info , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Neighbour_Information },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedCells_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedCells_item, ServedCells_item_sequence);

  return offset;
}


static const per_sequence_t ServedCells_sequence_of[1] = {
  { &hf_x2ap_ServedCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedCells_item },
};

static int
dissect_x2ap_ServedCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedCells, ServedCells_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const value_string x2ap_ServiceType_vals[] = {
  {   0, "qMC-for-streaming-service" },
  {   1, "qMC-for-MTSI-service" },
  { 0, NULL }
};


static int
dissect_x2ap_ServiceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_SgNBCoordinationAssistanceInformation_vals[] = {
  {   0, "coordination-not-required" },
  { 0, NULL }
};


static int
dissect_x2ap_SgNBCoordinationAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SgNBResourceCoordinationInformation_sequence[] = {
  { &hf_x2ap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_uLCoordinationInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_6_4400_ },
  { &hf_x2ap_dLCoordinationInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BIT_STRING_SIZE_6_4400_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBResourceCoordinationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBResourceCoordinationInformation, SgNBResourceCoordinationInformation_sequence);

  return offset;
}



static int
dissect_x2ap_SgNB_UE_X2AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_SIPTOBearerDeactivationIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_SIPTOBearerDeactivationIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_ShortMAC_I(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_SGNB_Addition_Trigger_Ind_vals[] = {
  {   0, "sn-change" },
  {   1, "inter-eNB-HO" },
  {   2, "intra-eNB-HO" },
  { 0, NULL }
};


static int
dissect_x2ap_SGNB_Addition_Trigger_Ind(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_SNtriggered_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_SNtriggered(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_SpectrumSharingGroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellineNB, NULL, FALSE);

  return offset;
}


static const value_string x2ap_T_periodicCommunicationIndicator_vals[] = {
  {   0, "periodically" },
  {   1, "ondemand" },
  { 0, NULL }
};


static int
dissect_x2ap_T_periodicCommunicationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_1_3600_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3600U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_86399_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 86399U, NULL, TRUE);

  return offset;
}


static const per_sequence_t ScheduledCommunicationTime_sequence[] = {
  { &hf_x2ap_dayofWeek      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BIT_STRING_SIZE_7 },
  { &hf_x2ap_timeofDayStart , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_0_86399_ },
  { &hf_x2ap_timeofDayEnd   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_0_86399_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ScheduledCommunicationTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ScheduledCommunicationTime, ScheduledCommunicationTime_sequence);

  return offset;
}


static const value_string x2ap_T_stationaryIndication_vals[] = {
  {   0, "stationary" },
  {   1, "mobile" },
  { 0, NULL }
};


static int
dissect_x2ap_T_stationaryIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_T_trafficProfile_vals[] = {
  {   0, "single-packet" },
  {   1, "dual-packets" },
  {   2, "multiple-packets" },
  { 0, NULL }
};


static int
dissect_x2ap_T_trafficProfile(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_T_batteryIndication_vals[] = {
  {   0, "battery-powered" },
  {   1, "battery-powered-not-rechargeable-or-replaceable" },
  {   2, "not-battery-powered" },
  { 0, NULL }
};


static int
dissect_x2ap_T_batteryIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Subscription_Based_UE_DifferentiationInfo_sequence[] = {
  { &hf_x2ap_periodicCommunicationIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_periodicCommunicationIndicator },
  { &hf_x2ap_periodicTime   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_1_3600_ },
  { &hf_x2ap_scheduledCommunicationTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ScheduledCommunicationTime },
  { &hf_x2ap_stationaryIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_stationaryIndication },
  { &hf_x2ap_trafficProfile , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_trafficProfile },
  { &hf_x2ap_batteryIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_batteryIndication },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_Subscription_Based_UE_DifferentiationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_Subscription_Based_UE_DifferentiationInfo, Subscription_Based_UE_DifferentiationInfo_sequence);

  return offset;
}


static const value_string x2ap_SRVCCOperationPossible_vals[] = {
  {   0, "possible" },
  { 0, NULL }
};


static int
dissect_x2ap_SRVCCOperationPossible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_SSB_PositionsInBurst_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_PositionsInBurst_choice[] = {
  {   0, &hf_x2ap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_x2ap_BIT_STRING_SIZE_4 },
  {   1, &hf_x2ap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_x2ap_BIT_STRING_SIZE_8 },
  {   2, &hf_x2ap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_x2ap_BIT_STRING_SIZE_64 },
  {   3, &hf_x2ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_x2ap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_SSB_PositionsInBurst(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_SSB_PositionsInBurst, SSB_PositionsInBurst_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_SubscriberProfileIDforRFP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_SgNBSecurityKey(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_x2ap_SgNBtoMeNBContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 273 "./asn1/x2ap/x2ap.cnf"
 tvbuff_t *parameter_tvb;
 proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_SgNBtoMeNBContainer);
  dissect_nr_rrc_CG_Config_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}


static const value_string x2ap_SCGConfigurationQuery_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_SCGConfigurationQuery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SFN_Offset_sequence[] = {
  { &hf_x2ap_sFN_Time_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_24 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SFN_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SFN_Offset, SFN_Offset_sequence);

  return offset;
}



static int
dissect_x2ap_TargetCellInNGRAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 832 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_TargetCellInNGRAN);
    dissect_ngap_NGRAN_CGI_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_x2ap_TargetCellInUTRAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_x2ap_TargeteNBtoSource_eNBTransparentContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 91 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_TargeteNBtoSource_eNBTransparentContainer);
  dissect_lte_rrc_HandoverCommand_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}



static int
dissect_x2ap_TDDULDLConfigurationCommonNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 841 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_TDDULDLConfigurationCommonNR);
    dissect_nr_rrc_TDD_UL_DL_ConfigCommon_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string x2ap_TimeToWait_vals[] = {
  {   0, "v1s" },
  {   1, "v2s" },
  {   2, "v5s" },
  {   3, "v10s" },
  {   4, "v20s" },
  {   5, "v60s" },
  { 0, NULL }
};


static int
dissect_x2ap_TimeToWait(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_Time_UE_StayedInCell_EnhancedGranularity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 40950U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_TNLAssociationUsage_vals[] = {
  {   0, "ue" },
  {   1, "non-ue" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_x2ap_TNLAssociationUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TNLA_To_Add_Item_sequence[] = {
  { &hf_x2ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CPTransportLayerInformation },
  { &hf_x2ap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TNLAssociationUsage },
  { &hf_x2ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TNLA_To_Add_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TNLA_To_Add_Item, TNLA_To_Add_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_To_Add_List_sequence_of[1] = {
  { &hf_x2ap_TNLA_To_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TNLA_To_Add_Item },
};

static int
dissect_x2ap_TNLA_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TNLA_To_Add_List, TNLA_To_Add_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_To_Update_Item_sequence[] = {
  { &hf_x2ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CPTransportLayerInformation },
  { &hf_x2ap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_x2ap_TNLAssociationUsage },
  { &hf_x2ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TNLA_To_Update_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TNLA_To_Update_Item, TNLA_To_Update_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_To_Update_List_sequence_of[1] = {
  { &hf_x2ap_TNLA_To_Update_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TNLA_To_Update_Item },
};

static int
dissect_x2ap_TNLA_To_Update_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TNLA_To_Update_List, TNLA_To_Update_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_To_Remove_Item_sequence[] = {
  { &hf_x2ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CPTransportLayerInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TNLA_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TNLA_To_Remove_Item, TNLA_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_To_Remove_List_sequence_of[1] = {
  { &hf_x2ap_TNLA_To_Remove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TNLA_To_Remove_Item },
};

static int
dissect_x2ap_TNLA_To_Remove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TNLA_To_Remove_List, TNLA_To_Remove_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_Setup_Item_sequence[] = {
  { &hf_x2ap_tNLAssociationTransportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_CPTransportLayerInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TNLA_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TNLA_Setup_Item, TNLA_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_Setup_List_sequence_of[1] = {
  { &hf_x2ap_TNLA_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TNLA_Setup_Item },
};

static int
dissect_x2ap_TNLA_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TNLA_Setup_List, TNLA_Setup_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_Failed_To_Setup_Item_sequence[] = {
  { &hf_x2ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_CPTransportLayerInformation },
  { &hf_x2ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Cause },
  { &hf_x2ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TNLA_Failed_To_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TNLA_Failed_To_Setup_Item, TNLA_Failed_To_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_Failed_To_Setup_List_sequence_of[1] = {
  { &hf_x2ap_TNLA_Failed_To_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_TNLA_Failed_To_Setup_Item },
};

static int
dissect_x2ap_TNLA_Failed_To_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_TNLA_Failed_To_Setup_List, TNLA_Failed_To_Setup_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}



static int
dissect_x2ap_INTEGER_1_16777216_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16777216U, NULL, TRUE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_100_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, TRUE);

  return offset;
}


static const per_sequence_t TNLCapacityIndicator_sequence[] = {
  { &hf_x2ap_dlTNLMaximumOfferedCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_16777216_ },
  { &hf_x2ap_dlTNLAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100_ },
  { &hf_x2ap_ulTNLMaximumOfferedCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_1_16777216_ },
  { &hf_x2ap_ulTNLAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_100_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TNLCapacityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TNLCapacityIndicator, TNLCapacityIndicator_sequence);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Addresses_Info_To_Add_Item_sequence[] = {
  { &hf_x2ap_iP_SecTransportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TransportLayerAddress },
  { &hf_x2ap_gTPTransportLayerAddressesToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPTLAs },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_Item, Transport_UP_Layer_Addresses_Info_To_Add_Item_sequence);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Addresses_Info_To_Add_List_sequence_of[1] = {
  { &hf_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_Item },
};

static int
dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_List, Transport_UP_Layer_Addresses_Info_To_Add_List_sequence_of,
                                                  1, maxnoofTLAs, FALSE);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Addresses_Info_To_Remove_Item_sequence[] = {
  { &hf_x2ap_iP_SecTransportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TransportLayerAddress },
  { &hf_x2ap_gTPTransportLayerAddressesToRemove, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPTLAs },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_Item, Transport_UP_Layer_Addresses_Info_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Addresses_Info_To_Remove_List_sequence_of[1] = {
  { &hf_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_Item },
};

static int
dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_List, Transport_UP_Layer_Addresses_Info_To_Remove_List_sequence_of,
                                                  1, maxnoofTLAs, FALSE);

  return offset;
}


static const per_sequence_t TNLConfigurationInfo_sequence[] = {
  { &hf_x2ap_transport_UP_Layer_Addresses_Info_To_Add_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Add_List },
  { &hf_x2ap_transport_UP_Layer_Addresses_Info_To_Remove_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Transport_UP_Layer_Addresses_Info_To_Remove_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TNLConfigurationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TNLConfigurationInfo, TNLConfigurationInfo_sequence);

  return offset;
}


static const value_string x2ap_TraceDepth_vals[] = {
  {   0, "minimum" },
  {   1, "medium" },
  {   2, "maximum" },
  {   3, "minimumWithoutVendorSpecificExtension" },
  {   4, "mediumWithoutVendorSpecificExtension" },
  {   5, "maximumWithoutVendorSpecificExtension" },
  { 0, NULL }
};


static int
dissect_x2ap_TraceDepth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_TraceCollectionEntityIPAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 353 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  int len;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, TRUE, NULL, 0, &parameter_tvb, &len);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_TraceCollectionEntityIPAddress);
  if (len == 32) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_x2ap_traceCollectionEntityIPAddress_IPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
  } else if (len == 128) {
    /* IPv6 */
     proto_tree_add_item(subtree, hf_x2ap_traceCollectionEntityIPAddress_IPv6, parameter_tvb, 0, 16, ENC_NA);
  } else if (len == 160) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_x2ap_traceCollectionEntityIPAddress_IPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
    /* IPv6 */
     proto_tree_add_item(subtree, hf_x2ap_traceCollectionEntityIPAddress_IPv6, parameter_tvb, 4, 16, ENC_NA);
  }



  return offset;
}


static const per_sequence_t TraceActivation_sequence[] = {
  { &hf_x2ap_eUTRANTraceID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EUTRANTraceID },
  { &hf_x2ap_interfacesToTrace, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_InterfacesToTrace },
  { &hf_x2ap_traceDepth     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TraceDepth },
  { &hf_x2ap_traceCollectionEntityIPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TraceCollectionEntityIPAddress },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TraceActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TraceActivation, TraceActivation_sequence);

  return offset;
}


static const per_sequence_t TunnelInformation_sequence[] = {
  { &hf_x2ap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_TransportLayerAddress },
  { &hf_x2ap_uDP_Port_Number, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Port_Number },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TunnelInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TunnelInformation, TunnelInformation_sequence);

  return offset;
}


static const per_sequence_t UEAggregateMaximumBitRate_sequence[] = {
  { &hf_x2ap_uEaggregateMaximumBitRateDownlink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_uEaggregateMaximumBitRateUplink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UEAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UEAggregateMaximumBitRate, UEAggregateMaximumBitRate_sequence);

  return offset;
}



static int
dissect_x2ap_OCTET_STRING_SIZE_1_1000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1000, FALSE, NULL);

  return offset;
}


static const per_sequence_t UEAppLayerMeasConfig_sequence[] = {
  { &hf_x2ap_containerForAppLayerMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_OCTET_STRING_SIZE_1_1000 },
  { &hf_x2ap_areaScopeOfQMC , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_AreaScopeOfQMC },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UEAppLayerMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UEAppLayerMeasConfig, UEAppLayerMeasConfig_sequence);

  return offset;
}


static const value_string x2ap_UE_ContextKeptIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_UE_ContextKeptIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t UE_HistoryInformation_sequence_of[1] = {
  { &hf_x2ap_UE_HistoryInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_LastVisitedCell_Item },
};

static int
dissect_x2ap_UE_HistoryInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_UE_HistoryInformation, UE_HistoryInformation_sequence_of,
                                                  1, maxnoofCells, FALSE);

  return offset;
}



static int
dissect_x2ap_UE_HistoryInformationFromTheUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 161 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_UE_HistoryInformationFromTheUE);
  dissect_lte_rrc_VisitedCellInfoList_r12_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}



static int
dissect_x2ap_UE_S1AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}



static int
dissect_x2ap_UERadioCapability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 892 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_UERadioCapability);
    dissect_lte_rrc_UERadioAccessCapabilityInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_x2ap_UERadioCapabilityID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_x2ap_UE_RLF_Report_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 211 "./asn1/x2ap/x2ap.cnf"
 tvbuff_t *parameter_tvb;
 proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_UE_RLF_Report_Container);
  dissect_lte_rrc_RLF_Report_r9_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}



static int
dissect_x2ap_UE_RLF_Report_Container_for_extended_bands(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 220 "./asn1/x2ap/x2ap.cnf"
 tvbuff_t *parameter_tvb;
 proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_UE_RLF_Report_Container_for_extended_bands);
  dissect_lte_rrc_RLF_Report_v9e0_PDU(parameter_tvb, actx->pinfo, subtree, NULL);



  return offset;
}


static const per_sequence_t UESecurityCapabilities_sequence[] = {
  { &hf_x2ap_encryptionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EncryptionAlgorithms },
  { &hf_x2ap_integrityProtectionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_IntegrityProtectionAlgorithms },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UESecurityCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UESecurityCapabilities, UESecurityCapabilities_sequence);

  return offset;
}


static const per_sequence_t UESidelinkAggregateMaximumBitRate_sequence[] = {
  { &hf_x2ap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BitRate },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UESidelinkAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UESidelinkAggregateMaximumBitRate, UESidelinkAggregateMaximumBitRate_sequence);

  return offset;
}


static const per_sequence_t UEsToBeResetList_Item_sequence[] = {
  { &hf_x2ap_meNB_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UE_X2AP_ID },
  { &hf_x2ap_meNB_ID_ext    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UE_X2AP_ID_Extension },
  { &hf_x2ap_sgNB_ID        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SgNB_UE_X2AP_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UEsToBeResetList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UEsToBeResetList_Item, UEsToBeResetList_Item_sequence);

  return offset;
}


static const per_sequence_t UEsToBeResetList_sequence_of[1] = {
  { &hf_x2ap_UEsToBeResetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_UEsToBeResetList_Item },
};

static int
dissect_x2ap_UEsToBeResetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_UEsToBeResetList, UEsToBeResetList_sequence_of,
                                                  1, maxUEsinengNBDU, FALSE);

  return offset;
}


static const value_string x2ap_UL_UE_Configuration_vals[] = {
  {   0, "no-data" },
  {   1, "shared" },
  {   2, "only" },
  { 0, NULL }
};


static int
dissect_x2ap_UL_UE_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ULConfiguration_sequence[] = {
  { &hf_x2ap_uL_PDCP        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_UE_Configuration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ULConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ULConfiguration, ULConfiguration_sequence);

  return offset;
}



static int
dissect_x2ap_UL_HighInterferenceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 110, TRUE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t UL_HighInterferenceIndicationInfo_Item_sequence[] = {
  { &hf_x2ap_target_Cell_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_ul_interferenceindication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_HighInterferenceIndication },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UL_HighInterferenceIndicationInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UL_HighInterferenceIndicationInfo_Item, UL_HighInterferenceIndicationInfo_Item_sequence);

  return offset;
}


static const per_sequence_t UL_HighInterferenceIndicationInfo_sequence_of[1] = {
  { &hf_x2ap_UL_HighInterferenceIndicationInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_UL_HighInterferenceIndicationInfo_Item },
};

static int
dissect_x2ap_UL_HighInterferenceIndicationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_UL_HighInterferenceIndicationInfo, UL_HighInterferenceIndicationInfo_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}



static int
dissect_x2ap_UL_scheduling_PDCCH_CCE_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const value_string x2ap_UnlicensedSpectrumRestriction_vals[] = {
  {   0, "unlicensed-restricted" },
  { 0, NULL }
};


static int
dissect_x2ap_UnlicensedSpectrumRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_URI_Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, FALSE);

  return offset;
}


static const per_sequence_t V2XServicesAuthorized_sequence[] = {
  { &hf_x2ap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_VehicleUE },
  { &hf_x2ap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_PedestrianUE },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_V2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_V2XServicesAuthorized, V2XServicesAuthorized_sequence);

  return offset;
}


static const value_string x2ap_WLANMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_x2ap_WLANMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_x2ap_WLANName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 684 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 32, FALSE, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);


  return offset;
}


static const per_sequence_t WLANMeasConfigNameList_sequence_of[1] = {
  { &hf_x2ap_WLANMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_WLANName },
};

static int
dissect_x2ap_WLANMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_WLANMeasConfigNameList, WLANMeasConfigNameList_sequence_of,
                                                  1, maxnoofWLANName, FALSE);

  return offset;
}


static const value_string x2ap_T_wlan_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_T_wlan_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_T_wlan_rtt_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_x2ap_T_wlan_rtt(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t WLANMeasurementConfiguration_sequence[] = {
  { &hf_x2ap_wlanMeasConfig , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_WLANMeasConfig },
  { &hf_x2ap_wlanMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_WLANMeasConfigNameList },
  { &hf_x2ap_wlan_rssi      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_wlan_rssi },
  { &hf_x2ap_wlan_rtt       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_T_wlan_rtt },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_WLANMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_WLANMeasurementConfiguration, WLANMeasurementConfiguration_sequence);

  return offset;
}


static const per_sequence_t WTID_Type1_sequence[] = {
  { &hf_x2ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PLMN_Identity },
  { &hf_x2ap_shortWTID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BIT_STRING_SIZE_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_WTID_Type1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_WTID_Type1, WTID_Type1_sequence);

  return offset;
}



static int
dissect_x2ap_WTID_Long_Type2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     48, 48, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string x2ap_WTID_vals[] = {
  {   0, "wTID-Type1" },
  {   1, "wTID-Type2" },
  { 0, NULL }
};

static const per_choice_t WTID_choice[] = {
  {   0, &hf_x2ap_wTID_Type1     , ASN1_EXTENSION_ROOT    , dissect_x2ap_WTID_Type1 },
  {   1, &hf_x2ap_wTID_Type2     , ASN1_EXTENSION_ROOT    , dissect_x2ap_WTID_Long_Type2 },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_WTID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_WTID, WTID_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_WT_UE_XwAP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, NULL);

  return offset;
}



static int
dissect_x2ap_X2BenefitValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t HandoverRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HandoverRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 902 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HandoverRequest, HandoverRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeSetup_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeSetup_List, E_RABs_ToBeSetup_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t UE_ContextInformation_sequence[] = {
  { &hf_x2ap_mME_UE_S1AP_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UE_S1AP_ID },
  { &hf_x2ap_uESecurityCapabilities, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UESecurityCapabilities },
  { &hf_x2ap_aS_SecurityInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_AS_SecurityInformation },
  { &hf_x2ap_uEaggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UEAggregateMaximumBitRate },
  { &hf_x2ap_subscriberProfileIDforRFP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SubscriberProfileIDforRFP },
  { &hf_x2ap_e_RABs_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RABs_ToBeSetup_List },
  { &hf_x2ap_rRC_Context    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RRC_Context },
  { &hf_x2ap_handoverRestrictionList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_HandoverRestrictionList },
  { &hf_x2ap_locationReportingInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_LocationReportingInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UE_ContextInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UE_ContextInformation, UE_ContextInformation_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeSetup_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_dL_Forwarding  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_DL_Forwarding },
  { &hf_x2ap_uL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeSetup_Item, E_RABs_ToBeSetup_Item_sequence);

  return offset;
}



static int
dissect_x2ap_MobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t UE_ContextReferenceAtSeNB_sequence[] = {
  { &hf_x2ap_source_GlobalSeNB_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GlobalENB_ID },
  { &hf_x2ap_seNB_UE_X2AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UE_X2AP_ID },
  { &hf_x2ap_seNB_UE_X2AP_ID_Extension, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UE_X2AP_ID_Extension },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UE_ContextReferenceAtSeNB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UE_ContextReferenceAtSeNB, UE_ContextReferenceAtSeNB_sequence);

  return offset;
}


static const per_sequence_t UE_ContextReferenceAtWT_sequence[] = {
  { &hf_x2ap_wTID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_WTID },
  { &hf_x2ap_wT_UE_XwAP_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_WT_UE_XwAP_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UE_ContextReferenceAtWT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UE_ContextReferenceAtWT, UE_ContextReferenceAtWT_sequence);

  return offset;
}


static const per_sequence_t UE_ContextReferenceAtSgNB_sequence[] = {
  { &hf_x2ap_source_GlobalSgNB_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GlobalGNB_ID },
  { &hf_x2ap_sgNB_UE_X2AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SgNB_UE_X2AP_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UE_ContextReferenceAtSgNB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UE_ContextReferenceAtSgNB, UE_ContextReferenceAtSgNB_sequence);

  return offset;
}


static const per_sequence_t HandoverRequestAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HandoverRequestAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 904 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverRequestAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HandoverRequestAcknowledge, HandoverRequestAcknowledge_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_List, E_RABs_Admitted_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_uL_GTP_TunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_GTP_TunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_Item, E_RABs_Admitted_Item_sequence);

  return offset;
}


static const per_sequence_t HandoverPreparationFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HandoverPreparationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 906 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverPreparationFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HandoverPreparationFailure, HandoverPreparationFailure_sequence);

  return offset;
}


static const per_sequence_t HandoverReport_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HandoverReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 944 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverReport");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HandoverReport, HandoverReport_sequence);

  return offset;
}


static const per_sequence_t EarlyStatusTransfer_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_EarlyStatusTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1092 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "EarlyStatusTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_EarlyStatusTransfer, EarlyStatusTransfer_sequence);

  return offset;
}


static const per_sequence_t FirstDLCount_sequence[] = {
  { &hf_x2ap_e_RABsSubjectToEarlyStatusTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RABsSubjectToEarlyStatusTransfer_List },
  { &hf_x2ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_FirstDLCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_FirstDLCount, FirstDLCount_sequence);

  return offset;
}


static const per_sequence_t DLDiscarding_sequence[] = {
  { &hf_x2ap_e_RABsSubjectToDLDiscarding_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RABsSubjectToDLDiscarding_List },
  { &hf_x2ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DLDiscarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DLDiscarding, DLDiscarding_sequence);

  return offset;
}


static const value_string x2ap_ProcedureStageChoice_vals[] = {
  {   0, "first-dl-count" },
  {   1, "dl-discarding" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ProcedureStageChoice_choice[] = {
  {   0, &hf_x2ap_first_dl_count , ASN1_NO_EXTENSIONS     , dissect_x2ap_FirstDLCount },
  {   1, &hf_x2ap_dl_discarding  , ASN1_NO_EXTENSIONS     , dissect_x2ap_DLDiscarding },
  {   2, &hf_x2ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_x2ap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_ProcedureStageChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_ProcedureStageChoice, ProcedureStageChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SNStatusTransfer_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SNStatusTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 908 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SNStatusTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SNStatusTransfer, SNStatusTransfer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_SubjectToStatusTransfer_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_SubjectToStatusTransfer_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_SubjectToStatusTransfer_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_SubjectToStatusTransfer_List, E_RABs_SubjectToStatusTransfer_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_SubjectToStatusTransfer_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_receiveStatusofULPDCPSDUs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ReceiveStatusofULPDCPSDUs },
  { &hf_x2ap_uL_COUNTvalue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_COUNTvalue },
  { &hf_x2ap_dL_COUNTvalue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_COUNTvalue },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_SubjectToStatusTransfer_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_SubjectToStatusTransfer_Item, E_RABs_SubjectToStatusTransfer_Item_sequence);

  return offset;
}


static const per_sequence_t UEContextRelease_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UEContextRelease(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 910 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "UEContextRelease");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UEContextRelease, UEContextRelease_sequence);

  return offset;
}


static const per_sequence_t HandoverCancel_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HandoverCancel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 912 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverCancel");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HandoverCancel, HandoverCancel_sequence);

  return offset;
}


static const per_sequence_t HandoverSuccess_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_HandoverSuccess(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1090 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverSuccess");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_HandoverSuccess, HandoverSuccess_sequence);

  return offset;
}


static const per_sequence_t ConditionalHandoverCancel_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ConditionalHandoverCancel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1094 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ConditionalHandoverCancel");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ConditionalHandoverCancel, ConditionalHandoverCancel_sequence);

  return offset;
}


static const per_sequence_t ErrorIndication_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ErrorIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 914 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ErrorIndication");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ErrorIndication, ErrorIndication_sequence);

  return offset;
}


static const per_sequence_t ResetRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResetRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 916 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ResetRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResetRequest, ResetRequest_sequence);

  return offset;
}


static const per_sequence_t ResetResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResetResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 918 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ResetResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResetResponse, ResetResponse_sequence);

  return offset;
}


static const per_sequence_t X2SetupRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2SetupRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 920 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2SetupRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2SetupRequest, X2SetupRequest_sequence);

  return offset;
}


static const per_sequence_t X2SetupResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2SetupResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 922 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2SetupResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2SetupResponse, X2SetupResponse_sequence);

  return offset;
}


static const per_sequence_t X2SetupFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2SetupFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 924 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2SetupFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2SetupFailure, X2SetupFailure_sequence);

  return offset;
}


static const per_sequence_t LoadInformation_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_LoadInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 926 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "LoadInformation");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_LoadInformation, LoadInformation_sequence);

  return offset;
}


static const per_sequence_t CellInformation_List_sequence_of[1] = {
  { &hf_x2ap_CellInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CellInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellInformation_List, CellInformation_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellInformation_Item_sequence[] = {
  { &hf_x2ap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_ul_InterferenceOverloadIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UL_InterferenceOverloadIndication },
  { &hf_x2ap_ul_HighInterferenceIndicationInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UL_HighInterferenceIndicationInfo },
  { &hf_x2ap_relativeNarrowbandTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_RelativeNarrowbandTxPower },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellInformation_Item, CellInformation_Item_sequence);

  return offset;
}


static const per_sequence_t ENBConfigurationUpdate_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENBConfigurationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 928 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENBConfigurationUpdate");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENBConfigurationUpdate, ENBConfigurationUpdate_sequence);

  return offset;
}


static const per_sequence_t ServedCellsToModify_Item_sequence[] = {
  { &hf_x2ap_old_ecgi       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_servedCellInfo , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedCell_Information },
  { &hf_x2ap_neighbour_Info , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_Neighbour_Information },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedCellsToModify_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedCellsToModify_Item, ServedCellsToModify_Item_sequence);

  return offset;
}


static const per_sequence_t ServedCellsToModify_sequence_of[1] = {
  { &hf_x2ap_ServedCellsToModify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedCellsToModify_Item },
};

static int
dissect_x2ap_ServedCellsToModify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedCellsToModify, ServedCellsToModify_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t Old_ECGIs_sequence_of[1] = {
  { &hf_x2ap_Old_ECGIs_item , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_Old_ECGIs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_Old_ECGIs, Old_ECGIs_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t ENBConfigurationUpdateAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENBConfigurationUpdateAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 930 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENBConfigurationUpdateAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENBConfigurationUpdateAcknowledge, ENBConfigurationUpdateAcknowledge_sequence);

  return offset;
}


static const per_sequence_t ENBConfigurationUpdateFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENBConfigurationUpdateFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 932 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENBConfigurationUpdateFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENBConfigurationUpdateFailure, ENBConfigurationUpdateFailure_sequence);

  return offset;
}


static const per_sequence_t ResourceStatusRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResourceStatusRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 934 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ResourceStatusRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResourceStatusRequest, ResourceStatusRequest_sequence);

  return offset;
}


static const per_sequence_t CellToReport_List_sequence_of[1] = {
  { &hf_x2ap_CellToReport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CellToReport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellToReport_List, CellToReport_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellToReport_Item_sequence[] = {
  { &hf_x2ap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellToReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellToReport_Item, CellToReport_Item_sequence);

  return offset;
}


static const value_string x2ap_ReportingPeriodicity_vals[] = {
  {   0, "one-thousand-ms" },
  {   1, "two-thousand-ms" },
  {   2, "five-thousand-ms" },
  {   3, "ten-thousand-ms" },
  { 0, NULL }
};


static int
dissect_x2ap_ReportingPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 855 "./asn1/x2ap/x2ap.cnf"
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(actx->pinfo);
  if (x2ap_data->procedure_code == id_endcresourceStatusReportingInitiation)
    return dissect_x2ap_ReportingPeriodicity_ENDC(tvb, offset, actx, tree, hf_x2ap_ReportingPeriodicity_ENDC_PDU);


  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_PartialSuccessIndicator_vals[] = {
  {   0, "partial-success-allowed" },
  { 0, NULL }
};


static int
dissect_x2ap_PartialSuccessIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceStatusResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResourceStatusResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 936 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ResourceStatusResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResourceStatusResponse, ResourceStatusResponse_sequence);

  return offset;
}


static const per_sequence_t MeasurementInitiationResult_List_sequence_of[1] = {
  { &hf_x2ap_MeasurementInitiationResult_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_MeasurementInitiationResult_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_MeasurementInitiationResult_List, MeasurementInitiationResult_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t MeasurementFailureCause_List_sequence_of[1] = {
  { &hf_x2ap_MeasurementFailureCause_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_MeasurementFailureCause_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_MeasurementFailureCause_List, MeasurementFailureCause_List_sequence_of,
                                                  1, maxFailedMeasObjects, FALSE);

  return offset;
}


static const per_sequence_t MeasurementInitiationResult_Item_sequence[] = {
  { &hf_x2ap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_measurementFailureCause_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_MeasurementFailureCause_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MeasurementInitiationResult_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MeasurementInitiationResult_Item, MeasurementInitiationResult_Item_sequence);

  return offset;
}



static int
dissect_x2ap_T_measurementFailedReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 189 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_x2ap_measurementFailedReportCharacteristics_PRBPeriodic,
      &hf_x2ap_measurementFailedReportCharacteristics_TNLLoadIndPeriodic,
      &hf_x2ap_measurementFailedReportCharacteristics_HWLoadIndPeriodic,
      &hf_x2ap_measurementFailedReportCharacteristics_CompositeAvailableCapacityPeriodic,
      &hf_x2ap_measurementFailedReportCharacteristics_ABSStatusPeriodic,
      &hf_x2ap_measurementFailedReportCharacteristics_RSRPMeasurementReportPeriodic,
      &hf_x2ap_measurementFailedReportCharacteristics_CSIReportPeriodic,
      &hf_x2ap_measurementFailedReportCharacteristics_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_measurementFailedReportCharacteristics);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 4, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t MeasurementFailureCause_Item_sequence[] = {
  { &hf_x2ap_measurementFailedReportCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_measurementFailedReportCharacteristics },
  { &hf_x2ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Cause },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MeasurementFailureCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MeasurementFailureCause_Item, MeasurementFailureCause_Item_sequence);

  return offset;
}


static const per_sequence_t ResourceStatusFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResourceStatusFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 938 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ResourceStatusFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResourceStatusFailure, ResourceStatusFailure_sequence);

  return offset;
}


static const per_sequence_t CompleteFailureCauseInformation_List_sequence_of[1] = {
  { &hf_x2ap_CompleteFailureCauseInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CompleteFailureCauseInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CompleteFailureCauseInformation_List, CompleteFailureCauseInformation_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CompleteFailureCauseInformation_Item_sequence[] = {
  { &hf_x2ap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_measurementFailureCause_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_MeasurementFailureCause_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CompleteFailureCauseInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CompleteFailureCauseInformation_Item, CompleteFailureCauseInformation_Item_sequence);

  return offset;
}


static const per_sequence_t ResourceStatusUpdate_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResourceStatusUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 940 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ResourceStatusUpdate");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResourceStatusUpdate, ResourceStatusUpdate_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResult_List_sequence_of[1] = {
  { &hf_x2ap_CellMeasurementResult_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CellMeasurementResult_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellMeasurementResult_List, CellMeasurementResult_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellMeasurementResult_Item_sequence[] = {
  { &hf_x2ap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_hWLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_HWLoadIndicator },
  { &hf_x2ap_s1TNLLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_S1TNLLoadIndicator },
  { &hf_x2ap_radioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_RadioResourceStatus },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellMeasurementResult_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellMeasurementResult_Item, CellMeasurementResult_Item_sequence);

  return offset;
}


static const per_sequence_t PrivateMessage_sequence[] = {
  { &hf_x2ap_privateIEs     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_PrivateIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_PrivateMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 942 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PrivateMessage");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_PrivateMessage, PrivateMessage_sequence);

  return offset;
}


static const per_sequence_t MobilityChangeRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MobilityChangeRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 948 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MobilityChangeRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MobilityChangeRequest, MobilityChangeRequest_sequence);

  return offset;
}


static const per_sequence_t MobilityChangeAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MobilityChangeAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 950 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MobilityChangeAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MobilityChangeAcknowledge, MobilityChangeAcknowledge_sequence);

  return offset;
}


static const per_sequence_t MobilityChangeFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_MobilityChangeFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 952 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MobilityChangeFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_MobilityChangeFailure, MobilityChangeFailure_sequence);

  return offset;
}


static const per_sequence_t RLFIndication_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RLFIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 946 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RLFIndication");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RLFIndication, RLFIndication_sequence);

  return offset;
}


static const per_sequence_t CellActivationRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellActivationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 954 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "CellActivationRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellActivationRequest, CellActivationRequest_sequence);

  return offset;
}


static const per_sequence_t ServedCellsToActivate_Item_sequence[] = {
  { &hf_x2ap_ecgi           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedCellsToActivate_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedCellsToActivate_Item, ServedCellsToActivate_Item_sequence);

  return offset;
}


static const per_sequence_t ServedCellsToActivate_sequence_of[1] = {
  { &hf_x2ap_ServedCellsToActivate_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedCellsToActivate_Item },
};

static int
dissect_x2ap_ServedCellsToActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedCellsToActivate, ServedCellsToActivate_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellActivationResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellActivationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 956 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "CellActivationResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellActivationResponse, CellActivationResponse_sequence);

  return offset;
}


static const per_sequence_t ActivatedCellList_Item_sequence[] = {
  { &hf_x2ap_ecgi           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ActivatedCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ActivatedCellList_Item, ActivatedCellList_Item_sequence);

  return offset;
}


static const per_sequence_t ActivatedCellList_sequence_of[1] = {
  { &hf_x2ap_ActivatedCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ActivatedCellList_Item },
};

static int
dissect_x2ap_ActivatedCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ActivatedCellList, ActivatedCellList_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellActivationFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellActivationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 958 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "CellActivationFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellActivationFailure, CellActivationFailure_sequence);

  return offset;
}


static const per_sequence_t X2Release_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2Release(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 960 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2Release");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2Release, X2Release_sequence);

  return offset;
}


static const per_sequence_t X2APMessageTransfer_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2APMessageTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 962 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2APMessageTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2APMessageTransfer, X2APMessageTransfer_sequence);

  return offset;
}


static const per_sequence_t RNL_Header_sequence[] = {
  { &hf_x2ap_source_GlobalENB_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GlobalENB_ID },
  { &hf_x2ap_target_GlobalENB_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GlobalENB_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RNL_Header(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RNL_Header, RNL_Header_sequence);

  return offset;
}



static int
dissect_x2ap_X2AP_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 581 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *parameter_tvb;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_X2AP_Message);
    dissect_X2AP_PDU_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t SeNBAdditionRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBAdditionRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 970 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBAdditionRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBAdditionRequest, SeNBAdditionRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeAdded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeAdded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeAdded_List, E_RABs_ToBeAdded_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_Item_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_dL_Forwarding  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_DL_Forwarding },
  { &hf_x2ap_s1_UL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_Item_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_Item_SCG_Bearer, E_RABs_ToBeAdded_Item_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_Item_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_meNB_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_Item_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_Item_Split_Bearer, E_RABs_ToBeAdded_Item_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_ToBeAdded_Item_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_ToBeAdded_Item_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer     , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_Item_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer   , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_Item_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_ToBeAdded_Item, E_RABs_ToBeAdded_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SeNBAdditionRequestAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBAdditionRequestAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 972 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBAdditionRequestAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBAdditionRequestAcknowledge, SeNBAdditionRequestAcknowledge_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeAdded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeAdded_List, E_RABs_Admitted_ToBeAdded_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_Item_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_s1_DL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_uL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_Item_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_Item_SCG_Bearer, E_RABs_Admitted_ToBeAdded_Item_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_Item_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_seNB_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_Item_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_Item_Split_Bearer, E_RABs_Admitted_ToBeAdded_Item_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_Admitted_ToBeAdded_Item_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_Admitted_ToBeAdded_Item_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_01  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_Item_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_01, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_Item_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_Admitted_ToBeAdded_Item, E_RABs_Admitted_ToBeAdded_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SeNBAdditionRequestReject_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBAdditionRequestReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 974 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBAdditionRequestReject");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBAdditionRequestReject, SeNBAdditionRequestReject_sequence);

  return offset;
}


static const per_sequence_t SeNBReconfigurationComplete_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBReconfigurationComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 976 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBReconfigurationComplete");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBReconfigurationComplete, SeNBReconfigurationComplete_sequence);

  return offset;
}


static const per_sequence_t ResponseInformationSeNBReconfComp_SuccessItem_sequence[] = {
  { &hf_x2ap_meNBtoSeNBContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_MeNBtoSeNBContainer },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResponseInformationSeNBReconfComp_SuccessItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResponseInformationSeNBReconfComp_SuccessItem, ResponseInformationSeNBReconfComp_SuccessItem_sequence);

  return offset;
}


static const per_sequence_t ResponseInformationSeNBReconfComp_RejectByMeNBItem_sequence[] = {
  { &hf_x2ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Cause },
  { &hf_x2ap_meNBtoSeNBContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_MeNBtoSeNBContainer },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResponseInformationSeNBReconfComp_RejectByMeNBItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResponseInformationSeNBReconfComp_RejectByMeNBItem, ResponseInformationSeNBReconfComp_RejectByMeNBItem_sequence);

  return offset;
}


static const value_string x2ap_ResponseInformationSeNBReconfComp_vals[] = {
  {   0, "success" },
  {   1, "reject-by-MeNB" },
  { 0, NULL }
};

static const per_choice_t ResponseInformationSeNBReconfComp_choice[] = {
  {   0, &hf_x2ap_success        , ASN1_EXTENSION_ROOT    , dissect_x2ap_ResponseInformationSeNBReconfComp_SuccessItem },
  {   1, &hf_x2ap_reject_by_MeNB , ASN1_EXTENSION_ROOT    , dissect_x2ap_ResponseInformationSeNBReconfComp_RejectByMeNBItem },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_ResponseInformationSeNBReconfComp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_ResponseInformationSeNBReconfComp, ResponseInformationSeNBReconfComp_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SeNBModificationRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBModificationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 978 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBModificationRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBModificationRequest, SeNBModificationRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_List_ModReq_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeAdded_List_ModReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeAdded_List_ModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeAdded_List_ModReq, E_RABs_ToBeAdded_List_ModReq_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_List_ModReq_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeModified_List_ModReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeModified_List_ModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeModified_List_ModReq, E_RABs_ToBeModified_List_ModReq_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_List_ModReq_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_List_ModReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_List_ModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_List_ModReq, E_RABs_ToBeReleased_List_ModReq_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t UE_ContextInformationSeNBModReq_sequence[] = {
  { &hf_x2ap_uE_SecurityCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UESecurityCapabilities },
  { &hf_x2ap_seNB_SecurityKey, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SeNBSecurityKey },
  { &hf_x2ap_seNBUEAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UEAggregateMaximumBitRate },
  { &hf_x2ap_e_RABs_ToBeAdded, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RABs_ToBeAdded_List_ModReq },
  { &hf_x2ap_e_RABs_ToBeModified, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RABs_ToBeModified_List_ModReq },
  { &hf_x2ap_e_RABs_ToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RABs_ToBeReleased_List_ModReq },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UE_ContextInformationSeNBModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UE_ContextInformationSeNBModReq, UE_ContextInformationSeNBModReq_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_ModReqItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_dL_Forwarding  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_DL_Forwarding },
  { &hf_x2ap_s1_UL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_ModReqItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_ModReqItem_SCG_Bearer, E_RABs_ToBeAdded_ModReqItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_ModReqItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_meNB_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_ModReqItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_ModReqItem_Split_Bearer, E_RABs_ToBeAdded_ModReqItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_ToBeAdded_ModReqItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_ToBeAdded_ModReqItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_02  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_ModReqItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_02, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_ModReqItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_ModReqItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_ToBeAdded_ModReqItem, E_RABs_ToBeAdded_ModReqItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_ModReqItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_s1_UL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_ModReqItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_ModReqItem_SCG_Bearer, E_RABs_ToBeModified_ModReqItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_ModReqItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_meNB_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_ModReqItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_ModReqItem_Split_Bearer, E_RABs_ToBeModified_ModReqItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_ToBeModified_ModReqItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_ToBeModified_ModReqItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_03  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeModified_ModReqItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_03, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeModified_ModReqItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_ModReqItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_ToBeModified_ModReqItem, E_RABs_ToBeModified_ModReqItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_ModReqItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_uL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_ModReqItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_ModReqItem_SCG_Bearer, E_RABs_ToBeReleased_ModReqItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_ModReqItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_ModReqItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_ModReqItem_Split_Bearer, E_RABs_ToBeReleased_ModReqItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_ToBeReleased_ModReqItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_ToBeReleased_ModReqItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_04  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_ModReqItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_04, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_ModReqItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_ModReqItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_ToBeReleased_ModReqItem, E_RABs_ToBeReleased_ModReqItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SeNBModificationRequestAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBModificationRequestAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 980 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBModificationRequestAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBModificationRequestAcknowledge, SeNBModificationRequestAcknowledge_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_ModAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList, E_RABs_Admitted_ToBeAdded_ModAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_ModAckItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_s1_DL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_uL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_SCG_Bearer, E_RABs_Admitted_ToBeAdded_ModAckItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_ModAckItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_seNB_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_Split_Bearer, E_RABs_Admitted_ToBeAdded_ModAckItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_Admitted_ToBeAdded_ModAckItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_05  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_05, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem, E_RABs_Admitted_ToBeAdded_ModAckItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeModified_ModAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeModified_ModAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckList, E_RABs_Admitted_ToBeModified_ModAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeModified_ModAckItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_s1_DL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_SCG_Bearer, E_RABs_Admitted_ToBeModified_ModAckItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeModified_ModAckItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_seNB_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_Split_Bearer, E_RABs_Admitted_ToBeModified_ModAckItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_Admitted_ToBeModified_ModAckItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_06  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_06, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem, E_RABs_Admitted_ToBeModified_ModAckItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_ModAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList, E_RABs_Admitted_ToBeReleased_ModAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_ModAckItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_SCG_Bearer, E_RABs_Admitted_ToBeReleased_ModAckItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_ModAckItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_Split_Bearer, E_RABs_Admitted_ToBeReleased_ModAckItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_Admitted_ToReleased_ModAckItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_Admitted_ToReleased_ModAckItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_07  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_07, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeReleased_ModAckItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToReleased_ModAckItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_Admitted_ToReleased_ModAckItem, E_RABs_Admitted_ToReleased_ModAckItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SeNBModificationRequestReject_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBModificationRequestReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 982 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBModificationRequestReject");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBModificationRequestReject, SeNBModificationRequestReject_sequence);

  return offset;
}


static const per_sequence_t SeNBModificationRequired_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBModificationRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 984 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBModificationRequired");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBModificationRequired, SeNBModificationRequired_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_ModReqd_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_ModReqd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_ModReqd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_ModReqd, E_RABs_ToBeReleased_ModReqd_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_ModReqdItem_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Cause },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_ModReqdItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_ModReqdItem, E_RABs_ToBeReleased_ModReqdItem_sequence);

  return offset;
}


static const per_sequence_t SeNBModificationConfirm_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBModificationConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 986 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBModificationConfirm");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBModificationConfirm, SeNBModificationConfirm_sequence);

  return offset;
}


static const per_sequence_t SeNBModificationRefuse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBModificationRefuse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 988 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBModificationRefuse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBModificationRefuse, SeNBModificationRefuse_sequence);

  return offset;
}


static const per_sequence_t SeNBReleaseRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBReleaseRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 990 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBReleaseRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBReleaseRequest, SeNBReleaseRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_List_RelReq_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_List_RelReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_List_RelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_List_RelReq, E_RABs_ToBeReleased_List_RelReq_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_RelReqItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_uL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_RelReqItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_RelReqItem_SCG_Bearer, E_RABs_ToBeReleased_RelReqItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_RelReqItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_RelReqItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_RelReqItem_Split_Bearer, E_RABs_ToBeReleased_RelReqItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_ToBeReleased_RelReqItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_ToBeReleased_RelReqItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_08  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_RelReqItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_08, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_RelReqItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_RelReqItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_ToBeReleased_RelReqItem, E_RABs_ToBeReleased_RelReqItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SeNBReleaseRequired_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBReleaseRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 992 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBReleaseRequired");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBReleaseRequired, SeNBReleaseRequired_sequence);

  return offset;
}


static const per_sequence_t SeNBReleaseConfirm_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBReleaseConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 994 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBReleaseConfirm");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBReleaseConfirm, SeNBReleaseConfirm_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_List_RelConf_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_List_RelConf_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_List_RelConf(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_List_RelConf, E_RABs_ToBeReleased_List_RelConf_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_RelConfItem_SCG_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_uL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_RelConfItem_SCG_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_RelConfItem_SCG_Bearer, E_RABs_ToBeReleased_RelConfItem_SCG_Bearer_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_RelConfItem_Split_Bearer_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_RelConfItem_Split_Bearer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_RelConfItem_Split_Bearer, E_RABs_ToBeReleased_RelConfItem_Split_Bearer_sequence);

  return offset;
}


static const value_string x2ap_E_RABs_ToBeReleased_RelConfItem_vals[] = {
  {   0, "sCG-Bearer" },
  {   1, "split-Bearer" },
  { 0, NULL }
};

static const per_choice_t E_RABs_ToBeReleased_RelConfItem_choice[] = {
  {   0, &hf_x2ap_sCG_Bearer_09  , ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_RelConfItem_SCG_Bearer },
  {   1, &hf_x2ap_split_Bearer_09, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_RelConfItem_Split_Bearer },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_RelConfItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_E_RABs_ToBeReleased_RelConfItem, E_RABs_ToBeReleased_RelConfItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SeNBCounterCheckRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SeNBCounterCheckRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 996 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SeNBCounterCheckRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SeNBCounterCheckRequest, SeNBCounterCheckRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_SubjectToCounterCheck_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_SubjectToCounterCheck_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_SubjectToCounterCheck_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_SubjectToCounterCheck_List, E_RABs_SubjectToCounterCheck_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_4294967295(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_SubjectToCounterCheckItem_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_uL_Count       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_4294967295 },
  { &hf_x2ap_dL_Count       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_4294967295 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_SubjectToCounterCheckItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_SubjectToCounterCheckItem, E_RABs_SubjectToCounterCheckItem_sequence);

  return offset;
}


static const per_sequence_t X2RemovalRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2RemovalRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 964 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2RemovalRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2RemovalRequest, X2RemovalRequest_sequence);

  return offset;
}


static const per_sequence_t X2RemovalResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2RemovalResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 966 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2RemovalResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2RemovalResponse, X2RemovalResponse_sequence);

  return offset;
}


static const per_sequence_t X2RemovalFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_X2RemovalFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 968 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "X2RemovalFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_X2RemovalFailure, X2RemovalFailure_sequence);

  return offset;
}


static const per_sequence_t RetrieveUEContextRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RetrieveUEContextRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 998 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RetrieveUEContextRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RetrieveUEContextRequest, RetrieveUEContextRequest_sequence);

  return offset;
}


static const per_sequence_t RetrieveUEContextResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RetrieveUEContextResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1000 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RetrieveUEContextResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RetrieveUEContextResponse, RetrieveUEContextResponse_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeSetup_ListRetrieve_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeSetup_ListRetrieve_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeSetup_ListRetrieve(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeSetup_ListRetrieve, E_RABs_ToBeSetup_ListRetrieve_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t UE_ContextInformationRetrieve_sequence[] = {
  { &hf_x2ap_mME_UE_S1AP_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UE_S1AP_ID },
  { &hf_x2ap_uESecurityCapabilities, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UESecurityCapabilities },
  { &hf_x2ap_aS_SecurityInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_AS_SecurityInformation },
  { &hf_x2ap_uEaggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_UEAggregateMaximumBitRate },
  { &hf_x2ap_subscriberProfileIDforRFP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SubscriberProfileIDforRFP },
  { &hf_x2ap_e_RABs_ToBeSetup_ListRetrieve, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RABs_ToBeSetup_ListRetrieve },
  { &hf_x2ap_rRC_Context    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RRC_Context },
  { &hf_x2ap_handoverRestrictionList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_HandoverRestrictionList },
  { &hf_x2ap_locationReportingInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_LocationReportingInformation },
  { &hf_x2ap_managBasedMDTallowed, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ManagementBasedMDTallowed },
  { &hf_x2ap_managBasedMDTPLMNList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_MDTPLMNList },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UE_ContextInformationRetrieve(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UE_ContextInformationRetrieve, UE_ContextInformationRetrieve_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeSetupRetrieve_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_e_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_bearerType     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_BearerType },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeSetupRetrieve_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeSetupRetrieve_Item, E_RABs_ToBeSetupRetrieve_Item_sequence);

  return offset;
}


static const per_sequence_t RetrieveUEContextFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RetrieveUEContextFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1002 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RetrieveUEContextFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RetrieveUEContextFailure, RetrieveUEContextFailure_sequence);

  return offset;
}


static const per_sequence_t SgNBAdditionRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBAdditionRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1004 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBAdditionRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBAdditionRequest, SgNBAdditionRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBAddReqList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeAdded_SgNBAddReqList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReqList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeAdded_SgNBAddReqList, E_RABs_ToBeAdded_SgNBAddReqList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_full_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_max_MCG_admit_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GBR_QosInformation },
  { &hf_x2ap_dL_Forwarding  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_DL_Forwarding },
  { &hf_x2ap_meNB_DL_GTP_TEIDatMCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_s1_UL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPpresent, E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_requested_SCG_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_meNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_secondary_meNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_rlc_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RLCMode },
  { &hf_x2ap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ULConfiguration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPnotpresent, E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration, T_resource_configuration_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBAddReq_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DRB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item, E_RABs_ToBeAdded_SgNBAddReq_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBAdditionRequestAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBAdditionRequestAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1006 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBAdditionRequestAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBAdditionRequestAcknowledge, SgNBAdditionRequestAcknowledge_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList, E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_s1_DL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_sgNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_rlc_Mode       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_RLCMode },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_uL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_mCG_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ULConfiguration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPpresent, E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_sgNB_DL_GTP_TEIDatSCG, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_secondary_sgNB_DL_GTP_TEIDatSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPnotpresent, E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_01_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_01_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_01, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_01, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_01, T_resource_configuration_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_01 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item, E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBAdditionRequestReject_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBAdditionRequestReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1008 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBAdditionRequestReject");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBAdditionRequestReject, SgNBAdditionRequestReject_sequence);

  return offset;
}


static const per_sequence_t SgNBReconfigurationComplete_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBReconfigurationComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1010 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBReconfigurationComplete");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBReconfigurationComplete, SgNBReconfigurationComplete_sequence);

  return offset;
}


static const per_sequence_t ResponseInformationSgNBReconfComp_SuccessItem_sequence[] = {
  { &hf_x2ap_meNBtoSgNBContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_MeNBtoSgNBContainer },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResponseInformationSgNBReconfComp_SuccessItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResponseInformationSgNBReconfComp_SuccessItem, ResponseInformationSgNBReconfComp_SuccessItem_sequence);

  return offset;
}


static const per_sequence_t ResponseInformationSgNBReconfComp_RejectByMeNBItem_sequence[] = {
  { &hf_x2ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Cause },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ResponseInformationSgNBReconfComp_RejectByMeNBItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ResponseInformationSgNBReconfComp_RejectByMeNBItem, ResponseInformationSgNBReconfComp_RejectByMeNBItem_sequence);

  return offset;
}


static const value_string x2ap_ResponseInformationSgNBReconfComp_vals[] = {
  {   0, "success-SgNBReconfComp" },
  {   1, "reject-by-MeNB-SgNBReconfComp" },
  { 0, NULL }
};

static const per_choice_t ResponseInformationSgNBReconfComp_choice[] = {
  {   0, &hf_x2ap_success_SgNBReconfComp, ASN1_EXTENSION_ROOT    , dissect_x2ap_ResponseInformationSgNBReconfComp_SuccessItem },
  {   1, &hf_x2ap_reject_by_MeNB_SgNBReconfComp, ASN1_EXTENSION_ROOT    , dissect_x2ap_ResponseInformationSgNBReconfComp_RejectByMeNBItem },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_ResponseInformationSgNBReconfComp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_ResponseInformationSgNBReconfComp, ResponseInformationSgNBReconfComp_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SgNBModificationRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBModificationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1012 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBModificationRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBModificationRequest, SgNBModificationRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBModReq_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeAdded_SgNBModReq_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_List, E_RABs_ToBeAdded_SgNBModReq_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReq_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeModified_SgNBModReq_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeModified_SgNBModReq_List, E_RABs_ToBeModified_SgNBModReq_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBModReq_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_SgNBModReq_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_List, E_RABs_ToBeReleased_SgNBModReq_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t UE_ContextInformation_SgNBModReq_sequence[] = {
  { &hf_x2ap_nRUE_SecurityCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRUESecurityCapabilities },
  { &hf_x2ap_sgNB_SecurityKey, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SgNBSecurityKey },
  { &hf_x2ap_sgNBUEAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_UEAggregateMaximumBitRate },
  { &hf_x2ap_e_RABs_ToBeAdded_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_List },
  { &hf_x2ap_e_RABs_ToBeModified_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_List },
  { &hf_x2ap_e_RABs_ToBeReleased_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UE_ContextInformation_SgNBModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UE_ContextInformation_SgNBModReq, UE_ContextInformation_SgNBModReq_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_full_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_max_MN_admit_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GBR_QosInformation },
  { &hf_x2ap_dL_Forwarding  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_DL_Forwarding },
  { &hf_x2ap_meNB_DL_GTP_TEIDatMCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_s1_UL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPpresent, E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_requested_SCG_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_meNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_secondary_meNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_rlc_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RLCMode },
  { &hf_x2ap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ULConfiguration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPnotpresent, E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_02_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_02_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_02, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_02, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_02, T_resource_configuration_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeAdded_SgNBModReq_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_DRB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_02 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item, E_RABs_ToBeAdded_SgNBModReq_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_full_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_max_MN_admit_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GBR_QosInformation },
  { &hf_x2ap_meNB_DL_GTP_TEIDatMCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_s1_UL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPpresent, E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_requested_SCG_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_meNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ULConfiguration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPnotpresent, E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_03_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_03_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_03, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_03, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_03, T_resource_configuration_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReq_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_03 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_SgNBModReq_Item, E_RABs_ToBeModified_SgNBModReq_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_dL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_uL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPpresent, E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPnotpresent, E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_04_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_04_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_04, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_04, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_04, T_resource_configuration_04_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBModReq_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_04, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_04 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item, E_RABs_ToBeReleased_SgNBModReq_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBModificationRequestAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBModificationRequestAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1014 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBModificationRequestAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBModificationRequestAcknowledge, SgNBModificationRequestAcknowledge_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBModAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList, E_RABs_Admitted_ToBeAdded_SgNBModAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_s1_DL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_sgNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_rlc_Mode       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_RLCMode },
  { &hf_x2ap_dL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_uL_Forwarding_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_mCG_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ULConfiguration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPpresent, E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_sgNB_DL_GTP_TEIDatSCG, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_secondary_sgNB_DL_GTP_TEIDatSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPnotpresent, E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_05_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_05_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_05, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_05, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_05, T_resource_configuration_05_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_05, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_05 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item, E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeModified_SgNBModAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList, E_RABs_Admitted_ToBeModified_SgNBModAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_s1_DL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_sgNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_mCG_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ULConfiguration },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPpresent, E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_sgNB_DL_GTP_TEIDatSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPnotpresent, E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_06_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_06_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_06, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_06, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_06, T_resource_configuration_06_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeModified_SgNBModAck_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_06, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_06 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item, E_RABs_Admitted_ToBeModified_SgNBModAck_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_SgNBModAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList, E_RABs_Admitted_ToBeReleased_SgNBModAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPpresent, E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPnotpresent, E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_07_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_07_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_07, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_07, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAck_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_07, T_resource_configuration_07_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToReleased_SgNBModAck_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_07, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_07 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToReleased_SgNBModAck_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToReleased_SgNBModAck_Item, E_RABs_Admitted_ToReleased_SgNBModAck_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBModificationRequestReject_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBModificationRequestReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1016 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBModificationRequestReject");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBModificationRequestReject, SgNBModificationRequestReject_sequence);

  return offset;
}


static const per_sequence_t SgNBModificationRequired_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBModificationRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1018 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBModificationRequired");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBModificationRequired, SgNBModificationRequired_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBModReqdList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_SgNBModReqdList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBModReqdList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_SgNBModReqdList, E_RABs_ToBeReleased_SgNBModReqdList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBModReqd_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_Cause },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBModReqd_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBModReqd_Item, E_RABs_ToBeReleased_SgNBModReqd_Item_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReqdList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeModified_SgNBModReqdList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReqdList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeModified_SgNBModReqdList, E_RABs_ToBeModified_SgNBModReqdList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_requested_MCG_E_RAB_Level_QoS_Parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_E_RAB_Level_QoS_Parameters },
  { &hf_x2ap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ULConfiguration },
  { &hf_x2ap_sgNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_s1_DL_GTP_TEIDatSgNB, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPpresent, E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_sgNB_DL_GTP_TEIDatSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_secondary_sgNB_DL_GTP_TEIDatSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPnotpresent, E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_08_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_08_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_08, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_08, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_08(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_08, T_resource_configuration_08_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeModified_SgNBModReqd_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_08, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_08 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item, E_RABs_ToBeModified_SgNBModReqd_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBModificationConfirm_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBModificationConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1020 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBModificationConfirm");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBModificationConfirm, SgNBModificationConfirm_sequence);

  return offset;
}


static const per_sequence_t E_RABs_AdmittedToBeModified_SgNBModConfList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList, E_RABs_AdmittedToBeModified_SgNBModConfList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPpresent, E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_secondary_meNB_UL_GTP_TEIDatPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPnotpresent, E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_09_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_09_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_09, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_09, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_09, T_resource_configuration_09_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_AdmittedToBeModified_SgNBModConf_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_09, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_09 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item, E_RABs_AdmittedToBeModified_SgNBModConf_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBModificationRefuse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBModificationRefuse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1022 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBModificationRefuse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBModificationRefuse, SgNBModificationRefuse_sequence);

  return offset;
}


static const per_sequence_t SgNBReleaseRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBReleaseRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1024 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBReleaseRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBReleaseRequest, SgNBReleaseRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelReqList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReqList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_SgNBRelReqList, E_RABs_ToBeReleased_SgNBRelReqList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_uL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPpresent, E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPnotpresent, E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_10_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_10_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_10, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_10, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_10, T_resource_configuration_10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelReq_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_10 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item, E_RABs_ToBeReleased_SgNBRelReq_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBReleaseRequestAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBReleaseRequestAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1026 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBReleaseRequestAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBReleaseRequestAcknowledge, SgNBReleaseRequestAcknowledge_sequence);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList, E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_rlc_Mode_transferred, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RLCMode },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item, E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBReleaseRequestReject_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBReleaseRequestReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1028 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBReleaseRequestReject");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBReleaseRequestReject, SgNBReleaseRequestReject_sequence);

  return offset;
}


static const per_sequence_t SgNBReleaseRequired_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBReleaseRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1030 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBReleaseRequired");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBReleaseRequired, SgNBReleaseRequired_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelReqdList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList, E_RABs_ToBeReleased_SgNBRelReqdList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelReqd_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_rlc_Mode_transferred, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_RLCMode },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReqd_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBRelReqd_Item, E_RABs_ToBeReleased_SgNBRelReqd_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBReleaseConfirm_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBReleaseConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1032 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBReleaseConfirm");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBReleaseConfirm, SgNBReleaseConfirm_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelConfList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_SgNBRelConfList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConfList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_SgNBRelConfList, E_RABs_ToBeReleased_SgNBRelConfList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_uL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPpresent, E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPnotpresent, E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_11_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_11_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_11, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_11, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_11, T_resource_configuration_11_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBRelConf_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_11, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_11 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item, E_RABs_ToBeReleased_SgNBRelConf_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBCounterCheckRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBCounterCheckRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1034 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBCounterCheckRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBCounterCheckRequest, SgNBCounterCheckRequest_sequence);

  return offset;
}


static const per_sequence_t E_RABs_SubjectToSgNBCounterCheck_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_SubjectToSgNBCounterCheck_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_SubjectToSgNBCounterCheck_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_SubjectToSgNBCounterCheck_List, E_RABs_SubjectToSgNBCounterCheck_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_SubjectToSgNBCounterCheck_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_uL_Count       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_4294967295 },
  { &hf_x2ap_dL_Count       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_INTEGER_0_4294967295 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_SubjectToSgNBCounterCheck_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_SubjectToSgNBCounterCheck_Item, E_RABs_SubjectToSgNBCounterCheck_Item_sequence);

  return offset;
}


static const per_sequence_t SgNBChangeRequired_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBChangeRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1036 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBChangeRequired");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBChangeRequired, SgNBChangeRequired_sequence);

  return offset;
}


static const per_sequence_t SgNBChangeConfirm_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBChangeConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1038 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBChangeConfirm");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBChangeConfirm, SgNBChangeConfirm_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBChaConfList_sequence_of[1] = {
  { &hf_x2ap_E_RABs_ToBeReleased_SgNBChaConfList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConfList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_ToBeReleased_SgNBChaConfList, E_RABs_ToBeReleased_SgNBChaConfList_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPpresent_sequence[] = {
  { &hf_x2ap_uL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_dL_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPpresent, E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPpresent_sequence);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPnotpresent_sequence[] = {
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPnotpresent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPnotpresent, E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPnotpresent_sequence);

  return offset;
}


static const value_string x2ap_T_resource_configuration_12_vals[] = {
  {   0, "sgNBPDCPpresent" },
  {   1, "sgNBPDCPnotpresent" },
  { 0, NULL }
};

static const per_choice_t T_resource_configuration_12_choice[] = {
  {   0, &hf_x2ap_sgNBPDCPpresent_12, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPpresent },
  {   1, &hf_x2ap_sgNBPDCPnotpresent_12, ASN1_EXTENSION_ROOT    , dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_SgNBPDCPnotpresent },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_resource_configuration_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_resource_configuration_12, T_resource_configuration_12_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_RABs_ToBeReleased_SgNBChaConf_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_en_DC_ResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_EN_DC_ResourceConfiguration },
  { &hf_x2ap_resource_configuration_12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_resource_configuration_12 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item, E_RABs_ToBeReleased_SgNBChaConf_Item_sequence);

  return offset;
}


static const per_sequence_t RRCTransfer_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_RRCTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1042 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRCTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_RRCTransfer, RRCTransfer_sequence);

  return offset;
}


static const per_sequence_t SgNBChangeRefuse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBChangeRefuse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1040 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBChangeRefuse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBChangeRefuse, SgNBChangeRefuse_sequence);

  return offset;
}


static const per_sequence_t ENDCX2SetupRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCX2SetupRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1044 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCX2SetupRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCX2SetupRequest, ENDCX2SetupRequest_sequence);

  return offset;
}


static const value_string x2ap_InitiatingNodeType_EndcX2Setup_vals[] = {
  {   0, "init-eNB" },
  {   1, "init-en-gNB" },
  { 0, NULL }
};

static const per_choice_t InitiatingNodeType_EndcX2Setup_choice[] = {
  {   0, &hf_x2ap_init_eNB       , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_init_en_gNB    , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_InitiatingNodeType_EndcX2Setup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_InitiatingNodeType_EndcX2Setup, InitiatingNodeType_EndcX2Setup_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ServedEUTRAcellsENDCX2ManagementList_item_sequence[] = {
  { &hf_x2ap_servedEUTRACellInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedCell_Information },
  { &hf_x2ap_nrNeighbourInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRNeighbour_Information },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedEUTRAcellsENDCX2ManagementList_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedEUTRAcellsENDCX2ManagementList_item, ServedEUTRAcellsENDCX2ManagementList_item_sequence);

  return offset;
}


static const per_sequence_t ServedEUTRAcellsENDCX2ManagementList_sequence_of[1] = {
  { &hf_x2ap_ServedEUTRAcellsENDCX2ManagementList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedEUTRAcellsENDCX2ManagementList_item },
};

static int
dissect_x2ap_ServedEUTRAcellsENDCX2ManagementList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedEUTRAcellsENDCX2ManagementList, ServedEUTRAcellsENDCX2ManagementList_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t FDD_InfoServedNRCell_Information_sequence[] = {
  { &hf_x2ap_ul_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRFreqInfo },
  { &hf_x2ap_dl_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRFreqInfo },
  { &hf_x2ap_ul_NR_TxBW     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NR_TxBW },
  { &hf_x2ap_dl_NR_TxBW     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NR_TxBW },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_FDD_InfoServedNRCell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_FDD_InfoServedNRCell_Information, FDD_InfoServedNRCell_Information_sequence);

  return offset;
}


static const per_sequence_t TDD_InfoServedNRCell_Information_sequence[] = {
  { &hf_x2ap_nRFreqInfo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRFreqInfo },
  { &hf_x2ap_nR_TxBW        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NR_TxBW },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TDD_InfoServedNRCell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TDD_InfoServedNRCell_Information, TDD_InfoServedNRCell_Information_sequence);

  return offset;
}


static const value_string x2ap_T_nrModeInfo_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  { 0, NULL }
};

static const per_choice_t T_nrModeInfo_choice[] = {
  {   0, &hf_x2ap_fdd_04         , ASN1_EXTENSION_ROOT    , dissect_x2ap_FDD_InfoServedNRCell_Information },
  {   1, &hf_x2ap_tdd_04         , ASN1_EXTENSION_ROOT    , dissect_x2ap_TDD_InfoServedNRCell_Information },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_T_nrModeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_T_nrModeInfo, T_nrModeInfo_choice,
                                 NULL);

  return offset;
}



static int
dissect_x2ap_T_measurementTimingConfiguration_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 646 "./asn1/x2ap/x2ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_x2ap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t ServedNRCell_Information_sequence[] = {
  { &hf_x2ap_nrpCI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRPCI },
  { &hf_x2ap_nrCellID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_FiveGS_TAC },
  { &hf_x2ap_configured_TAC , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_TAC },
  { &hf_x2ap_broadcastPLMNs , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_BroadcastPLMNs_Item },
  { &hf_x2ap_nrModeInfo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_nrModeInfo },
  { &hf_x2ap_measurementTimingConfiguration_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_T_measurementTimingConfiguration_01 },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedNRCell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedNRCell_Information, ServedNRCell_Information_sequence);

  return offset;
}


static const per_sequence_t ServedNRcellsENDCX2ManagementList_item_sequence[] = {
  { &hf_x2ap_servedNRCellInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedNRCell_Information },
  { &hf_x2ap_nRNeighbourInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRNeighbour_Information },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedNRcellsENDCX2ManagementList_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedNRcellsENDCX2ManagementList_item, ServedNRcellsENDCX2ManagementList_item_sequence);

  return offset;
}


static const per_sequence_t ServedNRcellsENDCX2ManagementList_sequence_of[1] = {
  { &hf_x2ap_ServedNRcellsENDCX2ManagementList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedNRcellsENDCX2ManagementList_item },
};

static int
dissect_x2ap_ServedNRcellsENDCX2ManagementList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedNRcellsENDCX2ManagementList, ServedNRcellsENDCX2ManagementList_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}


static const per_sequence_t Limited_list_item_sequence[] = {
  { &hf_x2ap_nrCellID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_Limited_list_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_Limited_list_item, Limited_list_item_sequence);

  return offset;
}


static const per_sequence_t Limited_list_sequence_of[1] = {
  { &hf_x2ap_Limited_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Limited_list_item },
};

static int
dissect_x2ap_Limited_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_Limited_list, Limited_list_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}


static const value_string x2ap_T_full_list_vals[] = {
  {   0, "allServedNRcells" },
  { 0, NULL }
};


static int
dissect_x2ap_T_full_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string x2ap_CellAssistanceInformation_vals[] = {
  {   0, "limited-list" },
  {   1, "full-list" },
  { 0, NULL }
};

static const per_choice_t CellAssistanceInformation_choice[] = {
  {   0, &hf_x2ap_limited_list   , ASN1_EXTENSION_ROOT    , dissect_x2ap_Limited_list },
  {   1, &hf_x2ap_full_list      , ASN1_EXTENSION_ROOT    , dissect_x2ap_T_full_list },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_CellAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_CellAssistanceInformation, CellAssistanceInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellandCapacityAssistInfo_sequence[] = {
  { &hf_x2ap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_MaximumCellListSize },
  { &hf_x2ap_cellAssistanceInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_CellAssistanceInformation },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellandCapacityAssistInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellandCapacityAssistInfo, CellandCapacityAssistInfo_sequence);

  return offset;
}


static const per_sequence_t ENDCX2SetupResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCX2SetupResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1046 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCX2SetupResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCX2SetupResponse, ENDCX2SetupResponse_sequence);

  return offset;
}


static const value_string x2ap_RespondingNodeType_EndcX2Setup_vals[] = {
  {   0, "respond-eNB" },
  {   1, "respond-en-gNB" },
  { 0, NULL }
};

static const per_choice_t RespondingNodeType_EndcX2Setup_choice[] = {
  {   0, &hf_x2ap_respond_eNB    , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_respond_en_gNB , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_RespondingNodeType_EndcX2Setup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_RespondingNodeType_EndcX2Setup, RespondingNodeType_EndcX2Setup_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ENDCX2SetupFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCX2SetupFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1048 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCX2SetupFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCX2SetupFailure, ENDCX2SetupFailure_sequence);

  return offset;
}


static const per_sequence_t ENDCConfigurationUpdate_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCConfigurationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1050 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCConfigurationUpdate");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCConfigurationUpdate, ENDCConfigurationUpdate_sequence);

  return offset;
}


static const value_string x2ap_InitiatingNodeType_EndcConfigUpdate_vals[] = {
  {   0, "init-eNB" },
  {   1, "init-en-gNB" },
  { 0, NULL }
};

static const per_choice_t InitiatingNodeType_EndcConfigUpdate_choice[] = {
  {   0, &hf_x2ap_init_eNB       , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_init_en_gNB    , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_InitiatingNodeType_EndcConfigUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_InitiatingNodeType_EndcConfigUpdate, InitiatingNodeType_EndcConfigUpdate_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ServedEUTRAcellsToModifyListENDCConfUpd_item_sequence[] = {
  { &hf_x2ap_old_ECGI       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_servedEUTRACellInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedCell_Information },
  { &hf_x2ap_nrNeighbourInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRNeighbour_Information },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_item, ServedEUTRAcellsToModifyListENDCConfUpd_item_sequence);

  return offset;
}


static const per_sequence_t ServedEUTRAcellsToModifyListENDCConfUpd_sequence_of[1] = {
  { &hf_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_item },
};

static int
dissect_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd, ServedEUTRAcellsToModifyListENDCConfUpd_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t ServedEUTRAcellsToDeleteListENDCConfUpd_sequence_of[1] = {
  { &hf_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd, ServedEUTRAcellsToDeleteListENDCConfUpd_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t ServedNRCellsToModify_Item_sequence[] = {
  { &hf_x2ap_old_nrcgi      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_servedNRCellInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedNRCell_Information },
  { &hf_x2ap_nrNeighbourInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRNeighbour_Information },
  { &hf_x2ap_nrDeactivationIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_DeactivationIndication },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedNRCellsToModify_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedNRCellsToModify_Item, ServedNRCellsToModify_Item_sequence);

  return offset;
}


static const per_sequence_t ServedNRcellsToModifyENDCConfUpdList_sequence_of[1] = {
  { &hf_x2ap_ServedNRcellsToModifyENDCConfUpdList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedNRCellsToModify_Item },
};

static int
dissect_x2ap_ServedNRcellsToModifyENDCConfUpdList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedNRcellsToModifyENDCConfUpdList, ServedNRcellsToModifyENDCConfUpdList_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}


static const per_sequence_t ServedNRcellsToDeleteENDCConfUpdList_sequence_of[1] = {
  { &hf_x2ap_ServedNRcellsToDeleteENDCConfUpdList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
};

static int
dissect_x2ap_ServedNRcellsToDeleteENDCConfUpdList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedNRcellsToDeleteENDCConfUpdList, ServedNRcellsToDeleteENDCConfUpdList_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}


static const per_sequence_t ENDCConfigurationUpdateAcknowledge_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCConfigurationUpdateAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1052 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCConfigurationUpdateAcknowledge");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCConfigurationUpdateAcknowledge, ENDCConfigurationUpdateAcknowledge_sequence);

  return offset;
}


static const value_string x2ap_RespondingNodeType_EndcConfigUpdate_vals[] = {
  {   0, "respond-eNB" },
  {   1, "respond-en-gNB" },
  { 0, NULL }
};

static const per_choice_t RespondingNodeType_EndcConfigUpdate_choice[] = {
  {   0, &hf_x2ap_respond_eNB    , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_respond_en_gNB , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_RespondingNodeType_EndcConfigUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_RespondingNodeType_EndcConfigUpdate, RespondingNodeType_EndcConfigUpdate_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ENDCConfigurationUpdateFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCConfigurationUpdateFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1054 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCConfigurationUpdateFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCConfigurationUpdateFailure, ENDCConfigurationUpdateFailure_sequence);

  return offset;
}


static const per_sequence_t ENDCCellActivationRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCCellActivationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1058 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCCellActivationRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCCellActivationRequest, ENDCCellActivationRequest_sequence);

  return offset;
}


static const per_sequence_t ServedNRCellsToActivate_Item_sequence[] = {
  { &hf_x2ap_nrCellID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ServedNRCellsToActivate_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ServedNRCellsToActivate_Item, ServedNRCellsToActivate_Item_sequence);

  return offset;
}


static const per_sequence_t ServedNRCellsToActivate_sequence_of[1] = {
  { &hf_x2ap_ServedNRCellsToActivate_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ServedNRCellsToActivate_Item },
};

static int
dissect_x2ap_ServedNRCellsToActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ServedNRCellsToActivate, ServedNRCellsToActivate_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}


static const per_sequence_t ENDCCellActivationResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCCellActivationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1060 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCCellActivationResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCCellActivationResponse, ENDCCellActivationResponse_sequence);

  return offset;
}


static const per_sequence_t ActivatedNRCellList_Item_sequence[] = {
  { &hf_x2ap_nrCellID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ActivatedNRCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ActivatedNRCellList_Item, ActivatedNRCellList_Item_sequence);

  return offset;
}


static const per_sequence_t ActivatedNRCellList_sequence_of[1] = {
  { &hf_x2ap_ActivatedNRCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ActivatedNRCellList_Item },
};

static int
dissect_x2ap_ActivatedNRCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ActivatedNRCellList, ActivatedNRCellList_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}


static const per_sequence_t ENDCCellActivationFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCCellActivationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1062 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCCellActivationFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCCellActivationFailure, ENDCCellActivationFailure_sequence);

  return offset;
}


static const per_sequence_t ENDCResourceStatusRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCResourceStatusRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1096 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCResourceStatusRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCResourceStatusRequest, ENDCResourceStatusRequest_sequence);

  return offset;
}


static const value_string x2ap_ReportingPeriodicity_ENDC_vals[] = {
  {   0, "ms500" },
  {   1, "ms1000" },
  {   2, "ms2000" },
  {   3, "ms5000" },
  {   4, "ms10000" },
  { 0, NULL }
};


static int
dissect_x2ap_ReportingPeriodicity_ENDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CellToReport_NR_ENDC_List_sequence_of[1] = {
  { &hf_x2ap_CellToReport_NR_ENDC_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CellToReport_NR_ENDC_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellToReport_NR_ENDC_List, CellToReport_NR_ENDC_List_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}


static const per_sequence_t SSBToReport_Item_sequence[] = {
  { &hf_x2ap_ssbIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_SSBIndex },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SSBToReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SSBToReport_Item, SSBToReport_Item_sequence);

  return offset;
}


static const per_sequence_t SSBToReport_List_sequence_of[1] = {
  { &hf_x2ap_SSBToReport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_SSBToReport_Item },
};

static int
dissect_x2ap_SSBToReport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_SSBToReport_List, SSBToReport_List_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t CellToReport_NR_ENDC_Item_sequence[] = {
  { &hf_x2ap_nr_cell_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_ssbToReport_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_SSBToReport_List },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellToReport_NR_ENDC_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellToReport_NR_ENDC_Item, CellToReport_NR_ENDC_Item_sequence);

  return offset;
}


static const per_sequence_t CellToReport_E_UTRA_ENDC_List_sequence_of[1] = {
  { &hf_x2ap_CellToReport_E_UTRA_ENDC_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CellToReport_E_UTRA_ENDC_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellToReport_E_UTRA_ENDC_List, CellToReport_E_UTRA_ENDC_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellToReport_E_UTRA_ENDC_Item_sequence[] = {
  { &hf_x2ap_e_utra_cell_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellToReport_E_UTRA_ENDC_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellToReport_E_UTRA_ENDC_Item, CellToReport_E_UTRA_ENDC_Item_sequence);

  return offset;
}


static const per_sequence_t ENDCResourceStatusResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCResourceStatusResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1098 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCResourceStatusResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCResourceStatusResponse, ENDCResourceStatusResponse_sequence);

  return offset;
}


static const per_sequence_t ENDCResourceStatusFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCResourceStatusFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1100 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCResourceStatusFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCResourceStatusFailure, ENDCResourceStatusFailure_sequence);

  return offset;
}


static const per_sequence_t ENDCResourceStatusUpdate_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCResourceStatusUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1102 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCResourceStatusUpdate");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCResourceStatusUpdate, ENDCResourceStatusUpdate_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResult_NR_ENDC_List_sequence_of[1] = {
  { &hf_x2ap_CellMeasurementResult_NR_ENDC_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CellMeasurementResult_NR_ENDC_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellMeasurementResult_NR_ENDC_List, CellMeasurementResult_NR_ENDC_List_sequence_of,
                                                  1, maxCellinengNB, FALSE);

  return offset;
}



static int
dissect_x2ap_INTEGER_0_16777215_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CellMeasurementResult_NR_ENDC_Item_sequence[] = {
  { &hf_x2ap_nr_cell_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
  { &hf_x2ap_nr_radioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRRadioResourceStatus },
  { &hf_x2ap_tnlCapacityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_TNLCapacityIndicator },
  { &hf_x2ap_nr_compositeAvailableCapacityGroup, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_NRCompositeAvailableCapacityGroup },
  { &hf_x2ap_numberofActiveUEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_INTEGER_0_16777215_ },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellMeasurementResult_NR_ENDC_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellMeasurementResult_NR_ENDC_Item, CellMeasurementResult_NR_ENDC_Item_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResult_E_UTRA_ENDC_List_sequence_of[1] = {
  { &hf_x2ap_CellMeasurementResult_E_UTRA_ENDC_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_CellMeasurementResult_E_UTRA_ENDC_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_CellMeasurementResult_E_UTRA_ENDC_List, CellMeasurementResult_E_UTRA_ENDC_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t CellMeasurementResult_E_UTRA_ENDC_Item_sequence[] = {
  { &hf_x2ap_e_utra_cell_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
  { &hf_x2ap_hWLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_HWLoadIndicator },
  { &hf_x2ap_s1TNLLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_S1TNLLoadIndicator },
  { &hf_x2ap_radioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_RadioResourceStatus },
  { &hf_x2ap_compositeAvailableCapacityGroup, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_CompositeAvailableCapacityGroup },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellMeasurementResult_E_UTRA_ENDC_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellMeasurementResult_E_UTRA_ENDC_Item, CellMeasurementResult_E_UTRA_ENDC_Item_sequence);

  return offset;
}


static const per_sequence_t SecondaryRATDataUsageReport_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SecondaryRATDataUsageReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1056 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SecondaryRATDataUsageReport");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SecondaryRATDataUsageReport, SecondaryRATDataUsageReport_sequence);

  return offset;
}


static const per_sequence_t SgNBActivityNotification_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SgNBActivityNotification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1072 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SgNBActivityNotification");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SgNBActivityNotification, SgNBActivityNotification_sequence);

  return offset;
}


static const per_sequence_t ENDCPartialResetRequired_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCPartialResetRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1064 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCPartialResetRequired");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCPartialResetRequired, ENDCPartialResetRequired_sequence);

  return offset;
}


static const per_sequence_t ENDCPartialResetConfirm_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCPartialResetConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1066 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCPartialResetConfirm");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCPartialResetConfirm, ENDCPartialResetConfirm_sequence);

  return offset;
}


static const per_sequence_t EUTRANRCellResourceCoordinationRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_EUTRANRCellResourceCoordinationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1068 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "EUTRANRCellResourceCoordinationRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_EUTRANRCellResourceCoordinationRequest, EUTRANRCellResourceCoordinationRequest_sequence);

  return offset;
}


static const value_string x2ap_InitiatingNodeType_EutranrCellResourceCoordination_vals[] = {
  {   0, "initiate-eNB" },
  {   1, "initiate-en-gNB" },
  { 0, NULL }
};

static const per_choice_t InitiatingNodeType_EutranrCellResourceCoordination_choice[] = {
  {   0, &hf_x2ap_initiate_eNB   , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_initiate_en_gNB, ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_InitiatingNodeType_EutranrCellResourceCoordination(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_InitiatingNodeType_EutranrCellResourceCoordination, InitiatingNodeType_EutranrCellResourceCoordination_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ListofEUTRACellsinEUTRACoordinationReq_sequence_of[1] = {
  { &hf_x2ap_ListofEUTRACellsinEUTRACoordinationReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_ListofEUTRACellsinEUTRACoordinationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ListofEUTRACellsinEUTRACoordinationReq, ListofEUTRACellsinEUTRACoordinationReq_sequence_of,
                                                  0, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t ListofEUTRACellsinNRCoordinationReq_sequence_of[1] = {
  { &hf_x2ap_ListofEUTRACellsinNRCoordinationReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_ListofEUTRACellsinNRCoordinationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ListofEUTRACellsinNRCoordinationReq, ListofEUTRACellsinNRCoordinationReq_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t ListofNRCellsinNRCoordinationReq_sequence_of[1] = {
  { &hf_x2ap_ListofNRCellsinNRCoordinationReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
};

static int
dissect_x2ap_ListofNRCellsinNRCoordinationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ListofNRCellsinNRCoordinationReq, ListofNRCellsinNRCoordinationReq_sequence_of,
                                                  0, maxnoNRcellsSpectrumSharingWithE_UTRA, FALSE);

  return offset;
}


static const per_sequence_t EUTRANRCellResourceCoordinationResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_EUTRANRCellResourceCoordinationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1070 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "EUTRANRCellResourceCoordinationResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_EUTRANRCellResourceCoordinationResponse, EUTRANRCellResourceCoordinationResponse_sequence);

  return offset;
}


static const value_string x2ap_RespondingNodeType_EutranrCellResourceCoordination_vals[] = {
  {   0, "respond-eNB" },
  {   1, "respond-en-gNB" },
  { 0, NULL }
};

static const per_choice_t RespondingNodeType_EutranrCellResourceCoordination_choice[] = {
  {   0, &hf_x2ap_respond_eNB    , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_respond_en_gNB , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_RespondingNodeType_EutranrCellResourceCoordination(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_RespondingNodeType_EutranrCellResourceCoordination, RespondingNodeType_EutranrCellResourceCoordination_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ListofEUTRACellsinEUTRACoordinationResp_sequence_of[1] = {
  { &hf_x2ap_ListofEUTRACellsinEUTRACoordinationResp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ECGI },
};

static int
dissect_x2ap_ListofEUTRACellsinEUTRACoordinationResp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ListofEUTRACellsinEUTRACoordinationResp, ListofEUTRACellsinEUTRACoordinationResp_sequence_of,
                                                  0, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t ListofNRCellsinNRCoordinationResp_sequence_of[1] = {
  { &hf_x2ap_ListofNRCellsinNRCoordinationResp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_NRCGI },
};

static int
dissect_x2ap_ListofNRCellsinNRCoordinationResp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_ListofNRCellsinNRCoordinationResp, ListofNRCellsinNRCoordinationResp_sequence_of,
                                                  0, maxnoNRcellsSpectrumSharingWithE_UTRA, FALSE);

  return offset;
}


static const per_sequence_t ENDCX2RemovalRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCX2RemovalRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1074 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCX2RemovalRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCX2RemovalRequest, ENDCX2RemovalRequest_sequence);

  return offset;
}


static const value_string x2ap_InitiatingNodeType_EndcX2Removal_vals[] = {
  {   0, "init-eNB" },
  {   1, "init-en-gNB" },
  { 0, NULL }
};

static const per_choice_t InitiatingNodeType_EndcX2Removal_choice[] = {
  {   0, &hf_x2ap_init_eNB       , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_init_en_gNB    , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_InitiatingNodeType_EndcX2Removal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_InitiatingNodeType_EndcX2Removal, InitiatingNodeType_EndcX2Removal_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ENDCX2RemovalResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCX2RemovalResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1076 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCX2RemovalResponse");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCX2RemovalResponse, ENDCX2RemovalResponse_sequence);

  return offset;
}


static const value_string x2ap_RespondingNodeType_EndcX2Removal_vals[] = {
  {   0, "respond-eNB" },
  {   1, "respond-en-gNB" },
  { 0, NULL }
};

static const per_choice_t RespondingNodeType_EndcX2Removal_choice[] = {
  {   0, &hf_x2ap_respond_eNB    , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  {   1, &hf_x2ap_respond_en_gNB , ASN1_EXTENSION_ROOT    , dissect_x2ap_ProtocolIE_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_RespondingNodeType_EndcX2Removal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_RespondingNodeType_EndcX2Removal, RespondingNodeType_EndcX2Removal_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ENDCX2RemovalFailure_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCX2RemovalFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1078 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCX2RemovalFailure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCX2RemovalFailure, ENDCX2RemovalFailure_sequence);

  return offset;
}


static const per_sequence_t DataForwardingAddressIndication_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DataForwardingAddressIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1080 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "DataForwardingAddressIndication");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DataForwardingAddressIndication, DataForwardingAddressIndication_sequence);

  return offset;
}


static const per_sequence_t E_RABs_DataForwardingAddress_List_sequence_of[1] = {
  { &hf_x2ap_E_RABs_DataForwardingAddress_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Single_Container },
};

static int
dissect_x2ap_E_RABs_DataForwardingAddress_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_x2ap_E_RABs_DataForwardingAddress_List, E_RABs_DataForwardingAddress_List_sequence_of,
                                                  1, maxnoofBearers, FALSE);

  return offset;
}


static const per_sequence_t E_RABs_DataForwardingAddress_Item_sequence[] = {
  { &hf_x2ap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_E_RAB_ID },
  { &hf_x2ap_dl_GTPtunnelEndpoint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_GTPtunnelEndpoint },
  { &hf_x2ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_x2ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_E_RABs_DataForwardingAddress_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_E_RABs_DataForwardingAddress_Item, E_RABs_DataForwardingAddress_Item_sequence);

  return offset;
}


static const per_sequence_t GNBStatusIndication_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_GNBStatusIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1082 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "GNBStatusIndication");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_GNBStatusIndication, GNBStatusIndication_sequence);

  return offset;
}


static const per_sequence_t ENDCConfigurationTransfer_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_ENDCConfigurationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1084 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "ENDCConfigurationTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_ENDCConfigurationTransfer, ENDCConfigurationTransfer_sequence);

  return offset;
}


static const per_sequence_t TraceStart_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_TraceStart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1088 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "TraceStart");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_TraceStart, TraceStart_sequence);

  return offset;
}


static const per_sequence_t DeactivateTrace_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_DeactivateTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1086 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "DeactivateTrace");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_DeactivateTrace, DeactivateTrace_sequence);

  return offset;
}


static const per_sequence_t CellTrafficTrace_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_CellTrafficTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1104 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "CellTrafficTrace");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_CellTrafficTrace, CellTrafficTrace_sequence);

  return offset;
}


static const per_sequence_t F1CTrafficTransfer_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_F1CTrafficTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1106 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "F1CTrafficTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_F1CTrafficTransfer, F1CTrafficTransfer_sequence);

  return offset;
}


static const per_sequence_t UERadioCapabilityIDMappingRequest_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UERadioCapabilityIDMappingRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1108 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "UERadioCapabilityIDMappingRequest");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UERadioCapabilityIDMappingRequest, UERadioCapabilityIDMappingRequest_sequence);

  return offset;
}


static const per_sequence_t UERadioCapabilityIDMappingResponse_sequence[] = {
  { &hf_x2ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_x2ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UERadioCapabilityIDMappingResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1110 "./asn1/x2ap/x2ap.cnf"
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "UERadioCapabilityIDMappingResponse");


  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UERadioCapabilityIDMappingResponse, UERadioCapabilityIDMappingResponse_sequence);

  return offset;
}



static int
dissect_x2ap_InitiatingMessage_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_InitiatingMessageValue);

  return offset;
}


static const per_sequence_t InitiatingMessage_sequence[] = {
  { &hf_x2ap_procedureCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProcedureCode },
  { &hf_x2ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Criticality },
  { &hf_x2ap_initiatingMessage_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_InitiatingMessage_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_InitiatingMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_InitiatingMessage, InitiatingMessage_sequence);

  return offset;
}



static int
dissect_x2ap_SuccessfulOutcome_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_SuccessfulOutcomeValue);

  return offset;
}


static const per_sequence_t SuccessfulOutcome_sequence[] = {
  { &hf_x2ap_procedureCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProcedureCode },
  { &hf_x2ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Criticality },
  { &hf_x2ap_successfulOutcome_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_SuccessfulOutcome_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_SuccessfulOutcome(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_SuccessfulOutcome, SuccessfulOutcome_sequence);

  return offset;
}



static int
dissect_x2ap_UnsuccessfulOutcome_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_UnsuccessfulOutcomeValue);

  return offset;
}


static const per_sequence_t UnsuccessfulOutcome_sequence[] = {
  { &hf_x2ap_procedureCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_ProcedureCode },
  { &hf_x2ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_Criticality },
  { &hf_x2ap_value          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_x2ap_UnsuccessfulOutcome_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_x2ap_UnsuccessfulOutcome(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_x2ap_UnsuccessfulOutcome, UnsuccessfulOutcome_sequence);

  return offset;
}


static const value_string x2ap_X2AP_PDU_vals[] = {
  {   0, "initiatingMessage" },
  {   1, "successfulOutcome" },
  {   2, "unsuccessfulOutcome" },
  { 0, NULL }
};

static const per_choice_t X2AP_PDU_choice[] = {
  {   0, &hf_x2ap_initiatingMessage, ASN1_EXTENSION_ROOT    , dissect_x2ap_InitiatingMessage },
  {   1, &hf_x2ap_successfulOutcome, ASN1_EXTENSION_ROOT    , dissect_x2ap_SuccessfulOutcome },
  {   2, &hf_x2ap_unsuccessfulOutcome, ASN1_EXTENSION_ROOT    , dissect_x2ap_UnsuccessfulOutcome },
  { 0, NULL, 0, NULL }
};

static int
dissect_x2ap_X2AP_PDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_x2ap_X2AP_PDU, X2AP_PDU_choice,
                                 NULL);

  return offset;
}

/*--- PDUs ---*/

static int dissect_ABSInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ABSInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_ABSInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ABS_Status_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ABS_Status(tvb, offset, &asn1_ctx, tree, hf_x2ap_ABS_Status_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ActivationID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ActivationID(tvb, offset, &asn1_ctx, tree, hf_x2ap_ActivationID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionLocationInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_AdditionLocationInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_AdditionLocationInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalRRMPriorityIndex_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_AdditionalRRMPriorityIndex(tvb, offset, &asn1_ctx, tree, hf_x2ap_AdditionalRRMPriorityIndex_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalSpecialSubframe_Info_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_AdditionalSpecialSubframe_Info(tvb, offset, &asn1_ctx, tree, hf_x2ap_AdditionalSpecialSubframe_Info_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalSpecialSubframeExtension_Info_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_AdditionalSpecialSubframeExtension_Info(tvb, offset, &asn1_ctx, tree, hf_x2ap_AdditionalSpecialSubframeExtension_Info_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AvailableFastMCGRecoveryViaSRB3_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_AvailableFastMCGRecoveryViaSRB3(tvb, offset, &asn1_ctx, tree, hf_x2ap_AvailableFastMCGRecoveryViaSRB3_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AerialUEsubscriptionInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_AerialUEsubscriptionInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_AerialUEsubscriptionInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalPLMNs_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_AdditionalPLMNs_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_AdditionalPLMNs_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BandwidthReducedSI_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_BandwidthReducedSI(tvb, offset, &asn1_ctx, tree, hf_x2ap_BandwidthReducedSI_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BearerType_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_BearerType(tvb, offset, &asn1_ctx, tree, hf_x2ap_BearerType_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BluetoothMeasurementConfiguration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_BluetoothMeasurementConfiguration(tvb, offset, &asn1_ctx, tree, hf_x2ap_BluetoothMeasurementConfiguration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BPLMN_ID_Info_EUTRA_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_BPLMN_ID_Info_EUTRA(tvb, offset, &asn1_ctx, tree, hf_x2ap_BPLMN_ID_Info_EUTRA_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BPLMN_ID_Info_NR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_BPLMN_ID_Info_NR(tvb, offset, &asn1_ctx, tree, hf_x2ap_BPLMN_ID_Info_NR_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cause_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Cause(tvb, offset, &asn1_ctx, tree, hf_x2ap_Cause_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellReportingIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellReportingIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellReportingIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CHO_DC_EarlyDataForwarding_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CHO_DC_EarlyDataForwarding(tvb, offset, &asn1_ctx, tree, hf_x2ap_CHO_DC_EarlyDataForwarding_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CHO_DC_Indicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CHO_DC_Indicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_CHO_DC_Indicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CNTypeRestrictions_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CNTypeRestrictions(tvb, offset, &asn1_ctx, tree, hf_x2ap_CNTypeRestrictions_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CoMPInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CoMPInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_CoMPInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CompositeAvailableCapacityGroup_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CompositeAvailableCapacityGroup(tvb, offset, &asn1_ctx, tree, hf_x2ap_CompositeAvailableCapacityGroup_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Correlation_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Correlation_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_Correlation_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_COUNTValueExtended_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_COUNTValueExtended(tvb, offset, &asn1_ctx, tree, hf_x2ap_COUNTValueExtended_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_COUNTvaluePDCP_SNlength18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_COUNTvaluePDCP_SNlength18(tvb, offset, &asn1_ctx, tree, hf_x2ap_COUNTvaluePDCP_SNlength18_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CoverageModificationList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CoverageModificationList(tvb, offset, &asn1_ctx, tree, hf_x2ap_CoverageModificationList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CriticalityDiagnostics_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CriticalityDiagnostics(tvb, offset, &asn1_ctx, tree, hf_x2ap_CriticalityDiagnostics_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CRNTI_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CRNTI(tvb, offset, &asn1_ctx, tree, hf_x2ap_CRNTI_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CSGMembershipStatus_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CSGMembershipStatus(tvb, offset, &asn1_ctx, tree, hf_x2ap_CSGMembershipStatus_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CSG_Id_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CSG_Id(tvb, offset, &asn1_ctx, tree, hf_x2ap_CSG_Id_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CSIReportList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CSIReportList(tvb, offset, &asn1_ctx, tree, hf_x2ap_CSIReportList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CHOinformation_REQ_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CHOinformation_REQ(tvb, offset, &asn1_ctx, tree, hf_x2ap_CHOinformation_REQ_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CHOinformation_ACK_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CHOinformation_ACK(tvb, offset, &asn1_ctx, tree, hf_x2ap_CHOinformation_ACK_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CandidateCellsToBeCancelledList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CandidateCellsToBeCancelledList(tvb, offset, &asn1_ctx, tree, hf_x2ap_CandidateCellsToBeCancelledList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CSI_RSTransmissionIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CSI_RSTransmissionIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_CSI_RSTransmissionIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DataTrafficResourceIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DataTrafficResourceIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_DataTrafficResourceIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DAPSRequestInfo_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DAPSRequestInfo(tvb, offset, &asn1_ctx, tree, hf_x2ap_DAPSRequestInfo_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DAPSResponseInfo_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DAPSResponseInfo(tvb, offset, &asn1_ctx, tree, hf_x2ap_DAPSResponseInfo_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DeactivationIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DeactivationIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_DeactivationIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DesiredActNotificationLevel_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DesiredActNotificationLevel(tvb, offset, &asn1_ctx, tree, hf_x2ap_DesiredActNotificationLevel_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DirectForwardingPathAvailability_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DirectForwardingPathAvailability(tvb, offset, &asn1_ctx, tree, hf_x2ap_DirectForwardingPathAvailability_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DL_Forwarding_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DL_Forwarding(tvb, offset, &asn1_ctx, tree, hf_x2ap_DL_Forwarding_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DL_scheduling_PDCCH_CCE_usage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DL_scheduling_PDCCH_CCE_usage(tvb, offset, &asn1_ctx, tree, hf_x2ap_DL_scheduling_PDCCH_CCE_usage_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DuplicationActivation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DuplicationActivation(tvb, offset, &asn1_ctx, tree, hf_x2ap_DuplicationActivation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DynamicDLTransmissionInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DynamicDLTransmissionInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_DynamicDLTransmissionInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EARFCNExtension_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EARFCNExtension(tvb, offset, &asn1_ctx, tree, hf_x2ap_EARFCNExtension_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ECGI_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ECGI(tvb, offset, &asn1_ctx, tree, hf_x2ap_ECGI_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EndcSONConfigurationTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EndcSONConfigurationTransfer(tvb, offset, &asn1_ctx, tree, hf_x2ap_EndcSONConfigurationTransfer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EnhancedRNTP_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EnhancedRNTP(tvb, offset, &asn1_ctx, tree, hf_x2ap_EnhancedRNTP_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EPCHandoverRestrictionListContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EPCHandoverRestrictionListContainer(tvb, offset, &asn1_ctx, tree, hf_x2ap_EPCHandoverRestrictionListContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ERABActivityNotifyItemList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ERABActivityNotifyItemList(tvb, offset, &asn1_ctx, tree, hf_x2ap_ERABActivityNotifyItemList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RAB_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RAB_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RAB_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RAB_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RAB_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RAB_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABUsageReport_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABUsageReport_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABUsageReport_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Ethernet_Type_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Ethernet_Type(tvb, offset, &asn1_ctx, tree, hf_x2ap_Ethernet_Type_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EUTRANCellIdentifier_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EUTRANCellIdentifier(tvb, offset, &asn1_ctx, tree, hf_x2ap_EUTRANCellIdentifier_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EUTRANTraceID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EUTRANTraceID(tvb, offset, &asn1_ctx, tree, hf_x2ap_EUTRANTraceID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExpectedUEBehaviour_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ExpectedUEBehaviour(tvb, offset, &asn1_ctx, tree, hf_x2ap_ExpectedUEBehaviour_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExtendedULInterferenceOverloadInfo_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ExtendedULInterferenceOverloadInfo(tvb, offset, &asn1_ctx, tree, hf_x2ap_ExtendedULInterferenceOverloadInfo_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExtendedBitRate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ExtendedBitRate(tvb, offset, &asn1_ctx, tree, hf_x2ap_ExtendedBitRate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_F1CTrafficContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_F1CTrafficContainer(tvb, offset, &asn1_ctx, tree, hf_x2ap_F1CTrafficContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_FastMCGRecovery_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_FastMCGRecovery(tvb, offset, &asn1_ctx, tree, hf_x2ap_FastMCGRecovery_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_FreqBandIndicatorPriority_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_FreqBandIndicatorPriority(tvb, offset, &asn1_ctx, tree, hf_x2ap_FreqBandIndicatorPriority_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_FrequencyShift7p5khz_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_FrequencyShift7p5khz(tvb, offset, &asn1_ctx, tree, hf_x2ap_FrequencyShift7p5khz_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GlobalENB_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_GlobalENB_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_GlobalENB_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GlobalGNB_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_GlobalGNB_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_GlobalGNB_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Global_RAN_NODE_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Global_RAN_NODE_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_Global_RAN_NODE_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNBOverloadInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_GNBOverloadInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_GNBOverloadInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GTPtunnelEndpoint_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_GTPtunnelEndpoint(tvb, offset, &asn1_ctx, tree, hf_x2ap_GTPtunnelEndpoint_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GUGroupIDList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_GUGroupIDList(tvb, offset, &asn1_ctx, tree, hf_x2ap_GUGroupIDList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GUMMEI_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_GUMMEI(tvb, offset, &asn1_ctx, tree, hf_x2ap_GUMMEI_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverReportType_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverReportType(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverReportType_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverRestrictionList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverRestrictionList(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverRestrictionList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_IABNodeIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_IABNodeIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_IABNodeIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_IMSvoiceEPSfallbackfrom5G_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_IMSvoiceEPSfallbackfrom5G(tvb, offset, &asn1_ctx, tree, hf_x2ap_IMSvoiceEPSfallbackfrom5G_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_IntendedTDD_DL_ULConfiguration_NR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_IntendedTDD_DL_ULConfiguration_NR(tvb, offset, &asn1_ctx, tree, hf_x2ap_IntendedTDD_DL_ULConfiguration_NR_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_InterfaceInstanceIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_InterfaceInstanceIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_InterfaceInstanceIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_InvokeIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_InvokeIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_InvokeIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_LCID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_LCID(tvb, offset, &asn1_ctx, tree, hf_x2ap_LCID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_LHN_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_LHN_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_LHN_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_LocationInformationSgNB_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_LocationInformationSgNB(tvb, offset, &asn1_ctx, tree, hf_x2ap_LocationInformationSgNB_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_LocationInformationSgNBReporting_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_LocationInformationSgNBReporting(tvb, offset, &asn1_ctx, tree, hf_x2ap_LocationInformationSgNBReporting_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_LowerLayerPresenceStatusChange_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_LowerLayerPresenceStatusChange(tvb, offset, &asn1_ctx, tree, hf_x2ap_LowerLayerPresenceStatusChange_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_M3Configuration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_M3Configuration(tvb, offset, &asn1_ctx, tree, hf_x2ap_M3Configuration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_M4Configuration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_M4Configuration(tvb, offset, &asn1_ctx, tree, hf_x2ap_M4Configuration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_M5Configuration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_M5Configuration(tvb, offset, &asn1_ctx, tree, hf_x2ap_M5Configuration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_M6Configuration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_M6Configuration(tvb, offset, &asn1_ctx, tree, hf_x2ap_M6Configuration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_M7Configuration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_M7Configuration(tvb, offset, &asn1_ctx, tree, hf_x2ap_M7Configuration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MakeBeforeBreakIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MakeBeforeBreakIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_MakeBeforeBreakIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ManagementBasedMDTallowed_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ManagementBasedMDTallowed(tvb, offset, &asn1_ctx, tree, hf_x2ap_ManagementBasedMDTallowed_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Masked_IMEISV_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Masked_IMEISV(tvb, offset, &asn1_ctx, tree, hf_x2ap_Masked_IMEISV_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MDT_Configuration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MDT_Configuration(tvb, offset, &asn1_ctx, tree, hf_x2ap_MDT_Configuration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MDTPLMNList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MDTPLMNList(tvb, offset, &asn1_ctx, tree, hf_x2ap_MDTPLMNList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MDT_Location_Info_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MDT_Location_Info(tvb, offset, &asn1_ctx, tree, hf_x2ap_MDT_Location_Info_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Measurement_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Measurement_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_Measurement_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Measurement_ID_ENDC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Measurement_ID_ENDC(tvb, offset, &asn1_ctx, tree, hf_x2ap_Measurement_ID_ENDC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MeNBCoordinationAssistanceInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MeNBCoordinationAssistanceInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_MeNBCoordinationAssistanceInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
int dissect_x2ap_MeNBResourceCoordinationInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MeNBResourceCoordinationInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_x2ap_MeNBResourceCoordinationInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MeNBtoSeNBContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MeNBtoSeNBContainer(tvb, offset, &asn1_ctx, tree, hf_x2ap_MeNBtoSeNBContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MBMS_Service_Area_Identity_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MBMS_Service_Area_Identity_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_MBMS_Service_Area_Identity_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MBSFN_Subframe_Infolist_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MBSFN_Subframe_Infolist(tvb, offset, &asn1_ctx, tree, hf_x2ap_MBSFN_Subframe_Infolist_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MDT_ConfigurationNR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MDT_ConfigurationNR(tvb, offset, &asn1_ctx, tree, hf_x2ap_MDT_ConfigurationNR_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MobilityParametersModificationRange_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MobilityParametersModificationRange(tvb, offset, &asn1_ctx, tree, hf_x2ap_MobilityParametersModificationRange_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MobilityParametersInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MobilityParametersInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_MobilityParametersInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MultibandInfoList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MultibandInfoList(tvb, offset, &asn1_ctx, tree, hf_x2ap_MultibandInfoList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MessageOversizeNotification_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MessageOversizeNotification(tvb, offset, &asn1_ctx, tree, hf_x2ap_MessageOversizeNotification_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MeNBtoSgNBContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MeNBtoSgNBContainer(tvb, offset, &asn1_ctx, tree, hf_x2ap_MeNBtoSgNBContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SplitSRBs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SplitSRBs(tvb, offset, &asn1_ctx, tree, hf_x2ap_SplitSRBs_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SplitSRB_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SplitSRB(tvb, offset, &asn1_ctx, tree, hf_x2ap_SplitSRB_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NBIoT_UL_DL_AlignmentOffset_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NBIoT_UL_DL_AlignmentOffset(tvb, offset, &asn1_ctx, tree, hf_x2ap_NBIoT_UL_DL_AlignmentOffset_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NBIoT_RLF_Report_Container_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NBIoT_RLF_Report_Container(tvb, offset, &asn1_ctx, tree, hf_x2ap_NBIoT_RLF_Report_Container_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NewDRBIDrequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NewDRBIDrequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_NewDRBIDrequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Number_of_Antennaports_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Number_of_Antennaports(tvb, offset, &asn1_ctx, tree, hf_x2ap_Number_of_Antennaports_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRCarrierList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRCarrierList(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRCarrierList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRCellPRACHConfig_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRCellPRACHConfig(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRCellPRACHConfig_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRCGI_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRCGI(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRCGI_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRNeighbour_Information_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRNeighbour_Information(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRNeighbour_Information_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NPRACHConfiguration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NPRACHConfiguration(tvb, offset, &asn1_ctx, tree, hf_x2ap_NPRACHConfiguration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRrestrictioninEPSasSecondaryRAT_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRrestrictioninEPSasSecondaryRAT(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRrestrictioninEPSasSecondaryRAT_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRrestrictionin5GS_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRrestrictionin5GS(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRrestrictionin5GS_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRS_NSSS_PowerOffset_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRS_NSSS_PowerOffset(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRS_NSSS_PowerOffset_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRUeReport_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRUeReport(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRUeReport_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRUESidelinkAggregateMaximumBitRate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRUESidelinkAggregateMaximumBitRate(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRUESidelinkAggregateMaximumBitRate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRUESecurityCapabilities_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRUESecurityCapabilities(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRUESecurityCapabilities_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NSSS_NumOccasionDifferentPrecoder_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NSSS_NumOccasionDifferentPrecoder(tvb, offset, &asn1_ctx, tree, hf_x2ap_NSSS_NumOccasionDifferentPrecoder_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_NRV2XServicesAuthorized_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_NRV2XServicesAuthorized(tvb, offset, &asn1_ctx, tree, hf_x2ap_NRV2XServicesAuthorized_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_OffsetOfNbiotChannelNumberToEARFCN_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_OffsetOfNbiotChannelNumberToEARFCN(tvb, offset, &asn1_ctx, tree, hf_x2ap_OffsetOfNbiotChannelNumberToEARFCN_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Packet_LossRate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Packet_LossRate(tvb, offset, &asn1_ctx, tree, hf_x2ap_Packet_LossRate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PC5QoSParameters_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PC5QoSParameters(tvb, offset, &asn1_ctx, tree, hf_x2ap_PC5QoSParameters_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PDCPChangeIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PDCPChangeIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_PDCPChangeIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PDCPSnLength_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PDCPSnLength(tvb, offset, &asn1_ctx, tree, hf_x2ap_PDCPSnLength_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PCI_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PCI(tvb, offset, &asn1_ctx, tree, hf_x2ap_PCI_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PLMN_Identity_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PLMN_Identity(tvb, offset, &asn1_ctx, tree, hf_x2ap_PLMN_Identity_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PRACH_Configuration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PRACH_Configuration(tvb, offset, &asn1_ctx, tree, hf_x2ap_PRACH_Configuration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ProSeAuthorized_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ProSeAuthorized(tvb, offset, &asn1_ctx, tree, hf_x2ap_ProSeAuthorized_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ProSeUEtoNetworkRelaying_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ProSeUEtoNetworkRelaying(tvb, offset, &asn1_ctx, tree, hf_x2ap_ProSeUEtoNetworkRelaying_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
int dissect_x2ap_ProtectedEUTRAResourceIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ProtectedEUTRAResourceIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_x2ap_ProtectedEUTRAResourceIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PartialListIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PartialListIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_PartialListIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PrivacyIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PrivacyIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_PrivacyIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_QoS_Mapping_Information_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_QoS_Mapping_Information(tvb, offset, &asn1_ctx, tree, hf_x2ap_QoS_Mapping_Information_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RAN_UE_NGAP_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RAN_UE_NGAP_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_RAN_UE_NGAP_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ReceiveStatusOfULPDCPSDUsExtended_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ReceiveStatusOfULPDCPSDUsExtended(tvb, offset, &asn1_ctx, tree, hf_x2ap_ReceiveStatusOfULPDCPSDUsExtended_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ReceiveStatusOfULPDCPSDUsPDCP_SNlength18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ReceiveStatusOfULPDCPSDUsPDCP_SNlength18(tvb, offset, &asn1_ctx, tree, hf_x2ap_ReceiveStatusOfULPDCPSDUsPDCP_SNlength18_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ReleaseFastMCGRecoveryViaSRB3_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ReleaseFastMCGRecoveryViaSRB3(tvb, offset, &asn1_ctx, tree, hf_x2ap_ReleaseFastMCGRecoveryViaSRB3_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Registration_Request_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Registration_Request(tvb, offset, &asn1_ctx, tree, hf_x2ap_Registration_Request_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ReportCharacteristics_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ReportCharacteristics(tvb, offset, &asn1_ctx, tree, hf_x2ap_ReportCharacteristics_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ReportingPeriodicityCSIR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ReportingPeriodicityCSIR(tvb, offset, &asn1_ctx, tree, hf_x2ap_ReportingPeriodicityCSIR_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ReportingPeriodicityRSRPMR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ReportingPeriodicityRSRPMR(tvb, offset, &asn1_ctx, tree, hf_x2ap_ReportingPeriodicityRSRPMR_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RequestedFastMCGRecoveryViaSRB3_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RequestedFastMCGRecoveryViaSRB3(tvb, offset, &asn1_ctx, tree, hf_x2ap_RequestedFastMCGRecoveryViaSRB3_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RequestedFastMCGRecoveryViaSRB3Release_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RequestedFastMCGRecoveryViaSRB3Release(tvb, offset, &asn1_ctx, tree, hf_x2ap_RequestedFastMCGRecoveryViaSRB3Release_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResumeID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResumeID(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResumeID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RLCMode_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RLCMode(tvb, offset, &asn1_ctx, tree, hf_x2ap_RLCMode_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RLC_Status_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RLC_Status(tvb, offset, &asn1_ctx, tree, hf_x2ap_RLC_Status_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RRC_Config_Ind_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RRC_Config_Ind(tvb, offset, &asn1_ctx, tree, hf_x2ap_RRC_Config_Ind_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RRCConnReestabIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RRCConnReestabIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_RRCConnReestabIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RRCConnSetupIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RRCConnSetupIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_RRCConnSetupIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RSRPMRList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RSRPMRList(tvb, offset, &asn1_ctx, tree, hf_x2ap_RSRPMRList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SCGChangeIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SCGChangeIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_SCGChangeIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SecondaryRATUsageReportList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SecondaryRATUsageReportList(tvb, offset, &asn1_ctx, tree, hf_x2ap_SecondaryRATUsageReportList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SecondaryRATUsageReport_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SecondaryRATUsageReport_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_SecondaryRATUsageReport_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBSecurityKey_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBSecurityKey(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBSecurityKey_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBtoMeNBContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBtoMeNBContainer(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBtoMeNBContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedCells_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedCells(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedCells_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServiceType_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServiceType(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServiceType_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBCoordinationAssistanceInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBCoordinationAssistanceInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBCoordinationAssistanceInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
int dissect_x2ap_SgNBResourceCoordinationInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBResourceCoordinationInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_x2ap_SgNBResourceCoordinationInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNB_UE_X2AP_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNB_UE_X2AP_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNB_UE_X2AP_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SIPTOBearerDeactivationIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SIPTOBearerDeactivationIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_SIPTOBearerDeactivationIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ShortMAC_I_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ShortMAC_I(tvb, offset, &asn1_ctx, tree, hf_x2ap_ShortMAC_I_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SGNB_Addition_Trigger_Ind_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SGNB_Addition_Trigger_Ind(tvb, offset, &asn1_ctx, tree, hf_x2ap_SGNB_Addition_Trigger_Ind_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SNtriggered_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SNtriggered(tvb, offset, &asn1_ctx, tree, hf_x2ap_SNtriggered_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SpectrumSharingGroupID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SpectrumSharingGroupID(tvb, offset, &asn1_ctx, tree, hf_x2ap_SpectrumSharingGroupID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Subscription_Based_UE_DifferentiationInfo_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Subscription_Based_UE_DifferentiationInfo(tvb, offset, &asn1_ctx, tree, hf_x2ap_Subscription_Based_UE_DifferentiationInfo_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SRVCCOperationPossible_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SRVCCOperationPossible(tvb, offset, &asn1_ctx, tree, hf_x2ap_SRVCCOperationPossible_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SSB_PositionsInBurst_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SSB_PositionsInBurst(tvb, offset, &asn1_ctx, tree, hf_x2ap_SSB_PositionsInBurst_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SubscriberProfileIDforRFP_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SubscriberProfileIDforRFP(tvb, offset, &asn1_ctx, tree, hf_x2ap_SubscriberProfileIDforRFP_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SubframeAssignment_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SubframeAssignment(tvb, offset, &asn1_ctx, tree, hf_x2ap_SubframeAssignment_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBSecurityKey_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBSecurityKey(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBSecurityKey_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBtoMeNBContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBtoMeNBContainer(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBtoMeNBContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SCGConfigurationQuery_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SCGConfigurationQuery(tvb, offset, &asn1_ctx, tree, hf_x2ap_SCGConfigurationQuery_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SFN_Offset_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SFN_Offset(tvb, offset, &asn1_ctx, tree, hf_x2ap_SFN_Offset_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TAC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TAC(tvb, offset, &asn1_ctx, tree, hf_x2ap_TAC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TargetCellInNGRAN_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TargetCellInNGRAN(tvb, offset, &asn1_ctx, tree, hf_x2ap_TargetCellInNGRAN_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TargetCellInUTRAN_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TargetCellInUTRAN(tvb, offset, &asn1_ctx, tree, hf_x2ap_TargetCellInUTRAN_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TargeteNBtoSource_eNBTransparentContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TargeteNBtoSource_eNBTransparentContainer(tvb, offset, &asn1_ctx, tree, hf_x2ap_TargeteNBtoSource_eNBTransparentContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TDDULDLConfigurationCommonNR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TDDULDLConfigurationCommonNR(tvb, offset, &asn1_ctx, tree, hf_x2ap_TDDULDLConfigurationCommonNR_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TimeToWait_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TimeToWait(tvb, offset, &asn1_ctx, tree, hf_x2ap_TimeToWait_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Time_UE_StayedInCell_EnhancedGranularity_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Time_UE_StayedInCell_EnhancedGranularity(tvb, offset, &asn1_ctx, tree, hf_x2ap_Time_UE_StayedInCell_EnhancedGranularity_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TNLA_To_Add_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TNLA_To_Add_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_TNLA_To_Add_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TNLA_To_Update_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TNLA_To_Update_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_TNLA_To_Update_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TNLA_To_Remove_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TNLA_To_Remove_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_TNLA_To_Remove_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TNLA_Setup_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TNLA_Setup_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_TNLA_Setup_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TNLA_Failed_To_Setup_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TNLA_Failed_To_Setup_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_TNLA_Failed_To_Setup_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TNLConfigurationInfo_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TNLConfigurationInfo(tvb, offset, &asn1_ctx, tree, hf_x2ap_TNLConfigurationInfo_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TraceActivation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TraceActivation(tvb, offset, &asn1_ctx, tree, hf_x2ap_TraceActivation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TransportLayerAddress_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TransportLayerAddress(tvb, offset, &asn1_ctx, tree, hf_x2ap_TransportLayerAddress_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TunnelInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TunnelInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_TunnelInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UEAggregateMaximumBitRate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UEAggregateMaximumBitRate(tvb, offset, &asn1_ctx, tree, hf_x2ap_UEAggregateMaximumBitRate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UEAppLayerMeasConfig_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UEAppLayerMeasConfig(tvb, offset, &asn1_ctx, tree, hf_x2ap_UEAppLayerMeasConfig_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextKeptIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextKeptIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextKeptIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UEID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UEID(tvb, offset, &asn1_ctx, tree, hf_x2ap_UEID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_HistoryInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_HistoryInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_HistoryInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_HistoryInformationFromTheUE_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_HistoryInformationFromTheUE(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_HistoryInformationFromTheUE_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_X2AP_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_X2AP_ID(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_X2AP_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_X2AP_ID_Extension_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_X2AP_ID_Extension(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_X2AP_ID_Extension_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UERadioCapability_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UERadioCapability(tvb, offset, &asn1_ctx, tree, hf_x2ap_UERadioCapability_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UERadioCapabilityID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UERadioCapabilityID(tvb, offset, &asn1_ctx, tree, hf_x2ap_UERadioCapabilityID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_RLF_Report_Container_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_RLF_Report_Container(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_RLF_Report_Container_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_RLF_Report_Container_for_extended_bands_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_RLF_Report_Container_for_extended_bands(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_RLF_Report_Container_for_extended_bands_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UESecurityCapabilities_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UESecurityCapabilities(tvb, offset, &asn1_ctx, tree, hf_x2ap_UESecurityCapabilities_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UESidelinkAggregateMaximumBitRate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UESidelinkAggregateMaximumBitRate(tvb, offset, &asn1_ctx, tree, hf_x2ap_UESidelinkAggregateMaximumBitRate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UEsToBeResetList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UEsToBeResetList(tvb, offset, &asn1_ctx, tree, hf_x2ap_UEsToBeResetList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UL_scheduling_PDCCH_CCE_usage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UL_scheduling_PDCCH_CCE_usage(tvb, offset, &asn1_ctx, tree, hf_x2ap_UL_scheduling_PDCCH_CCE_usage_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UnlicensedSpectrumRestriction_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UnlicensedSpectrumRestriction(tvb, offset, &asn1_ctx, tree, hf_x2ap_UnlicensedSpectrumRestriction_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_URI_Address_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_URI_Address(tvb, offset, &asn1_ctx, tree, hf_x2ap_URI_Address_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UserPlaneTrafficActivityReport_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UserPlaneTrafficActivityReport(tvb, offset, &asn1_ctx, tree, hf_x2ap_UserPlaneTrafficActivityReport_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_V2XServicesAuthorized_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_V2XServicesAuthorized(tvb, offset, &asn1_ctx, tree, hf_x2ap_V2XServicesAuthorized_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_WLANMeasurementConfiguration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_WLANMeasurementConfiguration(tvb, offset, &asn1_ctx, tree, hf_x2ap_WLANMeasurementConfiguration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2BenefitValue_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2BenefitValue(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2BenefitValue_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeSetup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeSetup_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeSetup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MobilityInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MobilityInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_MobilityInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextReferenceAtSeNB_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextReferenceAtSeNB(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextReferenceAtSeNB_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextReferenceAtWT_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextReferenceAtWT(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextReferenceAtWT_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextReferenceAtSgNB_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextReferenceAtSgNB(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextReferenceAtSgNB_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverRequestAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverRequestAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverRequestAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverPreparationFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverPreparationFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverPreparationFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverReport_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverReport(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverReport_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EarlyStatusTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EarlyStatusTransfer(tvb, offset, &asn1_ctx, tree, hf_x2ap_EarlyStatusTransfer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ProcedureStageChoice_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ProcedureStageChoice(tvb, offset, &asn1_ctx, tree, hf_x2ap_ProcedureStageChoice_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SNStatusTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SNStatusTransfer(tvb, offset, &asn1_ctx, tree, hf_x2ap_SNStatusTransfer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_SubjectToStatusTransfer_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_SubjectToStatusTransfer_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_SubjectToStatusTransfer_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_SubjectToStatusTransfer_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_SubjectToStatusTransfer_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_SubjectToStatusTransfer_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UEContextRelease_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UEContextRelease(tvb, offset, &asn1_ctx, tree, hf_x2ap_UEContextRelease_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverCancel_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverCancel(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverCancel_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverSuccess_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_HandoverSuccess(tvb, offset, &asn1_ctx, tree, hf_x2ap_HandoverSuccess_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ConditionalHandoverCancel_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ConditionalHandoverCancel(tvb, offset, &asn1_ctx, tree, hf_x2ap_ConditionalHandoverCancel_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ErrorIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ErrorIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_ErrorIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResetRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResetRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResetRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResetResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResetResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResetResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2SetupRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2SetupRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2SetupRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2SetupResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2SetupResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2SetupResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2SetupFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2SetupFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2SetupFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_LoadInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_LoadInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_LoadInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellInformation_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellInformation_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellInformation_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellInformation_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellInformation_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellInformation_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENBConfigurationUpdate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENBConfigurationUpdate(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENBConfigurationUpdate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedCellsToModify_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedCellsToModify(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedCellsToModify_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Old_ECGIs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_Old_ECGIs(tvb, offset, &asn1_ctx, tree, hf_x2ap_Old_ECGIs_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENBConfigurationUpdateAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENBConfigurationUpdateAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENBConfigurationUpdateAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENBConfigurationUpdateFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENBConfigurationUpdateFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENBConfigurationUpdateFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResourceStatusRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResourceStatusRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResourceStatusRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellToReport_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellToReport_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellToReport_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellToReport_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellToReport_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellToReport_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ReportingPeriodicity_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ReportingPeriodicity(tvb, offset, &asn1_ctx, tree, hf_x2ap_ReportingPeriodicity_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PartialSuccessIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PartialSuccessIndicator(tvb, offset, &asn1_ctx, tree, hf_x2ap_PartialSuccessIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResourceStatusResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResourceStatusResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResourceStatusResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MeasurementInitiationResult_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MeasurementInitiationResult_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_MeasurementInitiationResult_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MeasurementInitiationResult_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MeasurementInitiationResult_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_MeasurementInitiationResult_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MeasurementFailureCause_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MeasurementFailureCause_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_MeasurementFailureCause_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResourceStatusFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResourceStatusFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResourceStatusFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CompleteFailureCauseInformation_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CompleteFailureCauseInformation_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CompleteFailureCauseInformation_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CompleteFailureCauseInformation_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CompleteFailureCauseInformation_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CompleteFailureCauseInformation_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResourceStatusUpdate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResourceStatusUpdate(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResourceStatusUpdate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellMeasurementResult_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellMeasurementResult_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellMeasurementResult_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellMeasurementResult_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellMeasurementResult_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellMeasurementResult_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_PrivateMessage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_PrivateMessage(tvb, offset, &asn1_ctx, tree, hf_x2ap_PrivateMessage_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MobilityChangeRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MobilityChangeRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_MobilityChangeRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MobilityChangeAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MobilityChangeAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_MobilityChangeAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_MobilityChangeFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_MobilityChangeFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_MobilityChangeFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RLFIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RLFIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_RLFIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellActivationRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellActivationRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellActivationRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedCellsToActivate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedCellsToActivate(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedCellsToActivate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellActivationResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellActivationResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellActivationResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ActivatedCellList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ActivatedCellList(tvb, offset, &asn1_ctx, tree, hf_x2ap_ActivatedCellList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellActivationFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellActivationFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellActivationFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2Release_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2Release(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2Release_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2APMessageTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2APMessageTransfer(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2APMessageTransfer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RNL_Header_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RNL_Header(tvb, offset, &asn1_ctx, tree, hf_x2ap_RNL_Header_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2AP_Message_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2AP_Message(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2AP_Message_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBAdditionRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBAdditionRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBAdditionRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeAdded_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeAdded_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeAdded_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeAdded_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeAdded_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeAdded_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBAdditionRequestAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBAdditionRequestAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBAdditionRequestAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBAdditionRequestReject_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBAdditionRequestReject(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBAdditionRequestReject_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBReconfigurationComplete_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBReconfigurationComplete(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBReconfigurationComplete_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResponseInformationSeNBReconfComp_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResponseInformationSeNBReconfComp(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResponseInformationSeNBReconfComp_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBModificationRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBModificationRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBModificationRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextInformationSeNBModReq_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextInformationSeNBModReq(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextInformationSeNBModReq_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeAdded_ModReqItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeAdded_ModReqItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeAdded_ModReqItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeModified_ModReqItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeModified_ModReqItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeModified_ModReqItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_ModReqItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_ModReqItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_ModReqItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBModificationRequestAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBModificationRequestAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBModificationRequestAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_ModAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_ModAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_ModAckItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_ModAckItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeModified_ModAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeModified_ModAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeModified_ModAckItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeModified_ModAckItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeReleased_ModAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeReleased_ModAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToReleased_ModAckItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToReleased_ModAckItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToReleased_ModAckItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBModificationRequestReject_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBModificationRequestReject(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBModificationRequestReject_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBModificationRequired_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBModificationRequired(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBModificationRequired_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_ModReqd_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_ModReqd(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_ModReqd_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_ModReqdItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_ModReqdItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_ModReqdItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBModificationConfirm_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBModificationConfirm(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBModificationConfirm_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBModificationRefuse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBModificationRefuse(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBModificationRefuse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBReleaseRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBReleaseRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBReleaseRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_List_RelReq_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_List_RelReq(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_List_RelReq_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_RelReqItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_RelReqItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_RelReqItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBReleaseRequired_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBReleaseRequired(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBReleaseRequired_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBReleaseConfirm_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBReleaseConfirm(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBReleaseConfirm_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_List_RelConf_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_List_RelConf(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_List_RelConf_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_RelConfItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_RelConfItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_RelConfItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SeNBCounterCheckRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SeNBCounterCheckRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SeNBCounterCheckRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_SubjectToCounterCheck_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_SubjectToCounterCheck_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_SubjectToCounterCheck_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_SubjectToCounterCheckItem_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_SubjectToCounterCheckItem(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_SubjectToCounterCheckItem_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2RemovalRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2RemovalRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2RemovalRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2RemovalResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2RemovalResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2RemovalResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2RemovalFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2RemovalFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2RemovalFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RetrieveUEContextRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RetrieveUEContextRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_RetrieveUEContextRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RetrieveUEContextResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RetrieveUEContextResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_RetrieveUEContextResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextInformationRetrieve_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextInformationRetrieve(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextInformationRetrieve_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeSetupRetrieve_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeSetupRetrieve_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeSetupRetrieve_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RetrieveUEContextFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RetrieveUEContextFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_RetrieveUEContextFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBAdditionRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBAdditionRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBAdditionRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeAdded_SgNBAddReqList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReqList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeAdded_SgNBAddReqList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeAdded_SgNBAddReq_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeAdded_SgNBAddReq_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBAdditionRequestAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBAdditionRequestAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBAdditionRequestAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBAddReqAck_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBAdditionRequestReject_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBAdditionRequestReject(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBAdditionRequestReject_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBReconfigurationComplete_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBReconfigurationComplete(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBReconfigurationComplete_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ResponseInformationSgNBReconfComp_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ResponseInformationSgNBReconfComp(tvb, offset, &asn1_ctx, tree, hf_x2ap_ResponseInformationSgNBReconfComp_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBModificationRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBModificationRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBModificationRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UE_ContextInformation_SgNBModReq_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UE_ContextInformation_SgNBModReq(tvb, offset, &asn1_ctx, tree, hf_x2ap_UE_ContextInformation_SgNBModReq_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeAdded_SgNBModReq_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeAdded_SgNBModReq_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeModified_SgNBModReq_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeModified_SgNBModReq_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeModified_SgNBModReq_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBModReq_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBModReq_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBModificationRequestAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBModificationRequestAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBModificationRequestAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_SgNBModAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeAdded_SgNBModAck_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeModified_SgNBModAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeModified_SgNBModAck_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeReleased_SgNBModAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBModAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToReleased_SgNBModAck_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToReleased_SgNBModAck_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToReleased_SgNBModAck_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBModificationRequestReject_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBModificationRequestReject(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBModificationRequestReject_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBModificationRequired_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBModificationRequired(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBModificationRequired_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBModReqdList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBModReqdList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBModReqdList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBModReqd_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBModReqd_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBModReqd_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeModified_SgNBModReqdList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeModified_SgNBModReqdList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeModified_SgNBModReqdList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeModified_SgNBModReqd_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeModified_SgNBModReqd_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBModificationConfirm_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBModificationConfirm(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBModificationConfirm_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_AdmittedToBeModified_SgNBModConfList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_AdmittedToBeModified_SgNBModConfList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_AdmittedToBeModified_SgNBModConf_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_AdmittedToBeModified_SgNBModConf_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBModificationRefuse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBModificationRefuse(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBModificationRefuse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBReleaseRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBReleaseRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBReleaseRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBRelReqList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReqList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBRelReq_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBRelReq_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBReleaseRequestAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBReleaseRequestAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBReleaseRequestAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAckList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_Admitted_ToBeReleased_SgNBRelReqAck_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBReleaseRequestReject_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBReleaseRequestReject(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBReleaseRequestReject_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBReleaseRequired_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBReleaseRequired(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBReleaseRequired_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBRelReqdList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqdList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBRelReqd_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBRelReqd_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBRelReqd_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBReleaseConfirm_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBReleaseConfirm(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBReleaseConfirm_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBRelConfList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConfList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBRelConfList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBRelConf_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBRelConf_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBCounterCheckRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBCounterCheckRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBCounterCheckRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_SubjectToSgNBCounterCheck_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_SubjectToSgNBCounterCheck_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_SubjectToSgNBCounterCheck_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_SubjectToSgNBCounterCheck_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_SubjectToSgNBCounterCheck_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_SubjectToSgNBCounterCheck_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBChangeRequired_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBChangeRequired(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBChangeRequired_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBChangeConfirm_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBChangeConfirm(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBChangeConfirm_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBChaConfList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConfList(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBChaConfList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_ToBeReleased_SgNBChaConf_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_ToBeReleased_SgNBChaConf_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RRCTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RRCTransfer(tvb, offset, &asn1_ctx, tree, hf_x2ap_RRCTransfer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBChangeRefuse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBChangeRefuse(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBChangeRefuse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCX2SetupRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCX2SetupRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCX2SetupRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_InitiatingNodeType_EndcX2Setup_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_InitiatingNodeType_EndcX2Setup(tvb, offset, &asn1_ctx, tree, hf_x2ap_InitiatingNodeType_EndcX2Setup_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedEUTRAcellsENDCX2ManagementList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedEUTRAcellsENDCX2ManagementList(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedEUTRAcellsENDCX2ManagementList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedNRcellsENDCX2ManagementList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedNRcellsENDCX2ManagementList(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedNRcellsENDCX2ManagementList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellandCapacityAssistInfo_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellandCapacityAssistInfo(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellandCapacityAssistInfo_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellAssistanceInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellAssistanceInformation(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellAssistanceInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCX2SetupResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCX2SetupResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCX2SetupResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RespondingNodeType_EndcX2Setup_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RespondingNodeType_EndcX2Setup(tvb, offset, &asn1_ctx, tree, hf_x2ap_RespondingNodeType_EndcX2Setup_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCX2SetupFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCX2SetupFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCX2SetupFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCConfigurationUpdate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCConfigurationUpdate(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCConfigurationUpdate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_InitiatingNodeType_EndcConfigUpdate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_InitiatingNodeType_EndcConfigUpdate(tvb, offset, &asn1_ctx, tree, hf_x2ap_InitiatingNodeType_EndcConfigUpdate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedEUTRAcellsToModifyListENDCConfUpd_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedEUTRAcellsToModifyListENDCConfUpd_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedEUTRAcellsToDeleteListENDCConfUpd_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedEUTRAcellsToDeleteListENDCConfUpd_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedNRcellsToModifyENDCConfUpdList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedNRcellsToModifyENDCConfUpdList(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedNRcellsToModifyENDCConfUpdList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedNRcellsToDeleteENDCConfUpdList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedNRcellsToDeleteENDCConfUpdList(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedNRcellsToDeleteENDCConfUpdList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCConfigurationUpdateAcknowledge_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCConfigurationUpdateAcknowledge(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCConfigurationUpdateAcknowledge_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RespondingNodeType_EndcConfigUpdate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RespondingNodeType_EndcConfigUpdate(tvb, offset, &asn1_ctx, tree, hf_x2ap_RespondingNodeType_EndcConfigUpdate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCConfigurationUpdateFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCConfigurationUpdateFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCConfigurationUpdateFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCCellActivationRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCCellActivationRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCCellActivationRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ServedNRCellsToActivate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ServedNRCellsToActivate(tvb, offset, &asn1_ctx, tree, hf_x2ap_ServedNRCellsToActivate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCCellActivationResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCCellActivationResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCCellActivationResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ActivatedNRCellList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ActivatedNRCellList(tvb, offset, &asn1_ctx, tree, hf_x2ap_ActivatedNRCellList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCCellActivationFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCCellActivationFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCCellActivationFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCResourceStatusRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCResourceStatusRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCResourceStatusRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellToReport_NR_ENDC_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellToReport_NR_ENDC_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellToReport_NR_ENDC_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellToReport_NR_ENDC_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellToReport_NR_ENDC_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellToReport_NR_ENDC_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellToReport_E_UTRA_ENDC_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellToReport_E_UTRA_ENDC_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellToReport_E_UTRA_ENDC_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellToReport_E_UTRA_ENDC_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellToReport_E_UTRA_ENDC_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellToReport_E_UTRA_ENDC_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCResourceStatusResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCResourceStatusResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCResourceStatusResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCResourceStatusFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCResourceStatusFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCResourceStatusFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCResourceStatusUpdate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCResourceStatusUpdate(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCResourceStatusUpdate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellMeasurementResult_NR_ENDC_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellMeasurementResult_NR_ENDC_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellMeasurementResult_NR_ENDC_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellMeasurementResult_NR_ENDC_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellMeasurementResult_NR_ENDC_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellMeasurementResult_NR_ENDC_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellMeasurementResult_E_UTRA_ENDC_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellMeasurementResult_E_UTRA_ENDC_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellMeasurementResult_E_UTRA_ENDC_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellMeasurementResult_E_UTRA_ENDC_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellMeasurementResult_E_UTRA_ENDC_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellMeasurementResult_E_UTRA_ENDC_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SecondaryRATDataUsageReport_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SecondaryRATDataUsageReport(tvb, offset, &asn1_ctx, tree, hf_x2ap_SecondaryRATDataUsageReport_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_SgNBActivityNotification_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_SgNBActivityNotification(tvb, offset, &asn1_ctx, tree, hf_x2ap_SgNBActivityNotification_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCPartialResetRequired_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCPartialResetRequired(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCPartialResetRequired_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCPartialResetConfirm_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCPartialResetConfirm(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCPartialResetConfirm_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
int dissect_x2ap_EUTRANRCellResourceCoordinationRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EUTRANRCellResourceCoordinationRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_x2ap_EUTRANRCellResourceCoordinationRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_InitiatingNodeType_EutranrCellResourceCoordination_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_InitiatingNodeType_EutranrCellResourceCoordination(tvb, offset, &asn1_ctx, tree, hf_x2ap_InitiatingNodeType_EutranrCellResourceCoordination_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ListofEUTRACellsinEUTRACoordinationReq_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ListofEUTRACellsinEUTRACoordinationReq(tvb, offset, &asn1_ctx, tree, hf_x2ap_ListofEUTRACellsinEUTRACoordinationReq_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ListofEUTRACellsinNRCoordinationReq_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ListofEUTRACellsinNRCoordinationReq(tvb, offset, &asn1_ctx, tree, hf_x2ap_ListofEUTRACellsinNRCoordinationReq_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ListofNRCellsinNRCoordinationReq_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ListofNRCellsinNRCoordinationReq(tvb, offset, &asn1_ctx, tree, hf_x2ap_ListofNRCellsinNRCoordinationReq_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
int dissect_x2ap_EUTRANRCellResourceCoordinationResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_EUTRANRCellResourceCoordinationResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_x2ap_EUTRANRCellResourceCoordinationResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RespondingNodeType_EutranrCellResourceCoordination_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RespondingNodeType_EutranrCellResourceCoordination(tvb, offset, &asn1_ctx, tree, hf_x2ap_RespondingNodeType_EutranrCellResourceCoordination_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ListofEUTRACellsinEUTRACoordinationResp_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ListofEUTRACellsinEUTRACoordinationResp(tvb, offset, &asn1_ctx, tree, hf_x2ap_ListofEUTRACellsinEUTRACoordinationResp_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ListofNRCellsinNRCoordinationResp_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ListofNRCellsinNRCoordinationResp(tvb, offset, &asn1_ctx, tree, hf_x2ap_ListofNRCellsinNRCoordinationResp_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCX2RemovalRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCX2RemovalRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCX2RemovalRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_InitiatingNodeType_EndcX2Removal_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_InitiatingNodeType_EndcX2Removal(tvb, offset, &asn1_ctx, tree, hf_x2ap_InitiatingNodeType_EndcX2Removal_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCX2RemovalResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCX2RemovalResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCX2RemovalResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_RespondingNodeType_EndcX2Removal_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_RespondingNodeType_EndcX2Removal(tvb, offset, &asn1_ctx, tree, hf_x2ap_RespondingNodeType_EndcX2Removal_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCX2RemovalFailure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCX2RemovalFailure(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCX2RemovalFailure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DataForwardingAddressIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DataForwardingAddressIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_DataForwardingAddressIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_DataForwardingAddress_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_DataForwardingAddress_List(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_DataForwardingAddress_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_RABs_DataForwardingAddress_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_E_RABs_DataForwardingAddress_Item(tvb, offset, &asn1_ctx, tree, hf_x2ap_E_RABs_DataForwardingAddress_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNBStatusIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_GNBStatusIndication(tvb, offset, &asn1_ctx, tree, hf_x2ap_GNBStatusIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ENDCConfigurationTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_ENDCConfigurationTransfer(tvb, offset, &asn1_ctx, tree, hf_x2ap_ENDCConfigurationTransfer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_TraceStart_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_TraceStart(tvb, offset, &asn1_ctx, tree, hf_x2ap_TraceStart_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DeactivateTrace_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_DeactivateTrace(tvb, offset, &asn1_ctx, tree, hf_x2ap_DeactivateTrace_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellTrafficTrace_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_CellTrafficTrace(tvb, offset, &asn1_ctx, tree, hf_x2ap_CellTrafficTrace_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_F1CTrafficTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_F1CTrafficTransfer(tvb, offset, &asn1_ctx, tree, hf_x2ap_F1CTrafficTransfer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UERadioCapabilityIDMappingRequest_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UERadioCapabilityIDMappingRequest(tvb, offset, &asn1_ctx, tree, hf_x2ap_UERadioCapabilityIDMappingRequest_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_UERadioCapabilityIDMappingResponse_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_UERadioCapabilityIDMappingResponse(tvb, offset, &asn1_ctx, tree, hf_x2ap_UERadioCapabilityIDMappingResponse_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_X2AP_PDU_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_x2ap_X2AP_PDU(tvb, offset, &asn1_ctx, tree, hf_x2ap_X2AP_PDU_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/*--- End of included file: packet-x2ap-fn.c ---*/
#line 297 "./asn1/x2ap/packet-x2ap-template.c"

static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(pinfo);

  return (dissector_try_uint_new(x2ap_ies_dissector_table, x2ap_data->protocol_ie_id, tvb, pinfo, tree, FALSE, NULL)) ? tvb_captured_length(tvb) : 0;
}

static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(pinfo);

  return (dissector_try_uint_new(x2ap_extension_dissector_table, x2ap_data->protocol_ie_id, tvb, pinfo, tree, FALSE, NULL)) ? tvb_captured_length(tvb) : 0;
}

static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(pinfo);

  x2ap_data->message_type = INITIATING_MESSAGE;
  return (dissector_try_uint_new(x2ap_proc_imsg_dissector_table, x2ap_data->procedure_code, tvb, pinfo, tree, FALSE, NULL)) ? tvb_captured_length(tvb) : 0;
}

static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(pinfo);

  x2ap_data->message_type = SUCCESSFUL_OUTCOME;
  return (dissector_try_uint_new(x2ap_proc_sout_dissector_table, x2ap_data->procedure_code, tvb, pinfo, tree, FALSE, NULL)) ? tvb_captured_length(tvb) : 0;
}

static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
  struct x2ap_private_data *x2ap_data = x2ap_get_private_data(pinfo);

  x2ap_data->message_type = UNSUCCESSFUL_OUTCOME;
  return (dissector_try_uint_new(x2ap_proc_uout_dissector_table, x2ap_data->procedure_code, tvb, pinfo, tree, FALSE, NULL)) ? tvb_captured_length(tvb) : 0;
}

static int
dissect_x2ap(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data)
{
  proto_item *x2ap_item;
  proto_tree *x2ap_tree;

  /* make entry in the Protocol column on summary display */
  col_set_str(pinfo->cinfo, COL_PROTOCOL, "X2AP");
  col_clear_fence(pinfo->cinfo, COL_INFO);
  col_clear(pinfo->cinfo, COL_INFO);

  /* create the x2ap protocol tree */
  x2ap_item = proto_tree_add_item(tree, proto_x2ap, tvb, 0, -1, ENC_NA);
  x2ap_tree = proto_item_add_subtree(x2ap_item, ett_x2ap);

  return dissect_X2AP_PDU_PDU(tvb, pinfo, x2ap_tree, data);
}

/*--- proto_register_x2ap -------------------------------------------*/
void proto_register_x2ap(void) {

  /* List of fields */

  static hf_register_info hf[] = {
    { &hf_x2ap_transportLayerAddressIPv4,
      { "transportLayerAddress(IPv4)", "x2ap.transportLayerAddressIPv4",
        FT_IPv4, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_x2ap_transportLayerAddressIPv6,
      { "transportLayerAddress(IPv6)", "x2ap.transportLayerAddressIPv6",
        FT_IPv6, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_PRBPeriodic,
      { "PRBPeriodic", "x2ap.ReportCharacteristics.PRBPeriodic",
        FT_BOOLEAN, 32, TFS(&tfs_requested_not_requested), 0x80000000,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_TNLLoadIndPeriodic,
      { "TNLLoadIndPeriodic", "x2ap.ReportCharacteristics.TNLLoadIndPeriodic",
        FT_BOOLEAN, 32, TFS(&tfs_requested_not_requested), 0x40000000,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_HWLoadIndPeriodic,
      { "HWLoadIndPeriodic", "x2ap.ReportCharacteristics.HWLoadIndPeriodic",
        FT_BOOLEAN, 32, TFS(&tfs_requested_not_requested), 0x20000000,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_CompositeAvailableCapacityPeriodic,
      { "CompositeAvailableCapacityPeriodic", "x2ap.ReportCharacteristics.CompositeAvailableCapacityPeriodic",
        FT_BOOLEAN, 32, TFS(&tfs_requested_not_requested), 0x10000000,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_ABSStatusPeriodic,
      { "ABSStatusPeriodic", "x2ap.ReportCharacteristics.ABSStatusPeriodic",
        FT_BOOLEAN, 32, TFS(&tfs_requested_not_requested), 0x08000000,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_RSRPMeasurementReportPeriodic,
      { "RSRPMeasurementReportPeriodic", "x2ap.ReportCharacteristics.RSRPMeasurementReportPeriodic",
        FT_BOOLEAN, 32, TFS(&tfs_requested_not_requested), 0x04000000,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_CSIReportPeriodic,
      { "CSIReportPeriodic", "x2ap.ReportCharacteristics.CSIReportPeriodic",
        FT_BOOLEAN, 32, TFS(&tfs_requested_not_requested), 0x02000000,
        NULL, HFILL }},
    { &hf_x2ap_ReportCharacteristics_Reserved,
      { "Reserved", "x2ap.ReportCharacteristics.Reserved",
        FT_UINT32, BASE_HEX, NULL, 0x01ffffff,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_PRBPeriodic,
      { "PRBPeriodic", "x2ap.measurementFailedReportCharacteristics.PRBPeriodic",
        FT_BOOLEAN, 32, TFS(&x2ap_tfs_failed_succeeded), 0x80000000,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_TNLLoadIndPeriodic,
      { "TNLLoadIndPeriodic", "x2ap.measurementFailedReportCharacteristics.TNLLoadIndPeriodic",
        FT_BOOLEAN, 32, TFS(&x2ap_tfs_failed_succeeded), 0x40000000,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_HWLoadIndPeriodic,
      { "HWLoadIndPeriodic", "x2ap.measurementFailedReportCharacteristics.HWLoadIndPeriodic",
        FT_BOOLEAN, 32, TFS(&x2ap_tfs_failed_succeeded), 0x20000000,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_CompositeAvailableCapacityPeriodic,
      { "CompositeAvailableCapacityPeriodic", "x2ap.measurementFailedReportCharacteristics.CompositeAvailableCapacityPeriodic",
        FT_BOOLEAN, 32, TFS(&x2ap_tfs_failed_succeeded), 0x10000000,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_ABSStatusPeriodic,
      { "ABSStatusPeriodic", "x2ap.measurementFailedReportCharacteristics.ABSStatusPeriodic",
        FT_BOOLEAN, 32, TFS(&x2ap_tfs_failed_succeeded), 0x08000000,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_RSRPMeasurementReportPeriodic,
      { "RSRPMeasurementReportPeriodic", "x2ap.measurementFailedReportCharacteristics.RSRPMeasurementReportPeriodic",
        FT_BOOLEAN, 32, TFS(&x2ap_tfs_failed_succeeded), 0x04000000,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_CSIReportPeriodic,
      { "CSIReportPeriodic", "x2ap.measurementFailedReportCharacteristics.CSIReportPeriodic",
        FT_BOOLEAN, 32, TFS(&x2ap_tfs_failed_succeeded), 0x02000000,
        NULL, HFILL }},
    { &hf_x2ap_measurementFailedReportCharacteristics_Reserved,
      { "Reserved", "x2ap.measurementFailedReportCharacteristics.Reserved",
        FT_UINT32, BASE_HEX, NULL, 0x01ffffff,
        NULL, HFILL }},
    { &hf_x2ap_eUTRANTraceID_TraceID,
      { "TraceID", "x2ap.eUTRANTraceID.TraceID",
        FT_UINT24, BASE_HEX, NULL, 0,
        NULL, HFILL }},
    { &hf_x2ap_eUTRANTraceID_TraceRecordingSessionReference,
      { "TraceRecordingSessionReference", "x2ap.eUTRANTraceID.TraceRecordingSessionReference",
        FT_UINT16, BASE_HEX, NULL, 0,
        NULL, HFILL }},
    { &hf_x2ap_interfacesToTrace_S1_MME,
      { "S1-MME", "x2ap.interfacesToTrace.S1_MME",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_interfacesToTrace), 0x80,
        NULL, HFILL }},
    { &hf_x2ap_interfacesToTrace_X2,
      { "X2", "x2ap.interfacesToTrace.X2",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_interfacesToTrace), 0x40,
        NULL, HFILL }},
    { &hf_x2ap_interfacesToTrace_Uu,
      { "Uu", "x2ap.interfacesToTrace.Uu",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_interfacesToTrace), 0x20,
        NULL, HFILL }},
    { &hf_x2ap_interfacesToTrace_F1_C,
      { "F1-C", "x2ap.interfacesToTrace.F1_C",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_interfacesToTrace), 0x10,
        NULL, HFILL }},
    { &hf_x2ap_interfacesToTrace_E1,
      { "E1", "x2ap.interfacesToTrace.E1",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_interfacesToTrace), 0x08,
        NULL, HFILL }},
    { &hf_x2ap_interfacesToTrace_Reserved,
      { "Reserved", "x2ap.interfacesToTrace.Reserved",
        FT_UINT8, BASE_HEX, NULL, 0x07,
        NULL, HFILL }},
    { &hf_x2ap_traceCollectionEntityIPAddress_IPv4,
      { "IPv4", "x2ap.traceCollectionEntityIPAddress.IPv4",
        FT_IPv4, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_x2ap_traceCollectionEntityIPAddress_IPv6,
      { "IPv6", "x2ap.traceCollectionEntityIPAddress.IPv6",
        FT_IPv6, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_x2ap_encryptionAlgorithms_EEA1,
      { "128-EEA1", "x2ap.encryptionAlgorithms.EEA1",
        FT_BOOLEAN, 16, TFS(&tfs_supported_not_supported), 0x8000,
        NULL, HFILL }},
    { &hf_x2ap_encryptionAlgorithms_EEA2,
      { "128-EEA2", "x2ap.encryptionAlgorithms.EEA2",
        FT_BOOLEAN, 16, TFS(&tfs_supported_not_supported), 0x4000,
        NULL, HFILL }},
    { &hf_x2ap_encryptionAlgorithms_EEA3,
      { "128-EEA3", "x2ap.encryptionAlgorithms.EEA3",
        FT_BOOLEAN, 16, TFS(&tfs_supported_not_supported), 0x2000,
        NULL, HFILL }},
    { &hf_x2ap_encryptionAlgorithms_Reserved,
      { "Reserved", "x2ap.encryptionAlgorithms.Reserved",
        FT_UINT16, BASE_HEX, NULL, 0x1fff,
        NULL, HFILL }},
    { &hf_x2ap_integrityProtectionAlgorithms_EIA1,
      { "128-EIA1", "x2ap.integrityProtectionAlgorithms.EIA1",
        FT_BOOLEAN, 16, TFS(&tfs_supported_not_supported), 0x8000,
        NULL, HFILL }},
    { &hf_x2ap_integrityProtectionAlgorithms_EIA2,
      { "128-EIA2", "x2ap.integrityProtectionAlgorithms.EIA2",
        FT_BOOLEAN, 16, TFS(&tfs_supported_not_supported), 0x4000,
        NULL, HFILL }},
    { &hf_x2ap_integrityProtectionAlgorithms_EIA3,
      { "128-EIA3", "x2ap.integrityProtectionAlgorithms.EIA3",
        FT_BOOLEAN, 16, TFS(&tfs_supported_not_supported), 0x2000,
        NULL, HFILL }},
    { &hf_x2ap_integrityProtectionAlgorithms_Reserved,
      { "Reserved", "x2ap.integrityProtectionAlgorithms.Reserved",
        FT_UINT16, BASE_HEX, NULL, 0x1fff,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_M1,
      { "M1", "x2ap.measurementsToActivate.M1",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x80,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_M2,
      { "M2", "x2ap.measurementsToActivate.M2",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x40,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_M3,
      { "M3", "x2ap.measurementsToActivate.M3",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x20,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_M4,
      { "M4", "x2ap.measurementsToActivate.M4",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x10,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_M5,
      { "M5", "x2ap.measurementsToActivate.M5",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x08,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_LoggingM1FromEventTriggered,
      { "LoggingOfM1FromEventTriggeredMeasurementReports", "x2ap.measurementsToActivate.LoggingM1FromEventTriggered",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x04,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_M6,
      { "M6", "x2ap.measurementsToActivate.M6",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x02,
        NULL, HFILL }},
    { &hf_x2ap_measurementsToActivate_M7,
      { "M7", "x2ap.measurementsToActivate.M7",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x01,
        NULL, HFILL }},
    { &hf_x2ap_MDT_Location_Info_GNSS,
      { "GNSS", "x2ap.MDT_Location_Info.GNSS",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x80,
        NULL, HFILL }},
    { &hf_x2ap_MDT_Location_Info_E_CID,
      { "E-CID", "x2ap.MDT_Location_Info.E_CID",
        FT_BOOLEAN, 8, TFS(&x2ap_tfs_activate_do_not_activate), 0x40,
        NULL, HFILL }},
    { &hf_x2ap_MDT_Location_Info_Reserved,
      { "Reserved", "x2ap.MDT_Location_Info.Reserved",
        FT_UINT8, BASE_HEX, NULL, 0x3f,
        NULL, HFILL }},
    { &hf_x2ap_MDT_transmissionModes_tm1,
      { "TM1", "x2ap.MDT_Location_Info.transmissionModes.tm1",
        FT_BOOLEAN, 8, TFS(&tfs_yes_no), 0x80,
        NULL, HFILL }},
    { &hf_x2ap_MDT_transmissionModes_tm2,
      { "TM2", "x2ap.MDT_Location_Info.transmissionModes.tm2",
        FT_BOOLEAN, 8, TFS(&tfs_yes_no), 0x40,
        NULL, HFILL }},
    { &hf_x2ap_MDT_transmissionModes_tm3,
      { "TM3", "x2ap.MDT_Location_Info.transmissionModes.tm3",
        FT_BOOLEAN, 8, TFS(&tfs_yes_no), 0x20,
        NULL, HFILL }},
    { &hf_x2ap_MDT_transmissionModes_tm4,
      { "TM4", "x2ap.MDT_Location_Info.transmissionModes.tm4",
        FT_BOOLEAN, 8, TFS(&tfs_yes_no), 0x10,
        NULL, HFILL }},
    { &hf_x2ap_MDT_transmissionModes_tm6,
      { "TM6", "x2ap.MDT_Location_Info.transmissionModes.tm6",
        FT_BOOLEAN, 8, TFS(&tfs_yes_no), 0x08,
        NULL, HFILL }},
    { &hf_x2ap_MDT_transmissionModes_tm8,
      { "TM8", "x2ap.MDT_Location_Info.transmissionModes.tm8",
        FT_BOOLEAN, 8, TFS(&tfs_yes_no), 0x04,
        NULL, HFILL }},
    { &hf_x2ap_MDT_transmissionModes_tm9,
      { "TM9", "x2ap.MDT_Location_Info.transmissionModes.tm9",
        FT_BOOLEAN, 8, TFS(&tfs_yes_no), 0x02,
        NULL, HFILL }},
    