/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-f1ap.c                                                              */
/* asn2wrs.py -p f1ap -c ./f1ap.cnf -s ./packet-f1ap-template -D . -O ../.. F1AP-CommonDataTypes.asn F1AP-Constants.asn F1AP-Containers.asn F1AP-IEs.asn F1AP-PDU-Contents.asn F1AP-PDU-Descriptions.asn */

/* Input file: packet-f1ap-template.c */

#line 1 "./asn1/f1ap/packet-f1ap-template.c"
/* packet-f1ap.c
 * Routines for E-UTRAN F1 Application Protocol (F1AP) packet dissection
 * Copyright 2018-2020, Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * References: 3GPP TS 38.473 V16.6.0 (2021-07)
 */

#include "config.h"

#include <epan/packet.h>

#include <epan/asn1.h>
#include <epan/sctpppids.h>
#include <epan/proto_data.h>
#include <epan/stats_tree.h>
#include <epan/exported_pdu.h>

#include "packet-per.h"
#include "packet-f1ap.h"
#include "packet-x2ap.h"
#include "packet-nr-rrc.h"
#include "packet-e212.h"
#include "packet-pdcp-nr.h"
#include "packet-lte-rrc.h"
#include "packet-nrppa.h"

#define PNAME  "F1 Application Protocol"
#define PSNAME "F1AP"
#define PFNAME "f1ap"

#define SCTP_PORT_F1AP 38472

void proto_register_f1ap(void);
void proto_reg_handoff_f1ap(void);

static gint exported_pdu_tap = -1;


/*--- Included file: packet-f1ap-val.h ---*/
#line 1 "./asn1/f1ap/packet-f1ap-val.h"
#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxNRARFCN                     3279165
#define maxnoofErrors                  256
#define maxnoofIndividualF1ConnectionsToReset 65536
#define maxCellingNBDU                 512
#define maxnoofSCells                  32
#define maxnoofSRBs                    8
#define maxnoofDRBs                    64
#define maxnoofULUPTNLInformation      2
#define maxnoofDLUPTNLInformation      2
#define maxnoofBPLMNs                  6
#define maxnoofCandidateSpCells        64
#define maxnoofPotentialSpCells        64
#define maxnoofNrCellBands             32
#define maxnoofSIBTypes                32
#define maxnoofSITypes                 32
#define maxnoofPagingCells             512
#define maxnoofTNLAssociations         32
#define maxnoofQoSFlows                64
#define maxnoofSliceItems              1024
#define maxCellineNB                   256
#define maxnoofExtendedBPLMNs          6
#define maxnoofUEIDs                   65536
#define maxnoofBPLMNsNR                12
#define maxnoofUACPLMNs                12
#define maxnoofUACperPLMN              64
#define maxnoofAdditionalSIBs          63
#define maxnoofslots                   5120
#define maxnoofTLAs                    16
#define maxnoofGTPTLAs                 16
#define maxnoofBHRLCChannels           65536
#define maxnoofRoutingEntries          1024
#define maxnoofIABSTCInfo              45
#define maxnoofSymbols                 14
#define maxnoofServingCells            32
#define maxnoofDUFSlots                320
#define maxnoofHSNASlots               5120
#define maxnoofServedCellsIAB          512
#define maxnoofChildIABNodes           1024
#define maxnoofNonUPTrafficMappings    32
#define maxnoofTLAsIAB                 1024
#define maxnoofMappingEntries          67108864
#define maxnoofDSInfo                  64
#define maxnoofEgressLinks             2
#define maxnoofULUPTNLInformationforIAB 32678
#define maxnoofUPTNLAddresses          8
#define maxnoofSLDRBs                  512
#define maxnoofQoSParaSets             8
#define maxnoofPC5QoSFlows             2048
#define maxnoofSSBAreas                64
#define maxnoofPhysicalResourceBlocks  275
#define maxnoofPhysicalResourceBlocks_1 274
#define maxnoofPRACHconfigs            16
#define maxnoofRACHReports             64
#define maxnoofRLFReports              64
#define maxnoofAdditionalPDCPDuplicationTNL 2
#define maxnoofRLCDuplicationState     3
#define maxnoofCHOcells                8
#define maxnoofMDTPLMNs                16
#define maxnoofCAGsupported            12
#define maxnoofNIDsupported            12
#define maxnoofNRSCSs                  5
#define maxnoofExtSliceItems           65535
#define maxnoofPosMeas                 16384
#define maxnoofTRPInfoTypes            64
#define maxnoofTRPs                    65535
#define maxnoofSRSTriggerStates        3
#define maxnoofSpatialRelations        64
#define maxnoBcastCell                 16384
#define maxnoofAngleInfo               65535
#define maxnooflcs_gcs_translation     3
#define maxnoofPath                    2
#define maxnoofMeasE_CID               64
#define maxnoofSSBs                    255
#define maxnoSRS_ResourceSets          16
#define maxnoSRS_ResourcePerSet        16
#define maxnoSRS_Carriers              32
#define maxnoSCSs                      5
#define maxnoSRS_Resources             64
#define maxnoSRS_PosResources          64
#define maxnoSRS_PosResourceSets       16
#define maxnoSRS_PosResourcePerSet     16
#define maxnoofPRS_ResourceSets        2
#define maxnoofPRS_ResourcesPerSet     64
#define maxNoOfMeasTRPs                64
#define maxnoofPRSresourceSets         8
#define maxnoofPRSresources            64

typedef enum _ProcedureCode_enum {
  id_Reset     =   0,
  id_F1Setup   =   1,
  id_ErrorIndication =   2,
  id_gNBDUConfigurationUpdate =   3,
  id_gNBCUConfigurationUpdate =   4,
  id_UEContextSetup =   5,
  id_UEContextRelease =   6,
  id_UEContextModification =   7,
  id_UEContextModificationRequired =   8,
  id_UEMobilityCommand =   9,
  id_UEContextReleaseRequest =  10,
  id_InitialULRRCMessageTransfer =  11,
  id_DLRRCMessageTransfer =  12,
  id_ULRRCMessageTransfer =  13,
  id_privateMessage =  14,
  id_UEInactivityNotification =  15,
  id_GNBDUResourceCoordination =  16,
  id_SystemInformationDeliveryCommand =  17,
  id_Paging    =  18,
  id_Notify    =  19,
  id_WriteReplaceWarning =  20,
  id_PWSCancel =  21,
  id_PWSRestartIndication =  22,
  id_PWSFailureIndication =  23,
  id_GNBDUStatusIndication =  24,
  id_RRCDeliveryReport =  25,
  id_F1Removal =  26,
  id_NetworkAccessRateReduction =  27,
  id_TraceStart =  28,
  id_DeactivateTrace =  29,
  id_DUCURadioInformationTransfer =  30,
  id_CUDURadioInformationTransfer =  31,
  id_BAPMappingConfiguration =  32,
  id_GNBDUResourceConfiguration =  33,
  id_IABTNLAddressAllocation =  34,
  id_IABUPConfigurationUpdate =  35,
  id_resourceStatusReportingInitiation =  36,
  id_resourceStatusReporting =  37,
  id_accessAndMobilityIndication =  38,
  id_accessSuccess =  39,
  id_cellTrafficTrace =  40,
  id_PositioningMeasurementExchange =  41,
  id_PositioningAssistanceInformationControl =  42,
  id_PositioningAssistanceInformationFeedback =  43,
  id_PositioningMeasurementReport =  44,
  id_PositioningMeasurementAbort =  45,
  id_PositioningMeasurementFailureIndication =  46,
  id_PositioningMeasurementUpdate =  47,
  id_TRPInformationExchange =  48,
  id_PositioningInformationExchange =  49,
  id_PositioningActivation =  50,
  id_PositioningDeactivation =  51,
  id_E_CIDMeasurementInitiation =  52,
  id_E_CIDMeasurementFailureIndication =  53,
  id_E_CIDMeasurementReport =  54,
  id_E_CIDMeasurementTermination =  55,
  id_PositioningInformationUpdate =  56,
  id_ReferenceTimeInformationReport =  57,
  id_ReferenceTimeInformationReportingControl =  58
} ProcedureCode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_Cause     =   0,
  id_Cells_Failed_to_be_Activated_List =   1,
  id_Cells_Failed_to_be_Activated_List_Item =   2,
  id_Cells_to_be_Activated_List =   3,
  id_Cells_to_be_Activated_List_Item =   4,
  id_Cells_to_be_Deactivated_List =   5,
  id_Cells_to_be_Deactivated_List_Item =   6,
  id_CriticalityDiagnostics =   7,
  id_CUtoDURRCInformation =   9,
  id_Unknown_10 =  10,
  id_Unknown_11 =  11,
  id_DRBs_FailedToBeModified_Item =  12,
  id_DRBs_FailedToBeModified_List =  13,
  id_DRBs_FailedToBeSetup_Item =  14,
  id_DRBs_FailedToBeSetup_List =  15,
  id_DRBs_FailedToBeSetupMod_Item =  16,
  id_DRBs_FailedToBeSetupMod_List =  17,
  id_DRBs_ModifiedConf_Item =  18,
  id_DRBs_ModifiedConf_List =  19,
  id_DRBs_Modified_Item =  20,
  id_DRBs_Modified_List =  21,
  id_DRBs_Required_ToBeModified_Item =  22,
  id_DRBs_Required_ToBeModified_List =  23,
  id_DRBs_Required_ToBeReleased_Item =  24,
  id_DRBs_Required_ToBeReleased_List =  25,
  id_DRBs_Setup_Item =  26,
  id_DRBs_Setup_List =  27,
  id_DRBs_SetupMod_Item =  28,
  id_DRBs_SetupMod_List =  29,
  id_DRBs_ToBeModified_Item =  30,
  id_DRBs_ToBeModified_List =  31,
  id_DRBs_ToBeReleased_Item =  32,
  id_DRBs_ToBeReleased_List =  33,
  id_DRBs_ToBeSetup_Item =  34,
  id_DRBs_ToBeSetup_List =  35,
  id_DRBs_ToBeSetupMod_Item =  36,
  id_DRBs_ToBeSetupMod_List =  37,
  id_DRXCycle  =  38,
  id_DUtoCURRCInformation =  39,
  id_gNB_CU_UE_F1AP_ID =  40,
  id_gNB_DU_UE_F1AP_ID =  41,
  id_gNB_DU_ID =  42,
  id_GNB_DU_Served_Cells_Item =  43,
  id_gNB_DU_Served_Cells_List =  44,
  id_gNB_DU_Name =  45,
  id_NRCellID  =  46,
  id_oldgNB_DU_UE_F1AP_ID =  47,
  id_ResetType =  48,
  id_ResourceCoordinationTransferContainer =  49,
  id_RRCContainer =  50,
  id_SCell_ToBeRemoved_Item =  51,
  id_SCell_ToBeRemoved_List =  52,
  id_SCell_ToBeSetup_Item =  53,
  id_SCell_ToBeSetup_List =  54,
  id_SCell_ToBeSetupMod_Item =  55,
  id_SCell_ToBeSetupMod_List =  56,
  id_Served_Cells_To_Add_Item =  57,
  id_Served_Cells_To_Add_List =  58,
  id_Served_Cells_To_Delete_Item =  59,
  id_Served_Cells_To_Delete_List =  60,
  id_Served_Cells_To_Modify_Item =  61,
  id_Served_Cells_To_Modify_List =  62,
  id_SpCell_ID =  63,
  id_SRBID     =  64,
  id_SRBs_FailedToBeSetup_Item =  65,
  id_SRBs_FailedToBeSetup_List =  66,
  id_SRBs_FailedToBeSetupMod_Item =  67,
  id_SRBs_FailedToBeSetupMod_List =  68,
  id_SRBs_Required_ToBeReleased_Item =  69,
  id_SRBs_Required_ToBeReleased_List =  70,
  id_SRBs_ToBeReleased_Item =  71,
  id_SRBs_ToBeReleased_List =  72,
  id_SRBs_ToBeSetup_Item =  73,
  id_SRBs_ToBeSetup_List =  74,
  id_SRBs_ToBeSetupMod_Item =  75,
  id_SRBs_ToBeSetupMod_List =  76,
  id_TimeToWait =  77,
  id_TransactionID =  78,
  id_TransmissionActionIndicator =  79,
  id_UE_associatedLogicalF1_ConnectionItem =  80,
  id_UE_associatedLogicalF1_ConnectionListResAck =  81,
  id_gNB_CU_Name =  82,
  id_SCell_FailedtoSetup_List =  83,
  id_SCell_FailedtoSetup_Item =  84,
  id_SCell_FailedtoSetupMod_List =  85,
  id_SCell_FailedtoSetupMod_Item =  86,
  id_RRCReconfigurationCompleteIndicator =  87,
  id_Cells_Status_Item =  88,
  id_Cells_Status_List =  89,
  id_Candidate_SpCell_List =  90,
  id_Candidate_SpCell_Item =  91,
  id_Potential_SpCell_List =  92,
  id_Potential_SpCell_Item =  93,
  id_FullConfiguration =  94,
  id_C_RNTI    =  95,
  id_SpCellULConfigured =  96,
  id_InactivityMonitoringRequest =  97,
  id_InactivityMonitoringResponse =  98,
  id_DRB_Activity_Item =  99,
  id_DRB_Activity_List = 100,
  id_EUTRA_NR_CellResourceCoordinationReq_Container = 101,
  id_EUTRA_NR_CellResourceCoordinationReqAck_Container = 102,
  id_Unknown_103 = 103,
  id_Unknown_104 = 104,
  id_Protected_EUTRA_Resources_List = 105,
  id_RequestType = 106,
  id_ServCellIndex = 107,
  id_RAT_FrequencyPriorityInformation = 108,
  id_ExecuteDuplication = 109,
  id_Unknown_110 = 110,
  id_NRCGI     = 111,
  id_PagingCell_Item = 112,
  id_PagingCell_List = 113,
  id_PagingDRX = 114,
  id_PagingPriority = 115,
  id_SItype_List = 116,
  id_UEIdentityIndexValue = 117,
  id_gNB_CUSystemInformation = 118,
  id_HandoverPreparationInformation = 119,
  id_GNB_CU_TNL_Association_To_Add_Item = 120,
  id_GNB_CU_TNL_Association_To_Add_List = 121,
  id_GNB_CU_TNL_Association_To_Remove_Item = 122,
  id_GNB_CU_TNL_Association_To_Remove_List = 123,
  id_GNB_CU_TNL_Association_To_Update_Item = 124,
  id_GNB_CU_TNL_Association_To_Update_List = 125,
  id_MaskedIMEISV = 126,
  id_PagingIdentity = 127,
  id_DUtoCURRCContainer = 128,
  id_Cells_to_be_Barred_List = 129,
  id_Cells_to_be_Barred_Item = 130,
  id_TAISliceSupportList = 131,
  id_GNB_CU_TNL_Association_Setup_List = 132,
  id_GNB_CU_TNL_Association_Setup_Item = 133,
  id_GNB_CU_TNL_Association_Failed_To_Setup_List = 134,
  id_GNB_CU_TNL_Association_Failed_To_Setup_Item = 135,
  id_DRB_Notify_Item = 136,
  id_DRB_Notify_List = 137,
  id_NotficationControl = 138,
  id_RANAC     = 139,
  id_PWSSystemInformation = 140,
  id_RepetitionPeriod = 141,
  id_NumberofBroadcastRequest = 142,
  id_Unknown_143 = 143,
  id_Cells_To_Be_Broadcast_List = 144,
  id_Cells_To_Be_Broadcast_Item = 145,
  id_Cells_Broadcast_Completed_List = 146,
  id_Cells_Broadcast_Completed_Item = 147,
  id_Broadcast_To_Be_Cancelled_List = 148,
  id_Broadcast_To_Be_Cancelled_Item = 149,
  id_Cells_Broadcast_Cancelled_List = 150,
  id_Cells_Broadcast_Cancelled_Item = 151,
  id_NR_CGI_List_For_Restart_List = 152,
  id_NR_CGI_List_For_Restart_Item = 153,
  id_PWS_Failed_NR_CGI_List = 154,
  id_PWS_Failed_NR_CGI_Item = 155,
  id_ConfirmedUEID = 156,
  id_Cancel_all_Warning_Messages_Indicator = 157,
  id_GNB_DU_UE_AMBR_UL = 158,
  id_DRXConfigurationIndicator = 159,
  id_RLC_Status = 160,
  id_DLPDCPSNLength = 161,
  id_GNB_DUConfigurationQuery = 162,
  id_MeasurementTimingConfiguration = 163,
  id_DRB_Information = 164,
  id_ServingPLMN = 165,
  id_Unknown_166 = 166,
  id_Unknown_167 = 167,
  id_Protected_EUTRA_Resources_Item = 168,
  id_Unknown_169 = 169,
  id_GNB_CU_RRC_Version = 170,
  id_GNB_DU_RRC_Version = 171,
  id_GNBDUOverloadInformation = 172,
  id_CellGroupConfig = 173,
  id_RLCFailureIndication = 174,
  id_UplinkTxDirectCurrentListInformation = 175,
  id_DC_Based_Duplication_Configured = 176,
  id_DC_Based_Duplication_Activation = 177,
  id_SULAccessIndication = 178,
  id_AvailablePLMNList = 179,
  id_PDUSessionID = 180,
  id_ULPDUSessionAggregateMaximumBitRate = 181,
  id_ServingCellMO = 182,
  id_QoSFlowMappingIndication = 183,
  id_RRCDeliveryStatusRequest = 184,
  id_RRCDeliveryStatus = 185,
  id_BearerTypeChange = 186,
  id_RLCMode   = 187,
  id_Duplication_Activation = 188,
  id_Dedicated_SIDelivery_NeededUE_List = 189,
  id_Dedicated_SIDelivery_NeededUE_Item = 190,
  id_DRX_LongCycleStartOffset = 191,
  id_ULPDCPSNLength = 192,
  id_SelectedBandCombinationIndex = 193,
  id_SelectedFeatureSetEntryIndex = 194,
  id_ResourceCoordinationTransferInformation = 195,
  id_ExtendedServedPLMNs_List = 196,
  id_ExtendedAvailablePLMN_List = 197,
  id_Associated_SCell_List = 198,
  id_latest_RRC_Version_Enhanced = 199,
  id_Associated_SCell_Item = 200,
  id_Cell_Direction = 201,
  id_SRBs_Setup_List = 202,
  id_SRBs_Setup_Item = 203,
  id_SRBs_SetupMod_List = 204,
  id_SRBs_SetupMod_Item = 205,
  id_SRBs_Modified_List = 206,
  id_SRBs_Modified_Item = 207,
  id_Ph_InfoSCG = 208,
  id_RequestedBandCombinationIndex = 209,
  id_RequestedFeatureSetEntryIndex = 210,
  id_RequestedP_MaxFR2 = 211,
  id_DRX_Config = 212,
  id_IgnoreResourceCoordinationContainer = 213,
  id_UEAssistanceInformation = 214,
  id_NeedforGap = 215,
  id_PagingOrigin = 216,
  id_new_gNB_CU_UE_F1AP_ID = 217,
  id_RedirectedRRCmessage = 218,
  id_new_gNB_DU_UE_F1AP_ID = 219,
  id_NotificationInformation = 220,
  id_PLMNAssistanceInfoForNetShar = 221,
  id_UEContextNotRetrievable = 222,
  id_BPLMN_ID_Info_List = 223,
  id_SelectedPLMNID = 224,
  id_UAC_Assistance_Info = 225,
  id_RANUEID   = 226,
  id_GNB_DU_TNL_Association_To_Remove_Item = 227,
  id_GNB_DU_TNL_Association_To_Remove_List = 228,
  id_TNLAssociationTransportLayerAddressgNBDU = 229,
  id_portNumber = 230,
  id_AdditionalSIBMessageList = 231,
  id_Cell_Type = 232,
  id_IgnorePRACHConfiguration = 233,
  id_CG_Config = 234,
  id_PDCCH_BlindDetectionSCG = 235,
  id_Requested_PDCCH_BlindDetectionSCG = 236,
  id_Ph_InfoMCG = 237,
  id_MeasGapSharingConfig = 238,
  id_systemInformationAreaID = 239,
  id_areaScope = 240,
  id_RRCContainer_RRCSetupComplete = 241,
  id_TraceActivation = 242,
  id_TraceID   = 243,
  id_Neighbour_Cell_Information_List = 244,
  id_Unknown_245 = 245,
  id_SymbolAllocInSlot = 246,
  id_NumDLULSymbols = 247,
  id_AdditionalRRMPriorityIndex = 248,
  id_DUCURadioInformationType = 249,
  id_CUDURadioInformationType = 250,
  id_AggressorgNBSetID = 251,
  id_VictimgNBSetID = 252,
  id_LowerLayerPresenceStatusChange = 253,
  id_Transport_Layer_Address_Info = 254,
  id_Neighbour_Cell_Information_Item = 255,
  id_IntendedTDD_DL_ULConfig = 256,
  id_QosMonitoringRequest = 257,
  id_BHChannels_ToBeSetup_List = 258,
  id_BHChannels_ToBeSetup_Item = 259,
  id_BHChannels_Setup_List = 260,
  id_BHChannels_Setup_Item = 261,
  id_BHChannels_ToBeModified_Item = 262,
  id_BHChannels_ToBeModified_List = 263,
  id_BHChannels_ToBeReleased_Item = 264,
  id_BHChannels_ToBeReleased_List = 265,
  id_BHChannels_ToBeSetupMod_Item = 266,
  id_BHChannels_ToBeSetupMod_List = 267,
  id_BHChannels_FailedToBeModified_Item = 268,
  id_BHChannels_FailedToBeModified_List = 269,
  id_BHChannels_FailedToBeSetupMod_Item = 270,
  id_BHChannels_FailedToBeSetupMod_List = 271,
  id_BHChannels_Modified_Item = 272,
  id_BHChannels_Modified_List = 273,
  id_BHChannels_SetupMod_Item = 274,
  id_BHChannels_SetupMod_List = 275,
  id_BHChannels_Required_ToBeReleased_Item = 276,
  id_BHChannels_Required_ToBeReleased_List = 277,
  id_BHChannels_FailedToBeSetup_Item = 278,
  id_BHChannels_FailedToBeSetup_List = 279,
  id_BHInfo    = 280,
  id_BAPAddress = 281,
  id_ConfiguredBAPAddress = 282,
  id_BH_Routing_Information_Added_List = 283,
  id_BH_Routing_Information_Added_List_Item = 284,
  id_BH_Routing_Information_Removed_List = 285,
  id_BH_Routing_Information_Removed_List_Item = 286,
  id_UL_BH_Non_UP_Traffic_Mapping = 287,
  id_Activated_Cells_to_be_Updated_List = 288,
  id_Child_Nodes_List = 289,
  id_IAB_Info_IAB_DU = 290,
  id_IAB_Info_IAB_donor_CU = 291,
  id_IAB_TNL_Addresses_To_Remove_List = 292,
  id_IAB_TNL_Addresses_To_Remove_Item = 293,
  id_IAB_Allocated_TNL_Address_List = 294,
  id_IAB_Allocated_TNL_Address_Item = 295,
  id_IABIPv6RequestType = 296,
  id_IABv4AddressesRequested = 297,
  id_IAB_Barred = 298,
  id_TrafficMappingInformation = 299,
  id_UL_UP_TNL_Information_to_Update_List = 300,
  id_UL_UP_TNL_Information_to_Update_List_Item = 301,
  id_UL_UP_TNL_Address_to_Update_List = 302,
  id_UL_UP_TNL_Address_to_Update_List_Item = 303,
  id_DL_UP_TNL_Address_to_Update_List = 304,
  id_DL_UP_TNL_Address_to_Update_List_Item = 305,
  id_NRV2XServicesAuthorized = 306,
  id_LTEV2XServicesAuthorized = 307,
  id_NRUESidelinkAggregateMaximumBitrate = 308,
  id_LTEUESidelinkAggregateMaximumBitrate = 309,
  id_SIB12_message = 310,
  id_SIB13_message = 311,
  id_SIB14_message = 312,
  id_SLDRBs_FailedToBeModified_Item = 313,
  id_SLDRBs_FailedToBeModified_List = 314,
  id_SLDRBs_FailedToBeSetup_Item = 315,
  id_SLDRBs_FailedToBeSetup_List = 316,
  id_SLDRBs_Modified_Item = 317,
  id_SLDRBs_Modified_List = 318,
  id_SLDRBs_Required_ToBeModified_Item = 319,
  id_SLDRBs_Required_ToBeModified_List = 320,
  id_SLDRBs_Required_ToBeReleased_Item = 321,
  id_SLDRBs_Required_ToBeReleased_List = 322,
  id_SLDRBs_Setup_Item = 323,
  id_SLDRBs_Setup_List = 324,
  id_SLDRBs_ToBeModified_Item = 325,
  id_SLDRBs_ToBeModified_List = 326,
  id_SLDRBs_ToBeReleased_Item = 327,
  id_SLDRBs_ToBeReleased_List = 328,
  id_SLDRBs_ToBeSetup_Item = 329,
  id_SLDRBs_ToBeSetup_List = 330,
  id_SLDRBs_ToBeSetupMod_Item = 331,
  id_SLDRBs_ToBeSetupMod_List = 332,
  id_SLDRBs_SetupMod_List = 333,
  id_SLDRBs_FailedToBeSetupMod_List = 334,
  id_SLDRBs_SetupMod_Item = 335,
  id_SLDRBs_FailedToBeSetupMod_Item = 336,
  id_SLDRBs_ModifiedConf_List = 337,
  id_SLDRBs_ModifiedConf_Item = 338,
  id_UEAssistanceInformationEUTRA = 339,
  id_PC5LinkAMBR = 340,
  id_SL_PHY_MAC_RLC_Config = 341,
  id_SL_ConfigDedicatedEUTRA_Info = 342,
  id_AlternativeQoSParaSetList = 343,
  id_CurrentQoSParaSetIndex = 344,
  id_gNBCUMeasurementID = 345,
  id_gNBDUMeasurementID = 346,
  id_RegistrationRequest = 347,
  id_ReportCharacteristics = 348,
  id_CellToReportList = 349,
  id_CellMeasurementResultList = 350,
  id_HardwareLoadIndicator = 351,
  id_ReportingPeriodicity = 352,
  id_TNLCapacityIndicator = 353,
  id_CarrierList = 354,
  id_ULCarrierList = 355,
  id_FrequencyShift7p5khz = 356,
  id_SSB_PositionsInBurst = 357,
  id_NRPRACHConfig = 358,
  id_RACHReportInformationList = 359,
  id_RLFReportInformationList = 360,
  id_TDD_UL_DLConfigCommonNR = 361,
  id_CNPacketDelayBudgetDownlink = 362,
  id_ExtendedPacketDelayBudget = 363,
  id_TSCTrafficCharacteristics = 364,
  id_ReportingRequestType = 365,
  id_TimeReferenceInformation = 366,
  id_Unknown_367 = 367,
  id_Unknown_368 = 368,
  id_CNPacketDelayBudgetUplink = 369,
  id_AdditionalPDCPDuplicationTNL_List = 370,
  id_RLCDuplicationInformation = 371,
  id_AdditionalDuplicationIndication = 372,
  id_ConditionalInterDUMobilityInformation = 373,
  id_ConditionalIntraDUMobilityInformation = 374,
  id_targetCellsToCancel = 375,
  id_requestedTargetCellGlobalID = 376,
  id_ManagementBasedMDTPLMNList = 377,
  id_TraceCollectionEntityIPAddress = 378,
  id_PrivacyIndicator = 379,
  id_TraceCollectionEntityURI = 380,
  id_mdtConfiguration = 381,
  id_ServingNID = 382,
  id_NPNBroadcastInformation = 383,
  id_NPNSupportInfo = 384,
  id_NID       = 385,
  id_AvailableSNPN_ID_List = 386,
  id_SIB10_message = 387,
  id_Unknown_388 = 388,
  id_DLCarrierList = 389,
  id_ExtendedTAISliceSupportList = 390,
  id_RequestedSRSTransmissionCharacteristics = 391,
  id_PosAssistance_Information = 392,
  id_PosBroadcast = 393,
  id_RoutingID = 394,
  id_PosAssistanceInformationFailureList = 395,
  id_PosMeasurementQuantities = 396,
  id_PosMeasurementResultList = 397,
  id_TRPInformationTypeListTRPReq = 398,
  id_TRPInformationTypeItem = 399,
  id_TRPInformationListTRPResp = 400,
  id_TRPInformationItem = 401,
  id_LMF_MeasurementID = 402,
  id_SRSType   = 403,
  id_ActivationTime = 404,
  id_AbortTransmission = 405,
  id_PositioningBroadcastCells = 406,
  id_SRSConfiguration = 407,
  id_PosReportCharacteristics = 408,
  id_PosMeasurementPeriodicity = 409,
  id_TRPList   = 410,
  id_RAN_MeasurementID = 411,
  id_LMF_UE_MeasurementID = 412,
  id_RAN_UE_MeasurementID = 413,
  id_E_CID_MeasurementQuantities = 414,
  id_E_CID_MeasurementQuantities_Item = 415,
  id_E_CID_MeasurementPeriodicity = 416,
  id_E_CID_MeasurementResult = 417,
  id_Cell_Portion_ID = 418,
  id_SFNInitialisationTime = 419,
  id_SystemFrameNumber = 420,
  id_SlotNumber = 421,
  id_TRP_MeasurementRequestList = 422,
  id_MeasurementBeamInfoRequest = 423,
  id_E_CID_ReportCharacteristics = 424,
  id_ConfiguredTACIndication = 425,
  id_Extended_GNB_DU_Name = 426,
  id_Extended_GNB_CU_Name = 427,
  id_F1CTransferPath = 428,
  id_SFN_Offset = 429,
  id_TransmissionStopIndicator = 430,
  id_SrsFrequency = 431,
  id_SCGIndicator = 432,
  id_EstimatedArrivalProbability = 433
} ProtocolIE_ID_enum;

/*--- End of included file: packet-f1ap-val.h ---*/
#line 45 "./asn1/f1ap/packet-f1ap-template.c"

/* Initialize the protocol and registered fields */
static int proto_f1ap = -1;

static int hf_f1ap_transportLayerAddressIPv4 = -1;
static int hf_f1ap_transportLayerAddressIPv6 = -1;
static int hf_f1ap_IABTNLAddressIPv4 = -1;
static int hf_f1ap_IABTNLAddressIPv6 = -1;
static int hf_f1ap_IABTNLAddressIPv6Prefix = -1;
static int hf_f1ap_interfacesToTrace_NG_C = -1;
static int hf_f1ap_interfacesToTrace_Xn_C = -1;
static int hf_f1ap_interfacesToTrace_Uu = -1;
static int hf_f1ap_interfacesToTrace_F1_C = -1;
static int hf_f1ap_interfacesToTrace_E1 = -1;
static int hf_f1ap_interfacesToTrace_Reserved = -1;
static int hf_f1ap_MeasurementsToActivate_Reserved1 = -1;
static int hf_f1ap_MeasurementsToActivate_M2 = -1;
static int hf_f1ap_MeasurementsToActivate_Reserved2 = -1;
static int hf_f1ap_MeasurementsToActivate_M5 = -1;
static int hf_f1ap_MeasurementsToActivate_Reserved3 = -1;
static int hf_f1ap_MeasurementsToActivate_M6 = -1;
static int hf_f1ap_MeasurementsToActivate_M7 = -1;
static int hf_f1ap_ReportCharacteristics_PRBPeriodic = -1;
static int hf_f1ap_ReportCharacteristics_TNLCapacityIndPeriodic = -1;
static int hf_f1ap_ReportCharacteristics_CompositeAvailableCapacityPeriodic = -1;
static int hf_f1ap_ReportCharacteristics_HWLoadIndPeriodic = -1;
static int hf_f1ap_ReportCharacteristics_NumberOfActiveUEs = -1;
static int hf_f1ap_ReportCharacteristics_Reserved = -1;

/*--- Included file: packet-f1ap-hf.c ---*/
#line 1 "./asn1/f1ap/packet-f1ap-hf.c"
static int hf_f1ap_AbortTransmission_PDU = -1;    /* AbortTransmission */
static int hf_f1ap_Activated_Cells_to_be_Updated_List_PDU = -1;  /* Activated_Cells_to_be_Updated_List */
static int hf_f1ap_AdditionalDuplicationIndication_PDU = -1;  /* AdditionalDuplicationIndication */
static int hf_f1ap_AdditionalPDCPDuplicationTNL_List_PDU = -1;  /* AdditionalPDCPDuplicationTNL_List */
static int hf_f1ap_AdditionalSIBMessageList_PDU = -1;  /* AdditionalSIBMessageList */
static int hf_f1ap_AdditionalRRMPriorityIndex_PDU = -1;  /* AdditionalRRMPriorityIndex */
static int hf_f1ap_AggressorgNBSetID_PDU = -1;    /* AggressorgNBSetID */
static int hf_f1ap_AlternativeQoSParaSetList_PDU = -1;  /* AlternativeQoSParaSetList */
static int hf_f1ap_Associated_SCell_Item_PDU = -1;  /* Associated_SCell_Item */
static int hf_f1ap_AvailablePLMNList_PDU = -1;    /* AvailablePLMNList */
static int hf_f1ap_AvailableSNPN_ID_List_PDU = -1;  /* AvailableSNPN_ID_List */
static int hf_f1ap_AreaScope_PDU = -1;            /* AreaScope */
static int hf_f1ap_BAPAddress_PDU = -1;           /* BAPAddress */
static int hf_f1ap_BitRate_PDU = -1;              /* BitRate */
static int hf_f1ap_BearerTypeChange_PDU = -1;     /* BearerTypeChange */
static int hf_f1ap_BHChannels_FailedToBeModified_Item_PDU = -1;  /* BHChannels_FailedToBeModified_Item */
static int hf_f1ap_BHChannels_FailedToBeSetup_Item_PDU = -1;  /* BHChannels_FailedToBeSetup_Item */
static int hf_f1ap_BHChannels_FailedToBeSetupMod_Item_PDU = -1;  /* BHChannels_FailedToBeSetupMod_Item */
static int hf_f1ap_BHChannels_Modified_Item_PDU = -1;  /* BHChannels_Modified_Item */
static int hf_f1ap_BHChannels_Required_ToBeReleased_Item_PDU = -1;  /* BHChannels_Required_ToBeReleased_Item */
static int hf_f1ap_BHChannels_Setup_Item_PDU = -1;  /* BHChannels_Setup_Item */
static int hf_f1ap_BHChannels_SetupMod_Item_PDU = -1;  /* BHChannels_SetupMod_Item */
static int hf_f1ap_BHChannels_ToBeModified_Item_PDU = -1;  /* BHChannels_ToBeModified_Item */
static int hf_f1ap_BHChannels_ToBeReleased_Item_PDU = -1;  /* BHChannels_ToBeReleased_Item */
static int hf_f1ap_BHChannels_ToBeSetup_Item_PDU = -1;  /* BHChannels_ToBeSetup_Item */
static int hf_f1ap_BHChannels_ToBeSetupMod_Item_PDU = -1;  /* BHChannels_ToBeSetupMod_Item */
static int hf_f1ap_BHInfo_PDU = -1;               /* BHInfo */
static int hf_f1ap_BH_Routing_Information_Added_List_Item_PDU = -1;  /* BH_Routing_Information_Added_List_Item */
static int hf_f1ap_BH_Routing_Information_Removed_List_Item_PDU = -1;  /* BH_Routing_Information_Removed_List_Item */
static int hf_f1ap_BPLMN_ID_Info_List_PDU = -1;   /* BPLMN_ID_Info_List */
static int hf_f1ap_Cancel_all_Warning_Messages_Indicator_PDU = -1;  /* Cancel_all_Warning_Messages_Indicator */
static int hf_f1ap_Candidate_SpCell_Item_PDU = -1;  /* Candidate_SpCell_Item */
static int hf_f1ap_Cause_PDU = -1;                /* Cause */
static int hf_f1ap_CellGroupConfig_PDU = -1;      /* CellGroupConfig */
static int hf_f1ap_Cell_Direction_PDU = -1;       /* Cell_Direction */
static int hf_f1ap_CellMeasurementResultList_PDU = -1;  /* CellMeasurementResultList */
static int hf_f1ap_Cell_Portion_ID_PDU = -1;      /* Cell_Portion_ID */
static int hf_f1ap_Cells_Failed_to_be_Activated_List_Item_PDU = -1;  /* Cells_Failed_to_be_Activated_List_Item */
static int hf_f1ap_Cells_Status_Item_PDU = -1;    /* Cells_Status_Item */
static int hf_f1ap_Cells_To_Be_Broadcast_Item_PDU = -1;  /* Cells_To_Be_Broadcast_Item */
static int hf_f1ap_Cells_Broadcast_Completed_Item_PDU = -1;  /* Cells_Broadcast_Completed_Item */
static int hf_f1ap_Broadcast_To_Be_Cancelled_Item_PDU = -1;  /* Broadcast_To_Be_Cancelled_Item */
static int hf_f1ap_Cells_Broadcast_Cancelled_Item_PDU = -1;  /* Cells_Broadcast_Cancelled_Item */
static int hf_f1ap_Cells_to_be_Activated_List_Item_PDU = -1;  /* Cells_to_be_Activated_List_Item */
static int hf_f1ap_Cells_to_be_Deactivated_List_Item_PDU = -1;  /* Cells_to_be_Deactivated_List_Item */
static int hf_f1ap_Cells_to_be_Barred_Item_PDU = -1;  /* Cells_to_be_Barred_Item */
static int hf_f1ap_CellToReportList_PDU = -1;     /* CellToReportList */
static int hf_f1ap_CellType_PDU = -1;             /* CellType */
static int hf_f1ap_CellULConfigured_PDU = -1;     /* CellULConfigured */
static int hf_f1ap_Child_Nodes_List_PDU = -1;     /* Child_Nodes_List */
static int hf_f1ap_CHO_Probability_PDU = -1;      /* CHO_Probability */
static int hf_f1ap_ConditionalInterDUMobilityInformation_PDU = -1;  /* ConditionalInterDUMobilityInformation */
static int hf_f1ap_ConditionalIntraDUMobilityInformation_PDU = -1;  /* ConditionalIntraDUMobilityInformation */
static int hf_f1ap_ConfiguredTACIndication_PDU = -1;  /* ConfiguredTACIndication */
static int hf_f1ap_CP_TransportLayerAddress_PDU = -1;  /* CP_TransportLayerAddress */
static int hf_f1ap_CriticalityDiagnostics_PDU = -1;  /* CriticalityDiagnostics */
static int hf_f1ap_C_RNTI_PDU = -1;               /* C_RNTI */
static int hf_f1ap_CUDURadioInformationType_PDU = -1;  /* CUDURadioInformationType */
static int hf_f1ap_CUtoDURRCInformation_PDU = -1;  /* CUtoDURRCInformation */
static int hf_f1ap_DCBasedDuplicationConfigured_PDU = -1;  /* DCBasedDuplicationConfigured */
static int hf_f1ap_Dedicated_SIDelivery_NeededUE_Item_PDU = -1;  /* Dedicated_SIDelivery_NeededUE_Item */
static int hf_f1ap_DL_UP_TNL_Address_to_Update_List_Item_PDU = -1;  /* DL_UP_TNL_Address_to_Update_List_Item */
static int hf_f1ap_DRB_Activity_Item_PDU = -1;    /* DRB_Activity_Item */
static int hf_f1ap_DRBs_FailedToBeModified_Item_PDU = -1;  /* DRBs_FailedToBeModified_Item */
static int hf_f1ap_DRBs_FailedToBeSetup_Item_PDU = -1;  /* DRBs_FailedToBeSetup_Item */
static int hf_f1ap_DRBs_FailedToBeSetupMod_Item_PDU = -1;  /* DRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_DRB_Information_PDU = -1;      /* DRB_Information */
static int hf_f1ap_DRBs_Modified_Item_PDU = -1;   /* DRBs_Modified_Item */
static int hf_f1ap_DRBs_ModifiedConf_Item_PDU = -1;  /* DRBs_ModifiedConf_Item */
static int hf_f1ap_DRB_Notify_Item_PDU = -1;      /* DRB_Notify_Item */
static int hf_f1ap_DRBs_Required_ToBeModified_Item_PDU = -1;  /* DRBs_Required_ToBeModified_Item */
static int hf_f1ap_DRBs_Required_ToBeReleased_Item_PDU = -1;  /* DRBs_Required_ToBeReleased_Item */
static int hf_f1ap_DRBs_Setup_Item_PDU = -1;      /* DRBs_Setup_Item */
static int hf_f1ap_DRBs_SetupMod_Item_PDU = -1;   /* DRBs_SetupMod_Item */
static int hf_f1ap_DRBs_ToBeModified_Item_PDU = -1;  /* DRBs_ToBeModified_Item */
static int hf_f1ap_DRBs_ToBeReleased_Item_PDU = -1;  /* DRBs_ToBeReleased_Item */
static int hf_f1ap_DRBs_ToBeSetup_Item_PDU = -1;  /* DRBs_ToBeSetup_Item */
static int hf_f1ap_DRBs_ToBeSetupMod_Item_PDU = -1;  /* DRBs_ToBeSetupMod_Item */
static int hf_f1ap_DRXCycle_PDU = -1;             /* DRXCycle */
static int hf_f1ap_DRX_Config_PDU = -1;           /* DRX_Config */
static int hf_f1ap_DRXConfigurationIndicator_PDU = -1;  /* DRXConfigurationIndicator */
static int hf_f1ap_DRX_LongCycleStartOffset_PDU = -1;  /* DRX_LongCycleStartOffset */
static int hf_f1ap_DUtoCURRCContainer_PDU = -1;   /* DUtoCURRCContainer */
static int hf_f1ap_DUCURadioInformationType_PDU = -1;  /* DUCURadioInformationType */
static int hf_f1ap_DUtoCURRCInformation_PDU = -1;  /* DUtoCURRCInformation */
static int hf_f1ap_DuplicationActivation_PDU = -1;  /* DuplicationActivation */
static int hf_f1ap_E_CID_MeasurementQuantities_PDU = -1;  /* E_CID_MeasurementQuantities */
static int hf_f1ap_E_CID_MeasurementQuantities_Item_PDU = -1;  /* E_CID_MeasurementQuantities_Item */
static int hf_f1ap_E_CID_MeasurementResult_PDU = -1;  /* E_CID_MeasurementResult */
static int hf_f1ap_E_CID_ReportCharacteristics_PDU = -1;  /* E_CID_ReportCharacteristics */
static int hf_f1ap_ExtendedAvailablePLMN_List_PDU = -1;  /* ExtendedAvailablePLMN_List */
static int hf_f1ap_ExtendedServedPLMNs_List_PDU = -1;  /* ExtendedServedPLMNs_List */
static int hf_f1ap_ExtendedSliceSupportList_PDU = -1;  /* ExtendedSliceSupportList */
static int hf_f1ap_ExecuteDuplication_PDU = -1;   /* ExecuteDuplication */
static int hf_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container_PDU = -1;  /* EUTRA_NR_CellResourceCoordinationReq_Container */
static int hf_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container_PDU = -1;  /* EUTRA_NR_CellResourceCoordinationReqAck_Container */
static int hf_f1ap_ExtendedPacketDelayBudget_PDU = -1;  /* ExtendedPacketDelayBudget */
static int hf_f1ap_F1CTransferPath_PDU = -1;      /* F1CTransferPath */
static int hf_f1ap_FrequencyShift7p5khz_PDU = -1;  /* FrequencyShift7p5khz */
static int hf_f1ap_FullConfiguration_PDU = -1;    /* FullConfiguration */
static int hf_f1ap_CG_Config_PDU = -1;            /* CG_Config */
static int hf_f1ap_GNBCUMeasurementID_PDU = -1;   /* GNBCUMeasurementID */
static int hf_f1ap_GNBDUMeasurementID_PDU = -1;   /* GNBDUMeasurementID */
static int hf_f1ap_GNB_CUSystemInformation_PDU = -1;  /* GNB_CUSystemInformation */
static int hf_f1ap_GNB_CU_TNL_Association_Setup_Item_PDU = -1;  /* GNB_CU_TNL_Association_Setup_Item */
static int hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item_PDU = -1;  /* GNB_CU_TNL_Association_Failed_To_Setup_Item */
static int hf_f1ap_GNB_CU_TNL_Association_To_Add_Item_PDU = -1;  /* GNB_CU_TNL_Association_To_Add_Item */
static int hf_f1ap_GNB_CU_TNL_Association_To_Remove_Item_PDU = -1;  /* GNB_CU_TNL_Association_To_Remove_Item */
static int hf_f1ap_GNB_CU_TNL_Association_To_Update_Item_PDU = -1;  /* GNB_CU_TNL_Association_To_Update_Item */
static int hf_f1ap_GNB_CU_UE_F1AP_ID_PDU = -1;    /* GNB_CU_UE_F1AP_ID */
static int hf_f1ap_GNB_DU_UE_F1AP_ID_PDU = -1;    /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_GNB_DU_ID_PDU = -1;            /* GNB_DU_ID */
static int hf_f1ap_GNB_CU_Name_PDU = -1;          /* GNB_CU_Name */
static int hf_f1ap_GNB_DU_Name_PDU = -1;          /* GNB_DU_Name */
static int hf_f1ap_Extended_GNB_CU_Name_PDU = -1;  /* Extended_GNB_CU_Name */
static int hf_f1ap_Extended_GNB_DU_Name_PDU = -1;  /* Extended_GNB_DU_Name */
static int hf_f1ap_GNB_DU_Served_Cells_Item_PDU = -1;  /* GNB_DU_Served_Cells_Item */
static int hf_f1ap_GNB_DUConfigurationQuery_PDU = -1;  /* GNB_DUConfigurationQuery */
static int hf_f1ap_GNBDUOverloadInformation_PDU = -1;  /* GNBDUOverloadInformation */
static int hf_f1ap_GNB_DU_TNL_Association_To_Remove_Item_PDU = -1;  /* GNB_DU_TNL_Association_To_Remove_Item */
static int hf_f1ap_HandoverPreparationInformation_PDU = -1;  /* HandoverPreparationInformation */
static int hf_f1ap_HardwareLoadIndicator_PDU = -1;  /* HardwareLoadIndicator */
static int hf_f1ap_IAB_Barred_PDU = -1;           /* IAB_Barred */
static int hf_f1ap_IAB_Info_IAB_donor_CU_PDU = -1;  /* IAB_Info_IAB_donor_CU */
static int hf_f1ap_IAB_Info_IAB_DU_PDU = -1;      /* IAB_Info_IAB_DU */
static int hf_f1ap_IAB_Allocated_TNL_Address_Item_PDU = -1;  /* IAB_Allocated_TNL_Address_Item */
static int hf_f1ap_IABIPv6RequestType_PDU = -1;   /* IABIPv6RequestType */
static int hf_f1ap_IAB_TNL_Addresses_To_Remove_Item_PDU = -1;  /* IAB_TNL_Addresses_To_Remove_Item */
static int hf_f1ap_IABv4AddressesRequested_PDU = -1;  /* IABv4AddressesRequested */
static int hf_f1ap_IgnorePRACHConfiguration_PDU = -1;  /* IgnorePRACHConfiguration */
static int hf_f1ap_IgnoreResourceCoordinationContainer_PDU = -1;  /* IgnoreResourceCoordinationContainer */
static int hf_f1ap_InactivityMonitoringRequest_PDU = -1;  /* InactivityMonitoringRequest */
static int hf_f1ap_InactivityMonitoringResponse_PDU = -1;  /* InactivityMonitoringResponse */
static int hf_f1ap_IntendedTDD_DL_ULConfig_PDU = -1;  /* IntendedTDD_DL_ULConfig */
static int hf_f1ap_LMF_MeasurementID_PDU = -1;    /* LMF_MeasurementID */
static int hf_f1ap_LMF_UE_MeasurementID_PDU = -1;  /* LMF_UE_MeasurementID */
static int hf_f1ap_LowerLayerPresenceStatusChange_PDU = -1;  /* LowerLayerPresenceStatusChange */
static int hf_f1ap_LTEUESidelinkAggregateMaximumBitrate_PDU = -1;  /* LTEUESidelinkAggregateMaximumBitrate */
static int hf_f1ap_LTEV2XServicesAuthorized_PDU = -1;  /* LTEV2XServicesAuthorized */
static int hf_f1ap_MaskedIMEISV_PDU = -1;         /* MaskedIMEISV */
static int hf_f1ap_MeasGapSharingConfig_PDU = -1;  /* MeasGapSharingConfig */
static int hf_f1ap_MeasurementBeamInfoRequest_PDU = -1;  /* MeasurementBeamInfoRequest */
static int hf_f1ap_MeasurementTimingConfiguration_PDU = -1;  /* MeasurementTimingConfiguration */
static int hf_f1ap_MDTConfiguration_PDU = -1;     /* MDTConfiguration */
static int hf_f1ap_MDTPLMNList_PDU = -1;          /* MDTPLMNList */
static int hf_f1ap_NeedforGap_PDU = -1;           /* NeedforGap */
static int hf_f1ap_Neighbour_Cell_Information_Item_PDU = -1;  /* Neighbour_Cell_Information_Item */
static int hf_f1ap_NID_PDU = -1;                  /* NID */
static int hf_f1ap_NR_CGI_List_For_Restart_Item_PDU = -1;  /* NR_CGI_List_For_Restart_Item */
static int hf_f1ap_NotificationInformation_PDU = -1;  /* NotificationInformation */
static int hf_f1ap_NPNBroadcastInformation_PDU = -1;  /* NPNBroadcastInformation */
static int hf_f1ap_NPNSupportInfo_PDU = -1;       /* NPNSupportInfo */
static int hf_f1ap_NRCarrierList_PDU = -1;        /* NRCarrierList */
static int hf_f1ap_NRCGI_PDU = -1;                /* NRCGI */
static int hf_f1ap_f1ap_NRPRACHConfig_PDU = -1;   /* NRPRACHConfig */
static int hf_f1ap_NumberofBroadcastRequest_PDU = -1;  /* NumberofBroadcastRequest */
static int hf_f1ap_NRV2XServicesAuthorized_PDU = -1;  /* NRV2XServicesAuthorized */
static int hf_f1ap_NRUESidelinkAggregateMaximumBitrate_PDU = -1;  /* NRUESidelinkAggregateMaximumBitrate */
static int hf_f1ap_PagingCell_Item_PDU = -1;      /* PagingCell_Item */
static int hf_f1ap_PagingDRX_PDU = -1;            /* PagingDRX */
static int hf_f1ap_PagingIdentity_PDU = -1;       /* PagingIdentity */
static int hf_f1ap_PagingOrigin_PDU = -1;         /* PagingOrigin */
static int hf_f1ap_PagingPriority_PDU = -1;       /* PagingPriority */
static int hf_f1ap_PDCCH_BlindDetectionSCG_PDU = -1;  /* PDCCH_BlindDetectionSCG */
static int hf_f1ap_PDCPSNLength_PDU = -1;         /* PDCPSNLength */
static int hf_f1ap_PDUSessionID_PDU = -1;         /* PDUSessionID */
static int hf_f1ap_Ph_InfoMCG_PDU = -1;           /* Ph_InfoMCG */
static int hf_f1ap_Ph_InfoSCG_PDU = -1;           /* Ph_InfoSCG */
static int hf_f1ap_PLMN_Identity_PDU = -1;        /* PLMN_Identity */
static int hf_f1ap_PortNumber_PDU = -1;           /* PortNumber */
static int hf_f1ap_PosAssistance_Information_PDU = -1;  /* PosAssistance_Information */
static int hf_f1ap_PosAssistanceInformationFailureList_PDU = -1;  /* PosAssistanceInformationFailureList */
static int hf_f1ap_PosBroadcast_PDU = -1;         /* PosBroadcast */
static int hf_f1ap_PositioningBroadcastCells_PDU = -1;  /* PositioningBroadcastCells */
static int hf_f1ap_MeasurementPeriodicity_PDU = -1;  /* MeasurementPeriodicity */
static int hf_f1ap_PosMeasurementQuantities_PDU = -1;  /* PosMeasurementQuantities */
static int hf_f1ap_PosMeasurementResultList_PDU = -1;  /* PosMeasurementResultList */
static int hf_f1ap_PosReportCharacteristics_PDU = -1;  /* PosReportCharacteristics */
static int hf_f1ap_Protected_EUTRA_Resources_Item_PDU = -1;  /* Protected_EUTRA_Resources_Item */
static int hf_f1ap_Potential_SpCell_Item_PDU = -1;  /* Potential_SpCell_Item */
static int hf_f1ap_PWS_Failed_NR_CGI_Item_PDU = -1;  /* PWS_Failed_NR_CGI_Item */
static int hf_f1ap_PWSSystemInformation_PDU = -1;  /* PWSSystemInformation */
static int hf_f1ap_PrivacyIndicator_PDU = -1;     /* PrivacyIndicator */
static int hf_f1ap_QoSFlowMappingIndication_PDU = -1;  /* QoSFlowMappingIndication */
static int hf_f1ap_QosMonitoringRequest_PDU = -1;  /* QosMonitoringRequest */
static int hf_f1ap_QoSParaSetNotifyIndex_PDU = -1;  /* QoSParaSetNotifyIndex */
static int hf_f1ap_RACHReportInformationList_PDU = -1;  /* RACHReportInformationList */
static int hf_f1ap_RANAC_PDU = -1;                /* RANAC */
static int hf_f1ap_RAN_MeasurementID_PDU = -1;    /* RAN_MeasurementID */
static int hf_f1ap_RAN_UE_MeasurementID_PDU = -1;  /* RAN_UE_MeasurementID */
static int hf_f1ap_RANUEID_PDU = -1;              /* RANUEID */
static int hf_f1ap_RAT_FrequencyPriorityInformation_PDU = -1;  /* RAT_FrequencyPriorityInformation */
static int hf_f1ap_RegistrationRequest_PDU = -1;  /* RegistrationRequest */
static int hf_f1ap_ReportCharacteristics_PDU = -1;  /* ReportCharacteristics */
static int hf_f1ap_ReportingPeriodicity_PDU = -1;  /* ReportingPeriodicity */
static int hf_f1ap_RequestedBandCombinationIndex_PDU = -1;  /* RequestedBandCombinationIndex */
static int hf_f1ap_RequestedFeatureSetEntryIndex_PDU = -1;  /* RequestedFeatureSetEntryIndex */
static int hf_f1ap_RequestedP_MaxFR2_PDU = -1;    /* RequestedP_MaxFR2 */
static int hf_f1ap_Requested_PDCCH_BlindDetectionSCG_PDU = -1;  /* Requested_PDCCH_BlindDetectionSCG */
static int hf_f1ap_RequestedSRSTransmissionCharacteristics_PDU = -1;  /* RequestedSRSTransmissionCharacteristics */
static int hf_f1ap_RequestType_PDU = -1;          /* RequestType */
static int hf_f1ap_ResourceCoordinationTransferInformation_PDU = -1;  /* ResourceCoordinationTransferInformation */
static int hf_f1ap_ResourceCoordinationTransferContainer_PDU = -1;  /* ResourceCoordinationTransferContainer */
static int hf_f1ap_RepetitionPeriod_PDU = -1;     /* RepetitionPeriod */
static int hf_f1ap_ReportingRequestType_PDU = -1;  /* ReportingRequestType */
static int hf_f1ap_RLCDuplicationInformation_PDU = -1;  /* RLCDuplicationInformation */
static int hf_f1ap_RLCFailureIndication_PDU = -1;  /* RLCFailureIndication */
static int hf_f1ap_RLCMode_PDU = -1;              /* RLCMode */
static int hf_f1ap_RLC_Status_PDU = -1;           /* RLC_Status */
static int hf_f1ap_RLFReportInformationList_PDU = -1;  /* RLFReportInformationList */
static int hf_f1ap_RRCContainer_PDU = -1;         /* RRCContainer */
static int hf_f1ap_RRCContainer_RRCSetupComplete_PDU = -1;  /* RRCContainer_RRCSetupComplete */
static int hf_f1ap_RRCDeliveryStatus_PDU = -1;    /* RRCDeliveryStatus */
static int hf_f1ap_RRCDeliveryStatusRequest_PDU = -1;  /* RRCDeliveryStatusRequest */
static int hf_f1ap_RRCReconfigurationCompleteIndicator_PDU = -1;  /* RRCReconfigurationCompleteIndicator */
static int hf_f1ap_RRC_Version_PDU = -1;          /* RRC_Version */
static int hf_f1ap_Latest_RRC_Version_Enhanced_PDU = -1;  /* Latest_RRC_Version_Enhanced */
static int hf_f1ap_RoutingID_PDU = -1;            /* RoutingID */
static int hf_f1ap_SCell_FailedtoSetup_Item_PDU = -1;  /* SCell_FailedtoSetup_Item */
static int hf_f1ap_SCell_FailedtoSetupMod_Item_PDU = -1;  /* SCell_FailedtoSetupMod_Item */
static int hf_f1ap_SCell_ToBeRemoved_Item_PDU = -1;  /* SCell_ToBeRemoved_Item */
static int hf_f1ap_SCell_ToBeSetup_Item_PDU = -1;  /* SCell_ToBeSetup_Item */
static int hf_f1ap_SCell_ToBeSetupMod_Item_PDU = -1;  /* SCell_ToBeSetupMod_Item */
static int hf_f1ap_SCGIndicator_PDU = -1;         /* SCGIndicator */
static int hf_f1ap_SelectedBandCombinationIndex_PDU = -1;  /* SelectedBandCombinationIndex */
static int hf_f1ap_SelectedFeatureSetEntryIndex_PDU = -1;  /* SelectedFeatureSetEntryIndex */
static int hf_f1ap_ServCellIndex_PDU = -1;        /* ServCellIndex */
static int hf_f1ap_ServingCellMO_PDU = -1;        /* ServingCellMO */
static int hf_f1ap_SFN_Offset_PDU = -1;           /* SFN_Offset */
static int hf_f1ap_Served_Cells_To_Add_Item_PDU = -1;  /* Served_Cells_To_Add_Item */
static int hf_f1ap_Served_Cells_To_Delete_Item_PDU = -1;  /* Served_Cells_To_Delete_Item */
static int hf_f1ap_Served_Cells_To_Modify_Item_PDU = -1;  /* Served_Cells_To_Modify_Item */
static int hf_f1ap_RelativeTime1900_PDU = -1;     /* RelativeTime1900 */
static int hf_f1ap_SIB10_message_PDU = -1;        /* SIB10_message */
static int hf_f1ap_SIB12_message_PDU = -1;        /* SIB12_message */
static int hf_f1ap_SIB13_message_PDU = -1;        /* SIB13_message */
static int hf_f1ap_SIB14_message_PDU = -1;        /* SIB14_message */
static int hf_f1ap_SItype_List_PDU = -1;          /* SItype_List */
static int hf_f1ap_SLDRBs_FailedToBeModified_Item_PDU = -1;  /* SLDRBs_FailedToBeModified_Item */
static int hf_f1ap_SLDRBs_FailedToBeSetup_Item_PDU = -1;  /* SLDRBs_FailedToBeSetup_Item */
static int hf_f1ap_SLDRBs_FailedToBeSetupMod_Item_PDU = -1;  /* SLDRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_SLDRBs_Modified_Item_PDU = -1;  /* SLDRBs_Modified_Item */
static int hf_f1ap_SLDRBs_ModifiedConf_Item_PDU = -1;  /* SLDRBs_ModifiedConf_Item */
static int hf_f1ap_SLDRBs_Required_ToBeModified_Item_PDU = -1;  /* SLDRBs_Required_ToBeModified_Item */
static int hf_f1ap_SLDRBs_Required_ToBeReleased_Item_PDU = -1;  /* SLDRBs_Required_ToBeReleased_Item */
static int hf_f1ap_SLDRBs_Setup_Item_PDU = -1;    /* SLDRBs_Setup_Item */
static int hf_f1ap_SLDRBs_SetupMod_Item_PDU = -1;  /* SLDRBs_SetupMod_Item */
static int hf_f1ap_SLDRBs_ToBeModified_Item_PDU = -1;  /* SLDRBs_ToBeModified_Item */
static int hf_f1ap_SLDRBs_ToBeReleased_Item_PDU = -1;  /* SLDRBs_ToBeReleased_Item */
static int hf_f1ap_SLDRBs_ToBeSetup_Item_PDU = -1;  /* SLDRBs_ToBeSetup_Item */
static int hf_f1ap_SLDRBs_ToBeSetupMod_Item_PDU = -1;  /* SLDRBs_ToBeSetupMod_Item */
static int hf_f1ap_SL_PHY_MAC_RLC_Config_PDU = -1;  /* SL_PHY_MAC_RLC_Config */
static int hf_f1ap_SL_ConfigDedicatedEUTRA_Info_PDU = -1;  /* SL_ConfigDedicatedEUTRA_Info */
static int hf_f1ap_SliceSupportList_PDU = -1;     /* SliceSupportList */
static int hf_f1ap_SlotNumber_PDU = -1;           /* SlotNumber */
static int hf_f1ap_SRBID_PDU = -1;                /* SRBID */
static int hf_f1ap_SRBs_FailedToBeSetup_Item_PDU = -1;  /* SRBs_FailedToBeSetup_Item */
static int hf_f1ap_SRBs_FailedToBeSetupMod_Item_PDU = -1;  /* SRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_SRBs_Modified_Item_PDU = -1;   /* SRBs_Modified_Item */
static int hf_f1ap_SRBs_Required_ToBeReleased_Item_PDU = -1;  /* SRBs_Required_ToBeReleased_Item */
static int hf_f1ap_SRBs_Setup_Item_PDU = -1;      /* SRBs_Setup_Item */
static int hf_f1ap_SRBs_SetupMod_Item_PDU = -1;   /* SRBs_SetupMod_Item */
static int hf_f1ap_SRBs_ToBeReleased_Item_PDU = -1;  /* SRBs_ToBeReleased_Item */
static int hf_f1ap_SRBs_ToBeSetup_Item_PDU = -1;  /* SRBs_ToBeSetup_Item */
static int hf_f1ap_SRBs_ToBeSetupMod_Item_PDU = -1;  /* SRBs_ToBeSetupMod_Item */
static int hf_f1ap_SRSConfiguration_PDU = -1;     /* SRSConfiguration */
static int hf_f1ap_SrsFrequency_PDU = -1;         /* SrsFrequency */
static int hf_f1ap_SSB_PositionsInBurst_PDU = -1;  /* SSB_PositionsInBurst */
static int hf_f1ap_SULAccessIndication_PDU = -1;  /* SULAccessIndication */
static int hf_f1ap_SystemFrameNumber_PDU = -1;    /* SystemFrameNumber */
static int hf_f1ap_SystemInformationAreaID_PDU = -1;  /* SystemInformationAreaID */
static int hf_f1ap_TargetCellList_PDU = -1;       /* TargetCellList */
static int hf_f1ap_TDD_UL_DLConfigCommonNR_PDU = -1;  /* TDD_UL_DLConfigCommonNR */
static int hf_f1ap_TimeReferenceInformation_PDU = -1;  /* TimeReferenceInformation */
static int hf_f1ap_TimeToWait_PDU = -1;           /* TimeToWait */
static int hf_f1ap_TNLCapacityIndicator_PDU = -1;  /* TNLCapacityIndicator */
static int hf_f1ap_TraceActivation_PDU = -1;      /* TraceActivation */
static int hf_f1ap_TraceID_PDU = -1;              /* TraceID */
static int hf_f1ap_TrafficMappingInfo_PDU = -1;   /* TrafficMappingInfo */
static int hf_f1ap_TransportLayerAddress_PDU = -1;  /* TransportLayerAddress */
static int hf_f1ap_TransactionID_PDU = -1;        /* TransactionID */
static int hf_f1ap_TransmissionStopIndicator_PDU = -1;  /* TransmissionStopIndicator */
static int hf_f1ap_TransmissionActionIndicator_PDU = -1;  /* TransmissionActionIndicator */
static int hf_f1ap_TRPInformationItem_PDU = -1;   /* TRPInformationItem */
static int hf_f1ap_TRPInformationTypeItem_PDU = -1;  /* TRPInformationTypeItem */
static int hf_f1ap_TRPList_PDU = -1;              /* TRPList */
static int hf_f1ap_TRP_MeasurementRequestList_PDU = -1;  /* TRP_MeasurementRequestList */
static int hf_f1ap_Transport_Layer_Address_Info_PDU = -1;  /* Transport_Layer_Address_Info */
static int hf_f1ap_TSCTrafficCharacteristics_PDU = -1;  /* TSCTrafficCharacteristics */
static int hf_f1ap_UAC_Assistance_Info_PDU = -1;  /* UAC_Assistance_Info */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionItem_PDU = -1;  /* UE_associatedLogicalF1_ConnectionItem */
static int hf_f1ap_UEAssistanceInformation_PDU = -1;  /* UEAssistanceInformation */
static int hf_f1ap_UEAssistanceInformationEUTRA_PDU = -1;  /* UEAssistanceInformationEUTRA */
static int hf_f1ap_UEContextNotRetrievable_PDU = -1;  /* UEContextNotRetrievable */
static int hf_f1ap_UEIdentityIndexValue_PDU = -1;  /* UEIdentityIndexValue */
static int hf_f1ap_UL_BH_Non_UP_Traffic_Mapping_PDU = -1;  /* UL_BH_Non_UP_Traffic_Mapping */
static int hf_f1ap_UL_UP_TNL_Information_to_Update_List_Item_PDU = -1;  /* UL_UP_TNL_Information_to_Update_List_Item */
static int hf_f1ap_UL_UP_TNL_Address_to_Update_List_Item_PDU = -1;  /* UL_UP_TNL_Address_to_Update_List_Item */
static int hf_f1ap_UplinkTxDirectCurrentListInformation_PDU = -1;  /* UplinkTxDirectCurrentListInformation */
static int hf_f1ap_URI_address_PDU = -1;          /* URI_address */
static int hf_f1ap_VictimgNBSetID_PDU = -1;       /* VictimgNBSetID */
static int hf_f1ap_Reset_PDU = -1;                /* Reset */
static int hf_f1ap_ResetType_PDU = -1;            /* ResetType */
static int hf_f1ap_ResetAcknowledge_PDU = -1;     /* ResetAcknowledge */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionListResAck_PDU = -1;  /* UE_associatedLogicalF1_ConnectionListResAck */
static int hf_f1ap_ErrorIndication_PDU = -1;      /* ErrorIndication */
static int hf_f1ap_F1SetupRequest_PDU = -1;       /* F1SetupRequest */
static int hf_f1ap_GNB_DU_Served_Cells_List_PDU = -1;  /* GNB_DU_Served_Cells_List */
static int hf_f1ap_F1SetupResponse_PDU = -1;      /* F1SetupResponse */
static int hf_f1ap_Cells_to_be_Activated_List_PDU = -1;  /* Cells_to_be_Activated_List */
static int hf_f1ap_F1SetupFailure_PDU = -1;       /* F1SetupFailure */
static int hf_f1ap_GNBDUConfigurationUpdate_PDU = -1;  /* GNBDUConfigurationUpdate */
static int hf_f1ap_Served_Cells_To_Add_List_PDU = -1;  /* Served_Cells_To_Add_List */
static int hf_f1ap_Served_Cells_To_Modify_List_PDU = -1;  /* Served_Cells_To_Modify_List */
static int hf_f1ap_Served_Cells_To_Delete_List_PDU = -1;  /* Served_Cells_To_Delete_List */
static int hf_f1ap_Cells_Status_List_PDU = -1;    /* Cells_Status_List */
static int hf_f1ap_Dedicated_SIDelivery_NeededUE_List_PDU = -1;  /* Dedicated_SIDelivery_NeededUE_List */
static int hf_f1ap_GNB_DU_TNL_Association_To_Remove_List_PDU = -1;  /* GNB_DU_TNL_Association_To_Remove_List */
static int hf_f1ap_GNBDUConfigurationUpdateAcknowledge_PDU = -1;  /* GNBDUConfigurationUpdateAcknowledge */
static int hf_f1ap_GNBDUConfigurationUpdateFailure_PDU = -1;  /* GNBDUConfigurationUpdateFailure */
static int hf_f1ap_GNBCUConfigurationUpdate_PDU = -1;  /* GNBCUConfigurationUpdate */
static int hf_f1ap_Cells_to_be_Deactivated_List_PDU = -1;  /* Cells_to_be_Deactivated_List */
static int hf_f1ap_GNB_CU_TNL_Association_To_Add_List_PDU = -1;  /* GNB_CU_TNL_Association_To_Add_List */
static int hf_f1ap_GNB_CU_TNL_Association_To_Remove_List_PDU = -1;  /* GNB_CU_TNL_Association_To_Remove_List */
static int hf_f1ap_GNB_CU_TNL_Association_To_Update_List_PDU = -1;  /* GNB_CU_TNL_Association_To_Update_List */
static int hf_f1ap_Cells_to_be_Barred_List_PDU = -1;  /* Cells_to_be_Barred_List */
static int hf_f1ap_Protected_EUTRA_Resources_List_PDU = -1;  /* Protected_EUTRA_Resources_List */
static int hf_f1ap_Neighbour_Cell_Information_List_PDU = -1;  /* Neighbour_Cell_Information_List */
static int hf_f1ap_GNBCUConfigurationUpdateAcknowledge_PDU = -1;  /* GNBCUConfigurationUpdateAcknowledge */
static int hf_f1ap_Cells_Failed_to_be_Activated_List_PDU = -1;  /* Cells_Failed_to_be_Activated_List */
static int hf_f1ap_GNB_CU_TNL_Association_Setup_List_PDU = -1;  /* GNB_CU_TNL_Association_Setup_List */
static int hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List_PDU = -1;  /* GNB_CU_TNL_Association_Failed_To_Setup_List */
static int hf_f1ap_GNBCUConfigurationUpdateFailure_PDU = -1;  /* GNBCUConfigurationUpdateFailure */
static int hf_f1ap_GNBDUResourceCoordinationRequest_PDU = -1;  /* GNBDUResourceCoordinationRequest */
static int hf_f1ap_GNBDUResourceCoordinationResponse_PDU = -1;  /* GNBDUResourceCoordinationResponse */
static int hf_f1ap_UEContextSetupRequest_PDU = -1;  /* UEContextSetupRequest */
static int hf_f1ap_Candidate_SpCell_List_PDU = -1;  /* Candidate_SpCell_List */
static int hf_f1ap_SCell_ToBeSetup_List_PDU = -1;  /* SCell_ToBeSetup_List */
static int hf_f1ap_SRBs_ToBeSetup_List_PDU = -1;  /* SRBs_ToBeSetup_List */
static int hf_f1ap_DRBs_ToBeSetup_List_PDU = -1;  /* DRBs_ToBeSetup_List */
static int hf_f1ap_BHChannels_ToBeSetup_List_PDU = -1;  /* BHChannels_ToBeSetup_List */
static int hf_f1ap_SLDRBs_ToBeSetup_List_PDU = -1;  /* SLDRBs_ToBeSetup_List */
static int hf_f1ap_UEContextSetupResponse_PDU = -1;  /* UEContextSetupResponse */
static int hf_f1ap_DRBs_Setup_List_PDU = -1;      /* DRBs_Setup_List */
static int hf_f1ap_SRBs_FailedToBeSetup_List_PDU = -1;  /* SRBs_FailedToBeSetup_List */
static int hf_f1ap_DRBs_FailedToBeSetup_List_PDU = -1;  /* DRBs_FailedToBeSetup_List */
static int hf_f1ap_SCell_FailedtoSetup_List_PDU = -1;  /* SCell_FailedtoSetup_List */
static int hf_f1ap_SRBs_Setup_List_PDU = -1;      /* SRBs_Setup_List */
static int hf_f1ap_BHChannels_Setup_List_PDU = -1;  /* BHChannels_Setup_List */
static int hf_f1ap_BHChannels_FailedToBeSetup_List_PDU = -1;  /* BHChannels_FailedToBeSetup_List */
static int hf_f1ap_SLDRBs_Setup_List_PDU = -1;    /* SLDRBs_Setup_List */
static int hf_f1ap_SLDRBs_FailedToBeSetup_List_PDU = -1;  /* SLDRBs_FailedToBeSetup_List */
static int hf_f1ap_UEContextSetupFailure_PDU = -1;  /* UEContextSetupFailure */
static int hf_f1ap_Potential_SpCell_List_PDU = -1;  /* Potential_SpCell_List */
static int hf_f1ap_UEContextReleaseRequest_PDU = -1;  /* UEContextReleaseRequest */
static int hf_f1ap_UEContextReleaseCommand_PDU = -1;  /* UEContextReleaseCommand */
static int hf_f1ap_UEContextReleaseComplete_PDU = -1;  /* UEContextReleaseComplete */
static int hf_f1ap_UEContextModificationRequest_PDU = -1;  /* UEContextModificationRequest */
static int hf_f1ap_SCell_ToBeSetupMod_List_PDU = -1;  /* SCell_ToBeSetupMod_List */
static int hf_f1ap_SCell_ToBeRemoved_List_PDU = -1;  /* SCell_ToBeRemoved_List */
static int hf_f1ap_SRBs_ToBeSetupMod_List_PDU = -1;  /* SRBs_ToBeSetupMod_List */
static int hf_f1ap_DRBs_ToBeSetupMod_List_PDU = -1;  /* DRBs_ToBeSetupMod_List */
static int hf_f1ap_BHChannels_ToBeSetupMod_List_PDU = -1;  /* BHChannels_ToBeSetupMod_List */
static int hf_f1ap_DRBs_ToBeModified_List_PDU = -1;  /* DRBs_ToBeModified_List */
static int hf_f1ap_BHChannels_ToBeModified_List_PDU = -1;  /* BHChannels_ToBeModified_List */
static int hf_f1ap_SRBs_ToBeReleased_List_PDU = -1;  /* SRBs_ToBeReleased_List */
static int hf_f1ap_DRBs_ToBeReleased_List_PDU = -1;  /* DRBs_ToBeReleased_List */
static int hf_f1ap_BHChannels_ToBeReleased_List_PDU = -1;  /* BHChannels_ToBeReleased_List */
static int hf_f1ap_SLDRBs_ToBeSetupMod_List_PDU = -1;  /* SLDRBs_ToBeSetupMod_List */
static int hf_f1ap_SLDRBs_ToBeModified_List_PDU = -1;  /* SLDRBs_ToBeModified_List */
static int hf_f1ap_SLDRBs_ToBeReleased_List_PDU = -1;  /* SLDRBs_ToBeReleased_List */
static int hf_f1ap_UEContextModificationResponse_PDU = -1;  /* UEContextModificationResponse */
static int hf_f1ap_DRBs_SetupMod_List_PDU = -1;   /* DRBs_SetupMod_List */
static int hf_f1ap_DRBs_Modified_List_PDU = -1;   /* DRBs_Modified_List */
static int hf_f1ap_SRBs_SetupMod_List_PDU = -1;   /* SRBs_SetupMod_List */
static int hf_f1ap_SRBs_Modified_List_PDU = -1;   /* SRBs_Modified_List */
static int hf_f1ap_DRBs_FailedToBeModified_List_PDU = -1;  /* DRBs_FailedToBeModified_List */
static int hf_f1ap_SRBs_FailedToBeSetupMod_List_PDU = -1;  /* SRBs_FailedToBeSetupMod_List */
static int hf_f1ap_DRBs_FailedToBeSetupMod_List_PDU = -1;  /* DRBs_FailedToBeSetupMod_List */
static int hf_f1ap_SCell_FailedtoSetupMod_List_PDU = -1;  /* SCell_FailedtoSetupMod_List */
static int hf_f1ap_BHChannels_SetupMod_List_PDU = -1;  /* BHChannels_SetupMod_List */
static int hf_f1ap_BHChannels_Modified_List_PDU = -1;  /* BHChannels_Modified_List */
static int hf_f1ap_BHChannels_FailedToBeModified_List_PDU = -1;  /* BHChannels_FailedToBeModified_List */
static int hf_f1ap_BHChannels_FailedToBeSetupMod_List_PDU = -1;  /* BHChannels_FailedToBeSetupMod_List */
static int hf_f1ap_Associated_SCell_List_PDU = -1;  /* Associated_SCell_List */
static int hf_f1ap_SLDRBs_SetupMod_List_PDU = -1;  /* SLDRBs_SetupMod_List */
static int hf_f1ap_SLDRBs_Modified_List_PDU = -1;  /* SLDRBs_Modified_List */
static int hf_f1ap_SLDRBs_FailedToBeModified_List_PDU = -1;  /* SLDRBs_FailedToBeModified_List */
static int hf_f1ap_SLDRBs_FailedToBeSetupMod_List_PDU = -1;  /* SLDRBs_FailedToBeSetupMod_List */
static int hf_f1ap_UEContextModificationFailure_PDU = -1;  /* UEContextModificationFailure */
static int hf_f1ap_UEContextModificationRequired_PDU = -1;  /* UEContextModificationRequired */
static int hf_f1ap_DRBs_Required_ToBeModified_List_PDU = -1;  /* DRBs_Required_ToBeModified_List */
static int hf_f1ap_DRBs_Required_ToBeReleased_List_PDU = -1;  /* DRBs_Required_ToBeReleased_List */
static int hf_f1ap_SRBs_Required_ToBeReleased_List_PDU = -1;  /* SRBs_Required_ToBeReleased_List */
static int hf_f1ap_BHChannels_Required_ToBeReleased_List_PDU = -1;  /* BHChannels_Required_ToBeReleased_List */
static int hf_f1ap_SLDRBs_Required_ToBeModified_List_PDU = -1;  /* SLDRBs_Required_ToBeModified_List */
static int hf_f1ap_SLDRBs_Required_ToBeReleased_List_PDU = -1;  /* SLDRBs_Required_ToBeReleased_List */
static int hf_f1ap_UEContextModificationConfirm_PDU = -1;  /* UEContextModificationConfirm */
static int hf_f1ap_DRBs_ModifiedConf_List_PDU = -1;  /* DRBs_ModifiedConf_List */
static int hf_f1ap_SLDRBs_ModifiedConf_List_PDU = -1;  /* SLDRBs_ModifiedConf_List */
static int hf_f1ap_UEContextModificationRefuse_PDU = -1;  /* UEContextModificationRefuse */
static int hf_f1ap_WriteReplaceWarningRequest_PDU = -1;  /* WriteReplaceWarningRequest */
static int hf_f1ap_Cells_To_Be_Broadcast_List_PDU = -1;  /* Cells_To_Be_Broadcast_List */
static int hf_f1ap_WriteReplaceWarningResponse_PDU = -1;  /* WriteReplaceWarningResponse */
static int hf_f1ap_Cells_Broadcast_Completed_List_PDU = -1;  /* Cells_Broadcast_Completed_List */
static int hf_f1ap_PWSCancelRequest_PDU = -1;     /* PWSCancelRequest */
static int hf_f1ap_Broadcast_To_Be_Cancelled_List_PDU = -1;  /* Broadcast_To_Be_Cancelled_List */
static int hf_f1ap_PWSCancelResponse_PDU = -1;    /* PWSCancelResponse */
static int hf_f1ap_Cells_Broadcast_Cancelled_List_PDU = -1;  /* Cells_Broadcast_Cancelled_List */
static int hf_f1ap_UEInactivityNotification_PDU = -1;  /* UEInactivityNotification */
static int hf_f1ap_DRB_Activity_List_PDU = -1;    /* DRB_Activity_List */
static int hf_f1ap_InitialULRRCMessageTransfer_PDU = -1;  /* InitialULRRCMessageTransfer */
static int hf_f1ap_DLRRCMessageTransfer_PDU = -1;  /* DLRRCMessageTransfer */
static int hf_f1ap_RedirectedRRCmessage_PDU = -1;  /* RedirectedRRCmessage */
static int hf_f1ap_ULRRCMessageTransfer_PDU = -1;  /* ULRRCMessageTransfer */
static int hf_f1ap_PrivateMessage_PDU = -1;       /* PrivateMessage */
static int hf_f1ap_SystemInformationDeliveryCommand_PDU = -1;  /* SystemInformationDeliveryCommand */
static int hf_f1ap_Paging_PDU = -1;               /* Paging */
static int hf_f1ap_PagingCell_list_PDU = -1;      /* PagingCell_list */
static int hf_f1ap_Notify_PDU = -1;               /* Notify */
static int hf_f1ap_DRB_Notify_List_PDU = -1;      /* DRB_Notify_List */
static int hf_f1ap_NetworkAccessRateReduction_PDU = -1;  /* NetworkAccessRateReduction */
static int hf_f1ap_PWSRestartIndication_PDU = -1;  /* PWSRestartIndication */
static int hf_f1ap_NR_CGI_List_For_Restart_List_PDU = -1;  /* NR_CGI_List_For_Restart_List */
static int hf_f1ap_PWSFailureIndication_PDU = -1;  /* PWSFailureIndication */
static int hf_f1ap_PWS_Failed_NR_CGI_List_PDU = -1;  /* PWS_Failed_NR_CGI_List */
static int hf_f1ap_GNBDUStatusIndication_PDU = -1;  /* GNBDUStatusIndication */
static int hf_f1ap_RRCDeliveryReport_PDU = -1;    /* RRCDeliveryReport */
static int hf_f1ap_F1RemovalRequest_PDU = -1;     /* F1RemovalRequest */
static int hf_f1ap_F1RemovalResponse_PDU = -1;    /* F1RemovalResponse */
static int hf_f1ap_F1RemovalFailure_PDU = -1;     /* F1RemovalFailure */
static int hf_f1ap_TraceStart_PDU = -1;           /* TraceStart */
static int hf_f1ap_DeactivateTrace_PDU = -1;      /* DeactivateTrace */
static int hf_f1ap_CellTrafficTrace_PDU = -1;     /* CellTrafficTrace */
static int hf_f1ap_DUCURadioInformationTransfer_PDU = -1;  /* DUCURadioInformationTransfer */
static int hf_f1ap_CUDURadioInformationTransfer_PDU = -1;  /* CUDURadioInformationTransfer */
static int hf_f1ap_BAPMappingConfiguration_PDU = -1;  /* BAPMappingConfiguration */
static int hf_f1ap_BH_Routing_Information_Added_List_PDU = -1;  /* BH_Routing_Information_Added_List */
static int hf_f1ap_BH_Routing_Information_Removed_List_PDU = -1;  /* BH_Routing_Information_Removed_List */
static int hf_f1ap_BAPMappingConfigurationAcknowledge_PDU = -1;  /* BAPMappingConfigurationAcknowledge */
static int hf_f1ap_BAPMappingConfigurationFailure_PDU = -1;  /* BAPMappingConfigurationFailure */
static int hf_f1ap_GNBDUResourceConfiguration_PDU = -1;  /* GNBDUResourceConfiguration */
static int hf_f1ap_GNBDUResourceConfigurationAcknowledge_PDU = -1;  /* GNBDUResourceConfigurationAcknowledge */
static int hf_f1ap_GNBDUResourceConfigurationFailure_PDU = -1;  /* GNBDUResourceConfigurationFailure */
static int hf_f1ap_IABTNLAddressRequest_PDU = -1;  /* IABTNLAddressRequest */
static int hf_f1ap_IAB_TNL_Addresses_To_Remove_List_PDU = -1;  /* IAB_TNL_Addresses_To_Remove_List */
static int hf_f1ap_IABTNLAddressResponse_PDU = -1;  /* IABTNLAddressResponse */
static int hf_f1ap_IAB_Allocated_TNL_Address_List_PDU = -1;  /* IAB_Allocated_TNL_Address_List */
static int hf_f1ap_IABTNLAddressFailure_PDU = -1;  /* IABTNLAddressFailure */
static int hf_f1ap_IABUPConfigurationUpdateRequest_PDU = -1;  /* IABUPConfigurationUpdateRequest */
static int hf_f1ap_UL_UP_TNL_Information_to_Update_List_PDU = -1;  /* UL_UP_TNL_Information_to_Update_List */
static int hf_f1ap_UL_UP_TNL_Address_to_Update_List_PDU = -1;  /* UL_UP_TNL_Address_to_Update_List */
static int hf_f1ap_IABUPConfigurationUpdateResponse_PDU = -1;  /* IABUPConfigurationUpdateResponse */
static int hf_f1ap_DL_UP_TNL_Address_to_Update_List_PDU = -1;  /* DL_UP_TNL_Address_to_Update_List */
static int hf_f1ap_IABUPConfigurationUpdateFailure_PDU = -1;  /* IABUPConfigurationUpdateFailure */
static int hf_f1ap_ResourceStatusRequest_PDU = -1;  /* ResourceStatusRequest */
static int hf_f1ap_ResourceStatusResponse_PDU = -1;  /* ResourceStatusResponse */
static int hf_f1ap_ResourceStatusFailure_PDU = -1;  /* ResourceStatusFailure */
static int hf_f1ap_ResourceStatusUpdate_PDU = -1;  /* ResourceStatusUpdate */
static int hf_f1ap_AccessAndMobilityIndication_PDU = -1;  /* AccessAndMobilityIndication */
static int hf_f1ap_ReferenceTimeInformationReportingControl_PDU = -1;  /* ReferenceTimeInformationReportingControl */
static int hf_f1ap_ReferenceTimeInformationReport_PDU = -1;  /* ReferenceTimeInformationReport */
static int hf_f1ap_AccessSuccess_PDU = -1;        /* AccessSuccess */
static int hf_f1ap_PositioningAssistanceInformationControl_PDU = -1;  /* PositioningAssistanceInformationControl */
static int hf_f1ap_PositioningAssistanceInformationFeedback_PDU = -1;  /* PositioningAssistanceInformationFeedback */
static int hf_f1ap_PositioningMeasurementRequest_PDU = -1;  /* PositioningMeasurementRequest */
static int hf_f1ap_PositioningMeasurementResponse_PDU = -1;  /* PositioningMeasurementResponse */
static int hf_f1ap_PositioningMeasurementFailure_PDU = -1;  /* PositioningMeasurementFailure */
static int hf_f1ap_PositioningMeasurementReport_PDU = -1;  /* PositioningMeasurementReport */
static int hf_f1ap_PositioningMeasurementAbort_PDU = -1;  /* PositioningMeasurementAbort */
static int hf_f1ap_PositioningMeasurementFailureIndication_PDU = -1;  /* PositioningMeasurementFailureIndication */
static int hf_f1ap_PositioningMeasurementUpdate_PDU = -1;  /* PositioningMeasurementUpdate */
static int hf_f1ap_TRPInformationRequest_PDU = -1;  /* TRPInformationRequest */
static int hf_f1ap_TRPInformationTypeListTRPReq_PDU = -1;  /* TRPInformationTypeListTRPReq */
static int hf_f1ap_TRPInformationResponse_PDU = -1;  /* TRPInformationResponse */
static int hf_f1ap_TRPInformationListTRPResp_PDU = -1;  /* TRPInformationListTRPResp */
static int hf_f1ap_TRPInformationFailure_PDU = -1;  /* TRPInformationFailure */
static int hf_f1ap_PositioningInformationRequest_PDU = -1;  /* PositioningInformationRequest */
static int hf_f1ap_PositioningInformationResponse_PDU = -1;  /* PositioningInformationResponse */
static int hf_f1ap_PositioningInformationFailure_PDU = -1;  /* PositioningInformationFailure */
static int hf_f1ap_PositioningActivationRequest_PDU = -1;  /* PositioningActivationRequest */
static int hf_f1ap_SRSType_PDU = -1;              /* SRSType */
static int hf_f1ap_PositioningActivationResponse_PDU = -1;  /* PositioningActivationResponse */
static int hf_f1ap_PositioningActivationFailure_PDU = -1;  /* PositioningActivationFailure */
static int hf_f1ap_PositioningDeactivation_PDU = -1;  /* PositioningDeactivation */
static int hf_f1ap_PositioningInformationUpdate_PDU = -1;  /* PositioningInformationUpdate */
static int hf_f1ap_E_CIDMeasurementInitiationRequest_PDU = -1;  /* E_CIDMeasurementInitiationRequest */
static int hf_f1ap_E_CIDMeasurementInitiationResponse_PDU = -1;  /* E_CIDMeasurementInitiationResponse */
static int hf_f1ap_E_CIDMeasurementInitiationFailure_PDU = -1;  /* E_CIDMeasurementInitiationFailure */
static int hf_f1ap_E_CIDMeasurementFailureIndication_PDU = -1;  /* E_CIDMeasurementFailureIndication */
static int hf_f1ap_E_CIDMeasurementReport_PDU = -1;  /* E_CIDMeasurementReport */
static int hf_f1ap_E_CIDMeasurementTerminationCommand_PDU = -1;  /* E_CIDMeasurementTerminationCommand */
static int hf_f1ap_F1AP_PDU_PDU = -1;             /* F1AP_PDU */
static int hf_f1ap_local = -1;                    /* INTEGER_0_65535 */
static int hf_f1ap_global = -1;                   /* T_global */
static int hf_f1ap_ProtocolIE_Container_item = -1;  /* ProtocolIE_Field */
static int hf_f1ap_id = -1;                       /* ProtocolIE_ID */
static int hf_f1ap_criticality = -1;              /* Criticality */
static int hf_f1ap_ie_field_value = -1;           /* T_ie_field_value */
static int hf_f1ap_ProtocolExtensionContainer_item = -1;  /* ProtocolExtensionField */
static int hf_f1ap_ext_id = -1;                   /* ProtocolExtensionID */
static int hf_f1ap_extensionValue = -1;           /* T_extensionValue */
static int hf_f1ap_PrivateIE_Container_item = -1;  /* PrivateIE_Field */
static int hf_f1ap_private_id = -1;               /* PrivateIE_ID */
static int hf_f1ap_value = -1;                    /* T_value */
static int hf_f1ap_sRSResourceSetID = -1;         /* SRSResourceSetID */
static int hf_f1ap_releaseALL = -1;               /* NULL */
static int hf_f1ap_choice_extension = -1;         /* ProtocolIE_SingleContainer */
static int hf_f1ap_latitudeSign = -1;             /* T_latitudeSign */
static int hf_f1ap_latitude = -1;                 /* INTEGER_0_8388607 */
static int hf_f1ap_longitude = -1;                /* INTEGER_M8388608_8388607 */
static int hf_f1ap_directionOfAltitude = -1;      /* T_directionOfAltitude */
static int hf_f1ap_altitude = -1;                 /* INTEGER_0_32767 */
static int hf_f1ap_uncertaintySemi_major = -1;    /* INTEGER_0_127 */
static int hf_f1ap_uncertaintySemi_minor = -1;    /* INTEGER_0_127 */
static int hf_f1ap_orientationOfMajorAxis = -1;   /* INTEGER_0_179 */
static int hf_f1ap_uncertaintyAltitude = -1;      /* INTEGER_0_127 */
static int hf_f1ap_confidence = -1;               /* INTEGER_0_100 */
static int hf_f1ap_iE_Extensions = -1;            /* ProtocolExtensionContainer */
static int hf_f1ap_Activated_Cells_to_be_Updated_List_item = -1;  /* Activated_Cells_to_be_Updated_List_Item */
static int hf_f1ap_nRCGI = -1;                    /* NRCGI */
static int hf_f1ap_iAB_DU_Cell_Resource_Configuration_Mode_Info = -1;  /* IAB_DU_Cell_Resource_Configuration_Mode_Info */
static int hf_f1ap_locationAndBandwidth = -1;     /* INTEGER_0_37949_ */
static int hf_f1ap_subcarrierSpacing = -1;        /* T_subcarrierSpacing */
static int hf_f1ap_cyclicPrefix = -1;             /* T_cyclicPrefix */
static int hf_f1ap_txDirectCurrentLocation = -1;  /* INTEGER_0_3301_ */
static int hf_f1ap_shift7dot5kHz = -1;            /* T_shift7dot5kHz */
static int hf_f1ap_sRSConfig = -1;                /* SRSConfig */
static int hf_f1ap_AdditionalPath_List_item = -1;  /* AdditionalPath_Item */
static int hf_f1ap_relativePathDelay = -1;        /* RelativePathDelay */
static int hf_f1ap_pathQuality = -1;              /* TRPMeasurementQuality */
static int hf_f1ap_AdditionalPDCPDuplicationTNL_List_item = -1;  /* AdditionalPDCPDuplicationTNL_Item */
static int hf_f1ap_additionalPDCPDuplicationUPTNLInformation = -1;  /* UPTransportLayerInformation */
static int hf_f1ap_AdditionalSIBMessageList_item = -1;  /* AdditionalSIBMessageList_Item */
static int hf_f1ap_additionalSIB = -1;            /* T_additionalSIB */
static int hf_f1ap_AggressorCellList_item = -1;   /* AggressorCellList_Item */
static int hf_f1ap_aggressorCell_ID = -1;         /* NRCGI */
static int hf_f1ap_aggressorgNBSetID = -1;        /* GNBSetID */
static int hf_f1ap_priorityLevel = -1;            /* PriorityLevel */
static int hf_f1ap_pre_emptionCapability = -1;    /* Pre_emptionCapability */
static int hf_f1ap_pre_emptionVulnerability = -1;  /* Pre_emptionVulnerability */
static int hf_f1ap_AlternativeQoSParaSetList_item = -1;  /* AlternativeQoSParaSetItem */
static int hf_f1ap_alternativeQoSParaSetIndex = -1;  /* QoSParaSetIndex */
static int hf_f1ap_guaranteedFlowBitRateDL = -1;  /* BitRate */
static int hf_f1ap_guaranteedFlowBitRateUL = -1;  /* BitRate */
static int hf_f1ap_packetDelayBudget = -1;        /* PacketDelayBudget */
static int hf_f1ap_packetErrorRate = -1;          /* PacketErrorRate */
static int hf_f1ap_azimuthQuality = -1;           /* INTEGER_0_255 */
static int hf_f1ap_zenithQuality = -1;            /* INTEGER_0_255 */
static int hf_f1ap_resolution = -1;               /* T_resolution */
static int hf_f1ap_AperiodicSRSResourceTriggerList_item = -1;  /* AperiodicSRSResourceTrigger */
static int hf_f1ap_sCell_ID = -1;                 /* NRCGI */
static int hf_f1ap_AvailablePLMNList_item = -1;   /* AvailablePLMNList_Item */
static int hf_f1ap_pLMNIdentity = -1;             /* PLMN_Identity */
static int hf_f1ap_AvailableSNPN_ID_List_item = -1;  /* AvailableSNPN_ID_List_Item */
static int hf_f1ap_pLMN_Identity = -1;            /* PLMN_Identity */
static int hf_f1ap_availableNIDList = -1;         /* BroadcastNIDList */
static int hf_f1ap_fR1 = -1;                      /* FR1_Bandwidth */
static int hf_f1ap_fR2 = -1;                      /* FR2_Bandwidth */
static int hf_f1ap_bAPlayerBHRLCchannelMappingInfoToAdd = -1;  /* BAPlayerBHRLCchannelMappingInfoList */
static int hf_f1ap_bAPlayerBHRLCchannelMappingInfoToRemove = -1;  /* MappingInformationtoRemove */
static int hf_f1ap_BAPlayerBHRLCchannelMappingInfoList_item = -1;  /* BAPlayerBHRLCchannelMappingInfo_Item */
static int hf_f1ap_mappingInformationIndex = -1;  /* MappingInformationIndex */
static int hf_f1ap_priorHopBAPAddress = -1;       /* BAPAddress */
static int hf_f1ap_ingressbHRLCChannelID = -1;    /* BHRLCChannelID */
static int hf_f1ap_nextHopBAPAddress = -1;        /* BAPAddress */
static int hf_f1ap_egressbHRLCChannelID = -1;     /* BHRLCChannelID */
static int hf_f1ap_bAPAddress = -1;               /* BAPAddress */
static int hf_f1ap_bAPPathID = -1;                /* BAPPathID */
static int hf_f1ap_bHRLCChannelID = -1;           /* BHRLCChannelID */
static int hf_f1ap_cause = -1;                    /* Cause */
static int hf_f1ap_bHQoSInformation = -1;         /* BHQoSInformation */
static int hf_f1ap_rLCmode = -1;                  /* RLCMode */
static int hf_f1ap_bAPCtrlPDUChannel = -1;        /* BAPCtrlPDUChannel */
static int hf_f1ap_trafficMappingInfo = -1;       /* TrafficMappingInfo */
static int hf_f1ap_bAProutingID = -1;             /* BAPRoutingID */
static int hf_f1ap_egressBHRLCCHList = -1;        /* EgressBHRLCCHList */
static int hf_f1ap_bHRLCCHQoS = -1;               /* QoSFlowLevelQoSParameters */
static int hf_f1ap_eUTRANBHRLCCHQoS = -1;         /* EUTRANQoS */
static int hf_f1ap_cPTrafficType = -1;            /* CPTrafficType */
static int hf_f1ap_bAPRoutingID = -1;             /* BAPRoutingID */
static int hf_f1ap_BPLMN_ID_Info_List_item = -1;  /* BPLMN_ID_Info_Item */
static int hf_f1ap_pLMN_Identity_List = -1;       /* AvailablePLMNList */
static int hf_f1ap_extended_PLMN_Identity_List = -1;  /* ExtendedAvailablePLMN_List */
static int hf_f1ap_fiveGS_TAC = -1;               /* FiveGS_TAC */
static int hf_f1ap_nr_cell_ID = -1;               /* NRCellIdentity */
static int hf_f1ap_ranac = -1;                    /* RANAC */
static int hf_f1ap_ServedPLMNs_List_item = -1;    /* ServedPLMNs_Item */
static int hf_f1ap_BroadcastCAGList_item = -1;    /* CAGID */
static int hf_f1ap_BroadcastNIDList_item = -1;    /* NID */
static int hf_f1ap_BroadcastSNPN_ID_List_item = -1;  /* BroadcastSNPN_ID_List_Item */
static int hf_f1ap_broadcastNIDList = -1;         /* BroadcastNIDList */
static int hf_f1ap_BroadcastPNI_NPN_ID_List_item = -1;  /* BroadcastPNI_NPN_ID_List_Item */
static int hf_f1ap_broadcastCAGList = -1;         /* BroadcastCAGList */
static int hf_f1ap_candidate_SpCell_ID = -1;      /* NRCGI */
static int hf_f1ap_capacityValue = -1;            /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaCapacityValueList = -1;  /* SSBAreaCapacityValueList */
static int hf_f1ap_radioNetwork = -1;             /* CauseRadioNetwork */
static int hf_f1ap_transport = -1;                /* CauseTransport */
static int hf_f1ap_protocol = -1;                 /* CauseProtocol */
static int hf_f1ap_misc = -1;                     /* CauseMisc */
static int hf_f1ap_CellMeasurementResultList_item = -1;  /* CellMeasurementResultItem */
static int hf_f1ap_cellID = -1;                   /* NRCGI */
static int hf_f1ap_radioResourceStatus = -1;      /* RadioResourceStatus */
static int hf_f1ap_compositeAvailableCapacityGroup = -1;  /* CompositeAvailableCapacityGroup */
static int hf_f1ap_sliceAvailableCapacity = -1;   /* SliceAvailableCapacity */
static int hf_f1ap_numberofActiveUEs = -1;        /* NumberofActiveUEs */
static int hf_f1ap_service_status = -1;           /* Service_Status */
static int hf_f1ap_numberOfBroadcasts = -1;       /* NumberOfBroadcasts */
static int hf_f1ap_nRPCI = -1;                    /* NRPCI */
static int hf_f1ap_cellBarred = -1;               /* CellBarred */
static int hf_f1ap_CellToReportList_item = -1;    /* CellToReportItem */
static int hf_f1ap_sSBToReportList = -1;          /* SSBToReportList */
static int hf_f1ap_sliceToReportList = -1;        /* SliceToReportList */
static int hf_f1ap_cellSize = -1;                 /* CellSize */
static int hf_f1ap_Child_Node_Cells_List_item = -1;  /* Child_Node_Cells_List_Item */
static int hf_f1ap_iAB_STC_Info = -1;             /* IAB_STC_Info */
static int hf_f1ap_rACH_Config_Common = -1;       /* RACH_Config_Common */
static int hf_f1ap_rACH_Config_Common_IAB = -1;   /* RACH_Config_Common_IAB */
static int hf_f1ap_cSI_RS_Configuration = -1;     /* T_cSI_RS_Configuration */
static int hf_f1ap_sR_Configuration = -1;         /* T_sR_Configuration */
static int hf_f1ap_pDCCH_ConfigSIB1 = -1;         /* T_pDCCH_ConfigSIB1 */
static int hf_f1ap_sCS_Common = -1;               /* T_sCS_Common */
static int hf_f1ap_multiplexingInfo = -1;         /* MultiplexingInfo */
static int hf_f1ap_Child_Nodes_List_item = -1;    /* Child_Nodes_List_Item */
static int hf_f1ap_gNB_CU_UE_F1AP_ID = -1;        /* GNB_CU_UE_F1AP_ID */
static int hf_f1ap_gNB_DU_UE_F1AP_ID = -1;        /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_child_Node_Cells_List = -1;    /* Child_Node_Cells_List */
static int hf_f1ap_fiveG_S_TMSI = -1;             /* BIT_STRING_SIZE_48 */
static int hf_f1ap_compositeAvailableCapacityDownlink = -1;  /* CompositeAvailableCapacity */
static int hf_f1ap_compositeAvailableCapacityUplink = -1;  /* CompositeAvailableCapacity */
static int hf_f1ap_cellCapacityClassValue = -1;   /* CellCapacityClassValue */
static int hf_f1ap_capacityValue_01 = -1;         /* CapacityValue */
static int hf_f1ap_cho_trigger = -1;              /* CHOtrigger_InterDU */
static int hf_f1ap_targetgNB_DUUEF1APID = -1;     /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_cho_trigger_01 = -1;           /* CHOtrigger_IntraDU */
static int hf_f1ap_targetCellsTocancel = -1;      /* TargetCellList */
static int hf_f1ap_endpoint_IP_address = -1;      /* TransportLayerAddress */
static int hf_f1ap_endpoint_IP_address_and_port = -1;  /* Endpoint_IP_address_and_port */
static int hf_f1ap_procedureCode = -1;            /* ProcedureCode */
static int hf_f1ap_triggeringMessage = -1;        /* TriggeringMessage */
static int hf_f1ap_procedureCriticality = -1;     /* Criticality */
static int hf_f1ap_transactionID = -1;            /* TransactionID */
static int hf_f1ap_iEsCriticalityDiagnostics = -1;  /* CriticalityDiagnostics_IE_List */
static int hf_f1ap_CriticalityDiagnostics_IE_List_item = -1;  /* CriticalityDiagnostics_IE_Item */
static int hf_f1ap_iECriticality = -1;            /* Criticality */
static int hf_f1ap_iE_ID = -1;                    /* ProtocolIE_ID */
static int hf_f1ap_typeOfError = -1;              /* TypeOfError */
static int hf_f1ap_rIM = -1;                      /* CUDURIMInformation */
static int hf_f1ap_victimgNBSetID = -1;           /* GNBSetID */
static int hf_f1ap_rIMRSDetectionStatus = -1;     /* RIMRSDetectionStatus */
static int hf_f1ap_cG_ConfigInfo = -1;            /* CG_ConfigInfo */
static int hf_f1ap_uE_CapabilityRAT_ContainerList = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_f1ap_measConfig = -1;               /* MeasConfig */
static int hf_f1ap_prsid = -1;                    /* INTEGER_0_255 */
static int hf_f1ap_dl_PRSResourceSetID = -1;      /* PRS_Resource_Set_ID */
static int hf_f1ap_dl_PRSResourceID = -1;         /* PRS_Resource_ID */
static int hf_f1ap_two = -1;                      /* BIT_STRING_SIZE_2 */
static int hf_f1ap_four = -1;                     /* BIT_STRING_SIZE_4 */
static int hf_f1ap_six = -1;                      /* BIT_STRING_SIZE_6 */
static int hf_f1ap_eight = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_f1ap_sixteen = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_f1ap_thirty_two = -1;               /* BIT_STRING_SIZE_32 */
static int hf_f1ap_listofDL_PRSResourceSetARP = -1;  /* SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP */
static int hf_f1ap_listofDL_PRSResourceSetARP_item = -1;  /* DLPRSResourceSetARP */
static int hf_f1ap_dL_PRSResourceSetARPLocation = -1;  /* DL_PRSResourceSetARPLocation */
static int hf_f1ap_listofDL_PRSResourceARP = -1;  /* SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP */
static int hf_f1ap_listofDL_PRSResourceARP_item = -1;  /* DLPRSResourceARP */
static int hf_f1ap_relativeGeodeticLocation = -1;  /* RelativeGeodeticLocation */
static int hf_f1ap_relativeCartesianLocation = -1;  /* RelativeCartesianLocation */
static int hf_f1ap_choice_Extension = -1;         /* ProtocolIE_SingleContainer */
static int hf_f1ap_dL_PRSResourceARPLocation = -1;  /* DL_PRSResourceARPLocation */
static int hf_f1ap_oldIPAdress = -1;              /* TransportLayerAddress */
static int hf_f1ap_newIPAdress = -1;              /* TransportLayerAddress */
static int hf_f1ap_DLUPTNLInformation_ToBeSetup_List_item = -1;  /* DLUPTNLInformation_ToBeSetup_Item */
static int hf_f1ap_dLUPTNLInformation = -1;       /* UPTransportLayerInformation */
static int hf_f1ap_dRBID = -1;                    /* DRBID */
static int hf_f1ap_dRB_Activity = -1;             /* DRB_Activity */
static int hf_f1ap_dRB_QoS = -1;                  /* QoSFlowLevelQoSParameters */
static int hf_f1ap_sNSSAI = -1;                   /* SNSSAI */
static int hf_f1ap_notificationControl = -1;      /* NotificationControl */
static int hf_f1ap_flows_Mapped_To_DRB_List = -1;  /* Flows_Mapped_To_DRB_List */
static int hf_f1ap_lCID = -1;                     /* LCID */
static int hf_f1ap_dLUPTNLInformation_ToBeSetup_List = -1;  /* DLUPTNLInformation_ToBeSetup_List */
static int hf_f1ap_uLUPTNLInformation_ToBeSetup_List = -1;  /* ULUPTNLInformation_ToBeSetup_List */
static int hf_f1ap_notification_Cause = -1;       /* Notification_Cause */
static int hf_f1ap_qoSInformation = -1;           /* QoSInformation */
static int hf_f1ap_uLConfiguration = -1;          /* ULConfiguration */
static int hf_f1ap_rLCMode = -1;                  /* RLCMode */
static int hf_f1ap_duplicationActivation = -1;    /* DuplicationActivation */
static int hf_f1ap_longDRXCycleLength = -1;       /* LongDRXCycleLength */
static int hf_f1ap_shortDRXCycleLength = -1;      /* ShortDRXCycleLength */
static int hf_f1ap_shortDRXCycleTimer = -1;       /* ShortDRXCycleTimer */
static int hf_f1ap_DSInformationList_item = -1;   /* DSCP */
static int hf_f1ap_rIM_01 = -1;                   /* DUCURIMInformation */
static int hf_f1ap_aggressorCellList = -1;        /* AggressorCellList */
static int hf_f1ap_explicitFormat = -1;           /* ExplicitFormat */
static int hf_f1ap_implicitFormat = -1;           /* ImplicitFormat */
static int hf_f1ap_DUF_Slot_Config_List_item = -1;  /* DUF_Slot_Config_Item */
static int hf_f1ap_cellGroupConfig = -1;          /* CellGroupConfig */
static int hf_f1ap_measGapConfig = -1;            /* MeasGapConfig */
static int hf_f1ap_requestedP_MaxFR1 = -1;        /* T_requestedP_MaxFR1 */
static int hf_f1ap_qoSPriorityLevel = -1;         /* INTEGER_1_127 */
static int hf_f1ap_fiveQI = -1;                   /* INTEGER_0_255_ */
static int hf_f1ap_delayCritical = -1;            /* T_delayCritical */
static int hf_f1ap_averagingWindow = -1;          /* AveragingWindow */
static int hf_f1ap_maxDataBurstVolume = -1;       /* MaxDataBurstVolume */
static int hf_f1ap_resourceType = -1;             /* T_resourceType */
static int hf_f1ap_qoSPriorityLevel_01 = -1;      /* INTEGER_1_8_ */
static int hf_f1ap_E_CID_MeasurementQuantities_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_e_CIDmeasurementQuantitiesValue = -1;  /* E_CID_MeasurementQuantitiesValue */
static int hf_f1ap_geographicalCoordinates = -1;  /* GeographicalCoordinates */
static int hf_f1ap_measuredResults_List = -1;     /* E_CID_MeasuredResults_List */
static int hf_f1ap_E_CID_MeasuredResults_List_item = -1;  /* E_CID_MeasuredResults_Item */
static int hf_f1ap_e_CID_MeasuredResults_Value = -1;  /* E_CID_MeasuredResults_Value */
static int hf_f1ap_valueAngleofArrivalNR = -1;    /* UL_AoA */
static int hf_f1ap_EgressBHRLCCHList_item = -1;   /* EgressBHRLCCHItem */
static int hf_f1ap_endpointIPAddress = -1;        /* TransportLayerAddress */
static int hf_f1ap_ExtendedAvailablePLMN_List_item = -1;  /* ExtendedAvailablePLMN_Item */
static int hf_f1ap_permutation = -1;              /* Permutation */
static int hf_f1ap_noofDownlinkSymbols = -1;      /* NoofDownlinkSymbols */
static int hf_f1ap_noofUplinkSymbols = -1;        /* NoofUplinkSymbols */
static int hf_f1ap_ExtendedServedPLMNs_List_item = -1;  /* ExtendedServedPLMNs_Item */
static int hf_f1ap_tAISliceSupportList = -1;      /* SliceSupportList */
static int hf_f1ap_ExtendedSliceSupportList_item = -1;  /* SliceSupportItem */
static int hf_f1ap_EUTRACells_List_item = -1;     /* EUTRACells_List_item */
static int hf_f1ap_eUTRA_Cell_ID = -1;            /* EUTRA_Cell_ID */
static int hf_f1ap_served_EUTRA_Cells_Information = -1;  /* Served_EUTRA_Cells_Information */
static int hf_f1ap_uL_EARFCN = -1;                /* ExtendedEARFCN */
static int hf_f1ap_dL_EARFCN = -1;                /* ExtendedEARFCN */
static int hf_f1ap_uL_Transmission_Bandwidth = -1;  /* EUTRA_Transmission_Bandwidth */
static int hf_f1ap_dL_Transmission_Bandwidth = -1;  /* EUTRA_Transmission_Bandwidth */
static int hf_f1ap_fDD = -1;                      /* EUTRA_Coex_FDD_Info */
static int hf_f1ap_tDD = -1;                      /* EUTRA_Coex_TDD_Info */
static int hf_f1ap_eARFCN = -1;                   /* ExtendedEARFCN */
static int hf_f1ap_transmission_Bandwidth = -1;   /* EUTRA_Transmission_Bandwidth */
static int hf_f1ap_subframeAssignment = -1;       /* EUTRA_SubframeAssignment */
static int hf_f1ap_specialSubframe_Info = -1;     /* EUTRA_SpecialSubframe_Info */
static int hf_f1ap_rootSequenceIndex = -1;        /* INTEGER_0_837 */
static int hf_f1ap_zeroCorrelationIndex = -1;     /* INTEGER_0_15 */
static int hf_f1ap_highSpeedFlag = -1;            /* BOOLEAN */
static int hf_f1ap_prach_FreqOffset = -1;         /* INTEGER_0_94 */
static int hf_f1ap_prach_ConfigIndex = -1;        /* INTEGER_0_63 */
static int hf_f1ap_specialSubframePatterns = -1;  /* EUTRA_SpecialSubframePatterns */
static int hf_f1ap_cyclicPrefixDL = -1;           /* EUTRA_CyclicPrefixDL */
static int hf_f1ap_cyclicPrefixUL = -1;           /* EUTRA_CyclicPrefixUL */
static int hf_f1ap_qCI = -1;                      /* QCI */
static int hf_f1ap_allocationAndRetentionPriority = -1;  /* AllocationAndRetentionPriority */
static int hf_f1ap_gbrQosInformation = -1;        /* GBR_QosInformation */
static int hf_f1ap_eUTRAFDD = -1;                 /* EUTRA_FDD_Info */
static int hf_f1ap_eUTRATDD = -1;                 /* EUTRA_TDD_Info */
static int hf_f1ap_uL_offsetToPointA = -1;        /* OffsetToPointA */
static int hf_f1ap_dL_offsetToPointA = -1;        /* OffsetToPointA */
static int hf_f1ap_offsetToPointA = -1;           /* OffsetToPointA */
static int hf_f1ap_f1CPathNSA = -1;               /* F1CPathNSA */
static int hf_f1ap_uL_NRFreqInfo = -1;            /* NRFreqInfo */
static int hf_f1ap_dL_NRFreqInfo = -1;            /* NRFreqInfo */
static int hf_f1ap_uL_Transmission_Bandwidth_01 = -1;  /* Transmission_Bandwidth */
static int hf_f1ap_dL_Transmission_Bandwidth_01 = -1;  /* Transmission_Bandwidth */
static int hf_f1ap_Flows_Mapped_To_DRB_List_item = -1;  /* Flows_Mapped_To_DRB_Item */
static int hf_f1ap_qoSFlowIdentifier = -1;        /* QoSFlowIdentifier */
static int hf_f1ap_qoSFlowLevelQoSParameters = -1;  /* QoSFlowLevelQoSParameters */
static int hf_f1ap_freqBandIndicatorNr = -1;      /* INTEGER_1_1024_ */
static int hf_f1ap_supportedSULBandList = -1;     /* SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem */
static int hf_f1ap_supportedSULBandList_item = -1;  /* SupportedSULFreqBandItem */
static int hf_f1ap_l839 = -1;                     /* L839Info */
static int hf_f1ap_l139 = -1;                     /* L139Info */
static int hf_f1ap_FlowsMappedToSLDRB_List_item = -1;  /* FlowsMappedToSLDRB_Item */
static int hf_f1ap_pc5QoSFlowIdentifier = -1;     /* PC5QoSFlowIdentifier */
static int hf_f1ap_e_RAB_MaximumBitrateDL = -1;   /* BitRate */
static int hf_f1ap_e_RAB_MaximumBitrateUL = -1;   /* BitRate */
static int hf_f1ap_e_RAB_GuaranteedBitrateDL = -1;  /* BitRate */
static int hf_f1ap_e_RAB_GuaranteedBitrateUL = -1;  /* BitRate */
static int hf_f1ap_maxFlowBitRateDownlink = -1;   /* BitRate */
static int hf_f1ap_maxFlowBitRateUplink = -1;     /* BitRate */
static int hf_f1ap_guaranteedFlowBitRateDownlink = -1;  /* BitRate */
static int hf_f1ap_guaranteedFlowBitRateUplink = -1;  /* BitRate */
static int hf_f1ap_maxPacketLossRateDownlink = -1;  /* MaxPacketLossRate */
static int hf_f1ap_maxPacketLossRateUplink = -1;  /* MaxPacketLossRate */
static int hf_f1ap_tRPPositionDefinitionType = -1;  /* TRPPositionDefinitionType */
static int hf_f1ap_dLPRSResourceCoordinates = -1;  /* DLPRSResourceCoordinates */
static int hf_f1ap_sibtypetobeupdatedlist = -1;   /* SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem */
static int hf_f1ap_sibtypetobeupdatedlist_item = -1;  /* SibtypetobeupdatedListItem */
static int hf_f1ap_tNLAssociationTransportLayerAddress = -1;  /* CP_TransportLayerAddress */
static int hf_f1ap_tNLAssociationUsage = -1;      /* TNLAssociationUsage */
static int hf_f1ap_subcarrierSpacing_01 = -1;     /* SubcarrierSpacing */
static int hf_f1ap_dUFTransmissionPeriodicity = -1;  /* DUFTransmissionPeriodicity */
static int hf_f1ap_dUF_Slot_Config_List = -1;     /* DUF_Slot_Config_List */
static int hf_f1ap_hSNATransmissionPeriodicity = -1;  /* HSNATransmissionPeriodicity */
static int hf_f1ap_hNSASlotConfigList = -1;       /* HSNASlotConfigList */
static int hf_f1ap_gNB_CU_NameVisibleString = -1;  /* GNB_CU_NameVisibleString */
static int hf_f1ap_gNB_CU_NameUTF8String = -1;    /* GNB_CU_NameUTF8String */
static int hf_f1ap_gNB_DU_NameVisibleString = -1;  /* GNB_DU_NameVisibleString */
static int hf_f1ap_gNB_DU_NameUTF8String = -1;    /* GNB_DU_NameUTF8String */
static int hf_f1ap_served_Cell_Information = -1;  /* Served_Cell_Information */
static int hf_f1ap_gNB_DU_System_Information = -1;  /* GNB_DU_System_Information */
static int hf_f1ap_mIB_message = -1;              /* MIB_message */
static int hf_f1ap_sIB1_message = -1;             /* SIB1_message */
static int hf_f1ap_tNLAssociationTransportLayerAddressgNBCU = -1;  /* CP_TransportLayerAddress */
static int hf_f1ap_rxTxTimeDiff = -1;             /* GNBRxTxTimeDiffMeas */
static int hf_f1ap_additionalPath_List = -1;      /* AdditionalPath_List */
static int hf_f1ap_k0 = -1;                       /* INTEGER_0_1970049 */
static int hf_f1ap_k1 = -1;                       /* INTEGER_0_985025 */
static int hf_f1ap_k2 = -1;                       /* INTEGER_0_492513 */
static int hf_f1ap_k3 = -1;                       /* INTEGER_0_246257 */
static int hf_f1ap_k4 = -1;                       /* INTEGER_0_123129 */
static int hf_f1ap_k5 = -1;                       /* INTEGER_0_61565 */
static int hf_f1ap_GTPTLAs_item = -1;             /* GTPTLA_Item */
static int hf_f1ap_gTPTransportLayerAddress = -1;  /* TransportLayerAddress */
static int hf_f1ap_transportLayerAddress = -1;    /* TransportLayerAddress */
static int hf_f1ap_gTP_TEID = -1;                 /* GTP_TEID */
static int hf_f1ap_dLHardwareLoadIndicator = -1;  /* INTEGER_0_100_ */
static int hf_f1ap_uLHardwareLoadIndicator = -1;  /* INTEGER_0_100_ */
static int hf_f1ap_HSNASlotConfigList_item = -1;  /* HSNASlotConfigItem */
static int hf_f1ap_hSNADownlink = -1;             /* HSNADownlink */
static int hf_f1ap_hSNAUplink = -1;               /* HSNAUplink */
static int hf_f1ap_hSNAFlexible = -1;             /* HSNAFlexible */
static int hf_f1ap_IAB_MT_Cell_List_item = -1;    /* IAB_MT_Cell_List_Item */
static int hf_f1ap_nRCellIdentity = -1;           /* NRCellIdentity */
static int hf_f1ap_dU_RX_MT_RX = -1;              /* DU_RX_MT_RX */
static int hf_f1ap_dU_TX_MT_TX = -1;              /* DU_TX_MT_TX */
static int hf_f1ap_dU_RX_MT_TX = -1;              /* DU_RX_MT_TX */
static int hf_f1ap_dU_TX_MT_RX = -1;              /* DU_TX_MT_RX */
static int hf_f1ap_iAB_STC_Info_List = -1;        /* IAB_STC_Info_List */
static int hf_f1ap_IAB_STC_Info_List_item = -1;   /* IAB_STC_Info_Item */
static int hf_f1ap_sSB_freqInfo = -1;             /* SSB_freqInfo */
static int hf_f1ap_sSB_subcarrierSpacing = -1;    /* SSB_subcarrierSpacing */
static int hf_f1ap_sSB_transmissionPeriodicity = -1;  /* SSB_transmissionPeriodicity */
static int hf_f1ap_sSB_transmissionTimingOffset = -1;  /* SSB_transmissionTimingOffset */
static int hf_f1ap_sSB_transmissionBitmap = -1;   /* SSB_transmissionBitmap */
static int hf_f1ap_iABTNLAddress = -1;            /* IABTNLAddress */
static int hf_f1ap_iABTNLAddressUsage = -1;       /* IABTNLAddressUsage */
static int hf_f1ap_fDD_01 = -1;                   /* IAB_DU_Cell_Resource_Configuration_FDD_Info */
static int hf_f1ap_tDD_01 = -1;                   /* IAB_DU_Cell_Resource_Configuration_TDD_Info */
static int hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_UL = -1;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_DL = -1;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_gNB_DU_Cell_Resourc_Configuration_TDD = -1;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_iPv6Address = -1;              /* IABTNLAddressesRequested */
static int hf_f1ap_iPv6Prefix = -1;               /* IABTNLAddressesRequested */
static int hf_f1ap_iPv4Address = -1;              /* T_iPv4Address */
static int hf_f1ap_iPv6Address_01 = -1;           /* T_iPv6Address */
static int hf_f1ap_iPv6Prefix_01 = -1;            /* T_iPv6Prefix */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedAllTraffic = -1;  /* INTEGER_1_256 */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedF1_C = -1;  /* INTEGER_1_256 */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedF1_U = -1;  /* INTEGER_1_256 */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedNoNF1 = -1;  /* INTEGER_1_256 */
static int hf_f1ap_iABv4AddressesRequested = -1;  /* IABTNLAddressesRequested */
static int hf_f1ap_dUFSlotformatIndex = -1;       /* DUFSlotformatIndex */
static int hf_f1ap_nRSCS = -1;                    /* T_nRSCS */
static int hf_f1ap_nRCP = -1;                     /* T_nRCP */
static int hf_f1ap_nRDLULTxPeriodicity = -1;      /* T_nRDLULTxPeriodicity */
static int hf_f1ap_slot_Configuration_List = -1;  /* Slot_Configuration_List */
static int hf_f1ap_destinationIABTNLAddress = -1;  /* IABTNLAddress */
static int hf_f1ap_dsInformationList = -1;        /* DSInformationList */
static int hf_f1ap_iPv6FlowLabel = -1;            /* BIT_STRING_SIZE_20 */
static int hf_f1ap_iPtolayer2TrafficMappingInfoToAdd = -1;  /* IPtolayer2TrafficMappingInfoList */
static int hf_f1ap_iPtolayer2TrafficMappingInfoToRemove = -1;  /* MappingInformationtoRemove */
static int hf_f1ap_IPtolayer2TrafficMappingInfoList_item = -1;  /* IPtolayer2TrafficMappingInfo_Item */
static int hf_f1ap_iPHeaderInformation = -1;      /* IPHeaderInformation */
static int hf_f1ap_bHInfo = -1;                   /* BHInfo */
static int hf_f1ap_msg1SCS = -1;                  /* T_msg1SCS */
static int hf_f1ap_rootSequenceIndex_01 = -1;     /* INTEGER_0_137 */
static int hf_f1ap_iE_Extension = -1;             /* ProtocolExtensionContainer */
static int hf_f1ap_restrictedSetConfig = -1;      /* T_restrictedSetConfig */
static int hf_f1ap_alpha = -1;                    /* INTEGER_0_3599 */
static int hf_f1ap_beta = -1;                     /* INTEGER_0_3599 */
static int hf_f1ap_gamma = -1;                    /* INTEGER_0_3599 */
static int hf_f1ap_LCStoGCSTranslationList_item = -1;  /* LCStoGCSTranslation */
static int hf_f1ap_alpha_01 = -1;                 /* INTEGER_0_359 */
static int hf_f1ap_alpha_fine = -1;               /* INTEGER_0_9 */
static int hf_f1ap_beta_01 = -1;                  /* INTEGER_0_359 */
static int hf_f1ap_beta_fine = -1;                /* INTEGER_0_9 */
static int hf_f1ap_gamma_01 = -1;                 /* INTEGER_0_359 */
static int hf_f1ap_gamma_fine = -1;               /* INTEGER_0_9 */
static int hf_f1ap_horizontalUncertainty = -1;    /* INTEGER_0_255 */
static int hf_f1ap_horizontalConfidence = -1;     /* INTEGER_0_100 */
static int hf_f1ap_verticalUncertainty = -1;      /* INTEGER_0_255 */
static int hf_f1ap_verticalConfidence = -1;       /* INTEGER_0_100 */
static int hf_f1ap_uELTESidelinkAggregateMaximumBitrate = -1;  /* BitRate */
static int hf_f1ap_vehicleUE = -1;                /* VehicleUE */
static int hf_f1ap_pedestrianUE = -1;             /* PedestrianUE */
static int hf_f1ap_MappingInformationtoRemove_item = -1;  /* MappingInformationIndex */
static int hf_f1ap_pRS_Resource_ID = -1;          /* PRS_Resource_ID */
static int hf_f1ap_pRS_Resource_Set_ID = -1;      /* PRS_Resource_Set_ID */
static int hf_f1ap_sSB_Index = -1;                /* SSB_Index */
static int hf_f1ap_iAB_MT_Cell_List = -1;         /* IAB_MT_Cell_List */
static int hf_f1ap_m5period = -1;                 /* M5period */
static int hf_f1ap_m5_links_to_log = -1;          /* M5_Links_to_log */
static int hf_f1ap_m6report_Interval = -1;        /* M6report_Interval */
static int hf_f1ap_m6_links_to_log = -1;          /* M6_Links_to_log */
static int hf_f1ap_m7period = -1;                 /* M7period */
static int hf_f1ap_m7_links_to_log = -1;          /* M7_Links_to_log */
static int hf_f1ap_mdt_Activation = -1;           /* MDT_Activation */
static int hf_f1ap_measurementsToActivate = -1;   /* MeasurementsToActivate */
static int hf_f1ap_m2Configuration = -1;          /* M2Configuration */
static int hf_f1ap_m5Configuration = -1;          /* M5Configuration */
static int hf_f1ap_m6Configuration = -1;          /* M6Configuration */
static int hf_f1ap_m7Configuration = -1;          /* M7Configuration */
static int hf_f1ap_MDTPLMNList_item = -1;         /* PLMN_Identity */
static int hf_f1ap_uL_AngleOfArrival = -1;        /* UL_AoA */
static int hf_f1ap_uL_SRS_RSRP = -1;              /* UL_SRS_RSRP */
static int hf_f1ap_uL_RTOA = -1;                  /* UL_RTOA_Measurement */
static int hf_f1ap_gNB_RxTxTimeDiff = -1;         /* GNB_RxTxTimeDiff */
static int hf_f1ap_intendedTDD_DL_ULConfig = -1;  /* IntendedTDD_DL_ULConfig */
static int hf_f1ap_latitude_01 = -1;              /* INTEGER_M2147483648_2147483647 */
static int hf_f1ap_longitude_01 = -1;             /* INTEGER_M2147483648_2147483647 */
static int hf_f1ap_altitude_01 = -1;              /* INTEGER_M64000_1280000 */
static int hf_f1ap_uncertaintySemi_major_01 = -1;  /* INTEGER_0_255 */
static int hf_f1ap_uncertaintySemi_minor_01 = -1;  /* INTEGER_0_255 */
static int hf_f1ap_uncertaintyAltitude_01 = -1;   /* INTEGER_0_255 */
static int hf_f1ap_nR_PRSBeamInformationList = -1;  /* NR_PRSBeamInformationList */
static int hf_f1ap_lCStoGCSTranslationList = -1;  /* LCStoGCSTranslationList */
static int hf_f1ap_NR_PRSBeamInformationList_item = -1;  /* NR_PRSBeamInformationItem */
static int hf_f1ap_pRSResourceSetID = -1;         /* PRS_Resource_Set_ID */
static int hf_f1ap_pRSAngleList = -1;             /* PRSAngleList */
static int hf_f1ap_message_Identifier = -1;       /* MessageIdentifier */
static int hf_f1ap_serialNumber = -1;             /* SerialNumber */
static int hf_f1ap_sNPN_Broadcast_Information = -1;  /* NPN_Broadcast_Information_SNPN */
static int hf_f1ap_pNI_NPN_Broadcast_Information = -1;  /* NPN_Broadcast_Information_PNI_NPN */
static int hf_f1ap_broadcastSNPNID_List = -1;     /* BroadcastSNPN_ID_List */
static int hf_f1ap_broadcastPNI_NPN_ID_Information = -1;  /* BroadcastPNI_NPN_ID_List */
static int hf_f1ap_sNPN_Information = -1;         /* NID */
static int hf_f1ap_NRCarrierList_item = -1;       /* NRCarrierItem */
static int hf_f1ap_carrierSCS = -1;               /* NRSCS */
static int hf_f1ap_offsetToCarrier = -1;          /* INTEGER_0_2199_ */
static int hf_f1ap_carrierBandwidth = -1;         /* INTEGER_0_maxnoofPhysicalResourceBlocks_ */
static int hf_f1ap_nRARFCN = -1;                  /* INTEGER_0_maxNRARFCN */
static int hf_f1ap_sul_Information = -1;          /* SUL_Information */
static int hf_f1ap_freqBandListNr = -1;           /* SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem */
static int hf_f1ap_freqBandListNr_item = -1;      /* FreqBandNrItem */
static int hf_f1ap_fDD_02 = -1;                   /* FDD_Info */
static int hf_f1ap_tDD_02 = -1;                   /* TDD_Info */
static int hf_f1ap_ulPRACHConfigList = -1;        /* NRPRACHConfigList */
static int hf_f1ap_sulPRACHConfigList = -1;       /* NRPRACHConfigList */
static int hf_f1ap_NRPRACHConfigList_item = -1;   /* NRPRACHConfigItem */
static int hf_f1ap_nRSCS_01 = -1;                 /* NRSCS */
static int hf_f1ap_prachFreqStartfromCarrier = -1;  /* INTEGER_0_maxnoofPhysicalResourceBlocks_1_ */
static int hf_f1ap_msg1FDM = -1;                  /* T_msg1FDM */
static int hf_f1ap_parchConfigIndex = -1;         /* INTEGER_0_255_ */
static int hf_f1ap_ssb_perRACH_Occasion = -1;     /* T_ssb_perRACH_Occasion */
static int hf_f1ap_freqDomainLength = -1;         /* FreqDomainLength */
static int hf_f1ap_zeroCorrelZoneConfig = -1;     /* INTEGER_0_15 */
static int hf_f1ap_numDLSymbols = -1;             /* INTEGER_0_13_ */
static int hf_f1ap_numULSymbols = -1;             /* INTEGER_0_13_ */
static int hf_f1ap_uENRSidelinkAggregateMaximumBitrate = -1;  /* BitRate */
static int hf_f1ap_pER_Scalar = -1;               /* PER_Scalar */
static int hf_f1ap_pER_Exponent = -1;             /* PER_Exponent */
static int hf_f1ap_rANUEPagingIdentity = -1;      /* RANUEPagingIdentity */
static int hf_f1ap_cNUEPagingIdentity = -1;       /* CNUEPagingIdentity */
static int hf_f1ap_k0_01 = -1;                    /* INTEGER_0_16351 */
static int hf_f1ap_k1_01 = -1;                    /* INTEGER_0_8176 */
static int hf_f1ap_k2_01 = -1;                    /* INTEGER_0_4088 */
static int hf_f1ap_k3_01 = -1;                    /* INTEGER_0_2044 */
static int hf_f1ap_k4_01 = -1;                    /* INTEGER_0_1022 */
static int hf_f1ap_k5_01 = -1;                    /* INTEGER_0_511 */
static int hf_f1ap_pathlossReferenceSignal = -1;  /* PathlossReferenceSignal */
static int hf_f1ap_sSB = -1;                      /* SSB */
static int hf_f1ap_dL_PRS = -1;                   /* DL_PRS */
static int hf_f1ap_non_Dynamic_PQI = -1;          /* NonDynamicPQIDescriptor */
static int hf_f1ap_dynamic_PQI = -1;              /* DynamicPQIDescriptor */
static int hf_f1ap_pC5_QoS_Characteristics = -1;  /* PC5_QoS_Characteristics */
static int hf_f1ap_pC5_QoS_Flow_Bit_Rates = -1;   /* PC5FlowBitRates */
static int hf_f1ap_guaranteedFlowBitRate = -1;    /* BitRate */
static int hf_f1ap_maximumFlowBitRate = -1;       /* BitRate */
static int hf_f1ap_PeriodicityList_item = -1;     /* PeriodicityList_Item */
static int hf_f1ap_periodicitySRS = -1;           /* PeriodicitySRS */
static int hf_f1ap_PositioningBroadcastCells_item = -1;  /* NRCGI */
static int hf_f1ap_PosMeasurementQuantities_item = -1;  /* PosMeasurementQuantities_Item */
static int hf_f1ap_posMeasurementType = -1;       /* PosMeasurementType */
static int hf_f1ap_timingReportingGranularityFactor = -1;  /* INTEGER_0_5 */
static int hf_f1ap_PosMeasurementResult_item = -1;  /* PosMeasurementResultItem */
static int hf_f1ap_measuredResultsValue = -1;     /* MeasuredResultsValue */
static int hf_f1ap_timeStamp = -1;                /* TimeStamp */
static int hf_f1ap_measurementQuality = -1;       /* TRPMeasurementQuality */
static int hf_f1ap_measurementBeamInfo = -1;      /* MeasurementBeamInfo */
static int hf_f1ap_PosMeasurementResultList_item = -1;  /* PosMeasurementResultList_Item */
static int hf_f1ap_posMeasurementResult = -1;     /* PosMeasurementResult */
static int hf_f1ap_tRPID = -1;                    /* TRPID */
static int hf_f1ap_periodic = -1;                 /* PosResourceSetTypePR */
static int hf_f1ap_semi_persistent = -1;          /* PosResourceSetTypeSP */
static int hf_f1ap_aperiodic = -1;                /* PosResourceSetTypeAP */
static int hf_f1ap_posperiodicSet = -1;           /* T_posperiodicSet */
static int hf_f1ap_possemi_persistentSet = -1;    /* T_possemi_persistentSet */
static int hf_f1ap_sRSResourceTrigger_List = -1;  /* INTEGER_1_3 */
static int hf_f1ap_PosSRSResourceID_List_item = -1;  /* SRSPosResourceID */
static int hf_f1ap_srs_PosResourceId = -1;        /* SRSPosResourceID */
static int hf_f1ap_transmissionCombPos = -1;      /* TransmissionCombPos */
static int hf_f1ap_startPosition = -1;            /* INTEGER_0_13 */
static int hf_f1ap_nrofSymbols = -1;              /* T_nrofSymbols */
static int hf_f1ap_freqDomainShift = -1;          /* INTEGER_0_268 */
static int hf_f1ap_c_SRS = -1;                    /* INTEGER_0_63 */
static int hf_f1ap_groupOrSequenceHopping = -1;   /* T_groupOrSequenceHopping */
static int hf_f1ap_resourceTypePos = -1;          /* ResourceTypePos */
static int hf_f1ap_sequenceId = -1;               /* INTEGER_0_65535 */
static int hf_f1ap_spatialRelationPos = -1;       /* SpatialRelationPos */
static int hf_f1ap_PosSRSResource_List_item = -1;  /* PosSRSResource_Item */
static int hf_f1ap_possrsResourceSetID = -1;      /* INTEGER_0_15 */
static int hf_f1ap_possRSResourceID_List = -1;    /* PosSRSResourceID_List */
static int hf_f1ap_posresourceSetType = -1;       /* PosResourceSetType */
static int hf_f1ap_PosSRSResourceSet_List_item = -1;  /* PosSRSResourceSet_Item */
static int hf_f1ap_spectrumSharingGroupID = -1;   /* SpectrumSharingGroupID */
static int hf_f1ap_eUTRACells_List = -1;          /* EUTRACells_List */
static int hf_f1ap_pRSResourceSet_List = -1;      /* PRSResourceSet_List */
static int hf_f1ap_pRS_IDPos = -1;                /* INTEGER_0_255 */
static int hf_f1ap_pRS_Resource_Set_IDPos = -1;   /* INTEGER_0_7 */
static int hf_f1ap_pRS_Resource_IDPos = -1;       /* INTEGER_0_63 */
static int hf_f1ap_potential_SpCell_ID = -1;      /* NRCGI */
static int hf_f1ap_PRSAngleList_item = -1;        /* PRSAngleItem */
static int hf_f1ap_nR_PRS_Azimuth = -1;           /* INTEGER_0_359 */
static int hf_f1ap_nR_PRS_Azimuth_fine = -1;      /* INTEGER_0_9 */
static int hf_f1ap_nR_PRS_Elevation = -1;         /* INTEGER_0_180 */
static int hf_f1ap_nR_PRS_Elevation_fine = -1;    /* INTEGER_0_9 */
static int hf_f1ap_pRSMutingOption1 = -1;         /* PRSMutingOption1 */
static int hf_f1ap_pRSMutingOption2 = -1;         /* PRSMutingOption2 */
static int hf_f1ap_mutingPattern = -1;            /* DL_PRSMutingPattern */
static int hf_f1ap_mutingBitRepetitionFactor = -1;  /* T_mutingBitRepetitionFactor */
static int hf_f1ap_PRSResource_List_item = -1;    /* PRSResource_Item */
static int hf_f1ap_pRSResourceID = -1;            /* PRS_Resource_ID */
static int hf_f1ap_sequenceID = -1;               /* INTEGER_0_4095 */
static int hf_f1ap_rEOffset = -1;                 /* INTEGER_0_11_ */
static int hf_f1ap_resourceSlotOffset = -1;       /* INTEGER_0_511 */
static int hf_f1ap_resourceSymbolOffset = -1;     /* INTEGER_0_12 */
static int hf_f1ap_qCLInfo = -1;                  /* PRSResource_QCLInfo */
static int hf_f1ap_qCLSourceSSB = -1;             /* PRSResource_QCLSourceSSB */
static int hf_f1ap_qCLSourcePRS = -1;             /* PRSResource_QCLSourcePRS */
static int hf_f1ap_pCI_NR = -1;                   /* INTEGER_0_1007 */
static int hf_f1ap_qCLSourcePRSResourceSetID = -1;  /* PRS_Resource_Set_ID */
static int hf_f1ap_qCLSourcePRSResourceID = -1;   /* PRS_Resource_ID */
static int hf_f1ap_PRSResourceSet_List_item = -1;  /* PRSResourceSet_Item */
static int hf_f1ap_subcarrierSpacing_02 = -1;     /* T_subcarrierSpacing_01 */
static int hf_f1ap_pRSbandwidth = -1;             /* INTEGER_1_63 */
static int hf_f1ap_startPRB = -1;                 /* INTEGER_0_2176 */
static int hf_f1ap_pointA = -1;                   /* INTEGER_0_3279165 */
static int hf_f1ap_combSize = -1;                 /* T_combSize */
static int hf_f1ap_cPType = -1;                   /* T_cPType */
static int hf_f1ap_resourceSetPeriodicity = -1;   /* T_resourceSetPeriodicity */
static int hf_f1ap_resourceSetSlotOffset = -1;    /* INTEGER_0_81919_ */
static int hf_f1ap_resourceRepetitionFactor = -1;  /* T_resourceRepetitionFactor */
static int hf_f1ap_resourceTimeGap = -1;          /* T_resourceTimeGap */
static int hf_f1ap_resourceNumberofSymbols = -1;  /* T_resourceNumberofSymbols */
static int hf_f1ap_pRSMuting = -1;                /* PRSMuting */
static int hf_f1ap_pRSResourceTransmitPower = -1;  /* INTEGER_M60_50 */
static int hf_f1ap_pRSResource_List = -1;         /* PRSResource_List */
static int hf_f1ap_sIBtype = -1;                  /* SIBType_PWS */
static int hf_f1ap_sIBmessage = -1;               /* T_sIBmessage */
static int hf_f1ap_non_Dynamic_5QI = -1;          /* NonDynamic5QIDescriptor */
static int hf_f1ap_dynamic_5QI = -1;              /* Dynamic5QIDescriptor */
static int hf_f1ap_qoS_Characteristics = -1;      /* QoS_Characteristics */
static int hf_f1ap_nGRANallocationRetentionPriority = -1;  /* NGRANAllocationAndRetentionPriority */
static int hf_f1ap_gBR_QoS_Flow_Information = -1;  /* GBR_QoSFlowInformation */
static int hf_f1ap_reflective_QoS_Attribute = -1;  /* T_reflective_QoS_Attribute */
static int hf_f1ap_eUTRANQoS = -1;                /* EUTRANQoS */
static int hf_f1ap_RACHReportInformationList_item = -1;  /* RACHReportInformationItem */
static int hf_f1ap_rACHReportContainer = -1;      /* RACHReportContainer */
static int hf_f1ap_uEAssitantIdentifier = -1;     /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_sSBAreaRadioResourceStatusList = -1;  /* SSBAreaRadioResourceStatusList */
static int hf_f1ap_iRNTI = -1;                    /* BIT_STRING_SIZE_40 */
static int hf_f1ap_eNDC = -1;                     /* SubscriberProfileIDforRFP */
static int hf_f1ap_nGRAN = -1;                    /* RAT_FrequencySelectionPriority */
static int hf_f1ap_coordinateID = -1;             /* CoordinateID */
static int hf_f1ap_referencePointCoordinate = -1;  /* AccessPointPosition */
static int hf_f1ap_referencePointCoordinateHA = -1;  /* NGRANHighAccuracyAccessPointPosition */
static int hf_f1ap_nZP_CSI_RS = -1;               /* NZP_CSI_RS_ResourceID */
static int hf_f1ap_sRS = -1;                      /* SRSResourceID */
static int hf_f1ap_positioningSRS = -1;           /* SRSPosResourceID */
static int hf_f1ap_xYZunit = -1;                  /* T_xYZunit */
static int hf_f1ap_xvalue = -1;                   /* INTEGER_M65536_65535 */
static int hf_f1ap_yvalue = -1;                   /* INTEGER_M65536_65535 */
static int hf_f1ap_zvalue = -1;                   /* INTEGER_M32768_32767 */
static int hf_f1ap_locationUncertainty = -1;      /* LocationUncertainty */
static int hf_f1ap_milli_Arc_SecondUnits = -1;    /* T_milli_Arc_SecondUnits */
static int hf_f1ap_heightUnits = -1;              /* T_heightUnits */
static int hf_f1ap_deltaLatitude = -1;            /* INTEGER_M1024_1023 */
static int hf_f1ap_deltaLongitude = -1;           /* INTEGER_M1024_1023 */
static int hf_f1ap_deltaHeight = -1;              /* INTEGER_M1024_1023 */
static int hf_f1ap_iE_extensions = -1;            /* ProtocolExtensionContainer */
static int hf_f1ap_numberOfTransmissions = -1;    /* INTEGER_0_500_ */
static int hf_f1ap_resourceType_01 = -1;          /* T_resourceType_01 */
static int hf_f1ap_bandwidthSRS = -1;             /* BandwidthSRS */
static int hf_f1ap_sRSResourceSetList = -1;       /* SRSResourceSetList */
static int hf_f1ap_sSBInformation = -1;           /* SSBInformation */
static int hf_f1ap_eUTRA_Mode_Info = -1;          /* EUTRA_Coex_Mode_Info */
static int hf_f1ap_eUTRA_PRACH_Configuration = -1;  /* EUTRA_PRACH_Configuration */
static int hf_f1ap_meNB_Cell_ID = -1;             /* EUTRA_Cell_ID */
static int hf_f1ap_resourceCoordinationEUTRACellInfo = -1;  /* ResourceCoordinationEUTRACellInfo */
static int hf_f1ap_periodic_01 = -1;              /* ResourceSetTypePeriodic */
static int hf_f1ap_semi_persistent_01 = -1;       /* ResourceSetTypeSemi_persistent */
static int hf_f1ap_aperiodic_01 = -1;             /* ResourceSetTypeAperiodic */
static int hf_f1ap_periodicSet = -1;              /* T_periodicSet */
static int hf_f1ap_semi_persistentSet = -1;       /* T_semi_persistentSet */
static int hf_f1ap_slotoffset = -1;               /* INTEGER_0_32 */
static int hf_f1ap_eventType = -1;                /* EventType */
static int hf_f1ap_reportingPeriodicityValue = -1;  /* ReportingPeriodicityValue */
static int hf_f1ap_periodic_02 = -1;              /* ResourceTypePeriodic */
static int hf_f1ap_semi_persistent_02 = -1;       /* ResourceTypeSemi_persistent */
static int hf_f1ap_aperiodic_02 = -1;             /* ResourceTypeAperiodic */
static int hf_f1ap_periodicity = -1;              /* T_periodicity */
static int hf_f1ap_offset = -1;                   /* INTEGER_0_2559_ */
static int hf_f1ap_periodicity_01 = -1;           /* T_periodicity_01 */
static int hf_f1ap_aperiodicResourceType = -1;    /* T_aperiodicResourceType */
static int hf_f1ap_periodic_03 = -1;              /* ResourceTypePeriodicPos */
static int hf_f1ap_semi_persistent_03 = -1;       /* ResourceTypeSemi_persistentPos */
static int hf_f1ap_aperiodic_03 = -1;             /* ResourceTypeAperiodicPos */
static int hf_f1ap_periodicity_02 = -1;           /* T_periodicity_02 */
static int hf_f1ap_offset_01 = -1;                /* INTEGER_0_81919_ */
static int hf_f1ap_periodicity_03 = -1;           /* T_periodicity_03 */
static int hf_f1ap_slotOffset = -1;               /* INTEGER_0_32 */
static int hf_f1ap_rLCDuplicationStateList = -1;  /* RLCDuplicationStateList */
static int hf_f1ap_primaryPathIndication = -1;    /* PrimaryPathIndication */
static int hf_f1ap_RLCDuplicationStateList_item = -1;  /* RLCDuplicationState_Item */
static int hf_f1ap_duplicationState = -1;         /* DuplicationState */
static int hf_f1ap_assocatedLCID = -1;            /* LCID */
static int hf_f1ap_reestablishment_Indication = -1;  /* Reestablishment_Indication */
static int hf_f1ap_RLFReportInformationList_item = -1;  /* RLFReportInformationItem */
static int hf_f1ap_nRUERLFReportContainer = -1;   /* NRUERLFReportContainer */
static int hf_f1ap_delivery_status = -1;          /* PDCP_SN */
static int hf_f1ap_triggering_message = -1;       /* PDCP_SN */
static int hf_f1ap_latest_RRC_Version = -1;       /* BIT_STRING_SIZE_3 */
static int hf_f1ap_sCellIndex = -1;               /* SCellIndex */
static int hf_f1ap_sCellULConfigured = -1;        /* CellULConfigured */
static int hf_f1ap_subcarrierSpacing_03 = -1;     /* T_subcarrierSpacing_02 */
static int hf_f1ap_carrierBandwidth_01 = -1;      /* INTEGER_1_275_ */
static int hf_f1ap_expectedPropagationDelay = -1;  /* INTEGER_M3841_3841_ */
static int hf_f1ap_delayUncertainty = -1;         /* INTEGER_1_246_ */
static int hf_f1ap_configured_EPS_TAC = -1;       /* Configured_EPS_TAC */
static int hf_f1ap_servedPLMNs = -1;              /* ServedPLMNs_List */
static int hf_f1ap_nR_Mode_Info = -1;             /* NR_Mode_Info */
static int hf_f1ap_measurementTimingConfiguration = -1;  /* T_measurementTimingConfiguration */
static int hf_f1ap_sFN_Time_Offset = -1;          /* BIT_STRING_SIZE_24 */
static int hf_f1ap_oldNRCGI = -1;                 /* NRCGI */
static int hf_f1ap_eUTRA_Mode_Info_01 = -1;       /* EUTRA_Mode_Info */
static int hf_f1ap_protectedEUTRAResourceIndication = -1;  /* ProtectedEUTRAResourceIndication */
static int hf_f1ap_service_state = -1;            /* Service_State */
static int hf_f1ap_switchingOffOngoing = -1;      /* T_switchingOffOngoing */
static int hf_f1ap_SItype_List_item = -1;         /* SItype_Item */
static int hf_f1ap_sItype = -1;                   /* SItype */
static int hf_f1ap_sIBtype_01 = -1;               /* T_sIBtype */
static int hf_f1ap_sIBmessage_01 = -1;            /* T_sIBmessage_01 */
static int hf_f1ap_valueTag = -1;                 /* INTEGER_0_31_ */
static int hf_f1ap_sLDRB_QoS = -1;                /* PC5QoSParameters */
static int hf_f1ap_flowsMappedToSLDRB_List = -1;  /* FlowsMappedToSLDRB_List */
static int hf_f1ap_sLDRBID = -1;                  /* SLDRBID */
static int hf_f1ap_sLDRBInformation = -1;         /* SLDRBInformation */
static int hf_f1ap_sliceAvailableCapacityList = -1;  /* SliceAvailableCapacityList */
static int hf_f1ap_SliceAvailableCapacityList_item = -1;  /* SliceAvailableCapacityItem */
static int hf_f1ap_sNSSAIAvailableCapacity_List = -1;  /* SNSSAIAvailableCapacity_List */
static int hf_f1ap_SNSSAIAvailableCapacity_List_item = -1;  /* SNSSAIAvailableCapacity_Item */
static int hf_f1ap_sliceAvailableCapacityValueDownlink = -1;  /* INTEGER_0_100 */
static int hf_f1ap_sliceAvailableCapacityValueUplink = -1;  /* INTEGER_0_100 */
static int hf_f1ap_SliceSupportList_item = -1;    /* SliceSupportItem */
static int hf_f1ap_SliceToReportList_item = -1;   /* SliceToReportItem */
static int hf_f1ap_sNSSAIlist = -1;               /* SNSSAI_list */
static int hf_f1ap_SNSSAI_list_item = -1;         /* SNSSAI_Item */
static int hf_f1ap_Slot_Configuration_List_item = -1;  /* Slot_Configuration_Item */
static int hf_f1ap_slotIndex = -1;                /* INTEGER_0_5119_ */
static int hf_f1ap_symbolAllocInSlot = -1;        /* SymbolAllocInSlot */
static int hf_f1ap_sST = -1;                      /* OCTET_STRING_SIZE_1 */
static int hf_f1ap_sD = -1;                       /* OCTET_STRING_SIZE_3 */
static int hf_f1ap_nR_PRSBeamInformation = -1;    /* NR_PRSBeamInformation */
static int hf_f1ap_spatialRelationforResourceID = -1;  /* SpatialRelationforResourceID */
static int hf_f1ap_SpatialRelationforResourceID_item = -1;  /* SpatialRelationforResourceIDItem */
static int hf_f1ap_referenceSignal = -1;          /* ReferenceSignal */
static int hf_f1ap_sSBPos = -1;                   /* SSB */
static int hf_f1ap_pRSInformationPos = -1;        /* PRSInformationPos */
static int hf_f1ap_sRBID = -1;                    /* SRBID */
static int hf_f1ap_duplicationIndication = -1;    /* DuplicationIndication */
static int hf_f1ap_SRSCarrier_List_item = -1;     /* SRSCarrier_List_Item */
static int hf_f1ap_uplinkChannelBW_PerSCS_List = -1;  /* UplinkChannelBW_PerSCS_List */
static int hf_f1ap_activeULBWP = -1;              /* ActiveULBWP */
static int hf_f1ap_pci = -1;                      /* NRPCI */
static int hf_f1ap_sRSResource_List = -1;         /* SRSResource_List */
static int hf_f1ap_posSRSResource_List = -1;      /* PosSRSResource_List */
static int hf_f1ap_sRSResourceSet_List = -1;      /* SRSResourceSet_List */
static int hf_f1ap_posSRSResourceSet_List = -1;   /* PosSRSResourceSet_List */
static int hf_f1ap_sRSCarrier_List = -1;          /* SRSCarrier_List */
static int hf_f1ap_sRSResourceID = -1;            /* SRSResourceID */
static int hf_f1ap_nrofSRS_Ports = -1;            /* T_nrofSRS_Ports */
static int hf_f1ap_transmissionComb = -1;         /* TransmissionComb */
static int hf_f1ap_nrofSymbols_01 = -1;           /* T_nrofSymbols_01 */
static int hf_f1ap_repetitionFactor = -1;         /* T_repetitionFactor */
static int hf_f1ap_freqDomainPosition = -1;       /* INTEGER_0_67 */
static int hf_f1ap_b_SRS = -1;                    /* INTEGER_0_3 */
static int hf_f1ap_b_hop = -1;                    /* INTEGER_0_3 */
static int hf_f1ap_groupOrSequenceHopping_01 = -1;  /* T_groupOrSequenceHopping_01 */
static int hf_f1ap_resourceType_02 = -1;          /* ResourceType */
static int hf_f1ap_sequenceId_01 = -1;            /* INTEGER_0_1023 */
static int hf_f1ap_SRSResourceID_List_item = -1;  /* SRSResourceID */
static int hf_f1ap_SRSResource_List_item = -1;    /* SRSResource */
static int hf_f1ap_sRSResourceID_List = -1;       /* SRSResourceID_List */
static int hf_f1ap_resourceSetType = -1;          /* ResourceSetType */
static int hf_f1ap_SRSResourceSetList_item = -1;  /* SRSResourceSetItem */
static int hf_f1ap_numSRSresourcesperset = -1;    /* INTEGER_1_16_ */
static int hf_f1ap_periodicityList = -1;          /* PeriodicityList */
static int hf_f1ap_spatialRelationInfo = -1;      /* SpatialRelationInfo */
static int hf_f1ap_pathlossReferenceInfo = -1;    /* PathlossReferenceInfo */
static int hf_f1ap_SRSResourceSet_List_item = -1;  /* SRSResourceSet */
static int hf_f1ap_aperiodicSRSResourceTriggerList = -1;  /* AperiodicSRSResourceTriggerList */
static int hf_f1ap_pCI_NR_01 = -1;                /* NRPCI */
static int hf_f1ap_ssb_index = -1;                /* SSB_Index */
static int hf_f1ap_shortBitmap = -1;              /* BIT_STRING_SIZE_4 */
static int hf_f1ap_mediumBitmap = -1;             /* BIT_STRING_SIZE_8 */
static int hf_f1ap_longBitmap = -1;               /* BIT_STRING_SIZE_64 */
static int hf_f1ap_SSBAreaCapacityValueList_item = -1;  /* SSBAreaCapacityValueItem */
static int hf_f1ap_sSBIndex = -1;                 /* INTEGER_0_63 */
static int hf_f1ap_sSBAreaCapacityValue = -1;     /* INTEGER_0_100 */
static int hf_f1ap_SSBAreaRadioResourceStatusList_item = -1;  /* SSBAreaRadioResourceStatusItem */
static int hf_f1ap_sSBAreaDLGBRPRBusage = -1;     /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaULGBRPRBusage = -1;     /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaDLnon_GBRPRBusage = -1;  /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaULnon_GBRPRBusage = -1;  /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaDLTotalPRBusage = -1;   /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaULTotalPRBusage = -1;   /* INTEGER_0_100 */
static int hf_f1ap_dLschedulingPDCCHCCEusage = -1;  /* INTEGER_0_100 */
static int hf_f1ap_uLschedulingPDCCHCCEusage = -1;  /* INTEGER_0_100 */
static int hf_f1ap_sSBInformationList = -1;       /* SSBInformationList */
static int hf_f1ap_SSBInformationList_item = -1;  /* SSBInformationItem */
static int hf_f1ap_sSB_Configuration = -1;        /* SSB_TF_Configuration */
static int hf_f1ap_sSB_frequency = -1;            /* INTEGER_0_3279165 */
static int hf_f1ap_sSB_subcarrier_spacing = -1;   /* T_sSB_subcarrier_spacing */
static int hf_f1ap_sSB_Transmit_power = -1;       /* INTEGER_M60_50 */
static int hf_f1ap_sSB_periodicity = -1;          /* T_sSB_periodicity */
static int hf_f1ap_sSB_half_frame_offset = -1;    /* INTEGER_0_1 */
static int hf_f1ap_sSB_SFN_offset = -1;           /* INTEGER_0_15 */
static int hf_f1ap_sSB_position_in_burst = -1;    /* SSB_PositionsInBurst */
static int hf_f1ap_sFNInitialisationTime = -1;    /* RelativeTime1900 */
static int hf_f1ap_SSBToReportList_item = -1;     /* SSBToReportItem */
static int hf_f1ap_sUL_NRARFCN = -1;              /* INTEGER_0_maxNRARFCN */
static int hf_f1ap_sUL_transmission_Bandwidth = -1;  /* Transmission_Bandwidth */
static int hf_f1ap_all_DL = -1;                   /* NULL */
static int hf_f1ap_all_UL = -1;                   /* NULL */
static int hf_f1ap_both_DL_and_UL = -1;           /* NumDLULSymbols */
static int hf_f1ap_TargetCellList_item = -1;      /* TargetCellList_Item */
static int hf_f1ap_target_cell = -1;              /* NRCGI */
static int hf_f1ap_nRFreqInfo = -1;               /* NRFreqInfo */
static int hf_f1ap_transmission_Bandwidth_01 = -1;  /* Transmission_Bandwidth */
static int hf_f1ap_referenceTime = -1;            /* ReferenceTime */
static int hf_f1ap_referenceSFN = -1;             /* ReferenceSFN */
static int hf_f1ap_uncertainty = -1;              /* Uncertainty */
static int hf_f1ap_timeInformationType = -1;      /* TimeInformationType */
static int hf_f1ap_systemFrameNumber = -1;        /* SystemFrameNumber */
static int hf_f1ap_slotIndex_01 = -1;             /* TimeStampSlotIndex */
static int hf_f1ap_measurementTime = -1;          /* RelativeTime1900 */
static int hf_f1ap_sCS_15 = -1;                   /* INTEGER_0_9 */
static int hf_f1ap_sCS_30 = -1;                   /* INTEGER_0_19 */
static int hf_f1ap_sCS_60 = -1;                   /* INTEGER_0_39 */
static int hf_f1ap_sCS_120 = -1;                  /* INTEGER_0_79 */
static int hf_f1ap_measurementQuality_01 = -1;    /* INTEGER_0_31 */
static int hf_f1ap_resolution_01 = -1;            /* T_resolution_01 */
static int hf_f1ap_dLTNLOfferedCapacity = -1;     /* INTEGER_1_16777216_ */
static int hf_f1ap_dLTNLAvailableCapacity = -1;   /* INTEGER_0_100_ */
static int hf_f1ap_uLTNLOfferedCapacity = -1;     /* INTEGER_1_16777216_ */
static int hf_f1ap_uLTNLAvailableCapacity = -1;   /* INTEGER_0_100_ */
static int hf_f1ap_traceID = -1;                  /* TraceID */
static int hf_f1ap_interfacesToTrace = -1;        /* InterfacesToTrace */
static int hf_f1ap_traceDepth = -1;               /* TraceDepth */
static int hf_f1ap_traceCollectionEntityIPAddress = -1;  /* TransportLayerAddress */
static int hf_f1ap_iPtolayer2TrafficMappingInfo = -1;  /* IPtolayer2TrafficMappingInfo */
static int hf_f1ap_bAPlayerBHRLCchannelMappingInfo = -1;  /* BAPlayerBHRLCchannelMappingInfo */
static int hf_f1ap_nRNRB = -1;                    /* NRNRB */
static int hf_f1ap_n2 = -1;                       /* T_n2 */
static int hf_f1ap_combOffset_n2 = -1;            /* INTEGER_0_1 */
static int hf_f1ap_cyclicShift_n2 = -1;           /* INTEGER_0_7 */
static int hf_f1ap_n4 = -1;                       /* T_n4 */
static int hf_f1ap_combOffset_n4 = -1;            /* INTEGER_0_3 */
static int hf_f1ap_cyclicShift_n4 = -1;           /* INTEGER_0_11 */
static int hf_f1ap_n2_01 = -1;                    /* T_n2_01 */
static int hf_f1ap_n4_01 = -1;                    /* T_n4_01 */
static int hf_f1ap_n8 = -1;                       /* T_n8 */
static int hf_f1ap_combOffset_n8 = -1;            /* INTEGER_0_7 */
static int hf_f1ap_cyclicShift_n8 = -1;           /* INTEGER_0_5 */
static int hf_f1ap_Transport_UP_Layer_Address_Info_To_Add_List_item = -1;  /* Transport_UP_Layer_Address_Info_To_Add_Item */
static int hf_f1ap_iP_SecTransportLayerAddress = -1;  /* TransportLayerAddress */
static int hf_f1ap_gTPTransportLayerAddressToAdd = -1;  /* GTPTLAs */
static int hf_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List_item = -1;  /* Transport_UP_Layer_Address_Info_To_Remove_Item */
static int hf_f1ap_gTPTransportLayerAddressToRemove = -1;  /* GTPTLAs */
static int hf_f1ap_tRPInformationTypeResponseList = -1;  /* TRPInformationTypeResponseList */
static int hf_f1ap_tRPInformation = -1;           /* TRPInformation */
static int hf_f1ap_TRPInformationTypeResponseList_item = -1;  /* TRPInformationTypeResponseItem */
static int hf_f1ap_nG_RAN_CGI = -1;               /* NRCGI */
static int hf_f1ap_pRSConfiguration = -1;         /* PRSConfiguration */
static int hf_f1ap_sSBinformation = -1;           /* SSBInformation */
static int hf_f1ap_spatialDirectionInformation = -1;  /* SpatialDirectionInformation */
static int hf_f1ap_TRPList_item = -1;             /* TRPListItem */
static int hf_f1ap_tRPmeasurementQuality_Item = -1;  /* TRPMeasurementQuality_Item */
static int hf_f1ap_timingMeasurementQuality = -1;  /* TimingMeasurementQuality */
static int hf_f1ap_angleMeasurementQuality = -1;  /* AngleMeasurementQuality */
static int hf_f1ap_TRP_MeasurementRequestList_item = -1;  /* TRP_MeasurementRequestItem */
static int hf_f1ap_search_window_information = -1;  /* Search_window_information */
static int hf_f1ap_direct = -1;                   /* TRPPositionDirect */
static int hf_f1ap_referenced = -1;               /* TRPPositionReferenced */
static int hf_f1ap_accuracy = -1;                 /* TRPPositionDirectAccuracy */
static int hf_f1ap_tRPPosition = -1;              /* AccessPointPosition */
static int hf_f1ap_tRPHAposition = -1;            /* NGRANHighAccuracyAccessPointPosition */
static int hf_f1ap_referencePoint = -1;           /* ReferencePoint */
static int hf_f1ap_referencePointType = -1;       /* TRPReferencePointType */
static int hf_f1ap_tRPPositionRelativeGeodetic = -1;  /* RelativeGeodeticLocation */
static int hf_f1ap_tRPPositionRelativeCartesian = -1;  /* RelativeCartesianLocation */
static int hf_f1ap_transport_UP_Layer_Address_Info_To_Add_List = -1;  /* Transport_UP_Layer_Address_Info_To_Add_List */
static int hf_f1ap_transport_UP_Layer_Address_Info_To_Remove_List = -1;  /* Transport_UP_Layer_Address_Info_To_Remove_List */
static int hf_f1ap_periodicity_04 = -1;           /* Periodicity */
static int hf_f1ap_burstArrivalTime = -1;         /* BurstArrivalTime */
static int hf_f1ap_tSCAssistanceInformationDL = -1;  /* TSCAssistanceInformation */
static int hf_f1ap_tSCAssistanceInformationUL = -1;  /* TSCAssistanceInformation */
static int hf_f1ap_uACPLMN_List = -1;             /* UACPLMN_List */
static int hf_f1ap_UACPLMN_List_item = -1;        /* UACPLMN_Item */
static int hf_f1ap_uACType_List = -1;             /* UACType_List */
static int hf_f1ap_UACType_List_item = -1;        /* UACType_Item */
static int hf_f1ap_uACReductionIndication = -1;   /* UACReductionIndication */
static int hf_f1ap_uACCategoryType = -1;          /* UACCategoryType */
static int hf_f1ap_uACstandardized = -1;          /* UACAction */
static int hf_f1ap_uACOperatorDefined = -1;       /* UACOperatorDefined */
static int hf_f1ap_accessCategory = -1;           /* INTEGER_32_63_ */
static int hf_f1ap_accessIdentity = -1;           /* BIT_STRING_SIZE_7 */
static int hf_f1ap_indexLength10 = -1;            /* BIT_STRING_SIZE_10 */
static int hf_f1ap_azimuthAoA = -1;               /* INTEGER_0_3599 */
static int hf_f1ap_zenithAoA = -1;                /* INTEGER_0_1799 */
static int hf_f1ap_lCS_to_GCS_TranslationAoA = -1;  /* LCS_to_GCS_TranslationAoA */
static int hf_f1ap_uL_BH_Non_UP_Traffic_Mapping_List = -1;  /* UL_BH_Non_UP_Traffic_Mapping_List */
static int hf_f1ap_UL_BH_Non_UP_Traffic_Mapping_List_item = -1;  /* UL_BH_Non_UP_Traffic_Mapping_Item */
static int hf_f1ap_nonUPTrafficType = -1;         /* NonUPTrafficType */
static int hf_f1ap_uLUEConfiguration = -1;        /* ULUEConfiguration */
static int hf_f1ap_uL_RTOA_MeasurementItem = -1;  /* UL_RTOA_MeasurementItem */
static int hf_f1ap_uLUPTNLInformation = -1;       /* UPTransportLayerInformation */
static int hf_f1ap_newULUPTNLInformation = -1;    /* UPTransportLayerInformation */
static int hf_f1ap_ULUPTNLInformation_ToBeSetup_List_item = -1;  /* ULUPTNLInformation_ToBeSetup_Item */
static int hf_f1ap_UplinkChannelBW_PerSCS_List_item = -1;  /* SCS_SpecificCarrier */
static int hf_f1ap_gTPTunnel = -1;                /* GTPTunnel */
static int hf_f1ap_protocolIEs = -1;              /* ProtocolIE_Container */
static int hf_f1ap_f1_Interface = -1;             /* ResetAll */
static int hf_f1ap_partOfF1_Interface = -1;       /* UE_associatedLogicalF1_ConnectionListRes */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionListRes_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionListResAck_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_DU_Served_Cells_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_to_be_Activated_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Served_Cells_To_Add_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Served_Cells_To_Modify_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Served_Cells_To_Delete_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Status_List_item = -1;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_Dedicated_SIDelivery_NeededUE_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_DU_TNL_Association_To_Remove_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_to_be_Deactivated_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_To_Add_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_To_Remove_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_To_Update_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_to_be_Barred_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Protected_EUTRA_Resources_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Neighbour_Cell_Information_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Failed_to_be_Activated_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_Setup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Candidate_SpCell_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_ToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_ToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Setup_List_item = -1;     /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_FailedToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_FailedToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_FailedtoSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_Setup_List_item = -1;     /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_Setup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_FailedToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Setup_List_item = -1;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_FailedToBeSetup_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Potential_SpCell_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_ToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_ToBeRemoved_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_ToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_SetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Modified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_SetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_Modified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_FailedToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_FailedToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_FailedToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_FailedtoSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_SetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_Modified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_FailedToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_FailedToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Associated_SCell_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_SetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Modified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_FailedToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_FailedToBeSetupMod_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Required_ToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Required_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_Required_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_Required_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Required_ToBeModified_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Required_ToBeReleased_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ModifiedConf_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ModifiedConf_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_To_Be_Broadcast_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Broadcast_Completed_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Broadcast_To_Be_Cancelled_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Broadcast_Cancelled_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRB_Activity_List_item = -1;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_privateIEs = -1;               /* PrivateIE_Container */
static int hf_f1ap_PagingCell_list_item = -1;     /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRB_Notify_List_item = -1;     /* ProtocolIE_SingleContainer */
static int hf_f1ap_NR_CGI_List_For_Restart_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_PWS_Failed_NR_CGI_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BH_Routing_Information_Added_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BH_Routing_Information_Removed_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_IAB_TNL_Addresses_To_Remove_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_IAB_Allocated_TNL_Address_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UL_UP_TNL_Information_to_Update_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UL_UP_TNL_Address_to_Update_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DL_UP_TNL_Address_to_Update_List_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_TRPInformationTypeListTRPReq_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_TRPInformationListTRPResp_item = -1;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_semipersistentSRS = -1;        /* SemipersistentSRS */
static int hf_f1ap_aperiodicSRS = -1;             /* AperiodicSRS */
static int hf_f1ap_sRSSpatialRelation = -1;       /* SpatialRelationInfo */
static int hf_f1ap_aperiodic_04 = -1;             /* T_aperiodic */
static int hf_f1ap_sRSResourceTrigger = -1;       /* SRSResourceTrigger */
static int hf_f1ap_initiatingMessage = -1;        /* InitiatingMessage */
static int hf_f1ap_successfulOutcome = -1;        /* SuccessfulOutcome */
static int hf_f1ap_unsuccessfulOutcome = -1;      /* UnsuccessfulOutcome */
static int hf_f1ap_initiatingMessagevalue = -1;   /* InitiatingMessage_value */
static int hf_f1ap_successfulOutcome_value = -1;  /* SuccessfulOutcome_value */
static int hf_f1ap_unsuccessfulOutcome_value = -1;  /* UnsuccessfulOutcome_value */

/*--- End of included file: packet-f1ap-hf.c ---*/
#line 74 "./asn1/f1ap/packet-f1ap-template.c"

/* Initialize the subtree pointers */
static gint ett_f1ap = -1;
static gint ett_f1ap_ResourceCoordinationTransferContainer = -1;
static gint ett_f1ap_PLMN_Identity = -1;
static gint ett_f1ap_MIB_message = -1;
static gint ett_f1ap_SIB1_message = -1;
static gint ett_f1ap_CG_ConfigInfo = -1;
static gint ett_f1ap_CellGroupConfig = -1;
static gint ett_f1ap_TransportLayerAddress = -1;
static gint ett_f1ap_UE_CapabilityRAT_ContainerList = -1;
static gint ett_f1ap_measurementTimingConfiguration = -1;
static gint ett_f1ap_DUtoCURRCContainer = -1;
static gint ett_f1ap_requestedP_MaxFR1 = -1;
static gint ett_f1ap_HandoverPreparationInformation = -1;
static gint ett_f1ap_MeasConfig = -1;
static gint ett_f1ap_MeasGapConfig = -1;
static gint ett_f1ap_MeasGapSharingConfig = -1;
static gint ett_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container = -1;
static gint ett_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container = -1;
static gint ett_f1ap_ProtectedEUTRAResourceIndication = -1;
static gint ett_f1ap_RRCContainer = -1;
static gint ett_f1ap_RRCContainer_RRCSetupComplete = -1;
static gint ett_f1ap_sIBmessage = -1;
static gint ett_f1ap_UplinkTxDirectCurrentListInformation = -1;
static gint ett_f1ap_DRX_Config = -1;
static gint ett_f1ap_Ph_InfoSCG = -1;
static gint ett_f1ap_RequestedBandCombinationIndex = -1;
static gint ett_f1ap_RequestedFeatureSetEntryIndex = -1;
static gint ett_f1ap_RequestedP_MaxFR2 = -1;
static gint ett_f1ap_UEAssistanceInformation = -1;
static gint ett_f1ap_CG_Config = -1;
static gint ett_f1ap_Ph_InfoMCG = -1;
static gint ett_f1ap_BurstArrivalTime = -1;
static gint ett_f1ap_cSI_RS_Configuration = -1;
static gint ett_f1ap_sR_Configuration = -1;
static gint ett_f1ap_pDCCH_ConfigSIB1 = -1;
static gint ett_f1ap_sCS_Common = -1;
static gint ett_f1ap_IABTNLAddressIPv4Address = -1;
static gint ett_f1ap_IABTNLAddressIPv6Address = -1;
static gint ett_f1ap_IABTNLAddressIPv6Prefix = -1;
static gint ett_f1ap_InterfacesToTrace = -1;
static gint ett_f1ap_MeasurementsToActivate = -1;
static gint ett_f1ap_NRUERLFReportContainer = -1;
static gint ett_f1ap_RACH_Config_Common = -1;
static gint ett_f1ap_RACH_Config_Common_IAB = -1;
static gint ett_f1ap_RACHReportContainer = -1;
static gint ett_f1ap_ReferenceTime = -1;
static gint ett_f1ap_ReportCharacteristics = -1;
static gint ett_f1ap_SIB10_message = -1;
static gint ett_f1ap_SIB12_message = -1;
static gint ett_f1ap_SIB13_message = -1;
static gint ett_f1ap_SIB14_message = -1;
static gint ett_f1ap_SL_PHY_MAC_RLC_Config = -1;
static gint ett_f1ap_SL_ConfigDedicatedEUTRA_Info = -1;
static gint ett_f1ap_TDD_UL_DLConfigCommonNR = -1;
static gint ett_f1ap_UEAssistanceInformationEUTRA = -1;
static gint ett_f1ap_PosAssistance_Information = -1;

/*--- Included file: packet-f1ap-ett.c ---*/
#line 1 "./asn1/f1ap/packet-f1ap-ett.c"
static gint ett_f1ap_PrivateIE_ID = -1;
static gint ett_f1ap_ProtocolIE_Container = -1;
static gint ett_f1ap_ProtocolIE_Field = -1;
static gint ett_f1ap_ProtocolExtensionContainer = -1;
static gint ett_f1ap_ProtocolExtensionField = -1;
static gint ett_f1ap_PrivateIE_Container = -1;
static gint ett_f1ap_PrivateIE_Field = -1;
static gint ett_f1ap_AbortTransmission = -1;
static gint ett_f1ap_AccessPointPosition = -1;
static gint ett_f1ap_Activated_Cells_to_be_Updated_List = -1;
static gint ett_f1ap_Activated_Cells_to_be_Updated_List_Item = -1;
static gint ett_f1ap_ActiveULBWP = -1;
static gint ett_f1ap_AdditionalPath_List = -1;
static gint ett_f1ap_AdditionalPath_Item = -1;
static gint ett_f1ap_AdditionalPDCPDuplicationTNL_List = -1;
static gint ett_f1ap_AdditionalPDCPDuplicationTNL_Item = -1;
static gint ett_f1ap_AdditionalSIBMessageList = -1;
static gint ett_f1ap_AdditionalSIBMessageList_Item = -1;
static gint ett_f1ap_AggressorCellList = -1;
static gint ett_f1ap_AggressorCellList_Item = -1;
static gint ett_f1ap_AggressorgNBSetID = -1;
static gint ett_f1ap_AllocationAndRetentionPriority = -1;
static gint ett_f1ap_AlternativeQoSParaSetList = -1;
static gint ett_f1ap_AlternativeQoSParaSetItem = -1;
static gint ett_f1ap_AngleMeasurementQuality = -1;
static gint ett_f1ap_AperiodicSRSResourceTriggerList = -1;
static gint ett_f1ap_Associated_SCell_Item = -1;
static gint ett_f1ap_AvailablePLMNList = -1;
static gint ett_f1ap_AvailablePLMNList_Item = -1;
static gint ett_f1ap_AvailableSNPN_ID_List = -1;
static gint ett_f1ap_AvailableSNPN_ID_List_Item = -1;
static gint ett_f1ap_BandwidthSRS = -1;
static gint ett_f1ap_BAPlayerBHRLCchannelMappingInfo = -1;
static gint ett_f1ap_BAPlayerBHRLCchannelMappingInfoList = -1;
static gint ett_f1ap_BAPlayerBHRLCchannelMappingInfo_Item = -1;
static gint ett_f1ap_BAPRoutingID = -1;
static gint ett_f1ap_BHChannels_FailedToBeModified_Item = -1;
static gint ett_f1ap_BHChannels_FailedToBeSetup_Item = -1;
static gint ett_f1ap_BHChannels_FailedToBeSetupMod_Item = -1;
static gint ett_f1ap_BHChannels_Modified_Item = -1;
static gint ett_f1ap_BHChannels_Required_ToBeReleased_Item = -1;
static gint ett_f1ap_BHChannels_Setup_Item = -1;
static gint ett_f1ap_BHChannels_SetupMod_Item = -1;
static gint ett_f1ap_BHChannels_ToBeModified_Item = -1;
static gint ett_f1ap_BHChannels_ToBeReleased_Item = -1;
static gint ett_f1ap_BHChannels_ToBeSetup_Item = -1;
static gint ett_f1ap_BHChannels_ToBeSetupMod_Item = -1;
static gint ett_f1ap_BHInfo = -1;
static gint ett_f1ap_BHQoSInformation = -1;
static gint ett_f1ap_BH_Routing_Information_Added_List_Item = -1;
static gint ett_f1ap_BH_Routing_Information_Removed_List_Item = -1;
static gint ett_f1ap_BPLMN_ID_Info_List = -1;
static gint ett_f1ap_BPLMN_ID_Info_Item = -1;
static gint ett_f1ap_ServedPLMNs_List = -1;
static gint ett_f1ap_ServedPLMNs_Item = -1;
static gint ett_f1ap_BroadcastCAGList = -1;
static gint ett_f1ap_BroadcastNIDList = -1;
static gint ett_f1ap_BroadcastSNPN_ID_List = -1;
static gint ett_f1ap_BroadcastSNPN_ID_List_Item = -1;
static gint ett_f1ap_BroadcastPNI_NPN_ID_List = -1;
static gint ett_f1ap_BroadcastPNI_NPN_ID_List_Item = -1;
static gint ett_f1ap_Candidate_SpCell_Item = -1;
static gint ett_f1ap_CapacityValue = -1;
static gint ett_f1ap_Cause = -1;
static gint ett_f1ap_CellMeasurementResultList = -1;
static gint ett_f1ap_CellMeasurementResultItem = -1;
static gint ett_f1ap_Cells_Failed_to_be_Activated_List_Item = -1;
static gint ett_f1ap_Cells_Status_Item = -1;
static gint ett_f1ap_Cells_To_Be_Broadcast_Item = -1;
static gint ett_f1ap_Cells_Broadcast_Completed_Item = -1;
static gint ett_f1ap_Broadcast_To_Be_Cancelled_Item = -1;
static gint ett_f1ap_Cells_Broadcast_Cancelled_Item = -1;
static gint ett_f1ap_Cells_to_be_Activated_List_Item = -1;
static gint ett_f1ap_Cells_to_be_Deactivated_List_Item = -1;
static gint ett_f1ap_Cells_to_be_Barred_Item = -1;
static gint ett_f1ap_CellToReportList = -1;
static gint ett_f1ap_CellToReportItem = -1;
static gint ett_f1ap_CellType = -1;
static gint ett_f1ap_Child_Node_Cells_List = -1;
static gint ett_f1ap_Child_Node_Cells_List_Item = -1;
static gint ett_f1ap_Child_Nodes_List = -1;
static gint ett_f1ap_Child_Nodes_List_Item = -1;
static gint ett_f1ap_CNUEPagingIdentity = -1;
static gint ett_f1ap_CompositeAvailableCapacityGroup = -1;
static gint ett_f1ap_CompositeAvailableCapacity = -1;
static gint ett_f1ap_ConditionalInterDUMobilityInformation = -1;
static gint ett_f1ap_ConditionalIntraDUMobilityInformation = -1;
static gint ett_f1ap_CP_TransportLayerAddress = -1;
static gint ett_f1ap_CriticalityDiagnostics = -1;
static gint ett_f1ap_CriticalityDiagnostics_IE_List = -1;
static gint ett_f1ap_CriticalityDiagnostics_IE_Item = -1;
static gint ett_f1ap_CUDURadioInformationType = -1;
static gint ett_f1ap_CUDURIMInformation = -1;
static gint ett_f1ap_CUtoDURRCInformation = -1;
static gint ett_f1ap_Dedicated_SIDelivery_NeededUE_Item = -1;
static gint ett_f1ap_DL_PRS = -1;
static gint ett_f1ap_DL_PRSMutingPattern = -1;
static gint ett_f1ap_DLPRSResourceCoordinates = -1;
static gint ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP = -1;
static gint ett_f1ap_DLPRSResourceSetARP = -1;
static gint ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP = -1;
static gint ett_f1ap_DL_PRSResourceSetARPLocation = -1;
static gint ett_f1ap_DLPRSResourceARP = -1;
static gint ett_f1ap_DL_PRSResourceARPLocation = -1;
static gint ett_f1ap_DL_UP_TNL_Address_to_Update_List_Item = -1;
static gint ett_f1ap_DLUPTNLInformation_ToBeSetup_List = -1;
static gint ett_f1ap_DLUPTNLInformation_ToBeSetup_Item = -1;
static gint ett_f1ap_DRB_Activity_Item = -1;
static gint ett_f1ap_DRBs_FailedToBeModified_Item = -1;
static gint ett_f1ap_DRBs_FailedToBeSetup_Item = -1;
static gint ett_f1ap_DRBs_FailedToBeSetupMod_Item = -1;
static gint ett_f1ap_DRB_Information = -1;
static gint ett_f1ap_DRBs_Modified_Item = -1;
static gint ett_f1ap_DRBs_ModifiedConf_Item = -1;
static gint ett_f1ap_DRB_Notify_Item = -1;
static gint ett_f1ap_DRBs_Required_ToBeModified_Item = -1;
static gint ett_f1ap_DRBs_Required_ToBeReleased_Item = -1;
static gint ett_f1ap_DRBs_Setup_Item = -1;
static gint ett_f1ap_DRBs_SetupMod_Item = -1;
static gint ett_f1ap_DRBs_ToBeModified_Item = -1;
static gint ett_f1ap_DRBs_ToBeReleased_Item = -1;
static gint ett_f1ap_DRBs_ToBeSetup_Item = -1;
static gint ett_f1ap_DRBs_ToBeSetupMod_Item = -1;
static gint ett_f1ap_DRXCycle = -1;
static gint ett_f1ap_DSInformationList = -1;
static gint ett_f1ap_DUCURadioInformationType = -1;
static gint ett_f1ap_DUCURIMInformation = -1;
static gint ett_f1ap_DUF_Slot_Config_Item = -1;
static gint ett_f1ap_DUF_Slot_Config_List = -1;
static gint ett_f1ap_DUtoCURRCInformation = -1;
static gint ett_f1ap_Dynamic5QIDescriptor = -1;
static gint ett_f1ap_DynamicPQIDescriptor = -1;
static gint ett_f1ap_E_CID_MeasurementQuantities = -1;
static gint ett_f1ap_E_CID_MeasurementQuantities_Item = -1;
static gint ett_f1ap_E_CID_MeasurementResult = -1;
static gint ett_f1ap_E_CID_MeasuredResults_List = -1;
static gint ett_f1ap_E_CID_MeasuredResults_Item = -1;
static gint ett_f1ap_E_CID_MeasuredResults_Value = -1;
static gint ett_f1ap_EgressBHRLCCHList = -1;
static gint ett_f1ap_EgressBHRLCCHItem = -1;
static gint ett_f1ap_Endpoint_IP_address_and_port = -1;
static gint ett_f1ap_ExtendedAvailablePLMN_List = -1;
static gint ett_f1ap_ExtendedAvailablePLMN_Item = -1;
static gint ett_f1ap_ExplicitFormat = -1;
static gint ett_f1ap_ExtendedServedPLMNs_List = -1;
static gint ett_f1ap_ExtendedServedPLMNs_Item = -1;
static gint ett_f1ap_ExtendedSliceSupportList = -1;
static gint ett_f1ap_EUTRACells_List = -1;
static gint ett_f1ap_EUTRACells_List_item = -1;
static gint ett_f1ap_EUTRA_Coex_FDD_Info = -1;
static gint ett_f1ap_EUTRA_Coex_Mode_Info = -1;
static gint ett_f1ap_EUTRA_Coex_TDD_Info = -1;
static gint ett_f1ap_EUTRA_PRACH_Configuration = -1;
static gint ett_f1ap_EUTRA_SpecialSubframe_Info = -1;
static gint ett_f1ap_EUTRANQoS = -1;
static gint ett_f1ap_EUTRA_Mode_Info = -1;
static gint ett_f1ap_EUTRA_FDD_Info = -1;
static gint ett_f1ap_EUTRA_TDD_Info = -1;
static gint ett_f1ap_F1CTransferPath = -1;
static gint ett_f1ap_FDD_Info = -1;
static gint ett_f1ap_Flows_Mapped_To_DRB_List = -1;
static gint ett_f1ap_Flows_Mapped_To_DRB_Item = -1;
static gint ett_f1ap_FreqBandNrItem = -1;
static gint ett_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem = -1;
static gint ett_f1ap_FreqDomainLength = -1;
static gint ett_f1ap_FlowsMappedToSLDRB_List = -1;
static gint ett_f1ap_FlowsMappedToSLDRB_Item = -1;
static gint ett_f1ap_GBR_QosInformation = -1;
static gint ett_f1ap_GBR_QoSFlowInformation = -1;
static gint ett_f1ap_GeographicalCoordinates = -1;
static gint ett_f1ap_GNB_CUSystemInformation = -1;
static gint ett_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_Setup_Item = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_To_Add_Item = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_To_Remove_Item = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_To_Update_Item = -1;
static gint ett_f1ap_GNB_DU_Cell_Resource_Configuration = -1;
static gint ett_f1ap_Extended_GNB_CU_Name = -1;
static gint ett_f1ap_Extended_GNB_DU_Name = -1;
static gint ett_f1ap_GNB_DU_Served_Cells_Item = -1;
static gint ett_f1ap_GNB_DU_System_Information = -1;
static gint ett_f1ap_GNB_DU_TNL_Association_To_Remove_Item = -1;
static gint ett_f1ap_GNB_RxTxTimeDiff = -1;
static gint ett_f1ap_GNBRxTxTimeDiffMeas = -1;
static gint ett_f1ap_GTPTLAs = -1;
static gint ett_f1ap_GTPTLA_Item = -1;
static gint ett_f1ap_GTPTunnel = -1;
static gint ett_f1ap_HardwareLoadIndicator = -1;
static gint ett_f1ap_HSNASlotConfigList = -1;
static gint ett_f1ap_HSNASlotConfigItem = -1;
static gint ett_f1ap_IAB_Info_IAB_donor_CU = -1;
static gint ett_f1ap_IAB_Info_IAB_DU = -1;
static gint ett_f1ap_IAB_MT_Cell_List = -1;
static gint ett_f1ap_IAB_MT_Cell_List_Item = -1;
static gint ett_f1ap_IAB_STC_Info = -1;
static gint ett_f1ap_IAB_STC_Info_List = -1;
static gint ett_f1ap_IAB_STC_Info_Item = -1;
static gint ett_f1ap_IAB_Allocated_TNL_Address_Item = -1;
static gint ett_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info = -1;
static gint ett_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info = -1;
static gint ett_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info = -1;
static gint ett_f1ap_IABIPv6RequestType = -1;
static gint ett_f1ap_IABTNLAddress = -1;
static gint ett_f1ap_IABTNLAddressesRequested = -1;
static gint ett_f1ap_IAB_TNL_Addresses_To_Remove_Item = -1;
static gint ett_f1ap_IABv4AddressesRequested = -1;
static gint ett_f1ap_ImplicitFormat = -1;
static gint ett_f1ap_IntendedTDD_DL_ULConfig = -1;
static gint ett_f1ap_IPHeaderInformation = -1;
static gint ett_f1ap_IPtolayer2TrafficMappingInfo = -1;
static gint ett_f1ap_IPtolayer2TrafficMappingInfoList = -1;
static gint ett_f1ap_IPtolayer2TrafficMappingInfo_Item = -1;
static gint ett_f1ap_L139Info = -1;
static gint ett_f1ap_L839Info = -1;
static gint ett_f1ap_LCS_to_GCS_TranslationAoA = -1;
static gint ett_f1ap_LCStoGCSTranslationList = -1;
static gint ett_f1ap_LCStoGCSTranslation = -1;
static gint ett_f1ap_LocationUncertainty = -1;
static gint ett_f1ap_LTEUESidelinkAggregateMaximumBitrate = -1;
static gint ett_f1ap_LTEV2XServicesAuthorized = -1;
static gint ett_f1ap_MappingInformationtoRemove = -1;
static gint ett_f1ap_MeasurementBeamInfo = -1;
static gint ett_f1ap_MultiplexingInfo = -1;
static gint ett_f1ap_M5Configuration = -1;
static gint ett_f1ap_M6Configuration = -1;
static gint ett_f1ap_M7Configuration = -1;
static gint ett_f1ap_MDTConfiguration = -1;
static gint ett_f1ap_MDTPLMNList = -1;
static gint ett_f1ap_MeasuredResultsValue = -1;
static gint ett_f1ap_Neighbour_Cell_Information_Item = -1;
static gint ett_f1ap_NGRANAllocationAndRetentionPriority = -1;
static gint ett_f1ap_NGRANHighAccuracyAccessPointPosition = -1;
static gint ett_f1ap_NR_CGI_List_For_Restart_Item = -1;
static gint ett_f1ap_NR_PRSBeamInformation = -1;
static gint ett_f1ap_NR_PRSBeamInformationList = -1;
static gint ett_f1ap_NR_PRSBeamInformationItem = -1;
static gint ett_f1ap_NonDynamic5QIDescriptor = -1;
static gint ett_f1ap_NonDynamicPQIDescriptor = -1;
static gint ett_f1ap_NotificationInformation = -1;
static gint ett_f1ap_NPNBroadcastInformation = -1;
static gint ett_f1ap_NPN_Broadcast_Information_SNPN = -1;
static gint ett_f1ap_NPN_Broadcast_Information_PNI_NPN = -1;
static gint ett_f1ap_NPNSupportInfo = -1;
static gint ett_f1ap_NRCarrierList = -1;
static gint ett_f1ap_NRCarrierItem = -1;
static gint ett_f1ap_NRFreqInfo = -1;
static gint ett_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem = -1;
static gint ett_f1ap_NRCGI = -1;
static gint ett_f1ap_NR_Mode_Info = -1;
static gint ett_f1ap_NRPRACHConfig = -1;
static gint ett_f1ap_NRPRACHConfigList = -1;
static gint ett_f1ap_NRPRACHConfigItem = -1;
static gint ett_f1ap_NumDLULSymbols = -1;
static gint ett_f1ap_NRV2XServicesAuthorized = -1;
static gint ett_f1ap_NRUESidelinkAggregateMaximumBitrate = -1;
static gint ett_f1ap_PacketErrorRate = -1;
static gint ett_f1ap_PagingCell_Item = -1;
static gint ett_f1ap_PagingIdentity = -1;
static gint ett_f1ap_RelativePathDelay = -1;
static gint ett_f1ap_PathlossReferenceInfo = -1;
static gint ett_f1ap_PathlossReferenceSignal = -1;
static gint ett_f1ap_PC5_QoS_Characteristics = -1;
static gint ett_f1ap_PC5QoSParameters = -1;
static gint ett_f1ap_PC5FlowBitRates = -1;
static gint ett_f1ap_PeriodicityList = -1;
static gint ett_f1ap_PeriodicityList_Item = -1;
static gint ett_f1ap_PositioningBroadcastCells = -1;
static gint ett_f1ap_PosMeasurementQuantities = -1;
static gint ett_f1ap_PosMeasurementQuantities_Item = -1;
static gint ett_f1ap_PosMeasurementResult = -1;
static gint ett_f1ap_PosMeasurementResultItem = -1;
static gint ett_f1ap_PosMeasurementResultList = -1;
static gint ett_f1ap_PosMeasurementResultList_Item = -1;
static gint ett_f1ap_PosResourceSetType = -1;
static gint ett_f1ap_PosResourceSetTypePR = -1;
static gint ett_f1ap_PosResourceSetTypeSP = -1;
static gint ett_f1ap_PosResourceSetTypeAP = -1;
static gint ett_f1ap_PosSRSResourceID_List = -1;
static gint ett_f1ap_PosSRSResource_Item = -1;
static gint ett_f1ap_PosSRSResource_List = -1;
static gint ett_f1ap_PosSRSResourceSet_Item = -1;
static gint ett_f1ap_PosSRSResourceSet_List = -1;
static gint ett_f1ap_Protected_EUTRA_Resources_Item = -1;
static gint ett_f1ap_PRSConfiguration = -1;
static gint ett_f1ap_PRSInformationPos = -1;
static gint ett_f1ap_Potential_SpCell_Item = -1;
static gint ett_f1ap_PRSAngleList = -1;
static gint ett_f1ap_PRSAngleItem = -1;
static gint ett_f1ap_PRSMuting = -1;
static gint ett_f1ap_PRSMutingOption1 = -1;
static gint ett_f1ap_PRSMutingOption2 = -1;
static gint ett_f1ap_PRSResource_List = -1;
static gint ett_f1ap_PRSResource_Item = -1;
static gint ett_f1ap_PRSResource_QCLInfo = -1;
static gint ett_f1ap_PRSResource_QCLSourceSSB = -1;
static gint ett_f1ap_PRSResource_QCLSourcePRS = -1;
static gint ett_f1ap_PRSResourceSet_List = -1;
static gint ett_f1ap_PRSResourceSet_Item = -1;
static gint ett_f1ap_PWS_Failed_NR_CGI_Item = -1;
static gint ett_f1ap_PWSSystemInformation = -1;
static gint ett_f1ap_QoS_Characteristics = -1;
static gint ett_f1ap_QoSFlowLevelQoSParameters = -1;
static gint ett_f1ap_QoSInformation = -1;
static gint ett_f1ap_RACHReportInformationList = -1;
static gint ett_f1ap_RACHReportInformationItem = -1;
static gint ett_f1ap_RadioResourceStatus = -1;
static gint ett_f1ap_RANUEPagingIdentity = -1;
static gint ett_f1ap_RAT_FrequencyPriorityInformation = -1;
static gint ett_f1ap_ReferencePoint = -1;
static gint ett_f1ap_ReferenceSignal = -1;
static gint ett_f1ap_RelativeCartesianLocation = -1;
static gint ett_f1ap_RelativeGeodeticLocation = -1;
static gint ett_f1ap_RequestedSRSTransmissionCharacteristics = -1;
static gint ett_f1ap_ResourceCoordinationEUTRACellInfo = -1;
static gint ett_f1ap_ResourceCoordinationTransferInformation = -1;
static gint ett_f1ap_ResourceSetType = -1;
static gint ett_f1ap_ResourceSetTypePeriodic = -1;
static gint ett_f1ap_ResourceSetTypeSemi_persistent = -1;
static gint ett_f1ap_ResourceSetTypeAperiodic = -1;
static gint ett_f1ap_ReportingRequestType = -1;
static gint ett_f1ap_ResourceType = -1;
static gint ett_f1ap_ResourceTypePeriodic = -1;
static gint ett_f1ap_ResourceTypeSemi_persistent = -1;
static gint ett_f1ap_ResourceTypeAperiodic = -1;
static gint ett_f1ap_ResourceTypePos = -1;
static gint ett_f1ap_ResourceTypePeriodicPos = -1;
static gint ett_f1ap_ResourceTypeSemi_persistentPos = -1;
static gint ett_f1ap_ResourceTypeAperiodicPos = -1;
static gint ett_f1ap_RLCDuplicationInformation = -1;
static gint ett_f1ap_RLCDuplicationStateList = -1;
static gint ett_f1ap_RLCDuplicationState_Item = -1;
static gint ett_f1ap_RLCFailureIndication = -1;
static gint ett_f1ap_RLC_Status = -1;
static gint ett_f1ap_RLFReportInformationList = -1;
static gint ett_f1ap_RLFReportInformationItem = -1;
static gint ett_f1ap_RRCDeliveryStatus = -1;
static gint ett_f1ap_RRC_Version = -1;
static gint ett_f1ap_SCell_FailedtoSetup_Item = -1;
static gint ett_f1ap_SCell_FailedtoSetupMod_Item = -1;
static gint ett_f1ap_SCell_ToBeRemoved_Item = -1;
static gint ett_f1ap_SCell_ToBeSetup_Item = -1;
static gint ett_f1ap_SCell_ToBeSetupMod_Item = -1;
static gint ett_f1ap_SCS_SpecificCarrier = -1;
static gint ett_f1ap_Search_window_information = -1;
static gint ett_f1ap_Served_Cell_Information = -1;
static gint ett_f1ap_SFN_Offset = -1;
static gint ett_f1ap_Served_Cells_To_Add_Item = -1;
static gint ett_f1ap_Served_Cells_To_Delete_Item = -1;
static gint ett_f1ap_Served_Cells_To_Modify_Item = -1;
static gint ett_f1ap_Served_EUTRA_Cells_Information = -1;
static gint ett_f1ap_Service_Status = -1;
static gint ett_f1ap_SItype_List = -1;
static gint ett_f1ap_SItype_Item = -1;
static gint ett_f1ap_SibtypetobeupdatedListItem = -1;
static gint ett_f1ap_SLDRBInformation = -1;
static gint ett_f1ap_SLDRBs_FailedToBeModified_Item = -1;
static gint ett_f1ap_SLDRBs_FailedToBeSetup_Item = -1;
static gint ett_f1ap_SLDRBs_FailedToBeSetupMod_Item = -1;
static gint ett_f1ap_SLDRBs_Modified_Item = -1;
static gint ett_f1ap_SLDRBs_ModifiedConf_Item = -1;
static gint ett_f1ap_SLDRBs_Required_ToBeModified_Item = -1;
static gint ett_f1ap_SLDRBs_Required_ToBeReleased_Item = -1;
static gint ett_f1ap_SLDRBs_Setup_Item = -1;
static gint ett_f1ap_SLDRBs_SetupMod_Item = -1;
static gint ett_f1ap_SLDRBs_ToBeModified_Item = -1;
static gint ett_f1ap_SLDRBs_ToBeReleased_Item = -1;
static gint ett_f1ap_SLDRBs_ToBeSetup_Item = -1;
static gint ett_f1ap_SLDRBs_ToBeSetupMod_Item = -1;
static gint ett_f1ap_SliceAvailableCapacity = -1;
static gint ett_f1ap_SliceAvailableCapacityList = -1;
static gint ett_f1ap_SliceAvailableCapacityItem = -1;
static gint ett_f1ap_SNSSAIAvailableCapacity_List = -1;
static gint ett_f1ap_SNSSAIAvailableCapacity_Item = -1;
static gint ett_f1ap_SliceSupportList = -1;
static gint ett_f1ap_SliceSupportItem = -1;
static gint ett_f1ap_SliceToReportList = -1;
static gint ett_f1ap_SliceToReportItem = -1;
static gint ett_f1ap_SNSSAI_list = -1;
static gint ett_f1ap_SNSSAI_Item = -1;
static gint ett_f1ap_Slot_Configuration_List = -1;
static gint ett_f1ap_Slot_Configuration_Item = -1;
static gint ett_f1ap_SNSSAI = -1;
static gint ett_f1ap_SpatialDirectionInformation = -1;
static gint ett_f1ap_SpatialRelationInfo = -1;
static gint ett_f1ap_SpatialRelationforResourceID = -1;
static gint ett_f1ap_SpatialRelationforResourceIDItem = -1;
static gint ett_f1ap_SpatialRelationPos = -1;
static gint ett_f1ap_SRBs_FailedToBeSetup_Item = -1;
static gint ett_f1ap_SRBs_FailedToBeSetupMod_Item = -1;
static gint ett_f1ap_SRBs_Modified_Item = -1;
static gint ett_f1ap_SRBs_Required_ToBeReleased_Item = -1;
static gint ett_f1ap_SRBs_Setup_Item = -1;
static gint ett_f1ap_SRBs_SetupMod_Item = -1;
static gint ett_f1ap_SRBs_ToBeReleased_Item = -1;
static gint ett_f1ap_SRBs_ToBeSetup_Item = -1;
static gint ett_f1ap_SRBs_ToBeSetupMod_Item = -1;
static gint ett_f1ap_SRSCarrier_List = -1;
static gint ett_f1ap_SRSCarrier_List_Item = -1;
static gint ett_f1ap_SRSConfig = -1;
static gint ett_f1ap_SRSConfiguration = -1;
static gint ett_f1ap_SRSResource = -1;
static gint ett_f1ap_SRSResourceID_List = -1;
static gint ett_f1ap_SRSResource_List = -1;
static gint ett_f1ap_SRSResourceSet = -1;
static gint ett_f1ap_SRSResourceSetList = -1;
static gint ett_f1ap_SRSResourceSetItem = -1;
static gint ett_f1ap_SRSResourceSet_List = -1;
static gint ett_f1ap_SRSResourceTrigger = -1;
static gint ett_f1ap_SSB = -1;
static gint ett_f1ap_SSB_transmissionBitmap = -1;
static gint ett_f1ap_SSBAreaCapacityValueList = -1;
static gint ett_f1ap_SSBAreaCapacityValueItem = -1;
static gint ett_f1ap_SSBAreaRadioResourceStatusList = -1;
static gint ett_f1ap_SSBAreaRadioResourceStatusItem = -1;
static gint ett_f1ap_SSBInformation = -1;
static gint ett_f1ap_SSBInformationList = -1;
static gint ett_f1ap_SSBInformationItem = -1;
static gint ett_f1ap_SSB_PositionsInBurst = -1;
static gint ett_f1ap_SSB_TF_Configuration = -1;
static gint ett_f1ap_SSBToReportList = -1;
static gint ett_f1ap_SSBToReportItem = -1;
static gint ett_f1ap_SUL_Information = -1;
static gint ett_f1ap_SupportedSULFreqBandItem = -1;
static gint ett_f1ap_SymbolAllocInSlot = -1;
static gint ett_f1ap_TargetCellList = -1;
static gint ett_f1ap_TargetCellList_Item = -1;
static gint ett_f1ap_TDD_Info = -1;
static gint ett_f1ap_TimeReferenceInformation = -1;
static gint ett_f1ap_TimeStamp = -1;
static gint ett_f1ap_TimeStampSlotIndex = -1;
static gint ett_f1ap_TimingMeasurementQuality = -1;
static gint ett_f1ap_TNLCapacityIndicator = -1;
static gint ett_f1ap_TraceActivation = -1;
static gint ett_f1ap_TrafficMappingInfo = -1;
static gint ett_f1ap_Transmission_Bandwidth = -1;
static gint ett_f1ap_TransmissionComb = -1;
static gint ett_f1ap_T_n2 = -1;
static gint ett_f1ap_T_n4 = -1;
static gint ett_f1ap_TransmissionCombPos = -1;
static gint ett_f1ap_T_n2_01 = -1;
static gint ett_f1ap_T_n4_01 = -1;
static gint ett_f1ap_T_n8 = -1;
static gint ett_f1ap_Transport_UP_Layer_Address_Info_To_Add_List = -1;
static gint ett_f1ap_Transport_UP_Layer_Address_Info_To_Add_Item = -1;
static gint ett_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List = -1;
static gint ett_f1ap_Transport_UP_Layer_Address_Info_To_Remove_Item = -1;
static gint ett_f1ap_TRPInformation = -1;
static gint ett_f1ap_TRPInformationItem = -1;
static gint ett_f1ap_TRPInformationTypeResponseList = -1;
static gint ett_f1ap_TRPInformationTypeResponseItem = -1;
static gint ett_f1ap_TRPList = -1;
static gint ett_f1ap_TRPListItem = -1;
static gint ett_f1ap_TRPMeasurementQuality = -1;
static gint ett_f1ap_TRPMeasurementQuality_Item = -1;
static gint ett_f1ap_TRP_MeasurementRequestList = -1;
static gint ett_f1ap_TRP_MeasurementRequestItem = -1;
static gint ett_f1ap_TRPPositionDefinitionType = -1;
static gint ett_f1ap_TRPPositionDirect = -1;
static gint ett_f1ap_TRPPositionDirectAccuracy = -1;
static gint ett_f1ap_TRPPositionReferenced = -1;
static gint ett_f1ap_TRPReferencePointType = -1;
static gint ett_f1ap_Transport_Layer_Address_Info = -1;
static gint ett_f1ap_TSCAssistanceInformation = -1;
static gint ett_f1ap_TSCTrafficCharacteristics = -1;
static gint ett_f1ap_UAC_Assistance_Info = -1;
static gint ett_f1ap_UACPLMN_List = -1;
static gint ett_f1ap_UACPLMN_Item = -1;
static gint ett_f1ap_UACType_List = -1;
static gint ett_f1ap_UACType_Item = -1;
static gint ett_f1ap_UACCategoryType = -1;
static gint ett_f1ap_UACOperatorDefined = -1;
static gint ett_f1ap_UE_associatedLogicalF1_ConnectionItem = -1;
static gint ett_f1ap_UEIdentityIndexValue = -1;
static gint ett_f1ap_UL_AoA = -1;
static gint ett_f1ap_UL_BH_Non_UP_Traffic_Mapping = -1;
static gint ett_f1ap_UL_BH_Non_UP_Traffic_Mapping_List = -1;
static gint ett_f1ap_UL_BH_Non_UP_Traffic_Mapping_Item = -1;
static gint ett_f1ap_ULConfiguration = -1;
static gint ett_f1ap_UL_RTOA_Measurement = -1;
static gint ett_f1ap_UL_RTOA_MeasurementItem = -1;
static gint ett_f1ap_UL_UP_TNL_Information_to_Update_List_Item = -1;
static gint ett_f1ap_UL_UP_TNL_Address_to_Update_List_Item = -1;
static gint ett_f1ap_ULUPTNLInformation_ToBeSetup_List = -1;
static gint ett_f1ap_ULUPTNLInformation_ToBeSetup_Item = -1;
static gint ett_f1ap_UplinkChannelBW_PerSCS_List = -1;
static gint ett_f1ap_UPTransportLayerInformation = -1;
static gint ett_f1ap_VictimgNBSetID = -1;
static gint ett_f1ap_Reset = -1;
static gint ett_f1ap_ResetType = -1;
static gint ett_f1ap_UE_associatedLogicalF1_ConnectionListRes = -1;
static gint ett_f1ap_ResetAcknowledge = -1;
static gint ett_f1ap_UE_associatedLogicalF1_ConnectionListResAck = -1;
static gint ett_f1ap_ErrorIndication = -1;
static gint ett_f1ap_F1SetupRequest = -1;
static gint ett_f1ap_GNB_DU_Served_Cells_List = -1;
static gint ett_f1ap_F1SetupResponse = -1;
static gint ett_f1ap_Cells_to_be_Activated_List = -1;
static gint ett_f1ap_F1SetupFailure = -1;
static gint ett_f1ap_GNBDUConfigurationUpdate = -1;
static gint ett_f1ap_Served_Cells_To_Add_List = -1;
static gint ett_f1ap_Served_Cells_To_Modify_List = -1;
static gint ett_f1ap_Served_Cells_To_Delete_List = -1;
static gint ett_f1ap_Cells_Status_List = -1;
static gint ett_f1ap_Dedicated_SIDelivery_NeededUE_List = -1;
static gint ett_f1ap_GNB_DU_TNL_Association_To_Remove_List = -1;
static gint ett_f1ap_GNBDUConfigurationUpdateAcknowledge = -1;
static gint ett_f1ap_GNBDUConfigurationUpdateFailure = -1;
static gint ett_f1ap_GNBCUConfigurationUpdate = -1;
static gint ett_f1ap_Cells_to_be_Deactivated_List = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_To_Add_List = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_To_Remove_List = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_To_Update_List = -1;
static gint ett_f1ap_Cells_to_be_Barred_List = -1;
static gint ett_f1ap_Protected_EUTRA_Resources_List = -1;
static gint ett_f1ap_Neighbour_Cell_Information_List = -1;
static gint ett_f1ap_GNBCUConfigurationUpdateAcknowledge = -1;
static gint ett_f1ap_Cells_Failed_to_be_Activated_List = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_Setup_List = -1;
static gint ett_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List = -1;
static gint ett_f1ap_GNBCUConfigurationUpdateFailure = -1;
static gint ett_f1ap_GNBDUResourceCoordinationRequest = -1;
static gint ett_f1ap_GNBDUResourceCoordinationResponse = -1;
static gint ett_f1ap_UEContextSetupRequest = -1;
static gint ett_f1ap_Candidate_SpCell_List = -1;
static gint ett_f1ap_SCell_ToBeSetup_List = -1;
static gint ett_f1ap_SRBs_ToBeSetup_List = -1;
static gint ett_f1ap_DRBs_ToBeSetup_List = -1;
static gint ett_f1ap_BHChannels_ToBeSetup_List = -1;
static gint ett_f1ap_SLDRBs_ToBeSetup_List = -1;
static gint ett_f1ap_UEContextSetupResponse = -1;
static gint ett_f1ap_DRBs_Setup_List = -1;
static gint ett_f1ap_SRBs_FailedToBeSetup_List = -1;
static gint ett_f1ap_DRBs_FailedToBeSetup_List = -1;
static gint ett_f1ap_SCell_FailedtoSetup_List = -1;
static gint ett_f1ap_SRBs_Setup_List = -1;
static gint ett_f1ap_BHChannels_Setup_List = -1;
static gint ett_f1ap_BHChannels_FailedToBeSetup_List = -1;
static gint ett_f1ap_SLDRBs_Setup_List = -1;
static gint ett_f1ap_SLDRBs_FailedToBeSetup_List = -1;
static gint ett_f1ap_UEContextSetupFailure = -1;
static gint ett_f1ap_Potential_SpCell_List = -1;
static gint ett_f1ap_UEContextReleaseRequest = -1;
static gint ett_f1ap_UEContextReleaseCommand = -1;
static gint ett_f1ap_UEContextReleaseComplete = -1;
static gint ett_f1ap_UEContextModificationRequest = -1;
static gint ett_f1ap_SCell_ToBeSetupMod_List = -1;
static gint ett_f1ap_SCell_ToBeRemoved_List = -1;
static gint ett_f1ap_SRBs_ToBeSetupMod_List = -1;
static gint ett_f1ap_DRBs_ToBeSetupMod_List = -1;
static gint ett_f1ap_BHChannels_ToBeSetupMod_List = -1;
static gint ett_f1ap_DRBs_ToBeModified_List = -1;
static gint ett_f1ap_BHChannels_ToBeModified_List = -1;
static gint ett_f1ap_SRBs_ToBeReleased_List = -1;
static gint ett_f1ap_DRBs_ToBeReleased_List = -1;
static gint ett_f1ap_BHChannels_ToBeReleased_List = -1;
static gint ett_f1ap_SLDRBs_ToBeSetupMod_List = -1;
static gint ett_f1ap_SLDRBs_ToBeModified_List = -1;
static gint ett_f1ap_SLDRBs_ToBeReleased_List = -1;
static gint ett_f1ap_UEContextModificationResponse = -1;
static gint ett_f1ap_DRBs_SetupMod_List = -1;
static gint ett_f1ap_DRBs_Modified_List = -1;
static gint ett_f1ap_SRBs_SetupMod_List = -1;
static gint ett_f1ap_SRBs_Modified_List = -1;
static gint ett_f1ap_DRBs_FailedToBeModified_List = -1;
static gint ett_f1ap_SRBs_FailedToBeSetupMod_List = -1;
static gint ett_f1ap_DRBs_FailedToBeSetupMod_List = -1;
static gint ett_f1ap_SCell_FailedtoSetupMod_List = -1;
static gint ett_f1ap_BHChannels_SetupMod_List = -1;
static gint ett_f1ap_BHChannels_Modified_List = -1;
static gint ett_f1ap_BHChannels_FailedToBeModified_List = -1;
static gint ett_f1ap_BHChannels_FailedToBeSetupMod_List = -1;
static gint ett_f1ap_Associated_SCell_List = -1;
static gint ett_f1ap_SLDRBs_SetupMod_List = -1;
static gint ett_f1ap_SLDRBs_Modified_List = -1;
static gint ett_f1ap_SLDRBs_FailedToBeModified_List = -1;
static gint ett_f1ap_SLDRBs_FailedToBeSetupMod_List = -1;
static gint ett_f1ap_UEContextModificationFailure = -1;
static gint ett_f1ap_UEContextModificationRequired = -1;
static gint ett_f1ap_DRBs_Required_ToBeModified_List = -1;
static gint ett_f1ap_DRBs_Required_ToBeReleased_List = -1;
static gint ett_f1ap_SRBs_Required_ToBeReleased_List = -1;
static gint ett_f1ap_BHChannels_Required_ToBeReleased_List = -1;
static gint ett_f1ap_SLDRBs_Required_ToBeModified_List = -1;
static gint ett_f1ap_SLDRBs_Required_ToBeReleased_List = -1;
static gint ett_f1ap_UEContextModificationConfirm = -1;
static gint ett_f1ap_DRBs_ModifiedConf_List = -1;
static gint ett_f1ap_SLDRBs_ModifiedConf_List = -1;
static gint ett_f1ap_UEContextModificationRefuse = -1;
static gint ett_f1ap_WriteReplaceWarningRequest = -1;
static gint ett_f1ap_Cells_To_Be_Broadcast_List = -1;
static gint ett_f1ap_WriteReplaceWarningResponse = -1;
static gint ett_f1ap_Cells_Broadcast_Completed_List = -1;
static gint ett_f1ap_PWSCancelRequest = -1;
static gint ett_f1ap_Broadcast_To_Be_Cancelled_List = -1;
static gint ett_f1ap_PWSCancelResponse = -1;
static gint ett_f1ap_Cells_Broadcast_Cancelled_List = -1;
static gint ett_f1ap_UEInactivityNotification = -1;
static gint ett_f1ap_DRB_Activity_List = -1;
static gint ett_f1ap_InitialULRRCMessageTransfer = -1;
static gint ett_f1ap_DLRRCMessageTransfer = -1;
static gint ett_f1ap_ULRRCMessageTransfer = -1;
static gint ett_f1ap_PrivateMessage = -1;
static gint ett_f1ap_SystemInformationDeliveryCommand = -1;
static gint ett_f1ap_Paging = -1;
static gint ett_f1ap_PagingCell_list = -1;
static gint ett_f1ap_Notify = -1;
static gint ett_f1ap_DRB_Notify_List = -1;
static gint ett_f1ap_NetworkAccessRateReduction = -1;
static gint ett_f1ap_PWSRestartIndication = -1;
static gint ett_f1ap_NR_CGI_List_For_Restart_List = -1;
static gint ett_f1ap_PWSFailureIndication = -1;
static gint ett_f1ap_PWS_Failed_NR_CGI_List = -1;
static gint ett_f1ap_GNBDUStatusIndication = -1;
static gint ett_f1ap_RRCDeliveryReport = -1;
static gint ett_f1ap_F1RemovalRequest = -1;
static gint ett_f1ap_F1RemovalResponse = -1;
static gint ett_f1ap_F1RemovalFailure = -1;
static gint ett_f1ap_TraceStart = -1;
static gint ett_f1ap_DeactivateTrace = -1;
static gint ett_f1ap_CellTrafficTrace = -1;
static gint ett_f1ap_DUCURadioInformationTransfer = -1;
static gint ett_f1ap_CUDURadioInformationTransfer = -1;
static gint ett_f1ap_BAPMappingConfiguration = -1;
static gint ett_f1ap_BH_Routing_Information_Added_List = -1;
static gint ett_f1ap_BH_Routing_Information_Removed_List = -1;
static gint ett_f1ap_BAPMappingConfigurationAcknowledge = -1;
static gint ett_f1ap_BAPMappingConfigurationFailure = -1;
static gint ett_f1ap_GNBDUResourceConfiguration = -1;
static gint ett_f1ap_GNBDUResourceConfigurationAcknowledge = -1;
static gint ett_f1ap_GNBDUResourceConfigurationFailure = -1;
static gint ett_f1ap_IABTNLAddressRequest = -1;
static gint ett_f1ap_IAB_TNL_Addresses_To_Remove_List = -1;
static gint ett_f1ap_IABTNLAddressResponse = -1;
static gint ett_f1ap_IAB_Allocated_TNL_Address_List = -1;
static gint ett_f1ap_IABTNLAddressFailure = -1;
static gint ett_f1ap_IABUPConfigurationUpdateRequest = -1;
static gint ett_f1ap_UL_UP_TNL_Information_to_Update_List = -1;
static gint ett_f1ap_UL_UP_TNL_Address_to_Update_List = -1;
static gint ett_f1ap_IABUPConfigurationUpdateResponse = -1;
static gint ett_f1ap_DL_UP_TNL_Address_to_Update_List = -1;
static gint ett_f1ap_IABUPConfigurationUpdateFailure = -1;
static gint ett_f1ap_ResourceStatusRequest = -1;
static gint ett_f1ap_ResourceStatusResponse = -1;
static gint ett_f1ap_ResourceStatusFailure = -1;
static gint ett_f1ap_ResourceStatusUpdate = -1;
static gint ett_f1ap_AccessAndMobilityIndication = -1;
static gint ett_f1ap_ReferenceTimeInformationReportingControl = -1;
static gint ett_f1ap_ReferenceTimeInformationReport = -1;
static gint ett_f1ap_AccessSuccess = -1;
static gint ett_f1ap_PositioningAssistanceInformationControl = -1;
static gint ett_f1ap_PositioningAssistanceInformationFeedback = -1;
static gint ett_f1ap_PositioningMeasurementRequest = -1;
static gint ett_f1ap_PositioningMeasurementResponse = -1;
static gint ett_f1ap_PositioningMeasurementFailure = -1;
static gint ett_f1ap_PositioningMeasurementReport = -1;
static gint ett_f1ap_PositioningMeasurementAbort = -1;
static gint ett_f1ap_PositioningMeasurementFailureIndication = -1;
static gint ett_f1ap_PositioningMeasurementUpdate = -1;
static gint ett_f1ap_TRPInformationRequest = -1;
static gint ett_f1ap_TRPInformationTypeListTRPReq = -1;
static gint ett_f1ap_TRPInformationResponse = -1;
static gint ett_f1ap_TRPInformationListTRPResp = -1;
static gint ett_f1ap_TRPInformationFailure = -1;
static gint ett_f1ap_PositioningInformationRequest = -1;
static gint ett_f1ap_PositioningInformationResponse = -1;
static gint ett_f1ap_PositioningInformationFailure = -1;
static gint ett_f1ap_PositioningActivationRequest = -1;
static gint ett_f1ap_SRSType = -1;
static gint ett_f1ap_SemipersistentSRS = -1;
static gint ett_f1ap_AperiodicSRS = -1;
static gint ett_f1ap_PositioningActivationResponse = -1;
static gint ett_f1ap_PositioningActivationFailure = -1;
static gint ett_f1ap_PositioningDeactivation = -1;
static gint ett_f1ap_PositioningInformationUpdate = -1;
static gint ett_f1ap_E_CIDMeasurementInitiationRequest = -1;
static gint ett_f1ap_E_CIDMeasurementInitiationResponse = -1;
static gint ett_f1ap_E_CIDMeasurementInitiationFailure = -1;
static gint ett_f1ap_E_CIDMeasurementFailureIndication = -1;
static gint ett_f1ap_E_CIDMeasurementReport = -1;
static gint ett_f1ap_E_CIDMeasurementTerminationCommand = -1;
static gint ett_f1ap_F1AP_PDU = -1;
static gint ett_f1ap_InitiatingMessage = -1;
static gint ett_f1ap_SuccessfulOutcome = -1;
static gint ett_f1ap_UnsuccessfulOutcome = -1;

/*--- End of included file: packet-f1ap-ett.c ---*/
#line 133 "./asn1/f1ap/packet-f1ap-template.c"

enum{
  INITIATING_MESSAGE,
  SUCCESSFUL_OUTCOME,
  UNSUCCESSFUL_OUTCOME
};

/* F1AP stats - Tap interface */

static void set_stats_message_type(packet_info *pinfo, int type);

static const guint8 *st_str_packets        = "Total Packets";
static const guint8 *st_str_packet_types   = "F1AP Packet Types";

static int st_node_packets = -1;
static int st_node_packet_types = -1;
static int f1ap_tap = -1;

struct f1ap_tap_t {
    gint f1ap_mtype;
};

#define MTYPE_RESET                                       1
#define MTYPE_RESET_ACK                                   2
#define MTYPE_F1_SETUP_REQUEST                            3
#define MTYPE_F1_SETUP_RESPONSE                           4
#define MTYPE_F1_SETUP_FAILURE                            5
#define MTYPE_GNB_DU_CONFIGURATION_UPDATE                 6
#define MTYPE_GNB_DU_CONFIGURATION_UPDATE_ACKNOWLEDGE     7
#define MTYPE_GNB_DU_CONFIGURATION_UPDATE_FAILURE         8
#define MTYPE_GNB_CU_CONFIGURATION_UPDATE                 9
#define MTYPE_GNB_CU_CONFIGURATION_UPDATE_ACKNOWLEDGE     10
#define MTYPE_GNB_CU_CONFIGURATION_UPDATE_FAILURE         11
#define MTYPE_UE_CONTEXT_SETUP_REQUEST                    12
#define MTYPE_UE_CONTEXT_SETUP_RESPONSE                   13
#define MTYPE_UE_CONTEXT_SETUP_FAILURE                    14
#define MTYPE_UE_CONTEXT_RELEASE_COMMAND                  15
#define MTYPE_UE_CONTEXT_RELEASE_COMPLETE                 16
#define MTYPE_UE_CONTEXT_MODIFICATION_REQUEST             17
#define MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE            18
#define MTYPE_UE_CONTEXT_MODIFICATION_FAILURE             19
#define MTYPE_UE_CONTEXT_MODIFICATION_REQUIRED            20
#define MTYPE_UE_CONTEXT_MODIFICATION_CONFIRM             21
#define MTYPE_UE_CONTEXT_MODIFICATION_REFUSE              22
#define MTYPE_WRITE_REPLACE_WARNING_REQUEST               23
#define MTYPE_WRITE_REPLACE_WARNING_RESPONSE              24
#define MTYPE_PWS_CANCEL_REQUEST                          25
#define MTYPE_PWS_CANCEL_RESPONSE                         25
#define MTYPE_ERROR_INDICATION                            26
#define MTYPE_UE_CONTEXT_RELEASE_REQUEST                  27
#define MTYPE_INITIAL_UL_RRC_MESSAGE_TRANSFER             28
#define MTYPE_DL_RRC_MESSAGE_TRANSFER                     29
#define MTYPE_UL_RRC_MESSAGE_TRANSFER                     30
#define MTYPE_UE_INACTIVITY_NOTIFICATION                  31
#define MTYPE_GNB_DU_RESOURCE_COORDINATION_REQUEST        32
#define MTYPE_GNB_DU_RESOURCE_COORDINATION_RESPONSE       33
#define MTYPE_PRIVATE_MESSAGE                             34
#define MTYPE_SYSTEM_INFORMATION_DELIVERY_COMMAND         35
#define MTYPE_PAGING                                      36
#define MTYPE_NOTIFY                                      37
#define MTYPE_NETWORK_ACCESS_RATE_REDUCTION               38
#define MTYPE_PWS_RESTART_INDICATION                      39
#define MTYPE_PWS_FAILURE_INDICATION                      40
#define MTYPE_GNB_DU_STATUS_INDICATION                    41
#define MTYPE_RRC_DELIVERY_REPORT                         42
#define MTYPE_F1_REMOVAL_REQUEST                          43
#define MTYPE_F1_REMOVAL_RESPONSE                         44
#define MTYPE_F1_REMOVAL_FAILURE                          45
#define MTYPE_TRACE_START                                 46
#define MTYPE_DEACTIVATE_TRACE                            47
#define MTYPE_DU_CU_RADIO_INFORMATION_TRANSFER            48
#define MTYPE_CU_DU_RADIO_INFORMATION_TRANSFER            49
#define MTYPE_BAP_MAPPING_CONFIGURATION                   50
#define MTYPE_BAP_MAPPING_CONFIGURATION_ACKNOWLEDGE       51
#define MTYPE_BAP_MAPPING_CONFIGURATION_FAILURE           52
#define MTYPE_GNB_DU_RESOURCE_CONFIGURATION               53
#define MTYPE_GNB_DU_RESOURCE_CONFIGURATION_ACKNOWLEDGE   54
#define MTYPE_GNB_DU_RESOURCE_CONFIGURATION_FAILURE       55
#define MTYPE_IAB_TNL_ADDRESS_REQUEST                     56
#define MTYPE_IAB_TNL_ADDRESS_RESPONSE                    57
#define MTYPE_IAB_TNL_ADDRESS_FAILURE                     58
#define MTYPE_IAB_UP_CONFIGURATION_UPDATE_REQUEST         59
#define MTYPE_IAB_UP_CONFIGURATION_UPDATE_RESPONSE        60
#define MTYPE_IAB_UP_CONFIGURATION_UPDATE_FAILURE         61
#define MTYPE_RESOURCE_STATUS_REQUEST                     62
#define MTYPE_RESOURCE_STATUS_RESPONSE                    63
#define MTYPE_RESOURCE_STATUS_FAILURE                     64
#define MTYPE_RESOURCE_STATUS_UPDATE                      65
#define MTYPE_ACCESS_AND_MOBILITY_INDICATION              66
#define MTYPE_REFERENCE_TIME_INFORMATION_REPORTING_CONTROL 67
#define MTYPE_REFERENCE_TIME_INFORMATION_REPORT           68
#define MTYPE_ACCESS_SUCCESS                              69
#define MTYPE_CELL_TRAFFIC_TRACE                          70
#define MTYPE_POSITIONING_ASSISTANCE_INFORMATION_CONTROL  71
#define MTYPE_POSITIONING_ASSISTANCE_INFORMATION_FEEDBACK 72
#define MTYPE_POSITIONING_MEASUREMENT_REQUEST             73
#define MTYPE_POSITIONING_MEASUREMENT_RESPONSE            74
#define MTYPE_POSITIONING_MEASUREMENT_FAILURE             75
#define MTYPE_POSITIONING_MEASUREMENT_REPORT              76
#define MTYPE_POSITIONING_MEASUREMENT_ABORT               77
#define MTYPE_POSITIONING_MEASUREMENT_FAILURE_INDICATION  78
#define MTYPE_POSITIONING_MEASUREMENT_UPDATE              79
#define MTYPE_TRP_INFORMATION_REQUEST                     80
#define MTYPE_TRP_INFORMATION_RESPONSE                    81
#define MTYPE_TRP_INFORMATION_FAILURE                     82
#define MTYPE_POSITIONING_INFORMATION_REQUEST             83
#define MTYPE_POSITIONING_INFORMATION_RESPONSE            84
#define MTYPE_POSITIONING_INFORMATION_FAILURE             85
#define MTYPE_POSITIONING_ACTIVATION_REQUEST              86
#define MTYPE_POSITIONING_ACTIVATION_RESPONSE             87
#define MTYPE_POSITIONING_ACTIVATION_FAILURE              88
#define MTYPE_POSITIONING_DEACTIVATION                    89
#define MTYPE_E_CID_MEASUREMENT_INITIATION_REQUEST        90
#define MTYPE_E_CID_MEASUREMENT_INITIATION_RESPONSE       91
#define MTYPE_E_CID_MEASUREMENT_INITIATION_FAILURE        92
#define MTYPE_E_CID_MEASUREMENT_FAILURE_INDICATION        93
#define MTYPE_E_CID_MEASUREMENT_REPORT                    94
#define MTYPE_E_CID_MEASUREMENT_TERMINATION_COMMAND       95
#define MTYPE_POSITIONING_INFORMATION_UPDATE              96



/* Value Strings. TODO: ext? */
static const value_string mtype_names[] = {
    { MTYPE_RESET,     "Reset" },
    { MTYPE_RESET_ACK, "ResetAcknowledge" },
    { MTYPE_F1_SETUP_REQUEST,  "F1SetupRequest" },
    { MTYPE_F1_SETUP_RESPONSE, "F1SetupResponse" },
    { MTYPE_F1_SETUP_FAILURE,  "F1SetupFailure" },
    { MTYPE_GNB_DU_CONFIGURATION_UPDATE,             "GNBDUConfigurationUpdate" },
    { MTYPE_GNB_DU_CONFIGURATION_UPDATE_ACKNOWLEDGE, "GNBDUConfigurationUpdateAcknowledge" },
    { MTYPE_GNB_DU_CONFIGURATION_UPDATE_FAILURE,     "GNBDUConfigurationUpdateFailure" },
    { MTYPE_GNB_CU_CONFIGURATION_UPDATE,             "GNBCUConfigurationUpdate" },
    { MTYPE_GNB_CU_CONFIGURATION_UPDATE_ACKNOWLEDGE, "GNBCUConfigurationUpdateAcknowledge" },
    { MTYPE_GNB_CU_CONFIGURATION_UPDATE_FAILURE,     "GNBCUConfigurationUpdateFailure" },
    { MTYPE_UE_CONTEXT_SETUP_REQUEST,    "UEContextSetupRequest" },
    { MTYPE_UE_CONTEXT_SETUP_RESPONSE,   "UEContextSetupResponse" },
    { MTYPE_UE_CONTEXT_SETUP_FAILURE,    "UEContextSetupFailure" },
    { MTYPE_UE_CONTEXT_RELEASE_COMMAND,      "UEContextReleaseCommand"},
    { MTYPE_UE_CONTEXT_RELEASE_COMPLETE,     "UEContextReleaseComplete"},
    { MTYPE_UE_CONTEXT_MODIFICATION_REQUEST,   "UEContextModificationRequest" },
    { MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE,  "UEContextModificationResponse" },
    { MTYPE_UE_CONTEXT_MODIFICATION_FAILURE,   "UEContextModificationFailure" },
    { MTYPE_UE_CONTEXT_MODIFICATION_REQUIRED,  "UEContextModificationRequired" },
    { MTYPE_UE_CONTEXT_MODIFICATION_CONFIRM,   "UEContextModificationConfirm" },
    { MTYPE_UE_CONTEXT_MODIFICATION_REFUSE,   "UEContextModificationRefuse" },
    { MTYPE_WRITE_REPLACE_WARNING_REQUEST,  "WriteReplaceWarningRequest" },
    { MTYPE_WRITE_REPLACE_WARNING_RESPONSE, "WriteReplaceWarningResponse" },
    { MTYPE_PWS_CANCEL_REQUEST,   "PWSCancelRequest" },
    { MTYPE_PWS_CANCEL_RESPONSE,  "PWSCancelResponse" },
    { MTYPE_ERROR_INDICATION, "ErrorIndication" },
    { MTYPE_UE_CONTEXT_RELEASE_REQUEST, "UEContextReleaseRequest" },
    { MTYPE_INITIAL_UL_RRC_MESSAGE_TRANSFER, "InitialULRRCMessageTransfer" },
    { MTYPE_DL_RRC_MESSAGE_TRANSFER,  "DLRRCMessageTransfer" },
    { MTYPE_UL_RRC_MESSAGE_TRANSFER,  "ULRRCMessageTransfer" },
    { MTYPE_UE_INACTIVITY_NOTIFICATION, "UEInactivityNotification" },
    { MTYPE_GNB_DU_RESOURCE_COORDINATION_REQUEST,  "GNBDUResourceCoordinationRequest" },
    { MTYPE_GNB_DU_RESOURCE_COORDINATION_RESPONSE, "GNBDUResourceCoordinationResponse" },
    { MTYPE_PRIVATE_MESSAGE, "PrivateMessage" },
    { MTYPE_SYSTEM_INFORMATION_DELIVERY_COMMAND, "SystemInformationDeliveryCommand" },
    { MTYPE_PAGING, "Paging" },
    { MTYPE_NOTIFY, "Notify" },
    { MTYPE_NETWORK_ACCESS_RATE_REDUCTION, "NetworkAccessRateReduction" },
    { MTYPE_PWS_RESTART_INDICATION, "PWSRestartIndication" },
    { MTYPE_PWS_FAILURE_INDICATION, "PWSFailureIndication" },
    { MTYPE_GNB_DU_STATUS_INDICATION, "GNBDUStatusIndication" },
    { MTYPE_RRC_DELIVERY_REPORT, "RRCDeliveryReport" },
    { MTYPE_F1_REMOVAL_REQUEST,  "F1RemovalRequest" },
    { MTYPE_F1_REMOVAL_RESPONSE, "F1RemovalResponse" },
    { MTYPE_F1_REMOVAL_FAILURE,  "F1RemovalFailure" },
    { MTYPE_TRACE_START, "TraceStart" },
    { MTYPE_DEACTIVATE_TRACE, "DeactivateTrace" },
    { MTYPE_DU_CU_RADIO_INFORMATION_TRANSFER, "DUCURadioInformationTransfer" },
    { MTYPE_CU_DU_RADIO_INFORMATION_TRANSFER, "CUDURadioInformationTransfer" },
    { MTYPE_BAP_MAPPING_CONFIGURATION,             "BAPMappingConfiguration" },
    { MTYPE_BAP_MAPPING_CONFIGURATION_ACKNOWLEDGE, "BAPMappingConfigurationAcknowledge" },
    { MTYPE_BAP_MAPPING_CONFIGURATION_FAILURE,     "BAPMappingConfigurationFailure" },
    { MTYPE_GNB_DU_RESOURCE_CONFIGURATION,             "GNBDUResourceConfiguration" },
    { MTYPE_GNB_DU_RESOURCE_CONFIGURATION_ACKNOWLEDGE, "GNBDUResourceConfigurationAcknowledge" },
    { MTYPE_GNB_DU_RESOURCE_CONFIGURATION_FAILURE,     "GNBDUResourceConfigurationFailure" },
    { MTYPE_IAB_TNL_ADDRESS_REQUEST,  "IABTNLAddressRequest" },
    { MTYPE_IAB_TNL_ADDRESS_RESPONSE, "IABTNLAddressResponse" },
    { MTYPE_IAB_TNL_ADDRESS_FAILURE,  "IABTNLAddressFailure" },
    { MTYPE_IAB_UP_CONFIGURATION_UPDATE_REQUEST,  "IABUPConfigurationUpdateRequest" },
    { MTYPE_IAB_UP_CONFIGURATION_UPDATE_RESPONSE, "IABUPConfigurationUpdateResponse" },
    { MTYPE_IAB_UP_CONFIGURATION_UPDATE_FAILURE,  "IABUPConfigurationUpdateFailure" },
    { MTYPE_RESOURCE_STATUS_REQUEST,   "ResourceStatusRequest" },
    { MTYPE_RESOURCE_STATUS_RESPONSE,  "ResourceStatusResponse" },
    { MTYPE_RESOURCE_STATUS_FAILURE,   "ResourceStatusFailure" },
    { MTYPE_RESOURCE_STATUS_UPDATE,    "ResourceStatusUpdate" },
    { MTYPE_ACCESS_AND_MOBILITY_INDICATION, "AccessAndMobilityIndication" },
    { MTYPE_REFERENCE_TIME_INFORMATION_REPORTING_CONTROL, "ReferenceTimeInformationReportingControl" },
    { MTYPE_REFERENCE_TIME_INFORMATION_REPORT,            "ReferenceTimeInformationReport" },
    { MTYPE_ACCESS_SUCCESS, "AccessSuccess" },
    { MTYPE_CELL_TRAFFIC_TRACE, "CellTrafficTrace" },
    { MTYPE_POSITIONING_ASSISTANCE_INFORMATION_CONTROL,  "PositioningAssistanceInformationControl" },
    { MTYPE_POSITIONING_ASSISTANCE_INFORMATION_FEEDBACK, "PositioningAssistanceInformationFeedback" },
    { MTYPE_POSITIONING_MEASUREMENT_REQUEST,            "PositioningMeasurementRequest" },
    { MTYPE_POSITIONING_MEASUREMENT_RESPONSE,           "PositioningMeasurementResponse" },
    { MTYPE_POSITIONING_MEASUREMENT_FAILURE,            "PositioningMeasurementFailure" },
    { MTYPE_POSITIONING_MEASUREMENT_REPORT,             "PositioningMeasurementReport" },
    { MTYPE_POSITIONING_MEASUREMENT_ABORT,              "PositioningMeasurementAbort" },
    { MTYPE_POSITIONING_MEASUREMENT_FAILURE_INDICATION, "PositioningMeasurementFailureIndication" },
    { MTYPE_POSITIONING_MEASUREMENT_UPDATE,             "PositioningMeasurementUpdate" },
    { MTYPE_TRP_INFORMATION_REQUEST,  "TRPInformationRequest" },
    { MTYPE_TRP_INFORMATION_RESPONSE, "TRPInformationResponse" },
    { MTYPE_TRP_INFORMATION_FAILURE,  "TRPInformationFailure" },
    { MTYPE_POSITIONING_INFORMATION_REQUEST,  "PositioningInformationRequest" },
    { MTYPE_POSITIONING_INFORMATION_RESPONSE, "PositioningInformationResponse" },
    { MTYPE_POSITIONING_INFORMATION_FAILURE,  "PositioningInformationFailure" },
    { MTYPE_POSITIONING_ACTIVATION_REQUEST,   "PositioningActivationRequest" },
    { MTYPE_POSITIONING_ACTIVATION_RESPONSE,  "PositioningActivationResponse" },
    { MTYPE_POSITIONING_ACTIVATION_FAILURE,   "PositioningActivationFailure" },
    { MTYPE_POSITIONING_DEACTIVATION, "PositioningDeactivation" },
    { MTYPE_E_CID_MEASUREMENT_INITIATION_REQUEST,  "E-CIDMeasurementInitiationRequest" },
    { MTYPE_E_CID_MEASUREMENT_INITIATION_RESPONSE, "E-CIDMeasurementInitiationResponse" },
    { MTYPE_E_CID_MEASUREMENT_INITIATION_FAILURE,  "E-CIDMeasurementInitiationFailure" },
    { MTYPE_E_CID_MEASUREMENT_FAILURE_INDICATION,  "E-CIDMeasurementFailureIndication" },
    { MTYPE_E_CID_MEASUREMENT_REPORT,              "E-CIDMeasurementReport" },
    { MTYPE_E_CID_MEASUREMENT_TERMINATION_COMMAND, "E-CIDMeasurementTerminationCommand" },
    { MTYPE_POSITIONING_INFORMATION_UPDATE, "PositioningInformationUpdate" },
    { 0,  NULL }
};



typedef struct {
  guint32 message_type;
  guint32 procedure_code;
  guint32 protocol_ie_id;
  guint32 protocol_extension_id;
  const char *obj_id;
  guint32 sib_type;
  guint32 srb_id;
  e212_number_type_t number_type;
  struct f1ap_tap_t  *stats_tap;
} f1ap_private_data_t;

typedef struct {
  guint32 message_type;
  guint32 ProcedureCode;
  guint32 ProtocolIE_ID;
  guint32 ProtocolExtensionID;
} f1ap_ctx_t;

/* Global variables */
static dissector_handle_t f1ap_handle;
static dissector_handle_t nr_rrc_ul_ccch_handle;
static dissector_handle_t nr_rrc_dl_ccch_handle;
static dissector_handle_t nr_rrc_ul_dcch_handle;
static dissector_handle_t nr_pdcp_handle;
static dissector_handle_t lte_rrc_conn_reconf_handle;

/* Dissector tables */
static dissector_table_t f1ap_ies_dissector_table;
static dissector_table_t f1ap_extension_dissector_table;
static dissector_table_t f1ap_proc_imsg_dissector_table;
static dissector_table_t f1ap_proc_sout_dissector_table;
static dissector_table_t f1ap_proc_uout_dissector_table;

static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);

static const true_false_string f1ap_tfs_interfacesToTrace = {
  "Should be traced",
  "Should not be traced"
};


static proto_tree *top_tree = NULL;

static void set_message_label(asn1_ctx_t *actx, int type)
{
  const char *label = val_to_str_const(type, mtype_names, "Unknown");
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, label);
  /* N.B. would like to be able to use actx->subTree.top_tree, but not easy to set.. */
  proto_item_append_text(top_tree, " (%s)", label);
}



static void
f1ap_MaxPacketLossRate_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%.1f%% (%u)", (float)v/10, v);
}

static void
f1ap_PacketDelayBudget_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/2, v);
}

static void
f1ap_ExtendedPacketDelayBudget_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%.2fms (%u)", (float)v/100, v);
}

static f1ap_private_data_t*
f1ap_get_private_data(packet_info *pinfo)
{
  f1ap_private_data_t *f1ap_data = (f1ap_private_data_t*)p_get_proto_data(wmem_file_scope(), pinfo, proto_f1ap, 0);
  if (!f1ap_data) {
    f1ap_data = wmem_new0(wmem_file_scope(), f1ap_private_data_t);
    f1ap_data->srb_id = -1;
    p_add_proto_data(wmem_file_scope(), pinfo, proto_f1ap, 0, f1ap_data);
  }
  return f1ap_data;
}

static void
add_nr_pdcp_meta_data(packet_info *pinfo, guint8 direction, guint8 srb_id)
{
  pdcp_nr_info *p_pdcp_nr_info;

  /* Only need to set info once per session. */
  if (get_pdcp_nr_proto_data(pinfo)) {
      return;
  }

  p_pdcp_nr_info = wmem_new0(wmem_file_scope(), pdcp_nr_info);
  p_pdcp_nr_info->direction = direction;
  p_pdcp_nr_info->bearerType = Bearer_DCCH;
  p_pdcp_nr_info->bearerId = srb_id;
  p_pdcp_nr_info->plane = NR_SIGNALING_PLANE;
  p_pdcp_nr_info->seqnum_length = PDCP_NR_SN_LENGTH_12_BITS;
  p_pdcp_nr_info->maci_present = TRUE;
  set_pdcp_nr_proto_data(pinfo, p_pdcp_nr_info);
}


/*--- Included file: packet-f1ap-fn.c ---*/
#line 1 "./asn1/f1ap/packet-f1ap-fn.c"

static const value_string f1ap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_f1ap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_T_global(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 98 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_object_identifier_str(tvb, offset, actx, tree, hf_index, &f1ap_data->obj_id);




  return offset;
}


static const value_string f1ap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_f1ap_local          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_65535 },
  {   1, &hf_f1ap_global         , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_global },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 94 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->obj_id = NULL;


  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_ProcedureCode_vals[] = {
  { id_Reset, "id-Reset" },
  { id_F1Setup, "id-F1Setup" },
  { id_ErrorIndication, "id-ErrorIndication" },
  { id_gNBDUConfigurationUpdate, "id-gNBDUConfigurationUpdate" },
  { id_gNBCUConfigurationUpdate, "id-gNBCUConfigurationUpdate" },
  { id_UEContextSetup, "id-UEContextSetup" },
  { id_UEContextRelease, "id-UEContextRelease" },
  { id_UEContextModification, "id-UEContextModification" },
  { id_UEContextModificationRequired, "id-UEContextModificationRequired" },
  { id_UEMobilityCommand, "id-UEMobilityCommand" },
  { id_UEContextReleaseRequest, "id-UEContextReleaseRequest" },
  { id_InitialULRRCMessageTransfer, "id-InitialULRRCMessageTransfer" },
  { id_DLRRCMessageTransfer, "id-DLRRCMessageTransfer" },
  { id_ULRRCMessageTransfer, "id-ULRRCMessageTransfer" },
  { id_privateMessage, "id-privateMessage" },
  { id_UEInactivityNotification, "id-UEInactivityNotification" },
  { id_GNBDUResourceCoordination, "id-GNBDUResourceCoordination" },
  { id_SystemInformationDeliveryCommand, "id-SystemInformationDeliveryCommand" },
  { id_Paging, "id-Paging" },
  { id_Notify, "id-Notify" },
  { id_WriteReplaceWarning, "id-WriteReplaceWarning" },
  { id_PWSCancel, "id-PWSCancel" },
  { id_PWSRestartIndication, "id-PWSRestartIndication" },
  { id_PWSFailureIndication, "id-PWSFailureIndication" },
  { id_GNBDUStatusIndication, "id-GNBDUStatusIndication" },
  { id_RRCDeliveryReport, "id-RRCDeliveryReport" },
  { id_F1Removal, "id-F1Removal" },
  { id_NetworkAccessRateReduction, "id-NetworkAccessRateReduction" },
  { id_TraceStart, "id-TraceStart" },
  { id_DeactivateTrace, "id-DeactivateTrace" },
  { id_DUCURadioInformationTransfer, "id-DUCURadioInformationTransfer" },
  { id_CUDURadioInformationTransfer, "id-CUDURadioInformationTransfer" },
  { id_BAPMappingConfiguration, "id-BAPMappingConfiguration" },
  { id_GNBDUResourceConfiguration, "id-GNBDUResourceConfiguration" },
  { id_IABTNLAddressAllocation, "id-IABTNLAddressAllocation" },
  { id_IABUPConfigurationUpdate, "id-IABUPConfigurationUpdate" },
  { id_resourceStatusReportingInitiation, "id-resourceStatusReportingInitiation" },
  { id_resourceStatusReporting, "id-resourceStatusReporting" },
  { id_accessAndMobilityIndication, "id-accessAndMobilityIndication" },
  { id_accessSuccess, "id-accessSuccess" },
  { id_cellTrafficTrace, "id-cellTrafficTrace" },
  { id_PositioningMeasurementExchange, "id-PositioningMeasurementExchange" },
  { id_PositioningAssistanceInformationControl, "id-PositioningAssistanceInformationControl" },
  { id_PositioningAssistanceInformationFeedback, "id-PositioningAssistanceInformationFeedback" },
  { id_PositioningMeasurementReport, "id-PositioningMeasurementReport" },
  { id_PositioningMeasurementAbort, "id-PositioningMeasurementAbort" },
  { id_PositioningMeasurementFailureIndication, "id-PositioningMeasurementFailureIndication" },
  { id_PositioningMeasurementUpdate, "id-PositioningMeasurementUpdate" },
  { id_TRPInformationExchange, "id-TRPInformationExchange" },
  { id_PositioningInformationExchange, "id-PositioningInformationExchange" },
  { id_PositioningActivation, "id-PositioningActivation" },
  { id_PositioningDeactivation, "id-PositioningDeactivation" },
  { id_E_CIDMeasurementInitiation, "id-E-CIDMeasurementInitiation" },
  { id_E_CIDMeasurementFailureIndication, "id-E-CIDMeasurementFailureIndication" },
  { id_E_CIDMeasurementReport, "id-E-CIDMeasurementReport" },
  { id_E_CIDMeasurementTermination, "id-E-CIDMeasurementTermination" },
  { id_PositioningInformationUpdate, "id-PositioningInformationUpdate" },
  { id_ReferenceTimeInformationReport, "id-ReferenceTimeInformationReport" },
  { id_ReferenceTimeInformationReportingControl, "id-ReferenceTimeInformationReportingControl" },
  { 0, NULL }
};

static value_string_ext f1ap_ProcedureCode_vals_ext = VALUE_STRING_EXT_INIT(f1ap_ProcedureCode_vals);


static int
dissect_f1ap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 75 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &f1ap_data->procedure_code, FALSE);



  return offset;
}



static int
dissect_f1ap_ProtocolExtensionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 69 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, &f1ap_data->protocol_extension_id, FALSE);




  return offset;
}


static const value_string f1ap_ProtocolIE_ID_vals[] = {
  { id_Cause, "id-Cause" },
  { id_Cells_Failed_to_be_Activated_List, "id-Cells-Failed-to-be-Activated-List" },
  { id_Cells_Failed_to_be_Activated_List_Item, "id-Cells-Failed-to-be-Activated-List-Item" },
  { id_Cells_to_be_Activated_List, "id-Cells-to-be-Activated-List" },
  { id_Cells_to_be_Activated_List_Item, "id-Cells-to-be-Activated-List-Item" },
  { id_Cells_to_be_Deactivated_List, "id-Cells-to-be-Deactivated-List" },
  { id_Cells_to_be_Deactivated_List_Item, "id-Cells-to-be-Deactivated-List-Item" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_CUtoDURRCInformation, "id-CUtoDURRCInformation" },
  { id_Unknown_10, "id-Unknown-10" },
  { id_Unknown_11, "id-Unknown-11" },
  { id_DRBs_FailedToBeModified_Item, "id-DRBs-FailedToBeModified-Item" },
  { id_DRBs_FailedToBeModified_List, "id-DRBs-FailedToBeModified-List" },
  { id_DRBs_FailedToBeSetup_Item, "id-DRBs-FailedToBeSetup-Item" },
  { id_DRBs_FailedToBeSetup_List, "id-DRBs-FailedToBeSetup-List" },
  { id_DRBs_FailedToBeSetupMod_Item, "id-DRBs-FailedToBeSetupMod-Item" },
  { id_DRBs_FailedToBeSetupMod_List, "id-DRBs-FailedToBeSetupMod-List" },
  { id_DRBs_ModifiedConf_Item, "id-DRBs-ModifiedConf-Item" },
  { id_DRBs_ModifiedConf_List, "id-DRBs-ModifiedConf-List" },
  { id_DRBs_Modified_Item, "id-DRBs-Modified-Item" },
  { id_DRBs_Modified_List, "id-DRBs-Modified-List" },
  { id_DRBs_Required_ToBeModified_Item, "id-DRBs-Required-ToBeModified-Item" },
  { id_DRBs_Required_ToBeModified_List, "id-DRBs-Required-ToBeModified-List" },
  { id_DRBs_Required_ToBeReleased_Item, "id-DRBs-Required-ToBeReleased-Item" },
  { id_DRBs_Required_ToBeReleased_List, "id-DRBs-Required-ToBeReleased-List" },
  { id_DRBs_Setup_Item, "id-DRBs-Setup-Item" },
  { id_DRBs_Setup_List, "id-DRBs-Setup-List" },
  { id_DRBs_SetupMod_Item, "id-DRBs-SetupMod-Item" },
  { id_DRBs_SetupMod_List, "id-DRBs-SetupMod-List" },
  { id_DRBs_ToBeModified_Item, "id-DRBs-ToBeModified-Item" },
  { id_DRBs_ToBeModified_List, "id-DRBs-ToBeModified-List" },
  { id_DRBs_ToBeReleased_Item, "id-DRBs-ToBeReleased-Item" },
  { id_DRBs_ToBeReleased_List, "id-DRBs-ToBeReleased-List" },
  { id_DRBs_ToBeSetup_Item, "id-DRBs-ToBeSetup-Item" },
  { id_DRBs_ToBeSetup_List, "id-DRBs-ToBeSetup-List" },
  { id_DRBs_ToBeSetupMod_Item, "id-DRBs-ToBeSetupMod-Item" },
  { id_DRBs_ToBeSetupMod_List, "id-DRBs-ToBeSetupMod-List" },
  { id_DRXCycle, "id-DRXCycle" },
  { id_DUtoCURRCInformation, "id-DUtoCURRCInformation" },
  { id_gNB_CU_UE_F1AP_ID, "id-gNB-CU-UE-F1AP-ID" },
  { id_gNB_DU_UE_F1AP_ID, "id-gNB-DU-UE-F1AP-ID" },
  { id_gNB_DU_ID, "id-gNB-DU-ID" },
  { id_GNB_DU_Served_Cells_Item, "id-GNB-DU-Served-Cells-Item" },
  { id_gNB_DU_Served_Cells_List, "id-gNB-DU-Served-Cells-List" },
  { id_gNB_DU_Name, "id-gNB-DU-Name" },
  { id_NRCellID, "id-NRCellID" },
  { id_oldgNB_DU_UE_F1AP_ID, "id-oldgNB-DU-UE-F1AP-ID" },
  { id_ResetType, "id-ResetType" },
  { id_ResourceCoordinationTransferContainer, "id-ResourceCoordinationTransferContainer" },
  { id_RRCContainer, "id-RRCContainer" },
  { id_SCell_ToBeRemoved_Item, "id-SCell-ToBeRemoved-Item" },
  { id_SCell_ToBeRemoved_List, "id-SCell-ToBeRemoved-List" },
  { id_SCell_ToBeSetup_Item, "id-SCell-ToBeSetup-Item" },
  { id_SCell_ToBeSetup_List, "id-SCell-ToBeSetup-List" },
  { id_SCell_ToBeSetupMod_Item, "id-SCell-ToBeSetupMod-Item" },
  { id_SCell_ToBeSetupMod_List, "id-SCell-ToBeSetupMod-List" },
  { id_Served_Cells_To_Add_Item, "id-Served-Cells-To-Add-Item" },
  { id_Served_Cells_To_Add_List, "id-Served-Cells-To-Add-List" },
  { id_Served_Cells_To_Delete_Item, "id-Served-Cells-To-Delete-Item" },
  { id_Served_Cells_To_Delete_List, "id-Served-Cells-To-Delete-List" },
  { id_Served_Cells_To_Modify_Item, "id-Served-Cells-To-Modify-Item" },
  { id_Served_Cells_To_Modify_List, "id-Served-Cells-To-Modify-List" },
  { id_SpCell_ID, "id-SpCell-ID" },
  { id_SRBID, "id-SRBID" },
  { id_SRBs_FailedToBeSetup_Item, "id-SRBs-FailedToBeSetup-Item" },
  { id_SRBs_FailedToBeSetup_List, "id-SRBs-FailedToBeSetup-List" },
  { id_SRBs_FailedToBeSetupMod_Item, "id-SRBs-FailedToBeSetupMod-Item" },
  { id_SRBs_FailedToBeSetupMod_List, "id-SRBs-FailedToBeSetupMod-List" },
  { id_SRBs_Required_ToBeReleased_Item, "id-SRBs-Required-ToBeReleased-Item" },
  { id_SRBs_Required_ToBeReleased_List, "id-SRBs-Required-ToBeReleased-List" },
  { id_SRBs_ToBeReleased_Item, "id-SRBs-ToBeReleased-Item" },
  { id_SRBs_ToBeReleased_List, "id-SRBs-ToBeReleased-List" },
  { id_SRBs_ToBeSetup_Item, "id-SRBs-ToBeSetup-Item" },
  { id_SRBs_ToBeSetup_List, "id-SRBs-ToBeSetup-List" },
  { id_SRBs_ToBeSetupMod_Item, "id-SRBs-ToBeSetupMod-Item" },
  { id_SRBs_ToBeSetupMod_List, "id-SRBs-ToBeSetupMod-List" },
  { id_TimeToWait, "id-TimeToWait" },
  { id_TransactionID, "id-TransactionID" },
  { id_TransmissionActionIndicator, "id-TransmissionActionIndicator" },
  { id_UE_associatedLogicalF1_ConnectionItem, "id-UE-associatedLogicalF1-ConnectionItem" },
  { id_UE_associatedLogicalF1_ConnectionListResAck, "id-UE-associatedLogicalF1-ConnectionListResAck" },
  { id_gNB_CU_Name, "id-gNB-CU-Name" },
  { id_SCell_FailedtoSetup_List, "id-SCell-FailedtoSetup-List" },
  { id_SCell_FailedtoSetup_Item, "id-SCell-FailedtoSetup-Item" },
  { id_SCell_FailedtoSetupMod_List, "id-SCell-FailedtoSetupMod-List" },
  { id_SCell_FailedtoSetupMod_Item, "id-SCell-FailedtoSetupMod-Item" },
  { id_RRCReconfigurationCompleteIndicator, "id-RRCReconfigurationCompleteIndicator" },
  { id_Cells_Status_Item, "id-Cells-Status-Item" },
  { id_Cells_Status_List, "id-Cells-Status-List" },
  { id_Candidate_SpCell_List, "id-Candidate-SpCell-List" },
  { id_Candidate_SpCell_Item, "id-Candidate-SpCell-Item" },
  { id_Potential_SpCell_List, "id-Potential-SpCell-List" },
  { id_Potential_SpCell_Item, "id-Potential-SpCell-Item" },
  { id_FullConfiguration, "id-FullConfiguration" },
  { id_C_RNTI, "id-C-RNTI" },
  { id_SpCellULConfigured, "id-SpCellULConfigured" },
  { id_InactivityMonitoringRequest, "id-InactivityMonitoringRequest" },
  { id_InactivityMonitoringResponse, "id-InactivityMonitoringResponse" },
  { id_DRB_Activity_Item, "id-DRB-Activity-Item" },
  { id_DRB_Activity_List, "id-DRB-Activity-List" },
  { id_EUTRA_NR_CellResourceCoordinationReq_Container, "id-EUTRA-NR-CellResourceCoordinationReq-Container" },
  { id_EUTRA_NR_CellResourceCoordinationReqAck_Container, "id-EUTRA-NR-CellResourceCoordinationReqAck-Container" },
  { id_Unknown_103, "id-Unknown-103" },
  { id_Unknown_104, "id-Unknown-104" },
  { id_Protected_EUTRA_Resources_List, "id-Protected-EUTRA-Resources-List" },
  { id_RequestType, "id-RequestType" },
  { id_ServCellIndex, "id-ServCellIndex" },
  { id_RAT_FrequencyPriorityInformation, "id-RAT-FrequencyPriorityInformation" },
  { id_ExecuteDuplication, "id-ExecuteDuplication" },
  { id_Unknown_110, "id-Unknown-110" },
  { id_NRCGI, "id-NRCGI" },
  { id_PagingCell_Item, "id-PagingCell-Item" },
  { id_PagingCell_List, "id-PagingCell-List" },
  { id_PagingDRX, "id-PagingDRX" },
  { id_PagingPriority, "id-PagingPriority" },
  { id_SItype_List, "id-SItype-List" },
  { id_UEIdentityIndexValue, "id-UEIdentityIndexValue" },
  { id_gNB_CUSystemInformation, "id-gNB-CUSystemInformation" },
  { id_HandoverPreparationInformation, "id-HandoverPreparationInformation" },
  { id_GNB_CU_TNL_Association_To_Add_Item, "id-GNB-CU-TNL-Association-To-Add-Item" },
  { id_GNB_CU_TNL_Association_To_Add_List, "id-GNB-CU-TNL-Association-To-Add-List" },
  { id_GNB_CU_TNL_Association_To_Remove_Item, "id-GNB-CU-TNL-Association-To-Remove-Item" },
  { id_GNB_CU_TNL_Association_To_Remove_List, "id-GNB-CU-TNL-Association-To-Remove-List" },
  { id_GNB_CU_TNL_Association_To_Update_Item, "id-GNB-CU-TNL-Association-To-Update-Item" },
  { id_GNB_CU_TNL_Association_To_Update_List, "id-GNB-CU-TNL-Association-To-Update-List" },
  { id_MaskedIMEISV, "id-MaskedIMEISV" },
  { id_PagingIdentity, "id-PagingIdentity" },
  { id_DUtoCURRCContainer, "id-DUtoCURRCContainer" },
  { id_Cells_to_be_Barred_List, "id-Cells-to-be-Barred-List" },
  { id_Cells_to_be_Barred_Item, "id-Cells-to-be-Barred-Item" },
  { id_TAISliceSupportList, "id-TAISliceSupportList" },
  { id_GNB_CU_TNL_Association_Setup_List, "id-GNB-CU-TNL-Association-Setup-List" },
  { id_GNB_CU_TNL_Association_Setup_Item, "id-GNB-CU-TNL-Association-Setup-Item" },
  { id_GNB_CU_TNL_Association_Failed_To_Setup_List, "id-GNB-CU-TNL-Association-Failed-To-Setup-List" },
  { id_GNB_CU_TNL_Association_Failed_To_Setup_Item, "id-GNB-CU-TNL-Association-Failed-To-Setup-Item" },
  { id_DRB_Notify_Item, "id-DRB-Notify-Item" },
  { id_DRB_Notify_List, "id-DRB-Notify-List" },
  { id_NotficationControl, "id-NotficationControl" },
  { id_RANAC, "id-RANAC" },
  { id_PWSSystemInformation, "id-PWSSystemInformation" },
  { id_RepetitionPeriod, "id-RepetitionPeriod" },
  { id_NumberofBroadcastRequest, "id-NumberofBroadcastRequest" },
  { id_Unknown_143, "id-Unknown-143" },
  { id_Cells_To_Be_Broadcast_List, "id-Cells-To-Be-Broadcast-List" },
  { id_Cells_To_Be_Broadcast_Item, "id-Cells-To-Be-Broadcast-Item" },
  { id_Cells_Broadcast_Completed_List, "id-Cells-Broadcast-Completed-List" },
  { id_Cells_Broadcast_Completed_Item, "id-Cells-Broadcast-Completed-Item" },
  { id_Broadcast_To_Be_Cancelled_List, "id-Broadcast-To-Be-Cancelled-List" },
  { id_Broadcast_To_Be_Cancelled_Item, "id-Broadcast-To-Be-Cancelled-Item" },
  { id_Cells_Broadcast_Cancelled_List, "id-Cells-Broadcast-Cancelled-List" },
  { id_Cells_Broadcast_Cancelled_Item, "id-Cells-Broadcast-Cancelled-Item" },
  { id_NR_CGI_List_For_Restart_List, "id-NR-CGI-List-For-Restart-List" },
  { id_NR_CGI_List_For_Restart_Item, "id-NR-CGI-List-For-Restart-Item" },
  { id_PWS_Failed_NR_CGI_List, "id-PWS-Failed-NR-CGI-List" },
  { id_PWS_Failed_NR_CGI_Item, "id-PWS-Failed-NR-CGI-Item" },
  { id_ConfirmedUEID, "id-ConfirmedUEID" },
  { id_Cancel_all_Warning_Messages_Indicator, "id-Cancel-all-Warning-Messages-Indicator" },
  { id_GNB_DU_UE_AMBR_UL, "id-GNB-DU-UE-AMBR-UL" },
  { id_DRXConfigurationIndicator, "id-DRXConfigurationIndicator" },
  { id_RLC_Status, "id-RLC-Status" },
  { id_DLPDCPSNLength, "id-DLPDCPSNLength" },
  { id_GNB_DUConfigurationQuery, "id-GNB-DUConfigurationQuery" },
  { id_MeasurementTimingConfiguration, "id-MeasurementTimingConfiguration" },
  { id_DRB_Information, "id-DRB-Information" },
  { id_ServingPLMN, "id-ServingPLMN" },
  { id_Unknown_166, "id-Unknown-166" },
  { id_Unknown_167, "id-Unknown-167" },
  { id_Protected_EUTRA_Resources_Item, "id-Protected-EUTRA-Resources-Item" },
  { id_Unknown_169, "id-Unknown-169" },
  { id_GNB_CU_RRC_Version, "id-GNB-CU-RRC-Version" },
  { id_GNB_DU_RRC_Version, "id-GNB-DU-RRC-Version" },
  { id_GNBDUOverloadInformation, "id-GNBDUOverloadInformation" },
  { id_CellGroupConfig, "id-CellGroupConfig" },
  { id_RLCFailureIndication, "id-RLCFailureIndication" },
  { id_UplinkTxDirectCurrentListInformation, "id-UplinkTxDirectCurrentListInformation" },
  { id_DC_Based_Duplication_Configured, "id-DC-Based-Duplication-Configured" },
  { id_DC_Based_Duplication_Activation, "id-DC-Based-Duplication-Activation" },
  { id_SULAccessIndication, "id-SULAccessIndication" },
  { id_AvailablePLMNList, "id-AvailablePLMNList" },
  { id_PDUSessionID, "id-PDUSessionID" },
  { id_ULPDUSessionAggregateMaximumBitRate, "id-ULPDUSessionAggregateMaximumBitRate" },
  { id_ServingCellMO, "id-ServingCellMO" },
  { id_QoSFlowMappingIndication, "id-QoSFlowMappingIndication" },
  { id_RRCDeliveryStatusRequest, "id-RRCDeliveryStatusRequest" },
  { id_RRCDeliveryStatus, "id-RRCDeliveryStatus" },
  { id_BearerTypeChange, "id-BearerTypeChange" },
  { id_RLCMode, "id-RLCMode" },
  { id_Duplication_Activation, "id-Duplication-Activation" },
  { id_Dedicated_SIDelivery_NeededUE_List, "id-Dedicated-SIDelivery-NeededUE-List" },
  { id_Dedicated_SIDelivery_NeededUE_Item, "id-Dedicated-SIDelivery-NeededUE-Item" },
  { id_DRX_LongCycleStartOffset, "id-DRX-LongCycleStartOffset" },
  { id_ULPDCPSNLength, "id-ULPDCPSNLength" },
  { id_SelectedBandCombinationIndex, "id-SelectedBandCombinationIndex" },
  { id_SelectedFeatureSetEntryIndex, "id-SelectedFeatureSetEntryIndex" },
  { id_ResourceCoordinationTransferInformation, "id-ResourceCoordinationTransferInformation" },
  { id_ExtendedServedPLMNs_List, "id-ExtendedServedPLMNs-List" },
  { id_ExtendedAvailablePLMN_List, "id-ExtendedAvailablePLMN-List" },
  { id_Associated_SCell_List, "id-Associated-SCell-List" },
  { id_latest_RRC_Version_Enhanced, "id-latest-RRC-Version-Enhanced" },
  { id_Associated_SCell_Item, "id-Associated-SCell-Item" },
  { id_Cell_Direction, "id-Cell-Direction" },
  { id_SRBs_Setup_List, "id-SRBs-Setup-List" },
  { id_SRBs_Setup_Item, "id-SRBs-Setup-Item" },
  { id_SRBs_SetupMod_List, "id-SRBs-SetupMod-List" },
  { id_SRBs_SetupMod_Item, "id-SRBs-SetupMod-Item" },
  { id_SRBs_Modified_List, "id-SRBs-Modified-List" },
  { id_SRBs_Modified_Item, "id-SRBs-Modified-Item" },
  { id_Ph_InfoSCG, "id-Ph-InfoSCG" },
  { id_RequestedBandCombinationIndex, "id-RequestedBandCombinationIndex" },
  { id_RequestedFeatureSetEntryIndex, "id-RequestedFeatureSetEntryIndex" },
  { id_RequestedP_MaxFR2, "id-RequestedP-MaxFR2" },
  { id_DRX_Config, "id-DRX-Config" },
  { id_IgnoreResourceCoordinationContainer, "id-IgnoreResourceCoordinationContainer" },
  { id_UEAssistanceInformation, "id-UEAssistanceInformation" },
  { id_NeedforGap, "id-NeedforGap" },
  { id_PagingOrigin, "id-PagingOrigin" },
  { id_new_gNB_CU_UE_F1AP_ID, "id-new-gNB-CU-UE-F1AP-ID" },
  { id_RedirectedRRCmessage, "id-RedirectedRRCmessage" },
  { id_new_gNB_DU_UE_F1AP_ID, "id-new-gNB-DU-UE-F1AP-ID" },
  { id_NotificationInformation, "id-NotificationInformation" },
  { id_PLMNAssistanceInfoForNetShar, "id-PLMNAssistanceInfoForNetShar" },
  { id_UEContextNotRetrievable, "id-UEContextNotRetrievable" },
  { id_BPLMN_ID_Info_List, "id-BPLMN-ID-Info-List" },
  { id_SelectedPLMNID, "id-SelectedPLMNID" },
  { id_UAC_Assistance_Info, "id-UAC-Assistance-Info" },
  { id_RANUEID, "id-RANUEID" },
  { id_GNB_DU_TNL_Association_To_Remove_Item, "id-GNB-DU-TNL-Association-To-Remove-Item" },
  { id_GNB_DU_TNL_Association_To_Remove_List, "id-GNB-DU-TNL-Association-To-Remove-List" },
  { id_TNLAssociationTransportLayerAddressgNBDU, "id-TNLAssociationTransportLayerAddressgNBDU" },
  { id_portNumber, "id-portNumber" },
  { id_AdditionalSIBMessageList, "id-AdditionalSIBMessageList" },
  { id_Cell_Type, "id-Cell-Type" },
  { id_IgnorePRACHConfiguration, "id-IgnorePRACHConfiguration" },
  { id_CG_Config, "id-CG-Config" },
  { id_PDCCH_BlindDetectionSCG, "id-PDCCH-BlindDetectionSCG" },
  { id_Requested_PDCCH_BlindDetectionSCG, "id-Requested-PDCCH-BlindDetectionSCG" },
  { id_Ph_InfoMCG, "id-Ph-InfoMCG" },
  { id_MeasGapSharingConfig, "id-MeasGapSharingConfig" },
  { id_systemInformationAreaID, "id-systemInformationAreaID" },
  { id_areaScope, "id-areaScope" },
  { id_RRCContainer_RRCSetupComplete, "id-RRCContainer-RRCSetupComplete" },
  { id_TraceActivation, "id-TraceActivation" },
  { id_TraceID, "id-TraceID" },
  { id_Neighbour_Cell_Information_List, "id-Neighbour-Cell-Information-List" },
  { id_Unknown_245, "id-Unknown-245" },
  { id_SymbolAllocInSlot, "id-SymbolAllocInSlot" },
  { id_NumDLULSymbols, "id-NumDLULSymbols" },
  { id_AdditionalRRMPriorityIndex, "id-AdditionalRRMPriorityIndex" },
  { id_DUCURadioInformationType, "id-DUCURadioInformationType" },
  { id_CUDURadioInformationType, "id-CUDURadioInformationType" },
  { id_AggressorgNBSetID, "id-AggressorgNBSetID" },
  { id_VictimgNBSetID, "id-VictimgNBSetID" },
  { id_LowerLayerPresenceStatusChange, "id-LowerLayerPresenceStatusChange" },
  { id_Transport_Layer_Address_Info, "id-Transport-Layer-Address-Info" },
  { id_Neighbour_Cell_Information_Item, "id-Neighbour-Cell-Information-Item" },
  { id_IntendedTDD_DL_ULConfig, "id-IntendedTDD-DL-ULConfig" },
  { id_QosMonitoringRequest, "id-QosMonitoringRequest" },
  { id_BHChannels_ToBeSetup_List, "id-BHChannels-ToBeSetup-List" },
  { id_BHChannels_ToBeSetup_Item, "id-BHChannels-ToBeSetup-Item" },
  { id_BHChannels_Setup_List, "id-BHChannels-Setup-List" },
  { id_BHChannels_Setup_Item, "id-BHChannels-Setup-Item" },
  { id_BHChannels_ToBeModified_Item, "id-BHChannels-ToBeModified-Item" },
  { id_BHChannels_ToBeModified_List, "id-BHChannels-ToBeModified-List" },
  { id_BHChannels_ToBeReleased_Item, "id-BHChannels-ToBeReleased-Item" },
  { id_BHChannels_ToBeReleased_List, "id-BHChannels-ToBeReleased-List" },
  { id_BHChannels_ToBeSetupMod_Item, "id-BHChannels-ToBeSetupMod-Item" },
  { id_BHChannels_ToBeSetupMod_List, "id-BHChannels-ToBeSetupMod-List" },
  { id_BHChannels_FailedToBeModified_Item, "id-BHChannels-FailedToBeModified-Item" },
  { id_BHChannels_FailedToBeModified_List, "id-BHChannels-FailedToBeModified-List" },
  { id_BHChannels_FailedToBeSetupMod_Item, "id-BHChannels-FailedToBeSetupMod-Item" },
  { id_BHChannels_FailedToBeSetupMod_List, "id-BHChannels-FailedToBeSetupMod-List" },
  { id_BHChannels_Modified_Item, "id-BHChannels-Modified-Item" },
  { id_BHChannels_Modified_List, "id-BHChannels-Modified-List" },
  { id_BHChannels_SetupMod_Item, "id-BHChannels-SetupMod-Item" },
  { id_BHChannels_SetupMod_List, "id-BHChannels-SetupMod-List" },
  { id_BHChannels_Required_ToBeReleased_Item, "id-BHChannels-Required-ToBeReleased-Item" },
  { id_BHChannels_Required_ToBeReleased_List, "id-BHChannels-Required-ToBeReleased-List" },
  { id_BHChannels_FailedToBeSetup_Item, "id-BHChannels-FailedToBeSetup-Item" },
  { id_BHChannels_FailedToBeSetup_List, "id-BHChannels-FailedToBeSetup-List" },
  { id_BHInfo, "id-BHInfo" },
  { id_BAPAddress, "id-BAPAddress" },
  { id_ConfiguredBAPAddress, "id-ConfiguredBAPAddress" },
  { id_BH_Routing_Information_Added_List, "id-BH-Routing-Information-Added-List" },
  { id_BH_Routing_Information_Added_List_Item, "id-BH-Routing-Information-Added-List-Item" },
  { id_BH_Routing_Information_Removed_List, "id-BH-Routing-Information-Removed-List" },
  { id_BH_Routing_Information_Removed_List_Item, "id-BH-Routing-Information-Removed-List-Item" },
  { id_UL_BH_Non_UP_Traffic_Mapping, "id-UL-BH-Non-UP-Traffic-Mapping" },
  { id_Activated_Cells_to_be_Updated_List, "id-Activated-Cells-to-be-Updated-List" },
  { id_Child_Nodes_List, "id-Child-Nodes-List" },
  { id_IAB_Info_IAB_DU, "id-IAB-Info-IAB-DU" },
  { id_IAB_Info_IAB_donor_CU, "id-IAB-Info-IAB-donor-CU" },
  { id_IAB_TNL_Addresses_To_Remove_List, "id-IAB-TNL-Addresses-To-Remove-List" },
  { id_IAB_TNL_Addresses_To_Remove_Item, "id-IAB-TNL-Addresses-To-Remove-Item" },
  { id_IAB_Allocated_TNL_Address_List, "id-IAB-Allocated-TNL-Address-List" },
  { id_IAB_Allocated_TNL_Address_Item, "id-IAB-Allocated-TNL-Address-Item" },
  { id_IABIPv6RequestType, "id-IABIPv6RequestType" },
  { id_IABv4AddressesRequested, "id-IABv4AddressesRequested" },
  { id_IAB_Barred, "id-IAB-Barred" },
  { id_TrafficMappingInformation, "id-TrafficMappingInformation" },
  { id_UL_UP_TNL_Information_to_Update_List, "id-UL-UP-TNL-Information-to-Update-List" },
  { id_UL_UP_TNL_Information_to_Update_List_Item, "id-UL-UP-TNL-Information-to-Update-List-Item" },
  { id_UL_UP_TNL_Address_to_Update_List, "id-UL-UP-TNL-Address-to-Update-List" },
  { id_UL_UP_TNL_Address_to_Update_List_Item, "id-UL-UP-TNL-Address-to-Update-List-Item" },
  { id_DL_UP_TNL_Address_to_Update_List, "id-DL-UP-TNL-Address-to-Update-List" },
  { id_DL_UP_TNL_Address_to_Update_List_Item, "id-DL-UP-TNL-Address-to-Update-List-Item" },
  { id_NRV2XServicesAuthorized, "id-NRV2XServicesAuthorized" },
  { id_LTEV2XServicesAuthorized, "id-LTEV2XServicesAuthorized" },
  { id_NRUESidelinkAggregateMaximumBitrate, "id-NRUESidelinkAggregateMaximumBitrate" },
  { id_LTEUESidelinkAggregateMaximumBitrate, "id-LTEUESidelinkAggregateMaximumBitrate" },
  { id_SIB12_message, "id-SIB12-message" },
  { id_SIB13_message, "id-SIB13-message" },
  { id_SIB14_message, "id-SIB14-message" },
  { id_SLDRBs_FailedToBeModified_Item, "id-SLDRBs-FailedToBeModified-Item" },
  { id_SLDRBs_FailedToBeModified_List, "id-SLDRBs-FailedToBeModified-List" },
  { id_SLDRBs_FailedToBeSetup_Item, "id-SLDRBs-FailedToBeSetup-Item" },
  { id_SLDRBs_FailedToBeSetup_List, "id-SLDRBs-FailedToBeSetup-List" },
  { id_SLDRBs_Modified_Item, "id-SLDRBs-Modified-Item" },
  { id_SLDRBs_Modified_List, "id-SLDRBs-Modified-List" },
  { id_SLDRBs_Required_ToBeModified_Item, "id-SLDRBs-Required-ToBeModified-Item" },
  { id_SLDRBs_Required_ToBeModified_List, "id-SLDRBs-Required-ToBeModified-List" },
  { id_SLDRBs_Required_ToBeReleased_Item, "id-SLDRBs-Required-ToBeReleased-Item" },
  { id_SLDRBs_Required_ToBeReleased_List, "id-SLDRBs-Required-ToBeReleased-List" },
  { id_SLDRBs_Setup_Item, "id-SLDRBs-Setup-Item" },
  { id_SLDRBs_Setup_List, "id-SLDRBs-Setup-List" },
  { id_SLDRBs_ToBeModified_Item, "id-SLDRBs-ToBeModified-Item" },
  { id_SLDRBs_ToBeModified_List, "id-SLDRBs-ToBeModified-List" },
  { id_SLDRBs_ToBeReleased_Item, "id-SLDRBs-ToBeReleased-Item" },
  { id_SLDRBs_ToBeReleased_List, "id-SLDRBs-ToBeReleased-List" },
  { id_SLDRBs_ToBeSetup_Item, "id-SLDRBs-ToBeSetup-Item" },
  { id_SLDRBs_ToBeSetup_List, "id-SLDRBs-ToBeSetup-List" },
  { id_SLDRBs_ToBeSetupMod_Item, "id-SLDRBs-ToBeSetupMod-Item" },
  { id_SLDRBs_ToBeSetupMod_List, "id-SLDRBs-ToBeSetupMod-List" },
  { id_SLDRBs_SetupMod_List, "id-SLDRBs-SetupMod-List" },
  { id_SLDRBs_FailedToBeSetupMod_List, "id-SLDRBs-FailedToBeSetupMod-List" },
  { id_SLDRBs_SetupMod_Item, "id-SLDRBs-SetupMod-Item" },
  { id_SLDRBs_FailedToBeSetupMod_Item, "id-SLDRBs-FailedToBeSetupMod-Item" },
  { id_SLDRBs_ModifiedConf_List, "id-SLDRBs-ModifiedConf-List" },
  { id_SLDRBs_ModifiedConf_Item, "id-SLDRBs-ModifiedConf-Item" },
  { id_UEAssistanceInformationEUTRA, "id-UEAssistanceInformationEUTRA" },
  { id_PC5LinkAMBR, "id-PC5LinkAMBR" },
  { id_SL_PHY_MAC_RLC_Config, "id-SL-PHY-MAC-RLC-Config" },
  { id_SL_ConfigDedicatedEUTRA_Info, "id-SL-ConfigDedicatedEUTRA-Info" },
  { id_AlternativeQoSParaSetList, "id-AlternativeQoSParaSetList" },
  { id_CurrentQoSParaSetIndex, "id-CurrentQoSParaSetIndex" },
  { id_gNBCUMeasurementID, "id-gNBCUMeasurementID" },
  { id_gNBDUMeasurementID, "id-gNBDUMeasurementID" },
  { id_RegistrationRequest, "id-RegistrationRequest" },
  { id_ReportCharacteristics, "id-ReportCharacteristics" },
  { id_CellToReportList, "id-CellToReportList" },
  { id_CellMeasurementResultList, "id-CellMeasurementResultList" },
  { id_HardwareLoadIndicator, "id-HardwareLoadIndicator" },
  { id_ReportingPeriodicity, "id-ReportingPeriodicity" },
  { id_TNLCapacityIndicator, "id-TNLCapacityIndicator" },
  { id_CarrierList, "id-CarrierList" },
  { id_ULCarrierList, "id-ULCarrierList" },
  { id_FrequencyShift7p5khz, "id-FrequencyShift7p5khz" },
  { id_SSB_PositionsInBurst, "id-SSB-PositionsInBurst" },
  { id_NRPRACHConfig, "id-NRPRACHConfig" },
  { id_RACHReportInformationList, "id-RACHReportInformationList" },
  { id_RLFReportInformationList, "id-RLFReportInformationList" },
  { id_TDD_UL_DLConfigCommonNR, "id-TDD-UL-DLConfigCommonNR" },
  { id_CNPacketDelayBudgetDownlink, "id-CNPacketDelayBudgetDownlink" },
  { id_ExtendedPacketDelayBudget, "id-ExtendedPacketDelayBudget" },
  { id_TSCTrafficCharacteristics, "id-TSCTrafficCharacteristics" },
  { id_ReportingRequestType, "id-ReportingRequestType" },
  { id_TimeReferenceInformation, "id-TimeReferenceInformation" },
  { id_Unknown_367, "id-Unknown-367" },
  { id_Unknown_368, "id-Unknown-368" },
  { id_CNPacketDelayBudgetUplink, "id-CNPacketDelayBudgetUplink" },
  { id_AdditionalPDCPDuplicationTNL_List, "id-AdditionalPDCPDuplicationTNL-List" },
  { id_RLCDuplicationInformation, "id-RLCDuplicationInformation" },
  { id_AdditionalDuplicationIndication, "id-AdditionalDuplicationIndication" },
  { id_ConditionalInterDUMobilityInformation, "id-ConditionalInterDUMobilityInformation" },
  { id_ConditionalIntraDUMobilityInformation, "id-ConditionalIntraDUMobilityInformation" },
  { id_targetCellsToCancel, "id-targetCellsToCancel" },
  { id_requestedTargetCellGlobalID, "id-requestedTargetCellGlobalID" },
  { id_ManagementBasedMDTPLMNList, "id-ManagementBasedMDTPLMNList" },
  { id_TraceCollectionEntityIPAddress, "id-TraceCollectionEntityIPAddress" },
  { id_PrivacyIndicator, "id-PrivacyIndicator" },
  { id_TraceCollectionEntityURI, "id-TraceCollectionEntityURI" },
  { id_mdtConfiguration, "id-mdtConfiguration" },
  { id_ServingNID, "id-ServingNID" },
  { id_NPNBroadcastInformation, "id-NPNBroadcastInformation" },
  { id_NPNSupportInfo, "id-NPNSupportInfo" },
  { id_NID, "id-NID" },
  { id_AvailableSNPN_ID_List, "id-AvailableSNPN-ID-List" },
  { id_SIB10_message, "id-SIB10-message" },
  { id_Unknown_388, "id-Unknown-388" },
  { id_DLCarrierList, "id-DLCarrierList" },
  { id_ExtendedTAISliceSupportList, "id-ExtendedTAISliceSupportList" },
  { id_RequestedSRSTransmissionCharacteristics, "id-RequestedSRSTransmissionCharacteristics" },
  { id_PosAssistance_Information, "id-PosAssistance-Information" },
  { id_PosBroadcast, "id-PosBroadcast" },
  { id_RoutingID, "id-RoutingID" },
  { id_PosAssistanceInformationFailureList, "id-PosAssistanceInformationFailureList" },
  { id_PosMeasurementQuantities, "id-PosMeasurementQuantities" },
  { id_PosMeasurementResultList, "id-PosMeasurementResultList" },
  { id_TRPInformationTypeListTRPReq, "id-TRPInformationTypeListTRPReq" },
  { id_TRPInformationTypeItem, "id-TRPInformationTypeItem" },
  { id_TRPInformationListTRPResp, "id-TRPInformationListTRPResp" },
  { id_TRPInformationItem, "id-TRPInformationItem" },
  { id_LMF_MeasurementID, "id-LMF-MeasurementID" },
  { id_SRSType, "id-SRSType" },
  { id_ActivationTime, "id-ActivationTime" },
  { id_AbortTransmission, "id-AbortTransmission" },
  { id_PositioningBroadcastCells, "id-PositioningBroadcastCells" },
  { id_SRSConfiguration, "id-SRSConfiguration" },
  { id_PosReportCharacteristics, "id-PosReportCharacteristics" },
  { id_PosMeasurementPeriodicity, "id-PosMeasurementPeriodicity" },
  { id_TRPList, "id-TRPList" },
  { id_RAN_MeasurementID, "id-RAN-MeasurementID" },
  { id_LMF_UE_MeasurementID, "id-LMF-UE-MeasurementID" },
  { id_RAN_UE_MeasurementID, "id-RAN-UE-MeasurementID" },
  { id_E_CID_MeasurementQuantities, "id-E-CID-MeasurementQuantities" },
  { id_E_CID_MeasurementQuantities_Item, "id-E-CID-MeasurementQuantities-Item" },
  { id_E_CID_MeasurementPeriodicity, "id-E-CID-MeasurementPeriodicity" },
  { id_E_CID_MeasurementResult, "id-E-CID-MeasurementResult" },
  { id_Cell_Portion_ID, "id-Cell-Portion-ID" },
  { id_SFNInitialisationTime, "id-SFNInitialisationTime" },
  { id_SystemFrameNumber, "id-SystemFrameNumber" },
  { id_SlotNumber, "id-SlotNumber" },
  { id_TRP_MeasurementRequestList, "id-TRP-MeasurementRequestList" },
  { id_MeasurementBeamInfoRequest, "id-MeasurementBeamInfoRequest" },
  { id_E_CID_ReportCharacteristics, "id-E-CID-ReportCharacteristics" },
  { id_ConfiguredTACIndication, "id-ConfiguredTACIndication" },
  { id_Extended_GNB_DU_Name, "id-Extended-GNB-DU-Name" },
  { id_Extended_GNB_CU_Name, "id-Extended-GNB-CU-Name" },
  { id_F1CTransferPath, "id-F1CTransferPath" },
  { id_SFN_Offset, "id-SFN-Offset" },
  { id_TransmissionStopIndicator, "id-TransmissionStopIndicator" },
  { id_SrsFrequency, "id-SrsFrequency" },
  { id_SCGIndicator, "id-SCGIndicator" },
  { id_EstimatedArrivalProbability, "id-EstimatedArrivalProbability" },
  { 0, NULL }
};

static value_string_ext f1ap_ProtocolIE_ID_vals_ext = VALUE_STRING_EXT_INIT(f1ap_ProtocolIE_ID_vals);


static int
dissect_f1ap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 57 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, &f1ap_data->protocol_ie_id, FALSE);




#line 61 "./asn1/f1ap/f1ap.cnf"
  if (tree) {
    proto_item_append_text(proto_item_get_parent_nth(actx->created_item, 2), ": %s",
                           val_to_str_ext(f1ap_data->protocol_ie_id, &f1ap_ProtocolIE_ID_vals_ext, "unknown (%d)"));
  }


  return offset;
}


static const value_string f1ap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  { 0, NULL }
};


static int
dissect_f1ap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_T_ie_field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_f1ap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_ID },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_ie_field_value , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_ie_field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_f1ap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Field },
};

static int
dissect_f1ap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs, FALSE);

  return offset;
}



static int
dissect_f1ap_ProtocolIE_SingleContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_f1ap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_f1ap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_f1ap_ext_id         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolExtensionID },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_extensionValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_f1ap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolExtensionField },
};

static int
dissect_f1ap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions, FALSE);

  return offset;
}



static int
dissect_f1ap_T_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 102 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  if (f1ap_data->obj_id) {
    offset = call_per_oid_callback(f1ap_data->obj_id, tvb, actx->pinfo, tree, offset, actx, hf_index);
  } else {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  }



  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_f1ap_private_id     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PrivateIE_ID },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_value          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_f1ap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PrivateIE_Field },
};

static int
dissect_f1ap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs, FALSE);

  return offset;
}



static int
dissect_f1ap_SRSResourceSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string f1ap_AbortTransmission_vals[] = {
  {   0, "sRSResourceSetID" },
  {   1, "releaseALL" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AbortTransmission_choice[] = {
  {   0, &hf_f1ap_sRSResourceSetID, ASN1_NO_EXTENSIONS     , dissect_f1ap_SRSResourceSetID },
  {   1, &hf_f1ap_releaseALL     , ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_AbortTransmission(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_AbortTransmission, AbortTransmission_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_T_latitudeSign_vals[] = {
  {   0, "north" },
  {   1, "south" },
  { 0, NULL }
};


static int
dissect_f1ap_T_latitudeSign(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8388607U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_M8388608_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8388608, 8388607U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_T_directionOfAltitude_vals[] = {
  {   0, "height" },
  {   1, "depth" },
  { 0, NULL }
};


static int
dissect_f1ap_T_directionOfAltitude(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_179(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 179U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t AccessPointPosition_sequence[] = {
  { &hf_f1ap_latitudeSign   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_latitudeSign },
  { &hf_f1ap_latitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_8388607 },
  { &hf_f1ap_longitude      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M8388608_8388607 },
  { &hf_f1ap_directionOfAltitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_directionOfAltitude },
  { &hf_f1ap_altitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_32767 },
  { &hf_f1ap_uncertaintySemi_major, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_uncertaintySemi_minor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_orientationOfMajorAxis, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_179 },
  { &hf_f1ap_uncertaintyAltitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_confidence     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AccessPointPosition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AccessPointPosition, AccessPointPosition_sequence);

  return offset;
}



static int
dissect_f1ap_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1349 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  e212_number_type_t number_type = f1ap_data->number_type;
  f1ap_data->number_type = E212_NONE;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_PLMN_Identity);
    dissect_e212_mcc_mnc(param_tvb, actx->pinfo, subtree, 0, number_type, FALSE);
  }



  return offset;
}



static int
dissect_f1ap_NRCellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t NRCGI_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_nRCellIdentity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCellIdentity },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1360 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->number_type = E212_NRCGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRCGI, NRCGI_sequence);




  return offset;
}


static const value_string f1ap_SubcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_f1ap_SubcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_DUFTransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  { 0, NULL }
};


static int
dissect_f1ap_DUFTransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_Permutation_vals[] = {
  {   0, "dfu" },
  {   1, "ufd" },
  { 0, NULL }
};


static int
dissect_f1ap_Permutation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_NoofDownlinkSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_NoofUplinkSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ExplicitFormat_sequence[] = {
  { &hf_f1ap_permutation    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Permutation },
  { &hf_f1ap_noofDownlinkSymbols, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NoofDownlinkSymbols },
  { &hf_f1ap_noofUplinkSymbols, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NoofUplinkSymbols },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ExplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ExplicitFormat, ExplicitFormat_sequence);

  return offset;
}



static int
dissect_f1ap_DUFSlotformatIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 254U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ImplicitFormat_sequence[] = {
  { &hf_f1ap_dUFSlotformatIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DUFSlotformatIndex },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ImplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ImplicitFormat, ImplicitFormat_sequence);

  return offset;
}


static const value_string f1ap_DUF_Slot_Config_Item_vals[] = {
  {   0, "explicitFormat" },
  {   1, "implicitFormat" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DUF_Slot_Config_Item_choice[] = {
  {   0, &hf_f1ap_explicitFormat , ASN1_NO_EXTENSIONS     , dissect_f1ap_ExplicitFormat },
  {   1, &hf_f1ap_implicitFormat , ASN1_NO_EXTENSIONS     , dissect_f1ap_ImplicitFormat },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DUF_Slot_Config_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DUF_Slot_Config_Item, DUF_Slot_Config_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DUF_Slot_Config_List_sequence_of[1] = {
  { &hf_f1ap_DUF_Slot_Config_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DUF_Slot_Config_Item },
};

static int
dissect_f1ap_DUF_Slot_Config_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DUF_Slot_Config_List, DUF_Slot_Config_List_sequence_of,
                                                  1, maxnoofDUFSlots, FALSE);

  return offset;
}


static const value_string f1ap_HSNATransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  {   8, "ms20" },
  {   9, "ms40" },
  {  10, "ms80" },
  {  11, "ms160" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNATransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_HSNADownlink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNADownlink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_HSNAUplink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNAUplink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_HSNAFlexible_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNAFlexible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t HSNASlotConfigItem_sequence[] = {
  { &hf_f1ap_hSNADownlink   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNADownlink },
  { &hf_f1ap_hSNAUplink     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNAUplink },
  { &hf_f1ap_hSNAFlexible   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNAFlexible },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_HSNASlotConfigItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_HSNASlotConfigItem, HSNASlotConfigItem_sequence);

  return offset;
}


static const per_sequence_t HSNASlotConfigList_sequence_of[1] = {
  { &hf_f1ap_HSNASlotConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_HSNASlotConfigItem },
};

static int
dissect_f1ap_HSNASlotConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_HSNASlotConfigList, HSNASlotConfigList_sequence_of,
                                                  1, maxnoofHSNASlots, FALSE);

  return offset;
}


static const per_sequence_t GNB_DU_Cell_Resource_Configuration_sequence[] = {
  { &hf_f1ap_subcarrierSpacing_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SubcarrierSpacing },
  { &hf_f1ap_dUFTransmissionPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_DUFTransmissionPeriodicity },
  { &hf_f1ap_dUF_Slot_Config_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_DUF_Slot_Config_List },
  { &hf_f1ap_hSNATransmissionPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_HSNATransmissionPeriodicity },
  { &hf_f1ap_hNSASlotConfigList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNASlotConfigList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_Cell_Resource_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_Cell_Resource_Configuration, GNB_DU_Cell_Resource_Configuration_sequence);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence[] = {
  { &hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_UL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_DL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info, IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence[] = {
  { &hf_f1ap_gNB_DU_Cell_Resourc_Configuration_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info, IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IAB_DU_Cell_Resource_Configuration_Mode_Info_choice[] = {
  {   0, &hf_f1ap_fDD_01         , ASN1_NO_EXTENSIONS     , dissect_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info },
  {   1, &hf_f1ap_tDD_01         , ASN1_NO_EXTENSIONS     , dissect_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info, IAB_DU_Cell_Resource_Configuration_Mode_Info_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Activated_Cells_to_be_Updated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iAB_DU_Cell_Resource_Configuration_Mode_Info, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Activated_Cells_to_be_Updated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Activated_Cells_to_be_Updated_List_Item, Activated_Cells_to_be_Updated_List_Item_sequence);

  return offset;
}


static const per_sequence_t Activated_Cells_to_be_Updated_List_sequence_of[1] = {
  { &hf_f1ap_Activated_Cells_to_be_Updated_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Activated_Cells_to_be_Updated_List_Item },
};

static int
dissect_f1ap_Activated_Cells_to_be_Updated_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Activated_Cells_to_be_Updated_List, Activated_Cells_to_be_Updated_List_sequence_of,
                                                  1, maxnoofServedCellsIAB, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_37949_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37949U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_T_subcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  { 0, NULL }
};


static int
dissect_f1ap_T_subcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_cyclicPrefix_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_T_cyclicPrefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3301_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3301U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_T_shift7dot5kHz_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_shift7dot5kHz(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_SRSResourceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_T_nrofSRS_Ports_vals[] = {
  {   0, "port1" },
  {   1, "ports2" },
  {   2, "ports4" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nrofSRS_Ports(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_n2_sequence[] = {
  { &hf_f1ap_combOffset_n2  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1 },
  { &hf_f1ap_cyclicShift_n2 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n2, T_n2_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 11U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_n4_sequence[] = {
  { &hf_f1ap_combOffset_n4  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_cyclicShift_n4 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n4, T_n4_sequence);

  return offset;
}


static const value_string f1ap_TransmissionComb_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TransmissionComb_choice[] = {
  {   0, &hf_f1ap_n2             , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n2 },
  {   1, &hf_f1ap_n4             , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n4 },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TransmissionComb(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TransmissionComb, TransmissionComb_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_T_nrofSymbols_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nrofSymbols_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_repetitionFactor_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  { 0, NULL }
};


static int
dissect_f1ap_T_repetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_67(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 67U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_268(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 268U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_T_groupOrSequenceHopping_01_vals[] = {
  {   0, "neither" },
  {   1, "groupHopping" },
  {   2, "sequenceHopping" },
  { 0, NULL }
};


static int
dissect_f1ap_T_groupOrSequenceHopping_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_periodicity_vals[] = {
  {   0, "slot1" },
  {   1, "slot2" },
  {   2, "slot4" },
  {   3, "slot5" },
  {   4, "slot8" },
  {   5, "slot10" },
  {   6, "slot16" },
  {   7, "slot20" },
  {   8, "slot32" },
  {   9, "slot40" },
  {  10, "slot64" },
  {  11, "slot80" },
  {  12, "slot160" },
  {  13, "slot320" },
  {  14, "slot640" },
  {  15, "slot1280" },
  {  16, "slot2560" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     17, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_2559_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2559U, NULL, TRUE);

  return offset;
}


static const per_sequence_t ResourceTypePeriodic_sequence[] = {
  { &hf_f1ap_periodicity    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicity },
  { &hf_f1ap_offset         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2559_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypePeriodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypePeriodic, ResourceTypePeriodic_sequence);

  return offset;
}


static const value_string f1ap_T_periodicity_01_vals[] = {
  {   0, "slot1" },
  {   1, "slot2" },
  {   2, "slot4" },
  {   3, "slot5" },
  {   4, "slot8" },
  {   5, "slot10" },
  {   6, "slot16" },
  {   7, "slot20" },
  {   8, "slot32" },
  {   9, "slot40" },
  {  10, "slot64" },
  {  11, "slot80" },
  {  12, "slot160" },
  {  13, "slot320" },
  {  14, "slot640" },
  {  15, "slot1280" },
  {  16, "slot2560" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicity_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     17, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceTypeSemi_persistent_sequence[] = {
  { &hf_f1ap_periodicity_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicity_01 },
  { &hf_f1ap_offset         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2559_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeSemi_persistent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeSemi_persistent, ResourceTypeSemi_persistent_sequence);

  return offset;
}


static const value_string f1ap_T_aperiodicResourceType_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_aperiodicResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceTypeAperiodic_sequence[] = {
  { &hf_f1ap_aperiodicResourceType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_aperiodicResourceType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeAperiodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeAperiodic, ResourceTypeAperiodic_sequence);

  return offset;
}


static const value_string f1ap_ResourceType_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResourceType_choice[] = {
  {   0, &hf_f1ap_periodic_02    , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypePeriodic },
  {   1, &hf_f1ap_semi_persistent_02, ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeSemi_persistent },
  {   2, &hf_f1ap_aperiodic_02   , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeAperiodic },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ResourceType, ResourceType_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SRSResource_sequence[] = {
  { &hf_f1ap_sRSResourceID  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceID },
  { &hf_f1ap_nrofSRS_Ports  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nrofSRS_Ports },
  { &hf_f1ap_transmissionComb, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransmissionComb },
  { &hf_f1ap_startPosition  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13 },
  { &hf_f1ap_nrofSymbols_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nrofSymbols_01 },
  { &hf_f1ap_repetitionFactor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_repetitionFactor },
  { &hf_f1ap_freqDomainPosition, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_67 },
  { &hf_f1ap_freqDomainShift, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_268 },
  { &hf_f1ap_c_SRS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_b_SRS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_b_hop          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_groupOrSequenceHopping_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_groupOrSequenceHopping_01 },
  { &hf_f1ap_resourceType_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ResourceType },
  { &hf_f1ap_sequenceId_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1023 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSResource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSResource, SRSResource_sequence);

  return offset;
}


static const per_sequence_t SRSResource_List_sequence_of[1] = {
  { &hf_f1ap_SRSResource_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResource },
};

static int
dissect_f1ap_SRSResource_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSResource_List, SRSResource_List_sequence_of,
                                                  1, maxnoSRS_Resources, FALSE);

  return offset;
}



static int
dissect_f1ap_SRSPosResourceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_n2_01_sequence[] = {
  { &hf_f1ap_combOffset_n2  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1 },
  { &hf_f1ap_cyclicShift_n2 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n2_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n2_01, T_n2_01_sequence);

  return offset;
}


static const per_sequence_t T_n4_01_sequence[] = {
  { &hf_f1ap_combOffset_n4  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_cyclicShift_n4 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n4_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n4_01, T_n4_01_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_n8_sequence[] = {
  { &hf_f1ap_combOffset_n8  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { &hf_f1ap_cyclicShift_n8 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_5 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n8, T_n8_sequence);

  return offset;
}


static const value_string f1ap_TransmissionCombPos_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TransmissionCombPos_choice[] = {
  {   0, &hf_f1ap_n2_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n2_01 },
  {   1, &hf_f1ap_n4_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n4_01 },
  {   2, &hf_f1ap_n8             , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n8 },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TransmissionCombPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TransmissionCombPos, TransmissionCombPos_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_T_nrofSymbols_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nrofSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_groupOrSequenceHopping_vals[] = {
  {   0, "neither" },
  {   1, "groupHopping" },
  {   2, "sequenceHopping" },
  { 0, NULL }
};


static int
dissect_f1ap_T_groupOrSequenceHopping(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_periodicity_02_vals[] = {
  {   0, "slot1" },
  {   1, "slot2" },
  {   2, "slot4" },
  {   3, "slot5" },
  {   4, "slot8" },
  {   5, "slot10" },
  {   6, "slot16" },
  {   7, "slot20" },
  {   8, "slot32" },
  {   9, "slot40" },
  {  10, "slot64" },
  {  11, "slot80" },
  {  12, "slot160" },
  {  13, "slot320" },
  {  14, "slot640" },
  {  15, "slot1280" },
  {  16, "slot2560" },
  {  17, "slot5120" },
  {  18, "slot10240" },
  {  19, "slot40960" },
  {  20, "slot81920" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicity_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     21, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_81919_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 81919U, NULL, TRUE);

  return offset;
}


static const per_sequence_t ResourceTypePeriodicPos_sequence[] = {
  { &hf_f1ap_periodicity_02 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicity_02 },
  { &hf_f1ap_offset_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_81919_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypePeriodicPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypePeriodicPos, ResourceTypePeriodicPos_sequence);

  return offset;
}


static const value_string f1ap_T_periodicity_03_vals[] = {
  {   0, "slot1" },
  {   1, "slot2" },
  {   2, "slot4" },
  {   3, "slot5" },
  {   4, "slot8" },
  {   5, "slot10" },
  {   6, "slot16" },
  {   7, "slot20" },
  {   8, "slot32" },
  {   9, "slot40" },
  {  10, "slot64" },
  {  11, "slot80" },
  {  12, "slot160" },
  {  13, "slot320" },
  {  14, "slot640" },
  {  15, "slot1280" },
  {  16, "slot2560" },
  {  17, "slot5120" },
  {  18, "slot10240" },
  {  19, "slot40960" },
  {  20, "slot81920" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicity_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     21, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceTypeSemi_persistentPos_sequence[] = {
  { &hf_f1ap_periodicity_03 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicity_03 },
  { &hf_f1ap_offset_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_81919_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeSemi_persistentPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeSemi_persistentPos, ResourceTypeSemi_persistentPos_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ResourceTypeAperiodicPos_sequence[] = {
  { &hf_f1ap_slotOffset     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_32 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeAperiodicPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeAperiodicPos, ResourceTypeAperiodicPos_sequence);

  return offset;
}


static const value_string f1ap_ResourceTypePos_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResourceTypePos_choice[] = {
  {   0, &hf_f1ap_periodic_03    , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypePeriodicPos },
  {   1, &hf_f1ap_semi_persistent_03, ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeSemi_persistentPos },
  {   2, &hf_f1ap_aperiodic_03   , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeAperiodicPos },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ResourceTypePos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ResourceTypePos, ResourceTypePos_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_NRPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_SSB_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SSB_sequence[] = {
  { &hf_f1ap_pCI_NR_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPCI },
  { &hf_f1ap_ssb_index      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSB_Index },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSB, SSB_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PRSInformationPos_sequence[] = {
  { &hf_f1ap_pRS_IDPos      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_pRS_Resource_Set_IDPos, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { &hf_f1ap_pRS_Resource_IDPos, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSInformationPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSInformationPos, PRSInformationPos_sequence);

  return offset;
}


static const value_string f1ap_SpatialRelationPos_vals[] = {
  {   0, "sSBPos" },
  {   1, "pRSInformationPos" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SpatialRelationPos_choice[] = {
  {   0, &hf_f1ap_sSBPos         , ASN1_NO_EXTENSIONS     , dissect_f1ap_SSB },
  {   1, &hf_f1ap_pRSInformationPos, ASN1_NO_EXTENSIONS     , dissect_f1ap_PRSInformationPos },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SpatialRelationPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SpatialRelationPos, SpatialRelationPos_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PosSRSResource_Item_sequence[] = {
  { &hf_f1ap_srs_PosResourceId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSPosResourceID },
  { &hf_f1ap_transmissionCombPos, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransmissionCombPos },
  { &hf_f1ap_startPosition  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13 },
  { &hf_f1ap_nrofSymbols    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nrofSymbols },
  { &hf_f1ap_freqDomainShift, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_268 },
  { &hf_f1ap_c_SRS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_groupOrSequenceHopping, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_groupOrSequenceHopping },
  { &hf_f1ap_resourceTypePos, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ResourceTypePos },
  { &hf_f1ap_sequenceId     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_65535 },
  { &hf_f1ap_spatialRelationPos, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SpatialRelationPos },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosSRSResource_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosSRSResource_Item, PosSRSResource_Item_sequence);

  return offset;
}


static const per_sequence_t PosSRSResource_List_sequence_of[1] = {
  { &hf_f1ap_PosSRSResource_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosSRSResource_Item },
};

static int
dissect_f1ap_PosSRSResource_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosSRSResource_List, PosSRSResource_List_sequence_of,
                                                  1, maxnoSRS_PosResources, FALSE);

  return offset;
}


static const per_sequence_t SRSResourceID_List_sequence_of[1] = {
  { &hf_f1ap_SRSResourceID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceID },
};

static int
dissect_f1ap_SRSResourceID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSResourceID_List, SRSResourceID_List_sequence_of,
                                                  1, maxnoSRS_ResourcePerSet, FALSE);

  return offset;
}


static const value_string f1ap_T_periodicSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceSetTypePeriodic_sequence[] = {
  { &hf_f1ap_periodicSet    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceSetTypePeriodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceSetTypePeriodic, ResourceSetTypePeriodic_sequence);

  return offset;
}


static const value_string f1ap_T_semi_persistentSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_semi_persistentSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceSetTypeSemi_persistent_sequence[] = {
  { &hf_f1ap_semi_persistentSet, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_semi_persistentSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceSetTypeSemi_persistent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceSetTypeSemi_persistent, ResourceSetTypeSemi_persistent_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ResourceSetTypeAperiodic_sequence[] = {
  { &hf_f1ap_sRSResourceTrigger_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_3 },
  { &hf_f1ap_slotoffset     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_32 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceSetTypeAperiodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceSetTypeAperiodic, ResourceSetTypeAperiodic_sequence);

  return offset;
}


static const value_string f1ap_ResourceSetType_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResourceSetType_choice[] = {
  {   0, &hf_f1ap_periodic_01    , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceSetTypePeriodic },
  {   1, &hf_f1ap_semi_persistent_01, ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceSetTypeSemi_persistent },
  {   2, &hf_f1ap_aperiodic_01   , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceSetTypeAperiodic },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ResourceSetType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ResourceSetType, ResourceSetType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SRSResourceSet_sequence[] = {
  { &hf_f1ap_sRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceSetID },
  { &hf_f1ap_sRSResourceID_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceID_List },
  { &hf_f1ap_resourceSetType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ResourceSetType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSResourceSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSResourceSet, SRSResourceSet_sequence);

  return offset;
}


static const per_sequence_t SRSResourceSet_List_sequence_of[1] = {
  { &hf_f1ap_SRSResourceSet_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceSet },
};

static int
dissect_f1ap_SRSResourceSet_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSResourceSet_List, SRSResourceSet_List_sequence_of,
                                                  1, maxnoSRS_ResourceSets, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PosSRSResourceID_List_sequence_of[1] = {
  { &hf_f1ap_PosSRSResourceID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSPosResourceID },
};

static int
dissect_f1ap_PosSRSResourceID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosSRSResourceID_List, PosSRSResourceID_List_sequence_of,
                                                  1, maxnoSRS_PosResourcePerSet, FALSE);

  return offset;
}


static const value_string f1ap_T_posperiodicSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_posperiodicSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PosResourceSetTypePR_sequence[] = {
  { &hf_f1ap_posperiodicSet , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_posperiodicSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetTypePR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosResourceSetTypePR, PosResourceSetTypePR_sequence);

  return offset;
}


static const value_string f1ap_T_possemi_persistentSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_possemi_persistentSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PosResourceSetTypeSP_sequence[] = {
  { &hf_f1ap_possemi_persistentSet, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_possemi_persistentSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetTypeSP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosResourceSetTypeSP, PosResourceSetTypeSP_sequence);

  return offset;
}


static const per_sequence_t PosResourceSetTypeAP_sequence[] = {
  { &hf_f1ap_sRSResourceTrigger_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_3 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetTypeAP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosResourceSetTypeAP, PosResourceSetTypeAP_sequence);

  return offset;
}


static const value_string f1ap_PosResourceSetType_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PosResourceSetType_choice[] = {
  {   0, &hf_f1ap_periodic       , ASN1_NO_EXTENSIONS     , dissect_f1ap_PosResourceSetTypePR },
  {   1, &hf_f1ap_semi_persistent, ASN1_NO_EXTENSIONS     , dissect_f1ap_PosResourceSetTypeSP },
  {   2, &hf_f1ap_aperiodic      , ASN1_NO_EXTENSIONS     , dissect_f1ap_PosResourceSetTypeAP },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PosResourceSetType, PosResourceSetType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PosSRSResourceSet_Item_sequence[] = {
  { &hf_f1ap_possrsResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_possRSResourceID_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosSRSResourceID_List },
  { &hf_f1ap_posresourceSetType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosResourceSetType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosSRSResourceSet_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosSRSResourceSet_Item, PosSRSResourceSet_Item_sequence);

  return offset;
}


static const per_sequence_t PosSRSResourceSet_List_sequence_of[1] = {
  { &hf_f1ap_PosSRSResourceSet_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosSRSResourceSet_Item },
};

static int
dissect_f1ap_PosSRSResourceSet_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosSRSResourceSet_List, PosSRSResourceSet_List_sequence_of,
                                                  1, maxnoSRS_PosResourceSets, FALSE);

  return offset;
}


static const per_sequence_t SRSConfig_sequence[] = {
  { &hf_f1ap_sRSResource_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SRSResource_List },
  { &hf_f1ap_posSRSResource_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PosSRSResource_List },
  { &hf_f1ap_sRSResourceSet_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SRSResourceSet_List },
  { &hf_f1ap_posSRSResourceSet_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PosSRSResourceSet_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSConfig, SRSConfig_sequence);

  return offset;
}


static const per_sequence_t ActiveULBWP_sequence[] = {
  { &hf_f1ap_locationAndBandwidth, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_37949_ },
  { &hf_f1ap_subcarrierSpacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_subcarrierSpacing },
  { &hf_f1ap_cyclicPrefix   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_cyclicPrefix },
  { &hf_f1ap_txDirectCurrentLocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3301_ },
  { &hf_f1ap_shift7dot5kHz  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_shift7dot5kHz },
  { &hf_f1ap_sRSConfig      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ActiveULBWP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ActiveULBWP, ActiveULBWP_sequence);

  return offset;
}


static const value_string f1ap_AdditionalDuplicationIndication_vals[] = {
  {   0, "three" },
  {   1, "four" },
  { 0, NULL }
};


static int
dissect_f1ap_AdditionalDuplicationIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_16351(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16351U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_8176(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8176U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_4088(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4088U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_2044(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2044U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1022(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1022U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_RelativePathDelay_vals[] = {
  {   0, "k0" },
  {   1, "k1" },
  {   2, "k2" },
  {   3, "k3" },
  {   4, "k4" },
  {   5, "k5" },
  {   6, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RelativePathDelay_choice[] = {
  {   0, &hf_f1ap_k0_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_16351 },
  {   1, &hf_f1ap_k1_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_8176 },
  {   2, &hf_f1ap_k2_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_4088 },
  {   3, &hf_f1ap_k3_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_2044 },
  {   4, &hf_f1ap_k4_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_1022 },
  {   5, &hf_f1ap_k5_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_511 },
  {   6, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_RelativePathDelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_RelativePathDelay, RelativePathDelay_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_T_resolution_01_vals[] = {
  {   0, "m0dot1" },
  {   1, "m1" },
  {   2, "m10" },
  {   3, "m30" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resolution_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TimingMeasurementQuality_sequence[] = {
  { &hf_f1ap_measurementQuality_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_31 },
  { &hf_f1ap_resolution_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resolution_01 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TimingMeasurementQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TimingMeasurementQuality, TimingMeasurementQuality_sequence);

  return offset;
}


static const value_string f1ap_T_resolution_vals[] = {
  {   0, "deg0dot1" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resolution(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t AngleMeasurementQuality_sequence[] = {
  { &hf_f1ap_azimuthQuality , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_zenithQuality  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_resolution     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resolution },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AngleMeasurementQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AngleMeasurementQuality, AngleMeasurementQuality_sequence);

  return offset;
}


static const value_string f1ap_TRPMeasurementQuality_Item_vals[] = {
  {   0, "timingMeasurementQuality" },
  {   1, "angleMeasurementQuality" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPMeasurementQuality_Item_choice[] = {
  {   0, &hf_f1ap_timingMeasurementQuality, ASN1_NO_EXTENSIONS     , dissect_f1ap_TimingMeasurementQuality },
  {   1, &hf_f1ap_angleMeasurementQuality, ASN1_NO_EXTENSIONS     , dissect_f1ap_AngleMeasurementQuality },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPMeasurementQuality_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPMeasurementQuality_Item, TRPMeasurementQuality_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TRPMeasurementQuality_sequence[] = {
  { &hf_f1ap_tRPmeasurementQuality_Item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPMeasurementQuality_Item },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPMeasurementQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPMeasurementQuality, TRPMeasurementQuality_sequence);

  return offset;
}


static const per_sequence_t AdditionalPath_Item_sequence[] = {
  { &hf_f1ap_relativePathDelay, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RelativePathDelay },
  { &hf_f1ap_pathQuality    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TRPMeasurementQuality },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AdditionalPath_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AdditionalPath_Item, AdditionalPath_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalPath_List_sequence_of[1] = {
  { &hf_f1ap_AdditionalPath_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AdditionalPath_Item },
};

static int
dissect_f1ap_AdditionalPath_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AdditionalPath_List, AdditionalPath_List_sequence_of,
                                                  1, maxnoofPath, FALSE);

  return offset;
}



static int
dissect_f1ap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1608 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, TRUE, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree;
    gint tvb_len;

    tvb_len = tvb_reported_length(param_tvb);
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_TransportLayerAddress);
    if (tvb_len == 4) {
      /* IPv4 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv4, param_tvb, 0, 4, ENC_BIG_ENDIAN);
    } else if (tvb_len == 16) {
      /* IPv6 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv6, param_tvb, 0, 16, ENC_NA);
    } else if (tvb_len == 20) {
      /* IPv4 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv4, param_tvb, 0, 4, ENC_BIG_ENDIAN);
      /* IPv6 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv6, param_tvb, 4, 16, ENC_NA);
    }
  }



  return offset;
}



static int
dissect_f1ap_GTP_TEID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, NULL);

  return offset;
}


static const per_sequence_t GTPTunnel_sequence[] = {
  { &hf_f1ap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_gTP_TEID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GTP_TEID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GTPTunnel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GTPTunnel, GTPTunnel_sequence);

  return offset;
}


static const value_string f1ap_UPTransportLayerInformation_vals[] = {
  {   0, "gTPTunnel" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UPTransportLayerInformation_choice[] = {
  {   0, &hf_f1ap_gTPTunnel      , ASN1_NO_EXTENSIONS     , dissect_f1ap_GTPTunnel },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_UPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_UPTransportLayerInformation, UPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AdditionalPDCPDuplicationTNL_Item_sequence[] = {
  { &hf_f1ap_additionalPDCPDuplicationUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AdditionalPDCPDuplicationTNL_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AdditionalPDCPDuplicationTNL_Item, AdditionalPDCPDuplicationTNL_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalPDCPDuplicationTNL_List_sequence_of[1] = {
  { &hf_f1ap_AdditionalPDCPDuplicationTNL_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AdditionalPDCPDuplicationTNL_Item },
};

static int
dissect_f1ap_AdditionalPDCPDuplicationTNL_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AdditionalPDCPDuplicationTNL_List, AdditionalPDCPDuplicationTNL_List_sequence_of,
                                                  1, maxnoofAdditionalPDCPDuplicationTNL, FALSE);

  return offset;
}



static int
dissect_f1ap_T_additionalSIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1177 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sIBmessage);
    switch (f1ap_data->sib_type) {
    case 6:
      dissect_nr_rrc_SIB6_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 7:
      dissect_nr_rrc_SIB7_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 8:
      dissect_nr_rrc_SIB8_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }



  return offset;
}


static const per_sequence_t AdditionalSIBMessageList_Item_sequence[] = {
  { &hf_f1ap_additionalSIB  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_additionalSIB },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AdditionalSIBMessageList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AdditionalSIBMessageList_Item, AdditionalSIBMessageList_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalSIBMessageList_sequence_of[1] = {
  { &hf_f1ap_AdditionalSIBMessageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AdditionalSIBMessageList_Item },
};

static int
dissect_f1ap_AdditionalSIBMessageList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AdditionalSIBMessageList, AdditionalSIBMessageList_sequence_of,
                                                  1, maxnoofAdditionalSIBs, FALSE);

  return offset;
}



static int
dissect_f1ap_AdditionalRRMPriorityIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t AggressorCellList_Item_sequence[] = {
  { &hf_f1ap_aggressorCell_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AggressorCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AggressorCellList_Item, AggressorCellList_Item_sequence);

  return offset;
}


static const per_sequence_t AggressorCellList_sequence_of[1] = {
  { &hf_f1ap_AggressorCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AggressorCellList_Item },
};

static int
dissect_f1ap_AggressorCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AggressorCellList, AggressorCellList_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}



static int
dissect_f1ap_GNBSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 22, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t AggressorgNBSetID_sequence[] = {
  { &hf_f1ap_aggressorgNBSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBSetID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AggressorgNBSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AggressorgNBSetID, AggressorgNBSetID_sequence);

  return offset;
}


static const value_string f1ap_PriorityLevel_vals[] = {
  {   0, "spare" },
  {   1, "highest" },
  {  14, "lowest" },
  {  15, "no-priority" },
  { 0, NULL }
};


static int
dissect_f1ap_PriorityLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_Pre_emptionCapability_vals[] = {
  {   0, "shall-not-trigger-pre-emption" },
  {   1, "may-trigger-pre-emption" },
  { 0, NULL }
};


static int
dissect_f1ap_Pre_emptionCapability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_Pre_emptionVulnerability_vals[] = {
  {   0, "not-pre-emptable" },
  {   1, "pre-emptable" },
  { 0, NULL }
};


static int
dissect_f1ap_Pre_emptionVulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationAndRetentionPriority_sequence[] = {
  { &hf_f1ap_priorityLevel  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PriorityLevel },
  { &hf_f1ap_pre_emptionCapability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionCapability },
  { &hf_f1ap_pre_emptionVulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionVulnerability },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AllocationAndRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AllocationAndRetentionPriority, AllocationAndRetentionPriority_sequence);

  return offset;
}



static int
dissect_f1ap_QoSParaSetIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_BitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(4000000000000), NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_PacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_PER_Scalar(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_PER_Exponent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, TRUE);

  return offset;
}


static const per_sequence_t PacketErrorRate_sequence[] = {
  { &hf_f1ap_pER_Scalar     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PER_Scalar },
  { &hf_f1ap_pER_Exponent   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PER_Exponent },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PacketErrorRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PacketErrorRate, PacketErrorRate_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetItem_sequence[] = {
  { &hf_f1ap_alternativeQoSParaSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSParaSetIndex },
  { &hf_f1ap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BitRate },
  { &hf_f1ap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BitRate },
  { &hf_f1ap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_PacketDelayBudget },
  { &hf_f1ap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_PacketErrorRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AlternativeQoSParaSetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AlternativeQoSParaSetItem, AlternativeQoSParaSetItem_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetList_sequence_of[1] = {
  { &hf_f1ap_AlternativeQoSParaSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AlternativeQoSParaSetItem },
};

static int
dissect_f1ap_AlternativeQoSParaSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AlternativeQoSParaSetList, AlternativeQoSParaSetList_sequence_of,
                                                  1, maxnoofQoSParaSets, FALSE);

  return offset;
}



static int
dissect_f1ap_AperiodicSRSResourceTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t AperiodicSRSResourceTriggerList_sequence_of[1] = {
  { &hf_f1ap_AperiodicSRSResourceTriggerList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AperiodicSRSResourceTrigger },
};

static int
dissect_f1ap_AperiodicSRSResourceTriggerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AperiodicSRSResourceTriggerList, AperiodicSRSResourceTriggerList_sequence_of,
                                                  1, maxnoofSRSTriggerStates, FALSE);

  return offset;
}


static const per_sequence_t Associated_SCell_Item_sequence[] = {
  { &hf_f1ap_sCell_ID       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Associated_SCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Associated_SCell_Item, Associated_SCell_Item_sequence);

  return offset;
}


static const per_sequence_t AvailablePLMNList_Item_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AvailablePLMNList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AvailablePLMNList_Item, AvailablePLMNList_Item_sequence);

  return offset;
}


static const per_sequence_t AvailablePLMNList_sequence_of[1] = {
  { &hf_f1ap_AvailablePLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AvailablePLMNList_Item },
};

static int
dissect_f1ap_AvailablePLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AvailablePLMNList, AvailablePLMNList_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}



static int
dissect_f1ap_NID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     44, 44, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BroadcastNIDList_sequence_of[1] = {
  { &hf_f1ap_BroadcastNIDList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NID },
};

static int
dissect_f1ap_BroadcastNIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastNIDList, BroadcastNIDList_sequence_of,
                                                  1, maxnoofNIDsupported, FALSE);

  return offset;
}


static const per_sequence_t AvailableSNPN_ID_List_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_availableNIDList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastNIDList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AvailableSNPN_ID_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AvailableSNPN_ID_List_Item, AvailableSNPN_ID_List_Item_sequence);

  return offset;
}


static const per_sequence_t AvailableSNPN_ID_List_sequence_of[1] = {
  { &hf_f1ap_AvailableSNPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AvailableSNPN_ID_List_Item },
};

static int
dissect_f1ap_AvailableSNPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AvailableSNPN_ID_List, AvailableSNPN_ID_List_sequence_of,
                                                  1, maxnoofNIDsupported, FALSE);

  return offset;
}



static int
dissect_f1ap_AveragingWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_AreaScope_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_AreaScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_FR1_Bandwidth_vals[] = {
  {   0, "bw5" },
  {   1, "bw10" },
  {   2, "bw20" },
  {   3, "bw40" },
  {   4, "bw50" },
  {   5, "bw80" },
  {   6, "bw100" },
  { 0, NULL }
};


static int
dissect_f1ap_FR1_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_FR2_Bandwidth_vals[] = {
  {   0, "bw50" },
  {   1, "bw100" },
  {   2, "bw200" },
  {   3, "bw400" },
  { 0, NULL }
};


static int
dissect_f1ap_FR2_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_BandwidthSRS_vals[] = {
  {   0, "fR1" },
  {   1, "fR2" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t BandwidthSRS_choice[] = {
  {   0, &hf_f1ap_fR1            , ASN1_NO_EXTENSIONS     , dissect_f1ap_FR1_Bandwidth },
  {   1, &hf_f1ap_fR2            , ASN1_NO_EXTENSIONS     , dissect_f1ap_FR2_Bandwidth },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_BandwidthSRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_BandwidthSRS, BandwidthSRS_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_BAPAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_BAPCtrlPDUChannel_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_BAPCtrlPDUChannel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_MappingInformationIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     26, 26, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BHRLCChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPlayerBHRLCchannelMappingInfo_Item_sequence[] = {
  { &hf_f1ap_mappingInformationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MappingInformationIndex },
  { &hf_f1ap_priorHopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BAPAddress },
  { &hf_f1ap_ingressbHRLCChannelID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_nextHopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BAPAddress },
  { &hf_f1ap_egressbHRLCChannelID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPlayerBHRLCchannelMappingInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPlayerBHRLCchannelMappingInfo_Item, BAPlayerBHRLCchannelMappingInfo_Item_sequence);

  return offset;
}


static const per_sequence_t BAPlayerBHRLCchannelMappingInfoList_sequence_of[1] = {
  { &hf_f1ap_BAPlayerBHRLCchannelMappingInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPlayerBHRLCchannelMappingInfo_Item },
};

static int
dissect_f1ap_BAPlayerBHRLCchannelMappingInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BAPlayerBHRLCchannelMappingInfoList, BAPlayerBHRLCchannelMappingInfoList_sequence_of,
                                                  1, maxnoofMappingEntries, FALSE);

  return offset;
}


static const per_sequence_t MappingInformationtoRemove_sequence_of[1] = {
  { &hf_f1ap_MappingInformationtoRemove_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MappingInformationIndex },
};

static int
dissect_f1ap_MappingInformationtoRemove(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MappingInformationtoRemove, MappingInformationtoRemove_sequence_of,
                                                  1, maxnoofMappingEntries, FALSE);

  return offset;
}


static const per_sequence_t BAPlayerBHRLCchannelMappingInfo_sequence[] = {
  { &hf_f1ap_bAPlayerBHRLCchannelMappingInfoToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BAPlayerBHRLCchannelMappingInfoList },
  { &hf_f1ap_bAPlayerBHRLCchannelMappingInfoToRemove, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MappingInformationtoRemove },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPlayerBHRLCchannelMappingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPlayerBHRLCchannelMappingInfo, BAPlayerBHRLCchannelMappingInfo_sequence);

  return offset;
}



static int
dissect_f1ap_BAPPathID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPRoutingID_sequence[] = {
  { &hf_f1ap_bAPAddress     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPAddress },
  { &hf_f1ap_bAPPathID      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPPathID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPRoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPRoutingID, BAPRoutingID_sequence);

  return offset;
}


static const value_string f1ap_BearerTypeChange_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_BearerTypeChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_CauseRadioNetwork_vals[] = {
  {   0, "unspecified" },
  {   1, "rl-failure-rlc" },
  {   2, "unknown-or-already-allocated-gnb-cu-ue-f1ap-id" },
  {   3, "unknown-or-already-allocated-gnb-du-ue-f1ap-id" },
  {   4, "unknown-or-inconsistent-pair-of-ue-f1ap-id" },
  {   5, "interaction-with-other-procedure" },
  {   6, "not-supported-qci-Value" },
  {   7, "action-desirable-for-radio-reasons" },
  {   8, "no-radio-resources-available" },
  {   9, "procedure-cancelled" },
  {  10, "normal-release" },
  {  11, "cell-not-available" },
  {  12, "rl-failure-others" },
  {  13, "ue-rejection" },
  {  14, "resources-not-available-for-the-slice" },
  {  15, "amf-initiated-abnormal-release" },
  {  16, "release-due-to-pre-emption" },
  {  17, "plmn-not-served-by-the-gNB-CU" },
  {  18, "multiple-drb-id-instances" },
  {  19, "unknown-drb-id" },
  {  20, "multiple-bh-rlc-ch-id-instances" },
  {  21, "unknown-bh-rlc-ch-id" },
  {  22, "cho-cpc-resources-tobechanged" },
  {  23, "nPN-not-supported" },
  {  24, "nPN-access-denied" },
  {  25, "gNB-CU-Cell-Capacity-Exceeded" },
  {  26, "report-characteristics-empty" },
  {  27, "existing-measurement-ID" },
  {  28, "measurement-temporarily-not-available" },
  {  29, "measurement-not-supported-for-the-object" },
  {  30, "unknown-bh-address" },
  {  31, "unknown-bap-routing-id" },
  {  32, "insufficient-ue-capabilities" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseRadioNetwork(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, TRUE, 22, NULL);

  return offset;
}


static const value_string f1ap_CauseTransport_vals[] = {
  {   0, "unspecified" },
  {   1, "transport-resource-unavailable" },
  {   2, "unknown-TNL-address-for-IAB" },
  {   3, "unknown-UP-TNL-information-for-IAB" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseTransport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 2, NULL);

  return offset;
}


static const value_string f1ap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "abstract-syntax-error-falsely-constructed-message" },
  {   6, "unspecified" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "not-enough-user-plane-processing-resources" },
  {   2, "hardware-failure" },
  {   3, "om-intervention" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_f1ap_radioNetwork   , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseRadioNetwork },
  {   1, &hf_f1ap_transport      , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseTransport },
  {   2, &hf_f1ap_protocol       , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseProtocol },
  {   3, &hf_f1ap_misc           , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseMisc },
  {   4, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_Cause, Cause_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeModified_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_FailedToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_FailedToBeModified_Item, BHChannels_FailedToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeSetup_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_FailedToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_FailedToBeSetup_Item, BHChannels_FailedToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_FailedToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_FailedToBeSetupMod_Item, BHChannels_FailedToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_Modified_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_Modified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_Modified_Item, BHChannels_Modified_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_Required_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_Required_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_Required_ToBeReleased_Item, BHChannels_Required_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_Setup_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_Setup_Item, BHChannels_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_SetupMod_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_SetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_SetupMod_Item, BHChannels_SetupMod_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_255_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_MaxDataBurstVolume(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}


static const per_sequence_t NonDynamic5QIDescriptor_sequence[] = {
  { &hf_f1ap_fiveQI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255_ },
  { &hf_f1ap_qoSPriorityLevel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_127 },
  { &hf_f1ap_averagingWindow, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AveragingWindow },
  { &hf_f1ap_maxDataBurstVolume, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MaxDataBurstVolume },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NonDynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NonDynamic5QIDescriptor, NonDynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string f1ap_T_delayCritical_vals[] = {
  {   0, "delay-critical" },
  {   1, "non-delay-critical" },
  { 0, NULL }
};


static int
dissect_f1ap_T_delayCritical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Dynamic5QIDescriptor_sequence[] = {
  { &hf_f1ap_qoSPriorityLevel, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_127 },
  { &hf_f1ap_packetDelayBudget, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketDelayBudget },
  { &hf_f1ap_packetErrorRate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketErrorRate },
  { &hf_f1ap_fiveQI         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_255_ },
  { &hf_f1ap_delayCritical  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_delayCritical },
  { &hf_f1ap_averagingWindow, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AveragingWindow },
  { &hf_f1ap_maxDataBurstVolume, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MaxDataBurstVolume },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Dynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Dynamic5QIDescriptor, Dynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string f1ap_QoS_Characteristics_vals[] = {
  {   0, "non-Dynamic-5QI" },
  {   1, "dynamic-5QI" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t QoS_Characteristics_choice[] = {
  {   0, &hf_f1ap_non_Dynamic_5QI, ASN1_NO_EXTENSIONS     , dissect_f1ap_NonDynamic5QIDescriptor },
  {   1, &hf_f1ap_dynamic_5QI    , ASN1_NO_EXTENSIONS     , dissect_f1ap_Dynamic5QIDescriptor },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_QoS_Characteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_QoS_Characteristics, QoS_Characteristics_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NGRANAllocationAndRetentionPriority_sequence[] = {
  { &hf_f1ap_priorityLevel  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PriorityLevel },
  { &hf_f1ap_pre_emptionCapability, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionCapability },
  { &hf_f1ap_pre_emptionVulnerability, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionVulnerability },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NGRANAllocationAndRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NGRANAllocationAndRetentionPriority, NGRANAllocationAndRetentionPriority_sequence);

  return offset;
}



static int
dissect_f1ap_MaxPacketLossRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GBR_QoSFlowInformation_sequence[] = {
  { &hf_f1ap_maxFlowBitRateDownlink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_maxFlowBitRateUplink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_guaranteedFlowBitRateDownlink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_guaranteedFlowBitRateUplink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_maxPacketLossRateDownlink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MaxPacketLossRate },
  { &hf_f1ap_maxPacketLossRateUplink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MaxPacketLossRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GBR_QoSFlowInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GBR_QoSFlowInformation, GBR_QoSFlowInformation_sequence);

  return offset;
}


static const value_string f1ap_T_reflective_QoS_Attribute_vals[] = {
  {   0, "subject-to" },
  { 0, NULL }
};


static int
dissect_f1ap_T_reflective_QoS_Attribute(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlowLevelQoSParameters_sequence[] = {
  { &hf_f1ap_qoS_Characteristics, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoS_Characteristics },
  { &hf_f1ap_nGRANallocationRetentionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NGRANAllocationAndRetentionPriority },
  { &hf_f1ap_gBR_QoS_Flow_Information, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_GBR_QoSFlowInformation },
  { &hf_f1ap_reflective_QoS_Attribute, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_reflective_QoS_Attribute },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_QoSFlowLevelQoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_QoSFlowLevelQoSParameters, QoSFlowLevelQoSParameters_sequence);

  return offset;
}



static int
dissect_f1ap_QCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GBR_QosInformation_sequence[] = {
  { &hf_f1ap_e_RAB_MaximumBitrateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_e_RAB_MaximumBitrateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_e_RAB_GuaranteedBitrateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_e_RAB_GuaranteedBitrateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GBR_QosInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GBR_QosInformation, GBR_QosInformation_sequence);

  return offset;
}


static const per_sequence_t EUTRANQoS_sequence[] = {
  { &hf_f1ap_qCI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QCI },
  { &hf_f1ap_allocationAndRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_AllocationAndRetentionPriority },
  { &hf_f1ap_gbrQosInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GBR_QosInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRANQoS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRANQoS, EUTRANQoS_sequence);

  return offset;
}



static int
dissect_f1ap_CPTrafficType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_BHQoSInformation_vals[] = {
  {   0, "bHRLCCHQoS" },
  {   1, "eUTRANBHRLCCHQoS" },
  {   2, "cPTrafficType" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t BHQoSInformation_choice[] = {
  {   0, &hf_f1ap_bHRLCCHQoS     , ASN1_NO_EXTENSIONS     , dissect_f1ap_QoSFlowLevelQoSParameters },
  {   1, &hf_f1ap_eUTRANBHRLCCHQoS, ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRANQoS },
  {   2, &hf_f1ap_cPTrafficType  , ASN1_NO_EXTENSIONS     , dissect_f1ap_CPTrafficType },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_BHQoSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_BHQoSInformation, BHQoSInformation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_RLCMode_vals[] = {
  {   0, "rlc-am" },
  {   1, "rlc-um-bidirectional" },
  {   2, "rlc-um-unidirectional-ul" },
  {   3, "rlc-um-unidirectional-dl" },
  { 0, NULL }
};


static int
dissect_f1ap_RLCMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_T_iPv4Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1753 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_IABTNLAddressIPv4Address);
    proto_tree_add_item(subtree, hf_f1ap_IABTNLAddressIPv4, param_tvb, 0, 4, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_f1ap_T_iPv6Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1761 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     128, 128, FALSE, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_IABTNLAddressIPv6Address);
    proto_tree_add_item(subtree, hf_f1ap_IABTNLAddressIPv6, param_tvb, 0, 16, ENC_NA);
  }



  return offset;
}



static int
dissect_f1ap_T_iPv6Prefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1769 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_IABTNLAddressIPv6Prefix);
    proto_tree_add_item(subtree, hf_f1ap_IABTNLAddressIPv6Prefix, param_tvb, 0, 8, ENC_NA);
  }



  return offset;
}


static const value_string f1ap_IABTNLAddress_vals[] = {
  {   0, "iPv4Address" },
  {   1, "iPv6Address" },
  {   2, "iPv6Prefix" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABTNLAddress_choice[] = {
  {   0, &hf_f1ap_iPv4Address    , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_iPv4Address },
  {   1, &hf_f1ap_iPv6Address_01 , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_iPv6Address },
  {   2, &hf_f1ap_iPv6Prefix_01  , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_iPv6Prefix },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_IABTNLAddress, IABTNLAddress_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_DSCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DSInformationList_sequence_of[1] = {
  { &hf_f1ap_DSInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DSCP },
};

static int
dissect_f1ap_DSInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DSInformationList, DSInformationList_sequence_of,
                                                  0, maxnoofDSInfo, FALSE);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t IPHeaderInformation_sequence[] = {
  { &hf_f1ap_destinationIABTNLAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress },
  { &hf_f1ap_dsInformationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DSInformationList },
  { &hf_f1ap_iPv6FlowLabel  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BIT_STRING_SIZE_20 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IPHeaderInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IPHeaderInformation, IPHeaderInformation_sequence);

  return offset;
}


static const per_sequence_t EgressBHRLCCHItem_sequence[] = {
  { &hf_f1ap_nextHopBAPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPAddress },
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EgressBHRLCCHItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EgressBHRLCCHItem, EgressBHRLCCHItem_sequence);

  return offset;
}


static const per_sequence_t EgressBHRLCCHList_sequence_of[1] = {
  { &hf_f1ap_EgressBHRLCCHList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EgressBHRLCCHItem },
};

static int
dissect_f1ap_EgressBHRLCCHList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_EgressBHRLCCHList, EgressBHRLCCHList_sequence_of,
                                                  1, maxnoofEgressLinks, FALSE);

  return offset;
}


static const per_sequence_t BHInfo_sequence[] = {
  { &hf_f1ap_bAProutingID   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_egressBHRLCCHList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_EgressBHRLCCHList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHInfo, BHInfo_sequence);

  return offset;
}


static const per_sequence_t IPtolayer2TrafficMappingInfo_Item_sequence[] = {
  { &hf_f1ap_mappingInformationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MappingInformationIndex },
  { &hf_f1ap_iPHeaderInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_IPHeaderInformation },
  { &hf_f1ap_bHInfo         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BHInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IPtolayer2TrafficMappingInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IPtolayer2TrafficMappingInfo_Item, IPtolayer2TrafficMappingInfo_Item_sequence);

  return offset;
}


static const per_sequence_t IPtolayer2TrafficMappingInfoList_sequence_of[1] = {
  { &hf_f1ap_IPtolayer2TrafficMappingInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IPtolayer2TrafficMappingInfo_Item },
};

static int
dissect_f1ap_IPtolayer2TrafficMappingInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IPtolayer2TrafficMappingInfoList, IPtolayer2TrafficMappingInfoList_sequence_of,
                                                  1, maxnoofMappingEntries, FALSE);

  return offset;
}


static const per_sequence_t IPtolayer2TrafficMappingInfo_sequence[] = {
  { &hf_f1ap_iPtolayer2TrafficMappingInfoToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_IPtolayer2TrafficMappingInfoList },
  { &hf_f1ap_iPtolayer2TrafficMappingInfoToRemove, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MappingInformationtoRemove },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IPtolayer2TrafficMappingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IPtolayer2TrafficMappingInfo, IPtolayer2TrafficMappingInfo_sequence);

  return offset;
}


static const value_string f1ap_TrafficMappingInfo_vals[] = {
  {   0, "iPtolayer2TrafficMappingInfo" },
  {   1, "bAPlayerBHRLCchannelMappingInfo" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TrafficMappingInfo_choice[] = {
  {   0, &hf_f1ap_iPtolayer2TrafficMappingInfo, ASN1_NO_EXTENSIONS     , dissect_f1ap_IPtolayer2TrafficMappingInfo },
  {   1, &hf_f1ap_bAPlayerBHRLCchannelMappingInfo, ASN1_NO_EXTENSIONS     , dissect_f1ap_BAPlayerBHRLCchannelMappingInfo },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TrafficMappingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TrafficMappingInfo, TrafficMappingInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BHChannels_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_bHQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHQoSInformation },
  { &hf_f1ap_rLCmode        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RLCMode },
  { &hf_f1ap_bAPCtrlPDUChannel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPCtrlPDUChannel },
  { &hf_f1ap_trafficMappingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TrafficMappingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeModified_Item, BHChannels_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeReleased_Item, BHChannels_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_bHQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHQoSInformation },
  { &hf_f1ap_rLCmode        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_bAPCtrlPDUChannel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPCtrlPDUChannel },
  { &hf_f1ap_trafficMappingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TrafficMappingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeSetup_Item, BHChannels_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_bHQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHQoSInformation },
  { &hf_f1ap_rLCmode        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_bAPCtrlPDUChannel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPCtrlPDUChannel },
  { &hf_f1ap_trafficMappingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TrafficMappingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeSetupMod_Item, BHChannels_ToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t BH_Routing_Information_Added_List_Item_sequence[] = {
  { &hf_f1ap_bAPRoutingID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_nextHopBAPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BH_Routing_Information_Added_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BH_Routing_Information_Added_List_Item, BH_Routing_Information_Added_List_Item_sequence);

  return offset;
}


static const per_sequence_t BH_Routing_Information_Removed_List_Item_sequence[] = {
  { &hf_f1ap_bAPRoutingID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BH_Routing_Information_Removed_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BH_Routing_Information_Removed_List_Item, BH_Routing_Information_Removed_List_Item_sequence);

  return offset;
}


static const per_sequence_t ExtendedAvailablePLMN_Item_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ExtendedAvailablePLMN_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ExtendedAvailablePLMN_Item, ExtendedAvailablePLMN_Item_sequence);

  return offset;
}


static const per_sequence_t ExtendedAvailablePLMN_List_sequence_of[1] = {
  { &hf_f1ap_ExtendedAvailablePLMN_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedAvailablePLMN_Item },
};

static int
dissect_f1ap_ExtendedAvailablePLMN_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ExtendedAvailablePLMN_List, ExtendedAvailablePLMN_List_sequence_of,
                                                  1, maxnoofExtendedBPLMNs, FALSE);

  return offset;
}



static int
dissect_f1ap_FiveGS_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1476 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       3, 3, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 3, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_f1ap_RANAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_AvailablePLMNList },
  { &hf_f1ap_extended_PLMN_Identity_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ExtendedAvailablePLMN_List },
  { &hf_f1ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveGS_TAC },
  { &hf_f1ap_nr_cell_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCellIdentity },
  { &hf_f1ap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_RANAC },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BPLMN_ID_Info_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BPLMN_ID_Info_Item, BPLMN_ID_Info_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_List_sequence_of[1] = {
  { &hf_f1ap_BPLMN_ID_Info_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BPLMN_ID_Info_Item },
};

static int
dissect_f1ap_BPLMN_ID_Info_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BPLMN_ID_Info_List, BPLMN_ID_Info_List_sequence_of,
                                                  1, maxnoofBPLMNsNR, FALSE);

  return offset;
}


static const per_sequence_t ServedPLMNs_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ServedPLMNs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ServedPLMNs_Item, ServedPLMNs_Item_sequence);

  return offset;
}


static const per_sequence_t ServedPLMNs_List_sequence_of[1] = {
  { &hf_f1ap_ServedPLMNs_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ServedPLMNs_Item },
};

static int
dissect_f1ap_ServedPLMNs_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ServedPLMNs_List, ServedPLMNs_List_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}



static int
dissect_f1ap_CAGID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BroadcastCAGList_sequence_of[1] = {
  { &hf_f1ap_BroadcastCAGList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CAGID },
};

static int
dissect_f1ap_BroadcastCAGList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastCAGList, BroadcastCAGList_sequence_of,
                                                  1, maxnoofCAGsupported, FALSE);

  return offset;
}


static const per_sequence_t BroadcastSNPN_ID_List_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_broadcastNIDList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastNIDList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastSNPN_ID_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastSNPN_ID_List_Item, BroadcastSNPN_ID_List_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastSNPN_ID_List_sequence_of[1] = {
  { &hf_f1ap_BroadcastSNPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastSNPN_ID_List_Item },
};

static int
dissect_f1ap_BroadcastSNPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastSNPN_ID_List, BroadcastSNPN_ID_List_sequence_of,
                                                  1, maxnoofNIDsupported, FALSE);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_List_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_broadcastCAGList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastCAGList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastPNI_NPN_ID_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastPNI_NPN_ID_List_Item, BroadcastPNI_NPN_ID_List_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_List_sequence_of[1] = {
  { &hf_f1ap_BroadcastPNI_NPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastPNI_NPN_ID_List_Item },
};

static int
dissect_f1ap_BroadcastPNI_NPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastPNI_NPN_ID_List, BroadcastPNI_NPN_ID_List_sequence_of,
                                                  1, maxnoofCAGsupported, FALSE);

  return offset;
}



static int
dissect_f1ap_BurstArrivalTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1710 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_BurstArrivalTime);
    dissect_nr_rrc_ReferenceTime_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_Cancel_all_Warning_Messages_Indicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_Cancel_all_Warning_Messages_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Candidate_SpCell_Item_sequence[] = {
  { &hf_f1ap_candidate_SpCell_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Candidate_SpCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Candidate_SpCell_Item, Candidate_SpCell_Item_sequence);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValueItem_sequence[] = {
  { &hf_f1ap_sSBIndex       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_sSBAreaCapacityValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBAreaCapacityValueItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBAreaCapacityValueItem, SSBAreaCapacityValueItem_sequence);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValueList_sequence_of[1] = {
  { &hf_f1ap_SSBAreaCapacityValueList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBAreaCapacityValueItem },
};

static int
dissect_f1ap_SSBAreaCapacityValueList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBAreaCapacityValueList, SSBAreaCapacityValueList_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t CapacityValue_sequence[] = {
  { &hf_f1ap_capacityValue  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaCapacityValueList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSBAreaCapacityValueList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CapacityValue, CapacityValue_sequence);

  return offset;
}



static int
dissect_f1ap_CellGroupConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1434 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_CellGroupConfig);
    dissect_nr_rrc_CellGroupConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_CellCapacityClassValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_Cell_Direction_vals[] = {
  {   0, "dl-only" },
  {   1, "ul-only" },
  { 0, NULL }
};


static int
dissect_f1ap_Cell_Direction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatusItem_sequence[] = {
  { &hf_f1ap_sSBIndex       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_sSBAreaDLGBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaULGBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaDLnon_GBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaULnon_GBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaDLTotalPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaULTotalPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_dLschedulingPDCCHCCEusage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_uLschedulingPDCCHCCEusage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBAreaRadioResourceStatusItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBAreaRadioResourceStatusItem, SSBAreaRadioResourceStatusItem_sequence);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatusList_sequence_of[1] = {
  { &hf_f1ap_SSBAreaRadioResourceStatusList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBAreaRadioResourceStatusItem },
};

static int
dissect_f1ap_SSBAreaRadioResourceStatusList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBAreaRadioResourceStatusList, SSBAreaRadioResourceStatusList_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t RadioResourceStatus_sequence[] = {
  { &hf_f1ap_sSBAreaRadioResourceStatusList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBAreaRadioResourceStatusList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RadioResourceStatus, RadioResourceStatus_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacity_sequence[] = {
  { &hf_f1ap_cellCapacityClassValue, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_CellCapacityClassValue },
  { &hf_f1ap_capacityValue_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CapacityValue },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CompositeAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CompositeAvailableCapacity, CompositeAvailableCapacity_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacityGroup_sequence[] = {
  { &hf_f1ap_compositeAvailableCapacityDownlink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CompositeAvailableCapacity },
  { &hf_f1ap_compositeAvailableCapacityUplink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CompositeAvailableCapacity },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CompositeAvailableCapacityGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CompositeAvailableCapacityGroup, CompositeAvailableCapacityGroup_sequence);

  return offset;
}



static int
dissect_f1ap_OCTET_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, FALSE, NULL);

  return offset;
}



static int
dissect_f1ap_OCTET_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, NULL);

  return offset;
}


static const per_sequence_t SNSSAI_sequence[] = {
  { &hf_f1ap_sST            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_OCTET_STRING_SIZE_1 },
  { &hf_f1ap_sD             , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_OCTET_STRING_SIZE_3 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SNSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SNSSAI, SNSSAI_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_Item_sequence[] = {
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_sliceAvailableCapacityValueDownlink, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sliceAvailableCapacityValueUplink, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SNSSAIAvailableCapacity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SNSSAIAvailableCapacity_Item, SNSSAIAvailableCapacity_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_List_sequence_of[1] = {
  { &hf_f1ap_SNSSAIAvailableCapacity_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAIAvailableCapacity_Item },
};

static int
dissect_f1ap_SNSSAIAvailableCapacity_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SNSSAIAvailableCapacity_List, SNSSAIAvailableCapacity_List_sequence_of,
                                                  1, maxnoofSliceItems, FALSE);

  return offset;
}


static const per_sequence_t SliceAvailableCapacityItem_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_sNSSAIAvailableCapacity_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAIAvailableCapacity_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceAvailableCapacityItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceAvailableCapacityItem, SliceAvailableCapacityItem_sequence);

  return offset;
}


static const per_sequence_t SliceAvailableCapacityList_sequence_of[1] = {
  { &hf_f1ap_SliceAvailableCapacityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceAvailableCapacityItem },
};

static int
dissect_f1ap_SliceAvailableCapacityList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SliceAvailableCapacityList, SliceAvailableCapacityList_sequence_of,
                                                  1, maxnoofBPLMNsNR, FALSE);

  return offset;
}


static const per_sequence_t SliceAvailableCapacity_sequence[] = {
  { &hf_f1ap_sliceAvailableCapacityList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceAvailableCapacityList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceAvailableCapacity, SliceAvailableCapacity_sequence);

  return offset;
}



static int
dissect_f1ap_NumberofActiveUEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CellMeasurementResultItem_sequence[] = {
  { &hf_f1ap_cellID         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_radioResourceStatus, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RadioResourceStatus },
  { &hf_f1ap_compositeAvailableCapacityGroup, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_CompositeAvailableCapacityGroup },
  { &hf_f1ap_sliceAvailableCapacity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SliceAvailableCapacity },
  { &hf_f1ap_numberofActiveUEs, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NumberofActiveUEs },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellMeasurementResultItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellMeasurementResultItem, CellMeasurementResultItem_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResultList_sequence_of[1] = {
  { &hf_f1ap_CellMeasurementResultList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CellMeasurementResultItem },
};

static int
dissect_f1ap_CellMeasurementResultList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CellMeasurementResultList, CellMeasurementResultList_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}



static int
dissect_f1ap_Cell_Portion_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Cells_Failed_to_be_Activated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Failed_to_be_Activated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Failed_to_be_Activated_List_Item, Cells_Failed_to_be_Activated_List_Item_sequence);

  return offset;
}


static const value_string f1ap_Service_State_vals[] = {
  {   0, "in-service" },
  {   1, "out-of-service" },
  { 0, NULL }
};


static int
dissect_f1ap_Service_State(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_switchingOffOngoing_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_switchingOffOngoing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Service_Status_sequence[] = {
  { &hf_f1ap_service_state  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Service_State },
  { &hf_f1ap_switchingOffOngoing, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_T_switchingOffOngoing },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Service_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Service_Status, Service_Status_sequence);

  return offset;
}


static const per_sequence_t Cells_Status_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_service_status , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Service_Status },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Status_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Status_Item, Cells_Status_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_To_Be_Broadcast_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_To_Be_Broadcast_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_To_Be_Broadcast_Item, Cells_To_Be_Broadcast_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_Broadcast_Completed_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Broadcast_Completed_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Broadcast_Completed_Item, Cells_Broadcast_Completed_Item_sequence);

  return offset;
}


static const per_sequence_t Broadcast_To_Be_Cancelled_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Broadcast_To_Be_Cancelled_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Broadcast_To_Be_Cancelled_Item, Broadcast_To_Be_Cancelled_Item_sequence);

  return offset;
}



static int
dissect_f1ap_NumberOfBroadcasts(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Cells_Broadcast_Cancelled_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NumberOfBroadcasts },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Broadcast_Cancelled_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Broadcast_Cancelled_Item, Cells_Broadcast_Cancelled_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_to_be_Activated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_nRPCI          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPCI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_to_be_Activated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_to_be_Activated_List_Item, Cells_to_be_Activated_List_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_to_be_Deactivated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_to_be_Deactivated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_to_be_Deactivated_List_Item, Cells_to_be_Deactivated_List_Item_sequence);

  return offset;
}


static const value_string f1ap_CellBarred_vals[] = {
  {   0, "barred" },
  {   1, "not-barred" },
  { 0, NULL }
};


static int
dissect_f1ap_CellBarred(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Cells_to_be_Barred_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_cellBarred     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CellBarred },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_to_be_Barred_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_to_be_Barred_Item, Cells_to_be_Barred_Item_sequence);

  return offset;
}


static const value_string f1ap_CellSize_vals[] = {
  {   0, "verysmall" },
  {   1, "small" },
  {   2, "medium" },
  {   3, "large" },
  { 0, NULL }
};


static int
dissect_f1ap_CellSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SSBToReportItem_sequence[] = {
  { &hf_f1ap_sSBIndex       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBToReportItem, SSBToReportItem_sequence);

  return offset;
}


static const per_sequence_t SSBToReportList_sequence_of[1] = {
  { &hf_f1ap_SSBToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBToReportItem },
};

static int
dissect_f1ap_SSBToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBToReportList, SSBToReportList_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t SNSSAI_Item_sequence[] = {
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SNSSAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SNSSAI_Item, SNSSAI_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAI_list_sequence_of[1] = {
  { &hf_f1ap_SNSSAI_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI_Item },
};

static int
dissect_f1ap_SNSSAI_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SNSSAI_list, SNSSAI_list_sequence_of,
                                                  1, maxnoofSliceItems, FALSE);

  return offset;
}


static const per_sequence_t SliceToReportItem_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_sNSSAIlist     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI_list },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceToReportItem, SliceToReportItem_sequence);

  return offset;
}


static const per_sequence_t SliceToReportList_sequence_of[1] = {
  { &hf_f1ap_SliceToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceToReportItem },
};

static int
dissect_f1ap_SliceToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SliceToReportList, SliceToReportList_sequence_of,
                                                  1, maxnoofBPLMNsNR, FALSE);

  return offset;
}


static const per_sequence_t CellToReportItem_sequence[] = {
  { &hf_f1ap_cellID         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sSBToReportList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSBToReportList },
  { &hf_f1ap_sliceToReportList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SliceToReportList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellToReportItem, CellToReportItem_sequence);

  return offset;
}


static const per_sequence_t CellToReportList_sequence_of[1] = {
  { &hf_f1ap_CellToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CellToReportItem },
};

static int
dissect_f1ap_CellToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CellToReportList, CellToReportList_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t CellType_sequence[] = {
  { &hf_f1ap_cellSize       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CellSize },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellType, CellType_sequence);

  return offset;
}


static const value_string f1ap_CellULConfigured_vals[] = {
  {   0, "none" },
  {   1, "ul" },
  {   2, "sul" },
  {   3, "ul-and-sul" },
  { 0, NULL }
};


static int
dissect_f1ap_CellULConfigured(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_SSB_freqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, FALSE);

  return offset;
}


static const value_string f1ap_SSB_subcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz120" },
  {   3, "kHz240" },
  {   4, "spare3" },
  {   5, "spare2" },
  {   6, "spare1" },
  { 0, NULL }
};


static int
dissect_f1ap_SSB_subcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_SSB_transmissionPeriodicity_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf40" },
  {   3, "sf80" },
  {   4, "sf160" },
  {   5, "sf320" },
  {   6, "sf640" },
  { 0, NULL }
};


static int
dissect_f1ap_SSB_transmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_SSB_transmissionTimingOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_SSB_transmissionBitmap_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_transmissionBitmap_choice[] = {
  {   0, &hf_f1ap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_4 },
  {   1, &hf_f1ap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_8 },
  {   2, &hf_f1ap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_64 },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SSB_transmissionBitmap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SSB_transmissionBitmap, SSB_transmissionBitmap_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IAB_STC_Info_Item_sequence[] = {
  { &hf_f1ap_sSB_freqInfo   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_freqInfo },
  { &hf_f1ap_sSB_subcarrierSpacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_subcarrierSpacing },
  { &hf_f1ap_sSB_transmissionPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_transmissionPeriodicity },
  { &hf_f1ap_sSB_transmissionTimingOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_transmissionTimingOffset },
  { &hf_f1ap_sSB_transmissionBitmap, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_transmissionBitmap },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_STC_Info_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_STC_Info_Item, IAB_STC_Info_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_STC_Info_List_sequence_of[1] = {
  { &hf_f1ap_IAB_STC_Info_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_STC_Info_Item },
};

static int
dissect_f1ap_IAB_STC_Info_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IAB_STC_Info_List, IAB_STC_Info_List_sequence_of,
                                                  1, maxnoofIABSTCInfo, FALSE);

  return offset;
}


static const per_sequence_t IAB_STC_Info_sequence[] = {
  { &hf_f1ap_iAB_STC_Info_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_STC_Info_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_STC_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_STC_Info, IAB_STC_Info_sequence);

  return offset;
}



static int
dissect_f1ap_RACH_Config_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1829 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RACH_Config_Common);
    dissect_nr_rrc_RACH_ConfigCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_RACH_Config_Common_IAB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1837 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RACH_Config_Common_IAB);
    dissect_nr_rrc_RACH_ConfigCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_T_cSI_RS_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1718 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_cSI_RS_Configuration);
    dissect_nr_rrc_NZP_CSI_RS_Resource_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_T_sR_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1726 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sR_Configuration);
    dissect_nr_rrc_SchedulingRequestResourceConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_T_pDCCH_ConfigSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1734 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_pDCCH_ConfigSIB1);
    dissect_nr_rrc_PDCCH_ConfigSIB1_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_T_sCS_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1742 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sCS_Common);
    dissect_nr_rrc_subCarrierSpacingCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_DU_RX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_RX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_TX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_TX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_RX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_RX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_TX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_TX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_Item_sequence[] = {
  { &hf_f1ap_nRCellIdentity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCellIdentity },
  { &hf_f1ap_dU_RX_MT_RX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_RX_MT_RX },
  { &hf_f1ap_dU_TX_MT_TX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_TX_MT_TX },
  { &hf_f1ap_dU_RX_MT_TX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_RX_MT_TX },
  { &hf_f1ap_dU_TX_MT_RX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_TX_MT_RX },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_MT_Cell_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_MT_Cell_List_Item, IAB_MT_Cell_List_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_sequence_of[1] = {
  { &hf_f1ap_IAB_MT_Cell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_MT_Cell_List_Item },
};

static int
dissect_f1ap_IAB_MT_Cell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IAB_MT_Cell_List, IAB_MT_Cell_List_sequence_of,
                                                  1, maxnoofServingCells, FALSE);

  return offset;
}


static const per_sequence_t MultiplexingInfo_sequence[] = {
  { &hf_f1ap_iAB_MT_Cell_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_MT_Cell_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MultiplexingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MultiplexingInfo, MultiplexingInfo_sequence);

  return offset;
}


static const per_sequence_t Child_Node_Cells_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iAB_DU_Cell_Resource_Configuration_Mode_Info, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info },
  { &hf_f1ap_iAB_STC_Info   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_STC_Info },
  { &hf_f1ap_rACH_Config_Common, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RACH_Config_Common },
  { &hf_f1ap_rACH_Config_Common_IAB, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RACH_Config_Common_IAB },
  { &hf_f1ap_cSI_RS_Configuration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_cSI_RS_Configuration },
  { &hf_f1ap_sR_Configuration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_sR_Configuration },
  { &hf_f1ap_pDCCH_ConfigSIB1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_pDCCH_ConfigSIB1 },
  { &hf_f1ap_sCS_Common     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_sCS_Common },
  { &hf_f1ap_multiplexingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MultiplexingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Child_Node_Cells_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Child_Node_Cells_List_Item, Child_Node_Cells_List_Item_sequence);

  return offset;
}


static const per_sequence_t Child_Node_Cells_List_sequence_of[1] = {
  { &hf_f1ap_Child_Node_Cells_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Child_Node_Cells_List_Item },
};

static int
dissect_f1ap_Child_Node_Cells_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Child_Node_Cells_List, Child_Node_Cells_List_sequence_of,
                                                  1, maxnoofChildIABNodes, FALSE);

  return offset;
}



static int
dissect_f1ap_GNB_CU_UE_F1AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_GNB_DU_UE_F1AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Child_Nodes_List_Item_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_gNB_DU_UE_F1AP_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_child_Node_Cells_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Child_Node_Cells_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Child_Nodes_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Child_Nodes_List_Item, Child_Nodes_List_Item_sequence);

  return offset;
}


static const per_sequence_t Child_Nodes_List_sequence_of[1] = {
  { &hf_f1ap_Child_Nodes_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Child_Nodes_List_Item },
};

static int
dissect_f1ap_Child_Nodes_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Child_Nodes_List, Child_Nodes_List_sequence_of,
                                                  1, maxnoofChildIABNodes, FALSE);

  return offset;
}


static const value_string f1ap_CHOtrigger_InterDU_vals[] = {
  {   0, "cho-initiation" },
  {   1, "cho-replace" },
  { 0, NULL }
};


static int
dissect_f1ap_CHOtrigger_InterDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_CHOtrigger_IntraDU_vals[] = {
  {   0, "cho-initiation" },
  {   1, "cho-replace" },
  {   2, "cho-cancel" },
  { 0, NULL }
};


static int
dissect_f1ap_CHOtrigger_IntraDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_48(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     48, 48, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_CNUEPagingIdentity_vals[] = {
  {   0, "fiveG-S-TMSI" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CNUEPagingIdentity_choice[] = {
  {   0, &hf_f1ap_fiveG_S_TMSI   , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_48 },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_CNUEPagingIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_CNUEPagingIdentity, CNUEPagingIdentity_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_CHO_Probability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ConditionalInterDUMobilityInformation_sequence[] = {
  { &hf_f1ap_cho_trigger    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CHOtrigger_InterDU },
  { &hf_f1ap_targetgNB_DUUEF1APID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ConditionalInterDUMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ConditionalInterDUMobilityInformation, ConditionalInterDUMobilityInformation_sequence);

  return offset;
}


static const per_sequence_t TargetCellList_Item_sequence[] = {
  { &hf_f1ap_target_cell    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TargetCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TargetCellList_Item, TargetCellList_Item_sequence);

  return offset;
}


static const per_sequence_t TargetCellList_sequence_of[1] = {
  { &hf_f1ap_TargetCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TargetCellList_Item },
};

static int
dissect_f1ap_TargetCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_TargetCellList, TargetCellList_sequence_of,
                                                  1, maxnoofCHOcells, FALSE);

  return offset;
}


static const per_sequence_t ConditionalIntraDUMobilityInformation_sequence[] = {
  { &hf_f1ap_cho_trigger_01 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CHOtrigger_IntraDU },
  { &hf_f1ap_targetCellsTocancel, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TargetCellList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ConditionalIntraDUMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ConditionalIntraDUMobilityInformation, ConditionalIntraDUMobilityInformation_sequence);

  return offset;
}


static const value_string f1ap_ConfiguredTACIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_ConfiguredTACIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_CoordinateID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Endpoint_IP_address_and_port_sequence[] = {
  { &hf_f1ap_endpointIPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Endpoint_IP_address_and_port(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Endpoint_IP_address_and_port, Endpoint_IP_address_and_port_sequence);

  return offset;
}


static const value_string f1ap_CP_TransportLayerAddress_vals[] = {
  {   0, "endpoint-IP-address" },
  {   1, "endpoint-IP-address-and-port" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CP_TransportLayerAddress_choice[] = {
  {   0, &hf_f1ap_endpoint_IP_address, ASN1_NO_EXTENSIONS     , dissect_f1ap_TransportLayerAddress },
  {   1, &hf_f1ap_endpoint_IP_address_and_port, ASN1_NO_EXTENSIONS     , dissect_f1ap_Endpoint_IP_address_and_port },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_CP_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_CP_TransportLayerAddress, CP_TransportLayerAddress_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_TransactionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_f1ap_TypeOfError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_Item_sequence[] = {
  { &hf_f1ap_iECriticality  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_iE_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_ID },
  { &hf_f1ap_typeOfError    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TypeOfError },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CriticalityDiagnostics_IE_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CriticalityDiagnostics_IE_Item, CriticalityDiagnostics_IE_Item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_f1ap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CriticalityDiagnostics_IE_Item },
};

static int
dissect_f1ap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxnoofErrors, FALSE);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_f1ap_procedureCode  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProcedureCode },
  { &hf_f1ap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TriggeringMessage },
  { &hf_f1ap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Criticality },
  { &hf_f1ap_transactionID  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TransactionID },
  { &hf_f1ap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CriticalityDiagnostics_IE_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}



static int
dissect_f1ap_C_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_RIMRSDetectionStatus_vals[] = {
  {   0, "rs-detected" },
  {   1, "rs-disappeared" },
  { 0, NULL }
};


static int
dissect_f1ap_RIMRSDetectionStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CUDURIMInformation_sequence[] = {
  { &hf_f1ap_victimgNBSetID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBSetID },
  { &hf_f1ap_rIMRSDetectionStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RIMRSDetectionStatus },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CUDURIMInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CUDURIMInformation, CUDURIMInformation_sequence);

  return offset;
}


static const value_string f1ap_CUDURadioInformationType_vals[] = {
  {   0, "rIM" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CUDURadioInformationType_choice[] = {
  {   0, &hf_f1ap_rIM            , ASN1_NO_EXTENSIONS     , dissect_f1ap_CUDURIMInformation },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_CUDURadioInformationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_CUDURadioInformationType, CUDURadioInformationType_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_CG_ConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1402 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_CG_ConfigInfo);
    dissect_nr_rrc_CG_ConfigInfo_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_UE_CapabilityRAT_ContainerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1410 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_UE_CapabilityRAT_ContainerList);
    dissect_nr_rrc_UE_CapabilityRAT_ContainerList_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_MeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1418 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MeasConfig);
    dissect_nr_rrc_MeasConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t CUtoDURRCInformation_sequence[] = {
  { &hf_f1ap_cG_ConfigInfo  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CG_ConfigInfo },
  { &hf_f1ap_uE_CapabilityRAT_ContainerList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_UE_CapabilityRAT_ContainerList },
  { &hf_f1ap_measConfig     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MeasConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CUtoDURRCInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CUtoDURRCInformation, CUtoDURRCInformation_sequence);

  return offset;
}


static const value_string f1ap_DCBasedDuplicationConfigured_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_DCBasedDuplicationConfigured(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 1, NULL);

  return offset;
}


static const per_sequence_t Dedicated_SIDelivery_NeededUE_Item_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Dedicated_SIDelivery_NeededUE_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Dedicated_SIDelivery_NeededUE_Item, Dedicated_SIDelivery_NeededUE_Item_sequence);

  return offset;
}



static int
dissect_f1ap_PRS_Resource_Set_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_PRS_Resource_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DL_PRS_sequence[] = {
  { &hf_f1ap_prsid          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_dl_PRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_dl_PRSResourceID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PRS_Resource_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DL_PRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DL_PRS, DL_PRS_sequence);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_DL_PRSMutingPattern_vals[] = {
  {   0, "two" },
  {   1, "four" },
  {   2, "six" },
  {   3, "eight" },
  {   4, "sixteen" },
  {   5, "thirty-two" },
  {   6, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DL_PRSMutingPattern_choice[] = {
  {   0, &hf_f1ap_two            , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_2 },
  {   1, &hf_f1ap_four           , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_4 },
  {   2, &hf_f1ap_six            , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_6 },
  {   3, &hf_f1ap_eight          , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_8 },
  {   4, &hf_f1ap_sixteen        , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_16 },
  {   5, &hf_f1ap_thirty_two     , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_32 },
  {   6, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DL_PRSMutingPattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DL_PRSMutingPattern, DL_PRSMutingPattern_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_T_milli_Arc_SecondUnits_vals[] = {
  {   0, "zerodot03" },
  {   1, "zerodot3" },
  {   2, "three" },
  { 0, NULL }
};


static int
dissect_f1ap_T_milli_Arc_SecondUnits(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_heightUnits_vals[] = {
  {   0, "mm" },
  {   1, "cm" },
  {   2, "m" },
  { 0, NULL }
};


static int
dissect_f1ap_T_heightUnits(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_M1024_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1024, 1023U, NULL, FALSE);

  return offset;
}


static const per_sequence_t LocationUncertainty_sequence[] = {
  { &hf_f1ap_horizontalUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_horizontalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_verticalUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_verticalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LocationUncertainty(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LocationUncertainty, LocationUncertainty_sequence);

  return offset;
}


static const per_sequence_t RelativeGeodeticLocation_sequence[] = {
  { &hf_f1ap_milli_Arc_SecondUnits, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_milli_Arc_SecondUnits },
  { &hf_f1ap_heightUnits    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_heightUnits },
  { &hf_f1ap_deltaLatitude  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M1024_1023 },
  { &hf_f1ap_deltaLongitude , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M1024_1023 },
  { &hf_f1ap_deltaHeight    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M1024_1023 },
  { &hf_f1ap_locationUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LocationUncertainty },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RelativeGeodeticLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RelativeGeodeticLocation, RelativeGeodeticLocation_sequence);

  return offset;
}


static const value_string f1ap_T_xYZunit_vals[] = {
  {   0, "mm" },
  {   1, "cm" },
  {   2, "dm" },
  { 0, NULL }
};


static int
dissect_f1ap_T_xYZunit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_M65536_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -65536, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_M32768_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32768, 32767U, NULL, FALSE);

  return offset;
}


static const per_sequence_t RelativeCartesianLocation_sequence[] = {
  { &hf_f1ap_xYZunit        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_xYZunit },
  { &hf_f1ap_xvalue         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M65536_65535 },
  { &hf_f1ap_yvalue         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M65536_65535 },
  { &hf_f1ap_zvalue         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M32768_32767 },
  { &hf_f1ap_locationUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LocationUncertainty },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RelativeCartesianLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RelativeCartesianLocation, RelativeCartesianLocation_sequence);

  return offset;
}


static const value_string f1ap_DL_PRSResourceSetARPLocation_vals[] = {
  {   0, "relativeGeodeticLocation" },
  {   1, "relativeCartesianLocation" },
  {   2, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t DL_PRSResourceSetARPLocation_choice[] = {
  {   0, &hf_f1ap_relativeGeodeticLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeGeodeticLocation },
  {   1, &hf_f1ap_relativeCartesianLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeCartesianLocation },
  {   2, &hf_f1ap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DL_PRSResourceSetARPLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DL_PRSResourceSetARPLocation, DL_PRSResourceSetARPLocation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_DL_PRSResourceARPLocation_vals[] = {
  {   0, "relativeGeodeticLocation" },
  {   1, "relativeCartesianLocation" },
  {   2, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t DL_PRSResourceARPLocation_choice[] = {
  {   0, &hf_f1ap_relativeGeodeticLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeGeodeticLocation },
  {   1, &hf_f1ap_relativeCartesianLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeCartesianLocation },
  {   2, &hf_f1ap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DL_PRSResourceARPLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DL_PRSResourceARPLocation, DL_PRSResourceARPLocation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DLPRSResourceARP_sequence[] = {
  { &hf_f1ap_dl_PRSResourceID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_ID },
  { &hf_f1ap_dL_PRSResourceARPLocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRSResourceARPLocation },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLPRSResourceARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLPRSResourceARP, DLPRSResourceARP_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP_sequence_of[1] = {
  { &hf_f1ap_listofDL_PRSResourceARP_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DLPRSResourceARP },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP, SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP_sequence_of,
                                                  1, maxnoofPRS_ResourcesPerSet, FALSE);

  return offset;
}


static const per_sequence_t DLPRSResourceSetARP_sequence[] = {
  { &hf_f1ap_dl_PRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_dL_PRSResourceSetARPLocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRSResourceSetARPLocation },
  { &hf_f1ap_listofDL_PRSResourceARP, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLPRSResourceSetARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLPRSResourceSetARP, DLPRSResourceSetARP_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP_sequence_of[1] = {
  { &hf_f1ap_listofDL_PRSResourceSetARP_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DLPRSResourceSetARP },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP, SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP_sequence_of,
                                                  1, maxnoofPRS_ResourceSets, FALSE);

  return offset;
}


static const per_sequence_t DLPRSResourceCoordinates_sequence[] = {
  { &hf_f1ap_listofDL_PRSResourceSetARP, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLPRSResourceCoordinates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLPRSResourceCoordinates, DLPRSResourceCoordinates_sequence);

  return offset;
}


static const per_sequence_t DL_UP_TNL_Address_to_Update_List_Item_sequence[] = {
  { &hf_f1ap_oldIPAdress    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_newIPAdress    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DL_UP_TNL_Address_to_Update_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DL_UP_TNL_Address_to_Update_List_Item, DL_UP_TNL_Address_to_Update_List_Item_sequence);

  return offset;
}


static const per_sequence_t DLUPTNLInformation_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_dLUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLUPTNLInformation_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLUPTNLInformation_ToBeSetup_Item, DLUPTNLInformation_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t DLUPTNLInformation_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_DLUPTNLInformation_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_Item },
};

static int
dissect_f1ap_DLUPTNLInformation_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DLUPTNLInformation_ToBeSetup_List, DLUPTNLInformation_ToBeSetup_List_sequence_of,
                                                  1, maxnoofDLUPTNLInformation, FALSE);

  return offset;
}



static int
dissect_f1ap_DRBID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_DRB_Activity_vals[] = {
  {   0, "active" },
  {   1, "not-active" },
  { 0, NULL }
};


static int
dissect_f1ap_DRB_Activity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DRB_Activity_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_dRB_Activity   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DRB_Activity },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRB_Activity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRB_Activity_Item, DRB_Activity_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeModified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_FailedToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_FailedToBeModified_Item, DRBs_FailedToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeSetup_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_FailedToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_FailedToBeSetup_Item, DRBs_FailedToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_FailedToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_FailedToBeSetupMod_Item, DRBs_FailedToBeSetupMod_Item_sequence);

  return offset;
}


static const value_string f1ap_NotificationControl_vals[] = {
  {   0, "active" },
  {   1, "not-active" },
  { 0, NULL }
};


static int
dissect_f1ap_NotificationControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_QoSFlowIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_Item_sequence[] = {
  { &hf_f1ap_qoSFlowIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowIdentifier },
  { &hf_f1ap_qoSFlowLevelQoSParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Flows_Mapped_To_DRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Flows_Mapped_To_DRB_Item, Flows_Mapped_To_DRB_Item_sequence);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_List_sequence_of[1] = {
  { &hf_f1ap_Flows_Mapped_To_DRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Flows_Mapped_To_DRB_Item },
};

static int
dissect_f1ap_Flows_Mapped_To_DRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Flows_Mapped_To_DRB_List, Flows_Mapped_To_DRB_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t DRB_Information_sequence[] = {
  { &hf_f1ap_dRB_QoS        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_notificationControl, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NotificationControl },
  { &hf_f1ap_flows_Mapped_To_DRB_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Flows_Mapped_To_DRB_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRB_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRB_Information, DRB_Information_sequence);

  return offset;
}



static int
dissect_f1ap_LCID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, TRUE);

  return offset;
}


static const per_sequence_t DRBs_Modified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Modified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Modified_Item, DRBs_Modified_Item_sequence);

  return offset;
}


static const per_sequence_t ULUPTNLInformation_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_uLUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ULUPTNLInformation_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ULUPTNLInformation_ToBeSetup_Item, ULUPTNLInformation_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t ULUPTNLInformation_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_ULUPTNLInformation_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_Item },
};

static int
dissect_f1ap_ULUPTNLInformation_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ULUPTNLInformation_ToBeSetup_List, ULUPTNLInformation_ToBeSetup_List_sequence_of,
                                                  1, maxnoofULUPTNLInformation, FALSE);

  return offset;
}


static const per_sequence_t DRBs_ModifiedConf_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ModifiedConf_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ModifiedConf_Item, DRBs_ModifiedConf_Item_sequence);

  return offset;
}


static const value_string f1ap_Notification_Cause_vals[] = {
  {   0, "fulfilled" },
  {   1, "not-fulfilled" },
  { 0, NULL }
};


static int
dissect_f1ap_Notification_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DRB_Notify_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_notification_Cause, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Notification_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRB_Notify_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRB_Notify_Item, DRB_Notify_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_Required_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Required_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Required_ToBeModified_Item, DRBs_Required_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_Required_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Required_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Required_ToBeReleased_Item, DRBs_Required_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_Setup_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Setup_Item, DRBs_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_SetupMod_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_SetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_SetupMod_Item, DRBs_SetupMod_Item_sequence);

  return offset;
}


static const value_string f1ap_QoSInformation_vals[] = {
  {   0, "eUTRANQoS" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t QoSInformation_choice[] = {
  {   0, &hf_f1ap_eUTRANQoS      , ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRANQoS },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_QoSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_QoSInformation, QoSInformation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_ULUEConfiguration_vals[] = {
  {   0, "no-data" },
  {   1, "shared" },
  {   2, "only" },
  { 0, NULL }
};


static int
dissect_f1ap_ULUEConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ULConfiguration_sequence[] = {
  { &hf_f1ap_uLUEConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUEConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ULConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ULConfiguration, ULConfiguration_sequence);

  return offset;
}


static const per_sequence_t DRBs_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_qoSInformation , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_QoSInformation },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_uLConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ULConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeModified_Item, DRBs_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeReleased_Item, DRBs_ToBeReleased_Item_sequence);

  return offset;
}


static const value_string f1ap_DuplicationActivation_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_f1ap_DuplicationActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DRBs_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_qoSInformation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSInformation },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_rLCMode        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_uLConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ULConfiguration },
  { &hf_f1ap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DuplicationActivation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeSetup_Item, DRBs_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_qoSInformation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSInformation },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_rLCMode        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_uLConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ULConfiguration },
  { &hf_f1ap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DuplicationActivation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeSetupMod_Item, DRBs_ToBeSetupMod_Item_sequence);

  return offset;
}


static const value_string f1ap_LongDRXCycleLength_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  {   2, "ms32" },
  {   3, "ms40" },
  {   4, "ms60" },
  {   5, "ms64" },
  {   6, "ms70" },
  {   7, "ms80" },
  {   8, "ms128" },
  {   9, "ms160" },
  {  10, "ms256" },
  {  11, "ms320" },
  {  12, "ms512" },
  {  13, "ms640" },
  {  14, "ms1024" },
  {  15, "ms1280" },
  {  16, "ms2048" },
  {  17, "ms2560" },
  {  18, "ms5120" },
  {  19, "ms10240" },
  { 0, NULL }
};

static value_string_ext f1ap_LongDRXCycleLength_vals_ext = VALUE_STRING_EXT_INIT(f1ap_LongDRXCycleLength_vals);


static int
dissect_f1ap_LongDRXCycleLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     20, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_ShortDRXCycleLength_vals[] = {
  {   0, "ms2" },
  {   1, "ms3" },
  {   2, "ms4" },
  {   3, "ms5" },
  {   4, "ms6" },
  {   5, "ms7" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms14" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms30" },
  {  12, "ms32" },
  {  13, "ms35" },
  {  14, "ms40" },
  {  15, "ms64" },
  {  16, "ms80" },
  {  17, "ms128" },
  {  18, "ms160" },
  {  19, "ms256" },
  {  20, "ms320" },
  {  21, "ms512" },
  {  22, "ms640" },
  { 0, NULL }
};

static value_string_ext f1ap_ShortDRXCycleLength_vals_ext = VALUE_STRING_EXT_INIT(f1ap_ShortDRXCycleLength_vals);


static int
dissect_f1ap_ShortDRXCycleLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     23, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_ShortDRXCycleTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DRXCycle_sequence[] = {
  { &hf_f1ap_longDRXCycleLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LongDRXCycleLength },
  { &hf_f1ap_shortDRXCycleLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ShortDRXCycleLength },
  { &hf_f1ap_shortDRXCycleTimer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ShortDRXCycleTimer },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRXCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRXCycle, DRXCycle_sequence);

  return offset;
}



static int
dissect_f1ap_DRX_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1634 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_DRX_Config);
    dissect_nr_rrc_DRX_Config_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_DRXConfigurationIndicator_vals[] = {
  {   0, "release" },
  { 0, NULL }
};


static int
dissect_f1ap_DRXConfigurationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_DRX_LongCycleStartOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10239U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_DUtoCURRCContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1333 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_DUtoCURRCContainer);
    dissect_nr_rrc_CellGroupConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t DUCURIMInformation_sequence[] = {
  { &hf_f1ap_victimgNBSetID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBSetID },
  { &hf_f1ap_rIMRSDetectionStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RIMRSDetectionStatus },
  { &hf_f1ap_aggressorCellList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AggressorCellList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DUCURIMInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DUCURIMInformation, DUCURIMInformation_sequence);

  return offset;
}


static const value_string f1ap_DUCURadioInformationType_vals[] = {
  {   0, "rIM" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DUCURadioInformationType_choice[] = {
  {   0, &hf_f1ap_rIM_01         , ASN1_NO_EXTENSIONS     , dissect_f1ap_DUCURIMInformation },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DUCURadioInformationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DUCURadioInformationType, DUCURadioInformationType_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_MeasGapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1450 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MeasGapConfig);
    dissect_nr_rrc_MeasGapConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_T_requestedP_MaxFR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1466 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_requestedP_MaxFR1);
    dissect_nr_rrc_P_Max_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t DUtoCURRCInformation_sequence[] = {
  { &hf_f1ap_cellGroupConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CellGroupConfig },
  { &hf_f1ap_measGapConfig  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MeasGapConfig },
  { &hf_f1ap_requestedP_MaxFR1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_T_requestedP_MaxFR1 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DUtoCURRCInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DUtoCURRCInformation, DUtoCURRCInformation_sequence);

  return offset;
}


static const value_string f1ap_DuplicationIndication_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_DuplicationIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 1, NULL);

  return offset;
}


static const value_string f1ap_DuplicationState_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_f1ap_DuplicationState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_resourceType_vals[] = {
  {   0, "gbr" },
  {   1, "non-gbr" },
  {   2, "delay-critical-grb" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t DynamicPQIDescriptor_sequence[] = {
  { &hf_f1ap_resourceType   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_resourceType },
  { &hf_f1ap_qoSPriorityLevel_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_8_ },
  { &hf_f1ap_packetDelayBudget, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketDelayBudget },
  { &hf_f1ap_packetErrorRate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketErrorRate },
  { &hf_f1ap_averagingWindow, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AveragingWindow },
  { &hf_f1ap_maxDataBurstVolume, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MaxDataBurstVolume },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DynamicPQIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DynamicPQIDescriptor, DynamicPQIDescriptor_sequence);

  return offset;
}


static const per_sequence_t E_CID_MeasurementQuantities_sequence_of[1] = {
  { &hf_f1ap_E_CID_MeasurementQuantities_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_E_CID_MeasurementQuantities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_E_CID_MeasurementQuantities, E_CID_MeasurementQuantities_sequence_of,
                                                  1, maxnoofMeasE_CID, FALSE);

  return offset;
}


static const value_string f1ap_E_CID_MeasurementQuantitiesValue_vals[] = {
  {   0, "default" },
  {   1, "angleOfArrivalNR" },
  { 0, NULL }
};


static int
dissect_f1ap_E_CID_MeasurementQuantitiesValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t E_CID_MeasurementQuantities_Item_sequence[] = {
  { &hf_f1ap_e_CIDmeasurementQuantitiesValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_E_CID_MeasurementQuantitiesValue },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasurementQuantities_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CID_MeasurementQuantities_Item, E_CID_MeasurementQuantities_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_M2147483648_2147483647(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            G_MININT32, 2147483647U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_M64000_1280000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -64000, 1280000U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NGRANHighAccuracyAccessPointPosition_sequence[] = {
  { &hf_f1ap_latitude_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M2147483648_2147483647 },
  { &hf_f1ap_longitude_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M2147483648_2147483647 },
  { &hf_f1ap_altitude_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M64000_1280000 },
  { &hf_f1ap_uncertaintySemi_major_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_uncertaintySemi_minor_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_orientationOfMajorAxis, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_179 },
  { &hf_f1ap_horizontalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_uncertaintyAltitude_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_verticalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NGRANHighAccuracyAccessPointPosition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NGRANHighAccuracyAccessPointPosition, NGRANHighAccuracyAccessPointPosition_sequence);

  return offset;
}


static const value_string f1ap_TRPPositionDirectAccuracy_vals[] = {
  {   0, "tRPPosition" },
  {   1, "tRPHAposition" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPPositionDirectAccuracy_choice[] = {
  {   0, &hf_f1ap_tRPPosition    , ASN1_NO_EXTENSIONS     , dissect_f1ap_AccessPointPosition },
  {   1, &hf_f1ap_tRPHAposition  , ASN1_NO_EXTENSIONS     , dissect_f1ap_NGRANHighAccuracyAccessPointPosition },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPPositionDirectAccuracy(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPPositionDirectAccuracy, TRPPositionDirectAccuracy_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TRPPositionDirect_sequence[] = {
  { &hf_f1ap_accuracy       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPPositionDirectAccuracy },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPPositionDirect(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPPositionDirect, TRPPositionDirect_sequence);

  return offset;
}


static const value_string f1ap_ReferencePoint_vals[] = {
  {   0, "coordinateID" },
  {   1, "referencePointCoordinate" },
  {   2, "referencePointCoordinateHA" },
  {   3, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t ReferencePoint_choice[] = {
  {   0, &hf_f1ap_coordinateID   , ASN1_NO_EXTENSIONS     , dissect_f1ap_CoordinateID },
  {   1, &hf_f1ap_referencePointCoordinate, ASN1_NO_EXTENSIONS     , dissect_f1ap_AccessPointPosition },
  {   2, &hf_f1ap_referencePointCoordinateHA, ASN1_NO_EXTENSIONS     , dissect_f1ap_NGRANHighAccuracyAccessPointPosition },
  {   3, &hf_f1ap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ReferencePoint(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ReferencePoint, ReferencePoint_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_TRPReferencePointType_vals[] = {
  {   0, "tRPPositionRelativeGeodetic" },
  {   1, "tRPPositionRelativeCartesian" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPReferencePointType_choice[] = {
  {   0, &hf_f1ap_tRPPositionRelativeGeodetic, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeGeodeticLocation },
  {   1, &hf_f1ap_tRPPositionRelativeCartesian, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeCartesianLocation },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPReferencePointType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPReferencePointType, TRPReferencePointType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TRPPositionReferenced_sequence[] = {
  { &hf_f1ap_referencePoint , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ReferencePoint },
  { &hf_f1ap_referencePointType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPReferencePointType },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPPositionReferenced(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPPositionReferenced, TRPPositionReferenced_sequence);

  return offset;
}


static const value_string f1ap_TRPPositionDefinitionType_vals[] = {
  {   0, "direct" },
  {   1, "referenced" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPPositionDefinitionType_choice[] = {
  {   0, &hf_f1ap_direct         , ASN1_NO_EXTENSIONS     , dissect_f1ap_TRPPositionDirect },
  {   1, &hf_f1ap_referenced     , ASN1_NO_EXTENSIONS     , dissect_f1ap_TRPPositionReferenced },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPPositionDefinitionType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPPositionDefinitionType, TRPPositionDefinitionType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GeographicalCoordinates_sequence[] = {
  { &hf_f1ap_tRPPositionDefinitionType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPPositionDefinitionType },
  { &hf_f1ap_dLPRSResourceCoordinates, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_DLPRSResourceCoordinates },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GeographicalCoordinates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GeographicalCoordinates, GeographicalCoordinates_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3599(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3599U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1799(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1799U, NULL, FALSE);

  return offset;
}


static const per_sequence_t LCS_to_GCS_TranslationAoA_sequence[] = {
  { &hf_f1ap_alpha          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_beta           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_gamma          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LCS_to_GCS_TranslationAoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LCS_to_GCS_TranslationAoA, LCS_to_GCS_TranslationAoA_sequence);

  return offset;
}


static const per_sequence_t UL_AoA_sequence[] = {
  { &hf_f1ap_azimuthAoA     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_zenithAoA      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_1799 },
  { &hf_f1ap_lCS_to_GCS_TranslationAoA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_LCS_to_GCS_TranslationAoA },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_AoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_AoA, UL_AoA_sequence);

  return offset;
}


static const value_string f1ap_E_CID_MeasuredResults_Value_vals[] = {
  {   0, "valueAngleofArrivalNR" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t E_CID_MeasuredResults_Value_choice[] = {
  {   0, &hf_f1ap_valueAngleofArrivalNR, ASN1_NO_EXTENSIONS     , dissect_f1ap_UL_AoA },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasuredResults_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_E_CID_MeasuredResults_Value, E_CID_MeasuredResults_Value_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_CID_MeasuredResults_Item_sequence[] = {
  { &hf_f1ap_e_CID_MeasuredResults_Value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_E_CID_MeasuredResults_Value },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasuredResults_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CID_MeasuredResults_Item, E_CID_MeasuredResults_Item_sequence);

  return offset;
}


static const per_sequence_t E_CID_MeasuredResults_List_sequence_of[1] = {
  { &hf_f1ap_E_CID_MeasuredResults_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_E_CID_MeasuredResults_Item },
};

static int
dissect_f1ap_E_CID_MeasuredResults_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_E_CID_MeasuredResults_List, E_CID_MeasuredResults_List_sequence_of,
                                                  1, maxnoofMeasE_CID, FALSE);

  return offset;
}


static const per_sequence_t E_CID_MeasurementResult_sequence[] = {
  { &hf_f1ap_geographicalCoordinates, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_GeographicalCoordinates },
  { &hf_f1ap_measuredResults_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_E_CID_MeasuredResults_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasurementResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CID_MeasurementResult, E_CID_MeasurementResult_sequence);

  return offset;
}


static const value_string f1ap_E_CID_ReportCharacteristics_vals[] = {
  {   0, "onDemand" },
  {   1, "periodic" },
  { 0, NULL }
};


static int
dissect_f1ap_E_CID_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SliceSupportItem_sequence[] = {
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceSupportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceSupportItem, SliceSupportItem_sequence);

  return offset;
}


static const per_sequence_t SliceSupportList_sequence_of[1] = {
  { &hf_f1ap_SliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceSupportItem },
};

static int
dissect_f1ap_SliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SliceSupportList, SliceSupportList_sequence_of,
                                                  1, maxnoofSliceItems, FALSE);

  return offset;
}


static const per_sequence_t ExtendedServedPLMNs_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_tAISliceSupportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SliceSupportList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ExtendedServedPLMNs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ExtendedServedPLMNs_Item, ExtendedServedPLMNs_Item_sequence);

  return offset;
}


static const per_sequence_t ExtendedServedPLMNs_List_sequence_of[1] = {
  { &hf_f1ap_ExtendedServedPLMNs_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedServedPLMNs_Item },
};

static int
dissect_f1ap_ExtendedServedPLMNs_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ExtendedServedPLMNs_List, ExtendedServedPLMNs_List_sequence_of,
                                                  1, maxnoofExtendedBPLMNs, FALSE);

  return offset;
}


static const per_sequence_t ExtendedSliceSupportList_sequence_of[1] = {
  { &hf_f1ap_ExtendedSliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceSupportItem },
};

static int
dissect_f1ap_ExtendedSliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ExtendedSliceSupportList, ExtendedSliceSupportList_sequence_of,
                                                  1, maxnoofExtSliceItems, FALSE);

  return offset;
}



static int
dissect_f1ap_EUTRA_Cell_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_OffsetToPointA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, TRUE);

  return offset;
}


static const per_sequence_t EUTRA_FDD_Info_sequence[] = {
  { &hf_f1ap_uL_offsetToPointA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_OffsetToPointA },
  { &hf_f1ap_dL_offsetToPointA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_OffsetToPointA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_FDD_Info, EUTRA_FDD_Info_sequence);

  return offset;
}


static const per_sequence_t EUTRA_TDD_Info_sequence[] = {
  { &hf_f1ap_offsetToPointA , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_OffsetToPointA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_TDD_Info, EUTRA_TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_EUTRA_Mode_Info_vals[] = {
  {   0, "eUTRAFDD" },
  {   1, "eUTRATDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t EUTRA_Mode_Info_choice[] = {
  {   0, &hf_f1ap_eUTRAFDD       , ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRA_FDD_Info },
  {   1, &hf_f1ap_eUTRATDD       , ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRA_TDD_Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_EUTRA_Mode_Info, EUTRA_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_ProtectedEUTRAResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1584 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ProtectedEUTRAResourceIndication);
    dissect_x2ap_ProtectedEUTRAResourceIndication_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t Served_EUTRA_Cells_Information_sequence[] = {
  { &hf_f1ap_eUTRA_Mode_Info_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Mode_Info },
  { &hf_f1ap_protectedEUTRAResourceIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtectedEUTRAResourceIndication },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Served_EUTRA_Cells_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Served_EUTRA_Cells_Information, Served_EUTRA_Cells_Information_sequence);

  return offset;
}


static const per_sequence_t EUTRACells_List_item_sequence[] = {
  { &hf_f1ap_eUTRA_Cell_ID  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Cell_ID },
  { &hf_f1ap_served_EUTRA_Cells_Information, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Served_EUTRA_Cells_Information },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRACells_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRACells_List_item, EUTRACells_List_item_sequence);

  return offset;
}


static const per_sequence_t EUTRACells_List_sequence_of[1] = {
  { &hf_f1ap_EUTRACells_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRACells_List_item },
};

static int
dissect_f1ap_EUTRACells_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_EUTRACells_List, EUTRACells_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}



static int
dissect_f1ap_ExtendedEARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 262143U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_EUTRA_Transmission_Bandwidth_vals[] = {
  {   0, "bw6" },
  {   1, "bw15" },
  {   2, "bw25" },
  {   3, "bw50" },
  {   4, "bw75" },
  {   5, "bw100" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_Transmission_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_Coex_FDD_Info_sequence[] = {
  { &hf_f1ap_uL_EARFCN      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ExtendedEARFCN },
  { &hf_f1ap_dL_EARFCN      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedEARFCN },
  { &hf_f1ap_uL_Transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_EUTRA_Transmission_Bandwidth },
  { &hf_f1ap_dL_Transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Coex_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_Coex_FDD_Info, EUTRA_Coex_FDD_Info_sequence);

  return offset;
}


static const value_string f1ap_EUTRA_SubframeAssignment_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_SubframeAssignment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_EUTRA_SpecialSubframePatterns_vals[] = {
  {   0, "ssp0" },
  {   1, "ssp1" },
  {   2, "ssp2" },
  {   3, "ssp3" },
  {   4, "ssp4" },
  {   5, "ssp5" },
  {   6, "ssp6" },
  {   7, "ssp7" },
  {   8, "ssp8" },
  {   9, "ssp9" },
  {  10, "ssp10" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_SpecialSubframePatterns(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_EUTRA_CyclicPrefixDL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_CyclicPrefixDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_EUTRA_CyclicPrefixUL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_CyclicPrefixUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_SpecialSubframe_Info_sequence[] = {
  { &hf_f1ap_specialSubframePatterns, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_SpecialSubframePatterns },
  { &hf_f1ap_cyclicPrefixDL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_CyclicPrefixDL },
  { &hf_f1ap_cyclicPrefixUL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_CyclicPrefixUL },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_SpecialSubframe_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_SpecialSubframe_Info, EUTRA_SpecialSubframe_Info_sequence);

  return offset;
}


static const per_sequence_t EUTRA_Coex_TDD_Info_sequence[] = {
  { &hf_f1ap_eARFCN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedEARFCN },
  { &hf_f1ap_transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Transmission_Bandwidth },
  { &hf_f1ap_subframeAssignment, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_SubframeAssignment },
  { &hf_f1ap_specialSubframe_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_SpecialSubframe_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Coex_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_Coex_TDD_Info, EUTRA_Coex_TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_EUTRA_Coex_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  { 0, NULL }
};

static const per_choice_t EUTRA_Coex_Mode_Info_choice[] = {
  {   0, &hf_f1ap_fDD            , ASN1_EXTENSION_ROOT    , dissect_f1ap_EUTRA_Coex_FDD_Info },
  {   1, &hf_f1ap_tDD            , ASN1_EXTENSION_ROOT    , dissect_f1ap_EUTRA_Coex_TDD_Info },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Coex_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_EUTRA_Coex_Mode_Info, EUTRA_Coex_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_837(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 837U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_94(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 94U, NULL, FALSE);

  return offset;
}


static const per_sequence_t EUTRA_PRACH_Configuration_sequence[] = {
  { &hf_f1ap_rootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_837 },
  { &hf_f1ap_zeroCorrelationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_highSpeedFlag  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BOOLEAN },
  { &hf_f1ap_prach_FreqOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_94 },
  { &hf_f1ap_prach_ConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_PRACH_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_PRACH_Configuration, EUTRA_PRACH_Configuration_sequence);

  return offset;
}


static const value_string f1ap_ExecuteDuplication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_ExecuteDuplication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1198 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container);
    dissect_x2ap_EUTRANRCellResourceCoordinationRequest_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1206 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container);
    dissect_x2ap_EUTRANRCellResourceCoordinationResponse_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_EventType_vals[] = {
  {   0, "on-demand" },
  {   1, "periodic" },
  {   2, "stop" },
  { 0, NULL }
};


static int
dissect_f1ap_EventType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_ExtendedPacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_F1CPathNSA_vals[] = {
  {   0, "lte" },
  {   1, "nr" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_f1ap_F1CPathNSA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t F1CTransferPath_sequence[] = {
  { &hf_f1ap_f1CPathNSA     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_F1CPathNSA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1CTransferPath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1CTransferPath, F1CTransferPath_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_maxNRARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, FALSE);

  return offset;
}


static const value_string f1ap_NRSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  { 0, NULL }
};


static int
dissect_f1ap_NRSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_NRNRB_vals[] = {
  {   0, "nrb11" },
  {   1, "nrb18" },
  {   2, "nrb24" },
  {   3, "nrb25" },
  {   4, "nrb31" },
  {   5, "nrb32" },
  {   6, "nrb38" },
  {   7, "nrb51" },
  {   8, "nrb52" },
  {   9, "nrb65" },
  {  10, "nrb66" },
  {  11, "nrb78" },
  {  12, "nrb79" },
  {  13, "nrb93" },
  {  14, "nrb106" },
  {  15, "nrb107" },
  {  16, "nrb121" },
  {  17, "nrb132" },
  {  18, "nrb133" },
  {  19, "nrb135" },
  {  20, "nrb160" },
  {  21, "nrb162" },
  {  22, "nrb189" },
  {  23, "nrb216" },
  {  24, "nrb217" },
  {  25, "nrb245" },
  {  26, "nrb264" },
  {  27, "nrb270" },
  {  28, "nrb273" },
  { 0, NULL }
};

static value_string_ext f1ap_NRNRB_vals_ext = VALUE_STRING_EXT_INIT(f1ap_NRNRB_vals);


static int
dissect_f1ap_NRNRB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     29, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Transmission_Bandwidth_sequence[] = {
  { &hf_f1ap_nRSCS_01       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRSCS },
  { &hf_f1ap_nRNRB          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRNRB },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Transmission_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Transmission_Bandwidth, Transmission_Bandwidth_sequence);

  return offset;
}


static const per_sequence_t SUL_Information_sequence[] = {
  { &hf_f1ap_sUL_NRARFCN    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxNRARFCN },
  { &hf_f1ap_sUL_transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SUL_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SUL_Information, SUL_Information_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_1024_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SupportedSULFreqBandItem_sequence[] = {
  { &hf_f1ap_freqBandIndicatorNr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_1024_ },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SupportedSULFreqBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SupportedSULFreqBandItem, SupportedSULFreqBandItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem_sequence_of[1] = {
  { &hf_f1ap_supportedSULBandList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SupportedSULFreqBandItem },
};

static int
dissect_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem, SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem_sequence_of,
                                                  0, maxnoofNrCellBands, FALSE);

  return offset;
}


static const per_sequence_t FreqBandNrItem_sequence[] = {
  { &hf_f1ap_freqBandIndicatorNr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_1024_ },
  { &hf_f1ap_supportedSULBandList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FreqBandNrItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FreqBandNrItem, FreqBandNrItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem_sequence_of[1] = {
  { &hf_f1ap_freqBandListNr_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_FreqBandNrItem },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem, SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem_sequence_of,
                                                  1, maxnoofNrCellBands, FALSE);

  return offset;
}


static const per_sequence_t NRFreqInfo_sequence[] = {
  { &hf_f1ap_nRARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxNRARFCN },
  { &hf_f1ap_sul_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SUL_Information },
  { &hf_f1ap_freqBandListNr , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRFreqInfo, NRFreqInfo_sequence);

  return offset;
}


static const per_sequence_t FDD_Info_sequence[] = {
  { &hf_f1ap_uL_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_dL_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_uL_Transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_dL_Transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FDD_Info, FDD_Info_sequence);

  return offset;
}


static const value_string f1ap_T_restrictedSetConfig_vals[] = {
  {   0, "unrestrictedSet" },
  {   1, "restrictedSetTypeA" },
  {   2, "restrictedSetTypeB" },
  { 0, NULL }
};


static int
dissect_f1ap_T_restrictedSetConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t L839Info_sequence[] = {
  { &hf_f1ap_rootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_837 },
  { &hf_f1ap_restrictedSetConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_restrictedSetConfig },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_L839Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_L839Info, L839Info_sequence);

  return offset;
}


static const value_string f1ap_T_msg1SCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  { 0, NULL }
};


static int
dissect_f1ap_T_msg1SCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_137(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 137U, NULL, FALSE);

  return offset;
}


static const per_sequence_t L139Info_sequence[] = {
  { &hf_f1ap_msg1SCS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_msg1SCS },
  { &hf_f1ap_rootSequenceIndex_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_137 },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_L139Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_L139Info, L139Info_sequence);

  return offset;
}


static const value_string f1ap_FreqDomainLength_vals[] = {
  {   0, "l839" },
  {   1, "l139" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t FreqDomainLength_choice[] = {
  {   0, &hf_f1ap_l839           , ASN1_NO_EXTENSIONS     , dissect_f1ap_L839Info },
  {   1, &hf_f1ap_l139           , ASN1_NO_EXTENSIONS     , dissect_f1ap_L139Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_FreqDomainLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_FreqDomainLength, FreqDomainLength_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_FrequencyShift7p5khz_vals[] = {
  {   0, "false" },
  {   1, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_FrequencyShift7p5khz(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_FullConfiguration_vals[] = {
  {   0, "full" },
  { 0, NULL }
};


static int
dissect_f1ap_FullConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_PC5QoSFlowIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 2048U, NULL, FALSE);

  return offset;
}


static const per_sequence_t FlowsMappedToSLDRB_Item_sequence[] = {
  { &hf_f1ap_pc5QoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PC5QoSFlowIdentifier },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FlowsMappedToSLDRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FlowsMappedToSLDRB_Item, FlowsMappedToSLDRB_Item_sequence);

  return offset;
}


static const per_sequence_t FlowsMappedToSLDRB_List_sequence_of[1] = {
  { &hf_f1ap_FlowsMappedToSLDRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_FlowsMappedToSLDRB_Item },
};

static int
dissect_f1ap_FlowsMappedToSLDRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_FlowsMappedToSLDRB_List, FlowsMappedToSLDRB_List_sequence_of,
                                                  1, maxnoofPC5QoSFlows, FALSE);

  return offset;
}



static int
dissect_f1ap_CG_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1394 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_CG_Config);
    dissect_nr_rrc_CG_Config_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_GNBCUMeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_GNBDUMeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_T_sIBtype(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1492 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 32U, &f1ap_data->sib_type, TRUE);




  return offset;
}



static int
dissect_f1ap_T_sIBmessage_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1496 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sIBmessage);
    switch (f1ap_data->sib_type) {
    case 2:
      dissect_nr_rrc_SIB2_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 3:
      dissect_nr_rrc_SIB3_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 4:
      dissect_nr_rrc_SIB4_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 5:
      dissect_nr_rrc_SIB5_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 6:
      dissect_nr_rrc_SIB6_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 7:
      dissect_nr_rrc_SIB7_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 8:
      dissect_nr_rrc_SIB8_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 9:
      dissect_nr_rrc_SIB9_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 10:
      dissect_nr_rrc_SIB10_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 11:
      dissect_nr_rrc_SIB11_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 12:
      dissect_nr_rrc_SIB12_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 13:
      dissect_nr_rrc_SIB13_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 14:
      dissect_nr_rrc_SIB14_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }



  return offset;
}



static int
dissect_f1ap_INTEGER_0_31_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SibtypetobeupdatedListItem_sequence[] = {
  { &hf_f1ap_sIBtype_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sIBtype },
  { &hf_f1ap_sIBmessage_01  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sIBmessage_01 },
  { &hf_f1ap_valueTag       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_31_ },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SibtypetobeupdatedListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SibtypetobeupdatedListItem, SibtypetobeupdatedListItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem_sequence_of[1] = {
  { &hf_f1ap_sibtypetobeupdatedlist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SibtypetobeupdatedListItem },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem, SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem_sequence_of,
                                                  1, maxnoofSIBTypes, FALSE);

  return offset;
}


static const per_sequence_t GNB_CUSystemInformation_sequence[] = {
  { &hf_f1ap_sibtypetobeupdatedlist, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CUSystemInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CUSystemInformation, GNB_CUSystemInformation_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_Setup_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_Setup_Item, GNB_CU_TNL_Association_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_Failed_To_Setup_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item, GNB_CU_TNL_Association_Failed_To_Setup_Item_sequence);

  return offset;
}


static const value_string f1ap_TNLAssociationUsage_vals[] = {
  {   0, "ue" },
  {   1, "non-ue" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_f1ap_TNLAssociationUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Add_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TNLAssociationUsage },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Add_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_To_Add_Item, GNB_CU_TNL_Association_To_Add_Item_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Remove_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_To_Remove_Item, GNB_CU_TNL_Association_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Update_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TNLAssociationUsage },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Update_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_To_Update_Item, GNB_CU_TNL_Association_To_Update_Item_sequence);

  return offset;
}



static int
dissect_f1ap_GNB_DU_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(68719476735), NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_GNB_CU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_PrintableString(tvb, offset, actx, tree, hf_index,
                                          1, 150, TRUE);

  return offset;
}



static int
dissect_f1ap_GNB_DU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_PrintableString(tvb, offset, actx, tree, hf_index,
                                          1, 150, TRUE);

  return offset;
}



static int
dissect_f1ap_GNB_CU_NameVisibleString(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 150, TRUE);

  return offset;
}



static int
dissect_f1ap_GNB_CU_NameUTF8String(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 150, TRUE);

  return offset;
}


static const per_sequence_t Extended_GNB_CU_Name_sequence[] = {
  { &hf_f1ap_gNB_CU_NameVisibleString, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_CU_NameVisibleString },
  { &hf_f1ap_gNB_CU_NameUTF8String, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_CU_NameUTF8String },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Extended_GNB_CU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Extended_GNB_CU_Name, Extended_GNB_CU_Name_sequence);

  return offset;
}



static int
dissect_f1ap_GNB_DU_NameVisibleString(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 150, TRUE);

  return offset;
}



static int
dissect_f1ap_GNB_DU_NameUTF8String(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 150, TRUE);

  return offset;
}


static const per_sequence_t Extended_GNB_DU_Name_sequence[] = {
  { &hf_f1ap_gNB_DU_NameVisibleString, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_NameVisibleString },
  { &hf_f1ap_gNB_DU_NameUTF8String, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_NameUTF8String },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Extended_GNB_DU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Extended_GNB_DU_Name, Extended_GNB_DU_Name_sequence);

  return offset;
}



static int
dissect_f1ap_Configured_EPS_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1485 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t TDD_Info_sequence[] = {
  { &hf_f1ap_nRFreqInfo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TDD_Info, TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_NR_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NR_Mode_Info_choice[] = {
  {   0, &hf_f1ap_fDD_02         , ASN1_NO_EXTENSIONS     , dissect_f1ap_FDD_Info },
  {   1, &hf_f1ap_tDD_02         , ASN1_NO_EXTENSIONS     , dissect_f1ap_TDD_Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_NR_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_NR_Mode_Info, NR_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_T_measurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1341 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t Served_Cell_Information_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_nRPCI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPCI },
  { &hf_f1ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveGS_TAC },
  { &hf_f1ap_configured_EPS_TAC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Configured_EPS_TAC },
  { &hf_f1ap_servedPLMNs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ServedPLMNs_List },
  { &hf_f1ap_nR_Mode_Info   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NR_Mode_Info },
  { &hf_f1ap_measurementTimingConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_measurementTimingConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Served_Cell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Served_Cell_Information, Served_Cell_Information_sequence);

  return offset;
}



static int
dissect_f1ap_MIB_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1375 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MIB_message);
    dissect_nr_rrc_MIB_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_SIB1_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1383 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SIB1_message);
    dissect_nr_rrc_SIB1_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t GNB_DU_System_Information_sequence[] = {
  { &hf_f1ap_mIB_message    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MIB_message },
  { &hf_f1ap_sIB1_message   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SIB1_message },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_System_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_System_Information, GNB_DU_System_Information_sequence);

  return offset;
}


static const per_sequence_t GNB_DU_Served_Cells_Item_sequence[] = {
  { &hf_f1ap_served_Cell_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Served_Cell_Information },
  { &hf_f1ap_gNB_DU_System_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_System_Information },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_Served_Cells_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_Served_Cells_Item, GNB_DU_Served_Cells_Item_sequence);

  return offset;
}


static const value_string f1ap_GNB_DUConfigurationQuery_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_GNB_DUConfigurationQuery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_GNBDUOverloadInformation_vals[] = {
  {   0, "overloaded" },
  {   1, "not-overloaded" },
  { 0, NULL }
};


static int
dissect_f1ap_GNBDUOverloadInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNB_DU_TNL_Association_To_Remove_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_tNLAssociationTransportLayerAddressgNBCU, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_TNL_Association_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_TNL_Association_To_Remove_Item, GNB_DU_TNL_Association_To_Remove_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1970049(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1970049U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_985025(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 985025U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_492513(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 492513U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_246257(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 246257U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_123129(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 123129U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_61565(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 61565U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_GNBRxTxTimeDiffMeas_vals[] = {
  {   0, "k0" },
  {   1, "k1" },
  {   2, "k2" },
  {   3, "k3" },
  {   4, "k4" },
  {   5, "k5" },
  {   6, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t GNBRxTxTimeDiffMeas_choice[] = {
  {   0, &hf_f1ap_k0             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_1970049 },
  {   1, &hf_f1ap_k1             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_985025 },
  {   2, &hf_f1ap_k2             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_492513 },
  {   3, &hf_f1ap_k3             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_246257 },
  {   4, &hf_f1ap_k4             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_123129 },
  {   5, &hf_f1ap_k5             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_61565 },
  {   6, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_GNBRxTxTimeDiffMeas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_GNBRxTxTimeDiffMeas, GNBRxTxTimeDiffMeas_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNB_RxTxTimeDiff_sequence[] = {
  { &hf_f1ap_rxTxTimeDiff   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBRxTxTimeDiffMeas },
  { &hf_f1ap_additionalPath_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AdditionalPath_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_RxTxTimeDiff(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_RxTxTimeDiff, GNB_RxTxTimeDiff_sequence);

  return offset;
}


static const per_sequence_t GTPTLA_Item_sequence[] = {
  { &hf_f1ap_gTPTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GTPTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GTPTLA_Item, GTPTLA_Item_sequence);

  return offset;
}


static const per_sequence_t GTPTLAs_sequence_of[1] = {
  { &hf_f1ap_GTPTLAs_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GTPTLA_Item },
};

static int
dissect_f1ap_GTPTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GTPTLAs, GTPTLAs_sequence_of,
                                                  1, maxnoofGTPTLAs, FALSE);

  return offset;
}



static int
dissect_f1ap_HandoverPreparationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1426 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_HandoverPreparationInformation);
    dissect_nr_rrc_HandoverPreparationInformation_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_INTEGER_0_100_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, TRUE);

  return offset;
}


static const per_sequence_t HardwareLoadIndicator_sequence[] = {
  { &hf_f1ap_dLHardwareLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100_ },
  { &hf_f1ap_uLHardwareLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100_ },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_HardwareLoadIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_HardwareLoadIndicator, HardwareLoadIndicator_sequence);

  return offset;
}


static const value_string f1ap_IAB_Barred_vals[] = {
  {   0, "barred" },
  {   1, "not-barred" },
  { 0, NULL }
};


static int
dissect_f1ap_IAB_Barred(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t IAB_Info_IAB_donor_CU_sequence[] = {
  { &hf_f1ap_iAB_STC_Info   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_STC_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_Info_IAB_donor_CU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_Info_IAB_donor_CU, IAB_Info_IAB_donor_CU_sequence);

  return offset;
}


static const per_sequence_t IAB_Info_IAB_DU_sequence[] = {
  { &hf_f1ap_multiplexingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MultiplexingInfo },
  { &hf_f1ap_iAB_STC_Info   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_STC_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_Info_IAB_DU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_Info_IAB_DU, IAB_Info_IAB_DU_sequence);

  return offset;
}


static const value_string f1ap_IABTNLAddressUsage_vals[] = {
  {   0, "f1-c" },
  {   1, "f1-u" },
  {   2, "non-f1" },
  { 0, NULL }
};


static int
dissect_f1ap_IABTNLAddressUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t IAB_Allocated_TNL_Address_Item_sequence[] = {
  { &hf_f1ap_iABTNLAddress  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress },
  { &hf_f1ap_iABTNLAddressUsage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IABTNLAddressUsage },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_Allocated_TNL_Address_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_Allocated_TNL_Address_Item, IAB_Allocated_TNL_Address_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const per_sequence_t IABTNLAddressesRequested_sequence[] = {
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedAllTraffic, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedF1_C, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedF1_U, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedNoNF1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddressesRequested(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABTNLAddressesRequested, IABTNLAddressesRequested_sequence);

  return offset;
}


static const value_string f1ap_IABIPv6RequestType_vals[] = {
  {   0, "iPv6Address" },
  {   1, "iPv6Prefix" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABIPv6RequestType_choice[] = {
  {   0, &hf_f1ap_iPv6Address    , ASN1_NO_EXTENSIONS     , dissect_f1ap_IABTNLAddressesRequested },
  {   1, &hf_f1ap_iPv6Prefix     , ASN1_NO_EXTENSIONS     , dissect_f1ap_IABTNLAddressesRequested },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_IABIPv6RequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_IABIPv6RequestType, IABIPv6RequestType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IAB_TNL_Addresses_To_Remove_Item_sequence[] = {
  { &hf_f1ap_iABTNLAddress  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_TNL_Addresses_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_TNL_Addresses_To_Remove_Item, IAB_TNL_Addresses_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t IABv4AddressesRequested_sequence[] = {
  { &hf_f1ap_iABv4AddressesRequested, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddressesRequested },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABv4AddressesRequested(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABv4AddressesRequested, IABv4AddressesRequested_sequence);

  return offset;
}


static const value_string f1ap_IgnorePRACHConfiguration_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_IgnorePRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_IgnoreResourceCoordinationContainer_vals[] = {
  {   0, "yes" },
  { 0, NULL }
};


static int
dissect_f1ap_IgnoreResourceCoordinationContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_InactivityMonitoringRequest_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_InactivityMonitoringRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_InactivityMonitoringResponse_vals[] = {
  {   0, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_InactivityMonitoringResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_InterfacesToTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1777 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &param_tvb, NULL);

  if(param_tvb){
    static int * const fields[] = {
      &hf_f1ap_interfacesToTrace_NG_C,
      &hf_f1ap_interfacesToTrace_Xn_C,
      &hf_f1ap_interfacesToTrace_Uu,
      &hf_f1ap_interfacesToTrace_F1_C,
      &hf_f1ap_interfacesToTrace_E1,
      &hf_f1ap_interfacesToTrace_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_InterfacesToTrace);
    proto_tree_add_bitmask_list(subtree, param_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const value_string f1ap_T_nRSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nRSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_nRCP_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nRCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_nRDLULTxPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms3" },
  {   7, "ms4" },
  {   8, "ms5" },
  {   9, "ms10" },
  {  10, "ms20" },
  {  11, "ms40" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms120" },
  {  16, "ms140" },
  {  17, "ms160" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nRDLULTxPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_5119_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5119U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_13_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, TRUE);

  return offset;
}


static const per_sequence_t NumDLULSymbols_sequence[] = {
  { &hf_f1ap_numDLSymbols   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13_ },
  { &hf_f1ap_numULSymbols   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NumDLULSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NumDLULSymbols, NumDLULSymbols_sequence);

  return offset;
}


static const value_string f1ap_SymbolAllocInSlot_vals[] = {
  {   0, "all-DL" },
  {   1, "all-UL" },
  {   2, "both-DL-and-UL" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SymbolAllocInSlot_choice[] = {
  {   0, &hf_f1ap_all_DL         , ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   1, &hf_f1ap_all_UL         , ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_both_DL_and_UL , ASN1_NO_EXTENSIONS     , dissect_f1ap_NumDLULSymbols },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SymbolAllocInSlot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SymbolAllocInSlot, SymbolAllocInSlot_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Slot_Configuration_Item_sequence[] = {
  { &hf_f1ap_slotIndex      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_5119_ },
  { &hf_f1ap_symbolAllocInSlot, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SymbolAllocInSlot },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Slot_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Slot_Configuration_Item, Slot_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t Slot_Configuration_List_sequence_of[1] = {
  { &hf_f1ap_Slot_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Slot_Configuration_Item },
};

static int
dissect_f1ap_Slot_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Slot_Configuration_List, Slot_Configuration_List_sequence_of,
                                                  1, maxnoofslots, FALSE);

  return offset;
}


static const per_sequence_t IntendedTDD_DL_ULConfig_sequence[] = {
  { &hf_f1ap_nRSCS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nRSCS },
  { &hf_f1ap_nRCP           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nRCP },
  { &hf_f1ap_nRDLULTxPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nRDLULTxPeriodicity },
  { &hf_f1ap_slot_Configuration_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Slot_Configuration_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IntendedTDD_DL_ULConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IntendedTDD_DL_ULConfig, IntendedTDD_DL_ULConfig_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_359(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 359U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}


static const per_sequence_t LCStoGCSTranslation_sequence[] = {
  { &hf_f1ap_alpha_01       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_359 },
  { &hf_f1ap_alpha_fine     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_beta_01        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_359 },
  { &hf_f1ap_beta_fine      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_gamma_01       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_359 },
  { &hf_f1ap_gamma_fine     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LCStoGCSTranslation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LCStoGCSTranslation, LCStoGCSTranslation_sequence);

  return offset;
}


static const per_sequence_t LCStoGCSTranslationList_sequence_of[1] = {
  { &hf_f1ap_LCStoGCSTranslationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LCStoGCSTranslation },
};

static int
dissect_f1ap_LCStoGCSTranslationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LCStoGCSTranslationList, LCStoGCSTranslationList_sequence_of,
                                                  1, maxnooflcs_gcs_translation, FALSE);

  return offset;
}



static int
dissect_f1ap_LMF_MeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65536U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_LMF_UE_MeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_LowerLayerPresenceStatusChange_vals[] = {
  {   0, "suspend-lower-layers" },
  {   1, "resume-lower-layers" },
  { 0, NULL }
};


static int
dissect_f1ap_LowerLayerPresenceStatusChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t LTEUESidelinkAggregateMaximumBitrate_sequence[] = {
  { &hf_f1ap_uELTESidelinkAggregateMaximumBitrate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTEUESidelinkAggregateMaximumBitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTEUESidelinkAggregateMaximumBitrate, LTEUESidelinkAggregateMaximumBitrate_sequence);

  return offset;
}


static const value_string f1ap_VehicleUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_VehicleUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_PedestrianUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_PedestrianUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t LTEV2XServicesAuthorized_sequence[] = {
  { &hf_f1ap_vehicleUE      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_VehicleUE },
  { &hf_f1ap_pedestrianUE   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PedestrianUE },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTEV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTEV2XServicesAuthorized, LTEV2XServicesAuthorized_sequence);

  return offset;
}



static int
dissect_f1ap_MaskedIMEISV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_MeasGapSharingConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1458 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MeasGapSharingConfig);
    dissect_nr_rrc_MeasGapSharingConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_MeasurementBeamInfoRequest_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_MeasurementBeamInfoRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MeasurementBeamInfo_sequence[] = {
  { &hf_f1ap_pRS_Resource_ID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PRS_Resource_ID },
  { &hf_f1ap_pRS_Resource_Set_ID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_sSB_Index      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSB_Index },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MeasurementBeamInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MeasurementBeamInfo, MeasurementBeamInfo_sequence);

  return offset;
}



static int
dissect_f1ap_MeasurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1442 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_MessageIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_M2Configuration_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_M2Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_M5period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_f1ap_M5period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_M5_Links_to_log_vals[] = {
  {   0, "uplink" },
  {   1, "downlink" },
  {   2, "both-uplink-and-downlink" },
  { 0, NULL }
};


static int
dissect_f1ap_M5_Links_to_log(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M5Configuration_sequence[] = {
  { &hf_f1ap_m5period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_M5period },
  { &hf_f1ap_m5_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_M5_Links_to_log },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_M5Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_M5Configuration, M5Configuration_sequence);

  return offset;
}


static const value_string f1ap_M6report_Interval_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms640" },
  {   3, "ms1024" },
  {   4, "ms2048" },
  {   5, "ms5120" },
  {   6, "ms10240" },
  {   7, "ms20480" },
  {   8, "ms40960" },
  {   9, "min1" },
  {  10, "min6" },
  {  11, "min12" },
  {  12, "min30" },
  { 0, NULL }
};


static int
dissect_f1ap_M6report_Interval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_M6_Links_to_log_vals[] = {
  {   0, "uplink" },
  {   1, "downlink" },
  {   2, "both-uplink-and-downlink" },
  { 0, NULL }
};


static int
dissect_f1ap_M6_Links_to_log(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M6Configuration_sequence[] = {
  { &hf_f1ap_m6report_Interval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_M6report_Interval },
  { &hf_f1ap_m6_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_M6_Links_to_log },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_M6Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_M6Configuration, M6Configuration_sequence);

  return offset;
}



static int
dissect_f1ap_M7period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 60U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_M7_Links_to_log_vals[] = {
  {   0, "downlink" },
  { 0, NULL }
};


static int
dissect_f1ap_M7_Links_to_log(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M7Configuration_sequence[] = {
  { &hf_f1ap_m7period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_M7period },
  { &hf_f1ap_m7_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_M7_Links_to_log },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_M7Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_M7Configuration, M7Configuration_sequence);

  return offset;
}


static const value_string f1ap_MDT_Activation_vals[] = {
  {   0, "immediate-MDT-only" },
  {   1, "immediate-MDT-and-Trace" },
  { 0, NULL }
};


static int
dissect_f1ap_MDT_Activation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_MeasurementsToActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1797 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    static int * const fields[] = {
      &hf_f1ap_MeasurementsToActivate_Reserved1,
      &hf_f1ap_MeasurementsToActivate_M2,
      &hf_f1ap_MeasurementsToActivate_Reserved2,
      &hf_f1ap_MeasurementsToActivate_M5,
      &hf_f1ap_MeasurementsToActivate_Reserved3,
      &hf_f1ap_MeasurementsToActivate_M6,
      &hf_f1ap_MeasurementsToActivate_M7,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MeasurementsToActivate);
    proto_tree_add_bitmask_list(subtree, param_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const per_sequence_t MDTConfiguration_sequence[] = {
  { &hf_f1ap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MDT_Activation },
  { &hf_f1ap_measurementsToActivate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MeasurementsToActivate },
  { &hf_f1ap_m2Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_M2Configuration },
  { &hf_f1ap_m5Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_M5Configuration },
  { &hf_f1ap_m6Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_M6Configuration },
  { &hf_f1ap_m7Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_M7Configuration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MDTConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MDTConfiguration, MDTConfiguration_sequence);

  return offset;
}


static const per_sequence_t MDTPLMNList_sequence_of[1] = {
  { &hf_f1ap_MDTPLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
};

static int
dissect_f1ap_MDTPLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MDTPLMNList, MDTPLMNList_sequence_of,
                                                  1, maxnoofMDTPLMNs, FALSE);

  return offset;
}



static int
dissect_f1ap_UL_SRS_RSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 126U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_UL_RTOA_MeasurementItem_vals[] = {
  {   0, "k0" },
  {   1, "k1" },
  {   2, "k2" },
  {   3, "k3" },
  {   4, "k4" },
  {   5, "k5" },
  {   6, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UL_RTOA_MeasurementItem_choice[] = {
  {   0, &hf_f1ap_k0             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_1970049 },
  {   1, &hf_f1ap_k1             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_985025 },
  {   2, &hf_f1ap_k2             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_492513 },
  {   3, &hf_f1ap_k3             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_246257 },
  {   4, &hf_f1ap_k4             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_123129 },
  {   5, &hf_f1ap_k5             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_61565 },
  {   6, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_UL_RTOA_MeasurementItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_UL_RTOA_MeasurementItem, UL_RTOA_MeasurementItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UL_RTOA_Measurement_sequence[] = {
  { &hf_f1ap_uL_RTOA_MeasurementItem, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UL_RTOA_MeasurementItem },
  { &hf_f1ap_additionalPath_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AdditionalPath_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_RTOA_Measurement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_RTOA_Measurement, UL_RTOA_Measurement_sequence);

  return offset;
}


static const value_string f1ap_MeasuredResultsValue_vals[] = {
  {   0, "uL-AngleOfArrival" },
  {   1, "uL-SRS-RSRP" },
  {   2, "uL-RTOA" },
  {   3, "gNB-RxTxTimeDiff" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MeasuredResultsValue_choice[] = {
  {   0, &hf_f1ap_uL_AngleOfArrival, ASN1_NO_EXTENSIONS     , dissect_f1ap_UL_AoA },
  {   1, &hf_f1ap_uL_SRS_RSRP    , ASN1_NO_EXTENSIONS     , dissect_f1ap_UL_SRS_RSRP },
  {   2, &hf_f1ap_uL_RTOA        , ASN1_NO_EXTENSIONS     , dissect_f1ap_UL_RTOA_Measurement },
  {   3, &hf_f1ap_gNB_RxTxTimeDiff, ASN1_NO_EXTENSIONS     , dissect_f1ap_GNB_RxTxTimeDiff },
  {   4, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_MeasuredResultsValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_MeasuredResultsValue, MeasuredResultsValue_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_NeedforGap_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_NeedforGap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Neighbour_Cell_Information_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_intendedTDD_DL_ULConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IntendedTDD_DL_ULConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Neighbour_Cell_Information_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Neighbour_Cell_Information_Item, Neighbour_Cell_Information_Item_sequence);

  return offset;
}


static const per_sequence_t NR_CGI_List_For_Restart_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NR_CGI_List_For_Restart_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NR_CGI_List_For_Restart_Item, NR_CGI_List_For_Restart_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_180(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 180U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PRSAngleItem_sequence[] = {
  { &hf_f1ap_nR_PRS_Azimuth , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_359 },
  { &hf_f1ap_nR_PRS_Azimuth_fine, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_nR_PRS_Elevation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_180 },
  { &hf_f1ap_nR_PRS_Elevation_fine, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSAngleItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSAngleItem, PRSAngleItem_sequence);

  return offset;
}


static const per_sequence_t PRSAngleList_sequence_of[1] = {
  { &hf_f1ap_PRSAngleList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSAngleItem },
};

static int
dissect_f1ap_PRSAngleList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PRSAngleList, PRSAngleList_sequence_of,
                                                  1, maxnoofPRS_ResourcesPerSet, FALSE);

  return offset;
}


static const per_sequence_t NR_PRSBeamInformationItem_sequence[] = {
  { &hf_f1ap_pRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_pRSAngleList   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSAngleList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NR_PRSBeamInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NR_PRSBeamInformationItem, NR_PRSBeamInformationItem_sequence);

  return offset;
}


static const per_sequence_t NR_PRSBeamInformationList_sequence_of[1] = {
  { &hf_f1ap_NR_PRSBeamInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NR_PRSBeamInformationItem },
};

static int
dissect_f1ap_NR_PRSBeamInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NR_PRSBeamInformationList, NR_PRSBeamInformationList_sequence_of,
                                                  1, maxnoofPRS_ResourceSets, FALSE);

  return offset;
}


static const per_sequence_t NR_PRSBeamInformation_sequence[] = {
  { &hf_f1ap_nR_PRSBeamInformationList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NR_PRSBeamInformationList },
  { &hf_f1ap_lCStoGCSTranslationList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_LCStoGCSTranslationList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NR_PRSBeamInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NR_PRSBeamInformation, NR_PRSBeamInformation_sequence);

  return offset;
}


static const per_sequence_t NonDynamicPQIDescriptor_sequence[] = {
  { &hf_f1ap_fiveQI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255_ },
  { &hf_f1ap_qoSPriorityLevel_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_8_ },
  { &hf_f1ap_averagingWindow, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AveragingWindow },
  { &hf_f1ap_maxDataBurstVolume, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MaxDataBurstVolume },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NonDynamicPQIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NonDynamicPQIDescriptor, NonDynamicPQIDescriptor_sequence);

  return offset;
}


static const value_string f1ap_NonUPTrafficType_vals[] = {
  {   0, "ue-associated" },
  {   1, "non-ue-associated" },
  {   2, "non-f1" },
  {   3, "bap-control-pdu" },
  { 0, NULL }
};


static int
dissect_f1ap_NonUPTrafficType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_SerialNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t NotificationInformation_sequence[] = {
  { &hf_f1ap_message_Identifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MessageIdentifier },
  { &hf_f1ap_serialNumber   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SerialNumber },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NotificationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NotificationInformation, NotificationInformation_sequence);

  return offset;
}


static const per_sequence_t NPN_Broadcast_Information_SNPN_sequence[] = {
  { &hf_f1ap_broadcastSNPNID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastSNPN_ID_List },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NPN_Broadcast_Information_SNPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NPN_Broadcast_Information_SNPN, NPN_Broadcast_Information_SNPN_sequence);

  return offset;
}


static const per_sequence_t NPN_Broadcast_Information_PNI_NPN_sequence[] = {
  { &hf_f1ap_broadcastPNI_NPN_ID_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastPNI_NPN_ID_List },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NPN_Broadcast_Information_PNI_NPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NPN_Broadcast_Information_PNI_NPN, NPN_Broadcast_Information_PNI_NPN_sequence);

  return offset;
}


static const value_string f1ap_NPNBroadcastInformation_vals[] = {
  {   0, "sNPN-Broadcast-Information" },
  {   1, "pNI-NPN-Broadcast-Information" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPNBroadcastInformation_choice[] = {
  {   0, &hf_f1ap_sNPN_Broadcast_Information, ASN1_NO_EXTENSIONS     , dissect_f1ap_NPN_Broadcast_Information_SNPN },
  {   1, &hf_f1ap_pNI_NPN_Broadcast_Information, ASN1_NO_EXTENSIONS     , dissect_f1ap_NPN_Broadcast_Information_PNI_NPN },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_NPNBroadcastInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_NPNBroadcastInformation, NPNBroadcastInformation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_NPNSupportInfo_vals[] = {
  {   0, "sNPN-Information" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPNSupportInfo_choice[] = {
  {   0, &hf_f1ap_sNPN_Information, ASN1_NO_EXTENSIONS     , dissect_f1ap_NID },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_NPNSupportInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_NPNSupportInfo, NPNSupportInfo_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_2199_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofPhysicalResourceBlocks, NULL, TRUE);

  return offset;
}


static const per_sequence_t NRCarrierItem_sequence[] = {
  { &hf_f1ap_carrierSCS     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRSCS },
  { &hf_f1ap_offsetToCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2199_ },
  { &hf_f1ap_carrierBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_ },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRCarrierItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRCarrierItem, NRCarrierItem_sequence);

  return offset;
}


static const per_sequence_t NRCarrierList_sequence_of[1] = {
  { &hf_f1ap_NRCarrierList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCarrierItem },
};

static int
dissect_f1ap_NRCarrierList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NRCarrierList, NRCarrierList_sequence_of,
                                                  1, maxnoofNRSCSs, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_1_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofPhysicalResourceBlocks_1, NULL, TRUE);

  return offset;
}


static const value_string f1ap_T_msg1FDM_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "four" },
  {   3, "eight" },
  { 0, NULL }
};


static int
dissect_f1ap_T_msg1FDM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_ssb_perRACH_Occasion_vals[] = {
  {   0, "oneEighth" },
  {   1, "oneFourth" },
  {   2, "oneHalf" },
  {   3, "one" },
  {   4, "two" },
  {   5, "four" },
  {   6, "eight" },
  {   7, "sixteen" },
  { 0, NULL }
};


static int
dissect_f1ap_T_ssb_perRACH_Occasion(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NRPRACHConfigItem_sequence[] = {
  { &hf_f1ap_nRSCS_01       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRSCS },
  { &hf_f1ap_prachFreqStartfromCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_1_ },
  { &hf_f1ap_msg1FDM        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_msg1FDM },
  { &hf_f1ap_parchConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255_ },
  { &hf_f1ap_ssb_perRACH_Occasion, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_ssb_perRACH_Occasion },
  { &hf_f1ap_freqDomainLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_FreqDomainLength },
  { &hf_f1ap_zeroCorrelZoneConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRPRACHConfigItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRPRACHConfigItem, NRPRACHConfigItem_sequence);

  return offset;
}


static const per_sequence_t NRPRACHConfigList_sequence_of[1] = {
  { &hf_f1ap_NRPRACHConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPRACHConfigItem },
};

static int
dissect_f1ap_NRPRACHConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NRPRACHConfigList, NRPRACHConfigList_sequence_of,
                                                  0, maxnoofPRACHconfigs, FALSE);

  return offset;
}


static const per_sequence_t NRPRACHConfig_sequence[] = {
  { &hf_f1ap_ulPRACHConfigList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPRACHConfigList },
  { &hf_f1ap_sulPRACHConfigList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPRACHConfigList },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRPRACHConfig, NRPRACHConfig_sequence);

  return offset;
}



static int
dissect_f1ap_NRUERLFReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1815 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_NRUERLFReportContainer);
    dissect_nr_rrc_nr_RLF_Report_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_NumberofBroadcastRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NRV2XServicesAuthorized_sequence[] = {
  { &hf_f1ap_vehicleUE      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_VehicleUE },
  { &hf_f1ap_pedestrianUE   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PedestrianUE },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRV2XServicesAuthorized, NRV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t NRUESidelinkAggregateMaximumBitrate_sequence[] = {
  { &hf_f1ap_uENRSidelinkAggregateMaximumBitrate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRUESidelinkAggregateMaximumBitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRUESidelinkAggregateMaximumBitrate, NRUESidelinkAggregateMaximumBitrate_sequence);

  return offset;
}



static int
dissect_f1ap_NZP_CSI_RS_ResourceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 191U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PagingCell_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PagingCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PagingCell_Item, PagingCell_Item_sequence);

  return offset;
}


static const value_string f1ap_PagingDRX_vals[] = {
  {   0, "v32" },
  {   1, "v64" },
  {   2, "v128" },
  {   3, "v256" },
  { 0, NULL }
};


static int
dissect_f1ap_PagingDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_40(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     40, 40, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t RANUEPagingIdentity_sequence[] = {
  { &hf_f1ap_iRNTI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BIT_STRING_SIZE_40 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RANUEPagingIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RANUEPagingIdentity, RANUEPagingIdentity_sequence);

  return offset;
}


static const value_string f1ap_PagingIdentity_vals[] = {
  {   0, "rANUEPagingIdentity" },
  {   1, "cNUEPagingIdentity" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PagingIdentity_choice[] = {
  {   0, &hf_f1ap_rANUEPagingIdentity, ASN1_NO_EXTENSIONS     , dissect_f1ap_RANUEPagingIdentity },
  {   1, &hf_f1ap_cNUEPagingIdentity, ASN1_NO_EXTENSIONS     , dissect_f1ap_CNUEPagingIdentity },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PagingIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PagingIdentity, PagingIdentity_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_PagingOrigin_vals[] = {
  {   0, "non-3gpp" },
  { 0, NULL }
};


static int
dissect_f1ap_PagingOrigin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_PagingPriority_vals[] = {
  {   0, "priolevel1" },
  {   1, "priolevel2" },
  {   2, "priolevel3" },
  {   3, "priolevel4" },
  {   4, "priolevel5" },
  {   5, "priolevel6" },
  {   6, "priolevel7" },
  {   7, "priolevel8" },
  { 0, NULL }
};


static int
dissect_f1ap_PagingPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_PathlossReferenceSignal_vals[] = {
  {   0, "sSB" },
  {   1, "dL-PRS" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PathlossReferenceSignal_choice[] = {
  {   0, &hf_f1ap_sSB            , ASN1_NO_EXTENSIONS     , dissect_f1ap_SSB },
  {   1, &hf_f1ap_dL_PRS         , ASN1_NO_EXTENSIONS     , dissect_f1ap_DL_PRS },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PathlossReferenceSignal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PathlossReferenceSignal, PathlossReferenceSignal_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PathlossReferenceInfo_sequence[] = {
  { &hf_f1ap_pathlossReferenceSignal, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PathlossReferenceSignal },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PathlossReferenceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PathlossReferenceInfo, PathlossReferenceInfo_sequence);

  return offset;
}


static const value_string f1ap_PC5_QoS_Characteristics_vals[] = {
  {   0, "non-Dynamic-PQI" },
  {   1, "dynamic-PQI" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PC5_QoS_Characteristics_choice[] = {
  {   0, &hf_f1ap_non_Dynamic_PQI, ASN1_NO_EXTENSIONS     , dissect_f1ap_NonDynamicPQIDescriptor },
  {   1, &hf_f1ap_dynamic_PQI    , ASN1_NO_EXTENSIONS     , dissect_f1ap_DynamicPQIDescriptor },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PC5_QoS_Characteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PC5_QoS_Characteristics, PC5_QoS_Characteristics_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PC5FlowBitRates_sequence[] = {
  { &hf_f1ap_guaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_maximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PC5FlowBitRates, PC5FlowBitRates_sequence);

  return offset;
}


static const per_sequence_t PC5QoSParameters_sequence[] = {
  { &hf_f1ap_pC5_QoS_Characteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PC5_QoS_Characteristics },
  { &hf_f1ap_pC5_QoS_Flow_Bit_Rates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_PC5FlowBitRates },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PC5QoSParameters, PC5QoSParameters_sequence);

  return offset;
}



static int
dissect_f1ap_PDCCH_BlindDetectionSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1642 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 1, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_f1ap_PDCP_SN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_PDCPSNLength_vals[] = {
  {   0, "twelve-bits" },
  {   1, "eighteen-bits" },
  { 0, NULL }
};


static int
dissect_f1ap_PDCPSNLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_PDUSessionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_ReportingPeriodicityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 512U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_Periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 640000U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_PeriodicitySRS_vals[] = {
  {   0, "ms0p125" },
  {   1, "ms0p25" },
  {   2, "ms0p5" },
  {   3, "ms0p625" },
  {   4, "ms1" },
  {   5, "ms1p25" },
  {   6, "ms2" },
  {   7, "ms2p5" },
  {   8, "ms4" },
  {   9, "ms5" },
  {  10, "ms8" },
  {  11, "ms10" },
  {  12, "ms16" },
  {  13, "ms20" },
  {  14, "ms32" },
  {  15, "ms40" },
  {  16, "ms64" },
  {  17, "ms80" },
  {  18, "ms160" },
  {  19, "ms320" },
  {  20, "ms640" },
  {  21, "ms1280" },
  {  22, "ms2560" },
  {  23, "ms5120" },
  {  24, "ms10240" },
  { 0, NULL }
};


static int
dissect_f1ap_PeriodicitySRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     25, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PeriodicityList_Item_sequence[] = {
  { &hf_f1ap_periodicitySRS , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PeriodicitySRS },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PeriodicityList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PeriodicityList_Item, PeriodicityList_Item_sequence);

  return offset;
}


static const per_sequence_t PeriodicityList_sequence_of[1] = {
  { &hf_f1ap_PeriodicityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PeriodicityList_Item },
};

static int
dissect_f1ap_PeriodicityList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PeriodicityList, PeriodicityList_sequence_of,
                                                  1, maxnoSRS_ResourcePerSet, FALSE);

  return offset;
}



static int
dissect_f1ap_Ph_InfoMCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1662 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_Ph_InfoMCG);
    dissect_nr_rrc_PH_TypeListMCG_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_Ph_InfoSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1670 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_Ph_InfoSCG);
    dissect_nr_rrc_PH_TypeListSCG_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_PortNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1368 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     16, 16, FALSE, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_f1ap_PosAssistance_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1944 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_PosAssistance_Information);
    dissect_nrppa_Assistance_Information_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_PosAssistanceInformationFailureList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1952 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_PosAssistance_Information);
    dissect_nrppa_Assistance_Information_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_PosBroadcast_vals[] = {
  {   0, "start" },
  {   1, "stop" },
  { 0, NULL }
};


static int
dissect_f1ap_PosBroadcast(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PositioningBroadcastCells_sequence_of[1] = {
  { &hf_f1ap_PositioningBroadcastCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
};

static int
dissect_f1ap_PositioningBroadcastCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PositioningBroadcastCells, PositioningBroadcastCells_sequence_of,
                                                  1, maxnoBcastCell, FALSE);

  return offset;
}


static const value_string f1ap_MeasurementPeriodicity_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "min1" },
  {   9, "min6" },
  {  10, "min12" },
  {  11, "min30" },
  {  12, "ms20480" },
  {  13, "ms40960" },
  { 0, NULL }
};


static int
dissect_f1ap_MeasurementPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, TRUE, 2, NULL);

  return offset;
}


static const value_string f1ap_PosMeasurementType_vals[] = {
  {   0, "gnb-rx-tx" },
  {   1, "ul-srs-rsrp" },
  {   2, "ul-aoa" },
  {   3, "ul-rtoa" },
  { 0, NULL }
};


static int
dissect_f1ap_PosMeasurementType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PosMeasurementQuantities_Item_sequence[] = {
  { &hf_f1ap_posMeasurementType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosMeasurementType },
  { &hf_f1ap_timingReportingGranularityFactor, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_5 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosMeasurementQuantities_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosMeasurementQuantities_Item, PosMeasurementQuantities_Item_sequence);

  return offset;
}


static const per_sequence_t PosMeasurementQuantities_sequence_of[1] = {
  { &hf_f1ap_PosMeasurementQuantities_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosMeasurementQuantities_Item },
};

static int
dissect_f1ap_PosMeasurementQuantities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosMeasurementQuantities, PosMeasurementQuantities_sequence_of,
                                                  1, maxnoofPosMeas, FALSE);

  return offset;
}



static int
dissect_f1ap_SystemFrameNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 39U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_79(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 79U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_TimeStampSlotIndex_vals[] = {
  {   0, "sCS-15" },
  {   1, "sCS-30" },
  {   2, "sCS-60" },
  {   3, "sCS-120" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TimeStampSlotIndex_choice[] = {
  {   0, &hf_f1ap_sCS_15         , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_9 },
  {   1, &hf_f1ap_sCS_30         , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_19 },
  {   2, &hf_f1ap_sCS_60         , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_39 },
  {   3, &hf_f1ap_sCS_120        , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_79 },
  {   4, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TimeStampSlotIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TimeStampSlotIndex, TimeStampSlotIndex_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_RelativeTime1900(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t TimeStamp_sequence[] = {
  { &hf_f1ap_systemFrameNumber, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SystemFrameNumber },
  { &hf_f1ap_slotIndex_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TimeStampSlotIndex },
  { &hf_f1ap_measurementTime, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RelativeTime1900 },
  { &hf_f1ap_iE_Extension   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TimeStamp, TimeStamp_sequence);

  return offset;
}


static const per_sequence_t PosMeasurementResultItem_sequence[] = {
  { &hf_f1ap_measuredResultsValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MeasuredResultsValue },
  { &hf_f1ap_timeStamp      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TimeStamp },
  { &hf_f1ap_measurementQuality, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TRPMeasurementQuality },
  { &hf_f1ap_measurementBeamInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MeasurementBeamInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosMeasurementResultItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosMeasurementResultItem, PosMeasurementResultItem_sequence);

  return offset;
}


static const per_sequence_t PosMeasurementResult_sequence_of[1] = {
  { &hf_f1ap_PosMeasurementResult_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosMeasurementResultItem },
};

static int
dissect_f1ap_PosMeasurementResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosMeasurementResult, PosMeasurementResult_sequence_of,
                                                  1, maxnoofPosMeas, FALSE);

  return offset;
}



static int
dissect_f1ap_TRPID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofTRPs, NULL, TRUE);

  return offset;
}


static const per_sequence_t PosMeasurementResultList_Item_sequence[] = {
  { &hf_f1ap_posMeasurementResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosMeasurementResult },
  { &hf_f1ap_tRPID          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosMeasurementResultList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosMeasurementResultList_Item, PosMeasurementResultList_Item_sequence);

  return offset;
}


static const per_sequence_t PosMeasurementResultList_sequence_of[1] = {
  { &hf_f1ap_PosMeasurementResultList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosMeasurementResultList_Item },
};

static int
dissect_f1ap_PosMeasurementResultList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosMeasurementResultList, PosMeasurementResultList_sequence_of,
                                                  1, maxNoOfMeasTRPs, FALSE);

  return offset;
}


static const value_string f1ap_PosReportCharacteristics_vals[] = {
  {   0, "ondemand" },
  {   1, "periodic" },
  { 0, NULL }
};


static int
dissect_f1ap_PosReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_PrimaryPathIndication_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_PrimaryPathIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_SpectrumSharingGroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellineNB, NULL, FALSE);

  return offset;
}


static const per_sequence_t Protected_EUTRA_Resources_Item_sequence[] = {
  { &hf_f1ap_spectrumSharingGroupID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SpectrumSharingGroupID },
  { &hf_f1ap_eUTRACells_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRACells_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Protected_EUTRA_Resources_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Protected_EUTRA_Resources_Item, Protected_EUTRA_Resources_Item_sequence);

  return offset;
}


static const value_string f1ap_T_subcarrierSpacing_01_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  { 0, NULL }
};


static int
dissect_f1ap_T_subcarrierSpacing_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_2176(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2176U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3279165(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3279165U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_T_combSize_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n12" },
  { 0, NULL }
};


static int
dissect_f1ap_T_combSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_cPType_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_T_cPType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_resourceSetPeriodicity_vals[] = {
  {   0, "n4" },
  {   1, "n5" },
  {   2, "n8" },
  {   3, "n10" },
  {   4, "n16" },
  {   5, "n20" },
  {   6, "n32" },
  {   7, "n40" },
  {   8, "n64" },
  {   9, "n80" },
  {  10, "n160" },
  {  11, "n320" },
  {  12, "n640" },
  {  13, "n1280" },
  {  14, "n2560" },
  {  15, "n5120" },
  {  16, "n10240" },
  {  17, "n20480" },
  {  18, "n40960" },
  {  19, "n81920" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resourceSetPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     20, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_resourceRepetitionFactor_vals[] = {
  {   0, "rf1" },
  {   1, "rf2" },
  {   2, "rf4" },
  {   3, "rf6" },
  {   4, "rf8" },
  {   5, "rf16" },
  {   6, "rf32" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resourceRepetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_resourceTimeGap_vals[] = {
  {   0, "tg1" },
  {   1, "tg2" },
  {   2, "tg4" },
  {   3, "tg8" },
  {   4, "tg16" },
  {   5, "tg32" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resourceTimeGap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_resourceNumberofSymbols_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n12" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resourceNumberofSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_mutingBitRepetitionFactor_vals[] = {
  {   0, "rf1" },
  {   1, "rf2" },
  {   2, "rf4" },
  {   3, "rf8" },
  { 0, NULL }
};


static int
dissect_f1ap_T_mutingBitRepetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PRSMutingOption1_sequence[] = {
  { &hf_f1ap_mutingPattern  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRSMutingPattern },
  { &hf_f1ap_mutingBitRepetitionFactor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_mutingBitRepetitionFactor },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSMutingOption1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSMutingOption1, PRSMutingOption1_sequence);

  return offset;
}


static const per_sequence_t PRSMutingOption2_sequence[] = {
  { &hf_f1ap_mutingPattern  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRSMutingPattern },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSMutingOption2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSMutingOption2, PRSMutingOption2_sequence);

  return offset;
}


static const per_sequence_t PRSMuting_sequence[] = {
  { &hf_f1ap_pRSMutingOption1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSMutingOption1 },
  { &hf_f1ap_pRSMutingOption2, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSMutingOption2 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSMuting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSMuting, PRSMuting_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_M60_50(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -60, 50U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_11_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 11U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 12U, NULL, FALSE);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1007(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PRSResource_QCLSourceSSB_sequence[] = {
  { &hf_f1ap_pCI_NR         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1007 },
  { &hf_f1ap_sSB_Index      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SSB_Index },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSResource_QCLSourceSSB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSResource_QCLSourceSSB, PRSResource_QCLSourceSSB_sequence);

  return offset;
}


static const per_sequence_t PRSResource_QCLSourcePRS_sequence[] = {
  { &hf_f1ap_qCLSourcePRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_qCLSourcePRSResourceID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PRS_Resource_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSResource_QCLSourcePRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSResource_QCLSourcePRS, PRSResource_QCLSourcePRS_sequence);

  return offset;
}


static const value_string f1ap_PRSResource_QCLInfo_vals[] = {
  {   0, "qCLSourceSSB" },
  {   1, "qCLSourcePRS" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PRSResource_QCLInfo_choice[] = {
  {   0, &hf_f1ap_qCLSourceSSB   , ASN1_NO_EXTENSIONS     , dissect_f1ap_PRSResource_QCLSourceSSB },
  {   1, &hf_f1ap_qCLSourcePRS   , ASN1_NO_EXTENSIONS     , dissect_f1ap_PRSResource_QCLSourcePRS },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PRSResource_QCLInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PRSResource_QCLInfo, PRSResource_QCLInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PRSResource_Item_sequence[] = {
  { &hf_f1ap_pRSResourceID  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_ID },
  { &hf_f1ap_sequenceID     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_4095 },
  { &hf_f1ap_rEOffset       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_11_ },
  { &hf_f1ap_resourceSlotOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_511 },
  { &hf_f1ap_resourceSymbolOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_12 },
  { &hf_f1ap_qCLInfo        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PRSResource_QCLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSResource_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSResource_Item, PRSResource_Item_sequence);

  return offset;
}


static const per_sequence_t PRSResource_List_sequence_of[1] = {
  { &hf_f1ap_PRSResource_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSResource_Item },
};

static int
dissect_f1ap_PRSResource_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PRSResource_List, PRSResource_List_sequence_of,
                                                  1, maxnoofPRSresources, FALSE);

  return offset;
}


static const per_sequence_t PRSResourceSet_Item_sequence[] = {
  { &hf_f1ap_pRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_subcarrierSpacing_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_subcarrierSpacing_01 },
  { &hf_f1ap_pRSbandwidth   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_63 },
  { &hf_f1ap_startPRB       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2176 },
  { &hf_f1ap_pointA         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3279165 },
  { &hf_f1ap_combSize       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_combSize },
  { &hf_f1ap_cPType         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_cPType },
  { &hf_f1ap_resourceSetPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resourceSetPeriodicity },
  { &hf_f1ap_resourceSetSlotOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_81919_ },
  { &hf_f1ap_resourceRepetitionFactor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resourceRepetitionFactor },
  { &hf_f1ap_resourceTimeGap, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resourceTimeGap },
  { &hf_f1ap_resourceNumberofSymbols, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resourceNumberofSymbols },
  { &hf_f1ap_pRSMuting      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PRSMuting },
  { &hf_f1ap_pRSResourceTransmitPower, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M60_50 },
  { &hf_f1ap_pRSResource_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSResource_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSResourceSet_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSResourceSet_Item, PRSResourceSet_Item_sequence);

  return offset;
}


static const per_sequence_t PRSResourceSet_List_sequence_of[1] = {
  { &hf_f1ap_PRSResourceSet_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSResourceSet_Item },
};

static int
dissect_f1ap_PRSResourceSet_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PRSResourceSet_List, PRSResourceSet_List_sequence_of,
                                                  1, maxnoofPRSresourceSets, FALSE);

  return offset;
}


static const per_sequence_t PRSConfiguration_sequence[] = {
  { &hf_f1ap_pRSResourceSet_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRSResourceSet_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSConfiguration, PRSConfiguration_sequence);

  return offset;
}


static const per_sequence_t Potential_SpCell_Item_sequence[] = {
  { &hf_f1ap_potential_SpCell_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Potential_SpCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Potential_SpCell_Item, Potential_SpCell_Item_sequence);

  return offset;
}


static const per_sequence_t PWS_Failed_NR_CGI_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NumberOfBroadcasts },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PWS_Failed_NR_CGI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PWS_Failed_NR_CGI_Item, PWS_Failed_NR_CGI_Item_sequence);

  return offset;
}



static int
dissect_f1ap_SIBType_PWS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1547 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            6U, 8U, &f1ap_data->sib_type, TRUE);




  return offset;
}



static int
dissect_f1ap_T_sIBmessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1551 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sIBmessage);
    switch (f1ap_data->sib_type) {
    case 6:
      dissect_nr_rrc_SIB6_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 7:
      dissect_nr_rrc_SIB7_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 8:
      dissect_nr_rrc_SIB8_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }



  return offset;
}


static const per_sequence_t PWSSystemInformation_sequence[] = {
  { &hf_f1ap_sIBtype        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SIBType_PWS },
  { &hf_f1ap_sIBmessage     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sIBmessage },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PWSSystemInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PWSSystemInformation, PWSSystemInformation_sequence);

  return offset;
}


static const value_string f1ap_PrivacyIndicator_vals[] = {
  {   0, "immediate-MDT" },
  {   1, "logged-MDT" },
  { 0, NULL }
};


static int
dissect_f1ap_PrivacyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_QoSFlowMappingIndication_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  { 0, NULL }
};


static int
dissect_f1ap_QoSFlowMappingIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_QosMonitoringRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_f1ap_QosMonitoringRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_f1ap_QoSParaSetNotifyIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_RACHReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1845 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RACHReportContainer);
    dissect_nr_rrc_RA_ReportList_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const per_sequence_t RACHReportInformationItem_sequence[] = {
  { &hf_f1ap_rACHReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RACHReportContainer },
  { &hf_f1ap_uEAssitantIdentifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RACHReportInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RACHReportInformationItem, RACHReportInformationItem_sequence);

  return offset;
}


static const per_sequence_t RACHReportInformationList_sequence_of[1] = {
  { &hf_f1ap_RACHReportInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RACHReportInformationItem },
};

static int
dissect_f1ap_RACHReportInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_RACHReportInformationList, RACHReportInformationList_sequence_of,
                                                  1, maxnoofRACHReports, FALSE);

  return offset;
}



static int
dissect_f1ap_RAN_MeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65536U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_RAN_UE_MeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_RANUEID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, FALSE, NULL);

  return offset;
}



static int
dissect_f1ap_SubscriberProfileIDforRFP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_RAT_FrequencySelectionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_RAT_FrequencyPriorityInformation_vals[] = {
  {   0, "eNDC" },
  {   1, "nGRAN" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RAT_FrequencyPriorityInformation_choice[] = {
  {   0, &hf_f1ap_eNDC           , ASN1_NO_EXTENSIONS     , dissect_f1ap_SubscriberProfileIDforRFP },
  {   1, &hf_f1ap_nGRAN          , ASN1_NO_EXTENSIONS     , dissect_f1ap_RAT_FrequencySelectionPriority },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_RAT_FrequencyPriorityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_RAT_FrequencyPriorityInformation, RAT_FrequencyPriorityInformation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_Reestablishment_Indication_vals[] = {
  {   0, "reestablished" },
  { 0, NULL }
};


static int
dissect_f1ap_Reestablishment_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_ReferenceSFN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_ReferenceSignal_vals[] = {
  {   0, "nZP-CSI-RS" },
  {   1, "sSB" },
  {   2, "sRS" },
  {   3, "positioningSRS" },
  {   4, "dL-PRS" },
  {   5, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ReferenceSignal_choice[] = {
  {   0, &hf_f1ap_nZP_CSI_RS     , ASN1_NO_EXTENSIONS     , dissect_f1ap_NZP_CSI_RS_ResourceID },
  {   1, &hf_f1ap_sSB            , ASN1_NO_EXTENSIONS     , dissect_f1ap_SSB },
  {   2, &hf_f1ap_sRS            , ASN1_NO_EXTENSIONS     , dissect_f1ap_SRSResourceID },
  {   3, &hf_f1ap_positioningSRS , ASN1_NO_EXTENSIONS     , dissect_f1ap_SRSPosResourceID },
  {   4, &hf_f1ap_dL_PRS         , ASN1_NO_EXTENSIONS     , dissect_f1ap_DL_PRS },
  {   5, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ReferenceSignal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ReferenceSignal, ReferenceSignal_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_ReferenceTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1853 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ReferenceTime);
    dissect_nr_rrc_ReferenceTime_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_RegistrationRequest_vals[] = {
  {   0, "start" },
  {   1, "stop" },
  {   2, "add" },
  { 0, NULL }
};


static int
dissect_f1ap_RegistrationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1861 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_f1ap_ReportCharacteristics_PRBPeriodic,
      &hf_f1ap_ReportCharacteristics_TNLCapacityIndPeriodic,
      &hf_f1ap_ReportCharacteristics_CompositeAvailableCapacityPeriodic,
      &hf_f1ap_ReportCharacteristics_HWLoadIndPeriodic,
      &hf_f1ap_ReportCharacteristics_NumberOfActiveUEs,
      &hf_f1ap_ReportCharacteristics_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ReportCharacteristics);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 4, fields, ENC_BIG_ENDIAN);
  }



  return offset;
}


static const value_string f1ap_ReportingPeriodicity_vals[] = {
  {   0, "ms500" },
  {   1, "ms1000" },
  {   2, "ms2000" },
  {   3, "ms5000" },
  {   4, "ms10000" },
  { 0, NULL }
};


static int
dissect_f1ap_ReportingPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_RequestedBandCombinationIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1678 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RequestedBandCombinationIndex);
    dissect_nr_rrc_BandCombinationIndex_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_RequestedFeatureSetEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1686 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RequestedFeatureSetEntryIndex);
    dissect_nr_rrc_FeatureSetEntryIndex_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_RequestedP_MaxFR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1694 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RequestedP_MaxFR2);
    dissect_nr_rrc_P_Max_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_Requested_PDCCH_BlindDetectionSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1652 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 1, ENC_BIG_ENDIAN);
  }



  return offset;
}



static int
dissect_f1ap_INTEGER_0_500_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 500U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_T_resourceType_01_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resourceType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_16_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SpatialRelationforResourceIDItem_sequence[] = {
  { &hf_f1ap_referenceSignal, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ReferenceSignal },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SpatialRelationforResourceIDItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SpatialRelationforResourceIDItem, SpatialRelationforResourceIDItem_sequence);

  return offset;
}


static const per_sequence_t SpatialRelationforResourceID_sequence_of[1] = {
  { &hf_f1ap_SpatialRelationforResourceID_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SpatialRelationforResourceIDItem },
};

static int
dissect_f1ap_SpatialRelationforResourceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SpatialRelationforResourceID, SpatialRelationforResourceID_sequence_of,
                                                  1, maxnoofSpatialRelations, FALSE);

  return offset;
}


static const per_sequence_t SpatialRelationInfo_sequence[] = {
  { &hf_f1ap_spatialRelationforResourceID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SpatialRelationforResourceID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SpatialRelationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SpatialRelationInfo, SpatialRelationInfo_sequence);

  return offset;
}


static const per_sequence_t SRSResourceSetItem_sequence[] = {
  { &hf_f1ap_numSRSresourcesperset, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_16_ },
  { &hf_f1ap_periodicityList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PeriodicityList },
  { &hf_f1ap_spatialRelationInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SpatialRelationInfo },
  { &hf_f1ap_pathlossReferenceInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PathlossReferenceInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSResourceSetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSResourceSetItem, SRSResourceSetItem_sequence);

  return offset;
}


static const per_sequence_t SRSResourceSetList_sequence_of[1] = {
  { &hf_f1ap_SRSResourceSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceSetItem },
};

static int
dissect_f1ap_SRSResourceSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSResourceSetList, SRSResourceSetList_sequence_of,
                                                  1, maxnoSRS_ResourceSets, FALSE);

  return offset;
}


static const value_string f1ap_T_sSB_subcarrier_spacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz240" },
  { 0, NULL }
};


static int
dissect_f1ap_T_sSB_subcarrier_spacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_sSB_periodicity_vals[] = {
  {   0, "ms5" },
  {   1, "ms10" },
  {   2, "ms20" },
  {   3, "ms40" },
  {   4, "ms80" },
  {   5, "ms160" },
  { 0, NULL }
};


static int
dissect_f1ap_T_sSB_periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_SSB_PositionsInBurst_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_PositionsInBurst_choice[] = {
  {   0, &hf_f1ap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_4 },
  {   1, &hf_f1ap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_8 },
  {   2, &hf_f1ap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_64 },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SSB_PositionsInBurst(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SSB_PositionsInBurst, SSB_PositionsInBurst_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SSB_TF_Configuration_sequence[] = {
  { &hf_f1ap_sSB_frequency  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3279165 },
  { &hf_f1ap_sSB_subcarrier_spacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sSB_subcarrier_spacing },
  { &hf_f1ap_sSB_Transmit_power, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M60_50 },
  { &hf_f1ap_sSB_periodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sSB_periodicity },
  { &hf_f1ap_sSB_half_frame_offset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1 },
  { &hf_f1ap_sSB_SFN_offset , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_sSB_position_in_burst, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSB_PositionsInBurst },
  { &hf_f1ap_sFNInitialisationTime, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RelativeTime1900 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSB_TF_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSB_TF_Configuration, SSB_TF_Configuration_sequence);

  return offset;
}


static const per_sequence_t SSBInformationItem_sequence[] = {
  { &hf_f1ap_sSB_Configuration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_TF_Configuration },
  { &hf_f1ap_pCI_NR_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPCI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBInformationItem, SSBInformationItem_sequence);

  return offset;
}


static const per_sequence_t SSBInformationList_sequence_of[1] = {
  { &hf_f1ap_SSBInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBInformationItem },
};

static int
dissect_f1ap_SSBInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBInformationList, SSBInformationList_sequence_of,
                                                  1, maxnoofSSBs, FALSE);

  return offset;
}


static const per_sequence_t SSBInformation_sequence[] = {
  { &hf_f1ap_sSBInformationList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBInformationList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBInformation, SSBInformation_sequence);

  return offset;
}


static const per_sequence_t RequestedSRSTransmissionCharacteristics_sequence[] = {
  { &hf_f1ap_numberOfTransmissions, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_500_ },
  { &hf_f1ap_resourceType_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resourceType_01 },
  { &hf_f1ap_bandwidthSRS   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BandwidthSRS },
  { &hf_f1ap_sRSResourceSetList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SRSResourceSetList },
  { &hf_f1ap_sSBInformation , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSBInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RequestedSRSTransmissionCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RequestedSRSTransmissionCharacteristics, RequestedSRSTransmissionCharacteristics_sequence);

  return offset;
}


static const value_string f1ap_RequestType_vals[] = {
  {   0, "offer" },
  {   1, "execution" },
  { 0, NULL }
};


static int
dissect_f1ap_RequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceCoordinationEUTRACellInfo_sequence[] = {
  { &hf_f1ap_eUTRA_Mode_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Coex_Mode_Info },
  { &hf_f1ap_eUTRA_PRACH_Configuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_PRACH_Configuration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceCoordinationEUTRACellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceCoordinationEUTRACellInfo, ResourceCoordinationEUTRACellInfo_sequence);

  return offset;
}


static const per_sequence_t ResourceCoordinationTransferInformation_sequence[] = {
  { &hf_f1ap_meNB_Cell_ID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Cell_ID },
  { &hf_f1ap_resourceCoordinationEUTRACellInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ResourceCoordinationEUTRACellInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceCoordinationTransferInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceCoordinationTransferInformation, ResourceCoordinationTransferInformation_sequence);

  return offset;
}



static int
dissect_f1ap_ResourceCoordinationTransferContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1214 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree;
    f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);

    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ResourceCoordinationTransferContainer);
    switch (f1ap_data->message_type) {
    case INITIATING_MESSAGE:
      switch (f1ap_data->procedure_code) {
      case id_UEContextSetup:
      case id_UEContextModification:
        dissect_x2ap_MeNBResourceCoordinationInformation_PDU(param_tvb, actx->pinfo, subtree, NULL);
        break;
      case id_UEContextModificationRequired:
        dissect_x2ap_SgNBResourceCoordinationInformation_PDU(param_tvb, actx->pinfo, subtree, NULL);
        break;
      default:
        break;
      }
      break;
    case SUCCESSFUL_OUTCOME:
      switch (f1ap_data->procedure_code) {
      case id_UEContextSetup:
      case id_UEContextModification:
        dissect_x2ap_SgNBResourceCoordinationInformation_PDU(param_tvb, actx->pinfo, subtree, NULL);
        break;
      case id_UEContextModificationRequired:
        dissect_x2ap_MeNBResourceCoordinationInformation_PDU(param_tvb, actx->pinfo, subtree, NULL);
        break;
      default:
        break;
      }
      break;
    default:
      break;
    }
  }



  return offset;
}



static int
dissect_f1ap_RepetitionPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 131071U, NULL, TRUE);

  return offset;
}


static const per_sequence_t ReportingRequestType_sequence[] = {
  { &hf_f1ap_eventType      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EventType },
  { &hf_f1ap_reportingPeriodicityValue, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ReportingPeriodicityValue },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ReportingRequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ReportingRequestType, ReportingRequestType_sequence);

  return offset;
}


static const per_sequence_t RLCDuplicationState_Item_sequence[] = {
  { &hf_f1ap_duplicationState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DuplicationState },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RLCDuplicationState_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RLCDuplicationState_Item, RLCDuplicationState_Item_sequence);

  return offset;
}


static const per_sequence_t RLCDuplicationStateList_sequence_of[1] = {
  { &hf_f1ap_RLCDuplicationStateList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCDuplicationState_Item },
};

static int
dissect_f1ap_RLCDuplicationStateList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_RLCDuplicationStateList, RLCDuplicationStateList_sequence_of,
                                                  1, maxnoofRLCDuplicationState, FALSE);

  return offset;
}


static const per_sequence_t RLCDuplicationInformation_sequence[] = {
  { &hf_f1ap_rLCDuplicationStateList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCDuplicationStateList },
  { &hf_f1ap_primaryPathIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PrimaryPathIndication },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RLCDuplicationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RLCDuplicationInformation, RLCDuplicationInformation_sequence);

  return offset;
}


static const per_sequence_t RLCFailureIndication_sequence[] = {
  { &hf_f1ap_assocatedLCID  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LCID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RLCFailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RLCFailureIndication, RLCFailureIndication_sequence);

  return offset;
}


static const per_sequence_t RLC_Status_sequence[] = {
  { &hf_f1ap_reestablishment_Indication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Reestablishment_Indication },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RLC_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RLC_Status, RLC_Status_sequence);

  return offset;
}


static const per_sequence_t RLFReportInformationItem_sequence[] = {
  { &hf_f1ap_nRUERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRUERLFReportContainer },
  { &hf_f1ap_uEAssitantIdentifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RLFReportInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RLFReportInformationItem, RLFReportInformationItem_sequence);

  return offset;
}


static const per_sequence_t RLFReportInformationList_sequence_of[1] = {
  { &hf_f1ap_RLFReportInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLFReportInformationItem },
};

static int
dissect_f1ap_RLFReportInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_RLFReportInformationList, RLFReportInformationList_sequence_of,
                                                  1, maxnoofRLFReports, FALSE);

  return offset;
}



static int
dissect_f1ap_RRCContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1254 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree;
    f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);

    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RRCContainer);
    switch (f1ap_data->message_type) {
    case INITIATING_MESSAGE:
      switch (f1ap_data->procedure_code) {
      case id_InitialULRRCMessageTransfer:
        col_append_str(actx->pinfo->cinfo, COL_PROTOCOL, "/");
        col_set_fence(actx->pinfo->cinfo, COL_PROTOCOL);
        col_set_fence(actx->pinfo->cinfo, COL_INFO);
        call_dissector(nr_rrc_ul_ccch_handle, param_tvb, actx->pinfo, subtree);
        break;
      case id_ULRRCMessageTransfer:
        switch (f1ap_data->srb_id) {
        case 1:
        case 2:
        case 3:
          col_append_str(actx->pinfo->cinfo, COL_PROTOCOL, "/");
          col_set_fence(actx->pinfo->cinfo, COL_PROTOCOL);
          col_set_fence(actx->pinfo->cinfo, COL_INFO);
          add_nr_pdcp_meta_data(actx->pinfo, PDCP_NR_DIRECTION_UPLINK, f1ap_data->srb_id);
          call_dissector(nr_pdcp_handle, param_tvb, actx->pinfo, subtree);
          break;
        default:
          break;
        }
        break;
      case id_DLRRCMessageTransfer:
      case id_UEContextRelease:
        switch (f1ap_data->srb_id) {
        case 0:
          col_append_str(actx->pinfo->cinfo, COL_PROTOCOL, "/");
          col_set_fence(actx->pinfo->cinfo, COL_PROTOCOL);
          col_set_fence(actx->pinfo->cinfo, COL_INFO);
          call_dissector(nr_rrc_dl_ccch_handle, param_tvb, actx->pinfo, subtree);
          break;
        case 1:
        case 2:
        case 3:
          col_append_str(actx->pinfo->cinfo, COL_PROTOCOL, "/");
          col_set_fence(actx->pinfo->cinfo, COL_PROTOCOL);
          col_set_fence(actx->pinfo->cinfo, COL_INFO);
          add_nr_pdcp_meta_data(actx->pinfo, PDCP_NR_DIRECTION_DOWNLINK, f1ap_data->srb_id);
          call_dissector(nr_pdcp_handle, param_tvb, actx->pinfo, subtree);
          break;
        default:
          break;
        }
        break;
      default:
        break;
      }
      break;
    default:
      break;
    }
  }



  return offset;
}



static int
dissect_f1ap_RRCContainer_RRCSetupComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1321 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RRCContainer_RRCSetupComplete);
    col_append_str(actx->pinfo->cinfo, COL_PROTOCOL, "/");
    col_set_fence(actx->pinfo->cinfo, COL_PROTOCOL);
    col_set_fence(actx->pinfo->cinfo, COL_INFO);
    call_dissector(nr_rrc_ul_dcch_handle, param_tvb, actx->pinfo, subtree);
  }



  return offset;
}


static const per_sequence_t RRCDeliveryStatus_sequence[] = {
  { &hf_f1ap_delivery_status, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PDCP_SN },
  { &hf_f1ap_triggering_message, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PDCP_SN },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RRCDeliveryStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RRCDeliveryStatus, RRCDeliveryStatus_sequence);

  return offset;
}


static const value_string f1ap_RRCDeliveryStatusRequest_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_RRCDeliveryStatusRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_RRCReconfigurationCompleteIndicator_vals[] = {
  {   0, "true" },
  {   1, "failure" },
  { 0, NULL }
};


static int
dissect_f1ap_RRCReconfigurationCompleteIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     3, 3, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t RRC_Version_sequence[] = {
  { &hf_f1ap_latest_RRC_Version, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BIT_STRING_SIZE_3 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RRC_Version(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RRC_Version, RRC_Version_sequence);

  return offset;
}



static int
dissect_f1ap_Latest_RRC_Version_Enhanced(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1600 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, &param_tvb);



#line 1603 "./asn1/f1ap/f1ap.cnf"
  if (param_tvb) {
    proto_item_set_text(actx->created_item, "%u.%u.%u", tvb_get_guint8(param_tvb, 0), tvb_get_guint8(param_tvb, 1), tvb_get_guint8(param_tvb, 2));
  }


  return offset;
}



static int
dissect_f1ap_RoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const per_sequence_t SCell_FailedtoSetup_Item_sequence[] = {
  { &hf_f1ap_sCell_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SCell_FailedtoSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SCell_FailedtoSetup_Item, SCell_FailedtoSetup_Item_sequence);

  return offset;
}


static const per_sequence_t SCell_FailedtoSetupMod_Item_sequence[] = {
  { &hf_f1ap_sCell_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SCell_FailedtoSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SCell_FailedtoSetupMod_Item, SCell_FailedtoSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t SCell_ToBeRemoved_Item_sequence[] = {
  { &hf_f1ap_sCell_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SCell_ToBeRemoved_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SCell_ToBeRemoved_Item, SCell_ToBeRemoved_Item_sequence);

  return offset;
}



static int
dissect_f1ap_SCellIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 31U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SCell_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_sCell_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sCellIndex     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SCellIndex },
  { &hf_f1ap_sCellULConfigured, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CellULConfigured },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SCell_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SCell_ToBeSetup_Item, SCell_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t SCell_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_sCell_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sCellIndex     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SCellIndex },
  { &hf_f1ap_sCellULConfigured, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CellULConfigured },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SCell_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SCell_ToBeSetupMod_Item, SCell_ToBeSetupMod_Item_sequence);

  return offset;
}


static const value_string f1ap_SCGIndicator_vals[] = {
  {   0, "released" },
  { 0, NULL }
};


static int
dissect_f1ap_SCGIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string f1ap_T_subcarrierSpacing_02_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  { 0, NULL }
};


static int
dissect_f1ap_T_subcarrierSpacing_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_275_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 275U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SCS_SpecificCarrier_sequence[] = {
  { &hf_f1ap_offsetToCarrier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2199_ },
  { &hf_f1ap_subcarrierSpacing_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_subcarrierSpacing_02 },
  { &hf_f1ap_carrierBandwidth_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_275_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SCS_SpecificCarrier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SCS_SpecificCarrier, SCS_SpecificCarrier_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_M3841_3841_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -3841, 3841U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_246_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 246U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Search_window_information_sequence[] = {
  { &hf_f1ap_expectedPropagationDelay, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M3841_3841_ },
  { &hf_f1ap_delayUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_246_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Search_window_information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Search_window_information, Search_window_information_sequence);

  return offset;
}



static int
dissect_f1ap_SelectedBandCombinationIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_f1ap_SelectedFeatureSetEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_f1ap_ServCellIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_ServingCellMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SFN_Offset_sequence[] = {
  { &hf_f1ap_sFN_Time_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BIT_STRING_SIZE_24 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SFN_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SFN_Offset, SFN_Offset_sequence);

  return offset;
}


static const per_sequence_t Served_Cells_To_Add_Item_sequence[] = {
  { &hf_f1ap_served_Cell_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Served_Cell_Information },
  { &hf_f1ap_gNB_DU_System_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_System_Information },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Served_Cells_To_Add_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Served_Cells_To_Add_Item, Served_Cells_To_Add_Item_sequence);

  return offset;
}


static const per_sequence_t Served_Cells_To_Delete_Item_sequence[] = {
  { &hf_f1ap_oldNRCGI       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Served_Cells_To_Delete_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Served_Cells_To_Delete_Item, Served_Cells_To_Delete_Item_sequence);

  return offset;
}


static const per_sequence_t Served_Cells_To_Modify_Item_sequence[] = {
  { &hf_f1ap_oldNRCGI       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_served_Cell_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Served_Cell_Information },
  { &hf_f1ap_gNB_DU_System_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_System_Information },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Served_Cells_To_Modify_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Served_Cells_To_Modify_Item, Served_Cells_To_Modify_Item_sequence);

  return offset;
}



static int
dissect_f1ap_SIB10_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1878 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SIB10_message);
    dissect_nr_rrc_SIB10_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_SIB12_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1886 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SIB12_message);
    dissect_nr_rrc_SIB12_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_SIB13_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1894 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SIB13_message);
    dissect_nr_rrc_SIB13_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_SIB14_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1902 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SIB14_message);
    dissect_nr_rrc_SIB14_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_SItype(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SItype_Item_sequence[] = {
  { &hf_f1ap_sItype         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SItype },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SItype_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SItype_Item, SItype_Item_sequence);

  return offset;
}


static const per_sequence_t SItype_List_sequence_of[1] = {
  { &hf_f1ap_SItype_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SItype_Item },
};

static int
dissect_f1ap_SItype_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SItype_List, SItype_List_sequence_of,
                                                  1, maxnoofSITypes, FALSE);

  return offset;
}



static int
dissect_f1ap_SLDRBID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 512U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SLDRBInformation_sequence[] = {
  { &hf_f1ap_sLDRB_QoS      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PC5QoSParameters },
  { &hf_f1ap_flowsMappedToSLDRB_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_FlowsMappedToSLDRB_List },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBInformation, SLDRBInformation_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_FailedToBeModified_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_FailedToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_FailedToBeModified_Item, SLDRBs_FailedToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_FailedToBeSetup_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_FailedToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_FailedToBeSetup_Item, SLDRBs_FailedToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_FailedToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_FailedToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_FailedToBeSetupMod_Item, SLDRBs_FailedToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_Modified_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_Modified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_Modified_Item, SLDRBs_Modified_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_ModifiedConf_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_ModifiedConf_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_ModifiedConf_Item, SLDRBs_ModifiedConf_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_Required_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_Required_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_Required_ToBeModified_Item, SLDRBs_Required_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_Required_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_Required_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_Required_ToBeReleased_Item, SLDRBs_Required_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_Setup_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_Setup_Item, SLDRBs_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_SetupMod_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_SetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_SetupMod_Item, SLDRBs_SetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_sLDRBInformation, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SLDRBInformation },
  { &hf_f1ap_rLCMode        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RLCMode },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_ToBeModified_Item, SLDRBs_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_ToBeReleased_Item, SLDRBs_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_sLDRBInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBInformation },
  { &hf_f1ap_rLCMode        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_ToBeSetup_Item, SLDRBs_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_sLDRBID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBID },
  { &hf_f1ap_sLDRBInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SLDRBInformation },
  { &hf_f1ap_rLCMode        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RLCMode },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SLDRBs_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SLDRBs_ToBeSetupMod_Item, SLDRBs_ToBeSetupMod_Item_sequence);

  return offset;
}



static int
dissect_f1ap_SL_PHY_MAC_RLC_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1910 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SL_PHY_MAC_RLC_Config);
    dissect_nr_rrc_SL_PHY_MAC_RLC_Config_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_SL_ConfigDedicatedEUTRA_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1918 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SL_ConfigDedicatedEUTRA_Info);
    dissect_nr_rrc_SL_ConfigDedicatedEUTRA_Info_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_SlotNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 79U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SpatialDirectionInformation_sequence[] = {
  { &hf_f1ap_nR_PRSBeamInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NR_PRSBeamInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SpatialDirectionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SpatialDirectionInformation, SpatialDirectionInformation_sequence);

  return offset;
}



static int
dissect_f1ap_SRBID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1317 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, &f1ap_data->srb_id, TRUE);




  return offset;
}


static const per_sequence_t SRBs_FailedToBeSetup_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_FailedToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_FailedToBeSetup_Item, SRBs_FailedToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_FailedToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_FailedToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_FailedToBeSetupMod_Item, SRBs_FailedToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_Modified_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LCID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_Modified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_Modified_Item, SRBs_Modified_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_Required_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_Required_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_Required_ToBeReleased_Item, SRBs_Required_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_Setup_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LCID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_Setup_Item, SRBs_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_SetupMod_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LCID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_SetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_SetupMod_Item, SRBs_SetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_ToBeReleased_Item, SRBs_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_duplicationIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DuplicationIndication },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_ToBeSetup_Item, SRBs_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t SRBs_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_sRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRBID },
  { &hf_f1ap_duplicationIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DuplicationIndication },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRBs_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRBs_ToBeSetupMod_Item, SRBs_ToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t UplinkChannelBW_PerSCS_List_sequence_of[1] = {
  { &hf_f1ap_UplinkChannelBW_PerSCS_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SCS_SpecificCarrier },
};

static int
dissect_f1ap_UplinkChannelBW_PerSCS_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UplinkChannelBW_PerSCS_List, UplinkChannelBW_PerSCS_List_sequence_of,
                                                  1, maxnoSCSs, FALSE);

  return offset;
}


static const per_sequence_t SRSCarrier_List_Item_sequence[] = {
  { &hf_f1ap_pointA         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3279165 },
  { &hf_f1ap_uplinkChannelBW_PerSCS_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UplinkChannelBW_PerSCS_List },
  { &hf_f1ap_activeULBWP    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ActiveULBWP },
  { &hf_f1ap_pci            , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NRPCI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSCarrier_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSCarrier_List_Item, SRSCarrier_List_Item_sequence);

  return offset;
}


static const per_sequence_t SRSCarrier_List_sequence_of[1] = {
  { &hf_f1ap_SRSCarrier_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSCarrier_List_Item },
};

static int
dissect_f1ap_SRSCarrier_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSCarrier_List, SRSCarrier_List_sequence_of,
                                                  1, maxnoSRS_Carriers, FALSE);

  return offset;
}


static const per_sequence_t SRSConfiguration_sequence[] = {
  { &hf_f1ap_sRSCarrier_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSCarrier_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSConfiguration, SRSConfiguration_sequence);

  return offset;
}



static int
dissect_f1ap_SrsFrequency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3279165U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SRSResourceTrigger_sequence[] = {
  { &hf_f1ap_aperiodicSRSResourceTriggerList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AperiodicSRSResourceTriggerList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSResourceTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSResourceTrigger, SRSResourceTrigger_sequence);

  return offset;
}


static const value_string f1ap_SULAccessIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_SULAccessIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_SystemInformationAreaID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_TDD_UL_DLConfigCommonNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1927 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_TDD_UL_DLConfigCommonNR);
    dissect_nr_rrc_TDD_UL_DL_ConfigCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_Uncertainty(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, TRUE);

  return offset;
}


static const value_string f1ap_TimeInformationType_vals[] = {
  {   0, "localClock" },
  { 0, NULL }
};


static int
dissect_f1ap_TimeInformationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t TimeReferenceInformation_sequence[] = {
  { &hf_f1ap_referenceTime  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ReferenceTime },
  { &hf_f1ap_referenceSFN   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ReferenceSFN },
  { &hf_f1ap_uncertainty    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Uncertainty },
  { &hf_f1ap_timeInformationType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TimeInformationType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TimeReferenceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TimeReferenceInformation, TimeReferenceInformation_sequence);

  return offset;
}


static const value_string f1ap_TimeToWait_vals[] = {
  {   0, "v1s" },
  {   1, "v2s" },
  {   2, "v5s" },
  {   3, "v10s" },
  {   4, "v20s" },
  {   5, "v60s" },
  { 0, NULL }
};


static int
dissect_f1ap_TimeToWait(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_16777216_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16777216U, NULL, TRUE);

  return offset;
}


static const per_sequence_t TNLCapacityIndicator_sequence[] = {
  { &hf_f1ap_dLTNLOfferedCapacity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_16777216_ },
  { &hf_f1ap_dLTNLAvailableCapacity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100_ },
  { &hf_f1ap_uLTNLOfferedCapacity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_16777216_ },
  { &hf_f1ap_uLTNLAvailableCapacity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TNLCapacityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TNLCapacityIndicator, TNLCapacityIndicator_sequence);

  return offset;
}



static int
dissect_f1ap_TraceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, FALSE, NULL);

  return offset;
}


static const value_string f1ap_TraceDepth_vals[] = {
  {   0, "minimum" },
  {   1, "medium" },
  {   2, "maximum" },
  {   3, "minimumWithoutVendorSpecificExtension" },
  {   4, "mediumWithoutVendorSpecificExtension" },
  {   5, "maximumWithoutVendorSpecificExtension" },
  { 0, NULL }
};


static int
dissect_f1ap_TraceDepth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TraceActivation_sequence[] = {
  { &hf_f1ap_traceID        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TraceID },
  { &hf_f1ap_interfacesToTrace, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_InterfacesToTrace },
  { &hf_f1ap_traceDepth     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TraceDepth },
  { &hf_f1ap_traceCollectionEntityIPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TraceActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TraceActivation, TraceActivation_sequence);

  return offset;
}


static const value_string f1ap_TransmissionStopIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_TransmissionStopIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Address_Info_To_Add_Item_sequence[] = {
  { &hf_f1ap_iP_SecTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_gTPTransportLayerAddressToAdd, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_GTPTLAs },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Transport_UP_Layer_Address_Info_To_Add_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Transport_UP_Layer_Address_Info_To_Add_Item, Transport_UP_Layer_Address_Info_To_Add_Item_sequence);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Address_Info_To_Add_List_sequence_of[1] = {
  { &hf_f1ap_Transport_UP_Layer_Address_Info_To_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Transport_UP_Layer_Address_Info_To_Add_Item },
};

static int
dissect_f1ap_Transport_UP_Layer_Address_Info_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Transport_UP_Layer_Address_Info_To_Add_List, Transport_UP_Layer_Address_Info_To_Add_List_sequence_of,
                                                  1, maxnoofTLAs, FALSE);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Address_Info_To_Remove_Item_sequence[] = {
  { &hf_f1ap_iP_SecTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_gTPTransportLayerAddressToRemove, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_GTPTLAs },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Transport_UP_Layer_Address_Info_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Transport_UP_Layer_Address_Info_To_Remove_Item, Transport_UP_Layer_Address_Info_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t Transport_UP_Layer_Address_Info_To_Remove_List_sequence_of[1] = {
  { &hf_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Transport_UP_Layer_Address_Info_To_Remove_Item },
};

static int
dissect_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List, Transport_UP_Layer_Address_Info_To_Remove_List_sequence_of,
                                                  1, maxnoofTLAs, FALSE);

  return offset;
}


static const value_string f1ap_TransmissionActionIndicator_vals[] = {
  {   0, "stop" },
  {   1, "restart" },
  { 0, NULL }
};


static int
dissect_f1ap_TransmissionActionIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 1, NULL);

  return offset;
}


static const value_string f1ap_TRPInformationTypeResponseItem_vals[] = {
  {   0, "pCI-NR" },
  {   1, "nG-RAN-CGI" },
  {   2, "nRARFCN" },
  {   3, "pRSConfiguration" },
  {   4, "sSBinformation" },
  {   5, "sFNInitialisationTime" },
  {   6, "spatialDirectionInformation" },
  {   7, "geographicalCoordinates" },
  {   8, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPInformationTypeResponseItem_choice[] = {
  {   0, &hf_f1ap_pCI_NR_01      , ASN1_NO_EXTENSIONS     , dissect_f1ap_NRPCI },
  {   1, &hf_f1ap_nG_RAN_CGI     , ASN1_NO_EXTENSIONS     , dissect_f1ap_NRCGI },
  {   2, &hf_f1ap_nRARFCN        , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_maxNRARFCN },
  {   3, &hf_f1ap_pRSConfiguration, ASN1_NO_EXTENSIONS     , dissect_f1ap_PRSConfiguration },
  {   4, &hf_f1ap_sSBinformation , ASN1_NO_EXTENSIONS     , dissect_f1ap_SSBInformation },
  {   5, &hf_f1ap_sFNInitialisationTime, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeTime1900 },
  {   6, &hf_f1ap_spatialDirectionInformation, ASN1_NO_EXTENSIONS     , dissect_f1ap_SpatialDirectionInformation },
  {   7, &hf_f1ap_geographicalCoordinates, ASN1_NO_EXTENSIONS     , dissect_f1ap_GeographicalCoordinates },
  {   8, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPInformationTypeResponseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPInformationTypeResponseItem, TRPInformationTypeResponseItem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TRPInformationTypeResponseList_sequence_of[1] = {
  { &hf_f1ap_TRPInformationTypeResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPInformationTypeResponseItem },
};

static int
dissect_f1ap_TRPInformationTypeResponseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_TRPInformationTypeResponseList, TRPInformationTypeResponseList_sequence_of,
                                                  1, maxnoofTRPInfoTypes, FALSE);

  return offset;
}


static const per_sequence_t TRPInformation_sequence[] = {
  { &hf_f1ap_tRPID          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPID },
  { &hf_f1ap_tRPInformationTypeResponseList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPInformationTypeResponseList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPInformation, TRPInformation_sequence);

  return offset;
}


static const per_sequence_t TRPInformationItem_sequence[] = {
  { &hf_f1ap_tRPInformation , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPInformationItem, TRPInformationItem_sequence);

  return offset;
}


static const value_string f1ap_TRPInformationTypeItem_vals[] = {
  {   0, "nrPCI" },
  {   1, "nG-RAN-CGI" },
  {   2, "arfcn" },
  {   3, "pRSConfig" },
  {   4, "sSBConfig" },
  {   5, "sFNInitTime" },
  {   6, "spatialDirectInfo" },
  {   7, "geoCoord" },
  { 0, NULL }
};


static int
dissect_f1ap_TRPInformationTypeItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TRPListItem_sequence[] = {
  { &hf_f1ap_tRPID          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPListItem, TRPListItem_sequence);

  return offset;
}


static const per_sequence_t TRPList_sequence_of[1] = {
  { &hf_f1ap_TRPList_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPListItem },
};

static int
dissect_f1ap_TRPList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_TRPList, TRPList_sequence_of,
                                                  1, maxnoofTRPs, FALSE);

  return offset;
}


static const per_sequence_t TRP_MeasurementRequestItem_sequence[] = {
  { &hf_f1ap_tRPID          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPID },
  { &hf_f1ap_search_window_information, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Search_window_information },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRP_MeasurementRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRP_MeasurementRequestItem, TRP_MeasurementRequestItem_sequence);

  return offset;
}


static const per_sequence_t TRP_MeasurementRequestList_sequence_of[1] = {
  { &hf_f1ap_TRP_MeasurementRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRP_MeasurementRequestItem },
};

static int
dissect_f1ap_TRP_MeasurementRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_TRP_MeasurementRequestList, TRP_MeasurementRequestList_sequence_of,
                                                  1, maxNoOfMeasTRPs, FALSE);

  return offset;
}


static const per_sequence_t Transport_Layer_Address_Info_sequence[] = {
  { &hf_f1ap_transport_UP_Layer_Address_Info_To_Add_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Transport_UP_Layer_Address_Info_To_Add_List },
  { &hf_f1ap_transport_UP_Layer_Address_Info_To_Remove_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Transport_Layer_Address_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Transport_Layer_Address_Info, Transport_Layer_Address_Info_sequence);

  return offset;
}


static const per_sequence_t TSCAssistanceInformation_sequence[] = {
  { &hf_f1ap_periodicity_04 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Periodicity },
  { &hf_f1ap_burstArrivalTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BurstArrivalTime },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TSCAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TSCAssistanceInformation, TSCAssistanceInformation_sequence);

  return offset;
}


static const per_sequence_t TSCTrafficCharacteristics_sequence[] = {
  { &hf_f1ap_tSCAssistanceInformationDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TSCAssistanceInformation },
  { &hf_f1ap_tSCAssistanceInformationUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TSCAssistanceInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TSCTrafficCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TSCTrafficCharacteristics, TSCTrafficCharacteristics_sequence);

  return offset;
}



static int
dissect_f1ap_UACReductionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const value_string f1ap_UACAction_vals[] = {
  {   0, "reject-non-emergency-mo-dt" },
  {   1, "reject-rrc-cr-signalling" },
  {   2, "permit-emergency-sessions-and-mobile-terminated-services-only" },
  {   3, "permit-high-priority-sessions-and-mobile-terminated-services-only" },
  { 0, NULL }
};


static int
dissect_f1ap_UACAction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_32_63_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            32U, 63U, NULL, TRUE);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t UACOperatorDefined_sequence[] = {
  { &hf_f1ap_accessCategory , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_32_63_ },
  { &hf_f1ap_accessIdentity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BIT_STRING_SIZE_7 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UACOperatorDefined(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UACOperatorDefined, UACOperatorDefined_sequence);

  return offset;
}


static const value_string f1ap_UACCategoryType_vals[] = {
  {   0, "uACstandardized" },
  {   1, "uACOperatorDefined" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UACCategoryType_choice[] = {
  {   0, &hf_f1ap_uACstandardized, ASN1_NO_EXTENSIONS     , dissect_f1ap_UACAction },
  {   1, &hf_f1ap_uACOperatorDefined, ASN1_NO_EXTENSIONS     , dissect_f1ap_UACOperatorDefined },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_UACCategoryType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_UACCategoryType, UACCategoryType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UACType_Item_sequence[] = {
  { &hf_f1ap_uACReductionIndication, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UACReductionIndication },
  { &hf_f1ap_uACCategoryType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UACCategoryType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UACType_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UACType_Item, UACType_Item_sequence);

  return offset;
}


static const per_sequence_t UACType_List_sequence_of[1] = {
  { &hf_f1ap_UACType_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UACType_Item },
};

static int
dissect_f1ap_UACType_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UACType_List, UACType_List_sequence_of,
                                                  1, maxnoofUACperPLMN, FALSE);

  return offset;
}


static const per_sequence_t UACPLMN_Item_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_uACType_List   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UACType_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UACPLMN_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UACPLMN_Item, UACPLMN_Item_sequence);

  return offset;
}


static const per_sequence_t UACPLMN_List_sequence_of[1] = {
  { &hf_f1ap_UACPLMN_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UACPLMN_Item },
};

static int
dissect_f1ap_UACPLMN_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UACPLMN_List, UACPLMN_List_sequence_of,
                                                  1, maxnoofUACPLMNs, FALSE);

  return offset;
}


static const per_sequence_t UAC_Assistance_Info_sequence[] = {
  { &hf_f1ap_uACPLMN_List   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UACPLMN_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UAC_Assistance_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UAC_Assistance_Info, UAC_Assistance_Info_sequence);

  return offset;
}


static const per_sequence_t UE_associatedLogicalF1_ConnectionItem_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_gNB_DU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UE_associatedLogicalF1_ConnectionItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UE_associatedLogicalF1_ConnectionItem, UE_associatedLogicalF1_ConnectionItem_sequence);

  return offset;
}



static int
dissect_f1ap_UEAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1702 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_UEAssistanceInformation);
    dissect_nr_rrc_UEAssistanceInformation_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_UEAssistanceInformationEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1936 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_UEAssistanceInformationEUTRA);
    dissect_lte_rrc_UEAssistanceInformation_r11_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}


static const value_string f1ap_UEContextNotRetrievable_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_UEContextNotRetrievable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_UEIdentityIndexValue_vals[] = {
  {   0, "indexLength10" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UEIdentityIndexValue_choice[] = {
  {   0, &hf_f1ap_indexLength10  , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_10 },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_UEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_UEIdentityIndexValue, UEIdentityIndexValue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UL_BH_Non_UP_Traffic_Mapping_Item_sequence[] = {
  { &hf_f1ap_nonUPTrafficType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NonUPTrafficType },
  { &hf_f1ap_bHInfo         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_BH_Non_UP_Traffic_Mapping_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_BH_Non_UP_Traffic_Mapping_Item, UL_BH_Non_UP_Traffic_Mapping_Item_sequence);

  return offset;
}


static const per_sequence_t UL_BH_Non_UP_Traffic_Mapping_List_sequence_of[1] = {
  { &hf_f1ap_UL_BH_Non_UP_Traffic_Mapping_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UL_BH_Non_UP_Traffic_Mapping_Item },
};

static int
dissect_f1ap_UL_BH_Non_UP_Traffic_Mapping_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UL_BH_Non_UP_Traffic_Mapping_List, UL_BH_Non_UP_Traffic_Mapping_List_sequence_of,
                                                  1, maxnoofNonUPTrafficMappings, FALSE);

  return offset;
}


static const per_sequence_t UL_BH_Non_UP_Traffic_Mapping_sequence[] = {
  { &hf_f1ap_uL_BH_Non_UP_Traffic_Mapping_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UL_BH_Non_UP_Traffic_Mapping_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_BH_Non_UP_Traffic_Mapping(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_BH_Non_UP_Traffic_Mapping, UL_BH_Non_UP_Traffic_Mapping_sequence);

  return offset;
}


static const per_sequence_t UL_UP_TNL_Information_to_Update_List_Item_sequence[] = {
  { &hf_f1ap_uLUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_newULUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_bHInfo         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BHInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_UP_TNL_Information_to_Update_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_UP_TNL_Information_to_Update_List_Item, UL_UP_TNL_Information_to_Update_List_Item_sequence);

  return offset;
}


static const per_sequence_t UL_UP_TNL_Address_to_Update_List_Item_sequence[] = {
  { &hf_f1ap_oldIPAdress    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_newIPAdress    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_UP_TNL_Address_to_Update_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_UP_TNL_Address_to_Update_List_Item, UL_UP_TNL_Address_to_Update_List_Item_sequence);

  return offset;
}



static int
dissect_f1ap_UplinkTxDirectCurrentListInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1592 "./asn1/f1ap/f1ap.cnf"
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_UplinkTxDirectCurrentListInformation);
    dissect_nr_rrc_UplinkTxDirectCurrentList_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }



  return offset;
}



static int
dissect_f1ap_URI_address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, FALSE);

  return offset;
}


static const per_sequence_t VictimgNBSetID_sequence[] = {
  { &hf_f1ap_victimgNBSetID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBSetID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_VictimgNBSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_VictimgNBSetID, VictimgNBSetID_sequence);

  return offset;
}


static const per_sequence_t Reset_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Reset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1960 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_RESET);
  set_stats_message_type(actx->pinfo, MTYPE_RESET);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Reset, Reset_sequence);

  return offset;
}


static const value_string f1ap_ResetAll_vals[] = {
  {   0, "reset-all" },
  { 0, NULL }
};


static int
dissect_f1ap_ResetAll(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t UE_associatedLogicalF1_ConnectionListRes_sequence_of[1] = {
  { &hf_f1ap_UE_associatedLogicalF1_ConnectionListRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_UE_associatedLogicalF1_ConnectionListRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UE_associatedLogicalF1_ConnectionListRes, UE_associatedLogicalF1_ConnectionListRes_sequence_of,
                                                  1, maxnoofIndividualF1ConnectionsToReset, FALSE);

  return offset;
}


static const value_string f1ap_ResetType_vals[] = {
  {   0, "f1-Interface" },
  {   1, "partOfF1-Interface" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResetType_choice[] = {
  {   0, &hf_f1ap_f1_Interface   , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResetAll },
  {   1, &hf_f1ap_partOfF1_Interface, ASN1_NO_EXTENSIONS     , dissect_f1ap_UE_associatedLogicalF1_ConnectionListRes },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ResetType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ResetType, ResetType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ResetAcknowledge_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResetAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1963 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_RESET_ACK);
  set_stats_message_type(actx->pinfo, MTYPE_RESET_ACK);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResetAcknowledge, ResetAcknowledge_sequence);

  return offset;
}


static const per_sequence_t UE_associatedLogicalF1_ConnectionListResAck_sequence_of[1] = {
  { &hf_f1ap_UE_associatedLogicalF1_ConnectionListResAck_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_UE_associatedLogicalF1_ConnectionListResAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UE_associatedLogicalF1_ConnectionListResAck, UE_associatedLogicalF1_ConnectionListResAck_sequence_of,
                                                  1, maxnoofIndividualF1ConnectionsToReset, FALSE);

  return offset;
}


static const per_sequence_t ErrorIndication_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ErrorIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2038 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_ERROR_INDICATION);
  set_stats_message_type(actx->pinfo, MTYPE_ERROR_INDICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ErrorIndication, ErrorIndication_sequence);

  return offset;
}


static const per_sequence_t F1SetupRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1SetupRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1966 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_F1_SETUP_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_F1_SETUP_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1SetupRequest, F1SetupRequest_sequence);

  return offset;
}


static const per_sequence_t GNB_DU_Served_Cells_List_sequence_of[1] = {
  { &hf_f1ap_GNB_DU_Served_Cells_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_GNB_DU_Served_Cells_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNB_DU_Served_Cells_List, GNB_DU_Served_Cells_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t F1SetupResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1SetupResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1969 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_F1_SETUP_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_F1_SETUP_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1SetupResponse, F1SetupResponse_sequence);

  return offset;
}


static const per_sequence_t Cells_to_be_Activated_List_sequence_of[1] = {
  { &hf_f1ap_Cells_to_be_Activated_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_to_be_Activated_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_to_be_Activated_List, Cells_to_be_Activated_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t F1SetupFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1SetupFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1972 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_F1_SETUP_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_F1_SETUP_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1SetupFailure, F1SetupFailure_sequence);

  return offset;
}


static const per_sequence_t GNBDUConfigurationUpdate_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUConfigurationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1975 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_CONFIGURATION_UPDATE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_CONFIGURATION_UPDATE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUConfigurationUpdate, GNBDUConfigurationUpdate_sequence);

  return offset;
}


static const per_sequence_t Served_Cells_To_Add_List_sequence_of[1] = {
  { &hf_f1ap_Served_Cells_To_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Served_Cells_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Served_Cells_To_Add_List, Served_Cells_To_Add_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t Served_Cells_To_Modify_List_sequence_of[1] = {
  { &hf_f1ap_Served_Cells_To_Modify_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Served_Cells_To_Modify_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Served_Cells_To_Modify_List, Served_Cells_To_Modify_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t Served_Cells_To_Delete_List_sequence_of[1] = {
  { &hf_f1ap_Served_Cells_To_Delete_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Served_Cells_To_Delete_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Served_Cells_To_Delete_List, Served_Cells_To_Delete_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t Cells_Status_List_sequence_of[1] = {
  { &hf_f1ap_Cells_Status_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_Status_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_Status_List, Cells_Status_List_sequence_of,
                                                  0, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t Dedicated_SIDelivery_NeededUE_List_sequence_of[1] = {
  { &hf_f1ap_Dedicated_SIDelivery_NeededUE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Dedicated_SIDelivery_NeededUE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Dedicated_SIDelivery_NeededUE_List, Dedicated_SIDelivery_NeededUE_List_sequence_of,
                                                  1, maxnoofUEIDs, FALSE);

  return offset;
}


static const per_sequence_t GNB_DU_TNL_Association_To_Remove_List_sequence_of[1] = {
  { &hf_f1ap_GNB_DU_TNL_Association_To_Remove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_GNB_DU_TNL_Association_To_Remove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNB_DU_TNL_Association_To_Remove_List, GNB_DU_TNL_Association_To_Remove_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t GNBDUConfigurationUpdateAcknowledge_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUConfigurationUpdateAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1978 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_CONFIGURATION_UPDATE_ACKNOWLEDGE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_CONFIGURATION_UPDATE_ACKNOWLEDGE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUConfigurationUpdateAcknowledge, GNBDUConfigurationUpdateAcknowledge_sequence);

  return offset;
}


static const per_sequence_t GNBDUConfigurationUpdateFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUConfigurationUpdateFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1981 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_CONFIGURATION_UPDATE_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_CONFIGURATION_UPDATE_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUConfigurationUpdateFailure, GNBDUConfigurationUpdateFailure_sequence);

  return offset;
}


static const per_sequence_t GNBCUConfigurationUpdate_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBCUConfigurationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1984 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_CU_CONFIGURATION_UPDATE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_CU_CONFIGURATION_UPDATE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBCUConfigurationUpdate, GNBCUConfigurationUpdate_sequence);

  return offset;
}


static const per_sequence_t Cells_to_be_Deactivated_List_sequence_of[1] = {
  { &hf_f1ap_Cells_to_be_Deactivated_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_to_be_Deactivated_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_to_be_Deactivated_List, Cells_to_be_Deactivated_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Add_List_sequence_of[1] = {
  { &hf_f1ap_GNB_CU_TNL_Association_To_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNB_CU_TNL_Association_To_Add_List, GNB_CU_TNL_Association_To_Add_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Remove_List_sequence_of[1] = {
  { &hf_f1ap_GNB_CU_TNL_Association_To_Remove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Remove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNB_CU_TNL_Association_To_Remove_List, GNB_CU_TNL_Association_To_Remove_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Update_List_sequence_of[1] = {
  { &hf_f1ap_GNB_CU_TNL_Association_To_Update_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Update_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNB_CU_TNL_Association_To_Update_List, GNB_CU_TNL_Association_To_Update_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t Cells_to_be_Barred_List_sequence_of[1] = {
  { &hf_f1ap_Cells_to_be_Barred_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_to_be_Barred_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_to_be_Barred_List, Cells_to_be_Barred_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t Protected_EUTRA_Resources_List_sequence_of[1] = {
  { &hf_f1ap_Protected_EUTRA_Resources_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Protected_EUTRA_Resources_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Protected_EUTRA_Resources_List, Protected_EUTRA_Resources_List_sequence_of,
                                                  1, maxCellineNB, FALSE);

  return offset;
}


static const per_sequence_t Neighbour_Cell_Information_List_sequence_of[1] = {
  { &hf_f1ap_Neighbour_Cell_Information_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Neighbour_Cell_Information_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Neighbour_Cell_Information_List, Neighbour_Cell_Information_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t GNBCUConfigurationUpdateAcknowledge_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBCUConfigurationUpdateAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1987 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_CU_CONFIGURATION_UPDATE_ACKNOWLEDGE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_CU_CONFIGURATION_UPDATE_ACKNOWLEDGE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBCUConfigurationUpdateAcknowledge, GNBCUConfigurationUpdateAcknowledge_sequence);

  return offset;
}


static const per_sequence_t Cells_Failed_to_be_Activated_List_sequence_of[1] = {
  { &hf_f1ap_Cells_Failed_to_be_Activated_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_Failed_to_be_Activated_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_Failed_to_be_Activated_List, Cells_Failed_to_be_Activated_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_Setup_List_sequence_of[1] = {
  { &hf_f1ap_GNB_CU_TNL_Association_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_GNB_CU_TNL_Association_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNB_CU_TNL_Association_Setup_List, GNB_CU_TNL_Association_Setup_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_Failed_To_Setup_List_sequence_of[1] = {
  { &hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List, GNB_CU_TNL_Association_Failed_To_Setup_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t GNBCUConfigurationUpdateFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBCUConfigurationUpdateFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1990 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_CU_CONFIGURATION_UPDATE_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_CU_CONFIGURATION_UPDATE_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBCUConfigurationUpdateFailure, GNBCUConfigurationUpdateFailure_sequence);

  return offset;
}


static const per_sequence_t GNBDUResourceCoordinationRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUResourceCoordinationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2056 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_RESOURCE_COORDINATION_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_RESOURCE_COORDINATION_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUResourceCoordinationRequest, GNBDUResourceCoordinationRequest_sequence);

  return offset;
}


static const per_sequence_t GNBDUResourceCoordinationResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUResourceCoordinationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2059 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_RESOURCE_COORDINATION_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_RESOURCE_COORDINATION_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUResourceCoordinationResponse, GNBDUResourceCoordinationResponse_sequence);

  return offset;
}


static const per_sequence_t UEContextSetupRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextSetupRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1993 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_SETUP_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_SETUP_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextSetupRequest, UEContextSetupRequest_sequence);

  return offset;
}


static const per_sequence_t Candidate_SpCell_List_sequence_of[1] = {
  { &hf_f1ap_Candidate_SpCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Candidate_SpCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Candidate_SpCell_List, Candidate_SpCell_List_sequence_of,
                                                  1, maxnoofCandidateSpCells, FALSE);

  return offset;
}


static const per_sequence_t SCell_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_SCell_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SCell_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SCell_ToBeSetup_List, SCell_ToBeSetup_List_sequence_of,
                                                  1, maxnoofSCells, FALSE);

  return offset;
}


static const per_sequence_t SRBs_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_ToBeSetup_List, SRBs_ToBeSetup_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_ToBeSetup_List, DRBs_ToBeSetup_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_ToBeSetup_List, BHChannels_ToBeSetup_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_ToBeSetup_List, SLDRBs_ToBeSetup_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t UEContextSetupResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextSetupResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1996 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_SETUP_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_SETUP_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextSetupResponse, UEContextSetupResponse_sequence);

  return offset;
}


static const per_sequence_t DRBs_Setup_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_Setup_List, DRBs_Setup_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t SRBs_FailedToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_FailedToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_FailedToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_FailedToBeSetup_List, SRBs_FailedToBeSetup_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_FailedToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_FailedToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_FailedToBeSetup_List, DRBs_FailedToBeSetup_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t SCell_FailedtoSetup_List_sequence_of[1] = {
  { &hf_f1ap_SCell_FailedtoSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SCell_FailedtoSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SCell_FailedtoSetup_List, SCell_FailedtoSetup_List_sequence_of,
                                                  1, maxnoofSCells, FALSE);

  return offset;
}


static const per_sequence_t SRBs_Setup_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_Setup_List, SRBs_Setup_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_Setup_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_Setup_List, BHChannels_Setup_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_FailedToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_FailedToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_FailedToBeSetup_List, BHChannels_FailedToBeSetup_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_Setup_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_Setup_List, SLDRBs_Setup_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_FailedToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_FailedToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_FailedToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_FailedToBeSetup_List, SLDRBs_FailedToBeSetup_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t UEContextSetupFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextSetupFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1999 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_SETUP_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_SETUP_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextSetupFailure, UEContextSetupFailure_sequence);

  return offset;
}


static const per_sequence_t Potential_SpCell_List_sequence_of[1] = {
  { &hf_f1ap_Potential_SpCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Potential_SpCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Potential_SpCell_List, Potential_SpCell_List_sequence_of,
                                                  0, maxnoofPotentialSpCells, FALSE);

  return offset;
}


static const per_sequence_t UEContextReleaseRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextReleaseRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2041 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_RELEASE_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_RELEASE_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextReleaseRequest, UEContextReleaseRequest_sequence);

  return offset;
}


static const per_sequence_t UEContextReleaseCommand_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextReleaseCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2002 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_RELEASE_COMMAND);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_RELEASE_COMMAND);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextReleaseCommand, UEContextReleaseCommand_sequence);

  return offset;
}


static const per_sequence_t UEContextReleaseComplete_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextReleaseComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2005 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_RELEASE_COMPLETE);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_RELEASE_COMPLETE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextReleaseComplete, UEContextReleaseComplete_sequence);

  return offset;
}


static const per_sequence_t UEContextModificationRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextModificationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2008 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_MODIFICATION_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_MODIFICATION_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextModificationRequest, UEContextModificationRequest_sequence);

  return offset;
}


static const per_sequence_t SCell_ToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SCell_ToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SCell_ToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SCell_ToBeSetupMod_List, SCell_ToBeSetupMod_List_sequence_of,
                                                  1, maxnoofSCells, FALSE);

  return offset;
}


static const per_sequence_t SCell_ToBeRemoved_List_sequence_of[1] = {
  { &hf_f1ap_SCell_ToBeRemoved_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SCell_ToBeRemoved_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SCell_ToBeRemoved_List, SCell_ToBeRemoved_List_sequence_of,
                                                  1, maxnoofSCells, FALSE);

  return offset;
}


static const per_sequence_t SRBs_ToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_ToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_ToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_ToBeSetupMod_List, SRBs_ToBeSetupMod_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_ToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_ToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_ToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_ToBeSetupMod_List, DRBs_ToBeSetupMod_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_ToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_ToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_ToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_ToBeSetupMod_List, BHChannels_ToBeSetupMod_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t DRBs_ToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_ToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_ToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_ToBeModified_List, DRBs_ToBeModified_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_ToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_ToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_ToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_ToBeModified_List, BHChannels_ToBeModified_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t SRBs_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_ToBeReleased_List, SRBs_ToBeReleased_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_ToBeReleased_List, DRBs_ToBeReleased_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_ToBeReleased_List, BHChannels_ToBeReleased_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_ToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_ToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_ToBeSetupMod_List, SLDRBs_ToBeSetupMod_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_ToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_ToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_ToBeModified_List, SLDRBs_ToBeModified_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_ToBeReleased_List, SLDRBs_ToBeReleased_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t UEContextModificationResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextModificationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2011 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextModificationResponse, UEContextModificationResponse_sequence);

  return offset;
}


static const per_sequence_t DRBs_SetupMod_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_SetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_SetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_SetupMod_List, DRBs_SetupMod_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_Modified_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_Modified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_Modified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_Modified_List, DRBs_Modified_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t SRBs_SetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_SetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_SetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_SetupMod_List, SRBs_SetupMod_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t SRBs_Modified_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_Modified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_Modified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_Modified_List, SRBs_Modified_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_FailedToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_FailedToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_FailedToBeModified_List, DRBs_FailedToBeModified_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t SRBs_FailedToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_FailedToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_FailedToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_FailedToBeSetupMod_List, SRBs_FailedToBeSetupMod_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_FailedToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_FailedToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_FailedToBeSetupMod_List, DRBs_FailedToBeSetupMod_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t SCell_FailedtoSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SCell_FailedtoSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SCell_FailedtoSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SCell_FailedtoSetupMod_List, SCell_FailedtoSetupMod_List_sequence_of,
                                                  1, maxnoofSCells, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_SetupMod_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_SetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_SetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_SetupMod_List, BHChannels_SetupMod_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_Modified_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_Modified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_Modified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_Modified_List, BHChannels_Modified_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_FailedToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_FailedToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_FailedToBeModified_List, BHChannels_FailedToBeModified_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_FailedToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_FailedToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_FailedToBeSetupMod_List, BHChannels_FailedToBeSetupMod_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t Associated_SCell_List_sequence_of[1] = {
  { &hf_f1ap_Associated_SCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Associated_SCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Associated_SCell_List, Associated_SCell_List_sequence_of,
                                                  1, maxnoofSCells, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_SetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_SetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_SetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_SetupMod_List, SLDRBs_SetupMod_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_Modified_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_Modified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_Modified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_Modified_List, SLDRBs_Modified_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_FailedToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_FailedToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_FailedToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_FailedToBeModified_List, SLDRBs_FailedToBeModified_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_FailedToBeSetupMod_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_FailedToBeSetupMod_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_FailedToBeSetupMod_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_FailedToBeSetupMod_List, SLDRBs_FailedToBeSetupMod_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t UEContextModificationFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextModificationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2014 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_MODIFICATION_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_MODIFICATION_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextModificationFailure, UEContextModificationFailure_sequence);

  return offset;
}


static const per_sequence_t UEContextModificationRequired_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextModificationRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2017 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_MODIFICATION_REQUIRED);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_MODIFICATION_REQUIRED);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextModificationRequired, UEContextModificationRequired_sequence);

  return offset;
}


static const per_sequence_t DRBs_Required_ToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_Required_ToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_Required_ToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_Required_ToBeModified_List, DRBs_Required_ToBeModified_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBs_Required_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_Required_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_Required_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_Required_ToBeReleased_List, DRBs_Required_ToBeReleased_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t SRBs_Required_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_SRBs_Required_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SRBs_Required_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRBs_Required_ToBeReleased_List, SRBs_Required_ToBeReleased_List_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t BHChannels_Required_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_BHChannels_Required_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BHChannels_Required_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHChannels_Required_ToBeReleased_List, BHChannels_Required_ToBeReleased_List_sequence_of,
                                                  1, maxnoofBHRLCChannels, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_Required_ToBeModified_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_Required_ToBeModified_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_Required_ToBeModified_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_Required_ToBeModified_List, SLDRBs_Required_ToBeModified_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_Required_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_Required_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_Required_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_Required_ToBeReleased_List, SLDRBs_Required_ToBeReleased_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t UEContextModificationConfirm_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextModificationConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2020 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_MODIFICATION_CONFIRM);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_MODIFICATION_CONFIRM);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextModificationConfirm, UEContextModificationConfirm_sequence);

  return offset;
}


static const per_sequence_t DRBs_ModifiedConf_List_sequence_of[1] = {
  { &hf_f1ap_DRBs_ModifiedConf_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRBs_ModifiedConf_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRBs_ModifiedConf_List, DRBs_ModifiedConf_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t SLDRBs_ModifiedConf_List_sequence_of[1] = {
  { &hf_f1ap_SLDRBs_ModifiedConf_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_SLDRBs_ModifiedConf_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SLDRBs_ModifiedConf_List, SLDRBs_ModifiedConf_List_sequence_of,
                                                  1, maxnoofSLDRBs, FALSE);

  return offset;
}


static const per_sequence_t UEContextModificationRefuse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEContextModificationRefuse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2023 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_CONTEXT_MODIFICATION_REFUSE);
  set_stats_message_type(actx->pinfo, MTYPE_UE_CONTEXT_MODIFICATION_REFUSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEContextModificationRefuse, UEContextModificationRefuse_sequence);

  return offset;
}


static const per_sequence_t WriteReplaceWarningRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_WriteReplaceWarningRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2026 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_WRITE_REPLACE_WARNING_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_WRITE_REPLACE_WARNING_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_WriteReplaceWarningRequest, WriteReplaceWarningRequest_sequence);

  return offset;
}


static const per_sequence_t Cells_To_Be_Broadcast_List_sequence_of[1] = {
  { &hf_f1ap_Cells_To_Be_Broadcast_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_To_Be_Broadcast_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_To_Be_Broadcast_List, Cells_To_Be_Broadcast_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t WriteReplaceWarningResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_WriteReplaceWarningResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2029 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_WRITE_REPLACE_WARNING_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_WRITE_REPLACE_WARNING_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_WriteReplaceWarningResponse, WriteReplaceWarningResponse_sequence);

  return offset;
}


static const per_sequence_t Cells_Broadcast_Completed_List_sequence_of[1] = {
  { &hf_f1ap_Cells_Broadcast_Completed_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_Broadcast_Completed_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_Broadcast_Completed_List, Cells_Broadcast_Completed_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t PWSCancelRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PWSCancelRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2032 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_PWS_CANCEL_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_PWS_CANCEL_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PWSCancelRequest, PWSCancelRequest_sequence);

  return offset;
}


static const per_sequence_t Broadcast_To_Be_Cancelled_List_sequence_of[1] = {
  { &hf_f1ap_Broadcast_To_Be_Cancelled_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Broadcast_To_Be_Cancelled_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Broadcast_To_Be_Cancelled_List, Broadcast_To_Be_Cancelled_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t PWSCancelResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PWSCancelResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2035 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_PWS_CANCEL_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_PWS_CANCEL_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PWSCancelResponse, PWSCancelResponse_sequence);

  return offset;
}


static const per_sequence_t Cells_Broadcast_Cancelled_List_sequence_of[1] = {
  { &hf_f1ap_Cells_Broadcast_Cancelled_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_Cells_Broadcast_Cancelled_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_Broadcast_Cancelled_List, Cells_Broadcast_Cancelled_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t UEInactivityNotification_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UEInactivityNotification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2053 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UE_INACTIVITY_NOTIFICATION);
  set_stats_message_type(actx->pinfo, MTYPE_UE_INACTIVITY_NOTIFICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UEInactivityNotification, UEInactivityNotification_sequence);

  return offset;
}


static const per_sequence_t DRB_Activity_List_sequence_of[1] = {
  { &hf_f1ap_DRB_Activity_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRB_Activity_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRB_Activity_List, DRB_Activity_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t InitialULRRCMessageTransfer_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_InitialULRRCMessageTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2044 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_INITIAL_UL_RRC_MESSAGE_TRANSFER);
  set_stats_message_type(actx->pinfo, MTYPE_INITIAL_UL_RRC_MESSAGE_TRANSFER);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_InitialULRRCMessageTransfer, InitialULRRCMessageTransfer_sequence);

  return offset;
}


static const per_sequence_t DLRRCMessageTransfer_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLRRCMessageTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2047 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_DL_RRC_MESSAGE_TRANSFER);
  set_stats_message_type(actx->pinfo, MTYPE_DL_RRC_MESSAGE_TRANSFER);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLRRCMessageTransfer, DLRRCMessageTransfer_sequence);

  return offset;
}



static int
dissect_f1ap_RedirectedRRCmessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const per_sequence_t ULRRCMessageTransfer_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ULRRCMessageTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2050 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_UL_RRC_MESSAGE_TRANSFER);
  set_stats_message_type(actx->pinfo, MTYPE_UL_RRC_MESSAGE_TRANSFER);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ULRRCMessageTransfer, ULRRCMessageTransfer_sequence);

  return offset;
}


static const per_sequence_t PrivateMessage_sequence[] = {
  { &hf_f1ap_privateIEs     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PrivateIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PrivateMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2062 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_PRIVATE_MESSAGE);
  set_stats_message_type(actx->pinfo, MTYPE_PRIVATE_MESSAGE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PrivateMessage, PrivateMessage_sequence);

  return offset;
}


static const per_sequence_t SystemInformationDeliveryCommand_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SystemInformationDeliveryCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2065 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_SYSTEM_INFORMATION_DELIVERY_COMMAND);
  set_stats_message_type(actx->pinfo, MTYPE_SYSTEM_INFORMATION_DELIVERY_COMMAND);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SystemInformationDeliveryCommand, SystemInformationDeliveryCommand_sequence);

  return offset;
}


static const per_sequence_t Paging_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Paging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2068 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_PAGING);
  set_stats_message_type(actx->pinfo, MTYPE_PAGING);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Paging, Paging_sequence);

  return offset;
}


static const per_sequence_t PagingCell_list_sequence_of[1] = {
  { &hf_f1ap_PagingCell_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_PagingCell_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PagingCell_list, PagingCell_list_sequence_of,
                                                  1, maxnoofPagingCells, FALSE);

  return offset;
}


static const per_sequence_t Notify_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Notify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2071 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_NOTIFY);
  set_stats_message_type(actx->pinfo, MTYPE_NOTIFY);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Notify, Notify_sequence);

  return offset;
}


static const per_sequence_t DRB_Notify_List_sequence_of[1] = {
  { &hf_f1ap_DRB_Notify_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DRB_Notify_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRB_Notify_List, DRB_Notify_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t NetworkAccessRateReduction_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NetworkAccessRateReduction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2074 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_NETWORK_ACCESS_RATE_REDUCTION);
  set_stats_message_type(actx->pinfo, MTYPE_NETWORK_ACCESS_RATE_REDUCTION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NetworkAccessRateReduction, NetworkAccessRateReduction_sequence);

  return offset;
}


static const per_sequence_t PWSRestartIndication_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PWSRestartIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2077 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_PWS_RESTART_INDICATION);
  set_stats_message_type(actx->pinfo, MTYPE_PWS_RESTART_INDICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PWSRestartIndication, PWSRestartIndication_sequence);

  return offset;
}


static const per_sequence_t NR_CGI_List_For_Restart_List_sequence_of[1] = {
  { &hf_f1ap_NR_CGI_List_For_Restart_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_NR_CGI_List_For_Restart_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NR_CGI_List_For_Restart_List, NR_CGI_List_For_Restart_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t PWSFailureIndication_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PWSFailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2080 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_PWS_FAILURE_INDICATION);
  set_stats_message_type(actx->pinfo, MTYPE_PWS_FAILURE_INDICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PWSFailureIndication, PWSFailureIndication_sequence);

  return offset;
}


static const per_sequence_t PWS_Failed_NR_CGI_List_sequence_of[1] = {
  { &hf_f1ap_PWS_Failed_NR_CGI_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_PWS_Failed_NR_CGI_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PWS_Failed_NR_CGI_List, PWS_Failed_NR_CGI_List_sequence_of,
                                                  1, maxCellingNBDU, FALSE);

  return offset;
}


static const per_sequence_t GNBDUStatusIndication_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUStatusIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2083 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_STATUS_INDICATION);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_STATUS_INDICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUStatusIndication, GNBDUStatusIndication_sequence);

  return offset;
}


static const per_sequence_t RRCDeliveryReport_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RRCDeliveryReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2086 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_RRC_DELIVERY_REPORT);
  set_stats_message_type(actx->pinfo, MTYPE_RRC_DELIVERY_REPORT);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RRCDeliveryReport, RRCDeliveryReport_sequence);

  return offset;
}


static const per_sequence_t F1RemovalRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1RemovalRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2090 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_F1_REMOVAL_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_F1_REMOVAL_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1RemovalRequest, F1RemovalRequest_sequence);

  return offset;
}


static const per_sequence_t F1RemovalResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1RemovalResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2094 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_F1_REMOVAL_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_F1_REMOVAL_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1RemovalResponse, F1RemovalResponse_sequence);

  return offset;
}


static const per_sequence_t F1RemovalFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1RemovalFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2098 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_F1_REMOVAL_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_F1_REMOVAL_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1RemovalFailure, F1RemovalFailure_sequence);

  return offset;
}


static const per_sequence_t TraceStart_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TraceStart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2102 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_TRACE_START);
  set_stats_message_type(actx->pinfo, MTYPE_TRACE_START);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TraceStart, TraceStart_sequence);

  return offset;
}


static const per_sequence_t DeactivateTrace_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DeactivateTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2106 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_DEACTIVATE_TRACE);
  set_stats_message_type(actx->pinfo, MTYPE_DEACTIVATE_TRACE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DeactivateTrace, DeactivateTrace_sequence);

  return offset;
}


static const per_sequence_t CellTrafficTrace_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellTrafficTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2198 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_CELL_TRAFFIC_TRACE);
  set_stats_message_type(actx->pinfo, MTYPE_CELL_TRAFFIC_TRACE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellTrafficTrace, CellTrafficTrace_sequence);

  return offset;
}


static const per_sequence_t DUCURadioInformationTransfer_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DUCURadioInformationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2110 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_DU_CU_RADIO_INFORMATION_TRANSFER);
  set_stats_message_type(actx->pinfo, MTYPE_DU_CU_RADIO_INFORMATION_TRANSFER);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DUCURadioInformationTransfer, DUCURadioInformationTransfer_sequence);

  return offset;
}


static const per_sequence_t CUDURadioInformationTransfer_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CUDURadioInformationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2114 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_CU_DU_RADIO_INFORMATION_TRANSFER);
  set_stats_message_type(actx->pinfo, MTYPE_CU_DU_RADIO_INFORMATION_TRANSFER);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CUDURadioInformationTransfer, CUDURadioInformationTransfer_sequence);

  return offset;
}


static const per_sequence_t BAPMappingConfiguration_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPMappingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2118 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_BAP_MAPPING_CONFIGURATION);
  set_stats_message_type(actx->pinfo, MTYPE_BAP_MAPPING_CONFIGURATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPMappingConfiguration, BAPMappingConfiguration_sequence);

  return offset;
}


static const per_sequence_t BH_Routing_Information_Added_List_sequence_of[1] = {
  { &hf_f1ap_BH_Routing_Information_Added_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BH_Routing_Information_Added_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BH_Routing_Information_Added_List, BH_Routing_Information_Added_List_sequence_of,
                                                  1, maxnoofRoutingEntries, FALSE);

  return offset;
}


static const per_sequence_t BH_Routing_Information_Removed_List_sequence_of[1] = {
  { &hf_f1ap_BH_Routing_Information_Removed_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_BH_Routing_Information_Removed_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BH_Routing_Information_Removed_List, BH_Routing_Information_Removed_List_sequence_of,
                                                  1, maxnoofRoutingEntries, FALSE);

  return offset;
}


static const per_sequence_t BAPMappingConfigurationAcknowledge_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPMappingConfigurationAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2122 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_BAP_MAPPING_CONFIGURATION_ACKNOWLEDGE);
  set_stats_message_type(actx->pinfo, MTYPE_BAP_MAPPING_CONFIGURATION_ACKNOWLEDGE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPMappingConfigurationAcknowledge, BAPMappingConfigurationAcknowledge_sequence);

  return offset;
}


static const per_sequence_t BAPMappingConfigurationFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPMappingConfigurationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2126 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_BAP_MAPPING_CONFIGURATION_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_BAP_MAPPING_CONFIGURATION_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPMappingConfigurationFailure, BAPMappingConfigurationFailure_sequence);

  return offset;
}


static const per_sequence_t GNBDUResourceConfiguration_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUResourceConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2130 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_RESOURCE_CONFIGURATION);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_RESOURCE_CONFIGURATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUResourceConfiguration, GNBDUResourceConfiguration_sequence);

  return offset;
}


static const per_sequence_t GNBDUResourceConfigurationAcknowledge_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUResourceConfigurationAcknowledge(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2134 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_RESOURCE_CONFIGURATION_ACKNOWLEDGE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_RESOURCE_CONFIGURATION_ACKNOWLEDGE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUResourceConfigurationAcknowledge, GNBDUResourceConfigurationAcknowledge_sequence);

  return offset;
}


static const per_sequence_t GNBDUResourceConfigurationFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUResourceConfigurationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2138 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_GNB_DU_RESOURCE_CONFIGURATION_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_GNB_DU_RESOURCE_CONFIGURATION_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUResourceConfigurationFailure, GNBDUResourceConfigurationFailure_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddressRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddressRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2142 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_IAB_TNL_ADDRESS_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_IAB_TNL_ADDRESS_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABTNLAddressRequest, IABTNLAddressRequest_sequence);

  return offset;
}


static const per_sequence_t IAB_TNL_Addresses_To_Remove_List_sequence_of[1] = {
  { &hf_f1ap_IAB_TNL_Addresses_To_Remove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_IAB_TNL_Addresses_To_Remove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IAB_TNL_Addresses_To_Remove_List, IAB_TNL_Addresses_To_Remove_List_sequence_of,
                                                  1, maxnoofTLAsIAB, FALSE);

  return offset;
}


static const per_sequence_t IABTNLAddressResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddressResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2146 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_IAB_TNL_ADDRESS_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_IAB_TNL_ADDRESS_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABTNLAddressResponse, IABTNLAddressResponse_sequence);

  return offset;
}


static const per_sequence_t IAB_Allocated_TNL_Address_List_sequence_of[1] = {
  { &hf_f1ap_IAB_Allocated_TNL_Address_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_IAB_Allocated_TNL_Address_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IAB_Allocated_TNL_Address_List, IAB_Allocated_TNL_Address_List_sequence_of,
                                                  1, maxnoofTLAsIAB, FALSE);

  return offset;
}


static const per_sequence_t IABTNLAddressFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddressFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2150 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_IAB_TNL_ADDRESS_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_IAB_TNL_ADDRESS_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABTNLAddressFailure, IABTNLAddressFailure_sequence);

  return offset;
}


static const per_sequence_t IABUPConfigurationUpdateRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABUPConfigurationUpdateRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2154 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_IAB_UP_CONFIGURATION_UPDATE_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_IAB_UP_CONFIGURATION_UPDATE_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABUPConfigurationUpdateRequest, IABUPConfigurationUpdateRequest_sequence);

  return offset;
}


static const per_sequence_t UL_UP_TNL_Information_to_Update_List_sequence_of[1] = {
  { &hf_f1ap_UL_UP_TNL_Information_to_Update_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_UL_UP_TNL_Information_to_Update_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UL_UP_TNL_Information_to_Update_List, UL_UP_TNL_Information_to_Update_List_sequence_of,
                                                  1, maxnoofULUPTNLInformationforIAB, FALSE);

  return offset;
}


static const per_sequence_t UL_UP_TNL_Address_to_Update_List_sequence_of[1] = {
  { &hf_f1ap_UL_UP_TNL_Address_to_Update_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_UL_UP_TNL_Address_to_Update_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_UL_UP_TNL_Address_to_Update_List, UL_UP_TNL_Address_to_Update_List_sequence_of,
                                                  1, maxnoofUPTNLAddresses, FALSE);

  return offset;
}


static const per_sequence_t IABUPConfigurationUpdateResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABUPConfigurationUpdateResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2158 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_IAB_UP_CONFIGURATION_UPDATE_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_IAB_UP_CONFIGURATION_UPDATE_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABUPConfigurationUpdateResponse, IABUPConfigurationUpdateResponse_sequence);

  return offset;
}


static const per_sequence_t DL_UP_TNL_Address_to_Update_List_sequence_of[1] = {
  { &hf_f1ap_DL_UP_TNL_Address_to_Update_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_DL_UP_TNL_Address_to_Update_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DL_UP_TNL_Address_to_Update_List, DL_UP_TNL_Address_to_Update_List_sequence_of,
                                                  1, maxnoofUPTNLAddresses, FALSE);

  return offset;
}


static const per_sequence_t IABUPConfigurationUpdateFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABUPConfigurationUpdateFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2162 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_IAB_UP_CONFIGURATION_UPDATE_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_IAB_UP_CONFIGURATION_UPDATE_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABUPConfigurationUpdateFailure, IABUPConfigurationUpdateFailure_sequence);

  return offset;
}


static const per_sequence_t ResourceStatusRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceStatusRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2166 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_RESOURCE_STATUS_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_RESOURCE_STATUS_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceStatusRequest, ResourceStatusRequest_sequence);

  return offset;
}


static const per_sequence_t ResourceStatusResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceStatusResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2170 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_RESOURCE_STATUS_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_RESOURCE_STATUS_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceStatusResponse, ResourceStatusResponse_sequence);

  return offset;
}


static const per_sequence_t ResourceStatusFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceStatusFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2174 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_RESOURCE_STATUS_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_RESOURCE_STATUS_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceStatusFailure, ResourceStatusFailure_sequence);

  return offset;
}


static const per_sequence_t ResourceStatusUpdate_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceStatusUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2178 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_RESOURCE_STATUS_UPDATE);
  set_stats_message_type(actx->pinfo, MTYPE_RESOURCE_STATUS_UPDATE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceStatusUpdate, ResourceStatusUpdate_sequence);

  return offset;
}


static const per_sequence_t AccessAndMobilityIndication_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AccessAndMobilityIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2182 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_ACCESS_AND_MOBILITY_INDICATION);
  set_stats_message_type(actx->pinfo, MTYPE_ACCESS_AND_MOBILITY_INDICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AccessAndMobilityIndication, AccessAndMobilityIndication_sequence);

  return offset;
}


static const per_sequence_t ReferenceTimeInformationReportingControl_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ReferenceTimeInformationReportingControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2186 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_REFERENCE_TIME_INFORMATION_REPORTING_CONTROL);
  set_stats_message_type(actx->pinfo, MTYPE_REFERENCE_TIME_INFORMATION_REPORTING_CONTROL);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ReferenceTimeInformationReportingControl, ReferenceTimeInformationReportingControl_sequence);

  return offset;
}


static const per_sequence_t ReferenceTimeInformationReport_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ReferenceTimeInformationReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2190 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_REFERENCE_TIME_INFORMATION_REPORT);
  set_stats_message_type(actx->pinfo, MTYPE_REFERENCE_TIME_INFORMATION_REPORT);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ReferenceTimeInformationReport, ReferenceTimeInformationReport_sequence);

  return offset;
}


static const per_sequence_t AccessSuccess_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AccessSuccess(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2194 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_ACCESS_SUCCESS);
  set_stats_message_type(actx->pinfo, MTYPE_ACCESS_SUCCESS);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AccessSuccess, AccessSuccess_sequence);

  return offset;
}


static const per_sequence_t PositioningAssistanceInformationControl_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningAssistanceInformationControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2202 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_ASSISTANCE_INFORMATION_CONTROL);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_ASSISTANCE_INFORMATION_CONTROL);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningAssistanceInformationControl, PositioningAssistanceInformationControl_sequence);

  return offset;
}


static const per_sequence_t PositioningAssistanceInformationFeedback_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningAssistanceInformationFeedback(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2206 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_ASSISTANCE_INFORMATION_FEEDBACK);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_ASSISTANCE_INFORMATION_FEEDBACK);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningAssistanceInformationFeedback, PositioningAssistanceInformationFeedback_sequence);

  return offset;
}


static const per_sequence_t PositioningMeasurementRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningMeasurementRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2210 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_MEASUREMENT_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_MEASUREMENT_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningMeasurementRequest, PositioningMeasurementRequest_sequence);

  return offset;
}


static const per_sequence_t PositioningMeasurementResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningMeasurementResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2214 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_MEASUREMENT_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_MEASUREMENT_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningMeasurementResponse, PositioningMeasurementResponse_sequence);

  return offset;
}


static const per_sequence_t PositioningMeasurementFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningMeasurementFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2218 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_MEASUREMENT_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_MEASUREMENT_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningMeasurementFailure, PositioningMeasurementFailure_sequence);

  return offset;
}


static const per_sequence_t PositioningMeasurementReport_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningMeasurementReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2222 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_MEASUREMENT_REPORT);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_MEASUREMENT_REPORT);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningMeasurementReport, PositioningMeasurementReport_sequence);

  return offset;
}


static const per_sequence_t PositioningMeasurementAbort_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningMeasurementAbort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2226 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_MEASUREMENT_ABORT);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_MEASUREMENT_ABORT);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningMeasurementAbort, PositioningMeasurementAbort_sequence);

  return offset;
}


static const per_sequence_t PositioningMeasurementFailureIndication_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningMeasurementFailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2230 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_MEASUREMENT_FAILURE_INDICATION);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_MEASUREMENT_FAILURE_INDICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningMeasurementFailureIndication, PositioningMeasurementFailureIndication_sequence);

  return offset;
}


static const per_sequence_t PositioningMeasurementUpdate_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningMeasurementUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2234 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_MEASUREMENT_UPDATE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_MEASUREMENT_UPDATE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningMeasurementUpdate, PositioningMeasurementUpdate_sequence);

  return offset;
}


static const per_sequence_t TRPInformationRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2238 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_TRP_INFORMATION_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_TRP_INFORMATION_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPInformationRequest, TRPInformationRequest_sequence);

  return offset;
}


static const per_sequence_t TRPInformationTypeListTRPReq_sequence_of[1] = {
  { &hf_f1ap_TRPInformationTypeListTRPReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_TRPInformationTypeListTRPReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_TRPInformationTypeListTRPReq, TRPInformationTypeListTRPReq_sequence_of,
                                                  1, maxnoofTRPInfoTypes, FALSE);

  return offset;
}


static const per_sequence_t TRPInformationResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPInformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2242 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_TRP_INFORMATION_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_TRP_INFORMATION_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPInformationResponse, TRPInformationResponse_sequence);

  return offset;
}


static const per_sequence_t TRPInformationListTRPResp_sequence_of[1] = {
  { &hf_f1ap_TRPInformationListTRPResp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_TRPInformationListTRPResp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_TRPInformationListTRPResp, TRPInformationListTRPResp_sequence_of,
                                                  1, maxnoofTRPs, FALSE);

  return offset;
}


static const per_sequence_t TRPInformationFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPInformationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2246 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_TRP_INFORMATION_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_TRP_INFORMATION_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPInformationFailure, TRPInformationFailure_sequence);

  return offset;
}


static const per_sequence_t PositioningInformationRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2250 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_INFORMATION_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_INFORMATION_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningInformationRequest, PositioningInformationRequest_sequence);

  return offset;
}


static const per_sequence_t PositioningInformationResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningInformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2254 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_INFORMATION_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_INFORMATION_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningInformationResponse, PositioningInformationResponse_sequence);

  return offset;
}


static const per_sequence_t PositioningInformationFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningInformationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2258 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_INFORMATION_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_INFORMATION_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningInformationFailure, PositioningInformationFailure_sequence);

  return offset;
}


static const per_sequence_t PositioningActivationRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningActivationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2262 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_ACTIVATION_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_ACTIVATION_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningActivationRequest, PositioningActivationRequest_sequence);

  return offset;
}


static const per_sequence_t SemipersistentSRS_sequence[] = {
  { &hf_f1ap_sRSResourceSetID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceSetID },
  { &hf_f1ap_sRSSpatialRelation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SpatialRelationInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SemipersistentSRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SemipersistentSRS, SemipersistentSRS_sequence);

  return offset;
}


static const value_string f1ap_T_aperiodic_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_aperiodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t AperiodicSRS_sequence[] = {
  { &hf_f1ap_aperiodic_04   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_aperiodic },
  { &hf_f1ap_sRSResourceTrigger, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SRSResourceTrigger },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AperiodicSRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AperiodicSRS, AperiodicSRS_sequence);

  return offset;
}


static const value_string f1ap_SRSType_vals[] = {
  {   0, "semipersistentSRS" },
  {   1, "aperiodicSRS" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SRSType_choice[] = {
  {   0, &hf_f1ap_semipersistentSRS, ASN1_NO_EXTENSIONS     , dissect_f1ap_SemipersistentSRS },
  {   1, &hf_f1ap_aperiodicSRS   , ASN1_NO_EXTENSIONS     , dissect_f1ap_AperiodicSRS },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SRSType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SRSType, SRSType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PositioningActivationResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningActivationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2266 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_ACTIVATION_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_ACTIVATION_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningActivationResponse, PositioningActivationResponse_sequence);

  return offset;
}


static const per_sequence_t PositioningActivationFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningActivationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2270 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_ACTIVATION_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_ACTIVATION_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningActivationFailure, PositioningActivationFailure_sequence);

  return offset;
}


static const per_sequence_t PositioningDeactivation_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningDeactivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2274 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_DEACTIVATION);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_DEACTIVATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningDeactivation, PositioningDeactivation_sequence);

  return offset;
}


static const per_sequence_t PositioningInformationUpdate_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PositioningInformationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2302 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_POSITIONING_INFORMATION_UPDATE);
  set_stats_message_type(actx->pinfo, MTYPE_POSITIONING_INFORMATION_UPDATE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PositioningInformationUpdate, PositioningInformationUpdate_sequence);

  return offset;
}


static const per_sequence_t E_CIDMeasurementInitiationRequest_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CIDMeasurementInitiationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2278 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_E_CID_MEASUREMENT_INITIATION_REQUEST);
  set_stats_message_type(actx->pinfo, MTYPE_E_CID_MEASUREMENT_INITIATION_REQUEST);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CIDMeasurementInitiationRequest, E_CIDMeasurementInitiationRequest_sequence);

  return offset;
}


static const per_sequence_t E_CIDMeasurementInitiationResponse_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CIDMeasurementInitiationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2282 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_E_CID_MEASUREMENT_INITIATION_RESPONSE);
  set_stats_message_type(actx->pinfo, MTYPE_E_CID_MEASUREMENT_INITIATION_RESPONSE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CIDMeasurementInitiationResponse, E_CIDMeasurementInitiationResponse_sequence);

  return offset;
}


static const per_sequence_t E_CIDMeasurementInitiationFailure_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CIDMeasurementInitiationFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2286 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_E_CID_MEASUREMENT_INITIATION_FAILURE);
  set_stats_message_type(actx->pinfo, MTYPE_E_CID_MEASUREMENT_INITIATION_FAILURE);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CIDMeasurementInitiationFailure, E_CIDMeasurementInitiationFailure_sequence);

  return offset;
}


static const per_sequence_t E_CIDMeasurementFailureIndication_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CIDMeasurementFailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2290 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_E_CID_MEASUREMENT_FAILURE_INDICATION);
  set_stats_message_type(actx->pinfo, MTYPE_E_CID_MEASUREMENT_FAILURE_INDICATION);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CIDMeasurementFailureIndication, E_CIDMeasurementFailureIndication_sequence);

  return offset;
}


static const per_sequence_t E_CIDMeasurementReport_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CIDMeasurementReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2294 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_E_CID_MEASUREMENT_REPORT);
  set_stats_message_type(actx->pinfo, MTYPE_E_CID_MEASUREMENT_REPORT);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CIDMeasurementReport, E_CIDMeasurementReport_sequence);

  return offset;
}


static const per_sequence_t E_CIDMeasurementTerminationCommand_sequence[] = {
  { &hf_f1ap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CIDMeasurementTerminationCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2298 "./asn1/f1ap/f1ap.cnf"
  set_message_label(actx, MTYPE_E_CID_MEASUREMENT_TERMINATION_COMMAND);
  set_stats_message_type(actx->pinfo, MTYPE_E_CID_MEASUREMENT_TERMINATION_COMMAND);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CIDMeasurementTerminationCommand, E_CIDMeasurementTerminationCommand_sequence);

  return offset;
}



static int
dissect_f1ap_InitiatingMessage_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 81 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->message_type = INITIATING_MESSAGE;

  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_InitiatingMessageValue);

  return offset;
}


static const per_sequence_t InitiatingMessage_sequence[] = {
  { &hf_f1ap_procedureCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProcedureCode },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_initiatingMessagevalue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_InitiatingMessage_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_InitiatingMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_InitiatingMessage, InitiatingMessage_sequence);

  return offset;
}



static int
dissect_f1ap_SuccessfulOutcome_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 85 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->message_type = SUCCESSFUL_OUTCOME;

  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_SuccessfulOutcomeValue);

  return offset;
}


static const per_sequence_t SuccessfulOutcome_sequence[] = {
  { &hf_f1ap_procedureCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProcedureCode },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_successfulOutcome_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SuccessfulOutcome_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SuccessfulOutcome(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SuccessfulOutcome, SuccessfulOutcome_sequence);

  return offset;
}



static int
dissect_f1ap_UnsuccessfulOutcome_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 89 "./asn1/f1ap/f1ap.cnf"
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->message_type = UNSUCCESSFUL_OUTCOME;

  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_UnsuccessfulOutcomeValue);

  return offset;
}


static const per_sequence_t UnsuccessfulOutcome_sequence[] = {
  { &hf_f1ap_procedureCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProcedureCode },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_unsuccessfulOutcome_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_UnsuccessfulOutcome_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UnsuccessfulOutcome(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UnsuccessfulOutcome, UnsuccessfulOutcome_sequence);

  return offset;
}


static const value_string f1ap_F1AP_PDU_vals[] = {
  {   0, "initiatingMessage" },
  {   1, "successfulOutcome" },
  {   2, "unsuccessfulOutcome" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t F1AP_PDU_choice[] = {
  {   0, &hf_f1ap_initiatingMessage, ASN1_NO_EXTENSIONS     , dissect_f1ap_InitiatingMessage },
  {   1, &hf_f1ap_successfulOutcome, ASN1_NO_EXTENSIONS     , dissect_f1ap_SuccessfulOutcome },
  {   2, &hf_f1ap_unsuccessfulOutcome, ASN1_NO_EXTENSIONS     , dissect_f1ap_UnsuccessfulOutcome },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_F1AP_PDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_F1AP_PDU, F1AP_PDU_choice,
                                 NULL);

  return offset;
}

/*--- PDUs ---*/

static int dissect_AbortTransmission_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AbortTransmission(tvb, offset, &asn1_ctx, tree, hf_f1ap_AbortTransmission_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Activated_Cells_to_be_Updated_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Activated_Cells_to_be_Updated_List(tvb, offset, &asn1_ctx, tree, hf_f1ap_Activated_Cells_to_be_Updated_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalDuplicationIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AdditionalDuplicationIndication(tvb, offset, &asn1_ctx, tree, hf_f1ap_AdditionalDuplicationIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalPDCPDuplicationTNL_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AdditionalPDCPDuplicationTNL_List(tvb, offset, &asn1_ctx, tree, hf_f1ap_AdditionalPDCPDuplicationTNL_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalSIBMessageList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AdditionalSIBMessageList(tvb, offset, &asn1_ctx, tree, hf_f1ap_AdditionalSIBMessageList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AdditionalRRMPriorityIndex_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AdditionalRRMPriorityIndex(tvb, offset, &asn1_ctx, tree, hf_f1ap_AdditionalRRMPriorityIndex_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AggressorgNBSetID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AggressorgNBSetID(tvb, offset, &asn1_ctx, tree, hf_f1ap_AggressorgNBSetID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AlternativeQoSParaSetList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AlternativeQoSParaSetList(tvb, offset, &asn1_ctx, tree, hf_f1ap_AlternativeQoSParaSetList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Associated_SCell_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Associated_SCell_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Associated_SCell_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AvailablePLMNList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AvailablePLMNList(tvb, offset, &asn1_ctx, tree, hf_f1ap_AvailablePLMNList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AvailableSNPN_ID_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AvailableSNPN_ID_List(tvb, offset, &asn1_ctx, tree, hf_f1ap_AvailableSNPN_ID_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AreaScope_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_AreaScope(tvb, offset, &asn1_ctx, tree, hf_f1ap_AreaScope_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BAPAddress_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BAPAddress(tvb, offset, &asn1_ctx, tree, hf_f1ap_BAPAddress_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BitRate_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BitRate(tvb, offset, &asn1_ctx, tree, hf_f1ap_BitRate_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BearerTypeChange_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BearerTypeChange(tvb, offset, &asn1_ctx, tree, hf_f1ap_BearerTypeChange_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_FailedToBeModified_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_FailedToBeModified_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_FailedToBeModified_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_FailedToBeSetup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_FailedToBeSetup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_FailedToBeSetup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_FailedToBeSetupMod_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_FailedToBeSetupMod_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_FailedToBeSetupMod_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_Modified_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_Modified_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_Modified_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_Required_ToBeReleased_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_Required_ToBeReleased_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_Required_ToBeReleased_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_Setup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_Setup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_Setup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_SetupMod_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_SetupMod_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_SetupMod_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_ToBeModified_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_ToBeModified_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_ToBeModified_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_ToBeReleased_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_ToBeReleased_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_ToBeReleased_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_ToBeSetup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_ToBeSetup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_ToBeSetup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHChannels_ToBeSetupMod_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHChannels_ToBeSetupMod_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHChannels_ToBeSetupMod_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BHInfo_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BHInfo(tvb, offset, &asn1_ctx, tree, hf_f1ap_BHInfo_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BH_Routing_Information_Added_List_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BH_Routing_Information_Added_List_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BH_Routing_Information_Added_List_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BH_Routing_Information_Removed_List_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BH_Routing_Information_Removed_List_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_BH_Routing_Information_Removed_List_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_BPLMN_ID_Info_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_BPLMN_ID_Info_List(tvb, offset, &asn1_ctx, tree, hf_f1ap_BPLMN_ID_Info_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cancel_all_Warning_Messages_Indicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cancel_all_Warning_Messages_Indicator(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cancel_all_Warning_Messages_Indicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Candidate_SpCell_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Candidate_SpCell_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Candidate_SpCell_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cause_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cause(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cause_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellGroupConfig_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CellGroupConfig(tvb, offset, &asn1_ctx, tree, hf_f1ap_CellGroupConfig_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cell_Direction_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cell_Direction(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cell_Direction_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellMeasurementResultList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CellMeasurementResultList(tvb, offset, &asn1_ctx, tree, hf_f1ap_CellMeasurementResultList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cell_Portion_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cell_Portion_ID(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cell_Portion_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_Failed_to_be_Activated_List_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_Failed_to_be_Activated_List_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_Failed_to_be_Activated_List_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_Status_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_Status_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_Status_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_To_Be_Broadcast_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_To_Be_Broadcast_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_To_Be_Broadcast_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_Broadcast_Completed_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_Broadcast_Completed_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_Broadcast_Completed_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Broadcast_To_Be_Cancelled_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Broadcast_To_Be_Cancelled_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Broadcast_To_Be_Cancelled_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_Broadcast_Cancelled_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_Broadcast_Cancelled_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_Broadcast_Cancelled_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_to_be_Activated_List_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_to_be_Activated_List_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_to_be_Activated_List_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_to_be_Deactivated_List_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_to_be_Deactivated_List_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_to_be_Deactivated_List_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Cells_to_be_Barred_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Cells_to_be_Barred_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Cells_to_be_Barred_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellToReportList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CellToReportList(tvb, offset, &asn1_ctx, tree, hf_f1ap_CellToReportList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellType_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CellType(tvb, offset, &asn1_ctx, tree, hf_f1ap_CellType_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CellULConfigured_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CellULConfigured(tvb, offset, &asn1_ctx, tree, hf_f1ap_CellULConfigured_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Child_Nodes_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Child_Nodes_List(tvb, offset, &asn1_ctx, tree, hf_f1ap_Child_Nodes_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CHO_Probability_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CHO_Probability(tvb, offset, &asn1_ctx, tree, hf_f1ap_CHO_Probability_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ConditionalInterDUMobilityInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ConditionalInterDUMobilityInformation(tvb, offset, &asn1_ctx, tree, hf_f1ap_ConditionalInterDUMobilityInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ConditionalIntraDUMobilityInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ConditionalIntraDUMobilityInformation(tvb, offset, &asn1_ctx, tree, hf_f1ap_ConditionalIntraDUMobilityInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ConfiguredTACIndication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ConfiguredTACIndication(tvb, offset, &asn1_ctx, tree, hf_f1ap_ConfiguredTACIndication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CP_TransportLayerAddress_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CP_TransportLayerAddress(tvb, offset, &asn1_ctx, tree, hf_f1ap_CP_TransportLayerAddress_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CriticalityDiagnostics_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CriticalityDiagnostics(tvb, offset, &asn1_ctx, tree, hf_f1ap_CriticalityDiagnostics_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_C_RNTI_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_C_RNTI(tvb, offset, &asn1_ctx, tree, hf_f1ap_C_RNTI_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CUDURadioInformationType_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CUDURadioInformationType(tvb, offset, &asn1_ctx, tree, hf_f1ap_CUDURadioInformationType_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CUtoDURRCInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CUtoDURRCInformation(tvb, offset, &asn1_ctx, tree, hf_f1ap_CUtoDURRCInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DCBasedDuplicationConfigured_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DCBasedDuplicationConfigured(tvb, offset, &asn1_ctx, tree, hf_f1ap_DCBasedDuplicationConfigured_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Dedicated_SIDelivery_NeededUE_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Dedicated_SIDelivery_NeededUE_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_Dedicated_SIDelivery_NeededUE_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DL_UP_TNL_Address_to_Update_List_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DL_UP_TNL_Address_to_Update_List_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DL_UP_TNL_Address_to_Update_List_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRB_Activity_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRB_Activity_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRB_Activity_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_FailedToBeModified_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_FailedToBeModified_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_FailedToBeModified_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_FailedToBeSetup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_FailedToBeSetup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_FailedToBeSetup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_FailedToBeSetupMod_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_FailedToBeSetupMod_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_FailedToBeSetupMod_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRB_Information_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRB_Information(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRB_Information_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_Modified_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_Modified_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_Modified_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_ModifiedConf_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_ModifiedConf_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_ModifiedConf_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRB_Notify_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRB_Notify_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRB_Notify_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_Required_ToBeModified_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_Required_ToBeModified_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_Required_ToBeModified_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_Required_ToBeReleased_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_Required_ToBeReleased_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_Required_ToBeReleased_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_Setup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_Setup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_Setup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_SetupMod_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_SetupMod_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_SetupMod_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_ToBeModified_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_ToBeModified_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_ToBeModified_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_ToBeReleased_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_ToBeReleased_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_ToBeReleased_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_ToBeSetup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_ToBeSetup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_ToBeSetup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRBs_ToBeSetupMod_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRBs_ToBeSetupMod_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRBs_ToBeSetupMod_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRXCycle_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRXCycle(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRXCycle_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRX_Config_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRX_Config(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRX_Config_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRXConfigurationIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRXConfigurationIndicator(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRXConfigurationIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DRX_LongCycleStartOffset_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DRX_LongCycleStartOffset(tvb, offset, &asn1_ctx, tree, hf_f1ap_DRX_LongCycleStartOffset_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DUtoCURRCContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DUtoCURRCContainer(tvb, offset, &asn1_ctx, tree, hf_f1ap_DUtoCURRCContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DUCURadioInformationType_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DUCURadioInformationType(tvb, offset, &asn1_ctx, tree, hf_f1ap_DUCURadioInformationType_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DUtoCURRCInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DUtoCURRCInformation(tvb, offset, &asn1_ctx, tree, hf_f1ap_DUtoCURRCInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_DuplicationActivation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_DuplicationActivation(tvb, offset, &asn1_ctx, tree, hf_f1ap_DuplicationActivation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_CID_MeasurementQuantities_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_E_CID_MeasurementQuantities(tvb, offset, &asn1_ctx, tree, hf_f1ap_E_CID_MeasurementQuantities_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_CID_MeasurementQuantities_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_E_CID_MeasurementQuantities_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_E_CID_MeasurementQuantities_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_CID_MeasurementResult_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_E_CID_MeasurementResult(tvb, offset, &asn1_ctx, tree, hf_f1ap_E_CID_MeasurementResult_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_E_CID_ReportCharacteristics_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_E_CID_ReportCharacteristics(tvb, offset, &asn1_ctx, tree, hf_f1ap_E_CID_ReportCharacteristics_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExtendedAvailablePLMN_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ExtendedAvailablePLMN_List(tvb, offset, &asn1_ctx, tree, hf_f1ap_ExtendedAvailablePLMN_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExtendedServedPLMNs_List_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ExtendedServedPLMNs_List(tvb, offset, &asn1_ctx, tree, hf_f1ap_ExtendedServedPLMNs_List_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExtendedSliceSupportList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ExtendedSliceSupportList(tvb, offset, &asn1_ctx, tree, hf_f1ap_ExtendedSliceSupportList_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExecuteDuplication_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ExecuteDuplication(tvb, offset, &asn1_ctx, tree, hf_f1ap_ExecuteDuplication_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EUTRA_NR_CellResourceCoordinationReq_Container_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container(tvb, offset, &asn1_ctx, tree, hf_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_EUTRA_NR_CellResourceCoordinationReqAck_Container_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container(tvb, offset, &asn1_ctx, tree, hf_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_ExtendedPacketDelayBudget_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_ExtendedPacketDelayBudget(tvb, offset, &asn1_ctx, tree, hf_f1ap_ExtendedPacketDelayBudget_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_F1CTransferPath_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_F1CTransferPath(tvb, offset, &asn1_ctx, tree, hf_f1ap_F1CTransferPath_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_FrequencyShift7p5khz_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_FrequencyShift7p5khz(tvb, offset, &asn1_ctx, tree, hf_f1ap_FrequencyShift7p5khz_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_FullConfiguration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_FullConfiguration(tvb, offset, &asn1_ctx, tree, hf_f1ap_FullConfiguration_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_CG_Config_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_CG_Config(tvb, offset, &asn1_ctx, tree, hf_f1ap_CG_Config_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNBCUMeasurementID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNBCUMeasurementID(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNBCUMeasurementID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNBDUMeasurementID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNBDUMeasurementID(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNBDUMeasurementID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CUSystemInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CUSystemInformation(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CUSystemInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CU_TNL_Association_Setup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CU_TNL_Association_Setup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CU_TNL_Association_Setup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CU_TNL_Association_Failed_To_Setup_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CU_TNL_Association_To_Add_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CU_TNL_Association_To_Add_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CU_TNL_Association_To_Add_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CU_TNL_Association_To_Remove_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CU_TNL_Association_To_Remove_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CU_TNL_Association_To_Remove_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CU_TNL_Association_To_Update_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CU_TNL_Association_To_Update_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CU_TNL_Association_To_Update_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CU_UE_F1AP_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CU_UE_F1AP_ID(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CU_UE_F1AP_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_DU_UE_F1AP_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_DU_UE_F1AP_ID(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_DU_UE_F1AP_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_DU_ID_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_DU_ID(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_DU_ID_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_CU_Name_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_CU_Name(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_CU_Name_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_DU_Name_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_DU_Name(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_DU_Name_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Extended_GNB_CU_Name_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Extended_GNB_CU_Name(tvb, offset, &asn1_ctx, tree, hf_f1ap_Extended_GNB_CU_Name_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_Extended_GNB_DU_Name_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_Extended_GNB_DU_Name(tvb, offset, &asn1_ctx, tree, hf_f1ap_Extended_GNB_DU_Name_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_DU_Served_Cells_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_DU_Served_Cells_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_DU_Served_Cells_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_DUConfigurationQuery_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_DUConfigurationQuery(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_DUConfigurationQuery_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNBDUOverloadInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNBDUOverloadInformation(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNBDUOverloadInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_GNB_DU_TNL_Association_To_Remove_Item_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_GNB_DU_TNL_Association_To_Remove_Item(tvb, offset, &asn1_ctx, tree, hf_f1ap_GNB_DU_TNL_Association_To_Remove_Item_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HandoverPreparationInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_HandoverPreparationInformation(tvb, offset, &asn1_ctx, tree, hf_f1ap_HandoverPreparationInformation_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_HardwareLoadIndicator_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_HardwareLoadIndicator(tvb, offset, &asn1_ctx, tree, hf_f1ap_HardwareLoadIndicator_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_IAB_Barred_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_IAB_Barred(tvb, offset, &asn1_ctx, tree, hf_f1ap_IAB_Barred_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_IAB_Info_IAB_donor_CU_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, TRUE, pinfo);
  offset = dissect_f1ap_IAB_Info_IAB_donor_CU(tvb, offset, &asn1_ctx, tree, hf_f1ap_IAB_Info_IAB_donor_CU_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_IAB_Info_IAB_DU_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_