/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-nr-rrc.c                                                            */
/* asn2wrs.py -L -p nr-rrc -c ./nr-rrc.cnf -s ./packet-nr-rrc-template -D . -O ../.. NR-InterNodeDefinitions.asn NR-RRC-Definitions.asn NR-UE-Variables.asn */

/* Input file: packet-nr-rrc-template.c */

#line 1 "./asn1/nr-rrc/packet-nr-rrc-template.c"
/* packet-nr-rrc-template.c
 * NR;
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 38.331 V15.7.0 Release 15) packet dissection
 * Copyright 2018-2019, Pascal Quantin
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <stdlib.h>

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/expert.h>
#include <epan/reassemble.h>
#include <epan/exceptions.h>
#include <epan/show_exception.h>
#include <epan/proto_data.h>

#include <wsutil/str_util.h>

#include "packet-per.h"
#include "packet-gsm_map.h"
#include "packet-cell_broadcast.h"
#include "packet-mac-nr.h"
#include "packet-rlc-nr.h"
#include "packet-lte-rrc.h"
#include "packet-nr-rrc.h"
#include "packet-gsm_a_common.h"

#define PNAME  "NR Radio Resource Control (RRC) protocol"
#define PSNAME "NR RRC"
#define PFNAME "nr-rrc"

void proto_register_nr_rrc(void);
void proto_reg_handoff_nr_rrc(void);

static dissector_handle_t nas_5gs_handle = NULL;
static dissector_handle_t lte_rrc_conn_reconf_handle = NULL;
static dissector_handle_t lte_rrc_conn_reconf_compl_handle = NULL;
static dissector_handle_t lte_rrc_ul_dcch_handle = NULL;
static dissector_handle_t lte_rrc_dl_dcch_handle = NULL;

static wmem_map_t *nr_rrc_etws_cmas_dcs_hash = NULL;

static reassembly_table nr_rrc_sib7_reassembly_table;
static reassembly_table nr_rrc_sib8_reassembly_table;

extern int proto_mac_nr;

/* Include constants */

/*--- Included file: packet-nr-rrc-val.h ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-val.h"
#define maxMeasFreqsMN                 32
#define maxMeasFreqsSN                 32
#define maxMeasIdentitiesMN            62
#define maxCellPrep                    32
#define maxBandComb                    65536
#define maxCellBlack                   16
#define maxCellInter                   16
#define maxCellIntra                   16
#define maxCellMeasEUTRA               32
#define maxEARFCN                      262143
#define maxEUTRA_CellBlack             16
#define maxEUTRA_NS_Pmax               8
#define maxMultiBands                  8
#define maxNARFCN                      3279165
#define maxNR_NS_Pmax                  8
#define maxNrofServingCells            32
#define maxNrofServingCells_1          31
#define maxNrofAggregatedCellsPerCellGroup 16
#define maxNrofSCells                  31
#define maxNrofCellMeas                32
#define maxNrofSS_BlocksToAverage      16
#define maxNrofCSI_RS_ResourcesToAverage 16
#define maxNrofDL_Allocations          16
#define maxNrofSR_ConfigPerCellGroup   8
#define maxLCG_ID                      7
#define maxLC_ID                       32
#define maxNrofTAGs                    4
#define maxNrofTAGs_1                  3
#define maxNrofBWPs                    4
#define maxNrofCombIDC                 128
#define maxNrofSymbols_1               13
#define maxNrofSlots                   320
#define maxNrofSlots_1                 319
#define maxNrofPhysicalResourceBlocks  275
#define maxNrofPhysicalResourceBlocks_1 274
#define maxNrofPhysicalResourceBlocksPlus1 276
#define maxNrofControlResourceSets_1   11
#define maxCoReSetDuration             3
#define maxNrofSearchSpaces_1          39
#define maxSFI_DCI_PayloadSize         128
#define maxSFI_DCI_PayloadSize_1       127
#define maxINT_DCI_PayloadSize         126
#define maxINT_DCI_PayloadSize_1       125
#define maxNrofRateMatchPatterns       4
#define maxNrofRateMatchPatterns_1     3
#define maxNrofRateMatchPatternsPerGroup 8
#define maxNrofCSI_ReportConfigurations 48
#define maxNrofCSI_ReportConfigurations_1 47
#define maxNrofCSI_ResourceConfigurations 112
#define maxNrofCSI_ResourceConfigurations_1 111
#define maxNrofAP_CSI_RS_ResourcesPerSet 16
#define maxNrOfCSI_AperiodicTriggers   128
#define maxNrofReportConfigPerAperiodicTrigger 16
#define maxNrofNZP_CSI_RS_Resources    192
#define maxNrofNZP_CSI_RS_Resources_1  191
#define maxNrofNZP_CSI_RS_ResourcesPerSet 64
#define maxNrofNZP_CSI_RS_ResourceSets 64
#define maxNrofNZP_CSI_RS_ResourceSets_1 63
#define maxNrofNZP_CSI_RS_ResourceSetsPerConfig 16
#define maxNrofNZP_CSI_RS_ResourcesPerConfig 128
#define maxNrofZP_CSI_RS_Resources     32
#define maxNrofZP_CSI_RS_Resources_1   31
#define maxNrofZP_CSI_RS_ResourceSets_1 15
#define maxNrofZP_CSI_RS_ResourcesPerSet 16
#define maxNrofZP_CSI_RS_ResourceSets  16
#define maxNrofCSI_IM_Resources        32
#define maxNrofCSI_IM_Resources_1      31
#define maxNrofCSI_IM_ResourcesPerSet  8
#define maxNrofCSI_IM_ResourceSets     64
#define maxNrofCSI_IM_ResourceSets_1   63
#define maxNrofCSI_IM_ResourceSetsPerConfig 16
#define maxNrofCSI_SSB_ResourcePerSet  64
#define maxNrofCSI_SSB_ResourceSets    64
#define maxNrofCSI_SSB_ResourceSets_1  63
#define maxNrofCSI_SSB_ResourceSetsPerConfig 1
#define maxNrofFailureDetectionResources 10
#define maxNrofFailureDetectionResources_1 9
#define maxNrofObjectId                64
#define maxNrofPageRec                 32
#define maxNrofPCI_Ranges              8
#define maxPLMN                        12
#define maxNrofCSI_RS_ResourcesRRM     96
#define maxNrofCSI_RS_ResourcesRRM_1   95
#define maxNrofMeasId                  64
#define maxNrofQuantityConfig          2
#define maxNrofCSI_RS_CellsRRM         96
#define maxNrofSRS_ResourceSets        16
#define maxNrofSRS_ResourceSets_1      15
#define maxNrofSRS_Resources           64
#define maxNrofSRS_Resources_1         63
#define maxNrofSRS_ResourcesPerSet     16
#define maxNrofSRS_TriggerStates_1     3
#define maxNrofSRS_TriggerStates_2     2
#define maxRAT_CapabilityContainers    8
#define maxSimultaneousBands           32
#define maxNrofSlotFormatCombinationsPerSet 512
#define maxNrofSlotFormatCombinationsPerSet_1 511
#define maxNrofPUCCH_Resources         128
#define maxNrofPUCCH_Resources_1       127
#define maxNrofPUCCH_ResourceSets      4
#define maxNrofPUCCH_ResourceSets_1    3
#define maxNrofPUCCH_ResourcesPerSet   32
#define maxNrofPUCCH_P0_PerSet         8
#define maxNrofPUCCH_PathlossReferenceRSs 4
#define maxNrofPUCCH_PathlossReferenceRSs_1 3
#define maxNrofP0_PUSCH_AlphaSets      30
#define maxNrofP0_PUSCH_AlphaSets_1    29
#define maxNrofPUSCH_PathlossReferenceRSs 4
#define maxNrofPUSCH_PathlossReferenceRSs_1 3
#define maxNrofNAICS_Entries           8
#define maxBands                       1024
#define maxBandsMRDC                   1280
#define maxBandsEUTRA                  256
#define maxCellReport                  8
#define maxDRB                         29
#define maxFreq                        8
#define maxFreqIDC_MRDC                32
#define maxNrofCandidateBeams          16
#define maxNrofPCIsPerSMTC             64
#define maxNrofQFIs                    64
#define maxNrOfSemiPersistentPUSCH_Triggers 64
#define maxNrofSR_Resources            8
#define maxNrofSlotFormatsPerCombination 256
#define maxNrofSpatialRelationInfos    8
#define maxNrofIndexesToReport         32
#define maxNrofIndexesToReport2        64
#define maxNrofSSBs_1                  63
#define maxNrofS_NSSAI                 8
#define maxNrofTCI_StatesPDCCH         64
#define maxNrofTCI_States              128
#define maxNrofTCI_States_1            127
#define maxNrofUL_Allocations          16
#define maxQFI                         63
#define maxRA_CSIRS_Resources          96
#define maxRA_OccasionsPerCSIRS        64
#define maxRA_Occasions_1              511
#define maxRA_SSB_Resources            64
#define maxSCSs                        5
#define maxSecondaryCellGroups         3
#define maxNrofServingCellsEUTRA       32
#define maxMBSFN_Allocations           8
#define maxNrofMultiBands              8
#define maxCellSFTD                    3
#define maxReportConfigId              64
#define maxNrofCodebooks               16
#define maxNrofCSI_RS_Resources        7
#define maxNrofSRI_PUSCH_Mappings      16
#define maxNrofSRI_PUSCH_Mappings_1    15
#define maxSIB                         32
#define maxSI_Message                  32
#define maxPO_perPF                    4
#define maxAccessCat_1                 63
#define maxBarringInfoSet              8
#define maxCellEUTRA                   8
#define maxEUTRA_Carrier               8
#define maxPLMNIdentities              8
#define maxDownlinkFeatureSets         1024
#define maxUplinkFeatureSets           1024
#define maxEUTRA_DL_FeatureSets        256
#define maxEUTRA_UL_FeatureSets        256
#define maxFeatureSetsPerBand          128
#define maxPerCC_FeatureSets           1024
#define maxFeatureSetCombinations      1024
#define maxInterRAT_RSTD_Freq          3

typedef enum _RAT_Type_enum {
  RAT_Type_nr  =   0,
  RAT_Type_eutra_nr =   1,
  RAT_Type_eutra =   2,
  RAT_Type_spare1 =   3
} RAT_Type_enum;

typedef enum _T_targetRAT_Type_enum {
  T_targetRAT_Type_eutra =   0,
  T_targetRAT_Type_spare3 =   1,
  T_targetRAT_Type_spare2 =   2,
  T_targetRAT_Type_spare1 =   3
} T_targetRAT_Type_enum;

/*--- End of included file: packet-nr-rrc-val.h ---*/
#line 59 "./asn1/nr-rrc/packet-nr-rrc-template.c"

/* Initialize the protocol and registered fields */
static int proto_nr_rrc = -1;

/*--- Included file: packet-nr-rrc-hf.c ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-hf.c"
static int hf_nr_rrc_nr_rrc_HandoverCommand_PDU = -1;  /* HandoverCommand */
static int hf_nr_rrc_nr_rrc_HandoverPreparationInformation_PDU = -1;  /* HandoverPreparationInformation */
static int hf_nr_rrc_nr_rrc_CG_Config_PDU = -1;   /* CG_Config */
static int hf_nr_rrc_nr_rrc_PH_TypeListSCG_PDU = -1;  /* PH_TypeListSCG */
static int hf_nr_rrc_nr_rrc_BandCombinationIndex_PDU = -1;  /* BandCombinationIndex */
static int hf_nr_rrc_nr_rrc_BandCombinationInfoSN_PDU = -1;  /* BandCombinationInfoSN */
static int hf_nr_rrc_nr_rrc_CG_ConfigInfo_PDU = -1;  /* CG_ConfigInfo */
static int hf_nr_rrc_nr_rrc_ConfigRestrictInfoSCG_PDU = -1;  /* ConfigRestrictInfoSCG */
static int hf_nr_rrc_nr_rrc_PH_TypeListMCG_PDU = -1;  /* PH_TypeListMCG */
static int hf_nr_rrc_nr_rrc_FeatureSetEntryIndex_PDU = -1;  /* FeatureSetEntryIndex */
static int hf_nr_rrc_nr_rrc_MeasurementTimingConfiguration_PDU = -1;  /* MeasurementTimingConfiguration */
static int hf_nr_rrc_nr_rrc_UERadioPagingInformation_PDU = -1;  /* UERadioPagingInformation */
static int hf_nr_rrc_UERadioAccessCapabilityInformation_PDU = -1;  /* UERadioAccessCapabilityInformation */
static int hf_nr_rrc_BCCH_BCH_Message_PDU = -1;   /* BCCH_BCH_Message */
static int hf_nr_rrc_BCCH_DL_SCH_Message_PDU = -1;  /* BCCH_DL_SCH_Message */
static int hf_nr_rrc_DL_CCCH_Message_PDU = -1;    /* DL_CCCH_Message */
static int hf_nr_rrc_DL_DCCH_Message_PDU = -1;    /* DL_DCCH_Message */
static int hf_nr_rrc_PCCH_Message_PDU = -1;       /* PCCH_Message */
static int hf_nr_rrc_UL_CCCH_Message_PDU = -1;    /* UL_CCCH_Message */
static int hf_nr_rrc_UL_CCCH1_Message_PDU = -1;   /* UL_CCCH1_Message */
static int hf_nr_rrc_nr_rrc_UL_DCCH_Message_PDU = -1;  /* UL_DCCH_Message */
static int hf_nr_rrc_nr_rrc_MIB_PDU = -1;         /* MIB */
static int hf_nr_rrc_nr_rrc_RRCReconfiguration_PDU = -1;  /* RRCReconfiguration */
static int hf_nr_rrc_nr_rrc_RRCReconfigurationComplete_PDU = -1;  /* RRCReconfigurationComplete */
static int hf_nr_rrc_nr_rrc_SIB1_PDU = -1;        /* SIB1 */
static int hf_nr_rrc_nr_rrc_UEAssistanceInformation_PDU = -1;  /* UEAssistanceInformation */
static int hf_nr_rrc_nr_rrc_SIB2_PDU = -1;        /* SIB2 */
static int hf_nr_rrc_nr_rrc_SIB3_PDU = -1;        /* SIB3 */
static int hf_nr_rrc_nr_rrc_SIB4_PDU = -1;        /* SIB4 */
static int hf_nr_rrc_nr_rrc_SIB5_PDU = -1;        /* SIB5 */
static int hf_nr_rrc_nr_rrc_SIB6_PDU = -1;        /* SIB6 */
static int hf_nr_rrc_nr_rrc_SIB7_PDU = -1;        /* SIB7 */
static int hf_nr_rrc_nr_rrc_SIB8_PDU = -1;        /* SIB8 */
static int hf_nr_rrc_nr_rrc_SIB9_PDU = -1;        /* SIB9 */
static int hf_nr_rrc_nr_rrc_CellGroupConfig_PDU = -1;  /* CellGroupConfig */
static int hf_nr_rrc_nr_rrc_DRX_Config_PDU = -1;  /* DRX_Config */
static int hf_nr_rrc_nr_rrc_MeasConfig_PDU = -1;  /* MeasConfig */
static int hf_nr_rrc_nr_rrc_MeasGapConfig_PDU = -1;  /* MeasGapConfig */
static int hf_nr_rrc_nr_rrc_MeasResultSCG_Failure_PDU = -1;  /* MeasResultSCG_Failure */
static int hf_nr_rrc_nr_rrc_P_Max_PDU = -1;       /* P_Max */
static int hf_nr_rrc_nr_rrc_RadioBearerConfig_PDU = -1;  /* RadioBearerConfig */
static int hf_nr_rrc_nr_rrc_UplinkTxDirectCurrentList_PDU = -1;  /* UplinkTxDirectCurrentList */
static int hf_nr_rrc_nr_rrc_FreqBandList_PDU = -1;  /* FreqBandList */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRAT_ContainerList_PDU = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRequestFilterCommon_PDU = -1;  /* UE_CapabilityRequestFilterCommon */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRequestFilterNR_PDU = -1;  /* UE_CapabilityRequestFilterNR */
static int hf_nr_rrc_nr_rrc_UE_MRDC_Capability_PDU = -1;  /* UE_MRDC_Capability */
static int hf_nr_rrc_nr_rrc_UE_NR_Capability_PDU = -1;  /* UE_NR_Capability */
static int hf_nr_rrc_MeasResultList2NR_PDU = -1;  /* MeasResultList2NR */
static int hf_nr_rrc_SystemInformation_PDU = -1;  /* SystemInformation */
static int hf_nr_rrc_UECapabilityEnquiry_v1560_IEs_PDU = -1;  /* UECapabilityEnquiry_v1560_IEs */
static int hf_nr_rrc_criticalExtensions = -1;     /* T_criticalExtensions */
static int hf_nr_rrc_c1 = -1;                     /* T_c1 */
static int hf_nr_rrc_handoverCommand = -1;        /* HandoverCommand_IEs */
static int hf_nr_rrc_spare3 = -1;                 /* NULL */
static int hf_nr_rrc_spare2 = -1;                 /* NULL */
static int hf_nr_rrc_spare1 = -1;                 /* NULL */
static int hf_nr_rrc_criticalExtensionsFuture = -1;  /* T_criticalExtensionsFuture */
static int hf_nr_rrc_handoverCommandMessage = -1;  /* T_handoverCommandMessage */
static int hf_nr_rrc_nonCriticalExtension = -1;   /* T_nonCriticalExtension */
static int hf_nr_rrc_criticalExtensions_01 = -1;  /* T_criticalExtensions_01 */
static int hf_nr_rrc_c1_01 = -1;                  /* T_c1_01 */
static int hf_nr_rrc_handoverPreparationInformation = -1;  /* HandoverPreparationInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_01 = -1;  /* T_criticalExtensionsFuture_01 */
static int hf_nr_rrc_ue_CapabilityRAT_List = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_sourceConfig = -1;           /* AS_Config */
static int hf_nr_rrc_rrm_Config = -1;             /* RRM_Config */
static int hf_nr_rrc_as_Context = -1;             /* AS_Context */
static int hf_nr_rrc_nonCriticalExtension_01 = -1;  /* T_nonCriticalExtension_01 */
static int hf_nr_rrc_rrcReconfiguration = -1;     /* T_rrcReconfiguration */
static int hf_nr_rrc_sourceRB_SN_Config = -1;     /* T_sourceRB_SN_Config */
static int hf_nr_rrc_sourceSCG_NR_Config = -1;    /* T_sourceSCG_NR_Config */
static int hf_nr_rrc_sourceSCG_EUTRA_Config = -1;  /* T_sourceSCG_EUTRA_Config */
static int hf_nr_rrc_reestablishmentInfo = -1;    /* ReestablishmentInfo */
static int hf_nr_rrc_configRestrictInfo = -1;     /* ConfigRestrictInfoSCG */
static int hf_nr_rrc_ran_NotificationAreaInfo = -1;  /* RAN_NotificationAreaInfo */
static int hf_nr_rrc_ueAssistanceInformation = -1;  /* T_ueAssistanceInformation */
static int hf_nr_rrc_selectedBandCombinationSN = -1;  /* BandCombinationInfoSN */
static int hf_nr_rrc_sourcePhysCellId = -1;       /* PhysCellId */
static int hf_nr_rrc_targetCellShortMAC_I = -1;   /* ShortMAC_I */
static int hf_nr_rrc_additionalReestabInfoList = -1;  /* ReestabNCellInfoList */
static int hf_nr_rrc_ReestabNCellInfoList_item = -1;  /* ReestabNCellInfo */
static int hf_nr_rrc_cellIdentity = -1;           /* CellIdentity */
static int hf_nr_rrc_key_gNodeB_Star = -1;        /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_shortMAC_I = -1;             /* ShortMAC_I */
static int hf_nr_rrc_ue_InactiveTime = -1;        /* T_ue_InactiveTime */
static int hf_nr_rrc_candidateCellInfoList = -1;  /* MeasResultList2NR */
static int hf_nr_rrc_candidateCellInfoListSN_EUTRA = -1;  /* MeasResultServFreqListEUTRA_SCG */
static int hf_nr_rrc_criticalExtensions_02 = -1;  /* T_criticalExtensions_02 */
static int hf_nr_rrc_c1_02 = -1;                  /* T_c1_02 */
static int hf_nr_rrc_cg_Config = -1;              /* CG_Config_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_02 = -1;  /* T_criticalExtensionsFuture_02 */
static int hf_nr_rrc_scg_CellGroupConfig = -1;    /* T_scg_CellGroupConfig */
static int hf_nr_rrc_scg_RB_Config = -1;          /* T_scg_RB_Config */
static int hf_nr_rrc_configRestrictModReq = -1;   /* ConfigRestrictModReqSCG */
static int hf_nr_rrc_drx_InfoSCG = -1;            /* DRX_Info */
static int hf_nr_rrc_candidateCellInfoListSN = -1;  /* T_candidateCellInfoListSN */
static int hf_nr_rrc_measConfigSN = -1;           /* MeasConfigSN */
static int hf_nr_rrc_selectedBandCombination = -1;  /* BandCombinationInfoSN */
static int hf_nr_rrc_fr_InfoListSCG = -1;         /* FR_InfoList */
static int hf_nr_rrc_candidateServingFreqListNR = -1;  /* CandidateServingFreqListNR */
static int hf_nr_rrc_nonCriticalExtension_02 = -1;  /* CG_Config_v1540_IEs */
static int hf_nr_rrc_pSCellFrequency = -1;        /* ARFCN_ValueNR */
static int hf_nr_rrc_reportCGI_RequestNR = -1;    /* T_reportCGI_RequestNR */
static int hf_nr_rrc_requestedCellInfo = -1;      /* T_requestedCellInfo */
static int hf_nr_rrc_ssbFrequency = -1;           /* ARFCN_ValueNR */
static int hf_nr_rrc_cellForWhichToReportCGI = -1;  /* PhysCellId */
static int hf_nr_rrc_ph_InfoSCG = -1;             /* PH_TypeListSCG */
static int hf_nr_rrc_nonCriticalExtension_03 = -1;  /* CG_Config_v1560_IEs */
static int hf_nr_rrc_pSCellFrequencyEUTRA = -1;   /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_scg_CellGroupConfigEUTRA = -1;  /* T_scg_CellGroupConfigEUTRA */
static int hf_nr_rrc_candidateCellInfoListSN_EUTRA_01 = -1;  /* T_candidateCellInfoListSN_EUTRA */
static int hf_nr_rrc_candidateServingFreqListEUTRA = -1;  /* CandidateServingFreqListEUTRA */
static int hf_nr_rrc_needForGaps = -1;            /* T_needForGaps */
static int hf_nr_rrc_drx_ConfigSCG = -1;          /* DRX_Config */
static int hf_nr_rrc_reportCGI_RequestEUTRA = -1;  /* T_reportCGI_RequestEUTRA */
static int hf_nr_rrc_requestedCellInfoEUTRA = -1;  /* T_requestedCellInfoEUTRA */
static int hf_nr_rrc_eutraFrequency = -1;         /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_cellForWhichToReportCGI_EUTRA = -1;  /* EUTRA_PhysCellId */
static int hf_nr_rrc_nonCriticalExtension_04 = -1;  /* T_nonCriticalExtension_02 */
static int hf_nr_rrc_PH_TypeListSCG_item = -1;    /* PH_InfoSCG */
static int hf_nr_rrc_servCellIndex = -1;          /* ServCellIndex */
static int hf_nr_rrc_ph_Uplink = -1;              /* PH_UplinkCarrierSCG */
static int hf_nr_rrc_ph_SupplementaryUplink = -1;  /* PH_UplinkCarrierSCG */
static int hf_nr_rrc_ph_Type1or3 = -1;            /* T_ph_Type1or3 */
static int hf_nr_rrc_measuredFrequenciesSN = -1;  /* SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo */
static int hf_nr_rrc_measuredFrequenciesSN_item = -1;  /* NR_FreqInfo */
static int hf_nr_rrc_measuredFrequency = -1;      /* ARFCN_ValueNR */
static int hf_nr_rrc_requestedBC_MRDC = -1;       /* BandCombinationInfoSN */
static int hf_nr_rrc_requestedP_MaxFR1 = -1;      /* P_Max */
static int hf_nr_rrc_requestedPDCCH_BlindDetectionSCG = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_requestedP_MaxEUTRA = -1;    /* P_Max */
static int hf_nr_rrc_bandCombinationIndex = -1;   /* BandCombinationIndex */
static int hf_nr_rrc_requestedFeatureSets = -1;   /* FeatureSetEntryIndex */
static int hf_nr_rrc_FR_InfoList_item = -1;       /* FR_Info */
static int hf_nr_rrc_fr_Type = -1;                /* T_fr_Type */
static int hf_nr_rrc_CandidateServingFreqListNR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_CandidateServingFreqListEUTRA_item = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_criticalExtensions_03 = -1;  /* T_criticalExtensions_03 */
static int hf_nr_rrc_c1_03 = -1;                  /* T_c1_03 */
static int hf_nr_rrc_cg_ConfigInfo = -1;          /* CG_ConfigInfo_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_03 = -1;  /* T_criticalExtensionsFuture_03 */
static int hf_nr_rrc_ue_CapabilityInfo = -1;      /* T_ue_CapabilityInfo */
static int hf_nr_rrc_candidateCellInfoListMN = -1;  /* MeasResultList2NR */
static int hf_nr_rrc_candidateCellInfoListSN_01 = -1;  /* T_candidateCellInfoListSN_01 */
static int hf_nr_rrc_measResultCellListSFTD_NR = -1;  /* MeasResultCellListSFTD_NR */
static int hf_nr_rrc_scgFailureInfo = -1;         /* T_scgFailureInfo */
static int hf_nr_rrc_failureType = -1;            /* T_failureType */
static int hf_nr_rrc_measResultSCG = -1;          /* T_measResultSCG */
static int hf_nr_rrc_drx_InfoMCG = -1;            /* DRX_Info */
static int hf_nr_rrc_measConfigMN = -1;           /* MeasConfigMN */
static int hf_nr_rrc_sourceConfigSCG = -1;        /* T_sourceConfigSCG */
static int hf_nr_rrc_scg_RB_Config_01 = -1;       /* T_scg_RB_Config_01 */
static int hf_nr_rrc_mcg_RB_Config = -1;          /* T_mcg_RB_Config */
static int hf_nr_rrc_mrdc_AssistanceInfo = -1;    /* MRDC_AssistanceInfo */
static int hf_nr_rrc_nonCriticalExtension_05 = -1;  /* CG_ConfigInfo_v1540_IEs */
static int hf_nr_rrc_ph_InfoMCG = -1;             /* PH_TypeListMCG */
static int hf_nr_rrc_measResultReportCGI = -1;    /* T_measResultReportCGI */
static int hf_nr_rrc_cgi_Info = -1;               /* CGI_InfoNR */
static int hf_nr_rrc_nonCriticalExtension_06 = -1;  /* CG_ConfigInfo_v1560_IEs */
static int hf_nr_rrc_candidateCellInfoListMN_EUTRA = -1;  /* T_candidateCellInfoListMN_EUTRA */
static int hf_nr_rrc_candidateCellInfoListSN_EUTRA_02 = -1;  /* T_candidateCellInfoListSN_EUTRA_01 */
static int hf_nr_rrc_sourceConfigSCG_EUTRA = -1;  /* T_sourceConfigSCG_EUTRA */
static int hf_nr_rrc_scgFailureInfoEUTRA = -1;    /* T_scgFailureInfoEUTRA */
static int hf_nr_rrc_failureTypeEUTRA = -1;       /* T_failureTypeEUTRA */
static int hf_nr_rrc_measResultSCG_EUTRA = -1;    /* OCTET_STRING */
static int hf_nr_rrc_drx_ConfigMCG = -1;          /* DRX_Config */
static int hf_nr_rrc_measResultReportCGI_EUTRA = -1;  /* T_measResultReportCGI_EUTRA */
static int hf_nr_rrc_cgi_InfoEUTRA = -1;          /* CGI_InfoEUTRA */
static int hf_nr_rrc_measResultCellListSFTD_EUTRA = -1;  /* MeasResultCellListSFTD_EUTRA */
static int hf_nr_rrc_fr_InfoListMCG = -1;         /* FR_InfoList */
static int hf_nr_rrc_nonCriticalExtension_07 = -1;  /* CG_ConfigInfo_v1570_IEs */
static int hf_nr_rrc_sftdFrequencyList_NR = -1;   /* SFTD_FrequencyList_NR */
static int hf_nr_rrc_sftdFrequencyList_EUTRA = -1;  /* SFTD_FrequencyList_EUTRA */
static int hf_nr_rrc_nonCriticalExtension_08 = -1;  /* T_nonCriticalExtension_03 */
static int hf_nr_rrc_SFTD_FrequencyList_NR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_SFTD_FrequencyList_EUTRA_item = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_allowedBC_ListMRDC = -1;     /* BandCombinationInfoList */
static int hf_nr_rrc_powerCoordination_FR1 = -1;  /* T_powerCoordination_FR1 */
static int hf_nr_rrc_p_maxNR_FR1 = -1;            /* P_Max */
static int hf_nr_rrc_p_maxEUTRA = -1;             /* P_Max */
static int hf_nr_rrc_p_maxUE_FR1 = -1;            /* P_Max */
static int hf_nr_rrc_servCellIndexRangeSCG = -1;  /* T_servCellIndexRangeSCG */
static int hf_nr_rrc_lowBound = -1;               /* ServCellIndex */
static int hf_nr_rrc_upBound = -1;                /* ServCellIndex */
static int hf_nr_rrc_maxMeasFreqsSCG = -1;        /* INTEGER_1_maxMeasFreqsMN */
static int hf_nr_rrc_maxMeasIdentitiesSCG_NR = -1;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_selectedBandEntriesMNList = -1;  /* SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN */
static int hf_nr_rrc_selectedBandEntriesMNList_item = -1;  /* SelectedBandEntriesMN */
static int hf_nr_rrc_pdcch_BlindDetectionSCG = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_maxNumberROHC_ContextSessionsSN = -1;  /* INTEGER_0_16384 */
static int hf_nr_rrc_SelectedBandEntriesMN_item = -1;  /* BandEntryIndex */
static int hf_nr_rrc_PH_TypeListMCG_item = -1;    /* PH_InfoMCG */
static int hf_nr_rrc_ph_Uplink_01 = -1;           /* PH_UplinkCarrierMCG */
static int hf_nr_rrc_ph_SupplementaryUplink_01 = -1;  /* PH_UplinkCarrierMCG */
static int hf_nr_rrc_ph_Type1or3_01 = -1;         /* T_ph_Type1or3_01 */
static int hf_nr_rrc_BandCombinationInfoList_item = -1;  /* BandCombinationInfo */
static int hf_nr_rrc_allowedFeatureSetsList = -1;  /* SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex */
static int hf_nr_rrc_allowedFeatureSetsList_item = -1;  /* FeatureSetEntryIndex */
static int hf_nr_rrc_drx_LongCycleStartOffset = -1;  /* T_drx_LongCycleStartOffset */
static int hf_nr_rrc_ms10 = -1;                   /* INTEGER_0_9 */
static int hf_nr_rrc_ms20 = -1;                   /* INTEGER_0_19 */
static int hf_nr_rrc_ms32 = -1;                   /* INTEGER_0_31 */
static int hf_nr_rrc_ms40 = -1;                   /* INTEGER_0_39 */
static int hf_nr_rrc_ms60 = -1;                   /* INTEGER_0_59 */
static int hf_nr_rrc_ms64 = -1;                   /* INTEGER_0_63 */
static int hf_nr_rrc_ms70 = -1;                   /* INTEGER_0_69 */
static int hf_nr_rrc_ms80 = -1;                   /* INTEGER_0_79 */
static int hf_nr_rrc_ms128 = -1;                  /* INTEGER_0_127 */
static int hf_nr_rrc_ms160 = -1;                  /* INTEGER_0_159 */
static int hf_nr_rrc_ms256 = -1;                  /* INTEGER_0_255 */
static int hf_nr_rrc_ms320 = -1;                  /* INTEGER_0_319 */
static int hf_nr_rrc_ms512 = -1;                  /* INTEGER_0_511 */
static int hf_nr_rrc_ms640 = -1;                  /* INTEGER_0_639 */
static int hf_nr_rrc_ms1024 = -1;                 /* INTEGER_0_1023 */
static int hf_nr_rrc_ms1280 = -1;                 /* INTEGER_0_1279 */
static int hf_nr_rrc_ms2048 = -1;                 /* INTEGER_0_2047 */
static int hf_nr_rrc_ms2560 = -1;                 /* INTEGER_0_2559 */
static int hf_nr_rrc_ms5120 = -1;                 /* INTEGER_0_5119 */
static int hf_nr_rrc_ms10240 = -1;                /* INTEGER_0_10239 */
static int hf_nr_rrc_shortDRX = -1;               /* T_shortDRX */
static int hf_nr_rrc_drx_ShortCycle = -1;         /* T_drx_ShortCycle */
static int hf_nr_rrc_drx_ShortCycleTimer = -1;    /* INTEGER_1_16 */
static int hf_nr_rrc_measuredFrequenciesMN = -1;  /* SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo */
static int hf_nr_rrc_measuredFrequenciesMN_item = -1;  /* NR_FreqInfo */
static int hf_nr_rrc_measGapConfig = -1;          /* T_measGapConfig */
static int hf_nr_rrc_release = -1;                /* NULL */
static int hf_nr_rrc_setup = -1;                  /* GapConfig */
static int hf_nr_rrc_gapPurpose = -1;             /* T_gapPurpose */
static int hf_nr_rrc_measGapConfigFR2 = -1;       /* T_measGapConfigFR2 */
static int hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC = -1;  /* SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC_item = -1;  /* AffectedCarrierFreqCombInfoMRDC */
static int hf_nr_rrc_victimSystemType = -1;       /* VictimSystemType */
static int hf_nr_rrc_interferenceDirectionMRDC = -1;  /* T_interferenceDirectionMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombMRDC = -1;  /* T_affectedCarrierFreqCombMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombEUTRA = -1;  /* AffectedCarrierFreqCombEUTRA */
static int hf_nr_rrc_affectedCarrierFreqCombNR = -1;  /* AffectedCarrierFreqCombNR */
static int hf_nr_rrc_gps = -1;                    /* T_gps */
static int hf_nr_rrc_glonass = -1;                /* T_glonass */
static int hf_nr_rrc_bds = -1;                    /* T_bds */
static int hf_nr_rrc_galileo = -1;                /* T_galileo */
static int hf_nr_rrc_wlan = -1;                   /* T_wlan */
static int hf_nr_rrc_bluetooth = -1;              /* T_bluetooth */
static int hf_nr_rrc_AffectedCarrierFreqCombEUTRA_item = -1;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_AffectedCarrierFreqCombNR_item = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_criticalExtensions_04 = -1;  /* T_criticalExtensions_04 */
static int hf_nr_rrc_c1_04 = -1;                  /* T_c1_04 */
static int hf_nr_rrc_measTimingConf = -1;         /* MeasurementTimingConfiguration_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_04 = -1;  /* T_criticalExtensionsFuture_04 */
static int hf_nr_rrc_measTiming = -1;             /* MeasTimingList */
static int hf_nr_rrc_nonCriticalExtension_09 = -1;  /* MeasurementTimingConfiguration_v1550_IEs */
static int hf_nr_rrc_campOnFirstSSB = -1;         /* BOOLEAN */
static int hf_nr_rrc_psCellOnlyOnFirstSSB = -1;   /* BOOLEAN */
static int hf_nr_rrc_nonCriticalExtension_10 = -1;  /* T_nonCriticalExtension_04 */
static int hf_nr_rrc_MeasTimingList_item = -1;    /* MeasTiming */
static int hf_nr_rrc_frequencyAndTiming = -1;     /* T_frequencyAndTiming */
static int hf_nr_rrc_carrierFreq = -1;            /* ARFCN_ValueNR */
static int hf_nr_rrc_ssbSubcarrierSpacing = -1;   /* SubcarrierSpacing */
static int hf_nr_rrc_ssb_MeasurementTimingConfiguration = -1;  /* SSB_MTC */
static int hf_nr_rrc_ss_RSSI_Measurement = -1;    /* SS_RSSI_Measurement */
static int hf_nr_rrc_ssb_ToMeasure_v1540 = -1;    /* SSB_ToMeasure */
static int hf_nr_rrc_physCellId = -1;             /* PhysCellId */
static int hf_nr_rrc_criticalExtensions_05 = -1;  /* T_criticalExtensions_05 */
static int hf_nr_rrc_c1_05 = -1;                  /* T_c1_05 */
static int hf_nr_rrc_ueRadioPagingInformation = -1;  /* UERadioPagingInformation_IEs */
static int hf_nr_rrc_spare7 = -1;                 /* NULL */
static int hf_nr_rrc_spare6 = -1;                 /* NULL */
static int hf_nr_rrc_spare5 = -1;                 /* NULL */
static int hf_nr_rrc_spare4 = -1;                 /* NULL */
static int hf_nr_rrc_criticalExtensionsFuture_05 = -1;  /* T_criticalExtensionsFuture_05 */
static int hf_nr_rrc_supportedBandListNRForPaging = -1;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_supportedBandListNRForPaging_item = -1;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_nonCriticalExtension_11 = -1;  /* T_nonCriticalExtension_05 */
static int hf_nr_rrc_criticalExtensions_06 = -1;  /* T_criticalExtensions_06 */
static int hf_nr_rrc_c1_06 = -1;                  /* T_c1_06 */
static int hf_nr_rrc_ueRadioAccessCapabilityInformation = -1;  /* UERadioAccessCapabilityInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_06 = -1;  /* T_criticalExtensionsFuture_06 */
static int hf_nr_rrc_ue_RadioAccessCapabilityInfo = -1;  /* T_ue_RadioAccessCapabilityInfo */
static int hf_nr_rrc_nonCriticalExtension_12 = -1;  /* T_nonCriticalExtension_06 */
static int hf_nr_rrc_message = -1;                /* BCCH_BCH_MessageType */
static int hf_nr_rrc_mib = -1;                    /* MIB */
static int hf_nr_rrc_messageClassExtension = -1;  /* T_messageClassExtension */
static int hf_nr_rrc_message_01 = -1;             /* BCCH_DL_SCH_MessageType */
static int hf_nr_rrc_c1_07 = -1;                  /* T_c1_07 */
static int hf_nr_rrc_systemInformation = -1;      /* SystemInformation */
static int hf_nr_rrc_systemInformationBlockType1 = -1;  /* SIB1 */
static int hf_nr_rrc_messageClassExtension_01 = -1;  /* T_messageClassExtension_01 */
static int hf_nr_rrc_message_02 = -1;             /* DL_CCCH_MessageType */
static int hf_nr_rrc_c1_08 = -1;                  /* T_c1_08 */
static int hf_nr_rrc_rrcReject = -1;              /* RRCReject */
static int hf_nr_rrc_rrcSetup = -1;               /* RRCSetup */
static int hf_nr_rrc_messageClassExtension_02 = -1;  /* T_messageClassExtension_02 */
static int hf_nr_rrc_message_03 = -1;             /* DL_DCCH_MessageType */
static int hf_nr_rrc_c1_09 = -1;                  /* T_c1_09 */
static int hf_nr_rrc_rrcReconfiguration_01 = -1;  /* RRCReconfiguration */
static int hf_nr_rrc_rrcResume = -1;              /* RRCResume */
static int hf_nr_rrc_rrcRelease = -1;             /* RRCRelease */
static int hf_nr_rrc_rrcReestablishment = -1;     /* RRCReestablishment */
static int hf_nr_rrc_securityModeCommand = -1;    /* SecurityModeCommand */
static int hf_nr_rrc_dlInformationTransfer = -1;  /* DLInformationTransfer */
static int hf_nr_rrc_ueCapabilityEnquiry = -1;    /* UECapabilityEnquiry */
static int hf_nr_rrc_counterCheck = -1;           /* CounterCheck */
static int hf_nr_rrc_mobilityFromNRCommand = -1;  /* MobilityFromNRCommand */
static int hf_nr_rrc_messageClassExtension_03 = -1;  /* T_messageClassExtension_03 */
static int hf_nr_rrc_message_04 = -1;             /* PCCH_MessageType */
static int hf_nr_rrc_c1_10 = -1;                  /* T_c1_10 */
static int hf_nr_rrc_paging = -1;                 /* Paging */
static int hf_nr_rrc_messageClassExtension_04 = -1;  /* T_messageClassExtension_04 */
static int hf_nr_rrc_message_05 = -1;             /* UL_CCCH_MessageType */
static int hf_nr_rrc_c1_11 = -1;                  /* T_c1_11 */
static int hf_nr_rrc_rrcSetupRequest = -1;        /* RRCSetupRequest */
static int hf_nr_rrc_rrcResumeRequest = -1;       /* RRCResumeRequest */
static int hf_nr_rrc_rrcReestablishmentRequest = -1;  /* RRCReestablishmentRequest */
static int hf_nr_rrc_rrcSystemInfoRequest = -1;   /* RRCSystemInfoRequest */
static int hf_nr_rrc_messageClassExtension_05 = -1;  /* T_messageClassExtension_05 */
static int hf_nr_rrc_message_06 = -1;             /* UL_CCCH1_MessageType */
static int hf_nr_rrc_c1_12 = -1;                  /* T_c1_12 */
static int hf_nr_rrc_rrcResumeRequest1 = -1;      /* RRCResumeRequest1 */
static int hf_nr_rrc_messageClassExtension_06 = -1;  /* T_messageClassExtension_06 */
static int hf_nr_rrc_message_07 = -1;             /* UL_DCCH_MessageType */
static int hf_nr_rrc_c1_13 = -1;                  /* T_c1_13 */
static int hf_nr_rrc_measurementReport = -1;      /* MeasurementReport */
static int hf_nr_rrc_rrcReconfigurationComplete = -1;  /* RRCReconfigurationComplete */
static int hf_nr_rrc_rrcSetupComplete = -1;       /* RRCSetupComplete */
static int hf_nr_rrc_rrcReestablishmentComplete = -1;  /* RRCReestablishmentComplete */
static int hf_nr_rrc_rrcResumeComplete = -1;      /* RRCResumeComplete */
static int hf_nr_rrc_securityModeComplete = -1;   /* SecurityModeComplete */
static int hf_nr_rrc_securityModeFailure = -1;    /* SecurityModeFailure */
static int hf_nr_rrc_ulInformationTransfer = -1;  /* ULInformationTransfer */
static int hf_nr_rrc_locationMeasurementIndication = -1;  /* LocationMeasurementIndication */
static int hf_nr_rrc_ueCapabilityInformation = -1;  /* UECapabilityInformation */
static int hf_nr_rrc_counterCheckResponse = -1;   /* CounterCheckResponse */
static int hf_nr_rrc_ueAssistanceInformation_01 = -1;  /* UEAssistanceInformation */
static int hf_nr_rrc_failureInformation = -1;     /* FailureInformation */
static int hf_nr_rrc_ulInformationTransferMRDC = -1;  /* ULInformationTransferMRDC */
static int hf_nr_rrc_scgFailureInformation = -1;  /* SCGFailureInformation */
static int hf_nr_rrc_scgFailureInformationEUTRA = -1;  /* SCGFailureInformationEUTRA */
static int hf_nr_rrc_messageClassExtension_07 = -1;  /* T_messageClassExtension_07 */
static int hf_nr_rrc_rrc_TransactionIdentifier = -1;  /* RRC_TransactionIdentifier */
static int hf_nr_rrc_criticalExtensions_07 = -1;  /* T_criticalExtensions_07 */
static int hf_nr_rrc_counterCheck_01 = -1;        /* CounterCheck_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_07 = -1;  /* T_criticalExtensionsFuture_07 */
static int hf_nr_rrc_drb_CountMSB_InfoList = -1;  /* DRB_CountMSB_InfoList */
static int hf_nr_rrc_lateNonCriticalExtension = -1;  /* OCTET_STRING */
static int hf_nr_rrc_nonCriticalExtension_13 = -1;  /* T_nonCriticalExtension_07 */
static int hf_nr_rrc_DRB_CountMSB_InfoList_item = -1;  /* DRB_CountMSB_Info */
static int hf_nr_rrc_drb_Identity = -1;           /* DRB_Identity */
static int hf_nr_rrc_countMSB_Uplink = -1;        /* INTEGER_0_33554431 */
static int hf_nr_rrc_countMSB_Downlink = -1;      /* INTEGER_0_33554431 */
static int hf_nr_rrc_criticalExtensions_08 = -1;  /* T_criticalExtensions_08 */
static int hf_nr_rrc_counterCheckResponse_01 = -1;  /* CounterCheckResponse_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_08 = -1;  /* T_criticalExtensionsFuture_08 */
static int hf_nr_rrc_drb_CountInfoList = -1;      /* DRB_CountInfoList */
static int hf_nr_rrc_nonCriticalExtension_14 = -1;  /* T_nonCriticalExtension_08 */
static int hf_nr_rrc_DRB_CountInfoList_item = -1;  /* DRB_CountInfo */
static int hf_nr_rrc_count_Uplink = -1;           /* INTEGER_0_4294967295 */
static int hf_nr_rrc_count_Downlink = -1;         /* INTEGER_0_4294967295 */
static int hf_nr_rrc_criticalExtensions_09 = -1;  /* T_criticalExtensions_09 */
static int hf_nr_rrc_dlInformationTransfer_01 = -1;  /* DLInformationTransfer_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_09 = -1;  /* T_criticalExtensionsFuture_09 */
static int hf_nr_rrc_dedicatedNAS_Message = -1;   /* DedicatedNAS_Message */
static int hf_nr_rrc_nonCriticalExtension_15 = -1;  /* T_nonCriticalExtension_09 */
static int hf_nr_rrc_criticalExtensions_10 = -1;  /* T_criticalExtensions_10 */
static int hf_nr_rrc_failureInformation_01 = -1;  /* FailureInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_10 = -1;  /* T_criticalExtensionsFuture_10 */
static int hf_nr_rrc_failureInfoRLC_Bearer = -1;  /* FailureInfoRLC_Bearer */
static int hf_nr_rrc_nonCriticalExtension_16 = -1;  /* T_nonCriticalExtension_10 */
static int hf_nr_rrc_cellGroupId = -1;            /* CellGroupId */
static int hf_nr_rrc_logicalChannelIdentity = -1;  /* LogicalChannelIdentity */
static int hf_nr_rrc_failureType_01 = -1;         /* T_failureType_01 */
static int hf_nr_rrc_criticalExtensions_11 = -1;  /* T_criticalExtensions_11 */
static int hf_nr_rrc_locationMeasurementIndication_01 = -1;  /* LocationMeasurementIndication_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_11 = -1;  /* T_criticalExtensionsFuture_11 */
static int hf_nr_rrc_measurementIndication = -1;  /* T_measurementIndication */
static int hf_nr_rrc_setup_01 = -1;               /* LocationMeasurementInfo */
static int hf_nr_rrc_nonCriticalExtension_17 = -1;  /* T_nonCriticalExtension_11 */
static int hf_nr_rrc_criticalExtensions_12 = -1;  /* T_criticalExtensions_12 */
static int hf_nr_rrc_measurementReport_01 = -1;   /* MeasurementReport_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_12 = -1;  /* T_criticalExtensionsFuture_12 */
static int hf_nr_rrc_measResults = -1;            /* MeasResults */
static int hf_nr_rrc_nonCriticalExtension_18 = -1;  /* T_nonCriticalExtension_12 */
static int hf_nr_rrc_systemFrameNumber = -1;      /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_subCarrierSpacingCommon = -1;  /* T_subCarrierSpacingCommon */
static int hf_nr_rrc_ssb_SubcarrierOffset = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_dmrs_TypeA_Position = -1;    /* T_dmrs_TypeA_Position */
static int hf_nr_rrc_pdcch_ConfigSIB1 = -1;       /* PDCCH_ConfigSIB1 */
static int hf_nr_rrc_cellBarred = -1;             /* T_cellBarred */
static int hf_nr_rrc_intraFreqReselection = -1;   /* T_intraFreqReselection */
static int hf_nr_rrc_spare = -1;                  /* BIT_STRING_SIZE_1 */
static int hf_nr_rrc_criticalExtensions_13 = -1;  /* T_criticalExtensions_13 */
static int hf_nr_rrc_mobilityFromNRCommand_01 = -1;  /* MobilityFromNRCommand_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_13 = -1;  /* T_criticalExtensionsFuture_13 */
static int hf_nr_rrc_targetRAT_Type = -1;         /* T_targetRAT_Type */
static int hf_nr_rrc_targetRAT_MessageContainer = -1;  /* T_targetRAT_MessageContainer */
static int hf_nr_rrc_nas_SecurityParamFromNR = -1;  /* T_nas_SecurityParamFromNR */
static int hf_nr_rrc_nonCriticalExtension_19 = -1;  /* T_nonCriticalExtension_13 */
static int hf_nr_rrc_pagingRecordList = -1;       /* PagingRecordList */
static int hf_nr_rrc_nonCriticalExtension_20 = -1;  /* T_nonCriticalExtension_14 */
static int hf_nr_rrc_PagingRecordList_item = -1;  /* PagingRecord */
static int hf_nr_rrc_ue_Identity = -1;            /* PagingUE_Identity */
static int hf_nr_rrc_accessType = -1;             /* T_accessType */
static int hf_nr_rrc_ng_5G_S_TMSI = -1;           /* NG_5G_S_TMSI */
static int hf_nr_rrc_fullI_RNTI = -1;             /* I_RNTI_Value */
static int hf_nr_rrc_criticalExtensions_14 = -1;  /* T_criticalExtensions_14 */
static int hf_nr_rrc_rrcReestablishment_01 = -1;  /* RRCReestablishment_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_14 = -1;  /* T_criticalExtensionsFuture_14 */
static int hf_nr_rrc_nextHopChainingCount = -1;   /* NextHopChainingCount */
static int hf_nr_rrc_nonCriticalExtension_21 = -1;  /* T_nonCriticalExtension_15 */
static int hf_nr_rrc_criticalExtensions_15 = -1;  /* T_criticalExtensions_15 */
static int hf_nr_rrc_rrcReestablishmentComplete_01 = -1;  /* RRCReestablishmentComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_15 = -1;  /* T_criticalExtensionsFuture_15 */
static int hf_nr_rrc_nonCriticalExtension_22 = -1;  /* T_nonCriticalExtension_16 */
static int hf_nr_rrc_rrcReestablishmentRequest_01 = -1;  /* RRCReestablishmentRequest_IEs */
static int hf_nr_rrc_ue_Identity_01 = -1;         /* ReestabUE_Identity */
static int hf_nr_rrc_reestablishmentCause = -1;   /* ReestablishmentCause */
static int hf_nr_rrc_c_RNTI = -1;                 /* RNTI_Value */
static int hf_nr_rrc_criticalExtensions_16 = -1;  /* T_criticalExtensions_16 */
static int hf_nr_rrc_rrcReconfiguration_02 = -1;  /* RRCReconfiguration_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_16 = -1;  /* T_criticalExtensionsFuture_16 */
static int hf_nr_rrc_radioBearerConfig = -1;      /* RadioBearerConfig */
static int hf_nr_rrc_secondaryCellGroup = -1;     /* T_secondaryCellGroup */
static int hf_nr_rrc_measConfig = -1;             /* MeasConfig */
static int hf_nr_rrc_nonCriticalExtension_23 = -1;  /* RRCReconfiguration_v1530_IEs */
static int hf_nr_rrc_masterCellGroup = -1;        /* T_masterCellGroup */
static int hf_nr_rrc_fullConfig = -1;             /* T_fullConfig */
static int hf_nr_rrc_dedicatedNAS_MessageList = -1;  /* SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message */
static int hf_nr_rrc_dedicatedNAS_MessageList_item = -1;  /* DedicatedNAS_Message */
static int hf_nr_rrc_masterKeyUpdate = -1;        /* MasterKeyUpdate */
static int hf_nr_rrc_dedicatedSIB1_Delivery = -1;  /* T_dedicatedSIB1_Delivery */
static int hf_nr_rrc_dedicatedSystemInformationDelivery = -1;  /* T_dedicatedSystemInformationDelivery */
static int hf_nr_rrc_otherConfig = -1;            /* OtherConfig */
static int hf_nr_rrc_nonCriticalExtension_24 = -1;  /* RRCReconfiguration_v1540_IEs */
static int hf_nr_rrc_otherConfig_v1540 = -1;      /* OtherConfig_v1540 */
static int hf_nr_rrc_nonCriticalExtension_25 = -1;  /* RRCReconfiguration_v1560_IEs */
static int hf_nr_rrc_mrdc_SecondaryCellGroupConfig = -1;  /* T_mrdc_SecondaryCellGroupConfig */
static int hf_nr_rrc_setup_02 = -1;               /* MRDC_SecondaryCellGroupConfig */
static int hf_nr_rrc_radioBearerConfig2 = -1;     /* T_radioBearerConfig2 */
static int hf_nr_rrc_sk_Counter = -1;             /* SK_Counter */
static int hf_nr_rrc_nonCriticalExtension_26 = -1;  /* T_nonCriticalExtension_17 */
static int hf_nr_rrc_mrdc_ReleaseAndAdd = -1;     /* T_mrdc_ReleaseAndAdd */
static int hf_nr_rrc_mrdc_SecondaryCellGroup = -1;  /* T_mrdc_SecondaryCellGroup */
static int hf_nr_rrc_nr_SCG = -1;                 /* T_nr_SCG */
static int hf_nr_rrc_eutra_SCG = -1;              /* T_eutra_SCG */
static int hf_nr_rrc_keySetChangeIndicator = -1;  /* BOOLEAN */
static int hf_nr_rrc_nas_Container = -1;          /* T_nas_Container */
static int hf_nr_rrc_criticalExtensions_17 = -1;  /* T_criticalExtensions_17 */
static int hf_nr_rrc_rrcReconfigurationComplete_01 = -1;  /* RRCReconfigurationComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_17 = -1;  /* T_criticalExtensionsFuture_17 */
static int hf_nr_rrc_nonCriticalExtension_27 = -1;  /* RRCReconfigurationComplete_v1530_IEs */
static int hf_nr_rrc_uplinkTxDirectCurrentList = -1;  /* UplinkTxDirectCurrentList */
static int hf_nr_rrc_nonCriticalExtension_28 = -1;  /* RRCReconfigurationComplete_v1560_IEs */
static int hf_nr_rrc_scg_Response = -1;           /* T_scg_Response */
static int hf_nr_rrc_nr_SCG_Response = -1;        /* T_nr_SCG_Response */
static int hf_nr_rrc_eutra_SCG_Response = -1;     /* T_eutra_SCG_Response */
static int hf_nr_rrc_nonCriticalExtension_29 = -1;  /* T_nonCriticalExtension_18 */
static int hf_nr_rrc_criticalExtensions_18 = -1;  /* T_criticalExtensions_18 */
static int hf_nr_rrc_rrcReject_01 = -1;           /* RRCReject_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_18 = -1;  /* T_criticalExtensionsFuture_18 */
static int hf_nr_rrc_waitTime = -1;               /* RejectWaitTime */
static int hf_nr_rrc_nonCriticalExtension_30 = -1;  /* T_nonCriticalExtension_19 */
static int hf_nr_rrc_criticalExtensions_19 = -1;  /* T_criticalExtensions_19 */
static int hf_nr_rrc_rrcRelease_01 = -1;          /* RRCRelease_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_19 = -1;  /* T_criticalExtensionsFuture_19 */
static int hf_nr_rrc_redirectedCarrierInfo = -1;  /* RedirectedCarrierInfo */
static int hf_nr_rrc_cellReselectionPriorities = -1;  /* CellReselectionPriorities */
static int hf_nr_rrc_suspendConfig = -1;          /* SuspendConfig */
static int hf_nr_rrc_deprioritisationReq = -1;    /* T_deprioritisationReq */
static int hf_nr_rrc_deprioritisationType = -1;   /* T_deprioritisationType */
static int hf_nr_rrc_deprioritisationTimer = -1;  /* T_deprioritisationTimer */
static int hf_nr_rrc_nonCriticalExtension_31 = -1;  /* RRCRelease_v1540_IEs */
static int hf_nr_rrc_nonCriticalExtension_32 = -1;  /* T_nonCriticalExtension_20 */
static int hf_nr_rrc_nr = -1;                     /* CarrierInfoNR */
static int hf_nr_rrc_eutra = -1;                  /* RedirectedCarrierInfo_EUTRA */
static int hf_nr_rrc_cnType = -1;                 /* T_cnType */
static int hf_nr_rrc_smtc = -1;                   /* SSB_MTC */
static int hf_nr_rrc_shortI_RNTI = -1;            /* ShortI_RNTI_Value */
static int hf_nr_rrc_ran_PagingCycle = -1;        /* PagingCycle */
static int hf_nr_rrc_t380 = -1;                   /* PeriodicRNAU_TimerValue */
static int hf_nr_rrc_freqPriorityListEUTRA = -1;  /* FreqPriorityListEUTRA */
static int hf_nr_rrc_freqPriorityListNR = -1;     /* FreqPriorityListNR */
static int hf_nr_rrc_t320 = -1;                   /* T_t320 */
static int hf_nr_rrc_FreqPriorityListEUTRA_item = -1;  /* FreqPriorityEUTRA */
static int hf_nr_rrc_FreqPriorityListNR_item = -1;  /* FreqPriorityNR */
static int hf_nr_rrc_carrierFreq_01 = -1;         /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_cellReselectionPriority = -1;  /* CellReselectionPriority */
static int hf_nr_rrc_cellReselectionSubPriority = -1;  /* CellReselectionSubPriority */
static int hf_nr_rrc_cellList = -1;               /* PLMN_RAN_AreaCellList */
static int hf_nr_rrc_ran_AreaConfigList = -1;     /* PLMN_RAN_AreaConfigList */
static int hf_nr_rrc_PLMN_RAN_AreaCellList_item = -1;  /* PLMN_RAN_AreaCell */
static int hf_nr_rrc_plmn_Identity = -1;          /* PLMN_Identity */
static int hf_nr_rrc_ran_AreaCells = -1;          /* SEQUENCE_SIZE_1_32_OF_CellIdentity */
static int hf_nr_rrc_ran_AreaCells_item = -1;     /* CellIdentity */
static int hf_nr_rrc_PLMN_RAN_AreaConfigList_item = -1;  /* PLMN_RAN_AreaConfig */
static int hf_nr_rrc_ran_Area = -1;               /* SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig */
static int hf_nr_rrc_ran_Area_item = -1;          /* RAN_AreaConfig */
static int hf_nr_rrc_trackingAreaCode = -1;       /* TrackingAreaCode */
static int hf_nr_rrc_ran_AreaCodeList = -1;       /* SEQUENCE_SIZE_1_32_OF_RAN_AreaCode */
static int hf_nr_rrc_ran_AreaCodeList_item = -1;  /* RAN_AreaCode */
static int hf_nr_rrc_criticalExtensions_20 = -1;  /* T_criticalExtensions_20 */
static int hf_nr_rrc_rrcResume_01 = -1;           /* RRCResume_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_20 = -1;  /* T_criticalExtensionsFuture_20 */
static int hf_nr_rrc_masterCellGroup_01 = -1;     /* T_masterCellGroup_01 */
static int hf_nr_rrc_fullConfig_01 = -1;          /* T_fullConfig_01 */
static int hf_nr_rrc_nonCriticalExtension_33 = -1;  /* RRCResume_v1560_IEs */
static int hf_nr_rrc_radioBearerConfig2_01 = -1;  /* T_radioBearerConfig2_01 */
static int hf_nr_rrc_nonCriticalExtension_34 = -1;  /* T_nonCriticalExtension_21 */
static int hf_nr_rrc_criticalExtensions_21 = -1;  /* T_criticalExtensions_21 */
static int hf_nr_rrc_rrcResumeComplete_01 = -1;   /* RRCResumeComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_21 = -1;  /* T_criticalExtensionsFuture_21 */
static int hf_nr_rrc_selectedPLMN_Identity = -1;  /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_nonCriticalExtension_35 = -1;  /* T_nonCriticalExtension_22 */
static int hf_nr_rrc_rrcResumeRequest_01 = -1;    /* RRCResumeRequest_IEs */
static int hf_nr_rrc_resumeIdentity = -1;         /* ShortI_RNTI_Value */
static int hf_nr_rrc_resumeMAC_I = -1;            /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_resumeCause = -1;            /* ResumeCause */
static int hf_nr_rrc_rrcResumeRequest1_01 = -1;   /* RRCResumeRequest1_IEs */
static int hf_nr_rrc_resumeIdentity_01 = -1;      /* I_RNTI_Value */
static int hf_nr_rrc_criticalExtensions_22 = -1;  /* T_criticalExtensions_22 */
static int hf_nr_rrc_rrcSetup_01 = -1;            /* RRCSetup_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_22 = -1;  /* T_criticalExtensionsFuture_22 */
static int hf_nr_rrc_masterCellGroup_02 = -1;     /* T_masterCellGroup_02 */
static int hf_nr_rrc_nonCriticalExtension_36 = -1;  /* T_nonCriticalExtension_23 */
static int hf_nr_rrc_criticalExtensions_23 = -1;  /* T_criticalExtensions_23 */
static int hf_nr_rrc_rrcSetupComplete_01 = -1;    /* RRCSetupComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_23 = -1;  /* T_criticalExtensionsFuture_23 */
static int hf_nr_rrc_registeredAMF = -1;          /* RegisteredAMF */
static int hf_nr_rrc_guami_Type = -1;             /* T_guami_Type */
static int hf_nr_rrc_s_NSSAI_List = -1;           /* SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI */
static int hf_nr_rrc_s_NSSAI_List_item = -1;      /* S_NSSAI */
static int hf_nr_rrc_ng_5G_S_TMSI_Value = -1;     /* T_ng_5G_S_TMSI_Value */
static int hf_nr_rrc_ng_5G_S_TMSI_Part2 = -1;     /* BIT_STRING_SIZE_9 */
static int hf_nr_rrc_nonCriticalExtension_37 = -1;  /* T_nonCriticalExtension_24 */
static int hf_nr_rrc_amf_Identifier = -1;         /* AMF_Identifier */
static int hf_nr_rrc_rrcSetupRequest_01 = -1;     /* RRCSetupRequest_IEs */
static int hf_nr_rrc_ue_Identity_02 = -1;         /* InitialUE_Identity */
static int hf_nr_rrc_establishmentCause = -1;     /* EstablishmentCause */
static int hf_nr_rrc_ng_5G_S_TMSI_Part1 = -1;     /* BIT_STRING_SIZE_39 */
static int hf_nr_rrc_randomValue = -1;            /* BIT_STRING_SIZE_39 */
static int hf_nr_rrc_criticalExtensions_24 = -1;  /* T_criticalExtensions_24 */
static int hf_nr_rrc_rrcSystemInfoRequest_r15 = -1;  /* RRCSystemInfoRequest_r15_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_24 = -1;  /* T_criticalExtensionsFuture_24 */
static int hf_nr_rrc_requested_SI_List = -1;      /* BIT_STRING_SIZE_maxSI_Message */
static int hf_nr_rrc_spare_01 = -1;               /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_criticalExtensions_25 = -1;  /* T_criticalExtensions_25 */
static int hf_nr_rrc_scgFailureInformation_01 = -1;  /* SCGFailureInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_25 = -1;  /* T_criticalExtensionsFuture_25 */
static int hf_nr_rrc_failureReportSCG = -1;       /* FailureReportSCG */
static int hf_nr_rrc_nonCriticalExtension_38 = -1;  /* T_nonCriticalExtension_25 */
static int hf_nr_rrc_failureType_02 = -1;         /* T_failureType_02 */
static int hf_nr_rrc_measResultFreqList = -1;     /* MeasResultFreqList */
static int hf_nr_rrc_measResultSCG_Failure = -1;  /* T_measResultSCG_Failure */
static int hf_nr_rrc_MeasResultFreqList_item = -1;  /* MeasResult2NR */
static int hf_nr_rrc_criticalExtensions_26 = -1;  /* T_criticalExtensions_26 */
static int hf_nr_rrc_scgFailureInformationEUTRA_01 = -1;  /* SCGFailureInformationEUTRA_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_26 = -1;  /* T_criticalExtensionsFuture_26 */
static int hf_nr_rrc_failureReportSCG_EUTRA = -1;  /* FailureReportSCG_EUTRA */
static int hf_nr_rrc_nonCriticalExtension_39 = -1;  /* T_nonCriticalExtension_26 */
static int hf_nr_rrc_failureType_03 = -1;         /* T_failureType_03 */
static int hf_nr_rrc_measResultFreqListMRDC = -1;  /* MeasResultFreqListFailMRDC */
static int hf_nr_rrc_measResultSCG_FailureMRDC = -1;  /* T_measResultSCG_FailureMRDC */
static int hf_nr_rrc_MeasResultFreqListFailMRDC_item = -1;  /* MeasResult2EUTRA */
static int hf_nr_rrc_criticalExtensions_27 = -1;  /* T_criticalExtensions_27 */
static int hf_nr_rrc_securityModeCommand_01 = -1;  /* SecurityModeCommand_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_27 = -1;  /* T_criticalExtensionsFuture_27 */
static int hf_nr_rrc_securityConfigSMC = -1;      /* SecurityConfigSMC */
static int hf_nr_rrc_nonCriticalExtension_40 = -1;  /* T_nonCriticalExtension_27 */
static int hf_nr_rrc_securityAlgorithmConfig = -1;  /* SecurityAlgorithmConfig */
static int hf_nr_rrc_criticalExtensions_28 = -1;  /* T_criticalExtensions_28 */
static int hf_nr_rrc_securityModeComplete_01 = -1;  /* SecurityModeComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_28 = -1;  /* T_criticalExtensionsFuture_28 */
static int hf_nr_rrc_nonCriticalExtension_41 = -1;  /* T_nonCriticalExtension_28 */
static int hf_nr_rrc_criticalExtensions_29 = -1;  /* T_criticalExtensions_29 */
static int hf_nr_rrc_securityModeFailure_01 = -1;  /* SecurityModeFailure_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_29 = -1;  /* T_criticalExtensionsFuture_29 */
static int hf_nr_rrc_nonCriticalExtension_42 = -1;  /* T_nonCriticalExtension_29 */
static int hf_nr_rrc_cellSelectionInfo = -1;      /* T_cellSelectionInfo */
static int hf_nr_rrc_q_RxLevMin = -1;             /* Q_RxLevMin */
static int hf_nr_rrc_q_RxLevMinOffset = -1;       /* INTEGER_1_8 */
static int hf_nr_rrc_q_RxLevMinSUL = -1;          /* Q_RxLevMin */
static int hf_nr_rrc_q_QualMin = -1;              /* Q_QualMin */
static int hf_nr_rrc_q_QualMinOffset = -1;        /* INTEGER_1_8 */
static int hf_nr_rrc_cellAccessRelatedInfo = -1;  /* CellAccessRelatedInfo */
static int hf_nr_rrc_connEstFailureControl = -1;  /* ConnEstFailureControl */
static int hf_nr_rrc_si_SchedulingInfo = -1;      /* SI_SchedulingInfo */
static int hf_nr_rrc_servingCellConfigCommon = -1;  /* ServingCellConfigCommonSIB */
static int hf_nr_rrc_ims_EmergencySupport = -1;   /* T_ims_EmergencySupport */
static int hf_nr_rrc_eCallOverIMS_Support = -1;   /* T_eCallOverIMS_Support */
static int hf_nr_rrc_ue_TimersAndConstants = -1;  /* UE_TimersAndConstants */
static int hf_nr_rrc_uac_BarringInfo = -1;        /* T_uac_BarringInfo */
static int hf_nr_rrc_uac_BarringForCommon = -1;   /* UAC_BarringPerCatList */
static int hf_nr_rrc_uac_BarringPerPLMN_List = -1;  /* UAC_BarringPerPLMN_List */
static int hf_nr_rrc_uac_BarringInfoSetList = -1;  /* UAC_BarringInfoSetList */
static int hf_nr_rrc_uac_AccessCategory1_SelectionAssistanceInfo = -1;  /* T_uac_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_plmnCommon = -1;             /* UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_individualPLMNList = -1;     /* SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_individualPLMNList_item = -1;  /* UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_useFullResumeID = -1;        /* T_useFullResumeID */
static int hf_nr_rrc_nonCriticalExtension_43 = -1;  /* T_nonCriticalExtension_30 */
static int hf_nr_rrc_criticalExtensions_30 = -1;  /* T_criticalExtensions_30 */
static int hf_nr_rrc_systemInformation_01 = -1;   /* SystemInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_30 = -1;  /* T_criticalExtensionsFuture_30 */
static int hf_nr_rrc_sib_TypeAndInfo = -1;        /* T_sib_TypeAndInfo */
static int hf_nr_rrc_sib_TypeAndInfo_item = -1;   /* T_sib_TypeAndInfo_item */
static int hf_nr_rrc_sib2 = -1;                   /* SIB2 */
static int hf_nr_rrc_sib3 = -1;                   /* SIB3 */
static int hf_nr_rrc_sib4 = -1;                   /* SIB4 */
static int hf_nr_rrc_sib5 = -1;                   /* SIB5 */
static int hf_nr_rrc_sib6 = -1;                   /* SIB6 */
static int hf_nr_rrc_sib7 = -1;                   /* SIB7 */
static int hf_nr_rrc_sib8 = -1;                   /* SIB8 */
static int hf_nr_rrc_sib9 = -1;                   /* SIB9 */
static int hf_nr_rrc_nonCriticalExtension_44 = -1;  /* T_nonCriticalExtension_31 */
static int hf_nr_rrc_criticalExtensions_31 = -1;  /* T_criticalExtensions_31 */
static int hf_nr_rrc_ueAssistanceInformation_02 = -1;  /* UEAssistanceInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_31 = -1;  /* T_criticalExtensionsFuture_31 */
static int hf_nr_rrc_delayBudgetReport = -1;      /* DelayBudgetReport */
static int hf_nr_rrc_nonCriticalExtension_45 = -1;  /* UEAssistanceInformation_v1540_IEs */
static int hf_nr_rrc_type1 = -1;                  /* T_type1 */
static int hf_nr_rrc_overheatingAssistance = -1;  /* OverheatingAssistance */
static int hf_nr_rrc_nonCriticalExtension_46 = -1;  /* T_nonCriticalExtension_32 */
static int hf_nr_rrc_reducedMaxCCs = -1;          /* T_reducedMaxCCs */
static int hf_nr_rrc_reducedCCsDL = -1;           /* INTEGER_0_31 */
static int hf_nr_rrc_reducedCCsUL = -1;           /* INTEGER_0_31 */
static int hf_nr_rrc_reducedMaxBW_FR1 = -1;       /* T_reducedMaxBW_FR1 */
static int hf_nr_rrc_reducedBW_FR1_DL = -1;       /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedBW_FR1_UL = -1;       /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedMaxBW_FR2 = -1;       /* T_reducedMaxBW_FR2 */
static int hf_nr_rrc_reducedBW_FR2_DL = -1;       /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedBW_FR2_UL = -1;       /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR1 = -1;  /* T_reducedMaxMIMO_LayersFR1 */
static int hf_nr_rrc_reducedMIMO_LayersFR1_DL = -1;  /* MIMO_LayersDL */
static int hf_nr_rrc_reducedMIMO_LayersFR1_UL = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR2 = -1;  /* T_reducedMaxMIMO_LayersFR2 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_DL = -1;  /* MIMO_LayersDL */
static int hf_nr_rrc_reducedMIMO_LayersFR2_UL = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_criticalExtensions_32 = -1;  /* T_criticalExtensions_32 */
static int hf_nr_rrc_ueCapabilityEnquiry_01 = -1;  /* UECapabilityEnquiry_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_32 = -1;  /* T_criticalExtensionsFuture_32 */
static int hf_nr_rrc_ue_CapabilityRAT_RequestList = -1;  /* UE_CapabilityRAT_RequestList */
static int hf_nr_rrc_ue_CapabilityEnquiryExt = -1;  /* T_ue_CapabilityEnquiryExt */
static int hf_nr_rrc_capabilityRequestFilterCommon = -1;  /* UE_CapabilityRequestFilterCommon */
static int hf_nr_rrc_nonCriticalExtension_47 = -1;  /* T_nonCriticalExtension_33 */
static int hf_nr_rrc_criticalExtensions_33 = -1;  /* T_criticalExtensions_33 */
static int hf_nr_rrc_ueCapabilityInformation_01 = -1;  /* UECapabilityInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_33 = -1;  /* T_criticalExtensionsFuture_33 */
static int hf_nr_rrc_ue_CapabilityRAT_ContainerList = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_nonCriticalExtension_48 = -1;  /* T_nonCriticalExtension_34 */
static int hf_nr_rrc_criticalExtensions_34 = -1;  /* T_criticalExtensions_34 */
static int hf_nr_rrc_ulInformationTransfer_01 = -1;  /* ULInformationTransfer_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_34 = -1;  /* T_criticalExtensionsFuture_34 */
static int hf_nr_rrc_nonCriticalExtension_49 = -1;  /* T_nonCriticalExtension_35 */
static int hf_nr_rrc_criticalExtensions_35 = -1;  /* T_criticalExtensions_35 */
static int hf_nr_rrc_c1_14 = -1;                  /* T_c1_14 */
static int hf_nr_rrc_ulInformationTransferMRDC_01 = -1;  /* ULInformationTransferMRDC_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_35 = -1;  /* T_criticalExtensionsFuture_35 */
static int hf_nr_rrc_ul_DCCH_MessageNR = -1;      /* T_ul_DCCH_MessageNR */
static int hf_nr_rrc_ul_DCCH_MessageEUTRA = -1;   /* T_ul_DCCH_MessageEUTRA */
static int hf_nr_rrc_nonCriticalExtension_50 = -1;  /* T_nonCriticalExtension_36 */
static int hf_nr_rrc_cellReselectionInfoCommon = -1;  /* T_cellReselectionInfoCommon */
static int hf_nr_rrc_nrofSS_BlocksToAverage = -1;  /* INTEGER_2_maxNrofSS_BlocksToAverage */
static int hf_nr_rrc_absThreshSS_BlocksConsolidation = -1;  /* ThresholdNR */
static int hf_nr_rrc_rangeToBestCell = -1;        /* RangeToBestCell */
static int hf_nr_rrc_q_Hyst = -1;                 /* T_q_Hyst */
static int hf_nr_rrc_speedStateReselectionPars = -1;  /* T_speedStateReselectionPars */
static int hf_nr_rrc_mobilityStateParameters = -1;  /* MobilityStateParameters */
static int hf_nr_rrc_q_HystSF = -1;               /* T_q_HystSF */
static int hf_nr_rrc_sf_Medium = -1;              /* T_sf_Medium */
static int hf_nr_rrc_sf_High = -1;                /* T_sf_High */
static int hf_nr_rrc_cellReselectionServingFreqInfo = -1;  /* T_cellReselectionServingFreqInfo */
static int hf_nr_rrc_s_NonIntraSearchP = -1;      /* ReselectionThreshold */
static int hf_nr_rrc_s_NonIntraSearchQ = -1;      /* ReselectionThresholdQ */
static int hf_nr_rrc_threshServingLowP = -1;      /* ReselectionThreshold */
static int hf_nr_rrc_threshServingLowQ = -1;      /* ReselectionThresholdQ */
static int hf_nr_rrc_intraFreqCellReselectionInfo = -1;  /* T_intraFreqCellReselectionInfo */
static int hf_nr_rrc_s_IntraSearchP = -1;         /* ReselectionThreshold */
static int hf_nr_rrc_s_IntraSearchQ = -1;         /* ReselectionThresholdQ */
static int hf_nr_rrc_t_ReselectionNR = -1;        /* T_Reselection */
static int hf_nr_rrc_frequencyBandList = -1;      /* MultiFrequencyBandListNR_SIB */
static int hf_nr_rrc_frequencyBandListSUL = -1;   /* MultiFrequencyBandListNR_SIB */
static int hf_nr_rrc_p_Max = -1;                  /* P_Max */
static int hf_nr_rrc_ssb_ToMeasure = -1;          /* SSB_ToMeasure */
static int hf_nr_rrc_deriveSSB_IndexFromCell = -1;  /* BOOLEAN */
static int hf_nr_rrc_t_ReselectionNR_SF = -1;     /* SpeedStateScaleFactors */
static int hf_nr_rrc_intraFreqNeighCellList = -1;  /* IntraFreqNeighCellList */
static int hf_nr_rrc_intraFreqBlackCellList = -1;  /* IntraFreqBlackCellList */
static int hf_nr_rrc_IntraFreqNeighCellList_item = -1;  /* IntraFreqNeighCellInfo */
static int hf_nr_rrc_q_OffsetCell = -1;           /* Q_OffsetRange */
static int hf_nr_rrc_q_RxLevMinOffsetCell = -1;   /* INTEGER_1_8 */
static int hf_nr_rrc_q_RxLevMinOffsetCellSUL = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_q_QualMinOffsetCell = -1;    /* INTEGER_1_8 */
static int hf_nr_rrc_IntraFreqBlackCellList_item = -1;  /* PCI_Range */
static int hf_nr_rrc_interFreqCarrierFreqList = -1;  /* InterFreqCarrierFreqList */
static int hf_nr_rrc_InterFreqCarrierFreqList_item = -1;  /* InterFreqCarrierFreqInfo */
static int hf_nr_rrc_dl_CarrierFreq = -1;         /* ARFCN_ValueNR */
static int hf_nr_rrc_threshX_HighP = -1;          /* ReselectionThreshold */
static int hf_nr_rrc_threshX_LowP = -1;           /* ReselectionThreshold */
static int hf_nr_rrc_threshX_Q = -1;              /* T_threshX_Q */
static int hf_nr_rrc_threshX_HighQ = -1;          /* ReselectionThresholdQ */
static int hf_nr_rrc_threshX_LowQ = -1;           /* ReselectionThresholdQ */
static int hf_nr_rrc_q_OffsetFreq = -1;           /* Q_OffsetRange */
static int hf_nr_rrc_interFreqNeighCellList = -1;  /* InterFreqNeighCellList */
static int hf_nr_rrc_interFreqBlackCellList = -1;  /* InterFreqBlackCellList */
static int hf_nr_rrc_InterFreqNeighCellList_item = -1;  /* InterFreqNeighCellInfo */
static int hf_nr_rrc_InterFreqBlackCellList_item = -1;  /* PCI_Range */
static int hf_nr_rrc_carrierFreqListEUTRA = -1;   /* CarrierFreqListEUTRA */
static int hf_nr_rrc_t_ReselectionEUTRA = -1;     /* T_Reselection */
static int hf_nr_rrc_t_ReselectionEUTRA_SF = -1;  /* SpeedStateScaleFactors */
static int hf_nr_rrc_CarrierFreqListEUTRA_item = -1;  /* CarrierFreqEUTRA */
static int hf_nr_rrc_eutra_multiBandInfoList = -1;  /* EUTRA_MultiBandInfoList */
static int hf_nr_rrc_eutra_FreqNeighCellList = -1;  /* EUTRA_FreqNeighCellList */
static int hf_nr_rrc_eutra_BlackCellList = -1;    /* EUTRA_FreqBlackCellList */
static int hf_nr_rrc_allowedMeasBandwidth = -1;   /* EUTRA_AllowedMeasBandwidth */
static int hf_nr_rrc_presenceAntennaPort1 = -1;   /* EUTRA_PresenceAntennaPort1 */
static int hf_nr_rrc_threshX_High = -1;           /* ReselectionThreshold */
static int hf_nr_rrc_threshX_Low = -1;            /* ReselectionThreshold */
static int hf_nr_rrc_q_RxLevMin_01 = -1;          /* INTEGER_M70_M22 */
static int hf_nr_rrc_q_QualMin_01 = -1;           /* INTEGER_M34_M3 */
static int hf_nr_rrc_p_MaxEUTRA = -1;             /* INTEGER_M30_33 */
static int hf_nr_rrc_threshX_Q_01 = -1;           /* T_threshX_Q_01 */
static int hf_nr_rrc_EUTRA_FreqBlackCellList_item = -1;  /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_EUTRA_FreqNeighCellList_item = -1;  /* EUTRA_FreqNeighCellInfo */
static int hf_nr_rrc_physCellId_01 = -1;          /* EUTRA_PhysCellId */
static int hf_nr_rrc_dummy = -1;                  /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_messageIdentifier = -1;      /* T_messageIdentifier */
static int hf_nr_rrc_serialNumber = -1;           /* T_serialNumber */
static int hf_nr_rrc_warningType = -1;            /* T_warningType */
static int hf_nr_rrc_messageIdentifier_01 = -1;   /* T_messageIdentifier_01 */
static int hf_nr_rrc_serialNumber_01 = -1;        /* T_serialNumber_01 */
static int hf_nr_rrc_warningMessageSegmentType = -1;  /* T_warningMessageSegmentType */
static int hf_nr_rrc_warningMessageSegmentNumber = -1;  /* T_warningMessageSegmentNumber */
static int hf_nr_rrc_warningMessageSegment = -1;  /* T_warningMessageSegment */
static int hf_nr_rrc_dataCodingScheme = -1;       /* T_dataCodingScheme */
static int hf_nr_rrc_messageIdentifier_02 = -1;   /* T_messageIdentifier_02 */
static int hf_nr_rrc_serialNumber_02 = -1;        /* T_serialNumber_02 */
static int hf_nr_rrc_warningMessageSegmentType_01 = -1;  /* T_warningMessageSegmentType_01 */
static int hf_nr_rrc_warningMessageSegmentNumber_01 = -1;  /* T_warningMessageSegmentNumber_01 */
static int hf_nr_rrc_warningMessageSegment_01 = -1;  /* T_warningMessageSegment_01 */
static int hf_nr_rrc_dataCodingScheme_01 = -1;    /* T_dataCodingScheme_01 */
static int hf_nr_rrc_warningAreaCoordinatesSegment = -1;  /* OCTET_STRING */
static int hf_nr_rrc_timeInfo = -1;               /* T_timeInfo */
static int hf_nr_rrc_timeInfoUTC = -1;            /* T_timeInfoUTC */
static int hf_nr_rrc_dayLightSavingTime = -1;     /* T_dayLightSavingTime */
static int hf_nr_rrc_leapSeconds = -1;            /* INTEGER_M127_128 */
static int hf_nr_rrc_localTimeOffset = -1;        /* INTEGER_M63_64 */
static int hf_nr_rrc_rootSequenceIndex_BFR = -1;  /* INTEGER_0_137 */
static int hf_nr_rrc_rach_ConfigBFR = -1;         /* RACH_ConfigGeneric */
static int hf_nr_rrc_rsrp_ThresholdSSB = -1;      /* RSRP_Range */
static int hf_nr_rrc_candidateBeamRSList = -1;    /* SEQUENCE_SIZE_1_maxNrofCandidateBeams_OF_PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_candidateBeamRSList_item = -1;  /* PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_ssb_perRACH_Occasion = -1;   /* T_ssb_perRACH_Occasion */
static int hf_nr_rrc_ra_ssb_OccasionMaskIndex = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_recoverySearchSpaceId = -1;  /* SearchSpaceId */
static int hf_nr_rrc_ra_Prioritization = -1;      /* RA_Prioritization */
static int hf_nr_rrc_beamFailureRecoveryTimer = -1;  /* T_beamFailureRecoveryTimer */
static int hf_nr_rrc_msg1_SubcarrierSpacing_v1530 = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_ssb = -1;                    /* BFR_SSB_Resource */
static int hf_nr_rrc_csi_RS = -1;                 /* BFR_CSIRS_Resource */
static int hf_nr_rrc_ssb_01 = -1;                 /* SSB_Index */
static int hf_nr_rrc_ra_PreambleIndex = -1;       /* INTEGER_0_63 */
static int hf_nr_rrc_csi_RS_01 = -1;              /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_ra_OccasionList = -1;        /* T_ra_OccasionList */
static int hf_nr_rrc_ra_OccasionList_item = -1;   /* INTEGER_0_maxRA_Occasions_1 */
static int hf_nr_rrc_betaOffsetACK_Index1 = -1;   /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetACK_Index2 = -1;   /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetACK_Index3 = -1;   /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part1_Index1 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part1_Index2 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part2_Index1 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part2_Index2 = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_periodicBSR_Timer = -1;      /* T_periodicBSR_Timer */
static int hf_nr_rrc_retxBSR_Timer = -1;          /* T_retxBSR_Timer */
static int hf_nr_rrc_logicalChannelSR_DelayTimer = -1;  /* T_logicalChannelSR_DelayTimer */
static int hf_nr_rrc_locationAndBandwidth = -1;   /* INTEGER_0_37949 */
static int hf_nr_rrc_subcarrierSpacing = -1;      /* SubcarrierSpacing */
static int hf_nr_rrc_cyclicPrefix = -1;           /* T_cyclicPrefix */
static int hf_nr_rrc_bwp_Id = -1;                 /* BWP_Id */
static int hf_nr_rrc_bwp_Common = -1;             /* BWP_DownlinkCommon */
static int hf_nr_rrc_bwp_Dedicated = -1;          /* BWP_DownlinkDedicated */
static int hf_nr_rrc_genericParameters = -1;      /* BWP */
static int hf_nr_rrc_pdcch_ConfigCommon = -1;     /* T_pdcch_ConfigCommon */
static int hf_nr_rrc_setup_03 = -1;               /* PDCCH_ConfigCommon */
static int hf_nr_rrc_pdsch_ConfigCommon = -1;     /* T_pdsch_ConfigCommon */
static int hf_nr_rrc_setup_04 = -1;               /* PDSCH_ConfigCommon */
static int hf_nr_rrc_pdcch_Config = -1;           /* T_pdcch_Config */
static int hf_nr_rrc_setup_05 = -1;               /* PDCCH_Config */
static int hf_nr_rrc_pdsch_Config = -1;           /* T_pdsch_Config */
static int hf_nr_rrc_setup_06 = -1;               /* PDSCH_Config */
static int hf_nr_rrc_sps_Config = -1;             /* T_sps_Config */
static int hf_nr_rrc_setup_07 = -1;               /* SPS_Config */
static int hf_nr_rrc_radioLinkMonitoringConfig = -1;  /* T_radioLinkMonitoringConfig */
static int hf_nr_rrc_setup_08 = -1;               /* RadioLinkMonitoringConfig */
static int hf_nr_rrc_bwp_Common_01 = -1;          /* BWP_UplinkCommon */
static int hf_nr_rrc_bwp_Dedicated_01 = -1;       /* BWP_UplinkDedicated */
static int hf_nr_rrc_rach_ConfigCommon = -1;      /* T_rach_ConfigCommon */
static int hf_nr_rrc_setup_09 = -1;               /* RACH_ConfigCommon */
static int hf_nr_rrc_pusch_ConfigCommon = -1;     /* T_pusch_ConfigCommon */
static int hf_nr_rrc_setup_10 = -1;               /* PUSCH_ConfigCommon */
static int hf_nr_rrc_pucch_ConfigCommon = -1;     /* T_pucch_ConfigCommon */
static int hf_nr_rrc_setup_11 = -1;               /* PUCCH_ConfigCommon */
static int hf_nr_rrc_pucch_Config = -1;           /* T_pucch_Config */
static int hf_nr_rrc_setup_12 = -1;               /* PUCCH_Config */
static int hf_nr_rrc_pusch_Config = -1;           /* T_pusch_Config */
static int hf_nr_rrc_setup_13 = -1;               /* PUSCH_Config */
static int hf_nr_rrc_configuredGrantConfig = -1;  /* T_configuredGrantConfig */
static int hf_nr_rrc_setup_14 = -1;               /* ConfiguredGrantConfig */
static int hf_nr_rrc_srs_Config = -1;             /* T_srs_Config */
static int hf_nr_rrc_setup_15 = -1;               /* SRS_Config */
static int hf_nr_rrc_beamFailureRecoveryConfig = -1;  /* T_beamFailureRecoveryConfig */
static int hf_nr_rrc_setup_16 = -1;               /* BeamFailureRecoveryConfig */
static int hf_nr_rrc_plmn_IdentityList = -1;      /* PLMN_IdentityInfoList */
static int hf_nr_rrc_cellReservedForOtherUse = -1;  /* T_cellReservedForOtherUse */
static int hf_nr_rrc_plmn_IdentityList_eutra_5gc = -1;  /* PLMN_IdentityList_EUTRA_5GC */
static int hf_nr_rrc_trackingAreaCode_eutra_5gc = -1;  /* TrackingAreaCode */
static int hf_nr_rrc_ranac_5gc = -1;              /* RAN_AreaCode */
static int hf_nr_rrc_cellIdentity_eutra_5gc = -1;  /* CellIdentity_EUTRA_5GC */
static int hf_nr_rrc_PLMN_IdentityList_EUTRA_5GC_item = -1;  /* PLMN_Identity_EUTRA_5GC */
static int hf_nr_rrc_plmn_Identity_EUTRA_5GC = -1;  /* PLMN_Identity */
static int hf_nr_rrc_plmn_index = -1;             /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_cellIdentity_EUTRA = -1;     /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_cellId_index = -1;           /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_plmn_IdentityList_eutra_epc = -1;  /* PLMN_IdentityList_EUTRA_EPC */
static int hf_nr_rrc_trackingAreaCode_eutra_epc = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_cellIdentity_eutra_epc = -1;  /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_PLMN_IdentityList_EUTRA_EPC_item = -1;  /* PLMN_Identity */
static int hf_nr_rrc_rlc_BearerToAddModList = -1;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_RLC_BearerConfig */
static int hf_nr_rrc_rlc_BearerToAddModList_item = -1;  /* RLC_BearerConfig */
static int hf_nr_rrc_rlc_BearerToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_LogicalChannelIdentity */
static int hf_nr_rrc_rlc_BearerToReleaseList_item = -1;  /* LogicalChannelIdentity */
static int hf_nr_rrc_mac_CellGroupConfig = -1;    /* MAC_CellGroupConfig */
static int hf_nr_rrc_physicalCellGroupConfig = -1;  /* PhysicalCellGroupConfig */
static int hf_nr_rrc_spCellConfig = -1;           /* SpCellConfig */
static int hf_nr_rrc_sCellToAddModList = -1;      /* SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellConfig */
static int hf_nr_rrc_sCellToAddModList_item = -1;  /* SCellConfig */
static int hf_nr_rrc_sCellToReleaseList = -1;     /* SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellIndex */
static int hf_nr_rrc_sCellToReleaseList_item = -1;  /* SCellIndex */
static int hf_nr_rrc_reportUplinkTxDirectCurrent_v1530 = -1;  /* T_reportUplinkTxDirectCurrent_v1530 */
static int hf_nr_rrc_reconfigurationWithSync = -1;  /* ReconfigurationWithSync */
static int hf_nr_rrc_rlf_TimersAndConstants = -1;  /* T_rlf_TimersAndConstants */
static int hf_nr_rrc_setup_17 = -1;               /* RLF_TimersAndConstants */
static int hf_nr_rrc_rlmInSyncOutOfSyncThreshold = -1;  /* T_rlmInSyncOutOfSyncThreshold */
static int hf_nr_rrc_spCellConfigDedicated = -1;  /* ServingCellConfig */
static int hf_nr_rrc_spCellConfigCommon = -1;     /* ServingCellConfigCommon */
static int hf_nr_rrc_newUE_Identity = -1;         /* RNTI_Value */
static int hf_nr_rrc_t304 = -1;                   /* T_t304 */
static int hf_nr_rrc_rach_ConfigDedicated = -1;   /* T_rach_ConfigDedicated */
static int hf_nr_rrc_uplink = -1;                 /* RACH_ConfigDedicated */
static int hf_nr_rrc_supplementaryUplink = -1;    /* RACH_ConfigDedicated */
static int hf_nr_rrc_sCellIndex = -1;             /* SCellIndex */
static int hf_nr_rrc_sCellConfigCommon = -1;      /* ServingCellConfigCommon */
static int hf_nr_rrc_sCellConfigDedicated = -1;   /* ServingCellConfig */
static int hf_nr_rrc_cgi_info_EPC = -1;           /* T_cgi_info_EPC */
static int hf_nr_rrc_cgi_info_EPC_legacy = -1;    /* CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_EPC_list = -1;      /* SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_EPC_list_item = -1;  /* CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_5GC = -1;           /* SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC */
static int hf_nr_rrc_cgi_info_5GC_item = -1;      /* CellAccessRelatedInfo_EUTRA_5GC */
static int hf_nr_rrc_freqBandIndicator = -1;      /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_multiBandInfoList = -1;      /* MultiBandInfoListEUTRA */
static int hf_nr_rrc_freqBandIndicatorPriority = -1;  /* T_freqBandIndicatorPriority */
static int hf_nr_rrc_plmn_IdentityInfoList = -1;  /* PLMN_IdentityInfoList */
static int hf_nr_rrc_frequencyBandList_01 = -1;   /* MultiFrequencyBandListNR */
static int hf_nr_rrc_noSIB1 = -1;                 /* T_noSIB1 */
static int hf_nr_rrc_codebookType = -1;           /* T_codebookType */
static int hf_nr_rrc_type1_01 = -1;               /* T_type1_01 */
static int hf_nr_rrc_subType = -1;                /* T_subType */
static int hf_nr_rrc_typeI_SinglePanel = -1;      /* T_typeI_SinglePanel */
static int hf_nr_rrc_nrOfAntennaPorts = -1;       /* T_nrOfAntennaPorts */
static int hf_nr_rrc_two = -1;                    /* T_two */
static int hf_nr_rrc_twoTX_CodebookSubsetRestriction = -1;  /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_moreThanTwo = -1;            /* T_moreThanTwo */
static int hf_nr_rrc_n1_n2 = -1;                  /* T_n1_n2 */
static int hf_nr_rrc_two_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_three_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_six_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_four_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_eight_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_three_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_six_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_twelve_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_four_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_eight_two_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_sixteen_one_TypeI_SinglePanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_typeI_SinglePanel_codebookSubsetRestriction_i2 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_typeI_SinglePanel_ri_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_typeI_MultiPanel = -1;       /* T_typeI_MultiPanel */
static int hf_nr_rrc_ng_n1_n2 = -1;               /* T_ng_n1_n2 */
static int hf_nr_rrc_two_two_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_four_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_four_two_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_two_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_two_eight_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_four_one_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_two_four_two_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_four_two_two_TypeI_MultiPanel_Restriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_ri_Restriction = -1;         /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_codebookMode = -1;           /* INTEGER_1_2 */
static int hf_nr_rrc_type2 = -1;                  /* T_type2 */
static int hf_nr_rrc_subType_01 = -1;             /* T_subType_01 */
static int hf_nr_rrc_typeII = -1;                 /* T_typeII */
static int hf_nr_rrc_n1_n2_codebookSubsetRestriction = -1;  /* T_n1_n2_codebookSubsetRestriction */
static int hf_nr_rrc_two_one = -1;                /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_two_two = -1;                /* BIT_STRING_SIZE_43 */
static int hf_nr_rrc_four_one = -1;               /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_three_two = -1;              /* BIT_STRING_SIZE_59 */
static int hf_nr_rrc_six_one = -1;                /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_two = -1;               /* BIT_STRING_SIZE_75 */
static int hf_nr_rrc_eight_one = -1;              /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_three = -1;             /* BIT_STRING_SIZE_107 */
static int hf_nr_rrc_six_two = -1;                /* BIT_STRING_SIZE_107 */
static int hf_nr_rrc_twelve_one = -1;             /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_four_four = -1;              /* BIT_STRING_SIZE_139 */
static int hf_nr_rrc_eight_two = -1;              /* BIT_STRING_SIZE_139 */
static int hf_nr_rrc_sixteen_one = -1;            /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_typeII_RI_Restriction = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_typeII_PortSelection = -1;   /* T_typeII_PortSelection */
static int hf_nr_rrc_portSelectionSamplingSize = -1;  /* T_portSelectionSamplingSize */
static int hf_nr_rrc_typeII_PortSelectionRI_Restriction = -1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_phaseAlphabetSize = -1;      /* T_phaseAlphabetSize */
static int hf_nr_rrc_subbandAmplitude = -1;       /* BOOLEAN */
static int hf_nr_rrc_numberOfBeams = -1;          /* T_numberOfBeams */
static int hf_nr_rrc_frequencyHopping = -1;       /* T_frequencyHopping */
static int hf_nr_rrc_cg_DMRS_Configuration = -1;  /* DMRS_UplinkConfig */
static int hf_nr_rrc_mcs_Table = -1;              /* T_mcs_Table */
static int hf_nr_rrc_mcs_TableTransformPrecoder = -1;  /* T_mcs_TableTransformPrecoder */
static int hf_nr_rrc_uci_OnPUSCH = -1;            /* T_uci_OnPUSCH */
static int hf_nr_rrc_setup_18 = -1;               /* CG_UCI_OnPUSCH */
static int hf_nr_rrc_resourceAllocation = -1;     /* T_resourceAllocation */
static int hf_nr_rrc_rbg_Size = -1;               /* T_rbg_Size */
static int hf_nr_rrc_powerControlLoopToUse = -1;  /* T_powerControlLoopToUse */
static int hf_nr_rrc_p0_PUSCH_Alpha = -1;         /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_transformPrecoder = -1;      /* T_transformPrecoder */
static int hf_nr_rrc_nrofHARQ_Processes = -1;     /* INTEGER_1_16 */
static int hf_nr_rrc_repK = -1;                   /* T_repK */
static int hf_nr_rrc_repK_RV = -1;                /* T_repK_RV */
static int hf_nr_rrc_periodicity = -1;            /* T_periodicity */
static int hf_nr_rrc_configuredGrantTimer = -1;   /* INTEGER_1_64 */
static int hf_nr_rrc_rrc_ConfiguredUplinkGrant = -1;  /* T_rrc_ConfiguredUplinkGrant */
static int hf_nr_rrc_timeDomainOffset = -1;       /* INTEGER_0_5119 */
static int hf_nr_rrc_timeDomainAllocation = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_frequencyDomainAllocation = -1;  /* BIT_STRING_SIZE_18 */
static int hf_nr_rrc_antennaPort = -1;            /* INTEGER_0_31 */
static int hf_nr_rrc_dmrs_SeqInitialization = -1;  /* INTEGER_0_1 */
static int hf_nr_rrc_precodingAndNumberOfLayers = -1;  /* INTEGER_0_63 */
static int hf_nr_rrc_srs_ResourceIndicator = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_mcsAndTBS = -1;              /* INTEGER_0_31 */
static int hf_nr_rrc_frequencyHoppingOffset = -1;  /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_pathlossReferenceIndex = -1;  /* INTEGER_0_maxNrofPUSCH_PathlossReferenceRSs_1 */
static int hf_nr_rrc_dynamic = -1;                /* SEQUENCE_SIZE_1_4_OF_BetaOffsets */
static int hf_nr_rrc_dynamic_item = -1;           /* BetaOffsets */
static int hf_nr_rrc_semiStatic = -1;             /* BetaOffsets */
static int hf_nr_rrc_connEstFailCount = -1;       /* T_connEstFailCount */
static int hf_nr_rrc_connEstFailOffsetValidity = -1;  /* T_connEstFailOffsetValidity */
static int hf_nr_rrc_connEstFailOffset = -1;      /* INTEGER_0_15 */
static int hf_nr_rrc_controlResourceSetId = -1;   /* ControlResourceSetId */
static int hf_nr_rrc_frequencyDomainResources = -1;  /* BIT_STRING_SIZE_45 */
static int hf_nr_rrc_duration = -1;               /* INTEGER_1_maxCoReSetDuration */
static int hf_nr_rrc_cce_REG_MappingType = -1;    /* T_cce_REG_MappingType */
static int hf_nr_rrc_interleaved = -1;            /* T_interleaved */
static int hf_nr_rrc_reg_BundleSize = -1;         /* T_reg_BundleSize */
static int hf_nr_rrc_interleaverSize = -1;        /* T_interleaverSize */
static int hf_nr_rrc_shiftIndex = -1;             /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nonInterleaved = -1;         /* NULL */
static int hf_nr_rrc_precoderGranularity = -1;    /* T_precoderGranularity */
static int hf_nr_rrc_tci_StatesPDCCH_ToAddList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToAddList_item = -1;  /* TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToReleaseList_item = -1;  /* TCI_StateId */
static int hf_nr_rrc_tci_PresentInDCI = -1;       /* T_tci_PresentInDCI */
static int hf_nr_rrc_pdcch_DMRS_ScramblingID = -1;  /* INTEGER_0_65535 */
static int hf_nr_rrc_schedulingCellInfo = -1;     /* T_schedulingCellInfo */
static int hf_nr_rrc_own = -1;                    /* T_own */
static int hf_nr_rrc_cif_Presence = -1;           /* BOOLEAN */
static int hf_nr_rrc_other = -1;                  /* T_other */
static int hf_nr_rrc_schedulingCellId = -1;       /* ServCellIndex */
static int hf_nr_rrc_cif_InSchedulingCell = -1;   /* INTEGER_1_7 */
static int hf_nr_rrc_CSI_AperiodicTriggerStateList_item = -1;  /* CSI_AperiodicTriggerState */
static int hf_nr_rrc_associatedReportConfigInfoList = -1;  /* SEQUENCE_SIZE_1_maxNrofReportConfigPerAperiodicTrigger_OF_CSI_AssociatedReportConfigInfo */
static int hf_nr_rrc_associatedReportConfigInfoList_item = -1;  /* CSI_AssociatedReportConfigInfo */
static int hf_nr_rrc_reportConfigId = -1;         /* CSI_ReportConfigId */
static int hf_nr_rrc_resourcesForChannel = -1;    /* T_resourcesForChannel */
static int hf_nr_rrc_nzp_CSI_RS = -1;             /* T_nzp_CSI_RS */
static int hf_nr_rrc_resourceSet = -1;            /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_qcl_info = -1;               /* SEQUENCE_SIZE_1_maxNrofAP_CSI_RS_ResourcesPerSet_OF_TCI_StateId */
static int hf_nr_rrc_qcl_info_item = -1;          /* TCI_StateId */
static int hf_nr_rrc_csi_SSB_ResourceSet = -1;    /* INTEGER_1_maxNrofCSI_SSB_ResourceSetsPerConfig */
static int hf_nr_rrc_csi_IM_ResourcesForInterference = -1;  /* INTEGER_1_maxNrofCSI_IM_ResourceSetsPerConfig */
static int hf_nr_rrc_nzp_CSI_RS_ResourcesForInterference = -1;  /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_startingRB = -1;             /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofRBs = -1;                /* INTEGER_24_maxNrofPhysicalResourceBlocksPlus1 */
static int hf_nr_rrc_csi_IM_ResourceId = -1;      /* CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceElementPattern = -1;  /* T_csi_IM_ResourceElementPattern */
static int hf_nr_rrc_pattern0 = -1;               /* T_pattern0 */
static int hf_nr_rrc_subcarrierLocation_p0 = -1;  /* T_subcarrierLocation_p0 */
static int hf_nr_rrc_symbolLocation_p0 = -1;      /* INTEGER_0_12 */
static int hf_nr_rrc_pattern1 = -1;               /* T_pattern1 */
static int hf_nr_rrc_subcarrierLocation_p1 = -1;  /* T_subcarrierLocation_p1 */
static int hf_nr_rrc_symbolLocation_p1 = -1;      /* INTEGER_0_13 */
static int hf_nr_rrc_freqBand = -1;               /* CSI_FrequencyOccupation */
static int hf_nr_rrc_periodicityAndOffset = -1;   /* CSI_ResourcePeriodicityAndOffset */
static int hf_nr_rrc_csi_IM_ResourceSetId = -1;   /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_Resources = -1;       /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourcesPerSet_OF_CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_Resources_item = -1;  /* CSI_IM_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_Resource */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToAddModList_item = -1;  /* NZP_CSI_RS_Resource */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToReleaseList_item = -1;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToAddModList_item = -1;  /* NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToReleaseList_item = -1;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_Resource */
static int hf_nr_rrc_csi_IM_ResourceToAddModList_item = -1;  /* CSI_IM_Resource */
static int hf_nr_rrc_csi_IM_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceToReleaseList_item = -1;  /* CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSet */
static int hf_nr_rrc_csi_IM_ResourceSetToAddModList_item = -1;  /* CSI_IM_ResourceSet */
static int hf_nr_rrc_csi_IM_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetToReleaseList_item = -1;  /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSet */
static int hf_nr_rrc_csi_SSB_ResourceSetToAddModList_item = -1;  /* CSI_SSB_ResourceSet */
static int hf_nr_rrc_csi_SSB_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetToReleaseList_item = -1;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_ResourceConfigToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfig */
static int hf_nr_rrc_csi_ResourceConfigToAddModList_item = -1;  /* CSI_ResourceConfig */
static int hf_nr_rrc_csi_ResourceConfigToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfigId */
static int hf_nr_rrc_csi_ResourceConfigToReleaseList_item = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_ReportConfigToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfig */
static int hf_nr_rrc_csi_ReportConfigToAddModList_item = -1;  /* CSI_ReportConfig */
static int hf_nr_rrc_csi_ReportConfigToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfigId */
static int hf_nr_rrc_csi_ReportConfigToReleaseList_item = -1;  /* CSI_ReportConfigId */
static int hf_nr_rrc_reportTriggerSize = -1;      /* INTEGER_0_6 */
static int hf_nr_rrc_aperiodicTriggerStateList = -1;  /* T_aperiodicTriggerStateList */
static int hf_nr_rrc_setup_19 = -1;               /* CSI_AperiodicTriggerStateList */
static int hf_nr_rrc_semiPersistentOnPUSCH_TriggerStateList = -1;  /* T_semiPersistentOnPUSCH_TriggerStateList */
static int hf_nr_rrc_setup_20 = -1;               /* CSI_SemiPersistentOnPUSCH_TriggerStateList */
static int hf_nr_rrc_carrier = -1;                /* ServCellIndex */
static int hf_nr_rrc_resourcesForChannelMeasurement = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_IM_ResourcesForInterference_01 = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_nzp_CSI_RS_ResourcesForInterference_01 = -1;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_reportConfigType = -1;       /* T_reportConfigType */
static int hf_nr_rrc_periodic = -1;               /* T_periodic */
static int hf_nr_rrc_reportSlotConfig = -1;       /* CSI_ReportPeriodicityAndOffset */
static int hf_nr_rrc_pucch_CSI_ResourceList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_PUCCH_CSI_Resource */
static int hf_nr_rrc_pucch_CSI_ResourceList_item = -1;  /* PUCCH_CSI_Resource */
static int hf_nr_rrc_semiPersistentOnPUCCH = -1;  /* T_semiPersistentOnPUCCH */
static int hf_nr_rrc_semiPersistentOnPUSCH = -1;  /* T_semiPersistentOnPUSCH */
static int hf_nr_rrc_reportSlotConfig_01 = -1;    /* T_reportSlotConfig */
static int hf_nr_rrc_reportSlotOffsetList = -1;   /* T_reportSlotOffsetList */
static int hf_nr_rrc_reportSlotOffsetList_item = -1;  /* INTEGER_0_32 */
static int hf_nr_rrc_p0alpha = -1;                /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_aperiodic = -1;              /* T_aperiodic */
static int hf_nr_rrc_reportSlotOffsetList_01 = -1;  /* T_reportSlotOffsetList_01 */
static int hf_nr_rrc_reportQuantity = -1;         /* T_reportQuantity */
static int hf_nr_rrc_none = -1;                   /* NULL */
static int hf_nr_rrc_cri_RI_PMI_CQI = -1;         /* NULL */
static int hf_nr_rrc_cri_RI_i1 = -1;              /* NULL */
static int hf_nr_rrc_cri_RI_i1_CQI = -1;          /* T_cri_RI_i1_CQI */
static int hf_nr_rrc_pdsch_BundleSizeForCSI = -1;  /* T_pdsch_BundleSizeForCSI */
static int hf_nr_rrc_cri_RI_CQI = -1;             /* NULL */
static int hf_nr_rrc_cri_RSRP = -1;               /* NULL */
static int hf_nr_rrc_ssb_Index_RSRP = -1;         /* NULL */
static int hf_nr_rrc_cri_RI_LI_PMI_CQI = -1;      /* NULL */
static int hf_nr_rrc_reportFreqConfiguration = -1;  /* T_reportFreqConfiguration */
static int hf_nr_rrc_cqi_FormatIndicator = -1;    /* T_cqi_FormatIndicator */
static int hf_nr_rrc_pmi_FormatIndicator = -1;    /* T_pmi_FormatIndicator */
static int hf_nr_rrc_csi_ReportingBand = -1;      /* T_csi_ReportingBand */
static int hf_nr_rrc_subbands3 = -1;              /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_subbands4 = -1;              /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_subbands5 = -1;              /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_subbands6 = -1;              /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_subbands7 = -1;              /* BIT_STRING_SIZE_7 */
static int hf_nr_rrc_subbands8 = -1;              /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_subbands9 = -1;              /* BIT_STRING_SIZE_9 */
static int hf_nr_rrc_subbands10 = -1;             /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_subbands11 = -1;             /* BIT_STRING_SIZE_11 */
static int hf_nr_rrc_subbands12 = -1;             /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_subbands13 = -1;             /* BIT_STRING_SIZE_13 */
static int hf_nr_rrc_subbands14 = -1;             /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_subbands15 = -1;             /* BIT_STRING_SIZE_15 */
static int hf_nr_rrc_subbands16 = -1;             /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_subbands17 = -1;             /* BIT_STRING_SIZE_17 */
static int hf_nr_rrc_subbands18 = -1;             /* BIT_STRING_SIZE_18 */
static int hf_nr_rrc_subbands19_v1530 = -1;       /* BIT_STRING_SIZE_19 */
static int hf_nr_rrc_timeRestrictionForChannelMeasurements = -1;  /* T_timeRestrictionForChannelMeasurements */
static int hf_nr_rrc_timeRestrictionForInterferenceMeasurements = -1;  /* T_timeRestrictionForInterferenceMeasurements */
static int hf_nr_rrc_codebookConfig = -1;         /* CodebookConfig */
static int hf_nr_rrc_dummy_01 = -1;               /* T_dummy */
static int hf_nr_rrc_groupBasedBeamReporting = -1;  /* T_groupBasedBeamReporting */
static int hf_nr_rrc_enabled = -1;                /* NULL */
static int hf_nr_rrc_disabled = -1;               /* T_disabled */
static int hf_nr_rrc_nrofReportedRS = -1;         /* T_nrofReportedRS */
static int hf_nr_rrc_cqi_Table = -1;              /* T_cqi_Table */
static int hf_nr_rrc_subbandSize = -1;            /* T_subbandSize */
static int hf_nr_rrc_non_PMI_PortIndication = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerConfig_OF_PortIndexFor8Ranks */
static int hf_nr_rrc_non_PMI_PortIndication_item = -1;  /* PortIndexFor8Ranks */
static int hf_nr_rrc_semiPersistentOnPUSCH_v1530 = -1;  /* T_semiPersistentOnPUSCH_v1530 */
static int hf_nr_rrc_reportSlotConfig_v1530 = -1;  /* T_reportSlotConfig_v1530 */
static int hf_nr_rrc_slots4 = -1;                 /* INTEGER_0_3 */
static int hf_nr_rrc_slots5 = -1;                 /* INTEGER_0_4 */
static int hf_nr_rrc_slots8 = -1;                 /* INTEGER_0_7 */
static int hf_nr_rrc_slots10 = -1;                /* INTEGER_0_9 */
static int hf_nr_rrc_slots16 = -1;                /* INTEGER_0_15 */
static int hf_nr_rrc_slots20 = -1;                /* INTEGER_0_19 */
static int hf_nr_rrc_slots40 = -1;                /* INTEGER_0_39 */
static int hf_nr_rrc_slots80 = -1;                /* INTEGER_0_79 */
static int hf_nr_rrc_slots160 = -1;               /* INTEGER_0_159 */
static int hf_nr_rrc_slots320 = -1;               /* INTEGER_0_319 */
static int hf_nr_rrc_uplinkBandwidthPartId = -1;  /* BWP_Id */
static int hf_nr_rrc_pucch_Resource = -1;         /* PUCCH_ResourceId */
static int hf_nr_rrc_portIndex8 = -1;             /* T_portIndex8 */
static int hf_nr_rrc_rank1_8 = -1;                /* PortIndex8 */
static int hf_nr_rrc_rank2_8 = -1;                /* SEQUENCE_SIZE_2_OF_PortIndex8 */
static int hf_nr_rrc_rank2_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank3_8 = -1;                /* SEQUENCE_SIZE_3_OF_PortIndex8 */
static int hf_nr_rrc_rank3_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank4_8 = -1;                /* SEQUENCE_SIZE_4_OF_PortIndex8 */
static int hf_nr_rrc_rank4_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank5_8 = -1;                /* SEQUENCE_SIZE_5_OF_PortIndex8 */
static int hf_nr_rrc_rank5_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank6_8 = -1;                /* SEQUENCE_SIZE_6_OF_PortIndex8 */
static int hf_nr_rrc_rank6_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank7_8 = -1;                /* SEQUENCE_SIZE_7_OF_PortIndex8 */
static int hf_nr_rrc_rank7_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_rank8_8 = -1;                /* SEQUENCE_SIZE_8_OF_PortIndex8 */
static int hf_nr_rrc_rank8_8_item = -1;           /* PortIndex8 */
static int hf_nr_rrc_portIndex4 = -1;             /* T_portIndex4 */
static int hf_nr_rrc_rank1_4 = -1;                /* PortIndex4 */
static int hf_nr_rrc_rank2_4 = -1;                /* SEQUENCE_SIZE_2_OF_PortIndex4 */
static int hf_nr_rrc_rank2_4_item = -1;           /* PortIndex4 */
static int hf_nr_rrc_rank3_4 = -1;                /* SEQUENCE_SIZE_3_OF_PortIndex4 */
static int hf_nr_rrc_rank3_4_item = -1;           /* PortIndex4 */
static int hf_nr_rrc_rank4_4 = -1;                /* SEQUENCE_SIZE_4_OF_PortIndex4 */
static int hf_nr_rrc_rank4_4_item = -1;           /* PortIndex4 */
static int hf_nr_rrc_portIndex2 = -1;             /* T_portIndex2 */
static int hf_nr_rrc_rank1_2 = -1;                /* PortIndex2 */
static int hf_nr_rrc_rank2_2 = -1;                /* SEQUENCE_SIZE_2_OF_PortIndex2 */
static int hf_nr_rrc_rank2_2_item = -1;           /* PortIndex2 */
static int hf_nr_rrc_portIndex1 = -1;             /* NULL */
static int hf_nr_rrc_csi_ResourceConfigId = -1;   /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_RS_ResourceSetList = -1;  /* T_csi_RS_ResourceSetList */
static int hf_nr_rrc_nzp_CSI_RS_SSB = -1;         /* T_nzp_CSI_RS_SSB */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetList = -1;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig_OF_NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetList_item = -1;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSetsPerConfig_OF_CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetList_item = -1;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSetsPerConfig_OF_CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetList_item = -1;  /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_resourceType = -1;           /* T_resourceType */
static int hf_nr_rrc_slots32 = -1;                /* INTEGER_0_31 */
static int hf_nr_rrc_slots64 = -1;                /* INTEGER_0_63 */
static int hf_nr_rrc_slots640 = -1;               /* INTEGER_0_639 */
static int hf_nr_rrc_csi_RS_CellList_Mobility = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility */
static int hf_nr_rrc_csi_RS_CellList_Mobility_item = -1;  /* CSI_RS_CellMobility */
static int hf_nr_rrc_refServCellIndex_v1530 = -1;  /* ServCellIndex */
static int hf_nr_rrc_cellId = -1;                 /* PhysCellId */
static int hf_nr_rrc_csi_rs_MeasurementBW = -1;   /* T_csi_rs_MeasurementBW */
static int hf_nr_rrc_nrofPRBs = -1;               /* T_nrofPRBs */
static int hf_nr_rrc_startPRB = -1;               /* INTEGER_0_2169 */
static int hf_nr_rrc_density = -1;                /* T_density */
static int hf_nr_rrc_csi_rs_ResourceList_Mobility = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility */
static int hf_nr_rrc_csi_rs_ResourceList_Mobility_item = -1;  /* CSI_RS_Resource_Mobility */
static int hf_nr_rrc_csi_RS_Index = -1;           /* CSI_RS_Index */
static int hf_nr_rrc_slotConfig = -1;             /* T_slotConfig */
static int hf_nr_rrc_ms4 = -1;                    /* INTEGER_0_31 */
static int hf_nr_rrc_ms5 = -1;                    /* INTEGER_0_39 */
static int hf_nr_rrc_ms10_01 = -1;                /* INTEGER_0_79 */
static int hf_nr_rrc_ms20_01 = -1;                /* INTEGER_0_159 */
static int hf_nr_rrc_ms40_01 = -1;                /* INTEGER_0_319 */
static int hf_nr_rrc_associatedSSB = -1;          /* T_associatedSSB */
static int hf_nr_rrc_ssb_Index = -1;              /* SSB_Index */
static int hf_nr_rrc_isQuasiColocated = -1;       /* BOOLEAN */
static int hf_nr_rrc_frequencyDomainAllocation_01 = -1;  /* T_frequencyDomainAllocation */
static int hf_nr_rrc_row1 = -1;                   /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_row2 = -1;                   /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain = -1;  /* INTEGER_0_13 */
static int hf_nr_rrc_sequenceGenerationConfig = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_frequencyDomainAllocation_02 = -1;  /* T_frequencyDomainAllocation_01 */
static int hf_nr_rrc_row4 = -1;                   /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_other_01 = -1;               /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_nrofPorts = -1;              /* T_nrofPorts */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain2 = -1;  /* INTEGER_2_12 */
static int hf_nr_rrc_cdm_Type = -1;               /* T_cdm_Type */
static int hf_nr_rrc_density_01 = -1;             /* T_density_01 */
static int hf_nr_rrc_dot5 = -1;                   /* T_dot5 */
static int hf_nr_rrc_one = -1;                    /* NULL */
static int hf_nr_rrc_three = -1;                  /* NULL */
static int hf_nr_rrc_spare_02 = -1;               /* NULL */
static int hf_nr_rrc_CSI_SemiPersistentOnPUSCH_TriggerStateList_item = -1;  /* CSI_SemiPersistentOnPUSCH_TriggerState */
static int hf_nr_rrc_associatedReportConfigInfo = -1;  /* CSI_ReportConfigId */
static int hf_nr_rrc_csi_SSB_ResourceSetId = -1;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceList = -1;   /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourcePerSet_OF_SSB_Index */
static int hf_nr_rrc_csi_SSB_ResourceList_item = -1;  /* SSB_Index */
static int hf_nr_rrc_dmrs_Type = -1;              /* T_dmrs_Type */
static int hf_nr_rrc_dmrs_AdditionalPosition = -1;  /* T_dmrs_AdditionalPosition */
static int hf_nr_rrc_maxLength = -1;              /* T_maxLength */
static int hf_nr_rrc_scramblingID0 = -1;          /* INTEGER_0_65535 */
static int hf_nr_rrc_scramblingID1 = -1;          /* INTEGER_0_65535 */
static int hf_nr_rrc_phaseTrackingRS = -1;        /* T_phaseTrackingRS */
static int hf_nr_rrc_setup_21 = -1;               /* PTRS_DownlinkConfig */
static int hf_nr_rrc_dmrs_Type_01 = -1;           /* T_dmrs_Type_01 */
static int hf_nr_rrc_dmrs_AdditionalPosition_01 = -1;  /* T_dmrs_AdditionalPosition_01 */
static int hf_nr_rrc_phaseTrackingRS_01 = -1;     /* T_phaseTrackingRS_01 */
static int hf_nr_rrc_setup_22 = -1;               /* PTRS_UplinkConfig */
static int hf_nr_rrc_maxLength_01 = -1;           /* T_maxLength_01 */
static int hf_nr_rrc_transformPrecodingDisabled = -1;  /* T_transformPrecodingDisabled */
static int hf_nr_rrc_transformPrecodingEnabled = -1;  /* T_transformPrecodingEnabled */
static int hf_nr_rrc_nPUSCH_Identity = -1;        /* INTEGER_0_1007 */
static int hf_nr_rrc_sequenceGroupHopping = -1;   /* T_sequenceGroupHopping */
static int hf_nr_rrc_sequenceHopping = -1;        /* T_sequenceHopping */
static int hf_nr_rrc_frequencyInfoDL = -1;        /* FrequencyInfoDL */
static int hf_nr_rrc_initialDownlinkBWP = -1;     /* BWP_DownlinkCommon */
static int hf_nr_rrc_frequencyInfoDL_01 = -1;     /* FrequencyInfoDL_SIB */
static int hf_nr_rrc_bcch_Config = -1;            /* BCCH_Config */
static int hf_nr_rrc_pcch_Config = -1;            /* PCCH_Config */
static int hf_nr_rrc_modificationPeriodCoeff = -1;  /* T_modificationPeriodCoeff */
static int hf_nr_rrc_defaultPagingCycle = -1;     /* PagingCycle */
static int hf_nr_rrc_nAndPagingFrameOffset = -1;  /* T_nAndPagingFrameOffset */
static int hf_nr_rrc_oneT = -1;                   /* NULL */
static int hf_nr_rrc_halfT = -1;                  /* INTEGER_0_1 */
static int hf_nr_rrc_quarterT = -1;               /* INTEGER_0_3 */
static int hf_nr_rrc_oneEighthT = -1;             /* INTEGER_0_7 */
static int hf_nr_rrc_oneSixteenthT = -1;          /* INTEGER_0_15 */
static int hf_nr_rrc_ns = -1;                     /* T_ns */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO = -1;  /* T_firstPDCCH_MonitoringOccasionOfPO */
static int hf_nr_rrc_sCS15KHZoneT = -1;           /* T_sCS15KHZoneT */
static int hf_nr_rrc_sCS15KHZoneT_item = -1;      /* INTEGER_0_139 */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT = -1;  /* T_sCS30KHZoneT_SCS15KHZhalfT */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_item = -1;  /* INTEGER_0_279 */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT = -1;  /* T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_item = -1;  /* INTEGER_0_559 */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT = -1;  /* T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_item = -1;  /* INTEGER_0_1119 */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT = -1;  /* T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_item = -1;  /* INTEGER_0_2239 */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT = -1;  /* T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_item = -1;  /* INTEGER_0_4479 */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT = -1;  /* T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_item = -1;  /* INTEGER_0_8959 */
static int hf_nr_rrc_sCS120KHZoneSixteenthT = -1;  /* T_sCS120KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZoneSixteenthT_item = -1;  /* INTEGER_0_17919 */
static int hf_nr_rrc_int_RNTI = -1;               /* RNTI_Value */
static int hf_nr_rrc_timeFrequencySet = -1;       /* T_timeFrequencySet */
static int hf_nr_rrc_dci_PayloadSize = -1;        /* INTEGER_0_maxINT_DCI_PayloadSize */
static int hf_nr_rrc_int_ConfigurationPerServingCell = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_INT_ConfigurationPerServingCell */
static int hf_nr_rrc_int_ConfigurationPerServingCell_item = -1;  /* INT_ConfigurationPerServingCell */
static int hf_nr_rrc_servingCellId = -1;          /* ServCellIndex */
static int hf_nr_rrc_positionInDCI = -1;          /* INTEGER_0_maxINT_DCI_PayloadSize_1 */
static int hf_nr_rrc_drx_onDurationTimer = -1;    /* T_drx_onDurationTimer */
static int hf_nr_rrc_subMilliSeconds = -1;        /* INTEGER_1_31 */
static int hf_nr_rrc_milliSeconds = -1;           /* T_milliSeconds */
static int hf_nr_rrc_drx_InactivityTimer = -1;    /* T_drx_InactivityTimer */
static int hf_nr_rrc_drx_HARQ_RTT_TimerDL = -1;   /* INTEGER_0_56 */
static int hf_nr_rrc_drx_HARQ_RTT_TimerUL = -1;   /* INTEGER_0_56 */
static int hf_nr_rrc_drx_RetransmissionTimerDL = -1;  /* T_drx_RetransmissionTimerDL */
static int hf_nr_rrc_drx_RetransmissionTimerUL = -1;  /* T_drx_RetransmissionTimerUL */
static int hf_nr_rrc_drx_LongCycleStartOffset_01 = -1;  /* T_drx_LongCycleStartOffset_01 */
static int hf_nr_rrc_shortDRX_01 = -1;            /* T_shortDRX_01 */
static int hf_nr_rrc_drx_ShortCycle_01 = -1;      /* T_drx_ShortCycle_01 */
static int hf_nr_rrc_drx_SlotOffset = -1;         /* INTEGER_0_31 */
static int hf_nr_rrc_absoluteFrequencySSB = -1;   /* ARFCN_ValueNR */
static int hf_nr_rrc_absoluteFrequencyPointA = -1;  /* ARFCN_ValueNR */
static int hf_nr_rrc_scs_SpecificCarrierList = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_scs_SpecificCarrierList_item = -1;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_offsetToPointA = -1;         /* INTEGER_0_2199 */
static int hf_nr_rrc_additionalSpectrumEmission = -1;  /* AdditionalSpectrumEmission */
static int hf_nr_rrc_frequencyShift7p5khz = -1;   /* T_frequencyShift7p5khz */
static int hf_nr_rrc_frequencyShift7p5khz_01 = -1;  /* T_frequencyShift7p5khz_01 */
static int hf_nr_rrc_eutra_RSTD = -1;             /* EUTRA_RSTD_InfoList */
static int hf_nr_rrc_eutra_FineTimingDetection = -1;  /* NULL */
static int hf_nr_rrc_EUTRA_RSTD_InfoList_item = -1;  /* EUTRA_RSTD_Info */
static int hf_nr_rrc_measPRS_Offset = -1;         /* INTEGER_0_39 */
static int hf_nr_rrc_ul_SpecificParameters = -1;  /* T_ul_SpecificParameters */
static int hf_nr_rrc_priority = -1;               /* INTEGER_1_16 */
static int hf_nr_rrc_prioritisedBitRate = -1;     /* T_prioritisedBitRate */
static int hf_nr_rrc_bucketSizeDuration = -1;     /* T_bucketSizeDuration */
static int hf_nr_rrc_allowedServingCells = -1;    /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ServCellIndex */
static int hf_nr_rrc_allowedServingCells_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_allowedSCS_List = -1;        /* SEQUENCE_SIZE_1_maxSCSs_OF_SubcarrierSpacing */
static int hf_nr_rrc_allowedSCS_List_item = -1;   /* SubcarrierSpacing */
static int hf_nr_rrc_maxPUSCH_Duration = -1;      /* T_maxPUSCH_Duration */
static int hf_nr_rrc_configuredGrantType1Allowed = -1;  /* T_configuredGrantType1Allowed */
static int hf_nr_rrc_logicalChannelGroup = -1;    /* INTEGER_0_maxLCG_ID */
static int hf_nr_rrc_schedulingRequestID = -1;    /* SchedulingRequestId */
static int hf_nr_rrc_logicalChannelSR_Mask = -1;  /* BOOLEAN */
static int hf_nr_rrc_logicalChannelSR_DelayTimerApplied = -1;  /* BOOLEAN */
static int hf_nr_rrc_bitRateQueryProhibitTimer = -1;  /* T_bitRateQueryProhibitTimer */
static int hf_nr_rrc_drx_Config = -1;             /* T_drx_Config */
static int hf_nr_rrc_setup_23 = -1;               /* DRX_Config */
static int hf_nr_rrc_schedulingRequestConfig = -1;  /* SchedulingRequestConfig */
static int hf_nr_rrc_bsr_Config = -1;             /* BSR_Config */
static int hf_nr_rrc_tag_Config = -1;             /* TAG_Config */
static int hf_nr_rrc_phr_Config = -1;             /* T_phr_Config */
static int hf_nr_rrc_setup_24 = -1;               /* PHR_Config */
static int hf_nr_rrc_skipUplinkTxDynamic = -1;    /* BOOLEAN */
static int hf_nr_rrc_csi_Mask = -1;               /* BOOLEAN */
static int hf_nr_rrc_dataInactivityTimer = -1;    /* T_dataInactivityTimer */
static int hf_nr_rrc_setup_25 = -1;               /* DataInactivityTimer */
static int hf_nr_rrc_measObjectToRemoveList = -1;  /* MeasObjectToRemoveList */
static int hf_nr_rrc_measObjectToAddModList = -1;  /* MeasObjectToAddModList */
static int hf_nr_rrc_reportConfigToRemoveList = -1;  /* ReportConfigToRemoveList */
static int hf_nr_rrc_reportConfigToAddModList = -1;  /* ReportConfigToAddModList */
static int hf_nr_rrc_measIdToRemoveList = -1;     /* MeasIdToRemoveList */
static int hf_nr_rrc_measIdToAddModList = -1;     /* MeasIdToAddModList */
static int hf_nr_rrc_s_MeasureConfig = -1;        /* T_s_MeasureConfig */
static int hf_nr_rrc_ssb_RSRP = -1;               /* RSRP_Range */
static int hf_nr_rrc_csi_RSRP = -1;               /* RSRP_Range */
static int hf_nr_rrc_quantityConfig = -1;         /* QuantityConfig */
static int hf_nr_rrc_measGapConfig_01 = -1;       /* MeasGapConfig */
static int hf_nr_rrc_measGapSharingConfig = -1;   /* MeasGapSharingConfig */
static int hf_nr_rrc_MeasObjectToRemoveList_item = -1;  /* MeasObjectId */
static int hf_nr_rrc_MeasIdToRemoveList_item = -1;  /* MeasId */
static int hf_nr_rrc_ReportConfigToRemoveList_item = -1;  /* ReportConfigId */
static int hf_nr_rrc_gapFR2 = -1;                 /* T_gapFR2 */
static int hf_nr_rrc_gapFR1 = -1;                 /* T_gapFR1 */
static int hf_nr_rrc_gapUE = -1;                  /* T_gapUE */
static int hf_nr_rrc_gapOffset = -1;              /* INTEGER_0_159 */
static int hf_nr_rrc_mgl = -1;                    /* T_mgl */
static int hf_nr_rrc_mgrp = -1;                   /* T_mgrp */
static int hf_nr_rrc_mgta = -1;                   /* T_mgta */
static int hf_nr_rrc_refServCellIndicator = -1;   /* T_refServCellIndicator */
static int hf_nr_rrc_gapSharingFR2 = -1;          /* T_gapSharingFR2 */
static int hf_nr_rrc_setup_26 = -1;               /* MeasGapSharingScheme */
static int hf_nr_rrc_gapSharingFR1 = -1;          /* T_gapSharingFR1 */
static int hf_nr_rrc_gapSharingUE = -1;           /* T_gapSharingUE */
static int hf_nr_rrc_MeasIdToAddModList_item = -1;  /* MeasIdToAddMod */
static int hf_nr_rrc_measId = -1;                 /* MeasId */
static int hf_nr_rrc_measObjectId = -1;           /* MeasObjectId */
static int hf_nr_rrc_reportConfigId_01 = -1;      /* ReportConfigId */
static int hf_nr_rrc_cellsToRemoveListEUTRAN = -1;  /* EUTRA_CellIndexList */
static int hf_nr_rrc_cellsToAddModListEUTRAN = -1;  /* SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell */
static int hf_nr_rrc_cellsToAddModListEUTRAN_item = -1;  /* EUTRA_Cell */
static int hf_nr_rrc_blackCellsToRemoveListEUTRAN = -1;  /* EUTRA_CellIndexList */
static int hf_nr_rrc_blackCellsToAddModListEUTRAN = -1;  /* SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell */
static int hf_nr_rrc_blackCellsToAddModListEUTRAN_item = -1;  /* EUTRA_BlackCell */
static int hf_nr_rrc_eutra_PresenceAntennaPort1 = -1;  /* EUTRA_PresenceAntennaPort1 */
static int hf_nr_rrc_eutra_Q_OffsetRange = -1;    /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_widebandRSRQ_Meas = -1;      /* BOOLEAN */
static int hf_nr_rrc_EUTRA_CellIndexList_item = -1;  /* EUTRA_CellIndex */
static int hf_nr_rrc_cellIndexEUTRA = -1;         /* EUTRA_CellIndex */
static int hf_nr_rrc_cellIndividualOffset = -1;   /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_physCellIdRange = -1;        /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_smtc1 = -1;                  /* SSB_MTC */
static int hf_nr_rrc_smtc2 = -1;                  /* SSB_MTC2 */
static int hf_nr_rrc_refFreqCSI_RS = -1;          /* ARFCN_ValueNR */
static int hf_nr_rrc_referenceSignalConfig = -1;  /* ReferenceSignalConfig */
static int hf_nr_rrc_absThreshCSI_RS_Consolidation = -1;  /* ThresholdNR */
static int hf_nr_rrc_nrofCSI_RS_ResourcesToAverage = -1;  /* INTEGER_2_maxNrofCSI_RS_ResourcesToAverage */
static int hf_nr_rrc_quantityConfigIndex = -1;    /* INTEGER_1_maxNrofQuantityConfig */
static int hf_nr_rrc_offsetMO = -1;               /* Q_OffsetRangeList */
static int hf_nr_rrc_cellsToRemoveList = -1;      /* PCI_List */
static int hf_nr_rrc_cellsToAddModList = -1;      /* CellsToAddModList */
static int hf_nr_rrc_blackCellsToRemoveList = -1;  /* PCI_RangeIndexList */
static int hf_nr_rrc_blackCellsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement */
static int hf_nr_rrc_blackCellsToAddModList_item = -1;  /* PCI_RangeElement */
static int hf_nr_rrc_whiteCellsToRemoveList = -1;  /* PCI_RangeIndexList */
static int hf_nr_rrc_whiteCellsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement */
static int hf_nr_rrc_whiteCellsToAddModList_item = -1;  /* PCI_RangeElement */
static int hf_nr_rrc_freqBandIndicatorNR_v1530 = -1;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_measCycleSCell_v1530 = -1;   /* T_measCycleSCell_v1530 */
static int hf_nr_rrc_ssb_ConfigMobility = -1;     /* SSB_ConfigMobility */
static int hf_nr_rrc_csi_rs_ResourceConfigMobility = -1;  /* T_csi_rs_ResourceConfigMobility */
static int hf_nr_rrc_setup_27 = -1;               /* CSI_RS_ResourceConfigMobility */
static int hf_nr_rrc_ssb_ToMeasure_01 = -1;       /* T_ssb_ToMeasure */
static int hf_nr_rrc_setup_28 = -1;               /* SSB_ToMeasure */
static int hf_nr_rrc_rsrpOffsetSSB = -1;          /* Q_OffsetRange */
static int hf_nr_rrc_rsrqOffsetSSB = -1;          /* Q_OffsetRange */
static int hf_nr_rrc_sinrOffsetSSB = -1;          /* Q_OffsetRange */
static int hf_nr_rrc_rsrpOffsetCSI_RS = -1;       /* Q_OffsetRange */
static int hf_nr_rrc_rsrqOffsetCSI_RS = -1;       /* Q_OffsetRange */
static int hf_nr_rrc_sinrOffsetCSI_RS = -1;       /* Q_OffsetRange */
static int hf_nr_rrc_thresholdRSRP = -1;          /* RSRP_Range */
static int hf_nr_rrc_thresholdRSRQ = -1;          /* RSRQ_Range */
static int hf_nr_rrc_thresholdSINR = -1;          /* SINR_Range */
static int hf_nr_rrc_CellsToAddModList_item = -1;  /* CellsToAddMod */
static int hf_nr_rrc_cellIndividualOffset_01 = -1;  /* Q_OffsetRangeList */
static int hf_nr_rrc_MeasObjectToAddModList_item = -1;  /* MeasObjectToAddMod */
static int hf_nr_rrc_measObject = -1;             /* T_measObject */
static int hf_nr_rrc_measObjectNR = -1;           /* MeasObjectNR */
static int hf_nr_rrc_measObjectEUTRA = -1;        /* MeasObjectEUTRA */
static int hf_nr_rrc_MeasResultCellListSFTD_NR_item = -1;  /* MeasResultCellSFTD_NR */
static int hf_nr_rrc_sfn_OffsetResult = -1;       /* INTEGER_0_1023 */
static int hf_nr_rrc_frameBoundaryOffsetResult = -1;  /* INTEGER_M30720_30719 */
static int hf_nr_rrc_rsrp_Result = -1;            /* RSRP_Range */
static int hf_nr_rrc_MeasResultCellListSFTD_EUTRA_item = -1;  /* MeasResultSFTD_EUTRA */
static int hf_nr_rrc_eutra_PhysCellId = -1;       /* EUTRA_PhysCellId */
static int hf_nr_rrc_measResultServingMOList = -1;  /* MeasResultServMOList */
static int hf_nr_rrc_measResultNeighCells = -1;   /* T_measResultNeighCells */
static int hf_nr_rrc_measResultListNR = -1;       /* MeasResultListNR */
static int hf_nr_rrc_measResultListEUTRA = -1;    /* MeasResultListEUTRA */
static int hf_nr_rrc_measResultServFreqListEUTRA_SCG = -1;  /* MeasResultServFreqListEUTRA_SCG */
static int hf_nr_rrc_measResultServFreqListNR_SCG = -1;  /* MeasResultServFreqListNR_SCG */
static int hf_nr_rrc_measResultSFTD_EUTRA = -1;   /* MeasResultSFTD_EUTRA */
static int hf_nr_rrc_measResultSFTD_NR = -1;      /* MeasResultCellSFTD_NR */
static int hf_nr_rrc_MeasResultServMOList_item = -1;  /* MeasResultServMO */
static int hf_nr_rrc_servCellId = -1;             /* ServCellIndex */
static int hf_nr_rrc_measResultServingCell = -1;  /* MeasResultNR */
static int hf_nr_rrc_measResultBestNeighCell = -1;  /* MeasResultNR */
static int hf_nr_rrc_MeasResultListNR_item = -1;  /* MeasResultNR */
static int hf_nr_rrc_measResult = -1;             /* T_measResult */
static int hf_nr_rrc_cellResults = -1;            /* T_cellResults */
static int hf_nr_rrc_resultsSSB_Cell = -1;        /* MeasQuantityResults */
static int hf_nr_rrc_resultsCSI_RS_Cell = -1;     /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults = -1;         /* T_rsIndexResults */
static int hf_nr_rrc_resultsSSB_Indexes = -1;     /* ResultsPerSSB_IndexList */
static int hf_nr_rrc_resultsCSI_RS_Indexes = -1;  /* ResultsPerCSI_RS_IndexList */
static int hf_nr_rrc_MeasResultListEUTRA_item = -1;  /* MeasResultEUTRA */
static int hf_nr_rrc_eutra_PhysCellId_01 = -1;    /* PhysCellId */
static int hf_nr_rrc_measResult_01 = -1;          /* MeasQuantityResultsEUTRA */
static int hf_nr_rrc_cgi_Info_01 = -1;            /* CGI_InfoEUTRA */
static int hf_nr_rrc_MultiBandInfoListEUTRA_item = -1;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_rsrp = -1;                   /* RSRP_Range */
static int hf_nr_rrc_rsrq = -1;                   /* RSRQ_Range */
static int hf_nr_rrc_sinr = -1;                   /* SINR_Range */
static int hf_nr_rrc_rsrp_01 = -1;                /* RSRP_RangeEUTRA */
static int hf_nr_rrc_rsrq_01 = -1;                /* RSRQ_RangeEUTRA */
static int hf_nr_rrc_sinr_01 = -1;                /* SINR_RangeEUTRA */
static int hf_nr_rrc_ResultsPerSSB_IndexList_item = -1;  /* ResultsPerSSB_Index */
static int hf_nr_rrc_ssb_Results = -1;            /* MeasQuantityResults */
static int hf_nr_rrc_ResultsPerCSI_RS_IndexList_item = -1;  /* ResultsPerCSI_RS_Index */
static int hf_nr_rrc_csi_RS_Results = -1;         /* MeasQuantityResults */
static int hf_nr_rrc_MeasResultServFreqListEUTRA_SCG_item = -1;  /* MeasResult2EUTRA */
static int hf_nr_rrc_MeasResultServFreqListNR_SCG_item = -1;  /* MeasResult2NR */
static int hf_nr_rrc_measResultServingCell_01 = -1;  /* MeasResultEUTRA */
static int hf_nr_rrc_measResultBestNeighCell_01 = -1;  /* MeasResultEUTRA */
static int hf_nr_rrc_measResultNeighCellListNR = -1;  /* MeasResultListNR */
static int hf_nr_rrc_measResultPerMOList = -1;    /* MeasResultList2NR */
static int hf_nr_rrc_MeasResultList2NR_item = -1;  /* MeasResult2NR */
static int hf_nr_rrc_t_Evaluation = -1;           /* T_t_Evaluation */
static int hf_nr_rrc_t_HystNormal = -1;           /* T_t_HystNormal */
static int hf_nr_rrc_n_CellChangeMedium = -1;     /* INTEGER_1_16 */
static int hf_nr_rrc_n_CellChangeHigh = -1;       /* INTEGER_1_16 */
static int hf_nr_rrc_MultiFrequencyBandListNR_item = -1;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_MultiFrequencyBandListNR_SIB_item = -1;  /* NR_MultiBandInfo */
static int hf_nr_rrc_freqBandIndicatorNR = -1;    /* FreqBandIndicatorNR */
static int hf_nr_rrc_nr_NS_PmaxList = -1;         /* NR_NS_PmaxList */
static int hf_nr_rrc_NR_NS_PmaxList_item = -1;    /* NR_NS_PmaxValue */
static int hf_nr_rrc_additionalPmax = -1;         /* P_Max */
static int hf_nr_rrc_nzp_CSI_RS_ResourceId = -1;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_resourceMapping = -1;        /* CSI_RS_ResourceMapping */
static int hf_nr_rrc_powerControlOffset = -1;     /* INTEGER_M8_15 */
static int hf_nr_rrc_powerControlOffsetSS = -1;   /* T_powerControlOffsetSS */
static int hf_nr_rrc_scramblingID = -1;           /* ScramblingId */
static int hf_nr_rrc_qcl_InfoPeriodicCSI_RS = -1;  /* TCI_StateId */
static int hf_nr_rrc_nzp_CSI_ResourceSetId = -1;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_Resources = -1;   /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerSet_OF_NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_Resources_item = -1;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_repetition = -1;             /* T_repetition */
static int hf_nr_rrc_aperiodicTriggeringOffset = -1;  /* INTEGER_0_6 */
static int hf_nr_rrc_trs_Info = -1;               /* T_trs_Info */
static int hf_nr_rrc_PCI_List_item = -1;          /* PhysCellId */
static int hf_nr_rrc_start = -1;                  /* PhysCellId */
static int hf_nr_rrc_range = -1;                  /* T_range */
static int hf_nr_rrc_pci_RangeIndex = -1;         /* PCI_RangeIndex */
static int hf_nr_rrc_pci_Range = -1;              /* PCI_Range */
static int hf_nr_rrc_PCI_RangeIndexList_item = -1;  /* PCI_RangeIndex */
static int hf_nr_rrc_controlResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_3_OF_ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToAddModList_item = -1;  /* ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_3_OF_ControlResourceSetId */
static int hf_nr_rrc_controlResourceSetToReleaseList_item = -1;  /* ControlResourceSetId */
static int hf_nr_rrc_searchSpacesToAddModList = -1;  /* SEQUENCE_SIZE_1_10_OF_SearchSpace */
static int hf_nr_rrc_searchSpacesToAddModList_item = -1;  /* SearchSpace */
static int hf_nr_rrc_searchSpacesToReleaseList = -1;  /* SEQUENCE_SIZE_1_10_OF_SearchSpaceId */
static int hf_nr_rrc_searchSpacesToReleaseList_item = -1;  /* SearchSpaceId */
static int hf_nr_rrc_downlinkPreemption = -1;     /* T_downlinkPreemption */
static int hf_nr_rrc_setup_29 = -1;               /* DownlinkPreemption */
static int hf_nr_rrc_tpc_PUSCH = -1;              /* T_tpc_PUSCH */
static int hf_nr_rrc_setup_30 = -1;               /* PUSCH_TPC_CommandConfig */
static int hf_nr_rrc_tpc_PUCCH = -1;              /* T_tpc_PUCCH */
static int hf_nr_rrc_setup_31 = -1;               /* PUCCH_TPC_CommandConfig */
static int hf_nr_rrc_tpc_SRS = -1;                /* T_tpc_SRS */
static int hf_nr_rrc_setup_32 = -1;               /* SRS_TPC_CommandConfig */
static int hf_nr_rrc_controlResourceSetZero = -1;  /* ControlResourceSetZero */
static int hf_nr_rrc_commonControlResourceSet = -1;  /* ControlResourceSet */
static int hf_nr_rrc_searchSpaceZero = -1;        /* SearchSpaceZero */
static int hf_nr_rrc_commonSearchSpaceList = -1;  /* SEQUENCE_SIZE_1_4_OF_SearchSpace */
static int hf_nr_rrc_commonSearchSpaceList_item = -1;  /* SearchSpace */
static int hf_nr_rrc_searchSpaceSIB1 = -1;        /* SearchSpaceId */
static int hf_nr_rrc_searchSpaceOtherSystemInformation = -1;  /* SearchSpaceId */
static int hf_nr_rrc_pagingSearchSpace = -1;      /* SearchSpaceId */
static int hf_nr_rrc_ra_SearchSpace = -1;         /* SearchSpaceId */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO_01 = -1;  /* T_firstPDCCH_MonitoringOccasionOfPO_01 */
static int hf_nr_rrc_sCS15KHZoneT_01 = -1;        /* T_sCS15KHZoneT_01 */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_01 = -1;  /* T_sCS30KHZoneT_SCS15KHZhalfT_01 */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 = -1;  /* T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 = -1;  /* T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS120KHZoneSixteenthT_01 = -1;  /* T_sCS120KHZoneSixteenthT_01 */
static int hf_nr_rrc_slotFormatIndicator = -1;    /* T_slotFormatIndicator */
static int hf_nr_rrc_setup_33 = -1;               /* SlotFormatIndicator */
static int hf_nr_rrc_drb = -1;                    /* T_drb */
static int hf_nr_rrc_discardTimer = -1;           /* T_discardTimer */
static int hf_nr_rrc_pdcp_SN_SizeUL = -1;         /* T_pdcp_SN_SizeUL */
static int hf_nr_rrc_pdcp_SN_SizeDL = -1;         /* T_pdcp_SN_SizeDL */
static int hf_nr_rrc_headerCompression = -1;      /* T_headerCompression */
static int hf_nr_rrc_notUsed = -1;                /* NULL */
static int hf_nr_rrc_rohc = -1;                   /* T_rohc */
static int hf_nr_rrc_maxCID = -1;                 /* INTEGER_1_16383 */
static int hf_nr_rrc_profiles = -1;               /* T_profiles */
static int hf_nr_rrc_profile0x0001 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0002 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0003 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0004 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0006 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0101 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0102 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0103 = -1;          /* BOOLEAN */
static int hf_nr_rrc_profile0x0104 = -1;          /* BOOLEAN */
static int hf_nr_rrc_drb_ContinueROHC = -1;       /* T_drb_ContinueROHC */
static int hf_nr_rrc_uplinkOnlyROHC = -1;         /* T_uplinkOnlyROHC */
static int hf_nr_rrc_profiles_01 = -1;            /* T_profiles_01 */
static int hf_nr_rrc_drb_ContinueROHC_01 = -1;    /* T_drb_ContinueROHC_01 */
static int hf_nr_rrc_integrityProtection = -1;    /* T_integrityProtection */
static int hf_nr_rrc_statusReportRequired = -1;   /* T_statusReportRequired */
static int hf_nr_rrc_outOfOrderDelivery = -1;     /* T_outOfOrderDelivery */
static int hf_nr_rrc_moreThanOneRLC = -1;         /* T_moreThanOneRLC */
static int hf_nr_rrc_primaryPath = -1;            /* T_primaryPath */
static int hf_nr_rrc_cellGroup = -1;              /* CellGroupId */
static int hf_nr_rrc_logicalChannel = -1;         /* LogicalChannelIdentity */
static int hf_nr_rrc_ul_DataSplitThreshold = -1;  /* UL_DataSplitThreshold */
static int hf_nr_rrc_pdcp_Duplication = -1;       /* BOOLEAN */
static int hf_nr_rrc_t_Reordering = -1;           /* T_t_Reordering */
static int hf_nr_rrc_cipheringDisabled = -1;      /* T_cipheringDisabled */
static int hf_nr_rrc_dataScramblingIdentityPDSCH = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeA = -1;  /* T_dmrs_DownlinkForPDSCH_MappingTypeA */
static int hf_nr_rrc_setup_34 = -1;               /* DMRS_DownlinkConfig */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeB = -1;  /* T_dmrs_DownlinkForPDSCH_MappingTypeB */
static int hf_nr_rrc_tci_StatesToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_State */
static int hf_nr_rrc_tci_StatesToAddModList_item = -1;  /* TCI_State */
static int hf_nr_rrc_tci_StatesToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesToReleaseList_item = -1;  /* TCI_StateId */
static int hf_nr_rrc_vrb_ToPRB_Interleaver = -1;  /* T_vrb_ToPRB_Interleaver */
static int hf_nr_rrc_resourceAllocation_01 = -1;  /* T_resourceAllocation_01 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList = -1;  /* T_pdsch_TimeDomainAllocationList */
static int hf_nr_rrc_setup_35 = -1;               /* PDSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_pdsch_AggregationFactor = -1;  /* T_pdsch_AggregationFactor */
static int hf_nr_rrc_rateMatchPatternToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPattern */
static int hf_nr_rrc_rateMatchPatternToAddModList_item = -1;  /* RateMatchPattern */
static int hf_nr_rrc_rateMatchPatternToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPatternId */
static int hf_nr_rrc_rateMatchPatternToReleaseList_item = -1;  /* RateMatchPatternId */
static int hf_nr_rrc_rateMatchPatternGroup1 = -1;  /* RateMatchPatternGroup */
static int hf_nr_rrc_rateMatchPatternGroup2 = -1;  /* RateMatchPatternGroup */
static int hf_nr_rrc_rbg_Size_01 = -1;            /* T_rbg_Size_01 */
static int hf_nr_rrc_mcs_Table_01 = -1;           /* T_mcs_Table_01 */
static int hf_nr_rrc_maxNrofCodeWordsScheduledByDCI = -1;  /* T_maxNrofCodeWordsScheduledByDCI */
static int hf_nr_rrc_prb_BundlingType = -1;       /* T_prb_BundlingType */
static int hf_nr_rrc_staticBundling = -1;         /* T_staticBundling */
static int hf_nr_rrc_bundleSize = -1;             /* T_bundleSize */
static int hf_nr_rrc_dynamicBundling = -1;        /* T_dynamicBundling */
static int hf_nr_rrc_bundleSizeSet1 = -1;         /* T_bundleSizeSet1 */
static int hf_nr_rrc_bundleSizeSet2 = -1;         /* T_bundleSizeSet2 */
static int hf_nr_rrc_zp_CSI_RS_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_Resource */
static int hf_nr_rrc_zp_CSI_RS_ResourceToAddModList_item = -1;  /* ZP_CSI_RS_Resource */
static int hf_nr_rrc_zp_CSI_RS_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceToReleaseList_item = -1;  /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_item = -1;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_item = -1;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToAddModList_item = -1;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToReleaseList_item = -1;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_p_ZP_CSI_RS_ResourceSet = -1;  /* T_p_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_setup_36 = -1;               /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_RateMatchPatternGroup_item = -1;  /* RateMatchPatternGroup_item */
static int hf_nr_rrc_cellLevel = -1;              /* RateMatchPatternId */
static int hf_nr_rrc_bwpLevel = -1;               /* RateMatchPatternId */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList_01 = -1;  /* PDSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_codeBlockGroupTransmission = -1;  /* T_codeBlockGroupTransmission */
static int hf_nr_rrc_setup_37 = -1;               /* PDSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_xOverhead = -1;              /* T_xOverhead */
static int hf_nr_rrc_nrofHARQ_ProcessesForPDSCH = -1;  /* T_nrofHARQ_ProcessesForPDSCH */
static int hf_nr_rrc_pucch_Cell = -1;             /* ServCellIndex */
static int hf_nr_rrc_maxMIMO_Layers = -1;         /* INTEGER_1_8 */
static int hf_nr_rrc_processingType2Enabled = -1;  /* BOOLEAN */
static int hf_nr_rrc_maxCodeBlockGroupsPerTransportBlock = -1;  /* T_maxCodeBlockGroupsPerTransportBlock */
static int hf_nr_rrc_codeBlockGroupFlushIndicator = -1;  /* BOOLEAN */
static int hf_nr_rrc_PDSCH_TimeDomainResourceAllocationList_item = -1;  /* PDSCH_TimeDomainResourceAllocation */
static int hf_nr_rrc_k0 = -1;                     /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType = -1;            /* T_mappingType */
static int hf_nr_rrc_startSymbolAndLength = -1;   /* INTEGER_0_127 */
static int hf_nr_rrc_phr_PeriodicTimer = -1;      /* T_phr_PeriodicTimer */
static int hf_nr_rrc_phr_ProhibitTimer = -1;      /* T_phr_ProhibitTimer */
static int hf_nr_rrc_phr_Tx_PowerFactorChange = -1;  /* T_phr_Tx_PowerFactorChange */
static int hf_nr_rrc_multiplePHR = -1;            /* BOOLEAN */
static int hf_nr_rrc_dummy_02 = -1;               /* BOOLEAN */
static int hf_nr_rrc_phr_Type2OtherCell = -1;     /* BOOLEAN */
static int hf_nr_rrc_phr_ModeOtherCG = -1;        /* T_phr_ModeOtherCG */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUCCH = -1;  /* T_harq_ACK_SpatialBundlingPUCCH */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUSCH = -1;  /* T_harq_ACK_SpatialBundlingPUSCH */
static int hf_nr_rrc_p_NR_FR1 = -1;               /* P_Max */
static int hf_nr_rrc_pdsch_HARQ_ACK_Codebook = -1;  /* T_pdsch_HARQ_ACK_Codebook */
static int hf_nr_rrc_tpc_SRS_RNTI = -1;           /* RNTI_Value */
static int hf_nr_rrc_tpc_PUCCH_RNTI = -1;         /* RNTI_Value */
static int hf_nr_rrc_tpc_PUSCH_RNTI = -1;         /* RNTI_Value */
static int hf_nr_rrc_sp_CSI_RNTI = -1;            /* RNTI_Value */
static int hf_nr_rrc_cs_RNTI = -1;                /* T_cs_RNTI */
static int hf_nr_rrc_setup_38 = -1;               /* RNTI_Value */
static int hf_nr_rrc_mcs_C_RNTI = -1;             /* RNTI_Value */
static int hf_nr_rrc_p_UE_FR1 = -1;               /* P_Max */
static int hf_nr_rrc_xScale = -1;                 /* T_xScale */
static int hf_nr_rrc_pdcch_BlindDetection = -1;   /* T_pdcch_BlindDetection */
static int hf_nr_rrc_setup_39 = -1;               /* PDCCH_BlindDetection */
static int hf_nr_rrc_mcc = -1;                    /* MCC */
static int hf_nr_rrc_mnc = -1;                    /* MNC */
static int hf_nr_rrc_MCC_item = -1;               /* MCC_MNC_Digit */
static int hf_nr_rrc_MNC_item = -1;               /* MCC_MNC_Digit */
static int hf_nr_rrc_PLMN_IdentityInfoList_item = -1;  /* PLMN_IdentityInfo */
static int hf_nr_rrc_plmn_IdentityList_01 = -1;   /* SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity */
static int hf_nr_rrc_plmn_IdentityList_item = -1;  /* PLMN_Identity */
static int hf_nr_rrc_ranac = -1;                  /* RAN_AreaCode */
static int hf_nr_rrc_cellReservedForOperatorUse = -1;  /* T_cellReservedForOperatorUse */
static int hf_nr_rrc_frequencyDensity = -1;       /* T_frequencyDensity */
static int hf_nr_rrc_frequencyDensity_item = -1;  /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensity = -1;            /* T_timeDensity */
static int hf_nr_rrc_timeDensity_item = -1;       /* INTEGER_0_29 */
static int hf_nr_rrc_epre_Ratio = -1;             /* INTEGER_0_3 */
static int hf_nr_rrc_resourceElementOffset = -1;  /* T_resourceElementOffset */
static int hf_nr_rrc_transformPrecoderDisabled = -1;  /* T_transformPrecoderDisabled */
static int hf_nr_rrc_frequencyDensity_01 = -1;    /* T_frequencyDensity_01 */
static int hf_nr_rrc_timeDensity_01 = -1;         /* T_timeDensity_01 */
static int hf_nr_rrc_maxNrofPorts = -1;           /* T_maxNrofPorts */
static int hf_nr_rrc_resourceElementOffset_01 = -1;  /* T_resourceElementOffset_01 */
static int hf_nr_rrc_ptrs_Power = -1;             /* T_ptrs_Power */
static int hf_nr_rrc_transformPrecoderEnabled = -1;  /* T_transformPrecoderEnabled */
static int hf_nr_rrc_sampleDensity = -1;          /* T_sampleDensity */
static int hf_nr_rrc_sampleDensity_item = -1;     /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensityTransformPrecoding = -1;  /* T_timeDensityTransformPrecoding */
static int hf_nr_rrc_resourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSet */
static int hf_nr_rrc_resourceSetToAddModList_item = -1;  /* PUCCH_ResourceSet */
static int hf_nr_rrc_resourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceSetToReleaseList_item = -1;  /* PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceToAddModList = -1;   /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_Resource */
static int hf_nr_rrc_resourceToAddModList_item = -1;  /* PUCCH_Resource */
static int hf_nr_rrc_resourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourceToReleaseList_item = -1;  /* PUCCH_ResourceId */
static int hf_nr_rrc_format1 = -1;                /* T_format1 */
static int hf_nr_rrc_setup_40 = -1;               /* PUCCH_FormatConfig */
static int hf_nr_rrc_format2 = -1;                /* T_format2 */
static int hf_nr_rrc_format3 = -1;                /* T_format3 */
static int hf_nr_rrc_format4 = -1;                /* T_format4 */
static int hf_nr_rrc_schedulingRequestResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfig */
static int hf_nr_rrc_schedulingRequestResourceToAddModList_item = -1;  /* SchedulingRequestResourceConfig */
static int hf_nr_rrc_schedulingRequestResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceId */
static int hf_nr_rrc_schedulingRequestResourceToReleaseList_item = -1;  /* SchedulingRequestResourceId */
static int hf_nr_rrc_multi_CSI_PUCCH_ResourceList = -1;  /* SEQUENCE_SIZE_1_2_OF_PUCCH_ResourceId */
static int hf_nr_rrc_multi_CSI_PUCCH_ResourceList_item = -1;  /* PUCCH_ResourceId */
static int hf_nr_rrc_dl_DataToUL_ACK = -1;        /* T_dl_DataToUL_ACK */
static int hf_nr_rrc_dl_DataToUL_ACK_item = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_spatialRelationInfoToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToAddModList_item = -1;  /* PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_spatialRelationInfoToReleaseList_item = -1;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_pucch_PowerControl = -1;     /* PUCCH_PowerControl */
static int hf_nr_rrc_interslotFrequencyHopping = -1;  /* T_interslotFrequencyHopping */
static int hf_nr_rrc_additionalDMRS = -1;         /* T_additionalDMRS */
static int hf_nr_rrc_maxCodeRate = -1;            /* PUCCH_MaxCodeRate */
static int hf_nr_rrc_nrofSlots = -1;              /* T_nrofSlots */
static int hf_nr_rrc_pi2BPSK = -1;                /* T_pi2BPSK */
static int hf_nr_rrc_simultaneousHARQ_ACK_CSI = -1;  /* T_simultaneousHARQ_ACK_CSI */
static int hf_nr_rrc_pucch_ResourceSetId = -1;    /* PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceList = -1;           /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerSet_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourceList_item = -1;      /* PUCCH_ResourceId */
static int hf_nr_rrc_maxPayloadSize = -1;         /* INTEGER_4_256 */
static int hf_nr_rrc_pucch_ResourceId = -1;       /* PUCCH_ResourceId */
static int hf_nr_rrc_startingPRB = -1;            /* PRB_Id */
static int hf_nr_rrc_intraSlotFrequencyHopping = -1;  /* T_intraSlotFrequencyHopping */
static int hf_nr_rrc_secondHopPRB = -1;           /* PRB_Id */
static int hf_nr_rrc_format = -1;                 /* T_format */
static int hf_nr_rrc_format0 = -1;                /* PUCCH_format0 */
static int hf_nr_rrc_format1_01 = -1;             /* PUCCH_format1 */
static int hf_nr_rrc_format2_01 = -1;             /* PUCCH_format2 */
static int hf_nr_rrc_format3_01 = -1;             /* PUCCH_format3 */
static int hf_nr_rrc_format4_01 = -1;             /* PUCCH_format4 */
static int hf_nr_rrc_initialCyclicShift = -1;     /* INTEGER_0_11 */
static int hf_nr_rrc_nrofSymbols = -1;            /* INTEGER_1_2 */
static int hf_nr_rrc_startingSymbolIndex = -1;    /* INTEGER_0_13 */
static int hf_nr_rrc_nrofSymbols_01 = -1;         /* INTEGER_4_14 */
static int hf_nr_rrc_startingSymbolIndex_01 = -1;  /* INTEGER_0_10 */
static int hf_nr_rrc_timeDomainOCC = -1;          /* INTEGER_0_6 */
static int hf_nr_rrc_nrofPRBs_01 = -1;            /* INTEGER_1_16 */
static int hf_nr_rrc_occ_Length = -1;             /* T_occ_Length */
static int hf_nr_rrc_occ_Index = -1;              /* T_occ_Index */
static int hf_nr_rrc_pucch_ResourceCommon = -1;   /* INTEGER_0_15 */
static int hf_nr_rrc_pucch_GroupHopping = -1;     /* T_pucch_GroupHopping */
static int hf_nr_rrc_hoppingId = -1;              /* INTEGER_0_1023 */
static int hf_nr_rrc_p0_nominal = -1;             /* INTEGER_M202_24 */
static int hf_nr_rrc_deltaF_PUCCH_f0 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f1 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f2 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f3 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f4 = -1;        /* INTEGER_M16_15 */
static int hf_nr_rrc_p0_Set = -1;                 /* SEQUENCE_SIZE_1_maxNrofPUCCH_P0_PerSet_OF_P0_PUCCH */
static int hf_nr_rrc_p0_Set_item = -1;            /* P0_PUCCH */
static int hf_nr_rrc_pathlossReferenceRSs = -1;   /* SEQUENCE_SIZE_1_maxNrofPUCCH_PathlossReferenceRSs_OF_PUCCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSs_item = -1;  /* PUCCH_PathlossReferenceRS */
static int hf_nr_rrc_twoPUCCH_PC_AdjustmentStates = -1;  /* T_twoPUCCH_PC_AdjustmentStates */
static int hf_nr_rrc_p0_PUCCH_Id = -1;            /* P0_PUCCH_Id */
static int hf_nr_rrc_p0_PUCCH_Value = -1;         /* INTEGER_M16_15 */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id = -1;  /* PUCCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_referenceSignal = -1;        /* T_referenceSignal */
static int hf_nr_rrc_csi_RS_Index_01 = -1;        /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_pucch_SpatialRelationInfoId = -1;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_referenceSignal_01 = -1;     /* T_referenceSignal_01 */
static int hf_nr_rrc_srs = -1;                    /* T_srs */
static int hf_nr_rrc_resource = -1;               /* SRS_ResourceId */
static int hf_nr_rrc_uplinkBWP = -1;              /* BWP_Id */
static int hf_nr_rrc_closedLoopIndex = -1;        /* T_closedLoopIndex */
static int hf_nr_rrc_tpc_IndexPCell = -1;         /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexPUCCH_SCell = -1;   /* INTEGER_1_15 */
static int hf_nr_rrc_dataScramblingIdentityPUSCH = -1;  /* INTEGER_0_1023 */
static int hf_nr_rrc_txConfig = -1;               /* T_txConfig */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeA = -1;  /* T_dmrs_UplinkForPUSCH_MappingTypeA */
static int hf_nr_rrc_setup_41 = -1;               /* DMRS_UplinkConfig */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeB = -1;  /* T_dmrs_UplinkForPUSCH_MappingTypeB */
static int hf_nr_rrc_pusch_PowerControl = -1;     /* PUSCH_PowerControl */
static int hf_nr_rrc_frequencyHopping_01 = -1;    /* T_frequencyHopping_01 */
static int hf_nr_rrc_frequencyHoppingOffsetLists = -1;  /* T_frequencyHoppingOffsetLists */
static int hf_nr_rrc_frequencyHoppingOffsetLists_item = -1;  /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_resourceAllocation_02 = -1;  /* T_resourceAllocation_02 */
static int hf_nr_rrc_pusch_TimeDomainAllocationList = -1;  /* T_pusch_TimeDomainAllocationList */
static int hf_nr_rrc_setup_42 = -1;               /* PUSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_pusch_AggregationFactor = -1;  /* T_pusch_AggregationFactor */
static int hf_nr_rrc_mcs_Table_02 = -1;           /* T_mcs_Table_02 */
static int hf_nr_rrc_mcs_TableTransformPrecoder_01 = -1;  /* T_mcs_TableTransformPrecoder_01 */
static int hf_nr_rrc_transformPrecoder_01 = -1;   /* T_transformPrecoder_01 */
static int hf_nr_rrc_codebookSubset = -1;         /* T_codebookSubset */
static int hf_nr_rrc_maxRank = -1;                /* INTEGER_1_4 */
static int hf_nr_rrc_rbg_Size_02 = -1;            /* T_rbg_Size_02 */
static int hf_nr_rrc_uci_OnPUSCH_01 = -1;         /* T_uci_OnPUSCH_01 */
static int hf_nr_rrc_setup_43 = -1;               /* UCI_OnPUSCH */
static int hf_nr_rrc_tp_pi2BPSK = -1;             /* T_tp_pi2BPSK */
static int hf_nr_rrc_betaOffsets = -1;            /* T_betaOffsets */
static int hf_nr_rrc_dynamic_01 = -1;             /* SEQUENCE_SIZE_4_OF_BetaOffsets */
static int hf_nr_rrc_scaling = -1;                /* T_scaling */
static int hf_nr_rrc_groupHoppingEnabledTransformPrecoding = -1;  /* T_groupHoppingEnabledTransformPrecoding */
static int hf_nr_rrc_pusch_TimeDomainAllocationList_01 = -1;  /* PUSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_msg3_DeltaPreamble = -1;     /* INTEGER_M1_6 */
static int hf_nr_rrc_p0_NominalWithGrant = -1;    /* INTEGER_M202_24 */
static int hf_nr_rrc_tpc_Accumulation = -1;       /* T_tpc_Accumulation */
static int hf_nr_rrc_msg3_Alpha = -1;             /* Alpha */
static int hf_nr_rrc_p0_NominalWithoutGrant = -1;  /* INTEGER_M202_24 */
static int hf_nr_rrc_p0_AlphaSets = -1;           /* SEQUENCE_SIZE_1_maxNrofP0_PUSCH_AlphaSets_OF_P0_PUSCH_AlphaSet */
static int hf_nr_rrc_p0_AlphaSets_item = -1;      /* P0_PUSCH_AlphaSet */
static int hf_nr_rrc_pathlossReferenceRSToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSToAddModList_item = -1;  /* PUSCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList_item = -1;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_twoPUSCH_PC_AdjustmentStates = -1;  /* T_twoPUSCH_PC_AdjustmentStates */
static int hf_nr_rrc_deltaMCS = -1;               /* T_deltaMCS */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList_item = -1;  /* SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList_item = -1;  /* SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_p0_PUSCH_AlphaSetId = -1;    /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_p0 = -1;                     /* INTEGER_M16_15 */
static int hf_nr_rrc_alpha = -1;                  /* Alpha */
static int hf_nr_rrc_pusch_PathlossReferenceRS_Id = -1;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_referenceSignal_02 = -1;     /* T_referenceSignal_02 */
static int hf_nr_rrc_sri_PUSCH_PowerControlId = -1;  /* SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_sri_PUSCH_PathlossReferenceRS_Id = -1;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_sri_P0_PUSCH_AlphaSetId = -1;  /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_sri_PUSCH_ClosedLoopIndex = -1;  /* T_sri_PUSCH_ClosedLoopIndex */
static int hf_nr_rrc_codeBlockGroupTransmission_01 = -1;  /* T_codeBlockGroupTransmission_01 */
static int hf_nr_rrc_setup_44 = -1;               /* PUSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_rateMatching = -1;           /* T_rateMatching */
static int hf_nr_rrc_xOverhead_01 = -1;           /* T_xOverhead_01 */
static int hf_nr_rrc_maxMIMO_Layers_01 = -1;      /* INTEGER_1_4 */
static int hf_nr_rrc_maxCodeBlockGroupsPerTransportBlock_01 = -1;  /* T_maxCodeBlockGroupsPerTransportBlock_01 */
static int hf_nr_rrc_PUSCH_TimeDomainResourceAllocationList_item = -1;  /* PUSCH_TimeDomainResourceAllocation */
static int hf_nr_rrc_k2 = -1;                     /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType_01 = -1;         /* T_mappingType_01 */
static int hf_nr_rrc_tpc_Index = -1;              /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexSUL = -1;           /* INTEGER_1_15 */
static int hf_nr_rrc_targetCell = -1;             /* ServCellIndex */
static int hf_nr_rrc_quantityConfigNR_List = -1;  /* SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR */
static int hf_nr_rrc_quantityConfigNR_List_item = -1;  /* QuantityConfigNR */
static int hf_nr_rrc_quantityConfigEUTRA = -1;    /* FilterConfig */
static int hf_nr_rrc_quantityConfigCell = -1;     /* QuantityConfigRS */
static int hf_nr_rrc_quantityConfigRS_Index = -1;  /* QuantityConfigRS */
static int hf_nr_rrc_ssb_FilterConfig = -1;       /* FilterConfig */
static int hf_nr_rrc_csi_RS_FilterConfig = -1;    /* FilterConfig */
static int hf_nr_rrc_filterCoefficientRSRP = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRSRQ = -1;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRS_SINR = -1;  /* FilterCoefficient */
static int hf_nr_rrc_rach_ConfigGeneric = -1;     /* RACH_ConfigGeneric */
static int hf_nr_rrc_totalNumberOfRA_Preambles = -1;  /* INTEGER_1_63 */
static int hf_nr_rrc_ssb_perRACH_OccasionAndCB_PreamblesPerSSB = -1;  /* T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB */
static int hf_nr_rrc_oneEighth = -1;              /* T_oneEighth */
static int hf_nr_rrc_oneFourth = -1;              /* T_oneFourth */
static int hf_nr_rrc_oneHalf = -1;                /* T_oneHalf */
static int hf_nr_rrc_one_01 = -1;                 /* T_one */
static int hf_nr_rrc_two_01 = -1;                 /* T_two_01 */
static int hf_nr_rrc_four = -1;                   /* INTEGER_1_16 */
static int hf_nr_rrc_eight = -1;                  /* INTEGER_1_8 */
static int hf_nr_rrc_sixteen = -1;                /* INTEGER_1_4 */
static int hf_nr_rrc_groupBconfigured = -1;       /* T_groupBconfigured */
static int hf_nr_rrc_ra_Msg3SizeGroupA = -1;      /* T_ra_Msg3SizeGroupA */
static int hf_nr_rrc_messagePowerOffsetGroupB = -1;  /* T_messagePowerOffsetGroupB */
static int hf_nr_rrc_numberOfRA_PreamblesGroupA = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_ra_ContentionResolutionTimer = -1;  /* T_ra_ContentionResolutionTimer */
static int hf_nr_rrc_rsrp_ThresholdSSB_SUL = -1;  /* RSRP_Range */
static int hf_nr_rrc_prach_RootSequenceIndex = -1;  /* T_prach_RootSequenceIndex */
static int hf_nr_rrc_l839 = -1;                   /* INTEGER_0_837 */
static int hf_nr_rrc_l139 = -1;                   /* INTEGER_0_137 */
static int hf_nr_rrc_msg1_SubcarrierSpacing = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_restrictedSetConfig = -1;    /* T_restrictedSetConfig */
static int hf_nr_rrc_msg3_transformPrecoder = -1;  /* T_msg3_transformPrecoder */
static int hf_nr_rrc_cfra = -1;                   /* CFRA */
static int hf_nr_rrc_occasions = -1;              /* T_occasions */
static int hf_nr_rrc_ssb_perRACH_Occasion_01 = -1;  /* T_ssb_perRACH_Occasion_01 */
static int hf_nr_rrc_resources = -1;              /* T_resources */
static int hf_nr_rrc_ssb_02 = -1;                 /* T_ssb */
static int hf_nr_rrc_ssb_ResourceList = -1;       /* SEQUENCE_SIZE_1_maxRA_SSB_Resources_OF_CFRA_SSB_Resource */
static int hf_nr_rrc_ssb_ResourceList_item = -1;  /* CFRA_SSB_Resource */
static int hf_nr_rrc_csirs = -1;                  /* T_csirs */
static int hf_nr_rrc_csirs_ResourceList = -1;     /* SEQUENCE_SIZE_1_maxRA_CSIRS_Resources_OF_CFRA_CSIRS_Resource */
static int hf_nr_rrc_csirs_ResourceList_item = -1;  /* CFRA_CSIRS_Resource */
static int hf_nr_rrc_rsrp_ThresholdCSI_RS = -1;   /* RSRP_Range */
static int hf_nr_rrc_totalNumberOfRA_Preambles_v1530 = -1;  /* INTEGER_1_63 */
static int hf_nr_rrc_csi_RS_02 = -1;              /* CSI_RS_Index */
static int hf_nr_rrc_ra_OccasionList_01 = -1;     /* T_ra_OccasionList_01 */
static int hf_nr_rrc_prach_ConfigurationIndex = -1;  /* INTEGER_0_255 */
static int hf_nr_rrc_msg1_FDM = -1;               /* T_msg1_FDM */
static int hf_nr_rrc_msg1_FrequencyStart = -1;    /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_zeroCorrelationZoneConfig = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_preambleReceivedTargetPower = -1;  /* INTEGER_M202_M60 */
static int hf_nr_rrc_preambleTransMax = -1;       /* T_preambleTransMax */
static int hf_nr_rrc_powerRampingStep = -1;       /* T_powerRampingStep */
static int hf_nr_rrc_ra_ResponseWindow = -1;      /* T_ra_ResponseWindow */
static int hf_nr_rrc_powerRampingStepHighPriority = -1;  /* T_powerRampingStepHighPriority */
static int hf_nr_rrc_scalingFactorBI = -1;        /* T_scalingFactorBI */
static int hf_nr_rrc_srb_ToAddModList = -1;       /* SRB_ToAddModList */
static int hf_nr_rrc_srb3_ToRelease = -1;         /* T_srb3_ToRelease */
static int hf_nr_rrc_drb_ToAddModList = -1;       /* DRB_ToAddModList */
static int hf_nr_rrc_drb_ToReleaseList = -1;      /* DRB_ToReleaseList */
static int hf_nr_rrc_securityConfig = -1;         /* SecurityConfig */
static int hf_nr_rrc_SRB_ToAddModList_item = -1;  /* SRB_ToAddMod */
static int hf_nr_rrc_srb_Identity = -1;           /* SRB_Identity */
static int hf_nr_rrc_reestablishPDCP = -1;        /* T_reestablishPDCP */
static int hf_nr_rrc_discardOnPDCP = -1;          /* T_discardOnPDCP */
static int hf_nr_rrc_pdcp_Config = -1;            /* PDCP_Config */
static int hf_nr_rrc_DRB_ToAddModList_item = -1;  /* DRB_ToAddMod */
static int hf_nr_rrc_cnAssociation = -1;          /* T_cnAssociation */
static int hf_nr_rrc_eps_BearerIdentity = -1;     /* INTEGER_0_15 */
static int hf_nr_rrc_sdap_Config = -1;            /* SDAP_Config */
static int hf_nr_rrc_reestablishPDCP_01 = -1;     /* T_reestablishPDCP_01 */
static int hf_nr_rrc_recoverPDCP = -1;            /* T_recoverPDCP */
static int hf_nr_rrc_DRB_ToReleaseList_item = -1;  /* DRB_Identity */
static int hf_nr_rrc_keyToUse = -1;               /* T_keyToUse */
static int hf_nr_rrc_failureDetectionResourcesToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS */
static int hf_nr_rrc_failureDetectionResourcesToAddModList_item = -1;  /* RadioLinkMonitoringRS */
static int hf_nr_rrc_failureDetectionResourcesToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_failureDetectionResourcesToReleaseList_item = -1;  /* RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_beamFailureInstanceMaxCount = -1;  /* T_beamFailureInstanceMaxCount */
static int hf_nr_rrc_beamFailureDetectionTimer = -1;  /* T_beamFailureDetectionTimer */
static int hf_nr_rrc_radioLinkMonitoringRS_Id = -1;  /* RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_purpose = -1;                /* T_purpose */
static int hf_nr_rrc_detectionResource = -1;      /* T_detectionResource */
static int hf_nr_rrc_rateMatchPatternId = -1;     /* RateMatchPatternId */
static int hf_nr_rrc_patternType = -1;            /* T_patternType */
static int hf_nr_rrc_bitmaps = -1;                /* T_bitmaps */
static int hf_nr_rrc_resourceBlocks = -1;         /* BIT_STRING_SIZE_275 */
static int hf_nr_rrc_symbolsInResourceBlock = -1;  /* T_symbolsInResourceBlock */
static int hf_nr_rrc_oneSlot = -1;                /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_twoSlots = -1;               /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_periodicityAndPattern = -1;  /* T_periodicityAndPattern */
static int hf_nr_rrc_n2 = -1;                     /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_n4 = -1;                     /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_n5 = -1;                     /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_n8 = -1;                     /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_n10 = -1;                    /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_n20 = -1;                    /* BIT_STRING_SIZE_20 */
static int hf_nr_rrc_n40 = -1;                    /* BIT_STRING_SIZE_40 */
static int hf_nr_rrc_controlResourceSet = -1;     /* ControlResourceSetId */
static int hf_nr_rrc_dummy_03 = -1;               /* T_dummy_01 */
static int hf_nr_rrc_carrierFreqDL = -1;          /* INTEGER_0_16383 */
static int hf_nr_rrc_carrierBandwidthDL = -1;     /* T_carrierBandwidthDL */
static int hf_nr_rrc_mbsfn_SubframeConfigList = -1;  /* EUTRA_MBSFN_SubframeConfigList */
static int hf_nr_rrc_nrofCRS_Ports = -1;          /* T_nrofCRS_Ports */
static int hf_nr_rrc_v_Shift = -1;                /* T_v_Shift */
static int hf_nr_rrc_reportType = -1;             /* T_reportType */
static int hf_nr_rrc_periodical = -1;             /* PeriodicalReportConfigInterRAT */
static int hf_nr_rrc_eventTriggered = -1;         /* EventTriggerConfigInterRAT */
static int hf_nr_rrc_reportCGI = -1;              /* ReportCGI_EUTRA */
static int hf_nr_rrc_reportSFTD = -1;             /* ReportSFTD_EUTRA */
static int hf_nr_rrc_cellForWhichToReportCGI_01 = -1;  /* EUTRA_PhysCellId */
static int hf_nr_rrc_reportSFTD_Meas = -1;        /* BOOLEAN */
static int hf_nr_rrc_reportRSRP = -1;             /* BOOLEAN */
static int hf_nr_rrc_eventId = -1;                /* T_eventId */
static int hf_nr_rrc_eventB1 = -1;                /* T_eventB1 */
static int hf_nr_rrc_b1_ThresholdEUTRA = -1;      /* MeasTriggerQuantityEUTRA */
static int hf_nr_rrc_reportOnLeave = -1;          /* BOOLEAN */
static int hf_nr_rrc_hysteresis = -1;             /* Hysteresis */
static int hf_nr_rrc_timeToTrigger = -1;          /* TimeToTrigger */
static int hf_nr_rrc_eventB2 = -1;                /* T_eventB2 */
static int hf_nr_rrc_b2_Threshold1 = -1;          /* MeasTriggerQuantity */
static int hf_nr_rrc_b2_Threshold2EUTRA = -1;     /* MeasTriggerQuantityEUTRA */
static int hf_nr_rrc_rsType = -1;                 /* NR_RS_Type */
static int hf_nr_rrc_reportInterval = -1;         /* ReportInterval */
static int hf_nr_rrc_reportAmount = -1;           /* T_reportAmount */
static int hf_nr_rrc_reportQuantity_01 = -1;      /* MeasReportQuantity */
static int hf_nr_rrc_maxReportCells = -1;         /* INTEGER_1_maxCellReport */
static int hf_nr_rrc_reportAmount_01 = -1;        /* T_reportAmount_01 */
static int hf_nr_rrc_reportType_01 = -1;          /* T_reportType_01 */
static int hf_nr_rrc_periodical_01 = -1;          /* PeriodicalReportConfig */
static int hf_nr_rrc_eventTriggered_01 = -1;      /* EventTriggerConfig */
static int hf_nr_rrc_reportCGI_01 = -1;           /* ReportCGI */
static int hf_nr_rrc_reportSFTD_01 = -1;          /* ReportSFTD_NR */
static int hf_nr_rrc_reportSFTD_NeighMeas = -1;   /* T_reportSFTD_NeighMeas */
static int hf_nr_rrc_drx_SFTD_NeighMeas = -1;     /* T_drx_SFTD_NeighMeas */
static int hf_nr_rrc_cellsForWhichToReportSFTD = -1;  /* SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId */
static int hf_nr_rrc_cellsForWhichToReportSFTD_item = -1;  /* PhysCellId */
static int hf_nr_rrc_eventId_01 = -1;             /* T_eventId_01 */
static int hf_nr_rrc_eventA1 = -1;                /* T_eventA1 */
static int hf_nr_rrc_a1_Threshold = -1;           /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA2 = -1;                /* T_eventA2 */
static int hf_nr_rrc_a2_Threshold = -1;           /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA3 = -1;                /* T_eventA3 */
static int hf_nr_rrc_a3_Offset = -1;              /* MeasTriggerQuantityOffset */
static int hf_nr_rrc_useWhiteCellList = -1;       /* BOOLEAN */
static int hf_nr_rrc_eventA4 = -1;                /* T_eventA4 */
static int hf_nr_rrc_a4_Threshold = -1;           /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA5 = -1;                /* T_eventA5 */
static int hf_nr_rrc_a5_Threshold1 = -1;          /* MeasTriggerQuantity */
static int hf_nr_rrc_a5_Threshold2 = -1;          /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA6 = -1;                /* T_eventA6 */
static int hf_nr_rrc_a6_Offset = -1;              /* MeasTriggerQuantityOffset */
static int hf_nr_rrc_reportAmount_02 = -1;        /* T_reportAmount_02 */
static int hf_nr_rrc_reportQuantityCell = -1;     /* MeasReportQuantity */
static int hf_nr_rrc_reportQuantityRS_Indexes = -1;  /* MeasReportQuantity */
static int hf_nr_rrc_maxNrofRS_IndexesToReport = -1;  /* INTEGER_1_maxNrofIndexesToReport */
static int hf_nr_rrc_includeBeamMeasurements = -1;  /* BOOLEAN */
static int hf_nr_rrc_reportAddNeighMeas = -1;     /* T_reportAddNeighMeas */
static int hf_nr_rrc_reportAmount_03 = -1;        /* T_reportAmount_03 */
static int hf_nr_rrc_rsrp_02 = -1;                /* INTEGER_M30_30 */
static int hf_nr_rrc_rsrq_02 = -1;                /* INTEGER_M30_30 */
static int hf_nr_rrc_sinr_02 = -1;                /* INTEGER_M30_30 */
static int hf_nr_rrc_rsrp_03 = -1;                /* BOOLEAN */
static int hf_nr_rrc_rsrq_03 = -1;                /* BOOLEAN */
static int hf_nr_rrc_sinr_03 = -1;                /* BOOLEAN */
static int hf_nr_rrc_ReportConfigToAddModList_item = -1;  /* ReportConfigToAddMod */
static int hf_nr_rrc_reportConfig = -1;           /* T_reportConfig */
static int hf_nr_rrc_reportConfigNR = -1;         /* ReportConfigNR */
static int hf_nr_rrc_reportConfigInterRAT = -1;   /* ReportConfigInterRAT */
static int hf_nr_rrc_servedRadioBearer = -1;      /* T_servedRadioBearer */
static int hf_nr_rrc_reestablishRLC = -1;         /* T_reestablishRLC */
static int hf_nr_rrc_rlc_Config = -1;             /* RLC_Config */
static int hf_nr_rrc_mac_LogicalChannelConfig = -1;  /* LogicalChannelConfig */
static int hf_nr_rrc_am = -1;                     /* T_am */
static int hf_nr_rrc_ul_AM_RLC = -1;              /* UL_AM_RLC */
static int hf_nr_rrc_dl_AM_RLC = -1;              /* DL_AM_RLC */
static int hf_nr_rrc_um_Bi_Directional = -1;      /* T_um_Bi_Directional */
static int hf_nr_rrc_ul_UM_RLC = -1;              /* UL_UM_RLC */
static int hf_nr_rrc_dl_UM_RLC = -1;              /* DL_UM_RLC */
static int hf_nr_rrc_um_Uni_Directional_UL = -1;  /* T_um_Uni_Directional_UL */
static int hf_nr_rrc_um_Uni_Directional_DL = -1;  /* T_um_Uni_Directional_DL */
static int hf_nr_rrc_sn_FieldLength = -1;         /* SN_FieldLengthAM */
static int hf_nr_rrc_t_PollRetransmit = -1;       /* T_PollRetransmit */
static int hf_nr_rrc_pollPDU = -1;                /* PollPDU */
static int hf_nr_rrc_pollByte = -1;               /* PollByte */
static int hf_nr_rrc_maxRetxThreshold = -1;       /* T_maxRetxThreshold */
static int hf_nr_rrc_t_Reassembly = -1;           /* T_Reassembly */
static int hf_nr_rrc_t_StatusProhibit = -1;       /* T_StatusProhibit */
static int hf_nr_rrc_sn_FieldLength_01 = -1;      /* SN_FieldLengthUM */
static int hf_nr_rrc_t310 = -1;                   /* T_t310 */
static int hf_nr_rrc_n310 = -1;                   /* T_n310 */
static int hf_nr_rrc_n311 = -1;                   /* T_n311 */
static int hf_nr_rrc_t311_v1530 = -1;             /* T_t311_v1530 */
static int hf_nr_rrc_schedulingRequestToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestToAddMod */
static int hf_nr_rrc_schedulingRequestToAddModList_item = -1;  /* SchedulingRequestToAddMod */
static int hf_nr_rrc_schedulingRequestToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestToReleaseList_item = -1;  /* SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestId = -1;    /* SchedulingRequestId */
static int hf_nr_rrc_sr_ProhibitTimer = -1;       /* T_sr_ProhibitTimer */
static int hf_nr_rrc_sr_TransMax = -1;            /* T_sr_TransMax */
static int hf_nr_rrc_schedulingRequestResourceId = -1;  /* SchedulingRequestResourceId */
static int hf_nr_rrc_periodicityAndOffset_01 = -1;  /* T_periodicityAndOffset */
static int hf_nr_rrc_sym2 = -1;                   /* NULL */
static int hf_nr_rrc_sym6or7 = -1;                /* NULL */
static int hf_nr_rrc_sl1 = -1;                    /* NULL */
static int hf_nr_rrc_sl2 = -1;                    /* INTEGER_0_1 */
static int hf_nr_rrc_sl4 = -1;                    /* INTEGER_0_3 */
static int hf_nr_rrc_sl5 = -1;                    /* INTEGER_0_4 */
static int hf_nr_rrc_sl8 = -1;                    /* INTEGER_0_7 */
static int hf_nr_rrc_sl10 = -1;                   /* INTEGER_0_9 */
static int hf_nr_rrc_sl16 = -1;                   /* INTEGER_0_15 */
static int hf_nr_rrc_sl20 = -1;                   /* INTEGER_0_19 */
static int hf_nr_rrc_sl40 = -1;                   /* INTEGER_0_39 */
static int hf_nr_rrc_sl80 = -1;                   /* INTEGER_0_79 */
static int hf_nr_rrc_sl160 = -1;                  /* INTEGER_0_159 */
static int hf_nr_rrc_sl320 = -1;                  /* INTEGER_0_319 */
static int hf_nr_rrc_sl640 = -1;                  /* INTEGER_0_639 */
static int hf_nr_rrc_resource_01 = -1;            /* PUCCH_ResourceId */
static int hf_nr_rrc_offsetToCarrier = -1;        /* INTEGER_0_2199 */
static int hf_nr_rrc_carrierBandwidth = -1;       /* INTEGER_1_maxNrofPhysicalResourceBlocks */
static int hf_nr_rrc_txDirectCurrentLocation_v1530 = -1;  /* INTEGER_0_4095 */
static int hf_nr_rrc_pdu_Session = -1;            /* PDU_SessionID */
static int hf_nr_rrc_sdap_HeaderDL = -1;          /* T_sdap_HeaderDL */
static int hf_nr_rrc_sdap_HeaderUL = -1;          /* T_sdap_HeaderUL */
static int hf_nr_rrc_defaultDRB = -1;             /* BOOLEAN */
static int hf_nr_rrc_mappedQoS_FlowsToAdd = -1;   /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI */
static int hf_nr_rrc_mappedQoS_FlowsToAdd_item = -1;  /* QFI */
static int hf_nr_rrc_mappedQoS_FlowsToRelease = -1;  /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI */
static int hf_nr_rrc_mappedQoS_FlowsToRelease_item = -1;  /* QFI */
static int hf_nr_rrc_searchSpaceId = -1;          /* SearchSpaceId */
static int hf_nr_rrc_monitoringSlotPeriodicityAndOffset = -1;  /* T_monitoringSlotPeriodicityAndOffset */
static int hf_nr_rrc_sl1280 = -1;                 /* INTEGER_0_1279 */
static int hf_nr_rrc_sl2560 = -1;                 /* INTEGER_0_2559 */
static int hf_nr_rrc_duration_01 = -1;            /* INTEGER_2_2559 */
static int hf_nr_rrc_monitoringSymbolsWithinSlot = -1;  /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_nrofCandidates = -1;         /* T_nrofCandidates */
static int hf_nr_rrc_aggregationLevel1 = -1;      /* T_aggregationLevel1 */
static int hf_nr_rrc_aggregationLevel2 = -1;      /* T_aggregationLevel2 */
static int hf_nr_rrc_aggregationLevel4 = -1;      /* T_aggregationLevel4 */
static int hf_nr_rrc_aggregationLevel8 = -1;      /* T_aggregationLevel8 */
static int hf_nr_rrc_aggregationLevel16 = -1;     /* T_aggregationLevel16 */
static int hf_nr_rrc_searchSpaceType = -1;        /* T_searchSpaceType */
static int hf_nr_rrc_common = -1;                 /* T_common */
static int hf_nr_rrc_dci_Format0_0_AndFormat1_0 = -1;  /* T_dci_Format0_0_AndFormat1_0 */
static int hf_nr_rrc_dci_Format2_0 = -1;          /* T_dci_Format2_0 */
static int hf_nr_rrc_nrofCandidates_SFI = -1;     /* T_nrofCandidates_SFI */
static int hf_nr_rrc_aggregationLevel1_01 = -1;   /* T_aggregationLevel1_01 */
static int hf_nr_rrc_aggregationLevel2_01 = -1;   /* T_aggregationLevel2_01 */
static int hf_nr_rrc_aggregationLevel4_01 = -1;   /* T_aggregationLevel4_01 */
static int hf_nr_rrc_aggregationLevel8_01 = -1;   /* T_aggregationLevel8_01 */
static int hf_nr_rrc_aggregationLevel16_01 = -1;  /* T_aggregationLevel16_01 */
static int hf_nr_rrc_dci_Format2_1 = -1;          /* T_dci_Format2_1 */
static int hf_nr_rrc_dci_Format2_2 = -1;          /* T_dci_Format2_2 */
static int hf_nr_rrc_dci_Format2_3 = -1;          /* T_dci_Format2_3 */
static int hf_nr_rrc_dummy1 = -1;                 /* T_dummy1 */
static int hf_nr_rrc_dummy2 = -1;                 /* T_dummy2 */
static int hf_nr_rrc_ue_Specific = -1;            /* T_ue_Specific */
static int hf_nr_rrc_dci_Formats = -1;            /* T_dci_Formats */
static int hf_nr_rrc_cipheringAlgorithm = -1;     /* CipheringAlgorithm */
static int hf_nr_rrc_integrityProtAlgorithm = -1;  /* IntegrityProtAlgorithm */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationDedicated = -1;  /* TDD_UL_DL_ConfigDedicated */
static int hf_nr_rrc_initialDownlinkBWP_01 = -1;  /* BWP_DownlinkDedicated */
static int hf_nr_rrc_downlinkBWP_ToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id */
static int hf_nr_rrc_downlinkBWP_ToReleaseList_item = -1;  /* BWP_Id */
static int hf_nr_rrc_downlinkBWP_ToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Downlink */
static int hf_nr_rrc_downlinkBWP_ToAddModList_item = -1;  /* BWP_Downlink */
static int hf_nr_rrc_firstActiveDownlinkBWP_Id = -1;  /* BWP_Id */
static int hf_nr_rrc_bwp_InactivityTimer = -1;    /* T_bwp_InactivityTimer */
static int hf_nr_rrc_defaultDownlinkBWP_Id = -1;  /* BWP_Id */
static int hf_nr_rrc_uplinkConfig = -1;           /* UplinkConfig */
static int hf_nr_rrc_supplementaryUplink_01 = -1;  /* UplinkConfig */
static int hf_nr_rrc_pdcch_ServingCellConfig = -1;  /* T_pdcch_ServingCellConfig */
static int hf_nr_rrc_setup_45 = -1;               /* PDCCH_ServingCellConfig */
static int hf_nr_rrc_pdsch_ServingCellConfig = -1;  /* T_pdsch_ServingCellConfig */
static int hf_nr_rrc_setup_46 = -1;               /* PDSCH_ServingCellConfig */
static int hf_nr_rrc_csi_MeasConfig = -1;         /* T_csi_MeasConfig */
static int hf_nr_rrc_setup_47 = -1;               /* CSI_MeasConfig */
static int hf_nr_rrc_sCellDeactivationTimer = -1;  /* T_sCellDeactivationTimer */
static int hf_nr_rrc_crossCarrierSchedulingConfig = -1;  /* CrossCarrierSchedulingConfig */
static int hf_nr_rrc_tag_Id = -1;                 /* TAG_Id */
static int hf_nr_rrc_dummy_04 = -1;               /* T_dummy_02 */
static int hf_nr_rrc_pathlossReferenceLinking = -1;  /* T_pathlossReferenceLinking */
static int hf_nr_rrc_servingCellMO = -1;          /* MeasObjectId */
static int hf_nr_rrc_lte_CRS_ToMatchAround = -1;  /* T_lte_CRS_ToMatchAround */
static int hf_nr_rrc_setup_48 = -1;               /* RateMatchPatternLTE_CRS */
static int hf_nr_rrc_downlinkChannelBW_PerSCS_List = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_downlinkChannelBW_PerSCS_List_item = -1;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_initialUplinkBWP = -1;       /* BWP_UplinkDedicated */
static int hf_nr_rrc_uplinkBWP_ToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id */
static int hf_nr_rrc_uplinkBWP_ToReleaseList_item = -1;  /* BWP_Id */
static int hf_nr_rrc_uplinkBWP_ToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Uplink */
static int hf_nr_rrc_uplinkBWP_ToAddModList_item = -1;  /* BWP_Uplink */
static int hf_nr_rrc_firstActiveUplinkBWP_Id = -1;  /* BWP_Id */
static int hf_nr_rrc_pusch_ServingCellConfig = -1;  /* T_pusch_ServingCellConfig */
static int hf_nr_rrc_setup_49 = -1;               /* PUSCH_ServingCellConfig */
static int hf_nr_rrc_carrierSwitching = -1;       /* T_carrierSwitching */
static int hf_nr_rrc_setup_50 = -1;               /* SRS_CarrierSwitching */
static int hf_nr_rrc_powerBoostPi2BPSK = -1;      /* BOOLEAN */
static int hf_nr_rrc_uplinkChannelBW_PerSCS_List = -1;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_uplinkChannelBW_PerSCS_List_item = -1;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_downlinkConfigCommon = -1;   /* DownlinkConfigCommon */
static int hf_nr_rrc_uplinkConfigCommon = -1;     /* UplinkConfigCommon */
static int hf_nr_rrc_supplementaryUplinkConfig = -1;  /* UplinkConfigCommon */
static int hf_nr_rrc_n_TimingAdvanceOffset = -1;  /* T_n_TimingAdvanceOffset */
static int hf_nr_rrc_ssb_PositionsInBurst = -1;   /* T_ssb_PositionsInBurst */
static int hf_nr_rrc_shortBitmap = -1;            /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_mediumBitmap = -1;           /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_longBitmap = -1;             /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_ssb_periodicityServingCell = -1;  /* T_ssb_periodicityServingCell */
static int hf_nr_rrc_dmrs_TypeA_Position_01 = -1;  /* T_dmrs_TypeA_Position_01 */
static int hf_nr_rrc_lte_CRS_ToMatchAround_01 = -1;  /* T_lte_CRS_ToMatchAround_01 */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationCommon = -1;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_ss_PBCH_BlockPower = -1;     /* INTEGER_M60_50 */
static int hf_nr_rrc_downlinkConfigCommon_01 = -1;  /* DownlinkConfigCommonSIB */
static int hf_nr_rrc_uplinkConfigCommon_01 = -1;  /* UplinkConfigCommonSIB */
static int hf_nr_rrc_supplementaryUplink_02 = -1;  /* UplinkConfigCommonSIB */
static int hf_nr_rrc_n_TimingAdvanceOffset_01 = -1;  /* T_n_TimingAdvanceOffset_01 */
static int hf_nr_rrc_ssb_PositionsInBurst_01 = -1;  /* T_ssb_PositionsInBurst_01 */
static int hf_nr_rrc_inOneGroup = -1;             /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_groupPresence = -1;          /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_ssb_PeriodicityServingCell = -1;  /* T_ssb_PeriodicityServingCell */
static int hf_nr_rrc_schedulingInfoList = -1;     /* SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo */
static int hf_nr_rrc_schedulingInfoList_item = -1;  /* SchedulingInfo */
static int hf_nr_rrc_si_WindowLength = -1;        /* T_si_WindowLength */
static int hf_nr_rrc_si_RequestConfig = -1;       /* SI_RequestConfig */
static int hf_nr_rrc_si_RequestConfigSUL = -1;    /* SI_RequestConfig */
static int hf_nr_rrc_systemInformationAreaID = -1;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_si_BroadcastStatus = -1;     /* T_si_BroadcastStatus */
static int hf_nr_rrc_si_Periodicity = -1;         /* T_si_Periodicity */
static int hf_nr_rrc_sib_MappingInfo = -1;        /* SIB_Mapping */
static int hf_nr_rrc_SIB_Mapping_item = -1;       /* SIB_TypeInfo */
static int hf_nr_rrc_type = -1;                   /* T_type */
static int hf_nr_rrc_valueTag = -1;               /* INTEGER_0_31 */
static int hf_nr_rrc_areaScope = -1;              /* T_areaScope */
static int hf_nr_rrc_rach_OccasionsSI = -1;       /* T_rach_OccasionsSI */
static int hf_nr_rrc_rach_ConfigSI = -1;          /* RACH_ConfigGeneric */
static int hf_nr_rrc_ssb_perRACH_Occasion_02 = -1;  /* T_ssb_perRACH_Occasion_02 */
static int hf_nr_rrc_si_RequestPeriod = -1;       /* T_si_RequestPeriod */
static int hf_nr_rrc_si_RequestResources = -1;    /* SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources */
static int hf_nr_rrc_si_RequestResources_item = -1;  /* SI_RequestResources */
static int hf_nr_rrc_ra_PreambleStartIndex = -1;  /* INTEGER_0_63 */
static int hf_nr_rrc_ra_AssociationPeriodIndex = -1;  /* INTEGER_0_15 */
static int hf_nr_rrc_subcarrierSpacing2 = -1;     /* SubcarrierSpacing */
static int hf_nr_rrc_slotFormatCombinations = -1;  /* SEQUENCE_SIZE_1_maxNrofSlotFormatCombinationsPerSet_OF_SlotFormatCombination */
static int hf_nr_rrc_slotFormatCombinations_item = -1;  /* SlotFormatCombination */
static int hf_nr_rrc_positionInDCI_01 = -1;       /* INTEGER_0_maxSFI_DCI_PayloadSize_1 */
static int hf_nr_rrc_slotFormatCombinationId = -1;  /* SlotFormatCombinationId */
static int hf_nr_rrc_slotFormats = -1;            /* T_slotFormats */
static int hf_nr_rrc_slotFormats_item = -1;       /* INTEGER_0_255 */
static int hf_nr_rrc_sfi_RNTI = -1;               /* RNTI_Value */
static int hf_nr_rrc_dci_PayloadSize_01 = -1;     /* INTEGER_1_maxSFI_DCI_PayloadSize */
static int hf_nr_rrc_slotFormatCombToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_SlotFormatCombinationsPerCell */
static int hf_nr_rrc_slotFormatCombToAddModList_item = -1;  /* SlotFormatCombinationsPerCell */
static int hf_nr_rrc_slotFormatCombToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex */
static int hf_nr_rrc_slotFormatCombToReleaseList_item = -1;  /* ServCellIndex */
static int hf_nr_rrc_sst = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_sst_SD = -1;                 /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_sf_Medium_01 = -1;           /* T_sf_Medium_01 */
static int hf_nr_rrc_sf_High_01 = -1;             /* T_sf_High_01 */
static int hf_nr_rrc_periodicity_01 = -1;         /* T_periodicity_01 */
static int hf_nr_rrc_nrofHARQ_Processes_01 = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_n1PUCCH_AN = -1;             /* PUCCH_ResourceId */
static int hf_nr_rrc_mcs_Table_03 = -1;           /* T_mcs_Table_03 */
static int hf_nr_rrc_srs_SwitchFromServCellIndex = -1;  /* INTEGER_0_31 */
static int hf_nr_rrc_srs_SwitchFromCarrier = -1;  /* T_srs_SwitchFromCarrier */
static int hf_nr_rrc_srs_TPC_PDCCH_Group = -1;    /* T_srs_TPC_PDCCH_Group */
static int hf_nr_rrc_typeA = -1;                  /* SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_typeA_item = -1;             /* SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_typeB = -1;                  /* SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_monitoringCells = -1;        /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_ServCellIndex */
static int hf_nr_rrc_monitoringCells_item = -1;   /* ServCellIndex */
static int hf_nr_rrc_srs_CC_SetIndexlist = -1;    /* SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex */
static int hf_nr_rrc_srs_CC_SetIndexlist_item = -1;  /* SRS_CC_SetIndex */
static int hf_nr_rrc_cc_SetIndex = -1;            /* INTEGER_0_3 */
static int hf_nr_rrc_cc_IndexInOneCC_Set = -1;    /* INTEGER_0_7 */
static int hf_nr_rrc_srs_ResourceSetToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToReleaseList_item = -1;  /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceSetToAddModList_item = -1;  /* SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceToReleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceToReleaseList_item = -1;  /* SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_Resource */
static int hf_nr_rrc_srs_ResourceToAddModList_item = -1;  /* SRS_Resource */
static int hf_nr_rrc_tpc_Accumulation_01 = -1;    /* T_tpc_Accumulation_01 */
static int hf_nr_rrc_srs_ResourceSetId = -1;      /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceIdList = -1;     /* SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceIdList_item = -1;  /* SRS_ResourceId */
static int hf_nr_rrc_resourceType_01 = -1;        /* T_resourceType_01 */
static int hf_nr_rrc_aperiodic_01 = -1;           /* T_aperiodic_01 */
static int hf_nr_rrc_aperiodicSRS_ResourceTrigger = -1;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_slotOffset = -1;             /* INTEGER_1_32 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_v1530 = -1;  /* T_aperiodicSRS_ResourceTriggerList_v1530 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_v1530_item = -1;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_semi_persistent = -1;        /* T_semi_persistent */
static int hf_nr_rrc_associatedCSI_RS = -1;       /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_periodic_01 = -1;            /* T_periodic_01 */
static int hf_nr_rrc_usage = -1;                  /* T_usage */
static int hf_nr_rrc_p0_01 = -1;                  /* INTEGER_M202_24 */
static int hf_nr_rrc_pathlossReferenceRS = -1;    /* T_pathlossReferenceRS */
static int hf_nr_rrc_srs_PowerControlAdjustmentStates = -1;  /* T_srs_PowerControlAdjustmentStates */
static int hf_nr_rrc_srs_ResourceId = -1;         /* SRS_ResourceId */
static int hf_nr_rrc_nrofSRS_Ports = -1;          /* T_nrofSRS_Ports */
static int hf_nr_rrc_ptrs_PortIndex = -1;         /* T_ptrs_PortIndex */
static int hf_nr_rrc_transmissionComb = -1;       /* T_transmissionComb */
static int hf_nr_rrc_n2_01 = -1;                  /* T_n2 */
static int hf_nr_rrc_combOffset_n2 = -1;          /* INTEGER_0_1 */
static int hf_nr_rrc_cyclicShift_n2 = -1;         /* INTEGER_0_7 */
static int hf_nr_rrc_n4_01 = -1;                  /* T_n4 */
static int hf_nr_rrc_combOffset_n4 = -1;          /* INTEGER_0_3 */
static int hf_nr_rrc_cyclicShift_n4 = -1;         /* INTEGER_0_11 */
static int hf_nr_rrc_resourceMapping_01 = -1;     /* T_resourceMapping */
static int hf_nr_rrc_startPosition = -1;          /* INTEGER_0_5 */
static int hf_nr_rrc_nrofSymbols_02 = -1;         /* T_nrofSymbols */
static int hf_nr_rrc_repetitionFactor = -1;       /* T_repetitionFactor */
static int hf_nr_rrc_freqDomainPosition = -1;     /* INTEGER_0_67 */
static int hf_nr_rrc_freqDomainShift = -1;        /* INTEGER_0_268 */
static int hf_nr_rrc_freqHopping = -1;            /* T_freqHopping */
static int hf_nr_rrc_c_SRS = -1;                  /* INTEGER_0_63 */
static int hf_nr_rrc_b_SRS = -1;                  /* INTEGER_0_3 */
static int hf_nr_rrc_b_hop = -1;                  /* INTEGER_0_3 */
static int hf_nr_rrc_groupOrSequenceHopping = -1;  /* T_groupOrSequenceHopping */
static int hf_nr_rrc_resourceType_02 = -1;        /* T_resourceType_02 */
static int hf_nr_rrc_aperiodic_02 = -1;           /* T_aperiodic_02 */
static int hf_nr_rrc_semi_persistent_01 = -1;     /* T_semi_persistent_01 */
static int hf_nr_rrc_periodicityAndOffset_sp = -1;  /* SRS_PeriodicityAndOffset */
static int hf_nr_rrc_periodic_02 = -1;            /* T_periodic_02 */
static int hf_nr_rrc_periodicityAndOffset_p = -1;  /* SRS_PeriodicityAndOffset */
static int hf_nr_rrc_sequenceId = -1;             /* INTEGER_0_1023 */
static int hf_nr_rrc_spatialRelationInfo = -1;    /* SRS_SpatialRelationInfo */
static int hf_nr_rrc_referenceSignal_03 = -1;     /* T_referenceSignal_03 */
static int hf_nr_rrc_srs_01 = -1;                 /* T_srs_01 */
static int hf_nr_rrc_resourceId = -1;             /* SRS_ResourceId */
static int hf_nr_rrc_sl32 = -1;                   /* INTEGER_0_31 */
static int hf_nr_rrc_sl64 = -1;                   /* INTEGER_0_63 */
static int hf_nr_rrc_startingBitOfFormat2_3 = -1;  /* INTEGER_1_31 */
static int hf_nr_rrc_fieldTypeFormat2_3 = -1;     /* INTEGER_0_1 */
static int hf_nr_rrc_startingBitOfFormat2_3SUL_v1530 = -1;  /* INTEGER_1_31 */
static int hf_nr_rrc_periodicityAndOffset_02 = -1;  /* T_periodicityAndOffset_01 */
static int hf_nr_rrc_sf5 = -1;                    /* INTEGER_0_4 */
static int hf_nr_rrc_sf10 = -1;                   /* INTEGER_0_9 */
static int hf_nr_rrc_sf20 = -1;                   /* INTEGER_0_19 */
static int hf_nr_rrc_sf40 = -1;                   /* INTEGER_0_39 */
static int hf_nr_rrc_sf80 = -1;                   /* INTEGER_0_79 */
static int hf_nr_rrc_sf160 = -1;                  /* INTEGER_0_159 */
static int hf_nr_rrc_duration_02 = -1;            /* T_duration */
static int hf_nr_rrc_pci_List = -1;               /* SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId */
static int hf_nr_rrc_pci_List_item = -1;          /* PhysCellId */
static int hf_nr_rrc_periodicity_02 = -1;         /* T_periodicity_02 */
static int hf_nr_rrc_measurementSlots = -1;       /* BIT_STRING_SIZE_1_80 */
static int hf_nr_rrc_endSymbol = -1;              /* INTEGER_0_3 */
static int hf_nr_rrc_tag_ToReleaseList = -1;      /* SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG_Id */
static int hf_nr_rrc_tag_ToReleaseList_item = -1;  /* TAG_Id */
static int hf_nr_rrc_tag_ToAddModList = -1;       /* SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG */
static int hf_nr_rrc_tag_ToAddModList_item = -1;  /* TAG */
static int hf_nr_rrc_timeAlignmentTimer = -1;     /* TimeAlignmentTimer */
static int hf_nr_rrc_tci_StateId = -1;            /* TCI_StateId */
static int hf_nr_rrc_qcl_Type1 = -1;              /* QCL_Info */
static int hf_nr_rrc_qcl_Type2 = -1;              /* QCL_Info */
static int hf_nr_rrc_cell = -1;                   /* ServCellIndex */
static int hf_nr_rrc_referenceSignal_04 = -1;     /* T_referenceSignal_04 */
static int hf_nr_rrc_csi_rs = -1;                 /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_qcl_Type = -1;               /* T_qcl_Type */
static int hf_nr_rrc_referenceSubcarrierSpacing = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_pattern1_01 = -1;            /* TDD_UL_DL_Pattern */
static int hf_nr_rrc_pattern2 = -1;               /* TDD_UL_DL_Pattern */
static int hf_nr_rrc_dl_UL_TransmissionPeriodicity = -1;  /* T_dl_UL_TransmissionPeriodicity */
static int hf_nr_rrc_nrofDownlinkSlots = -1;      /* INTEGER_0_maxNrofSlots */
static int hf_nr_rrc_nrofDownlinkSymbols = -1;    /* INTEGER_0_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSlots = -1;        /* INTEGER_0_maxNrofSlots */
static int hf_nr_rrc_nrofUplinkSymbols = -1;      /* INTEGER_0_maxNrofSymbols_1 */
static int hf_nr_rrc_dl_UL_TransmissionPeriodicity_v1530 = -1;  /* T_dl_UL_TransmissionPeriodicity_v1530 */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList = -1;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList_item = -1;  /* TDD_UL_DL_SlotConfig */
static int hf_nr_rrc_slotSpecificConfigurationsToreleaseList = -1;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotSpecificConfigurationsToreleaseList_item = -1;  /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotIndex = -1;              /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_symbols = -1;                /* T_symbols */
static int hf_nr_rrc_allDownlink = -1;            /* NULL */
static int hf_nr_rrc_allUplink = -1;              /* NULL */
static int hf_nr_rrc_explicit = -1;               /* T_explicit */
static int hf_nr_rrc_nrofDownlinkSymbols_01 = -1;  /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSymbols_01 = -1;   /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_UAC_BarringInfoSetList_item = -1;  /* UAC_BarringInfoSet */
static int hf_nr_rrc_uac_BarringFactor = -1;      /* T_uac_BarringFactor */
static int hf_nr_rrc_uac_BarringTime = -1;        /* T_uac_BarringTime */
static int hf_nr_rrc_uac_BarringForAccessIdentity = -1;  /* BIT_STRING_SIZE_7 */
static int hf_nr_rrc_UAC_BarringPerCatList_item = -1;  /* UAC_BarringPerCat */
static int hf_nr_rrc_accessCategory = -1;         /* INTEGER_1_maxAccessCat_1 */
static int hf_nr_rrc_uac_barringInfoSetIndex = -1;  /* UAC_BarringInfoSetIndex */
static int hf_nr_rrc_UAC_BarringPerPLMN_List_item = -1;  /* UAC_BarringPerPLMN */
static int hf_nr_rrc_plmn_IdentityIndex = -1;     /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_uac_ACBarringListType = -1;  /* T_uac_ACBarringListType */
static int hf_nr_rrc_uac_ImplicitACBarringList = -1;  /* SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex */
static int hf_nr_rrc_uac_ImplicitACBarringList_item = -1;  /* UAC_BarringInfoSetIndex */
static int hf_nr_rrc_uac_ExplicitACBarringList = -1;  /* UAC_BarringPerCatList */
static int hf_nr_rrc_t300 = -1;                   /* T_t300 */
static int hf_nr_rrc_t301 = -1;                   /* T_t301 */
static int hf_nr_rrc_t310_01 = -1;                /* T_t310_01 */
static int hf_nr_rrc_n310_01 = -1;                /* T_n310_01 */
static int hf_nr_rrc_t311 = -1;                   /* T_t311 */
static int hf_nr_rrc_n311_01 = -1;                /* T_n311_01 */
static int hf_nr_rrc_t319 = -1;                   /* T_t319 */
static int hf_nr_rrc_frequencyInfoUL = -1;        /* FrequencyInfoUL */
static int hf_nr_rrc_initialUplinkBWP_01 = -1;    /* BWP_UplinkCommon */
static int hf_nr_rrc_dummy_05 = -1;               /* TimeAlignmentTimer */
static int hf_nr_rrc_frequencyInfoUL_01 = -1;     /* FrequencyInfoUL_SIB */
static int hf_nr_rrc_timeAlignmentTimerCommon = -1;  /* TimeAlignmentTimer */
static int hf_nr_rrc_UplinkTxDirectCurrentList_item = -1;  /* UplinkTxDirectCurrentCell */
static int hf_nr_rrc_uplinkDirectCurrentBWP = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_item = -1;  /* UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_SUL = -1;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_SUL_item = -1;  /* UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_shift7dot5kHz = -1;          /* BOOLEAN */
static int hf_nr_rrc_txDirectCurrentLocation = -1;  /* INTEGER_0_3301 */
static int hf_nr_rrc_zp_CSI_RS_ResourceId = -1;   /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceSetId = -1;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_zp_CSI_RS_ResourceIdList = -1;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourcesPerSet_OF_ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceIdList_item = -1;  /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_BandCombinationList_item = -1;  /* BandCombination */
static int hf_nr_rrc_BandCombinationList_v1540_item = -1;  /* BandCombination_v1540 */
static int hf_nr_rrc_BandCombinationList_v1550_item = -1;  /* BandCombination_v1550 */
static int hf_nr_rrc_BandCombinationList_v1560_item = -1;  /* BandCombination_v1560 */
static int hf_nr_rrc_BandCombinationList_v1570_item = -1;  /* BandCombination_v1570 */
static int hf_nr_rrc_bandList = -1;               /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters */
static int hf_nr_rrc_bandList_item = -1;          /* BandParameters */
static int hf_nr_rrc_featureSetCombination = -1;  /* FeatureSetCombinationId */
static int hf_nr_rrc_ca_ParametersEUTRA = -1;     /* CA_ParametersEUTRA */
static int hf_nr_rrc_ca_ParametersNR = -1;        /* CA_ParametersNR */
static int hf_nr_rrc_mrdc_Parameters = -1;        /* MRDC_Parameters */
static int hf_nr_rrc_supportedBandwidthCombinationSet = -1;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_powerClass_v1530 = -1;       /* T_powerClass_v1530 */
static int hf_nr_rrc_bandList_v1540 = -1;         /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1540 */
static int hf_nr_rrc_bandList_v1540_item = -1;    /* BandParameters_v1540 */
static int hf_nr_rrc_ca_ParametersNR_v1540 = -1;  /* CA_ParametersNR_v1540 */
static int hf_nr_rrc_ca_ParametersNR_v1550 = -1;  /* CA_ParametersNR_v1550 */
static int hf_nr_rrc_ne_DC_BC = -1;               /* T_ne_DC_BC */
static int hf_nr_rrc_ca_ParametersNRDC = -1;      /* CA_ParametersNRDC */
static int hf_nr_rrc_ca_ParametersEUTRA_v1560 = -1;  /* CA_ParametersEUTRA_v1560 */
static int hf_nr_rrc_ca_ParametersNR_v1560 = -1;  /* CA_ParametersNR_v1560 */
static int hf_nr_rrc_ca_ParametersEUTRA_v1570 = -1;  /* CA_ParametersEUTRA_v1570 */
static int hf_nr_rrc_eutra_01 = -1;               /* T_eutra */
static int hf_nr_rrc_bandEUTRA = -1;              /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_ca_BandwidthClassDL_EUTRA = -1;  /* CA_BandwidthClassEUTRA */
static int hf_nr_rrc_ca_BandwidthClassUL_EUTRA = -1;  /* CA_BandwidthClassEUTRA */
static int hf_nr_rrc_nr_01 = -1;                  /* T_nr */
static int hf_nr_rrc_bandNR = -1;                 /* FreqBandIndicatorNR */
static int hf_nr_rrc_ca_BandwidthClassDL_NR = -1;  /* CA_BandwidthClassNR */
static int hf_nr_rrc_ca_BandwidthClassUL_NR = -1;  /* CA_BandwidthClassNR */
static int hf_nr_rrc_srs_CarrierSwitch = -1;      /* T_srs_CarrierSwitch */
static int hf_nr_rrc_nr_02 = -1;                  /* T_nr_01 */
static int hf_nr_rrc_srs_SwitchingTimesListNR = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeNR */
static int hf_nr_rrc_srs_SwitchingTimesListNR_item = -1;  /* SRS_SwitchingTimeNR */
static int hf_nr_rrc_eutra_02 = -1;               /* T_eutra_01 */
static int hf_nr_rrc_srs_SwitchingTimesListEUTRA = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeEUTRA */
static int hf_nr_rrc_srs_SwitchingTimesListEUTRA_item = -1;  /* SRS_SwitchingTimeEUTRA */
static int hf_nr_rrc_srs_TxSwitch = -1;           /* T_srs_TxSwitch */
static int hf_nr_rrc_supportedSRS_TxPortSwitch = -1;  /* T_supportedSRS_TxPortSwitch */
static int hf_nr_rrc_txSwitchImpactToRx = -1;     /* INTEGER_1_32 */
static int hf_nr_rrc_txSwitchWithAnotherBand = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_multipleTimingAdvance = -1;  /* T_multipleTimingAdvance */
static int hf_nr_rrc_simultaneousRx_Tx = -1;      /* T_simultaneousRx_Tx */
static int hf_nr_rrc_supportedNAICS_2CRS_AP = -1;  /* BIT_STRING_SIZE_1_8 */
static int hf_nr_rrc_additionalRx_Tx_PerformanceReq = -1;  /* T_additionalRx_Tx_PerformanceReq */
static int hf_nr_rrc_ue_CA_PowerClass_N = -1;     /* T_ue_CA_PowerClass_N */
static int hf_nr_rrc_supportedBandwidthCombinationSetEUTRA_v1530 = -1;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_fd_MIMO_TotalWeightedLayers = -1;  /* INTEGER_2_128 */
static int hf_nr_rrc_dl_1024QAM_TotalWeightedLayers = -1;  /* INTEGER_0_10 */
static int hf_nr_rrc_dummy_06 = -1;               /* T_dummy_03 */
static int hf_nr_rrc_parallelTxSRS_PUCCH_PUSCH = -1;  /* T_parallelTxSRS_PUCCH_PUSCH */
static int hf_nr_rrc_parallelTxPRACH_SRS_PUCCH_PUSCH = -1;  /* T_parallelTxPRACH_SRS_PUCCH_PUSCH */
static int hf_nr_rrc_simultaneousRxTxInterBandCA = -1;  /* T_simultaneousRxTxInterBandCA */
static int hf_nr_rrc_simultaneousRxTxSUL = -1;    /* T_simultaneousRxTxSUL */
static int hf_nr_rrc_diffNumerologyAcrossPUCCH_Group = -1;  /* T_diffNumerologyAcrossPUCCH_Group */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupSmallerSCS = -1;  /* T_diffNumerologyWithinPUCCH_GroupSmallerSCS */
static int hf_nr_rrc_supportedNumberTAG = -1;     /* T_supportedNumberTAG */
static int hf_nr_rrc_simultaneousSRS_AssocCSI_RS_AllCC = -1;  /* INTEGER_5_32 */
static int hf_nr_rrc_csi_RS_IM_ReceptionForFeedbackPerBandComb = -1;  /* T_csi_RS_IM_ReceptionForFeedbackPerBandComb */
static int hf_nr_rrc_maxNumberSimultaneousNZP_CSI_RS_ActBWP_AllCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberPortsSimultaneousNZP_CSI_RS_ActBWP_AllCC = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_simultaneousCSI_ReportsAllCC = -1;  /* INTEGER_5_32 */
static int hf_nr_rrc_dualPA_Architecture = -1;    /* T_dualPA_Architecture */
static int hf_nr_rrc_dummy_07 = -1;               /* T_dummy_04 */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupLargerSCS = -1;  /* T_diffNumerologyWithinPUCCH_GroupLargerSCS */
static int hf_nr_rrc_ca_ParametersNR_ForDC = -1;  /* CA_ParametersNR */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1540 = -1;  /* CA_ParametersNR_v1540 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1550 = -1;  /* CA_ParametersNR_v1550 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1560 = -1;  /* CA_ParametersNR_v1560 */
static int hf_nr_rrc_featureSetCombinationDC = -1;  /* FeatureSetCombinationId */
static int hf_nr_rrc_type1_02 = -1;               /* T_type1_02 */
static int hf_nr_rrc_singlePanel = -1;            /* T_singlePanel */
static int hf_nr_rrc_supportedCSI_RS_ResourceList = -1;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_item = -1;  /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_modes = -1;                  /* T_modes */
static int hf_nr_rrc_maxNumberCSI_RS_PerResourceSet = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_multiPanel = -1;             /* T_multiPanel */
static int hf_nr_rrc_modes_01 = -1;               /* T_modes_01 */
static int hf_nr_rrc_nrofPanels = -1;             /* T_nrofPanels */
static int hf_nr_rrc_type2_01 = -1;               /* T_type2_01 */
static int hf_nr_rrc_parameterLx = -1;            /* INTEGER_2_4 */
static int hf_nr_rrc_amplitudeScalingType = -1;   /* T_amplitudeScalingType */
static int hf_nr_rrc_amplitudeSubsetRestriction = -1;  /* T_amplitudeSubsetRestriction */
static int hf_nr_rrc_type2_PortSelection = -1;    /* T_type2_PortSelection */
static int hf_nr_rrc_amplitudeScalingType_01 = -1;  /* T_amplitudeScalingType_01 */
static int hf_nr_rrc_maxNumberTxPortsPerResource = -1;  /* T_maxNumberTxPortsPerResource */
static int hf_nr_rrc_maxNumberResourcesPerBand = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberTxPortsPerBand = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_FeatureSetCombination_item = -1;  /* FeatureSetsPerBand */
static int hf_nr_rrc_FeatureSetsPerBand_item = -1;  /* FeatureSet */
static int hf_nr_rrc_eutra_03 = -1;               /* T_eutra_02 */
static int hf_nr_rrc_downlinkSetEUTRA = -1;       /* FeatureSetEUTRA_DownlinkId */
static int hf_nr_rrc_uplinkSetEUTRA = -1;         /* FeatureSetEUTRA_UplinkId */
static int hf_nr_rrc_nr_03 = -1;                  /* T_nr_02 */
static int hf_nr_rrc_downlinkSetNR = -1;          /* FeatureSetDownlinkId */
static int hf_nr_rrc_uplinkSetNR = -1;            /* FeatureSetUplinkId */
static int hf_nr_rrc_featureSetListPerDownlinkCC = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_featureSetListPerDownlinkCC_item = -1;  /* FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_intraBandFreqSeparationDL = -1;  /* FreqSeparationClass */
static int hf_nr_rrc_scalingFactor = -1;          /* T_scalingFactor */
static int hf_nr_rrc_crossCarrierScheduling_OtherSCS = -1;  /* T_crossCarrierScheduling_OtherSCS */
static int hf_nr_rrc_scellWithoutSSB = -1;        /* T_scellWithoutSSB */
static int hf_nr_rrc_csi_RS_MeasSCellWithoutSSB = -1;  /* T_csi_RS_MeasSCellWithoutSSB */
static int hf_nr_rrc_dummy1_01 = -1;              /* T_dummy1_01 */
static int hf_nr_rrc_type1_3_CSS = -1;            /* T_type1_3_CSS */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasions = -1;  /* T_pdcch_MonitoringAnyOccasions */
static int hf_nr_rrc_dummy2_01 = -1;              /* T_dummy2_01 */
static int hf_nr_rrc_ue_SpecificUL_DL_Assignment = -1;  /* T_ue_SpecificUL_DL_Assignment */
static int hf_nr_rrc_searchSpaceSharingCA_DL = -1;  /* T_searchSpaceSharingCA_DL */
static int hf_nr_rrc_timeDurationForQCL = -1;     /* T_timeDurationForQCL */
static int hf_nr_rrc_scs_60kHz = -1;              /* T_scs_60kHz */
static int hf_nr_rrc_scs_120kHz = -1;             /* T_scs_120kHz */
static int hf_nr_rrc_pdsch_ProcessingType1_DifferentTB_PerSlot = -1;  /* T_pdsch_ProcessingType1_DifferentTB_PerSlot */
static int hf_nr_rrc_scs_15kHz = -1;              /* T_scs_15kHz */
static int hf_nr_rrc_scs_30kHz = -1;              /* T_scs_30kHz */
static int hf_nr_rrc_scs_60kHz_01 = -1;           /* T_scs_60kHz_01 */
static int hf_nr_rrc_scs_120kHz_01 = -1;          /* T_scs_120kHz_01 */
static int hf_nr_rrc_dummy3 = -1;                 /* DummyA */
static int hf_nr_rrc_dummy4 = -1;                 /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyB */
static int hf_nr_rrc_dummy4_item = -1;            /* DummyB */
static int hf_nr_rrc_dummy5 = -1;                 /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyC */
static int hf_nr_rrc_dummy5_item = -1;            /* DummyC */
static int hf_nr_rrc_dummy6 = -1;                 /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyD */
static int hf_nr_rrc_dummy6_item = -1;            /* DummyD */
static int hf_nr_rrc_dummy7 = -1;                 /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyE */
static int hf_nr_rrc_dummy7_item = -1;            /* DummyE */
static int hf_nr_rrc_oneFL_DMRS_TwoAdditionalDMRS_DL = -1;  /* T_oneFL_DMRS_TwoAdditionalDMRS_DL */
static int hf_nr_rrc_additionalDMRS_DL_Alt = -1;  /* T_additionalDMRS_DL_Alt */
static int hf_nr_rrc_twoFL_DMRS_TwoAdditionalDMRS_DL = -1;  /* T_twoFL_DMRS_TwoAdditionalDMRS_DL */
static int hf_nr_rrc_oneFL_DMRS_ThreeAdditionalDMRS_DL = -1;  /* T_oneFL_DMRS_ThreeAdditionalDMRS_DL */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasionsWithSpanGap = -1;  /* T_pdcch_MonitoringAnyOccasionsWithSpanGap */
static int hf_nr_rrc_scs_15kHz_01 = -1;           /* T_scs_15kHz_01 */
static int hf_nr_rrc_scs_30kHz_01 = -1;           /* T_scs_30kHz_01 */
static int hf_nr_rrc_scs_60kHz_02 = -1;           /* T_scs_60kHz_02 */
static int hf_nr_rrc_scs_120kHz_02 = -1;          /* T_scs_120kHz_02 */
static int hf_nr_rrc_pdsch_SeparationWithGap = -1;  /* T_pdsch_SeparationWithGap */
static int hf_nr_rrc_pdsch_ProcessingType2 = -1;  /* T_pdsch_ProcessingType2 */
static int hf_nr_rrc_scs_15kHz_02 = -1;           /* ProcessingParameters */
static int hf_nr_rrc_scs_30kHz_02 = -1;           /* ProcessingParameters */
static int hf_nr_rrc_scs_60kHz_03 = -1;           /* ProcessingParameters */
static int hf_nr_rrc_pdsch_ProcessingType2_Limited = -1;  /* T_pdsch_ProcessingType2_Limited */
static int hf_nr_rrc_differentTB_PerSlot_SCS_30kHz = -1;  /* T_differentTB_PerSlot_SCS_30kHz */
static int hf_nr_rrc_dl_MCS_TableAlt_DynamicIndication = -1;  /* T_dl_MCS_TableAlt_DynamicIndication */
static int hf_nr_rrc_maxNumberNZP_CSI_RS_PerCC = -1;  /* INTEGER_1_32 */
static int hf_nr_rrc_maxNumberPortsAcrossNZP_CSI_RS_PerCC = -1;  /* T_maxNumberPortsAcrossNZP_CSI_RS_PerCC */
static int hf_nr_rrc_maxNumberCS_IM_PerCC = -1;   /* T_maxNumberCS_IM_PerCC */
static int hf_nr_rrc_maxNumberSimultaneousCSI_RS_ActBWP_AllCC = -1;  /* T_maxNumberSimultaneousCSI_RS_ActBWP_AllCC */
static int hf_nr_rrc_totalNumberPortsSimultaneousCSI_RS_ActBWP_AllCC = -1;  /* T_totalNumberPortsSimultaneousCSI_RS_ActBWP_AllCC */
static int hf_nr_rrc_maxNumberTxPortsPerResource_01 = -1;  /* T_maxNumberTxPortsPerResource_01 */
static int hf_nr_rrc_maxNumberResources = -1;     /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberTxPorts = -1;     /* INTEGER_2_256 */
static int hf_nr_rrc_supportedCodebookMode = -1;  /* T_supportedCodebookMode */
static int hf_nr_rrc_maxNumberTxPortsPerResource_02 = -1;  /* T_maxNumberTxPortsPerResource_02 */
static int hf_nr_rrc_supportedCodebookMode_01 = -1;  /* T_supportedCodebookMode_01 */
static int hf_nr_rrc_supportedNumberPanels = -1;  /* T_supportedNumberPanels */
static int hf_nr_rrc_maxNumberTxPortsPerResource_03 = -1;  /* T_maxNumberTxPortsPerResource_03 */
static int hf_nr_rrc_amplitudeScalingType_02 = -1;  /* T_amplitudeScalingType_02 */
static int hf_nr_rrc_amplitudeSubsetRestriction_01 = -1;  /* T_amplitudeSubsetRestriction_01 */
static int hf_nr_rrc_maxNumberTxPortsPerResource_04 = -1;  /* T_maxNumberTxPortsPerResource_04 */
static int hf_nr_rrc_amplitudeScalingType_03 = -1;  /* T_amplitudeScalingType_03 */
static int hf_nr_rrc_supportedSubcarrierSpacingDL = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_supportedBandwidthDL = -1;   /* SupportedBandwidth */
static int hf_nr_rrc_channelBW_90mhz = -1;        /* T_channelBW_90mhz */
static int hf_nr_rrc_maxNumberMIMO_LayersPDSCH = -1;  /* MIMO_LayersDL */
static int hf_nr_rrc_supportedModulationOrderDL = -1;  /* ModulationOrder */
static int hf_nr_rrc_featureSetsDownlink = -1;    /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink */
static int hf_nr_rrc_featureSetsDownlink_item = -1;  /* FeatureSetDownlink */
static int hf_nr_rrc_featureSetsDownlinkPerCC = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC */
static int hf_nr_rrc_featureSetsDownlinkPerCC_item = -1;  /* FeatureSetDownlinkPerCC */
static int hf_nr_rrc_featureSetsUplink = -1;      /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink */
static int hf_nr_rrc_featureSetsUplink_item = -1;  /* FeatureSetUplink */
static int hf_nr_rrc_featureSetsUplinkPerCC = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC */
static int hf_nr_rrc_featureSetsUplinkPerCC_item = -1;  /* FeatureSetUplinkPerCC */
static int hf_nr_rrc_featureSetsDownlink_v1540 = -1;  /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1540 */
static int hf_nr_rrc_featureSetsDownlink_v1540_item = -1;  /* FeatureSetDownlink_v1540 */
static int hf_nr_rrc_featureSetsUplink_v1540 = -1;  /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1540 */
static int hf_nr_rrc_featureSetsUplink_v1540_item = -1;  /* FeatureSetUplink_v1540 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1540 = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1540 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1540_item = -1;  /* FeatureSetUplinkPerCC_v1540 */
static int hf_nr_rrc_featureSetListPerUplinkCC = -1;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_featureSetListPerUplinkCC_item = -1;  /* FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_scalingFactor_01 = -1;       /* T_scalingFactor_01 */
static int hf_nr_rrc_crossCarrierScheduling_OtherSCS_01 = -1;  /* T_crossCarrierScheduling_OtherSCS_01 */
static int hf_nr_rrc_intraBandFreqSeparationUL = -1;  /* FreqSeparationClass */
static int hf_nr_rrc_searchSpaceSharingCA_UL = -1;  /* T_searchSpaceSharingCA_UL */
static int hf_nr_rrc_dummy1_02 = -1;              /* DummyI */
static int hf_nr_rrc_supportedSRS_Resources = -1;  /* SRS_Resources */
static int hf_nr_rrc_twoPUCCH_Group = -1;         /* T_twoPUCCH_Group */
static int hf_nr_rrc_dynamicSwitchSUL = -1;       /* T_dynamicSwitchSUL */
static int hf_nr_rrc_simultaneousTxSUL_NonSUL = -1;  /* T_simultaneousTxSUL_NonSUL */
static int hf_nr_rrc_pusch_ProcessingType1_DifferentTB_PerSlot = -1;  /* T_pusch_ProcessingType1_DifferentTB_PerSlot */
static int hf_nr_rrc_scs_15kHz_03 = -1;           /* T_scs_15kHz_02 */
static int hf_nr_rrc_scs_30kHz_03 = -1;           /* T_scs_30kHz_02 */
static int hf_nr_rrc_scs_60kHz_04 = -1;           /* T_scs_60kHz_03 */
static int hf_nr_rrc_scs_120kHz_03 = -1;          /* T_scs_120kHz_03 */
static int hf_nr_rrc_dummy2_02 = -1;              /* DummyF */
static int hf_nr_rrc_zeroSlotOffsetAperiodicSRS = -1;  /* T_zeroSlotOffsetAperiodicSRS */
static int hf_nr_rrc_pa_PhaseDiscontinuityImpacts = -1;  /* T_pa_PhaseDiscontinuityImpacts */
static int hf_nr_rrc_pusch_SeparationWithGap = -1;  /* T_pusch_SeparationWithGap */
static int hf_nr_rrc_pusch_ProcessingType2 = -1;  /* T_pusch_ProcessingType2 */
static int hf_nr_rrc_ul_MCS_TableAlt_DynamicIndication = -1;  /* T_ul_MCS_TableAlt_DynamicIndication */
static int hf_nr_rrc_maxNumberAperiodicSRS_PerBWP = -1;  /* T_maxNumberAperiodicSRS_PerBWP */
static int hf_nr_rrc_maxNumberAperiodicSRS_PerBWP_PerSlot = -1;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PerBWP = -1;  /* T_maxNumberPeriodicSRS_PerBWP */
static int hf_nr_rrc_maxNumberPeriodicSRS_PerBWP_PerSlot = -1;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_PerBWP = -1;  /* T_maxNumberSemiPersistentSRS_PerBWP */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_PerBWP_PerSlot = -1;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberSRS_Ports_PerResource = -1;  /* T_maxNumberSRS_Ports_PerResource */
static int hf_nr_rrc_maxNumberPeriodicCSI_ReportPerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_ReportPerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_ReportPerBWP = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_supportedSubcarrierSpacingUL = -1;  /* SubcarrierSpacing */
static int hf_nr_rrc_supportedBandwidthUL = -1;   /* SupportedBandwidth */
static int hf_nr_rrc_channelBW_90mhz_01 = -1;     /* T_channelBW_90mhz_01 */
static int hf_nr_rrc_mimo_CB_PUSCH = -1;          /* T_mimo_CB_PUSCH */
static int hf_nr_rrc_maxNumberMIMO_LayersCB_PUSCH = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet = -1;  /* INTEGER_1_2 */
static int hf_nr_rrc_maxNumberMIMO_LayersNonCB_PUSCH = -1;  /* MIMO_LayersUL */
static int hf_nr_rrc_supportedModulationOrderUL = -1;  /* ModulationOrder */
static int hf_nr_rrc_mimo_NonCB_PUSCH = -1;       /* T_mimo_NonCB_PUSCH */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_01 = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSimultaneousSRS_ResourceTx = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_FreqBandList_item = -1;      /* FreqBandInformation */
static int hf_nr_rrc_bandInformationEUTRA = -1;   /* FreqBandInformationEUTRA */
static int hf_nr_rrc_bandInformationNR = -1;      /* FreqBandInformationNR */
static int hf_nr_rrc_maxBandwidthRequestedDL = -1;  /* AggregatedBandwidth */
static int hf_nr_rrc_maxBandwidthRequestedUL = -1;  /* AggregatedBandwidth */
static int hf_nr_rrc_maxCarriersRequestedDL = -1;  /* INTEGER_1_maxNrofServingCells */
static int hf_nr_rrc_maxCarriersRequestedUL = -1;  /* INTEGER_1_maxNrofServingCells */
static int hf_nr_rrc_ims_ParametersCommon = -1;   /* IMS_ParametersCommon */
static int hf_nr_rrc_ims_ParametersFRX_Diff = -1;  /* IMS_ParametersFRX_Diff */
static int hf_nr_rrc_voiceOverEUTRA_5GC = -1;     /* T_voiceOverEUTRA_5GC */
static int hf_nr_rrc_voiceOverSCG_BearerEUTRA_5GC = -1;  /* T_voiceOverSCG_BearerEUTRA_5GC */
static int hf_nr_rrc_voiceOverNR = -1;            /* T_voiceOverNR */
static int hf_nr_rrc_eutra_04 = -1;               /* EUTRA_Parameters */
static int hf_nr_rrc_supportedBandListEUTRA = -1;  /* SEQUENCE_SIZE_1_maxBandsEUTRA_OF_FreqBandIndicatorEUTRA */
static int hf_nr_rrc_supportedBandListEUTRA_item = -1;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_eutra_ParametersCommon = -1;  /* EUTRA_ParametersCommon */
static int hf_nr_rrc_eutra_ParametersXDD_Diff = -1;  /* EUTRA_ParametersXDD_Diff */
static int hf_nr_rrc_mfbi_EUTRA = -1;             /* T_mfbi_EUTRA */
static int hf_nr_rrc_modifiedMPR_BehaviorEUTRA = -1;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_multiNS_Pmax_EUTRA = -1;     /* T_multiNS_Pmax_EUTRA */
static int hf_nr_rrc_rs_SINR_MeasEUTRA = -1;      /* T_rs_SINR_MeasEUTRA */
static int hf_nr_rrc_ne_DC = -1;                  /* T_ne_DC */
static int hf_nr_rrc_rsrqMeasWidebandEUTRA = -1;  /* T_rsrqMeasWidebandEUTRA */
static int hf_nr_rrc_mac_ParametersCommon = -1;   /* MAC_ParametersCommon */
static int hf_nr_rrc_mac_ParametersXDD_Diff = -1;  /* MAC_ParametersXDD_Diff */
static int hf_nr_rrc_lcp_Restriction = -1;        /* T_lcp_Restriction */
static int hf_nr_rrc_dummy_08 = -1;               /* T_dummy_05 */
static int hf_nr_rrc_lch_ToSCellRestriction = -1;  /* T_lch_ToSCellRestriction */
static int hf_nr_rrc_recommendedBitRate = -1;     /* T_recommendedBitRate */
static int hf_nr_rrc_recommendedBitRateQuery = -1;  /* T_recommendedBitRateQuery */
static int hf_nr_rrc_skipUplinkTxDynamic_01 = -1;  /* T_skipUplinkTxDynamic */
static int hf_nr_rrc_logicalChannelSR_DelayTimer_01 = -1;  /* T_logicalChannelSR_DelayTimer_01 */
static int hf_nr_rrc_longDRX_Cycle = -1;          /* T_longDRX_Cycle */
static int hf_nr_rrc_shortDRX_Cycle = -1;         /* T_shortDRX_Cycle */
static int hf_nr_rrc_multipleSR_Configurations = -1;  /* T_multipleSR_Configurations */
static int hf_nr_rrc_multipleConfiguredGrants = -1;  /* T_multipleConfiguredGrants */
static int hf_nr_rrc_measAndMobParametersCommon = -1;  /* MeasAndMobParametersCommon */
static int hf_nr_rrc_measAndMobParametersXDD_Diff = -1;  /* MeasAndMobParametersXDD_Diff */
static int hf_nr_rrc_measAndMobParametersFRX_Diff = -1;  /* MeasAndMobParametersFRX_Diff */
static int hf_nr_rrc_supportedGapPattern = -1;    /* BIT_STRING_SIZE_22 */
static int hf_nr_rrc_ssb_RLM = -1;                /* T_ssb_RLM */
static int hf_nr_rrc_ssb_AndCSI_RS_RLM = -1;      /* T_ssb_AndCSI_RS_RLM */
static int hf_nr_rrc_eventB_MeasAndReport = -1;   /* T_eventB_MeasAndReport */
static int hf_nr_rrc_handoverFDD_TDD = -1;        /* T_handoverFDD_TDD */
static int hf_nr_rrc_eutra_CGI_Reporting = -1;    /* T_eutra_CGI_Reporting */
static int hf_nr_rrc_nr_CGI_Reporting = -1;       /* T_nr_CGI_Reporting */
static int hf_nr_rrc_independentGapConfig = -1;   /* T_independentGapConfig */
static int hf_nr_rrc_periodicEUTRA_MeasAndReport = -1;  /* T_periodicEUTRA_MeasAndReport */
static int hf_nr_rrc_handoverFR1_FR2 = -1;        /* T_handoverFR1_FR2 */
static int hf_nr_rrc_maxNumberCSI_RS_RRM_RS_SINR = -1;  /* T_maxNumberCSI_RS_RRM_RS_SINR */
static int hf_nr_rrc_nr_CGI_Reporting_ENDC = -1;  /* T_nr_CGI_Reporting_ENDC */
static int hf_nr_rrc_intraAndInterF_MeasAndReport = -1;  /* T_intraAndInterF_MeasAndReport */
static int hf_nr_rrc_eventA_MeasAndReport = -1;   /* T_eventA_MeasAndReport */
static int hf_nr_rrc_handoverInterF = -1;         /* T_handoverInterF */
static int hf_nr_rrc_handoverLTE_EPC = -1;        /* T_handoverLTE_EPC */
static int hf_nr_rrc_handoverLTE_5GC = -1;        /* T_handoverLTE_5GC */
static int hf_nr_rrc_sftd_MeasNR_Neigh = -1;      /* T_sftd_MeasNR_Neigh */
static int hf_nr_rrc_sftd_MeasNR_Neigh_DRX = -1;  /* T_sftd_MeasNR_Neigh_DRX */
static int hf_nr_rrc_ss_SINR_Meas = -1;           /* T_ss_SINR_Meas */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithSSB = -1;  /* T_csi_RSRP_AndRSRQ_MeasWithSSB */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithoutSSB = -1;  /* T_csi_RSRP_AndRSRQ_MeasWithoutSSB */
static int hf_nr_rrc_csi_SINR_Meas = -1;          /* T_csi_SINR_Meas */
static int hf_nr_rrc_csi_RS_RLM = -1;             /* T_csi_RS_RLM */
static int hf_nr_rrc_handoverInterF_01 = -1;      /* T_handoverInterF_01 */
static int hf_nr_rrc_handoverLTE_EPC_01 = -1;     /* T_handoverLTE_EPC_01 */
static int hf_nr_rrc_handoverLTE_5GC_01 = -1;     /* T_handoverLTE_5GC_01 */
static int hf_nr_rrc_maxNumberResource_CSI_RS_RLM = -1;  /* T_maxNumberResource_CSI_RS_RLM */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology = -1;  /* T_simultaneousRxDataSSB_DiffNumerology */
static int hf_nr_rrc_measAndMobParametersMRDC_Common = -1;  /* MeasAndMobParametersMRDC_Common */
static int hf_nr_rrc_measAndMobParametersMRDC_XDD_Diff = -1;  /* MeasAndMobParametersMRDC_XDD_Diff */
static int hf_nr_rrc_measAndMobParametersMRDC_FRX_Diff = -1;  /* MeasAndMobParametersMRDC_FRX_Diff */
static int hf_nr_rrc_measAndMobParametersMRDC_XDD_Diff_v1560 = -1;  /* MeasAndMobParametersMRDC_XDD_Diff_v1560 */
static int hf_nr_rrc_independentGapConfig_01 = -1;  /* T_independentGapConfig_01 */
static int hf_nr_rrc_sftd_MeasPSCell = -1;        /* T_sftd_MeasPSCell */
static int hf_nr_rrc_sftd_MeasNR_Cell = -1;       /* T_sftd_MeasNR_Cell */
static int hf_nr_rrc_sftd_MeasPSCell_NEDC = -1;   /* T_sftd_MeasPSCell_NEDC */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology_01 = -1;  /* T_simultaneousRxDataSSB_DiffNumerology_01 */
static int hf_nr_rrc_tci_StatePDSCH = -1;         /* T_tci_StatePDSCH */
static int hf_nr_rrc_maxNumberConfiguredTCIstatesPerCC = -1;  /* T_maxNumberConfiguredTCIstatesPerCC */
static int hf_nr_rrc_maxNumberActiveTCI_PerBWP = -1;  /* T_maxNumberActiveTCI_PerBWP */
static int hf_nr_rrc_additionalActiveTCI_StatePDCCH = -1;  /* T_additionalActiveTCI_StatePDCCH */
static int hf_nr_rrc_pusch_TransCoherence = -1;   /* T_pusch_TransCoherence */
static int hf_nr_rrc_beamCorrespondenceWithoutUL_BeamSweeping = -1;  /* T_beamCorrespondenceWithoutUL_BeamSweeping */
static int hf_nr_rrc_periodicBeamReport = -1;     /* T_periodicBeamReport */
static int hf_nr_rrc_aperiodicBeamReport = -1;    /* T_aperiodicBeamReport */
static int hf_nr_rrc_sp_BeamReportPUCCH = -1;     /* T_sp_BeamReportPUCCH */
static int hf_nr_rrc_sp_BeamReportPUSCH = -1;     /* T_sp_BeamReportPUSCH */
static int hf_nr_rrc_dummy1_03 = -1;              /* DummyG */
static int hf_nr_rrc_maxNumberRxBeam = -1;        /* INTEGER_2_8 */
static int hf_nr_rrc_maxNumberRxTxBeamSwitchDL = -1;  /* T_maxNumberRxTxBeamSwitchDL */
static int hf_nr_rrc_scs_15kHz_04 = -1;           /* T_scs_15kHz_03 */
static int hf_nr_rrc_scs_30kHz_04 = -1;           /* T_scs_30kHz_03 */
static int hf_nr_rrc_scs_60kHz_05 = -1;           /* T_scs_60kHz_04 */
static int hf_nr_rrc_scs_120kHz_04 = -1;          /* T_scs_120kHz_04 */
static int hf_nr_rrc_scs_240kHz = -1;             /* T_scs_240kHz */
static int hf_nr_rrc_maxNumberNonGroupBeamReporting = -1;  /* T_maxNumberNonGroupBeamReporting */
static int hf_nr_rrc_groupBeamReporting = -1;     /* T_groupBeamReporting */
static int hf_nr_rrc_uplinkBeamManagement = -1;   /* T_uplinkBeamManagement */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_BM = -1;  /* T_maxNumberSRS_ResourcePerSet_BM */
static int hf_nr_rrc_maxNumberSRS_ResourceSet = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberCSI_RS_BFD = -1;    /* INTEGER_1_64 */
static int hf_nr_rrc_maxNumberSSB_BFD = -1;       /* INTEGER_1_64 */
static int hf_nr_rrc_maxNumberCSI_RS_SSB_CBD = -1;  /* INTEGER_1_256 */
static int hf_nr_rrc_dummy2_03 = -1;              /* T_dummy2_02 */
static int hf_nr_rrc_twoPortsPTRS_UL = -1;        /* T_twoPortsPTRS_UL */
static int hf_nr_rrc_dummy5_01 = -1;              /* SRS_Resources */
static int hf_nr_rrc_dummy3_01 = -1;              /* INTEGER_1_4 */
static int hf_nr_rrc_beamReportTiming = -1;       /* T_beamReportTiming */
static int hf_nr_rrc_scs_15kHz_05 = -1;           /* T_scs_15kHz_04 */
static int hf_nr_rrc_scs_30kHz_05 = -1;           /* T_scs_30kHz_04 */
static int hf_nr_rrc_scs_60kHz_06 = -1;           /* T_scs_60kHz_05 */
static int hf_nr_rrc_scs_120kHz_05 = -1;          /* T_scs_120kHz_05 */
static int hf_nr_rrc_ptrs_DensityRecommendationSetDL = -1;  /* T_ptrs_DensityRecommendationSetDL */
static int hf_nr_rrc_scs_15kHz_06 = -1;           /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_scs_30kHz_06 = -1;           /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_scs_60kHz_07 = -1;           /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_scs_120kHz_06 = -1;          /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_ptrs_DensityRecommendationSetUL = -1;  /* T_ptrs_DensityRecommendationSetUL */
static int hf_nr_rrc_scs_15kHz_07 = -1;           /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_scs_30kHz_07 = -1;           /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_scs_60kHz_08 = -1;           /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_scs_120kHz_07 = -1;          /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_dummy4_01 = -1;              /* DummyH */
static int hf_nr_rrc_aperiodicTRS = -1;           /* T_aperiodicTRS */
static int hf_nr_rrc_dummy6_01 = -1;              /* T_dummy6 */
static int hf_nr_rrc_beamManagementSSB_CSI_RS = -1;  /* BeamManagementSSB_CSI_RS */
static int hf_nr_rrc_beamSwitchTiming = -1;       /* T_beamSwitchTiming */
static int hf_nr_rrc_scs_60kHz_09 = -1;           /* T_scs_60kHz_06 */
static int hf_nr_rrc_scs_120kHz_08 = -1;          /* T_scs_120kHz_06 */
static int hf_nr_rrc_codebookParameters = -1;     /* CodebookParameters */
static int hf_nr_rrc_csi_RS_IM_ReceptionForFeedback = -1;  /* CSI_RS_IM_ReceptionForFeedback */
static int hf_nr_rrc_csi_RS_ProcFrameworkForSRS = -1;  /* CSI_RS_ProcFrameworkForSRS */
static int hf_nr_rrc_csi_ReportFramework = -1;    /* CSI_ReportFramework */
static int hf_nr_rrc_csi_RS_ForTracking = -1;     /* CSI_RS_ForTracking */
static int hf_nr_rrc_srs_AssocCSI_RS = -1;        /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_srs_AssocCSI_RS_item = -1;   /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_spatialRelations = -1;       /* SpatialRelations */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceOneTx = -1;  /* T_maxNumberSSB_CSI_RS_ResourceOneTx */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceTwoTx = -1;  /* T_maxNumberSSB_CSI_RS_ResourceTwoTx */
static int hf_nr_rrc_supportedCSI_RS_Density = -1;  /* T_supportedCSI_RS_Density */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceOneTx_01 = -1;  /* T_maxNumberSSB_CSI_RS_ResourceOneTx_01 */
static int hf_nr_rrc_maxNumberCSI_RS_Resource = -1;  /* T_maxNumberCSI_RS_Resource */
static int hf_nr_rrc_maxNumberCSI_RS_ResourceTwoTx = -1;  /* T_maxNumberCSI_RS_ResourceTwoTx */
static int hf_nr_rrc_supportedCSI_RS_Density_01 = -1;  /* T_supportedCSI_RS_Density_01 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_Resource = -1;  /* T_maxNumberAperiodicCSI_RS_Resource */
static int hf_nr_rrc_burstLength = -1;            /* INTEGER_1_2 */
static int hf_nr_rrc_maxSimultaneousResourceSetsPerCC = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxConfiguredResourceSetsPerCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_maxConfiguredResourceSetsAllCC = -1;  /* INTEGER_1_128 */
static int hf_nr_rrc_maxBurstLength = -1;         /* INTEGER_1_2 */
static int hf_nr_rrc_maxConfiguredResourceSetsAllCC_01 = -1;  /* INTEGER_1_256 */
static int hf_nr_rrc_maxConfigNumberNZP_CSI_RS_PerCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_maxConfigNumberPortsAcrossNZP_CSI_RS_PerCC = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_maxConfigNumberCSI_IM_PerCC = -1;  /* T_maxConfigNumberCSI_IM_PerCC */
static int hf_nr_rrc_maxNumberSimultaneousNZP_CSI_RS_PerCC = -1;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberPortsSimultaneousNZP_CSI_RS_PerCC = -1;  /* INTEGER_2_256 */
static int hf_nr_rrc_maxNumberPeriodicSRS_AssocCSI_RS_PerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicSRS_AssocCSI_RS_PerBWP = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSP_SRS_AssocCSI_RS_PerBWP = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_simultaneousSRS_AssocCSI_RS_PerCC = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberPeriodicCSI_PerBWP_ForCSI_Report = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForCSI_Report = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_PerBWP_ForCSI_Report = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_maxNumberPeriodicCSI_PerBWP_ForBeamReport = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForBeamReport = -1;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_triggeringStatePerCC = -1;  /* T_maxNumberAperiodicCSI_triggeringStatePerCC */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_PerBWP_ForBeamReport = -1;  /* INTEGER_0_4 */
static int hf_nr_rrc_simultaneousCSI_ReportsPerCC = -1;  /* INTEGER_1_8 */
static int hf_nr_rrc_frequencyDensity1 = -1;      /* INTEGER_1_276 */
static int hf_nr_rrc_frequencyDensity2 = -1;      /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensity1 = -1;           /* INTEGER_0_29 */
static int hf_nr_rrc_timeDensity2 = -1;           /* INTEGER_0_29 */
static int hf_nr_rrc_timeDensity3 = -1;           /* INTEGER_0_29 */
static int hf_nr_rrc_sampleDensity1 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity2 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity3 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity4 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity5 = -1;         /* INTEGER_1_276 */
static int hf_nr_rrc_maxNumberConfiguredSpatialRelations = -1;  /* T_maxNumberConfiguredSpatialRelations */
static int hf_nr_rrc_maxNumberActiveSpatialRelations = -1;  /* T_maxNumberActiveSpatialRelations */
static int hf_nr_rrc_additionalActiveSpatialRelationPUCCH = -1;  /* T_additionalActiveSpatialRelationPUCCH */
static int hf_nr_rrc_maxNumberDL_RS_QCL_TypeD = -1;  /* T_maxNumberDL_RS_QCL_TypeD */
static int hf_nr_rrc_supportedSRS_TxPortSwitch_01 = -1;  /* T_supportedSRS_TxPortSwitch_01 */
static int hf_nr_rrc_txSwitchImpactToRx_01 = -1;  /* T_txSwitchImpactToRx */
static int hf_nr_rrc_singleUL_Transmission = -1;  /* T_singleUL_Transmission */
static int hf_nr_rrc_dynamicPowerSharing = -1;    /* T_dynamicPowerSharing */
static int hf_nr_rrc_tdm_Pattern = -1;            /* T_tdm_Pattern */
static int hf_nr_rrc_ul_SharingEUTRA_NR = -1;     /* T_ul_SharingEUTRA_NR */
static int hf_nr_rrc_ul_SwitchingTimeEUTRA_NR = -1;  /* T_ul_SwitchingTimeEUTRA_NR */
static int hf_nr_rrc_simultaneousRxTxInterBandENDC = -1;  /* T_simultaneousRxTxInterBandENDC */
static int hf_nr_rrc_asyncIntraBandENDC = -1;     /* T_asyncIntraBandENDC */
static int hf_nr_rrc_dualPA_Architecture_01 = -1;  /* T_dualPA_Architecture_01 */
static int hf_nr_rrc_intraBandENDC_Support_v1540 = -1;  /* T_intraBandENDC_Support_v1540 */
static int hf_nr_rrc_ul_TimingAlignmentEUTRA_NR = -1;  /* T_ul_TimingAlignmentEUTRA_NR */
static int hf_nr_rrc_measAndMobParametersNRDC = -1;  /* MeasAndMobParametersMRDC */
static int hf_nr_rrc_generalParametersNRDC = -1;  /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_fdd_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_NRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_dummy_09 = -1;               /* T_dummy_06 */
static int hf_nr_rrc_sfn_SyncNRDC = -1;           /* T_sfn_SyncNRDC */
static int hf_nr_rrc_supportedROHC_Profiles = -1;  /* T_supportedROHC_Profiles */
static int hf_nr_rrc_profile0x0000 = -1;          /* BOOLEAN */
static int hf_nr_rrc_maxNumberROHC_ContextSessions = -1;  /* T_maxNumberROHC_ContextSessions */
static int hf_nr_rrc_uplinkOnlyROHC_Profiles = -1;  /* T_uplinkOnlyROHC_Profiles */
static int hf_nr_rrc_continueROHC_Context = -1;   /* T_continueROHC_Context */
static int hf_nr_rrc_outOfOrderDelivery_01 = -1;  /* T_outOfOrderDelivery_01 */
static int hf_nr_rrc_shortSN = -1;                /* T_shortSN */
static int hf_nr_rrc_pdcp_DuplicationSRB = -1;    /* T_pdcp_DuplicationSRB */
static int hf_nr_rrc_pdcp_DuplicationMCG_OrSCG_DRB = -1;  /* T_pdcp_DuplicationMCG_OrSCG_DRB */
static int hf_nr_rrc_pdcp_DuplicationSplitSRB = -1;  /* T_pdcp_DuplicationSplitSRB */
static int hf_nr_rrc_pdcp_DuplicationSplitDRB = -1;  /* T_pdcp_DuplicationSplitDRB */
static int hf_nr_rrc_phy_ParametersCommon = -1;   /* Phy_ParametersCommon */
static int hf_nr_rrc_phy_ParametersXDD_Diff = -1;  /* Phy_ParametersXDD_Diff */
static int hf_nr_rrc_phy_ParametersFRX_Diff = -1;  /* Phy_ParametersFRX_Diff */
static int hf_nr_rrc_phy_ParametersFR1 = -1;      /* Phy_ParametersFR1 */
static int hf_nr_rrc_phy_ParametersFR2 = -1;      /* Phy_ParametersFR2 */
static int hf_nr_rrc_csi_RS_CFRA_ForHO = -1;      /* T_csi_RS_CFRA_ForHO */
static int hf_nr_rrc_dynamicPRB_BundlingDL = -1;  /* T_dynamicPRB_BundlingDL */
static int hf_nr_rrc_sp_CSI_ReportPUCCH = -1;     /* T_sp_CSI_ReportPUCCH */
static int hf_nr_rrc_sp_CSI_ReportPUSCH = -1;     /* T_sp_CSI_ReportPUSCH */
static int hf_nr_rrc_nzp_CSI_RS_IntefMgmt = -1;   /* T_nzp_CSI_RS_IntefMgmt */
static int hf_nr_rrc_type2_SP_CSI_Feedback_LongPUCCH = -1;  /* T_type2_SP_CSI_Feedback_LongPUCCH */
static int hf_nr_rrc_precoderGranularityCORESET = -1;  /* T_precoderGranularityCORESET */
static int hf_nr_rrc_dynamicHARQ_ACK_Codebook = -1;  /* T_dynamicHARQ_ACK_Codebook */
static int hf_nr_rrc_semiStaticHARQ_ACK_Codebook = -1;  /* T_semiStaticHARQ_ACK_Codebook */
static int hf_nr_rrc_spatialBundlingHARQ_ACK = -1;  /* T_spatialBundlingHARQ_ACK */
static int hf_nr_rrc_dynamicBetaOffsetInd_HARQ_ACK_CSI = -1;  /* T_dynamicBetaOffsetInd_HARQ_ACK_CSI */
static int hf_nr_rrc_pucch_Repetition_F1_3_4 = -1;  /* T_pucch_Repetition_F1_3_4 */
static int hf_nr_rrc_ra_Type0_PUSCH = -1;         /* T_ra_Type0_PUSCH */
static int hf_nr_rrc_dynamicSwitchRA_Type0_1_PDSCH = -1;  /* T_dynamicSwitchRA_Type0_1_PDSCH */
static int hf_nr_rrc_dynamicSwitchRA_Type0_1_PUSCH = -1;  /* T_dynamicSwitchRA_Type0_1_PUSCH */
static int hf_nr_rrc_pdsch_MappingTypeA = -1;     /* T_pdsch_MappingTypeA */
static int hf_nr_rrc_pdsch_MappingTypeB = -1;     /* T_pdsch_MappingTypeB */
static int hf_nr_rrc_interleavingVRB_ToPRB_PDSCH = -1;  /* T_interleavingVRB_ToPRB_PDSCH */
static int hf_nr_rrc_interSlotFreqHopping_PUSCH = -1;  /* T_interSlotFreqHopping_PUSCH */
static int hf_nr_rrc_type1_PUSCH_RepetitionMultiSlots = -1;  /* T_type1_PUSCH_RepetitionMultiSlots */
static int hf_nr_rrc_type2_PUSCH_RepetitionMultiSlots = -1;  /* T_type2_PUSCH_RepetitionMultiSlots */
static int hf_nr_rrc_pusch_RepetitionMultiSlots = -1;  /* T_pusch_RepetitionMultiSlots */
static int hf_nr_rrc_pdsch_RepetitionMultiSlots = -1;  /* T_pdsch_RepetitionMultiSlots */
static int hf_nr_rrc_downlinkSPS = -1;            /* T_downlinkSPS */
static int hf_nr_rrc_configuredUL_GrantType1 = -1;  /* T_configuredUL_GrantType1 */
static int hf_nr_rrc_configuredUL_GrantType2 = -1;  /* T_configuredUL_GrantType2 */
static int hf_nr_rrc_pre_EmptIndication_DL = -1;  /* T_pre_EmptIndication_DL */
static int hf_nr_rrc_cbg_TransIndication_DL = -1;  /* T_cbg_TransIndication_DL */
static int hf_nr_rrc_cbg_TransIndication_UL = -1;  /* T_cbg_TransIndication_UL */
static int hf_nr_rrc_cbg_FlushIndication_DL = -1;  /* T_cbg_FlushIndication_DL */
static int hf_nr_rrc_dynamicHARQ_ACK_CodeB_CBG_Retx_DL = -1;  /* T_dynamicHARQ_ACK_CodeB_CBG_Retx_DL */
static int hf_nr_rrc_rateMatchingResrcSetSemi_Static = -1;  /* T_rateMatchingResrcSetSemi_Static */
static int hf_nr_rrc_rateMatchingResrcSetDynamic = -1;  /* T_rateMatchingResrcSetDynamic */
static int hf_nr_rrc_bwp_SwitchingDelay = -1;     /* T_bwp_SwitchingDelay */
static int hf_nr_rrc_dummy_10 = -1;               /* T_dummy_07 */
static int hf_nr_rrc_maxNumberSearchSpaces = -1;  /* T_maxNumberSearchSpaces */
static int hf_nr_rrc_rateMatchingCtrlResrcSetDynamic = -1;  /* T_rateMatchingCtrlResrcSetDynamic */
static int hf_nr_rrc_maxLayersMIMO_Indication = -1;  /* T_maxLayersMIMO_Indication */
static int hf_nr_rrc_dynamicSFI = -1;             /* T_dynamicSFI */
static int hf_nr_rrc_twoPUCCH_F0_2_ConsecSymbols = -1;  /* T_twoPUCCH_F0_2_ConsecSymbols */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUSCH = -1;  /* T_twoDifferentTPC_Loop_PUSCH */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUCCH = -1;  /* T_twoDifferentTPC_Loop_PUCCH */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeA */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeB */
static int hf_nr_rrc_ul_SchedulingOffset = -1;    /* T_ul_SchedulingOffset */
static int hf_nr_rrc_dynamicSFI_01 = -1;          /* T_dynamicSFI_01 */
static int hf_nr_rrc_dummy1_04 = -1;              /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_twoFL_DMRS = -1;             /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_dummy2_04 = -1;              /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_dummy3_02 = -1;              /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_supportedDMRS_TypeDL = -1;   /* T_supportedDMRS_TypeDL */
static int hf_nr_rrc_supportedDMRS_TypeUL = -1;   /* T_supportedDMRS_TypeUL */
static int hf_nr_rrc_semiOpenLoopCSI = -1;        /* T_semiOpenLoopCSI */
static int hf_nr_rrc_csi_ReportWithoutPMI = -1;   /* T_csi_ReportWithoutPMI */
static int hf_nr_rrc_csi_ReportWithoutCQI = -1;   /* T_csi_ReportWithoutCQI */
static int hf_nr_rrc_onePortsPTRS = -1;           /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_twoPUCCH_F0_2_ConsecSymbols_01 = -1;  /* T_twoPUCCH_F0_2_ConsecSymbols_01 */
static int hf_nr_rrc_pucch_F2_WithFH = -1;        /* T_pucch_F2_WithFH */
static int hf_nr_rrc_pucch_F3_WithFH = -1;        /* T_pucch_F3_WithFH */
static int hf_nr_rrc_pucch_F4_WithFH = -1;        /* T_pucch_F4_WithFH */
static int hf_nr_rrc_pucch_F0_2WithoutFH = -1;    /* T_pucch_F0_2WithoutFH */
static int hf_nr_rrc_pucch_F1_3_4WithoutFH = -1;  /* T_pucch_F1_3_4WithoutFH */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot = -1;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot */
static int hf_nr_rrc_uci_CodeBlockSegmentation = -1;  /* T_uci_CodeBlockSegmentation */
static int hf_nr_rrc_onePUCCH_LongAndShortFormat = -1;  /* T_onePUCCH_LongAndShortFormat */
static int hf_nr_rrc_twoPUCCH_AnyOthersInSlot = -1;  /* T_twoPUCCH_AnyOthersInSlot */
static int hf_nr_rrc_intraSlotFreqHopping_PUSCH = -1;  /* T_intraSlotFreqHopping_PUSCH */
static int hf_nr_rrc_pusch_LBRM = -1;             /* T_pusch_LBRM */
static int hf_nr_rrc_pdcch_BlindDetectionCA = -1;  /* INTEGER_4_16 */
static int hf_nr_rrc_tpc_PUSCH_RNTI_01 = -1;      /* T_tpc_PUSCH_RNTI */
static int hf_nr_rrc_tpc_PUCCH_RNTI_01 = -1;      /* T_tpc_PUCCH_RNTI */
static int hf_nr_rrc_tpc_SRS_RNTI_01 = -1;        /* T_tpc_SRS_RNTI */
static int hf_nr_rrc_absoluteTPC_Command = -1;    /* T_absoluteTPC_Command */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUSCH_01 = -1;  /* T_twoDifferentTPC_Loop_PUSCH_01 */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUCCH_01 = -1;  /* T_twoDifferentTPC_Loop_PUCCH_01 */
static int hf_nr_rrc_pusch_HalfPi_BPSK = -1;      /* T_pusch_HalfPi_BPSK */
static int hf_nr_rrc_pucch_F3_4_HalfPi_BPSK = -1;  /* T_pucch_F3_4_HalfPi_BPSK */
static int hf_nr_rrc_almostContiguousCP_OFDM_UL = -1;  /* T_almostContiguousCP_OFDM_UL */
static int hf_nr_rrc_sp_CSI_RS = -1;              /* T_sp_CSI_RS */
static int hf_nr_rrc_sp_CSI_IM = -1;              /* T_sp_CSI_IM */
static int hf_nr_rrc_tdd_MultiDL_UL_SwitchPerSlot = -1;  /* T_tdd_MultiDL_UL_SwitchPerSlot */
static int hf_nr_rrc_multipleCORESET = -1;        /* T_multipleCORESET */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot = -1;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot */
static int hf_nr_rrc_sameSymbol = -1;             /* T_sameSymbol */
static int hf_nr_rrc_diffSymbol = -1;             /* T_diffSymbol */
static int hf_nr_rrc_mux_SR_HARQ_ACK_PUCCH = -1;  /* T_mux_SR_HARQ_ACK_PUCCH */
static int hf_nr_rrc_mux_MultipleGroupCtrlCH_Overlap = -1;  /* T_mux_MultipleGroupCtrlCH_Overlap */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_01 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeA_01 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_01 = -1;  /* T_dl_SchedulingOffset_PDSCH_TypeB_01 */
static int hf_nr_rrc_ul_SchedulingOffset_01 = -1;  /* T_ul_SchedulingOffset_01 */
static int hf_nr_rrc_dl_64QAM_MCS_TableAlt = -1;  /* T_dl_64QAM_MCS_TableAlt */
static int hf_nr_rrc_ul_64QAM_MCS_TableAlt = -1;  /* T_ul_64QAM_MCS_TableAlt */
static int hf_nr_rrc_cqi_TableAlt = -1;           /* T_cqi_TableAlt */
static int hf_nr_rrc_oneFL_DMRS_TwoAdditionalDMRS_UL = -1;  /* T_oneFL_DMRS_TwoAdditionalDMRS_UL */
static int hf_nr_rrc_twoFL_DMRS_TwoAdditionalDMRS_UL = -1;  /* T_twoFL_DMRS_TwoAdditionalDMRS_UL */
static int hf_nr_rrc_oneFL_DMRS_ThreeAdditionalDMRS_UL = -1;  /* T_oneFL_DMRS_ThreeAdditionalDMRS_UL */
static int hf_nr_rrc_pdcch_BlindDetectionNRDC = -1;  /* T_pdcch_BlindDetectionNRDC */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE = -1;  /* INTEGER_1_15 */
static int hf_nr_rrc_mux_HARQ_ACK_PUSCH_DiffSymbol = -1;  /* T_mux_HARQ_ACK_PUSCH_DiffSymbol */
static int hf_nr_rrc_pdcch_MonitoringSingleOccasion = -1;  /* T_pdcch_MonitoringSingleOccasion */
static int hf_nr_rrc_scs_60kHz_10 = -1;           /* T_scs_60kHz_07 */
static int hf_nr_rrc_pdsch_256QAM_FR1 = -1;       /* T_pdsch_256QAM_FR1 */
static int hf_nr_rrc_pdsch_RE_MappingFR1_PerSymbol = -1;  /* T_pdsch_RE_MappingFR1_PerSymbol */
static int hf_nr_rrc_pdsch_RE_MappingFR1_PerSlot = -1;  /* T_pdsch_RE_MappingFR1_PerSlot */
static int hf_nr_rrc_dummy_11 = -1;               /* T_dummy_08 */
static int hf_nr_rrc_pdsch_RE_MappingFR2_PerSymbol = -1;  /* T_pdsch_RE_MappingFR2_PerSymbol */
static int hf_nr_rrc_pCell_FR2 = -1;              /* T_pCell_FR2 */
static int hf_nr_rrc_pdsch_RE_MappingFR2_PerSlot = -1;  /* T_pdsch_RE_MappingFR2_PerSlot */
static int hf_nr_rrc_naics_Capability_List = -1;  /* SEQUENCE_SIZE_1_maxNrofNAICS_Entries_OF_NAICS_Capability_Entry */
static int hf_nr_rrc_naics_Capability_List_item = -1;  /* NAICS_Capability_Entry */
static int hf_nr_rrc_numberOfNAICS_CapableCC = -1;  /* INTEGER_1_5 */
static int hf_nr_rrc_numberOfAggregatedPRB = -1;  /* T_numberOfAggregatedPRB */
static int hf_nr_rrc_fallback = -1;               /* T_fallback */
static int hf_nr_rrc_differentTB_PerSlot = -1;    /* T_differentTB_PerSlot */
static int hf_nr_rrc_upto1 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_upto2 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_upto4 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_upto7 = -1;                  /* NumberOfCarriers */
static int hf_nr_rrc_supportedBandListNR = -1;    /* SEQUENCE_SIZE_1_maxBands_OF_BandNR */
static int hf_nr_rrc_supportedBandListNR_item = -1;  /* BandNR */
static int hf_nr_rrc_supportedBandCombinationList = -1;  /* BandCombinationList */
static int hf_nr_rrc_appliedFreqBandListFilter = -1;  /* FreqBandList */
static int hf_nr_rrc_supportedBandCombinationList_v1540 = -1;  /* BandCombinationList_v1540 */
static int hf_nr_rrc_srs_SwitchingTimeRequested = -1;  /* T_srs_SwitchingTimeRequested */
static int hf_nr_rrc_supportedBandCombinationList_v1550 = -1;  /* BandCombinationList_v1550 */
static int hf_nr_rrc_supportedBandCombinationList_v1560 = -1;  /* BandCombinationList_v1560 */
static int hf_nr_rrc_modifiedMPR_Behaviour = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_mimo_ParametersPerBand = -1;  /* MIMO_ParametersPerBand */
static int hf_nr_rrc_extendedCP = -1;             /* T_extendedCP */
static int hf_nr_rrc_multipleTCI = -1;            /* T_multipleTCI */
static int hf_nr_rrc_bwp_WithoutRestriction = -1;  /* T_bwp_WithoutRestriction */
static int hf_nr_rrc_bwp_SameNumerology = -1;     /* T_bwp_SameNumerology */
static int hf_nr_rrc_bwp_DiffNumerology = -1;     /* T_bwp_DiffNumerology */
static int hf_nr_rrc_crossCarrierScheduling_SameSCS = -1;  /* T_crossCarrierScheduling_SameSCS */
static int hf_nr_rrc_pdsch_256QAM_FR2 = -1;       /* T_pdsch_256QAM_FR2 */
static int hf_nr_rrc_pusch_256QAM = -1;           /* T_pusch_256QAM */
static int hf_nr_rrc_ue_PowerClass = -1;          /* T_ue_PowerClass */
static int hf_nr_rrc_rateMatchingLTE_CRS = -1;    /* T_rateMatchingLTE_CRS */
static int hf_nr_rrc_channelBWs_DL_v1530 = -1;    /* T_channelBWs_DL_v1530 */
static int hf_nr_rrc_fr1 = -1;                    /* T_fr1 */
static int hf_nr_rrc_scs_15kHz_08 = -1;           /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_scs_30kHz_08 = -1;           /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_scs_60kHz_11 = -1;           /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_fr2 = -1;                    /* T_fr2 */
static int hf_nr_rrc_scs_60kHz_12 = -1;           /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_scs_120kHz_09 = -1;          /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_channelBWs_UL_v1530 = -1;    /* T_channelBWs_UL_v1530 */
static int hf_nr_rrc_fr1_01 = -1;                 /* T_fr1_01 */
static int hf_nr_rrc_fr2_01 = -1;                 /* T_fr2_01 */
static int hf_nr_rrc_maxUplinkDutyCycle_PC2_FR1 = -1;  /* T_maxUplinkDutyCycle_PC2_FR1 */
static int hf_nr_rrc_pucch_SpatialRelInfoMAC_CE = -1;  /* T_pucch_SpatialRelInfoMAC_CE */
static int hf_nr_rrc_powerBoosting_pi2BPSK = -1;  /* T_powerBoosting_pi2BPSK */
static int hf_nr_rrc_maxUplinkDutyCycle_FR2 = -1;  /* T_maxUplinkDutyCycle_FR2 */
static int hf_nr_rrc_srs_SwitchingTimeRequested_01 = -1;  /* T_srs_SwitchingTimeRequested_01 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only = -1;  /* BandCombinationList */
static int hf_nr_rrc_supportedBandCombinationList_v1570 = -1;  /* BandCombinationList_v1570 */
static int hf_nr_rrc_am_WithShortSN = -1;         /* T_am_WithShortSN */
static int hf_nr_rrc_um_WithShortSN = -1;         /* T_um_WithShortSN */
static int hf_nr_rrc_um_WithLongSN = -1;          /* T_um_WithLongSN */
static int hf_nr_rrc_as_ReflectiveQoS = -1;       /* T_as_ReflectiveQoS */
static int hf_nr_rrc_switchingTimeDL = -1;        /* T_switchingTimeDL */
static int hf_nr_rrc_switchingTimeUL = -1;        /* T_switchingTimeUL */
static int hf_nr_rrc_switchingTimeDL_01 = -1;     /* T_switchingTimeDL_01 */
static int hf_nr_rrc_switchingTimeUL_01 = -1;     /* T_switchingTimeUL_01 */
static int hf_nr_rrc_fr1_02 = -1;                 /* T_fr1_02 */
static int hf_nr_rrc_fr2_02 = -1;                 /* T_fr2_02 */
static int hf_nr_rrc_UE_CapabilityRAT_ContainerList_item = -1;  /* UE_CapabilityRAT_Container */
static int hf_nr_rrc_rat_Type = -1;               /* RAT_Type */
static int hf_nr_rrc_ue_CapabilityRAT_Container = -1;  /* T_ue_CapabilityRAT_Container */
static int hf_nr_rrc_UE_CapabilityRAT_RequestList_item = -1;  /* UE_CapabilityRAT_Request */
static int hf_nr_rrc_capabilityRequestFilter = -1;  /* T_capabilityRequestFilter */
static int hf_nr_rrc_mrdc_Request = -1;           /* T_mrdc_Request */
static int hf_nr_rrc_omitEN_DC = -1;              /* T_omitEN_DC */
static int hf_nr_rrc_includeNR_DC = -1;           /* T_includeNR_DC */
static int hf_nr_rrc_includeNE_DC = -1;           /* T_includeNE_DC */
static int hf_nr_rrc_frequencyBandListFilter = -1;  /* FreqBandList */
static int hf_nr_rrc_nonCriticalExtension_51 = -1;  /* UE_CapabilityRequestFilterNR_v1540 */
static int hf_nr_rrc_srs_SwitchingTimeRequest = -1;  /* T_srs_SwitchingTimeRequest */
static int hf_nr_rrc_nonCriticalExtension_52 = -1;  /* T_nonCriticalExtension_37 */
static int hf_nr_rrc_measAndMobParametersMRDC = -1;  /* MeasAndMobParametersMRDC */
static int hf_nr_rrc_phy_ParametersMRDC_v1530 = -1;  /* Phy_ParametersMRDC */
static int hf_nr_rrc_rf_ParametersMRDC = -1;      /* RF_ParametersMRDC */
static int hf_nr_rrc_generalParametersMRDC = -1;  /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_fdd_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_MRDC_Capabilities = -1;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_featureSetCombinations = -1;  /* SEQUENCE_SIZE_1_maxFeatureSetCombinations_OF_FeatureSetCombination */
static int hf_nr_rrc_featureSetCombinations_item = -1;  /* FeatureSetCombination */
static int hf_nr_rrc_pdcp_ParametersMRDC_v1530 = -1;  /* PDCP_ParametersMRDC */
static int hf_nr_rrc_nonCriticalExtension_53 = -1;  /* UE_MRDC_Capability_v1560 */
static int hf_nr_rrc_receivedFilters = -1;        /* T_receivedFilters */
static int hf_nr_rrc_measAndMobParametersMRDC_v1560 = -1;  /* MeasAndMobParametersMRDC_v1560 */
static int hf_nr_rrc_fdd_Add_UE_MRDC_Capabilities_v1560 = -1;  /* UE_MRDC_CapabilityAddXDD_Mode_v1560 */
static int hf_nr_rrc_tdd_Add_UE_MRDC_Capabilities_v1560 = -1;  /* UE_MRDC_CapabilityAddXDD_Mode_v1560 */
static int hf_nr_rrc_nonCriticalExtension_54 = -1;  /* T_nonCriticalExtension_38 */
static int hf_nr_rrc_generalParametersMRDC_XDD_Diff = -1;  /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_splitSRB_WithOneUL_Path = -1;  /* T_splitSRB_WithOneUL_Path */
static int hf_nr_rrc_splitDRB_withUL_Both_MCG_SCG = -1;  /* T_splitDRB_withUL_Both_MCG_SCG */
static int hf_nr_rrc_srb3 = -1;                   /* T_srb3 */
static int hf_nr_rrc_v2x_EUTRA = -1;              /* T_v2x_EUTRA */
static int hf_nr_rrc_accessStratumRelease = -1;   /* AccessStratumRelease */
static int hf_nr_rrc_pdcp_Parameters = -1;        /* PDCP_Parameters */
static int hf_nr_rrc_rlc_Parameters = -1;         /* RLC_Parameters */
static int hf_nr_rrc_mac_Parameters = -1;         /* MAC_Parameters */
static int hf_nr_rrc_phy_Parameters = -1;         /* Phy_Parameters */
static int hf_nr_rrc_rf_Parameters = -1;          /* RF_Parameters */
static int hf_nr_rrc_measAndMobParameters = -1;   /* MeasAndMobParameters */
static int hf_nr_rrc_fdd_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_featureSets = -1;            /* FeatureSets */
static int hf_nr_rrc_nonCriticalExtension_55 = -1;  /* UE_NR_Capability_v1530 */
static int hf_nr_rrc_fdd_Add_UE_NR_Capabilities_v1530 = -1;  /* UE_NR_CapabilityAddXDD_Mode_v1530 */
static int hf_nr_rrc_tdd_Add_UE_NR_Capabilities_v1530 = -1;  /* UE_NR_CapabilityAddXDD_Mode_v1530 */
static int hf_nr_rrc_dummy_12 = -1;               /* T_dummy_09 */
static int hf_nr_rrc_interRAT_Parameters = -1;    /* InterRAT_Parameters */
static int hf_nr_rrc_inactiveState = -1;          /* T_inactiveState */
static int hf_nr_rrc_delayBudgetReporting = -1;   /* T_delayBudgetReporting */
static int hf_nr_rrc_nonCriticalExtension_56 = -1;  /* UE_NR_Capability_v1540 */
static int hf_nr_rrc_sdap_Parameters = -1;        /* SDAP_Parameters */
static int hf_nr_rrc_overheatingInd = -1;         /* T_overheatingInd */
static int hf_nr_rrc_ims_Parameters = -1;         /* IMS_Parameters */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities_v1540 = -1;  /* UE_NR_CapabilityAddFRX_Mode_v1540 */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities_v1540 = -1;  /* UE_NR_CapabilityAddFRX_Mode_v1540 */
static int hf_nr_rrc_fr1_fr2_Add_UE_NR_Capabilities = -1;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_nonCriticalExtension_57 = -1;  /* UE_NR_Capability_v1550 */
static int hf_nr_rrc_reducedCP_Latency = -1;      /* T_reducedCP_Latency */
static int hf_nr_rrc_nonCriticalExtension_58 = -1;  /* UE_NR_Capability_v1560 */
static int hf_nr_rrc_nrdc_Parameters = -1;        /* NRDC_Parameters */
static int hf_nr_rrc_receivedFilters_01 = -1;     /* T_receivedFilters_01 */
static int hf_nr_rrc_nonCriticalExtension_59 = -1;  /* UE_NR_Capability_v1570 */
static int hf_nr_rrc_nrdc_Parameters_v1570 = -1;  /* NRDC_Parameters_v1570 */
static int hf_nr_rrc_nonCriticalExtension_60 = -1;  /* T_nonCriticalExtension_39 */
static int hf_nr_rrc_EUTRA_MBSFN_SubframeConfigList_item = -1;  /* EUTRA_MBSFN_SubframeConfig */
static int hf_nr_rrc_radioframeAllocationPeriod = -1;  /* T_radioframeAllocationPeriod */
static int hf_nr_rrc_radioframeAllocationOffset = -1;  /* INTEGER_0_7 */
static int hf_nr_rrc_subframeAllocation1 = -1;    /* T_subframeAllocation1 */
static int hf_nr_rrc_oneFrame = -1;               /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_fourFrames = -1;             /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_subframeAllocation2 = -1;    /* T_subframeAllocation2 */
static int hf_nr_rrc_oneFrame_01 = -1;            /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_fourFrames_01 = -1;          /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_EUTRA_MultiBandInfoList_item = -1;  /* EUTRA_MultiBandInfo */
static int hf_nr_rrc_eutra_FreqBandIndicator = -1;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_eutra_NS_PmaxList = -1;      /* EUTRA_NS_PmaxList */
static int hf_nr_rrc_EUTRA_NS_PmaxList_item = -1;  /* EUTRA_NS_PmaxValue */
static int hf_nr_rrc_additionalPmax_01 = -1;      /* INTEGER_M30_33 */
static int hf_nr_rrc_additionalSpectrumEmission_01 = -1;  /* INTEGER_1_288 */
static int hf_nr_rrc_start_01 = -1;               /* EUTRA_PhysCellId */
static int hf_nr_rrc_range_01 = -1;               /* T_range_01 */
static int hf_nr_rrc_delayBudgetReportingConfig = -1;  /* T_delayBudgetReportingConfig */
static int hf_nr_rrc_setup_51 = -1;               /* T_setup */
static int hf_nr_rrc_delayBudgetReportingProhibitTimer = -1;  /* T_delayBudgetReportingProhibitTimer */
static int hf_nr_rrc_overheatingAssistanceConfig = -1;  /* T_overheatingAssistanceConfig */
static int hf_nr_rrc_setup_52 = -1;               /* OverheatingAssistanceConfig */
static int hf_nr_rrc_overheatingIndicationProhibitTimer = -1;  /* T_overheatingIndicationProhibitTimer */
static int dummy_hf_nr_rrc_eag_field = -1; /* never registered */

/*--- End of included file: packet-nr-rrc-hf.c ---*/
#line 63 "./asn1/nr-rrc/packet-nr-rrc-template.c"
static int hf_nr_rrc_serialNumber_gs = -1;
static int hf_nr_rrc_serialNumber_msg_code = -1;
static int hf_nr_rrc_serialNumber_upd_nb = -1;
static int hf_nr_rrc_warningType_value = -1;
static int hf_nr_rrc_warningType_emergency_user_alert = -1;
static int hf_nr_rrc_warningType_popup = -1;
static int hf_nr_rrc_warningMessageSegment_nb_pages = -1;
static int hf_nr_rrc_warningMessageSegment_decoded_page = -1;
static int hf_nr_rrc_sib7_fragments = -1;
static int hf_nr_rrc_sib7_fragment = -1;
static int hf_nr_rrc_sib7_fragment_overlap = -1;
static int hf_nr_rrc_sib7_fragment_overlap_conflict = -1;
static int hf_nr_rrc_sib7_fragment_multiple_tails = -1;
static int hf_nr_rrc_sib7_fragment_too_long_fragment = -1;
static int hf_nr_rrc_sib7_fragment_error = -1;
static int hf_nr_rrc_sib7_fragment_count = -1;
static int hf_nr_rrc_sib7_reassembled_in = -1;
static int hf_nr_rrc_sib7_reassembled_length = -1;
static int hf_nr_rrc_sib7_reassembled_data = -1;
static int hf_nr_rrc_sib8_fragments = -1;
static int hf_nr_rrc_sib8_fragment = -1;
static int hf_nr_rrc_sib8_fragment_overlap = -1;
static int hf_nr_rrc_sib8_fragment_overlap_conflict = -1;
static int hf_nr_rrc_sib8_fragment_multiple_tails = -1;
static int hf_nr_rrc_sib8_fragment_too_long_fragment = -1;
static int hf_nr_rrc_sib8_fragment_error = -1;
static int hf_nr_rrc_sib8_fragment_count = -1;
static int hf_nr_rrc_sib8_reassembled_in = -1;
static int hf_nr_rrc_sib8_reassembled_length = -1;
static int hf_nr_rrc_sib8_reassembled_data = -1;
static int hf_nr_rrc_utc_time = -1;
static int hf_nr_rrc_local_time = -1;

/* Initialize the subtree pointers */
static gint ett_nr_rrc = -1;

/*--- Included file: packet-nr-rrc-ett.c ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-ett.c"
static gint ett_nr_rrc_HandoverCommand = -1;
static gint ett_nr_rrc_T_criticalExtensions = -1;
static gint ett_nr_rrc_T_c1 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture = -1;
static gint ett_nr_rrc_HandoverCommand_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension = -1;
static gint ett_nr_rrc_HandoverPreparationInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_01 = -1;
static gint ett_nr_rrc_T_c1_01 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_01 = -1;
static gint ett_nr_rrc_HandoverPreparationInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_01 = -1;
static gint ett_nr_rrc_AS_Config = -1;
static gint ett_nr_rrc_AS_Context = -1;
static gint ett_nr_rrc_ReestablishmentInfo = -1;
static gint ett_nr_rrc_ReestabNCellInfoList = -1;
static gint ett_nr_rrc_ReestabNCellInfo = -1;
static gint ett_nr_rrc_RRM_Config = -1;
static gint ett_nr_rrc_CG_Config = -1;
static gint ett_nr_rrc_T_criticalExtensions_02 = -1;
static gint ett_nr_rrc_T_c1_02 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_02 = -1;
static gint ett_nr_rrc_CG_Config_IEs = -1;
static gint ett_nr_rrc_CG_Config_v1540_IEs = -1;
static gint ett_nr_rrc_T_reportCGI_RequestNR = -1;
static gint ett_nr_rrc_T_requestedCellInfo = -1;
static gint ett_nr_rrc_CG_Config_v1560_IEs = -1;
static gint ett_nr_rrc_T_reportCGI_RequestEUTRA = -1;
static gint ett_nr_rrc_T_requestedCellInfoEUTRA = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_02 = -1;
static gint ett_nr_rrc_PH_TypeListSCG = -1;
static gint ett_nr_rrc_PH_InfoSCG = -1;
static gint ett_nr_rrc_PH_UplinkCarrierSCG = -1;
static gint ett_nr_rrc_MeasConfigSN = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo = -1;
static gint ett_nr_rrc_NR_FreqInfo = -1;
static gint ett_nr_rrc_ConfigRestrictModReqSCG = -1;
static gint ett_nr_rrc_BandCombinationInfoSN = -1;
static gint ett_nr_rrc_FR_InfoList = -1;
static gint ett_nr_rrc_FR_Info = -1;
static gint ett_nr_rrc_CandidateServingFreqListNR = -1;
static gint ett_nr_rrc_CandidateServingFreqListEUTRA = -1;
static gint ett_nr_rrc_CG_ConfigInfo = -1;
static gint ett_nr_rrc_T_criticalExtensions_03 = -1;
static gint ett_nr_rrc_T_c1_03 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_03 = -1;
static gint ett_nr_rrc_CG_ConfigInfo_IEs = -1;
static gint ett_nr_rrc_T_scgFailureInfo = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1540_IEs = -1;
static gint ett_nr_rrc_T_measResultReportCGI = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1560_IEs = -1;
static gint ett_nr_rrc_T_scgFailureInfoEUTRA = -1;
static gint ett_nr_rrc_T_measResultReportCGI_EUTRA = -1;
static gint ett_nr_rrc_CG_ConfigInfo_v1570_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_03 = -1;
static gint ett_nr_rrc_SFTD_FrequencyList_NR = -1;
static gint ett_nr_rrc_SFTD_FrequencyList_EUTRA = -1;
static gint ett_nr_rrc_ConfigRestrictInfoSCG = -1;
static gint ett_nr_rrc_T_powerCoordination_FR1 = -1;
static gint ett_nr_rrc_T_servCellIndexRangeSCG = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN = -1;
static gint ett_nr_rrc_SelectedBandEntriesMN = -1;
static gint ett_nr_rrc_PH_TypeListMCG = -1;
static gint ett_nr_rrc_PH_InfoMCG = -1;
static gint ett_nr_rrc_PH_UplinkCarrierMCG = -1;
static gint ett_nr_rrc_BandCombinationInfoList = -1;
static gint ett_nr_rrc_BandCombinationInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex = -1;
static gint ett_nr_rrc_DRX_Info = -1;
static gint ett_nr_rrc_T_drx_LongCycleStartOffset = -1;
static gint ett_nr_rrc_T_shortDRX = -1;
static gint ett_nr_rrc_MeasConfigMN = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo = -1;
static gint ett_nr_rrc_T_measGapConfig = -1;
static gint ett_nr_rrc_T_measGapConfigFR2 = -1;
static gint ett_nr_rrc_MRDC_AssistanceInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC = -1;
static gint ett_nr_rrc_AffectedCarrierFreqCombInfoMRDC = -1;
static gint ett_nr_rrc_T_affectedCarrierFreqCombMRDC = -1;
static gint ett_nr_rrc_VictimSystemType = -1;
static gint ett_nr_rrc_AffectedCarrierFreqCombEUTRA = -1;
static gint ett_nr_rrc_AffectedCarrierFreqCombNR = -1;
static gint ett_nr_rrc_MeasurementTimingConfiguration = -1;
static gint ett_nr_rrc_T_criticalExtensions_04 = -1;
static gint ett_nr_rrc_T_c1_04 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_04 = -1;
static gint ett_nr_rrc_MeasurementTimingConfiguration_IEs = -1;
static gint ett_nr_rrc_MeasurementTimingConfiguration_v1550_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_04 = -1;
static gint ett_nr_rrc_MeasTimingList = -1;
static gint ett_nr_rrc_MeasTiming = -1;
static gint ett_nr_rrc_T_frequencyAndTiming = -1;
static gint ett_nr_rrc_UERadioPagingInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_05 = -1;
static gint ett_nr_rrc_T_c1_05 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_05 = -1;
static gint ett_nr_rrc_UERadioPagingInformation_IEs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_05 = -1;
static gint ett_nr_rrc_UERadioAccessCapabilityInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_06 = -1;
static gint ett_nr_rrc_T_c1_06 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_06 = -1;
static gint ett_nr_rrc_UERadioAccessCapabilityInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_06 = -1;
static gint ett_nr_rrc_BCCH_BCH_Message = -1;
static gint ett_nr_rrc_BCCH_BCH_MessageType = -1;
static gint ett_nr_rrc_T_messageClassExtension = -1;
static gint ett_nr_rrc_BCCH_DL_SCH_Message = -1;
static gint ett_nr_rrc_BCCH_DL_SCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_07 = -1;
static gint ett_nr_rrc_T_messageClassExtension_01 = -1;
static gint ett_nr_rrc_DL_CCCH_Message = -1;
static gint ett_nr_rrc_DL_CCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_08 = -1;
static gint ett_nr_rrc_T_messageClassExtension_02 = -1;
static gint ett_nr_rrc_DL_DCCH_Message = -1;
static gint ett_nr_rrc_DL_DCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_09 = -1;
static gint ett_nr_rrc_T_messageClassExtension_03 = -1;
static gint ett_nr_rrc_PCCH_Message = -1;
static gint ett_nr_rrc_PCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_10 = -1;
static gint ett_nr_rrc_T_messageClassExtension_04 = -1;
static gint ett_nr_rrc_UL_CCCH_Message = -1;
static gint ett_nr_rrc_UL_CCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_11 = -1;
static gint ett_nr_rrc_T_messageClassExtension_05 = -1;
static gint ett_nr_rrc_UL_CCCH1_Message = -1;
static gint ett_nr_rrc_UL_CCCH1_MessageType = -1;
static gint ett_nr_rrc_T_c1_12 = -1;
static gint ett_nr_rrc_T_messageClassExtension_06 = -1;
static gint ett_nr_rrc_UL_DCCH_Message = -1;
static gint ett_nr_rrc_UL_DCCH_MessageType = -1;
static gint ett_nr_rrc_T_c1_13 = -1;
static gint ett_nr_rrc_T_messageClassExtension_07 = -1;
static gint ett_nr_rrc_CounterCheck = -1;
static gint ett_nr_rrc_T_criticalExtensions_07 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_07 = -1;
static gint ett_nr_rrc_CounterCheck_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_07 = -1;
static gint ett_nr_rrc_DRB_CountMSB_InfoList = -1;
static gint ett_nr_rrc_DRB_CountMSB_Info = -1;
static gint ett_nr_rrc_CounterCheckResponse = -1;
static gint ett_nr_rrc_T_criticalExtensions_08 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_08 = -1;
static gint ett_nr_rrc_CounterCheckResponse_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_08 = -1;
static gint ett_nr_rrc_DRB_CountInfoList = -1;
static gint ett_nr_rrc_DRB_CountInfo = -1;
static gint ett_nr_rrc_DLInformationTransfer = -1;
static gint ett_nr_rrc_T_criticalExtensions_09 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_09 = -1;
static gint ett_nr_rrc_DLInformationTransfer_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_09 = -1;
static gint ett_nr_rrc_FailureInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_10 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_10 = -1;
static gint ett_nr_rrc_FailureInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_10 = -1;
static gint ett_nr_rrc_FailureInfoRLC_Bearer = -1;
static gint ett_nr_rrc_LocationMeasurementIndication = -1;
static gint ett_nr_rrc_T_criticalExtensions_11 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_11 = -1;
static gint ett_nr_rrc_LocationMeasurementIndication_IEs = -1;
static gint ett_nr_rrc_T_measurementIndication = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_11 = -1;
static gint ett_nr_rrc_MeasurementReport = -1;
static gint ett_nr_rrc_T_criticalExtensions_12 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_12 = -1;
static gint ett_nr_rrc_MeasurementReport_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_12 = -1;
static gint ett_nr_rrc_MIB = -1;
static gint ett_nr_rrc_MobilityFromNRCommand = -1;
static gint ett_nr_rrc_T_criticalExtensions_13 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_13 = -1;
static gint ett_nr_rrc_MobilityFromNRCommand_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_13 = -1;
static gint ett_nr_rrc_Paging = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_14 = -1;
static gint ett_nr_rrc_PagingRecordList = -1;
static gint ett_nr_rrc_PagingRecord = -1;
static gint ett_nr_rrc_PagingUE_Identity = -1;
static gint ett_nr_rrc_RRCReestablishment = -1;
static gint ett_nr_rrc_T_criticalExtensions_14 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_14 = -1;
static gint ett_nr_rrc_RRCReestablishment_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_15 = -1;
static gint ett_nr_rrc_RRCReestablishmentComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_15 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_15 = -1;
static gint ett_nr_rrc_RRCReestablishmentComplete_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_16 = -1;
static gint ett_nr_rrc_RRCReestablishmentRequest = -1;
static gint ett_nr_rrc_RRCReestablishmentRequest_IEs = -1;
static gint ett_nr_rrc_ReestabUE_Identity = -1;
static gint ett_nr_rrc_RRCReconfiguration = -1;
static gint ett_nr_rrc_T_criticalExtensions_16 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_16 = -1;
static gint ett_nr_rrc_RRCReconfiguration_IEs = -1;
static gint ett_nr_rrc_RRCReconfiguration_v1530_IEs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message = -1;
static gint ett_nr_rrc_RRCReconfiguration_v1540_IEs = -1;
static gint ett_nr_rrc_RRCReconfiguration_v1560_IEs = -1;
static gint ett_nr_rrc_T_mrdc_SecondaryCellGroupConfig = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_17 = -1;
static gint ett_nr_rrc_MRDC_SecondaryCellGroupConfig = -1;
static gint ett_nr_rrc_T_mrdc_SecondaryCellGroup = -1;
static gint ett_nr_rrc_MasterKeyUpdate = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_17 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_17 = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_IEs = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_v1530_IEs = -1;
static gint ett_nr_rrc_RRCReconfigurationComplete_v1560_IEs = -1;
static gint ett_nr_rrc_T_scg_Response = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_18 = -1;
static gint ett_nr_rrc_RRCReject = -1;
static gint ett_nr_rrc_T_criticalExtensions_18 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_18 = -1;
static gint ett_nr_rrc_RRCReject_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_19 = -1;
static gint ett_nr_rrc_RRCRelease = -1;
static gint ett_nr_rrc_T_criticalExtensions_19 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_19 = -1;
static gint ett_nr_rrc_RRCRelease_IEs = -1;
static gint ett_nr_rrc_T_deprioritisationReq = -1;
static gint ett_nr_rrc_RRCRelease_v1540_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_20 = -1;
static gint ett_nr_rrc_RedirectedCarrierInfo = -1;
static gint ett_nr_rrc_RedirectedCarrierInfo_EUTRA = -1;
static gint ett_nr_rrc_CarrierInfoNR = -1;
static gint ett_nr_rrc_SuspendConfig = -1;
static gint ett_nr_rrc_CellReselectionPriorities = -1;
static gint ett_nr_rrc_FreqPriorityListEUTRA = -1;
static gint ett_nr_rrc_FreqPriorityListNR = -1;
static gint ett_nr_rrc_FreqPriorityEUTRA = -1;
static gint ett_nr_rrc_FreqPriorityNR = -1;
static gint ett_nr_rrc_RAN_NotificationAreaInfo = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaCellList = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaConfigList = -1;
static gint ett_nr_rrc_PLMN_RAN_AreaConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig = -1;
static gint ett_nr_rrc_RAN_AreaConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode = -1;
static gint ett_nr_rrc_RRCResume = -1;
static gint ett_nr_rrc_T_criticalExtensions_20 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_20 = -1;
static gint ett_nr_rrc_RRCResume_IEs = -1;
static gint ett_nr_rrc_RRCResume_v1560_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_21 = -1;
static gint ett_nr_rrc_RRCResumeComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_21 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_21 = -1;
static gint ett_nr_rrc_RRCResumeComplete_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_22 = -1;
static gint ett_nr_rrc_RRCResumeRequest = -1;
static gint ett_nr_rrc_RRCResumeRequest_IEs = -1;
static gint ett_nr_rrc_RRCResumeRequest1 = -1;
static gint ett_nr_rrc_RRCResumeRequest1_IEs = -1;
static gint ett_nr_rrc_RRCSetup = -1;
static gint ett_nr_rrc_T_criticalExtensions_22 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_22 = -1;
static gint ett_nr_rrc_RRCSetup_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_23 = -1;
static gint ett_nr_rrc_RRCSetupComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_23 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_23 = -1;
static gint ett_nr_rrc_RRCSetupComplete_IEs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI = -1;
static gint ett_nr_rrc_T_ng_5G_S_TMSI_Value = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_24 = -1;
static gint ett_nr_rrc_RegisteredAMF = -1;
static gint ett_nr_rrc_RRCSetupRequest = -1;
static gint ett_nr_rrc_RRCSetupRequest_IEs = -1;
static gint ett_nr_rrc_InitialUE_Identity = -1;
static gint ett_nr_rrc_RRCSystemInfoRequest = -1;
static gint ett_nr_rrc_T_criticalExtensions_24 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_24 = -1;
static gint ett_nr_rrc_RRCSystemInfoRequest_r15_IEs = -1;
static gint ett_nr_rrc_SCGFailureInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_25 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_25 = -1;
static gint ett_nr_rrc_SCGFailureInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_25 = -1;
static gint ett_nr_rrc_FailureReportSCG = -1;
static gint ett_nr_rrc_MeasResultFreqList = -1;
static gint ett_nr_rrc_SCGFailureInformationEUTRA = -1;
static gint ett_nr_rrc_T_criticalExtensions_26 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_26 = -1;
static gint ett_nr_rrc_SCGFailureInformationEUTRA_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_26 = -1;
static gint ett_nr_rrc_FailureReportSCG_EUTRA = -1;
static gint ett_nr_rrc_MeasResultFreqListFailMRDC = -1;
static gint ett_nr_rrc_SecurityModeCommand = -1;
static gint ett_nr_rrc_T_criticalExtensions_27 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_27 = -1;
static gint ett_nr_rrc_SecurityModeCommand_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_27 = -1;
static gint ett_nr_rrc_SecurityConfigSMC = -1;
static gint ett_nr_rrc_SecurityModeComplete = -1;
static gint ett_nr_rrc_T_criticalExtensions_28 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_28 = -1;
static gint ett_nr_rrc_SecurityModeComplete_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_28 = -1;
static gint ett_nr_rrc_SecurityModeFailure = -1;
static gint ett_nr_rrc_T_criticalExtensions_29 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_29 = -1;
static gint ett_nr_rrc_SecurityModeFailure_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_29 = -1;
static gint ett_nr_rrc_SIB1 = -1;
static gint ett_nr_rrc_T_cellSelectionInfo = -1;
static gint ett_nr_rrc_T_uac_BarringInfo = -1;
static gint ett_nr_rrc_T_uac_AccessCategory1_SelectionAssistanceInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_30 = -1;
static gint ett_nr_rrc_SystemInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_30 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_30 = -1;
static gint ett_nr_rrc_SystemInformation_IEs = -1;
static gint ett_nr_rrc_T_sib_TypeAndInfo = -1;
static gint ett_nr_rrc_T_sib_TypeAndInfo_item = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_31 = -1;
static gint ett_nr_rrc_UEAssistanceInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_31 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_31 = -1;
static gint ett_nr_rrc_UEAssistanceInformation_IEs = -1;
static gint ett_nr_rrc_DelayBudgetReport = -1;
static gint ett_nr_rrc_UEAssistanceInformation_v1540_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_32 = -1;
static gint ett_nr_rrc_OverheatingAssistance = -1;
static gint ett_nr_rrc_T_reducedMaxCCs = -1;
static gint ett_nr_rrc_T_reducedMaxBW_FR1 = -1;
static gint ett_nr_rrc_T_reducedMaxBW_FR2 = -1;
static gint ett_nr_rrc_T_reducedMaxMIMO_LayersFR1 = -1;
static gint ett_nr_rrc_T_reducedMaxMIMO_LayersFR2 = -1;
static gint ett_nr_rrc_UECapabilityEnquiry = -1;
static gint ett_nr_rrc_T_criticalExtensions_32 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_32 = -1;
static gint ett_nr_rrc_UECapabilityEnquiry_IEs = -1;
static gint ett_nr_rrc_UECapabilityEnquiry_v1560_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_33 = -1;
static gint ett_nr_rrc_UECapabilityInformation = -1;
static gint ett_nr_rrc_T_criticalExtensions_33 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_33 = -1;
static gint ett_nr_rrc_UECapabilityInformation_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_34 = -1;
static gint ett_nr_rrc_ULInformationTransfer = -1;
static gint ett_nr_rrc_T_criticalExtensions_34 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_34 = -1;
static gint ett_nr_rrc_ULInformationTransfer_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_35 = -1;
static gint ett_nr_rrc_ULInformationTransferMRDC = -1;
static gint ett_nr_rrc_T_criticalExtensions_35 = -1;
static gint ett_nr_rrc_T_c1_14 = -1;
static gint ett_nr_rrc_T_criticalExtensionsFuture_35 = -1;
static gint ett_nr_rrc_ULInformationTransferMRDC_IEs = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_36 = -1;
static gint ett_nr_rrc_SIB2 = -1;
static gint ett_nr_rrc_T_cellReselectionInfoCommon = -1;
static gint ett_nr_rrc_T_speedStateReselectionPars = -1;
static gint ett_nr_rrc_T_q_HystSF = -1;
static gint ett_nr_rrc_T_cellReselectionServingFreqInfo = -1;
static gint ett_nr_rrc_T_intraFreqCellReselectionInfo = -1;
static gint ett_nr_rrc_SIB3 = -1;
static gint ett_nr_rrc_IntraFreqNeighCellList = -1;
static gint ett_nr_rrc_IntraFreqNeighCellInfo = -1;
static gint ett_nr_rrc_IntraFreqBlackCellList = -1;
static gint ett_nr_rrc_SIB4 = -1;
static gint ett_nr_rrc_InterFreqCarrierFreqList = -1;
static gint ett_nr_rrc_InterFreqCarrierFreqInfo = -1;
static gint ett_nr_rrc_T_threshX_Q = -1;
static gint ett_nr_rrc_InterFreqNeighCellList = -1;
static gint ett_nr_rrc_InterFreqNeighCellInfo = -1;
static gint ett_nr_rrc_InterFreqBlackCellList = -1;
static gint ett_nr_rrc_SIB5 = -1;
static gint ett_nr_rrc_CarrierFreqListEUTRA = -1;
static gint ett_nr_rrc_CarrierFreqEUTRA = -1;
static gint ett_nr_rrc_T_threshX_Q_01 = -1;
static gint ett_nr_rrc_EUTRA_FreqBlackCellList = -1;
static gint ett_nr_rrc_EUTRA_FreqNeighCellList = -1;
static gint ett_nr_rrc_EUTRA_FreqNeighCellInfo = -1;
static gint ett_nr_rrc_SIB6 = -1;
static gint ett_nr_rrc_SIB7 = -1;
static gint ett_nr_rrc_SIB8 = -1;
static gint ett_nr_rrc_SIB9 = -1;
static gint ett_nr_rrc_T_timeInfo = -1;
static gint ett_nr_rrc_BeamFailureRecoveryConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCandidateBeams_OF_PRACH_ResourceDedicatedBFR = -1;
static gint ett_nr_rrc_PRACH_ResourceDedicatedBFR = -1;
static gint ett_nr_rrc_BFR_SSB_Resource = -1;
static gint ett_nr_rrc_BFR_CSIRS_Resource = -1;
static gint ett_nr_rrc_T_ra_OccasionList = -1;
static gint ett_nr_rrc_BetaOffsets = -1;
static gint ett_nr_rrc_BSR_Config = -1;
static gint ett_nr_rrc_BWP = -1;
static gint ett_nr_rrc_BWP_Downlink = -1;
static gint ett_nr_rrc_BWP_DownlinkCommon = -1;
static gint ett_nr_rrc_T_pdcch_ConfigCommon = -1;
static gint ett_nr_rrc_T_pdsch_ConfigCommon = -1;
static gint ett_nr_rrc_BWP_DownlinkDedicated = -1;
static gint ett_nr_rrc_T_pdcch_Config = -1;
static gint ett_nr_rrc_T_pdsch_Config = -1;
static gint ett_nr_rrc_T_sps_Config = -1;
static gint ett_nr_rrc_T_radioLinkMonitoringConfig = -1;
static gint ett_nr_rrc_BWP_Uplink = -1;
static gint ett_nr_rrc_BWP_UplinkCommon = -1;
static gint ett_nr_rrc_T_rach_ConfigCommon = -1;
static gint ett_nr_rrc_T_pusch_ConfigCommon = -1;
static gint ett_nr_rrc_T_pucch_ConfigCommon = -1;
static gint ett_nr_rrc_BWP_UplinkDedicated = -1;
static gint ett_nr_rrc_T_pucch_Config = -1;
static gint ett_nr_rrc_T_pusch_Config = -1;
static gint ett_nr_rrc_T_configuredGrantConfig = -1;
static gint ett_nr_rrc_T_srs_Config = -1;
static gint ett_nr_rrc_T_beamFailureRecoveryConfig = -1;
static gint ett_nr_rrc_CellAccessRelatedInfo = -1;
static gint ett_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC = -1;
static gint ett_nr_rrc_PLMN_IdentityList_EUTRA_5GC = -1;
static gint ett_nr_rrc_PLMN_Identity_EUTRA_5GC = -1;
static gint ett_nr_rrc_CellIdentity_EUTRA_5GC = -1;
static gint ett_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC = -1;
static gint ett_nr_rrc_PLMN_IdentityList_EUTRA_EPC = -1;
static gint ett_nr_rrc_CellGroupConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxLC_ID_OF_RLC_BearerConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxLC_ID_OF_LogicalChannelIdentity = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellIndex = -1;
static gint ett_nr_rrc_SpCellConfig = -1;
static gint ett_nr_rrc_T_rlf_TimersAndConstants = -1;
static gint ett_nr_rrc_ReconfigurationWithSync = -1;
static gint ett_nr_rrc_T_rach_ConfigDedicated = -1;
static gint ett_nr_rrc_SCellConfig = -1;
static gint ett_nr_rrc_CGI_InfoEUTRA = -1;
static gint ett_nr_rrc_T_cgi_info_EPC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC = -1;
static gint ett_nr_rrc_CGI_InfoNR = -1;
static gint ett_nr_rrc_T_noSIB1 = -1;
static gint ett_nr_rrc_CodebookConfig = -1;
static gint ett_nr_rrc_T_codebookType = -1;
static gint ett_nr_rrc_T_type1_01 = -1;
static gint ett_nr_rrc_T_subType = -1;
static gint ett_nr_rrc_T_typeI_SinglePanel = -1;
static gint ett_nr_rrc_T_nrOfAntennaPorts = -1;
static gint ett_nr_rrc_T_two = -1;
static gint ett_nr_rrc_T_moreThanTwo = -1;
static gint ett_nr_rrc_T_n1_n2 = -1;
static gint ett_nr_rrc_T_typeI_MultiPanel = -1;
static gint ett_nr_rrc_T_ng_n1_n2 = -1;
static gint ett_nr_rrc_T_type2 = -1;
static gint ett_nr_rrc_T_subType_01 = -1;
static gint ett_nr_rrc_T_typeII = -1;
static gint ett_nr_rrc_T_n1_n2_codebookSubsetRestriction = -1;
static gint ett_nr_rrc_T_typeII_PortSelection = -1;
static gint ett_nr_rrc_ConfiguredGrantConfig = -1;
static gint ett_nr_rrc_T_uci_OnPUSCH = -1;
static gint ett_nr_rrc_T_rrc_ConfiguredUplinkGrant = -1;
static gint ett_nr_rrc_CG_UCI_OnPUSCH = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_BetaOffsets = -1;
static gint ett_nr_rrc_ConnEstFailureControl = -1;
static gint ett_nr_rrc_ControlResourceSet = -1;
static gint ett_nr_rrc_T_cce_REG_MappingType = -1;
static gint ett_nr_rrc_T_interleaved = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId = -1;
static gint ett_nr_rrc_CrossCarrierSchedulingConfig = -1;
static gint ett_nr_rrc_T_schedulingCellInfo = -1;
static gint ett_nr_rrc_T_own = -1;
static gint ett_nr_rrc_T_other = -1;
static gint ett_nr_rrc_CSI_AperiodicTriggerStateList = -1;
static gint ett_nr_rrc_CSI_AperiodicTriggerState = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofReportConfigPerAperiodicTrigger_OF_CSI_AssociatedReportConfigInfo = -1;
static gint ett_nr_rrc_CSI_AssociatedReportConfigInfo = -1;
static gint ett_nr_rrc_T_resourcesForChannel = -1;
static gint ett_nr_rrc_T_nzp_CSI_RS = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAP_CSI_RS_ResourcesPerSet_OF_TCI_StateId = -1;
static gint ett_nr_rrc_CSI_FrequencyOccupation = -1;
static gint ett_nr_rrc_CSI_IM_Resource = -1;
static gint ett_nr_rrc_T_csi_IM_ResourceElementPattern = -1;
static gint ett_nr_rrc_T_pattern0 = -1;
static gint ett_nr_rrc_T_pattern1 = -1;
static gint ett_nr_rrc_CSI_IM_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourcesPerSet_OF_CSI_IM_ResourceId = -1;
static gint ett_nr_rrc_CSI_MeasConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfigId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfigId = -1;
static gint ett_nr_rrc_T_aperiodicTriggerStateList = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUSCH_TriggerStateList = -1;
static gint ett_nr_rrc_CSI_ReportConfig = -1;
static gint ett_nr_rrc_T_reportConfigType = -1;
static gint ett_nr_rrc_T_periodic = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_PUCCH_CSI_Resource = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUCCH = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUSCH = -1;
static gint ett_nr_rrc_T_reportSlotOffsetList = -1;
static gint ett_nr_rrc_T_aperiodic = -1;
static gint ett_nr_rrc_T_reportSlotOffsetList_01 = -1;
static gint ett_nr_rrc_T_reportQuantity = -1;
static gint ett_nr_rrc_T_cri_RI_i1_CQI = -1;
static gint ett_nr_rrc_T_reportFreqConfiguration = -1;
static gint ett_nr_rrc_T_csi_ReportingBand = -1;
static gint ett_nr_rrc_T_groupBasedBeamReporting = -1;
static gint ett_nr_rrc_T_disabled = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerConfig_OF_PortIndexFor8Ranks = -1;
static gint ett_nr_rrc_T_semiPersistentOnPUSCH_v1530 = -1;
static gint ett_nr_rrc_CSI_ReportPeriodicityAndOffset = -1;
static gint ett_nr_rrc_PUCCH_CSI_Resource = -1;
static gint ett_nr_rrc_PortIndexFor8Ranks = -1;
static gint ett_nr_rrc_T_portIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_3_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_4_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_5_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_6_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_7_OF_PortIndex8 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_8_OF_PortIndex8 = -1;
static gint ett_nr_rrc_T_portIndex4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_OF_PortIndex4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_3_OF_PortIndex4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_4_OF_PortIndex4 = -1;
static gint ett_nr_rrc_T_portIndex2 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_2_OF_PortIndex2 = -1;
static gint ett_nr_rrc_CSI_ResourceConfig = -1;
static gint ett_nr_rrc_T_csi_RS_ResourceSetList = -1;
static gint ett_nr_rrc_T_nzp_CSI_RS_SSB = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig_OF_NZP_CSI_RS_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSetsPerConfig_OF_CSI_SSB_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSetsPerConfig_OF_CSI_IM_ResourceSetId = -1;
static gint ett_nr_rrc_CSI_ResourcePeriodicityAndOffset = -1;
static gint ett_nr_rrc_CSI_RS_ResourceConfigMobility = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility = -1;
static gint ett_nr_rrc_CSI_RS_CellMobility = -1;
static gint ett_nr_rrc_T_csi_rs_MeasurementBW = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility = -1;
static gint ett_nr_rrc_CSI_RS_Resource_Mobility = -1;
static gint ett_nr_rrc_T_slotConfig = -1;
static gint ett_nr_rrc_T_associatedSSB = -1;
static gint ett_nr_rrc_T_frequencyDomainAllocation = -1;
static gint ett_nr_rrc_CSI_RS_ResourceMapping = -1;
static gint ett_nr_rrc_T_frequencyDomainAllocation_01 = -1;
static gint ett_nr_rrc_T_density_01 = -1;
static gint ett_nr_rrc_CSI_SemiPersistentOnPUSCH_TriggerStateList = -1;
static gint ett_nr_rrc_CSI_SemiPersistentOnPUSCH_TriggerState = -1;
static gint ett_nr_rrc_CSI_SSB_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourcePerSet_OF_SSB_Index = -1;
static gint ett_nr_rrc_DMRS_DownlinkConfig = -1;
static gint ett_nr_rrc_T_phaseTrackingRS = -1;
static gint ett_nr_rrc_DMRS_UplinkConfig = -1;
static gint ett_nr_rrc_T_phaseTrackingRS_01 = -1;
static gint ett_nr_rrc_T_transformPrecodingDisabled = -1;
static gint ett_nr_rrc_T_transformPrecodingEnabled = -1;
static gint ett_nr_rrc_DownlinkConfigCommon = -1;
static gint ett_nr_rrc_DownlinkConfigCommonSIB = -1;
static gint ett_nr_rrc_BCCH_Config = -1;
static gint ett_nr_rrc_PCCH_Config = -1;
static gint ett_nr_rrc_T_nAndPagingFrameOffset = -1;
static gint ett_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO = -1;
static gint ett_nr_rrc_T_sCS15KHZoneT = -1;
static gint ett_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT = -1;
static gint ett_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT = -1;
static gint ett_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT = -1;
static gint ett_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT = -1;
static gint ett_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT = -1;
static gint ett_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT = -1;
static gint ett_nr_rrc_T_sCS120KHZoneSixteenthT = -1;
static gint ett_nr_rrc_DownlinkPreemption = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_INT_ConfigurationPerServingCell = -1;
static gint ett_nr_rrc_INT_ConfigurationPerServingCell = -1;
static gint ett_nr_rrc_DRX_Config = -1;
static gint ett_nr_rrc_T_drx_onDurationTimer = -1;
static gint ett_nr_rrc_T_drx_LongCycleStartOffset_01 = -1;
static gint ett_nr_rrc_T_shortDRX_01 = -1;
static gint ett_nr_rrc_FrequencyInfoDL = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier = -1;
static gint ett_nr_rrc_FrequencyInfoDL_SIB = -1;
static gint ett_nr_rrc_FrequencyInfoUL = -1;
static gint ett_nr_rrc_FrequencyInfoUL_SIB = -1;
static gint ett_nr_rrc_LocationMeasurementInfo = -1;
static gint ett_nr_rrc_EUTRA_RSTD_InfoList = -1;
static gint ett_nr_rrc_EUTRA_RSTD_Info = -1;
static gint ett_nr_rrc_LogicalChannelConfig = -1;
static gint ett_nr_rrc_T_ul_SpecificParameters = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ServCellIndex = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SubcarrierSpacing = -1;
static gint ett_nr_rrc_MAC_CellGroupConfig = -1;
static gint ett_nr_rrc_T_drx_Config = -1;
static gint ett_nr_rrc_T_phr_Config = -1;
static gint ett_nr_rrc_T_dataInactivityTimer = -1;
static gint ett_nr_rrc_MeasConfig = -1;
static gint ett_nr_rrc_T_s_MeasureConfig = -1;
static gint ett_nr_rrc_MeasObjectToRemoveList = -1;
static gint ett_nr_rrc_MeasIdToRemoveList = -1;
static gint ett_nr_rrc_ReportConfigToRemoveList = -1;
static gint ett_nr_rrc_MeasGapConfig = -1;
static gint ett_nr_rrc_T_gapFR2 = -1;
static gint ett_nr_rrc_T_gapFR1 = -1;
static gint ett_nr_rrc_T_gapUE = -1;
static gint ett_nr_rrc_GapConfig = -1;
static gint ett_nr_rrc_MeasGapSharingConfig = -1;
static gint ett_nr_rrc_T_gapSharingFR2 = -1;
static gint ett_nr_rrc_T_gapSharingFR1 = -1;
static gint ett_nr_rrc_T_gapSharingUE = -1;
static gint ett_nr_rrc_MeasIdToAddModList = -1;
static gint ett_nr_rrc_MeasIdToAddMod = -1;
static gint ett_nr_rrc_MeasObjectEUTRA = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell = -1;
static gint ett_nr_rrc_EUTRA_CellIndexList = -1;
static gint ett_nr_rrc_EUTRA_Cell = -1;
static gint ett_nr_rrc_EUTRA_BlackCell = -1;
static gint ett_nr_rrc_MeasObjectNR = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement = -1;
static gint ett_nr_rrc_ReferenceSignalConfig = -1;
static gint ett_nr_rrc_T_csi_rs_ResourceConfigMobility = -1;
static gint ett_nr_rrc_SSB_ConfigMobility = -1;
static gint ett_nr_rrc_T_ssb_ToMeasure = -1;
static gint ett_nr_rrc_Q_OffsetRangeList = -1;
static gint ett_nr_rrc_ThresholdNR = -1;
static gint ett_nr_rrc_CellsToAddModList = -1;
static gint ett_nr_rrc_CellsToAddMod = -1;
static gint ett_nr_rrc_MeasObjectToAddModList = -1;
static gint ett_nr_rrc_MeasObjectToAddMod = -1;
static gint ett_nr_rrc_T_measObject = -1;
static gint ett_nr_rrc_MeasResultCellListSFTD_NR = -1;
static gint ett_nr_rrc_MeasResultCellSFTD_NR = -1;
static gint ett_nr_rrc_MeasResultCellListSFTD_EUTRA = -1;
static gint ett_nr_rrc_MeasResultSFTD_EUTRA = -1;
static gint ett_nr_rrc_MeasResults = -1;
static gint ett_nr_rrc_T_measResultNeighCells = -1;
static gint ett_nr_rrc_MeasResultServMOList = -1;
static gint ett_nr_rrc_MeasResultServMO = -1;
static gint ett_nr_rrc_MeasResultListNR = -1;
static gint ett_nr_rrc_MeasResultNR = -1;
static gint ett_nr_rrc_T_measResult = -1;
static gint ett_nr_rrc_T_cellResults = -1;
static gint ett_nr_rrc_T_rsIndexResults = -1;
static gint ett_nr_rrc_MeasResultListEUTRA = -1;
static gint ett_nr_rrc_MeasResultEUTRA = -1;
static gint ett_nr_rrc_MultiBandInfoListEUTRA = -1;
static gint ett_nr_rrc_MeasQuantityResults = -1;
static gint ett_nr_rrc_MeasQuantityResultsEUTRA = -1;
static gint ett_nr_rrc_ResultsPerSSB_IndexList = -1;
static gint ett_nr_rrc_ResultsPerSSB_Index = -1;
static gint ett_nr_rrc_ResultsPerCSI_RS_IndexList = -1;
static gint ett_nr_rrc_ResultsPerCSI_RS_Index = -1;
static gint ett_nr_rrc_MeasResultServFreqListEUTRA_SCG = -1;
static gint ett_nr_rrc_MeasResultServFreqListNR_SCG = -1;
static gint ett_nr_rrc_MeasResult2EUTRA = -1;
static gint ett_nr_rrc_MeasResult2NR = -1;
static gint ett_nr_rrc_MeasResultSCG_Failure = -1;
static gint ett_nr_rrc_MeasResultList2NR = -1;
static gint ett_nr_rrc_MeasTriggerQuantityEUTRA = -1;
static gint ett_nr_rrc_MobilityStateParameters = -1;
static gint ett_nr_rrc_MultiFrequencyBandListNR = -1;
static gint ett_nr_rrc_MultiFrequencyBandListNR_SIB = -1;
static gint ett_nr_rrc_NR_MultiBandInfo = -1;
static gint ett_nr_rrc_NR_NS_PmaxList = -1;
static gint ett_nr_rrc_NR_NS_PmaxValue = -1;
static gint ett_nr_rrc_NZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_NZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerSet_OF_NZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_PCI_List = -1;
static gint ett_nr_rrc_PCI_Range = -1;
static gint ett_nr_rrc_PCI_RangeElement = -1;
static gint ett_nr_rrc_PCI_RangeIndexList = -1;
static gint ett_nr_rrc_PDCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_3_OF_ControlResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_3_OF_ControlResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_10_OF_SearchSpace = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_10_OF_SearchSpaceId = -1;
static gint ett_nr_rrc_T_downlinkPreemption = -1;
static gint ett_nr_rrc_T_tpc_PUSCH = -1;
static gint ett_nr_rrc_T_tpc_PUCCH = -1;
static gint ett_nr_rrc_T_tpc_SRS = -1;
static gint ett_nr_rrc_PDCCH_ConfigCommon = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_SearchSpace = -1;
static gint ett_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO_01 = -1;
static gint ett_nr_rrc_T_sCS15KHZoneT_01 = -1;
static gint ett_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT_01 = -1;
static gint ett_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_T_sCS120KHZoneSixteenthT_01 = -1;
static gint ett_nr_rrc_PDCCH_ConfigSIB1 = -1;
static gint ett_nr_rrc_PDCCH_ServingCellConfig = -1;
static gint ett_nr_rrc_T_slotFormatIndicator = -1;
static gint ett_nr_rrc_PDCP_Config = -1;
static gint ett_nr_rrc_T_drb = -1;
static gint ett_nr_rrc_T_headerCompression = -1;
static gint ett_nr_rrc_T_rohc = -1;
static gint ett_nr_rrc_T_profiles = -1;
static gint ett_nr_rrc_T_uplinkOnlyROHC = -1;
static gint ett_nr_rrc_T_profiles_01 = -1;
static gint ett_nr_rrc_T_moreThanOneRLC = -1;
static gint ett_nr_rrc_T_primaryPath = -1;
static gint ett_nr_rrc_PDSCH_Config = -1;
static gint ett_nr_rrc_T_dmrs_DownlinkForPDSCH_MappingTypeA = -1;
static gint ett_nr_rrc_T_dmrs_DownlinkForPDSCH_MappingTypeB = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_State = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_StateId = -1;
static gint ett_nr_rrc_T_pdsch_TimeDomainAllocationList = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPattern = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPatternId = -1;
static gint ett_nr_rrc_T_prb_BundlingType = -1;
static gint ett_nr_rrc_T_staticBundling = -1;
static gint ett_nr_rrc_T_dynamicBundling = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId = -1;
static gint ett_nr_rrc_T_p_ZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_RateMatchPatternGroup = -1;
static gint ett_nr_rrc_RateMatchPatternGroup_item = -1;
static gint ett_nr_rrc_PDSCH_ConfigCommon = -1;
static gint ett_nr_rrc_PDSCH_ServingCellConfig = -1;
static gint ett_nr_rrc_T_codeBlockGroupTransmission = -1;
static gint ett_nr_rrc_PDSCH_CodeBlockGroupTransmission = -1;
static gint ett_nr_rrc_PDSCH_TimeDomainResourceAllocationList = -1;
static gint ett_nr_rrc_PDSCH_TimeDomainResourceAllocation = -1;
static gint ett_nr_rrc_PHR_Config = -1;
static gint ett_nr_rrc_PhysicalCellGroupConfig = -1;
static gint ett_nr_rrc_T_cs_RNTI = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetection = -1;
static gint ett_nr_rrc_PLMN_Identity = -1;
static gint ett_nr_rrc_MCC = -1;
static gint ett_nr_rrc_MNC = -1;
static gint ett_nr_rrc_PLMN_IdentityInfoList = -1;
static gint ett_nr_rrc_PLMN_IdentityInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity = -1;
static gint ett_nr_rrc_PTRS_DownlinkConfig = -1;
static gint ett_nr_rrc_T_frequencyDensity = -1;
static gint ett_nr_rrc_T_timeDensity = -1;
static gint ett_nr_rrc_PTRS_UplinkConfig = -1;
static gint ett_nr_rrc_T_transformPrecoderDisabled = -1;
static gint ett_nr_rrc_T_frequencyDensity_01 = -1;
static gint ett_nr_rrc_T_timeDensity_01 = -1;
static gint ett_nr_rrc_T_transformPrecoderEnabled = -1;
static gint ett_nr_rrc_T_sampleDensity = -1;
static gint ett_nr_rrc_PUCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_Resource = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceId = -1;
static gint ett_nr_rrc_T_format1 = -1;
static gint ett_nr_rrc_T_format2 = -1;
static gint ett_nr_rrc_T_format3 = -1;
static gint ett_nr_rrc_T_format4 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_2_OF_PUCCH_ResourceId = -1;
static gint ett_nr_rrc_T_dl_DataToUL_ACK = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfoId = -1;
static gint ett_nr_rrc_PUCCH_FormatConfig = -1;
static gint ett_nr_rrc_PUCCH_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerSet_OF_PUCCH_ResourceId = -1;
static gint ett_nr_rrc_PUCCH_Resource = -1;
static gint ett_nr_rrc_T_format = -1;
static gint ett_nr_rrc_PUCCH_format0 = -1;
static gint ett_nr_rrc_PUCCH_format1 = -1;
static gint ett_nr_rrc_PUCCH_format2 = -1;
static gint ett_nr_rrc_PUCCH_format3 = -1;
static gint ett_nr_rrc_PUCCH_format4 = -1;
static gint ett_nr_rrc_PUCCH_ConfigCommon = -1;
static gint ett_nr_rrc_PUCCH_PowerControl = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_P0_PerSet_OF_P0_PUCCH = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUCCH_PathlossReferenceRSs_OF_PUCCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_P0_PUCCH = -1;
static gint ett_nr_rrc_PUCCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_T_referenceSignal = -1;
static gint ett_nr_rrc_PUCCH_SpatialRelationInfo = -1;
static gint ett_nr_rrc_T_referenceSignal_01 = -1;
static gint ett_nr_rrc_T_srs = -1;
static gint ett_nr_rrc_PUCCH_TPC_CommandConfig = -1;
static gint ett_nr_rrc_PUSCH_Config = -1;
static gint ett_nr_rrc_T_dmrs_UplinkForPUSCH_MappingTypeA = -1;
static gint ett_nr_rrc_T_dmrs_UplinkForPUSCH_MappingTypeB = -1;
static gint ett_nr_rrc_T_frequencyHoppingOffsetLists = -1;
static gint ett_nr_rrc_T_pusch_TimeDomainAllocationList = -1;
static gint ett_nr_rrc_T_uci_OnPUSCH_01 = -1;
static gint ett_nr_rrc_UCI_OnPUSCH = -1;
static gint ett_nr_rrc_T_betaOffsets = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_4_OF_BetaOffsets = -1;
static gint ett_nr_rrc_PUSCH_ConfigCommon = -1;
static gint ett_nr_rrc_PUSCH_PowerControl = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofP0_PUSCH_AlphaSets_OF_P0_PUSCH_AlphaSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS_Id = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControl = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControlId = -1;
static gint ett_nr_rrc_P0_PUSCH_AlphaSet = -1;
static gint ett_nr_rrc_PUSCH_PathlossReferenceRS = -1;
static gint ett_nr_rrc_T_referenceSignal_02 = -1;
static gint ett_nr_rrc_SRI_PUSCH_PowerControl = -1;
static gint ett_nr_rrc_PUSCH_ServingCellConfig = -1;
static gint ett_nr_rrc_T_codeBlockGroupTransmission_01 = -1;
static gint ett_nr_rrc_PUSCH_CodeBlockGroupTransmission = -1;
static gint ett_nr_rrc_PUSCH_TimeDomainResourceAllocationList = -1;
static gint ett_nr_rrc_PUSCH_TimeDomainResourceAllocation = -1;
static gint ett_nr_rrc_PUSCH_TPC_CommandConfig = -1;
static gint ett_nr_rrc_QuantityConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR = -1;
static gint ett_nr_rrc_QuantityConfigNR = -1;
static gint ett_nr_rrc_QuantityConfigRS = -1;
static gint ett_nr_rrc_FilterConfig = -1;
static gint ett_nr_rrc_RACH_ConfigCommon = -1;
static gint ett_nr_rrc_T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB = -1;
static gint ett_nr_rrc_T_groupBconfigured = -1;
static gint ett_nr_rrc_T_prach_RootSequenceIndex = -1;
static gint ett_nr_rrc_RACH_ConfigDedicated = -1;
static gint ett_nr_rrc_CFRA = -1;
static gint ett_nr_rrc_T_occasions = -1;
static gint ett_nr_rrc_T_resources = -1;
static gint ett_nr_rrc_T_ssb = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxRA_SSB_Resources_OF_CFRA_SSB_Resource = -1;
static gint ett_nr_rrc_T_csirs = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxRA_CSIRS_Resources_OF_CFRA_CSIRS_Resource = -1;
static gint ett_nr_rrc_CFRA_SSB_Resource = -1;
static gint ett_nr_rrc_CFRA_CSIRS_Resource = -1;
static gint ett_nr_rrc_T_ra_OccasionList_01 = -1;
static gint ett_nr_rrc_RACH_ConfigGeneric = -1;
static gint ett_nr_rrc_RA_Prioritization = -1;
static gint ett_nr_rrc_RadioBearerConfig = -1;
static gint ett_nr_rrc_SRB_ToAddModList = -1;
static gint ett_nr_rrc_SRB_ToAddMod = -1;
static gint ett_nr_rrc_DRB_ToAddModList = -1;
static gint ett_nr_rrc_DRB_ToAddMod = -1;
static gint ett_nr_rrc_T_cnAssociation = -1;
static gint ett_nr_rrc_DRB_ToReleaseList = -1;
static gint ett_nr_rrc_SecurityConfig = -1;
static gint ett_nr_rrc_RadioLinkMonitoringConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS_Id = -1;
static gint ett_nr_rrc_RadioLinkMonitoringRS = -1;
static gint ett_nr_rrc_T_detectionResource = -1;
static gint ett_nr_rrc_RateMatchPattern = -1;
static gint ett_nr_rrc_T_patternType = -1;
static gint ett_nr_rrc_T_bitmaps = -1;
static gint ett_nr_rrc_T_symbolsInResourceBlock = -1;
static gint ett_nr_rrc_T_periodicityAndPattern = -1;
static gint ett_nr_rrc_RateMatchPatternLTE_CRS = -1;
static gint ett_nr_rrc_ReportConfigInterRAT = -1;
static gint ett_nr_rrc_T_reportType = -1;
static gint ett_nr_rrc_ReportCGI_EUTRA = -1;
static gint ett_nr_rrc_ReportSFTD_EUTRA = -1;
static gint ett_nr_rrc_EventTriggerConfigInterRAT = -1;
static gint ett_nr_rrc_T_eventId = -1;
static gint ett_nr_rrc_T_eventB1 = -1;
static gint ett_nr_rrc_T_eventB2 = -1;
static gint ett_nr_rrc_PeriodicalReportConfigInterRAT = -1;
static gint ett_nr_rrc_ReportConfigNR = -1;
static gint ett_nr_rrc_T_reportType_01 = -1;
static gint ett_nr_rrc_ReportCGI = -1;
static gint ett_nr_rrc_ReportSFTD_NR = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId = -1;
static gint ett_nr_rrc_EventTriggerConfig = -1;
static gint ett_nr_rrc_T_eventId_01 = -1;
static gint ett_nr_rrc_T_eventA1 = -1;
static gint ett_nr_rrc_T_eventA2 = -1;
static gint ett_nr_rrc_T_eventA3 = -1;
static gint ett_nr_rrc_T_eventA4 = -1;
static gint ett_nr_rrc_T_eventA5 = -1;
static gint ett_nr_rrc_T_eventA6 = -1;
static gint ett_nr_rrc_PeriodicalReportConfig = -1;
static gint ett_nr_rrc_MeasTriggerQuantity = -1;
static gint ett_nr_rrc_MeasTriggerQuantityOffset = -1;
static gint ett_nr_rrc_MeasReportQuantity = -1;
static gint ett_nr_rrc_ReportConfigToAddModList = -1;
static gint ett_nr_rrc_ReportConfigToAddMod = -1;
static gint ett_nr_rrc_T_reportConfig = -1;
static gint ett_nr_rrc_RLC_BearerConfig = -1;
static gint ett_nr_rrc_T_servedRadioBearer = -1;
static gint ett_nr_rrc_RLC_Config = -1;
static gint ett_nr_rrc_T_am = -1;
static gint ett_nr_rrc_T_um_Bi_Directional = -1;
static gint ett_nr_rrc_T_um_Uni_Directional_UL = -1;
static gint ett_nr_rrc_T_um_Uni_Directional_DL = -1;
static gint ett_nr_rrc_UL_AM_RLC = -1;
static gint ett_nr_rrc_DL_AM_RLC = -1;
static gint ett_nr_rrc_UL_UM_RLC = -1;
static gint ett_nr_rrc_DL_UM_RLC = -1;
static gint ett_nr_rrc_RLF_TimersAndConstants = -1;
static gint ett_nr_rrc_SchedulingRequestConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestToAddMod = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestId = -1;
static gint ett_nr_rrc_SchedulingRequestToAddMod = -1;
static gint ett_nr_rrc_SchedulingRequestResourceConfig = -1;
static gint ett_nr_rrc_T_periodicityAndOffset = -1;
static gint ett_nr_rrc_SCS_SpecificCarrier = -1;
static gint ett_nr_rrc_SDAP_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI = -1;
static gint ett_nr_rrc_SearchSpace = -1;
static gint ett_nr_rrc_T_monitoringSlotPeriodicityAndOffset = -1;
static gint ett_nr_rrc_T_nrofCandidates = -1;
static gint ett_nr_rrc_T_searchSpaceType = -1;
static gint ett_nr_rrc_T_common = -1;
static gint ett_nr_rrc_T_dci_Format0_0_AndFormat1_0 = -1;
static gint ett_nr_rrc_T_dci_Format2_0 = -1;
static gint ett_nr_rrc_T_nrofCandidates_SFI = -1;
static gint ett_nr_rrc_T_dci_Format2_1 = -1;
static gint ett_nr_rrc_T_dci_Format2_2 = -1;
static gint ett_nr_rrc_T_dci_Format2_3 = -1;
static gint ett_nr_rrc_T_ue_Specific = -1;
static gint ett_nr_rrc_SecurityAlgorithmConfig = -1;
static gint ett_nr_rrc_ServingCellConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Downlink = -1;
static gint ett_nr_rrc_T_pdcch_ServingCellConfig = -1;
static gint ett_nr_rrc_T_pdsch_ServingCellConfig = -1;
static gint ett_nr_rrc_T_csi_MeasConfig = -1;
static gint ett_nr_rrc_T_lte_CRS_ToMatchAround = -1;
static gint ett_nr_rrc_UplinkConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Uplink = -1;
static gint ett_nr_rrc_T_pusch_ServingCellConfig = -1;
static gint ett_nr_rrc_T_carrierSwitching = -1;
static gint ett_nr_rrc_ServingCellConfigCommon = -1;
static gint ett_nr_rrc_T_ssb_PositionsInBurst = -1;
static gint ett_nr_rrc_T_lte_CRS_ToMatchAround_01 = -1;
static gint ett_nr_rrc_ServingCellConfigCommonSIB = -1;
static gint ett_nr_rrc_T_ssb_PositionsInBurst_01 = -1;
static gint ett_nr_rrc_SI_SchedulingInfo = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo = -1;
static gint ett_nr_rrc_SchedulingInfo = -1;
static gint ett_nr_rrc_SIB_Mapping = -1;
static gint ett_nr_rrc_SIB_TypeInfo = -1;
static gint ett_nr_rrc_SI_RequestConfig = -1;
static gint ett_nr_rrc_T_rach_OccasionsSI = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources = -1;
static gint ett_nr_rrc_SI_RequestResources = -1;
static gint ett_nr_rrc_SlotFormatCombinationsPerCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSlotFormatCombinationsPerSet_OF_SlotFormatCombination = -1;
static gint ett_nr_rrc_SlotFormatCombination = -1;
static gint ett_nr_rrc_T_slotFormats = -1;
static gint ett_nr_rrc_SlotFormatIndicator = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_SlotFormatCombinationsPerCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex = -1;
static gint ett_nr_rrc_S_NSSAI = -1;
static gint ett_nr_rrc_SpeedStateScaleFactors = -1;
static gint ett_nr_rrc_SPS_Config = -1;
static gint ett_nr_rrc_SRS_CarrierSwitching = -1;
static gint ett_nr_rrc_T_srs_TPC_PDCCH_Group = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_ServCellIndex = -1;
static gint ett_nr_rrc_SRS_TPC_PDCCH_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex = -1;
static gint ett_nr_rrc_SRS_CC_SetIndex = -1;
static gint ett_nr_rrc_SRS_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSetId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_ResourceId = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_Resource = -1;
static gint ett_nr_rrc_SRS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_ResourceId = -1;
static gint ett_nr_rrc_T_resourceType_01 = -1;
static gint ett_nr_rrc_T_aperiodic_01 = -1;
static gint ett_nr_rrc_T_aperiodicSRS_ResourceTriggerList_v1530 = -1;
static gint ett_nr_rrc_T_semi_persistent = -1;
static gint ett_nr_rrc_T_periodic_01 = -1;
static gint ett_nr_rrc_T_pathlossReferenceRS = -1;
static gint ett_nr_rrc_SRS_Resource = -1;
static gint ett_nr_rrc_T_transmissionComb = -1;
static gint ett_nr_rrc_T_n2 = -1;
static gint ett_nr_rrc_T_n4 = -1;
static gint ett_nr_rrc_T_resourceMapping = -1;
static gint ett_nr_rrc_T_freqHopping = -1;
static gint ett_nr_rrc_T_resourceType_02 = -1;
static gint ett_nr_rrc_T_aperiodic_02 = -1;
static gint ett_nr_rrc_T_semi_persistent_01 = -1;
static gint ett_nr_rrc_T_periodic_02 = -1;
static gint ett_nr_rrc_SRS_SpatialRelationInfo = -1;
static gint ett_nr_rrc_T_referenceSignal_03 = -1;
static gint ett_nr_rrc_T_srs_01 = -1;
static gint ett_nr_rrc_SRS_PeriodicityAndOffset = -1;
static gint ett_nr_rrc_SRS_TPC_CommandConfig = -1;
static gint ett_nr_rrc_SSB_MTC = -1;
static gint ett_nr_rrc_T_periodicityAndOffset_01 = -1;
static gint ett_nr_rrc_SSB_MTC2 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId = -1;
static gint ett_nr_rrc_SSB_ToMeasure = -1;
static gint ett_nr_rrc_SS_RSSI_Measurement = -1;
static gint ett_nr_rrc_TAG_Config = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG_Id = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG = -1;
static gint ett_nr_rrc_TAG = -1;
static gint ett_nr_rrc_TCI_State = -1;
static gint ett_nr_rrc_QCL_Info = -1;
static gint ett_nr_rrc_T_referenceSignal_04 = -1;
static gint ett_nr_rrc_TDD_UL_DL_ConfigCommon = -1;
static gint ett_nr_rrc_TDD_UL_DL_Pattern = -1;
static gint ett_nr_rrc_TDD_UL_DL_ConfigDedicated = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotIndex = -1;
static gint ett_nr_rrc_TDD_UL_DL_SlotConfig = -1;
static gint ett_nr_rrc_T_symbols = -1;
static gint ett_nr_rrc_T_explicit = -1;
static gint ett_nr_rrc_UAC_BarringInfoSetList = -1;
static gint ett_nr_rrc_UAC_BarringInfoSet = -1;
static gint ett_nr_rrc_UAC_BarringPerCatList = -1;
static gint ett_nr_rrc_UAC_BarringPerCat = -1;
static gint ett_nr_rrc_UAC_BarringPerPLMN_List = -1;
static gint ett_nr_rrc_UAC_BarringPerPLMN = -1;
static gint ett_nr_rrc_T_uac_ACBarringListType = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex = -1;
static gint ett_nr_rrc_UE_TimersAndConstants = -1;
static gint ett_nr_rrc_UplinkConfigCommon = -1;
static gint ett_nr_rrc_UplinkConfigCommonSIB = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentList = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentCell = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP = -1;
static gint ett_nr_rrc_UplinkTxDirectCurrentBWP = -1;
static gint ett_nr_rrc_ZP_CSI_RS_Resource = -1;
static gint ett_nr_rrc_ZP_CSI_RS_ResourceSet = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourcesPerSet_OF_ZP_CSI_RS_ResourceId = -1;
static gint ett_nr_rrc_BandCombinationList = -1;
static gint ett_nr_rrc_BandCombinationList_v1540 = -1;
static gint ett_nr_rrc_BandCombinationList_v1550 = -1;
static gint ett_nr_rrc_BandCombinationList_v1560 = -1;
static gint ett_nr_rrc_BandCombinationList_v1570 = -1;
static gint ett_nr_rrc_BandCombination = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters = -1;
static gint ett_nr_rrc_BandCombination_v1540 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1540 = -1;
static gint ett_nr_rrc_BandCombination_v1550 = -1;
static gint ett_nr_rrc_BandCombination_v1560 = -1;
static gint ett_nr_rrc_BandCombination_v1570 = -1;
static gint ett_nr_rrc_BandParameters = -1;
static gint ett_nr_rrc_T_eutra = -1;
static gint ett_nr_rrc_T_nr = -1;
static gint ett_nr_rrc_BandParameters_v1540 = -1;
static gint ett_nr_rrc_T_srs_CarrierSwitch = -1;
static gint ett_nr_rrc_T_nr_01 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeNR = -1;
static gint ett_nr_rrc_T_eutra_01 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeEUTRA = -1;
static gint ett_nr_rrc_T_srs_TxSwitch = -1;
static gint ett_nr_rrc_CA_ParametersEUTRA = -1;
static gint ett_nr_rrc_CA_ParametersEUTRA_v1560 = -1;
static gint ett_nr_rrc_CA_ParametersEUTRA_v1570 = -1;
static gint ett_nr_rrc_CA_ParametersNR = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1540 = -1;
static gint ett_nr_rrc_T_csi_RS_IM_ReceptionForFeedbackPerBandComb = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1550 = -1;
static gint ett_nr_rrc_CA_ParametersNR_v1560 = -1;
static gint ett_nr_rrc_CA_ParametersNRDC = -1;
static gint ett_nr_rrc_CodebookParameters = -1;
static gint ett_nr_rrc_T_type1_02 = -1;
static gint ett_nr_rrc_T_singlePanel = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource = -1;
static gint ett_nr_rrc_T_multiPanel = -1;
static gint ett_nr_rrc_T_type2_01 = -1;
static gint ett_nr_rrc_T_type2_PortSelection = -1;
static gint ett_nr_rrc_SupportedCSI_RS_Resource = -1;
static gint ett_nr_rrc_FeatureSetCombination = -1;
static gint ett_nr_rrc_FeatureSetsPerBand = -1;
static gint ett_nr_rrc_FeatureSet = -1;
static gint ett_nr_rrc_T_eutra_02 = -1;
static gint ett_nr_rrc_T_nr_02 = -1;
static gint ett_nr_rrc_FeatureSetDownlink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetDownlinkPerCC_Id = -1;
static gint ett_nr_rrc_T_timeDurationForQCL = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType1_DifferentTB_PerSlot = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyB = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyD = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyE = -1;
static gint ett_nr_rrc_FeatureSetDownlink_v1540 = -1;
static gint ett_nr_rrc_T_pdcch_MonitoringAnyOccasionsWithSpanGap = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType2 = -1;
static gint ett_nr_rrc_T_pdsch_ProcessingType2_Limited = -1;
static gint ett_nr_rrc_DummyA = -1;
static gint ett_nr_rrc_DummyB = -1;
static gint ett_nr_rrc_DummyC = -1;
static gint ett_nr_rrc_DummyD = -1;
static gint ett_nr_rrc_DummyE = -1;
static gint ett_nr_rrc_FeatureSetDownlinkPerCC = -1;
static gint ett_nr_rrc_FeatureSets = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1540 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1540 = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1540 = -1;
static gint ett_nr_rrc_FeatureSetUplink = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetUplinkPerCC_Id = -1;
static gint ett_nr_rrc_T_pusch_ProcessingType1_DifferentTB_PerSlot = -1;
static gint ett_nr_rrc_FeatureSetUplink_v1540 = -1;
static gint ett_nr_rrc_T_pusch_ProcessingType2 = -1;
static gint ett_nr_rrc_SRS_Resources = -1;
static gint ett_nr_rrc_DummyF = -1;
static gint ett_nr_rrc_FeatureSetUplinkPerCC = -1;
static gint ett_nr_rrc_T_mimo_CB_PUSCH = -1;
static gint ett_nr_rrc_FeatureSetUplinkPerCC_v1540 = -1;
static gint ett_nr_rrc_T_mimo_NonCB_PUSCH = -1;
static gint ett_nr_rrc_FreqBandList = -1;
static gint ett_nr_rrc_FreqBandInformation = -1;
static gint ett_nr_rrc_FreqBandInformationEUTRA = -1;
static gint ett_nr_rrc_FreqBandInformationNR = -1;
static gint ett_nr_rrc_IMS_Parameters = -1;
static gint ett_nr_rrc_IMS_ParametersCommon = -1;
static gint ett_nr_rrc_IMS_ParametersFRX_Diff = -1;
static gint ett_nr_rrc_InterRAT_Parameters = -1;
static gint ett_nr_rrc_EUTRA_Parameters = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBandsEUTRA_OF_FreqBandIndicatorEUTRA = -1;
static gint ett_nr_rrc_EUTRA_ParametersCommon = -1;
static gint ett_nr_rrc_EUTRA_ParametersXDD_Diff = -1;
static gint ett_nr_rrc_MAC_Parameters = -1;
static gint ett_nr_rrc_MAC_ParametersCommon = -1;
static gint ett_nr_rrc_MAC_ParametersXDD_Diff = -1;
static gint ett_nr_rrc_MeasAndMobParameters = -1;
static gint ett_nr_rrc_MeasAndMobParametersCommon = -1;
static gint ett_nr_rrc_MeasAndMobParametersXDD_Diff = -1;
static gint ett_nr_rrc_MeasAndMobParametersFRX_Diff = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_v1560 = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_Common = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_XDD_Diff = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_XDD_Diff_v1560 = -1;
static gint ett_nr_rrc_MeasAndMobParametersMRDC_FRX_Diff = -1;
static gint ett_nr_rrc_MIMO_ParametersPerBand = -1;
static gint ett_nr_rrc_T_tci_StatePDSCH = -1;
static gint ett_nr_rrc_T_maxNumberRxTxBeamSwitchDL = -1;
static gint ett_nr_rrc_T_uplinkBeamManagement = -1;
static gint ett_nr_rrc_T_beamReportTiming = -1;
static gint ett_nr_rrc_T_ptrs_DensityRecommendationSetDL = -1;
static gint ett_nr_rrc_T_ptrs_DensityRecommendationSetUL = -1;
static gint ett_nr_rrc_T_beamSwitchTiming = -1;
static gint ett_nr_rrc_DummyG = -1;
static gint ett_nr_rrc_BeamManagementSSB_CSI_RS = -1;
static gint ett_nr_rrc_DummyH = -1;
static gint ett_nr_rrc_CSI_RS_ForTracking = -1;
static gint ett_nr_rrc_CSI_RS_IM_ReceptionForFeedback = -1;
static gint ett_nr_rrc_CSI_RS_ProcFrameworkForSRS = -1;
static gint ett_nr_rrc_CSI_ReportFramework = -1;
static gint ett_nr_rrc_PTRS_DensityRecommendationDL = -1;
static gint ett_nr_rrc_PTRS_DensityRecommendationUL = -1;
static gint ett_nr_rrc_SpatialRelations = -1;
static gint ett_nr_rrc_DummyI = -1;
static gint ett_nr_rrc_MRDC_Parameters = -1;
static gint ett_nr_rrc_NRDC_Parameters = -1;
static gint ett_nr_rrc_T_dummy_06 = -1;
static gint ett_nr_rrc_NRDC_Parameters_v1570 = -1;
static gint ett_nr_rrc_PDCP_Parameters = -1;
static gint ett_nr_rrc_T_supportedROHC_Profiles = -1;
static gint ett_nr_rrc_PDCP_ParametersMRDC = -1;
static gint ett_nr_rrc_Phy_Parameters = -1;
static gint ett_nr_rrc_Phy_ParametersCommon = -1;
static gint ett_nr_rrc_Phy_ParametersXDD_Diff = -1;
static gint ett_nr_rrc_Phy_ParametersFRX_Diff = -1;
static gint ett_nr_rrc_T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot = -1;
static gint ett_nr_rrc_T_pdcch_BlindDetectionNRDC = -1;
static gint ett_nr_rrc_Phy_ParametersFR1 = -1;
static gint ett_nr_rrc_Phy_ParametersFR2 = -1;
static gint ett_nr_rrc_Phy_ParametersMRDC = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofNAICS_Entries_OF_NAICS_Capability_Entry = -1;
static gint ett_nr_rrc_NAICS_Capability_Entry = -1;
static gint ett_nr_rrc_ProcessingParameters = -1;
static gint ett_nr_rrc_T_differentTB_PerSlot = -1;
static gint ett_nr_rrc_RF_Parameters = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_BandNR = -1;
static gint ett_nr_rrc_BandNR = -1;
static gint ett_nr_rrc_T_channelBWs_DL_v1530 = -1;
static gint ett_nr_rrc_T_fr1 = -1;
static gint ett_nr_rrc_T_fr2 = -1;
static gint ett_nr_rrc_T_channelBWs_UL_v1530 = -1;
static gint ett_nr_rrc_T_fr1_01 = -1;
static gint ett_nr_rrc_T_fr2_01 = -1;
static gint ett_nr_rrc_RF_ParametersMRDC = -1;
static gint ett_nr_rrc_RLC_Parameters = -1;
static gint ett_nr_rrc_SDAP_Parameters = -1;
static gint ett_nr_rrc_SRS_SwitchingTimeNR = -1;
static gint ett_nr_rrc_SRS_SwitchingTimeEUTRA = -1;
static gint ett_nr_rrc_SupportedBandwidth = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_ContainerList = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_Container = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_RequestList = -1;
static gint ett_nr_rrc_UE_CapabilityRAT_Request = -1;
static gint ett_nr_rrc_UE_CapabilityRequestFilterCommon = -1;
static gint ett_nr_rrc_T_mrdc_Request = -1;
static gint ett_nr_rrc_UE_CapabilityRequestFilterNR = -1;
static gint ett_nr_rrc_UE_CapabilityRequestFilterNR_v1540 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_37 = -1;
static gint ett_nr_rrc_UE_MRDC_Capability = -1;
static gint ett_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetCombinations_OF_FeatureSetCombination = -1;
static gint ett_nr_rrc_UE_MRDC_Capability_v1560 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_38 = -1;
static gint ett_nr_rrc_UE_MRDC_CapabilityAddXDD_Mode = -1;
static gint ett_nr_rrc_UE_MRDC_CapabilityAddXDD_Mode_v1560 = -1;
static gint ett_nr_rrc_UE_MRDC_CapabilityAddFRX_Mode = -1;
static gint ett_nr_rrc_GeneralParametersMRDC_XDD_Diff = -1;
static gint ett_nr_rrc_UE_NR_Capability = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1530 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1540 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1550 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1560 = -1;
static gint ett_nr_rrc_UE_NR_Capability_v1570 = -1;
static gint ett_nr_rrc_T_nonCriticalExtension_39 = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddXDD_Mode = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddXDD_Mode_v1530 = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddFRX_Mode = -1;
static gint ett_nr_rrc_UE_NR_CapabilityAddFRX_Mode_v1540 = -1;
static gint ett_nr_rrc_EUTRA_MBSFN_SubframeConfigList = -1;
static gint ett_nr_rrc_EUTRA_MBSFN_SubframeConfig = -1;
static gint ett_nr_rrc_T_subframeAllocation1 = -1;
static gint ett_nr_rrc_T_subframeAllocation2 = -1;
static gint ett_nr_rrc_EUTRA_MultiBandInfoList = -1;
static gint ett_nr_rrc_EUTRA_MultiBandInfo = -1;
static gint ett_nr_rrc_EUTRA_NS_PmaxList = -1;
static gint ett_nr_rrc_EUTRA_NS_PmaxValue = -1;
static gint ett_nr_rrc_EUTRA_PhysCellIdRange = -1;
static gint ett_nr_rrc_OtherConfig = -1;
static gint ett_nr_rrc_T_delayBudgetReportingConfig = -1;
static gint ett_nr_rrc_T_setup = -1;
static gint ett_nr_rrc_OtherConfig_v1540 = -1;
static gint ett_nr_rrc_T_overheatingAssistanceConfig = -1;
static gint ett_nr_rrc_OverheatingAssistanceConfig = -1;

/*--- End of included file: packet-nr-rrc-ett.c ---*/
#line 99 "./asn1/nr-rrc/packet-nr-rrc-template.c"
static gint ett_nr_rrc_DedicatedNAS_Message = -1;
static gint ett_rr_rrc_targetRAT_MessageContainer = -1;
static gint ett_nr_rrc_nas_Container = -1;
static gint ett_nr_rrc_serialNumber = -1;
static gint ett_nr_rrc_warningType = -1;
static gint ett_nr_rrc_dataCodingScheme = -1;
static gint ett_nr_rrc_sib7_fragment = -1;
static gint ett_nr_rrc_sib7_fragments = -1;
static gint ett_nr_rrc_sib8_fragment = -1;
static gint ett_nr_rrc_sib8_fragments = -1;
static gint ett_nr_rrc_warningMessageSegment = -1;
static gint ett_nr_rrc_timeInfo = -1;
static gint ett_nr_rrc_capabilityRequestFilter = -1;
static gint ett_nr_rrc_sourceSCG_EUTRA_Config = -1;
static gint ett_nr_rrc_scg_CellGroupConfigEUTRA = -1;
static gint ett_nr_rrc_candidateCellInfoListSN_EUTRA = -1;
static gint ett_nr_rrc_candidateCellInfoListMN_EUTRA = -1;
static gint ett_nr_rrc_sourceConfigSCG_EUTRA = -1;
static gint ett_nr_rrc_eutra_SCG = -1;
static gint ett_nr_rrc_nr_SCG_Response = -1;
static gint ett_nr_rrc_eutra_SCG_Response = -1;
static gint ett_nr_rrc_measResultSCG_FailureMRDC = -1;
static gint ett_nr_rrc_ul_DCCH_MessageNR = -1;
static gint ett_nr_rrc_ul_DCCH_MessageEUTRA = -1;
static gint ett_rr_rrc_nas_SecurityParamFromNR = -1;

static expert_field ei_nr_rrc_number_pages_le15 = EI_INIT;

static const unit_name_string units_periodicities = { " periodicity", " periodicities" };
static const unit_name_string units_prbs = { " PRB", " PRBs" };
static const unit_name_string units_slots = { " slot", " slots" };

typedef struct {
  guint8 rat_type;
  guint8 target_rat_type;
  guint16 message_identifier;
  guint8 warning_message_segment_type;
  guint8 warning_message_segment_number;
  nr_drb_mapping_t drb_mapping;
} nr_rrc_private_data_t;

/* Helper function to get or create a struct that will be actx->private_data */
static nr_rrc_private_data_t*
nr_rrc_get_private_data(asn1_ctx_t *actx)
{
  if (actx->private_data == NULL) {
    actx->private_data = wmem_new0(wmem_packet_scope(), nr_rrc_private_data_t);
  }
  return (nr_rrc_private_data_t*)actx->private_data;
}


static void
nr_rrc_call_dissector(dissector_handle_t handle, tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree)
{
  TRY {
    call_dissector(handle, tvb, pinfo, tree);
  }
  CATCH_BOUNDS_ERRORS {
    show_exception(tvb, pinfo, tree, EXCEPT_CODE, GET_MESSAGE);
  }
  ENDTRY;
}

static void
nr_rrc_q_RxLevMin_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  g_snprintf(s, ITEM_LABEL_LENGTH, "%d dB (%d)", 2*d, d);
}

static const value_string nr_rrc_serialNumber_gs_vals[] = {
  { 0, "Display mode immediate, cell wide"},
  { 1, "Display mode normal, PLMN wide"},
  { 2, "Display mode normal, tracking area wide"},
  { 3, "Display mode normal, cell wide"},
  { 0, NULL},
};

static const value_string nr_rrc_warningType_vals[] = {
  { 0, "Earthquake"},
  { 1, "Tsunami"},
  { 2, "Earthquake and Tsunami"},
  { 3, "Test"},
  { 4, "Other"},
  { 0, NULL},
};

static const fragment_items nr_rrc_sib7_frag_items = {
    &ett_nr_rrc_sib7_fragment,
    &ett_nr_rrc_sib7_fragments,
    &hf_nr_rrc_sib7_fragments,
    &hf_nr_rrc_sib7_fragment,
    &hf_nr_rrc_sib7_fragment_overlap,
    &hf_nr_rrc_sib7_fragment_overlap_conflict,
    &hf_nr_rrc_sib7_fragment_multiple_tails,
    &hf_nr_rrc_sib7_fragment_too_long_fragment,
    &hf_nr_rrc_sib7_fragment_error,
    &hf_nr_rrc_sib7_fragment_count,
    &hf_nr_rrc_sib7_reassembled_in,
    &hf_nr_rrc_sib7_reassembled_length,
    &hf_nr_rrc_sib7_reassembled_data,
    "SIB7 warning message segments"
};

static const fragment_items nr_rrc_sib8_frag_items = {
    &ett_nr_rrc_sib8_fragment,
    &ett_nr_rrc_sib8_fragments,
    &hf_nr_rrc_sib8_fragments,
    &hf_nr_rrc_sib8_fragment,
    &hf_nr_rrc_sib8_fragment_overlap,
    &hf_nr_rrc_sib8_fragment_overlap_conflict,
    &hf_nr_rrc_sib8_fragment_multiple_tails,
    &hf_nr_rrc_sib8_fragment_too_long_fragment,
    &hf_nr_rrc_sib8_fragment_error,
    &hf_nr_rrc_sib8_fragment_count,
    &hf_nr_rrc_sib8_reassembled_in,
    &hf_nr_rrc_sib8_reassembled_length,
    &hf_nr_rrc_sib8_reassembled_data,
    "SIB8 warning message segments"
};

static void
dissect_nr_rrc_warningMessageSegment(tvbuff_t *warning_msg_seg_tvb, proto_tree *tree, packet_info *pinfo, guint8 dataCodingScheme)
{
  guint32 offset;
  guint8 nb_of_pages, length, *str;
  proto_item *ti;
  tvbuff_t *cb_data_page_tvb, *cb_data_tvb;
  int i;

  nb_of_pages = tvb_get_guint8(warning_msg_seg_tvb, 0);
  ti = proto_tree_add_uint(tree, hf_nr_rrc_warningMessageSegment_nb_pages, warning_msg_seg_tvb, 0, 1, nb_of_pages);
  if (nb_of_pages > 15) {
    expert_add_info_format(pinfo, ti, &ei_nr_rrc_number_pages_le15,
                           "Number of pages should be <=15 (found %u)", nb_of_pages);
    nb_of_pages = 15;
  }
  for (i = 0, offset = 1; i < nb_of_pages; i++) {
    length = tvb_get_guint8(warning_msg_seg_tvb, offset+82);
    cb_data_page_tvb = tvb_new_subset_length(warning_msg_seg_tvb, offset, length);
    cb_data_tvb = dissect_cbs_data(dataCodingScheme, cb_data_page_tvb, tree, pinfo, 0);
    if (cb_data_tvb) {
      str = tvb_get_string_enc(wmem_packet_scope(), cb_data_tvb, 0, tvb_reported_length(cb_data_tvb), ENC_UTF_8|ENC_NA);
      proto_tree_add_string_format(tree, hf_nr_rrc_warningMessageSegment_decoded_page, warning_msg_seg_tvb, offset, 83,
                                   str, "Decoded Page %u: %s", i+1, str);
    }
    offset += 83;
  }
}

static const value_string nr_rrc_daylightSavingTime_vals[] = {
  { 0, "No adjustment for Daylight Saving Time"},
  { 1, "+1 hour adjustment for Daylight Saving Time"},
  { 2, "+2 hours adjustment for Daylight Saving Time"},
  { 3, "Reserved"},
  { 0, NULL},
};

static void
nr_rrc_localTimeOffset_fmt(gchar *s, guint32 v)
{
  gint32 time_offset = (gint32) v;

  g_snprintf(s, ITEM_LABEL_LENGTH, "UTC time %c %dhr %dmin (%d)",
             (time_offset < 0) ? '-':'+', abs(time_offset) >> 2,
             (abs(time_offset) & 0x03) * 15, time_offset);
}

static void
nr_rrc_drx_SlotOffset_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%g ms (%u)", 1./32 * v, v);
}

static void
nr_rrc_Hysteresis_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%gdB (%u)", 0.5 * v, v);
}

static void
nr_rrc_msg3_DeltaPreamble_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  g_snprintf(s, ITEM_LABEL_LENGTH, "%ddB (%d)", 2 * d, d);
}

static void
nr_rrc_Q_RxLevMin_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%d)", 2 * d, d);
}

static void
nr_rrc_RSRP_RangeEUTRA_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "RSRP < -140dBm (0)");
  } else if (v < 97) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSRP < %ddBm (%u)", v-141, v-140, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= RSRP (97)");
  }
}

static void
nr_rrc_RSRQ_RangeEUTRA_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -19.5dB (0)");
  } else if (v < 34) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%u)", ((float)v/2)-20, (((float)v+1)/2)-20, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-3dB <= RSRQ (34)");
  }
}

static void
nr_rrc_SINR_RangeEUTRA_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "SINR < -23dB (0)");
  } else if (v == 127) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "40dB <= SINR (127)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SINR < %.1fdB (%u)", (((float)v-1)/2)-23, ((float)v/2)-23, v);
  }
}

static void
nr_rrc_ReselectionThreshold_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%udB (%u)", 2 * v, v);
}

static void
nr_rrc_RSRP_Range_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "SS-RSRP < -156dBm (0)");
  } else if (v < 126) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= SS-RSRP < %ddBm (%u)", v-157, v-156, v);
  } else if (v == 126) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-31dBm <= SS-RSRP (126)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "infinity (127)");
  }
}

static void
nr_rrc_RSRQ_Range_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "SS-RSRQ < -43dB (0)");
  } else if (v < 127) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SS-RSRQ < %.1fdB (%u)", (((float)v-1)/2)-43, ((float)v/2)-43, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-20dB <= SS-RSRQ (127)");
  }
}

static void
nr_rrc_SINR_Range_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "SS-SINR < -23dB (0)");
  } else if (v < 127) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SS-SINR < %.1fdB (%u)", (((float)v-1)/2)-23, ((float)v/2)-23, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "40dB <= SS-SINR (127)");
  }
}

static void
nr_rrc_dl_1024QAM_TotalWeightedLayers_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%u (%u)", 10+(2*v), v);
}

static void
nr_rrc_MeasTriggerQuantityOffset_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%d)", (float)d/2, d);
}


/*--- Included file: packet-nr-rrc-fn.c ---*/
#line 1 "./asn1/nr-rrc/packet-nr-rrc-fn.c"
/*--- PDUs declarations ---*/
static int dissect_MeasResultList2NR_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UECapabilityEnquiry_v1560_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);



static int
dissect_nr_rrc_T_handoverCommandMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension, T_nonCriticalExtension_sequence);

  return offset;
}


static const per_sequence_t HandoverCommand_IEs_sequence[] = {
  { &hf_nr_rrc_handoverCommandMessage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_handoverCommandMessage },
  { &hf_nr_rrc_nonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverCommand_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverCommand_IEs, HandoverCommand_IEs_sequence);

  return offset;
}



static int
dissect_nr_rrc_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nr_rrc_T_c1_vals[] = {
  {   0, "handoverCommand" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_choice[] = {
  {   0, &hf_nr_rrc_handoverCommand, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_HandoverCommand_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1, T_c1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture, T_criticalExtensionsFuture_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_choice[] = {
  {   0, &hf_nr_rrc_c1           , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions, T_criticalExtensions_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HandoverCommand_sequence[] = {
  { &hf_nr_rrc_criticalExtensions, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverCommand, HandoverCommand_sequence);

  return offset;
}


static const value_string nr_rrc_RAT_Type_vals[] = {
  { RAT_Type_nr, "nr" },
  { RAT_Type_eutra_nr, "eutra-nr" },
  { RAT_Type_eutra, "eutra" },
  { RAT_Type_spare1, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_RAT_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 rat_type;
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, &rat_type, TRUE, 0, NULL);

  nr_priv->rat_type = (guint8)rat_type;


  return offset;
}



static int
dissect_nr_rrc_T_ue_CapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ue_cap_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &ue_cap_tvb);



  if (ue_cap_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;

    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_UE_CapabilityRAT_Container);
    switch(nr_priv->rat_type){
    case RAT_Type_nr:
      dissect_nr_rrc_UE_NR_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
      break;
    case RAT_Type_eutra_nr:
      dissect_nr_rrc_UE_MRDC_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
      break;
    case RAT_Type_eutra:
      dissect_lte_rrc_UE_EUTRA_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }

  return offset;
}


static const per_sequence_t UE_CapabilityRAT_Container_sequence[] = {
  { &hf_nr_rrc_rat_Type     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RAT_Type },
  { &hf_nr_rrc_ue_CapabilityRAT_Container, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ue_CapabilityRAT_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UE_CapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  /* Initialise to invalid value */
  nr_priv->rat_type = 0xFF;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UE_CapabilityRAT_Container, UE_CapabilityRAT_Container_sequence);



  return offset;
}


static const per_sequence_t UE_CapabilityRAT_ContainerList_sequence_of[1] = {
  { &hf_nr_rrc_UE_CapabilityRAT_ContainerList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UE_CapabilityRAT_Container },
};

static int
dissect_nr_rrc_UE_CapabilityRAT_ContainerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_UE_CapabilityRAT_ContainerList, UE_CapabilityRAT_ContainerList_sequence_of,
                                                  0, maxRAT_CapabilityContainers, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_rrcReconfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_sourceRB_SN_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_sourceSCG_NR_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_sourceSCG_EUTRA_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *src_scg_eutra_config_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &src_scg_eutra_config_tvb);

  if (src_scg_eutra_config_tvb && lte_rrc_conn_reconf_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_rr_rrc_targetRAT_MessageContainer);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_handle, src_scg_eutra_config_tvb, actx->pinfo, subtree);
  }


  return offset;
}


static const per_sequence_t AS_Config_eag_1_sequence[] = {
  { &hf_nr_rrc_sourceRB_SN_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceRB_SN_Config },
  { &hf_nr_rrc_sourceSCG_NR_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceSCG_NR_Config },
  { &hf_nr_rrc_sourceSCG_EUTRA_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceSCG_EUTRA_Config },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Config_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Config_eag_1_sequence);

  return offset;
}


static const per_sequence_t AS_Config_sequence[] = {
  { &hf_nr_rrc_rrcReconfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_rrcReconfiguration },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Config_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_AS_Config, AS_Config_sequence);

  return offset;
}


static const value_string nr_rrc_T_ue_InactiveTime_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s5" },
  {   4, "s7" },
  {   5, "s10" },
  {   6, "s15" },
  {   7, "s20" },
  {   8, "s25" },
  {   9, "s30" },
  {  10, "s40" },
  {  11, "s50" },
  {  12, "min1" },
  {  13, "min1s20" },
  {  14, "min1s40" },
  {  15, "min2" },
  {  16, "min2s30" },
  {  17, "min3" },
  {  18, "min3s30" },
  {  19, "min4" },
  {  20, "min5" },
  {  21, "min6" },
  {  22, "min7" },
  {  23, "min8" },
  {  24, "min9" },
  {  25, "min10" },
  {  26, "min12" },
  {  27, "min14" },
  {  28, "min17" },
  {  29, "min20" },
  {  30, "min24" },
  {  31, "min28" },
  {  32, "min33" },
  {  33, "min38" },
  {  34, "min44" },
  {  35, "min50" },
  {  36, "hr1" },
  {  37, "hr1min30" },
  {  38, "hr2" },
  {  39, "hr2min30" },
  {  40, "hr3" },
  {  41, "hr3min30" },
  {  42, "hr4" },
  {  43, "hr5" },
  {  44, "hr6" },
  {  45, "hr8" },
  {  46, "hr10" },
  {  47, "hr13" },
  {  48, "hr16" },
  {  49, "hr20" },
  {  50, "day1" },
  {  51, "day1hr12" },
  {  52, "day2" },
  {  53, "day2hr12" },
  {  54, "day3" },
  {  55, "day4" },
  {  56, "day5" },
  {  57, "day7" },
  {  58, "day10" },
  {  59, "day14" },
  {  60, "day19" },
  {  61, "day24" },
  {  62, "day30" },
  {  63, "dayMoreThan30" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_ue_InactiveTime_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_ue_InactiveTime_vals);


static int
dissect_nr_rrc_T_ue_InactiveTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     64, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_ARFCN_ValueNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNARFCN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRP_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRQ_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_SINR_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasQuantityResults_sequence[] = {
  { &hf_nr_rrc_rsrp         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { &hf_nr_rrc_rsrq         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRQ_Range },
  { &hf_nr_rrc_sinr         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SINR_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasQuantityResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasQuantityResults, MeasQuantityResults_sequence);

  return offset;
}


static const per_sequence_t T_cellResults_sequence[] = {
  { &hf_nr_rrc_resultsSSB_Cell, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { &hf_nr_rrc_resultsCSI_RS_Cell, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellResults, T_cellResults_sequence);

  return offset;
}



static int
dissect_nr_rrc_SSB_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSSBs_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t ResultsPerSSB_Index_sequence[] = {
  { &hf_nr_rrc_ssb_Index    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SSB_Index },
  { &hf_nr_rrc_ssb_Results  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ResultsPerSSB_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ResultsPerSSB_Index, ResultsPerSSB_Index_sequence);

  return offset;
}


static const per_sequence_t ResultsPerSSB_IndexList_sequence_of[1] = {
  { &hf_nr_rrc_ResultsPerSSB_IndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ResultsPerSSB_Index },
};

static int
dissect_nr_rrc_ResultsPerSSB_IndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ResultsPerSSB_IndexList, ResultsPerSSB_IndexList_sequence_of,
                                                  1, maxNrofIndexesToReport2, FALSE);

  return offset;
}



static int
dissect_nr_rrc_CSI_RS_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofCSI_RS_ResourcesRRM_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t ResultsPerCSI_RS_Index_sequence[] = {
  { &hf_nr_rrc_csi_RS_Index , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_Index },
  { &hf_nr_rrc_csi_RS_Results, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasQuantityResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ResultsPerCSI_RS_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ResultsPerCSI_RS_Index, ResultsPerCSI_RS_Index_sequence);

  return offset;
}


static const per_sequence_t ResultsPerCSI_RS_IndexList_sequence_of[1] = {
  { &hf_nr_rrc_ResultsPerCSI_RS_IndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ResultsPerCSI_RS_Index },
};

static int
dissect_nr_rrc_ResultsPerCSI_RS_IndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ResultsPerCSI_RS_IndexList, ResultsPerCSI_RS_IndexList_sequence_of,
                                                  1, maxNrofIndexesToReport2, FALSE);

  return offset;
}


static const per_sequence_t T_rsIndexResults_sequence[] = {
  { &hf_nr_rrc_resultsSSB_Indexes, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ResultsPerSSB_IndexList },
  { &hf_nr_rrc_resultsCSI_RS_Indexes, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ResultsPerCSI_RS_IndexList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_rsIndexResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_rsIndexResults, T_rsIndexResults_sequence);

  return offset;
}


static const per_sequence_t T_measResult_sequence[] = {
  { &hf_nr_rrc_cellResults  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellResults },
  { &hf_nr_rrc_rsIndexResults, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_rsIndexResults },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_measResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_measResult, T_measResult_sequence);

  return offset;
}



static int
dissect_nr_rrc_MCC_MNC_Digit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MCC_sequence_of[1] = {
  { &hf_nr_rrc_MCC_item     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MCC_MNC_Digit },
};

static int
dissect_nr_rrc_MCC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MCC, MCC_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const per_sequence_t MNC_sequence_of[1] = {
  { &hf_nr_rrc_MNC_item     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MCC_MNC_Digit },
};

static int
dissect_nr_rrc_MNC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MNC, MNC_sequence_of,
                                                  2, 3, FALSE);

  return offset;
}


static const per_sequence_t PLMN_Identity_sequence[] = {
  { &hf_nr_rrc_mcc          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MCC },
  { &hf_nr_rrc_mnc          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MNC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_Identity, PLMN_Identity_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity_sequence_of[1] = {
  { &hf_nr_rrc_plmn_IdentityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity, SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_TrackingAreaCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_RAN_AreaCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_CellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_cellReservedForOperatorUse_vals[] = {
  {   0, "reserved" },
  {   1, "notReserved" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cellReservedForOperatorUse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PLMN_IdentityInfo_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityList_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity },
  { &hf_nr_rrc_trackingAreaCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_TrackingAreaCode },
  { &hf_nr_rrc_ranac        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_AreaCode },
  { &hf_nr_rrc_cellIdentity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity },
  { &hf_nr_rrc_cellReservedForOperatorUse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellReservedForOperatorUse },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_IdentityInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_IdentityInfo, PLMN_IdentityInfo_sequence);

  return offset;
}


static const per_sequence_t PLMN_IdentityInfoList_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_IdentityInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityInfo },
};

static int
dissect_nr_rrc_PLMN_IdentityInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_IdentityInfoList, PLMN_IdentityInfoList_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_FreqBandIndicatorNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MultiFrequencyBandListNR_sequence_of[1] = {
  { &hf_nr_rrc_MultiFrequencyBandListNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorNR },
};

static int
dissect_nr_rrc_MultiFrequencyBandListNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MultiFrequencyBandListNR, MultiFrequencyBandListNR_sequence_of,
                                                  1, maxNrofMultiBands, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_ControlResourceSetZero(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_SearchSpaceZero(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PDCCH_ConfigSIB1_sequence[] = {
  { &hf_nr_rrc_controlResourceSetZero, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ControlResourceSetZero },
  { &hf_nr_rrc_searchSpaceZero, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SearchSpaceZero },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDCCH_ConfigSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PDCCH_ConfigSIB1, PDCCH_ConfigSIB1_sequence);

  return offset;
}


static const per_sequence_t T_noSIB1_sequence[] = {
  { &hf_nr_rrc_ssb_SubcarrierOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_15 },
  { &hf_nr_rrc_pdcch_ConfigSIB1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDCCH_ConfigSIB1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_noSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_noSIB1, T_noSIB1_sequence);

  return offset;
}


static const per_sequence_t CGI_InfoNR_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityInfoList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PLMN_IdentityInfoList },
  { &hf_nr_rrc_frequencyBandList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR },
  { &hf_nr_rrc_noSIB1       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_noSIB1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CGI_InfoNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CGI_InfoNR, CGI_InfoNR_sequence);

  return offset;
}


static const per_sequence_t MeasResultNR_eag_1_sequence[] = {
  { &hf_nr_rrc_cgi_Info     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CGI_InfoNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultNR_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasResultNR_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasResultNR_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_measResult   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measResult },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultNR_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultNR, MeasResultNR_sequence);

  return offset;
}


static const per_sequence_t MeasResultListNR_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultListNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultNR },
};

static int
dissect_nr_rrc_MeasResultListNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultListNR, MeasResultListNR_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}


static const per_sequence_t MeasResult2NR_sequence[] = {
  { &hf_nr_rrc_ssbFrequency , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_refFreqCSI_RS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_measResultServingCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultNR },
  { &hf_nr_rrc_measResultNeighCellListNR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultListNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResult2NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResult2NR, MeasResult2NR_sequence);

  return offset;
}


static const per_sequence_t MeasResultList2NR_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultList2NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResult2NR },
};

static int
dissect_nr_rrc_MeasResultList2NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultList2NR, MeasResultList2NR_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}



static int
dissect_nr_rrc_ARFCN_ValueEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRP_RangeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 97U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_RSRQ_RangeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 34U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_SINR_RangeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasQuantityResultsEUTRA_sequence[] = {
  { &hf_nr_rrc_rsrp_01      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_RangeEUTRA },
  { &hf_nr_rrc_rsrq_01      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRQ_RangeEUTRA },
  { &hf_nr_rrc_sinr_01      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SINR_RangeEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasQuantityResultsEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasQuantityResultsEUTRA, MeasQuantityResultsEUTRA_sequence);

  return offset;
}


static const per_sequence_t PLMN_IdentityList_EUTRA_EPC_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_IdentityList_EUTRA_EPC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity },
};

static int
dissect_nr_rrc_PLMN_IdentityList_EUTRA_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_IdentityList_EUTRA_EPC, PLMN_IdentityList_EUTRA_EPC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t CellAccessRelatedInfo_EUTRA_EPC_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityList_eutra_epc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityList_EUTRA_EPC },
  { &hf_nr_rrc_trackingAreaCode_eutra_epc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_16 },
  { &hf_nr_rrc_cellIdentity_eutra_epc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC, CellAccessRelatedInfo_EUTRA_EPC_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC_sequence_of[1] = {
  { &hf_nr_rrc_cgi_info_EPC_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC, SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}


static const per_sequence_t T_cgi_info_EPC_sequence[] = {
  { &hf_nr_rrc_cgi_info_EPC_legacy, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_EPC },
  { &hf_nr_rrc_cgi_info_EPC_list, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cgi_info_EPC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cgi_info_EPC, T_cgi_info_EPC_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxPLMN, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_PLMN_Identity_EUTRA_5GC_vals[] = {
  {   0, "plmn-Identity-EUTRA-5GC" },
  {   1, "plmn-index" },
  { 0, NULL }
};

static const per_choice_t PLMN_Identity_EUTRA_5GC_choice[] = {
  {   0, &hf_nr_rrc_plmn_Identity_EUTRA_5GC, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_PLMN_Identity },
  {   1, &hf_nr_rrc_plmn_index   , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_maxPLMN },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_Identity_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_PLMN_Identity_EUTRA_5GC, PLMN_Identity_EUTRA_5GC_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PLMN_IdentityList_EUTRA_5GC_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_IdentityList_EUTRA_5GC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_Identity_EUTRA_5GC },
};

static int
dissect_nr_rrc_PLMN_IdentityList_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_IdentityList_EUTRA_5GC, PLMN_IdentityList_EUTRA_5GC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}


static const value_string nr_rrc_CellIdentity_EUTRA_5GC_vals[] = {
  {   0, "cellIdentity-EUTRA" },
  {   1, "cellId-index" },
  { 0, NULL }
};

static const per_choice_t CellIdentity_EUTRA_5GC_choice[] = {
  {   0, &hf_nr_rrc_cellIdentity_EUTRA, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_28 },
  {   1, &hf_nr_rrc_cellId_index , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_maxPLMN },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_CellIdentity_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_CellIdentity_EUTRA_5GC, CellIdentity_EUTRA_5GC_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellAccessRelatedInfo_EUTRA_5GC_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityList_eutra_5gc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityList_EUTRA_5GC },
  { &hf_nr_rrc_trackingAreaCode_eutra_5gc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TrackingAreaCode },
  { &hf_nr_rrc_ranac_5gc    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_AreaCode },
  { &hf_nr_rrc_cellIdentity_eutra_5gc, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity_EUTRA_5GC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC, CellAccessRelatedInfo_EUTRA_5GC_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC_sequence_of[1] = {
  { &hf_nr_rrc_cgi_info_5GC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellAccessRelatedInfo_EUTRA_5GC },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC, SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_FreqBandIndicatorEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxBandsEUTRA, NULL, FALSE);

  return offset;
}


static const per_sequence_t MultiBandInfoListEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_MultiBandInfoListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorEUTRA },
};

static int
dissect_nr_rrc_MultiBandInfoListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MultiBandInfoListEUTRA, MultiBandInfoListEUTRA_sequence_of,
                                                  1, maxMultiBands, FALSE);

  return offset;
}


static const value_string nr_rrc_T_freqBandIndicatorPriority_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_freqBandIndicatorPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CGI_InfoEUTRA_sequence[] = {
  { &hf_nr_rrc_cgi_info_EPC , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cgi_info_EPC },
  { &hf_nr_rrc_cgi_info_5GC , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC },
  { &hf_nr_rrc_freqBandIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorEUTRA },
  { &hf_nr_rrc_multiBandInfoList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MultiBandInfoListEUTRA },
  { &hf_nr_rrc_freqBandIndicatorPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_freqBandIndicatorPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CGI_InfoEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CGI_InfoEUTRA, CGI_InfoEUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultEUTRA_sequence[] = {
  { &hf_nr_rrc_eutra_PhysCellId_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_measResult_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasQuantityResultsEUTRA },
  { &hf_nr_rrc_cgi_Info_01  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CGI_InfoEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultEUTRA, MeasResultEUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResult2EUTRA_sequence[] = {
  { &hf_nr_rrc_carrierFreq_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_measResultServingCell_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultEUTRA },
  { &hf_nr_rrc_measResultBestNeighCell_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResult2EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResult2EUTRA, MeasResult2EUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultServFreqListEUTRA_SCG_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultServFreqListEUTRA_SCG_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResult2EUTRA },
};

static int
dissect_nr_rrc_MeasResultServFreqListEUTRA_SCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultServFreqListEUTRA_SCG, MeasResultServFreqListEUTRA_SCG_sequence_of,
                                                  1, maxNrofServingCellsEUTRA, FALSE);

  return offset;
}


static const per_sequence_t RRM_Config_eag_1_sequence[] = {
  { &hf_nr_rrc_candidateCellInfoListSN_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultServFreqListEUTRA_SCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRM_Config_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RRM_Config_eag_1_sequence);

  return offset;
}


static const per_sequence_t RRM_Config_sequence[] = {
  { &hf_nr_rrc_ue_InactiveTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_ue_InactiveTime },
  { &hf_nr_rrc_candidateCellInfoList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultList2NR },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRM_Config_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRM_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRM_Config, RRM_Config_sequence);

  return offset;
}



static int
dissect_nr_rrc_ShortMAC_I(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t ReestabNCellInfo_sequence[] = {
  { &hf_nr_rrc_cellIdentity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity },
  { &hf_nr_rrc_key_gNodeB_Star, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_256 },
  { &hf_nr_rrc_shortMAC_I   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ShortMAC_I },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReestabNCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReestabNCellInfo, ReestabNCellInfo_sequence);

  return offset;
}


static const per_sequence_t ReestabNCellInfoList_sequence_of[1] = {
  { &hf_nr_rrc_ReestabNCellInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReestabNCellInfo },
};

static int
dissect_nr_rrc_ReestabNCellInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ReestabNCellInfoList, ReestabNCellInfoList_sequence_of,
                                                  1, maxCellPrep, FALSE);

  return offset;
}


static const per_sequence_t ReestablishmentInfo_sequence[] = {
  { &hf_nr_rrc_sourcePhysCellId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_targetCellShortMAC_I, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ShortMAC_I },
  { &hf_nr_rrc_additionalReestabInfoList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ReestabNCellInfoList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReestablishmentInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReestablishmentInfo, ReestablishmentInfo_sequence);

  return offset;
}



static int
dissect_nr_rrc_BandCombinationIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxBandComb, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_FeatureSetEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxFeatureSetsPerBand, NULL, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex_sequence_of[1] = {
  { &hf_nr_rrc_allowedFeatureSetsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FeatureSetEntryIndex },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex, SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex_sequence_of,
                                                  1, maxFeatureSetsPerBand, FALSE);

  return offset;
}


static const per_sequence_t BandCombinationInfo_sequence[] = {
  { &hf_nr_rrc_bandCombinationIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandCombinationIndex },
  { &hf_nr_rrc_allowedFeatureSetsList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BandCombinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BandCombinationInfo, BandCombinationInfo_sequence);

  return offset;
}


static const per_sequence_t BandCombinationInfoList_sequence_of[1] = {
  { &hf_nr_rrc_BandCombinationInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandCombinationInfo },
};

static int
dissect_nr_rrc_BandCombinationInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_BandCombinationInfoList, BandCombinationInfoList_sequence_of,
                                                  1, maxBandComb, FALSE);

  return offset;
}



static int
dissect_nr_rrc_P_Max(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30, 33U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_powerCoordination_FR1_sequence[] = {
  { &hf_nr_rrc_p_maxNR_FR1  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_p_maxEUTRA   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_p_maxUE_FR1  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_powerCoordination_FR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_powerCoordination_FR1, T_powerCoordination_FR1_sequence);

  return offset;
}



static int
dissect_nr_rrc_ServCellIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofServingCells_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_servCellIndexRangeSCG_sequence[] = {
  { &hf_nr_rrc_lowBound     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_upBound      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_servCellIndexRangeSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_servCellIndexRangeSCG, T_servCellIndexRangeSCG_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxMeasFreqsMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxMeasFreqsMN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxMeasIdentitiesMN, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BandEntryIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofServingCells, NULL, FALSE);

  return offset;
}


static const per_sequence_t SelectedBandEntriesMN_sequence_of[1] = {
  { &hf_nr_rrc_SelectedBandEntriesMN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandEntryIndex },
};

static int
dissect_nr_rrc_SelectedBandEntriesMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SelectedBandEntriesMN, SelectedBandEntriesMN_sequence_of,
                                                  1, maxSimultaneousBands, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN_sequence_of[1] = {
  { &hf_nr_rrc_selectedBandEntriesMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SelectedBandEntriesMN },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN, SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN_sequence_of,
                                                  1, maxBandComb, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_16384(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16384U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoSCG_eag_1_sequence[] = {
  { &hf_nr_rrc_selectedBandEntriesMNList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN },
  { &hf_nr_rrc_pdcch_BlindDetectionSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_15 },
  { &hf_nr_rrc_maxNumberROHC_ContextSessionsSN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_16384 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoSCG_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ConfigRestrictInfoSCG_eag_1_sequence);

  return offset;
}


static const per_sequence_t ConfigRestrictInfoSCG_sequence[] = {
  { &hf_nr_rrc_allowedBC_ListMRDC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoList },
  { &hf_nr_rrc_powerCoordination_FR1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_powerCoordination_FR1 },
  { &hf_nr_rrc_servCellIndexRangeSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_servCellIndexRangeSCG },
  { &hf_nr_rrc_maxMeasFreqsSCG, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasFreqsMN },
  { &hf_nr_rrc_maxMeasIdentitiesSCG_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxMeasIdentitiesMN },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ConfigRestrictInfoSCG_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictInfoSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ConfigRestrictInfoSCG, ConfigRestrictInfoSCG_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_32_OF_CellIdentity_sequence_of[1] = {
  { &hf_nr_rrc_ran_AreaCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellIdentity },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity, SEQUENCE_SIZE_1_32_OF_CellIdentity_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaCell_sequence[] = {
  { &hf_nr_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PLMN_Identity },
  { &hf_nr_rrc_ran_AreaCells, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_RAN_AreaCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_RAN_AreaCell, PLMN_RAN_AreaCell_sequence);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaCellList_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_RAN_AreaCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_RAN_AreaCell },
};

static int
dissect_nr_rrc_PLMN_RAN_AreaCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_RAN_AreaCellList, PLMN_RAN_AreaCellList_sequence_of,
                                                  1, maxPLMNIdentities, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_sequence_of[1] = {
  { &hf_nr_rrc_ran_AreaCodeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RAN_AreaCode },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode, SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t RAN_AreaConfig_sequence[] = {
  { &hf_nr_rrc_trackingAreaCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TrackingAreaCode },
  { &hf_nr_rrc_ran_AreaCodeList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RAN_AreaConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RAN_AreaConfig, RAN_AreaConfig_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_sequence_of[1] = {
  { &hf_nr_rrc_ran_Area_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RAN_AreaConfig },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig, SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaConfig_sequence[] = {
  { &hf_nr_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PLMN_Identity },
  { &hf_nr_rrc_ran_Area     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PLMN_RAN_AreaConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PLMN_RAN_AreaConfig, PLMN_RAN_AreaConfig_sequence);

  return offset;
}


static const per_sequence_t PLMN_RAN_AreaConfigList_sequence_of[1] = {
  { &hf_nr_rrc_PLMN_RAN_AreaConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_RAN_AreaConfig },
};

static int
dissect_nr_rrc_PLMN_RAN_AreaConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PLMN_RAN_AreaConfigList, PLMN_RAN_AreaConfigList_sequence_of,
                                                  1, maxPLMNIdentities, FALSE);

  return offset;
}


static const value_string nr_rrc_RAN_NotificationAreaInfo_vals[] = {
  {   0, "cellList" },
  {   1, "ran-AreaConfigList" },
  { 0, NULL }
};

static const per_choice_t RAN_NotificationAreaInfo_choice[] = {
  {   0, &hf_nr_rrc_cellList     , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_PLMN_RAN_AreaCellList },
  {   1, &hf_nr_rrc_ran_AreaConfigList, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_PLMN_RAN_AreaConfigList },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_RAN_NotificationAreaInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_RAN_NotificationAreaInfo, RAN_NotificationAreaInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AS_Context_eag_1_sequence[] = {
  { &hf_nr_rrc_ran_NotificationAreaInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_NotificationAreaInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_1_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_ueAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UEAssistanceInformation_PDU);

  return offset;
}


static const per_sequence_t AS_Context_eag_2_sequence[] = {
  { &hf_nr_rrc_ueAssistanceInformation, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ueAssistanceInformation },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_2_sequence);

  return offset;
}


static const per_sequence_t BandCombinationInfoSN_sequence[] = {
  { &hf_nr_rrc_bandCombinationIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BandCombinationIndex },
  { &hf_nr_rrc_requestedFeatureSets, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FeatureSetEntryIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BandCombinationInfoSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BandCombinationInfoSN, BandCombinationInfoSN_sequence);

  return offset;
}


static const per_sequence_t AS_Context_eag_3_sequence[] = {
  { &hf_nr_rrc_selectedBandCombinationSN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoSN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, AS_Context_eag_3_sequence);

  return offset;
}


static const per_sequence_t AS_Context_sequence[] = {
  { &hf_nr_rrc_reestablishmentInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReestablishmentInfo },
  { &hf_nr_rrc_configRestrictInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictInfoSCG },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_2 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_AS_Context_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AS_Context(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_AS_Context, AS_Context_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_01, T_nonCriticalExtension_01_sequence);

  return offset;
}


static const per_sequence_t HandoverPreparationInformation_IEs_sequence[] = {
  { &hf_nr_rrc_ue_CapabilityRAT_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UE_CapabilityRAT_ContainerList },
  { &hf_nr_rrc_sourceConfig , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_AS_Config },
  { &hf_nr_rrc_rrm_Config   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRM_Config },
  { &hf_nr_rrc_as_Context   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_AS_Context },
  { &hf_nr_rrc_nonCriticalExtension_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverPreparationInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverPreparationInformation_IEs, HandoverPreparationInformation_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_01_vals[] = {
  {   0, "handoverPreparationInformation" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_01_choice[] = {
  {   0, &hf_nr_rrc_handoverPreparationInformation, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_HandoverPreparationInformation_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_01, T_c1_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_01, T_criticalExtensionsFuture_01_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_01_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_01_choice[] = {
  {   0, &hf_nr_rrc_c1_01        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_01 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_01, T_criticalExtensions_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HandoverPreparationInformation_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_HandoverPreparationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_HandoverPreparationInformation, HandoverPreparationInformation_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_scg_CellGroupConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_scg_RB_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}


static const per_sequence_t ConfigRestrictModReqSCG_eag_1_sequence[] = {
  { &hf_nr_rrc_requestedPDCCH_BlindDetectionSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_15 },
  { &hf_nr_rrc_requestedP_MaxEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictModReqSCG_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ConfigRestrictModReqSCG_eag_1_sequence);

  return offset;
}


static const per_sequence_t ConfigRestrictModReqSCG_sequence[] = {
  { &hf_nr_rrc_requestedBC_MRDC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoSN },
  { &hf_nr_rrc_requestedP_MaxFR1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ConfigRestrictModReqSCG_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConfigRestrictModReqSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ConfigRestrictModReqSCG, ConfigRestrictModReqSCG_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 39U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_59(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 59U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_69(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 69U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_79(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 79U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_159(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 159U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_319(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 319U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_639(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 639U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_1279(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1279U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2559(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2559U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_5119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5119U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_10239(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10239U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_drx_LongCycleStartOffset_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  {   2, "ms32" },
  {   3, "ms40" },
  {   4, "ms60" },
  {   5, "ms64" },
  {   6, "ms70" },
  {   7, "ms80" },
  {   8, "ms128" },
  {   9, "ms160" },
  {  10, "ms256" },
  {  11, "ms320" },
  {  12, "ms512" },
  {  13, "ms640" },
  {  14, "ms1024" },
  {  15, "ms1280" },
  {  16, "ms2048" },
  {  17, "ms2560" },
  {  18, "ms5120" },
  {  19, "ms10240" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_LongCycleStartOffset_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_LongCycleStartOffset_vals);

static const per_choice_t T_drx_LongCycleStartOffset_choice[] = {
  {   0, &hf_nr_rrc_ms10         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_9 },
  {   1, &hf_nr_rrc_ms20         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_19 },
  {   2, &hf_nr_rrc_ms32         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_31 },
  {   3, &hf_nr_rrc_ms40         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   4, &hf_nr_rrc_ms60         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_59 },
  {   5, &hf_nr_rrc_ms64         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_63 },
  {   6, &hf_nr_rrc_ms70         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_69 },
  {   7, &hf_nr_rrc_ms80         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   8, &hf_nr_rrc_ms128        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_127 },
  {   9, &hf_nr_rrc_ms160        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  {  10, &hf_nr_rrc_ms256        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_255 },
  {  11, &hf_nr_rrc_ms320        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_319 },
  {  12, &hf_nr_rrc_ms512        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_511 },
  {  13, &hf_nr_rrc_ms640        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_639 },
  {  14, &hf_nr_rrc_ms1024       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1023 },
  {  15, &hf_nr_rrc_ms1280       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1279 },
  {  16, &hf_nr_rrc_ms2048       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2047 },
  {  17, &hf_nr_rrc_ms2560       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2559 },
  {  18, &hf_nr_rrc_ms5120       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_5119 },
  {  19, &hf_nr_rrc_ms10240      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_10239 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_drx_LongCycleStartOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_drx_LongCycleStartOffset, T_drx_LongCycleStartOffset_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_ShortCycle_vals[] = {
  {   0, "ms2" },
  {   1, "ms3" },
  {   2, "ms4" },
  {   3, "ms5" },
  {   4, "ms6" },
  {   5, "ms7" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms14" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms30" },
  {  12, "ms32" },
  {  13, "ms35" },
  {  14, "ms40" },
  {  15, "ms64" },
  {  16, "ms80" },
  {  17, "ms128" },
  {  18, "ms160" },
  {  19, "ms256" },
  {  20, "ms320" },
  {  21, "ms512" },
  {  22, "ms640" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_ShortCycle_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_ShortCycle_vals);


static int
dissect_nr_rrc_T_drx_ShortCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_shortDRX_sequence[] = {
  { &hf_nr_rrc_drx_ShortCycle, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_ShortCycle },
  { &hf_nr_rrc_drx_ShortCycleTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_shortDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_shortDRX, T_shortDRX_sequence);

  return offset;
}


static const per_sequence_t DRX_Info_sequence[] = {
  { &hf_nr_rrc_drx_LongCycleStartOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_LongCycleStartOffset },
  { &hf_nr_rrc_shortDRX     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_shortDRX },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DRX_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DRX_Info, DRX_Info_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_MeasResultList2NR_PDU);

  return offset;
}


static const per_sequence_t NR_FreqInfo_sequence[] = {
  { &hf_nr_rrc_measuredFrequency, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NR_FreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NR_FreqInfo, NR_FreqInfo_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo_sequence_of[1] = {
  { &hf_nr_rrc_measuredFrequenciesSN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_FreqInfo },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo, SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo_sequence_of,
                                                  1, maxMeasFreqsSN, FALSE);

  return offset;
}


static const per_sequence_t MeasConfigSN_sequence[] = {
  { &hf_nr_rrc_measuredFrequenciesSN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasConfigSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasConfigSN, MeasConfigSN_sequence);

  return offset;
}


static const value_string nr_rrc_T_fr_Type_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_fr_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t FR_Info_sequence[] = {
  { &hf_nr_rrc_servCellIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_fr_Type      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_fr_Type },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FR_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FR_Info, FR_Info_sequence);

  return offset;
}


static const per_sequence_t FR_InfoList_sequence_of[1] = {
  { &hf_nr_rrc_FR_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FR_Info },
};

static int
dissect_nr_rrc_FR_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_FR_InfoList, FR_InfoList_sequence_of,
                                                  1, maxNrofServingCells_1, FALSE);

  return offset;
}


static const per_sequence_t CandidateServingFreqListNR_sequence_of[1] = {
  { &hf_nr_rrc_CandidateServingFreqListNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
};

static int
dissect_nr_rrc_CandidateServingFreqListNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_CandidateServingFreqListNR, CandidateServingFreqListNR_sequence_of,
                                                  1, maxFreqIDC_MRDC, FALSE);

  return offset;
}


static const per_sequence_t T_requestedCellInfo_sequence[] = {
  { &hf_nr_rrc_ssbFrequency , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_cellForWhichToReportCGI, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_requestedCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_requestedCellInfo, T_requestedCellInfo_sequence);

  return offset;
}


static const per_sequence_t T_reportCGI_RequestNR_sequence[] = {
  { &hf_nr_rrc_requestedCellInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_requestedCellInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_reportCGI_RequestNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_reportCGI_RequestNR, T_reportCGI_RequestNR_sequence);

  return offset;
}


static const value_string nr_rrc_T_ph_Type1or3_vals[] = {
  {   0, "type1" },
  {   1, "type3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ph_Type1or3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PH_UplinkCarrierSCG_sequence[] = {
  { &hf_nr_rrc_ph_Type1or3  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ph_Type1or3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_UplinkCarrierSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_UplinkCarrierSCG, PH_UplinkCarrierSCG_sequence);

  return offset;
}


static const per_sequence_t PH_InfoSCG_sequence[] = {
  { &hf_nr_rrc_servCellIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_ph_Uplink    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_UplinkCarrierSCG },
  { &hf_nr_rrc_ph_SupplementaryUplink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PH_UplinkCarrierSCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_InfoSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_InfoSCG, PH_InfoSCG_sequence);

  return offset;
}


static const per_sequence_t PH_TypeListSCG_sequence_of[1] = {
  { &hf_nr_rrc_PH_TypeListSCG_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_InfoSCG },
};

static int
dissect_nr_rrc_PH_TypeListSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PH_TypeListSCG, PH_TypeListSCG_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_scg_CellGroupConfigEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *scg_cell_group_config_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &scg_cell_group_config_eutra_tvb);

  if (scg_cell_group_config_eutra_tvb && lte_rrc_conn_reconf_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_scg_CellGroupConfigEUTRA);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_handle, scg_cell_group_config_eutra_tvb, actx->pinfo, subtree);
  }


  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListSN_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cand_cell_info_list_sn_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &cand_cell_info_list_sn_eutra_tvb);

  if (cand_cell_info_list_sn_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_candidateCellInfoListSN_EUTRA);
    dissect_lte_rrc_MeasResultList3EUTRA_r15_PDU(cand_cell_info_list_sn_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CandidateServingFreqListEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_CandidateServingFreqListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
};

static int
dissect_nr_rrc_CandidateServingFreqListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_CandidateServingFreqListEUTRA, CandidateServingFreqListEUTRA_sequence_of,
                                                  1, maxFreqIDC_MRDC, FALSE);

  return offset;
}


static const value_string nr_rrc_T_needForGaps_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_needForGaps(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 31U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_milliSeconds_vals[] = {
  {   0, "ms1" },
  {   1, "ms2" },
  {   2, "ms3" },
  {   3, "ms4" },
  {   4, "ms5" },
  {   5, "ms6" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms20" },
  {   9, "ms30" },
  {  10, "ms40" },
  {  11, "ms50" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms200" },
  {  16, "ms300" },
  {  17, "ms400" },
  {  18, "ms500" },
  {  19, "ms600" },
  {  20, "ms800" },
  {  21, "ms1000" },
  {  22, "ms1200" },
  {  23, "ms1600" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_milliSeconds_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_milliSeconds_vals);


static int
dissect_nr_rrc_T_milliSeconds(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_onDurationTimer_vals[] = {
  {   0, "subMilliSeconds" },
  {   1, "milliSeconds" },
  { 0, NULL }
};

static const per_choice_t T_drx_onDurationTimer_choice[] = {
  {   0, &hf_nr_rrc_subMilliSeconds, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_31 },
  {   1, &hf_nr_rrc_milliSeconds , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_milliSeconds },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_drx_onDurationTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_drx_onDurationTimer, T_drx_onDurationTimer_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_InactivityTimer_vals[] = {
  {   0, "ms0" },
  {   1, "ms1" },
  {   2, "ms2" },
  {   3, "ms3" },
  {   4, "ms4" },
  {   5, "ms5" },
  {   6, "ms6" },
  {   7, "ms8" },
  {   8, "ms10" },
  {   9, "ms20" },
  {  10, "ms30" },
  {  11, "ms40" },
  {  12, "ms50" },
  {  13, "ms60" },
  {  14, "ms80" },
  {  15, "ms100" },
  {  16, "ms200" },
  {  17, "ms300" },
  {  18, "ms500" },
  {  19, "ms750" },
  {  20, "ms1280" },
  {  21, "ms1920" },
  {  22, "ms2560" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_InactivityTimer_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_InactivityTimer_vals);


static int
dissect_nr_rrc_T_drx_InactivityTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_56(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 56U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_drx_RetransmissionTimerDL_vals[] = {
  {   0, "sl0" },
  {   1, "sl1" },
  {   2, "sl2" },
  {   3, "sl4" },
  {   4, "sl6" },
  {   5, "sl8" },
  {   6, "sl16" },
  {   7, "sl24" },
  {   8, "sl33" },
  {   9, "sl40" },
  {  10, "sl64" },
  {  11, "sl80" },
  {  12, "sl96" },
  {  13, "sl112" },
  {  14, "sl128" },
  {  15, "sl160" },
  {  16, "sl320" },
  {  17, "spare15" },
  {  18, "spare14" },
  {  19, "spare13" },
  {  20, "spare12" },
  {  21, "spare11" },
  {  22, "spare10" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_RetransmissionTimerDL_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_RetransmissionTimerDL_vals);


static int
dissect_nr_rrc_T_drx_RetransmissionTimerDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_RetransmissionTimerUL_vals[] = {
  {   0, "sl0" },
  {   1, "sl1" },
  {   2, "sl2" },
  {   3, "sl4" },
  {   4, "sl6" },
  {   5, "sl8" },
  {   6, "sl16" },
  {   7, "sl24" },
  {   8, "sl33" },
  {   9, "sl40" },
  {  10, "sl64" },
  {  11, "sl80" },
  {  12, "sl96" },
  {  13, "sl112" },
  {  14, "sl128" },
  {  15, "sl160" },
  {  16, "sl320" },
  {  17, "spare15" },
  {  18, "spare14" },
  {  19, "spare13" },
  {  20, "spare12" },
  {  21, "spare11" },
  {  22, "spare10" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_RetransmissionTimerUL_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_RetransmissionTimerUL_vals);


static int
dissect_nr_rrc_T_drx_RetransmissionTimerUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_LongCycleStartOffset_01_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  {   2, "ms32" },
  {   3, "ms40" },
  {   4, "ms60" },
  {   5, "ms64" },
  {   6, "ms70" },
  {   7, "ms80" },
  {   8, "ms128" },
  {   9, "ms160" },
  {  10, "ms256" },
  {  11, "ms320" },
  {  12, "ms512" },
  {  13, "ms640" },
  {  14, "ms1024" },
  {  15, "ms1280" },
  {  16, "ms2048" },
  {  17, "ms2560" },
  {  18, "ms5120" },
  {  19, "ms10240" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_LongCycleStartOffset_01_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_LongCycleStartOffset_01_vals);

static const per_choice_t T_drx_LongCycleStartOffset_01_choice[] = {
  {   0, &hf_nr_rrc_ms10         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_9 },
  {   1, &hf_nr_rrc_ms20         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_19 },
  {   2, &hf_nr_rrc_ms32         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_31 },
  {   3, &hf_nr_rrc_ms40         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   4, &hf_nr_rrc_ms60         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_59 },
  {   5, &hf_nr_rrc_ms64         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_63 },
  {   6, &hf_nr_rrc_ms70         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_69 },
  {   7, &hf_nr_rrc_ms80         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   8, &hf_nr_rrc_ms128        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_127 },
  {   9, &hf_nr_rrc_ms160        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  {  10, &hf_nr_rrc_ms256        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_255 },
  {  11, &hf_nr_rrc_ms320        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_319 },
  {  12, &hf_nr_rrc_ms512        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_511 },
  {  13, &hf_nr_rrc_ms640        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_639 },
  {  14, &hf_nr_rrc_ms1024       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1023 },
  {  15, &hf_nr_rrc_ms1280       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1279 },
  {  16, &hf_nr_rrc_ms2048       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2047 },
  {  17, &hf_nr_rrc_ms2560       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2559 },
  {  18, &hf_nr_rrc_ms5120       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_5119 },
  {  19, &hf_nr_rrc_ms10240      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_10239 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_drx_LongCycleStartOffset_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_drx_LongCycleStartOffset_01, T_drx_LongCycleStartOffset_01_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_ShortCycle_01_vals[] = {
  {   0, "ms2" },
  {   1, "ms3" },
  {   2, "ms4" },
  {   3, "ms5" },
  {   4, "ms6" },
  {   5, "ms7" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms14" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms30" },
  {  12, "ms32" },
  {  13, "ms35" },
  {  14, "ms40" },
  {  15, "ms64" },
  {  16, "ms80" },
  {  17, "ms128" },
  {  18, "ms160" },
  {  19, "ms256" },
  {  20, "ms320" },
  {  21, "ms512" },
  {  22, "ms640" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_drx_ShortCycle_01_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_drx_ShortCycle_01_vals);


static int
dissect_nr_rrc_T_drx_ShortCycle_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_shortDRX_01_sequence[] = {
  { &hf_nr_rrc_drx_ShortCycle_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_ShortCycle_01 },
  { &hf_nr_rrc_drx_ShortCycleTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_shortDRX_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_shortDRX_01, T_shortDRX_01_sequence);

  return offset;
}


static const per_sequence_t DRX_Config_sequence[] = {
  { &hf_nr_rrc_drx_onDurationTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_onDurationTimer },
  { &hf_nr_rrc_drx_InactivityTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_InactivityTimer },
  { &hf_nr_rrc_drx_HARQ_RTT_TimerDL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_56 },
  { &hf_nr_rrc_drx_HARQ_RTT_TimerUL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_56 },
  { &hf_nr_rrc_drx_RetransmissionTimerDL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_RetransmissionTimerDL },
  { &hf_nr_rrc_drx_RetransmissionTimerUL, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_RetransmissionTimerUL },
  { &hf_nr_rrc_drx_LongCycleStartOffset_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_drx_LongCycleStartOffset_01 },
  { &hf_nr_rrc_shortDRX_01  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_shortDRX_01 },
  { &hf_nr_rrc_drx_SlotOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DRX_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DRX_Config, DRX_Config_sequence);

  return offset;
}



static int
dissect_nr_rrc_EUTRA_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_requestedCellInfoEUTRA_sequence[] = {
  { &hf_nr_rrc_eutraFrequency, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_cellForWhichToReportCGI_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_requestedCellInfoEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_requestedCellInfoEUTRA, T_requestedCellInfoEUTRA_sequence);

  return offset;
}


static const per_sequence_t T_reportCGI_RequestEUTRA_sequence[] = {
  { &hf_nr_rrc_requestedCellInfoEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_requestedCellInfoEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_reportCGI_RequestEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_reportCGI_RequestEUTRA, T_reportCGI_RequestEUTRA_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_02, T_nonCriticalExtension_02_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1560_IEs_sequence[] = {
  { &hf_nr_rrc_pSCellFrequencyEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_scg_CellGroupConfigEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_CellGroupConfigEUTRA },
  { &hf_nr_rrc_candidateCellInfoListSN_EUTRA_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListSN_EUTRA },
  { &hf_nr_rrc_candidateServingFreqListEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CandidateServingFreqListEUTRA },
  { &hf_nr_rrc_needForGaps  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_needForGaps },
  { &hf_nr_rrc_drx_ConfigSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Config },
  { &hf_nr_rrc_reportCGI_RequestEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_reportCGI_RequestEUTRA },
  { &hf_nr_rrc_nonCriticalExtension_04, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1560_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1560_IEs, CG_Config_v1560_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_v1540_IEs_sequence[] = {
  { &hf_nr_rrc_pSCellFrequency, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_reportCGI_RequestNR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_reportCGI_RequestNR },
  { &hf_nr_rrc_ph_InfoSCG   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PH_TypeListSCG },
  { &hf_nr_rrc_nonCriticalExtension_03, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1560_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_v1540_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_v1540_IEs, CG_Config_v1540_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_Config_IEs_sequence[] = {
  { &hf_nr_rrc_scg_CellGroupConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_CellGroupConfig },
  { &hf_nr_rrc_scg_RB_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_RB_Config },
  { &hf_nr_rrc_configRestrictModReq, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictModReqSCG },
  { &hf_nr_rrc_drx_InfoSCG  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Info },
  { &hf_nr_rrc_candidateCellInfoListSN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListSN },
  { &hf_nr_rrc_measConfigSN , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasConfigSN },
  { &hf_nr_rrc_selectedBandCombination, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_BandCombinationInfoSN },
  { &hf_nr_rrc_fr_InfoListSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FR_InfoList },
  { &hf_nr_rrc_candidateServingFreqListNR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CandidateServingFreqListNR },
  { &hf_nr_rrc_nonCriticalExtension_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_Config_v1540_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config_IEs, CG_Config_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_02_vals[] = {
  {   0, "cg-Config" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_02_choice[] = {
  {   0, &hf_nr_rrc_cg_Config    , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_CG_Config_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_02, T_c1_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_02, T_criticalExtensionsFuture_02_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_02_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_02_choice[] = {
  {   0, &hf_nr_rrc_c1_02        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_02 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_02, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_02, T_criticalExtensions_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CG_Config_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_Config, CG_Config_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_ue_CapabilityInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UE_CapabilityRAT_ContainerList_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListSN_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_MeasResultList2NR_PDU);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M30720_30719(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30720, 30719U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasResultCellSFTD_NR_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_sfn_OffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1023 },
  { &hf_nr_rrc_frameBoundaryOffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M30720_30719 },
  { &hf_nr_rrc_rsrp_Result  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultCellSFTD_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultCellSFTD_NR, MeasResultCellSFTD_NR_sequence);

  return offset;
}


static const per_sequence_t MeasResultCellListSFTD_NR_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultCellListSFTD_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultCellSFTD_NR },
};

static int
dissect_nr_rrc_MeasResultCellListSFTD_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultCellListSFTD_NR, MeasResultCellListSFTD_NR_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const value_string nr_rrc_T_failureType_vals[] = {
  {   0, "t310-Expiry" },
  {   1, "randomAccessProblem" },
  {   2, "rlc-MaxNumRetx" },
  {   3, "synchReconfigFailure-SCG" },
  {   4, "scg-reconfigFailure" },
  {   5, "srb3-IntegrityFailure" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_failureType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_T_measResultSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_MeasResultSCG_Failure_PDU);

  return offset;
}


static const per_sequence_t T_scgFailureInfo_sequence[] = {
  { &hf_nr_rrc_failureType  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_failureType },
  { &hf_nr_rrc_measResultSCG, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measResultSCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_scgFailureInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_scgFailureInfo, T_scgFailureInfo_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo_sequence_of[1] = {
  { &hf_nr_rrc_measuredFrequenciesMN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_FreqInfo },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo, SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo_sequence_of,
                                                  1, maxMeasFreqsMN, FALSE);

  return offset;
}


static const value_string nr_rrc_T_mgl_vals[] = {
  {   0, "ms1dot5" },
  {   1, "ms3" },
  {   2, "ms3dot5" },
  {   3, "ms4" },
  {   4, "ms5dot5" },
  {   5, "ms6" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mgl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_mgrp_vals[] = {
  {   0, "ms20" },
  {   1, "ms40" },
  {   2, "ms80" },
  {   3, "ms160" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mgrp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_mgta_vals[] = {
  {   0, "ms0" },
  {   1, "ms0dot25" },
  {   2, "ms0dot5" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mgta(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_refServCellIndicator_vals[] = {
  {   0, "pCell" },
  {   1, "pSCell" },
  {   2, "mcg-FR2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_refServCellIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GapConfig_eag_1_sequence[] = {
  { &hf_nr_rrc_refServCellIndicator, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_refServCellIndicator },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_GapConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GapConfig_eag_1_sequence);

  return offset;
}


static const per_sequence_t GapConfig_sequence[] = {
  { &hf_nr_rrc_gapOffset    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_159 },
  { &hf_nr_rrc_mgl          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mgl },
  { &hf_nr_rrc_mgrp         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mgrp },
  { &hf_nr_rrc_mgta         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mgta },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_GapConfig_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_GapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_GapConfig, GapConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_measGapConfig_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_measGapConfig_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_GapConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_measGapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_measGapConfig, T_measGapConfig_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_gapPurpose_vals[] = {
  {   0, "perUE" },
  {   1, "perFR1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_gapPurpose(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_measGapConfigFR2_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_measGapConfigFR2_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_GapConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_measGapConfigFR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_measGapConfigFR2, T_measGapConfigFR2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasConfigMN_eag_1_sequence[] = {
  { &hf_nr_rrc_measGapConfigFR2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_measGapConfigFR2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasConfigMN_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasConfigMN_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasConfigMN_sequence[] = {
  { &hf_nr_rrc_measuredFrequenciesMN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo },
  { &hf_nr_rrc_measGapConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_measGapConfig },
  { &hf_nr_rrc_gapPurpose   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapPurpose },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasConfigMN_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasConfigMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasConfigMN, MeasConfigMN_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_sourceConfigSCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_scg_RB_Config_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_mcg_RB_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}


static const value_string nr_rrc_T_gps_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_gps(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_glonass_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_glonass(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_bds_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_bds(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_galileo_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_galileo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_wlan_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_wlan(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_bluetooth_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_bluetooth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t VictimSystemType_sequence[] = {
  { &hf_nr_rrc_gps          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_gps },
  { &hf_nr_rrc_glonass      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_glonass },
  { &hf_nr_rrc_bds          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_bds },
  { &hf_nr_rrc_galileo      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_galileo },
  { &hf_nr_rrc_wlan         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_wlan },
  { &hf_nr_rrc_bluetooth    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_bluetooth },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_VictimSystemType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_VictimSystemType, VictimSystemType_sequence);

  return offset;
}


static const value_string nr_rrc_T_interferenceDirectionMRDC_vals[] = {
  {   0, "eutra-nr" },
  {   1, "nr" },
  {   2, "other" },
  {   3, "utra-nr-other" },
  {   4, "nr-other" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_interferenceDirectionMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AffectedCarrierFreqCombEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_AffectedCarrierFreqCombEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
};

static int
dissect_nr_rrc_AffectedCarrierFreqCombEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_AffectedCarrierFreqCombEUTRA, AffectedCarrierFreqCombEUTRA_sequence_of,
                                                  1, maxNrofServingCellsEUTRA, FALSE);

  return offset;
}


static const per_sequence_t AffectedCarrierFreqCombNR_sequence_of[1] = {
  { &hf_nr_rrc_AffectedCarrierFreqCombNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
};

static int
dissect_nr_rrc_AffectedCarrierFreqCombNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_AffectedCarrierFreqCombNR, AffectedCarrierFreqCombNR_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const per_sequence_t T_affectedCarrierFreqCombMRDC_sequence[] = {
  { &hf_nr_rrc_affectedCarrierFreqCombEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_AffectedCarrierFreqCombEUTRA },
  { &hf_nr_rrc_affectedCarrierFreqCombNR, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_AffectedCarrierFreqCombNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_affectedCarrierFreqCombMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_affectedCarrierFreqCombMRDC, T_affectedCarrierFreqCombMRDC_sequence);

  return offset;
}


static const per_sequence_t AffectedCarrierFreqCombInfoMRDC_sequence[] = {
  { &hf_nr_rrc_victimSystemType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_VictimSystemType },
  { &hf_nr_rrc_interferenceDirectionMRDC, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_interferenceDirectionMRDC },
  { &hf_nr_rrc_affectedCarrierFreqCombMRDC, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_affectedCarrierFreqCombMRDC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_AffectedCarrierFreqCombInfoMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_AffectedCarrierFreqCombInfoMRDC, AffectedCarrierFreqCombInfoMRDC_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC_sequence_of[1] = {
  { &hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_AffectedCarrierFreqCombInfoMRDC },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC, SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC_sequence_of,
                                                  1, maxNrofCombIDC, FALSE);

  return offset;
}


static const per_sequence_t MRDC_AssistanceInfo_sequence[] = {
  { &hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MRDC_AssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MRDC_AssistanceInfo, MRDC_AssistanceInfo_sequence);

  return offset;
}


static const value_string nr_rrc_T_ph_Type1or3_01_vals[] = {
  {   0, "type1" },
  {   1, "type3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ph_Type1or3_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PH_UplinkCarrierMCG_sequence[] = {
  { &hf_nr_rrc_ph_Type1or3_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ph_Type1or3_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_UplinkCarrierMCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_UplinkCarrierMCG, PH_UplinkCarrierMCG_sequence);

  return offset;
}


static const per_sequence_t PH_InfoMCG_sequence[] = {
  { &hf_nr_rrc_servCellIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_ph_Uplink_01 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_UplinkCarrierMCG },
  { &hf_nr_rrc_ph_SupplementaryUplink_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PH_UplinkCarrierMCG },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PH_InfoMCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PH_InfoMCG, PH_InfoMCG_sequence);

  return offset;
}


static const per_sequence_t PH_TypeListMCG_sequence_of[1] = {
  { &hf_nr_rrc_PH_TypeListMCG_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PH_InfoMCG },
};

static int
dissect_nr_rrc_PH_TypeListMCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PH_TypeListMCG, PH_TypeListMCG_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const per_sequence_t T_measResultReportCGI_sequence[] = {
  { &hf_nr_rrc_ssbFrequency , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_cellForWhichToReportCGI, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_cgi_Info     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CGI_InfoNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_measResultReportCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_measResultReportCGI, T_measResultReportCGI_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListMN_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cand_cell_info_list_mn_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &cand_cell_info_list_mn_eutra_tvb);

  if (cand_cell_info_list_mn_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_candidateCellInfoListMN_EUTRA);
    dissect_lte_rrc_MeasResultList3EUTRA_r15_PDU(cand_cell_info_list_mn_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_nr_rrc_T_candidateCellInfoListSN_EUTRA_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cand_cell_info_list_sn_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &cand_cell_info_list_sn_eutra_tvb);

  if (cand_cell_info_list_sn_eutra_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_candidateCellInfoListSN_EUTRA);
    dissect_lte_rrc_MeasResultList3EUTRA_r15_PDU(cand_cell_info_list_sn_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_nr_rrc_T_sourceConfigSCG_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *source_config_scg_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &source_config_scg_eutra_tvb);

  if (source_config_scg_eutra_tvb && lte_rrc_conn_reconf_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_sourceConfigSCG_EUTRA);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_handle, source_config_scg_eutra_tvb, actx->pinfo, subtree);
  }

  return offset;
}


static const value_string nr_rrc_T_failureTypeEUTRA_vals[] = {
  {   0, "t313-Expiry" },
  {   1, "randomAccessProblem" },
  {   2, "rlc-MaxNumRetx" },
  {   3, "scg-ChangeFailure" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_failureTypeEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_OCTET_STRING(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const per_sequence_t T_scgFailureInfoEUTRA_sequence[] = {
  { &hf_nr_rrc_failureTypeEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_failureTypeEUTRA },
  { &hf_nr_rrc_measResultSCG_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_scgFailureInfoEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_scgFailureInfoEUTRA, T_scgFailureInfoEUTRA_sequence);

  return offset;
}


static const per_sequence_t T_measResultReportCGI_EUTRA_sequence[] = {
  { &hf_nr_rrc_eutraFrequency, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_cellForWhichToReportCGI_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { &hf_nr_rrc_cgi_InfoEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CGI_InfoEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_measResultReportCGI_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_measResultReportCGI_EUTRA, T_measResultReportCGI_EUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultSFTD_EUTRA_sequence[] = {
  { &hf_nr_rrc_eutra_PhysCellId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { &hf_nr_rrc_sfn_OffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1023 },
  { &hf_nr_rrc_frameBoundaryOffsetResult, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M30720_30719 },
  { &hf_nr_rrc_rsrp_Result  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultSFTD_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultSFTD_EUTRA, MeasResultSFTD_EUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultCellListSFTD_EUTRA_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultCellListSFTD_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultSFTD_EUTRA },
};

static int
dissect_nr_rrc_MeasResultCellListSFTD_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultCellListSFTD_EUTRA, MeasResultCellListSFTD_EUTRA_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const per_sequence_t SFTD_FrequencyList_NR_sequence_of[1] = {
  { &hf_nr_rrc_SFTD_FrequencyList_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
};

static int
dissect_nr_rrc_SFTD_FrequencyList_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SFTD_FrequencyList_NR, SFTD_FrequencyList_NR_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const per_sequence_t SFTD_FrequencyList_EUTRA_sequence_of[1] = {
  { &hf_nr_rrc_SFTD_FrequencyList_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
};

static int
dissect_nr_rrc_SFTD_FrequencyList_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SFTD_FrequencyList_EUTRA, SFTD_FrequencyList_EUTRA_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_03, T_nonCriticalExtension_03_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1570_IEs_sequence[] = {
  { &hf_nr_rrc_sftdFrequencyList_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SFTD_FrequencyList_NR },
  { &hf_nr_rrc_sftdFrequencyList_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SFTD_FrequencyList_EUTRA },
  { &hf_nr_rrc_nonCriticalExtension_08, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1570_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1570_IEs, CG_ConfigInfo_v1570_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1560_IEs_sequence[] = {
  { &hf_nr_rrc_candidateCellInfoListMN_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListMN_EUTRA },
  { &hf_nr_rrc_candidateCellInfoListSN_EUTRA_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListSN_EUTRA_01 },
  { &hf_nr_rrc_sourceConfigSCG_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceConfigSCG_EUTRA },
  { &hf_nr_rrc_scgFailureInfoEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scgFailureInfoEUTRA },
  { &hf_nr_rrc_drx_ConfigMCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Config },
  { &hf_nr_rrc_measResultReportCGI_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_measResultReportCGI_EUTRA },
  { &hf_nr_rrc_measResultCellListSFTD_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultCellListSFTD_EUTRA },
  { &hf_nr_rrc_fr_InfoListMCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FR_InfoList },
  { &hf_nr_rrc_nonCriticalExtension_07, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1570_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1560_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1560_IEs, CG_ConfigInfo_v1560_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_v1540_IEs_sequence[] = {
  { &hf_nr_rrc_ph_InfoMCG   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PH_TypeListMCG },
  { &hf_nr_rrc_measResultReportCGI, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_measResultReportCGI },
  { &hf_nr_rrc_nonCriticalExtension_06, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1560_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_v1540_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_v1540_IEs, CG_ConfigInfo_v1540_IEs_sequence);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_IEs_sequence[] = {
  { &hf_nr_rrc_ue_CapabilityInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ue_CapabilityInfo },
  { &hf_nr_rrc_candidateCellInfoListMN, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultList2NR },
  { &hf_nr_rrc_candidateCellInfoListSN_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_candidateCellInfoListSN_01 },
  { &hf_nr_rrc_measResultCellListSFTD_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultCellListSFTD_NR },
  { &hf_nr_rrc_scgFailureInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scgFailureInfo },
  { &hf_nr_rrc_configRestrictInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ConfigRestrictInfoSCG },
  { &hf_nr_rrc_drx_InfoMCG  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DRX_Info },
  { &hf_nr_rrc_measConfigMN , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasConfigMN },
  { &hf_nr_rrc_sourceConfigSCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_sourceConfigSCG },
  { &hf_nr_rrc_scg_RB_Config_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_RB_Config_01 },
  { &hf_nr_rrc_mcg_RB_Config, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_mcg_RB_Config },
  { &hf_nr_rrc_mrdc_AssistanceInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MRDC_AssistanceInfo },
  { &hf_nr_rrc_nonCriticalExtension_05, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CG_ConfigInfo_v1540_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo_IEs, CG_ConfigInfo_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_03_vals[] = {
  {   0, "cg-ConfigInfo" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_03_choice[] = {
  {   0, &hf_nr_rrc_cg_ConfigInfo, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_CG_ConfigInfo_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_03, T_c1_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_03, T_criticalExtensionsFuture_03_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_03_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_03_choice[] = {
  {   0, &hf_nr_rrc_c1_03        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_03 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_03, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_03 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_03, T_criticalExtensions_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CG_ConfigInfo_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CG_ConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CG_ConfigInfo, CG_ConfigInfo_sequence);

  return offset;
}


static const value_string nr_rrc_SubcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_SubcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_periodicityAndOffset_01_vals[] = {
  {   0, "sf5" },
  {   1, "sf10" },
  {   2, "sf20" },
  {   3, "sf40" },
  {   4, "sf80" },
  {   5, "sf160" },
  { 0, NULL }
};

static const per_choice_t T_periodicityAndOffset_01_choice[] = {
  {   0, &hf_nr_rrc_sf5          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_4 },
  {   1, &hf_nr_rrc_sf10         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_9 },
  {   2, &hf_nr_rrc_sf20         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_19 },
  {   3, &hf_nr_rrc_sf40         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   4, &hf_nr_rrc_sf80         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   5, &hf_nr_rrc_sf160        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_periodicityAndOffset_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_periodicityAndOffset_01, T_periodicityAndOffset_01_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_duration_vals[] = {
  {   0, "sf1" },
  {   1, "sf2" },
  {   2, "sf3" },
  {   3, "sf4" },
  {   4, "sf5" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_duration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SSB_MTC_sequence[] = {
  { &hf_nr_rrc_periodicityAndOffset_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_periodicityAndOffset_01 },
  { &hf_nr_rrc_duration_02  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_duration },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SSB_MTC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SSB_MTC, SSB_MTC_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_1_80(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 80, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SS_RSSI_Measurement_sequence[] = {
  { &hf_nr_rrc_measurementSlots, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1_80 },
  { &hf_nr_rrc_endSymbol    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SS_RSSI_Measurement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SS_RSSI_Measurement, SS_RSSI_Measurement_sequence);

  return offset;
}


static const per_sequence_t T_frequencyAndTiming_sequence[] = {
  { &hf_nr_rrc_carrierFreq  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_ssbSubcarrierSpacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_ssb_MeasurementTimingConfiguration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SSB_MTC },
  { &hf_nr_rrc_ss_RSSI_Measurement, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SS_RSSI_Measurement },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_frequencyAndTiming(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_frequencyAndTiming, T_frequencyAndTiming_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_SSB_ToMeasure_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  { 0, NULL }
};

static const per_choice_t SSB_ToMeasure_choice[] = {
  {   0, &hf_nr_rrc_shortBitmap  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_4 },
  {   1, &hf_nr_rrc_mediumBitmap , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_8 },
  {   2, &hf_nr_rrc_longBitmap   , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_64 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_SSB_ToMeasure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_SSB_ToMeasure, SSB_ToMeasure_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasTiming_eag_1_sequence[] = {
  { &hf_nr_rrc_ssb_ToMeasure_v1540, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_ToMeasure },
  { &hf_nr_rrc_physCellId   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasTiming_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasTiming_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasTiming_sequence[] = {
  { &hf_nr_rrc_frequencyAndTiming, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_frequencyAndTiming },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTiming_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasTiming(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasTiming, MeasTiming_sequence);

  return offset;
}


static const per_sequence_t MeasTimingList_sequence_of[1] = {
  { &hf_nr_rrc_MeasTimingList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTiming },
};

static int
dissect_nr_rrc_MeasTimingList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasTimingList, MeasTimingList_sequence_of,
                                                  1, maxMeasFreqsMN, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_04, T_nonCriticalExtension_04_sequence);

  return offset;
}


static const per_sequence_t MeasurementTimingConfiguration_v1550_IEs_sequence[] = {
  { &hf_nr_rrc_campOnFirstSSB, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_psCellOnlyOnFirstSSB, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_nonCriticalExtension_10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementTimingConfiguration_v1550_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementTimingConfiguration_v1550_IEs, MeasurementTimingConfiguration_v1550_IEs_sequence);

  return offset;
}


static const per_sequence_t MeasurementTimingConfiguration_IEs_sequence[] = {
  { &hf_nr_rrc_measTiming   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasTimingList },
  { &hf_nr_rrc_nonCriticalExtension_09, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasurementTimingConfiguration_v1550_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementTimingConfiguration_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementTimingConfiguration_IEs, MeasurementTimingConfiguration_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_04_vals[] = {
  {   0, "measTimingConf" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_04_choice[] = {
  {   0, &hf_nr_rrc_measTimingConf, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MeasurementTimingConfiguration_IEs },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_04, T_c1_04_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_04, T_criticalExtensionsFuture_04_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_04_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_04_choice[] = {
  {   0, &hf_nr_rrc_c1_04        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_04 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_04, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_04 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_04, T_criticalExtensions_04_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasurementTimingConfiguration_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_04, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementTimingConfiguration, MeasurementTimingConfiguration_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR_sequence_of[1] = {
  { &hf_nr_rrc_supportedBandListNRForPaging_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorNR },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR, SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR_sequence_of,
                                                  1, maxBands, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_05, T_nonCriticalExtension_05_sequence);

  return offset;
}


static const per_sequence_t UERadioPagingInformation_IEs_sequence[] = {
  { &hf_nr_rrc_supportedBandListNRForPaging, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR },
  { &hf_nr_rrc_nonCriticalExtension_11, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_05 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioPagingInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioPagingInformation_IEs, UERadioPagingInformation_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_05_vals[] = {
  {   0, "ueRadioPagingInformation" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_05_choice[] = {
  {   0, &hf_nr_rrc_ueRadioPagingInformation, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UERadioPagingInformation_IEs },
  {   1, &hf_nr_rrc_spare7       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare6       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare5       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   4, &hf_nr_rrc_spare4       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   5, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   6, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   7, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_05, T_c1_05_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_05, T_criticalExtensionsFuture_05_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_05_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_05_choice[] = {
  {   0, &hf_nr_rrc_c1_05        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_05 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_05, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_05 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_05, T_criticalExtensions_05_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UERadioPagingInformation_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_05, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_05 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioPagingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioPagingInformation, UERadioPagingInformation_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_ue_RadioAccessCapabilityInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_UE_CapabilityRAT_ContainerList_PDU);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_06_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_06, T_nonCriticalExtension_06_sequence);

  return offset;
}


static const per_sequence_t UERadioAccessCapabilityInformation_IEs_sequence[] = {
  { &hf_nr_rrc_ue_RadioAccessCapabilityInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ue_RadioAccessCapabilityInfo },
  { &hf_nr_rrc_nonCriticalExtension_12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_06 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioAccessCapabilityInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioAccessCapabilityInformation_IEs, UERadioAccessCapabilityInformation_IEs_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_06_vals[] = {
  {   0, "ueRadioAccessCapabilityInformation" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_06_choice[] = {
  {   0, &hf_nr_rrc_ueRadioAccessCapabilityInformation, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UERadioAccessCapabilityInformation_IEs },
  {   1, &hf_nr_rrc_spare7       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare6       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare5       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   4, &hf_nr_rrc_spare4       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   5, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   6, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   7, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_06, T_c1_06_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_06_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_06, T_criticalExtensionsFuture_06_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_06_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_06_choice[] = {
  {   0, &hf_nr_rrc_c1_06        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_06 },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_06, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_06 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_06, T_criticalExtensions_06_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UERadioAccessCapabilityInformation_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_06, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_06 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UERadioAccessCapabilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UERadioAccessCapabilityInformation, UERadioAccessCapabilityInformation_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_subCarrierSpacingCommon_vals[] = {
  {   0, "scs15or60" },
  {   1, "scs30or120" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_subCarrierSpacingCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dmrs_TypeA_Position_vals[] = {
  {   0, "pos2" },
  {   1, "pos3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dmrs_TypeA_Position(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_cellBarred_vals[] = {
  {   0, "barred" },
  {   1, "notBarred" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cellBarred(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_intraFreqReselection_vals[] = {
  {   0, "allowed" },
  {   1, "notAllowed" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_intraFreqReselection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 1, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t MIB_sequence[] = {
  { &hf_nr_rrc_systemFrameNumber, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_6 },
  { &hf_nr_rrc_subCarrierSpacingCommon, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_subCarrierSpacingCommon },
  { &hf_nr_rrc_ssb_SubcarrierOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_15 },
  { &hf_nr_rrc_dmrs_TypeA_Position, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_dmrs_TypeA_Position },
  { &hf_nr_rrc_pdcch_ConfigSIB1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDCCH_ConfigSIB1 },
  { &hf_nr_rrc_cellBarred   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellBarred },
  { &hf_nr_rrc_intraFreqReselection, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_intraFreqReselection },
  { &hf_nr_rrc_spare        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MIB");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MIB, MIB_sequence);

  return offset;
}


static const per_sequence_t T_messageClassExtension_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension, T_messageClassExtension_sequence);

  return offset;
}


static const value_string nr_rrc_BCCH_BCH_MessageType_vals[] = {
  {   0, "mib" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t BCCH_BCH_MessageType_choice[] = {
  {   0, &hf_nr_rrc_mib          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MIB },
  {   1, &hf_nr_rrc_messageClassExtension, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_BCCH_BCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_BCCH_BCH_MessageType, BCCH_BCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BCCH_BCH_Message_sequence[] = {
  { &hf_nr_rrc_message      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BCCH_BCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BCCH_BCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BCCH_BCH_Message, BCCH_BCH_Message_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_2_maxNrofSS_BlocksToAverage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, maxNrofSS_BlocksToAverage, NULL, FALSE);

  return offset;
}


static const per_sequence_t ThresholdNR_sequence[] = {
  { &hf_nr_rrc_thresholdRSRP, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { &hf_nr_rrc_thresholdRSRQ, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RSRQ_Range },
  { &hf_nr_rrc_thresholdSINR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SINR_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ThresholdNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ThresholdNR, ThresholdNR_sequence);

  return offset;
}


static const value_string nr_rrc_Q_OffsetRange_vals[] = {
  {   0, "dB-24" },
  {   1, "dB-22" },
  {   2, "dB-20" },
  {   3, "dB-18" },
  {   4, "dB-16" },
  {   5, "dB-14" },
  {   6, "dB-12" },
  {   7, "dB-10" },
  {   8, "dB-8" },
  {   9, "dB-6" },
  {  10, "dB-5" },
  {  11, "dB-4" },
  {  12, "dB-3" },
  {  13, "dB-2" },
  {  14, "dB-1" },
  {  15, "dB0" },
  {  16, "dB1" },
  {  17, "dB2" },
  {  18, "dB3" },
  {  19, "dB4" },
  {  20, "dB5" },
  {  21, "dB6" },
  {  22, "dB8" },
  {  23, "dB10" },
  {  24, "dB12" },
  {  25, "dB14" },
  {  26, "dB16" },
  {  27, "dB18" },
  {  28, "dB20" },
  {  29, "dB22" },
  {  30, "dB24" },
  { 0, NULL }
};

static value_string_ext nr_rrc_Q_OffsetRange_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_Q_OffsetRange_vals);


static int
dissect_nr_rrc_Q_OffsetRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_RangeToBestCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_nr_rrc_Q_OffsetRange(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nr_rrc_T_q_Hyst_vals[] = {
  {   0, "dB0" },
  {   1, "dB1" },
  {   2, "dB2" },
  {   3, "dB3" },
  {   4, "dB4" },
  {   5, "dB5" },
  {   6, "dB6" },
  {   7, "dB8" },
  {   8, "dB10" },
  {   9, "dB12" },
  {  10, "dB14" },
  {  11, "dB16" },
  {  12, "dB18" },
  {  13, "dB20" },
  {  14, "dB22" },
  {  15, "dB24" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_q_Hyst(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t_Evaluation_vals[] = {
  {   0, "s30" },
  {   1, "s60" },
  {   2, "s120" },
  {   3, "s180" },
  {   4, "s240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t_Evaluation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t_HystNormal_vals[] = {
  {   0, "s30" },
  {   1, "s60" },
  {   2, "s120" },
  {   3, "s180" },
  {   4, "s240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t_HystNormal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t MobilityStateParameters_sequence[] = {
  { &hf_nr_rrc_t_Evaluation , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t_Evaluation },
  { &hf_nr_rrc_t_HystNormal , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t_HystNormal },
  { &hf_nr_rrc_n_CellChangeMedium, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { &hf_nr_rrc_n_CellChangeHigh, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MobilityStateParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MobilityStateParameters, MobilityStateParameters_sequence);

  return offset;
}


static const value_string nr_rrc_T_sf_Medium_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4" },
  {   2, "dB-2" },
  {   3, "dB0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_Medium(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_sf_High_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4" },
  {   2, "dB-2" },
  {   3, "dB0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_High(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_q_HystSF_sequence[] = {
  { &hf_nr_rrc_sf_Medium    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_Medium },
  { &hf_nr_rrc_sf_High      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_High },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_q_HystSF(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_q_HystSF, T_q_HystSF_sequence);

  return offset;
}


static const per_sequence_t T_speedStateReselectionPars_sequence[] = {
  { &hf_nr_rrc_mobilityStateParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MobilityStateParameters },
  { &hf_nr_rrc_q_HystSF     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_q_HystSF },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_speedStateReselectionPars(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_speedStateReselectionPars, T_speedStateReselectionPars_sequence);

  return offset;
}


static const per_sequence_t T_cellReselectionInfoCommon_sequence[] = {
  { &hf_nr_rrc_nrofSS_BlocksToAverage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_2_maxNrofSS_BlocksToAverage },
  { &hf_nr_rrc_absThreshSS_BlocksConsolidation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ThresholdNR },
  { &hf_nr_rrc_rangeToBestCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RangeToBestCell },
  { &hf_nr_rrc_q_Hyst       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_q_Hyst },
  { &hf_nr_rrc_speedStateReselectionPars, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_speedStateReselectionPars },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellReselectionInfoCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellReselectionInfoCommon, T_cellReselectionInfoCommon_sequence);

  return offset;
}



static int
dissect_nr_rrc_ReselectionThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_ReselectionThresholdQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_CellReselectionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_CellReselectionSubPriority_vals[] = {
  {   0, "oDot2" },
  {   1, "oDot4" },
  {   2, "oDot6" },
  {   3, "oDot8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_CellReselectionSubPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_cellReselectionServingFreqInfo_sequence[] = {
  { &hf_nr_rrc_s_NonIntraSearchP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_s_NonIntraSearchQ, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_threshServingLowP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_threshServingLowQ, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_cellReselectionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellReselectionPriority },
  { &hf_nr_rrc_cellReselectionSubPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionSubPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellReselectionServingFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellReselectionServingFreqInfo, T_cellReselectionServingFreqInfo_sequence);

  return offset;
}



static int
dissect_nr_rrc_Q_RxLevMin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -70, -22, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_Q_QualMin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -43, -12, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_Reselection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_AdditionalSpectrumEmission(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NR_NS_PmaxValue_sequence[] = {
  { &hf_nr_rrc_additionalPmax, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_additionalSpectrumEmission, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_AdditionalSpectrumEmission },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NR_NS_PmaxValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NR_NS_PmaxValue, NR_NS_PmaxValue_sequence);

  return offset;
}


static const per_sequence_t NR_NS_PmaxList_sequence_of[1] = {
  { &hf_nr_rrc_NR_NS_PmaxList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_NS_PmaxValue },
};

static int
dissect_nr_rrc_NR_NS_PmaxList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_NR_NS_PmaxList, NR_NS_PmaxList_sequence_of,
                                                  1, maxNR_NS_Pmax, FALSE);

  return offset;
}


static const per_sequence_t NR_MultiBandInfo_sequence[] = {
  { &hf_nr_rrc_freqBandIndicatorNR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FreqBandIndicatorNR },
  { &hf_nr_rrc_nr_NS_PmaxList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_NR_NS_PmaxList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_NR_MultiBandInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_NR_MultiBandInfo, NR_MultiBandInfo_sequence);

  return offset;
}


static const per_sequence_t MultiFrequencyBandListNR_SIB_sequence_of[1] = {
  { &hf_nr_rrc_MultiFrequencyBandListNR_SIB_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_MultiBandInfo },
};

static int
dissect_nr_rrc_MultiFrequencyBandListNR_SIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MultiFrequencyBandListNR_SIB, MultiFrequencyBandListNR_SIB_sequence_of,
                                                  1, maxNrofMultiBands, FALSE);

  return offset;
}


static const value_string nr_rrc_T_sf_Medium_01_vals[] = {
  {   0, "oDot25" },
  {   1, "oDot5" },
  {   2, "oDot75" },
  {   3, "lDot0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_Medium_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_sf_High_01_vals[] = {
  {   0, "oDot25" },
  {   1, "oDot5" },
  {   2, "oDot75" },
  {   3, "lDot0" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sf_High_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SpeedStateScaleFactors_sequence[] = {
  { &hf_nr_rrc_sf_Medium_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_Medium_01 },
  { &hf_nr_rrc_sf_High_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sf_High_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SpeedStateScaleFactors(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SpeedStateScaleFactors, SpeedStateScaleFactors_sequence);

  return offset;
}


static const per_sequence_t T_eag_1_sequence[] = {
  { &hf_nr_rrc_t_ReselectionNR_SF, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SpeedStateScaleFactors },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_sequence);

  return offset;
}


static const per_sequence_t T_intraFreqCellReselectionInfo_sequence[] = {
  { &hf_nr_rrc_q_RxLevMin   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_RxLevMinSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_QualMin    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_Q_QualMin },
  { &hf_nr_rrc_s_IntraSearchP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_s_IntraSearchQ, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_t_ReselectionNR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_Reselection },
  { &hf_nr_rrc_frequencyBandList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_frequencyBandListSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_p_Max        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_smtc         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_MTC },
  { &hf_nr_rrc_ss_RSSI_Measurement, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SS_RSSI_Measurement },
  { &hf_nr_rrc_ssb_ToMeasure, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_ToMeasure },
  { &hf_nr_rrc_deriveSSB_IndexFromCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_intraFreqCellReselectionInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_intraFreqCellReselectionInfo, T_intraFreqCellReselectionInfo_sequence);

  return offset;
}


static const per_sequence_t SIB2_sequence[] = {
  { &hf_nr_rrc_cellReselectionInfoCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellReselectionInfoCommon },
  { &hf_nr_rrc_cellReselectionServingFreqInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cellReselectionServingFreqInfo },
  { &hf_nr_rrc_intraFreqCellReselectionInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_intraFreqCellReselectionInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB2");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB2, SIB2_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  return offset;
}


static const per_sequence_t IntraFreqNeighCellInfo_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_q_OffsetCell , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_q_RxLevMinOffsetCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_RxLevMinOffsetCellSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_QualMinOffsetCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_IntraFreqNeighCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_IntraFreqNeighCellInfo, IntraFreqNeighCellInfo_sequence);

  return offset;
}


static const per_sequence_t IntraFreqNeighCellList_sequence_of[1] = {
  { &hf_nr_rrc_IntraFreqNeighCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_IntraFreqNeighCellInfo },
};

static int
dissect_nr_rrc_IntraFreqNeighCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_IntraFreqNeighCellList, IntraFreqNeighCellList_sequence_of,
                                                  1, maxCellIntra, FALSE);

  return offset;
}


static const value_string nr_rrc_T_range_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n24" },
  {   5, "n32" },
  {   6, "n48" },
  {   7, "n64" },
  {   8, "n84" },
  {   9, "n96" },
  {  10, "n128" },
  {  11, "n168" },
  {  12, "n252" },
  {  13, "n504" },
  {  14, "n1008" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PCI_Range_sequence[] = {
  { &hf_nr_rrc_start        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_range        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PCI_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PCI_Range, PCI_Range_sequence);

  return offset;
}


static const per_sequence_t IntraFreqBlackCellList_sequence_of[1] = {
  { &hf_nr_rrc_IntraFreqBlackCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCI_Range },
};

static int
dissect_nr_rrc_IntraFreqBlackCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_IntraFreqBlackCellList, IntraFreqBlackCellList_sequence_of,
                                                  1, maxCellBlack, FALSE);

  return offset;
}


static const per_sequence_t SIB3_sequence[] = {
  { &hf_nr_rrc_intraFreqNeighCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_IntraFreqNeighCellList },
  { &hf_nr_rrc_intraFreqBlackCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_IntraFreqBlackCellList },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB3");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB3, SIB3_sequence);

  return offset;
}


static const per_sequence_t T_threshX_Q_sequence[] = {
  { &hf_nr_rrc_threshX_HighQ, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_threshX_LowQ , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThresholdQ },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_threshX_Q(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_threshX_Q, T_threshX_Q_sequence);

  return offset;
}


static const per_sequence_t InterFreqNeighCellInfo_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_q_OffsetCell , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_q_RxLevMinOffsetCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_RxLevMinOffsetCellSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_QualMinOffsetCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_InterFreqNeighCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_InterFreqNeighCellInfo, InterFreqNeighCellInfo_sequence);

  return offset;
}


static const per_sequence_t InterFreqNeighCellList_sequence_of[1] = {
  { &hf_nr_rrc_InterFreqNeighCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_InterFreqNeighCellInfo },
};

static int
dissect_nr_rrc_InterFreqNeighCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_InterFreqNeighCellList, InterFreqNeighCellList_sequence_of,
                                                  1, maxCellInter, FALSE);

  return offset;
}


static const per_sequence_t InterFreqBlackCellList_sequence_of[1] = {
  { &hf_nr_rrc_InterFreqBlackCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCI_Range },
};

static int
dissect_nr_rrc_InterFreqBlackCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_InterFreqBlackCellList, InterFreqBlackCellList_sequence_of,
                                                  1, maxCellBlack, FALSE);

  return offset;
}


static const per_sequence_t InterFreqCarrierFreqInfo_sequence[] = {
  { &hf_nr_rrc_dl_CarrierFreq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_frequencyBandList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_frequencyBandListSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_nrofSS_BlocksToAverage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_2_maxNrofSS_BlocksToAverage },
  { &hf_nr_rrc_absThreshSS_BlocksConsolidation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ThresholdNR },
  { &hf_nr_rrc_smtc         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_MTC },
  { &hf_nr_rrc_ssbSubcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_ssb_ToMeasure, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_ToMeasure },
  { &hf_nr_rrc_deriveSSB_IndexFromCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_ss_RSSI_Measurement, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SS_RSSI_Measurement },
  { &hf_nr_rrc_q_RxLevMin   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_RxLevMinSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_QualMin    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_Q_QualMin },
  { &hf_nr_rrc_p_Max        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_t_ReselectionNR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_Reselection },
  { &hf_nr_rrc_t_ReselectionNR_SF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SpeedStateScaleFactors },
  { &hf_nr_rrc_threshX_HighP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_threshX_LowP , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_threshX_Q    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_threshX_Q },
  { &hf_nr_rrc_cellReselectionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionPriority },
  { &hf_nr_rrc_cellReselectionSubPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionSubPriority },
  { &hf_nr_rrc_q_OffsetFreq , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_interFreqNeighCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_InterFreqNeighCellList },
  { &hf_nr_rrc_interFreqBlackCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_InterFreqBlackCellList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_InterFreqCarrierFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_InterFreqCarrierFreqInfo, InterFreqCarrierFreqInfo_sequence);

  return offset;
}


static const per_sequence_t InterFreqCarrierFreqList_sequence_of[1] = {
  { &hf_nr_rrc_InterFreqCarrierFreqList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_InterFreqCarrierFreqInfo },
};

static int
dissect_nr_rrc_InterFreqCarrierFreqList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_InterFreqCarrierFreqList, InterFreqCarrierFreqList_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const per_sequence_t SIB4_sequence[] = {
  { &hf_nr_rrc_interFreqCarrierFreqList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_InterFreqCarrierFreqList },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB4");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB4, SIB4_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M30_33(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30, 33U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_288(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 288U, NULL, FALSE);

  return offset;
}


static const per_sequence_t EUTRA_NS_PmaxValue_sequence[] = {
  { &hf_nr_rrc_additionalPmax_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_M30_33 },
  { &hf_nr_rrc_additionalSpectrumEmission_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_288 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EUTRA_NS_PmaxValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EUTRA_NS_PmaxValue, EUTRA_NS_PmaxValue_sequence);

  return offset;
}


static const per_sequence_t EUTRA_NS_PmaxList_sequence_of[1] = {
  { &hf_nr_rrc_EUTRA_NS_PmaxList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_NS_PmaxValue },
};

static int
dissect_nr_rrc_EUTRA_NS_PmaxList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_EUTRA_NS_PmaxList, EUTRA_NS_PmaxList_sequence_of,
                                                  1, maxEUTRA_NS_Pmax, FALSE);

  return offset;
}


static const per_sequence_t EUTRA_MultiBandInfo_sequence[] = {
  { &hf_nr_rrc_eutra_FreqBandIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqBandIndicatorEUTRA },
  { &hf_nr_rrc_eutra_NS_PmaxList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_EUTRA_NS_PmaxList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EUTRA_MultiBandInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EUTRA_MultiBandInfo, EUTRA_MultiBandInfo_sequence);

  return offset;
}


static const per_sequence_t EUTRA_MultiBandInfoList_sequence_of[1] = {
  { &hf_nr_rrc_EUTRA_MultiBandInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_MultiBandInfo },
};

static int
dissect_nr_rrc_EUTRA_MultiBandInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_EUTRA_MultiBandInfoList, EUTRA_MultiBandInfoList_sequence_of,
                                                  1, maxMultiBands, FALSE);

  return offset;
}


static const value_string nr_rrc_EUTRA_Q_OffsetRange_vals[] = {
  {   0, "dB-24" },
  {   1, "dB-22" },
  {   2, "dB-20" },
  {   3, "dB-18" },
  {   4, "dB-16" },
  {   5, "dB-14" },
  {   6, "dB-12" },
  {   7, "dB-10" },
  {   8, "dB-8" },
  {   9, "dB-6" },
  {  10, "dB-5" },
  {  11, "dB-4" },
  {  12, "dB-3" },
  {  13, "dB-2" },
  {  14, "dB-1" },
  {  15, "dB0" },
  {  16, "dB1" },
  {  17, "dB2" },
  {  18, "dB3" },
  {  19, "dB4" },
  {  20, "dB5" },
  {  21, "dB6" },
  {  22, "dB8" },
  {  23, "dB10" },
  {  24, "dB12" },
  {  25, "dB14" },
  {  26, "dB16" },
  {  27, "dB18" },
  {  28, "dB20" },
  {  29, "dB22" },
  {  30, "dB24" },
  { 0, NULL }
};

static value_string_ext nr_rrc_EUTRA_Q_OffsetRange_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_EUTRA_Q_OffsetRange_vals);


static int
dissect_nr_rrc_EUTRA_Q_OffsetRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_FreqNeighCellInfo_sequence[] = {
  { &hf_nr_rrc_physCellId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { &hf_nr_rrc_dummy        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_Q_OffsetRange },
  { &hf_nr_rrc_q_RxLevMinOffsetCell, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_QualMinOffsetCell, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EUTRA_FreqNeighCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EUTRA_FreqNeighCellInfo, EUTRA_FreqNeighCellInfo_sequence);

  return offset;
}


static const per_sequence_t EUTRA_FreqNeighCellList_sequence_of[1] = {
  { &hf_nr_rrc_EUTRA_FreqNeighCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_FreqNeighCellInfo },
};

static int
dissect_nr_rrc_EUTRA_FreqNeighCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_EUTRA_FreqNeighCellList, EUTRA_FreqNeighCellList_sequence_of,
                                                  1, maxCellEUTRA, FALSE);

  return offset;
}


static const value_string nr_rrc_T_range_01_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n24" },
  {   5, "n32" },
  {   6, "n48" },
  {   7, "n64" },
  {   8, "n84" },
  {   9, "n96" },
  {  10, "n128" },
  {  11, "n168" },
  {  12, "n252" },
  {  13, "n504" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_range_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_PhysCellIdRange_sequence[] = {
  { &hf_nr_rrc_start_01     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { &hf_nr_rrc_range_01     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_range_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EUTRA_PhysCellIdRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EUTRA_PhysCellIdRange, EUTRA_PhysCellIdRange_sequence);

  return offset;
}


static const per_sequence_t EUTRA_FreqBlackCellList_sequence_of[1] = {
  { &hf_nr_rrc_EUTRA_FreqBlackCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellIdRange },
};

static int
dissect_nr_rrc_EUTRA_FreqBlackCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_EUTRA_FreqBlackCellList, EUTRA_FreqBlackCellList_sequence_of,
                                                  1, maxEUTRA_CellBlack, FALSE);

  return offset;
}


static const value_string nr_rrc_EUTRA_AllowedMeasBandwidth_vals[] = {
  {   0, "mbw6" },
  {   1, "mbw15" },
  {   2, "mbw25" },
  {   3, "mbw50" },
  {   4, "mbw75" },
  {   5, "mbw100" },
  { 0, NULL }
};


static int
dissect_nr_rrc_EUTRA_AllowedMeasBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_EUTRA_PresenceAntennaPort1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M70_M22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -70, -22, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M34_M3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -34, -3, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_threshX_Q_01_sequence[] = {
  { &hf_nr_rrc_threshX_HighQ, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThresholdQ },
  { &hf_nr_rrc_threshX_LowQ , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThresholdQ },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_threshX_Q_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_threshX_Q_01, T_threshX_Q_01_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqEUTRA_sequence[] = {
  { &hf_nr_rrc_carrierFreq_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_eutra_multiBandInfoList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_EUTRA_MultiBandInfoList },
  { &hf_nr_rrc_eutra_FreqNeighCellList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_EUTRA_FreqNeighCellList },
  { &hf_nr_rrc_eutra_BlackCellList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_EUTRA_FreqBlackCellList },
  { &hf_nr_rrc_allowedMeasBandwidth, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_AllowedMeasBandwidth },
  { &hf_nr_rrc_presenceAntennaPort1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PresenceAntennaPort1 },
  { &hf_nr_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionPriority },
  { &hf_nr_rrc_cellReselectionSubPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionSubPriority },
  { &hf_nr_rrc_threshX_High , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_threshX_Low  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReselectionThreshold },
  { &hf_nr_rrc_q_RxLevMin_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M70_M22 },
  { &hf_nr_rrc_q_QualMin_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M34_M3 },
  { &hf_nr_rrc_p_MaxEUTRA   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M30_33 },
  { &hf_nr_rrc_threshX_Q_01 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_threshX_Q_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CarrierFreqEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CarrierFreqEUTRA, CarrierFreqEUTRA_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqListEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_CarrierFreqListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CarrierFreqEUTRA },
};

static int
dissect_nr_rrc_CarrierFreqListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_CarrierFreqListEUTRA, CarrierFreqListEUTRA_sequence_of,
                                                  1, maxEUTRA_Carrier, FALSE);

  return offset;
}


static const per_sequence_t SIB5_sequence[] = {
  { &hf_nr_rrc_carrierFreqListEUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CarrierFreqListEUTRA },
  { &hf_nr_rrc_t_ReselectionEUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_Reselection },
  { &hf_nr_rrc_t_ReselectionEUTRA_SF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SpeedStateScaleFactors },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB5");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB5, SIB5_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_messageIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *msg_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     16, 16, FALSE, NULL, 0, &msg_id_tvb, NULL);



  if (msg_id_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, msg_id_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}



static int
dissect_nr_rrc_T_serialNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *serial_nb_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, &serial_nb_tvb, NULL);



  if (serial_nb_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_serialNumber);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_gs, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_msg_code, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_upd_nb, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}



static int
dissect_nr_rrc_T_warningType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *warning_type_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, FALSE, &warning_type_tvb);



  if (warning_type_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_warningType);
    proto_tree_add_item(subtree, hf_nr_rrc_warningType_value, warning_type_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_warningType_emergency_user_alert, warning_type_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_warningType_popup, warning_type_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}


static const per_sequence_t SIB6_sequence[] = {
  { &hf_nr_rrc_messageIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_messageIdentifier },
  { &hf_nr_rrc_serialNumber , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_serialNumber },
  { &hf_nr_rrc_warningType  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_warningType },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB6");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB6, SIB6_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_messageIdentifier_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *msg_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     16, 16, FALSE, NULL, 0, &msg_id_tvb, NULL);



  if (msg_id_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    nr_priv->message_identifier = tvb_get_ntohs(msg_id_tvb, 0) << 16;
    actx->created_item = proto_tree_add_item(tree, hf_index, msg_id_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}



static int
dissect_nr_rrc_T_serialNumber_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *serial_nb_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, &serial_nb_tvb, NULL);



  if (serial_nb_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    nr_priv->message_identifier |= tvb_get_ntohs(serial_nb_tvb, 0);
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_serialNumber);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_gs, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_msg_code, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_upd_nb, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}


static const value_string nr_rrc_T_warningMessageSegmentType_vals[] = {
  {   0, "notLastSegment" },
  {   1, "lastSegment" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_warningMessageSegmentType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  guint32 segment_type;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, &segment_type, FALSE, 0, NULL);

  nr_priv->warning_message_segment_type = (guint8)segment_type;


  return offset;
}



static int
dissect_nr_rrc_T_warningMessageSegmentNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  guint32 segment_number;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, &segment_number, FALSE);

  nr_priv->warning_message_segment_number = (guint8)segment_number;


  return offset;
}



static int
dissect_nr_rrc_T_warningMessageSegment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *warning_msg_seg_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &warning_msg_seg_tvb);



  if (warning_msg_seg_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    tvbuff_t *frag_tvb;
    gpointer p_dcs;
    fragment_head *frag_data = fragment_add_seq_check(&nr_rrc_sib7_reassembly_table, warning_msg_seg_tvb, 0, actx->pinfo,
                                                      nr_priv->message_identifier, NULL,
                                                      nr_priv->warning_message_segment_number,
                                                      tvb_reported_length(warning_msg_seg_tvb),
                                                      nr_priv->warning_message_segment_type ? FALSE : TRUE);
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_warningMessageSegment);
    frag_tvb = process_reassembled_data(warning_msg_seg_tvb, 0, actx->pinfo, "Reassembled SIB7 warning message",
                                        frag_data, &nr_rrc_sib7_frag_items, NULL, subtree);
    p_dcs = wmem_map_lookup(nr_rrc_etws_cmas_dcs_hash, GUINT_TO_POINTER((guint)nr_priv->message_identifier));
    if (frag_tvb && p_dcs) {
      dissect_nr_rrc_warningMessageSegment(frag_tvb, subtree, actx->pinfo, GPOINTER_TO_UINT(p_dcs));
    }
  }

  return offset;
}



static int
dissect_nr_rrc_T_dataCodingScheme(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *data_coding_scheme_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, FALSE, &data_coding_scheme_tvb);



  if (data_coding_scheme_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    guint32 dataCodingScheme;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_dataCodingScheme);
    dataCodingScheme = dissect_cbs_data_coding_scheme(data_coding_scheme_tvb, actx->pinfo, subtree, 0);
    wmem_map_insert(nr_rrc_etws_cmas_dcs_hash, GUINT_TO_POINTER((guint)nr_priv->message_identifier),
                    GUINT_TO_POINTER(dataCodingScheme));
  }

  return offset;
}


static const per_sequence_t SIB7_sequence[] = {
  { &hf_nr_rrc_messageIdentifier_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_messageIdentifier_01 },
  { &hf_nr_rrc_serialNumber_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_serialNumber_01 },
  { &hf_nr_rrc_warningMessageSegmentType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_warningMessageSegmentType },
  { &hf_nr_rrc_warningMessageSegmentNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_warningMessageSegmentNumber },
  { &hf_nr_rrc_warningMessageSegment, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_warningMessageSegment },
  { &hf_nr_rrc_dataCodingScheme, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_dataCodingScheme },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB7");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB7, SIB7_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_messageIdentifier_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *msg_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     16, 16, FALSE, NULL, 0, &msg_id_tvb, NULL);



  if (msg_id_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    nr_priv->message_identifier = tvb_get_ntohs(msg_id_tvb, 0) << 16;
    actx->created_item = proto_tree_add_item(tree, hf_index, msg_id_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}



static int
dissect_nr_rrc_T_serialNumber_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *serial_nb_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, &serial_nb_tvb, NULL);



  if (serial_nb_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    nr_priv->message_identifier |= tvb_get_ntohs(serial_nb_tvb, 0);
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_serialNumber);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_gs, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_msg_code, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_nr_rrc_serialNumber_upd_nb, serial_nb_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}


static const value_string nr_rrc_T_warningMessageSegmentType_01_vals[] = {
  {   0, "notLastSegment" },
  {   1, "lastSegment" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_warningMessageSegmentType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  guint32 segment_type;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, &segment_type, FALSE, 0, NULL);

  nr_priv->warning_message_segment_type = (guint8)segment_type;


  return offset;
}



static int
dissect_nr_rrc_T_warningMessageSegmentNumber_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  guint32 segment_number;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, &segment_number, FALSE);

  nr_priv->warning_message_segment_number = (guint8)segment_number;


  return offset;
}



static int
dissect_nr_rrc_T_warningMessageSegment_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *warning_msg_seg_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &warning_msg_seg_tvb);



  if (warning_msg_seg_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    tvbuff_t *frag_tvb;
    gpointer p_dcs;
    fragment_head *frag_data = fragment_add_seq_check(&nr_rrc_sib8_reassembly_table, warning_msg_seg_tvb, 0, actx->pinfo,
                                                      nr_priv->message_identifier, NULL,
                                                      nr_priv->warning_message_segment_number,
                                                      tvb_reported_length(warning_msg_seg_tvb),
                                                      nr_priv->warning_message_segment_type ? FALSE : TRUE);
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_warningMessageSegment);
    frag_tvb = process_reassembled_data(warning_msg_seg_tvb, 0, actx->pinfo, "Reassembled SIB8 warning message",
                                        frag_data, &nr_rrc_sib8_frag_items, NULL, subtree);
    p_dcs = wmem_map_lookup(nr_rrc_etws_cmas_dcs_hash, GUINT_TO_POINTER((guint)nr_priv->message_identifier));
    if (frag_tvb && p_dcs) {
      dissect_nr_rrc_warningMessageSegment(frag_tvb, subtree, actx->pinfo, GPOINTER_TO_UINT(p_dcs));
    }
  }

  return offset;
}



static int
dissect_nr_rrc_T_dataCodingScheme_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *data_coding_scheme_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, FALSE, &data_coding_scheme_tvb);



  if (data_coding_scheme_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    guint32 dataCodingScheme;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_dataCodingScheme);
    dataCodingScheme = dissect_cbs_data_coding_scheme(data_coding_scheme_tvb, actx->pinfo, subtree, 0);
    wmem_map_insert(nr_rrc_etws_cmas_dcs_hash, GUINT_TO_POINTER((guint)nr_priv->message_identifier),
                    GUINT_TO_POINTER(dataCodingScheme));
  }

  return offset;
}


static const per_sequence_t SIB8_sequence[] = {
  { &hf_nr_rrc_messageIdentifier_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_messageIdentifier_02 },
  { &hf_nr_rrc_serialNumber_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_serialNumber_02 },
  { &hf_nr_rrc_warningMessageSegmentType_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_warningMessageSegmentType_01 },
  { &hf_nr_rrc_warningMessageSegmentNumber_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_warningMessageSegmentNumber_01 },
  { &hf_nr_rrc_warningMessageSegment_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_warningMessageSegment_01 },
  { &hf_nr_rrc_dataCodingScheme_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_dataCodingScheme_01 },
  { &hf_nr_rrc_warningAreaCoordinatesSegment, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB8");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB8, SIB8_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_timeInfoUTC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint64 timeInfo;
  proto_tree *subtree;
  nstime_t ts;
  guint32 old_offset = offset;
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(549755813887), &timeInfo, FALSE);



  subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_timeInfo);
  ts.secs = (time_t)(timeInfo/100)-2208988800U; /* epoch is 00:00:00 (midnight) UTC on 1900-01-01 */
  ts.nsecs = (int)(timeInfo%100)*10000000;
  proto_tree_add_time(subtree, hf_nr_rrc_utc_time, tvb, old_offset>>3, (old_offset&0x07) ? 6 : 5, &ts);
  proto_tree_add_time(subtree, hf_nr_rrc_local_time, tvb, old_offset>>3, (old_offset&0x07) ? 6 : 5, &ts);

  return offset;
}



static int
dissect_nr_rrc_T_dayLightSavingTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *daylight_saving_time_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, FALSE, NULL, 0, &daylight_saving_time_tvb, NULL);



  if (daylight_saving_time_tvb) {
    guint bitvalue = tvb_get_bits8(daylight_saving_time_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, daylight_saving_time_tvb, 0, 1, bitvalue);
  }

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M127_128(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 128U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M63_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -63, 64U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_timeInfo_sequence[] = {
  { &hf_nr_rrc_timeInfoUTC  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_timeInfoUTC },
  { &hf_nr_rrc_dayLightSavingTime, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dayLightSavingTime },
  { &hf_nr_rrc_leapSeconds  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_M127_128 },
  { &hf_nr_rrc_localTimeOffset, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_M63_64 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_timeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_timeInfo, T_timeInfo_sequence);

  return offset;
}


static const per_sequence_t SIB9_sequence[] = {
  { &hf_nr_rrc_timeInfo     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_timeInfo },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_str(actx->pinfo->cinfo, COL_INFO, " SIB9");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB9, SIB9_sequence);

  return offset;
}


static const value_string nr_rrc_T_sib_TypeAndInfo_item_vals[] = {
  {   0, "sib2" },
  {   1, "sib3" },
  {   2, "sib4" },
  {   3, "sib5" },
  {   4, "sib6" },
  {   5, "sib7" },
  {   6, "sib8" },
  {   7, "sib9" },
  { 0, NULL }
};

static const per_choice_t T_sib_TypeAndInfo_item_choice[] = {
  {   0, &hf_nr_rrc_sib2         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB2 },
  {   1, &hf_nr_rrc_sib3         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB3 },
  {   2, &hf_nr_rrc_sib4         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB4 },
  {   3, &hf_nr_rrc_sib5         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB5 },
  {   4, &hf_nr_rrc_sib6         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB6 },
  {   5, &hf_nr_rrc_sib7         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB7 },
  {   6, &hf_nr_rrc_sib8         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB8 },
  {   7, &hf_nr_rrc_sib9         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_SIB9 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_sib_TypeAndInfo_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_sib_TypeAndInfo_item, T_sib_TypeAndInfo_item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_sib_TypeAndInfo_sequence_of[1] = {
  { &hf_nr_rrc_sib_TypeAndInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sib_TypeAndInfo_item },
};

static int
dissect_nr_rrc_T_sib_TypeAndInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sib_TypeAndInfo, T_sib_TypeAndInfo_sequence_of,
                                                  1, maxSIB, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_31_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_31, T_nonCriticalExtension_31_sequence);

  return offset;
}


static const per_sequence_t SystemInformation_IEs_sequence[] = {
  { &hf_nr_rrc_sib_TypeAndInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sib_TypeAndInfo },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_44, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SystemInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SystemInformation_IEs, SystemInformation_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_30_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_30, T_criticalExtensionsFuture_30_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_30_vals[] = {
  {   0, "systemInformation" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_30_choice[] = {
  {   0, &hf_nr_rrc_systemInformation_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SystemInformation_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_30, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_30 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_30, T_criticalExtensions_30_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SystemInformation_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_30, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_30 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SystemInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "System Information [");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SystemInformation, SystemInformation_sequence);

  col_append_str(actx->pinfo->cinfo, COL_INFO, " ]");

  return offset;
}


static const per_sequence_t T_cellSelectionInfo_sequence[] = {
  { &hf_nr_rrc_q_RxLevMin   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_RxLevMinOffset, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { &hf_nr_rrc_q_RxLevMinSUL, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_RxLevMin },
  { &hf_nr_rrc_q_QualMin    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_QualMin },
  { &hf_nr_rrc_q_QualMinOffset, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_cellSelectionInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_cellSelectionInfo, T_cellSelectionInfo_sequence);

  return offset;
}


static const value_string nr_rrc_T_cellReservedForOtherUse_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cellReservedForOtherUse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CellAccessRelatedInfo_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PLMN_IdentityInfoList },
  { &hf_nr_rrc_cellReservedForOtherUse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_cellReservedForOtherUse },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CellAccessRelatedInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CellAccessRelatedInfo, CellAccessRelatedInfo_sequence);

  return offset;
}


static const value_string nr_rrc_T_connEstFailCount_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_connEstFailCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_connEstFailOffsetValidity_vals[] = {
  {   0, "s30" },
  {   1, "s60" },
  {   2, "s120" },
  {   3, "s240" },
  {   4, "s300" },
  {   5, "s420" },
  {   6, "s600" },
  {   7, "s900" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_connEstFailOffsetValidity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ConnEstFailureControl_sequence[] = {
  { &hf_nr_rrc_connEstFailCount, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_connEstFailCount },
  { &hf_nr_rrc_connEstFailOffsetValidity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_connEstFailOffsetValidity },
  { &hf_nr_rrc_connEstFailOffset, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ConnEstFailureControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ConnEstFailureControl, ConnEstFailureControl_sequence);

  return offset;
}


static const value_string nr_rrc_T_si_BroadcastStatus_vals[] = {
  {   0, "broadcasting" },
  {   1, "notBroadcasting" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_si_BroadcastStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_si_Periodicity_vals[] = {
  {   0, "rf8" },
  {   1, "rf16" },
  {   2, "rf32" },
  {   3, "rf64" },
  {   4, "rf128" },
  {   5, "rf256" },
  {   6, "rf512" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_si_Periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_type_vals[] = {
  {   0, "sibType2" },
  {   1, "sibType3" },
  {   2, "sibType4" },
  {   3, "sibType5" },
  {   4, "sibType6" },
  {   5, "sibType7" },
  {   6, "sibType8" },
  {   7, "sibType9" },
  {   8, "spare8" },
  {   9, "spare7" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_areaScope_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_areaScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SIB_TypeInfo_sequence[] = {
  { &hf_nr_rrc_type         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_type },
  { &hf_nr_rrc_valueTag     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_31 },
  { &hf_nr_rrc_areaScope    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_areaScope },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB_TypeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB_TypeInfo, SIB_TypeInfo_sequence);

  return offset;
}


static const per_sequence_t SIB_Mapping_sequence_of[1] = {
  { &hf_nr_rrc_SIB_Mapping_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SIB_TypeInfo },
};

static int
dissect_nr_rrc_SIB_Mapping(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SIB_Mapping, SIB_Mapping_sequence_of,
                                                  1, maxSIB, FALSE);

  return offset;
}


static const per_sequence_t SchedulingInfo_sequence[] = {
  { &hf_nr_rrc_si_BroadcastStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_si_BroadcastStatus },
  { &hf_nr_rrc_si_Periodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_si_Periodicity },
  { &hf_nr_rrc_sib_MappingInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SIB_Mapping },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SchedulingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SchedulingInfo, SchedulingInfo_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo_sequence_of[1] = {
  { &hf_nr_rrc_schedulingInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SchedulingInfo },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo, SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo_sequence_of,
                                                  1, maxSI_Message, FALSE);

  return offset;
}


static const value_string nr_rrc_T_si_WindowLength_vals[] = {
  {   0, "s5" },
  {   1, "s10" },
  {   2, "s20" },
  {   3, "s40" },
  {   4, "s80" },
  {   5, "s160" },
  {   6, "s320" },
  {   7, "s640" },
  {   8, "s1280" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_si_WindowLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_msg1_FDM_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "four" },
  {   3, "eight" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_msg1_FDM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_maxNrofPhysicalResourceBlocks_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofPhysicalResourceBlocks_1, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M202_M60(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -202, -60, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_preambleTransMax_vals[] = {
  {   0, "n3" },
  {   1, "n4" },
  {   2, "n5" },
  {   3, "n6" },
  {   4, "n7" },
  {   5, "n8" },
  {   6, "n10" },
  {   7, "n20" },
  {   8, "n50" },
  {   9, "n100" },
  {  10, "n200" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_preambleTransMax(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_powerRampingStep_vals[] = {
  {   0, "dB0" },
  {   1, "dB2" },
  {   2, "dB4" },
  {   3, "dB6" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_powerRampingStep(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_ra_ResponseWindow_vals[] = {
  {   0, "sl1" },
  {   1, "sl2" },
  {   2, "sl4" },
  {   3, "sl8" },
  {   4, "sl10" },
  {   5, "sl20" },
  {   6, "sl40" },
  {   7, "sl80" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ra_ResponseWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RACH_ConfigGeneric_sequence[] = {
  { &hf_nr_rrc_prach_ConfigurationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_255 },
  { &hf_nr_rrc_msg1_FDM     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_msg1_FDM },
  { &hf_nr_rrc_msg1_FrequencyStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_maxNrofPhysicalResourceBlocks_1 },
  { &hf_nr_rrc_zeroCorrelationZoneConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_15 },
  { &hf_nr_rrc_preambleReceivedTargetPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M202_M60 },
  { &hf_nr_rrc_preambleTransMax, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_preambleTransMax },
  { &hf_nr_rrc_powerRampingStep, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_powerRampingStep },
  { &hf_nr_rrc_ra_ResponseWindow, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ra_ResponseWindow },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RACH_ConfigGeneric(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RACH_ConfigGeneric, RACH_ConfigGeneric_sequence);

  return offset;
}


static const value_string nr_rrc_T_ssb_perRACH_Occasion_02_vals[] = {
  {   0, "oneEighth" },
  {   1, "oneFourth" },
  {   2, "oneHalf" },
  {   3, "one" },
  {   4, "two" },
  {   5, "four" },
  {   6, "eight" },
  {   7, "sixteen" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ssb_perRACH_Occasion_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_rach_OccasionsSI_sequence[] = {
  { &hf_nr_rrc_rach_ConfigSI, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RACH_ConfigGeneric },
  { &hf_nr_rrc_ssb_perRACH_Occasion_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ssb_perRACH_Occasion_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_rach_OccasionsSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_rach_OccasionsSI, T_rach_OccasionsSI_sequence);

  return offset;
}


static const value_string nr_rrc_T_si_RequestPeriod_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "four" },
  {   3, "six" },
  {   4, "eight" },
  {   5, "ten" },
  {   6, "twelve" },
  {   7, "sixteen" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_si_RequestPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SI_RequestResources_sequence[] = {
  { &hf_nr_rrc_ra_PreambleStartIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_63 },
  { &hf_nr_rrc_ra_AssociationPeriodIndex, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_15 },
  { &hf_nr_rrc_ra_ssb_OccasionMaskIndex, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SI_RequestResources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SI_RequestResources, SI_RequestResources_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources_sequence_of[1] = {
  { &hf_nr_rrc_si_RequestResources_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SI_RequestResources },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources, SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources_sequence_of,
                                                  1, maxSI_Message, FALSE);

  return offset;
}


static const per_sequence_t SI_RequestConfig_sequence[] = {
  { &hf_nr_rrc_rach_OccasionsSI, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_rach_OccasionsSI },
  { &hf_nr_rrc_si_RequestPeriod, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_si_RequestPeriod },
  { &hf_nr_rrc_si_RequestResources, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SI_RequestConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SI_RequestConfig, SI_RequestConfig_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SI_SchedulingInfo_sequence[] = {
  { &hf_nr_rrc_schedulingInfoList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo },
  { &hf_nr_rrc_si_WindowLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_si_WindowLength },
  { &hf_nr_rrc_si_RequestConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SI_RequestConfig },
  { &hf_nr_rrc_si_RequestConfigSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SI_RequestConfig },
  { &hf_nr_rrc_systemInformationAreaID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_BIT_STRING_SIZE_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SI_SchedulingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SI_SchedulingInfo, SI_SchedulingInfo_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2199(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxNrofPhysicalResourceBlocks(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrofPhysicalResourceBlocks, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SCS_SpecificCarrier_eag_1_sequence[] = {
  { &hf_nr_rrc_txDirectCurrentLocation_v1530, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_4095 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SCS_SpecificCarrier_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SCS_SpecificCarrier_eag_1_sequence);

  return offset;
}


static const per_sequence_t SCS_SpecificCarrier_sequence[] = {
  { &hf_nr_rrc_offsetToCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_2199 },
  { &hf_nr_rrc_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_carrierBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxNrofPhysicalResourceBlocks },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_SCS_SpecificCarrier_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SCS_SpecificCarrier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SCS_SpecificCarrier, SCS_SpecificCarrier_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier_sequence_of[1] = {
  { &hf_nr_rrc_scs_SpecificCarrierList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SCS_SpecificCarrier },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier, SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier_sequence_of,
                                                  1, maxSCSs, FALSE);

  return offset;
}


static const per_sequence_t FrequencyInfoDL_SIB_sequence[] = {
  { &hf_nr_rrc_frequencyBandList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_offsetToPointA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_2199 },
  { &hf_nr_rrc_scs_SpecificCarrierList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FrequencyInfoDL_SIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FrequencyInfoDL_SIB, FrequencyInfoDL_SIB_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_37949(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37949U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_cyclicPrefix_vals[] = {
  {   0, "extended" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cyclicPrefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t BWP_sequence[] = {
  { &hf_nr_rrc_locationAndBandwidth, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_37949 },
  { &hf_nr_rrc_subcarrierSpacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_cyclicPrefix , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cyclicPrefix },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BWP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BWP, BWP_sequence);

  return offset;
}



static int
dissect_nr_rrc_ControlResourceSetId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofControlResourceSets_1, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_45(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     45, 45, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxCoReSetDuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCoReSetDuration, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_reg_BundleSize_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n6" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reg_BundleSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_interleaverSize_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n6" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_interleaverSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_interleaved_sequence[] = {
  { &hf_nr_rrc_reg_BundleSize, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reg_BundleSize },
  { &hf_nr_rrc_interleaverSize, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_interleaverSize },
  { &hf_nr_rrc_shiftIndex   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_maxNrofPhysicalResourceBlocks_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_interleaved(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_interleaved, T_interleaved_sequence);

  return offset;
}


static const value_string nr_rrc_T_cce_REG_MappingType_vals[] = {
  {   0, "interleaved" },
  {   1, "nonInterleaved" },
  { 0, NULL }
};

static const per_choice_t T_cce_REG_MappingType_choice[] = {
  {   0, &hf_nr_rrc_interleaved  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_interleaved },
  {   1, &hf_nr_rrc_nonInterleaved, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_cce_REG_MappingType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_cce_REG_MappingType, T_cce_REG_MappingType_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_precoderGranularity_vals[] = {
  {   0, "sameAsREG-bundle" },
  {   1, "allContiguousRBs" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_precoderGranularity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_TCI_StateId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofTCI_States_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId_sequence_of[1] = {
  { &hf_nr_rrc_tci_StatesPDCCH_ToAddList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TCI_StateId },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId, SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId_sequence_of,
                                                  1, maxNrofTCI_StatesPDCCH, FALSE);

  return offset;
}


static const value_string nr_rrc_T_tci_PresentInDCI_vals[] = {
  {   0, "enabled" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_tci_PresentInDCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ControlResourceSet_sequence[] = {
  { &hf_nr_rrc_controlResourceSetId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ControlResourceSetId },
  { &hf_nr_rrc_frequencyDomainResources, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_45 },
  { &hf_nr_rrc_duration     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxCoReSetDuration },
  { &hf_nr_rrc_cce_REG_MappingType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_cce_REG_MappingType },
  { &hf_nr_rrc_precoderGranularity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_precoderGranularity },
  { &hf_nr_rrc_tci_StatesPDCCH_ToAddList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId },
  { &hf_nr_rrc_tci_StatesPDCCH_ToReleaseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId },
  { &hf_nr_rrc_tci_PresentInDCI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_tci_PresentInDCI },
  { &hf_nr_rrc_pdcch_DMRS_ScramblingID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_65535 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ControlResourceSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ControlResourceSet, ControlResourceSet_sequence);

  return offset;
}



static int
dissect_nr_rrc_SearchSpaceId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSearchSpaces_1, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_monitoringSlotPeriodicityAndOffset_vals[] = {
  {   0, "sl1" },
  {   1, "sl2" },
  {   2, "sl4" },
  {   3, "sl5" },
  {   4, "sl8" },
  {   5, "sl10" },
  {   6, "sl16" },
  {   7, "sl20" },
  {   8, "sl40" },
  {   9, "sl80" },
  {  10, "sl160" },
  {  11, "sl320" },
  {  12, "sl640" },
  {  13, "sl1280" },
  {  14, "sl2560" },
  { 0, NULL }
};

static const per_choice_t T_monitoringSlotPeriodicityAndOffset_choice[] = {
  {   0, &hf_nr_rrc_sl1          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_sl2          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1 },
  {   2, &hf_nr_rrc_sl4          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_3 },
  {   3, &hf_nr_rrc_sl5          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_4 },
  {   4, &hf_nr_rrc_sl8          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_7 },
  {   5, &hf_nr_rrc_sl10         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_9 },
  {   6, &hf_nr_rrc_sl16         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_15 },
  {   7, &hf_nr_rrc_sl20         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_19 },
  {   8, &hf_nr_rrc_sl40         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   9, &hf_nr_rrc_sl80         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {  10, &hf_nr_rrc_sl160        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  {  11, &hf_nr_rrc_sl320        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_319 },
  {  12, &hf_nr_rrc_sl640        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_639 },
  {  13, &hf_nr_rrc_sl1280       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1279 },
  {  14, &hf_nr_rrc_sl2560       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_2559 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_monitoringSlotPeriodicityAndOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_monitoringSlotPeriodicityAndOffset, T_monitoringSlotPeriodicityAndOffset_choice,
                                 NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_2_2559(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 2559U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     14, 14, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel1_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel2_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel4_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel8_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel16_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nrofCandidates_sequence[] = {
  { &hf_nr_rrc_aggregationLevel1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_aggregationLevel1 },
  { &hf_nr_rrc_aggregationLevel2, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_aggregationLevel2 },
  { &hf_nr_rrc_aggregationLevel4, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_aggregationLevel4 },
  { &hf_nr_rrc_aggregationLevel8, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_aggregationLevel8 },
  { &hf_nr_rrc_aggregationLevel16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_aggregationLevel16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nrofCandidates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nrofCandidates, T_nrofCandidates_sequence);

  return offset;
}


static const per_sequence_t T_dci_Format0_0_AndFormat1_0_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_nr_rrc_T_dci_Format0_0_AndFormat1_0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_dci_Format0_0_AndFormat1_0, T_dci_Format0_0_AndFormat1_0_sequence);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel1_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel2_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel2_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel4_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel4_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel8_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel8_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_aggregationLevel16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_aggregationLevel16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nrofCandidates_SFI_sequence[] = {
  { &hf_nr_rrc_aggregationLevel1_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_aggregationLevel1_01 },
  { &hf_nr_rrc_aggregationLevel2_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_aggregationLevel2_01 },
  { &hf_nr_rrc_aggregationLevel4_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_aggregationLevel4_01 },
  { &hf_nr_rrc_aggregationLevel8_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_aggregationLevel8_01 },
  { &hf_nr_rrc_aggregationLevel16_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_aggregationLevel16_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nrofCandidates_SFI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nrofCandidates_SFI, T_nrofCandidates_SFI_sequence);

  return offset;
}


static const per_sequence_t T_dci_Format2_0_sequence[] = {
  { &hf_nr_rrc_nrofCandidates_SFI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_nrofCandidates_SFI },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_dci_Format2_0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_dci_Format2_0, T_dci_Format2_0_sequence);

  return offset;
}


static const per_sequence_t T_dci_Format2_1_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_nr_rrc_T_dci_Format2_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_dci_Format2_1, T_dci_Format2_1_sequence);

  return offset;
}


static const per_sequence_t T_dci_Format2_2_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_nr_rrc_T_dci_Format2_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_dci_Format2_2, T_dci_Format2_2_sequence);

  return offset;
}


static const value_string nr_rrc_T_dummy1_vals[] = {
  {   0, "sl1" },
  {   1, "sl2" },
  {   2, "sl4" },
  {   3, "sl5" },
  {   4, "sl8" },
  {   5, "sl10" },
  {   6, "sl16" },
  {   7, "sl20" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dummy1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dummy2_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dummy2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_dci_Format2_3_sequence[] = {
  { &hf_nr_rrc_dummy1       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_dummy1 },
  { &hf_nr_rrc_dummy2       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_dummy2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_dci_Format2_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_dci_Format2_3, T_dci_Format2_3_sequence);

  return offset;
}


static const per_sequence_t T_common_sequence[] = {
  { &hf_nr_rrc_dci_Format0_0_AndFormat1_0, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dci_Format0_0_AndFormat1_0 },
  { &hf_nr_rrc_dci_Format2_0, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dci_Format2_0 },
  { &hf_nr_rrc_dci_Format2_1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dci_Format2_1 },
  { &hf_nr_rrc_dci_Format2_2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dci_Format2_2 },
  { &hf_nr_rrc_dci_Format2_3, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dci_Format2_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_common, T_common_sequence);

  return offset;
}


static const value_string nr_rrc_T_dci_Formats_vals[] = {
  {   0, "formats0-0-And-1-0" },
  {   1, "formats0-1-And-1-1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dci_Formats(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ue_Specific_sequence[] = {
  { &hf_nr_rrc_dci_Formats  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_dci_Formats },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_ue_Specific(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_ue_Specific, T_ue_Specific_sequence);

  return offset;
}


static const value_string nr_rrc_T_searchSpaceType_vals[] = {
  {   0, "common" },
  {   1, "ue-Specific" },
  { 0, NULL }
};

static const per_choice_t T_searchSpaceType_choice[] = {
  {   0, &hf_nr_rrc_common       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_common },
  {   1, &hf_nr_rrc_ue_Specific  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_ue_Specific },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_searchSpaceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_searchSpaceType, T_searchSpaceType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SearchSpace_sequence[] = {
  { &hf_nr_rrc_searchSpaceId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SearchSpaceId },
  { &hf_nr_rrc_controlResourceSetId, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ControlResourceSetId },
  { &hf_nr_rrc_monitoringSlotPeriodicityAndOffset, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_monitoringSlotPeriodicityAndOffset },
  { &hf_nr_rrc_duration_01  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_2_2559 },
  { &hf_nr_rrc_monitoringSymbolsWithinSlot, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_BIT_STRING_SIZE_14 },
  { &hf_nr_rrc_nrofCandidates, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nrofCandidates },
  { &hf_nr_rrc_searchSpaceType, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_searchSpaceType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SearchSpace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SearchSpace, SearchSpace_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_4_OF_SearchSpace_sequence_of[1] = {
  { &hf_nr_rrc_commonSearchSpaceList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SearchSpace },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_4_OF_SearchSpace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_4_OF_SearchSpace, SEQUENCE_SIZE_1_4_OF_SearchSpace_sequence_of,
                                                  1, 4, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_139(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 139U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS15KHZoneT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS15KHZoneT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_139 },
};

static int
dissect_nr_rrc_T_sCS15KHZoneT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS15KHZoneT_01, T_sCS15KHZoneT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_279(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 279U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS30KHZoneT_SCS15KHZhalfT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_279 },
};

static int
dissect_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT_01, T_sCS30KHZoneT_SCS15KHZhalfT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_559(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 559U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_559 },
};

static int
dissect_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01, T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_1119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1119U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1119 },
};

static int
dissect_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01, T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2239(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2239U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_2239 },
};

static int
dissect_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01, T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_4479(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4479U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_4479 },
};

static int
dissect_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01, T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_8959(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8959U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_8959 },
};

static int
dissect_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01, T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_17919(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 17919U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZoneSixteenthT_01_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_17919 },
};

static int
dissect_nr_rrc_T_sCS120KHZoneSixteenthT_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZoneSixteenthT_01, T_sCS120KHZoneSixteenthT_01_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const value_string nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO_01_vals[] = {
  {   0, "sCS15KHZoneT" },
  {   1, "sCS30KHZoneT-SCS15KHZhalfT" },
  {   2, "sCS60KHZoneT-SCS30KHZhalfT-SCS15KHZquarterT" },
  {   3, "sCS120KHZoneT-SCS60KHZhalfT-SCS30KHZquarterT-SCS15KHZoneEighthT" },
  {   4, "sCS120KHZhalfT-SCS60KHZquarterT-SCS30KHZoneEighthT-SCS15KHZoneSixteenthT" },
  {   5, "sCS120KHZquarterT-SCS60KHZoneEighthT-SCS30KHZoneSixteenthT" },
  {   6, "sCS120KHZoneEighthT-SCS60KHZoneSixteenthT" },
  {   7, "sCS120KHZoneSixteenthT" },
  { 0, NULL }
};

static const per_choice_t T_firstPDCCH_MonitoringOccasionOfPO_01_choice[] = {
  {   0, &hf_nr_rrc_sCS15KHZoneT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS15KHZoneT_01 },
  {   1, &hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT_01 },
  {   2, &hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 },
  {   3, &hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 },
  {   4, &hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 },
  {   5, &hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 },
  {   6, &hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 },
  {   7, &hf_nr_rrc_sCS120KHZoneSixteenthT_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZoneSixteenthT_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO_01, T_firstPDCCH_MonitoringOccasionOfPO_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PDCCH_ConfigCommon_eag_1_sequence[] = {
  { &hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDCCH_ConfigCommon_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PDCCH_ConfigCommon_eag_1_sequence);

  return offset;
}


static const per_sequence_t PDCCH_ConfigCommon_sequence[] = {
  { &hf_nr_rrc_controlResourceSetZero, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ControlResourceSetZero },
  { &hf_nr_rrc_commonControlResourceSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ControlResourceSet },
  { &hf_nr_rrc_searchSpaceZero, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SearchSpaceZero },
  { &hf_nr_rrc_commonSearchSpaceList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_4_OF_SearchSpace },
  { &hf_nr_rrc_searchSpaceSIB1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SearchSpaceId },
  { &hf_nr_rrc_searchSpaceOtherSystemInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SearchSpaceId },
  { &hf_nr_rrc_pagingSearchSpace, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SearchSpaceId },
  { &hf_nr_rrc_ra_SearchSpace, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SearchSpaceId },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDCCH_ConfigCommon_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDCCH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PDCCH_ConfigCommon, PDCCH_ConfigCommon_sequence);

  return offset;
}


static const value_string nr_rrc_T_pdcch_ConfigCommon_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_pdcch_ConfigCommon_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_03     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_PDCCH_ConfigCommon },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_pdcch_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_pdcch_ConfigCommon, T_pdcch_ConfigCommon_choice,
                                 NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_mappingType_vals[] = {
  {   0, "typeA" },
  {   1, "typeB" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mappingType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PDSCH_TimeDomainResourceAllocation_sequence[] = {
  { &hf_nr_rrc_k0           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_32 },
  { &hf_nr_rrc_mappingType  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mappingType },
  { &hf_nr_rrc_startSymbolAndLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDSCH_TimeDomainResourceAllocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PDSCH_TimeDomainResourceAllocation, PDSCH_TimeDomainResourceAllocation_sequence);

  return offset;
}


static const per_sequence_t PDSCH_TimeDomainResourceAllocationList_sequence_of[1] = {
  { &hf_nr_rrc_PDSCH_TimeDomainResourceAllocationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDSCH_TimeDomainResourceAllocation },
};

static int
dissect_nr_rrc_PDSCH_TimeDomainResourceAllocationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PDSCH_TimeDomainResourceAllocationList, PDSCH_TimeDomainResourceAllocationList_sequence_of,
                                                  1, maxNrofDL_Allocations, FALSE);

  return offset;
}


static const per_sequence_t PDSCH_ConfigCommon_sequence[] = {
  { &hf_nr_rrc_pdsch_TimeDomainAllocationList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PDSCH_TimeDomainResourceAllocationList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDSCH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PDSCH_ConfigCommon, PDSCH_ConfigCommon_sequence);

  return offset;
}


static const value_string nr_rrc_T_pdsch_ConfigCommon_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_pdsch_ConfigCommon_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_04     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_PDSCH_ConfigCommon },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_pdsch_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_pdsch_ConfigCommon, T_pdsch_ConfigCommon_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BWP_DownlinkCommon_sequence[] = {
  { &hf_nr_rrc_genericParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BWP },
  { &hf_nr_rrc_pdcch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_pdcch_ConfigCommon },
  { &hf_nr_rrc_pdsch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_pdsch_ConfigCommon },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BWP_DownlinkCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BWP_DownlinkCommon, BWP_DownlinkCommon_sequence);

  return offset;
}


static const value_string nr_rrc_T_modificationPeriodCoeff_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "n16" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_modificationPeriodCoeff(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t BCCH_Config_sequence[] = {
  { &hf_nr_rrc_modificationPeriodCoeff, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_modificationPeriodCoeff },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BCCH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BCCH_Config, BCCH_Config_sequence);

  return offset;
}


static const value_string nr_rrc_PagingCycle_vals[] = {
  {   0, "rf32" },
  {   1, "rf64" },
  {   2, "rf128" },
  {   3, "rf256" },
  { 0, NULL }
};


static int
dissect_nr_rrc_PagingCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_nAndPagingFrameOffset_vals[] = {
  {   0, "oneT" },
  {   1, "halfT" },
  {   2, "quarterT" },
  {   3, "oneEighthT" },
  {   4, "oneSixteenthT" },
  { 0, NULL }
};

static const per_choice_t T_nAndPagingFrameOffset_choice[] = {
  {   0, &hf_nr_rrc_oneT         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_halfT        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_1 },
  {   2, &hf_nr_rrc_quarterT     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_3 },
  {   3, &hf_nr_rrc_oneEighthT   , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_7 },
  {   4, &hf_nr_rrc_oneSixteenthT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_15 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_nAndPagingFrameOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_nAndPagingFrameOffset, T_nAndPagingFrameOffset_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_ns_vals[] = {
  {   0, "four" },
  {   1, "two" },
  {   2, "one" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ns(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_sCS15KHZoneT_sequence_of[1] = {
  { &hf_nr_rrc_sCS15KHZoneT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_139 },
};

static int
dissect_nr_rrc_T_sCS15KHZoneT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS15KHZoneT, T_sCS15KHZoneT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const per_sequence_t T_sCS30KHZoneT_SCS15KHZhalfT_sequence_of[1] = {
  { &hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_279 },
};

static int
dissect_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT, T_sCS30KHZoneT_SCS15KHZhalfT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const per_sequence_t T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_sequence_of[1] = {
  { &hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_559 },
};

static int
dissect_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT, T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1119 },
};

static int
dissect_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT, T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_2239 },
};

static int
dissect_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT, T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_4479 },
};

static int
dissect_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT, T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_8959 },
};

static int
dissect_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT, T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const per_sequence_t T_sCS120KHZoneSixteenthT_sequence_of[1] = {
  { &hf_nr_rrc_sCS120KHZoneSixteenthT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_17919 },
};

static int
dissect_nr_rrc_T_sCS120KHZoneSixteenthT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_T_sCS120KHZoneSixteenthT, T_sCS120KHZoneSixteenthT_sequence_of,
                                                  1, maxPO_perPF, FALSE);

  return offset;
}


static const value_string nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO_vals[] = {
  {   0, "sCS15KHZoneT" },
  {   1, "sCS30KHZoneT-SCS15KHZhalfT" },
  {   2, "sCS60KHZoneT-SCS30KHZhalfT-SCS15KHZquarterT" },
  {   3, "sCS120KHZoneT-SCS60KHZhalfT-SCS30KHZquarterT-SCS15KHZoneEighthT" },
  {   4, "sCS120KHZhalfT-SCS60KHZquarterT-SCS30KHZoneEighthT-SCS15KHZoneSixteenthT" },
  {   5, "sCS120KHZquarterT-SCS60KHZoneEighthT-SCS30KHZoneSixteenthT" },
  {   6, "sCS120KHZoneEighthT-SCS60KHZoneSixteenthT" },
  {   7, "sCS120KHZoneSixteenthT" },
  { 0, NULL }
};

static const per_choice_t T_firstPDCCH_MonitoringOccasionOfPO_choice[] = {
  {   0, &hf_nr_rrc_sCS15KHZoneT , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS15KHZoneT },
  {   1, &hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS30KHZoneT_SCS15KHZhalfT },
  {   2, &hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT },
  {   3, &hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT },
  {   4, &hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT },
  {   5, &hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT },
  {   6, &hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT },
  {   7, &hf_nr_rrc_sCS120KHZoneSixteenthT, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_sCS120KHZoneSixteenthT },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO, T_firstPDCCH_MonitoringOccasionOfPO_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PCCH_Config_sequence[] = {
  { &hf_nr_rrc_defaultPagingCycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PagingCycle },
  { &hf_nr_rrc_nAndPagingFrameOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_nAndPagingFrameOffset },
  { &hf_nr_rrc_ns           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ns },
  { &hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_firstPDCCH_MonitoringOccasionOfPO },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PCCH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PCCH_Config, PCCH_Config_sequence);

  return offset;
}


static const per_sequence_t DownlinkConfigCommonSIB_sequence[] = {
  { &hf_nr_rrc_frequencyInfoDL_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FrequencyInfoDL_SIB },
  { &hf_nr_rrc_initialDownlinkBWP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BWP_DownlinkCommon },
  { &hf_nr_rrc_bcch_Config  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BCCH_Config },
  { &hf_nr_rrc_pcch_Config  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCCH_Config },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DownlinkConfigCommonSIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DownlinkConfigCommonSIB, DownlinkConfigCommonSIB_sequence);

  return offset;
}


static const value_string nr_rrc_T_frequencyShift7p5khz_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_frequencyShift7p5khz_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t FrequencyInfoUL_SIB_sequence[] = {
  { &hf_nr_rrc_frequencyBandList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MultiFrequencyBandListNR_SIB },
  { &hf_nr_rrc_absoluteFrequencyPointA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_scs_SpecificCarrierList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier },
  { &hf_nr_rrc_p_Max        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_P_Max },
  { &hf_nr_rrc_frequencyShift7p5khz_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_frequencyShift7p5khz_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FrequencyInfoUL_SIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FrequencyInfoUL_SIB, FrequencyInfoUL_SIB_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_oneEighth_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n20" },
  {   5, "n24" },
  {   6, "n28" },
  {   7, "n32" },
  {   8, "n36" },
  {   9, "n40" },
  {  10, "n44" },
  {  11, "n48" },
  {  12, "n52" },
  {  13, "n56" },
  {  14, "n60" },
  {  15, "n64" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_oneEighth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_oneFourth_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n20" },
  {   5, "n24" },
  {   6, "n28" },
  {   7, "n32" },
  {   8, "n36" },
  {   9, "n40" },
  {  10, "n44" },
  {  11, "n48" },
  {  12, "n52" },
  {  13, "n56" },
  {  14, "n60" },
  {  15, "n64" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_oneFourth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_oneHalf_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n20" },
  {   5, "n24" },
  {   6, "n28" },
  {   7, "n32" },
  {   8, "n36" },
  {   9, "n40" },
  {  10, "n44" },
  {  11, "n48" },
  {  12, "n52" },
  {  13, "n56" },
  {  14, "n60" },
  {  15, "n64" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_oneHalf(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_one_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n20" },
  {   5, "n24" },
  {   6, "n28" },
  {   7, "n32" },
  {   8, "n36" },
  {   9, "n40" },
  {  10, "n44" },
  {  11, "n48" },
  {  12, "n52" },
  {  13, "n56" },
  {  14, "n60" },
  {  15, "n64" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_one(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_two_01_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n20" },
  {   5, "n24" },
  {   6, "n28" },
  {   7, "n32" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_two_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_vals[] = {
  {   0, "oneEighth" },
  {   1, "oneFourth" },
  {   2, "oneHalf" },
  {   3, "one" },
  {   4, "two" },
  {   5, "four" },
  {   6, "eight" },
  {   7, "sixteen" },
  { 0, NULL }
};

static const per_choice_t T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_choice[] = {
  {   0, &hf_nr_rrc_oneEighth    , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_oneEighth },
  {   1, &hf_nr_rrc_oneFourth    , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_oneFourth },
  {   2, &hf_nr_rrc_oneHalf      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_oneHalf },
  {   3, &hf_nr_rrc_one_01       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_one },
  {   4, &hf_nr_rrc_two_01       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_two_01 },
  {   5, &hf_nr_rrc_four         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_16 },
  {   6, &hf_nr_rrc_eight        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_8 },
  {   7, &hf_nr_rrc_sixteen      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_1_4 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB, T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_ra_Msg3SizeGroupA_vals[] = {
  {   0, "b56" },
  {   1, "b144" },
  {   2, "b208" },
  {   3, "b256" },
  {   4, "b282" },
  {   5, "b480" },
  {   6, "b640" },
  {   7, "b800" },
  {   8, "b1000" },
  {   9, "b72" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ra_Msg3SizeGroupA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_messagePowerOffsetGroupB_vals[] = {
  {   0, "minusinfinity" },
  {   1, "dB0" },
  {   2, "dB5" },
  {   3, "dB8" },
  {   4, "dB10" },
  {   5, "dB12" },
  {   6, "dB15" },
  {   7, "dB18" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_messagePowerOffsetGroupB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_groupBconfigured_sequence[] = {
  { &hf_nr_rrc_ra_Msg3SizeGroupA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ra_Msg3SizeGroupA },
  { &hf_nr_rrc_messagePowerOffsetGroupB, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_messagePowerOffsetGroupB },
  { &hf_nr_rrc_numberOfRA_PreamblesGroupA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_64 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_groupBconfigured(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_groupBconfigured, T_groupBconfigured_sequence);

  return offset;
}


static const value_string nr_rrc_T_ra_ContentionResolutionTimer_vals[] = {
  {   0, "sf8" },
  {   1, "sf16" },
  {   2, "sf24" },
  {   3, "sf32" },
  {   4, "sf40" },
  {   5, "sf48" },
  {   6, "sf56" },
  {   7, "sf64" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ra_ContentionResolutionTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_837(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 837U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_137(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 137U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_prach_RootSequenceIndex_vals[] = {
  {   0, "l839" },
  {   1, "l139" },
  { 0, NULL }
};

static const per_choice_t T_prach_RootSequenceIndex_choice[] = {
  {   0, &hf_nr_rrc_l839         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_837 },
  {   1, &hf_nr_rrc_l139         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_137 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_prach_RootSequenceIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_prach_RootSequenceIndex, T_prach_RootSequenceIndex_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_restrictedSetConfig_vals[] = {
  {   0, "unrestrictedSet" },
  {   1, "restrictedSetTypeA" },
  {   2, "restrictedSetTypeB" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_restrictedSetConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_msg3_transformPrecoder_vals[] = {
  {   0, "enabled" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_msg3_transformPrecoder(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RACH_ConfigCommon_sequence[] = {
  { &hf_nr_rrc_rach_ConfigGeneric, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RACH_ConfigGeneric },
  { &hf_nr_rrc_totalNumberOfRA_Preambles, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_63 },
  { &hf_nr_rrc_ssb_perRACH_OccasionAndCB_PreamblesPerSSB, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB },
  { &hf_nr_rrc_groupBconfigured, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_groupBconfigured },
  { &hf_nr_rrc_ra_ContentionResolutionTimer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ra_ContentionResolutionTimer },
  { &hf_nr_rrc_rsrp_ThresholdSSB, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { &hf_nr_rrc_rsrp_ThresholdSSB_SUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RSRP_Range },
  { &hf_nr_rrc_prach_RootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_prach_RootSequenceIndex },
  { &hf_nr_rrc_msg1_SubcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_restrictedSetConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_restrictedSetConfig },
  { &hf_nr_rrc_msg3_transformPrecoder, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_msg3_transformPrecoder },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RACH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RACH_ConfigCommon, RACH_ConfigCommon_sequence);

  return offset;
}


static const value_string nr_rrc_T_rach_ConfigCommon_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_rach_ConfigCommon_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_09     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RACH_ConfigCommon },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_rach_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_rach_ConfigCommon, T_rach_ConfigCommon_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_groupHoppingEnabledTransformPrecoding_vals[] = {
  {   0, "enabled" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_groupHoppingEnabledTransformPrecoding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_mappingType_01_vals[] = {
  {   0, "typeA" },
  {   1, "typeB" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mappingType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PUSCH_TimeDomainResourceAllocation_sequence[] = {
  { &hf_nr_rrc_k2           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_32 },
  { &hf_nr_rrc_mappingType_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mappingType_01 },
  { &hf_nr_rrc_startSymbolAndLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PUSCH_TimeDomainResourceAllocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PUSCH_TimeDomainResourceAllocation, PUSCH_TimeDomainResourceAllocation_sequence);

  return offset;
}


static const per_sequence_t PUSCH_TimeDomainResourceAllocationList_sequence_of[1] = {
  { &hf_nr_rrc_PUSCH_TimeDomainResourceAllocationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PUSCH_TimeDomainResourceAllocation },
};

static int
dissect_nr_rrc_PUSCH_TimeDomainResourceAllocationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PUSCH_TimeDomainResourceAllocationList, PUSCH_TimeDomainResourceAllocationList_sequence_of,
                                                  1, maxNrofUL_Allocations, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M1_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1, 6U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M202_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -202, 24U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PUSCH_ConfigCommon_sequence[] = {
  { &hf_nr_rrc_groupHoppingEnabledTransformPrecoding, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_groupHoppingEnabledTransformPrecoding },
  { &hf_nr_rrc_pusch_TimeDomainAllocationList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PUSCH_TimeDomainResourceAllocationList },
  { &hf_nr_rrc_msg3_DeltaPreamble, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_M1_6 },
  { &hf_nr_rrc_p0_NominalWithGrant, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_M202_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PUSCH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PUSCH_ConfigCommon, PUSCH_ConfigCommon_sequence);

  return offset;
}


static const value_string nr_rrc_T_pusch_ConfigCommon_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_pusch_ConfigCommon_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_10     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_PUSCH_ConfigCommon },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_pusch_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_pusch_ConfigCommon, T_pusch_ConfigCommon_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_pucch_GroupHopping_vals[] = {
  {   0, "neither" },
  {   1, "enable" },
  {   2, "disable" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_pucch_GroupHopping(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PUCCH_ConfigCommon_sequence[] = {
  { &hf_nr_rrc_pucch_ResourceCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_15 },
  { &hf_nr_rrc_pucch_GroupHopping, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_pucch_GroupHopping },
  { &hf_nr_rrc_hoppingId    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_0_1023 },
  { &hf_nr_rrc_p0_nominal   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_M202_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PUCCH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PUCCH_ConfigCommon, PUCCH_ConfigCommon_sequence);

  return offset;
}


static const value_string nr_rrc_T_pucch_ConfigCommon_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_pucch_ConfigCommon_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_11     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_PUCCH_ConfigCommon },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_pucch_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_pucch_ConfigCommon, T_pucch_ConfigCommon_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BWP_UplinkCommon_sequence[] = {
  { &hf_nr_rrc_genericParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BWP },
  { &hf_nr_rrc_rach_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_rach_ConfigCommon },
  { &hf_nr_rrc_pusch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_pusch_ConfigCommon },
  { &hf_nr_rrc_pucch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_pucch_ConfigCommon },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BWP_UplinkCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BWP_UplinkCommon, BWP_UplinkCommon_sequence);

  return offset;
}


static const value_string nr_rrc_TimeAlignmentTimer_vals[] = {
  {   0, "ms500" },
  {   1, "ms750" },
  {   2, "ms1280" },
  {   3, "ms1920" },
  {   4, "ms2560" },
  {   5, "ms5120" },
  {   6, "ms10240" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_nr_rrc_TimeAlignmentTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UplinkConfigCommonSIB_sequence[] = {
  { &hf_nr_rrc_frequencyInfoUL_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FrequencyInfoUL_SIB },
  { &hf_nr_rrc_initialUplinkBWP_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BWP_UplinkCommon },
  { &hf_nr_rrc_timeAlignmentTimerCommon, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeAlignmentTimer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UplinkConfigCommonSIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UplinkConfigCommonSIB, UplinkConfigCommonSIB_sequence);

  return offset;
}


static const value_string nr_rrc_T_n_TimingAdvanceOffset_01_vals[] = {
  {   0, "n0" },
  {   1, "n25600" },
  {   2, "n39936" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_n_TimingAdvanceOffset_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ssb_PositionsInBurst_01_sequence[] = {
  { &hf_nr_rrc_inOneGroup   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_8 },
  { &hf_nr_rrc_groupPresence, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_BIT_STRING_SIZE_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_ssb_PositionsInBurst_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_ssb_PositionsInBurst_01, T_ssb_PositionsInBurst_01_sequence);

  return offset;
}


static const value_string nr_rrc_T_ssb_PeriodicityServingCell_vals[] = {
  {   0, "ms5" },
  {   1, "ms10" },
  {   2, "ms20" },
  {   3, "ms40" },
  {   4, "ms80" },
  {   5, "ms160" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ssb_PeriodicityServingCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_dl_UL_TransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_UL_TransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_maxNrofSlots(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSlots, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_maxNrofSymbols_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSymbols_1, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_dl_UL_TransmissionPeriodicity_v1530_vals[] = {
  {   0, "ms3" },
  {   1, "ms4" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_dl_UL_TransmissionPeriodicity_v1530(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_UL_DL_Pattern_eag_1_sequence[] = {
  { &hf_nr_rrc_dl_UL_TransmissionPeriodicity_v1530, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dl_UL_TransmissionPeriodicity_v1530 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_TDD_UL_DL_Pattern_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, TDD_UL_DL_Pattern_eag_1_sequence);

  return offset;
}


static const per_sequence_t TDD_UL_DL_Pattern_sequence[] = {
  { &hf_nr_rrc_dl_UL_TransmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_dl_UL_TransmissionPeriodicity },
  { &hf_nr_rrc_nrofDownlinkSlots, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_maxNrofSlots },
  { &hf_nr_rrc_nrofDownlinkSymbols, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_maxNrofSymbols_1 },
  { &hf_nr_rrc_nrofUplinkSlots, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_maxNrofSlots },
  { &hf_nr_rrc_nrofUplinkSymbols, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_maxNrofSymbols_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_TDD_UL_DL_Pattern_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_TDD_UL_DL_Pattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_TDD_UL_DL_Pattern, TDD_UL_DL_Pattern_sequence);

  return offset;
}


static const per_sequence_t TDD_UL_DL_ConfigCommon_sequence[] = {
  { &hf_nr_rrc_referenceSubcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_pattern1_01  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TDD_UL_DL_Pattern },
  { &hf_nr_rrc_pattern2     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_TDD_UL_DL_Pattern },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_TDD_UL_DL_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_TDD_UL_DL_ConfigCommon, TDD_UL_DL_ConfigCommon_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M60_50(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -60, 50U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ServingCellConfigCommonSIB_sequence[] = {
  { &hf_nr_rrc_downlinkConfigCommon_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DownlinkConfigCommonSIB },
  { &hf_nr_rrc_uplinkConfigCommon_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_UplinkConfigCommonSIB },
  { &hf_nr_rrc_supplementaryUplink_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_UplinkConfigCommonSIB },
  { &hf_nr_rrc_n_TimingAdvanceOffset_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_n_TimingAdvanceOffset_01 },
  { &hf_nr_rrc_ssb_PositionsInBurst_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ssb_PositionsInBurst_01 },
  { &hf_nr_rrc_ssb_PeriodicityServingCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_ssb_PeriodicityServingCell },
  { &hf_nr_rrc_tdd_UL_DL_ConfigurationCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_TDD_UL_DL_ConfigCommon },
  { &hf_nr_rrc_ss_PBCH_BlockPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_M60_50 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ServingCellConfigCommonSIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ServingCellConfigCommonSIB, ServingCellConfigCommonSIB_sequence);

  return offset;
}


static const value_string nr_rrc_T_ims_EmergencySupport_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_ims_EmergencySupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_eCallOverIMS_Support_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_eCallOverIMS_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t300_vals[] = {
  {   0, "ms100" },
  {   1, "ms200" },
  {   2, "ms300" },
  {   3, "ms400" },
  {   4, "ms600" },
  {   5, "ms1000" },
  {   6, "ms1500" },
  {   7, "ms2000" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t300(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t301_vals[] = {
  {   0, "ms100" },
  {   1, "ms200" },
  {   2, "ms300" },
  {   3, "ms400" },
  {   4, "ms600" },
  {   5, "ms1000" },
  {   6, "ms1500" },
  {   7, "ms2000" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t301(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t310_01_vals[] = {
  {   0, "ms0" },
  {   1, "ms50" },
  {   2, "ms100" },
  {   3, "ms200" },
  {   4, "ms500" },
  {   5, "ms1000" },
  {   6, "ms2000" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t310_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_n310_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  {   6, "n10" },
  {   7, "n20" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_n310_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t311_vals[] = {
  {   0, "ms1000" },
  {   1, "ms3000" },
  {   2, "ms5000" },
  {   3, "ms10000" },
  {   4, "ms15000" },
  {   5, "ms20000" },
  {   6, "ms30000" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t311(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_n311_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_n311_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_t319_vals[] = {
  {   0, "ms100" },
  {   1, "ms200" },
  {   2, "ms300" },
  {   3, "ms400" },
  {   4, "ms600" },
  {   5, "ms1000" },
  {   6, "ms1500" },
  {   7, "ms2000" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t319(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UE_TimersAndConstants_sequence[] = {
  { &hf_nr_rrc_t300         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t300 },
  { &hf_nr_rrc_t301         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t301 },
  { &hf_nr_rrc_t310_01      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t310_01 },
  { &hf_nr_rrc_n310_01      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_n310_01 },
  { &hf_nr_rrc_t311         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t311 },
  { &hf_nr_rrc_n311_01      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_n311_01 },
  { &hf_nr_rrc_t319         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_t319 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UE_TimersAndConstants(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UE_TimersAndConstants, UE_TimersAndConstants_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxAccessCat_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxAccessCat_1, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_UAC_BarringInfoSetIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxBarringInfoSet, NULL, FALSE);

  return offset;
}


static const per_sequence_t UAC_BarringPerCat_sequence[] = {
  { &hf_nr_rrc_accessCategory, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxAccessCat_1 },
  { &hf_nr_rrc_uac_barringInfoSetIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UAC_BarringInfoSetIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UAC_BarringPerCat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UAC_BarringPerCat, UAC_BarringPerCat_sequence);

  return offset;
}


static const per_sequence_t UAC_BarringPerCatList_sequence_of[1] = {
  { &hf_nr_rrc_UAC_BarringPerCatList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UAC_BarringPerCat },
};

static int
dissect_nr_rrc_UAC_BarringPerCatList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_UAC_BarringPerCatList, UAC_BarringPerCatList_sequence_of,
                                                  1, maxAccessCat_1, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex_sequence_of[1] = {
  { &hf_nr_rrc_uac_ImplicitACBarringList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UAC_BarringInfoSetIndex },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex, SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex_sequence_of,
                                                  maxAccessCat_1, maxAccessCat_1, FALSE);

  return offset;
}


static const value_string nr_rrc_T_uac_ACBarringListType_vals[] = {
  {   0, "uac-ImplicitACBarringList" },
  {   1, "uac-ExplicitACBarringList" },
  { 0, NULL }
};

static const per_choice_t T_uac_ACBarringListType_choice[] = {
  {   0, &hf_nr_rrc_uac_ImplicitACBarringList, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex },
  {   1, &hf_nr_rrc_uac_ExplicitACBarringList, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UAC_BarringPerCatList },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_uac_ACBarringListType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_uac_ACBarringListType, T_uac_ACBarringListType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UAC_BarringPerPLMN_sequence[] = {
  { &hf_nr_rrc_plmn_IdentityIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxPLMN },
  { &hf_nr_rrc_uac_ACBarringListType, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_uac_ACBarringListType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UAC_BarringPerPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UAC_BarringPerPLMN, UAC_BarringPerPLMN_sequence);

  return offset;
}


static const per_sequence_t UAC_BarringPerPLMN_List_sequence_of[1] = {
  { &hf_nr_rrc_UAC_BarringPerPLMN_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UAC_BarringPerPLMN },
};

static int
dissect_nr_rrc_UAC_BarringPerPLMN_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_UAC_BarringPerPLMN_List, UAC_BarringPerPLMN_List_sequence_of,
                                                  1, maxPLMN, FALSE);

  return offset;
}


static const value_string nr_rrc_T_uac_BarringFactor_vals[] = {
  {   0, "p00" },
  {   1, "p05" },
  {   2, "p10" },
  {   3, "p15" },
  {   4, "p20" },
  {   5, "p25" },
  {   6, "p30" },
  {   7, "p40" },
  {   8, "p50" },
  {   9, "p60" },
  {  10, "p70" },
  {  11, "p75" },
  {  12, "p80" },
  {  13, "p85" },
  {  14, "p90" },
  {  15, "p95" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_uac_BarringFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_uac_BarringTime_vals[] = {
  {   0, "s4" },
  {   1, "s8" },
  {   2, "s16" },
  {   3, "s32" },
  {   4, "s64" },
  {   5, "s128" },
  {   6, "s256" },
  {   7, "s512" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_uac_BarringTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t UAC_BarringInfoSet_sequence[] = {
  { &hf_nr_rrc_uac_BarringFactor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_uac_BarringFactor },
  { &hf_nr_rrc_uac_BarringTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_uac_BarringTime },
  { &hf_nr_rrc_uac_BarringForAccessIdentity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UAC_BarringInfoSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UAC_BarringInfoSet, UAC_BarringInfoSet_sequence);

  return offset;
}


static const per_sequence_t UAC_BarringInfoSetList_sequence_of[1] = {
  { &hf_nr_rrc_UAC_BarringInfoSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UAC_BarringInfoSet },
};

static int
dissect_nr_rrc_UAC_BarringInfoSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_UAC_BarringInfoSetList, UAC_BarringInfoSetList_sequence_of,
                                                  1, maxBarringInfoSet, FALSE);

  return offset;
}


static const value_string nr_rrc_UAC_AccessCategory1_SelectionAssistanceInfo_vals[] = {
  {   0, "a" },
  {   1, "b" },
  {   2, "c" },
  { 0, NULL }
};


static int
dissect_nr_rrc_UAC_AccessCategory1_SelectionAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo_sequence_of[1] = {
  { &hf_nr_rrc_individualPLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UAC_AccessCategory1_SelectionAssistanceInfo },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo, SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo_sequence_of,
                                                  2, maxPLMN, FALSE);

  return offset;
}


static const value_string nr_rrc_T_uac_AccessCategory1_SelectionAssistanceInfo_vals[] = {
  {   0, "plmnCommon" },
  {   1, "individualPLMNList" },
  { 0, NULL }
};

static const per_choice_t T_uac_AccessCategory1_SelectionAssistanceInfo_choice[] = {
  {   0, &hf_nr_rrc_plmnCommon   , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UAC_AccessCategory1_SelectionAssistanceInfo },
  {   1, &hf_nr_rrc_individualPLMNList, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_uac_AccessCategory1_SelectionAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_uac_AccessCategory1_SelectionAssistanceInfo, T_uac_AccessCategory1_SelectionAssistanceInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_uac_BarringInfo_sequence[] = {
  { &hf_nr_rrc_uac_BarringForCommon, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UAC_BarringPerCatList },
  { &hf_nr_rrc_uac_BarringPerPLMN_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UAC_BarringPerPLMN_List },
  { &hf_nr_rrc_uac_BarringInfoSetList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UAC_BarringInfoSetList },
  { &hf_nr_rrc_uac_AccessCategory1_SelectionAssistanceInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_uac_AccessCategory1_SelectionAssistanceInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_uac_BarringInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_uac_BarringInfo, T_uac_BarringInfo_sequence);

  return offset;
}


static const value_string nr_rrc_T_useFullResumeID_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_useFullResumeID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_30_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_30, T_nonCriticalExtension_30_sequence);

  return offset;
}


static const per_sequence_t SIB1_sequence[] = {
  { &hf_nr_rrc_cellSelectionInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cellSelectionInfo },
  { &hf_nr_rrc_cellAccessRelatedInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellAccessRelatedInfo },
  { &hf_nr_rrc_connEstFailureControl, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ConnEstFailureControl },
  { &hf_nr_rrc_si_SchedulingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SI_SchedulingInfo },
  { &hf_nr_rrc_servingCellConfigCommon, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ServingCellConfigCommonSIB },
  { &hf_nr_rrc_ims_EmergencySupport, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ims_EmergencySupport },
  { &hf_nr_rrc_eCallOverIMS_Support, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_eCallOverIMS_Support },
  { &hf_nr_rrc_ue_TimersAndConstants, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UE_TimersAndConstants },
  { &hf_nr_rrc_uac_BarringInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_uac_BarringInfo },
  { &hf_nr_rrc_useFullResumeID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_useFullResumeID },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_43, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_30 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SIB1");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SIB1, SIB1_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_07_vals[] = {
  {   0, "systemInformation" },
  {   1, "systemInformationBlockType1" },
  { 0, NULL }
};

static const per_choice_t T_c1_07_choice[] = {
  {   0, &hf_nr_rrc_systemInformation, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SystemInformation },
  {   1, &hf_nr_rrc_systemInformationBlockType1, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SIB1 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_07, T_c1_07_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension_01, T_messageClassExtension_01_sequence);

  return offset;
}


static const value_string nr_rrc_BCCH_DL_SCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t BCCH_DL_SCH_MessageType_choice[] = {
  {   0, &hf_nr_rrc_c1_07        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_07 },
  {   1, &hf_nr_rrc_messageClassExtension_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_BCCH_DL_SCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_BCCH_DL_SCH_MessageType, BCCH_DL_SCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BCCH_DL_SCH_Message_sequence[] = {
  { &hf_nr_rrc_message_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BCCH_DL_SCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_BCCH_DL_SCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_BCCH_DL_SCH_Message, BCCH_DL_SCH_Message_sequence);

  return offset;
}



static int
dissect_nr_rrc_RejectWaitTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_19_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_19, T_nonCriticalExtension_19_sequence);

  return offset;
}


static const per_sequence_t RRCReject_IEs_sequence[] = {
  { &hf_nr_rrc_waitTime     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RejectWaitTime },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_30, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_19 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReject_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReject_IEs, RRCReject_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_18_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_18, T_criticalExtensionsFuture_18_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_18_vals[] = {
  {   0, "rrcReject" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_18_choice[] = {
  {   0, &hf_nr_rrc_rrcReject_01 , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReject_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_18, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_18 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_18, T_criticalExtensions_18_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReject_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Reject");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReject, RRCReject_sequence);

  return offset;
}



static int
dissect_nr_rrc_RRC_TransactionIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_SRB_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_reestablishPDCP_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reestablishPDCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_discardOnPDCP_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_discardOnPDCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_discardTimer_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  {   2, "ms30" },
  {   3, "ms40" },
  {   4, "ms50" },
  {   5, "ms60" },
  {   6, "ms75" },
  {   7, "ms100" },
  {   8, "ms150" },
  {   9, "ms200" },
  {  10, "ms250" },
  {  11, "ms300" },
  {  12, "ms500" },
  {  13, "ms750" },
  {  14, "ms1500" },
  {  15, "infinity" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_discardTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_pdcp_SN_SizeUL_vals[] = {
  {   0, "len12bits" },
  {   1, "len18bits" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_pdcp_SN_SizeUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 value;
  nr_drb_mapping_t *mapping = &nr_rrc_get_private_data(actx)->drb_mapping;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, &value, FALSE, 0, NULL);

  mapping->pdcpUlSnLength_present = TRUE;
  mapping->pdcpUlSnLength = (value) ? 18 : 12;


  return offset;
}


static const value_string nr_rrc_T_pdcp_SN_SizeDL_vals[] = {
  {   0, "len12bits" },
  {   1, "len18bits" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_pdcp_SN_SizeDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 value;
  nr_drb_mapping_t *mapping = &nr_rrc_get_private_data(actx)->drb_mapping;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, &value, FALSE, 0, NULL);

  mapping->pdcpDlSnLength_present = TRUE;
  mapping->pdcpDlSnLength = (value) ? 18 : 12;


  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16383U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_profiles_sequence[] = {
  { &hf_nr_rrc_profile0x0001, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0002, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0003, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0004, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0006, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0101, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0102, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0103, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_profile0x0104, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_profiles(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_profiles, T_profiles_sequence);

  return offset;
}


static const value_string nr_rrc_T_drb_ContinueROHC_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_drb_ContinueROHC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_rohc_sequence[] = {
  { &hf_nr_rrc_maxCID       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_16383 },
  { &hf_nr_rrc_profiles     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_profiles },
  { &hf_nr_rrc_drb_ContinueROHC, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_drb_ContinueROHC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_rohc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_rohc, T_rohc_sequence);

  return offset;
}


static const per_sequence_t T_profiles_01_sequence[] = {
  { &hf_nr_rrc_profile0x0006, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_profiles_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_profiles_01, T_profiles_01_sequence);

  return offset;
}


static const value_string nr_rrc_T_drb_ContinueROHC_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_drb_ContinueROHC_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_uplinkOnlyROHC_sequence[] = {
  { &hf_nr_rrc_maxCID       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_16383 },
  { &hf_nr_rrc_profiles_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_profiles_01 },
  { &hf_nr_rrc_drb_ContinueROHC_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_drb_ContinueROHC_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_uplinkOnlyROHC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_uplinkOnlyROHC, T_uplinkOnlyROHC_sequence);

  return offset;
}


static const value_string nr_rrc_T_headerCompression_vals[] = {
  {   0, "notUsed" },
  {   1, "rohc" },
  {   2, "uplinkOnlyROHC" },
  { 0, NULL }
};

static const per_choice_t T_headerCompression_choice[] = {
  {   0, &hf_nr_rrc_notUsed      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_rohc         , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_rohc },
  {   2, &hf_nr_rrc_uplinkOnlyROHC, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_uplinkOnlyROHC },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_headerCompression(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_headerCompression, T_headerCompression_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_integrityProtection_vals[] = {
  {   0, "enabled" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_integrityProtection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_statusReportRequired_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_statusReportRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_outOfOrderDelivery_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_outOfOrderDelivery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_drb_sequence[] = {
  { &hf_nr_rrc_discardTimer , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_discardTimer },
  { &hf_nr_rrc_pdcp_SN_SizeUL, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_pdcp_SN_SizeUL },
  { &hf_nr_rrc_pdcp_SN_SizeDL, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_pdcp_SN_SizeDL },
  { &hf_nr_rrc_headerCompression, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_headerCompression },
  { &hf_nr_rrc_integrityProtection, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_integrityProtection },
  { &hf_nr_rrc_statusReportRequired, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_statusReportRequired },
  { &hf_nr_rrc_outOfOrderDelivery, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_outOfOrderDelivery },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_drb(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_drb, T_drb_sequence);

  return offset;
}



static int
dissect_nr_rrc_CellGroupId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxSecondaryCellGroups, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_LogicalChannelIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 value;
  nr_drb_mapping_t *mapping = &nr_rrc_get_private_data(actx)->drb_mapping;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxLC_ID, &value, FALSE);

  mapping->lcid = (guint8)value;
  mapping->lcid_present = TRUE;


  return offset;
}


static const per_sequence_t T_primaryPath_sequence[] = {
  { &hf_nr_rrc_cellGroup    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CellGroupId },
  { &hf_nr_rrc_logicalChannel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_LogicalChannelIdentity },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_primaryPath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_primaryPath, T_primaryPath_sequence);

  return offset;
}


static const value_string nr_rrc_UL_DataSplitThreshold_vals[] = {
  {   0, "b0" },
  {   1, "b100" },
  {   2, "b200" },
  {   3, "b400" },
  {   4, "b800" },
  {   5, "b1600" },
  {   6, "b3200" },
  {   7, "b6400" },
  {   8, "b12800" },
  {   9, "b25600" },
  {  10, "b51200" },
  {  11, "b102400" },
  {  12, "b204800" },
  {  13, "b409600" },
  {  14, "b819200" },
  {  15, "b1228800" },
  {  16, "b1638400" },
  {  17, "b2457600" },
  {  18, "b3276800" },
  {  19, "b4096000" },
  {  20, "b4915200" },
  {  21, "b5734400" },
  {  22, "b6553600" },
  {  23, "infinity" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext nr_rrc_UL_DataSplitThreshold_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_UL_DataSplitThreshold_vals);


static int
dissect_nr_rrc_UL_DataSplitThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_moreThanOneRLC_sequence[] = {
  { &hf_nr_rrc_primaryPath  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_primaryPath },
  { &hf_nr_rrc_ul_DataSplitThreshold, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UL_DataSplitThreshold },
  { &hf_nr_rrc_pdcp_Duplication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_moreThanOneRLC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_moreThanOneRLC, T_moreThanOneRLC_sequence);

  return offset;
}


static const value_string nr_rrc_T_t_Reordering_vals[] = {
  {   0, "ms0" },
  {   1, "ms1" },
  {   2, "ms2" },
  {   3, "ms4" },
  {   4, "ms5" },
  {   5, "ms8" },
  {   6, "ms10" },
  {   7, "ms15" },
  {   8, "ms20" },
  {   9, "ms30" },
  {  10, "ms40" },
  {  11, "ms50" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms120" },
  {  16, "ms140" },
  {  17, "ms160" },
  {  18, "ms180" },
  {  19, "ms200" },
  {  20, "ms220" },
  {  21, "ms240" },
  {  22, "ms260" },
  {  23, "ms280" },
  {  24, "ms300" },
  {  25, "ms500" },
  {  26, "ms750" },
  {  27, "ms1000" },
  {  28, "ms1250" },
  {  29, "ms1500" },
  {  30, "ms1750" },
  {  31, "ms2000" },
  {  32, "ms2250" },
  {  33, "ms2500" },
  {  34, "ms2750" },
  {  35, "ms3000" },
  {  36, "spare28" },
  {  37, "spare27" },
  {  38, "spare26" },
  {  39, "spare25" },
  {  40, "spare24" },
  {  41, "spare23" },
  {  42, "spare22" },
  {  43, "spare21" },
  {  44, "spare20" },
  {  45, "spare19" },
  {  46, "spare18" },
  {  47, "spare17" },
  {  48, "spare16" },
  {  49, "spare15" },
  {  50, "spare14" },
  {  51, "spare13" },
  {  52, "spare12" },
  {  53, "spare11" },
  {  54, "spare10" },
  {  55, "spare09" },
  {  56, "spare08" },
  {  57, "spare07" },
  {  58, "spare06" },
  {  59, "spare05" },
  {  60, "spare04" },
  {  61, "spare03" },
  {  62, "spare02" },
  {  63, "spare01" },
  { 0, NULL }
};

static value_string_ext nr_rrc_T_t_Reordering_vals_ext = VALUE_STRING_EXT_INIT(nr_rrc_T_t_Reordering_vals);


static int
dissect_nr_rrc_T_t_Reordering(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     64, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_cipheringDisabled_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cipheringDisabled(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PDCP_Config_eag_1_sequence[] = {
  { &hf_nr_rrc_cipheringDisabled, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cipheringDisabled },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDCP_Config_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PDCP_Config_eag_1_sequence);

  return offset;
}


static const per_sequence_t PDCP_Config_sequence[] = {
  { &hf_nr_rrc_drb          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_drb },
  { &hf_nr_rrc_moreThanOneRLC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_moreThanOneRLC },
  { &hf_nr_rrc_t_Reordering , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_t_Reordering },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDCP_Config_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PDCP_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PDCP_Config, PDCP_Config_sequence);

  return offset;
}


static const per_sequence_t SRB_ToAddMod_sequence[] = {
  { &hf_nr_rrc_srb_Identity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SRB_Identity },
  { &hf_nr_rrc_reestablishPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_reestablishPDCP },
  { &hf_nr_rrc_discardOnPDCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_discardOnPDCP },
  { &hf_nr_rrc_pdcp_Config  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PDCP_Config },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SRB_ToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SRB_ToAddMod, SRB_ToAddMod_sequence);

  return offset;
}


static const per_sequence_t SRB_ToAddModList_sequence_of[1] = {
  { &hf_nr_rrc_SRB_ToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SRB_ToAddMod },
};

static int
dissect_nr_rrc_SRB_ToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SRB_ToAddModList, SRB_ToAddModList_sequence_of,
                                                  1, 2, FALSE);

  return offset;
}


static const value_string nr_rrc_T_srb3_ToRelease_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_srb3_ToRelease(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_PDU_SessionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_T_sdap_HeaderDL_vals[] = {
  {   0, "present" },
  {   1, "absent" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sdap_HeaderDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_sdap_HeaderUL_vals[] = {
  {   0, "present" },
  {   1, "absent" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_sdap_HeaderUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_QFI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxQFI, NULL, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI_sequence_of[1] = {
  { &hf_nr_rrc_mappedQoS_FlowsToAdd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_QFI },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI, SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI_sequence_of,
                                                  1, maxNrofQFIs, FALSE);

  return offset;
}


static const per_sequence_t SDAP_Config_sequence[] = {
  { &hf_nr_rrc_pdu_Session  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PDU_SessionID },
  { &hf_nr_rrc_sdap_HeaderDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sdap_HeaderDL },
  { &hf_nr_rrc_sdap_HeaderUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_sdap_HeaderUL },
  { &hf_nr_rrc_defaultDRB   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_mappedQoS_FlowsToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI },
  { &hf_nr_rrc_mappedQoS_FlowsToRelease, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SDAP_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SDAP_Config, SDAP_Config_sequence);

  return offset;
}


static const value_string nr_rrc_T_cnAssociation_vals[] = {
  {   0, "eps-BearerIdentity" },
  {   1, "sdap-Config" },
  { 0, NULL }
};

static const per_choice_t T_cnAssociation_choice[] = {
  {   0, &hf_nr_rrc_eps_BearerIdentity, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_15 },
  {   1, &hf_nr_rrc_sdap_Config  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SDAP_Config },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_cnAssociation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_cnAssociation, T_cnAssociation_choice,
                                 NULL);

  return offset;
}



static int
dissect_nr_rrc_DRB_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 value;
  nr_drb_mapping_t *mapping = &nr_rrc_get_private_data(actx)->drb_mapping;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, &value, FALSE);

  mapping->drbid = (guint8)value;


  return offset;
}


static const value_string nr_rrc_T_reestablishPDCP_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reestablishPDCP_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_recoverPDCP_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_recoverPDCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DRB_ToAddMod_sequence[] = {
  { &hf_nr_rrc_cnAssociation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_cnAssociation },
  { &hf_nr_rrc_drb_Identity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DRB_Identity },
  { &hf_nr_rrc_reestablishPDCP_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_reestablishPDCP_01 },
  { &hf_nr_rrc_recoverPDCP  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_recoverPDCP },
  { &hf_nr_rrc_pdcp_Config  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PDCP_Config },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DRB_ToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_drb_mapping_t *mapping = &nr_rrc_get_private_data(actx)->drb_mapping;
  memset(mapping, 0, sizeof(*mapping));
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DRB_ToAddMod, DRB_ToAddMod_sequence);

  /* Need UE identifier */
  mac_nr_info *p_mac_nr_info = (mac_nr_info *)p_get_proto_data(wmem_file_scope(), actx->pinfo, proto_mac_nr, 0);
  if (p_mac_nr_info) {
    /* Configure PDCP SN length(s) for this DRB */
    if (mapping->pdcpUlSnLength_present || mapping->pdcpDlSnLength_present) {
      set_rlc_nr_drb_pdcp_seqnum_length(actx->pinfo, p_mac_nr_info->ueid, mapping->drbid,
                                        mapping->pdcpUlSnLength, mapping->pdcpDlSnLength);
    }
  }


  return offset;
}


static const per_sequence_t DRB_ToAddModList_sequence_of[1] = {
  { &hf_nr_rrc_DRB_ToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DRB_ToAddMod },
};

static int
dissect_nr_rrc_DRB_ToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_DRB_ToAddModList, DRB_ToAddModList_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}


static const per_sequence_t DRB_ToReleaseList_sequence_of[1] = {
  { &hf_nr_rrc_DRB_ToReleaseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DRB_Identity },
};

static int
dissect_nr_rrc_DRB_ToReleaseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_DRB_ToReleaseList, DRB_ToReleaseList_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}


static const value_string nr_rrc_CipheringAlgorithm_vals[] = {
  {   0, "nea0" },
  {   1, "nea1" },
  {   2, "nea2" },
  {   3, "nea3" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_CipheringAlgorithm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_IntegrityProtAlgorithm_vals[] = {
  {   0, "nia0" },
  {   1, "nia1" },
  {   2, "nia2" },
  {   3, "nia3" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_IntegrityProtAlgorithm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityAlgorithmConfig_sequence[] = {
  { &hf_nr_rrc_cipheringAlgorithm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CipheringAlgorithm },
  { &hf_nr_rrc_integrityProtAlgorithm, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_IntegrityProtAlgorithm },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityAlgorithmConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityAlgorithmConfig, SecurityAlgorithmConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_keyToUse_vals[] = {
  {   0, "master" },
  {   1, "secondary" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_keyToUse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityConfig_sequence[] = {
  { &hf_nr_rrc_securityAlgorithmConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SecurityAlgorithmConfig },
  { &hf_nr_rrc_keyToUse     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_keyToUse },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityConfig, SecurityConfig_sequence);

  return offset;
}


static const per_sequence_t RadioBearerConfig_sequence[] = {
  { &hf_nr_rrc_srb_ToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SRB_ToAddModList },
  { &hf_nr_rrc_srb3_ToRelease, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_srb3_ToRelease },
  { &hf_nr_rrc_drb_ToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_DRB_ToAddModList },
  { &hf_nr_rrc_drb_ToReleaseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_DRB_ToReleaseList },
  { &hf_nr_rrc_securityConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SecurityConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RadioBearerConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RadioBearerConfig, RadioBearerConfig_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_masterCellGroup_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_CellGroupConfig_PDU);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_23_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_23, T_nonCriticalExtension_23_sequence);

  return offset;
}


static const per_sequence_t RRCSetup_IEs_sequence[] = {
  { &hf_nr_rrc_radioBearerConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RadioBearerConfig },
  { &hf_nr_rrc_masterCellGroup_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_masterCellGroup_02 },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_36, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSetup_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSetup_IEs, RRCSetup_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_22_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_22, T_criticalExtensionsFuture_22_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_22_vals[] = {
  {   0, "rrcSetup" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_22_choice[] = {
  {   0, &hf_nr_rrc_rrcSetup_01  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCSetup_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_22, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_22 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_22, T_criticalExtensions_22_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCSetup_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_22, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_22 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSetup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Setup");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSetup, RRCSetup_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_08_vals[] = {
  {   0, "rrcReject" },
  {   1, "rrcSetup" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_08_choice[] = {
  {   0, &hf_nr_rrc_rrcReject    , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReject },
  {   1, &hf_nr_rrc_rrcSetup     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCSetup },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_08(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_08, T_c1_08_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension_02, T_messageClassExtension_02_sequence);

  return offset;
}


static const value_string nr_rrc_DL_CCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t DL_CCCH_MessageType_choice[] = {
  {   0, &hf_nr_rrc_c1_08        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_08 },
  {   1, &hf_nr_rrc_messageClassExtension_02, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_DL_CCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_DL_CCCH_MessageType, DL_CCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DL_CCCH_Message_sequence[] = {
  { &hf_nr_rrc_message_02   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DL_CCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DL_CCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  actx->pinfo->link_dir = P2P_DIR_DL;

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DL_CCCH_Message, DL_CCCH_Message_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_secondaryCellGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_CellGroupConfig_PDU);

  return offset;
}



static int
dissect_nr_rrc_MeasObjectId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrofObjectId, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectToRemoveList_sequence_of[1] = {
  { &hf_nr_rrc_MeasObjectToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasObjectId },
};

static int
dissect_nr_rrc_MeasObjectToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasObjectToRemoveList, MeasObjectToRemoveList_sequence_of,
                                                  1, maxNrofObjectId, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId_sequence_of[1] = {
  { &hf_nr_rrc_pci_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId, SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId_sequence_of,
                                                  1, maxNrofPCIsPerSMTC, FALSE);

  return offset;
}


static const value_string nr_rrc_T_periodicity_02_vals[] = {
  {   0, "sf5" },
  {   1, "sf10" },
  {   2, "sf20" },
  {   3, "sf40" },
  {   4, "sf80" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_periodicity_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SSB_MTC2_sequence[] = {
  { &hf_nr_rrc_pci_List     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId },
  { &hf_nr_rrc_periodicity_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_periodicity_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SSB_MTC2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SSB_MTC2, SSB_MTC2_sequence);

  return offset;
}


static const value_string nr_rrc_T_ssb_ToMeasure_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_ssb_ToMeasure_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_28     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SSB_ToMeasure },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_ssb_ToMeasure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_ssb_ToMeasure, T_ssb_ToMeasure_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SSB_ConfigMobility_sequence[] = {
  { &hf_nr_rrc_ssb_ToMeasure_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_ssb_ToMeasure },
  { &hf_nr_rrc_deriveSSB_IndexFromCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_ss_RSSI_Measurement, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SS_RSSI_Measurement },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SSB_ConfigMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SSB_ConfigMobility, SSB_ConfigMobility_sequence);

  return offset;
}


static const value_string nr_rrc_T_nrofPRBs_vals[] = {
  {   0, "size24" },
  {   1, "size48" },
  {   2, "size96" },
  {   3, "size192" },
  {   4, "size264" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_nrofPRBs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_2169(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2169U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_csi_rs_MeasurementBW_sequence[] = {
  { &hf_nr_rrc_nrofPRBs     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_nrofPRBs },
  { &hf_nr_rrc_startPRB     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_2169 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_csi_rs_MeasurementBW(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_csi_rs_MeasurementBW, T_csi_rs_MeasurementBW_sequence);

  return offset;
}


static const value_string nr_rrc_T_density_vals[] = {
  {   0, "d1" },
  {   1, "d3" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_density(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_slotConfig_vals[] = {
  {   0, "ms4" },
  {   1, "ms5" },
  {   2, "ms10" },
  {   3, "ms20" },
  {   4, "ms40" },
  { 0, NULL }
};

static const per_choice_t T_slotConfig_choice[] = {
  {   0, &hf_nr_rrc_ms4          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_31 },
  {   1, &hf_nr_rrc_ms5          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_39 },
  {   2, &hf_nr_rrc_ms10_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_79 },
  {   3, &hf_nr_rrc_ms20_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_159 },
  {   4, &hf_nr_rrc_ms40_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_0_319 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_slotConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_slotConfig, T_slotConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_associatedSSB_sequence[] = {
  { &hf_nr_rrc_ssb_Index    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SSB_Index },
  { &hf_nr_rrc_isQuasiColocated, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_associatedSSB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_associatedSSB, T_associatedSSB_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 12, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_frequencyDomainAllocation_vals[] = {
  {   0, "row1" },
  {   1, "row2" },
  { 0, NULL }
};

static const per_choice_t T_frequencyDomainAllocation_choice[] = {
  {   0, &hf_nr_rrc_row1         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_4 },
  {   1, &hf_nr_rrc_row2         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_frequencyDomainAllocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_frequencyDomainAllocation, T_frequencyDomainAllocation_choice,
                                 NULL);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CSI_RS_Resource_Mobility_sequence[] = {
  { &hf_nr_rrc_csi_RS_Index , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_Index },
  { &hf_nr_rrc_slotConfig   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_slotConfig },
  { &hf_nr_rrc_associatedSSB, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_associatedSSB },
  { &hf_nr_rrc_frequencyDomainAllocation_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_frequencyDomainAllocation },
  { &hf_nr_rrc_firstOFDMSymbolInTimeDomain, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_13 },
  { &hf_nr_rrc_sequenceGenerationConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CSI_RS_Resource_Mobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CSI_RS_Resource_Mobility, CSI_RS_Resource_Mobility_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility_sequence_of[1] = {
  { &hf_nr_rrc_csi_rs_ResourceList_Mobility_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_Resource_Mobility },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility, SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility_sequence_of,
                                                  1, maxNrofCSI_RS_ResourcesRRM, FALSE);

  return offset;
}


static const per_sequence_t CSI_RS_CellMobility_sequence[] = {
  { &hf_nr_rrc_cellId       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_csi_rs_MeasurementBW, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_csi_rs_MeasurementBW },
  { &hf_nr_rrc_density      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_density },
  { &hf_nr_rrc_csi_rs_ResourceList_Mobility, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CSI_RS_CellMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CSI_RS_CellMobility, CSI_RS_CellMobility_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility_sequence_of[1] = {
  { &hf_nr_rrc_csi_RS_CellList_Mobility_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_CellMobility },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility, SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility_sequence_of,
                                                  1, maxNrofCSI_RS_CellsRRM, FALSE);

  return offset;
}


static const per_sequence_t CSI_RS_ResourceConfigMobility_eag_1_sequence[] = {
  { &hf_nr_rrc_refServCellIndex_v1530, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_ServCellIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CSI_RS_ResourceConfigMobility_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CSI_RS_ResourceConfigMobility_eag_1_sequence);

  return offset;
}


static const per_sequence_t CSI_RS_ResourceConfigMobility_sequence[] = {
  { &hf_nr_rrc_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_csi_RS_CellList_Mobility, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_CSI_RS_ResourceConfigMobility_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CSI_RS_ResourceConfigMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CSI_RS_ResourceConfigMobility, CSI_RS_ResourceConfigMobility_sequence);

  return offset;
}


static const value_string nr_rrc_T_csi_rs_ResourceConfigMobility_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_csi_rs_ResourceConfigMobility_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_27     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_CSI_RS_ResourceConfigMobility },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_csi_rs_ResourceConfigMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_csi_rs_ResourceConfigMobility, T_csi_rs_ResourceConfigMobility_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ReferenceSignalConfig_sequence[] = {
  { &hf_nr_rrc_ssb_ConfigMobility, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_ConfigMobility },
  { &hf_nr_rrc_csi_rs_ResourceConfigMobility, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_csi_rs_ResourceConfigMobility },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReferenceSignalConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReferenceSignalConfig, ReferenceSignalConfig_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_2_maxNrofCSI_RS_ResourcesToAverage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, maxNrofCSI_RS_ResourcesToAverage, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxNrofQuantityConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrofQuantityConfig, NULL, FALSE);

  return offset;
}


static const per_sequence_t Q_OffsetRangeList_sequence[] = {
  { &hf_nr_rrc_rsrpOffsetSSB, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_rsrqOffsetSSB, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_sinrOffsetSSB, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_rsrpOffsetCSI_RS, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_rsrqOffsetCSI_RS, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_OffsetRange },
  { &hf_nr_rrc_sinrOffsetCSI_RS, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_Q_OffsetRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_Q_OffsetRangeList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_Q_OffsetRangeList, Q_OffsetRangeList_sequence);

  return offset;
}


static const per_sequence_t PCI_List_sequence_of[1] = {
  { &hf_nr_rrc_PCI_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
};

static int
dissect_nr_rrc_PCI_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PCI_List, PCI_List_sequence_of,
                                                  1, maxNrofCellMeas, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddMod_sequence[] = {
  { &hf_nr_rrc_physCellId   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_cellIndividualOffset_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_OffsetRangeList },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CellsToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CellsToAddMod, CellsToAddMod_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModList_sequence_of[1] = {
  { &hf_nr_rrc_CellsToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellsToAddMod },
};

static int
dissect_nr_rrc_CellsToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_CellsToAddModList, CellsToAddModList_sequence_of,
                                                  1, maxNrofCellMeas, FALSE);

  return offset;
}



static int
dissect_nr_rrc_PCI_RangeIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrofPCI_Ranges, NULL, FALSE);

  return offset;
}


static const per_sequence_t PCI_RangeIndexList_sequence_of[1] = {
  { &hf_nr_rrc_PCI_RangeIndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCI_RangeIndex },
};

static int
dissect_nr_rrc_PCI_RangeIndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PCI_RangeIndexList, PCI_RangeIndexList_sequence_of,
                                                  1, maxNrofPCI_Ranges, FALSE);

  return offset;
}


static const per_sequence_t PCI_RangeElement_sequence[] = {
  { &hf_nr_rrc_pci_RangeIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCI_RangeIndex },
  { &hf_nr_rrc_pci_Range    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCI_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PCI_RangeElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PCI_RangeElement, PCI_RangeElement_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement_sequence_of[1] = {
  { &hf_nr_rrc_blackCellsToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCI_RangeElement },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement, SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement_sequence_of,
                                                  1, maxNrofPCI_Ranges, FALSE);

  return offset;
}


static const value_string nr_rrc_T_measCycleSCell_v1530_vals[] = {
  {   0, "sf160" },
  {   1, "sf256" },
  {   2, "sf320" },
  {   3, "sf512" },
  {   4, "sf640" },
  {   5, "sf1024" },
  {   6, "sf1280" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_measCycleSCell_v1530(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t MeasObjectNR_eag_1_sequence[] = {
  { &hf_nr_rrc_freqBandIndicatorNR_v1530, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FreqBandIndicatorNR },
  { &hf_nr_rrc_measCycleSCell_v1530, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_measCycleSCell_v1530 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasObjectNR_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectNR_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasObjectNR_sequence[] = {
  { &hf_nr_rrc_ssbFrequency , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_ssbSubcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_smtc1        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_MTC },
  { &hf_nr_rrc_smtc2        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_MTC2 },
  { &hf_nr_rrc_refFreqCSI_RS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_referenceSignalConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReferenceSignalConfig },
  { &hf_nr_rrc_absThreshSS_BlocksConsolidation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ThresholdNR },
  { &hf_nr_rrc_absThreshCSI_RS_Consolidation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ThresholdNR },
  { &hf_nr_rrc_nrofSS_BlocksToAverage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_2_maxNrofSS_BlocksToAverage },
  { &hf_nr_rrc_nrofCSI_RS_ResourcesToAverage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_2_maxNrofCSI_RS_ResourcesToAverage },
  { &hf_nr_rrc_quantityConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxNrofQuantityConfig },
  { &hf_nr_rrc_offsetMO     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Q_OffsetRangeList },
  { &hf_nr_rrc_cellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PCI_List },
  { &hf_nr_rrc_cellsToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_CellsToAddModList },
  { &hf_nr_rrc_blackCellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PCI_RangeIndexList },
  { &hf_nr_rrc_blackCellsToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement },
  { &hf_nr_rrc_whiteCellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PCI_RangeIndexList },
  { &hf_nr_rrc_whiteCellsToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasObjectNR_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasObjectNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasObjectNR, MeasObjectNR_sequence);

  return offset;
}



static int
dissect_nr_rrc_EUTRA_CellIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellMeasEUTRA, NULL, FALSE);

  return offset;
}


static const per_sequence_t EUTRA_CellIndexList_sequence_of[1] = {
  { &hf_nr_rrc_EUTRA_CellIndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_CellIndex },
};

static int
dissect_nr_rrc_EUTRA_CellIndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_EUTRA_CellIndexList, EUTRA_CellIndexList_sequence_of,
                                                  1, maxCellMeasEUTRA, FALSE);

  return offset;
}


static const per_sequence_t EUTRA_Cell_sequence[] = {
  { &hf_nr_rrc_cellIndexEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_CellIndex },
  { &hf_nr_rrc_physCellId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { &hf_nr_rrc_cellIndividualOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_Q_OffsetRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EUTRA_Cell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EUTRA_Cell, EUTRA_Cell_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell_sequence_of[1] = {
  { &hf_nr_rrc_cellsToAddModListEUTRAN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_Cell },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell, SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell_sequence_of,
                                                  1, maxCellMeasEUTRA, FALSE);

  return offset;
}


static const per_sequence_t EUTRA_BlackCell_sequence[] = {
  { &hf_nr_rrc_cellIndexEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_CellIndex },
  { &hf_nr_rrc_physCellIdRange, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellIdRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EUTRA_BlackCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EUTRA_BlackCell, EUTRA_BlackCell_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell_sequence_of[1] = {
  { &hf_nr_rrc_blackCellsToAddModListEUTRAN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_BlackCell },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell, SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell_sequence_of,
                                                  1, maxCellMeasEUTRA, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_sequence[] = {
  { &hf_nr_rrc_carrierFreq_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_allowedMeasBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_AllowedMeasBandwidth },
  { &hf_nr_rrc_cellsToRemoveListEUTRAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_EUTRA_CellIndexList },
  { &hf_nr_rrc_cellsToAddModListEUTRAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell },
  { &hf_nr_rrc_blackCellsToRemoveListEUTRAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_EUTRA_CellIndexList },
  { &hf_nr_rrc_blackCellsToAddModListEUTRAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_BlackCell },
  { &hf_nr_rrc_eutra_PresenceAntennaPort1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PresenceAntennaPort1 },
  { &hf_nr_rrc_eutra_Q_OffsetRange, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_EUTRA_Q_OffsetRange },
  { &hf_nr_rrc_widebandRSRQ_Meas, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasObjectEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasObjectEUTRA, MeasObjectEUTRA_sequence);

  return offset;
}


static const value_string nr_rrc_T_measObject_vals[] = {
  {   0, "measObjectNR" },
  {   1, "measObjectEUTRA" },
  { 0, NULL }
};

static const per_choice_t T_measObject_choice[] = {
  {   0, &hf_nr_rrc_measObjectNR , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_MeasObjectNR },
  {   1, &hf_nr_rrc_measObjectEUTRA, ASN1_NOT_EXTENSION_ROOT, dissect_nr_rrc_MeasObjectEUTRA },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_measObject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_measObject, T_measObject_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasObjectToAddMod_sequence[] = {
  { &hf_nr_rrc_measObjectId , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasObjectId },
  { &hf_nr_rrc_measObject   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measObject },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasObjectToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasObjectToAddMod, MeasObjectToAddMod_sequence);

  return offset;
}


static const per_sequence_t MeasObjectToAddModList_sequence_of[1] = {
  { &hf_nr_rrc_MeasObjectToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasObjectToAddMod },
};

static int
dissect_nr_rrc_MeasObjectToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasObjectToAddModList, MeasObjectToAddModList_sequence_of,
                                                  1, maxNrofObjectId, FALSE);

  return offset;
}



static int
dissect_nr_rrc_ReportConfigId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxReportConfigId, NULL, FALSE);

  return offset;
}


static const per_sequence_t ReportConfigToRemoveList_sequence_of[1] = {
  { &hf_nr_rrc_ReportConfigToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportConfigId },
};

static int
dissect_nr_rrc_ReportConfigToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ReportConfigToRemoveList, ReportConfigToRemoveList_sequence_of,
                                                  1, maxReportConfigId, FALSE);

  return offset;
}


static const value_string nr_rrc_NR_RS_Type_vals[] = {
  {   0, "ssb" },
  {   1, "csi-rs" },
  { 0, NULL }
};


static int
dissect_nr_rrc_NR_RS_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_ReportInterval_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "ms20480" },
  {   9, "ms40960" },
  {  10, "min1" },
  {  11, "min6" },
  {  12, "min12" },
  {  13, "min30" },
  { 0, NULL }
};


static int
dissect_nr_rrc_ReportInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_reportAmount_03_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reportAmount_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t MeasReportQuantity_sequence[] = {
  { &hf_nr_rrc_rsrp_03      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_rsrq_03      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_sinr_03      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasReportQuantity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasReportQuantity, MeasReportQuantity_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxCellReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellReport, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_1_maxNrofIndexesToReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrofIndexesToReport, NULL, FALSE);

  return offset;
}


static const per_sequence_t PeriodicalReportConfig_sequence[] = {
  { &hf_nr_rrc_rsType       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_RS_Type },
  { &hf_nr_rrc_reportInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportInterval },
  { &hf_nr_rrc_reportAmount_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reportAmount_03 },
  { &hf_nr_rrc_reportQuantityCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasReportQuantity },
  { &hf_nr_rrc_maxReportCells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxCellReport },
  { &hf_nr_rrc_reportQuantityRS_Indexes, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasReportQuantity },
  { &hf_nr_rrc_maxNrofRS_IndexesToReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxNrofIndexesToReport },
  { &hf_nr_rrc_includeBeamMeasurements, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_useWhiteCellList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PeriodicalReportConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PeriodicalReportConfig, PeriodicalReportConfig_sequence);

  return offset;
}


static const value_string nr_rrc_MeasTriggerQuantity_vals[] = {
  {   0, "rsrp" },
  {   1, "rsrq" },
  {   2, "sinr" },
  { 0, NULL }
};

static const per_choice_t MeasTriggerQuantity_choice[] = {
  {   0, &hf_nr_rrc_rsrp         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RSRP_Range },
  {   1, &hf_nr_rrc_rsrq         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RSRQ_Range },
  {   2, &hf_nr_rrc_sinr         , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SINR_Range },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_MeasTriggerQuantity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_MeasTriggerQuantity, MeasTriggerQuantity_choice,
                                 NULL);

  return offset;
}



static int
dissect_nr_rrc_Hysteresis(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_TimeToTrigger_vals[] = {
  {   0, "ms0" },
  {   1, "ms40" },
  {   2, "ms64" },
  {   3, "ms80" },
  {   4, "ms100" },
  {   5, "ms128" },
  {   6, "ms160" },
  {   7, "ms256" },
  {   8, "ms320" },
  {   9, "ms480" },
  {  10, "ms512" },
  {  11, "ms640" },
  {  12, "ms1024" },
  {  13, "ms1280" },
  {  14, "ms2560" },
  {  15, "ms5120" },
  { 0, NULL }
};


static int
dissect_nr_rrc_TimeToTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_eventA1_sequence[] = {
  { &hf_nr_rrc_a1_Threshold , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantity },
  { &hf_nr_rrc_reportOnLeave, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventA1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventA1, T_eventA1_sequence);

  return offset;
}


static const per_sequence_t T_eventA2_sequence[] = {
  { &hf_nr_rrc_a2_Threshold , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantity },
  { &hf_nr_rrc_reportOnLeave, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventA2, T_eventA2_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_M30_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30, 30U, NULL, FALSE);

  return offset;
}


static const value_string nr_rrc_MeasTriggerQuantityOffset_vals[] = {
  {   0, "rsrp" },
  {   1, "rsrq" },
  {   2, "sinr" },
  { 0, NULL }
};

static const per_choice_t MeasTriggerQuantityOffset_choice[] = {
  {   0, &hf_nr_rrc_rsrp_02      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_M30_30 },
  {   1, &hf_nr_rrc_rsrq_02      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_M30_30 },
  {   2, &hf_nr_rrc_sinr_02      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_INTEGER_M30_30 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_MeasTriggerQuantityOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_MeasTriggerQuantityOffset, MeasTriggerQuantityOffset_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_eventA3_sequence[] = {
  { &hf_nr_rrc_a3_Offset    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantityOffset },
  { &hf_nr_rrc_reportOnLeave, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { &hf_nr_rrc_useWhiteCellList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventA3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventA3, T_eventA3_sequence);

  return offset;
}


static const per_sequence_t T_eventA4_sequence[] = {
  { &hf_nr_rrc_a4_Threshold , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantity },
  { &hf_nr_rrc_reportOnLeave, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { &hf_nr_rrc_useWhiteCellList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventA4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventA4, T_eventA4_sequence);

  return offset;
}


static const per_sequence_t T_eventA5_sequence[] = {
  { &hf_nr_rrc_a5_Threshold1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantity },
  { &hf_nr_rrc_a5_Threshold2, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantity },
  { &hf_nr_rrc_reportOnLeave, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { &hf_nr_rrc_useWhiteCellList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventA5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventA5, T_eventA5_sequence);

  return offset;
}


static const per_sequence_t T_eventA6_sequence[] = {
  { &hf_nr_rrc_a6_Offset    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantityOffset },
  { &hf_nr_rrc_reportOnLeave, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { &hf_nr_rrc_useWhiteCellList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventA6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventA6, T_eventA6_sequence);

  return offset;
}


static const value_string nr_rrc_T_eventId_01_vals[] = {
  {   0, "eventA1" },
  {   1, "eventA2" },
  {   2, "eventA3" },
  {   3, "eventA4" },
  {   4, "eventA5" },
  {   5, "eventA6" },
  { 0, NULL }
};

static const per_choice_t T_eventId_01_choice[] = {
  {   0, &hf_nr_rrc_eventA1      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventA1 },
  {   1, &hf_nr_rrc_eventA2      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventA2 },
  {   2, &hf_nr_rrc_eventA3      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventA3 },
  {   3, &hf_nr_rrc_eventA4      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventA4 },
  {   4, &hf_nr_rrc_eventA5      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventA5 },
  {   5, &hf_nr_rrc_eventA6      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventA6 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_eventId_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_eventId_01, T_eventId_01_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_reportAmount_02_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reportAmount_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_reportAddNeighMeas_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reportAddNeighMeas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EventTriggerConfig_sequence[] = {
  { &hf_nr_rrc_eventId_01   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_eventId_01 },
  { &hf_nr_rrc_rsType       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_RS_Type },
  { &hf_nr_rrc_reportInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportInterval },
  { &hf_nr_rrc_reportAmount_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reportAmount_02 },
  { &hf_nr_rrc_reportQuantityCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasReportQuantity },
  { &hf_nr_rrc_maxReportCells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxCellReport },
  { &hf_nr_rrc_reportQuantityRS_Indexes, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasReportQuantity },
  { &hf_nr_rrc_maxNrofRS_IndexesToReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxNrofIndexesToReport },
  { &hf_nr_rrc_includeBeamMeasurements, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_reportAddNeighMeas, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_reportAddNeighMeas },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EventTriggerConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EventTriggerConfig, EventTriggerConfig_sequence);

  return offset;
}


static const per_sequence_t ReportCGI_sequence[] = {
  { &hf_nr_rrc_cellForWhichToReportCGI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReportCGI, ReportCGI_sequence);

  return offset;
}


static const value_string nr_rrc_T_reportSFTD_NeighMeas_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reportSFTD_NeighMeas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_drx_SFTD_NeighMeas_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_drx_SFTD_NeighMeas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId_sequence_of[1] = {
  { &hf_nr_rrc_cellsForWhichToReportSFTD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId, SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId_sequence_of,
                                                  1, maxCellSFTD, FALSE);

  return offset;
}


static const per_sequence_t ReportSFTD_NR_eag_1_sequence[] = {
  { &hf_nr_rrc_reportSFTD_NeighMeas, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_reportSFTD_NeighMeas },
  { &hf_nr_rrc_drx_SFTD_NeighMeas, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_drx_SFTD_NeighMeas },
  { &hf_nr_rrc_cellsForWhichToReportSFTD, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportSFTD_NR_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ReportSFTD_NR_eag_1_sequence);

  return offset;
}


static const per_sequence_t ReportSFTD_NR_sequence[] = {
  { &hf_nr_rrc_reportSFTD_Meas, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_reportRSRP   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportSFTD_NR_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportSFTD_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReportSFTD_NR, ReportSFTD_NR_sequence);

  return offset;
}


static const value_string nr_rrc_T_reportType_01_vals[] = {
  {   0, "periodical" },
  {   1, "eventTriggered" },
  {   2, "reportCGI" },
  {   3, "reportSFTD" },
  { 0, NULL }
};

static const per_choice_t T_reportType_01_choice[] = {
  {   0, &hf_nr_rrc_periodical_01, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_PeriodicalReportConfig },
  {   1, &hf_nr_rrc_eventTriggered_01, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_EventTriggerConfig },
  {   2, &hf_nr_rrc_reportCGI_01 , ASN1_NOT_EXTENSION_ROOT, dissect_nr_rrc_ReportCGI },
  {   3, &hf_nr_rrc_reportSFTD_01, ASN1_NOT_EXTENSION_ROOT, dissect_nr_rrc_ReportSFTD_NR },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_reportType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_reportType_01, T_reportType_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ReportConfigNR_sequence[] = {
  { &hf_nr_rrc_reportType_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reportType_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportConfigNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReportConfigNR, ReportConfigNR_sequence);

  return offset;
}


static const value_string nr_rrc_T_reportAmount_01_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reportAmount_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PeriodicalReportConfigInterRAT_sequence[] = {
  { &hf_nr_rrc_reportInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportInterval },
  { &hf_nr_rrc_reportAmount_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reportAmount_01 },
  { &hf_nr_rrc_reportQuantity_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasReportQuantity },
  { &hf_nr_rrc_maxReportCells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxCellReport },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PeriodicalReportConfigInterRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PeriodicalReportConfigInterRAT, PeriodicalReportConfigInterRAT_sequence);

  return offset;
}


static const value_string nr_rrc_MeasTriggerQuantityEUTRA_vals[] = {
  {   0, "rsrp" },
  {   1, "rsrq" },
  {   2, "sinr" },
  { 0, NULL }
};

static const per_choice_t MeasTriggerQuantityEUTRA_choice[] = {
  {   0, &hf_nr_rrc_rsrp_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RSRP_RangeEUTRA },
  {   1, &hf_nr_rrc_rsrq_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RSRQ_RangeEUTRA },
  {   2, &hf_nr_rrc_sinr_01      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SINR_RangeEUTRA },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_MeasTriggerQuantityEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_MeasTriggerQuantityEUTRA, MeasTriggerQuantityEUTRA_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_eventB1_sequence[] = {
  { &hf_nr_rrc_b1_ThresholdEUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantityEUTRA },
  { &hf_nr_rrc_reportOnLeave, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventB1, T_eventB1_sequence);

  return offset;
}


static const per_sequence_t T_eventB2_sequence[] = {
  { &hf_nr_rrc_b2_Threshold1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantity },
  { &hf_nr_rrc_b2_Threshold2EUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasTriggerQuantityEUTRA },
  { &hf_nr_rrc_reportOnLeave, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_hysteresis   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_Hysteresis },
  { &hf_nr_rrc_timeToTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_TimeToTrigger },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_eventB2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_eventB2, T_eventB2_sequence);

  return offset;
}


static const value_string nr_rrc_T_eventId_vals[] = {
  {   0, "eventB1" },
  {   1, "eventB2" },
  { 0, NULL }
};

static const per_choice_t T_eventId_choice[] = {
  {   0, &hf_nr_rrc_eventB1      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventB1 },
  {   1, &hf_nr_rrc_eventB2      , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_T_eventB2 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_eventId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_eventId, T_eventId_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_reportAmount_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_reportAmount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EventTriggerConfigInterRAT_sequence[] = {
  { &hf_nr_rrc_eventId      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_eventId },
  { &hf_nr_rrc_rsType       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NR_RS_Type },
  { &hf_nr_rrc_reportInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportInterval },
  { &hf_nr_rrc_reportAmount , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reportAmount },
  { &hf_nr_rrc_reportQuantity_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasReportQuantity },
  { &hf_nr_rrc_maxReportCells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxCellReport },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EventTriggerConfigInterRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EventTriggerConfigInterRAT, EventTriggerConfigInterRAT_sequence);

  return offset;
}


static const per_sequence_t ReportCGI_EUTRA_sequence[] = {
  { &hf_nr_rrc_cellForWhichToReportCGI_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_PhysCellId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportCGI_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReportCGI_EUTRA, ReportCGI_EUTRA_sequence);

  return offset;
}


static const per_sequence_t ReportSFTD_EUTRA_sequence[] = {
  { &hf_nr_rrc_reportSFTD_Meas, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_reportRSRP   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportSFTD_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReportSFTD_EUTRA, ReportSFTD_EUTRA_sequence);

  return offset;
}


static const value_string nr_rrc_T_reportType_vals[] = {
  {   0, "periodical" },
  {   1, "eventTriggered" },
  {   2, "reportCGI" },
  {   3, "reportSFTD" },
  { 0, NULL }
};

static const per_choice_t T_reportType_choice[] = {
  {   0, &hf_nr_rrc_periodical   , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_PeriodicalReportConfigInterRAT },
  {   1, &hf_nr_rrc_eventTriggered, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_EventTriggerConfigInterRAT },
  {   2, &hf_nr_rrc_reportCGI    , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_ReportCGI_EUTRA },
  {   3, &hf_nr_rrc_reportSFTD   , ASN1_NOT_EXTENSION_ROOT, dissect_nr_rrc_ReportSFTD_EUTRA },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_reportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_reportType, T_reportType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ReportConfigInterRAT_sequence[] = {
  { &hf_nr_rrc_reportType   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reportType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportConfigInterRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReportConfigInterRAT, ReportConfigInterRAT_sequence);

  return offset;
}


static const value_string nr_rrc_T_reportConfig_vals[] = {
  {   0, "reportConfigNR" },
  {   1, "reportConfigInterRAT" },
  { 0, NULL }
};

static const per_choice_t T_reportConfig_choice[] = {
  {   0, &hf_nr_rrc_reportConfigNR, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_ReportConfigNR },
  {   1, &hf_nr_rrc_reportConfigInterRAT, ASN1_NOT_EXTENSION_ROOT, dissect_nr_rrc_ReportConfigInterRAT },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_reportConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_reportConfig, T_reportConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ReportConfigToAddMod_sequence[] = {
  { &hf_nr_rrc_reportConfigId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportConfigId },
  { &hf_nr_rrc_reportConfig , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_reportConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReportConfigToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReportConfigToAddMod, ReportConfigToAddMod_sequence);

  return offset;
}


static const per_sequence_t ReportConfigToAddModList_sequence_of[1] = {
  { &hf_nr_rrc_ReportConfigToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportConfigToAddMod },
};

static int
dissect_nr_rrc_ReportConfigToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_ReportConfigToAddModList, ReportConfigToAddModList_sequence_of,
                                                  1, maxReportConfigId, FALSE);

  return offset;
}



static int
dissect_nr_rrc_MeasId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrofMeasId, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasIdToRemoveList_sequence_of[1] = {
  { &hf_nr_rrc_MeasIdToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasId },
};

static int
dissect_nr_rrc_MeasIdToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasIdToRemoveList, MeasIdToRemoveList_sequence_of,
                                                  1, maxNrofMeasId, FALSE);

  return offset;
}


static const per_sequence_t MeasIdToAddMod_sequence[] = {
  { &hf_nr_rrc_measId       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasId },
  { &hf_nr_rrc_measObjectId , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasObjectId },
  { &hf_nr_rrc_reportConfigId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReportConfigId },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasIdToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasIdToAddMod, MeasIdToAddMod_sequence);

  return offset;
}


static const per_sequence_t MeasIdToAddModList_sequence_of[1] = {
  { &hf_nr_rrc_MeasIdToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasIdToAddMod },
};

static int
dissect_nr_rrc_MeasIdToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasIdToAddModList, MeasIdToAddModList_sequence_of,
                                                  1, maxNrofMeasId, FALSE);

  return offset;
}


static const value_string nr_rrc_T_s_MeasureConfig_vals[] = {
  {   0, "ssb-RSRP" },
  {   1, "csi-RSRP" },
  { 0, NULL }
};

static const per_choice_t T_s_MeasureConfig_choice[] = {
  {   0, &hf_nr_rrc_ssb_RSRP     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RSRP_Range },
  {   1, &hf_nr_rrc_csi_RSRP     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RSRP_Range },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_s_MeasureConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_s_MeasureConfig, T_s_MeasureConfig_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_FilterCoefficient_vals[] = {
  {   0, "fc0" },
  {   1, "fc1" },
  {   2, "fc2" },
  {   3, "fc3" },
  {   4, "fc4" },
  {   5, "fc5" },
  {   6, "fc6" },
  {   7, "fc7" },
  {   8, "fc8" },
  {   9, "fc9" },
  {  10, "fc11" },
  {  11, "fc13" },
  {  12, "fc15" },
  {  13, "fc17" },
  {  14, "fc19" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_FilterCoefficient(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t FilterConfig_sequence[] = {
  { &hf_nr_rrc_filterCoefficientRSRP, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FilterCoefficient },
  { &hf_nr_rrc_filterCoefficientRSRQ, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FilterCoefficient },
  { &hf_nr_rrc_filterCoefficientRS_SINR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FilterCoefficient },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FilterConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FilterConfig, FilterConfig_sequence);

  return offset;
}


static const per_sequence_t QuantityConfigRS_sequence[] = {
  { &hf_nr_rrc_ssb_FilterConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FilterConfig },
  { &hf_nr_rrc_csi_RS_FilterConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FilterConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_QuantityConfigRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_QuantityConfigRS, QuantityConfigRS_sequence);

  return offset;
}


static const per_sequence_t QuantityConfigNR_sequence[] = {
  { &hf_nr_rrc_quantityConfigCell, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_QuantityConfigRS },
  { &hf_nr_rrc_quantityConfigRS_Index, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_QuantityConfigRS },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_QuantityConfigNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_QuantityConfigNR, QuantityConfigNR_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR_sequence_of[1] = {
  { &hf_nr_rrc_quantityConfigNR_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_QuantityConfigNR },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR, SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR_sequence_of,
                                                  1, maxNrofQuantityConfig, FALSE);

  return offset;
}


static const per_sequence_t QuantityConfig_eag_1_sequence[] = {
  { &hf_nr_rrc_quantityConfigEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_FilterConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_QuantityConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, QuantityConfig_eag_1_sequence);

  return offset;
}


static const per_sequence_t QuantityConfig_sequence[] = {
  { &hf_nr_rrc_quantityConfigNR_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_QuantityConfig_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_QuantityConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_QuantityConfig, QuantityConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_gapFR2_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_gapFR2_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_GapConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_gapFR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_gapFR2, T_gapFR2_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_gapFR1_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_gapFR1_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_GapConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_gapFR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_gapFR1, T_gapFR1_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_gapUE_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_gapUE_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_GapConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_gapUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_gapUE, T_gapUE_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasGapConfig_eag_1_sequence[] = {
  { &hf_nr_rrc_gapFR1       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapFR1 },
  { &hf_nr_rrc_gapUE        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapUE },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasGapConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasGapConfig_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasGapConfig_sequence[] = {
  { &hf_nr_rrc_gapFR2       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapFR2 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasGapConfig_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasGapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasGapConfig, MeasGapConfig_sequence);

  return offset;
}


static const value_string nr_rrc_MeasGapSharingScheme_vals[] = {
  {   0, "scheme00" },
  {   1, "scheme01" },
  {   2, "scheme10" },
  {   3, "scheme11" },
  { 0, NULL }
};


static int
dissect_nr_rrc_MeasGapSharingScheme(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_gapSharingFR2_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_gapSharingFR2_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_26     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MeasGapSharingScheme },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_gapSharingFR2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_gapSharingFR2, T_gapSharingFR2_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_gapSharingFR1_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_gapSharingFR1_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_26     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MeasGapSharingScheme },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_gapSharingFR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_gapSharingFR1, T_gapSharingFR1_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_gapSharingUE_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_gapSharingUE_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_26     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MeasGapSharingScheme },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_gapSharingUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_gapSharingUE, T_gapSharingUE_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasGapSharingConfig_eag_1_sequence[] = {
  { &hf_nr_rrc_gapSharingFR1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapSharingFR1 },
  { &hf_nr_rrc_gapSharingUE , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapSharingUE },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasGapSharingConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasGapSharingConfig_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasGapSharingConfig_sequence[] = {
  { &hf_nr_rrc_gapSharingFR2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_gapSharingFR2 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasGapSharingConfig_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasGapSharingConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasGapSharingConfig, MeasGapSharingConfig_sequence);

  return offset;
}


static const per_sequence_t MeasConfig_sequence[] = {
  { &hf_nr_rrc_measObjectToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasObjectToRemoveList },
  { &hf_nr_rrc_measObjectToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasObjectToAddModList },
  { &hf_nr_rrc_reportConfigToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReportConfigToRemoveList },
  { &hf_nr_rrc_reportConfigToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_ReportConfigToAddModList },
  { &hf_nr_rrc_measIdToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasIdToRemoveList },
  { &hf_nr_rrc_measIdToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasIdToAddModList },
  { &hf_nr_rrc_s_MeasureConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_s_MeasureConfig },
  { &hf_nr_rrc_quantityConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_QuantityConfig },
  { &hf_nr_rrc_measGapConfig_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasGapConfig },
  { &hf_nr_rrc_measGapSharingConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasGapSharingConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasConfig, MeasConfig_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_masterCellGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_CellGroupConfig_PDU);

  return offset;
}


static const value_string nr_rrc_T_fullConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_fullConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_DedicatedNAS_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nas_5gs_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &nas_5gs_tvb);

  if (nas_5gs_tvb && nas_5gs_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_DedicatedNAS_Message);
    nr_rrc_call_dissector(nas_5gs_handle, nas_5gs_tvb, actx->pinfo, subtree);
  }


  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message_sequence_of[1] = {
  { &hf_nr_rrc_dedicatedNAS_MessageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DedicatedNAS_Message },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message, SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}



static int
dissect_nr_rrc_NextHopChainingCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_nas_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nas_5gs_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &nas_5gs_tvb);

  if (nas_5gs_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_nas_Container);
    de_nas_5gs_s1_mode_to_n1_mode_nas_transparent_cont(nas_5gs_tvb, subtree, actx->pinfo);
  }


  return offset;
}


static const per_sequence_t MasterKeyUpdate_sequence[] = {
  { &hf_nr_rrc_keySetChangeIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_nextHopChainingCount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NextHopChainingCount },
  { &hf_nr_rrc_nas_Container, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_nas_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MasterKeyUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MasterKeyUpdate, MasterKeyUpdate_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_dedicatedSIB1_Delivery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_SIB1_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_dedicatedSystemInformationDelivery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_SystemInformation_PDU);

  return offset;
}


static const value_string nr_rrc_T_delayBudgetReportingProhibitTimer_vals[] = {
  {   0, "s0" },
  {   1, "s0dot4" },
  {   2, "s0dot8" },
  {   3, "s1dot6" },
  {   4, "s3" },
  {   5, "s6" },
  {   6, "s12" },
  {   7, "s30" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_delayBudgetReportingProhibitTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_sequence[] = {
  { &hf_nr_rrc_delayBudgetReportingProhibitTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_delayBudgetReportingProhibitTimer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_setup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_setup, T_setup_sequence);

  return offset;
}


static const value_string nr_rrc_T_delayBudgetReportingConfig_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_delayBudgetReportingConfig_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_51     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_setup },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_delayBudgetReportingConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_delayBudgetReportingConfig, T_delayBudgetReportingConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t OtherConfig_sequence[] = {
  { &hf_nr_rrc_delayBudgetReportingConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_delayBudgetReportingConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_OtherConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_OtherConfig, OtherConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_overheatingIndicationProhibitTimer_vals[] = {
  {   0, "s0" },
  {   1, "s0dot5" },
  {   2, "s1" },
  {   3, "s2" },
  {   4, "s5" },
  {   5, "s10" },
  {   6, "s20" },
  {   7, "s30" },
  {   8, "s60" },
  {   9, "s90" },
  {  10, "s120" },
  {  11, "s300" },
  {  12, "s600" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_overheatingIndicationProhibitTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t OverheatingAssistanceConfig_sequence[] = {
  { &hf_nr_rrc_overheatingIndicationProhibitTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_overheatingIndicationProhibitTimer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_OverheatingAssistanceConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_OverheatingAssistanceConfig, OverheatingAssistanceConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_overheatingAssistanceConfig_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_overheatingAssistanceConfig_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_52     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_OverheatingAssistanceConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_overheatingAssistanceConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_overheatingAssistanceConfig, T_overheatingAssistanceConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t OtherConfig_v1540_sequence[] = {
  { &hf_nr_rrc_overheatingAssistanceConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_overheatingAssistanceConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_OtherConfig_v1540(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_OtherConfig_v1540, OtherConfig_v1540_sequence);

  return offset;
}


static const value_string nr_rrc_T_mrdc_ReleaseAndAdd_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_mrdc_ReleaseAndAdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_T_nr_SCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfiguration_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_eutra_SCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *eutra_scg_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &eutra_scg_tvb);

  if (eutra_scg_tvb && lte_rrc_conn_reconf_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_eutra_SCG);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_handle, eutra_scg_tvb, actx->pinfo, subtree);
  }


  return offset;
}


static const value_string nr_rrc_T_mrdc_SecondaryCellGroup_vals[] = {
  {   0, "nr-SCG" },
  {   1, "eutra-SCG" },
  { 0, NULL }
};

static const per_choice_t T_mrdc_SecondaryCellGroup_choice[] = {
  {   0, &hf_nr_rrc_nr_SCG       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_nr_SCG },
  {   1, &hf_nr_rrc_eutra_SCG    , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_eutra_SCG },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_mrdc_SecondaryCellGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_mrdc_SecondaryCellGroup, T_mrdc_SecondaryCellGroup_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MRDC_SecondaryCellGroupConfig_sequence[] = {
  { &hf_nr_rrc_mrdc_ReleaseAndAdd, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_mrdc_ReleaseAndAdd },
  { &hf_nr_rrc_mrdc_SecondaryCellGroup, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_mrdc_SecondaryCellGroup },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MRDC_SecondaryCellGroupConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MRDC_SecondaryCellGroupConfig, MRDC_SecondaryCellGroupConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_mrdc_SecondaryCellGroupConfig_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_mrdc_SecondaryCellGroupConfig_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_02     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MRDC_SecondaryCellGroupConfig },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_mrdc_SecondaryCellGroupConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_mrdc_SecondaryCellGroupConfig, T_mrdc_SecondaryCellGroupConfig_choice,
                                 NULL);

  return offset;
}



static int
dissect_nr_rrc_T_radioBearerConfig2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}



static int
dissect_nr_rrc_SK_Counter(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_17_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_17, T_nonCriticalExtension_17_sequence);

  return offset;
}


static const per_sequence_t RRCReconfiguration_v1560_IEs_sequence[] = {
  { &hf_nr_rrc_mrdc_SecondaryCellGroupConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_mrdc_SecondaryCellGroupConfig },
  { &hf_nr_rrc_radioBearerConfig2, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_radioBearerConfig2 },
  { &hf_nr_rrc_sk_Counter   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SK_Counter },
  { &hf_nr_rrc_nonCriticalExtension_26, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfiguration_v1560_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfiguration_v1560_IEs, RRCReconfiguration_v1560_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCReconfiguration_v1540_IEs_sequence[] = {
  { &hf_nr_rrc_otherConfig_v1540, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OtherConfig_v1540 },
  { &hf_nr_rrc_nonCriticalExtension_25, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRCReconfiguration_v1560_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfiguration_v1540_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfiguration_v1540_IEs, RRCReconfiguration_v1540_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCReconfiguration_v1530_IEs_sequence[] = {
  { &hf_nr_rrc_masterCellGroup, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_masterCellGroup },
  { &hf_nr_rrc_fullConfig   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_fullConfig },
  { &hf_nr_rrc_dedicatedNAS_MessageList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message },
  { &hf_nr_rrc_masterKeyUpdate, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MasterKeyUpdate },
  { &hf_nr_rrc_dedicatedSIB1_Delivery, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dedicatedSIB1_Delivery },
  { &hf_nr_rrc_dedicatedSystemInformationDelivery, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_dedicatedSystemInformationDelivery },
  { &hf_nr_rrc_otherConfig  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OtherConfig },
  { &hf_nr_rrc_nonCriticalExtension_24, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRCReconfiguration_v1540_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfiguration_v1530_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfiguration_v1530_IEs, RRCReconfiguration_v1530_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCReconfiguration_IEs_sequence[] = {
  { &hf_nr_rrc_radioBearerConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RadioBearerConfig },
  { &hf_nr_rrc_secondaryCellGroup, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_secondaryCellGroup },
  { &hf_nr_rrc_measConfig   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasConfig },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_23, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRCReconfiguration_v1530_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfiguration_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfiguration_IEs, RRCReconfiguration_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_16_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_16, T_criticalExtensionsFuture_16_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_16_vals[] = {
  {   0, "rrcReconfiguration" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_16_choice[] = {
  {   0, &hf_nr_rrc_rrcReconfiguration_02, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReconfiguration_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_16, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_16, T_criticalExtensions_16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReconfiguration_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Reconfiguration");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfiguration, RRCReconfiguration_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_masterCellGroup_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_CellGroupConfig_PDU);

  return offset;
}


static const value_string nr_rrc_T_fullConfig_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_fullConfig_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_T_radioBearerConfig2_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RadioBearerConfig_PDU);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_21_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_21, T_nonCriticalExtension_21_sequence);

  return offset;
}


static const per_sequence_t RRCResume_v1560_IEs_sequence[] = {
  { &hf_nr_rrc_radioBearerConfig2_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_radioBearerConfig2_01 },
  { &hf_nr_rrc_sk_Counter   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SK_Counter },
  { &hf_nr_rrc_nonCriticalExtension_34, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_21 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResume_v1560_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResume_v1560_IEs, RRCResume_v1560_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCResume_IEs_sequence[] = {
  { &hf_nr_rrc_radioBearerConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RadioBearerConfig },
  { &hf_nr_rrc_masterCellGroup_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_masterCellGroup_01 },
  { &hf_nr_rrc_measConfig   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasConfig },
  { &hf_nr_rrc_fullConfig_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_fullConfig_01 },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_33, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRCResume_v1560_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResume_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResume_IEs, RRCResume_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_20_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_20, T_criticalExtensionsFuture_20_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_20_vals[] = {
  {   0, "rrcResume" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_20_choice[] = {
  {   0, &hf_nr_rrc_rrcResume_01 , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCResume_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_20, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_20 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_20, T_criticalExtensions_20_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCResume_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_20, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResume(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Resume");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResume, RRCResume_sequence);

  return offset;
}


static const per_sequence_t CarrierInfoNR_sequence[] = {
  { &hf_nr_rrc_carrierFreq  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_ssbSubcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SubcarrierSpacing },
  { &hf_nr_rrc_smtc         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_SSB_MTC },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CarrierInfoNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CarrierInfoNR, CarrierInfoNR_sequence);

  return offset;
}


static const value_string nr_rrc_T_cnType_vals[] = {
  {   0, "epc" },
  {   1, "fiveGC" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_cnType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RedirectedCarrierInfo_EUTRA_sequence[] = {
  { &hf_nr_rrc_eutraFrequency, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_cnType       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_cnType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RedirectedCarrierInfo_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RedirectedCarrierInfo_EUTRA, RedirectedCarrierInfo_EUTRA_sequence);

  return offset;
}


static const value_string nr_rrc_RedirectedCarrierInfo_vals[] = {
  {   0, "nr" },
  {   1, "eutra" },
  { 0, NULL }
};

static const per_choice_t RedirectedCarrierInfo_choice[] = {
  {   0, &hf_nr_rrc_nr           , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_CarrierInfoNR },
  {   1, &hf_nr_rrc_eutra        , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_RedirectedCarrierInfo_EUTRA },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_RedirectedCarrierInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_RedirectedCarrierInfo, RedirectedCarrierInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t FreqPriorityEUTRA_sequence[] = {
  { &hf_nr_rrc_carrierFreq_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellReselectionPriority },
  { &hf_nr_rrc_cellReselectionSubPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionSubPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FreqPriorityEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FreqPriorityEUTRA, FreqPriorityEUTRA_sequence);

  return offset;
}


static const per_sequence_t FreqPriorityListEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_FreqPriorityListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqPriorityEUTRA },
};

static int
dissect_nr_rrc_FreqPriorityListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_FreqPriorityListEUTRA, FreqPriorityListEUTRA_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const per_sequence_t FreqPriorityNR_sequence[] = {
  { &hf_nr_rrc_carrierFreq  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueNR },
  { &hf_nr_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_CellReselectionPriority },
  { &hf_nr_rrc_cellReselectionSubPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionSubPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_FreqPriorityNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_FreqPriorityNR, FreqPriorityNR_sequence);

  return offset;
}


static const per_sequence_t FreqPriorityListNR_sequence_of[1] = {
  { &hf_nr_rrc_FreqPriorityListNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_FreqPriorityNR },
};

static int
dissect_nr_rrc_FreqPriorityListNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_FreqPriorityListNR, FreqPriorityListNR_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const value_string nr_rrc_T_t320_vals[] = {
  {   0, "min5" },
  {   1, "min10" },
  {   2, "min20" },
  {   3, "min30" },
  {   4, "min60" },
  {   5, "min120" },
  {   6, "min180" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_t320(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CellReselectionPriorities_sequence[] = {
  { &hf_nr_rrc_freqPriorityListEUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_FreqPriorityListEUTRA },
  { &hf_nr_rrc_freqPriorityListNR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_FreqPriorityListNR },
  { &hf_nr_rrc_t320         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_t320 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CellReselectionPriorities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CellReselectionPriorities, CellReselectionPriorities_sequence);

  return offset;
}



static int
dissect_nr_rrc_I_RNTI_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     40, 40, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_nr_rrc_ShortI_RNTI_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_PeriodicRNAU_TimerValue_vals[] = {
  {   0, "min5" },
  {   1, "min10" },
  {   2, "min20" },
  {   3, "min30" },
  {   4, "min60" },
  {   5, "min120" },
  {   6, "min360" },
  {   7, "min720" },
  { 0, NULL }
};


static int
dissect_nr_rrc_PeriodicRNAU_TimerValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SuspendConfig_sequence[] = {
  { &hf_nr_rrc_fullI_RNTI   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_I_RNTI_Value },
  { &hf_nr_rrc_shortI_RNTI  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ShortI_RNTI_Value },
  { &hf_nr_rrc_ran_PagingCycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PagingCycle },
  { &hf_nr_rrc_ran_NotificationAreaInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_RAN_NotificationAreaInfo },
  { &hf_nr_rrc_t380         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_PeriodicRNAU_TimerValue },
  { &hf_nr_rrc_nextHopChainingCount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NextHopChainingCount },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SuspendConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SuspendConfig, SuspendConfig_sequence);

  return offset;
}


static const value_string nr_rrc_T_deprioritisationType_vals[] = {
  {   0, "frequency" },
  {   1, "nr" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_deprioritisationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nr_rrc_T_deprioritisationTimer_vals[] = {
  {   0, "min5" },
  {   1, "min10" },
  {   2, "min15" },
  {   3, "min30" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_deprioritisationTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_deprioritisationReq_sequence[] = {
  { &hf_nr_rrc_deprioritisationType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_deprioritisationType },
  { &hf_nr_rrc_deprioritisationTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_deprioritisationTimer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_deprioritisationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_deprioritisationReq, T_deprioritisationReq_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_20_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_20, T_nonCriticalExtension_20_sequence);

  return offset;
}


static const per_sequence_t RRCRelease_v1540_IEs_sequence[] = {
  { &hf_nr_rrc_waitTime     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RejectWaitTime },
  { &hf_nr_rrc_nonCriticalExtension_32, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCRelease_v1540_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCRelease_v1540_IEs, RRCRelease_v1540_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCRelease_IEs_sequence[] = {
  { &hf_nr_rrc_redirectedCarrierInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RedirectedCarrierInfo },
  { &hf_nr_rrc_cellReselectionPriorities, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_CellReselectionPriorities },
  { &hf_nr_rrc_suspendConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SuspendConfig },
  { &hf_nr_rrc_deprioritisationReq, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_deprioritisationReq },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_31, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRCRelease_v1540_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCRelease_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCRelease_IEs, RRCRelease_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_19_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_19, T_criticalExtensionsFuture_19_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_19_vals[] = {
  {   0, "rrcRelease" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_19_choice[] = {
  {   0, &hf_nr_rrc_rrcRelease_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCRelease_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_19, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_19 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_19, T_criticalExtensions_19_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCRelease_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_19, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_19 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCRelease(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Release");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCRelease, RRCRelease_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_15_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_15, T_nonCriticalExtension_15_sequence);

  return offset;
}


static const per_sequence_t RRCReestablishment_IEs_sequence[] = {
  { &hf_nr_rrc_nextHopChainingCount, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_NextHopChainingCount },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_21, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReestablishment_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReestablishment_IEs, RRCReestablishment_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_14_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_14, T_criticalExtensionsFuture_14_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_14_vals[] = {
  {   0, "rrcReestablishment" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_14_choice[] = {
  {   0, &hf_nr_rrc_rrcReestablishment_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReestablishment_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_14, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_14 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_14, T_criticalExtensions_14_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReestablishment_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_14, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReestablishment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Reestablishment");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReestablishment, RRCReestablishment_sequence);

  return offset;
}


static const per_sequence_t SecurityConfigSMC_sequence[] = {
  { &hf_nr_rrc_securityAlgorithmConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SecurityAlgorithmConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityConfigSMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityConfigSMC, SecurityConfigSMC_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_27_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_27, T_nonCriticalExtension_27_sequence);

  return offset;
}


static const per_sequence_t SecurityModeCommand_IEs_sequence[] = {
  { &hf_nr_rrc_securityConfigSMC, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SecurityConfigSMC },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_40, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_27 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityModeCommand_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityModeCommand_IEs, SecurityModeCommand_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_27_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_27, T_criticalExtensionsFuture_27_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_27_vals[] = {
  {   0, "securityModeCommand" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_27_choice[] = {
  {   0, &hf_nr_rrc_securityModeCommand_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SecurityModeCommand_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_27, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_27 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_27, T_criticalExtensions_27_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SecurityModeCommand_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_27, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_27 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityModeCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Security Mode Command");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityModeCommand, SecurityModeCommand_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_09_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_09, T_nonCriticalExtension_09_sequence);

  return offset;
}


static const per_sequence_t DLInformationTransfer_IEs_sequence[] = {
  { &hf_nr_rrc_dedicatedNAS_Message, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DedicatedNAS_Message },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_09 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DLInformationTransfer_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DLInformationTransfer_IEs, DLInformationTransfer_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_09_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_09, T_criticalExtensionsFuture_09_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_09_vals[] = {
  {   0, "dlInformationTransfer" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_09_choice[] = {
  {   0, &hf_nr_rrc_dlInformationTransfer_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_DLInformationTransfer_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_09, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_09 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_09, T_criticalExtensions_09_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DLInformationTransfer_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_09, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_09 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DLInformationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "DL Information Transfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DLInformationTransfer, DLInformationTransfer_sequence);

  return offset;
}



static int
dissect_nr_rrc_T_capabilityRequestFilter(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cap_req_filter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &cap_req_filter_tvb);



  if (cap_req_filter_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;

    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_capabilityRequestFilter);
    switch(nr_priv->rat_type){
    case RAT_Type_nr:
      dissect_nr_rrc_UE_CapabilityRequestFilterNR_PDU(cap_req_filter_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }

  return offset;
}


static const per_sequence_t UE_CapabilityRAT_Request_sequence[] = {
  { &hf_nr_rrc_rat_Type     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RAT_Type },
  { &hf_nr_rrc_capabilityRequestFilter, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_capabilityRequestFilter },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UE_CapabilityRAT_Request(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  /* Initialise to invalid value */
  nr_priv->rat_type = 0xFF;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UE_CapabilityRAT_Request, UE_CapabilityRAT_Request_sequence);



  return offset;
}


static const per_sequence_t UE_CapabilityRAT_RequestList_sequence_of[1] = {
  { &hf_nr_rrc_UE_CapabilityRAT_RequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UE_CapabilityRAT_Request },
};

static int
dissect_nr_rrc_UE_CapabilityRAT_RequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_UE_CapabilityRAT_RequestList, UE_CapabilityRAT_RequestList_sequence_of,
                                                  1, maxRAT_CapabilityContainers, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_ue_CapabilityEnquiryExt(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_UECapabilityEnquiry_v1560_IEs_PDU);

  return offset;
}


static const per_sequence_t UECapabilityEnquiry_IEs_sequence[] = {
  { &hf_nr_rrc_ue_CapabilityRAT_RequestList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UE_CapabilityRAT_RequestList },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_ue_CapabilityEnquiryExt, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ue_CapabilityEnquiryExt },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UECapabilityEnquiry_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UECapabilityEnquiry_IEs, UECapabilityEnquiry_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_32_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_32, T_criticalExtensionsFuture_32_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_32_vals[] = {
  {   0, "ueCapabilityEnquiry" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_32_choice[] = {
  {   0, &hf_nr_rrc_ueCapabilityEnquiry_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UECapabilityEnquiry_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_32, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_32 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_32, T_criticalExtensions_32_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UECapabilityEnquiry_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_32, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_32 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UECapabilityEnquiry(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "UE Capability Enquiry");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UECapabilityEnquiry, UECapabilityEnquiry_sequence);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_33554431(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 33554431U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DRB_CountMSB_Info_sequence[] = {
  { &hf_nr_rrc_drb_Identity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DRB_Identity },
  { &hf_nr_rrc_countMSB_Uplink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_33554431 },
  { &hf_nr_rrc_countMSB_Downlink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_33554431 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DRB_CountMSB_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DRB_CountMSB_Info, DRB_CountMSB_Info_sequence);

  return offset;
}


static const per_sequence_t DRB_CountMSB_InfoList_sequence_of[1] = {
  { &hf_nr_rrc_DRB_CountMSB_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DRB_CountMSB_Info },
};

static int
dissect_nr_rrc_DRB_CountMSB_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_DRB_CountMSB_InfoList, DRB_CountMSB_InfoList_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_07_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_07, T_nonCriticalExtension_07_sequence);

  return offset;
}


static const per_sequence_t CounterCheck_IEs_sequence[] = {
  { &hf_nr_rrc_drb_CountMSB_InfoList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DRB_CountMSB_InfoList },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_07 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CounterCheck_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CounterCheck_IEs, CounterCheck_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_07_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_07, T_criticalExtensionsFuture_07_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_07_vals[] = {
  {   0, "counterCheck" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_07_choice[] = {
  {   0, &hf_nr_rrc_counterCheck_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_CounterCheck_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_07, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_07 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_07, T_criticalExtensions_07_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CounterCheck_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_07, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_07 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_CounterCheck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Counter Check");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_CounterCheck, CounterCheck_sequence);

  return offset;
}


static const value_string nr_rrc_T_targetRAT_Type_vals[] = {
  { T_targetRAT_Type_eutra, "eutra" },
  { T_targetRAT_Type_spare3, "spare3" },
  { T_targetRAT_Type_spare2, "spare2" },
  { T_targetRAT_Type_spare1, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_targetRAT_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 target_rat_type;
  nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, &target_rat_type, TRUE, 0, NULL);

  nr_priv->target_rat_type = (guint8)target_rat_type;


  return offset;
}



static int
dissect_nr_rrc_T_targetRAT_MessageContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *target_rat_msg_cont_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &target_rat_msg_cont_tvb);

  if (target_rat_msg_cont_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_rr_rrc_targetRAT_MessageContainer);
    switch (nr_priv->target_rat_type) {
    case T_targetRAT_Type_eutra:
      /* eutra */
      if (lte_rrc_dl_dcch_handle)
        nr_rrc_call_dissector(lte_rrc_dl_dcch_handle, target_rat_msg_cont_tvb, actx->pinfo, subtree);
      break;
    default:
      break;
    }
  }


  return offset;
}



static int
dissect_nr_rrc_T_nas_SecurityParamFromNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nas_sec_param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &nas_sec_param_tvb);

  if (nas_sec_param_tvb) {
    nr_rrc_private_data_t *nr_priv = nr_rrc_get_private_data(actx);
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_rr_rrc_nas_SecurityParamFromNR);
    switch (nr_priv->target_rat_type) {
    case T_targetRAT_Type_eutra:
      /* eutra */
      de_nas_5gs_n1_mode_to_s1_mode_nas_transparent_cont(nas_sec_param_tvb, subtree, actx->pinfo);
      break;
    default:
      break;
    }
  }


  return offset;
}


static const per_sequence_t T_nonCriticalExtension_13_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_13, T_nonCriticalExtension_13_sequence);

  return offset;
}


static const per_sequence_t MobilityFromNRCommand_IEs_sequence[] = {
  { &hf_nr_rrc_targetRAT_Type, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_targetRAT_Type },
  { &hf_nr_rrc_targetRAT_MessageContainer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_targetRAT_MessageContainer },
  { &hf_nr_rrc_nas_SecurityParamFromNR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nas_SecurityParamFromNR },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_19, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MobilityFromNRCommand_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MobilityFromNRCommand_IEs, MobilityFromNRCommand_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_13_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_13, T_criticalExtensionsFuture_13_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_13_vals[] = {
  {   0, "mobilityFromNRCommand" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_13_choice[] = {
  {   0, &hf_nr_rrc_mobilityFromNRCommand_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MobilityFromNRCommand_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_13, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_13 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_13, T_criticalExtensions_13_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MobilityFromNRCommand_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_13, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MobilityFromNRCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Mobility From NR Command");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MobilityFromNRCommand, MobilityFromNRCommand_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_09_vals[] = {
  {   0, "rrcReconfiguration" },
  {   1, "rrcResume" },
  {   2, "rrcRelease" },
  {   3, "rrcReestablishment" },
  {   4, "securityModeCommand" },
  {   5, "dlInformationTransfer" },
  {   6, "ueCapabilityEnquiry" },
  {   7, "counterCheck" },
  {   8, "mobilityFromNRCommand" },
  {   9, "spare7" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_09_choice[] = {
  {   0, &hf_nr_rrc_rrcReconfiguration_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReconfiguration },
  {   1, &hf_nr_rrc_rrcResume    , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCResume },
  {   2, &hf_nr_rrc_rrcRelease   , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCRelease },
  {   3, &hf_nr_rrc_rrcReestablishment, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReestablishment },
  {   4, &hf_nr_rrc_securityModeCommand, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SecurityModeCommand },
  {   5, &hf_nr_rrc_dlInformationTransfer, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_DLInformationTransfer },
  {   6, &hf_nr_rrc_ueCapabilityEnquiry, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_UECapabilityEnquiry },
  {   7, &hf_nr_rrc_counterCheck , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_CounterCheck },
  {   8, &hf_nr_rrc_mobilityFromNRCommand, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MobilityFromNRCommand },
  {   9, &hf_nr_rrc_spare7       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {  10, &hf_nr_rrc_spare6       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {  11, &hf_nr_rrc_spare5       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {  12, &hf_nr_rrc_spare4       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {  13, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {  14, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {  15, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_09, T_c1_09_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension_03, T_messageClassExtension_03_sequence);

  return offset;
}


static const value_string nr_rrc_DL_DCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t DL_DCCH_MessageType_choice[] = {
  {   0, &hf_nr_rrc_c1_09        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_09 },
  {   1, &hf_nr_rrc_messageClassExtension_03, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension_03 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_DL_DCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_DL_DCCH_MessageType, DL_DCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DL_DCCH_Message_sequence[] = {
  { &hf_nr_rrc_message_03   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DL_DCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_DL_DCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  actx->pinfo->link_dir = P2P_DIR_DL;

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_DL_DCCH_Message, DL_DCCH_Message_sequence);

  return offset;
}



static int
dissect_nr_rrc_NG_5G_S_TMSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     48, 48, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_PagingUE_Identity_vals[] = {
  {   0, "ng-5G-S-TMSI" },
  {   1, "fullI-RNTI" },
  { 0, NULL }
};

static const per_choice_t PagingUE_Identity_choice[] = {
  {   0, &hf_nr_rrc_ng_5G_S_TMSI , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_NG_5G_S_TMSI },
  {   1, &hf_nr_rrc_fullI_RNTI   , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_I_RNTI_Value },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_PagingUE_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_PagingUE_Identity, PagingUE_Identity_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_accessType_vals[] = {
  {   0, "non3GPP" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_accessType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PagingRecord_sequence[] = {
  { &hf_nr_rrc_ue_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PagingUE_Identity },
  { &hf_nr_rrc_accessType   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_accessType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PagingRecord(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PagingRecord, PagingRecord_sequence);

  return offset;
}


static const per_sequence_t PagingRecordList_sequence_of[1] = {
  { &hf_nr_rrc_PagingRecordList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PagingRecord },
};

static int
dissect_nr_rrc_PagingRecordList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_PagingRecordList, PagingRecordList_sequence_of,
                                                  1, maxNrofPageRec, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_14_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_14, T_nonCriticalExtension_14_sequence);

  return offset;
}


static const per_sequence_t Paging_sequence[] = {
  { &hf_nr_rrc_pagingRecordList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PagingRecordList },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_20, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_Paging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Paging");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_Paging, Paging_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_10_vals[] = {
  {   0, "paging" },
  {   1, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_10_choice[] = {
  {   0, &hf_nr_rrc_paging       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_Paging },
  {   1, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_10, T_c1_10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension_04, T_messageClassExtension_04_sequence);

  return offset;
}


static const value_string nr_rrc_PCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t PCCH_MessageType_choice[] = {
  {   0, &hf_nr_rrc_c1_10        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_10 },
  {   1, &hf_nr_rrc_messageClassExtension_04, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension_04 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_PCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_PCCH_MessageType, PCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PCCH_Message_sequence[] = {
  { &hf_nr_rrc_message_04   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_PCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_PCCH_Message, PCCH_Message_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     39, 39, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_InitialUE_Identity_vals[] = {
  {   0, "ng-5G-S-TMSI-Part1" },
  {   1, "randomValue" },
  { 0, NULL }
};

static const per_choice_t InitialUE_Identity_choice[] = {
  {   0, &hf_nr_rrc_ng_5G_S_TMSI_Part1, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_39 },
  {   1, &hf_nr_rrc_randomValue  , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_39 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_InitialUE_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_InitialUE_Identity, InitialUE_Identity_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_EstablishmentCause_vals[] = {
  {   0, "emergency" },
  {   1, "highPriorityAccess" },
  {   2, "mt-Access" },
  {   3, "mo-Signalling" },
  {   4, "mo-Data" },
  {   5, "mo-VoiceCall" },
  {   6, "mo-VideoCall" },
  {   7, "mo-SMS" },
  {   8, "mps-PriorityAccess" },
  {   9, "mcs-PriorityAccess" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_EstablishmentCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RRCSetupRequest_IEs_sequence[] = {
  { &hf_nr_rrc_ue_Identity_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_InitialUE_Identity },
  { &hf_nr_rrc_establishmentCause, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EstablishmentCause },
  { &hf_nr_rrc_spare        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSetupRequest_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSetupRequest_IEs, RRCSetupRequest_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCSetupRequest_sequence[] = {
  { &hf_nr_rrc_rrcSetupRequest_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRCSetupRequest_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSetupRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Setup Request");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSetupRequest, RRCSetupRequest_sequence);

  return offset;
}


static const value_string nr_rrc_ResumeCause_vals[] = {
  {   0, "emergency" },
  {   1, "highPriorityAccess" },
  {   2, "mt-Access" },
  {   3, "mo-Signalling" },
  {   4, "mo-Data" },
  {   5, "mo-VoiceCall" },
  {   6, "mo-VideoCall" },
  {   7, "mo-SMS" },
  {   8, "rna-Update" },
  {   9, "mps-PriorityAccess" },
  {  10, "mcs-PriorityAccess" },
  {  11, "spare1" },
  {  12, "spare2" },
  {  13, "spare3" },
  {  14, "spare4" },
  {  15, "spare5" },
  { 0, NULL }
};


static int
dissect_nr_rrc_ResumeCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RRCResumeRequest_IEs_sequence[] = {
  { &hf_nr_rrc_resumeIdentity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ShortI_RNTI_Value },
  { &hf_nr_rrc_resumeMAC_I  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_16 },
  { &hf_nr_rrc_resumeCause  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ResumeCause },
  { &hf_nr_rrc_spare        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResumeRequest_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResumeRequest_IEs, RRCResumeRequest_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCResumeRequest_sequence[] = {
  { &hf_nr_rrc_rrcResumeRequest_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRCResumeRequest_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResumeRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Resume Request");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResumeRequest, RRCResumeRequest_sequence);

  return offset;
}



static int
dissect_nr_rrc_RNTI_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ReestabUE_Identity_sequence[] = {
  { &hf_nr_rrc_c_RNTI       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RNTI_Value },
  { &hf_nr_rrc_physCellId   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_PhysCellId },
  { &hf_nr_rrc_shortMAC_I   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ShortMAC_I },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ReestabUE_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ReestabUE_Identity, ReestabUE_Identity_sequence);

  return offset;
}


static const value_string nr_rrc_ReestablishmentCause_vals[] = {
  {   0, "reconfigurationFailure" },
  {   1, "handoverFailure" },
  {   2, "otherFailure" },
  {   3, "spare1" },
  { 0, NULL }
};


static int
dissect_nr_rrc_ReestablishmentCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RRCReestablishmentRequest_IEs_sequence[] = {
  { &hf_nr_rrc_ue_Identity_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReestabUE_Identity },
  { &hf_nr_rrc_reestablishmentCause, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ReestablishmentCause },
  { &hf_nr_rrc_spare        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReestablishmentRequest_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReestablishmentRequest_IEs, RRCReestablishmentRequest_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCReestablishmentRequest_sequence[] = {
  { &hf_nr_rrc_rrcReestablishmentRequest_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRCReestablishmentRequest_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReestablishmentRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Reestablishment Request");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReestablishmentRequest, RRCReestablishmentRequest_sequence);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_maxSI_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     maxSI_Message, maxSI_Message, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t RRCSystemInfoRequest_r15_IEs_sequence[] = {
  { &hf_nr_rrc_requested_SI_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_maxSI_Message },
  { &hf_nr_rrc_spare_01     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSystemInfoRequest_r15_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSystemInfoRequest_r15_IEs, RRCSystemInfoRequest_r15_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_24_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_24, T_criticalExtensionsFuture_24_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_24_vals[] = {
  {   0, "rrcSystemInfoRequest-r15" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_24_choice[] = {
  {   0, &hf_nr_rrc_rrcSystemInfoRequest_r15, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCSystemInfoRequest_r15_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_24, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_24 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_24, T_criticalExtensions_24_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCSystemInfoRequest_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_24, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSystemInfoRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC System Info Request");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSystemInfoRequest, RRCSystemInfoRequest_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_11_vals[] = {
  {   0, "rrcSetupRequest" },
  {   1, "rrcResumeRequest" },
  {   2, "rrcReestablishmentRequest" },
  {   3, "rrcSystemInfoRequest" },
  { 0, NULL }
};

static const per_choice_t T_c1_11_choice[] = {
  {   0, &hf_nr_rrc_rrcSetupRequest, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCSetupRequest },
  {   1, &hf_nr_rrc_rrcResumeRequest, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCResumeRequest },
  {   2, &hf_nr_rrc_rrcReestablishmentRequest, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReestablishmentRequest },
  {   3, &hf_nr_rrc_rrcSystemInfoRequest, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCSystemInfoRequest },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_11, T_c1_11_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension_05, T_messageClassExtension_05_sequence);

  return offset;
}


static const value_string nr_rrc_UL_CCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t UL_CCCH_MessageType_choice[] = {
  {   0, &hf_nr_rrc_c1_11        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_11 },
  {   1, &hf_nr_rrc_messageClassExtension_05, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension_05 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_UL_CCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_UL_CCCH_MessageType, UL_CCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UL_CCCH_Message_sequence[] = {
  { &hf_nr_rrc_message_05   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UL_CCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UL_CCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  actx->pinfo->link_dir = P2P_DIR_UL;

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UL_CCCH_Message, UL_CCCH_Message_sequence);

  return offset;
}


static const per_sequence_t RRCResumeRequest1_IEs_sequence[] = {
  { &hf_nr_rrc_resumeIdentity_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_I_RNTI_Value },
  { &hf_nr_rrc_resumeMAC_I  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_16 },
  { &hf_nr_rrc_resumeCause  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ResumeCause },
  { &hf_nr_rrc_spare        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BIT_STRING_SIZE_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResumeRequest1_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResumeRequest1_IEs, RRCResumeRequest1_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCResumeRequest1_sequence[] = {
  { &hf_nr_rrc_rrcResumeRequest1_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRCResumeRequest1_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResumeRequest1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Resume Request 1");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResumeRequest1, RRCResumeRequest1_sequence);

  return offset;
}


static const value_string nr_rrc_T_c1_12_vals[] = {
  {   0, "rrcResumeRequest1" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_12_choice[] = {
  {   0, &hf_nr_rrc_rrcResumeRequest1, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCResumeRequest1 },
  {   1, &hf_nr_rrc_spare3       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   2, &hf_nr_rrc_spare2       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   3, &hf_nr_rrc_spare1       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_c1_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_c1_12, T_c1_12_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_06_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_messageClassExtension_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_messageClassExtension_06, T_messageClassExtension_06_sequence);

  return offset;
}


static const value_string nr_rrc_UL_CCCH1_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t UL_CCCH1_MessageType_choice[] = {
  {   0, &hf_nr_rrc_c1_12        , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_c1_12 },
  {   1, &hf_nr_rrc_messageClassExtension_06, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_messageClassExtension_06 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_UL_CCCH1_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_UL_CCCH1_MessageType, UL_CCCH1_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UL_CCCH1_Message_sequence[] = {
  { &hf_nr_rrc_message_06   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UL_CCCH1_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UL_CCCH1_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *ti;

  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "NR RRC");
  col_clear(actx->pinfo->cinfo, COL_INFO);

  ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  tree = proto_item_add_subtree(ti, ett_nr_rrc);

  actx->pinfo->link_dir = P2P_DIR_UL;

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UL_CCCH1_Message, UL_CCCH1_Message_sequence);

  return offset;
}


static const per_sequence_t MeasResultServMO_sequence[] = {
  { &hf_nr_rrc_servCellId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_measResultServingCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultNR },
  { &hf_nr_rrc_measResultBestNeighCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultNR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResultServMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResultServMO, MeasResultServMO_sequence);

  return offset;
}


static const per_sequence_t MeasResultServMOList_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultServMOList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultServMO },
};

static int
dissect_nr_rrc_MeasResultServMOList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultServMOList, MeasResultServMOList_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const per_sequence_t MeasResultListEUTRA_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultEUTRA },
};

static int
dissect_nr_rrc_MeasResultListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultListEUTRA, MeasResultListEUTRA_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}


static const value_string nr_rrc_T_measResultNeighCells_vals[] = {
  {   0, "measResultListNR" },
  {   1, "measResultListEUTRA" },
  { 0, NULL }
};

static const per_choice_t T_measResultNeighCells_choice[] = {
  {   0, &hf_nr_rrc_measResultListNR, ASN1_EXTENSION_ROOT    , dissect_nr_rrc_MeasResultListNR },
  {   1, &hf_nr_rrc_measResultListEUTRA, ASN1_NOT_EXTENSION_ROOT, dissect_nr_rrc_MeasResultListEUTRA },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_measResultNeighCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_measResultNeighCells, T_measResultNeighCells_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasResultServFreqListNR_SCG_sequence_of[1] = {
  { &hf_nr_rrc_MeasResultServFreqListNR_SCG_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResult2NR },
};

static int
dissect_nr_rrc_MeasResultServFreqListNR_SCG(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_MeasResultServFreqListNR_SCG, MeasResultServFreqListNR_SCG_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}


static const per_sequence_t MeasResults_eag_1_sequence[] = {
  { &hf_nr_rrc_measResultServFreqListEUTRA_SCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultServFreqListEUTRA_SCG },
  { &hf_nr_rrc_measResultServFreqListNR_SCG, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultServFreqListNR_SCG },
  { &hf_nr_rrc_measResultSFTD_EUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultSFTD_EUTRA },
  { &hf_nr_rrc_measResultSFTD_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultCellSFTD_NR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResults_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasResults_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasResults_eag_2_sequence[] = {
  { &hf_nr_rrc_measResultCellListSFTD_NR, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_MeasResultCellListSFTD_NR },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResults_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasResults_eag_2_sequence);

  return offset;
}


static const per_sequence_t MeasResults_sequence[] = {
  { &hf_nr_rrc_measId       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasId },
  { &hf_nr_rrc_measResultServingMOList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResultServMOList },
  { &hf_nr_rrc_measResultNeighCells, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nr_rrc_T_measResultNeighCells },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResults_eag_1 },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResults_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasResults, MeasResults_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_12_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_12, T_nonCriticalExtension_12_sequence);

  return offset;
}


static const per_sequence_t MeasurementReport_IEs_sequence[] = {
  { &hf_nr_rrc_measResults  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_MeasResults },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementReport_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementReport_IEs, MeasurementReport_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_12_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_12, T_criticalExtensionsFuture_12_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_12_vals[] = {
  {   0, "measurementReport" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_12_choice[] = {
  {   0, &hf_nr_rrc_measurementReport_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_MeasurementReport_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_12, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_12, T_criticalExtensions_12_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasurementReport_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_12, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_MeasurementReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Measurement Report");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_MeasurementReport, MeasurementReport_sequence);

  return offset;
}



static int
dissect_nr_rrc_BWP_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofBWPs, NULL, FALSE);

  return offset;
}



static int
dissect_nr_rrc_INTEGER_0_3301(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3301U, NULL, FALSE);

  return offset;
}


static const per_sequence_t UplinkTxDirectCurrentBWP_sequence[] = {
  { &hf_nr_rrc_bwp_Id       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BWP_Id },
  { &hf_nr_rrc_shift7dot5kHz, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_BOOLEAN },
  { &hf_nr_rrc_txDirectCurrentLocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_3301 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UplinkTxDirectCurrentBWP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UplinkTxDirectCurrentBWP, UplinkTxDirectCurrentBWP_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP_sequence_of[1] = {
  { &hf_nr_rrc_uplinkDirectCurrentBWP_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UplinkTxDirectCurrentBWP },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP, SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP_sequence_of,
                                                  1, maxNrofBWPs, FALSE);

  return offset;
}


static const per_sequence_t UplinkTxDirectCurrentCell_eag_1_sequence[] = {
  { &hf_nr_rrc_uplinkDirectCurrentBWP_SUL, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UplinkTxDirectCurrentCell_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, UplinkTxDirectCurrentCell_eag_1_sequence);

  return offset;
}


static const per_sequence_t UplinkTxDirectCurrentCell_sequence[] = {
  { &hf_nr_rrc_servCellIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ServCellIndex },
  { &hf_nr_rrc_uplinkDirectCurrentBWP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP },
  { &dummy_hf_nr_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nr_rrc_UplinkTxDirectCurrentCell_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UplinkTxDirectCurrentCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UplinkTxDirectCurrentCell, UplinkTxDirectCurrentCell_sequence);

  return offset;
}


static const per_sequence_t UplinkTxDirectCurrentList_sequence_of[1] = {
  { &hf_nr_rrc_UplinkTxDirectCurrentList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_UplinkTxDirectCurrentCell },
};

static int
dissect_nr_rrc_UplinkTxDirectCurrentList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_UplinkTxDirectCurrentList, UplinkTxDirectCurrentList_sequence_of,
                                                  1, maxNrofServingCells, FALSE);

  return offset;
}



static int
dissect_nr_rrc_T_nr_SCG_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_nr_rrc_RRCReconfigurationComplete_PDU);

  return offset;
}



static int
dissect_nr_rrc_T_eutra_SCG_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *eutra_scg_response_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &eutra_scg_response_tvb);

  if (eutra_scg_response_tvb && lte_rrc_conn_reconf_compl_handle) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_nr_rrc_eutra_SCG_Response);
    nr_rrc_call_dissector(lte_rrc_conn_reconf_compl_handle, eutra_scg_response_tvb, actx->pinfo, subtree);
  }


  return offset;
}


static const value_string nr_rrc_T_scg_Response_vals[] = {
  {   0, "nr-SCG-Response" },
  {   1, "eutra-SCG-Response" },
  { 0, NULL }
};

static const per_choice_t T_scg_Response_choice[] = {
  {   0, &hf_nr_rrc_nr_SCG_Response, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_nr_SCG_Response },
  {   1, &hf_nr_rrc_eutra_SCG_Response, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_eutra_SCG_Response },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_scg_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_scg_Response, T_scg_Response_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_18_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_18, T_nonCriticalExtension_18_sequence);

  return offset;
}


static const per_sequence_t RRCReconfigurationComplete_v1560_IEs_sequence[] = {
  { &hf_nr_rrc_scg_Response , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_scg_Response },
  { &hf_nr_rrc_nonCriticalExtension_29, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfigurationComplete_v1560_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfigurationComplete_v1560_IEs, RRCReconfigurationComplete_v1560_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCReconfigurationComplete_v1530_IEs_sequence[] = {
  { &hf_nr_rrc_uplinkTxDirectCurrentList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UplinkTxDirectCurrentList },
  { &hf_nr_rrc_nonCriticalExtension_28, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRCReconfigurationComplete_v1560_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfigurationComplete_v1530_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfigurationComplete_v1530_IEs, RRCReconfigurationComplete_v1530_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCReconfigurationComplete_IEs_sequence[] = {
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_27, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RRCReconfigurationComplete_v1530_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfigurationComplete_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfigurationComplete_IEs, RRCReconfigurationComplete_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_17_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_17, T_criticalExtensionsFuture_17_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_17_vals[] = {
  {   0, "rrcReconfigurationComplete" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_17_choice[] = {
  {   0, &hf_nr_rrc_rrcReconfigurationComplete_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReconfigurationComplete_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_17, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_17 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_17, T_criticalExtensions_17_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReconfigurationComplete_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReconfigurationComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_nr_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Reconfiguration Complete");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReconfigurationComplete, RRCReconfigurationComplete_sequence);

  return offset;
}



static int
dissect_nr_rrc_AMF_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t RegisteredAMF_sequence[] = {
  { &hf_nr_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_PLMN_Identity },
  { &hf_nr_rrc_amf_Identifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_AMF_Identifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RegisteredAMF(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RegisteredAMF, RegisteredAMF_sequence);

  return offset;
}


static const value_string nr_rrc_T_guami_Type_vals[] = {
  {   0, "native" },
  {   1, "mapped" },
  { 0, NULL }
};


static int
dissect_nr_rrc_T_guami_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_S_NSSAI_vals[] = {
  {   0, "sst" },
  {   1, "sst-SD" },
  { 0, NULL }
};

static const per_choice_t S_NSSAI_choice[] = {
  {   0, &hf_nr_rrc_sst          , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_8 },
  {   1, &hf_nr_rrc_sst_SD       , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_32 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_S_NSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_S_NSSAI, S_NSSAI_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI_sequence_of[1] = {
  { &hf_nr_rrc_s_NSSAI_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_S_NSSAI },
};

static int
dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI, SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI_sequence_of,
                                                  1, maxNrofS_NSSAI, FALSE);

  return offset;
}



static int
dissect_nr_rrc_BIT_STRING_SIZE_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     9, 9, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string nr_rrc_T_ng_5G_S_TMSI_Value_vals[] = {
  {   0, "ng-5G-S-TMSI" },
  {   1, "ng-5G-S-TMSI-Part2" },
  { 0, NULL }
};

static const per_choice_t T_ng_5G_S_TMSI_Value_choice[] = {
  {   0, &hf_nr_rrc_ng_5G_S_TMSI , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NG_5G_S_TMSI },
  {   1, &hf_nr_rrc_ng_5G_S_TMSI_Part2, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_BIT_STRING_SIZE_9 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_ng_5G_S_TMSI_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_ng_5G_S_TMSI_Value, T_ng_5G_S_TMSI_Value_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_24_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_24, T_nonCriticalExtension_24_sequence);

  return offset;
}


static const per_sequence_t RRCSetupComplete_IEs_sequence[] = {
  { &hf_nr_rrc_selectedPLMN_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_1_maxPLMN },
  { &hf_nr_rrc_registeredAMF, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_RegisteredAMF },
  { &hf_nr_rrc_guami_Type   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_guami_Type },
  { &hf_nr_rrc_s_NSSAI_List , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI },
  { &hf_nr_rrc_dedicatedNAS_Message, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_DedicatedNAS_Message },
  { &hf_nr_rrc_ng_5G_S_TMSI_Value, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_ng_5G_S_TMSI_Value },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_37, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSetupComplete_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSetupComplete_IEs, RRCSetupComplete_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_23_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_23, T_criticalExtensionsFuture_23_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_23_vals[] = {
  {   0, "rrcSetupComplete" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_23_choice[] = {
  {   0, &hf_nr_rrc_rrcSetupComplete_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCSetupComplete_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_23, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_23 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_23, T_criticalExtensions_23_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCSetupComplete_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_23, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCSetupComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Setup Complete");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCSetupComplete, RRCSetupComplete_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_16_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_16, T_nonCriticalExtension_16_sequence);

  return offset;
}


static const per_sequence_t RRCReestablishmentComplete_IEs_sequence[] = {
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_22, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReestablishmentComplete_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReestablishmentComplete_IEs, RRCReestablishmentComplete_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_15_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_15, T_criticalExtensionsFuture_15_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_15_vals[] = {
  {   0, "rrcReestablishmentComplete" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_15_choice[] = {
  {   0, &hf_nr_rrc_rrcReestablishmentComplete_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCReestablishmentComplete_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_15, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_15 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_15, T_criticalExtensions_15_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReestablishmentComplete_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCReestablishmentComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Reestablishment Complete");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCReestablishmentComplete, RRCReestablishmentComplete_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_22_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_22, T_nonCriticalExtension_22_sequence);

  return offset;
}


static const per_sequence_t RRCResumeComplete_IEs_sequence[] = {
  { &hf_nr_rrc_dedicatedNAS_Message, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DedicatedNAS_Message },
  { &hf_nr_rrc_selectedPLMN_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_INTEGER_1_maxPLMN },
  { &hf_nr_rrc_uplinkTxDirectCurrentList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UplinkTxDirectCurrentList },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_35, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_22 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResumeComplete_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResumeComplete_IEs, RRCResumeComplete_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_21_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_21, T_criticalExtensionsFuture_21_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_21_vals[] = {
  {   0, "rrcResumeComplete" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_21_choice[] = {
  {   0, &hf_nr_rrc_rrcResumeComplete_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_RRCResumeComplete_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_21, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_21 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_21, T_criticalExtensions_21_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCResumeComplete_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_21, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_21 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_RRCResumeComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RRC Resume Complete");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_RRCResumeComplete, RRCResumeComplete_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_28_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_28, T_nonCriticalExtension_28_sequence);

  return offset;
}


static const per_sequence_t SecurityModeComplete_IEs_sequence[] = {
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_41, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityModeComplete_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityModeComplete_IEs, SecurityModeComplete_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_28_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_28, T_criticalExtensionsFuture_28_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_28_vals[] = {
  {   0, "securityModeComplete" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_28_choice[] = {
  {   0, &hf_nr_rrc_securityModeComplete_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SecurityModeComplete_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_28, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_28 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_28, T_criticalExtensions_28_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SecurityModeComplete_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_28, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityModeComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Security Mode Complete");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityModeComplete, SecurityModeComplete_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_29_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_29, T_nonCriticalExtension_29_sequence);

  return offset;
}


static const per_sequence_t SecurityModeFailure_IEs_sequence[] = {
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_42, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_29 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityModeFailure_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityModeFailure_IEs, SecurityModeFailure_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_29_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_29, T_criticalExtensionsFuture_29_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_29_vals[] = {
  {   0, "securityModeFailure" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_29_choice[] = {
  {   0, &hf_nr_rrc_securityModeFailure_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_SecurityModeFailure_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_29, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_29 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_29, T_criticalExtensions_29_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SecurityModeFailure_sequence[] = {
  { &hf_nr_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_RRC_TransactionIdentifier },
  { &hf_nr_rrc_criticalExtensions_29, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_29 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_SecurityModeFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Security Mode Failure");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_SecurityModeFailure, SecurityModeFailure_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_35_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_35(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_35, T_nonCriticalExtension_35_sequence);

  return offset;
}


static const per_sequence_t ULInformationTransfer_IEs_sequence[] = {
  { &hf_nr_rrc_dedicatedNAS_Message, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_DedicatedNAS_Message },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_49, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_35 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ULInformationTransfer_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ULInformationTransfer_IEs, ULInformationTransfer_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_34_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_34(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_34, T_criticalExtensionsFuture_34_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_34_vals[] = {
  {   0, "ulInformationTransfer" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_34_choice[] = {
  {   0, &hf_nr_rrc_ulInformationTransfer_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_ULInformationTransfer_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_34, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_34 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_34(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_34, T_criticalExtensions_34_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ULInformationTransfer_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_34, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_34 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_ULInformationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "UL Information Transfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_ULInformationTransfer, ULInformationTransfer_sequence);

  return offset;
}


static const per_sequence_t EUTRA_RSTD_Info_sequence[] = {
  { &hf_nr_rrc_carrierFreq_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_ARFCN_ValueEUTRA },
  { &hf_nr_rrc_measPRS_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nr_rrc_INTEGER_0_39 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_EUTRA_RSTD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_EUTRA_RSTD_Info, EUTRA_RSTD_Info_sequence);

  return offset;
}


static const per_sequence_t EUTRA_RSTD_InfoList_sequence_of[1] = {
  { &hf_nr_rrc_EUTRA_RSTD_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_EUTRA_RSTD_Info },
};

static int
dissect_nr_rrc_EUTRA_RSTD_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nr_rrc_EUTRA_RSTD_InfoList, EUTRA_RSTD_InfoList_sequence_of,
                                                  1, maxInterRAT_RSTD_Freq, FALSE);

  return offset;
}


static const value_string nr_rrc_LocationMeasurementInfo_vals[] = {
  {   0, "eutra-RSTD" },
  {   1, "eutra-FineTimingDetection" },
  { 0, NULL }
};

static const per_choice_t LocationMeasurementInfo_choice[] = {
  {   0, &hf_nr_rrc_eutra_RSTD   , ASN1_EXTENSION_ROOT    , dissect_nr_rrc_EUTRA_RSTD_InfoList },
  {   1, &hf_nr_rrc_eutra_FineTimingDetection, ASN1_NOT_EXTENSION_ROOT, dissect_nr_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_LocationMeasurementInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_LocationMeasurementInfo, LocationMeasurementInfo_choice,
                                 NULL);

  return offset;
}


static const value_string nr_rrc_T_measurementIndication_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_measurementIndication_choice[] = {
  {   0, &hf_nr_rrc_release      , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_NULL },
  {   1, &hf_nr_rrc_setup_01     , ASN1_NO_EXTENSIONS     , dissect_nr_rrc_LocationMeasurementInfo },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_measurementIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_measurementIndication, T_measurementIndication_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_11_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_11, T_nonCriticalExtension_11_sequence);

  return offset;
}


static const per_sequence_t LocationMeasurementIndication_IEs_sequence[] = {
  { &hf_nr_rrc_measurementIndication, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_measurementIndication },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_LocationMeasurementIndication_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_LocationMeasurementIndication_IEs, LocationMeasurementIndication_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_11_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_11, T_criticalExtensionsFuture_11_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_11_vals[] = {
  {   0, "locationMeasurementIndication" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_11_choice[] = {
  {   0, &hf_nr_rrc_locationMeasurementIndication_01, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_LocationMeasurementIndication_IEs },
  {   1, &hf_nr_rrc_criticalExtensionsFuture_11, ASN1_NO_EXTENSIONS     , dissect_nr_rrc_T_criticalExtensionsFuture_11 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensions_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nr_rrc_T_criticalExtensions_11, T_criticalExtensions_11_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LocationMeasurementIndication_sequence[] = {
  { &hf_nr_rrc_criticalExtensions_11, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nr_rrc_T_criticalExtensions_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_LocationMeasurementIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Location Measurement Indication");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_LocationMeasurementIndication, LocationMeasurementIndication_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_34_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_nonCriticalExtension_34(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_nonCriticalExtension_34, T_nonCriticalExtension_34_sequence);

  return offset;
}


static const per_sequence_t UECapabilityInformation_IEs_sequence[] = {
  { &hf_nr_rrc_ue_CapabilityRAT_ContainerList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_UE_CapabilityRAT_ContainerList },
  { &hf_nr_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_OCTET_STRING },
  { &hf_nr_rrc_nonCriticalExtension_48, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_nr_rrc_T_nonCriticalExtension_34 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_UECapabilityInformation_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_UECapabilityInformation_IEs, UECapabilityInformation_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_33_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_nr_rrc_T_criticalExtensionsFuture_33(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nr_rrc_T_criticalExtensionsFuture_33, T_criticalExtensionsFuture_33_sequence);

  return offset;
}


static const value_string nr_rrc_T_criticalExtensions_33_vals[] = {
  {   0, "ueCapabilityInformatio