/* -*-mode: flex-*- */

%top {
/* Include this before everything else, for various large-file definitions */
#include "config.h"
}

/*
 * We don't use input, so don't generate code for it.
 */
%option noinput

/*
 * We don't use unput, so don't generate code for it.
 */
%option nounput

/*
 * We don't read interactively from the terminal.
 */
%option never-interactive

/*
 * We want to stop processing when we get to the end of the input.
 */
%option noyywrap

/*
 * Prefix scanner routines with "text2pcap_" rather than "yy" to avoid a
 * "redefined macro" warning with flex 2.6.3.
 */
%option prefix="text2pcap_"

%{

/********************************************************************************
 *
 * text2pcap-scanner.l
 *
 * Utility to convert an ASCII hexdump into a libpcap-format capture file
 *
 * (c) Copyright 2001 Ashok Narayanan <ashokn@cisco.com>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *******************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "text2pcap.h"

DIAG_OFF(sign-compare)

/*
 * Flex (v 2.5.35) uses this symbol to "exclude" unistd.h
 */
#ifdef _WIN32
#define YY_NO_UNISTD_H
#endif

#ifdef _WIN32
/* disable Windows VC compiler warning "signed/unsigned mismatch" associated  */
/* with YY_INPUT code generated by flex versions such as 2.5.35.              */
#pragma warning (disable:4018)
#endif

%}

hexdigit [0-9A-Fa-f]
directive ^#TEXT2PCAP.*\r?\n
comment ^[\t ]*#.*\r?\n
byte [0-9A-Fa-f][0-9A-Fa-f][ \t]
byte_eol [0-9A-Fa-f][0-9A-Fa-f]\r?\n
offset [0-9A-Fa-f]+[: \t]
offset_eol [0-9A-Fa-f]+\r?\n
text [^ \n\t]+
mailfwd >
eol \r?\n\r?

%%

{byte}            { if (parse_token(T_BYTE, yytext) != EXIT_SUCCESS) return EXIT_FAILURE; }
{byte_eol}        { if (parse_token(T_BYTE, yytext) != EXIT_SUCCESS) return EXIT_FAILURE;
	if (parse_token(T_EOL, NULL) != EXIT_SUCCESS) return EXIT_FAILURE; }
{offset}          { if (parse_token(T_OFFSET, yytext) != EXIT_SUCCESS) return EXIT_FAILURE; }
{offset_eol}      { if (parse_token(T_OFFSET, yytext) != EXIT_SUCCESS) return EXIT_FAILURE;
	if (parse_token(T_EOL, NULL) != EXIT_SUCCESS) return EXIT_FAILURE; }
{mailfwd}{offset} { if (parse_token(T_OFFSET, yytext+1) != EXIT_SUCCESS) return EXIT_FAILURE; }
{eol}             { if (parse_token(T_EOL, NULL) != EXIT_SUCCESS) return EXIT_FAILURE; }
[ \t]             ; /* ignore whitespace */
{directive}       { if (parse_token(T_DIRECTIVE, yytext) != EXIT_SUCCESS) return EXIT_FAILURE;
	if (parse_token(T_EOL, NULL) != EXIT_SUCCESS) return EXIT_FAILURE; }
{comment}         { if (parse_token(T_EOL, NULL) != EXIT_SUCCESS) return EXIT_FAILURE; }
{text}            { if (parse_token(T_TEXT, yytext) != EXIT_SUCCESS) return EXIT_FAILURE; }
