/* Do not modify this file.                                                   */
/* It is created automatically by the ASN.1 to Wireshark dissector compiler   */
/* packet-rrc.c                                                               */
/* ../../tools/asn2wrs.py -p rrc -c ./rrc.cnf -s ./packet-rrc-template -D . -O ../../epan/dissectors Class-definitions.asn PDU-definitions.asn InformationElements.asn Constant-definitions.asn Internode-definitions.asn */

/* Input file: packet-rrc-template.c */

#line 1 "../../asn1/rrc/packet-rrc-template.c"
/* packet-rrc.c
 * Routines for Universal Mobile Telecommunications System (UMTS);
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 25.331  packet dissection
 * Copyright 2006-2010, Anders Broman <anders.broman@ericsson.com>
 *
 * $Id: packet-rrc.c 48444 2013-03-20 21:15:19Z pascal $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Ref: 3GPP TS 25.331 V11.5.0 (2013-03)
 */

/**
 *
 * TODO:
 * - Fix ciphering information for circuit switched stuff
 */

#include "config.h"

#include <glib.h>
#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/conversation.h>
#include <epan/expert.h>

#include "packet-ber.h"
#include "packet-per.h"
#include "packet-rrc.h"
#include "packet-gsm_a_common.h"
#include "packet-umts_fp.h"

#ifdef _MSC_VER
/* disable: "warning C4049: compiler limit : terminating line number emission" */
#pragma warning(disable:4049)
/* disable: "warning C4146: unary minus operator applied to unsigned type, result still unsigned" */
#pragma warning(disable:4146)
#endif

#define PNAME  "Radio Resource Control (RRC) protocol"
#define PSNAME "RRC"
#define PFNAME "rrc"

extern int proto_fp;    /*Handler to FP*/

GTree * hsdsch_muxed_flows = NULL;
GTree * rrc_ciph_inf = NULL;
static int msg_type _U_;

static dissector_handle_t gsm_a_dtap_handle;
static dissector_handle_t rrc_ue_radio_access_cap_info_handle=NULL;
static dissector_handle_t rrc_pcch_handle=NULL;
static dissector_handle_t rrc_ul_ccch_handle=NULL;
static dissector_handle_t rrc_dl_ccch_handle=NULL;
static dissector_handle_t rrc_ul_dcch_handle=NULL;
static dissector_handle_t rrc_dl_dcch_handle=NULL;
static dissector_handle_t rrc_bcch_fach_handle=NULL;
static dissector_handle_t lte_rrc_ue_eutra_cap_handle=NULL;
static dissector_handle_t lte_rrc_dl_dcch_handle=NULL;
static dissector_handle_t gsm_rlcmac_dl_handle=NULL;

enum nas_sys_info_gsm_map {
  RRC_NAS_SYS_INFO_CS,
  RRC_NAS_SYS_INFO_PS,
  RRC_NAS_SYS_INFO_CN_COMMON
};

static guint32 rrc_nas_sys_info_gsm_map_type = RRC_NAS_SYS_INFO_CN_COMMON;

/* Forward declarations */
void proto_register_rrc(void);
void proto_reg_handoff_rrc(void);
static int dissect_UE_RadioAccessCapabilityInfo_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoTypeSB1_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoTypeSB2_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoType5_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoType11_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoType11bis_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoType22_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);

/* Include constants */

/*--- Included file: packet-rrc-val.h ---*/
#line 1 "../../asn1/rrc/packet-rrc-val.h"
#define hiPDSCHidentities              64
#define hiPUSCHidentities              64
#define hiRM                           256
#define maxAC                          16
#define maxAdditionalMeas              4
#define maxASC                         8
#define maxASCmap                      7
#define maxASCpersist                  6
#define maxCCTrCH                      8
#define maxCellMeas                    32
#define maxCellMeasOnSecULFreq         32
#define maxCellMeas_1                  31
#define maxCellMeasOnSecULFreq_1       31
#define maxCNdomains                   4
#define maxCommonHRNTI                 4
#define maxCommonQueueID               2
#define maxCPCHsets                    16
#define maxDedicatedCSGFreq            4
#define maxDPCH_DLchan                 8
#define maxDPDCH_UL                    6
#define maxDRACclasses                 8
#define maxExcludedDetectedSetCells    64
#define maxE_DCHMACdFlow               8
#define maxE_DCHMACdFlow_1             7
#define maxMultipleFrequencyBandsFDD   8
#define maxMultipleFrequencyBandsEUTRA 8
#define maxEUTRACellPerFreq            16
#define maxEUTRATargetFreqs            8
#define maxEDCHRL                      4
#define maxEDCHRL_1                    3
#define maxEDCHs                       32
#define maxEDCHs_1                     31
#define maxEDCHTxPattern_TDD128        4
#define maxEDCHTxPattern_TDD128_1      3
#define maxERNTIgroup                  32
#define maxERNTIperGroup               2
#define maxERUCCH                      256
#define maxFACHPCH                     8
#define maxFreq                        8
#define maxFreqBandsEUTRA              16
#define maxFreqBandsFDD                8
#define maxFreqBandsFDD2               22
#define maxFreqBandsFDD3               86
#define maxFreqBandsFDD_ext            15
#define maxFreqBandsFDD_ext2           64
#define maxFreqBandsFDD_ext3           78
#define maxFreqBandsIndicatorSupport   2
#define maxFreqBandsTDD                4
#define maxFreqBandsTDD_ext            16
#define maxFreqBandsGSM                16
#define maxFreqMeasWithoutCM           2
#define maxGANSS                       8
#define maxGANSS_1                     7
#define maxGANSSSat                    64
#define maxGANSSSat_1                  63
#define maxGERAN_SI                    8
#define maxGSMTargetCells              32
#define maxHNBNameSize                 48
#define maxHProcesses                  8
#define maxHS_SCCHLessTrBlk            4
#define maxHSDSCHTBIndex               64
#define maxHSDSCHTBIndex_tdd384        512
#define maxHSSCCHs                     4
#define maxHSSCCHs_1                   3
#define maxHSSICH_TDD128               4
#define maxHSSICH_TDD128_1             3
#define maxInterSysMessages            4
#define maxLoCHperRLC                  2
#define maxLoggedMeasReport            128
#define maxMAC_d_PDUsizes              8
#define maxMBMS_CommonCCTrCh           32
#define maxMBMS_CommonPhyCh            32
#define maxMBMS_CommonRB               32
#define maxMBMS_CommonTrCh             32
#define maxMBMS_Freq                   4
#define maxMBMS_L1CP                   4
#define maxMBMSservCount               8
#define maxMBMSservModif               32
#define maxMBMSservSched               16
#define maxMBMSservSelect              8
#define maxMBMSservUnmodif             64
#define maxMBMSTransmis                4
#define maxMBSFNClusters               16
#define maxMeasCSGRange                4
#define maxMeasEvent                   8
#define maxMeasEventOnSecULFreq        8
#define maxMeasIntervals               3
#define maxMeasOccasionPattern         5
#define maxMeasOccasionPattern_1       4
#define maxMeasParEvent                2
#define maxNonContiguousMultiCellCombinations 3
#define maxNumCDMA2000Freqs            8
#define maxNumE_AGCH                   4
#define maxNumE_HICH                   4
#define maxNumEUTRAFreqs               8
#define maxNumEUTRAFreqs_FACH          4
#define maxNumGSMCellGroup             16
#define maxNumGSMFreqRanges            32
#define maxNumFDDFreqs                 8
#define maxNumANRLoggedItems           4
#define maxnumLoggedMeas               8
#define maxNumMDTPLMN                  15
#define maxNumTDDFreqs                 8
#define maxNoOfMeas                    16
#define maxOtherRAT                    15
#define maxOtherRAT_16                 16
#define maxPage1                       8
#define maxPCPCH_APsig                 16
#define maxPCPCH_APsubCh               12
#define maxPCPCH_CDsig                 16
#define maxPCPCH_CDsubCh               12
#define maxPCPCH_SF                    7
#define maxPCPCHs                      64
#define maxPDCPAlgoType                8
#define maxPDSCH                       8
#define maxPDSCH_TFCIgroups            256
#define maxPRACH                       16
#define maxPRACH_EUL                   4
#define maxPRACH_FPACH                 8
#define maxPredefConfig                16
#define maxPrio                        8
#define maxPrio_1                      7
#define maxPUSCH                       8
#define maxQueueIDs                    8
#define maxRABsetup                    16
#define maxRAT                         16
#define maxRB                          32
#define maxRBallRABs                   27
#define maxRBMuxOptions                8
#define maxRBperRAB                    8
#define maxRBperTrCh                   16
#define maxReportedEUTRACellPerFreq    4
#define maxReportedEUTRAFreqs          4
#define maxReportedGSMCells            8
#define maxRL                          8
#define maxRL_1                        7
#define maxRLCPDUsizePerLogChan        32
#define maxRFC3095_CID                 16384
#define maxROHC_PacketSizes_r4         16
#define maxROHC_Profile_r4             8
#define maxRxPatternForHSDSCH_TDD128   4
#define maxRxPatternForHSDSCH_TDD128_1 3
#define maxSat                         16
#define maxSatClockModels              4
#define maxSCCPCH                      16
#define maxSgnType                     8
#define maxSIB                         32
#define maxSIB_FACH                    8
#define maxSIBperMsg                   16
#define maxSIrequest                   4
#define maxSRBsetup                    8
#define maxSystemCapability            16
#define maxTDD128Carrier               6
#define maxTDD128Carrier_1             5
#define maxTbsForHSDSCH_TDD128         4
#define maxTbsForHSDSCH_TDD128_1       3
#define maxTF                          32
#define maxTF_CPCH                     16
#define maxTFC                         1024
#define maxTFCsub                      1024
#define maxTFCI_2_Combs                512
#define maxTGPS                        6
#define maxTrCH                        32
#define maxTrCHpreconf                 32
#define maxTS                          14
#define maxTS_1                        13
#define maxTS_2                        12
#define maxTS_LCR                      6
#define maxTS_LCR_1                    5
#define maxURA                         8
#define maxURNTI_Group                 8

/*--- End of included file: packet-rrc-val.h ---*/
#line 100 "../../asn1/rrc/packet-rrc-template.c"

/* Initialize the protocol and registered fields */
int proto_rrc = -1;
static int hf_test;

/*--- Included file: packet-rrc-hf.c ---*/
#line 1 "../../asn1/rrc/packet-rrc-hf.c"
static int hf_rrc_DL_DCCH_Message_PDU = -1;       /* DL_DCCH_Message */
static int hf_rrc_UL_DCCH_Message_PDU = -1;       /* UL_DCCH_Message */
static int hf_rrc_DL_CCCH_Message_PDU = -1;       /* DL_CCCH_Message */
static int hf_rrc_UL_CCCH_Message_PDU = -1;       /* UL_CCCH_Message */
static int hf_rrc_PCCH_Message_PDU = -1;          /* PCCH_Message */
static int hf_rrc_DL_SHCCH_Message_PDU = -1;      /* DL_SHCCH_Message */
static int hf_rrc_UL_SHCCH_Message_PDU = -1;      /* UL_SHCCH_Message */
static int hf_rrc_BCCH_FACH_Message_PDU = -1;     /* BCCH_FACH_Message */
static int hf_rrc_BCCH_BCH_Message_PDU = -1;      /* BCCH_BCH_Message */
static int hf_rrc_MCCH_Message_PDU = -1;          /* MCCH_Message */
static int hf_rrc_MSCH_Message_PDU = -1;          /* MSCH_Message */
static int hf_rrc_rrc_HandoverToUTRANCommand_PDU = -1;  /* HandoverToUTRANCommand */
static int hf_rrc_rrc_InterRATHandoverInfo_PDU = -1;  /* InterRATHandoverInfo */
static int hf_rrc_SystemInformation_BCH_PDU = -1;  /* SystemInformation_BCH */
static int hf_rrc_System_Information_Container_PDU = -1;  /* System_Information_Container */
static int hf_rrc_UE_RadioAccessCapabilityInfo_PDU = -1;  /* UE_RadioAccessCapabilityInfo */
static int hf_rrc_rrc_MasterInformationBlock_PDU = -1;  /* MasterInformationBlock */
static int hf_rrc_rrc_SysInfoType1_PDU = -1;      /* SysInfoType1 */
static int hf_rrc_rrc_SysInfoType2_PDU = -1;      /* SysInfoType2 */
static int hf_rrc_rrc_SysInfoType3_PDU = -1;      /* SysInfoType3 */
static int hf_rrc_SysInfoType4_PDU = -1;          /* SysInfoType4 */
static int hf_rrc_SysInfoType5_PDU = -1;          /* SysInfoType5 */
static int hf_rrc_SysInfoType5bis_PDU = -1;       /* SysInfoType5bis */
static int hf_rrc_SysInfoType6_PDU = -1;          /* SysInfoType6 */
static int hf_rrc_rrc_SysInfoType7_PDU = -1;      /* SysInfoType7 */
static int hf_rrc_SysInfoType8_PDU = -1;          /* SysInfoType8 */
static int hf_rrc_SysInfoType9_PDU = -1;          /* SysInfoType9 */
static int hf_rrc_SysInfoType10_PDU = -1;         /* SysInfoType10 */
static int hf_rrc_SysInfoType11_PDU = -1;         /* SysInfoType11 */
static int hf_rrc_SysInfoType11bis_PDU = -1;      /* SysInfoType11bis */
static int hf_rrc_rrc_SysInfoType12_PDU = -1;     /* SysInfoType12 */
static int hf_rrc_SysInfoType13_PDU = -1;         /* SysInfoType13 */
static int hf_rrc_SysInfoType13_1_PDU = -1;       /* SysInfoType13_1 */
static int hf_rrc_SysInfoType13_2_PDU = -1;       /* SysInfoType13_2 */
static int hf_rrc_SysInfoType13_3_PDU = -1;       /* SysInfoType13_3 */
static int hf_rrc_SysInfoType13_4_PDU = -1;       /* SysInfoType13_4 */
static int hf_rrc_SysInfoType14_PDU = -1;         /* SysInfoType14 */
static int hf_rrc_SysInfoType15_PDU = -1;         /* SysInfoType15 */
static int hf_rrc_SysInfoType15bis_PDU = -1;      /* SysInfoType15bis */
static int hf_rrc_SysInfoType15_1_PDU = -1;       /* SysInfoType15_1 */
static int hf_rrc_SysInfoType15_1bis_PDU = -1;    /* SysInfoType15_1bis */
static int hf_rrc_SysInfoType15_2_PDU = -1;       /* SysInfoType15_2 */
static int hf_rrc_SysInfoType15_2bis_PDU = -1;    /* SysInfoType15_2bis */
static int hf_rrc_SysInfoType15_2ter_PDU = -1;    /* SysInfoType15_2ter */
static int hf_rrc_SysInfoType15_3_PDU = -1;       /* SysInfoType15_3 */
static int hf_rrc_SysInfoType15_3bis_PDU = -1;    /* SysInfoType15_3bis */
static int hf_rrc_SysInfoType15_4_PDU = -1;       /* SysInfoType15_4 */
static int hf_rrc_SysInfoType15_5_PDU = -1;       /* SysInfoType15_5 */
static int hf_rrc_SysInfoType15_6_PDU = -1;       /* SysInfoType15_6 */
static int hf_rrc_SysInfoType15_7_PDU = -1;       /* SysInfoType15_7 */
static int hf_rrc_SysInfoType15_8_PDU = -1;       /* SysInfoType15_8 */
static int hf_rrc_SysInfoType16_PDU = -1;         /* SysInfoType16 */
static int hf_rrc_SysInfoType17_PDU = -1;         /* SysInfoType17 */
static int hf_rrc_SysInfoType18_PDU = -1;         /* SysInfoType18 */
static int hf_rrc_SysInfoType19_PDU = -1;         /* SysInfoType19 */
static int hf_rrc_SysInfoType20_PDU = -1;         /* SysInfoType20 */
static int hf_rrc_SysInfoType21_PDU = -1;         /* SysInfoType21 */
static int hf_rrc_SysInfoType22_PDU = -1;         /* SysInfoType22 */
static int hf_rrc_SysInfoTypeSB1_PDU = -1;        /* SysInfoTypeSB1 */
static int hf_rrc_SysInfoTypeSB2_PDU = -1;        /* SysInfoTypeSB2 */
static int hf_rrc_rrc_ToTargetRNC_Container_PDU = -1;  /* ToTargetRNC_Container */
static int hf_rrc_rrc_TargetRNC_ToSourceRNC_Container_PDU = -1;  /* TargetRNC_ToSourceRNC_Container */
static int hf_rrc_CellUpdate_r3_add_ext_IEs_PDU = -1;  /* CellUpdate_r3_add_ext_IEs */
static int hf_rrc_CellUpdateConfirm_r7_add_ext_IEs_PDU = -1;  /* CellUpdateConfirm_r7_add_ext_IEs */
static int hf_rrc_InitialDirectTransfer_r3_add_ext_IEs_PDU = -1;  /* InitialDirectTransfer_r3_add_ext_IEs */
static int hf_rrc_InterRATHandoverInfo_r3_add_ext_IEs_PDU = -1;  /* InterRATHandoverInfo_r3_add_ext_IEs */
static int hf_rrc_RadioBearerSetup_r7_add_ext_IEs_PDU = -1;  /* RadioBearerSetup_r7_add_ext_IEs */
static int hf_rrc_RRCConnectionSetupComplete_r3_add_ext_IEs_PDU = -1;  /* RRCConnectionSetupComplete_r3_add_ext_IEs */
static int hf_rrc_UE_CapabilityContainer_IEs_PDU = -1;  /* UE_CapabilityContainer_IEs */
static int hf_rrc_UECapabilityInformation_r3_add_ext_IEs_PDU = -1;  /* UECapabilityInformation_r3_add_ext_IEs */
static int hf_rrc_URAUpdate_r3_add_ext_IEs_PDU = -1;  /* URAUpdate_r3_add_ext_IEs */
static int hf_rrc_SRNC_RelocationInfo_v3h0ext_IEs_PDU = -1;  /* SRNC_RelocationInfo_v3h0ext_IEs */
static int hf_rrc_SRNC_RelocationInfo_r6_add_ext_IEs_PDU = -1;  /* SRNC_RelocationInfo_r6_add_ext_IEs */
static int hf_rrc_SRNC_RelocationInfo_r7_add_ext_IEs_PDU = -1;  /* SRNC_RelocationInfo_r7_add_ext_IEs */
static int hf_rrc_MeasurementReport_PDU = -1;     /* MeasurementReport */
static int hf_rrc_integrityCheckInfo = -1;        /* IntegrityCheckInfo */
static int hf_rrc_message = -1;                   /* DL_DCCH_MessageType */
static int hf_rrc_activeSetUpdate = -1;           /* ActiveSetUpdate */
static int hf_rrc_assistanceDataDelivery = -1;    /* AssistanceDataDelivery */
static int hf_rrc_cellChangeOrderFromUTRAN = -1;  /* CellChangeOrderFromUTRAN */
static int hf_rrc_cellUpdateConfirm = -1;         /* CellUpdateConfirm */
static int hf_rrc_counterCheck = -1;              /* CounterCheck */
static int hf_rrc_downlinkDirectTransfer = -1;    /* DownlinkDirectTransfer */
static int hf_rrc_handoverFromUTRANCommand_GSM = -1;  /* HandoverFromUTRANCommand_GSM */
static int hf_rrc_handoverFromUTRANCommand_CDMA2000 = -1;  /* HandoverFromUTRANCommand_CDMA2000 */
static int hf_rrc_measurementControl = -1;        /* MeasurementControl */
static int hf_rrc_pagingType2 = -1;               /* PagingType2 */
static int hf_rrc_physicalChannelReconfiguration = -1;  /* PhysicalChannelReconfiguration */
static int hf_rrc_physicalSharedChannelAllocation = -1;  /* PhysicalSharedChannelAllocation */
static int hf_rrc_radioBearerReconfiguration = -1;  /* RadioBearerReconfiguration */
static int hf_rrc_radioBearerRelease = -1;        /* RadioBearerRelease */
static int hf_rrc_radioBearerSetup = -1;          /* RadioBearerSetup */
static int hf_rrc_rrcConnectionRelease = -1;      /* RRCConnectionRelease */
static int hf_rrc_securityModeCommand = -1;       /* SecurityModeCommand */
static int hf_rrc_signallingConnectionRelease = -1;  /* SignallingConnectionRelease */
static int hf_rrc_transportChannelReconfiguration = -1;  /* TransportChannelReconfiguration */
static int hf_rrc_transportFormatCombinationControl = -1;  /* TransportFormatCombinationControl */
static int hf_rrc_ueCapabilityEnquiry = -1;       /* UECapabilityEnquiry */
static int hf_rrc_ueCapabilityInformationConfirm = -1;  /* UECapabilityInformationConfirm */
static int hf_rrc_uplinkPhysicalChannelControl = -1;  /* UplinkPhysicalChannelControl */
static int hf_rrc_uraUpdateConfirm = -1;          /* URAUpdateConfirm */
static int hf_rrc_utranMobilityInformation = -1;  /* UTRANMobilityInformation */
static int hf_rrc_handoverFromUTRANCommand_GERANIu = -1;  /* HandoverFromUTRANCommand_GERANIu */
static int hf_rrc_mbmsModifiedServicesInformation = -1;  /* MBMSModifiedServicesInformation */
static int hf_rrc_etwsPrimaryNotificationWithSecurity = -1;  /* ETWSPrimaryNotificationWithSecurity */
static int hf_rrc_handoverFromUTRANCommand_EUTRA = -1;  /* HandoverFromUTRANCommand_EUTRA */
static int hf_rrc_ueInformationRequest = -1;      /* UEInformationRequest */
static int hf_rrc_loggingMeasurementConfiguration = -1;  /* LoggingMeasurementConfiguration */
static int hf_rrc_spare1 = -1;                    /* NULL */
static int hf_rrc_message_01 = -1;                /* UL_DCCH_MessageType */
static int hf_rrc_activeSetUpdateComplete = -1;   /* ActiveSetUpdateComplete */
static int hf_rrc_activeSetUpdateFailure = -1;    /* ActiveSetUpdateFailure */
static int hf_rrc_cellChangeOrderFromUTRANFailure = -1;  /* CellChangeOrderFromUTRANFailure */
static int hf_rrc_counterCheckResponse = -1;      /* CounterCheckResponse */
static int hf_rrc_handoverToUTRANComplete = -1;   /* HandoverToUTRANComplete */
static int hf_rrc_initialDirectTransfer = -1;     /* InitialDirectTransfer */
static int hf_rrc_handoverFromUTRANFailure = -1;  /* HandoverFromUTRANFailure */
static int hf_rrc_measurementControlFailure = -1;  /* MeasurementControlFailure */
static int hf_rrc_measurementReport = -1;         /* MeasurementReport */
static int hf_rrc_physicalChannelReconfigurationComplete = -1;  /* PhysicalChannelReconfigurationComplete */
static int hf_rrc_physicalChannelReconfigurationFailure = -1;  /* PhysicalChannelReconfigurationFailure */
static int hf_rrc_radioBearerReconfigurationComplete = -1;  /* RadioBearerReconfigurationComplete */
static int hf_rrc_radioBearerReconfigurationFailure = -1;  /* RadioBearerReconfigurationFailure */
static int hf_rrc_radioBearerReleaseComplete = -1;  /* RadioBearerReleaseComplete */
static int hf_rrc_radioBearerReleaseFailure = -1;  /* RadioBearerReleaseFailure */
static int hf_rrc_radioBearerSetupComplete = -1;  /* RadioBearerSetupComplete */
static int hf_rrc_radioBearerSetupFailure = -1;   /* RadioBearerSetupFailure */
static int hf_rrc_rrcConnectionReleaseComplete = -1;  /* RRCConnectionReleaseComplete */
static int hf_rrc_rrcConnectionSetupComplete = -1;  /* RRCConnectionSetupComplete */
static int hf_rrc_rrcStatus = -1;                 /* RRCStatus */
static int hf_rrc_securityModeComplete = -1;      /* SecurityModeComplete */
static int hf_rrc_securityModeFailure = -1;       /* SecurityModeFailure */
static int hf_rrc_signallingConnectionReleaseIndication = -1;  /* SignallingConnectionReleaseIndication */
static int hf_rrc_transportChannelReconfigurationComplete = -1;  /* TransportChannelReconfigurationComplete */
static int hf_rrc_transportChannelReconfigurationFailure = -1;  /* TransportChannelReconfigurationFailure */
static int hf_rrc_transportFormatCombinationControlFailure = -1;  /* TransportFormatCombinationControlFailure */
static int hf_rrc_ueCapabilityInformation = -1;   /* UECapabilityInformation */
static int hf_rrc_uplinkDirectTransfer = -1;      /* UplinkDirectTransfer */
static int hf_rrc_utranMobilityInformationConfirm = -1;  /* UTRANMobilityInformationConfirm */
static int hf_rrc_utranMobilityInformationFailure = -1;  /* UTRANMobilityInformationFailure */
static int hf_rrc_mbmsModificationRequest = -1;   /* MBMSModificationRequest */
static int hf_rrc_ul_DCCH_MessageType_ext = -1;   /* UL_DCCH_MessageType_ext */
static int hf_rrc_ueInformationResponse = -1;     /* UEInformationResponse */
static int hf_rrc_spare15 = -1;                   /* NULL */
static int hf_rrc_spare14 = -1;                   /* NULL */
static int hf_rrc_spare13 = -1;                   /* NULL */
static int hf_rrc_spare12 = -1;                   /* NULL */
static int hf_rrc_spare11 = -1;                   /* NULL */
static int hf_rrc_spare10 = -1;                   /* NULL */
static int hf_rrc_spare9 = -1;                    /* NULL */
static int hf_rrc_spare8 = -1;                    /* NULL */
static int hf_rrc_spare7 = -1;                    /* NULL */
static int hf_rrc_spare6 = -1;                    /* NULL */
static int hf_rrc_spare5 = -1;                    /* NULL */
static int hf_rrc_spare4 = -1;                    /* NULL */
static int hf_rrc_spare3 = -1;                    /* NULL */
static int hf_rrc_spare2 = -1;                    /* NULL */
static int hf_rrc_message_02 = -1;                /* DL_CCCH_MessageType */
static int hf_rrc_cellUpdateConfirm_01 = -1;      /* CellUpdateConfirm_CCCH */
static int hf_rrc_rrcConnectionReject = -1;       /* RRCConnectionReject */
static int hf_rrc_rrcConnectionRelease_01 = -1;   /* RRCConnectionRelease_CCCH */
static int hf_rrc_rrcConnectionSetup = -1;        /* RRCConnectionSetup */
static int hf_rrc_uraUpdateConfirm_01 = -1;       /* URAUpdateConfirm_CCCH */
static int hf_rrc_dummy = -1;                     /* ETWSPrimaryNotificationWithSecurity */
static int hf_rrc_message_03 = -1;                /* UL_CCCH_MessageType */
static int hf_rrc_cellUpdate = -1;                /* CellUpdate */
static int hf_rrc_rrcConnectionRequest = -1;      /* RRCConnectionRequest */
static int hf_rrc_uraUpdate = -1;                 /* URAUpdate */
static int hf_rrc_uL_CCCH_MessageType_r11 = -1;   /* UL_CCCH_MessageType_r11 */
static int hf_rrc_cellUpdate_01 = -1;             /* CellUpdateFDD_r11 */
static int hf_rrc_message_04 = -1;                /* PCCH_MessageType */
static int hf_rrc_pagingType1 = -1;               /* PagingType1 */
static int hf_rrc_spare = -1;                     /* NULL */
static int hf_rrc_message_05 = -1;                /* DL_SHCCH_MessageType */
static int hf_rrc_message_06 = -1;                /* UL_SHCCH_MessageType */
static int hf_rrc_puschCapacityRequest = -1;      /* PUSCHCapacityRequest */
static int hf_rrc_message_07 = -1;                /* BCCH_FACH_MessageType */
static int hf_rrc_dummy_01 = -1;                  /* SystemInformation_FACH */
static int hf_rrc_systemInformationChangeIndication = -1;  /* SystemInformationChangeIndication */
static int hf_rrc_message_08 = -1;                /* SystemInformation_BCH */
static int hf_rrc_message_09 = -1;                /* MCCH_MessageType */
static int hf_rrc_mbmsAccessInformation = -1;     /* MBMSAccessInformation */
static int hf_rrc_mbmsCommonPTMRBInformation = -1;  /* MBMSCommonPTMRBInformation */
static int hf_rrc_mbmsCurrentCellPTMRBInformation = -1;  /* MBMSCurrentCellPTMRBInformation */
static int hf_rrc_mbmsGeneralInformation = -1;    /* MBMSGeneralInformation */
static int hf_rrc_mbmsNeighbouringCellPTMRBInformation = -1;  /* MBMSNeighbouringCellPTMRBInformation */
static int hf_rrc_mbmsUnmodifiedServicesInformation = -1;  /* MBMSUnmodifiedServicesInformation */
static int hf_rrc_message_10 = -1;                /* MSCH_MessageType */
static int hf_rrc_mbmsSchedulingInformation = -1;  /* MBMSSchedulingInformation */
static int hf_rrc_r3 = -1;                        /* T_r3 */
static int hf_rrc_activeSetUpdate_r3 = -1;        /* ActiveSetUpdate_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions = -1;  /* T_laterNonCriticalExtensions */
static int hf_rrc_activeSetUpdate_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions = -1;  /* T_v4b0NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v4b0ext = -1;   /* ActiveSetUpdate_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions = -1;  /* T_v590NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v590ext = -1;   /* ActiveSetUpdate_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions = -1;  /* T_v690NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v690ext = -1;   /* ActiveSetUpdate_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions = -1;     /* T_nonCriticalExtensions */
static int hf_rrc_later_than_r3 = -1;             /* T_later_than_r3 */
static int hf_rrc_rrc_TransactionIdentifier = -1;  /* RRC_TransactionIdentifier */
static int hf_rrc_criticalExtensions = -1;        /* T_criticalExtensions */
static int hf_rrc_r6 = -1;                        /* T_r6 */
static int hf_rrc_activeSetUpdate_r6 = -1;        /* ActiveSetUpdate_r6_IEs */
static int hf_rrc_activeSetUpdate_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions = -1;  /* T_v6b0NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v6b0ext = -1;   /* ActiveSetUpdate_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_01 = -1;  /* T_nonCriticalExtensions_01 */
static int hf_rrc_criticalExtensions_01 = -1;     /* T_criticalExtensions_01 */
static int hf_rrc_r7 = -1;                        /* T_r7 */
static int hf_rrc_activeSetUpdate_r7 = -1;        /* ActiveSetUpdate_r7_IEs */
static int hf_rrc_activeSetUpdate_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions = -1;  /* T_v780NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v780ext = -1;   /* ActiveSetUpdate_v780ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions = -1;  /* T_v7f0NonCriticalExtensions */
static int hf_rrc_activeSetUdpate_v7f0ext = -1;   /* ActiveSetUpdate_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions = -1;  /* T_v7g0NonCriticalExtensions */
static int hf_rrc_activeSetUdpate_v7g0ext = -1;   /* ActiveSetUpdate_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_02 = -1;  /* T_nonCriticalExtensions_02 */
static int hf_rrc_criticalExtensions_02 = -1;     /* T_criticalExtensions_02 */
static int hf_rrc_r8 = -1;                        /* T_r8 */
static int hf_rrc_activeSetUpdate_r8 = -1;        /* ActiveSetUpdate_r8_IEs */
static int hf_rrc_activeSetUpdate_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v890NonCriticalExtensions = -1;  /* T_v890NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v890ext = -1;   /* ActiveSetUpdate_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_01 = -1;  /* T_v7g0NonCriticalExtensions_01 */
static int hf_rrc_activeSetUpdate_v7g0ext = -1;   /* ActiveSetUpdate_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_03 = -1;  /* T_nonCriticalExtensions_03 */
static int hf_rrc_criticalExtensions_03 = -1;     /* T_criticalExtensions_03 */
static int hf_rrc_r9 = -1;                        /* T_r9 */
static int hf_rrc_activeSetUpdate_r9 = -1;        /* ActiveSetUpdate_r9_IEs */
static int hf_rrc_activeSetUpdate_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions = -1;  /* T_v950NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v950ext = -1;   /* ActiveSetUpdate_v950ext_IEs */
static int hf_rrc_nonCriticalExtensions_04 = -1;  /* T_nonCriticalExtensions_04 */
static int hf_rrc_criticalExtensions_04 = -1;     /* T_criticalExtensions_04 */
static int hf_rrc_r10 = -1;                       /* T_r10 */
static int hf_rrc_activeSetUpdate_r10 = -1;       /* ActiveSetUpdate_r10_IEs */
static int hf_rrc_activeSetUpdate_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_vb50NonCriticalExtensions = -1;  /* T_vb50NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_vb50ext = -1;   /* ActiveSetUpdate_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_05 = -1;  /* T_nonCriticalExtensions_05 */
static int hf_rrc_criticalExtensions_05 = -1;     /* T_criticalExtensions_05 */
static int hf_rrc_r11 = -1;                       /* T_r11 */
static int hf_rrc_activeSetUpdate_r11 = -1;       /* ActiveSetUpdate_r11_IEs */
static int hf_rrc_activeSetUpdate_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_06 = -1;  /* T_nonCriticalExtensions_06 */
static int hf_rrc_criticalExtensions_06 = -1;     /* T_criticalExtensions_06 */
static int hf_rrc_dummy_02 = -1;                  /* IntegrityProtectionModeInfo */
static int hf_rrc_dummy2 = -1;                    /* CipheringModeInfo */
static int hf_rrc_activationTime = -1;            /* ActivationTime */
static int hf_rrc_newU_RNTI = -1;                 /* U_RNTI */
static int hf_rrc_cn_InformationInfo = -1;        /* CN_InformationInfo */
static int hf_rrc_dummy3 = -1;                    /* DL_CounterSynchronisationInfo */
static int hf_rrc_maxAllowedUL_TX_Power = -1;     /* MaxAllowedUL_TX_Power */
static int hf_rrc_rl_AdditionInformationList = -1;  /* RL_AdditionInformationList */
static int hf_rrc_rl_RemovalInformationList = -1;  /* RL_RemovalInformationList */
static int hf_rrc_tx_DiversityMode = -1;          /* TX_DiversityMode */
static int hf_rrc_dummy4 = -1;                    /* SSDT_Information */
static int hf_rrc_dummy_03 = -1;                  /* SSDT_UL */
static int hf_rrc_cell_id_PerRL_List = -1;        /* CellIdentity_PerRL_List */
static int hf_rrc_dpc_Mode = -1;                  /* DPC_Mode */
static int hf_rrc_dl_TPC_PowerOffsetPerRL_List = -1;  /* DL_TPC_PowerOffsetPerRL_List */
static int hf_rrc_primary_plmn_Identity = -1;     /* PLMN_Identity */
static int hf_rrc_newH_RNTI = -1;                 /* H_RNTI */
static int hf_rrc_newPrimary_E_RNTI = -1;         /* E_RNTI */
static int hf_rrc_newSecondary_E_RNTI = -1;       /* E_RNTI */
static int hf_rrc_cn_InformationInfo_01 = -1;     /* CN_InformationInfo_r6 */
static int hf_rrc_rl_AdditionInformationList_01 = -1;  /* RL_AdditionInformationList_r6 */
static int hf_rrc_serving_HSDSCH_CellInformation = -1;  /* Serving_HSDSCH_CellInformation */
static int hf_rrc_e_dch_ReconfigurationInfo = -1;  /* E_DCH_ReconfigurationInfo */
static int hf_rrc_rl_AdditionInformation_list_v6b0ext = -1;  /* RL_AdditionInformation_list_v6b0ext */
static int hf_rrc_dtx_drx_TimingInfo = -1;        /* DTX_DRX_TimingInfo_r7 */
static int hf_rrc_dtx_drx_Info = -1;              /* DTX_DRX_Info_r7 */
static int hf_rrc_hs_scch_LessInfo = -1;          /* HS_SCCH_LessInfo_r7 */
static int hf_rrc_mimoParameters = -1;            /* MIMO_Parameters_r7 */
static int hf_rrc_rl_AdditionInformationList_02 = -1;  /* RL_AdditionInformationList_r7 */
static int hf_rrc_serving_HSDSCH_CellInformation_01 = -1;  /* Serving_HSDSCH_CellInformation_r7 */
static int hf_rrc_e_dch_ReconfigurationInfo_01 = -1;  /* E_DCH_ReconfigurationInfo_r7 */
static int hf_rrc_ul_16QAM_Config = -1;           /* UL_16QAM_Config */
static int hf_rrc_e_dch_ReconfInfoSameCell = -1;  /* E_DCH_RL_InfoSameServingCell */
static int hf_rrc_e_TFC_Boost_Info = -1;          /* E_TFC_Boost_Info_r7 */
static int hf_rrc_e_DPDCH_PowerInterpolation = -1;  /* E_DPDCH_PowerInterpolation */
static int hf_rrc_hs_DSCH_TBSizeTable = -1;       /* HS_DSCH_TBSizeTable */
static int hf_rrc_mimoParameters_01 = -1;         /* MIMO_Parameters_v7f0ext */
static int hf_rrc_mimoParameters_02 = -1;         /* MIMO_Parameters_v7g0ext */
static int hf_rrc_mimoParameters_03 = -1;         /* MIMO_Parameters_r8 */
static int hf_rrc_rl_AdditionInformationList_03 = -1;  /* RL_AdditionInformationList_r8 */
static int hf_rrc_servingCellChangeParameters = -1;  /* ServingCellChangeParameters */
static int hf_rrc_serving_HSDSCH_CellInformation_02 = -1;  /* Serving_HSDSCH_CellInformation_r8 */
static int hf_rrc_dl_SecondaryCellInfoFDD = -1;   /* DL_SecondaryCellInfoFDD */
static int hf_rrc_dl_SecondaryCellInfoFDD_v890ext = -1;  /* DL_SecondaryCellInfoFDD_v890ext */
static int hf_rrc_rl_AdditionInformationList_04 = -1;  /* RL_AdditionInformationList_v890ext */
static int hf_rrc_mimoParameters_04 = -1;         /* MIMO_Parameters_r9 */
static int hf_rrc_ul_SecondaryCellInfoFDD = -1;   /* UL_SecondaryCellInfoFDD */
static int hf_rrc_e_dch_ReconfigurationInfo_SecULFrequency = -1;  /* E_DCH_ReconfigurationInfo_SecULFrequency */
static int hf_rrc_rl_AdditionInformationList_05 = -1;  /* RL_AdditionInformationList_r9 */
static int hf_rrc_rl_AdditionInformationList_SecULFreq = -1;  /* RL_AdditionInformationList_SecULFreq */
static int hf_rrc_rl_RemovalInformationList_SecULFreq = -1;  /* RL_RemovalInformationList_SecULFreq */
static int hf_rrc_serving_HSDSCH_CellInformation_03 = -1;  /* Serving_HSDSCH_CellInformation_r9 */
static int hf_rrc_dl_SecondaryCellInfoFDD_01 = -1;  /* DL_SecondaryCellInfoFDD_r9 */
static int hf_rrc_secondaryCellMimoParameters = -1;  /* SecondaryCellMIMOparametersFDD_v950ext */
static int hf_rrc_rl_AdditionInformationList_06 = -1;  /* RL_AdditionInformationList_v950ext */
static int hf_rrc_rl_AdditionInformationList_07 = -1;  /* RL_AdditionInformationList_r10 */
static int hf_rrc_dl_SecondaryCellInfoFDD_02 = -1;  /* DL_SecondaryCellInfoFDD_r10 */
static int hf_rrc_additionalDLSecCellInfoListFDD = -1;  /* AdditionalDLSecCellInfoListFDD */
static int hf_rrc_ulOLTDInfoFDD = -1;             /* UL_OLTD_InfoFDD */
static int hf_rrc_rl_AdditionInformationList_08 = -1;  /* RL_AdditionInformationList_vb50ext */
static int hf_rrc_mimo4x4Parameters = -1;         /* MIMO4x4_Parameters */
static int hf_rrc_ul_CLTD_InfoFDD = -1;           /* UL_CLTD_InfoFDD */
static int hf_rrc_f_tpich_ReconfigurationInfo = -1;  /* F_TPICH_ReconfigurationInfo */
static int hf_rrc_ul_OLTD_InfoFDD = -1;           /* UL_OLTD_InfoFDD */
static int hf_rrc_rl_AdditionInformationList_09 = -1;  /* RL_AdditionInformationList_r11 */
static int hf_rrc_serving_HSDSCH_CellInformation_04 = -1;  /* Serving_HSDSCH_CellInformation_r11 */
static int hf_rrc_e_dch_ReconfigurationInfo_02 = -1;  /* E_DCH_ReconfigurationInfo_r11 */
static int hf_rrc_ul_64QAM_Config = -1;           /* UL_64QAM_Config */
static int hf_rrc_ul_MIMO_InfoFDD = -1;           /* UL_MIMO_InfoFDD */
static int hf_rrc_dl_SecondaryCellInfoFDD_03 = -1;  /* DL_SecondaryCellInfoFDD_r11 */
static int hf_rrc_additionalDLSecCellInfoListFDD_01 = -1;  /* AdditionalDLSecCellInfoListFDD_r11 */
static int hf_rrc_additionalDLSecCellInfoListFDD2 = -1;  /* AdditionalDLSecCellInfoListFDD2 */
static int hf_rrc_dummy_04 = -1;                  /* IntegrityProtActivationInfo */
static int hf_rrc_dummy2_01 = -1;                 /* RB_ActivationTimeInfoList */
static int hf_rrc_dummy3_01 = -1;                 /* UL_CounterSynchronisationInfo */
static int hf_rrc_laterNonCriticalExtensions_01 = -1;  /* T_laterNonCriticalExtensions_01 */
static int hf_rrc_activeSetUpdateComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_07 = -1;  /* T_nonCriticalExtensions_07 */
static int hf_rrc_failureCause = -1;              /* FailureCauseWithProtErr */
static int hf_rrc_laterNonCriticalExtensions_02 = -1;  /* T_laterNonCriticalExtensions_02 */
static int hf_rrc_activeSetUpdateFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_08 = -1;  /* T_nonCriticalExtensions_08 */
static int hf_rrc_r3_01 = -1;                     /* T_r3_01 */
static int hf_rrc_assistanceDataDelivery_r3 = -1;  /* AssistanceDataDelivery_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions = -1;  /* T_v3a0NonCriticalExtensions */
static int hf_rrc_assistanceDataDelivery_v3a0ext = -1;  /* AssistanceDataDelivery_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_03 = -1;  /* T_laterNonCriticalExtensions_03 */
static int hf_rrc_assistanceDataDelivery_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_01 = -1;  /* T_v4b0NonCriticalExtensions_01 */
static int hf_rrc_assistanceDataDelivery_v4b0ext = -1;  /* AssistanceDataDelivery_v4b0ext_IEs */
static int hf_rrc_v770NonCriticalExtension = -1;  /* T_v770NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_v770ext = -1;  /* AssistanceDataDelivery_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtension = -1;  /* T_v860NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_v860ext = -1;  /* AssistanceDataDelivery_v860ext_IEs */
static int hf_rrc_v920NonCriticalExtension = -1;  /* T_v920NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_v920ext = -1;  /* AssistanceDataDelivery_v920ext_IEs */
static int hf_rrc_va40NonCriticalExtension = -1;  /* T_va40NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_va40ext = -1;  /* AssistanceDataDelivery_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_09 = -1;  /* T_nonCriticalExtensions_09 */
static int hf_rrc_later_than_r3_01 = -1;          /* T_later_than_r3_01 */
static int hf_rrc_criticalExtensions_07 = -1;     /* T_criticalExtensions_07 */
static int hf_rrc_ue_positioning_GPS_AssistanceData = -1;  /* UE_Positioning_GPS_AssistanceData */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData_UEB = -1;  /* UE_Positioning_OTDOA_AssistanceData_UEB */
static int hf_rrc_sfn_Offset_Validity = -1;       /* SFN_Offset_Validity */
static int hf_rrc_ue_Positioning_OTDOA_AssistanceData_r4ext = -1;  /* UE_Positioning_OTDOA_AssistanceData_r4ext */
static int hf_rrc_ue_Positioning_OTDOA_AssistanceData_UEB_ext = -1;  /* UE_Positioning_OTDOA_AssistanceData_UEB_ext */
static int hf_rrc_ue_Positioning_GPS_AssistanceData = -1;  /* UE_Positioning_GPS_AssistanceData_v770ext */
static int hf_rrc_ue_positioning_GANSS_AssistanceData = -1;  /* UE_Positioning_GANSS_AssistanceData */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_v860ext = -1;  /* UE_Positioning_GANSS_AssistanceData_v860ext */
static int hf_rrc_ue_positioning_GPS_AssistanceData_v920ext = -1;  /* UE_Positioning_GPS_AssistanceData_v920ext */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_v920ext = -1;  /* UE_Positioning_GANSS_AssistanceData_v920ext */
static int hf_rrc_ue_positioning_GPS_AssistanceData_va40ext = -1;  /* UE_Positioning_GPS_AssistanceData_va40ext */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_va40ext = -1;  /* UE_Positioning_GANSS_AssistanceData_va40ext */
static int hf_rrc_r3_02 = -1;                     /* T_r3_02 */
static int hf_rrc_cellChangeOrderFromUTRAN_IEs = -1;  /* CellChangeOrderFromUTRAN_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_04 = -1;  /* T_laterNonCriticalExtensions_04 */
static int hf_rrc_cellChangeOrderFromUTRAN_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_01 = -1;  /* T_v590NonCriticalExtensions_01 */
static int hf_rrc_cellChangeOrderFromUTRAN_v590ext = -1;  /* CellChangeOrderFromUTRAN_v590ext_IEs */
static int hf_rrc_nonCriticalExtensions_10 = -1;  /* T_nonCriticalExtensions_10 */
static int hf_rrc_later_than_r3_02 = -1;          /* T_later_than_r3_02 */
static int hf_rrc_criticalExtensions_08 = -1;     /* T_criticalExtensions_08 */
static int hf_rrc_rab_InformationList = -1;       /* RAB_InformationList */
static int hf_rrc_interRAT_TargetCellDescription = -1;  /* InterRAT_TargetCellDescription */
static int hf_rrc_geran_SystemInfoType = -1;      /* T_geran_SystemInfoType */
static int hf_rrc_sI = -1;                        /* GERAN_SystemInformation */
static int hf_rrc_pSI = -1;                       /* GERAN_SystemInformation */
static int hf_rrc_r3_03 = -1;                     /* T_r3_03 */
static int hf_rrc_cellChangeOrderFromUTRANFailure_r3 = -1;  /* CellChangeOrderFromUTRANFailure_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_05 = -1;  /* T_laterNonCriticalExtensions_05 */
static int hf_rrc_cellChangeOrderFromUTRANFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_11 = -1;  /* T_nonCriticalExtensions_11 */
static int hf_rrc_dummy_05 = -1;                  /* T_dummy */
static int hf_rrc_criticalExtensions_09 = -1;     /* T_criticalExtensions_09 */
static int hf_rrc_interRAT_ChangeFailureCause = -1;  /* InterRAT_ChangeFailureCause */
static int hf_rrc_u_RNTI = -1;                    /* U_RNTI */
static int hf_rrc_startList = -1;                 /* STARTList */
static int hf_rrc_am_RLC_ErrorIndicationRb2_3or4 = -1;  /* BOOLEAN */
static int hf_rrc_am_RLC_ErrorIndicationRb5orAbove = -1;  /* BOOLEAN */
static int hf_rrc_cellUpdateCause = -1;           /* CellUpdateCause */
static int hf_rrc_failureCause_01 = -1;           /* FailureCauseWithProtErrTrId */
static int hf_rrc_rb_timer_indicator = -1;        /* Rb_timer_indicator */
static int hf_rrc_measuredResultsOnRACH = -1;     /* MeasuredResultsOnRACH */
static int hf_rrc_laterNonCriticalExtensions_06 = -1;  /* T_laterNonCriticalExtensions_06 */
static int hf_rrc_cellUpdate_r3_add_ext = -1;     /* T_cellUpdate_r3_add_ext */
static int hf_rrc_v590NonCriticalExtensions_02 = -1;  /* T_v590NonCriticalExtensions_02 */
static int hf_rrc_cellUpdate_v590ext = -1;        /* CellUpdate_v590ext */
static int hf_rrc_v690NonCriticalExtensions_01 = -1;  /* T_v690NonCriticalExtensions_01 */
static int hf_rrc_cellUpdate_v690ext = -1;        /* CellUpdate_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_01 = -1;  /* T_v6b0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdate_v6b0ext = -1;        /* CellUpdate_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions = -1;  /* T_v770NonCriticalExtensions */
static int hf_rrc_cellUpdate_v770ext = -1;        /* CellUpdate_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions = -1;  /* T_v860NonCriticalExtensions */
static int hf_rrc_cellUpdate_v860ext = -1;        /* CellUpdate_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions = -1;  /* T_va40NonCriticalExtensions */
static int hf_rrc_cellUpdate_va40ext = -1;        /* CellUpdate_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_01 = -1;  /* T_vb50NonCriticalExtensions_01 */
static int hf_rrc_cellUpdate_vb50ext = -1;        /* CellUpdate_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_12 = -1;  /* T_nonCriticalExtensions_12 */
static int hf_rrc_cellUpdate_v7e0ext = -1;        /* CellUpdate_v7e0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_02 = -1;  /* T_v7g0NonCriticalExtensions_02 */
static int hf_rrc_cellUpdate_v7g0ext = -1;        /* CellUpdate_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_13 = -1;  /* T_nonCriticalExtensions_13 */
static int hf_rrc_establishmentCause = -1;        /* EstablishmentCause */
static int hf_rrc_cellUpdateCause_ext = -1;       /* CellUpdateCause_ext */
static int hf_rrc_trafficVolumeIndicator = -1;    /* T_trafficVolumeIndicator */
static int hf_rrc_measuredResultsOnRACHinterFreq = -1;  /* MeasuredResultsOnRACHinterFreq */
static int hf_rrc_reconfigurationStatusIndicator = -1;  /* T_reconfigurationStatusIndicator */
static int hf_rrc_mbmsSelectedServices = -1;      /* MBMS_SelectedServicesShort */
static int hf_rrc_csCallType = -1;                /* T_csCallType */
static int hf_rrc_hspdschReception_CellFach = -1;  /* T_hspdschReception_CellFach */
static int hf_rrc_ueMobilityStateIndicator = -1;  /* High_MobilityDetected */
static int hf_rrc_capabilityChangeIndicator = -1;  /* T_capabilityChangeIndicator */
static int hf_rrc_supportForTwoDRXSchemesInPCH = -1;  /* T_supportForTwoDRXSchemesInPCH */
static int hf_rrc_measuredResultsOnRACH_v7g0ext = -1;  /* MeasuredResultsOnRACH_v7g0ext */
static int hf_rrc_supportOfCommonEDCH = -1;       /* T_supportOfCommonEDCH */
static int hf_rrc_supportOfHS_DSCHDRXOperation = -1;  /* T_supportOfHS_DSCHDRXOperation */
static int hf_rrc_supportOfMACiis = -1;           /* T_supportOfMACiis */
static int hf_rrc_supportOfSPSOperation = -1;     /* T_supportOfSPSOperation */
static int hf_rrc_supportOfControlChannelDRXOperation = -1;  /* T_supportOfControlChannelDRXOperation */
static int hf_rrc_securityRevertStatusIndicator = -1;  /* T_securityRevertStatusIndicator */
static int hf_rrc_loggedMeasAvailable = -1;       /* T_loggedMeasAvailable */
static int hf_rrc_loggedANRResultsAvailable = -1;  /* T_loggedANRResultsAvailable */
static int hf_rrc_trafficVolumeIndicator_01 = -1;  /* T_trafficVolumeIndicator_01 */
static int hf_rrc_reconfigurationStatusIndicator_01 = -1;  /* T_reconfigurationStatusIndicator_01 */
static int hf_rrc_csCallType_01 = -1;             /* T_csCallType_01 */
static int hf_rrc_hspdschReception_CellFach_01 = -1;  /* T_hspdschReception_CellFach_01 */
static int hf_rrc_capabilityChangeIndicator_01 = -1;  /* T_capabilityChangeIndicator_01 */
static int hf_rrc_supportOfCommonEDCH_01 = -1;    /* T_supportOfCommonEDCH_01 */
static int hf_rrc_supportOfHS_DSCHDRXOperation_01 = -1;  /* T_supportOfHS_DSCHDRXOperation_01 */
static int hf_rrc_supportOfMACiis_01 = -1;        /* T_supportOfMACiis_01 */
static int hf_rrc_securityRevertStatusIndicator_01 = -1;  /* T_securityRevertStatusIndicator_01 */
static int hf_rrc_spare4_01 = -1;                 /* T_spare4 */
static int hf_rrc_spare3_01 = -1;                 /* T_spare3 */
static int hf_rrc_spare2_01 = -1;                 /* T_spare2 */
static int hf_rrc_spare1_01 = -1;                 /* T_spare1 */
static int hf_rrc_measuredResultsOnRACH_01 = -1;  /* MeasuredResultsOnRACHFDD_r11 */
static int hf_rrc_loggedMeasAvailable_01 = -1;    /* T_loggedMeasAvailable_01 */
static int hf_rrc_loggedANRResultsAvailable_01 = -1;  /* T_loggedANRResultsAvailable_01 */
static int hf_rrc_measuredResultsOnRACHEUTRAFreq = -1;  /* MeasuredResultsOnRACH_EUTRAFreq */
static int hf_rrc_r3_04 = -1;                     /* T_r3_04 */
static int hf_rrc_cellUpdateConfirm_r3 = -1;      /* CellUpdateConfirm_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_01 = -1;  /* T_v3a0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v3a0ext = -1;  /* CellUpdateConfirm_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_07 = -1;  /* T_laterNonCriticalExtensions_07 */
static int hf_rrc_cellUpdateConfirm_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_02 = -1;  /* T_v4b0NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_v4b0ext = -1;  /* CellUpdateConfirm_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtenstions = -1;  /* T_v590NonCriticalExtenstions */
static int hf_rrc_cellUpdateConfirm_v590ext = -1;  /* CellUpdateConfirm_v590ext_IEs */
static int hf_rrc_v5d0NonCriticalExtenstions = -1;  /* T_v5d0NonCriticalExtenstions */
static int hf_rrc_cellUpdateConfirm_v5d0ext = -1;  /* CellUpdateConfirm_v5d0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_02 = -1;  /* T_v690NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_v690ext = -1;  /* CellUpdateConfirm_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_14 = -1;  /* T_nonCriticalExtensions_14 */
static int hf_rrc_later_than_r3_03 = -1;          /* T_later_than_r3_03 */
static int hf_rrc_criticalExtensions_10 = -1;     /* T_criticalExtensions_10 */
static int hf_rrc_r4 = -1;                        /* T_r4 */
static int hf_rrc_cellUpdateConfirm_r4 = -1;      /* CellUpdateConfirm_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions = -1;  /* T_v4d0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtenstions_01 = -1;  /* T_v590NonCriticalExtenstions_01 */
static int hf_rrc_v5d0NonCriticalExtenstions_01 = -1;  /* T_v5d0NonCriticalExtenstions_01 */
static int hf_rrc_v690NonCriticalExtensions_03 = -1;  /* T_v690NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_15 = -1;  /* T_nonCriticalExtensions_15 */
static int hf_rrc_criticalExtensions_11 = -1;     /* T_criticalExtensions_11 */
static int hf_rrc_r5 = -1;                        /* T_r5 */
static int hf_rrc_cellUpdateConfirm_r5 = -1;      /* CellUpdateConfirm_r5_IEs */
static int hf_rrc_cellUpdateConfirm_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_02 = -1;  /* T_v5d0NonCriticalExtenstions_02 */
static int hf_rrc_v690NonCriticalExtensions_04 = -1;  /* T_v690NonCriticalExtensions_04 */
static int hf_rrc_nonCriticalExtensions_16 = -1;  /* T_nonCriticalExtensions_16 */
static int hf_rrc_criticalExtensions_12 = -1;     /* T_criticalExtensions_12 */
static int hf_rrc_r6_01 = -1;                     /* T_r6_01 */
static int hf_rrc_cellUpdateConfirm_r6 = -1;      /* CellUpdateConfirm_r6_IEs */
static int hf_rrc_cellUpdateConfirm_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_02 = -1;  /* T_v6b0NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_v6b0ext = -1;  /* CellUpdateConfirm_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_17 = -1;  /* T_nonCriticalExtensions_17 */
static int hf_rrc_criticalExtensions_13 = -1;     /* T_criticalExtensions_13 */
static int hf_rrc_r7_01 = -1;                     /* T_r7_01 */
static int hf_rrc_cellUpdateConfirm_r7 = -1;      /* CellUpdateConfirm_r7_IEs */
static int hf_rrc_cellUpdateConfirm_r7_add_ext = -1;  /* T_cellUpdateConfirm_r7_add_ext */
static int hf_rrc_v780NonCriticalExtensions_01 = -1;  /* T_v780NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v780ext = -1;  /* CellUpdateConfirm_v780ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_01 = -1;  /* T_v860NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v860ext = -1;  /* CellUpdateConfirm_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_18 = -1;  /* T_nonCriticalExtensions_18 */
static int hf_rrc_criticalExtensions_14 = -1;     /* T_criticalExtensions_14 */
static int hf_rrc_r8_01 = -1;                     /* T_r8_01 */
static int hf_rrc_cellUpdateConfirm_r8 = -1;      /* CellUpdateConfirm_r8_IEs */
static int hf_rrc_cellUpdateConfirm_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions = -1;  /* T_v7d0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_v7d0ext = -1;  /* CellUpdateConfirm_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_01 = -1;  /* T_v7f0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v7f0ext = -1;  /* CellUpdateConfirm_v7f0ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_01 = -1;  /* T_v890NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v890ext = -1;  /* CellUpdateConfirm_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_03 = -1;  /* T_v7g0NonCriticalExtensions_03 */
static int hf_rrc_cellUpdateConfirm_v7g0ext = -1;  /* CellUpdateConfirm_v7g0ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions = -1;  /* T_v8a0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_v8a0ext = -1;  /* CellUpdateConfirm_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_19 = -1;  /* T_nonCriticalExtensions_19 */
static int hf_rrc_criticalExtensions_15 = -1;     /* T_criticalExtensions_15 */
static int hf_rrc_r9_01 = -1;                     /* T_r9_01 */
static int hf_rrc_cellUpdateConfirm_r9 = -1;      /* CellUpdateConfirm_r9_IEs */
static int hf_rrc_cellUpdateConfirm_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_01 = -1;  /* T_v950NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v950ext = -1;  /* CellUpdateConfirm_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions = -1;  /* T_v9c0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_v9c0ext = -1;  /* CellUpdateConfirm_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_20 = -1;  /* T_nonCriticalExtensions_20 */
static int hf_rrc_criticalExtensions_16 = -1;     /* T_criticalExtensions_16 */
static int hf_rrc_r10_01 = -1;                    /* T_r10_01 */
static int hf_rrc_cellUpdateConfirm_r10 = -1;     /* CellUpdateConfirm_r10_IEs */
static int hf_rrc_cellUpdateConfirm_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_01 = -1;  /* T_v9c0NonCriticalExtensions_01 */
static int hf_rrc_vb50NonCriticalExtensions_02 = -1;  /* T_vb50NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_vb50ext = -1;  /* CellUpdateConfirm_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_21 = -1;  /* T_nonCriticalExtensions_21 */
static int hf_rrc_criticalExtensions_17 = -1;     /* T_criticalExtensions_17 */
static int hf_rrc_r11_01 = -1;                    /* T_r11_01 */
static int hf_rrc_cellUpdateConfirm_r11 = -1;     /* CellUpdateConfirm_r11_IEs */
static int hf_rrc_cellUpdateConfirm_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_22 = -1;  /* T_nonCriticalExtensions_22 */
static int hf_rrc_criticalExtensions_18 = -1;     /* T_criticalExtensions_18 */
static int hf_rrc_integrityProtectionModeInfo = -1;  /* IntegrityProtectionModeInfo */
static int hf_rrc_cipheringModeInfo = -1;         /* CipheringModeInfo */
static int hf_rrc_new_U_RNTI = -1;                /* U_RNTI */
static int hf_rrc_new_C_RNTI = -1;                /* C_RNTI */
static int hf_rrc_rrc_StateIndicator = -1;        /* RRC_StateIndicator */
static int hf_rrc_utran_DRX_CycleLengthCoeff = -1;  /* UTRAN_DRX_CycleLengthCoefficient */
static int hf_rrc_rlc_Re_establishIndicatorRb2_3or4 = -1;  /* BOOLEAN */
static int hf_rrc_rlc_Re_establishIndicatorRb5orAbove = -1;  /* BOOLEAN */
static int hf_rrc_ura_Identity = -1;              /* URA_Identity */
static int hf_rrc_rb_InformationReleaseList = -1;  /* RB_InformationReleaseList */
static int hf_rrc_rb_InformationReconfigList = -1;  /* RB_InformationReconfigList */
static int hf_rrc_rb_InformationAffectedList = -1;  /* RB_InformationAffectedList */
static int hf_rrc_dl_CounterSynchronisationInfo = -1;  /* DL_CounterSynchronisationInfo */
static int hf_rrc_ul_CommonTransChInfo = -1;      /* UL_CommonTransChInfo */
static int hf_rrc_ul_deletedTransChInfoList = -1;  /* UL_DeletedTransChInfoList */
static int hf_rrc_ul_AddReconfTransChInfoList = -1;  /* UL_AddReconfTransChInfoList */
static int hf_rrc_modeSpecificTransChInfo = -1;   /* T_modeSpecificTransChInfo */
static int hf_rrc_fdd = -1;                       /* T_fdd */
static int hf_rrc_dummy_06 = -1;                  /* CPCH_SetID */
static int hf_rrc_dummy2_02 = -1;                 /* DRAC_StaticInformationList */
static int hf_rrc_tdd = -1;                       /* NULL */
static int hf_rrc_dl_CommonTransChInfo = -1;      /* DL_CommonTransChInfo */
static int hf_rrc_dl_DeletedTransChInfoList = -1;  /* DL_DeletedTransChInfoList */
static int hf_rrc_dl_AddReconfTransChInfoList = -1;  /* DL_AddReconfTransChInfoList */
static int hf_rrc_frequencyInfo = -1;             /* FrequencyInfo */
static int hf_rrc_ul_ChannelRequirement = -1;     /* UL_ChannelRequirement */
static int hf_rrc_modeSpecificPhysChInfo = -1;    /* T_modeSpecificPhysChInfo */
static int hf_rrc_fdd_01 = -1;                    /* T_fdd_01 */
static int hf_rrc_dummy_07 = -1;                  /* DL_PDSCH_Information */
static int hf_rrc_dl_CommonInformation = -1;      /* DL_CommonInformation */
static int hf_rrc_dl_InformationPerRL_List = -1;  /* DL_InformationPerRL_List */
static int hf_rrc_new_DSCH_RNTI = -1;             /* DSCH_RNTI */
static int hf_rrc_pdcp_ROHC_TargetMode = -1;      /* PDCP_ROHC_TargetMode */
static int hf_rrc_rb_InformationReconfigList_01 = -1;  /* RB_InformationReconfigList_r4 */
static int hf_rrc_ul_CommonTransChInfo_01 = -1;   /* UL_CommonTransChInfo_r4 */
static int hf_rrc_modeSpecificTransChInfo_01 = -1;  /* T_modeSpecificTransChInfo_01 */
static int hf_rrc_fdd_02 = -1;                    /* T_fdd_02 */
static int hf_rrc_dl_CommonTransChInfo_01 = -1;   /* DL_CommonTransChInfo_r4 */
static int hf_rrc_dl_AddReconfTransChInfoList_01 = -1;  /* DL_AddReconfTransChInfoList_r4 */
static int hf_rrc_ul_ChannelRequirement_01 = -1;  /* UL_ChannelRequirement_r4 */
static int hf_rrc_modeSpecificPhysChInfo_01 = -1;  /* T_modeSpecificPhysChInfo_01 */
static int hf_rrc_fdd_03 = -1;                    /* T_fdd_03 */
static int hf_rrc_dl_CommonInformation_01 = -1;   /* DL_CommonInformation_r4 */
static int hf_rrc_dl_InformationPerRL_List_01 = -1;  /* DL_InformationPerRL_List_r4 */
static int hf_rrc_new_H_RNTI = -1;                /* H_RNTI */
static int hf_rrc_rb_InformationReconfigList_02 = -1;  /* RB_InformationReconfigList_r5 */
static int hf_rrc_rb_InformationAffectedList_01 = -1;  /* RB_InformationAffectedList_r5 */
static int hf_rrc_dl_CounterSynchronisationInfo_01 = -1;  /* DL_CounterSynchronisationInfo_r5 */
static int hf_rrc_modeSpecificTransChInfo_02 = -1;  /* T_modeSpecificTransChInfo_02 */
static int hf_rrc_fdd_04 = -1;                    /* T_fdd_04 */
static int hf_rrc_dl_DeletedTransChInfoList_01 = -1;  /* DL_DeletedTransChInfoList_r5 */
static int hf_rrc_dl_AddReconfTransChInfoList_02 = -1;  /* DL_AddReconfTransChInfoList_r5 */
static int hf_rrc_ul_ChannelRequirement_02 = -1;  /* UL_ChannelRequirement_r5 */
static int hf_rrc_modeSpecificPhysChInfo_02 = -1;  /* T_modeSpecificPhysChInfo_02 */
static int hf_rrc_fdd_05 = -1;                    /* T_fdd_05 */
static int hf_rrc_dl_HSPDSCH_Information = -1;    /* DL_HSPDSCH_Information */
static int hf_rrc_dl_CommonInformation_02 = -1;   /* DL_CommonInformation_r5 */
static int hf_rrc_dl_InformationPerRL_List_02 = -1;  /* DL_InformationPerRL_List_r5 */
static int hf_rrc_rb_InformationReconfigList_03 = -1;  /* RB_InformationReconfigList_r6 */
static int hf_rrc_rb_InformationAffectedList_02 = -1;  /* RB_InformationAffectedList_r6 */
static int hf_rrc_ul_deletedTransChInfoList_01 = -1;  /* UL_DeletedTransChInfoList_r6 */
static int hf_rrc_ul_AddReconfTransChInfoList_01 = -1;  /* UL_AddReconfTransChInfoList_r6 */
static int hf_rrc_ul_DPCH_Info = -1;              /* UL_DPCH_Info_r6 */
static int hf_rrc_ul_EDCH_Information = -1;       /* UL_EDCH_Information_r6 */
static int hf_rrc_dl_HSPDSCH_Information_01 = -1;  /* DL_HSPDSCH_Information_r6 */
static int hf_rrc_dl_CommonInformation_03 = -1;   /* DL_CommonInformation_r6 */
static int hf_rrc_dl_InformationPerRL_List_03 = -1;  /* DL_InformationPerRL_List_r6 */
static int hf_rrc_mbms_PL_ServiceRestrictInfo = -1;  /* MBMS_PL_ServiceRestrictInfo_r6 */
static int hf_rrc_harq_Preamble_Mode = -1;        /* HARQ_Preamble_Mode */
static int hf_rrc_beaconPLEst = -1;               /* BEACON_PL_Est */
static int hf_rrc_postVerificationPeriod = -1;    /* T_postVerificationPeriod */
static int hf_rrc_dhs_sync = -1;                  /* DHS_Sync */
static int hf_rrc_dl_InformationPerRL_List_v6b0ext = -1;  /* DL_InformationPerRL_List_v6b0ext */
static int hf_rrc_integrityProtectionModeInfo_01 = -1;  /* IntegrityProtectionModeInfo_r7 */
static int hf_rrc_cipheringModeInfo_01 = -1;      /* CipheringModeInfo_r7 */
static int hf_rrc_utran_DRX_CycleLengthCoeff_01 = -1;  /* UTRAN_DRX_CycleLengthCoefficient_r7 */
static int hf_rrc_waitTime = -1;                  /* WaitTime */
static int hf_rrc_supportForChangeOfUE_Capability = -1;  /* BOOLEAN */
static int hf_rrc_rb_InformationReconfigList_04 = -1;  /* RB_InformationReconfigList_r7 */
static int hf_rrc_rb_InformationAffectedList_03 = -1;  /* RB_InformationAffectedList_r7 */
static int hf_rrc_ul_AddReconfTransChInfoList_02 = -1;  /* UL_AddReconfTransChInfoList_r7 */
static int hf_rrc_dl_DeletedTransChInfoList_02 = -1;  /* DL_DeletedTransChInfoList_r7 */
static int hf_rrc_dl_AddReconfTransChInfoList_03 = -1;  /* DL_AddReconfTransChInfoList_r7 */
static int hf_rrc_multi_frequencyInfo = -1;       /* Multi_frequencyInfo_LCR_r7 */
static int hf_rrc_ul_DPCH_Info_01 = -1;           /* UL_DPCH_Info_r7 */
static int hf_rrc_ul_EDCH_Information_01 = -1;    /* UL_EDCH_Information_r7 */
static int hf_rrc_dl_HSPDSCH_Information_02 = -1;  /* DL_HSPDSCH_Information_r7 */
static int hf_rrc_dl_CommonInformation_04 = -1;   /* DL_CommonInformation_r7 */
static int hf_rrc_dl_InformationPerRL_List_04 = -1;  /* DL_InformationPerRL_List_r7 */
static int hf_rrc_v7f0NonCriticalExtensions_02 = -1;  /* T_v7f0NonCriticalExtensions_02 */
static int hf_rrc_v7g0NonCriticalExtensions_04 = -1;  /* T_v7g0NonCriticalExtensions_04 */
static int hf_rrc_nonCriticalExtensions_23 = -1;  /* T_nonCriticalExtensions_23 */
static int hf_rrc_ul_EDCH_Information_02 = -1;    /* UL_EDCH_Information_ext */
static int hf_rrc_dummy_08 = -1;                  /* DefaultConfigForCellFACH */
static int hf_rrc_rab_InformationSetup = -1;      /* RAB_InformationSetup_r8 */
static int hf_rrc_rb_InformationReconfigList_05 = -1;  /* RB_InformationReconfigList_r8 */
static int hf_rrc_rb_InformationAffectedList_04 = -1;  /* RB_InformationAffectedList_r8 */
static int hf_rrc_ul_AddReconfTransChInfoList_03 = -1;  /* UL_AddReconfTransChInfoList_r8 */
static int hf_rrc_ul_EDCH_Information_03 = -1;    /* UL_EDCH_Information_r8 */
static int hf_rrc_dl_HSPDSCH_Information_03 = -1;  /* DL_HSPDSCH_Information_r8 */
static int hf_rrc_dl_CommonInformation_05 = -1;   /* DL_CommonInformation_r8 */
static int hf_rrc_dl_InformationPerRL_List_05 = -1;  /* DL_InformationPerRL_List_r8 */
static int hf_rrc_controlChannelDRXInfo_TDD128 = -1;  /* ControlChannelDRXInfo_TDD128_r8 */
static int hf_rrc_sps_Information_TDD128 = -1;    /* SPS_Information_TDD128_r8 */
static int hf_rrc_rab_InformationSetup_01 = -1;   /* T_rab_InformationSetup */
static int hf_rrc_rab_InformationSetup_r7 = -1;   /* RAB_InformationSetup_r7 */
static int hf_rrc_rab_InformationSetup_v820ext = -1;  /* RAB_InformationSetup_v820ext */
static int hf_rrc_dl_HSPDSCH_Information_04 = -1;  /* DL_HSPDSCH_Information_r8_ext */
static int hf_rrc_dl_HSPDSCH_Information_05 = -1;  /* DL_HSPDSCH_Information_r8_ext2 */
static int hf_rrc_dl_AddReconfTransChInfoList_04 = -1;  /* DL_AddReconfTransChInfoList_r9 */
static int hf_rrc_ul_EDCH_Information_04 = -1;    /* UL_EDCH_Information_r9 */
static int hf_rrc_dl_HSPDSCH_Information_06 = -1;  /* DL_HSPDSCH_Information_r9 */
static int hf_rrc_cellDCHMeasOccasionInfo_TDD128 = -1;  /* CellDCHMeasOccasionInfo_TDD128_r9 */
static int hf_rrc_dl_AddReconfTransChInfoList_05 = -1;  /* DL_AddReconfTransChInfoList_TDD128_v9c0ext */
static int hf_rrc_dummy2_03 = -1;                 /* SR_VCC_Info */
static int hf_rrc_ul_MulticarrierEDCHInfo_TDD128 = -1;  /* UL_MulticarrierEDCHInfo_TDD128 */
static int hf_rrc_dl_CommonInformation_06 = -1;   /* DL_CommonInformation_r10 */
static int hf_rrc_mu_MIMO_Info_TDD128 = -1;       /* MU_MIMO_Info_TDD128 */
static int hf_rrc_rb_InformationReconfigList_06 = -1;  /* RB_InformationReconfigList_r11 */
static int hf_rrc_dl_AddReconfTransChInfoList_06 = -1;  /* DL_AddReconfTransChInfoList_r11 */
static int hf_rrc_ul_DPCH_Info_02 = -1;           /* UL_DPCH_Info_r11 */
static int hf_rrc_ul_EDCH_Information_05 = -1;    /* UL_EDCH_Information_r11 */
static int hf_rrc_dl_HSPDSCH_Information_07 = -1;  /* DL_HSPDSCH_Information_r11 */
static int hf_rrc_dl_CommonInformation_07 = -1;   /* DL_CommonInformation_r11 */
static int hf_rrc_dl_InformationPerRL_List_06 = -1;  /* DL_InformationPerRL_List_r11 */
static int hf_rrc_commonERGCHInfoFDD = -1;        /* CommonERGCHInfoFDD */
static int hf_rrc_r3_05 = -1;                     /* T_r3_05 */
static int hf_rrc_laterNonCriticalExtensions_08 = -1;  /* T_laterNonCriticalExtensions_08 */
static int hf_rrc_cellUpdateConfirm_CCCH_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_03 = -1;  /* T_v4b0NonCriticalExtensions_03 */
static int hf_rrc_v590NonCriticalExtensions_03 = -1;  /* T_v590NonCriticalExtensions_03 */
static int hf_rrc_v5d0NonCriticalExtenstions_03 = -1;  /* T_v5d0NonCriticalExtenstions_03 */
static int hf_rrc_v690NonCriticalExtensions_05 = -1;  /* T_v690NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_24 = -1;  /* T_nonCriticalExtensions_24 */
static int hf_rrc_later_than_r3_04 = -1;          /* T_later_than_r3_04 */
static int hf_rrc_criticalExtensions_19 = -1;     /* T_criticalExtensions_19 */
static int hf_rrc_r4_01 = -1;                     /* T_r4_01 */
static int hf_rrc_v4d0NonCriticalExtensions_01 = -1;  /* T_v4d0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_CCCH_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_04 = -1;  /* T_v590NonCriticalExtensions_04 */
static int hf_rrc_v5d0NonCriticalExtenstions_04 = -1;  /* T_v5d0NonCriticalExtenstions_04 */
static int hf_rrc_v690NonCriticalExtensions_06 = -1;  /* T_v690NonCriticalExtensions_06 */
static int hf_rrc_nonCriticalExtensions_25 = -1;  /* T_nonCriticalExtensions_25 */
static int hf_rrc_criticalExtensions_20 = -1;     /* T_criticalExtensions_20 */
static int hf_rrc_r5_01 = -1;                     /* T_r5_01 */
static int hf_rrc_cellUpdateConfirm_CCCH_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_05 = -1;  /* T_v5d0NonCriticalExtenstions_05 */
static int hf_rrc_v690NonCriticalExtensions_07 = -1;  /* T_v690NonCriticalExtensions_07 */
static int hf_rrc_nonCriticalExtensions_26 = -1;  /* T_nonCriticalExtensions_26 */
static int hf_rrc_criticalExtensions_21 = -1;     /* T_criticalExtensions_21 */
static int hf_rrc_r6_02 = -1;                     /* T_r6_02 */
static int hf_rrc_v6b0NonCriticalExtensions_03 = -1;  /* T_v6b0NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_27 = -1;  /* T_nonCriticalExtensions_27 */
static int hf_rrc_criticalExtensions_22 = -1;     /* T_criticalExtensions_22 */
static int hf_rrc_r7_02 = -1;                     /* T_r7_02 */
static int hf_rrc_cellUpdateConfirm_r7_add_ext_01 = -1;  /* T_cellUpdateConfirm_r7_add_ext_01 */
static int hf_rrc_v780NonCriticalExtensions_02 = -1;  /* T_v780NonCriticalExtensions_02 */
static int hf_rrc_v860NonCriticalExtensions_02 = -1;  /* T_v860NonCriticalExtensions_02 */
static int hf_rrc_nonCriticalExtensions_28 = -1;  /* T_nonCriticalExtensions_28 */
static int hf_rrc_criticalExtensions_23 = -1;     /* T_criticalExtensions_23 */
static int hf_rrc_r8_02 = -1;                     /* T_r8_02 */
static int hf_rrc_v7d0NonCriticalExtensions_01 = -1;  /* T_v7d0NonCriticalExtensions_01 */
static int hf_rrc_v890NonCriticalExtensions_02 = -1;  /* T_v890NonCriticalExtensions_02 */
static int hf_rrc_v8a0NonCriticalExtensions_01 = -1;  /* T_v8a0NonCriticalExtensions_01 */
static int hf_rrc_v7f0NonCriticalExtensions_03 = -1;  /* T_v7f0NonCriticalExtensions_03 */
static int hf_rrc_v7g0NonCriticalExtensions_05 = -1;  /* T_v7g0NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_29 = -1;  /* T_nonCriticalExtensions_29 */
static int hf_rrc_criticalExtensions_24 = -1;     /* T_criticalExtensions_24 */
static int hf_rrc_r9_02 = -1;                     /* T_r9_02 */
static int hf_rrc_nonCriticalExtensions_30 = -1;  /* T_nonCriticalExtensions_30 */
static int hf_rrc_criticalExtensions_25 = -1;     /* T_criticalExtensions_25 */
static int hf_rrc_r10_02 = -1;                    /* T_r10_02 */
static int hf_rrc_vb50NonCriticalExtensions_03 = -1;  /* T_vb50NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_31 = -1;  /* T_nonCriticalExtensions_31 */
static int hf_rrc_criticalExtensions_26 = -1;     /* T_criticalExtensions_26 */
static int hf_rrc_r11_02 = -1;                    /* T_r11_02 */
static int hf_rrc_nonCriticalExtensions_32 = -1;  /* T_nonCriticalExtensions_32 */
static int hf_rrc_criticalExtensions_27 = -1;     /* T_criticalExtensions_27 */
static int hf_rrc_r3_06 = -1;                     /* T_r3_06 */
static int hf_rrc_counterCheck_r3 = -1;           /* CounterCheck_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_09 = -1;  /* T_laterNonCriticalExtensions_09 */
static int hf_rrc_counterCheck_r3_add_ext = -1;   /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_33 = -1;  /* T_nonCriticalExtensions_33 */
static int hf_rrc_later_than_r3_05 = -1;          /* T_later_than_r3_05 */
static int hf_rrc_criticalExtensions_28 = -1;     /* T_criticalExtensions_28 */
static int hf_rrc_rb_COUNT_C_MSB_InformationList = -1;  /* RB_COUNT_C_MSB_InformationList */
static int hf_rrc_rb_COUNT_C_InformationList = -1;  /* RB_COUNT_C_InformationList */
static int hf_rrc_laterNonCriticalExtensions_10 = -1;  /* T_laterNonCriticalExtensions_10 */
static int hf_rrc_counterCheckResponse_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_34 = -1;  /* T_nonCriticalExtensions_34 */
static int hf_rrc_r3_07 = -1;                     /* T_r3_07 */
static int hf_rrc_downlinkDirectTransfer_r3 = -1;  /* DownlinkDirectTransfer_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_11 = -1;  /* T_laterNonCriticalExtensions_11 */
static int hf_rrc_downlinkDirectTransfer_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_35 = -1;  /* T_nonCriticalExtensions_35 */
static int hf_rrc_later_than_r3_06 = -1;          /* T_later_than_r3_06 */
static int hf_rrc_criticalExtensions_29 = -1;     /* T_criticalExtensions_29 */
static int hf_rrc_cn_DomainIdentity = -1;         /* CN_DomainIdentity */
static int hf_rrc_nas_Message = -1;               /* NAS_Message */
static int hf_rrc_etws_Information = -1;          /* ETWS_Information */
static int hf_rrc_dummy_09 = -1;                  /* ETWS_WarningSecurityInfo */
static int hf_rrc_nonCriticalExtensions_36 = -1;  /* T_nonCriticalExtensions_36 */
static int hf_rrc_r3_08 = -1;                     /* T_r3_08 */
static int hf_rrc_handoverToUTRANCommand_r3 = -1;  /* HandoverToUTRANCommand_r3_IEs */
static int hf_rrc_nonCriticalExtensions_37 = -1;  /* T_nonCriticalExtensions_37 */
static int hf_rrc_criticalExtensions_30 = -1;     /* T_criticalExtensions_30 */
static int hf_rrc_r4_02 = -1;                     /* T_r4_02 */
static int hf_rrc_handoverToUTRANCommand_r4 = -1;  /* HandoverToUTRANCommand_r4_IEs */
static int hf_rrc_nonCriticalExtensions_38 = -1;  /* T_nonCriticalExtensions_38 */
static int hf_rrc_criticalExtensions_31 = -1;     /* T_criticalExtensions_31 */
static int hf_rrc_r5_02 = -1;                     /* T_r5_02 */
static int hf_rrc_handoverToUTRANCommand_r5 = -1;  /* HandoverToUTRANCommand_r5_IEs */
static int hf_rrc_nonCriticalExtensions_39 = -1;  /* T_nonCriticalExtensions_39 */
static int hf_rrc_criticalExtensions_32 = -1;     /* T_criticalExtensions_32 */
static int hf_rrc_r6_03 = -1;                     /* T_r6_03 */
static int hf_rrc_handoverToUTRANCommand_r6 = -1;  /* HandoverToUTRANCommand_r6_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_04 = -1;  /* T_v6b0NonCriticalExtensions_04 */
static int hf_rrc_handoverToUTRANCommand_v6b0ext = -1;  /* HandoverToUTRANCommand_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_40 = -1;  /* T_nonCriticalExtensions_40 */
static int hf_rrc_criticalExtensions_33 = -1;     /* T_criticalExtensions_33 */
static int hf_rrc_r7_03 = -1;                     /* T_r7_03 */
static int hf_rrc_handoverToUTRANCommand_r7 = -1;  /* HandoverToUTRANCommand_r7_IEs */
static int hf_rrc_v780NonCriticalExtensions_03 = -1;  /* T_v780NonCriticalExtensions_03 */
static int hf_rrc_handoverToUTRANCommand_v780ext = -1;  /* HandoverToUTRANCommand_v780ext_IEs */
static int hf_rrc_v820NonCriticalExtensions = -1;  /* T_v820NonCriticalExtensions */
static int hf_rrc_handoverToUTRANCommand_v820ext = -1;  /* HandoverToUTRANCommand_v820ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_02 = -1;  /* T_v7d0NonCriticalExtensions_02 */
static int hf_rrc_handoverToUTRANCommand_v7d0ext = -1;  /* HandoverToUTRANCommand_v7d0ext_IEs */
static int hf_rrc_nonCriticalExtensions_41 = -1;  /* T_nonCriticalExtensions_41 */
static int hf_rrc_criticalExtensions_34 = -1;     /* T_criticalExtensions_34 */
static int hf_rrc_r8_03 = -1;                     /* T_r8_03 */
static int hf_rrc_handoverToUTRANCommand_r8 = -1;  /* HandoverToUTRANCommand_r8_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_03 = -1;  /* T_v7d0NonCriticalExtensions_03 */
static int hf_rrc_v890NonCriticalExtensions_03 = -1;  /* T_v890NonCriticalExtensions_03 */
static int hf_rrc_handoverToUTRANCommand_v890ext = -1;  /* HandoverToUTRANCommand_v890ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions_02 = -1;  /* T_v8a0NonCriticalExtensions_02 */
static int hf_rrc_handoverToUTRANCommand_v8a0ext = -1;  /* HandoverToUTRANCommand_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_42 = -1;  /* T_nonCriticalExtensions_42 */
static int hf_rrc_criticalExtensions_35 = -1;     /* T_criticalExtensions_35 */
static int hf_rrc_r9_03 = -1;                     /* T_r9_03 */
static int hf_rrc_handoverToUTRANCommand_r9 = -1;  /* HandoverToUTRANCommand_r9_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_02 = -1;  /* T_v9c0NonCriticalExtensions_02 */
static int hf_rrc_handoverToUTRANCommand_v9c0ext = -1;  /* HandoverToUTRANCommand_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_43 = -1;  /* T_nonCriticalExtensions_43 */
static int hf_rrc_criticalExtensions_36 = -1;     /* HandoverToUTRANCommand_LaterCriticalExtensions */
static int hf_rrc_new_U_RNTI_01 = -1;             /* U_RNTI_Short */
static int hf_rrc_dummy_10 = -1;                  /* ActivationTime */
static int hf_rrc_cipheringAlgorithm = -1;        /* CipheringAlgorithm */
static int hf_rrc_specificationMode = -1;         /* T_specificationMode */
static int hf_rrc_complete = -1;                  /* T_complete */
static int hf_rrc_srb_InformationSetupList = -1;  /* SRB_InformationSetupList */
static int hf_rrc_rab_InformationSetupList = -1;  /* RAB_InformationSetupList */
static int hf_rrc_ul_DPCH_Info_03 = -1;           /* UL_DPCH_Info */
static int hf_rrc_modeSpecificInfo = -1;          /* T_modeSpecificInfo */
static int hf_rrc_fdd_06 = -1;                    /* T_fdd_06 */
static int hf_rrc_dummy2_04 = -1;                 /* CPCH_SetInfo */
static int hf_rrc_preconfiguration = -1;          /* T_preconfiguration */
static int hf_rrc_preConfigMode = -1;             /* T_preConfigMode */
static int hf_rrc_predefinedConfigIdentity = -1;  /* PredefinedConfigIdentity */
static int hf_rrc_defaultConfig = -1;             /* T_defaultConfig */
static int hf_rrc_defaultConfigMode = -1;         /* DefaultConfigMode */
static int hf_rrc_defaultConfigIdentity = -1;     /* DefaultConfigIdentity */
static int hf_rrc_rab_Info = -1;                  /* RAB_Info_Post */
static int hf_rrc_modeSpecificInfo_01 = -1;       /* T_modeSpecificInfo_01 */
static int hf_rrc_fdd_07 = -1;                    /* T_fdd_07 */
static int hf_rrc_ul_DPCH_Info_04 = -1;           /* UL_DPCH_InfoPostFDD */
static int hf_rrc_dl_CommonInformationPost = -1;  /* DL_CommonInformationPost */
static int hf_rrc_dl_InformationPerRL_List_07 = -1;  /* DL_InformationPerRL_ListPostFDD */
static int hf_rrc_frequencyInfo_01 = -1;          /* FrequencyInfoFDD */
static int hf_rrc_tdd_01 = -1;                    /* T_tdd */
static int hf_rrc_ul_DPCH_Info_05 = -1;           /* UL_DPCH_InfoPostTDD */
static int hf_rrc_dl_InformationPerRL = -1;       /* DL_InformationPerRL_PostTDD */
static int hf_rrc_frequencyInfo_02 = -1;          /* FrequencyInfoTDD */
static int hf_rrc_primaryCCPCH_TX_Power = -1;     /* PrimaryCCPCH_TX_Power */
static int hf_rrc_specificationMode_01 = -1;      /* T_specificationMode_01 */
static int hf_rrc_complete_01 = -1;               /* T_complete_01 */
static int hf_rrc_rab_InformationSetupList_01 = -1;  /* RAB_InformationSetupList_r4 */
static int hf_rrc_ul_DPCH_Info_06 = -1;           /* UL_DPCH_Info_r4 */
static int hf_rrc_modeSpecificInfo_02 = -1;       /* T_modeSpecificInfo_02 */
static int hf_rrc_fdd_08 = -1;                    /* T_fdd_08 */
static int hf_rrc_preconfiguration_01 = -1;       /* T_preconfiguration_01 */
static int hf_rrc_preConfigMode_01 = -1;          /* T_preConfigMode_01 */
static int hf_rrc_defaultConfig_01 = -1;          /* T_defaultConfig_01 */
static int hf_rrc_defaultConfigIdentity_01 = -1;  /* DefaultConfigIdentity_r4 */
static int hf_rrc_modeSpecificInfo_03 = -1;       /* T_modeSpecificInfo_03 */
static int hf_rrc_fdd_09 = -1;                    /* T_fdd_09 */
static int hf_rrc_tdd_02 = -1;                    /* T_tdd_01 */
static int hf_rrc_tdd384 = -1;                    /* T_tdd384 */
static int hf_rrc_tdd128 = -1;                    /* T_tdd128 */
static int hf_rrc_ul_DPCH_Info_07 = -1;           /* UL_DPCH_InfoPostTDD_LCR_r4 */
static int hf_rrc_dl_InformationPerRL_01 = -1;    /* DL_InformationPerRL_PostTDD_LCR_r4 */
static int hf_rrc_specificationMode_02 = -1;      /* T_specificationMode_02 */
static int hf_rrc_complete_02 = -1;               /* T_complete_02 */
static int hf_rrc_srb_InformationSetupList_01 = -1;  /* SRB_InformationSetupList_r5 */
static int hf_rrc_rab_InformationSetupList_02 = -1;  /* RAB_InformationSetupList_r5 */
static int hf_rrc_ul_DPCH_Info_08 = -1;           /* UL_DPCH_Info_r5 */
static int hf_rrc_modeSpecificInfo_04 = -1;       /* T_modeSpecificInfo_04 */
static int hf_rrc_fdd_10 = -1;                    /* T_fdd_10 */
static int hf_rrc_preconfiguration_02 = -1;       /* T_preconfiguration_02 */
static int hf_rrc_preConfigMode_02 = -1;          /* T_preConfigMode_02 */
static int hf_rrc_defaultConfig_02 = -1;          /* T_defaultConfig_02 */
static int hf_rrc_defaultConfigIdentity_02 = -1;  /* DefaultConfigIdentity_r5 */
static int hf_rrc_modeSpecificInfo_05 = -1;       /* T_modeSpecificInfo_05 */
static int hf_rrc_fdd_11 = -1;                    /* T_fdd_11 */
static int hf_rrc_tdd_03 = -1;                    /* T_tdd_02 */
static int hf_rrc_tdd384_01 = -1;                 /* T_tdd384_01 */
static int hf_rrc_tdd128_01 = -1;                 /* T_tdd128_01 */
static int hf_rrc_specificationMode_03 = -1;      /* T_specificationMode_03 */
static int hf_rrc_complete_03 = -1;               /* T_complete_03 */
static int hf_rrc_srb_InformationSetupList_02 = -1;  /* SRB_InformationSetupList_r6 */
static int hf_rrc_rab_InformationSetupList_03 = -1;  /* RAB_InformationSetupList_r6 */
static int hf_rrc_preconfiguration_03 = -1;       /* T_preconfiguration_03 */
static int hf_rrc_preConfigMode_03 = -1;          /* T_preConfigMode_03 */
static int hf_rrc_defaultConfig_03 = -1;          /* T_defaultConfig_03 */
static int hf_rrc_defaultConfigIdentity_03 = -1;  /* DefaultConfigIdentity_r6 */
static int hf_rrc_modeSpecificInfo_06 = -1;       /* T_modeSpecificInfo_06 */
static int hf_rrc_fdd_12 = -1;                    /* T_fdd_12 */
static int hf_rrc_tdd_04 = -1;                    /* T_tdd_03 */
static int hf_rrc_tdd384_02 = -1;                 /* T_tdd384_02 */
static int hf_rrc_tdd128_02 = -1;                 /* T_tdd128_02 */
static int hf_rrc_ue_hspa_identities = -1;        /* UE_HSPA_Identities_r6 */
static int hf_rrc_cipheringAlgorithm_01 = -1;     /* CipheringAlgorithm_r7 */
static int hf_rrc_specificationMode_04 = -1;      /* T_specificationMode_04 */
static int hf_rrc_complete_04 = -1;               /* T_complete_04 */
static int hf_rrc_srb_InformationSetupList_03 = -1;  /* SRB_InformationSetupList_r7 */
static int hf_rrc_rab_InformationSetupList_04 = -1;  /* RAB_InformationSetupList_r7 */
static int hf_rrc_preconfiguration_04 = -1;       /* T_preconfiguration_04 */
static int hf_rrc_preConfigMode_04 = -1;          /* T_preConfigMode_04 */
static int hf_rrc_defaultConfig_04 = -1;          /* T_defaultConfig_04 */
static int hf_rrc_modeSpecificInfo_07 = -1;       /* T_modeSpecificInfo_07 */
static int hf_rrc_fdd_13 = -1;                    /* T_fdd_13 */
static int hf_rrc_tdd_05 = -1;                    /* T_tdd_04 */
static int hf_rrc_tdd384_03 = -1;                 /* T_tdd384_03 */
static int hf_rrc_tdd128_03 = -1;                 /* T_tdd128_03 */
static int hf_rrc_tdd768 = -1;                    /* T_tdd768 */
static int hf_rrc_dl_InformationPerRL_02 = -1;    /* DL_InformationPerRL_List_r7 */
static int hf_rrc_specificationMode_05 = -1;      /* T_specificationMode_05 */
static int hf_rrc_complete_05 = -1;               /* T_complete_05 */
static int hf_rrc_srb_InformationSetupList_04 = -1;  /* SRB_InformationSetupList_r8 */
static int hf_rrc_rab_InformationSetupList_05 = -1;  /* RAB_InformationSetupList_r8 */
static int hf_rrc_preconfiguration_05 = -1;       /* T_preconfiguration_05 */
static int hf_rrc_preConfigMode_05 = -1;          /* T_preConfigMode_05 */
static int hf_rrc_defaultConfig_05 = -1;          /* T_defaultConfig_05 */
static int hf_rrc_dummy_11 = -1;                  /* DLUL_HSPA_Information_r8 */
static int hf_rrc_modeSpecificInfo_08 = -1;       /* T_modeSpecificInfo_08 */
static int hf_rrc_fdd_14 = -1;                    /* T_fdd_14 */
static int hf_rrc_tdd_06 = -1;                    /* T_tdd_05 */
static int hf_rrc_tdd384_04 = -1;                 /* T_tdd384_04 */
static int hf_rrc_tdd128_04 = -1;                 /* T_tdd128_04 */
static int hf_rrc_tdd768_01 = -1;                 /* T_tdd768_01 */
static int hf_rrc_rab_InformationSetupList_06 = -1;  /* RAB_InformationSetupList_v820ext */
static int hf_rrc_defaultConfigForCellFACH = -1;  /* DefaultConfigForCellFACH */
static int hf_rrc_specificationMode_06 = -1;      /* T_specificationMode_06 */
static int hf_rrc_complete_06 = -1;               /* T_complete_06 */
static int hf_rrc_preconfiguration_06 = -1;       /* T_preconfiguration_06 */
static int hf_rrc_preConfigMode_06 = -1;          /* T_preConfigMode_06 */
static int hf_rrc_defaultConfig_06 = -1;          /* T_defaultConfig_06 */
static int hf_rrc_dummy_12 = -1;                  /* DLUL_HSPA_Information_r9 */
static int hf_rrc_modeSpecificInfo_09 = -1;       /* T_modeSpecificInfo_09 */
static int hf_rrc_fdd_15 = -1;                    /* T_fdd_15 */
static int hf_rrc_tdd_07 = -1;                    /* T_tdd_06 */
static int hf_rrc_tdd384_05 = -1;                 /* T_tdd384_05 */
static int hf_rrc_tdd128_05 = -1;                 /* T_tdd128_05 */
static int hf_rrc_tdd768_02 = -1;                 /* T_tdd768_02 */
static int hf_rrc_r10_03 = -1;                    /* T_r10_03 */
static int hf_rrc_handoverToUTRANCommand_r10 = -1;  /* HandoverToUTRANCommand_r10_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_03 = -1;  /* T_v9c0NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_44 = -1;  /* T_nonCriticalExtensions_44 */
static int hf_rrc_criticalExtensions_37 = -1;     /* T_criticalExtensions_36 */
static int hf_rrc_r11_03 = -1;                    /* T_r11_03 */
static int hf_rrc_handoverToUTRANCommand_r11 = -1;  /* HandoverToUTRANCommand_r11_IEs */
static int hf_rrc_handoverToUTRANCommand_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_45 = -1;  /* T_nonCriticalExtensions_45 */
static int hf_rrc_criticalExtensions_38 = -1;     /* T_criticalExtensions_37 */
static int hf_rrc_specificationMode_07 = -1;      /* T_specificationMode_07 */
static int hf_rrc_complete_07 = -1;               /* T_complete_07 */
static int hf_rrc_preconfiguration_07 = -1;       /* T_preconfiguration_07 */
static int hf_rrc_preConfigMode_07 = -1;          /* T_preConfigMode_07 */
static int hf_rrc_defaultConfig_07 = -1;          /* T_defaultConfig_07 */
static int hf_rrc_dummy_13 = -1;                  /* DLUL_HSPA_Information_r10 */
static int hf_rrc_modeSpecificInfo_10 = -1;       /* T_modeSpecificInfo_10 */
static int hf_rrc_fdd_16 = -1;                    /* T_fdd_16 */
static int hf_rrc_tdd_08 = -1;                    /* T_tdd_07 */
static int hf_rrc_tdd384_06 = -1;                 /* T_tdd384_06 */
static int hf_rrc_tdd128_06 = -1;                 /* T_tdd128_06 */
static int hf_rrc_tdd768_03 = -1;                 /* T_tdd768_03 */
static int hf_rrc_specificationMode_08 = -1;      /* T_specificationMode_08 */
static int hf_rrc_complete_08 = -1;               /* T_complete_08 */
static int hf_rrc_preconfiguration_08 = -1;       /* T_preconfiguration_08 */
static int hf_rrc_preConfigMode_08 = -1;          /* T_preConfigMode_08 */
static int hf_rrc_defaultConfig_08 = -1;          /* T_defaultConfig_08 */
static int hf_rrc_modeSpecificInfo_11 = -1;       /* T_modeSpecificInfo_11 */
static int hf_rrc_fdd_17 = -1;                    /* T_fdd_17 */
static int hf_rrc_tdd_09 = -1;                    /* T_tdd_08 */
static int hf_rrc_tdd384_07 = -1;                 /* T_tdd384_07 */
static int hf_rrc_tdd128_07 = -1;                 /* T_tdd128_07 */
static int hf_rrc_tdd768_04 = -1;                 /* T_tdd768_04 */
static int hf_rrc_count_C_ActivationTime = -1;    /* ActivationTime */
static int hf_rrc_laterNonCriticalExtensions_12 = -1;  /* T_laterNonCriticalExtensions_12 */
static int hf_rrc_handoverToUTRANComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_va40NonCriticalExtensions_01 = -1;  /* T_va40NonCriticalExtensions_01 */
static int hf_rrc_handoverToUTRANComplete_va40ext = -1;  /* HandoverToUTRANComplete_va40ext */
static int hf_rrc_vb50NonCriticalExtensions_04 = -1;  /* T_vb50NonCriticalExtensions_04 */
static int hf_rrc_handoverToUTRANComplete_vb50ext = -1;  /* HandoverToUTRANComplete_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_46 = -1;  /* T_nonCriticalExtensions_46 */
static int hf_rrc_loggedMeasAvailable_02 = -1;    /* T_loggedMeasAvailable_02 */
static int hf_rrc_connEstFailInfoAvailable = -1;  /* T_connEstFailInfoAvailable */
static int hf_rrc_intraDomainNasNodeSelector = -1;  /* IntraDomainNasNodeSelector */
static int hf_rrc_v3a0NonCriticalExtensions_02 = -1;  /* T_v3a0NonCriticalExtensions_02 */
static int hf_rrc_initialDirectTransfer_v3a0ext = -1;  /* InitialDirectTransfer_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_13 = -1;  /* T_laterNonCriticalExtensions_13 */
static int hf_rrc_initialDirectTransfer_r3_add_ext = -1;  /* T_initialDirectTransfer_r3_add_ext */
static int hf_rrc_v590NonCriticalExtensions_05 = -1;  /* T_v590NonCriticalExtensions_05 */
static int hf_rrc_initialDirectTransfer_v590ext = -1;  /* InitialDirectTransfer_v590ext */
static int hf_rrc_v690NonCriticalExtensions_08 = -1;  /* T_v690NonCriticalExtensions_08 */
static int hf_rrc_initialDirectTransfer_v690ext = -1;  /* InitialDirectTransfer_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_01 = -1;  /* T_v770NonCriticalExtensions_01 */
static int hf_rrc_initialDirectTransfer_v770ext = -1;  /* InitialDirectTransfer_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_03 = -1;  /* T_v860NonCriticalExtensions_03 */
static int hf_rrc_initialDirectTransfer_v860ext = -1;  /* InitialDirectTransfer_v860ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_05 = -1;  /* T_vb50NonCriticalExtensions_05 */
static int hf_rrc_initialDirectTransfer_vb50ext = -1;  /* InitialDirectTransfer_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_47 = -1;  /* T_nonCriticalExtensions_47 */
static int hf_rrc_start_Value = -1;               /* START_Value */
static int hf_rrc_plmn_Identity = -1;             /* PLMN_Identity */
static int hf_rrc_mbms_JoinedInformation = -1;    /* MBMS_JoinedInformation_r6 */
static int hf_rrc_csCallType_02 = -1;             /* T_csCallType_02 */
static int hf_rrc_supportOfCSG = -1;              /* T_supportOfCSG */
static int hf_rrc_initialDirectTransfer_v7g0ext = -1;  /* InitialDirectTransfer_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_48 = -1;  /* T_nonCriticalExtensions_48 */
static int hf_rrc_r3_09 = -1;                     /* T_r3_09 */
static int hf_rrc_handoverFromUTRANCommand_GSM_r3 = -1;  /* HandoverFromUTRANCommand_GSM_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_14 = -1;  /* T_laterNonCriticalExtensions_14 */
static int hf_rrc_handoverFromUTRANCommand_GSM_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_09 = -1;  /* T_v690NonCriticalExtensions_09 */
static int hf_rrc_handoverFromUTRANCommand_GSM_v690ext = -1;  /* HandoverFromUTRANCommand_GSM_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_04 = -1;  /* T_v860NonCriticalExtensions_04 */
static int hf_rrc_handoverFromUTRANCommand_GSM_v860ext = -1;  /* HandoverFromUTRANCommand_GSM_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_49 = -1;  /* T_nonCriticalExtensions_49 */
static int hf_rrc_later_than_r3_07 = -1;          /* T_later_than_r3_07 */
static int hf_rrc_criticalExtensions_39 = -1;     /* T_criticalExtensions_38 */
static int hf_rrc_r6_04 = -1;                     /* T_r6_04 */
static int hf_rrc_handoverFromUTRANCommand_GSM_r6 = -1;  /* HandoverFromUTRANCommand_GSM_r6_IEs */
static int hf_rrc_handoverFromUTRANCommand_GSM_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_05 = -1;  /* T_v860NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_50 = -1;  /* T_nonCriticalExtensions_50 */
static int hf_rrc_criticalExtensions_40 = -1;     /* T_criticalExtensions_39 */
static int hf_rrc_toHandoverRAB_Info = -1;        /* RAB_Info */
static int hf_rrc_frequency_band = -1;            /* Frequency_Band */
static int hf_rrc_gsm_message = -1;               /* T_gsm_message */
static int hf_rrc_single_GSM_Message_r3 = -1;     /* T_single_GSM_Message_r3 */
static int hf_rrc_gsm_MessageList_r3 = -1;        /* T_gsm_MessageList_r3 */
static int hf_rrc_gsm_Messages = -1;              /* GSM_MessageList */
static int hf_rrc_toHandoverRAB_Info_01 = -1;     /* RAB_InformationList_r6 */
static int hf_rrc_gsm_message_01 = -1;            /* T_gsm_message_01 */
static int hf_rrc_single_GSM_Message_r6 = -1;     /* T_single_GSM_Message_r6 */
static int hf_rrc_gsm_MessageList_r6 = -1;        /* T_gsm_MessageList_r6 */
static int hf_rrc_geran_SystemInfoType_01 = -1;   /* T_geran_SystemInfoType_01 */
static int hf_rrc_geran_SystemInfoType_02 = -1;   /* T_geran_SystemInfoType_02 */
static int hf_rrc_sr_vcc_SecurityRABInfo = -1;    /* SR_VCC_SecurityRABInfo_v860ext */
static int hf_rrc_handoverFromUTRANCommand_GERANIu_01 = -1;  /* T_handoverFromUTRANCommand_GERANIu */
static int hf_rrc_r5_03 = -1;                     /* T_r5_03 */
static int hf_rrc_handoverFromUTRANCommand_GERANIu_r5 = -1;  /* HandoverFromUTRANCommand_GERANIu_r5_IEs */
static int hf_rrc_nonCriticalExtensions_51 = -1;  /* T_nonCriticalExtensions_51 */
static int hf_rrc_later_than_r5 = -1;             /* T_later_than_r5 */
static int hf_rrc_criticalExtensions_41 = -1;     /* T_criticalExtensions_40 */
static int hf_rrc_frequency_Band = -1;            /* Frequency_Band */
static int hf_rrc_geranIu_Message = -1;           /* T_geranIu_Message */
static int hf_rrc_single_GERANIu_Message = -1;    /* T_single_GERANIu_Message */
static int hf_rrc_geranIu_MessageList = -1;       /* T_geranIu_MessageList */
static int hf_rrc_geranIu_Messages = -1;          /* GERANIu_MessageList */
static int hf_rrc_r3_10 = -1;                     /* T_r3_10 */
static int hf_rrc_handoverFromUTRANCommand_CDMA2000_r3 = -1;  /* HandoverFromUTRANCommand_CDMA2000_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_15 = -1;  /* T_laterNonCriticalExtensions_15 */
static int hf_rrc_handoverFromUTRANCommand_CDMA2000_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_52 = -1;  /* T_nonCriticalExtensions_52 */
static int hf_rrc_later_than_r3_08 = -1;          /* T_later_than_r3_08 */
static int hf_rrc_criticalExtensions_42 = -1;     /* T_criticalExtensions_41 */
static int hf_rrc_cdma2000_MessageList = -1;      /* CDMA2000_MessageList */
static int hf_rrc_criticalExtensions_43 = -1;     /* T_criticalExtensions_42 */
static int hf_rrc_r8_04 = -1;                     /* T_r8_04 */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r8 = -1;  /* HandoverFromUTRANCommand_EUTRA_r8_IEs */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_53 = -1;  /* T_nonCriticalExtensions_53 */
static int hf_rrc_criticalExtensions_44 = -1;     /* T_criticalExtensions_43 */
static int hf_rrc_r11_04 = -1;                    /* T_r11_04 */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r11 = -1;  /* HandoverFromUTRANCommand_EUTRA_r11_IEs */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_54 = -1;  /* T_nonCriticalExtensions_54 */
static int hf_rrc_criticalExtensions_45 = -1;     /* T_criticalExtensions_44 */
static int hf_rrc_toHandoverRAB_Info_02 = -1;     /* RAB_InformationList */
static int hf_rrc_eutra_Message = -1;             /* T_eutra_Message */
static int hf_rrc_rsr_vcc_Info = -1;              /* RSR_VCC_Info */
static int hf_rrc_eutra_Message_01 = -1;          /* T_eutra_Message_01 */
static int hf_rrc_interRAT_HO_FailureCause = -1;  /* InterRAT_HO_FailureCause */
static int hf_rrc_interRATMessage = -1;           /* T_interRATMessage */
static int hf_rrc_gsm = -1;                       /* T_gsm */
static int hf_rrc_gsm_MessageList_gsm = -1;       /* GSM_MessageList */
static int hf_rrc_cdma2000 = -1;                  /* T_cdma2000 */
static int hf_rrc_laterNonCriticalExtensions_16 = -1;  /* T_laterNonCriticalExtensions_16 */
static int hf_rrc_handoverFromUTRANFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_06 = -1;  /* T_v590NonCriticalExtensions_06 */
static int hf_rrc_handoverFromUTRANFailure_v590ext = -1;  /* HandoverFromUtranFailure_v590ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_06 = -1;  /* T_v860NonCriticalExtensions_06 */
static int hf_rrc_handoverFromUTRANFailure_v860ext = -1;  /* HandoverFromUtranFailure_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_55 = -1;  /* T_nonCriticalExtensions_55 */
static int hf_rrc_geranIu_MessageList_01 = -1;    /* GERANIu_MessageList */
static int hf_rrc_eutra_Message_02 = -1;          /* T_eutra_Message_02 */
static int hf_rrc_predefinedConfigStatusList = -1;  /* T_predefinedConfigStatusList */
static int hf_rrc_absent = -1;                    /* NULL */
static int hf_rrc_present = -1;                   /* PredefinedConfigStatusList */
static int hf_rrc_uE_SecurityInformation = -1;    /* T_uE_SecurityInformation */
static int hf_rrc_present_01 = -1;                /* UE_SecurityInformation */
static int hf_rrc_ue_CapabilityContainer = -1;    /* T_ue_CapabilityContainer */
static int hf_rrc_present_02 = -1;                /* T_present */
static int hf_rrc_v390NonCriticalExtensions = -1;  /* T_v390NonCriticalExtensions */
static int hf_rrc_present_03 = -1;                /* T_present_01 */
static int hf_rrc_interRATHandoverInfo_v390ext = -1;  /* InterRATHandoverInfo_v390ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_03 = -1;  /* T_v3a0NonCriticalExtensions_03 */
static int hf_rrc_interRATHandoverInfo_v3a0ext = -1;  /* InterRATHandoverInfo_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_17 = -1;  /* T_laterNonCriticalExtensions_17 */
static int hf_rrc_interRATHandoverInfo_v3d0ext = -1;  /* InterRATHandoverInfo_v3d0ext_IEs */
static int hf_rrc_interRATHandoverInfo_r3_add_ext = -1;  /* T_interRATHandoverInfo_r3_add_ext */
static int hf_rrc_v3g0NonCriticalExtensions = -1;  /* T_v3g0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v3g0ext = -1;  /* InterRATHandoverInfo_v3g0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_04 = -1;  /* T_v4b0NonCriticalExtensions_04 */
static int hf_rrc_interRATHandoverInfo_v4b0ext = -1;  /* InterRATHandoverInfo_v4b0ext_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_02 = -1;  /* T_v4d0NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_v4d0ext = -1;  /* InterRATHandoverInfo_v4d0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_07 = -1;  /* T_v590NonCriticalExtensions_07 */
static int hf_rrc_interRATHandoverInfo_v590ext = -1;  /* InterRATHandoverInfo_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_10 = -1;  /* T_v690NonCriticalExtensions_10 */
static int hf_rrc_interRATHandoverInfo_v690ext = -1;  /* InterRATHandoverInfo_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_05 = -1;  /* InterRATHandoverInfo_NonCriticalExtension_v6b0_IEs */
static int hf_rrc_ue_RadioAccessCapability_v380ext = -1;  /* UE_RadioAccessCapability_v380ext */
static int hf_rrc_dl_PhysChCapabilityFDD_v380ext = -1;  /* DL_PhysChCapabilityFDD_v380ext */
static int hf_rrc_ue_RadioAccessCapability_v3a0ext = -1;  /* UE_RadioAccessCapability_v3a0ext */
static int hf_rrc_uESpecificBehaviourInformation1interRAT = -1;  /* UESpecificBehaviourInformation1interRAT */
static int hf_rrc_ue_RadioAccessCapability_v3g0ext = -1;  /* UE_RadioAccessCapability_v3g0ext */
static int hf_rrc_interRATHandoverInfo_v690ext1 = -1;  /* InterRATHandoverInfo_v690ext1_IEs */
static int hf_rrc_v7e0NonCriticalExtensions = -1;  /* T_v7e0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v7e0ext = -1;  /* InterRATHandoverInfo_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_04 = -1;  /* T_v7f0NonCriticalExtensions_04 */
static int hf_rrc_interRATHandoverInfo_v7f0ext = -1;  /* InterRATHandoverInfo_v7f0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_02 = -1;  /* T_va40NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_va40ext = -1;  /* InterRATHandoverInfoBand_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_56 = -1;  /* T_nonCriticalExtensions_56 */
static int hf_rrc_accessStratumReleaseIndicator = -1;  /* AccessStratumReleaseIndicator */
static int hf_rrc_tdd128_RF_Capability = -1;      /* RadioFrequencyBandTDDList */
static int hf_rrc_predefinedConfigStatusListComp = -1;  /* PredefinedConfigStatusListComp */
static int hf_rrc_ue_RadioAccessCapabilityComp = -1;  /* UE_RadioAccessCapabilityComp */
static int hf_rrc_ue_RadioAccessCapability_v650ext = -1;  /* UE_RadioAccessCapability_v650ext */
static int hf_rrc_ue_SecurityInformation2 = -1;   /* UE_SecurityInformation2 */
static int hf_rrc_ue_RadioAccessCapabilityComp_01 = -1;  /* UE_RadioAccessCapabilityComp_ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2 = -1;  /* UE_RadioAccessCapabilityComp2 */
static int hf_rrc_interRATHandoverInfo_v6b0ext = -1;  /* InterRATHandoverInfo_v6b0ext_IEs */
static int hf_rrc_v6e0NonCriticalExtensions = -1;  /* T_v6e0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v6e0ext = -1;  /* InterRATHandoverInfo_v6e0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_02 = -1;  /* T_v770NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_v770ext = -1;  /* InterRATHandoverInfo_v770ext_IEs */
static int hf_rrc_v790nonCriticalExtensions = -1;  /* T_v790nonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v790ext = -1;  /* InterRATHandoverInfo_v790ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_07 = -1;  /* T_v860NonCriticalExtensions_07 */
static int hf_rrc_interRATHandoverInfo_v860ext = -1;  /* InterRATHandoverInfo_v860ext_IEs */
static int hf_rrc_v880NonCriticalExtensions = -1;  /* T_v880NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v880ext = -1;  /* InterRATHandoverInfo_v880ext_IEs */
static int hf_rrc_v920NonCriticalExtensions = -1;  /* T_v920NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v920ext = -1;  /* InterRATHandoverInfo_v920ext_IEs */
static int hf_rrc_v8b0NonCriticalExtensions = -1;  /* T_v8b0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v8b0ext = -1;  /* InterRATHandoverInfo_v8b0ext_IEs */
static int hf_rrc_v950NonCriticalExtensions_02 = -1;  /* T_v950NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_v950ext = -1;  /* InterRATHandoverInfo_v950ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_03 = -1;  /* T_va40NonCriticalExtensions_03 */
static int hf_rrc_interRATHandoverInfo_va40ext_01 = -1;  /* InterRATHandoverInfo_va40ext_IEs */
static int hf_rrc_va80NonCriticalExtensions = -1;  /* T_va80NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_va80ext = -1;  /* InterRATHandoverInfo_va80ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_06 = -1;  /* T_vb50NonCriticalExtensions_06 */
static int hf_rrc_interRATHandoverInfo_vb50ext = -1;  /* InterRATHandoverInfo_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_57 = -1;  /* T_nonCriticalExtensions_57 */
static int hf_rrc_supportForSIB11bis = -1;        /* T_supportForSIB11bis */
static int hf_rrc_supportForFDPCH = -1;           /* T_supportForFDPCH */
static int hf_rrc_ue_RadioAccessCapabilityInfo = -1;  /* UE_RadioAccessCapabilityInfo_v770ext */
static int hf_rrc_ue_RadioAccessCapabilityComp_02 = -1;  /* UE_RadioAccessCapabilityComp_v770ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_01 = -1;  /* UE_RadioAccessCapabilityComp2_v770ext */
static int hf_rrc_supportForEDPCCHPowerBoosting = -1;  /* T_supportForEDPCCHPowerBoosting */
static int hf_rrc_ue_RadioAccessCapability = -1;  /* UE_RadioAccessCapability_v7e0ext */
static int hf_rrc_ue_RadioAccessCapability_01 = -1;  /* UE_RadioAccessCapability_v7f0ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_02 = -1;  /* UE_RadioAccessCapabilityComp2_v7f0ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_01 = -1;  /* UE_RadioAccessCapability_v860ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_03 = -1;  /* UE_RadioAccessCapabilityComp2_v860ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_02 = -1;  /* UE_RadioAccessCapability_v880ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_TDD128 = -1;  /* UE_RadioAccessCapabilityComp_TDD128 */
static int hf_rrc_ue_RadioAccessCapabilityInfo_03 = -1;  /* UE_RadioAccessCapability_v920ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_04 = -1;  /* UE_RadioAccessCapabilityComp2_v920ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_04 = -1;  /* UE_RadioAccessCapabilityInfo_TDD128_v8b0ext */
static int hf_rrc_pdcp_Capability = -1;           /* PDCP_Capability_r4_ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_05 = -1;  /* UE_RadioAccessCapability_va40ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_05 = -1;  /* UE_RadioAccessCapabilityComp2_va40ext */
static int hf_rrc_ue_RadioAccessCapabBand = -1;   /* UE_RadioAccessCapabBand_va40ext */
static int hf_rrc_rf_CapabilityFDDComp = -1;      /* RF_CapabBandListFDDComp_ext2 */
static int hf_rrc_ue_RadioAccessCapabilityInfo_va80ext = -1;  /* UE_RadioAccessCapability_va80ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_vb50ext = -1;  /* UE_RadioAccessCapability_vb50ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_06 = -1;  /* UE_RadioAccessCapabilityComp2_vb50ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_TDD128_01 = -1;  /* UE_RadioAccessCapabilityInfo_TDD128_vb50ext */
static int hf_rrc_r3_11 = -1;                     /* T_r3_11 */
static int hf_rrc_measurementControl_r3 = -1;     /* MeasurementControl_r3_IEs */
static int hf_rrc_v390nonCriticalExtensions = -1;  /* T_v390nonCriticalExtensions */
static int hf_rrc_measurementControl_v390ext = -1;  /* MeasurementControl_v390ext */
static int hf_rrc_v3a0NonCriticalExtensions_04 = -1;  /* T_v3a0NonCriticalExtensions_04 */
static int hf_rrc_measurementControl_v3a0ext = -1;  /* MeasurementControl_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_18 = -1;  /* T_laterNonCriticalExtensions_18 */
static int hf_rrc_measurementControl_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_05 = -1;  /* T_v4b0NonCriticalExtensions_05 */
static int hf_rrc_v590NonCriticalExtensions_08 = -1;  /* T_v590NonCriticalExtensions_08 */
static int hf_rrc_measurementControl_v590ext = -1;  /* MeasurementControl_v590ext_IEs */
static int hf_rrc_v5b0NonCriticalExtensions = -1;  /* T_v5b0NonCriticalExtensions */
static int hf_rrc_measurementControl_v5b0ext = -1;  /* MeasurementControl_v5b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_58 = -1;  /* T_nonCriticalExtensions_58 */
static int hf_rrc_later_than_r3_09 = -1;          /* T_later_than_r3_09 */
static int hf_rrc_criticalExtensions_46 = -1;     /* T_criticalExtensions_45 */
static int hf_rrc_r4_03 = -1;                     /* T_r4_03 */
static int hf_rrc_measurementControl_r4 = -1;     /* MeasurementControl_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_03 = -1;  /* T_v4d0NonCriticalExtensions_03 */
static int hf_rrc_measurementControl_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_09 = -1;  /* T_v590NonCriticalExtensions_09 */
static int hf_rrc_v5b0NonCriticalExtensions_01 = -1;  /* T_v5b0NonCriticalExtensions_01 */
static int hf_rrc_nonCriticalExtensions_59 = -1;  /* T_nonCriticalExtensions_59 */
static int hf_rrc_later_than_r4 = -1;             /* T_later_than_r4 */
static int hf_rrc_rrc_TransactionIdentifier_MSP = -1;  /* RRC_TransactionIdentifier */
static int hf_rrc_criticalExtensions_47 = -1;     /* T_criticalExtensions_46 */
static int hf_rrc_r6_05 = -1;                     /* T_r6_05 */
static int hf_rrc_measurementControl_r6 = -1;     /* MeasurementControl_r6_IEs */
static int hf_rrc_v6a0NonCriticalExtensions = -1;  /* T_v6a0NonCriticalExtensions */
static int hf_rrc_measurementControl_v6a0ext = -1;  /* MeasurementControl_v6a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_60 = -1;  /* T_nonCriticalExtensions_60 */
static int hf_rrc_criticalExtensions_48 = -1;     /* T_criticalExtensions_47 */
static int hf_rrc_r7_04 = -1;                     /* T_r7_04 */
static int hf_rrc_measurementControl_r7 = -1;     /* MeasurementControl_r7_IEs */
static int hf_rrc_measurementControl_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7b0NonCriticalExtensions = -1;  /* T_v7b0NonCriticalExtensions */
static int hf_rrc_measurementControl_v7b0ext = -1;  /* MeasurementControl_v7b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_61 = -1;  /* T_nonCriticalExtensions_61 */
static int hf_rrc_criticalExtensions_49 = -1;     /* T_criticalExtensions_48 */
static int hf_rrc_r8_05 = -1;                     /* T_r8_05 */
static int hf_rrc_measurementControl_r8 = -1;     /* MeasurementControl_r8_IEs */
static int hf_rrc_measurementControl_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v8a0NonCriticalExtensions_03 = -1;  /* T_v8a0NonCriticalExtensions_03 */
static int hf_rrc_measurementControl_v8a0ext = -1;  /* MeasurementControl_v8a0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_07 = -1;  /* T_vb50NonCriticalExtensions_07 */
static int hf_rrc_measurementControl_vb50ext = -1;  /* MeasurementControl_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_62 = -1;  /* T_nonCriticalExtensions_62 */
static int hf_rrc_criticalExtensions_50 = -1;     /* T_criticalExtensions_49 */
static int hf_rrc_r9_04 = -1;                     /* T_r9_04 */
static int hf_rrc_measurementControl_r9 = -1;     /* MeasurementControl_r9_IEs */
static int hf_rrc_measurementControl_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v970NonCriticalExtensions = -1;  /* T_v970NonCriticalExtensions */
static int hf_rrc_measurementControl_v970ext = -1;  /* MeasurementControl_v970ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_08 = -1;  /* T_vb50NonCriticalExtensions_08 */
static int hf_rrc_nonCriticalExtensions_63 = -1;  /* T_nonCriticalExtensions_63 */
static int hf_rrc_criticalExtensions_51 = -1;     /* T_criticalExtensions_50 */
static int hf_rrc_r10_04 = -1;                    /* T_r10_04 */
static int hf_rrc_measurementControl_r10 = -1;    /* MeasurementControl_r10_IEs */
static int hf_rrc_measurementControl_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_vaa0NonCriticalExtensions = -1;  /* T_vaa0NonCriticalExtensions */
static int hf_rrc_measurementControl_vaa0ext = -1;  /* MeasurementControl_vaa0ext_IEs */
static int hf_rrc_vab0NonCriticalExtensions = -1;  /* T_vab0NonCriticalExtensions */
static int hf_rrc_measurementControl_vab0ext = -1;  /* MeasurementControl_vab0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_09 = -1;  /* T_vb50NonCriticalExtensions_09 */
static int hf_rrc_nonCriticalExtensions_64 = -1;  /* T_nonCriticalExtensions_64 */
static int hf_rrc_criticalExtensions_52 = -1;     /* T_criticalExtensions_51 */
static int hf_rrc_r11_05 = -1;                    /* T_r11_05 */
static int hf_rrc_measurementControl_r11 = -1;    /* MeasurementControl_r11_IEs */
static int hf_rrc_measurementControl_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_65 = -1;  /* T_nonCriticalExtensions_65 */
static int hf_rrc_criticalExtensions_53 = -1;     /* T_criticalExtensions_52 */
static int hf_rrc_measurementIdentity = -1;       /* MeasurementIdentity */
static int hf_rrc_measurementCommand = -1;        /* MeasurementCommand */
static int hf_rrc_measurementReportingMode = -1;  /* MeasurementReportingMode */
static int hf_rrc_additionalMeasurementList = -1;  /* AdditionalMeasurementID_List */
static int hf_rrc_dpch_CompressedModeStatusInfo = -1;  /* DPCH_CompressedModeStatusInfo */
static int hf_rrc_ue_Positioning_Measurement_v390ext = -1;  /* UE_Positioning_Measurement_v390ext */
static int hf_rrc_measurementCommand_01 = -1;     /* MeasurementCommand_r4 */
static int hf_rrc_measurementCommand_v590ext = -1;  /* T_measurementCommand_v590ext */
static int hf_rrc_intra_frequency = -1;           /* Intra_FreqEventCriteriaList_v590ext */
static int hf_rrc_inter_frequency = -1;           /* Inter_FreqEventCriteriaList_v590ext */
static int hf_rrc_intraFreqReportingCriteria_1b_r5 = -1;  /* IntraFreqReportingCriteria_1b_r5 */
static int hf_rrc_intraFreqEvent_1d_r5 = -1;      /* IntraFreqEvent_1d_r5 */
static int hf_rrc_rrc_TransactionIdentifier_MSP_v590ext = -1;  /* RRC_TransactionIdentifier */
static int hf_rrc_interRATCellInfoIndication = -1;  /* InterRATCellInfoIndication */
static int hf_rrc_measurementCommand_02 = -1;     /* MeasurementCommand_r6 */
static int hf_rrc_measurementCommand_03 = -1;     /* MeasurementCommand_r7 */
static int hf_rrc_newInterFreqCellList = -1;      /* NewInterFreqCellList_v7b0ext */
static int hf_rrc_measurementCommand_04 = -1;     /* MeasurementCommand_r8 */
static int hf_rrc_newIntraFreqCellList = -1;      /* NewIntraFreqCellList_LCR_v8a0ext */
static int hf_rrc_newInterFreqCellList_01 = -1;   /* NewInterFreqCellList_LCR_v8a0ext */
static int hf_rrc_measurementCommand_05 = -1;     /* MeasurementCommand_r9 */
static int hf_rrc_measurementIdentity_01 = -1;    /* MeasurementIdentity_r9 */
static int hf_rrc_additionalMeasurementList_01 = -1;  /* AdditionalMeasurementID_List_r9 */
static int hf_rrc_measurementCommand_06 = -1;     /* MeasurementCommand_r10 */
static int hf_rrc_dpch_CompressedModeStatusInfo_01 = -1;  /* DPCH_CompressedModeStatusInfo_r10 */
static int hf_rrc_periodicalReportingCriteriaOnSecULFreq = -1;  /* PeriodicalWithReportingCellStatusOnSecULFreq */
static int hf_rrc_measurementCommand_07 = -1;     /* MeasurementCommand_r11 */
static int hf_rrc_interRATMeasurement = -1;       /* InterRATMeasurement_r11 */
static int hf_rrc_laterNonCriticalExtensions_19 = -1;  /* T_laterNonCriticalExtensions_19 */
static int hf_rrc_measurementControlFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_10 = -1;  /* T_v590NonCriticalExtensions_10 */
static int hf_rrc_measurementControlFailure_v590ext = -1;  /* MeasurementControlFailure_v590ext_IEs */
static int hf_rrc_nonCriticalExtensions_66 = -1;  /* T_nonCriticalExtensions_66 */
static int hf_rrc_measuredResults = -1;           /* MeasuredResults */
static int hf_rrc_additionalMeasuredResults = -1;  /* MeasuredResultsList */
static int hf_rrc_eventResults = -1;              /* EventResults */
static int hf_rrc_v390nonCriticalExtensions_01 = -1;  /* T_v390nonCriticalExtensions_01 */
static int hf_rrc_measurementReport_v390ext = -1;  /* MeasurementReport_v390ext */
static int hf_rrc_laterNonCriticalExtensions_20 = -1;  /* T_laterNonCriticalExtensions_20 */
static int hf_rrc_measurementReport_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_06 = -1;  /* T_v4b0NonCriticalExtensions_06 */
static int hf_rrc_measurementReport_v4b0ext = -1;  /* MeasurementReport_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_11 = -1;  /* T_v590NonCriticalExtensions_11 */
static int hf_rrc_measurementReport_v590ext = -1;  /* MeasurementReport_v590ext_IEs */
static int hf_rrc_v5b0NonCriticalExtensions_02 = -1;  /* T_v5b0NonCriticalExtensions_02 */
static int hf_rrc_measurementReport_v5b0ext = -1;  /* MeasurementReport_v5b0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_11 = -1;  /* T_v690NonCriticalExtensions_11 */
static int hf_rrc_measurementReport_v690ext = -1;  /* MeasurementReport_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_03 = -1;  /* T_v770NonCriticalExtensions_03 */
static int hf_rrc_measurementReport_v770ext = -1;  /* MeasurementReport_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_08 = -1;  /* T_v860NonCriticalExtensions_08 */
static int hf_rrc_measurementReport_v860ext = -1;  /* MeasurementReport_v860ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_01 = -1;  /* T_v920NonCriticalExtensions_01 */
static int hf_rrc_measurementReport_v920ext = -1;  /* MeasurementReport_v920ext_IEs */
static int hf_rrc_v970NonCriticalExtensions_01 = -1;  /* T_v970NonCriticalExtensions_01 */
static int hf_rrc_measurementReport_v970ext_IE = -1;  /* MeasurementReport_v970ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_04 = -1;  /* T_va40NonCriticalExtensions_04 */
static int hf_rrc_measurementReport_va40ext = -1;  /* MeasurementReport_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_10 = -1;  /* T_vb50NonCriticalExtensions_10 */
static int hf_rrc_measurementReport_vb50ext = -1;  /* MeasurementReport_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_67 = -1;  /* T_nonCriticalExtensions_67 */
static int hf_rrc_measuredResults_v390ext = -1;   /* MeasuredResults_v390ext */
static int hf_rrc_interFreqEventResults_LCR = -1;  /* InterFreqEventResults_LCR_r4_ext */
static int hf_rrc_additionalMeasuredResults_LCR = -1;  /* MeasuredResultsList_LCR_r4_ext */
static int hf_rrc_dummy_14 = -1;                  /* PrimaryCPICH_Info */
static int hf_rrc_measuredResults_v590ext = -1;   /* MeasuredResults_v590ext */
static int hf_rrc_measuredResults_01 = -1;        /* MeasuredResults_v770ext */
static int hf_rrc_additionalMeasuredResults_01 = -1;  /* MeasuredResultsList_v770xet */
static int hf_rrc_eventResults_01 = -1;           /* EventResults_v770ext */
static int hf_rrc_ue_Positioning_OTDOA_MeasuredResults = -1;  /* UE_Positioning_OTDOA_MeasuredResultsTDD_ext */
static int hf_rrc_measuredResults_02 = -1;        /* MeasuredResults_v860ext */
static int hf_rrc_additionalMeasuredResults_02 = -1;  /* MeasuredResultsList_v860ext */
static int hf_rrc_eventResults_02 = -1;           /* EventResults_v860ext */
static int hf_rrc_eutra_MeasuredResults = -1;     /* EUTRA_MeasuredResults */
static int hf_rrc_eutra_EventResults = -1;        /* EUTRA_EventResults */
static int hf_rrc_cSGProximityIndication = -1;    /* CSGProximityIndication */
static int hf_rrc_measuredResults_03 = -1;        /* MeasuredResults_v920ext */
static int hf_rrc_measuredResultsOnSecUlFreq = -1;  /* MeasuredResultsOnSecUlFreq */
static int hf_rrc_additionalMeasuredResults_03 = -1;  /* MeasuredResultsList_v920ext */
static int hf_rrc_additionalMeasuredResultsOnSecUlFreq = -1;  /* MeasuredResultsListOnSecUlFreq */
static int hf_rrc_eventResultsOnSecUlFreq = -1;   /* EventResultsOnSecUlFreq */
static int hf_rrc_eutra_MeasuredResults_01 = -1;  /* EUTRA_MeasuredResults_v920ext */
static int hf_rrc_measurementIdentity_02 = -1;    /* MeasurementIdentityExt */
static int hf_rrc_eventResults_03 = -1;           /* EventResults_va40ext */
static int hf_rrc_loggedMeasAvailable_03 = -1;    /* T_loggedMeasAvailable_03 */
static int hf_rrc_loggedANRResultsAvailable_02 = -1;  /* T_loggedANRResultsAvailable_02 */
static int hf_rrc_eutra_EventResultsForCELLFACH = -1;  /* EUTRA_EventResultsForCELLFACH */
static int hf_rrc_cSGProximityIndication_01 = -1;  /* CSGProximityIndication_vb50ext */
static int hf_rrc_eutra_MeasuredResults_02 = -1;  /* EUTRA_MeasuredResults_vb50ext */
static int hf_rrc_eutra_EventResults_01 = -1;     /* EUTRA_EventResults_vb50ext */
static int hf_rrc_pagingRecordList = -1;          /* PagingRecordList */
static int hf_rrc_bcch_ModificationInfo = -1;     /* BCCH_ModificationInfo */
static int hf_rrc_laterNonCriticalExtensions_21 = -1;  /* T_laterNonCriticalExtensions_21 */
static int hf_rrc_pagingType1_r3_add_ext = -1;    /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_12 = -1;  /* T_v590NonCriticalExtensions_12 */
static int hf_rrc_pagingType1_v590ext = -1;       /* PagingType1_v590ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_09 = -1;  /* T_v860NonCriticalExtensions_09 */
static int hf_rrc_pagingType1_v860ext = -1;       /* PagingType1_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_68 = -1;  /* T_nonCriticalExtensions_68 */
static int hf_rrc_pagingRecord2List = -1;         /* PagingRecord2List_r5 */
static int hf_rrc_pagingCause = -1;               /* PagingCause */
static int hf_rrc_pagingRecordTypeID = -1;        /* PagingRecordTypeID */
static int hf_rrc_laterNonCriticalExtensions_22 = -1;  /* T_laterNonCriticalExtensions_22 */
static int hf_rrc_pagingType2_r3_add_ext = -1;    /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_69 = -1;  /* T_nonCriticalExtensions_69 */
static int hf_rrc_r3_12 = -1;                     /* T_r3_12 */
static int hf_rrc_physicalChannelReconfiguration_r3 = -1;  /* PhysicalChannelReconfiguration_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_05 = -1;  /* T_v3a0NonCriticalExtensions_05 */
static int hf_rrc_physicalChannelReconfiguration_v3a0ext = -1;  /* PhysicalChannelReconfiguration_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_23 = -1;  /* T_laterNonCriticalExtensions_23 */
static int hf_rrc_physicalChannelReconfiguration_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtenstions = -1;  /* T_v4b0NonCriticalExtenstions */
static int hf_rrc_physicalChannelReconfiguration_v4b0ext = -1;  /* PhysicalChannelReconfiguration_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtenstions_02 = -1;  /* T_v590NonCriticalExtenstions_02 */
static int hf_rrc_physicalChannelReconfiguration_v590ext = -1;  /* PhysicalChannelReconfiguration_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_12 = -1;  /* T_v690NonCriticalExtensions_12 */
static int hf_rrc_physicalChannelReconfiguration_v690ext = -1;  /* PhysicalChannelReconfiguration_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_04 = -1;  /* T_v770NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v770ext = -1;  /* PhysicalChannelReconfiguration_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_70 = -1;  /* T_nonCriticalExtensions_70 */
static int hf_rrc_later_than_r3_10 = -1;          /* T_later_than_r3_10 */
static int hf_rrc_criticalExtensions_54 = -1;     /* T_criticalExtensions_53 */
static int hf_rrc_r4_04 = -1;                     /* T_r4_04 */
static int hf_rrc_physicalChannelReconfiguration_r4 = -1;  /* PhysicalChannelReconfiguration_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_04 = -1;  /* T_v4d0NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtenstions_03 = -1;  /* T_v590NonCriticalExtenstions_03 */
static int hf_rrc_v690NonCriticalExtensions_13 = -1;  /* T_v690NonCriticalExtensions_13 */
static int hf_rrc_v770NonCriticalExtensions_05 = -1;  /* T_v770NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_71 = -1;  /* T_nonCriticalExtensions_71 */
static int hf_rrc_criticalExtensions_55 = -1;     /* T_criticalExtensions_54 */
static int hf_rrc_r5_04 = -1;                     /* T_r5_04 */
static int hf_rrc_physicalChannelReconfiguration_r5 = -1;  /* PhysicalChannelReconfiguration_r5_IEs */
static int hf_rrc_physicalChannelReconfiguration_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_14 = -1;  /* T_v690NonCriticalExtensions_14 */
static int hf_rrc_v770NonCriticalExtensions_06 = -1;  /* T_v770NonCriticalExtensions_06 */
static int hf_rrc_nonCriticalExtensions_72 = -1;  /* T_nonCriticalExtensions_72 */
static int hf_rrc_criticalExtensions_56 = -1;     /* T_criticalExtensions_55 */
static int hf_rrc_r6_06 = -1;                     /* T_r6_06 */
static int hf_rrc_physicalChannelReconfiguration_r6 = -1;  /* PhysicalChannelReconfiguration_r6_IEs */
static int hf_rrc_physicalChannelReconfiguration_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_06 = -1;  /* T_v6b0NonCriticalExtensions_05 */
static int hf_rrc_physicalChannelReconfiguration_v6b0ext = -1;  /* PhysicalChannelReconfiguration_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_07 = -1;  /* T_v770NonCriticalExtensions_07 */
static int hf_rrc_nonCriticalExtensions_73 = -1;  /* T_nonCriticalExtensions_73 */
static int hf_rrc_criticalExtensions_57 = -1;     /* T_criticalExtensions_56 */
static int hf_rrc_r7_05 = -1;                     /* T_r7_05 */
static int hf_rrc_physicalChannelReconfiguration_r7 = -1;  /* PhysicalChannelReconfiguration_r7_IEs */
static int hf_rrc_physicalChannelReconfiguration_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_04 = -1;  /* T_v780NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v780ext = -1;  /* PhysicalChannelReconfiguration_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_04 = -1;  /* T_v7d0NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v7d0ext = -1;  /* PhysicalChannelReconfiguration_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_05 = -1;  /* T_v7f0NonCriticalExtensions_05 */
static int hf_rrc_physicalChannelReconfiguration_v7f0ext = -1;  /* PhysicalChannelReconfiguration_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_06 = -1;  /* T_v7g0NonCriticalExtensions_06 */
static int hf_rrc_physicalChannelReconfiguration_v7g0ext = -1;  /* PhysicalChannelReconfiguration_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_74 = -1;  /* T_nonCriticalExtensions_74 */
static int hf_rrc_criticalExtensions_58 = -1;     /* T_criticalExtensions_57 */
static int hf_rrc_r8_06 = -1;                     /* T_r8_06 */
static int hf_rrc_physicalChannelReconfiguration_r8 = -1;  /* PhysicalChannelReconfiguration_r8_IEs */
static int hf_rrc_physicalChannelReconfiguration_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_05 = -1;  /* T_v7d0NonCriticalExtensions_05 */
static int hf_rrc_v7f0NonCriticalExtensions_06 = -1;  /* T_v7f0NonCriticalExtensions_06 */
static int hf_rrc_v890NonCriticalExtensions_04 = -1;  /* T_v890NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v890ext = -1;  /* PhysicalChannelReconfiguration_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_07 = -1;  /* T_v7g0NonCriticalExtensions_07 */
static int hf_rrc_v8a0NonCriticalExtensions_04 = -1;  /* T_v8a0NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v8a0ext = -1;  /* PhysicalChannelReconfiguration_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_75 = -1;  /* T_nonCriticalExtensions_75 */
static int hf_rrc_criticalExtensions_59 = -1;     /* T_criticalExtensions_58 */
static int hf_rrc_r9_05 = -1;                     /* T_r9_05 */
static int hf_rrc_physicalChannelReconfiguration_r9 = -1;  /* PhysicalChannelReconfiguration_r9_IEs */
static int hf_rrc_physicalChannelReconfiguration_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_03 = -1;  /* T_v950NonCriticalExtensions_03 */
static int hf_rrc_physicalChannelReconfiguration_v950ext = -1;  /* PhysicalChannelReconfiguration_v950ext_IEs */
static int hf_rrc_nonCriticalExtensions_76 = -1;  /* T_nonCriticalExtensions_76 */
static int hf_rrc_criticalExtensions_60 = -1;     /* T_criticalExtensions_59 */
static int hf_rrc_r10_05 = -1;                    /* T_r10_05 */
static int hf_rrc_physicalChannelReconfiguration_r10 = -1;  /* PhysicalChannelReconfiguration_r10_IEs */
static int hf_rrc_physicalChannelReconfiguration_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_vb50NonCriticalExtensions_11 = -1;  /* T_vb50NonCriticalExtensions_11 */
static int hf_rrc_physicalChannelReconfiguration_vb50ext = -1;  /* PhysicalChannelReconfiguration_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_77 = -1;  /* T_nonCriticalExtensions_77 */
static int hf_rrc_criticalExtensions_61 = -1;     /* T_criticalExtensions_60 */
static int hf_rrc_r11_06 = -1;                    /* T_r11_06 */
static int hf_rrc_physicalChannelReconfiguration_r11 = -1;  /* PhysicalChannelReconfiguration_r11_IEs */
static int hf_rrc_physicalChannelReconfiguration_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_78 = -1;  /* T_nonCriticalExtensions_78 */
static int hf_rrc_criticalExtensions_62 = -1;     /* T_criticalExtensions_61 */
static int hf_rrc_ul_ChannelRequirement_03 = -1;  /* UL_ChannelRequirementWithCPCH_SetID */
static int hf_rrc_modeSpecificInfo_12 = -1;       /* T_modeSpecificInfo_12 */
static int hf_rrc_fdd_18 = -1;                    /* T_fdd_18 */
static int hf_rrc_ul_ChannelRequirement_04 = -1;  /* UL_ChannelRequirementWithCPCH_SetID_r4 */
static int hf_rrc_modeSpecificInfo_13 = -1;       /* T_modeSpecificInfo_13 */
static int hf_rrc_fdd_19 = -1;                    /* T_fdd_19 */
static int hf_rrc_ul_ChannelRequirement_05 = -1;  /* UL_ChannelRequirementWithCPCH_SetID_r5 */
static int hf_rrc_modeSpecificInfo_14 = -1;       /* T_modeSpecificInfo_14 */
static int hf_rrc_fdd_20 = -1;                    /* T_fdd_20 */
static int hf_rrc_delayRestrictionFlag = -1;      /* DelayRestrictionFlag */
static int hf_rrc_postVerificationPeriod_01 = -1;  /* T_postVerificationPeriod_01 */
static int hf_rrc_timingMaintainedSynchInd = -1;  /* TimingMaintainedSynchInd */
static int hf_rrc_responseToChangeOfUE_Capability = -1;  /* T_responseToChangeOfUE_Capability */
static int hf_rrc_harqInfo = -1;                  /* HARQ_Info_r7 */
static int hf_rrc_responseToChangeOfUE_Capability_01 = -1;  /* T_responseToChangeOfUE_Capability_01 */
static int hf_rrc_responseToChangeOfUE_Capability_02 = -1;  /* T_responseToChangeOfUE_Capability_02 */
static int hf_rrc_responseToChangeOfUE_Capability_03 = -1;  /* T_responseToChangeOfUE_Capability_03 */
static int hf_rrc_responseToChangeOfUE_Capability_04 = -1;  /* T_responseToChangeOfUE_Capability_04 */
static int hf_rrc_harqInfo_01 = -1;               /* HARQ_Info_r11 */
static int hf_rrc_ul_IntegProtActivationInfo = -1;  /* IntegrityProtActivationInfo */
static int hf_rrc_ul_TimingAdvance = -1;          /* UL_TimingAdvance */
static int hf_rrc_dummy_15 = -1;                  /* RB_ActivationTimeInfoList */
static int hf_rrc_ul_CounterSynchronisationInfo = -1;  /* UL_CounterSynchronisationInfo */
static int hf_rrc_laterNonCriticalExtensions_24 = -1;  /* T_laterNonCriticalExtensions_24 */
static int hf_rrc_physicalChannelReconfigurationComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_08 = -1;  /* T_v770NonCriticalExtensions_08 */
static int hf_rrc_physicalChannelReconfigurationComplete_v770ext = -1;  /* PhysicalChannelReconfigurationComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_79 = -1;  /* T_nonCriticalExtensions_79 */
static int hf_rrc_ext_UL_TimingAdvance = -1;      /* EXT_UL_TimingAdvance */
static int hf_rrc_deferredMeasurementControlReading = -1;  /* T_deferredMeasurementControlReading */
static int hf_rrc_laterNonCriticalExtensions_25 = -1;  /* T_laterNonCriticalExtensions_25 */
static int hf_rrc_physicalChannelReconfigurationFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_80 = -1;  /* T_nonCriticalExtensions_80 */
static int hf_rrc_r3_13 = -1;                     /* T_r3_13 */
static int hf_rrc_physicalSharedChannelAllocation_r3 = -1;  /* PhysicalSharedChannelAllocation_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_26 = -1;  /* T_laterNonCriticalExtensions_26 */
static int hf_rrc_physicalSharedChannelAllocation_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_81 = -1;  /* T_nonCriticalExtensions_81 */
static int hf_rrc_later_than_r3_11 = -1;          /* T_later_than_r3_11 */
static int hf_rrc_dsch_RNTI = -1;                 /* DSCH_RNTI */
static int hf_rrc_criticalExtensions_63 = -1;     /* T_criticalExtensions_62 */
static int hf_rrc_r4_05 = -1;                     /* T_r4_05 */
static int hf_rrc_physicalSharedChannelAllocation_r4 = -1;  /* PhysicalSharedChannelAllocation_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_05 = -1;  /* T_v4d0NonCriticalExtensions_05 */
static int hf_rrc_physicalSharedChannelAllocation_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_15 = -1;  /* T_v690NonCriticalExtensions_15 */
static int hf_rrc_physicalSharedChannelAllocation_v690ext = -1;  /* PhysicalSharedChannelAllocation_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_09 = -1;  /* T_v770NonCriticalExtensions_09 */
static int hf_rrc_physicalSharedChannelAllocation_v770ext = -1;  /* PhysicalSharedChannelAllocation_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_82 = -1;  /* T_nonCriticalExtensions_82 */
static int hf_rrc_criticalExtensions_64 = -1;     /* T_criticalExtensions_63 */
static int hf_rrc_ul_TimingAdvance_01 = -1;       /* UL_TimingAdvanceControl */
static int hf_rrc_pusch_CapacityAllocationInfo = -1;  /* PUSCH_CapacityAllocationInfo */
static int hf_rrc_pdsch_CapacityAllocationInfo = -1;  /* PDSCH_CapacityAllocationInfo */
static int hf_rrc_confirmRequest = -1;            /* T_confirmRequest */
static int hf_rrc_trafficVolumeReportRequest = -1;  /* INTEGER_0_255 */
static int hf_rrc_iscpTimeslotList = -1;          /* TimeslotList */
static int hf_rrc_requestPCCPCHRSCP = -1;         /* BOOLEAN */
static int hf_rrc_ul_TimingAdvance_02 = -1;       /* UL_TimingAdvanceControl_r4 */
static int hf_rrc_pusch_CapacityAllocationInfo_01 = -1;  /* PUSCH_CapacityAllocationInfo_r4 */
static int hf_rrc_pdsch_CapacityAllocationInfo_01 = -1;  /* PDSCH_CapacityAllocationInfo_r4 */
static int hf_rrc_confirmRequest_01 = -1;         /* T_confirmRequest_01 */
static int hf_rrc_iscpTimeslotList_01 = -1;       /* TimeslotList_r4 */
static int hf_rrc_ul_TimingAdvance_03 = -1;       /* UL_TimingAdvanceControl_r7 */
static int hf_rrc_pusch_CapacityAllocationInfo_02 = -1;  /* PUSCH_CapacityAllocationInfo_r7 */
static int hf_rrc_pdsch_CapacityAllocationInfo_02 = -1;  /* PDSCH_CapacityAllocationInfo_r7 */
static int hf_rrc_trafficVolume = -1;             /* TrafficVolumeMeasuredResultsList */
static int hf_rrc_timeslotListWithISCP = -1;      /* TimeslotListWithISCP */
static int hf_rrc_primaryCCPCH_RSCP = -1;         /* PrimaryCCPCH_RSCP */
static int hf_rrc_allocationConfirmation = -1;    /* T_allocationConfirmation */
static int hf_rrc_pdschConfirmation = -1;         /* PDSCH_Identity */
static int hf_rrc_puschConfirmation = -1;         /* PUSCH_Identity */
static int hf_rrc_protocolErrorIndicator = -1;    /* ProtocolErrorIndicatorWithMoreInfo */
static int hf_rrc_laterNonCriticalExtensions_27 = -1;  /* T_laterNonCriticalExtensions_27 */
static int hf_rrc_puschCapacityRequest_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_13 = -1;  /* T_v590NonCriticalExtensions_13 */
static int hf_rrc_puschCapacityRequest_v590ext = -1;  /* PUSCHCapacityRequest_v590ext */
static int hf_rrc_nonCriticalExtensions_83 = -1;  /* T_nonCriticalExtensions_83 */
static int hf_rrc_primaryCCPCH_RSCP_delta = -1;   /* DeltaRSCP */
static int hf_rrc_r3_14 = -1;                     /* T_r3_14 */
static int hf_rrc_radioBearerReconfiguration_r3 = -1;  /* RadioBearerReconfiguration_r3_IEs */
static int hf_rrc_v3aoNonCriticalExtensions = -1;  /* T_v3aoNonCriticalExtensions */
static int hf_rrc_radioBearerReconfiguration_v3a0ext = -1;  /* RadioBearerReconfiguration_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_28 = -1;  /* T_laterNonCriticalExtensions_28 */
static int hf_rrc_radioBearerReconfiguration_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_07 = -1;  /* T_v4b0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerReconfiguration_v4b0ext = -1;  /* RadioBearerReconfiguration_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_14 = -1;  /* T_v590NonCriticalExtensions_14 */
static int hf_rrc_radioBearerReconfiguration_v590ext = -1;  /* RadioBearerReconfiguration_v590ext_IEs */
static int hf_rrc_v5d0NonCriticalExtenstions_06 = -1;  /* T_v5d0NonCriticalExtenstions_06 */
static int hf_rrc_radioBearerReconfiguration_v5d0ext = -1;  /* RadioBearerReconfiguration_v5d0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_16 = -1;  /* T_v690NonCriticalExtensions_16 */
static int hf_rrc_radioBearerReconfiguration_v690ext = -1;  /* RadioBearerReconfiguration_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_10 = -1;  /* T_v770NonCriticalExtensions_10 */
static int hf_rrc_radioBearerReconfiguration_v770ext = -1;  /* RadioBearerReconfiguration_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_84 = -1;  /* T_nonCriticalExtensions_84 */
static int hf_rrc_later_than_r3_12 = -1;          /* T_later_than_r3_12 */
static int hf_rrc_criticalExtensions_65 = -1;     /* T_criticalExtensions_64 */
static int hf_rrc_r4_06 = -1;                     /* T_r4_06 */
static int hf_rrc_radioBearerReconfiguration_r4 = -1;  /* RadioBearerReconfiguration_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_06 = -1;  /* T_v4d0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerReconfiguration_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_15 = -1;  /* T_v590NonCriticalExtensions_15 */
static int hf_rrc_v5d0NonCriticalExtenstions_07 = -1;  /* T_v5d0NonCriticalExtenstions_07 */
static int hf_rrc_v690NonCriticalExtensions_17 = -1;  /* T_v690NonCriticalExtensions_17 */
static int hf_rrc_v770NonCriticalExtensions_11 = -1;  /* T_v770NonCriticalExtensions_11 */
static int hf_rrc_nonCriticalExtensions_85 = -1;  /* T_nonCriticalExtensions_85 */
static int hf_rrc_criticalExtensions_66 = -1;     /* T_criticalExtensions_65 */
static int hf_rrc_r5_05 = -1;                     /* T_r5_05 */
static int hf_rrc_radioBearerReconfiguration_r5 = -1;  /* RadioBearerReconfiguration_r5_IEs */
static int hf_rrc_radioBearerReconfiguration_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_08 = -1;  /* T_v5d0NonCriticalExtenstions_08 */
static int hf_rrc_v690NonCriticalExtensions_18 = -1;  /* T_v690NonCriticalExtensions_18 */
static int hf_rrc_v770NonCriticalExtensions_12 = -1;  /* T_v770NonCriticalExtensions_12 */
static int hf_rrc_nonCriticalExtensions_86 = -1;  /* T_nonCriticalExtensions_86 */
static int hf_rrc_criticalExtensions_67 = -1;     /* T_criticalExtensions_66 */
static int hf_rrc_r6_07 = -1;                     /* T_r6_07 */
static int hf_rrc_radioBearerReconfiguration_r6 = -1;  /* RadioBearerReconfiguration_r6_IEs */
static int hf_rrc_radioBearerReconfiguration_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_07 = -1;  /* T_v6b0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerReconfiguration_v6b0ext = -1;  /* RadioBearerReconfiguration_v6b0ext_IEs */
static int hf_rrc_v6f0NonCriticalExtensions = -1;  /* T_v6f0NonCriticalExtensions */
static int hf_rrc_radioBearerRconfiguration_v6f0ext = -1;  /* RadioBearerReconfiguration_v6f0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_13 = -1;  /* T_v770NonCriticalExtensions_13 */
static int hf_rrc_nonCriticalExtensions_87 = -1;  /* T_nonCriticalExtensions_87 */
static int hf_rrc_criticalExtensions_68 = -1;     /* T_criticalExtensions_67 */
static int hf_rrc_r7_06 = -1;                     /* T_r7_06 */
static int hf_rrc_radioBearerReconfiguration_r7 = -1;  /* RadioBearerReconfiguration_r7_IEs */
static int hf_rrc_v780NonCriticalExtensions_05 = -1;  /* T_v780NonCriticalExtensions_05 */
static int hf_rrc_radioBearerReconfiguration_v780ext = -1;  /* RadioBearerReconfiguration_v780ext_IEs */
static int hf_rrc_v790NonCriticalExtensions = -1;  /* T_v790NonCriticalExtensions */
static int hf_rrc_radioBearerReconfiguration_v790ext = -1;  /* RadioBearerReconfiguration_v790ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_06 = -1;  /* T_v7d0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerReconfiguration_v7d0ext = -1;  /* RadioBearerReconfiguration_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_07 = -1;  /* T_v7f0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerReconfiguration_v7f0ext = -1;  /* RadioBearerReconfiguration_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_08 = -1;  /* T_v7g0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerReconfiguration_v7g0ext = -1;  /* RadioBearerReconfiguration_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_88 = -1;  /* T_nonCriticalExtensions_88 */
static int hf_rrc_criticalExtensions_69 = -1;     /* T_criticalExtensions_68 */
static int hf_rrc_r8_07 = -1;                     /* T_r8_07 */
static int hf_rrc_radioBearerReconfiguration_r8 = -1;  /* RadioBearerReconfiguration_r8_IEs */
static int hf_rrc_radioBearerReconfiguration_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_07 = -1;  /* T_v7d0NonCriticalExtensions_07 */
static int hf_rrc_v7f0NonCriticalExtensions_08 = -1;  /* T_v7f0NonCriticalExtensions_08 */
static int hf_rrc_v890NonCriticalExtensions_05 = -1;  /* T_v890NonCriticalExtensions_05 */
static int hf_rrc_radioBearerReconfiguration_v890ext = -1;  /* RadioBearerReconfiguration_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_09 = -1;  /* T_v7g0NonCriticalExtensions_09 */
static int hf_rrc_v8a0NonCriticalExtensions_05 = -1;  /* T_v8a0NonCriticalExtensions_05 */
static int hf_rrc_radioBearerReconfiguration_v8a0ext = -1;  /* RadioBearerReconfiguration_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_89 = -1;  /* T_nonCriticalExtensions_89 */
static int hf_rrc_criticalExtensions_70 = -1;     /* T_criticalExtensions_69 */
static int hf_rrc_r9_06 = -1;                     /* T_r9_06 */
static int hf_rrc_radioBearerReconfiguration_r9 = -1;  /* RadioBearerReconfiguration_r9_IEs */
static int hf_rrc_radioBearerReconfiguration_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_04 = -1;  /* T_v950NonCriticalExtensions_04 */
static int hf_rrc_radioBearerReconfiguration_v950ext = -1;  /* RadioBearerReconfiguration_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_04 = -1;  /* T_v9c0NonCriticalExtensions_04 */
static int hf_rrc_radioBearerReconfiguration_v9c0ext = -1;  /* RadioBearerReconfiguration_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_90 = -1;  /* T_nonCriticalExtensions_90 */
static int hf_rrc_criticalExtensions_71 = -1;     /* T_criticalExtensions_70 */
static int hf_rrc_r10_06 = -1;                    /* T_r10_06 */
static int hf_rrc_radioBearerReconfiguration_r10 = -1;  /* RadioBearerReconfiguration_r10_IEs */
static int hf_rrc_radioBearerReconfiguration_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_05 = -1;  /* T_v9c0NonCriticalExtensions_05 */
static int hf_rrc_vaa0NonCriticalExtensions_01 = -1;  /* T_vaa0NonCriticalExtensions_01 */
static int hf_rrc_radioBearerReconfiguration_vaa0ext = -1;  /* RadioBearerReconfiguration_vaa0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_12 = -1;  /* T_vb50NonCriticalExtensions_12 */
static int hf_rrc_radioBearerReconfiguration_vb50ext = -1;  /* RadioBearerReconfiguration_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_91 = -1;  /* T_nonCriticalExtensions_91 */
static int hf_rrc_criticalExtensions_72 = -1;     /* T_criticalExtensions_71 */
static int hf_rrc_r11_07 = -1;                    /* T_r11_07 */
static int hf_rrc_radioBearerReconfiguration_r11 = -1;  /* RadioBearerReconfiguration_r11_IEs */
static int hf_rrc_radioBearerReconfiguration_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_92 = -1;  /* T_nonCriticalExtensions_92 */
static int hf_rrc_criticalExtensions_73 = -1;     /* T_criticalExtensions_72 */
static int hf_rrc_um_RLC_ReEstablishmentRBList = -1;  /* RB_IdentityList */
static int hf_rrc_rab_InformationReconfigList = -1;  /* RAB_InformationReconfigList */
static int hf_rrc_dummy_16 = -1;                  /* T_dummy_01 */
static int hf_rrc_fdd_21 = -1;                    /* T_fdd_21 */
static int hf_rrc_dummy1 = -1;                    /* CPCH_SetID */
static int hf_rrc_dl_AddReconfTransChInfoList_07 = -1;  /* DL_AddReconfTransChInfo2List */
static int hf_rrc_modeSpecificPhysChInfo_03 = -1;  /* T_modeSpecificPhysChInfo_03 */
static int hf_rrc_fdd_22 = -1;                    /* T_fdd_22 */
static int hf_rrc_dummy_17 = -1;                  /* T_dummy_02 */
static int hf_rrc_fdd_23 = -1;                    /* T_fdd_23 */
static int hf_rrc_modeSpecificPhysChInfo_04 = -1;  /* T_modeSpecificPhysChInfo_04 */
static int hf_rrc_fdd_24 = -1;                    /* T_fdd_24 */
static int hf_rrc_specificationMode_09 = -1;      /* T_specificationMode_09 */
static int hf_rrc_complete_09 = -1;               /* T_complete_09 */
static int hf_rrc_rb_PDCPContextRelocationList = -1;  /* RB_PDCPContextRelocationList */
static int hf_rrc_dummy_18 = -1;                  /* T_dummy_03 */
static int hf_rrc_fdd_25 = -1;                    /* T_fdd_25 */
static int hf_rrc_preconfiguration_09 = -1;       /* T_preconfiguration_09 */
static int hf_rrc_preConfigMode_09 = -1;          /* T_preConfigMode_09 */
static int hf_rrc_defaultConfig_09 = -1;          /* T_defaultConfig_09 */
static int hf_rrc_modeSpecificPhysChInfo_05 = -1;  /* T_modeSpecificPhysChInfo_05 */
static int hf_rrc_fdd_26 = -1;                    /* T_fdd_26 */
static int hf_rrc_specificationMode_10 = -1;      /* T_specificationMode_10 */
static int hf_rrc_complete_10 = -1;               /* T_complete_10 */
static int hf_rrc_preconfiguration_10 = -1;       /* T_preconfiguration_10 */
static int hf_rrc_preConfigMode_10 = -1;          /* T_preConfigMode_10 */
static int hf_rrc_defaultConfig_10 = -1;          /* T_defaultConfig_10 */
static int hf_rrc_postVerificationPeriod_02 = -1;  /* T_postVerificationPeriod_02 */
static int hf_rrc_specificationMode_11 = -1;      /* T_specificationMode_11 */
static int hf_rrc_complete_11 = -1;               /* T_complete_11 */
static int hf_rrc_rab_InformationMBMSPtpList = -1;  /* RAB_InformationMBMSPtpList */
static int hf_rrc_responseToChangeOfUE_Capability_05 = -1;  /* T_responseToChangeOfUE_Capability_05 */
static int hf_rrc_specificationMode_12 = -1;      /* T_specificationMode_12 */
static int hf_rrc_complete_12 = -1;               /* T_complete_12 */
static int hf_rrc_preconfiguration_11 = -1;       /* T_preconfiguration_11 */
static int hf_rrc_preConfigMode_11 = -1;          /* T_preConfigMode_11 */
static int hf_rrc_defaultConfig_11 = -1;          /* T_defaultConfig_11 */
static int hf_rrc_radioBearerReconfiguration_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_responseToChangeOfUE_Capability_06 = -1;  /* T_responseToChangeOfUE_Capability_06 */
static int hf_rrc_specificationMode_13 = -1;      /* T_specificationMode_13 */
static int hf_rrc_complete_13 = -1;               /* T_complete_13 */
static int hf_rrc_rab_InformationReconfigList_01 = -1;  /* RAB_InformationReconfigList_r8 */
static int hf_rrc_preconfiguration_12 = -1;       /* T_preconfiguration_12 */
static int hf_rrc_preConfigMode_12 = -1;          /* T_preConfigMode_12 */
static int hf_rrc_defaultConfig_12 = -1;          /* T_defaultConfig_12 */
static int hf_rrc_responseToChangeOfUE_Capability_07 = -1;  /* T_responseToChangeOfUE_Capability_07 */
static int hf_rrc_specificationMode_14 = -1;      /* T_specificationMode_14 */
static int hf_rrc_complete_14 = -1;               /* T_complete_14 */
static int hf_rrc_preconfiguration_13 = -1;       /* T_preconfiguration_13 */
static int hf_rrc_preConfigMode_13 = -1;          /* T_preConfigMode_13 */
static int hf_rrc_defaultConfig_13 = -1;          /* T_defaultConfig_13 */
static int hf_rrc_responseToChangeOfUE_Capability_08 = -1;  /* T_responseToChangeOfUE_Capability_08 */
static int hf_rrc_specificationMode_15 = -1;      /* T_specificationMode_15 */
static int hf_rrc_complete_15 = -1;               /* T_complete_15 */
static int hf_rrc_preconfiguration_14 = -1;       /* T_preconfiguration_14 */
static int hf_rrc_preConfigMode_14 = -1;          /* T_preConfigMode_14 */
static int hf_rrc_defaultConfig_14 = -1;          /* T_defaultConfig_14 */
static int hf_rrc_responseToChangeOfUE_Capability_09 = -1;  /* T_responseToChangeOfUE_Capability_09 */
static int hf_rrc_specificationMode_16 = -1;      /* T_specificationMode_16 */
static int hf_rrc_complete_16 = -1;               /* T_complete_16 */
static int hf_rrc_umRlc_ReEstablishmentRBList = -1;  /* RB_IdentityList */
static int hf_rrc_preconfiguration_15 = -1;       /* T_preconfiguration_15 */
static int hf_rrc_preConfigMode_15 = -1;          /* T_preConfigMode_15 */
static int hf_rrc_defaultConfig_15 = -1;          /* T_defaultConfig_15 */
static int hf_rrc_laterNonCriticalExtensions_29 = -1;  /* T_laterNonCriticalExtensions_29 */
static int hf_rrc_radioBearerReconfigurationComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_14 = -1;  /* T_v770NonCriticalExtensions_14 */
static int hf_rrc_radioBearerReconfigurationComplete_v770ext = -1;  /* RadioBearerReconfigurationComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_93 = -1;  /* T_nonCriticalExtensions_93 */
static int hf_rrc_deferredMeasurementControlReading_01 = -1;  /* T_deferredMeasurementControlReading_01 */
static int hf_rrc_potentiallySuccesfulBearerList = -1;  /* RB_IdentityList */
static int hf_rrc_laterNonCriticalExtensions_30 = -1;  /* T_laterNonCriticalExtensions_30 */
static int hf_rrc_radioBearerReconfigurationFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_94 = -1;  /* T_nonCriticalExtensions_94 */
static int hf_rrc_r3_15 = -1;                     /* T_r3_15 */
static int hf_rrc_radioBearerRelease_r3 = -1;     /* RadioBearerRelease_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_06 = -1;  /* T_v3a0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v3a0ext = -1;  /* RadioBearerRelease_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_31 = -1;  /* T_laterNonCriticalExtensions_31 */
static int hf_rrc_radioBearerRelease_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_08 = -1;  /* T_v4b0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerRelease_v4b0ext = -1;  /* RadioBearerRelease_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_16 = -1;  /* T_v590NonCriticalExtensions_16 */
static int hf_rrc_radioBearerRelease_v590ext = -1;  /* RadioBearerRelease_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_19 = -1;  /* T_v690NonCriticalExtensions_19 */
static int hf_rrc_radioBearerRelease_v690ext = -1;  /* RadioBearerRelease_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_15 = -1;  /* T_v770NonCriticalExtensions_15 */
static int hf_rrc_radioBearerRelease_v770ext = -1;  /* RadioBearerRelease_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_95 = -1;  /* T_nonCriticalExtensions_95 */
static int hf_rrc_later_than_r3_13 = -1;          /* T_later_than_r3_13 */
static int hf_rrc_criticalExtensions_74 = -1;     /* T_criticalExtensions_73 */
static int hf_rrc_r4_07 = -1;                     /* T_r4_07 */
static int hf_rrc_radioBearerRelease_r4 = -1;     /* RadioBearerRelease_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_07 = -1;  /* T_v4d0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerRelease_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_17 = -1;  /* T_v590NonCriticalExtensions_17 */
static int hf_rrc_v690NonCriticalExtensions_20 = -1;  /* T_v690NonCriticalExtensions_20 */
static int hf_rrc_v770NonCriticalExtensions_16 = -1;  /* T_v770NonCriticalExtensions_16 */
static int hf_rrc_nonCriticalExtensions_96 = -1;  /* T_nonCriticalExtensions_96 */
static int hf_rrc_criticalExtensions_75 = -1;     /* T_criticalExtensions_74 */
static int hf_rrc_r5_06 = -1;                     /* T_r5_06 */
static int hf_rrc_radioBearerRelease_r5 = -1;     /* RadioBearerRelease_r5_IEs */
static int hf_rrc_radioBearerRelease_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_21 = -1;  /* T_v690NonCriticalExtensions_21 */
static int hf_rrc_v770NonCriticalExtensions_17 = -1;  /* T_v770NonCriticalExtensions_17 */
static int hf_rrc_nonCriticalExtensions_97 = -1;  /* T_nonCriticalExtensions_97 */
static int hf_rrc_criticalExtensions_76 = -1;     /* T_criticalExtensions_75 */
static int hf_rrc_r6_08 = -1;                     /* T_r6_08 */
static int hf_rrc_radioBearerRelease_r6 = -1;     /* RadioBearerRelease_r6_IEs */
static int hf_rrc_radioBearerRelease_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_08 = -1;  /* T_v6b0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerRelease_v6b0ext = -1;  /* RadioBearerRelease_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_18 = -1;  /* T_v770NonCriticalExtensions_18 */
static int hf_rrc_nonCriticalExtensions_98 = -1;  /* T_nonCriticalExtensions_98 */
static int hf_rrc_criticalExtensions_77 = -1;     /* T_criticalExtensions_76 */
static int hf_rrc_r7_07 = -1;                     /* T_r7_07 */
static int hf_rrc_radioBearerRelease_r7 = -1;     /* RadioBearerRelease_r7_IEs */
static int hf_rrc_radioBearerRelease_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_06 = -1;  /* T_v780NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v780ext = -1;  /* RadioBearerRelease_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_08 = -1;  /* T_v7d0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerRelease_v7d0ext = -1;  /* RadioBearerRelease_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_09 = -1;  /* T_v7f0NonCriticalExtensions_09 */
static int hf_rrc_radioBearerRelease_v7f0ext = -1;  /* RadioBearerRelease_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_10 = -1;  /* T_v7g0NonCriticalExtensions_10 */
static int hf_rrc_radioBearerRelease_v7g0ext = -1;  /* RadioBearerRelease_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_99 = -1;  /* T_nonCriticalExtensions_99 */
static int hf_rrc_criticalExtensions_78 = -1;     /* T_criticalExtensions_77 */
static int hf_rrc_r8_08 = -1;                     /* T_r8_08 */
static int hf_rrc_radioBearerRelease_r8 = -1;     /* RadioBearerRelease_r8_IEs */
static int hf_rrc_radioBearerRelease_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_09 = -1;  /* T_v7d0NonCriticalExtensions_09 */
static int hf_rrc_v7f0NonCriticalExtensions_10 = -1;  /* T_v7f0NonCriticalExtensions_10 */
static int hf_rrc_v890NonCriticalExtensions_06 = -1;  /* T_v890NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v890ext = -1;  /* RadioBearerRelease_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_11 = -1;  /* T_v7g0NonCriticalExtensions_11 */
static int hf_rrc_v8a0NonCriticalExtensions_06 = -1;  /* T_v8a0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v8a0ext = -1;  /* RadioBearerRelease_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_100 = -1;  /* T_nonCriticalExtensions_100 */
static int hf_rrc_criticalExtensions_79 = -1;     /* T_criticalExtensions_78 */
static int hf_rrc_r9_07 = -1;                     /* T_r9_07 */
static int hf_rrc_radioBearerRelease_r9 = -1;     /* RadioBearerRelease_r9_IEs */
static int hf_rrc_radioBearerRelease_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_05 = -1;  /* T_v950NonCriticalExtensions_05 */
static int hf_rrc_radioBearerRelease_v950ext = -1;  /* RadioBearerRelease_v950ext_IEs */
static int hf_rrc_v970NonCriticalExtensions_02 = -1;  /* T_v970NonCriticalExtensions_02 */
static int hf_rrc_radioBearerRelease_v970ext = -1;  /* RadioBearerRelease_v970ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_06 = -1;  /* T_v9c0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v9c0ext = -1;  /* RadioBearerRelease_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_101 = -1;  /* T_nonCriticalExtensions_101 */
static int hf_rrc_criticalExtensions_80 = -1;     /* T_criticalExtensions_79 */
static int hf_rrc_r10_07 = -1;                    /* T_r10_07 */
static int hf_rrc_radioBearerRelease_r10 = -1;    /* RadioBearerRelease_r10_IEs */
static int hf_rrc_radioBearerRelease_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_07 = -1;  /* T_v9c0NonCriticalExtensions_07 */
static int hf_rrc_vb50NonCriticalExtensions_13 = -1;  /* T_vb50NonCriticalExtensions_13 */
static int hf_rrc_radioBearerRelease_vb50ext = -1;  /* RadioBearerRelease_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_102 = -1;  /* T_nonCriticalExtensions_102 */
static int hf_rrc_criticalExtensions_81 = -1;     /* T_criticalExtensions_80 */
static int hf_rrc_r11_08 = -1;                    /* T_r11_08 */
static int hf_rrc_radioBearerRelease_r11 = -1;    /* RadioBearerRelease_r11_IEs */
static int hf_rrc_radioBearerRelease_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_103 = -1;  /* T_nonCriticalExtensions_103 */
static int hf_rrc_criticalExtensions_82 = -1;     /* T_criticalExtensions_81 */
static int hf_rrc_signallingConnectionRelIndication = -1;  /* CN_DomainIdentity */
static int hf_rrc_dummy_19 = -1;                  /* T_dummy_04 */
static int hf_rrc_fdd_27 = -1;                    /* T_fdd_27 */
static int hf_rrc_modeSpecificPhysChInfo_06 = -1;  /* T_modeSpecificPhysChInfo_06 */
static int hf_rrc_fdd_28 = -1;                    /* T_fdd_28 */
static int hf_rrc_dummy_20 = -1;                  /* T_dummy_05 */
static int hf_rrc_fdd_29 = -1;                    /* T_fdd_29 */
static int hf_rrc_modeSpecificPhysChInfo_07 = -1;  /* T_modeSpecificPhysChInfo_07 */
static int hf_rrc_fdd_30 = -1;                    /* T_fdd_30 */
static int hf_rrc_dummy_21 = -1;                  /* T_dummy_06 */
static int hf_rrc_fdd_31 = -1;                    /* T_fdd_31 */
static int hf_rrc_modeSpecificPhysChInfo_08 = -1;  /* T_modeSpecificPhysChInfo_08 */
static int hf_rrc_fdd_32 = -1;                    /* T_fdd_32 */
static int hf_rrc_postVerificationPeriod_03 = -1;  /* T_postVerificationPeriod_03 */
static int hf_rrc_mbms_RB_ListReleasedToChangeTransferMode = -1;  /* RB_InformationReleaseList */
static int hf_rrc_laterNonCriticalExtensions_32 = -1;  /* T_laterNonCriticalExtensions_32 */
static int hf_rrc_radioBearerReleaseComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_19 = -1;  /* T_v770NonCriticalExtensions_19 */
static int hf_rrc_radioBearerReleaseComplete_v770ext = -1;  /* RadioBearerReleaseComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_104 = -1;  /* T_nonCriticalExtensions_104 */
static int hf_rrc_deferredMeasurementControlReading_02 = -1;  /* T_deferredMeasurementControlReading_02 */
static int hf_rrc_laterNonCriticalExtensions_33 = -1;  /* T_laterNonCriticalExtensions_33 */
static int hf_rrc_radioBearerReleaseFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_105 = -1;  /* T_nonCriticalExtensions_105 */
static int hf_rrc_r3_16 = -1;                     /* T_r3_16 */
static int hf_rrc_radioBearerSetup_r3 = -1;       /* RadioBearerSetup_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_07 = -1;  /* T_v3a0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v3a0ext = -1;  /* RadioBearerSetup_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_34 = -1;  /* T_laterNonCriticalExtensions_34 */
static int hf_rrc_radioBearerSetup_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_09 = -1;  /* T_v4b0NonCriticalExtensions_09 */
static int hf_rrc_radioBearerSetup_v4b0ext = -1;  /* RadioBearerSetup_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_18 = -1;  /* T_v590NonCriticalExtensions_18 */
static int hf_rrc_radioBearerSetup_v590ext = -1;  /* RadioBearerSetup_v590ext_IEs */
static int hf_rrc_v5d0NonCriticalExtenstions_09 = -1;  /* T_v5d0NonCriticalExtenstions_09 */
static int hf_rrc_radioBearerSetup_v5d0ext = -1;  /* RadioBearerSetup_v5d0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_22 = -1;  /* T_v690NonCriticalExtensions_22 */
static int hf_rrc_radioBearerSetup_v690ext = -1;  /* RadioBearerSetup_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_106 = -1;  /* T_nonCriticalExtensions_106 */
static int hf_rrc_later_than_r3_14 = -1;          /* T_later_than_r3_14 */
static int hf_rrc_criticalExtensions_83 = -1;     /* T_criticalExtensions_82 */
static int hf_rrc_r4_08 = -1;                     /* T_r4_08 */
static int hf_rrc_radioBearerSetup_r4 = -1;       /* RadioBearerSetup_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_08 = -1;  /* T_v4d0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerSetup_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_19 = -1;  /* T_v590NonCriticalExtensions_19 */
static int hf_rrc_v5d0NonCriticalExtenstions_10 = -1;  /* T_v5d0NonCriticalExtenstions_10 */
static int hf_rrc_v690NonCriticalExtensions_23 = -1;  /* T_v690NonCriticalExtensions_23 */
static int hf_rrc_nonCriticalExtensions_107 = -1;  /* T_nonCriticalExtensions_107 */
static int hf_rrc_criticalExtensions_84 = -1;     /* T_criticalExtensions_83 */
static int hf_rrc_r5_07 = -1;                     /* T_r5_07 */
static int hf_rrc_radioBearerSetup_r5 = -1;       /* RadioBearerSetup_r5_IEs */
static int hf_rrc_radioBearerSetup_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_11 = -1;  /* T_v5d0NonCriticalExtenstions_11 */
static int hf_rrc_v690NonCriticalExtensions_24 = -1;  /* T_v690NonCriticalExtensions_24 */
static int hf_rrc_nonCriticalExtensions_108 = -1;  /* T_nonCriticalExtensions_108 */
static int hf_rrc_criticalExtensions_85 = -1;     /* T_criticalExtensions_84 */
static int hf_rrc_r6_09 = -1;                     /* T_r6_09 */
static int hf_rrc_radioBearerSetup_r6 = -1;       /* RadioBearerSetup_r6_IEs */
static int hf_rrc_radioBearerSetup_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_09 = -1;  /* T_v6b0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerSetup_v6b0ext = -1;  /* RadioBearerSetup_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_109 = -1;  /* T_nonCriticalExtensions_109 */
static int hf_rrc_criticalExtensions_86 = -1;     /* T_criticalExtensions_85 */
static int hf_rrc_r7_08 = -1;                     /* T_r7_08 */
static int hf_rrc_radioBearerSetup_r7 = -1;       /* RadioBearerSetup_r7_IEs */
static int hf_rrc_radioBearerSetup_r7_add_ext = -1;  /* T_radioBearerSetup_r7_add_ext */
static int hf_rrc_v780NonCriticalExtensions_07 = -1;  /* T_v780NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v780ext = -1;  /* RadioBearerSetup_v780ext_IEs */
static int hf_rrc_v820NonCriticalExtensions_01 = -1;  /* T_v820NonCriticalExtensions_01 */
static int hf_rrc_radioBearerSetup_v820ext = -1;  /* RadioBearerSetup_v820ext_IEs */
static int hf_rrc_nonCriticalExtensions_110 = -1;  /* T_nonCriticalExtensions_110 */
static int hf_rrc_criticalExtensions_87 = -1;     /* T_criticalExtensions_86 */
static int hf_rrc_r8_09 = -1;                     /* T_r8_09 */
static int hf_rrc_radioBearerSetup_r8 = -1;       /* RadioBearerSetup_r8_IEs */
static int hf_rrc_radioBearerSetup_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_10 = -1;  /* T_v7d0NonCriticalExtensions_10 */
static int hf_rrc_radioBearerSetup_v7d0ext = -1;  /* RadioBearerSetup_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_11 = -1;  /* T_v7f0NonCriticalExtensions_11 */
static int hf_rrc_radioBearerSetup_v7f0ext = -1;  /* RadioBearerSetup_v7f0ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_07 = -1;  /* T_v890NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v890ext = -1;  /* RadioBearerSetup_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_12 = -1;  /* T_v7g0NonCriticalExtensions_12 */
static int hf_rrc_radioBearerSetup_v7g0ext = -1;  /* RadioBearerSetup_v7g0ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions_07 = -1;  /* T_v8a0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v8a0ext = -1;  /* RadioBearerSetup_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_111 = -1;  /* T_nonCriticalExtensions_111 */
static int hf_rrc_criticalExtensions_88 = -1;     /* T_criticalExtensions_87 */
static int hf_rrc_r9_08 = -1;                     /* T_r9_08 */
static int hf_rrc_radioBearerSetup_r9 = -1;       /* RadioBearerSetup_r9_IEs */
static int hf_rrc_radioBearerSetup_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_06 = -1;  /* T_v950NonCriticalExtensions_06 */
static int hf_rrc_radioBearerSetup_v950ext = -1;  /* RadioBearerSetup_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_08 = -1;  /* T_v9c0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerSetup_v9c0ext = -1;  /* RadioBearerSetup_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_112 = -1;  /* T_nonCriticalExtensions_112 */
static int hf_rrc_criticalExtensions_89 = -1;     /* T_criticalExtensions_88 */
static int hf_rrc_r10_08 = -1;                    /* T_r10_08 */
static int hf_rrc_radioBearerSetup_r10 = -1;      /* RadioBearerSetup_r10_IEs */
static int hf_rrc_radioBearerSetup_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_09 = -1;  /* T_v9c0NonCriticalExtensions_09 */
static int hf_rrc_vb50NonCriticalExtensions_14 = -1;  /* T_vb50NonCriticalExtensions_14 */
static int hf_rrc_radioBearerSetup_vb50ext = -1;  /* RadioBearerSetup_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_113 = -1;  /* T_nonCriticalExtensions_113 */
static int hf_rrc_criticalExtensions_90 = -1;     /* T_criticalExtensions_89 */
static int hf_rrc_r11_09 = -1;                    /* T_r11_09 */
static int hf_rrc_radioBearerSetup_r11 = -1;      /* RadioBearerSetup_r11_IEs */
static int hf_rrc_radioBearerSetup_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_114 = -1;  /* T_nonCriticalExtensions_114 */
static int hf_rrc_criticalExtensions_91 = -1;     /* T_criticalExtensions_90 */
static int hf_rrc_dummy_22 = -1;                  /* T_dummy_07 */
static int hf_rrc_fdd_33 = -1;                    /* T_fdd_33 */
static int hf_rrc_modeSpecificPhysChInfo_09 = -1;  /* T_modeSpecificPhysChInfo_09 */
static int hf_rrc_fdd_34 = -1;                    /* T_fdd_34 */
static int hf_rrc_dummy_23 = -1;                  /* T_dummy_08 */
static int hf_rrc_fdd_35 = -1;                    /* T_fdd_35 */
static int hf_rrc_modeSpecificPhysChInfo_10 = -1;  /* T_modeSpecificPhysChInfo_10 */
static int hf_rrc_fdd_36 = -1;                    /* T_fdd_36 */
static int hf_rrc_dummy_24 = -1;                  /* T_dummy_09 */
static int hf_rrc_fdd_37 = -1;                    /* T_fdd_37 */
static int hf_rrc_modeSpecificPhysChInfo_11 = -1;  /* T_modeSpecificPhysChInfo_11 */
static int hf_rrc_fdd_38 = -1;                    /* T_fdd_38 */
static int hf_rrc_postVerificationPeriod_04 = -1;  /* T_postVerificationPeriod_04 */
static int hf_rrc_rab_InformationSetupList_07 = -1;  /* RAB_InformationSetupList_r6_ext */
static int hf_rrc_specificationMode_17 = -1;      /* T_specificationMode_17 */
static int hf_rrc_complete_17 = -1;               /* T_complete_17 */
static int hf_rrc_dummy_25 = -1;                  /* T_dummy_10 */
static int hf_rrc_rab_Info_01 = -1;               /* RAB_Info_r6 */
static int hf_rrc_rb_InformationChangedList = -1;  /* RB_InformationChangedList_r6 */
static int hf_rrc_powerOffsetInfoShort = -1;      /* PowerOffsetInfoShort */
static int hf_rrc_rab_InformationSetupListExt = -1;  /* RAB_InformationSetupList_v6b0ext */
static int hf_rrc_specificationMode_18 = -1;      /* T_specificationMode_18 */
static int hf_rrc_complete_18 = -1;               /* T_complete_18 */
static int hf_rrc_dummy_26 = -1;                  /* NULL */
static int hf_rrc_v7f0NonCriticalExtensions_12 = -1;  /* T_v7f0NonCriticalExtensions_12 */
static int hf_rrc_v7g0NonCriticalExtensions_13 = -1;  /* T_v7g0NonCriticalExtensions_13 */
static int hf_rrc_nonCriticalExtensions_115 = -1;  /* T_nonCriticalExtensions_115 */
static int hf_rrc_sr_vcc_Info = -1;               /* SR_VCC_Info */
static int hf_rrc_srb_InformationSetupList_05 = -1;  /* SRB_InformationSetupList_r11 */
static int hf_rrc_rab_InformationSetupList_08 = -1;  /* RAB_InformationSetupList_r11 */
static int hf_rrc_laterNonCriticalExtensions_35 = -1;  /* T_laterNonCriticalExtensions_35 */
static int hf_rrc_radioBearerSetupComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_20 = -1;  /* T_v770NonCriticalExtensions_20 */
static int hf_rrc_radioBearerSetupComplete_v770ext = -1;  /* RadioBearerSetupComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_116 = -1;  /* T_nonCriticalExtensions_116 */
static int hf_rrc_deferredMeasurementControlReading_03 = -1;  /* T_deferredMeasurementControlReading_03 */
static int hf_rrc_laterNonCriticalExtensions_36 = -1;  /* T_laterNonCriticalExtensions_36 */
static int hf_rrc_radioBearerSetupFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_117 = -1;  /* T_nonCriticalExtensions_117 */
static int hf_rrc_r3_17 = -1;                     /* T_r3_17 */
static int hf_rrc_rrcConnectionReject_r3 = -1;    /* RRCConnectionReject_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_37 = -1;  /* T_laterNonCriticalExtensions_37 */
static int hf_rrc_rrcConnectionReject_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_25 = -1;  /* T_v690NonCriticalExtensions_25 */
static int hf_rrc_rrcConnectionReject_v690ext = -1;  /* RRCConnectionReject_v690ext_IEs */
static int hf_rrc_v6f0NonCriticalExtensions_01 = -1;  /* T_v6f0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionReject_v6f0ext = -1;  /* RRCConnectionReject_v6f0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_10 = -1;  /* T_v860NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionReject_v860ext = -1;  /* RRCConnectionReject_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_05 = -1;  /* T_va40NonCriticalExtensions_05 */
static int hf_rrc_rrcConnectionReject_va40ext = -1;  /* RRCConnectionReject_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_15 = -1;  /* T_vb50NonCriticalExtensions_15 */
static int hf_rrc_rrcConnectionReject_vb50ext = -1;  /* RRCConnectionReject_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_118 = -1;  /* T_nonCriticalExtensions_118 */
static int hf_rrc_later_than_r3_15 = -1;          /* T_later_than_r3_15 */
static int hf_rrc_initialUE_Identity = -1;        /* InitialUE_Identity */
static int hf_rrc_criticalExtensions_92 = -1;     /* T_criticalExtensions_91 */
static int hf_rrc_rejectionCause = -1;            /* RejectionCause */
static int hf_rrc_redirectionInfo = -1;           /* RedirectionInfo */
static int hf_rrc_redirectionInfo_v690ext = -1;   /* GSM_TargetCellInfoList */
static int hf_rrc_countingCompletion = -1;        /* T_countingCompletion */
static int hf_rrc_redirectionInfo_01 = -1;        /* RedirectionInfo_v860ext */
static int hf_rrc_extendedWaitTime = -1;          /* ExtendedWaitTime */
static int hf_rrc_eutra_TargetFreqInfoList = -1;  /* EUTRA_TargetFreqInfoList_vb50ext */
static int hf_rrc_r3_18 = -1;                     /* T_r3_18 */
static int hf_rrc_rrcConnectionRelease_r3 = -1;   /* RRCConnectionRelease_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_38 = -1;  /* T_laterNonCriticalExtensions_38 */
static int hf_rrc_rrcConnectionRelease_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_26 = -1;  /* T_v690NonCriticalExtensions_26 */
static int hf_rrc_rrcConnectionRelease_v690ext = -1;  /* RRCConnectionRelease_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_21 = -1;  /* T_v770NonCriticalExtensions_21 */
static int hf_rrc_rrcConnectionRelease_v770ext = -1;  /* RRCConnectionRelease_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_11 = -1;  /* T_v860NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionRelease_v860ext = -1;  /* RRCConnectionRelease_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_06 = -1;  /* T_va40NonCriticalExtensions_06 */
static int hf_rrc_rrcConnectionRelease_va40ext = -1;  /* RRCConnectionRelease_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_119 = -1;  /* T_nonCriticalExtensions_119 */
static int hf_rrc_later_than_r3_16 = -1;          /* T_later_than_r3_16 */
static int hf_rrc_criticalExtensions_93 = -1;     /* T_criticalExtensions_92 */
static int hf_rrc_r4_09 = -1;                     /* T_r4_09 */
static int hf_rrc_rrcConnectionRelease_r4 = -1;   /* RRCConnectionRelease_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_09 = -1;  /* T_v4d0NonCriticalExtensions_09 */
static int hf_rrc_rrcConnectionRelease_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_27 = -1;  /* T_v690NonCriticalExtensions_27 */
static int hf_rrc_v770NonCriticalExtensions_22 = -1;  /* T_v770NonCriticalExtensions_22 */
static int hf_rrc_v860NonCriticalExtensions_12 = -1;  /* T_v860NonCriticalExtensions_12 */
static int hf_rrc_va40NonCriticalExtensions_07 = -1;  /* T_va40NonCriticalExtensions_07 */
static int hf_rrc_vb50NonCriticalExtensions_16 = -1;  /* T_vb50NonCriticalExtensions_16 */
static int hf_rrc_rrcConnectionRelease_vb50ext = -1;  /* RRCConnectionRelease_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_120 = -1;  /* T_nonCriticalExtensions_120 */
static int hf_rrc_criticalExtensions_94 = -1;     /* T_criticalExtensions_93 */
static int hf_rrc_n_308 = -1;                     /* N_308 */
static int hf_rrc_releaseCause = -1;              /* ReleaseCause */
static int hf_rrc_rplmn_information = -1;         /* Rplmn_Information */
static int hf_rrc_rplmn_information_01 = -1;      /* Rplmn_Information_r4 */
static int hf_rrc_redirectionInfo_v690ext_01 = -1;  /* RedirectionInfo_r6 */
static int hf_rrc_r3_19 = -1;                     /* T_r3_19 */
static int hf_rrc_rrcConnectionRelease_CCCH_r3 = -1;  /* RRCConnectionRelease_CCCH_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_39 = -1;  /* T_laterNonCriticalExtensions_39 */
static int hf_rrc_rrcConnectionRelease_CCCH_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_28 = -1;  /* T_v690NonCriticalExtensions_28 */
static int hf_rrc_rrcConnectionRelease_v690ext_01 = -1;  /* RRCConnectionRelease_CCCH_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_13 = -1;  /* T_v860NonCriticalExtensions_13 */
static int hf_rrc_rrcConnectionRelease_v860ext_01 = -1;  /* RRCConnectionRelease_CCCH_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_08 = -1;  /* T_va40NonCriticalExtensions_08 */
static int hf_rrc_nonCriticalExtensions_121 = -1;  /* T_nonCriticalExtensions_121 */
static int hf_rrc_later_than_r3_17 = -1;          /* T_later_than_r3_17 */
static int hf_rrc_criticalExtensions_95 = -1;     /* T_criticalExtensions_94 */
static int hf_rrc_r4_10 = -1;                     /* T_r4_10 */
static int hf_rrc_rrcConnectionRelease_CCCH_r4 = -1;  /* RRCConnectionRelease_CCCH_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_10 = -1;  /* T_v4d0NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionRelease_CCCH_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_29 = -1;  /* T_v690NonCriticalExtensions_29 */
static int hf_rrc_v860NonCriticalExtensions_14 = -1;  /* T_v860NonCriticalExtensions_14 */
static int hf_rrc_va40NonCriticalExtensions_09 = -1;  /* T_va40NonCriticalExtensions_09 */
static int hf_rrc_nonCriticalExtensions_122 = -1;  /* T_nonCriticalExtensions_122 */
static int hf_rrc_criticalExtensions_96 = -1;     /* T_criticalExtensions_95 */
static int hf_rrc_groupIdentity = -1;             /* SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupReleaseInformation */
static int hf_rrc_groupIdentity_item = -1;        /* GroupReleaseInformation */
static int hf_rrc_criticalExtensions_97 = -1;     /* T_criticalExtensions_96 */
static int hf_rrc_r5_08 = -1;                     /* T_r5_08 */
static int hf_rrc_rrcConnectionRelease_CCCH_r5 = -1;  /* RRCConnectionRelease_CCCH_r5_IEs */
static int hf_rrc_rrcConnectionRelease_CCCH_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_30 = -1;  /* T_v690NonCriticalExtensions_30 */
static int hf_rrc_v860NonCriticalExtensions_15 = -1;  /* T_v860NonCriticalExtensions_15 */
static int hf_rrc_va40NonCriticalExtensions_10 = -1;  /* T_va40NonCriticalExtensions_10 */
static int hf_rrc_nonCriticalExtensions_123 = -1;  /* T_nonCriticalExtensions_123 */
static int hf_rrc_criticalExtensions_98 = -1;     /* T_criticalExtensions_97 */
static int hf_rrc_rrcConnectionRelease_02 = -1;   /* RRCConnectionRelease_r3_IEs */
static int hf_rrc_rrcConnectionRelease_03 = -1;   /* RRCConnectionRelease_r4_IEs */
static int hf_rrc_errorIndication = -1;           /* FailureCauseWithProtErr */
static int hf_rrc_laterNonCriticalExtensions_40 = -1;  /* T_laterNonCriticalExtensions_40 */
static int hf_rrc_rrcConnectionReleaseComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_124 = -1;  /* T_nonCriticalExtensions_124 */
static int hf_rrc_protocolErrorIndicator_01 = -1;  /* ProtocolErrorIndicator */
static int hf_rrc_v3d0NonCriticalExtensions = -1;  /* T_v3d0NonCriticalExtensions */
static int hf_rrc_rRCConnectionRequest_v3d0ext = -1;  /* RRCConnectionRequest_v3d0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_10 = -1;  /* T_v4b0NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionRequest_v4b0ext = -1;  /* RRCConnectionRequest_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_20 = -1;  /* T_v590NonCriticalExtensions_20 */
static int hf_rrc_rrcConnectionRequest_v590ext = -1;  /* RRCConnectionRequest_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_31 = -1;  /* T_v690NonCriticalExtensions_31 */
static int hf_rrc_rrcConnectionRequest_v690ext = -1;  /* RRCConnectionRequest_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_10 = -1;  /* T_v6b0NonCriticalExtensions_09 */
static int hf_rrc_rrcConnectionRequest_v6b0ext = -1;  /* RRCConnectionRequest_v6b0ext_IEs */
static int hf_rrc_v6e0NonCriticalExtensions_01 = -1;  /* T_v6e0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionRequest_v6e0ext = -1;  /* RRCConnectionRequest_v6e0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_23 = -1;  /* T_v770NonCriticalExtensions_23 */
static int hf_rrc_rrcConnectionRequest_v770ext = -1;  /* RRCConnectionRequest_v770ext_IEs */
static int hf_rrc_v7b0NonCriticalExtensions_01 = -1;  /* T_v7b0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionRequest_v7b0ext = -1;  /* RRCConnectionRequest_v7b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_16 = -1;  /* T_v860NonCriticalExtensions_16 */
static int hf_rrc_rrcConnectionRequest_v860ext = -1;  /* RRCConnectionRequest_v860ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_01 = -1;  /* T_v7e0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionRequest_v7e0ext = -1;  /* RRCConnectionRequest_v7e0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_14 = -1;  /* T_v7g0NonCriticalExtensions_14 */
static int hf_rrc_rrcConnectionRequest_v7g0ext = -1;  /* RRCConnectionRequest_v7g0ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_02 = -1;  /* T_v920NonCriticalExtensions_02 */
static int hf_rrc_rrcConnectionRequest_v920ext = -1;  /* RRCConnectionRequest_v920ext_IEs */
static int hf_rrc_v940NonCriticalExtensions = -1;  /* T_v940NonCriticalExtensions */
static int hf_rrc_rrcConnectionRequest_v940ext = -1;  /* RRCConnectionRequest_v940ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_11 = -1;  /* RRCConnectionRequest_NonCriticalExts_va40_IEs */
static int hf_rrc_uESpecificBehaviourInformation1idle = -1;  /* UESpecificBehaviourInformation1idle */
static int hf_rrc_predefinedConfigStatusInfo = -1;  /* BOOLEAN */
static int hf_rrc_ueCapabilityIndication = -1;    /* T_ueCapabilityIndication */
static int hf_rrc_domainIndicator = -1;           /* T_domainIndicator */
static int hf_rrc_cs_domain = -1;                 /* T_cs_domain */
static int hf_rrc_csCallType_03 = -1;             /* T_csCallType_03 */
static int hf_rrc_ps_domain = -1;                 /* NULL */
static int hf_rrc_supportForFDPCH_01 = -1;        /* T_supportForFDPCH_01 */
static int hf_rrc_hspdschReception_CellFach_02 = -1;  /* T_hspdschReception_CellFach_02 */
static int hf_rrc_mac_ehsSupport = -1;            /* T_mac_ehsSupport */
static int hf_rrc_discontinuousDpcchTransmission = -1;  /* T_discontinuousDpcchTransmission */
static int hf_rrc_supportForE_FDPCH = -1;         /* T_supportForE_FDPCH */
static int hf_rrc_supportForCSVoiceoverHSPA = -1;  /* T_supportForCSVoiceoverHSPA */
static int hf_rrc_supportOfCommonEDCH_02 = -1;    /* T_supportOfCommonEDCH_02 */
static int hf_rrc_multiCellSupport = -1;          /* T_multiCellSupport */
static int hf_rrc_pre_redirectionInfo = -1;       /* Pre_RedirectionInfo */
static int hf_rrc_supportOfMACiis_02 = -1;        /* T_supportOfMACiis_02 */
static int hf_rrc_supportOfSPSOperation_01 = -1;  /* T_supportOfSPSOperation_01 */
static int hf_rrc_supportOfDualCellMIMO = -1;     /* T_supportOfDualCellMIMO */
static int hf_rrc_systemInformationContainerStoredIndicator = -1;  /* T_systemInformationContainerStoredIndicator */
static int hf_rrc_cSFBIndication = -1;            /* T_cSFBIndication */
static int hf_rrc_rrcConnectionRequest_va40ext = -1;  /* RRCConnectionRequest_va40ext_IEs */
static int hf_rrc_v9b0NonCriticalExtensions = -1;  /* T_v9b0NonCriticalExtensions */
static int hf_rrc_rrcConnectionRequest_v9b0ext = -1;  /* RRCConnectionRequest_v9b0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_17 = -1;  /* T_vb50NonCriticalExtensions_17 */
static int hf_rrc_rrcConnectionRequest_vb50ext = -1;  /* RRCConnectionRequest_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_125 = -1;  /* T_nonCriticalExtensions_125 */
static int hf_rrc_supportOfMoreThanTwoCellsOrMIMO4x4 = -1;  /* T_supportOfMoreThanTwoCellsOrMIMO4x4 */
static int hf_rrc_supportOf1stFrequencyBand = -1;  /* T_supportOf1stFrequencyBand */
static int hf_rrc_supportOf2ndFrequencyBand = -1;  /* T_supportOf2ndFrequencyBand */
static int hf_rrc_r3_20 = -1;                     /* T_r3_20 */
static int hf_rrc_rrcConnectionSetup_r3 = -1;     /* RRCConnectionSetup_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_41 = -1;  /* T_laterNonCriticalExtensions_41 */
static int hf_rrc_rrcConnectionSetup_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_11 = -1;  /* T_v4b0NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionSetup_v4b0ext = -1;  /* RRCConnectionSetup_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_21 = -1;  /* T_v590NonCriticalExtensions_21 */
static int hf_rrc_rrcConnectionSetup_v590ext = -1;  /* RRCConnectionSetup_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_32 = -1;  /* T_v690NonCriticalExtensions_32 */
static int hf_rrc_rrcConnectionSetup_v690ext = -1;  /* RRCConnectionSetup_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_126 = -1;  /* T_nonCriticalExtensions_126 */
static int hf_rrc_later_than_r3_18 = -1;          /* T_later_than_r3_18 */
static int hf_rrc_criticalExtensions_99 = -1;     /* T_criticalExtensions_98 */
static int hf_rrc_r4_11 = -1;                     /* T_r4_11 */
static int hf_rrc_rrcConnectionSetup_r4 = -1;     /* RRCConnectionSetup_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_11 = -1;  /* T_v4d0NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionSetup_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_22 = -1;  /* T_v590NonCriticalExtensions_22 */
static int hf_rrc_v690NonCriticalExtensions_33 = -1;  /* T_v690NonCriticalExtensions_33 */
static int hf_rrc_nonCriticalExtensions_127 = -1;  /* T_nonCriticalExtensions_127 */
static int hf_rrc_criticalExtensions_100 = -1;    /* T_criticalExtensions_99 */
static int hf_rrc_r5_09 = -1;                     /* T_r5_09 */
static int hf_rrc_rrcConnectionSetup_r5 = -1;     /* RRCConnectionSetup_r5_IEs */
static int hf_rrc_rrcConnectionSetup_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_34 = -1;  /* T_v690NonCriticalExtensions_34 */
static int hf_rrc_nonCriticalExtensions_128 = -1;  /* T_nonCriticalExtensions_128 */
static int hf_rrc_criticalExtensions_101 = -1;    /* T_criticalExtensions_100 */
static int hf_rrc_r6_10 = -1;                     /* T_r6_10 */
static int hf_rrc_rrcConnectionSetup_r6 = -1;     /* RRCConnectionSetup_r6_IEs */
static int hf_rrc_rrcConnectionSetup_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_11 = -1;  /* T_v6b0NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionSetup_v6b0ext = -1;  /* RRCConnectionSetup_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_129 = -1;  /* T_nonCriticalExtensions_129 */
static int hf_rrc_criticalExtensions_102 = -1;    /* T_criticalExtensions_101 */
static int hf_rrc_r7_09 = -1;                     /* T_r7_09 */
static int hf_rrc_rrcConnectionSetup_r7 = -1;     /* RRCConnectionSetup_r7_IEs */
static int hf_rrc_rrcConnectionSetup_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_08 = -1;  /* T_v780NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetup_v780ext = -1;  /* RRCConnectionSetup_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_11 = -1;  /* T_v7d0NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionSetup_v7d0ext = -1;  /* RRCConnectionSetup_v7d0ext_IEs */
static int hf_rrc_nonCriticalExtensions_130 = -1;  /* T_nonCriticalExtensions_130 */
static int hf_rrc_criticalExtensions_103 = -1;    /* T_criticalExtensions_102 */
static int hf_rrc_r8_10 = -1;                     /* T_r8_10 */
static int hf_rrc_rrcConnectionSetup_r8 = -1;     /* RRCConnectionSetup_r8_IEs */
static int hf_rrc_rrcConnectionSetup_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_12 = -1;  /* T_v7d0NonCriticalExtensions_12 */
static int hf_rrc_v890NonCriticalExtensions_08 = -1;  /* T_v890NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetup_v890ext = -1;  /* RRCConnectionSetup_v890ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions_08 = -1;  /* T_v8a0NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetup_v8a0ext = -1;  /* RRCConnectionSetup_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_131 = -1;  /* T_nonCriticalExtensions_131 */
static int hf_rrc_criticalExtensions_104 = -1;    /* T_criticalExtensions_103 */
static int hf_rrc_r9_09 = -1;                     /* T_r9_09 */
static int hf_rrc_rrcConnectionSetup_r9 = -1;     /* RRCConnectionSetup_r9_IEs */
static int hf_rrc_rrcConnectionSetup_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_07 = -1;  /* T_v950NonCriticalExtensions_07 */
static int hf_rrc_rrcConnectionSetup_v950ext = -1;  /* RRCConnectionSetup_v950ext_IEs */
static int hf_rrc_nonCriticalExtensions_132 = -1;  /* T_nonCriticalExtensions_132 */
static int hf_rrc_criticalExtensions_105 = -1;    /* T_criticalExtensions_104 */
static int hf_rrc_r10_09 = -1;                    /* T_r10_09 */
static int hf_rrc_rrcConnectionSetup_r10 = -1;    /* RRCConnectionSetup_r10_IEs */
static int hf_rrc_rrcConnectionSetup_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_133 = -1;  /* T_nonCriticalExtensions_133 */
static int hf_rrc_criticalExtensions_106 = -1;    /* T_criticalExtensions_105 */
static int hf_rrc_r11_10 = -1;                    /* T_r11_10 */
static int hf_rrc_rrcConnectionSetup_r11 = -1;    /* RRCConnectionSetup_r11_IEs */
static int hf_rrc_rrcConnectionSetup_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_134 = -1;  /* T_nonCriticalExtensions_134 */
static int hf_rrc_criticalExtensions_107 = -1;    /* T_criticalExtensions_106 */
static int hf_rrc_new_c_RNTI = -1;                /* C_RNTI */
static int hf_rrc_capabilityUpdateRequirement = -1;  /* CapabilityUpdateRequirement */
static int hf_rrc_srb_InformationSetupList_06 = -1;  /* SRB_InformationSetupList2 */
static int hf_rrc_capabilityUpdateRequirement_r4_ext = -1;  /* CapabilityUpdateRequirement_r4_ext */
static int hf_rrc_systemSpecificCapUpdateReq = -1;  /* SystemSpecificCapUpdateReq_v590ext */
static int hf_rrc_capabilityUpdateRequirement_01 = -1;  /* CapabilityUpdateRequirement_r4 */
static int hf_rrc_capabilityUpdateRequirement_02 = -1;  /* CapabilityUpdateRequirement_r5 */
static int hf_rrc_specificationMode_19 = -1;      /* T_specificationMode_19 */
static int hf_rrc_complete_19 = -1;               /* T_complete_19 */
static int hf_rrc_preconfiguration_16 = -1;       /* T_preconfiguration_16 */
static int hf_rrc_preConfigMode_16 = -1;          /* T_preConfigMode_16 */
static int hf_rrc_defaultConfig_16 = -1;          /* T_defaultConfig_16 */
static int hf_rrc_dl_InformationPerRL_List_08 = -1;  /* DL_InformationPerRL_List_r5bis */
static int hf_rrc_postVerificationPeriod_05 = -1;  /* T_postVerificationPeriod_05 */
static int hf_rrc_specificationMode_20 = -1;      /* T_specificationMode_20 */
static int hf_rrc_complete_20 = -1;               /* T_complete_20 */
static int hf_rrc_srb_InformationSetupList_07 = -1;  /* SRB_InformationSetupList2_r6 */
static int hf_rrc_preconfiguration_17 = -1;       /* T_preconfiguration_17 */
static int hf_rrc_preConfigMode_17 = -1;          /* T_preConfigMode_17 */
static int hf_rrc_defaultConfig_17 = -1;          /* T_defaultConfig_17 */
static int hf_rrc_capabilityUpdateRequirement_03 = -1;  /* CapabilityUpdateRequirement_r7 */
static int hf_rrc_specificationMode_21 = -1;      /* T_specificationMode_21 */
static int hf_rrc_complete_21 = -1;               /* T_complete_21 */
static int hf_rrc_srb_InformationSetupList_08 = -1;  /* SRB_InformationSetupList2_r7 */
static int hf_rrc_preconfiguration_18 = -1;       /* T_preconfiguration_18 */
static int hf_rrc_preConfigMode_18 = -1;          /* T_preConfigMode_18 */
static int hf_rrc_defaultConfig_18 = -1;          /* T_defaultConfig_18 */
static int hf_rrc_capabilityUpdateRequirement_04 = -1;  /* CapabilityUpdateRequirement_r8 */
static int hf_rrc_specificationMode_22 = -1;      /* T_specificationMode_22 */
static int hf_rrc_complete_22 = -1;               /* T_complete_22 */
static int hf_rrc_srb_InformationSetupList_09 = -1;  /* SRB_InformationSetupList2_r8 */
static int hf_rrc_preconfiguration_19 = -1;       /* T_preconfiguration_19 */
static int hf_rrc_preConfigMode_19 = -1;          /* T_preConfigMode_19 */
static int hf_rrc_defaultConfig_19 = -1;          /* T_defaultConfig_19 */
static int hf_rrc_specificationMode_23 = -1;      /* T_specificationMode_23 */
static int hf_rrc_complete_23 = -1;               /* T_complete_23 */
static int hf_rrc_preconfiguration_20 = -1;       /* T_preconfiguration_20 */
static int hf_rrc_preConfigMode_20 = -1;          /* T_preConfigMode_20 */
static int hf_rrc_defaultConfig_20 = -1;          /* T_defaultConfig_20 */
static int hf_rrc_specificationMode_24 = -1;      /* T_specificationMode_24 */
static int hf_rrc_complete_24 = -1;               /* T_complete_24 */
static int hf_rrc_preconfiguration_21 = -1;       /* T_preconfiguration_21 */
static int hf_rrc_preConfigMode_21 = -1;          /* T_preConfigMode_21 */
static int hf_rrc_defaultConfig_21 = -1;          /* T_defaultConfig_21 */
static int hf_rrc_specificationMode_25 = -1;      /* T_specificationMode_25 */
static int hf_rrc_complete_25 = -1;               /* T_complete_25 */
static int hf_rrc_preconfiguration_22 = -1;       /* T_preconfiguration_22 */
static int hf_rrc_preConfigMode_22 = -1;          /* T_preConfigMode_22 */
static int hf_rrc_defaultConfig_22 = -1;          /* T_defaultConfig_22 */
static int hf_rrc_ue_RadioAccessCapability_02 = -1;  /* UE_RadioAccessCapability */
static int hf_rrc_ue_RATSpecificCapability = -1;  /* InterRAT_UE_RadioAccessCapabilityList */
static int hf_rrc_v370NonCriticalExtensions = -1;  /* T_v370NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v370ext = -1;  /* RRCConnectionSetupComplete_v370ext */
static int hf_rrc_v380NonCriticalExtensions = -1;  /* T_v380NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v380ext = -1;  /* RRCConnectionSetupComplete_v380ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_08 = -1;  /* T_v3a0NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetupComplete_v3a0ext = -1;  /* RRCConnectionSetupComplete_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_42 = -1;  /* T_laterNonCriticalExtensions_42 */
static int hf_rrc_rrcConnectionSetupComplete_r3_add_ext = -1;  /* T_rrcConnectionSetupComplete_r3_add_ext */
static int hf_rrc_v3g0NonCriticalExtensions_01 = -1;  /* T_v3g0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionSetupComplete_v3g0ext = -1;  /* RRCConnectionSetupComplete_v3g0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_12 = -1;  /* T_v4b0NonCriticalExtensions_12 */
static int hf_rrc_rrcConnectionSetupComplete_v4b0ext = -1;  /* RRCConnectionSetupComplete_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_23 = -1;  /* T_v590NonCriticalExtensions_23 */
static int hf_rrc_rrcConnectionSetupComplete_v590ext = -1;  /* RRCConnectionSetupComplete_v590ext_IEs */
static int hf_rrc_v5c0NonCriticalExtensions = -1;  /* T_v5c0NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v5c0ext = -1;  /* RRCConnectionSetupComplete_v5c0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_35 = -1;  /* T_v690NonCriticalExtensions_35 */
static int hf_rrc_rrcConnectionSetupComplete_v690ext = -1;  /* RRCConnectionSetupComplete_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_24 = -1;  /* T_v770NonCriticalExtensions_24 */
static int hf_rrc_rrcConectionSetupComplete_v770ext = -1;  /* RRCConnectionSetupComplete_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_12 = -1;  /* T_va40NonCriticalExtensions_11 */
static int hf_rrc_rrcConectionSetupComplete_va40ext = -1;  /* RRCConnectionSetupComplete_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_18 = -1;  /* T_vb50NonCriticalExtensions_18 */
static int hf_rrc_rrcConnectionSetupComplete_vb50ext = -1;  /* RRCConnectionSetupComplete_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_135 = -1;  /* T_nonCriticalExtensions_135 */
static int hf_rrc_ue_RadioAccessCapability_v370ext = -1;  /* UE_RadioAccessCapability_v370ext */
static int hf_rrc_rrcConnectionSetupComplete_v650ext = -1;  /* RRCConnectionSetupComplete_v650ext_IEs */
static int hf_rrc_v680NonCriticalExtensions = -1;  /* T_v680NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v680ext = -1;  /* RRCConnectionSetupComplete_v680ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_02 = -1;  /* T_v7e0NonCriticalExtensions_02 */
static int hf_rrc_rrcConnectionSetupComplete_v7e0ext = -1;  /* RRCConnectionSetupComplete_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_13 = -1;  /* T_v7f0NonCriticalExtensions_13 */
static int hf_rrc_rrcConnectionSetupComplete_v7f0ext = -1;  /* RRCConnectionSetupComplete_v7f0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_13 = -1;  /* T_va40NonCriticalExtensions_12 */
static int hf_rrc_rrcConnectionSetupCompleteBand_va40ext = -1;  /* RRCConnectionSetupCompleteBand_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_136 = -1;  /* T_nonCriticalExtensions_136 */
static int hf_rrc_ue_RadioAccessCapability_v4b0ext = -1;  /* UE_RadioAccessCapability_v4b0ext */
static int hf_rrc_ue_RadioAccessCapability_v590ext = -1;  /* UE_RadioAccessCapability_v590ext */
static int hf_rrc_ue_RATSpecificCapability_v590ext = -1;  /* InterRAT_UE_RadioAccessCapability_v590ext */
static int hf_rrc_ue_RadioAccessCapability_v5c0ext = -1;  /* UE_RadioAccessCapability_v5c0ext */
static int hf_rrc_ue_RadioAccessCapability_v680ext = -1;  /* UE_RadioAccessCapability_v680ext */
static int hf_rrc_ueCapabilityContainer = -1;     /* T_ueCapabilityContainer */
static int hf_rrc_deferredMeasurementControlReading_04 = -1;  /* T_deferredMeasurementControlReading_04 */
static int hf_rrc_loggedMeasAvailable_04 = -1;    /* T_loggedMeasAvailable_04 */
static int hf_rrc_loggedANRResultsAvailable_03 = -1;  /* T_loggedANRResultsAvailable_03 */
static int hf_rrc_connEstFailInfoAvailable_01 = -1;  /* T_connEstFailInfoAvailable_01 */
static int hf_rrc_r3_21 = -1;                     /* T_r3_21 */
static int hf_rrc_rRC_FailureInfo_r3 = -1;        /* RRC_FailureInfo_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_43 = -1;  /* T_laterNonCriticalExtensions_43 */
static int hf_rrc_rrc_FailureInfo_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_137 = -1;  /* T_nonCriticalExtensions_137 */
static int hf_rrc_criticalExtensions_108 = -1;    /* T_criticalExtensions_107 */
static int hf_rrc_failureCauseWithProtErr = -1;   /* FailureCauseWithProtErr */
static int hf_rrc_protocolErrorInformation = -1;  /* ProtocolErrorMoreInformation */
static int hf_rrc_laterNonCriticalExtensions_44 = -1;  /* T_laterNonCriticalExtensions_44 */
static int hf_rrc_rrcStatus_r3_add_ext = -1;      /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_138 = -1;  /* T_nonCriticalExtensions_138 */
static int hf_rrc_r3_22 = -1;                     /* T_r3_22 */
static int hf_rrc_securityModeCommand_r3 = -1;    /* SecurityModeCommand_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_45 = -1;  /* T_laterNonCriticalExtensions_45 */
static int hf_rrc_securityModeCommand_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_139 = -1;  /* T_nonCriticalExtensions_139 */
static int hf_rrc_later_than_r3_19 = -1;          /* T_later_than_r3_19 */
static int hf_rrc_criticalExtensions_109 = -1;    /* T_criticalExtensions_108 */
static int hf_rrc_r7_10 = -1;                     /* T_r7_10 */
static int hf_rrc_securityModeCommand_r7 = -1;    /* SecurityModeCommand_r7_IEs */
static int hf_rrc_securityModeCommand_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_140 = -1;  /* T_nonCriticalExtensions_140 */
static int hf_rrc_criticalExtensions_110 = -1;    /* T_criticalExtensions_109 */
static int hf_rrc_securityCapability = -1;        /* SecurityCapability */
static int hf_rrc_ue_SystemSpecificSecurityCap = -1;  /* InterRAT_UE_SecurityCapList */
static int hf_rrc_rb_UL_CiphActivationTimeInfo = -1;  /* RB_ActivationTimeInfoList */
static int hf_rrc_laterNonCriticalExtensions_46 = -1;  /* T_laterNonCriticalExtensions_46 */
static int hf_rrc_securityModeComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_141 = -1;  /* T_nonCriticalExtensions_141 */
static int hf_rrc_laterNonCriticalExtensions_47 = -1;  /* T_laterNonCriticalExtensions_47 */
static int hf_rrc_securityModeFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_142 = -1;  /* T_nonCriticalExtensions_142 */
static int hf_rrc_r3_23 = -1;                     /* T_r3_23 */
static int hf_rrc_signallingConnectionRelease_r3 = -1;  /* SignallingConnectionRelease_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_48 = -1;  /* T_laterNonCriticalExtensions_48 */
static int hf_rrc_signallingConnectionRelease_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_va40NonCriticalExtensions_14 = -1;  /* T_va40NonCriticalExtensions_13 */
static int hf_rrc_signallingConnectionRelease_va40ext = -1;  /* SignallingConnectionRelease_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_143 = -1;  /* T_nonCriticalExtensions_143 */
static int hf_rrc_later_than_r3_20 = -1;          /* T_later_than_r3_20 */
static int hf_rrc_criticalExtensions_111 = -1;    /* T_criticalExtensions_110 */
static int hf_rrc_laterNonCriticalExtensions_49 = -1;  /* T_laterNonCriticalExtensions_49 */
static int hf_rrc_signallingConnectionReleaseIndication_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v860nonCriticalExtentions = -1;  /* T_v860nonCriticalExtentions */
static int hf_rrc_signallingConnectionReleaseIndication_v860ext = -1;  /* SignallingConnectionReleaseIndication_v860ext */
static int hf_rrc_nonCriticalExtensions_144 = -1;  /* T_nonCriticalExtensions_144 */
static int hf_rrc_signallingConnectionReleaseIndicationCause = -1;  /* T_signallingConnectionReleaseIndicationCause */
static int hf_rrc_sfn_Prime = -1;                 /* SFN_Prime */
static int hf_rrc_payload = -1;                   /* T_payload */
static int hf_rrc_noSegment = -1;                 /* NULL */
static int hf_rrc_firstSegment = -1;              /* FirstSegment */
static int hf_rrc_subsequentSegment = -1;         /* SubsequentSegment */
static int hf_rrc_lastSegmentShort = -1;          /* LastSegmentShort */
static int hf_rrc_lastAndFirst = -1;              /* T_lastAndFirst */
static int hf_rrc_firstSegment_01 = -1;           /* FirstSegmentShort */
static int hf_rrc_lastAndComplete = -1;           /* T_lastAndComplete */
static int hf_rrc_completeSIB_List = -1;          /* CompleteSIB_List */
static int hf_rrc_lastAndCompleteAndFirst = -1;   /* T_lastAndCompleteAndFirst */
static int hf_rrc_completeAndFirst = -1;          /* T_completeAndFirst */
static int hf_rrc_completeSIB = -1;               /* CompleteSIB */
static int hf_rrc_lastSegment = -1;               /* LastSegment */
static int hf_rrc_payload_01 = -1;                /* T_payload_01 */
static int hf_rrc_lastAndFirst_01 = -1;           /* T_lastAndFirst_01 */
static int hf_rrc_lastAndComplete_01 = -1;        /* T_lastAndComplete_01 */
static int hf_rrc_lastAndCompleteAndFirst_01 = -1;  /* T_lastAndCompleteAndFirst_01 */
static int hf_rrc_completeAndFirst_01 = -1;       /* T_completeAndFirst_01 */
static int hf_rrc_sib_Type = -1;                  /* SIB_Type */
static int hf_rrc_seg_Count = -1;                 /* SegCount */
static int hf_rrc_sib_Data_fixed = -1;            /* SIB_Data_fixed */
static int hf_rrc_sib_Data_variable = -1;         /* SIB_Data_variable */
static int hf_rrc_segmentIndex = -1;              /* SegmentIndex */
static int hf_rrc_CompleteSIB_List_item = -1;     /* CompleteSIBshort */
static int hf_rrc_sib_Data_fixed_01 = -1;         /* BIT_STRING_SIZE_226 */
static int hf_rrc_laterNonCriticalExtensions_50 = -1;  /* T_laterNonCriticalExtensions_50 */
static int hf_rrc_systemInformationChangeIndication_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_17 = -1;  /* T_v860NonCriticalExtensions_17 */
static int hf_rrc_systemInformationChangeIndication_v860ext = -1;  /* SystemInformationChangeIndication_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_145 = -1;  /* T_nonCriticalExtensions_145 */
static int hf_rrc_r3_24 = -1;                     /* T_r3_24 */
static int hf_rrc_transportChannelReconfiguration_r3 = -1;  /* TransportChannelReconfiguration_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_09 = -1;  /* T_v3a0NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v3a0ext = -1;  /* TransportChannelReconfiguration_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_51 = -1;  /* T_laterNonCriticalExtensions_51 */
static int hf_rrc_transportChannelReconfiguration_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_13 = -1;  /* T_v4b0NonCriticalExtensions_13 */
static int hf_rrc_transportChannelReconfiguration_v4b0ext = -1;  /* TransportChannelReconfiguration_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_24 = -1;  /* T_v590NonCriticalExtensions_24 */
static int hf_rrc_transportChannelReconfiguration_v590ext = -1;  /* TransportChannelReconfiguration_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_36 = -1;  /* T_v690NonCriticalExtensions_36 */
static int hf_rrc_transportChannelReconfiguration_v690ext = -1;  /* TransportChannelReconfiguration_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_25 = -1;  /* T_v770NonCriticalExtensions_25 */
static int hf_rrc_transportChannelReconfiguration_v770ext = -1;  /* TransportChannelReconfiguration_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_146 = -1;  /* T_nonCriticalExtensions_146 */
static int hf_rrc_later_than_r3_21 = -1;          /* T_later_than_r3_21 */
static int hf_rrc_criticalExtensions_112 = -1;    /* T_criticalExtensions_111 */
static int hf_rrc_r4_12 = -1;                     /* T_r4_12 */
static int hf_rrc_transportChannelReconfiguration_r4 = -1;  /* TransportChannelReconfiguration_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_12 = -1;  /* T_v4d0NonCriticalExtensions_12 */
static int hf_rrc_transportChannelReconfiguration_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_25 = -1;  /* T_v590NonCriticalExtensions_25 */
static int hf_rrc_v690NonCriticalExtensions_37 = -1;  /* T_v690NonCriticalExtensions_37 */
static int hf_rrc_v770NonCriticalExtensions_26 = -1;  /* T_v770NonCriticalExtensions_26 */
static int hf_rrc_nonCriticalExtensions_147 = -1;  /* T_nonCriticalExtensions_147 */
static int hf_rrc_criticalExtensions_113 = -1;    /* T_criticalExtensions_112 */
static int hf_rrc_r5_10 = -1;                     /* T_r5_10 */
static int hf_rrc_transportChannelReconfiguration_r5 = -1;  /* TransportChannelReconfiguration_r5_IEs */
static int hf_rrc_transportChannelReconfiguration_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_38 = -1;  /* T_v690NonCriticalExtensions_38 */
static int hf_rrc_v770NonCriticalExtensions_27 = -1;  /* T_v770NonCriticalExtensions_27 */
static int hf_rrc_nonCriticalExtensions_148 = -1;  /* T_nonCriticalExtensions_148 */
static int hf_rrc_criticalExtensions_114 = -1;    /* T_criticalExtensions_113 */
static int hf_rrc_r6_11 = -1;                     /* T_r6_11 */
static int hf_rrc_transportChannelReconfiguration_r6 = -1;  /* TransportChannelReconfiguration_r6_IEs */
static int hf_rrc_transportChannelReconfiguration_r6_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_12 = -1;  /* T_v6b0NonCriticalExtensions_11 */
static int hf_rrc_transportChannelReconfiguration_v6b0ext = -1;  /* TransportChannelReconfiguration_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_28 = -1;  /* T_v770NonCriticalExtensions_28 */
static int hf_rrc_nonCriticalExtensions_149 = -1;  /* T_nonCriticalExtensions_149 */
static int hf_rrc_criticalExtensions_115 = -1;    /* T_criticalExtensions_114 */
static int hf_rrc_r7_11 = -1;                     /* T_r7_11 */
static int hf_rrc_transportChannelReconfiguration_r7 = -1;  /* TransportChannelReconfiguration_r7_IEs */
static int hf_rrc_transportChannelReconfiguration_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_09 = -1;  /* T_v780NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v780ext = -1;  /* TransportChannelReconfiguration_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_13 = -1;  /* T_v7d0NonCriticalExtensions_13 */
static int hf_rrc_transportChannelReconfiguration_v7d0ext = -1;  /* TransportChannelReconfiguration_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_14 = -1;  /* T_v7f0NonCriticalExtensions_14 */
static int hf_rrc_transportChannelReconfiguration_v7f0ext = -1;  /* TransportChannelReconfiguration_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_15 = -1;  /* T_v7g0NonCriticalExtensions_15 */
static int hf_rrc_transportChannelReconfiguration_v7g0ext = -1;  /* TransportChannelReconfiguration_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_150 = -1;  /* T_nonCriticalExtensions_150 */
static int hf_rrc_criticalExtensions_116 = -1;    /* T_criticalExtensions_115 */
static int hf_rrc_r8_11 = -1;                     /* T_r8_11 */
static int hf_rrc_transportChannelReconfiguration_r8 = -1;  /* TransportChannelReconfiguration_r8_IEs */
static int hf_rrc_transportChannelReconfiguration_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_14 = -1;  /* T_v7d0NonCriticalExtensions_14 */
static int hf_rrc_v7f0NonCriticalExtensions_15 = -1;  /* T_v7f0NonCriticalExtensions_15 */
static int hf_rrc_v890NonCriticalExtensions_09 = -1;  /* T_v890NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v890ext = -1;  /* TransportChannelReconfiguration_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_16 = -1;  /* T_v7g0NonCriticalExtensions_16 */
static int hf_rrc_v8a0NonCriticalExtensions_09 = -1;  /* T_v8a0NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v8a0ext = -1;  /* TransportChannelReconfiguration_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_151 = -1;  /* T_nonCriticalExtensions_151 */
static int hf_rrc_criticalExtensions_117 = -1;    /* T_criticalExtensions_116 */
static int hf_rrc_r9_10 = -1;                     /* T_r9_10 */
static int hf_rrc_transportChannelReconfiguration_r9 = -1;  /* TransportChannelReconfiguration_r9_IEs */
static int hf_rrc_transportChannelReconfiguration_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_08 = -1;  /* T_v950NonCriticalExtensions_08 */
static int hf_rrc_transportChannelReconfiguration_v950ext = -1;  /* TransportChannelReconfiguration_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_10 = -1;  /* T_v9c0NonCriticalExtensions_10 */
static int hf_rrc_transportChannelReconfiguration_v9c0ext = -1;  /* TransportChannelReconfiguration_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_152 = -1;  /* T_nonCriticalExtensions_152 */
static int hf_rrc_criticalExtensions_118 = -1;    /* T_criticalExtensions_117 */
static int hf_rrc_r10_10 = -1;                    /* T_r10_10 */
static int hf_rrc_transportChannelReconfiguration_r10 = -1;  /* TransportChannelReconfiguration_r10_IEs */
static int hf_rrc_transportChannelReconfiguration_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_11 = -1;  /* T_v9c0NonCriticalExtensions_11 */
static int hf_rrc_vb50NonCriticalExtensions_19 = -1;  /* T_vb50NonCriticalExtensions_19 */
static int hf_rrc_transportChannelReconfiguration_vb50ext = -1;  /* TransportChannelReconfiguration_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_153 = -1;  /* T_nonCriticalExtensions_153 */
static int hf_rrc_criticalExtensions_119 = -1;    /* T_criticalExtensions_118 */
static int hf_rrc_r11_11 = -1;                    /* T_r11_11 */
static int hf_rrc_transportChannelReconfiguration_r11 = -1;  /* TransportChannelReconfiguration_r11_IEs */
static int hf_rrc_transportChannelReconfiguration_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_154 = -1;  /* T_nonCriticalExtensions_154 */
static int hf_rrc_criticalExtensions_120 = -1;    /* T_criticalExtensions_119 */
static int hf_rrc_dummy_27 = -1;                  /* T_dummy_11 */
static int hf_rrc_fdd_39 = -1;                    /* T_fdd_39 */
static int hf_rrc_modeSpecificPhysChInfo_12 = -1;  /* T_modeSpecificPhysChInfo_12 */
static int hf_rrc_fdd_40 = -1;                    /* T_fdd_40 */
static int hf_rrc_dummy_28 = -1;                  /* T_dummy_12 */
static int hf_rrc_fdd_41 = -1;                    /* T_fdd_41 */
static int hf_rrc_modeSpecificPhysChInfo_13 = -1;  /* T_modeSpecificPhysChInfo_13 */
static int hf_rrc_fdd_42 = -1;                    /* T_fdd_42 */
static int hf_rrc_dummy_29 = -1;                  /* T_dummy_13 */
static int hf_rrc_fdd_43 = -1;                    /* T_fdd_43 */
static int hf_rrc_modeSpecificPhysChInfo_14 = -1;  /* T_modeSpecificPhysChInfo_14 */
static int hf_rrc_fdd_44 = -1;                    /* T_fdd_44 */
static int hf_rrc_postVerificationPeriod_06 = -1;  /* T_postVerificationPeriod_06 */
static int hf_rrc_responseToChangeOfUE_Capability_10 = -1;  /* T_responseToChangeOfUE_Capability_10 */
static int hf_rrc_responseToChangeOfUE_Capability_11 = -1;  /* T_responseToChangeOfUE_Capability_11 */
static int hf_rrc_responseToChangeOfUE_Capability_12 = -1;  /* T_responseToChangeOfUE_Capability_12 */
static int hf_rrc_responseToChangeOfUE_Capability_13 = -1;  /* T_responseToChangeOfUE_Capability_13 */
static int hf_rrc_responseToChangeOfUE_Capability_14 = -1;  /* T_responseToChangeOfUE_Capability_14 */
static int hf_rrc_laterNonCriticalExtensions_52 = -1;  /* T_laterNonCriticalExtensions_52 */
static int hf_rrc_transportChannelReconfigurationComplete_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_29 = -1;  /* T_v770NonCriticalExtensions_29 */
static int hf_rrc_transportChannelReconfigurationComplete_v770ext = -1;  /* TransportChannelReconfigurationComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_155 = -1;  /* T_nonCriticalExtensions_155 */
static int hf_rrc_deferredMeasurementControlReading_05 = -1;  /* T_deferredMeasurementControlReading_05 */
static int hf_rrc_laterNonCriticalExtensions_53 = -1;  /* T_laterNonCriticalExtensions_53 */
static int hf_rrc_transportChannelReconfigurationFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_156 = -1;  /* T_nonCriticalExtensions_156 */
static int hf_rrc_modeSpecificInfo_15 = -1;       /* T_modeSpecificInfo_15 */
static int hf_rrc_fdd_45 = -1;                    /* NULL */
static int hf_rrc_tdd_10 = -1;                    /* T_tdd_09 */
static int hf_rrc_tfcs_ID = -1;                   /* TFCS_Identity */
static int hf_rrc_dpch_TFCS_InUplink = -1;        /* TFC_Subset */
static int hf_rrc_activationTimeForTFCSubset = -1;  /* ActivationTime */
static int hf_rrc_tfc_ControlDuration = -1;       /* TFC_ControlDuration */
static int hf_rrc_laterNonCriticalExtensions_54 = -1;  /* T_laterNonCriticalExtensions_54 */
static int hf_rrc_transportFormatCombinationControl_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v820NonCriticalExtensions_02 = -1;  /* T_v820NonCriticalExtensions_02 */
static int hf_rrc_transportformatcombinationcontrol_v820ext = -1;  /* TransportFormatCombinationControl_v820ext_IEs */
static int hf_rrc_nonCriticalExtensions_157 = -1;  /* T_nonCriticalExtensions_157 */
static int hf_rrc_ul_AMR_Rate = -1;               /* UL_AMR_Rate */
static int hf_rrc_laterNonCriticalExtensions_55 = -1;  /* T_laterNonCriticalExtensions_55 */
static int hf_rrc_transportFormatCombinationControlFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_158 = -1;  /* T_nonCriticalExtensions_158 */
static int hf_rrc_r3_25 = -1;                     /* T_r3_25 */
static int hf_rrc_ueCapabilityEnquiry_r3 = -1;    /* UECapabilityEnquiry_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_56 = -1;  /* T_laterNonCriticalExtensions_56 */
static int hf_rrc_ueCapabilityEnquiry_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_14 = -1;  /* T_v4b0NonCriticalExtensions_14 */
static int hf_rrc_ueCapabilityEnquiry_v4b0ext = -1;  /* UECapabilityEnquiry_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_26 = -1;  /* T_v590NonCriticalExtensions_26 */
static int hf_rrc_ueCapabilityEnquiry_v590ext = -1;  /* UECapabilityEnquiry_v590ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_30 = -1;  /* T_v770NonCriticalExtensions_30 */
static int hf_rrc_ueCapabilityEnquiry_v770ext = -1;  /* UECapabilityEnquiry_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_18 = -1;  /* T_v860NonCriticalExtensions_18 */
static int hf_rrc_ueCapabilityEnquiry_v860ext = -1;  /* UECapabilityEnquiry_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_159 = -1;  /* T_nonCriticalExtensions_159 */
static int hf_rrc_later_than_r3_22 = -1;          /* T_later_than_r3_22 */
static int hf_rrc_criticalExtensions_121 = -1;    /* T_criticalExtensions_120 */
static int hf_rrc_capabilityUpdateRequirement_05 = -1;  /* CapabilityUpdateRequirement_v770ext */
static int hf_rrc_capabilityUpdateRequirement_06 = -1;  /* CapabilityUpdateRequirement_v860ext */
static int hf_rrc_v370NonCriticalExtensions_01 = -1;  /* T_v370NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v370ext = -1;  /* UECapabilityInformation_v370ext */
static int hf_rrc_v380NonCriticalExtensions_01 = -1;  /* T_v380NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v380ext = -1;  /* UECapabilityInformation_v380ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_10 = -1;  /* T_v3a0NonCriticalExtensions_10 */
static int hf_rrc_ueCapabilityInformation_v3a0ext = -1;  /* UECapabilityInformation_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_57 = -1;  /* T_laterNonCriticalExtensions_57 */
static int hf_rrc_ueCapabilityInformation_r3_add_ext = -1;  /* T_ueCapabilityInformation_r3_add_ext */
static int hf_rrc_v4b0NonCriticalExtensions_15 = -1;  /* T_v4b0NonCriticalExtensions_15 */
static int hf_rrc_ueCapabilityInformation_v4b0ext = -1;  /* UECapabilityInformation_v4b0ext */
static int hf_rrc_v590NonCriticalExtensions_27 = -1;  /* T_v590NonCriticalExtensions_27 */
static int hf_rrc_ueCapabilityInformation_v590ext = -1;  /* UECapabilityInformation_v590ext */
static int hf_rrc_v5c0NonCriticalExtensions_01 = -1;  /* T_v5c0NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v5c0ext = -1;  /* UECapabilityInformation_v5c0ext */
static int hf_rrc_v690NonCriticalExtensions_39 = -1;  /* T_v690NonCriticalExtensions_39 */
static int hf_rrc_ueCapabilityInformation_v690ext = -1;  /* UECapabilityInformation_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_160 = -1;  /* T_nonCriticalExtensions_160 */
static int hf_rrc_ueCapabilityInformation_v650ext = -1;  /* UECapabilityInformation_v650ext_IEs */
static int hf_rrc_v680NonCriticalExtensions_01 = -1;  /* T_v680NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v680ext = -1;  /* UECapabilityInformation_v680ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_03 = -1;  /* T_v7e0NonCriticalExtensions_03 */
static int hf_rrc_ueCapabilityInformation_v7e0ext = -1;  /* UECapabilityInformation_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_16 = -1;  /* T_v7f0NonCriticalExtensions_16 */
static int hf_rrc_ueCapabilityInformation_v7f0ext = -1;  /* UECapabilityInformation_v7f0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_15 = -1;  /* T_va40NonCriticalExtensions_14 */
static int hf_rrc_ueCapabilityInformation_va40ext = -1;  /* UECapabilityInformation_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_161 = -1;  /* T_nonCriticalExtensions_161 */
static int hf_rrc_ueCapabilityContainer_01 = -1;  /* T_ueCapabilityContainer_01 */
static int hf_rrc_r3_26 = -1;                     /* T_r3_26 */
static int hf_rrc_ueCapabilityInformationConfirm_r3 = -1;  /* UECapabilityInformationConfirm_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_58 = -1;  /* T_laterNonCriticalExtensions_58 */
static int hf_rrc_ueCapabilityInformationConfirm_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_31 = -1;  /* T_v770NonCriticalExtensions_31 */
static int hf_rrc_ueCapabilityInformationConfirm_v770ext = -1;  /* UECapabilityInformationConfirm_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_162 = -1;  /* T_nonCriticalExtensions_162 */
static int hf_rrc_later_than_r3_23 = -1;          /* T_later_than_r3_23 */
static int hf_rrc_criticalExtensions_122 = -1;    /* T_criticalExtensions_121 */
static int hf_rrc_acceptanceOfChangeOfCapability = -1;  /* T_acceptanceOfChangeOfCapability */
static int hf_rrc_laterNonCriticalExtensions_59 = -1;  /* T_laterNonCriticalExtensions_59 */
static int hf_rrc_uplinkDirectTransfer_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_40 = -1;  /* T_v690NonCriticalExtensions_40 */
static int hf_rrc_uplinkDirectTransfer_v690ext = -1;  /* UplinkDirectTransfer_v690ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_17 = -1;  /* T_v7g0NonCriticalExtensions_17 */
static int hf_rrc_uplinkDirectTransfer_v7g0ext = -1;  /* UplinkDirectTransfer_v7g0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_20 = -1;  /* T_vb50NonCriticalExtensions_20 */
static int hf_rrc_uplinkDirectTransfer_vb50ext = -1;  /* UplinkDirectTransfer_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_163 = -1;  /* T_nonCriticalExtensions_163 */
static int hf_rrc_r3_27 = -1;                     /* T_r3_27 */
static int hf_rrc_uplinkPhysicalChannelControl_r3 = -1;  /* UplinkPhysicalChannelControl_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_60 = -1;  /* T_laterNonCriticalExtensions_60 */
static int hf_rrc_uplinkPhysicalChannelControl_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_16 = -1;  /* T_v4b0NonCriticalExtensions_16 */
static int hf_rrc_uplinkPysicalChannelControl_v4b0ext = -1;  /* UplinkPhysicalChannelControl_v4b0ext_IEs */
static int hf_rrc_noncriticalExtensions = -1;     /* T_noncriticalExtensions */
static int hf_rrc_later_than_r3_24 = -1;          /* T_later_than_r3_24 */
static int hf_rrc_criticalExtensions_123 = -1;    /* T_criticalExtensions_122 */
static int hf_rrc_r4_13 = -1;                     /* T_r4_13 */
static int hf_rrc_uplinkPhysicalChannelControl_r4 = -1;  /* UplinkPhysicalChannelControl_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_13 = -1;  /* T_v4d0NonCriticalExtensions_13 */
static int hf_rrc_uplinkPhysicalChannelControl_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_41 = -1;  /* T_v690NonCriticalExtensions_41 */
static int hf_rrc_uplinkPhysicalChannelControl_v690ext = -1;  /* UplinkPhysicalChannelControl_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_164 = -1;  /* T_nonCriticalExtensions_164 */
static int hf_rrc_criticalExtensions_124 = -1;    /* T_criticalExtensions_123 */
static int hf_rrc_r5_11 = -1;                     /* T_r5_11 */
static int hf_rrc_uplinkPhysicalChannelControl_r5 = -1;  /* UplinkPhysicalChannelControl_r5_IEs */
static int hf_rrc_uplinkPhysicalChannelControl_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_42 = -1;  /* T_v690NonCriticalExtensions_42 */
static int hf_rrc_v6a0NonCriticalExtensions_01 = -1;  /* T_v6a0NonCriticalExtensions_01 */
static int hf_rrc_uplinkPhysicalChannelControl_v6a0ext = -1;  /* UplinkPhysicalChannelControl_v6a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_165 = -1;  /* T_nonCriticalExtensions_165 */
static int hf_rrc_criticalExtensions_125 = -1;    /* T_criticalExtensions_124 */
static int hf_rrc_r7_12 = -1;                     /* T_r7_12 */
static int hf_rrc_uplinkPhysicalChannelControl_r7 = -1;  /* UplinkPhysicalChannelControl_r7_IEs */
static int hf_rrc_uplinkPhysicalChannelControl_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_166 = -1;  /* T_nonCriticalExtensions_166 */
static int hf_rrc_criticalExtensions_126 = -1;    /* T_criticalExtensions_125 */
static int hf_rrc_ccTrCH_PowerControlInfo = -1;   /* CCTrCH_PowerControlInfo */
static int hf_rrc_timingAdvance = -1;             /* UL_TimingAdvanceControl */
static int hf_rrc_alpha = -1;                     /* Alpha */
static int hf_rrc_specialBurstScheduling = -1;    /* SpecialBurstScheduling */
static int hf_rrc_prach_ConstantValue = -1;       /* ConstantValueTdd */
static int hf_rrc_pusch_ConstantValue = -1;       /* ConstantValueTdd */
static int hf_rrc_openLoopPowerControl_IPDL_TDD = -1;  /* OpenLoopPowerControl_IPDL_TDD_r4 */
static int hf_rrc_ccTrCH_PowerControlInfo_01 = -1;  /* CCTrCH_PowerControlInfo_r4 */
static int hf_rrc_tddOption = -1;                 /* T_tddOption */
static int hf_rrc_tdd384_08 = -1;                 /* T_tdd384_08 */
static int hf_rrc_timingAdvance_01 = -1;          /* UL_TimingAdvanceControl_r4 */
static int hf_rrc_tdd128_08 = -1;                 /* T_tdd128_08 */
static int hf_rrc_ul_SynchronisationParameters = -1;  /* UL_SynchronisationParameters_r4 */
static int hf_rrc_ccTrCH_PowerControlInfo_02 = -1;  /* CCTrCH_PowerControlInfo_r5 */
static int hf_rrc_tddOption_01 = -1;              /* T_tddOption_01 */
static int hf_rrc_tdd384_09 = -1;                 /* T_tdd384_09 */
static int hf_rrc_hs_SICH_PowerControl = -1;      /* HS_SICH_Power_Control_Info_TDD384 */
static int hf_rrc_tdd128_09 = -1;                 /* T_tdd128_09 */
static int hf_rrc_desired_HS_SICH_PowerLevel = -1;  /* INTEGER_M120_M58 */
static int hf_rrc_tpc_Step_Size = -1;             /* T_tpc_Step_Size */
static int hf_rrc_ccTrCH_PowerControlInfo_03 = -1;  /* CCTrCH_PowerControlInfo_r7 */
static int hf_rrc_tddOption_02 = -1;              /* T_tddOption_02 */
static int hf_rrc_tdd384_10 = -1;                 /* T_tdd384_10 */
static int hf_rrc_tdd768_05 = -1;                 /* T_tdd768_05 */
static int hf_rrc_timingAdvance_02 = -1;          /* UL_TimingAdvanceControl_r7 */
static int hf_rrc_hs_SICH_PowerControl_01 = -1;   /* HS_SICH_Power_Control_Info_TDD768 */
static int hf_rrc_tdd128_10 = -1;                 /* T_tdd128_10 */
static int hf_rrc_tpc_Step_Size_01 = -1;          /* T_tpc_Step_Size_01 */
static int hf_rrc_ura_UpdateCause = -1;           /* URA_UpdateCause */
static int hf_rrc_laterNonCriticalExtensions_61 = -1;  /* T_laterNonCriticalExtensions_61 */
static int hf_rrc_uraUpdate_r3_add_ext = -1;      /* T_uraUpdate_r3_add_ext */
static int hf_rrc_v770NonCriticalExtensions_32 = -1;  /* T_v770NonCriticalExtensions_32 */
static int hf_rrc_uraUpdate_v770ext = -1;         /* UraUpdate_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_19 = -1;  /* T_v860NonCriticalExtensions_19 */
static int hf_rrc_uraUpdate_v860ext = -1;         /* URAUpdate_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_16 = -1;  /* T_va40NonCriticalExtensions_15 */
static int hf_rrc_uraUpdate_va40ext = -1;         /* URAUpdate_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_167 = -1;  /* T_nonCriticalExtensions_167 */
static int hf_rrc_uraUpdate_v7e0ext = -1;         /* URAUpdate_v7e0ext_IEs */
static int hf_rrc_nonCriticalExtensions_168 = -1;  /* T_nonCriticalExtensions_168 */
static int hf_rrc_support_hsdschReception_CellUraPch = -1;  /* T_support_hsdschReception_CellUraPch */
static int hf_rrc_support_hsdschReception_CellFach = -1;  /* T_support_hsdschReception_CellFach */
static int hf_rrc_supportForTwoDRXSchemesInPCH_01 = -1;  /* T_supportForTwoDRXSchemesInPCH_01 */
static int hf_rrc_supportOfHS_DSCHDRXOperation_02 = -1;  /* T_supportOfHS_DSCHDRXOperation_02 */
static int hf_rrc_supportOfCommonEDCH_03 = -1;    /* T_supportOfCommonEDCH_03 */
static int hf_rrc_supportOfMACiis_03 = -1;        /* T_supportOfMACiis_03 */
static int hf_rrc_loggedMeasAvailable_05 = -1;    /* T_loggedMeasAvailable_05 */
static int hf_rrc_loggedANRResultsAvailable_04 = -1;  /* T_loggedANRResultsAvailable_04 */
static int hf_rrc_r3_28 = -1;                     /* T_r3_28 */
static int hf_rrc_uraUpdateConfirm_r3 = -1;       /* URAUpdateConfirm_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_62 = -1;  /* T_laterNonCriticalExtensions_62 */
static int hf_rrc_uraUpdateConfirm_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_43 = -1;  /* T_v690NonCriticalExtensions_43 */
static int hf_rrc_uraUpdateConfirm_v690ext = -1;  /* URAUpdateConfirm_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_169 = -1;  /* T_nonCriticalExtensions_169 */
static int hf_rrc_later_than_r3_25 = -1;          /* T_later_than_r3_25 */
static int hf_rrc_criticalExtensions_127 = -1;    /* T_criticalExtensions_126 */
static int hf_rrc_r5_12 = -1;                     /* T_r5_12 */
static int hf_rrc_uraUpdateConfirm_r5 = -1;       /* URAUpdateConfirm_r5_IEs */
static int hf_rrc_v690NonCriticalExtensions_44 = -1;  /* T_v690NonCriticalExtensions_44 */
static int hf_rrc_nonCriticalExtensions_170 = -1;  /* T_nonCriticalExtensions_170 */
static int hf_rrc_criticalExtensions_128 = -1;    /* T_criticalExtensions_127 */
static int hf_rrc_r7_13 = -1;                     /* T_r7_13 */
static int hf_rrc_uraUpdateConfirm_r7 = -1;       /* URAUpdateConfirm_r7_IEs */
static int hf_rrc_uraUpdateConfirm_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_20 = -1;  /* T_v860NonCriticalExtensions_20 */
static int hf_rrc_uraUpdateConfirm_v860ext = -1;  /* URAUpdateConfirm_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_171 = -1;  /* T_nonCriticalExtensions_171 */
static int hf_rrc_criticalExtensions_129 = -1;    /* T_criticalExtensions_128 */
static int hf_rrc_r3_29 = -1;                     /* T_r3_29 */
static int hf_rrc_uraUpdateConfirm_CCCH_r3 = -1;  /* URAUpdateConfirm_CCCH_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_63 = -1;  /* T_laterNonCriticalExtensions_63 */
static int hf_rrc_uraUpdateConfirm_CCCH_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_45 = -1;  /* T_v690NonCriticalExtensions_45 */
static int hf_rrc_v860NonCriticalExtensions_21 = -1;  /* T_v860NonCriticalExtensions_21 */
static int hf_rrc_nonCriticalExtensions_172 = -1;  /* T_nonCriticalExtensions_172 */
static int hf_rrc_later_than_r3_26 = -1;          /* T_later_than_r3_26 */
static int hf_rrc_criticalExtensions_130 = -1;    /* T_criticalExtensions_129 */
static int hf_rrc_uraUpdateConfirm_02 = -1;       /* URAUpdateConfirm_r3_IEs */
static int hf_rrc_r3_30 = -1;                     /* T_r3_30 */
static int hf_rrc_utranMobilityInformation_r3 = -1;  /* UTRANMobilityInformation_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_11 = -1;  /* T_v3a0NonCriticalExtensions_11 */
static int hf_rrc_utranMobilityInformation_v3a0ext = -1;  /* UTRANMobilityInformation_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_64 = -1;  /* T_laterNonCriticalExtensions_64 */
static int hf_rrc_utranMobilityInformation_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_46 = -1;  /* T_v690NonCriticalExtensions_46 */
static int hf_rrc_utranMobilityInformation_v690ext = -1;  /* UtranMobilityInformation_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtentions = -1;  /* T_v860NonCriticalExtentions */
static int hf_rrc_utranMobilityInformation_v860ext = -1;  /* UTRANMobilityInformation_v860ext1_IEs */
static int hf_rrc_nonCriticalExtensions_173 = -1;  /* T_nonCriticalExtensions_173 */
static int hf_rrc_later_than_r3_27 = -1;          /* T_later_than_r3_27 */
static int hf_rrc_criticalExtensions_131 = -1;    /* T_criticalExtensions_130 */
static int hf_rrc_r5_13 = -1;                     /* T_r5_13 */
static int hf_rrc_utranMobilityInformation_r5 = -1;  /* UTRANMobilityInformation_r5_IEs */
static int hf_rrc_v690NonCriticalExtensions_47 = -1;  /* T_v690NonCriticalExtensions_47 */
static int hf_rrc_v860NonCriticalExtentions_01 = -1;  /* T_v860NonCriticalExtentions_01 */
static int hf_rrc_nonCriticalExtensions_174 = -1;  /* T_nonCriticalExtensions_174 */
static int hf_rrc_criticalExtensions_132 = -1;    /* T_criticalExtensions_131 */
static int hf_rrc_r7_14 = -1;                     /* T_r7_14 */
static int hf_rrc_utranMobilityInformation_r7 = -1;  /* UTRANMobilityInformation_r7_IEs */
static int hf_rrc_utranMobilityInformation_r7_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_22 = -1;  /* T_v860NonCriticalExtensions_22 */
static int hf_rrc_utranMobilityInformation_v860ext_01 = -1;  /* UTRANMobilityInformation_v860ext2_IEs */
static int hf_rrc_vb50NonCriticalExtentions = -1;  /* T_vb50NonCriticalExtentions */
static int hf_rrc_utranMobilityInformation_vb50ext = -1;  /* UTRANMobilityInformation_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_175 = -1;  /* T_nonCriticalExtensions_175 */
static int hf_rrc_criticalExtensions_133 = -1;    /* T_criticalExtensions_132 */
static int hf_rrc_r11_12 = -1;                    /* T_r11_12 */
static int hf_rrc_utranMobilityInformation_r11 = -1;  /* UTRANMobilityInformation_r11_IEs */
static int hf_rrc_utranMobilityInformation_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_176 = -1;  /* T_nonCriticalExtensions_176 */
static int hf_rrc_criticalExtensions_134 = -1;    /* T_criticalExtensions_133 */
static int hf_rrc_ue_ConnTimersAndConstants = -1;  /* UE_ConnTimersAndConstants */
static int hf_rrc_cn_InformationInfo_02 = -1;     /* CN_InformationInfoFull */
static int hf_rrc_nonCriticalExtensions_177 = -1;  /* T_nonCriticalExtensions_177 */
static int hf_rrc_ue_ConnTimersAndConstants_v3a0ext = -1;  /* UE_ConnTimersAndConstants_v3a0ext */
static int hf_rrc_ue_ConnTimersAndConstants_01 = -1;  /* UE_ConnTimersAndConstants_r5 */
static int hf_rrc_ue_ConnTimersAndConstants_02 = -1;  /* UE_ConnTimersAndConstants_v860ext */
static int hf_rrc_dedicatedPriorityInformation = -1;  /* DedicatedPriorityInformation */
static int hf_rrc_dedicatedPriorityInformation_01 = -1;  /* DedicatedPriorityInformation_r11 */
static int hf_rrc_ue_ConnTimersAndConstants_03 = -1;  /* UE_ConnTimersAndConstants_r11 */
static int hf_rrc_laterNonCriticalExtensions_65 = -1;  /* T_laterNonCriticalExtensions_65 */
static int hf_rrc_utranMobilityInformationConfirm_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtension_01 = -1;  /* T_v770NonCriticalExtension_01 */
static int hf_rrc_utranMobilityInformationConfirm_v770ext = -1;  /* UTRANMobilityInformationConfirm_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_17 = -1;  /* T_va40NonCriticalExtensions_16 */
static int hf_rrc_utranMobilityInformationConfirm_va40ext = -1;  /* UTRANMobilityInformationConfirm_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_178 = -1;  /* T_nonCriticalExtensions_178 */
static int hf_rrc_deferredMeasurementControlReading_06 = -1;  /* T_deferredMeasurementControlReading_06 */
static int hf_rrc_loggedMeasAvailable_06 = -1;    /* T_loggedMeasAvailable_06 */
static int hf_rrc_laterNonCriticalExtensions_66 = -1;  /* T_laterNonCriticalExtensions_66 */
static int hf_rrc_utranMobilityInformationFailure_r3_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_179 = -1;  /* T_nonCriticalExtensions_179 */
static int hf_rrc_mbms_ServiceAccessInfoList = -1;  /* MBMS_ServiceAccessInfoList_r6 */
static int hf_rrc_nonCriticalExtensions_180 = -1;  /* T_nonCriticalExtensions_180 */
static int hf_rrc_mbms_CommonRBInformationList = -1;  /* MBMS_CommonRBInformationList_r6 */
static int hf_rrc_mbms_TranspChInfoForEachTrCh = -1;  /* MBMS_TranspChInfoForEachTrCh_r6 */
static int hf_rrc_mbms_TranspChInfoForEachCCTrCh = -1;  /* MBMS_TranspChInfoForEachCCTrCh_r6 */
static int hf_rrc_mbms_PhyChInformationList = -1;  /* MBMS_PhyChInformationList_r6 */
static int hf_rrc_v770NonCriticalExtensions_33 = -1;  /* T_v770NonCriticalExtensions_33 */
static int hf_rrc_mbmsCommonPTMRBInformation_v770ext = -1;  /* MBMSCommonPTMRBInformation_v770ext_IEs */
static int hf_rrc_v780NonCriticalExtensions_10 = -1;  /* T_v780NonCriticalExtensions_10 */
static int hf_rrc_mbmsCommonPTMRBInformation_v780ext = -1;  /* MBMSCommonPTMRBInformation_v780ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_23 = -1;  /* T_v860NonCriticalExtensions_23 */
static int hf_rrc_mbmsCommonPTMRBInformation_v860ext = -1;  /* MBMSCommonPTMRBInformation_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_181 = -1;  /* T_nonCriticalExtensions_181 */
static int hf_rrc_mbms_PhyChInformationList_r7 = -1;  /* MBMS_PhyChInformationList_r7 */
static int hf_rrc_mbsfn_TDDInformation_LCR = -1;  /* MBSFN_TDDInformation_LCR */
static int hf_rrc_mbms_PhyChInformationList_01 = -1;  /* MBMS_PhyChInformationList_IMB384 */
static int hf_rrc_mbms_CurrentCell_SCCPCHList = -1;  /* MBMS_CurrentCell_SCCPCHList_r6 */
static int hf_rrc_mbms_SIBType5_SCCPCHList = -1;  /* MBMS_SIBType5_SCCPCHList_r6 */
static int hf_rrc_v770NonCriticalExtensions_34 = -1;  /* T_v770NonCriticalExtensions_34 */
static int hf_rrc_mbmsCurrentCellPTMRBInfo_v770ext = -1;  /* MBMSCurrentCellPTMRBInfo_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_182 = -1;  /* T_nonCriticalExtensions_182 */
static int hf_rrc_mbsfn_TDM_Info_List = -1;       /* MBSFN_TDM_Info_List */
static int hf_rrc_mbms_PreferredFrequencyInfo = -1;  /* MBMS_PreferredFrequencyList_r6 */
static int hf_rrc_mbms_TimersAndCounters = -1;    /* MBMS_TimersAndCounters_r6 */
static int hf_rrc_michConfigurationInfo = -1;     /* MBMS_MICHConfigurationInfo_r6 */
static int hf_rrc_cellGroupIdentity = -1;         /* MBMS_CellGroupIdentity_r6 */
static int hf_rrc_mschDefaultConfigurationInfo = -1;  /* MBMS_MSCH_ConfigurationInfo_r6 */
static int hf_rrc_v6b0NonCriticalExtensions_13 = -1;  /* T_v6b0NonCriticalExtensions_12 */
static int hf_rrc_mbmsGeneralInformation_v6b0ext = -1;  /* MBMSGeneralInformation_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_35 = -1;  /* T_v770NonCriticalExtensions_35 */
static int hf_rrc_mbmsGeneralInformation_v770ext = -1;  /* MBMSGeneralInformation_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_24 = -1;  /* T_v860NonCriticalExtensions_24 */
static int hf_rrc_mbmsGeneralInformation_v860ext = -1;  /* MBMSGeneralInformation_v860ext_IEs */
static int hf_rrc_v890NoncriticalExtensions = -1;  /* T_v890NoncriticalExtensions */
static int hf_rrc_mbmsGeneralInformation_v890ext = -1;  /* MBMSGeneralInformation_v890ext_IEs */
static int hf_rrc_nonCriticalExtensions_183 = -1;  /* T_nonCriticalExtensions_183 */
static int hf_rrc_indicateChangeInSelectedServices = -1;  /* BOOLEAN */
static int hf_rrc_mbmsMICHConfiguration = -1;     /* MBMS_MICHConfigurationInfo_v770ext */
static int hf_rrc_mbsfnInterFrequencyNeighbourList = -1;  /* MBSFN_InterFrequencyNeighbourList_r7 */
static int hf_rrc_mbsfnInterFrequencyNeighbourList_01 = -1;  /* MBSFN_InterFrequencyNeighbourList_v860ext */
static int hf_rrc_mbmsNetworkStandardTimeInformation_LCR = -1;  /* MBMS_NetworkStandardTimeInformation_LCR_v890ext */
static int hf_rrc_mbmsMICHConfiguration_01 = -1;  /* MBMS_MICHConfigurationInfo_v890ext */
static int hf_rrc_mbms_PreferredFreqRequest = -1;  /* MBMS_ServiceIdentity_r6 */
static int hf_rrc_v6b0NonCriticalExtensions_14 = -1;  /* T_v6b0NonCriticalExtensions_13 */
static int hf_rrc_mbmsModificationRequest_v6b0ext = -1;  /* MBMSModificationRequest_v6b0ext_IEs */
static int hf_rrc_v6f0NonCriticalExtensions_02 = -1;  /* T_v6f0NonCriticalExtensions_02 */
static int hf_rrc_mbmsModificationRequest_v6f0ext = -1;  /* MBMSModificationRequest_v6f0ext_IEs */
static int hf_rrc_nonCriticalExtensions_184 = -1;  /* T_nonCriticalExtensions_184 */
static int hf_rrc_mbmsSelectedServiceInfo = -1;   /* MBMS_SelectedServiceInfo */
static int hf_rrc_mbmsSupportOfServiceChangeForAPtpRB = -1;  /* T_mbmsSupportOfServiceChangeForAPtpRB */
static int hf_rrc_modifedServiceList = -1;        /* MBMS_ModifedServiceList_r6 */
static int hf_rrc_mbms_ReacquireMCCH = -1;        /* T_mbms_ReacquireMCCH */
static int hf_rrc_mbms_DynamicPersistenceLevel = -1;  /* DynamicPersistenceLevel */
static int hf_rrc_endOfModifiedMCCHInformation = -1;  /* INTEGER_1_16 */
static int hf_rrc_mbmsNumberOfNeighbourCells = -1;  /* MBMS_NumberOfNeighbourCells_r6 */
static int hf_rrc_mbms_AllUnmodifiedPTMServices = -1;  /* T_mbms_AllUnmodifiedPTMServices */
static int hf_rrc_mbms_PTMActivationTime = -1;    /* MBMS_PTMActivationTime_r6 */
static int hf_rrc_v770NonCriticalExtensions_36 = -1;  /* T_v770NonCriticalExtensions_36 */
static int hf_rrc_mbmsModifiedServicesInformation_v770ext = -1;  /* MBMSModifiedServicesInformation_v770ext_IEs */
static int hf_rrc_v7c0NonCriticalExtensions = -1;  /* T_v7c0NonCriticalExtensions */
static int hf_rrc_mbmsModifiedServicesInformation_v7c0ext = -1;  /* MBMSModifiedServicesInformation_v7c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_185 = -1;  /* T_nonCriticalExtensions_185 */
static int hf_rrc_modifiedServiceList = -1;       /* MBMS_ModifiedServiceList_v770ext */
static int hf_rrc_mib_ValueTag = -1;              /* MIB_ValueTag */
static int hf_rrc_modifiedServiceList_01 = -1;    /* MBMS_ModifiedServiceList_LCR_v7c0ext */
static int hf_rrc_neighbouringCellIdentity = -1;  /* IntraFreqCellID */
static int hf_rrc_neighbouringCellSCCPCHList = -1;  /* MBMS_NeighbouringCellSCCPCHList_r6 */
static int hf_rrc_v770NonCriticalExtensions_37 = -1;  /* T_v770NonCriticalExtensions_37 */
static int hf_rrc_mbmsNeighbouringCellPTMRBInformation_v770ext = -1;  /* MBMSNeighbouringCellPTMRBInformation_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_186 = -1;  /* T_nonCriticalExtensions_186 */
static int hf_rrc_neighbouringCellSCCPCHList_01 = -1;  /* MBMS_NeighbouringCellSCCPCHList_v770ext */
static int hf_rrc_serviceSchedulingInfoList = -1;  /* MBMS_ServiceSchedulingInfoList_r6 */
static int hf_rrc_nonCriticalExtensions_187 = -1;  /* T_nonCriticalExtensions_187 */
static int hf_rrc_unmodifiedServiceList = -1;     /* MBMS_UnmodifiedServiceList_r6 */
static int hf_rrc_v770NonCriticalExtensions_38 = -1;  /* T_v770NonCriticalExtensions_38 */
static int hf_rrc_mbmsUnmodifiedServicesInformation_v770ext = -1;  /* MBMSUnmodifiedServicesInformation_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_188 = -1;  /* T_nonCriticalExtensions_188 */
static int hf_rrc_unmodifiedServiceList_01 = -1;  /* MBMS_UnmodifiedServiceList_v770ext */
static int hf_rrc_mib = -1;                       /* T_mib */
static int hf_rrc_sysInfoTypeSB1 = -1;            /* T_sysInfoTypeSB1 */
static int hf_rrc_sysInfoTypeSB2 = -1;            /* T_sysInfoTypeSB2 */
static int hf_rrc_sysInfoType1 = -1;              /* T_sysInfoType1 */
static int hf_rrc_sysInfoType3 = -1;              /* T_sysInfoType3 */
static int hf_rrc_sysInfoType5 = -1;              /* T_sysInfoType5 */
static int hf_rrc_sysInfoType7 = -1;              /* T_sysInfoType7 */
static int hf_rrc_sysInfoType11 = -1;             /* T_sysInfoType11 */
static int hf_rrc_sysInfoType11bis = -1;          /* T_sysInfoType11bis */
static int hf_rrc_sysInfoType12 = -1;             /* T_sysInfoType12 */
static int hf_rrc_vb50NonCriticalExtensions_21 = -1;  /* T_vb50NonCriticalExtensions_21 */
static int hf_rrc_system_Information_Container_vb50ext = -1;  /* System_Information_Container_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_189 = -1;  /* T_nonCriticalExtensions_189 */
static int hf_rrc_sysInfoType22 = -1;             /* T_sysInfoType22 */
static int hf_rrc_criticalExtensions_135 = -1;    /* T_criticalExtensions_134 */
static int hf_rrc_r10_11 = -1;                    /* T_r10_11 */
static int hf_rrc_loggingMeasurementConfiguration_r10_IEs = -1;  /* LoggingMeasurementConfiguration_r10_IEs */
static int hf_rrc_loggingMeasurementConfiguration_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_190 = -1;  /* T_nonCriticalExtensions_190 */
static int hf_rrc_criticalExtensions_136 = -1;    /* T_criticalExtensions_135 */
static int hf_rrc_r11_13 = -1;                    /* T_r11_13 */
static int hf_rrc_loggingMeasurementConfiguration_r11_IEs = -1;  /* LoggingMeasurementConfiguration_r11_IEs */
static int hf_rrc_loggingMeasurementConfiguration_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_191 = -1;  /* T_nonCriticalExtensions_191 */
static int hf_rrc_criticalExtensions_137 = -1;    /* T_criticalExtensions_136 */
static int hf_rrc_loggedMeasurementsConfigurationInfo = -1;  /* LoggedMeasurementsConfigurationInfo */
static int hf_rrc_loggedANRConfigurationInfo = -1;  /* LoggedANRConfigurationInfo */
static int hf_rrc_loggedMeasurementsConfigurationInfo_01 = -1;  /* LoggedMeasurementsConfigurationInfo_r11 */
static int hf_rrc_loggedMeasReport = -1;          /* LoggedMeasReport */
static int hf_rrc_loggedANRReportInfoList = -1;   /* LoggedANRReportInfoList */
static int hf_rrc_vb50NonCriticalExtensions_22 = -1;  /* T_vb50NonCriticalExtensions_22 */
static int hf_rrc_ueInformationResponse_vb50ext = -1;  /* UEInformationResponse_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_192 = -1;  /* T_nonCriticalExtensions_192 */
static int hf_rrc_loggedMeasReport_01 = -1;       /* LoggedMeasReport_vb50ext */
static int hf_rrc_connectionEstablishmentFailureReport = -1;  /* ConnectionEstablishmentFailureReport */
static int hf_rrc_loggedANRReportInfoList_01 = -1;  /* LoggedANRReportInfoList_vb50ext */
static int hf_rrc_criticalExtensions_138 = -1;    /* T_criticalExtensions_137 */
static int hf_rrc_r10_12 = -1;                    /* T_r10_12 */
static int hf_rrc_ueInformationRequest_r10 = -1;  /* UEInformationRequest_r10_IEs */
static int hf_rrc_ueInformationRequest_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_193 = -1;  /* T_nonCriticalExtensions_193 */
static int hf_rrc_criticalExtensions_139 = -1;    /* T_criticalExtensions_138 */
static int hf_rrc_r11_14 = -1;                    /* T_r11_14 */
static int hf_rrc_ueInformationRequest_r11 = -1;  /* UEInformationRequest_r11_IEs */
static int hf_rrc_ueInformationRequest_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_194 = -1;  /* T_nonCriticalExtensions_194 */
static int hf_rrc_criticalExtensions_140 = -1;    /* T_criticalExtensions_139 */
static int hf_rrc_loggedMeasReportRequest = -1;   /* T_loggedMeasReportRequest */
static int hf_rrc_loggedANRReportRequest = -1;    /* T_loggedANRReportRequest */
static int hf_rrc_loggedMeasReportRequest_01 = -1;  /* T_loggedMeasReportRequest_01 */
static int hf_rrc_loggedANRReportRequest_01 = -1;  /* T_loggedANRReportRequest_01 */
static int hf_rrc_connectionEstablishmentFailureRequest = -1;  /* T_connectionEstablishmentFailureRequest */
static int hf_rrc_cn_DomainSpecificNAS_Info = -1;  /* NAS_SystemInformationGSM_MAP */
static int hf_rrc_cn_DRX_CycleLengthCoeff = -1;   /* CN_DRX_CycleLengthCoefficient */
static int hf_rrc_CN_DomainInformationList_item = -1;  /* CN_DomainInformation */
static int hf_rrc_CN_DomainInformationListFull_item = -1;  /* CN_DomainInformationFull */
static int hf_rrc_cn_Type = -1;                   /* T_cn_Type */
static int hf_rrc_gsm_MAP = -1;                   /* NAS_SystemInformationGSM_MAP */
static int hf_rrc_ansi_41 = -1;                   /* NAS_SystemInformationANSI_41 */
static int hf_rrc_CN_DomainSysInfoList_item = -1;  /* CN_DomainSysInfo */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo = -1;  /* T_cn_CommonGSM_MAP_NAS_SysInfo */
static int hf_rrc_cn_DomainInformationList = -1;  /* CN_DomainInformationList */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_01 = -1;  /* T_cn_CommonGSM_MAP_NAS_SysInfo_01 */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_02 = -1;  /* T_cn_CommonGSM_MAP_NAS_SysInfo_02 */
static int hf_rrc_cn_DomainInformationListFull = -1;  /* CN_DomainInformationListFull */
static int hf_rrc_cs_DomainSpecificEAB_Parameters = -1;  /* EAB_Configuration */
static int hf_rrc_ps_DomainSpecificEAB_Parameters = -1;  /* EAB_Configuration */
static int hf_rrc_commonEAB_Parameters = -1;      /* EAB_Configuration */
static int hf_rrc_EAB_AccessClassBarredList_item = -1;  /* AccessClassBarred */
static int hf_rrc_eab_Category = -1;              /* T_eab_Category */
static int hf_rrc_eab_AccessClassBarredList = -1;  /* EAB_AccessClassBarredList */
static int hf_rrc_eab_ParametersPerPLMN_List = -1;  /* EAB_ParametersPerPLMN_List */
static int hf_rrc_eab_ParametersForAll = -1;      /* DomainSpecificEAB_Parameters */
static int hf_rrc_domainSpecificEAB_Parameters = -1;  /* DomainSpecificEAB_Parameters */
static int hf_rrc_EAB_ParametersPerPLMN_List_item = -1;  /* EAB_ParametersPerPLMN */
static int hf_rrc_ec_N0 = -1;                     /* INTEGER_M24_0 */
static int hf_rrc_routingbasis = -1;              /* T_routingbasis */
static int hf_rrc_localPTMSI = -1;                /* T_localPTMSI */
static int hf_rrc_routingparameter = -1;          /* RoutingParameter */
static int hf_rrc_tMSIofsamePLMN = -1;            /* T_tMSIofsamePLMN */
static int hf_rrc_tMSIofdifferentPLMN = -1;       /* T_tMSIofdifferentPLMN */
static int hf_rrc_iMSIresponsetopaging = -1;      /* T_iMSIresponsetopaging */
static int hf_rrc_iMSIcauseUEinitiatedEvent = -1;  /* T_iMSIcauseUEinitiatedEvent */
static int hf_rrc_iMEI = -1;                      /* T_iMEI */
static int hf_rrc_spare2_02 = -1;                 /* T_spare2_01 */
static int hf_rrc_spare1_02 = -1;                 /* T_spare1_01 */
static int hf_rrc_dummy_30 = -1;                  /* BOOLEAN */
static int hf_rrc_IMEI_item = -1;                 /* IMEI_Digit */
static int hf_rrc_IMSI_GSM_MAP_item = -1;         /* Digit */
static int hf_rrc_version = -1;                   /* T_version */
static int hf_rrc_release99 = -1;                 /* T_release99 */
static int hf_rrc_cn_Type_01 = -1;                /* T_cn_Type_01 */
static int hf_rrc_gsm_Map_IDNNS = -1;             /* Gsm_map_IDNNS */
static int hf_rrc_ansi_41_IDNNS = -1;             /* Ansi_41_IDNNS */
static int hf_rrc_later = -1;                     /* T_later */
static int hf_rrc_futurecoding = -1;              /* BIT_STRING_SIZE_15 */
static int hf_rrc_lac = -1;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_LocationRegistrationAccessClassBarredList_item = -1;  /* AccessClassBarred */
static int hf_rrc_noRestriction = -1;             /* NULL */
static int hf_rrc_restriction = -1;               /* LocationRegistrationAccessClassBarredList */
static int hf_rrc_MCC_item = -1;                  /* Digit */
static int hf_rrc_MNC_item = -1;                  /* Digit */
static int hf_rrc_mibPLMN_Identity = -1;          /* BOOLEAN */
static int hf_rrc_multiplePLMNs = -1;             /* SEQUENCE_SIZE_1_5_OF_PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_multiplePLMNs_item = -1;        /* PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_pagingPermissionWithAccessControlList = -1;  /* PagingPermissionWithAccessControlList */
static int hf_rrc_pagingPermissionWithAccessControlForAll = -1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator1 = -1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator2 = -1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator3 = -1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator4 = -1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator5 = -1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingResponseRestrictionIndicator = -1;  /* T_pagingResponseRestrictionIndicator */
static int hf_rrc_locationRegistrationRestrictionIndicator = -1;  /* T_locationRegistrationRestrictionIndicator */
static int hf_rrc_locationRegistration = -1;      /* LocationRegistrationParameters */
static int hf_rrc_mcc = -1;                       /* MCC */
static int hf_rrc_mnc = -1;                       /* MNC */
static int hf_rrc_gsm_MAP_01 = -1;                /* T_gsm_MAP */
static int hf_rrc_ansi_41_01 = -1;                /* T_ansi_41 */
static int hf_rrc_p_REV = -1;                     /* P_REV */
static int hf_rrc_min_P_REV = -1;                 /* Min_P_REV */
static int hf_rrc_sid = -1;                       /* SID */
static int hf_rrc_nid = -1;                       /* NID */
static int hf_rrc_gsm_MAP_and_ANSI_41 = -1;       /* T_gsm_MAP_and_ANSI_41 */
static int hf_rrc_gsm_MAP_RAB_Identity = -1;      /* BIT_STRING_SIZE_8 */
static int hf_rrc_ansi_41_RAB_Identity = -1;      /* BIT_STRING_SIZE_8 */
static int hf_rrc_lai = -1;                       /* LAI */
static int hf_rrc_rac = -1;                       /* RoutingAreaCode */
static int hf_rrc_AccessClassBarredList_item = -1;  /* AccessClassBarred */
static int hf_rrc_cellBarred = -1;                /* CellBarred */
static int hf_rrc_cellReservedForOperatorUse = -1;  /* ReservedIndicator */
static int hf_rrc_cellReservationExtension = -1;  /* ReservedIndicator */
static int hf_rrc_accessClassBarredList = -1;     /* AccessClassBarredList */
static int hf_rrc_cellReservedForCSG = -1;        /* T_cellReservedForCSG */
static int hf_rrc_barred = -1;                    /* T_barred */
static int hf_rrc_intraFreqCellReselectionInd = -1;  /* AllowedIndicator */
static int hf_rrc_t_Barred = -1;                  /* T_Barred */
static int hf_rrc_notBarred = -1;                 /* NULL */
static int hf_rrc_CellIdentity_PerRL_List_item = -1;  /* CellIdentity */
static int hf_rrc_cell_Identity = -1;             /* CellIdentity */
static int hf_rrc_mappingInfo = -1;               /* MappingInfo */
static int hf_rrc_cellSelectQualityMeasure = -1;  /* T_cellSelectQualityMeasure */
static int hf_rrc_cpich_Ec_N0 = -1;               /* T_cpich_Ec_N0 */
static int hf_rrc_q_HYST_2_S = -1;                /* Q_Hyst_S */
static int hf_rrc_cpich_RSCP = -1;                /* NULL */
static int hf_rrc_modeSpecificInfo_16 = -1;       /* T_modeSpecificInfo_16 */
static int hf_rrc_fdd_46 = -1;                    /* T_fdd_45 */
static int hf_rrc_s_Intrasearch = -1;             /* S_SearchQual */
static int hf_rrc_s_Intersearch = -1;             /* S_SearchQual */
static int hf_rrc_s_SearchHCS = -1;               /* S_SearchRXLEV */
static int hf_rrc_rat_List = -1;                  /* RAT_FDD_InfoList */
static int hf_rrc_q_QualMin = -1;                 /* Q_QualMin */
static int hf_rrc_q_RxlevMin = -1;                /* Q_RxlevMin */
static int hf_rrc_tdd_11 = -1;                    /* T_tdd_10 */
static int hf_rrc_s_Intrasearch_01 = -1;          /* S_SearchRXLEV */
static int hf_rrc_s_Intersearch_01 = -1;          /* S_SearchRXLEV */
static int hf_rrc_rat_List_01 = -1;               /* RAT_TDD_InfoList */
static int hf_rrc_q_Hyst_l_S = -1;                /* Q_Hyst_S */
static int hf_rrc_t_Reselection_S = -1;           /* T_Reselection_S */
static int hf_rrc_hcs_ServingCellInformation = -1;  /* HCS_ServingCellInformation */
static int hf_rrc_CSG_DedicatedFrequencyInfoList_item = -1;  /* FrequencyInfo */
static int hf_rrc_startPSC = -1;                  /* INTEGER_0_63 */
static int hf_rrc_numberOfPSCs = -1;              /* T_numberOfPSCs */
static int hf_rrc_pscRange2Offset = -1;           /* INTEGER_1_63 */
static int hf_rrc_domainSpecificAccessRestictionList = -1;  /* DomainSpecificAccessRestrictionList_v670ext */
static int hf_rrc_domainSpecificAccessRestictionParametersForAll = -1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator1 = -1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator2 = -1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator3 = -1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator4 = -1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator5 = -1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_cSDomainSpecificAccessRestriction = -1;  /* DomainSpecificAccessRestriction_v670ext */
static int hf_rrc_pSDomainSpecificAccessRestriction = -1;  /* DomainSpecificAccessRestriction_v670ext */
static int hf_rrc_restriction_01 = -1;            /* T_restriction */
static int hf_rrc_domainSpecficAccessClassBarredList = -1;  /* AccessClassBarredList */
static int hf_rrc_rat = -1;                       /* RAT */
static int hf_rrc_mappingFunctionParameterList = -1;  /* MappingFunctionParameterList */
static int hf_rrc_functionType = -1;              /* MappingFunctionType */
static int hf_rrc_mapParameter1 = -1;             /* MapParameter */
static int hf_rrc_mapParameter2 = -1;             /* MapParameter */
static int hf_rrc_upperLimit = -1;                /* UpperLimit */
static int hf_rrc_MappingFunctionParameterList_item = -1;  /* MappingFunctionParameter */
static int hf_rrc_MappingInfo_item = -1;          /* Mapping */
static int hf_rrc_action = -1;                    /* T_action */
static int hf_rrc_clearDedicatedPriorities = -1;  /* NULL */
static int hf_rrc_configureDedicatedPriorities = -1;  /* T_configureDedicatedPriorities */
static int hf_rrc_t_322 = -1;                     /* T_322 */
static int hf_rrc_priorityLevelList = -1;         /* PriorityLevelList */
static int hf_rrc_eutraDetection = -1;            /* BOOLEAN */
static int hf_rrc_action_01 = -1;                 /* T_action_01 */
static int hf_rrc_configureDedicatedPriorities_01 = -1;  /* T_configureDedicatedPriorities_01 */
static int hf_rrc_priorityLevelList_01 = -1;      /* PriorityLevelList_r11 */
static int hf_rrc_priority = -1;                  /* INTEGER_0_maxPrio_1 */
static int hf_rrc_radioAccessTechnology = -1;     /* T_radioAccessTechnology */
static int hf_rrc_utraFDD = -1;                   /* T_utraFDD */
static int hf_rrc_utraFDD_item = -1;              /* T_utraFDD_item */
static int hf_rrc_uarfcn = -1;                    /* UARFCN */
static int hf_rrc_utraTDD = -1;                   /* T_utraTDD */
static int hf_rrc_utraTDD_item = -1;              /* T_utraTDD_item */
static int hf_rrc_eutra = -1;                     /* T_eutra */
static int hf_rrc_eutra_item = -1;                /* T_eutra_item */
static int hf_rrc_earfcn = -1;                    /* EARFCN */
static int hf_rrc_gsm_01 = -1;                    /* T_gsm_01 */
static int hf_rrc_gsm_CellGroup = -1;             /* GSM_CellGroup */
static int hf_rrc_radioAccessTechnology_01 = -1;  /* T_radioAccessTechnology_01 */
static int hf_rrc_utraFDD_01 = -1;                /* T_utraFDD_01 */
static int hf_rrc_utraFDD_item_01 = -1;           /* T_utraFDD_item_01 */
static int hf_rrc_utraTDD_01 = -1;                /* T_utraTDD_01 */
static int hf_rrc_utraTDD_item_01 = -1;           /* T_utraTDD_item_01 */
static int hf_rrc_eutra_01 = -1;                  /* SEQUENCE_SIZE_1_maxNumEUTRAFreqs_OF_EARFCNRange */
static int hf_rrc_eutra_item_01 = -1;             /* EARFCNRange */
static int hf_rrc_gsm_02 = -1;                    /* T_gsm_02 */
static int hf_rrc_PriorityLevelList_item = -1;    /* PriorityLevel */
static int hf_rrc_PriorityLevelList_r11_item = -1;  /* PriorityLevel_r11 */
static int hf_rrc_rat_Identifier = -1;            /* RAT_Identifier */
static int hf_rrc_s_SearchRAT = -1;               /* S_SearchQual */
static int hf_rrc_s_HCS_RAT = -1;                 /* S_SearchRXLEV */
static int hf_rrc_s_Limit_SearchRAT = -1;         /* S_SearchQual */
static int hf_rrc_RAT_FDD_InfoList_item = -1;     /* RAT_FDD_Info */
static int hf_rrc_s_SearchRAT_01 = -1;            /* S_SearchRXLEV */
static int hf_rrc_s_Limit_SearchRAT_01 = -1;      /* S_SearchRXLEV */
static int hf_rrc_RAT_TDD_InfoList_item = -1;     /* RAT_TDD_Info */
static int hf_rrc_URA_IdentityList_item = -1;     /* URA_Identity */
static int hf_rrc_n_AP_RetransMax = -1;           /* N_AP_RetransMax */
static int hf_rrc_n_AccessFails = -1;             /* N_AccessFails */
static int hf_rrc_nf_BO_NoAICH = -1;              /* NF_BO_NoAICH */
static int hf_rrc_ns_BO_Busy = -1;                /* NS_BO_Busy */
static int hf_rrc_nf_BO_AllBusy = -1;             /* NF_BO_AllBusy */
static int hf_rrc_nf_BO_Mismatch = -1;            /* NF_BO_Mismatch */
static int hf_rrc_t_CPCH = -1;                    /* T_CPCH */
static int hf_rrc_ue_RadioCapabilityFDDUpdateRequirement = -1;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement = -1;  /* BOOLEAN */
static int hf_rrc_systemSpecificCapUpdateReqList = -1;  /* SystemSpecificCapUpdateReqList */
static int hf_rrc_ue_RadioCapabilityUpdateRequirement_TDD128 = -1;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityFDDUpdateRequirement_FDD = -1;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement_TDD384 = -1;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement_TDD128 = -1;  /* BOOLEAN */
static int hf_rrc_systemSpecificCapUpdateReqList_01 = -1;  /* SystemSpecificCapUpdateReqList_r5 */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement_TDD768 = -1;  /* BOOLEAN */
static int hf_rrc_systemSpecificCapUpdateReqList_02 = -1;  /* SystemSpecificCapUpdateReqList_r8 */
static int hf_rrc_startRestart = -1;              /* CipheringAlgorithm */
static int hf_rrc_startRestart_01 = -1;           /* CipheringAlgorithm_r7 */
static int hf_rrc_cipheringModeCommand = -1;      /* CipheringModeCommand */
static int hf_rrc_activationTimeForDPCH = -1;     /* ActivationTime */
static int hf_rrc_rb_DL_CiphActivationTimeInfo = -1;  /* RB_ActivationTimeInfoList */
static int hf_rrc_cipheringModeCommand_01 = -1;   /* CipheringModeCommand_r7 */
static int hf_rrc_imsi_GSM_MAP = -1;              /* IMSI_GSM_MAP */
static int hf_rrc_tmsi_GSM_MAP = -1;              /* TMSI_GSM_MAP */
static int hf_rrc_p_TMSI_GSM_MAP = -1;            /* P_TMSI_GSM_MAP */
static int hf_rrc_imsi_DS_41 = -1;                /* IMSI_DS_41 */
static int hf_rrc_tmsi_DS_41 = -1;                /* TMSI_DS_41 */
static int hf_rrc_fdd_Measurements = -1;          /* BOOLEAN */
static int hf_rrc_tdd_Measurements = -1;          /* BOOLEAN */
static int hf_rrc_gsm_Measurements = -1;          /* GSM_Measurements */
static int hf_rrc_multiCarrierMeasurements = -1;  /* BOOLEAN */
static int hf_rrc_tdd128_Measurements = -1;       /* BOOLEAN */
static int hf_rrc_adjacentFrequencyMeasurements = -1;  /* T_adjacentFrequencyMeasurements */
static int hf_rrc_interBandMeasurements = -1;     /* T_interBandMeasurements */
static int hf_rrc_enhancedInterFrequencyMeasurements = -1;  /* T_enhancedInterFrequencyMeasurements */
static int hf_rrc_freqSpecificCompressedMode = -1;  /* T_freqSpecificCompressedMode */
static int hf_rrc_radioFrequencyBandEUTRA = -1;   /* RadioFrequencyBandEUTRA */
static int hf_rrc_compressedMode = -1;            /* BOOLEAN */
static int hf_rrc_radioFrequencyBandEUTRA_01 = -1;  /* RadioFrequencyBandEUTRAExt */
static int hf_rrc_CompressedModeMeasCapabEUTRAList_item = -1;  /* CompressedModeMeasCapabEUTRA */
static int hf_rrc_CompressedModeMeasCapabEUTRAList2_item = -1;  /* CompressedModeMeasCapabEUTRAExt */
static int hf_rrc_CompressedModeMeasCapabFDDList_item = -1;  /* CompressedModeMeasCapabFDD */
static int hf_rrc_CompressedModeMeasCapabFDDList2_item = -1;  /* CompressedModeMeasCapabFDD2 */
static int hf_rrc_CompressedModeMeasCapabFDDList3_item = -1;  /* CompressedModeMeasCapabFDD3 */
static int hf_rrc_CompressedModeMeasCapabFDDList_ext_item = -1;  /* CompressedModeMeasCapabFDD_ext */
static int hf_rrc_radioFrequencyBandFDD = -1;     /* RadioFrequencyBandFDD */
static int hf_rrc_dl_MeasurementsFDD = -1;        /* BOOLEAN */
static int hf_rrc_ul_MeasurementsFDD = -1;        /* BOOLEAN */
static int hf_rrc_radioFrequencyBandFDD2 = -1;    /* RadioFrequencyBandFDD2 */
static int hf_rrc_radioFrequencyBandFDD3 = -1;    /* RadioFrequencyBandFDD3 */
static int hf_rrc_CompressedModeMeasCapabTDDList_item = -1;  /* CompressedModeMeasCapabTDD */
static int hf_rrc_radioFrequencyBandTDD = -1;     /* RadioFrequencyBandTDD */
static int hf_rrc_dl_MeasurementsTDD = -1;        /* BOOLEAN */
static int hf_rrc_ul_MeasurementsTDD = -1;        /* BOOLEAN */
static int hf_rrc_CompressedModeMeasCapabGSMList_item = -1;  /* CompressedModeMeasCapabGSM */
static int hf_rrc_radioFrequencyBandGSM = -1;     /* RadioFrequencyBandGSM */
static int hf_rrc_dl_MeasurementsGSM = -1;        /* BOOLEAN */
static int hf_rrc_ul_MeasurementsGSM = -1;        /* BOOLEAN */
static int hf_rrc_dl_MeasurementsMC = -1;         /* BOOLEAN */
static int hf_rrc_ul_MeasurementsMC = -1;         /* BOOLEAN */
static int hf_rrc_initialPriorityDelayList = -1;  /* InitialPriorityDelayList */
static int hf_rrc_backoffControlParams = -1;      /* BackoffControlParams */
static int hf_rrc_powerControlAlgorithm = -1;     /* PowerControlAlgorithm */
static int hf_rrc_dl_DPCCH_BER = -1;              /* DL_DPCCH_BER */
static int hf_rrc_supportOfIntraFreqProximityIndication = -1;  /* T_supportOfIntraFreqProximityIndication */
static int hf_rrc_supportOfInterFreqProximityIndication = -1;  /* T_supportOfInterFreqProximityIndication */
static int hf_rrc_supportOfE_UtraProximityIndication = -1;  /* T_supportOfE_UtraProximityIndication */
static int hf_rrc_DL_InformationPerSecondaryRL_List_item = -1;  /* DL_InformationPerSecondaryRL */
static int hf_rrc_primaryCPICH_Info = -1;         /* PrimaryCPICH_Info */
static int hf_rrc_cell_id = -1;                   /* CellIdentity */
static int hf_rrc_dl_FDPCHInfoPerRL_SecULFreq = -1;  /* DL_FDPCH_InfoPerRL_r7 */
static int hf_rrc_e_AGCH_Information = -1;        /* E_AGCH_Information */
static int hf_rrc_e_HICH_Information = -1;        /* E_HICH_Information */
static int hf_rrc_e_RGCH_Info = -1;               /* T_e_RGCH_Info */
static int hf_rrc_e_RGCH_Information = -1;        /* E_RGCH_Information */
static int hf_rrc_releaseIndicator = -1;          /* NULL */
static int hf_rrc_maxNoDPCH_PDSCH_Codes = -1;     /* INTEGER_1_8 */
static int hf_rrc_maxNoPhysChBitsReceived = -1;   /* MaxNoPhysChBitsReceived */
static int hf_rrc_supportForSF_512 = -1;          /* BOOLEAN */
static int hf_rrc_dummy2_05 = -1;                 /* SimultaneousSCCPCH_DPCH_Reception */
static int hf_rrc_dummy_31 = -1;                  /* SupportOfDedicatedPilotsForChEstimation */
static int hf_rrc_hsdsch_physical_layer_category_ext = -1;  /* HSDSCH_physical_layer_category_ext */
static int hf_rrc_hsscchlessHsdschOperation = -1;  /* T_hsscchlessHsdschOperation */
static int hf_rrc_enhancedFdpch = -1;             /* T_enhancedFdpch */
static int hf_rrc_hsdschReception_CellFach = -1;  /* T_hsdschReception_CellFach */
static int hf_rrc_hsdschReception_CellUraPch = -1;  /* T_hsdschReception_CellUraPch */
static int hf_rrc_hsdsch_physical_layer_category_ext2 = -1;  /* HSDSCH_physical_layer_category_ext2 */
static int hf_rrc_supportOfTargetCellPreConfig = -1;  /* T_supportOfTargetCellPreConfig */
static int hf_rrc_supportOfHsdschDrxOperation = -1;  /* T_supportOfHsdschDrxOperation */
static int hf_rrc_hsdsch_physical_layer_category_ext3 = -1;  /* HSDSCH_physical_layer_category_ext3 */
static int hf_rrc_supportOfMimoOnlySingleStream = -1;  /* T_supportOfMimoOnlySingleStream */
static int hf_rrc_hsdsch_physical_layer_category_ext4 = -1;  /* HSDSCH_physical_layer_category_ext4 */
static int hf_rrc_hsdsch_physical_layer_category_ext5 = -1;  /* HSDSCH_physical_layer_category_ext5 */
static int hf_rrc_hsdsch_physical_layer_category_ext6 = -1;  /* HSDSCH_physical_layer_category_ext6 */
static int hf_rrc_hsdsch_physical_layer_category_ext7 = -1;  /* HSDSCH_physical_layer_category_ext7 */
static int hf_rrc_hsdsch_physical_layer_category_ext8 = -1;  /* HSDSCH_physical_layer_category_ext8 */
static int hf_rrc_supportOf4x4MimoDualStreamRestriction = -1;  /* T_supportOf4x4MimoDualStreamRestriction */
static int hf_rrc_supportOfHS_DSCHSecondDRXOperation = -1;  /* T_supportOfHS_DSCHSecondDRXOperation */
static int hf_rrc_supportOfNodeBTrigHS_DPCCHTransmission = -1;  /* T_supportOfNodeBTrigHS_DPCCHTransmission */
static int hf_rrc_maxTS_PerFrame = -1;            /* MaxTS_PerFrame */
static int hf_rrc_maxPhysChPerFrame = -1;         /* MaxPhysChPerFrame */
static int hf_rrc_minimumSF = -1;                 /* MinimumSF_DL */
static int hf_rrc_supportOfPDSCH = -1;            /* BOOLEAN */
static int hf_rrc_maxPhysChPerTS = -1;            /* MaxPhysChPerTS */
static int hf_rrc_maxTS_PerSubFrame = -1;         /* MaxTS_PerSubFrame_r4 */
static int hf_rrc_maxPhysChPerFrame_01 = -1;      /* MaxPhysChPerSubFrame_r4 */
static int hf_rrc_supportOf8PSK = -1;             /* BOOLEAN */
static int hf_rrc_multiCarrier_physical_layer_category = -1;  /* MultiCarrier_HSDSCH_physical_layer_category */
static int hf_rrc_hSDSCH_physical_layer_category_extension = -1;  /* HSDSCH_physical_layer_category_extension */
static int hf_rrc_multiCarrier_physical_layer_category_extension = -1;  /* MultiCarrier_HSDSCH_physical_layer_category_extension */
static int hf_rrc_supportOfSFModeForHSPDSCHDualStream = -1;  /* T_supportOfSFModeForHSPDSCHDualStream */
static int hf_rrc_multiCarrier_physical_layer_category_extension2 = -1;  /* MultiCarrier_HSDSCH_physical_layer_category_extension2 */
static int hf_rrc_maxPhysChPerFrame_02 = -1;      /* MaxPhysChPerFrame_768 */
static int hf_rrc_minimumSF_01 = -1;              /* MinimumSF_DL_768 */
static int hf_rrc_tdd768_hspdsch = -1;            /* T_tdd768_hspdsch */
static int hf_rrc_supported = -1;                 /* HSDSCH_physical_layer_category */
static int hf_rrc_unsupported = -1;               /* NULL */
static int hf_rrc_maxPhysChPerTS_01 = -1;         /* MaxPhysChPerTS_768 */
static int hf_rrc_maxNoBitsReceived = -1;         /* MaxNoBits */
static int hf_rrc_maxConvCodeBitsReceived = -1;   /* MaxNoBits */
static int hf_rrc_turboDecodingSupport = -1;      /* TurboSupport */
static int hf_rrc_maxSimultaneousTransChs = -1;   /* MaxSimultaneousTransChsDL */
static int hf_rrc_maxSimultaneousCCTrCH_Count = -1;  /* MaxSimultaneousCCTrCH_Count */
static int hf_rrc_maxReceivedTransportBlocks = -1;  /* MaxTransportBlocksDL */
static int hf_rrc_maxNumberOfTFC = -1;            /* MaxNumberOfTFC_DL */
static int hf_rrc_maxNumberOfTF = -1;             /* MaxNumberOfTF */
static int hf_rrc_transmissionProbability = -1;   /* TransmissionProbability */
static int hf_rrc_maximumBitRate = -1;            /* MaximumBitRate */
static int hf_rrc_DRAC_SysInfoList_item = -1;     /* DRAC_SysInfo */
static int hf_rrc_configurationUnsupported = -1;  /* NULL */
static int hf_rrc_physicalChannelFailure = -1;    /* NULL */
static int hf_rrc_incompatibleSimultaneousReconfiguration = -1;  /* NULL */
static int hf_rrc_compressedModeRuntimeError = -1;  /* TGPSI */
static int hf_rrc_protocolError = -1;             /* ProtocolErrorInformation */
static int hf_rrc_cellUpdateOccurred = -1;        /* NULL */
static int hf_rrc_invalidConfiguration = -1;      /* NULL */
static int hf_rrc_configurationIncomplete = -1;   /* NULL */
static int hf_rrc_unsupportedMeasurement = -1;    /* NULL */
static int hf_rrc_mbmsSessionAlreadyReceivedCorrectly = -1;  /* NULL */
static int hf_rrc_lowerPriorityMBMSService = -1;  /* NULL */
static int hf_rrc_modeSpecificInfo_17 = -1;       /* T_modeSpecificInfo_17 */
static int hf_rrc_fdd_47 = -1;                    /* T_fdd_46 */
static int hf_rrc_frequencyBandsSupportFDD = -1;  /* FrequencyBandsRedirectionFDD */
static int hf_rrc_tdd_12 = -1;                    /* T_tdd_11 */
static int hf_rrc_frequencyBandsSupportTDD128 = -1;  /* FrequencyBandsIndicatorTDD128 */
static int hf_rrc_FrequencyBandsIndicatorTDD128_item = -1;  /* FrequencyBandsIndicatorSupportTDD128 */
static int hf_rrc_frequencyBandsIndicatorTDD = -1;  /* RadioFrequencyBandTDD_r10 */
static int hf_rrc_FrequencyBandsRedirectionFDD_item = -1;  /* FrequencyBandsIndicatorFDD */
static int hf_rrc_frequencyBandsIndicator1 = -1;  /* RadioFrequencyBandFDD */
static int hf_rrc_frequencyBandsIndicator2 = -1;  /* RadioFrequencyBandFDD2 */
static int hf_rrc_frequencyBandsIndicator3 = -1;  /* RadioFrequencyBandFDD3 */
static int hf_rrc_rrc_ConnectionReleaseInformation = -1;  /* RRC_ConnectionReleaseInformation */
static int hf_rrc_groupReleaseInformation = -1;   /* GroupReleaseInformation */
static int hf_rrc_uRNTI_Group = -1;               /* U_RNTI_Group */
static int hf_rrc_gsm900 = -1;                    /* BOOLEAN */
static int hf_rrc_dcs1800 = -1;                   /* BOOLEAN */
static int hf_rrc_gsm1900 = -1;                   /* BOOLEAN */
static int hf_rrc_numberOfCellsBandA = -1;        /* INTEGER_2_6 */
static int hf_rrc_numberOfFrequenciesBandA = -1;  /* INTEGER_1_3 */
static int hf_rrc_numberOfCellsBandB = -1;        /* INTEGER_2_6 */
static int hf_rrc_numberOfFrequenciesBandB = -1;  /* INTEGER_1_3 */
static int hf_rrc_MultiflowCapabBandCombList_item = -1;  /* MultiflowCapabBandCombination */
static int hf_rrc_mimoInDifferentBands = -1;      /* MultiflowMIMOCapability */
static int hf_rrc_longerHARQProcessing = -1;      /* T_longerHARQProcessing */
static int hf_rrc_numberOfCells = -1;             /* INTEGER_2_8 */
static int hf_rrc_numberOfFrequencies = -1;       /* INTEGER_1_4 */
static int hf_rrc_mimo = -1;                      /* MultiflowMIMOCapability */
static int hf_rrc_nonContiguousCapability = -1;   /* MultiflowNonContiguousCapability */
static int hf_rrc_gapSize = -1;                   /* T_gapSize */
static int hf_rrc_idleInterval = -1;              /* BOOLEAN */
static int hf_rrc_IdleIntervalMeasCapabEUTRAList_item = -1;  /* IdleIntervalMeasCapabEUTRA */
static int hf_rrc_IdleIntervalMeasCapabEUTRAExtensionList_item = -1;  /* IdleIntervalMeasCapabEUTRAExtension */
static int hf_rrc_esn_DS_41 = -1;                 /* ESN_DS_41 */
static int hf_rrc_InitialPriorityDelayList_item = -1;  /* NS_IP */
static int hf_rrc_imsi = -1;                      /* IMSI_GSM_MAP */
static int hf_rrc_tmsi_and_LAI = -1;              /* TMSI_and_LAI_GSM_MAP */
static int hf_rrc_p_TMSI_and_RAI = -1;            /* P_TMSI_and_RAI_GSM_MAP */
static int hf_rrc_imei = -1;                      /* IMEI */
static int hf_rrc_imsi_and_ESN_DS_41 = -1;        /* IMSI_and_ESN_DS_41 */
static int hf_rrc_messageAuthenticationCode = -1;  /* MessageAuthenticationCode */
static int hf_rrc_rrc_MessageSequenceNumber = -1;  /* RRC_MessageSequenceNumber */
static int hf_rrc_rrc_MessageSequenceNumberList = -1;  /* RRC_MessageSequenceNumberList */
static int hf_rrc_startIntegrityProtection = -1;  /* T_startIntegrityProtection */
static int hf_rrc_integrityProtInitNumber = -1;   /* IntegrityProtInitNumber */
static int hf_rrc_modify = -1;                    /* T_modify */
static int hf_rrc_dl_IntegrityProtActivationInfo = -1;  /* IntegrityProtActivationInfo */
static int hf_rrc_integrityProtectionModeCommand = -1;  /* IntegrityProtectionModeCommand */
static int hf_rrc_integrityProtectionAlgorithm = -1;  /* IntegrityProtectionAlgorithm */
static int hf_rrc_integrityProtectionAlgorithm_01 = -1;  /* IntegrityProtectionAlgorithm_r7 */
static int hf_rrc_downlinkCompressedMode = -1;    /* CompressedModeMeasCapability */
static int hf_rrc_uplinkCompressedMode = -1;      /* CompressedModeMeasCapability */
static int hf_rrc_compressedModeMeasCapabFDDList = -1;  /* CompressedModeMeasCapabFDDList */
static int hf_rrc_compressedModeMeasCapabTDDList = -1;  /* CompressedModeMeasCapabTDDList */
static int hf_rrc_compressedModeMeasCapabGSMList = -1;  /* CompressedModeMeasCapabGSMList */
static int hf_rrc_compressedModeMeasCapabMC = -1;  /* CompressedModeMeasCapabMC */
static int hf_rrc_compressedModeMeasCapabFDDList_01 = -1;  /* CompressedModeMeasCapabFDDList2 */
static int hf_rrc_compressedModeMeasCapabEUTRAList = -1;  /* CompressedModeMeasCapabEUTRAList */
static int hf_rrc_compressedModeMeasCapabFDDList2 = -1;  /* CompressedModeMeasCapabFDDList2 */
static int hf_rrc_compressedModeMeasCapabFDDList3 = -1;  /* CompressedModeMeasCapabFDDList3 */
static int hf_rrc_compressedModeMeasCapabEUTRAList_01 = -1;  /* CompressedModeMeasCapabEUTRAList2 */
static int hf_rrc_downlinkCompressedMode_LCR = -1;  /* CompressedModeMeasCapability_LCR_r4 */
static int hf_rrc_uplinkCompressedMode_LCR = -1;  /* CompressedModeMeasCapability_LCR_r4 */
static int hf_rrc_downlinkCompressedMode_01 = -1;  /* CompressedModeMeasCapability_v860ext */
static int hf_rrc_downlinkCompressedMode_02 = -1;  /* CompressedModeMeasCapability_v920ext */
static int hf_rrc_interFrequencyDetectedSetMeasurements = -1;  /* T_interFrequencyDetectedSetMeasurements */
static int hf_rrc_downlinkCompressedMode_03 = -1;  /* CompressedModeMeasCapability_va40ext */
static int hf_rrc_interFrequencyMeasOnConfigCarriersWithoutCompMode = -1;  /* T_interFrequencyMeasOnConfigCarriersWithoutCompMode */
static int hf_rrc_cellsExcludedFromDetectedSetMeasurements = -1;  /* T_cellsExcludedFromDetectedSetMeasurements */
static int hf_rrc_idleIntervalMeasCapabEUTRAList = -1;  /* IdleIntervalMeasCapabEUTRAList */
static int hf_rrc_idleIntervalMeasCapabEUTRAList_01 = -1;  /* IdleIntervalMeasCapabEUTRAExtensionList */
static int hf_rrc_NonContiguousMultiCellCombinationList_item = -1;  /* NonContiguousMultiCell */
static int hf_rrc_aggregatedCells = -1;           /* T_aggregatedCells */
static int hf_rrc_gapSize_01 = -1;                /* T_gapSize_01 */
static int hf_rrc_nonContiguousMultiCellCombination22 = -1;  /* T_nonContiguousMultiCellCombination22 */
static int hf_rrc_nonContiguousMultiCellCombination31_13 = -1;  /* T_nonContiguousMultiCellCombination31_13 */
static int hf_rrc_supportOfGSM = -1;              /* BOOLEAN */
static int hf_rrc_supportOfMulticarrier = -1;     /* BOOLEAN */
static int hf_rrc_supportOfUTRAN_ToGERAN_NACC = -1;  /* BOOLEAN */
static int hf_rrc_supportOfHandoverToGAN = -1;    /* T_supportOfHandoverToGAN */
static int hf_rrc_supportOfPSHandoverToGAN = -1;  /* T_supportOfPSHandoverToGAN */
static int hf_rrc_supportOfEUTRAFDD = -1;         /* T_supportOfEUTRAFDD */
static int hf_rrc_supportOfInterRATHOToEUTRAFDD = -1;  /* T_supportOfInterRATHOToEUTRAFDD */
static int hf_rrc_supportOfEUTRATDD = -1;         /* T_supportOfEUTRATDD */
static int hf_rrc_supportOfInterRATHOToEUTRATDD = -1;  /* T_supportOfInterRATHOToEUTRATDD */
static int hf_rrc_eutraFeatureGroupIndicators = -1;  /* T_eutraFeatureGroupIndicators */
static int hf_rrc_supportOfEUTRAFDDMeasurementReportingInCELLFACH = -1;  /* T_supportOfEUTRAFDDMeasurementReportingInCELLFACH */
static int hf_rrc_supportOfEUTRATDDMeasurementReportingInCELLFACH = -1;  /* T_supportOfEUTRATDDMeasurementReportingInCELLFACH */
static int hf_rrc_supportOfIntraFreqSIAcquisitionForHO = -1;  /* T_supportOfIntraFreqSIAcquisitionForHO */
static int hf_rrc_supportOfInterFreqSIAcquisitionForHO = -1;  /* T_supportOfInterFreqSIAcquisitionForHO */
static int hf_rrc_supportOfE_UtraSIAcquisitionForHO = -1;  /* T_supportOfE_UtraSIAcquisitionForHO */
static int hf_rrc_NetworkAssistedGANSS_Supported_List_item = -1;  /* NetworkAssistedGANSS_Supported_List_item */
static int hf_rrc_gANSS_Id = -1;                  /* T_gANSS_Id */
static int hf_rrc_gANSS_Mode = -1;                /* GANSS_Mode */
static int hf_rrc_gANSS_SignalId = -1;            /* GANSS_Signal_Id */
static int hf_rrc_supportForUE_GANSS_TimingOfCellFrames = -1;  /* BOOLEAN */
static int hf_rrc_supportForUE_GANSS_CarrierPhaseMeasurement = -1;  /* BOOLEAN */
static int hf_rrc_NetworkAssistedGANSS_Supported_List_v860ext_item = -1;  /* NetworkAssistedGANSS_Supported_List_v860ext_item */
static int hf_rrc_sbas_Ids = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rrc_gANSS_SignalIds = -1;           /* BIT_STRING_SIZE_8 */
static int hf_rrc_non_native_AD_choices_supported = -1;  /* T_non_native_AD_choices_supported */
static int hf_rrc_p_TMSI = -1;                    /* P_TMSI_GSM_MAP */
static int hf_rrc_rai = -1;                       /* RAI */
static int hf_rrc_cn_Identity = -1;               /* T_cn_Identity */
static int hf_rrc_cn_pagedUE_Identity = -1;       /* CN_PagedUE_Identity */
static int hf_rrc_utran_Identity = -1;            /* T_utran_Identity */
static int hf_rrc_cn_OriginatedPage_connectedMode_UE = -1;  /* T_cn_OriginatedPage_connectedMode_UE */
static int hf_rrc_utran_SingleUE_Identity = -1;   /* T_utran_SingleUE_Identity */
static int hf_rrc_cn_OriginatedPage_connectedMode_UE_01 = -1;  /* T_cn_OriginatedPage_connectedMode_UE_01 */
static int hf_rrc_utran_GroupIdentity = -1;       /* SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupIdentityWithReleaseInformation */
static int hf_rrc_utran_GroupIdentity_item = -1;  /* GroupIdentityWithReleaseInformation */
static int hf_rrc_PagingRecordList_item = -1;     /* PagingRecord */
static int hf_rrc_PagingRecord2List_r5_item = -1;  /* PagingRecord2_r5 */
static int hf_rrc_losslessSRNS_RelocationSupport = -1;  /* BOOLEAN */
static int hf_rrc_supportForRfc2507 = -1;         /* T_supportForRfc2507 */
static int hf_rrc_notSupported = -1;              /* NULL */
static int hf_rrc_supported_01 = -1;              /* MaxHcContextSpace */
static int hf_rrc_supportForRfc3095 = -1;         /* T_supportForRfc3095 */
static int hf_rrc_supported_02 = -1;              /* T_supported */
static int hf_rrc_maxROHC_ContextSessions = -1;   /* MaxROHC_ContextSessions_r4 */
static int hf_rrc_reverseCompressionDepth = -1;   /* INTEGER_0_65535 */
static int hf_rrc_supportForRfc3095ContextRelocation = -1;  /* BOOLEAN */
static int hf_rrc_maxHcContextSpace = -1;         /* MaxHcContextSpace_r5_ext */
static int hf_rrc_losslessDLRLC_PDUSizeChange = -1;  /* T_losslessDLRLC_PDUSizeChange */
static int hf_rrc_supportForCSVoiceoverHSPA_01 = -1;  /* T_supportForCSVoiceoverHSPA_01 */
static int hf_rrc_fddPhysChCapability = -1;       /* T_fddPhysChCapability */
static int hf_rrc_downlinkPhysChCapability = -1;  /* DL_PhysChCapabilityFDD */
static int hf_rrc_uplinkPhysChCapability = -1;    /* UL_PhysChCapabilityFDD */
static int hf_rrc_tddPhysChCapability = -1;       /* T_tddPhysChCapability */
static int hf_rrc_downlinkPhysChCapability_01 = -1;  /* DL_PhysChCapabilityTDD */
static int hf_rrc_uplinkPhysChCapability_01 = -1;  /* UL_PhysChCapabilityTDD */
static int hf_rrc_fddPhysChCapability_01 = -1;    /* T_fddPhysChCapability_01 */
static int hf_rrc_downlinkPhysChCapability_02 = -1;  /* DL_PhysChCapabilityFDD_v770ext */
static int hf_rrc_uplinkPhysChCapability_02 = -1;  /* UL_PhysChCapabilityFDD_v770ext */
static int hf_rrc_tddPhysChCapability_384 = -1;   /* T_tddPhysChCapability_384 */
static int hf_rrc_uplinkPhysChCapability_03 = -1;  /* UL_PhysChCapabilityTDD_384_v770ext */
static int hf_rrc_tddPhysChCapability_768 = -1;   /* T_tddPhysChCapability_768 */
static int hf_rrc_downlinkPhysChCapability_03 = -1;  /* DL_PhysChCapabilityTDD_768 */
static int hf_rrc_uplinkPhysChCapability_04 = -1;  /* UL_PhysChCapabilityTDD_768 */
static int hf_rrc_tddPhysChCapability_128 = -1;   /* T_tddPhysChCapability_128 */
static int hf_rrc_downlinkPhysChCapability_04 = -1;  /* DL_PhysChCapabilityTDD_128_v770ext */
static int hf_rrc_uplinkPhysChCapability_05 = -1;  /* UL_PhysChCapabilityTDD_128_v770ext */
static int hf_rrc_fddPhysChCapability_02 = -1;    /* T_fddPhysChCapability_02 */
static int hf_rrc_downlinkPhysChCapability_05 = -1;  /* DL_PhysChCapabilityFDD_v860ext */
static int hf_rrc_tddPhysChCapability_128_01 = -1;  /* T_tddPhysChCapability_128_01 */
static int hf_rrc_downlinkPhysChCapability_06 = -1;  /* DL_PhysChCapabilityTDD_128_v860ext */
static int hf_rrc_fddPhysChCapability_03 = -1;    /* T_fddPhysChCapability_03 */
static int hf_rrc_downlinkPhysChCapability_07 = -1;  /* DL_PhysChCapabilityFDD_v920ext */
static int hf_rrc_uplinkPhysChCapability_06 = -1;  /* UL_PhysChCapabilityFDD_v920ext */
static int hf_rrc_fddPhysChCapability_04 = -1;    /* T_fddPhysChCapability_04 */
static int hf_rrc_downlinkPhysChCapability_08 = -1;  /* DL_PhysChCapabilityFDD_va40ext */
static int hf_rrc_tddPhysChCapability_128_02 = -1;  /* T_tddPhysChCapability_128_02 */
static int hf_rrc_downlinkPhysChCapability_09 = -1;  /* DL_PhysChCapabilityInfoTDD_128_va40ext */
static int hf_rrc_uplinkPhysChCapability_07 = -1;  /* UL_PhysChCapabilityInfoTDD_128_va40ext */
static int hf_rrc_fddPhysChCapability_05 = -1;    /* T_fddPhysChCapability_05 */
static int hf_rrc_downlinkPhysChCapability_10 = -1;  /* DL_PhysChCapabilityFDD_vb50ext */
static int hf_rrc_uplinkPhysChCapability_08 = -1;  /* UL_PhysChCapabilityFDD_vb50ext */
static int hf_rrc_tddPhysChCapability_768_01 = -1;  /* T_tddPhysChCapability_768_01 */
static int hf_rrc_downlinkPhysChCapability_11 = -1;  /* DL_PhysChCapabilityInfoTDD_768 */
static int hf_rrc_tddPhysChCapability_128_03 = -1;  /* T_tddPhysChCapability_128_03 */
static int hf_rrc_uplinkPhysChCapability_09 = -1;  /* UL_PhysChCapabilityInfoTDD_128_v770ext */
static int hf_rrc_tdd128_PhysChCapability = -1;   /* T_tdd128_PhysChCapability */
static int hf_rrc_downlinkPhysChCapability_12 = -1;  /* DL_PhysChCapabilityTDD_LCR_r4 */
static int hf_rrc_uplinkPhysChCapability_10 = -1;  /* UL_PhysChCapabilityTDD_LCR_r4 */
static int hf_rrc_fdd_hspdsch = -1;               /* T_fdd_hspdsch */
static int hf_rrc_supported_03 = -1;              /* T_supported_01 */
static int hf_rrc_hsdsch_physical_layer_category = -1;  /* HSDSCH_physical_layer_category */
static int hf_rrc_dummy2_06 = -1;                 /* BOOLEAN */
static int hf_rrc_tdd384_hspdsch = -1;            /* T_tdd384_hspdsch */
static int hf_rrc_tdd128_hspdsch = -1;            /* T_tdd128_hspdsch */
static int hf_rrc_numberOfRepetitionsPerSFNPeriod = -1;  /* T_numberOfRepetitionsPerSFNPeriod */
static int hf_rrc_supportEUTRA_FDD = -1;          /* BOOLEAN */
static int hf_rrc_supportEUTRA_TDD = -1;          /* BOOLEAN */
static int hf_rrc_noError = -1;                   /* NULL */
static int hf_rrc_errorOccurred = -1;             /* T_errorOccurred */
static int hf_rrc_protocolErrorInformation_01 = -1;  /* ProtocolErrorInformation */
static int hf_rrc_diagnosticsType = -1;           /* T_diagnosticsType */
static int hf_rrc_type1 = -1;                     /* T_type1 */
static int hf_rrc_asn1_ViolationOrEncodingError = -1;  /* NULL */
static int hf_rrc_messageTypeNonexistent = -1;    /* NULL */
static int hf_rrc_messageNotCompatibleWithReceiverState = -1;  /* IdentificationOfReceivedMessage */
static int hf_rrc_ie_ValueNotComprehended = -1;   /* IdentificationOfReceivedMessage */
static int hf_rrc_conditionalInformationElementError = -1;  /* IdentificationOfReceivedMessage */
static int hf_rrc_messageExtensionNotComprehended = -1;  /* IdentificationOfReceivedMessage */
static int hf_rrc_RadioFrequencyBandTDDextList_item = -1;  /* RadioFrequencyBandTDDext */
static int hf_rrc_t314_expired = -1;              /* BOOLEAN */
static int hf_rrc_t315_expired = -1;              /* BOOLEAN */
static int hf_rrc_interRATInfo = -1;              /* InterRATInfo */
static int hf_rrc_interRATInfo_01 = -1;           /* InterRATInfo_r6 */
static int hf_rrc_frequencyInfo_03 = -1;          /* NULL */
static int hf_rrc_interRATInfo_02 = -1;           /* InterRATInfo_v860ext */
static int hf_rrc_fddRF_Capability = -1;          /* T_fddRF_Capability */
static int hf_rrc_ue_PowerClass = -1;             /* UE_PowerClass */
static int hf_rrc_txRxFrequencySeparation = -1;   /* TxRxFrequencySeparation */
static int hf_rrc_tddRF_Capability = -1;          /* T_tddRF_Capability */
static int hf_rrc_radioFrequencyTDDBandList = -1;  /* RadioFrequencyBandTDDList */
static int hf_rrc_chipRateCapability = -1;        /* ChipRateCapability */
static int hf_rrc_tddRF_Capability_01 = -1;       /* T_tddRF_Capability_01 */
static int hf_rrc_radioFrequencyBandTDDList = -1;  /* RadioFrequencyBandTDDList */
static int hf_rrc_tdd384RF_Capability = -1;       /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd768RF_Capability = -1;       /* T_tdd768RF_Capability */
static int hf_rrc_radioFrequencyBandTDDList_01 = -1;  /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd128RF_Capability = -1;       /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd128RF_Capability_01 = -1;    /* RadioFrequencyBandTDDextList */
static int hf_rrc_tdd384RF_Capability_01 = -1;    /* RadioFrequencyBandTDDextList */
static int hf_rrc_tdd768RF_Capability_01 = -1;    /* RadioFrequencyBandTDDextList */
static int hf_rrc_supportOfMFBI = -1;             /* T_supportOfMFBI */
static int hf_rrc_totalRLC_AM_BufferSize = -1;    /* TotalRLC_AM_BufferSize */
static int hf_rrc_maximumRLC_WindowSize = -1;     /* MaximumRLC_WindowSize */
static int hf_rrc_maximumAM_EntityNumber = -1;    /* MaximumAM_EntityNumberRLC_Cap */
static int hf_rrc_totalRLC_AM_BufferSize_01 = -1;  /* TotalRLC_AM_BufferSize_r5_ext */
static int hf_rrc_supportOfTwoLogicalChannel = -1;  /* BOOLEAN */
static int hf_rrc_totalRLC_AM_BufferSize_02 = -1;  /* TotalRLC_AM_BufferSize_v920ext */
static int hf_rrc_totalRLC_AM_BufferSize_03 = -1;  /* TotalRLC_AM_BufferSize_va40ext */
static int hf_rrc_totalRLC_AM_BufferSize_04 = -1;  /* TotalRLC_AM_BufferSize_vb50ext */
static int hf_rrc_noRelease = -1;                 /* NULL */
static int hf_rrc_release = -1;                   /* T_release */
static int hf_rrc_RRC_MessageSequenceNumberList_item = -1;  /* RRC_MessageSequenceNumber */
static int hf_rrc_nonce = -1;                     /* BIT_STRING_SIZE_128 */
static int hf_rrc_ims_Information = -1;           /* OCTET_STRING_SIZE_1_32 */
static int hf_rrc_cipheringAlgorithmCap = -1;     /* T_cipheringAlgorithmCap */
static int hf_rrc_integrityProtectionAlgorithmCap = -1;  /* T_integrityProtectionAlgorithmCap */
static int hf_rrc_primary_E_RNTI = -1;            /* E_RNTI */
static int hf_rrc_secondary_E_RNTI = -1;          /* E_RNTI */
static int hf_rrc_scramblingCodeType = -1;        /* ScramblingCodeType */
static int hf_rrc_scramblingCodeNumber = -1;      /* UL_ScramblingCode */
static int hf_rrc_ms2_SchedTransmGrantHARQAlloc = -1;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_servingGrant = -1;              /* T_servingGrant */
static int hf_rrc_primary_Secondary_GrantSelector = -1;  /* T_primary_Secondary_GrantSelector */
static int hf_rrc_minReduced_E_DPDCH_GainFactor = -1;  /* MinReduced_E_DPDCH_GainFactor */
static int hf_rrc_e_DCH_minimumSet_E_TFCI = -1;   /* E_DCH_MinimumSet_E_TFCI */
static int hf_rrc_dpcchPowerOffset_SecondaryULFrequency = -1;  /* INTEGER_0_7 */
static int hf_rrc_pc_Preamble = -1;               /* PC_Preamble */
static int hf_rrc_deltaACK = -1;                  /* DeltaACK */
static int hf_rrc_deltaNACK = -1;                 /* DeltaNACK */
static int hf_rrc_dl_hspdsch_Information = -1;    /* DL_HSPDSCH_Information */
static int hf_rrc_harqInfo_02 = -1;               /* HARQ_Info */
static int hf_rrc_mac_hsResetIndicator = -1;      /* T_mac_hsResetIndicator */
static int hf_rrc_dl_hspdsch_Information_01 = -1;  /* DL_HSPDSCH_Information_r7 */
static int hf_rrc_mac_hsResetIndicator_01 = -1;   /* T_mac_hsResetIndicator_01 */
static int hf_rrc_dl_hspdsch_Information_02 = -1;  /* DL_HSPDSCH_Information_r8 */
static int hf_rrc_mac_hsResetIndicator_02 = -1;   /* T_mac_hsResetIndicator_02 */
static int hf_rrc_dl_hspdsch_Information_03 = -1;  /* DL_HSPDSCH_Information_r9 */
static int hf_rrc_mac_hsResetIndicator_03 = -1;   /* T_mac_hsResetIndicator_03 */
static int hf_rrc_deltaACK_01 = -1;               /* DeltaACK_r11 */
static int hf_rrc_deltaNACK_01 = -1;              /* DeltaNACK_r11 */
static int hf_rrc_dl_hspdsch_Information_04 = -1;  /* DL_HSPDSCH_Information_r11 */
static int hf_rrc_mac_hsResetIndicator_04 = -1;   /* T_mac_hsResetIndicator_04 */
static int hf_rrc_mac_hsResetIndicator_assisting = -1;  /* T_mac_hsResetIndicator_assisting */
static int hf_rrc_supported_04 = -1;              /* T_supported_02 */
static int hf_rrc_maxNoSCCPCH_RL = -1;            /* MaxNoSCCPCH_RL */
static int hf_rrc_simultaneousSCCPCH_DPCH_DPDCH_Reception = -1;  /* BOOLEAN */
static int hf_rrc_rab_InfoReplace = -1;           /* RAB_InfoReplace */
static int hf_rrc_STARTList_item = -1;            /* STARTSingle */
static int hf_rrc_SystemSpecificCapUpdateReqList_item = -1;  /* SystemSpecificCapUpdateReq */
static int hf_rrc_SystemSpecificCapUpdateReqList_r5_item = -1;  /* SystemSpecificCapUpdateReq_r5 */
static int hf_rrc_SystemSpecificCapUpdateReqList_r8_item = -1;  /* SystemSpecificCapUpdateReq_r8 */
static int hf_rrc_tmsi = -1;                      /* TMSI_GSM_MAP */
static int hf_rrc_dl_TransChCapability = -1;      /* DL_TransChCapability */
static int hf_rrc_ul_TransChCapability = -1;      /* UL_TransChCapability */
static int hf_rrc_supported_05 = -1;              /* MaxNoBits */
static int hf_rrc_srnc_Identity = -1;             /* SRNC_Identity */
static int hf_rrc_s_RNTI = -1;                    /* S_RNTI */
static int hf_rrc_all = -1;                       /* NULL */
static int hf_rrc_u_RNTI_BitMaskIndex_b1 = -1;    /* BIT_STRING_SIZE_31 */
static int hf_rrc_u_RNTI_BitMaskIndex_b2 = -1;    /* BIT_STRING_SIZE_30 */
static int hf_rrc_u_RNTI_BitMaskIndex_b3 = -1;    /* BIT_STRING_SIZE_29 */
static int hf_rrc_u_RNTI_BitMaskIndex_b4 = -1;    /* BIT_STRING_SIZE_28 */
static int hf_rrc_u_RNTI_BitMaskIndex_b5 = -1;    /* BIT_STRING_SIZE_27 */
static int hf_rrc_u_RNTI_BitMaskIndex_b6 = -1;    /* BIT_STRING_SIZE_26 */
static int hf_rrc_u_RNTI_BitMaskIndex_b7 = -1;    /* BIT_STRING_SIZE_25 */
static int hf_rrc_u_RNTI_BitMaskIndex_b8 = -1;    /* BIT_STRING_SIZE_24 */
static int hf_rrc_u_RNTI_BitMaskIndex_b9 = -1;    /* BIT_STRING_SIZE_23 */
static int hf_rrc_u_RNTI_BitMaskIndex_b10 = -1;   /* BIT_STRING_SIZE_22 */
static int hf_rrc_u_RNTI_BitMaskIndex_b11 = -1;   /* BIT_STRING_SIZE_21 */
static int hf_rrc_u_RNTI_BitMaskIndex_b12 = -1;   /* BIT_STRING_SIZE_20 */
static int hf_rrc_u_RNTI_BitMaskIndex_b13 = -1;   /* BIT_STRING_SIZE_19 */
static int hf_rrc_u_RNTI_BitMaskIndex_b14 = -1;   /* BIT_STRING_SIZE_18 */
static int hf_rrc_u_RNTI_BitMaskIndex_b15 = -1;   /* BIT_STRING_SIZE_17 */
static int hf_rrc_u_RNTI_BitMaskIndex_b16 = -1;   /* BIT_STRING_SIZE_16 */
static int hf_rrc_u_RNTI_BitMaskIndex_b17 = -1;   /* BIT_STRING_SIZE_15 */
static int hf_rrc_u_RNTI_BitMaskIndex_b18 = -1;   /* BIT_STRING_SIZE_14 */
static int hf_rrc_u_RNTI_BitMaskIndex_b19 = -1;   /* BIT_STRING_SIZE_13 */
static int hf_rrc_u_RNTI_BitMaskIndex_b20 = -1;   /* BIT_STRING_SIZE_12 */
static int hf_rrc_u_RNTI_BitMaskIndex_b21 = -1;   /* BIT_STRING_SIZE_11 */
static int hf_rrc_u_RNTI_BitMaskIndex_b22 = -1;   /* BIT_STRING_SIZE_10 */
static int hf_rrc_u_RNTI_BitMaskIndex_b23 = -1;   /* BIT_STRING_SIZE_9 */
static int hf_rrc_u_RNTI_BitMaskIndex_b24 = -1;   /* BIT_STRING_SIZE_8 */
static int hf_rrc_u_RNTI_BitMaskIndex_b25 = -1;   /* BIT_STRING_SIZE_7 */
static int hf_rrc_u_RNTI_BitMaskIndex_b26 = -1;   /* BIT_STRING_SIZE_6 */
static int hf_rrc_u_RNTI_BitMaskIndex_b27 = -1;   /* BIT_STRING_SIZE_5 */
static int hf_rrc_u_RNTI_BitMaskIndex_b28 = -1;   /* BIT_STRING_SIZE_4 */
static int hf_rrc_u_RNTI_BitMaskIndex_b29 = -1;   /* BIT_STRING_SIZE_3 */
static int hf_rrc_u_RNTI_BitMaskIndex_b30 = -1;   /* BIT_STRING_SIZE_2 */
static int hf_rrc_u_RNTI_BitMaskIndex_b31 = -1;   /* BIT_STRING_SIZE_1 */
static int hf_rrc_s_RNTI_2 = -1;                  /* S_RNTI_2 */
static int hf_rrc_supportOfLoggedMeasurementsIdlePCH = -1;  /* T_supportOfLoggedMeasurementsIdlePCH */
static int hf_rrc_ue_RadioAccessCapability_v690ext = -1;  /* UE_RadioAccessCapability_v690ext */
static int hf_rrc_ue_RATSpecificCapability_v690ext = -1;  /* InterRAT_UE_RadioAccessCapability_v690ext */
static int hf_rrc_v6b0NonCriticalExtensions_15 = -1;  /* T_v6b0NonCriticalExtensions_14 */
static int hf_rrc_ue_RadioAccessCapability_v6b0ext = -1;  /* UE_RadioAccessCapability_v6b0ext_IEs */
static int hf_rrc_v6e0NonCriticalExtensions_02 = -1;  /* T_v6e0NonCriticalExtensions_02 */
static int hf_rrc_ue_RadioAccessCapability_v6e0ext = -1;  /* UE_RadioAccessCapability_v6e0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_39 = -1;  /* T_v770NonCriticalExtensions_39 */
static int hf_rrc_ue_RadioAccessCapability_v770ext = -1;  /* UE_RadioAccessCapability_v770ext_IEs */
static int hf_rrc_v790NonCriticalExtensions_01 = -1;  /* T_v790NonCriticalExtensions_01 */
static int hf_rrc_ue_RadioAccessCapability_v790ext = -1;  /* UE_RadioAccessCapability_v790ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_25 = -1;  /* T_v860NonCriticalExtensions_25 */
static int hf_rrc_ue_RadioAccessCapability_v860ext = -1;  /* UE_RadioAccessCapability_v860ext_IEs */
static int hf_rrc_ue_RATSpecificCapability_v860ext = -1;  /* InterRAT_UE_RadioAccessCapability_v860ext */
static int hf_rrc_v880NonCriticalExtensions_01 = -1;  /* T_v880NonCriticalExtensions_01 */
static int hf_rrc_ue_RadioAccessCapability_v880ext = -1;  /* UE_RadioAccessCapability_v880ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_10 = -1;  /* T_v890NonCriticalExtensions_10 */
static int hf_rrc_ue_RadioAccessCapability_v890ext = -1;  /* UE_RadioAccessCapability_v890ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_03 = -1;  /* T_v920NonCriticalExtensions_03 */
static int hf_rrc_ue_RadioAccessCapability_v920ext = -1;  /* UE_RadioAccessCapability_v920ext_IEs */
static int hf_rrc_v970NonCriticalExtensions_03 = -1;  /* T_v970NonCriticalExtensions_03 */
static int hf_rrc_ue_RadioAccessCapability_v970ext = -1;  /* UE_RadioAccessCapability_v970ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_18 = -1;  /* T_va40NonCriticalExtensions_17 */
static int hf_rrc_ue_RadioAccessCapability_va40ext = -1;  /* UE_RadioAccessCapability_va40ext_IEs */
static int hf_rrc_va60NonCriticalExtensions = -1;  /* T_va60NonCriticalExtensions */
static int hf_rrc_ue_RadioAccessCapability_va60ext = -1;  /* UE_RadioAccessCapability_va60ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_01 = -1;  /* T_va80NonCriticalExtensions_01 */
static int hf_rrc_ue_RadioAccessCapability_va80ext = -1;  /* UE_RadioAccessCapability_va80ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_67 = -1;  /* UE_RadioAccessCapability_LaterNonCriticalExtensions */
static int hf_rrc_supportForSIB11bis_01 = -1;     /* T_supportForSIB11bis_01 */
static int hf_rrc_supportForFDPCH_02 = -1;        /* T_supportForFDPCH_02 */
static int hf_rrc_pdcp_Capability_01 = -1;        /* PDCP_Capability_v770ext */
static int hf_rrc_rlc_Capability = -1;            /* RLC_Capability_v770ext */
static int hf_rrc_rf_Capability = -1;             /* RF_Capability_v770ext */
static int hf_rrc_physicalChannelCapability = -1;  /* PhysicalChannelCapability_v770ext */
static int hf_rrc_multiModeRAT_Capability = -1;   /* MultiModeRAT_Capability_v770ext */
static int hf_rrc_ue_PositioningCapability = -1;  /* UE_PositioningCapability_v770ext */
static int hf_rrc_mac_ehsSupport_01 = -1;         /* T_mac_ehsSupport_01 */
static int hf_rrc_ue_specificCapabilityInformation = -1;  /* UE_SpecificCapabilityInformation_LCRTDD */
static int hf_rrc_supportForEDPCCHPowerBoosting_01 = -1;  /* T_supportForEDPCCHPowerBoosting_01 */
static int hf_rrc_rf_Capability_01 = -1;          /* RF_Capability_v860ext */
static int hf_rrc_physicalChannelCapability_01 = -1;  /* PhysicalChannelCapability_v860ext */
static int hf_rrc_multiModeRAT_Capability_01 = -1;  /* MultiModeRAT_Capability_v860ext */
static int hf_rrc_ue_PositioningCapability_01 = -1;  /* UE_PositioningCapability_v860ext */
static int hf_rrc_measurementCapability = -1;     /* MeasurementCapability_v860ext */
static int hf_rrc_measurementCapabilityTDD = -1;  /* MeasurementCapabilityTDD */
static int hf_rrc_supportOfCommonEDCH_04 = -1;    /* T_supportOfCommonEDCH_04 */
static int hf_rrc_supportOfMACiis_04 = -1;        /* T_supportOfMACiis_04 */
static int hf_rrc_supportOfSPSOperation_02 = -1;  /* T_supportOfSPSOperation_02 */
static int hf_rrc_supportOfControlChannelDRXOperation_01 = -1;  /* T_supportOfControlChannelDRXOperation_01 */
static int hf_rrc_supportOfCSG_01 = -1;           /* T_supportOfCSG_01 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList3 = -1;  /* UE_RadioAccessCapabBandFDDList3 */
static int hf_rrc_supportForPriorityReselectionInUTRAN = -1;  /* T_supportForPriorityReselectionInUTRAN */
static int hf_rrc_supportCellSpecificTxDiversityinDC_Operation = -1;  /* T_supportCellSpecificTxDiversityinDC_Operation */
static int hf_rrc_ue_RadioAccessCapabBandCombList = -1;  /* UE_RadioAccessCapabBandCombList */
static int hf_rrc_physicalChannelCapability_02 = -1;  /* PhysicalChannelCapability_v920ext */
static int hf_rrc_rlc_Capability_01 = -1;         /* RLC_Capability_v920ext */
static int hf_rrc_supportOfenhancedTS0 = -1;      /* T_supportOfenhancedTS0 */
static int hf_rrc_measurementCapability_01 = -1;  /* MeasurementCapability_v920ext */
static int hf_rrc_csgProximityIndicationCapability = -1;  /* CSG_ProximityIndicationCapability */
static int hf_rrc_neighCellSI_AcquisitionCapability = -1;  /* NeighCellSI_AcquisitionCapability */
static int hf_rrc_ue_ExtendedMeasurementSupport = -1;  /* T_ue_ExtendedMeasurementSupport */
static int hf_rrc_voiceOverUTRA_PS_HS_Support = -1;  /* T_voiceOverUTRA_PS_HS_Support */
static int hf_rrc_srvcc_SupportFromUTRA_to_UTRA = -1;  /* T_srvcc_SupportFromUTRA_to_UTRA */
static int hf_rrc_srvcc_SupportFromUTRA_to_GERAN = -1;  /* T_srvcc_SupportFromUTRA_to_GERAN */
static int hf_rrc_ue_supportMac_ehsWindowSizeExtension = -1;  /* T_ue_supportMac_ehsWindowSizeExtension */
static int hf_rrc_v9c0NonCriticalExtensions_12 = -1;  /* T_v9c0NonCriticalExtensions_12 */
static int hf_rrc_ue_RadioAccessCapability_v9c0ext = -1;  /* UE_RadioAccessCapability_v9c0ext_IEs */
static int hf_rrc_vaa0NonCriticalExtensions_02 = -1;  /* T_vaa0NonCriticalExtensions_02 */
static int hf_rrc_ue_RadioAccessCapability_vaa0ext = -1;  /* UE_RadioAccessCapability_vaa0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_23 = -1;  /* T_vb50NonCriticalExtensions_23 */
static int hf_rrc_ue_RadioAccessCapability_vb50ext = -1;  /* UE_RadioAccessCapability_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_195 = -1;  /* T_nonCriticalExtensions_195 */
static int hf_rrc_ue_RadioAccessCapabBandCombList_va40ext = -1;  /* UE_RadioAccessCapabBandCombList_va40ext */
static int hf_rrc_physicalChannelCapability_03 = -1;  /* PhysicalChannelCapability_va40ext */
static int hf_rrc_rlc_Capability_02 = -1;         /* RLC_Capability_va40ext */
static int hf_rrc_measurementCapability_02 = -1;  /* MeasurementCapability_va40ext */
static int hf_rrc_supportOfMUMIMO = -1;           /* T_supportOfMUMIMO */
static int hf_rrc_supportForDualCellMimoInDifferentBands = -1;  /* T_supportForDualCellMimoInDifferentBands */
static int hf_rrc_ue_BasedNetworkPerformanceMeasurementsParameters = -1;  /* UE_BasedNetworkPerformanceMeasurementsParameters */
static int hf_rrc_supportOfUTRANANR = -1;         /* T_supportOfUTRANANR */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4 = -1;  /* UE_RadioAccessCapabBandFDDList4 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_01 = -1;  /* UE_RadioAccessCapabBandFDDList4_va60ext */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_02 = -1;  /* UE_RadioAccessCapabBandFDDList4_va80ext */
static int hf_rrc_supportOfUMRLCre_establish_via_reconfig = -1;  /* T_supportOfUMRLCre_establish_via_reconfig */
static int hf_rrc_rf_capability = -1;             /* RF_Capability_vaa0ext */
static int hf_rrc_multiModeRAT_Capability_02 = -1;  /* MultiModeRAT_Capability_vb50ext */
static int hf_rrc_supportOfCommonERGCHBasedInterferenceControl = -1;  /* T_supportOfCommonERGCHBasedInterferenceControl */
static int hf_rrc_supportOfFallbackToR99PRACH = -1;  /* T_supportOfFallbackToR99PRACH */
static int hf_rrc_supportOfConcurrentDeployment = -1;  /* T_supportOfConcurrentDeployment */
static int hf_rrc_supportOfTTIalignmentAndPerHARQProcess = -1;  /* T_supportOfTTIalignmentAndPerHARQProcess */
static int hf_rrc_ue_RadioAccessCapabBandCombList_vb50ext = -1;  /* UE_RadioAccessCapabBandCombList_vb50ext */
static int hf_rrc_multiflowCapabBandCombList = -1;  /* MultiflowCapabBandCombList */
static int hf_rrc_physicalChannelCapability_04 = -1;  /* PhysicalChannelCapability_vb50ext */
static int hf_rrc_rlc_Capability_03 = -1;         /* RLC_Capability_vb50ext */
static int hf_rrc_multiflowCapability = -1;       /* MultiflowCapability */
static int hf_rrc_ue_RadioAccessCapabBandFDDList6 = -1;  /* UE_RadioAccessCapabBandFDDList6 */
static int hf_rrc_measurementCapability_03 = -1;  /* MeasurementCapability_vb50ext */
static int hf_rrc_measurementCapabilityTDD_01 = -1;  /* MeasurementCapabilityTDD_vb50ext */
static int hf_rrc_rsrvcc_SupportFromUTRA_CS_to_EUTRA_FDD = -1;  /* T_rsrvcc_SupportFromUTRA_CS_to_EUTRA_FDD */
static int hf_rrc_rsrvcc_SupportFromUTRA_CS_to_EUTRA_TDD = -1;  /* T_rsrvcc_SupportFromUTRA_CS_to_EUTRA_TDD */
static int hf_rrc_supportOfHSDPCCHPowerOffsetExtension = -1;  /* T_supportOfHSDPCCHPowerOffsetExtension */
static int hf_rrc_supportOfSTTDOnDLControlChannelsWhenMultiflowOperationIsActive = -1;  /* T_supportOfSTTDOnDLControlChannelsWhenMultiflowOperationIsActive */
static int hf_rrc_t_301 = -1;                     /* T_301 */
static int hf_rrc_n_301 = -1;                     /* N_301 */
static int hf_rrc_t_302 = -1;                     /* T_302 */
static int hf_rrc_n_302 = -1;                     /* N_302 */
static int hf_rrc_t_304 = -1;                     /* T_304 */
static int hf_rrc_n_304 = -1;                     /* N_304 */
static int hf_rrc_t_305 = -1;                     /* T_305 */
static int hf_rrc_t_307 = -1;                     /* T_307 */
static int hf_rrc_t_308 = -1;                     /* T_308 */
static int hf_rrc_t_309 = -1;                     /* T_309 */
static int hf_rrc_t_310 = -1;                     /* T_310 */
static int hf_rrc_n_310 = -1;                     /* N_310 */
static int hf_rrc_t_311 = -1;                     /* T_311 */
static int hf_rrc_t_312 = -1;                     /* T_312 */
static int hf_rrc_n_312 = -1;                     /* N_312 */
static int hf_rrc_t_313 = -1;                     /* T_313 */
static int hf_rrc_n_313 = -1;                     /* N_313 */
static int hf_rrc_t_314 = -1;                     /* T_314 */
static int hf_rrc_t_315 = -1;                     /* T_315 */
static int hf_rrc_n_315 = -1;                     /* N_315 */
static int hf_rrc_t_316 = -1;                     /* T_316 */
static int hf_rrc_t_317 = -1;                     /* T_317 */
static int hf_rrc_n_312_01 = -1;                  /* N_312ext */
static int hf_rrc_n_315_01 = -1;                  /* N_315ext */
static int hf_rrc_n_312_02 = -1;                  /* N_312_r5 */
static int hf_rrc_n_315_02 = -1;                  /* N_315_r5 */
static int hf_rrc_t_323 = -1;                     /* T_323 */
static int hf_rrc_networkAssistedGANSS_supportedList = -1;  /* NetworkAssistedGANSS_Supported_List */
static int hf_rrc_networkAssistedGANSS_supportedList_01 = -1;  /* NetworkAssistedGANSS_Supported_List_v860ext */
static int hf_rrc_t_300 = -1;                     /* T_300 */
static int hf_rrc_n_300 = -1;                     /* N_300 */
static int hf_rrc_multiRAT_CapabilityList = -1;   /* MultiRAT_Capability */
static int hf_rrc_multiModeCapability = -1;       /* MultiModeCapability */
static int hf_rrc_pdcp_Capability_02 = -1;        /* PDCP_Capability */
static int hf_rrc_rlc_Capability_04 = -1;         /* RLC_Capability */
static int hf_rrc_transportChannelCapability = -1;  /* TransportChannelCapability */
static int hf_rrc_rf_Capability_02 = -1;          /* RF_Capability */
static int hf_rrc_physicalChannelCapability_05 = -1;  /* PhysicalChannelCapability */
static int hf_rrc_ue_MultiModeRAT_Capability = -1;  /* UE_MultiModeRAT_Capability */
static int hf_rrc_ue_positioning_Capability = -1;  /* UE_Positioning_Capability */
static int hf_rrc_measurementCapability_04 = -1;  /* MeasurementCapability */
static int hf_rrc_ue_RadioAccessCapabBandFDDList = -1;  /* UE_RadioAccessCapabBandFDDList */
static int hf_rrc_ue_PositioningCapabilityExt_v380 = -1;  /* UE_PositioningCapabilityExt_v380 */
static int hf_rrc_ue_PositioningCapabilityExt_v3a0 = -1;  /* UE_PositioningCapabilityExt_v3a0 */
static int hf_rrc_ue_PositioningCapabilityExt_v3g0 = -1;  /* UE_PositioningCapabilityExt_v3g0 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList2 = -1;  /* UE_RadioAccessCapabBandFDDList2 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList_ext = -1;  /* UE_RadioAccessCapabBandFDDList_ext */
static int hf_rrc_physicalchannelcapability_edch = -1;  /* PhysicalChannelCapability_edch_r6 */
static int hf_rrc_deviceType = -1;                /* T_deviceType */
static int hf_rrc_supportForTwoDRXSchemesInPCH_02 = -1;  /* T_supportForTwoDRXSchemesInPCH_02 */
static int hf_rrc_supportEDPDCHPowerInterpolation = -1;  /* T_supportEDPDCHPowerInterpolation */
static int hf_rrc_supportofTxDivOnNonMIMOChannel = -1;  /* T_supportofTxDivOnNonMIMOChannel */
static int hf_rrc_physicalChannelCapability_LCR = -1;  /* PhysicalChannelCapability_LCR_r4 */
static int hf_rrc_ue_RadioAccessCapabilityComp_TDD128 = -1;  /* UE_RadioAccessCapabilityComp_TDD128_v7f0ext */
static int hf_rrc_physicalChannelCapability_06 = -1;  /* PhysicalChannelCapabilityInfo_v770ext */
static int hf_rrc_ganssSupportIndication = -1;    /* T_ganssSupportIndication */
static int hf_rrc_mac_ehsSupport_02 = -1;         /* T_mac_ehsSupport_02 */
static int hf_rrc_ue_SpecificCapabilityInformation = -1;  /* UE_SpecificCapabilityInformation_LCRTDD */
static int hf_rrc_supportForPriorityReselectionInUTRAN_01 = -1;  /* T_supportForPriorityReselectionInUTRAN_01 */
static int hf_rrc_supportOfenhancedTS0_01 = -1;   /* T_supportOfenhancedTS0_01 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_va60ext = -1;  /* UE_RadioAccessCapabBandFDDList4_va60ext */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_va80ext = -1;  /* UE_RadioAccessCapabBandFDDList4_va80ext */
static int hf_rrc_ue_RadioAccessCapabBandFDDList5 = -1;  /* UE_RadioAccessCapabBandFDDList5 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList_ext2 = -1;  /* UE_RadioAccessCapabBandFDDList_ext2 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList2_item = -1;  /* UE_RadioAccessCapabBandFDD2 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList3_item = -1;  /* UE_RadioAccessCapabBandFDD3 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList4_item = -1;  /* UE_RadioAccessCapabBandFDD4 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList4_va60ext_item = -1;  /* UE_RadioAccessCapabBandFDD4_va60ext */
static int hf_rrc_UE_RadioAccessCapabBandFDDList4_va80ext_item = -1;  /* UE_RadioAccessCapabBandFDD4_va80ext */
static int hf_rrc_UE_RadioAccessCapabBandFDDList5_item = -1;  /* UE_RadioAccessCapabBandFDD5 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList6_item = -1;  /* UE_RadioAccessCapabBandFDD6 */
static int hf_rrc_fddRF_Capability_01 = -1;       /* T_fddRF_Capability_01 */
static int hf_rrc_ue_PowerClass_01 = -1;          /* UE_PowerClassExt */
static int hf_rrc_measurementCapability2 = -1;    /* MeasurementCapabilityExt2 */
static int hf_rrc_measurementCapability3 = -1;    /* MeasurementCapabilityExt3 */
static int hf_rrc_additionalSecondaryCells = -1;  /* T_additionalSecondaryCells */
static int hf_rrc_nonContiguousMultiCellCombinationList = -1;  /* NonContiguousMultiCellCombinationList */
static int hf_rrc_supportofULOLTD = -1;           /* T_supportofULOLTD */
static int hf_rrc_additionalSecondaryCells_01 = -1;  /* T_additionalSecondaryCells_01 */
static int hf_rrc_supportofULOLTD_01 = -1;        /* T_supportofULOLTD_01 */
static int hf_rrc_fddRF_Capability_02 = -1;       /* T_fddRF_Capability_02 */
static int hf_rrc_measurementCapability4 = -1;    /* MeasurementCapabilityExt4 */
static int hf_rrc_additionalSecondaryCells2 = -1;  /* T_additionalSecondaryCells2 */
static int hf_rrc_supportOfULCLTD = -1;           /* T_supportOfULCLTD */
static int hf_rrc_multiflowCapability_01 = -1;    /* MultiflowPerBandCapability */
static int hf_rrc_mimo4x4CapabilityBand = -1;     /* T_mimo4x4CapabilityBand */
static int hf_rrc_supportOfULMIMO = -1;           /* T_supportOfULMIMO */
static int hf_rrc_measurementCapability5 = -1;    /* MeasurementCapabilityExt5 */
static int hf_rrc_freqSpecificCompressedModeForNonContiguous = -1;  /* T_freqSpecificCompressedModeForNonContiguous */
static int hf_rrc_rx_tx_TimeDifferenceType2Capable = -1;  /* BOOLEAN */
static int hf_rrc_validity_CellPCH_UraPCH = -1;   /* T_validity_CellPCH_UraPCH */
static int hf_rrc_sfn_sfnType2Capability = -1;    /* T_sfn_sfnType2Capability */
static int hf_rrc_ue_GANSSPositioning_Capability = -1;  /* UE_GANSSPositioning_Capability */
static int hf_rrc_ue_GANSSPositioning_Capability_v860ext = -1;  /* UE_GANSSPositioning_Capability_v860ext_IEs */
static int hf_rrc_UE_RadioAccessCapabBandCombList_item = -1;  /* BandComb */
static int hf_rrc_UE_RadioAccessCapabBandFDDList_item = -1;  /* UE_RadioAccessCapabBandFDD */
static int hf_rrc_UE_RadioAccessCapabBandFDDList_ext_item = -1;  /* UE_RadioAccessCapabBandFDD_ext */
static int hf_rrc_UE_RadioAccessCapabBandFDDList_ext2_item = -1;  /* UE_RadioAccessCapabBandFDD_ext2 */
static int hf_rrc_fddRF_Capability_03 = -1;       /* T_fddRF_Capability_03 */
static int hf_rrc_measurementCapability_05 = -1;  /* MeasurementCapabilityExt */
static int hf_rrc_compressedModeMeasCapabFDDList_ext = -1;  /* CompressedModeMeasCapabFDDList_ext */
static int hf_rrc_pdcp_Capability_r4_ext = -1;    /* PDCP_Capability_r4_ext */
static int hf_rrc_tdd_CapabilityExt = -1;         /* T_tdd_CapabilityExt */
static int hf_rrc_rf_Capability_03 = -1;          /* RF_Capability_r4_ext */
static int hf_rrc_measurementCapability_r4_ext = -1;  /* MeasurementCapability_r4_ext */
static int hf_rrc_totalAM_RLCMemoryExceeds10kB = -1;  /* BOOLEAN */
static int hf_rrc_rf_CapabilityComp = -1;         /* RF_CapabilityComp */
static int hf_rrc_rf_CapabilityFDDComp_01 = -1;   /* RF_CapabBandListFDDComp_ext */
static int hf_rrc_hSDSCH_physical_layer_category = -1;  /* HSDSCH_physical_layer_category */
static int hf_rrc_tdd_edch_PhysicalLayerCategory = -1;  /* INTEGER_1_6 */
static int hf_rrc_dl_CapabilityWithSimultaneousHS_DSCHConfig = -1;  /* DL_CapabilityWithSimultaneousHS_DSCHConfig */
static int hf_rrc_supportForCSVoiceoverHSPA_02 = -1;  /* T_supportForCSVoiceoverHSPA_02 */
static int hf_rrc_rf_CapabilityComp_01 = -1;      /* RF_CapabilityComp_v770ext */
static int hf_rrc_securityCapabilityIndication = -1;  /* T_securityCapabilityIndication */
static int hf_rrc_ganssSupportIndication_01 = -1;  /* T_ganssSupportIndication_01 */
static int hf_rrc_mac_ehsSupport_03 = -1;         /* T_mac_ehsSupport_03 */
static int hf_rrc_fddPhysicalChannelCapab_hspdsch_edch = -1;  /* T_fddPhysicalChannelCapab_hspdsch_edch */
static int hf_rrc_physicalChannelCapabComp_hspdsch_r6 = -1;  /* HSDSCH_physical_layer_category */
static int hf_rrc_physicalChannelCapability_edch_r6 = -1;  /* PhysicalChannelCapability_edch_r6 */
static int hf_rrc_edch_PhysicalLayerCategory_extension = -1;  /* INTEGER_7 */
static int hf_rrc_hsscchlessHsdschOperation_01 = -1;  /* T_hsscchlessHsdschOperation_01 */
static int hf_rrc_enhancedFdpch_01 = -1;          /* T_enhancedFdpch_01 */
static int hf_rrc_hsdschReception_CellFach_01 = -1;  /* T_hsdschReception_CellFach_01 */
static int hf_rrc_hsdschReception_CellUraPch_01 = -1;  /* T_hsdschReception_CellUraPch_01 */
static int hf_rrc_discontinuousDpcchTransmission_01 = -1;  /* T_discontinuousDpcchTransmission_01 */
static int hf_rrc_slotFormat4 = -1;               /* T_slotFormat4 */
static int hf_rrc_supportofTxDivOnNonMIMOChannel_01 = -1;  /* T_supportofTxDivOnNonMIMOChannel_01 */
static int hf_rrc_supportOfMACiis_05 = -1;        /* T_supportOfMACiis_05 */
static int hf_rrc_edch_PhysicalLayerCategory_extension2 = -1;  /* INTEGER_8_9 */
static int hf_rrc_edch_PhysicalLayerCategory_extension3 = -1;  /* INTEGER_10_12 */
static int hf_rrc_supportOfHSDPCCHPowerOffsetExtension_01 = -1;  /* T_supportOfHSDPCCHPowerOffsetExtension_01 */
static int hf_rrc_supportOfSFModeForHSPDSCHDualStream_01 = -1;  /* T_supportOfSFModeForHSPDSCHDualStream_01 */
static int hf_rrc_supportOfCommonEDCH_05 = -1;    /* T_supportOfCommonEDCH_05 */
static int hf_rrc_supportOfMACiis_06 = -1;        /* T_supportOfMACiis_06 */
static int hf_rrc_supportOfSPSOperation_03 = -1;  /* T_supportOfSPSOperation_03 */
static int hf_rrc_supportOfControlChannelDRXOperation_02 = -1;  /* T_supportOfControlChannelDRXOperation_02 */
static int hf_rrc_fdd_48 = -1;                    /* T_fdd_47 */
static int hf_rrc_supported_06 = -1;              /* RF_CapabBandListFDDComp */
static int hf_rrc_tdd384_RF_Capability = -1;      /* T_tdd384_RF_Capability */
static int hf_rrc_supported_07 = -1;              /* RadioFrequencyBandTDDList */
static int hf_rrc_tdd128_RF_Capability_01 = -1;   /* T_tdd128_RF_Capability */
static int hf_rrc_tdd384_RF_Capability_01 = -1;   /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd768_RF_Capability = -1;      /* T_tdd768_RF_Capability */
static int hf_rrc_supported_08 = -1;              /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd128_RF_Capability_02 = -1;   /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_RF_CapabBandListFDDComp_item = -1;  /* RF_CapabBandFDDComp */
static int hf_rrc_RF_CapabBandListFDDComp_ext_item = -1;  /* RF_CapabBandFDDComp */
static int hf_rrc_RF_CapabBandListFDDComp_ext2_item = -1;  /* RF_CapabBandFDDComp */
static int hf_rrc_UE_RadioAccessCapabBandCombList_va40ext_item = -1;  /* SupportedCarrierCombination */
static int hf_rrc_UE_RadioAccessCapabBandCombList_vb50ext_item = -1;  /* SupportedCarrierCombination_ext */
static int hf_rrc_carrierCombination12 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination21 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination13 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination31 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination22 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination14 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination41 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination15 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination51 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination16 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination61 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination17 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination71 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination23 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination32 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination24 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination42 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination25 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination52 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination26 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination62 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination33 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination34 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination43 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination44 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination35 = -1;      /* BOOLEAN */
static int hf_rrc_carrierCombination53 = -1;      /* BOOLEAN */
static int hf_rrc_pdcp_Capability_r5_ext = -1;    /* PDCP_Capability_r5_ext */
static int hf_rrc_rlc_Capability_r5_ext = -1;     /* RLC_Capability_r5_ext */
static int hf_rrc_physicalChannelCapability_07 = -1;  /* PhysicalChannelCapability_hspdsch_r5 */
static int hf_rrc_multiModeRAT_Capability_v590ext = -1;  /* MultiModeRAT_Capability_v590ext */
static int hf_rrc_pdcp_Capability_r5_ext2 = -1;   /* PDCP_Capability_r5_ext2 */
static int hf_rrc_multiModeRAT_Capability_v680ext = -1;  /* MultiModeRAT_Capability_v680ext */
static int hf_rrc_ulOLTDActivation = -1;          /* T_ulOLTDActivation */
static int hf_rrc_maxNoDPDCH_BitsTransmitted = -1;  /* MaxNoDPDCH_BitsTransmitted */
static int hf_rrc_discontinuousDpcchTransmission_02 = -1;  /* T_discontinuousDpcchTransmission_02 */
static int hf_rrc_slotFormat4_01 = -1;            /* T_slotFormat4_01 */
static int hf_rrc_maxPhysChPerTimeslot = -1;      /* MaxPhysChPerTimeslot */
static int hf_rrc_minimumSF_02 = -1;              /* MinimumSF_UL */
static int hf_rrc_supportOfPUSCH = -1;            /* BOOLEAN */
static int hf_rrc_tdd384_edch = -1;               /* T_tdd384_edch */
static int hf_rrc_supported_09 = -1;              /* T_supported_03 */
static int hf_rrc_tdd_edch_PhysicalLayerCategory_01 = -1;  /* INTEGER_1_16 */
static int hf_rrc_maxPhysChPerTimeslot_01 = -1;   /* MaxPhysChPerTimeslot_LCR_r7 */
static int hf_rrc_tdd128_edch = -1;               /* T_tdd128_edch */
static int hf_rrc_supported_10 = -1;              /* T_supported_04 */
static int hf_rrc_multiCarrier_EdchPhysicalLayerCategory_128 = -1;  /* INTEGER_1_8 */
static int hf_rrc_maxNumberCarrierForMCHSUPA_TDD = -1;  /* T_maxNumberCarrierForMCHSUPA_TDD */
static int hf_rrc_tdd384_edch_01 = -1;            /* T_tdd384_edch_01 */
static int hf_rrc_supported_11 = -1;              /* T_supported_05 */
static int hf_rrc_continue = -1;                  /* NULL */
static int hf_rrc_newConfiguration = -1;          /* T_newConfiguration */
static int hf_rrc_secondaryServingEDCHCell_Info = -1;  /* SecondaryServingEDCHCell_Info */
static int hf_rrc_secondaryEDCH_Info_Common = -1;  /* SecondaryEDCH_Info_Common */
static int hf_rrc_dl_InformationPerSecondaryRL_List = -1;  /* DL_InformationPerSecondaryRL_List */
static int hf_rrc_fdd_edch = -1;                  /* T_fdd_edch */
static int hf_rrc_supported_12 = -1;              /* T_supported_06 */
static int hf_rrc_edch_PhysicalLayerCategory = -1;  /* INTEGER_1_16 */
static int hf_rrc_maxNoBitsTransmitted = -1;      /* MaxNoBits */
static int hf_rrc_maxConvCodeBitsTransmitted = -1;  /* MaxNoBits */
static int hf_rrc_turboEncodingSupport = -1;      /* TurboSupport */
static int hf_rrc_maxSimultaneousTransChs_01 = -1;  /* MaxSimultaneousTransChsUL */
static int hf_rrc_modeSpecificInfo_18 = -1;       /* T_modeSpecificInfo_18 */
static int hf_rrc_tdd_13 = -1;                    /* T_tdd_12 */
static int hf_rrc_maxTransmittedBlocks = -1;      /* MaxTransportBlocksUL */
static int hf_rrc_maxNumberOfTFC_01 = -1;         /* MaxNumberOfTFC_UL */
static int hf_rrc_standaloneLocMethodsSupported = -1;  /* BOOLEAN */
static int hf_rrc_ue_BasedOTDOA_Supported = -1;   /* BOOLEAN */
static int hf_rrc_networkAssistedGPS_Supported = -1;  /* NetworkAssistedGPS_Supported */
static int hf_rrc_supportForUE_GPS_TimingOfCellFrames = -1;  /* BOOLEAN */
static int hf_rrc_supportForIPDL = -1;            /* BOOLEAN */
static int hf_rrc_start_CS = -1;                  /* START_Value */
static int hf_rrc_start_PS = -1;                  /* START_Value */
static int hf_rrc_drx_CycleLengthCoefficient = -1;  /* INTEGER_3_9 */
static int hf_rrc_drx_CycleLengthCoefficient2 = -1;  /* INTEGER_3_9 */
static int hf_rrc_timeForDRXCycle2 = -1;          /* T_319 */
static int hf_rrc_rfc2507_Info = -1;              /* RFC2507_Info */
static int hf_rrc_rfc3095_Info = -1;              /* RFC3095_Info_r4 */
static int hf_rrc_logicalChannelIdentity = -1;    /* LogicalChannelIdentity */
static int hf_rrc_mac_ehs_QueueId = -1;           /* MAC_ehs_QueueId */
static int hf_rrc_maxCS_Delay = -1;               /* MaxCS_Delay */
static int hf_rrc_defaultConfigIdForCellFACH = -1;  /* DefaultConfigIdForCellFACH */
static int hf_rrc_inSequenceDelivery = -1;        /* BOOLEAN */
static int hf_rrc_receivingWindowSize = -1;       /* ReceivingWindowSize */
static int hf_rrc_dl_RLC_StatusInfo = -1;         /* DL_RLC_StatusInfo */
static int hf_rrc_dl_RLC_PDU_size = -1;           /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_dl_RLC_PDU_size_01 = -1;        /* T_dl_RLC_PDU_size */
static int hf_rrc_fixedSize = -1;                 /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_flexibleSize = -1;              /* T_flexibleSize */
static int hf_rrc_dl_RLC_PDU_size_02 = -1;        /* T_dl_RLC_PDU_size_01 */
static int hf_rrc_flexibleSize_01 = -1;           /* T_flexibleSize_01 */
static int hf_rrc_dl_RLC_StatusInfo_01 = -1;      /* DL_RLC_StatusInfo_r11 */
static int hf_rrc_rB_WithPDCP_InfoList = -1;      /* RB_WithPDCP_InfoList */
static int hf_rrc_rb_WithPDCP_InfoList = -1;      /* RB_WithPDCP_InfoList */
static int hf_rrc_dl_TransportChannelType = -1;   /* DL_TransportChannelType */
static int hf_rrc_dl_TransportChannelType_01 = -1;  /* DL_TransportChannelType_r5 */
static int hf_rrc_dl_TransportChannelType_02 = -1;  /* DL_TransportChannelType_r7 */
static int hf_rrc_DL_LogicalChannelMappingList_item = -1;  /* DL_LogicalChannelMapping */
static int hf_rrc_DL_LogicalChannelMappingList_r5_item = -1;  /* DL_LogicalChannelMapping_r5 */
static int hf_rrc_DL_LogicalChannelMappingList_r7_item = -1;  /* DL_LogicalChannelMapping_r7 */
static int hf_rrc_dummy_32 = -1;                  /* CID_InclusionInfo_r4 */
static int hf_rrc_max_CID = -1;                   /* INTEGER_1_16383 */
static int hf_rrc_reverseDecompressionDepth = -1;  /* INTEGER_0_65535 */
static int hf_rrc_dl_AM_RLC_Mode = -1;            /* DL_AM_RLC_Mode */
static int hf_rrc_dl_UM_RLC_Mode = -1;            /* NULL */
static int hf_rrc_dl_TM_RLC_Mode = -1;            /* DL_TM_RLC_Mode */
static int hf_rrc_dl_AM_RLC_Mode_01 = -1;         /* DL_AM_RLC_Mode_r5 */
static int hf_rrc_dl_UM_RLC_Mode_01 = -1;         /* DL_UM_RLC_Mode_r5 */
static int hf_rrc_dl_UM_RLC_Mode_02 = -1;         /* DL_UM_RLC_Mode_r6 */
static int hf_rrc_dl_AM_RLC_Mode_02 = -1;         /* DL_AM_RLC_Mode_r7 */
static int hf_rrc_dl_AM_RLC_Mode_03 = -1;         /* DL_AM_RLC_Mode_r11 */
static int hf_rrc_timerStatusProhibit = -1;       /* TimerStatusProhibit */
static int hf_rrc_dummy_33 = -1;                  /* TimerEPC */
static int hf_rrc_missingPDU_Indicator = -1;      /* BOOLEAN */
static int hf_rrc_timerStatusPeriodic = -1;       /* TimerStatusPeriodic */
static int hf_rrc_timerReordering = -1;           /* TimerReordering */
static int hf_rrc_segmentationIndication = -1;    /* BOOLEAN */
static int hf_rrc_dch = -1;                       /* TransportChannelIdentity */
static int hf_rrc_fach = -1;                      /* NULL */
static int hf_rrc_dsch = -1;                      /* TransportChannelIdentity */
static int hf_rrc_dch_and_dsch = -1;              /* TransportChannelIdentityDCHandDSCH */
static int hf_rrc_hsdsch = -1;                    /* MAC_d_FlowIdentity */
static int hf_rrc_dch_and_hsdsch = -1;            /* MAC_d_FlowIdentityDCHandHSDSCH */
static int hf_rrc_hsdsch_01 = -1;                 /* T_hsdsch */
static int hf_rrc_mac_hs = -1;                    /* MAC_d_FlowIdentity */
static int hf_rrc_mac_ehs = -1;                   /* MAC_ehs_QueueId */
static int hf_rrc_dch_and_hsdsch_01 = -1;         /* T_dch_and_hsdsch */
static int hf_rrc_mac_hs_01 = -1;                 /* MAC_d_FlowIdentityDCHandHSDSCH */
static int hf_rrc_mac_ehs_01 = -1;                /* MAC_ehs_QueueIdDCHandHSDSCH */
static int hf_rrc_dl_UM_RLC_LI_size = -1;         /* DL_UM_RLC_LI_size */
static int hf_rrc_dl_Reception_Window_Size = -1;  /* DL_Reception_Window_Size_r6 */
static int hf_rrc_timerMRW = -1;                  /* TimerMRW */
static int hf_rrc_timerDiscard = -1;              /* TimerDiscard */
static int hf_rrc_maxMRW = -1;                    /* MaxMRW */
static int hf_rrc_algorithmSpecificInfo = -1;     /* AlgorithmSpecificInfo */
static int hf_rrc_HeaderCompressionInfoList_item = -1;  /* HeaderCompressionInfo */
static int hf_rrc_algorithmSpecificInfo_01 = -1;  /* AlgorithmSpecificInfo_r4 */
static int hf_rrc_HeaderCompressionInfoList_r4_item = -1;  /* HeaderCompressionInfo_r4 */
static int hf_rrc_supported_13 = -1;              /* MaxPDCP_SN_WindowSize */
static int hf_rrc_maxDAT = -1;                    /* MaxDAT */
static int hf_rrc_losslessSRNS_RelocSupport = -1;  /* LosslessSRNS_RelocSupport */
static int hf_rrc_pdcp_PDU_Header = -1;           /* PDCP_PDU_Header */
static int hf_rrc_headerCompressionInfoList = -1;  /* HeaderCompressionInfoList */
static int hf_rrc_headerCompressionInfoList_01 = -1;  /* HeaderCompressionInfoList_r4 */
static int hf_rrc_pdcp_Info = -1;                 /* PDCP_Info */
static int hf_rrc_dummy_34 = -1;                  /* INTEGER_0_65535 */
static int hf_rrc_pdcp_Info_01 = -1;              /* PDCP_Info_r4 */
static int hf_rrc_timerPollProhibit = -1;         /* TimerPollProhibit */
static int hf_rrc_timerPoll = -1;                 /* TimerPoll */
static int hf_rrc_poll_PDU = -1;                  /* Poll_PDU */
static int hf_rrc_poll_SDU = -1;                  /* Poll_SDU */
static int hf_rrc_lastTransmissionPDU_Poll = -1;  /* BOOLEAN */
static int hf_rrc_lastRetransmissionPDU_Poll = -1;  /* BOOLEAN */
static int hf_rrc_pollWindow = -1;                /* PollWindow */
static int hf_rrc_timerPollPeriodic = -1;         /* TimerPollPeriodic */
static int hf_rrc_re_EstablishmentTimer = -1;     /* Re_EstablishmentTimer */
static int hf_rrc_srb_InformationList = -1;       /* SRB_InformationSetupList */
static int hf_rrc_rb_InformationList = -1;        /* RB_InformationSetupList */
static int hf_rrc_predefinedRB_Configuration = -1;  /* PredefinedRB_Configuration */
static int hf_rrc_preDefTransChConfiguration = -1;  /* PreDefTransChConfiguration */
static int hf_rrc_preDefPhyChConfiguration = -1;  /* PreDefPhyChConfiguration */
static int hf_rrc_preDefPhyChConfiguration_01 = -1;  /* PreDefPhyChConfiguration_v770ext */
static int hf_rrc_mac_ehsWindowSize = -1;         /* MAC_hs_WindowSize_r9 */
static int hf_rrc_PredefinedConfigStatusList_item = -1;  /* PredefinedConfigStatusInfo */
static int hf_rrc_storedWithValueTagSameAsPrevius = -1;  /* NULL */
static int hf_rrc_other = -1;                     /* T_other */
static int hf_rrc_notStored = -1;                 /* NULL */
static int hf_rrc_storedWithDifferentValueTag = -1;  /* PredefinedConfigValueTag */
static int hf_rrc_setsWithDifferentValueTag = -1;  /* PredefinedConfigSetsWithDifferentValueTag */
static int hf_rrc_otherEntries = -1;              /* PredefinedConfigStatusListVarSz */
static int hf_rrc_PredefinedConfigSetsWithDifferentValueTag_item = -1;  /* PredefinedConfigSetWithDifferentValueTag */
static int hf_rrc_startPosition = -1;             /* INTEGER_0_10 */
static int hf_rrc_valueTagList = -1;              /* PredefinedConfigValueTagList */
static int hf_rrc_PredefinedConfigValueTagList_item = -1;  /* PredefinedConfigValueTag */
static int hf_rrc_PredefinedConfigStatusListVarSz_item = -1;  /* PredefinedConfigStatusInfo */
static int hf_rrc_rab_Identity = -1;              /* RAB_Identity */
static int hf_rrc_nas_Synchronisation_Indicator = -1;  /* NAS_Synchronisation_Indicator */
static int hf_rrc_mbms_SessionIdentity = -1;      /* MBMS_SessionIdentity */
static int hf_rrc_mbms_ServiceIdentity = -1;      /* OCTET_STRING_SIZE_3 */
static int hf_rrc_RAB_InformationList_item = -1;  /* RAB_Info */
static int hf_rrc_RAB_InformationList_r6_item = -1;  /* RAB_Info_r6 */
static int hf_rrc_RAB_InformationReconfigList_item = -1;  /* RAB_InformationReconfig */
static int hf_rrc_RAB_InformationReconfigList_r8_item = -1;  /* RAB_InformationReconfig_r8 */
static int hf_rrc_cs_HSPA_Information = -1;       /* CS_HSPA_Information */
static int hf_rrc_rb_Identity = -1;               /* RB_Identity */
static int hf_rrc_RAB_InformationMBMSPtpList_item = -1;  /* RAB_InformationMBMSPtp */
static int hf_rrc_rab_Info_02 = -1;               /* RAB_Info */
static int hf_rrc_rb_InformationSetupList = -1;   /* RB_InformationSetupList */
static int hf_rrc_rb_InformationSetupList_01 = -1;  /* RB_InformationSetupList_r4 */
static int hf_rrc_rb_InformationSetupList_02 = -1;  /* RB_InformationSetupList_r5 */
static int hf_rrc_rab_Info_r6_ext = -1;           /* RAB_Info_r6_ext */
static int hf_rrc_rb_InformationSetupList_03 = -1;  /* RB_InformationSetupList_r6 */
static int hf_rrc_rab_Info_v6b0ext = -1;          /* RAB_Info_v6b0ext */
static int hf_rrc_rab_Info_03 = -1;               /* RAB_Info_r7 */
static int hf_rrc_rb_InformationSetupList_04 = -1;  /* RB_InformationSetupList_r7 */
static int hf_rrc_rb_InformationSetupList_05 = -1;  /* RB_InformationSetupList_r8 */
static int hf_rrc_rb_InformationSetupList_06 = -1;  /* RB_InformationSetupList_r11 */
static int hf_rrc_RAB_InformationSetupList_item = -1;  /* RAB_InformationSetup */
static int hf_rrc_RAB_InformationSetupList_r4_item = -1;  /* RAB_InformationSetup_r4 */
static int hf_rrc_RAB_InformationSetupList_r5_item = -1;  /* RAB_InformationSetup_r5 */
static int hf_rrc_RAB_InformationSetupList_r6_item = -1;  /* RAB_InformationSetup_r6 */
static int hf_rrc_RAB_InformationSetupList_r6_ext_item = -1;  /* RAB_InformationSetup_r6_ext */
static int hf_rrc_RAB_InformationSetupList_v6b0ext_item = -1;  /* RAB_InformationSetup_v6b0ext */
static int hf_rrc_RAB_InformationSetupList_r7_item = -1;  /* RAB_InformationSetup_r7 */
static int hf_rrc_RAB_InformationSetupList_r8_item = -1;  /* RAB_InformationSetup_r8 */
static int hf_rrc_RAB_InformationSetupList_v820ext_item = -1;  /* RAB_InformationSetup_v820ext */
static int hf_rrc_RAB_InformationSetupList_r11_item = -1;  /* RAB_InformationSetup_r11 */
static int hf_rrc_rlc_SequenceNumber = -1;        /* RLC_SequenceNumber */
static int hf_rrc_RB_ActivationTimeInfoList_item = -1;  /* RB_ActivationTimeInfo */
static int hf_rrc_count_C_UL = -1;                /* COUNT_C */
static int hf_rrc_count_C_DL = -1;                /* COUNT_C */
static int hf_rrc_RB_COUNT_C_InformationList_item = -1;  /* RB_COUNT_C_Information */
static int hf_rrc_count_C_MSB_UL = -1;            /* COUNT_C_MSB */
static int hf_rrc_count_C_MSB_DL = -1;            /* COUNT_C_MSB */
static int hf_rrc_RB_COUNT_C_MSB_InformationList_item = -1;  /* RB_COUNT_C_MSB_Information */
static int hf_rrc_RB_IdentityList_item = -1;      /* RB_Identity */
static int hf_rrc_rb_MappingInfo = -1;            /* RB_MappingInfo */
static int hf_rrc_rb_MappingInfo_01 = -1;         /* RB_MappingInfo_r5 */
static int hf_rrc_rb_MappingInfo_02 = -1;         /* RB_MappingInfo_r6 */
static int hf_rrc_rb_MappingInfo_03 = -1;         /* RB_MappingInfo_r7 */
static int hf_rrc_rb_MappingInfo_04 = -1;         /* RB_MappingInfo_r8 */
static int hf_rrc_RB_InformationAffectedList_item = -1;  /* RB_InformationAffected */
static int hf_rrc_RB_InformationAffectedList_r5_item = -1;  /* RB_InformationAffected_r5 */
static int hf_rrc_RB_InformationAffectedList_r6_item = -1;  /* RB_InformationAffected_r6 */
static int hf_rrc_RB_InformationAffectedList_r7_item = -1;  /* RB_InformationAffected_r7 */
static int hf_rrc_RB_InformationAffectedList_r8_item = -1;  /* RB_InformationAffected_r8 */
static int hf_rrc_rb_Change = -1;                 /* T_rb_Change */
static int hf_rrc_release_01 = -1;                /* NULL */
static int hf_rrc_re_mapToDefaultRb = -1;         /* RB_Identity */
static int hf_rrc_RB_InformationChangedList_r6_item = -1;  /* RB_InformationChanged_r6 */
static int hf_rrc_pdcp_Info_02 = -1;              /* PDCP_InfoReconfig */
static int hf_rrc_pdcp_SN_Info = -1;              /* PDCP_SN_Info */
static int hf_rrc_rlc_Info = -1;                  /* RLC_Info */
static int hf_rrc_rb_StopContinue = -1;           /* RB_StopContinue */
static int hf_rrc_pdcp_Info_03 = -1;              /* PDCP_InfoReconfig_r4 */
static int hf_rrc_rlc_Info_01 = -1;               /* RLC_Info_r5 */
static int hf_rrc_rlc_Info_02 = -1;               /* RLC_Info_r6 */
static int hf_rrc_rlc_Info_03 = -1;               /* RLC_Info_r7 */
static int hf_rrc_rlc_Info_04 = -1;               /* RLC_Info_r11 */
static int hf_rrc_RB_InformationReconfigList_item = -1;  /* RB_InformationReconfig */
static int hf_rrc_RB_InformationReconfigList_r4_item = -1;  /* RB_InformationReconfig_r4 */
static int hf_rrc_RB_InformationReconfigList_r5_item = -1;  /* RB_InformationReconfig_r5 */
static int hf_rrc_RB_InformationReconfigList_r6_item = -1;  /* RB_InformationReconfig_r6 */
static int hf_rrc_RB_InformationReconfigList_r7_item = -1;  /* RB_InformationReconfig_r7 */
static int hf_rrc_RB_InformationReconfigList_r8_item = -1;  /* RB_InformationReconfig_r8 */
static int hf_rrc_RB_InformationReconfigList_r11_item = -1;  /* RB_InformationReconfig_r11 */
static int hf_rrc_RB_InformationReleaseList_item = -1;  /* RB_Identity */
static int hf_rrc_rlc_InfoChoice = -1;            /* RLC_InfoChoice */
static int hf_rrc_rlc_InfoChoice_01 = -1;         /* RLC_InfoChoice_r5 */
static int hf_rrc_rlc_InfoChoice_02 = -1;         /* RLC_InfoChoice_r6 */
static int hf_rrc_rlc_InfoChoice_03 = -1;         /* RLC_InfoChoice_r7 */
static int hf_rrc_rlc_InfoChoice_04 = -1;         /* RLC_InfoChoice_r11 */
static int hf_rrc_RB_InformationSetupList_item = -1;  /* RB_InformationSetup */
static int hf_rrc_RB_InformationSetupList_r4_item = -1;  /* RB_InformationSetup_r4 */
static int hf_rrc_RB_InformationSetupList_r5_item = -1;  /* RB_InformationSetup_r5 */
static int hf_rrc_RB_InformationSetupList_r6_item = -1;  /* RB_InformationSetup_r6 */
static int hf_rrc_RB_InformationSetupList_r7_item = -1;  /* RB_InformationSetup_r7 */
static int hf_rrc_RB_InformationSetupList_r8_item = -1;  /* RB_InformationSetup_r8 */
static int hf_rrc_RB_InformationSetupList_r11_item = -1;  /* RB_InformationSetup_r11 */
static int hf_rrc_RB_MappingInfo_item = -1;       /* RB_MappingOption */
static int hf_rrc_RB_MappingInfo_r5_item = -1;    /* RB_MappingOption_r5 */
static int hf_rrc_RB_MappingInfo_r6_item = -1;    /* RB_MappingOption_r6 */
static int hf_rrc_RB_MappingInfo_r7_item = -1;    /* RB_MappingOption_r7 */
static int hf_rrc_RB_MappingInfo_r8_item = -1;    /* RB_MappingOption_r8 */
static int hf_rrc_ul_LogicalChannelMappings = -1;  /* UL_LogicalChannelMappings */
static int hf_rrc_dl_LogicalChannelMappingList = -1;  /* DL_LogicalChannelMappingList */
static int hf_rrc_dl_LogicalChannelMappingList_01 = -1;  /* DL_LogicalChannelMappingList_r5 */
static int hf_rrc_ul_LogicalChannelMappings_01 = -1;  /* UL_LogicalChannelMappings_r6 */
static int hf_rrc_dl_LogicalChannelMappingList_02 = -1;  /* DL_LogicalChannelMappingList_r7 */
static int hf_rrc_ul_LogicalChannelMappings_02 = -1;  /* UL_LogicalChannelMappings_r8 */
static int hf_rrc_dl_RFC3095_Context_Relocation = -1;  /* BOOLEAN */
static int hf_rrc_ul_RFC3095_Context_Relocation = -1;  /* BOOLEAN */
static int hf_rrc_RB_PDCPContextRelocationList_item = -1;  /* RB_PDCPContextRelocation */
static int hf_rrc_RB_WithPDCP_InfoList_item = -1;  /* RB_WithPDCP_Info */
static int hf_rrc_f_MAX_PERIOD = -1;              /* INTEGER_1_65535 */
static int hf_rrc_f_MAX_TIME = -1;                /* INTEGER_1_255 */
static int hf_rrc_max_HEADER = -1;                /* INTEGER_60_65535 */
static int hf_rrc_tcp_SPACE = -1;                 /* INTEGER_3_255 */
static int hf_rrc_non_TCP_SPACE = -1;             /* INTEGER_3_65535 */
static int hf_rrc_expectReordering = -1;          /* ExpectReordering */
static int hf_rrc_rohcProfileList = -1;           /* ROHC_ProfileList_r4 */
static int hf_rrc_ul_RFC3095 = -1;                /* UL_RFC3095_r4 */
static int hf_rrc_dl_RFC3095 = -1;                /* DL_RFC3095_r4 */
static int hf_rrc_ul_RLC_Mode = -1;               /* UL_RLC_Mode */
static int hf_rrc_dl_RLC_Mode = -1;               /* DL_RLC_Mode */
static int hf_rrc_dl_RLC_Mode_01 = -1;            /* DL_RLC_Mode_r5 */
static int hf_rrc_rlc_OneSidedReEst = -1;         /* BOOLEAN */
static int hf_rrc_dl_RLC_Mode_02 = -1;            /* DL_RLC_Mode_r6 */
static int hf_rrc_altE_bitInterpretation = -1;    /* T_altE_bitInterpretation */
static int hf_rrc_dl_RLC_Mode_03 = -1;            /* DL_RLC_Mode_r7 */
static int hf_rrc_altE_bitInterpretation_01 = -1;  /* T_altE_bitInterpretation_01 */
static int hf_rrc_useSpecialValueOfHEField = -1;  /* T_useSpecialValueOfHEField */
static int hf_rrc_dl_RLC_Mode_04 = -1;            /* DL_RLC_Mode_r11 */
static int hf_rrc_altE_bitInterpretation_02 = -1;  /* T_altE_bitInterpretation_02 */
static int hf_rrc_useSpecialValueOfHEField_01 = -1;  /* T_useSpecialValueOfHEField_01 */
static int hf_rrc_dl_UM_RLC_OutOSeqDelivery_Info = -1;  /* UM_RLC_OutOSeqDelivery_Info_r6 */
static int hf_rrc_dl_UM_RLC_DuplAvoid_Reord_Info = -1;  /* UM_RLC_DuplAvoid_Reord_Info_r6 */
static int hf_rrc_same_as_RB = -1;                /* RB_Identity */
static int hf_rrc_lengthIndicatorSize = -1;       /* T_lengthIndicatorSize */
static int hf_rrc_minRLC_PDU_Size = -1;           /* INTEGER_0_1503 */
static int hf_rrc_largestRLC_PDU_Size = -1;       /* INTEGER_0_1503 */
static int hf_rrc_RLC_PDU_SizeList_item = -1;     /* RLC_PDU_Size */
static int hf_rrc_rlc_SizeIndex = -1;             /* INTEGER_1_maxTF */
static int hf_rrc_RLC_SizeExplicitList_item = -1;  /* RLC_SizeInfo */
static int hf_rrc_ROHC_ProfileList_r4_item = -1;  /* ROHC_Profile_r4 */
static int hf_rrc_ROHC_PacketSizeList_r4_item = -1;  /* ROHC_PacketSize_r4 */
static int hf_rrc_SRB_InformationSetupList_item = -1;  /* SRB_InformationSetup */
static int hf_rrc_SRB_InformationSetupList_r5_item = -1;  /* SRB_InformationSetup_r5 */
static int hf_rrc_SRB_InformationSetupList_r6_item = -1;  /* SRB_InformationSetup_r6 */
static int hf_rrc_SRB_InformationSetupList_r7_item = -1;  /* SRB_InformationSetup_r7 */
static int hf_rrc_SRB_InformationSetupList_r8_item = -1;  /* SRB_InformationSetup_r8 */
static int hf_rrc_SRB_InformationSetupList_r11_item = -1;  /* SRB_InformationSetup_r11 */
static int hf_rrc_SRB_InformationSetupList2_item = -1;  /* SRB_InformationSetup */
static int hf_rrc_SRB_InformationSetupList2_r6_item = -1;  /* SRB_InformationSetup_r6 */
static int hf_rrc_SRB_InformationSetupList2_r7_item = -1;  /* SRB_InformationSetup_r7 */
static int hf_rrc_SRB_InformationSetupList2_r8_item = -1;  /* SRB_InformationSetup_r8 */
static int hf_rrc_timerBasedExplicit = -1;        /* ExplicitDiscard */
static int hf_rrc_timerBasedNoExplicit = -1;      /* NoExplicitDiscard */
static int hf_rrc_maxDAT_Retransmissions = -1;    /* MaxDAT_Retransmissions */
static int hf_rrc_noDiscard = -1;                 /* MaxDAT */
static int hf_rrc_transmissionRLC_Discard = -1;   /* TransmissionRLC_Discard */
static int hf_rrc_transmissionWindowSize = -1;    /* TransmissionWindowSize */
static int hf_rrc_timerRST = -1;                  /* TimerRST */
static int hf_rrc_max_RST = -1;                   /* MaxRST */
static int hf_rrc_pollingInfo = -1;               /* PollingInfo */
static int hf_rrc_ul_TransportChannelType = -1;   /* UL_TransportChannelType */
static int hf_rrc_rlc_SizeList = -1;              /* T_rlc_SizeList */
static int hf_rrc_allSizes = -1;                  /* NULL */
static int hf_rrc_configured = -1;                /* NULL */
static int hf_rrc_explicitList = -1;              /* RLC_SizeExplicitList */
static int hf_rrc_mac_LogicalChannelPriority = -1;  /* MAC_LogicalChannelPriority */
static int hf_rrc_ul_TrCH_Type = -1;              /* T_ul_TrCH_Type */
static int hf_rrc_dch_rach_usch = -1;             /* T_dch_rach_usch */
static int hf_rrc_rlc_SizeList_01 = -1;           /* T_rlc_SizeList_01 */
static int hf_rrc_e_dch = -1;                     /* T_e_dch */
static int hf_rrc_e_DCH_MAC_d_FlowIdentity = -1;  /* E_DCH_MAC_d_FlowIdentity */
static int hf_rrc_ddi = -1;                       /* DDI */
static int hf_rrc_rlc_PDU_SizeList = -1;          /* RLC_PDU_SizeList */
static int hf_rrc_includeInSchedulingInfo = -1;   /* BOOLEAN */
static int hf_rrc_ul_TrCH_Type_01 = -1;           /* T_ul_TrCH_Type_01 */
static int hf_rrc_dch_rach_usch_01 = -1;          /* T_dch_rach_usch_01 */
static int hf_rrc_rlc_SizeList_02 = -1;           /* T_rlc_SizeList_02 */
static int hf_rrc_e_dch_01 = -1;                  /* T_e_dch_01 */
static int hf_rrc_rlc_PDU_Size = -1;              /* T_rlc_PDU_Size */
static int hf_rrc_fixedSize_01 = -1;              /* T_fixedSize */
static int hf_rrc_flexibleSize_02 = -1;           /* RLC_PDU_SizeConstraint */
static int hf_rrc_rlc_LogicalChannelMappingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_ul_LogicalChannelMapping = -1;  /* SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping */
static int hf_rrc_ul_LogicalChannelMapping_item = -1;  /* UL_LogicalChannelMapping */
static int hf_rrc_ul_LogicalChannelMapping_01 = -1;  /* SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping_r6 */
static int hf_rrc_ul_LogicalChannelMapping_item_01 = -1;  /* UL_LogicalChannelMapping_r6 */
static int hf_rrc_ul_LogicalChannelMapping_02 = -1;  /* SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping_r8 */
static int hf_rrc_ul_LogicalChannelMapping_item_02 = -1;  /* UL_LogicalChannelMapping_r8 */
static int hf_rrc_oneLogicalChannel = -1;         /* UL_LogicalChannelMapping */
static int hf_rrc_twoLogicalChannels = -1;        /* UL_LogicalChannelMappingList */
static int hf_rrc_oneLogicalChannel_01 = -1;      /* UL_LogicalChannelMapping_r6 */
static int hf_rrc_twoLogicalChannels_01 = -1;     /* UL_LogicalChannelMappingList_r6 */
static int hf_rrc_oneLogicalChannel_02 = -1;      /* UL_LogicalChannelMapping_r8 */
static int hf_rrc_twoLogicalChannels_02 = -1;     /* UL_LogicalChannelMappingList_r8 */
static int hf_rrc_dummy1_01 = -1;                 /* CID_InclusionInfo_r4 */
static int hf_rrc_dummy_35 = -1;                  /* ROHC_PacketSizeList_r4 */
static int hf_rrc_ul_AM_RLC_Mode = -1;            /* UL_AM_RLC_Mode */
static int hf_rrc_ul_UM_RLC_Mode = -1;            /* UL_UM_RLC_Mode */
static int hf_rrc_ul_TM_RLC_Mode = -1;            /* UL_TM_RLC_Mode */
static int hf_rrc_rach = -1;                      /* NULL */
static int hf_rrc_usch = -1;                      /* TransportChannelIdentity */
static int hf_rrc_timer_DAR = -1;                 /* TimerDAR_r6 */
static int hf_rrc_widowSize_DAR = -1;             /* WindowSizeDAR_r6 */
static int hf_rrc_timer_OSD = -1;                 /* TimerOSD_r6 */
static int hf_rrc_windowSize_OSD = -1;            /* WindowSizeOSD_r6 */
static int hf_rrc_mac_hs_AddReconfQueue_List = -1;  /* MAC_hs_AddReconfQueue_List */
static int hf_rrc_mac_hs_DelQueue_List = -1;      /* MAC_hs_DelQueue_List */
static int hf_rrc_mac_ehs_AddReconfQueue_List = -1;  /* MAC_ehs_AddReconfReordQ_List */
static int hf_rrc_dummy_36 = -1;                  /* MAC_ehs_DelReordQ_List */
static int hf_rrc_mac_ehs_AddReconfQueue_List_01 = -1;  /* MAC_ehs_AddReconfReordQ_List_r9 */
static int hf_rrc_mac_ehs_AddReconfQueue_List_02 = -1;  /* MAC_ehs_AddReconfReordQ_List_TDD128_v9c0ext */
static int hf_rrc_mac_ehs_AddReconfQueue_List_03 = -1;  /* MAC_ehs_AddReconfReordQ_List_r11 */
static int hf_rrc_AllowedTFC_List_item = -1;      /* TFC_Value */
static int hf_rrc_AllowedTFI_List_item = -1;      /* INTEGER_0_31 */
static int hf_rrc_sizeType1 = -1;                 /* INTEGER_0_127 */
static int hf_rrc_sizeType2 = -1;                 /* T_sizeType2 */
static int hf_rrc_part1 = -1;                     /* INTEGER_0_15 */
static int hf_rrc_part2 = -1;                     /* INTEGER_1_7 */
static int hf_rrc_sizeType3 = -1;                 /* T_sizeType3 */
static int hf_rrc_part1_01 = -1;                  /* INTEGER_0_47 */
static int hf_rrc_part2_01 = -1;                  /* INTEGER_1_15 */
static int hf_rrc_sizeType4 = -1;                 /* T_sizeType4 */
static int hf_rrc_part1_02 = -1;                  /* INTEGER_0_62 */
static int hf_rrc_part2_02 = -1;                  /* INTEGER_1_63 */
static int hf_rrc_noCoding = -1;                  /* NULL */
static int hf_rrc_convolutional = -1;             /* CodingRate */
static int hf_rrc_turbo = -1;                     /* NULL */
static int hf_rrc_mac_d_FlowIdentity = -1;        /* E_DCH_MAC_d_FlowIdentity */
static int hf_rrc_mac_d_FlowPowerOffset = -1;     /* E_DCH_MAC_d_FlowPowerOffset */
static int hf_rrc_mac_d_FlowMaxRetrans = -1;      /* E_DCH_MAC_d_FlowMaxRetrans */
static int hf_rrc_mac_d_FlowMultiplexingList = -1;  /* E_DCH_MAC_d_FlowMultiplexingList */
static int hf_rrc_e_dch_mac_d_flow_retransmission_timer = -1;  /* E_DCH_MAC_d_FlowRetransTimer */
static int hf_rrc_Common_E_DCH_MAC_d_FlowList_item = -1;  /* Common_E_DCH_MAC_d_Flow */
static int hf_rrc_Common_E_DCH_MAC_d_Flow_Info_List_ConcurrentTTI_item = -1;  /* Common_E_DCH_MAC_d_Flow_Info_ConcurrentTTI */
static int hf_rrc_rlc_Size = -1;                  /* T_rlc_Size */
static int hf_rrc_fdd_49 = -1;                    /* T_fdd_48 */
static int hf_rrc_octetModeRLC_SizeInfoType2 = -1;  /* OctetModeRLC_SizeInfoType2 */
static int hf_rrc_tdd_14 = -1;                    /* T_tdd_13 */
static int hf_rrc_commonTDD_Choice = -1;          /* T_commonTDD_Choice */
static int hf_rrc_bitModeRLC_SizeInfo = -1;       /* BitModeRLC_SizeInfo */
static int hf_rrc_octetModeRLC_SizeInfoType1 = -1;  /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_numberOfTbSizeList = -1;        /* SEQUENCE_SIZE_1_maxTF_OF_NumberOfTransportBlocks */
static int hf_rrc_numberOfTbSizeList_item = -1;   /* NumberOfTransportBlocks */
static int hf_rrc_logicalChannelList = -1;        /* LogicalChannelList */
static int hf_rrc_commonTDD_Choice_01 = -1;       /* T_commonTDD_Choice_01 */
static int hf_rrc_numberOfTbSizeAndTTIList = -1;  /* NumberOfTbSizeAndTTIList */
static int hf_rrc_CommonDynamicTF_InfoList_item = -1;  /* CommonDynamicTF_Info */
static int hf_rrc_CommonDynamicTF_InfoList_DynamicTTI_item = -1;  /* CommonDynamicTF_Info_DynamicTTI */
static int hf_rrc_tti = -1;                       /* T_tti */
static int hf_rrc_tti10 = -1;                     /* CommonDynamicTF_InfoList */
static int hf_rrc_tti20 = -1;                     /* CommonDynamicTF_InfoList */
static int hf_rrc_tti40 = -1;                     /* CommonDynamicTF_InfoList */
static int hf_rrc_tti80 = -1;                     /* CommonDynamicTF_InfoList */
static int hf_rrc_dynamic = -1;                   /* CommonDynamicTF_InfoList_DynamicTTI */
static int hf_rrc_semistaticTF_Information = -1;  /* SemistaticTF_Information */
static int hf_rrc_tti_01 = -1;                    /* T_tti_01 */
static int hf_rrc_tti5 = -1;                      /* CommonDynamicTF_InfoList */
static int hf_rrc_t1_ReleaseTimer = -1;           /* T1_ReleaseTimer */
static int hf_rrc_reorderingResetTimer = -1;      /* Treset_ResetTimer */
static int hf_rrc_mac_ehsWindowSize_01 = -1;      /* MAC_hs_WindowSize */
static int hf_rrc_Common_MAC_ehs_ReorderingQueueList_item = -1;  /* Common_MAC_ehs_ReorderingQueue */
static int hf_rrc_tti_selection = -1;             /* T_tti_selection */
static int hf_rrc_fixed = -1;                     /* T_fixed */
static int hf_rrc_fixed_TTI_Selection = -1;       /* T_fixed_TTI_Selection */
static int hf_rrc_threshold_based = -1;           /* T_threshold_based */
static int hf_rrc_common_E_DCH_TTI_Selection_Thresh = -1;  /* INTEGER_0_15 */
static int hf_rrc_concurrent_TTI_Partition_Index = -1;  /* INTEGER_0_maxEDCHs_1 */
static int hf_rrc_commonEDCHSystemInfoParamConcurrentTTI = -1;  /* CommonEDCHSystemInfoParamConcurrentTTI */
static int hf_rrc_rlc_Size_01 = -1;               /* T_rlc_Size_01 */
static int hf_rrc_bitMode = -1;                   /* BitModeRLC_SizeInfo */
static int hf_rrc_octetModeType1 = -1;            /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_rlc_Size_02 = -1;               /* T_rlc_Size_02 */
static int hf_rrc_DedicatedDynamicTF_InfoList_item = -1;  /* DedicatedDynamicTF_Info */
static int hf_rrc_DedicatedDynamicTF_InfoList_DynamicTTI_item = -1;  /* DedicatedDynamicTF_Info_DynamicTTI */
static int hf_rrc_tti_02 = -1;                    /* T_tti_02 */
static int hf_rrc_tti10_01 = -1;                  /* DedicatedDynamicTF_InfoList */
static int hf_rrc_tti20_01 = -1;                  /* DedicatedDynamicTF_InfoList */
static int hf_rrc_tti40_01 = -1;                  /* DedicatedDynamicTF_InfoList */
static int hf_rrc_tti80_01 = -1;                  /* DedicatedDynamicTF_InfoList */
static int hf_rrc_dynamic_01 = -1;                /* DedicatedDynamicTF_InfoList_DynamicTTI */
static int hf_rrc_DL_AddReconfTransChInfo2List_item = -1;  /* DL_AddReconfTransChInformation2 */
static int hf_rrc_DL_AddReconfTransChInfoList_item = -1;  /* DL_AddReconfTransChInformation */
static int hf_rrc_DL_AddReconfTransChInfoList_r4_item = -1;  /* DL_AddReconfTransChInformation_r4 */
static int hf_rrc_DL_AddReconfTransChInfoList_r5_item = -1;  /* DL_AddReconfTransChInformation_r5 */
static int hf_rrc_DL_AddReconfTransChInfoList_r7_item = -1;  /* DL_AddReconfTransChInformation_r7 */
static int hf_rrc_DL_AddReconfTransChInfoList_r9_item = -1;  /* DL_AddReconfTransChInformation_r9 */
static int hf_rrc_DL_AddReconfTransChInfoList_TDD128_v9c0ext_item = -1;  /* DL_AddReconfTransChInformation_TDD128_v9c0ext */
static int hf_rrc_DL_AddReconfTransChInfoList_r11_item = -1;  /* DL_AddReconfTransChInformation_r11 */
static int hf_rrc_dl_TransportChannelType_03 = -1;  /* DL_TrCH_Type */
static int hf_rrc_dl_transportChannelIdentity = -1;  /* TransportChannelIdentity */
static int hf_rrc_tfs_SignallingMode = -1;        /* T_tfs_SignallingMode */
static int hf_rrc_explicit_config = -1;           /* TransportFormatSet */
static int hf_rrc_sameAsULTrCH = -1;              /* UL_TransportChannelIdentity */
static int hf_rrc_dch_QualityTarget = -1;         /* QualityTarget */
static int hf_rrc_dummy_37 = -1;                  /* TM_SignallingInfo */
static int hf_rrc_tfs_SignallingMode_01 = -1;     /* T_tfs_SignallingMode_01 */
static int hf_rrc_dl_TransportChannelType_04 = -1;  /* DL_TrCH_TypeId1_r5 */
static int hf_rrc_tfs_SignallingMode_02 = -1;     /* T_tfs_SignallingMode_02 */
static int hf_rrc_hsdsch_02 = -1;                 /* HSDSCH_Info */
static int hf_rrc_tfs_SignallingMode_03 = -1;     /* T_tfs_SignallingMode_03 */
static int hf_rrc_hsdsch_03 = -1;                 /* HSDSCH_Info_r7 */
static int hf_rrc_tfs_SignallingMode_04 = -1;     /* T_tfs_SignallingMode_04 */
static int hf_rrc_hsdsch_04 = -1;                 /* HSDSCH_Info_r9 */
static int hf_rrc_hsdsch_05 = -1;                 /* HSDSCH_Info_TDD128_v9c0ext */
static int hf_rrc_tfs_SignallingMode_05 = -1;     /* T_tfs_SignallingMode_05 */
static int hf_rrc_hsdsch_06 = -1;                 /* HSDSCH_Info_r11 */
static int hf_rrc_transportChannelIdentity = -1;  /* TransportChannelIdentity */
static int hf_rrc_tfs_SignallingMode_06 = -1;     /* T_tfs_SignallingMode_06 */
static int hf_rrc_qualityTarget = -1;             /* QualityTarget */
static int hf_rrc_sccpch_TFCS = -1;               /* TFCS */
static int hf_rrc_modeSpecificInfo_19 = -1;       /* T_modeSpecificInfo_19 */
static int hf_rrc_fdd_50 = -1;                    /* T_fdd_49 */
static int hf_rrc_dl_Parameters = -1;             /* T_dl_Parameters */
static int hf_rrc_dl_DCH_TFCS = -1;               /* TFCS */
static int hf_rrc_sameAsUL = -1;                  /* NULL */
static int hf_rrc_tdd_15 = -1;                    /* T_tdd_14 */
static int hf_rrc_individualDL_CCTrCH_InfoList = -1;  /* IndividualDL_CCTrCH_InfoList */
static int hf_rrc_modeSpecificInfo_20 = -1;       /* T_modeSpecificInfo_20 */
static int hf_rrc_fdd_51 = -1;                    /* T_fdd_50 */
static int hf_rrc_dl_Parameters_01 = -1;          /* T_dl_Parameters_01 */
static int hf_rrc_dl_DCH_TFCS_01 = -1;            /* T_dl_DCH_TFCS */
static int hf_rrc_tfcs = -1;                      /* TFCS */
static int hf_rrc_tdd_16 = -1;                    /* T_tdd_15 */
static int hf_rrc_DL_DeletedTransChInfoList_item = -1;  /* DL_TransportChannelIdentity */
static int hf_rrc_DL_DeletedTransChInfoList_r5_item = -1;  /* DL_TransportChannelIdentity_r5 */
static int hf_rrc_DL_DeletedTransChInfoList_r7_item = -1;  /* DL_TransportChannelIdentity_r7 */
static int hf_rrc_dl_TransportChannelIdentity = -1;  /* TransportChannelIdentity */
static int hf_rrc_dl_TransportChannelType_05 = -1;  /* DL_TrCH_TypeId2_r5 */
static int hf_rrc_dl_TransportChannelType_06 = -1;  /* DL_TrCH_TypeId2_r7 */
static int hf_rrc_hsdsch_07 = -1;                 /* NULL */
static int hf_rrc_hsdsch_08 = -1;                 /* T_hsdsch_01 */
static int hf_rrc_transmissionTimeValidity = -1;  /* TransmissionTimeValidity */
static int hf_rrc_timeDurationBeforeRetry = -1;   /* TimeDurationBeforeRetry */
static int hf_rrc_drac_ClassIdentity = -1;        /* DRAC_ClassIdentity */
static int hf_rrc_DRAC_StaticInformationList_item = -1;  /* DRAC_StaticInformation */
static int hf_rrc_transmissionGrantType = -1;     /* T_transmissionGrantType */
static int hf_rrc_non_ScheduledTransGrantInfo = -1;  /* T_non_ScheduledTransGrantInfo */
static int hf_rrc_maxMAC_e_PDUContents = -1;      /* INTEGER_1_19982 */
static int hf_rrc_ms2_NonSchedTransmGrantHARQAlloc = -1;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_scheduledTransmissionGrantInfo = -1;  /* NULL */
static int hf_rrc_mac_d_FlowRetransTimer = -1;    /* E_DCH_MAC_d_FlowRetransTimer */
static int hf_rrc_transmissionGrantType_01 = -1;  /* T_transmissionGrantType_01 */
static int hf_rrc_non_ScheduledTransGrantInfo_01 = -1;  /* T_non_ScheduledTransGrantInfo_01 */
static int hf_rrc_modeSpecificInfo_21 = -1;       /* T_modeSpecificInfo_21 */
static int hf_rrc_fdd_52 = -1;                    /* T_fdd_51 */
static int hf_rrc_E_DCH_AddReconf_MAC_d_FlowList_item = -1;  /* E_DCH_AddReconf_MAC_d_Flow */
static int hf_rrc_E_DCH_AddReconf_MAC_d_FlowList_r7_item = -1;  /* E_DCH_AddReconf_MAC_d_Flow_r7 */
static int hf_rrc_complete_26 = -1;               /* TFCS_ReconfAdd */
static int hf_rrc_addition = -1;                  /* TFCS_ReconfAdd */
static int hf_rrc_removal = -1;                   /* TFCS_RemovalList */
static int hf_rrc_replacement = -1;               /* T_replacement */
static int hf_rrc_tfcsRemoval = -1;               /* TFCS_RemovalList */
static int hf_rrc_tfcsAdd = -1;                   /* TFCS_ReconfAdd */
static int hf_rrc_signalledGainFactors = -1;      /* SignalledGainFactors */
static int hf_rrc_computedGainFactors = -1;       /* ReferenceTFC_ID */
static int hf_rrc_addOrReconfMAC_dFlow = -1;      /* AddOrReconfMAC_dFlow */
static int hf_rrc_dl_MAC_HeaderType = -1;         /* T_dl_MAC_HeaderType */
static int hf_rrc_mac_hs_02 = -1;                 /* AddOrReconfMAC_dFlow */
static int hf_rrc_mac_ehs_02 = -1;                /* AddOrReconfMAC_ehs_ReordQ */
static int hf_rrc_dl_MAC_HeaderType_01 = -1;      /* T_dl_MAC_HeaderType_01 */
static int hf_rrc_mac_ehs_03 = -1;                /* AddOrReconfMAC_ehs_ReordQ_r9 */
static int hf_rrc_mac_ehs_04 = -1;                /* AddOrReconfMAC_ehs_ReordQ_TDD128_v9c0ext */
static int hf_rrc_dl_MAC_HeaderType_02 = -1;      /* T_dl_MAC_HeaderType_02 */
static int hf_rrc_mac_ehs_05 = -1;                /* AddOrReconfMAC_ehs_ReordQ_r11 */
static int hf_rrc_numberOfProcesses = -1;         /* INTEGER_1_8 */
static int hf_rrc_memoryPartitioning = -1;        /* T_memoryPartitioning */
static int hf_rrc_implicit = -1;                  /* NULL */
static int hf_rrc_explicit = -1;                  /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_explicit_item = -1;             /* HARQMemorySize */
static int hf_rrc_numberOfProcesses_01 = -1;      /* T_numberOfProcesses */
static int hf_rrc_memoryPartitioning_01 = -1;     /* T_memoryPartitioning_01 */
static int hf_rrc_explicit_01 = -1;               /* T_explicit */
static int hf_rrc_memorySize = -1;                /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_memorySize_item = -1;           /* HARQMemorySize */
static int hf_rrc_additionalMemorySizesForMIMO = -1;  /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_additionalMemorySizesForMIMO_item = -1;  /* HARQMemorySize */
static int hf_rrc_numberOfProcesses_02 = -1;      /* T_numberOfProcesses_01 */
static int hf_rrc_memoryPartitioning_02 = -1;     /* T_memoryPartitioning_02 */
static int hf_rrc_explicit_02 = -1;               /* T_explicit_01 */
static int hf_rrc_additionalMemorySizesThirdMIMOStream = -1;  /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_additionalMemorySizesThirdMIMOStream_item = -1;  /* HARQMemorySize */
static int hf_rrc_additionalMemorySizesFourthMIMOStream = -1;  /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_additionalMemorySizesFourthMIMOStream_item = -1;  /* HARQMemorySize */
static int hf_rrc_dl_TFCS_Identity = -1;          /* TFCS_Identity */
static int hf_rrc_tfcs_SignallingMode = -1;       /* T_tfcs_SignallingMode */
static int hf_rrc_explicit_config_01 = -1;        /* TFCS */
static int hf_rrc_sameAsUL_01 = -1;               /* TFCS_Identity */
static int hf_rrc_IndividualDL_CCTrCH_InfoList_item = -1;  /* IndividualDL_CCTrCH_Info */
static int hf_rrc_ul_TFCS_Identity = -1;          /* TFCS_Identity */
static int hf_rrc_ul_TFCS = -1;                   /* TFCS */
static int hf_rrc_tfc_Subset = -1;                /* TFC_Subset */
static int hf_rrc_IndividualUL_CCTrCH_InfoList_item = -1;  /* IndividualUL_CCTrCH_Info */
static int hf_rrc_logChOfRb = -1;                 /* INTEGER_0_1 */
static int hf_rrc_explicitList_01 = -1;           /* SEQUENCE_SIZE_1_15_OF_LogicalChannelByRB */
static int hf_rrc_explicitList_item = -1;         /* LogicalChannelByRB */
static int hf_rrc_dch_transport_ch_id = -1;       /* TransportChannelIdentity */
static int hf_rrc_hsdsch_mac_d_flow_id = -1;      /* MAC_d_FlowIdentity */
static int hf_rrc_MAC_d_PDU_SizeInfo_List_item = -1;  /* MAC_d_PDUsizeInfo */
static int hf_rrc_mac_d_PDU_Size = -1;            /* INTEGER_1_5000 */
static int hf_rrc_mac_d_PDU_Index = -1;           /* INTEGER_0_7 */
static int hf_rrc_MAC_hs_AddReconfQueue_List_item = -1;  /* MAC_hs_AddReconfQueue */
static int hf_rrc_mac_hsQueueId = -1;             /* INTEGER_0_7 */
static int hf_rrc_mac_dFlowId = -1;               /* MAC_d_FlowIdentity */
static int hf_rrc_reorderingReleaseTimer = -1;    /* T1_ReleaseTimer */
static int hf_rrc_mac_hsWindowSize = -1;          /* MAC_hs_WindowSize */
static int hf_rrc_mac_d_PDU_SizeInfo_List = -1;   /* MAC_d_PDU_SizeInfo_List */
static int hf_rrc_MAC_hs_DelQueue_List_item = -1;  /* MAC_hs_DelQueue */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_item = -1;  /* MAC_ehs_AddReconfReordQ */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_r9_item = -1;  /* MAC_ehs_AddReconfReordQ_r9 */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_TDD128_v9c0ext_item = -1;  /* MAC_ehs_AddReconfReordQ_TDD128_v9c0ext */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_r11_item = -1;  /* MAC_ehs_AddReconfReordQ_r11 */
static int hf_rrc_mac_ehsWindowSize_extension = -1;  /* MAC_ehs_WindowSize_TDD128_v9c0ext */
static int hf_rrc_mac_ehsWindowSize_02 = -1;      /* MAC_hs_WindowSize_r11 */
static int hf_rrc_MAC_ehs_DelReordQ_List_item = -1;  /* MAC_ehs_DelReordQ */
static int hf_rrc_hsdsch_mac_ehs_QueueId = -1;    /* MAC_ehs_QueueId */
static int hf_rrc_NumberOfTbSizeAndTTIList_item = -1;  /* NumberOfTbSizeAndTTIList_item */
static int hf_rrc_numberOfTransportBlocks = -1;   /* NumberOfTransportBlocks */
static int hf_rrc_transmissionTimeInterval = -1;  /* TransmissionTimeInterval */
static int hf_rrc_Non_allowedTFC_List_item = -1;  /* TFC_Value */
static int hf_rrc_zero = -1;                      /* NULL */
static int hf_rrc_one = -1;                       /* NULL */
static int hf_rrc_small = -1;                     /* INTEGER_2_17 */
static int hf_rrc_large = -1;                     /* INTEGER_18_512 */
static int hf_rrc_sizeType1_01 = -1;              /* INTEGER_0_31 */
static int hf_rrc_sizeType2_01 = -1;              /* T_sizeType2_01 */
static int hf_rrc_part1_03 = -1;                  /* INTEGER_0_23 */
static int hf_rrc_part2_03 = -1;                  /* INTEGER_1_3 */
static int hf_rrc_sizeType3_01 = -1;              /* T_sizeType3_01 */
static int hf_rrc_part1_04 = -1;                  /* INTEGER_0_61 */
static int hf_rrc_sizeType2_02 = -1;              /* INTEGER_0_63 */
static int hf_rrc_sizeType3_02 = -1;              /* INTEGER_0_56 */
static int hf_rrc_referenceTFC = -1;              /* TFC_Value */
static int hf_rrc_modeSpecificInfo_22 = -1;       /* T_modeSpecificInfo_22 */
static int hf_rrc_fdd_53 = -1;                    /* T_fdd_52 */
static int hf_rrc_gainFactorBetaC = -1;           /* GainFactor */
static int hf_rrc_gainFactorBetaD = -1;           /* GainFactor */
static int hf_rrc_gainFactorInformation = -1;     /* GainFactorInformation */
static int hf_rrc_powerOffsetPp_m = -1;           /* PowerOffsetPp_m */
static int hf_rrc_ul_AddReconfTrChInfoList = -1;  /* UL_AddReconfTransChInfoList */
static int hf_rrc_dl_TrChInfoList = -1;           /* DL_AddReconfTransChInfoList */
static int hf_rrc_bler_QualityValue = -1;         /* BLER_QualityValue */
static int hf_rrc_ul_TransportChannelType_01 = -1;  /* UL_TrCH_Type */
static int hf_rrc_restrictedTrChIdentity = -1;    /* TransportChannelIdentity */
static int hf_rrc_allowedTFI_List = -1;           /* AllowedTFI_List */
static int hf_rrc_RestrictedTrChInfoList_item = -1;  /* RestrictedTrChInfo */
static int hf_rrc_channelCodingType = -1;         /* ChannelCodingType */
static int hf_rrc_rateMatchingAttribute = -1;     /* RateMatchingAttribute */
static int hf_rrc_crc_Size = -1;                  /* CRC_Size */
static int hf_rrc_modeSpecificInfo_23 = -1;       /* T_modeSpecificInfo_23 */
static int hf_rrc_fdd_54 = -1;                    /* T_fdd_53 */
static int hf_rrc_referenceTFC_ID = -1;           /* ReferenceTFC_ID */
static int hf_rrc_splitType = -1;                 /* SplitType */
static int hf_rrc_tfci_Field2_Length = -1;        /* INTEGER_1_10 */
static int hf_rrc_tfci_Field1_Information = -1;   /* ExplicitTFCS_Configuration */
static int hf_rrc_tfci_Field2_Information = -1;   /* TFCI_Field2_Information */
static int hf_rrc_minimumAllowedTFC_Number = -1;  /* TFC_Value */
static int hf_rrc_allowedTFC_List = -1;           /* AllowedTFC_List */
static int hf_rrc_non_allowedTFC_List = -1;       /* Non_allowedTFC_List */
static int hf_rrc_restrictedTrChInfoList = -1;    /* RestrictedTrChInfoList */
static int hf_rrc_fullTFCS = -1;                  /* NULL */
static int hf_rrc_TFC_SubsetList_item = -1;       /* TFC_SubsetList_item */
static int hf_rrc_modeSpecificInfo_24 = -1;       /* T_modeSpecificInfo_24 */
static int hf_rrc_tdd_17 = -1;                    /* T_tdd_16 */
static int hf_rrc_tfci_Range = -1;                /* TFCI_RangeList */
static int hf_rrc_explicit_config_02 = -1;        /* ExplicitTFCS_Configuration */
static int hf_rrc_maxTFCIField2Value = -1;        /* INTEGER_1_1023 */
static int hf_rrc_tfcs_InfoForDSCH = -1;          /* TFCS_InfoForDSCH */
static int hf_rrc_TFCI_RangeList_item = -1;       /* TFCI_Range */
static int hf_rrc_normalTFCI_Signalling = -1;     /* ExplicitTFCS_Configuration */
static int hf_rrc_dummy_38 = -1;                  /* SplitTFCI_Signalling */
static int hf_rrc_tfcs_ID_01 = -1;                /* TFCS_IdentityPlain */
static int hf_rrc_sharedChannelIndicator = -1;    /* BOOLEAN */
static int hf_rrc_ctfc2bit = -1;                  /* INTEGER_0_3 */
static int hf_rrc_ctfc4bit = -1;                  /* INTEGER_0_15 */
static int hf_rrc_ctfc6bit = -1;                  /* INTEGER_0_63 */
static int hf_rrc_ctfc8bit = -1;                  /* INTEGER_0_255 */
static int hf_rrc_ctfc12bit = -1;                 /* INTEGER_0_4095 */
static int hf_rrc_ctfc16bit = -1;                 /* INTEGER_0_65535 */
static int hf_rrc_ctfc24bit = -1;                 /* INTEGER_0_16777215 */
static int hf_rrc_ctfcSize = -1;                  /* T_ctfcSize */
static int hf_rrc_ctfc2Bit = -1;                  /* T_ctfc2Bit */
static int hf_rrc_ctfc2Bit_item = -1;             /* T_ctfc2Bit_item */
static int hf_rrc_ctfc2 = -1;                     /* INTEGER_0_3 */
static int hf_rrc_powerOffsetInformation = -1;    /* PowerOffsetInformation */
static int hf_rrc_ctfc4Bit = -1;                  /* T_ctfc4Bit */
static int hf_rrc_ctfc4Bit_item = -1;             /* T_ctfc4Bit_item */
static int hf_rrc_ctfc4 = -1;                     /* INTEGER_0_15 */
static int hf_rrc_ctfc6Bit = -1;                  /* T_ctfc6Bit */
static int hf_rrc_ctfc6Bit_item = -1;             /* T_ctfc6Bit_item */
static int hf_rrc_ctfc6 = -1;                     /* INTEGER_0_63 */
static int hf_rrc_ctfc8Bit = -1;                  /* T_ctfc8Bit */
static int hf_rrc_ctfc8Bit_item = -1;             /* T_ctfc8Bit_item */
static int hf_rrc_ctfc8 = -1;                     /* INTEGER_0_255 */
static int hf_rrc_ctfc12Bit = -1;                 /* T_ctfc12Bit */
static int hf_rrc_ctfc12Bit_item = -1;            /* T_ctfc12Bit_item */
static int hf_rrc_ctfc12 = -1;                    /* INTEGER_0_4095 */
static int hf_rrc_ctfc16Bit = -1;                 /* T_ctfc16Bit */
static int hf_rrc_ctfc16Bit_item = -1;            /* T_ctfc16Bit_item */
static int hf_rrc_ctfc16 = -1;                    /* INTEGER_0_65535 */
static int hf_rrc_ctfc24Bit = -1;                 /* T_ctfc24Bit */
static int hf_rrc_ctfc24Bit_item = -1;            /* T_ctfc24Bit_item */
static int hf_rrc_ctfc24 = -1;                    /* INTEGER_0_16777215 */
static int hf_rrc_tfci = -1;                      /* INTEGER_0_1023 */
static int hf_rrc_TFCS_RemovalList_item = -1;     /* TFCS_Removal */
static int hf_rrc_messType = -1;                  /* MessType */
static int hf_rrc_tm_SignallingMode = -1;         /* T_tm_SignallingMode */
static int hf_rrc_mode1 = -1;                     /* NULL */
static int hf_rrc_mode2 = -1;                     /* T_mode2 */
static int hf_rrc_ul_controlledTrChList = -1;     /* UL_ControlledTrChList */
static int hf_rrc_dsch_transport_ch_id = -1;      /* TransportChannelIdentity */
static int hf_rrc_dedicatedTransChTFS = -1;       /* DedicatedTransChTFS */
static int hf_rrc_commonTransChTFS = -1;          /* CommonTransChTFS */
static int hf_rrc_commonTransChTFS_LCR = -1;      /* CommonTransChTFS_LCR */
static int hf_rrc_UL_AddReconfTransChInfoList_item = -1;  /* UL_AddReconfTransChInformation */
static int hf_rrc_UL_AddReconfTransChInfoList_r6_item = -1;  /* UL_AddReconfTransChInformation_r6 */
static int hf_rrc_UL_AddReconfTransChInfoList_r7_item = -1;  /* UL_AddReconfTransChInformation_r7 */
static int hf_rrc_UL_AddReconfTransChInfoList_r8_item = -1;  /* UL_AddReconfTransChInformation_r8 */
static int hf_rrc_transportFormatSet = -1;        /* TransportFormatSet */
static int hf_rrc_dch_usch = -1;                  /* T_dch_usch */
static int hf_rrc_e_dch_02 = -1;                  /* T_e_dch_02 */
static int hf_rrc_tti_03 = -1;                    /* E_DCH_TTI */
static int hf_rrc_harq_Info = -1;                 /* T_harq_Info */
static int hf_rrc_addReconf_MAC_d_FlowList = -1;  /* E_DCH_AddReconf_MAC_d_FlowList */
static int hf_rrc_dch_usch_01 = -1;               /* T_dch_usch_01 */
static int hf_rrc_e_dch_03 = -1;                  /* T_e_dch_03 */
static int hf_rrc_modeSpecific = -1;              /* T_modeSpecific */
static int hf_rrc_fdd_55 = -1;                    /* T_fdd_54 */
static int hf_rrc_harq_Info_01 = -1;              /* T_harq_Info_01 */
static int hf_rrc_addReconf_MAC_d_FlowList_01 = -1;  /* E_DCH_AddReconf_MAC_d_FlowList_r7 */
static int hf_rrc_dch_usch_02 = -1;               /* T_dch_usch_02 */
static int hf_rrc_e_dch_04 = -1;                  /* T_e_dch_04 */
static int hf_rrc_ul_MAC_HeaderType = -1;         /* T_ul_MAC_HeaderType */
static int hf_rrc_modeSpecific_01 = -1;           /* T_modeSpecific_01 */
static int hf_rrc_fdd_56 = -1;                    /* T_fdd_55 */
static int hf_rrc_harq_Info_02 = -1;              /* T_harq_Info_02 */
static int hf_rrc_prach_TFCS = -1;                /* TFCS */
static int hf_rrc_modeSpecificInfo_25 = -1;       /* T_modeSpecificInfo_25 */
static int hf_rrc_fdd_57 = -1;                    /* T_fdd_56 */
static int hf_rrc_tdd_18 = -1;                    /* T_tdd_17 */
static int hf_rrc_individualUL_CCTrCH_InfoList = -1;  /* IndividualUL_CCTrCH_InfoList */
static int hf_rrc_modeSpecificInfo_26 = -1;       /* T_modeSpecificInfo_26 */
static int hf_rrc_fdd_58 = -1;                    /* T_fdd_57 */
static int hf_rrc_tdd_19 = -1;                    /* T_tdd_18 */
static int hf_rrc_tfc_SubsetList = -1;            /* TFC_SubsetList */
static int hf_rrc_UL_ControlledTrChList_item = -1;  /* TransportChannelIdentity */
static int hf_rrc_UL_DeletedTransChInfoList_item = -1;  /* UL_TransportChannelIdentity */
static int hf_rrc_UL_DeletedTransChInfoList_r6_item = -1;  /* UL_TransportChannelIdentity_r6 */
static int hf_rrc_ul_TransportChannelIdentity = -1;  /* TransportChannelIdentity */
static int hf_rrc_dch_usch_03 = -1;               /* T_dch_usch_03 */
static int hf_rrc_e_dch_05 = -1;                  /* E_DCH_MAC_d_FlowIdentity */
static int hf_rrc_USCH_TransportChannelsInfo_item = -1;  /* USCH_TransportChannelsInfo_item */
static int hf_rrc_usch_TransportChannelIdentity = -1;  /* TransportChannelIdentity */
static int hf_rrc_usch_TFS = -1;                  /* TransportFormatSet */
static int hf_rrc_AC_To_ASC_MappingTable_item = -1;  /* AC_To_ASC_Mapping */
static int hf_rrc_availableSignatureStartIndex = -1;  /* INTEGER_0_15 */
static int hf_rrc_availableSignatureEndIndex = -1;  /* INTEGER_0_15 */
static int hf_rrc_assignedSubChannelNumber = -1;  /* T_assignedSubChannelNumber */
static int hf_rrc_channelisationCodeIndices = -1;  /* T_channelisationCodeIndices */
static int hf_rrc_subchannelSize = -1;            /* T_subchannelSize */
static int hf_rrc_size1 = -1;                     /* NULL */
static int hf_rrc_size2 = -1;                     /* T_size2 */
static int hf_rrc_subchannels = -1;               /* T_subchannels */
static int hf_rrc_size4 = -1;                     /* T_size4 */
static int hf_rrc_subchannels_01 = -1;            /* T_subchannels_01 */
static int hf_rrc_size8 = -1;                     /* T_size8 */
static int hf_rrc_subchannels_02 = -1;            /* T_subchannels_02 */
static int hf_rrc_channelisationCodeIndices_01 = -1;  /* T_channelisationCodeIndices_01 */
static int hf_rrc_subchannelSize_01 = -1;         /* T_subchannelSize_01 */
static int hf_rrc_size2_01 = -1;                  /* T_size2_01 */
static int hf_rrc_subchannels_03 = -1;            /* T_subchannels_03 */
static int hf_rrc_size4_01 = -1;                  /* T_size4_01 */
static int hf_rrc_subchannels_04 = -1;            /* T_subchannels_04 */
static int hf_rrc_size8_01 = -1;                  /* T_size8_01 */
static int hf_rrc_subchannels_05 = -1;            /* T_subchannels_05 */
static int hf_rrc_size16 = -1;                    /* T_size16 */
static int hf_rrc_subchannels_06 = -1;            /* T_subchannels_06 */
static int hf_rrc_availableSYNC_UlCodesIndics = -1;  /* T_availableSYNC_UlCodesIndics */
static int hf_rrc_subchannelSize_02 = -1;         /* T_subchannelSize_02 */
static int hf_rrc_size2_02 = -1;                  /* T_size2_02 */
static int hf_rrc_subchannels_07 = -1;            /* T_subchannels_07 */
static int hf_rrc_size4_02 = -1;                  /* T_size4_02 */
static int hf_rrc_subchannels_08 = -1;            /* T_subchannels_08 */
static int hf_rrc_size8_02 = -1;                  /* T_size8_02 */
static int hf_rrc_subchannels_09 = -1;            /* T_subchannels_09 */
static int hf_rrc_dynamicTFInformationCCCH = -1;  /* DynamicTFInformationCCCH */
static int hf_rrc_additionalPRACH_TF_and_TFCS_CCCH_IEs = -1;  /* AdditionalPRACH_TF_and_TFCS_CCCH_IEs */
static int hf_rrc_AdditionalPRACH_TF_and_TFCS_CCCH_List_item = -1;  /* AdditionalPRACH_TF_and_TFCS_CCCH */
static int hf_rrc_AdditionalDLSecCellInfoListFDD_item = -1;  /* AdditionalDLSecCellInfoFDD */
static int hf_rrc_AdditionalDLSecCellInfoListFDD_r11_item = -1;  /* AdditionalDLSecCellInfoFDD_r11 */
static int hf_rrc_AdditionalDLSecCellInfoListFDD2_item = -1;  /* AdditionalDLSecCellInfoFDD_r11 */
static int hf_rrc_channelisationCode256 = -1;     /* ChannelisationCode256 */
static int hf_rrc_sttd_Indicator = -1;            /* BOOLEAN */
static int hf_rrc_aich_TransmissionTiming = -1;   /* AICH_TransmissionTiming */
static int hf_rrc_allocationActivationTime = -1;  /* INTEGER_0_255 */
static int hf_rrc_allocationDuration = -1;        /* INTEGER_1_256 */
static int hf_rrc_antenna3And4_S_CPICH = -1;      /* Antenna3And4_S_CPICH */
static int hf_rrc_antenna3And4_D_CPICH = -1;      /* Antenna3And4_D_CPICH */
static int hf_rrc_antenna3_S_CPICH = -1;          /* Antenna3_S_CPICH */
static int hf_rrc_antenna4_S_CPICH = -1;          /* Antenna4_S_CPICH */
static int hf_rrc_s_cpich_PowerOffset_Mimo = -1;  /* S_CPICH_PowerOffset_4x4MIMO */
static int hf_rrc_antenna3_D_CPICH = -1;          /* Antenna3_D_CPICH */
static int hf_rrc_antenna4_D_CPICH = -1;          /* Antenna4_D_CPICH */
static int hf_rrc_d_cpich_PowerOffset_Mimo = -1;  /* D_CPICH_PowerOffset_4x4MIMO */
static int hf_rrc_initialD_CPICHStatus = -1;      /* T_initialD_CPICHStatus */
static int hf_rrc_channelisationCode = -1;        /* ChannelisationCode256 */
static int hf_rrc_ap_Signature = -1;              /* AP_Signature */
static int hf_rrc_availableAP_SubchannelList = -1;  /* AvailableAP_SubchannelList */
static int hf_rrc_accessServiceClass_FDD = -1;    /* AccessServiceClass_FDD */
static int hf_rrc_accessServiceClass_TDD = -1;    /* AccessServiceClass_TDD */
static int hf_rrc_accessServiceClass_TDD_01 = -1;  /* AccessServiceClass_TDD_r7 */
static int hf_rrc_accessServiceClass_TDD_LCR = -1;  /* AccessServiceClass_TDD_LCR_r4 */
static int hf_rrc_AvailableAP_Signature_VCAMList_item = -1;  /* AP_Signature_VCAM */
static int hf_rrc_AvailableAP_SignatureList_item = -1;  /* AP_Signature */
static int hf_rrc_AvailableAP_SubchannelList_item = -1;  /* AP_Subchannel */
static int hf_rrc_AvailableMinimumSF_ListVCAM_item = -1;  /* AvailableMinimumSF_VCAM */
static int hf_rrc_minimumSpreadingFactor = -1;    /* MinimumSpreadingFactor */
static int hf_rrc_nf_Max = -1;                    /* NF_Max */
static int hf_rrc_maxAvailablePCPCH_Number = -1;  /* MaxAvailablePCPCH_Number */
static int hf_rrc_availableAP_Signature_VCAMList = -1;  /* AvailableAP_Signature_VCAMList */
static int hf_rrc_tfcs_Identity = -1;             /* TFCS_Identity */
static int hf_rrc_ul_DPCH_PowerControlInfo = -1;  /* UL_DPCH_PowerControlInfo */
static int hf_rrc_ul_DPCH_PowerControlInfo_01 = -1;  /* UL_DPCH_PowerControlInfo_r4 */
static int hf_rrc_ul_DPCH_PowerControlInfo_02 = -1;  /* UL_DPCH_PowerControlInfo_r5 */
static int hf_rrc_ul_DPCH_PowerControlInfo_03 = -1;  /* UL_DPCH_PowerControlInfo_r7 */
static int hf_rrc_CD_AccessSlotSubchannelList_item = -1;  /* CD_AccessSlotSubchannel */
static int hf_rrc_CD_SignatureCodeList_item = -1;  /* CD_SignatureCode */
static int hf_rrc_burstType = -1;                 /* BurstType */
static int hf_rrc_midambleShift = -1;             /* MidambleShiftLong */
static int hf_rrc_timeslot = -1;                  /* TimeslotNumber */
static int hf_rrc_cellParametersID = -1;          /* CellParametersID */
static int hf_rrc_notActive = -1;                 /* NULL */
static int hf_rrc_isActive = -1;                  /* AvailableMinimumSF_ListVCAM */
static int hf_rrc_availableAP_SignatureList = -1;  /* AvailableAP_SignatureList */
static int hf_rrc_pdsch_CodeMapList = -1;         /* PDSCH_CodeMapList */
static int hf_rrc_start_code = -1;                /* HS_ChannelisationCode_LCR */
static int hf_rrc_stop_code = -1;                 /* HS_ChannelisationCode_LCR */
static int hf_rrc_s_offset = -1;                  /* INTEGER_0_9 */
static int hf_rrc_f_dpch_ChannelisationCodeNumber = -1;  /* INTEGER_0_255 */
static int hf_rrc_e_RGCH_Information_01 = -1;     /* E_RGCH_Information_CommonEdch */
static int hf_rrc_e_hich_Info = -1;               /* E_HICH_Information_CommonEdch */
static int hf_rrc_ul_DPCH_CodeInfoForCommonEDCH = -1;  /* UL_DPCH_CodeInfoForCommonEDCH */
static int hf_rrc_twoMsHarqConfiguration = -1;    /* TwoMsHarqConfiguration */
static int hf_rrc_Common_E_RNTI_Info_item = -1;   /* Common_E_RNTI_Info_item */
static int hf_rrc_starting_E_RNTI = -1;           /* E_RNTI */
static int hf_rrc_number_of_group = -1;           /* INTEGER_1_maxERNTIgroup */
static int hf_rrc_number_of_ENRTI_per_group = -1;  /* INTEGER_1_maxERNTIperGroup */
static int hf_rrc_scheduledTransmissionConfiguration = -1;  /* ScheduledTransmissionConfiguration */
static int hf_rrc_cOffset = -1;                   /* INTEGER_0_29 */
static int hf_rrc_ul_InterferenceForCommonEDCH = -1;  /* UL_Interference */
static int hf_rrc_common_E_DCH_MAC_d_FlowList = -1;  /* Common_E_DCH_MAC_d_FlowList */
static int hf_rrc_modeSpecificInfo_27 = -1;       /* T_modeSpecificInfo_27 */
static int hf_rrc_dummy_39 = -1;                  /* T_dummy_14 */
static int hf_rrc_tdd_20 = -1;                    /* T_tdd_19 */
static int hf_rrc_tdd768_06 = -1;                 /* NULL */
static int hf_rrc_tdd384_11 = -1;                 /* NULL */
static int hf_rrc_tdd128_11 = -1;                 /* T_tdd128_11 */
static int hf_rrc_e_RUCCH_Info = -1;              /* E_RUCCH_Info_TDD128 */
static int hf_rrc_e_PUCH_Info = -1;               /* E_PUCH_Info_TDD128 */
static int hf_rrc_e_hich_Information = -1;        /* E_HICH_Information_TDD128 */
static int hf_rrc_e_agch_Information = -1;        /* E_AGCH_Information_TDD128 */
static int hf_rrc_harq_Info_03 = -1;              /* T_harq_Info_03 */
static int hf_rrc_ccch_transmission_Info = -1;    /* T_ccch_transmission_Info */
static int hf_rrc_common_e_rnti_Info = -1;        /* Common_E_RNTI_Info */
static int hf_rrc_harq_MaximumNumberOfRetransmissions = -1;  /* INTEGER_0_7 */
static int hf_rrc_harq_retransmission_timer = -1;  /* T_harq_retransmission_timer */
static int hf_rrc_harq_power_offset = -1;         /* INTEGER_0_6 */
static int hf_rrc_prach_PreambleForEnhancedUplink = -1;  /* PRACH_PreambleForEnhancedUplink */
static int hf_rrc_initialServingGrantValue = -1;  /* INTEGER_0_37 */
static int hf_rrc_e_dch_TTI = -1;                 /* E_DCH_TTI */
static int hf_rrc_e_agch_Information_01 = -1;     /* E_AGCH_Information */
static int hf_rrc_harq_Info_04 = -1;              /* T_harq_Info_04 */
static int hf_rrc_ul_DPCHpowerControlInfoForCommonEDCH = -1;  /* UL_DPCHpowerControlInfoForCommonEDCH */
static int hf_rrc_e_dpcch_Info = -1;              /* E_DPCCH_Info_r7 */
static int hf_rrc_e_dpdch_Info = -1;              /* E_DPDCH_Info_r8 */
static int hf_rrc_dl_FDPCH_TPCcommandErrorRate = -1;  /* INTEGER_1_10 */
static int hf_rrc_additional_E_DCH_TransmitBackoff = -1;  /* INTEGER_0_15 */
static int hf_rrc_max_CCCH_ResourceAllocation = -1;  /* T_max_CCCH_ResourceAllocation */
static int hf_rrc_max_PeriodForCollisionResolution = -1;  /* INTEGER_8_24 */
static int hf_rrc_e_dch_TransmitContinuationOffset = -1;  /* T_e_dch_TransmitContinuationOffset */
static int hf_rrc_ack_nack_support_on_HS_DPCCH = -1;  /* BOOLEAN */
static int hf_rrc_measurement_Feedback_Info = -1;  /* Measurement_Feedback_Info_r7 */
static int hf_rrc_common_E_DCH_ResourceInfoList = -1;  /* SEQUENCE_SIZE_1_maxEDCHs_OF_Common_E_DCH_ResourceInfoList */
static int hf_rrc_common_E_DCH_ResourceInfoList_item = -1;  /* Common_E_DCH_ResourceInfoList */
static int hf_rrc_common_E_DCH_MAC_d_Flow_Info_List_ConcurrentTTI = -1;  /* Common_E_DCH_MAC_d_Flow_Info_List_ConcurrentTTI */
static int hf_rrc_ul_DPCHpowerControlInfoConcurrentTTI = -1;  /* UL_DPCHpowerControlInfoConcurrentTTI */
static int hf_rrc_e_DPCCH_DPCCH_PowerOffset = -1;  /* E_DPCCH_DPCCH_PowerOffset */
static int hf_rrc_max_CCCH_ResourceAllocation_01 = -1;  /* T_max_CCCH_ResourceAllocation_01 */
static int hf_rrc_e_dch_TransmitContinuationOffset_01 = -1;  /* T_e_dch_TransmitContinuationOffset_01 */
static int hf_rrc_measurement_Feedback_Info_ConcurrentTTI = -1;  /* Measurement_Feedback_Info_ConcurrentTTI */
static int hf_rrc_channelisationCode_01 = -1;     /* INTEGER_0_127 */
static int hf_rrc_signatureSequence = -1;         /* INTEGER_0_39 */
static int hf_rrc_configurationInfo = -1;         /* T_configurationInfo */
static int hf_rrc_newConfiguration_01 = -1;       /* T_newConfiguration_01 */
static int hf_rrc_eRGCHNeighbourCellList = -1;    /* BIT_STRING_SIZE_maxCellMeas */
static int hf_rrc_commonERGCHChannelConfigList = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CommonERGCHChannelConfig */
static int hf_rrc_commonERGCHChannelConfigList_item = -1;  /* CommonERGCHChannelConfig */
static int hf_rrc_minimumServingGrantValue = -1;  /* INTEGER_0_37 */
static int hf_rrc_reportingRange = -1;            /* ReportingRange */
static int hf_rrc_filterCoefficient = -1;         /* FilterCoefficient */
static int hf_rrc_secondInterleavingMode = -1;    /* SecondInterleavingMode */
static int hf_rrc_tfci_Coding = -1;               /* TFCI_Coding */
static int hf_rrc_puncturingLimit = -1;           /* PuncturingLimit */
static int hf_rrc_repetitionPeriodAndLength = -1;  /* RepetitionPeriodAndLength */
static int hf_rrc_repetitionPeriodLengthAndOffset = -1;  /* RepetitionPeriodLengthAndOffset */
static int hf_rrc_controlChannelDrxOperation = -1;  /* T_controlChannelDrxOperation */
static int hf_rrc_continue_01 = -1;               /* T_continue */
static int hf_rrc_enablingDelay = -1;             /* EnablingDelay_TDD128 */
static int hf_rrc_newOperation = -1;              /* T_newOperation */
static int hf_rrc_hS_SCCH_Drx_Info = -1;          /* HS_SCCH_DRX_Info_TDD128 */
static int hf_rrc_e_AGCH_Drx_Info = -1;           /* E_AGCH_DRX_Info_TDD128 */
static int hf_rrc_cpch_SetID = -1;                /* CPCH_SetID */
static int hf_rrc_dynamicPersistenceLevelTF_List = -1;  /* DynamicPersistenceLevelTF_List */
static int hf_rrc_CPCH_PersistenceLevelsList_item = -1;  /* CPCH_PersistenceLevels */
static int hf_rrc_ap_PreambleScramblingCode = -1;  /* AP_PreambleScramblingCode */
static int hf_rrc_ap_AICH_ChannelisationCode = -1;  /* AP_AICH_ChannelisationCode */
static int hf_rrc_cd_PreambleScramblingCode = -1;  /* CD_PreambleScramblingCode */
static int hf_rrc_cd_CA_ICH_ChannelisationCode = -1;  /* CD_CA_ICH_ChannelisationCode */
static int hf_rrc_cd_AccessSlotSubchannelList = -1;  /* CD_AccessSlotSubchannelList */
static int hf_rrc_cd_SignatureCodeList = -1;      /* CD_SignatureCodeList */
static int hf_rrc_deltaPp_m = -1;                 /* DeltaPp_m */
static int hf_rrc_ul_DPCCH_SlotFormat = -1;       /* UL_DPCCH_SlotFormat */
static int hf_rrc_n_StartMessage = -1;            /* N_StartMessage */
static int hf_rrc_n_EOT = -1;                     /* N_EOT */
static int hf_rrc_channelAssignmentActive = -1;   /* ChannelAssignmentActive */
static int hf_rrc_cpch_StatusIndicationMode = -1;  /* CPCH_StatusIndicationMode */
static int hf_rrc_pcpch_ChannelInfoList = -1;     /* PCPCH_ChannelInfoList */
static int hf_rrc_CPCH_SetInfoList_item = -1;     /* CPCH_SetInfo */
static int hf_rrc_timeInfo = -1;                  /* TimeInfo */
static int hf_rrc_commonTimeslotInfo = -1;        /* CommonTimeslotInfo */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes = -1;  /* DownlinkTimeslotsCodes */
static int hf_rrc_ul_CCTrChTPCList = -1;          /* UL_CCTrChTPCList */
static int hf_rrc_tddOption_03 = -1;              /* T_tddOption_03 */
static int hf_rrc_tdd384_12 = -1;                 /* T_tdd384_11 */
static int hf_rrc_tdd128_12 = -1;                 /* T_tdd128_12 */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes_01 = -1;  /* DownlinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_tddOption_04 = -1;              /* T_tddOption_04 */
static int hf_rrc_tdd384_13 = -1;                 /* T_tdd384_12 */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes_02 = -1;  /* DownlinkTimeslotsCodes_r7 */
static int hf_rrc_tdd768_07 = -1;                 /* T_tdd768_06 */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes_03 = -1;  /* DownlinkTimeslotsCodes_VHCR */
static int hf_rrc_tdd128_13 = -1;                 /* T_tdd128_13 */
static int hf_rrc_DL_CCTrChList_item = -1;        /* DL_CCTrCh */
static int hf_rrc_DL_CCTrChList_r7_item = -1;     /* DL_CCTrCh_r7 */
static int hf_rrc_DL_CCTrChList_r4_item = -1;     /* DL_CCTrCh_r4 */
static int hf_rrc_DL_CCTrChListToRemove_item = -1;  /* TFCS_IdentityPlain */
static int hf_rrc_secondaryScramblingCode = -1;   /* SecondaryScramblingCode */
static int hf_rrc_sf_AndCodeNumber = -1;          /* SF512_AndCodeNumber */
static int hf_rrc_scramblingCodeChange = -1;      /* ScramblingCodeChange */
static int hf_rrc_DL_ChannelisationCodeList_item = -1;  /* DL_ChannelisationCode */
static int hf_rrc_dl_DPCH_InfoCommon = -1;        /* DL_DPCH_InfoCommon */
static int hf_rrc_modeSpecificInfo_28 = -1;       /* T_modeSpecificInfo_28 */
static int hf_rrc_fdd_59 = -1;                    /* T_fdd_58 */
static int hf_rrc_defaultDPCH_OffsetValue = -1;   /* DefaultDPCH_OffsetValueFDD */
static int hf_rrc_dpch_CompressedModeInfo = -1;   /* DPCH_CompressedModeInfo */
static int hf_rrc_dummy_40 = -1;                  /* SSDT_Information */
static int hf_rrc_tdd_21 = -1;                    /* T_tdd_20 */
static int hf_rrc_defaultDPCH_OffsetValue_01 = -1;  /* DefaultDPCH_OffsetValueTDD */
static int hf_rrc_dl_DPCH_InfoCommon_01 = -1;     /* DL_DPCH_InfoCommon_r4 */
static int hf_rrc_modeSpecificInfo_29 = -1;       /* T_modeSpecificInfo_29 */
static int hf_rrc_fdd_60 = -1;                    /* T_fdd_59 */
static int hf_rrc_dummy_41 = -1;                  /* SSDT_Information_r4 */
static int hf_rrc_tdd_22 = -1;                    /* T_tdd_21 */
static int hf_rrc_tddOption_05 = -1;              /* T_tddOption_05 */
static int hf_rrc_tdd128_14 = -1;                 /* T_tdd128_14 */
static int hf_rrc_tstd_Indicator = -1;            /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_30 = -1;       /* T_modeSpecificInfo_30 */
static int hf_rrc_fdd_61 = -1;                    /* T_fdd_60 */
static int hf_rrc_tdd_23 = -1;                    /* T_tdd_22 */
static int hf_rrc_tddOption_06 = -1;              /* T_tddOption_06 */
static int hf_rrc_tdd128_15 = -1;                 /* T_tdd128_15 */
static int hf_rrc_mac_hsResetIndicator_05 = -1;   /* T_mac_hsResetIndicator_05 */
static int hf_rrc_dl_dpchInfoCommon = -1;         /* T_dl_dpchInfoCommon */
static int hf_rrc_dl_DPCH_InfoCommon_02 = -1;     /* DL_DPCH_InfoCommon_r6 */
static int hf_rrc_dl_FDPCH_InfoCommon = -1;       /* DL_FDPCH_InfoCommon_r6 */
static int hf_rrc_modeSpecificInfo_31 = -1;       /* T_modeSpecificInfo_31 */
static int hf_rrc_fdd_62 = -1;                    /* T_fdd_61 */
static int hf_rrc_tdd_24 = -1;                    /* T_tdd_23 */
static int hf_rrc_tddOption_07 = -1;              /* T_tddOption_07 */
static int hf_rrc_tdd128_16 = -1;                 /* T_tdd128_16 */
static int hf_rrc_mac_hsResetIndicator_06 = -1;   /* T_mac_hsResetIndicator_06 */
static int hf_rrc_postVerificationPeriod_07 = -1;  /* T_postVerificationPeriod_07 */
static int hf_rrc_dl_dpchInfoCommon_01 = -1;      /* T_dl_dpchInfoCommon_01 */
static int hf_rrc_modeSpecificInfo_32 = -1;       /* T_modeSpecificInfo_32 */
static int hf_rrc_fdd_63 = -1;                    /* T_fdd_62 */
static int hf_rrc_tdd_25 = -1;                    /* T_tdd_24 */
static int hf_rrc_tddOption_08 = -1;              /* T_tddOption_08 */
static int hf_rrc_tdd128_17 = -1;                 /* T_tdd128_17 */
static int hf_rrc_mac_hsResetIndicator_07 = -1;   /* T_mac_hsResetIndicator_07 */
static int hf_rrc_postVerificationPeriod_08 = -1;  /* T_postVerificationPeriod_08 */
static int hf_rrc_dl_dpchInfoCommon_02 = -1;      /* T_dl_dpchInfoCommon_02 */
static int hf_rrc_modeSpecificInfo_33 = -1;       /* T_modeSpecificInfo_33 */
static int hf_rrc_fdd_64 = -1;                    /* T_fdd_63 */
static int hf_rrc_dpch_CompressedModeInfo_01 = -1;  /* DPCH_CompressedModeInfo_r8 */
static int hf_rrc_tdd_26 = -1;                    /* T_tdd_25 */
static int hf_rrc_tddOption_09 = -1;              /* T_tddOption_09 */
static int hf_rrc_tdd128_18 = -1;                 /* T_tdd128_18 */
static int hf_rrc_mac_hsResetIndicator_08 = -1;   /* T_mac_hsResetIndicator_08 */
static int hf_rrc_postVerificationPeriod_09 = -1;  /* T_postVerificationPeriod_09 */
static int hf_rrc_dl_dpchInfoCommon_03 = -1;      /* T_dl_dpchInfoCommon_03 */
static int hf_rrc_modeSpecificInfo_34 = -1;       /* T_modeSpecificInfo_34 */
static int hf_rrc_fdd_65 = -1;                    /* T_fdd_64 */
static int hf_rrc_dpch_CompressedModeInfo_02 = -1;  /* DPCH_CompressedModeInfo_r10 */
static int hf_rrc_tdd_27 = -1;                    /* T_tdd_26 */
static int hf_rrc_tddOption_10 = -1;              /* T_tddOption_10 */
static int hf_rrc_tdd128_19 = -1;                 /* T_tdd128_19 */
static int hf_rrc_mac_hsResetIndicator_09 = -1;   /* T_mac_hsResetIndicator_09 */
static int hf_rrc_postVerificationPeriod_10 = -1;  /* T_postVerificationPeriod_10 */
static int hf_rrc_dl_dpchInfoCommon_04 = -1;      /* T_dl_dpchInfoCommon_04 */
static int hf_rrc_modeSpecificInfo_35 = -1;       /* T_modeSpecificInfo_35 */
static int hf_rrc_fdd_66 = -1;                    /* T_fdd_65 */
static int hf_rrc_tdd_28 = -1;                    /* T_tdd_27 */
static int hf_rrc_tddOption_11 = -1;              /* T_tddOption_11 */
static int hf_rrc_tdd128_20 = -1;                 /* T_tdd128_20 */
static int hf_rrc_mac_hsResetIndicator_10 = -1;   /* T_mac_hsResetIndicator_10 */
static int hf_rrc_postVerificationPeriod_11 = -1;  /* T_postVerificationPeriod_11 */
static int hf_rrc_mac_hsResetIndicator_assisting_01 = -1;  /* T_mac_hsResetIndicator_assisting_01 */
static int hf_rrc_dl_DPCH_InfoCommon_03 = -1;     /* DL_DPCH_InfoCommonPost */
static int hf_rrc_dl_DPCH_InfoCommon_04 = -1;     /* DL_DPCH_InfoCommonPredef */
static int hf_rrc_cfnHandling = -1;               /* T_cfnHandling */
static int hf_rrc_maintain = -1;                  /* NULL */
static int hf_rrc_initialise = -1;                /* T_initialise */
static int hf_rrc_dummy_42 = -1;                  /* Cfntargetsfnframeoffset */
static int hf_rrc_modeSpecificInfo_36 = -1;       /* T_modeSpecificInfo_36 */
static int hf_rrc_fdd_67 = -1;                    /* T_fdd_66 */
static int hf_rrc_dl_DPCH_PowerControlInfo = -1;  /* DL_DPCH_PowerControlInfo */
static int hf_rrc_powerOffsetPilot_pdpdch = -1;   /* PowerOffsetPilot_pdpdch */
static int hf_rrc_dl_rate_matching_restriction = -1;  /* Dl_rate_matching_restriction */
static int hf_rrc_spreadingFactorAndPilot = -1;   /* SF512_AndPilot */
static int hf_rrc_positionFixedOrFlexible = -1;   /* PositionFixedOrFlexible */
static int hf_rrc_tfci_Existence = -1;            /* BOOLEAN */
static int hf_rrc_tdd_29 = -1;                    /* T_tdd_28 */
static int hf_rrc_cfnHandling_01 = -1;            /* T_cfnHandling_01 */
static int hf_rrc_initialise_01 = -1;             /* T_initialise_01 */
static int hf_rrc_modeSpecificInfo_37 = -1;       /* T_modeSpecificInfo_37 */
static int hf_rrc_fdd_68 = -1;                    /* T_fdd_67 */
static int hf_rrc_tdd_30 = -1;                    /* T_tdd_29 */
static int hf_rrc_mac_d_HFN_initial_value = -1;   /* MAC_d_HFN_initial_value */
static int hf_rrc_cfnHandling_02 = -1;            /* T_cfnHandling_02 */
static int hf_rrc_maintain_01 = -1;               /* T_maintain */
static int hf_rrc_timingmaintainedsynchind = -1;  /* TimingMaintainedSynchInd */
static int hf_rrc_initialise_02 = -1;             /* NULL */
static int hf_rrc_modeSpecificInfo_38 = -1;       /* T_modeSpecificInfo_38 */
static int hf_rrc_fdd_69 = -1;                    /* T_fdd_68 */
static int hf_rrc_tdd_31 = -1;                    /* T_tdd_30 */
static int hf_rrc_modeSpecificInfo_39 = -1;       /* T_modeSpecificInfo_39 */
static int hf_rrc_fdd_70 = -1;                    /* T_fdd_69 */
static int hf_rrc_tdd_32 = -1;                    /* T_tdd_31 */
static int hf_rrc_fdd_71 = -1;                    /* T_fdd_70 */
static int hf_rrc_pCPICH_UsageForChannelEst = -1;  /* PCPICH_UsageForChannelEst */
static int hf_rrc_dpch_FrameOffset = -1;          /* DPCH_FrameOffset */
static int hf_rrc_secondaryCPICH_Info = -1;       /* SecondaryCPICH_Info */
static int hf_rrc_dl_ChannelisationCodeList = -1;  /* DL_ChannelisationCodeList */
static int hf_rrc_tpc_CombinationIndex = -1;      /* TPC_CombinationIndex */
static int hf_rrc_dummy_43 = -1;                  /* SSDT_CellIdentity */
static int hf_rrc_closedLoopTimingAdjMode = -1;   /* ClosedLoopTimingAdjMode */
static int hf_rrc_tdd_33 = -1;                    /* T_tdd_32 */
static int hf_rrc_dl_CCTrChListToEstablish = -1;  /* DL_CCTrChList */
static int hf_rrc_dl_CCTrChListToRemove = -1;     /* DL_CCTrChListToRemove */
static int hf_rrc_fdd_72 = -1;                    /* T_fdd_71 */
static int hf_rrc_tdd_34 = -1;                    /* T_tdd_33 */
static int hf_rrc_dl_CCTrChListToEstablish_01 = -1;  /* DL_CCTrChList_r4 */
static int hf_rrc_fdd_73 = -1;                    /* T_fdd_72 */
static int hf_rrc_powerOffsetTPC_pdpdch = -1;     /* PowerOffsetTPC_pdpdch */
static int hf_rrc_tdd_35 = -1;                    /* T_tdd_34 */
static int hf_rrc_fdd_74 = -1;                    /* T_fdd_73 */
static int hf_rrc_tdd_36 = -1;                    /* T_tdd_35 */
static int hf_rrc_fdd_75 = -1;                    /* T_fdd_74 */
static int hf_rrc_tdd_37 = -1;                    /* T_tdd_36 */
static int hf_rrc_dl_CCTrChListToEstablish_02 = -1;  /* DL_CCTrChList_r7 */
static int hf_rrc_fdpch_FrameOffset = -1;         /* DPCH_FrameOffset */
static int hf_rrc_dl_ChannelisationCode = -1;     /* INTEGER_0_255 */
static int hf_rrc_fdpch_SlotFormat = -1;          /* FDPCH_SlotFormat */
static int hf_rrc_sttdIndication = -1;            /* STTDIndication */
static int hf_rrc_dl_ChannelisationCode_01 = -1;  /* DL_ChannelisationCode */
static int hf_rrc_dl_DPCH_TimeslotsCodes = -1;    /* DownlinkTimeslotsCodes */
static int hf_rrc_modeSpecificInfo_40 = -1;       /* T_modeSpecificInfo_40 */
static int hf_rrc_fdd_76 = -1;                    /* T_fdd_75 */
static int hf_rrc_tdd_38 = -1;                    /* T_tdd_37 */
static int hf_rrc_tpc_StepSizeTDD = -1;           /* TPC_StepSizeTDD */
static int hf_rrc_cfnHandling_03 = -1;            /* T_cfnHandling_03 */
static int hf_rrc_maintain_02 = -1;               /* T_maintain_01 */
static int hf_rrc_dl_FDPCH_PowerControlInfo = -1;  /* DL_DPCH_PowerControlInfo */
static int hf_rrc_dl_FDPCH_TPCcommandErrorRate_01 = -1;  /* INTEGER_1_16 */
static int hf_rrc_hs_scch_Info = -1;              /* HS_SCCH_Info */
static int hf_rrc_measurement_feedback_Info = -1;  /* Measurement_Feedback_Info */
static int hf_rrc_modeSpecificInfo_41 = -1;       /* T_modeSpecificInfo_41 */
static int hf_rrc_tdd_39 = -1;                    /* T_tdd_38 */
static int hf_rrc_tdd384_14 = -1;                 /* T_tdd384_13 */
static int hf_rrc_dl_HSPDSCH_TS_Configuration = -1;  /* DL_HSPDSCH_TS_Configuration */
static int hf_rrc_tdd128_21 = -1;                 /* T_tdd128_21 */
static int hf_rrc_hs_PDSCH_Midamble_Configuration_tdd128 = -1;  /* HS_PDSCH_Midamble_Configuration_TDD128 */
static int hf_rrc_hs_scch_Info_01 = -1;           /* HS_SCCH_Info_r6 */
static int hf_rrc_modeSpecificInfo_42 = -1;       /* T_modeSpecificInfo_42 */
static int hf_rrc_tdd_40 = -1;                    /* T_tdd_39 */
static int hf_rrc_tdd384_15 = -1;                 /* T_tdd384_14 */
static int hf_rrc_tdd128_22 = -1;                 /* T_tdd128_22 */
static int hf_rrc_hs_scch_Info_02 = -1;           /* HS_SCCH_Info_r7 */
static int hf_rrc_measurement_feedback_Info_01 = -1;  /* Measurement_Feedback_Info_r7 */
static int hf_rrc_modeSpecificInfo_43 = -1;       /* T_modeSpecificInfo_43 */
static int hf_rrc_tdd_41 = -1;                    /* T_tdd_40 */
static int hf_rrc_tdd384_16 = -1;                 /* T_tdd384_15 */
static int hf_rrc_tdd768_08 = -1;                 /* T_tdd768_07 */
static int hf_rrc_dl_HSPDSCH_TS_Configuration_01 = -1;  /* DL_HSPDSCH_TS_Configuration_VHCR */
static int hf_rrc_tdd128_23 = -1;                 /* T_tdd128_23 */
static int hf_rrc_dl_MultiCarrier_Information = -1;  /* DL_MultiCarrier_Information */
static int hf_rrc_fdd_77 = -1;                    /* T_fdd_76 */
static int hf_rrc_dl_64QAM_Configured = -1;       /* T_dl_64QAM_Configured */
static int hf_rrc_modeSpecificInfo_44 = -1;       /* T_modeSpecificInfo_44 */
static int hf_rrc_tdd_42 = -1;                    /* T_tdd_41 */
static int hf_rrc_tdd384_17 = -1;                 /* T_tdd384_16 */
static int hf_rrc_tdd768_09 = -1;                 /* T_tdd768_08 */
static int hf_rrc_tdd128_24 = -1;                 /* T_tdd128_24 */
static int hf_rrc_fdd_78 = -1;                    /* T_fdd_77 */
static int hf_rrc_dl_64QAM_Configured_01 = -1;    /* T_dl_64QAM_Configured_01 */
static int hf_rrc_modeSpecificInfo_45 = -1;       /* T_modeSpecificInfo_45 */
static int hf_rrc_tdd_43 = -1;                    /* T_tdd_42 */
static int hf_rrc_tdd128_25 = -1;                 /* T_tdd128_25 */
static int hf_rrc_outofSyncWindow = -1;           /* OutofSyncWindow */
static int hf_rrc_hs_scch_Info_03 = -1;           /* HS_SCCH_Info_r8_ext */
static int hf_rrc_hs_scch_Info_04 = -1;           /* HS_SCCH_Info_r9 */
static int hf_rrc_modeSpecificInfo_46 = -1;       /* T_modeSpecificInfo_46 */
static int hf_rrc_tdd_44 = -1;                    /* T_tdd_43 */
static int hf_rrc_tdd384_18 = -1;                 /* T_tdd384_17 */
static int hf_rrc_tdd768_10 = -1;                 /* T_tdd768_09 */
static int hf_rrc_tdd128_26 = -1;                 /* T_tdd128_26 */
static int hf_rrc_tS0_Indicator = -1;             /* T_tS0_Indicator */
static int hf_rrc_fdd_79 = -1;                    /* T_fdd_78 */
static int hf_rrc_dl_64QAM_Configured_02 = -1;    /* T_dl_64QAM_Configured_02 */
static int hf_rrc_measurement_feedback_Info_02 = -1;  /* Measurement_Feedback_Info_r11 */
static int hf_rrc_modeSpecificInfo_47 = -1;       /* T_modeSpecificInfo_47 */
static int hf_rrc_tdd_45 = -1;                    /* T_tdd_44 */
static int hf_rrc_tdd384_19 = -1;                 /* T_tdd384_18 */
static int hf_rrc_tdd768_11 = -1;                 /* T_tdd768_10 */
static int hf_rrc_tdd128_27 = -1;                 /* T_tdd128_27 */
static int hf_rrc_tS0_Indicator_01 = -1;          /* T_tS0_Indicator_01 */
static int hf_rrc_fdd_80 = -1;                    /* T_fdd_79 */
static int hf_rrc_dl_64QAM_Configured_03 = -1;    /* T_dl_64QAM_Configured_03 */
static int hf_rrc_DL_HSPDSCH_MultiCarrier_Information_item = -1;  /* DL_HSPDSCH_MultiCarrier_Information_item */
static int hf_rrc_uarfcn_Carrier = -1;            /* UARFCN */
static int hf_rrc_hs_PDSCH_Midamble_Configuration = -1;  /* HS_PDSCH_Midamble_Configuration_TDD128 */
static int hf_rrc_hs_SCCH_TDD128_MultiCarrier = -1;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_MultiCarrier */
static int hf_rrc_hs_SCCH_TDD128_MultiCarrier_item = -1;  /* HS_SCCH_TDD128_MultiCarrier */
static int hf_rrc_DL_HSPDSCH_TS_Configuration_item = -1;  /* DL_HSPDSCH_TS_Configuration_item */
static int hf_rrc_midambleShiftAndBurstType = -1;  /* MidambleShiftAndBurstType_DL */
static int hf_rrc_DL_HSPDSCH_TS_Configuration_VHCR_item = -1;  /* DL_HSPDSCH_TS_Configuration_VHCR_item */
static int hf_rrc_midambleShiftAndBurstType_01 = -1;  /* MidambleShiftAndBurstType_DL_VHCR */
static int hf_rrc_modeSpecificInfo_48 = -1;       /* T_modeSpecificInfo_48 */
static int hf_rrc_fdd_81 = -1;                    /* T_fdd_80 */
static int hf_rrc_dummy1_02 = -1;                 /* PDSCH_SHO_DCH_Info */
static int hf_rrc_dummy2_07 = -1;                 /* PDSCH_CodeMapping */
static int hf_rrc_tdd_46 = -1;                    /* PrimaryCCPCH_Info */
static int hf_rrc_dl_DPCH_InfoPerRL = -1;         /* DL_DPCH_InfoPerRL */
static int hf_rrc_dummy_44 = -1;                  /* SCCPCH_InfoForFACH */
static int hf_rrc_modeSpecificInfo_49 = -1;       /* T_modeSpecificInfo_49 */
static int hf_rrc_fdd_82 = -1;                    /* T_fdd_81 */
static int hf_rrc_tdd_47 = -1;                    /* PrimaryCCPCH_Info_r4 */
static int hf_rrc_dl_DPCH_InfoPerRL_01 = -1;      /* DL_DPCH_InfoPerRL_r4 */
static int hf_rrc_dummy_45 = -1;                  /* SCCPCH_InfoForFACH_r4 */
static int hf_rrc_modeSpecificInfo_50 = -1;       /* T_modeSpecificInfo_50 */
static int hf_rrc_fdd_83 = -1;                    /* T_fdd_82 */
static int hf_rrc_servingHSDSCH_RL_indicator = -1;  /* BOOLEAN */
static int hf_rrc_dl_DPCH_InfoPerRL_02 = -1;      /* DL_DPCH_InfoPerRL_r5 */
static int hf_rrc_modeSpecificInfo_51 = -1;       /* T_modeSpecificInfo_51 */
static int hf_rrc_fdd_84 = -1;                    /* T_fdd_83 */
static int hf_rrc_modeSpecificInfo_52 = -1;       /* T_modeSpecificInfo_52 */
static int hf_rrc_fdd_85 = -1;                    /* T_fdd_84 */
static int hf_rrc_servingEDCH_RL_indicator = -1;  /* BOOLEAN */
static int hf_rrc_dl_dpchInfo = -1;               /* T_dl_dpchInfo */
static int hf_rrc_dl_DPCH_InfoPerRL_03 = -1;      /* DL_DPCH_InfoPerRL_r6 */
static int hf_rrc_dl_FDPCH_InfoPerRL = -1;        /* DL_FDPCH_InfoPerRL_r6 */
static int hf_rrc_e_HICH_Info = -1;               /* T_e_HICH_Info */
static int hf_rrc_e_RGCH_Info_01 = -1;            /* T_e_RGCH_Info_01 */
static int hf_rrc_modeSpecificInfo_53 = -1;       /* T_modeSpecificInfo_53 */
static int hf_rrc_fdd_86 = -1;                    /* T_fdd_85 */
static int hf_rrc_dl_dpchInfo_01 = -1;            /* T_dl_dpchInfo_01 */
static int hf_rrc_dl_DPCH_InfoPerRL_04 = -1;      /* DL_DPCH_InfoPerRL_r7 */
static int hf_rrc_dl_FDPCH_InfoPerRL_01 = -1;     /* DL_FDPCH_InfoPerRL_r7 */
static int hf_rrc_e_AGCH_Information_01 = -1;     /* E_AGCH_Information_r7 */
static int hf_rrc_modeSpecificInfo2 = -1;         /* T_modeSpecificInfo2 */
static int hf_rrc_fdd_87 = -1;                    /* T_fdd_86 */
static int hf_rrc_e_HICH_Info_01 = -1;            /* T_e_HICH_Info_01 */
static int hf_rrc_e_RGCH_Info_02 = -1;            /* T_e_RGCH_Info_02 */
static int hf_rrc_tdd_48 = -1;                    /* T_tdd_45 */
static int hf_rrc_tdd384_tdd768 = -1;             /* T_tdd384_tdd768 */
static int hf_rrc_e_HICH_Info_02 = -1;            /* E_HICH_Information_TDD384_768 */
static int hf_rrc_tdd128_28 = -1;                 /* T_tdd128_28 */
static int hf_rrc_e_HICH_Info_03 = -1;            /* E_HICH_Information_TDD128 */
static int hf_rrc_modeSpecificInfo_54 = -1;       /* T_modeSpecificInfo_54 */
static int hf_rrc_fdd_88 = -1;                    /* T_fdd_87 */
static int hf_rrc_dl_dpchInfo_02 = -1;            /* T_dl_dpchInfo_02 */
static int hf_rrc_e_AGCH_Information_02 = -1;     /* E_AGCH_Information_r8 */
static int hf_rrc_modeSpecificInfo2_01 = -1;      /* T_modeSpecificInfo2_01 */
static int hf_rrc_fdd_89 = -1;                    /* T_fdd_88 */
static int hf_rrc_e_HICH_Info_04 = -1;            /* T_e_HICH_Info_02 */
static int hf_rrc_e_RGCH_Info_03 = -1;            /* T_e_RGCH_Info_03 */
static int hf_rrc_tdd_49 = -1;                    /* T_tdd_46 */
static int hf_rrc_tdd384_tdd768_01 = -1;          /* T_tdd384_tdd768_01 */
static int hf_rrc_tdd128_29 = -1;                 /* T_tdd128_29 */
static int hf_rrc_modeSpecificInfo_55 = -1;       /* T_modeSpecificInfo_55 */
static int hf_rrc_fdd_90 = -1;                    /* T_fdd_89 */
static int hf_rrc_dl_dpchInfo_03 = -1;            /* T_dl_dpchInfo_03 */
static int hf_rrc_e_ROCH_Information = -1;        /* E_ROCH_Information */
static int hf_rrc_modeSpecificInfo2_02 = -1;      /* T_modeSpecificInfo2_02 */
static int hf_rrc_fdd_91 = -1;                    /* T_fdd_90 */
static int hf_rrc_e_HICH_Info_05 = -1;            /* T_e_HICH_Info_03 */
static int hf_rrc_e_HICH_Information_01 = -1;     /* E_HICH_Information_r11 */
static int hf_rrc_secondaryReleaseIndicator = -1;  /* NULL */
static int hf_rrc_e_RGCH_Info_04 = -1;            /* T_e_RGCH_Info_04 */
static int hf_rrc_f_TPICH_Info = -1;              /* T_f_TPICH_Info */
static int hf_rrc_f_TPICH_Information = -1;       /* F_TPICH_Information */
static int hf_rrc_tdd_50 = -1;                    /* T_tdd_47 */
static int hf_rrc_tdd384_tdd768_02 = -1;          /* T_tdd384_tdd768_02 */
static int hf_rrc_tdd128_30 = -1;                 /* T_tdd128_30 */
static int hf_rrc_DL_InformationPerRL_List_item = -1;  /* DL_InformationPerRL */
static int hf_rrc_DL_InformationPerRL_List_r4_item = -1;  /* DL_InformationPerRL_r4 */
static int hf_rrc_DL_InformationPerRL_List_r5_item = -1;  /* DL_InformationPerRL_r5 */
static int hf_rrc_DL_InformationPerRL_List_r6_item = -1;  /* DL_InformationPerRL_r6 */
static int hf_rrc_DL_InformationPerRL_List_v6b0ext_item = -1;  /* DL_InformationPerRL_v6b0ext */
static int hf_rrc_DL_InformationPerRL_List_r5bis_item = -1;  /* DL_InformationPerRL_r5bis */
static int hf_rrc_DL_InformationPerRL_List_r7_item = -1;  /* DL_InformationPerRL_r7 */
static int hf_rrc_DL_InformationPerRL_List_r8_item = -1;  /* DL_InformationPerRL_r8 */
static int hf_rrc_DL_InformationPerRL_List_r11_item = -1;  /* DL_InformationPerRL_r11 */
static int hf_rrc_DL_InformationPerRL_ListPostFDD_item = -1;  /* DL_InformationPerRL_PostFDD */
static int hf_rrc_dl_DPCH_InfoPerRL_05 = -1;      /* DL_DPCH_InfoPerRL_PostFDD */
static int hf_rrc_primaryCCPCH_Info = -1;         /* PrimaryCCPCH_InfoPost */
static int hf_rrc_dl_DPCH_InfoPerRL_06 = -1;      /* DL_DPCH_InfoPerRL_PostTDD */
static int hf_rrc_primaryCCPCH_Info_01 = -1;      /* PrimaryCCPCH_InfoPostTDD_LCR_r4 */
static int hf_rrc_dl_DPCH_InfoPerRL_07 = -1;      /* DL_DPCH_InfoPerRL_PostTDD_LCR_r4 */
static int hf_rrc_tsn_Length = -1;                /* T_tsn_Length */
static int hf_rrc_multiCarrierNumber = -1;        /* INTEGER_1_maxTDD128Carrier */
static int hf_rrc_dl_HSPDSCH_MultiCarrier_Information = -1;  /* DL_HSPDSCH_MultiCarrier_Information */
static int hf_rrc_restrictedTrCH_InfoList = -1;   /* RestrictedTrCH_InfoList */
static int hf_rrc_newConfiguration_02 = -1;       /* T_newConfiguration_02 */
static int hf_rrc_dl_64QAM_Configured_04 = -1;    /* T_dl_64QAM_Configured_04 */
static int hf_rrc_dl_ScramblingCode = -1;         /* SecondaryScramblingCode */
static int hf_rrc_hS_SCCHChannelisationCodeInfo = -1;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_Codes */
static int hf_rrc_hS_SCCHChannelisationCodeInfo_item = -1;  /* HS_SCCH_Codes */
static int hf_rrc_measurementPowerOffset = -1;    /* MeasurementPowerOffset */
static int hf_rrc_uarfcn_DL = -1;                 /* UARFCN */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell = -1;  /* T_differentTxModeFromServingHS_DSCHCell */
static int hf_rrc_configurationInfo_01 = -1;      /* T_configurationInfo_01 */
static int hf_rrc_newConfiguration_03 = -1;       /* T_newConfiguration_03 */
static int hf_rrc_dl_64QAM_Configured_05 = -1;    /* T_dl_64QAM_Configured_05 */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell_01 = -1;  /* T_differentTxModeFromServingHS_DSCHCell_01 */
static int hf_rrc_secondaryCellMIMOparameters = -1;  /* SecondaryCellMIMOparametersFDD */
static int hf_rrc_configurationInfo_02 = -1;      /* T_configurationInfo_02 */
static int hf_rrc_newConfiguration_04 = -1;       /* T_newConfiguration_04 */
static int hf_rrc_dl_64QAM_Configured_06 = -1;    /* T_dl_64QAM_Configured_06 */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell_02 = -1;  /* T_differentTxModeFromServingHS_DSCHCell_02 */
static int hf_rrc_secondaryCellMIMOparameters_01 = -1;  /* SecondaryCellMIMOparametersFDD_r10 */
static int hf_rrc_configurationInfo_03 = -1;      /* T_configurationInfo_03 */
static int hf_rrc_newConfiguration_05 = -1;       /* T_newConfiguration_05 */
static int hf_rrc_dl_64QAM_Configured_07 = -1;    /* T_dl_64QAM_Configured_07 */
static int hf_rrc_measurementPowerOffset1 = -1;   /* MeasurementPowerOffset */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell_03 = -1;  /* T_differentTxModeFromServingHS_DSCHCell_03 */
static int hf_rrc_multiflowConfigurationInfo = -1;  /* MultiflowConfigurationInfo */
static int hf_rrc_secondaryCell4x4MIMOparameters = -1;  /* SecondaryCell4x4MIMOparametersFDD */
static int hf_rrc_DL_TPC_PowerOffsetPerRL_List_item = -1;  /* DL_TPC_PowerOffsetPerRL */
static int hf_rrc_codesRepresentation = -1;       /* T_codesRepresentation */
static int hf_rrc_consecutive = -1;               /* T_consecutive */
static int hf_rrc_firstChannelisationCode = -1;   /* DL_TS_ChannelisationCode */
static int hf_rrc_lastChannelisationCode = -1;    /* DL_TS_ChannelisationCode */
static int hf_rrc_bitmap = -1;                    /* T_bitmap */
static int hf_rrc_codesRepresentation_01 = -1;    /* T_codesRepresentation_01 */
static int hf_rrc_consecutive_01 = -1;            /* T_consecutive_01 */
static int hf_rrc_firstChannelisationCode_01 = -1;  /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_lastChannelisationCode_01 = -1;  /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_bitmap_01 = -1;                 /* T_bitmap_01 */
static int hf_rrc_firstChannelisationCode_02 = -1;  /* INTEGER_1_15 */
static int hf_rrc_lastChannelisationCode_02 = -1;  /* INTEGER_1_15 */
static int hf_rrc_parameters = -1;                /* T_parameters */
static int hf_rrc_sameAsLast = -1;                /* T_sameAsLast */
static int hf_rrc_timeslotNumber = -1;            /* TimeslotNumber */
static int hf_rrc_newParameters = -1;             /* T_newParameters */
static int hf_rrc_individualTimeslotInfo = -1;    /* IndividualTimeslotInfo */
static int hf_rrc_dl_TS_ChannelisationCodesShort = -1;  /* DL_TS_ChannelisationCodesShort */
static int hf_rrc_parameters_01 = -1;             /* T_parameters_01 */
static int hf_rrc_sameAsLast_01 = -1;             /* T_sameAsLast_01 */
static int hf_rrc_newParameters_01 = -1;          /* T_newParameters_01 */
static int hf_rrc_individualTimeslotInfo_01 = -1;  /* IndividualTimeslotInfo_VHCR */
static int hf_rrc_dl_TS_ChannelisationCodesShort_01 = -1;  /* DL_TS_ChannelisationCodesShort_VHCR */
static int hf_rrc_parameters_02 = -1;             /* T_parameters_02 */
static int hf_rrc_sameAsLast_02 = -1;             /* T_sameAsLast_02 */
static int hf_rrc_timeslotNumber_01 = -1;         /* TimeslotNumber_LCR_r4 */
static int hf_rrc_newParameters_02 = -1;          /* T_newParameters_02 */
static int hf_rrc_individualTimeslotInfo_02 = -1;  /* IndividualTimeslotInfo_LCR_r4 */
static int hf_rrc_parameters_03 = -1;             /* T_parameters_03 */
static int hf_rrc_sameAsLast_03 = -1;             /* T_sameAsLast_03 */
static int hf_rrc_newParameters_03 = -1;          /* T_newParameters_03 */
static int hf_rrc_individualTimeslotInfo_03 = -1;  /* IndividualTimeslotInfo_r7 */
static int hf_rrc_firstIndividualTimeslotInfo = -1;  /* IndividualTimeslotInfo */
static int hf_rrc_moreTimeslots = -1;             /* T_moreTimeslots */
static int hf_rrc_noMore = -1;                    /* NULL */
static int hf_rrc_additionalTimeslots = -1;       /* T_additionalTimeslots */
static int hf_rrc_consecutive_02 = -1;            /* INTEGER_1_maxTS_1 */
static int hf_rrc_timeslotList = -1;              /* SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots */
static int hf_rrc_timeslotList_item = -1;         /* DownlinkAdditionalTimeslots */
static int hf_rrc_firstIndividualTimeslotInfo_01 = -1;  /* IndividualTimeslotInfo_VHCR */
static int hf_rrc_moreTimeslots_01 = -1;          /* T_moreTimeslots_01 */
static int hf_rrc_additionalTimeslots_01 = -1;    /* T_additionalTimeslots_01 */
static int hf_rrc_timeslotList_01 = -1;           /* SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots_VHCR */
static int hf_rrc_timeslotList_item_01 = -1;      /* DownlinkAdditionalTimeslots_VHCR */
static int hf_rrc_firstIndividualTimeslotInfo_02 = -1;  /* IndividualTimeslotInfo_LCR_r4 */
static int hf_rrc_moreTimeslots_02 = -1;          /* T_moreTimeslots_02 */
static int hf_rrc_additionalTimeslots_02 = -1;    /* T_additionalTimeslots_02 */
static int hf_rrc_consecutive_03 = -1;            /* INTEGER_1_maxTS_LCR_1 */
static int hf_rrc_timeslotList_02 = -1;           /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_DownlinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_timeslotList_item_02 = -1;      /* DownlinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_firstIndividualTimeslotInfo_03 = -1;  /* IndividualTimeslotInfo_r7 */
static int hf_rrc_moreTimeslots_03 = -1;          /* T_moreTimeslots_03 */
static int hf_rrc_additionalTimeslots_03 = -1;    /* T_additionalTimeslots_03 */
static int hf_rrc_timeslotList_03 = -1;           /* SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots_r7 */
static int hf_rrc_timeslotList_item_03 = -1;      /* DownlinkAdditionalTimeslots_r7 */
static int hf_rrc_tgp_SequenceList = -1;          /* TGP_SequenceList */
static int hf_rrc_tgp_SequenceList_01 = -1;       /* TGP_SequenceList_r8 */
static int hf_rrc_tgp_SequenceList_02 = -1;       /* TGP_SequenceList_r10 */
static int hf_rrc_tgps_Reconfiguration_CFN = -1;  /* TGPS_Reconfiguration_CFN */
static int hf_rrc_tgp_SequenceShortList = -1;     /* SEQUENCE_SIZE_1_maxTGPS_OF_TGP_SequenceShort */
static int hf_rrc_tgp_SequenceShortList_item = -1;  /* TGP_SequenceShort */
static int hf_rrc_tgp_SequenceShortList_01 = -1;  /* SEQUENCE_SIZE_1_maxTGPS_OF_TGP_SequenceShort_r10 */
static int hf_rrc_tgp_SequenceShortList_item_01 = -1;  /* TGP_SequenceShort_r10 */
static int hf_rrc_ue_drx_Cycle = -1;              /* UE_DRX_Cycle */
static int hf_rrc_ue_drx_Cycle_InactivityThreshold = -1;  /* UE_DRX_Cycle_InactivityThreshold */
static int hf_rrc_ue_GrantMonitoring_InactivityThreshold = -1;  /* UE_GrantMonitoring_InactivityThreshold */
static int hf_rrc_ue_drx_GrantMonitoring = -1;    /* BOOLEAN */
static int hf_rrc_maxTFCI_Field2Value = -1;       /* MaxTFCI_Field2Value */
static int hf_rrc_spreadingFactor = -1;           /* SF_PDSCH */
static int hf_rrc_codeNumber = -1;                /* CodeNumberDSCH */
static int hf_rrc_multiCodeInfo = -1;             /* MultiCodeInfo */
static int hf_rrc_DSCH_MappingList_item = -1;     /* DSCH_Mapping */
static int hf_rrc_DSCH_TransportChannelsInfo_item = -1;  /* DSCH_TransportChannelsInfo_item */
static int hf_rrc_dsch_transport_channel_identity = -1;  /* TransportChannelIdentity */
static int hf_rrc_dsch_TFS = -1;                  /* TransportFormatSet */
static int hf_rrc_dtx_Info = -1;                  /* DTX_Info */
static int hf_rrc_drx_Info = -1;                  /* DRX_Info */
static int hf_rrc_uplink_DPCCHSlotFormatInformation = -1;  /* Uplink_DPCCH_Slot_Format_Information */
static int hf_rrc_ue_dtx_Cycle1_10ms = -1;        /* UE_DTX_Cycle1_10ms */
static int hf_rrc_ue_dtx_Cycle2_10ms = -1;        /* UE_DTX_Cycle2_10ms */
static int hf_rrc_mac_dtx_Cycle_10ms = -1;        /* MAC_DTX_Cycle_10ms */
static int hf_rrc_ue_dtx_Cycle1_2ms = -1;         /* UE_DTX_Cycle1_2ms */
static int hf_rrc_ue_dtx_Cycle2_2ms = -1;         /* UE_DTX_Cycle2_2ms */
static int hf_rrc_mac_dtx_Cycle_2ms = -1;         /* MAC_DTX_Cycle_2ms */
static int hf_rrc_e_dch_TTI_Length = -1;          /* T_e_dch_TTI_Length */
static int hf_rrc_dtx_e_dch_TTI_10ms = -1;        /* DTX_E_DCH_TTI_10ms */
static int hf_rrc_dtx_e_dch_TTI_2ms = -1;         /* DTX_E_DCH_TTI_2ms */
static int hf_rrc_ue_dtx_cycle2InactivityThreshold = -1;  /* UE_DTX_Cycle2InactivityThreshold */
static int hf_rrc_ue_dtx_cycle2DefaultSG = -1;    /* INTEGER_0_38 */
static int hf_rrc_ue_dtx_long_preamble_length = -1;  /* UE_DTX_long_preamble_length */
static int hf_rrc_mac_InactivityThreshold = -1;   /* MAC_InactivityThreshold */
static int hf_rrc_cqi_dtx_Timer = -1;             /* CQI_DTX_Timer */
static int hf_rrc_ue_dpcch_Burst1 = -1;           /* UE_DPCCH_Burst */
static int hf_rrc_ue_dpcch_Burst2 = -1;           /* UE_DPCCH_Burst */
static int hf_rrc_DynamicPersistenceLevelList_item = -1;  /* DynamicPersistenceLevel */
static int hf_rrc_DynamicPersistenceLevelTF_List_item = -1;  /* DynamicPersistenceLevel */
static int hf_rrc_e_AGCH_DRX_InfoType = -1;       /* T_e_AGCH_DRX_InfoType */
static int hf_rrc_sameAsHS_SCCH = -1;             /* NULL */
static int hf_rrc_e_AGCH_DRX_Parameters = -1;     /* T_e_AGCH_DRX_Parameters */
static int hf_rrc_e_AGCH_DRX_Cycle = -1;          /* ControlChannelDRXCycle_TDD128 */
static int hf_rrc_e_AGCH_InactivityMonitorThreshold = -1;  /* E_AGCH_InactivityMonitorThreshold_TDD128 */
static int hf_rrc_e_AGCH_DRX_Offset = -1;         /* INTEGER_0_63 */
static int hf_rrc_tS_number = -1;                 /* INTEGER_0_14 */
static int hf_rrc_channelisation_code = -1;       /* DL_TS_ChannelisationCode */
static int hf_rrc_midambleShiftAndBurstType_02 = -1;  /* MidambleShiftAndBurstType_EDCH */
static int hf_rrc_channelisation_code_01 = -1;    /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_firstChannelisationCode_03 = -1;  /* HS_ChannelisationCode_LCR */
static int hf_rrc_secondChannelisationCode = -1;  /* HS_ChannelisationCode_LCR */
static int hf_rrc_midambleAllocationMode = -1;    /* T_midambleAllocationMode */
static int hf_rrc_defaultMidamble = -1;           /* NULL */
static int hf_rrc_commonMidamble = -1;            /* NULL */
static int hf_rrc_ueSpecificMidamble = -1;        /* INTEGER_0_15 */
static int hf_rrc_midambleConfiguration = -1;     /* INTEGER_1_8 */
static int hf_rrc_e_AGCH_ChannelisationCode = -1;  /* E_AGCH_ChannelisationCode */
static int hf_rrc_modeSpecific_02 = -1;           /* T_modeSpecific_02 */
static int hf_rrc_fdd_92 = -1;                    /* T_fdd_91 */
static int hf_rrc_tdd_51 = -1;                    /* T_tdd_48 */
static int hf_rrc_tdd384_20 = -1;                 /* T_tdd384_19 */
static int hf_rrc_long_Term_Grant_Indicator = -1;  /* BOOLEAN */
static int hf_rrc_length_of_TTRI_field = -1;      /* INTEGER_1_12 */
static int hf_rrc_e_AGCH_Set_Config = -1;         /* E_AGCH_Set_Config */
static int hf_rrc_e_AGCH_BLER_Target = -1;        /* Bler_Target */
static int hf_rrc_tdd768_12 = -1;                 /* T_tdd768_11 */
static int hf_rrc_e_AGCH_Set_Config_01 = -1;      /* E_AGCH_Set_Config_VHCR */
static int hf_rrc_tdd128_31 = -1;                 /* T_tdd128_31 */
static int hf_rrc_rdi_Indicator = -1;             /* BOOLEAN */
static int hf_rrc_tpc_StepSize = -1;              /* TPC_StepSizeTDD */
static int hf_rrc_e_AGCH_Set_Config_02 = -1;      /* E_AGCH_Set_Config_LCR */
static int hf_rrc_modeSpecific_03 = -1;           /* T_modeSpecific_03 */
static int hf_rrc_fdd_93 = -1;                    /* T_fdd_92 */
static int hf_rrc_tdd_52 = -1;                    /* T_tdd_49 */
static int hf_rrc_tdd384_21 = -1;                 /* T_tdd384_20 */
static int hf_rrc_tdd768_13 = -1;                 /* T_tdd768_12 */
static int hf_rrc_tdd128_32 = -1;                 /* T_tdd128_32 */
static int hf_rrc_E_AGCH_Set_Config_item = -1;    /* E_AGCH_Individual */
static int hf_rrc_E_AGCH_Set_Config_VHCR_item = -1;  /* E_AGCH_Individual_VHCR */
static int hf_rrc_E_AGCH_Set_Config_LCR_item = -1;  /* E_AGCH_Individual_LCR */
static int hf_rrc_e_ROCH_ChannelisationCode = -1;  /* E_ROCH_ChannelisationCode */
static int hf_rrc_e_roch_e_rnti = -1;             /* E_RNTI */
static int hf_rrc_e_DCH_RL_InfoNewServingCell = -1;  /* E_DCH_RL_InfoNewServingCell */
static int hf_rrc_e_DCH_RL_InfoOtherCellList = -1;  /* SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_item = -1;  /* E_DCH_RL_InfoOtherCell */
static int hf_rrc_e_DCH_RL_InfoNewServingCell_01 = -1;  /* E_DCH_RL_InfoNewServingCell_r7 */
static int hf_rrc_e_DCH_RL_InfoNewServingCell_02 = -1;  /* E_DCH_RL_InfoNewServingCell_r11 */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_01 = -1;  /* SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell_r11 */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_item_01 = -1;  /* E_DCH_RL_InfoOtherCell_r11 */
static int hf_rrc_e_DCH_RL_InfoNewSecServingCell = -1;  /* E_DCH_RL_InfoNewSecServingCell */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_SecULFreq = -1;  /* SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell_SecULFreq */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_SecULFreq_item = -1;  /* E_DCH_RL_InfoOtherCell_SecULFreq */
static int hf_rrc_servingGrant_01 = -1;           /* T_servingGrant_01 */
static int hf_rrc_value = -1;                     /* INTEGER_0_38 */
static int hf_rrc_primary_Secondary_GrantSelector_01 = -1;  /* T_primary_Secondary_GrantSelector_01 */
static int hf_rrc_reference_E_TFCIs = -1;         /* E_DPDCH_Reference_E_TFCIList */
static int hf_rrc_powerOffsetForSchedInfo = -1;   /* INTEGER_0_6 */
static int hf_rrc_threeIndexStepThreshold = -1;   /* INTEGER_0_37 */
static int hf_rrc_twoIndexStepThreshold = -1;     /* INTEGER_0_37 */
static int hf_rrc_e_RGCH_Info_05 = -1;            /* T_e_RGCH_Info_05 */
static int hf_rrc_servingGrant_02 = -1;           /* T_servingGrant_02 */
static int hf_rrc_primary_Secondary_GrantSelector_02 = -1;  /* T_primary_Secondary_GrantSelector_02 */
static int hf_rrc_reference_E_TFCIs_01 = -1;      /* E_DPDCH_Reference_E_TFCIList_r7 */
static int hf_rrc_e_RGCH_Info_06 = -1;            /* T_e_RGCH_Info_06 */
static int hf_rrc_servingGrant_03 = -1;           /* T_servingGrant_03 */
static int hf_rrc_primary_Secondary_GrantSelector_03 = -1;  /* T_primary_Secondary_GrantSelector_03 */
static int hf_rrc_e_RGCH_Info_07 = -1;            /* T_e_RGCH_Info_07 */
static int hf_rrc_e_RGCH_Info_08 = -1;            /* T_e_RGCH_Info_08 */
static int hf_rrc_e_HICH_Info_06 = -1;            /* T_e_HICH_Info_04 */
static int hf_rrc_e_RGCH_Info_09 = -1;            /* T_e_RGCH_Info_09 */
static int hf_rrc_e_HICH_Info_07 = -1;            /* T_e_HICH_Info_05 */
static int hf_rrc_e_RGCH_Info_10 = -1;            /* T_e_RGCH_Info_10 */
static int hf_rrc_e_RGCH_Info_11 = -1;            /* T_e_RGCH_Info_11 */
static int hf_rrc_e_dch_SPS_Operation = -1;       /* T_e_dch_SPS_Operation */
static int hf_rrc_newOperation_01 = -1;           /* E_DCH_SPS_NewOperation_TDD128 */
static int hf_rrc_e_hich_Info_01 = -1;            /* E_HICH_Information_For_SPS_TDD128 */
static int hf_rrc_e_dch_TxPattern = -1;           /* E_DCH_TxPatternList_TDD128 */
static int hf_rrc_initialSPSInfoForEDCH = -1;     /* T_initialSPSInfoForEDCH */
static int hf_rrc_n_E_UCCH = -1;                  /* INTEGER_1_8 */
static int hf_rrc_codeResourceInfo = -1;          /* UL_TS_ChannelisationCode */
static int hf_rrc_timeslotResourceRelatedInfo = -1;  /* BIT_STRING_SIZE_5 */
static int hf_rrc_powerResourceRelatedInfo = -1;  /* INTEGER_1_32 */
static int hf_rrc_subframeNum = -1;               /* INTEGER_0_1 */
static int hf_rrc_initialTxPatternIndex = -1;     /* INTEGER_0_maxEDCHTxPattern_TDD128_1 */
static int hf_rrc_E_DCH_TxPatternList_TDD128_item = -1;  /* E_DCH_TxPatternList_TDD128_item */
static int hf_rrc_repetitionPeriodAndLength_01 = -1;  /* RepetitionPeriodAndLengthForSPS */
static int hf_rrc_happyBit_DelayCondition = -1;   /* HappyBit_DelayCondition */
static int hf_rrc_e_TFCI_TableIndex = -1;         /* E_TFCI_TableIndex */
static int hf_rrc_e_DCH_MinimumSet_E_TFCI = -1;   /* E_DCH_MinimumSet_E_TFCI */
static int hf_rrc_maxChannelisationCodes = -1;    /* E_DPDCH_MaxChannelisationCodes */
static int hf_rrc_pl_NonMax = -1;                 /* E_DPDCH_PL_NonMax */
static int hf_rrc_schedulingInfoConfiguration = -1;  /* E_DPDCH_SchedulingInfoConfiguration */
static int hf_rrc_reference_E_TFCI = -1;          /* INTEGER_0_127 */
static int hf_rrc_reference_E_TFCI_PO = -1;       /* INTEGER_0_29 */
static int hf_rrc_reference_E_TFCI_PO_r7 = -1;    /* INTEGER_0_31 */
static int hf_rrc_E_DPDCH_Reference_E_TFCIList_item = -1;  /* E_DPDCH_Reference_E_TFCI */
static int hf_rrc_E_DPDCH_Reference_E_TFCIList_r7_item = -1;  /* E_DPDCH_Reference_E_TFCI_r7 */
static int hf_rrc_periodicityOfSchedInfo_NoGrant = -1;  /* E_DPDCH_PeriodicyOfSchedInfo */
static int hf_rrc_periodicityOfSchedInfo_Grant = -1;  /* E_DPDCH_PeriodicyOfSchedInfo */
static int hf_rrc_servingGrant_04 = -1;           /* T_servingGrant_04 */
static int hf_rrc_primary_Secondary_GrantSelector_04 = -1;  /* T_primary_Secondary_GrantSelector_04 */
static int hf_rrc_channelisationCode_02 = -1;     /* E_HICH_ChannelisationCode */
static int hf_rrc_signatureSequence_01 = -1;      /* E_HICH_RGCH_SignatureSequence */
static int hf_rrc_secondarySignatureSequence = -1;  /* E_HICH_RGCH_SignatureSequence */
static int hf_rrc_n_E_HICH = -1;                  /* INTEGER_4_44 */
static int hf_rrc_tS_Number = -1;                 /* INTEGER_0_14 */
static int hf_rrc_modeSpecificInfo_56 = -1;       /* T_modeSpecificInfo_56 */
static int hf_rrc_tdd384_22 = -1;                 /* DL_TS_ChannelisationCode */
static int hf_rrc_tdd768_14 = -1;                 /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_burst_Type = -1;                /* T_burst_Type */
static int hf_rrc_midamble_Allocation_Mode = -1;  /* T_midamble_Allocation_Mode */
static int hf_rrc_ei = -1;                        /* INTEGER_0_3 */
static int hf_rrc_channelisation_Code = -1;       /* HS_ChannelisationCode_LCR */
static int hf_rrc_midambleAllocationMode_01 = -1;  /* T_midambleAllocationMode_01 */
static int hf_rrc_n_E_HICH_01 = -1;               /* INTEGER_4_15 */
static int hf_rrc_e_HICH_InfoList = -1;           /* E_HICH_Information_LCR_List */
static int hf_rrc_E_HICH_Information_LCR_List_item = -1;  /* E_HICH_Information_LCR */
static int hf_rrc_configurationmode = -1;         /* T_configurationmode */
static int hf_rrc_implicit_01 = -1;               /* T_implicit */
static int hf_rrc_explicit_03 = -1;               /* T_explicit_02 */
static int hf_rrc_midambleAllocationMode_02 = -1;  /* T_midambleAllocationMode_02 */
static int hf_rrc_signatureSequenceGroupIndex = -1;  /* INTEGER_0_19 */
static int hf_rrc_e_TFCS_Info = -1;               /* E_TFCS_Info */
static int hf_rrc_modeSpecificInfo_57 = -1;       /* T_modeSpecificInfo_57 */
static int hf_rrc_tdd348_tdd768 = -1;             /* T_tdd348_tdd768 */
static int hf_rrc_noSlotsForTFCIandTPC = -1;      /* INTEGER_1_12 */
static int hf_rrc_e_PUCH_ContantValue = -1;       /* INTEGER_M35_10 */
static int hf_rrc_e_PUCH_TS_ConfigurationList = -1;  /* SEQUENCE_SIZE_1_maxTS_2_OF_E_PUCH_TS_Slots */
static int hf_rrc_e_PUCH_TS_ConfigurationList_item = -1;  /* E_PUCH_TS_Slots */
static int hf_rrc_e_PUCH_CodeHopping = -1;        /* BOOLEAN */
static int hf_rrc_e_PUCH_TPC_Step_Size = -1;      /* INTEGER_1_3 */
static int hf_rrc_minimum_Allowed_Code_Rate = -1;  /* INTEGER_0_63 */
static int hf_rrc_maximum_Allowed_Code_Rate = -1;  /* INTEGER_0_63 */
static int hf_rrc_tdd128_33 = -1;                 /* T_tdd128_33 */
static int hf_rrc_snpl_ReportType = -1;           /* T_snpl_ReportType */
static int hf_rrc_prxdes_base = -1;               /* INTEGER_M112_M50 */
static int hf_rrc_beaconPLEst_01 = -1;            /* BOOLEAN */
static int hf_rrc_pebase_PowerControlGAP = -1;    /* PowerControlGAP */
static int hf_rrc_e_PUCH_TS_ConfigurationList_01 = -1;  /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_E_PUCH_TS_Slots_LCR */
static int hf_rrc_e_PUCH_TS_ConfigurationList_item_01 = -1;  /* E_PUCH_TS_Slots_LCR */
static int hf_rrc_maximumNumOfRetransSchedInfo = -1;  /* INTEGER_0_15 */
static int hf_rrc_retransTimerForSchedInfo = -1;  /* T_retransTimerForSchedInfo */
static int hf_rrc_snpl_ReportType_01 = -1;        /* T_snpl_ReportType_01 */
static int hf_rrc_pebase_PowerControlGAP_01 = -1;  /* INTEGER_1_255 */
static int hf_rrc_retransTimerForSchedInfo_01 = -1;  /* T_retransTimerForSchedInfo_01 */
static int hf_rrc_dummy_46 = -1;                  /* INTEGER_0_6 */
static int hf_rrc_ts_Number = -1;                 /* INTEGER_0_14 */
static int hf_rrc_midambleAllocationMode_03 = -1;  /* T_midambleAllocationMode_03 */
static int hf_rrc_rg_CombinationIndex = -1;       /* E_RGCH_CombinationIndex */
static int hf_rrc_modeSpecificInfo_58 = -1;       /* T_modeSpecificInfo_58 */
static int hf_rrc_tdd384_tdd768_03 = -1;          /* T_tdd384_tdd768_03 */
static int hf_rrc_e_RUCCH_ConstantValue = -1;     /* INTEGER_M35_10 */
static int hf_rrc_e_RUCCH_PersistenceScalingFactor = -1;  /* PersistenceScalingFactor */
static int hf_rrc_t_RUCCH = -1;                   /* T_t_RUCCH */
static int hf_rrc_e_RUCCH_TS_Number = -1;         /* INTEGER_0_14 */
static int hf_rrc_e_RUCCH_Midamble = -1;          /* T_e_RUCCH_Midamble */
static int hf_rrc_t_adv = -1;                     /* T_t_adv */
static int hf_rrc_t_SCHED = -1;                   /* T_t_SCHED */
static int hf_rrc_modeSpecificInfo_59 = -1;       /* T_modeSpecificInfo_59 */
static int hf_rrc_tdd384_23 = -1;                 /* T_tdd384_21 */
static int hf_rrc_sF16 = -1;                      /* SEQUENCE_SIZE_1_8_OF_SF16Codes */
static int hf_rrc_sF16_item = -1;                 /* SF16Codes */
static int hf_rrc_sF8 = -1;                       /* SEQUENCE_SIZE_1_8_OF_SF8Codes */
static int hf_rrc_sF8_item = -1;                  /* SF8Codes */
static int hf_rrc_tdd768_15 = -1;                 /* T_tdd768_13 */
static int hf_rrc_sF32 = -1;                      /* SEQUENCE_SIZE_1_16_OF_SF32Codes */
static int hf_rrc_sF32_item = -1;                 /* SF32Codes */
static int hf_rrc_sF816 = -1;                     /* SEQUENCE_SIZE_1_16_OF_SF16Codes2 */
static int hf_rrc_sF816_item = -1;                /* SF16Codes2 */
static int hf_rrc_tdd128_34 = -1;                 /* T_tdd128_34 */
static int hf_rrc_t_RUCCH_01 = -1;                /* T_t_RUCCH_01 */
static int hf_rrc_n_RUCCH = -1;                   /* INTEGER_0_7 */
static int hf_rrc_t_WAIT = -1;                    /* T_t_WAIT */
static int hf_rrc_t_SI = -1;                      /* T_t_SI */
static int hf_rrc_extendedEstimationWindow = -1;  /* INTEGER_2_5 */
static int hf_rrc_e_RUCCH_AccessServiceClass = -1;  /* E_RUCCH_AccessServiceClass */
static int hf_rrc_e_RUCCH_PersistenceScalingFactor_01 = -1;  /* PersistenceScalingFactorList */
static int hf_rrc_sync_UL_InfoForE_RUCCH = -1;    /* SYNC_UL_InfoForE_RUCCH */
static int hf_rrc_prach_information = -1;         /* PRACH_Information_LCR_List */
static int hf_rrc_t_RUCCH_02 = -1;                /* T_t_RUCCH_02 */
static int hf_rrc_t_WAIT_01 = -1;                 /* T_t_WAIT_01 */
static int hf_rrc_t_SI_01 = -1;                   /* T_t_SI_01 */
static int hf_rrc_e_TFCI_Boost = -1;              /* INTEGER_0_127 */
static int hf_rrc_delta_T2TP = -1;                /* INTEGER_0_6 */
static int hf_rrc_reference_Beta_QPSK_List = -1;  /* SEQUENCE_SIZE_1_8_OF_Reference_Beta_QPSK */
static int hf_rrc_reference_Beta_QPSK_List_item = -1;  /* Reference_Beta_QPSK */
static int hf_rrc_reference_Beta_16QAM_List = -1;  /* SEQUENCE_SIZE_1_8_OF_Reference_Beta_16QAM */
static int hf_rrc_reference_Beta_16QAM_List_item = -1;  /* Reference_Beta_16QAM */
static int hf_rrc_earfcnExt = -1;                 /* EARFCNExtension */
static int hf_rrc_modeSpecificInfo_60 = -1;       /* T_modeSpecificInfo_60 */
static int hf_rrc_tdd384_24 = -1;                 /* T_tdd384_22 */
static int hf_rrc_ex_ul_TimingAdvance = -1;       /* INTEGER_0_255 */
static int hf_rrc_tdd768_16 = -1;                 /* T_tdd768_14 */
static int hf_rrc_ex_ul_TimingAdvance_01 = -1;    /* INTEGER_0_511 */
static int hf_rrc_ctch_Indicator = -1;            /* BOOLEAN */
static int hf_rrc_FACH_PCH_InformationList_item = -1;  /* FACH_PCH_Information */
static int hf_rrc_cCCH_Fallback = -1;             /* BOOLEAN */
static int hf_rrc_dCCH_Fallback = -1;             /* BOOLEAN */
static int hf_rrc_timeslot_01 = -1;               /* TimeslotNumber_LCR_r4 */
static int hf_rrc_channelisationCode_03 = -1;     /* TDD_FPACH_CCode16_r4 */
static int hf_rrc_midambleShiftAndBurstType_03 = -1;  /* MidambleShiftAndBurstType_LCR_r4 */
static int hf_rrc_wi = -1;                        /* Wi_LCR */
static int hf_rrc_f_tpich_Information = -1;       /* F_TPICH_Information */
static int hf_rrc_f_tpich_Info = -1;              /* T_f_tpich_Info */
static int hf_rrc_ftpich_SlotFormat = -1;         /* FTPICH_SlotFormat */
static int hf_rrc_ftpich_CodeNumber = -1;         /* INTEGER_0_255 */
static int hf_rrc_ftpich_FrameOffset = -1;        /* FTPICH_FrameOffset */
static int hf_rrc_f_tpich_InfoNewServingCell = -1;  /* F_TPICH_InfoNewServingCell */
static int hf_rrc_f_tpich_InfoOtherCellList = -1;  /* SEQUENCE_SIZE_1_maxRL_OF_F_TPICH_InfoOtherCell */
static int hf_rrc_f_tpich_InfoOtherCellList_item = -1;  /* F_TPICH_InfoOtherCell */
static int hf_rrc_FreqIndexListForEnhancedMeas_item = -1;  /* FrequencyIndexForEnhancedMeas */
static int hf_rrc_modeSpecificInfo_61 = -1;       /* T_modeSpecificInfo_61 */
static int hf_rrc_fdd_94 = -1;                    /* FrequencyInfoFDD */
static int hf_rrc_tdd_53 = -1;                    /* FrequencyInfoTDD */
static int hf_rrc_uarfcn_UL = -1;                 /* UARFCN */
static int hf_rrc_uarfcn_Nt = -1;                 /* UARFCN */
static int hf_rrc_startCode = -1;                 /* HS_ChannelisationCode_LCR */
static int hf_rrc_stopCode = -1;                  /* HS_ChannelisationCode_LCR */
static int hf_rrc_ccch_MappingInfo = -1;          /* CommonRBMappingInfo */
static int hf_rrc_srb1_MappingInfo = -1;          /* CommonRBMappingInfo */
static int hf_rrc_common_MAC_ehs_ReorderingQueueList = -1;  /* Common_MAC_ehs_ReorderingQueueList */
static int hf_rrc_hs_scch_SystemInfo = -1;        /* HS_SCCH_SystemInfo */
static int hf_rrc_harq_SystemInfo = -1;           /* HARQ_Info */
static int hf_rrc_common_H_RNTI_information = -1;  /* SEQUENCE_SIZE_1_maxCommonHRNTI_OF_H_RNTI */
static int hf_rrc_common_H_RNTI_information_item = -1;  /* H_RNTI */
static int hf_rrc_bcchSpecific_H_RNTI = -1;       /* H_RNTI */
static int hf_rrc_hs_scch_SystemInfo_tdd128 = -1;  /* HS_SCCH_SystemInfo_TDD128 */
static int hf_rrc_hs_pdsch_MidambleConfiguration = -1;  /* HS_PDSCH_Midamble_Configuration_TDD128 */
static int hf_rrc_t_321 = -1;                     /* T_321 */
static int hf_rrc_hs_dsch_DrxCycleFach = -1;      /* HS_DSCH_DrxCycleFach */
static int hf_rrc_hs_dsch_DrxBurstFach = -1;      /* HS_DSCH_DrxBurstFach */
static int hf_rrc_drxInterruption_hs_dsch = -1;   /* BOOLEAN */
static int hf_rrc_hs_dsch_SecondDrx_CycleFach = -1;  /* HS_DSCH_SecondDrx_CycleFach */
static int hf_rrc_drx_level = -1;                 /* T_drx_level */
static int hf_rrc_one_level_DRX = -1;             /* T_one_level_DRX */
static int hf_rrc_hs_dsch_Second_Rx_BurstFach = -1;  /* HS_DSCH_Second_Rx_BurstFach */
static int hf_rrc_t329 = -1;                      /* T_329 */
static int hf_rrc_two_level_DRX = -1;             /* T_two_level_DRX */
static int hf_rrc_t328 = -1;                      /* T_328 */
static int hf_rrc_hs_dsch_First_Rx_BurstFach = -1;  /* HS_DSCH_First_Rx_BurstFach */
static int hf_rrc_hs_dsch_First_Drx_CycleFach = -1;  /* HS_DSCH_First_Drx_CycleFach */
static int hf_rrc_dlScramblingCode = -1;          /* SecondaryScramblingCode */
static int hf_rrc_pich_ForHSDPASupportedPagingList = -1;  /* SEQUENCE_SIZE_1_maxSCCPCH_OF_PICH_ForHSDPASupportedPaging */
static int hf_rrc_pich_ForHSDPASupportedPagingList_item = -1;  /* PICH_ForHSDPASupportedPaging */
static int hf_rrc_numberOfPcchTransmissions = -1;  /* INTEGER_1_5 */
static int hf_rrc_transportBlockSizeList = -1;    /* SEQUENCE_SIZE_1_2_OF_TransportBlockSizeIndex */
static int hf_rrc_transportBlockSizeList_item = -1;  /* TransportBlockSizeIndex */
static int hf_rrc_pich_ForHsdschList = -1;        /* SEQUENCE_SIZE_1_maxSCCPCH_OF_PICH_ForHSDPASupportedPaging_TDD128 */
static int hf_rrc_pich_ForHsdschList_item = -1;   /* PICH_ForHSDPASupportedPaging_TDD128 */
static int hf_rrc_dtch_DCCH_reception_window_size = -1;  /* INTEGER_1_16 */
static int hf_rrc_pcch_InformationList = -1;      /* PCCH_InformationList */
static int hf_rrc_HS_DSCH_RxPatternList_TDD128_item = -1;  /* HS_DSCH_RxPatternList_TDD128_item */
static int hf_rrc_HS_DSCH_TbsList_TDD128_item = -1;  /* HS_DSCH_TbsList_TDD128_item */
static int hf_rrc_hs_dsch_TBSizeIndex = -1;       /* INTEGER_1_63 */
static int hf_rrc_hs_dsch_SPS_Operation = -1;     /* T_hs_dsch_SPS_Operation */
static int hf_rrc_newOperation_02 = -1;           /* HS_DSCH_SPS_NewOperation_TDD128 */
static int hf_rrc_hs_dsch_TbsList = -1;           /* HS_DSCH_TbsList_TDD128 */
static int hf_rrc_hs_dsch_RxPatternList = -1;     /* HS_DSCH_RxPatternList_TDD128 */
static int hf_rrc_hARQInfoForSPS = -1;            /* T_hARQInfoForSPS */
static int hf_rrc_memorySize_01 = -1;             /* HARQMemorySize */
static int hf_rrc_hs_sich_List = -1;              /* HS_SICH_List_TDD128 */
static int hf_rrc_initialSPSInfoForHSDSCH = -1;   /* T_initialSPSInfoForHSDSCH */
static int hf_rrc_timeslotInfo = -1;              /* BIT_STRING_SIZE_5 */
static int hf_rrc_codeResourceInfo_01 = -1;       /* HS_ChannelisationCodeSetInfo_LCR */
static int hf_rrc_sfnNum = -1;                    /* INTEGER_0_1 */
static int hf_rrc_initialRxPatternIndex = -1;     /* INTEGER_0_maxRxPatternForHSDSCH_TDD128_1 */
static int hf_rrc_initialTfsIndex = -1;           /* INTEGER_0_maxTbsForHSDSCH_TDD128_1 */
static int hf_rrc_modulation = -1;                /* T_modulation */
static int hf_rrc_hs_sich_Index = -1;             /* INTEGER_0_maxHSSICH_TDD128_1 */
static int hf_rrc_midambleAllocationMode_04 = -1;  /* T_midambleAllocationMode_04 */
static int hf_rrc_modeSpecificInfo_62 = -1;       /* T_modeSpecificInfo_62 */
static int hf_rrc_fdd_95 = -1;                    /* T_fdd_93 */
static int hf_rrc_tdd_54 = -1;                    /* T_tdd_50 */
static int hf_rrc_tdd384_25 = -1;                 /* T_tdd384_23 */
static int hf_rrc_nack_ack_power_offset = -1;     /* INTEGER_M7_8 */
static int hf_rrc_hs_SICH_PowerControl_Info = -1;  /* HS_SICH_Power_Control_Info_TDD384 */
static int hf_rrc_hS_SCCH_SetConfiguration = -1;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD384 */
static int hf_rrc_hS_SCCH_SetConfiguration_item = -1;  /* HS_SCCH_TDD384 */
static int hf_rrc_tdd128_35 = -1;                 /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128 */
static int hf_rrc_tdd128_item = -1;               /* HS_SCCH_TDD128 */
static int hf_rrc_modeSpecificInfo_63 = -1;       /* T_modeSpecificInfo_63 */
static int hf_rrc_fdd_96 = -1;                    /* T_fdd_94 */
static int hf_rrc_tdd_55 = -1;                    /* T_tdd_51 */
static int hf_rrc_tdd384_26 = -1;                 /* T_tdd384_24 */
static int hf_rrc_bler_target = -1;               /* Bler_Target */
static int hf_rrc_hS_SCCH_SetConfiguration_01 = -1;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD384_r6 */
static int hf_rrc_hS_SCCH_SetConfiguration_item_01 = -1;  /* HS_SCCH_TDD384_r6 */
static int hf_rrc_tdd128_36 = -1;                 /* T_tdd128_35 */
static int hf_rrc_power_level_HSSICH = -1;        /* INTEGER_M120_M58 */
static int hf_rrc_tpc_step_size = -1;             /* T_tpc_step_size */
static int hf_rrc_hS_SCCH_SetConfiguration_02 = -1;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_r6 */
static int hf_rrc_hS_SCCH_SetConfiguration_item_02 = -1;  /* HS_SCCH_TDD128_r6 */
static int hf_rrc_modeSpecificInfo_64 = -1;       /* T_modeSpecificInfo_64 */
static int hf_rrc_fdd_97 = -1;                    /* T_fdd_95 */
static int hf_rrc_tdd_56 = -1;                    /* T_tdd_52 */
static int hf_rrc_tdd384_27 = -1;                 /* T_tdd384_25 */
static int hf_rrc_tdd768_17 = -1;                 /* T_tdd768_15 */
static int hf_rrc_hs_SICH_PowerControl_Info_01 = -1;  /* HS_SICH_Power_Control_Info_TDD768 */
static int hf_rrc_hS_SCCH_SetConfiguration_03 = -1;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD768 */
static int hf_rrc_hS_SCCH_SetConfiguration_item_03 = -1;  /* HS_SCCH_TDD768 */
static int hf_rrc_tdd128_37 = -1;                 /* T_tdd128_36 */
static int hf_rrc_tpc_step_size_01 = -1;          /* T_tpc_step_size_01 */
static int hf_rrc_powerControlGAP = -1;           /* PowerControlGAP */
static int hf_rrc_pathlossCompensationSwitch = -1;  /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_65 = -1;       /* T_modeSpecificInfo_65 */
static int hf_rrc_tdd_57 = -1;                    /* T_tdd_53 */
static int hf_rrc_tdd128_38 = -1;                 /* T_tdd128_37 */
static int hf_rrc_hS_SCCH_tpc_step_size = -1;     /* T_hS_SCCH_tpc_step_size */
static int hf_rrc_modeSpecificInfo_66 = -1;       /* T_modeSpecificInfo_66 */
static int hf_rrc_fdd_98 = -1;                    /* T_fdd_96 */
static int hf_rrc_tdd_58 = -1;                    /* T_tdd_54 */
static int hf_rrc_tdd384_28 = -1;                 /* T_tdd384_26 */
static int hf_rrc_tdd768_18 = -1;                 /* T_tdd768_16 */
static int hf_rrc_tdd128_39 = -1;                 /* T_tdd128_38 */
static int hf_rrc_tpc_step_size_02 = -1;          /* T_tpc_step_size_02 */
static int hf_rrc_hS_SCCH_tpc_step_size_01 = -1;  /* T_hS_SCCH_tpc_step_size_01 */
static int hf_rrc_hS_SCCH_DRX_Cycle = -1;         /* ControlChannelDRXCycle_TDD128 */
static int hf_rrc_hS_SCCH_DRX_InactivityThreshold = -1;  /* HS_SCCH_DRX_InactivityThreshold_TDD128 */
static int hf_rrc_hS_SCCH_DRX_Offset = -1;        /* INTEGER_0_63 */
static int hf_rrc_hs_pdsch_CodeIndex = -1;        /* INTEGER_1_15 */
static int hf_rrc_hs_scch_LessTFS = -1;           /* HS_SCCH_LessTFSList */
static int hf_rrc_hs_scchLessOperation = -1;      /* T_hs_scchLessOperation */
static int hf_rrc_newOperation_03 = -1;           /* HS_SCCH_Less_NewOperation */
static int hf_rrc_HS_SCCH_LessTFSList_item = -1;  /* HS_SCCH_LessTFSList_item */
static int hf_rrc_hs_scch_LessTFSI = -1;          /* INTEGER_1_90 */
static int hf_rrc_hs_scch_LessSecondCodeSupport = -1;  /* BOOLEAN */
static int hf_rrc_hs_SCCH_SetConfiguration = -1;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_r6 */
static int hf_rrc_hs_SCCH_SetConfiguration_item = -1;  /* HS_SCCH_TDD128_r6 */
static int hf_rrc_tpc_step_size_03 = -1;          /* T_tpc_step_size_03 */
static int hf_rrc_power_control_gap = -1;         /* INTEGER_1_255 */
static int hf_rrc_pathloss_compensation_switch = -1;  /* BOOLEAN */
static int hf_rrc_midambleAllocationMode_05 = -1;  /* T_midambleAllocationMode_05 */
static int hf_rrc_hs_sich_configuration = -1;     /* HS_SICH_Configuration_TDD128 */
static int hf_rrc_midambleAllocationMode_06 = -1;  /* T_midambleAllocationMode_06 */
static int hf_rrc_hs_sich_configuration_01 = -1;  /* HS_SICH_Configuration_TDD128_r6 */
static int hf_rrc_uarfcn_HS_SCCH_Rx = -1;         /* UARFCN */
static int hf_rrc_midambleAllocationMode_07 = -1;  /* T_midambleAllocationMode_07 */
static int hf_rrc_channelisationCode_04 = -1;     /* HS_ChannelisationCode_LCR */
static int hf_rrc_midambleAllocationMode_08 = -1;  /* T_midambleAllocationMode_08 */
static int hf_rrc_ueSpecificMidamble_01 = -1;     /* T_ueSpecificMidamble */
static int hf_rrc_tpc_step_size_04 = -1;          /* T_tpc_step_size_04 */
static int hf_rrc_midambleAllocationMode_09 = -1;  /* T_midambleAllocationMode_09 */
static int hf_rrc_ueSpecificMidamble_02 = -1;     /* T_ueSpecificMidamble_01 */
static int hf_rrc_HS_SICH_List_TDD128_item = -1;  /* HS_SICH_List_TDD128_item */
static int hf_rrc_implicit_02 = -1;               /* T_implicit_01 */
static int hf_rrc_hS_SCCH_Index = -1;             /* INTEGER_0_maxHSSCCHs_1 */
static int hf_rrc_explicit_04 = -1;               /* T_explicit_03 */
static int hf_rrc_hS_SICH_Info = -1;              /* HS_SICH_Configuration_TDD128_r6 */
static int hf_rrc_HS_SICH_ReferenceSignalInfoList_item = -1;  /* HS_SICH_ReferenceSignalInfoList_item */
static int hf_rrc_midambleShift_01 = -1;          /* INTEGER_0_15 */
static int hf_rrc_timeSlot = -1;                  /* INTEGER_1_5 */
static int hf_rrc_channelisationCode_05 = -1;     /* DL_TS_ChannelisationCode */
static int hf_rrc_midambleAllocationMode_10 = -1;  /* T_midambleAllocationMode_10 */
static int hf_rrc_ueSpecificMidamble_03 = -1;     /* T_ueSpecificMidamble_02 */
static int hf_rrc_midambleconfiguration = -1;     /* MidambleConfigurationBurstType1and3 */
static int hf_rrc_hs_sich_configuration_02 = -1;  /* HS_SICH_Configuration_TDD384 */
static int hf_rrc_midambleAllocationMode_11 = -1;  /* T_midambleAllocationMode_11 */
static int hf_rrc_ueSpecificMidamble_04 = -1;     /* T_ueSpecificMidamble_03 */
static int hf_rrc_channelisationCode_06 = -1;     /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_midambleAllocationMode_12 = -1;  /* T_midambleAllocationMode_12 */
static int hf_rrc_ueSpecificMidamble_05 = -1;     /* T_ueSpecificMidamble_04 */
static int hf_rrc_hs_sich_configuration_03 = -1;  /* HS_SICH_Configuration_TDD768 */
static int hf_rrc_midambleAllocationMode_13 = -1;  /* T_midambleAllocationMode_13 */
static int hf_rrc_ueSpecificMidamble_06 = -1;     /* T_ueSpecificMidamble_05 */
static int hf_rrc_midambleAllocationMode_14 = -1;  /* T_midambleAllocationMode_14 */
static int hf_rrc_ueSpecificMidamble_07 = -1;     /* T_ueSpecificMidamble_06 */
static int hf_rrc_ul_target_SIR = -1;             /* INTEGER_M22_40 */
static int hf_rrc_hs_sich_ConstantValue = -1;     /* ConstantValue */
static int hf_rrc_midambleShiftAndBurstType_04 = -1;  /* MidambleShiftAndBurstType */
static int hf_rrc_midambleShiftAndBurstType_VHCR = -1;  /* MidambleShiftAndBurstType_VHCR */
static int hf_rrc_modulation_01 = -1;             /* T_modulation_01 */
static int hf_rrc_ss_TPC_Symbols = -1;            /* T_ss_TPC_Symbols */
static int hf_rrc_additionalSS_TPC_Symbols = -1;  /* INTEGER_1_15 */
static int hf_rrc_modulation_02 = -1;             /* T_modulation_02 */
static int hf_rrc_ss_TPC_Symbols_01 = -1;         /* T_ss_TPC_Symbols_01 */
static int hf_rrc_midambleShiftAndBurstType_05 = -1;  /* MidambleShiftAndBurstType_r7 */
static int hf_rrc_ul_TimeslotInterference = -1;   /* TDD_UL_Interference */
static int hf_rrc_IndividualTS_InterferenceList_item = -1;  /* IndividualTS_Interference */
static int hf_rrc_modeSpecificInfo_67 = -1;       /* T_modeSpecificInfo_67 */
static int hf_rrc_fdd_99 = -1;                    /* T_fdd_97 */
static int hf_rrc_feedback_cycle = -1;            /* Feedback_cycle */
static int hf_rrc_cqi_RepetitionFactor = -1;      /* CQI_RepetitionFactor */
static int hf_rrc_deltaCQI = -1;                  /* DeltaCQI */
static int hf_rrc_modeSpecificInfo_68 = -1;       /* T_modeSpecificInfo_68 */
static int hf_rrc_fdd_100 = -1;                   /* T_fdd_98 */
static int hf_rrc_feedback_cycle_01 = -1;         /* Feedback_cycle_r7 */
static int hf_rrc_modeSpecificInfo_69 = -1;       /* T_modeSpecificInfo_69 */
static int hf_rrc_fdd_101 = -1;                   /* T_fdd_99 */
static int hf_rrc_cqi_RepetitionFactor_Assisting = -1;  /* CQI_RepetitionFactor */
static int hf_rrc_deltaCQI_01 = -1;               /* DeltaCQI_r11 */
static int hf_rrc_burstType_01 = -1;              /* T_burstType */
static int hf_rrc_type1_01 = -1;                  /* T_type1_01 */
static int hf_rrc_midambleConfigurationBurstType1and3 = -1;  /* MidambleConfigurationBurstType1and3 */
static int hf_rrc_midambleAllocationMode_15 = -1;  /* T_midambleAllocationMode_15 */
static int hf_rrc_ueSpecificMidamble_08 = -1;     /* T_ueSpecificMidamble_07 */
static int hf_rrc_type2 = -1;                     /* T_type2 */
static int hf_rrc_midambleConfigurationBurstType2 = -1;  /* MidambleConfigurationBurstType2 */
static int hf_rrc_midambleAllocationMode_16 = -1;  /* T_midambleAllocationMode_16 */
static int hf_rrc_ueSpecificMidamble_09 = -1;     /* T_ueSpecificMidamble_08 */
static int hf_rrc_midambleShift_02 = -1;          /* MidambleShiftShort */
static int hf_rrc_type3 = -1;                     /* T_type3 */
static int hf_rrc_midambleAllocationMode_17 = -1;  /* T_midambleAllocationMode_17 */
static int hf_rrc_ueSpecificMidamble_10 = -1;     /* T_ueSpecificMidamble_09 */
static int hf_rrc_burstType_02 = -1;              /* T_burstType_01 */
static int hf_rrc_type1_02 = -1;                  /* T_type1_02 */
static int hf_rrc_midambleAllocationMode_18 = -1;  /* T_midambleAllocationMode_18 */
static int hf_rrc_ueSpecificMidamble_11 = -1;     /* T_ueSpecificMidamble_10 */
static int hf_rrc_type2_01 = -1;                  /* T_type2_01 */
static int hf_rrc_midambleConfigurationBurstType2_01 = -1;  /* MidambleConfigurationBurstType2_VHCR */
static int hf_rrc_midambleAllocationMode_19 = -1;  /* T_midambleAllocationMode_19 */
static int hf_rrc_ueSpecificMidamble_12 = -1;     /* T_ueSpecificMidamble_11 */
static int hf_rrc_midambleShift_03 = -1;          /* MidambleShiftShort_VHCR */
static int hf_rrc_type3_01 = -1;                  /* T_type3_01 */
static int hf_rrc_midambleAllocationMode_20 = -1;  /* T_midambleAllocationMode_20 */
static int hf_rrc_ueSpecificMidamble_13 = -1;     /* T_ueSpecificMidamble_12 */
static int hf_rrc_mbsfnBurstType4 = -1;           /* NULL */
static int hf_rrc_burstType_03 = -1;              /* T_burstType_02 */
static int hf_rrc_type1_03 = -1;                  /* T_type1_03 */
static int hf_rrc_midambleAllocationMode_21 = -1;  /* T_midambleAllocationMode_21 */
static int hf_rrc_ueSpecificMidamble_14 = -1;     /* T_ueSpecificMidamble_13 */
static int hf_rrc_type2_02 = -1;                  /* T_type2_02 */
static int hf_rrc_midambleAllocationMode_22 = -1;  /* T_midambleAllocationMode_22 */
static int hf_rrc_ueSpecificMidamble_15 = -1;     /* T_ueSpecificMidamble_14 */
static int hf_rrc_type3_02 = -1;                  /* T_type3_02 */
static int hf_rrc_midambleAllocationMode_23 = -1;  /* T_midambleAllocationMode_23 */
static int hf_rrc_ueSpecificMidamble_16 = -1;     /* T_ueSpecificMidamble_15 */
static int hf_rrc_burstType_04 = -1;              /* T_burstType_03 */
static int hf_rrc_type1_04 = -1;                  /* T_type1_04 */
static int hf_rrc_midambleAllocationMode_24 = -1;  /* T_midambleAllocationMode_24 */
static int hf_rrc_ueSpecificMidamble_17 = -1;     /* T_ueSpecificMidamble_16 */
static int hf_rrc_type2_03 = -1;                  /* T_type2_03 */
static int hf_rrc_midambleAllocationMode_25 = -1;  /* T_midambleAllocationMode_25 */
static int hf_rrc_ueSpecificMidamble_18 = -1;     /* T_ueSpecificMidamble_17 */
static int hf_rrc_burstType_05 = -1;              /* T_burstType_04 */
static int hf_rrc_type1_05 = -1;                  /* T_type1_05 */
static int hf_rrc_midambleAllocationMode_26 = -1;  /* T_midambleAllocationMode_26 */
static int hf_rrc_ueSpecificMidamble_19 = -1;     /* T_ueSpecificMidamble_18 */
static int hf_rrc_type2_04 = -1;                  /* T_type2_04 */
static int hf_rrc_midambleAllocationMode_27 = -1;  /* T_midambleAllocationMode_27 */
static int hf_rrc_ueSpecificMidamble_20 = -1;     /* T_ueSpecificMidamble_19 */
static int hf_rrc_midambleAllocationMode_28 = -1;  /* T_midambleAllocationMode_28 */
static int hf_rrc_ueSpecificMidamble_21 = -1;     /* T_ueSpecificMidamble_20 */
static int hf_rrc_burstType_06 = -1;              /* T_burstType_05 */
static int hf_rrc_type1_06 = -1;                  /* T_type1_06 */
static int hf_rrc_midambleConfigurationBurstType1 = -1;  /* MidambleConfigurationBurstType1 */
static int hf_rrc_midambleAllocationMode_29 = -1;  /* T_midambleAllocationMode_29 */
static int hf_rrc_ueSpecificMidamble_22 = -1;     /* T_ueSpecificMidamble_21 */
static int hf_rrc_type2_05 = -1;                  /* T_type2_05 */
static int hf_rrc_midambleAllocationMode_30 = -1;  /* T_midambleAllocationMode_30 */
static int hf_rrc_ueSpecificMidamble_23 = -1;     /* T_ueSpecificMidamble_22 */
static int hf_rrc_mimoOperation = -1;             /* MIMO_Operation */
static int hf_rrc_mimoN_M_Ratio = -1;             /* MIMO_N_M_Ratio */
static int hf_rrc_mimoPilotConfiguration = -1;    /* MIMO_PilotConfiguration */
static int hf_rrc_configurationInfo_04 = -1;      /* T_configurationInfo_04 */
static int hf_rrc_newConfiguration_06 = -1;       /* T_newConfiguration_06 */
static int hf_rrc_mimo4x4N_M_Ratio = -1;          /* MIMO_N_M_Ratio */
static int hf_rrc_mimo4x4PilotConfiguration = -1;  /* MIMO4x4_PilotConfiguration */
static int hf_rrc_precodingWeightSetRestriction = -1;  /* BIT_STRING_SIZE_64 */
static int hf_rrc_precodingWeightSetRestriction_01 = -1;  /* T_precodingWeightSetRestriction */
static int hf_rrc_modeSpecificInfo_70 = -1;       /* T_modeSpecificInfo_70 */
static int hf_rrc_fdd_102 = -1;                   /* T_fdd_100 */
static int hf_rrc_tdd_59 = -1;                    /* T_tdd_55 */
static int hf_rrc_tdd128_40 = -1;                 /* T_tdd128_39 */
static int hf_rrc_mimoSFModeForHSPDSCHDualStream = -1;  /* T_mimoSFModeForHSPDSCHDualStream */
static int hf_rrc_hs_sich_ReferenceSignalInfoList = -1;  /* HS_SICH_ReferenceSignalInfoList */
static int hf_rrc_tdd384_tdd768_04 = -1;          /* NULL */
static int hf_rrc_modeSpecificInfo_71 = -1;       /* T_modeSpecificInfo_71 */
static int hf_rrc_fdd_103 = -1;                   /* T_fdd_101 */
static int hf_rrc_mimoPilotConfiguration_01 = -1;  /* MIMO_PilotConfiguration_r9 */
static int hf_rrc_precodingWeightSetRestriction_02 = -1;  /* T_precodingWeightSetRestriction_01 */
static int hf_rrc_tdd_60 = -1;                    /* T_tdd_56 */
static int hf_rrc_tdd128_41 = -1;                 /* T_tdd128_40 */
static int hf_rrc_mimoSFModeForHSPDSCHDualStream_01 = -1;  /* T_mimoSFModeForHSPDSCHDualStream_01 */
static int hf_rrc_secondCPICH_Pattern = -1;       /* T_secondCPICH_Pattern */
static int hf_rrc_normalPattern = -1;             /* NULL */
static int hf_rrc_diversityPattern = -1;          /* T_diversityPattern */
static int hf_rrc_s_cpich_PowerOffset_Mimo_01 = -1;  /* S_CPICH_PowerOffset_MIMO */
static int hf_rrc_secondCPICH_Pattern_01 = -1;    /* T_secondCPICH_Pattern_01 */
static int hf_rrc_diversityPattern_01 = -1;       /* T_diversityPattern_01 */
static int hf_rrc_antenna2 = -1;                  /* MIMO_PilotConfiguration_r9 */
static int hf_rrc_antenna3And4 = -1;              /* Antenna3And4 */
static int hf_rrc_secondFrequencyInfo = -1;       /* FrequencyInfoTDD */
static int hf_rrc_fPachFrequencyInfo = -1;        /* FrequencyInfoTDD */
static int hf_rrc_upPCHpositionInfo = -1;         /* UpPCHposition_LCR */
static int hf_rrc_cellType = -1;                  /* MultiflowCellType */
static int hf_rrc_timeReferenceCell = -1;         /* T_timeReferenceCell */
static int hf_rrc_newConfiguration_07 = -1;       /* T_newConfiguration_07 */
static int hf_rrc_mu_MIMO_Operation = -1;         /* MU_MIMO_Operation */
static int hf_rrc_standaloneMidambleInfo = -1;    /* StandaloneMidambleInfo_TDD128 */
static int hf_rrc_enablingDelay_01 = -1;          /* EnablingDelay */
static int hf_rrc_ue_dtx_drx_Offset = -1;         /* UE_DTX_DRX_Offset */
static int hf_rrc_hs_dpcch_TransmitContinuationOffset = -1;  /* T_hs_dpcch_TransmitContinuationOffset */
static int hf_rrc_tdd384_768 = -1;                /* T_tdd384_768 */
static int hf_rrc_timeslotResourceRelatedInfo_01 = -1;  /* BIT_STRING_SIZE_13 */
static int hf_rrc_tdd128_42 = -1;                 /* T_tdd128_41 */
static int hf_rrc_e_HICH_Info_08 = -1;            /* T_e_HICH_Info_06 */
static int hf_rrc_midambleAllocationMode_31 = -1;  /* T_midambleAllocationMode_31 */
static int hf_rrc_tdd384_768_01 = -1;             /* NULL */
static int hf_rrc_tdd128_43 = -1;                 /* T_tdd128_42 */
static int hf_rrc_t_SI_nst = -1;                  /* T_t_SI_nst */
static int hf_rrc_tdd384_768_02 = -1;             /* T_tdd384_768_01 */
static int hf_rrc_tdd128_44 = -1;                 /* T_tdd128_43 */
static int hf_rrc_e_HICH_Info_09 = -1;            /* T_e_HICH_Info_07 */
static int hf_rrc_midambleAllocationMode_32 = -1;  /* T_midambleAllocationMode_32 */
static int hf_rrc_t_SI_nst_01 = -1;               /* T_t_SI_nst_01 */
static int hf_rrc_dpch_ConstantValue = -1;        /* ConstantValueTdd */
static int hf_rrc_ipdl_alpha = -1;                /* Alpha */
static int hf_rrc_maxPowerIncrease = -1;          /* MaxPowerIncrease_r4 */
static int hf_rrc_paging_associatedHspdschInfo = -1;  /* T_paging_associatedHspdschInfo */
static int hf_rrc_paging_associatedHspdschInfo_item = -1;  /* T_paging_associatedHspdschInfo_item */
static int hf_rrc_timeslotResourceRelatedInfo_02 = -1;  /* BIT_STRING_SIZE_6 */
static int hf_rrc_codeResourceInformation = -1;   /* CodeResourceInformation_TDD128 */
static int hf_rrc_paging_sub_Channel_size = -1;   /* INTEGER_1_3 */
static int hf_rrc_pcpch_UL_ScramblingCode = -1;   /* INTEGER_0_79 */
static int hf_rrc_pcpch_DL_ChannelisationCode = -1;  /* INTEGER_0_511 */
static int hf_rrc_pcpch_DL_ScramblingCode = -1;   /* SecondaryScramblingCode */
static int hf_rrc_pcp_Length = -1;                /* PCP_Length */
static int hf_rrc_ucsm_Info = -1;                 /* UCSM_Info */
static int hf_rrc_PCPCH_ChannelInfoList_item = -1;  /* PCPCH_ChannelInfo */
static int hf_rrc_pdsch_PowerControlInfo = -1;    /* PDSCH_PowerControlInfo */
static int hf_rrc_pdsch_AllocationPeriodInfo = -1;  /* AllocationPeriodInfo */
static int hf_rrc_configuration = -1;             /* T_configuration */
static int hf_rrc_old_Configuration = -1;         /* T_old_Configuration */
static int hf_rrc_pdsch_Identity = -1;            /* PDSCH_Identity */
static int hf_rrc_new_Configuration = -1;         /* T_new_Configuration */
static int hf_rrc_pdsch_Info = -1;                /* PDSCH_Info */
static int hf_rrc_configuration_01 = -1;          /* T_configuration_01 */
static int hf_rrc_old_Configuration_01 = -1;      /* T_old_Configuration_01 */
static int hf_rrc_new_Configuration_01 = -1;      /* T_new_Configuration_01 */
static int hf_rrc_pdsch_Info_01 = -1;             /* PDSCH_Info_r4 */
static int hf_rrc_configuration_02 = -1;          /* T_configuration_02 */
static int hf_rrc_old_Configuration_02 = -1;      /* T_old_Configuration_02 */
static int hf_rrc_new_Configuration_02 = -1;      /* T_new_Configuration_02 */
static int hf_rrc_pdsch_Info_02 = -1;             /* PDSCH_Info_r7 */
static int hf_rrc_PDSCH_CodeInfoList_item = -1;   /* PDSCH_CodeInfo */
static int hf_rrc_codeNumberStart = -1;           /* CodeNumberDSCH */
static int hf_rrc_codeNumberStop = -1;            /* CodeNumberDSCH */
static int hf_rrc_PDSCH_CodeMapList_item = -1;    /* PDSCH_CodeMap */
static int hf_rrc_signallingMethod = -1;          /* T_signallingMethod */
static int hf_rrc_codeRange = -1;                 /* CodeRange */
static int hf_rrc_tfci_Range_01 = -1;             /* DSCH_MappingList */
static int hf_rrc_explicit_config_03 = -1;        /* PDSCH_CodeInfoList */
static int hf_rrc_replace = -1;                   /* ReplacedPDSCH_CodeInfoList */
static int hf_rrc_pdsch_TimeslotsCodes = -1;      /* DownlinkTimeslotsCodes */
static int hf_rrc_tddOption_12 = -1;              /* T_tddOption_12 */
static int hf_rrc_tdd384_29 = -1;                 /* T_tdd384_27 */
static int hf_rrc_tdd128_45 = -1;                 /* T_tdd128_44 */
static int hf_rrc_pdsch_TimeslotsCodes_01 = -1;   /* DownlinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_tddOption_13 = -1;              /* T_tddOption_13 */
static int hf_rrc_tdd384_30 = -1;                 /* T_tdd384_28 */
static int hf_rrc_tdd768_19 = -1;                 /* T_tdd768_17 */
static int hf_rrc_pdsch_TimeslotsCodes_02 = -1;   /* DownlinkTimeslotsCodes_VHCR */
static int hf_rrc_tdd128_46 = -1;                 /* T_tdd128_45 */
static int hf_rrc_dsch_RadioLinkIdentifier = -1;  /* DSCH_RadioLinkIdentifier */
static int hf_rrc_rl_IdentifierList = -1;         /* RL_IdentifierList */
static int hf_rrc_dsch_TFCS = -1;                 /* TFCS */
static int hf_rrc_dsch_TransportChannelsInfo = -1;  /* DSCH_TransportChannelsInfo */
static int hf_rrc_pdsch_Info_03 = -1;             /* PDSCH_Info_LCR_r4 */
static int hf_rrc_PDSCH_SysInfoList_item = -1;    /* PDSCH_SysInfo */
static int hf_rrc_PDSCH_SysInfoList_VHCR_r7_item = -1;  /* PDSCH_SysInfo_VHCR_r7 */
static int hf_rrc_PDSCH_SysInfoList_HCR_r5_item = -1;  /* PDSCH_SysInfo_HCR_r5 */
static int hf_rrc_PDSCH_SysInfoList_LCR_r4_item = -1;  /* PDSCH_SysInfo_LCR_r4 */
static int hf_rrc_PDSCH_SysInfoList_SFN_item = -1;  /* PDSCH_SysInfoList_SFN_item */
static int hf_rrc_pdsch_SysInfo = -1;             /* PDSCH_SysInfo */
static int hf_rrc_sfn_TimeInfo = -1;              /* SFN_TimeInfo */
static int hf_rrc_PDSCH_SysInfoList_SFN_HCR_r5_item = -1;  /* PDSCH_SysInfoList_SFN_HCR_r5_item */
static int hf_rrc_pdsch_SysInfo_01 = -1;          /* PDSCH_SysInfo_HCR_r5 */
static int hf_rrc_PDSCH_SysInfoList_SFN_LCR_r4_item = -1;  /* PDSCH_SysInfoList_SFN_LCR_r4_item */
static int hf_rrc_pdsch_SysInfo_02 = -1;          /* PDSCH_SysInfo_LCR_r4 */
static int hf_rrc_PersistenceScalingFactorList_item = -1;  /* PersistenceScalingFactor */
static int hf_rrc_PichChannelisationCodeList_LCR_r4_item = -1;  /* DL_TS_ChannelisationCode */
static int hf_rrc_hsdpa_AssociatedPichInfo = -1;  /* PICH_Info */
static int hf_rrc_hs_pdschChannelisationCode = -1;  /* INTEGER_1_15 */
static int hf_rrc_implicit_03 = -1;               /* T_implicit_02 */
static int hf_rrc_occurrenceSequenceNumberOfPICH = -1;  /* OccurrenceSequenceNumberOfPICH */
static int hf_rrc_explicit_05 = -1;               /* PICH_Info_LCR_r4 */
static int hf_rrc_fdd_104 = -1;                   /* T_fdd_102 */
static int hf_rrc_pi_CountPerFrame = -1;          /* PI_CountPerFrame */
static int hf_rrc_tdd_61 = -1;                    /* T_tdd_57 */
static int hf_rrc_channelisationCode_07 = -1;     /* TDD_PICH_CCode */
static int hf_rrc_repetitionPeriodLengthOffset = -1;  /* RepPerLengthOffset_PICH */
static int hf_rrc_pagingIndicatorLength = -1;     /* PagingIndicatorLength */
static int hf_rrc_n_GAP = -1;                     /* N_GAP */
static int hf_rrc_n_PCH = -1;                     /* N_PCH */
static int hf_rrc_channelisationCode_08 = -1;     /* T_channelisationCode */
static int hf_rrc_tdd384_31 = -1;                 /* TDD_PICH_CCode */
static int hf_rrc_tdd768_20 = -1;                 /* TDD768_PICH_CCode */
static int hf_rrc_pichChannelisationCodeList_LCR_r4 = -1;  /* PichChannelisationCodeList_LCR_r4 */
static int hf_rrc_plcchSequenceNumber = -1;       /* INTEGER_1_14 */
static int hf_rrc_tpcCommandTargetRate = -1;      /* TPC_CommandTargetRate */
static int hf_rrc_algorithm1 = -1;                /* TPC_StepSizeFDD */
static int hf_rrc_algorithm2 = -1;                /* NULL */
static int hf_rrc_PRACH_ChanCodes_LCR_r4_item = -1;  /* TDD_PRACH_CCode_LCR_r4 */
static int hf_rrc_PRACH_ChanCodes_List_LCR_item = -1;  /* TDD_PRACH_CCode_LCR_r4 */
static int hf_rrc_timeslot_02 = -1;               /* TimeslotNumber_PRACH_LCR_r4 */
static int hf_rrc_prach_ChanCodes_LCR = -1;       /* PRACH_ChanCodes_LCR_r4 */
static int hf_rrc_fpach_Info = -1;                /* FPACH_Info_r4 */
static int hf_rrc_prach_ChanCodes_list_LCR = -1;  /* PRACH_ChanCodes_List_LCR */
static int hf_rrc_PRACH_Information_LCR_List_item = -1;  /* PRACH_Information_LCR */
static int hf_rrc_fdd_105 = -1;                   /* SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_FDD */
static int hf_rrc_fdd_item = -1;                  /* ASCSetting_FDD */
static int hf_rrc_tdd_62 = -1;                    /* SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_TDD */
static int hf_rrc_tdd_item = -1;                  /* ASCSetting_TDD */
static int hf_rrc_tdd_63 = -1;                    /* SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_TDD_r7 */
static int hf_rrc_tdd_item_01 = -1;               /* ASCSetting_TDD_r7 */
static int hf_rrc_PRACH_Partitioning_LCR_r4_item = -1;  /* ASCSetting_TDD_LCR_r4 */
static int hf_rrc_powerRampStep = -1;             /* PowerRampStep */
static int hf_rrc_preambleRetransMax = -1;        /* PreambleRetransMax */
static int hf_rrc_availableSignatures = -1;       /* AvailableSignatures */
static int hf_rrc_e_ai_Indication = -1;           /* BOOLEAN */
static int hf_rrc_preambleScramblingCodeWordNumber = -1;  /* PreambleScramblingCodeWordNumber */
static int hf_rrc_availableSubChannelNumbers = -1;  /* AvailableSubChannelNumbers */
static int hf_rrc_prach_Partitioning = -1;        /* PRACH_Partitioning_r7 */
static int hf_rrc_persistenceScalingFactorList = -1;  /* PersistenceScalingFactorList */
static int hf_rrc_ac_To_ASC_MappingTable = -1;    /* AC_To_ASC_MappingTable */
static int hf_rrc_primaryCPICH_TX_Power = -1;     /* PrimaryCPICH_TX_Power */
static int hf_rrc_constantValue = -1;             /* ConstantValue */
static int hf_rrc_prach_PowerOffset = -1;         /* PRACH_PowerOffset */
static int hf_rrc_rach_TransmissionParameters = -1;  /* RACH_TransmissionParameters */
static int hf_rrc_aich_Info = -1;                 /* AICH_Info */
static int hf_rrc_powerOffsetPp_e = -1;           /* INTEGER_M5_10 */
static int hf_rrc_aich_Info_01 = -1;              /* AICH_Info_Compressed */
static int hf_rrc_PRACH_PreambleForEnhancedUplinkExtList_item = -1;  /* PRACH_PreambleForEnhancedUplinkExtWithWeight */
static int hf_rrc_prach_PreambleForEnhancedUplinkExt = -1;  /* PRACH_PreambleForEnhancedUplinkExt */
static int hf_rrc_weight = -1;                    /* INTEGER_1_5 */
static int hf_rrc_modeSpecificInfo_72 = -1;       /* T_modeSpecificInfo_72 */
static int hf_rrc_fdd_106 = -1;                   /* T_fdd_103 */
static int hf_rrc_availableSF = -1;               /* SF_PRACH */
static int hf_rrc_tdd_64 = -1;                    /* T_tdd_58 */
static int hf_rrc_channelisationCodeList = -1;    /* TDD_PRACH_CCodeList */
static int hf_rrc_prach_Midamble = -1;            /* PRACH_Midamble */
static int hf_rrc_channelisationCodeList_01 = -1;  /* TDD768_PRACH_CCodeList */
static int hf_rrc_e_RUCCH_Sync_UL_Codes_Bitmap = -1;  /* Sync_UL_Codes_Bitmap */
static int hf_rrc_sync_UL_Info = -1;              /* SYNC_UL_Info_r4 */
static int hf_rrc_prach_DefinitionList = -1;      /* SEQUENCE_SIZE_1_maxPRACH_FPACH_OF_PRACH_Definition_LCR_r4 */
static int hf_rrc_prach_DefinitionList_item = -1;  /* PRACH_Definition_LCR_r4 */
static int hf_rrc_prach_RACH_Info = -1;           /* PRACH_RACH_Info */
static int hf_rrc_rach_TransportFormatSet = -1;   /* TransportFormatSet */
static int hf_rrc_rach_TFCS = -1;                 /* TFCS */
static int hf_rrc_prach_Partitioning_01 = -1;     /* PRACH_Partitioning */
static int hf_rrc_modeSpecificInfo_73 = -1;       /* T_modeSpecificInfo_73 */
static int hf_rrc_fdd_107 = -1;                   /* T_fdd_104 */
static int hf_rrc_prach_RACH_Info_01 = -1;        /* PRACH_RACH_Info_VHCR_r7 */
static int hf_rrc_prach_RACH_Info_LCR = -1;       /* PRACH_RACH_Info_LCR_r4 */
static int hf_rrc_rach_TransportFormatSet_LCR = -1;  /* TransportFormatSet_LCR */
static int hf_rrc_prach_Partitioning_LCR = -1;    /* PRACH_Partitioning_LCR_r4 */
static int hf_rrc_prach_RACH_Info_LCR_01 = -1;    /* PRACH_RACH_Info_LCR_v770ext */
static int hf_rrc_PRACH_SystemInformationList_item = -1;  /* PRACH_SystemInformation */
static int hf_rrc_PRACH_SystemInformationList_VHCR_r7_item = -1;  /* PRACH_SystemInformation_VHCR_r7 */
static int hf_rrc_PRACH_SystemInformationList_LCR_r4_item = -1;  /* PRACH_SystemInformation_LCR_r4 */
static int hf_rrc_PRACH_SystemInformationList_LCR_v770ext_item = -1;  /* PRACH_SystemInformation_LCR_v770ext */
static int hf_rrc_ul_DPCH_InfoPredef = -1;        /* UL_DPCH_InfoPredef */
static int hf_rrc_dl_CommonInformationPredef = -1;  /* DL_CommonInformationPredef */
static int hf_rrc_ul_DPCH_InfoPredef_01 = -1;     /* UL_DPCH_InfoPredef_v770ext */
static int hf_rrc_fdd_108 = -1;                   /* T_fdd_105 */
static int hf_rrc_tx_DiversityIndicator = -1;     /* BOOLEAN */
static int hf_rrc_tdd_65 = -1;                    /* T_tdd_59 */
static int hf_rrc_syncCase = -1;                  /* T_syncCase */
static int hf_rrc_syncCase1 = -1;                 /* T_syncCase1 */
static int hf_rrc_syncCase2 = -1;                 /* T_syncCase2 */
static int hf_rrc_timeslotSync2 = -1;             /* TimeslotSync2 */
static int hf_rrc_sctd_Indicator = -1;            /* BOOLEAN */
static int hf_rrc_fdd_109 = -1;                   /* T_fdd_106 */
static int hf_rrc_tdd_66 = -1;                    /* T_tdd_60 */
static int hf_rrc_tddOption_14 = -1;              /* T_tddOption_14 */
static int hf_rrc_tdd384_tdd768_05 = -1;          /* T_tdd384_tdd768_04 */
static int hf_rrc_syncCase_01 = -1;               /* T_syncCase_01 */
static int hf_rrc_syncCase1_01 = -1;              /* T_syncCase1_01 */
static int hf_rrc_syncCase2_01 = -1;              /* T_syncCase2_01 */
static int hf_rrc_tdd128_47 = -1;                 /* T_tdd128_46 */
static int hf_rrc_syncCase_02 = -1;               /* T_syncCase_02 */
static int hf_rrc_syncCase1_02 = -1;              /* T_syncCase1_02 */
static int hf_rrc_syncCase2_02 = -1;              /* T_syncCase2_02 */
static int hf_rrc_primaryScramblingCode = -1;     /* PrimaryScramblingCode */
static int hf_rrc_pusch_Allocation = -1;          /* T_pusch_Allocation */
static int hf_rrc_pusch_AllocationPending = -1;   /* NULL */
static int hf_rrc_pusch_AllocationAssignment = -1;  /* T_pusch_AllocationAssignment */
static int hf_rrc_pusch_AllocationPeriodInfo = -1;  /* AllocationPeriodInfo */
static int hf_rrc_pusch_PowerControlInfo = -1;    /* UL_TargetSIR */
static int hf_rrc_configuration_03 = -1;          /* T_configuration_03 */
static int hf_rrc_old_Configuration_03 = -1;      /* T_old_Configuration_03 */
static int hf_rrc_pusch_Identity = -1;            /* PUSCH_Identity */
static int hf_rrc_new_Configuration_03 = -1;      /* T_new_Configuration_03 */
static int hf_rrc_pusch_Info = -1;                /* PUSCH_Info */
static int hf_rrc_pusch_Allocation_01 = -1;       /* T_pusch_Allocation_01 */
static int hf_rrc_pusch_AllocationAssignment_01 = -1;  /* T_pusch_AllocationAssignment_01 */
static int hf_rrc_pusch_PowerControlInfo_01 = -1;  /* PUSCH_PowerControlInfo_r4 */
static int hf_rrc_configuration_04 = -1;          /* T_configuration_04 */
static int hf_rrc_old_Configuration_04 = -1;      /* T_old_Configuration_04 */
static int hf_rrc_new_Configuration_04 = -1;      /* T_new_Configuration_04 */
static int hf_rrc_pusch_Info_01 = -1;             /* PUSCH_Info_r4 */
static int hf_rrc_pusch_Allocation_02 = -1;       /* T_pusch_Allocation_02 */
static int hf_rrc_pusch_AllocationAssignment_02 = -1;  /* T_pusch_AllocationAssignment_02 */
static int hf_rrc_pusch_PowerControlInfo_02 = -1;  /* PUSCH_PowerControlInfo_r7 */
static int hf_rrc_configuration_05 = -1;          /* T_configuration_05 */
static int hf_rrc_old_Configuration_05 = -1;      /* T_old_Configuration_05 */
static int hf_rrc_new_Configuration_05 = -1;      /* T_new_Configuration_05 */
static int hf_rrc_pusch_Info_02 = -1;             /* PUSCH_Info_VHCR */
static int hf_rrc_pusch_TimeslotsCodes = -1;      /* UplinkTimeslotsCodes */
static int hf_rrc_tddOption_15 = -1;              /* T_tddOption_15 */
static int hf_rrc_tdd384_32 = -1;                 /* T_tdd384_29 */
static int hf_rrc_tdd128_48 = -1;                 /* T_tdd128_47 */
static int hf_rrc_pusch_TimeslotsCodes_01 = -1;   /* UplinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_pusch_TimeslotsCodes_VHCR = -1;  /* UplinkTimeslotsCodes_VHCR */
static int hf_rrc_ul_TargetSIR = -1;              /* UL_TargetSIR */
static int hf_rrc_tddOption_16 = -1;              /* T_tddOption_16 */
static int hf_rrc_tdd128_49 = -1;                 /* T_tdd128_48 */
static int hf_rrc_tddOption_17 = -1;              /* T_tddOption_17 */
static int hf_rrc_tdd128_50 = -1;                 /* T_tdd128_49 */
static int hf_rrc_usch_TFCS = -1;                 /* TFCS */
static int hf_rrc_pusch_Info_VHCR = -1;           /* PUSCH_Info_VHCR */
static int hf_rrc_usch_TransportChannelsInfo = -1;  /* USCH_TransportChannelsInfo */
static int hf_rrc_pusch_Info_03 = -1;             /* PUSCH_Info_LCR_r4 */
static int hf_rrc_PUSCH_SysInfoList_item = -1;    /* PUSCH_SysInfo */
static int hf_rrc_PUSCH_SysInfoList_HCR_r5_item = -1;  /* PUSCH_SysInfo_HCR_r5 */
static int hf_rrc_PUSCH_SysInfoList_LCR_r4_item = -1;  /* PUSCH_SysInfo_LCR_r4 */
static int hf_rrc_PUSCH_SysInfoList_SFN_item = -1;  /* PUSCH_SysInfoList_SFN_item */
static int hf_rrc_pusch_SysInfo = -1;             /* PUSCH_SysInfo */
static int hf_rrc_PUSCH_SysInfoList_SFN_HCR_r5_item = -1;  /* PUSCH_SysInfoList_SFN_HCR_r5_item */
static int hf_rrc_pusch_SysInfo_01 = -1;          /* PUSCH_SysInfo_HCR_r5 */
static int hf_rrc_PUSCH_SysInfoList_SFN_LCR_r4_item = -1;  /* PUSCH_SysInfoList_SFN_LCR_r4_item */
static int hf_rrc_pusch_SysInfo_02 = -1;          /* PUSCH_SysInfo_LCR_r4 */
static int hf_rrc_PUSCH_SysInfoList_SFN_VHCR_item = -1;  /* PUSCH_SysInfoList_SFN_VHCR_item */
static int hf_rrc_pusch_SysInfo_VHCR = -1;        /* PUSCH_SysInfo_VHCR */
static int hf_rrc_mmax = -1;                      /* INTEGER_1_32 */
static int hf_rrc_nb01Min = -1;                   /* NB01 */
static int hf_rrc_nb01Max = -1;                   /* NB01 */
static int hf_rrc_reference_Code_Rate = -1;       /* INTEGER_0_10 */
static int hf_rrc_reference_Beta = -1;            /* INTEGER_M15_16 */
static int hf_rrc_repetitionPeriod1 = -1;         /* NULL */
static int hf_rrc_repetitionPeriod2 = -1;         /* INTEGER_1_1 */
static int hf_rrc_repetitionPeriod4 = -1;         /* INTEGER_1_3 */
static int hf_rrc_repetitionPeriod8 = -1;         /* INTEGER_1_7 */
static int hf_rrc_repetitionPeriod16 = -1;        /* INTEGER_1_15 */
static int hf_rrc_repetitionPeriod32 = -1;        /* INTEGER_1_31 */
static int hf_rrc_repetitionPeriod64 = -1;        /* INTEGER_1_63 */
static int hf_rrc_repetitionPeriod2_01 = -1;      /* T_repetitionPeriod2 */
static int hf_rrc_length = -1;                    /* NULL */
static int hf_rrc_offset = -1;                    /* INTEGER_0_1 */
static int hf_rrc_repetitionPeriod4_01 = -1;      /* T_repetitionPeriod4 */
static int hf_rrc_length_01 = -1;                 /* INTEGER_1_3 */
static int hf_rrc_offset_01 = -1;                 /* INTEGER_0_3 */
static int hf_rrc_repetitionPeriod8_01 = -1;      /* T_repetitionPeriod8 */
static int hf_rrc_length_02 = -1;                 /* INTEGER_1_7 */
static int hf_rrc_offset_02 = -1;                 /* INTEGER_0_7 */
static int hf_rrc_repetitionPeriod16_01 = -1;     /* T_repetitionPeriod16 */
static int hf_rrc_length_03 = -1;                 /* INTEGER_1_15 */
static int hf_rrc_offset_03 = -1;                 /* INTEGER_0_15 */
static int hf_rrc_repetitionPeriod32_01 = -1;     /* T_repetitionPeriod32 */
static int hf_rrc_length_04 = -1;                 /* INTEGER_1_31 */
static int hf_rrc_offset_04 = -1;                 /* INTEGER_0_31 */
static int hf_rrc_repetitionPeriod64_01 = -1;     /* T_repetitionPeriod64 */
static int hf_rrc_length_05 = -1;                 /* INTEGER_1_63 */
static int hf_rrc_offset_05 = -1;                 /* INTEGER_0_63 */
static int hf_rrc_tfci_Field2 = -1;               /* MaxTFCI_Field2Value */
static int hf_rrc_ReplacedPDSCH_CodeInfoList_item = -1;  /* ReplacedPDSCH_CodeInfo */
static int hf_rrc_rpp4_2 = -1;                    /* INTEGER_0_3 */
static int hf_rrc_rpp8_2 = -1;                    /* INTEGER_0_7 */
static int hf_rrc_rpp8_4 = -1;                    /* INTEGER_0_7 */
static int hf_rrc_rpp16_2 = -1;                   /* INTEGER_0_15 */
static int hf_rrc_rpp16_4 = -1;                   /* INTEGER_0_15 */
static int hf_rrc_rpp32_2 = -1;                   /* INTEGER_0_31 */
static int hf_rrc_rpp32_4 = -1;                   /* INTEGER_0_31 */
static int hf_rrc_rpp64_2 = -1;                   /* INTEGER_0_63 */
static int hf_rrc_rpp64_4 = -1;                   /* INTEGER_0_63 */
static int hf_rrc_dl_restrictedTrCh_Type = -1;    /* DL_TrCH_Type */
static int hf_rrc_restrictedDL_TrCH_Identity = -1;  /* TransportChannelIdentity */
static int hf_rrc_allowedTFIList = -1;            /* AllowedTFI_List */
static int hf_rrc_RestrictedTrCH_InfoList_item = -1;  /* RestrictedTrCH */
static int hf_rrc_dummy2_08 = -1;                 /* SCCPCH_InfoForFACH */
static int hf_rrc_cell_Id = -1;                   /* CellIdentity */
static int hf_rrc_dl_dpchInfo_04 = -1;            /* T_dl_dpchInfo_04 */
static int hf_rrc_dl_dpchInfo_05 = -1;            /* T_dl_dpchInfo_05 */
static int hf_rrc_dl_dpchInfo_06 = -1;            /* T_dl_dpchInfo_06 */
static int hf_rrc_targetCellPreconfigInfo = -1;   /* TargetCellPreconfigInfo */
static int hf_rrc_dl_dpchInfo_07 = -1;            /* T_dl_dpchInfo_07 */
static int hf_rrc_targetCellPreconfigInfo_01 = -1;  /* TargetCellPreconfigInfo_r9 */
static int hf_rrc_dl_dpchInfo_08 = -1;            /* T_dl_dpchInfo_08 */
static int hf_rrc_targetCellPreconfigInfo_02 = -1;  /* TargetCellPreconfigInfo_r10 */
static int hf_rrc_targetCellPreconfigInfo_03 = -1;  /* TargetCellPreconfigInfo_vb50ext */
static int hf_rrc_dl_dpchInfo_09 = -1;            /* T_dl_dpchInfo_09 */
static int hf_rrc_targetCellPreconfigInfo_04 = -1;  /* TargetCellPreconfigInfo_r11 */
static int hf_rrc_targetCellPreconfigInfo_05 = -1;  /* TargetCellPreconfigInfo_v890ext */
static int hf_rrc_targetCellPreconfigInfo_06 = -1;  /* TargetCellPreconfigInfo_v950ext */
static int hf_rrc_RL_AdditionInformationList_item = -1;  /* RL_AdditionInformation */
static int hf_rrc_RL_AdditionInformationList_r6_item = -1;  /* RL_AdditionInformation_r6 */
static int hf_rrc_RL_AdditionInformationList_r7_item = -1;  /* RL_AdditionInformation_r7 */
static int hf_rrc_RL_AdditionInformation_list_v6b0ext_item = -1;  /* RL_AdditionInformation_v6b0ext */
static int hf_rrc_RL_AdditionInformationList_r8_item = -1;  /* RL_AdditionInformation_r8 */
static int hf_rrc_RL_AdditionInformationList_v890ext_item = -1;  /* RL_AdditionInformation_v890ext */
static int hf_rrc_RL_AdditionInformationList_r9_item = -1;  /* RL_AdditionInformation_r9 */
static int hf_rrc_RL_AdditionInformationList_v950ext_item = -1;  /* RL_AdditionInformation_v950ext */
static int hf_rrc_RL_AdditionInformationList_r10_item = -1;  /* RL_AdditionInformation_r10 */
static int hf_rrc_RL_AdditionInformationList_vb50ext_item = -1;  /* RL_AdditionInformation_vb50ext */
static int hf_rrc_RL_AdditionInformationList_r11_item = -1;  /* RL_AdditionInformation_r11 */
static int hf_rrc_RL_AdditionInformationList_SecULFreq_item = -1;  /* RL_AdditionInformation_SecULFreq */
static int hf_rrc_RL_IdentifierList_item = -1;    /* PrimaryCPICH_Info */
static int hf_rrc_RL_RemovalInformationList_item = -1;  /* PrimaryCPICH_Info */
static int hf_rrc_RL_RemovalInformationList_SecULFreq_item = -1;  /* PrimaryCPICH_Info */
static int hf_rrc_SCCPCH_ChannelisationCodeList_item = -1;  /* SCCPCH_ChannelisationCode */
static int hf_rrc_SCCPCH_ChannelisationCodeList_VHCR_item = -1;  /* SCCPCH_ChannelisationCode_VHCR */
static int hf_rrc_secondaryCCPCH_Info = -1;       /* SecondaryCCPCH_Info */
static int hf_rrc_modeSpecificInfo_74 = -1;       /* T_modeSpecificInfo_74 */
static int hf_rrc_fdd_110 = -1;                   /* T_fdd_107 */
static int hf_rrc_fach_PCH_InformationList = -1;  /* FACH_PCH_InformationList */
static int hf_rrc_sib_ReferenceListFACH = -1;     /* SIB_ReferenceListFACH */
static int hf_rrc_tdd_67 = -1;                    /* T_tdd_61 */
static int hf_rrc_secondaryCCPCH_Info_01 = -1;    /* SecondaryCCPCH_Info_r4 */
static int hf_rrc_modeSpecificInfo_75 = -1;       /* T_modeSpecificInfo_75 */
static int hf_rrc_fdd_111 = -1;                   /* T_fdd_108 */
static int hf_rrc_pich_Info = -1;                 /* PICH_Info */
static int hf_rrc_secondaryCCPCH_LCR_Extensions = -1;  /* SecondaryCCPCH_Info_LCR_r4_ext */
static int hf_rrc_pich_Info_01 = -1;              /* PICH_Info_LCR_r4 */
static int hf_rrc_secondaryCCPCH_Info_02 = -1;    /* SecondaryCCPCH_Info_HCR_VHCR_r7 */
static int hf_rrc_pich_Info_02 = -1;              /* PICH_Info_HCR_VHCR_r7 */
static int hf_rrc_SCCPCH_SystemInformationList_item = -1;  /* SCCPCH_SystemInformation */
static int hf_rrc_SCCPCH_SystemInformationList_HCR_VHCR_r7_item = -1;  /* SCCPCH_SystemInformation_HCR_VHCR_r7 */
static int hf_rrc_SCCPCH_SystemInformationList_LCR_r4_ext_item = -1;  /* SCCPCH_SystemInformation_LCR_r4_ext */
static int hf_rrc_secondaryCCPCHInfo_MBMS = -1;   /* SecondaryCCPCHInfo_MBMS_r6 */
static int hf_rrc_transportFormatCombinationSet = -1;  /* TFCS */
static int hf_rrc_fachCarryingMCCH = -1;          /* T_fachCarryingMCCH */
static int hf_rrc_mcch_transportFormatSet = -1;   /* TransportFormatSet */
static int hf_rrc_mcch_ConfigurationInfo = -1;    /* MBMS_MCCH_ConfigurationInfo_r6 */
static int hf_rrc_fachCarryingMTCH_List = -1;     /* MBMS_FACHCarryingMTCH_List */
static int hf_rrc_fachCarryingMSCH = -1;          /* T_fachCarryingMSCH */
static int hf_rrc_msch_transportFormatSet = -1;   /* TransportFormatSet */
static int hf_rrc_dummy_47 = -1;                  /* MBMS_MSCH_ConfigurationInfo_r6 */
static int hf_rrc_secondaryCCPCHInfo_MBMS_01 = -1;  /* SecondaryCCPCHInfo_MBMS_r7 */
static int hf_rrc_fachCarryingMCCH_01 = -1;       /* T_fachCarryingMCCH_01 */
static int hf_rrc_fachCarryingMSCH_01 = -1;       /* T_fachCarryingMSCH_01 */
static int hf_rrc_common_E_DCH_ResourceInfoListExt = -1;  /* SEQUENCE_SIZE_1_maxEDCHs_OF_Common_E_DCH_ResourceInfoListExt */
static int hf_rrc_common_E_DCH_ResourceInfoListExt_item = -1;  /* Common_E_DCH_ResourceInfoListExt */
static int hf_rrc_modeSpecificInfo_76 = -1;       /* T_modeSpecificInfo_76 */
static int hf_rrc_fdd_112 = -1;                   /* T_fdd_109 */
static int hf_rrc_dummy1_03 = -1;                 /* PCPICH_UsageForChannelEst */
static int hf_rrc_dummy2_09 = -1;                 /* SecondaryCPICH_Info */
static int hf_rrc_sf_AndCodeNumber_01 = -1;       /* SF256_AndCodeNumber */
static int hf_rrc_pilotSymbolExistence = -1;      /* BOOLEAN */
static int hf_rrc_timingOffset = -1;              /* TimingOffset */
static int hf_rrc_tdd_68 = -1;                    /* T_tdd_62 */
static int hf_rrc_commonTimeslotInfo_01 = -1;     /* CommonTimeslotInfoSCCPCH */
static int hf_rrc_channelisationCode_09 = -1;     /* SCCPCH_ChannelisationCodeList */
static int hf_rrc_modeSpecificInfo_77 = -1;       /* T_modeSpecificInfo_77 */
static int hf_rrc_fdd_113 = -1;                   /* T_fdd_110 */
static int hf_rrc_tdd_69 = -1;                    /* T_tdd_63 */
static int hf_rrc_tddOption_18 = -1;              /* T_tddOption_18 */
static int hf_rrc_tdd384_33 = -1;                 /* T_tdd384_30 */
static int hf_rrc_tdd128_51 = -1;                 /* T_tdd128_50 */
static int hf_rrc_modeSpecificInfo_78 = -1;       /* T_modeSpecificInfo_78 */
static int hf_rrc_tdd384_34 = -1;                 /* T_tdd384_31 */
static int hf_rrc_tdd768_21 = -1;                 /* T_tdd768_18 */
static int hf_rrc_channelisationCode_10 = -1;     /* SCCPCH_ChannelisationCodeList_VHCR */
static int hf_rrc_individualTimeslotLCR_Ext = -1;  /* IndividualTimeslotInfo_LCR_r4_ext */
static int hf_rrc_subFrameNumber = -1;            /* INTEGER_0_4 */
static int hf_rrc_dl_ChannelisationCodes = -1;    /* DL_ChannelCodes_MBSFN_IMB384 */
static int hf_rrc_modulation_03 = -1;             /* T_modulation_03 */
static int hf_rrc_modQPSK = -1;                   /* NULL */
static int hf_rrc_mod16QAM = -1;                  /* T_mod16QAM */
static int hf_rrc_cpich_SecCCPCH_PowerOffset = -1;  /* INTEGER_M11_4 */
static int hf_rrc_modeSpecificInfo_79 = -1;       /* T_modeSpecificInfo_79 */
static int hf_rrc_fdd_114 = -1;                   /* T_fdd_111 */
static int hf_rrc_tdd384_35 = -1;                 /* T_tdd384_32 */
static int hf_rrc_commonTimeslotInfoMBMS = -1;    /* CommonTimeslotInfoMBMS */
static int hf_rrc_downlinkTimeslotsCodes = -1;    /* DownlinkTimeslotsCodes */
static int hf_rrc_tdd128_52 = -1;                 /* T_tdd128_51 */
static int hf_rrc_downlinkTimeslotsCodes_01 = -1;  /* DownlinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_modeSpecificInfo_80 = -1;       /* T_modeSpecificInfo_80 */
static int hf_rrc_fdd_115 = -1;                   /* T_fdd_112 */
static int hf_rrc_modulation_04 = -1;             /* T_modulation_04 */
static int hf_rrc_mod16QAM_01 = -1;               /* INTEGER_M11_4 */
static int hf_rrc_tdd384_36 = -1;                 /* T_tdd384_33 */
static int hf_rrc_downlinkTimeslotsCodes_02 = -1;  /* DownlinkTimeslotsCodes_r7 */
static int hf_rrc_modulation_05 = -1;             /* T_modulation_05 */
static int hf_rrc_tdd768_22 = -1;                 /* T_tdd768_19 */
static int hf_rrc_downlinkTimeslotsCodes_03 = -1;  /* DownlinkTimeslotsCodes_VHCR */
static int hf_rrc_modulation_06 = -1;             /* T_modulation_06 */
static int hf_rrc_tdd128_53 = -1;                 /* T_tdd128_52 */
static int hf_rrc_mbsfnSpecialTimeSlot = -1;      /* TimeSlotLCR_ext */
static int hf_rrc_modulation_07 = -1;             /* T_modulation_07 */
static int hf_rrc_secondaryDL_ScramblingCode = -1;  /* SecondaryScramblingCode */
static int hf_rrc_newConfiguration_08 = -1;       /* T_newConfiguration_08 */
static int hf_rrc_precodingWeightSetRestriction_03 = -1;  /* T_precodingWeightSetRestriction_02 */
static int hf_rrc_newConfiguration_09 = -1;       /* T_newConfiguration_09 */
static int hf_rrc_precodingWeightSetRestriction_04 = -1;  /* T_precodingWeightSetRestriction_03 */
static int hf_rrc_configurationInfo_05 = -1;      /* T_configurationInfo_05 */
static int hf_rrc_newConfiguration_10 = -1;       /* T_newConfiguration_10 */
static int hf_rrc_mimoPilotConfiguration_02 = -1;  /* MIMO4x4_PilotConfiguration */
static int hf_rrc_servingCellChangeMACreset = -1;  /* ServingCellChangeMACreset */
static int hf_rrc_servingCellChangeMsgType = -1;  /* ServingCellChangeMsgType */
static int hf_rrc_servingCellChangeTrId = -1;     /* ServingCellChangeTrId */
static int hf_rrc_sf4 = -1;                       /* INTEGER_0_3 */
static int hf_rrc_sf8 = -1;                       /* INTEGER_0_7 */
static int hf_rrc_sf16 = -1;                      /* INTEGER_0_15 */
static int hf_rrc_sf32 = -1;                      /* INTEGER_0_31 */
static int hf_rrc_sf64 = -1;                      /* INTEGER_0_63 */
static int hf_rrc_sf128 = -1;                     /* INTEGER_0_127 */
static int hf_rrc_sf256 = -1;                     /* INTEGER_0_255 */
static int hf_rrc_sf512 = -1;                     /* INTEGER_0_511 */
static int hf_rrc_sfd4 = -1;                      /* NULL */
static int hf_rrc_sfd8 = -1;                      /* NULL */
static int hf_rrc_sfd16 = -1;                     /* NULL */
static int hf_rrc_sfd32 = -1;                     /* NULL */
static int hf_rrc_sfd64 = -1;                     /* NULL */
static int hf_rrc_sfd128 = -1;                    /* PilotBits128 */
static int hf_rrc_sfd256 = -1;                    /* PilotBits256 */
static int hf_rrc_sfd512 = -1;                    /* NULL */
static int hf_rrc_activationTimeSFN = -1;         /* INTEGER_0_4095 */
static int hf_rrc_physChDuration = -1;            /* DurationTimeInfo */
static int hf_rrc_e_dch_SPS_Info = -1;            /* E_DCH_SPS_Information_TDD128 */
static int hf_rrc_hs_dsch_SPS_Info = -1;          /* HS_DSCH_SPS_Information_TDD128 */
static int hf_rrc_s_Field = -1;                   /* S_Field */
static int hf_rrc_codeWordSet = -1;               /* CodeWordSet */
static int hf_rrc_ssdt_UL_r4 = -1;                /* SSDT_UL */
static int hf_rrc_timeSlotInformation = -1;       /* BIT_STRING_SIZE_5 */
static int hf_rrc_repetitionPeriod = -1;          /* T_repetitionPeriod */
static int hf_rrc_referenceBeta = -1;             /* INTEGER_M15_16 */
static int hf_rrc_sync_UL_CodesBitmap = -1;       /* T_sync_UL_CodesBitmap */
static int hf_rrc_prxUpPCHdes = -1;               /* INTEGER_0_62 */
static int hf_rrc_sync_UL_Procedure = -1;         /* SYNC_UL_Procedure_r4 */
static int hf_rrc_max_SYNC_UL_Transmissions = -1;  /* T_max_SYNC_UL_Transmissions */
static int hf_rrc_powerRampStep_01 = -1;          /* INTEGER_0_3 */
static int hf_rrc_sync_UL_Codes_Bitmap = -1;      /* Sync_UL_Codes_Bitmap */
static int hf_rrc_max_SYNC_UL_Transmissions_01 = -1;  /* T_max_SYNC_UL_Transmissions_01 */
static int hf_rrc_max_SYNC_UL_Transmissions_02 = -1;  /* T_max_SYNC_UL_Transmissions_02 */
static int hf_rrc_activationTimeOffset = -1;      /* ActivationTimeOffset */
static int hf_rrc_uL_OLTD_InfoFDD = -1;           /* UL_OLTD_InfoFDD */
static int hf_rrc_ul_MIMO_Info = -1;              /* UL_MIMO_InfoFDD */
static int hf_rrc_TDD_MBSFNInformation_item = -1;  /* TDD_MBSFNTSlotInfo */
static int hf_rrc_timeSlotNumber = -1;            /* TimeslotNumber */
static int hf_rrc_sf8_01 = -1;                    /* SEQUENCE_SIZE_1_8_OF_TDD_PRACH_CCode8 */
static int hf_rrc_sf8_item = -1;                  /* TDD_PRACH_CCode8 */
static int hf_rrc_sf16_01 = -1;                   /* SEQUENCE_SIZE_1_8_OF_TDD_PRACH_CCode16 */
static int hf_rrc_sf16_item = -1;                 /* TDD_PRACH_CCode16 */
static int hf_rrc_sf32_01 = -1;                   /* SEQUENCE_SIZE_1_16_OF_TDD768_PRACH_CCode32 */
static int hf_rrc_sf32_item = -1;                 /* TDD768_PRACH_CCode32 */
static int hf_rrc_sf16_02 = -1;                   /* SEQUENCE_SIZE_1_16_OF_TDD768_PRACH_CCode16 */
static int hf_rrc_sf16_item_01 = -1;              /* TDD768_PRACH_CCode16 */
static int hf_rrc_tgpsi = -1;                     /* TGPSI */
static int hf_rrc_tgps_Status = -1;               /* T_tgps_Status */
static int hf_rrc_activate = -1;                  /* T_activate */
static int hf_rrc_tgcfn = -1;                     /* TGCFN */
static int hf_rrc_deactivate = -1;                /* NULL */
static int hf_rrc_tgps_ConfigurationParams = -1;  /* TGPS_ConfigurationParams */
static int hf_rrc_tgps_Status_01 = -1;            /* T_tgps_Status_01 */
static int hf_rrc_activate_01 = -1;               /* T_activate_01 */
static int hf_rrc_tgps_ConfigurationParams_01 = -1;  /* TGPS_ConfigurationParams_r8 */
static int hf_rrc_tgps_Status_02 = -1;            /* T_tgps_Status_02 */
static int hf_rrc_activate_02 = -1;               /* T_activate_02 */
static int hf_rrc_tgps_ConfigurationParams_02 = -1;  /* TGPS_ConfigurationParams_r10 */
static int hf_rrc_TGP_SequenceList_item = -1;     /* TGP_Sequence */
static int hf_rrc_TGP_SequenceList_r8_item = -1;  /* TGP_Sequence_r8 */
static int hf_rrc_TGP_SequenceList_r10_item = -1;  /* TGP_Sequence_r10 */
static int hf_rrc_tgps_Status_03 = -1;            /* T_tgps_Status_03 */
static int hf_rrc_activate_03 = -1;               /* T_activate_03 */
static int hf_rrc_tgps_Status_04 = -1;            /* T_tgps_Status_04 */
static int hf_rrc_activate_04 = -1;               /* T_activate_04 */
static int hf_rrc_freqSpecificCompressedMode_01 = -1;  /* T_freqSpecificCompressedMode_01 */
static int hf_rrc_tgmp = -1;                      /* TGMP */
static int hf_rrc_tgprc = -1;                     /* TGPRC */
static int hf_rrc_tgsn = -1;                      /* TGSN */
static int hf_rrc_tgl1 = -1;                      /* TGL */
static int hf_rrc_tgl2 = -1;                      /* TGL */
static int hf_rrc_tgd = -1;                       /* TGD */
static int hf_rrc_tgpl1 = -1;                     /* TGPL */
static int hf_rrc_dummy_48 = -1;                  /* TGPL */
static int hf_rrc_rpp = -1;                       /* RPP */
static int hf_rrc_itp = -1;                       /* ITP */
static int hf_rrc_ul_DL_Mode = -1;                /* UL_DL_Mode */
static int hf_rrc_dl_FrameType = -1;              /* DL_FrameType */
static int hf_rrc_deltaSIR1 = -1;                 /* DeltaSIR */
static int hf_rrc_deltaSIRAfter1 = -1;            /* DeltaSIR */
static int hf_rrc_deltaSIR2 = -1;                 /* DeltaSIR */
static int hf_rrc_deltaSIRAfter2 = -1;            /* DeltaSIR */
static int hf_rrc_nidentifyAbort = -1;            /* NidentifyAbort */
static int hf_rrc_treconfirmAbort = -1;           /* TreconfirmAbort */
static int hf_rrc_tgmp_01 = -1;                   /* TGMP_r8 */
static int hf_rrc_freqSpecificCompressedMode_02 = -1;  /* T_freqSpecificCompressedMode_02 */
static int hf_rrc_durationTimeInfo = -1;          /* DurationTimeInfo */
static int hf_rrc_TimeslotList_item = -1;         /* TimeslotNumber */
static int hf_rrc_tdd384_37 = -1;                 /* SEQUENCE_SIZE_1_maxTS_OF_TimeslotNumber */
static int hf_rrc_tdd384_item = -1;               /* TimeslotNumber */
static int hf_rrc_tdd128_54 = -1;                 /* SEQUENCE_SIZE_1_maxTS_LCR_OF_TimeslotNumber_LCR_r4 */
static int hf_rrc_tdd128_item_01 = -1;            /* TimeslotNumber_LCR_r4 */
static int hf_rrc_timing = -1;                    /* T_timing */
static int hf_rrc_newTiming = -1;                 /* NewTiming */
static int hf_rrc_harqProcessAllocation = -1;     /* BIT_STRING_SIZE_8 */
static int hf_rrc_channelReqParamsForUCSM = -1;   /* ChannelReqParamsForUCSM */
static int hf_rrc_ul_16QAM_Settings = -1;         /* UL_16QAM_Settings */
static int hf_rrc_mac_es_e_resetIndicator = -1;   /* T_mac_es_e_resetIndicator */
static int hf_rrc_beta_Ed_Gain_E_AGCH_Table_Selection = -1;  /* INTEGER_0_1 */
static int hf_rrc_ul_64QAM_Settings = -1;         /* UL_64QAM_Settings */
static int hf_rrc_mac_is_i_resetIndicator = -1;   /* T_mac_is_i_resetIndicator */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes = -1;  /* UplinkTimeslotsCodes */
static int hf_rrc_tddOption_19 = -1;              /* T_tddOption_19 */
static int hf_rrc_tdd384_38 = -1;                 /* T_tdd384_34 */
static int hf_rrc_tdd128_55 = -1;                 /* T_tdd128_53 */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes_01 = -1;  /* UplinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_tddOption_20 = -1;              /* T_tddOption_20 */
static int hf_rrc_tdd384_39 = -1;                 /* T_tdd384_35 */
static int hf_rrc_tdd768_23 = -1;                 /* T_tdd768_20 */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes_02 = -1;  /* UplinkTimeslotsCodes_VHCR */
static int hf_rrc_tdd128_56 = -1;                 /* T_tdd128_54 */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes_03 = -1;  /* UplinkTimeslotsCodes_LCR_r7 */
static int hf_rrc_UL_CCTrCHList_item = -1;        /* UL_CCTrCH */
static int hf_rrc_UL_CCTrCHList_r4_item = -1;     /* UL_CCTrCH_r4 */
static int hf_rrc_UL_CCTrCHList_r7_item = -1;     /* UL_CCTrCH_r7 */
static int hf_rrc_UL_CCTrCHListToRemove_item = -1;  /* TFCS_IdentityPlain */
static int hf_rrc_UL_CCTrChTPCList_item = -1;     /* TFCS_Identity */
static int hf_rrc_dummy_49 = -1;                  /* CPCH_SetInfo */
static int hf_rrc_dummy1_04 = -1;                 /* CPCH_SetInfo */
static int hf_rrc_dummy2_10 = -1;                 /* CPCH_SetID */
static int hf_rrc_configurationInfo_06 = -1;      /* T_configurationInfo_06 */
static int hf_rrc_newConfiguration_11 = -1;       /* T_newConfiguration_11 */
static int hf_rrc_s_dpcch_Info = -1;              /* S_DPCCH_Information */
static int hf_rrc_initial_CLTD_ActivationState = -1;  /* T_initial_CLTD_ActivationState */
static int hf_rrc_ul = -1;                        /* UL_CompressedModeMethod */
static int hf_rrc_dl = -1;                        /* DL_CompressedModeMethod */
static int hf_rrc_ul_and_dl = -1;                 /* T_ul_and_dl */
static int hf_rrc_ul_DPCCHscramblingCodeType = -1;  /* ScramblingCodeType */
static int hf_rrc_ul_DPCCHscramblingCode = -1;    /* UL_ScramblingCode */
static int hf_rrc_modeSpecificInfo_81 = -1;       /* T_modeSpecificInfo_81 */
static int hf_rrc_fdd_116 = -1;                   /* T_fdd_113 */
static int hf_rrc_scramblingCode = -1;            /* UL_ScramblingCode */
static int hf_rrc_numberOfDPDCH = -1;             /* NumberOfDPDCH */
static int hf_rrc_spreadingFactor_01 = -1;        /* SpreadingFactor */
static int hf_rrc_numberOfFBI_Bits = -1;          /* NumberOfFBI_Bits */
static int hf_rrc_tdd_70 = -1;                    /* T_tdd_64 */
static int hf_rrc_ul_CCTrCHList = -1;             /* UL_CCTrCHList */
static int hf_rrc_ul_CCTrCHListToRemove = -1;     /* UL_CCTrCHListToRemove */
static int hf_rrc_modeSpecificInfo_82 = -1;       /* T_modeSpecificInfo_82 */
static int hf_rrc_fdd_117 = -1;                   /* T_fdd_114 */
static int hf_rrc_tdd_71 = -1;                    /* T_tdd_65 */
static int hf_rrc_ul_CCTrCHList_01 = -1;          /* UL_CCTrCHList_r4 */
static int hf_rrc_modeSpecificInfo_83 = -1;       /* T_modeSpecificInfo_83 */
static int hf_rrc_fdd_118 = -1;                   /* T_fdd_115 */
static int hf_rrc_tdd_72 = -1;                    /* T_tdd_66 */
static int hf_rrc_ul_DPCH_PowerControlInfo_04 = -1;  /* UL_DPCH_PowerControlInfo_r6 */
static int hf_rrc_modeSpecificInfo_84 = -1;       /* T_modeSpecificInfo_84 */
static int hf_rrc_fdd_119 = -1;                   /* T_fdd_116 */
static int hf_rrc_dpdchPresence = -1;             /* T_dpdchPresence */
static int hf_rrc_present_04 = -1;                /* T_present_02 */
static int hf_rrc_notPresent = -1;                /* T_notPresent */
static int hf_rrc_tdd_73 = -1;                    /* T_tdd_67 */
static int hf_rrc_modeSpecificInfo_85 = -1;       /* T_modeSpecificInfo_85 */
static int hf_rrc_fdd_120 = -1;                   /* T_fdd_117 */
static int hf_rrc_dpdchPresence_01 = -1;          /* T_dpdchPresence_01 */
static int hf_rrc_present_05 = -1;                /* T_present_03 */
static int hf_rrc_numberOfTPC_Bits = -1;          /* NumberOfTPC_Bits */
static int hf_rrc_notPresent_01 = -1;             /* T_notPresent_01 */
static int hf_rrc_tdd_74 = -1;                    /* T_tdd_68 */
static int hf_rrc_ul_CCTrCHList_02 = -1;          /* UL_CCTrCHList_r7 */
static int hf_rrc_ul_DPCH_PowerControlInfo_05 = -1;  /* UL_DPCH_PowerControlInfo_r11 */
static int hf_rrc_modeSpecificInfo_86 = -1;       /* T_modeSpecificInfo_86 */
static int hf_rrc_fdd_121 = -1;                   /* T_fdd_118 */
static int hf_rrc_dpdchPresence_02 = -1;          /* T_dpdchPresence_02 */
static int hf_rrc_present_06 = -1;                /* T_present_04 */
static int hf_rrc_notPresent_02 = -1;             /* T_notPresent_02 */
static int hf_rrc_tdd_75 = -1;                    /* T_tdd_69 */
static int hf_rrc_ul_DPCH_PowerControlInfo_06 = -1;  /* UL_DPCH_PowerControlInfoPostFDD */
static int hf_rrc_reducedScramblingCodeNumber = -1;  /* ReducedScramblingCodeNumber */
static int hf_rrc_ul_DPCH_PowerControlInfo_07 = -1;  /* UL_DPCH_PowerControlInfoPostTDD */
static int hf_rrc_ul_DPCH_PowerControlInfo_08 = -1;  /* UL_DPCH_PowerControlInfoPostTDD_LCR_r4 */
static int hf_rrc_ul_TimingAdvance_04 = -1;       /* UL_TimingAdvanceControl_LCR_r4 */
static int hf_rrc_ul_DPCH_PowerControlInfo_09 = -1;  /* UL_DPCH_PowerControlInfoPredef */
static int hf_rrc_modeSpecificInfo_87 = -1;       /* T_modeSpecificInfo_87 */
static int hf_rrc_fdd_122 = -1;                   /* T_fdd_119 */
static int hf_rrc_tdd_76 = -1;                    /* T_tdd_70 */
static int hf_rrc_modeSpecificInfo_88 = -1;       /* T_modeSpecificInfo_88 */
static int hf_rrc_fdd_123 = -1;                   /* T_fdd_120 */
static int hf_rrc_fdd_124 = -1;                   /* T_fdd_121 */
static int hf_rrc_dpcch_PowerOffset = -1;         /* DPCCH_PowerOffset */
static int hf_rrc_sRB_delay = -1;                 /* SRB_delay */
static int hf_rrc_tdd_77 = -1;                    /* T_tdd_71 */
static int hf_rrc_ul_OL_PC_Signalling = -1;       /* T_ul_OL_PC_Signalling */
static int hf_rrc_broadcast_UL_OL_PC_info = -1;   /* NULL */
static int hf_rrc_individuallySignalled = -1;     /* T_individuallySignalled */
static int hf_rrc_individualTS_InterferenceList = -1;  /* IndividualTS_InterferenceList */
static int hf_rrc_fdd_125 = -1;                   /* T_fdd_122 */
static int hf_rrc_tdd_78 = -1;                    /* T_tdd_72 */
static int hf_rrc_ul_OL_PC_Signalling_01 = -1;    /* T_ul_OL_PC_Signalling_01 */
static int hf_rrc_individuallySignalled_01 = -1;  /* T_individuallySignalled_01 */
static int hf_rrc_tddOption_21 = -1;              /* T_tddOption_21 */
static int hf_rrc_tdd384_40 = -1;                 /* T_tdd384_36 */
static int hf_rrc_dpch_ConstantValue_01 = -1;     /* ConstantValue */
static int hf_rrc_tdd128_57 = -1;                 /* T_tdd128_55 */
static int hf_rrc_fdd_126 = -1;                   /* T_fdd_123 */
static int hf_rrc_ack_NACK_repetition_factor = -1;  /* ACK_NACK_repetitionFactor */
static int hf_rrc_tdd_79 = -1;                    /* T_tdd_73 */
static int hf_rrc_ul_OL_PC_Signalling_02 = -1;    /* T_ul_OL_PC_Signalling_02 */
static int hf_rrc_individuallySignalled_02 = -1;  /* T_individuallySignalled_02 */
static int hf_rrc_tddOption_22 = -1;              /* T_tddOption_22 */
static int hf_rrc_tdd384_41 = -1;                 /* T_tdd384_37 */
static int hf_rrc_tdd128_58 = -1;                 /* T_tdd128_56 */
static int hf_rrc_fdd_127 = -1;                   /* T_fdd_124 */
static int hf_rrc_tdd_80 = -1;                    /* T_tdd_74 */
static int hf_rrc_ul_OL_PC_Signalling_03 = -1;    /* T_ul_OL_PC_Signalling_03 */
static int hf_rrc_individuallySignalled_03 = -1;  /* T_individuallySignalled_03 */
static int hf_rrc_tddOption_23 = -1;              /* T_tddOption_23 */
static int hf_rrc_tdd384_42 = -1;                 /* T_tdd384_38 */
static int hf_rrc_tdd128_59 = -1;                 /* T_tdd128_57 */
static int hf_rrc_fdd_128 = -1;                   /* T_fdd_125 */
static int hf_rrc_tdd_81 = -1;                    /* T_tdd_75 */
static int hf_rrc_ul_OL_PC_Signalling_04 = -1;    /* T_ul_OL_PC_Signalling_04 */
static int hf_rrc_individuallySignalled_04 = -1;  /* T_individuallySignalled_04 */
static int hf_rrc_tddOption_24 = -1;              /* T_tddOption_24 */
static int hf_rrc_tdd384_43 = -1;                 /* T_tdd384_39 */
static int hf_rrc_tdd768_24 = -1;                 /* T_tdd768_21 */
static int hf_rrc_tdd128_60 = -1;                 /* T_tdd128_58 */
static int hf_rrc_fdd_129 = -1;                   /* T_fdd_126 */
static int hf_rrc_ack_NACK_repetition_factor_assisting = -1;  /* ACK_NACK_repetitionFactor */
static int hf_rrc_tdd_82 = -1;                    /* T_tdd_76 */
static int hf_rrc_ul_OL_PC_Signalling_05 = -1;    /* T_ul_OL_PC_Signalling_05 */
static int hf_rrc_individuallySignalled_05 = -1;  /* T_individuallySignalled_05 */
static int hf_rrc_tddOption_25 = -1;              /* T_tddOption_25 */
static int hf_rrc_tdd384_44 = -1;                 /* T_tdd384_40 */
static int hf_rrc_tdd768_25 = -1;                 /* T_tdd768_22 */
static int hf_rrc_tdd128_61 = -1;                 /* T_tdd128_59 */
static int hf_rrc_dpcch_PowerOffset_01 = -1;      /* DPCCH_PowerOffset2 */
static int hf_rrc_fdd_130 = -1;                   /* T_fdd_127 */
static int hf_rrc_tdd_83 = -1;                    /* T_tdd_77 */
static int hf_rrc_tdd_84 = -1;                    /* T_tdd_78 */
static int hf_rrc_non_ScheduledTransGrantInfo_02 = -1;  /* Non_ScheduledTransGrantInfoTDD_ext */
static int hf_rrc_mac_es_e_resetIndicator_01 = -1;  /* T_mac_es_e_resetIndicator_01 */
static int hf_rrc_e_DPCCH_Info = -1;              /* E_DPCCH_Info */
static int hf_rrc_e_DPDCH_Info = -1;              /* E_DPDCH_Info */
static int hf_rrc_schedulingTransmConfiguration = -1;  /* E_DPDCH_SchedulingTransmConfiguration */
static int hf_rrc_mac_es_e_resetIndicator_02 = -1;  /* T_mac_es_e_resetIndicator_02 */
static int hf_rrc_modeSpecificInfo_89 = -1;       /* T_modeSpecificInfo_89 */
static int hf_rrc_fdd_131 = -1;                   /* T_fdd_128 */
static int hf_rrc_e_DPCCH_Info_01 = -1;           /* E_DPCCH_Info_r7 */
static int hf_rrc_e_DPDCH_Info_01 = -1;           /* E_DPDCH_Info_r7 */
static int hf_rrc_tdd_85 = -1;                    /* T_tdd_79 */
static int hf_rrc_e_RUCCH_Info_01 = -1;           /* E_RUCCH_Info */
static int hf_rrc_e_PUCH_Info_01 = -1;            /* E_PUCH_Info */
static int hf_rrc_non_ScheduledTransGrantInfo_03 = -1;  /* Non_ScheduledTransGrantInfoTDD */
static int hf_rrc_mac_es_e_resetIndicator_03 = -1;  /* T_mac_es_e_resetIndicator_03 */
static int hf_rrc_modeSpecificInfo_90 = -1;       /* T_modeSpecificInfo_90 */
static int hf_rrc_fdd_132 = -1;                   /* T_fdd_129 */
static int hf_rrc_e_DPDCH_Info_02 = -1;           /* E_DPDCH_Info_r8 */
static int hf_rrc_tdd_86 = -1;                    /* T_tdd_80 */
static int hf_rrc_mac_es_e_resetIndicator_04 = -1;  /* T_mac_es_e_resetIndicator_04 */
static int hf_rrc_modeSpecificInfo_91 = -1;       /* T_modeSpecificInfo_91 */
static int hf_rrc_fdd_133 = -1;                   /* T_fdd_130 */
static int hf_rrc_tdd_87 = -1;                    /* T_tdd_81 */
static int hf_rrc_non_ScheduledTransGrantInfo_04 = -1;  /* Non_ScheduledTransGrantInfoTDD_r9 */
static int hf_rrc_mac_es_e_resetIndicator_05 = -1;  /* T_mac_es_e_resetIndicator_05 */
static int hf_rrc_modeSpecificInfo_92 = -1;       /* T_modeSpecificInfo_92 */
static int hf_rrc_fdd_134 = -1;                   /* T_fdd_131 */
static int hf_rrc_tdd_88 = -1;                    /* T_tdd_82 */
static int hf_rrc_configurationInfo_07 = -1;      /* T_configurationInfo_07 */
static int hf_rrc_newConfiguration_12 = -1;       /* T_newConfiguration_12 */
static int hf_rrc_s_e_dpcch_power_offset = -1;    /* INTEGER_0_17 */
static int hf_rrc_rank2_minimum_E_TFCI = -1;      /* E_DCH_MinimumSet_E_TFCI */
static int hf_rrc_inter_stream_compensation = -1;  /* INTEGER_0_15 */
static int hf_rrc_e_PUCH_info = -1;               /* E_PUCH_Info_MulticarrierEDCH_TDD128 */
static int hf_rrc_e_AGCH_info = -1;               /* E_AGCH_Information_TDD128 */
static int hf_rrc_e_HICH_info = -1;               /* E_HICH_Information_TDD128 */
static int hf_rrc_UL_MulticarrierEDCH_Infolist_TDD128_item = -1;  /* UL_MulticarrierEDCH_InfolistItem_TDD128 */
static int hf_rrc_UL_MulticarrierEDCH_Deletelist_TDD128_item = -1;  /* UARFCN */
static int hf_rrc_configuration_info = -1;        /* T_configuration_info */
static int hf_rrc_newConfiguration_13 = -1;       /* UL_MulticarrierEDCH_NewConfigurationInfo_TDD128 */
static int hf_rrc_tsn_Length_01 = -1;             /* T_tsn_Length_01 */
static int hf_rrc_ul_MulticarrierEDCH_Infolist = -1;  /* UL_MulticarrierEDCH_Infolist_TDD128 */
static int hf_rrc_ul_MulticarrierEDCH_Deletelist = -1;  /* UL_MulticarrierEDCH_Deletelist_TDD128 */
static int hf_rrc_stepSize = -1;                  /* INTEGER_1_8 */
static int hf_rrc_frequency = -1;                 /* INTEGER_1_8 */
static int hf_rrc_disabled = -1;                  /* NULL */
static int hf_rrc_enabled = -1;                   /* T_enabled */
static int hf_rrc_enabled_01 = -1;                /* T_enabled_01 */
static int hf_rrc_tddOption_26 = -1;              /* T_tddOption_26 */
static int hf_rrc_tdd384_45 = -1;                 /* T_tdd384_41 */
static int hf_rrc_tdd128_62 = -1;                 /* T_tdd128_60 */
static int hf_rrc_synchronisationParameters = -1;  /* SynchronisationParameters_r4 */
static int hf_rrc_enabled_02 = -1;                /* T_enabled_02 */
static int hf_rrc_tddOption_27 = -1;              /* T_tddOption_27 */
static int hf_rrc_tdd384_46 = -1;                 /* T_tdd384_42 */
static int hf_rrc_tdd768_26 = -1;                 /* T_tdd768_23 */
static int hf_rrc_tdd128_63 = -1;                 /* T_tdd128_61 */
static int hf_rrc_enabled_03 = -1;                /* T_enabled_03 */
static int hf_rrc_UL_TS_ChannelisationCodeList_item = -1;  /* UL_TS_ChannelisationCode */
static int hf_rrc_UL_TS_ChannelisationCodeList_r7_item = -1;  /* UL_TS_ChannelisationCodeList_r7_item */
static int hf_rrc_ul_TS_Channelisation_Code = -1;  /* UL_TS_ChannelisationCode */
static int hf_rrc_plcch_info = -1;                /* PLCCH_Info */
static int hf_rrc_UL_TS_ChannelisationCodeList_VHCR_item = -1;  /* UL_TS_ChannelisationCode_VHCR */
static int hf_rrc_parameters_04 = -1;             /* T_parameters_04 */
static int hf_rrc_sameAsLast_04 = -1;             /* T_sameAsLast_04 */
static int hf_rrc_newParameters_04 = -1;          /* T_newParameters_04 */
static int hf_rrc_ul_TS_ChannelisationCodeList = -1;  /* UL_TS_ChannelisationCodeList */
static int hf_rrc_parameters_05 = -1;             /* T_parameters_05 */
static int hf_rrc_sameAsLast_05 = -1;             /* T_sameAsLast_05 */
static int hf_rrc_newParameters_05 = -1;          /* T_newParameters_05 */
static int hf_rrc_parameters_06 = -1;             /* T_parameters_06 */
static int hf_rrc_sameAsLast_06 = -1;             /* T_sameAsLast_06 */
static int hf_rrc_newParameters_06 = -1;          /* T_newParameters_06 */
static int hf_rrc_ul_TS_ChannelisationCodeList_01 = -1;  /* UL_TS_ChannelisationCodeList_r7 */
static int hf_rrc_parameters_07 = -1;             /* T_parameters_07 */
static int hf_rrc_sameAsLast_07 = -1;             /* T_sameAsLast_07 */
static int hf_rrc_newParameters_07 = -1;          /* T_newParameters_07 */
static int hf_rrc_dynamicSFusage = -1;            /* BOOLEAN */
static int hf_rrc_moreTimeslots_04 = -1;          /* T_moreTimeslots_04 */
static int hf_rrc_additionalTimeslots_04 = -1;    /* T_additionalTimeslots_04 */
static int hf_rrc_consecutive_04 = -1;            /* T_consecutive_02 */
static int hf_rrc_numAdditionalTimeslots = -1;    /* INTEGER_1_maxTS_1 */
static int hf_rrc_timeslotList_04 = -1;           /* SEQUENCE_SIZE_1_maxTS_1_OF_UplinkAdditionalTimeslots */
static int hf_rrc_timeslotList_item_04 = -1;      /* UplinkAdditionalTimeslots */
static int hf_rrc_ul_TS_ChannelisationCodeList_02 = -1;  /* UL_TS_ChannelisationCodeList_VHCR */
static int hf_rrc_moreTimeslots_05 = -1;          /* T_moreTimeslots_05 */
static int hf_rrc_additionalTimeslots_05 = -1;    /* T_additionalTimeslots_05 */
static int hf_rrc_consecutive_05 = -1;            /* T_consecutive_03 */
static int hf_rrc_timeslotList_05 = -1;           /* SEQUENCE_SIZE_1_maxTS_1_OF_UplinkAdditionalTimeslots_VHCR */
static int hf_rrc_timeslotList_item_05 = -1;      /* UplinkAdditionalTimeslots_VHCR */
static int hf_rrc_moreTimeslots_06 = -1;          /* T_moreTimeslots_06 */
static int hf_rrc_additionalTimeslots_06 = -1;    /* T_additionalTimeslots_06 */
static int hf_rrc_consecutive_06 = -1;            /* T_consecutive_04 */
static int hf_rrc_numAdditionalTimeslots_01 = -1;  /* INTEGER_1_maxTS_LCR_1 */
static int hf_rrc_timeslotList_06 = -1;           /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_UplinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_timeslotList_item_06 = -1;      /* UplinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_moreTimeslots_07 = -1;          /* T_moreTimeslots_07 */
static int hf_rrc_additionalTimeslots_07 = -1;    /* T_additionalTimeslots_07 */
static int hf_rrc_consecutive_07 = -1;            /* T_consecutive_05 */
static int hf_rrc_timeslotList_07 = -1;           /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_UplinkAdditionalTimeslots_LCR_r7 */
static int hf_rrc_timeslotList_item_07 = -1;      /* UplinkAdditionalTimeslots_LCR_r7 */
static int hf_rrc_satID = -1;                     /* SatID */
static int hf_rrc_doppler0thOrder = -1;           /* INTEGER_M2048_2047 */
static int hf_rrc_extraDopplerInfo = -1;          /* ExtraDopplerInfo */
static int hf_rrc_codePhase = -1;                 /* INTEGER_0_1022 */
static int hf_rrc_integerCodePhase = -1;          /* INTEGER_0_19 */
static int hf_rrc_gps_BitNumber = -1;             /* INTEGER_0_3 */
static int hf_rrc_codePhaseSearchWindow = -1;     /* CodePhaseSearchWindow */
static int hf_rrc_azimuthAndElevation = -1;       /* AzimuthAndElevation */
static int hf_rrc_azimuthAndElevation_01 = -1;    /* AzimuthAndElevation_va40ext */
static int hf_rrc_azimuthAndElevation_02 = -1;    /* AzimuthAndElevation_r10 */
static int hf_rrc_AcquisitionSatInfoList_item = -1;  /* AcquisitionSatInfo */
static int hf_rrc_AcquisitionSatInfoList_va40ext_item = -1;  /* AcquisitionSatInfo_va40ext */
static int hf_rrc_AcquisitionSatInfoList_r10_item = -1;  /* AcquisitionSatInfo_r10 */
static int hf_rrc_AdditionalMeasurementID_List_item = -1;  /* MeasurementIdentity */
static int hf_rrc_AdditionalMeasurementID_List_r9_item = -1;  /* MeasurementIdentity_r9 */
static int hf_rrc_dataID = -1;                    /* INTEGER_0_3 */
static int hf_rrc_e = -1;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_t_oa = -1;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_deltaI = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_omegaDot = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_satHealth = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_rrc_a_Sqrt = -1;                    /* BIT_STRING_SIZE_24 */
static int hf_rrc_omega0 = -1;                    /* BIT_STRING_SIZE_24 */
static int hf_rrc_m0 = -1;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_omega = -1;                     /* BIT_STRING_SIZE_24 */
static int hf_rrc_af0 = -1;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_af1 = -1;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_AlmanacSatInfoList_item = -1;   /* AlmanacSatInfo */
static int hf_rrc_sat_info_SBASecefList = -1;     /* GANSS_SAT_Info_Almanac_SBASecefList */
static int hf_rrc_sat_info_GLOkpList = -1;        /* GANSS_SAT_Info_Almanac_GLOkpList */
static int hf_rrc_t_oa_01 = -1;                   /* INTEGER_0_147 */
static int hf_rrc_iod_a = -1;                     /* INTEGER_0_3 */
static int hf_rrc_sat_info_kpList = -1;           /* GANSS_SAT_Info_Almanac_KpList */
static int hf_rrc_sat_info_MIDIkpList = -1;       /* GANSS_SAT_Info_Almanac_MIDIkpList */
static int hf_rrc_sat_info_NAVkpList = -1;        /* GANSS_SAT_Info_Almanac_NAVkpList */
static int hf_rrc_sat_info_REDkpList = -1;        /* GANSS_SAT_Info_Almanac_REDkpList */
static int hf_rrc_AuxInfoGANSS_ID1_item = -1;     /* AuxInfoGANSS_ID1_element */
static int hf_rrc_svID = -1;                      /* INTEGER_0_63 */
static int hf_rrc_signalsAvailable = -1;          /* BIT_STRING_SIZE_8 */
static int hf_rrc_AuxInfoGANSS_ID3_item = -1;     /* AuxInfoGANSS_ID3_element */
static int hf_rrc_channelNumber = -1;             /* INTEGER_M7_13 */
static int hf_rrc_azimuth = -1;                   /* INTEGER_0_31 */
static int hf_rrc_elevation = -1;                 /* INTEGER_0_7 */
static int hf_rrc_azimuthLSB = -1;                /* INTEGER_0_15 */
static int hf_rrc_elevationLSB = -1;              /* INTEGER_0_15 */
static int hf_rrc_BadSatList_item = -1;           /* INTEGER_0_63 */
static int hf_rrc_dl_TransportChannelBLER = -1;   /* DL_TransportChannelBLER */
static int hf_rrc_BLER_MeasurementResultsList_item = -1;  /* BLER_MeasurementResults */
static int hf_rrc_BLER_TransChIdList_item = -1;   /* TransportChannelIdentity */
static int hf_rrc_verifiedBSIC = -1;              /* INTEGER_0_maxCellMeas */
static int hf_rrc_nonVerifiedBSIC = -1;           /* BCCH_ARFCN */
static int hf_rrc_burstStart = -1;                /* INTEGER_0_15 */
static int hf_rrc_burstLength = -1;               /* INTEGER_10_25 */
static int hf_rrc_burstFreq = -1;                 /* INTEGER_1_16 */
static int hf_rrc_intraFreqReportingCriteria = -1;  /* IntraFreqReportingCriteria */
static int hf_rrc_periodicalReportingCriteria = -1;  /* PeriodicalReportingCriteria */
static int hf_rrc_intraFreqReportingCriteria_01 = -1;  /* IntraFreqReportingCriteria_LCR_r4 */
static int hf_rrc_patternIdentifier = -1;         /* INTEGER_0_maxMeasOccasionPattern_1 */
static int hf_rrc_statusFlag = -1;                /* T_statusFlag */
static int hf_rrc_measurementPurpose = -1;        /* BIT_STRING_SIZE_5 */
static int hf_rrc_measurementOccasionPatternParameter = -1;  /* MeasurementOccasionPatternParameter */
static int hf_rrc_cellDCHMeasOccasionSequenceList = -1;  /* SEQUENCE_SIZE_1_maxMeasOccasionPattern_OF_CellDCHMeasOccasionPattern_LCR */
static int hf_rrc_cellDCHMeasOccasionSequenceList_item = -1;  /* CellDCHMeasOccasionPattern_LCR */
static int hf_rrc_cellIndividualOffset = -1;      /* CellIndividualOffset */
static int hf_rrc_referenceTimeDifferenceToCell = -1;  /* ReferenceTimeDifferenceToCell */
static int hf_rrc_modeSpecificInfo_93 = -1;       /* T_modeSpecificInfo_93 */
static int hf_rrc_fdd_135 = -1;                   /* T_fdd_132 */
static int hf_rrc_readSFN_Indicator = -1;         /* BOOLEAN */
static int hf_rrc_tdd_89 = -1;                    /* T_tdd_83 */
static int hf_rrc_primaryCCPCH_Info_02 = -1;      /* PrimaryCCPCH_Info */
static int hf_rrc_timeslotInfoList = -1;          /* TimeslotInfoList */
static int hf_rrc_modeSpecificInfo_94 = -1;       /* T_modeSpecificInfo_94 */
static int hf_rrc_fdd_136 = -1;                   /* T_fdd_133 */
static int hf_rrc_tdd_90 = -1;                    /* T_tdd_84 */
static int hf_rrc_primaryCCPCH_Info_03 = -1;      /* PrimaryCCPCH_Info_r4 */
static int hf_rrc_timeslotInfoList_01 = -1;       /* TimeslotInfoList_r4 */
static int hf_rrc_cellSelectionReselectionInfo = -1;  /* CellSelectReselectInfoMC_RSCP */
static int hf_rrc_modeSpecificInfo_95 = -1;       /* T_modeSpecificInfo_95 */
static int hf_rrc_fdd_137 = -1;                   /* T_fdd_134 */
static int hf_rrc_tdd_91 = -1;                    /* T_tdd_85 */
static int hf_rrc_CellInfoListToBeExcluded_item = -1;  /* PrimaryCPICH_Info */
static int hf_rrc_modeSpecificInfo_96 = -1;       /* T_modeSpecificInfo_96 */
static int hf_rrc_fdd_138 = -1;                   /* T_fdd_135 */
static int hf_rrc_tdd_92 = -1;                    /* T_tdd_86 */
static int hf_rrc_cellSelectionReselectionInfo_01 = -1;  /* CellSelectReselectInfoSIB_11_12_RSCP */
static int hf_rrc_primaryCCPCH_Info_04 = -1;      /* PrimaryCCPCH_Info_LCR_r4 */
static int hf_rrc_timeslotInfoList_02 = -1;       /* TimeslotInfoList_LCR_r4 */
static int hf_rrc_modeSpecificInfo_97 = -1;       /* T_modeSpecificInfo_97 */
static int hf_rrc_fdd_139 = -1;                   /* T_fdd_136 */
static int hf_rrc_tdd_93 = -1;                    /* T_tdd_87 */
static int hf_rrc_cellSelectionReselectionInfo_02 = -1;  /* CellSelectReselectInfoSIB_11_12_ECN0 */
static int hf_rrc_modeSpecificInfo_98 = -1;       /* T_modeSpecificInfo_98 */
static int hf_rrc_fdd_140 = -1;                   /* T_fdd_137 */
static int hf_rrc_tdd_94 = -1;                    /* T_tdd_88 */
static int hf_rrc_cellSelectionReselectionInfo_03 = -1;  /* CellSelectReselectInfoSIB_11_12_HCS_RSCP */
static int hf_rrc_modeSpecificInfo_99 = -1;       /* T_modeSpecificInfo_99 */
static int hf_rrc_fdd_141 = -1;                   /* T_fdd_138 */
static int hf_rrc_tdd_95 = -1;                    /* T_tdd_89 */
static int hf_rrc_cellSelectionReselectionInfo_04 = -1;  /* CellSelectReselectInfoSIB_11_12_HCS_ECN0 */
static int hf_rrc_cellIdentity = -1;              /* CellIdentity */
static int hf_rrc_dummy_50 = -1;                  /* SFN_SFN_ObsTimeDifference */
static int hf_rrc_cellSynchronisationInfo = -1;   /* CellSynchronisationInfo */
static int hf_rrc_modeSpecificInfo_100 = -1;      /* T_modeSpecificInfo_100 */
static int hf_rrc_fdd_142 = -1;                   /* T_fdd_139 */
static int hf_rrc_cpich_Ec_N0_01 = -1;            /* CPICH_Ec_N0 */
static int hf_rrc_cpich_RSCP_01 = -1;             /* CPICH_RSCP */
static int hf_rrc_pathloss = -1;                  /* Pathloss */
static int hf_rrc_tdd_96 = -1;                    /* T_tdd_90 */
static int hf_rrc_proposedTGSN = -1;              /* TGSN */
static int hf_rrc_timeslotISCP_List = -1;         /* TimeslotISCP_List */
static int hf_rrc_modeSpecificInfo_101 = -1;      /* T_modeSpecificInfo_101 */
static int hf_rrc_fdd_143 = -1;                   /* T_fdd_140 */
static int hf_rrc_deltaRSCPPerCell = -1;          /* DeltaRSCPPerCell */
static int hf_rrc_tdd_97 = -1;                    /* T_tdd_91 */
static int hf_rrc_csgIdentity = -1;               /* CSG_Identity */
static int hf_rrc_csgMemberIndication = -1;       /* T_csgMemberIndication */
static int hf_rrc_fdd_144 = -1;                   /* SEQUENCE_SIZE_1_maxCellMeas_OF_PrimaryCPICH_Info */
static int hf_rrc_fdd_item_01 = -1;               /* PrimaryCPICH_Info */
static int hf_rrc_tdd_98 = -1;                    /* SEQUENCE_SIZE_1_maxCellMeas_OF_PrimaryCCPCH_Info */
static int hf_rrc_tdd_item_02 = -1;               /* PrimaryCCPCH_Info */
static int hf_rrc_fdd_145 = -1;                   /* SEQUENCE_SIZE_1_maxCellMeasOnSecULFreq_OF_PrimaryCPICH_Info */
static int hf_rrc_CellMeasurementEventResults_LCR_r4_item = -1;  /* PrimaryCCPCH_Info_LCR_r4 */
static int hf_rrc_dummy_51 = -1;                  /* SFN_SFN_OTD_Type */
static int hf_rrc_cellIdentity_reportingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_cellSynchronisationInfoReportingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_102 = -1;      /* T_modeSpecificInfo_102 */
static int hf_rrc_fdd_146 = -1;                   /* T_fdd_141 */
static int hf_rrc_cpich_Ec_N0_reportingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_cpich_RSCP_reportingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_pathloss_reportingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_tdd_99 = -1;                    /* T_tdd_92 */
static int hf_rrc_timeslotISCP_reportingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_proposedTGSN_ReportingRequired = -1;  /* BOOLEAN */
static int hf_rrc_primaryCCPCH_RSCP_reportingIndicator = -1;  /* BOOLEAN */
static int hf_rrc_q_OffsetS_N = -1;               /* Q_OffsetS_N */
static int hf_rrc_hcs_NeighbouringCellInformation_RSCP = -1;  /* HCS_NeighbouringCellInformation_RSCP */
static int hf_rrc_modeSpecificInfo_103 = -1;      /* T_modeSpecificInfo_103 */
static int hf_rrc_fdd_147 = -1;                   /* T_fdd_142 */
static int hf_rrc_tdd_100 = -1;                   /* T_tdd_93 */
static int hf_rrc_gsm_03 = -1;                    /* T_gsm_03 */
static int hf_rrc_q_Offset1S_N = -1;              /* Q_OffsetS_N */
static int hf_rrc_q_Offset2S_N = -1;              /* Q_OffsetS_N */
static int hf_rrc_modeSpecificInfo_104 = -1;      /* T_modeSpecificInfo_104 */
static int hf_rrc_fdd_148 = -1;                   /* T_fdd_143 */
static int hf_rrc_tdd_101 = -1;                   /* T_tdd_94 */
static int hf_rrc_gsm_04 = -1;                    /* T_gsm_04 */
static int hf_rrc_modeSpecificInfo_105 = -1;      /* T_modeSpecificInfo_105 */
static int hf_rrc_fdd_149 = -1;                   /* T_fdd_144 */
static int hf_rrc_tdd_102 = -1;                   /* T_tdd_95 */
static int hf_rrc_gsm_05 = -1;                    /* T_gsm_05 */
static int hf_rrc_modeSpecificInfo_106 = -1;      /* T_modeSpecificInfo_106 */
static int hf_rrc_fdd_150 = -1;                   /* T_fdd_145 */
static int hf_rrc_tdd_103 = -1;                   /* T_tdd_96 */
static int hf_rrc_gsm_06 = -1;                    /* T_gsm_06 */
static int hf_rrc_modeSpecificInfo_107 = -1;      /* T_modeSpecificInfo_107 */
static int hf_rrc_fdd_151 = -1;                   /* T_fdd_146 */
static int hf_rrc_tdd_104 = -1;                   /* T_tdd_97 */
static int hf_rrc_gsm_07 = -1;                    /* T_gsm_07 */
static int hf_rrc_hcs_NeighbouringCellInformation_ECN0 = -1;  /* HCS_NeighbouringCellInformation_ECN0 */
static int hf_rrc_modeSpecificInfo_108 = -1;      /* T_modeSpecificInfo_108 */
static int hf_rrc_fdd_152 = -1;                   /* T_fdd_147 */
static int hf_rrc_tdd_105 = -1;                   /* T_tdd_98 */
static int hf_rrc_gsm_08 = -1;                    /* T_gsm_08 */
static int hf_rrc_deltaQrxlevmin = -1;            /* DeltaQrxlevmin */
static int hf_rrc_deltaQhcs = -1;                 /* DeltaRSCP */
static int hf_rrc_q_Hyst_l_S_PCH = -1;            /* Q_Hyst_S_Fine */
static int hf_rrc_q_Hyst_l_S_FACH = -1;           /* Q_Hyst_S_Fine */
static int hf_rrc_q_Hyst_2_S_PCH = -1;            /* Q_Hyst_S_Fine */
static int hf_rrc_q_Hyst_2_S_FACH = -1;           /* Q_Hyst_S_Fine */
static int hf_rrc_t_Reselection_S_PCH = -1;       /* T_Reselection_S */
static int hf_rrc_t_Reselection_S_FACH = -1;      /* T_Reselection_S_Fine */
static int hf_rrc_non_HCS_t_CR_Max = -1;          /* T_CRMax */
static int hf_rrc_speedDependentScalingFactor = -1;  /* SpeedDependentScalingFactor */
static int hf_rrc_interFrequencyTreselectionScalingFactor = -1;  /* TreselectionScalingFactor */
static int hf_rrc_interRATTreselectionScalingFactor = -1;  /* TreselectionScalingFactor */
static int hf_rrc_CellsForInterFreqMeasList_item = -1;  /* InterFreqCellID */
static int hf_rrc_CellsForInterRATMeasList_item = -1;  /* InterRATCellID */
static int hf_rrc_CellsForIntraFreqMeasList_item = -1;  /* IntraFreqCellID */
static int hf_rrc_CellsForIntraFreqMeasListOnSecULFreq_item = -1;  /* IntraFreqCellIDOnSecULFreq */
static int hf_rrc_modeSpecificInfo_109 = -1;      /* T_modeSpecificInfo_109 */
static int hf_rrc_fdd_153 = -1;                   /* T_fdd_148 */
static int hf_rrc_countC_SFN_Frame_difference = -1;  /* CountC_SFN_Frame_difference */
static int hf_rrc_tm = -1;                        /* INTEGER_0_38399 */
static int hf_rrc_tdd_106 = -1;                   /* T_tdd_99 */
static int hf_rrc_bsicReported = -1;              /* BSICReported */
static int hf_rrc_CellToReportList_item = -1;     /* CellToReport */
static int hf_rrc_cnavToc = -1;                   /* BIT_STRING_SIZE_11 */
static int hf_rrc_cnavTop = -1;                   /* BIT_STRING_SIZE_11 */
static int hf_rrc_cnavURA0 = -1;                  /* BIT_STRING_SIZE_5 */
static int hf_rrc_cnavURA1 = -1;                  /* BIT_STRING_SIZE_3 */
static int hf_rrc_cnavURA2 = -1;                  /* BIT_STRING_SIZE_3 */
static int hf_rrc_cnavAf2 = -1;                   /* BIT_STRING_SIZE_10 */
static int hf_rrc_cnavAf1 = -1;                   /* BIT_STRING_SIZE_20 */
static int hf_rrc_cnavAf0 = -1;                   /* BIT_STRING_SIZE_26 */
static int hf_rrc_cnavTgd = -1;                   /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl1cp = -1;               /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl1cd = -1;               /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl1ca = -1;               /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl2c = -1;                /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl5i5 = -1;               /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl5q5 = -1;               /* BIT_STRING_SIZE_13 */
static int hf_rrc_countC_SFN_High = -1;           /* INTEGER_0_15 */
static int hf_rrc_off = -1;                       /* INTEGER_0_255 */
static int hf_rrc_modeSpecificInfo_110 = -1;      /* T_modeSpecificInfo_110 */
static int hf_rrc_fdd_154 = -1;                   /* T_fdd_149 */
static int hf_rrc_startPSC_01 = -1;               /* PrimaryCPICH_Info */
static int hf_rrc_numberOfPSCs_01 = -1;           /* INTEGER_1_512 */
static int hf_rrc_CSGCellInfoList_item = -1;      /* CSGCellInfo */
static int hf_rrc_cSGInterFreqCellInfoListperFreq = -1;  /* CSGCellInfoList */
static int hf_rrc_CSGInterFreqCellInfoList_item = -1;  /* CSGInterFreqCellInfo */
static int hf_rrc_uTRACSGProximityDetec = -1;     /* T_uTRACSGProximityDetec */
static int hf_rrc_e_UTRACSGProximityDetec = -1;   /* T_e_UTRACSGProximityDetec */
static int hf_rrc_cSGproximityInd = -1;           /* T_cSGproximityInd */
static int hf_rrc_radioAccessTechnology_02 = -1;  /* T_radioAccessTechnology_02 */
static int hf_rrc_uTRA = -1;                      /* T_uTRA */
static int hf_rrc_cSGFrequencyInfoUTRA = -1;      /* FrequencyInfo */
static int hf_rrc_e_UTRA = -1;                    /* T_e_UTRA */
static int hf_rrc_cSGFrequencyInfoEUTRA = -1;     /* EARFCN */
static int hf_rrc_cSGFrequencyInfoEUTRA_01 = -1;  /* EARFCNExtension */
static int hf_rrc_ganss_signal_id = -1;           /* GANSS_Signal_Id */
static int hf_rrc_data_bits = -1;                 /* BIT_STRING_SIZE_1_1024 */
static int hf_rrc_DataBitAssistanceList_item = -1;  /* DataBitAssistanceSat */
static int hf_rrc_satID_01 = -1;                  /* INTEGER_0_63 */
static int hf_rrc_dataBitAssistanceSgnList = -1;  /* DataBitAssistanceSgnList */
static int hf_rrc_DataBitAssistanceSgnList_item = -1;  /* DataBitAssistance */
static int hf_rrc_deltaRSCP = -1;                 /* DeltaRSCP */
static int hf_rrc_b1 = -1;                        /* BIT_STRING_SIZE_11 */
static int hf_rrc_b2 = -1;                        /* BIT_STRING_SIZE_10 */
static int hf_rrc_ganssSignalId = -1;             /* GANSS_Signal_Id */
static int hf_rrc_ganssStatusHealth = -1;         /* GANSS_Status_Health */
static int hf_rrc_dgansssignalInformationList = -1;  /* DGANSSSignalInformationList */
static int hf_rrc_dgansssignalInformationList_01 = -1;  /* DGANSSSignalInformationList_r9 */
static int hf_rrc_dgansssignalInformationList_02 = -1;  /* DGANSSSignalInformationList_v920ext */
static int hf_rrc_DGANSSInfoList_item = -1;       /* DGANSSInfo */
static int hf_rrc_DGANSSInfoList_r9_item = -1;    /* DGANSSInfo_r9 */
static int hf_rrc_DGANSSInfoList_v920ext_item = -1;  /* DGANSSInfo_v920ext */
static int hf_rrc_satId = -1;                     /* INTEGER_0_63 */
static int hf_rrc_iode_dganss = -1;               /* BIT_STRING_SIZE_10 */
static int hf_rrc_udre = -1;                      /* UDRE */
static int hf_rrc_ganss_prc = -1;                 /* INTEGER_M2047_2047 */
static int hf_rrc_ganss_rrc = -1;                 /* INTEGER_M127_127 */
static int hf_rrc_udreGrowthRate = -1;            /* UDREGrowthRate */
static int hf_rrc_udreValidityTime = -1;          /* UDREValidityTime */
static int hf_rrc_DGANSSSignalInformationList_item = -1;  /* DGANSSSignalInformation */
static int hf_rrc_DGANSSSignalInformationList_r9_item = -1;  /* DGANSSSignalInformation_r9 */
static int hf_rrc_DGANSSSignalInformationList_v920ext_item = -1;  /* DGANSSSignalInformation_v920ext */
static int hf_rrc_iode = -1;                      /* IODE */
static int hf_rrc_prc = -1;                       /* PRC */
static int hf_rrc_rrc = -1;                       /* RRC */
static int hf_rrc_dummy1_05 = -1;                 /* DeltaPRC */
static int hf_rrc_dummy2_11 = -1;                 /* DeltaRRC */
static int hf_rrc_dummy3_02 = -1;                 /* DeltaPRC */
static int hf_rrc_dummy4_01 = -1;                 /* DeltaRRC */
static int hf_rrc_DGPS_CorrectionSatInfoList_item = -1;  /* DGPS_CorrectionSatInfo */
static int hf_rrc_DGPS_CorrectionSatInfoList_r9_item = -1;  /* DGPS_CorrectionSatInfo_r9 */
static int hf_rrc_DGPS_CorrectionSatInfoList_v920ext_item = -1;  /* DGPS_CorrectionSatInfo_v920ext */
static int hf_rrc_latitudeSign = -1;              /* T_latitudeSign */
static int hf_rrc_latitude = -1;                  /* INTEGER_0_8388607 */
static int hf_rrc_longitude = -1;                 /* INTEGER_M8388608_8388607 */
static int hf_rrc_latitudeSign_01 = -1;           /* T_latitudeSign_01 */
static int hf_rrc_altitudeDirection = -1;         /* T_altitudeDirection */
static int hf_rrc_altitude = -1;                  /* INTEGER_0_32767 */
static int hf_rrc_latitudeSign_02 = -1;           /* T_latitudeSign_02 */
static int hf_rrc_altitudeDirection_01 = -1;      /* T_altitudeDirection_01 */
static int hf_rrc_uncertaintySemiMajor = -1;      /* INTEGER_0_127 */
static int hf_rrc_uncertaintySemiMinor = -1;      /* INTEGER_0_127 */
static int hf_rrc_orientationMajorAxis = -1;      /* INTEGER_0_89 */
static int hf_rrc_uncertaintyAltitude = -1;       /* INTEGER_0_127 */
static int hf_rrc_confidence = -1;                /* INTEGER_0_100 */
static int hf_rrc_latitudeSign_03 = -1;           /* T_latitudeSign_03 */
static int hf_rrc_uncertaintyCode = -1;           /* INTEGER_0_127 */
static int hf_rrc_latitudeSign_04 = -1;           /* T_latitudeSign_04 */
static int hf_rrc_reportedCells = -1;             /* SEQUENCE_SIZE_1_maxReportedEUTRACellPerFreq_OF_EUTRA_PhysicalCellIdentity */
static int hf_rrc_reportedCells_item = -1;        /* EUTRA_PhysicalCellIdentity */
static int hf_rrc_earfcn_01 = -1;                 /* EARFCNExtension */
static int hf_rrc_Eutra_EventResultList_item = -1;  /* Eutra_EventResult */
static int hf_rrc_EUTRA_EventResultList_vb50ext_item = -1;  /* EUTRA_EventResult_vb50ext */
static int hf_rrc_eventID = -1;                   /* EventIDInterRAT */
static int hf_rrc_eutra_EventResultsList = -1;    /* Eutra_EventResultList */
static int hf_rrc_eutra_EventResultsList_01 = -1;  /* EUTRA_EventResultList_vb50ext */
static int hf_rrc_eutraFrequencyIndicator = -1;   /* BIT_STRING_SIZE_maxNumEUTRAFreqs_FACH */
static int hf_rrc_measurementBandwidth = -1;      /* EUTRA_MeasurementBandwidth */
static int hf_rrc_qRxLevMinEUTRA = -1;            /* INTEGER_M70_M22 */
static int hf_rrc_threshXhigh = -1;               /* INTEGER_0_31 */
static int hf_rrc_threshXlow = -1;                /* INTEGER_0_31 */
static int hf_rrc_eutra_blackListedCellList = -1;  /* EUTRA_BlacklistedCellPerFreqList */
static int hf_rrc_qqualMinEUTRA = -1;             /* INTEGER_M34_M3 */
static int hf_rrc_threshXhigh2 = -1;              /* INTEGER_0_31 */
static int hf_rrc_threshXlow2 = -1;               /* INTEGER_0_31 */
static int hf_rrc_qqualMinEUTRA_WB = -1;          /* INTEGER_M34_M3 */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoExtensionList_item = -1;  /* EUTRA_FrequencyAndPriorityInfoExtension_vb50ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_item = -1;  /* EUTRA_FrequencyAndPriorityInfo */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_v920ext_item = -1;  /* EUTRA_FrequencyAndPriorityInfo_v920ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_vb50ext_item = -1;  /* EUTRA_FrequencyAndPriorityInfo_vb50ext */
static int hf_rrc_eutraFrequencyRemoval = -1;     /* EUTRA_FrequencyRemoval */
static int hf_rrc_eutraNewFrequencies = -1;       /* EUTRA_FrequencyInfoList */
static int hf_rrc_eutraSIAcquisition = -1;        /* EUTRA_SIAcquisition */
static int hf_rrc_eutraFrequencyRemoval_01 = -1;  /* EUTRA_FrequencyRemoval_r11 */
static int hf_rrc_eutraNewFrequencies_01 = -1;    /* EUTRA_FrequencyInfoList_r11 */
static int hf_rrc_eutraSIAcquisition_01 = -1;     /* EUTRA_SIAcquisition_r11 */
static int hf_rrc_physicalCellIdentity = -1;      /* EUTRA_PhysicalCellIdentity */
static int hf_rrc_rSRP = -1;                      /* INTEGER_0_97 */
static int hf_rrc_rSRQ = -1;                      /* INTEGER_0_33 */
static int hf_rrc_measuredEUTRACells = -1;        /* SEQUENCE_SIZE_1_maxReportedEUTRACellPerFreq_OF_EUTRA_MeasuredCells */
static int hf_rrc_measuredEUTRACells_item = -1;   /* EUTRA_MeasuredCells */
static int hf_rrc_Eutra_MeasuredResultList_item = -1;  /* Eutra_MeasuredResult */
static int hf_rrc_EUTRA_MeasuredResultList_vb50ext_item = -1;  /* EUTRA_MeasuredResult_vb50ext */
static int hf_rrc_eutraMeasuredResultList = -1;   /* Eutra_MeasuredResultList */
static int hf_rrc_eutraMeasuredResultList_01 = -1;  /* EUTRA_MeasuredResultList_vb50ext */
static int hf_rrc_eutraSIacquisitionResults = -1;  /* EUTRA_SIacquisitionResults */
static int hf_rrc_measuredEUTRACells_v920ext = -1;  /* SEQUENCE_SIZE_1_maxReportedEUTRACellPerFreq_OF_EUTRA_MeasuredCells_v920ext */
static int hf_rrc_measuredEUTRACells_v920ext_item = -1;  /* EUTRA_MeasuredCells_v920ext */
static int hf_rrc_Eutra_MeasuredResultList_v920ext_item = -1;  /* Eutra_MeasuredResult_v920ext */
static int hf_rrc_eutraMeasuredResultList_v920ext = -1;  /* Eutra_MeasuredResultList_v920ext */
static int hf_rrc_cgiInfo = -1;                   /* T_cgiInfo */
static int hf_rrc_cellIdentity_01 = -1;           /* BIT_STRING_SIZE_28 */
static int hf_rrc_trackingAreaCode = -1;          /* BIT_STRING_SIZE_16 */
static int hf_rrc_csgMemberIndication_01 = -1;    /* T_csgMemberIndication_01 */
static int hf_rrc_removeAllFrequencies = -1;      /* NULL */
static int hf_rrc_removeSomeFrequencies = -1;     /* SEQUENCE_SIZE_1_maxNumEUTRAFreqs_OF_EARFCN */
static int hf_rrc_removeSomeFrequencies_item = -1;  /* EARFCN */
static int hf_rrc_removeNoFrequencies = -1;       /* NULL */
static int hf_rrc_removeSomeFrequencies_01 = -1;  /* FrequenciesToRemove */
static int hf_rrc_EUTRA_FrequencyInfoList_item = -1;  /* EUTRA_FrequencyInfo */
static int hf_rrc_EUTRA_FrequencyInfoList_r11_item = -1;  /* EUTRA_FrequencyInfo_r11 */
static int hf_rrc_widebandRSRQMeasurements = -1;  /* T_widebandRSRQMeasurements */
static int hf_rrc_eutra_FrequencyListIndicator = -1;  /* BIT_STRING_SIZE_maxNumEUTRAFreqs */
static int hf_rrc_eutra_FrequencyRepQuantityRACH = -1;  /* T_eutra_FrequencyRepQuantityRACH */
static int hf_rrc_eutra_FrequencyRACHReportingThreshold = -1;  /* INTEGER_0_97 */
static int hf_rrc_rachReportingPriority = -1;     /* T_rachReportingPriority */
static int hf_rrc_eutraFrequenciesForMeasurement = -1;  /* SEQUENCE_SIZE_1_maxNumEUTRAFreqs_FACH_OF_EARFCNRange */
static int hf_rrc_eutraFrequenciesForMeasurement_item = -1;  /* EARFCNRange */
static int hf_rrc_reportCriteria = -1;            /* T_reportCriteria */
static int hf_rrc_measurementQuantity = -1;       /* T_measurementQuantity */
static int hf_rrc_reportingThreshold = -1;        /* INTEGER_0_97 */
static int hf_rrc_FrequenciesToRemove_item = -1;  /* EARFCNRange */
static int hf_rrc_triggeringCondition = -1;       /* TriggeringCondition2 */
static int hf_rrc_forbiddenAffectCellList = -1;   /* ForbiddenAffectCellList */
static int hf_rrc_w = -1;                         /* W */
static int hf_rrc_reportDeactivationThreshold = -1;  /* ReportDeactivationThreshold */
static int hf_rrc_reportingAmount = -1;           /* ReportingAmount */
static int hf_rrc_reportingInterval = -1;         /* ReportingInterval */
static int hf_rrc_forbiddenAffectCellList_01 = -1;  /* ForbiddenAffectCellList_r4 */
static int hf_rrc_forbiddenAffectCellListOnSecULFreq = -1;  /* ForbiddenAffectCellListOnSecULFreq */
static int hf_rrc_forbiddenAffectCellList_02 = -1;  /* ForbiddenAffectCellList_LCR_r4 */
static int hf_rrc_triggeringCondition_01 = -1;    /* TriggeringCondition1 */
static int hf_rrc_periodicReportingInfo_1b = -1;  /* PeriodicReportingInfo_1b */
static int hf_rrc_replacementActivationThreshold = -1;  /* ReplacementActivationThreshold */
static int hf_rrc_useCIO = -1;                    /* BOOLEAN */
static int hf_rrc_thresholdUsedFrequency = -1;    /* ThresholdUsedFrequency */
static int hf_rrc_thresholdUsedFrequency_01 = -1;  /* ThresholdUsedFrequency_r6 */
static int hf_rrc_dummy_52 = -1;                  /* Threshold */
static int hf_rrc_usedFreqW = -1;                 /* W */
static int hf_rrc_hysteresis = -1;                /* HysteresisInterFreq */
static int hf_rrc_timeToTrigger = -1;             /* TimeToTrigger */
static int hf_rrc_reportingCellStatus = -1;       /* ReportingCellStatus */
static int hf_rrc_nonUsedFreqParameterList = -1;  /* NonUsedFreqParameterList */
static int hf_rrc_nonUsedFreqParameterList_01 = -1;  /* NonUsedFreqWList_r6 */
static int hf_rrc_reportingCellStatus_01 = -1;    /* ReportingCellStatus_r10 */
static int hf_rrc_nonUsedFreqParameterList_02 = -1;  /* NonUsedFreq2aParameterList_r10 */
static int hf_rrc_nonUsedFreqParameterList_03 = -1;  /* NonUsedFreq2aParameterList_r11 */
static int hf_rrc_usedFreqThreshold = -1;         /* Threshold */
static int hf_rrc_usedFreqThreshold_01 = -1;      /* Threshold_r6 */
static int hf_rrc_nonUsedFreqParameterList_04 = -1;  /* NonUsedFreqParameterList_r6 */
static int hf_rrc_nonUsedFreqParameterList_05 = -1;  /* NonUsedFreqParameterList_r10 */
static int hf_rrc_nonUsedFreqParameterList_06 = -1;  /* NonUsedFreqParameterList_r11 */
static int hf_rrc_thresholdOwnSystem = -1;        /* Threshold */
static int hf_rrc_thresholdOtherSystem = -1;      /* Threshold */
static int hf_rrc_hysteresis_01 = -1;             /* Hysteresis */
static int hf_rrc_intraFreqEventResults = -1;     /* IntraFreqEventResults */
static int hf_rrc_interFreqEventResults = -1;     /* InterFreqEventResults */
static int hf_rrc_interRATEventResults = -1;      /* InterRATEventResults */
static int hf_rrc_trafficVolumeEventResults = -1;  /* TrafficVolumeEventResults */
static int hf_rrc_qualityEventResults = -1;       /* QualityEventResults */
static int hf_rrc_ue_InternalEventResults = -1;   /* UE_InternalEventResults */
static int hf_rrc_ue_positioning_MeasurementEventResults = -1;  /* UE_Positioning_MeasurementEventResults */
static int hf_rrc_ue_positioning_MeasurementEventResults_01 = -1;  /* UE_Positioning_MeasurementEventResults_v770ext */
static int hf_rrc_ue_positioning_MeasurementEventResults_02 = -1;  /* UE_Positioning_MeasurementEventResults_v860ext */
static int hf_rrc_interFreqEventResults_01 = -1;  /* InterFreqEventResults_va40ext */
static int hf_rrc_intraFreqEventResults_01 = -1;  /* IntraFreqEventResultsOnSecUlFreq */
static int hf_rrc_dopplerFirstOrder = -1;         /* INTEGER_M42_21 */
static int hf_rrc_dopplerUncertainty = -1;        /* T_dopplerUncertainty */
static int hf_rrc_doppler1stOrder = -1;           /* INTEGER_M42_21 */
static int hf_rrc_dopplerUncertainty_01 = -1;     /* DopplerUncertainty */
static int hf_rrc_fACH_meas_occasion_coeff = -1;  /* INTEGER_1_12 */
static int hf_rrc_inter_freq_FDD_meas_ind = -1;   /* BOOLEAN */
static int hf_rrc_inter_freq_TDD_meas_ind = -1;   /* BOOLEAN */
static int hf_rrc_inter_RAT_meas_ind = -1;        /* SEQUENCE_SIZE_1_maxOtherRAT_OF_RAT_Type */
static int hf_rrc_inter_RAT_meas_ind_item = -1;   /* RAT_Type */
static int hf_rrc_inter_freq_TDD128_meas_ind = -1;  /* BOOLEAN */
static int hf_rrc_fdd_155 = -1;                   /* PrimaryCPICH_Info */
static int hf_rrc_tdd_107 = -1;                   /* PrimaryCCPCH_Info_LCR_r4 */
static int hf_rrc_ForbiddenAffectCellList_item = -1;  /* ForbiddenAffectCell */
static int hf_rrc_ForbiddenAffectCellList_r4_item = -1;  /* ForbiddenAffectCell_r4 */
static int hf_rrc_ForbiddenAffectCellList_LCR_r4_item = -1;  /* ForbiddenAffectCell_LCR_r4 */
static int hf_rrc_ForbiddenAffectCellListOnSecULFreq_item = -1;  /* ForbiddenAffectCellOnSecULFreq */
static int hf_rrc_primaryCPICH = -1;              /* PrimaryCPICH_Info */
static int hf_rrc_ganssTod = -1;                  /* INTEGER_0_86399 */
static int hf_rrc_dataBitAssistance = -1;         /* ReqDataBitAssistance */
static int hf_rrc_ganssId = -1;                   /* INTEGER_0_7 */
static int hf_rrc_ganssTimeModelsList = -1;       /* GANSSTimeModelsList */
static int hf_rrc_uePositioningDGANSSCorrections = -1;  /* UE_Positioning_DGANSSCorrections */
static int hf_rrc_uePositioningGANSSNavigationModel = -1;  /* UE_Positioning_GANSS_NavigationModel */
static int hf_rrc_uePositioningGANSSRealTimeIntegrity = -1;  /* UE_Positioning_GANSS_RealTimeIntegrity */
static int hf_rrc_uePositioningGANSSDataBitAssistance = -1;  /* UE_Positioning_GANSS_Data_Bit_Assistance */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo = -1;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo */
static int hf_rrc_uePositioningGANSSAlmanac = -1;  /* UE_Positioning_GANSS_Almanac */
static int hf_rrc_uePositioningGANSSUTCModel = -1;  /* UE_Positioning_GANSS_UTCModel */
static int hf_rrc_uePositiningGANSSsbasID = -1;   /* UE_Positioning_GANSS_SBAS_ID */
static int hf_rrc_uePositioningGANSSAddNavigationModels = -1;  /* UE_Positioning_GANSS_AddNavigationModels */
static int hf_rrc_uePositioningGANSSAlmanac_01 = -1;  /* UE_Positioning_GANSS_Almanac_v860ext */
static int hf_rrc_uePositioningGANSSAddUTCModels = -1;  /* UE_Positioning_GANSS_AddUTCModels */
static int hf_rrc_uePositioningGANSSAuxiliaryInfo = -1;  /* UE_Positioning_GANSS_AuxiliaryInfo */
static int hf_rrc_uePositioningGANSSAlmanac_02 = -1;  /* UE_Positioning_GANSS_Almanac_r8 */
static int hf_rrc_uePositioningDGANSSCorrections_01 = -1;  /* UE_Positioning_DGANSSCorrections_r9 */
static int hf_rrc_uePositioningDGANSSCorrections_02 = -1;  /* UE_Positioning_DGANSSCorrections_v920ext */
static int hf_rrc_ganssTimeModelsList_01 = -1;    /* GANSSTimeModelsList_va40ext */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo_01 = -1;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_va40ext */
static int hf_rrc_uePositioningGANSSAlmanac_03 = -1;  /* UE_Positioning_GANSS_Almanac_va40ext */
static int hf_rrc_ganssTimeModelsList_02 = -1;    /* GANSSTimeModelsList_r10 */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo_02 = -1;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_r10 */
static int hf_rrc_uePositioningGANSSAlmanac_04 = -1;  /* UE_Positioning_GANSS_Almanac_r10 */
static int hf_rrc_GANSSGenericDataList_item = -1;  /* GANSSGenericData */
static int hf_rrc_GANSSGenericDataList_v860ext_item = -1;  /* GANSSGenericData_v860ext */
static int hf_rrc_GANSSGenericDataList_r8_item = -1;  /* GANSSGenericData_r8 */
static int hf_rrc_GANSSGenericDataList_r9_item = -1;  /* GANSSGenericData_r9 */
static int hf_rrc_GANSSGenericDataList_v920ext_item = -1;  /* GANSSGenericData_v920ext */
static int hf_rrc_GANSSGenericDataList_va40ext_item = -1;  /* GANSSGenericData_va40ext */
static int hf_rrc_GANSSGenericDataList_r10_item = -1;  /* GANSSGenericData_r10 */
static int hf_rrc_GANSSGenericMeasurementInfo_item = -1;  /* GANSSGenericMeasurementInfo_item */
static int hf_rrc_ganssMeasurementSignalList = -1;  /* GANSSMeasurementSignalList */
static int hf_rrc_GANSSGenericMeasurementInfo_v860ext_item = -1;  /* GANSSGenericMeasurementInfo_v860ext_item */
static int hf_rrc_ganssMeasurementSignalList_01 = -1;  /* GANSSMeasurementSignalList_v860ext */
static int hf_rrc_GANSSMeasurementParameters_item = -1;  /* GANSSMeasurementParameters_item */
static int hf_rrc_cSurNzero = -1;                 /* INTEGER_0_63 */
static int hf_rrc_multipathIndicator = -1;        /* T_multipathIndicator */
static int hf_rrc_carrierQualityIndication = -1;  /* BIT_STRING_SIZE_2 */
static int hf_rrc_ganssCodePhase = -1;            /* INTEGER_0_2097151 */
static int hf_rrc_ganssIntegerCodePhase = -1;     /* INTEGER_0_63 */
static int hf_rrc_codePhaseRmsError = -1;         /* INTEGER_0_63 */
static int hf_rrc_doppler = -1;                   /* INTEGER_M32768_32767 */
static int hf_rrc_adr = -1;                       /* INTEGER_0_33554431 */
static int hf_rrc_GANSSMeasurementParameters_v860ext_item = -1;  /* GANSSMeasurementParameters_v860ext_item */
static int hf_rrc_ganssIntegerCodePhaseExt = -1;  /* INTEGER_64_127 */
static int hf_rrc_GANSSMeasurementSignalList_item = -1;  /* GANSSMeasurementSignalList_item */
static int hf_rrc_ganssCodePhaseAmbiguity = -1;   /* INTEGER_0_31 */
static int hf_rrc_ganssMeasurementParameters = -1;  /* GANSSMeasurementParameters */
static int hf_rrc_GANSSMeasurementSignalList_v860ext_item = -1;  /* GANSSMeasurementSignalList_v860ext_item */
static int hf_rrc_ganssCodePhaseAmbiguityExt = -1;  /* INTEGER_32_127 */
static int hf_rrc_ganssMeasurementParameters_01 = -1;  /* GANSSMeasurementParameters_v860ext */
static int hf_rrc_ganssWeek = -1;                 /* INTEGER_0_4095 */
static int hf_rrc_ganssToe = -1;                  /* INTEGER_0_167 */
static int hf_rrc_t_toeLimit = -1;                /* INTEGER_0_10 */
static int hf_rrc_satellitesListRelatedDataList = -1;  /* SatellitesListRelatedDataList */
static int hf_rrc_gANSS_tod = -1;                 /* INTEGER_0_3599999 */
static int hf_rrc_gANSS_timeId = -1;              /* INTEGER_0_7 */
static int hf_rrc_gANSS_tod_uncertainty = -1;     /* INTEGER_0_127 */
static int hf_rrc_ganssRealTimeIntegrity = -1;    /* BOOLEAN */
static int hf_rrc_ganssDifferentialCorrection = -1;  /* DGANSS_Sig_Id_Req */
static int hf_rrc_ganssAlmanac = -1;              /* BOOLEAN */
static int hf_rrc_ganssNavigationModel = -1;      /* BOOLEAN */
static int hf_rrc_ganssTimeModelGNSS_GNSS = -1;   /* BIT_STRING_SIZE_8 */
static int hf_rrc_ganssReferenceMeasurementInfo = -1;  /* BOOLEAN */
static int hf_rrc_ganssDataBits = -1;             /* GanssDataBits */
static int hf_rrc_ganssUTCModel = -1;             /* BOOLEAN */
static int hf_rrc_ganssNavigationModelAdditionalData = -1;  /* GanssNavigationModelAdditionalData */
static int hf_rrc_sbasId = -1;                    /* UE_Positioning_GANSS_SBAS_ID */
static int hf_rrc_ganssAddNavigationModel = -1;   /* T_ganssAddNavigationModel */
static int hf_rrc_ganssAddUTCmodel = -1;          /* T_ganssAddUTCmodel */
static int hf_rrc_ganssAuxInfo = -1;              /* T_ganssAuxInfo */
static int hf_rrc_ganssAddADchoices = -1;         /* T_ganssAddADchoices */
static int hf_rrc_orbitModelID = -1;              /* INTEGER_0_7 */
static int hf_rrc_clockModelID = -1;              /* INTEGER_0_7 */
static int hf_rrc_utcModelID = -1;                /* INTEGER_0_7 */
static int hf_rrc_almanacModelID = -1;            /* INTEGER_0_7 */
static int hf_rrc_GanssRequestedGenericAssistanceDataList_item = -1;  /* GanssReqGenericData */
static int hf_rrc_GanssRequestedGenericAssistanceDataList_v860ext_item = -1;  /* GanssReqGenericData_v860ext */
static int hf_rrc_ganssSatId = -1;                /* INTEGER_0_63 */
static int hf_rrc_dopplerZeroOrder = -1;          /* INTEGER_M2048_2047 */
static int hf_rrc_extraDoppler = -1;              /* ExtraDoppler */
static int hf_rrc_codePhase_01 = -1;              /* INTEGER_0_1023 */
static int hf_rrc_integerCodePhase_01 = -1;       /* INTEGER_0_127 */
static int hf_rrc_codePhaseSearchWindow_01 = -1;  /* BIT_STRING_SIZE_5 */
static int hf_rrc_azimuthandElevation = -1;       /* AzimuthAndElevation */
static int hf_rrc_azimuthandElevation_01 = -1;    /* AzimuthAndElevation_r10 */
static int hf_rrc_GANSSSatelliteInformationList_item = -1;  /* GANSSSatelliteInformation */
static int hf_rrc_GANSSSatelliteInformationList_va40ext_item = -1;  /* GANSSSatelliteInformation_va40ext */
static int hf_rrc_GANSSSatelliteInformationList_r10_item = -1;  /* GANSSSatelliteInformation_r10 */
static int hf_rrc_GANSSTimeModelsList_item = -1;  /* UE_Positioning_GANSS_TimeModel */
static int hf_rrc_GANSSTimeModelsList_va40ext_item = -1;  /* UE_Positioning_GANSS_TimeModel_va40ext */
static int hf_rrc_GANSSTimeModelsList_r10_item = -1;  /* UE_Positioning_GANSS_TimeModel_r10 */
static int hf_rrc_gloAlmNA = -1;                  /* BIT_STRING_SIZE_11 */
static int hf_rrc_gloAlmnA = -1;                  /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloAlmHA = -1;                  /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloAlmLambdaA = -1;             /* BIT_STRING_SIZE_21 */
static int hf_rrc_gloAlmTlambdaA = -1;            /* BIT_STRING_SIZE_21 */
static int hf_rrc_gloAlmDeltaIA = -1;             /* BIT_STRING_SIZE_18 */
static int hf_rrc_gloAkmDeltaTA = -1;             /* BIT_STRING_SIZE_22 */
static int hf_rrc_gloAlmDeltaTdotA = -1;          /* BIT_STRING_SIZE_7 */
static int hf_rrc_gloAlmEpsilonA = -1;            /* BIT_STRING_SIZE_15 */
static int hf_rrc_gloAlmOmegaA = -1;              /* BIT_STRING_SIZE_16 */
static int hf_rrc_gloAlmTauA = -1;                /* BIT_STRING_SIZE_10 */
static int hf_rrc_gloAlmCA = -1;                  /* BIT_STRING_SIZE_1 */
static int hf_rrc_gloAlmMA = -1;                  /* BIT_STRING_SIZE_2 */
static int hf_rrc_svId = -1;                      /* INTEGER_0_63 */
static int hf_rrc_ganss_alm_e = -1;               /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganss_delta_I_alm = -1;         /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganss_omegadot_alm = -1;        /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganss_svhealth_alm = -1;        /* BIT_STRING_SIZE_4 */
static int hf_rrc_ganss_delta_a_sqrt_alm = -1;    /* BIT_STRING_SIZE_17 */
static int hf_rrc_ganss_omegazero_alm = -1;       /* BIT_STRING_SIZE_16 */
static int hf_rrc_ganss_m_zero_alm = -1;          /* BIT_STRING_SIZE_16 */
static int hf_rrc_ganss_omega_alm = -1;           /* BIT_STRING_SIZE_16 */
static int hf_rrc_ganss_af_zero_alm = -1;         /* BIT_STRING_SIZE_14 */
static int hf_rrc_ganss_af_one_alm = -1;          /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmE = -1;                  /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmDeltaI = -1;             /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmOmegaDot = -1;           /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmSqrtA = -1;              /* BIT_STRING_SIZE_17 */
static int hf_rrc_midiAlmOmega0 = -1;             /* BIT_STRING_SIZE_16 */
static int hf_rrc_midiAlmOmega = -1;              /* BIT_STRING_SIZE_16 */
static int hf_rrc_midiAlmMo = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_rrc_midiAlmaf0 = -1;                /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmaf1 = -1;                /* BIT_STRING_SIZE_10 */
static int hf_rrc_midiAlmL1Health = -1;           /* BIT_STRING_SIZE_1 */
static int hf_rrc_midiAlmL2Health = -1;           /* BIT_STRING_SIZE_1 */
static int hf_rrc_midiAlmL5Health = -1;           /* BIT_STRING_SIZE_1 */
static int hf_rrc_navAlmE = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_navAlmDeltaI = -1;              /* BIT_STRING_SIZE_16 */
static int hf_rrc_navAlmOMEGADOT = -1;            /* BIT_STRING_SIZE_16 */
static int hf_rrc_navAlmSVHealth = -1;            /* BIT_STRING_SIZE_8 */
static int hf_rrc_navAlmSqrtA = -1;               /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmOMEGAo = -1;              /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmOmega = -1;               /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmMo = -1;                  /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmaf0 = -1;                 /* BIT_STRING_SIZE_11 */
static int hf_rrc_navAlmaf1 = -1;                 /* BIT_STRING_SIZE_11 */
static int hf_rrc_redAlmDeltaA = -1;              /* BIT_STRING_SIZE_8 */
static int hf_rrc_redAlmOmega0 = -1;              /* BIT_STRING_SIZE_7 */
static int hf_rrc_redAlmPhi0 = -1;                /* BIT_STRING_SIZE_7 */
static int hf_rrc_redAlmL1Health = -1;            /* BIT_STRING_SIZE_1 */
static int hf_rrc_redAlmL2Health = -1;            /* BIT_STRING_SIZE_1 */
static int hf_rrc_redAlmL5Health = -1;            /* BIT_STRING_SIZE_1 */
static int hf_rrc_sbasAlmDataID = -1;             /* BIT_STRING_SIZE_2 */
static int hf_rrc_sbasAlmHealth = -1;             /* BIT_STRING_SIZE_8 */
static int hf_rrc_sbasAlmXg = -1;                 /* BIT_STRING_SIZE_15 */
static int hf_rrc_sbasAlmYg = -1;                 /* BIT_STRING_SIZE_15 */
static int hf_rrc_sbasAlmZg = -1;                 /* BIT_STRING_SIZE_9 */
static int hf_rrc_sbasAlmXgdot = -1;              /* BIT_STRING_SIZE_3 */
static int hf_rrc_sbasAlmYgDot = -1;              /* BIT_STRING_SIZE_3 */
static int hf_rrc_sbasAlmZgDot = -1;              /* BIT_STRING_SIZE_4 */
static int hf_rrc_sbasAlmTo = -1;                 /* BIT_STRING_SIZE_11 */
static int hf_rrc_GANSS_SAT_Info_Almanac_GLOkpList_item = -1;  /* GANSS_SAT_Info_Almanac_GLOkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_KpList_item = -1;  /* GANSS_SAT_Info_Almanac_Kp */
static int hf_rrc_GANSS_SAT_Info_Almanac_MIDIkpList_item = -1;  /* GANSS_SAT_Info_Almanac_MIDIkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_NAVkpList_item = -1;  /* GANSS_SAT_Info_Almanac_NAVkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_REDkpList_item = -1;  /* GANSS_SAT_Info_Almanac_REDkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_SBASecefList_item = -1;  /* GANSS_SAT_Info_Almanac_SBASecef */
static int hf_rrc_svHealth = -1;                  /* BIT_STRING_SIZE_6 */
static int hf_rrc_iod = -1;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganssClockModel = -1;           /* UE_Positioning_GANSS_AddClockModels */
static int hf_rrc_ganssOrbitModel = -1;           /* UE_Positioning_GANSS_AddOrbitModels */
static int hf_rrc_svHealth_01 = -1;               /* BIT_STRING_SIZE_5 */
static int hf_rrc_iod_01 = -1;                    /* BIT_STRING_SIZE_10 */
static int hf_rrc_ganssClockModel_01 = -1;        /* UE_Positioning_GANSS_ClockModel */
static int hf_rrc_ganssOrbitModel_01 = -1;        /* UE_Positioning_GANSS_OrbitModel */
static int hf_rrc_Ganss_Sat_Info_AddNavList_item = -1;  /* Ganss_Sat_Info_AddNav */
static int hf_rrc_Ganss_Sat_Info_NavList_item = -1;  /* Ganss_Sat_Info_Nav */
static int hf_rrc_storm_flag_one = -1;            /* BOOLEAN */
static int hf_rrc_storm_flag_two = -1;            /* BOOLEAN */
static int hf_rrc_storm_flag_three = -1;          /* BOOLEAN */
static int hf_rrc_storm_flag_four = -1;           /* BOOLEAN */
static int hf_rrc_storm_flag_five = -1;           /* BOOLEAN */
static int hf_rrc_gloTau = -1;                    /* BIT_STRING_SIZE_22 */
static int hf_rrc_gloGamma = -1;                  /* BIT_STRING_SIZE_11 */
static int hf_rrc_gloDeltaTau = -1;               /* BIT_STRING_SIZE_5 */
static int hf_rrc_satelliteID = -1;               /* INTEGER_0_63 */
static int hf_rrc_c_N0 = -1;                      /* INTEGER_0_63 */
static int hf_rrc_doppler_01 = -1;                /* INTEGER_M32768_32768 */
static int hf_rrc_wholeGPS_Chips = -1;            /* INTEGER_0_1022 */
static int hf_rrc_fractionalGPS_Chips = -1;       /* INTEGER_0_1023 */
static int hf_rrc_multipathIndicator_01 = -1;     /* MultipathIndicator */
static int hf_rrc_pseudorangeRMS_Error = -1;      /* INTEGER_0_63 */
static int hf_rrc_GPS_MeasurementParamList_item = -1;  /* GPS_MeasurementParam */
static int hf_rrc_startingARFCN = -1;             /* BCCH_ARFCN */
static int hf_rrc_bandIndicator = -1;             /* T_bandIndicator */
static int hf_rrc_followingARFCNs = -1;           /* T_followingARFCNs */
static int hf_rrc_explicitListOfARFCNs = -1;      /* SEQUENCE_SIZE_0_31_OF_BCCH_ARFCN */
static int hf_rrc_explicitListOfARFCNs_item = -1;  /* BCCH_ARFCN */
static int hf_rrc_equallySpacedARFCNs = -1;       /* T_equallySpacedARFCNs */
static int hf_rrc_arfcn_Spacing = -1;             /* INTEGER_1_8 */
static int hf_rrc_numberOfFollowingARFCNs = -1;   /* INTEGER_0_31 */
static int hf_rrc_variableBitMapOfARFCNs = -1;    /* OCTET_STRING_SIZE_1_16 */
static int hf_rrc_continuousRangeOfARFCNs = -1;   /* T_continuousRangeOfARFCNs */
static int hf_rrc_endingARFCN = -1;               /* BCCH_ARFCN */
static int hf_rrc_gsm_CarrierRSSI = -1;           /* GSM_CarrierRSSI */
static int hf_rrc_dummy_53 = -1;                  /* INTEGER_46_173 */
static int hf_rrc_dummy2_12 = -1;                 /* ObservedTimeDifferenceToGSM */
static int hf_rrc_GSM_MeasuredResultsList_item = -1;  /* GSM_MeasuredResults */
static int hf_rrc_tlm_Message = -1;               /* BIT_STRING_SIZE_14 */
static int hf_rrc_tlm_Reserved = -1;              /* BIT_STRING_SIZE_2 */
static int hf_rrc_alert = -1;                     /* BOOLEAN */
static int hf_rrc_antiSpoof = -1;                 /* BOOLEAN */
static int hf_rrc_GPS_TOW_AssistList_item = -1;   /* GPS_TOW_Assist */
static int hf_rrc_gsmCellGroup = -1;              /* GSM_CellGroup */
static int hf_rrc_qRxLevMinGSM = -1;              /* INTEGER_M58_M13 */
static int hf_rrc_GSM_PriorityInfoList_item = -1;  /* GSM_PriorityInfo */
static int hf_rrc_penaltyTime = -1;               /* PenaltyTime_RSCP */
static int hf_rrc_penaltyTime_01 = -1;            /* PenaltyTime_ECN0 */
static int hf_rrc_hcs_PRIO = -1;                  /* HCS_PRIO */
static int hf_rrc_q_HCS = -1;                     /* Q_HCS */
static int hf_rrc_hcs_CellReselectInformation = -1;  /* HCS_CellReselectInformation_RSCP */
static int hf_rrc_hcs_CellReselectInformation_01 = -1;  /* HCS_CellReselectInformation_ECN0 */
static int hf_rrc_t_CR_Max = -1;                  /* T_CRMax */
static int hf_rrc_bearing = -1;                   /* INTEGER_0_359 */
static int hf_rrc_horizontalSpeed = -1;           /* INTEGER_0_2047 */
static int hf_rrc_verticalSpeedDirection = -1;    /* T_verticalSpeedDirection */
static int hf_rrc_verticalSpeed = -1;             /* INTEGER_0_255 */
static int hf_rrc_horizontalSpeedUncertainty = -1;  /* INTEGER_0_255 */
static int hf_rrc_verticalSpeedDirection_01 = -1;  /* T_verticalSpeedDirection_01 */
static int hf_rrc_horizontalUncertaintySpeed = -1;  /* INTEGER_0_255 */
static int hf_rrc_verticalUncertaintySpeed = -1;  /* INTEGER_0_255 */
static int hf_rrc_k = -1;                         /* INTEGER_2_3 */
static int hf_rrc_nonFreqRelatedEventResults = -1;  /* CellMeasurementEventResults */
static int hf_rrc_nonFreqRelatedEventResults_01 = -1;  /* CellMeasurementEventResults_LCR_r4 */
static int hf_rrc_removedInterFreqCellList = -1;  /* RemovedInterFreqCellList */
static int hf_rrc_newInterFreqCellList_02 = -1;   /* NewInterFreqCellList */
static int hf_rrc_cellsForInterFreqMeasList = -1;  /* CellsForInterFreqMeasList */
static int hf_rrc_newInterFreqCellList_03 = -1;   /* NewInterFreqCellList_r4 */
static int hf_rrc_newInterFreqCellList_04 = -1;   /* NewInterFreqCellList_r8 */
static int hf_rrc_newInterFreqCellList_05 = -1;   /* NewInterFreqCellList_r9 */
static int hf_rrc_cSGInterFreqCellInfoList = -1;  /* CSGInterFreqCellInfoList */
static int hf_rrc_interFreqSIAcquisition = -1;    /* InterFreqSIAcquisition */
static int hf_rrc_newInterFreqCellList_06 = -1;   /* NewInterFreqCellList_r10 */
static int hf_rrc_modeSpecificInfo_111 = -1;      /* T_modeSpecificInfo_111 */
static int hf_rrc_fdd_156 = -1;                   /* T_fdd_150 */
static int hf_rrc_primaryScramblingCode_01 = -1;  /* PrimaryCPICH_Info */
static int hf_rrc_newInterFreqCellList_07 = -1;   /* NewInterFreqCellSI_List_RSCP */
static int hf_rrc_newInterFreqCellList_08 = -1;   /* NewInterFreqCellSI_List_ECN0 */
static int hf_rrc_newInterFreqCellList_09 = -1;   /* NewInterFreqCellSI_List_HCS_RSCP */
static int hf_rrc_newInterFreqCellList_10 = -1;   /* NewInterFreqCellSI_List_HCS_ECN0 */
static int hf_rrc_newInterFreqCellList_11 = -1;   /* NewInterFreqCellSI_List_RSCP_LCR_r4 */
static int hf_rrc_newInterFreqCellList_12 = -1;   /* NewInterFreqCellSI_List_ECN0_LCR_r4 */
static int hf_rrc_newInterFreqCellList_13 = -1;   /* NewInterFreqCellSI_List_HCS_RSCP_LCR_r4 */
static int hf_rrc_newInterFreqCellList_14 = -1;   /* NewInterFreqCellSI_List_HCS_ECN0_LCR_r4 */
static int hf_rrc_InterFreqCellList_item = -1;    /* InterFreqCell */
static int hf_rrc_InterFreqCellList_LCR_r4_ext_item = -1;  /* InterFreqCell_LCR_r4 */
static int hf_rrc_InterFreqCellMeasuredResultsList_item = -1;  /* CellMeasuredResults */
static int hf_rrc_InterFreqCellMeasuredResultsList_v920ext_item = -1;  /* CellMeasuredResults_v920ext */
static int hf_rrc_event2a = -1;                   /* Event2a */
static int hf_rrc_event2b = -1;                   /* Event2b */
static int hf_rrc_event2c = -1;                   /* Event2c */
static int hf_rrc_event2d = -1;                   /* Event2d */
static int hf_rrc_event2e = -1;                   /* Event2e */
static int hf_rrc_event2f = -1;                   /* Event2f */
static int hf_rrc_event2a_01 = -1;                /* Event2a_r6 */
static int hf_rrc_event2b_01 = -1;                /* Event2b_r6 */
static int hf_rrc_event2c_01 = -1;                /* Event2c_r6 */
static int hf_rrc_event2d_01 = -1;                /* Event2d_r6 */
static int hf_rrc_event2e_01 = -1;                /* Event2e_r6 */
static int hf_rrc_event2f_01 = -1;                /* Event2f_r6 */
static int hf_rrc_event2a_02 = -1;                /* Event2a_r10 */
static int hf_rrc_event2b_02 = -1;                /* Event2b_r10 */
static int hf_rrc_event2c_02 = -1;                /* Event2c_r10 */
static int hf_rrc_event2d_02 = -1;                /* Event2d_r10 */
static int hf_rrc_event2e_02 = -1;                /* Event2e_r10 */
static int hf_rrc_event2f_02 = -1;                /* Event2f_r10 */
static int hf_rrc_event2a_03 = -1;                /* Event2a_r11 */
static int hf_rrc_event2b_03 = -1;                /* Event2b_r11 */
static int hf_rrc_event2c_03 = -1;                /* Event2c_r11 */
static int hf_rrc_event2e_03 = -1;                /* Event2e_r11 */
static int hf_rrc_InterFreqEventList_item = -1;   /* InterFreqEvent */
static int hf_rrc_InterFreqEventList_r6_item = -1;  /* InterFreqEvent_r6 */
static int hf_rrc_InterFreqEventList_r10_item = -1;  /* InterFreqEvent_r10 */
static int hf_rrc_InterFreqEventList_r11_item = -1;  /* InterFreqEvent_r11 */
static int hf_rrc_InterFrequencyMeasuredResultsList_v590ext_item = -1;  /* DeltaRSCPPerCell */
static int hf_rrc_threholdUsedFrequency_delta = -1;  /* DeltaRSCP */
static int hf_rrc_threholdNonUsedFrequency_deltaList = -1;  /* ThreholdNonUsedFrequency_deltaList */
static int hf_rrc_Inter_FreqEventCriteriaList_v590ext_item = -1;  /* Inter_FreqEventCriteria_v590ext */
static int hf_rrc_Intra_FreqEventCriteriaList_v590ext_item = -1;  /* DeltaRSCP */
static int hf_rrc_IntraFrequencyMeasuredResultsList_v590ext_item = -1;  /* DeltaRSCPPerCell */
static int hf_rrc_eventID_01 = -1;                /* EventIDInterFreq */
static int hf_rrc_interFreqCellList = -1;         /* InterFreqCellList */
static int hf_rrc_detectedSetTrigger = -1;        /* T_detectedSetTrigger */
static int hf_rrc_interFreqCellList_01 = -1;      /* InterFreqCellList_LCR_r4_ext */
static int hf_rrc_reportingCriteria = -1;         /* T_reportingCriteria */
static int hf_rrc_intraFreqReportingCriteria_02 = -1;  /* T_intraFreqReportingCriteria */
static int hf_rrc_intraFreqMeasQuantity = -1;     /* IntraFreqMeasQuantity */
static int hf_rrc_interFreqReportingCriteria = -1;  /* T_interFreqReportingCriteria */
static int hf_rrc_modeSpecificInfo_112 = -1;      /* T_modeSpecificInfo_112 */
static int hf_rrc_fdd_157 = -1;                   /* T_fdd_151 */
static int hf_rrc_freqQualityEstimateQuantity_FDD = -1;  /* FreqQualityEstimateQuantity_FDD */
static int hf_rrc_tdd_108 = -1;                   /* T_tdd_100 */
static int hf_rrc_freqQualityEstimateQuantity_TDD = -1;  /* FreqQualityEstimateQuantity_TDD */
static int hf_rrc_utra_CarrierRSSI = -1;          /* UTRA_CarrierRSSI */
static int hf_rrc_interFreqCellMeasuredResultsList = -1;  /* InterFreqCellMeasuredResultsList */
static int hf_rrc_interFreqCellMeasuredResultsList_01 = -1;  /* InterFreqCellMeasuredResultsList_v920ext */
static int hf_rrc_InterFreqMeasuredResultsList_item = -1;  /* InterFreqMeasuredResults */
static int hf_rrc_InterFreqMeasuredResultsList_v920ext_item = -1;  /* InterFreqMeasuredResults_v920ext */
static int hf_rrc_interFreqCellInfoSI_List = -1;  /* InterFreqCellInfoSI_List_RSCP */
static int hf_rrc_interFreqCellInfoSI_List_01 = -1;  /* InterFreqCellInfoSI_List_ECN0 */
static int hf_rrc_interFreqCellInfoSI_List_02 = -1;  /* InterFreqCellInfoSI_List_HCS_RSCP */
static int hf_rrc_interFreqCellInfoSI_List_03 = -1;  /* InterFreqCellInfoSI_List_HCS_ECN0 */
static int hf_rrc_interFreqCellInfoSI_List_04 = -1;  /* InterFreqCellInfoSI_List_RSCP_LCR */
static int hf_rrc_interFreqCellInfoSI_List_05 = -1;  /* InterFreqCellInfoSI_List_ECN0_LCR */
static int hf_rrc_interFreqCellInfoSI_List_06 = -1;  /* InterFreqCellInfoSI_List_HCS_RSCP_LCR */
static int hf_rrc_interFreqCellInfoSI_List_07 = -1;  /* InterFreqCellInfoSI_List_HCS_ECN0_LCR */
static int hf_rrc_InterFreqRACHRepCellsList_item = -1;  /* InterFreqCellID */
static int hf_rrc_modeSpecificInfo_113 = -1;      /* T_modeSpecificInfo_113 */
static int hf_rrc_fdd_158 = -1;                   /* T_fdd_152 */
static int hf_rrc_interFreqRepQuantityRACH_FDD = -1;  /* InterFreqRepQuantityRACH_FDD */
static int hf_rrc_tdd_109 = -1;                   /* T_tdd_101 */
static int hf_rrc_interFreqRepQuantityRACH_TDDList = -1;  /* InterFreqRepQuantityRACH_TDDList */
static int hf_rrc_interFreqRACHReportingThreshold = -1;  /* Threshold */
static int hf_rrc_maxReportedCellsOnRACHinterFreq = -1;  /* MaxReportedCellsOnRACHinterFreq */
static int hf_rrc_modeSpecificInfo_114 = -1;      /* T_modeSpecificInfo_114 */
static int hf_rrc_fdd_159 = -1;                   /* T_fdd_153 */
static int hf_rrc_tdd_110 = -1;                   /* T_tdd_102 */
static int hf_rrc_interFreqReportingCriteria_01 = -1;  /* InterFreqReportingCriteria */
static int hf_rrc_periodicalReportingCriteria_01 = -1;  /* PeriodicalWithReportingCellStatus */
static int hf_rrc_noReporting = -1;               /* ReportingCellStatusOpt */
static int hf_rrc_intraFreqReportingCriteria_03 = -1;  /* IntraFreqReportingCriteria_r4 */
static int hf_rrc_intraFreqReportingCriteria_04 = -1;  /* IntraFreqReportingCriteria_r6 */
static int hf_rrc_interFreqReportingCriteria_02 = -1;  /* InterFreqReportingCriteria_r6 */
static int hf_rrc_intraFreqReportingCriteria_05 = -1;  /* IntraFreqReportingCriteria_r7 */
static int hf_rrc_intraFreqReportingCriteria_06 = -1;  /* IntraFreqReportingCriteria_r9 */
static int hf_rrc_interFreqReportingCriteria_03 = -1;  /* InterFreqReportingCriteria_r10 */
static int hf_rrc_periodicalReportingCriteria_02 = -1;  /* PeriodicalWithReportingCellStatus_r10 */
static int hf_rrc_noReporting_01 = -1;            /* ReportingCellStatusOpt_r10 */
static int hf_rrc_intraFreqReportingCriteria_07 = -1;  /* IntraFreqReportingCriteria_r11 */
static int hf_rrc_interFreqReportingCriteria_04 = -1;  /* InterFreqReportingCriteria_r11 */
static int hf_rrc_interFreqEventList = -1;        /* InterFreqEventList */
static int hf_rrc_interFreqEventList_01 = -1;     /* InterFreqEventList_r6 */
static int hf_rrc_interFreqEventList_02 = -1;     /* InterFreqEventList_r10 */
static int hf_rrc_interFreqEventList_03 = -1;     /* InterFreqEventList_r11 */
static int hf_rrc_utra_Carrier_RSSI = -1;         /* BOOLEAN */
static int hf_rrc_frequencyQualityEstimate = -1;  /* BOOLEAN */
static int hf_rrc_nonFreqRelatedQuantities = -1;  /* CellReportingQuantities */
static int hf_rrc_InterFreqRepQuantityRACH_TDDList_item = -1;  /* InterFreqRepQuantityRACH_TDD */
static int hf_rrc_interFreqCellInfoList = -1;     /* InterFreqCellInfoList */
static int hf_rrc_interFreqMeasQuantity = -1;     /* InterFreqMeasQuantity */
static int hf_rrc_interFreqReportingQuantity = -1;  /* InterFreqReportingQuantity */
static int hf_rrc_measurementValidity = -1;       /* MeasurementValidity */
static int hf_rrc_interFreqSetUpdate = -1;        /* UE_AutonomousUpdateMode */
static int hf_rrc_reportCriteria_01 = -1;         /* InterFreqReportCriteria */
static int hf_rrc_interFreqCellInfoList_01 = -1;  /* InterFreqCellInfoList_r4 */
static int hf_rrc_reportCriteria_02 = -1;         /* InterFreqReportCriteria_r4 */
static int hf_rrc_reportCriteria_03 = -1;         /* InterFreqReportCriteria_r6 */
static int hf_rrc_reportCriteria_04 = -1;         /* InterFreqReportCriteria_r7 */
static int hf_rrc_interFreqCellInfoList_02 = -1;  /* InterFreqCellInfoList_r8 */
static int hf_rrc_adjacentFrequencyIndex = -1;    /* INTEGER_0_31 */
static int hf_rrc_interFreqCellInfoList_03 = -1;  /* InterFreqCellInfoList_r9 */
static int hf_rrc_interBandFrequencyIndex = -1;   /* INTEGER_0_31 */
static int hf_rrc_reportCriteria_05 = -1;         /* InterFreqReportCriteria_r9 */
static int hf_rrc_interFreqCellInfoList_04 = -1;  /* InterFreqCellInfoList_r10 */
static int hf_rrc_freqIndexListForEnhancedMeas = -1;  /* FreqIndexListForEnhancedMeas */
static int hf_rrc_reportCriteria_06 = -1;         /* InterFreqReportCriteria_r10 */
static int hf_rrc_reportCriteria_07 = -1;         /* InterFreqReportCriteria_r11 */
static int hf_rrc_technologySpecificInfo = -1;    /* T_technologySpecificInfo */
static int hf_rrc_gsm_09 = -1;                    /* T_gsm_09 */
static int hf_rrc_bsic = -1;                      /* BSIC */
static int hf_rrc_bcch_ARFCN = -1;                /* BCCH_ARFCN */
static int hf_rrc_ncMode = -1;                    /* NC_Mode */
static int hf_rrc_is_2000 = -1;                   /* NULL */
static int hf_rrc_removedInterRATCellList = -1;   /* RemovedInterRATCellList */
static int hf_rrc_newInterRATCellList = -1;       /* NewInterRATCellList */
static int hf_rrc_cellsForInterRATMeasList = -1;  /* CellsForInterRATMeasList */
static int hf_rrc_newInterRATCellList_01 = -1;    /* NewInterRATCellList_B */
static int hf_rrc_interRATCellInfoIndication_r6 = -1;  /* InterRATCellInfoIndication */
static int hf_rrc_event3a = -1;                   /* Event3a */
static int hf_rrc_event3b = -1;                   /* Event3b */
static int hf_rrc_event3c = -1;                   /* Event3c */
static int hf_rrc_event3d = -1;                   /* Event3d */
static int hf_rrc_InterRATEventList_item = -1;    /* InterRATEvent */
static int hf_rrc_cellToReportList = -1;          /* CellToReportList */
static int hf_rrc_rat_01 = -1;                    /* InterRATInfo */
static int hf_rrc_gsm_TargetCellInfoList = -1;    /* GSM_TargetCellInfoList */
static int hf_rrc_gsm_10 = -1;                    /* NULL */
static int hf_rrc_eutra_02 = -1;                  /* T_eutra_01 */
static int hf_rrc_eutra_TargetFreqInfoList_01 = -1;  /* EUTRA_TargetFreqInfoList */
static int hf_rrc_measQuantityUTRAN_QualityEstimate = -1;  /* IntraFreqMeasQuantity */
static int hf_rrc_ratSpecificInfo = -1;           /* T_ratSpecificInfo */
static int hf_rrc_gsm_11 = -1;                    /* T_gsm_10 */
static int hf_rrc_measurementQuantity_01 = -1;    /* MeasurementQuantityGSM */
static int hf_rrc_bsic_VerificationRequired = -1;  /* BSIC_VerificationRequired */
static int hf_rrc_is_2000_01 = -1;                /* T_is_2000 */
static int hf_rrc_tadd_EcIo = -1;                 /* INTEGER_0_63 */
static int hf_rrc_tcomp_EcIo = -1;                /* INTEGER_0_15 */
static int hf_rrc_softSlope = -1;                 /* INTEGER_0_63 */
static int hf_rrc_addIntercept = -1;              /* INTEGER_0_63 */
static int hf_rrc_ratSpecificInfo_01 = -1;        /* T_ratSpecificInfo_01 */
static int hf_rrc_gsm_12 = -1;                    /* T_gsm_11 */
static int hf_rrc_is_2000_02 = -1;                /* T_is_2000_01 */
static int hf_rrc_e_UTRA_01 = -1;                 /* T_e_UTRA_01 */
static int hf_rrc_measurementQuantity_02 = -1;    /* MeasurementQuantityEUTRA */
static int hf_rrc_gsm_13 = -1;                    /* GSM_MeasuredResultsList */
static int hf_rrc_InterRATMeasuredResultsList_item = -1;  /* InterRATMeasuredResults */
static int hf_rrc_interRATCellInfoList = -1;      /* InterRATCellInfoList */
static int hf_rrc_interRATMeasQuantity = -1;      /* InterRATMeasQuantity */
static int hf_rrc_interRATReportingQuantity = -1;  /* InterRATReportingQuantity */
static int hf_rrc_reportCriteria_08 = -1;         /* InterRATReportCriteria */
static int hf_rrc_interRATCellInfoList_01 = -1;   /* InterRATCellInfoList_r4 */
static int hf_rrc_interRATCellInfoList_02 = -1;   /* InterRATCellInfoList_r6 */
static int hf_rrc_interRATMeasurementObjects = -1;  /* T_interRATMeasurementObjects */
static int hf_rrc_eutra_FrequencyList = -1;       /* EUTRA_FrequencyList */
static int hf_rrc_interRATMeasQuantity_01 = -1;   /* InterRATMeasQuantity_r8 */
static int hf_rrc_interRATReportingQuantity_01 = -1;  /* InterRATReportingQuantity_r8 */
static int hf_rrc_idleIntervalInfo = -1;          /* IdleIntervalInfo */
static int hf_rrc_interRATMeasurementObjects_01 = -1;  /* T_interRATMeasurementObjects_01 */
static int hf_rrc_eutra_FrequencyList_01 = -1;    /* EUTRA_FrequencyList_r9 */
static int hf_rrc_interRATMeasurementObjects_02 = -1;  /* T_interRATMeasurementObjects_02 */
static int hf_rrc_eutra_FrequencyList_02 = -1;    /* EUTRA_FrequencyList_r11 */
static int hf_rrc_interRATCellInfoList_03 = -1;   /* InterRATCellInfoList_B */
static int hf_rrc_interRATReportingCriteria = -1;  /* InterRATReportingCriteria */
static int hf_rrc_interRATEventList = -1;         /* InterRATEventList */
static int hf_rrc_utran_EstimatedQuality = -1;    /* BOOLEAN */
static int hf_rrc_ratSpecificInfo_02 = -1;        /* T_ratSpecificInfo_02 */
static int hf_rrc_gsm_14 = -1;                    /* T_gsm_12 */
static int hf_rrc_gsm_Carrier_RSSI = -1;          /* BOOLEAN */
static int hf_rrc_ratSpecificInfo_03 = -1;        /* T_ratSpecificInfo_03 */
static int hf_rrc_gsm_15 = -1;                    /* T_gsm_13 */
static int hf_rrc_eutra_03 = -1;                  /* T_eutra_02 */
static int hf_rrc_reportingQuantity = -1;         /* T_reportingQuantity */
static int hf_rrc_removedIntraFreqCellList = -1;  /* RemovedIntraFreqCellList */
static int hf_rrc_newIntraFreqCellList_01 = -1;   /* NewIntraFreqCellList */
static int hf_rrc_cellsForIntraFreqMeasList = -1;  /* CellsForIntraFreqMeasList */
static int hf_rrc_newIntraFreqCellList_02 = -1;   /* NewIntraFreqCellList_r4 */
static int hf_rrc_removedIntraFreqCellList_01 = -1;  /* RemovedIntraFreqCellListOnSecULFreq */
static int hf_rrc_newIntraFreqCellList_03 = -1;   /* NewIntraFreqCellListOnSecULFreq */
static int hf_rrc_cellsForIntraFreqMeasList_01 = -1;  /* CellsForIntraFreqMeasListOnSecULFreq */
static int hf_rrc_intraFreqCellInfoListOnSecULFreq = -1;  /* IntraFreqCellInfoListInfoOnSecULFreq */
static int hf_rrc_newIntraFreqCellList_04 = -1;   /* NewIntraFreqCellList_r9 */
static int hf_rrc_cSGIntraFreqCellInfoList = -1;  /* CSGIntraFreqCellInfoList */
static int hf_rrc_intraFreqSIAcquisition = -1;    /* IntraFreqSIAcquisition */
static int hf_rrc_newIntraFreqCellList_05 = -1;   /* NewIntraFreqCellList_r10 */
static int hf_rrc_IntraFreqSIAcquisitionInfo_item = -1;  /* PrimaryCPICH_Info */
static int hf_rrc_modeSpecificInfo_115 = -1;      /* T_modeSpecificInfo_115 */
static int hf_rrc_fdd_160 = -1;                   /* T_fdd_154 */
static int hf_rrc_intraFreqSIAcquisitionInfo = -1;  /* IntraFreqSIAcquisitionInfo */
static int hf_rrc_newIntraFreqCellList_06 = -1;   /* NewIntraFreqCellSI_List_RSCP */
static int hf_rrc_newIntraFreqCellList_07 = -1;   /* NewIntraFreqCellSI_List_ECN0 */
static int hf_rrc_newIntraFreqCellList_08 = -1;   /* NewIntraFreqCellSI_List_HCS_RSCP */
static int hf_rrc_newIntraFreqCellList_09 = -1;   /* NewIntraFreqCellSI_List_HCS_ECN0 */
static int hf_rrc_newIntraFreqCellList_10 = -1;   /* NewIntraFreqCellSI_List_RSCP_LCR_r4 */
static int hf_rrc_newIntraFreqCellList_11 = -1;   /* NewIntraFreqCellSI_List_ECN0_LCR_r4 */
static int hf_rrc_newIntraFreqCellList_12 = -1;   /* NewIntraFreqCellSI_List_HCS_RSCP_LCR_r4 */
static int hf_rrc_newIntraFreqCellList_13 = -1;   /* NewIntraFreqCellSI_List_HCS_ECN0_LCR_r4 */
static int hf_rrc_e1a = -1;                       /* Event1a */
static int hf_rrc_e1b = -1;                       /* Event1b */
static int hf_rrc_e1c = -1;                       /* Event1c */
static int hf_rrc_e1d = -1;                       /* NULL */
static int hf_rrc_e1e = -1;                       /* Event1e */
static int hf_rrc_e1f = -1;                       /* Event1f */
static int hf_rrc_e1g = -1;                       /* NULL */
static int hf_rrc_e1h = -1;                       /* ThresholdUsedFrequency */
static int hf_rrc_e1i = -1;                       /* ThresholdUsedFrequency */
static int hf_rrc_e1a_01 = -1;                    /* Event1a_r4 */
static int hf_rrc_e1b_01 = -1;                    /* Event1b_r4 */
static int hf_rrc_e1a_02 = -1;                    /* Event1a_LCR_r4 */
static int hf_rrc_e1b_02 = -1;                    /* Event1b_LCR_r4 */
static int hf_rrc_e1d_01 = -1;                    /* Event1d */
static int hf_rrc_e1e_01 = -1;                    /* Event1e_r6 */
static int hf_rrc_e1f_01 = -1;                    /* Event1f_r6 */
static int hf_rrc_e1h_01 = -1;                    /* ThresholdUsedFrequency_r6 */
static int hf_rrc_e1i_01 = -1;                    /* ThresholdUsedFrequency_r6 */
static int hf_rrc_e1j = -1;                       /* Event1j_r6 */
static int hf_rrc_e1b_03 = -1;                    /* Event1b_r7 */
static int hf_rrc_e1a_03 = -1;                    /* Event1a_OnSecUlFreq_r9 */
static int hf_rrc_e1b_04 = -1;                    /* Event1b_OnSecUlFreq_r9 */
static int hf_rrc_event = -1;                     /* IntraFreqEvent */
static int hf_rrc_event_01 = -1;                  /* IntraFreqEvent_r4 */
static int hf_rrc_event_02 = -1;                  /* IntraFreqEvent_LCR_r4 */
static int hf_rrc_event_03 = -1;                  /* IntraFreqEvent_r6 */
static int hf_rrc_event_04 = -1;                  /* IntraFreqEvent_r7 */
static int hf_rrc_event_05 = -1;                  /* IntraFreqEventOnSecULFreq */
static int hf_rrc_IntraFreqEventCriteriaList_item = -1;  /* IntraFreqEventCriteria */
static int hf_rrc_IntraFreqEventCriteriaList_r4_item = -1;  /* IntraFreqEventCriteria_r4 */
static int hf_rrc_IntraFreqEventCriteriaList_LCR_r4_item = -1;  /* IntraFreqEventCriteria_LCR_r4 */
static int hf_rrc_IntraFreqEventCriteriaList_r6_item = -1;  /* IntraFreqEventCriteria_r6 */
static int hf_rrc_IntraFreqEventCriteriaList_r7_item = -1;  /* IntraFreqEventCriteria_r7 */
static int hf_rrc_intraFreqEventCriteria = -1;    /* SEQUENCE_SIZE_1_maxMeasEventOnSecULFreq_OF_IntraFreqEventCriteriaOnSecULFreq */
static int hf_rrc_intraFreqEventCriteria_item = -1;  /* IntraFreqEventCriteriaOnSecULFreq */
static int hf_rrc_eventID_02 = -1;                /* EventIDIntraFreq */
static int hf_rrc_cellMeasurementEventResults = -1;  /* CellMeasurementEventResults */
static int hf_rrc_cellMeasurementEventResultsOnSecUlFreq = -1;  /* CellMeasurementEventResultsOnSecUlFreq */
static int hf_rrc_modeSpecificInfo_116 = -1;      /* T_modeSpecificInfo_116 */
static int hf_rrc_fdd_161 = -1;                   /* T_fdd_155 */
static int hf_rrc_intraFreqMeasQuantity_FDD = -1;  /* IntraFreqMeasQuantity_FDD */
static int hf_rrc_tdd_111 = -1;                   /* T_tdd_103 */
static int hf_rrc_intraFreqMeasQuantity_TDDList = -1;  /* IntraFreqMeasQuantity_TDDList */
static int hf_rrc_IntraFreqMeasQuantity_TDDList_item = -1;  /* IntraFreqMeasQuantity_TDD */
static int hf_rrc_IntraFreqMeasQuantity_TDD_sib3List_item = -1;  /* IntraFreqMeasQuantity_TDD_sib3List_item */
static int hf_rrc_IntraFreqMeasuredResultsList_item = -1;  /* CellMeasuredResults */
static int hf_rrc_IntraFreqMeasuredResultsList_v920ext_item = -1;  /* CellMeasuredResults_v920ext */
static int hf_rrc_intraFreqMeasurementID = -1;    /* MeasurementIdentity */
static int hf_rrc_intraFreqCellInfoSI_List = -1;  /* IntraFreqCellInfoSI_List_RSCP */
static int hf_rrc_intraFreqReportingQuantityForRACH = -1;  /* IntraFreqReportingQuantityForRACH */
static int hf_rrc_maxReportedCellsOnRACH = -1;    /* MaxReportedCellsOnRACH */
static int hf_rrc_reportingInfoForCellDCH = -1;   /* ReportingInfoForCellDCH */
static int hf_rrc_intraFreqCellInfoSI_List_01 = -1;  /* IntraFreqCellInfoSI_List_ECN0 */
static int hf_rrc_intraFreqCellInfoSI_List_02 = -1;  /* IntraFreqCellInfoSI_List_HCS_RSCP */
static int hf_rrc_intraFreqCellInfoSI_List_03 = -1;  /* IntraFreqCellInfoSI_List_HCS_ECN0 */
static int hf_rrc_intraFreqCellInfoSI_List_04 = -1;  /* IntraFreqCellInfoSI_List_RSCP_LCR_r4 */
static int hf_rrc_reportingInfoForCellDCH_01 = -1;  /* ReportingInfoForCellDCH_LCR_r4 */
static int hf_rrc_intraFreqCellInfoSI_List_05 = -1;  /* IntraFreqCellInfoSI_List_ECN0_LCR_r4 */
static int hf_rrc_intraFreqCellInfoSI_List_06 = -1;  /* IntraFreqCellInfoSI_List_HCS_RSCP_LCR_r4 */
static int hf_rrc_intraFreqCellInfoSI_List_07 = -1;  /* IntraFreqCellInfoSI_List_HCS_ECN0_LCR_r4 */
static int hf_rrc_eventCriteriaList = -1;         /* IntraFreqEventCriteriaList */
static int hf_rrc_eventCriteriaList_01 = -1;      /* IntraFreqEventCriteriaList_r4 */
static int hf_rrc_eventCriteriaList_02 = -1;      /* IntraFreqEventCriteriaList_LCR_r4 */
static int hf_rrc_eventCriteriaList_03 = -1;      /* IntraFreqEventCriteriaList_r6 */
static int hf_rrc_eventCriteriaList_04 = -1;      /* IntraFreqEventCriteriaList_r7 */
static int hf_rrc_eventCriteriaListOnSecULFreq = -1;  /* IntraFreqEventCriteriaListOnSecULFreq */
static int hf_rrc_excludedCellInfoList = -1;      /* CellInfoListToBeExcluded */
static int hf_rrc_activeSetReportingQuantities = -1;  /* CellReportingQuantities */
static int hf_rrc_monitoredSetReportingQuantities = -1;  /* CellReportingQuantities */
static int hf_rrc_detectedSetReportingQuantities = -1;  /* CellReportingQuantities */
static int hf_rrc_sfn_SFN_OTD_Type = -1;          /* SFN_SFN_OTD_Type */
static int hf_rrc_modeSpecificInfo_117 = -1;      /* T_modeSpecificInfo_117 */
static int hf_rrc_fdd_162 = -1;                   /* T_fdd_156 */
static int hf_rrc_intraFreqRepQuantityRACH_FDD = -1;  /* IntraFreqRepQuantityRACH_FDD */
static int hf_rrc_tdd_112 = -1;                   /* T_tdd_104 */
static int hf_rrc_intraFreqRepQuantityRACH_TDDList = -1;  /* IntraFreqRepQuantityRACH_TDDList */
static int hf_rrc_IntraFreqRepQuantityRACH_TDDList_item = -1;  /* IntraFreqRepQuantityRACH_TDD */
static int hf_rrc_intraFreqCellInfoList = -1;     /* IntraFreqCellInfoList */
static int hf_rrc_intraFreqReportingQuantity = -1;  /* IntraFreqReportingQuantity */
static int hf_rrc_reportCriteria_09 = -1;         /* IntraFreqReportCriteria */
static int hf_rrc_intraFreqCellInfoList_01 = -1;  /* IntraFreqCellInfoList_r4 */
static int hf_rrc_reportCriteria_10 = -1;         /* IntraFreqReportCriteria_r4 */
static int hf_rrc_reportCriteria_11 = -1;         /* IntraFreqReportCriteria_r6 */
static int hf_rrc_reportCriteria_12 = -1;         /* IntraFreqReportCriteria_r7 */
static int hf_rrc_intraFreqCellInfoList_02 = -1;  /* IntraFreqCellInfoList_r9 */
static int hf_rrc_intraFreqCellInfoListOnSecULFreq_01 = -1;  /* IntraFreqCellInfoListOnSecULFreq */
static int hf_rrc_reportCriteria_13 = -1;         /* IntraFreqReportCriteria_r9 */
static int hf_rrc_intraFreqCellInfoList_03 = -1;  /* IntraFreqCellInfoList_r10 */
static int hf_rrc_reportCriteria_14 = -1;         /* IntraFreqReportCriteria_r11 */
static int hf_rrc_IntraFrequencyMeasuredResultsListOnSecULFreq_item = -1;  /* CellMeasuredResults_r9 */
static int hf_rrc_loggingAbsoluteThreshold = -1;  /* LoggingAbsoluteThreshold */
static int hf_rrc_loggingRelativeThreshold = -1;  /* LoggingRelativeThreshold */
static int hf_rrc_loggingDuration = -1;           /* T_loggingDuration */
static int hf_rrc_intraUTRAANR = -1;              /* IntraUTRAANR */
static int hf_rrc_interRATANRforEUTRAIndicator = -1;  /* T_interRATANRforEUTRAIndicator */
static int hf_rrc_interRATANRforGSMIndicator = -1;  /* T_interRATANRforGSMIndicator */
static int hf_rrc_LoggedANRReportInfoList_item = -1;  /* LoggedANRReportInfo */
static int hf_rrc_LoggedANRReportInfoList_vb50ext_item = -1;  /* LoggedANRReportInfo_vb50ext */
static int hf_rrc_servingCell = -1;               /* CellIdentity */
static int hf_rrc_loggedCellInfo = -1;            /* LoggedCellInfo */
static int hf_rrc_loggedCellInfo_01 = -1;         /* LoggedCellInfo_vb50ext */
static int hf_rrc_loggedUTRACellInfo = -1;        /* LoggedUTRACellInfo */
static int hf_rrc_loggedEUTRACellInfo = -1;       /* LoggedEUTRACellInfo */
static int hf_rrc_loggedGSMCellInfo = -1;         /* LoggedGSMCellInfo */
static int hf_rrc_loggedEUTRACellInfo_01 = -1;    /* LoggedEUTRACellInfo_vb50ext */
static int hf_rrc_loggedConnectionEstablishmentFailureAccessInfo_FDD = -1;  /* LoggedConnectionEstablishmentFailureAccessInfo_FDD */
static int hf_rrc_loggedMeasFailedCellMeas = -1;  /* LoggedMeasServingCellMeas_FDD */
static int hf_rrc_loggedMeasIntrafreqNeighbourList = -1;  /* LoggedMeasIntrafreqNeighbourList_FDD */
static int hf_rrc_loggedMeasInterfreqList = -1;   /* LoggedMeasInterfreqList_FDD */
static int hf_rrc_loggedMeasInterRATNeighbourMeas = -1;  /* LoggedMeasInterRATNeighbourMeas_vb50ext */
static int hf_rrc_loggedConnectionEstablishmentFailureLocationInfo = -1;  /* LoggedConnectionEstablishmentFailureLocationInfo */
static int hf_rrc_loggedConnectionEstablishmentFailureAccessInfo_TDD = -1;  /* LoggedConnectionEstablishmentFailureAccessInfo_TDD */
static int hf_rrc_loggedMeasFailedCellMeas_01 = -1;  /* LoggedMeasServingCellMeas_TDD128 */
static int hf_rrc_loggedMeasIntrafreqNeighbourList_01 = -1;  /* LoggedMeasIntrafreqNeighbourMeasList_TDD128 */
static int hf_rrc_loggedMeasInterfreqList_01 = -1;  /* LoggedMeasInterfreqList_TDD128 */
static int hf_rrc_numberOfRRCMsgTransmitted = -1;  /* INTEGER_0_8 */
static int hf_rrc_fpachReceived = -1;             /* BOOLEAN */
static int hf_rrc_e_RUCCHFailure = -1;            /* BOOLEAN */
static int hf_rrc_location = -1;                  /* T_location */
static int hf_rrc_ellipsoidPoint = -1;            /* EllipsoidPoint */
static int hf_rrc_ellipsoidPointUncertCircle = -1;  /* EllipsoidPointUncertCircle */
static int hf_rrc_ellipsoidPointUncertEllipse = -1;  /* EllipsoidPointUncertEllipse */
static int hf_rrc_ellipsoidPointAltitude = -1;    /* EllipsoidPointAltitude */
static int hf_rrc_ellipsoidPointAltitudeEllipse = -1;  /* EllipsoidPointAltitudeEllipsoide */
static int hf_rrc_horizontalVelocity = -1;        /* HorizontalVelocity */
static int hf_rrc_timeSinceFailure = -1;          /* INTEGER_0_172800 */
static int hf_rrc_modeSpecificInfo_118 = -1;      /* T_modeSpecificInfo_118 */
static int hf_rrc_fdd_163 = -1;                   /* T_fdd_157 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo = -1;  /* LoggedConnectionEstablishmentFailureInfo_FDD */
static int hf_rrc_tdd_113 = -1;                   /* T_tdd_105 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo_01 = -1;  /* LoggedConnectionEstablishmentFailureInfo_TDD128 */
static int hf_rrc_eutraCellIdentity = -1;         /* BIT_STRING_SIZE_28 */
static int hf_rrc_gsmCellIdentity = -1;           /* BIT_STRING_SIZE_16 */
static int hf_rrc_bandIndicator_01 = -1;          /* Frequency_Band */
static int hf_rrc_absoluteTimeInfo = -1;          /* BIT_STRING_SIZE_48 */
static int hf_rrc_loggingDuration_01 = -1;        /* T_loggingDuration_01 */
static int hf_rrc_loggingInterval = -1;           /* T_loggingInterval */
static int hf_rrc_traceReference = -1;            /* TraceReference */
static int hf_rrc_traceRecordingSession = -1;     /* TraceRecordingSession */
static int hf_rrc_tce_Id = -1;                    /* TCE_Id */
static int hf_rrc_areaConfiguration = -1;         /* T_areaConfiguration */
static int hf_rrc_cellIDList = -1;                /* SEQUENCE_SIZE_1_32_OF_CellIdentity */
static int hf_rrc_cellIDList_item = -1;           /* CellIdentity */
static int hf_rrc_locationAreaList = -1;          /* SEQUENCE_SIZE_1_8_OF_LAI */
static int hf_rrc_locationAreaList_item = -1;     /* LAI */
static int hf_rrc_routingAreaList = -1;           /* SEQUENCE_SIZE_1_8_OF_RAI */
static int hf_rrc_routingAreaList_item = -1;      /* RAI */
static int hf_rrc_loggingDuration_02 = -1;        /* T_loggingDuration_02 */
static int hf_rrc_loggingInterval_01 = -1;        /* T_loggingInterval_01 */
static int hf_rrc_plmnList = -1;                  /* PlmnList */
static int hf_rrc_areaConfiguration_01 = -1;      /* T_areaConfiguration_01 */
static int hf_rrc_cellIDList_01 = -1;             /* SEQUENCE_SIZE_1_32_OF_CellIDListItem */
static int hf_rrc_cellIDList_item_01 = -1;        /* CellIDListItem */
static int hf_rrc_LoggedMeasInterfreqList_FDD_item = -1;  /* LoggedMeasInterfreqInfo_FDD */
static int hf_rrc_loggedMeasInterfreqNeighbourList = -1;  /* SEQUENCE_SIZE_1_maxnumLoggedMeas_OF_LoggedMeasNeighbourInfo_FDD */
static int hf_rrc_loggedMeasInterfreqNeighbourList_item = -1;  /* LoggedMeasNeighbourInfo_FDD */
static int hf_rrc_loggedMeasInterfreqNeighbourList_01 = -1;  /* LoggedMeasInterfreqNeighbourList_TDD128 */
static int hf_rrc_loggedMeasEUTRAFreqList = -1;   /* LoggedMeasEUTRAFreqList */
static int hf_rrc_loggedMeasGSMNeighbourCellsList = -1;  /* LoggedMeasGSMNeighbourCellsList */
static int hf_rrc_loggedMeasEUTRAFreqList_01 = -1;  /* LoggedMeasEUTRAFreqList_vb50ext */
static int hf_rrc_LoggedMeasIntrafreqNeighbourList_FDD_item = -1;  /* LoggedMeasNeighbourInfo_FDD */
static int hf_rrc_LoggedMeasIntrafreqNeighbourMeasList_TDD128_item = -1;  /* LoggedMeasNeighbourMeas_TDD128 */
static int hf_rrc_LoggedMeasGSMNeighbourCellsList_item = -1;  /* LoggedMeasGSMNeighbourCellsinfo */
static int hf_rrc_LoggedMeasEUTRAFreqList_item = -1;  /* LoggedMeasEUTRAFreqInfo */
static int hf_rrc_LoggedMeasEUTRAFreqList_vb50ext_item = -1;  /* LoggedMeasEUTRAFreqInfo_vb50ext */
static int hf_rrc_loggedMeasEUTRAFreqNeighbourInfoList = -1;  /* SEQUENCE_SIZE_1_maxnumLoggedMeas_OF_LoggedMeasEUTRAFreqNeighbourInfo */
static int hf_rrc_loggedMeasEUTRAFreqNeighbourInfoList_item = -1;  /* LoggedMeasEUTRAFreqNeighbourInfo */
static int hf_rrc_relativeTimeStamp = -1;         /* INTEGER_0_7200 */
static int hf_rrc_loggedMeasServingCellMeas = -1;  /* LoggedMeasServingCellMeas_FDD */
static int hf_rrc_loggedMeasInterRATNeighbourMeas_01 = -1;  /* LoggedMeasInterRATNeighbourMeas */
static int hf_rrc_loggedMeasLocationInfo = -1;    /* LoggedMeasLocationInfo */
static int hf_rrc_loggedMeasServingCellMeas_01 = -1;  /* LoggedMeasServingCellMeas_FDD_vb50ext */
static int hf_rrc_loggedMeasLocationInfo_01 = -1;  /* LoggedMeasLocationInfo_vb50ext */
static int hf_rrc_loggedMeasServingCellMeas_02 = -1;  /* LoggedMeasServingCellMeas_TDD128 */
static int hf_rrc_loggedMeasServingCellMeas_03 = -1;  /* LoggedMeasServingCellMeas_TDD128_vb50ext */
static int hf_rrc_LoggedMeasInfoList_FDD_item = -1;  /* LoggedMeasInfo_FDD */
static int hf_rrc_LoggedMeasInfoList_FDD_vb50ext_item = -1;  /* LoggedMeasInfo_FDD_vb50ext */
static int hf_rrc_LoggedMeasInfoList_TDD128_item = -1;  /* LoggedMeasInfo_TDD128 */
static int hf_rrc_LoggedMeasInfoList_TDD128_vb50ext_item = -1;  /* LoggedMeasInfo_TDD128_vb50ext */
static int hf_rrc_modeSpecificInfo_119 = -1;      /* T_modeSpecificInfo_119 */
static int hf_rrc_fdd_164 = -1;                   /* T_fdd_158 */
static int hf_rrc_loggedMeasInfoList = -1;        /* LoggedMeasInfoList_FDD */
static int hf_rrc_tdd_114 = -1;                   /* T_tdd_106 */
static int hf_rrc_loggedMeasInfoList_01 = -1;     /* LoggedMeasInfoList_TDD128 */
static int hf_rrc_modeSpecificInfo_120 = -1;      /* T_modeSpecificInfo_120 */
static int hf_rrc_fdd_165 = -1;                   /* T_fdd_159 */
static int hf_rrc_loggedMeasInfoList_02 = -1;     /* LoggedMeasInfoList_FDD_vb50ext */
static int hf_rrc_tdd_115 = -1;                   /* T_tdd_107 */
static int hf_rrc_loggedMeasInfoList_03 = -1;     /* LoggedMeasInfoList_TDD128_vb50ext */
static int hf_rrc_LoggedMeasInterfreqList_TDD128_item = -1;  /* LoggedMeasInterfreqInfo_TDD128 */
static int hf_rrc_LoggedMeasInterfreqNeighbourList_TDD128_item = -1;  /* LoggedMeasNeighbourMeas_TDD128 */
static int hf_rrc_loggedMeasInfoList_04 = -1;     /* LoggedMeasInfoList */
static int hf_rrc_loggedMeasAvailable_07 = -1;    /* T_loggedMeasAvailable_07 */
static int hf_rrc_loggedMeasInfoList_05 = -1;     /* LoggedMeasInfoList_vb50ext */
static int hf_rrc_plmnIdentity = -1;              /* PLMN_Identity */
static int hf_rrc_rscpforANR = -1;                /* RSCPforANR */
static int hf_rrc_ec_N0forANR = -1;               /* Ec_N0forANR */
static int hf_rrc_toe_nav = -1;                   /* BIT_STRING_SIZE_14 */
static int hf_rrc_ganss_omega_nav = -1;           /* BIT_STRING_SIZE_32 */
static int hf_rrc_delta_n_nav = -1;               /* BIT_STRING_SIZE_16 */
static int hf_rrc_m_zero_nav = -1;                /* BIT_STRING_SIZE_32 */
static int hf_rrc_omegadot_nav = -1;              /* BIT_STRING_SIZE_24 */
static int hf_rrc_ganss_e_nav = -1;               /* BIT_STRING_SIZE_32 */
static int hf_rrc_idot_nav = -1;                  /* BIT_STRING_SIZE_14 */
static int hf_rrc_a_sqrt_nav = -1;                /* BIT_STRING_SIZE_32 */
static int hf_rrc_i_zero_nav = -1;                /* BIT_STRING_SIZE_32 */
static int hf_rrc_omega_zero_nav = -1;            /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_rs_nav = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_is_nav = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_us_nav = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_rc_nav = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_ic_nav = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_uc_nav = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_intraFreqMeasuredResultsList = -1;  /* IntraFreqMeasuredResultsList */
static int hf_rrc_interFreqMeasuredResultsList = -1;  /* InterFreqMeasuredResultsList */
static int hf_rrc_interRATMeasuredResultsList = -1;  /* InterRATMeasuredResultsList */
static int hf_rrc_trafficVolumeMeasuredResultsList = -1;  /* TrafficVolumeMeasuredResultsList */
static int hf_rrc_qualityMeasuredResults = -1;    /* QualityMeasuredResults */
static int hf_rrc_ue_InternalMeasuredResults = -1;  /* UE_InternalMeasuredResults */
static int hf_rrc_ue_positioning_MeasuredResults = -1;  /* UE_Positioning_MeasuredResults */
static int hf_rrc_intraFreqMeasuredResultsList_01 = -1;  /* IntraFrequencyMeasuredResultsListOnSecULFreq */
static int hf_rrc_ue_positioning_MeasuredResults_v390ext = -1;  /* UE_Positioning_MeasuredResults_v390ext */
static int hf_rrc_intraFrequencyMeasuredResultsList = -1;  /* IntraFrequencyMeasuredResultsList_v590ext */
static int hf_rrc_interFrequencyMeasuredResultsList = -1;  /* InterFrequencyMeasuredResultsList_v590ext */
static int hf_rrc_ueInternalMeasuredResults = -1;  /* UE_InternalMeasuredResults_v770ext */
static int hf_rrc_ue_positioning_MeasuredResults_01 = -1;  /* UE_Positioning_MeasuredResults_v770ext */
static int hf_rrc_ue_positioning_MeasuredResults_02 = -1;  /* UE_Positioning_MeasuredResults_v860ext */
static int hf_rrc_MeasuredResultsList_v920ext_item = -1;  /* MeasuredResults_v920ext */
static int hf_rrc_MeasuredResultsListOnSecUlFreq_item = -1;  /* MeasuredResultsOnSecUlFreq */
static int hf_rrc_intraFreqMeasuredResultsList_02 = -1;  /* IntraFreqMeasuredResultsList_v920ext */
static int hf_rrc_interFreqMeasuredResultsList_01 = -1;  /* InterFreqMeasuredResultsList_v920ext */
static int hf_rrc_ue_InternalMeasuredResults_01 = -1;  /* UE_InternalMeasuredResults_LCR_r4 */
static int hf_rrc_ue_positioniing_MeasuredResults = -1;  /* UE_Positioning_MeasuredResults */
static int hf_rrc_MeasuredResultsList_item = -1;  /* MeasuredResults */
static int hf_rrc_MeasuredResultsList_LCR_r4_ext_item = -1;  /* MeasuredResults_LCR_r4 */
static int hf_rrc_MeasuredResultsList_v770xet_item = -1;  /* MeasuredResultsList_v770xet_item */
static int hf_rrc_MeasuredResultsList_v860ext_item = -1;  /* MeasuredResultsList_v860ext_item */
static int hf_rrc_currentCell = -1;               /* T_currentCell */
static int hf_rrc_modeSpecificInfo_121 = -1;      /* T_modeSpecificInfo_121 */
static int hf_rrc_fdd_166 = -1;                   /* T_fdd_160 */
static int hf_rrc_measurementQuantity_03 = -1;    /* T_measurementQuantity_01 */
static int hf_rrc_tdd_116 = -1;                   /* T_tdd_108 */
static int hf_rrc_timeslotISCP = -1;              /* TimeslotISCP_List */
static int hf_rrc_monitoredCells = -1;            /* MonitoredCellRACH_List */
static int hf_rrc_currentCell_DeltaRSCP = -1;     /* DeltaRSCPPerCell */
static int hf_rrc_monitoredCellRACH_List_v7g0ext = -1;  /* MonitoredCellRACH_List_v7g0ext */
static int hf_rrc_MonitoredCellRACH_List_v7g0ext_item = -1;  /* DeltaRSCPPerCell */
static int hf_rrc_currentCell_01 = -1;            /* T_currentCell_01 */
static int hf_rrc_measurementQuantity_04 = -1;    /* T_measurementQuantity_02 */
static int hf_rrc_measuredResultsUsedFreq = -1;   /* MonitoredCellRACH_ListFDD_r11 */
static int hf_rrc_measuredResultsNonUsedFreq = -1;  /* MeasuredResultsOnRACHinterFreq */
static int hf_rrc_measuredResultsEUTRAFreq = -1;  /* MeasuredResultsOnRACH_EUTRAFreq */
static int hf_rrc_interFreqCellIndication_SIB11 = -1;  /* INTEGER_0_1 */
static int hf_rrc_interFreqCellIndication_SIB12 = -1;  /* INTEGER_0_1 */
static int hf_rrc_interFreqRACHRepCellsList = -1;  /* InterFreqRACHRepCellsList */
static int hf_rrc_eutraFrequencyIndication_SIB19 = -1;  /* INTEGER_0_1 */
static int hf_rrc_setup = -1;                     /* MeasurementType */
static int hf_rrc_modify_01 = -1;                 /* T_modify_01 */
static int hf_rrc_measurementType = -1;           /* MeasurementType */
static int hf_rrc_setup_01 = -1;                  /* MeasurementType_r4 */
static int hf_rrc_modify_02 = -1;                 /* T_modify_02 */
static int hf_rrc_measurementType_01 = -1;        /* MeasurementType_r4 */
static int hf_rrc_setup_02 = -1;                  /* MeasurementType_r6 */
static int hf_rrc_modify_03 = -1;                 /* T_modify_03 */
static int hf_rrc_measurementType_02 = -1;        /* MeasurementType_r6 */
static int hf_rrc_setup_03 = -1;                  /* MeasurementType_r7 */
static int hf_rrc_modify_04 = -1;                 /* T_modify_04 */
static int hf_rrc_measurementType_03 = -1;        /* MeasurementType_r7 */
static int hf_rrc_setup_04 = -1;                  /* MeasurementType_r8 */
static int hf_rrc_modify_05 = -1;                 /* T_modify_05 */
static int hf_rrc_measurementType_04 = -1;        /* MeasurementType_r8 */
static int hf_rrc_setup_05 = -1;                  /* MeasurementType_r9 */
static int hf_rrc_modify_06 = -1;                 /* T_modify_06 */
static int hf_rrc_measurementType_05 = -1;        /* MeasurementType_r9 */
static int hf_rrc_setup_06 = -1;                  /* MeasurementType_r10 */
static int hf_rrc_modify_07 = -1;                 /* T_modify_07 */
static int hf_rrc_measurementType_06 = -1;        /* MeasurementType_r10 */
static int hf_rrc_setup_07 = -1;                  /* MeasurementType_r11 */
static int hf_rrc_modify_08 = -1;                 /* T_modify_08 */
static int hf_rrc_measurementType_07 = -1;        /* MeasurementType_r11 */
static int hf_rrc_use_of_HCS = -1;                /* T_use_of_HCS */
static int hf_rrc_hcs_not_used = -1;              /* T_hcs_not_used */
static int hf_rrc_cellSelectQualityMeasure_01 = -1;  /* T_cellSelectQualityMeasure_01 */
static int hf_rrc_cpich_RSCP_02 = -1;             /* T_cpich_RSCP */
static int hf_rrc_intraFreqMeasurementSysInfo = -1;  /* IntraFreqMeasurementSysInfo_RSCP */
static int hf_rrc_interFreqMeasurementSysInfo = -1;  /* InterFreqMeasurementSysInfo_RSCP */
static int hf_rrc_cpich_Ec_N0_02 = -1;            /* T_cpich_Ec_N0_01 */
static int hf_rrc_intraFreqMeasurementSysInfo_01 = -1;  /* IntraFreqMeasurementSysInfo_ECN0 */
static int hf_rrc_interFreqMeasurementSysInfo_01 = -1;  /* InterFreqMeasurementSysInfo_ECN0 */
static int hf_rrc_interRATMeasurementSysInfo = -1;  /* InterRATMeasurementSysInfo_B */
static int hf_rrc_hcs_used = -1;                  /* T_hcs_used */
static int hf_rrc_cellSelectQualityMeasure_02 = -1;  /* T_cellSelectQualityMeasure_02 */
static int hf_rrc_cpich_RSCP_03 = -1;             /* T_cpich_RSCP_01 */
static int hf_rrc_intraFreqMeasurementSysInfo_02 = -1;  /* IntraFreqMeasurementSysInfo_HCS_RSCP */
static int hf_rrc_interFreqMeasurementSysInfo_02 = -1;  /* InterFreqMeasurementSysInfo_HCS_RSCP */
static int hf_rrc_cpich_Ec_N0_03 = -1;            /* T_cpich_Ec_N0_02 */
static int hf_rrc_intraFreqMeasurementSysInfo_03 = -1;  /* IntraFreqMeasurementSysInfo_HCS_ECN0 */
static int hf_rrc_interFreqMeasurementSysInfo_03 = -1;  /* InterFreqMeasurementSysInfo_HCS_ECN0 */
static int hf_rrc_interRATMeasurementSysInfo_01 = -1;  /* InterRATMeasurementSysInfo */
static int hf_rrc_trafficVolumeMeasSysInfo = -1;  /* TrafficVolumeMeasSysInfo */
static int hf_rrc_dummy_54 = -1;                  /* UE_InternalMeasurementSysInfo */
static int hf_rrc_use_of_HCS_01 = -1;             /* T_use_of_HCS_01 */
static int hf_rrc_hcs_not_used_01 = -1;           /* T_hcs_not_used_01 */
static int hf_rrc_cellSelectQualityMeasure_03 = -1;  /* T_cellSelectQualityMeasure_03 */
static int hf_rrc_cpich_RSCP_04 = -1;             /* T_cpich_RSCP_02 */
static int hf_rrc_cpich_Ec_N0_04 = -1;            /* T_cpich_Ec_N0_03 */
static int hf_rrc_hcs_used_01 = -1;               /* T_hcs_used_01 */
static int hf_rrc_cellSelectQualityMeasure_04 = -1;  /* T_cellSelectQualityMeasure_04 */
static int hf_rrc_cpich_RSCP_05 = -1;             /* T_cpich_RSCP_03 */
static int hf_rrc_cpich_Ec_N0_05 = -1;            /* T_cpich_Ec_N0_04 */
static int hf_rrc_newIntraFrequencyCellInfoListAddon_r5 = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newIntraFrequencyCellInfoListAddon_r5_item = -1;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoListAddon_r5 = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoListAddon_r5_item = -1;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoListAddon_r5 = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoListAddon_r5_item = -1;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_use_of_HCS_02 = -1;             /* T_use_of_HCS_02 */
static int hf_rrc_hcs_not_used_02 = -1;           /* T_hcs_not_used_02 */
static int hf_rrc_cellSelectQualityMeasure_05 = -1;  /* T_cellSelectQualityMeasure_05 */
static int hf_rrc_cpich_RSCP_06 = -1;             /* T_cpich_RSCP_04 */
static int hf_rrc_cpich_Ec_N0_06 = -1;            /* T_cpich_Ec_N0_05 */
static int hf_rrc_hcs_used_02 = -1;               /* T_hcs_used_02 */
static int hf_rrc_cellSelectQualityMeasure_06 = -1;  /* T_cellSelectQualityMeasure_06 */
static int hf_rrc_cpich_RSCP_07 = -1;             /* T_cpich_RSCP_05 */
static int hf_rrc_cpich_Ec_N0_07 = -1;            /* T_cpich_Ec_N0_06 */
static int hf_rrc_use_of_HCS_03 = -1;             /* T_use_of_HCS_03 */
static int hf_rrc_hcs_not_used_03 = -1;           /* T_hcs_not_used_03 */
static int hf_rrc_cellSelectQualityMeasure_07 = -1;  /* T_cellSelectQualityMeasure_07 */
static int hf_rrc_cpich_RSCP_08 = -1;             /* T_cpich_RSCP_06 */
static int hf_rrc_intraFreqMeasurementSysInfo_04 = -1;  /* IntraFreqMeasurementSysInfo_RSCP_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_04 = -1;  /* InterFreqMeasurementSysInfo_RSCP_LCR_r4 */
static int hf_rrc_cpich_Ec_N0_08 = -1;            /* T_cpich_Ec_N0_07 */
static int hf_rrc_intraFreqMeasurementSysInfo_05 = -1;  /* IntraFreqMeasurementSysInfo_ECN0_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_05 = -1;  /* InterFreqMeasurementSysInfo_ECN0_LCR_r4 */
static int hf_rrc_hcs_used_03 = -1;               /* T_hcs_used_03 */
static int hf_rrc_cellSelectQualityMeasure_08 = -1;  /* T_cellSelectQualityMeasure_08 */
static int hf_rrc_cpich_RSCP_09 = -1;             /* T_cpich_RSCP_07 */
static int hf_rrc_intraFreqMeasurementSysInfo_06 = -1;  /* IntraFreqMeasurementSysInfo_HCS_RSCP_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_06 = -1;  /* InterFreqMeasurementSysInfo_HCS_RSCP_LCR_r4 */
static int hf_rrc_cpich_Ec_N0_09 = -1;            /* T_cpich_Ec_N0_08 */
static int hf_rrc_intraFreqMeasurementSysInfo_07 = -1;  /* IntraFreqMeasurementSysInfo_HCS_ECN0_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_07 = -1;  /* InterFreqMeasurementSysInfo_HCS_ECN0_LCR_r4 */
static int hf_rrc_measurement_Occasion_Coeff = -1;  /* INTEGER_1_9 */
static int hf_rrc_measurement_Occasion_Offset = -1;  /* INTEGER_0_511 */
static int hf_rrc_measurement_Occasion_Length = -1;  /* INTEGER_1_512 */
static int hf_rrc_timeslotBitmap = -1;            /* BIT_STRING_SIZE_7 */
static int hf_rrc_measurementReportTransferMode = -1;  /* TransferMode */
static int hf_rrc_periodicalOrEventTrigger = -1;  /* PeriodicalOrEventTrigger */
static int hf_rrc_intraFrequencyMeasurement = -1;  /* IntraFrequencyMeasurement */
static int hf_rrc_interFrequencyMeasurement = -1;  /* InterFrequencyMeasurement */
static int hf_rrc_interRATMeasurement_01 = -1;    /* InterRATMeasurement */
static int hf_rrc_ue_positioning_Measurement = -1;  /* UE_Positioning_Measurement */
static int hf_rrc_trafficVolumeMeasurement = -1;  /* TrafficVolumeMeasurement */
static int hf_rrc_qualityMeasurement = -1;        /* QualityMeasurement */
static int hf_rrc_ue_InternalMeasurement = -1;    /* UE_InternalMeasurement */
static int hf_rrc_intraFrequencyMeasurement_01 = -1;  /* IntraFrequencyMeasurement_r4 */
static int hf_rrc_interFrequencyMeasurement_01 = -1;  /* InterFrequencyMeasurement_r4 */
static int hf_rrc_interRATMeasurement_02 = -1;    /* InterRATMeasurement_r4 */
static int hf_rrc_up_Measurement = -1;            /* UE_Positioning_Measurement_r4 */
static int hf_rrc_ue_InternalMeasurement_01 = -1;  /* UE_InternalMeasurement_r4 */
static int hf_rrc_intraFrequencyMeasurement_02 = -1;  /* IntraFrequencyMeasurement_r6 */
static int hf_rrc_interFrequencyMeasurement_02 = -1;  /* InterFrequencyMeasurement_r6 */
static int hf_rrc_interRATMeasurement_03 = -1;    /* InterRATMeasurement_r6 */
static int hf_rrc_intraFrequencyMeasurement_03 = -1;  /* IntraFrequencyMeasurement_r7 */
static int hf_rrc_interFrequencyMeasurement_03 = -1;  /* InterFrequencyMeasurement_r7 */
static int hf_rrc_up_Measurement_01 = -1;         /* UE_Positioning_Measurement_r7 */
static int hf_rrc_interFrequencyMeasurement_04 = -1;  /* InterFrequencyMeasurement_r8 */
static int hf_rrc_interRATMeasurement_04 = -1;    /* InterRATMeasurement_r8 */
static int hf_rrc_up_Measurement_02 = -1;         /* UE_Positioning_Measurement_r8 */
static int hf_rrc_intraFrequencyMeasurement_04 = -1;  /* IntraFrequencyMeasurement_r9 */
static int hf_rrc_interFrequencyMeasurement_05 = -1;  /* InterFrequencyMeasurement_r9 */
static int hf_rrc_interRATMeasurement_05 = -1;    /* InterRATMeasurement_r9 */
static int hf_rrc_up_Measurement_03 = -1;         /* UE_Positioning_Measurement_r9 */
static int hf_rrc_csgProximityDetection = -1;     /* CSGProximityDetection */
static int hf_rrc_intraFrequencyMeasurement_05 = -1;  /* IntraFrequencyMeasurement_r10 */
static int hf_rrc_interFrequencyMeasurement_06 = -1;  /* InterFrequencyMeasurement_r10 */
static int hf_rrc_up_Measurement_04 = -1;         /* UE_Positioning_Measurement_r10 */
static int hf_rrc_intraFrequencyMeasurement_06 = -1;  /* IntraFrequencyMeasurement_r11 */
static int hf_rrc_interFrequencyMeasurement_07 = -1;  /* InterFrequencyMeasurement_r11 */
static int hf_rrc_eutraMeasurementForCELLFACH = -1;  /* EUTRA_MeasurementForCELLFACH */
static int hf_rrc_ue_State = -1;                  /* T_ue_State */
static int hf_rrc_MonitoredCellRACH_List_item = -1;  /* MonitoredCellRACH_Result */
static int hf_rrc_sfn_SFN_ObsTimeDifference = -1;  /* SFN_SFN_ObsTimeDifference */
static int hf_rrc_modeSpecificInfo_122 = -1;      /* T_modeSpecificInfo_122 */
static int hf_rrc_fdd_167 = -1;                   /* T_fdd_161 */
static int hf_rrc_measurementQuantity_05 = -1;    /* T_measurementQuantity_03 */
static int hf_rrc_tdd_117 = -1;                   /* T_tdd_109 */
static int hf_rrc_MonitoredCellRACH_ListFDD_r11_item = -1;  /* MonitoredCellRACH_ResultFDD_r11 */
static int hf_rrc_measurementQuantity_06 = -1;    /* T_measurementQuantity_04 */
static int hf_rrc_MultipleEUTRAFrequencyBandIndicatorList_item = -1;  /* RadioFrequencyBandEUTRA */
static int hf_rrc_MultipleEUTRAFrequencyBandIndicatorExtensionList_item = -1;  /* RadioFrequencyBandEUTRAExt */
static int hf_rrc_multipleEUTRAFrequencyBandIndicatorlist = -1;  /* MultipleEUTRAFrequencyBandIndicatorList */
static int hf_rrc_multipleEUTRAFrequencyBandIndicatorlist_01 = -1;  /* MultipleEUTRAFrequencyBandIndicatorExtensionList */
static int hf_rrc_MultipleEUTRAFrequencyInfoList_item = -1;  /* MultipleEUTRAFrequencyBandInfo */
static int hf_rrc_MultipleEUTRAFrequencyInfoExtensionList_item = -1;  /* MultipleEUTRAFrequencyBandExtensionInfo */
static int hf_rrc_MultipleFrequencyBandIndicatorListFDD_item = -1;  /* FrequencyBandsIndicatorFDD */
static int hf_rrc_multipleFrequencyBandIndicatorListFDD = -1;  /* MultipleFrequencyBandIndicatorListFDD */
static int hf_rrc_MultipleFrequencyInfoListFDD_item = -1;  /* MultipleFrequencyBandInfo */
static int hf_rrc_n_CR = -1;                      /* INTEGER_1_16 */
static int hf_rrc_t_CRMaxHyst = -1;               /* T_CRMaxHyst */
static int hf_rrc_navToc = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navaf2 = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_navaf1 = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navaf0 = -1;                    /* BIT_STRING_SIZE_22 */
static int hf_rrc_navTgd = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_satelliteStatus = -1;           /* SatelliteStatus */
static int hf_rrc_ephemerisParameter = -1;        /* EphemerisParameter */
static int hf_rrc_NavigationModelSatInfoList_item = -1;  /* NavigationModelSatInfo */
static int hf_rrc_cnavURAindex = -1;              /* BIT_STRING_SIZE_5 */
static int hf_rrc_cnavDeltaA = -1;                /* BIT_STRING_SIZE_26 */
static int hf_rrc_cnavAdot = -1;                  /* BIT_STRING_SIZE_25 */
static int hf_rrc_cnavDeltaNo = -1;               /* BIT_STRING_SIZE_17 */
static int hf_rrc_cnavDeltaNoDot = -1;            /* BIT_STRING_SIZE_23 */
static int hf_rrc_cnavMo = -1;                    /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavE = -1;                     /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavOmega = -1;                 /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavOMEGA0 = -1;                /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavDeltaOmegaDot = -1;         /* BIT_STRING_SIZE_17 */
static int hf_rrc_cnavIo = -1;                    /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavIoDot = -1;                 /* BIT_STRING_SIZE_15 */
static int hf_rrc_cnavCis = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_cnavCic = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_cnavCrs = -1;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_cnavCrc = -1;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_cnavCus = -1;                   /* BIT_STRING_SIZE_21 */
static int hf_rrc_cnavCuc = -1;                   /* BIT_STRING_SIZE_21 */
static int hf_rrc_gloEn = -1;                     /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloP1 = -1;                     /* BIT_STRING_SIZE_2 */
static int hf_rrc_gloP2 = -1;                     /* BIT_STRING_SIZE_1 */
static int hf_rrc_gloM = -1;                      /* BIT_STRING_SIZE_2 */
static int hf_rrc_gloX = -1;                      /* BIT_STRING_SIZE_27 */
static int hf_rrc_gloXdot = -1;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_gloXdotdot = -1;                /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloY = -1;                      /* BIT_STRING_SIZE_27 */
static int hf_rrc_gloYdot = -1;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_gloYdotdot = -1;                /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloZ = -1;                      /* BIT_STRING_SIZE_27 */
static int hf_rrc_gloZdot = -1;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_gloZdotdot = -1;                /* BIT_STRING_SIZE_5 */
static int hf_rrc_navURA = -1;                    /* BIT_STRING_SIZE_4 */
static int hf_rrc_navFitFlag = -1;                /* BIT_STRING_SIZE_1 */
static int hf_rrc_navToe = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navOmega = -1;                  /* BIT_STRING_SIZE_32 */
static int hf_rrc_navDeltaN = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_rrc_navM0 = -1;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_navOmegaADot = -1;              /* BIT_STRING_SIZE_24 */
static int hf_rrc_navE = -1;                      /* BIT_STRING_SIZE_32 */
static int hf_rrc_navIDot = -1;                   /* BIT_STRING_SIZE_14 */
static int hf_rrc_navAPowerHalf = -1;             /* BIT_STRING_SIZE_32 */
static int hf_rrc_navI0 = -1;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_navOmegaA0 = -1;                /* BIT_STRING_SIZE_32 */
static int hf_rrc_navCrs = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCis = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCus = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCrc = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCic = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCuc = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_sbasTo = -1;                    /* BIT_STRING_SIZE_13 */
static int hf_rrc_sbasAccuracy = -1;              /* BIT_STRING_SIZE_4 */
static int hf_rrc_sbasXg = -1;                    /* BIT_STRING_SIZE_30 */
static int hf_rrc_sbasYg = -1;                    /* BIT_STRING_SIZE_30 */
static int hf_rrc_sbasZg = -1;                    /* BIT_STRING_SIZE_25 */
static int hf_rrc_sbasXgDot = -1;                 /* BIT_STRING_SIZE_17 */
static int hf_rrc_sbasYgDot = -1;                 /* BIT_STRING_SIZE_17 */
static int hf_rrc_sbasZgDot = -1;                 /* BIT_STRING_SIZE_18 */
static int hf_rrc_sbasXgDotDot = -1;              /* BIT_STRING_SIZE_10 */
static int hf_rrc_sbagYgDotDot = -1;              /* BIT_STRING_SIZE_10 */
static int hf_rrc_sbasZgDotDot = -1;              /* BIT_STRING_SIZE_10 */
static int hf_rrc_codeOnL2 = -1;                  /* BIT_STRING_SIZE_2 */
static int hf_rrc_uraIndex = -1;                  /* BIT_STRING_SIZE_4 */
static int hf_rrc_satHealth_01 = -1;              /* BIT_STRING_SIZE_6 */
static int hf_rrc_iodc = -1;                      /* BIT_STRING_SIZE_10 */
static int hf_rrc_l2Pflag = -1;                   /* BIT_STRING_SIZE_1 */
static int hf_rrc_sf1Revd = -1;                   /* SubFrame1Reserved */
static int hf_rrc_t_GD = -1;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_t_oc = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_af2 = -1;                       /* BIT_STRING_SIZE_8 */
static int hf_rrc_af1_01 = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_af0_01 = -1;                    /* BIT_STRING_SIZE_22 */
static int hf_rrc_c_rs = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_delta_n = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_m0_01 = -1;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_uc = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_e_01 = -1;                      /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_us = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_a_Sqrt_01 = -1;                 /* BIT_STRING_SIZE_32 */
static int hf_rrc_t_oe = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_fitInterval = -1;               /* BIT_STRING_SIZE_1 */
static int hf_rrc_aodo = -1;                      /* BIT_STRING_SIZE_5 */
static int hf_rrc_c_ic = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_omega0_01 = -1;                 /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_is = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_i0 = -1;                        /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_rc = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_omega_01 = -1;                  /* BIT_STRING_SIZE_32 */
static int hf_rrc_omegaDot_01 = -1;               /* BIT_STRING_SIZE_24 */
static int hf_rrc_iDot = -1;                      /* BIT_STRING_SIZE_14 */
static int hf_rrc_modeSpecificInfo_123 = -1;      /* T_modeSpecificInfo_123 */
static int hf_rrc_fdd_168 = -1;                   /* T_fdd_162 */
static int hf_rrc_neighbourIdentity = -1;         /* PrimaryCPICH_Info */
static int hf_rrc_uE_RX_TX_TimeDifferenceType2Info = -1;  /* UE_RX_TX_TimeDifferenceType2Info */
static int hf_rrc_tdd_118 = -1;                   /* T_tdd_110 */
static int hf_rrc_neighbourAndChannelIdentity = -1;  /* CellAndChannelIdentity */
static int hf_rrc_neighbourQuality = -1;          /* NeighbourQuality */
static int hf_rrc_sfn_SFN_ObsTimeDifference2 = -1;  /* SFN_SFN_ObsTimeDifference2 */
static int hf_rrc_modeSpecificInfo_124 = -1;      /* T_modeSpecificInfo_124 */
static int hf_rrc_fdd_169 = -1;                   /* T_fdd_163 */
static int hf_rrc_NeighbourList_item = -1;        /* Neighbour */
static int hf_rrc_NeighbourList_TDD_r7_item = -1;  /* Neighbour_TDD_r7 */
static int hf_rrc_NeighbourList_v390ext_item = -1;  /* Neighbour_v390ext */
static int hf_rrc_ue_Positioning_OTDOA_Quality = -1;  /* UE_Positioning_OTDOA_Quality */
static int hf_rrc_interFreqCellID = -1;           /* InterFreqCellID */
static int hf_rrc_cellInfo = -1;                  /* CellInfo */
static int hf_rrc_cellInfo_01 = -1;               /* CellInfo_r4 */
static int hf_rrc_intraSecondaryFreqIndicator = -1;  /* BOOLEAN */
static int hf_rrc_cellInfo_LCR_r8 = -1;           /* CellInfo_LCR_r8_ext */
static int hf_rrc_modeSpecificInfo_125 = -1;      /* T_modeSpecificInfo_125 */
static int hf_rrc_noInfo = -1;                    /* NULL */
static int hf_rrc_tdd128_64 = -1;                 /* T_tdd128_62 */
static int hf_rrc_cellInfo_02 = -1;               /* CellInfo_r9 */
static int hf_rrc_modeSpecificInfo_126 = -1;      /* T_modeSpecificInfo_126 */
static int hf_rrc_tdd128_65 = -1;                 /* T_tdd128_63 */
static int hf_rrc_modeSpecificInfo_127 = -1;      /* T_modeSpecificInfo_127 */
static int hf_rrc_tdd128_66 = -1;                 /* T_tdd128_64 */
static int hf_rrc_sNPLMonitorSetIndicator_TDD128 = -1;  /* BIT_STRING_SIZE_5 */
static int hf_rrc_NewInterFreqCellList_item = -1;  /* NewInterFreqCell */
static int hf_rrc_NewInterFreqCellList_r4_item = -1;  /* NewInterFreqCell_r4 */
static int hf_rrc_NewInterFreqCellList_v7b0ext_item = -1;  /* NewInterFreqCell_v7b0ext */
static int hf_rrc_NewInterFreqCellList_LCR_v8a0ext_item = -1;  /* NewInterFreqCell_LCR_v8a0ext */
static int hf_rrc_NewInterFreqCellList_r8_item = -1;  /* NewInterFreqCell_r8 */
static int hf_rrc_NewInterFreqCellList_r9_item = -1;  /* NewInterFreqCell_r9 */
static int hf_rrc_NewInterFreqCellList_r10_item = -1;  /* NewInterFreqCell_r10 */
static int hf_rrc_cellInfo_03 = -1;               /* CellInfoSI_RSCP */
static int hf_rrc_cellInfo_04 = -1;               /* CellInfoSI_ECN0 */
static int hf_rrc_cellInfo_05 = -1;               /* CellInfoSI_HCS_RSCP */
static int hf_rrc_cellInfo_06 = -1;               /* CellInfoSI_HCS_ECN0 */
static int hf_rrc_cellInfo_07 = -1;               /* CellInfoSI_RSCP_LCR_r4 */
static int hf_rrc_cellInfo_08 = -1;               /* CellInfoSI_ECN0_LCR_r4 */
static int hf_rrc_cellInfo_09 = -1;               /* CellInfoSI_HCS_RSCP_LCR_r4 */
static int hf_rrc_cellInfo_10 = -1;               /* CellInfoSI_HCS_ECN0_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_ECN0_item = -1;  /* NewInterFreqCellSI_ECN0 */
static int hf_rrc_NewInterFreqCellSI_List_HCS_RSCP_item = -1;  /* NewInterFreqCellSI_HCS_RSCP */
static int hf_rrc_NewInterFreqCellSI_List_HCS_ECN0_item = -1;  /* NewInterFreqCellSI_HCS_ECN0 */
static int hf_rrc_NewInterFreqCellSI_List_RSCP_item = -1;  /* NewInterFreqCellSI_RSCP */
static int hf_rrc_NewInterFreqCellSI_List_ECN0_LCR_r4_item = -1;  /* NewInterFreqCellSI_ECN0_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_HCS_RSCP_LCR_r4_item = -1;  /* NewInterFreqCellSI_HCS_RSCP_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_HCS_ECN0_LCR_r4_item = -1;  /* NewInterFreqCellSI_HCS_ECN0_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_RSCP_LCR_r4_item = -1;  /* NewInterFreqCellSI_RSCP_LCR_r4 */
static int hf_rrc_interRATCellID = -1;            /* InterRATCellID */
static int hf_rrc_technologySpecificInfo_01 = -1;  /* T_technologySpecificInfo_01 */
static int hf_rrc_gsm_16 = -1;                    /* T_gsm_14 */
static int hf_rrc_cellSelectionReselectionInfo_05 = -1;  /* CellSelectReselectInfoSIB_11_12 */
static int hf_rrc_interRATCellIndividualOffset = -1;  /* InterRATCellIndividualOffset */
static int hf_rrc_is_2000_03 = -1;                /* T_is_2000_02 */
static int hf_rrc_is_2000SpecificMeasInfo = -1;   /* IS_2000SpecificMeasInfo */
static int hf_rrc_technologySpecificInfo_02 = -1;  /* T_technologySpecificInfo_02 */
static int hf_rrc_gsm_17 = -1;                    /* T_gsm_15 */
static int hf_rrc_is_2000_04 = -1;                /* T_is_2000_03 */
static int hf_rrc_NewInterRATCellList_item = -1;  /* NewInterRATCell */
static int hf_rrc_NewInterRATCellList_B_item = -1;  /* NewInterRATCell_B */
static int hf_rrc_intraFreqCellID = -1;           /* IntraFreqCellID */
static int hf_rrc_modeSpecificInfo_128 = -1;      /* T_modeSpecificInfo_128 */
static int hf_rrc_tdd128_67 = -1;                 /* T_tdd128_65 */
static int hf_rrc_intraFreqCellIDOnSecULFreq = -1;  /* IntraFreqCellIDOnSecULFreq */
static int hf_rrc_NewIntraFreqCellList_item = -1;  /* NewIntraFreqCell */
static int hf_rrc_NewIntraFreqCellList_r4_item = -1;  /* NewIntraFreqCell_r4 */
static int hf_rrc_NewIntraFreqCellList_r9_item = -1;  /* NewIntraFreqCell_r9 */
static int hf_rrc_NewIntraFreqCellList_r10_item = -1;  /* NewIntraFreqCell_r10 */
static int hf_rrc_NewIntraFreqCellList_LCR_v8a0ext_item = -1;  /* NewIntraFreqCell_LCR_v8a0ext */
static int hf_rrc_NewIntraFreqCellListOnSecULFreq_item = -1;  /* NewIntraFreqCellOnSecULFreq */
static int hf_rrc_NewIntraFreqCellSI_List_RSCP_item = -1;  /* NewIntraFreqCellSI_RSCP */
static int hf_rrc_NewIntraFreqCellSI_List_ECN0_item = -1;  /* NewIntraFreqCellSI_ECN0 */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_RSCP_item = -1;  /* NewIntraFreqCellSI_HCS_RSCP */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_ECN0_item = -1;  /* NewIntraFreqCellSI_HCS_ECN0 */
static int hf_rrc_NewIntraFreqCellSI_List_RSCP_LCR_r4_item = -1;  /* NewIntraFreqCellSI_RSCP_LCR_r4 */
static int hf_rrc_NewIntraFreqCellSI_List_ECN0_LCR_r4_item = -1;  /* NewIntraFreqCellSI_ECN0_LCR_r4 */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_RSCP_LCR_r4_item = -1;  /* NewIntraFreqCellSI_HCS_RSCP_LCR_r4 */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_ECN0_LCR_r4_item = -1;  /* NewIntraFreqCellSI_HCS_ECN0_LCR_r4 */
static int hf_rrc_nonUsedFreqThreshold = -1;      /* Threshold */
static int hf_rrc_nonUsedFreqW = -1;              /* W */
static int hf_rrc_nonUsedFreqThreshold_01 = -1;   /* Threshold_r6 */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells = -1;  /* T_nonUsedFreqTriggeringConditionDetectedCells */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells_01 = -1;  /* T_nonUsedFreqTriggeringConditionDetectedCells_01 */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells_02 = -1;  /* T_nonUsedFreqTriggeringConditionDetectedCells_02 */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells_03 = -1;  /* T_nonUsedFreqTriggeringConditionDetectedCells_03 */
static int hf_rrc_NonUsedFreqParameterList_item = -1;  /* NonUsedFreqParameter */
static int hf_rrc_NonUsedFreqParameterList_r6_item = -1;  /* NonUsedFreqParameter_r6 */
static int hf_rrc_NonUsedFreqParameterList_r10_item = -1;  /* NonUsedFreqParameter_r10 */
static int hf_rrc_NonUsedFreqParameterList_r11_item = -1;  /* NonUsedFreqParameter_r11 */
static int hf_rrc_NonUsedFreq2aParameterList_r10_item = -1;  /* NonUsedFreq2aParameter_r10 */
static int hf_rrc_NonUsedFreq2aParameterList_r11_item = -1;  /* NonUsedFreq2aParameter_r11 */
static int hf_rrc_NonUsedFreqWList_r6_item = -1;  /* W */
static int hf_rrc_notUsed = -1;                   /* NULL */
static int hf_rrc_pt10 = -1;                      /* TemporaryOffset1 */
static int hf_rrc_pt20 = -1;                      /* TemporaryOffset1 */
static int hf_rrc_pt30 = -1;                      /* TemporaryOffset1 */
static int hf_rrc_pt40 = -1;                      /* TemporaryOffset1 */
static int hf_rrc_pt50 = -1;                      /* TemporaryOffset1 */
static int hf_rrc_pt60 = -1;                      /* TemporaryOffset1 */
static int hf_rrc_pt10_01 = -1;                   /* TemporaryOffsetList */
static int hf_rrc_pt20_01 = -1;                   /* TemporaryOffsetList */
static int hf_rrc_pt30_01 = -1;                   /* TemporaryOffsetList */
static int hf_rrc_pt40_01 = -1;                   /* TemporaryOffsetList */
static int hf_rrc_pt50_01 = -1;                   /* TemporaryOffsetList */
static int hf_rrc_pt60_01 = -1;                   /* TemporaryOffsetList */
static int hf_rrc_reportingInterval_01 = -1;      /* ReportingIntervalLong */
static int hf_rrc_periodicalWithReportingCellStatus = -1;  /* PeriodicalWithReportingCellStatus_r10 */
static int hf_rrc_plmnsOfIntraFreqCellsList = -1;  /* PLMNsOfIntraFreqCellsList */
static int hf_rrc_plmnsOfInterFreqCellsList = -1;  /* PLMNsOfInterFreqCellsList */
static int hf_rrc_plmnsOfInterRATCellsList = -1;  /* PLMNsOfInterRATCellsList */
static int hf_rrc_multipleplmnsOfIntraFreqCellsList = -1;  /* MultiplePLMNsOfIntraFreqCellsList */
static int hf_rrc_multipleplmnsOfInterFreqCellsList = -1;  /* MultiplePLMNsOfInterFreqCellsList */
static int hf_rrc_PlmnList_item = -1;             /* PLMN_Identity */
static int hf_rrc_PLMNsOfInterFreqCellsList_item = -1;  /* PLMNsOfInterFreqCellsList_item */
static int hf_rrc_MultiplePLMNsOfInterFreqCellsList_item = -1;  /* MultiplePLMNsOfInterFreqCellsList_item */
static int hf_rrc_multiplePLMN_list = -1;         /* SEQUENCE_SIZE_1_6_OF_PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_multiplePLMN_list_item = -1;    /* PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_PLMNsOfIntraFreqCellsList_item = -1;  /* PLMNsOfIntraFreqCellsList_item */
static int hf_rrc_MultiplePLMNsOfIntraFreqCellsList_item = -1;  /* MultiplePLMNsOfIntraFreqCellsList_item */
static int hf_rrc_PLMNsOfInterRATCellsList_item = -1;  /* PLMNsOfInterRATCellsList_item */
static int hf_rrc_QualityEventResults_item = -1;  /* TransportChannelIdentity */
static int hf_rrc_blerMeasurementResultsList = -1;  /* BLER_MeasurementResultsList */
static int hf_rrc_modeSpecificInfo_129 = -1;      /* T_modeSpecificInfo_129 */
static int hf_rrc_tdd_119 = -1;                   /* T_tdd_111 */
static int hf_rrc_sir_MeasurementResults = -1;    /* SIR_MeasurementList */
static int hf_rrc_qualityReportingQuantity = -1;  /* QualityReportingQuantity */
static int hf_rrc_reportCriteria_15 = -1;         /* QualityReportCriteria */
static int hf_rrc_qualityReportingCriteria = -1;  /* QualityReportingCriteria */
static int hf_rrc_noReporting_02 = -1;            /* NULL */
static int hf_rrc_QualityReportingCriteria_item = -1;  /* QualityReportingCriteriaSingle */
static int hf_rrc_totalCRC = -1;                  /* INTEGER_1_512 */
static int hf_rrc_badCRC = -1;                    /* INTEGER_1_512 */
static int hf_rrc_pendingAfterTrigger = -1;       /* INTEGER_1_512 */
static int hf_rrc_dl_TransChBLER = -1;            /* BOOLEAN */
static int hf_rrc_bler_dl_TransChIdList = -1;     /* BLER_TransChIdList */
static int hf_rrc_modeSpecificInfo_130 = -1;      /* T_modeSpecificInfo_130 */
static int hf_rrc_tdd_120 = -1;                   /* T_tdd_112 */
static int hf_rrc_sir_TFCS_List = -1;             /* SIR_TFCS_List */
static int hf_rrc_ellipsoidPointWithAltitude = -1;  /* EllipsoidPointAltitude */
static int hf_rrc_ellipsoidPointAltitudeEllipsoide = -1;  /* EllipsoidPointAltitudeEllipsoide */
static int hf_rrc_accuracy40 = -1;                /* INTEGER_0_960 */
static int hf_rrc_accuracy256 = -1;               /* INTEGER_0_150 */
static int hf_rrc_accuracy2560 = -1;              /* INTEGER_0_15 */
static int hf_rrc_removeAllInterFreqCells = -1;   /* NULL */
static int hf_rrc_removeSomeInterFreqCells = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_InterFreqCellID */
static int hf_rrc_removeSomeInterFreqCells_item = -1;  /* InterFreqCellID */
static int hf_rrc_removeNoInterFreqCells = -1;    /* NULL */
static int hf_rrc_removeAllInterRATCells = -1;    /* NULL */
static int hf_rrc_removeSomeInterRATCells = -1;   /* SEQUENCE_SIZE_1_maxCellMeas_OF_InterRATCellID */
static int hf_rrc_removeSomeInterRATCells_item = -1;  /* InterRATCellID */
static int hf_rrc_removeNoInterRATCells = -1;     /* NULL */
static int hf_rrc_removeAllIntraFreqCells = -1;   /* NULL */
static int hf_rrc_removeSomeIntraFreqCells = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_IntraFreqCellID */
static int hf_rrc_removeSomeIntraFreqCells_item = -1;  /* IntraFreqCellID */
static int hf_rrc_removeNoIntraFreqCells = -1;    /* NULL */
static int hf_rrc_removeSomeIntraFreqCells_01 = -1;  /* SEQUENCE_SIZE_1_maxCellMeasOnSecULFreq_OF_IntraFreqCellIDOnSecULFreq */
static int hf_rrc_removeSomeIntraFreqCells_item_01 = -1;  /* IntraFreqCellIDOnSecULFreq */
static int hf_rrc_withinActiveSet = -1;           /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredSetUsedFreq = -1;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinActiveAndOrMonitoredUsedFreq = -1;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinDetectedSetUsedFreq = -1;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredAndOrDetectedUsedFreq = -1;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_allActiveplusMonitoredSet = -1;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_allActivePlusDetectedSet = -1;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_allActivePlusMonitoredAndOrDetectedSet = -1;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_withinVirtualActSet = -1;       /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredSetNonUsedFreq = -1;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredAndOrVirtualActiveSetNonUsedFreq = -1;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_allVirtualActSetplusMonitoredSetNonUsedFreq = -1;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_withinActSetOrVirtualActSet_InterRATcells = -1;  /* MaxNumberOfReportingCellsType2 */
static int hf_rrc_withinActSetAndOrMonitoredUsedFreqOrVirtualActSetAndOrMonitoredNonUsedFreq = -1;  /* MaxNumberOfReportingCellsType2 */
static int hf_rrc_allVirtualActSetplusMonitoredSetplusDetectedSetNonUsedFreq = -1;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_reportCriteria_16 = -1;         /* CellDCH_ReportCriteria */
static int hf_rrc_reportCriteria_17 = -1;         /* CellDCH_ReportCriteria_LCR_r4 */
static int hf_rrc_ganssSignalID = -1;             /* DGANSS_Sig_Id_Req */
static int hf_rrc_ganssDataBitInterval = -1;      /* INTEGER_0_15 */
static int hf_rrc_ganssSatelliteInfo = -1;        /* T_ganssSatelliteInfo */
static int hf_rrc_ganssSatelliteInfo_item = -1;   /* INTEGER_0_63 */
static int hf_rrc_RL_AdditionInfoList_item = -1;  /* PrimaryCPICH_Info */
static int hf_rrc_rl_AdditionInfoList = -1;       /* RL_AdditionInfoList */
static int hf_rrc_rL_RemovalInformationList = -1;  /* RL_RemovalInformationList */
static int hf_rrc_rSCP = -1;                      /* INTEGER_M120_M25 */
static int hf_rrc_SatDataList_item = -1;          /* SatData */
static int hf_rrc_iod_02 = -1;                    /* INTEGER_0_1023 */
static int hf_rrc_SatellitesListRelatedDataList_item = -1;  /* SatellitesListRelatedData */
static int hf_rrc_t_oc_01 = -1;                   /* BIT_STRING_SIZE_14 */
static int hf_rrc_af2_01 = -1;                    /* BIT_STRING_SIZE_12 */
static int hf_rrc_af1_02 = -1;                    /* BIT_STRING_SIZE_18 */
static int hf_rrc_af0_02 = -1;                    /* BIT_STRING_SIZE_28 */
static int hf_rrc_tgd_01 = -1;                    /* BIT_STRING_SIZE_10 */
static int hf_rrc_model_id = -1;                  /* INTEGER_0_1 */
static int hf_rrc_Satellite_clock_modelList_item = -1;  /* Satellite_clock_model */
static int hf_rrc_sbasAgfo = -1;                  /* BIT_STRING_SIZE_12 */
static int hf_rrc_sbasAgf1 = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rrc_s_DPCCH_DPCCH_PowerOffset = -1;  /* S_DPCCH_DPCCH_PowerOffset */
static int hf_rrc_type1_07 = -1;                  /* SFN_SFN_ObsTimeDifference1 */
static int hf_rrc_type2_06 = -1;                  /* SFN_SFN_ObsTimeDifference2 */
static int hf_rrc_sfn_Offset = -1;                /* INTEGER_0_4095 */
static int hf_rrc_sfn_sfn_Reltimedifference = -1;  /* INTEGER_0_38399 */
static int hf_rrc_SIR_MeasurementList_item = -1;  /* SIR_MeasurementResults */
static int hf_rrc_sir_TimeslotList = -1;          /* SIR_TimeslotList */
static int hf_rrc_SIR_TFCS_List_item = -1;        /* SIR_TFCS */
static int hf_rrc_SIR_TimeslotList_item = -1;     /* SIR */
static int hf_rrc_reserved1 = -1;                 /* BIT_STRING_SIZE_23 */
static int hf_rrc_reserved2 = -1;                 /* BIT_STRING_SIZE_24 */
static int hf_rrc_reserved3 = -1;                 /* BIT_STRING_SIZE_24 */
static int hf_rrc_reserved4 = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_rrc_t_ADV = -1;                     /* INTEGER_0_2047 */
static int hf_rrc_sfn = -1;                       /* INTEGER_0_4095 */
static int hf_rrc_t_ADV_01 = -1;                  /* INTEGER_0_8191 */
static int hf_rrc_t30 = -1;                       /* N_CR_T_CRMaxHyst */
static int hf_rrc_t60 = -1;                       /* N_CR_T_CRMaxHyst */
static int hf_rrc_t120 = -1;                      /* N_CR_T_CRMaxHyst */
static int hf_rrc_t180 = -1;                      /* N_CR_T_CRMaxHyst */
static int hf_rrc_t240 = -1;                      /* N_CR_T_CRMaxHyst */
static int hf_rrc_tce_Id_01 = -1;                 /* OCTET_STRING_SIZE_1 */
static int hf_rrc_temporaryOffset1 = -1;          /* TemporaryOffset1 */
static int hf_rrc_temporaryOffset2 = -1;          /* TemporaryOffset2 */
static int hf_rrc_ThreholdNonUsedFrequency_deltaList_item = -1;  /* DeltaRSCPPerCell */
static int hf_rrc_TimeslotInfoList_item = -1;     /* TimeslotInfo */
static int hf_rrc_TimeslotInfoList_LCR_r4_item = -1;  /* TimeslotInfo_LCR_r4 */
static int hf_rrc_tdd384_47 = -1;                 /* SEQUENCE_SIZE_1_maxTS_OF_TimeslotInfo */
static int hf_rrc_tdd384_item_01 = -1;            /* TimeslotInfo */
static int hf_rrc_tdd128_68 = -1;                 /* SEQUENCE_SIZE_1_maxTS_LCR_OF_TimeslotInfo_LCR_r4 */
static int hf_rrc_tdd128_item_02 = -1;            /* TimeslotInfo_LCR_r4 */
static int hf_rrc_TimeslotISCP_List_item = -1;    /* TimeslotISCP */
static int hf_rrc_TimeslotListWithISCP_item = -1;  /* TimeslotWithISCP */
static int hf_rrc_timeslotISCP_01 = -1;           /* TimeslotISCP */
static int hf_rrc_traceId = -1;                   /* OCTET_STRING_SIZE_3 */
static int hf_rrc_traceRecordingSession_01 = -1;  /* OCTET_STRING_SIZE_2 */
static int hf_rrc_eventID_03 = -1;                /* TrafficVolumeEventType */
static int hf_rrc_reportingThreshold_01 = -1;     /* TrafficVolumeThreshold */
static int hf_rrc_pendingTimeAfterTrigger = -1;   /* PendingTimeAfterTrigger */
static int hf_rrc_tx_InterruptionAfterTrigger = -1;  /* TX_InterruptionAfterTrigger */
static int hf_rrc_ul_transportChannelCausingEvent = -1;  /* UL_TrCH_Identity */
static int hf_rrc_trafficVolumeEventIdentity = -1;  /* TrafficVolumeEventType */
static int hf_rrc_rlc_BufferPayload = -1;         /* NULL */
static int hf_rrc_averageRLC_BufferPayload = -1;  /* TimeInterval */
static int hf_rrc_varianceOfRLC_BufferPayload = -1;  /* TimeInterval */
static int hf_rrc_trafficVolumeMeasurementID = -1;  /* MeasurementIdentity */
static int hf_rrc_trafficVolumeMeasurementObjectList = -1;  /* TrafficVolumeMeasurementObjectList */
static int hf_rrc_trafficVolumeMeasQuantity = -1;  /* TrafficVolumeMeasQuantity */
static int hf_rrc_trafficVolumeReportingQuantity = -1;  /* TrafficVolumeReportingQuantity */
static int hf_rrc_dummy_55 = -1;                  /* TrafficVolumeReportingCriteria */
static int hf_rrc_reportCriteriaSysInf = -1;      /* TrafficVolumeReportCriteriaSysInfo */
static int hf_rrc_rlc_BuffersPayload = -1;        /* RLC_BuffersPayload */
static int hf_rrc_averageRLC_BufferPayload_01 = -1;  /* AverageRLC_BufferPayload */
static int hf_rrc_varianceOfRLC_BufferPayload_01 = -1;  /* VarianceOfRLC_BufferPayload */
static int hf_rrc_TrafficVolumeMeasuredResultsList_item = -1;  /* TrafficVolumeMeasuredResults */
static int hf_rrc_reportCriteria_18 = -1;         /* TrafficVolumeReportCriteria */
static int hf_rrc_TrafficVolumeMeasurementObjectList_item = -1;  /* UL_TrCH_Identity */
static int hf_rrc_trafficVolumeReportingCriteria = -1;  /* TrafficVolumeReportingCriteria */
static int hf_rrc_transChCriteriaList = -1;       /* TransChCriteriaList */
static int hf_rrc_rlc_RB_BufferPayload = -1;      /* BOOLEAN */
static int hf_rrc_rlc_RB_BufferPayloadAverage = -1;  /* BOOLEAN */
static int hf_rrc_rlc_RB_BufferPayloadVariance = -1;  /* BOOLEAN */
static int hf_rrc_ul_transportChannelID = -1;     /* UL_TrCH_Identity */
static int hf_rrc_eventSpecificParameters = -1;   /* SEQUENCE_SIZE_1_maxMeasParEvent_OF_TrafficVolumeEventParam */
static int hf_rrc_eventSpecificParameters_item = -1;  /* TrafficVolumeEventParam */
static int hf_rrc_TransChCriteriaList_item = -1;  /* TransChCriteria */
static int hf_rrc_transmittedPowerThreshold = -1;  /* TransmittedPowerThreshold */
static int hf_rrc_ue_RX_TX_TimeDifferenceThreshold = -1;  /* UE_RX_TX_TimeDifferenceThreshold */
static int hf_rrc_onWithNoReporting = -1;         /* NULL */
static int hf_rrc_dummy2_13 = -1;                 /* RL_InformationLists */
static int hf_rrc_event6a = -1;                   /* UE_6AB_Event */
static int hf_rrc_event6b = -1;                   /* UE_6AB_Event */
static int hf_rrc_event6c = -1;                   /* TimeToTrigger */
static int hf_rrc_event6d = -1;                   /* TimeToTrigger */
static int hf_rrc_event6e = -1;                   /* TimeToTrigger */
static int hf_rrc_event6f = -1;                   /* UE_6FG_Event */
static int hf_rrc_event6g = -1;                   /* UE_6FG_Event */
static int hf_rrc_UE_InternalEventParamList_item = -1;  /* UE_InternalEventParam */
static int hf_rrc_event6a_01 = -1;                /* NULL */
static int hf_rrc_event6b_01 = -1;                /* NULL */
static int hf_rrc_event6c_01 = -1;                /* NULL */
static int hf_rrc_event6d_01 = -1;                /* NULL */
static int hf_rrc_event6e_01 = -1;                /* NULL */
static int hf_rrc_event6f_01 = -1;                /* PrimaryCPICH_Info */
static int hf_rrc_event6g_01 = -1;                /* PrimaryCPICH_Info */
static int hf_rrc_measurementQuantity_07 = -1;    /* UE_MeasurementQuantity */
static int hf_rrc_modeSpecificInfo_131 = -1;      /* T_modeSpecificInfo_131 */
static int hf_rrc_fdd_170 = -1;                   /* T_fdd_164 */
static int hf_rrc_ue_TransmittedPowerFDD = -1;    /* UE_TransmittedPower */
static int hf_rrc_ue_RX_TX_ReportEntryList = -1;  /* UE_RX_TX_ReportEntryList */
static int hf_rrc_tdd_121 = -1;                   /* T_tdd_113 */
static int hf_rrc_ue_TransmittedPowerTDD_List = -1;  /* UE_TransmittedPowerTDD_List */
static int hf_rrc_appliedTA = -1;                 /* UL_TimingAdvance */
static int hf_rrc_t_ADVinfo = -1;                 /* T_ADVinfo */
static int hf_rrc_modeSpecificInfo_132 = -1;      /* T_modeSpecificInfo_132 */
static int hf_rrc_tdd384_768_03 = -1;             /* T_tdd384_768_02 */
static int hf_rrc_appliedTA_01 = -1;              /* EXT_UL_TimingAdvance */
static int hf_rrc_tdd128_69 = -1;                 /* T_tdd128_66 */
static int hf_rrc_t_ADVinfo_01 = -1;              /* T_ADVinfo_ext */
static int hf_rrc_ue_InternalMeasQuantity = -1;   /* UE_InternalMeasQuantity */
static int hf_rrc_ue_InternalReportingQuantity = -1;  /* UE_InternalReportingQuantity */
static int hf_rrc_reportCriteria_19 = -1;         /* UE_InternalReportCriteria */
static int hf_rrc_ue_InternalReportingQuantity_01 = -1;  /* UE_InternalReportingQuantity_r4 */
static int hf_rrc_ue_InternalMeasurementID = -1;  /* MeasurementIdentity */
static int hf_rrc_ue_InternalReportingCriteria = -1;  /* UE_InternalReportingCriteria */
static int hf_rrc_ue_InternalEventParamList = -1;  /* UE_InternalEventParamList */
static int hf_rrc_ue_TransmittedPower = -1;       /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_133 = -1;      /* T_modeSpecificInfo_133 */
static int hf_rrc_fdd_171 = -1;                   /* T_fdd_165 */
static int hf_rrc_ue_RX_TX_TimeDifference = -1;   /* BOOLEAN */
static int hf_rrc_tdd_122 = -1;                   /* T_tdd_114 */
static int hf_rrc_appliedTA_02 = -1;              /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_134 = -1;      /* T_modeSpecificInfo_134 */
static int hf_rrc_fdd_172 = -1;                   /* T_fdd_166 */
static int hf_rrc_tdd_123 = -1;                   /* T_tdd_115 */
static int hf_rrc_tddOption_28 = -1;              /* T_tddOption_28 */
static int hf_rrc_tdd384_48 = -1;                 /* T_tdd384_43 */
static int hf_rrc_tdd128_70 = -1;                 /* T_tdd128_67 */
static int hf_rrc_t_ADVinfo_02 = -1;              /* BOOLEAN */
static int hf_rrc_ue_RX_TX_TimeDifferenceType1 = -1;  /* UE_RX_TX_TimeDifferenceType1 */
static int hf_rrc_UE_RX_TX_ReportEntryList_item = -1;  /* UE_RX_TX_ReportEntry */
static int hf_rrc_ue_RX_TX_TimeDifferenceType2 = -1;  /* UE_RX_TX_TimeDifferenceType2 */
static int hf_rrc_UE_TransmittedPowerTDD_List_item = -1;  /* UE_TransmittedPower */
static int hf_rrc_rachorcpch = -1;                /* NULL */
static int hf_rrc_cipheringKeyFlag = -1;          /* BIT_STRING_SIZE_1 */
static int hf_rrc_cipheringSerialNumber = -1;     /* INTEGER_0_65535 */
static int hf_rrc_dganssreferencetime = -1;       /* INTEGER_0_119 */
static int hf_rrc_dganssInfoList = -1;            /* DGANSSInfoList */
static int hf_rrc_dganssInfoList_01 = -1;         /* DGANSSInfoList_r9 */
static int hf_rrc_dganssInfoList_02 = -1;         /* DGANSSInfoList_v920ext */
static int hf_rrc_errorReason = -1;               /* UE_Positioning_ErrorCause */
static int hf_rrc_ue_positioning_GPS_additionalAssistanceDataRequest = -1;  /* UE_Positioning_GPS_AdditionalAssistanceDataRequest */
static int hf_rrc_errorReason_01 = -1;            /* UE_Positioning_ErrorCause_r7 */
static int hf_rrc_ue_positioning_GANSS_additionalAssistanceDataRequest = -1;  /* UE_Positioning_GANSS_AdditionalAssistanceDataRequest */
static int hf_rrc_ue_positioning_GANSS_additionalAssistanceDataRequest_01 = -1;  /* UE_Positioning_GANSS_AdditionalAssistanceDataRequest_v860ext */
static int hf_rrc_reportFirstFix = -1;            /* BOOLEAN */
static int hf_rrc_measurementInterval = -1;       /* UE_Positioning_MeasurementInterval */
static int hf_rrc_eventSpecificInfo = -1;         /* UE_Positioning_EventSpecificInfo */
static int hf_rrc_eventSpecificInfo_01 = -1;      /* UE_Positioning_EventSpecificInfo_r7 */
static int hf_rrc_UE_Positioning_EventParamList_item = -1;  /* UE_Positioning_EventParam */
static int hf_rrc_UE_Positioning_EventParamList_r7_item = -1;  /* UE_Positioning_EventParam_r7 */
static int hf_rrc_e7a = -1;                       /* ThresholdPositionChange */
static int hf_rrc_e7b = -1;                       /* ThresholdSFN_SFN_Change */
static int hf_rrc_e7c = -1;                       /* ThresholdSFN_GPS_TOW */
static int hf_rrc_e7c_01 = -1;                    /* ThresholdSFN_GPS_TOW_us */
static int hf_rrc_e7d = -1;                       /* ThresholdSFN_GANSS_TOW */
static int hf_rrc_utcModel1 = -1;                 /* UTCmodelSet1 */
static int hf_rrc_utcModel2 = -1;                 /* UTCmodelSet2 */
static int hf_rrc_utcModel3 = -1;                 /* UTCmodelSet3 */
static int hf_rrc_ganss_wk_number = -1;           /* INTEGER_0_255 */
static int hf_rrc_alm_keplerianParameters = -1;   /* ALM_keplerianParameters */
static int hf_rrc_alm_keplerianNAVAlmanac = -1;   /* ALM_NAVKeplerianSet */
static int hf_rrc_alm_keplerianReducedAlmanac = -1;  /* ALM_ReducedKeplerianSet */
static int hf_rrc_alm_keplerianMidiAlmanac = -1;  /* ALM_MidiAlmanacSet */
static int hf_rrc_alm_keplerianGLONASS = -1;      /* ALM_GlonassAlmanacSet */
static int hf_rrc_alm_ecefSBASAlmanac = -1;       /* ALM_ECEFsbasAlmanacSet */
static int hf_rrc_complete_Almanac_Provided = -1;  /* BOOLEAN */
static int hf_rrc_ganssReferenceTime = -1;        /* BOOLEAN */
static int hf_rrc_ganssreferenceLocation = -1;    /* BOOLEAN */
static int hf_rrc_ganssIonosphericModel = -1;     /* BOOLEAN */
static int hf_rrc_ganssRequestedGenericAssistanceDataList = -1;  /* GanssRequestedGenericAssistanceDataList */
static int hf_rrc_ganssAddIonoModelReq = -1;      /* BIT_STRING_SIZE_2 */
static int hf_rrc_ganssEOPreq = -1;               /* T_ganssEOPreq */
static int hf_rrc_ganssRequestedGenericAssistanceDataList_01 = -1;  /* GanssRequestedGenericAssistanceDataList_v860ext */
static int hf_rrc_dataID_01 = -1;                 /* BIT_STRING_SIZE_2 */
static int hf_rrc_alpha_beta_parameters = -1;     /* UE_Positioning_GPS_IonosphericModel */
static int hf_rrc_non_broadcastIndication = -1;   /* T_non_broadcastIndication */
static int hf_rrc_ganssSatInfoNavList = -1;       /* Ganss_Sat_Info_AddNavList */
static int hf_rrc_ue_positioning_GANSS_ReferenceTime = -1;  /* UE_Positioning_GANSS_ReferenceTime */
static int hf_rrc_uePositioningGanssReferencePosition = -1;  /* ReferenceLocationGANSS */
static int hf_rrc_uePositioningGanssIonosphericModel = -1;  /* UE_Positioning_GANSS_IonosphericModel */
static int hf_rrc_ganssGenericDataList = -1;      /* GANSSGenericDataList */
static int hf_rrc_uePositioningGanssAddIonoModel = -1;  /* UE_Positioning_GANSS_AddIonoModel */
static int hf_rrc_uePositioningGanssEarthOrientationPara = -1;  /* UE_Positioning_GANSS_EarthOrientPara */
static int hf_rrc_ganssGenericDataList_01 = -1;   /* GANSSGenericDataList_v860ext */
static int hf_rrc_ganssGenericDataList_02 = -1;   /* GANSSGenericDataList_r8 */
static int hf_rrc_ganssGenericDataList_03 = -1;   /* GANSSGenericDataList_r9 */
static int hf_rrc_ganssGenericDataList_04 = -1;   /* GANSSGenericDataList_v920ext */
static int hf_rrc_ue_positioning_GANSS_ReferenceTime_01 = -1;  /* UE_Positioning_GANSS_ReferenceTime_va40ext */
static int hf_rrc_ganssGenericDataList_05 = -1;   /* GANSSGenericDataList_va40ext */
static int hf_rrc_ue_positioning_GANSS_ReferenceTime_02 = -1;  /* UE_Positioning_GANSS_ReferenceTime_r10 */
static int hf_rrc_ganssGenericDataList_06 = -1;   /* GANSSGenericDataList_r10 */
static int hf_rrc_ganssID1 = -1;                  /* AuxInfoGANSS_ID1 */
static int hf_rrc_ganssID3 = -1;                  /* AuxInfoGANSS_ID3 */
static int hf_rrc_satellite_clock_modelList = -1;  /* Satellite_clock_modelList */
static int hf_rrc_navClockModel = -1;             /* NAVclockModel */
static int hf_rrc_cnavClockModel = -1;            /* CNAVclockModel */
static int hf_rrc_glonassClockModel = -1;         /* GLONASSclockModel */
static int hf_rrc_sbasClockModel = -1;            /* SBASclockModel */
static int hf_rrc_navKeplerianSet = -1;           /* NavModel_NAVKeplerianSet */
static int hf_rrc_cnavKeplerianSet = -1;          /* NavModel_CNAVKeplerianSet */
static int hf_rrc_glonassECEF = -1;               /* NavModel_GLONASSecef */
static int hf_rrc_sbasECEF = -1;                  /* NavModel_SBASecef */
static int hf_rrc_ganss_tod = -1;                 /* INTEGER_0_59 */
static int hf_rrc_dataBitAssistanceList = -1;     /* DataBitAssistanceList */
static int hf_rrc_teop = -1;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_pmX = -1;                       /* BIT_STRING_SIZE_21 */
static int hf_rrc_pmXdot = -1;                    /* BIT_STRING_SIZE_15 */
static int hf_rrc_pmY = -1;                       /* BIT_STRING_SIZE_21 */
static int hf_rrc_pmYdot = -1;                    /* BIT_STRING_SIZE_15 */
static int hf_rrc_deltaUT1 = -1;                  /* BIT_STRING_SIZE_31 */
static int hf_rrc_deltaUT1dot = -1;               /* BIT_STRING_SIZE_19 */
static int hf_rrc_alpha_zero_ionos = -1;          /* BIT_STRING_SIZE_12 */
static int hf_rrc_alpha_one_ionos = -1;           /* BIT_STRING_SIZE_12 */
static int hf_rrc_alpha_two_ionos = -1;           /* BIT_STRING_SIZE_12 */
static int hf_rrc_gANSS_storm_flags = -1;         /* GANSS_Storm_Flag */
static int hf_rrc_referenceTime = -1;             /* T_referenceTime */
static int hf_rrc_utran_GANSSReferenceTimeResult = -1;  /* UTRAN_GANSSReferenceTime */
static int hf_rrc_ganssReferenceTimeOnly = -1;    /* GANSSReferenceTimeOnly */
static int hf_rrc_ganssGenericMeasurementInfo = -1;  /* GANSSGenericMeasurementInfo */
static int hf_rrc_ganssGenericMeasurementInfo_01 = -1;  /* GANSSGenericMeasurementInfo_v860ext */
static int hf_rrc_non_broadcastIndication_01 = -1;  /* T_non_broadcastIndication_01 */
static int hf_rrc_ganssSatInfoNavList_01 = -1;    /* Ganss_Sat_Info_NavList */
static int hf_rrc_keplerianParameters = -1;       /* KeplerianParameters */
static int hf_rrc_UE_Positioning_GANSS_RealTimeIntegrity_item = -1;  /* UE_Positioning_GANSS_RealTimeIntegrity_item */
static int hf_rrc_bad_ganss_satId = -1;           /* INTEGER_0_63 */
static int hf_rrc_bad_ganss_signalId = -1;        /* BIT_STRING_SIZE_8 */
static int hf_rrc_satelliteInformationList = -1;  /* GANSSSatelliteInformationList */
static int hf_rrc_satelliteInformationList_01 = -1;  /* GANSSSatelliteInformationList_va40ext */
static int hf_rrc_satelliteInformationList_02 = -1;  /* GANSSSatelliteInformationList_r10 */
static int hf_rrc_ganssDay = -1;                  /* INTEGER_0_8191 */
static int hf_rrc_ganssTodUncertainty = -1;       /* INTEGER_0_127 */
static int hf_rrc_ganssTimeId = -1;               /* INTEGER_0_7 */
static int hf_rrc_utran_ganssreferenceTime = -1;  /* T_utran_ganssreferenceTime */
static int hf_rrc_timingOfCellFrames = -1;        /* INTEGER_0_3999999 */
static int hf_rrc_mode = -1;                      /* T_mode */
static int hf_rrc_fdd_173 = -1;                   /* T_fdd_167 */
static int hf_rrc_primary_CPICH_Info = -1;        /* PrimaryCPICH_Info */
static int hf_rrc_tdd_124 = -1;                   /* T_tdd_116 */
static int hf_rrc_cellParameters = -1;            /* CellParametersID */
static int hf_rrc_referenceSfn = -1;              /* INTEGER_0_4095 */
static int hf_rrc_tutran_ganss_driftRate = -1;    /* Tutran_Ganss_DriftRate */
static int hf_rrc_ganss_Day_Cycle_Number = -1;    /* INTEGER_0_7 */
static int hf_rrc_utran_ganssreferenceTime_01 = -1;  /* T_utran_ganssreferenceTime_01 */
static int hf_rrc_mode_01 = -1;                   /* T_mode_01 */
static int hf_rrc_fdd_174 = -1;                   /* T_fdd_168 */
static int hf_rrc_tdd_125 = -1;                   /* T_tdd_117 */
static int hf_rrc_ganss_timeModelreferenceTime = -1;  /* INTEGER_0_37799 */
static int hf_rrc_ganss_t_a0 = -1;                /* INTEGER_M2147483648_2147483647 */
static int hf_rrc_ganss_t_a1 = -1;                /* INTEGER_M8388608_8388607 */
static int hf_rrc_ganss_t_a2 = -1;                /* INTEGER_M64_63 */
static int hf_rrc_gnss_to_id = -1;                /* T_gnss_to_id */
static int hf_rrc_ganss_wk_number_01 = -1;        /* INTEGER_0_8191 */
static int hf_rrc_deltaT = -1;                    /* INTEGER_M128_127 */
static int hf_rrc_gnss_to_id_01 = -1;             /* T_gnss_to_id_01 */
static int hf_rrc_UE_Positioning_GANSS_TimeModels_item = -1;  /* UE_Positioning_GANSS_TimeModel */
static int hf_rrc_UE_Positioning_GANSS_TimeModels_va40ext_item = -1;  /* UE_Positioning_GANSS_TimeModel_va40ext */
static int hf_rrc_a_one_utc = -1;                 /* BIT_STRING_SIZE_24 */
static int hf_rrc_a_zero_utc = -1;                /* BIT_STRING_SIZE_32 */
static int hf_rrc_t_ot_utc = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_ls_utc = -1;            /* BIT_STRING_SIZE_8 */
static int hf_rrc_w_n_t_utc = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_rrc_w_n_lsf_utc = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rrc_dn_utc = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_lsf_utc = -1;           /* BIT_STRING_SIZE_8 */
static int hf_rrc_gps_ReferenceTime = -1;         /* GPS_TOW_1msec */
static int hf_rrc_utran_GPSReferenceTime = -1;    /* UTRAN_GPSReferenceTime */
static int hf_rrc_satelliteInformationList_03 = -1;  /* AcquisitionSatInfoList */
static int hf_rrc_ue_Positioning_GPS_ReferenceTimeUncertainty = -1;  /* UE_Positioning_GPS_ReferenceTimeUncertainty */
static int hf_rrc_satelliteInformationList_04 = -1;  /* AcquisitionSatInfoList_va40ext */
static int hf_rrc_satelliteInformationList_05 = -1;  /* AcquisitionSatInfoList_r10 */
static int hf_rrc_almanacRequest = -1;            /* BOOLEAN */
static int hf_rrc_utcModelRequest = -1;           /* BOOLEAN */
static int hf_rrc_ionosphericModelRequest = -1;   /* BOOLEAN */
static int hf_rrc_navigationModelRequest = -1;    /* BOOLEAN */
static int hf_rrc_dgpsCorrectionsRequest = -1;    /* BOOLEAN */
static int hf_rrc_referenceLocationRequest = -1;  /* BOOLEAN */
static int hf_rrc_referenceTimeRequest = -1;      /* BOOLEAN */
static int hf_rrc_aquisitionAssistanceRequest = -1;  /* BOOLEAN */
static int hf_rrc_realTimeIntegrityRequest = -1;  /* BOOLEAN */
static int hf_rrc_navModelAddDataRequest = -1;    /* UE_Positioning_GPS_NavModelAddDataReq */
static int hf_rrc_wn_a = -1;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_almanacSatInfoList = -1;        /* AlmanacSatInfoList */
static int hf_rrc_sv_GlobalHealth = -1;           /* BIT_STRING_SIZE_364 */
static int hf_rrc_ue_positioning_GPS_ReferenceTime = -1;  /* UE_Positioning_GPS_ReferenceTime */
static int hf_rrc_ue_positioning_GPS_ReferenceLocation = -1;  /* ReferenceLocation */
static int hf_rrc_ue_positioning_GPS_DGPS_Corrections = -1;  /* UE_Positioning_GPS_DGPS_Corrections */
static int hf_rrc_ue_positioning_GPS_NavigationModel = -1;  /* UE_Positioning_GPS_NavigationModel */
static int hf_rrc_ue_positioning_GPS_IonosphericModel = -1;  /* UE_Positioning_GPS_IonosphericModel */
static int hf_rrc_ue_positioning_GPS_UTC_Model = -1;  /* UE_Positioning_GPS_UTC_Model */
static int hf_rrc_ue_positioning_GPS_Almanac = -1;  /* UE_Positioning_GPS_Almanac */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance = -1;  /* UE_Positioning_GPS_AcquisitionAssistance */
static int hf_rrc_ue_positioning_GPS_Real_timeIntegrity = -1;  /* BadSatList */
static int hf_rrc_dummy_56 = -1;                  /* UE_Positioning_GPS_ReferenceCellInfo */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_01 = -1;  /* UE_Positioning_GPS_ReferenceTime_v770ext */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_01 = -1;  /* UE_Positioning_GPS_AcquisitionAssistance_v770ext */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_02 = -1;  /* UE_Positioning_GPS_ReferenceTime_r7 */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_02 = -1;  /* UE_Positioning_GPS_AcquisitionAssistance_r7 */
static int hf_rrc_ue_positioning_GPS_DGPS_Corrections_01 = -1;  /* UE_Positioning_GPS_DGPS_Corrections_r9 */
static int hf_rrc_ue_positioning_GPS_DGPS_Corrections_02 = -1;  /* UE_Positioning_GPS_DGPS_Corrections_v920ext */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_03 = -1;  /* UE_Positioning_GPS_ReferenceTime_va40ext */
static int hf_rrc_ue_positioning_GPS_Almanac_01 = -1;  /* UE_Positioning_GPS_Almanac_va40ext */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_03 = -1;  /* UE_Positioning_GPS_AcquisitionAssistance_va40ext */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_04 = -1;  /* UE_Positioning_GPS_ReferenceTime_r10 */
static int hf_rrc_ue_positioning_GPS_Almanac_02 = -1;  /* UE_Positioning_GPS_Almanac_r10 */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_04 = -1;  /* UE_Positioning_GPS_AcquisitionAssistance_r10 */
static int hf_rrc_gps_TOW = -1;                   /* GPS_TOW_1sec */
static int hf_rrc_statusHealth = -1;              /* DiffCorrectionStatus */
static int hf_rrc_dgps_CorrectionSatInfoList = -1;  /* DGPS_CorrectionSatInfoList */
static int hf_rrc_dgps_CorrectionSatInfoList_01 = -1;  /* DGPS_CorrectionSatInfoList_r9 */
static int hf_rrc_dgps_CorrectionSatInfoList_02 = -1;  /* DGPS_CorrectionSatInfoList_v920ext */
static int hf_rrc_alpha0 = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_alpha1 = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_alpha2 = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_alpha3 = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta0 = -1;                     /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta1 = -1;                     /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta2 = -1;                     /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta3 = -1;                     /* BIT_STRING_SIZE_8 */
static int hf_rrc_referenceTime_01 = -1;          /* T_referenceTime_01 */
static int hf_rrc_utran_GPSReferenceTimeResult = -1;  /* UTRAN_GPSReferenceTimeResult */
static int hf_rrc_gps_ReferenceTimeOnly = -1;     /* GPS_TOW_1msec */
static int hf_rrc_gps_MeasurementParamList = -1;  /* GPS_MeasurementParamList */
static int hf_rrc_navigationModelSatInfoList = -1;  /* NavigationModelSatInfoList */
static int hf_rrc_gps_Week = -1;                  /* INTEGER_0_1023 */
static int hf_rrc_gps_Toe = -1;                   /* INTEGER_0_255 */
static int hf_rrc_tToeLimit = -1;                 /* INTEGER_0_15 */
static int hf_rrc_satDataList = -1;               /* SatDataList */
static int hf_rrc_modeSpecificInfo_135 = -1;      /* T_modeSpecificInfo_135 */
static int hf_rrc_fdd_175 = -1;                   /* T_fdd_169 */
static int hf_rrc_referenceIdentity = -1;         /* PrimaryCPICH_Info */
static int hf_rrc_tdd_126 = -1;                   /* T_tdd_118 */
static int hf_rrc_referenceIdentity_01 = -1;      /* CellParametersID */
static int hf_rrc_gps_tow_1msec = -1;             /* GPS_TOW_1msec */
static int hf_rrc_sfn_tow_Uncertainty = -1;       /* SFN_TOW_Uncertainty */
static int hf_rrc_utran_GPS_DriftRate = -1;       /* UTRAN_GPS_DriftRate */
static int hf_rrc_gps_TOW_AssistList = -1;        /* GPS_TOW_AssistList */
static int hf_rrc_gps_Week_Cycle_Number = -1;     /* INTEGER_0_7 */
static int hf_rrc_a1 = -1;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_a0 = -1;                        /* BIT_STRING_SIZE_32 */
static int hf_rrc_t_ot = -1;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_wn_t = -1;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_LS = -1;                /* BIT_STRING_SIZE_8 */
static int hf_rrc_wn_lsf = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_dn = -1;                        /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_LSF = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rrc_ip_Spacing = -1;                /* IP_Spacing */
static int hf_rrc_ip_Length = -1;                 /* IP_Length */
static int hf_rrc_ip_Offset = -1;                 /* INTEGER_0_9 */
static int hf_rrc_seed = -1;                      /* INTEGER_0_63 */
static int hf_rrc_burstModeParameters = -1;       /* BurstModeParameters */
static int hf_rrc_modeSpecificInfo_136 = -1;      /* T_modeSpecificInfo_136 */
static int hf_rrc_fdd_176 = -1;                   /* T_fdd_170 */
static int hf_rrc_tdd_127 = -1;                   /* T_tdd_119 */
static int hf_rrc_ip_Spacing_TDD = -1;            /* IP_Spacing_TDD */
static int hf_rrc_ip_slot = -1;                   /* INTEGER_0_14 */
static int hf_rrc_ip_Start = -1;                  /* INTEGER_0_4095 */
static int hf_rrc_ip_PCCPCG = -1;                 /* IP_PCCPCH_r4 */
static int hf_rrc_ip_Spacing_01 = -1;             /* IP_Spacing_TDD */
static int hf_rrc_ue_positioning_OTDOA_Measurement = -1;  /* UE_Positioning_OTDOA_Measurement */
static int hf_rrc_ue_positioning_PositionEstimateInfo = -1;  /* UE_Positioning_PositionEstimateInfo */
static int hf_rrc_ue_positioning_GPS_Measurement = -1;  /* UE_Positioning_GPS_MeasurementResults */
static int hf_rrc_ue_positioning_Error = -1;      /* UE_Positioning_Error */
static int hf_rrc_ue_positioning_PositionEstimateInfo_01 = -1;  /* UE_Positioning_PositionEstimateInfo_v770ext */
static int hf_rrc_ue_positioning_GPS_Measurement_01 = -1;  /* UE_Positioning_GPS_MeasurementResults_v770ext */
static int hf_rrc_ue_positioning_Error_01 = -1;   /* UE_Positioning_Error_r7 */
static int hf_rrc_ue_positioning_Ganss_MeasuredResults = -1;  /* UE_Positioning_GANSS_MeasuredResults */
static int hf_rrc_ue_Positioning_OTDOA_Measurement_v390ext = -1;  /* UE_Positioning_OTDOA_Measurement_v390ext */
static int hf_rrc_ue_positioning_Error_02 = -1;   /* UE_Positioning_Error_v860ext */
static int hf_rrc_ue_positioning_Ganss_MeasurementResults = -1;  /* UE_Positioning_GANSS_MeasuredResults_v860ext */
static int hf_rrc_ue_positioning_ReportingQuantity = -1;  /* UE_Positioning_ReportingQuantity */
static int hf_rrc_reportCriteria_20 = -1;         /* UE_Positioning_ReportCriteria */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData = -1;  /* UE_Positioning_OTDOA_AssistanceData */
static int hf_rrc_ue_positioning_ReportingQuantity_v390ext = -1;  /* UE_Positioning_ReportingQuantity_v390ext */
static int hf_rrc_ue_positioning_ReportingQuantity_01 = -1;  /* UE_Positioning_ReportingQuantity_r4 */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData_01 = -1;  /* UE_Positioning_OTDOA_AssistanceData_r4 */
static int hf_rrc_ue_positioning_ReportingQuantity_02 = -1;  /* UE_Positioning_ReportingQuantity_r7 */
static int hf_rrc_reportCriteria_21 = -1;         /* UE_Positioning_ReportCriteria_r7 */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData_02 = -1;  /* UE_Positioning_OTDOA_AssistanceData_r7 */
static int hf_rrc_ue_positioning_GPS_AssistanceData_01 = -1;  /* UE_Positioning_GPS_AssistanceData_r7 */
static int hf_rrc_ue_positioning_ReportingQuantity_03 = -1;  /* UE_Positioning_ReportingQuantity_r8 */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_01 = -1;  /* UE_Positioning_GANSS_AssistanceData_r8 */
static int hf_rrc_ue_positioning_GPS_AssistanceData_02 = -1;  /* UE_Positioning_GPS_AssistanceData_r9 */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_02 = -1;  /* UE_Positioning_GANSS_AssistanceData_r9 */
static int hf_rrc_ue_positioning_GPS_AssistanceData_03 = -1;  /* UE_Positioning_GPS_AssistanceData_r10 */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_03 = -1;  /* UE_Positioning_GANSS_AssistanceData_r10 */
static int hf_rrc_event7a = -1;                   /* UE_Positioning_PositionEstimateInfo */
static int hf_rrc_event7b = -1;                   /* UE_Positioning_OTDOA_Measurement */
static int hf_rrc_event7c = -1;                   /* UE_Positioning_GPS_MeasurementResults */
static int hf_rrc_additionalOrReplacedPosMeasEvent = -1;  /* NULL */
static int hf_rrc_event7a_01 = -1;                /* UE_Positioning_PositionEstimateInfo_v770ext */
static int hf_rrc_event7c_01 = -1;                /* UE_Positioning_GPS_MeasurementResults_v770ext */
static int hf_rrc_event7d = -1;                   /* UE_Positioning_GANSS_MeasuredResults */
static int hf_rrc_event7d_01 = -1;                /* UE_Positioning_GANSS_MeasuredResults_v860ext */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo = -1;  /* UE_Positioning_OTDOA_ReferenceCellInfo */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList = -1;  /* UE_Positioning_OTDOA_NeighbourCellList */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_01 = -1;  /* UE_Positioning_OTDOA_ReferenceCellInfo_r4 */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_01 = -1;  /* UE_Positioning_OTDOA_NeighbourCellList_r4 */
static int hf_rrc_ue_Positioning_IPDL_Parameters_TDD_r4_ext = -1;  /* UE_Positioning_IPDL_Parameters_TDD_r4_ext */
static int hf_rrc_ue_Positioning_IPDL_Parameters_TDDList_r4_ext = -1;  /* UE_Positioning_IPDL_Parameters_TDDList_r4_ext */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_UEB = -1;  /* UE_Positioning_OTDOA_ReferenceCellInfo_UEB */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_UEB = -1;  /* UE_Positioning_OTDOA_NeighbourCellList_UEB */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_UEB_ext = -1;  /* UE_Positioning_OTDOA_ReferenceCellInfo_UEB_ext */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_UEB_ext = -1;  /* UE_Positioning_OTDOA_NeighbourCellList_UEB_ext */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_02 = -1;  /* UE_Positioning_OTDOA_ReferenceCellInfo_r7 */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_02 = -1;  /* UE_Positioning_OTDOA_NeighbourCellList_r7 */
static int hf_rrc_UE_Positioning_IPDL_Parameters_TDDList_r4_ext_item = -1;  /* UE_Positioning_IPDL_Parameters_TDD_r4_ext */
static int hf_rrc_neighbourList = -1;             /* NeighbourList_TDD_r7 */
static int hf_rrc_modeSpecificInfo_137 = -1;      /* T_modeSpecificInfo_137 */
static int hf_rrc_fdd_177 = -1;                   /* T_fdd_171 */
static int hf_rrc_referenceCellIDentity = -1;     /* PrimaryCPICH_Info */
static int hf_rrc_ue_RX_TX_TimeDifferenceType2Info = -1;  /* UE_RX_TX_TimeDifferenceType2Info */
static int hf_rrc_tdd_128 = -1;                   /* T_tdd_120 */
static int hf_rrc_referenceCellIdentity = -1;     /* CellParametersID */
static int hf_rrc_neighbourList_01 = -1;          /* NeighbourList */
static int hf_rrc_neighbourList_v390ext = -1;     /* NeighbourList_v390ext */
static int hf_rrc_modeSpecificInfo_138 = -1;      /* T_modeSpecificInfo_138 */
static int hf_rrc_fdd_178 = -1;                   /* T_fdd_172 */
static int hf_rrc_tdd_129 = -1;                   /* T_tdd_121 */
static int hf_rrc_cellAndChannelIdentity = -1;    /* CellAndChannelIdentity */
static int hf_rrc_ue_positioning_IPDL_Paremeters = -1;  /* UE_Positioning_IPDL_Parameters */
static int hf_rrc_sfn_SFN_RelTimeDifference = -1;  /* SFN_SFN_RelTimeDifference1 */
static int hf_rrc_sfn_SFN_Drift = -1;             /* SFN_SFN_Drift */
static int hf_rrc_searchWindowSize = -1;          /* OTDOA_SearchWindowSize */
static int hf_rrc_positioningMode = -1;           /* T_positioningMode */
static int hf_rrc_ueBased = -1;                   /* T_ueBased */
static int hf_rrc_ueAssisted = -1;                /* T_ueAssisted */
static int hf_rrc_modeSpecificInfo_139 = -1;      /* T_modeSpecificInfo_139 */
static int hf_rrc_fdd_179 = -1;                   /* T_fdd_173 */
static int hf_rrc_tdd_130 = -1;                   /* T_tdd_122 */
static int hf_rrc_ue_positioning_IPDL_Paremeters_01 = -1;  /* UE_Positioning_IPDL_Parameters_r4 */
static int hf_rrc_positioningMode_01 = -1;        /* T_positioningMode_01 */
static int hf_rrc_ueBased_01 = -1;                /* T_ueBased_01 */
static int hf_rrc_relativeNorth = -1;             /* INTEGER_M20000_20000 */
static int hf_rrc_relativeEast = -1;              /* INTEGER_M20000_20000 */
static int hf_rrc_relativeAltitude = -1;          /* INTEGER_M4000_4000 */
static int hf_rrc_fineSFN_SFN = -1;               /* FineSFN_SFN */
static int hf_rrc_roundTripTime = -1;             /* INTEGER_0_32766 */
static int hf_rrc_ueAssisted_01 = -1;             /* T_ueAssisted_01 */
static int hf_rrc_modeSpecificInfo_140 = -1;      /* T_modeSpecificInfo_140 */
static int hf_rrc_fdd_180 = -1;                   /* T_fdd_174 */
static int hf_rrc_tdd_131 = -1;                   /* T_tdd_123 */
static int hf_rrc_roundTripTimeExtension = -1;    /* INTEGER_0_70274 */
static int hf_rrc_modeSpecificInfo_141 = -1;      /* T_modeSpecificInfo_141 */
static int hf_rrc_fdd_181 = -1;                   /* T_fdd_175 */
static int hf_rrc_tdd_132 = -1;                   /* T_tdd_124 */
static int hf_rrc_positioningMode_02 = -1;        /* T_positioningMode_02 */
static int hf_rrc_ueBased_02 = -1;                /* T_ueBased_02 */
static int hf_rrc_ueAssisted_02 = -1;             /* T_ueAssisted_02 */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_item = -1;  /* UE_Positioning_OTDOA_NeighbourCellInfo */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_r4_item = -1;  /* UE_Positioning_OTDOA_NeighbourCellInfo_r4 */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_UEB_item = -1;  /* UE_Positioning_OTDOA_NeighbourCellInfo_UEB */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_UEB_ext_item = -1;  /* UE_Positioning_OTDOA_NeighbourCellInfo_UEB_ext */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_r7_item = -1;  /* UE_Positioning_OTDOA_NeighbourCellInfo_r7 */
static int hf_rrc_stdResolution = -1;             /* BIT_STRING_SIZE_2 */
static int hf_rrc_numberOfOTDOA_Measurements = -1;  /* BIT_STRING_SIZE_3 */
static int hf_rrc_stdOfOTDOA_Measurements = -1;   /* BIT_STRING_SIZE_5 */
static int hf_rrc_modeSpecificInfo_142 = -1;      /* T_modeSpecificInfo_142 */
static int hf_rrc_fdd_182 = -1;                   /* T_fdd_176 */
static int hf_rrc_tdd_133 = -1;                   /* T_tdd_125 */
static int hf_rrc_positioningMode_03 = -1;        /* T_positioningMode_03 */
static int hf_rrc_ueBased_03 = -1;                /* T_ueBased_03 */
static int hf_rrc_ueAssisted_03 = -1;             /* T_ueAssisted_03 */
static int hf_rrc_modeSpecificInfo_143 = -1;      /* T_modeSpecificInfo_143 */
static int hf_rrc_fdd_183 = -1;                   /* T_fdd_177 */
static int hf_rrc_tdd_134 = -1;                   /* T_tdd_126 */
static int hf_rrc_positioningMode_04 = -1;        /* T_positioningMode_04 */
static int hf_rrc_ueBased_04 = -1;                /* T_ueBased_04 */
static int hf_rrc_cellPosition = -1;              /* ReferenceCellPosition */
static int hf_rrc_ueAssisted_04 = -1;             /* T_ueAssisted_04 */
static int hf_rrc_modeSpecificInfo_144 = -1;      /* T_modeSpecificInfo_144 */
static int hf_rrc_fdd_184 = -1;                   /* T_fdd_178 */
static int hf_rrc_tdd_135 = -1;                   /* T_tdd_127 */
static int hf_rrc_modeSpecificInfo_145 = -1;      /* T_modeSpecificInfo_145 */
static int hf_rrc_fdd_185 = -1;                   /* T_fdd_179 */
static int hf_rrc_tdd_136 = -1;                   /* T_tdd_128 */
static int hf_rrc_positioningMode_05 = -1;        /* T_positioningMode_05 */
static int hf_rrc_ueBased_05 = -1;                /* T_ueBased_05 */
static int hf_rrc_ueAssisted_05 = -1;             /* T_ueAssisted_05 */
static int hf_rrc_referenceTime_02 = -1;          /* T_referenceTime_02 */
static int hf_rrc_cell_Timing = -1;               /* T_cell_Timing */
static int hf_rrc_modeSpecificInfo_146 = -1;      /* T_modeSpecificInfo_146 */
static int hf_rrc_fdd_186 = -1;                   /* T_fdd_180 */
static int hf_rrc_tdd_137 = -1;                   /* T_tdd_129 */
static int hf_rrc_positionEstimate = -1;          /* PositionEstimate */
static int hf_rrc_referenceTimeOptions = -1;      /* T_referenceTimeOptions */
static int hf_rrc_earlier_than_r7 = -1;           /* NULL */
static int hf_rrc_r7_15 = -1;                     /* T_r7_15 */
static int hf_rrc_referenceTime_03 = -1;          /* T_referenceTime_03 */
static int hf_rrc_positionData = -1;              /* BIT_STRING_SIZE_16 */
static int hf_rrc_velocityEstimate = -1;          /* VelocityEstimate */
static int hf_rrc_ue_positioning_ReportingCriteria = -1;  /* UE_Positioning_EventParamList */
static int hf_rrc_ue_positioning_ReportingCriteria_01 = -1;  /* UE_Positioning_EventParamList_r7 */
static int hf_rrc_methodType = -1;                /* UE_Positioning_MethodType */
static int hf_rrc_positioningMethod = -1;         /* PositioningMethod */
static int hf_rrc_dummy1_06 = -1;                 /* UE_Positioning_ResponseTime */
static int hf_rrc_horizontal_Accuracy = -1;       /* UE_Positioning_Accuracy */
static int hf_rrc_gps_TimingOfCellWanted = -1;    /* BOOLEAN */
static int hf_rrc_additionalAssistanceDataRequest = -1;  /* BOOLEAN */
static int hf_rrc_environmentCharacterisation = -1;  /* EnvironmentCharacterisation */
static int hf_rrc_vertical_Accuracy = -1;         /* UE_Positioning_Accuracy */
static int hf_rrc_horizontalAccuracy = -1;        /* UE_Positioning_Accuracy */
static int hf_rrc_verticalAccuracy = -1;          /* UE_Positioning_Accuracy */
static int hf_rrc_additionalAssistanceDataReq = -1;  /* BOOLEAN */
static int hf_rrc_velocityRequested = -1;         /* T_velocityRequested */
static int hf_rrc_gANSSPositioningMethods = -1;   /* BIT_STRING_SIZE_16 */
static int hf_rrc_gANSSTimingOfCellWanted = -1;   /* BIT_STRING_SIZE_8 */
static int hf_rrc_gANSSCarrierPhaseMeasurementRequested = -1;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_velocityRequested_01 = -1;      /* T_velocityRequested_01 */
static int hf_rrc_gANSSMultiFreqMeasurementRequested = -1;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcA0 = -1;                     /* BIT_STRING_SIZE_16 */
static int hf_rrc_utcA1 = -1;                     /* BIT_STRING_SIZE_13 */
static int hf_rrc_utcA2 = -1;                     /* BIT_STRING_SIZE_7 */
static int hf_rrc_utcDeltaTls = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcTot = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_utcWNot = -1;                   /* BIT_STRING_SIZE_13 */
static int hf_rrc_utcWNlsf = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcDN = -1;                     /* BIT_STRING_SIZE_4 */
static int hf_rrc_utcDeltaTlsf = -1;              /* BIT_STRING_SIZE_8 */
static int hf_rrc_nA = -1;                        /* BIT_STRING_SIZE_11 */
static int hf_rrc_tauC = -1;                      /* BIT_STRING_SIZE_32 */
static int hf_rrc_deltaUT1_01 = -1;               /* DeltaUT1 */
static int hf_rrc_kp = -1;                        /* BIT_STRING_SIZE_2 */
static int hf_rrc_utcA1wnt = -1;                  /* BIT_STRING_SIZE_24 */
static int hf_rrc_utcA0wnt = -1;                  /* BIT_STRING_SIZE_32 */
static int hf_rrc_utcTot_01 = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcWNt = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcDN_01 = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcStandardID = -1;             /* BIT_STRING_SIZE_3 */
static int hf_rrc_ue_GANSSTimingOfCellFrames = -1;  /* T_ue_GANSSTimingOfCellFrames */
static int hf_rrc_ms_Part = -1;                   /* INTEGER_0_80 */
static int hf_rrc_ls_Part = -1;                   /* INTEGER_0_4294967295 */
static int hf_rrc_gANSS_TimeId = -1;              /* INTEGER_0_7 */
static int hf_rrc_gANSS_TimeUncertainty = -1;     /* INTEGER_0_127 */
static int hf_rrc_mode_02 = -1;                   /* T_mode_02 */
static int hf_rrc_fdd_187 = -1;                   /* T_fdd_181 */
static int hf_rrc_tdd_138 = -1;                   /* T_tdd_130 */
static int hf_rrc_UTRAN_FDD_FrequencyList_item = -1;  /* UTRAN_FDD_Frequency */
static int hf_rrc_qQualMinFDD = -1;               /* INTEGER_M24_0 */
static int hf_rrc_qRxLevMinFDD = -1;              /* INTEGER_M60_M13 */
static int hf_rrc_UTRAN_TDD_FrequencyList_item = -1;  /* UTRAN_TDD_Frequency */
static int hf_rrc_qRxLevMinTDD = -1;              /* INTEGER_M60_M13 */
static int hf_rrc_utran_GPSTimingOfCell = -1;     /* T_utran_GPSTimingOfCell */
static int hf_rrc_ms_part = -1;                   /* INTEGER_0_1023 */
static int hf_rrc_ls_part = -1;                   /* INTEGER_0_4294967295 */
static int hf_rrc_modeSpecificInfo_147 = -1;      /* T_modeSpecificInfo_147 */
static int hf_rrc_fdd_188 = -1;                   /* T_fdd_182 */
static int hf_rrc_tdd_139 = -1;                   /* T_tdd_131 */
static int hf_rrc_ue_GPSTimingOfCell = -1;        /* T_ue_GPSTimingOfCell */
static int hf_rrc_ms_part_01 = -1;                /* INTEGER_0_16383 */
static int hf_rrc_modeSpecificInfo_148 = -1;      /* T_modeSpecificInfo_148 */
static int hf_rrc_fdd_189 = -1;                   /* T_fdd_183 */
static int hf_rrc_tdd_140 = -1;                   /* T_tdd_132 */
static int hf_rrc_utra_ServingCell = -1;          /* T_utra_ServingCell */
static int hf_rrc_s_PrioritySearch1 = -1;         /* INTEGER_0_31 */
static int hf_rrc_s_PrioritySearch2 = -1;         /* INTEGER_0_7 */
static int hf_rrc_threshServingLow = -1;          /* INTEGER_0_31 */
static int hf_rrc_utran_FDD_FrequencyList = -1;   /* UTRAN_FDD_FrequencyList */
static int hf_rrc_utran_TDD_FrequencyList = -1;   /* UTRAN_TDD_FrequencyList */
static int hf_rrc_threshServingLow2 = -1;         /* INTEGER_0_31 */
static int hf_rrc_horizontalWithVerticalVelocity = -1;  /* HorizontalWithVerticalVelocity */
static int hf_rrc_horizontalVelocityWithUncertainty = -1;  /* HorizontalVelocityWithUncertainty */
static int hf_rrc_horizontalWithVerticalVelocityAndUncertainty = -1;  /* HorizontalWithVerticalVelocityAndUncertainty */
static int hf_rrc_bcch_ModificationTime = -1;     /* BCCH_ModificationTime */
static int hf_rrc_ncc = -1;                       /* NCC */
static int hf_rrc_bcc = -1;                       /* BCC */
static int hf_rrc_ctch_AllocationPeriod = -1;     /* INTEGER_1_256 */
static int hf_rrc_cbs_FrameOffset = -1;           /* INTEGER_0_255 */
static int hf_rrc_msg_Type = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rrc_payload_02 = -1;                /* BIT_STRING_SIZE_1_512 */
static int hf_rrc_CDMA2000_MessageList_item = -1;  /* CDMA2000_Message */
static int hf_rrc_CDMA2000_UMTS_Frequency_List_item = -1;  /* FrequencyInfoCDMA2000 */
static int hf_rrc_dataTransmFreqGranularity = -1;  /* T_dataTransmFreqGranularity */
static int hf_rrc_numberOfDataTransmOcc = -1;     /* INTEGER_1_610 */
static int hf_rrc_dataVolumeMontoringWindow = -1;  /* INTEGER_1_120 */
static int hf_rrc_dataTransmFrequency = -1;       /* DataTransmFrequency */
static int hf_rrc_dataVolumePerRB = -1;           /* DataVolumePerRB_List */
static int hf_rrc_dataVolume = -1;                /* INTEGER_0_4294967295 */
static int hf_rrc_DataVolumePerRB_List_item = -1;  /* DataVolumePerRB */
static int hf_rrc_modeSpecificInfo_149 = -1;      /* T_modeSpecificInfo_149 */
static int hf_rrc_fdd_190 = -1;                   /* T_fdd_184 */
static int hf_rrc_intraFreqMeasQuantity_FDD_01 = -1;  /* IntraFreqMeasQuantity_FDD_sib3 */
static int hf_rrc_tdd_141 = -1;                   /* T_tdd_133 */
static int hf_rrc_intraFreqMeasQuantity_TDDList_01 = -1;  /* IntraFreqMeasQuantity_TDD_sib3List */
static int hf_rrc_warningType = -1;               /* OCTET_STRING_SIZE_1_2 */
static int hf_rrc_messageIdentifier = -1;         /* OCTET_STRING_SIZE_2 */
static int hf_rrc_serialNumber = -1;              /* OCTET_STRING_SIZE_2 */
static int hf_rrc_EUTRA_BlacklistedCellPerFreqList_item = -1;  /* EUTRA_BlacklistedCell */
static int hf_rrc_ue_EUTRA_Capability = -1;       /* T_ue_EUTRA_Capability */
static int hf_rrc_EUTRA_TargetFreqInfoList_item = -1;  /* EUTRA_TargetFreqInfo */
static int hf_rrc_EUTRA_TargetFreqInfoList_vb50ext_item = -1;  /* EUTRA_TargetFreqInfo_vb50ext */
static int hf_rrc_dlEUTRACarrierFreq = -1;        /* EARFCN */
static int hf_rrc_eutraBlacklistedCellPerFreqList = -1;  /* EUTRA_BlacklistedCellPerFreqList */
static int hf_rrc_extensionGANSS_SIBType = -1;    /* SIB_TypeExtGANSS */
static int hf_rrc_schedulingInfo = -1;            /* SchedulingInformation */
static int hf_rrc_valueTagInfo = -1;              /* ValueTagInfo */
static int hf_rrc_ExtGANSS_SIBTypeInfoSchedulingInfoList_item = -1;  /* ExtGANSS_SIBTypeInfoSchedulingInfo */
static int hf_rrc_ganssID = -1;                   /* INTEGER_0_7 */
static int hf_rrc_sbasID = -1;                    /* UE_Positioning_GANSS_SBAS_ID */
static int hf_rrc_ganssScheduling = -1;           /* SEQUENCE_SIZE_1_maxSIB_OF_ExtGANSS_SchedulingInfo */
static int hf_rrc_ganssScheduling_item = -1;      /* ExtGANSS_SchedulingInfo */
static int hf_rrc_ExtSIBTypeInfoSchedulingInfo_List_item = -1;  /* ExtSIBTypeInfoSchedulingInfo */
static int hf_rrc_extensionSIB_Type = -1;         /* SIB_TypeExt */
static int hf_rrc_ExtSIBTypeInfoSchedulingInfo_List2_item = -1;  /* ExtSIBTypeInfoSchedulingInfo2 */
static int hf_rrc_extensionSIB_Type2 = -1;        /* SIB_TypeExt2 */
static int hf_rrc_FDD_UMTS_Frequency_List_item = -1;  /* FrequencyInfoFDD */
static int hf_rrc_band_Class = -1;                /* BIT_STRING_SIZE_5 */
static int hf_rrc_cdma_Freq = -1;                 /* BIT_STRING_SIZE_11 */
static int hf_rrc_GERAN_SystemInformation_item = -1;  /* GERAN_SystemInfoBlock */
static int hf_rrc_gsmLowRangeUARFCN = -1;         /* UARFCN */
static int hf_rrc_gsmUpRangeUARFCN = -1;          /* UARFCN */
static int hf_rrc_GSM_BA_Range_List_item = -1;    /* GSM_BA_Range */
static int hf_rrc_GSM_MessageList_item = -1;      /* GSM_MessageList_item */
static int hf_rrc_GSM_TargetCellInfoList_item = -1;  /* GSM_TargetCellInfo */
static int hf_rrc_receivedMessageType = -1;       /* ReceivedMessageType */
static int hf_rrc_configurationUnacceptable = -1;  /* NULL */
static int hf_rrc_unspecified = -1;               /* NULL */
static int hf_rrc_GERANIu_MessageList_item = -1;  /* BIT_STRING_SIZE_1_32768 */
static int hf_rrc_gsm_18 = -1;                    /* T_gsm_16 */
static int hf_rrc_gsm_Classmark2 = -1;            /* GSM_Classmark2 */
static int hf_rrc_gsm_Classmark3 = -1;            /* GSM_Classmark3 */
static int hf_rrc_cdma2000_01 = -1;               /* T_cdma2000_01 */
static int hf_rrc_InterRAT_UE_RadioAccessCapabilityList_item = -1;  /* InterRAT_UE_RadioAccessCapability */
static int hf_rrc_geranIu_RadioAccessCapability = -1;  /* GERANIu_RadioAccessCapability */
static int hf_rrc_supportOfInter_RAT_PS_Handover = -1;  /* T_supportOfInter_RAT_PS_Handover */
static int hf_rrc_gsm_MS_RadioAccessCapability = -1;  /* GSM_MS_RadioAccessCapability */
static int hf_rrc_eutra_RadioAccessCapability = -1;  /* EUTRA_RadioAccessCapability */
static int hf_rrc_gsm_19 = -1;                    /* T_gsm_17 */
static int hf_rrc_gsmSecurityCapability = -1;     /* GsmSecurityCapability */
static int hf_rrc_InterRAT_UE_SecurityCapList_item = -1;  /* InterRAT_UE_SecurityCapability */
static int hf_rrc_interRAT_ProtocolError = -1;    /* NULL */
static int hf_rrc_plmn_Type = -1;                 /* PLMN_Type */
static int hf_rrc_sibSb_ReferenceList = -1;       /* SIBSb_ReferenceList */
static int hf_rrc_v690NonCriticalExtensions_48 = -1;  /* T_v690NonCriticalExtensions_48 */
static int hf_rrc_masterInformationBlock_v690ext = -1;  /* MasterInformationBlock_v690ext */
static int hf_rrc_v6b0NonCriticalExtensions_16 = -1;  /* T_v6b0NonCriticalExtensions_15 */
static int hf_rrc_masterInformationBlock_v6b0ext = -1;  /* MasterInformationBlock_v6b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_26 = -1;  /* T_v860NonCriticalExtensions_26 */
static int hf_rrc_masterInformationBlock_v860ext = -1;  /* MasterInformationBlock_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_196 = -1;  /* T_nonCriticalExtensions_196 */
static int hf_rrc_multiplePLMN_List = -1;         /* MultiplePLMN_List_r6 */
static int hf_rrc_extSIBTypeInfoSchedulingInfo_List = -1;  /* ExtSIBTypeInfoSchedulingInfo_List */
static int hf_rrc_extSIBTypeInfoSchedulingInfo_List_01 = -1;  /* ExtSIBTypeInfoSchedulingInfo_List2 */
static int hf_rrc_extGANSS_SIBTypeInfoSchedulingInfoList = -1;  /* ExtGANSS_SIBTypeInfoSchedulingInfoList */
static int hf_rrc_csg_Indicator = -1;             /* T_csg_Indicator */
static int hf_rrc_predefinedConfigValueTag = -1;  /* PredefinedConfigValueTag */
static int hf_rrc_diagnosticsType_01 = -1;        /* T_diagnosticsType_01 */
static int hf_rrc_type1_08 = -1;                  /* T_type1_07 */
static int hf_rrc_protocolErrorCause = -1;        /* ProtocolErrorCause */
static int hf_rrc_gsm_BA_Range_List = -1;         /* GSM_BA_Range_List */
static int hf_rrc_fdd_UMTS_Frequency_List = -1;   /* FDD_UMTS_Frequency_List */
static int hf_rrc_tdd_UMTS_Frequency_List = -1;   /* TDD_UMTS_Frequency_List */
static int hf_rrc_cdma2000_UMTS_Frequency_List = -1;  /* CDMA2000_UMTS_Frequency_List */
static int hf_rrc_tdd384_UMTS_Frequency_List = -1;  /* TDD_UMTS_Frequency_List */
static int hf_rrc_tdd128_UMTS_Frequency_List = -1;  /* TDD_UMTS_Frequency_List */
static int hf_rrc_scheduling = -1;                /* T_scheduling */
static int hf_rrc_segCount = -1;                  /* SegCount */
static int hf_rrc_sib_Pos = -1;                   /* T_sib_Pos */
static int hf_rrc_rep4 = -1;                      /* INTEGER_0_1 */
static int hf_rrc_rep8 = -1;                      /* INTEGER_0_3 */
static int hf_rrc_rep16 = -1;                     /* INTEGER_0_7 */
static int hf_rrc_rep32 = -1;                     /* INTEGER_0_15 */
static int hf_rrc_rep64 = -1;                     /* INTEGER_0_31 */
static int hf_rrc_rep128 = -1;                    /* INTEGER_0_63 */
static int hf_rrc_rep256 = -1;                    /* INTEGER_0_127 */
static int hf_rrc_rep512 = -1;                    /* INTEGER_0_255 */
static int hf_rrc_rep1024 = -1;                   /* INTEGER_0_511 */
static int hf_rrc_rep2048 = -1;                   /* INTEGER_0_1023 */
static int hf_rrc_rep4096 = -1;                   /* INTEGER_0_2047 */
static int hf_rrc_sib_PosOffsetInfo = -1;         /* SibOFF_List */
static int hf_rrc_sib_Type_01 = -1;               /* SIB_TypeAndTag */
static int hf_rrc_scheduling_01 = -1;             /* SchedulingInformation */
static int hf_rrc_sibSb_Type = -1;                /* SIBSb_TypeAndTag */
static int hf_rrc_sibOccurIdentity = -1;          /* SIBOccurIdentity */
static int hf_rrc_sibOccurValueTag = -1;          /* SIBOccurValueTag */
static int hf_rrc_SIB_ReferenceList_item = -1;    /* SchedulingInformationSIB */
static int hf_rrc_SIBSb_ReferenceList_item = -1;  /* SchedulingInformationSIBSb */
static int hf_rrc_SIB_ReferenceListFACH_item = -1;  /* SchedulingInformationSIB */
static int hf_rrc_sysInfoType1_01 = -1;           /* PLMN_ValueTag */
static int hf_rrc_sysInfoType2 = -1;              /* CellValueTag */
static int hf_rrc_sysInfoType3_01 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType4 = -1;              /* CellValueTag */
static int hf_rrc_sysInfoType5_01 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType6 = -1;              /* CellValueTag */
static int hf_rrc_sysInfoType7_01 = -1;           /* NULL */
static int hf_rrc_dummy_57 = -1;                  /* CellValueTag */
static int hf_rrc_dummy2_14 = -1;                 /* NULL */
static int hf_rrc_dummy3_03 = -1;                 /* NULL */
static int hf_rrc_sysInfoType11_01 = -1;          /* CellValueTag */
static int hf_rrc_sysInfoType12_01 = -1;          /* CellValueTag */
static int hf_rrc_sysInfoType13 = -1;             /* CellValueTag */
static int hf_rrc_sysInfoType13_1 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType13_2 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType13_3 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType13_4 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType14 = -1;             /* NULL */
static int hf_rrc_sysInfoType15 = -1;             /* CellValueTag */
static int hf_rrc_sysInfoType16 = -1;             /* PredefinedConfigIdentityAndValueTag */
static int hf_rrc_sysInfoType17 = -1;             /* NULL */
static int hf_rrc_sysInfoType15_1 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType15_2 = -1;           /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_sysInfoType15_3 = -1;           /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_sysInfoType15_4 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType18 = -1;             /* CellValueTag */
static int hf_rrc_sysInfoType15_5 = -1;           /* CellValueTag */
static int hf_rrc_sysInfoType5bis = -1;           /* CellValueTag */
static int hf_rrc_sysInfoTypeSB1_01 = -1;         /* CellValueTag */
static int hf_rrc_sysInfoTypeSB2_01 = -1;         /* CellValueTag */
static int hf_rrc_systemInfoType11bis = -1;       /* NULL */
static int hf_rrc_systemInfoType15bis = -1;       /* NULL */
static int hf_rrc_systemInfoType15_1bis = -1;     /* NULL */
static int hf_rrc_systemInfoType15_2bis = -1;     /* NULL */
static int hf_rrc_systemInfoType15_3bis = -1;     /* NULL */
static int hf_rrc_systemInfoType15_6 = -1;        /* NULL */
static int hf_rrc_systemInfoType15_7 = -1;        /* NULL */
static int hf_rrc_systemInfoType15_8 = -1;        /* NULL */
static int hf_rrc_systemInfoType19 = -1;          /* NULL */
static int hf_rrc_systemInfoType15_2ter = -1;     /* NULL */
static int hf_rrc_systemInfoType20 = -1;          /* NULL */
static int hf_rrc_systemInfoType21 = -1;          /* NULL */
static int hf_rrc_systemInfoType22 = -1;          /* NULL */
static int hf_rrc_SibOFF_List_item = -1;          /* SibOFF */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_03 = -1;  /* T_cn_CommonGSM_MAP_NAS_SysInfo_03 */
static int hf_rrc_cn_DomainSysInfoList = -1;      /* CN_DomainSysInfoList */
static int hf_rrc_ue_IdleTimersAndConstants = -1;  /* UE_IdleTimersAndConstants */
static int hf_rrc_v3a0NonCriticalExtensions_12 = -1;  /* T_v3a0NonCriticalExtensions_12 */
static int hf_rrc_sysInfoType1_v3a0ext = -1;      /* SysInfoType1_v3a0ext_IEs */
static int hf_rrc_v860NonCriticalExtentions_02 = -1;  /* T_v860NonCriticalExtentions_02 */
static int hf_rrc_sysInfoType1_v860ext = -1;      /* SysInfoType1_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_197 = -1;  /* T_nonCriticalExtensions_197 */
static int hf_rrc_ue_IdleTimersAndConstants_v3a0ext = -1;  /* UE_IdleTimersAndConstants_v3a0ext */
static int hf_rrc_ura_IdentityList = -1;          /* URA_IdentityList */
static int hf_rrc_nonCriticalExtensions_198 = -1;  /* T_nonCriticalExtensions_198 */
static int hf_rrc_sib4indicator = -1;             /* BOOLEAN */
static int hf_rrc_cellSelectReselectInfo = -1;    /* CellSelectReselectInfoSIB_3_4 */
static int hf_rrc_cellAccessRestriction = -1;     /* CellAccessRestriction */
static int hf_rrc_v4b0NonCriticalExtensions_17 = -1;  /* T_v4b0NonCriticalExtensions_17 */
static int hf_rrc_sysInfoType3_v4b0ext = -1;      /* SysInfoType3_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension = -1;  /* T_v590NonCriticalExtension */
static int hf_rrc_sysInfoType3_v590ext = -1;      /* SysInfoType3_v590ext */
static int hf_rrc_v5c0NoncriticalExtension = -1;  /* T_v5c0NoncriticalExtension */
static int hf_rrc_sysInfoType3_v5c0ext = -1;      /* SysInfoType3_v5c0ext_IEs */
static int hf_rrc_v670NonCriticalExtension = -1;  /* T_v670NonCriticalExtension */
static int hf_rrc_sysInfoType3_v670ext = -1;      /* SysInfoType3_v670ext */
static int hf_rrc_v770NonCriticalExtension_02 = -1;  /* T_v770NonCriticalExtension_02 */
static int hf_rrc_sysInfoType3_v770ext = -1;      /* SysInfoType3_v770ext_IEs */
static int hf_rrc_v830NonCriticalExtension = -1;  /* T_v830NonCriticalExtension */
static int hf_rrc_sysInfoType3_v830ext = -1;      /* SysInfoType3_v830ext_IEs */
static int hf_rrc_v860NonCriticalExtension_01 = -1;  /* T_v860NonCriticalExtension_01 */
static int hf_rrc_sysInfoType3_v860ext = -1;      /* SysInfoType3_v860ext_IEs */
static int hf_rrc_v870NonCriticalExtension = -1;  /* T_v870NonCriticalExtension */
static int hf_rrc_sysInfoType3_v870ext = -1;      /* SysInfoType3_v870ext_IEs */
static int hf_rrc_v900NonCriticalExtension = -1;  /* T_v900NonCriticalExtension */
static int hf_rrc_sysInfoType3_v920ext = -1;      /* SysInfoType3_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_199 = -1;  /* T_nonCriticalExtensions_199 */
static int hf_rrc_mapping_LCR = -1;               /* Mapping_LCR_r4 */
static int hf_rrc_cellSelectReselectInfo_v590ext = -1;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_cellSelectReselectInfoTreselectionScaling_v5c0ext = -1;  /* CellSelectReselectInfoTreselectionScaling_v5c0ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForPLMNOfMIB = -1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestictionForSharedNetwork = -1;  /* DomainSpecificAccessRestrictionForSharedNetwork_v670ext */
static int hf_rrc_deferredMeasurementControlReadingSupport = -1;  /* DeferredMeasurementControlReadingSupport */
static int hf_rrc_q_QualMin_Offset = -1;          /* Q_QualMin_Offset */
static int hf_rrc_q_RxlevMin_Offset = -1;         /* Q_RxlevMin_Offset */
static int hf_rrc_mbsfnOnlyService = -1;          /* MBSFNOnlyService */
static int hf_rrc_pagingPermissionWithAccessControlParametersForPLMNOfMIB = -1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForSharedNetwork = -1;  /* PagingPermissionWithAccessControlForSharedNetwork */
static int hf_rrc_csg_PSCSplitInfo = -1;          /* CSG_PSCSplitInfo */
static int hf_rrc_cellAccessRestriction_01 = -1;  /* CellAccessRestriction_v870ext */
static int hf_rrc_imsEmergencySupportIndicator = -1;  /* T_imsEmergencySupportIndicator */
static int hf_rrc_v4b0NonCriticalExtensions_18 = -1;  /* T_v4b0NonCriticalExtensions_18 */
static int hf_rrc_sysInfoType4_v4b0ext = -1;      /* SysInfoType4_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension_01 = -1;  /* T_v590NonCriticalExtension_01 */
static int hf_rrc_sysInfoType4_v590ext = -1;      /* SysInfoType4_v590ext */
static int hf_rrc_v5b0NonCriticalExtension = -1;  /* T_v5b0NonCriticalExtension */
static int hf_rrc_sysInfoType4_v5b0ext = -1;      /* SysInfoType4_v5b0ext_IEs */
static int hf_rrc_v5c0NonCriticalExtension = -1;  /* T_v5c0NonCriticalExtension */
static int hf_rrc_sysInfoType4_v5c0ext = -1;      /* SysInfoType4_v5c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_200 = -1;  /* T_nonCriticalExtensions_200 */
static int hf_rrc_cellSelectReselectInfoPCHFACH_v5b0ext = -1;  /* CellSelectReselectInfoPCHFACH_v5b0ext */
static int hf_rrc_sib6indicator = -1;             /* BOOLEAN */
static int hf_rrc_pich_PowerOffset = -1;          /* PICH_PowerOffset */
static int hf_rrc_modeSpecificInfo_150 = -1;      /* T_modeSpecificInfo_150 */
static int hf_rrc_fdd_191 = -1;                   /* T_fdd_185 */
static int hf_rrc_aich_PowerOffset = -1;          /* AICH_PowerOffset */
static int hf_rrc_tdd_142 = -1;                   /* T_tdd_134 */
static int hf_rrc_pusch_SysInfoList_SFN = -1;     /* PUSCH_SysInfoList_SFN */
static int hf_rrc_pdsch_SysInfoList_SFN = -1;     /* PDSCH_SysInfoList_SFN */
static int hf_rrc_openLoopPowerControl_TDD = -1;  /* OpenLoopPowerControl_TDD */
static int hf_rrc_prach_SystemInformationList = -1;  /* PRACH_SystemInformationList */
static int hf_rrc_sCCPCH_SystemInformationList = -1;  /* SCCPCH_SystemInformationList */
static int hf_rrc_cbs_DRX_Level1Information = -1;  /* CBS_DRX_Level1Information */
static int hf_rrc_v4b0NonCriticalExtensions_19 = -1;  /* T_v4b0NonCriticalExtensions_19 */
static int hf_rrc_sysInfoType5_v4b0ext = -1;      /* SysInfoType5_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_28 = -1;  /* T_v590NonCriticalExtensions_28 */
static int hf_rrc_sysInfoType5_v590ext = -1;      /* SysInfoType5_v590ext_IEs */
static int hf_rrc_v650NonCriticalExtensions = -1;  /* T_v650NonCriticalExtensions */
static int hf_rrc_sysInfoType5_v650ext = -1;      /* SysInfoType5_v650ext_IEs */
static int hf_rrc_v680NonCriticalExtensions_02 = -1;  /* T_v680NonCriticalExtensions_02 */
static int hf_rrc_sysInfoType5_v680ext = -1;      /* SysInfoType5_v680ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_49 = -1;  /* T_v690NonCriticalExtensions_49 */
static int hf_rrc_sysInfoType5_v690ext = -1;      /* SysInfoType5_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_40 = -1;  /* T_v770NonCriticalExtensions_40 */
static int hf_rrc_sysInfoType5_v770ext = -1;      /* SysInfoType5_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_27 = -1;  /* T_v860NonCriticalExtensions_27 */
static int hf_rrc_sysInfoType5_v860ext = -1;      /* SysInfoType5_v860ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_11 = -1;  /* T_v890NonCriticalExtensions_11 */
static int hf_rrc_sysInfoType5_v890ext = -1;      /* SysInfoType5_v890ext_IEs */
static int hf_rrc_v8b0NonCriticalExtensions_01 = -1;  /* T_v8b0NonCriticalExtensions_01 */
static int hf_rrc_sysInfoType5_v8b0ext = -1;      /* SysInfoType5_v8b0ext_IEs */
static int hf_rrc_v8d0NonCriticalExtensions = -1;  /* T_v8d0NonCriticalExtensions */
static int hf_rrc_sysInfoType5_v8d0ext = -1;      /* SysInfoType5_v8d0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_19 = -1;  /* T_va40NonCriticalExtensions_18 */
static int hf_rrc_sysInfoType5_va40ext = -1;      /* SysInfoType5_va40ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_02 = -1;  /* T_va80NonCriticalExtensions_02 */
static int hf_rrc_sysInfoType5_va80ext = -1;      /* SysInfoType5_va80ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_24 = -1;  /* SysInfoType5_NonCriticalExtensions_vb50_IEs */
static int hf_rrc_pNBSCH_Allocation_r4 = -1;      /* PNBSCH_Allocation_r4 */
static int hf_rrc_prach_SystemInformationList_LCR_r4 = -1;  /* PRACH_SystemInformationList_LCR_r4 */
static int hf_rrc_tdd128SpecificInfo = -1;        /* T_tdd128SpecificInfo */
static int hf_rrc_pusch_SysInfoList_SFN_01 = -1;  /* PUSCH_SysInfoList_SFN_LCR_r4 */
static int hf_rrc_pdsch_SysInfoList_SFN_01 = -1;  /* PDSCH_SysInfoList_SFN_LCR_r4 */
static int hf_rrc_pCCPCH_LCR_Extensions = -1;     /* PrimaryCCPCH_Info_LCR_r4_ext */
static int hf_rrc_sCCPCH_LCR_ExtensionsList = -1;  /* SCCPCH_SystemInformationList_LCR_r4_ext */
static int hf_rrc_frequencyBandIndicator = -1;    /* RadioFrequencyBandFDD */
static int hf_rrc_hcr_r5_SpecificInfo = -1;       /* T_hcr_r5_SpecificInfo */
static int hf_rrc_pusch_SysInfoList_SFN_02 = -1;  /* PUSCH_SysInfoList_SFN_HCR_r5 */
static int hf_rrc_pdsch_SysInfoList_SFN_02 = -1;  /* PDSCH_SysInfoList_SFN_HCR_r5 */
static int hf_rrc_frequencyBandIndicator2 = -1;   /* RadioFrequencyBandFDD2 */
static int hf_rrc_hsdpa_CellIndicator = -1;       /* T_hsdpa_CellIndicator */
static int hf_rrc_edch_CellIndicator = -1;        /* T_edch_CellIndicator */
static int hf_rrc_sccpch_SystemInformation_MBMS = -1;  /* T_sccpch_SystemInformation_MBMS */
static int hf_rrc_mcchOnSCCPCHusedForNonMBMS = -1;  /* MBMS_MCCH_ConfigurationInfo_r6 */
static int hf_rrc_mcchOnSCCPCHusedOnlyForMBMS = -1;  /* SCCPCH_SystemInformation_MBMS_r6 */
static int hf_rrc_additionalPRACH_TF_and_TFCS_CCCH_List = -1;  /* AdditionalPRACH_TF_and_TFCS_CCCH_List */
static int hf_rrc_cBS_DRX_Level1Information_extension = -1;  /* CBS_DRX_Level1Information_extension_r6 */
static int hf_rrc_modeSpecificInfo_151 = -1;      /* T_modeSpecificInfo_151 */
static int hf_rrc_fdd_192 = -1;                   /* T_fdd_186 */
static int hf_rrc_hs_dsch_CommonSystemInformation = -1;  /* HS_DSCH_CommonSystemInformation */
static int hf_rrc_hs_dsch_PagingSystemInformation = -1;  /* HS_DSCH_PagingSystemInformation */
static int hf_rrc_tdd768_27 = -1;                 /* T_tdd768_24 */
static int hf_rrc_pusch_SysInfoList_SFN_03 = -1;  /* PUSCH_SysInfoList_SFN_VHCR */
static int hf_rrc_pdsch_SysInfoList_SFN_03 = -1;  /* PDSCH_SysInfoList_VHCR_r7 */
static int hf_rrc_prach_SystemInformationList_01 = -1;  /* PRACH_SystemInformationList_VHCR_r7 */
static int hf_rrc_tdd128_71 = -1;                 /* T_tdd128_68 */
static int hf_rrc_prach_SystemInformationList_02 = -1;  /* PRACH_SystemInformationList_LCR_v770ext */
static int hf_rrc_sccpch_SystemInformationList = -1;  /* SCCPCH_SystemInformationList_HCR_VHCR_r7 */
static int hf_rrc_sccpch_SystemInformation_MBMS_01 = -1;  /* T_sccpch_SystemInformation_MBMS_01 */
static int hf_rrc_mcchOnSCCPCHusedOnlyForMBMS_01 = -1;  /* SCCPCH_SystemInformation_MBMS_r7 */
static int hf_rrc_tDD_MBSFNInformation = -1;      /* TDD_MBSFNInformation */
static int hf_rrc_dummy_58 = -1;                  /* T_dummy_15 */
static int hf_rrc_modeSpecificInfo_152 = -1;      /* T_modeSpecificInfo_152 */
static int hf_rrc_fdd_193 = -1;                   /* T_fdd_187 */
static int hf_rrc_hs_dsch_DrxCellfach_info = -1;  /* HS_DSCH_DrxCellfach_info */
static int hf_rrc_tdd128_72 = -1;                 /* T_tdd128_69 */
static int hf_rrc_hs_dsch_CommonSysInfo = -1;     /* T_hs_dsch_CommonSysInfo */
static int hf_rrc_hs_dsch_CommonSystemInformation_01 = -1;  /* HS_DSCH_CommonSystemInformation_TDD128 */
static int hf_rrc_hs_dsch_PagingSystemInformation_01 = -1;  /* HS_DSCH_PagingSystemInformation_TDD128 */
static int hf_rrc_hs_dsch_DrxCellfach_info_01 = -1;  /* HS_DSCH_DrxCellfach_info_TDD128 */
static int hf_rrc_commonEDCHSystemInfo = -1;      /* CommonEDCHSystemInfo */
static int hf_rrc_tresetUsageIndicator = -1;      /* T_tresetUsageIndicator */
static int hf_rrc_commonEDCHSystemInfoFDD = -1;   /* CommonEDCHSystemInfoFDD */
static int hf_rrc_frequencyBandsIndicatorSupport = -1;  /* FrequencyBandsIndicatorSupport */
static int hf_rrc_frequencyBandIndicator3 = -1;   /* RadioFrequencyBandFDD3 */
static int hf_rrc_sysInfoType5_vb50ext = -1;      /* SysInfoType5_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_201 = -1;  /* T_nonCriticalExtensions_201 */
static int hf_rrc_sib22indicator = -1;            /* BOOLEAN */
static int hf_rrc_cellUpdateMessageOptimisedEncoding = -1;  /* T_cellUpdateMessageOptimisedEncoding */
static int hf_rrc_modeSpecificInfo_153 = -1;      /* T_modeSpecificInfo_153 */
static int hf_rrc_fdd_194 = -1;                   /* T_fdd_188 */
static int hf_rrc_dummy_59 = -1;                  /* CSICH_PowerOffset */
static int hf_rrc_tdd_143 = -1;                   /* T_tdd_135 */
static int hf_rrc_v4b0NonCriticalExtensions_20 = -1;  /* T_v4b0NonCriticalExtensions_20 */
static int hf_rrc_sysInfoType6_v4b0ext = -1;      /* SysInfoType6_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_29 = -1;  /* T_v590NonCriticalExtensions_29 */
static int hf_rrc_sysInfoType6_v590ext = -1;      /* SysInfoType6_v590ext_IEs */
static int hf_rrc_v650nonCriticalExtensions = -1;  /* T_v650nonCriticalExtensions */
static int hf_rrc_sysInfoType6_v650ext = -1;      /* SysInfoType6_v650ext_IEs */
static int hf_rrc_v690nonCriticalExtensions = -1;  /* T_v690nonCriticalExtensions */
static int hf_rrc_sysInfoType6_v690ext = -1;      /* SysInfoType6_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_41 = -1;  /* T_v770NonCriticalExtensions_41 */
static int hf_rrc_sysInfoType6_v770ext = -1;      /* SysInfoType6_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_20 = -1;  /* T_va40NonCriticalExtensions_19 */
static int hf_rrc_sysInfoType6_va40ext = -1;      /* SysInfoType6_va40ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_03 = -1;  /* T_va80NonCriticalExtensions_03 */
static int hf_rrc_sysInfoType6_va80ext = -1;      /* SysInfoType6_va80ext_IEs */
static int hf_rrc_nonCriticalExtensions_202 = -1;  /* T_nonCriticalExtensions_202 */
static int hf_rrc_tdd128SpecificInfo_01 = -1;     /* T_tdd128SpecificInfo_01 */
static int hf_rrc_hcr_r5_SpecificInfo_01 = -1;    /* T_hcr_r5_SpecificInfo_01 */
static int hf_rrc_tdd768SpecificInfo = -1;        /* T_tdd768SpecificInfo */
static int hf_rrc_modeSpecificInfo_154 = -1;      /* T_modeSpecificInfo_154 */
static int hf_rrc_fdd_195 = -1;                   /* T_fdd_189 */
static int hf_rrc_ul_Interference = -1;           /* UL_Interference */
static int hf_rrc_prach_Information_SIB5_List = -1;  /* DynamicPersistenceLevelList */
static int hf_rrc_prach_Information_SIB6_List = -1;  /* DynamicPersistenceLevelList */
static int hf_rrc_expirationTimeFactor = -1;      /* ExpirationTimeFactor */
static int hf_rrc_nonCriticalExtensions_203 = -1;  /* T_nonCriticalExtensions_203 */
static int hf_rrc_dummy1_07 = -1;                 /* CPCH_Parameters */
static int hf_rrc_dummy2_15 = -1;                 /* CPCH_SetInfoList */
static int hf_rrc_dummy3_04 = -1;                 /* CSICH_PowerOffset */
static int hf_rrc_nonCriticalExtensions_204 = -1;  /* T_nonCriticalExtensions_204 */
static int hf_rrc_dummy_60 = -1;                  /* CPCH_PersistenceLevelsList */
static int hf_rrc_nonCriticalExtensions_205 = -1;  /* T_nonCriticalExtensions_205 */
static int hf_rrc_dummy_61 = -1;                  /* DRAC_SysInfoList */
static int hf_rrc_nonCriticalExtensions_206 = -1;  /* T_nonCriticalExtensions_206 */
static int hf_rrc_sib12indicator = -1;            /* BOOLEAN */
static int hf_rrc_fach_MeasurementOccasionInfo = -1;  /* FACH_MeasurementOccasionInfo */
static int hf_rrc_measurementControlSysInfo = -1;  /* MeasurementControlSysInfo */
static int hf_rrc_v4b0NonCriticalExtensions_21 = -1;  /* T_v4b0NonCriticalExtensions_21 */
static int hf_rrc_sysInfoType11_v4b0ext = -1;     /* SysInfoType11_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension_02 = -1;  /* T_v590NonCriticalExtension_02 */
static int hf_rrc_sysInfoType11_v590ext = -1;     /* SysInfoType11_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_50 = -1;  /* T_v690NonCriticalExtensions_50 */
static int hf_rrc_sysInfoType11_v690ext = -1;     /* SysInfoType11_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_17 = -1;  /* T_v6b0NonCriticalExtensions_16 */
static int hf_rrc_sysInfoType11_v6b0ext = -1;     /* SysInfoType11_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_42 = -1;  /* T_v770NonCriticalExtensions_42 */
static int hf_rrc_sysInfoType11_v770ext = -1;     /* SysInfoType11_v770ext_IEs */
static int hf_rrc_v7b0NonCriticalExtensions_02 = -1;  /* T_v7b0NonCriticalExtensions_02 */
static int hf_rrc_sysInfoType11_v7b0ext = -1;     /* SysInfoType11_v7b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_28 = -1;  /* T_v860NonCriticalExtensions_28 */
static int hf_rrc_sysInfoType11_v860ext = -1;     /* SysInfoType11_v860ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_04 = -1;  /* T_va80NonCriticalExtensions_04 */
static int hf_rrc_sysInfoType11_va80ext = -1;     /* SysInfoType11_va80ext_IEs */
static int hf_rrc_nonCriticalExtensions_207 = -1;  /* T_nonCriticalExtensions_207 */
static int hf_rrc_fach_MeasurementOccasionInfo_LCR_Ext = -1;  /* FACH_MeasurementOccasionInfo_LCR_r4_ext */
static int hf_rrc_measurementControlSysInfo_LCR = -1;  /* MeasurementControlSysInfo_LCR_r4_ext */
static int hf_rrc_newIntraFrequencyCellInfoList_v590ext = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newIntraFrequencyCellInfoList_v590ext_item = -1;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoList_v590ext = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoList_v590ext_item = -1;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoList_v590ext = -1;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoList_v590ext_item = -1;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_intraFreqEventCriteriaList_v590ext = -1;  /* Intra_FreqEventCriteriaList_v590ext */
static int hf_rrc_dummy_62 = -1;                  /* Dummy_InterFreqRACHReportingInfo */
static int hf_rrc_interFreqRACHReportingInfo = -1;  /* InterFreqRACHReportingInfo */
static int hf_rrc_mbsfnFrequencyList = -1;        /* MBSFNFrequencyList */
static int hf_rrc_mbsfnFrequencyList_01 = -1;     /* MBSFNFrequencyList_v860ext */
static int hf_rrc_multipleFrequencyInfoListFDD = -1;  /* MultipleFrequencyInfoListFDD */
static int hf_rrc_measurementControlSysInfo_01 = -1;  /* MeasurementControlSysInfoExtension */
static int hf_rrc_measurementControlSysInfo_LCR_01 = -1;  /* MeasurementControlSysInfoExtension_LCR_r4 */
static int hf_rrc_measurementControlSysInfoExtensionAddon_r5 = -1;  /* MeasurementControlSysInfoExtensionAddon_r5 */
static int hf_rrc_v7b0NonCriticalExtensions_03 = -1;  /* T_v7b0NonCriticalExtensions_03 */
static int hf_rrc_sysInfoType11bis_v7b0ext = -1;  /* SysInfoType11bis_v7b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_29 = -1;  /* T_v860NonCriticalExtensions_29 */
static int hf_rrc_sysInfoType11bis_v860ext = -1;  /* SysInfoType11bis_v860ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_05 = -1;  /* T_va80NonCriticalExtensions_05 */
static int hf_rrc_sysInfoType11bis_va80ext = -1;  /* SysInfoType11bis_va80ext_IEs */
static int hf_rrc_nonCriticalExtensions_208 = -1;  /* T_nonCriticalExtensions_208 */
static int hf_rrc_csg_DedicatedFrequencyInfoList = -1;  /* CSG_DedicatedFrequencyInfoList */
static int hf_rrc_v4b0NonCriticalExtensions_22 = -1;  /* T_v4b0NonCriticalExtensions_22 */
static int hf_rrc_sysInfoType12_v4b0ext = -1;     /* SysInfoType12_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension_03 = -1;  /* T_v590NonCriticalExtension_03 */
static int hf_rrc_sysInfoType12_v590ext = -1;     /* SysInfoType12_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_51 = -1;  /* T_v690NonCriticalExtensions_51 */
static int hf_rrc_sysInfoType12_v690ext = -1;     /* SysInfoType12_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_18 = -1;  /* T_v6b0NonCriticalExtensions_17 */
static int hf_rrc_sysInfoType12_v6b0ext = -1;     /* SysInfoType12_v6b0ext_IEs */
static int hf_rrc_v7b0NonCriticalExtensions_04 = -1;  /* T_v7b0NonCriticalExtensions_04 */
static int hf_rrc_sysInfoType12_v7b0ext = -1;     /* SysInfoType12_v7b0ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_06 = -1;  /* T_va80NonCriticalExtensions_06 */
static int hf_rrc_sysInfoType12_va80ext = -1;     /* SysInfoType12_va80ext_IEs */
static int hf_rrc_nonCriticalExtensions_209 = -1;  /* T_nonCriticalExtensions_209 */
static int hf_rrc_v3a0NonCriticalExtensions_13 = -1;  /* T_v3a0NonCriticalExtensions_13 */
static int hf_rrc_sysInfoType13_v3a0ext = -1;     /* SysInfoType13_v3a0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_23 = -1;  /* T_v4b0NonCriticalExtensions_23 */
static int hf_rrc_sysInfoType13_v4b0ext = -1;     /* SysInfoType13_v4b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_43 = -1;  /* T_v770NonCriticalExtensions_43 */
static int hf_rrc_sysInfoType13_v770ext = -1;     /* SysInfoType13_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_210 = -1;  /* T_nonCriticalExtensions_210 */
static int hf_rrc_capabilityUpdateRequirement_r4Ext = -1;  /* CapabilityUpdateRequirement_r4_ext */
static int hf_rrc_ansi_41_RAND_Information = -1;  /* ANSI_41_RAND_Information */
static int hf_rrc_nonCriticalExtensions_211 = -1;  /* T_nonCriticalExtensions_211 */
static int hf_rrc_ansi_41_UserZoneID_Information = -1;  /* ANSI_41_UserZoneID_Information */
static int hf_rrc_nonCriticalExtensions_212 = -1;  /* T_nonCriticalExtensions_212 */
static int hf_rrc_ansi_41_PrivateNeighbourListInfo = -1;  /* ANSI_41_PrivateNeighbourListInfo */
static int hf_rrc_nonCriticalExtensions_213 = -1;  /* T_nonCriticalExtensions_213 */
static int hf_rrc_ansi_41_GlobalServiceRedirectInfo = -1;  /* ANSI_41_GlobalServiceRedirectInfo */
static int hf_rrc_nonCriticalExtensions_214 = -1;  /* T_nonCriticalExtensions_214 */
static int hf_rrc_nonCriticalExtensions_215 = -1;  /* T_nonCriticalExtensions_215 */
static int hf_rrc_ue_positioning_GPS_CipherParameters = -1;  /* UE_Positioning_CipherParameters */
static int hf_rrc_v4b0NonCriticalExtensions_24 = -1;  /* T_v4b0NonCriticalExtensions_24 */
static int hf_rrc_sysInfoType15_v4b0ext = -1;     /* SysInfoType15_v4b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_44 = -1;  /* T_v770NonCriticalExtensions_44 */
static int hf_rrc_sysInfoType15_v770ext = -1;     /* SysInfoType15_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_21 = -1;  /* T_va40NonCriticalExtensions_20 */
static int hf_rrc_sysInfoType15_va40ext = -1;     /* SysInfoType15_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_216 = -1;  /* T_nonCriticalExtensions_216 */
static int hf_rrc_up_Ipdl_Parameters_TDD = -1;    /* UE_Positioning_IPDL_Parameters_TDD_r4_ext */
static int hf_rrc_ue_Positioning_GPS_ReferenceTime = -1;  /* UE_Positioning_GPS_ReferenceTime_v770ext */
static int hf_rrc_ue_Positioning_GPS_ReferenceTime_01 = -1;  /* UE_Positioning_GPS_ReferenceTime_va40ext */
static int hf_rrc_ue_positioning_GANSS_ReferencePosition = -1;  /* ReferenceLocationGANSS */
static int hf_rrc_ue_positioning_GANSS_IonosphericModel = -1;  /* UE_Positioning_GANSS_IonosphericModel */
static int hf_rrc_v860NonCriticalExtensions_30 = -1;  /* T_v860NonCriticalExtensions_30 */
static int hf_rrc_sysInfoType15bis_v860ext = -1;  /* SysInfoType15bis_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_22 = -1;  /* T_va40NonCriticalExtensions_21 */
static int hf_rrc_sysInfoType15bis_va40ext = -1;  /* SysInfoType15bis_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_217 = -1;  /* T_nonCriticalExtensions_217 */
static int hf_rrc_ue_Positioning_GANSS_AddIonoModel = -1;  /* UE_Positioning_GANSS_AddIonoModel */
static int hf_rrc_ue_Positioning_GANSS_EarthOrientationPara = -1;  /* UE_Positioning_GANSS_EarthOrientPara */
static int hf_rrc_v920NonCriticalExtensions_04 = -1;  /* T_v920NonCriticalExtensions_04 */
static int hf_rrc_sysInfoType15_1_v920ext = -1;   /* SysInfoType15_1_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_218 = -1;  /* T_nonCriticalExtensions_218 */
static int hf_rrc_ue_positioning_GANSS_DGANSS_Corrections = -1;  /* UE_Positioning_DGANSSCorrections */
static int hf_rrc_v920NonCriticalExtensions_05 = -1;  /* T_v920NonCriticalExtensions_05 */
static int hf_rrc_sysInfoType15_1bis_v920ext = -1;  /* SysInfoType15_1bis_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_219 = -1;  /* T_nonCriticalExtensions_219 */
static int hf_rrc_ue_positioning_GANSS_DGANSS_Corrections_01 = -1;  /* UE_Positioning_DGANSSCorrections_v920ext */
static int hf_rrc_transmissionTOW = -1;           /* GPS_TOW_1sec */
static int hf_rrc_nonCriticalExtensions_220 = -1;  /* T_nonCriticalExtensions_220 */
static int hf_rrc_ue_positioning_GANSS_navigationModel = -1;  /* UE_Positioning_GANSS_NavigationModel */
static int hf_rrc_nonCriticalExtensions_221 = -1;  /* T_nonCriticalExtensions_221 */
static int hf_rrc_ue_positioning_GANSS_AddNavigationModels = -1;  /* UE_Positioning_GANSS_AddNavigationModels */
static int hf_rrc_nonCriticalExtensions_222 = -1;  /* T_nonCriticalExtensions_222 */
static int hf_rrc_satMask = -1;                   /* BIT_STRING_SIZE_1_32 */
static int hf_rrc_lsbTOW = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_va40NonCriticalExtensions_23 = -1;  /* T_va40NonCriticalExtensions_22 */
static int hf_rrc_sysInfoType15_3_va40ext = -1;   /* SysInfoType15_3_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_223 = -1;  /* T_nonCriticalExtensions_223 */
static int hf_rrc_ue_positioning_GANSS_Almanac = -1;  /* UE_Positioning_GANSS_Almanac */
static int hf_rrc_ue_positioning_GANSS_TimeModels = -1;  /* UE_Positioning_GANSS_TimeModels */
static int hf_rrc_ue_positioning_GANSS_UTC_Model = -1;  /* UE_Positioning_GANSS_UTCModel */
static int hf_rrc_v860NonCriticalExtensions_31 = -1;  /* T_v860NonCriticalExtensions_31 */
static int hf_rrc_sysInfoType15_3bis_v860ext = -1;  /* SysInfoType15_3bis_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_24 = -1;  /* T_va40NonCriticalExtensions_23 */
static int hf_rrc_sysInfoType15_3bis_va40ext = -1;  /* SysInfoType15_3bis_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_224 = -1;  /* T_nonCriticalExtensions_224 */
static int hf_rrc_ue_Positioning_GANSS_Almanac = -1;  /* UE_Positioning_GANSS_Almanac_v860ext */
static int hf_rrc_ue_Positioning_GANSS_AddUTCModels = -1;  /* UE_Positioning_GANSS_AddUTCModels */
static int hf_rrc_ue_Positioning_GANSS_AuxiliaryInfo = -1;  /* UE_Positioning_GANSS_AuxiliaryInfo */
static int hf_rrc_ue_Positioning_GANSS_Almanac_01 = -1;  /* UE_Positioning_GANSS_Almanac_va40ext */
static int hf_rrc_ue_positioning_GANSS_TimeModels_01 = -1;  /* UE_Positioning_GANSS_TimeModels_va40ext */
static int hf_rrc_ue_positioning_OTDOA_CipherParameters = -1;  /* UE_Positioning_CipherParameters */
static int hf_rrc_v3a0NonCriticalExtensions_14 = -1;  /* T_v3a0NonCriticalExtensions_14 */
static int hf_rrc_sysInfoType15_4_v3a0ext = -1;   /* SysInfoType15_4_v3a0ext */
static int hf_rrc_v4b0NonCriticalExtensions_25 = -1;  /* T_v4b0NonCriticalExtensions_25 */
static int hf_rrc_sysInfoType15_4_v4b0ext = -1;   /* SysInfoType15_4_v4b0ext */
static int hf_rrc_nonCriticalExtensions_225 = -1;  /* T_nonCriticalExtensions_225 */
static int hf_rrc_v3a0NonCriticalExtensions_15 = -1;  /* T_v3a0NonCriticalExtensions_15 */
static int hf_rrc_sysInfoType15_5_v3a0ext = -1;   /* SysInfoType15_5_v3a0ext */
static int hf_rrc_v770NonCriticalExtensions_45 = -1;  /* T_v770NonCriticalExtensions_45 */
static int hf_rrc_sysInfoType15_5_v770ext = -1;   /* SysInfoType15_5_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_226 = -1;  /* T_nonCriticalExtensions_226 */
static int hf_rrc_ue_positioning_GANSS_TOD = -1;  /* INTEGER_0_86399 */
static int hf_rrc_ue_positioning_GANSS_ReferenceMeasurementInformation = -1;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo */
static int hf_rrc_va40NonCriticalExtensions_25 = -1;  /* T_va40NonCriticalExtensions_24 */
static int hf_rrc_sysInfoType15_6_va40ext = -1;   /* SysInfoType15_6_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_227 = -1;  /* T_nonCriticalExtensions_227 */
static int hf_rrc_ue_positioning_GANSS_ReferenceMeasurementInformation_01 = -1;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_va40ext */
static int hf_rrc_ue_positioning_GANSS_DataBitAssistance = -1;  /* UE_Positioning_GANSS_Data_Bit_Assistance */
static int hf_rrc_nonCriticalExtensions_228 = -1;  /* T_nonCriticalExtensions_228 */
static int hf_rrc_ue_positioning_GANSS_DataCipheringInfo = -1;  /* UE_Positioning_CipherParameters */
static int hf_rrc_ue_positioning_GANSS_realTimeIntegrity = -1;  /* UE_Positioning_GANSS_RealTimeIntegrity */
static int hf_rrc_nonCriticalExtensions_229 = -1;  /* T_nonCriticalExtensions_229 */
static int hf_rrc_preDefinedRadioConfiguration = -1;  /* PreDefRadioConfiguration */
static int hf_rrc_v770NonCriticalExtensions_46 = -1;  /* T_v770NonCriticalExtensions_46 */
static int hf_rrc_sysInfoType16_v770ext = -1;     /* SysInfoType16_v770ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_06 = -1;  /* T_v920NonCriticalExtensions_06 */
static int hf_rrc_sysInfoType16_v920ext = -1;     /* SysInfoType16_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_230 = -1;  /* T_nonCriticalExtensions_230 */
static int hf_rrc_preDefinedRadioConfiguration_01 = -1;  /* PreDefRadioConfiguration_v770ext */
static int hf_rrc_preDefinedRadioConfiguration_02 = -1;  /* PreDefRadioConfiguration_v920ext */
static int hf_rrc_pusch_SysInfoList = -1;         /* PUSCH_SysInfoList */
static int hf_rrc_pdsch_SysInfoList = -1;         /* PDSCH_SysInfoList */
static int hf_rrc_v4b0NonCriticalExtensions_26 = -1;  /* T_v4b0NonCriticalExtensions_26 */
static int hf_rrc_sysInfoType17_v4b0ext = -1;     /* SysInfoType17_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_30 = -1;  /* T_v590NonCriticalExtensions_30 */
static int hf_rrc_sysInfoType17_v590ext = -1;     /* SysInfoType17_v590ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_47 = -1;  /* T_v770NonCriticalExtensions_47 */
static int hf_rrc_sysInfoType17_v770ext = -1;     /* SysInfoType17_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_231 = -1;  /* T_nonCriticalExtensions_231 */
static int hf_rrc_tdd128SpecificInfo_02 = -1;     /* T_tdd128SpecificInfo_02 */
static int hf_rrc_pusch_SysInfoList_01 = -1;      /* PUSCH_SysInfoList_LCR_r4 */
static int hf_rrc_pdsch_SysInfoList_01 = -1;      /* PDSCH_SysInfoList_LCR_r4 */
static int hf_rrc_hcr_r5_SpecificInfo_02 = -1;    /* T_hcr_r5_SpecificInfo_02 */
static int hf_rrc_pusch_SysInfoList_02 = -1;      /* PUSCH_SysInfoList_HCR_r5 */
static int hf_rrc_pdsch_SysInfoList_02 = -1;      /* PDSCH_SysInfoList_HCR_r5 */
static int hf_rrc_tdd768SpecificInfo_01 = -1;     /* T_tdd768SpecificInfo_01 */
static int hf_rrc_idleModePLMNIdentities = -1;    /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_connectedModePLMNIdentities = -1;  /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_v6b0NonCriticalExtensions_19 = -1;  /* T_v6b0NonCriticalExtensions_18 */
static int hf_rrc_sysInfoType18_v6b0ext = -1;     /* SysInfoType18_v6b0ext */
static int hf_rrc_v860NonCriticalExtensions_32 = -1;  /* T_v860NonCriticalExtensions_32 */
static int hf_rrc_sysInfoType18_v860ext = -1;     /* SysInfoType18_v860ext */
static int hf_rrc_nonCriticalExtensions_232 = -1;  /* T_nonCriticalExtensions_232 */
static int hf_rrc_idleModePLMNIdentitiesSIB11bis = -1;  /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_connectedModePLMNIdentitiesSIB11bis = -1;  /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_idleModePLMNIdentities_01 = -1;  /* PLMNIdentitiesOfNeighbourCells_v860ext */
static int hf_rrc_connectedModePLMNIdentities_01 = -1;  /* PLMNIdentitiesOfNeighbourCells_v860ext */
static int hf_rrc_utra_PriorityInfoList = -1;     /* UTRA_PriorityInfoList */
static int hf_rrc_gsm_PriorityInfoList = -1;      /* GSM_PriorityInfoList */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList = -1;  /* EUTRA_FrequencyAndPriorityInfoList */
static int hf_rrc_v920NonCriticalExtensions_07 = -1;  /* T_v920NonCriticalExtensions_07 */
static int hf_rrc_sysInfoType19_v920ext = -1;     /* SysInfoType19_v920ext */
static int hf_rrc_va80NonCriticalExtensions_07 = -1;  /* T_va80NonCriticalExtensions_07 */
static int hf_rrc_sysInfoType19_va80ext = -1;     /* SysInfoType19_va80ext */
static int hf_rrc_vb30NonCriticalExtensions = -1;  /* T_vb30NonCriticalExtensions */
static int hf_rrc_sysInfoType19_vb30ext = -1;     /* SysInfoType19_vb30ext */
static int hf_rrc_vb50NonCriticalExtensions_25 = -1;  /* T_vb50NonCriticalExtensions_24 */
static int hf_rrc_sysInfoType19_vb50ext = -1;     /* SysInfoType19_vb50ext */
static int hf_rrc_nonCriticalExtensions_233 = -1;  /* T_nonCriticalExtensions_233 */
static int hf_rrc_utra_PriorityInfoList_v920ext = -1;  /* UTRA_PriorityInfoList_v920ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList_v920ext = -1;  /* EUTRA_FrequencyAndPriorityInfoList_v920ext */
static int hf_rrc_multipleEutraFrequencyInfoList = -1;  /* MultipleEUTRAFrequencyInfoList */
static int hf_rrc_cell_fach_meas_ind = -1;        /* T_cell_fach_meas_ind */
static int hf_rrc_gsmTreselectionScalingFactor = -1;  /* TreselectionScalingFactor2 */
static int hf_rrc_eutraTreselectionScalingFactor = -1;  /* TreselectionScalingFactor2 */
static int hf_rrc_numberOfApplicableEARFCN = -1;  /* INTEGER_0_7 */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList_vb50ext = -1;  /* EUTRA_FrequencyAndPriorityInfoList_vb50ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoExtensionList = -1;  /* EUTRA_FrequencyAndPriorityInfoExtensionList */
static int hf_rrc_multipleEutraFrequencyInfoExtensionList = -1;  /* MultipleEUTRAFrequencyInfoExtensionList */
static int hf_rrc_eutra_FrequencyRACHReportingInfo = -1;  /* EUTRA_FrequencyRACHReportingInfo */
static int hf_rrc_hNBName = -1;                   /* HNBName */
static int hf_rrc_nonCriticalExtensions_234 = -1;  /* T_nonCriticalExtensions_234 */
static int hf_rrc_eab_Parameters = -1;            /* EAB_Parameters */
static int hf_rrc_nonCriticalExtensions_235 = -1;  /* T_nonCriticalExtensions_235 */
static int hf_rrc_prach_PreambleForEnhancedUplinkListType1Ext = -1;  /* PRACH_PreambleForEnhancedUplinkExtList */
static int hf_rrc_prach_PreambleForEnhancedUplinkListType2Ext = -1;  /* PRACH_PreambleForEnhancedUplinkExtList */
static int hf_rrc_prach_PreambleForEnhancedUplinkListType3Ext = -1;  /* PRACH_PreambleForEnhancedUplinkExtList */
static int hf_rrc_concurrent_Deployment_2ms_10ms_TTI = -1;  /* Concurrent_Deployment_2ms_10ms_TTI */
static int hf_rrc_nodeB_Trigger_HS_DPCCH_Transmission = -1;  /* NodeB_Trigger_HS_DPCCH_Transmission */
static int hf_rrc_fallback_R99_PRACH_info = -1;   /* Fallback_R99_PRACH_info_IEs */
static int hf_rrc_commonEDCHResourceConfigInfoListExt = -1;  /* CommonEDCHResourceConfigInfoListExt */
static int hf_rrc_hs_dsch_DrxCellfach_SecondDrx_info = -1;  /* HS_DSCH_DrxCellfach_SecondDrx_info */
static int hf_rrc_nonCriticalExtensions_236 = -1;  /* T_nonCriticalExtensions_236 */
static int hf_rrc_sib_ReferenceList = -1;         /* SIB_ReferenceList */
static int hf_rrc_v6b0NonCriticalExtensions_20 = -1;  /* T_v6b0NonCriticalExtensions_19 */
static int hf_rrc_sysInfoTypeSB1_v6b0ext = -1;    /* SysInfoTypeSB1_v6b0ext */
static int hf_rrc_v860NonCriticalExtensions_33 = -1;  /* T_v860NonCriticalExtensions_33 */
static int hf_rrc_sysInfoTypeSB1_v860ext = -1;    /* SysInfoTypeSB1_v860ext */
static int hf_rrc_nonCriticalExtensions_237 = -1;  /* T_nonCriticalExtensions_237 */
static int hf_rrc_v6b0NonCriticalExtensions_21 = -1;  /* T_v6b0NonCriticalExtensions_20 */
static int hf_rrc_sysInfoTypeSB2_v6b0ext = -1;    /* SysInfoTypeSB2_v6b0ext */
static int hf_rrc_v860NonCriticalExtensions_34 = -1;  /* T_v860NonCriticalExtensions_34 */
static int hf_rrc_sysInfoTypeSB2_v860ext = -1;    /* SysInfoTypeSB2_v860ext */
static int hf_rrc_nonCriticalExtensions_238 = -1;  /* T_nonCriticalExtensions_238 */
static int hf_rrc_TDD_UMTS_Frequency_List_item = -1;  /* FrequencyInfoTDD */
static int hf_rrc_ue_InactivityPeriod = -1;       /* INTEGER_1_120 */
static int hf_rrc_ul_dataVolumeHistory = -1;      /* DataVolumeHistory */
static int hf_rrc_dl_dataVolumeHistory = -1;      /* DataVolumeHistory */
static int hf_rrc_none = -1;                      /* NULL */
static int hf_rrc_cellValueTag = -1;              /* CellValueTag */
static int hf_rrc_plmn_ValueTag = -1;             /* PLMN_ValueTag */
static int hf_rrc_sIBOccurrenceIdentityAndValueTag = -1;  /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_commonRBIdentity = -1;          /* MBMS_CommonRBIdentity */
static int hf_rrc_rlc_Info_05 = -1;               /* RLC_Info_MTCH_r6 */
static int hf_rrc_MBMS_CommonRBInformationList_r6_item = -1;  /* MBMS_CommonRBInformation_r6 */
static int hf_rrc_countingForUraPCH = -1;         /* BOOLEAN */
static int hf_rrc_countingForCellPCH = -1;        /* BOOLEAN */
static int hf_rrc_countingForCellFACH = -1;       /* BOOLEAN */
static int hf_rrc_sccpchIdentity = -1;            /* MBMS_SCCPCHIdentity */
static int hf_rrc_secondaryCCPCH_Info_03 = -1;    /* MBMS_CommonPhyChIdentity */
static int hf_rrc_softComb_TimingOffset = -1;     /* MBMS_SoftComb_TimingOffset */
static int hf_rrc_transpCh_InfoCommonForAllTrCh = -1;  /* MBMS_CommonCCTrChIdentity */
static int hf_rrc_transpCHInformation = -1;       /* MBMS_TrCHInformation_CurrList */
static int hf_rrc_MBMS_CurrentCell_SCCPCHList_r6_item = -1;  /* MBMS_CurrentCell_SCCPCH_r6 */
static int hf_rrc_MBMS_FACHCarryingMTCH_List_item = -1;  /* TransportFormatSet */
static int hf_rrc_cycleOffset = -1;               /* INTEGER_0_7 */
static int hf_rrc_mtch_L1CombiningPeriodList = -1;  /* T_mtch_L1CombiningPeriodList */
static int hf_rrc_mtch_L1CombiningPeriodList_item = -1;  /* T_mtch_L1CombiningPeriodList_item */
static int hf_rrc_periodStart = -1;               /* INTEGER_0_7 */
static int hf_rrc_periodDuration = -1;            /* INTEGER_1_8 */
static int hf_rrc_cycleOffset_01 = -1;            /* INTEGER_0_15 */
static int hf_rrc_mtch_L1CombiningPeriodList_01 = -1;  /* T_mtch_L1CombiningPeriodList_01 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_01 = -1;  /* T_mtch_L1CombiningPeriodList_item_01 */
static int hf_rrc_periodStart_01 = -1;            /* INTEGER_0_15 */
static int hf_rrc_periodDuration_01 = -1;         /* INTEGER_1_16 */
static int hf_rrc_cycleOffset_02 = -1;            /* INTEGER_0_31 */
static int hf_rrc_mtch_L1CombiningPeriodList_02 = -1;  /* T_mtch_L1CombiningPeriodList_02 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_02 = -1;  /* T_mtch_L1CombiningPeriodList_item_02 */
static int hf_rrc_periodStart_02 = -1;            /* INTEGER_0_31 */
static int hf_rrc_periodDuration_02 = -1;         /* INTEGER_1_32 */
static int hf_rrc_cycleOffset_03 = -1;            /* INTEGER_0_63 */
static int hf_rrc_mtch_L1CombiningPeriodList_03 = -1;  /* T_mtch_L1CombiningPeriodList_03 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_03 = -1;  /* T_mtch_L1CombiningPeriodList_item_03 */
static int hf_rrc_periodStart_03 = -1;            /* INTEGER_0_63 */
static int hf_rrc_periodDuration_03 = -1;         /* INTEGER_1_64 */
static int hf_rrc_cycleOffset_04 = -1;            /* INTEGER_0_127 */
static int hf_rrc_mtch_L1CombiningPeriodList_04 = -1;  /* T_mtch_L1CombiningPeriodList_04 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_04 = -1;  /* T_mtch_L1CombiningPeriodList_item_04 */
static int hf_rrc_periodStart_04 = -1;            /* INTEGER_0_127 */
static int hf_rrc_periodDuration_04 = -1;         /* INTEGER_1_128 */
static int hf_rrc_cycleOffset_05 = -1;            /* INTEGER_0_255 */
static int hf_rrc_mtch_L1CombiningPeriodList_05 = -1;  /* T_mtch_L1CombiningPeriodList_05 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_05 = -1;  /* T_mtch_L1CombiningPeriodList_item_05 */
static int hf_rrc_periodStart_05 = -1;            /* INTEGER_0_255 */
static int hf_rrc_periodDuration_05 = -1;         /* INTEGER_1_256 */
static int hf_rrc_cycleLength_32 = -1;            /* MBMS_L1CombiningSchedule_32 */
static int hf_rrc_cycleLength_64 = -1;            /* MBMS_L1CombiningSchedule_64 */
static int hf_rrc_cycleLength_128 = -1;           /* MBMS_L1CombiningSchedule_128 */
static int hf_rrc_cycleLength_256 = -1;           /* MBMS_L1CombiningSchedule_256 */
static int hf_rrc_cycleLength_512 = -1;           /* MBMS_L1CombiningSchedule_512 */
static int hf_rrc_cycleLength_1024 = -1;          /* MBMS_L1CombiningSchedule_1024 */
static int hf_rrc_sameAsCurrent = -1;             /* T_sameAsCurrent */
static int hf_rrc_currentCell_SCCPCH = -1;        /* MBMS_SCCPCHIdentity */
static int hf_rrc_msch_ConfigurationInfo = -1;    /* MBMS_MSCH_ConfigurationInfo_r6 */
static int hf_rrc_different = -1;                 /* T_different */
static int hf_rrc_transpCHInformation_01 = -1;    /* MBMS_TrCHInformation_NeighbList */
static int hf_rrc_accessInfoPeriodCoefficient = -1;  /* INTEGER_0_3 */
static int hf_rrc_repetitionPeriodCoefficient = -1;  /* INTEGER_0_3 */
static int hf_rrc_modificationPeriodCoefficient = -1;  /* INTEGER_7_10 */
static int hf_rrc_rlc_Info_06 = -1;               /* RLC_Info_MCCH_r6 */
static int hf_rrc_tctf_Presence = -1;             /* MBMS_TCTF_Presence */
static int hf_rrc_michPowerOffset = -1;           /* MBMS_MICHPowerOffset */
static int hf_rrc_mode_03 = -1;                   /* T_mode_03 */
static int hf_rrc_fdd_196 = -1;                   /* T_fdd_190 */
static int hf_rrc_ni_CountPerFrame = -1;          /* MBMS_NI_CountPerFrame */
static int hf_rrc_tdd384_49 = -1;                 /* T_tdd384_44 */
static int hf_rrc_repetitionPeriodLengthOffset_01 = -1;  /* RepPerLengthOffset_MICH */
static int hf_rrc_mbmsNotificationIndLength = -1;  /* MBMS_MICHNotificationIndLength */
static int hf_rrc_tdd128_73 = -1;                 /* T_tdd128_70 */
static int hf_rrc_channelisationCodeList_02 = -1;  /* SEQUENCE_SIZE_1_2_OF_DL_TS_ChannelisationCode */
static int hf_rrc_channelisationCodeList_item = -1;  /* DL_TS_ChannelisationCode */
static int hf_rrc_mode_04 = -1;                   /* T_mode_04 */
static int hf_rrc_tdd384_50 = -1;                 /* T_tdd384_45 */
static int hf_rrc_tdd768_28 = -1;                 /* T_tdd768_25 */
static int hf_rrc_midambleShiftAndBurstType_06 = -1;  /* MidambleShiftAndBurstType_VHCR */
static int hf_rrc_tdd128_74 = -1;                 /* T_tdd128_71 */
static int hf_rrc_mode_05 = -1;                   /* T_mode_05 */
static int hf_rrc_imb384 = -1;                    /* T_imb384 */
static int hf_rrc_ni_CountPerFrame_01 = -1;       /* MBMS_NI_CountPerFrame_IMB384 */
static int hf_rrc_mbms_TransmissionIdentity = -1;  /* MBMS_TransmissionIdentity */
static int hf_rrc_mbms_RequiredUEAction = -1;     /* MBMS_RequiredUEAction_Mod */
static int hf_rrc_mbms_PreferredFrequency = -1;   /* T_mbms_PreferredFrequency */
static int hf_rrc_mcch = -1;                      /* MBMS_PFLIndex */
static int hf_rrc_dcch = -1;                      /* MBMS_PFLInfo */
static int hf_rrc_dummy_63 = -1;                  /* T_dummy_16 */
static int hf_rrc_continueMCCHReading = -1;       /* BOOLEAN */
static int hf_rrc_MBMS_ModifedServiceList_r6_item = -1;  /* MBMS_ModifedService_r6 */
static int hf_rrc_mbsfnClusterFrequency = -1;     /* MBSFN_ClusterFrequency_r7 */
static int hf_rrc_rbReleaseCause = -1;            /* MBMS_PTM_RBReleaseCause_LCR_r7 */
static int hf_rrc_MBMS_ModifiedServiceList_v770ext_item = -1;  /* MBMS_ModifiedService_v770ext */
static int hf_rrc_MBMS_ModifiedServiceList_LCR_v7c0ext_item = -1;  /* MBMS_ModifiedService_LCR_v7c0ext */
static int hf_rrc_mschShedulingInfo = -1;         /* MBMS_MSCHSchedulingInfo */
static int hf_rrc_rlc_Info_07 = -1;               /* RLC_Info_MSCH_r6 */
static int hf_rrc_schedulingPeriod_32_Offset = -1;  /* INTEGER_0_31 */
static int hf_rrc_schedulingPeriod_64_Offset = -1;  /* INTEGER_0_63 */
static int hf_rrc_schedulingPeriod_128_Offset = -1;  /* INTEGER_0_127 */
static int hf_rrc_schedulingPeriod_256_Offset = -1;  /* INTEGER_0_255 */
static int hf_rrc_schedulingPeriod_512_Offset = -1;  /* INTEGER_0_511 */
static int hf_rrc_schedulingPeriod_1024_Offset = -1;  /* INTEGER_0_1023 */
static int hf_rrc_secondaryCCPCHPwrOffsetDiff = -1;  /* MBMS_SCCPCHPwrOffsetDiff */
static int hf_rrc_layer1Combining = -1;           /* T_layer1Combining */
static int hf_rrc_fdd_197 = -1;                   /* T_fdd_191 */
static int hf_rrc_mbms_L1CombiningTransmTimeDiff = -1;  /* MBMS_L1CombiningTransmTimeDiff */
static int hf_rrc_mbms_L1CombiningSchedule = -1;  /* MBMS_L1CombiningSchedule */
static int hf_rrc_mbms_L23Configuration = -1;     /* MBMS_L23Configuration */
static int hf_rrc_secondaryCCPCH_InfoDiff = -1;   /* SecondaryCCPCHInfoDiff_MBMS */
static int hf_rrc_layer1Combining_01 = -1;        /* T_layer1Combining_01 */
static int hf_rrc_fdd_198 = -1;                   /* T_fdd_192 */
static int hf_rrc_MBMS_NeighbouringCellSCCPCHList_r6_item = -1;  /* MBMS_NeighbouringCellSCCPCH_r6 */
static int hf_rrc_MBMS_NeighbouringCellSCCPCHList_v770ext_item = -1;  /* MBMS_NeighbouringCellSCCPCH_v770ext */
static int hf_rrc_networkStandardTime = -1;       /* BIT_STRING_SIZE_40 */
static int hf_rrc_correlativeSFN = -1;            /* INTEGER_0_4095 */
static int hf_rrc_mbms_CommonPhyChIdentity = -1;  /* MBMS_CommonPhyChIdentity */
static int hf_rrc_secondaryCCPCHInfo_MBMS_02 = -1;  /* SecondaryCCPCHFrameType2Info */
static int hf_rrc_MBMS_PhyChInformationList_IMB384_item = -1;  /* MBMS_PhyChInformation_IMB384 */
static int hf_rrc_MBMS_PhyChInformationList_r6_item = -1;  /* MBMS_PhyChInformation_r6 */
static int hf_rrc_MBMS_PhyChInformationList_r7_item = -1;  /* MBMS_PhyChInformation_r7 */
static int hf_rrc_mbmsPreferredFrequency = -1;    /* INTEGER_1_maxMBMS_Freq */
static int hf_rrc_layerConvergenceInformation = -1;  /* T_layerConvergenceInformation */
static int hf_rrc_mbms_Qoffset = -1;              /* MBMS_Qoffset */
static int hf_rrc_mbms_HCSoffset = -1;            /* INTEGER_0_7 */
static int hf_rrc_MBMS_PreferredFrequencyList_r6_item = -1;  /* MBMS_PreferredFrequencyInfo_r6 */
static int hf_rrc_rbInformation = -1;             /* MBMS_CommonRBIdentity */
static int hf_rrc_shortTransmissionID = -1;       /* MBMS_ShortTransmissionID */
static int hf_rrc_logicalChIdentity = -1;         /* MBMS_LogicalChIdentity */
static int hf_rrc_MBMS_PTM_RBInformation_CList_item = -1;  /* MBMS_PTM_RBInformation_C */
static int hf_rrc_layer1_CombiningStatus = -1;    /* BOOLEAN */
static int hf_rrc_MBMS_PTM_RBInformation_NList_item = -1;  /* MBMS_PTM_RBInformation_N */
static int hf_rrc_status = -1;                    /* T_status */
static int hf_rrc_some = -1;                      /* MBMS_SelectedServicesListFull */
static int hf_rrc_MBMS_SelectedServicesListFull_item = -1;  /* MBMS_ServiceIdentity_r6 */
static int hf_rrc_MBMS_SelectedServicesListShort_item = -1;  /* MBMS_ShortTransmissionID */
static int hf_rrc_mbms_SelectedServicesList = -1;  /* MBMS_SelectedServicesListShort */
static int hf_rrc_modificationPeriodIdentity = -1;  /* INTEGER_0_1 */
static int hf_rrc_accessprobabilityFactor_Idle = -1;  /* MBMS_AccessProbabilityFactor */
static int hf_rrc_accessprobabilityFactor_Connected = -1;  /* MBMS_AccessProbabilityFactor */
static int hf_rrc_mbms_ConnectedModeCountingScope = -1;  /* MBMS_ConnectedModeCountingScope */
static int hf_rrc_MBMS_ServiceAccessInfoList_r6_item = -1;  /* MBMS_ServiceAccessInfo_r6 */
static int hf_rrc_serviceIdentity = -1;           /* OCTET_STRING_SIZE_3 */
static int hf_rrc_plmn_Identity_01 = -1;          /* T_plmn_Identity */
static int hf_rrc_sameAsMIB_PLMN_Id = -1;         /* NULL */
static int hf_rrc_other_01 = -1;                  /* T_other_01 */
static int hf_rrc_sameAsMIB_MultiPLMN_Id = -1;    /* INTEGER_1_5 */
static int hf_rrc_explicitPLMN_Id = -1;           /* PLMN_Identity */
static int hf_rrc_mbms_ServiceTransmInfoList = -1;  /* MBMS_ServiceTransmInfoList */
static int hf_rrc_nextSchedulingperiod = -1;      /* INTEGER_0_31 */
static int hf_rrc_MBMS_ServiceSchedulingInfoList_r6_item = -1;  /* MBMS_ServiceSchedulingInfo_r6 */
static int hf_rrc_start = -1;                     /* INTEGER_0_255 */
static int hf_rrc_duration = -1;                  /* INTEGER_1_256 */
static int hf_rrc_MBMS_ServiceTransmInfoList_item = -1;  /* MBMS_ServiceTransmInfo */
static int hf_rrc_transpCHInformation_02 = -1;    /* MBMS_TrCHInformation_SIB5List */
static int hf_rrc_MBMS_SIBType5_SCCPCHList_r6_item = -1;  /* MBMS_SIBType5_SCCPCH_r6 */
static int hf_rrc_t_318 = -1;                     /* T_318 */
static int hf_rrc_mbms_ServiceIdentity_01 = -1;   /* MBMS_ServiceIdentity_r6 */
static int hf_rrc_commonCCTrChIdentity = -1;      /* MBMS_CommonCCTrChIdentity */
static int hf_rrc_MBMS_TranspChInfoForEachCCTrCh_r6_item = -1;  /* MBMS_TranspChInfoForCCTrCh_r6 */
static int hf_rrc_MBMS_TranspChInfoForEachTrCh_r6_item = -1;  /* MBMS_TranspChInfoForTrCh_r6 */
static int hf_rrc_commonTrChIdentity = -1;        /* MBMS_CommonTrChIdentity */
static int hf_rrc_transpCh_Info = -1;             /* MBMS_CommonTrChIdentity */
static int hf_rrc_rbInformation_01 = -1;          /* MBMS_PTM_RBInformation_CList */
static int hf_rrc_MBMS_TrCHInformation_CurrList_item = -1;  /* MBMS_TrCHInformation_Curr */
static int hf_rrc_transpCh_CombiningStatus = -1;  /* BOOLEAN */
static int hf_rrc_rbInformation_02 = -1;          /* MBMS_PTM_RBInformation_NList */
static int hf_rrc_MBMS_TrCHInformation_NeighbList_item = -1;  /* MBMS_TrCHInformation_Neighb */
static int hf_rrc_transpCh_Identity = -1;         /* INTEGER_1_maxFACHPCH */
static int hf_rrc_MBMS_TrCHInformation_SIB5List_item = -1;  /* MBMS_TrCHInformation_SIB5 */
static int hf_rrc_mbms_RequiredUEAction_01 = -1;  /* MBMS_RequiredUEAction_UMod */
static int hf_rrc_mbms_PreferredFrequency_01 = -1;  /* MBMS_PFLIndex */
static int hf_rrc_MBMS_UnmodifiedServiceList_r6_item = -1;  /* MBMS_UnmodifiedService_r6 */
static int hf_rrc_MBMS_UnmodifiedServiceList_v770ext_item = -1;  /* MBMS_UnmodifiedService_v770ext */
static int hf_rrc_imb_Indication = -1;            /* T_imb_Indication */
static int hf_rrc_MBSFNFrequencyList_item = -1;   /* MBSFNFrequency */
static int hf_rrc_MBSFNFrequencyList_v860ext_item = -1;  /* MBSFNFrequency_v860ext */
static int hf_rrc_notificationOfAllMBSFNServicesInTheBand = -1;  /* T_notificationOfAllMBSFNServicesInTheBand */
static int hf_rrc_mbsfnFrequency = -1;            /* FrequencyInfo */
static int hf_rrc_mbsfnServicesNotification = -1;  /* T_mbsfnServicesNotification */
static int hf_rrc_mbsfnServicesNotified = -1;     /* NULL */
static int hf_rrc_mbsfnServicesNotNotified = -1;  /* MBSFNservicesNotNotified_r7 */
static int hf_rrc_imb_Indication_01 = -1;         /* T_imb_Indication_01 */
static int hf_rrc_MBSFN_InterFrequencyNeighbourList_r7_item = -1;  /* MBSFNInterFrequencyNeighbour_r7 */
static int hf_rrc_MBSFN_InterFrequencyNeighbourList_v860ext_item = -1;  /* MBSFNInterFrequencyNeighbour_v860ext */
static int hf_rrc_MBSFN_TDDInformation_item = -1;  /* MBSFN_TDDTimeSlotInfo */
static int hf_rrc_MBSFN_TDDInformation_LCR_item = -1;  /* MBSFN_TDDTimeSlotInfo_LCR */
static int hf_rrc_timeSlotNumber_01 = -1;         /* TimeslotNumber_LCR_r4 */
static int hf_rrc_frequencyIndex = -1;            /* INTEGER_1_maxMBSFNClusters */
static int hf_rrc_timeSlotList = -1;              /* MBSFN_TDDInformation */
static int hf_rrc_tDMPeriod = -1;                 /* INTEGER_2_9 */
static int hf_rrc_tDMOffset = -1;                 /* INTEGER_0_8 */
static int hf_rrc_tDMLength = -1;                 /* INTEGER_1_8 */
static int hf_rrc_MBSFN_TDM_Info_List_item = -1;  /* MBSFN_TDM_Info */
static int hf_rrc_interRATHandoverInfo = -1;      /* InterRATHandoverInfoWithInterRATCapabilities_r3 */
static int hf_rrc_srncRelocation = -1;            /* SRNC_RelocationInfo_r3 */
static int hf_rrc_rfc3095_ContextInfo = -1;       /* RFC3095_ContextInfo_r5 */
static int hf_rrc_extension = -1;                 /* NULL */
static int hf_rrc_rrc_FailureInfo = -1;           /* RRC_FailureInfo */
static int hf_rrc_dL_DCCHmessage = -1;            /* T_dL_DCCHmessage */
static int hf_rrc_r3_31 = -1;                     /* T_r3_31 */
static int hf_rrc_interRATHandoverInfo_r3 = -1;   /* InterRATHandoverInfoWithInterRATCapabilities_r3_IEs */
static int hf_rrc_v390NonCriticalExtensions_01 = -1;  /* T_v390NonCriticalExtensions_01 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v390ext = -1;  /* InterRATHandoverInfoWithInterRATCapabilities_v390ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_52 = -1;  /* T_v690NonCriticalExtensions_52 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v690ext = -1;  /* InterRATHandoverInfoWithInterRATCapabilities_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_35 = -1;  /* T_v860NonCriticalExtensions_35 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v860ext = -1;  /* InterRATHandoverInfoWithInterRATCapabilities_v860ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_08 = -1;  /* T_v920NonCriticalExtensions_08 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v920ext = -1;  /* InterRATHandoverInfoWithInterRATCapabilities_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_239 = -1;  /* T_nonCriticalExtensions_239 */
static int hf_rrc_criticalExtensions_141 = -1;    /* T_criticalExtensions_140 */
static int hf_rrc_interRATHandoverInfo_01 = -1;   /* T_interRATHandoverInfo */
static int hf_rrc_ue_RATSpecificCapability_01 = -1;  /* InterRAT_UE_RadioAccessCapability_v860ext */
static int hf_rrc_ue_Inactivity_Period = -1;      /* INTEGER_1_120 */
static int hf_rrc_r5_14 = -1;                     /* T_r5_14 */
static int hf_rrc_rFC3095_ContextInfoList_r5 = -1;  /* RFC3095_ContextInfoList_r5 */
static int hf_rrc_nonCriticalExtensions_240 = -1;  /* T_nonCriticalExtensions_240 */
static int hf_rrc_criticalExtensions_142 = -1;    /* T_criticalExtensions_141 */
static int hf_rrc_RFC3095_ContextInfoList_r5_item = -1;  /* RFC3095_ContextInfo */
static int hf_rrc_r3_32 = -1;                     /* T_r3_32 */
static int hf_rrc_sRNC_RelocationInfo_r3 = -1;    /* SRNC_RelocationInfo_r3_IEs */
static int hf_rrc_v380NonCriticalExtensions_02 = -1;  /* T_v380NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v380ext = -1;  /* SRNC_RelocationInfo_v380ext_IEs */
static int hf_rrc_v390NonCriticalExtensions_02 = -1;  /* T_v390NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v390ext = -1;  /* SRNC_RelocationInfo_v390ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_16 = -1;  /* T_v3a0NonCriticalExtensions_16 */
static int hf_rrc_sRNC_RelocationInfo_v3a0ext = -1;  /* SRNC_RelocationInfo_v3a0ext_IEs */
static int hf_rrc_v3b0NonCriticalExtensions = -1;  /* T_v3b0NonCriticalExtensions */
static int hf_rrc_sRNC_RelocationInfo_v3b0ext = -1;  /* SRNC_RelocationInfo_v3b0ext_IEs */
static int hf_rrc_v3c0NonCriticalExtensions = -1;  /* T_v3c0NonCriticalExtensions */
static int hf_rrc_sRNC_RelocationInfo_v3c0ext = -1;  /* SRNC_RelocationInfo_v3c0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_68 = -1;  /* T_laterNonCriticalExtensions_67 */
static int hf_rrc_sRNC_RelocationInfo_v3d0ext = -1;  /* SRNC_RelocationInfo_v3d0ext_IEs */
static int hf_rrc_sRNC_RelocationInfo_r3_add_ext = -1;  /* T_sRNC_RelocationInfo_r3_add_ext */
static int hf_rrc_v3g0NonCriticalExtensions_02 = -1;  /* T_v3g0NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v3g0ext = -1;  /* SRNC_RelocationInfo_v3g0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_27 = -1;  /* T_v4b0NonCriticalExtensions_27 */
static int hf_rrc_sRNC_RelocationInfo_v4b0ext = -1;  /* SRNC_RelocationInfo_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_31 = -1;  /* T_v590NonCriticalExtensions_31 */
static int hf_rrc_sRNC_RelocationInfo_v590ext = -1;  /* SRNC_RelocationInfo_v590ext_IEs */
static int hf_rrc_v5a0NonCriticalExtensions = -1;  /* T_v5a0NonCriticalExtensions */
static int hf_rrc_sRNC_RelocationInfo_v5a0ext = -1;  /* SRNC_RelocationInfo_v5a0ext_IEs */
static int hf_rrc_v5b0NonCriticalExtensions_03 = -1;  /* T_v5b0NonCriticalExtensions_03 */
static int hf_rrc_sRNC_RelocationInfo_v5b0ext = -1;  /* SRNC_RelocationInfo_v5b0ext_IEs */
static int hf_rrc_v5c0NonCriticalExtensions_02 = -1;  /* T_v5c0NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v5c0ext = -1;  /* SRNC_RelocationInfo_v5c0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_53 = -1;  /* T_v690NonCriticalExtensions_53 */
static int hf_rrc_sRNC_RelocationInfo_v690ext = -1;  /* SRNC_RelocationInfo_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_22 = -1;  /* T_v6b0NonCriticalExtensions_21 */
static int hf_rrc_sRNC_RelocationInfo_v6b0ext = -1;  /* SRNC_RelocationInfo_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_48 = -1;  /* T_v770NonCriticalExtensions_48 */
static int hf_rrc_sRNC_RelocationInfo_v770ext = -1;  /* SRNC_RelocationInfo_v770ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_04 = -1;  /* T_v7e0NonCriticalExtensions_04 */
static int hf_rrc_sRNC_RelocationInfo_v7e0ext = -1;  /* SRNC_RelocationInfo_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_17 = -1;  /* T_v7f0NonCriticalExtensions_17 */
static int hf_rrc_sRNC_RelocationInfo_v7f0ext = -1;  /* SRNC_RelocationInfo_v7f0ext_IEs */
static int hf_rrc_nonCriticalExtensions_241 = -1;  /* T_nonCriticalExtensions_241 */
static int hf_rrc_later_than_r3_28 = -1;          /* T_later_than_r3_28 */
static int hf_rrc_r4_14 = -1;                     /* T_r4_14 */
static int hf_rrc_sRNC_RelocationInfo_r4 = -1;    /* SRNC_RelocationInfo_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_14 = -1;  /* T_v4d0NonCriticalExtensions_14 */
static int hf_rrc_sRNC_RelocationInfo_v4d0ext = -1;  /* SRNC_RelocationInfo_v4d0ext_IEs */
static int hf_rrc_sRNC_RelocationInfo_r4_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_32 = -1;  /* T_v590NonCriticalExtensions_32 */
static int hf_rrc_v5a0NonCriticalExtensions_01 = -1;  /* T_v5a0NonCriticalExtensions_01 */
static int hf_rrc_v5b0NonCriticalExtensions_04 = -1;  /* T_v5b0NonCriticalExtensions_04 */
static int hf_rrc_v5c0NonCriticalExtensions_03 = -1;  /* T_v5c0NonCriticalExtensions_03 */
static int hf_rrc_v690NonCriticalExtensions_54 = -1;  /* T_v690NonCriticalExtensions_54 */
static int hf_rrc_v6b0NonCriticalExtensions_23 = -1;  /* T_v6b0NonCriticalExtensions_22 */
static int hf_rrc_v770NonCriticalExtensions_49 = -1;  /* T_v770NonCriticalExtensions_49 */
static int hf_rrc_v7e0NonCriticalExtensions_05 = -1;  /* T_v7e0NonCriticalExtensions_05 */
static int hf_rrc_v7f0NonCriticalExtensions_18 = -1;  /* T_v7f0NonCriticalExtensions_18 */
static int hf_rrc_nonCriticalExtensions_242 = -1;  /* T_nonCriticalExtensions_242 */
static int hf_rrc_criticalExtensions_143 = -1;    /* T_criticalExtensions_142 */
static int hf_rrc_r5_15 = -1;                     /* T_r5_15 */
static int hf_rrc_sRNC_RelocationInfo_r5 = -1;    /* SRNC_RelocationInfo_r5_IEs */
static int hf_rrc_sRNC_RelocationInfo_r5_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v5a0NonCriticalExtensions_02 = -1;  /* T_v5a0NonCriticalExtensions_02 */
static int hf_rrc_v5b0NonCriticalExtensions_05 = -1;  /* T_v5b0NonCriticalExtensions_05 */
static int hf_rrc_v5c0NonCriticalExtensions_04 = -1;  /* T_v5c0NonCriticalExtensions_04 */
static int hf_rrc_v690NonCriticalExtensions_55 = -1;  /* T_v690NonCriticalExtensions_55 */
static int hf_rrc_v6b0NonCriticalExtensions_24 = -1;  /* T_v6b0NonCriticalExtensions_23 */
static int hf_rrc_v770NonCriticalExtensions_50 = -1;  /* T_v770NonCriticalExtensions_50 */
static int hf_rrc_v7e0NonCriticalExtensions_06 = -1;  /* T_v7e0NonCriticalExtensions_06 */
static int hf_rrc_v7f0NonCriticalExtensions_19 = -1;  /* T_v7f0NonCriticalExtensions_19 */
static int hf_rrc_nonCriticalExtensions_243 = -1;  /* T_nonCriticalExtensions_243 */
static int hf_rrc_criticalExtensions_144 = -1;    /* T_criticalExtensions_143 */
static int hf_rrc_r6_12 = -1;                     /* T_r6_12 */
static int hf_rrc_sRNC_RelocationInfo_r6 = -1;    /* SRNC_RelocationInfo_r6_IEs */
static int hf_rrc_sRNC_RelocationInfo_r6_add_ext = -1;  /* T_sRNC_RelocationInfo_r6_add_ext */
static int hf_rrc_v6b0NonCriticalExtensions_25 = -1;  /* T_v6b0NonCriticalExtensions_24 */
static int hf_rrc_v770NonCriticalExtensions_51 = -1;  /* T_v770NonCriticalExtensions_51 */
static int hf_rrc_v820NonCriticalExtensions_03 = -1;  /* T_v820NonCriticalExtensions_03 */
static int hf_rrc_srnc_RelocationInfo_v820ext = -1;  /* SRNC_RelocationInfo_v820ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_36 = -1;  /* T_v860NonCriticalExtensions_36 */
static int hf_rrc_sRNC_RelocationInfo_v860ext = -1;  /* SRNC_RelocationInfo_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_244 = -1;  /* T_nonCriticalExtensions_244 */
static int hf_rrc_criticalExtensions_145 = -1;    /* T_criticalExtensions_144 */
static int hf_rrc_r7_16 = -1;                     /* T_r7_16 */
static int hf_rrc_sRNC_RelocationInfo_r7 = -1;    /* SRNC_RelocationInfo_r7_IEs */
static int hf_rrc_sRNC_RelocationInfo_r7_add_ext = -1;  /* T_sRNC_RelocationInfo_r7_add_ext */
static int hf_rrc_v820NonCriticalExtensions_04 = -1;  /* T_v820NonCriticalExtensions_04 */
static int hf_rrc_v860NonCriticalExtensions_37 = -1;  /* T_v860NonCriticalExtensions_37 */
static int hf_rrc_nonCriticalExtensions_245 = -1;  /* T_nonCriticalExtensions_245 */
static int hf_rrc_criticalExtensions_146 = -1;    /* T_criticalExtensions_145 */
static int hf_rrc_r8_12 = -1;                     /* T_r8_12 */
static int hf_rrc_sRNC_RelocationInfo_r8 = -1;    /* SRNC_RelocationInfo_r8_IEs */
static int hf_rrc_sRNC_RelocationInfo_r8_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v7e0NonCriticalExtensions_07 = -1;  /* T_v7e0NonCriticalExtensions_07 */
static int hf_rrc_v7f0NonCriticalExtensions_20 = -1;  /* T_v7f0NonCriticalExtensions_20 */
static int hf_rrc_v8d0NonCriticalExtensions_01 = -1;  /* T_v8d0NonCriticalExtensions_01 */
static int hf_rrc_sRNC_RelocationInfo_v8d0ext = -1;  /* SRNC_RelocationInfo_v8d0ext_IEs */
static int hf_rrc_nonCriticalExtensions_246 = -1;  /* T_nonCriticalExtensions_246 */
static int hf_rrc_criticalExtensions_147 = -1;    /* T_criticalExtensions_146 */
static int hf_rrc_r9_11 = -1;                     /* T_r9_11 */
static int hf_rrc_sRNC_RelocationInfo_r9 = -1;    /* SRNC_RelocationInfo_r9_IEs */
static int hf_rrc_sRNC_RelocationInfo_r9_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v8d0NonCriticalExtensions_02 = -1;  /* T_v8d0NonCriticalExtensions_02 */
static int hf_rrc_v970NonCriticalExtensions_04 = -1;  /* T_v970NonCriticalExtensions_04 */
static int hf_rrc_sRNC_RelocationInfo_v970ext = -1;  /* SRNC_RelocationInfo_v970ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_13 = -1;  /* T_v9c0NonCriticalExtensions_13 */
static int hf_rrc_sRNC_RelocationInfo_v9c0ext = -1;  /* SRNC_RelocationInfo_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_247 = -1;  /* T_nonCriticalExtensions_247 */
static int hf_rrc_criticalExtensions_148 = -1;    /* T_criticalExtensions_147 */
static int hf_rrc_r10_13 = -1;                    /* T_r10_13 */
static int hf_rrc_sRNC_RelocationInfo_r10 = -1;   /* SRNC_RelocationInfo_r10_IEs */
static int hf_rrc_sRNC_RelocationInfo_r10_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_14 = -1;  /* T_v9c0NonCriticalExtensions_14 */
static int hf_rrc_vab0NonCriticalExtensions_01 = -1;  /* T_vab0NonCriticalExtensions_01 */
static int hf_rrc_sRNC_RelocationInfo_vab0ext = -1;  /* SRNC_RelocationInfo_vab0ext_IEs */
static int hf_rrc_nonCriticalExtensions_248 = -1;  /* T_nonCriticalExtensions_248 */
static int hf_rrc_criticalExtensions_149 = -1;    /* T_criticalExtensions_148 */
static int hf_rrc_r11_15 = -1;                    /* T_r11_15 */
static int hf_rrc_sRNC_RelocationInfo_r11 = -1;   /* SRNC_RelocationInfo_r11_IEs */
static int hf_rrc_sRNC_RelocationInfo_r11_add_ext = -1;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_249 = -1;  /* T_nonCriticalExtensions_249 */
static int hf_rrc_criticalExtensions_150 = -1;    /* T_criticalExtensions_149 */
static int hf_rrc_stateOfRRC = -1;                /* StateOfRRC */
static int hf_rrc_stateOfRRC_Procedure = -1;      /* StateOfRRC_Procedure */
static int hf_rrc_cipheringStatus = -1;           /* CipheringStatus */
static int hf_rrc_calculationTimeForCiphering = -1;  /* CalculationTimeForCiphering */
static int hf_rrc_cipheringInfoPerRB_List = -1;   /* CipheringInfoPerRB_List */
static int hf_rrc_count_C_List = -1;              /* COUNT_C_List */
static int hf_rrc_integrityProtectionStatus = -1;  /* IntegrityProtectionStatus */
static int hf_rrc_srb_SpecificIntegrityProtInfo = -1;  /* SRB_SpecificIntegrityProtInfoList */
static int hf_rrc_implementationSpecificParams = -1;  /* ImplementationSpecificParams */
static int hf_rrc_c_RNTI = -1;                    /* C_RNTI */
static int hf_rrc_ue_Positioning_LastKnownPos = -1;  /* UE_Positioning_LastKnownPos */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_04 = -1;  /* NAS_SystemInformationGSM_MAP */
static int hf_rrc_ongoingMeasRepList = -1;        /* OngoingMeasRepList */
static int hf_rrc_predefinedConfigStatusList_01 = -1;  /* PredefinedConfigStatusList */
static int hf_rrc_rab_InformationList_01 = -1;    /* RAB_InformationSetupList */
static int hf_rrc_ul_TransChInfoList = -1;        /* UL_AddReconfTransChInfoList */
static int hf_rrc_modeSpecificInfo_155 = -1;      /* T_modeSpecificInfo_155 */
static int hf_rrc_fdd_199 = -1;                   /* T_fdd_193 */
static int hf_rrc_dl_TransChInfoList = -1;        /* DL_AddReconfTransChInfoList */
static int hf_rrc_cipheringStatusList = -1;       /* CipheringStatusList */
static int hf_rrc_cn_DomainInformationList_v390ext = -1;  /* CN_DomainInformationList_v390ext */
static int hf_rrc_cipheringInfoForSRB1_v3a0ext = -1;  /* CipheringInfoPerRB_List_v3a0ext */
static int hf_rrc_startValueForCiphering_v3a0ext = -1;  /* START_Value */
static int hf_rrc_startValueForCiphering_v3b0ext = -1;  /* STARTList2 */
static int hf_rrc_rb_IdentityForHOMessage = -1;   /* RB_Identity */
static int hf_rrc_tpc_CombinationInfoList = -1;   /* TPC_CombinationInfoList */
static int hf_rrc_nonCriticalExtension = -1;      /* T_nonCriticalExtension */
static int hf_rrc_TPC_CombinationInfoList_item = -1;  /* TPC_Combination_Info */
static int hf_rrc_TPC_CombinationInfoList_r9_item = -1;  /* TPC_Combination_Info_r9 */
static int hf_rrc_STARTList2_item = -1;           /* STARTSingle */
static int hf_rrc_storedCompressedModeInfo = -1;  /* StoredCompressedModeInfo */
static int hf_rrc_dl_UM_SN = -1;                  /* BIT_STRING_SIZE_7 */
static int hf_rrc_CipheringStatusList_item = -1;  /* CipheringStatusCNdomain */
static int hf_rrc_CodeChangeStatusList_item = -1;  /* CodeChangeStatus */
static int hf_rrc_storedTGP_SequenceList = -1;    /* StoredTGP_SequenceList */
static int hf_rrc_codeChangeStatusList = -1;      /* CodeChangeStatusList */
static int hf_rrc_storedTGP_SequenceList_01 = -1;  /* StoredTGP_SequenceList_r8 */
static int hf_rrc_StoredTGP_SequenceList_item = -1;  /* StoredTGP_Sequence */
static int hf_rrc_StoredTGP_SequenceList_r8_item = -1;  /* StoredTGP_Sequence_r8 */
static int hf_rrc_current_tgps_Status = -1;       /* T_current_tgps_Status */
static int hf_rrc_active = -1;                    /* T_active */
static int hf_rrc_inactive = -1;                  /* NULL */
static int hf_rrc_current_tgps_Status_01 = -1;    /* T_current_tgps_Status_01 */
static int hf_rrc_active_01 = -1;                 /* T_active_01 */
static int hf_rrc_cipheringStatusList_01 = -1;    /* CipheringStatusList_r4 */
static int hf_rrc_latestConfiguredCN_Domain = -1;  /* CN_DomainIdentity */
static int hf_rrc_cipheringInfoPerRB_List_01 = -1;  /* CipheringInfoPerRB_List_r4 */
static int hf_rrc_ue_RadioAccessCapability_03 = -1;  /* UE_RadioAccessCapability_r4 */
static int hf_rrc_ue_RadioAccessCapability_ext = -1;  /* UE_RadioAccessCapabBandFDDList */
static int hf_rrc_cn_DomainInformationList_01 = -1;  /* CN_DomainInformationListFull */
static int hf_rrc_ongoingMeasRepList_01 = -1;     /* OngoingMeasRepList_r4 */
static int hf_rrc_rab_InformationList_02 = -1;    /* RAB_InformationSetupList_r4 */
static int hf_rrc_dummy_64 = -1;                  /* T_dummy_17 */
static int hf_rrc_fdd_200 = -1;                   /* T_fdd_194 */
static int hf_rrc_dl_TransChInfoList_01 = -1;     /* DL_AddReconfTransChInfoList_r4 */
static int hf_rrc_ue_RadioAccessCapability_04 = -1;  /* UE_RadioAccessCapability_r5 */
static int hf_rrc_ue_RATSpecificCapability_02 = -1;  /* InterRAT_UE_RadioAccessCapabilityList_r5 */
static int hf_rrc_ongoingMeasRepList_02 = -1;     /* OngoingMeasRepList_r5 */
static int hf_rrc_srb_InformationList_01 = -1;    /* SRB_InformationSetupList_r5 */
static int hf_rrc_rab_InformationList_03 = -1;    /* RAB_InformationSetupList_r5 */
static int hf_rrc_dummy_65 = -1;                  /* T_dummy_18 */
static int hf_rrc_fdd_201 = -1;                   /* T_fdd_195 */
static int hf_rrc_dl_TransChInfoList_02 = -1;     /* DL_AddReconfTransChInfoList_r5 */
static int hf_rrc_ueCapabilityContainer_02 = -1;  /* T_ueCapabilityContainer_02 */
static int hf_rrc_ueCapabilityContainer_RSC = -1;  /* T_ueCapabilityContainer_RSC */
static int hf_rrc_ueCapabilityContainer_UCI = -1;  /* T_ueCapabilityContainer_UCI */
static int hf_rrc_intraFreqReportingCriteria_08 = -1;  /* IntraFreqReportingCriteria_r6_ext */
static int hf_rrc_ue_RadioAccessCapability_05 = -1;  /* UE_RadioAccessCapability_r6 */
static int hf_rrc_ueCapabilityContainer_03 = -1;  /* T_ueCapabilityContainer_03 */
static int hf_rrc_ueCapabilityContainer_RSC_01 = -1;  /* T_ueCapabilityContainer_RSC_01 */
static int hf_rrc_ueCapabilityContainer_UCI_01 = -1;  /* T_ueCapabilityContainer_UCI_01 */
static int hf_rrc_ongoingMeasRepList_03 = -1;     /* OngoingMeasRepList_r6 */
static int hf_rrc_srb_InformationList_02 = -1;    /* SRB_InformationSetupList_r6 */
static int hf_rrc_rab_InformationList_04 = -1;    /* RAB_InformationSetupList_r6 */
static int hf_rrc_ul_TransChInfoList_01 = -1;     /* UL_AddReconfTransChInfoList_r6 */
static int hf_rrc_measurementReport_01 = -1;      /* T_measurementReport */
static int hf_rrc_v7f0NonCriticalExtensions_21 = -1;  /* T_v7f0NonCriticalExtensions_21 */
static int hf_rrc_nonCriticalExtensions_250 = -1;  /* T_nonCriticalExtensions_250 */
static int hf_rrc_ueCapabilityContainer_04 = -1;  /* T_ueCapabilityContainer_04 */
static int hf_rrc_ueCapabilityContainer_RSC_02 = -1;  /* T_ueCapabilityContainer_RSC_02 */
static int hf_rrc_ueCapabilityContainer_UCI_02 = -1;  /* T_ueCapabilityContainer_UCI_02 */
static int hf_rrc_srns_t_305 = -1;                /* T_305 */
static int hf_rrc_ongoingMeasRepList_04 = -1;     /* OngoingMeasRepList_r7 */
static int hf_rrc_srb_InformationList_03 = -1;    /* SRB_InformationSetupList_r7 */
static int hf_rrc_rab_InformationList_05 = -1;    /* RAB_InformationSetupList_r7 */
static int hf_rrc_ul_TransChInfoList_02 = -1;     /* UL_AddReconfTransChInfoList_r7 */
static int hf_rrc_dl_TransChInfoList_03 = -1;     /* DL_AddReconfTransChInfoList_r7 */
static int hf_rrc_measurementReport_02 = -1;      /* T_measurementReport_01 */
static int hf_rrc_v7f0NonCriticalExtensions_22 = -1;  /* T_v7f0NonCriticalExtensions_22 */
static int hf_rrc_nonCriticalExtensions_251 = -1;  /* T_nonCriticalExtensions_251 */
static int hf_rrc_thresholdSFN_GPS_TOW_us = -1;   /* ThresholdSFN_GPS_TOW_us */
static int hf_rrc_ueCapabilityContainer_05 = -1;  /* T_ueCapabilityContainer_05 */
static int hf_rrc_ueCapabilityContainer_RSC_03 = -1;  /* T_ueCapabilityContainer_RSC_03 */
static int hf_rrc_ueCapabilityContainer_UCI_03 = -1;  /* T_ueCapabilityContainer_UCI_03 */
static int hf_rrc_ongoingMeasRepList_05 = -1;     /* OngoingMeasRepList_r8 */
static int hf_rrc_srb_InformationList_04 = -1;    /* SRB_InformationSetupList_r8 */
static int hf_rrc_rab_InformationList_06 = -1;    /* RAB_InformationSetupList_r8 */
static int hf_rrc_ul_TransChInfoList_03 = -1;     /* UL_AddReconfTransChInfoList_r8 */
static int hf_rrc_e_RGCH_CombinationInfoList = -1;  /* E_RGCH_CombinationInfoList */
static int hf_rrc_storedCompressedModeInfo_01 = -1;  /* StoredCompressedModeInfo_r8 */
static int hf_rrc_measurementReport_03 = -1;      /* T_measurementReport_02 */
static int hf_rrc_ue_HistoryInformation = -1;     /* UE_HistoryInformation */
static int hf_rrc_rab_InformationList_07 = -1;    /* RAB_InformationSetupList_v820ext */
static int hf_rrc_ueCapabilityContainer_06 = -1;  /* T_ueCapabilityContainer_06 */
static int hf_rrc_ueCapabilityContainer_RSC_04 = -1;  /* T_ueCapabilityContainer_RSC_04 */
static int hf_rrc_ueCapabilityContainer_UCI_04 = -1;  /* T_ueCapabilityContainer_UCI_04 */
static int hf_rrc_ongoingMeasRepList_06 = -1;     /* OngoingMeasRepList_r9 */
static int hf_rrc_dl_TransChInfoList_04 = -1;     /* DL_AddReconfTransChInfoList_r9 */
static int hf_rrc_secondary_tpc_CombinationInfoList = -1;  /* TPC_CombinationInfoList_r9 */
static int hf_rrc_secondary_e_RGCH_CombinationInfoList = -1;  /* E_RGCH_CombinationInfoList_r9 */
static int hf_rrc_measurementReport_04 = -1;      /* T_measurementReport_03 */
static int hf_rrc_ongoingMeasRepList_07 = -1;     /* OngoingMeasRepList_v970ext_IE */
static int hf_rrc_ueCapabilityContainer_07 = -1;  /* T_ueCapabilityContainer_07 */
static int hf_rrc_ueCapabilityContainer_RSC_05 = -1;  /* T_ueCapabilityContainer_RSC_05 */
static int hf_rrc_ueCapabilityContainer_UCI_05 = -1;  /* T_ueCapabilityContainer_UCI_05 */
static int hf_rrc_ongoingMeasRepList_08 = -1;     /* OngoingMeasRepList_r10 */
static int hf_rrc_measurementReport_05 = -1;      /* T_measurementReport_04 */
static int hf_rrc_ueCapabilityContainer_08 = -1;  /* T_ueCapabilityContainer_08 */
static int hf_rrc_ueCapabilityContainer_RSC_06 = -1;  /* T_ueCapabilityContainer_RSC_06 */
static int hf_rrc_ueCapabilityContainer_UCI_06 = -1;  /* T_ueCapabilityContainer_UCI_06 */
static int hf_rrc_ongoingMeasRepList_09 = -1;     /* OngoingMeasRepList_r11 */
static int hf_rrc_srb_InformationList_05 = -1;    /* SRB_InformationSetupList_r11 */
static int hf_rrc_rab_InformationList_08 = -1;    /* RAB_InformationSetupList_r11 */
static int hf_rrc_dl_TransChInfoList_05 = -1;     /* DL_AddReconfTransChInfoList_r11 */
static int hf_rrc_measurementReport_06 = -1;      /* T_measurementReport_05 */
static int hf_rrc_dl_HFN = -1;                    /* BIT_STRING_SIZE_20_25 */
static int hf_rrc_ul_HFN = -1;                    /* BIT_STRING_SIZE_20_25 */
static int hf_rrc_CipheringInfoPerRB_List_item = -1;  /* CipheringInfoPerRB */
static int hf_rrc_CipheringInfoPerRB_List_r4_item = -1;  /* CipheringInfoPerRB_r4 */
static int hf_rrc_CipheringStatusList_r4_item = -1;  /* CipheringStatusCNdomain_r4 */
static int hf_rrc_CN_DomainInformationList_v390ext_item = -1;  /* CN_DomainInformation_v390ext */
static int hf_rrc_tdd384_Measurements = -1;       /* BOOLEAN */
static int hf_rrc_COUNT_C_List_item = -1;         /* COUNT_CSingle */
static int hf_rrc_count_C = -1;                   /* BIT_STRING_SIZE_32 */
static int hf_rrc_dummy3_05 = -1;                 /* SupportOfDedicatedPilotsForChEstimation */
static int hf_rrc_fdd_hspdsch_01 = -1;            /* T_fdd_hspdsch_01 */
static int hf_rrc_supported_14 = -1;              /* T_supported_07 */
static int hf_rrc_tdd384_hspdsch_01 = -1;         /* T_tdd384_hspdsch_01 */
static int hf_rrc_tdd128_hspdsch_01 = -1;         /* T_tdd128_hspdsch_01 */
static int hf_rrc_rfc3095_Context_Identity = -1;  /* INTEGER_0_16383 */
static int hf_rrc_dl_mode = -1;                   /* T_dl_mode */
static int hf_rrc_dl_ref_ir = -1;                 /* OCTET_STRING_SIZE_1_3000 */
static int hf_rrc_dl_ref_time = -1;               /* INTEGER_0_4294967295 */
static int hf_rrc_dl_curr_time = -1;              /* INTEGER_0_4294967295 */
static int hf_rrc_dl_syn_offset_id = -1;          /* INTEGER_0_65535 */
static int hf_rrc_dl_syn_slope_ts = -1;           /* INTEGER_0_4294967295 */
static int hf_rrc_dl_dyn_changed = -1;            /* BOOLEAN */
static int hf_rrc_rg_CombinationIndex_01 = -1;    /* INTEGER_0_5 */
static int hf_rrc_E_RGCH_CombinationInfoList_item = -1;  /* E_RGCH_Combination_Info */
static int hf_rrc_E_RGCH_CombinationInfoList_r9_item = -1;  /* E_RGCH_Combination_Info_r9 */
static int hf_rrc_interRAT_UE_RadioAccessCapability = -1;  /* InterRAT_UE_RadioAccessCapabilityList */
static int hf_rrc_event_06 = -1;                  /* Event1j_r6 */
static int hf_rrc_downlinkCompressedMode_04 = -1;  /* CompressedModeMeasCapability_r4 */
static int hf_rrc_uplinkCompressedMode_01 = -1;   /* CompressedModeMeasCapability_r4 */
static int hf_rrc_modify_09 = -1;                 /* NULL */
static int hf_rrc_measurementCommandWithType = -1;  /* MeasurementCommandWithType */
static int hf_rrc_additionalMeasurementID_List = -1;  /* AdditionalMeasurementID_List */
static int hf_rrc_measurementCommandWithType_01 = -1;  /* MeasurementCommandWithType_r4 */
static int hf_rrc_measurementCommand_v590ext_01 = -1;  /* T_measurementCommand_v590ext_01 */
static int hf_rrc_measurementCommandWithType_02 = -1;  /* MeasurementCommandWithType_r6 */
static int hf_rrc_measurementCommandWithType_03 = -1;  /* MeasurementCommandWithType_r7 */
static int hf_rrc_measurementCommandWithType_04 = -1;  /* MeasurementCommandWithType_r8 */
static int hf_rrc_measurementCommandWithType_05 = -1;  /* MeasurementCommandWithType_r9 */
static int hf_rrc_additionalMeasurementID_List_01 = -1;  /* AdditionalMeasurementID_List_r9 */
static int hf_rrc_measurementCommandWithType_06 = -1;  /* MeasurementCommandWithType_r10 */
static int hf_rrc_measurementCommandWithType_07 = -1;  /* MeasurementCommandWithType_r11 */
static int hf_rrc_OngoingMeasRepList_item = -1;   /* OngoingMeasRep */
static int hf_rrc_OngoingMeasRepList_r4_item = -1;  /* OngoingMeasRep_r4 */
static int hf_rrc_OngoingMeasRepList_r5_item = -1;  /* OngoingMeasRep_r5 */
static int hf_rrc_OngoingMeasRepList_r6_item = -1;  /* OngoingMeasRep_r6 */
static int hf_rrc_OngoingMeasRepList_r7_item = -1;  /* OngoingMeasRep_r7 */
static int hf_rrc_OngoingMeasRepList_r8_item = -1;  /* OngoingMeasRep_r8 */
static int hf_rrc_OngoingMeasRepList_r9_item = -1;  /* OngoingMeasRep_r9 */
static int hf_rrc_OngoingMeasRepList_v970ext_IE_item = -1;  /* OngoingMeasRep_v970ext_IEs */
static int hf_rrc_OngoingMeasRepList_r10_item = -1;  /* OngoingMeasRep_r10 */
static int hf_rrc_OngoingMeasRepList_r11_item = -1;  /* OngoingMeasRep_r11 */
static int hf_rrc_supportForRfc2507_01 = -1;      /* T_supportForRfc2507_01 */
static int hf_rrc_supportForRfc3095_01 = -1;      /* T_supportForRfc3095_01 */
static int hf_rrc_supported_15 = -1;              /* T_supported_08 */
static int hf_rrc_supportForRfc2507_02 = -1;      /* T_supportForRfc2507_02 */
static int hf_rrc_supported_16 = -1;              /* MaxHcContextSpace_r5 */
static int hf_rrc_supportForRfc3095_02 = -1;      /* T_supportForRfc3095_02 */
static int hf_rrc_supported_17 = -1;              /* T_supported_09 */
static int hf_rrc_losslessDLRLC_PDUSizeChange_01 = -1;  /* T_losslessDLRLC_PDUSizeChange_01 */
static int hf_rrc_supportForRfc2507_03 = -1;      /* T_supportForRfc2507_03 */
static int hf_rrc_supportForRfc3095_03 = -1;      /* T_supportForRfc3095_03 */
static int hf_rrc_supported_18 = -1;              /* T_supported_10 */
static int hf_rrc_fddPhysChCapability_06 = -1;    /* T_fddPhysChCapability_06 */
static int hf_rrc_downlinkPhysChCapability_13 = -1;  /* DL_PhysChCapabilityFDD_r4 */
static int hf_rrc_tdd384_PhysChCapability = -1;   /* T_tdd384_PhysChCapability */
static int hf_rrc_tdd128_PhysChCapability_01 = -1;  /* T_tdd128_PhysChCapability_01 */
static int hf_rrc_fddPhysChCapability_07 = -1;    /* T_fddPhysChCapability_07 */
static int hf_rrc_downlinkPhysChCapability_14 = -1;  /* DL_PhysChCapabilityFDD_r5 */
static int hf_rrc_tdd384_PhysChCapability_01 = -1;  /* T_tdd384_PhysChCapability_01 */
static int hf_rrc_downlinkPhysChCapability_15 = -1;  /* DL_PhysChCapabilityTDD_r5 */
static int hf_rrc_tdd128_PhysChCapability_02 = -1;  /* T_tdd128_PhysChCapability_02 */
static int hf_rrc_downlinkPhysChCapability_16 = -1;  /* DL_PhysChCapabilityTDD_LCR_r5 */
static int hf_rrc_fddRF_Capability_04 = -1;       /* T_fddRF_Capability_04 */
static int hf_rrc_tdd384_RF_Capability_02 = -1;   /* T_tdd384_RF_Capability_01 */
static int hf_rrc_tdd128_RF_Capability_03 = -1;   /* T_tdd128_RF_Capability_01 */
static int hf_rrc_rfc3095_Context_List = -1;      /* RFC3095_Context_List */
static int hf_rrc_RFC3095_Context_List_item = -1;  /* RFC3095_Context_List_item */
static int hf_rrc_dl_RFC3095_Context = -1;        /* DL_RFC3095_Context */
static int hf_rrc_ul_RFC3095_Context = -1;        /* UL_RFC3095_Context */
static int hf_rrc_totalRLC_AM_BufferSize_05 = -1;  /* TotalRLC_AM_BufferSize_r5 */
static int hf_rrc_ul_RRC_HFN = -1;                /* BIT_STRING_SIZE_28 */
static int hf_rrc_dl_RRC_HFN = -1;                /* BIT_STRING_SIZE_28 */
static int hf_rrc_ul_RRC_SequenceNumber = -1;     /* RRC_MessageSequenceNumber */
static int hf_rrc_dl_RRC_SequenceNumber = -1;     /* RRC_MessageSequenceNumber */
static int hf_rrc_SRB_SpecificIntegrityProtInfoList_item = -1;  /* SRB_SpecificIntegrityProtInfo */
static int hf_rrc_validity_CellPCH_UraPCH_01 = -1;  /* T_validity_CellPCH_UraPCH_01 */
static int hf_rrc_sfn_sfnType2Capability_01 = -1;  /* T_sfn_sfnType2Capability_01 */
static int hf_rrc_pdcp_Capability_03 = -1;        /* PDCP_Capability_r4 */
static int hf_rrc_rf_Capability_04 = -1;          /* RF_Capability_r4 */
static int hf_rrc_physicalChannelCapability_08 = -1;  /* PhysicalChannelCapability_r4 */
static int hf_rrc_ue_positioning_Capability_01 = -1;  /* UE_Positioning_Capability_r4 */
static int hf_rrc_measurementCapability_06 = -1;  /* MeasurementCapability_r4 */
static int hf_rrc_pdcp_Capability_04 = -1;        /* PDCP_Capability_r5 */
static int hf_rrc_rlc_Capability_05 = -1;         /* RLC_Capability_r5 */
static int hf_rrc_physicalChannelCapability_09 = -1;  /* PhysicalChannelCapability_r5 */
static int hf_rrc_ue_MultiModeRAT_Capability_01 = -1;  /* UE_MultiModeRAT_Capability_r5 */
static int hf_rrc_pdcp_Capability_05 = -1;        /* PDCP_Capability_r6 */
static int hf_rrc_ul_mode = -1;                   /* T_ul_mode */
static int hf_rrc_ul_ref_ir = -1;                 /* OCTET_STRING_SIZE_1_3000 */
static int hf_rrc_ul_ref_time = -1;               /* INTEGER_0_4294967295 */
static int hf_rrc_ul_curr_time = -1;              /* INTEGER_0_4294967295 */
static int hf_rrc_ul_syn_offset_id = -1;          /* INTEGER_0_65535 */
static int hf_rrc_ul_syn_slope_ts = -1;           /* INTEGER_0_4294967295 */
static int hf_rrc_ul_ref_sn_1 = -1;               /* INTEGER_0_65535 */
/* named bits */
static int hf_rrc_T_cipheringAlgorithmCap_spare15 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare14 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare13 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare12 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare11 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare10 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare9 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare8 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare7 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare6 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare5 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare4 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_spare3 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_uea2 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_uea1 = -1;
static int hf_rrc_T_cipheringAlgorithmCap_uea0 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare15 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare14 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare13 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare12 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare11 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare10 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare9 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare8 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare7 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare6 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare5 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare4 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare3 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_uia2 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_uia1 = -1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare0 = -1;
static int hf_rrc_T_assignedSubChannelNumber_b3 = -1;
static int hf_rrc_T_assignedSubChannelNumber_b2 = -1;
static int hf_rrc_T_assignedSubChannelNumber_b1 = -1;
static int hf_rrc_T_assignedSubChannelNumber_b0 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex7 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex6 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex5 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex4 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex3 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex2 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex1 = -1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex0 = -1;
static int hf_rrc_T_subchannels_01_subCh3 = -1;
static int hf_rrc_T_subchannels_01_subCh2 = -1;
static int hf_rrc_T_subchannels_01_subCh1 = -1;
static int hf_rrc_T_subchannels_01_subCh0 = -1;
static int hf_rrc_T_subchannels_02_subCh7 = -1;
static int hf_rrc_T_subchannels_02_subCh6 = -1;
static int hf_rrc_T_subchannels_02_subCh5 = -1;
static int hf_rrc_T_subchannels_02_subCh4 = -1;
static int hf_rrc_T_subchannels_02_subCh3 = -1;
static int hf_rrc_T_subchannels_02_subCh2 = -1;
static int hf_rrc_T_subchannels_02_subCh1 = -1;
static int hf_rrc_T_subchannels_02_subCh0 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex15 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex14 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex13 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex12 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex11 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex10 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex9 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex8 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex7 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex6 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex5 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex4 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex3 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex2 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex1 = -1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex0 = -1;
static int hf_rrc_T_subchannels_04_subCh3 = -1;
static int hf_rrc_T_subchannels_04_subCh2 = -1;
static int hf_rrc_T_subchannels_04_subCh1 = -1;
static int hf_rrc_T_subchannels_04_subCh0 = -1;
static int hf_rrc_T_subchannels_05_subCh7 = -1;
static int hf_rrc_T_subchannels_05_subCh6 = -1;
static int hf_rrc_T_subchannels_05_subCh5 = -1;
static int hf_rrc_T_subchannels_05_subCh4 = -1;
static int hf_rrc_T_subchannels_05_subCh3 = -1;
static int hf_rrc_T_subchannels_05_subCh2 = -1;
static int hf_rrc_T_subchannels_05_subCh1 = -1;
static int hf_rrc_T_subchannels_05_subCh0 = -1;
static int hf_rrc_T_subchannels_06_subCh15 = -1;
static int hf_rrc_T_subchannels_06_subCh14 = -1;
static int hf_rrc_T_subchannels_06_subCh13 = -1;
static int hf_rrc_T_subchannels_06_subCh12 = -1;
static int hf_rrc_T_subchannels_06_subCh11 = -1;
static int hf_rrc_T_subchannels_06_subCh10 = -1;
static int hf_rrc_T_subchannels_06_subCh9 = -1;
static int hf_rrc_T_subchannels_06_subCh8 = -1;
static int hf_rrc_T_subchannels_06_subCh7 = -1;
static int hf_rrc_T_subchannels_06_subCh6 = -1;
static int hf_rrc_T_subchannels_06_subCh5 = -1;
static int hf_rrc_T_subchannels_06_subCh4 = -1;
static int hf_rrc_T_subchannels_06_subCh3 = -1;
static int hf_rrc_T_subchannels_06_subCh2 = -1;
static int hf_rrc_T_subchannels_06_subCh1 = -1;
static int hf_rrc_T_subchannels_06_subCh0 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex7 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex6 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex5 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex4 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex3 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex2 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex1 = -1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex0 = -1;
static int hf_rrc_T_subchannels_08_subCh3 = -1;
static int hf_rrc_T_subchannels_08_subCh2 = -1;
static int hf_rrc_T_subchannels_08_subCh1 = -1;
static int hf_rrc_T_subchannels_08_subCh0 = -1;
static int hf_rrc_T_subchannels_09_subCh7 = -1;
static int hf_rrc_T_subchannels_09_subCh6 = -1;
static int hf_rrc_T_subchannels_09_subCh5 = -1;
static int hf_rrc_T_subchannels_09_subCh4 = -1;
static int hf_rrc_T_subchannels_09_subCh3 = -1;
static int hf_rrc_T_subchannels_09_subCh2 = -1;
static int hf_rrc_T_subchannels_09_subCh1 = -1;
static int hf_rrc_T_subchannels_09_subCh0 = -1;
static int hf_rrc_AvailableSignatures_signature15 = -1;
static int hf_rrc_AvailableSignatures_signature14 = -1;
static int hf_rrc_AvailableSignatures_signature13 = -1;
static int hf_rrc_AvailableSignatures_signature12 = -1;
static int hf_rrc_AvailableSignatures_signature11 = -1;
static int hf_rrc_AvailableSignatures_signature10 = -1;
static int hf_rrc_AvailableSignatures_signature9 = -1;
static int hf_rrc_AvailableSignatures_signature8 = -1;
static int hf_rrc_AvailableSignatures_signature7 = -1;
static int hf_rrc_AvailableSignatures_signature6 = -1;
static int hf_rrc_AvailableSignatures_signature5 = -1;
static int hf_rrc_AvailableSignatures_signature4 = -1;
static int hf_rrc_AvailableSignatures_signature3 = -1;
static int hf_rrc_AvailableSignatures_signature2 = -1;
static int hf_rrc_AvailableSignatures_signature1 = -1;
static int hf_rrc_AvailableSignatures_signature0 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh11 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh10 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh9 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh8 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh7 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh6 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh5 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh4 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh3 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh2 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh1 = -1;
static int hf_rrc_AvailableSubChannelNumbers_subCh0 = -1;
static int hf_rrc_T_bitmap_chCode16_SF16 = -1;
static int hf_rrc_T_bitmap_chCode15_SF16 = -1;
static int hf_rrc_T_bitmap_chCode14_SF16 = -1;
static int hf_rrc_T_bitmap_chCode13_SF16 = -1;
static int hf_rrc_T_bitmap_chCode12_SF16 = -1;
static int hf_rrc_T_bitmap_chCode11_SF16 = -1;
static int hf_rrc_T_bitmap_chCode10_SF16 = -1;
static int hf_rrc_T_bitmap_chCode9_SF16 = -1;
static int hf_rrc_T_bitmap_chCode8_SF16 = -1;
static int hf_rrc_T_bitmap_chCode7_SF16 = -1;
static int hf_rrc_T_bitmap_chCode6_SF16 = -1;
static int hf_rrc_T_bitmap_chCode5_SF16 = -1;
static int hf_rrc_T_bitmap_chCode4_SF16 = -1;
static int hf_rrc_T_bitmap_chCode3_SF16 = -1;
static int hf_rrc_T_bitmap_chCode2_SF16 = -1;
static int hf_rrc_T_bitmap_chCode1_SF16 = -1;
static int hf_rrc_T_bitmap_01_chCode32_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode31_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode30_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode29_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode28_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode27_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode26_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode25_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode24_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode23_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode22_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode21_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode20_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode19_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode18_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode17_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode16_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode15_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode14_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode13_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode12_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode11_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode10_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode9_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode8_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode7_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode6_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode5_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode4_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode3_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode2_SF32 = -1;
static int hf_rrc_T_bitmap_01_chCode1_SF32 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code7 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code6 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code5 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code4 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code3 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code2 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code1 = -1;
static int hf_rrc_T_sync_UL_CodesBitmap_code0 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code7 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code6 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code5 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code4 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code3 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code2 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code1 = -1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code0 = -1;
static int hf_rrc_GsmSecurityCapability_a5_7 = -1;
static int hf_rrc_GsmSecurityCapability_a5_6 = -1;
static int hf_rrc_GsmSecurityCapability_a5_5 = -1;
static int hf_rrc_GsmSecurityCapability_a5_4 = -1;
static int hf_rrc_GsmSecurityCapability_a5_3 = -1;
static int hf_rrc_GsmSecurityCapability_a5_2 = -1;
static int hf_rrc_GsmSecurityCapability_a5_1 = -1;

/*--- End of included file: packet-rrc-hf.c ---*/
#line 105 "../../asn1/rrc/packet-rrc-template.c"

/* Initialize the subtree pointers */
static int ett_rrc = -1;


/*--- Included file: packet-rrc-ett.c ---*/
#line 1 "../../asn1/rrc/packet-rrc-ett.c"
static gint ett_rrc_DL_DCCH_Message = -1;
static gint ett_rrc_DL_DCCH_MessageType = -1;
static gint ett_rrc_UL_DCCH_Message = -1;
static gint ett_rrc_UL_DCCH_MessageType = -1;
static gint ett_rrc_UL_DCCH_MessageType_ext = -1;
static gint ett_rrc_DL_CCCH_Message = -1;
static gint ett_rrc_DL_CCCH_MessageType = -1;
static gint ett_rrc_UL_CCCH_Message = -1;
static gint ett_rrc_UL_CCCH_MessageType = -1;
static gint ett_rrc_UL_CCCH_MessageType_r11 = -1;
static gint ett_rrc_PCCH_Message = -1;
static gint ett_rrc_PCCH_MessageType = -1;
static gint ett_rrc_DL_SHCCH_Message = -1;
static gint ett_rrc_DL_SHCCH_MessageType = -1;
static gint ett_rrc_UL_SHCCH_Message = -1;
static gint ett_rrc_UL_SHCCH_MessageType = -1;
static gint ett_rrc_BCCH_FACH_Message = -1;
static gint ett_rrc_BCCH_FACH_MessageType = -1;
static gint ett_rrc_BCCH_BCH_Message = -1;
static gint ett_rrc_MCCH_Message = -1;
static gint ett_rrc_MCCH_MessageType = -1;
static gint ett_rrc_MSCH_Message = -1;
static gint ett_rrc_MSCH_MessageType = -1;
static gint ett_rrc_ActiveSetUpdate = -1;
static gint ett_rrc_T_r3 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions = -1;
static gint ett_rrc_T_v590NonCriticalExtensions = -1;
static gint ett_rrc_T_v690NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions = -1;
static gint ett_rrc_T_later_than_r3 = -1;
static gint ett_rrc_T_criticalExtensions = -1;
static gint ett_rrc_T_r6 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_01 = -1;
static gint ett_rrc_T_criticalExtensions_01 = -1;
static gint ett_rrc_T_r7 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_02 = -1;
static gint ett_rrc_T_criticalExtensions_02 = -1;
static gint ett_rrc_T_r8 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_03 = -1;
static gint ett_rrc_T_criticalExtensions_03 = -1;
static gint ett_rrc_T_r9 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_04 = -1;
static gint ett_rrc_T_criticalExtensions_04 = -1;
static gint ett_rrc_T_r10 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_05 = -1;
static gint ett_rrc_T_criticalExtensions_05 = -1;
static gint ett_rrc_T_r11 = -1;
static gint ett_rrc_T_nonCriticalExtensions_06 = -1;
static gint ett_rrc_T_criticalExtensions_06 = -1;
static gint ett_rrc_ActiveSetUpdate_r3_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v4b0ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v590ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v690ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_r6_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v6b0ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_r7_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v780ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v7f0ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v7g0ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_r8_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v890ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_r9_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_v950ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_r10_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_vb50ext_IEs = -1;
static gint ett_rrc_ActiveSetUpdate_r11_IEs = -1;
static gint ett_rrc_ActiveSetUpdateComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_07 = -1;
static gint ett_rrc_ActiveSetUpdateFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_08 = -1;
static gint ett_rrc_AssistanceDataDelivery = -1;
static gint ett_rrc_T_r3_01 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v770NonCriticalExtension = -1;
static gint ett_rrc_T_v860NonCriticalExtension = -1;
static gint ett_rrc_T_v920NonCriticalExtension = -1;
static gint ett_rrc_T_va40NonCriticalExtension = -1;
static gint ett_rrc_T_nonCriticalExtensions_09 = -1;
static gint ett_rrc_T_later_than_r3_01 = -1;
static gint ett_rrc_T_criticalExtensions_07 = -1;
static gint ett_rrc_AssistanceDataDelivery_r3_IEs = -1;
static gint ett_rrc_AssistanceDataDelivery_v3a0ext = -1;
static gint ett_rrc_AssistanceDataDelivery_v4b0ext_IEs = -1;
static gint ett_rrc_AssistanceDataDelivery_v770ext_IEs = -1;
static gint ett_rrc_AssistanceDataDelivery_v860ext_IEs = -1;
static gint ett_rrc_AssistanceDataDelivery_v920ext_IEs = -1;
static gint ett_rrc_AssistanceDataDelivery_va40ext_IEs = -1;
static gint ett_rrc_CellChangeOrderFromUTRAN = -1;
static gint ett_rrc_T_r3_02 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_10 = -1;
static gint ett_rrc_T_later_than_r3_02 = -1;
static gint ett_rrc_T_criticalExtensions_08 = -1;
static gint ett_rrc_CellChangeOrderFromUTRAN_r3_IEs = -1;
static gint ett_rrc_CellChangeOrderFromUTRAN_v590ext_IEs = -1;
static gint ett_rrc_T_geran_SystemInfoType = -1;
static gint ett_rrc_CellChangeOrderFromUTRANFailure = -1;
static gint ett_rrc_T_r3_03 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_11 = -1;
static gint ett_rrc_T_dummy = -1;
static gint ett_rrc_T_criticalExtensions_09 = -1;
static gint ett_rrc_CellChangeOrderFromUTRANFailure_r3_IEs = -1;
static gint ett_rrc_CellUpdate = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions = -1;
static gint ett_rrc_T_v860NonCriticalExtensions = -1;
static gint ett_rrc_T_va40NonCriticalExtensions = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_12 = -1;
static gint ett_rrc_CellUpdate_r3_add_ext_IEs = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_13 = -1;
static gint ett_rrc_CellUpdate_v590ext = -1;
static gint ett_rrc_CellUpdate_v690ext_IEs = -1;
static gint ett_rrc_CellUpdate_v6b0ext_IEs = -1;
static gint ett_rrc_CellUpdate_v770ext_IEs = -1;
static gint ett_rrc_CellUpdate_v7e0ext_IEs = -1;
static gint ett_rrc_CellUpdate_v7g0ext_IEs = -1;
static gint ett_rrc_CellUpdate_v860ext_IEs = -1;
static gint ett_rrc_CellUpdate_va40ext_IEs = -1;
static gint ett_rrc_CellUpdateFDD_r11 = -1;
static gint ett_rrc_CellUpdate_vb50ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm = -1;
static gint ett_rrc_T_r3_04 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v590NonCriticalExtenstions = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_14 = -1;
static gint ett_rrc_T_later_than_r3_03 = -1;
static gint ett_rrc_T_criticalExtensions_10 = -1;
static gint ett_rrc_T_r4 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions = -1;
static gint ett_rrc_T_v590NonCriticalExtenstions_01 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_01 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_nonCriticalExtensions_15 = -1;
static gint ett_rrc_T_criticalExtensions_11 = -1;
static gint ett_rrc_T_r5 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_02 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_16 = -1;
static gint ett_rrc_T_criticalExtensions_12 = -1;
static gint ett_rrc_T_r6_01 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_17 = -1;
static gint ett_rrc_T_criticalExtensions_13 = -1;
static gint ett_rrc_T_r7_01 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_18 = -1;
static gint ett_rrc_T_criticalExtensions_14 = -1;
static gint ett_rrc_T_r8_01 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_19 = -1;
static gint ett_rrc_T_criticalExtensions_15 = -1;
static gint ett_rrc_T_r9_01 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_20 = -1;
static gint ett_rrc_T_criticalExtensions_16 = -1;
static gint ett_rrc_T_r10_01 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_21 = -1;
static gint ett_rrc_T_criticalExtensions_17 = -1;
static gint ett_rrc_T_r11_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_22 = -1;
static gint ett_rrc_T_criticalExtensions_18 = -1;
static gint ett_rrc_CellUpdateConfirm_r3_IEs = -1;
static gint ett_rrc_T_modeSpecificTransChInfo = -1;
static gint ett_rrc_T_fdd = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo = -1;
static gint ett_rrc_T_fdd_01 = -1;
static gint ett_rrc_CellUpdateConfirm_v3a0ext = -1;
static gint ett_rrc_CellUpdateConfirm_v4b0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v590ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v5d0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_r4_IEs = -1;
static gint ett_rrc_T_modeSpecificTransChInfo_01 = -1;
static gint ett_rrc_T_fdd_02 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_01 = -1;
static gint ett_rrc_T_fdd_03 = -1;
static gint ett_rrc_CellUpdateConfirm_r5_IEs = -1;
static gint ett_rrc_T_modeSpecificTransChInfo_02 = -1;
static gint ett_rrc_T_fdd_04 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_02 = -1;
static gint ett_rrc_T_fdd_05 = -1;
static gint ett_rrc_CellUpdateConfirm_r6_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v690ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v6b0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_r7_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_r7_add_ext_IEs = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_23 = -1;
static gint ett_rrc_CellUpdateConfirm_v780ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v7d0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v7f0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v7g0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_r8_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v860ext_IEs = -1;
static gint ett_rrc_T_rab_InformationSetup = -1;
static gint ett_rrc_CellUpdateConfirm_v890ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v8a0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_r9_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v950ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_v9c0ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_r10_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_vb50ext_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_r11_IEs = -1;
static gint ett_rrc_CellUpdateConfirm_CCCH = -1;
static gint ett_rrc_T_r3_05 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_03 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_24 = -1;
static gint ett_rrc_T_later_than_r3_04 = -1;
static gint ett_rrc_T_criticalExtensions_19 = -1;
static gint ett_rrc_T_r4_01 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_04 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_25 = -1;
static gint ett_rrc_T_criticalExtensions_20 = -1;
static gint ett_rrc_T_r5_01 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_05 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_nonCriticalExtensions_26 = -1;
static gint ett_rrc_T_criticalExtensions_21 = -1;
static gint ett_rrc_T_r6_02 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_nonCriticalExtensions_27 = -1;
static gint ett_rrc_T_criticalExtensions_22 = -1;
static gint ett_rrc_T_r7_02 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_28 = -1;
static gint ett_rrc_T_criticalExtensions_23 = -1;
static gint ett_rrc_T_r8_02 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_29 = -1;
static gint ett_rrc_T_criticalExtensions_24 = -1;
static gint ett_rrc_T_r9_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_30 = -1;
static gint ett_rrc_T_criticalExtensions_25 = -1;
static gint ett_rrc_T_r10_02 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_nonCriticalExtensions_31 = -1;
static gint ett_rrc_T_criticalExtensions_26 = -1;
static gint ett_rrc_T_r11_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_32 = -1;
static gint ett_rrc_T_criticalExtensions_27 = -1;
static gint ett_rrc_CounterCheck = -1;
static gint ett_rrc_T_r3_06 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_33 = -1;
static gint ett_rrc_T_later_than_r3_05 = -1;
static gint ett_rrc_T_criticalExtensions_28 = -1;
static gint ett_rrc_CounterCheck_r3_IEs = -1;
static gint ett_rrc_CounterCheckResponse = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_34 = -1;
static gint ett_rrc_DownlinkDirectTransfer = -1;
static gint ett_rrc_T_r3_07 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_11 = -1;
static gint ett_rrc_T_nonCriticalExtensions_35 = -1;
static gint ett_rrc_T_later_than_r3_06 = -1;
static gint ett_rrc_T_criticalExtensions_29 = -1;
static gint ett_rrc_DownlinkDirectTransfer_r3_IEs = -1;
static gint ett_rrc_ETWSPrimaryNotificationWithSecurity = -1;
static gint ett_rrc_T_nonCriticalExtensions_36 = -1;
static gint ett_rrc_HandoverToUTRANCommand = -1;
static gint ett_rrc_T_r3_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_37 = -1;
static gint ett_rrc_T_criticalExtensions_30 = -1;
static gint ett_rrc_T_r4_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_38 = -1;
static gint ett_rrc_T_criticalExtensions_31 = -1;
static gint ett_rrc_T_r5_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_39 = -1;
static gint ett_rrc_T_criticalExtensions_32 = -1;
static gint ett_rrc_T_r6_03 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_40 = -1;
static gint ett_rrc_T_criticalExtensions_33 = -1;
static gint ett_rrc_T_r7_03 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v820NonCriticalExtensions = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_41 = -1;
static gint ett_rrc_T_criticalExtensions_34 = -1;
static gint ett_rrc_T_r8_03 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_42 = -1;
static gint ett_rrc_T_criticalExtensions_35 = -1;
static gint ett_rrc_T_r9_03 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_43 = -1;
static gint ett_rrc_HandoverToUTRANCommand_r3_IEs = -1;
static gint ett_rrc_T_specificationMode = -1;
static gint ett_rrc_T_complete = -1;
static gint ett_rrc_T_modeSpecificInfo = -1;
static gint ett_rrc_T_fdd_06 = -1;
static gint ett_rrc_T_preconfiguration = -1;
static gint ett_rrc_T_preConfigMode = -1;
static gint ett_rrc_T_defaultConfig = -1;
static gint ett_rrc_T_modeSpecificInfo_01 = -1;
static gint ett_rrc_T_fdd_07 = -1;
static gint ett_rrc_T_tdd = -1;
static gint ett_rrc_HandoverToUTRANCommand_r4_IEs = -1;
static gint ett_rrc_T_specificationMode_01 = -1;
static gint ett_rrc_T_complete_01 = -1;
static gint ett_rrc_T_modeSpecificInfo_02 = -1;
static gint ett_rrc_T_fdd_08 = -1;
static gint ett_rrc_T_preconfiguration_01 = -1;
static gint ett_rrc_T_preConfigMode_01 = -1;
static gint ett_rrc_T_defaultConfig_01 = -1;
static gint ett_rrc_T_modeSpecificInfo_03 = -1;
static gint ett_rrc_T_fdd_09 = -1;
static gint ett_rrc_T_tdd_01 = -1;
static gint ett_rrc_T_tdd384 = -1;
static gint ett_rrc_T_tdd128 = -1;
static gint ett_rrc_HandoverToUTRANCommand_r5_IEs = -1;
static gint ett_rrc_T_specificationMode_02 = -1;
static gint ett_rrc_T_complete_02 = -1;
static gint ett_rrc_T_modeSpecificInfo_04 = -1;
static gint ett_rrc_T_fdd_10 = -1;
static gint ett_rrc_T_preconfiguration_02 = -1;
static gint ett_rrc_T_preConfigMode_02 = -1;
static gint ett_rrc_T_defaultConfig_02 = -1;
static gint ett_rrc_T_modeSpecificInfo_05 = -1;
static gint ett_rrc_T_fdd_11 = -1;
static gint ett_rrc_T_tdd_02 = -1;
static gint ett_rrc_T_tdd384_01 = -1;
static gint ett_rrc_T_tdd128_01 = -1;
static gint ett_rrc_HandoverToUTRANCommand_r6_IEs = -1;
static gint ett_rrc_T_specificationMode_03 = -1;
static gint ett_rrc_T_complete_03 = -1;
static gint ett_rrc_T_preconfiguration_03 = -1;
static gint ett_rrc_T_preConfigMode_03 = -1;
static gint ett_rrc_T_defaultConfig_03 = -1;
static gint ett_rrc_T_modeSpecificInfo_06 = -1;
static gint ett_rrc_T_fdd_12 = -1;
static gint ett_rrc_T_tdd_03 = -1;
static gint ett_rrc_T_tdd384_02 = -1;
static gint ett_rrc_T_tdd128_02 = -1;
static gint ett_rrc_HandoverToUTRANCommand_v6b0ext_IEs = -1;
static gint ett_rrc_HandoverToUTRANCommand_r7_IEs = -1;
static gint ett_rrc_T_specificationMode_04 = -1;
static gint ett_rrc_T_complete_04 = -1;
static gint ett_rrc_T_preconfiguration_04 = -1;
static gint ett_rrc_T_preConfigMode_04 = -1;
static gint ett_rrc_T_defaultConfig_04 = -1;
static gint ett_rrc_T_modeSpecificInfo_07 = -1;
static gint ett_rrc_T_fdd_13 = -1;
static gint ett_rrc_T_tdd_04 = -1;
static gint ett_rrc_T_tdd384_03 = -1;
static gint ett_rrc_T_tdd128_03 = -1;
static gint ett_rrc_T_tdd768 = -1;
static gint ett_rrc_HandoverToUTRANCommand_v780ext_IEs = -1;
static gint ett_rrc_HandoverToUTRANCommand_v7d0ext_IEs = -1;
static gint ett_rrc_HandoverToUTRANCommand_r8_IEs = -1;
static gint ett_rrc_T_specificationMode_05 = -1;
static gint ett_rrc_T_complete_05 = -1;
static gint ett_rrc_T_preconfiguration_05 = -1;
static gint ett_rrc_T_preConfigMode_05 = -1;
static gint ett_rrc_T_defaultConfig_05 = -1;
static gint ett_rrc_T_modeSpecificInfo_08 = -1;
static gint ett_rrc_T_fdd_14 = -1;
static gint ett_rrc_T_tdd_05 = -1;
static gint ett_rrc_T_tdd384_04 = -1;
static gint ett_rrc_T_tdd128_04 = -1;
static gint ett_rrc_T_tdd768_01 = -1;
static gint ett_rrc_HandoverToUTRANCommand_v820ext_IEs = -1;
static gint ett_rrc_HandoverToUTRANCommand_v890ext_IEs = -1;
static gint ett_rrc_HandoverToUTRANCommand_v8a0ext_IEs = -1;
static gint ett_rrc_HandoverToUTRANCommand_r9_IEs = -1;
static gint ett_rrc_T_specificationMode_06 = -1;
static gint ett_rrc_T_complete_06 = -1;
static gint ett_rrc_T_preconfiguration_06 = -1;
static gint ett_rrc_T_preConfigMode_06 = -1;
static gint ett_rrc_T_defaultConfig_06 = -1;
static gint ett_rrc_T_modeSpecificInfo_09 = -1;
static gint ett_rrc_T_fdd_15 = -1;
static gint ett_rrc_T_tdd_06 = -1;
static gint ett_rrc_T_tdd384_05 = -1;
static gint ett_rrc_T_tdd128_05 = -1;
static gint ett_rrc_T_tdd768_02 = -1;
static gint ett_rrc_HandoverToUTRANCommand_v9c0ext_IEs = -1;
static gint ett_rrc_HandoverToUTRANCommand_LaterCriticalExtensions = -1;
static gint ett_rrc_T_r10_03 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_nonCriticalExtensions_44 = -1;
static gint ett_rrc_T_criticalExtensions_36 = -1;
static gint ett_rrc_T_r11_03 = -1;
static gint ett_rrc_T_nonCriticalExtensions_45 = -1;
static gint ett_rrc_T_criticalExtensions_37 = -1;
static gint ett_rrc_HandoverToUTRANCommand_r10_IEs = -1;
static gint ett_rrc_T_specificationMode_07 = -1;
static gint ett_rrc_T_complete_07 = -1;
static gint ett_rrc_T_preconfiguration_07 = -1;
static gint ett_rrc_T_preConfigMode_07 = -1;
static gint ett_rrc_T_defaultConfig_07 = -1;
static gint ett_rrc_T_modeSpecificInfo_10 = -1;
static gint ett_rrc_T_fdd_16 = -1;
static gint ett_rrc_T_tdd_07 = -1;
static gint ett_rrc_T_tdd384_06 = -1;
static gint ett_rrc_T_tdd128_06 = -1;
static gint ett_rrc_T_tdd768_03 = -1;
static gint ett_rrc_HandoverToUTRANCommand_r11_IEs = -1;
static gint ett_rrc_T_specificationMode_08 = -1;
static gint ett_rrc_T_complete_08 = -1;
static gint ett_rrc_T_preconfiguration_08 = -1;
static gint ett_rrc_T_preConfigMode_08 = -1;
static gint ett_rrc_T_defaultConfig_08 = -1;
static gint ett_rrc_T_modeSpecificInfo_11 = -1;
static gint ett_rrc_T_fdd_17 = -1;
static gint ett_rrc_T_tdd_08 = -1;
static gint ett_rrc_T_tdd384_07 = -1;
static gint ett_rrc_T_tdd128_07 = -1;
static gint ett_rrc_T_tdd768_04 = -1;
static gint ett_rrc_HandoverToUTRANComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_12 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_46 = -1;
static gint ett_rrc_HandoverToUTRANComplete_va40ext = -1;
static gint ett_rrc_HandoverToUTRANComplete_vb50ext_IEs = -1;
static gint ett_rrc_InitialDirectTransfer = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_13 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_47 = -1;
static gint ett_rrc_InitialDirectTransfer_v3a0ext = -1;
static gint ett_rrc_InitialDirectTransfer_v590ext = -1;
static gint ett_rrc_InitialDirectTransfer_v690ext_IEs = -1;
static gint ett_rrc_InitialDirectTransfer_v770ext_IEs = -1;
static gint ett_rrc_InitialDirectTransfer_v860ext_IEs = -1;
static gint ett_rrc_InitialDirectTransfer_r3_add_ext_IEs = -1;
static gint ett_rrc_T_nonCriticalExtensions_48 = -1;
static gint ett_rrc_InitialDirectTransfer_v7g0ext_IEs = -1;
static gint ett_rrc_InitialDirectTransfer_vb50ext_IEs = -1;
static gint ett_rrc_HandoverFromUTRANCommand_GSM = -1;
static gint ett_rrc_T_r3_09 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_49 = -1;
static gint ett_rrc_T_later_than_r3_07 = -1;
static gint ett_rrc_T_criticalExtensions_38 = -1;
static gint ett_rrc_T_r6_04 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_50 = -1;
static gint ett_rrc_T_criticalExtensions_39 = -1;
static gint ett_rrc_HandoverFromUTRANCommand_GSM_r3_IEs = -1;
static gint ett_rrc_T_gsm_message = -1;
static gint ett_rrc_T_single_GSM_Message_r3 = -1;
static gint ett_rrc_T_gsm_MessageList_r3 = -1;
static gint ett_rrc_HandoverFromUTRANCommand_GSM_r6_IEs = -1;
static gint ett_rrc_T_gsm_message_01 = -1;
static gint ett_rrc_T_single_GSM_Message_r6 = -1;
static gint ett_rrc_T_gsm_MessageList_r6 = -1;
static gint ett_rrc_T_geran_SystemInfoType_01 = -1;
static gint ett_rrc_HandoverFromUTRANCommand_GSM_v690ext_IEs = -1;
static gint ett_rrc_T_geran_SystemInfoType_02 = -1;
static gint ett_rrc_HandoverFromUTRANCommand_GSM_v860ext_IEs = -1;
static gint ett_rrc_HandoverFromUTRANCommand_GERANIu = -1;
static gint ett_rrc_T_handoverFromUTRANCommand_GERANIu = -1;
static gint ett_rrc_T_r5_03 = -1;
static gint ett_rrc_T_nonCriticalExtensions_51 = -1;
static gint ett_rrc_T_later_than_r5 = -1;
static gint ett_rrc_T_criticalExtensions_40 = -1;
static gint ett_rrc_HandoverFromUTRANCommand_GERANIu_r5_IEs = -1;
static gint ett_rrc_T_geranIu_Message = -1;
static gint ett_rrc_T_single_GERANIu_Message = -1;
static gint ett_rrc_T_geranIu_MessageList = -1;
static gint ett_rrc_HandoverFromUTRANCommand_CDMA2000 = -1;
static gint ett_rrc_T_r3_10 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_15 = -1;
static gint ett_rrc_T_nonCriticalExtensions_52 = -1;
static gint ett_rrc_T_later_than_r3_08 = -1;
static gint ett_rrc_T_criticalExtensions_41 = -1;
static gint ett_rrc_HandoverFromUTRANCommand_CDMA2000_r3_IEs = -1;
static gint ett_rrc_HandoverFromUTRANCommand_EUTRA = -1;
static gint ett_rrc_T_criticalExtensions_42 = -1;
static gint ett_rrc_T_r8_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_53 = -1;
static gint ett_rrc_T_criticalExtensions_43 = -1;
static gint ett_rrc_T_r11_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_54 = -1;
static gint ett_rrc_T_criticalExtensions_44 = -1;
static gint ett_rrc_HandoverFromUTRANCommand_EUTRA_r8_IEs = -1;
static gint ett_rrc_HandoverFromUTRANCommand_EUTRA_r11_IEs = -1;
static gint ett_rrc_HandoverFromUTRANFailure = -1;
static gint ett_rrc_T_interRATMessage = -1;
static gint ett_rrc_T_gsm = -1;
static gint ett_rrc_T_cdma2000 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_16 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_55 = -1;
static gint ett_rrc_HandoverFromUtranFailure_v590ext_IEs = -1;
static gint ett_rrc_HandoverFromUtranFailure_v860ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo = -1;
static gint ett_rrc_T_predefinedConfigStatusList = -1;
static gint ett_rrc_T_uE_SecurityInformation = -1;
static gint ett_rrc_T_ue_CapabilityContainer = -1;
static gint ett_rrc_T_v390NonCriticalExtensions = -1;
static gint ett_rrc_T_present_01 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_17 = -1;
static gint ett_rrc_T_v3g0NonCriticalExtensions = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_10 = -1;
static gint ett_rrc_InterRATHandoverInfo_v390ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v3a0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v3d0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v3g0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_r3_add_ext_IEs = -1;
static gint ett_rrc_T_v7e0NonCriticalExtensions = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_56 = -1;
static gint ett_rrc_InterRATHandoverInfo_v4b0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v4d0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v590ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v690ext1_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v690ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_NonCriticalExtension_v6b0_IEs = -1;
static gint ett_rrc_T_v6e0NonCriticalExtensions = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v790nonCriticalExtensions = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v880NonCriticalExtensions = -1;
static gint ett_rrc_T_v920NonCriticalExtensions = -1;
static gint ett_rrc_T_v8b0NonCriticalExtensions = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_va80NonCriticalExtensions = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_57 = -1;
static gint ett_rrc_InterRATHandoverInfo_v6b0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v6e0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v770ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v790ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v7e0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v7f0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v860ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v880ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v920ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v8b0ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_v950ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_va40ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfoBand_va40ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_va80ext_IEs = -1;
static gint ett_rrc_InterRATHandoverInfo_vb50ext_IEs = -1;
static gint ett_rrc_MeasurementControl = -1;
static gint ett_rrc_T_r3_11 = -1;
static gint ett_rrc_T_v390nonCriticalExtensions = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_18 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v5b0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_58 = -1;
static gint ett_rrc_T_later_than_r3_09 = -1;
static gint ett_rrc_T_criticalExtensions_45 = -1;
static gint ett_rrc_T_r4_03 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v5b0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_59 = -1;
static gint ett_rrc_T_later_than_r4 = -1;
static gint ett_rrc_T_criticalExtensions_46 = -1;
static gint ett_rrc_T_r6_05 = -1;
static gint ett_rrc_T_v6a0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_60 = -1;
static gint ett_rrc_T_criticalExtensions_47 = -1;
static gint ett_rrc_T_r7_04 = -1;
static gint ett_rrc_T_v7b0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_61 = -1;
static gint ett_rrc_T_criticalExtensions_48 = -1;
static gint ett_rrc_T_r8_05 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_nonCriticalExtensions_62 = -1;
static gint ett_rrc_T_criticalExtensions_49 = -1;
static gint ett_rrc_T_r9_04 = -1;
static gint ett_rrc_T_v970NonCriticalExtensions = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_63 = -1;
static gint ett_rrc_T_criticalExtensions_50 = -1;
static gint ett_rrc_T_r10_04 = -1;
static gint ett_rrc_T_vaa0NonCriticalExtensions = -1;
static gint ett_rrc_T_vab0NonCriticalExtensions = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_64 = -1;
static gint ett_rrc_T_criticalExtensions_51 = -1;
static gint ett_rrc_T_r11_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_65 = -1;
static gint ett_rrc_T_criticalExtensions_52 = -1;
static gint ett_rrc_MeasurementControl_r3_IEs = -1;
static gint ett_rrc_MeasurementControl_v390ext = -1;
static gint ett_rrc_MeasurementControl_v3a0ext = -1;
static gint ett_rrc_MeasurementControl_r4_IEs = -1;
static gint ett_rrc_MeasurementControl_v590ext_IEs = -1;
static gint ett_rrc_T_measurementCommand_v590ext = -1;
static gint ett_rrc_MeasurementControl_v5b0ext_IEs = -1;
static gint ett_rrc_MeasurementControl_r6_IEs = -1;
static gint ett_rrc_MeasurementControl_v6a0ext_IEs = -1;
static gint ett_rrc_MeasurementControl_r7_IEs = -1;
static gint ett_rrc_MeasurementControl_v7b0ext_IEs = -1;
static gint ett_rrc_MeasurementControl_r8_IEs = -1;
static gint ett_rrc_MeasurementControl_v8a0ext_IEs = -1;
static gint ett_rrc_MeasurementControl_r9_IEs = -1;
static gint ett_rrc_MeasurementControl_v970ext_IEs = -1;
static gint ett_rrc_MeasurementControl_r10_IEs = -1;
static gint ett_rrc_MeasurementControl_vaa0ext_IEs = -1;
static gint ett_rrc_MeasurementControl_r11_IEs = -1;
static gint ett_rrc_MeasurementControl_vb50ext_IEs = -1;
static gint ett_rrc_MeasurementControlFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_19 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_66 = -1;
static gint ett_rrc_MeasurementControlFailure_v590ext_IEs = -1;
static gint ett_rrc_MeasurementReport = -1;
static gint ett_rrc_T_v390nonCriticalExtensions_01 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_20 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_v5b0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v920NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v970NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_67 = -1;
static gint ett_rrc_MeasurementReport_v390ext = -1;
static gint ett_rrc_MeasurementReport_v4b0ext_IEs = -1;
static gint ett_rrc_MeasurementReport_v590ext_IEs = -1;
static gint ett_rrc_MeasurementReport_v5b0ext_IEs = -1;
static gint ett_rrc_MeasurementReport_v690ext_IEs = -1;
static gint ett_rrc_MeasurementReport_v770ext_IEs = -1;
static gint ett_rrc_MeasurementReport_v860ext_IEs = -1;
static gint ett_rrc_MeasurementReport_v920ext_IEs = -1;
static gint ett_rrc_MeasurementReport_v970ext_IEs = -1;
static gint ett_rrc_MeasurementReport_va40ext_IEs = -1;
static gint ett_rrc_MeasurementReport_vb50ext_IEs = -1;
static gint ett_rrc_PagingType1 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_21 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_68 = -1;
static gint ett_rrc_PagingType1_v590ext_IEs = -1;
static gint ett_rrc_PagingType1_v860ext_IEs = -1;
static gint ett_rrc_PagingType2 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_22 = -1;
static gint ett_rrc_T_nonCriticalExtensions_69 = -1;
static gint ett_rrc_PhysicalChannelReconfiguration = -1;
static gint ett_rrc_T_r3_12 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_23 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtenstions = -1;
static gint ett_rrc_T_v590NonCriticalExtenstions_02 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_70 = -1;
static gint ett_rrc_T_later_than_r3_10 = -1;
static gint ett_rrc_T_criticalExtensions_53 = -1;
static gint ett_rrc_T_r4_04 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v590NonCriticalExtenstions_03 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_71 = -1;
static gint ett_rrc_T_criticalExtensions_54 = -1;
static gint ett_rrc_T_r5_04 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_72 = -1;
static gint ett_rrc_T_criticalExtensions_55 = -1;
static gint ett_rrc_T_r6_06 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_nonCriticalExtensions_73 = -1;
static gint ett_rrc_T_criticalExtensions_56 = -1;
static gint ett_rrc_T_r7_05 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_74 = -1;
static gint ett_rrc_T_criticalExtensions_57 = -1;
static gint ett_rrc_T_r8_06 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_75 = -1;
static gint ett_rrc_T_criticalExtensions_58 = -1;
static gint ett_rrc_T_r9_05 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_nonCriticalExtensions_76 = -1;
static gint ett_rrc_T_criticalExtensions_59 = -1;
static gint ett_rrc_T_r10_05 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_nonCriticalExtensions_77 = -1;
static gint ett_rrc_T_criticalExtensions_60 = -1;
static gint ett_rrc_T_r11_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_78 = -1;
static gint ett_rrc_T_criticalExtensions_61 = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r3_IEs = -1;
static gint ett_rrc_T_modeSpecificInfo_12 = -1;
static gint ett_rrc_T_fdd_18 = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v3a0ext = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v4b0ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v590ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r4_IEs = -1;
static gint ett_rrc_T_modeSpecificInfo_13 = -1;
static gint ett_rrc_T_fdd_19 = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r5_IEs = -1;
static gint ett_rrc_T_modeSpecificInfo_14 = -1;
static gint ett_rrc_T_fdd_20 = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r6_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v690ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v6b0ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r7_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v770ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v780ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v7d0ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v7f0ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v7g0ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r8_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v890ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v8a0ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r9_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_v950ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r10_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_vb50ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfiguration_r11_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfigurationComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_24 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_79 = -1;
static gint ett_rrc_PhysicalChannelReconfigurationComplete_v770ext_IEs = -1;
static gint ett_rrc_PhysicalChannelReconfigurationFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_25 = -1;
static gint ett_rrc_T_nonCriticalExtensions_80 = -1;
static gint ett_rrc_PhysicalSharedChannelAllocation = -1;
static gint ett_rrc_T_r3_13 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_26 = -1;
static gint ett_rrc_T_nonCriticalExtensions_81 = -1;
static gint ett_rrc_T_later_than_r3_11 = -1;
static gint ett_rrc_T_criticalExtensions_62 = -1;
static gint ett_rrc_T_r4_05 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_82 = -1;
static gint ett_rrc_T_criticalExtensions_63 = -1;
static gint ett_rrc_PhysicalSharedChannelAllocation_r3_IEs = -1;
static gint ett_rrc_PhysicalSharedChannelAllocation_r4_IEs = -1;
static gint ett_rrc_PhysicalSharedChannelAllocation_v690ext_IEs = -1;
static gint ett_rrc_PhysicalSharedChannelAllocation_v770ext_IEs = -1;
static gint ett_rrc_PUSCHCapacityRequest = -1;
static gint ett_rrc_T_allocationConfirmation = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_27 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_nonCriticalExtensions_83 = -1;
static gint ett_rrc_PUSCHCapacityRequest_v590ext = -1;
static gint ett_rrc_RadioBearerReconfiguration = -1;
static gint ett_rrc_T_r3_14 = -1;
static gint ett_rrc_T_v3aoNonCriticalExtensions = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_28 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_06 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_84 = -1;
static gint ett_rrc_T_later_than_r3_12 = -1;
static gint ett_rrc_T_criticalExtensions_64 = -1;
static gint ett_rrc_T_r4_06 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_07 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_17 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_nonCriticalExtensions_85 = -1;
static gint ett_rrc_T_criticalExtensions_65 = -1;
static gint ett_rrc_T_r5_05 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_08 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_18 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_nonCriticalExtensions_86 = -1;
static gint ett_rrc_T_criticalExtensions_66 = -1;
static gint ett_rrc_T_r6_07 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v6f0NonCriticalExtensions = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_nonCriticalExtensions_87 = -1;
static gint ett_rrc_T_criticalExtensions_67 = -1;
static gint ett_rrc_T_r7_06 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v790NonCriticalExtensions = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_88 = -1;
static gint ett_rrc_T_criticalExtensions_68 = -1;
static gint ett_rrc_T_r8_07 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_nonCriticalExtensions_89 = -1;
static gint ett_rrc_T_criticalExtensions_69 = -1;
static gint ett_rrc_T_r9_06 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_04 = -1;
static gint ett_rrc_T_nonCriticalExtensions_90 = -1;
static gint ett_rrc_T_criticalExtensions_70 = -1;
static gint ett_rrc_T_r10_06 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_vaa0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_nonCriticalExtensions_91 = -1;
static gint ett_rrc_T_criticalExtensions_71 = -1;
static gint ett_rrc_T_r11_07 = -1;
static gint ett_rrc_T_nonCriticalExtensions_92 = -1;
static gint ett_rrc_T_criticalExtensions_72 = -1;
static gint ett_rrc_RadioBearerReconfiguration_vaa0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_r3_IEs = -1;
static gint ett_rrc_T_dummy_01 = -1;
static gint ett_rrc_T_fdd_21 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_03 = -1;
static gint ett_rrc_T_fdd_22 = -1;
static gint ett_rrc_RadioBearerReconfiguration_v3a0ext = -1;
static gint ett_rrc_RadioBearerReconfiguration_v4b0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v590ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v5d0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_r4_IEs = -1;
static gint ett_rrc_T_dummy_02 = -1;
static gint ett_rrc_T_fdd_23 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_04 = -1;
static gint ett_rrc_T_fdd_24 = -1;
static gint ett_rrc_RadioBearerReconfiguration_r5_IEs = -1;
static gint ett_rrc_T_specificationMode_09 = -1;
static gint ett_rrc_T_complete_09 = -1;
static gint ett_rrc_T_dummy_03 = -1;
static gint ett_rrc_T_fdd_25 = -1;
static gint ett_rrc_T_preconfiguration_09 = -1;
static gint ett_rrc_T_preConfigMode_09 = -1;
static gint ett_rrc_T_defaultConfig_09 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_05 = -1;
static gint ett_rrc_T_fdd_26 = -1;
static gint ett_rrc_RadioBearerReconfiguration_r6_IEs = -1;
static gint ett_rrc_T_specificationMode_10 = -1;
static gint ett_rrc_T_complete_10 = -1;
static gint ett_rrc_T_preconfiguration_10 = -1;
static gint ett_rrc_T_preConfigMode_10 = -1;
static gint ett_rrc_T_defaultConfig_10 = -1;
static gint ett_rrc_RadioBearerReconfiguration_v690ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v6b0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v6f0ext_IEs = -1;
static gint ett_rrc_T_specificationMode_11 = -1;
static gint ett_rrc_T_complete_11 = -1;
static gint ett_rrc_RadioBearerReconfiguration_r7_IEs = -1;
static gint ett_rrc_T_specificationMode_12 = -1;
static gint ett_rrc_T_complete_12 = -1;
static gint ett_rrc_T_preconfiguration_11 = -1;
static gint ett_rrc_T_preConfigMode_11 = -1;
static gint ett_rrc_T_defaultConfig_11 = -1;
static gint ett_rrc_RadioBearerReconfiguration_v770ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v780ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v790ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v7d0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v7f0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v7g0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_r8_IEs = -1;
static gint ett_rrc_T_specificationMode_13 = -1;
static gint ett_rrc_T_complete_13 = -1;
static gint ett_rrc_T_preconfiguration_12 = -1;
static gint ett_rrc_T_preConfigMode_12 = -1;
static gint ett_rrc_T_defaultConfig_12 = -1;
static gint ett_rrc_RadioBearerReconfiguration_v890ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v8a0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_r9_IEs = -1;
static gint ett_rrc_T_specificationMode_14 = -1;
static gint ett_rrc_T_complete_14 = -1;
static gint ett_rrc_T_preconfiguration_13 = -1;
static gint ett_rrc_T_preConfigMode_13 = -1;
static gint ett_rrc_T_defaultConfig_13 = -1;
static gint ett_rrc_RadioBearerReconfiguration_v950ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_v9c0ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_r10_IEs = -1;
static gint ett_rrc_T_specificationMode_15 = -1;
static gint ett_rrc_T_complete_15 = -1;
static gint ett_rrc_T_preconfiguration_14 = -1;
static gint ett_rrc_T_preConfigMode_14 = -1;
static gint ett_rrc_T_defaultConfig_14 = -1;
static gint ett_rrc_RadioBearerReconfiguration_vb50ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfiguration_r11_IEs = -1;
static gint ett_rrc_T_specificationMode_16 = -1;
static gint ett_rrc_T_complete_16 = -1;
static gint ett_rrc_T_preconfiguration_15 = -1;
static gint ett_rrc_T_preConfigMode_15 = -1;
static gint ett_rrc_T_defaultConfig_15 = -1;
static gint ett_rrc_RadioBearerReconfigurationComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_29 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_nonCriticalExtensions_93 = -1;
static gint ett_rrc_RadioBearerReconfigurationComplete_v770ext_IEs = -1;
static gint ett_rrc_RadioBearerReconfigurationFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_30 = -1;
static gint ett_rrc_T_nonCriticalExtensions_94 = -1;
static gint ett_rrc_RadioBearerRelease = -1;
static gint ett_rrc_T_r3_15 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_31 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_19 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_nonCriticalExtensions_95 = -1;
static gint ett_rrc_T_later_than_r3_13 = -1;
static gint ett_rrc_T_criticalExtensions_73 = -1;
static gint ett_rrc_T_r4_07 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_17 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_20 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_nonCriticalExtensions_96 = -1;
static gint ett_rrc_T_criticalExtensions_74 = -1;
static gint ett_rrc_T_r5_06 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_21 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_17 = -1;
static gint ett_rrc_T_nonCriticalExtensions_97 = -1;
static gint ett_rrc_T_criticalExtensions_75 = -1;
static gint ett_rrc_T_r6_08 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_18 = -1;
static gint ett_rrc_T_nonCriticalExtensions_98 = -1;
static gint ett_rrc_T_criticalExtensions_76 = -1;
static gint ett_rrc_T_r7_07 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_99 = -1;
static gint ett_rrc_T_criticalExtensions_77 = -1;
static gint ett_rrc_T_r8_08 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_100 = -1;
static gint ett_rrc_T_criticalExtensions_78 = -1;
static gint ett_rrc_T_r9_07 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_v970NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_101 = -1;
static gint ett_rrc_T_criticalExtensions_79 = -1;
static gint ett_rrc_T_r10_07 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_nonCriticalExtensions_102 = -1;
static gint ett_rrc_T_criticalExtensions_80 = -1;
static gint ett_rrc_T_r11_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_103 = -1;
static gint ett_rrc_T_criticalExtensions_81 = -1;
static gint ett_rrc_RadioBearerRelease_r3_IEs = -1;
static gint ett_rrc_T_dummy_04 = -1;
static gint ett_rrc_T_fdd_27 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_06 = -1;
static gint ett_rrc_T_fdd_28 = -1;
static gint ett_rrc_RadioBearerRelease_v3a0ext = -1;
static gint ett_rrc_RadioBearerRelease_v4b0ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v590ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_r4_IEs = -1;
static gint ett_rrc_T_dummy_05 = -1;
static gint ett_rrc_T_fdd_29 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_07 = -1;
static gint ett_rrc_T_fdd_30 = -1;
static gint ett_rrc_RadioBearerRelease_r5_IEs = -1;
static gint ett_rrc_T_dummy_06 = -1;
static gint ett_rrc_T_fdd_31 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_08 = -1;
static gint ett_rrc_T_fdd_32 = -1;
static gint ett_rrc_RadioBearerRelease_v690ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_r6_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v6b0ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_r7_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v770ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v780ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v7d0ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v7f0ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v7g0ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_r8_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v890ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v8a0ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_r9_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v950ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v970ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_v9c0ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_r10_IEs = -1;
static gint ett_rrc_RadioBearerRelease_vb50ext_IEs = -1;
static gint ett_rrc_RadioBearerRelease_r11_IEs = -1;
static gint ett_rrc_RadioBearerReleaseComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_32 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_19 = -1;
static gint ett_rrc_T_nonCriticalExtensions_104 = -1;
static gint ett_rrc_RadioBearerReleaseComplete_v770ext_IEs = -1;
static gint ett_rrc_RadioBearerReleaseFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_33 = -1;
static gint ett_rrc_T_nonCriticalExtensions_105 = -1;
static gint ett_rrc_RadioBearerSetup = -1;
static gint ett_rrc_T_r3_16 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_34 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_18 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_09 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_22 = -1;
static gint ett_rrc_T_nonCriticalExtensions_106 = -1;
static gint ett_rrc_T_later_than_r3_14 = -1;
static gint ett_rrc_T_criticalExtensions_82 = -1;
static gint ett_rrc_T_r4_08 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_19 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_10 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_23 = -1;
static gint ett_rrc_T_nonCriticalExtensions_107 = -1;
static gint ett_rrc_T_criticalExtensions_83 = -1;
static gint ett_rrc_T_r5_07 = -1;
static gint ett_rrc_T_v5d0NonCriticalExtenstions_11 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_24 = -1;
static gint ett_rrc_T_nonCriticalExtensions_108 = -1;
static gint ett_rrc_T_criticalExtensions_84 = -1;
static gint ett_rrc_T_r6_09 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_109 = -1;
static gint ett_rrc_T_criticalExtensions_85 = -1;
static gint ett_rrc_T_r7_08 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v820NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_110 = -1;
static gint ett_rrc_T_criticalExtensions_86 = -1;
static gint ett_rrc_T_r8_09 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_nonCriticalExtensions_111 = -1;
static gint ett_rrc_T_criticalExtensions_87 = -1;
static gint ett_rrc_T_r9_08 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_112 = -1;
static gint ett_rrc_T_criticalExtensions_88 = -1;
static gint ett_rrc_T_r10_08 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_nonCriticalExtensions_113 = -1;
static gint ett_rrc_T_criticalExtensions_89 = -1;
static gint ett_rrc_T_r11_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_114 = -1;
static gint ett_rrc_T_criticalExtensions_90 = -1;
static gint ett_rrc_RadioBearerSetup_r3_IEs = -1;
static gint ett_rrc_T_dummy_07 = -1;
static gint ett_rrc_T_fdd_33 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_09 = -1;
static gint ett_rrc_T_fdd_34 = -1;
static gint ett_rrc_RadioBearerSetup_v3a0ext = -1;
static gint ett_rrc_RadioBearerSetup_v4b0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v590ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v5d0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_r4_IEs = -1;
static gint ett_rrc_T_dummy_08 = -1;
static gint ett_rrc_T_fdd_35 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_10 = -1;
static gint ett_rrc_T_fdd_36 = -1;
static gint ett_rrc_RadioBearerSetup_r5_IEs = -1;
static gint ett_rrc_T_dummy_09 = -1;
static gint ett_rrc_T_fdd_37 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_11 = -1;
static gint ett_rrc_T_fdd_38 = -1;
static gint ett_rrc_RadioBearerSetup_v690ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_r6_IEs = -1;
static gint ett_rrc_T_specificationMode_17 = -1;
static gint ett_rrc_T_complete_17 = -1;
static gint ett_rrc_T_dummy_10 = -1;
static gint ett_rrc_RadioBearerSetup_v6b0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_r7_IEs = -1;
static gint ett_rrc_T_specificationMode_18 = -1;
static gint ett_rrc_T_complete_18 = -1;
static gint ett_rrc_RadioBearerSetup_r7_add_ext_IEs = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_nonCriticalExtensions_115 = -1;
static gint ett_rrc_RadioBearerSetup_v780ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v7d0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v7f0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v7g0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_r8_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v820ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v890ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v8a0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_r9_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v950ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_v9c0ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_r10_IEs = -1;
static gint ett_rrc_RadioBearerSetup_vb50ext_IEs = -1;
static gint ett_rrc_RadioBearerSetup_r11_IEs = -1;
static gint ett_rrc_RadioBearerSetupComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_35 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_20 = -1;
static gint ett_rrc_T_nonCriticalExtensions_116 = -1;
static gint ett_rrc_RadioBearerSetupComplete_v770ext_IEs = -1;
static gint ett_rrc_RadioBearerSetupFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_36 = -1;
static gint ett_rrc_T_nonCriticalExtensions_117 = -1;
static gint ett_rrc_RRCConnectionReject = -1;
static gint ett_rrc_T_r3_17 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_37 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_25 = -1;
static gint ett_rrc_T_v6f0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_05 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_nonCriticalExtensions_118 = -1;
static gint ett_rrc_T_later_than_r3_15 = -1;
static gint ett_rrc_T_criticalExtensions_91 = -1;
static gint ett_rrc_RRCConnectionReject_r3_IEs = -1;
static gint ett_rrc_RRCConnectionReject_v690ext_IEs = -1;
static gint ett_rrc_RRCConnectionReject_v6f0ext_IEs = -1;
static gint ett_rrc_RRCConnectionReject_v860ext_IEs = -1;
static gint ett_rrc_RRCConnectionReject_va40ext_IEs = -1;
static gint ett_rrc_RRCConnectionReject_vb50ext_IEs = -1;
static gint ett_rrc_RRCConnectionRelease = -1;
static gint ett_rrc_T_r3_18 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_38 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_26 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_21 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_06 = -1;
static gint ett_rrc_T_nonCriticalExtensions_119 = -1;
static gint ett_rrc_T_later_than_r3_16 = -1;
static gint ett_rrc_T_criticalExtensions_92 = -1;
static gint ett_rrc_T_r4_09 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_27 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_22 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_nonCriticalExtensions_120 = -1;
static gint ett_rrc_T_criticalExtensions_93 = -1;
static gint ett_rrc_RRCConnectionRelease_r3_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_r4_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_v690ext_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_v770ext_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_v860ext_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_va40ext_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_vb50ext_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_CCCH = -1;
static gint ett_rrc_T_r3_19 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_39 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_28 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_121 = -1;
static gint ett_rrc_T_later_than_r3_17 = -1;
static gint ett_rrc_T_criticalExtensions_94 = -1;
static gint ett_rrc_T_r4_10 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_29 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_122 = -1;
static gint ett_rrc_T_criticalExtensions_95 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupReleaseInformation = -1;
static gint ett_rrc_T_criticalExtensions_96 = -1;
static gint ett_rrc_T_r5_08 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_30 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_123 = -1;
static gint ett_rrc_T_criticalExtensions_97 = -1;
static gint ett_rrc_RRCConnectionRelease_CCCH_r3_IEs = -1;
static gint ett_rrc_RRCConnectionRelease_CCCH_r4_IEs = -1;
static gint ett_rrc_RRCConnectionReleaseComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_40 = -1;
static gint ett_rrc_T_nonCriticalExtensions_124 = -1;
static gint ett_rrc_RRCConnectionRequest = -1;
static gint ett_rrc_T_v3d0NonCriticalExtensions = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_20 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_31 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v6e0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_23 = -1;
static gint ett_rrc_T_v7b0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_v7e0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v920NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v940NonCriticalExtensions = -1;
static gint ett_rrc_RRCConnectionRequest_v3d0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v4b0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v590ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v690ext_IEs = -1;
static gint ett_rrc_T_domainIndicator = -1;
static gint ett_rrc_T_cs_domain = -1;
static gint ett_rrc_RRCConnectionRequest_v6b0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v6e0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v770ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v7b0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v7e0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v7g0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v860ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v920ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v940ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_v9b0ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_NonCriticalExts_va40_IEs = -1;
static gint ett_rrc_T_v9b0NonCriticalExtensions = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_17 = -1;
static gint ett_rrc_T_nonCriticalExtensions_125 = -1;
static gint ett_rrc_RRCConnectionRequest_va40ext_IEs = -1;
static gint ett_rrc_RRCConnectionRequest_vb50ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup = -1;
static gint ett_rrc_T_r3_20 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_41 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_21 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_32 = -1;
static gint ett_rrc_T_nonCriticalExtensions_126 = -1;
static gint ett_rrc_T_later_than_r3_18 = -1;
static gint ett_rrc_T_criticalExtensions_98 = -1;
static gint ett_rrc_T_r4_11 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_22 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_33 = -1;
static gint ett_rrc_T_nonCriticalExtensions_127 = -1;
static gint ett_rrc_T_criticalExtensions_99 = -1;
static gint ett_rrc_T_r5_09 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_34 = -1;
static gint ett_rrc_T_nonCriticalExtensions_128 = -1;
static gint ett_rrc_T_criticalExtensions_100 = -1;
static gint ett_rrc_T_r6_10 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_129 = -1;
static gint ett_rrc_T_criticalExtensions_101 = -1;
static gint ett_rrc_T_r7_09 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_nonCriticalExtensions_130 = -1;
static gint ett_rrc_T_criticalExtensions_102 = -1;
static gint ett_rrc_T_r8_10 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_nonCriticalExtensions_131 = -1;
static gint ett_rrc_T_criticalExtensions_103 = -1;
static gint ett_rrc_T_r9_09 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_07 = -1;
static gint ett_rrc_T_nonCriticalExtensions_132 = -1;
static gint ett_rrc_T_criticalExtensions_104 = -1;
static gint ett_rrc_T_r10_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_133 = -1;
static gint ett_rrc_T_criticalExtensions_105 = -1;
static gint ett_rrc_T_r11_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_134 = -1;
static gint ett_rrc_T_criticalExtensions_106 = -1;
static gint ett_rrc_RRCConnectionSetup_r3_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_v4b0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_v590ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_r4_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_r5_IEs = -1;
static gint ett_rrc_T_specificationMode_19 = -1;
static gint ett_rrc_T_complete_19 = -1;
static gint ett_rrc_T_preconfiguration_16 = -1;
static gint ett_rrc_T_preConfigMode_16 = -1;
static gint ett_rrc_T_defaultConfig_16 = -1;
static gint ett_rrc_RRCConnectionSetup_v690ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_r6_IEs = -1;
static gint ett_rrc_T_specificationMode_20 = -1;
static gint ett_rrc_T_complete_20 = -1;
static gint ett_rrc_T_preconfiguration_17 = -1;
static gint ett_rrc_T_preConfigMode_17 = -1;
static gint ett_rrc_T_defaultConfig_17 = -1;
static gint ett_rrc_RRCConnectionSetup_v6b0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_r7_IEs = -1;
static gint ett_rrc_T_specificationMode_21 = -1;
static gint ett_rrc_T_complete_21 = -1;
static gint ett_rrc_T_preconfiguration_18 = -1;
static gint ett_rrc_T_preConfigMode_18 = -1;
static gint ett_rrc_T_defaultConfig_18 = -1;
static gint ett_rrc_RRCConnectionSetup_v780ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_v7d0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_r8_IEs = -1;
static gint ett_rrc_T_specificationMode_22 = -1;
static gint ett_rrc_T_complete_22 = -1;
static gint ett_rrc_T_preconfiguration_19 = -1;
static gint ett_rrc_T_preConfigMode_19 = -1;
static gint ett_rrc_T_defaultConfig_19 = -1;
static gint ett_rrc_RRCConnectionSetup_v890ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_v8a0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_r9_IEs = -1;
static gint ett_rrc_T_specificationMode_23 = -1;
static gint ett_rrc_T_complete_23 = -1;
static gint ett_rrc_T_preconfiguration_20 = -1;
static gint ett_rrc_T_preConfigMode_20 = -1;
static gint ett_rrc_T_defaultConfig_20 = -1;
static gint ett_rrc_RRCConnectionSetup_v950ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetup_r10_IEs = -1;
static gint ett_rrc_T_specificationMode_24 = -1;
static gint ett_rrc_T_complete_24 = -1;
static gint ett_rrc_T_preconfiguration_21 = -1;
static gint ett_rrc_T_preConfigMode_21 = -1;
static gint ett_rrc_T_defaultConfig_21 = -1;
static gint ett_rrc_RRCConnectionSetup_r11_IEs = -1;
static gint ett_rrc_T_specificationMode_25 = -1;
static gint ett_rrc_T_complete_25 = -1;
static gint ett_rrc_T_preconfiguration_22 = -1;
static gint ett_rrc_T_preConfigMode_22 = -1;
static gint ett_rrc_T_defaultConfig_22 = -1;
static gint ett_rrc_RRCConnectionSetupComplete = -1;
static gint ett_rrc_T_v370NonCriticalExtensions = -1;
static gint ett_rrc_T_v380NonCriticalExtensions = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_42 = -1;
static gint ett_rrc_T_v3g0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_23 = -1;
static gint ett_rrc_T_v5c0NonCriticalExtensions = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_35 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_24 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_18 = -1;
static gint ett_rrc_T_nonCriticalExtensions_135 = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v370ext = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v380ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v3a0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v3g0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_r3_add_ext_IEs = -1;
static gint ett_rrc_T_v680NonCriticalExtensions = -1;
static gint ett_rrc_T_v7e0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_nonCriticalExtensions_136 = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v4b0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v590ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v5c0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v650ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v680ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v690ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v770ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v7e0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_v7f0ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_va40ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupCompleteBand_va40ext_IEs = -1;
static gint ett_rrc_RRCConnectionSetupComplete_vb50ext_IEs = -1;
static gint ett_rrc_RRC_FailureInfo = -1;
static gint ett_rrc_T_r3_21 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_43 = -1;
static gint ett_rrc_T_nonCriticalExtensions_137 = -1;
static gint ett_rrc_T_criticalExtensions_107 = -1;
static gint ett_rrc_RRC_FailureInfo_r3_IEs = -1;
static gint ett_rrc_RRCStatus = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_44 = -1;
static gint ett_rrc_T_nonCriticalExtensions_138 = -1;
static gint ett_rrc_SecurityModeCommand = -1;
static gint ett_rrc_T_r3_22 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_45 = -1;
static gint ett_rrc_T_nonCriticalExtensions_139 = -1;
static gint ett_rrc_T_later_than_r3_19 = -1;
static gint ett_rrc_T_criticalExtensions_108 = -1;
static gint ett_rrc_T_r7_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_140 = -1;
static gint ett_rrc_T_criticalExtensions_109 = -1;
static gint ett_rrc_SecurityModeCommand_r3_IEs = -1;
static gint ett_rrc_SecurityModeCommand_r7_IEs = -1;
static gint ett_rrc_SecurityModeComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_46 = -1;
static gint ett_rrc_T_nonCriticalExtensions_141 = -1;
static gint ett_rrc_SecurityModeFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_47 = -1;
static gint ett_rrc_T_nonCriticalExtensions_142 = -1;
static gint ett_rrc_SignallingConnectionRelease = -1;
static gint ett_rrc_T_r3_23 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_48 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_nonCriticalExtensions_143 = -1;
static gint ett_rrc_T_later_than_r3_20 = -1;
static gint ett_rrc_T_criticalExtensions_110 = -1;
static gint ett_rrc_SignallingConnectionRelease_r3_IEs = -1;
static gint ett_rrc_SignallingConnectionRelease_va40ext_IEs = -1;
static gint ett_rrc_SignallingConnectionReleaseIndication = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_49 = -1;
static gint ett_rrc_T_v860nonCriticalExtentions = -1;
static gint ett_rrc_T_nonCriticalExtensions_144 = -1;
static gint ett_rrc_SignallingConnectionReleaseIndication_v860ext = -1;
static gint ett_rrc_SystemInformation_BCH = -1;
static gint ett_rrc_T_payload = -1;
static gint ett_rrc_T_lastAndFirst = -1;
static gint ett_rrc_T_lastAndComplete = -1;
static gint ett_rrc_T_lastAndCompleteAndFirst = -1;
static gint ett_rrc_T_completeAndFirst = -1;
static gint ett_rrc_SystemInformation_FACH = -1;
static gint ett_rrc_T_payload_01 = -1;
static gint ett_rrc_T_lastAndFirst_01 = -1;
static gint ett_rrc_T_lastAndComplete_01 = -1;
static gint ett_rrc_T_lastAndCompleteAndFirst_01 = -1;
static gint ett_rrc_T_completeAndFirst_01 = -1;
static gint ett_rrc_FirstSegment = -1;
static gint ett_rrc_FirstSegmentShort = -1;
static gint ett_rrc_SubsequentSegment = -1;
static gint ett_rrc_LastSegment = -1;
static gint ett_rrc_LastSegmentShort = -1;
static gint ett_rrc_CompleteSIB_List = -1;
static gint ett_rrc_CompleteSIB = -1;
static gint ett_rrc_CompleteSIBshort = -1;
static gint ett_rrc_SystemInformationChangeIndication = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_50 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_17 = -1;
static gint ett_rrc_T_nonCriticalExtensions_145 = -1;
static gint ett_rrc_SystemInformationChangeIndication_v860ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration = -1;
static gint ett_rrc_T_r3_24 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_51 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_24 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_36 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_25 = -1;
static gint ett_rrc_T_nonCriticalExtensions_146 = -1;
static gint ett_rrc_T_later_than_r3_21 = -1;
static gint ett_rrc_T_criticalExtensions_111 = -1;
static gint ett_rrc_T_r4_12 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_25 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_37 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_26 = -1;
static gint ett_rrc_T_nonCriticalExtensions_147 = -1;
static gint ett_rrc_T_criticalExtensions_112 = -1;
static gint ett_rrc_T_r5_10 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_38 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_27 = -1;
static gint ett_rrc_T_nonCriticalExtensions_148 = -1;
static gint ett_rrc_T_criticalExtensions_113 = -1;
static gint ett_rrc_T_r6_11 = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_28 = -1;
static gint ett_rrc_T_nonCriticalExtensions_149 = -1;
static gint ett_rrc_T_criticalExtensions_114 = -1;
static gint ett_rrc_T_r7_11 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_nonCriticalExtensions_150 = -1;
static gint ett_rrc_T_criticalExtensions_115 = -1;
static gint ett_rrc_T_r8_11 = -1;
static gint ett_rrc_T_v7d0NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_v8a0NonCriticalExtensions_09 = -1;
static gint ett_rrc_T_nonCriticalExtensions_151 = -1;
static gint ett_rrc_T_criticalExtensions_116 = -1;
static gint ett_rrc_T_r9_10 = -1;
static gint ett_rrc_T_v950NonCriticalExtensions_08 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_nonCriticalExtensions_152 = -1;
static gint ett_rrc_T_criticalExtensions_117 = -1;
static gint ett_rrc_T_r10_10 = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_19 = -1;
static gint ett_rrc_T_nonCriticalExtensions_153 = -1;
static gint ett_rrc_T_criticalExtensions_118 = -1;
static gint ett_rrc_T_r11_11 = -1;
static gint ett_rrc_T_nonCriticalExtensions_154 = -1;
static gint ett_rrc_T_criticalExtensions_119 = -1;
static gint ett_rrc_TransportChannelReconfiguration_r3_IEs = -1;
static gint ett_rrc_T_dummy_11 = -1;
static gint ett_rrc_T_fdd_39 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_12 = -1;
static gint ett_rrc_T_fdd_40 = -1;
static gint ett_rrc_TransportChannelReconfiguration_v3a0ext = -1;
static gint ett_rrc_TransportChannelReconfiguration_v4b0ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v590ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_r4_IEs = -1;
static gint ett_rrc_T_dummy_12 = -1;
static gint ett_rrc_T_fdd_41 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_13 = -1;
static gint ett_rrc_T_fdd_42 = -1;
static gint ett_rrc_TransportChannelReconfiguration_r5_IEs = -1;
static gint ett_rrc_T_dummy_13 = -1;
static gint ett_rrc_T_fdd_43 = -1;
static gint ett_rrc_T_modeSpecificPhysChInfo_14 = -1;
static gint ett_rrc_T_fdd_44 = -1;
static gint ett_rrc_TransportChannelReconfiguration_v690ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_r6_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v6b0ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_r7_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v770ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v780ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v7d0ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v7f0ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v7g0ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_r8_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v890ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v8a0ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_r9_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v950ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_v9c0ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_r10_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_vb50ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfiguration_r11_IEs = -1;
static gint ett_rrc_TransportChannelReconfigurationComplete = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_52 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_29 = -1;
static gint ett_rrc_T_nonCriticalExtensions_155 = -1;
static gint ett_rrc_TransportChannelReconfigurationComplete_v770ext_IEs = -1;
static gint ett_rrc_TransportChannelReconfigurationFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_53 = -1;
static gint ett_rrc_T_nonCriticalExtensions_156 = -1;
static gint ett_rrc_TransportFormatCombinationControl = -1;
static gint ett_rrc_T_modeSpecificInfo_15 = -1;
static gint ett_rrc_T_tdd_09 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_54 = -1;
static gint ett_rrc_T_v820NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_157 = -1;
static gint ett_rrc_TransportFormatCombinationControl_v820ext_IEs = -1;
static gint ett_rrc_TransportFormatCombinationControlFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_55 = -1;
static gint ett_rrc_T_nonCriticalExtensions_158 = -1;
static gint ett_rrc_UECapabilityEnquiry = -1;
static gint ett_rrc_T_r3_25 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_56 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_26 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_30 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_18 = -1;
static gint ett_rrc_T_nonCriticalExtensions_159 = -1;
static gint ett_rrc_T_later_than_r3_22 = -1;
static gint ett_rrc_T_criticalExtensions_120 = -1;
static gint ett_rrc_UECapabilityEnquiry_r3_IEs = -1;
static gint ett_rrc_UECapabilityEnquiry_v4b0ext_IEs = -1;
static gint ett_rrc_UECapabilityEnquiry_v590ext_IEs = -1;
static gint ett_rrc_UECapabilityEnquiry_v770ext_IEs = -1;
static gint ett_rrc_UECapabilityEnquiry_v860ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation = -1;
static gint ett_rrc_T_v370NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v380NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_57 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_v590NonCriticalExtensions_27 = -1;
static gint ett_rrc_T_v5c0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_39 = -1;
static gint ett_rrc_T_nonCriticalExtensions_160 = -1;
static gint ett_rrc_UECapabilityInformation_v370ext = -1;
static gint ett_rrc_UECapabilityInformation_v380ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation_v3a0ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation_r3_add_ext_IEs = -1;
static gint ett_rrc_T_v680NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v7e0NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v7f0NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_nonCriticalExtensions_161 = -1;
static gint ett_rrc_UECapabilityInformation_v4b0ext = -1;
static gint ett_rrc_UECapabilityInformation_v590ext = -1;
static gint ett_rrc_UECapabilityInformation_v5c0ext = -1;
static gint ett_rrc_UECapabilityInformation_v650ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation_v680ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation_v690ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation_v7e0ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation_v7f0ext_IEs = -1;
static gint ett_rrc_UECapabilityInformation_va40ext_IEs = -1;
static gint ett_rrc_UECapabilityInformationConfirm = -1;
static gint ett_rrc_T_r3_26 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_58 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_31 = -1;
static gint ett_rrc_T_nonCriticalExtensions_162 = -1;
static gint ett_rrc_T_later_than_r3_23 = -1;
static gint ett_rrc_T_criticalExtensions_121 = -1;
static gint ett_rrc_UECapabilityInformationConfirm_r3_IEs = -1;
static gint ett_rrc_UECapabilityInformationConfirm_v770ext_IEs = -1;
static gint ett_rrc_UplinkDirectTransfer = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_59 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_40 = -1;
static gint ett_rrc_T_v7g0NonCriticalExtensions_17 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_20 = -1;
static gint ett_rrc_T_nonCriticalExtensions_163 = -1;
static gint ett_rrc_UplinkDirectTransfer_v690ext_IEs = -1;
static gint ett_rrc_UplinkDirectTransfer_v7g0ext_IEs = -1;
static gint ett_rrc_UplinkDirectTransfer_vb50ext_IEs = -1;
static gint ett_rrc_UplinkPhysicalChannelControl = -1;
static gint ett_rrc_T_r3_27 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_60 = -1;
static gint ett_rrc_T_v4b0NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_noncriticalExtensions = -1;
static gint ett_rrc_T_later_than_r3_24 = -1;
static gint ett_rrc_T_criticalExtensions_122 = -1;
static gint ett_rrc_T_r4_13 = -1;
static gint ett_rrc_T_v4d0NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_41 = -1;
static gint ett_rrc_T_nonCriticalExtensions_164 = -1;
static gint ett_rrc_T_criticalExtensions_123 = -1;
static gint ett_rrc_T_r5_11 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_42 = -1;
static gint ett_rrc_T_v6a0NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_165 = -1;
static gint ett_rrc_T_criticalExtensions_124 = -1;
static gint ett_rrc_T_r7_12 = -1;
static gint ett_rrc_T_nonCriticalExtensions_166 = -1;
static gint ett_rrc_T_criticalExtensions_125 = -1;
static gint ett_rrc_UplinkPhysicalChannelControl_r3_IEs = -1;
static gint ett_rrc_UplinkPhysicalChannelControl_v4b0ext_IEs = -1;
static gint ett_rrc_UplinkPhysicalChannelControl_r4_IEs = -1;
static gint ett_rrc_T_tddOption = -1;
static gint ett_rrc_T_tdd384_08 = -1;
static gint ett_rrc_T_tdd128_08 = -1;
static gint ett_rrc_UplinkPhysicalChannelControl_r5_IEs = -1;
static gint ett_rrc_T_tddOption_01 = -1;
static gint ett_rrc_T_tdd384_09 = -1;
static gint ett_rrc_T_tdd128_09 = -1;
static gint ett_rrc_UplinkPhysicalChannelControl_v690ext_IEs = -1;
static gint ett_rrc_UplinkPhysicalChannelControl_v6a0ext_IEs = -1;
static gint ett_rrc_UplinkPhysicalChannelControl_r7_IEs = -1;
static gint ett_rrc_T_tddOption_02 = -1;
static gint ett_rrc_T_tdd384_10 = -1;
static gint ett_rrc_T_tdd768_05 = -1;
static gint ett_rrc_T_tdd128_10 = -1;
static gint ett_rrc_URAUpdate = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_61 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_32 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_19 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_15 = -1;
static gint ett_rrc_T_nonCriticalExtensions_167 = -1;
static gint ett_rrc_URAUpdate_r3_add_ext_IEs = -1;
static gint ett_rrc_T_nonCriticalExtensions_168 = -1;
static gint ett_rrc_UraUpdate_v770ext_IEs = -1;
static gint ett_rrc_URAUpdate_v7e0ext_IEs = -1;
static gint ett_rrc_URAUpdate_v860ext_IEs = -1;
static gint ett_rrc_URAUpdate_va40ext_IEs = -1;
static gint ett_rrc_URAUpdateConfirm = -1;
static gint ett_rrc_T_r3_28 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_62 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_43 = -1;
static gint ett_rrc_T_nonCriticalExtensions_169 = -1;
static gint ett_rrc_T_later_than_r3_25 = -1;
static gint ett_rrc_T_criticalExtensions_126 = -1;
static gint ett_rrc_T_r5_12 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_44 = -1;
static gint ett_rrc_T_nonCriticalExtensions_170 = -1;
static gint ett_rrc_T_criticalExtensions_127 = -1;
static gint ett_rrc_T_r7_13 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_20 = -1;
static gint ett_rrc_T_nonCriticalExtensions_171 = -1;
static gint ett_rrc_T_criticalExtensions_128 = -1;
static gint ett_rrc_URAUpdateConfirm_r3_IEs = -1;
static gint ett_rrc_URAUpdateConfirm_r5_IEs = -1;
static gint ett_rrc_URAUpdateConfirm_v690ext_IEs = -1;
static gint ett_rrc_URAUpdateConfirm_r7_IEs = -1;
static gint ett_rrc_URAUpdateConfirm_v860ext_IEs = -1;
static gint ett_rrc_URAUpdateConfirm_CCCH = -1;
static gint ett_rrc_T_r3_29 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_63 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_45 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_21 = -1;
static gint ett_rrc_T_nonCriticalExtensions_172 = -1;
static gint ett_rrc_T_later_than_r3_26 = -1;
static gint ett_rrc_T_criticalExtensions_129 = -1;
static gint ett_rrc_URAUpdateConfirm_CCCH_r3_IEs = -1;
static gint ett_rrc_UTRANMobilityInformation = -1;
static gint ett_rrc_T_r3_30 = -1;
static gint ett_rrc_T_v3a0NonCriticalExtensions_11 = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_64 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_46 = -1;
static gint ett_rrc_T_v860NonCriticalExtentions = -1;
static gint ett_rrc_T_nonCriticalExtensions_173 = -1;
static gint ett_rrc_T_later_than_r3_27 = -1;
static gint ett_rrc_T_criticalExtensions_130 = -1;
static gint ett_rrc_T_r5_13 = -1;
static gint ett_rrc_T_v690NonCriticalExtensions_47 = -1;
static gint ett_rrc_T_v860NonCriticalExtentions_01 = -1;
static gint ett_rrc_T_nonCriticalExtensions_174 = -1;
static gint ett_rrc_T_criticalExtensions_131 = -1;
static gint ett_rrc_T_r7_14 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_22 = -1;
static gint ett_rrc_T_vb50NonCriticalExtentions = -1;
static gint ett_rrc_T_nonCriticalExtensions_175 = -1;
static gint ett_rrc_T_criticalExtensions_132 = -1;
static gint ett_rrc_T_r11_12 = -1;
static gint ett_rrc_T_nonCriticalExtensions_176 = -1;
static gint ett_rrc_T_criticalExtensions_133 = -1;
static gint ett_rrc_UTRANMobilityInformation_r3_IEs = -1;
static gint ett_rrc_T_nonCriticalExtensions_177 = -1;
static gint ett_rrc_UTRANMobilityInformation_v3a0ext_IEs = -1;
static gint ett_rrc_UTRANMobilityInformation_r5_IEs = -1;
static gint ett_rrc_UtranMobilityInformation_v690ext_IEs = -1;
static gint ett_rrc_UTRANMobilityInformation_r7_IEs = -1;
static gint ett_rrc_UTRANMobilityInformation_v860ext1_IEs = -1;
static gint ett_rrc_UTRANMobilityInformation_v860ext2_IEs = -1;
static gint ett_rrc_UTRANMobilityInformation_vb50ext_IEs = -1;
static gint ett_rrc_UTRANMobilityInformation_r11_IEs = -1;
static gint ett_rrc_UTRANMobilityInformationConfirm = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_65 = -1;
static gint ett_rrc_T_v770NonCriticalExtension_01 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_16 = -1;
static gint ett_rrc_T_nonCriticalExtensions_178 = -1;
static gint ett_rrc_UTRANMobilityInformationConfirm_v770ext_IEs = -1;
static gint ett_rrc_UTRANMobilityInformationConfirm_va40ext_IEs = -1;
static gint ett_rrc_UTRANMobilityInformationFailure = -1;
static gint ett_rrc_T_laterNonCriticalExtensions_66 = -1;
static gint ett_rrc_T_nonCriticalExtensions_179 = -1;
static gint ett_rrc_MBMSAccessInformation = -1;
static gint ett_rrc_T_nonCriticalExtensions_180 = -1;
static gint ett_rrc_MBMSCommonPTMRBInformation = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_33 = -1;
static gint ett_rrc_T_v780NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_23 = -1;
static gint ett_rrc_T_nonCriticalExtensions_181 = -1;
static gint ett_rrc_MBMSCommonPTMRBInformation_v770ext_IEs = -1;
static gint ett_rrc_MBMSCommonPTMRBInformation_v780ext_IEs = -1;
static gint ett_rrc_MBMSCommonPTMRBInformation_v860ext_IEs = -1;
static gint ett_rrc_MBMSCurrentCellPTMRBInformation = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_34 = -1;
static gint ett_rrc_T_nonCriticalExtensions_182 = -1;
static gint ett_rrc_MBMSCurrentCellPTMRBInfo_v770ext_IEs = -1;
static gint ett_rrc_MBMSGeneralInformation = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_35 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_24 = -1;
static gint ett_rrc_T_v890NoncriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_183 = -1;
static gint ett_rrc_MBMSGeneralInformation_v6b0ext_IEs = -1;
static gint ett_rrc_MBMSGeneralInformation_v770ext_IEs = -1;
static gint ett_rrc_MBMSGeneralInformation_v860ext_IEs = -1;
static gint ett_rrc_MBMSGeneralInformation_v890ext_IEs = -1;
static gint ett_rrc_MBMSModificationRequest = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_13 = -1;
static gint ett_rrc_T_v6f0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_nonCriticalExtensions_184 = -1;
static gint ett_rrc_MBMSModificationRequest_v6b0ext_IEs = -1;
static gint ett_rrc_MBMSModificationRequest_v6f0ext_IEs = -1;
static gint ett_rrc_MBMSModifiedServicesInformation = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_36 = -1;
static gint ett_rrc_T_v7c0NonCriticalExtensions = -1;
static gint ett_rrc_T_nonCriticalExtensions_185 = -1;
static gint ett_rrc_MBMSModifiedServicesInformation_v770ext_IEs = -1;
static gint ett_rrc_MBMSModifiedServicesInformation_v7c0ext_IEs = -1;
static gint ett_rrc_MBMSNeighbouringCellPTMRBInformation = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_37 = -1;
static gint ett_rrc_T_nonCriticalExtensions_186 = -1;
static gint ett_rrc_MBMSNeighbouringCellPTMRBInformation_v770ext_IEs = -1;
static gint ett_rrc_MBMSSchedulingInformation = -1;
static gint ett_rrc_T_nonCriticalExtensions_187 = -1;
static gint ett_rrc_MBMSUnmodifiedServicesInformation = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_38 = -1;
static gint ett_rrc_T_nonCriticalExtensions_188 = -1;
static gint ett_rrc_MBMSUnmodifiedServicesInformation_v770ext_IEs = -1;
static gint ett_rrc_System_Information_Container = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_21 = -1;
static gint ett_rrc_T_nonCriticalExtensions_189 = -1;
static gint ett_rrc_System_Information_Container_vb50ext_IEs = -1;
static gint ett_rrc_LoggingMeasurementConfiguration = -1;
static gint ett_rrc_T_criticalExtensions_134 = -1;
static gint ett_rrc_T_r10_11 = -1;
static gint ett_rrc_T_nonCriticalExtensions_190 = -1;
static gint ett_rrc_T_criticalExtensions_135 = -1;
static gint ett_rrc_T_r11_13 = -1;
static gint ett_rrc_T_nonCriticalExtensions_191 = -1;
static gint ett_rrc_T_criticalExtensions_136 = -1;
static gint ett_rrc_LoggingMeasurementConfiguration_r10_IEs = -1;
static gint ett_rrc_LoggingMeasurementConfiguration_r11_IEs = -1;
static gint ett_rrc_UEInformationResponse = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_22 = -1;
static gint ett_rrc_T_nonCriticalExtensions_192 = -1;
static gint ett_rrc_UEInformationResponse_vb50ext_IEs = -1;
static gint ett_rrc_UEInformationRequest = -1;
static gint ett_rrc_T_criticalExtensions_137 = -1;
static gint ett_rrc_T_r10_12 = -1;
static gint ett_rrc_T_nonCriticalExtensions_193 = -1;
static gint ett_rrc_T_criticalExtensions_138 = -1;
static gint ett_rrc_T_r11_14 = -1;
static gint ett_rrc_T_nonCriticalExtensions_194 = -1;
static gint ett_rrc_T_criticalExtensions_139 = -1;
static gint ett_rrc_UEInformationRequest_r10_IEs = -1;
static gint ett_rrc_UEInformationRequest_r11_IEs = -1;
static gint ett_rrc_CN_DomainInformation = -1;
static gint ett_rrc_CN_DomainInformationFull = -1;
static gint ett_rrc_CN_DomainInformationList = -1;
static gint ett_rrc_CN_DomainInformationListFull = -1;
static gint ett_rrc_CN_DomainSysInfo = -1;
static gint ett_rrc_T_cn_Type = -1;
static gint ett_rrc_CN_DomainSysInfoList = -1;
static gint ett_rrc_CN_InformationInfo = -1;
static gint ett_rrc_CN_InformationInfo_r6 = -1;
static gint ett_rrc_CN_InformationInfoFull = -1;
static gint ett_rrc_DomainSpecificEAB_Parameters = -1;
static gint ett_rrc_EAB_AccessClassBarredList = -1;
static gint ett_rrc_EAB_Configuration = -1;
static gint ett_rrc_EAB_Parameters = -1;
static gint ett_rrc_EAB_ParametersPerPLMN = -1;
static gint ett_rrc_EAB_ParametersPerPLMN_List = -1;
static gint ett_rrc_Ec_N0forANR = -1;
static gint ett_rrc_Gsm_map_IDNNS = -1;
static gint ett_rrc_T_routingbasis = -1;
static gint ett_rrc_T_localPTMSI = -1;
static gint ett_rrc_T_tMSIofsamePLMN = -1;
static gint ett_rrc_T_tMSIofdifferentPLMN = -1;
static gint ett_rrc_T_iMSIresponsetopaging = -1;
static gint ett_rrc_T_iMSIcauseUEinitiatedEvent = -1;
static gint ett_rrc_T_iMEI = -1;
static gint ett_rrc_T_spare2_01 = -1;
static gint ett_rrc_T_spare1_01 = -1;
static gint ett_rrc_IMEI = -1;
static gint ett_rrc_IMSI_GSM_MAP = -1;
static gint ett_rrc_IntraDomainNasNodeSelector = -1;
static gint ett_rrc_T_version = -1;
static gint ett_rrc_T_release99 = -1;
static gint ett_rrc_T_cn_Type_01 = -1;
static gint ett_rrc_T_later = -1;
static gint ett_rrc_LAI = -1;
static gint ett_rrc_LocationRegistrationAccessClassBarredList = -1;
static gint ett_rrc_LocationRegistrationParameters = -1;
static gint ett_rrc_MCC = -1;
static gint ett_rrc_MNC = -1;
static gint ett_rrc_MultiplePLMN_List_r6 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_5_OF_PLMN_IdentityWithOptionalMCC_r6 = -1;
static gint ett_rrc_PagingPermissionWithAccessControlForSharedNetwork = -1;
static gint ett_rrc_PagingPermissionWithAccessControlList = -1;
static gint ett_rrc_PagingPermissionWithAccessControlParameters = -1;
static gint ett_rrc_PLMN_Identity = -1;
static gint ett_rrc_PLMN_IdentityWithOptionalMCC_r6 = -1;
static gint ett_rrc_PLMN_Type = -1;
static gint ett_rrc_T_gsm_MAP = -1;
static gint ett_rrc_T_ansi_41 = -1;
static gint ett_rrc_T_gsm_MAP_and_ANSI_41 = -1;
static gint ett_rrc_RAB_Identity = -1;
static gint ett_rrc_RAI = -1;
static gint ett_rrc_AccessClassBarredList = -1;
static gint ett_rrc_CellAccessRestriction = -1;
static gint ett_rrc_CellAccessRestriction_v870ext = -1;
static gint ett_rrc_CellBarred = -1;
static gint ett_rrc_T_barred = -1;
static gint ett_rrc_CellIdentity_PerRL_List = -1;
static gint ett_rrc_CellIDListItem = -1;
static gint ett_rrc_CellSelectReselectInfoSIB_3_4 = -1;
static gint ett_rrc_T_cellSelectQualityMeasure = -1;
static gint ett_rrc_T_cpich_Ec_N0 = -1;
static gint ett_rrc_T_modeSpecificInfo_16 = -1;
static gint ett_rrc_T_fdd_45 = -1;
static gint ett_rrc_T_tdd_10 = -1;
static gint ett_rrc_CSG_DedicatedFrequencyInfoList = -1;
static gint ett_rrc_CSG_PSCSplitInfo = -1;
static gint ett_rrc_DomainSpecificAccessRestrictionForSharedNetwork_v670ext = -1;
static gint ett_rrc_DomainSpecificAccessRestrictionList_v670ext = -1;
static gint ett_rrc_DomainSpecificAccessRestrictionParam_v670ext = -1;
static gint ett_rrc_DomainSpecificAccessRestriction_v670ext = -1;
static gint ett_rrc_T_restriction = -1;
static gint ett_rrc_Mapping = -1;
static gint ett_rrc_Mapping_LCR_r4 = -1;
static gint ett_rrc_MappingFunctionParameter = -1;
static gint ett_rrc_MappingFunctionParameterList = -1;
static gint ett_rrc_MappingInfo = -1;
static gint ett_rrc_DedicatedPriorityInformation = -1;
static gint ett_rrc_T_action = -1;
static gint ett_rrc_T_configureDedicatedPriorities = -1;
static gint ett_rrc_DedicatedPriorityInformation_r11 = -1;
static gint ett_rrc_T_action_01 = -1;
static gint ett_rrc_T_configureDedicatedPriorities_01 = -1;
static gint ett_rrc_PriorityLevel = -1;
static gint ett_rrc_T_radioAccessTechnology = -1;
static gint ett_rrc_T_utraFDD = -1;
static gint ett_rrc_T_utraFDD_item = -1;
static gint ett_rrc_T_utraTDD = -1;
static gint ett_rrc_T_utraTDD_item = -1;
static gint ett_rrc_T_eutra = -1;
static gint ett_rrc_T_eutra_item = -1;
static gint ett_rrc_T_gsm_01 = -1;
static gint ett_rrc_PriorityLevel_r11 = -1;
static gint ett_rrc_T_radioAccessTechnology_01 = -1;
static gint ett_rrc_T_utraFDD_01 = -1;
static gint ett_rrc_T_utraFDD_item_01 = -1;
static gint ett_rrc_T_utraTDD_01 = -1;
static gint ett_rrc_T_utraTDD_item_01 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxNumEUTRAFreqs_OF_EARFCNRange = -1;
static gint ett_rrc_T_gsm_02 = -1;
static gint ett_rrc_PriorityLevelList = -1;
static gint ett_rrc_PriorityLevelList_r11 = -1;
static gint ett_rrc_RAT_FDD_Info = -1;
static gint ett_rrc_RAT_FDD_InfoList = -1;
static gint ett_rrc_RAT_TDD_Info = -1;
static gint ett_rrc_RAT_TDD_InfoList = -1;
static gint ett_rrc_URA_IdentityList = -1;
static gint ett_rrc_BackoffControlParams = -1;
static gint ett_rrc_CapabilityUpdateRequirement = -1;
static gint ett_rrc_CapabilityUpdateRequirement_r4_ext = -1;
static gint ett_rrc_CapabilityUpdateRequirement_r4 = -1;
static gint ett_rrc_CapabilityUpdateRequirement_r5 = -1;
static gint ett_rrc_CapabilityUpdateRequirement_v770ext = -1;
static gint ett_rrc_CapabilityUpdateRequirement_r7 = -1;
static gint ett_rrc_CapabilityUpdateRequirement_v860ext = -1;
static gint ett_rrc_CapabilityUpdateRequirement_r8 = -1;
static gint ett_rrc_CipheringModeCommand = -1;
static gint ett_rrc_CipheringModeCommand_r7 = -1;
static gint ett_rrc_CipheringModeInfo = -1;
static gint ett_rrc_CipheringModeInfo_r7 = -1;
static gint ett_rrc_CN_PagedUE_Identity = -1;
static gint ett_rrc_CompressedModeMeasCapability = -1;
static gint ett_rrc_CompressedModeMeasCapability_LCR_r4 = -1;
static gint ett_rrc_CompressedModeMeasCapability_v860ext = -1;
static gint ett_rrc_CompressedModeMeasCapability_v920ext = -1;
static gint ett_rrc_CompressedModeMeasCapability_va40ext = -1;
static gint ett_rrc_CompressedModeMeasCapabEUTRA = -1;
static gint ett_rrc_CompressedModeMeasCapabEUTRAExt = -1;
static gint ett_rrc_CompressedModeMeasCapabEUTRAList = -1;
static gint ett_rrc_CompressedModeMeasCapabEUTRAList2 = -1;
static gint ett_rrc_CompressedModeMeasCapabFDDList = -1;
static gint ett_rrc_CompressedModeMeasCapabFDDList2 = -1;
static gint ett_rrc_CompressedModeMeasCapabFDDList3 = -1;
static gint ett_rrc_CompressedModeMeasCapabFDDList_ext = -1;
static gint ett_rrc_CompressedModeMeasCapabFDD = -1;
static gint ett_rrc_CompressedModeMeasCapabFDD2 = -1;
static gint ett_rrc_CompressedModeMeasCapabFDD3 = -1;
static gint ett_rrc_CompressedModeMeasCapabFDD_ext = -1;
static gint ett_rrc_CompressedModeMeasCapabTDDList = -1;
static gint ett_rrc_CompressedModeMeasCapabTDD = -1;
static gint ett_rrc_CompressedModeMeasCapabGSMList = -1;
static gint ett_rrc_CompressedModeMeasCapabGSM = -1;
static gint ett_rrc_CompressedModeMeasCapabMC = -1;
static gint ett_rrc_CPCH_Parameters = -1;
static gint ett_rrc_CSG_ProximityIndicationCapability = -1;
static gint ett_rrc_DL_InformationPerSecondaryRL_List = -1;
static gint ett_rrc_DL_InformationPerSecondaryRL = -1;
static gint ett_rrc_T_e_RGCH_Info = -1;
static gint ett_rrc_DL_PhysChCapabilityFDD = -1;
static gint ett_rrc_DL_PhysChCapabilityFDD_v380ext = -1;
static gint ett_rrc_DL_PhysChCapabilityFDD_v770ext = -1;
static gint ett_rrc_DL_PhysChCapabilityFDD_v860ext = -1;
static gint ett_rrc_DL_PhysChCapabilityFDD_v920ext = -1;
static gint ett_rrc_DL_PhysChCapabilityFDD_va40ext = -1;
static gint ett_rrc_DL_PhysChCapabilityFDD_vb50ext = -1;
static gint ett_rrc_DL_PhysChCapabilityTDD = -1;
static gint ett_rrc_DL_PhysChCapabilityTDD_LCR_r4 = -1;
static gint ett_rrc_DL_PhysChCapabilityTDD_128_v770ext = -1;
static gint ett_rrc_DL_PhysChCapabilityTDD_128_v860ext = -1;
static gint ett_rrc_DL_PhysChCapabilityInfoTDD_128_va40ext = -1;
static gint ett_rrc_DL_PhysChCapabilityTDD_768 = -1;
static gint ett_rrc_T_tdd768_hspdsch = -1;
static gint ett_rrc_DL_PhysChCapabilityInfoTDD_768 = -1;
static gint ett_rrc_DL_TransChCapability = -1;
static gint ett_rrc_DRAC_SysInfo = -1;
static gint ett_rrc_DRAC_SysInfoList = -1;
static gint ett_rrc_FailureCauseWithProtErr = -1;
static gint ett_rrc_FailureCauseWithProtErrTrId = -1;
static gint ett_rrc_FrequencyBandsIndicatorSupport = -1;
static gint ett_rrc_T_modeSpecificInfo_17 = -1;
static gint ett_rrc_T_fdd_46 = -1;
static gint ett_rrc_T_tdd_11 = -1;
static gint ett_rrc_FrequencyBandsIndicatorTDD128 = -1;
static gint ett_rrc_FrequencyBandsIndicatorSupportTDD128 = -1;
static gint ett_rrc_FrequencyBandsRedirectionFDD = -1;
static gint ett_rrc_FrequencyBandsIndicatorFDD = -1;
static gint ett_rrc_GroupIdentityWithReleaseInformation = -1;
static gint ett_rrc_GroupReleaseInformation = -1;
static gint ett_rrc_GSM_Measurements = -1;
static gint ett_rrc_MultiflowCapabBandCombination = -1;
static gint ett_rrc_MultiflowCapabBandCombList = -1;
static gint ett_rrc_MultiflowCapability = -1;
static gint ett_rrc_MultiflowPerBandCapability = -1;
static gint ett_rrc_MultiflowNonContiguousCapability = -1;
static gint ett_rrc_IdleIntervalMeasCapabEUTRA = -1;
static gint ett_rrc_IdleIntervalMeasCapabEUTRAExtension = -1;
static gint ett_rrc_IdleIntervalMeasCapabEUTRAList = -1;
static gint ett_rrc_IdleIntervalMeasCapabEUTRAExtensionList = -1;
static gint ett_rrc_IMSI_and_ESN_DS_41 = -1;
static gint ett_rrc_InitialPriorityDelayList = -1;
static gint ett_rrc_InitialUE_Identity = -1;
static gint ett_rrc_IntegrityCheckInfo = -1;
static gint ett_rrc_IntegrityProtActivationInfo = -1;
static gint ett_rrc_IntegrityProtectionModeCommand = -1;
static gint ett_rrc_T_startIntegrityProtection = -1;
static gint ett_rrc_T_modify = -1;
static gint ett_rrc_IntegrityProtectionModeInfo = -1;
static gint ett_rrc_IntegrityProtectionModeInfo_r7 = -1;
static gint ett_rrc_MeasurementCapability = -1;
static gint ett_rrc_MeasurementCapabilityExt = -1;
static gint ett_rrc_MeasurementCapabilityExt2 = -1;
static gint ett_rrc_MeasurementCapabilityExt3 = -1;
static gint ett_rrc_MeasurementCapabilityExt4 = -1;
static gint ett_rrc_MeasurementCapabilityExt5 = -1;
static gint ett_rrc_MeasurementCapability_r4_ext = -1;
static gint ett_rrc_MeasurementCapability_v860ext = -1;
static gint ett_rrc_MeasurementCapability_v920ext = -1;
static gint ett_rrc_MeasurementCapability_va40ext = -1;
static gint ett_rrc_MeasurementCapability_vb50ext = -1;
static gint ett_rrc_MeasurementCapabilityTDD = -1;
static gint ett_rrc_MeasurementCapabilityTDD_vb50ext = -1;
static gint ett_rrc_NonContiguousMultiCellCombinationList = -1;
static gint ett_rrc_NonContiguousMultiCell = -1;
static gint ett_rrc_MultiRAT_Capability = -1;
static gint ett_rrc_MultiModeRAT_Capability_v590ext = -1;
static gint ett_rrc_MultiModeRAT_Capability_v680ext = -1;
static gint ett_rrc_MultiModeRAT_Capability_v770ext = -1;
static gint ett_rrc_MultiModeRAT_Capability_v860ext = -1;
static gint ett_rrc_MultiModeRAT_Capability_vb50ext = -1;
static gint ett_rrc_NeighCellSI_AcquisitionCapability = -1;
static gint ett_rrc_NetworkAssistedGANSS_Supported_List = -1;
static gint ett_rrc_NetworkAssistedGANSS_Supported_List_item = -1;
static gint ett_rrc_NetworkAssistedGANSS_Supported_List_v860ext = -1;
static gint ett_rrc_NetworkAssistedGANSS_Supported_List_v860ext_item = -1;
static gint ett_rrc_P_TMSI_and_RAI_GSM_MAP = -1;
static gint ett_rrc_PagingRecord = -1;
static gint ett_rrc_T_cn_Identity = -1;
static gint ett_rrc_T_utran_Identity = -1;
static gint ett_rrc_T_cn_OriginatedPage_connectedMode_UE = -1;
static gint ett_rrc_PagingRecord2_r5 = -1;
static gint ett_rrc_T_utran_SingleUE_Identity = -1;
static gint ett_rrc_T_cn_OriginatedPage_connectedMode_UE_01 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupIdentityWithReleaseInformation = -1;
static gint ett_rrc_PagingRecordList = -1;
static gint ett_rrc_PagingRecord2List_r5 = -1;
static gint ett_rrc_PDCP_Capability = -1;
static gint ett_rrc_T_supportForRfc2507 = -1;
static gint ett_rrc_PDCP_Capability_r4_ext = -1;
static gint ett_rrc_T_supportForRfc3095 = -1;
static gint ett_rrc_T_supported = -1;
static gint ett_rrc_PDCP_Capability_r5_ext = -1;
static gint ett_rrc_PDCP_Capability_r5_ext2 = -1;
static gint ett_rrc_PDCP_Capability_v770ext = -1;
static gint ett_rrc_PhysicalChannelCapability = -1;
static gint ett_rrc_T_fddPhysChCapability = -1;
static gint ett_rrc_T_tddPhysChCapability = -1;
static gint ett_rrc_PhysicalChannelCapability_v770ext = -1;
static gint ett_rrc_T_fddPhysChCapability_01 = -1;
static gint ett_rrc_T_tddPhysChCapability_384 = -1;
static gint ett_rrc_T_tddPhysChCapability_768 = -1;
static gint ett_rrc_T_tddPhysChCapability_128 = -1;
static gint ett_rrc_PhysicalChannelCapability_v860ext = -1;
static gint ett_rrc_T_fddPhysChCapability_02 = -1;
static gint ett_rrc_T_tddPhysChCapability_128_01 = -1;
static gint ett_rrc_PhysicalChannelCapability_v920ext = -1;
static gint ett_rrc_T_fddPhysChCapability_03 = -1;
static gint ett_rrc_PhysicalChannelCapability_va40ext = -1;
static gint ett_rrc_T_fddPhysChCapability_04 = -1;
static gint ett_rrc_T_tddPhysChCapability_128_02 = -1;
static gint ett_rrc_PhysicalChannelCapability_vb50ext = -1;
static gint ett_rrc_T_fddPhysChCapability_05 = -1;
static gint ett_rrc_PhysicalChannelCapabilityInfo_v770ext = -1;
static gint ett_rrc_T_tddPhysChCapability_768_01 = -1;
static gint ett_rrc_T_tddPhysChCapability_128_03 = -1;
static gint ett_rrc_PhysicalChannelCapability_LCR_r4 = -1;
static gint ett_rrc_T_tdd128_PhysChCapability = -1;
static gint ett_rrc_PhysicalChannelCapability_hspdsch_r5 = -1;
static gint ett_rrc_T_fdd_hspdsch = -1;
static gint ett_rrc_T_supported_01 = -1;
static gint ett_rrc_T_tdd384_hspdsch = -1;
static gint ett_rrc_T_tdd128_hspdsch = -1;
static gint ett_rrc_PNBSCH_Allocation_r4 = -1;
static gint ett_rrc_Pre_RedirectionInfo = -1;
static gint ett_rrc_ProtocolErrorIndicatorWithMoreInfo = -1;
static gint ett_rrc_T_errorOccurred = -1;
static gint ett_rrc_ProtocolErrorMoreInformation = -1;
static gint ett_rrc_T_diagnosticsType = -1;
static gint ett_rrc_T_type1 = -1;
static gint ett_rrc_RadioFrequencyBandTDDextList = -1;
static gint ett_rrc_Rb_timer_indicator = -1;
static gint ett_rrc_RedirectionInfo = -1;
static gint ett_rrc_RedirectionInfo_r6 = -1;
static gint ett_rrc_RedirectionInfo_v860ext = -1;
static gint ett_rrc_RF_Capability = -1;
static gint ett_rrc_T_fddRF_Capability = -1;
static gint ett_rrc_T_tddRF_Capability = -1;
static gint ett_rrc_RF_Capability_r4_ext = -1;
static gint ett_rrc_T_tddRF_Capability_01 = -1;
static gint ett_rrc_RF_Capability_v770ext = -1;
static gint ett_rrc_T_tdd768RF_Capability = -1;
static gint ett_rrc_RF_Capability_v860ext = -1;
static gint ett_rrc_RF_Capability_vaa0ext = -1;
static gint ett_rrc_RLC_Capability = -1;
static gint ett_rrc_RLC_Capability_r5_ext = -1;
static gint ett_rrc_RLC_Capability_v770ext = -1;
static gint ett_rrc_RLC_Capability_v920ext = -1;
static gint ett_rrc_RLC_Capability_va40ext = -1;
static gint ett_rrc_RLC_Capability_vb50ext = -1;
static gint ett_rrc_RRC_ConnectionReleaseInformation = -1;
static gint ett_rrc_T_release = -1;
static gint ett_rrc_RRC_MessageSequenceNumberList = -1;
static gint ett_rrc_RSR_VCC_Info = -1;
static gint ett_rrc_SecurityCapability = -1;
static gint ett_rrc_T_cipheringAlgorithmCap = -1;
static gint ett_rrc_T_integrityProtectionAlgorithmCap = -1;
static gint ett_rrc_SecondaryServingEDCHCell_Info = -1;
static gint ett_rrc_SecondaryEDCH_Info_Common = -1;
static gint ett_rrc_T_servingGrant = -1;
static gint ett_rrc_Serving_HSDSCH_CellInformation = -1;
static gint ett_rrc_Serving_HSDSCH_CellInformation_r7 = -1;
static gint ett_rrc_Serving_HSDSCH_CellInformation_r8 = -1;
static gint ett_rrc_Serving_HSDSCH_CellInformation_r9 = -1;
static gint ett_rrc_Serving_HSDSCH_CellInformation_r11 = -1;
static gint ett_rrc_SimultaneousSCCPCH_DPCH_Reception = -1;
static gint ett_rrc_T_supported_02 = -1;
static gint ett_rrc_SR_VCC_Info = -1;
static gint ett_rrc_SR_VCC_SecurityRABInfo_v860ext = -1;
static gint ett_rrc_STARTList = -1;
static gint ett_rrc_STARTSingle = -1;
static gint ett_rrc_SystemSpecificCapUpdateReqList = -1;
static gint ett_rrc_SystemSpecificCapUpdateReqList_r5 = -1;
static gint ett_rrc_SystemSpecificCapUpdateReqList_r8 = -1;
static gint ett_rrc_TMSI_and_LAI_GSM_MAP = -1;
static gint ett_rrc_TransportChannelCapability = -1;
static gint ett_rrc_TurboSupport = -1;
static gint ett_rrc_U_RNTI = -1;
static gint ett_rrc_U_RNTI_Group = -1;
static gint ett_rrc_U_RNTI_Short = -1;
static gint ett_rrc_UE_BasedNetworkPerformanceMeasurementsParameters = -1;
static gint ett_rrc_UE_CapabilityContainer_IEs = -1;
static gint ett_rrc_T_v6b0NonCriticalExtensions_14 = -1;
static gint ett_rrc_T_v6e0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_v770NonCriticalExtensions_39 = -1;
static gint ett_rrc_T_v790NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v860NonCriticalExtensions_25 = -1;
static gint ett_rrc_T_v880NonCriticalExtensions_01 = -1;
static gint ett_rrc_T_v890NonCriticalExtensions_10 = -1;
static gint ett_rrc_T_v920NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_v970NonCriticalExtensions_03 = -1;
static gint ett_rrc_T_va40NonCriticalExtensions_17 = -1;
static gint ett_rrc_T_va60NonCriticalExtensions = -1;
static gint ett_rrc_T_va80NonCriticalExtensions_01 = -1;
static gint ett_rrc_UE_RadioAccessCapability_v6b0ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v6e0ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v770ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v790ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v860ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v880ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v890ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v920ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v970ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_v9c0ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_LaterNonCriticalExtensions = -1;
static gint ett_rrc_T_v9c0NonCriticalExtensions_12 = -1;
static gint ett_rrc_T_vaa0NonCriticalExtensions_02 = -1;
static gint ett_rrc_T_vb50NonCriticalExtensions_23 = -1;
static gint ett_rrc_T_nonCriticalExtensions_195 = -1;
static gint ett_rrc_UE_RadioAccessCapability_va40ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_va60ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_va80ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_vaa0ext_IEs = -1;
static gint ett_rrc_UE_RadioAccessCapability_vb50ext_IEs = -1;
static gint ett_rrc_UE_ConnTimersAndConstants = -1;
static gint ett_rrc_UE_ConnTimersAndConstants_v3a0ext = -1;
static gint ett_rrc_UE_ConnTimersAndConstants_r5 = -1;
static gint ett_rrc_UE_ConnTimersAndConstants_v860ext = -1;
static gint ett_rrc_UE_ConnTimersAndConstants_r11 = -1;
static gint ett_rrc_UE_GANSSPositioning_Capability = -1;
static gint ett_rrc_UE_GANSSPositioning_Capability_v860ext_IEs = -1;
static gint ett_rrc_UE_IdleTimersAndConstants = -1;
static gint ett_rrc_UE_HSPA_Identities_r6 = -1;
static gint ett_rrc_UE_IdleTimersAndConstants_v3a0ext = -1;
static gint ett_rrc_UE_MultiModeRAT_Capability = -1;
static gint ett_rrc_UE_RadioAccessCapability = -1;
static gint ett_rrc_UE_RadioAccessCapabilityInfo = -1;
static gint ett_rrc_UE_RadioAccessCapability_v370ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v380ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v3a0ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v3g0ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v650ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v690ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v7e0ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v7f0ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityInfo_v770ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityInfo_TDD128_v8b0ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityInfo_TDD128_vb50ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v860ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v880ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v920ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_va40ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_va80ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_vb50ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBand_va40ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList2 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList3 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList4 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList4_va60ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList4_va80ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList5 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList6 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD2 = -1;
static gint ett_rrc_T_fddRF_Capability_01 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD3 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD4 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD4_va60ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD4_va80ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD5 = -1;
static gint ett_rrc_T_fddRF_Capability_02 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD6 = -1;
static gint ett_rrc_UE_PositioningCapabilityExt_v380 = -1;
static gint ett_rrc_UE_PositioningCapabilityExt_v3a0 = -1;
static gint ett_rrc_UE_PositioningCapabilityExt_v3g0 = -1;
static gint ett_rrc_UE_PositioningCapability_v770ext = -1;
static gint ett_rrc_UE_PositioningCapability_v860ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandCombList = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList_ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDDList_ext2 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD = -1;
static gint ett_rrc_T_fddRF_Capability_03 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD_ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandFDD_ext2 = -1;
static gint ett_rrc_UE_RadioAccessCapability_v4b0ext = -1;
static gint ett_rrc_T_tdd_CapabilityExt = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp_ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp_TDD128_v7f0ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp_v770ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp2 = -1;
static gint ett_rrc_T_fddPhysicalChannelCapab_hspdsch_edch = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp2_v770ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp2_v7f0ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp2_v860ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp2_v920ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp2_va40ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp2_vb50ext = -1;
static gint ett_rrc_UE_RadioAccessCapabilityComp_TDD128 = -1;
static gint ett_rrc_RF_CapabilityComp = -1;
static gint ett_rrc_T_fdd_47 = -1;
static gint ett_rrc_T_tdd384_RF_Capability = -1;
static gint ett_rrc_T_tdd128_RF_Capability = -1;
static gint ett_rrc_RF_CapabilityComp_v770ext = -1;
static gint ett_rrc_T_tdd768_RF_Capability = -1;
static gint ett_rrc_RF_CapabBandListFDDComp = -1;
static gint ett_rrc_RF_CapabBandListFDDComp_ext = -1;
static gint ett_rrc_RF_CapabBandListFDDComp_ext2 = -1;
static gint ett_rrc_UE_RadioAccessCapabBandCombList_va40ext = -1;
static gint ett_rrc_UE_RadioAccessCapabBandCombList_vb50ext = -1;
static gint ett_rrc_SupportedCarrierCombination = -1;
static gint ett_rrc_SupportedCarrierCombination_ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v590ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v5c0ext = -1;
static gint ett_rrc_UE_RadioAccessCapability_v680ext = -1;
static gint ett_rrc_UL_OLTD_InfoFDD = -1;
static gint ett_rrc_UL_PhysChCapabilityFDD = -1;
static gint ett_rrc_UL_PhysChCapabilityFDD_v770ext = -1;
static gint ett_rrc_UL_PhysChCapabilityFDD_v920ext = -1;
static gint ett_rrc_UL_PhysChCapabilityFDD_vb50ext = -1;
static gint ett_rrc_UL_PhysChCapabilityTDD = -1;
static gint ett_rrc_UL_PhysChCapabilityTDD_384_v770ext = -1;
static gint ett_rrc_T_tdd384_edch = -1;
static gint ett_rrc_T_supported_03 = -1;
static gint ett_rrc_UL_PhysChCapabilityTDD_LCR_r4 = -1;
static gint ett_rrc_UL_PhysChCapabilityTDD_128_v770ext = -1;
static gint ett_rrc_T_tdd128_edch = -1;
static gint ett_rrc_T_supported_04 = -1;
static gint ett_rrc_UL_PhysChCapabilityInfoTDD_128_v770ext = -1;
static gint ett_rrc_UL_PhysChCapabilityInfoTDD_128_va40ext = -1;
static gint ett_rrc_UL_PhysChCapabilityTDD_768 = -1;
static gint ett_rrc_T_tdd384_edch_01 = -1;
static gint ett_rrc_T_supported_05 = -1;
static gint ett_rrc_UL_SecondaryCellInfoFDD = -1;
static gint ett_rrc_T_newConfiguration = -1;
static gint ett_rrc_PhysicalChannelCapability_edch_r6 = -1;
static gint ett_rrc_T_fdd_edch = -1;
static gint ett_rrc_T_supported_06 = -1;
static gint ett_rrc_UL_TransChCapability = -1;
static gint ett_rrc_T_modeSpecificInfo_18 = -1;
static gint ett_rrc_T_tdd_12 = -1;
static gint ett_rrc_UE_Positioning_Capability = -1;
static gint ett_rrc_UE_SecurityInformation = -1;
static gint ett_rrc_UE_SecurityInformation2 = -1;
static gint ett_rrc_UTRAN_DRX_CycleLengthCoefficient_r7 = -1;
static gint ett_rrc_AlgorithmSpecificInfo = -1;
static gint ett_rrc_AlgorithmSpecificInfo_r4 = -1;
static gint ett_rrc_CommonRBMappingInfo = -1;
static gint ett_rrc_CS_HSPA_Information = -1;
static gint ett_rrc_DefaultConfigForCellFACH = -1;
static gint ett_rrc_DL_AM_RLC_Mode = -1;
static gint ett_rrc_DL_AM_RLC_Mode_r5 = -1;
static gint ett_rrc_DL_AM_RLC_Mode_r7 = -1;
static gint ett_rrc_T_dl_RLC_PDU_size = -1;
static gint ett_rrc_DL_AM_RLC_Mode_r11 = -1;
static gint ett_rrc_T_dl_RLC_PDU_size_01 = -1;
static gint ett_rrc_DL_CounterSynchronisationInfo = -1;
static gint ett_rrc_DL_CounterSynchronisationInfo_r5 = -1;
static gint ett_rrc_DL_LogicalChannelMapping = -1;
static gint ett_rrc_DL_LogicalChannelMapping_r5 = -1;
static gint ett_rrc_DL_LogicalChannelMapping_r7 = -1;
static gint ett_rrc_DL_LogicalChannelMappingList = -1;
static gint ett_rrc_DL_LogicalChannelMappingList_r5 = -1;
static gint ett_rrc_DL_LogicalChannelMappingList_r7 = -1;
static gint ett_rrc_DL_RFC3095_r4 = -1;
static gint ett_rrc_DL_RLC_Mode = -1;
static gint ett_rrc_DL_RLC_Mode_r5 = -1;
static gint ett_rrc_DL_RLC_Mode_r6 = -1;
static gint ett_rrc_DL_RLC_Mode_r7 = -1;
static gint ett_rrc_DL_RLC_Mode_r11 = -1;
static gint ett_rrc_DL_RLC_StatusInfo = -1;
static gint ett_rrc_DL_RLC_StatusInfo_r11 = -1;
static gint ett_rrc_DL_TM_RLC_Mode = -1;
static gint ett_rrc_DL_TransportChannelType = -1;
static gint ett_rrc_DL_TransportChannelType_r5 = -1;
static gint ett_rrc_DL_TransportChannelType_r7 = -1;
static gint ett_rrc_T_hsdsch = -1;
static gint ett_rrc_T_dch_and_hsdsch = -1;
static gint ett_rrc_DL_UM_RLC_Mode_r5 = -1;
static gint ett_rrc_DL_UM_RLC_Mode_r6 = -1;
static gint ett_rrc_ExplicitDiscard = -1;
static gint ett_rrc_HeaderCompressionInfo = -1;
static gint ett_rrc_HeaderCompressionInfoList = -1;
static gint ett_rrc_HeaderCompressionInfo_r4 = -1;
static gint ett_rrc_HeaderCompressionInfoList_r4 = -1;
static gint ett_rrc_LosslessSRNS_RelocSupport = -1;
static gint ett_rrc_MaxDAT_Retransmissions = -1;
static gint ett_rrc_PDCP_Info = -1;
static gint ett_rrc_PDCP_Info_r4 = -1;
static gint ett_rrc_PDCP_InfoReconfig = -1;
static gint ett_rrc_PDCP_InfoReconfig_r4 = -1;
static gint ett_rrc_PollingInfo = -1;
static gint ett_rrc_PredefinedRB_Configuration = -1;
static gint ett_rrc_PreDefRadioConfiguration = -1;
static gint ett_rrc_PreDefRadioConfiguration_v770ext = -1;
static gint ett_rrc_PreDefRadioConfiguration_v920ext = -1;
static gint ett_rrc_PredefinedConfigStatusList = -1;
static gint ett_rrc_PredefinedConfigStatusInfo = -1;
static gint ett_rrc_T_other = -1;
static gint ett_rrc_PredefinedConfigStatusListComp = -1;
static gint ett_rrc_PredefinedConfigSetsWithDifferentValueTag = -1;
static gint ett_rrc_PredefinedConfigSetWithDifferentValueTag = -1;
static gint ett_rrc_PredefinedConfigValueTagList = -1;
static gint ett_rrc_PredefinedConfigStatusListVarSz = -1;
static gint ett_rrc_RAB_Info = -1;
static gint ett_rrc_RAB_Info_r6_ext = -1;
static gint ett_rrc_RAB_Info_v6b0ext = -1;
static gint ett_rrc_RAB_Info_r6 = -1;
static gint ett_rrc_RAB_Info_r7 = -1;
static gint ett_rrc_RAB_InfoReplace = -1;
static gint ett_rrc_RAB_InformationList = -1;
static gint ett_rrc_RAB_InformationList_r6 = -1;
static gint ett_rrc_RAB_InformationReconfigList = -1;
static gint ett_rrc_RAB_InformationReconfigList_r8 = -1;
static gint ett_rrc_RAB_InformationReconfig = -1;
static gint ett_rrc_RAB_InformationReconfig_r8 = -1;
static gint ett_rrc_RAB_Info_Post = -1;
static gint ett_rrc_RAB_InformationMBMSPtp = -1;
static gint ett_rrc_RAB_InformationMBMSPtpList = -1;
static gint ett_rrc_RAB_InformationSetup = -1;
static gint ett_rrc_RAB_InformationSetup_r4 = -1;
static gint ett_rrc_RAB_InformationSetup_r5 = -1;
static gint ett_rrc_RAB_InformationSetup_r6_ext = -1;
static gint ett_rrc_RAB_InformationSetup_r6 = -1;
static gint ett_rrc_RAB_InformationSetup_v6b0ext = -1;
static gint ett_rrc_RAB_InformationSetup_r7 = -1;
static gint ett_rrc_RAB_InformationSetup_r8 = -1;
static gint ett_rrc_RAB_InformationSetup_v820ext = -1;
static gint ett_rrc_RAB_InformationSetup_r11 = -1;
static gint ett_rrc_RAB_InformationSetupList = -1;
static gint ett_rrc_RAB_InformationSetupList_r4 = -1;
static gint ett_rrc_RAB_InformationSetupList_r5 = -1;
static gint ett_rrc_RAB_InformationSetupList_r6 = -1;
static gint ett_rrc_RAB_InformationSetupList_r6_ext = -1;
static gint ett_rrc_RAB_InformationSetupList_v6b0ext = -1;
static gint ett_rrc_RAB_InformationSetupList_r7 = -1;
static gint ett_rrc_RAB_InformationSetupList_r8 = -1;
static gint ett_rrc_RAB_InformationSetupList_v820ext = -1;
static gint ett_rrc_RAB_InformationSetupList_r11 = -1;
static gint ett_rrc_RB_ActivationTimeInfo = -1;
static gint ett_rrc_RB_ActivationTimeInfoList = -1;
static gint ett_rrc_RB_COUNT_C_Information = -1;
static gint ett_rrc_RB_COUNT_C_InformationList = -1;
static gint ett_rrc_RB_COUNT_C_MSB_Information = -1;
static gint ett_rrc_RB_COUNT_C_MSB_InformationList = -1;
static gint ett_rrc_RB_IdentityList = -1;
static gint ett_rrc_RB_InformationAffected = -1;
static gint ett_rrc_RB_InformationAffected_r5 = -1;
static gint ett_rrc_RB_InformationAffected_r6 = -1;
static gint ett_rrc_RB_InformationAffected_r7 = -1;
static gint ett_rrc_RB_InformationAffected_r8 = -1;
static gint ett_rrc_RB_InformationAffectedList = -1;
static gint ett_rrc_RB_InformationAffectedList_r5 = -1;
static gint ett_rrc_RB_InformationAffectedList_r6 = -1;
static gint ett_rrc_RB_InformationAffectedList_r7 = -1;
static gint ett_rrc_RB_InformationAffectedList_r8 = -1;
static gint ett_rrc_RB_InformationChanged_r6 = -1;
static gint ett_rrc_T_rb_Change = -1;
static gint ett_rrc_RB_InformationChangedList_r6 = -1;
static gint ett_rrc_RB_InformationReconfig = -1;
static gint ett_rrc_RB_InformationReconfig_r4 = -1;
static gint ett_rrc_RB_InformationReconfig_r5 = -1;
static gint ett_rrc_RB_InformationReconfig_r6 = -1;
static gint ett_rrc_RB_InformationReconfig_r7 = -1;
static gint ett_rrc_RB_InformationReconfig_r8 = -1;
static gint ett_rrc_RB_InformationReconfig_r11 = -1;
static gint ett_rrc_RB_InformationReconfigList = -1;
static gint ett_rrc_RB_InformationReconfigList_r4 = -1;
static gint ett_rrc_RB_InformationReconfigList_r5 = -1;
static gint ett_rrc_RB_InformationReconfigList_r6 = -1;
static gint ett_rrc_RB_InformationReconfigList_r7 = -1;
static gint ett_rrc_RB_InformationReconfigList_r8 = -1;
static gint ett_rrc_RB_InformationReconfigList_r11 = -1;
static gint ett_rrc_RB_InformationReleaseList = -1;
static gint ett_rrc_RB_InformationSetup = -1;
static gint ett_rrc_RB_InformationSetup_r4 = -1;
static gint ett_rrc_RB_InformationSetup_r5 = -1;
static gint ett_rrc_RB_InformationSetup_r6 = -1;
static gint ett_rrc_RB_InformationSetup_r7 = -1;
static gint ett_rrc_RB_InformationSetup_r8 = -1;
static gint ett_rrc_RB_InformationSetup_r11 = -1;
static gint ett_rrc_RB_InformationSetupList = -1;
static gint ett_rrc_RB_InformationSetupList_r4 = -1;
static gint ett_rrc_RB_InformationSetupList_r5 = -1;
static gint ett_rrc_RB_InformationSetupList_r6 = -1;
static gint ett_rrc_RB_InformationSetupList_r7 = -1;
static gint ett_rrc_RB_InformationSetupList_r8 = -1;
static gint ett_rrc_RB_InformationSetupList_r11 = -1;
static gint ett_rrc_RB_MappingInfo = -1;
static gint ett_rrc_RB_MappingInfo_r5 = -1;
static gint ett_rrc_RB_MappingInfo_r6 = -1;
static gint ett_rrc_RB_MappingInfo_r7 = -1;
static gint ett_rrc_RB_MappingInfo_r8 = -1;
static gint ett_rrc_RB_MappingOption = -1;
static gint ett_rrc_RB_MappingOption_r5 = -1;
static gint ett_rrc_RB_MappingOption_r6 = -1;
static gint ett_rrc_RB_MappingOption_r7 = -1;
static gint ett_rrc_RB_MappingOption_r8 = -1;
static gint ett_rrc_RB_PDCPContextRelocation = -1;
static gint ett_rrc_RB_PDCPContextRelocationList = -1;
static gint ett_rrc_RB_WithPDCP_Info = -1;
static gint ett_rrc_RB_WithPDCP_InfoList = -1;
static gint ett_rrc_RFC2507_Info = -1;
static gint ett_rrc_RFC3095_Info_r4 = -1;
static gint ett_rrc_RLC_Info = -1;
static gint ett_rrc_RLC_Info_r5 = -1;
static gint ett_rrc_RLC_Info_r6 = -1;
static gint ett_rrc_RLC_Info_r7 = -1;
static gint ett_rrc_RLC_Info_r11 = -1;
static gint ett_rrc_RLC_Info_MCCH_r6 = -1;
static gint ett_rrc_RLC_Info_MSCH_r6 = -1;
static gint ett_rrc_RLC_Info_MTCH_r6 = -1;
static gint ett_rrc_RLC_InfoChoice = -1;
static gint ett_rrc_RLC_InfoChoice_r5 = -1;
static gint ett_rrc_RLC_InfoChoice_r6 = -1;
static gint ett_rrc_RLC_InfoChoice_r7 = -1;
static gint ett_rrc_RLC_InfoChoice_r11 = -1;
static gint ett_rrc_RLC_PDU_SizeConstraint = -1;
static gint ett_rrc_RLC_PDU_SizeList = -1;
static gint ett_rrc_RLC_SizeInfo = -1;
static gint ett_rrc_RLC_SizeExplicitList = -1;
static gint ett_rrc_ROHC_ProfileList_r4 = -1;
static gint ett_rrc_ROHC_PacketSizeList_r4 = -1;
static gint ett_rrc_SRB_InformationSetup = -1;
static gint ett_rrc_SRB_InformationSetup_r5 = -1;
static gint ett_rrc_SRB_InformationSetup_r6 = -1;
static gint ett_rrc_SRB_InformationSetup_r7 = -1;
static gint ett_rrc_SRB_InformationSetup_r8 = -1;
static gint ett_rrc_SRB_InformationSetup_r11 = -1;
static gint ett_rrc_SRB_InformationSetupList = -1;
static gint ett_rrc_SRB_InformationSetupList_r5 = -1;
static gint ett_rrc_SRB_InformationSetupList_r6 = -1;
static gint ett_rrc_SRB_InformationSetupList_r7 = -1;
static gint ett_rrc_SRB_InformationSetupList_r8 = -1;
static gint ett_rrc_SRB_InformationSetupList_r11 = -1;
static gint ett_rrc_SRB_InformationSetupList2 = -1;
static gint ett_rrc_SRB_InformationSetupList2_r6 = -1;
static gint ett_rrc_SRB_InformationSetupList2_r7 = -1;
static gint ett_rrc_SRB_InformationSetupList2_r8 = -1;
static gint ett_rrc_TransmissionRLC_Discard = -1;
static gint ett_rrc_UL_AM_RLC_Mode = -1;
static gint ett_rrc_UL_CounterSynchronisationInfo = -1;
static gint ett_rrc_UL_LogicalChannelMapping = -1;
static gint ett_rrc_T_rlc_SizeList = -1;
static gint ett_rrc_UL_LogicalChannelMapping_r6 = -1;
static gint ett_rrc_T_ul_TrCH_Type = -1;
static gint ett_rrc_T_dch_rach_usch = -1;
static gint ett_rrc_T_rlc_SizeList_01 = -1;
static gint ett_rrc_T_e_dch = -1;
static gint ett_rrc_UL_LogicalChannelMapping_r8 = -1;
static gint ett_rrc_T_ul_TrCH_Type_01 = -1;
static gint ett_rrc_T_dch_rach_usch_01 = -1;
static gint ett_rrc_T_rlc_SizeList_02 = -1;
static gint ett_rrc_T_e_dch_01 = -1;
static gint ett_rrc_T_rlc_PDU_Size = -1;
static gint ett_rrc_T_fixedSize = -1;
static gint ett_rrc_UL_LogicalChannelMappingList = -1;
static gint ett_rrc_SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping = -1;
static gint ett_rrc_UL_LogicalChannelMappingList_r6 = -1;
static gint ett_rrc_SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping_r6 = -1;
static gint ett_rrc_UL_LogicalChannelMappingList_r8 = -1;
static gint ett_rrc_SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping_r8 = -1;
static gint ett_rrc_UL_LogicalChannelMappings = -1;
static gint ett_rrc_UL_LogicalChannelMappings_r6 = -1;
static gint ett_rrc_UL_LogicalChannelMappings_r8 = -1;
static gint ett_rrc_UL_RFC3095_r4 = -1;
static gint ett_rrc_UL_RLC_Mode = -1;
static gint ett_rrc_UL_TM_RLC_Mode = -1;
static gint ett_rrc_UL_UM_RLC_Mode = -1;
static gint ett_rrc_UL_TransportChannelType = -1;
static gint ett_rrc_UM_RLC_DuplAvoid_Reord_Info_r6 = -1;
static gint ett_rrc_UM_RLC_OutOSeqDelivery_Info_r6 = -1;
static gint ett_rrc_AddOrReconfMAC_dFlow = -1;
static gint ett_rrc_AddOrReconfMAC_ehs_ReordQ = -1;
static gint ett_rrc_AddOrReconfMAC_ehs_ReordQ_r9 = -1;
static gint ett_rrc_AddOrReconfMAC_ehs_ReordQ_TDD128_v9c0ext = -1;
static gint ett_rrc_AddOrReconfMAC_ehs_ReordQ_r11 = -1;
static gint ett_rrc_AllowedTFC_List = -1;
static gint ett_rrc_AllowedTFI_List = -1;
static gint ett_rrc_BitModeRLC_SizeInfo = -1;
static gint ett_rrc_T_sizeType2 = -1;
static gint ett_rrc_T_sizeType3 = -1;
static gint ett_rrc_T_sizeType4 = -1;
static gint ett_rrc_ChannelCodingType = -1;
static gint ett_rrc_Common_E_DCH_MAC_d_Flow = -1;
static gint ett_rrc_Common_E_DCH_MAC_d_FlowList = -1;
static gint ett_rrc_Common_E_DCH_MAC_d_Flow_Info_ConcurrentTTI = -1;
static gint ett_rrc_Common_E_DCH_MAC_d_Flow_Info_List_ConcurrentTTI = -1;
static gint ett_rrc_CommonDynamicTF_Info = -1;
static gint ett_rrc_T_rlc_Size = -1;
static gint ett_rrc_T_fdd_48 = -1;
static gint ett_rrc_T_tdd_13 = -1;
static gint ett_rrc_T_commonTDD_Choice = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTF_OF_NumberOfTransportBlocks = -1;
static gint ett_rrc_CommonDynamicTF_Info_DynamicTTI = -1;
static gint ett_rrc_T_commonTDD_Choice_01 = -1;
static gint ett_rrc_CommonDynamicTF_InfoList = -1;
static gint ett_rrc_CommonDynamicTF_InfoList_DynamicTTI = -1;
static gint ett_rrc_CommonTransChTFS = -1;
static gint ett_rrc_T_tti = -1;
static gint ett_rrc_CommonTransChTFS_LCR = -1;
static gint ett_rrc_T_tti_01 = -1;
static gint ett_rrc_Common_MAC_ehs_ReorderingQueue = -1;
static gint ett_rrc_Common_MAC_ehs_ReorderingQueueList = -1;
static gint ett_rrc_Concurrent_Deployment_2ms_10ms_TTI = -1;
static gint ett_rrc_T_tti_selection = -1;
static gint ett_rrc_T_fixed = -1;
static gint ett_rrc_T_threshold_based = -1;
static gint ett_rrc_DedicatedDynamicTF_Info = -1;
static gint ett_rrc_T_rlc_Size_01 = -1;
static gint ett_rrc_DedicatedDynamicTF_Info_DynamicTTI = -1;
static gint ett_rrc_T_rlc_Size_02 = -1;
static gint ett_rrc_DedicatedDynamicTF_InfoList = -1;
static gint ett_rrc_DedicatedDynamicTF_InfoList_DynamicTTI = -1;
static gint ett_rrc_DedicatedTransChTFS = -1;
static gint ett_rrc_T_tti_02 = -1;
static gint ett_rrc_DL_AddReconfTransChInfo2List = -1;
static gint ett_rrc_DL_AddReconfTransChInfoList = -1;
static gint ett_rrc_DL_AddReconfTransChInfoList_r4 = -1;
static gint ett_rrc_DL_AddReconfTransChInfoList_r5 = -1;
static gint ett_rrc_DL_AddReconfTransChInfoList_r7 = -1;
static gint ett_rrc_DL_AddReconfTransChInfoList_r9 = -1;
static gint ett_rrc_DL_AddReconfTransChInfoList_TDD128_v9c0ext = -1;
static gint ett_rrc_DL_AddReconfTransChInfoList_r11 = -1;
static gint ett_rrc_DL_AddReconfTransChInformation = -1;
static gint ett_rrc_T_tfs_SignallingMode = -1;
static gint ett_rrc_DL_AddReconfTransChInformation_r4 = -1;
static gint ett_rrc_T_tfs_SignallingMode_01 = -1;
static gint ett_rrc_DL_AddReconfTransChInformation_r5 = -1;
static gint ett_rrc_T_tfs_SignallingMode_02 = -1;
static gint ett_rrc_DL_AddReconfTransChInformation_r7 = -1;
static gint ett_rrc_T_tfs_SignallingMode_03 = -1;
static gint ett_rrc_DL_AddReconfTransChInformation_r9 = -1;
static gint ett_rrc_T_tfs_SignallingMode_04 = -1;
static gint ett_rrc_DL_AddReconfTransChInformation_TDD128_v9c0ext = -1;
static gint ett_rrc_DL_AddReconfTransChInformation_r11 = -1;
static gint ett_rrc_T_tfs_SignallingMode_05 = -1;
static gint ett_rrc_DL_AddReconfTransChInformation2 = -1;
static gint ett_rrc_T_tfs_SignallingMode_06 = -1;
static gint ett_rrc_DL_CommonTransChInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_19 = -1;
static gint ett_rrc_T_fdd_49 = -1;
static gint ett_rrc_T_dl_Parameters = -1;
static gint ett_rrc_T_tdd_14 = -1;
static gint ett_rrc_DL_CommonTransChInfo_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_20 = -1;
static gint ett_rrc_T_fdd_50 = -1;
static gint ett_rrc_T_dl_Parameters_01 = -1;
static gint ett_rrc_T_dl_DCH_TFCS = -1;
static gint ett_rrc_T_tdd_15 = -1;
static gint ett_rrc_DL_DeletedTransChInfoList = -1;
static gint ett_rrc_DL_DeletedTransChInfoList_r5 = -1;
static gint ett_rrc_DL_DeletedTransChInfoList_r7 = -1;
static gint ett_rrc_DL_TransportChannelIdentity = -1;
static gint ett_rrc_DL_TransportChannelIdentity_r5 = -1;
static gint ett_rrc_DL_TransportChannelIdentity_r7 = -1;
static gint ett_rrc_DL_TrCH_TypeId1_r5 = -1;
static gint ett_rrc_DL_TrCH_TypeId2_r5 = -1;
static gint ett_rrc_DL_TrCH_TypeId2_r7 = -1;
static gint ett_rrc_T_hsdsch_01 = -1;
static gint ett_rrc_DRAC_StaticInformation = -1;
static gint ett_rrc_DRAC_StaticInformationList = -1;
static gint ett_rrc_E_DCH_AddReconf_MAC_d_Flow = -1;
static gint ett_rrc_T_transmissionGrantType = -1;
static gint ett_rrc_T_non_ScheduledTransGrantInfo = -1;
static gint ett_rrc_E_DCH_AddReconf_MAC_d_Flow_r7 = -1;
static gint ett_rrc_T_transmissionGrantType_01 = -1;
static gint ett_rrc_T_non_ScheduledTransGrantInfo_01 = -1;
static gint ett_rrc_T_modeSpecificInfo_21 = -1;
static gint ett_rrc_T_fdd_51 = -1;
static gint ett_rrc_E_DCH_AddReconf_MAC_d_FlowList = -1;
static gint ett_rrc_E_DCH_AddReconf_MAC_d_FlowList_r7 = -1;
static gint ett_rrc_ExplicitTFCS_Configuration = -1;
static gint ett_rrc_T_replacement = -1;
static gint ett_rrc_GainFactorInformation = -1;
static gint ett_rrc_HSDSCH_Info = -1;
static gint ett_rrc_HSDSCH_Info_r7 = -1;
static gint ett_rrc_T_dl_MAC_HeaderType = -1;
static gint ett_rrc_HSDSCH_Info_r9 = -1;
static gint ett_rrc_T_dl_MAC_HeaderType_01 = -1;
static gint ett_rrc_HSDSCH_Info_TDD128_v9c0ext = -1;
static gint ett_rrc_HSDSCH_Info_r11 = -1;
static gint ett_rrc_T_dl_MAC_HeaderType_02 = -1;
static gint ett_rrc_HARQ_Info = -1;
static gint ett_rrc_T_memoryPartitioning = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize = -1;
static gint ett_rrc_HARQ_Info_r7 = -1;
static gint ett_rrc_T_memoryPartitioning_01 = -1;
static gint ett_rrc_T_explicit = -1;
static gint ett_rrc_HARQ_Info_r11 = -1;
static gint ett_rrc_T_memoryPartitioning_02 = -1;
static gint ett_rrc_T_explicit_01 = -1;
static gint ett_rrc_IndividualDL_CCTrCH_Info = -1;
static gint ett_rrc_T_tfcs_SignallingMode = -1;
static gint ett_rrc_IndividualDL_CCTrCH_InfoList = -1;
static gint ett_rrc_IndividualUL_CCTrCH_Info = -1;
static gint ett_rrc_IndividualUL_CCTrCH_InfoList = -1;
static gint ett_rrc_LogicalChannelByRB = -1;
static gint ett_rrc_LogicalChannelList = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_15_OF_LogicalChannelByRB = -1;
static gint ett_rrc_MAC_d_FlowIdentityDCHandHSDSCH = -1;
static gint ett_rrc_MAC_d_PDU_SizeInfo_List = -1;
static gint ett_rrc_MAC_d_PDUsizeInfo = -1;
static gint ett_rrc_MAC_hs_AddReconfQueue_List = -1;
static gint ett_rrc_MAC_hs_AddReconfQueue = -1;
static gint ett_rrc_MAC_hs_DelQueue_List = -1;
static gint ett_rrc_MAC_hs_DelQueue = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ_List = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ_List_r9 = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ_List_TDD128_v9c0ext = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ_List_r11 = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ_r9 = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ_TDD128_v9c0ext = -1;
static gint ett_rrc_MAC_ehs_AddReconfReordQ_r11 = -1;
static gint ett_rrc_MAC_ehs_DelReordQ_List = -1;
static gint ett_rrc_MAC_ehs_DelReordQ = -1;
static gint ett_rrc_MAC_ehs_QueueIdDCHandHSDSCH = -1;
static gint ett_rrc_NumberOfTbSizeAndTTIList = -1;
static gint ett_rrc_NumberOfTbSizeAndTTIList_item = -1;
static gint ett_rrc_Non_allowedTFC_List = -1;
static gint ett_rrc_NumberOfTransportBlocks = -1;
static gint ett_rrc_OctetModeRLC_SizeInfoType1 = -1;
static gint ett_rrc_T_sizeType2_01 = -1;
static gint ett_rrc_T_sizeType3_01 = -1;
static gint ett_rrc_OctetModeRLC_SizeInfoType2 = -1;
static gint ett_rrc_PowerOffsetInfoShort = -1;
static gint ett_rrc_T_modeSpecificInfo_22 = -1;
static gint ett_rrc_T_fdd_52 = -1;
static gint ett_rrc_PowerOffsetInformation = -1;
static gint ett_rrc_PreDefTransChConfiguration = -1;
static gint ett_rrc_QualityTarget = -1;
static gint ett_rrc_RestrictedTrChInfo = -1;
static gint ett_rrc_RestrictedTrChInfoList = -1;
static gint ett_rrc_SemistaticTF_Information = -1;
static gint ett_rrc_SignalledGainFactors = -1;
static gint ett_rrc_T_modeSpecificInfo_23 = -1;
static gint ett_rrc_T_fdd_53 = -1;
static gint ett_rrc_SplitTFCI_Signalling = -1;
static gint ett_rrc_TFC_Subset = -1;
static gint ett_rrc_TFC_SubsetList = -1;
static gint ett_rrc_TFC_SubsetList_item = -1;
static gint ett_rrc_T_modeSpecificInfo_24 = -1;
static gint ett_rrc_T_tdd_16 = -1;
static gint ett_rrc_TFCI_Field2_Information = -1;
static gint ett_rrc_TFCI_Range = -1;
static gint ett_rrc_TFCI_RangeList = -1;
static gint ett_rrc_TFCS = -1;
static gint ett_rrc_TFCS_Identity = -1;
static gint ett_rrc_TFCS_InfoForDSCH = -1;
static gint ett_rrc_TFCS_ReconfAdd = -1;
static gint ett_rrc_T_ctfcSize = -1;
static gint ett_rrc_T_ctfc2Bit = -1;
static gint ett_rrc_T_ctfc2Bit_item = -1;
static gint ett_rrc_T_ctfc4Bit = -1;
static gint ett_rrc_T_ctfc4Bit_item = -1;
static gint ett_rrc_T_ctfc6Bit = -1;
static gint ett_rrc_T_ctfc6Bit_item = -1;
static gint ett_rrc_T_ctfc8Bit = -1;
static gint ett_rrc_T_ctfc8Bit_item = -1;
static gint ett_rrc_T_ctfc12Bit = -1;
static gint ett_rrc_T_ctfc12Bit_item = -1;
static gint ett_rrc_T_ctfc16Bit = -1;
static gint ett_rrc_T_ctfc16Bit_item = -1;
static gint ett_rrc_T_ctfc24Bit = -1;
static gint ett_rrc_T_ctfc24Bit_item = -1;
static gint ett_rrc_TFCS_Removal = -1;
static gint ett_rrc_TFCS_RemovalList = -1;
static gint ett_rrc_TM_SignallingInfo = -1;
static gint ett_rrc_T_tm_SignallingMode = -1;
static gint ett_rrc_T_mode2 = -1;
static gint ett_rrc_TransportChannelIdentityDCHandDSCH = -1;
static gint ett_rrc_TransportFormatSet = -1;
static gint ett_rrc_TransportFormatSet_LCR = -1;
static gint ett_rrc_UL_AddReconfTransChInfoList = -1;
static gint ett_rrc_UL_AddReconfTransChInfoList_r6 = -1;
static gint ett_rrc_UL_AddReconfTransChInfoList_r7 = -1;
static gint ett_rrc_UL_AddReconfTransChInfoList_r8 = -1;
static gint ett_rrc_UL_AddReconfTransChInformation = -1;
static gint ett_rrc_UL_AddReconfTransChInformation_r6 = -1;
static gint ett_rrc_T_dch_usch = -1;
static gint ett_rrc_T_e_dch_02 = -1;
static gint ett_rrc_UL_AddReconfTransChInformation_r7 = -1;
static gint ett_rrc_T_dch_usch_01 = -1;
static gint ett_rrc_T_e_dch_03 = -1;
static gint ett_rrc_T_modeSpecific = -1;
static gint ett_rrc_T_fdd_54 = -1;
static gint ett_rrc_UL_AddReconfTransChInformation_r8 = -1;
static gint ett_rrc_T_dch_usch_02 = -1;
static gint ett_rrc_T_e_dch_04 = -1;
static gint ett_rrc_T_modeSpecific_01 = -1;
static gint ett_rrc_T_fdd_55 = -1;
static gint ett_rrc_UL_CommonTransChInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_25 = -1;
static gint ett_rrc_T_fdd_56 = -1;
static gint ett_rrc_T_tdd_17 = -1;
static gint ett_rrc_UL_CommonTransChInfo_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_26 = -1;
static gint ett_rrc_T_fdd_57 = -1;
static gint ett_rrc_T_tdd_18 = -1;
static gint ett_rrc_UL_ControlledTrChList = -1;
static gint ett_rrc_UL_DeletedTransChInfoList = -1;
static gint ett_rrc_UL_DeletedTransChInfoList_r6 = -1;
static gint ett_rrc_UL_TransportChannelIdentity = -1;
static gint ett_rrc_UL_TransportChannelIdentity_r6 = -1;
static gint ett_rrc_T_dch_usch_03 = -1;
static gint ett_rrc_USCH_TransportChannelsInfo = -1;
static gint ett_rrc_USCH_TransportChannelsInfo_item = -1;
static gint ett_rrc_AC_To_ASC_MappingTable = -1;
static gint ett_rrc_AccessServiceClass_FDD = -1;
static gint ett_rrc_T_assignedSubChannelNumber = -1;
static gint ett_rrc_AccessServiceClass_TDD = -1;
static gint ett_rrc_T_channelisationCodeIndices = -1;
static gint ett_rrc_T_subchannelSize = -1;
static gint ett_rrc_T_size2 = -1;
static gint ett_rrc_T_size4 = -1;
static gint ett_rrc_T_subchannels_01 = -1;
static gint ett_rrc_T_size8 = -1;
static gint ett_rrc_T_subchannels_02 = -1;
static gint ett_rrc_AccessServiceClass_TDD_r7 = -1;
static gint ett_rrc_T_channelisationCodeIndices_01 = -1;
static gint ett_rrc_T_subchannelSize_01 = -1;
static gint ett_rrc_T_size2_01 = -1;
static gint ett_rrc_T_size4_01 = -1;
static gint ett_rrc_T_subchannels_04 = -1;
static gint ett_rrc_T_size8_01 = -1;
static gint ett_rrc_T_subchannels_05 = -1;
static gint ett_rrc_T_size16 = -1;
static gint ett_rrc_T_subchannels_06 = -1;
static gint ett_rrc_AccessServiceClass_TDD_LCR_r4 = -1;
static gint ett_rrc_T_availableSYNC_UlCodesIndics = -1;
static gint ett_rrc_T_subchannelSize_02 = -1;
static gint ett_rrc_T_size2_02 = -1;
static gint ett_rrc_T_size4_02 = -1;
static gint ett_rrc_T_subchannels_08 = -1;
static gint ett_rrc_T_size8_02 = -1;
static gint ett_rrc_T_subchannels_09 = -1;
static gint ett_rrc_AdditionalPRACH_TF_and_TFCS_CCCH_IEs = -1;
static gint ett_rrc_AdditionalPRACH_TF_and_TFCS_CCCH = -1;
static gint ett_rrc_AdditionalPRACH_TF_and_TFCS_CCCH_List = -1;
static gint ett_rrc_AdditionalDLSecCellInfoListFDD = -1;
static gint ett_rrc_AdditionalDLSecCellInfoListFDD_r11 = -1;
static gint ett_rrc_AdditionalDLSecCellInfoListFDD2 = -1;
static gint ett_rrc_AdditionalDLSecCellInfoFDD = -1;
static gint ett_rrc_AdditionalDLSecCellInfoFDD_r11 = -1;
static gint ett_rrc_AICH_Info = -1;
static gint ett_rrc_AICH_Info_Compressed = -1;
static gint ett_rrc_AllocationPeriodInfo = -1;
static gint ett_rrc_Antenna3And4 = -1;
static gint ett_rrc_Antenna3And4_S_CPICH = -1;
static gint ett_rrc_Antenna3And4_D_CPICH = -1;
static gint ett_rrc_Antenna3_D_CPICH = -1;
static gint ett_rrc_Antenna4_D_CPICH = -1;
static gint ett_rrc_Antenna3_S_CPICH = -1;
static gint ett_rrc_Antenna4_S_CPICH = -1;
static gint ett_rrc_AP_Signature_VCAM = -1;
static gint ett_rrc_ASCSetting_FDD = -1;
static gint ett_rrc_ASCSetting_TDD = -1;
static gint ett_rrc_ASCSetting_TDD_r7 = -1;
static gint ett_rrc_ASCSetting_TDD_LCR_r4 = -1;
static gint ett_rrc_AvailableAP_Signature_VCAMList = -1;
static gint ett_rrc_AvailableAP_SignatureList = -1;
static gint ett_rrc_AvailableAP_SubchannelList = -1;
static gint ett_rrc_AvailableMinimumSF_ListVCAM = -1;
static gint ett_rrc_AvailableMinimumSF_VCAM = -1;
static gint ett_rrc_AvailableSignatures = -1;
static gint ett_rrc_AvailableSubChannelNumbers = -1;
static gint ett_rrc_CCTrCH_PowerControlInfo = -1;
static gint ett_rrc_CCTrCH_PowerControlInfo_r4 = -1;
static gint ett_rrc_CCTrCH_PowerControlInfo_r5 = -1;
static gint ett_rrc_CCTrCH_PowerControlInfo_r7 = -1;
static gint ett_rrc_CD_AccessSlotSubchannelList = -1;
static gint ett_rrc_CD_SignatureCodeList = -1;
static gint ett_rrc_CellAndChannelIdentity = -1;
static gint ett_rrc_ChannelAssignmentActive = -1;
static gint ett_rrc_ChannelReqParamsForUCSM = -1;
static gint ett_rrc_CodeRange = -1;
static gint ett_rrc_CodeResourceInformation_TDD128 = -1;
static gint ett_rrc_Common_E_DCH_ResourceInfoList = -1;
static gint ett_rrc_Common_E_DCH_ResourceInfoListExt = -1;
static gint ett_rrc_Common_E_RNTI_Info = -1;
static gint ett_rrc_Common_E_RNTI_Info_item = -1;
static gint ett_rrc_CommonEDCHResourceConfigInfoListExt = -1;
static gint ett_rrc_CommonEDCHSystemInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_27 = -1;
static gint ett_rrc_T_dummy_14 = -1;
static gint ett_rrc_T_tdd_19 = -1;
static gint ett_rrc_T_tdd128_11 = -1;
static gint ett_rrc_T_ccch_transmission_Info = -1;
static gint ett_rrc_CommonEDCHSystemInfoFDD = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxEDCHs_OF_Common_E_DCH_ResourceInfoList = -1;
static gint ett_rrc_CommonEDCHSystemInfoParamConcurrentTTI = -1;
static gint ett_rrc_CommonERGCHChannelConfig = -1;
static gint ett_rrc_CommonERGCHInfoFDD = -1;
static gint ett_rrc_T_configurationInfo = -1;
static gint ett_rrc_T_newConfiguration_01 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxCellMeas_OF_CommonERGCHChannelConfig = -1;
static gint ett_rrc_CommonTimeslotInfo = -1;
static gint ett_rrc_CommonTimeslotInfoMBMS = -1;
static gint ett_rrc_CommonTimeslotInfoSCCPCH = -1;
static gint ett_rrc_ControlChannelDRXInfo_TDD128_r8 = -1;
static gint ett_rrc_T_controlChannelDrxOperation = -1;
static gint ett_rrc_T_continue = -1;
static gint ett_rrc_T_newOperation = -1;
static gint ett_rrc_CPCH_PersistenceLevels = -1;
static gint ett_rrc_CPCH_PersistenceLevelsList = -1;
static gint ett_rrc_CPCH_SetInfo = -1;
static gint ett_rrc_CPCH_SetInfoList = -1;
static gint ett_rrc_DL_CCTrCh = -1;
static gint ett_rrc_DL_CCTrCh_r4 = -1;
static gint ett_rrc_T_tddOption_03 = -1;
static gint ett_rrc_T_tdd384_11 = -1;
static gint ett_rrc_T_tdd128_12 = -1;
static gint ett_rrc_DL_CCTrCh_r7 = -1;
static gint ett_rrc_T_tddOption_04 = -1;
static gint ett_rrc_T_tdd384_12 = -1;
static gint ett_rrc_T_tdd768_06 = -1;
static gint ett_rrc_T_tdd128_13 = -1;
static gint ett_rrc_DL_CCTrChList = -1;
static gint ett_rrc_DL_CCTrChList_r7 = -1;
static gint ett_rrc_DL_CCTrChList_r4 = -1;
static gint ett_rrc_DL_CCTrChListToRemove = -1;
static gint ett_rrc_DL_ChannelisationCode = -1;
static gint ett_rrc_DL_ChannelisationCodeList = -1;
static gint ett_rrc_DL_CommonInformation = -1;
static gint ett_rrc_T_modeSpecificInfo_28 = -1;
static gint ett_rrc_T_fdd_58 = -1;
static gint ett_rrc_T_tdd_20 = -1;
static gint ett_rrc_DL_CommonInformation_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_29 = -1;
static gint ett_rrc_T_fdd_59 = -1;
static gint ett_rrc_T_tdd_21 = -1;
static gint ett_rrc_T_tddOption_05 = -1;
static gint ett_rrc_T_tdd128_14 = -1;
static gint ett_rrc_DL_CommonInformation_r5 = -1;
static gint ett_rrc_T_modeSpecificInfo_30 = -1;
static gint ett_rrc_T_fdd_60 = -1;
static gint ett_rrc_T_tdd_22 = -1;
static gint ett_rrc_T_tddOption_06 = -1;
static gint ett_rrc_T_tdd128_15 = -1;
static gint ett_rrc_DL_CommonInformation_r6 = -1;
static gint ett_rrc_T_dl_dpchInfoCommon = -1;
static gint ett_rrc_T_modeSpecificInfo_31 = -1;
static gint ett_rrc_T_fdd_61 = -1;
static gint ett_rrc_T_tdd_23 = -1;
static gint ett_rrc_T_tddOption_07 = -1;
static gint ett_rrc_T_tdd128_16 = -1;
static gint ett_rrc_DL_CommonInformation_r7 = -1;
static gint ett_rrc_T_dl_dpchInfoCommon_01 = -1;
static gint ett_rrc_T_modeSpecificInfo_32 = -1;
static gint ett_rrc_T_fdd_62 = -1;
static gint ett_rrc_T_tdd_24 = -1;
static gint ett_rrc_T_tddOption_08 = -1;
static gint ett_rrc_T_tdd128_17 = -1;
static gint ett_rrc_DL_CommonInformation_r8 = -1;
static gint ett_rrc_T_dl_dpchInfoCommon_02 = -1;
static gint ett_rrc_T_modeSpecificInfo_33 = -1;
static gint ett_rrc_T_fdd_63 = -1;
static gint ett_rrc_T_tdd_25 = -1;
static gint ett_rrc_T_tddOption_09 = -1;
static gint ett_rrc_T_tdd128_18 = -1;
static gint ett_rrc_DL_CommonInformation_r10 = -1;
static gint ett_rrc_T_dl_dpchInfoCommon_03 = -1;
static gint ett_rrc_T_modeSpecificInfo_34 = -1;
static gint ett_rrc_T_fdd_64 = -1;
static gint ett_rrc_T_tdd_26 = -1;
static gint ett_rrc_T_tddOption_10 = -1;
static gint ett_rrc_T_tdd128_19 = -1;
static gint ett_rrc_DL_CommonInformation_r11 = -1;
static gint ett_rrc_T_dl_dpchInfoCommon_04 = -1;
static gint ett_rrc_T_modeSpecificInfo_35 = -1;
static gint ett_rrc_T_fdd_65 = -1;
static gint ett_rrc_T_tdd_27 = -1;
static gint ett_rrc_T_tddOption_11 = -1;
static gint ett_rrc_T_tdd128_20 = -1;
static gint ett_rrc_DL_CommonInformationPost = -1;
static gint ett_rrc_DL_CommonInformationPredef = -1;
static gint ett_rrc_DL_DPCH_InfoCommon = -1;
static gint ett_rrc_T_cfnHandling = -1;
static gint ett_rrc_T_initialise = -1;
static gint ett_rrc_T_modeSpecificInfo_36 = -1;
static gint ett_rrc_T_fdd_66 = -1;
static gint ett_rrc_T_tdd_28 = -1;
static gint ett_rrc_DL_DPCH_InfoCommon_r4 = -1;
static gint ett_rrc_T_cfnHandling_01 = -1;
static gint ett_rrc_T_initialise_01 = -1;
static gint ett_rrc_T_modeSpecificInfo_37 = -1;
static gint ett_rrc_T_fdd_67 = -1;
static gint ett_rrc_T_tdd_29 = -1;
static gint ett_rrc_DL_DPCH_InfoCommon_r6 = -1;
static gint ett_rrc_T_cfnHandling_02 = -1;
static gint ett_rrc_T_maintain = -1;
static gint ett_rrc_T_modeSpecificInfo_38 = -1;
static gint ett_rrc_T_fdd_68 = -1;
static gint ett_rrc_T_tdd_30 = -1;
static gint ett_rrc_DL_DPCH_InfoCommonPost = -1;
static gint ett_rrc_DL_DPCH_InfoCommonPredef = -1;
static gint ett_rrc_T_modeSpecificInfo_39 = -1;
static gint ett_rrc_T_fdd_69 = -1;
static gint ett_rrc_T_tdd_31 = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL = -1;
static gint ett_rrc_T_fdd_70 = -1;
static gint ett_rrc_T_tdd_32 = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL_r4 = -1;
static gint ett_rrc_T_fdd_71 = -1;
static gint ett_rrc_T_tdd_33 = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL_r5 = -1;
static gint ett_rrc_T_fdd_72 = -1;
static gint ett_rrc_T_tdd_34 = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL_r6 = -1;
static gint ett_rrc_T_fdd_73 = -1;
static gint ett_rrc_T_tdd_35 = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL_r7 = -1;
static gint ett_rrc_T_fdd_74 = -1;
static gint ett_rrc_T_tdd_36 = -1;
static gint ett_rrc_DL_FDPCH_InfoPerRL_r6 = -1;
static gint ett_rrc_DL_FDPCH_InfoPerRL_r7 = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL_PostFDD = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL_PostTDD = -1;
static gint ett_rrc_DL_DPCH_InfoPerRL_PostTDD_LCR_r4 = -1;
static gint ett_rrc_DL_DPCH_PowerControlInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_40 = -1;
static gint ett_rrc_T_fdd_75 = -1;
static gint ett_rrc_T_tdd_37 = -1;
static gint ett_rrc_DL_FDPCH_InfoCommon_r6 = -1;
static gint ett_rrc_T_cfnHandling_03 = -1;
static gint ett_rrc_T_maintain_01 = -1;
static gint ett_rrc_DL_HSPDSCH_Information = -1;
static gint ett_rrc_T_modeSpecificInfo_41 = -1;
static gint ett_rrc_T_tdd_38 = -1;
static gint ett_rrc_T_tdd384_13 = -1;
static gint ett_rrc_T_tdd128_21 = -1;
static gint ett_rrc_DL_HSPDSCH_Information_r6 = -1;
static gint ett_rrc_T_modeSpecificInfo_42 = -1;
static gint ett_rrc_T_tdd_39 = -1;
static gint ett_rrc_T_tdd384_14 = -1;
static gint ett_rrc_T_tdd128_22 = -1;
static gint ett_rrc_DL_HSPDSCH_Information_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_43 = -1;
static gint ett_rrc_T_tdd_40 = -1;
static gint ett_rrc_T_tdd384_15 = -1;
static gint ett_rrc_T_tdd768_07 = -1;
static gint ett_rrc_T_tdd128_23 = -1;
static gint ett_rrc_T_fdd_76 = -1;
static gint ett_rrc_DL_HSPDSCH_Information_r8 = -1;
static gint ett_rrc_T_modeSpecificInfo_44 = -1;
static gint ett_rrc_T_tdd_41 = -1;
static gint ett_rrc_T_tdd384_16 = -1;
static gint ett_rrc_T_tdd768_08 = -1;
static gint ett_rrc_T_tdd128_24 = -1;
static gint ett_rrc_T_fdd_77 = -1;
static gint ett_rrc_DL_HSPDSCH_Information_r8_ext = -1;
static gint ett_rrc_T_modeSpecificInfo_45 = -1;
static gint ett_rrc_T_tdd_42 = -1;
static gint ett_rrc_T_tdd128_25 = -1;
static gint ett_rrc_DL_HSPDSCH_Information_r8_ext2 = -1;
static gint ett_rrc_DL_HSPDSCH_Information_r9 = -1;
static gint ett_rrc_T_modeSpecificInfo_46 = -1;
static gint ett_rrc_T_tdd_43 = -1;
static gint ett_rrc_T_tdd384_17 = -1;
static gint ett_rrc_T_tdd768_09 = -1;
static gint ett_rrc_T_tdd128_26 = -1;
static gint ett_rrc_T_fdd_78 = -1;
static gint ett_rrc_DL_HSPDSCH_Information_r11 = -1;
static gint ett_rrc_T_modeSpecificInfo_47 = -1;
static gint ett_rrc_T_tdd_44 = -1;
static gint ett_rrc_T_tdd384_18 = -1;
static gint ett_rrc_T_tdd768_10 = -1;
static gint ett_rrc_T_tdd128_27 = -1;
static gint ett_rrc_T_fdd_79 = -1;
static gint ett_rrc_DL_HSPDSCH_MultiCarrier_Information = -1;
static gint ett_rrc_DL_HSPDSCH_MultiCarrier_Information_item = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_MultiCarrier = -1;
static gint ett_rrc_DL_HSPDSCH_TS_Configuration = -1;
static gint ett_rrc_DL_HSPDSCH_TS_Configuration_item = -1;
static gint ett_rrc_DL_HSPDSCH_TS_Configuration_VHCR = -1;
static gint ett_rrc_DL_HSPDSCH_TS_Configuration_VHCR_item = -1;
static gint ett_rrc_DL_InformationPerRL = -1;
static gint ett_rrc_T_modeSpecificInfo_48 = -1;
static gint ett_rrc_T_fdd_80 = -1;
static gint ett_rrc_DL_InformationPerRL_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_49 = -1;
static gint ett_rrc_T_fdd_81 = -1;
static gint ett_rrc_DL_InformationPerRL_r5 = -1;
static gint ett_rrc_T_modeSpecificInfo_50 = -1;
static gint ett_rrc_T_fdd_82 = -1;
static gint ett_rrc_DL_InformationPerRL_r5bis = -1;
static gint ett_rrc_T_modeSpecificInfo_51 = -1;
static gint ett_rrc_T_fdd_83 = -1;
static gint ett_rrc_DL_InformationPerRL_r6 = -1;
static gint ett_rrc_T_modeSpecificInfo_52 = -1;
static gint ett_rrc_T_fdd_84 = -1;
static gint ett_rrc_T_dl_dpchInfo = -1;
static gint ett_rrc_T_e_HICH_Info = -1;
static gint ett_rrc_T_e_RGCH_Info_01 = -1;
static gint ett_rrc_DL_InformationPerRL_v6b0ext = -1;
static gint ett_rrc_DL_InformationPerRL_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_53 = -1;
static gint ett_rrc_T_fdd_85 = -1;
static gint ett_rrc_T_dl_dpchInfo_01 = -1;
static gint ett_rrc_T_modeSpecificInfo2 = -1;
static gint ett_rrc_T_fdd_86 = -1;
static gint ett_rrc_T_e_HICH_Info_01 = -1;
static gint ett_rrc_T_e_RGCH_Info_02 = -1;
static gint ett_rrc_T_tdd_45 = -1;
static gint ett_rrc_T_tdd384_tdd768 = -1;
static gint ett_rrc_T_tdd128_28 = -1;
static gint ett_rrc_DL_InformationPerRL_r8 = -1;
static gint ett_rrc_T_modeSpecificInfo_54 = -1;
static gint ett_rrc_T_fdd_87 = -1;
static gint ett_rrc_T_dl_dpchInfo_02 = -1;
static gint ett_rrc_T_modeSpecificInfo2_01 = -1;
static gint ett_rrc_T_fdd_88 = -1;
static gint ett_rrc_T_e_HICH_Info_02 = -1;
static gint ett_rrc_T_e_RGCH_Info_03 = -1;
static gint ett_rrc_T_tdd_46 = -1;
static gint ett_rrc_T_tdd384_tdd768_01 = -1;
static gint ett_rrc_T_tdd128_29 = -1;
static gint ett_rrc_DL_InformationPerRL_r11 = -1;
static gint ett_rrc_T_modeSpecificInfo_55 = -1;
static gint ett_rrc_T_fdd_89 = -1;
static gint ett_rrc_T_dl_dpchInfo_03 = -1;
static gint ett_rrc_T_modeSpecificInfo2_02 = -1;
static gint ett_rrc_T_fdd_90 = -1;
static gint ett_rrc_T_e_HICH_Info_03 = -1;
static gint ett_rrc_T_e_RGCH_Info_04 = -1;
static gint ett_rrc_T_f_TPICH_Info = -1;
static gint ett_rrc_T_tdd_47 = -1;
static gint ett_rrc_T_tdd384_tdd768_02 = -1;
static gint ett_rrc_T_tdd128_30 = -1;
static gint ett_rrc_DL_InformationPerRL_List = -1;
static gint ett_rrc_DL_InformationPerRL_List_r4 = -1;
static gint ett_rrc_DL_InformationPerRL_List_r5 = -1;
static gint ett_rrc_DL_InformationPerRL_List_r6 = -1;
static gint ett_rrc_DL_InformationPerRL_List_v6b0ext = -1;
static gint ett_rrc_DL_InformationPerRL_List_r5bis = -1;
static gint ett_rrc_DL_InformationPerRL_List_r7 = -1;
static gint ett_rrc_DL_InformationPerRL_List_r8 = -1;
static gint ett_rrc_DL_InformationPerRL_List_r11 = -1;
static gint ett_rrc_DL_InformationPerRL_ListPostFDD = -1;
static gint ett_rrc_DL_InformationPerRL_PostFDD = -1;
static gint ett_rrc_DL_InformationPerRL_PostTDD = -1;
static gint ett_rrc_DL_InformationPerRL_PostTDD_LCR_r4 = -1;
static gint ett_rrc_DL_MultiCarrier_Information = -1;
static gint ett_rrc_DL_PDSCH_Information = -1;
static gint ett_rrc_Dl_rate_matching_restriction = -1;
static gint ett_rrc_DL_SecondaryCellInfoFDD = -1;
static gint ett_rrc_T_newConfiguration_02 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_Codes = -1;
static gint ett_rrc_DL_SecondaryCellInfoFDD_v890ext = -1;
static gint ett_rrc_DL_SecondaryCellInfoFDD_r9 = -1;
static gint ett_rrc_T_configurationInfo_01 = -1;
static gint ett_rrc_T_newConfiguration_03 = -1;
static gint ett_rrc_DL_SecondaryCellInfoFDD_r10 = -1;
static gint ett_rrc_T_configurationInfo_02 = -1;
static gint ett_rrc_T_newConfiguration_04 = -1;
static gint ett_rrc_DL_SecondaryCellInfoFDD_r11 = -1;
static gint ett_rrc_T_configurationInfo_03 = -1;
static gint ett_rrc_T_newConfiguration_05 = -1;
static gint ett_rrc_DL_TPC_PowerOffsetPerRL = -1;
static gint ett_rrc_DL_TPC_PowerOffsetPerRL_List = -1;
static gint ett_rrc_DL_TS_ChannelisationCodesShort = -1;
static gint ett_rrc_T_codesRepresentation = -1;
static gint ett_rrc_T_consecutive = -1;
static gint ett_rrc_T_bitmap = -1;
static gint ett_rrc_DL_TS_ChannelisationCodesShort_VHCR = -1;
static gint ett_rrc_T_codesRepresentation_01 = -1;
static gint ett_rrc_T_consecutive_01 = -1;
static gint ett_rrc_T_bitmap_01 = -1;
static gint ett_rrc_DL_ChannelCodes_MBSFN_IMB384 = -1;
static gint ett_rrc_DLUL_HSPA_Information_r8 = -1;
static gint ett_rrc_DLUL_HSPA_Information_r9 = -1;
static gint ett_rrc_DLUL_HSPA_Information_r10 = -1;
static gint ett_rrc_DownlinkAdditionalTimeslots = -1;
static gint ett_rrc_T_parameters = -1;
static gint ett_rrc_T_sameAsLast = -1;
static gint ett_rrc_T_newParameters = -1;
static gint ett_rrc_DownlinkAdditionalTimeslots_VHCR = -1;
static gint ett_rrc_T_parameters_01 = -1;
static gint ett_rrc_T_sameAsLast_01 = -1;
static gint ett_rrc_T_newParameters_01 = -1;
static gint ett_rrc_DownlinkAdditionalTimeslots_LCR_r4 = -1;
static gint ett_rrc_T_parameters_02 = -1;
static gint ett_rrc_T_sameAsLast_02 = -1;
static gint ett_rrc_T_newParameters_02 = -1;
static gint ett_rrc_DownlinkAdditionalTimeslots_r7 = -1;
static gint ett_rrc_T_parameters_03 = -1;
static gint ett_rrc_T_sameAsLast_03 = -1;
static gint ett_rrc_T_newParameters_03 = -1;
static gint ett_rrc_DownlinkTimeslotsCodes = -1;
static gint ett_rrc_T_moreTimeslots = -1;
static gint ett_rrc_T_additionalTimeslots = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots = -1;
static gint ett_rrc_DownlinkTimeslotsCodes_VHCR = -1;
static gint ett_rrc_T_moreTimeslots_01 = -1;
static gint ett_rrc_T_additionalTimeslots_01 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots_VHCR = -1;
static gint ett_rrc_DownlinkTimeslotsCodes_LCR_r4 = -1;
static gint ett_rrc_T_moreTimeslots_02 = -1;
static gint ett_rrc_T_additionalTimeslots_02 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_LCR_1_OF_DownlinkAdditionalTimeslots_LCR_r4 = -1;
static gint ett_rrc_DownlinkTimeslotsCodes_r7 = -1;
static gint ett_rrc_T_moreTimeslots_03 = -1;
static gint ett_rrc_T_additionalTimeslots_03 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots_r7 = -1;
static gint ett_rrc_DPCH_CompressedModeInfo = -1;
static gint ett_rrc_DPCH_CompressedModeInfo_r8 = -1;
static gint ett_rrc_DPCH_CompressedModeInfo_r10 = -1;
static gint ett_rrc_DPCH_CompressedModeStatusInfo = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTGPS_OF_TGP_SequenceShort = -1;
static gint ett_rrc_DPCH_CompressedModeStatusInfo_r10 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTGPS_OF_TGP_SequenceShort_r10 = -1;
static gint ett_rrc_DRX_Info = -1;
static gint ett_rrc_DSCH_Mapping = -1;
static gint ett_rrc_DSCH_MappingList = -1;
static gint ett_rrc_DSCH_TransportChannelsInfo = -1;
static gint ett_rrc_DSCH_TransportChannelsInfo_item = -1;
static gint ett_rrc_DTX_DRX_Info_r7 = -1;
static gint ett_rrc_DTX_E_DCH_TTI_10ms = -1;
static gint ett_rrc_DTX_E_DCH_TTI_2ms = -1;
static gint ett_rrc_DTX_Info = -1;
static gint ett_rrc_T_e_dch_TTI_Length = -1;
static gint ett_rrc_DynamicPersistenceLevelList = -1;
static gint ett_rrc_DynamicPersistenceLevelTF_List = -1;
static gint ett_rrc_DynamicTFInformationCCCH = -1;
static gint ett_rrc_E_AGCH_DRX_Info_TDD128 = -1;
static gint ett_rrc_T_e_AGCH_DRX_InfoType = -1;
static gint ett_rrc_T_e_AGCH_DRX_Parameters = -1;
static gint ett_rrc_E_AGCH_Individual = -1;
static gint ett_rrc_E_AGCH_Individual_VHCR = -1;
static gint ett_rrc_E_AGCH_Individual_LCR = -1;
static gint ett_rrc_T_midambleAllocationMode = -1;
static gint ett_rrc_E_AGCH_Information = -1;
static gint ett_rrc_E_AGCH_Information_r7 = -1;
static gint ett_rrc_T_modeSpecific_02 = -1;
static gint ett_rrc_T_fdd_91 = -1;
static gint ett_rrc_T_tdd_48 = -1;
static gint ett_rrc_T_tdd384_19 = -1;
static gint ett_rrc_T_tdd768_11 = -1;
static gint ett_rrc_T_tdd128_31 = -1;
static gint ett_rrc_E_AGCH_Information_r8 = -1;
static gint ett_rrc_T_modeSpecific_03 = -1;
static gint ett_rrc_T_fdd_92 = -1;
static gint ett_rrc_T_tdd_49 = -1;
static gint ett_rrc_T_tdd384_20 = -1;
static gint ett_rrc_T_tdd768_12 = -1;
static gint ett_rrc_T_tdd128_32 = -1;
static gint ett_rrc_E_AGCH_Information_TDD128 = -1;
static gint ett_rrc_E_AGCH_Set_Config = -1;
static gint ett_rrc_E_AGCH_Set_Config_VHCR = -1;
static gint ett_rrc_E_AGCH_Set_Config_LCR = -1;
static gint ett_rrc_E_ROCH_Information = -1;
static gint ett_rrc_E_DCH_ReconfigurationInfo = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell = -1;
static gint ett_rrc_E_DCH_ReconfigurationInfo_r7 = -1;
static gint ett_rrc_E_DCH_ReconfigurationInfo_r11 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell_r11 = -1;
static gint ett_rrc_E_DCH_ReconfigurationInfo_SecULFrequency = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell_SecULFreq = -1;
static gint ett_rrc_E_DCH_RL_InfoNewServingCell = -1;
static gint ett_rrc_T_servingGrant_01 = -1;
static gint ett_rrc_T_e_RGCH_Info_05 = -1;
static gint ett_rrc_E_DCH_RL_InfoNewServingCell_r7 = -1;
static gint ett_rrc_T_servingGrant_02 = -1;
static gint ett_rrc_T_e_RGCH_Info_06 = -1;
static gint ett_rrc_E_DCH_RL_InfoNewServingCell_r11 = -1;
static gint ett_rrc_T_servingGrant_03 = -1;
static gint ett_rrc_T_e_RGCH_Info_07 = -1;
static gint ett_rrc_E_DCH_RL_InfoNewSecServingCell = -1;
static gint ett_rrc_T_e_RGCH_Info_08 = -1;
static gint ett_rrc_E_DCH_RL_InfoOtherCell = -1;
static gint ett_rrc_T_e_HICH_Info_04 = -1;
static gint ett_rrc_T_e_RGCH_Info_09 = -1;
static gint ett_rrc_E_DCH_RL_InfoOtherCell_r11 = -1;
static gint ett_rrc_T_e_HICH_Info_05 = -1;
static gint ett_rrc_T_e_RGCH_Info_10 = -1;
static gint ett_rrc_E_DCH_RL_InfoOtherCell_SecULFreq = -1;
static gint ett_rrc_T_e_RGCH_Info_11 = -1;
static gint ett_rrc_E_DCH_RL_InfoSameServingCell = -1;
static gint ett_rrc_E_DCH_SPS_Information_TDD128 = -1;
static gint ett_rrc_T_e_dch_SPS_Operation = -1;
static gint ett_rrc_E_DCH_SPS_NewOperation_TDD128 = -1;
static gint ett_rrc_T_initialSPSInfoForEDCH = -1;
static gint ett_rrc_E_DCH_TxPatternList_TDD128 = -1;
static gint ett_rrc_E_DCH_TxPatternList_TDD128_item = -1;
static gint ett_rrc_E_DPCCH_Info = -1;
static gint ett_rrc_E_DPCCH_Info_r7 = -1;
static gint ett_rrc_E_DPDCH_Info = -1;
static gint ett_rrc_E_DPDCH_Info_r7 = -1;
static gint ett_rrc_E_DPDCH_Info_r8 = -1;
static gint ett_rrc_E_DPDCH_Reference_E_TFCI = -1;
static gint ett_rrc_E_DPDCH_Reference_E_TFCI_r7 = -1;
static gint ett_rrc_E_DPDCH_Reference_E_TFCIList = -1;
static gint ett_rrc_E_DPDCH_Reference_E_TFCIList_r7 = -1;
static gint ett_rrc_E_DPDCH_SchedulingInfoConfiguration = -1;
static gint ett_rrc_E_DPDCH_SchedulingTransmConfiguration = -1;
static gint ett_rrc_T_servingGrant_04 = -1;
static gint ett_rrc_E_HICH_Information = -1;
static gint ett_rrc_E_HICH_Information_r11 = -1;
static gint ett_rrc_E_HICH_Information_CommonEdch = -1;
static gint ett_rrc_E_HICH_Information_TDD384_768 = -1;
static gint ett_rrc_T_modeSpecificInfo_56 = -1;
static gint ett_rrc_E_HICH_Information_LCR = -1;
static gint ett_rrc_T_midambleAllocationMode_01 = -1;
static gint ett_rrc_E_HICH_Information_TDD128 = -1;
static gint ett_rrc_E_HICH_Information_LCR_List = -1;
static gint ett_rrc_E_HICH_Information_For_SPS_TDD128 = -1;
static gint ett_rrc_T_configurationmode = -1;
static gint ett_rrc_T_implicit = -1;
static gint ett_rrc_T_explicit_02 = -1;
static gint ett_rrc_T_midambleAllocationMode_02 = -1;
static gint ett_rrc_E_PUCH_Info = -1;
static gint ett_rrc_T_modeSpecificInfo_57 = -1;
static gint ett_rrc_T_tdd348_tdd768 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_2_OF_E_PUCH_TS_Slots = -1;
static gint ett_rrc_T_tdd128_33 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_LCR_1_OF_E_PUCH_TS_Slots_LCR = -1;
static gint ett_rrc_E_PUCH_Info_TDD128 = -1;
static gint ett_rrc_E_PUCH_Info_MulticarrierEDCH_TDD128 = -1;
static gint ett_rrc_E_PUCH_TS_Slots = -1;
static gint ett_rrc_E_PUCH_TS_Slots_LCR = -1;
static gint ett_rrc_T_midambleAllocationMode_03 = -1;
static gint ett_rrc_E_RGCH_Information = -1;
static gint ett_rrc_E_RGCH_Information_CommonEdch = -1;
static gint ett_rrc_E_RUCCH_Info = -1;
static gint ett_rrc_T_modeSpecificInfo_58 = -1;
static gint ett_rrc_T_tdd384_tdd768_03 = -1;
static gint ett_rrc_T_modeSpecificInfo_59 = -1;
static gint ett_rrc_T_tdd384_21 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_8_OF_SF16Codes = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_8_OF_SF8Codes = -1;
static gint ett_rrc_T_tdd768_13 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_16_OF_SF32Codes = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_16_OF_SF16Codes2 = -1;
static gint ett_rrc_T_tdd128_34 = -1;
static gint ett_rrc_E_RUCCH_Info_TDD128 = -1;
static gint ett_rrc_E_TFC_Boost_Info_r7 = -1;
static gint ett_rrc_E_TFCS_Info = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_8_OF_Reference_Beta_QPSK = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_8_OF_Reference_Beta_16QAM = -1;
static gint ett_rrc_EARFCNRange = -1;
static gint ett_rrc_EXT_UL_TimingAdvance = -1;
static gint ett_rrc_T_modeSpecificInfo_60 = -1;
static gint ett_rrc_T_tdd384_22 = -1;
static gint ett_rrc_T_tdd768_14 = -1;
static gint ett_rrc_FACH_PCH_Information = -1;
static gint ett_rrc_FACH_PCH_InformationList = -1;
static gint ett_rrc_Fallback_R99_PRACH_info_IEs = -1;
static gint ett_rrc_FPACH_Info_r4 = -1;
static gint ett_rrc_F_TPICH_InfoNewServingCell = -1;
static gint ett_rrc_F_TPICH_InfoOtherCell = -1;
static gint ett_rrc_T_f_tpich_Info = -1;
static gint ett_rrc_F_TPICH_Information = -1;
static gint ett_rrc_F_TPICH_ReconfigurationInfo = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxRL_OF_F_TPICH_InfoOtherCell = -1;
static gint ett_rrc_FreqIndexListForEnhancedMeas = -1;
static gint ett_rrc_FrequencyInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_61 = -1;
static gint ett_rrc_FrequencyInfoFDD = -1;
static gint ett_rrc_FrequencyInfoTDD = -1;
static gint ett_rrc_HS_ChannelisationCodeSetInfo_LCR = -1;
static gint ett_rrc_HS_DSCH_CommonSystemInformation = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxCommonHRNTI_OF_H_RNTI = -1;
static gint ett_rrc_HS_DSCH_CommonSystemInformation_TDD128 = -1;
static gint ett_rrc_HS_DSCH_DrxCellfach_info = -1;
static gint ett_rrc_HS_DSCH_DrxCellfach_info_TDD128 = -1;
static gint ett_rrc_HS_DSCH_DrxCellfach_SecondDrx_info = -1;
static gint ett_rrc_T_drx_level = -1;
static gint ett_rrc_T_one_level_DRX = -1;
static gint ett_rrc_T_two_level_DRX = -1;
static gint ett_rrc_HS_DSCH_PagingSystemInformation = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxSCCPCH_OF_PICH_ForHSDPASupportedPaging = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_2_OF_TransportBlockSizeIndex = -1;
static gint ett_rrc_HS_DSCH_PagingSystemInformation_TDD128 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxSCCPCH_OF_PICH_ForHSDPASupportedPaging_TDD128 = -1;
static gint ett_rrc_HS_DSCH_RxPatternList_TDD128 = -1;
static gint ett_rrc_HS_DSCH_RxPatternList_TDD128_item = -1;
static gint ett_rrc_HS_DSCH_TbsList_TDD128 = -1;
static gint ett_rrc_HS_DSCH_TbsList_TDD128_item = -1;
static gint ett_rrc_HS_DSCH_SPS_Information_TDD128 = -1;
static gint ett_rrc_T_hs_dsch_SPS_Operation = -1;
static gint ett_rrc_HS_DSCH_SPS_NewOperation_TDD128 = -1;
static gint ett_rrc_T_hARQInfoForSPS = -1;
static gint ett_rrc_T_initialSPSInfoForHSDSCH = -1;
static gint ett_rrc_HS_PDSCH_Midamble_Configuration_TDD128 = -1;
static gint ett_rrc_T_midambleAllocationMode_04 = -1;
static gint ett_rrc_HS_SCCH_Info = -1;
static gint ett_rrc_T_modeSpecificInfo_62 = -1;
static gint ett_rrc_T_fdd_93 = -1;
static gint ett_rrc_T_tdd_50 = -1;
static gint ett_rrc_T_tdd384_23 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD384 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128 = -1;
static gint ett_rrc_HS_SCCH_Info_r6 = -1;
static gint ett_rrc_T_modeSpecificInfo_63 = -1;
static gint ett_rrc_T_fdd_94 = -1;
static gint ett_rrc_T_tdd_51 = -1;
static gint ett_rrc_T_tdd384_24 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD384_r6 = -1;
static gint ett_rrc_T_tdd128_35 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_r6 = -1;
static gint ett_rrc_HS_SCCH_Info_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_64 = -1;
static gint ett_rrc_T_fdd_95 = -1;
static gint ett_rrc_T_tdd_52 = -1;
static gint ett_rrc_T_tdd384_25 = -1;
static gint ett_rrc_T_tdd768_15 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD768 = -1;
static gint ett_rrc_T_tdd128_36 = -1;
static gint ett_rrc_HS_SCCH_Info_r8_ext = -1;
static gint ett_rrc_T_modeSpecificInfo_65 = -1;
static gint ett_rrc_T_tdd_53 = -1;
static gint ett_rrc_T_tdd128_37 = -1;
static gint ett_rrc_HS_SCCH_Info_r9 = -1;
static gint ett_rrc_T_modeSpecificInfo_66 = -1;
static gint ett_rrc_T_fdd_96 = -1;
static gint ett_rrc_T_tdd_54 = -1;
static gint ett_rrc_T_tdd384_26 = -1;
static gint ett_rrc_T_tdd768_16 = -1;
static gint ett_rrc_T_tdd128_38 = -1;
static gint ett_rrc_HS_SCCH_DRX_Info_TDD128 = -1;
static gint ett_rrc_HS_SCCH_Less_NewOperation = -1;
static gint ett_rrc_HS_SCCH_LessInfo_r7 = -1;
static gint ett_rrc_T_hs_scchLessOperation = -1;
static gint ett_rrc_HS_SCCH_LessTFSList = -1;
static gint ett_rrc_HS_SCCH_LessTFSList_item = -1;
static gint ett_rrc_HS_SCCH_SystemInfo = -1;
static gint ett_rrc_HS_SCCH_SystemInfo_TDD128 = -1;
static gint ett_rrc_HS_SCCH_TDD128 = -1;
static gint ett_rrc_T_midambleAllocationMode_05 = -1;
static gint ett_rrc_HS_SCCH_TDD128_r6 = -1;
static gint ett_rrc_T_midambleAllocationMode_06 = -1;
static gint ett_rrc_HS_SCCH_TDD128_MultiCarrier = -1;
static gint ett_rrc_T_midambleAllocationMode_07 = -1;
static gint ett_rrc_HS_SICH_Configuration_TDD128 = -1;
static gint ett_rrc_T_midambleAllocationMode_08 = -1;
static gint ett_rrc_T_ueSpecificMidamble = -1;
static gint ett_rrc_HS_SICH_Configuration_TDD128_r6 = -1;
static gint ett_rrc_T_midambleAllocationMode_09 = -1;
static gint ett_rrc_T_ueSpecificMidamble_01 = -1;
static gint ett_rrc_HS_SICH_List_TDD128 = -1;
static gint ett_rrc_HS_SICH_List_TDD128_item = -1;
static gint ett_rrc_T_implicit_01 = -1;
static gint ett_rrc_T_explicit_03 = -1;
static gint ett_rrc_HS_SICH_ReferenceSignalInfoList = -1;
static gint ett_rrc_HS_SICH_ReferenceSignalInfoList_item = -1;
static gint ett_rrc_HS_SCCH_TDD384 = -1;
static gint ett_rrc_T_midambleAllocationMode_10 = -1;
static gint ett_rrc_T_ueSpecificMidamble_02 = -1;
static gint ett_rrc_HS_SCCH_TDD384_r6 = -1;
static gint ett_rrc_T_midambleAllocationMode_11 = -1;
static gint ett_rrc_T_ueSpecificMidamble_03 = -1;
static gint ett_rrc_HS_SCCH_TDD768 = -1;
static gint ett_rrc_T_midambleAllocationMode_12 = -1;
static gint ett_rrc_T_ueSpecificMidamble_04 = -1;
static gint ett_rrc_HS_SICH_Configuration_TDD384 = -1;
static gint ett_rrc_T_midambleAllocationMode_13 = -1;
static gint ett_rrc_T_ueSpecificMidamble_05 = -1;
static gint ett_rrc_HS_SICH_Configuration_TDD768 = -1;
static gint ett_rrc_T_midambleAllocationMode_14 = -1;
static gint ett_rrc_T_ueSpecificMidamble_06 = -1;
static gint ett_rrc_HS_SICH_Power_Control_Info_TDD384 = -1;
static gint ett_rrc_HS_SICH_Power_Control_Info_TDD768 = -1;
static gint ett_rrc_IndividualTimeslotInfo = -1;
static gint ett_rrc_IndividualTimeslotInfo_VHCR = -1;
static gint ett_rrc_IndividualTimeslotInfo_LCR_r4 = -1;
static gint ett_rrc_IndividualTimeslotInfo_LCR_r4_ext = -1;
static gint ett_rrc_IndividualTimeslotInfo_r7 = -1;
static gint ett_rrc_IndividualTS_Interference = -1;
static gint ett_rrc_IndividualTS_InterferenceList = -1;
static gint ett_rrc_Measurement_Feedback_Info = -1;
static gint ett_rrc_T_modeSpecificInfo_67 = -1;
static gint ett_rrc_T_fdd_97 = -1;
static gint ett_rrc_Measurement_Feedback_Info_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_68 = -1;
static gint ett_rrc_T_fdd_98 = -1;
static gint ett_rrc_Measurement_Feedback_Info_r11 = -1;
static gint ett_rrc_T_modeSpecificInfo_69 = -1;
static gint ett_rrc_T_fdd_99 = -1;
static gint ett_rrc_Measurement_Feedback_Info_ConcurrentTTI = -1;
static gint ett_rrc_MidambleShiftAndBurstType = -1;
static gint ett_rrc_T_burstType = -1;
static gint ett_rrc_T_type1_01 = -1;
static gint ett_rrc_T_midambleAllocationMode_15 = -1;
static gint ett_rrc_T_ueSpecificMidamble_07 = -1;
static gint ett_rrc_T_type2 = -1;
static gint ett_rrc_T_midambleAllocationMode_16 = -1;
static gint ett_rrc_T_ueSpecificMidamble_08 = -1;
static gint ett_rrc_T_type3 = -1;
static gint ett_rrc_T_midambleAllocationMode_17 = -1;
static gint ett_rrc_T_ueSpecificMidamble_09 = -1;
static gint ett_rrc_MidambleShiftAndBurstType_VHCR = -1;
static gint ett_rrc_T_burstType_01 = -1;
static gint ett_rrc_T_type1_02 = -1;
static gint ett_rrc_T_midambleAllocationMode_18 = -1;
static gint ett_rrc_T_ueSpecificMidamble_10 = -1;
static gint ett_rrc_T_type2_01 = -1;
static gint ett_rrc_T_midambleAllocationMode_19 = -1;
static gint ett_rrc_T_ueSpecificMidamble_11 = -1;
static gint ett_rrc_T_type3_01 = -1;
static gint ett_rrc_T_midambleAllocationMode_20 = -1;
static gint ett_rrc_T_ueSpecificMidamble_12 = -1;
static gint ett_rrc_MidambleShiftAndBurstType_r7 = -1;
static gint ett_rrc_T_burstType_02 = -1;
static gint ett_rrc_T_type1_03 = -1;
static gint ett_rrc_T_midambleAllocationMode_21 = -1;
static gint ett_rrc_T_ueSpecificMidamble_13 = -1;
static gint ett_rrc_T_type2_02 = -1;
static gint ett_rrc_T_midambleAllocationMode_22 = -1;
static gint ett_rrc_T_ueSpecificMidamble_14 = -1;
static gint ett_rrc_T_type3_02 = -1;
static gint ett_rrc_T_midambleAllocationMode_23 = -1;
static gint ett_rrc_T_ueSpecificMidamble_15 = -1;
static gint ett_rrc_MidambleShiftAndBurstType_DL = -1;
static gint ett_rrc_T_burstType_03 = -1;
static gint ett_rrc_T_type1_04 = -1;
static gint ett_rrc_T_midambleAllocationMode_24 = -1;
static gint ett_rrc_T_ueSpecificMidamble_16 = -1;
static gint ett_rrc_T_type2_03 = -1;
static gint ett_rrc_T_midambleAllocationMode_25 = -1;
static gint ett_rrc_T_ueSpecificMidamble_17 = -1;
static gint ett_rrc_MidambleShiftAndBurstType_DL_VHCR = -1;
static gint ett_rrc_T_burstType_04 = -1;
static gint ett_rrc_T_type1_05 = -1;
static gint ett_rrc_T_midambleAllocationMode_26 = -1;
static gint ett_rrc_T_ueSpecificMidamble_18 = -1;
static gint ett_rrc_T_type2_04 = -1;
static gint ett_rrc_T_midambleAllocationMode_27 = -1;
static gint ett_rrc_T_ueSpecificMidamble_19 = -1;
static gint ett_rrc_MidambleShiftAndBurstType_LCR_r4 = -1;
static gint ett_rrc_T_midambleAllocationMode_28 = -1;
static gint ett_rrc_T_ueSpecificMidamble_20 = -1;
static gint ett_rrc_MidambleShiftAndBurstType_EDCH = -1;
static gint ett_rrc_T_burstType_05 = -1;
static gint ett_rrc_T_type1_06 = -1;
static gint ett_rrc_T_midambleAllocationMode_29 = -1;
static gint ett_rrc_T_ueSpecificMidamble_21 = -1;
static gint ett_rrc_T_type2_05 = -1;
static gint ett_rrc_T_midambleAllocationMode_30 = -1;
static gint ett_rrc_T_ueSpecificMidamble_22 = -1;
static gint ett_rrc_MIMO_Parameters_r7 = -1;
static gint ett_rrc_MIMO4x4_Parameters = -1;
static gint ett_rrc_T_configurationInfo_04 = -1;
static gint ett_rrc_T_newConfiguration_06 = -1;
static gint ett_rrc_MIMO_Parameters_v7g0ext = -1;
static gint ett_rrc_MIMO_Parameters_r8 = -1;
static gint ett_rrc_T_modeSpecificInfo_70 = -1;
static gint ett_rrc_T_fdd_100 = -1;
static gint ett_rrc_T_tdd_55 = -1;
static gint ett_rrc_T_tdd128_39 = -1;
static gint ett_rrc_MIMO_Parameters_r9 = -1;
static gint ett_rrc_T_modeSpecificInfo_71 = -1;
static gint ett_rrc_T_fdd_101 = -1;
static gint ett_rrc_T_tdd_56 = -1;
static gint ett_rrc_T_tdd128_40 = -1;
static gint ett_rrc_MIMO_PilotConfiguration = -1;
static gint ett_rrc_T_secondCPICH_Pattern = -1;
static gint ett_rrc_T_diversityPattern = -1;
static gint ett_rrc_MIMO_PilotConfiguration_v7f0ext = -1;
static gint ett_rrc_MIMO_PilotConfiguration_r9 = -1;
static gint ett_rrc_T_secondCPICH_Pattern_01 = -1;
static gint ett_rrc_T_diversityPattern_01 = -1;
static gint ett_rrc_MIMO4x4_PilotConfiguration = -1;
static gint ett_rrc_Multi_frequencyInfo_LCR_r7 = -1;
static gint ett_rrc_MultiflowConfigurationInfo = -1;
static gint ett_rrc_MU_MIMO_Info_TDD128 = -1;
static gint ett_rrc_T_newConfiguration_07 = -1;
static gint ett_rrc_NewTiming = -1;
static gint ett_rrc_NodeB_Trigger_HS_DPCCH_Transmission = -1;
static gint ett_rrc_Non_ScheduledTransGrantInfoTDD = -1;
static gint ett_rrc_T_tdd384_768 = -1;
static gint ett_rrc_T_tdd128_41 = -1;
static gint ett_rrc_T_e_HICH_Info_06 = -1;
static gint ett_rrc_T_midambleAllocationMode_31 = -1;
static gint ett_rrc_Non_ScheduledTransGrantInfoTDD_ext = -1;
static gint ett_rrc_T_tdd128_42 = -1;
static gint ett_rrc_Non_ScheduledTransGrantInfoTDD_r9 = -1;
static gint ett_rrc_T_tdd384_768_01 = -1;
static gint ett_rrc_T_tdd128_43 = -1;
static gint ett_rrc_T_e_HICH_Info_07 = -1;
static gint ett_rrc_T_midambleAllocationMode_32 = -1;
static gint ett_rrc_OpenLoopPowerControl_TDD = -1;
static gint ett_rrc_OpenLoopPowerControl_IPDL_TDD_r4 = -1;
static gint ett_rrc_PCCH_InformationList = -1;
static gint ett_rrc_T_paging_associatedHspdschInfo = -1;
static gint ett_rrc_T_paging_associatedHspdschInfo_item = -1;
static gint ett_rrc_PCPCH_ChannelInfo = -1;
static gint ett_rrc_PCPCH_ChannelInfoList = -1;
static gint ett_rrc_PDSCH_CapacityAllocationInfo = -1;
static gint ett_rrc_T_configuration = -1;
static gint ett_rrc_T_old_Configuration = -1;
static gint ett_rrc_T_new_Configuration = -1;
static gint ett_rrc_PDSCH_CapacityAllocationInfo_r4 = -1;
static gint ett_rrc_T_configuration_01 = -1;
static gint ett_rrc_T_old_Configuration_01 = -1;
static gint ett_rrc_T_new_Configuration_01 = -1;
static gint ett_rrc_PDSCH_CapacityAllocationInfo_r7 = -1;
static gint ett_rrc_T_configuration_02 = -1;
static gint ett_rrc_T_old_Configuration_02 = -1;
static gint ett_rrc_T_new_Configuration_02 = -1;
static gint ett_rrc_PDSCH_CodeInfo = -1;
static gint ett_rrc_PDSCH_CodeInfoList = -1;
static gint ett_rrc_PDSCH_CodeMap = -1;
static gint ett_rrc_PDSCH_CodeMapList = -1;
static gint ett_rrc_PDSCH_CodeMapping = -1;
static gint ett_rrc_T_signallingMethod = -1;
static gint ett_rrc_PDSCH_Info = -1;
static gint ett_rrc_PDSCH_Info_r4 = -1;
static gint ett_rrc_T_tddOption_12 = -1;
static gint ett_rrc_T_tdd384_27 = -1;
static gint ett_rrc_T_tdd128_44 = -1;
static gint ett_rrc_PDSCH_Info_r7 = -1;
static gint ett_rrc_T_tddOption_13 = -1;
static gint ett_rrc_T_tdd384_28 = -1;
static gint ett_rrc_T_tdd768_17 = -1;
static gint ett_rrc_T_tdd128_45 = -1;
static gint ett_rrc_PDSCH_Info_LCR_r4 = -1;
static gint ett_rrc_PDSCH_PowerControlInfo = -1;
static gint ett_rrc_PDSCH_SHO_DCH_Info = -1;
static gint ett_rrc_PDSCH_SysInfo = -1;
static gint ett_rrc_PDSCH_SysInfo_VHCR_r7 = -1;
static gint ett_rrc_PDSCH_SysInfo_HCR_r5 = -1;
static gint ett_rrc_PDSCH_SysInfo_LCR_r4 = -1;
static gint ett_rrc_PDSCH_SysInfoList = -1;
static gint ett_rrc_PDSCH_SysInfoList_VHCR_r7 = -1;
static gint ett_rrc_PDSCH_SysInfoList_HCR_r5 = -1;
static gint ett_rrc_PDSCH_SysInfoList_LCR_r4 = -1;
static gint ett_rrc_PDSCH_SysInfoList_SFN = -1;
static gint ett_rrc_PDSCH_SysInfoList_SFN_item = -1;
static gint ett_rrc_PDSCH_SysInfoList_SFN_HCR_r5 = -1;
static gint ett_rrc_PDSCH_SysInfoList_SFN_HCR_r5_item = -1;
static gint ett_rrc_PDSCH_SysInfoList_SFN_LCR_r4 = -1;
static gint ett_rrc_PDSCH_SysInfoList_SFN_LCR_r4_item = -1;
static gint ett_rrc_PersistenceScalingFactorList = -1;
static gint ett_rrc_PichChannelisationCodeList_LCR_r4 = -1;
static gint ett_rrc_PICH_ForHSDPASupportedPaging = -1;
static gint ett_rrc_PICH_ForHSDPASupportedPaging_TDD128 = -1;
static gint ett_rrc_T_implicit_02 = -1;
static gint ett_rrc_PICH_Info = -1;
static gint ett_rrc_T_fdd_102 = -1;
static gint ett_rrc_T_tdd_57 = -1;
static gint ett_rrc_PICH_Info_HCR_VHCR_r7 = -1;
static gint ett_rrc_T_channelisationCode = -1;
static gint ett_rrc_PICH_Info_LCR_r4 = -1;
static gint ett_rrc_PLCCH_Info = -1;
static gint ett_rrc_PowerControlAlgorithm = -1;
static gint ett_rrc_PRACH_ChanCodes_LCR_r4 = -1;
static gint ett_rrc_PRACH_ChanCodes_List_LCR = -1;
static gint ett_rrc_PRACH_Definition_LCR_r4 = -1;
static gint ett_rrc_PRACH_Information_LCR = -1;
static gint ett_rrc_PRACH_Information_LCR_List = -1;
static gint ett_rrc_PRACH_Partitioning = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_FDD = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_TDD = -1;
static gint ett_rrc_PRACH_Partitioning_r7 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_TDD_r7 = -1;
static gint ett_rrc_PRACH_Partitioning_LCR_r4 = -1;
static gint ett_rrc_PRACH_PowerOffset = -1;
static gint ett_rrc_PRACH_PreambleForEnhancedUplink = -1;
static gint ett_rrc_PRACH_PreambleForEnhancedUplinkExt = -1;
static gint ett_rrc_PRACH_PreambleForEnhancedUplinkExtList = -1;
static gint ett_rrc_PRACH_PreambleForEnhancedUplinkExtWithWeight = -1;
static gint ett_rrc_PRACH_RACH_Info = -1;
static gint ett_rrc_T_modeSpecificInfo_72 = -1;
static gint ett_rrc_T_fdd_103 = -1;
static gint ett_rrc_T_tdd_58 = -1;
static gint ett_rrc_PRACH_RACH_Info_VHCR_r7 = -1;
static gint ett_rrc_PRACH_RACH_Info_LCR_v770ext = -1;
static gint ett_rrc_PRACH_RACH_Info_LCR_r4 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxPRACH_FPACH_OF_PRACH_Definition_LCR_r4 = -1;
static gint ett_rrc_PRACH_SystemInformation = -1;
static gint ett_rrc_T_modeSpecificInfo_73 = -1;
static gint ett_rrc_T_fdd_104 = -1;
static gint ett_rrc_PRACH_SystemInformation_VHCR_r7 = -1;
static gint ett_rrc_PRACH_SystemInformation_LCR_r4 = -1;
static gint ett_rrc_PRACH_SystemInformation_LCR_v770ext = -1;
static gint ett_rrc_PRACH_SystemInformationList = -1;
static gint ett_rrc_PRACH_SystemInformationList_VHCR_r7 = -1;
static gint ett_rrc_PRACH_SystemInformationList_LCR_r4 = -1;
static gint ett_rrc_PRACH_SystemInformationList_LCR_v770ext = -1;
static gint ett_rrc_PreDefPhyChConfiguration = -1;
static gint ett_rrc_PreDefPhyChConfiguration_v770ext = -1;
static gint ett_rrc_PrimaryCCPCH_Info = -1;
static gint ett_rrc_T_fdd_105 = -1;
static gint ett_rrc_T_tdd_59 = -1;
static gint ett_rrc_T_syncCase = -1;
static gint ett_rrc_T_syncCase1 = -1;
static gint ett_rrc_T_syncCase2 = -1;
static gint ett_rrc_PrimaryCCPCH_Info_r4 = -1;
static gint ett_rrc_T_fdd_106 = -1;
static gint ett_rrc_T_tdd_60 = -1;
static gint ett_rrc_T_tddOption_14 = -1;
static gint ett_rrc_T_tdd384_tdd768_04 = -1;
static gint ett_rrc_T_syncCase_01 = -1;
static gint ett_rrc_T_syncCase1_01 = -1;
static gint ett_rrc_T_syncCase2_01 = -1;
static gint ett_rrc_T_tdd128_46 = -1;
static gint ett_rrc_PrimaryCCPCH_Info_LCR_r4 = -1;
static gint ett_rrc_PrimaryCCPCH_Info_LCR_r4_ext = -1;
static gint ett_rrc_PrimaryCCPCH_InfoPost = -1;
static gint ett_rrc_T_syncCase_02 = -1;
static gint ett_rrc_T_syncCase1_02 = -1;
static gint ett_rrc_T_syncCase2_02 = -1;
static gint ett_rrc_PrimaryCCPCH_InfoPostTDD_LCR_r4 = -1;
static gint ett_rrc_PrimaryCPICH_Info = -1;
static gint ett_rrc_PUSCH_CapacityAllocationInfo = -1;
static gint ett_rrc_T_pusch_Allocation = -1;
static gint ett_rrc_T_pusch_AllocationAssignment = -1;
static gint ett_rrc_T_configuration_03 = -1;
static gint ett_rrc_T_old_Configuration_03 = -1;
static gint ett_rrc_T_new_Configuration_03 = -1;
static gint ett_rrc_PUSCH_CapacityAllocationInfo_r4 = -1;
static gint ett_rrc_T_pusch_Allocation_01 = -1;
static gint ett_rrc_T_pusch_AllocationAssignment_01 = -1;
static gint ett_rrc_T_configuration_04 = -1;
static gint ett_rrc_T_old_Configuration_04 = -1;
static gint ett_rrc_T_new_Configuration_04 = -1;
static gint ett_rrc_PUSCH_CapacityAllocationInfo_r7 = -1;
static gint ett_rrc_T_pusch_Allocation_02 = -1;
static gint ett_rrc_T_pusch_AllocationAssignment_02 = -1;
static gint ett_rrc_T_configuration_05 = -1;
static gint ett_rrc_T_old_Configuration_05 = -1;
static gint ett_rrc_T_new_Configuration_05 = -1;
static gint ett_rrc_PUSCH_Info = -1;
static gint ett_rrc_PUSCH_Info_r4 = -1;
static gint ett_rrc_T_tddOption_15 = -1;
static gint ett_rrc_T_tdd384_29 = -1;
static gint ett_rrc_T_tdd128_47 = -1;
static gint ett_rrc_PUSCH_Info_VHCR = -1;
static gint ett_rrc_PUSCH_Info_LCR_r4 = -1;
static gint ett_rrc_PUSCH_PowerControlInfo_r4 = -1;
static gint ett_rrc_T_tddOption_16 = -1;
static gint ett_rrc_T_tdd128_48 = -1;
static gint ett_rrc_PUSCH_PowerControlInfo_r7 = -1;
static gint ett_rrc_T_tddOption_17 = -1;
static gint ett_rrc_T_tdd128_49 = -1;
static gint ett_rrc_PUSCH_SysInfo = -1;
static gint ett_rrc_PUSCH_SysInfo_VHCR = -1;
static gint ett_rrc_PUSCH_SysInfo_HCR_r5 = -1;
static gint ett_rrc_PUSCH_SysInfo_LCR_r4 = -1;
static gint ett_rrc_PUSCH_SysInfoList = -1;
static gint ett_rrc_PUSCH_SysInfoList_HCR_r5 = -1;
static gint ett_rrc_PUSCH_SysInfoList_LCR_r4 = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN_item = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN_HCR_r5 = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN_HCR_r5_item = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN_LCR_r4 = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN_LCR_r4_item = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN_VHCR = -1;
static gint ett_rrc_PUSCH_SysInfoList_SFN_VHCR_item = -1;
static gint ett_rrc_RACH_TransmissionParameters = -1;
static gint ett_rrc_Reference_Beta_QPSK = -1;
static gint ett_rrc_Reference_Beta_16QAM = -1;
static gint ett_rrc_RepetitionPeriodAndLength = -1;
static gint ett_rrc_RepetitionPeriodLengthAndOffset = -1;
static gint ett_rrc_T_repetitionPeriod2 = -1;
static gint ett_rrc_T_repetitionPeriod4 = -1;
static gint ett_rrc_T_repetitionPeriod8 = -1;
static gint ett_rrc_T_repetitionPeriod16 = -1;
static gint ett_rrc_T_repetitionPeriod32 = -1;
static gint ett_rrc_T_repetitionPeriod64 = -1;
static gint ett_rrc_RepetitionPeriodAndLengthForSPS = -1;
static gint ett_rrc_ReplacedPDSCH_CodeInfo = -1;
static gint ett_rrc_ReplacedPDSCH_CodeInfoList = -1;
static gint ett_rrc_RepPerLengthOffset_PICH = -1;
static gint ett_rrc_RepPerLengthOffset_MICH = -1;
static gint ett_rrc_RestrictedTrCH = -1;
static gint ett_rrc_RestrictedTrCH_InfoList = -1;
static gint ett_rrc_RL_AdditionInformation = -1;
static gint ett_rrc_RL_AdditionInformation_r6 = -1;
static gint ett_rrc_T_dl_dpchInfo_04 = -1;
static gint ett_rrc_RL_AdditionInformation_r7 = -1;
static gint ett_rrc_T_dl_dpchInfo_05 = -1;
static gint ett_rrc_RL_AdditionInformation_r8 = -1;
static gint ett_rrc_T_dl_dpchInfo_06 = -1;
static gint ett_rrc_RL_AdditionInformation_r9 = -1;
static gint ett_rrc_T_dl_dpchInfo_07 = -1;
static gint ett_rrc_RL_AdditionInformation_r10 = -1;
static gint ett_rrc_T_dl_dpchInfo_08 = -1;
static gint ett_rrc_RL_AdditionInformation_vb50ext = -1;
static gint ett_rrc_RL_AdditionInformation_r11 = -1;
static gint ett_rrc_T_dl_dpchInfo_09 = -1;
static gint ett_rrc_RL_AdditionInformation_v6b0ext = -1;
static gint ett_rrc_RL_AdditionInformation_v890ext = -1;
static gint ett_rrc_RL_AdditionInformation_v950ext = -1;
static gint ett_rrc_RL_AdditionInformationList = -1;
static gint ett_rrc_RL_AdditionInformationList_r6 = -1;
static gint ett_rrc_RL_AdditionInformationList_r7 = -1;
static gint ett_rrc_RL_AdditionInformation_list_v6b0ext = -1;
static gint ett_rrc_RL_AdditionInformationList_r8 = -1;
static gint ett_rrc_RL_AdditionInformationList_v890ext = -1;
static gint ett_rrc_RL_AdditionInformationList_r9 = -1;
static gint ett_rrc_RL_AdditionInformationList_v950ext = -1;
static gint ett_rrc_RL_AdditionInformationList_r10 = -1;
static gint ett_rrc_RL_AdditionInformationList_vb50ext = -1;
static gint ett_rrc_RL_AdditionInformationList_r11 = -1;
static gint ett_rrc_RL_AdditionInformationList_SecULFreq = -1;
static gint ett_rrc_RL_AdditionInformation_SecULFreq = -1;
static gint ett_rrc_RL_IdentifierList = -1;
static gint ett_rrc_RL_RemovalInformationList = -1;
static gint ett_rrc_RL_RemovalInformationList_SecULFreq = -1;
static gint ett_rrc_SCCPCH_ChannelisationCodeList = -1;
static gint ett_rrc_SCCPCH_ChannelisationCodeList_VHCR = -1;
static gint ett_rrc_SCCPCH_InfoForFACH = -1;
static gint ett_rrc_T_modeSpecificInfo_74 = -1;
static gint ett_rrc_T_fdd_107 = -1;
static gint ett_rrc_T_tdd_61 = -1;
static gint ett_rrc_SCCPCH_InfoForFACH_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_75 = -1;
static gint ett_rrc_T_fdd_108 = -1;
static gint ett_rrc_SCCPCH_SystemInformation = -1;
static gint ett_rrc_SCCPCH_SystemInformation_LCR_r4_ext = -1;
static gint ett_rrc_SCCPCH_SystemInformation_HCR_VHCR_r7 = -1;
static gint ett_rrc_SCCPCH_SystemInformationList = -1;
static gint ett_rrc_SCCPCH_SystemInformationList_HCR_VHCR_r7 = -1;
static gint ett_rrc_SCCPCH_SystemInformationList_LCR_r4_ext = -1;
static gint ett_rrc_SCCPCH_SystemInformation_MBMS_r6 = -1;
static gint ett_rrc_T_fachCarryingMCCH = -1;
static gint ett_rrc_T_fachCarryingMSCH = -1;
static gint ett_rrc_SCCPCH_SystemInformation_MBMS_r7 = -1;
static gint ett_rrc_T_fachCarryingMCCH_01 = -1;
static gint ett_rrc_T_fachCarryingMSCH_01 = -1;
static gint ett_rrc_ScheduledTransmissionConfiguration = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxEDCHs_OF_Common_E_DCH_ResourceInfoListExt = -1;
static gint ett_rrc_SecondaryCCPCH_Info = -1;
static gint ett_rrc_T_modeSpecificInfo_76 = -1;
static gint ett_rrc_T_fdd_109 = -1;
static gint ett_rrc_T_tdd_62 = -1;
static gint ett_rrc_SecondaryCCPCH_Info_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_77 = -1;
static gint ett_rrc_T_fdd_110 = -1;
static gint ett_rrc_T_tdd_63 = -1;
static gint ett_rrc_T_tddOption_18 = -1;
static gint ett_rrc_T_tdd384_30 = -1;
static gint ett_rrc_T_tdd128_50 = -1;
static gint ett_rrc_SecondaryCCPCH_Info_HCR_VHCR_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_78 = -1;
static gint ett_rrc_T_tdd384_31 = -1;
static gint ett_rrc_T_tdd768_18 = -1;
static gint ett_rrc_SecondaryCCPCH_Info_LCR_r4_ext = -1;
static gint ett_rrc_SecondaryCCPCHFrameType2Info = -1;
static gint ett_rrc_T_modulation_03 = -1;
static gint ett_rrc_T_mod16QAM = -1;
static gint ett_rrc_SecondaryCCPCHInfo_MBMS_r6 = -1;
static gint ett_rrc_T_modeSpecificInfo_79 = -1;
static gint ett_rrc_T_fdd_111 = -1;
static gint ett_rrc_T_tdd384_32 = -1;
static gint ett_rrc_T_tdd128_51 = -1;
static gint ett_rrc_SecondaryCCPCHInfo_MBMS_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_80 = -1;
static gint ett_rrc_T_fdd_112 = -1;
static gint ett_rrc_T_modulation_04 = -1;
static gint ett_rrc_T_tdd384_33 = -1;
static gint ett_rrc_T_tdd768_19 = -1;
static gint ett_rrc_T_tdd128_52 = -1;
static gint ett_rrc_SecondaryCCPCHInfoDiff_MBMS = -1;
static gint ett_rrc_SecondaryCPICH_Info = -1;
static gint ett_rrc_SecondaryCellMIMOparametersFDD = -1;
static gint ett_rrc_T_newConfiguration_08 = -1;
static gint ett_rrc_SecondaryCellMIMOparametersFDD_v950ext = -1;
static gint ett_rrc_SecondaryCellMIMOparametersFDD_r10 = -1;
static gint ett_rrc_T_newConfiguration_09 = -1;
static gint ett_rrc_SecondaryCell4x4MIMOparametersFDD = -1;
static gint ett_rrc_T_configurationInfo_05 = -1;
static gint ett_rrc_T_newConfiguration_10 = -1;
static gint ett_rrc_ServingCellChangeParameters = -1;
static gint ett_rrc_SF256_AndCodeNumber = -1;
static gint ett_rrc_SF512_AndCodeNumber = -1;
static gint ett_rrc_SF512_AndPilot = -1;
static gint ett_rrc_SFN_TimeInfo = -1;
static gint ett_rrc_SPS_Information_TDD128_r8 = -1;
static gint ett_rrc_SSDT_Information = -1;
static gint ett_rrc_SSDT_Information_r4 = -1;
static gint ett_rrc_StandaloneMidambleInfo_TDD128 = -1;
static gint ett_rrc_SynchronisationParameters_r4 = -1;
static gint ett_rrc_T_sync_UL_CodesBitmap = -1;
static gint ett_rrc_Sync_UL_Codes_Bitmap = -1;
static gint ett_rrc_SYNC_UL_Procedure_r4 = -1;
static gint ett_rrc_SYNC_UL_Info_r4 = -1;
static gint ett_rrc_SYNC_UL_InfoForE_RUCCH = -1;
static gint ett_rrc_TargetCellPreconfigInfo = -1;
static gint ett_rrc_TargetCellPreconfigInfo_r9 = -1;
static gint ett_rrc_TargetCellPreconfigInfo_r10 = -1;
static gint ett_rrc_TargetCellPreconfigInfo_vb50ext = -1;
static gint ett_rrc_TargetCellPreconfigInfo_r11 = -1;
static gint ett_rrc_TDD_MBSFNInformation = -1;
static gint ett_rrc_TDD_MBSFNTSlotInfo = -1;
static gint ett_rrc_TDD_PRACH_CCodeList = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_8_OF_TDD_PRACH_CCode8 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_8_OF_TDD_PRACH_CCode16 = -1;
static gint ett_rrc_TDD768_PRACH_CCodeList = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_16_OF_TDD768_PRACH_CCode32 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_16_OF_TDD768_PRACH_CCode16 = -1;
static gint ett_rrc_TGP_Sequence = -1;
static gint ett_rrc_T_tgps_Status = -1;
static gint ett_rrc_T_activate = -1;
static gint ett_rrc_TGP_Sequence_r8 = -1;
static gint ett_rrc_T_tgps_Status_01 = -1;
static gint ett_rrc_T_activate_01 = -1;
static gint ett_rrc_TGP_Sequence_r10 = -1;
static gint ett_rrc_T_tgps_Status_02 = -1;
static gint ett_rrc_T_activate_02 = -1;
static gint ett_rrc_TGP_SequenceList = -1;
static gint ett_rrc_TGP_SequenceList_r8 = -1;
static gint ett_rrc_TGP_SequenceList_r10 = -1;
static gint ett_rrc_TGP_SequenceShort = -1;
static gint ett_rrc_T_tgps_Status_03 = -1;
static gint ett_rrc_T_activate_03 = -1;
static gint ett_rrc_TGP_SequenceShort_r10 = -1;
static gint ett_rrc_T_tgps_Status_04 = -1;
static gint ett_rrc_T_activate_04 = -1;
static gint ett_rrc_TGPS_ConfigurationParams = -1;
static gint ett_rrc_TGPS_ConfigurationParams_r8 = -1;
static gint ett_rrc_TGPS_ConfigurationParams_r10 = -1;
static gint ett_rrc_TimeInfo = -1;
static gint ett_rrc_TimeslotList = -1;
static gint ett_rrc_TimeslotList_r4 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_OF_TimeslotNumber = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_LCR_OF_TimeslotNumber_LCR_r4 = -1;
static gint ett_rrc_DTX_DRX_TimingInfo_r7 = -1;
static gint ett_rrc_T_timing = -1;
static gint ett_rrc_TwoMsHarqConfiguration = -1;
static gint ett_rrc_UCSM_Info = -1;
static gint ett_rrc_UL_16QAM_Config = -1;
static gint ett_rrc_UL_16QAM_Settings = -1;
static gint ett_rrc_UL_64QAM_Config = -1;
static gint ett_rrc_UL_64QAM_Settings = -1;
static gint ett_rrc_UL_CCTrCH = -1;
static gint ett_rrc_UL_CCTrCH_r4 = -1;
static gint ett_rrc_T_tddOption_19 = -1;
static gint ett_rrc_T_tdd384_34 = -1;
static gint ett_rrc_T_tdd128_53 = -1;
static gint ett_rrc_UL_CCTrCH_r7 = -1;
static gint ett_rrc_T_tddOption_20 = -1;
static gint ett_rrc_T_tdd384_35 = -1;
static gint ett_rrc_T_tdd768_20 = -1;
static gint ett_rrc_T_tdd128_54 = -1;
static gint ett_rrc_UL_CCTrCHList = -1;
static gint ett_rrc_UL_CCTrCHList_r4 = -1;
static gint ett_rrc_UL_CCTrCHList_r7 = -1;
static gint ett_rrc_UL_CCTrCHListToRemove = -1;
static gint ett_rrc_UL_CCTrChTPCList = -1;
static gint ett_rrc_UL_ChannelRequirement = -1;
static gint ett_rrc_UL_ChannelRequirement_r4 = -1;
static gint ett_rrc_UL_ChannelRequirement_r5 = -1;
static gint ett_rrc_UL_ChannelRequirementWithCPCH_SetID = -1;
static gint ett_rrc_UL_ChannelRequirementWithCPCH_SetID_r4 = -1;
static gint ett_rrc_UL_ChannelRequirementWithCPCH_SetID_r5 = -1;
static gint ett_rrc_UL_CLTD_InfoFDD = -1;
static gint ett_rrc_T_configurationInfo_06 = -1;
static gint ett_rrc_T_newConfiguration_11 = -1;
static gint ett_rrc_UL_DL_Mode = -1;
static gint ett_rrc_T_ul_and_dl = -1;
static gint ett_rrc_UL_DPCH_CodeInfoForCommonEDCH = -1;
static gint ett_rrc_UL_DPCH_Info = -1;
static gint ett_rrc_T_modeSpecificInfo_81 = -1;
static gint ett_rrc_T_fdd_113 = -1;
static gint ett_rrc_T_tdd_64 = -1;
static gint ett_rrc_UL_DPCH_Info_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_82 = -1;
static gint ett_rrc_T_fdd_114 = -1;
static gint ett_rrc_T_tdd_65 = -1;
static gint ett_rrc_UL_DPCH_Info_r5 = -1;
static gint ett_rrc_T_modeSpecificInfo_83 = -1;
static gint ett_rrc_T_fdd_115 = -1;
static gint ett_rrc_T_tdd_66 = -1;
static gint ett_rrc_UL_DPCH_Info_r6 = -1;
static gint ett_rrc_T_modeSpecificInfo_84 = -1;
static gint ett_rrc_T_fdd_116 = -1;
static gint ett_rrc_T_dpdchPresence = -1;
static gint ett_rrc_T_present_02 = -1;
static gint ett_rrc_T_notPresent = -1;
static gint ett_rrc_T_tdd_67 = -1;
static gint ett_rrc_UL_DPCH_Info_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_85 = -1;
static gint ett_rrc_T_fdd_117 = -1;
static gint ett_rrc_T_dpdchPresence_01 = -1;
static gint ett_rrc_T_present_03 = -1;
static gint ett_rrc_T_notPresent_01 = -1;
static gint ett_rrc_T_tdd_68 = -1;
static gint ett_rrc_UL_DPCH_Info_r11 = -1;
static gint ett_rrc_T_modeSpecificInfo_86 = -1;
static gint ett_rrc_T_fdd_118 = -1;
static gint ett_rrc_T_dpdchPresence_02 = -1;
static gint ett_rrc_T_present_04 = -1;
static gint ett_rrc_T_notPresent_02 = -1;
static gint ett_rrc_T_tdd_69 = -1;
static gint ett_rrc_UL_DPCH_InfoPostFDD = -1;
static gint ett_rrc_UL_DPCH_InfoPostTDD = -1;
static gint ett_rrc_UL_DPCH_InfoPostTDD_LCR_r4 = -1;
static gint ett_rrc_UL_DPCH_InfoPredef = -1;
static gint ett_rrc_T_modeSpecificInfo_87 = -1;
static gint ett_rrc_T_fdd_119 = -1;
static gint ett_rrc_T_tdd_70 = -1;
static gint ett_rrc_UL_DPCH_InfoPredef_v770ext = -1;
static gint ett_rrc_T_modeSpecificInfo_88 = -1;
static gint ett_rrc_T_fdd_120 = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfo = -1;
static gint ett_rrc_T_fdd_121 = -1;
static gint ett_rrc_T_tdd_71 = -1;
static gint ett_rrc_T_ul_OL_PC_Signalling = -1;
static gint ett_rrc_T_individuallySignalled = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfo_r4 = -1;
static gint ett_rrc_T_fdd_122 = -1;
static gint ett_rrc_T_tdd_72 = -1;
static gint ett_rrc_T_ul_OL_PC_Signalling_01 = -1;
static gint ett_rrc_T_individuallySignalled_01 = -1;
static gint ett_rrc_T_tddOption_21 = -1;
static gint ett_rrc_T_tdd384_36 = -1;
static gint ett_rrc_T_tdd128_55 = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfo_r5 = -1;
static gint ett_rrc_T_fdd_123 = -1;
static gint ett_rrc_T_tdd_73 = -1;
static gint ett_rrc_T_ul_OL_PC_Signalling_02 = -1;
static gint ett_rrc_T_individuallySignalled_02 = -1;
static gint ett_rrc_T_tddOption_22 = -1;
static gint ett_rrc_T_tdd384_37 = -1;
static gint ett_rrc_T_tdd128_56 = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfo_r6 = -1;
static gint ett_rrc_T_fdd_124 = -1;
static gint ett_rrc_T_tdd_74 = -1;
static gint ett_rrc_T_ul_OL_PC_Signalling_03 = -1;
static gint ett_rrc_T_individuallySignalled_03 = -1;
static gint ett_rrc_T_tddOption_23 = -1;
static gint ett_rrc_T_tdd384_38 = -1;
static gint ett_rrc_T_tdd128_57 = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfo_r7 = -1;
static gint ett_rrc_T_fdd_125 = -1;
static gint ett_rrc_T_tdd_75 = -1;
static gint ett_rrc_T_ul_OL_PC_Signalling_04 = -1;
static gint ett_rrc_T_individuallySignalled_04 = -1;
static gint ett_rrc_T_tddOption_24 = -1;
static gint ett_rrc_T_tdd384_39 = -1;
static gint ett_rrc_T_tdd768_21 = -1;
static gint ett_rrc_T_tdd128_58 = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfo_r11 = -1;
static gint ett_rrc_T_fdd_126 = -1;
static gint ett_rrc_T_tdd_76 = -1;
static gint ett_rrc_T_ul_OL_PC_Signalling_05 = -1;
static gint ett_rrc_T_individuallySignalled_05 = -1;
static gint ett_rrc_T_tddOption_25 = -1;
static gint ett_rrc_T_tdd384_40 = -1;
static gint ett_rrc_T_tdd768_22 = -1;
static gint ett_rrc_T_tdd128_59 = -1;
static gint ett_rrc_UL_DPCHpowerControlInfoConcurrentTTI = -1;
static gint ett_rrc_UL_DPCHpowerControlInfoForCommonEDCH = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfoPostFDD = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfoPostTDD = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfoPostTDD_LCR_r4 = -1;
static gint ett_rrc_UL_DPCH_PowerControlInfoPredef = -1;
static gint ett_rrc_T_fdd_127 = -1;
static gint ett_rrc_T_tdd_77 = -1;
static gint ett_rrc_UL_EDCH_Information_ext = -1;
static gint ett_rrc_T_tdd_78 = -1;
static gint ett_rrc_UL_EDCH_Information_r6 = -1;
static gint ett_rrc_UL_EDCH_Information_r7 = -1;
static gint ett_rrc_T_modeSpecificInfo_89 = -1;
static gint ett_rrc_T_fdd_128 = -1;
static gint ett_rrc_T_tdd_79 = -1;
static gint ett_rrc_UL_EDCH_Information_r8 = -1;
static gint ett_rrc_T_modeSpecificInfo_90 = -1;
static gint ett_rrc_T_fdd_129 = -1;
static gint ett_rrc_T_tdd_80 = -1;
static gint ett_rrc_UL_EDCH_Information_r9 = -1;
static gint ett_rrc_T_modeSpecificInfo_91 = -1;
static gint ett_rrc_T_fdd_130 = -1;
static gint ett_rrc_T_tdd_81 = -1;
static gint ett_rrc_UL_EDCH_Information_r11 = -1;
static gint ett_rrc_T_modeSpecificInfo_92 = -1;
static gint ett_rrc_T_fdd_131 = -1;
static gint ett_rrc_T_tdd_82 = -1;
static gint ett_rrc_UL_MIMO_InfoFDD = -1;
static gint ett_rrc_T_configurationInfo_07 = -1;
static gint ett_rrc_T_newConfiguration_12 = -1;
static gint ett_rrc_UL_MulticarrierEDCH_InfolistItem_TDD128 = -1;
static gint ett_rrc_UL_MulticarrierEDCH_Infolist_TDD128 = -1;
static gint ett_rrc_UL_MulticarrierEDCH_Deletelist_TDD128 = -1;
static gint ett_rrc_UL_MulticarrierEDCHInfo_TDD128 = -1;
static gint ett_rrc_T_configuration_info = -1;
static gint ett_rrc_UL_MulticarrierEDCH_NewConfigurationInfo_TDD128 = -1;
static gint ett_rrc_UL_SynchronisationParameters_r4 = -1;
static gint ett_rrc_UL_TimingAdvanceControl = -1;
static gint ett_rrc_T_enabled = -1;
static gint ett_rrc_UL_TimingAdvanceControl_r4 = -1;
static gint ett_rrc_T_enabled_01 = -1;
static gint ett_rrc_T_tddOption_26 = -1;
static gint ett_rrc_T_tdd384_41 = -1;
static gint ett_rrc_T_tdd128_60 = -1;
static gint ett_rrc_UL_TimingAdvanceControl_r7 = -1;
static gint ett_rrc_T_enabled_02 = -1;
static gint ett_rrc_T_tddOption_27 = -1;
static gint ett_rrc_T_tdd384_42 = -1;
static gint ett_rrc_T_tdd768_23 = -1;
static gint ett_rrc_T_tdd128_61 = -1;
static gint ett_rrc_UL_TimingAdvanceControl_LCR_r4 = -1;
static gint ett_rrc_T_enabled_03 = -1;
static gint ett_rrc_UL_TS_ChannelisationCodeList = -1;
static gint ett_rrc_UL_TS_ChannelisationCodeList_r7 = -1;
static gint ett_rrc_UL_TS_ChannelisationCodeList_r7_item = -1;
static gint ett_rrc_UL_TS_ChannelisationCodeList_VHCR = -1;
static gint ett_rrc_UplinkAdditionalTimeslots = -1;
static gint ett_rrc_T_parameters_04 = -1;
static gint ett_rrc_T_sameAsLast_04 = -1;
static gint ett_rrc_T_newParameters_04 = -1;
static gint ett_rrc_UplinkAdditionalTimeslots_LCR_r4 = -1;
static gint ett_rrc_T_parameters_05 = -1;
static gint ett_rrc_T_sameAsLast_05 = -1;
static gint ett_rrc_T_newParameters_05 = -1;
static gint ett_rrc_UplinkAdditionalTimeslots_LCR_r7 = -1;
static gint ett_rrc_T_parameters_06 = -1;
static gint ett_rrc_T_sameAsLast_06 = -1;
static gint ett_rrc_T_newParameters_06 = -1;
static gint ett_rrc_UplinkAdditionalTimeslots_VHCR = -1;
static gint ett_rrc_T_parameters_07 = -1;
static gint ett_rrc_T_sameAsLast_07 = -1;
static gint ett_rrc_T_newParameters_07 = -1;
static gint ett_rrc_UplinkTimeslotsCodes = -1;
static gint ett_rrc_T_moreTimeslots_04 = -1;
static gint ett_rrc_T_additionalTimeslots_04 = -1;
static gint ett_rrc_T_consecutive_02 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_1_OF_UplinkAdditionalTimeslots = -1;
static gint ett_rrc_UplinkTimeslotsCodes_VHCR = -1;
static gint ett_rrc_T_moreTimeslots_05 = -1;
static gint ett_rrc_T_additionalTimeslots_05 = -1;
static gint ett_rrc_T_consecutive_03 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_1_OF_UplinkAdditionalTimeslots_VHCR = -1;
static gint ett_rrc_UplinkTimeslotsCodes_LCR_r4 = -1;
static gint ett_rrc_T_moreTimeslots_06 = -1;
static gint ett_rrc_T_additionalTimeslots_06 = -1;
static gint ett_rrc_T_consecutive_04 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_LCR_1_OF_UplinkAdditionalTimeslots_LCR_r4 = -1;
static gint ett_rrc_UplinkTimeslotsCodes_LCR_r7 = -1;
static gint ett_rrc_T_moreTimeslots_07 = -1;
static gint ett_rrc_T_additionalTimeslots_07 = -1;
static gint ett_rrc_T_consecutive_05 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxTS_LCR_1_OF_UplinkAdditionalTimeslots_LCR_r7 = -1;
static gint ett_rrc_AcquisitionSatInfo = -1;
static gint ett_rrc_AcquisitionSatInfo_va40ext = -1;
static gint ett_rrc_AcquisitionSatInfo_r10 = -1;
static gint ett_rrc_AcquisitionSatInfoList = -1;
static gint ett_rrc_AcquisitionSatInfoList_va40ext = -1;
static gint ett_rrc_AcquisitionSatInfoList_r10 = -1;
static gint ett_rrc_AdditionalMeasurementID_List = -1;
static gint ett_rrc_AdditionalMeasurementID_List_r9 = -1;
static gint ett_rrc_AlmanacSatInfo = -1;
static gint ett_rrc_AlmanacSatInfoList = -1;
static gint ett_rrc_ALM_ECEFsbasAlmanacSet = -1;
static gint ett_rrc_ALM_GlonassAlmanacSet = -1;
static gint ett_rrc_ALM_keplerianParameters = -1;
static gint ett_rrc_ALM_MidiAlmanacSet = -1;
static gint ett_rrc_ALM_NAVKeplerianSet = -1;
static gint ett_rrc_ALM_ReducedKeplerianSet = -1;
static gint ett_rrc_AuxInfoGANSS_ID1 = -1;
static gint ett_rrc_AuxInfoGANSS_ID1_element = -1;
static gint ett_rrc_AuxInfoGANSS_ID3 = -1;
static gint ett_rrc_AuxInfoGANSS_ID3_element = -1;
static gint ett_rrc_AzimuthAndElevation = -1;
static gint ett_rrc_AzimuthAndElevation_va40ext = -1;
static gint ett_rrc_AzimuthAndElevation_r10 = -1;
static gint ett_rrc_BadSatList = -1;
static gint ett_rrc_BLER_MeasurementResults = -1;
static gint ett_rrc_BLER_MeasurementResultsList = -1;
static gint ett_rrc_BLER_TransChIdList = -1;
static gint ett_rrc_BSICReported = -1;
static gint ett_rrc_BurstModeParameters = -1;
static gint ett_rrc_CellDCH_ReportCriteria = -1;
static gint ett_rrc_CellDCH_ReportCriteria_LCR_r4 = -1;
static gint ett_rrc_CellDCHMeasOccasionPattern_LCR = -1;
static gint ett_rrc_CellDCHMeasOccasionInfo_TDD128_r9 = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxMeasOccasionPattern_OF_CellDCHMeasOccasionPattern_LCR = -1;
static gint ett_rrc_CellInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_93 = -1;
static gint ett_rrc_T_fdd_132 = -1;
static gint ett_rrc_T_tdd_83 = -1;
static gint ett_rrc_CellInfo_r4 = -1;
static gint ett_rrc_T_modeSpecificInfo_94 = -1;
static gint ett_rrc_T_fdd_133 = -1;
static gint ett_rrc_T_tdd_84 = -1;
static gint ett_rrc_CellInfo_LCR_r8_ext = -1;
static gint ett_rrc_CellInfo_r9 = -1;
static gint ett_rrc_T_modeSpecificInfo_95 = -1;
static gint ett_rrc_T_fdd_134 = -1;
static gint ett_rrc_T_tdd_85 = -1;
static gint ett_rrc_CellInfoListToBeExcluded = -1;
static gint ett_rrc_CellInfoSI_RSCP = -1;
static gint ett_rrc_T_modeSpecificInfo_96 = -1;
static gint ett_rrc_T_fdd_135 = -1;
static gint ett_rrc_T_tdd_86 = -1;
static gint ett_rrc_CellInfoSI_RSCP_LCR_r4 = -1;
static gint ett_rrc_CellInfoSI_ECN0 = -1;
static gint ett_rrc_T_modeSpecificInfo_97 = -1;
static gint ett_rrc_T_fdd_136 = -1;
static gint ett_rrc_T_tdd_87 = -1;
static gint ett_rrc_CellInfoSI_ECN0_LCR_r4 = -1;
static gint ett_rrc_CellInfoSI_HCS_RSCP = -1;
static gint ett_rrc_T_modeSpecificInfo_98 = -1;
static gint ett_rrc_T_fdd_137 = -1;
static gint ett_rrc_T_tdd_88 = -1;
static gint ett_rrc_CellInfoSI_HCS_RSCP_LCR_r4 = -1;
static gint ett_rrc_CellInfoSI_HCS_ECN0 = -1;
static gint ett_rrc_T_modeSpecificInfo_99 = -1;
static gint ett_rrc_T_fdd_138 = -1;
static gint ett_rrc_T_tdd_89 = -1;
static gint ett_rrc_CellInfoSI_HCS_ECN0_LCR_r4 = -1;
static gint ett_rrc_CellMeasuredResults = -1;
static gint ett_rrc_T_modeSpecificInfo_100 = -1;
static gint ett_rrc_T_fdd_139 = -1;
static gint ett_rrc_T_tdd_90 = -1;
static gint ett_rrc_CellMeasuredResults_r9 = -1;
static gint ett_rrc_T_modeSpecificInfo_101 = -1;
static gint ett_rrc_T_fdd_140 = -1;
static gint ett_rrc_T_tdd_91 = -1;
static gint ett_rrc_CellMeasuredResults_v920ext = -1;
static gint ett_rrc_CellMeasurementEventResults = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxCellMeas_OF_PrimaryCPICH_Info = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxCellMeas_OF_PrimaryCCPCH_Info = -1;
static gint ett_rrc_CellMeasurementEventResultsOnSecUlFreq = -1;
static gint ett_rrc_SEQUENCE_SIZE_1_maxCellMeasOnSecULFreq_OF_PrimaryCPICH_Info = -1;
static gint ett_rrc_CellMeasurementEventResults_LCR_r4 = -1;
static gint ett_rrc_CellReportingQuantities = -1;
static gint ett_rrc_T_modeSpecificInfo_102 = -1;
static gint ett_rrc_T_fdd_141 = -1;
static gint ett_rrc_T_tdd_92 = -1;
static gint ett_rrc_CellSelectReselectInfoMC_RSCP = -1;
static gint ett_rrc_T_modeSpecificInfo_103 = -1;
static gint ett_rrc_T_fdd_142 = -1;
static gint ett_rrc_T_tdd_93 = -1;
static gint ett_rrc_T_gsm_03 = -1;
static gint ett_rrc_CellSelectReselectInfoSIB_11_12 = -1;
static gint ett_rrc_T_modeSpecificInfo_104 = -1;
static gint ett_rrc_T_fdd_143 = -1;
static gint ett_rrc_T_tdd_94 = -1;
static gint ett_rrc_T_gsm_04 = -1;
static gint ett_rrc_CellSelectReselectInfoSIB_11_12_RSCP = -1;
static gint ett_rrc_T_modeSpecificInfo_105 = -1;
static gint ett_rrc_T_fdd_144 = -1;
static gint ett_rrc_T_tdd_95 = -1;
static gint ett_rrc_T_gsm_05 = -1;
static gint ett_rrc_CellSelectReselectInfoSIB_11_12_ECN0 = -1;
static gint ett_rrc_T_modeSpecificInfo_106 = -1;
static gint ett_rrc_T_fdd_145 = -1;
static gint ett_rrc_T_tdd_96 = -1;
static gint ett_rrc_T_gsm_06 = -1;
static gint ett_rrc_CellSelectReselectInfoSIB_11_12_HCS_RSCP = -1;
static gint ett_rrc_T_modeSpecificInfo_107 = -1;
static gint ett_rrc_T_fdd_146 = -1;
static gint ett_rrc_T_tdd_97 = -1;
static gint ett_rrc_T_gsm_07 = -1;
static gint ett_rrc_CellSelectReselectInfoSIB_11_12_HCS_ECN0 = -1;
static gint ett_rrc_T_modeSpecificInfo_108 = -1;
static gint ett_rrc_T_fdd_147 = -1;
static gint ett_rrc_T_tdd_98 = -1;
static gint ett_rrc_T_gsm_08 = -1;
static gint ett_rrc_CellSelectReselectInfo_v590ext = -1;
static gint ett_rrc_CellSelectReselectInfoPCHFACH_v5b0ext = -1;
static gint ett_rrc_CellSelectReselectInfoTreselectionScaling_v5c0ext = -1;
static gint ett_rrc_CellsForInterFreqMeasList = -1;
static gint ett_rrc_CellsForInterRATMeasList = -1;
static gint ett_rrc_CellsForIntraFreqMeasList = -1;
static gint ett_rrc_CellsForIntraFreqMeasListOnSecULFreq = -1;
static gint ett_rrc_CellSynchronisationInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_109 = -1;
static gint ett_rrc_T_fdd_148 = -1;
static gint ett_rrc_T_tdd_99 = -1;
static gint ett_rrc_CellToReport = -1;
static gint ett_rrc_CellToReportList = -1;
static gint ett_rrc_CNAVclockModel = -1;
static gint ett_rrc_CountC_SFN_Frame_difference = -1;
static gint ett_rrc_CSGCellInfo = -1;
static gint ett_rrc_T_modeSpecificInfo_110 = -1;
static gint ett_rrc_T_fdd_149 = -1;
static gint ett_rrc_CSGCellInfoList = -1;
static gint ett_rrc_CSGInterFreqCellInfo = -1;
static gint ett_rrc_CSGInterFreqCellInfoList = -1;
static gint ett_rrc_CSGProximityDetection = -1;
static gint ett_rrc_CSGProximityIndication = -1;
static gint ett_rrc_T_radioAccessTechnology_02 = -1;
static gint ett_rrc_T_uTRA = -1;
static gint ett_rrc_T_e_UTRA = -1;
static gint ett_rrc_CSGProximityIndicati