/******************************************************************************
** $Id: opcua_serviceparser.c 53337 2013-11-15 06:32:11Z etxrab $
**
** Copyright (C) 2006-2009 ascolab GmbH. All Rights Reserved.
** Web: http://www.ascolab.com
** 
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
** 
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
** 
** Project: OpcUa Wireshark Plugin
**
** Description: OpcUa Complex Type Parser
**
** This file was autogenerated on 12.02.2013.
** DON'T MODIFY THIS FILE!
**
******************************************************************************/

#include "config.h"

#include <glib.h>
#include <epan/packet.h>
#include "opcua_complextypeparser.h"
#include "opcua_enumparser.h"
#include "opcua_simpletypes.h"
#include "opcua_hfindeces.h"
#include "opcua_serviceparser.h"

gint ett_opcua_FindServersRequest = -1;
void parseFindServersRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "FindServersRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_FindServersRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseString(subtree, tvb, pOffset, hf_opcua_EndpointUrl);
  /* Array length field ignored: NoOfLocaleIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LocaleIds, parseString);
  /* Array length field ignored: NoOfServerUris */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ServerUris, parseString);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_FindServersResponse = -1;
void parseFindServersResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "FindServersResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_FindServersResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfServers */
  parseArrayComplex(subtree, tvb, pOffset, "Servers", parseApplicationDescription);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_GetEndpointsRequest = -1;
void parseGetEndpointsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "GetEndpointsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_GetEndpointsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseString(subtree, tvb, pOffset, hf_opcua_EndpointUrl);
  /* Array length field ignored: NoOfLocaleIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LocaleIds, parseString);
  /* Array length field ignored: NoOfProfileUris */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ProfileUris, parseString);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_GetEndpointsResponse = -1;
void parseGetEndpointsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "GetEndpointsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_GetEndpointsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfEndpoints */
  parseArrayComplex(subtree, tvb, pOffset, "Endpoints", parseEndpointDescription);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_RegisterServerRequest = -1;
void parseRegisterServerRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "RegisterServerRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RegisterServerRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseRegisteredServer(subtree, tvb, pOffset, "Server");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_RegisterServerResponse = -1;
void parseRegisterServerResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "RegisterServerResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RegisterServerResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_OpenSecureChannelRequest = -1;
void parseOpenSecureChannelRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "OpenSecureChannelRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_OpenSecureChannelRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ClientProtocolVersion);
  parseSecurityTokenRequestType(subtree, tvb, pOffset);
  parseMessageSecurityMode(subtree, tvb, pOffset);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ClientNonce);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedLifetime);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_OpenSecureChannelResponse = -1;
void parseOpenSecureChannelResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "OpenSecureChannelResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_OpenSecureChannelResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ServerProtocolVersion);
  parseChannelSecurityToken(subtree, tvb, pOffset, "SecurityToken");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerNonce);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CloseSecureChannelRequest = -1;
void parseCloseSecureChannelRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CloseSecureChannelRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSecureChannelRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CloseSecureChannelResponse = -1;
void parseCloseSecureChannelResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CloseSecureChannelResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSecureChannelResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CreateSessionRequest = -1;
void parseCreateSessionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CreateSessionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSessionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseApplicationDescription(subtree, tvb, pOffset, "ClientDescription");
  parseString(subtree, tvb, pOffset, hf_opcua_ServerUri);
  parseString(subtree, tvb, pOffset, hf_opcua_EndpointUrl);
  parseString(subtree, tvb, pOffset, hf_opcua_SessionName);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ClientNonce);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ClientCertificate);
  parseDouble(subtree, tvb, pOffset, hf_opcua_RequestedSessionTimeout);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxResponseMessageSize);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CreateSessionResponse = -1;
void parseCreateSessionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CreateSessionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSessionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseNodeId(subtree, tvb, pOffset, "SessionId");
  parseNodeId(subtree, tvb, pOffset, "AuthenticationToken");
  parseDouble(subtree, tvb, pOffset, hf_opcua_RevisedSessionTimeout);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerNonce);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerCertificate);
  /* Array length field ignored: NoOfServerEndpoints */
  parseArrayComplex(subtree, tvb, pOffset, "ServerEndpoints", parseEndpointDescription);
  /* Array length field ignored: NoOfServerSoftwareCertificates */
  parseArrayComplex(subtree, tvb, pOffset, "ServerSoftwareCertificates", parseSignedSoftwareCertificate);
  parseSignatureData(subtree, tvb, pOffset, "ServerSignature");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxRequestMessageSize);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ActivateSessionRequest = -1;
void parseActivateSessionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ActivateSessionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ActivateSessionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseSignatureData(subtree, tvb, pOffset, "ClientSignature");
  /* Array length field ignored: NoOfClientSoftwareCertificates */
  parseArrayComplex(subtree, tvb, pOffset, "ClientSoftwareCertificates", parseSignedSoftwareCertificate);
  /* Array length field ignored: NoOfLocaleIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LocaleIds, parseString);
  parseExtensionObject(subtree, tvb, pOffset, "UserIdentityToken");
  parseSignatureData(subtree, tvb, pOffset, "UserTokenSignature");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ActivateSessionResponse = -1;
void parseActivateSessionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ActivateSessionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ActivateSessionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerNonce);
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CloseSessionRequest = -1;
void parseCloseSessionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CloseSessionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSessionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_DeleteSubscriptions);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CloseSessionResponse = -1;
void parseCloseSessionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CloseSessionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSessionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CancelRequest = -1;
void parseCancelRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CancelRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CancelRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestHandle);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CancelResponse = -1;
void parseCancelResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CancelResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CancelResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CancelCount);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_AddNodesRequest = -1;
void parseAddNodesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "AddNodesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddNodesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToAdd */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToAdd", parseAddNodesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_AddNodesResponse = -1;
void parseAddNodesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "AddNodesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddNodesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseAddNodesResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_AddReferencesRequest = -1;
void parseAddReferencesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "AddReferencesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddReferencesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfReferencesToAdd */
  parseArrayComplex(subtree, tvb, pOffset, "ReferencesToAdd", parseAddReferencesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_AddReferencesResponse = -1;
void parseAddReferencesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "AddReferencesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddReferencesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteNodesRequest = -1;
void parseDeleteNodesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteNodesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteNodesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToDelete */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToDelete", parseDeleteNodesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteNodesResponse = -1;
void parseDeleteNodesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteNodesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteNodesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteReferencesRequest = -1;
void parseDeleteReferencesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteReferencesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteReferencesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfReferencesToDelete */
  parseArrayComplex(subtree, tvb, pOffset, "ReferencesToDelete", parseDeleteReferencesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteReferencesResponse = -1;
void parseDeleteReferencesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteReferencesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteReferencesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_BrowseRequest = -1;
void parseBrowseRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "BrowseRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseViewDescription(subtree, tvb, pOffset, "View");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedMaxReferencesPerNode);
  /* Array length field ignored: NoOfNodesToBrowse */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToBrowse", parseBrowseDescription);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_BrowseResponse = -1;
void parseBrowseResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "BrowseResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseBrowseResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_BrowseNextRequest = -1;
void parseBrowseNextRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "BrowseNextRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseNextRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ReleaseContinuationPoints);
  /* Array length field ignored: NoOfContinuationPoints */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ContinuationPoints, parseByteString);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_BrowseNextResponse = -1;
void parseBrowseNextResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "BrowseNextResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseNextResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseBrowseResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TranslateBrowsePathsToNodeIdsRequest = -1;
void parseTranslateBrowsePathsToNodeIdsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TranslateBrowsePathsToNodeIdsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TranslateBrowsePathsToNodeIdsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfBrowsePaths */
  parseArrayComplex(subtree, tvb, pOffset, "BrowsePaths", parseBrowsePath);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TranslateBrowsePathsToNodeIdsResponse = -1;
void parseTranslateBrowsePathsToNodeIdsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TranslateBrowsePathsToNodeIdsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TranslateBrowsePathsToNodeIdsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseBrowsePathResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_RegisterNodesRequest = -1;
void parseRegisterNodesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "RegisterNodesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RegisterNodesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToRegister */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToRegister", parseNodeId);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_RegisterNodesResponse = -1;
void parseRegisterNodesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "RegisterNodesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RegisterNodesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfRegisteredNodeIds */
  parseArrayComplex(subtree, tvb, pOffset, "RegisteredNodeIds", parseNodeId);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_UnregisterNodesRequest = -1;
void parseUnregisterNodesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "UnregisterNodesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_UnregisterNodesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToUnregister */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToUnregister", parseNodeId);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_UnregisterNodesResponse = -1;
void parseUnregisterNodesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "UnregisterNodesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_UnregisterNodesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_QueryFirstRequest = -1;
void parseQueryFirstRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "QueryFirstRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryFirstRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseViewDescription(subtree, tvb, pOffset, "View");
  /* Array length field ignored: NoOfNodeTypes */
  parseArrayComplex(subtree, tvb, pOffset, "NodeTypes", parseNodeTypeDescription);
  parseContentFilter(subtree, tvb, pOffset, "Filter");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxDataSetsToReturn);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxReferencesToReturn);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_QueryFirstResponse = -1;
void parseQueryFirstResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "QueryFirstResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryFirstResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfQueryDataSets */
  parseArrayComplex(subtree, tvb, pOffset, "QueryDataSets", parseQueryDataSet);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
  /* Array length field ignored: NoOfParsingResults */
  parseArrayComplex(subtree, tvb, pOffset, "ParsingResults", parseParsingResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  parseContentFilterResult(subtree, tvb, pOffset, "FilterResult");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_QueryNextRequest = -1;
void parseQueryNextRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "QueryNextRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryNextRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ReleaseContinuationPoint);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_QueryNextResponse = -1;
void parseQueryNextResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "QueryNextResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryNextResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfQueryDataSets */
  parseArrayComplex(subtree, tvb, pOffset, "QueryDataSets", parseQueryDataSet);
  parseByteString(subtree, tvb, pOffset, hf_opcua_RevisedContinuationPoint);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ReadRequest = -1;
void parseReadRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ReadRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseDouble(subtree, tvb, pOffset, hf_opcua_MaxAge);
  parseTimestampsToReturn(subtree, tvb, pOffset);
  /* Array length field ignored: NoOfNodesToRead */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToRead", parseReadValueId);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ReadResponse = -1;
void parseReadResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ReadResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseDataValue);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_HistoryReadRequest = -1;
void parseHistoryReadRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "HistoryReadRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryReadRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseExtensionObject(subtree, tvb, pOffset, "HistoryReadDetails");
  parseTimestampsToReturn(subtree, tvb, pOffset);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ReleaseContinuationPoints);
  /* Array length field ignored: NoOfNodesToRead */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToRead", parseHistoryReadValueId);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_HistoryReadResponse = -1;
void parseHistoryReadResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "HistoryReadResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryReadResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseHistoryReadResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_WriteRequest = -1;
void parseWriteRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "WriteRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_WriteRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToWrite */
  parseArrayComplex(subtree, tvb, pOffset, "NodesToWrite", parseWriteValue);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_WriteResponse = -1;
void parseWriteResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "WriteResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_WriteResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_HistoryUpdateRequest = -1;
void parseHistoryUpdateRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "HistoryUpdateRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryUpdateRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfHistoryUpdateDetails */
  parseArrayComplex(subtree, tvb, pOffset, "HistoryUpdateDetails", parseExtensionObject);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_HistoryUpdateResponse = -1;
void parseHistoryUpdateResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "HistoryUpdateResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryUpdateResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseHistoryUpdateResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CallRequest = -1;
void parseCallRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CallRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CallRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfMethodsToCall */
  parseArrayComplex(subtree, tvb, pOffset, "MethodsToCall", parseCallMethodRequest);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CallResponse = -1;
void parseCallResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CallResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CallResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseCallMethodResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CreateMonitoredItemsRequest = -1;
void parseCreateMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CreateMonitoredItemsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateMonitoredItemsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseTimestampsToReturn(subtree, tvb, pOffset);
  /* Array length field ignored: NoOfItemsToCreate */
  parseArrayComplex(subtree, tvb, pOffset, "ItemsToCreate", parseMonitoredItemCreateRequest);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CreateMonitoredItemsResponse = -1;
void parseCreateMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CreateMonitoredItemsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateMonitoredItemsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseMonitoredItemCreateResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ModifyMonitoredItemsRequest = -1;
void parseModifyMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ModifyMonitoredItemsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifyMonitoredItemsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseTimestampsToReturn(subtree, tvb, pOffset);
  /* Array length field ignored: NoOfItemsToModify */
  parseArrayComplex(subtree, tvb, pOffset, "ItemsToModify", parseMonitoredItemModifyRequest);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ModifyMonitoredItemsResponse = -1;
void parseModifyMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ModifyMonitoredItemsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifyMonitoredItemsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseMonitoredItemModifyResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_SetMonitoringModeRequest = -1;
void parseSetMonitoringModeRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "SetMonitoringModeRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetMonitoringModeRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseMonitoringMode(subtree, tvb, pOffset);
  /* Array length field ignored: NoOfMonitoredItemIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_MonitoredItemIds, parseUInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_SetMonitoringModeResponse = -1;
void parseSetMonitoringModeResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "SetMonitoringModeResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetMonitoringModeResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_SetTriggeringRequest = -1;
void parseSetTriggeringRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "SetTriggeringRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetTriggeringRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TriggeringItemId);
  /* Array length field ignored: NoOfLinksToAdd */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LinksToAdd, parseUInt32);
  /* Array length field ignored: NoOfLinksToRemove */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LinksToRemove, parseUInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_SetTriggeringResponse = -1;
void parseSetTriggeringResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "SetTriggeringResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetTriggeringResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfAddResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_AddResults, parseStatusCode);
  /* Array length field ignored: NoOfAddDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "AddDiagnosticInfos", parseDiagnosticInfo);
  /* Array length field ignored: NoOfRemoveResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_RemoveResults, parseStatusCode);
  /* Array length field ignored: NoOfRemoveDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "RemoveDiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteMonitoredItemsRequest = -1;
void parseDeleteMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteMonitoredItemsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteMonitoredItemsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  /* Array length field ignored: NoOfMonitoredItemIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_MonitoredItemIds, parseUInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteMonitoredItemsResponse = -1;
void parseDeleteMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteMonitoredItemsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteMonitoredItemsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CreateSubscriptionRequest = -1;
void parseCreateSubscriptionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CreateSubscriptionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSubscriptionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseDouble(subtree, tvb, pOffset, hf_opcua_RequestedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedLifetimeCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedMaxKeepAliveCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxNotificationsPerPublish);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_PublishingEnabled);
  parseByte(subtree, tvb, pOffset, hf_opcua_Priority);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_CreateSubscriptionResponse = -1;
void parseCreateSubscriptionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "CreateSubscriptionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSubscriptionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseDouble(subtree, tvb, pOffset, hf_opcua_RevisedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedLifetimeCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedMaxKeepAliveCount);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ModifySubscriptionRequest = -1;
void parseModifySubscriptionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ModifySubscriptionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifySubscriptionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseDouble(subtree, tvb, pOffset, hf_opcua_RequestedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedLifetimeCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedMaxKeepAliveCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxNotificationsPerPublish);
  parseByte(subtree, tvb, pOffset, hf_opcua_Priority);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_ModifySubscriptionResponse = -1;
void parseModifySubscriptionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "ModifySubscriptionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifySubscriptionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseDouble(subtree, tvb, pOffset, hf_opcua_RevisedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedLifetimeCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedMaxKeepAliveCount);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_SetPublishingModeRequest = -1;
void parseSetPublishingModeRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "SetPublishingModeRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetPublishingModeRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_PublishingEnabled);
  /* Array length field ignored: NoOfSubscriptionIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SubscriptionIds, parseUInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_SetPublishingModeResponse = -1;
void parseSetPublishingModeResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "SetPublishingModeResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetPublishingModeResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_PublishRequest = -1;
void parsePublishRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "PublishRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_PublishRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfSubscriptionAcknowledgements */
  parseArrayComplex(subtree, tvb, pOffset, "SubscriptionAcknowledgements", parseSubscriptionAcknowledgement);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_PublishResponse = -1;
void parsePublishResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "PublishResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_PublishResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  /* Array length field ignored: NoOfAvailableSequenceNumbers */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_AvailableSequenceNumbers, parseUInt32);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_MoreNotifications);
  parseNotificationMessage(subtree, tvb, pOffset, "NotificationMessage");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_RepublishRequest = -1;
void parseRepublishRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "RepublishRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RepublishRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RetransmitSequenceNumber);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_RepublishResponse = -1;
void parseRepublishResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "RepublishResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RepublishResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseNotificationMessage(subtree, tvb, pOffset, "NotificationMessage");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TransferSubscriptionsRequest = -1;
void parseTransferSubscriptionsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TransferSubscriptionsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TransferSubscriptionsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfSubscriptionIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SubscriptionIds, parseUInt32);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_SendInitialValues);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TransferSubscriptionsResponse = -1;
void parseTransferSubscriptionsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TransferSubscriptionsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TransferSubscriptionsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseTransferResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteSubscriptionsRequest = -1;
void parseDeleteSubscriptionsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteSubscriptionsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteSubscriptionsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfSubscriptionIds */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SubscriptionIds, parseUInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_DeleteSubscriptionsResponse = -1;
void parseDeleteSubscriptionsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "DeleteSubscriptionsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteSubscriptionsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TestStackRequest = -1;
void parseTestStackRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TestStackRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TestId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_Iteration);
  parseVariant(subtree, tvb, pOffset, "Input");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TestStackResponse = -1;
void parseTestStackResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TestStackResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseVariant(subtree, tvb, pOffset, "Output");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TestStackExRequest = -1;
void parseTestStackExRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TestStackExRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackExRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TestId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_Iteration);
  parseCompositeTestType(subtree, tvb, pOffset, "Input");
  proto_item_set_end(ti, tvb, *pOffset);
}
gint ett_opcua_TestStackExResponse = -1;
void parseTestStackExResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, *pOffset, -1, "TestStackExResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackExResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseCompositeTestType(subtree, tvb, pOffset, "Output");
  proto_item_set_end(ti, tvb, *pOffset);
}

/** Setup protocol subtree array */
static gint *ett[] =
{
  &ett_opcua_FindServersRequest,
  &ett_opcua_FindServersResponse,
  &ett_opcua_GetEndpointsRequest,
  &ett_opcua_GetEndpointsResponse,
  &ett_opcua_RegisterServerRequest,
  &ett_opcua_RegisterServerResponse,
  &ett_opcua_OpenSecureChannelRequest,
  &ett_opcua_OpenSecureChannelResponse,
  &ett_opcua_CloseSecureChannelRequest,
  &ett_opcua_CloseSecureChannelResponse,
  &ett_opcua_CreateSessionRequest,
  &ett_opcua_CreateSessionResponse,
  &ett_opcua_ActivateSessionRequest,
  &ett_opcua_ActivateSessionResponse,
  &ett_opcua_CloseSessionRequest,
  &ett_opcua_CloseSessionResponse,
  &ett_opcua_CancelRequest,
  &ett_opcua_CancelResponse,
  &ett_opcua_AddNodesRequest,
  &ett_opcua_AddNodesResponse,
  &ett_opcua_AddReferencesRequest,
  &ett_opcua_AddReferencesResponse,
  &ett_opcua_DeleteNodesRequest,
  &ett_opcua_DeleteNodesResponse,
  &ett_opcua_DeleteReferencesRequest,
  &ett_opcua_DeleteReferencesResponse,
  &ett_opcua_BrowseRequest,
  &ett_opcua_BrowseResponse,
  &ett_opcua_BrowseNextRequest,
  &ett_opcua_BrowseNextResponse,
  &ett_opcua_TranslateBrowsePathsToNodeIdsRequest,
  &ett_opcua_TranslateBrowsePathsToNodeIdsResponse,
  &ett_opcua_RegisterNodesRequest,
  &ett_opcua_RegisterNodesResponse,
  &ett_opcua_UnregisterNodesRequest,
  &ett_opcua_UnregisterNodesResponse,
  &ett_opcua_QueryFirstRequest,
  &ett_opcua_QueryFirstResponse,
  &ett_opcua_QueryNextRequest,
  &ett_opcua_QueryNextResponse,
  &ett_opcua_ReadRequest,
  &ett_opcua_ReadResponse,
  &ett_opcua_HistoryReadRequest,
  &ett_opcua_HistoryReadResponse,
  &ett_opcua_WriteRequest,
  &ett_opcua_WriteResponse,
  &ett_opcua_HistoryUpdateRequest,
  &ett_opcua_HistoryUpdateResponse,
  &ett_opcua_CallRequest,
  &ett_opcua_CallResponse,
  &ett_opcua_CreateMonitoredItemsRequest,
  &ett_opcua_CreateMonitoredItemsResponse,
  &ett_opcua_ModifyMonitoredItemsRequest,
  &ett_opcua_ModifyMonitoredItemsResponse,
  &ett_opcua_SetMonitoringModeRequest,
  &ett_opcua_SetMonitoringModeResponse,
  &ett_opcua_SetTriggeringRequest,
  &ett_opcua_SetTriggeringResponse,
  &ett_opcua_DeleteMonitoredItemsRequest,
  &ett_opcua_DeleteMonitoredItemsResponse,
  &ett_opcua_CreateSubscriptionRequest,
  &ett_opcua_CreateSubscriptionResponse,
  &ett_opcua_ModifySubscriptionRequest,
  &ett_opcua_ModifySubscriptionResponse,
  &ett_opcua_SetPublishingModeRequest,
  &ett_opcua_SetPublishingModeResponse,
  &ett_opcua_PublishRequest,
  &ett_opcua_PublishResponse,
  &ett_opcua_RepublishRequest,
  &ett_opcua_RepublishResponse,
  &ett_opcua_TransferSubscriptionsRequest,
  &ett_opcua_TransferSubscriptionsResponse,
  &ett_opcua_DeleteSubscriptionsRequest,
  &ett_opcua_DeleteSubscriptionsResponse,
  &ett_opcua_TestStackRequest,
  &ett_opcua_TestStackResponse,
  &ett_opcua_TestStackExRequest,
  &ett_opcua_TestStackExResponse,
};

void registerServiceTypes(void)
{
  proto_register_subtree_array(ett, array_length(ett));
}

