/*
 *  crc6.c
 *
 * $Id: crc6.c 50062 2013-06-19 22:28:58Z morriss $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "config.h"

#include <glib.h>
#include "crc6.h"

static const unsigned char crc6_table[] =
{
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,
    0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,
    0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,
    0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,
    0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,
    0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,
    0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,
    0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,
    0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,
    0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,
    0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,
    0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,
    0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,
    0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,
    0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,
    0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,
    0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,
    0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,
    0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,
    0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,
    0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,
    0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,
    0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,
    0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,
    0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,
    0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,
    0x3b,0x3a,0x39,0x38,0x3f,0x3e,0x3d,0x3c,0x33,0x32,0x31,0x30,0x37,0x36,0x35,0x34,
    0x2b,0x2a,0x29,0x28,0x2f,0x2e,0x2d,0x2c,0x23,0x22,0x21,0x20,0x27,0x26,0x25,0x24,
    0x1b,0x1a,0x19,0x18,0x1f,0x1e,0x1d,0x1c,0x13,0x12,0x11,0x10,0x17,0x16,0x15,0x14,
    0x0b,0x0a,0x09,0x08,0x0f,0x0e,0x0d,0x0c,0x03,0x02,0x01,0x00,0x07,0x06,0x05,0x04,
    0x14,0x15,0x16,0x17,0x10,0x11,0x12,0x13,0x1c,0x1d,0x1e,0x1f,0x18,0x19,0x1a,0x1b,
    0x04,0x05,0x06,0x07,0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,0x08,0x09,0x0a,0x0b,
    0x34,0x35,0x36,0x37,0x30,0x31,0x32,0x33,0x3c,0x3d,0x3e,0x3f,0x38,0x39,0x3a,0x3b,
    0x24,0x25,0x26,0x27,0x20,0x21,0x22,0x23,0x2c,0x2d,0x2e,0x2f,0x28,0x29,0x2a,0x2b,
    0x0a,0x0b,0x08,0x09,0x0e,0x0f,0x0c,0x0d,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
    0x1a,0x1b,0x18,0x19,0x1e,0x1f,0x1c,0x1d,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
    0x2a,0x2b,0x28,0x29,0x2e,0x2f,0x2c,0x2d,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
    0x3a,0x3b,0x38,0x39,0x3e,0x3f,0x3c,0x3d,0x32,0x33,0x30,0x31,0x36,0x37,0x34,0x35,
    0x25,0x24,0x27,0x26,0x21,0x20,0x23,0x22,0x2d,0x2c,0x2f,0x2e,0x29,0x28,0x2b,0x2a,
    0x35,0x34,0x37,0x36,0x31,0x30,0x33,0x32,0x3d,0x3c,0x3f,0x3e,0x39,0x38,0x3b,0x3a,
    0x05,0x04,0x07,0x06,0x01,0x00,0x03,0x02,0x0d,0x0c,0x0f,0x0e,0x09,0x08,0x0b,0x0a,
    0x15,0x14,0x17,0x16,0x11,0x10,0x13,0x12,0x1d,0x1c,0x1f,0x1e,0x19,0x18,0x1b,0x1a,
    0x36,0x37,0x34,0x35,0x32,0x33,0x30,0x31,0x3e,0x3f,0x3c,0x3d,0x3a,0x3b,0x38,0x39,
    0x26,0x27,0x24,0x25,0x22,0x23,0x20,0x21,0x2e,0x2f,0x2c,0x2d,0x2a,0x2b,0x28,0x29,
    0x16,0x17,0x14,0x15,0x12,0x13,0x10,0x11,0x1e,0x1f,0x1c,0x1d,0x1a,0x1b,0x18,0x19,
    0x06,0x07,0x04,0x05,0x02,0x03,0x00,0x01,0x0e,0x0f,0x0c,0x0d,0x0a,0x0b,0x08,0x09,
    0x19,0x18,0x1b,0x1a,0x1d,0x1c,0x1f,0x1e,0x11,0x10,0x13,0x12,0x15,0x14,0x17,0x16,
    0x09,0x08,0x0b,0x0a,0x0d,0x0c,0x0f,0x0e,0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,
    0x39,0x38,0x3b,0x3a,0x3d,0x3c,0x3f,0x3e,0x31,0x30,0x33,0x32,0x35,0x34,0x37,0x36,
    0x29,0x28,0x2b,0x2a,0x2d,0x2c,0x2f,0x2e,0x21,0x20,0x23,0x22,0x25,0x24,0x27,0x26,
    0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0f,0x0e,0x0d,0x0c,0x0b,0x0a,0x09,0x08,
    0x17,0x16,0x15,0x14,0x13,0x12,0x11,0x10,0x1f,0x1e,0x1d,0x1c,0x1b,0x1a,0x19,0x18,
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,0x2f,0x2e,0x2d,0x2c,0x2b,0x2a,0x29,0x28,
    0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39,0x38,
    0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
    0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
    0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
    0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
};


guint16 update_crc6_by_bytes(guint16 crc6, guint8 byte1, guint8 byte2) {
    int bit;
    guint32 remainder = ( byte1<<8 | byte2 ) << 6;
    guint32 polynomial = 0x6F << 15;

    for (bit = 15;
		 bit >= 0;
		 --bit)
    {
        if (remainder & (0x40 << bit))
        {
            remainder ^= polynomial;
        }
        polynomial >>= 1;
    }

    return (guint16)(remainder ^ crc6);
}

guint16 crc6_compute(const guint8 *data_blk_ptr, int data_blk_size)
{
    guint16 h;
    int byteIndex;

    h = 0;
    byteIndex = 0;

    if(data_blk_size == 0)
    {
        return 0;
    }

    do
    {
        h = (h << 8) | data_blk_ptr[byteIndex];

        h = crc6_table[h];
        byteIndex++;
    }
    while(byteIndex < data_blk_size);

    return h;
}
