/* Do not modify this file.                                                   */
/* It is created automatically by the ASN.1 to Wireshark dissector compiler   */
/* packet-rnsap.c                                                             */
/* ../../tools/asn2wrs.py -p rnsap -c ./rnsap.cnf -s ./packet-rnsap-template -D . RNSAP-CommonDataTypes.asn RNSAP-Constants.asn RNSAP-Containers.asn RNSAP-IEs.asn RNSAP-PDU-Contents.asn RNSAP-PDU-Descriptions.asn */

/* Input file: packet-rnsap-template.c */

#line 1 "packet-rnsap-template.c"
/* packet-rnsap.c
 * Routines for dissecting Universal Mobile Telecommunications System (UMTS);
 * UTRAN Iur interface Radio Network Subsystem
 * Application Part (RNSAP) signalling
 * (3GPP TS 25.423 version 6.7.0 Release 6) packet dissection
 * Copyright 2005 - 2006, Anders Broman <anders.broman@ericsson.com>
 *
 * $Id: packet-rnsap.c 28405 2009-05-18 23:55:55Z gerald $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ref: 3GPP TS 25.423 version 6.7.0 Release 6
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include <epan/conversation.h>

#include <stdio.h>
#include <string.h>

#include <epan/asn1.h>

#include "packet-per.h"

#ifdef _MSC_VER
/* disable: "warning C4146: unary minus operator applied to unsigned type, result still unsigned" */
#pragma warning(disable:4146)
#endif

#define PNAME  "UTRAN Iur interface Radio Network Subsystem Application Part"
#define PSNAME "RNSAP"
#define PFNAME "rnsap"

#define SCCP_SSN_RNSAP 143


/*--- Included file: packet-rnsap-val.h ---*/
#line 1 "packet-rnsap-val.h"
#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxCellSIB11OrSIB12            32
#define maxCellsMeas                   8
#define maxRateMatching                256
#define maxNoOfDSCHs                   10
#define maxNoOfDSCHsLCR                10
#define maxNoOfRB                      32
#define maxNoOfUSCHs                   10
#define maxNoOfUSCHsLCR                10
#define maxNrOfTFCs                    1024
#define maxNrOfTFs                     32
#define maxNrOfCCTrCHs                 16
#define maxNrOfCCTrCHsLCR              16
#define maxNrOfDCHs                    128
#define maxNrOfDL_Codes                8
#define maxNrOfDPCHs                   240
#define maxNrOfDPCHsPerRL_1            239
#define maxNrOfDPCHsLCR                240
#define maxNrOfDPCHsLCRPerRL_1         95
#define maxNrOfDPCHs768                480
#define maxNrOfDPCHs768PerRL_1         479
#define maxNrOfErrors                  256
#define maxNrOfMACcshSDU_Length        16
#define maxNrOfMBMSServices            128
#define maxNrOfActiveMBMSServices      256
#define maxNrOfPoints                  15
#define maxNrOfRLs                     16
#define maxNrOfRLSets                  maxNrOfRLs
#define maxNrOfRLSets_1                15
#define maxNrOfRLs_1                   15
#define maxNrOfRLs_2                   14
#define maxNrOfUEs                     4096
#define maxNrOfULTs                    15
#define maxNrOfULTsLCR                 6
#define maxNrOfDLTs                    15
#define maxNrOfDLTsLCR                 6
#define maxRNCinURA_1                  15
#define maxTTI_Count                   4
#define maxCTFC                        16777215
#define maxNrOfNeighbouringRNCs        10
#define maxNrOfFDDNeighboursPerRNC     256
#define maxNrOfGSMNeighboursPerRNC     256
#define maxNrOfTDDNeighboursPerRNC     256
#define maxNrOfFACHs                   8
#define maxNrOfLCRTDDNeighboursPerRNC  256
#define maxIBSEG                       16
#define maxNrOfSCCPCHs                 8
#define maxNrOfSCCPCHs768              16
#define maxTGPS                        6
#define maxNrOfTS                      15
#define maxNrOfLevels                  256
#define maxNrOfTsLCR                   6
#define maxNoSat                       16
#define maxNoGPSTypes                  8
#define maxNrOfMeasNCell               96
#define maxNrOfMeasNCell_1             95
#define maxResetContext                250
#define maxResetContextGroup           32
#define maxNrOfHARQProc                8
#define maxNrOfHSSCCHCodes             4
#define maxNrOfHSSICHs                 4
#define maxNrOfHSSICHs_1               3
#define maxNrOfMACdFlows               8
#define maxNrOfMACdFlows_1             7
#define maxNrOfMACdPDUSize             32
#define maxNrOfPDUIndexes              8
#define maxNrOfPDUIndexes_1            7
#define maxNrOfPrioQueues              8
#define maxNrOfPrioQueues_1            7
#define maxNrOfSNAs                    65536
#define maxNrOfSatAlmanac_maxNoSat     16
#define maxNrOfGERANSI                 8
#define maxNrOfInterfaces              16
#define maxNrofSigSeqERGHICH_1         39
#define maxNrOfCells                   65536
#define maxNrOfAddFreq                 8
#define maxNrOfCellsPerFreq            65536
#define maxNrOfEDCHMACdFlows_1         7
#define maxNrOfEDCH_HARQ_PO_QUANTSTEPs 6
#define maxNrOfEDPCCH_PO_QUANTSTEPs    8
#define maxNrOfEDCHHARQProcesses2msEDCH 8
#define maxNrOfBits_MACe_PDU_non_scheduled 19982
#define maxNrOfRefETFCIs               8
#define maxNrOfRefETFCI_PO_QUANTSTEPs  29
#define maxNrOfEDCHMACdFlows           8
#define maxNoOfLogicalChannels         16
#define maxNrOfRefBetas                8
#define maxNrOfEAGCHCodes              4
#define maxNrOfHS_DSCHTBSs             90
#define maxNrOfHS_DSCHTBSs_HS_SCCHless 4
#define maxHS_PDSCHCodeNrComp_1        15
#define maxNrOfEHICHCodes              4
#define maxGANSSSat                    32
#define maxNoGANSS                     8
#define maxSgnType                     4

/* enumerated values for ProcedureCode */
#define RNSAP_ID_COMMONTRANSPORTCHANNELRESOURCESINITIALISATION   0
#define RNSAP_ID_COMMONTRANSPORTCHANNELRESOURCESRELEASE   1
#define RNSAP_ID_COMPRESSEDMODECOMMAND   2
#define RNSAP_ID_DOWNLINKPOWERCONTROL   3
#define RNSAP_ID_DOWNLINKPOWERTIMESLOTCONTROL   4
#define RNSAP_ID_DOWNLINKSIGNALLINGTRANSFER   5
#define RNSAP_ID_ERRORINDICATION   6
#define RNSAP_ID_DEDICATEDMEASUREMENTFAILURE   7
#define RNSAP_ID_DEDICATEDMEASUREMENTINITIATION   8
#define RNSAP_ID_DEDICATEDMEASUREMENTREPORTING   9
#define RNSAP_ID_DEDICATEDMEASUREMENTTERMINATION  10
#define RNSAP_ID_PAGING  11
#define RNSAP_ID_PHYSICALCHANNELRECONFIGURATION  12
#define RNSAP_ID_PRIVATEMESSAGE  13
#define RNSAP_ID_RADIOLINKADDITION  14
#define RNSAP_ID_RADIOLINKCONGESTION  34
#define RNSAP_ID_RADIOLINKDELETION  15
#define RNSAP_ID_RADIOLINKFAILURE  16
#define RNSAP_ID_RADIOLINKPREEMPTION  17
#define RNSAP_ID_RADIOLINKRESTORATION  18
#define RNSAP_ID_RADIOLINKSETUP  19
#define RNSAP_ID_RELOCATIONCOMMIT  20
#define RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCANCELLATION  21
#define RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCOMMIT  22
#define RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION  23
#define RNSAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION  24
#define RNSAP_ID_UPLINKSIGNALLINGTRANSFER  25
#define RNSAP_ID_COMMONMEASUREMENTFAILURE  26
#define RNSAP_ID_COMMONMEASUREMENTINITIATION  27
#define RNSAP_ID_COMMONMEASUREMENTREPORTING  28
#define RNSAP_ID_COMMONMEASUREMENTTERMINATION  29
#define RNSAP_ID_INFORMATIONEXCHANGEFAILURE  30
#define RNSAP_ID_INFORMATIONEXCHANGEINITIATION  31
#define RNSAP_ID_INFORMATIONREPORTING  32
#define RNSAP_ID_INFORMATIONEXCHANGETERMINATION  33
#define RNSAP_ID_RESET  35
#define RNSAP_ID_RADIOLINKACTIVATION  36
#define RNSAP_ID_GERANUPLINKSIGNALLINGTRANSFER  37
#define RNSAP_ID_RADIOLINKPARAMETERUPDATE  38
#define RNSAP_ID_UEMEASUREMENTFAILURE  39
#define RNSAP_ID_UEMEASUREMENTINITIATION  40
#define RNSAP_ID_UEMEASUREMENTREPORTING  41
#define RNSAP_ID_UEMEASUREMENTTERMINATION  42
#define RNSAP_ID_IURDEACTIVATETRACE  43
#define RNSAP_ID_IURINVOKETRACE  44
#define RNSAP_ID_MBMSATTACH  45
#define RNSAP_ID_MBMSDETACH  46
#define RNSAP_ID_DIRECTINFORMATIONTRANSFER  48

typedef enum _DdMode_enum {
  tdd          =   0,
  fdd          =   1,
  common       =   2
} DdMode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_AllowedQueuingTime =   4,
  id_Allowed_Rate_Information =  42,
  id_AntennaColocationIndicator = 309,
  id_BindingID =   5,
  id_C_ID      =   6,
  id_C_RNTI    =   7,
  id_Cell_Capacity_Class_Value = 303,
  id_CFN       =   8,
  id_CN_CS_DomainIdentifier =   9,
  id_CN_PS_DomainIdentifier =  10,
  id_Cause     =  11,
  id_CoverageIndicator = 310,
  id_CriticalityDiagnostics =  20,
  id_ContextInfoItem_Reset = 211,
  id_ContextGroupInfoItem_Reset = 515,
  id_D_RNTI    =  21,
  id_D_RNTI_ReleaseIndication =  22,
  id_DCHs_to_Add_FDD =  26,
  id_DCHs_to_Add_TDD =  27,
  id_DCH_DeleteList_RL_ReconfPrepFDD =  30,
  id_DCH_DeleteList_RL_ReconfPrepTDD =  31,
  id_DCH_DeleteList_RL_ReconfRqstFDD =  32,
  id_DCH_DeleteList_RL_ReconfRqstTDD =  33,
  id_DCH_FDD_Information =  34,
  id_DCH_TDD_Information =  35,
  id_FDD_DCHs_to_Modify =  39,
  id_TDD_DCHs_to_Modify =  40,
  id_DCH_InformationResponse =  43,
  id_DCH_Rate_InformationItem_RL_CongestInd =  38,
  id_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD =  44,
  id_DL_CCTrCH_InformationListIE_RL_ReconfReadyTDD =  45,
  id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD =  46,
  id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD =  47,
  id_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD =  48,
  id_DL_CCTrCH_InformationListIE_RL_AdditionRspTDD =  49,
  id_DL_CCTrCH_InformationListIE_RL_SetupRspTDD =  50,
  id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD =  51,
  id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD =  52,
  id_DL_CCTrCH_InformationList_RL_SetupRqstTDD =  53,
  id_FDD_DL_CodeInformation =  54,
  id_DL_DPCH_Information_RL_ReconfPrepFDD =  59,
  id_DL_DPCH_Information_RL_SetupRqstFDD =  60,
  id_DL_DPCH_Information_RL_ReconfRqstFDD =  61,
  id_DL_DPCH_InformationItem_PhyChReconfRqstTDD =  62,
  id_DL_DPCH_InformationItem_RL_AdditionRspTDD =  63,
  id_DL_DPCH_InformationItem_RL_SetupRspTDD =  64,
  id_DL_DPCH_TimingAdjustment = 278,
  id_DLReferencePower =  67,
  id_DLReferencePowerList_DL_PC_Rqst =  68,
  id_DL_ReferencePowerInformation_DL_PC_Rqst =  69,
  id_DPC_Mode  =  12,
  id_DRXCycleLengthCoefficient =  70,
  id_DedicatedMeasurementObjectType_DM_Fail_Ind = 470,
  id_DedicatedMeasurementObjectType_DM_Fail = 471,
  id_DedicatedMeasurementObjectType_DM_Rprt =  71,
  id_DedicatedMeasurementObjectType_DM_Rqst =  72,
  id_DedicatedMeasurementObjectType_DM_Rsp =  73,
  id_DedicatedMeasurementType =  74,
  id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD =  82,
  id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD =  83,
  id_Guaranteed_Rate_Information =  41,
  id_IMSI      =  84,
  id_HCS_Prio  = 311,
  id_L3_Information =  85,
  id_AdjustmentPeriod =  90,
  id_MaxAdjustmentStep =  91,
  id_MeasurementFilterCoefficient =  92,
  id_MessageStructure =  57,
  id_MeasurementID =  93,
  id_Neighbouring_GSM_CellInformation =  13,
  id_Neighbouring_UMTS_CellInformationItem =  95,
  id_NRT_Load_Information_Value = 305,
  id_NRT_Load_Information_Value_IncrDecrThres = 306,
  id_PagingArea_PagingRqst = 102,
  id_FACH_FlowControlInformation = 103,
  id_PartialReportingIndicator = 472,
  id_Permanent_NAS_UE_Identity =  17,
  id_PowerAdjustmentType = 107,
  id_RANAP_RelocationInformation = 109,
  id_RL_Information_PhyChReconfRqstFDD = 110,
  id_RL_Information_PhyChReconfRqstTDD = 111,
  id_RL_Information_RL_AdditionRqstFDD = 112,
  id_RL_Information_RL_AdditionRqstTDD = 113,
  id_RL_Information_RL_DeletionRqst = 114,
  id_RL_Information_RL_FailureInd = 115,
  id_RL_Information_RL_ReconfPrepFDD = 116,
  id_RL_Information_RL_RestoreInd = 117,
  id_RL_Information_RL_SetupRqstFDD = 118,
  id_RL_Information_RL_SetupRqstTDD = 119,
  id_RL_InformationItem_RL_CongestInd =  55,
  id_RL_InformationItem_DM_Rprt = 120,
  id_RL_InformationItem_DM_Rqst = 121,
  id_RL_InformationItem_DM_Rsp = 122,
  id_RL_InformationItem_RL_PreemptRequiredInd =   2,
  id_RL_InformationItem_RL_SetupRqstFDD = 123,
  id_RL_InformationList_RL_CongestInd =  56,
  id_RL_InformationList_RL_AdditionRqstFDD = 124,
  id_RL_InformationList_RL_DeletionRqst = 125,
  id_RL_InformationList_RL_PreemptRequiredInd =   1,
  id_RL_InformationList_RL_ReconfPrepFDD = 126,
  id_RL_InformationResponse_RL_AdditionRspTDD = 127,
  id_RL_InformationResponse_RL_ReconfReadyTDD = 128,
  id_RL_InformationResponse_RL_SetupRspTDD = 129,
  id_RL_InformationResponseItem_RL_AdditionRspFDD = 130,
  id_RL_InformationResponseItem_RL_ReconfReadyFDD = 131,
  id_RL_InformationResponseItem_RL_ReconfRspFDD = 132,
  id_RL_InformationResponseItem_RL_SetupRspFDD = 133,
  id_RL_InformationResponseList_RL_AdditionRspFDD = 134,
  id_RL_InformationResponseList_RL_ReconfReadyFDD = 135,
  id_RL_InformationResponseList_RL_ReconfRspFDD = 136,
  id_RL_InformationResponse_RL_ReconfRspTDD =  28,
  id_RL_InformationResponseList_RL_SetupRspFDD = 137,
  id_RL_ReconfigurationFailure_RL_ReconfFail = 141,
  id_RL_Set_InformationItem_DM_Rprt = 143,
  id_RL_Set_InformationItem_DM_Rqst = 144,
  id_RL_Set_InformationItem_DM_Rsp = 145,
  id_RL_Set_Information_RL_FailureInd = 146,
  id_RL_Set_Information_RL_RestoreInd = 147,
  id_RL_Set_Successful_InformationItem_DM_Fail = 473,
  id_RL_Set_Unsuccessful_InformationItem_DM_Fail = 474,
  id_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind = 475,
  id_RL_Successful_InformationItem_DM_Fail = 476,
  id_RL_Unsuccessful_InformationItem_DM_Fail = 477,
  id_RL_Unsuccessful_InformationItem_DM_Fail_Ind = 478,
  id_ReportCharacteristics = 152,
  id_Reporting_Object_RL_FailureInd = 153,
  id_Reporing_Object_RL_RestoreInd = 154,
  id_RT_Load_Value = 307,
  id_RT_Load_Value_IncrDecrThres = 308,
  id_S_RNTI    = 155,
  id_ResetIndicator = 244,
  id_RNC_ID    = 245,
  id_SAI       = 156,
  id_SRNC_ID   = 157,
  id_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD = 159,
  id_SuccessfulRL_InformationResponse_RL_SetupFailureFDD = 160,
  id_TransportBearerID = 163,
  id_TransportBearerRequestIndicator = 164,
  id_TransportLayerAddress = 165,
  id_TypeOfError = 140,
  id_UC_ID     = 166,
  id_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD = 167,
  id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = 169,
  id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD = 171,
  id_UL_CCTrCH_InformationList_RL_SetupRqstTDD = 172,
  id_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD = 173,
  id_UL_CCTrCH_InformationListIE_RL_AdditionRspTDD = 174,
  id_UL_CCTrCH_InformationListIE_RL_ReconfReadyTDD = 175,
  id_UL_CCTrCH_InformationListIE_RL_SetupRspTDD = 176,
  id_UL_DPCH_Information_RL_ReconfPrepFDD = 177,
  id_UL_DPCH_Information_RL_ReconfRqstFDD = 178,
  id_UL_DPCH_Information_RL_SetupRqstFDD = 179,
  id_UL_DPCH_InformationItem_PhyChReconfRqstTDD = 180,
  id_UL_DPCH_InformationItem_RL_AdditionRspTDD = 181,
  id_UL_DPCH_InformationItem_RL_SetupRspTDD = 182,
  id_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = 183,
  id_UL_SIRTarget = 184,
  id_URA_Information = 185,
  id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD = 188,
  id_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD = 189,
  id_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD = 190,
  id_Active_Pattern_Sequence_Information = 193,
  id_AdjustmentRatio = 194,
  id_CauseLevel_RL_AdditionFailureFDD = 197,
  id_CauseLevel_RL_AdditionFailureTDD = 198,
  id_CauseLevel_RL_ReconfFailure = 199,
  id_CauseLevel_RL_SetupFailureFDD = 200,
  id_CauseLevel_RL_SetupFailureTDD = 201,
  id_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD = 205,
  id_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD = 206,
  id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = 207,
  id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = 208,
  id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = 209,
  id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = 210,
  id_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = 212,
  id_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = 213,
  id_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = 214,
  id_DSCHs_to_Add_TDD = 215,
  id_Unused_ProtocolIE_ID_216 = 216,
  id_DSCH_DeleteList_RL_ReconfPrepTDD = 217,
  id_Unused_ProtocolIE_ID_218 = 218,
  id_Unused_ProtocolIE_ID_219 = 219,
  id_DSCH_InformationListIE_RL_AdditionRspTDD = 220,
  id_DSCH_InformationListIEs_RL_SetupRspTDD = 221,
  id_DSCH_TDD_Information = 222,
  id_Unused_ProtocolIE_ID_223 = 223,
  id_Unused_ProtocolIE_ID_226 = 226,
  id_DSCH_ModifyList_RL_ReconfPrepTDD = 227,
  id_Unused_ProtocolIE_ID_228 = 228,
  id_Unused_ProtocolIE_ID_324 = 324,
  id_Unused_ProtocolIE_ID_229 = 229,
  id_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = 230,
  id_Unused_ProtocolIE_ID_29 =  29,
  id_Unused_ProtocolIE_ID_225 = 225,
  id_GA_Cell   = 232,
  id_GA_CellAdditionalShapes =   3,
  id_Unused_ProtocolIE_ID_246 = 246,
  id_Transmission_Gap_Pattern_Sequence_Information = 255,
  id_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD = 256,
  id_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD = 257,
  id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = 258,
  id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = 259,
  id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = 260,
  id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = 261,
  id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = 262,
  id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = 263,
  id_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = 264,
  id_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = 265,
  id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD = 266,
  id_USCHs_to_Add = 267,
  id_USCH_DeleteList_RL_ReconfPrepTDD = 268,
  id_USCH_InformationListIE_RL_AdditionRspTDD = 269,
  id_USCH_InformationListIEs_RL_SetupRspTDD = 270,
  id_USCH_Information = 271,
  id_USCH_ModifyList_RL_ReconfPrepTDD = 272,
  id_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = 273,
  id_DL_Physical_Channel_Information_RL_SetupRqstTDD = 274,
  id_UL_Physical_Channel_Information_RL_SetupRqstTDD = 275,
  id_ClosedLoopMode1_SupportIndicator = 276,
  id_Unused_ProtocolIE_ID_277 = 277,
  id_STTD_SupportIndicator = 279,
  id_CFNReportingIndicator =  14,
  id_CNOriginatedPage_PagingRqst =  23,
  id_InnerLoopDLPCStatus =  24,
  id_PropagationDelay =  25,
  id_RxTimingDeviationForTA =  36,
  id_timeSlot_ISCP =  37,
  id_CCTrCH_InformationItem_RL_FailureInd =  15,
  id_CCTrCH_InformationItem_RL_RestoreInd =  16,
  id_CommonMeasurementAccuracy = 280,
  id_CommonMeasurementObjectType_CM_Rprt = 281,
  id_CommonMeasurementObjectType_CM_Rqst = 282,
  id_CommonMeasurementObjectType_CM_Rsp = 283,
  id_CommonMeasurementType = 284,
  id_CongestionCause =  18,
  id_SFN       = 285,
  id_SFNReportingIndicator = 286,
  id_InformationExchangeID = 287,
  id_InformationExchangeObjectType_InfEx_Rprt = 288,
  id_InformationExchangeObjectType_InfEx_Rqst = 289,
  id_InformationExchangeObjectType_InfEx_Rsp = 290,
  id_InformationReportCharacteristics = 291,
  id_InformationType = 292,
  id_neighbouring_LCR_TDD_CellInformation =  58,
  id_DL_Timeslot_ISCP_LCR_Information_RL_SetupRqstTDD =  65,
  id_RL_LCR_InformationResponse_RL_SetupRspTDD =  66,
  id_UL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD =  75,
  id_UL_DPCH_LCR_InformationItem_RL_SetupRspTDD =  76,
  id_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD =  77,
  id_DL_DPCH_LCR_InformationItem_RL_SetupRspTDD =  78,
  id_DSCH_LCR_InformationListIEs_RL_SetupRspTDD =  79,
  id_USCH_LCR_InformationListIEs_RL_SetupRspTDD =  80,
  id_DL_Timeslot_ISCP_LCR_Information_RL_AdditionRqstTDD =  81,
  id_RL_LCR_InformationResponse_RL_AdditionRspTDD =  86,
  id_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD =  87,
  id_UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD =  88,
  id_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD =  89,
  id_DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD =  94,
  id_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD =  96,
  id_USCH_LCR_InformationListIEs_RL_AdditionRspTDD =  97,
  id_UL_DPCH_LCR_InformationAddListIE_RL_ReconfReadyTDD =  98,
  id_UL_Timeslot_LCR_InformationModifyList_RL_ReconfReadyTDD = 100,
  id_DL_DPCH_LCR_InformationAddListIE_RL_ReconfReadyTDD = 101,
  id_DL_Timeslot_LCR_InformationModifyList_RL_ReconfReadyTDD = 104,
  id_UL_Timeslot_LCR_InformationList_PhyChReconfRqstTDD = 105,
  id_DL_Timeslot_LCR_InformationList_PhyChReconfRqstTDD = 106,
  id_timeSlot_ISCP_LCR_List_DL_PC_Rqst_TDD = 138,
  id_TSTD_Support_Indicator_RL_SetupRqstTDD = 139,
  id_RestrictionStateIndicator = 142,
  id_Load_Value = 233,
  id_Load_Value_IncrDecrThres = 234,
  id_OnModification = 235,
  id_Received_Total_Wideband_Power_Value = 236,
  id_Received_Total_Wideband_Power_Value_IncrDecrThres = 237,
  id_SFNSFNMeasurementThresholdInformation = 238,
  id_Transmitted_Carrier_Power_Value = 239,
  id_Transmitted_Carrier_Power_Value_IncrDecrThres = 240,
  id_TUTRANGPSMeasurementThresholdInformation = 241,
  id_UL_Timeslot_ISCP_Value = 242,
  id_UL_Timeslot_ISCP_Value_IncrDecrThres = 243,
  id_Rx_Timing_Deviation_Value_LCR = 293,
  id_DPC_Mode_Change_SupportIndicator =  19,
  id_Unused_ProtocolIE_ID_247 = 247,
  id_Unused_ProtocolIE_ID_295 = 295,
  id_PrimaryCCPCH_RSCP_RL_ReconfPrepTDD = 202,
  id_DL_TimeSlot_ISCP_Info_RL_ReconfPrepTDD = 203,
  id_DL_Timeslot_ISCP_LCR_Information_RL_ReconfPrepTDD = 204,
  id_DSCH_RNTI = 249,
  id_DL_PowerBalancing_Information = 296,
  id_DL_PowerBalancing_ActivationIndicator = 297,
  id_DL_PowerBalancing_UpdatedIndicator = 298,
  id_DL_ReferencePowerInformation = 299,
  id_Enhanced_PrimaryCPICH_EcNo = 224,
  id_IPDL_TDD_ParametersLCR = 252,
  id_CellCapabilityContainer_FDD = 300,
  id_CellCapabilityContainer_TDD = 301,
  id_CellCapabilityContainer_TDD_LCR = 302,
  id_RL_Specific_DCH_Info = 317,
  id_RL_ReconfigurationRequestFDD_RL_InformationList = 318,
  id_RL_ReconfigurationRequestFDD_RL_Information_IEs = 319,
  id_RL_ReconfigurationRequestTDD_RL_Information = 321,
  id_CommonTransportChannelResourcesInitialisationNotRequired = 250,
  id_DelayedActivation = 312,
  id_DelayedActivationList_RL_ActivationCmdFDD = 313,
  id_DelayedActivationInformation_RL_ActivationCmdFDD = 314,
  id_DelayedActivationList_RL_ActivationCmdTDD = 315,
  id_DelayedActivationInformation_RL_ActivationCmdTDD = 316,
  id_neighbouringTDDCellMeasurementInformationLCR = 251,
  id_UL_SIR_Target_CCTrCH_InformationItem_RL_SetupRspTDD = 150,
  id_UL_SIR_Target_CCTrCH_LCR_InformationItem_RL_SetupRspTDD = 151,
  id_PrimCCPCH_RSCP_DL_PC_RqstTDD = 451,
  id_HSDSCH_FDD_Information = 452,
  id_HSDSCH_FDD_Information_Response = 453,
  id_HSDSCH_FDD_Update_Information = 466,
  id_HSDSCH_Information_to_Modify = 456,
  id_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd = 516,
  id_HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd = 517,
  id_HSDSCH_RNTI = 457,
  id_HSDSCH_TDD_Information = 458,
  id_HSDSCH_TDD_Information_Response = 459,
  id_HSDSCH_TDD_Update_Information = 467,
  id_HSPDSCH_RL_ID = 463,
  id_HSDSCH_MACdFlows_to_Add = 531,
  id_HSDSCH_MACdFlows_to_Delete = 532,
  id_Angle_Of_Arrival_Value_LCR = 148,
  id_TrafficClass = 158,
  id_Unused_ProtocolIE_ID_248 = 248,
  id_Unused_ProtocolIE_ID_253 = 253,
  id_PDSCH_RL_ID = 323,
  id_TimeSlot_RL_SetupRspTDD = 325,
  id_GERAN_Cell_Capability = 468,
  id_GERAN_Classmark = 469,
  id_DSCH_InitialWindowSize = 480,
  id_UL_Synchronisation_Parameters_LCR = 464,
  id_SNA_Information = 479,
  id_MAChs_ResetIndicator = 465,
  id_TDD_DL_DPCH_TimeSlotFormatModifyItem_LCR_RL_ReconfReadyTDD = 481,
  id_TDD_UL_DPCH_TimeSlotFormatModifyItem_LCR_RL_ReconfReadyTDD = 482,
  id_TDD_TPC_UplinkStepSize_LCR_RL_SetupRqstTDD = 483,
  id_UL_CCTrCH_InformationList_RL_AdditionRqstTDD = 484,
  id_UL_CCTrCH_InformationItem_RL_AdditionRqstTDD = 485,
  id_DL_CCTrCH_InformationList_RL_AdditionRqstTDD = 486,
  id_DL_CCTrCH_InformationItem_RL_AdditionRqstTDD = 487,
  id_TDD_TPC_UplinkStepSize_InformationAdd_LCR_RL_ReconfPrepTDD = 488,
  id_TDD_TPC_UplinkStepSize_InformationModify_LCR_RL_ReconfPrepTDD = 489,
  id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD = 490,
  id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD = 491,
  id_UL_TimingAdvanceCtrl_LCR = 492,
  id_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD = 493,
  id_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD = 494,
  id_HS_SICH_Reception_Quality = 495,
  id_HS_SICH_Reception_Quality_Measurement_Value = 496,
  id_HSSICH_Info_DM_Rprt = 497,
  id_HSSICH_Info_DM_Rqst = 498,
  id_HSSICH_Info_DM = 499,
  id_CCTrCH_Maximum_DL_Power_RL_SetupRspTDD = 500,
  id_CCTrCH_Minimum_DL_Power_RL_SetupRspTDD = 501,
  id_CCTrCH_Maximum_DL_Power_RL_AdditionRspTDD = 502,
  id_CCTrCH_Minimum_DL_Power_RL_AdditionRspTDD = 503,
  id_CCTrCH_Maximum_DL_Power_RL_ReconfReadyTDD = 504,
  id_CCTrCH_Minimum_DL_Power_RL_ReconfReadyTDD = 505,
  id_Maximum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = 506,
  id_Minimum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = 507,
  id_DL_CCTrCH_InformationList_RL_ReconfRspTDD = 508,
  id_DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD = 509,
  id_Maximum_DL_Power_TimeslotLCR_InformationItem = 510,
  id_Minimum_DL_Power_TimeslotLCR_InformationItem = 511,
  id_TDD_Support_8PSK = 512,
  id_TDD_maxNrDLPhysicalchannels = 513,
  id_ExtendedGSMCellIndividualOffset = 514,
  id_RL_ParameterUpdateIndicationFDD_RL_InformationList = 518,
  id_Primary_CPICH_Usage_For_Channel_Estimation = 519,
  id_Secondary_CPICH_Information = 520,
  id_Secondary_CPICH_Information_Change = 521,
  id_Unused_ProtocolIE_ID_522 = 522,
  id_Unused_ProtocolIE_ID_523 = 523,
  id_RL_ParameterUpdateIndicationFDD_RL_Information_Item = 524,
  id_Phase_Reference_Update_Indicator = 525,
  id_Unidirectional_DCH_Indicator = 526,
  id_RL_Information_RL_ReconfPrepTDD = 527,
  id_Multiple_RL_InformationResponse_RL_ReconfReadyTDD = 528,
  id_RL_ReconfigurationResponseTDD_RL_Information = 529,
  id_Satellite_Almanac_Information_ExtItem = 530,
  id_HSDSCH_Information_to_Modify_Unsynchronised = 533,
  id_TnlQos    = 534,
  id_RTLoadValue = 535,
  id_NRTLoadInformationValue = 536,
  id_CellPortionID = 537,
  id_UpPTSInterferenceValue = 538,
  id_PrimaryCCPCH_RSCP_Delta = 539,
  id_UEMeasurementType = 540,
  id_UEMeasurementTimeslotInfoHCR = 541,
  id_UEMeasurementTimeslotInfoLCR = 542,
  id_UEMeasurementReportCharacteristics = 543,
  id_UEMeasurementParameterModAllow = 544,
  id_UEMeasurementValueInformation = 545,
  id_InterfacesToTraceItem = 546,
  id_ListOfInterfacesToTrace = 547,
  id_TraceDepth = 548,
  id_TraceRecordingSessionReference = 549,
  id_TraceReference = 550,
  id_UEIdentity = 551,
  id_NACC_Related_Data = 552,
  id_GSM_Cell_InfEx_Rqst = 553,
  id_MeasurementRecoveryBehavior = 554,
  id_MeasurementRecoveryReportingIndicator = 555,
  id_MeasurementRecoverySupportIndicator = 556,
  id_DL_DPCH_Power_Information_RL_ReconfPrepFDD = 557,
  id_F_DPCH_Information_RL_ReconfPrepFDD = 558,
  id_F_DPCH_Information_RL_SetupRqstFDD = 559,
  id_MBMS_Bearer_Service_List = 560,
  id_MBMS_Bearer_Service_List_InfEx_Rsp = 561,
  id_Active_MBMS_Bearer_ServiceFDD = 562,
  id_Active_MBMS_Bearer_ServiceTDD = 563,
  id_Old_URA_ID = 564,
  id_UE_State  = 568,
  id_URA_ID    = 569,
  id_HARQ_Preamble_Mode = 571,
  id_SynchronisationIndicator = 572,
  id_UL_DPDCHIndicatorEDCH = 573,
  id_EDPCH_Information = 574,
  id_RL_Specific_EDCH_Information = 575,
  id_EDCH_RL_Indication = 576,
  id_EDCH_FDD_Information = 577,
  id_EDCH_RLSet_Id = 578,
  id_Serving_EDCHRL_Id = 579,
  id_EDCH_FDD_DL_ControlChannelInformation = 580,
  id_EDCH_FDD_InformationResponse = 581,
  id_EDCH_MACdFlows_To_Add = 582,
  id_EDCH_FDD_Information_To_Modify = 583,
  id_EDCH_MACdFlows_To_Delete = 584,
  id_EDPCH_Information_RLReconfRequest_FDD = 585,
  id_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd = 586,
  id_EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd = 587,
  id_EDCH_MacdFlowSpecificInformationList_RL_CongestInd = 588,
  id_EDCH_MacdFlowSpecificInformationItem_RL_CongestInd = 589,
  id_MBMS_Bearer_Service_Full_Address = 590,
  id_Initial_DL_DPCH_TimingAdjustment = 591,
  id_Initial_DL_DPCH_TimingAdjustment_Allowed = 592,
  id_User_Plane_Congestion_Fields_Inclusion = 593,
  id_HARQ_Preamble_Mode_Activation_Indicator = 594,
  id_multiple_DedicatedMeasurementValueList_TDD_DM_Rsp = 595,
  id_multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp = 596,
  id_ProvidedInformation = 597,
  id_Active_MBMS_Bearer_ServiceFDD_PFL = 598,
  id_Active_MBMS_Bearer_ServiceTDD_PFL = 599,
  id_FrequencyBandIndicator = 600,
  id_Serving_cell_change_CFN = 601,
  id_HS_DSCH_serving_cell_change_information = 602,
  id_HS_DSCH_serving_cell_change_informationResponse = 603,
  id_E_DCH_Serving_cell_change_informationResponse = 604,
  id_secondary_LCR_CCPCH_Info_TDD = 605,
  id_E_DCH_FDD_Update_Information = 606,
  id_Inter_Frequency_Cell_List = 607,
  id_Inter_Frequency_Cell_Information = 608,
  id_multiple_HSSICHMeasurementValueList_TDD_DM_Rsp = 609,
  id_TDD_Support_PLCCH = 610,
  id_PLCCH_Information_UL_TimeslotLCR_Info = 611,
  id_PLCCH_Information_PhyChReconfRqstTDD = 612,
  id_TDD768_maxNrDLPhysicalchannelsTS = 613,
  id_RL_InformationResponse_RL_AdditionRspTDD768 = 614,
  id_UL_CCTrCH_InformationListIE_RL_AdditionRspTDD768 = 615,
  id_DL_CCTrCH_InformationListIE_RL_AdditionRspTDD768 = 616,
  id_UL_DPCH_InformationItem_RL_AdditionRspTDD768 = 617,
  id_DL_DPCH_InformationItem_RL_AdditionRspTDD768 = 618,
  id_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD768 = 619,
  id_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768 = 620,
  id_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD768 = 621,
  id_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768 = 622,
  id_secondary_CCPCH_Info_RL_ReconfReadyTDD768 = 623,
  id_hSSCCH_TDD_Specific_InfoList_Response768 = 624,
  id_hSPDSCH_TDD_Specific_InfoList_Response768 = 625,
  id_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD768 = 626,
  id_UL_Timeslot_InformationList_PhyChReconfRqstTDD768 = 627,
  id_DL_Timeslot_InformationList_PhyChReconfRqstTDD768 = 628,
  id_CellCapabilityContainer_TDD768 = 629,
  id_multiple_DedicatedMeasurementValueList_TDD768_DM_Rsp = 630,
  id_neighbouringTDDCellMeasurementInformation768 = 631,
  id_UEMeasurementTimeslotInfo768 = 632,
  id_Rx_Timing_Deviation_Value_768 = 633,
  id_UEMeasurementValueTransmittedPowerList768 = 634,
  id_UEMeasurementValueTimeslotISCPList768 = 635,
  id_RL_InformationResponse_RL_SetupRspTDD768 = 636,
  id_UL_CCTrCH_InformationListIE_RL_SetupRspTDD768 = 637,
  id_DL_CCTrCH_InformationListIE_RL_SetupRspTDD768 = 638,
  id_UL_DPCH_InformationItem_RL_SetupRspTDD768 = 639,
  id_DL_DPCH_InformationItem_RL_SetupRspTDD768 = 640,
  id_TDD768_minimumSpreadingFactor_UL = 641,
  id_TDD768_minimumSpreadingFactor_DL = 642,
  id_TDD768_maxNrDLPhysicalchannels = 643,
  id_DL_DPCH_InformationDeleteList768_RL_ReconfReadyTDD = 644,
  id_DPCH_ID768_DM_Rsp = 645,
  id_DPCH_ID768_DM_Rqst = 646,
  id_DPCH_ID768_DM_Rprt = 647,
  id_EDPCH_Information_RLAdditionReq_FDD = 648,
  id_HSDSCH_Configured_Indicator = 649,
  id_RxTimingDeviationForTAext = 650,
  id_RxTimingDeviationForTA768 = 651,
  id_Rx_Timing_Deviation_Value_ext = 652,
  id_E_DCH_PowerOffset_for_SchedulingInfo = 653,
  id_TrCH_SrcStatisticsDescr = 654,
  id_E_DCH_Information = 655,
  id_E_DCH_Serving_RL_ID = 656,
  id_E_DCH_Information_Reconfig = 657,
  id_E_DCH_Information_Response = 658,
  id_E_DCH_768_Information = 659,
  id_E_DCH_768_Information_Reconfig = 660,
  id_E_DCH_768_Information_Response = 661,
  id_ExtendedPropagationDelay = 662,
  id_Extended_Round_Trip_Time_Value = 663,
  id_AlternativeFormatReportingIndicator = 664,
  id_DCH_Indicator_For_E_DCH_HSDPA_Operation = 665,
  id_E_RGCH_E_HICH_ChannelisationCodeValidityIndicator = 666,
  id_E_DCH_Minimum_Set_E_TFCIValidityIndicator = 667,
  id_Fast_Reconfiguration_Mode = 668,
  id_Fast_Reconfiguration_Permission = 669,
  id_Continuous_Packet_Connectivity_DTX_DRX_Information = 670,
  id_Continuous_Packet_Connectivity_HS_SCCH_Less_Information = 671,
  id_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response = 672,
  id_CPC_Information = 673,
  id_MIMO_Information = 674,
  id_MIMO_InformationResponse = 675,
  id_MIMO_InformationToModify = 676,
  id_E_DCH_LCR_Information = 677,
  id_E_DCH_LCR_Information_Reconfig = 678,
  id_E_DCH_LCR_Information_Response = 679,
  id_HS_PDSCH_Code_Change_Grant = 680,
  id_HS_PDSCH_Code_Change_Indicator = 681,
  id_Extended_SRNC_ID = 682,
  id_Extended_RNC_ID = 683,
  id_SixtyfourQAM_DL_SupportIndicator = 684,
  id_Enhanced_FACH_Support_Indicator = 685,
  id_Enhanced_FACH_Information_ResponseFDD = 686,
  id_SixteenQAM_UL_Information = 688,
  id_HSDSCH_MACdPDUSizeFormat = 690,
  id_MaximumMACdPDU_SizeExtended = 691,
  id_F_DPCH_SlotFormat = 692,
  id_F_DPCH_SlotFormatSupportRequest = 693,
  id_eDCH_MACdFlow_Retransmission_Timer_LCR = 694,
  id_Max_UE_DTX_Cycle = 695,
  id_SixteenQAM_UL_Information_to_Modify = 696,
  id_E_TFCI_BetaEC_Boost = 697,
  id_E_TFCI_BetaED_Switch = 698,
  id_GANSS_Common_Data = 699,
  id_GANSS_Information = 700,
  id_GANSS_Generic_Data = 701,
  id_TUTRANGANSSMeasurementThresholdInformation = 702,
  id_TUTRANGANSSMeasurementValueInformation = 703,
  id_Enhanced_PCH_Support_Indicator = 704
} ProtocolIE_ID_enum;

/*--- End of included file: packet-rnsap-val.h ---*/
#line 58 "packet-rnsap-template.c"

static dissector_handle_t rnsap_handle = NULL;

static dissector_handle_t rrc_dl_dcch_handle = NULL;

/* Initialize the protocol and registered fields */
static int proto_rnsap = -1;


/*--- Included file: packet-rnsap-hf.c ---*/
#line 1 "packet-rnsap-hf.c"
static int hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_PDU = -1;  /* Active_MBMS_Bearer_Service_ListFDD */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL_PDU = -1;  /* Active_MBMS_Bearer_Service_ListFDD_PFL */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_PDU = -1;  /* Active_MBMS_Bearer_Service_ListTDD */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL_PDU = -1;  /* Active_MBMS_Bearer_Service_ListTDD_PFL */
static int hf_rnsap_Active_Pattern_Sequence_Information_PDU = -1;  /* Active_Pattern_Sequence_Information */
static int hf_rnsap_AdjustmentPeriod_PDU = -1;    /* AdjustmentPeriod */
static int hf_rnsap_Allowed_Rate_Information_PDU = -1;  /* Allowed_Rate_Information */
static int hf_rnsap_AllowedQueuingTime_PDU = -1;  /* AllowedQueuingTime */
static int hf_rnsap_AlternativeFormatReportingIndicator_PDU = -1;  /* AlternativeFormatReportingIndicator */
static int hf_rnsap_Angle_Of_Arrival_Value_LCR_PDU = -1;  /* Angle_Of_Arrival_Value_LCR */
static int hf_rnsap_AntennaColocationIndicator_PDU = -1;  /* AntennaColocationIndicator */
static int hf_rnsap_BindingID_PDU = -1;           /* BindingID */
static int hf_rnsap_Cause_PDU = -1;               /* Cause */
static int hf_rnsap_CellCapabilityContainer_FDD_PDU = -1;  /* CellCapabilityContainer_FDD */
static int hf_rnsap_CellCapabilityContainer_TDD_PDU = -1;  /* CellCapabilityContainer_TDD */
static int hf_rnsap_CellCapabilityContainer_TDD_LCR_PDU = -1;  /* CellCapabilityContainer_TDD_LCR */
static int hf_rnsap_CellCapabilityContainer_TDD768_PDU = -1;  /* CellCapabilityContainer_TDD768 */
static int hf_rnsap_C_ID_PDU = -1;                /* C_ID */
static int hf_rnsap_Cell_Capacity_Class_Value_PDU = -1;  /* Cell_Capacity_Class_Value */
static int hf_rnsap_CellPortionID_PDU = -1;       /* CellPortionID */
static int hf_rnsap_CFN_PDU = -1;                 /* CFN */
static int hf_rnsap_ClosedLoopMode1_SupportIndicator_PDU = -1;  /* ClosedLoopMode1_SupportIndicator */
static int hf_rnsap_CommonMeasurementAccuracy_PDU = -1;  /* CommonMeasurementAccuracy */
static int hf_rnsap_CommonMeasurementType_PDU = -1;  /* CommonMeasurementType */
static int hf_rnsap_CongestionCause_PDU = -1;     /* CongestionCause */
static int hf_rnsap_CommonTransportChannelResourcesInitialisationNotRequired_PDU = -1;  /* CommonTransportChannelResourcesInitialisationNotRequired */
static int hf_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information_PDU = -1;  /* Continuous_Packet_Connectivity_DTX_DRX_Information */
static int hf_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_PDU = -1;  /* Continuous_Packet_Connectivity_HS_SCCH_Less_Information */
static int hf_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response_PDU = -1;  /* Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response */
static int hf_rnsap_CoverageIndicator_PDU = -1;   /* CoverageIndicator */
static int hf_rnsap_CPC_Information_PDU = -1;     /* CPC_Information */
static int hf_rnsap_CriticalityDiagnostics_PDU = -1;  /* CriticalityDiagnostics */
static int hf_rnsap_MessageStructure_PDU = -1;    /* MessageStructure */
static int hf_rnsap_CN_CS_DomainIdentifier_PDU = -1;  /* CN_CS_DomainIdentifier */
static int hf_rnsap_CN_PS_DomainIdentifier_PDU = -1;  /* CN_PS_DomainIdentifier */
static int hf_rnsap_C_RNTI_PDU = -1;              /* C_RNTI */
static int hf_rnsap_DCH_FDD_Information_PDU = -1;  /* DCH_FDD_Information */
static int hf_rnsap_DCH_Indicator_For_E_DCH_HSDPA_Operation_PDU = -1;  /* DCH_Indicator_For_E_DCH_HSDPA_Operation */
static int hf_rnsap_DCH_InformationResponse_PDU = -1;  /* DCH_InformationResponse */
static int hf_rnsap_DCH_TDD_Information_PDU = -1;  /* DCH_TDD_Information */
static int hf_rnsap_DedicatedMeasurementType_PDU = -1;  /* DedicatedMeasurementType */
static int hf_rnsap_DelayedActivation_PDU = -1;   /* DelayedActivation */
static int hf_rnsap_DL_DPCH_TimingAdjustment_PDU = -1;  /* DL_DPCH_TimingAdjustment */
static int hf_rnsap_DL_Power_PDU = -1;            /* DL_Power */
static int hf_rnsap_DL_PowerBalancing_Information_PDU = -1;  /* DL_PowerBalancing_Information */
static int hf_rnsap_DL_PowerBalancing_ActivationIndicator_PDU = -1;  /* DL_PowerBalancing_ActivationIndicator */
static int hf_rnsap_DL_PowerBalancing_UpdatedIndicator_PDU = -1;  /* DL_PowerBalancing_UpdatedIndicator */
static int hf_rnsap_DL_ReferencePowerInformation_PDU = -1;  /* DL_ReferencePowerInformation */
static int hf_rnsap_D_RNTI_PDU = -1;              /* D_RNTI */
static int hf_rnsap_D_RNTI_ReleaseIndication_PDU = -1;  /* D_RNTI_ReleaseIndication */
static int hf_rnsap_DL_TimeSlot_ISCP_Info_PDU = -1;  /* DL_TimeSlot_ISCP_Info */
static int hf_rnsap_DL_TimeSlot_ISCP_LCR_Information_PDU = -1;  /* DL_TimeSlot_ISCP_LCR_Information */
static int hf_rnsap_DPC_Mode_PDU = -1;            /* DPC_Mode */
static int hf_rnsap_DPC_Mode_Change_SupportIndicator_PDU = -1;  /* DPC_Mode_Change_SupportIndicator */
static int hf_rnsap_DPCH_ID768_PDU = -1;          /* DPCH_ID768 */
static int hf_rnsap_DRXCycleLengthCoefficient_PDU = -1;  /* DRXCycleLengthCoefficient */
static int hf_rnsap_DSCH_RNTI_PDU = -1;           /* DSCH_RNTI */
static int hf_rnsap_DSCH_InitialWindowSize_PDU = -1;  /* DSCH_InitialWindowSize */
static int hf_rnsap_DSCH_TDD_Information_PDU = -1;  /* DSCH_TDD_Information */
static int hf_rnsap_EDCH_FDD_DL_ControlChannelInformation_PDU = -1;  /* EDCH_FDD_DL_ControlChannelInformation */
static int hf_rnsap_E_RGCH_E_HICH_ChannelisationCodeValidityIndicator_PDU = -1;  /* E_RGCH_E_HICH_ChannelisationCodeValidityIndicator */
static int hf_rnsap_EDCH_FDD_Information_PDU = -1;  /* EDCH_FDD_Information */
static int hf_rnsap_EDCH_FDD_InformationResponse_PDU = -1;  /* EDCH_FDD_InformationResponse */
static int hf_rnsap_EDCH_FDD_Information_To_Modify_PDU = -1;  /* EDCH_FDD_Information_To_Modify */
static int hf_rnsap_E_DCH_FDD_Update_Information_PDU = -1;  /* E_DCH_FDD_Update_Information */
static int hf_rnsap_E_DCH_PowerOffset_for_SchedulingInfo_PDU = -1;  /* E_DCH_PowerOffset_for_SchedulingInfo */
static int hf_rnsap_EDCH_MACdFlows_Information_PDU = -1;  /* EDCH_MACdFlows_Information */
static int hf_rnsap_EDCH_MACdFlows_To_Delete_PDU = -1;  /* EDCH_MACdFlows_To_Delete */
static int hf_rnsap_EDCH_RL_Indication_PDU = -1;  /* EDCH_RL_Indication */
static int hf_rnsap_E_DCH_Serving_cell_change_informationResponse_PDU = -1;  /* E_DCH_Serving_cell_change_informationResponse */
static int hf_rnsap_EDPCH_Information_FDD_PDU = -1;  /* EDPCH_Information_FDD */
static int hf_rnsap_EDPCH_Information_RLReconfRequest_FDD_PDU = -1;  /* EDPCH_Information_RLReconfRequest_FDD */
static int hf_rnsap_EDCH_Serving_RL_PDU = -1;     /* EDCH_Serving_RL */
static int hf_rnsap_Enhanced_FACH_Information_ResponseFDD_PDU = -1;  /* Enhanced_FACH_Information_ResponseFDD */
static int hf_rnsap_Enhanced_FACH_Support_Indicator_PDU = -1;  /* Enhanced_FACH_Support_Indicator */
static int hf_rnsap_Enhanced_PCH_Support_Indicator_PDU = -1;  /* Enhanced_PCH_Support_Indicator */
static int hf_rnsap_E_TFCI_BetaEC_Boost_PDU = -1;  /* E_TFCI_BetaEC_Boost */
static int hf_rnsap_E_TFCI_BetaED_Switch_PDU = -1;  /* E_TFCI_BetaED_Switch */
static int hf_rnsap_E_DCH_Minimum_Set_E_TFCIValidityIndicator_PDU = -1;  /* E_DCH_Minimum_Set_E_TFCIValidityIndicator */
static int hf_rnsap_Enhanced_PrimaryCPICH_EcNo_PDU = -1;  /* Enhanced_PrimaryCPICH_EcNo */
static int hf_rnsap_ExtendedGSMCellIndividualOffset_PDU = -1;  /* ExtendedGSMCellIndividualOffset */
static int hf_rnsap_E_DCH_Information_PDU = -1;   /* E_DCH_Information */
static int hf_rnsap_E_DCH_MACdFlow_Retransmission_Timer_LCR_PDU = -1;  /* E_DCH_MACdFlow_Retransmission_Timer_LCR */
static int hf_rnsap_E_DCH_Information_Reconfig_PDU = -1;  /* E_DCH_Information_Reconfig */
static int hf_rnsap_E_DCH_Information_Response_PDU = -1;  /* E_DCH_Information_Response */
static int hf_rnsap_E_DCH_768_Information_PDU = -1;  /* E_DCH_768_Information */
static int hf_rnsap_E_DCH_768_Information_Reconfig_PDU = -1;  /* E_DCH_768_Information_Reconfig */
static int hf_rnsap_E_DCH_768_Information_Response_PDU = -1;  /* E_DCH_768_Information_Response */
static int hf_rnsap_E_DCH_LCR_Information_PDU = -1;  /* E_DCH_LCR_Information */
static int hf_rnsap_E_DCH_LCR_Information_Reconfig_PDU = -1;  /* E_DCH_LCR_Information_Reconfig */
static int hf_rnsap_E_DCH_LCR_Information_Response_PDU = -1;  /* E_DCH_LCR_Information_Response */
static int hf_rnsap_ExtendedPropagationDelay_PDU = -1;  /* ExtendedPropagationDelay */
static int hf_rnsap_Extended_RNC_ID_PDU = -1;     /* Extended_RNC_ID */
static int hf_rnsap_Extended_Round_Trip_Time_Value_PDU = -1;  /* Extended_Round_Trip_Time_Value */
static int hf_rnsap_FACH_FlowControlInformation_PDU = -1;  /* FACH_FlowControlInformation */
static int hf_rnsap_Fast_Reconfiguration_Mode_PDU = -1;  /* Fast_Reconfiguration_Mode */
static int hf_rnsap_Fast_Reconfiguration_Permission_PDU = -1;  /* Fast_Reconfiguration_Permission */
static int hf_rnsap_FDD_DCHs_to_Modify_PDU = -1;  /* FDD_DCHs_to_Modify */
static int hf_rnsap_FDD_DL_CodeInformation_PDU = -1;  /* FDD_DL_CodeInformation */
static int hf_rnsap_F_DPCH_SlotFormat_PDU = -1;   /* F_DPCH_SlotFormat */
static int hf_rnsap_F_DPCH_SlotFormatSupportRequest_PDU = -1;  /* F_DPCH_SlotFormatSupportRequest */
static int hf_rnsap_FNReportingIndicator_PDU = -1;  /* FNReportingIndicator */
static int hf_rnsap_FrequencyBandIndicator_PDU = -1;  /* FrequencyBandIndicator */
static int hf_rnsap_GA_Cell_PDU = -1;             /* GA_Cell */
static int hf_rnsap_GA_CellAdditionalShapes_PDU = -1;  /* GA_CellAdditionalShapes */
static int hf_rnsap_GANSS_Common_Data_PDU = -1;   /* GANSS_Common_Data */
static int hf_rnsap_GANSS_Generic_Data_PDU = -1;  /* GANSS_Generic_Data */
static int hf_rnsap_GANSS_Information_PDU = -1;   /* GANSS_Information */
static int hf_rnsap_GERAN_Cell_Capability_PDU = -1;  /* GERAN_Cell_Capability */
static int hf_rnsap_GERAN_Classmark_PDU = -1;     /* GERAN_Classmark */
static int hf_rnsap_Satellite_Almanac_Information_ExtItem_PDU = -1;  /* Satellite_Almanac_Information_ExtItem */
static int hf_rnsap_Guaranteed_Rate_Information_PDU = -1;  /* Guaranteed_Rate_Information */
static int hf_rnsap_HARQ_Preamble_Mode_PDU = -1;  /* HARQ_Preamble_Mode */
static int hf_rnsap_HARQ_Preamble_Mode_Activation_Indicator_PDU = -1;  /* HARQ_Preamble_Mode_Activation_Indicator */
static int hf_rnsap_HCS_Prio_PDU = -1;            /* HCS_Prio */
static int hf_rnsap_HSDSCH_Configured_Indicator_PDU = -1;  /* HSDSCH_Configured_Indicator */
static int hf_rnsap_HSDSCH_FDD_Information_PDU = -1;  /* HSDSCH_FDD_Information */
static int hf_rnsap_HSDSCH_FDD_Information_Response_PDU = -1;  /* HSDSCH_FDD_Information_Response */
static int hf_rnsap_HSDSCH_Information_to_Modify_PDU = -1;  /* HSDSCH_Information_to_Modify */
static int hf_rnsap_HSDSCH_Information_to_Modify_Unsynchronised_PDU = -1;  /* HSDSCH_Information_to_Modify_Unsynchronised */
static int hf_rnsap_HSDSCH_MACdPDUSizeFormat_PDU = -1;  /* HSDSCH_MACdPDUSizeFormat */
static int hf_rnsap_HSDSCH_MACdFlows_Information_PDU = -1;  /* HSDSCH_MACdFlows_Information */
static int hf_rnsap_HSDSCH_MACdFlows_to_Delete_PDU = -1;  /* HSDSCH_MACdFlows_to_Delete */
static int hf_rnsap_HSDSCH_RNTI_PDU = -1;         /* HSDSCH_RNTI */
static int hf_rnsap_HS_DSCH_serving_cell_change_information_PDU = -1;  /* HS_DSCH_serving_cell_change_information */
static int hf_rnsap_HS_DSCH_serving_cell_change_informationResponse_PDU = -1;  /* HS_DSCH_serving_cell_change_informationResponse */
static int hf_rnsap_HSDSCH_TDD_Information_PDU = -1;  /* HSDSCH_TDD_Information */
static int hf_rnsap_HSDSCH_TDD_Information_Response_PDU = -1;  /* HSDSCH_TDD_Information_Response */
static int hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response768_PDU = -1;  /* HSPDSCH_TDD_Specific_InfoList_Response768 */
static int hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response768_PDU = -1;  /* HSSCCH_TDD_Specific_InfoList_Response768 */
static int hf_rnsap_HS_SICH_Reception_Quality_Value_PDU = -1;  /* HS_SICH_Reception_Quality_Value */
static int hf_rnsap_HS_SICH_Reception_Quality_Measurement_Value_PDU = -1;  /* HS_SICH_Reception_Quality_Measurement_Value */
static int hf_rnsap_HS_SICH_ID_PDU = -1;          /* HS_SICH_ID */
static int hf_rnsap_HS_PDSCH_Code_Change_Indicator_PDU = -1;  /* HS_PDSCH_Code_Change_Indicator */
static int hf_rnsap_HS_PDSCH_Code_Change_Grant_PDU = -1;  /* HS_PDSCH_Code_Change_Grant */
static int hf_rnsap_HSDSCH_FDD_Update_Information_PDU = -1;  /* HSDSCH_FDD_Update_Information */
static int hf_rnsap_HSDSCH_TDD_Update_Information_PDU = -1;  /* HSDSCH_TDD_Update_Information */
static int hf_rnsap_IMSI_PDU = -1;                /* IMSI */
static int hf_rnsap_InformationExchangeID_PDU = -1;  /* InformationExchangeID */
static int hf_rnsap_InformationReportCharacteristics_PDU = -1;  /* InformationReportCharacteristics */
static int hf_rnsap_InformationType_PDU = -1;     /* InformationType */
static int hf_rnsap_Initial_DL_DPCH_TimingAdjustment_Allowed_PDU = -1;  /* Initial_DL_DPCH_TimingAdjustment_Allowed */
static int hf_rnsap_InnerLoopDLPCStatus_PDU = -1;  /* InnerLoopDLPCStatus */
static int hf_rnsap_Inter_Frequency_Cell_List_PDU = -1;  /* Inter_Frequency_Cell_List */
static int hf_rnsap_Inter_Frequency_Cell_Information_PDU = -1;  /* Inter_Frequency_Cell_Information */
static int hf_rnsap_IPDL_TDD_ParametersLCR_PDU = -1;  /* IPDL_TDD_ParametersLCR */
static int hf_rnsap_L3_Information_PDU = -1;      /* L3_Information */
static int hf_rnsap_Load_Value_IncrDecrThres_PDU = -1;  /* Load_Value_IncrDecrThres */
static int hf_rnsap_Load_Value_PDU = -1;          /* Load_Value */
static int hf_rnsap_MAC_PDU_SizeExtended_PDU = -1;  /* MAC_PDU_SizeExtended */
static int hf_rnsap_MaxNrDLPhysicalchannels768_PDU = -1;  /* MaxNrDLPhysicalchannels768 */
static int hf_rnsap_MaxNrDLPhysicalchannelsTS_PDU = -1;  /* MaxNrDLPhysicalchannelsTS */
static int hf_rnsap_MaxNrDLPhysicalchannelsTS768_PDU = -1;  /* MaxNrDLPhysicalchannelsTS768 */
static int hf_rnsap_Max_UE_DTX_Cycle_PDU = -1;    /* Max_UE_DTX_Cycle */
static int hf_rnsap_MBMS_Bearer_Service_Full_Address_PDU = -1;  /* MBMS_Bearer_Service_Full_Address */
static int hf_rnsap_MBMS_Bearer_Service_List_PDU = -1;  /* MBMS_Bearer_Service_List */
static int hf_rnsap_MeasurementFilterCoefficient_PDU = -1;  /* MeasurementFilterCoefficient */
static int hf_rnsap_MeasurementID_PDU = -1;       /* MeasurementID */
static int hf_rnsap_MinimumSpreadingFactor768_PDU = -1;  /* MinimumSpreadingFactor768 */
static int hf_rnsap_MaxAdjustmentStep_PDU = -1;   /* MaxAdjustmentStep */
static int hf_rnsap_MeasurementRecoveryBehavior_PDU = -1;  /* MeasurementRecoveryBehavior */
static int hf_rnsap_MeasurementRecoveryReportingIndicator_PDU = -1;  /* MeasurementRecoveryReportingIndicator */
static int hf_rnsap_MeasurementRecoverySupportIndicator_PDU = -1;  /* MeasurementRecoverySupportIndicator */
static int hf_rnsap_MIMO_Information_PDU = -1;    /* MIMO_Information */
static int hf_rnsap_MIMO_InformationResponse_PDU = -1;  /* MIMO_InformationResponse */
static int hf_rnsap_MIMO_InformationToModify_PDU = -1;  /* MIMO_InformationToModify */
static int hf_rnsap_MAChs_ResetIndicator_PDU = -1;  /* MAChs_ResetIndicator */
static int hf_rnsap_NACC_Related_Data_PDU = -1;   /* NACC_Related_Data */
static int hf_rnsap_Neighbouring_UMTS_CellInformationItem_PDU = -1;  /* Neighbouring_UMTS_CellInformationItem */
static int hf_rnsap_Neighbouring_GSM_CellInformationIEs_PDU = -1;  /* Neighbouring_GSM_CellInformationIEs */
static int hf_rnsap_NeighbouringTDDCellMeasurementInformationLCR_PDU = -1;  /* NeighbouringTDDCellMeasurementInformationLCR */
static int hf_rnsap_NeighbouringTDDCellMeasurementInformation768_PDU = -1;  /* NeighbouringTDDCellMeasurementInformation768 */
static int hf_rnsap_Neighbouring_LCR_TDD_CellInformation_PDU = -1;  /* Neighbouring_LCR_TDD_CellInformation */
static int hf_rnsap_NRT_Load_Information_Value_IncrDecrThres_PDU = -1;  /* NRT_Load_Information_Value_IncrDecrThres */
static int hf_rnsap_NRT_Load_Information_Value_PDU = -1;  /* NRT_Load_Information_Value */
static int hf_rnsap_NRTLoadInformationValue_PDU = -1;  /* NRTLoadInformationValue */
static int hf_rnsap_OnModification_PDU = -1;      /* OnModification */
static int hf_rnsap_PartialReportingIndicator_PDU = -1;  /* PartialReportingIndicator */
static int hf_rnsap_Permanent_NAS_UE_Identity_PDU = -1;  /* Permanent_NAS_UE_Identity */
static int hf_rnsap_Phase_Reference_Update_Indicator_PDU = -1;  /* Phase_Reference_Update_Indicator */
static int hf_rnsap_PowerAdjustmentType_PDU = -1;  /* PowerAdjustmentType */
static int hf_rnsap_Primary_CPICH_Usage_For_Channel_Estimation_PDU = -1;  /* Primary_CPICH_Usage_For_Channel_Estimation */
static int hf_rnsap_PrimaryCCPCH_RSCP_PDU = -1;   /* PrimaryCCPCH_RSCP */
static int hf_rnsap_PrimaryCCPCH_RSCP_Delta_PDU = -1;  /* PrimaryCCPCH_RSCP_Delta */
static int hf_rnsap_PropagationDelay_PDU = -1;    /* PropagationDelay */
static int hf_rnsap_ProvidedInformation_PDU = -1;  /* ProvidedInformation */
static int hf_rnsap_RANAP_RelocationInformation_PDU = -1;  /* RANAP_RelocationInformation */
static int hf_rnsap_Received_Total_Wideband_Power_Value_PDU = -1;  /* Received_Total_Wideband_Power_Value */
static int hf_rnsap_Received_Total_Wideband_Power_Value_IncrDecrThres_PDU = -1;  /* Received_Total_Wideband_Power_Value_IncrDecrThres */
static int hf_rnsap_ReportCharacteristics_PDU = -1;  /* ReportCharacteristics */
static int hf_rnsap_RestrictionStateIndicator_PDU = -1;  /* RestrictionStateIndicator */
static int hf_rnsap_RL_ID_PDU = -1;               /* RL_ID */
static int hf_rnsap_RL_Set_ID_PDU = -1;           /* RL_Set_ID */
static int hf_rnsap_RL_Specific_DCH_Info_PDU = -1;  /* RL_Specific_DCH_Info */
static int hf_rnsap_RL_Specific_EDCH_Information_PDU = -1;  /* RL_Specific_EDCH_Information */
static int hf_rnsap_RNC_ID_PDU = -1;              /* RNC_ID */
static int hf_rnsap_RT_Load_Value_IncrDecrThres_PDU = -1;  /* RT_Load_Value_IncrDecrThres */
static int hf_rnsap_RT_Load_Value_PDU = -1;       /* RT_Load_Value */
static int hf_rnsap_RTLoadValue_PDU = -1;         /* RTLoadValue */
static int hf_rnsap_RxTimingDeviationForTA_PDU = -1;  /* RxTimingDeviationForTA */
static int hf_rnsap_RxTimingDeviationForTAext_PDU = -1;  /* RxTimingDeviationForTAext */
static int hf_rnsap_RxTimingDeviationForTA768_PDU = -1;  /* RxTimingDeviationForTA768 */
static int hf_rnsap_Rx_Timing_Deviation_Value_ext_PDU = -1;  /* Rx_Timing_Deviation_Value_ext */
static int hf_rnsap_Rx_Timing_Deviation_Value_LCR_PDU = -1;  /* Rx_Timing_Deviation_Value_LCR */
static int hf_rnsap_Rx_Timing_Deviation_Value_768_PDU = -1;  /* Rx_Timing_Deviation_Value_768 */
static int hf_rnsap_SAI_PDU = -1;                 /* SAI */
static int hf_rnsap_ScaledAdjustmentRatio_PDU = -1;  /* ScaledAdjustmentRatio */
static int hf_rnsap_Secondary_CPICH_Information_PDU = -1;  /* Secondary_CPICH_Information */
static int hf_rnsap_Secondary_CPICH_Information_Change_PDU = -1;  /* Secondary_CPICH_Information_Change */
static int hf_rnsap_Secondary_LCR_CCPCH_Info_TDD_PDU = -1;  /* Secondary_LCR_CCPCH_Info_TDD */
static int hf_rnsap_Secondary_CCPCH_Info_TDD768_PDU = -1;  /* Secondary_CCPCH_Info_TDD768 */
static int hf_rnsap_SFN_PDU = -1;                 /* SFN */
static int hf_rnsap_SFNSFNMeasurementThresholdInformation_PDU = -1;  /* SFNSFNMeasurementThresholdInformation */
static int hf_rnsap_SixteenQAM_UL_Information_PDU = -1;  /* SixteenQAM_UL_Information */
static int hf_rnsap_SixteenQAM_UL_Information_to_Modify_PDU = -1;  /* SixteenQAM_UL_Information_to_Modify */
static int hf_rnsap_SixtyfourQAM_DL_SupportIndicator_PDU = -1;  /* SixtyfourQAM_DL_SupportIndicator */
static int hf_rnsap_SNA_Information_PDU = -1;     /* SNA_Information */
static int hf_rnsap_S_RNTI_PDU = -1;              /* S_RNTI */
static int hf_rnsap_STTD_SupportIndicator_PDU = -1;  /* STTD_SupportIndicator */
static int hf_rnsap_Support_8PSK_PDU = -1;        /* Support_8PSK */
static int hf_rnsap_Support_PLCCH_PDU = -1;       /* Support_PLCCH */
static int hf_rnsap_TDD_DCHs_to_Modify_PDU = -1;  /* TDD_DCHs_to_Modify */
static int hf_rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR_PDU = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_TDD_TPC_DownlinkStepSize_PDU = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_rnsap_TDD_TPC_UplinkStepSize_LCR_PDU = -1;  /* TDD_TPC_UplinkStepSize_LCR */
static int hf_rnsap_TDD_UL_DPCH_TimeSlotFormat_LCR_PDU = -1;  /* TDD_UL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_TimeSlot_PDU = -1;            /* TimeSlot */
static int hf_rnsap_SynchronisationIndicator_PDU = -1;  /* SynchronisationIndicator */
static int hf_rnsap_TnlQos_PDU = -1;              /* TnlQos */
static int hf_rnsap_TraceDepth_PDU = -1;          /* TraceDepth */
static int hf_rnsap_TraceRecordingSessionReference_PDU = -1;  /* TraceRecordingSessionReference */
static int hf_rnsap_TraceReference_PDU = -1;      /* TraceReference */
static int hf_rnsap_TrafficClass_PDU = -1;        /* TrafficClass */
static int hf_rnsap_Transmission_Gap_Pattern_Sequence_Information_PDU = -1;  /* Transmission_Gap_Pattern_Sequence_Information */
static int hf_rnsap_Transmitted_Carrier_Power_Value_PDU = -1;  /* Transmitted_Carrier_Power_Value */
static int hf_rnsap_Transmitted_Carrier_Power_Value_IncrDecrThres_PDU = -1;  /* Transmitted_Carrier_Power_Value_IncrDecrThres */
static int hf_rnsap_TUTRANGANSSMeasurementThresholdInformation_PDU = -1;  /* TUTRANGANSSMeasurementThresholdInformation */
static int hf_rnsap_TUTRANGANSSMeasurementValueInformation_PDU = -1;  /* TUTRANGANSSMeasurementValueInformation */
static int hf_rnsap_TUTRANGPSMeasurementThresholdInformation_PDU = -1;  /* TUTRANGPSMeasurementThresholdInformation */
static int hf_rnsap_TransportBearerID_PDU = -1;   /* TransportBearerID */
static int hf_rnsap_TransportBearerRequestIndicator_PDU = -1;  /* TransportBearerRequestIndicator */
static int hf_rnsap_TransportLayerAddress_PDU = -1;  /* TransportLayerAddress */
static int hf_rnsap_TrCH_SrcStatisticsDescr_PDU = -1;  /* TrCH_SrcStatisticsDescr */
static int hf_rnsap_TSTD_Support_Indicator_PDU = -1;  /* TSTD_Support_Indicator */
static int hf_rnsap_TypeOfError_PDU = -1;         /* TypeOfError */
static int hf_rnsap_UEIdentity_PDU = -1;          /* UEIdentity */
static int hf_rnsap_UEMeasurementParameterModAllow_PDU = -1;  /* UEMeasurementParameterModAllow */
static int hf_rnsap_UEMeasurementReportCharacteristics_PDU = -1;  /* UEMeasurementReportCharacteristics */
static int hf_rnsap_UEMeasurementTimeslotInfoHCR_PDU = -1;  /* UEMeasurementTimeslotInfoHCR */
static int hf_rnsap_UEMeasurementTimeslotInfoLCR_PDU = -1;  /* UEMeasurementTimeslotInfoLCR */
static int hf_rnsap_UEMeasurementTimeslotInfo768_PDU = -1;  /* UEMeasurementTimeslotInfo768 */
static int hf_rnsap_UEMeasurementType_PDU = -1;   /* UEMeasurementType */
static int hf_rnsap_UEMeasurementValueTransmittedPowerList768_PDU = -1;  /* UEMeasurementValueTransmittedPowerList768 */
static int hf_rnsap_UEMeasurementValueTimeslotISCPList768_PDU = -1;  /* UEMeasurementValueTimeslotISCPList768 */
static int hf_rnsap_UEMeasurementValueInformation_PDU = -1;  /* UEMeasurementValueInformation */
static int hf_rnsap_UE_State_PDU = -1;            /* UE_State */
static int hf_rnsap_UL_DPDCHIndicatorEDCH_PDU = -1;  /* UL_DPDCHIndicatorEDCH */
static int hf_rnsap_PLCCHinformation_PDU = -1;    /* PLCCHinformation */
static int hf_rnsap_UL_Timeslot_ISCP_Value_PDU = -1;  /* UL_Timeslot_ISCP_Value */
static int hf_rnsap_UL_Timeslot_ISCP_Value_IncrDecrThres_PDU = -1;  /* UL_Timeslot_ISCP_Value_IncrDecrThres */
static int hf_rnsap_UL_TimingAdvanceCtrl_LCR_PDU = -1;  /* UL_TimingAdvanceCtrl_LCR */
static int hf_rnsap_UL_SIR_PDU = -1;              /* UL_SIR */
static int hf_rnsap_UC_ID_PDU = -1;               /* UC_ID */
static int hf_rnsap_UL_Synchronisation_Parameters_LCR_PDU = -1;  /* UL_Synchronisation_Parameters_LCR */
static int hf_rnsap_UpPTSInterferenceValue_PDU = -1;  /* UpPTSInterferenceValue */
static int hf_rnsap_Unidirectional_DCH_Indicator_PDU = -1;  /* Unidirectional_DCH_Indicator */
static int hf_rnsap_URA_ID_PDU = -1;              /* URA_ID */
static int hf_rnsap_URA_Information_PDU = -1;     /* URA_Information */
static int hf_rnsap_USCH_Information_PDU = -1;    /* USCH_Information */
static int hf_rnsap_User_Plane_Congestion_Fields_Inclusion_PDU = -1;  /* User_Plane_Congestion_Fields_Inclusion */
static int hf_rnsap_RadioLinkSetupRequestFDD_PDU = -1;  /* RadioLinkSetupRequestFDD */
static int hf_rnsap_UL_DPCH_Information_RL_SetupRqstFDD_PDU = -1;  /* UL_DPCH_Information_RL_SetupRqstFDD */
static int hf_rnsap_DL_DPCH_Information_RL_SetupRqstFDD_PDU = -1;  /* DL_DPCH_Information_RL_SetupRqstFDD */
static int hf_rnsap_RL_InformationList_RL_SetupRqstFDD_PDU = -1;  /* RL_InformationList_RL_SetupRqstFDD */
static int hf_rnsap_RL_InformationItem_RL_SetupRqstFDD_PDU = -1;  /* RL_InformationItem_RL_SetupRqstFDD */
static int hf_rnsap_F_DPCH_Information_RL_SetupRqstFDD_PDU = -1;  /* F_DPCH_Information_RL_SetupRqstFDD */
static int hf_rnsap_RadioLinkSetupRequestTDD_PDU = -1;  /* RadioLinkSetupRequestTDD */
static int hf_rnsap_UL_Physical_Channel_Information_RL_SetupRqstTDD_PDU = -1;  /* UL_Physical_Channel_Information_RL_SetupRqstTDD */
static int hf_rnsap_DL_Physical_Channel_Information_RL_SetupRqstTDD_PDU = -1;  /* DL_Physical_Channel_Information_RL_SetupRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationList_RL_SetupRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationItem_RL_SetupRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationList_RL_SetupRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationItem_RL_SetupRqstTDD */
static int hf_rnsap_RL_Information_RL_SetupRqstTDD_PDU = -1;  /* RL_Information_RL_SetupRqstTDD */
static int hf_rnsap_RadioLinkSetupResponseFDD_PDU = -1;  /* RadioLinkSetupResponseFDD */
static int hf_rnsap_RL_InformationResponseList_RL_SetupRspFDD_PDU = -1;  /* RL_InformationResponseList_RL_SetupRspFDD */
static int hf_rnsap_RL_InformationResponseItem_RL_SetupRspFDD_PDU = -1;  /* RL_InformationResponseItem_RL_SetupRspFDD */
static int hf_rnsap_RadioLinkSetupResponseTDD_PDU = -1;  /* RadioLinkSetupResponseTDD */
static int hf_rnsap_RL_InformationResponse_RL_SetupRspTDD_PDU = -1;  /* RL_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD_PDU = -1;  /* UL_CCTrCHInformationListIE_RL_SetupRspTDD */
static int hf_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD_PDU = -1;  /* UL_DPCH_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD_PDU = -1;  /* DL_CCTrCHInformationListIE_RL_SetupRspTDD */
static int hf_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD_PDU = -1;  /* DL_DPCH_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD_PDU = -1;  /* DSCH_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_USCH_InformationListIEs_RL_SetupRspTDD_PDU = -1;  /* USCH_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_RL_LCR_InformationResponse_RL_SetupRspTDD_PDU = -1;  /* RL_LCR_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_UL_LCR_CCTrCHInformationListIE_RL_SetupRspTDD_PDU = -1;  /* UL_LCR_CCTrCHInformationListIE_RL_SetupRspTDD */
static int hf_rnsap_UL_DPCH_LCR_InformationItem_RL_SetupRspTDD_PDU = -1;  /* UL_DPCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD_PDU = -1;  /* DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD */
static int hf_rnsap_DL_DPCH_LCR_InformationItem_RL_SetupRspTDD_PDU = -1;  /* DL_DPCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_DSCH_LCR_InformationListIEs_RL_SetupRspTDD_PDU = -1;  /* DSCH_LCR_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_USCH_LCR_InformationListIEs_RL_SetupRspTDD_PDU = -1;  /* USCH_LCR_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_RL_InformationResponse_RL_SetupRspTDD768_PDU = -1;  /* RL_InformationResponse_RL_SetupRspTDD768 */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD768_PDU = -1;  /* UL_CCTrCHInformationListIE_RL_SetupRspTDD768 */
static int hf_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD768_PDU = -1;  /* UL_DPCH_InformationItem_RL_SetupRspTDD768 */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD768_PDU = -1;  /* DL_CCTrCHInformationListIE_RL_SetupRspTDD768 */
static int hf_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD768_PDU = -1;  /* DL_DPCH_InformationItem_RL_SetupRspTDD768 */
static int hf_rnsap_RadioLinkSetupFailureFDD_PDU = -1;  /* RadioLinkSetupFailureFDD */
static int hf_rnsap_CauseLevel_RL_SetupFailureFDD_PDU = -1;  /* CauseLevel_RL_SetupFailureFDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD_PDU = -1;  /* UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD */
static int hf_rnsap_SuccessfulRL_InformationResponse_RL_SetupFailureFDD_PDU = -1;  /* SuccessfulRL_InformationResponse_RL_SetupFailureFDD */
static int hf_rnsap_RadioLinkSetupFailureTDD_PDU = -1;  /* RadioLinkSetupFailureTDD */
static int hf_rnsap_CauseLevel_RL_SetupFailureTDD_PDU = -1;  /* CauseLevel_RL_SetupFailureTDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD_PDU = -1;  /* UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD */
static int hf_rnsap_RadioLinkAdditionRequestFDD_PDU = -1;  /* RadioLinkAdditionRequestFDD */
static int hf_rnsap_RL_InformationList_RL_AdditionRqstFDD_PDU = -1;  /* RL_InformationList_RL_AdditionRqstFDD */
static int hf_rnsap_RL_Information_RL_AdditionRqstFDD_PDU = -1;  /* RL_Information_RL_AdditionRqstFDD */
static int hf_rnsap_EDPCH_Information_RLAdditionReq_FDD_PDU = -1;  /* EDPCH_Information_RLAdditionReq_FDD */
static int hf_rnsap_RadioLinkAdditionRequestTDD_PDU = -1;  /* RadioLinkAdditionRequestTDD */
static int hf_rnsap_RL_Information_RL_AdditionRqstTDD_PDU = -1;  /* RL_Information_RL_AdditionRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationList_RL_AdditionRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationItem_RL_AdditionRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationItem_RL_AdditionRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationList_RL_AdditionRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationItem_RL_AdditionRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationItem_RL_AdditionRqstTDD */
static int hf_rnsap_RadioLinkAdditionResponseFDD_PDU = -1;  /* RadioLinkAdditionResponseFDD */
static int hf_rnsap_RL_InformationResponseList_RL_AdditionRspFDD_PDU = -1;  /* RL_InformationResponseList_RL_AdditionRspFDD */
static int hf_rnsap_RL_InformationResponseItem_RL_AdditionRspFDD_PDU = -1;  /* RL_InformationResponseItem_RL_AdditionRspFDD */
static int hf_rnsap_RadioLinkAdditionResponseTDD_PDU = -1;  /* RadioLinkAdditionResponseTDD */
static int hf_rnsap_RL_InformationResponse_RL_AdditionRspTDD_PDU = -1;  /* RL_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD_PDU = -1;  /* UL_CCTrCHInformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD_PDU = -1;  /* UL_DPCH_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD_PDU = -1;  /* DL_CCTrCHInformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD_PDU = -1;  /* DL_DPCH_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD_PDU = -1;  /* DSCH_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_USCH_InformationListIE_RL_AdditionRspTDD_PDU = -1;  /* USCH_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_RL_LCR_InformationResponse_RL_AdditionRspTDD_PDU = -1;  /* RL_LCR_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD_PDU = -1;  /* UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD_PDU = -1;  /* UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD_PDU = -1;  /* DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD_PDU = -1;  /* DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD_PDU = -1;  /* DSCH_LCR_InformationListIEs_RL_AdditionRspTDD */
static int hf_rnsap_USCH_LCR_InformationListIEs_RL_AdditionRspTDD_PDU = -1;  /* USCH_LCR_InformationListIEs_RL_AdditionRspTDD */
static int hf_rnsap_RL_InformationResponse_RL_AdditionRspTDD768_PDU = -1;  /* RL_InformationResponse_RL_AdditionRspTDD768 */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD768_PDU = -1;  /* UL_CCTrCHInformationListIE_RL_AdditionRspTDD768 */
static int hf_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD768_PDU = -1;  /* UL_DPCH_InformationItem_RL_AdditionRspTDD768 */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD768_PDU = -1;  /* DL_CCTrCHInformationListIE_RL_AdditionRspTDD768 */
static int hf_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD768_PDU = -1;  /* DL_DPCH_InformationItem_RL_AdditionRspTDD768 */
static int hf_rnsap_RadioLinkAdditionFailureFDD_PDU = -1;  /* RadioLinkAdditionFailureFDD */
static int hf_rnsap_CauseLevel_RL_AdditionFailureFDD_PDU = -1;  /* CauseLevel_RL_AdditionFailureFDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD_PDU = -1;  /* UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD */
static int hf_rnsap_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD_PDU = -1;  /* SuccessfulRL_InformationResponse_RL_AdditionFailureFDD */
static int hf_rnsap_RadioLinkAdditionFailureTDD_PDU = -1;  /* RadioLinkAdditionFailureTDD */
static int hf_rnsap_CauseLevel_RL_AdditionFailureTDD_PDU = -1;  /* CauseLevel_RL_AdditionFailureTDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD_PDU = -1;  /* UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD */
static int hf_rnsap_RadioLinkDeletionRequest_PDU = -1;  /* RadioLinkDeletionRequest */
static int hf_rnsap_RL_InformationList_RL_DeletionRqst_PDU = -1;  /* RL_InformationList_RL_DeletionRqst */
static int hf_rnsap_RL_Information_RL_DeletionRqst_PDU = -1;  /* RL_Information_RL_DeletionRqst */
static int hf_rnsap_RadioLinkDeletionResponse_PDU = -1;  /* RadioLinkDeletionResponse */
static int hf_rnsap_RadioLinkReconfigurationPrepareFDD_PDU = -1;  /* RadioLinkReconfigurationPrepareFDD */
static int hf_rnsap_UL_DPCH_Information_RL_ReconfPrepFDD_PDU = -1;  /* UL_DPCH_Information_RL_ReconfPrepFDD */
static int hf_rnsap_DL_DPCH_Information_RL_ReconfPrepFDD_PDU = -1;  /* DL_DPCH_Information_RL_ReconfPrepFDD */
static int hf_rnsap_DL_DPCH_Power_Information_RL_ReconfPrepFDD_PDU = -1;  /* DL_DPCH_Power_Information_RL_ReconfPrepFDD */
static int hf_rnsap_DCH_DeleteList_RL_ReconfPrepFDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfPrepFDD */
static int hf_rnsap_RL_InformationList_RL_ReconfPrepFDD_PDU = -1;  /* RL_InformationList_RL_ReconfPrepFDD */
static int hf_rnsap_RL_Information_RL_ReconfPrepFDD_PDU = -1;  /* RL_Information_RL_ReconfPrepFDD */
static int hf_rnsap_F_DPCH_Information_RL_ReconfPrepFDD_PDU = -1;  /* F_DPCH_Information_RL_ReconfPrepFDD */
static int hf_rnsap_RadioLinkReconfigurationPrepareTDD_PDU = -1;  /* RadioLinkReconfigurationPrepareTDD */
static int hf_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_rnsap_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_AddInformation_RL_ReconfPrepTDD */
static int hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD */
static int hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_DCH_DeleteList_RL_ReconfPrepTDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* DSCH_ModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD_PDU = -1;  /* DSCH_DeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_USCH_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* USCH_ModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_USCH_DeleteList_RL_ReconfPrepTDD_PDU = -1;  /* USCH_DeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_RL_Information_RL_ReconfPrepTDD_PDU = -1;  /* RL_Information_RL_ReconfPrepTDD */
static int hf_rnsap_RadioLinkReconfigurationReadyFDD_PDU = -1;  /* RadioLinkReconfigurationReadyFDD */
static int hf_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD_PDU = -1;  /* RL_InformationResponseList_RL_ReconfReadyFDD */
static int hf_rnsap_RL_InformationResponseItem_RL_ReconfReadyFDD_PDU = -1;  /* RL_InformationResponseItem_RL_ReconfReadyFDD */
static int hf_rnsap_RadioLinkReconfigurationReadyTDD_PDU = -1;  /* RadioLinkReconfigurationReadyTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_PDU = -1;  /* UL_CCTrCHInformationListIE_RL_ReconfReadyTDD */
static int hf_rnsap_UL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD_PDU = -1;  /* UL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD_PDU = -1;  /* UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD */
static int hf_rnsap_UL_DPCH_InformationAddList_RL_ReconfReadyTDD768_PDU = -1;  /* UL_DPCH_InformationAddList_RL_ReconfReadyTDD768 */
static int hf_rnsap_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD_PDU = -1;  /* UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD */
static int hf_rnsap_UL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD_PDU = -1;  /* UL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768_PDU = -1;  /* UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768 */
static int hf_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_PDU = -1;  /* UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_PDU = -1;  /* DL_CCTrCHInformationListIE_RL_ReconfReadyTDD */
static int hf_rnsap_DL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD_PDU = -1;  /* DL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD_PDU = -1;  /* DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD */
static int hf_rnsap_DL_DPCH_InformationAddList_RL_ReconfReadyTDD768_PDU = -1;  /* DL_DPCH_InformationAddList_RL_ReconfReadyTDD768 */
static int hf_rnsap_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD_PDU = -1;  /* DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD */
static int hf_rnsap_DL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD_PDU = -1;  /* DL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768_PDU = -1;  /* DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768 */
static int hf_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_PDU = -1;  /* DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD */
static int hf_rnsap_DL_DPCH_InformationDeleteList768_RL_ReconfReadyTDD_PDU = -1;  /* DL_DPCH_InformationDeleteList768_RL_ReconfReadyTDD */
static int hf_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_PDU = -1;  /* DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD */
static int hf_rnsap_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_PDU = -1;  /* USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD */
static int hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfReadyTDD_PDU = -1;  /* Multiple_RL_InformationResponse_RL_ReconfReadyTDD */
static int hf_rnsap_RadioLinkReconfigurationCommit_PDU = -1;  /* RadioLinkReconfigurationCommit */
static int hf_rnsap_RadioLinkReconfigurationFailure_PDU = -1;  /* RadioLinkReconfigurationFailure */
static int hf_rnsap_CauseLevel_RL_ReconfFailure_PDU = -1;  /* CauseLevel_RL_ReconfFailure */
static int hf_rnsap_RL_ReconfigurationFailure_RL_ReconfFail_PDU = -1;  /* RL_ReconfigurationFailure_RL_ReconfFail */
static int hf_rnsap_RadioLinkReconfigurationCancel_PDU = -1;  /* RadioLinkReconfigurationCancel */
static int hf_rnsap_RadioLinkReconfigurationRequestFDD_PDU = -1;  /* RadioLinkReconfigurationRequestFDD */
static int hf_rnsap_UL_DPCH_Information_RL_ReconfRqstFDD_PDU = -1;  /* UL_DPCH_Information_RL_ReconfRqstFDD */
static int hf_rnsap_DL_DPCH_Information_RL_ReconfRqstFDD_PDU = -1;  /* DL_DPCH_Information_RL_ReconfRqstFDD */
static int hf_rnsap_DCH_DeleteList_RL_ReconfRqstFDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfRqstFDD */
static int hf_rnsap_RL_ReconfigurationRequestFDD_RL_InformationList_PDU = -1;  /* RL_ReconfigurationRequestFDD_RL_InformationList */
static int hf_rnsap_RL_ReconfigurationRequestFDD_RL_Information_IEs_PDU = -1;  /* RL_ReconfigurationRequestFDD_RL_Information_IEs */
static int hf_rnsap_RadioLinkReconfigurationRequestTDD_PDU = -1;  /* RadioLinkReconfigurationRequestTDD */
static int hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD */
static int hf_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD */
static int hf_rnsap_DCH_DeleteList_RL_ReconfRqstTDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfRqstTDD */
static int hf_rnsap_Multiple_RL_ReconfigurationRequestTDD_RL_Information_PDU = -1;  /* Multiple_RL_ReconfigurationRequestTDD_RL_Information */
static int hf_rnsap_RadioLinkReconfigurationResponseFDD_PDU = -1;  /* RadioLinkReconfigurationResponseFDD */
static int hf_rnsap_RL_InformationResponseList_RL_ReconfRspFDD_PDU = -1;  /* RL_InformationResponseList_RL_ReconfRspFDD */
static int hf_rnsap_RL_InformationResponseItem_RL_ReconfRspFDD_PDU = -1;  /* RL_InformationResponseItem_RL_ReconfRspFDD */
static int hf_rnsap_RadioLinkReconfigurationResponseTDD_PDU = -1;  /* RadioLinkReconfigurationResponseTDD */
static int hf_rnsap_RL_InformationResponse_RL_ReconfRspTDD_PDU = -1;  /* RL_InformationResponse_RL_ReconfRspTDD */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_ReconfRspTDD_PDU = -1;  /* DL_CCTrCH_InformationList_RL_ReconfRspTDD */
static int hf_rnsap_DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD_PDU = -1;  /* DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD */
static int hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfRspTDD_PDU = -1;  /* Multiple_RL_InformationResponse_RL_ReconfRspTDD */
static int hf_rnsap_RadioLinkFailureIndication_PDU = -1;  /* RadioLinkFailureIndication */
static int hf_rnsap_Reporting_Object_RL_FailureInd_PDU = -1;  /* Reporting_Object_RL_FailureInd */
static int hf_rnsap_RL_Information_RL_FailureInd_PDU = -1;  /* RL_Information_RL_FailureInd */
static int hf_rnsap_RL_Set_Information_RL_FailureInd_PDU = -1;  /* RL_Set_Information_RL_FailureInd */
static int hf_rnsap_CCTrCH_InformationItem_RL_FailureInd_PDU = -1;  /* CCTrCH_InformationItem_RL_FailureInd */
static int hf_rnsap_RadioLinkPreemptionRequiredIndication_PDU = -1;  /* RadioLinkPreemptionRequiredIndication */
static int hf_rnsap_RL_InformationList_RL_PreemptRequiredInd_PDU = -1;  /* RL_InformationList_RL_PreemptRequiredInd */
static int hf_rnsap_RL_InformationItem_RL_PreemptRequiredInd_PDU = -1;  /* RL_InformationItem_RL_PreemptRequiredInd */
static int hf_rnsap_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd_PDU = -1;  /* HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd */
static int hf_rnsap_HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd_PDU = -1;  /* HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd_PDU = -1;  /* EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd_PDU = -1;  /* EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd */
static int hf_rnsap_RadioLinkRestoreIndication_PDU = -1;  /* RadioLinkRestoreIndication */
static int hf_rnsap_Reporting_Object_RL_RestoreInd_PDU = -1;  /* Reporting_Object_RL_RestoreInd */
static int hf_rnsap_RL_Information_RL_RestoreInd_PDU = -1;  /* RL_Information_RL_RestoreInd */
static int hf_rnsap_RL_Set_Information_RL_RestoreInd_PDU = -1;  /* RL_Set_Information_RL_RestoreInd */
static int hf_rnsap_CCTrCH_InformationItem_RL_RestoreInd_PDU = -1;  /* CCTrCH_InformationItem_RL_RestoreInd */
static int hf_rnsap_DL_PowerControlRequest_PDU = -1;  /* DL_PowerControlRequest */
static int hf_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst_PDU = -1;  /* DL_ReferencePowerInformationList_DL_PC_Rqst */
static int hf_rnsap_DL_ReferencePowerInformation_DL_PC_Rqst_PDU = -1;  /* DL_ReferencePowerInformation_DL_PC_Rqst */
static int hf_rnsap_DL_PowerTimeslotControlRequest_PDU = -1;  /* DL_PowerTimeslotControlRequest */
static int hf_rnsap_PhysicalChannelReconfigurationRequestFDD_PDU = -1;  /* PhysicalChannelReconfigurationRequestFDD */
static int hf_rnsap_RL_Information_PhyChReconfRqstFDD_PDU = -1;  /* RL_Information_PhyChReconfRqstFDD */
static int hf_rnsap_PhysicalChannelReconfigurationRequestTDD_PDU = -1;  /* PhysicalChannelReconfigurationRequestTDD */
static int hf_rnsap_RL_Information_PhyChReconfRqstTDD_PDU = -1;  /* RL_Information_PhyChReconfRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD */
static int hf_rnsap_UL_DPCH_InformationItem_PhyChReconfRqstTDD_PDU = -1;  /* UL_DPCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_UL_TimeslotLCR_InformationList_PhyChReconfRqstTDD_PDU = -1;  /* UL_TimeslotLCR_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD768_PDU = -1;  /* UL_Timeslot_InformationList_PhyChReconfRqstTDD768 */
static int hf_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD */
static int hf_rnsap_DL_DPCH_InformationItem_PhyChReconfRqstTDD_PDU = -1;  /* DL_DPCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_DL_TimeslotLCR_InformationList_PhyChReconfRqstTDD_PDU = -1;  /* DL_TimeslotLCR_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD768_PDU = -1;  /* DL_Timeslot_InformationList_PhyChReconfRqstTDD768 */
static int hf_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD_PDU = -1;  /* HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD_PDU = -1;  /* HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD */
static int hf_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD768_PDU = -1;  /* HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD768 */
static int hf_rnsap_PhysicalChannelReconfigurationCommand_PDU = -1;  /* PhysicalChannelReconfigurationCommand */
static int hf_rnsap_PhysicalChannelReconfigurationFailure_PDU = -1;  /* PhysicalChannelReconfigurationFailure */
static int hf_rnsap_RadioLinkCongestionIndication_PDU = -1;  /* RadioLinkCongestionIndication */
static int hf_rnsap_RL_InformationList_RL_CongestInd_PDU = -1;  /* RL_InformationList_RL_CongestInd */
static int hf_rnsap_RL_InformationItem_RL_CongestInd_PDU = -1;  /* RL_InformationItem_RL_CongestInd */
static int hf_rnsap_DCH_Rate_InformationItem_RL_CongestInd_PDU = -1;  /* DCH_Rate_InformationItem_RL_CongestInd */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_CongestInd_PDU = -1;  /* EDCH_MacdFlowSpecificInformationList_RL_CongestInd */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationItem_RL_CongestInd_PDU = -1;  /* EDCH_MacdFlowSpecificInformationItem_RL_CongestInd */
static int hf_rnsap_UplinkSignallingTransferIndicationFDD_PDU = -1;  /* UplinkSignallingTransferIndicationFDD */
static int hf_rnsap_UplinkSignallingTransferIndicationTDD_PDU = -1;  /* UplinkSignallingTransferIndicationTDD */
static int hf_rnsap_DownlinkSignallingTransferRequest_PDU = -1;  /* DownlinkSignallingTransferRequest */
static int hf_rnsap_RelocationCommit_PDU = -1;    /* RelocationCommit */
static int hf_rnsap_PagingRequest_PDU = -1;       /* PagingRequest */
static int hf_rnsap_PagingArea_PagingRqst_PDU = -1;  /* PagingArea_PagingRqst */
static int hf_rnsap_CNOriginatedPage_PagingRqst_PDU = -1;  /* CNOriginatedPage_PagingRqst */
static int hf_rnsap_DedicatedMeasurementInitiationRequest_PDU = -1;  /* DedicatedMeasurementInitiationRequest */
static int hf_rnsap_DedicatedMeasurementObjectType_DM_Rqst_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Rqst */
static int hf_rnsap_RL_InformationItem_DM_Rqst_PDU = -1;  /* RL_InformationItem_DM_Rqst */
static int hf_rnsap_HSSICH_Info_DM_Rqst_PDU = -1;  /* HSSICH_Info_DM_Rqst */
static int hf_rnsap_RL_Set_InformationItem_DM_Rqst_PDU = -1;  /* RL_Set_InformationItem_DM_Rqst */
static int hf_rnsap_DedicatedMeasurementInitiationResponse_PDU = -1;  /* DedicatedMeasurementInitiationResponse */
static int hf_rnsap_DedicatedMeasurementObjectType_DM_Rsp_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Rsp */
static int hf_rnsap_RL_InformationItem_DM_Rsp_PDU = -1;  /* RL_InformationItem_DM_Rsp */
static int hf_rnsap_RL_Set_InformationItem_DM_Rsp_PDU = -1;  /* RL_Set_InformationItem_DM_Rsp */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp_PDU = -1;  /* Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp_PDU = -1;  /* Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp */
static int hf_rnsap_Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp_PDU = -1;  /* Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_TDD768_DM_Rsp_PDU = -1;  /* Multiple_DedicatedMeasurementValueList_TDD768_DM_Rsp */
static int hf_rnsap_DedicatedMeasurementInitiationFailure_PDU = -1;  /* DedicatedMeasurementInitiationFailure */
static int hf_rnsap_DedicatedMeasurementObjectType_DM_Fail_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Fail */
static int hf_rnsap_RL_Unsuccessful_InformationItem_DM_Fail_PDU = -1;  /* RL_Unsuccessful_InformationItem_DM_Fail */
static int hf_rnsap_RL_Successful_InformationItem_DM_Fail_PDU = -1;  /* RL_Successful_InformationItem_DM_Fail */
static int hf_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail_PDU = -1;  /* RL_Set_Unsuccessful_InformationItem_DM_Fail */
static int hf_rnsap_RL_Set_Successful_InformationItem_DM_Fail_PDU = -1;  /* RL_Set_Successful_InformationItem_DM_Fail */
static int hf_rnsap_DedicatedMeasurementReport_PDU = -1;  /* DedicatedMeasurementReport */
static int hf_rnsap_DedicatedMeasurementObjectType_DM_Rprt_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Rprt */
static int hf_rnsap_RL_InformationItem_DM_Rprt_PDU = -1;  /* RL_InformationItem_DM_Rprt */
static int hf_rnsap_RL_Set_InformationItem_DM_Rprt_PDU = -1;  /* RL_Set_InformationItem_DM_Rprt */
static int hf_rnsap_DedicatedMeasurementTerminationRequest_PDU = -1;  /* DedicatedMeasurementTerminationRequest */
static int hf_rnsap_DedicatedMeasurementFailureIndication_PDU = -1;  /* DedicatedMeasurementFailureIndication */
static int hf_rnsap_DedicatedMeasurementObjectType_DM_Fail_Ind_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Fail_Ind */
static int hf_rnsap_RL_Unsuccessful_InformationItem_DM_Fail_Ind_PDU = -1;  /* RL_Unsuccessful_InformationItem_DM_Fail_Ind */
static int hf_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind_PDU = -1;  /* RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind */
static int hf_rnsap_CommonTransportChannelResourcesReleaseRequest_PDU = -1;  /* CommonTransportChannelResourcesReleaseRequest */
static int hf_rnsap_CommonTransportChannelResourcesRequest_PDU = -1;  /* CommonTransportChannelResourcesRequest */
static int hf_rnsap_CommonTransportChannelResourcesResponseFDD_PDU = -1;  /* CommonTransportChannelResourcesResponseFDD */
static int hf_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD_PDU = -1;  /* FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD */
static int hf_rnsap_CommonTransportChannelResourcesResponseTDD_PDU = -1;  /* CommonTransportChannelResourcesResponseTDD */
static int hf_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD_PDU = -1;  /* FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD */
static int hf_rnsap_CommonTransportChannelResourcesFailure_PDU = -1;  /* CommonTransportChannelResourcesFailure */
static int hf_rnsap_CompressedModeCommand_PDU = -1;  /* CompressedModeCommand */
static int hf_rnsap_ErrorIndication_PDU = -1;     /* ErrorIndication */
static int hf_rnsap_CommonMeasurementInitiationRequest_PDU = -1;  /* CommonMeasurementInitiationRequest */
static int hf_rnsap_CommonMeasurementObjectType_CM_Rqst_PDU = -1;  /* CommonMeasurementObjectType_CM_Rqst */
static int hf_rnsap_CommonMeasurementInitiationResponse_PDU = -1;  /* CommonMeasurementInitiationResponse */
static int hf_rnsap_CommonMeasurementObjectType_CM_Rsp_PDU = -1;  /* CommonMeasurementObjectType_CM_Rsp */
static int hf_rnsap_CommonMeasurementInitiationFailure_PDU = -1;  /* CommonMeasurementInitiationFailure */
static int hf_rnsap_CommonMeasurementReport_PDU = -1;  /* CommonMeasurementReport */
static int hf_rnsap_CommonMeasurementObjectType_CM_Rprt_PDU = -1;  /* CommonMeasurementObjectType_CM_Rprt */
static int hf_rnsap_CommonMeasurementTerminationRequest_PDU = -1;  /* CommonMeasurementTerminationRequest */
static int hf_rnsap_CommonMeasurementFailureIndication_PDU = -1;  /* CommonMeasurementFailureIndication */
static int hf_rnsap_InformationExchangeInitiationRequest_PDU = -1;  /* InformationExchangeInitiationRequest */
static int hf_rnsap_InformationExchangeObjectType_InfEx_Rqst_PDU = -1;  /* InformationExchangeObjectType_InfEx_Rqst */
static int hf_rnsap_GSM_Cell_InfEx_Rqst_PDU = -1;  /* GSM_Cell_InfEx_Rqst */
static int hf_rnsap_InformationExchangeInitiationResponse_PDU = -1;  /* InformationExchangeInitiationResponse */
static int hf_rnsap_InformationExchangeObjectType_InfEx_Rsp_PDU = -1;  /* InformationExchangeObjectType_InfEx_Rsp */
static int hf_rnsap_MBMS_Bearer_Service_List_InfEx_Rsp_PDU = -1;  /* MBMS_Bearer_Service_List_InfEx_Rsp */
static int hf_rnsap_InformationExchangeInitiationFailure_PDU = -1;  /* InformationExchangeInitiationFailure */
static int hf_rnsap_InformationReport_PDU = -1;   /* InformationReport */
static int hf_rnsap_InformationExchangeObjectType_InfEx_Rprt_PDU = -1;  /* InformationExchangeObjectType_InfEx_Rprt */
static int hf_rnsap_InformationExchangeTerminationRequest_PDU = -1;  /* InformationExchangeTerminationRequest */
static int hf_rnsap_InformationExchangeFailureIndication_PDU = -1;  /* InformationExchangeFailureIndication */
static int hf_rnsap_ResetRequest_PDU = -1;        /* ResetRequest */
static int hf_rnsap_ResetIndicator_PDU = -1;      /* ResetIndicator */
static int hf_rnsap_ContextInfoItem_Reset_PDU = -1;  /* ContextInfoItem_Reset */
static int hf_rnsap_ContextGroupInfoItem_Reset_PDU = -1;  /* ContextGroupInfoItem_Reset */
static int hf_rnsap_ResetResponse_PDU = -1;       /* ResetResponse */
static int hf_rnsap_RadioLinkActivationCommandFDD_PDU = -1;  /* RadioLinkActivationCommandFDD */
static int hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdFDD_PDU = -1;  /* DelayedActivationInformationList_RL_ActivationCmdFDD */
static int hf_rnsap_DelayedActivationInformation_RL_ActivationCmdFDD_PDU = -1;  /* DelayedActivationInformation_RL_ActivationCmdFDD */
static int hf_rnsap_RadioLinkActivationCommandTDD_PDU = -1;  /* RadioLinkActivationCommandTDD */
static int hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdTDD_PDU = -1;  /* DelayedActivationInformationList_RL_ActivationCmdTDD */
static int hf_rnsap_DelayedActivationInformation_RL_ActivationCmdTDD_PDU = -1;  /* DelayedActivationInformation_RL_ActivationCmdTDD */
static int hf_rnsap_GERANUplinkSignallingTransferIndication_PDU = -1;  /* GERANUplinkSignallingTransferIndication */
static int hf_rnsap_RadioLinkParameterUpdateIndicationFDD_PDU = -1;  /* RadioLinkParameterUpdateIndicationFDD */
static int hf_rnsap_RL_ParameterUpdateIndicationFDD_RL_InformationList_PDU = -1;  /* RL_ParameterUpdateIndicationFDD_RL_InformationList */
static int hf_rnsap_RL_ParameterUpdateIndicationFDD_RL_Information_Item_PDU = -1;  /* RL_ParameterUpdateIndicationFDD_RL_Information_Item */
static int hf_rnsap_RadioLinkParameterUpdateIndicationTDD_PDU = -1;  /* RadioLinkParameterUpdateIndicationTDD */
static int hf_rnsap_UEMeasurementInitiationRequest_PDU = -1;  /* UEMeasurementInitiationRequest */
static int hf_rnsap_UEMeasurementInitiationResponse_PDU = -1;  /* UEMeasurementInitiationResponse */
static int hf_rnsap_UEMeasurementInitiationFailure_PDU = -1;  /* UEMeasurementInitiationFailure */
static int hf_rnsap_UEMeasurementReport_PDU = -1;  /* UEMeasurementReport */
static int hf_rnsap_UEMeasurementTerminationRequest_PDU = -1;  /* UEMeasurementTerminationRequest */
static int hf_rnsap_UEMeasurementFailureIndication_PDU = -1;  /* UEMeasurementFailureIndication */
static int hf_rnsap_IurInvokeTrace_PDU = -1;      /* IurInvokeTrace */
static int hf_rnsap_ListOfInterfacesToTrace_PDU = -1;  /* ListOfInterfacesToTrace */
static int hf_rnsap_InterfacesToTraceItem_PDU = -1;  /* InterfacesToTraceItem */
static int hf_rnsap_IurDeactivateTrace_PDU = -1;  /* IurDeactivateTrace */
static int hf_rnsap_MBMSAttachCommand_PDU = -1;   /* MBMSAttachCommand */
static int hf_rnsap_MBMSDetachCommand_PDU = -1;   /* MBMSDetachCommand */
static int hf_rnsap_DirectInformationTransfer_PDU = -1;  /* DirectInformationTransfer */
static int hf_rnsap_PrivateMessage_PDU = -1;      /* PrivateMessage */
static int hf_rnsap_RNSAP_PDU_PDU = -1;           /* RNSAP_PDU */
static int hf_rnsap_local = -1;                   /* INTEGER_0_maxPrivateIEs */
static int hf_rnsap_global = -1;                  /* OBJECT_IDENTIFIER */
static int hf_rnsap_procedureCode = -1;           /* ProcedureCode */
static int hf_rnsap_ddMode = -1;                  /* DdMode */
static int hf_rnsap_shortTransActionId = -1;      /* INTEGER_0_127 */
static int hf_rnsap_longTransActionId = -1;       /* INTEGER_0_32767 */
static int hf_rnsap_ProtocolIE_Container_item = -1;  /* ProtocolIE_Field */
static int hf_rnsap_id = -1;                      /* ProtocolIE_ID */
static int hf_rnsap_criticality = -1;             /* Criticality */
static int hf_rnsap_value = -1;                   /* ProtocolIE_Field_value */
static int hf_rnsap_ProtocolExtensionContainer_item = -1;  /* ProtocolExtensionField */
static int hf_rnsap_extensionValue = -1;          /* T_extensionValue */
static int hf_rnsap_PrivateIE_Container_item = -1;  /* PrivateIE_Field */
static int hf_rnsap_id_01 = -1;                   /* PrivateIE_ID */
static int hf_rnsap_value_01 = -1;                /* PrivateIE_Field_value */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_item = -1;  /* MBMS_Bearer_ServiceItemFDD */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL_item = -1;  /* MBMS_Bearer_ServiceItemFDD_PFL */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_item = -1;  /* MBMS_Bearer_ServiceItemTDD */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL_item = -1;  /* MBMS_Bearer_ServiceItemTDD_PFL */
static int hf_rnsap_cMConfigurationChangeCFN = -1;  /* CFN */
static int hf_rnsap_transmission_Gap_Pattern_Sequence_Status = -1;  /* Transmission_Gap_Pattern_Sequence_Status_List */
static int hf_rnsap_iE_Extensions = -1;           /* ProtocolExtensionContainer */
static int hf_rnsap_AdditionalPreferredFrequency_item = -1;  /* AdditionalPreferredFrequencyItem */
static int hf_rnsap_dL_UARFCN = -1;               /* UARFCN */
static int hf_rnsap_correspondingCells = -1;      /* CorrespondingCells */
static int hf_rnsap_AffectedUEInformationForMBMS_item = -1;  /* S_RNTI */
static int hf_rnsap_priorityLevel = -1;           /* PriorityLevel */
static int hf_rnsap_pre_emptionCapability = -1;   /* Pre_emptionCapability */
static int hf_rnsap_pre_emptionVulnerability = -1;  /* Pre_emptionVulnerability */
static int hf_rnsap_allowed_UL_Rate = -1;         /* Allowed_Rate */
static int hf_rnsap_allowed_DL_Rate = -1;         /* Allowed_Rate */
static int hf_rnsap_aOA_LCR = -1;                 /* AOA_LCR */
static int hf_rnsap_aOA_LCR_Accuracy_Class = -1;  /* AOA_LCR_Accuracy_Class */
static int hf_rnsap_badSatelliteInformation = -1;  /* T_badSatelliteInformation */
static int hf_rnsap_badSatelliteInformation_item = -1;  /* T_badSatelliteInformation_item */
static int hf_rnsap_badSAT_ID = -1;               /* SAT_ID */
static int hf_rnsap_nCC = -1;                     /* NCC */
static int hf_rnsap_bCC = -1;                     /* BCC */
static int hf_rnsap_burstStart = -1;              /* INTEGER_0_15 */
static int hf_rnsap_burstLength = -1;             /* INTEGER_10_25 */
static int hf_rnsap_burstFreq = -1;               /* INTEGER_1_16 */
static int hf_rnsap_radioNetwork = -1;            /* CauseRadioNetwork */
static int hf_rnsap_transport = -1;               /* CauseTransport */
static int hf_rnsap_protocol = -1;                /* CauseProtocol */
static int hf_rnsap_misc = -1;                    /* CauseMisc */
static int hf_rnsap_uplinkCellCapacityClassValue = -1;  /* INTEGER_1_100_ */
static int hf_rnsap_downlinkCellCapacityClassValue = -1;  /* INTEGER_1_100_ */
static int hf_rnsap_lAI = -1;                     /* T_lAI */
static int hf_rnsap_pLMN_Identity = -1;           /* PLMN_Identity */
static int hf_rnsap_lAC = -1;                     /* LAC */
static int hf_rnsap_cI = -1;                      /* CI */
static int hf_rnsap_tUTRANGPSMeasurementAccuracyClass = -1;  /* TUTRANGPSAccuracyClass */
static int hf_rnsap_tUTRANGANSSMeasurementAccuracyClass = -1;  /* TUTRANGANSSAccuracyClass */
static int hf_rnsap_tUTRANGPSMeasurementValueInformation = -1;  /* TUTRANGPSMeasurementValueInformation */
static int hf_rnsap_sFNSFNMeasurementValueInformation = -1;  /* SFNSFNMeasurementValueInformation */
static int hf_rnsap_loadValue = -1;               /* LoadValue */
static int hf_rnsap_transmittedCarrierPowerValue = -1;  /* INTEGER_0_100 */
static int hf_rnsap_receivedTotalWideBandPowerValue = -1;  /* INTEGER_0_621 */
static int hf_rnsap_uplinkTimeslotISCPValue = -1;  /* UL_TimeslotISCP */
static int hf_rnsap_extension_CommonMeasurementValue = -1;  /* Extension_CommonMeasurementValue */
static int hf_rnsap_tUTRANGANSSMeasurementValueInformation = -1;  /* TUTRANGANSSMeasurementValueInformation */
static int hf_rnsap_measurementAvailable = -1;    /* CommonMeasurementAvailable */
static int hf_rnsap_measurementnotAvailable = -1;  /* NULL */
static int hf_rnsap_commonMeasurementValue = -1;  /* CommonMeasurementValue */
static int hf_rnsap_uE_DTX_DRX_Offset = -1;       /* UE_DTX_DRX_Offset */
static int hf_rnsap_enabling_Delay = -1;          /* Enabling_Delay */
static int hf_rnsap_dTX_Information = -1;         /* DTX_Information */
static int hf_rnsap_dRX_Information = -1;         /* DRX_Information */
static int hf_rnsap_cPC_DPCCH_Slot_Format = -1;   /* CPC_DPCCH_Slot_Format */
static int hf_rnsap_dTX_Information_to_Modify = -1;  /* DTX_Information_to_Modify */
static int hf_rnsap_dRX_Information_to_Modify = -1;  /* DRX_Information_to_Modify */
static int hf_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_item = -1;  /* Continuous_Packet_Connectivity_HS_SCCH_Less_InformationItem */
static int hf_rnsap_transport_Block_Size_Index = -1;  /* Transport_Block_Size_Index */
static int hf_rnsap_hSPDSCH_Second_Code_Support = -1;  /* HSPDSCH_Second_Code_Support */
static int hf_rnsap_hSPDSCH_First_Code_Index = -1;  /* HSPDSCH_First_Code_Index */
static int hf_rnsap_hSPDSCH_Second_Code_Index = -1;  /* HSPDSCH_Second_Code_Index */
static int hf_rnsap_CorrespondingCells_item = -1;  /* C_ID */
static int hf_rnsap_continuous_Packet_Connectivity_DTX_DRX_Information = -1;  /* Continuous_Packet_Connectivity_DTX_DRX_Information */
static int hf_rnsap_continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify = -1;  /* Continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify */
static int hf_rnsap_continuous_Packet_Connectivity_HS_SCCH_Less_Information = -1;  /* Continuous_Packet_Connectivity_HS_SCCH_Less_Information */
static int hf_rnsap_procedureID = -1;             /* ProcedureID */
static int hf_rnsap_triggeringMessage = -1;       /* TriggeringMessage */
static int hf_rnsap_procedureCriticality = -1;    /* Criticality */
static int hf_rnsap_transactionID = -1;           /* TransactionID */
static int hf_rnsap_iEsCriticalityDiagnostics = -1;  /* CriticalityDiagnostics_IE_List */
static int hf_rnsap_CriticalityDiagnostics_IE_List_item = -1;  /* CriticalityDiagnostics_IE_List_item */
static int hf_rnsap_iECriticality = -1;           /* Criticality */
static int hf_rnsap_iE_ID = -1;                   /* ProtocolIE_ID */
static int hf_rnsap_repetitionNumber = -1;        /* RepetitionNumber0 */
static int hf_rnsap_MessageStructure_item = -1;   /* MessageStructure_item */
static int hf_rnsap_repetitionNumber_01 = -1;     /* RepetitionNumber1 */
static int hf_rnsap_rAC = -1;                     /* RAC */
static int hf_rnsap_DCH_FDD_Information_item = -1;  /* DCH_FDD_InformationItem */
static int hf_rnsap_payloadCRC_PresenceIndicator = -1;  /* PayloadCRC_PresenceIndicator */
static int hf_rnsap_ul_FP_Mode = -1;              /* UL_FP_Mode */
static int hf_rnsap_toAWS = -1;                   /* ToAWS */
static int hf_rnsap_toAWE = -1;                   /* ToAWE */
static int hf_rnsap_dCH_SpecificInformationList = -1;  /* DCH_Specific_FDD_InformationList */
static int hf_rnsap_DCH_Specific_FDD_InformationList_item = -1;  /* DCH_Specific_FDD_Item */
static int hf_rnsap_dCH_ID = -1;                  /* DCH_ID */
static int hf_rnsap_trCH_SrcStatisticsDescr = -1;  /* TrCH_SrcStatisticsDescr */
static int hf_rnsap_ul_transportFormatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_dl_transportFormatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_ul_BLER = -1;                 /* BLER */
static int hf_rnsap_dl_BLER = -1;                 /* BLER */
static int hf_rnsap_allocationRetentionPriority = -1;  /* AllocationRetentionPriority */
static int hf_rnsap_frameHandlingPriority = -1;   /* FrameHandlingPriority */
static int hf_rnsap_qE_Selector = -1;             /* QE_Selector */
static int hf_rnsap_dRACControl = -1;             /* DRACControl */
static int hf_rnsap_DCH_InformationResponse_item = -1;  /* DCH_InformationResponseItem */
static int hf_rnsap_bindingID = -1;               /* BindingID */
static int hf_rnsap_transportLayerAddress = -1;   /* TransportLayerAddress */
static int hf_rnsap_DCH_TDD_Information_item = -1;  /* DCH_TDD_InformationItem */
static int hf_rnsap_dCH_SpecificInformationList_01 = -1;  /* DCH_Specific_TDD_InformationList */
static int hf_rnsap_DCH_Specific_TDD_InformationList_item = -1;  /* DCH_Specific_TDD_Item */
static int hf_rnsap_ul_cCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_dl_cCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_sIR_Value = -1;               /* SIR_Value */
static int hf_rnsap_sIR_ErrorValue = -1;          /* SIR_Error_Value */
static int hf_rnsap_transmittedCodePowerValue = -1;  /* Transmitted_Code_Power_Value */
static int hf_rnsap_rSCP = -1;                    /* RSCP_Value */
static int hf_rnsap_rxTimingDeviationValue = -1;  /* Rx_Timing_Deviation_Value */
static int hf_rnsap_roundTripTime = -1;           /* Round_Trip_Time_Value */
static int hf_rnsap_extension_DedicatedMeasurementValue = -1;  /* Extension_DedicatedMeasurementValue */
static int hf_rnsap_measurementAvailable_01 = -1;  /* DedicatedMeasurementAvailable */
static int hf_rnsap_measurementnotAvailable_01 = -1;  /* DedicatedMeasurementnotAvailable */
static int hf_rnsap_dedicatedmeasurementValue = -1;  /* DedicatedMeasurementValue */
static int hf_rnsap_cFN = -1;                     /* CFN */
static int hf_rnsap_ie_Extensions = -1;           /* ProtocolExtensionContainer */
static int hf_rnsap_cfn = -1;                     /* CFN */
static int hf_rnsap_separate_indication = -1;     /* NULL */
static int hf_rnsap_activate = -1;                /* Activate_Info */
static int hf_rnsap_deactivate = -1;              /* Deactivate_Info */
static int hf_rnsap_activation_type = -1;         /* Execution_Type */
static int hf_rnsap_initial_dl_tx_power = -1;     /* DL_Power */
static int hf_rnsap_firstRLS_Indicator = -1;      /* FirstRLS_Indicator */
static int hf_rnsap_propagation_delay = -1;       /* PropagationDelay */
static int hf_rnsap_deactivation_type = -1;       /* Execution_Type */
static int hf_rnsap_synchronised = -1;            /* CFN */
static int hf_rnsap_unsynchronised = -1;          /* NULL */
static int hf_rnsap_dGANSS_ReferenceTime = -1;    /* INTEGER_0_119 */
static int hf_rnsap_dGANSS_Information = -1;      /* T_dGANSS_Information */
static int hf_rnsap_dGANSS_Information_item = -1;  /* T_dGANSS_Information_item */
static int hf_rnsap_gANSS_SignalId = -1;          /* INTEGER_0_3_ */
static int hf_rnsap_gANSS_StatusHealth = -1;      /* GANSS_StatusHealth */
static int hf_rnsap_dGANSS_SignalInformation = -1;  /* T_dGANSS_SignalInformation */
static int hf_rnsap_dGANSS_SignalInformation_item = -1;  /* T_dGANSS_SignalInformation_item */
static int hf_rnsap_satId = -1;                   /* INTEGER_0_63 */
static int hf_rnsap_gANSS_iod = -1;               /* BIT_STRING_SIZE_10 */
static int hf_rnsap_udre = -1;                    /* UDRE */
static int hf_rnsap_ganss_prc = -1;               /* INTEGER_M2047_2047 */
static int hf_rnsap_ganss_rrc = -1;               /* INTEGER_M127_127 */
static int hf_rnsap_pRCDeviation = -1;            /* PRCDeviation */
static int hf_rnsap_gPSTOW = -1;                  /* GPSTOW */
static int hf_rnsap_gPS_Status_Health = -1;       /* GPS_Status_Health */
static int hf_rnsap_satellite_DGPSCorrections_Information = -1;  /* T_satellite_DGPSCorrections_Information */
static int hf_rnsap_satellite_DGPSCorrections_Information_item = -1;  /* T_satellite_DGPSCorrections_Information_item */
static int hf_rnsap_sAT_ID = -1;                  /* SAT_ID */
static int hf_rnsap_iode_dgps = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rnsap_uDRE = -1;                    /* UDRE */
static int hf_rnsap_pRC = -1;                     /* PRC */
static int hf_rnsap_range_Correction_Rate = -1;   /* Range_Correction_Rate */
static int hf_rnsap_powerAdjustmentType = -1;     /* PowerAdjustmentType */
static int hf_rnsap_dLReferencePower = -1;        /* DL_Power */
static int hf_rnsap_dLReferencePowerList = -1;    /* DL_ReferencePowerInformationList */
static int hf_rnsap_maxAdjustmentStep = -1;       /* MaxAdjustmentStep */
static int hf_rnsap_adjustmentPeriod = -1;        /* AdjustmentPeriod */
static int hf_rnsap_adjustmentRatio = -1;         /* ScaledAdjustmentRatio */
static int hf_rnsap_DL_ReferencePowerInformationList_item = -1;  /* DL_ReferencePowerInformationItem */
static int hf_rnsap_rL_ID = -1;                   /* RL_ID */
static int hf_rnsap_dl_Reference_Power = -1;      /* DL_Power */
static int hf_rnsap_common_DL_ReferencePowerInformation = -1;  /* DL_Power */
static int hf_rnsap_individual_DL_ReferencePowerInformation = -1;  /* DL_ReferencePowerInformationList */
static int hf_rnsap_DL_Timeslot_Information_item = -1;  /* DL_Timeslot_InformationItem */
static int hf_rnsap_timeSlot = -1;                /* TimeSlot */
static int hf_rnsap_midambleShiftAndBurstType = -1;  /* MidambleShiftAndBurstType */
static int hf_rnsap_tFCI_Presence = -1;           /* TFCI_Presence */
static int hf_rnsap_dL_Code_Information = -1;     /* TDD_DL_Code_Information */
static int hf_rnsap_DL_TimeslotLCR_Information_item = -1;  /* DL_TimeslotLCR_InformationItem */
static int hf_rnsap_timeSlotLCR = -1;             /* TimeSlotLCR */
static int hf_rnsap_midambleShiftLCR = -1;        /* MidambleShiftLCR */
static int hf_rnsap_dL_Code_LCR_Information = -1;  /* TDD_DL_Code_LCR_Information */
static int hf_rnsap_DL_Timeslot_Information768_item = -1;  /* DL_Timeslot_InformationItem768 */
static int hf_rnsap_midambleShiftAndBurstType768 = -1;  /* MidambleShiftAndBurstType768 */
static int hf_rnsap_dL_Code_Information768 = -1;  /* TDD_DL_Code_Information768 */
static int hf_rnsap_DL_TimeSlot_ISCP_Info_item = -1;  /* DL_TimeSlot_ISCP_InfoItem */
static int hf_rnsap_dL_TimeslotISCP = -1;         /* DL_TimeslotISCP */
static int hf_rnsap_DL_TimeSlot_ISCP_LCR_Information_item = -1;  /* DL_TimeSlot_ISCP_LCR_InfoItem */
static int hf_rnsap_uE_DRX_Cycle = -1;            /* UE_DRX_Cycle */
static int hf_rnsap_inactivity_Threshold_for_UE_DRX_Cycle = -1;  /* Inactivity_Threshold_for_UE_DRX_Cycle */
static int hf_rnsap_inactivity_Threshold_for_UE_Grant_Monitoring = -1;  /* Inactivity_Threshold_for_UE_Grant_Monitoring */
static int hf_rnsap_uE_DRX_Grant_Monitoring = -1;  /* UE_DRX_Grant_Monitoring */
static int hf_rnsap_modify = -1;                  /* DRX_Information_to_Modify_Items */
static int hf_rnsap_deactivate_01 = -1;           /* NULL */
static int hf_rnsap_DSCH_FlowControlInformation_item = -1;  /* DSCH_FlowControlItem */
static int hf_rnsap_dSCH_SchedulingPriority = -1;  /* SchedulingPriorityIndicator */
static int hf_rnsap_mAC_c_sh_SDU_Lengths = -1;    /* MAC_c_sh_SDU_LengthList */
static int hf_rnsap_DSCH_TDD_Information_item = -1;  /* DSCH_TDD_InformationItem */
static int hf_rnsap_dSCH_ID = -1;                 /* DSCH_ID */
static int hf_rnsap_dl_ccTrCHID = -1;             /* CCTrCH_ID */
static int hf_rnsap_trChSourceStatisticsDescriptor = -1;  /* TrCH_SrcStatisticsDescr */
static int hf_rnsap_transportFormatSet = -1;      /* TransportFormatSet */
static int hf_rnsap_schedulingPriorityIndicator = -1;  /* SchedulingPriorityIndicator */
static int hf_rnsap_bLER = -1;                    /* BLER */
static int hf_rnsap_uE_DTX_Cycle1_2ms = -1;       /* UE_DTX_Cycle1_2ms */
static int hf_rnsap_uE_DTX_Cycle2_2ms = -1;       /* UE_DTX_Cycle2_2ms */
static int hf_rnsap_mAC_DTX_Cycle_2ms = -1;       /* MAC_DTX_Cycle_2ms */
static int hf_rnsap_uE_DTX_Cycle1_10ms = -1;      /* UE_DTX_Cycle1_10ms */
static int hf_rnsap_uE_DTX_Cycle2_10ms = -1;      /* UE_DTX_Cycle2_10ms */
static int hf_rnsap_mAC_DTX_Cycle_10ms = -1;      /* MAC_DTX_Cycle_10ms */
static int hf_rnsap_e_DCH_TTI_Length = -1;        /* E_DCH_TTI_Length */
static int hf_rnsap_inactivity_Threshold_for_UE_DTX_Cycle2 = -1;  /* Inactivity_Threshold_for_UE_DTX_Cycle2 */
static int hf_rnsap_uE_DTX_Long_Preamble = -1;    /* UE_DTX_Long_Preamble */
static int hf_rnsap_uE_Inactivity_Threshold = -1;  /* UE_Inactivity_Threshold */
static int hf_rnsap_cQI_DTX_Timer = -1;           /* CQI_DTX_Timer */
static int hf_rnsap_uE_DPCCH_burst1 = -1;         /* UE_DPCCH_burst1 */
static int hf_rnsap_uE_DPCCH_burst2 = -1;         /* UE_DPCCH_burst2 */
static int hf_rnsap_modify_01 = -1;               /* DTX_Information_to_Modify_Items */
static int hf_rnsap_e_DCH_TTI_Length_to_Modify = -1;  /* E_DCH_TTI_Length_to_Modify */
static int hf_rnsap_eAGCH_ERGCH_EHICH_FDD_ScramblingCode = -1;  /* DL_ScramblingCode */
static int hf_rnsap_eAGCH_ChannelisationCode = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_rnsap_primary_e_RNTI = -1;          /* E_RNTI */
static int hf_rnsap_secondary_e_RNTI = -1;        /* E_RNTI */
static int hf_rnsap_eRGCH_EHICH_ChannelisationCode = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_rnsap_eRGCH_SignatureSequence = -1;  /* ERGCH_SignatureSequence */
static int hf_rnsap_eHICH_SignatureSequence = -1;  /* EHICH_SignatureSequence */
static int hf_rnsap_serving_Grant_Value = -1;     /* E_Serving_Grant_Value */
static int hf_rnsap_primary_Secondary_Grant_Selector = -1;  /* E_Primary_Secondary_Grant_Selector */
static int hf_rnsap_e_RGCH_Release_Indicator = -1;  /* E_RGCH_Release_Indicator */
static int hf_rnsap_eDCH_MACdFlows_Information = -1;  /* EDCH_MACdFlows_Information */
static int hf_rnsap_hARQ_Process_Allocation_Scheduled_2ms_EDCH = -1;  /* HARQ_Process_Allocation_2ms_EDCH */
static int hf_rnsap_e_DCH_Maximum_Bitrate = -1;   /* E_DCH_Maximum_Bitrate */
static int hf_rnsap_e_DCH_Processing_Overload_Level = -1;  /* E_DCH_Processing_Overload_Level */
static int hf_rnsap_e_DCH_Reference_Power_Offset = -1;  /* E_DCH_Reference_Power_Offset */
static int hf_rnsap_eDCH_MACdFlow_Specific_InformationResponse = -1;  /* EDCH_MACdFlow_Specific_InformationResponse */
static int hf_rnsap_EDCH_MACdFlow_Specific_InformationResponse_item = -1;  /* EDCH_MACdFlow_Specific_InformationResponseItem */
static int hf_rnsap_eDCH_MACdFlow_ID = -1;        /* EDCH_MACdFlow_ID */
static int hf_rnsap_hARQ_Process_Allocation_NonSched_2ms_EDCH = -1;  /* HARQ_Process_Allocation_2ms_EDCH */
static int hf_rnsap_eDCH_MACdFlow_Specific_Information = -1;  /* EDCH_MACdFlow_Specific_InfoToModifyList */
static int hf_rnsap_mACeReset_Indicator = -1;     /* MACeReset_Indicator */
static int hf_rnsap_e_DCH_MACdFlow_Specific_UpdateInformation = -1;  /* E_DCH_MACdFlow_Specific_UpdateInformation */
static int hf_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation_item = -1;  /* E_DCH_MACdFlow_Specific_UpdateInformation_Item */
static int hf_rnsap_e_DCH_MACdFlow_ID = -1;       /* EDCH_MACdFlow_ID */
static int hf_rnsap_e_DCH_Non_Scheduled_Transmission_Grant = -1;  /* E_DCH_Non_Scheduled_Transmission_Grant_Items */
static int hf_rnsap_e_DCH_Scheduled_Transmission_Grant = -1;  /* NULL */
static int hf_rnsap_E_DCH_LogicalChannelInformation_item = -1;  /* E_DCH_LogicalChannelInformationItem */
static int hf_rnsap_logicalChannelId = -1;        /* LogicalChannelID */
static int hf_rnsap_schedulingInformation = -1;   /* SchedulingInformation */
static int hf_rnsap_mACes_GuaranteedBitRate = -1;  /* MACes_Guaranteed_Bitrate */
static int hf_rnsap_eDCH_DDI_Value = -1;          /* EDCH_DDI_Value */
static int hf_rnsap_mACd_PDU_Size_List = -1;      /* E_DCH_MACdPDU_SizeList */
static int hf_rnsap_E_DCH_MACdPDU_SizeList_item = -1;  /* E_DCH_MACdPDU_SizeListItem */
static int hf_rnsap_mACdPDU_Size = -1;            /* MACdPDU_Size */
static int hf_rnsap_E_DCH_LogicalChannelToModify_item = -1;  /* E_DCH_LogicalChannelToModifyItem */
static int hf_rnsap_mACd_PDU_Size_List_01 = -1;   /* E_DCH_MACdPDU_SizeToModifyList */
static int hf_rnsap_E_DCH_MACdPDU_SizeToModifyList_item = -1;  /* E_DCH_MACdPDU_SizeListItem */
static int hf_rnsap_E_DCH_LogicalChannelToDelete_item = -1;  /* E_DCH_LogicalChannelToDeleteItem */
static int hf_rnsap_eDCH_MACdFlow_Specific_Information_01 = -1;  /* EDCH_MACdFlow_Specific_InfoList */
static int hf_rnsap_EDCH_MACdFlow_Specific_InfoList_item = -1;  /* EDCH_MACdFlow_Specific_InfoItem */
static int hf_rnsap_tnlQoS = -1;                  /* TnlQos */
static int hf_rnsap_maxNr_Retransmissions_EDCH = -1;  /* MaxNr_Retransmissions_EDCH */
static int hf_rnsap_trafficClass = -1;            /* TrafficClass */
static int hf_rnsap_eDCH_HARQ_PO_FDD = -1;        /* E_DCH_HARQ_PO_FDD */
static int hf_rnsap_eDCH_MACdFlow_Multiplexing_List = -1;  /* E_DCH_MACdFlow_Multiplexing_List */
static int hf_rnsap_eDCH_Grant_Type_Information = -1;  /* E_DCH_Grant_Type_Information */
static int hf_rnsap_bundlingModeIndicator = -1;   /* BundlingModeIndicator */
static int hf_rnsap_eDCHLogicalChannelInformation = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList_item = -1;  /* EDCH_MACdFlow_Specific_InfoToModifyItem */
static int hf_rnsap_transportBearerRequestIndicator = -1;  /* TransportBearerRequestIndicator */
static int hf_rnsap_eDCH_LogicalChannelToAdd = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_rnsap_eDCH_LogicalChannelToModify = -1;  /* E_DCH_LogicalChannelToModify */
static int hf_rnsap_eDCH_LogicalChannelToDelete = -1;  /* E_DCH_LogicalChannelToDelete */
static int hf_rnsap_EDCH_MACdFlows_To_Delete_item = -1;  /* EDCH_MACdFlows_To_Delete_Item */
static int hf_rnsap_maxBits_MACe_PDU_non_scheduled = -1;  /* Max_Bits_MACe_PDU_non_scheduled */
static int hf_rnsap_hARQ_Process_Allocation_NonSched_2ms = -1;  /* HARQ_Process_Allocation_2ms_EDCH */
static int hf_rnsap_e_DCH_serving_cell_outcome_choice = -1;  /* E_DCH_serving_cell_change_choice */
static int hf_rnsap_e_DCH_serving_cell_change_successful = -1;  /* E_DCH_serving_cell_change_successful */
static int hf_rnsap_e_DCH_serving_cell_change_unsuccessful = -1;  /* E_DCH_serving_cell_change_unsuccessful */
static int hf_rnsap_e_DCH_RL_InformationList_Rsp = -1;  /* E_DCH_RL_InformationList_Rsp */
static int hf_rnsap_E_DCH_RL_InformationList_Rsp_item = -1;  /* E_DCH_RL_InformationList_Rsp_Item */
static int hf_rnsap_e_DCH_reconfigured_RL_Id = -1;  /* RL_ID */
static int hf_rnsap_e_DCH_FDD_DL_Control_Channel_Info = -1;  /* EDCH_FDD_DL_ControlChannelInformation */
static int hf_rnsap_cause = -1;                   /* Cause */
static int hf_rnsap_two_ms = -1;                  /* DTX_Cycle_2ms_Items */
static int hf_rnsap_ten_ms = -1;                  /* DTX_Cycle_10ms_Items */
static int hf_rnsap_two_ms_01 = -1;               /* DTX_Cycle_2ms_to_Modify_Items */
static int hf_rnsap_ten_ms_01 = -1;               /* DTX_Cycle_10ms_to_Modify_Items */
static int hf_rnsap_maxSet_E_DPDCHs = -1;         /* Max_Set_E_DPDCHs */
static int hf_rnsap_punctureLimit = -1;           /* PunctureLimit */
static int hf_rnsap_e_TFCS_Information = -1;      /* E_TFCS_Information */
static int hf_rnsap_e_TTI = -1;                   /* E_TTI */
static int hf_rnsap_e_DPCCH_PO = -1;              /* E_DPCCH_PO */
static int hf_rnsap_e_RGCH_2_IndexStepThreshold = -1;  /* E_RGCH_2_IndexStepThreshold */
static int hf_rnsap_e_RGCH_3_IndexStepThreshold = -1;  /* E_RGCH_3_IndexStepThreshold */
static int hf_rnsap_hARQ_Info_for_E_DCH = -1;     /* HARQ_Info_for_E_DCH */
static int hf_rnsap_hSDSCH_Configured_Indicator = -1;  /* HSDSCH_Configured_Indicator */
static int hf_rnsap_e_DCH_Serving_RL_in_this_DRNS = -1;  /* EDCH_Serving_RL_in_this_DRNS */
static int hf_rnsap_e_DCH_Serving_RL_not_in_this_DRNS = -1;  /* NULL */
static int hf_rnsap_e_DCH_Serving_RL_Id = -1;     /* RL_ID */
static int hf_rnsap_priorityQueueInfo_Common_HS_DSCH_RNTI = -1;  /* PriorityQueue_InfoList_EnhancedFACH */
static int hf_rnsap_priorityQueueInfo_Dedicated_HS_DSCH_RNTI = -1;  /* PriorityQueue_InfoList_EnhancedFACH */
static int hf_rnsap_hSDSCH_Initial_Capacity_Allocation = -1;  /* HSDSCH_Initial_Capacity_Allocation */
static int hf_rnsap_e_DCH_TFCI_Table_Index = -1;  /* E_DCH_TFCI_Table_Index */
static int hf_rnsap_e_DCH_Min_Set_E_TFCI = -1;    /* E_TFCI */
static int hf_rnsap_reference_E_TFCI_Information = -1;  /* Reference_E_TFCI_Information */
static int hf_rnsap_measurementTreshold = -1;     /* MeasurementThreshold */
static int hf_rnsap_measurementHysteresisTime = -1;  /* MeasurementHysteresisTime */
static int hf_rnsap_measurementIncreaseDecreaseThreshold = -1;  /* MeasurementIncreaseDecreaseThreshold */
static int hf_rnsap_measurementChangeTime = -1;   /* MeasurementChangeTime */
static int hf_rnsap_measurementThreshold1 = -1;   /* MeasurementThreshold */
static int hf_rnsap_measurementThreshold2 = -1;   /* MeasurementThreshold */
static int hf_rnsap_reportPeriodicity = -1;       /* ReportPeriodicity */
static int hf_rnsap_e_PUCH_Information = -1;      /* E_PUCH_Information */
static int hf_rnsap_e_TFCS_Information_TDD = -1;  /* E_TFCS_Information_TDD */
static int hf_rnsap_e_DCH_MACdFlows_Information_TDD = -1;  /* E_DCH_MACdFlows_Information_TDD */
static int hf_rnsap_e_DCH_TDD_Information = -1;   /* E_DCH_TDD_Information */
static int hf_rnsap_minCR = -1;                   /* CodeRate */
static int hf_rnsap_maxCR = -1;                   /* CodeRate */
static int hf_rnsap_harqInfo = -1;                /* HARQ_Info_for_E_DCH */
static int hf_rnsap_n_E_UCCH = -1;                /* N_E_UCCH */
static int hf_rnsap_e_DCH_QPSK_RefBetaInfo = -1;  /* E_DCH_QPSK_RefBetaInfo */
static int hf_rnsap_e_DCH_sixteenQAM_RefBetaInfo = -1;  /* E_DCH_sixteenQAM_RefBetaInfo */
static int hf_rnsap_E_DCH_QPSK_RefBetaInfo_item = -1;  /* E_DCH_RefBeta_Item */
static int hf_rnsap_E_DCH_sixteenQAM_RefBetaInfo_item = -1;  /* E_DCH_RefBeta_Item */
static int hf_rnsap_refCodeRate = -1;             /* CodeRate_short */
static int hf_rnsap_refBeta = -1;                 /* RefBeta */
static int hf_rnsap_E_DCH_MACdFlows_Information_TDD_item = -1;  /* E_DCH_MACdFlow_InfoTDDItem */
static int hf_rnsap_tnlQos = -1;                  /* TnlQos */
static int hf_rnsap_maximum_Number_of_Retransmissions_For_E_DCH = -1;  /* MaxNr_Retransmissions_EDCH */
static int hf_rnsap_eDCH_HARQ_PO_TDD = -1;        /* E_DCH_HARQ_PO_TDD */
static int hf_rnsap_eDCH_Grant_TypeTDD = -1;      /* E_DCH_Grant_TypeTDD */
static int hf_rnsap_e_DCH_TDD_Maximum_Bitrate = -1;  /* E_DCH_TDD_Maximum_Bitrate */
static int hf_rnsap_e_DCH_PowerOffset_for_SchedulingInfo = -1;  /* E_DCH_PowerOffset_for_SchedulingInfo */
static int hf_rnsap_e_DCH_MACdFlows_to_Add = -1;  /* E_DCH_MACdFlows_Information_TDD */
static int hf_rnsap_e_DCH_MACdFlows_to_Delete = -1;  /* EDCH_MACdFlows_To_Delete */
static int hf_rnsap_e_DCH_Non_Scheduled_Grant_Info = -1;  /* E_DCH_Non_Scheduled_Grant_Info */
static int hf_rnsap_e_DCH_TDD_Information_to_Modify = -1;  /* E_DCH_TDD_Information_to_Modify */
static int hf_rnsap_e_DCH_TDD_Information_to_Modify_List = -1;  /* E_DCH_TDD_Information_to_Modify_List */
static int hf_rnsap_E_DCH_TDD_Information_to_Modify_List_item = -1;  /* E_DCH_MACdFlow_ModifyTDDItem */
static int hf_rnsap_e_DCH_LogicalChannelToAdd = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_rnsap_e_DCH_LogicalChannelToModify = -1;  /* E_DCH_LogicalChannelToModify */
static int hf_rnsap_e_DCH_LogicalChannelToDelete = -1;  /* E_DCH_LogicalChannelToDelete */
static int hf_rnsap_e_DCH_TDD_MACdFlow_Specific_InformationResp = -1;  /* E_DCH_TDD_MACdFlow_Specific_InformationResp */
static int hf_rnsap_e_AGCH_Specific_Information_ResponseTDD = -1;  /* E_AGCH_Specific_InformationRespListTDD */
static int hf_rnsap_e_HICH_Information_Response = -1;  /* E_HICH_InformationResp */
static int hf_rnsap_e_RNTI = -1;                  /* E_RNTI */
static int hf_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp_item = -1;  /* E_DCH_TDD_MACdFlow_Specific_InformationResp_Item */
static int hf_rnsap_e_DCH_MacdFlow_Id = -1;       /* EDCH_MACdFlow_ID */
static int hf_rnsap_E_AGCH_Specific_InformationRespListTDD_item = -1;  /* E_AGCH_Specific_InformationResp_ItemTDD */
static int hf_rnsap_timeslot = -1;                /* TimeSlot */
static int hf_rnsap_tDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_rnsap_e_HICH_TimeOffset = -1;       /* E_HICH_TimeOffset */
static int hf_rnsap_timeslotResource = -1;        /* E_DCH_TimeslotResource */
static int hf_rnsap_powerResource = -1;           /* E_DCH_PowerResource */
static int hf_rnsap_repetitionPeriod = -1;        /* RepetitionPeriod */
static int hf_rnsap_repetitionLength = -1;        /* RepetitionLength */
static int hf_rnsap_tddE_PUCH_Offset = -1;        /* TddE_PUCH_Offset */
static int hf_rnsap_tdd_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_rnsap_e_DCH_TDD_Information768 = -1;  /* E_DCH_TDD_Information768 */
static int hf_rnsap_e_DCH_TDD_Maximum_Bitrate768 = -1;  /* E_DCH_TDD_Maximum_Bitrate768 */
static int hf_rnsap_e_DCH_Non_Scheduled_Grant_Info768 = -1;  /* E_DCH_Non_Scheduled_Grant_Info768 */
static int hf_rnsap_e_AGCH_Specific_Information_Response768TDD = -1;  /* E_AGCH_Specific_InformationRespList768TDD */
static int hf_rnsap_e_HICH_Information_Response768 = -1;  /* E_HICH_InformationResp768 */
static int hf_rnsap_E_AGCH_Specific_InformationRespList768TDD_item = -1;  /* E_AGCH_Specific_InformationResp_Item768TDD */
static int hf_rnsap_tDD_ChannelisationCode768 = -1;  /* TDD_ChannelisationCode768 */
static int hf_rnsap_tdd_ChannelisationCode768 = -1;  /* TDD_ChannelisationCode768 */
static int hf_rnsap_e_PUCH_LCR_Information = -1;  /* E_PUCH_LCR_Information */
static int hf_rnsap_e_DCH_LCR_TDD_Information = -1;  /* E_DCH_LCR_TDD_Information */
static int hf_rnsap_pRxdesBase = -1;              /* E_PUCH_PRXdesBase */
static int hf_rnsap_e_PUCH_TPC_Step_Size = -1;    /* TDD_TPC_UplinkStepSize_LCR */
static int hf_rnsap_n_E_UCCH_LCR = -1;            /* N_E_UCCH_LCR */
static int hf_rnsap_e_DCH_Physical_Layer_Category_LCR = -1;  /* E_DCH_Physical_Layer_Category_LCR */
static int hf_rnsap_e_AGCH_Specific_Information_Response_LCR_TDD = -1;  /* E_AGCH_Specific_InformationRespList_LCR_TDD */
static int hf_rnsap_e_HICH_Specific_Information_Response_LCR = -1;  /* E_HICH_Specific_InformationResp_LCR */
static int hf_rnsap_e_DCH_Non_Scheduled_Grant_Info_LCR = -1;  /* E_DCH_Non_Scheduled_Grant_Info_LCR */
static int hf_rnsap_E_AGCH_Specific_InformationRespList_LCR_TDD_item = -1;  /* E_AGCH_Specific_InformationResp_Item_LCR_TDD */
static int hf_rnsap_e_HICH_Scheduled_InformationResp_LCR = -1;  /* E_HICH_Scheduled_InformationRespList_LCR_TDD */
static int hf_rnsap_e_HICH_non_Scheduled_InformationResp_LCR = -1;  /* E_HICH_InformationResp_LCR */
static int hf_rnsap_e_HICH_TimeOffset_lcr = -1;   /* E_HICH_TimeOffset_LCR */
static int hf_rnsap_E_HICH_Scheduled_InformationRespList_LCR_TDD_item = -1;  /* E_HICH_Scheduled_InformationResp_Item_LCR_TDD */
static int hf_rnsap_e_HICH_EI = -1;               /* E_HICH_EI */
static int hf_rnsap_e_HICH_Scheduled_InformationResp_LCR_01 = -1;  /* E_HICH_InformationResp_LCR */
static int hf_rnsap_signatureSequenceGroupIndex = -1;  /* SignatureSequenceGroupIndex */
static int hf_rnsap_timeslotResource_LCR = -1;    /* E_DCH_TimeslotResource_LCR */
static int hf_rnsap_subframenumber = -1;          /* E_DCH_SubframeNumber_LCR */
static int hf_rnsap_FACH_FlowControlInformation_item = -1;  /* FACH_FlowControlInformationItem */
static int hf_rnsap_fACH_SchedulingPriority = -1;  /* SchedulingPriorityIndicator */
static int hf_rnsap_fACH_InitialWindowSize = -1;  /* FACH_InitialWindowSize */
static int hf_rnsap_FACH_InformationList_item = -1;  /* FACH_InformationItem */
static int hf_rnsap_FDD_DCHs_to_Modify_item = -1;  /* FDD_DCHs_to_ModifyItem */
static int hf_rnsap_dCH_SpecificInformationList_02 = -1;  /* FDD_DCHs_to_ModifySpecificInformationList */
static int hf_rnsap_FDD_DCHs_to_ModifySpecificInformationList_item = -1;  /* FDD_DCHs_to_ModifySpecificItem */
static int hf_rnsap_ul_TransportformatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_dl_TransportformatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_not_Used_dRACControl = -1;    /* NULL */
static int hf_rnsap_FDD_DL_CodeInformation_item = -1;  /* FDD_DL_CodeInformationItem */
static int hf_rnsap_dl_ScramblingCode = -1;       /* DL_ScramblingCode */
static int hf_rnsap_fDD_DL_ChannelisationCodeNumber = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_rnsap_transmission_Gap_Pattern_Sequence_ScramblingCode_Information = -1;  /* Transmission_Gap_Pattern_Sequence_ScramblingCode_Information */
static int hf_rnsap_tDD_ChannelisationCodeLCR = -1;  /* TDD_ChannelisationCodeLCR */
static int hf_rnsap_wT = -1;                      /* INTEGER_1_4 */
static int hf_rnsap_GA_Cell_item = -1;            /* GA_Cell_item */
static int hf_rnsap_cell_GAIgeographicalCoordinate = -1;  /* GeographicalCoordinate */
static int hf_rnsap_pointWithUncertainty = -1;    /* GA_PointWithUnCertainty */
static int hf_rnsap_pointWithUncertaintyEllipse = -1;  /* GA_PointWithUnCertaintyEllipse */
static int hf_rnsap_pointWithAltitude = -1;       /* GA_PointWithAltitude */
static int hf_rnsap_pointWithAltitudeAndUncertaintyEllipsoid = -1;  /* GA_PointWithAltitudeAndUncertaintyEllipsoid */
static int hf_rnsap_ellipsoidArc = -1;            /* GA_EllipsoidArc */
static int hf_rnsap_directionOfAltitude = -1;     /* T_directionOfAltitude */
static int hf_rnsap_altitude = -1;                /* INTEGER_0_32767 */
static int hf_rnsap_geographicalCoordinates = -1;  /* GeographicalCoordinate */
static int hf_rnsap_innerRadius = -1;             /* INTEGER_0_65535 */
static int hf_rnsap_uncertaintyRadius = -1;       /* INTEGER_0_127 */
static int hf_rnsap_offsetAngle = -1;             /* INTEGER_0_179 */
static int hf_rnsap_includedAngle = -1;           /* INTEGER_0_179 */
static int hf_rnsap_confidence = -1;              /* INTEGER_0_127 */
static int hf_rnsap_ganss_wk_number = -1;         /* INTEGER_0_255 */
static int hf_rnsap_ganss_sat_id = -1;            /* BIT_STRING_SIZE_36 */
static int hf_rnsap_gANSS_AlmanacModel = -1;      /* T_gANSS_AlmanacModel */
static int hf_rnsap_gANSS_keplerianParameters = -1;  /* T_gANSS_keplerianParameters */
static int hf_rnsap_t_oa = -1;                    /* INTEGER_0_255 */
static int hf_rnsap_iod_a = -1;                   /* INTEGER_0_3 */
static int hf_rnsap_gANSS_SatelliteInformationKP = -1;  /* GANSS_SatelliteInformationKP */
static int hf_rnsap_GANSS_Clock_Model_item = -1;  /* GANSS_Clock_Model_item */
static int hf_rnsap_t_oc_lsb = -1;                /* INTEGER_0_511 */
static int hf_rnsap_a_i2 = -1;                    /* BIT_STRING_SIZE_12 */
static int hf_rnsap_a_i1 = -1;                    /* BIT_STRING_SIZE_18 */
static int hf_rnsap_a_i0 = -1;                    /* BIT_STRING_SIZE_28 */
static int hf_rnsap_t_gd = -1;                    /* BIT_STRING_SIZE_10 */
static int hf_rnsap_model_id = -1;                /* INTEGER_0_1 */
static int hf_rnsap_ganss_Ionospheric_Model = -1;  /* GANSS_Ionospheric_Model */
static int hf_rnsap_ganss_Rx_Pos = -1;            /* GANSS_RX_Pos */
static int hf_rnsap_ionospheric_Model = -1;       /* BOOLEAN */
static int hf_rnsap_GANSS_GenericDataInfoReqList_item = -1;  /* GANSS_GenericDataInfoReqItem */
static int hf_rnsap_ganss_Id = -1;                /* INTEGER_0_7 */
static int hf_rnsap_ganss_Navigation_Model = -1;  /* BOOLEAN */
static int hf_rnsap_ganss_Time_Model = -1;        /* BIT_STRING_SIZE_8 */
static int hf_rnsap_ganss_UTC_Model = -1;         /* BOOLEAN */
static int hf_rnsap_ganss_Almanac = -1;           /* BOOLEAN */
static int hf_rnsap_ganss_Real_Time_Integrity = -1;  /* BOOLEAN */
static int hf_rnsap_GANSS_Generic_Data_item = -1;  /* GANSS_Generic_DataItem */
static int hf_rnsap_dganss_Correction = -1;       /* DGANSSCorrections */
static int hf_rnsap_ganss_Navigation_Model_01 = -1;  /* GANSS_Navigation_Model */
static int hf_rnsap_ganss_Time_Model_01 = -1;     /* GANSS_Time_Model */
static int hf_rnsap_ganss_UTC_TIME = -1;          /* GANSS_UTC_Model */
static int hf_rnsap_ganss_Almanac_01 = -1;        /* GANSS_Almanac */
static int hf_rnsap_ganss_Real_Time_Integrity_01 = -1;  /* GANSS_Real_Time_Integrity */
static int hf_rnsap_gANSS_CommonDataInfoReq = -1;  /* GANSS_CommonDataInfoReq */
static int hf_rnsap_gANSS_GenericDataInfoReqList = -1;  /* GANSS_GenericDataInfoReqList */
static int hf_rnsap_alpha_zero_ionos = -1;        /* BIT_STRING_SIZE_12 */
static int hf_rnsap_alpha_one_ionos = -1;         /* BIT_STRING_SIZE_12 */
static int hf_rnsap_alpha_two_ionos = -1;         /* BIT_STRING_SIZE_12 */
static int hf_rnsap_gANSS_IonosphereRegionalStormFlags = -1;  /* GANSS_IonosphereRegionalStormFlags */
static int hf_rnsap_storm_flag_one = -1;          /* BOOLEAN */
static int hf_rnsap_storm_flag_two = -1;          /* BOOLEAN */
static int hf_rnsap_storm_flag_three = -1;        /* BOOLEAN */
static int hf_rnsap_storm_flag_four = -1;         /* BOOLEAN */
static int hf_rnsap_storm_flag_five = -1;         /* BOOLEAN */
static int hf_rnsap_ganss_Ref_Time = -1;          /* GANSS_Reference_Time */
static int hf_rnsap_non_broadcastIndication = -1;  /* T_non_broadcastIndication */
static int hf_rnsap_toe_c_msb = -1;               /* INTEGER_0_31 */
static int hf_rnsap_e_msb = -1;                   /* INTEGER_0_127 */
static int hf_rnsap_sqrtA_msb = -1;               /* INTEGER_0_63 */
static int hf_rnsap_ganssSatInfoNav = -1;         /* GANSS_Sat_Info_Nav */
static int hf_rnsap_gANSS_keplerianParameters_01 = -1;  /* T_gANSS_keplerianParameters_01 */
static int hf_rnsap_toe_lsb_nav = -1;             /* INTEGER_0_511 */
static int hf_rnsap_ganss_omega_nav = -1;         /* BIT_STRING_SIZE_32 */
static int hf_rnsap_delta_n_nav = -1;             /* BIT_STRING_SIZE_16 */
static int hf_rnsap_m_zero_nav = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_omegadot_nav = -1;            /* BIT_STRING_SIZE_24 */
static int hf_rnsap_ganss_e_lsb_nav = -1;         /* INTEGER_0_33554431 */
static int hf_rnsap_idot_nav = -1;                /* BIT_STRING_SIZE_14 */
static int hf_rnsap_a_sqrt_lsb_nav = -1;          /* INTEGER_0_67108863 */
static int hf_rnsap_i_zero_nav = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_omega_zero_nav = -1;          /* BIT_STRING_SIZE_32 */
static int hf_rnsap_c_rs_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_c_is_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_c_us_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_c_rc_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_c_ic_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_c_uc_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_GANSS_Real_Time_Integrity_item = -1;  /* GANSS_Real_Time_Integrity_item */
static int hf_rnsap_bad_ganss_satId = -1;         /* INTEGER_0_63 */
static int hf_rnsap_bad_ganss_signalId = -1;      /* INTEGER_0_4_ */
static int hf_rnsap_ganssDay = -1;                /* INTEGER_0_8191 */
static int hf_rnsap_ganssTod = -1;                /* INTEGER_0_86399 */
static int hf_rnsap_ganssTodUncertainty = -1;     /* INTEGER_0_127 */
static int hf_rnsap_latitudeSign = -1;            /* T_latitudeSign */
static int hf_rnsap_degreesOfLatitude = -1;       /* INTEGER_0_2147483647 */
static int hf_rnsap_degreesOfLongitude = -1;      /* INTEGER_M2147483648_2147483647 */
static int hf_rnsap_directionOfAltitude_01 = -1;  /* T_directionOfAltitude_01 */
static int hf_rnsap_GANSS_SatelliteInformationKP_item = -1;  /* GANSS_SatelliteInformationKP_item */
static int hf_rnsap_ganss_e_alm = -1;             /* BIT_STRING_SIZE_11 */
static int hf_rnsap_ganss_delta_I_alm = -1;       /* BIT_STRING_SIZE_11 */
static int hf_rnsap_ganss_omegadot_alm = -1;      /* BIT_STRING_SIZE_11 */
static int hf_rnsap_ganss_svhealth_alm = -1;      /* BIT_STRING_SIZE_4 */
static int hf_rnsap_ganss_delta_a_sqrt_alm = -1;  /* BIT_STRING_SIZE_17 */
static int hf_rnsap_ganss_omegazero_alm = -1;     /* BIT_STRING_SIZE_16 */
static int hf_rnsap_ganss_m_zero_alm = -1;        /* BIT_STRING_SIZE_16 */
static int hf_rnsap_ganss_omega_alm = -1;         /* BIT_STRING_SIZE_16 */
static int hf_rnsap_ganss_af_zero_alm = -1;       /* BIT_STRING_SIZE_14 */
static int hf_rnsap_ganss_af_one_alm = -1;        /* BIT_STRING_SIZE_11 */
static int hf_rnsap_GANSS_Sat_Info_Nav_item = -1;  /* GANSS_Sat_Info_Nav_item */
static int hf_rnsap_svHealth = -1;                /* BIT_STRING_SIZE_5 */
static int hf_rnsap_iod = -1;                     /* BIT_STRING_SIZE_10 */
static int hf_rnsap_ganssClockModel = -1;         /* GANSS_Clock_Model */
static int hf_rnsap_ganssOrbitModel = -1;         /* GANSS_Orbit_Model */
static int hf_rnsap_ganss_time_model = -1;        /* INTEGER_0_65535 */
static int hf_rnsap_ganss_t_a0 = -1;              /* INTEGER_M2147483648_2147483647 */
static int hf_rnsap_ganss_t_a1 = -1;              /* INTEGER_M8388608_8388607 */
static int hf_rnsap_ganss_t_a2 = -1;              /* INTEGER_M64_63 */
static int hf_rnsap_ganss_to_id = -1;             /* INTEGER_0_7 */
static int hf_rnsap_ganss_wk_number_01 = -1;      /* INTEGER_0_8191 */
static int hf_rnsap_a_one_utc = -1;               /* BIT_STRING_SIZE_24 */
static int hf_rnsap_a_zero_utc = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_t_ot_utc = -1;                /* BIT_STRING_SIZE_8 */
static int hf_rnsap_w_n_t_utc = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rnsap_delta_t_ls_utc = -1;          /* BIT_STRING_SIZE_8 */
static int hf_rnsap_w_n_lsf_utc = -1;             /* BIT_STRING_SIZE_8 */
static int hf_rnsap_dn_utc = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rnsap_delta_t_lsf_utc = -1;         /* BIT_STRING_SIZE_8 */
static int hf_rnsap_altitudeAndDirection = -1;    /* GA_AltitudeAndDirection */
static int hf_rnsap_uncertaintyEllipse = -1;      /* GA_UncertaintyEllipse */
static int hf_rnsap_uncertaintyAltitude = -1;     /* INTEGER_0_127 */
static int hf_rnsap_uncertaintySemi_major = -1;   /* INTEGER_0_127 */
static int hf_rnsap_uncertaintySemi_minor = -1;   /* INTEGER_0_127 */
static int hf_rnsap_orientationOfMajorAxis = -1;  /* INTEGER_0_179 */
static int hf_rnsap_uncertaintyCode = -1;         /* INTEGER_0_127 */
static int hf_rnsap_geographicalCoordinate = -1;  /* GeographicalCoordinate */
static int hf_rnsap_latitudeSign_01 = -1;         /* T_latitudeSign_01 */
static int hf_rnsap_latitude = -1;                /* INTEGER_0_8388607 */
static int hf_rnsap_longitude = -1;               /* INTEGER_M8388608_8388607 */
static int hf_rnsap_sI = -1;                      /* GERAN_SystemInfo */
static int hf_rnsap_pSI = -1;                     /* GERAN_SystemInfo */
static int hf_rnsap_GERAN_SystemInfo_item = -1;   /* GERAN_SystemInfo_item */
static int hf_rnsap_gERAN_SI_block = -1;          /* OCTET_STRING_SIZE_1_23 */
static int hf_rnsap_wna_alm = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_rnsap_satellite_Almanac_Information = -1;  /* T_satellite_Almanac_Information */
static int hf_rnsap_satellite_Almanac_Information_item = -1;  /* T_satellite_Almanac_Information_item */
static int hf_rnsap_dATA_ID = -1;                 /* DATA_ID */
static int hf_rnsap_gps_e_alm = -1;               /* BIT_STRING_SIZE_16 */
static int hf_rnsap_gps_toa_alm = -1;             /* BIT_STRING_SIZE_8 */
static int hf_rnsap_gps_delta_I_alm = -1;         /* BIT_STRING_SIZE_16 */
static int hf_rnsap_omegadot_alm = -1;            /* BIT_STRING_SIZE_16 */
static int hf_rnsap_svhealth_alm = -1;            /* BIT_STRING_SIZE_8 */
static int hf_rnsap_gps_a_sqrt_alm = -1;          /* BIT_STRING_SIZE_24 */
static int hf_rnsap_omegazero_alm = -1;           /* BIT_STRING_SIZE_24 */
static int hf_rnsap_m_zero_alm = -1;              /* BIT_STRING_SIZE_24 */
static int hf_rnsap_gps_omega_alm = -1;           /* BIT_STRING_SIZE_24 */
static int hf_rnsap_gps_af_zero_alm = -1;         /* BIT_STRING_SIZE_11 */
static int hf_rnsap_gps_af_one_alm = -1;          /* BIT_STRING_SIZE_11 */
static int hf_rnsap_sVGlobalHealth_alm = -1;      /* BIT_STRING_SIZE_364 */
static int hf_rnsap_Satellite_Almanac_Information_ExtItem_item = -1;  /* Satellite_Almanac_Information_ExtItem_item */
static int hf_rnsap_GPSInformation_item = -1;     /* GPSInformation_item */
static int hf_rnsap_gPSInformationItem = -1;      /* T_gPSInformationItem */
static int hf_rnsap_alpha_zero_ionos_01 = -1;     /* BIT_STRING_SIZE_8 */
static int hf_rnsap_alpha_one_ionos_01 = -1;      /* BIT_STRING_SIZE_8 */
static int hf_rnsap_alpha_two_ionos_01 = -1;      /* BIT_STRING_SIZE_8 */
static int hf_rnsap_alpha_three_ionos = -1;       /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_zero_ionos = -1;         /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_one_ionos = -1;          /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_two_ionos = -1;          /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_three_ionos = -1;        /* BIT_STRING_SIZE_8 */
static int hf_rnsap_GPS_NavigationModel_and_TimeRecovery_item = -1;  /* GPS_NavigationModel_and_TimeRecovery_item */
static int hf_rnsap_tx_tow_nav = -1;              /* INTEGER_0_1048575 */
static int hf_rnsap_tlm_message_nav = -1;         /* BIT_STRING_SIZE_14 */
static int hf_rnsap_tlm_revd_c_nav = -1;          /* BIT_STRING_SIZE_2 */
static int hf_rnsap_ho_word_nav = -1;             /* BIT_STRING_SIZE_22 */
static int hf_rnsap_w_n_nav = -1;                 /* BIT_STRING_SIZE_10 */
static int hf_rnsap_ca_or_p_on_l2_nav = -1;       /* BIT_STRING_SIZE_2 */
static int hf_rnsap_user_range_accuracy_index_nav = -1;  /* BIT_STRING_SIZE_4 */
static int hf_rnsap_sv_health_nav = -1;           /* BIT_STRING_SIZE_6 */
static int hf_rnsap_iodc_nav = -1;                /* BIT_STRING_SIZE_10 */
static int hf_rnsap_l2_p_dataflag_nav = -1;       /* BIT_STRING_SIZE_1 */
static int hf_rnsap_sf1_reserved_nav = -1;        /* BIT_STRING_SIZE_87 */
static int hf_rnsap_t_gd_nav = -1;                /* BIT_STRING_SIZE_8 */
static int hf_rnsap_t_oc_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_a_f_2_nav = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rnsap_a_f_1_nav = -1;               /* BIT_STRING_SIZE_16 */
static int hf_rnsap_a_f_zero_nav = -1;            /* BIT_STRING_SIZE_22 */
static int hf_rnsap_gps_e_nav = -1;               /* BIT_STRING_SIZE_32 */
static int hf_rnsap_a_sqrt_nav = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_t_oe_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_fit_interval_flag_nav = -1;   /* BIT_STRING_SIZE_1 */
static int hf_rnsap_aodo_nav = -1;                /* BIT_STRING_SIZE_5 */
static int hf_rnsap_gps_omega_nav = -1;           /* BIT_STRING_SIZE_32 */
static int hf_rnsap_spare_zero_fill = -1;         /* BIT_STRING_SIZE_20 */
static int hf_rnsap_badSatellites = -1;           /* BadSatellites */
static int hf_rnsap_noBadSatellite = -1;          /* NULL */
static int hf_rnsap_guaranteed_UL_Rate = -1;      /* Guaranteed_Rate */
static int hf_rnsap_guaranteed_DL_Rate = -1;      /* Guaranteed_Rate */
static int hf_rnsap_implicit = -1;                /* HARQ_MemoryPartitioning_Implicit */
static int hf_rnsap_explicit = -1;                /* HARQ_MemoryPartitioning_Explicit */
static int hf_rnsap_number_of_Processes = -1;     /* INTEGER_1_8_ */
static int hf_rnsap_hARQ_MemoryPartitioningList = -1;  /* HARQ_MemoryPartitioningList */
static int hf_rnsap_HARQ_MemoryPartitioningList_item = -1;  /* HARQ_MemoryPartitioningItem */
static int hf_rnsap_process_Memory_Size = -1;     /* T_process_Memory_Size */
static int hf_rnsap_hSDSCH_MACdFlows_Information = -1;  /* HSDSCH_MACdFlows_Information */
static int hf_rnsap_uE_Capabilities_Info = -1;    /* UE_Capabilities_Info */
static int hf_rnsap_mAChs_Reordering_Buffer_Size_for_RLC_UM = -1;  /* MAChsReorderingBufferSize_for_RLC_UM */
static int hf_rnsap_cqiFeedback_CycleK = -1;      /* CQI_Feedback_Cycle */
static int hf_rnsap_cqiRepetitionFactor = -1;     /* CQI_RepetitionFactor */
static int hf_rnsap_ackNackRepetitionFactor = -1;  /* AckNack_RepetitionFactor */
static int hf_rnsap_cqiPowerOffset = -1;          /* CQI_Power_Offset */
static int hf_rnsap_ackPowerOffset = -1;          /* Ack_Power_Offset */
static int hf_rnsap_nackPowerOffset = -1;         /* Nack_Power_Offset */
static int hf_rnsap_hsscch_PowerOffset = -1;      /* HSSCCH_PowerOffset */
static int hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_Response = -1;  /* HSDSCH_MACdFlow_Specific_InfoList_Response */
static int hf_rnsap_hSSCCH_Specific_InfoList_Response = -1;  /* HSSCCH_FDD_Specific_InfoList_Response */
static int hf_rnsap_hSPDSCH_and_HSSCCH_ScramblingCode = -1;  /* DL_ScramblingCode */
static int hf_rnsap_measurement_Power_Offset = -1;  /* Measurement_Power_Offset */
static int hf_rnsap_hARQ_MemoryPartitioning = -1;  /* HARQ_MemoryPartitioning */
static int hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_to_Modify = -1;  /* HSDSCH_MACdFlow_Specific_InfoList_to_Modify */
static int hf_rnsap_priorityQueue_Info_to_Modify = -1;  /* PriorityQueue_InfoList_to_Modify */
static int hf_rnsap_hSSCCH_CodeChangeGrant = -1;  /* HSSCCH_Code_Change_Grant */
static int hf_rnsap_tDDAckNackPowerOffset = -1;   /* TDD_AckNack_Power_Offset */
static int hf_rnsap_priorityQueueInfotoModifyUnsynchronised = -1;  /* PriorityQueue_InfoList_to_Modify_Unsynchronised */
static int hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem */
static int hf_rnsap_hSDSCH_MACdFlow_ID = -1;      /* HSDSCH_MACdFlow_ID */
static int hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem_Response */
static int hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem_to_Modify */
static int hf_rnsap_hSDSCH_MACdFlow_Specific_Info = -1;  /* HSDSCH_MACdFlow_Specific_InfoList */
static int hf_rnsap_priorityQueue_Info = -1;      /* PriorityQueue_InfoList */
static int hf_rnsap_HSDSCH_MACdFlows_to_Delete_item = -1;  /* HSDSCH_MACdFlows_to_Delete_Item */
static int hf_rnsap_hsDSCH_MACdFlow_ID = -1;      /* HSDSCH_MACdFlow_ID */
static int hf_rnsap_HSDSCH_Initial_Capacity_Allocation_item = -1;  /* HSDSCH_Initial_Capacity_AllocationItem */
static int hf_rnsap_maximum_MACdPDU_Size = -1;    /* MACdPDU_Size */
static int hf_rnsap_hSDSCH_InitialWindowSize = -1;  /* HSDSCH_InitialWindowSize */
static int hf_rnsap_hS_PDSCH_RLID = -1;           /* RL_ID */
static int hf_rnsap_hSDSCH_FDD_Information = -1;  /* HSDSCH_FDD_Information */
static int hf_rnsap_hS_DSCH_serving_cell_choice = -1;  /* HS_DSCH_serving_cell_change_choice */
static int hf_rnsap_hS_serving_cell_change_successful = -1;  /* HS_serving_cell_change_successful */
static int hf_rnsap_hS_serving_cell_change_unsuccessful = -1;  /* HS_serving_cell_change_unsuccessful */
static int hf_rnsap_hSDSCH_FDD_Information_Response = -1;  /* HSDSCH_FDD_Information_Response */
static int hf_rnsap_hSDSCH_RNTI = -1;             /* HSDSCH_RNTI */
static int hf_rnsap_tDD_AckNack_Power_Offset = -1;  /* TDD_AckNack_Power_Offset */
static int hf_rnsap_hSSCCH_TDD_Specific_InfoList_Response = -1;  /* HSSCCH_TDD_Specific_InfoList_Response */
static int hf_rnsap_hSSCCH_TDD_Specific_InfoList_Response_LCR = -1;  /* HSSCCH_TDD_Specific_InfoList_Response_LCR */
static int hf_rnsap_hSPDSCH_TDD_Specific_InfoList_Response = -1;  /* HSPDSCH_TDD_Specific_InfoList_Response */
static int hf_rnsap_hSPDSCH_TDD_Specific_InfoList_Response_LCR = -1;  /* HSPDSCH_TDD_Specific_InfoList_Response_LCR */
static int hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_item = -1;  /* HSPDSCH_TDD_Specific_InfoItem_Response */
static int hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR_item = -1;  /* HSPDSCH_TDD_Specific_InfoItem_Response_LCR */
static int hf_rnsap_timeslotLCR = -1;             /* TimeSlotLCR */
static int hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response768_item = -1;  /* HSPDSCH_TDD_Specific_InfoItem_Response768 */
static int hf_rnsap_HSSCCH_FDD_Specific_InfoList_Response_item = -1;  /* HSSCCH_FDD_Specific_InfoItem_Response */
static int hf_rnsap_code_Number = -1;             /* INTEGER_0_127 */
static int hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response_item = -1;  /* HSSCCH_TDD_Specific_InfoItem_Response */
static int hf_rnsap_hSSICH_Info = -1;             /* HSSICH_Info */
static int hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR_item = -1;  /* HSSCCH_TDD_Specific_InfoItem_Response_LCR */
static int hf_rnsap_first_TDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_rnsap_second_TDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_rnsap_hSSICH_InfoLCR = -1;          /* HSSICH_InfoLCR */
static int hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response768_item = -1;  /* HSSCCH_TDD_Specific_InfoItem_Response768 */
static int hf_rnsap_hSSICH_Info768 = -1;          /* HSSICH_Info768 */
static int hf_rnsap_hsSICH_ID = -1;               /* HS_SICH_ID */
static int hf_rnsap_failed_HS_SICH = -1;          /* HS_SICH_failed */
static int hf_rnsap_missed_HS_SICH = -1;          /* HS_SICH_missed */
static int hf_rnsap_total_HS_SICH = -1;           /* HS_SICH_total */
static int hf_rnsap_hsSCCHCodeChangeIndicator = -1;  /* HSSCCH_CodeChangeIndicator */
static int hf_rnsap_requestedDataValue = -1;      /* RequestedDataValue */
static int hf_rnsap_onDemand = -1;                /* NULL */
static int hf_rnsap_periodic = -1;                /* PeriodicInformation */
static int hf_rnsap_onModification = -1;          /* OnModificationInformation */
static int hf_rnsap_min = -1;                     /* INTEGER_1_60_ */
static int hf_rnsap_hour = -1;                    /* INTEGER_1_24_ */
static int hf_rnsap_dGPSThreshold = -1;           /* DGPSThreshold */
static int hf_rnsap_dGANSSThreshold = -1;         /* DGANSSThreshold */
static int hf_rnsap_informationTypeItem = -1;     /* T_informationTypeItem */
static int hf_rnsap_gPSInformation = -1;          /* GPSInformation */
static int hf_rnsap_iPDL_FDD_Parameters = -1;     /* IPDL_FDD_Parameters */
static int hf_rnsap_iPDL_TDD_Parameters = -1;     /* IPDL_TDD_Parameters */
static int hf_rnsap_extension_IPDLParameters = -1;  /* Extension_IPDLParameters */
static int hf_rnsap_Inter_Frequency_Cell_List_item = -1;  /* Inter_Frequency_Cell */
static int hf_rnsap_uL_UARFCN = -1;               /* UARFCN */
static int hf_rnsap_primaryScramblingCode = -1;   /* PrimaryScramblingCode */
static int hf_rnsap_inter_Frequency_Cell_Information_SIB11 = -1;  /* Inter_Frequency_Cell_Information_SIB11 */
static int hf_rnsap_inter_Frequency_Cell_Information_SIB12 = -1;  /* Inter_Frequency_Cell_Information_SIB12 */
static int hf_rnsap_Inter_Frequency_Cell_Information_SIB11_item = -1;  /* Inter_Frequency_Cells_Information_SIB11_Per_Indication */
static int hf_rnsap_Inter_Frequency_Cell_Information_SIB12_item = -1;  /* Inter_Frequency_Cells_Information_SIB12_Per_Indication */
static int hf_rnsap_inter_Frequency_Cell_Indication_SIB11 = -1;  /* Inter_Frequency_Cell_Indication */
static int hf_rnsap_inter_Frequency_Cell_List_SIB11 = -1;  /* Inter_Frequency_Cell_SIB11_or_SIB12_List */
static int hf_rnsap_inter_Frequency_Cell_Indication_SIB12 = -1;  /* Inter_Frequency_Cell_Indication */
static int hf_rnsap_inter_Frequency_Cell_List_SIB12 = -1;  /* Inter_Frequency_Cell_SIB11_or_SIB12_List */
static int hf_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12_List_item = -1;  /* Inter_Frequency_Cell_SIB11_or_SIB12 */
static int hf_rnsap_interFrequencyCellID = -1;    /* InterFrequencyCellID */
static int hf_rnsap_iPSpacingFDD = -1;            /* IPSpacingFDD */
static int hf_rnsap_iPLength = -1;                /* IPLength */
static int hf_rnsap_iPOffset = -1;                /* IPOffset */
static int hf_rnsap_seed = -1;                    /* Seed */
static int hf_rnsap_burstModeParameters = -1;     /* BurstModeParameters */
static int hf_rnsap_iPSpacingTDD = -1;            /* IPSpacingTDD */
static int hf_rnsap_iPStart = -1;                 /* IPStart */
static int hf_rnsap_iPSlot = -1;                  /* IPSlot */
static int hf_rnsap_iP_P_CCPCH = -1;              /* IP_P_CCPCH */
static int hf_rnsap_iPSub = -1;                   /* IPSub */
static int hf_rnsap_uplinkLoadValue = -1;         /* INTEGER_0_100 */
static int hf_rnsap_downlinkLoadValue = -1;       /* INTEGER_0_100 */
static int hf_rnsap_MAC_c_sh_SDU_LengthList_item = -1;  /* MAC_c_sh_SDU_Length */
static int hf_rnsap_MACdPDU_Size_IndexList_item = -1;  /* MACdPDU_Size_IndexItem */
static int hf_rnsap_sID = -1;                     /* SID */
static int hf_rnsap_MACdPDU_Size_IndexList_to_Modify_item = -1;  /* MACdPDU_Size_IndexItem_to_Modify */
static int hf_rnsap_accessPointName = -1;         /* AccessPointName */
static int hf_rnsap_iPMulticastAddress = -1;      /* IPMulticastAddress */
static int hf_rnsap_MBMS_Bearer_Service_List_item = -1;  /* TMGI */
static int hf_rnsap_tmgi = -1;                    /* TMGI */
static int hf_rnsap_transmissionMode = -1;        /* TransmissionMode */
static int hf_rnsap_preferredFrequencyLayer = -1;  /* UARFCN */
static int hf_rnsap_tMGI = -1;                    /* TMGI */
static int hf_rnsap_pTM_Cell_List = -1;           /* PTMCellList */
static int hf_rnsap_pTP_Cell_List = -1;           /* PTPCellList */
static int hf_rnsap_not_Provided_Cell_List = -1;  /* NotProvidedCellList */
static int hf_rnsap_c_ID = -1;                    /* C_ID */
static int hf_rnsap_affectedUEInformationForMBMS = -1;  /* AffectedUEInformationForMBMS */
static int hf_rnsap_preferredFrequencyLayerInfo = -1;  /* PreferredFrequencyLayerInfo */
static int hf_rnsap_sir = -1;                     /* SIR_Value_IncrDecrThres */
static int hf_rnsap_sir_error = -1;               /* SIR_Error_Value_IncrDecrThres */
static int hf_rnsap_transmitted_code_power = -1;  /* Transmitted_Code_Power_Value_IncrDecrThres */
static int hf_rnsap_rscp = -1;                    /* RSCP_Value_IncrDecrThres */
static int hf_rnsap_round_trip_time = -1;         /* Round_Trip_Time_IncrDecrThres */
static int hf_rnsap_extension_MeasurementIncreaseDecreaseThreshold = -1;  /* Extension_MeasurementIncreaseDecreaseThreshold */
static int hf_rnsap_sir_01 = -1;                  /* SIR_Value */
static int hf_rnsap_sir_error_01 = -1;            /* SIR_Error_Value */
static int hf_rnsap_transmitted_code_power_01 = -1;  /* Transmitted_Code_Power_Value */
static int hf_rnsap_rscp_01 = -1;                 /* RSCP_Value */
static int hf_rnsap_rx_timing_deviation = -1;     /* Rx_Timing_Deviation_Value */
static int hf_rnsap_round_trip_time_01 = -1;      /* Round_Trip_Time_Value */
static int hf_rnsap_extension_MeasurementThreshold = -1;  /* Extension_MeasurementThreshold */
static int hf_rnsap_type1 = -1;                   /* Type1 */
static int hf_rnsap_midambleConfigurationBurstType1And3 = -1;  /* MidambleConfigurationBurstType1And3 */
static int hf_rnsap_midambleAllocationMode = -1;  /* MidambleAllocationMode1 */
static int hf_rnsap_defaultMidamble = -1;         /* NULL */
static int hf_rnsap_commonMidamble = -1;          /* NULL */
static int hf_rnsap_ueSpecificMidamble = -1;      /* MidambleShiftLong */
static int hf_rnsap_type2 = -1;                   /* Type2 */
static int hf_rnsap_midambleConfigurationBurstType2 = -1;  /* MidambleConfigurationBurstType2 */
static int hf_rnsap_midambleAllocationMode_01 = -1;  /* MidambleAllocationMode2 */
static int hf_rnsap_ueSpecificMidamble_01 = -1;   /* MidambleShiftShort */
static int hf_rnsap_type3 = -1;                   /* Type3 */
static int hf_rnsap_midambleAllocationMode_02 = -1;  /* MidambleAllocationMode3 */
static int hf_rnsap_midambleAllocationMode_03 = -1;  /* MidambleAllocationMode */
static int hf_rnsap_midambleShift = -1;           /* MidambleShiftLong */
static int hf_rnsap_midambleConfigurationLCR = -1;  /* MidambleConfigurationLCR */
static int hf_rnsap_type1_01 = -1;                /* Type7681 */
static int hf_rnsap_midambleAllocationMode_04 = -1;  /* MidambleAllocationMode7681 */
static int hf_rnsap_type2_01 = -1;                /* Type7682 */
static int hf_rnsap_midambleConfigurationBurstType2_768 = -1;  /* MidambleConfigurationBurstType2_768 */
static int hf_rnsap_midambleAllocationMode_05 = -1;  /* MidambleAllocationMode7682 */
static int hf_rnsap_ueSpecificMidamble_02 = -1;   /* MidambleShiftShort768 */
static int hf_rnsap_type3_01 = -1;                /* Type7683 */
static int hf_rnsap_midambleAllocationMode_06 = -1;  /* MidambleAllocationMode7683 */
static int hf_rnsap_mIMO_N_M_Ratio = -1;          /* MIMO_N_M_Ratio */
static int hf_rnsap_mIMO_PilotConfiguration = -1;  /* MIMO_PilotConfiguration */
static int hf_rnsap_mIMO_Mode_Indicator = -1;     /* MIMO_Mode_Indicator */
static int hf_rnsap_primary_and_secondary_CPICH = -1;  /* CommonPhysicalChannelID */
static int hf_rnsap_normal_and_diversity_primary_CPICH = -1;  /* NULL */
static int hf_rnsap_addPriorityQueue = -1;        /* PriorityQueue_InfoItem_to_Add */
static int hf_rnsap_modifyPriorityQueue = -1;     /* PriorityQueue_InfoItem_to_Modify */
static int hf_rnsap_deletePriorityQueue = -1;     /* PriorityQueue_Id */
static int hf_rnsap_gERAN_SI_Type = -1;           /* GERAN_SI_Type */
static int hf_rnsap_Neighbouring_UMTS_CellInformation_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rNC_ID = -1;                  /* RNC_ID */
static int hf_rnsap_cN_PS_DomainIdentifier = -1;  /* CN_PS_DomainIdentifier */
static int hf_rnsap_cN_CS_DomainIdentifier = -1;  /* CN_CS_DomainIdentifier */
static int hf_rnsap_neighbouring_FDD_CellInformation = -1;  /* Neighbouring_FDD_CellInformation */
static int hf_rnsap_neighbouring_TDD_CellInformation = -1;  /* Neighbouring_TDD_CellInformation */
static int hf_rnsap_Neighbouring_FDD_CellInformation_item = -1;  /* Neighbouring_FDD_CellInformationItem */
static int hf_rnsap_uARFCNforNu = -1;             /* UARFCN */
static int hf_rnsap_uARFCNforNd = -1;             /* UARFCN */
static int hf_rnsap_frameOffset = -1;             /* FrameOffset */
static int hf_rnsap_primaryCPICH_Power = -1;      /* PrimaryCPICH_Power */
static int hf_rnsap_cellIndividualOffset = -1;    /* CellIndividualOffset */
static int hf_rnsap_txDiversityIndicator = -1;    /* TxDiversityIndicator */
static int hf_rnsap_sTTD_SupportIndicator = -1;   /* STTD_SupportIndicator */
static int hf_rnsap_closedLoopMode1_SupportIndicator = -1;  /* ClosedLoopMode1_SupportIndicator */
static int hf_rnsap_not_used_closedLoopMode2_SupportIndicator = -1;  /* NULL */
static int hf_rnsap_uC_ID = -1;                   /* UC_ID */
static int hf_rnsap_uARFCN = -1;                  /* UARFCN */
static int hf_rnsap_Neighbouring_GSM_CellInformationIEs_item = -1;  /* Neighbouring_GSM_CellInformationItem */
static int hf_rnsap_cGI = -1;                     /* CGI */
static int hf_rnsap_bSIC = -1;                    /* BSIC */
static int hf_rnsap_band_Indicator = -1;          /* Band_Indicator */
static int hf_rnsap_bCCH_ARFCN = -1;              /* BCCH_ARFCN */
static int hf_rnsap_Neighbouring_TDD_CellInformation_item = -1;  /* Neighbouring_TDD_CellInformationItem */
static int hf_rnsap_uARFCNforNt = -1;             /* UARFCN */
static int hf_rnsap_cellParameterID = -1;         /* CellParameterID */
static int hf_rnsap_syncCase = -1;                /* SyncCase */
static int hf_rnsap_sCH_TimeSlot = -1;            /* SCH_TimeSlot */
static int hf_rnsap_sCTD_Indicator = -1;          /* SCTD_Indicator */
static int hf_rnsap_dPCHConstantValue = -1;       /* DPCHConstantValue */
static int hf_rnsap_pCCPCH_Power = -1;            /* PCCPCH_Power */
static int hf_rnsap_Neighbouring_LCR_TDD_CellInformation_item = -1;  /* Neighbouring_LCR_TDD_CellInformationItem */
static int hf_rnsap_restrictionStateIndicator = -1;  /* RestrictionStateIndicator */
static int hf_rnsap_NotProvidedCellList_item = -1;  /* MBMSChannelTypeCellList */
static int hf_rnsap_uplinkNRTLoadInformationValue = -1;  /* INTEGER_0_3 */
static int hf_rnsap_downlinkNRTLoadInformationValue = -1;  /* INTEGER_0_3 */
static int hf_rnsap_measurementThreshold = -1;    /* MeasurementThreshold */
static int hf_rnsap_informationThreshold = -1;    /* InformationThreshold */
static int hf_rnsap_PCH_InformationList_item = -1;  /* PCH_InformationItem */
static int hf_rnsap_informationReportPeriodicity = -1;  /* InformationReportPeriodicity */
static int hf_rnsap_imsi = -1;                    /* IMSI */
static int hf_rnsap_defaultPreferredFrequency = -1;  /* UARFCN */
static int hf_rnsap_additionalPreferredFrequency = -1;  /* AdditionalPreferredFrequency */
static int hf_rnsap_PriorityQueue_InfoList_item = -1;  /* PriorityQueue_InfoItem */
static int hf_rnsap_priorityQueue_Id = -1;        /* PriorityQueue_Id */
static int hf_rnsap_associatedHSDSCH_MACdFlow = -1;  /* HSDSCH_MACdFlow_ID */
static int hf_rnsap_t1 = -1;                      /* T1 */
static int hf_rnsap_discardTimer = -1;            /* DiscardTimer */
static int hf_rnsap_mAC_hsWindowSize = -1;        /* MAC_hsWindowSize */
static int hf_rnsap_mAChsGuaranteedBitRate = -1;  /* MAChsGuaranteedBitRate */
static int hf_rnsap_mACdPDU_Size_Index = -1;      /* MACdPDU_Size_IndexList */
static int hf_rnsap_rLC_Mode = -1;                /* RLC_Mode */
static int hf_rnsap_PriorityQueue_InfoList_EnhancedFACH_item = -1;  /* PriorityQueue_InfoItem_EnhancedFACH */
static int hf_rnsap_maximum_MACdPDU_Size_01 = -1;  /* MAC_PDU_SizeExtended */
static int hf_rnsap_PriorityQueue_InfoList_to_Modify_item = -1;  /* ModifyPriorityQueue */
static int hf_rnsap_mACdPDU_Size_Index_to_Modify = -1;  /* MACdPDU_Size_IndexList_to_Modify */
static int hf_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised_item = -1;  /* PriorityQueue_InfoItem_to_Modify_Unsynchronised */
static int hf_rnsap_priorityQueueId = -1;         /* PriorityQueue_Id */
static int hf_rnsap_mBMSChannelTypeInfo = -1;     /* MBMSChannelTypeInfo */
static int hf_rnsap_mBMSPreferredFreqLayerInfo = -1;  /* MBMSPreferredFreqLayerInfo */
static int hf_rnsap_PTMCellList_item = -1;        /* MBMSChannelTypeCellList */
static int hf_rnsap_PTPCellList_item = -1;        /* MBMSChannelTypeCellList */
static int hf_rnsap_RB_Info_item = -1;            /* RB_Identity */
static int hf_rnsap_Reference_E_TFCI_Information_item = -1;  /* Reference_E_TFCI_Information_Item */
static int hf_rnsap_reference_E_TFCI = -1;        /* E_TFCI */
static int hf_rnsap_reference_E_TFCI_PO = -1;     /* Reference_E_TFCI_PO */
static int hf_rnsap_periodic_01 = -1;             /* Periodic */
static int hf_rnsap_eventA = -1;                  /* EventA */
static int hf_rnsap_eventB = -1;                  /* EventB */
static int hf_rnsap_eventC = -1;                  /* EventC */
static int hf_rnsap_eventD = -1;                  /* EventD */
static int hf_rnsap_eventE = -1;                  /* EventE */
static int hf_rnsap_eventF = -1;                  /* EventF */
static int hf_rnsap_extension_ReportCharacteristics = -1;  /* Extension_ReportCharacteristics */
static int hf_rnsap_ten_msec = -1;                /* INTEGER_1_6000_ */
static int hf_rnsap_gA_AccessPointPositionwithAltitude = -1;  /* GA_AccessPointPositionwithOptionalAltitude */
static int hf_rnsap_iPDLParameters = -1;          /* IPDLParameters */
static int hf_rnsap_dGPSCorrections = -1;         /* DGPSCorrections */
static int hf_rnsap_gPS_NavigationModel_and_TimeRecovery = -1;  /* GPS_NavigationModel_and_TimeRecovery */
static int hf_rnsap_gPS_Ionospheric_Model = -1;   /* GPS_Ionospheric_Model */
static int hf_rnsap_gPS_UTC_Model = -1;           /* GPS_UTC_Model */
static int hf_rnsap_gPS_Almanac = -1;             /* GPS_Almanac */
static int hf_rnsap_gPS_RealTime_Integrity = -1;  /* GPS_RealTime_Integrity */
static int hf_rnsap_gPS_RX_POS = -1;              /* GPS_RX_POS */
static int hf_rnsap_sFNSFN_GA_AccessPointPosition = -1;  /* GA_AccessPointPositionwithOptionalAltitude */
static int hf_rnsap_informationAvailable = -1;    /* InformationAvailable */
static int hf_rnsap_informationNotAvailable = -1;  /* InformationNotAvailable */
static int hf_rnsap_RL_Specific_DCH_Info_item = -1;  /* RL_Specific_DCH_Info_Item */
static int hf_rnsap_dCH_id = -1;                  /* DCH_ID */
static int hf_rnsap_rL_Specific_EDCH_Info = -1;   /* RL_Specific_EDCH_Info */
static int hf_rnsap_e_AGCH_PowerOffset = -1;      /* E_AGCH_PowerOffset */
static int hf_rnsap_e_RGCH_PowerOffset = -1;      /* E_RGCH_PowerOffset */
static int hf_rnsap_e_HICH_PowerOffset = -1;      /* E_HICH_PowerOffset */
static int hf_rnsap_RL_Specific_EDCH_Info_item = -1;  /* RL_Specific_EDCH_InfoItem */
static int hf_rnsap_uplinkRTLoadValue = -1;       /* INTEGER_0_100 */
static int hf_rnsap_downlinkRTLoadValue = -1;     /* INTEGER_0_100 */
static int hf_rnsap_sAC = -1;                     /* SAC */
static int hf_rnsap_dl_TFCS = -1;                 /* TFCS */
static int hf_rnsap_tFCI_Coding = -1;             /* TFCI_Coding */
static int hf_rnsap_secondary_CCPCH_TDD_InformationList = -1;  /* Secondary_CCPCH_TDD_InformationList */
static int hf_rnsap_fACH_InformationList = -1;    /* FACH_InformationList */
static int hf_rnsap_pCH_InformationList = -1;     /* PCH_InformationList */
static int hf_rnsap_new_secondary_CPICH = -1;     /* Secondary_CPICH_Information */
static int hf_rnsap_secondary_CPICH_shall_not_be_used = -1;  /* NULL */
static int hf_rnsap_secondary_LCR_CCPCH_TDD_InformationList = -1;  /* Secondary_LCR_CCPCH_TDD_InformationList */
static int hf_rnsap_secondary_CCPCH_TDD_InformationList768 = -1;  /* Secondary_CCPCH_TDD_InformationList768 */
static int hf_rnsap_Secondary_CCPCH_TDD_InformationList_item = -1;  /* Secondary_CCPCH_TDD_InformationItem */
static int hf_rnsap_secondary_CCPCH_TDD_Code_Information = -1;  /* Secondary_CCPCH_TDD_Code_Information */
static int hf_rnsap_tDD_PhysicalChannelOffset = -1;  /* TDD_PhysicalChannelOffset */
static int hf_rnsap_Secondary_LCR_CCPCH_TDD_InformationList_item = -1;  /* Secondary_LCR_CCPCH_TDD_InformationItem */
static int hf_rnsap_secondary_LCR_CCPCH_TDD_Code_Information = -1;  /* Secondary_LCR_CCPCH_TDD_Code_Information */
static int hf_rnsap_Secondary_CCPCH_TDD_InformationList768_item = -1;  /* Secondary_CCPCH_TDD_InformationItem768 */
static int hf_rnsap_secondary_CCPCH_TDD_Code_Information768 = -1;  /* Secondary_CCPCH_TDD_Code_Information768 */
static int hf_rnsap_Secondary_CCPCH_TDD_Code_Information_item = -1;  /* Secondary_CCPCH_TDD_Code_InformationItem */
static int hf_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information_item = -1;  /* Secondary_LCR_CCPCH_TDD_Code_InformationItem */
static int hf_rnsap_s_CCPCH_TimeSlotFormat_LCR = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_Secondary_CCPCH_TDD_Code_Information768_item = -1;  /* Secondary_CCPCH_TDD_Code_InformationItem768 */
static int hf_rnsap_sFNSFNChangeLimit = -1;       /* SFNSFNChangeLimit */
static int hf_rnsap_predictedSFNSFNDeviationLimit = -1;  /* PredictedSFNSFNDeviationLimit */
static int hf_rnsap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;  /* T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation */
static int hf_rnsap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;  /* T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item */
static int hf_rnsap_sFNSFNValue = -1;             /* SFNSFNValue */
static int hf_rnsap_sFNSFNQuality = -1;           /* SFNSFNQuality */
static int hf_rnsap_sFNSFNDriftRate = -1;         /* SFNSFNDriftRate */
static int hf_rnsap_sFNSFNDriftRateQuality = -1;  /* SFNSFNDriftRateQuality */
static int hf_rnsap_sFNSFNTimeStampInformation = -1;  /* SFNSFNTimeStampInformation */
static int hf_rnsap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;  /* T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation */
static int hf_rnsap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;  /* T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item */
static int hf_rnsap_sFNSFNTimeStamp_FDD = -1;     /* SFN */
static int hf_rnsap_sFNSFNTimeStamp_TDD = -1;     /* SFNSFNTimeStamp_TDD */
static int hf_rnsap_sFN = -1;                     /* SFN */
static int hf_rnsap_sFNSFN_FDD = -1;              /* SFNSFN_FDD */
static int hf_rnsap_sFNSFN_TDD = -1;              /* SFNSFN_TDD */
static int hf_rnsap_sFNSFN_TDD768 = -1;           /* SFNSFN_TDD768 */
static int hf_rnsap_sixteenQAM_UL_Operation_Indicator = -1;  /* SixteenQAM_UL_Operation_Indicator */
static int hf_rnsap_sixteenQAM_UL_Delta_T2TP = -1;  /* SixteenQAM_UL_Delta_T2TP */
static int hf_rnsap_listOfSNAs = -1;              /* ListOfSNAs */
static int hf_rnsap_ListOfSNAs_item = -1;         /* SNACode */
static int hf_rnsap_sRNTI = -1;                   /* S_RNTI */
static int hf_rnsap_sRNTI_BitMaskIndex = -1;      /* T_sRNTI_BitMaskIndex */
static int hf_rnsap_n_INSYNC_IND = -1;            /* INTEGER_1_256 */
static int hf_rnsap_n_OUTSYNC_IND = -1;           /* INTEGER_1_256 */
static int hf_rnsap_t_RLFAILURE = -1;             /* INTEGER_0_255 */
static int hf_rnsap_maxSYNC_UL_transmissions = -1;  /* T_maxSYNC_UL_transmissions */
static int hf_rnsap_powerRampStep = -1;           /* INTEGER_0_3_ */
static int hf_rnsap_modulation = -1;              /* Modulation */
static int hf_rnsap_TDD_DCHs_to_Modify_item = -1;  /* TDD_DCHs_to_ModifyItem */
static int hf_rnsap_dCH_SpecificInformationList_03 = -1;  /* TDD_DCHs_to_ModifySpecificInformationList */
static int hf_rnsap_TDD_DCHs_to_ModifySpecificInformationList_item = -1;  /* TDD_DCHs_to_ModifySpecificItem */
static int hf_rnsap_ul_CCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_dl_CCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_TDD_DL_Code_Information_item = -1;  /* TDD_DL_Code_InformationItem */
static int hf_rnsap_dPCH_ID = -1;                 /* DPCH_ID */
static int hf_rnsap_TDD_DL_Code_LCR_Information_item = -1;  /* TDD_DL_Code_LCR_InformationItem */
static int hf_rnsap_tdd_ChannelisationCodeLCR = -1;  /* TDD_ChannelisationCodeLCR */
static int hf_rnsap_tdd_DL_DPCH_TimeSlotFormat_LCR = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_TDD_DL_Code_Information768_item = -1;  /* TDD_DL_Code_InformationItem768 */
static int hf_rnsap_qPSK = -1;                    /* QPSK_DL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_eightPSK = -1;                /* EightPSK_DL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_initialOffset = -1;           /* INTEGER_0_255 */
static int hf_rnsap_noinitialOffset = -1;         /* INTEGER_0_63 */
static int hf_rnsap_TDD_UL_Code_Information_item = -1;  /* TDD_UL_Code_InformationItem */
static int hf_rnsap_TDD_UL_Code_LCR_Information_item = -1;  /* TDD_UL_Code_LCR_InformationItem */
static int hf_rnsap_tdd_UL_DPCH_TimeSlotFormat_LCR = -1;  /* TDD_UL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_TDD_UL_Code_Information768_item = -1;  /* TDD_UL_Code_InformationItem768 */
static int hf_rnsap_qPSK_01 = -1;                 /* QPSK_UL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_eightPSK_01 = -1;             /* EightPSK_UL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_plmn_id = -1;                 /* PLMN_Identity */
static int hf_rnsap_service_id = -1;              /* Service_ID */
static int hf_rnsap_dsField = -1;                 /* DsField */
static int hf_rnsap_genericTrafficCategory = -1;  /* GenericTrafficCategory */
static int hf_rnsap_Transmission_Gap_Pattern_Sequence_Information_item = -1;  /* Transmission_Gap_Pattern_Sequence_Information_item */
static int hf_rnsap_tGPSID = -1;                  /* TGPSID */
static int hf_rnsap_tGSN = -1;                    /* TGSN */
static int hf_rnsap_tGL1 = -1;                    /* GapLength */
static int hf_rnsap_tGL2 = -1;                    /* GapLength */
static int hf_rnsap_tGD = -1;                     /* TGD */
static int hf_rnsap_tGPL1 = -1;                   /* GapDuration */
static int hf_rnsap_not_to_be_used_1 = -1;        /* GapDuration */
static int hf_rnsap_uL_DL_mode = -1;              /* UL_DL_mode */
static int hf_rnsap_downlink_Compressed_Mode_Method = -1;  /* Downlink_Compressed_Mode_Method */
static int hf_rnsap_uplink_Compressed_Mode_Method = -1;  /* Uplink_Compressed_Mode_Method */
static int hf_rnsap_dL_FrameType = -1;            /* DL_FrameType */
static int hf_rnsap_delta_SIR1 = -1;              /* DeltaSIR */
static int hf_rnsap_delta_SIR_after1 = -1;        /* DeltaSIR */
static int hf_rnsap_delta_SIR2 = -1;              /* DeltaSIR */
static int hf_rnsap_delta_SIR_after2 = -1;        /* DeltaSIR */
static int hf_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item = -1;  /* Transmission_Gap_Pattern_Sequence_Status_List_item */
static int hf_rnsap_tGPRC = -1;                   /* TGPRC */
static int hf_rnsap_tGCFN = -1;                   /* CFN */
static int hf_rnsap_mS = -1;                      /* INTEGER_0_16383 */
static int hf_rnsap_lS = -1;                      /* INTEGER_0_4294967295 */
static int hf_rnsap_tUTRANGANSSChangeLimit = -1;  /* INTEGER_1_256 */
static int hf_rnsap_predictedTUTRANGANSSDeviationLimit = -1;  /* INTEGER_1_256 */
static int hf_rnsap_tUTRANGANSS = -1;             /* TUTRANGANSS */
static int hf_rnsap_tUTRANGANSSQuality = -1;      /* INTEGER_0_255 */
static int hf_rnsap_tUTRANGANSSDriftRate = -1;    /* INTEGER_M50_50 */
static int hf_rnsap_tUTRANGANSSDriftRateQuality = -1;  /* INTEGER_0_50 */
static int hf_rnsap_ms_part = -1;                 /* INTEGER_0_16383 */
static int hf_rnsap_ls_part = -1;                 /* INTEGER_0_4294967295 */
static int hf_rnsap_tUTRANGPSChangeLimit = -1;    /* TUTRANGPSChangeLimit */
static int hf_rnsap_predictedTUTRANGPSDeviationLimit = -1;  /* PredictedTUTRANGPSDeviationLimit */
static int hf_rnsap_tUTRANGPS = -1;               /* TUTRANGPS */
static int hf_rnsap_tUTRANGPSQuality = -1;        /* TUTRANGPSQuality */
static int hf_rnsap_tUTRANGPSDriftRate = -1;      /* TUTRANGPSDriftRate */
static int hf_rnsap_tUTRANGPSDriftRateQuality = -1;  /* TUTRANGPSDriftRateQuality */
static int hf_rnsap_iEe_Extensions = -1;          /* ProtocolExtensionContainer */
static int hf_rnsap_signalledGainFactors = -1;    /* T_signalledGainFactors */
static int hf_rnsap_betaC = -1;                   /* BetaCD */
static int hf_rnsap_betaD = -1;                   /* BetaCD */
static int hf_rnsap_refTFCNumber = -1;            /* RefTFCNumber */
static int hf_rnsap_tFCSvalues = -1;              /* T_tFCSvalues */
static int hf_rnsap_no_Split_in_TFCI = -1;        /* TFCS_TFCSList */
static int hf_rnsap_not_Used_split_in_TFCI = -1;  /* NULL */
static int hf_rnsap_TFCS_TFCSList_item = -1;      /* TFCS_TFCSList_item */
static int hf_rnsap_cTFC = -1;                    /* TFCS_CTFC */
static int hf_rnsap_tFC_Beta = -1;                /* TransportFormatCombination_Beta */
static int hf_rnsap_ctfc2bit = -1;                /* INTEGER_0_3 */
static int hf_rnsap_ctfc4bit = -1;                /* INTEGER_0_15 */
static int hf_rnsap_ctfc6bit = -1;                /* INTEGER_0_63 */
static int hf_rnsap_ctfc8bit = -1;                /* INTEGER_0_255 */
static int hf_rnsap_ctfc12bit = -1;               /* INTEGER_0_4095 */
static int hf_rnsap_ctfc16bit = -1;               /* INTEGER_0_65535 */
static int hf_rnsap_ctfcmaxbit = -1;              /* INTEGER_0_maxCTFC */
static int hf_rnsap_dynamicParts = -1;            /* TransportFormatSet_DynamicPartList */
static int hf_rnsap_semi_staticPart = -1;         /* TransportFormatSet_Semi_staticPart */
static int hf_rnsap_TransportFormatSet_DynamicPartList_item = -1;  /* TransportFormatSet_DynamicPartList_item */
static int hf_rnsap_nrOfTransportBlocks = -1;     /* NrOfTransportBlocks */
static int hf_rnsap_transportBlockSize = -1;      /* TransportBlockSize */
static int hf_rnsap_mode = -1;                    /* TransportFormatSet_ModeDP */
static int hf_rnsap_tdd = -1;                     /* TDD_TransportFormatSet_ModeDP */
static int hf_rnsap_notApplicable = -1;           /* NULL */
static int hf_rnsap_transmissionTimeIntervalInformation = -1;  /* TransmissionTimeIntervalInformation */
static int hf_rnsap_TransmissionTimeIntervalInformation_item = -1;  /* TransmissionTimeIntervalInformation_item */
static int hf_rnsap_transmissionTimeInterval = -1;  /* TransmissionTimeIntervalDynamic */
static int hf_rnsap_transmissionTime = -1;        /* TransmissionTimeIntervalSemiStatic */
static int hf_rnsap_channelCoding = -1;           /* ChannelCodingType */
static int hf_rnsap_codingRate = -1;              /* CodingRate */
static int hf_rnsap_rateMatcingAttribute = -1;    /* RateMatchingAttribute */
static int hf_rnsap_cRC_Size = -1;                /* CRC_Size */
static int hf_rnsap_mode_01 = -1;                 /* TransportFormatSet_ModeSSP */
static int hf_rnsap_tdd_01 = -1;                  /* SecondInterleavingMode */
static int hf_rnsap_hSDSCH_Physical_Layer_Category = -1;  /* INTEGER_1_64_ */
static int hf_rnsap_imei = -1;                    /* IMEI */
static int hf_rnsap_imeisv = -1;                  /* IMEISV */
static int hf_rnsap_periodic_02 = -1;             /* UEMeasurementReportCharacteristicsPeriodic */
static int hf_rnsap_event1h = -1;                 /* UEMeasurementReportCharacteristicsEvent1h */
static int hf_rnsap_event1i = -1;                 /* UEMeasurementReportCharacteristicsEvent1i */
static int hf_rnsap_event6a = -1;                 /* UEMeasurementReportCharacteristicsEvent6a */
static int hf_rnsap_event6b = -1;                 /* UEMeasurementReportCharacteristicsEvent6b */
static int hf_rnsap_event6c = -1;                 /* UEMeasurementReportCharacteristicsEvent6c */
static int hf_rnsap_event6d = -1;                 /* UEMeasurementReportCharacteristicsEvent6d */
static int hf_rnsap_extension_ReportCharacteristics_01 = -1;  /* UEMeasurementReportCharacteristics_Extension */
static int hf_rnsap_uEMeasurementTreshold = -1;   /* UEMeasurementThreshold */
static int hf_rnsap_uEMeasurementTimeToTrigger = -1;  /* UEMeasurementTimeToTrigger */
static int hf_rnsap_uEMeasurementHysteresisTime = -1;  /* UEMeasurementHysteresisTime */
static int hf_rnsap_amountofReporting = -1;       /* UEMeasurementReportCharacteristicsPeriodicAmountofReporting */
static int hf_rnsap_reportingInterval = -1;       /* UEMeasurementReportCharacteristicsPeriodicReportingInterval */
static int hf_rnsap_timeslotISCP = -1;            /* UEMeasurementThresholdDLTimeslotISCP */
static int hf_rnsap_uETransmitPower = -1;         /* UEMeasurementThresholdUETransmitPower */
static int hf_rnsap_extension_UEMeasurementThreshold = -1;  /* UEMeasurementThreshold_Extension */
static int hf_rnsap_UEMeasurementTimeslotInfoHCR_item = -1;  /* UEMeasurementTimeslotInfoHCR_IEs */
static int hf_rnsap_burstType = -1;               /* UEMeasurementTimeslotInfoHCRBurstType */
static int hf_rnsap_UEMeasurementTimeslotInfoLCR_item = -1;  /* UEMeasurementTimeslotInfoLCR_IEs */
static int hf_rnsap_UEMeasurementTimeslotInfo768_item = -1;  /* UEMeasurementTimeslotInfo768_IEs */
static int hf_rnsap_burstType_01 = -1;            /* UEMeasurementTimeslotInfo768BurstType */
static int hf_rnsap_uE_Transmitted_Power = -1;    /* UE_MeasurementValue_UE_Transmitted_Power */
static int hf_rnsap_primary_CCPCH_RSCP = -1;      /* UE_MeasurementValue_Primary_CCPCH_RSCP */
static int hf_rnsap_dL_Timeslot_ISCP = -1;        /* UE_MeasurementValue_DL_Timeslot_ISCP */
static int hf_rnsap_extension_UEMeasurementValue = -1;  /* UEMeasurementValue_Extension */
static int hf_rnsap_uEMeasurementTransmittedPowerListHCR = -1;  /* UEMeasurementValueTransmittedPowerListHCR */
static int hf_rnsap_uEMeasurementTransmittedPowerListLCR = -1;  /* UEMeasurementValueTransmittedPowerListLCR */
static int hf_rnsap_UEMeasurementValueTransmittedPowerListHCR_item = -1;  /* UEMeasurementValueTransmittedPowerListHCR_IEs */
static int hf_rnsap_uETransmitPower_01 = -1;      /* INTEGER_0_104 */
static int hf_rnsap_UEMeasurementValueTransmittedPowerListLCR_item = -1;  /* UEMeasurementValueTransmittedPowerListLCR_IEs */
static int hf_rnsap_UEMeasurementValueTransmittedPowerList768_item = -1;  /* UEMeasurementValueTransmittedPowerList768_IEs */
static int hf_rnsap_primaryCCPCH_RSCP = -1;       /* PrimaryCCPCH_RSCP */
static int hf_rnsap_primaryCCPCH_RSCP_Delta = -1;  /* PrimaryCCPCH_RSCP_Delta */
static int hf_rnsap_uEMeasurementTimeslotISCPListHCR = -1;  /* UEMeasurementValueTimeslotISCPListHCR */
static int hf_rnsap_uEMeasurementTimeslotISCPListLCR = -1;  /* UEMeasurementValueTimeslotISCPListLCR */
static int hf_rnsap_UEMeasurementValueTimeslotISCPListHCR_item = -1;  /* UEMeasurementValueTimeslotISCPListHCR_IEs */
static int hf_rnsap_UEMeasurementValueTimeslotISCPListLCR_item = -1;  /* UEMeasurementValueTimeslotISCPListLCR_IEs */
static int hf_rnsap_UEMeasurementValueTimeslotISCPList768_item = -1;  /* UEMeasurementValueTimeslotISCPList768_IEs */
static int hf_rnsap_measurementAvailable_02 = -1;  /* UEMeasurementValueInformationAvailable */
static int hf_rnsap_measurementnotAvailable_02 = -1;  /* UEMeasurementValueInformationnotAvailable */
static int hf_rnsap_uEmeasurementValue = -1;      /* UEMeasurementValue */
static int hf_rnsap_cell_fach_pch = -1;           /* Cell_Fach_Pch_State */
static int hf_rnsap_ura_pch = -1;                 /* Ura_Pch_State */
static int hf_rnsap_d_RNTI = -1;                  /* D_RNTI */
static int hf_rnsap_srnc_id = -1;                 /* RNC_ID */
static int hf_rnsap_ura_id = -1;                  /* URA_ID */
static int hf_rnsap_UL_Timeslot_Information_item = -1;  /* UL_Timeslot_InformationItem */
static int hf_rnsap_uL_Code_Information = -1;     /* TDD_UL_Code_Information */
static int hf_rnsap_UL_TimeslotLCR_Information_item = -1;  /* UL_TimeslotLCR_InformationItem */
static int hf_rnsap_uL_Code_LCR_InformationList = -1;  /* TDD_UL_Code_LCR_Information */
static int hf_rnsap_sequenceNumber = -1;          /* PLCCHsequenceNumber */
static int hf_rnsap_UL_Timeslot_Information768_item = -1;  /* UL_Timeslot_InformationItem768 */
static int hf_rnsap_uL_Code_Information768 = -1;  /* TDD_UL_Code_Information768 */
static int hf_rnsap_UL_TimeSlot_ISCP_Info_item = -1;  /* UL_TimeSlot_ISCP_InfoItem */
static int hf_rnsap_uL_TimeslotISCP = -1;         /* UL_TimeslotISCP */
static int hf_rnsap_UL_TimeSlot_ISCP_LCR_Info_item = -1;  /* UL_TimeSlot_ISCP_LCR_InfoItem */
static int hf_rnsap_iSCP = -1;                    /* UL_Timeslot_ISCP_Value */
static int hf_rnsap_sync_UL_codes_bitmap = -1;    /* BIT_STRING_SIZE_8 */
static int hf_rnsap_fPACH_info = -1;              /* FPACH_Information */
static int hf_rnsap_prxUpPCHdes = -1;             /* INTEGER_M120_M58_ */
static int hf_rnsap_syncUL_procParameter = -1;    /* SYNC_UL_ProcParameters */
static int hf_rnsap_mMax = -1;                    /* INTEGER_1_32 */
static int hf_rnsap_ul_ScramblingCodeNumber = -1;  /* UL_ScramblingCodeNumber */
static int hf_rnsap_ul_ScramblingCodeLength = -1;  /* UL_ScramblingCodeLength */
static int hf_rnsap_uL_Synchronisation_StepSize = -1;  /* UL_Synchronisation_StepSize */
static int hf_rnsap_uL_Synchronisation_Frequency = -1;  /* UL_Synchronisation_Frequency */
static int hf_rnsap_uRA_ID = -1;                  /* URA_ID */
static int hf_rnsap_multipleURAsIndicator = -1;   /* MultipleURAsIndicator */
static int hf_rnsap_rNCsWithCellsInTheAccessedURA_List = -1;  /* RNCsWithCellsInTheAccessedURA_List */
static int hf_rnsap_RNCsWithCellsInTheAccessedURA_List_item = -1;  /* RNCsWithCellsInTheAccessedURA_Item */
static int hf_rnsap_USCH_Information_item = -1;   /* USCH_InformationItem */
static int hf_rnsap_uSCH_ID = -1;                 /* USCH_ID */
static int hf_rnsap_rb_Info = -1;                 /* RB_Info */
static int hf_rnsap_protocolIEs = -1;             /* ProtocolIE_Container */
static int hf_rnsap_protocolExtensions = -1;      /* ProtocolExtensionContainer */
static int hf_rnsap_ul_ScramblingCode = -1;       /* UL_ScramblingCode */
static int hf_rnsap_minUL_ChannelisationCodeLength = -1;  /* MinUL_ChannelisationCodeLength */
static int hf_rnsap_maxNrOfUL_DPCHs = -1;         /* MaxNrOfUL_DPCHs */
static int hf_rnsap_ul_PunctureLimit = -1;        /* PunctureLimit */
static int hf_rnsap_ul_TFCS = -1;                 /* TFCS */
static int hf_rnsap_ul_DPCCH_SlotFormat = -1;     /* UL_DPCCH_SlotFormat */
static int hf_rnsap_ul_SIRTarget = -1;            /* UL_SIR */
static int hf_rnsap_diversityMode = -1;           /* DiversityMode */
static int hf_rnsap_not_Used_sSDT_CellIdLength = -1;  /* NULL */
static int hf_rnsap_not_Used_s_FieldLength = -1;  /* NULL */
static int hf_rnsap_tFCS = -1;                    /* TFCS */
static int hf_rnsap_dl_DPCH_SlotFormat = -1;      /* DL_DPCH_SlotFormat */
static int hf_rnsap_nrOfDLchannelisationcodes = -1;  /* NrOfDLchannelisationcodes */
static int hf_rnsap_tFCI_SignallingMode = -1;     /* TFCI_SignallingMode */
static int hf_rnsap_multiplexingPosition = -1;    /* MultiplexingPosition */
static int hf_rnsap_powerOffsetInformation = -1;  /* PowerOffsetInformation_RL_SetupRqstFDD */
static int hf_rnsap_fdd_dl_TPC_DownlinkStepSize = -1;  /* FDD_TPC_DownlinkStepSize */
static int hf_rnsap_limitedPowerIncrease = -1;    /* LimitedPowerIncrease */
static int hf_rnsap_innerLoopDLPCStatus = -1;     /* InnerLoopDLPCStatus */
static int hf_rnsap_po1_ForTFCI_Bits = -1;        /* PowerOffset */
static int hf_rnsap_po2_ForTPC_Bits = -1;         /* PowerOffset */
static int hf_rnsap_po3_ForPilotBits = -1;        /* PowerOffset */
static int hf_rnsap_RL_InformationList_RL_SetupRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_firstRLS_indicator = -1;      /* FirstRLS_Indicator */
static int hf_rnsap_chipOffset = -1;              /* ChipOffset */
static int hf_rnsap_propagationDelay = -1;        /* PropagationDelay */
static int hf_rnsap_diversityControlField = -1;   /* DiversityControlField */
static int hf_rnsap_dl_InitialTX_Power = -1;      /* DL_Power */
static int hf_rnsap_primaryCPICH_EcNo = -1;       /* PrimaryCPICH_EcNo */
static int hf_rnsap_not_Used_sSDT_CellID = -1;    /* NULL */
static int hf_rnsap_transmitDiversityIndicator = -1;  /* TransmitDiversityIndicator */
static int hf_rnsap_powerOffsetInformation_01 = -1;  /* PowerOffsetInformation_F_DPCH_RL_SetupRqstFDD */
static int hf_rnsap_maxNrTimeslots_UL = -1;       /* MaxNrTimeslots */
static int hf_rnsap_minimumSpreadingFactor_UL = -1;  /* MinimumSpreadingFactor */
static int hf_rnsap_maxNrULPhysicalchannels = -1;  /* MaxNrULPhysicalchannels */
static int hf_rnsap_maxNrTimeslots_DL = -1;       /* MaxNrTimeslots */
static int hf_rnsap_minimumSpreadingFactor_DL = -1;  /* MinimumSpreadingFactor */
static int hf_rnsap_maxNrDLPhysicalchannels = -1;  /* MaxNrDLPhysicalchannels */
static int hf_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_ID = -1;               /* CCTrCH_ID */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_PunctureLimit = -1;        /* PunctureLimit */
static int hf_rnsap_tdd_TPC_DownlinkStepSize = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_rnsap_cCTrCH_TPCList = -1;          /* CCTrCH_TPCList_RL_SetupRqstTDD */
static int hf_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD_item = -1;  /* CCTrCH_TPCItem_RL_SetupRqstTDD */
static int hf_rnsap_specialBurstScheduling = -1;  /* SpecialBurstScheduling */
static int hf_rnsap_dL_TimeSlot_ISCP = -1;        /* DL_TimeSlot_ISCP_Info */
static int hf_rnsap_RL_InformationResponseList_RL_SetupRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_Set_ID = -1;               /* RL_Set_ID */
static int hf_rnsap_uRA_Information = -1;         /* URA_Information */
static int hf_rnsap_sAI = -1;                     /* SAI */
static int hf_rnsap_gA_Cell = -1;                 /* GA_Cell */
static int hf_rnsap_gA_AccessPointPosition = -1;  /* GA_AccessPointPosition */
static int hf_rnsap_received_total_wide_band_power = -1;  /* Received_total_wide_band_power */
static int hf_rnsap_not_Used_secondary_CCPCH_Info = -1;  /* NULL */
static int hf_rnsap_dl_CodeInformation = -1;      /* FDD_DL_CodeInformation */
static int hf_rnsap_diversityIndication = -1;     /* DiversityIndication_RL_SetupRspFDD */
static int hf_rnsap_sSDT_SupportIndicator = -1;   /* SSDT_SupportIndicator */
static int hf_rnsap_maxUL_SIR = -1;               /* UL_SIR */
static int hf_rnsap_minUL_SIR = -1;               /* UL_SIR */
static int hf_rnsap_closedlooptimingadjustmentmode = -1;  /* Closedlooptimingadjustmentmode */
static int hf_rnsap_maximumAllowedULTxPower = -1;  /* MaximumAllowedULTxPower */
static int hf_rnsap_maximumDLTxPower = -1;        /* DL_Power */
static int hf_rnsap_minimumDLTxPower = -1;        /* DL_Power */
static int hf_rnsap_not_Used_dSCHInformationResponse = -1;  /* NULL */
static int hf_rnsap_neighbouring_UMTS_CellInformation = -1;  /* Neighbouring_UMTS_CellInformation */
static int hf_rnsap_neighbouring_GSM_CellInformation = -1;  /* Neighbouring_GSM_CellInformation */
static int hf_rnsap_pC_Preamble = -1;             /* PC_Preamble */
static int hf_rnsap_sRB_Delay = -1;               /* SRB_Delay */
static int hf_rnsap_combining = -1;               /* Combining_RL_SetupRspFDD */
static int hf_rnsap_nonCombiningOrFirstRL = -1;   /* NonCombiningOrFirstRL_RL_SetupRspFDD */
static int hf_rnsap_dCH_InformationResponse = -1;  /* DCH_InformationResponse */
static int hf_rnsap_ul_TimeSlot_ISCP_Info = -1;   /* UL_TimeSlot_ISCP_Info */
static int hf_rnsap_timingAdvanceApplied = -1;    /* TimingAdvanceApplied */
static int hf_rnsap_alphaValue = -1;              /* AlphaValue */
static int hf_rnsap_ul_PhysCH_SF_Variation = -1;  /* UL_PhysCH_SF_Variation */
static int hf_rnsap_synchronisationConfiguration = -1;  /* SynchronisationConfiguration */
static int hf_rnsap_secondary_CCPCH_Info_TDD = -1;  /* Secondary_CCPCH_Info_TDD */
static int hf_rnsap_ul_CCTrCHInformation = -1;    /* UL_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dl_CCTrCHInformation = -1;    /* DL_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dCH_InformationResponse_01 = -1;  /* DCH_InformationResponseList_RL_SetupRspTDD */
static int hf_rnsap_dsch_InformationResponse = -1;  /* DSCH_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_usch_InformationResponse = -1;  /* USCH_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD_item = -1;  /* UL_CCTrCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_ul_DPCH_Information = -1;     /* UL_DPCH_InformationList_RL_SetupRspTDD */
static int hf_rnsap_tDD_DPCHOffset = -1;          /* TDD_DPCHOffset */
static int hf_rnsap_uL_Timeslot_Information = -1;  /* UL_Timeslot_Information */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD_item = -1;  /* DL_CCTrCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_dl_DPCH_Information = -1;     /* DL_DPCH_InformationList_RL_SetupRspTDD */
static int hf_rnsap_dL_Timeslot_Information = -1;  /* DL_Timeslot_Information */
static int hf_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD_item = -1;  /* DSCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_dsch_ID = -1;                 /* DSCH_ID */
static int hf_rnsap_dSCH_FlowControlInformation = -1;  /* DSCH_FlowControlInformation */
static int hf_rnsap_transportFormatManagement = -1;  /* TransportFormatManagement */
static int hf_rnsap_USCH_InformationListIEs_RL_SetupRspTDD_item = -1;  /* USCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_usch_ID = -1;                 /* USCH_ID */
static int hf_rnsap_ul_TimeSlot_ISCP_LCR_Info = -1;  /* UL_TimeSlot_ISCP_LCR_Info */
static int hf_rnsap_secondary_LCR_CCPCH_Info_TDD = -1;  /* Secondary_LCR_CCPCH_Info_TDD */
static int hf_rnsap_ul_LCR_CCTrCHInformation = -1;  /* UL_LCR_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dl_LCR_CCTrCHInformation = -1;  /* DL_LCR_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dsch_LCR_InformationResponse = -1;  /* DSCH_LCR_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_usch_LCR_InformationResponse = -1;  /* USCH_LCR_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_UL_LCR_CCTrCHInformationListIE_RL_SetupRspTDD_item = -1;  /* UL_LCR_CCTrCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_ul_DPCH_LCR_Information = -1;  /* UL_DPCH_LCR_InformationList_RL_SetupRspTDD */
static int hf_rnsap_uL_TimeslotLCR_Information = -1;  /* UL_TimeslotLCR_Information */
static int hf_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD_item = -1;  /* DL_CCTrCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_dl_DPCH_LCR_Information = -1;  /* DL_DPCH_LCR_InformationList_RL_SetupRspTDD */
static int hf_rnsap_dL_Timeslot_LCR_Information = -1;  /* DL_TimeslotLCR_Information */
static int hf_rnsap_tSTD_Indicator = -1;          /* TSTD_Indicator */
static int hf_rnsap_DSCH_LCR_InformationListIEs_RL_SetupRspTDD_item = -1;  /* DSCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_USCH_LCR_InformationListIEs_RL_SetupRspTDD_item = -1;  /* USCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_secondary_CCPCH_Info_TDD768 = -1;  /* Secondary_CCPCH_Info_TDD768 */
static int hf_rnsap_ul_CCTrCHInformation768 = -1;  /* UL_CCTrCHInformationList_RL_SetupRspTDD768 */
static int hf_rnsap_dl_CCTrCHInformation768 = -1;  /* DL_CCTrCHInformationList_RL_SetupRspTDD768 */
static int hf_rnsap_gA_CellAdditionalShapes = -1;  /* GA_CellAdditionalShapes */
static int hf_rnsap_hCS_Prio = -1;                /* HCS_Prio */
static int hf_rnsap_timeSlot_RL_SetupRspTDD = -1;  /* TimeSlot */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD768_item = -1;  /* UL_CCTrCHInformationItem_RL_SetupRspTDD768 */
static int hf_rnsap_ul_DPCH_Information768 = -1;  /* UL_DPCH_InformationList_RL_SetupRspTDD768 */
static int hf_rnsap_uL_SIR_Target_CCTrCH_InformationItem_RL_SetupRspTDD768 = -1;  /* UL_SIR */
static int hf_rnsap_uL_Timeslot_Information768 = -1;  /* UL_Timeslot_Information768 */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD768_item = -1;  /* DL_CCTrCHInformationItem_RL_SetupRspTDD768 */
static int hf_rnsap_dl_DPCH_Information768 = -1;  /* DL_DPCH_InformationList_RL_SetupRspTDD768 */
static int hf_rnsap_cCTrCH_Maximum_DL_Power = -1;  /* DL_Power */
static int hf_rnsap_cCTrCH_Minimum_DL_Power = -1;  /* DL_Power */
static int hf_rnsap_dL_Timeslot_Information768 = -1;  /* DL_Timeslot_Information768 */
static int hf_rnsap_generalCause = -1;            /* GeneralCauseList_RL_SetupFailureFDD */
static int hf_rnsap_rLSpecificCause = -1;         /* RLSpecificCauseList_RL_SetupFailureFDD */
static int hf_rnsap_unsuccessful_RL_InformationRespList_RL_SetupFailureFDD = -1;  /* UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD */
static int hf_rnsap_successful_RL_InformationRespList_RL_SetupFailureFDD = -1;  /* SuccessfulRL_InformationResponseList_RL_SetupFailureFDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_diversityIndication_01 = -1;  /* DiversityIndication_RL_SetupFailureFDD */
static int hf_rnsap_not_Used_dSCH_InformationResponse_RL_SetupFailureFDD = -1;  /* NULL */
static int hf_rnsap_combining_01 = -1;            /* Combining_RL_SetupFailureFDD */
static int hf_rnsap_nonCombiningOrFirstRL_01 = -1;  /* NonCombiningOrFirstRL_RL_SetupFailureFDD */
static int hf_rnsap_generalCause_01 = -1;         /* GeneralCauseList_RL_SetupFailureTDD */
static int hf_rnsap_rLSpecificCause_01 = -1;      /* RLSpecificCauseList_RL_SetupFailureTDD */
static int hf_rnsap_unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD = -1;  /* Unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD */
static int hf_rnsap_RL_InformationList_RL_AdditionRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dL_TimeSlot_ISCP_Info = -1;   /* DL_TimeSlot_ISCP_Info */
static int hf_rnsap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_uplinkStepSizeLCR = -1;       /* TDD_TPC_UplinkStepSize_LCR */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_downlinkStepSize = -1;        /* TDD_TPC_DownlinkStepSize */
static int hf_rnsap_RL_InformationResponseList_RL_AdditionRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_CodeInformation_01 = -1;   /* DL_CodeInformationList_RL_AdditionRspFDD */
static int hf_rnsap_diversityIndication_02 = -1;  /* DiversityIndication_RL_AdditionRspFDD */
static int hf_rnsap_combining_02 = -1;            /* Combining_RL_AdditionRspFDD */
static int hf_rnsap_nonCombining = -1;            /* NonCombining_RL_AdditionRspFDD */
static int hf_rnsap_ul_CCTrCHInformation_01 = -1;  /* UL_CCTrCHInformationList_RL_AdditionRspTDD */
static int hf_rnsap_dl_CCTrCHInformation_01 = -1;  /* DL_CCTrCHInformationList_RL_AdditionRspTDD */
static int hf_rnsap_dCH_Information = -1;         /* DCH_Information_RL_AdditionRspTDD */
static int hf_rnsap_dSCH_InformationResponse = -1;  /* DSCH_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_uSCH_InformationResponse = -1;  /* USCH_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD_item = -1;  /* UL_CCTrCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_ul_DPCH_Information_01 = -1;  /* UL_DPCH_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD_item = -1;  /* DL_CCTrCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_dl_DPCH_Information_01 = -1;  /* DL_DPCH_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_diversityIndication_03 = -1;  /* DiversityIndication_RL_AdditionRspTDD */
static int hf_rnsap_combining_03 = -1;            /* Combining_RL_AdditionRspTDD */
static int hf_rnsap_nonCombining_01 = -1;         /* NonCombining_RL_AdditionRspTDD */
static int hf_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD_item = -1;  /* DSCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_diversityIndication_04 = -1;  /* DiversityIndication_RL_AdditionRspTDD2 */
static int hf_rnsap_USCH_InformationListIE_RL_AdditionRspTDD_item = -1;  /* USCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_ul_CCTrCH_LCR_Information = -1;  /* UL_CCTrCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_dl_CCTrCH_LCR_Information = -1;  /* DL_CCTrCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_dCH_InformationResponse_02 = -1;  /* DCH_InformationResponseList_RL_AdditionRspTDD */
static int hf_rnsap_dsch_LCR_InformationResponse_01 = -1;  /* DSCH_LCR_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_usch_LCR_InformationResponse_01 = -1;  /* USCH_LCR_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD_item = -1;  /* UL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_ul_DPCH_LCR_Information_01 = -1;  /* UL_DPCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD_item = -1;  /* DL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_dl_DPCH_LCR_Information_01 = -1;  /* DL_DPCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_dL_TimeslotLCR_Information = -1;  /* DL_TimeslotLCR_Information */
static int hf_rnsap_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD_item = -1;  /* DSCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_USCH_LCR_InformationListIEs_RL_AdditionRspTDD_item = -1;  /* USCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_ul_CCTrCHInformation768_01 = -1;  /* UL_CCTrCHInformationList_RL_AdditionRspTDD768 */
static int hf_rnsap_dl_CCTrCHInformation768_01 = -1;  /* DL_CCTrCHInformationList_RL_AdditionRspTDD768 */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD768_item = -1;  /* UL_CCTrCHInformationItem_RL_AdditionRspTDD768 */
static int hf_rnsap_ul_DPCH_Information768_01 = -1;  /* UL_DPCH_InformationList_RL_AdditionRspTDD768 */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD768_item = -1;  /* DL_CCTrCHInformationItem_RL_AdditionRspTDD768 */
static int hf_rnsap_dl_DPCH_Information768_01 = -1;  /* DL_DPCH_InformationList_RL_AdditionRspTDD768 */
static int hf_rnsap_generalCause_02 = -1;         /* GeneralCauseList_RL_AdditionFailureFDD */
static int hf_rnsap_rLSpecificCause_02 = -1;      /* RLSpecificCauseList_RL_AdditionFailureFDD */
static int hf_rnsap_unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD = -1;  /* UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD */
static int hf_rnsap_successful_RL_InformationRespList_RL_AdditionFailureFDD = -1;  /* SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_CodeInformation_02 = -1;   /* DL_CodeInformationList_RL_AdditionFailureFDD */
static int hf_rnsap_diversityIndication_05 = -1;  /* DiversityIndication_RL_AdditionFailureFDD */
static int hf_rnsap_combining_04 = -1;            /* Combining_RL_AdditionFailureFDD */
static int hf_rnsap_nonCombining_02 = -1;         /* NonCombining_RL_AdditionFailureFDD */
static int hf_rnsap_generalCause_03 = -1;         /* GeneralCauseList_RL_AdditionFailureTDD */
static int hf_rnsap_rLSpecificCause_03 = -1;      /* RLSpecificCauseList_RL_AdditionFailureTDD */
static int hf_rnsap_unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD = -1;  /* Unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD */
static int hf_rnsap_RL_InformationList_RL_DeletionRqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_maxNrOfUL_DPDCHs = -1;        /* MaxNrOfUL_DPCHs */
static int hf_rnsap_not_Used_sSDT_CellIDLength = -1;  /* NULL */
static int hf_rnsap_powerOffsetInformation_02 = -1;  /* PowerOffsetInformation_RL_ReconfPrepFDD */
static int hf_rnsap_fdd_TPC_DownlinkStepSize = -1;  /* FDD_TPC_DownlinkStepSize */
static int hf_rnsap_pO1_ForTFCI_Bits = -1;        /* PowerOffset */
static int hf_rnsap_pO2_ForTPC_Bits = -1;         /* PowerOffset */
static int hf_rnsap_pO3_ForPilotBits = -1;        /* PowerOffset */
static int hf_rnsap_DCH_DeleteList_RL_ReconfPrepFDD_item = -1;  /* DCH_DeleteItem_RL_ReconfPrepFDD */
static int hf_rnsap_RL_InformationList_RL_ReconfPrepFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_not_Used_sSDT_Indication = -1;  /* NULL */
static int hf_rnsap_not_Used_sSDT_CellIdentity = -1;  /* NULL */
static int hf_rnsap_powerOffsetInformation_03 = -1;  /* PowerOffsetInformation_F_DPCH_RL_ReconfPrepFDD */
static int hf_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_TPCList_01 = -1;       /* CCTrCH_TPCAddList_RL_ReconfPrepTDD */
static int hf_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD_item = -1;  /* CCTrCH_TPCAddItem_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_TPCList_02 = -1;       /* CCTrCH_TPCModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD_item = -1;  /* CCTrCH_TPCModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DCH_DeleteList_RL_ReconfPrepTDD_item = -1;  /* DCH_DeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DSCH_ModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD_item = -1;  /* DSCH_DeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_USCH_ModifyList_RL_ReconfPrepTDD_item = -1;  /* USCH_ModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_ul_ccTrCHID = -1;             /* CCTrCH_ID */
static int hf_rnsap_USCH_DeleteList_RL_ReconfPrepTDD_item = -1;  /* USCH_DeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_RL_Information_RL_ReconfPrepTDD_item = -1;  /* RL_InformationIE_RL_ReconfPrepTDD */
static int hf_rnsap_rL_Specific_DCH_Info = -1;    /* RL_Specific_DCH_Info */
static int hf_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_max_UL_SIR = -1;              /* UL_SIR */
static int hf_rnsap_min_UL_SIR = -1;              /* UL_SIR */
static int hf_rnsap_dl_CodeInformationList = -1;  /* DL_CodeInformationList_RL_ReconfReadyFDD */
static int hf_rnsap_dCHInformationResponse = -1;  /* DCH_InformationResponseList_RL_ReconfReadyFDD */
static int hf_rnsap_not_Used_dSCHsToBeAddedOrModified = -1;  /* NULL */
static int hf_rnsap_ul_CCTrCH_Information = -1;   /* UL_CCTrCH_InformationList_RL_ReconfReadyTDD */
static int hf_rnsap_dl_CCTrCH_Information = -1;   /* DL_CCTrCH_InformationList_RL_ReconfReadyTDD */
static int hf_rnsap_dCHInformationResponse_01 = -1;  /* DCH_InformationResponseList_RL_ReconfReadyTDD */
static int hf_rnsap_dSCHsToBeAddedOrModified = -1;  /* DSCHToBeAddedOrModified_RL_ReconfReadyTDD */
static int hf_rnsap_uSCHsToBeAddedOrModified = -1;  /* USCHToBeAddedOrModified_RL_ReconfReadyTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item = -1;  /* UL_CCTrCH_InformationItem_RL_ReconfReadyTDD */
static int hf_rnsap_ul_DPCH_AddInformation = -1;  /* UL_DPCH_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_ul_DPCH_ModifyInformation = -1;  /* UL_DPCH_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_ul_DPCH_DeleteInformation = -1;  /* UL_DPCH_InformationDeleteList_RL_ReconfReadyTDD */
static int hf_rnsap_uL_TimeslotLCR_Info = -1;     /* UL_TimeslotLCR_Information */
static int hf_rnsap_rxTimingDeviationForTA = -1;  /* RxTimingDeviationForTA */
static int hf_rnsap_rxTimingDeviationForTA768 = -1;  /* RxTimingDeviationForTA768 */
static int hf_rnsap_uL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;  /* UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_UL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* UL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_tDD_uL_Code_LCR_Information = -1;  /* TDD_UL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_UL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_UL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_uL_Code_Information_01 = -1;  /* TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768_item = -1;  /* UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD768 */
static int hf_rnsap_uL_Code_Information768_01 = -1;  /* TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD768 */
static int hf_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD768_item = -1;  /* TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD768 */
static int hf_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item = -1;  /* UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item = -1;  /* DL_CCTrCH_InformationItem_RL_ReconfReadyTDD */
static int hf_rnsap_dl_DPCH_AddInformation = -1;  /* DL_DPCH_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_dl_DPCH_ModifyInformation = -1;  /* DL_DPCH_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_dl_DPCH_DeleteInformation = -1;  /* DL_DPCH_InformationDeleteList_RL_ReconfReadyTDD */
static int hf_rnsap_dL_TimeslotLCR_Info = -1;     /* DL_TimeslotLCR_Information */
static int hf_rnsap_dL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;  /* DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_DL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* DL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_tDD_dL_Code_LCR_Information = -1;  /* TDD_DL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_DL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_DL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_dL_Code_Information_01 = -1;  /* TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768_item = -1;  /* DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD768 */
static int hf_rnsap_dL_Code_Information768_01 = -1;  /* TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD768 */
static int hf_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD768_item = -1;  /* TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD768 */
static int hf_rnsap_dPCH_ID768 = -1;              /* DPCH_ID768 */
static int hf_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item = -1;  /* DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD */
static int hf_rnsap_DL_DPCH_InformationDeleteList768_RL_ReconfReadyTDD_item = -1;  /* DL_DPCH_InformationDeleteItem768_RL_ReconfReadyTDD */
static int hf_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_item = -1;  /* DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD */
static int hf_rnsap_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_item = -1;  /* USCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD */
static int hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfReadyTDD_item = -1;  /* RL_InformationResponse_RL_ReconfReadyTDD */
static int hf_rnsap_generalCause_04 = -1;         /* GeneralCauseList_RL_ReconfFailure */
static int hf_rnsap_rLSpecificCause_04 = -1;      /* RLSpecificCauseList_RL_ReconfFailure */
static int hf_rnsap_rL_ReconfigurationFailureList_RL_ReconfFailure = -1;  /* RL_ReconfigurationFailureList_RL_ReconfFailure */
static int hf_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DCH_DeleteList_RL_ReconfRqstFDD_item = -1;  /* DCH_DeleteItem_RL_ReconfRqstFDD */
static int hf_rnsap_RL_ReconfigurationRequestFDD_RL_InformationList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DCH_DeleteList_RL_ReconfRqstTDD_item = -1;  /* DCH_DeleteItem_RL_ReconfRqstTDD */
static int hf_rnsap_Multiple_RL_ReconfigurationRequestTDD_RL_Information_item = -1;  /* RL_ReconfigurationRequestTDD_RL_Information */
static int hf_rnsap_RL_InformationResponseList_RL_ReconfRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dCHsInformationResponseList = -1;  /* DCH_InformationResponseList_RL_ReconfRspFDD */
static int hf_rnsap_dL_CodeInformationList_RL_ReconfResp = -1;  /* DL_CodeInformationList_RL_ReconfRspFDD */
static int hf_rnsap_dCHsInformationResponseList_01 = -1;  /* DCH_InformationResponseList_RL_ReconfRspTDD */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_ReconfRspTDD_item = -1;  /* DL_CCTrCH_InformationItem_RL_ReconfRspTDD */
static int hf_rnsap_dl_DPCH_ModifyInformation_LCR = -1;  /* DL_DPCH_InformationModifyList_LCR_RL_ReconfRspTDD */
static int hf_rnsap_dL_Timeslot_LCR_InformationModifyList_RL_ReconfRqstTDD = -1;  /* DL_Timeslot_LCR_InformationModifyList_RL_ReconfRspTDD */
static int hf_rnsap_DL_Timeslot_LCR_InformationModifyList_RL_ReconfRspTDD_item = -1;  /* DL_Timeslot_LCR_InformationModifyItem_RL_ReconfRspTDD */
static int hf_rnsap_maxPowerLCR = -1;             /* DL_Power */
static int hf_rnsap_minPowerLCR = -1;             /* DL_Power */
static int hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfRspTDD_item = -1;  /* RL_InformationResponse_RL_ReconfRspTDD */
static int hf_rnsap_rL = -1;                      /* RL_RL_FailureInd */
static int hf_rnsap_rL_Set = -1;                  /* RL_Set_RL_FailureInd */
static int hf_rnsap_cCTrCH = -1;                  /* CCTrCH_RL_FailureInd */
static int hf_rnsap_rL_InformationList_RL_FailureInd = -1;  /* RL_InformationList_RL_FailureInd */
static int hf_rnsap_RL_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_Set_InformationList_RL_FailureInd = -1;  /* RL_Set_InformationList_RL_FailureInd */
static int hf_rnsap_RL_Set_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_InformationList_RL_FailureInd = -1;  /* CCTrCH_InformationList_RL_FailureInd */
static int hf_rnsap_CCTrCH_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_InformationList_RL_PreemptRequiredInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_01 = -1;                   /* RL_RL_RestoreInd */
static int hf_rnsap_rL_Set_01 = -1;               /* RL_Set_RL_RestoreInd */
static int hf_rnsap_cCTrCH_01 = -1;               /* CCTrCH_RL_RestoreInd */
static int hf_rnsap_rL_InformationList_RL_RestoreInd = -1;  /* RL_InformationList_RL_RestoreInd */
static int hf_rnsap_RL_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_Set_InformationList_RL_RestoreInd = -1;  /* RL_Set_InformationList_RL_RestoreInd */
static int hf_rnsap_RL_Set_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_InformationList_RL_RestoreInd = -1;  /* CCTrCH_InformationList_RL_RestoreInd */
static int hf_rnsap_CCTrCH_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_CodeInformation_03 = -1;   /* DL_CodeInformationList_PhyChReconfRqstFDD */
static int hf_rnsap_ul_CCTrCH_Information_01 = -1;  /* UL_CCTrCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_dl_CCTrCH_Information_01 = -1;  /* DL_CCTrCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item = -1;  /* UL_CCTrCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_ul_DPCH_Information_02 = -1;  /* UL_DPCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_uL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;  /* UL_Timeslot_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_UL_TimeslotLCR_InformationList_PhyChReconfRqstTDD_item = -1;  /* UL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_uL_Code_LCR_Information = -1;  /* TDD_UL_Code_LCR_Information */
static int hf_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD_item = -1;  /* UL_Timeslot_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD768_item = -1;  /* UL_Timeslot_InformationItem_PhyChReconfRqstTDD768 */
static int hf_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item = -1;  /* DL_CCTrCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_dl_DPCH_Information_02 = -1;  /* DL_DPCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_dL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;  /* DL_Timeslot_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_DL_TimeslotLCR_InformationList_PhyChReconfRqstTDD_item = -1;  /* DL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD_item = -1;  /* DL_Timeslot_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD768_item = -1;  /* DL_Timeslot_InformationItem_PhyChReconfRqstTDD768 */
static int hf_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD_item = -1;  /* HSPDSCH_Timeslot_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD_item = -1;  /* HSPDSCH_Timeslot_InformationItemLCR_PhyChReconfRqstTDD */
static int hf_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD768_item = -1;  /* HSPDSCH_Timeslot_InformationItem_PhyChReconfRqstTDD768 */
static int hf_rnsap_RL_InformationList_RL_CongestInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dCH_Rate_Information = -1;    /* DCH_Rate_Information_RL_CongestInd */
static int hf_rnsap_DCH_Rate_Information_RL_CongestInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_allowed_Rate_Information = -1;  /* Allowed_Rate_Information */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_CongestInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_uRA = -1;                     /* URA_PagingRqst */
static int hf_rnsap_cell = -1;                    /* Cell_PagingRqst */
static int hf_rnsap_pagingCause = -1;             /* PagingCause */
static int hf_rnsap_cNDomainType = -1;            /* CNDomainType */
static int hf_rnsap_pagingRecordType = -1;        /* PagingRecordType */
static int hf_rnsap_rL_02 = -1;                   /* RL_DM_Rqst */
static int hf_rnsap_rLS = -1;                     /* RL_Set_DM_Rqst */
static int hf_rnsap_allRL = -1;                   /* All_RL_DM_Rqst */
static int hf_rnsap_allRLS = -1;                  /* All_RL_Set_DM_Rqst */
static int hf_rnsap_rL_InformationList_DM_Rqst = -1;  /* RL_InformationList_DM_Rqst */
static int hf_rnsap_RL_InformationList_DM_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_HSSICH_Info_DM_Rqst_item = -1;  /* HS_SICH_ID */
static int hf_rnsap_rL_Set_InformationList_DM_Rqst = -1;  /* RL_Set_InformationList_DM_Rqst */
static int hf_rnsap_RL_Set_InformationList_DM_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rLs = -1;                     /* RL_DM_Rsp */
static int hf_rnsap_rLS_01 = -1;                  /* RL_Set_DM_Rsp */
static int hf_rnsap_allRL_01 = -1;                /* RL_DM_Rsp */
static int hf_rnsap_allRLS_01 = -1;               /* RL_Set_DM_Rsp */
static int hf_rnsap_rL_InformationList_DM_Rsp = -1;  /* RL_InformationList_DM_Rsp */
static int hf_rnsap_rL_Set_InformationList_DM_Rsp = -1;  /* RL_Set_InformationList_DM_Rsp */
static int hf_rnsap_RL_InformationList_DM_Rsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dedicatedMeasurementValue = -1;  /* DedicatedMeasurementValue */
static int hf_rnsap_RL_Set_InformationList_DM_Rsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_TDD_DM_Rsp */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_LCR_TDD_DM_Rsp */
static int hf_rnsap_Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp_item = -1;  /* Multiple_HSSICHMeasurementValueItem_TDD_DM_Rsp */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_TDD768_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_TDD768_DM_Rsp */
static int hf_rnsap_rL_03 = -1;                   /* RL_DM_Fail */
static int hf_rnsap_rLS_02 = -1;                  /* RL_Set_DM_Fail */
static int hf_rnsap_allRL_02 = -1;                /* RL_DM_Fail */
static int hf_rnsap_allRLS_02 = -1;               /* RL_Set_DM_Fail */
static int hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail = -1;  /* RL_Unsuccessful_InformationRespList_DM_Fail */
static int hf_rnsap_rL_successful_InformationRespList_DM_Fail = -1;  /* RL_Successful_InformationRespList_DM_Fail */
static int hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail = -1;  /* RL_Set_Unsuccessful_InformationRespList_DM_Fail */
static int hf_rnsap_rL_Set_successful_InformationRespList_DM_Fail = -1;  /* RL_Set_Successful_InformationRespList_DM_Fail */
static int hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_individualcause = -1;         /* Cause */
static int hf_rnsap_RL_Successful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_Set_Successful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rLs_01 = -1;                  /* RL_DM_Rprt */
static int hf_rnsap_rLS_03 = -1;                  /* RL_Set_DM_Rprt */
static int hf_rnsap_allRL_03 = -1;                /* RL_DM_Rprt */
static int hf_rnsap_allRLS_03 = -1;               /* RL_Set_DM_Rprt */
static int hf_rnsap_rL_InformationList_DM_Rprt = -1;  /* RL_InformationList_DM_Rprt */
static int hf_rnsap_rL_Set_InformationList_DM_Rprt = -1;  /* RL_Set_InformationList_DM_Rprt */
static int hf_rnsap_RL_InformationList_DM_Rprt_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dedicatedMeasurementValueInformation = -1;  /* DedicatedMeasurementValueInformation */
static int hf_rnsap_RL_Set_InformationList_DM_Rprt_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_04 = -1;                   /* RL_DM_Fail_Ind */
static int hf_rnsap_rLS_04 = -1;                  /* RL_Set_DM_Fail_Ind */
static int hf_rnsap_allRL_04 = -1;                /* RL_DM_Fail_Ind */
static int hf_rnsap_allRLS_04 = -1;               /* RL_Set_DM_Fail_Ind */
static int hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail_Ind = -1;  /* RL_Unsuccessful_InformationRespList_DM_Fail_Ind */
static int hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail_Ind = -1;  /* RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind */
static int hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_fACH_FlowControlInformation = -1;  /* FACH_FlowControlInformation_CTCH_ResourceRspFDD */
static int hf_rnsap_fACH_FlowControlInformation_01 = -1;  /* FACH_FlowControlInformation_CTCH_ResourceRspTDD */
static int hf_rnsap_cell_01 = -1;                 /* Cell_CM_Rqst */
static int hf_rnsap_neighbouringCellMeasurementInformation = -1;  /* NeighbouringCellMeasurementInfo */
static int hf_rnsap_NeighbouringCellMeasurementInfo_item = -1;  /* NeighbouringCellMeasurementInfo_item */
static int hf_rnsap_neighbouringFDDCellMeasurementInformation = -1;  /* NeighbouringFDDCellMeasurementInformation */
static int hf_rnsap_neighbouringTDDCellMeasurementInformation = -1;  /* NeighbouringTDDCellMeasurementInformation */
static int hf_rnsap_extension_neighbouringCellMeasurementInformation = -1;  /* Extension_neighbouringCellMeasurementInformation */
static int hf_rnsap_extension_neighbouringCellMeasurementInformation768 = -1;  /* Extension_neighbouringCellMeasurementInformation768 */
static int hf_rnsap_cell_02 = -1;                 /* Cell_CM_Rsp */
static int hf_rnsap_cell_03 = -1;                 /* Cell_CM_Rprt */
static int hf_rnsap_commonMeasurementValueInformation = -1;  /* CommonMeasurementValueInformation */
static int hf_rnsap_cell_04 = -1;                 /* Cell_InfEx_Rqst */
static int hf_rnsap_extension_InformationExchangeObjectType_InfEx_Rqst = -1;  /* Extension_InformationExchangeObjectType_InfEx_Rqst */
static int hf_rnsap_cell_05 = -1;                 /* Cell_InfEx_Rsp */
static int hf_rnsap_extension_InformationExchangeObjectType_InfEx_Rsp = -1;  /* Extension_InformationExchangeObjectType_InfEx_Rsp */
static int hf_rnsap_MBMS_Bearer_Service_List_InfEx_Rsp_item = -1;  /* MBMS_Bearer_ServiceItemIEs_InfEx_Rsp */
static int hf_rnsap_cell_06 = -1;                 /* Cell_InfEx_Rprt */
static int hf_rnsap_requestedDataValueInformation = -1;  /* RequestedDataValueInformation */
static int hf_rnsap_context = -1;                 /* ContextList_Reset */
static int hf_rnsap_all_contexts = -1;            /* NULL */
static int hf_rnsap_contextGroup = -1;            /* ContextGroupList_Reset */
static int hf_rnsap_contextInfoList_Reset = -1;   /* ContextInfoList_Reset */
static int hf_rnsap_ContextInfoList_Reset_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_contextType_Reset = -1;       /* ContextType_Reset */
static int hf_rnsap_dRNTI = -1;                   /* D_RNTI */
static int hf_rnsap_contextGroupInfoList_Reset = -1;  /* ContextGroupInfoList_Reset */
static int hf_rnsap_ContextGroupInfoList_Reset_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_s_RNTI_Group = -1;            /* S_RNTI_Group */
static int hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_delayed_activation_update = -1;  /* DelayedActivationUpdate */
static int hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_ParameterUpdateIndicationFDD_RL_InformationList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_phase_Reference_Update_Indicator = -1;  /* Phase_Reference_Update_Indicator */
static int hf_rnsap_ListOfInterfacesToTrace_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_interface = -1;               /* T_interface */
static int hf_rnsap_privateIEs = -1;              /* PrivateIE_Container */
static int hf_rnsap_initiatingMessage = -1;       /* InitiatingMessage */
static int hf_rnsap_successfulOutcome = -1;       /* SuccessfulOutcome */
static int hf_rnsap_unsuccessfulOutcome = -1;     /* UnsuccessfulOutcome */
static int hf_rnsap_outcome = -1;                 /* Outcome */
static int hf_rnsap_value_02 = -1;                /* InitiatingMessage_value */
static int hf_rnsap_value_03 = -1;                /* SuccessfulOutcome_value */
static int hf_rnsap_value_04 = -1;                /* UnsuccessfulOutcome_value */
static int hf_rnsap_value_05 = -1;                /* Outcome_value */

/*--- End of included file: packet-rnsap-hf.c ---*/
#line 67 "packet-rnsap-template.c"

/* Initialize the subtree pointers */
static int ett_rnsap = -1;


/*--- Included file: packet-rnsap-ett.c ---*/
#line 1 "packet-rnsap-ett.c"
static gint ett_rnsap_PrivateIE_ID = -1;
static gint ett_rnsap_ProcedureID = -1;
static gint ett_rnsap_TransactionID = -1;
static gint ett_rnsap_ProtocolIE_Container = -1;
static gint ett_rnsap_ProtocolIE_Field = -1;
static gint ett_rnsap_ProtocolExtensionContainer = -1;
static gint ett_rnsap_ProtocolExtensionField = -1;
static gint ett_rnsap_PrivateIE_Container = -1;
static gint ett_rnsap_PrivateIE_Field = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListFDD = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListTDD = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL = -1;
static gint ett_rnsap_Active_Pattern_Sequence_Information = -1;
static gint ett_rnsap_AdditionalPreferredFrequency = -1;
static gint ett_rnsap_AdditionalPreferredFrequencyItem = -1;
static gint ett_rnsap_AffectedUEInformationForMBMS = -1;
static gint ett_rnsap_AllocationRetentionPriority = -1;
static gint ett_rnsap_Allowed_Rate_Information = -1;
static gint ett_rnsap_Angle_Of_Arrival_Value_LCR = -1;
static gint ett_rnsap_BadSatellites = -1;
static gint ett_rnsap_T_badSatelliteInformation = -1;
static gint ett_rnsap_T_badSatelliteInformation_item = -1;
static gint ett_rnsap_BSIC = -1;
static gint ett_rnsap_BurstModeParameters = -1;
static gint ett_rnsap_Cause = -1;
static gint ett_rnsap_Cell_Capacity_Class_Value = -1;
static gint ett_rnsap_CGI = -1;
static gint ett_rnsap_T_lAI = -1;
static gint ett_rnsap_CommonMeasurementAccuracy = -1;
static gint ett_rnsap_CommonMeasurementValue = -1;
static gint ett_rnsap_CommonMeasurementValueInformation = -1;
static gint ett_rnsap_CommonMeasurementAvailable = -1;
static gint ett_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information = -1;
static gint ett_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify = -1;
static gint ett_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information = -1;
static gint ett_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_InformationItem = -1;
static gint ett_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response = -1;
static gint ett_rnsap_CorrespondingCells = -1;
static gint ett_rnsap_CPC_Information = -1;
static gint ett_rnsap_CriticalityDiagnostics = -1;
static gint ett_rnsap_CriticalityDiagnostics_IE_List = -1;
static gint ett_rnsap_CriticalityDiagnostics_IE_List_item = -1;
static gint ett_rnsap_MessageStructure = -1;
static gint ett_rnsap_MessageStructure_item = -1;
static gint ett_rnsap_CN_CS_DomainIdentifier = -1;
static gint ett_rnsap_CN_PS_DomainIdentifier = -1;
static gint ett_rnsap_DCH_FDD_Information = -1;
static gint ett_rnsap_DCH_FDD_InformationItem = -1;
static gint ett_rnsap_DCH_Specific_FDD_InformationList = -1;
static gint ett_rnsap_DCH_Specific_FDD_Item = -1;
static gint ett_rnsap_DCH_InformationResponse = -1;
static gint ett_rnsap_DCH_InformationResponseItem = -1;
static gint ett_rnsap_DCH_TDD_Information = -1;
static gint ett_rnsap_DCH_TDD_InformationItem = -1;
static gint ett_rnsap_DCH_Specific_TDD_InformationList = -1;
static gint ett_rnsap_DCH_Specific_TDD_Item = -1;
static gint ett_rnsap_DedicatedMeasurementValue = -1;
static gint ett_rnsap_DedicatedMeasurementValueInformation = -1;
static gint ett_rnsap_DedicatedMeasurementAvailable = -1;
static gint ett_rnsap_DelayedActivation = -1;
static gint ett_rnsap_DelayedActivationUpdate = -1;
static gint ett_rnsap_Activate_Info = -1;
static gint ett_rnsap_Deactivate_Info = -1;
static gint ett_rnsap_Execution_Type = -1;
static gint ett_rnsap_DGANSSCorrections = -1;
static gint ett_rnsap_T_dGANSS_Information = -1;
static gint ett_rnsap_T_dGANSS_Information_item = -1;
static gint ett_rnsap_T_dGANSS_SignalInformation = -1;
static gint ett_rnsap_T_dGANSS_SignalInformation_item = -1;
static gint ett_rnsap_DGANSSThreshold = -1;
static gint ett_rnsap_DGPSCorrections = -1;
static gint ett_rnsap_T_satellite_DGPSCorrections_Information = -1;
static gint ett_rnsap_T_satellite_DGPSCorrections_Information_item = -1;
static gint ett_rnsap_DGPSThreshold = -1;
static gint ett_rnsap_DL_PowerBalancing_Information = -1;
static gint ett_rnsap_DL_ReferencePowerInformationList = -1;
static gint ett_rnsap_DL_ReferencePowerInformationItem = -1;
static gint ett_rnsap_DL_ReferencePowerInformation = -1;
static gint ett_rnsap_DL_Timeslot_Information = -1;
static gint ett_rnsap_DL_Timeslot_InformationItem = -1;
static gint ett_rnsap_DL_TimeslotLCR_Information = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationItem = -1;
static gint ett_rnsap_DL_Timeslot_Information768 = -1;
static gint ett_rnsap_DL_Timeslot_InformationItem768 = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_Info = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_InfoItem = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_LCR_Information = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_LCR_InfoItem = -1;
static gint ett_rnsap_DRX_Information = -1;
static gint ett_rnsap_DRX_Information_to_Modify = -1;
static gint ett_rnsap_DRX_Information_to_Modify_Items = -1;
static gint ett_rnsap_DSCH_FlowControlInformation = -1;
static gint ett_rnsap_DSCH_FlowControlItem = -1;
static gint ett_rnsap_DSCH_TDD_Information = -1;
static gint ett_rnsap_DSCH_TDD_InformationItem = -1;
static gint ett_rnsap_DTX_Cycle_2ms_Items = -1;
static gint ett_rnsap_DTX_Cycle_2ms_to_Modify_Items = -1;
static gint ett_rnsap_DTX_Cycle_10ms_Items = -1;
static gint ett_rnsap_DTX_Cycle_10ms_to_Modify_Items = -1;
static gint ett_rnsap_DTX_Information = -1;
static gint ett_rnsap_DTX_Information_to_Modify = -1;
static gint ett_rnsap_DTX_Information_to_Modify_Items = -1;
static gint ett_rnsap_EDCH_FDD_DL_ControlChannelInformation = -1;
static gint ett_rnsap_EDCH_FDD_Information = -1;
static gint ett_rnsap_EDCH_FDD_InformationResponse = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InformationResponse = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InformationResponseItem = -1;
static gint ett_rnsap_EDCH_FDD_Information_To_Modify = -1;
static gint ett_rnsap_E_DCH_FDD_Update_Information = -1;
static gint ett_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation = -1;
static gint ett_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation_Item = -1;
static gint ett_rnsap_E_DCH_Grant_Type_Information = -1;
static gint ett_rnsap_E_DCH_LogicalChannelInformation = -1;
static gint ett_rnsap_E_DCH_LogicalChannelInformationItem = -1;
static gint ett_rnsap_E_DCH_MACdPDU_SizeList = -1;
static gint ett_rnsap_E_DCH_MACdPDU_SizeListItem = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToModify = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToModifyItem = -1;
static gint ett_rnsap_E_DCH_MACdPDU_SizeToModifyList = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToDelete = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToDeleteItem = -1;
static gint ett_rnsap_EDCH_MACdFlows_Information = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoList = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoItem = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoToModifyItem = -1;
static gint ett_rnsap_EDCH_MACdFlows_To_Delete = -1;
static gint ett_rnsap_EDCH_MACdFlows_To_Delete_Item = -1;
static gint ett_rnsap_E_DCH_Non_Scheduled_Transmission_Grant_Items = -1;
static gint ett_rnsap_E_DCH_Serving_cell_change_informationResponse = -1;
static gint ett_rnsap_E_DCH_serving_cell_change_choice = -1;
static gint ett_rnsap_E_DCH_serving_cell_change_successful = -1;
static gint ett_rnsap_E_DCH_RL_InformationList_Rsp = -1;
static gint ett_rnsap_E_DCH_RL_InformationList_Rsp_Item = -1;
static gint ett_rnsap_E_DCH_serving_cell_change_unsuccessful = -1;
static gint ett_rnsap_E_DCH_TTI_Length = -1;
static gint ett_rnsap_E_DCH_TTI_Length_to_Modify = -1;
static gint ett_rnsap_EDPCH_Information_FDD = -1;
static gint ett_rnsap_EDPCH_Information_RLReconfPrepare_FDD = -1;
static gint ett_rnsap_EDPCH_Information_RLReconfRequest_FDD = -1;
static gint ett_rnsap_EDCH_Serving_RL = -1;
static gint ett_rnsap_EDCH_Serving_RL_in_this_DRNS = -1;
static gint ett_rnsap_Enhanced_FACH_Information_ResponseFDD = -1;
static gint ett_rnsap_E_TFCS_Information = -1;
static gint ett_rnsap_EventA = -1;
static gint ett_rnsap_EventB = -1;
static gint ett_rnsap_EventC = -1;
static gint ett_rnsap_EventD = -1;
static gint ett_rnsap_EventE = -1;
static gint ett_rnsap_EventF = -1;
static gint ett_rnsap_E_DCH_Information = -1;
static gint ett_rnsap_E_PUCH_Information = -1;
static gint ett_rnsap_E_TFCS_Information_TDD = -1;
static gint ett_rnsap_E_DCH_QPSK_RefBetaInfo = -1;
static gint ett_rnsap_E_DCH_sixteenQAM_RefBetaInfo = -1;
static gint ett_rnsap_E_DCH_RefBeta_Item = -1;
static gint ett_rnsap_E_DCH_MACdFlows_Information_TDD = -1;
static gint ett_rnsap_E_DCH_MACdFlow_InfoTDDItem = -1;
static gint ett_rnsap_E_DCH_TDD_Information = -1;
static gint ett_rnsap_E_DCH_Information_Reconfig = -1;
static gint ett_rnsap_E_DCH_TDD_Information_to_Modify = -1;
static gint ett_rnsap_E_DCH_TDD_Information_to_Modify_List = -1;
static gint ett_rnsap_E_DCH_MACdFlow_ModifyTDDItem = -1;
static gint ett_rnsap_E_DCH_Information_Response = -1;
static gint ett_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp = -1;
static gint ett_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp_Item = -1;
static gint ett_rnsap_E_AGCH_Specific_InformationRespListTDD = -1;
static gint ett_rnsap_E_AGCH_Specific_InformationResp_ItemTDD = -1;
static gint ett_rnsap_E_HICH_InformationResp = -1;
static gint ett_rnsap_E_DCH_Non_Scheduled_Grant_Info = -1;
static gint ett_rnsap_E_DCH_768_Information = -1;
static gint ett_rnsap_E_DCH_TDD_Information768 = -1;
static gint ett_rnsap_E_DCH_768_Information_Reconfig = -1;
static gint ett_rnsap_E_DCH_768_Information_Response = -1;
static gint ett_rnsap_E_AGCH_Specific_InformationRespList768TDD = -1;
static gint ett_rnsap_E_AGCH_Specific_InformationResp_Item768TDD = -1;
static gint ett_rnsap_E_HICH_InformationResp768 = -1;
static gint ett_rnsap_E_DCH_Non_Scheduled_Grant_Info768 = -1;
static gint ett_rnsap_E_DCH_LCR_Information = -1;
static gint ett_rnsap_E_PUCH_LCR_Information = -1;
static gint ett_rnsap_E_DCH_LCR_TDD_Information = -1;
static gint ett_rnsap_E_DCH_LCR_Information_Reconfig = -1;
static gint ett_rnsap_E_DCH_LCR_Information_Response = -1;
static gint ett_rnsap_E_AGCH_Specific_InformationRespList_LCR_TDD = -1;
static gint ett_rnsap_E_AGCH_Specific_InformationResp_Item_LCR_TDD = -1;
static gint ett_rnsap_E_HICH_Specific_InformationResp_LCR = -1;
static gint ett_rnsap_E_HICH_Scheduled_InformationRespList_LCR_TDD = -1;
static gint ett_rnsap_E_HICH_Scheduled_InformationResp_Item_LCR_TDD = -1;
static gint ett_rnsap_E_HICH_InformationResp_LCR = -1;
static gint ett_rnsap_E_DCH_Non_Scheduled_Grant_Info_LCR = -1;
static gint ett_rnsap_FACH_FlowControlInformation = -1;
static gint ett_rnsap_FACH_FlowControlInformationItem = -1;
static gint ett_rnsap_FACH_InformationList = -1;
static gint ett_rnsap_FACH_InformationItem = -1;
static gint ett_rnsap_FDD_DCHs_to_Modify = -1;
static gint ett_rnsap_FDD_DCHs_to_ModifyItem = -1;
static gint ett_rnsap_FDD_DCHs_to_ModifySpecificInformationList = -1;
static gint ett_rnsap_FDD_DCHs_to_ModifySpecificItem = -1;
static gint ett_rnsap_FDD_DL_CodeInformation = -1;
static gint ett_rnsap_FDD_DL_CodeInformationItem = -1;
static gint ett_rnsap_FPACH_Information = -1;
static gint ett_rnsap_GA_Cell = -1;
static gint ett_rnsap_GA_Cell_item = -1;
static gint ett_rnsap_GA_CellAdditionalShapes = -1;
static gint ett_rnsap_GA_AltitudeAndDirection = -1;
static gint ett_rnsap_GA_EllipsoidArc = -1;
static gint ett_rnsap_GANSS_Almanac = -1;
static gint ett_rnsap_T_gANSS_AlmanacModel = -1;
static gint ett_rnsap_T_gANSS_keplerianParameters = -1;
static gint ett_rnsap_GANSS_Clock_Model = -1;
static gint ett_rnsap_GANSS_Clock_Model_item = -1;
static gint ett_rnsap_GANSS_Common_Data = -1;
static gint ett_rnsap_GANSS_CommonDataInfoReq = -1;
static gint ett_rnsap_GANSS_GenericDataInfoReqList = -1;
static gint ett_rnsap_GANSS_GenericDataInfoReqItem = -1;
static gint ett_rnsap_GANSS_Generic_Data = -1;
static gint ett_rnsap_GANSS_Generic_DataItem = -1;
static gint ett_rnsap_GANSS_Information = -1;
static gint ett_rnsap_GANSS_Ionospheric_Model = -1;
static gint ett_rnsap_GANSS_IonosphereRegionalStormFlags = -1;
static gint ett_rnsap_GANSS_Navigation_Model = -1;
static gint ett_rnsap_GANSS_Orbit_Model = -1;
static gint ett_rnsap_T_gANSS_keplerianParameters_01 = -1;
static gint ett_rnsap_GANSS_Real_Time_Integrity = -1;
static gint ett_rnsap_GANSS_Real_Time_Integrity_item = -1;
static gint ett_rnsap_GANSS_Reference_Time = -1;
static gint ett_rnsap_GANSS_RX_Pos = -1;
static gint ett_rnsap_GANSS_SatelliteInformationKP = -1;
static gint ett_rnsap_GANSS_SatelliteInformationKP_item = -1;
static gint ett_rnsap_GANSS_Sat_Info_Nav = -1;
static gint ett_rnsap_GANSS_Sat_Info_Nav_item = -1;
static gint ett_rnsap_GANSS_Time_Model = -1;
static gint ett_rnsap_GANSS_UTC_Model = -1;
static gint ett_rnsap_GA_PointWithAltitude = -1;
static gint ett_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid = -1;
static gint ett_rnsap_GA_PointWithUnCertaintyEllipse = -1;
static gint ett_rnsap_GA_UncertaintyEllipse = -1;
static gint ett_rnsap_GA_PointWithUnCertainty = -1;
static gint ett_rnsap_GA_AccessPointPosition = -1;
static gint ett_rnsap_GeographicalCoordinate = -1;
static gint ett_rnsap_GERAN_SI_Type = -1;
static gint ett_rnsap_GERAN_SystemInfo = -1;
static gint ett_rnsap_GERAN_SystemInfo_item = -1;
static gint ett_rnsap_GPS_Almanac = -1;
static gint ett_rnsap_T_satellite_Almanac_Information = -1;
static gint ett_rnsap_T_satellite_Almanac_Information_item = -1;
static gint ett_rnsap_Satellite_Almanac_Information_ExtItem = -1;
static gint ett_rnsap_Satellite_Almanac_Information_ExtItem_item = -1;
static gint ett_rnsap_GPSInformation = -1;
static gint ett_rnsap_GPSInformation_item = -1;
static gint ett_rnsap_GPS_Ionospheric_Model = -1;
static gint ett_rnsap_GPS_NavigationModel_and_TimeRecovery = -1;
static gint ett_rnsap_GPS_NavigationModel_and_TimeRecovery_item = -1;
static gint ett_rnsap_GPS_RealTime_Integrity = -1;
static gint ett_rnsap_GPS_RX_POS = -1;
static gint ett_rnsap_GPS_UTC_Model = -1;
static gint ett_rnsap_Guaranteed_Rate_Information = -1;
static gint ett_rnsap_HARQ_MemoryPartitioning = -1;
static gint ett_rnsap_HARQ_MemoryPartitioning_Implicit = -1;
static gint ett_rnsap_HARQ_MemoryPartitioning_Explicit = -1;
static gint ett_rnsap_HARQ_MemoryPartitioningList = -1;
static gint ett_rnsap_HARQ_MemoryPartitioningItem = -1;
static gint ett_rnsap_HSDSCH_FDD_Information = -1;
static gint ett_rnsap_HSDSCH_FDD_Information_Response = -1;
static gint ett_rnsap_HSDSCH_Information_to_Modify = -1;
static gint ett_rnsap_HSDSCH_Information_to_Modify_Unsynchronised = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_to_Modify = -1;
static gint ett_rnsap_HSDSCH_MACdFlows_Information = -1;
static gint ett_rnsap_HSDSCH_MACdFlows_to_Delete = -1;
static gint ett_rnsap_HSDSCH_MACdFlows_to_Delete_Item = -1;
static gint ett_rnsap_HSDSCH_Initial_Capacity_Allocation = -1;
static gint ett_rnsap_HSDSCH_Initial_Capacity_AllocationItem = -1;
static gint ett_rnsap_HS_DSCH_serving_cell_change_information = -1;
static gint ett_rnsap_HS_DSCH_serving_cell_change_informationResponse = -1;
static gint ett_rnsap_HS_DSCH_serving_cell_change_choice = -1;
static gint ett_rnsap_HS_serving_cell_change_successful = -1;
static gint ett_rnsap_HS_serving_cell_change_unsuccessful = -1;
static gint ett_rnsap_HSDSCH_TDD_Information = -1;
static gint ett_rnsap_HSDSCH_TDD_Information_Response = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response_LCR = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response768 = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response768 = -1;
static gint ett_rnsap_HSSCCH_FDD_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSSCCH_FDD_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response_LCR = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response768 = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response768 = -1;
static gint ett_rnsap_HSSICH_Info = -1;
static gint ett_rnsap_HSSICH_InfoLCR = -1;
static gint ett_rnsap_HSSICH_Info768 = -1;
static gint ett_rnsap_HS_SICH_Reception_Quality_Value = -1;
static gint ett_rnsap_HSDSCH_FDD_Update_Information = -1;
static gint ett_rnsap_HSDSCH_TDD_Update_Information = -1;
static gint ett_rnsap_InformationAvailable = -1;
static gint ett_rnsap_InformationReportCharacteristics = -1;
static gint ett_rnsap_InformationReportPeriodicity = -1;
static gint ett_rnsap_InformationThreshold = -1;
static gint ett_rnsap_InformationType = -1;
static gint ett_rnsap_IPDLParameters = -1;
static gint ett_rnsap_Inter_Frequency_Cell_List = -1;
static gint ett_rnsap_Inter_Frequency_Cell = -1;
static gint ett_rnsap_Inter_Frequency_Cell_Information = -1;
static gint ett_rnsap_Inter_Frequency_Cell_Information_SIB11 = -1;
static gint ett_rnsap_Inter_Frequency_Cell_Information_SIB12 = -1;
static gint ett_rnsap_Inter_Frequency_Cells_Information_SIB11_Per_Indication = -1;
static gint ett_rnsap_Inter_Frequency_Cells_Information_SIB12_Per_Indication = -1;
static gint ett_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12_List = -1;
static gint ett_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12 = -1;
static gint ett_rnsap_IPDL_FDD_Parameters = -1;
static gint ett_rnsap_IPDL_TDD_Parameters = -1;
static gint ett_rnsap_IPDL_TDD_ParametersLCR = -1;
static gint ett_rnsap_LoadValue = -1;
static gint ett_rnsap_MAC_c_sh_SDU_LengthList = -1;
static gint ett_rnsap_MACdPDU_Size_IndexList = -1;
static gint ett_rnsap_MACdPDU_Size_IndexItem = -1;
static gint ett_rnsap_MACdPDU_Size_IndexList_to_Modify = -1;
static gint ett_rnsap_MACdPDU_Size_IndexItem_to_Modify = -1;
static gint ett_rnsap_MBMS_Bearer_Service_Full_Address = -1;
static gint ett_rnsap_MBMS_Bearer_Service_List = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemFDD = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemFDD_PFL = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemTDD = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemTDD_PFL = -1;
static gint ett_rnsap_MBMSChannelTypeInfo = -1;
static gint ett_rnsap_MBMSChannelTypeCellList = -1;
static gint ett_rnsap_MBMSPreferredFreqLayerInfo = -1;
static gint ett_rnsap_MeasurementIncreaseDecreaseThreshold = -1;
static gint ett_rnsap_MeasurementThreshold = -1;
static gint ett_rnsap_MidambleShiftAndBurstType = -1;
static gint ett_rnsap_Type1 = -1;
static gint ett_rnsap_MidambleAllocationMode1 = -1;
static gint ett_rnsap_Type2 = -1;
static gint ett_rnsap_MidambleAllocationMode2 = -1;
static gint ett_rnsap_Type3 = -1;
static gint ett_rnsap_MidambleAllocationMode3 = -1;
static gint ett_rnsap_MidambleShiftLCR = -1;
static gint ett_rnsap_MidambleShiftAndBurstType768 = -1;
static gint ett_rnsap_Type7681 = -1;
static gint ett_rnsap_MidambleAllocationMode7681 = -1;
static gint ett_rnsap_Type7682 = -1;
static gint ett_rnsap_MidambleAllocationMode7682 = -1;
static gint ett_rnsap_Type7683 = -1;
static gint ett_rnsap_MidambleAllocationMode7683 = -1;
static gint ett_rnsap_MIMO_Information = -1;
static gint ett_rnsap_MIMO_InformationResponse = -1;
static gint ett_rnsap_MIMO_InformationToModify = -1;
static gint ett_rnsap_MIMO_PilotConfiguration = -1;
static gint ett_rnsap_ModifyPriorityQueue = -1;
static gint ett_rnsap_NACC_Related_Data = -1;
static gint ett_rnsap_Neighbouring_UMTS_CellInformation = -1;
static gint ett_rnsap_Neighbouring_UMTS_CellInformationItem = -1;
static gint ett_rnsap_Neighbouring_FDD_CellInformation = -1;
static gint ett_rnsap_Neighbouring_FDD_CellInformationItem = -1;
static gint ett_rnsap_NeighbouringFDDCellMeasurementInformation = -1;
static gint ett_rnsap_Neighbouring_GSM_CellInformationIEs = -1;
static gint ett_rnsap_Neighbouring_GSM_CellInformationItem = -1;
static gint ett_rnsap_Neighbouring_TDD_CellInformation = -1;
static gint ett_rnsap_Neighbouring_TDD_CellInformationItem = -1;
static gint ett_rnsap_NeighbouringTDDCellMeasurementInformation = -1;
static gint ett_rnsap_NeighbouringTDDCellMeasurementInformationLCR = -1;
static gint ett_rnsap_NeighbouringTDDCellMeasurementInformation768 = -1;
static gint ett_rnsap_Neighbouring_LCR_TDD_CellInformation = -1;
static gint ett_rnsap_Neighbouring_LCR_TDD_CellInformationItem = -1;
static gint ett_rnsap_NotProvidedCellList = -1;
static gint ett_rnsap_NRTLoadInformationValue = -1;
static gint ett_rnsap_OnModification = -1;
static gint ett_rnsap_OnModificationInformation = -1;
static gint ett_rnsap_PCH_InformationList = -1;
static gint ett_rnsap_PCH_InformationItem = -1;
static gint ett_rnsap_Periodic = -1;
static gint ett_rnsap_PeriodicInformation = -1;
static gint ett_rnsap_Permanent_NAS_UE_Identity = -1;
static gint ett_rnsap_PreferredFrequencyLayerInfo = -1;
static gint ett_rnsap_PriorityQueue_InfoList = -1;
static gint ett_rnsap_PriorityQueue_InfoItem = -1;
static gint ett_rnsap_PriorityQueue_InfoList_EnhancedFACH = -1;
static gint ett_rnsap_PriorityQueue_InfoItem_EnhancedFACH = -1;
static gint ett_rnsap_PriorityQueue_InfoList_to_Modify = -1;
static gint ett_rnsap_PriorityQueue_InfoItem_to_Add = -1;
static gint ett_rnsap_PriorityQueue_InfoItem_to_Modify = -1;
static gint ett_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised = -1;
static gint ett_rnsap_PriorityQueue_InfoItem_to_Modify_Unsynchronised = -1;
static gint ett_rnsap_ProvidedInformation = -1;
static gint ett_rnsap_PTMCellList = -1;
static gint ett_rnsap_PTPCellList = -1;
static gint ett_rnsap_RB_Info = -1;
static gint ett_rnsap_Reference_E_TFCI_Information = -1;
static gint ett_rnsap_Reference_E_TFCI_Information_Item = -1;
static gint ett_rnsap_ReportCharacteristics = -1;
static gint ett_rnsap_ReportPeriodicity = -1;
static gint ett_rnsap_RequestedDataValue = -1;
static gint ett_rnsap_RequestedDataValueInformation = -1;
static gint ett_rnsap_RL_Specific_DCH_Info = -1;
static gint ett_rnsap_RL_Specific_DCH_Info_Item = -1;
static gint ett_rnsap_RL_Specific_EDCH_Information = -1;
static gint ett_rnsap_RL_Specific_EDCH_Info = -1;
static gint ett_rnsap_RL_Specific_EDCH_InfoItem = -1;
static gint ett_rnsap_RTLoadValue = -1;
static gint ett_rnsap_SAI = -1;
static gint ett_rnsap_Secondary_CCPCH_Info_TDD = -1;
static gint ett_rnsap_Secondary_CPICH_Information = -1;
static gint ett_rnsap_Secondary_CPICH_Information_Change = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_Info_TDD = -1;
static gint ett_rnsap_Secondary_CCPCH_Info_TDD768 = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_InformationList = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_InformationItem = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_InformationList = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_InformationItem = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_InformationList768 = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_InformationItem768 = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_Code_Information = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_Code_InformationItem = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_Code_InformationItem = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_Code_Information768 = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_Code_InformationItem768 = -1;
static gint ett_rnsap_GA_AccessPointPositionwithOptionalAltitude = -1;
static gint ett_rnsap_SFNSFNMeasurementThresholdInformation = -1;
static gint ett_rnsap_SFNSFNMeasurementValueInformation = -1;
static gint ett_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;
static gint ett_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;
static gint ett_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;
static gint ett_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;
static gint ett_rnsap_SFNSFNTimeStampInformation = -1;
static gint ett_rnsap_SFNSFNTimeStamp_TDD = -1;
static gint ett_rnsap_SFNSFNValue = -1;
static gint ett_rnsap_SixteenQAM_UL_Information = -1;
static gint ett_rnsap_SixteenQAM_UL_Information_to_Modify = -1;
static gint ett_rnsap_SNA_Information = -1;
static gint ett_rnsap_ListOfSNAs = -1;
static gint ett_rnsap_S_RNTI_Group = -1;
static gint ett_rnsap_SynchronisationConfiguration = -1;
static gint ett_rnsap_SYNC_UL_ProcParameters = -1;
static gint ett_rnsap_TDD_ChannelisationCodeLCR = -1;
static gint ett_rnsap_TDD_DCHs_to_Modify = -1;
static gint ett_rnsap_TDD_DCHs_to_ModifyItem = -1;
static gint ett_rnsap_TDD_DCHs_to_ModifySpecificInformationList = -1;
static gint ett_rnsap_TDD_DCHs_to_ModifySpecificItem = -1;
static gint ett_rnsap_TDD_DL_Code_Information = -1;
static gint ett_rnsap_TDD_DL_Code_InformationItem = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_Information = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_InformationItem = -1;
static gint ett_rnsap_TDD_DL_Code_Information768 = -1;
static gint ett_rnsap_TDD_DL_Code_InformationItem768 = -1;
static gint ett_rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR = -1;
static gint ett_rnsap_TDD_DPCHOffset = -1;
static gint ett_rnsap_TDD_UL_Code_Information = -1;
static gint ett_rnsap_TDD_UL_Code_InformationItem = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_Information = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_InformationItem = -1;
static gint ett_rnsap_TDD_UL_Code_Information768 = -1;
static gint ett_rnsap_TDD_UL_Code_InformationItem768 = -1;
static gint ett_rnsap_TDD_UL_DPCH_TimeSlotFormat_LCR = -1;
static gint ett_rnsap_TMGI = -1;
static gint ett_rnsap_TnlQos = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Information = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Information_item = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item = -1;
static gint ett_rnsap_TUTRANGANSS = -1;
static gint ett_rnsap_TUTRANGANSSMeasurementThresholdInformation = -1;
static gint ett_rnsap_TUTRANGANSSMeasurementValueInformation = -1;
static gint ett_rnsap_TUTRANGPS = -1;
static gint ett_rnsap_TUTRANGPSMeasurementThresholdInformation = -1;
static gint ett_rnsap_TUTRANGPSMeasurementValueInformation = -1;
static gint ett_rnsap_TransportFormatCombination_Beta = -1;
static gint ett_rnsap_T_signalledGainFactors = -1;
static gint ett_rnsap_TFCS = -1;
static gint ett_rnsap_T_tFCSvalues = -1;
static gint ett_rnsap_TFCS_TFCSList = -1;
static gint ett_rnsap_TFCS_TFCSList_item = -1;
static gint ett_rnsap_TFCS_CTFC = -1;
static gint ett_rnsap_TransportFormatSet = -1;
static gint ett_rnsap_TransportFormatSet_DynamicPartList = -1;
static gint ett_rnsap_TransportFormatSet_DynamicPartList_item = -1;
static gint ett_rnsap_TransportFormatSet_ModeDP = -1;
static gint ett_rnsap_TDD_TransportFormatSet_ModeDP = -1;
static gint ett_rnsap_TransmissionTimeIntervalInformation = -1;
static gint ett_rnsap_TransmissionTimeIntervalInformation_item = -1;
static gint ett_rnsap_TransportFormatSet_Semi_staticPart = -1;
static gint ett_rnsap_TransportFormatSet_ModeSSP = -1;
static gint ett_rnsap_UE_Capabilities_Info = -1;
static gint ett_rnsap_UEIdentity = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristics = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent1h = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent1i = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6a = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6b = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6c = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6d = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsPeriodic = -1;
static gint ett_rnsap_UEMeasurementThreshold = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoHCR = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoHCR_IEs = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoLCR = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoLCR_IEs = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfo768 = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfo768_IEs = -1;
static gint ett_rnsap_UEMeasurementValue = -1;
static gint ett_rnsap_UE_MeasurementValue_UE_Transmitted_Power = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListHCR = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListHCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListLCR = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListLCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerList768 = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerList768_IEs = -1;
static gint ett_rnsap_UE_MeasurementValue_Primary_CCPCH_RSCP = -1;
static gint ett_rnsap_UE_MeasurementValue_DL_Timeslot_ISCP = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListHCR = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListHCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListLCR = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListLCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPList768 = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPList768_IEs = -1;
static gint ett_rnsap_UEMeasurementValueInformation = -1;
static gint ett_rnsap_UEMeasurementValueInformationAvailable = -1;
static gint ett_rnsap_UE_State = -1;
static gint ett_rnsap_Cell_Fach_Pch_State = -1;
static gint ett_rnsap_Ura_Pch_State = -1;
static gint ett_rnsap_UL_Timeslot_Information = -1;
static gint ett_rnsap_UL_Timeslot_InformationItem = -1;
static gint ett_rnsap_UL_TimeslotLCR_Information = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationItem = -1;
static gint ett_rnsap_PLCCHinformation = -1;
static gint ett_rnsap_UL_Timeslot_Information768 = -1;
static gint ett_rnsap_UL_Timeslot_InformationItem768 = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_Info = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_InfoItem = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_LCR_Info = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_LCR_InfoItem = -1;
static gint ett_rnsap_UL_TimingAdvanceCtrl_LCR = -1;
static gint ett_rnsap_UC_ID = -1;
static gint ett_rnsap_UL_ScramblingCode = -1;
static gint ett_rnsap_UL_Synchronisation_Parameters_LCR = -1;
static gint ett_rnsap_URA_Information = -1;
static gint ett_rnsap_RNCsWithCellsInTheAccessedURA_List = -1;
static gint ett_rnsap_RNCsWithCellsInTheAccessedURA_Item = -1;
static gint ett_rnsap_USCH_Information = -1;
static gint ett_rnsap_USCH_InformationItem = -1;
static gint ett_rnsap_RadioLinkSetupRequestFDD = -1;
static gint ett_rnsap_UL_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_rnsap_DL_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_RL_SetupRqstFDD = -1;
static gint ett_rnsap_RL_InformationList_RL_SetupRqstFDD = -1;
static gint ett_rnsap_RL_InformationItem_RL_SetupRqstFDD = -1;
static gint ett_rnsap_F_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_F_DPCH_RL_SetupRqstFDD = -1;
static gint ett_rnsap_RadioLinkSetupRequestTDD = -1;
static gint ett_rnsap_UL_Physical_Channel_Information_RL_SetupRqstTDD = -1;
static gint ett_rnsap_DL_Physical_Channel_Information_RL_SetupRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD = -1;
static gint ett_rnsap_CCTrCH_TPCItem_RL_SetupRqstTDD = -1;
static gint ett_rnsap_RL_Information_RL_SetupRqstTDD = -1;
static gint ett_rnsap_RadioLinkSetupResponseFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_SetupRspFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_SetupRspFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_SetupRspFDD = -1;
static gint ett_rnsap_Combining_RL_SetupRspFDD = -1;
static gint ett_rnsap_NonCombiningOrFirstRL_RL_SetupRspFDD = -1;
static gint ett_rnsap_RadioLinkSetupResponseTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCH_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_RL_LCR_InformationResponse_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_LCR_CCTrCHInformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_LCR_CCTrCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_DPCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_DPCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_SetupRspTDD768 = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD768 = -1;
static gint ett_rnsap_UL_CCTrCHInformationItem_RL_SetupRspTDD768 = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD768 = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD768 = -1;
static gint ett_rnsap_DL_CCTrCHInformationItem_RL_SetupRspTDD768 = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD768 = -1;
static gint ett_rnsap_RadioLinkSetupFailureFDD = -1;
static gint ett_rnsap_CauseLevel_RL_SetupFailureFDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponse_RL_SetupFailureFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_SetupFailureFDD = -1;
static gint ett_rnsap_Combining_RL_SetupFailureFDD = -1;
static gint ett_rnsap_NonCombiningOrFirstRL_RL_SetupFailureFDD = -1;
static gint ett_rnsap_RadioLinkSetupFailureTDD = -1;
static gint ett_rnsap_CauseLevel_RL_SetupFailureTDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_SetupFailureTDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_SetupFailureTDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD = -1;
static gint ett_rnsap_RadioLinkAdditionRequestFDD = -1;
static gint ett_rnsap_RL_InformationList_RL_AdditionRqstFDD = -1;
static gint ett_rnsap_RL_Information_RL_AdditionRqstFDD = -1;
static gint ett_rnsap_EDPCH_Information_RLAdditionReq_FDD = -1;
static gint ett_rnsap_RadioLinkAdditionRequestTDD = -1;
static gint ett_rnsap_RL_Information_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_RadioLinkAdditionResponseFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_AdditionRspFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_AdditionRspFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionRspFDD = -1;
static gint ett_rnsap_Combining_RL_AdditionRspFDD = -1;
static gint ett_rnsap_NonCombining_RL_AdditionRspFDD = -1;
static gint ett_rnsap_RadioLinkAdditionResponseTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DCH_Information_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionRspTDD = -1;
static gint ett_rnsap_Combining_RL_AdditionRspTDD = -1;
static gint ett_rnsap_NonCombining_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionRspTDD2 = -1;
static gint ett_rnsap_USCH_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_USCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_RL_LCR_InformationResponse_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationListIEs_RL_AdditionRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_AdditionRspTDD768 = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD768 = -1;
static gint ett_rnsap_UL_CCTrCHInformationItem_RL_AdditionRspTDD768 = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD768 = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD768 = -1;
static gint ett_rnsap_DL_CCTrCHInformationItem_RL_AdditionRspTDD768 = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD768 = -1;
static gint ett_rnsap_RadioLinkAdditionFailureFDD = -1;
static gint ett_rnsap_CauseLevel_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_Combining_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_NonCombining_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_RadioLinkAdditionFailureTDD = -1;
static gint ett_rnsap_CauseLevel_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_RadioLinkDeletionRequest = -1;
static gint ett_rnsap_RL_InformationList_RL_DeletionRqst = -1;
static gint ett_rnsap_RL_Information_RL_DeletionRqst = -1;
static gint ett_rnsap_RadioLinkDeletionResponse = -1;
static gint ett_rnsap_RadioLinkReconfigurationPrepareFDD = -1;
static gint ett_rnsap_UL_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DL_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DL_DPCH_Power_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_RL_InformationList_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_RL_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_F_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_F_DPCH_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationPrepareTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCAddItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_RL_Information_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_RL_InformationIE_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationReadyFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_ReconfReadyFDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationReadyTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationAddList_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationAddList_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD768 = -1;
static gint ett_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationDeleteList768_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationDeleteItem768_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_USCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_Multiple_RL_InformationResponse_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationCommit = -1;
static gint ett_rnsap_RadioLinkReconfigurationFailure = -1;
static gint ett_rnsap_CauseLevel_RL_ReconfFailure = -1;
static gint ett_rnsap_GeneralCauseList_RL_ReconfFailure = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_ReconfFailure = -1;
static gint ett_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure = -1;
static gint ett_rnsap_RL_ReconfigurationFailure_RL_ReconfFail = -1;
static gint ett_rnsap_RadioLinkReconfigurationCancel = -1;
static gint ett_rnsap_RadioLinkReconfigurationRequestFDD = -1;
static gint ett_rnsap_UL_DPCH_Information_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_DL_DPCH_Information_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_RL_ReconfigurationRequestFDD_RL_InformationList = -1;
static gint ett_rnsap_RL_ReconfigurationRequestFDD_RL_Information_IEs = -1;
static gint ett_rnsap_RadioLinkReconfigurationRequestTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_Multiple_RL_ReconfigurationRequestTDD_RL_Information = -1;
static gint ett_rnsap_RL_ReconfigurationRequestTDD_RL_Information = -1;
static gint ett_rnsap_RadioLinkReconfigurationResponseFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_ReconfRspFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_ReconfRspFDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationResponseTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationList_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_Timeslot_LCR_InformationModifyList_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_Timeslot_LCR_InformationModifyItem_RL_ReconfRspTDD = -1;
static gint ett_rnsap_Multiple_RL_InformationResponse_RL_ReconfRspTDD = -1;
static gint ett_rnsap_RadioLinkFailureIndication = -1;
static gint ett_rnsap_Reporting_Object_RL_FailureInd = -1;
static gint ett_rnsap_RL_RL_FailureInd = -1;
static gint ett_rnsap_RL_InformationList_RL_FailureInd = -1;
static gint ett_rnsap_RL_Information_RL_FailureInd = -1;
static gint ett_rnsap_RL_Set_RL_FailureInd = -1;
static gint ett_rnsap_RL_Set_InformationList_RL_FailureInd = -1;
static gint ett_rnsap_RL_Set_Information_RL_FailureInd = -1;
static gint ett_rnsap_CCTrCH_RL_FailureInd = -1;
static gint ett_rnsap_CCTrCH_InformationList_RL_FailureInd = -1;
static gint ett_rnsap_CCTrCH_InformationItem_RL_FailureInd = -1;
static gint ett_rnsap_RadioLinkPreemptionRequiredIndication = -1;
static gint ett_rnsap_RL_InformationList_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_RL_InformationItem_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_RadioLinkRestoreIndication = -1;
static gint ett_rnsap_Reporting_Object_RL_RestoreInd = -1;
static gint ett_rnsap_RL_RL_RestoreInd = -1;
static gint ett_rnsap_RL_InformationList_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Information_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Set_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Set_InformationList_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Set_Information_RL_RestoreInd = -1;
static gint ett_rnsap_CCTrCH_RL_RestoreInd = -1;
static gint ett_rnsap_CCTrCH_InformationList_RL_RestoreInd = -1;
static gint ett_rnsap_CCTrCH_InformationItem_RL_RestoreInd = -1;
static gint ett_rnsap_DL_PowerControlRequest = -1;
static gint ett_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst = -1;
static gint ett_rnsap_DL_ReferencePowerInformation_DL_PC_Rqst = -1;
static gint ett_rnsap_DL_PowerTimeslotControlRequest = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationRequestFDD = -1;
static gint ett_rnsap_RL_Information_PhyChReconfRqstFDD = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationRequestTDD = -1;
static gint ett_rnsap_RL_Information_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD768 = -1;
static gint ett_rnsap_UL_Timeslot_InformationItem_PhyChReconfRqstTDD768 = -1;
static gint ett_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD768 = -1;
static gint ett_rnsap_DL_Timeslot_InformationItem_PhyChReconfRqstTDD768 = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationItemLCR_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD768 = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationItem_PhyChReconfRqstTDD768 = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationCommand = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationFailure = -1;
static gint ett_rnsap_RadioLinkCongestionIndication = -1;
static gint ett_rnsap_RL_InformationList_RL_CongestInd = -1;
static gint ett_rnsap_RL_InformationItem_RL_CongestInd = -1;
static gint ett_rnsap_DCH_Rate_Information_RL_CongestInd = -1;
static gint ett_rnsap_DCH_Rate_InformationItem_RL_CongestInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationList_RL_CongestInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationItem_RL_CongestInd = -1;
static gint ett_rnsap_UplinkSignallingTransferIndicationFDD = -1;
static gint ett_rnsap_UplinkSignallingTransferIndicationTDD = -1;
static gint ett_rnsap_DownlinkSignallingTransferRequest = -1;
static gint ett_rnsap_RelocationCommit = -1;
static gint ett_rnsap_PagingRequest = -1;
static gint ett_rnsap_PagingArea_PagingRqst = -1;
static gint ett_rnsap_URA_PagingRqst = -1;
static gint ett_rnsap_Cell_PagingRqst = -1;
static gint ett_rnsap_CNOriginatedPage_PagingRqst = -1;
static gint ett_rnsap_DedicatedMeasurementInitiationRequest = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Rqst = -1;
static gint ett_rnsap_RL_DM_Rqst = -1;
static gint ett_rnsap_RL_InformationList_DM_Rqst = -1;
static gint ett_rnsap_RL_InformationItem_DM_Rqst = -1;
static gint ett_rnsap_HSSICH_Info_DM_Rqst = -1;
static gint ett_rnsap_RL_Set_DM_Rqst = -1;
static gint ett_rnsap_RL_Set_InformationList_DM_Rqst = -1;
static gint ett_rnsap_RL_Set_InformationItem_DM_Rqst = -1;
static gint ett_rnsap_DedicatedMeasurementInitiationResponse = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Rsp = -1;
static gint ett_rnsap_RL_DM_Rsp = -1;
static gint ett_rnsap_RL_Set_DM_Rsp = -1;
static gint ett_rnsap_RL_InformationList_DM_Rsp = -1;
static gint ett_rnsap_RL_InformationItem_DM_Rsp = -1;
static gint ett_rnsap_RL_Set_InformationList_DM_Rsp = -1;
static gint ett_rnsap_RL_Set_InformationItem_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueItem_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueItem_LCR_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_HSSICHMeasurementValueItem_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueList_TDD768_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueItem_TDD768_DM_Rsp = -1;
static gint ett_rnsap_DedicatedMeasurementInitiationFailure = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Fail = -1;
static gint ett_rnsap_RL_DM_Fail = -1;
static gint ett_rnsap_RL_Set_DM_Fail = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_RL_Successful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Successful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Successful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Successful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_DedicatedMeasurementReport = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Rprt = -1;
static gint ett_rnsap_RL_DM_Rprt = -1;
static gint ett_rnsap_RL_Set_DM_Rprt = -1;
static gint ett_rnsap_RL_InformationList_DM_Rprt = -1;
static gint ett_rnsap_RL_InformationItem_DM_Rprt = -1;
static gint ett_rnsap_RL_Set_InformationList_DM_Rprt = -1;
static gint ett_rnsap_RL_Set_InformationItem_DM_Rprt = -1;
static gint ett_rnsap_DedicatedMeasurementTerminationRequest = -1;
static gint ett_rnsap_DedicatedMeasurementFailureIndication = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Set_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationItem_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind = -1;
static gint ett_rnsap_CommonTransportChannelResourcesReleaseRequest = -1;
static gint ett_rnsap_CommonTransportChannelResourcesRequest = -1;
static gint ett_rnsap_CommonTransportChannelResourcesResponseFDD = -1;
static gint ett_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD = -1;
static gint ett_rnsap_CommonTransportChannelResourcesResponseTDD = -1;
static gint ett_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD = -1;
static gint ett_rnsap_CommonTransportChannelResourcesFailure = -1;
static gint ett_rnsap_CompressedModeCommand = -1;
static gint ett_rnsap_ErrorIndication = -1;
static gint ett_rnsap_CommonMeasurementInitiationRequest = -1;
static gint ett_rnsap_CommonMeasurementObjectType_CM_Rqst = -1;
static gint ett_rnsap_Cell_CM_Rqst = -1;
static gint ett_rnsap_NeighbouringCellMeasurementInfo = -1;
static gint ett_rnsap_NeighbouringCellMeasurementInfo_item = -1;
static gint ett_rnsap_CommonMeasurementInitiationResponse = -1;
static gint ett_rnsap_CommonMeasurementObjectType_CM_Rsp = -1;
static gint ett_rnsap_Cell_CM_Rsp = -1;
static gint ett_rnsap_CommonMeasurementInitiationFailure = -1;
static gint ett_rnsap_CommonMeasurementReport = -1;
static gint ett_rnsap_CommonMeasurementObjectType_CM_Rprt = -1;
static gint ett_rnsap_Cell_CM_Rprt = -1;
static gint ett_rnsap_CommonMeasurementTerminationRequest = -1;
static gint ett_rnsap_CommonMeasurementFailureIndication = -1;
static gint ett_rnsap_InformationExchangeInitiationRequest = -1;
static gint ett_rnsap_InformationExchangeObjectType_InfEx_Rqst = -1;
static gint ett_rnsap_Cell_InfEx_Rqst = -1;
static gint ett_rnsap_GSM_Cell_InfEx_Rqst = -1;
static gint ett_rnsap_InformationExchangeInitiationResponse = -1;
static gint ett_rnsap_InformationExchangeObjectType_InfEx_Rsp = -1;
static gint ett_rnsap_Cell_InfEx_Rsp = -1;
static gint ett_rnsap_MBMS_Bearer_Service_List_InfEx_Rsp = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemIEs_InfEx_Rsp = -1;
static gint ett_rnsap_InformationExchangeInitiationFailure = -1;
static gint ett_rnsap_InformationReport = -1;
static gint ett_rnsap_InformationExchangeObjectType_InfEx_Rprt = -1;
static gint ett_rnsap_Cell_InfEx_Rprt = -1;
static gint ett_rnsap_InformationExchangeTerminationRequest = -1;
static gint ett_rnsap_InformationExchangeFailureIndication = -1;
static gint ett_rnsap_ResetRequest = -1;
static gint ett_rnsap_ResetIndicator = -1;
static gint ett_rnsap_ContextList_Reset = -1;
static gint ett_rnsap_ContextInfoList_Reset = -1;
static gint ett_rnsap_ContextInfoItem_Reset = -1;
static gint ett_rnsap_ContextType_Reset = -1;
static gint ett_rnsap_ContextGroupList_Reset = -1;
static gint ett_rnsap_ContextGroupInfoList_Reset = -1;
static gint ett_rnsap_ContextGroupInfoItem_Reset = -1;
static gint ett_rnsap_ResetResponse = -1;
static gint ett_rnsap_RadioLinkActivationCommandFDD = -1;
static gint ett_rnsap_DelayedActivationInformationList_RL_ActivationCmdFDD = -1;
static gint ett_rnsap_DelayedActivationInformation_RL_ActivationCmdFDD = -1;
static gint ett_rnsap_RadioLinkActivationCommandTDD = -1;
static gint ett_rnsap_DelayedActivationInformationList_RL_ActivationCmdTDD = -1;
static gint ett_rnsap_DelayedActivationInformation_RL_ActivationCmdTDD = -1;
static gint ett_rnsap_GERANUplinkSignallingTransferIndication = -1;
static gint ett_rnsap_RadioLinkParameterUpdateIndicationFDD = -1;
static gint ett_rnsap_RL_ParameterUpdateIndicationFDD_RL_InformationList = -1;
static gint ett_rnsap_RL_ParameterUpdateIndicationFDD_RL_Information_Item = -1;
static gint ett_rnsap_RadioLinkParameterUpdateIndicationTDD = -1;
static gint ett_rnsap_UEMeasurementInitiationRequest = -1;
static gint ett_rnsap_UEMeasurementInitiationResponse = -1;
static gint ett_rnsap_UEMeasurementInitiationFailure = -1;
static gint ett_rnsap_UEMeasurementReport = -1;
static gint ett_rnsap_UEMeasurementTerminationRequest = -1;
static gint ett_rnsap_UEMeasurementFailureIndication = -1;
static gint ett_rnsap_IurInvokeTrace = -1;
static gint ett_rnsap_ListOfInterfacesToTrace = -1;
static gint ett_rnsap_InterfacesToTraceItem = -1;
static gint ett_rnsap_IurDeactivateTrace = -1;
static gint ett_rnsap_MBMSAttachCommand = -1;
static gint ett_rnsap_MBMSDetachCommand = -1;
static gint ett_rnsap_DirectInformationTransfer = -1;
static gint ett_rnsap_PrivateMessage = -1;
static gint ett_rnsap_RNSAP_PDU = -1;
static gint ett_rnsap_InitiatingMessage = -1;
static gint ett_rnsap_SuccessfulOutcome = -1;
static gint ett_rnsap_UnsuccessfulOutcome = -1;
static gint ett_rnsap_Outcome = -1;

/*--- End of included file: packet-rnsap-ett.c ---*/
#line 72 "packet-rnsap-template.c"

/* Global variables */
static guint32 ProcedureCode;
static guint32 ProtocolIE_ID;
static guint32 ddMode;
static const gchar *ProcedureID;

/* Dissector tables */
static dissector_table_t rnsap_ies_dissector_table;
static dissector_table_t rnsap_extension_dissector_table;
static dissector_table_t rnsap_proc_imsg_dissector_table;
static dissector_table_t rnsap_proc_sout_dissector_table;
static dissector_table_t rnsap_proc_uout_dissector_table;

static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree);
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree);


/*--- Included file: packet-rnsap-fn.c ---*/
#line 1 "packet-rnsap-fn.c"

static const value_string rnsap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_rnsap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_maxPrivateIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxPrivateIEs, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_OBJECT_IDENTIFIER(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_object_identifier(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string rnsap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_rnsap_local         , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_maxPrivateIEs },
  {   1, &hf_rnsap_global        , ASN1_NO_EXTENSIONS     , dissect_rnsap_OBJECT_IDENTIFIER },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_ProcedureCode_vals[] = {
  { RNSAP_ID_COMMONTRANSPORTCHANNELRESOURCESINITIALISATION, "id-commonTransportChannelResourcesInitialisation" },
  { RNSAP_ID_COMMONTRANSPORTCHANNELRESOURCESRELEASE, "id-commonTransportChannelResourcesRelease" },
  { RNSAP_ID_COMPRESSEDMODECOMMAND, "id-compressedModeCommand" },
  { RNSAP_ID_DOWNLINKPOWERCONTROL, "id-downlinkPowerControl" },
  { RNSAP_ID_DOWNLINKPOWERTIMESLOTCONTROL, "id-downlinkPowerTimeslotControl" },
  { RNSAP_ID_DOWNLINKSIGNALLINGTRANSFER, "id-downlinkSignallingTransfer" },
  { RNSAP_ID_ERRORINDICATION, "id-errorIndication" },
  { RNSAP_ID_DEDICATEDMEASUREMENTFAILURE, "id-dedicatedMeasurementFailure" },
  { RNSAP_ID_DEDICATEDMEASUREMENTINITIATION, "id-dedicatedMeasurementInitiation" },
  { RNSAP_ID_DEDICATEDMEASUREMENTREPORTING, "id-dedicatedMeasurementReporting" },
  { RNSAP_ID_DEDICATEDMEASUREMENTTERMINATION, "id-dedicatedMeasurementTermination" },
  { RNSAP_ID_PAGING, "id-paging" },
  { RNSAP_ID_PHYSICALCHANNELRECONFIGURATION, "id-physicalChannelReconfiguration" },
  { RNSAP_ID_PRIVATEMESSAGE, "id-privateMessage" },
  { RNSAP_ID_RADIOLINKADDITION, "id-radioLinkAddition" },
  { RNSAP_ID_RADIOLINKCONGESTION, "id-radioLinkCongestion" },
  { RNSAP_ID_RADIOLINKDELETION, "id-radioLinkDeletion" },
  { RNSAP_ID_RADIOLINKFAILURE, "id-radioLinkFailure" },
  { RNSAP_ID_RADIOLINKPREEMPTION, "id-radioLinkPreemption" },
  { RNSAP_ID_RADIOLINKRESTORATION, "id-radioLinkRestoration" },
  { RNSAP_ID_RADIOLINKSETUP, "id-radioLinkSetup" },
  { RNSAP_ID_RELOCATIONCOMMIT, "id-relocationCommit" },
  { RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCANCELLATION, "id-synchronisedRadioLinkReconfigurationCancellation" },
  { RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCOMMIT, "id-synchronisedRadioLinkReconfigurationCommit" },
  { RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION, "id-synchronisedRadioLinkReconfigurationPreparation" },
  { RNSAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION, "id-unSynchronisedRadioLinkReconfiguration" },
  { RNSAP_ID_UPLINKSIGNALLINGTRANSFER, "id-uplinkSignallingTransfer" },
  { RNSAP_ID_COMMONMEASUREMENTFAILURE, "id-commonMeasurementFailure" },
  { RNSAP_ID_COMMONMEASUREMENTINITIATION, "id-commonMeasurementInitiation" },
  { RNSAP_ID_COMMONMEASUREMENTREPORTING, "id-commonMeasurementReporting" },
  { RNSAP_ID_COMMONMEASUREMENTTERMINATION, "id-commonMeasurementTermination" },
  { RNSAP_ID_INFORMATIONEXCHANGEFAILURE, "id-informationExchangeFailure" },
  { RNSAP_ID_INFORMATIONEXCHANGEINITIATION, "id-informationExchangeInitiation" },
  { RNSAP_ID_INFORMATIONREPORTING, "id-informationReporting" },
  { RNSAP_ID_INFORMATIONEXCHANGETERMINATION, "id-informationExchangeTermination" },
  { RNSAP_ID_RESET, "id-reset" },
  { RNSAP_ID_RADIOLINKACTIVATION, "id-radioLinkActivation" },
  { RNSAP_ID_GERANUPLINKSIGNALLINGTRANSFER, "id-gERANuplinkSignallingTransfer" },
  { RNSAP_ID_RADIOLINKPARAMETERUPDATE, "id-radioLinkParameterUpdate" },
  { RNSAP_ID_UEMEASUREMENTFAILURE, "id-uEMeasurementFailure" },
  { RNSAP_ID_UEMEASUREMENTINITIATION, "id-uEMeasurementInitiation" },
  { RNSAP_ID_UEMEASUREMENTREPORTING, "id-uEMeasurementReporting" },
  { RNSAP_ID_UEMEASUREMENTTERMINATION, "id-uEMeasurementTermination" },
  { RNSAP_ID_IURDEACTIVATETRACE, "id-iurDeactivateTrace" },
  { RNSAP_ID_IURINVOKETRACE, "id-iurInvokeTrace" },
  { RNSAP_ID_MBMSATTACH, "id-mBMSAttach" },
  { RNSAP_ID_MBMSDETACH, "id-mBMSDetach" },
  { RNSAP_ID_DIRECTINFORMATIONTRANSFER, "id-directInformationTransfer" },
  { 0, NULL }
};


static int
dissect_rnsap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &ProcedureCode, FALSE);

#line 65 "rnsap.cnf"
	if (check_col(actx->pinfo->cinfo, COL_INFO))
       col_add_fstr(actx->pinfo->cinfo, COL_INFO, "%s ",
                   val_to_str(ProcedureCode, rnsap_ProcedureCode_vals,
                              "unknown message"));

  return offset;
}


static const value_string rnsap_DdMode_vals[] = {
  { tdd, "tdd" },
  { fdd, "fdd" },
  { common, "common" },
  { 0, NULL }
};


static int
dissect_rnsap_DdMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, &ddMode, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ProcedureID_sequence[] = {
  { &hf_rnsap_procedureCode , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProcedureCode },
  { &hf_rnsap_ddMode        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DdMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ProcedureID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 73 "rnsap.cnf"
  ProcedureCode = 0xFFFF;
  ddMode = 0xFFFF;
  ProcedureID = NULL;

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ProcedureID, ProcedureID_sequence);

#line 79 "rnsap.cnf"
  ProcedureID = ep_strdup_printf("%s/%s", 
                                 val_to_str(ProcedureCode, VALS(rnsap_ProcedureCode_vals), "unknown(%u)"),
                                 val_to_str(ddMode, VALS(rnsap_DdMode_vals), "unknown(%u)"));      

  return offset;
}


static const value_string rnsap_ProtocolIE_ID_vals[] = {
  { id_AllowedQueuingTime, "id-AllowedQueuingTime" },
  { id_Allowed_Rate_Information, "id-Allowed-Rate-Information" },
  { id_AntennaColocationIndicator, "id-AntennaColocationIndicator" },
  { id_BindingID, "id-BindingID" },
  { id_C_ID, "id-C-ID" },
  { id_C_RNTI, "id-C-RNTI" },
  { id_Cell_Capacity_Class_Value, "id-Cell-Capacity-Class-Value" },
  { id_CFN, "id-CFN" },
  { id_CN_CS_DomainIdentifier, "id-CN-CS-DomainIdentifier" },
  { id_CN_PS_DomainIdentifier, "id-CN-PS-DomainIdentifier" },
  { id_Cause, "id-Cause" },
  { id_CoverageIndicator, "id-CoverageIndicator" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_ContextInfoItem_Reset, "id-ContextInfoItem-Reset" },
  { id_ContextGroupInfoItem_Reset, "id-ContextGroupInfoItem-Reset" },
  { id_D_RNTI, "id-D-RNTI" },
  { id_D_RNTI_ReleaseIndication, "id-D-RNTI-ReleaseIndication" },
  { id_DCHs_to_Add_FDD, "id-DCHs-to-Add-FDD" },
  { id_DCHs_to_Add_TDD, "id-DCHs-to-Add-TDD" },
  { id_DCH_DeleteList_RL_ReconfPrepFDD, "id-DCH-DeleteList-RL-ReconfPrepFDD" },
  { id_DCH_DeleteList_RL_ReconfPrepTDD, "id-DCH-DeleteList-RL-ReconfPrepTDD" },
  { id_DCH_DeleteList_RL_ReconfRqstFDD, "id-DCH-DeleteList-RL-ReconfRqstFDD" },
  { id_DCH_DeleteList_RL_ReconfRqstTDD, "id-DCH-DeleteList-RL-ReconfRqstTDD" },
  { id_DCH_FDD_Information, "id-DCH-FDD-Information" },
  { id_DCH_TDD_Information, "id-DCH-TDD-Information" },
  { id_FDD_DCHs_to_Modify, "id-FDD-DCHs-to-Modify" },
  { id_TDD_DCHs_to_Modify, "id-TDD-DCHs-to-Modify" },
  { id_DCH_InformationResponse, "id-DCH-InformationResponse" },
  { id_DCH_Rate_InformationItem_RL_CongestInd, "id-DCH-Rate-InformationItem-RL-CongestInd" },
  { id_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationAddItem-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationListIE_RL_ReconfReadyTDD, "id-DL-CCTrCH-InformationListIE-RL-ReconfReadyTDD" },
  { id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationDeleteItem-RL-ReconfRqstTDD" },
  { id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD, "id-DL-CCTrCH-InformationItem-RL-SetupRqstTDD" },
  { id_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD, "id-DL-CCTrCH-InformationListIE-PhyChReconfRqstTDD" },
  { id_DL_CCTrCH_InformationListIE_RL_AdditionRspTDD, "id-DL-CCTrCH-InformationListIE-RL-AdditionRspTDD" },
  { id_DL_CCTrCH_InformationListIE_RL_SetupRspTDD, "id-DL-CCTrCH-InformationListIE-RL-SetupRspTDD" },
  { id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationAddList-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationDeleteList-RL-ReconfRqstTDD" },
  { id_DL_CCTrCH_InformationList_RL_SetupRqstTDD, "id-DL-CCTrCH-InformationList-RL-SetupRqstTDD" },
  { id_FDD_DL_CodeInformation, "id-FDD-DL-CodeInformation" },
  { id_DL_DPCH_Information_RL_ReconfPrepFDD, "id-DL-DPCH-Information-RL-ReconfPrepFDD" },
  { id_DL_DPCH_Information_RL_SetupRqstFDD, "id-DL-DPCH-Information-RL-SetupRqstFDD" },
  { id_DL_DPCH_Information_RL_ReconfRqstFDD, "id-DL-DPCH-Information-RL-ReconfRqstFDD" },
  { id_DL_DPCH_InformationItem_PhyChReconfRqstTDD, "id-DL-DPCH-InformationItem-PhyChReconfRqstTDD" },
  { id_DL_DPCH_InformationItem_RL_AdditionRspTDD, "id-DL-DPCH-InformationItem-RL-AdditionRspTDD" },
  { id_DL_DPCH_InformationItem_RL_SetupRspTDD, "id-DL-DPCH-InformationItem-RL-SetupRspTDD" },
  { id_DL_DPCH_TimingAdjustment, "id-DL-DPCH-TimingAdjustment" },
  { id_DLReferencePower, "id-DLReferencePower" },
  { id_DLReferencePowerList_DL_PC_Rqst, "id-DLReferencePowerList-DL-PC-Rqst" },
  { id_DL_ReferencePowerInformation_DL_PC_Rqst, "id-DL-ReferencePowerInformation-DL-PC-Rqst" },
  { id_DPC_Mode, "id-DPC-Mode" },
  { id_DRXCycleLengthCoefficient, "id-DRXCycleLengthCoefficient" },
  { id_DedicatedMeasurementObjectType_DM_Fail_Ind, "id-DedicatedMeasurementObjectType-DM-Fail-Ind" },
  { id_DedicatedMeasurementObjectType_DM_Fail, "id-DedicatedMeasurementObjectType-DM-Fail" },
  { id_DedicatedMeasurementObjectType_DM_Rprt, "id-DedicatedMeasurementObjectType-DM-Rprt" },
  { id_DedicatedMeasurementObjectType_DM_Rqst, "id-DedicatedMeasurementObjectType-DM-Rqst" },
  { id_DedicatedMeasurementObjectType_DM_Rsp, "id-DedicatedMeasurementObjectType-DM-Rsp" },
  { id_DedicatedMeasurementType, "id-DedicatedMeasurementType" },
  { id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD, "id-FACH-InfoForUESelectedS-CCPCH-CTCH-ResourceRspFDD" },
  { id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD, "id-FACH-InfoForUESelectedS-CCPCH-CTCH-ResourceRspTDD" },
  { id_Guaranteed_Rate_Information, "id-Guaranteed-Rate-Information" },
  { id_IMSI, "id-IMSI" },
  { id_HCS_Prio, "id-HCS-Prio" },
  { id_L3_Information, "id-L3-Information" },
  { id_AdjustmentPeriod, "id-AdjustmentPeriod" },
  { id_MaxAdjustmentStep, "id-MaxAdjustmentStep" },
  { id_MeasurementFilterCoefficient, "id-MeasurementFilterCoefficient" },
  { id_MessageStructure, "id-MessageStructure" },
  { id_MeasurementID, "id-MeasurementID" },
  { id_Neighbouring_GSM_CellInformation, "id-Neighbouring-GSM-CellInformation" },
  { id_Neighbouring_UMTS_CellInformationItem, "id-Neighbouring-UMTS-CellInformationItem" },
  { id_NRT_Load_Information_Value, "id-NRT-Load-Information-Value" },
  { id_NRT_Load_Information_Value_IncrDecrThres, "id-NRT-Load-Information-Value-IncrDecrThres" },
  { id_PagingArea_PagingRqst, "id-PagingArea-PagingRqst" },
  { id_FACH_FlowControlInformation, "id-FACH-FlowControlInformation" },
  { id_PartialReportingIndicator, "id-PartialReportingIndicator" },
  { id_Permanent_NAS_UE_Identity, "id-Permanent-NAS-UE-Identity" },
  { id_PowerAdjustmentType, "id-PowerAdjustmentType" },
  { id_RANAP_RelocationInformation, "id-RANAP-RelocationInformation" },
  { id_RL_Information_PhyChReconfRqstFDD, "id-RL-Information-PhyChReconfRqstFDD" },
  { id_RL_Information_PhyChReconfRqstTDD, "id-RL-Information-PhyChReconfRqstTDD" },
  { id_RL_Information_RL_AdditionRqstFDD, "id-RL-Information-RL-AdditionRqstFDD" },
  { id_RL_Information_RL_AdditionRqstTDD, "id-RL-Information-RL-AdditionRqstTDD" },
  { id_RL_Information_RL_DeletionRqst, "id-RL-Information-RL-DeletionRqst" },
  { id_RL_Information_RL_FailureInd, "id-RL-Information-RL-FailureInd" },
  { id_RL_Information_RL_ReconfPrepFDD, "id-RL-Information-RL-ReconfPrepFDD" },
  { id_RL_Information_RL_RestoreInd, "id-RL-Information-RL-RestoreInd" },
  { id_RL_Information_RL_SetupRqstFDD, "id-RL-Information-RL-SetupRqstFDD" },
  { id_RL_Information_RL_SetupRqstTDD, "id-RL-Information-RL-SetupRqstTDD" },
  { id_RL_InformationItem_RL_CongestInd, "id-RL-InformationItem-RL-CongestInd" },
  { id_RL_InformationItem_DM_Rprt, "id-RL-InformationItem-DM-Rprt" },
  { id_RL_InformationItem_DM_Rqst, "id-RL-InformationItem-DM-Rqst" },
  { id_RL_InformationItem_DM_Rsp, "id-RL-InformationItem-DM-Rsp" },
  { id_RL_InformationItem_RL_PreemptRequiredInd, "id-RL-InformationItem-RL-PreemptRequiredInd" },
  { id_RL_InformationItem_RL_SetupRqstFDD, "id-RL-InformationItem-RL-SetupRqstFDD" },
  { id_RL_InformationList_RL_CongestInd, "id-RL-InformationList-RL-CongestInd" },
  { id_RL_InformationList_RL_AdditionRqstFDD, "id-RL-InformationList-RL-AdditionRqstFDD" },
  { id_RL_InformationList_RL_DeletionRqst, "id-RL-InformationList-RL-DeletionRqst" },
  { id_RL_InformationList_RL_PreemptRequiredInd, "id-RL-InformationList-RL-PreemptRequiredInd" },
  { id_RL_InformationList_RL_ReconfPrepFDD, "id-RL-InformationList-RL-ReconfPrepFDD" },
  { id_RL_InformationResponse_RL_AdditionRspTDD, "id-RL-InformationResponse-RL-AdditionRspTDD" },
  { id_RL_InformationResponse_RL_ReconfReadyTDD, "id-RL-InformationResponse-RL-ReconfReadyTDD" },
  { id_RL_InformationResponse_RL_SetupRspTDD, "id-RL-InformationResponse-RL-SetupRspTDD" },
  { id_RL_InformationResponseItem_RL_AdditionRspFDD, "id-RL-InformationResponseItem-RL-AdditionRspFDD" },
  { id_RL_InformationResponseItem_RL_ReconfReadyFDD, "id-RL-InformationResponseItem-RL-ReconfReadyFDD" },
  { id_RL_InformationResponseItem_RL_ReconfRspFDD, "id-RL-InformationResponseItem-RL-ReconfRspFDD" },
  { id_RL_InformationResponseItem_RL_SetupRspFDD, "id-RL-InformationResponseItem-RL-SetupRspFDD" },
  { id_RL_InformationResponseList_RL_AdditionRspFDD, "id-RL-InformationResponseList-RL-AdditionRspFDD" },
  { id_RL_InformationResponseList_RL_ReconfReadyFDD, "id-RL-InformationResponseList-RL-ReconfReadyFDD" },
  { id_RL_InformationResponseList_RL_ReconfRspFDD, "id-RL-InformationResponseList-RL-ReconfRspFDD" },
  { id_RL_InformationResponse_RL_ReconfRspTDD, "id-RL-InformationResponse-RL-ReconfRspTDD" },
  { id_RL_InformationResponseList_RL_SetupRspFDD, "id-RL-InformationResponseList-RL-SetupRspFDD" },
  { id_RL_ReconfigurationFailure_RL_ReconfFail, "id-RL-ReconfigurationFailure-RL-ReconfFail" },
  { id_RL_Set_InformationItem_DM_Rprt, "id-RL-Set-InformationItem-DM-Rprt" },
  { id_RL_Set_InformationItem_DM_Rqst, "id-RL-Set-InformationItem-DM-Rqst" },
  { id_RL_Set_InformationItem_DM_Rsp, "id-RL-Set-InformationItem-DM-Rsp" },
  { id_RL_Set_Information_RL_FailureInd, "id-RL-Set-Information-RL-FailureInd" },
  { id_RL_Set_Information_RL_RestoreInd, "id-RL-Set-Information-RL-RestoreInd" },
  { id_RL_Set_Successful_InformationItem_DM_Fail, "id-RL-Set-Successful-InformationItem-DM-Fail" },
  { id_RL_Set_Unsuccessful_InformationItem_DM_Fail, "id-RL-Set-Unsuccessful-InformationItem-DM-Fail" },
  { id_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind, "id-RL-Set-Unsuccessful-InformationItem-DM-Fail-Ind" },
  { id_RL_Successful_InformationItem_DM_Fail, "id-RL-Successful-InformationItem-DM-Fail" },
  { id_RL_Unsuccessful_InformationItem_DM_Fail, "id-RL-Unsuccessful-InformationItem-DM-Fail" },
  { id_RL_Unsuccessful_InformationItem_DM_Fail_Ind, "id-RL-Unsuccessful-InformationItem-DM-Fail-Ind" },
  { id_ReportCharacteristics, "id-ReportCharacteristics" },
  { id_Reporting_Object_RL_FailureInd, "id-Reporting-Object-RL-FailureInd" },
  { id_Reporing_Object_RL_RestoreInd, "id-Reporing-Object-RL-RestoreInd" },
  { id_RT_Load_Value, "id-RT-Load-Value" },
  { id_RT_Load_Value_IncrDecrThres, "id-RT-Load-Value-IncrDecrThres" },
  { id_S_RNTI, "id-S-RNTI" },
  { id_ResetIndicator, "id-ResetIndicator" },
  { id_RNC_ID, "id-RNC-ID" },
  { id_SAI, "id-SAI" },
  { id_SRNC_ID, "id-SRNC-ID" },
  { id_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD, "id-SuccessfulRL-InformationResponse-RL-AdditionFailureFDD" },
  { id_SuccessfulRL_InformationResponse_RL_SetupFailureFDD, "id-SuccessfulRL-InformationResponse-RL-SetupFailureFDD" },
  { id_TransportBearerID, "id-TransportBearerID" },
  { id_TransportBearerRequestIndicator, "id-TransportBearerRequestIndicator" },
  { id_TransportLayerAddress, "id-TransportLayerAddress" },
  { id_TypeOfError, "id-TypeOfError" },
  { id_UC_ID, "id-UC-ID" },
  { id_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD, "id-UL-CCTrCH-AddInformation-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD, "id-UL-CCTrCH-InformationAddList-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD, "id-UL-CCTrCH-InformationItem-RL-SetupRqstTDD" },
  { id_UL_CCTrCH_InformationList_RL_SetupRqstTDD, "id-UL-CCTrCH-InformationList-RL-SetupRqstTDD" },
  { id_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD, "id-UL-CCTrCH-InformationListIE-PhyChReconfRqstTDD" },
  { id_UL_CCTrCH_InformationListIE_RL_AdditionRspTDD, "id-UL-CCTrCH-InformationListIE-RL-AdditionRspTDD" },
  { id_UL_CCTrCH_InformationListIE_RL_ReconfReadyTDD, "id-UL-CCTrCH-InformationListIE-RL-ReconfReadyTDD" },
  { id_UL_CCTrCH_InformationListIE_RL_SetupRspTDD, "id-UL-CCTrCH-InformationListIE-RL-SetupRspTDD" },
  { id_UL_DPCH_Information_RL_ReconfPrepFDD, "id-UL-DPCH-Information-RL-ReconfPrepFDD" },
  { id_UL_DPCH_Information_RL_ReconfRqstFDD, "id-UL-DPCH-Information-RL-ReconfRqstFDD" },
  { id_UL_DPCH_Information_RL_SetupRqstFDD, "id-UL-DPCH-Information-RL-SetupRqstFDD" },
  { id_UL_DPCH_InformationItem_PhyChReconfRqstTDD, "id-UL-DPCH-InformationItem-PhyChReconfRqstTDD" },
  { id_UL_DPCH_InformationItem_RL_AdditionRspTDD, "id-UL-DPCH-InformationItem-RL-AdditionRspTDD" },
  { id_UL_DPCH_InformationItem_RL_SetupRspTDD, "id-UL-DPCH-InformationItem-RL-SetupRspTDD" },
  { id_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD, "id-UL-DPCH-InformationAddListIE-RL-ReconfReadyTDD" },
  { id_UL_SIRTarget, "id-UL-SIRTarget" },
  { id_URA_Information, "id-URA-Information" },
  { id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD, "id-UnsuccessfulRL-InformationResponse-RL-AdditionFailureFDD" },
  { id_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD, "id-UnsuccessfulRL-InformationResponse-RL-SetupFailureFDD" },
  { id_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD, "id-UnsuccessfulRL-InformationResponse-RL-SetupFailureTDD" },
  { id_Active_Pattern_Sequence_Information, "id-Active-Pattern-Sequence-Information" },
  { id_AdjustmentRatio, "id-AdjustmentRatio" },
  { id_CauseLevel_RL_AdditionFailureFDD, "id-CauseLevel-RL-AdditionFailureFDD" },
  { id_CauseLevel_RL_AdditionFailureTDD, "id-CauseLevel-RL-AdditionFailureTDD" },
  { id_CauseLevel_RL_ReconfFailure, "id-CauseLevel-RL-ReconfFailure" },
  { id_CauseLevel_RL_SetupFailureFDD, "id-CauseLevel-RL-SetupFailureFDD" },
  { id_CauseLevel_RL_SetupFailureTDD, "id-CauseLevel-RL-SetupFailureTDD" },
  { id_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationDeleteItem-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationModifyItem-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationModifyItem-RL-ReconfRqstTDD" },
  { id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationDeleteList-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationModifyList-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationModifyList-RL-ReconfRqstTDD" },
  { id_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD, "id-DL-DPCH-InformationAddListIE-RL-ReconfReadyTDD" },
  { id_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD, "id-DL-DPCH-InformationDeleteListIE-RL-ReconfReadyTDD" },
  { id_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD, "id-DL-DPCH-InformationModifyListIE-RL-ReconfReadyTDD" },
  { id_DSCHs_to_Add_TDD, "id-DSCHs-to-Add-TDD" },
  { id_Unused_ProtocolIE_ID_216, "id-Unused-ProtocolIE-ID-216" },
  { id_DSCH_DeleteList_RL_ReconfPrepTDD, "id-DSCH-DeleteList-RL-ReconfPrepTDD" },
  { id_Unused_ProtocolIE_ID_218, "id-Unused-ProtocolIE-ID-218" },
  { id_Unused_ProtocolIE_ID_219, "id-Unused-ProtocolIE-ID-219" },
  { id_DSCH_InformationListIE_RL_AdditionRspTDD, "id-DSCH-InformationListIE-RL-AdditionRspTDD" },
  { id_DSCH_InformationListIEs_RL_SetupRspTDD, "id-DSCH-InformationListIEs-RL-SetupRspTDD" },
  { id_DSCH_TDD_Information, "id-DSCH-TDD-Information" },
  { id_Unused_ProtocolIE_ID_223, "id-Unused-ProtocolIE-ID-223" },
  { id_Unused_ProtocolIE_ID_226, "id-Unused-ProtocolIE-ID-226" },
  { id_DSCH_ModifyList_RL_ReconfPrepTDD, "id-DSCH-ModifyList-RL-ReconfPrepTDD" },
  { id_Unused_ProtocolIE_ID_228, "id-Unused-ProtocolIE-ID-228" },
  { id_Unused_ProtocolIE_ID_324, "id-Unused-ProtocolIE-ID-324" },
  { id_Unused_ProtocolIE_ID_229, "id-Unused-ProtocolIE-ID-229" },
  { id_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD, "id-DSCHToBeAddedOrModifiedList-RL-ReconfReadyTDD" },
  { id_Unused_ProtocolIE_ID_29, "id-Unused-ProtocolIE-ID-29" },
  { id_Unused_ProtocolIE_ID_225, "id-Unused-ProtocolIE-ID-225" },
  { id_GA_Cell, "id-GA-Cell" },
  { id_GA_CellAdditionalShapes, "id-GA-CellAdditionalShapes" },
  { id_Unused_ProtocolIE_ID_246, "id-Unused-ProtocolIE-ID-246" },
  { id_Transmission_Gap_Pattern_Sequence_Information, "id-Transmission-Gap-Pattern-Sequence-Information" },
  { id_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD, "id-UL-CCTrCH-DeleteInformation-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD, "id-UL-CCTrCH-ModifyInformation-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationModifyItem-RL-ReconfRqstTDD" },
  { id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD, "id-UL-CCTrCH-InformationDeleteList-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD, "id-UL-CCTrCH-InformationModifyList-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationModifyList-RL-ReconfRqstTDD" },
  { id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationDeleteItem-RL-ReconfRqstTDD" },
  { id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationDeleteList-RL-ReconfRqstTDD" },
  { id_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD, "id-UL-DPCH-InformationDeleteListIE-RL-ReconfReadyTDD" },
  { id_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD, "id-UL-DPCH-InformationModifyListIE-RL-ReconfReadyTDD" },
  { id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD, "id-UnsuccessfulRL-InformationResponse-RL-AdditionFailureTDD" },
  { id_USCHs_to_Add, "id-USCHs-to-Add" },
  { id_USCH_DeleteList_RL_ReconfPrepTDD, "id-USCH-DeleteList-RL-ReconfPrepTDD" },
  { id_USCH_InformationListIE_RL_AdditionRspTDD, "id-USCH-InformationListIE-RL-AdditionRspTDD" },
  { id_USCH_InformationListIEs_RL_SetupRspTDD, "id-USCH-InformationListIEs-RL-SetupRspTDD" },
  { id_USCH_Information, "id-USCH-Information" },
  { id_USCH_ModifyList_RL_ReconfPrepTDD, "id-USCH-ModifyList-RL-ReconfPrepTDD" },
  { id_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD, "id-USCHToBeAddedOrModifiedList-RL-ReconfReadyTDD" },
  { id_DL_Physical_Channel_Information_RL_SetupRqstTDD, "id-DL-Physical-Channel-Information-RL-SetupRqstTDD" },
  { id_UL_Physical_Channel_Information_RL_SetupRqstTDD, "id-UL-Physical-Channel-Information-RL-SetupRqstTDD" },
  { id_ClosedLoopMode1_SupportIndicator, "id-ClosedLoopMode1-SupportIndicator" },
  { id_Unused_ProtocolIE_ID_277, "id-Unused-ProtocolIE-ID-277" },
  { id_STTD_SupportIndicator, "id-STTD-SupportIndicator" },
  { id_CFNReportingIndicator, "id-CFNReportingIndicator" },
  { id_CNOriginatedPage_PagingRqst, "id-CNOriginatedPage-PagingRqst" },
  { id_InnerLoopDLPCStatus, "id-InnerLoopDLPCStatus" },
  { id_PropagationDelay, "id-PropagationDelay" },
  { id_RxTimingDeviationForTA, "id-RxTimingDeviationForTA" },
  { id_timeSlot_ISCP, "id-timeSlot-ISCP" },
  { id_CCTrCH_InformationItem_RL_FailureInd, "id-CCTrCH-InformationItem-RL-FailureInd" },
  { id_CCTrCH_InformationItem_RL_RestoreInd, "id-CCTrCH-InformationItem-RL-RestoreInd" },
  { id_CommonMeasurementAccuracy, "id-CommonMeasurementAccuracy" },
  { id_CommonMeasurementObjectType_CM_Rprt, "id-CommonMeasurementObjectType-CM-Rprt" },
  { id_CommonMeasurementObjectType_CM_Rqst, "id-CommonMeasurementObjectType-CM-Rqst" },
  { id_CommonMeasurementObjectType_CM_Rsp, "id-CommonMeasurementObjectType-CM-Rsp" },
  { id_CommonMeasurementType, "id-CommonMeasurementType" },
  { id_CongestionCause, "id-CongestionCause" },
  { id_SFN, "id-SFN" },
  { id_SFNReportingIndicator, "id-SFNReportingIndicator" },
  { id_InformationExchangeID, "id-InformationExchangeID" },
  { id_InformationExchangeObjectType_InfEx_Rprt, "id-InformationExchangeObjectType-InfEx-Rprt" },
  { id_InformationExchangeObjectType_InfEx_Rqst, "id-InformationExchangeObjectType-InfEx-Rqst" },
  { id_InformationExchangeObjectType_InfEx_Rsp, "id-InformationExchangeObjectType-InfEx-Rsp" },
  { id_InformationReportCharacteristics, "id-InformationReportCharacteristics" },
  { id_InformationType, "id-InformationType" },
  { id_neighbouring_LCR_TDD_CellInformation, "id-neighbouring-LCR-TDD-CellInformation" },
  { id_DL_Timeslot_ISCP_LCR_Information_RL_SetupRqstTDD, "id-DL-Timeslot-ISCP-LCR-Information-RL-SetupRqstTDD" },
  { id_RL_LCR_InformationResponse_RL_SetupRspTDD, "id-RL-LCR-InformationResponse-RL-SetupRspTDD" },
  { id_UL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD, "id-UL-CCTrCH-LCR-InformationListIE-RL-SetupRspTDD" },
  { id_UL_DPCH_LCR_InformationItem_RL_SetupRspTDD, "id-UL-DPCH-LCR-InformationItem-RL-SetupRspTDD" },
  { id_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD, "id-DL-CCTrCH-LCR-InformationListIE-RL-SetupRspTDD" },
  { id_DL_DPCH_LCR_InformationItem_RL_SetupRspTDD, "id-DL-DPCH-LCR-InformationItem-RL-SetupRspTDD" },
  { id_DSCH_LCR_InformationListIEs_RL_SetupRspTDD, "id-DSCH-LCR-InformationListIEs-RL-SetupRspTDD" },
  { id_USCH_LCR_InformationListIEs_RL_SetupRspTDD, "id-USCH-LCR-InformationListIEs-RL-SetupRspTDD" },
  { id_DL_Timeslot_ISCP_LCR_Information_RL_AdditionRqstTDD, "id-DL-Timeslot-ISCP-LCR-Information-RL-AdditionRqstTDD" },
  { id_RL_LCR_InformationResponse_RL_AdditionRspTDD, "id-RL-LCR-InformationResponse-RL-AdditionRspTDD" },
  { id_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD, "id-UL-CCTrCH-LCR-InformationListIE-RL-AdditionRspTDD" },
  { id_UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD, "id-UL-DPCH-LCR-InformationItem-RL-AdditionRspTDD" },
  { id_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD, "id-DL-CCTrCH-LCR-InformationListIE-RL-AdditionRspTDD" },
  { id_DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD, "id-DL-DPCH-LCR-InformationItem-RL-AdditionRspTDD" },
  { id_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD, "id-DSCH-LCR-InformationListIEs-RL-AdditionRspTDD" },
  { id_USCH_LCR_InformationListIEs_RL_AdditionRspTDD, "id-USCH-LCR-InformationListIEs-RL-AdditionRspTDD" },
  { id_UL_DPCH_LCR_InformationAddListIE_RL_ReconfReadyTDD, "id-UL-DPCH-LCR-InformationAddListIE-RL-ReconfReadyTDD" },
  { id_UL_Timeslot_LCR_InformationModifyList_RL_ReconfReadyTDD, "id-UL-Timeslot-LCR-InformationModifyList-RL-ReconfReadyTDD" },
  { id_DL_DPCH_LCR_InformationAddListIE_RL_ReconfReadyTDD, "id-DL-DPCH-LCR-InformationAddListIE-RL-ReconfReadyTDD" },
  { id_DL_Timeslot_LCR_InformationModifyList_RL_ReconfReadyTDD, "id-DL-Timeslot-LCR-InformationModifyList-RL-ReconfReadyTDD" },
  { id_UL_Timeslot_LCR_InformationList_PhyChReconfRqstTDD, "id-UL-Timeslot-LCR-InformationList-PhyChReconfRqstTDD" },
  { id_DL_Timeslot_LCR_InformationList_PhyChReconfRqstTDD, "id-DL-Timeslot-LCR-InformationList-PhyChReconfRqstTDD" },
  { id_timeSlot_ISCP_LCR_List_DL_PC_Rqst_TDD, "id-timeSlot-ISCP-LCR-List-DL-PC-Rqst-TDD" },
  { id_TSTD_Support_Indicator_RL_SetupRqstTDD, "id-TSTD-Support-Indicator-RL-SetupRqstTDD" },
  { id_RestrictionStateIndicator, "id-RestrictionStateIndicator" },
  { id_Load_Value, "id-Load-Value" },
  { id_Load_Value_IncrDecrThres, "id-Load-Value-IncrDecrThres" },
  { id_OnModification, "id-OnModification" },
  { id_Received_Total_Wideband_Power_Value, "id-Received-Total-Wideband-Power-Value" },
  { id_Received_Total_Wideband_Power_Value_IncrDecrThres, "id-Received-Total-Wideband-Power-Value-IncrDecrThres" },
  { id_SFNSFNMeasurementThresholdInformation, "id-SFNSFNMeasurementThresholdInformation" },
  { id_Transmitted_Carrier_Power_Value, "id-Transmitted-Carrier-Power-Value" },
  { id_Transmitted_Carrier_Power_Value_IncrDecrThres, "id-Transmitted-Carrier-Power-Value-IncrDecrThres" },
  { id_TUTRANGPSMeasurementThresholdInformation, "id-TUTRANGPSMeasurementThresholdInformation" },
  { id_UL_Timeslot_ISCP_Value, "id-UL-Timeslot-ISCP-Value" },
  { id_UL_Timeslot_ISCP_Value_IncrDecrThres, "id-UL-Timeslot-ISCP-Value-IncrDecrThres" },
  { id_Rx_Timing_Deviation_Value_LCR, "id-Rx-Timing-Deviation-Value-LCR" },
  { id_DPC_Mode_Change_SupportIndicator, "id-DPC-Mode-Change-SupportIndicator" },
  { id_Unused_ProtocolIE_ID_247, "id-Unused-ProtocolIE-ID-247" },
  { id_Unused_ProtocolIE_ID_295, "id-Unused-ProtocolIE-ID-295" },
  { id_PrimaryCCPCH_RSCP_RL_ReconfPrepTDD, "id-PrimaryCCPCH-RSCP-RL-ReconfPrepTDD" },
  { id_DL_TimeSlot_ISCP_Info_RL_ReconfPrepTDD, "id-DL-TimeSlot-ISCP-Info-RL-ReconfPrepTDD" },
  { id_DL_Timeslot_ISCP_LCR_Information_RL_ReconfPrepTDD, "id-DL-Timeslot-ISCP-LCR-Information-RL-ReconfPrepTDD" },
  { id_DSCH_RNTI, "id-DSCH-RNTI" },
  { id_DL_PowerBalancing_Information, "id-DL-PowerBalancing-Information" },
  { id_DL_PowerBalancing_ActivationIndicator, "id-DL-PowerBalancing-ActivationIndicator" },
  { id_DL_PowerBalancing_UpdatedIndicator, "id-DL-PowerBalancing-UpdatedIndicator" },
  { id_DL_ReferencePowerInformation, "id-DL-ReferencePowerInformation" },
  { id_Enhanced_PrimaryCPICH_EcNo, "id-Enhanced-PrimaryCPICH-EcNo" },
  { id_IPDL_TDD_ParametersLCR, "id-IPDL-TDD-ParametersLCR" },
  { id_CellCapabilityContainer_FDD, "id-CellCapabilityContainer-FDD" },
  { id_CellCapabilityContainer_TDD, "id-CellCapabilityContainer-TDD" },
  { id_CellCapabilityContainer_TDD_LCR, "id-CellCapabilityContainer-TDD-LCR" },
  { id_RL_Specific_DCH_Info, "id-RL-Specific-DCH-Info" },
  { id_RL_ReconfigurationRequestFDD_RL_InformationList, "id-RL-ReconfigurationRequestFDD-RL-InformationList" },
  { id_RL_ReconfigurationRequestFDD_RL_Information_IEs, "id-RL-ReconfigurationRequestFDD-RL-Information-IEs" },
  { id_RL_ReconfigurationRequestTDD_RL_Information, "id-RL-ReconfigurationRequestTDD-RL-Information" },
  { id_CommonTransportChannelResourcesInitialisationNotRequired, "id-CommonTransportChannelResourcesInitialisationNotRequired" },
  { id_DelayedActivation, "id-DelayedActivation" },
  { id_DelayedActivationList_RL_ActivationCmdFDD, "id-DelayedActivationList-RL-ActivationCmdFDD" },
  { id_DelayedActivationInformation_RL_ActivationCmdFDD, "id-DelayedActivationInformation-RL-ActivationCmdFDD" },
  { id_DelayedActivationList_RL_ActivationCmdTDD, "id-DelayedActivationList-RL-ActivationCmdTDD" },
  { id_DelayedActivationInformation_RL_ActivationCmdTDD, "id-DelayedActivationInformation-RL-ActivationCmdTDD" },
  { id_neighbouringTDDCellMeasurementInformationLCR, "id-neighbouringTDDCellMeasurementInformationLCR" },
  { id_UL_SIR_Target_CCTrCH_InformationItem_RL_SetupRspTDD, "id-UL-SIR-Target-CCTrCH-InformationItem-RL-SetupRspTDD" },
  { id_UL_SIR_Target_CCTrCH_LCR_InformationItem_RL_SetupRspTDD, "id-UL-SIR-Target-CCTrCH-LCR-InformationItem-RL-SetupRspTDD" },
  { id_PrimCCPCH_RSCP_DL_PC_RqstTDD, "id-PrimCCPCH-RSCP-DL-PC-RqstTDD" },
  { id_HSDSCH_FDD_Information, "id-HSDSCH-FDD-Information" },
  { id_HSDSCH_FDD_Information_Response, "id-HSDSCH-FDD-Information-Response" },
  { id_HSDSCH_FDD_Update_Information, "id-HSDSCH-FDD-Update-Information" },
  { id_HSDSCH_Information_to_Modify, "id-HSDSCH-Information-to-Modify" },
  { id_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd, "id-HSDSCHMacdFlowSpecificInformationList-RL-PreemptRequiredInd" },
  { id_HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd, "id-HSDSCHMacdFlowSpecificInformationItem-RL-PreemptRequiredInd" },
  { id_HSDSCH_RNTI, "id-HSDSCH-RNTI" },
  { id_HSDSCH_TDD_Information, "id-HSDSCH-TDD-Information" },
  { id_HSDSCH_TDD_Information_Response, "id-HSDSCH-TDD-Information-Response" },
  { id_HSDSCH_TDD_Update_Information, "id-HSDSCH-TDD-Update-Information" },
  { id_HSPDSCH_RL_ID, "id-HSPDSCH-RL-ID" },
  { id_HSDSCH_MACdFlows_to_Add, "id-HSDSCH-MACdFlows-to-Add" },
  { id_HSDSCH_MACdFlows_to_Delete, "id-HSDSCH-MACdFlows-to-Delete" },
  { id_Angle_Of_Arrival_Value_LCR, "id-Angle-Of-Arrival-Value-LCR" },
  { id_TrafficClass, "id-TrafficClass" },
  { id_Unused_ProtocolIE_ID_248, "id-Unused-ProtocolIE-ID-248" },
  { id_Unused_ProtocolIE_ID_253, "id-Unused-ProtocolIE-ID-253" },
  { id_PDSCH_RL_ID, "id-PDSCH-RL-ID" },
  { id_TimeSlot_RL_SetupRspTDD, "id-TimeSlot-RL-SetupRspTDD" },
  { id_GERAN_Cell_Capability, "id-GERAN-Cell-Capability" },
  { id_GERAN_Classmark, "id-GERAN-Classmark" },
  { id_DSCH_InitialWindowSize, "id-DSCH-InitialWindowSize" },
  { id_UL_Synchronisation_Parameters_LCR, "id-UL-Synchronisation-Parameters-LCR" },
  { id_SNA_Information, "id-SNA-Information" },
  { id_MAChs_ResetIndicator, "id-MAChs-ResetIndicator" },
  { id_TDD_DL_DPCH_TimeSlotFormatModifyItem_LCR_RL_ReconfReadyTDD, "id-TDD-DL-DPCH-TimeSlotFormatModifyItem-LCR-RL-ReconfReadyTDD" },
  { id_TDD_UL_DPCH_TimeSlotFormatModifyItem_LCR_RL_ReconfReadyTDD, "id-TDD-UL-DPCH-TimeSlotFormatModifyItem-LCR-RL-ReconfReadyTDD" },
  { id_TDD_TPC_UplinkStepSize_LCR_RL_SetupRqstTDD, "id-TDD-TPC-UplinkStepSize-LCR-RL-SetupRqstTDD" },
  { id_UL_CCTrCH_InformationList_RL_AdditionRqstTDD, "id-UL-CCTrCH-InformationList-RL-AdditionRqstTDD" },
  { id_UL_CCTrCH_InformationItem_RL_AdditionRqstTDD, "id-UL-CCTrCH-InformationItem-RL-AdditionRqstTDD" },
  { id_DL_CCTrCH_InformationList_RL_AdditionRqstTDD, "id-DL-CCTrCH-InformationList-RL-AdditionRqstTDD" },
  { id_DL_CCTrCH_InformationItem_RL_AdditionRqstTDD, "id-DL-CCTrCH-InformationItem-RL-AdditionRqstTDD" },
  { id_TDD_TPC_UplinkStepSize_InformationAdd_LCR_RL_ReconfPrepTDD, "id-TDD-TPC-UplinkStepSize-InformationAdd-LCR-RL-ReconfPrepTDD" },
  { id_TDD_TPC_UplinkStepSize_InformationModify_LCR_RL_ReconfPrepTDD, "id-TDD-TPC-UplinkStepSize-InformationModify-LCR-RL-ReconfPrepTDD" },
  { id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD, "id-TDD-TPC-DownlinkStepSize-InformationAdd-RL-ReconfPrepTDD" },
  { id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD, "id-TDD-TPC-DownlinkStepSize-InformationModify-RL-ReconfPrepTDD" },
  { id_UL_TimingAdvanceCtrl_LCR, "id-UL-TimingAdvanceCtrl-LCR" },
  { id_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD, "id-HSPDSCH-Timeslot-InformationList-PhyChReconfRqstTDD" },
  { id_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD, "id-HSPDSCH-Timeslot-InformationListLCR-PhyChReconfRqstTDD" },
  { id_HS_SICH_Reception_Quality, "id-HS-SICH-Reception-Quality" },
  { id_HS_SICH_Reception_Quality_Measurement_Value, "id-HS-SICH-Reception-Quality-Measurement-Value" },
  { id_HSSICH_Info_DM_Rprt, "id-HSSICH-Info-DM-Rprt" },
  { id_HSSICH_Info_DM_Rqst, "id-HSSICH-Info-DM-Rqst" },
  { id_HSSICH_Info_DM, "id-HSSICH-Info-DM" },
  { id_CCTrCH_Maximum_DL_Power_RL_SetupRspTDD, "id-CCTrCH-Maximum-DL-Power-RL-SetupRspTDD" },
  { id_CCTrCH_Minimum_DL_Power_RL_SetupRspTDD, "id-CCTrCH-Minimum-DL-Power-RL-SetupRspTDD" },
  { id_CCTrCH_Maximum_DL_Power_RL_AdditionRspTDD, "id-CCTrCH-Maximum-DL-Power-RL-AdditionRspTDD" },
  { id_CCTrCH_Minimum_DL_Power_RL_AdditionRspTDD, "id-CCTrCH-Minimum-DL-Power-RL-AdditionRspTDD" },
  { id_CCTrCH_Maximum_DL_Power_RL_ReconfReadyTDD, "id-CCTrCH-Maximum-DL-Power-RL-ReconfReadyTDD" },
  { id_CCTrCH_Minimum_DL_Power_RL_ReconfReadyTDD, "id-CCTrCH-Minimum-DL-Power-RL-ReconfReadyTDD" },
  { id_Maximum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD, "id-Maximum-DL-Power-TimeslotLCR-InformationModifyItem-RL-ReconfReadyTDD" },
  { id_Minimum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD, "id-Minimum-DL-Power-TimeslotLCR-InformationModifyItem-RL-ReconfReadyTDD" },
  { id_DL_CCTrCH_InformationList_RL_ReconfRspTDD, "id-DL-CCTrCH-InformationList-RL-ReconfRspTDD" },
  { id_DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD, "id-DL-DPCH-InformationModifyItem-LCR-RL-ReconfRspTDD" },
  { id_Maximum_DL_Power_TimeslotLCR_InformationItem, "id-Maximum-DL-Power-TimeslotLCR-InformationItem" },
  { id_Minimum_DL_Power_TimeslotLCR_InformationItem, "id-Minimum-DL-Power-TimeslotLCR-InformationItem" },
  { id_TDD_Support_8PSK, "id-TDD-Support-8PSK" },
  { id_TDD_maxNrDLPhysicalchannels, "id-TDD-maxNrDLPhysicalchannels" },
  { id_ExtendedGSMCellIndividualOffset, "id-ExtendedGSMCellIndividualOffset" },
  { id_RL_ParameterUpdateIndicationFDD_RL_InformationList, "id-RL-ParameterUpdateIndicationFDD-RL-InformationList" },
  { id_Primary_CPICH_Usage_For_Channel_Estimation, "id-Primary-CPICH-Usage-For-Channel-Estimation" },
  { id_Secondary_CPICH_Information, "id-Secondary-CPICH-Information" },
  { id_Secondary_CPICH_Information_Change, "id-Secondary-CPICH-Information-Change" },
  { id_Unused_ProtocolIE_ID_522, "id-Unused-ProtocolIE-ID-522" },
  { id_Unused_ProtocolIE_ID_523, "id-Unused-ProtocolIE-ID-523" },
  { id_RL_ParameterUpdateIndicationFDD_RL_Information_Item, "id-RL-ParameterUpdateIndicationFDD-RL-Information-Item" },
  { id_Phase_Reference_Update_Indicator, "id-Phase-Reference-Update-Indicator" },
  { id_Unidirectional_DCH_Indicator, "id-Unidirectional-DCH-Indicator" },
  { id_RL_Information_RL_ReconfPrepTDD, "id-RL-Information-RL-ReconfPrepTDD" },
  { id_Multiple_RL_InformationResponse_RL_ReconfReadyTDD, "id-Multiple-RL-InformationResponse-RL-ReconfReadyTDD" },
  { id_RL_ReconfigurationResponseTDD_RL_Information, "id-RL-ReconfigurationResponseTDD-RL-Information" },
  { id_Satellite_Almanac_Information_ExtItem, "id-Satellite-Almanac-Information-ExtItem" },
  { id_HSDSCH_Information_to_Modify_Unsynchronised, "id-HSDSCH-Information-to-Modify-Unsynchronised" },
  { id_TnlQos, "id-TnlQos" },
  { id_RTLoadValue, "id-RTLoadValue" },
  { id_NRTLoadInformationValue, "id-NRTLoadInformationValue" },
  { id_CellPortionID, "id-CellPortionID" },
  { id_UpPTSInterferenceValue, "id-UpPTSInterferenceValue" },
  { id_PrimaryCCPCH_RSCP_Delta, "id-PrimaryCCPCH-RSCP-Delta" },
  { id_UEMeasurementType, "id-UEMeasurementType" },
  { id_UEMeasurementTimeslotInfoHCR, "id-UEMeasurementTimeslotInfoHCR" },
  { id_UEMeasurementTimeslotInfoLCR, "id-UEMeasurementTimeslotInfoLCR" },
  { id_UEMeasurementReportCharacteristics, "id-UEMeasurementReportCharacteristics" },
  { id_UEMeasurementParameterModAllow, "id-UEMeasurementParameterModAllow" },
  { id_UEMeasurementValueInformation, "id-UEMeasurementValueInformation" },
  { id_InterfacesToTraceItem, "id-InterfacesToTraceItem" },
  { id_ListOfInterfacesToTrace, "id-ListOfInterfacesToTrace" },
  { id_TraceDepth, "id-TraceDepth" },
  { id_TraceRecordingSessionReference, "id-TraceRecordingSessionReference" },
  { id_TraceReference, "id-TraceReference" },
  { id_UEIdentity, "id-UEIdentity" },
  { id_NACC_Related_Data, "id-NACC-Related-Data" },
  { id_GSM_Cell_InfEx_Rqst, "id-GSM-Cell-InfEx-Rqst" },
  { id_MeasurementRecoveryBehavior, "id-MeasurementRecoveryBehavior" },
  { id_MeasurementRecoveryReportingIndicator, "id-MeasurementRecoveryReportingIndicator" },
  { id_MeasurementRecoverySupportIndicator, "id-MeasurementRecoverySupportIndicator" },
  { id_DL_DPCH_Power_Information_RL_ReconfPrepFDD, "id-DL-DPCH-Power-Information-RL-ReconfPrepFDD" },
  { id_F_DPCH_Information_RL_ReconfPrepFDD, "id-F-DPCH-Information-RL-ReconfPrepFDD" },
  { id_F_DPCH_Information_RL_SetupRqstFDD, "id-F-DPCH-Information-RL-SetupRqstFDD" },
  { id_MBMS_Bearer_Service_List, "id-MBMS-Bearer-Service-List" },
  { id_MBMS_Bearer_Service_List_InfEx_Rsp, "id-MBMS-Bearer-Service-List-InfEx-Rsp" },
  { id_Active_MBMS_Bearer_ServiceFDD, "id-Active-MBMS-Bearer-ServiceFDD" },
  { id_Active_MBMS_Bearer_ServiceTDD, "id-Active-MBMS-Bearer-ServiceTDD" },
  { id_Old_URA_ID, "id-Old-URA-ID" },
  { id_UE_State, "id-UE-State" },
  { id_URA_ID, "id-URA-ID" },
  { id_HARQ_Preamble_Mode, "id-HARQ-Preamble-Mode" },
  { id_SynchronisationIndicator, "id-SynchronisationIndicator" },
  { id_UL_DPDCHIndicatorEDCH, "id-UL-DPDCHIndicatorEDCH" },
  { id_EDPCH_Information, "id-EDPCH-Information" },
  { id_RL_Specific_EDCH_Information, "id-RL-Specific-EDCH-Information" },
  { id_EDCH_RL_Indication, "id-EDCH-RL-Indication" },
  { id_EDCH_FDD_Information, "id-EDCH-FDD-Information" },
  { id_EDCH_RLSet_Id, "id-EDCH-RLSet-Id" },
  { id_Serving_EDCHRL_Id, "id-Serving-EDCHRL-Id" },
  { id_EDCH_FDD_DL_ControlChannelInformation, "id-EDCH-FDD-DL-ControlChannelInformation" },
  { id_EDCH_FDD_InformationResponse, "id-EDCH-FDD-InformationResponse" },
  { id_EDCH_MACdFlows_To_Add, "id-EDCH-MACdFlows-To-Add" },
  { id_EDCH_FDD_Information_To_Modify, "id-EDCH-FDD-Information-To-Modify" },
  { id_EDCH_MACdFlows_To_Delete, "id-EDCH-MACdFlows-To-Delete" },
  { id_EDPCH_Information_RLReconfRequest_FDD, "id-EDPCH-Information-RLReconfRequest-FDD" },
  { id_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd, "id-EDCH-MacdFlowSpecificInformationList-RL-PreemptRequiredInd" },
  { id_EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd, "id-EDCH-MacdFlowSpecificInformationItem-RL-PreemptRequiredInd" },
  { id_EDCH_MacdFlowSpecificInformationList_RL_CongestInd, "id-EDCH-MacdFlowSpecificInformationList-RL-CongestInd" },
  { id_EDCH_MacdFlowSpecificInformationItem_RL_CongestInd, "id-EDCH-MacdFlowSpecificInformationItem-RL-CongestInd" },
  { id_MBMS_Bearer_Service_Full_Address, "id-MBMS-Bearer-Service-Full-Address" },
  { id_Initial_DL_DPCH_TimingAdjustment, "id-Initial-DL-DPCH-TimingAdjustment" },
  { id_Initial_DL_DPCH_TimingAdjustment_Allowed, "id-Initial-DL-DPCH-TimingAdjustment-Allowed" },
  { id_User_Plane_Congestion_Fields_Inclusion, "id-User-Plane-Congestion-Fields-Inclusion" },
  { id_HARQ_Preamble_Mode_Activation_Indicator, "id-HARQ-Preamble-Mode-Activation-Indicator" },
  { id_multiple_DedicatedMeasurementValueList_TDD_DM_Rsp, "id-multiple-DedicatedMeasurementValueList-TDD-DM-Rsp" },
  { id_multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp, "id-multiple-DedicatedMeasurementValueList-LCR-TDD-DM-Rsp" },
  { id_ProvidedInformation, "id-ProvidedInformation" },
  { id_Active_MBMS_Bearer_ServiceFDD_PFL, "id-Active-MBMS-Bearer-ServiceFDD-PFL" },
  { id_Active_MBMS_Bearer_ServiceTDD_PFL, "id-Active-MBMS-Bearer-ServiceTDD-PFL" },
  { id_FrequencyBandIndicator, "id-FrequencyBandIndicator" },
  { id_Serving_cell_change_CFN, "id-Serving-cell-change-CFN" },
  { id_HS_DSCH_serving_cell_change_information, "id-HS-DSCH-serving-cell-change-information" },
  { id_HS_DSCH_serving_cell_change_informationResponse, "id-HS-DSCH-serving-cell-change-informationResponse" },
  { id_E_DCH_Serving_cell_change_informationResponse, "id-E-DCH-Serving-cell-change-informationResponse" },
  { id_secondary_LCR_CCPCH_Info_TDD, "id-secondary-LCR-CCPCH-Info-TDD" },
  { id_E_DCH_FDD_Update_Information, "id-E-DCH-FDD-Update-Information" },
  { id_Inter_Frequency_Cell_List, "id-Inter-Frequency-Cell-List" },
  { id_Inter_Frequency_Cell_Information, "id-Inter-Frequency-Cell-Information" },
  { id_multiple_HSSICHMeasurementValueList_TDD_DM_Rsp, "id-multiple-HSSICHMeasurementValueList-TDD-DM-Rsp" },
  { id_TDD_Support_PLCCH, "id-TDD-Support-PLCCH" },
  { id_PLCCH_Information_UL_TimeslotLCR_Info, "id-PLCCH-Information-UL-TimeslotLCR-Info" },
  { id_PLCCH_Information_PhyChReconfRqstTDD, "id-PLCCH-Information-PhyChReconfRqstTDD" },
  { id_TDD768_maxNrDLPhysicalchannelsTS, "id-TDD768-maxNrDLPhysicalchannelsTS" },
  { id_RL_InformationResponse_RL_AdditionRspTDD768, "id-RL-InformationResponse-RL-AdditionRspTDD768" },
  { id_UL_CCTrCH_InformationListIE_RL_AdditionRspTDD768, "id-UL-CCTrCH-InformationListIE-RL-AdditionRspTDD768" },
  { id_DL_CCTrCH_InformationListIE_RL_AdditionRspTDD768, "id-DL-CCTrCH-InformationListIE-RL-AdditionRspTDD768" },
  { id_UL_DPCH_InformationItem_RL_AdditionRspTDD768, "id-UL-DPCH-InformationItem-RL-AdditionRspTDD768" },
  { id_DL_DPCH_InformationItem_RL_AdditionRspTDD768, "id-DL-DPCH-InformationItem-RL-AdditionRspTDD768" },
  { id_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD768, "id-UL-DPCH-InformationAddListIE-RL-ReconfReadyTDD768" },
  { id_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768, "id-UL-Timeslot-InformationModifyList-RL-ReconfReadyTDD768" },
  { id_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD768, "id-DL-DPCH-InformationAddListIE-RL-ReconfReadyTDD768" },
  { id_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD768, "id-DL-Timeslot-InformationModifyList-RL-ReconfReadyTDD768" },
  { id_secondary_CCPCH_Info_RL_ReconfReadyTDD768, "id-secondary-CCPCH-Info-RL-ReconfReadyTDD768" },
  { id_hSSCCH_TDD_Specific_InfoList_Response768, "id-hSSCCH-TDD-Specific-InfoList-Response768" },
  { id_hSPDSCH_TDD_Specific_InfoList_Response768, "id-hSPDSCH-TDD-Specific-InfoList-Response768" },
  { id_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD768, "id-HSPDSCH-Timeslot-InformationList-PhyChReconfRqstTDD768" },
  { id_UL_Timeslot_InformationList_PhyChReconfRqstTDD768, "id-UL-Timeslot-InformationList-PhyChReconfRqstTDD768" },
  { id_DL_Timeslot_InformationList_PhyChReconfRqstTDD768, "id-DL-Timeslot-InformationList-PhyChReconfRqstTDD768" },
  { id_CellCapabilityContainer_TDD768, "id-CellCapabilityContainer-TDD768" },
  { id_multiple_DedicatedMeasurementValueList_TDD768_DM_Rsp, "id-multiple-DedicatedMeasurementValueList-TDD768-DM-Rsp" },
  { id_neighbouringTDDCellMeasurementInformation768, "id-neighbouringTDDCellMeasurementInformation768" },
  { id_UEMeasurementTimeslotInfo768, "id-UEMeasurementTimeslotInfo768" },
  { id_Rx_Timing_Deviation_Value_768, "id-Rx-Timing-Deviation-Value-768" },
  { id_UEMeasurementValueTransmittedPowerList768, "id-UEMeasurementValueTransmittedPowerList768" },
  { id_UEMeasurementValueTimeslotISCPList768, "id-UEMeasurementValueTimeslotISCPList768" },
  { id_RL_InformationResponse_RL_SetupRspTDD768, "id-RL-InformationResponse-RL-SetupRspTDD768" },
  { id_UL_CCTrCH_InformationListIE_RL_SetupRspTDD768, "id-UL-CCTrCH-InformationListIE-RL-SetupRspTDD768" },
  { id_DL_CCTrCH_InformationListIE_RL_SetupRspTDD768, "id-DL-CCTrCH-InformationListIE-RL-SetupRspTDD768" },
  { id_UL_DPCH_InformationItem_RL_SetupRspTDD768, "id-UL-DPCH-InformationItem-RL-SetupRspTDD768" },
  { id_DL_DPCH_InformationItem_RL_SetupRspTDD768, "id-DL-DPCH-InformationItem-RL-SetupRspTDD768" },
  { id_TDD768_minimumSpreadingFactor_UL, "id-TDD768-minimumSpreadingFactor-UL" },
  { id_TDD768_minimumSpreadingFactor_DL, "id-TDD768-minimumSpreadingFactor-DL" },
  { id_TDD768_maxNrDLPhysicalchannels, "id-TDD768-maxNrDLPhysicalchannels" },
  { id_DL_DPCH_InformationDeleteList768_RL_ReconfReadyTDD, "id-DL-DPCH-InformationDeleteList768-RL-ReconfReadyTDD" },
  { id_DPCH_ID768_DM_Rsp, "id-DPCH-ID768-DM-Rsp" },
  { id_DPCH_ID768_DM_Rqst, "id-DPCH-ID768-DM-Rqst" },
  { id_DPCH_ID768_DM_Rprt, "id-DPCH-ID768-DM-Rprt" },
  { id_EDPCH_Information_RLAdditionReq_FDD, "id-EDPCH-Information-RLAdditionReq-FDD" },
  { id_HSDSCH_Configured_Indicator, "id-HSDSCH-Configured-Indicator" },
  { id_RxTimingDeviationForTAext, "id-RxTimingDeviationForTAext" },
  { id_RxTimingDeviationForTA768, "id-RxTimingDeviationForTA768" },
  { id_Rx_Timing_Deviation_Value_ext, "id-Rx-Timing-Deviation-Value-ext" },
  { id_E_DCH_PowerOffset_for_SchedulingInfo, "id-E-DCH-PowerOffset-for-SchedulingInfo" },
  { id_TrCH_SrcStatisticsDescr, "id-TrCH-SrcStatisticsDescr" },
  { id_E_DCH_Information, "id-E-DCH-Information" },
  { id_E_DCH_Serving_RL_ID, "id-E-DCH-Serving-RL-ID" },
  { id_E_DCH_Information_Reconfig, "id-E-DCH-Information-Reconfig" },
  { id_E_DCH_Information_Response, "id-E-DCH-Information-Response" },
  { id_E_DCH_768_Information, "id-E-DCH-768-Information" },
  { id_E_DCH_768_Information_Reconfig, "id-E-DCH-768-Information-Reconfig" },
  { id_E_DCH_768_Information_Response, "id-E-DCH-768-Information-Response" },
  { id_ExtendedPropagationDelay, "id-ExtendedPropagationDelay" },
  { id_Extended_Round_Trip_Time_Value, "id-Extended-Round-Trip-Time-Value" },
  { id_AlternativeFormatReportingIndicator, "id-AlternativeFormatReportingIndicator" },
  { id_DCH_Indicator_For_E_DCH_HSDPA_Operation, "id-DCH-Indicator-For-E-DCH-HSDPA-Operation" },
  { id_E_RGCH_E_HICH_ChannelisationCodeValidityIndicator, "id-E-RGCH-E-HICH-ChannelisationCodeValidityIndicator" },
  { id_E_DCH_Minimum_Set_E_TFCIValidityIndicator, "id-E-DCH-Minimum-Set-E-TFCIValidityIndicator" },
  { id_Fast_Reconfiguration_Mode, "id-Fast-Reconfiguration-Mode" },
  { id_Fast_Reconfiguration_Permission, "id-Fast-Reconfiguration-Permission" },
  { id_Continuous_Packet_Connectivity_DTX_DRX_Information, "id-Continuous-Packet-Connectivity-DTX-DRX-Information" },
  { id_Continuous_Packet_Connectivity_HS_SCCH_Less_Information, "id-Continuous-Packet-Connectivity-HS-SCCH-Less-Information" },
  { id_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response, "id-Continuous-Packet-Connectivity-HS-SCCH-Less-Information-Response" },
  { id_CPC_Information, "id-CPC-Information" },
  { id_MIMO_Information, "id-MIMO-Information" },
  { id_MIMO_InformationResponse, "id-MIMO-InformationResponse" },
  { id_MIMO_InformationToModify, "id-MIMO-InformationToModify" },
  { id_E_DCH_LCR_Information, "id-E-DCH-LCR-Information" },
  { id_E_DCH_LCR_Information_Reconfig, "id-E-DCH-LCR-Information-Reconfig" },
  { id_E_DCH_LCR_Information_Response, "id-E-DCH-LCR-Information-Response" },
  { id_HS_PDSCH_Code_Change_Grant, "id-HS-PDSCH-Code-Change-Grant" },
  { id_HS_PDSCH_Code_Change_Indicator, "id-HS-PDSCH-Code-Change-Indicator" },
  { id_Extended_SRNC_ID, "id-Extended-SRNC-ID" },
  { id_Extended_RNC_ID, "id-Extended-RNC-ID" },
  { id_SixtyfourQAM_DL_SupportIndicator, "id-SixtyfourQAM-DL-SupportIndicator" },
  { id_Enhanced_FACH_Support_Indicator, "id-Enhanced-FACH-Support-Indicator" },
  { id_Enhanced_FACH_Information_ResponseFDD, "id-Enhanced-FACH-Information-ResponseFDD" },
  { id_SixteenQAM_UL_Information, "id-SixteenQAM-UL-Information" },
  { id_HSDSCH_MACdPDUSizeFormat, "id-HSDSCH-MACdPDUSizeFormat" },
  { id_MaximumMACdPDU_SizeExtended, "id-MaximumMACdPDU-SizeExtended" },
  { id_F_DPCH_SlotFormat, "id-F-DPCH-SlotFormat" },
  { id_F_DPCH_SlotFormatSupportRequest, "id-F-DPCH-SlotFormatSupportRequest" },
  { id_eDCH_MACdFlow_Retransmission_Timer_LCR, "id-eDCH-MACdFlow-Retransmission-Timer-LCR" },
  { id_Max_UE_DTX_Cycle, "id-Max-UE-DTX-Cycle" },
  { id_SixteenQAM_UL_Information_to_Modify, "id-SixteenQAM-UL-Information-to-Modify" },
  { id_E_TFCI_BetaEC_Boost, "id-E-TFCI-BetaEC-Boost" },
  { id_E_TFCI_BetaED_Switch, "id-E-TFCI-BetaED-Switch" },
  { id_GANSS_Common_Data, "id-GANSS-Common-Data" },
  { id_GANSS_Information, "id-GANSS-Information" },
  { id_GANSS_Generic_Data, "id-GANSS-Generic-Data" },
  { id_TUTRANGANSSMeasurementThresholdInformation, "id-TUTRANGANSSMeasurementThresholdInformation" },
  { id_TUTRANGANSSMeasurementValueInformation, "id-TUTRANGANSSMeasurementValueInformation" },
  { id_Enhanced_PCH_Support_Indicator, "id-Enhanced-PCH-Support-Indicator" },
  { 0, NULL }
};


static int
dissect_rnsap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxProtocolIEs, &ProtocolIE_ID, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TransactionID_vals[] = {
  {   0, "shortTransActionId" },
  {   1, "longTransActionId" },
  { 0, NULL }
};

static const per_choice_t TransactionID_choice[] = {
  {   0, &hf_rnsap_shortTransActionId, ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_127 },
  {   1, &hf_rnsap_longTransActionId, ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_32767 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransactionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransactionID, TransactionID_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  {   3, "outcome" },
  { 0, NULL }
};


static int
dissect_rnsap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_ProtocolIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_rnsap_id            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_value         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_rnsap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Field },
};

static int
dissect_rnsap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs);

  return offset;
}



static int
dissect_rnsap_ProtocolIE_Single_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_rnsap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_rnsap_id            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_extensionValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_rnsap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolExtensionField },
};

static int
dissect_rnsap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions);

  return offset;
}



static int
dissect_rnsap_PrivateIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_rnsap_id_01         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PrivateIE_ID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_value_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PrivateIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_rnsap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PrivateIE_Field },
};

static int
dissect_rnsap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs);

  return offset;
}



static int
dissect_rnsap_AccessPointName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 255, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_AckNack_RepetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_Ack_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_Service_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, NULL);

  return offset;
}


static const per_sequence_t TMGI_sequence[] = {
  { &hf_rnsap_plmn_id       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_service_id    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Service_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TMGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TMGI, TMGI_sequence);

  return offset;
}


static const value_string rnsap_TransmissionMode_vals[] = {
  {   0, "p-t-p" },
  {   1, "p-t-m" },
  {   2, "not-provided" },
  { 0, NULL }
};


static int
dissect_rnsap_TransmissionMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MBMS_Bearer_ServiceItemFDD_sequence[] = {
  { &hf_rnsap_tmgi          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TMGI },
  { &hf_rnsap_transmissionMode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionMode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMS_Bearer_ServiceItemFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMS_Bearer_ServiceItemFDD, MBMS_Bearer_ServiceItemFDD_sequence);

  return offset;
}


static const per_sequence_t Active_MBMS_Bearer_Service_ListFDD_sequence_of[1] = {
  { &hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MBMS_Bearer_ServiceItemFDD },
};

static int
dissect_rnsap_Active_MBMS_Bearer_Service_ListFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Active_MBMS_Bearer_Service_ListFDD, Active_MBMS_Bearer_Service_ListFDD_sequence_of,
                                                  1, maxNrOfActiveMBMSServices);

  return offset;
}



static int
dissect_rnsap_UARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, TRUE);

  return offset;
}


static const per_sequence_t MBMS_Bearer_ServiceItemFDD_PFL_sequence[] = {
  { &hf_rnsap_tmgi          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TMGI },
  { &hf_rnsap_transmissionMode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransmissionMode },
  { &hf_rnsap_preferredFrequencyLayer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMS_Bearer_ServiceItemFDD_PFL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMS_Bearer_ServiceItemFDD_PFL, MBMS_Bearer_ServiceItemFDD_PFL_sequence);

  return offset;
}


static const per_sequence_t Active_MBMS_Bearer_Service_ListFDD_PFL_sequence_of[1] = {
  { &hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MBMS_Bearer_ServiceItemFDD_PFL },
};

static int
dissect_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL, Active_MBMS_Bearer_Service_ListFDD_PFL_sequence_of,
                                                  1, maxNrOfActiveMBMSServices);

  return offset;
}


static const per_sequence_t MBMS_Bearer_ServiceItemTDD_sequence[] = {
  { &hf_rnsap_tmgi          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TMGI },
  { &hf_rnsap_transmissionMode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionMode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMS_Bearer_ServiceItemTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMS_Bearer_ServiceItemTDD, MBMS_Bearer_ServiceItemTDD_sequence);

  return offset;
}


static const per_sequence_t Active_MBMS_Bearer_Service_ListTDD_sequence_of[1] = {
  { &hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MBMS_Bearer_ServiceItemTDD },
};

static int
dissect_rnsap_Active_MBMS_Bearer_Service_ListTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Active_MBMS_Bearer_Service_ListTDD, Active_MBMS_Bearer_Service_ListTDD_sequence_of,
                                                  1, maxNrOfActiveMBMSServices);

  return offset;
}


static const per_sequence_t MBMS_Bearer_ServiceItemTDD_PFL_sequence[] = {
  { &hf_rnsap_tmgi          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TMGI },
  { &hf_rnsap_transmissionMode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransmissionMode },
  { &hf_rnsap_preferredFrequencyLayer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMS_Bearer_ServiceItemTDD_PFL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMS_Bearer_ServiceItemTDD_PFL, MBMS_Bearer_ServiceItemTDD_PFL_sequence);

  return offset;
}


static const per_sequence_t Active_MBMS_Bearer_Service_ListTDD_PFL_sequence_of[1] = {
  { &hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MBMS_Bearer_ServiceItemTDD_PFL },
};

static int
dissect_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL, Active_MBMS_Bearer_Service_ListTDD_PFL_sequence_of,
                                                  1, maxNrOfActiveMBMSServices);

  return offset;
}



static int
dissect_rnsap_CFN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TGPSID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxTGPS, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TGPRC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Status_List_item_sequence[] = {
  { &hf_rnsap_tGPSID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGPSID },
  { &hf_rnsap_tGPRC         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGPRC },
  { &hf_rnsap_tGCFN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CFN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item, Transmission_Gap_Pattern_Sequence_Status_List_item_sequence);

  return offset;
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Status_List_sequence_of[1] = {
  { &hf_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item },
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List, Transmission_Gap_Pattern_Sequence_Status_List_sequence_of,
                                                  0, maxTGPS);

  return offset;
}


static const per_sequence_t Active_Pattern_Sequence_Information_sequence[] = {
  { &hf_rnsap_cMConfigurationChangeCFN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CFN },
  { &hf_rnsap_transmission_Gap_Pattern_Sequence_Status, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Active_Pattern_Sequence_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Active_Pattern_Sequence_Information, Active_Pattern_Sequence_Information_sequence);

  return offset;
}



static int
dissect_rnsap_C_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CorrespondingCells_sequence_of[1] = {
  { &hf_rnsap_CorrespondingCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
};

static int
dissect_rnsap_CorrespondingCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CorrespondingCells, CorrespondingCells_sequence_of,
                                                  1, maxNrOfCellsPerFreq);

  return offset;
}


static const per_sequence_t AdditionalPreferredFrequencyItem_sequence[] = {
  { &hf_rnsap_dL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_correspondingCells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CorrespondingCells },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_AdditionalPreferredFrequencyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_AdditionalPreferredFrequencyItem, AdditionalPreferredFrequencyItem_sequence);

  return offset;
}


static const per_sequence_t AdditionalPreferredFrequency_sequence_of[1] = {
  { &hf_rnsap_AdditionalPreferredFrequency_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_AdditionalPreferredFrequencyItem },
};

static int
dissect_rnsap_AdditionalPreferredFrequency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_AdditionalPreferredFrequency, AdditionalPreferredFrequency_sequence_of,
                                                  1, maxNrOfAddFreq);

  return offset;
}



static int
dissect_rnsap_AdjustmentPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_S_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, FALSE);

  return offset;
}


static const per_sequence_t AffectedUEInformationForMBMS_sequence_of[1] = {
  { &hf_rnsap_AffectedUEInformationForMBMS_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_S_RNTI },
};

static int
dissect_rnsap_AffectedUEInformationForMBMS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_AffectedUEInformationForMBMS, AffectedUEInformationForMBMS_sequence_of,
                                                  1, maxNrOfUEs);

  return offset;
}



static int
dissect_rnsap_PriorityLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_Pre_emptionCapability_vals[] = {
  {   0, "shall-not-trigger-pre-emption" },
  {   1, "may-trigger-pre-emption" },
  { 0, NULL }
};


static int
dissect_rnsap_Pre_emptionCapability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_Pre_emptionVulnerability_vals[] = {
  {   0, "not-pre-emptable" },
  {   1, "pre-emptable" },
  { 0, NULL }
};


static int
dissect_rnsap_Pre_emptionVulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationRetentionPriority_sequence[] = {
  { &hf_rnsap_priorityLevel , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityLevel },
  { &hf_rnsap_pre_emptionCapability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Pre_emptionCapability },
  { &hf_rnsap_pre_emptionVulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Pre_emptionVulnerability },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_AllocationRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_AllocationRetentionPriority, AllocationRetentionPriority_sequence);

  return offset;
}



static int
dissect_rnsap_Allowed_Rate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfTFs, NULL, FALSE);

  return offset;
}


static const per_sequence_t Allowed_Rate_Information_sequence[] = {
  { &hf_rnsap_allowed_UL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Allowed_Rate },
  { &hf_rnsap_allowed_DL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Allowed_Rate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Allowed_Rate_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Allowed_Rate_Information, Allowed_Rate_Information_sequence);

  return offset;
}



static int
dissect_rnsap_AllowedQueuingTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 60U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_AlphaValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_AlternativeFormatReportingIndicator_vals[] = {
  {   0, "alternativeFormatAllowed" },
  { 0, NULL }
};


static int
dissect_rnsap_AlternativeFormatReportingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_AOA_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 719U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_AOA_LCR_Accuracy_Class_vals[] = {
  {   0, "a" },
  {   1, "b" },
  {   2, "c" },
  {   3, "d" },
  {   4, "e" },
  {   5, "f" },
  {   6, "g" },
  {   7, "h" },
  { 0, NULL }
};


static int
dissect_rnsap_AOA_LCR_Accuracy_Class(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Angle_Of_Arrival_Value_LCR_sequence[] = {
  { &hf_rnsap_aOA_LCR       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AOA_LCR },
  { &hf_rnsap_aOA_LCR_Accuracy_Class, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AOA_LCR_Accuracy_Class },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Angle_Of_Arrival_Value_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Angle_Of_Arrival_Value_LCR, Angle_Of_Arrival_Value_LCR_sequence);

  return offset;
}


static const value_string rnsap_AntennaColocationIndicator_vals[] = {
  {   0, "co-located" },
  { 0, NULL }
};


static int
dissect_rnsap_AntennaColocationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_SAT_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_badSatelliteInformation_item_sequence[] = {
  { &hf_rnsap_badSAT_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAT_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_badSatelliteInformation_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_badSatelliteInformation_item, T_badSatelliteInformation_item_sequence);

  return offset;
}


static const per_sequence_t T_badSatelliteInformation_sequence_of[1] = {
  { &hf_rnsap_badSatelliteInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_badSatelliteInformation_item },
};

static int
dissect_rnsap_T_badSatelliteInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_T_badSatelliteInformation, T_badSatelliteInformation_sequence_of,
                                                  1, maxNoSat);

  return offset;
}


static const per_sequence_t BadSatellites_sequence[] = {
  { &hf_rnsap_badSatelliteInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_badSatelliteInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_BadSatellites(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_BadSatellites, BadSatellites_sequence);

  return offset;
}


static const value_string rnsap_Band_Indicator_vals[] = {
  {   0, "dcs1800Band" },
  {   1, "pcs1900Band" },
  { 0, NULL }
};


static int
dissect_rnsap_Band_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_BCC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     3, 3, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BCCH_ARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_BetaCD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_BindingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 4, TRUE, NULL);

  return offset;
}



static int
dissect_rnsap_BLER(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -63, 0U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_SCTD_Indicator_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_rnsap_SCTD_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_NCC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     3, 3, FALSE, NULL);

  return offset;
}


static const per_sequence_t BSIC_sequence[] = {
  { &hf_rnsap_nCC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_NCC },
  { &hf_rnsap_bCC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_BCC },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_BSIC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_BSIC, BSIC_sequence);

  return offset;
}


static const value_string rnsap_BundlingModeIndicator_vals[] = {
  {   0, "bundling" },
  {   1, "no-bundling" },
  { 0, NULL }
};


static int
dissect_rnsap_BundlingModeIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_10_25(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            10U, 25U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t BurstModeParameters_sequence[] = {
  { &hf_rnsap_burstStart    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_15 },
  { &hf_rnsap_burstLength   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_10_25 },
  { &hf_rnsap_burstFreq     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_16 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_BurstModeParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_BurstModeParameters, BurstModeParameters_sequence);

  return offset;
}


static const value_string rnsap_CauseRadioNetwork_vals[] = {
  {   0, "unknown-C-ID" },
  {   1, "cell-not-available" },
  {   2, "power-level-not-supported" },
  {   3, "ul-scrambling-code-already-in-use" },
  {   4, "dl-radio-resources-not-available" },
  {   5, "ul-radio-resources-not-available" },
  {   6, "measurement-not-supported-for-the-object" },
  {   7, "combining-resources-not-available" },
  {   8, "combining-not-supported" },
  {   9, "reconfiguration-not-allowed" },
  {  10, "requested-configuration-not-supported" },
  {  11, "synchronisation-failure" },
  {  12, "requested-tx-diversity-mode-not-supported" },
  {  13, "measurement-temporaily-not-available" },
  {  14, "unspecified" },
  {  15, "invalid-CM-settings" },
  {  16, "reconfiguration-CFN-not-elapsed" },
  {  17, "number-of-DL-codes-not-supported" },
  {  18, "dedicated-transport-channel-type-not-supported" },
  {  19, "dl-shared-channel-type-not-supported" },
  {  20, "ul-shared-channel-type-not-supported" },
  {  21, "common-transport-channel-type-not-supported" },
  {  22, "ul-spreading-factor-not-supported" },
  {  23, "dl-spreading-factor-not-supported" },
  {  24, "cm-not-supported" },
  {  25, "transaction-not-supported-by-destination-node-b" },
  {  26, "rl-already-activated-or-alocated" },
  {  27, "number-of-UL-codes-not-supported" },
  {  28, "cell-reserved-for-operator-use" },
  {  29, "dpc-mode-change-not-supported" },
  {  30, "information-temporarily-not-available" },
  {  31, "information-provision-not-supported-for-the-object" },
  {  32, "power-balancing-status-not-compatible" },
  {  33, "delayed-activation-not-supported" },
  {  34, "rl-timing-adjustment-not-supported" },
  {  35, "unknown-RNTI" },
  {  36, "measurement-repetition-rate-not-compatible" },
  {  37, "ue-not-capable-of-support" },
  {  38, "f-dpch-not-supported" },
  {  39, "e-dch-not-supported" },
  {  40, "continuous-packet-connectivity-dtx-drx-operation-not-supported" },
  {  41, "continuous-packet-connectivity-hs-scch-less-operation-not-supported" },
  {  42, "mimo-not-supported" },
  {  43, "e-dch-tti2ms-not-supported" },
  {  44, "continuous-packet-connectivity-DTX-DRX-operation-not-available" },
  {  45, "continuous-packet-connectivity-UE-DTX-Cycle-not-available" },
  {  46, "mimo-not-available" },
  {  47, "sixteenQAM-UL-not-Supported" },
  {  48, "hSDSCH-MACdPDU-SizeFormatNotSupported" },
  {  49, "f-dpch-slot-format-operation-not-supported" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseRadioNetwork(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     27, NULL, TRUE, 23, NULL);

  return offset;
}


static const value_string rnsap_CauseTransport_vals[] = {
  {   0, "transport-resource-unavailable" },
  {   1, "unspecified" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseTransport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "unspecified" },
  {   6, "abstract-syntax-error-falsely-constructed-message" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "hardware-failure" },
  {   2, "om-intervention" },
  {   3, "not-enough-user-plane-processing-resources" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_rnsap_radioNetwork  , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseRadioNetwork },
  {   1, &hf_rnsap_transport     , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseTransport },
  {   2, &hf_rnsap_protocol      , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseProtocol },
  {   3, &hf_rnsap_misc          , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseMisc },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Cause, Cause_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_CellCapabilityContainer_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_CellCapabilityContainer_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_CellCapabilityContainer_TDD_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_CellCapabilityContainer_TDD768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_CCTrCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_100_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Cell_Capacity_Class_Value_sequence[] = {
  { &hf_rnsap_uplinkCellCapacityClassValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_100_ },
  { &hf_rnsap_downlinkCellCapacityClassValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_100_ },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Cell_Capacity_Class_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Cell_Capacity_Class_Value, Cell_Capacity_Class_Value_sequence);

  return offset;
}



static int
dissect_rnsap_CellIndividualOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -20, 20U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_CellParameterID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_CellPortionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_LAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, FALSE, NULL);

  return offset;
}


static const per_sequence_t T_lAI_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_lAC           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_LAC },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_lAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_lAI, T_lAI_sequence);

  return offset;
}



static int
dissect_rnsap_CI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, FALSE, NULL);

  return offset;
}


static const per_sequence_t CGI_sequence[] = {
  { &hf_rnsap_lAI           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_lAI },
  { &hf_rnsap_cI            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_CI },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CGI, CGI_sequence);

  return offset;
}


static const value_string rnsap_ChannelCodingType_vals[] = {
  {   0, "no-codingTDD" },
  {   1, "convolutional-coding" },
  {   2, "turbo-coding" },
  { 0, NULL }
};


static int
dissect_rnsap_ChannelCodingType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_ChipOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 38399U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_ClosedLoopMode1_SupportIndicator_vals[] = {
  {   0, "closedLoop-Mode1-Supported" },
  {   1, "closedLoop-Mode1-not-Supported" },
  { 0, NULL }
};


static int
dissect_rnsap_ClosedLoopMode1_SupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_Closedlooptimingadjustmentmode_vals[] = {
  {   0, "adj-1-slot" },
  {   1, "adj-2-slot" },
  { 0, NULL }
};


static int
dissect_rnsap_Closedlooptimingadjustmentmode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_CodingRate_vals[] = {
  {   0, "half" },
  {   1, "third" },
  { 0, NULL }
};


static int
dissect_rnsap_CodingRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_TUTRANGPSAccuracyClass_vals[] = {
  {   0, "accuracy-class-A" },
  {   1, "accuracy-class-B" },
  {   2, "accuracy-class-C" },
  { 0, NULL }
};


static int
dissect_rnsap_TUTRANGPSAccuracyClass(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_TUTRANGANSSAccuracyClass_vals[] = {
  {   0, "ganssAccuracy-class-A" },
  {   1, "ganssAccuracy-class-B" },
  {   2, "ganssAccuracy-class-C" },
  { 0, NULL }
};


static int
dissect_rnsap_TUTRANGANSSAccuracyClass(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_CommonMeasurementAccuracy_vals[] = {
  {   0, "tUTRANGPSMeasurementAccuracyClass" },
  {   1, "tUTRANGANSSMeasurementAccuracyClass" },
  { 0, NULL }
};

static const per_choice_t CommonMeasurementAccuracy_choice[] = {
  {   0, &hf_rnsap_tUTRANGPSMeasurementAccuracyClass, ASN1_EXTENSION_ROOT    , dissect_rnsap_TUTRANGPSAccuracyClass },
  {   1, &hf_rnsap_tUTRANGANSSMeasurementAccuracyClass, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_TUTRANGANSSAccuracyClass },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementAccuracy(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CommonMeasurementAccuracy, CommonMeasurementAccuracy_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_CommonMeasurementType_vals[] = {
  {   0, "uTRAN-GPS-timing-of-cell-frames-for-UE-Positioning" },
  {   1, "sFN-SFN-observerd-time-difference" },
  {   2, "load" },
  {   3, "transmitted-carrier-power" },
  {   4, "received-total-wide-band-power" },
  {   5, "uplink-timeslot-iscp" },
  {   6, "rT-load" },
  {   7, "nRT-load-Information" },
  {   8, "upPTSInterference" },
  {   9, "uTRAN-GANSS-timing-of-cell-frames-for-UE-Positioning" },
  { 0, NULL }
};


static int
dissect_rnsap_CommonMeasurementType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 4, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_4294967295(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}


static const per_sequence_t TUTRANGPS_sequence[] = {
  { &hf_rnsap_ms_part       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_16383 },
  { &hf_rnsap_ls_part       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_4294967295 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TUTRANGPS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TUTRANGPS, TUTRANGPS_sequence);

  return offset;
}



static int
dissect_rnsap_TUTRANGPSQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TUTRANGPSDriftRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -50, 50U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TUTRANGPSDriftRateQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 50U, NULL, FALSE);

  return offset;
}


static const per_sequence_t TUTRANGPSMeasurementValueInformation_sequence[] = {
  { &hf_rnsap_tUTRANGPS     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TUTRANGPS },
  { &hf_rnsap_tUTRANGPSQuality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TUTRANGPSQuality },
  { &hf_rnsap_tUTRANGPSDriftRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TUTRANGPSDriftRate },
  { &hf_rnsap_tUTRANGPSDriftRateQuality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TUTRANGPSDriftRateQuality },
  { &hf_rnsap_iEe_Extensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TUTRANGPSMeasurementValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TUTRANGPSMeasurementValueInformation, TUTRANGPSMeasurementValueInformation_sequence);

  return offset;
}



static int
dissect_rnsap_RNC_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const per_sequence_t UC_ID_sequence[] = {
  { &hf_rnsap_rNC_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RNC_ID },
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UC_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UC_ID, UC_ID_sequence);

  return offset;
}



static int
dissect_rnsap_SFNSFN_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 614399U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SFNSFN_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 40961U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SFNSFN_TDD768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 81923U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_SFNSFNValue_vals[] = {
  {   0, "sFNSFN-FDD" },
  {   1, "sFNSFN-TDD" },
  {   2, "sFNSFN-TDD768" },
  { 0, NULL }
};

static const per_choice_t SFNSFNValue_choice[] = {
  {   0, &hf_rnsap_sFNSFN_FDD    , ASN1_EXTENSION_ROOT    , dissect_rnsap_SFNSFN_FDD },
  {   1, &hf_rnsap_sFNSFN_TDD    , ASN1_EXTENSION_ROOT    , dissect_rnsap_SFNSFN_TDD },
  {   2, &hf_rnsap_sFNSFN_TDD768 , ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_SFNSFN_TDD768 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_SFNSFNValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_SFNSFNValue, SFNSFNValue_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_SFNSFNQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SFNSFNDriftRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SFNSFNDriftRateQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SFN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TimeSlot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SFNSFNTimeStamp_TDD_sequence[] = {
  { &hf_rnsap_sFN           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SFN },
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SFNSFNTimeStamp_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SFNSFNTimeStamp_TDD, SFNSFNTimeStamp_TDD_sequence);

  return offset;
}


static const value_string rnsap_SFNSFNTimeStampInformation_vals[] = {
  {   0, "sFNSFNTimeStamp-FDD" },
  {   1, "sFNSFNTimeStamp-TDD" },
  { 0, NULL }
};

static const per_choice_t SFNSFNTimeStampInformation_choice[] = {
  {   0, &hf_rnsap_sFNSFNTimeStamp_FDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_SFN },
  {   1, &hf_rnsap_sFNSFNTimeStamp_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_SFNSFNTimeStamp_TDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_SFNSFNTimeStampInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_SFNSFNTimeStampInformation, SFNSFNTimeStampInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item_sequence[] = {
  { &hf_rnsap_uC_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UC_ID },
  { &hf_rnsap_sFNSFNValue   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SFNSFNValue },
  { &hf_rnsap_sFNSFNQuality , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SFNSFNQuality },
  { &hf_rnsap_sFNSFNDriftRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SFNSFNDriftRate },
  { &hf_rnsap_sFNSFNDriftRateQuality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SFNSFNDriftRateQuality },
  { &hf_rnsap_sFNSFNTimeStampInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SFNSFNTimeStampInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item, T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item_sequence);

  return offset;
}


static const per_sequence_t T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_sequence_of[1] = {
  { &hf_rnsap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item },
};

static int
dissect_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation, T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_sequence_of,
                                                  1, maxNrOfMeasNCell);

  return offset;
}


static const per_sequence_t T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item_sequence[] = {
  { &hf_rnsap_uC_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UC_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item, T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item_sequence);

  return offset;
}


static const per_sequence_t T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_sequence_of[1] = {
  { &hf_rnsap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item },
};

static int
dissect_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation, T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_sequence_of,
                                                  0, maxNrOfMeasNCell_1);

  return offset;
}


static const per_sequence_t SFNSFNMeasurementValueInformation_sequence[] = {
  { &hf_rnsap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation },
  { &hf_rnsap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SFNSFNMeasurementValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SFNSFNMeasurementValueInformation, SFNSFNMeasurementValueInformation_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t LoadValue_sequence[] = {
  { &hf_rnsap_uplinkLoadValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_100 },
  { &hf_rnsap_downlinkLoadValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_LoadValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_LoadValue, LoadValue_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_621(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 621U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_UL_TimeslotISCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Extension_CommonMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t TUTRANGANSS_sequence[] = {
  { &hf_rnsap_mS            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_16383 },
  { &hf_rnsap_lS            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_4294967295 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TUTRANGANSS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TUTRANGANSS, TUTRANGANSS_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_M50_50(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -50, 50U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_50(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 50U, NULL, FALSE);

  return offset;
}


static const per_sequence_t TUTRANGANSSMeasurementValueInformation_sequence[] = {
  { &hf_rnsap_tUTRANGANSS   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TUTRANGANSS },
  { &hf_rnsap_tUTRANGANSSQuality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_255 },
  { &hf_rnsap_tUTRANGANSSDriftRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_M50_50 },
  { &hf_rnsap_tUTRANGANSSDriftRateQuality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_50 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TUTRANGANSSMeasurementValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TUTRANGANSSMeasurementValueInformation, TUTRANGANSSMeasurementValueInformation_sequence);

  return offset;
}


static const value_string rnsap_CommonMeasurementValue_vals[] = {
  {   0, "tUTRANGPSMeasurementValueInformation" },
  {   1, "sFNSFNMeasurementValueInformation" },
  {   2, "loadValue" },
  {   3, "transmittedCarrierPowerValue" },
  {   4, "receivedTotalWideBandPowerValue" },
  {   5, "uplinkTimeslotISCPValue" },
  {   6, "extension-CommonMeasurementValue" },
  {   7, "tUTRANGANSSMeasurementValueInformation" },
  { 0, NULL }
};

static const per_choice_t CommonMeasurementValue_choice[] = {
  {   0, &hf_rnsap_tUTRANGPSMeasurementValueInformation, ASN1_EXTENSION_ROOT    , dissect_rnsap_TUTRANGPSMeasurementValueInformation },
  {   1, &hf_rnsap_sFNSFNMeasurementValueInformation, ASN1_EXTENSION_ROOT    , dissect_rnsap_SFNSFNMeasurementValueInformation },
  {   2, &hf_rnsap_loadValue     , ASN1_EXTENSION_ROOT    , dissect_rnsap_LoadValue },
  {   3, &hf_rnsap_transmittedCarrierPowerValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_0_100 },
  {   4, &hf_rnsap_receivedTotalWideBandPowerValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_0_621 },
  {   5, &hf_rnsap_uplinkTimeslotISCPValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_UL_TimeslotISCP },
  {   6, &hf_rnsap_extension_CommonMeasurementValue, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_CommonMeasurementValue },
  {   7, &hf_rnsap_tUTRANGANSSMeasurementValueInformation, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_TUTRANGANSSMeasurementValueInformation },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CommonMeasurementValue, CommonMeasurementValue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CommonMeasurementAvailable_sequence[] = {
  { &hf_rnsap_commonMeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CommonMeasurementValue },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonMeasurementAvailable, CommonMeasurementAvailable_sequence);

  return offset;
}



static int
dissect_rnsap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_CommonMeasurementValueInformation_vals[] = {
  {   0, "measurementAvailable" },
  {   1, "measurementnotAvailable" },
  { 0, NULL }
};

static const per_choice_t CommonMeasurementValueInformation_choice[] = {
  {   0, &hf_rnsap_measurementAvailable, ASN1_NO_EXTENSIONS     , dissect_rnsap_CommonMeasurementAvailable },
  {   1, &hf_rnsap_measurementnotAvailable, ASN1_NO_EXTENSIONS     , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CommonMeasurementValueInformation, CommonMeasurementValueInformation_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_CongestionCause_vals[] = {
  {   0, "uTRAN-dynamic-resources" },
  {   1, "uTRAN-semistatic-resources" },
  { 0, NULL }
};


static int
dissect_rnsap_CongestionCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_CommonTransportChannelResourcesInitialisationNotRequired_vals[] = {
  {   0, "not-Required" },
  { 0, NULL }
};


static int
dissect_rnsap_CommonTransportChannelResourcesInitialisationNotRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_UE_DTX_DRX_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 159U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_Enabling_Delay_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  { 0, NULL }
};


static int
dissect_rnsap_Enabling_Delay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UE_DTX_Cycle1_2ms_vals[] = {
  {   0, "v1" },
  {   1, "v4" },
  {   2, "v5" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v16" },
  {   6, "v20" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DTX_Cycle1_2ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UE_DTX_Cycle2_2ms_vals[] = {
  {   0, "v4" },
  {   1, "v5" },
  {   2, "v8" },
  {   3, "v10" },
  {   4, "v16" },
  {   5, "v20" },
  {   6, "v32" },
  {   7, "v40" },
  {   8, "v64" },
  {   9, "v80" },
  {  10, "v128" },
  {  11, "v160" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DTX_Cycle2_2ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_MAC_DTX_Cycle_2ms_vals[] = {
  {   0, "v1" },
  {   1, "v4" },
  {   2, "v5" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v16" },
  {   6, "v20" },
  { 0, NULL }
};


static int
dissect_rnsap_MAC_DTX_Cycle_2ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DTX_Cycle_2ms_Items_sequence[] = {
  { &hf_rnsap_uE_DTX_Cycle1_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DTX_Cycle1_2ms },
  { &hf_rnsap_uE_DTX_Cycle2_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DTX_Cycle2_2ms },
  { &hf_rnsap_mAC_DTX_Cycle_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_DTX_Cycle_2ms },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DTX_Cycle_2ms_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DTX_Cycle_2ms_Items, DTX_Cycle_2ms_Items_sequence);

  return offset;
}


static const value_string rnsap_UE_DTX_Cycle1_10ms_vals[] = {
  {   0, "v1" },
  {   1, "v5" },
  {   2, "v10" },
  {   3, "v20" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DTX_Cycle1_10ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UE_DTX_Cycle2_10ms_vals[] = {
  {   0, "v5" },
  {   1, "v10" },
  {   2, "v20" },
  {   3, "v40" },
  {   4, "v80" },
  {   5, "v160" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DTX_Cycle2_10ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_MAC_DTX_Cycle_10ms_vals[] = {
  {   0, "v5" },
  {   1, "v10" },
  {   2, "v20" },
  { 0, NULL }
};


static int
dissect_rnsap_MAC_DTX_Cycle_10ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DTX_Cycle_10ms_Items_sequence[] = {
  { &hf_rnsap_uE_DTX_Cycle1_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DTX_Cycle1_10ms },
  { &hf_rnsap_uE_DTX_Cycle2_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DTX_Cycle2_10ms },
  { &hf_rnsap_mAC_DTX_Cycle_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_DTX_Cycle_10ms },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DTX_Cycle_10ms_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DTX_Cycle_10ms_Items, DTX_Cycle_10ms_Items_sequence);

  return offset;
}


static const value_string rnsap_E_DCH_TTI_Length_vals[] = {
  {   0, "two-ms" },
  {   1, "ten-ms" },
  { 0, NULL }
};

static const per_choice_t E_DCH_TTI_Length_choice[] = {
  {   0, &hf_rnsap_two_ms        , ASN1_EXTENSION_ROOT    , dissect_rnsap_DTX_Cycle_2ms_Items },
  {   1, &hf_rnsap_ten_ms        , ASN1_EXTENSION_ROOT    , dissect_rnsap_DTX_Cycle_10ms_Items },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_E_DCH_TTI_Length(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_E_DCH_TTI_Length, E_DCH_TTI_Length_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_Inactivity_Threshold_for_UE_DTX_Cycle2_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  {   7, "v128" },
  {   8, "v256" },
  { 0, NULL }
};


static int
dissect_rnsap_Inactivity_Threshold_for_UE_DTX_Cycle2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UE_DTX_Long_Preamble_vals[] = {
  {   0, "v2" },
  {   1, "v4" },
  {   2, "v15" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DTX_Long_Preamble(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UE_Inactivity_Threshold_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  {   7, "v128" },
  {   8, "v256" },
  {   9, "v512" },
  {  10, "infinity" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_Inactivity_Threshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_CQI_DTX_Timer_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  {   9, "v256" },
  {  10, "v512" },
  {  11, "infinity" },
  { 0, NULL }
};


static int
dissect_rnsap_CQI_DTX_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UE_DPCCH_burst1_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v5" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DPCCH_burst1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UE_DPCCH_burst2_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v5" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DPCCH_burst2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DTX_Information_sequence[] = {
  { &hf_rnsap_e_DCH_TTI_Length, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TTI_Length },
  { &hf_rnsap_inactivity_Threshold_for_UE_DTX_Cycle2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inactivity_Threshold_for_UE_DTX_Cycle2 },
  { &hf_rnsap_uE_DTX_Long_Preamble, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DTX_Long_Preamble },
  { &hf_rnsap_uE_Inactivity_Threshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_Inactivity_Threshold },
  { &hf_rnsap_cQI_DTX_Timer , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CQI_DTX_Timer },
  { &hf_rnsap_uE_DPCCH_burst1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DPCCH_burst1 },
  { &hf_rnsap_uE_DPCCH_burst2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DPCCH_burst2 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DTX_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DTX_Information, DTX_Information_sequence);

  return offset;
}


static const value_string rnsap_UE_DRX_Cycle_vals[] = {
  {   0, "v4" },
  {   1, "v5" },
  {   2, "v8" },
  {   3, "v10" },
  {   4, "v16" },
  {   5, "v20" },
  { 0, NULL }
};


static int
dissect_rnsap_UE_DRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_Inactivity_Threshold_for_UE_DRX_Cycle_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  {   9, "v256" },
  {  10, "v512" },
  { 0, NULL }
};


static int
dissect_rnsap_Inactivity_Threshold_for_UE_DRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_Inactivity_Threshold_for_UE_Grant_Monitoring_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  {   7, "v128" },
  {   8, "v256" },
  { 0, NULL }
};


static int
dissect_rnsap_Inactivity_Threshold_for_UE_Grant_Monitoring(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_UE_DRX_Grant_Monitoring(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t DRX_Information_sequence[] = {
  { &hf_rnsap_uE_DRX_Cycle  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DRX_Cycle },
  { &hf_rnsap_inactivity_Threshold_for_UE_DRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inactivity_Threshold_for_UE_DRX_Cycle },
  { &hf_rnsap_inactivity_Threshold_for_UE_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inactivity_Threshold_for_UE_Grant_Monitoring },
  { &hf_rnsap_uE_DRX_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DRX_Grant_Monitoring },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DRX_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DRX_Information, DRX_Information_sequence);

  return offset;
}


static const value_string rnsap_CPC_DPCCH_Slot_Format_vals[] = {
  {   0, "v1" },
  {   1, "v3" },
  {   2, "v4" },
  { 0, NULL }
};


static int
dissect_rnsap_CPC_DPCCH_Slot_Format(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Continuous_Packet_Connectivity_DTX_DRX_Information_sequence[] = {
  { &hf_rnsap_uE_DTX_DRX_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_DTX_DRX_Offset },
  { &hf_rnsap_enabling_Delay, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Enabling_Delay },
  { &hf_rnsap_dTX_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DTX_Information },
  { &hf_rnsap_dRX_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DRX_Information },
  { &hf_rnsap_cPC_DPCCH_Slot_Format, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CPC_DPCCH_Slot_Format },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information, Continuous_Packet_Connectivity_DTX_DRX_Information_sequence);

  return offset;
}


static const per_sequence_t DTX_Cycle_2ms_to_Modify_Items_sequence[] = {
  { &hf_rnsap_uE_DTX_Cycle1_2ms, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DTX_Cycle1_2ms },
  { &hf_rnsap_uE_DTX_Cycle2_2ms, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DTX_Cycle2_2ms },
  { &hf_rnsap_mAC_DTX_Cycle_2ms, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAC_DTX_Cycle_2ms },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DTX_Cycle_2ms_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DTX_Cycle_2ms_to_Modify_Items, DTX_Cycle_2ms_to_Modify_Items_sequence);

  return offset;
}


static const per_sequence_t DTX_Cycle_10ms_to_Modify_Items_sequence[] = {
  { &hf_rnsap_uE_DTX_Cycle1_10ms, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DTX_Cycle1_10ms },
  { &hf_rnsap_uE_DTX_Cycle2_10ms, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DTX_Cycle2_10ms },
  { &hf_rnsap_mAC_DTX_Cycle_10ms, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAC_DTX_Cycle_10ms },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DTX_Cycle_10ms_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DTX_Cycle_10ms_to_Modify_Items, DTX_Cycle_10ms_to_Modify_Items_sequence);

  return offset;
}


static const value_string rnsap_E_DCH_TTI_Length_to_Modify_vals[] = {
  {   0, "two-ms" },
  {   1, "ten-ms" },
  { 0, NULL }
};

static const per_choice_t E_DCH_TTI_Length_to_Modify_choice[] = {
  {   0, &hf_rnsap_two_ms_01     , ASN1_EXTENSION_ROOT    , dissect_rnsap_DTX_Cycle_2ms_to_Modify_Items },
  {   1, &hf_rnsap_ten_ms_01     , ASN1_EXTENSION_ROOT    , dissect_rnsap_DTX_Cycle_10ms_to_Modify_Items },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_E_DCH_TTI_Length_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_E_DCH_TTI_Length_to_Modify, E_DCH_TTI_Length_to_Modify_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DTX_Information_to_Modify_Items_sequence[] = {
  { &hf_rnsap_e_DCH_TTI_Length_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TTI_Length_to_Modify },
  { &hf_rnsap_inactivity_Threshold_for_UE_DTX_Cycle2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Inactivity_Threshold_for_UE_DTX_Cycle2 },
  { &hf_rnsap_uE_DTX_Long_Preamble, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DTX_Long_Preamble },
  { &hf_rnsap_uE_Inactivity_Threshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_Inactivity_Threshold },
  { &hf_rnsap_cQI_DTX_Timer , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_DTX_Timer },
  { &hf_rnsap_uE_DPCCH_burst1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DPCCH_burst1 },
  { &hf_rnsap_uE_DPCCH_burst2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DPCCH_burst2 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DTX_Information_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DTX_Information_to_Modify_Items, DTX_Information_to_Modify_Items_sequence);

  return offset;
}


static const value_string rnsap_DTX_Information_to_Modify_vals[] = {
  {   0, "modify" },
  {   1, "deactivate" },
  { 0, NULL }
};

static const per_choice_t DTX_Information_to_Modify_choice[] = {
  {   0, &hf_rnsap_modify_01     , ASN1_EXTENSION_ROOT    , dissect_rnsap_DTX_Information_to_Modify_Items },
  {   1, &hf_rnsap_deactivate_01 , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DTX_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DTX_Information_to_Modify, DTX_Information_to_Modify_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRX_Information_to_Modify_Items_sequence[] = {
  { &hf_rnsap_uE_DRX_Cycle  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DRX_Cycle },
  { &hf_rnsap_inactivity_Threshold_for_UE_DRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Inactivity_Threshold_for_UE_DRX_Cycle },
  { &hf_rnsap_inactivity_Threshold_for_UE_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Inactivity_Threshold_for_UE_Grant_Monitoring },
  { &hf_rnsap_uE_DRX_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DRX_Grant_Monitoring },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DRX_Information_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DRX_Information_to_Modify_Items, DRX_Information_to_Modify_Items_sequence);

  return offset;
}


static const value_string rnsap_DRX_Information_to_Modify_vals[] = {
  {   0, "modify" },
  {   1, "deactivate" },
  { 0, NULL }
};

static const per_choice_t DRX_Information_to_Modify_choice[] = {
  {   0, &hf_rnsap_modify        , ASN1_EXTENSION_ROOT    , dissect_rnsap_DRX_Information_to_Modify_Items },
  {   1, &hf_rnsap_deactivate_01 , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DRX_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DRX_Information_to_Modify, DRX_Information_to_Modify_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify_sequence[] = {
  { &hf_rnsap_uE_DTX_DRX_Offset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UE_DTX_DRX_Offset },
  { &hf_rnsap_enabling_Delay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Enabling_Delay },
  { &hf_rnsap_dTX_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DTX_Information_to_Modify },
  { &hf_rnsap_dRX_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DRX_Information_to_Modify },
  { &hf_rnsap_cPC_DPCCH_Slot_Format, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CPC_DPCCH_Slot_Format },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify, Continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify_sequence);

  return offset;
}



static int
dissect_rnsap_Transport_Block_Size_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfHS_DSCHTBSs, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_HSPDSCH_Second_Code_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t Continuous_Packet_Connectivity_HS_SCCH_Less_InformationItem_sequence[] = {
  { &hf_rnsap_transport_Block_Size_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Transport_Block_Size_Index },
  { &hf_rnsap_hSPDSCH_Second_Code_Support, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSPDSCH_Second_Code_Support },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_InformationItem, Continuous_Packet_Connectivity_HS_SCCH_Less_InformationItem_sequence);

  return offset;
}


static const per_sequence_t Continuous_Packet_Connectivity_HS_SCCH_Less_Information_sequence_of[1] = {
  { &hf_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_InformationItem },
};

static int
dissect_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information, Continuous_Packet_Connectivity_HS_SCCH_Less_Information_sequence_of,
                                                  1, maxNrOfHS_DSCHTBSs_HS_SCCHless);

  return offset;
}



static int
dissect_rnsap_HSPDSCH_First_Code_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxHS_PDSCHCodeNrComp_1, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_HSPDSCH_Second_Code_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxHS_PDSCHCodeNrComp_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response_sequence[] = {
  { &hf_rnsap_hSPDSCH_First_Code_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSPDSCH_First_Code_Index },
  { &hf_rnsap_hSPDSCH_Second_Code_Index, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSPDSCH_Second_Code_Index },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response, Continuous_Packet_Connectivity_HS_SCCH_Less_Information_Response_sequence);

  return offset;
}


static const value_string rnsap_CoverageIndicator_vals[] = {
  {   0, "overlap" },
  {   1, "covers" },
  {   2, "containedIn" },
  { 0, NULL }
};


static int
dissect_rnsap_CoverageIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CPC_Information_sequence[] = {
  { &hf_rnsap_continuous_Packet_Connectivity_DTX_DRX_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information },
  { &hf_rnsap_continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Continuous_Packet_Connectivity_DTX_DRX_Information_to_Modify },
  { &hf_rnsap_continuous_Packet_Connectivity_HS_SCCH_Less_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Continuous_Packet_Connectivity_HS_SCCH_Less_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CPC_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CPC_Information, CPC_Information_sequence);

  return offset;
}


static const value_string rnsap_CRC_Size_vals[] = {
  {   0, "v0" },
  {   1, "v8" },
  {   2, "v12" },
  {   3, "v16" },
  {   4, "v24" },
  { 0, NULL }
};


static int
dissect_rnsap_CRC_Size(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_RepetitionNumber0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_item_sequence[] = {
  { &hf_rnsap_iECriticality , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_iE_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_repetitionNumber, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionNumber0 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CriticalityDiagnostics_IE_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CriticalityDiagnostics_IE_List_item, CriticalityDiagnostics_IE_List_item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_rnsap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_CriticalityDiagnostics_IE_List_item },
};

static int
dissect_rnsap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxNrOfErrors);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_rnsap_procedureID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProcedureID },
  { &hf_rnsap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TriggeringMessage },
  { &hf_rnsap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Criticality },
  { &hf_rnsap_transactionID , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransactionID },
  { &hf_rnsap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CriticalityDiagnostics_IE_List },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}



static int
dissect_rnsap_RepetitionNumber1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MessageStructure_item_sequence[] = {
  { &hf_rnsap_iE_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_repetitionNumber_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionNumber1 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MessageStructure_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MessageStructure_item, MessageStructure_item_sequence);

  return offset;
}


static const per_sequence_t MessageStructure_sequence_of[1] = {
  { &hf_rnsap_MessageStructure_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MessageStructure_item },
};

static int
dissect_rnsap_MessageStructure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_MessageStructure, MessageStructure_sequence_of,
                                                  1, maxNrOfLevels);

  return offset;
}


static const per_sequence_t CN_CS_DomainIdentifier_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_lAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_LAC },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CN_CS_DomainIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CN_CS_DomainIdentifier, CN_CS_DomainIdentifier_sequence);

  return offset;
}



static int
dissect_rnsap_RAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, FALSE, NULL);

  return offset;
}


static const per_sequence_t CN_PS_DomainIdentifier_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_lAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_LAC },
  { &hf_rnsap_rAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RAC },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CN_PS_DomainIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CN_PS_DomainIdentifier, CN_PS_DomainIdentifier_sequence);

  return offset;
}


static const value_string rnsap_CNDomainType_vals[] = {
  {   0, "cs-domain" },
  {   1, "ps-domain" },
  {   2, "dont-care" },
  { 0, NULL }
};


static int
dissect_rnsap_CNDomainType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_CommonPhysicalChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_CQI_Feedback_Cycle_vals[] = {
  {   0, "v0" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v20" },
  {   6, "v40" },
  {   7, "v80" },
  {   8, "v160" },
  {   9, "v16" },
  {  10, "v32" },
  {  11, "v64" },
  { 0, NULL }
};


static int
dissect_rnsap_CQI_Feedback_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, TRUE, 3, NULL);

  return offset;
}



static int
dissect_rnsap_CQI_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_CQI_RepetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_C_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_CodeRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_CodeRate_short(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_DATA_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_PayloadCRC_PresenceIndicator_vals[] = {
  {   0, "crc-included" },
  {   1, "crc-not-included" },
  { 0, NULL }
};


static int
dissect_rnsap_PayloadCRC_PresenceIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UL_FP_Mode_vals[] = {
  {   0, "normal" },
  {   1, "silent" },
  { 0, NULL }
};


static int
dissect_rnsap_UL_FP_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_ToAWS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1279U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_ToAWE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2559U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_DCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TrCH_SrcStatisticsDescr_vals[] = {
  {   0, "speech" },
  {   1, "rRC" },
  {   2, "unknown" },
  { 0, NULL }
};


static int
dissect_rnsap_TrCH_SrcStatisticsDescr(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_NrOfTransportBlocks(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 512U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TransportBlockSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5000U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TransmissionTimeIntervalDynamic_vals[] = {
  {   0, "msec-10" },
  {   1, "msec-20" },
  {   2, "msec-40" },
  {   3, "msec-80" },
  { 0, NULL }
};


static int
dissect_rnsap_TransmissionTimeIntervalDynamic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TransmissionTimeIntervalInformation_item_sequence[] = {
  { &hf_rnsap_transmissionTimeInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionTimeIntervalDynamic },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransmissionTimeIntervalInformation_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransmissionTimeIntervalInformation_item, TransmissionTimeIntervalInformation_item_sequence);

  return offset;
}


static const per_sequence_t TransmissionTimeIntervalInformation_sequence_of[1] = {
  { &hf_rnsap_TransmissionTimeIntervalInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionTimeIntervalInformation_item },
};

static int
dissect_rnsap_TransmissionTimeIntervalInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TransmissionTimeIntervalInformation, TransmissionTimeIntervalInformation_sequence_of,
                                                  1, maxTTI_Count);

  return offset;
}


static const per_sequence_t TDD_TransportFormatSet_ModeDP_sequence[] = {
  { &hf_rnsap_transmissionTimeIntervalInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransmissionTimeIntervalInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_TransportFormatSet_ModeDP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_TransportFormatSet_ModeDP, TDD_TransportFormatSet_ModeDP_sequence);

  return offset;
}


static const value_string rnsap_TransportFormatSet_ModeDP_vals[] = {
  {   0, "tdd" },
  {   1, "notApplicable" },
  { 0, NULL }
};

static const per_choice_t TransportFormatSet_ModeDP_choice[] = {
  {   0, &hf_rnsap_tdd           , ASN1_EXTENSION_ROOT    , dissect_rnsap_TDD_TransportFormatSet_ModeDP },
  {   1, &hf_rnsap_notApplicable , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_ModeDP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransportFormatSet_ModeDP, TransportFormatSet_ModeDP_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TransportFormatSet_DynamicPartList_item_sequence[] = {
  { &hf_rnsap_nrOfTransportBlocks, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_NrOfTransportBlocks },
  { &hf_rnsap_transportBlockSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportBlockSize },
  { &hf_rnsap_mode          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_ModeDP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_DynamicPartList_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransportFormatSet_DynamicPartList_item, TransportFormatSet_DynamicPartList_item_sequence);

  return offset;
}


static const per_sequence_t TransportFormatSet_DynamicPartList_sequence_of[1] = {
  { &hf_rnsap_TransportFormatSet_DynamicPartList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_DynamicPartList_item },
};

static int
dissect_rnsap_TransportFormatSet_DynamicPartList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TransportFormatSet_DynamicPartList, TransportFormatSet_DynamicPartList_sequence_of,
                                                  1, maxNrOfTFs);

  return offset;
}


static const value_string rnsap_TransmissionTimeIntervalSemiStatic_vals[] = {
  {   0, "msec-10" },
  {   1, "msec-20" },
  {   2, "msec-40" },
  {   3, "msec-80" },
  {   4, "dynamic" },
  { 0, NULL }
};


static int
dissect_rnsap_TransmissionTimeIntervalSemiStatic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_RateMatchingAttribute(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxRateMatching, NULL, FALSE);

  return offset;
}


static const value_string rnsap_SecondInterleavingMode_vals[] = {
  {   0, "frame-related" },
  {   1, "timeslot-related" },
  { 0, NULL }
};


static int
dissect_rnsap_SecondInterleavingMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_TransportFormatSet_ModeSSP_vals[] = {
  {   0, "tdd" },
  {   1, "notApplicable" },
  { 0, NULL }
};

static const per_choice_t TransportFormatSet_ModeSSP_choice[] = {
  {   0, &hf_rnsap_tdd_01        , ASN1_EXTENSION_ROOT    , dissect_rnsap_SecondInterleavingMode },
  {   1, &hf_rnsap_notApplicable , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_ModeSSP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransportFormatSet_ModeSSP, TransportFormatSet_ModeSSP_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TransportFormatSet_Semi_staticPart_sequence[] = {
  { &hf_rnsap_transmissionTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionTimeIntervalSemiStatic },
  { &hf_rnsap_channelCoding , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ChannelCodingType },
  { &hf_rnsap_codingRate    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CodingRate },
  { &hf_rnsap_rateMatcingAttribute, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RateMatchingAttribute },
  { &hf_rnsap_cRC_Size      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CRC_Size },
  { &hf_rnsap_mode_01       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_ModeSSP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_Semi_staticPart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransportFormatSet_Semi_staticPart, TransportFormatSet_Semi_staticPart_sequence);

  return offset;
}


static const per_sequence_t TransportFormatSet_sequence[] = {
  { &hf_rnsap_dynamicParts  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_DynamicPartList },
  { &hf_rnsap_semi_staticPart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_Semi_staticPart },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransportFormatSet, TransportFormatSet_sequence);

  return offset;
}


static const value_string rnsap_FrameHandlingPriority_vals[] = {
  {   0, "lowest" },
  {  15, "highest" },
  { 0, NULL }
};


static int
dissect_rnsap_FrameHandlingPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_QE_Selector_vals[] = {
  {   0, "selected" },
  {   1, "non-selected" },
  { 0, NULL }
};


static int
dissect_rnsap_QE_Selector(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_DRACControl_vals[] = {
  {   0, "not-Used-requested" },
  {   1, "not-requested" },
  { 0, NULL }
};


static int
dissect_rnsap_DRACControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DCH_Specific_FDD_Item_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_trCH_SrcStatisticsDescr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_ul_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_ul_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_dl_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_qE_Selector   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_QE_Selector },
  { &hf_rnsap_dRACControl   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DRACControl },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_Specific_FDD_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_Specific_FDD_Item, DCH_Specific_FDD_Item_sequence);

  return offset;
}


static const per_sequence_t DCH_Specific_FDD_InformationList_sequence_of[1] = {
  { &hf_rnsap_DCH_Specific_FDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_FDD_Item },
};

static int
dissect_rnsap_DCH_Specific_FDD_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_Specific_FDD_InformationList, DCH_Specific_FDD_InformationList_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const per_sequence_t DCH_FDD_InformationItem_sequence[] = {
  { &hf_rnsap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PayloadCRC_PresenceIndicator },
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWE },
  { &hf_rnsap_dCH_SpecificInformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_FDD_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_FDD_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_FDD_InformationItem, DCH_FDD_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DCH_FDD_Information_sequence_of[1] = {
  { &hf_rnsap_DCH_FDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_FDD_InformationItem },
};

static int
dissect_rnsap_DCH_FDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_FDD_Information, DCH_FDD_Information_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const value_string rnsap_DCH_Indicator_For_E_DCH_HSDPA_Operation_vals[] = {
  {   0, "dch-not-present" },
  { 0, NULL }
};


static int
dissect_rnsap_DCH_Indicator_For_E_DCH_HSDPA_Operation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, TRUE, NULL);

  return offset;
}


static const per_sequence_t DCH_InformationResponseItem_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_InformationResponseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_InformationResponseItem, DCH_InformationResponseItem_sequence);

  return offset;
}


static const per_sequence_t DCH_InformationResponse_sequence_of[1] = {
  { &hf_rnsap_DCH_InformationResponse_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_InformationResponseItem },
};

static int
dissect_rnsap_DCH_InformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_InformationResponse, DCH_InformationResponse_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const per_sequence_t DCH_Specific_TDD_Item_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_ul_cCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_cCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_trCH_SrcStatisticsDescr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_ul_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_ul_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_dl_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_qE_Selector   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_QE_Selector },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_Specific_TDD_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_Specific_TDD_Item, DCH_Specific_TDD_Item_sequence);

  return offset;
}


static const per_sequence_t DCH_Specific_TDD_InformationList_sequence_of[1] = {
  { &hf_rnsap_DCH_Specific_TDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_TDD_Item },
};

static int
dissect_rnsap_DCH_Specific_TDD_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_Specific_TDD_InformationList, DCH_Specific_TDD_InformationList_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const per_sequence_t DCH_TDD_InformationItem_sequence[] = {
  { &hf_rnsap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PayloadCRC_PresenceIndicator },
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWE },
  { &hf_rnsap_dCH_SpecificInformationList_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_TDD_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_TDD_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_TDD_InformationItem, DCH_TDD_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DCH_TDD_Information_sequence_of[1] = {
  { &hf_rnsap_DCH_TDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_TDD_InformationItem },
};

static int
dissect_rnsap_DCH_TDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_TDD_Information, DCH_TDD_Information_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const value_string rnsap_DedicatedMeasurementType_vals[] = {
  {   0, "sir" },
  {   1, "sir-error" },
  {   2, "transmitted-code-power" },
  {   3, "rSCP" },
  {   4, "rx-timing-deviation" },
  {   5, "round-trip-time" },
  {   6, "rx-timing-deviation-LCR" },
  {   7, "angle-Of-Arrival-LCR" },
  {   8, "hs-sich-quality" },
  {   9, "rx-timing-deviation-768" },
  {  10, "rx-timing-deviation-ext" },
  { 0, NULL }
};


static int
dissect_rnsap_DedicatedMeasurementType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 5, NULL);

  return offset;
}



static int
dissect_rnsap_SIR_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SIR_Error_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 125U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Transmitted_Code_Power_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_RSCP_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Rx_Timing_Deviation_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8191U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Round_Trip_Time_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Extension_DedicatedMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_DedicatedMeasurementValue_vals[] = {
  {   0, "sIR-Value" },
  {   1, "sIR-ErrorValue" },
  {   2, "transmittedCodePowerValue" },
  {   3, "rSCP" },
  {   4, "rxTimingDeviationValue" },
  {   5, "roundTripTime" },
  {   6, "extension-DedicatedMeasurementValue" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementValue_choice[] = {
  {   0, &hf_rnsap_sIR_Value     , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Value },
  {   1, &hf_rnsap_sIR_ErrorValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Error_Value },
  {   2, &hf_rnsap_transmittedCodePowerValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_Transmitted_Code_Power_Value },
  {   3, &hf_rnsap_rSCP          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RSCP_Value },
  {   4, &hf_rnsap_rxTimingDeviationValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_Rx_Timing_Deviation_Value },
  {   5, &hf_rnsap_roundTripTime , ASN1_EXTENSION_ROOT    , dissect_rnsap_Round_Trip_Time_Value },
  {   6, &hf_rnsap_extension_DedicatedMeasurementValue, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_DedicatedMeasurementValue },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementValue, DedicatedMeasurementValue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DedicatedMeasurementAvailable_sequence[] = {
  { &hf_rnsap_dedicatedmeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValue },
  { &hf_rnsap_cFN           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CFN },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementAvailable, DedicatedMeasurementAvailable_sequence);

  return offset;
}



static int
dissect_rnsap_DedicatedMeasurementnotAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_DedicatedMeasurementValueInformation_vals[] = {
  {   0, "measurementAvailable" },
  {   1, "measurementnotAvailable" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementValueInformation_choice[] = {
  {   0, &hf_rnsap_measurementAvailable_01, ASN1_NO_EXTENSIONS     , dissect_rnsap_DedicatedMeasurementAvailable },
  {   1, &hf_rnsap_measurementnotAvailable_01, ASN1_NO_EXTENSIONS     , dissect_rnsap_DedicatedMeasurementnotAvailable },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementValueInformation, DedicatedMeasurementValueInformation_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_DelayedActivation_vals[] = {
  {   0, "cfn" },
  {   1, "separate-indication" },
  { 0, NULL }
};

static const per_choice_t DelayedActivation_choice[] = {
  {   0, &hf_rnsap_cfn           , ASN1_NO_EXTENSIONS     , dissect_rnsap_CFN },
  {   1, &hf_rnsap_separate_indication, ASN1_NO_EXTENSIONS     , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DelayedActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DelayedActivation, DelayedActivation_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_Execution_Type_vals[] = {
  {   0, "synchronised" },
  {   1, "unsynchronised" },
  { 0, NULL }
};

static const per_choice_t Execution_Type_choice[] = {
  {   0, &hf_rnsap_synchronised  , ASN1_NO_EXTENSIONS     , dissect_rnsap_CFN },
  {   1, &hf_rnsap_unsynchronised, ASN1_NO_EXTENSIONS     , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Execution_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Execution_Type, Execution_Type_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_DL_Power(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -350, 150U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_FirstRLS_Indicator_vals[] = {
  {   0, "first-RLS" },
  {   1, "not-first-RLS" },
  { 0, NULL }
};


static int
dissect_rnsap_FirstRLS_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_PropagationDelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Activate_Info_sequence[] = {
  { &hf_rnsap_activation_type, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Execution_Type },
  { &hf_rnsap_initial_dl_tx_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_firstRLS_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FirstRLS_Indicator },
  { &hf_rnsap_propagation_delay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PropagationDelay },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Activate_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Activate_Info, Activate_Info_sequence);

  return offset;
}


static const per_sequence_t Deactivate_Info_sequence[] = {
  { &hf_rnsap_deactivation_type, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Execution_Type },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Deactivate_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Deactivate_Info, Deactivate_Info_sequence);

  return offset;
}


static const value_string rnsap_DelayedActivationUpdate_vals[] = {
  {   0, "activate" },
  {   1, "deactivate" },
  { 0, NULL }
};

static const per_choice_t DelayedActivationUpdate_choice[] = {
  {   0, &hf_rnsap_activate      , ASN1_NO_EXTENSIONS     , dissect_rnsap_Activate_Info },
  {   1, &hf_rnsap_deactivate    , ASN1_NO_EXTENSIONS     , dissect_rnsap_Deactivate_Info },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DelayedActivationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DelayedActivationUpdate, DelayedActivationUpdate_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_DeltaSIR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 119U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_3_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_GANSS_StatusHealth_vals[] = {
  {   0, "udre-scale-1dot0" },
  {   1, "udre-scale-0dot75" },
  {   2, "udre-scale-0dot5" },
  {   3, "udre-scale-0dot3" },
  {   4, "udre-scale-0dot2" },
  {   5, "udre-scale-0dot1" },
  {   6, "no-data" },
  {   7, "invalid-data" },
  { 0, NULL }
};


static int
dissect_rnsap_GANSS_StatusHealth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL);

  return offset;
}


static const value_string rnsap_UDRE_vals[] = {
  {   0, "lessThan1" },
  {   1, "between1-and-4" },
  {   2, "between4-and-8" },
  {   3, "over8" },
  { 0, NULL }
};


static int
dissect_rnsap_UDRE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_M2047_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2047, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_M127_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_dGANSS_SignalInformation_item_sequence[] = {
  { &hf_rnsap_satId         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_63 },
  { &hf_rnsap_gANSS_iod     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_10 },
  { &hf_rnsap_udre          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UDRE },
  { &hf_rnsap_ganss_prc     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_M2047_2047 },
  { &hf_rnsap_ganss_rrc     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_M127_127 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_dGANSS_SignalInformation_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_dGANSS_SignalInformation_item, T_dGANSS_SignalInformation_item_sequence);

  return offset;
}


static const per_sequence_t T_dGANSS_SignalInformation_sequence_of[1] = {
  { &hf_rnsap_dGANSS_SignalInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_dGANSS_SignalInformation_item },
};

static int
dissect_rnsap_T_dGANSS_SignalInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_T_dGANSS_SignalInformation, T_dGANSS_SignalInformation_sequence_of,
                                                  1, maxGANSSSat);

  return offset;
}


static const per_sequence_t T_dGANSS_Information_item_sequence[] = {
  { &hf_rnsap_gANSS_SignalId, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_3_ },
  { &hf_rnsap_gANSS_StatusHealth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_StatusHealth },
  { &hf_rnsap_dGANSS_SignalInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_T_dGANSS_SignalInformation },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_dGANSS_Information_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_dGANSS_Information_item, T_dGANSS_Information_item_sequence);

  return offset;
}


static const per_sequence_t T_dGANSS_Information_sequence_of[1] = {
  { &hf_rnsap_dGANSS_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_dGANSS_Information_item },
};

static int
dissect_rnsap_T_dGANSS_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_T_dGANSS_Information, T_dGANSS_Information_sequence_of,
                                                  1, maxSgnType);

  return offset;
}


static const per_sequence_t DGANSSCorrections_sequence[] = {
  { &hf_rnsap_dGANSS_ReferenceTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_119 },
  { &hf_rnsap_dGANSS_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_dGANSS_Information },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DGANSSCorrections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DGANSSCorrections, DGANSSCorrections_sequence);

  return offset;
}


static const value_string rnsap_PRCDeviation_vals[] = {
  {   0, "prcd1" },
  {   1, "prcd2" },
  {   2, "prcd5" },
  {   3, "prcd10" },
  { 0, NULL }
};


static int
dissect_rnsap_PRCDeviation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DGANSSThreshold_sequence[] = {
  { &hf_rnsap_pRCDeviation  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PRCDeviation },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DGANSSThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DGANSSThreshold, DGANSSThreshold_sequence);

  return offset;
}



static int
dissect_rnsap_GPSTOW(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 604799U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_GPS_Status_Health_vals[] = {
  {   0, "udre-1-0" },
  {   1, "udre-0-75" },
  {   2, "udre-0-5" },
  {   3, "udre-0-3" },
  {   4, "udre-0-1" },
  {   5, "no-data" },
  {   6, "invalid-data" },
  { 0, NULL }
};


static int
dissect_rnsap_GPS_Status_Health(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_PRC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2047, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Range_Correction_Rate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_satellite_DGPSCorrections_Information_item_sequence[] = {
  { &hf_rnsap_sAT_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAT_ID },
  { &hf_rnsap_iode_dgps     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_uDRE          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UDRE },
  { &hf_rnsap_pRC           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PRC },
  { &hf_rnsap_range_Correction_Rate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Range_Correction_Rate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_satellite_DGPSCorrections_Information_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_satellite_DGPSCorrections_Information_item, T_satellite_DGPSCorrections_Information_item_sequence);

  return offset;
}


static const per_sequence_t T_satellite_DGPSCorrections_Information_sequence_of[1] = {
  { &hf_rnsap_satellite_DGPSCorrections_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_satellite_DGPSCorrections_Information_item },
};

static int
dissect_rnsap_T_satellite_DGPSCorrections_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_T_satellite_DGPSCorrections_Information, T_satellite_DGPSCorrections_Information_sequence_of,
                                                  1, maxNoSat);

  return offset;
}


static const per_sequence_t DGPSCorrections_sequence[] = {
  { &hf_rnsap_gPSTOW        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GPSTOW },
  { &hf_rnsap_gPS_Status_Health, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GPS_Status_Health },
  { &hf_rnsap_satellite_DGPSCorrections_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_satellite_DGPSCorrections_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DGPSCorrections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DGPSCorrections, DGPSCorrections_sequence);

  return offset;
}


static const per_sequence_t DGPSThreshold_sequence[] = {
  { &hf_rnsap_pRCDeviation  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PRCDeviation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DGPSThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DGPSThreshold, DGPSThreshold_sequence);

  return offset;
}


static const value_string rnsap_DiscardTimer_vals[] = {
  {   0, "v20" },
  {   1, "v40" },
  {   2, "v60" },
  {   3, "v80" },
  {   4, "v100" },
  {   5, "v120" },
  {   6, "v140" },
  {   7, "v160" },
  {   8, "v180" },
  {   9, "v200" },
  {  10, "v250" },
  {  11, "v300" },
  {  12, "v400" },
  {  13, "v500" },
  {  14, "v750" },
  {  15, "v1000" },
  {  16, "v1250" },
  {  17, "v1500" },
  {  18, "v1750" },
  {  19, "v2000" },
  {  20, "v2500" },
  {  21, "v3000" },
  {  22, "v3500" },
  {  23, "v4000" },
  {  24, "v4500" },
  {  25, "v5000" },
  {  26, "v7500" },
  { 0, NULL }
};


static int
dissect_rnsap_DiscardTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     27, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_DiversityControlField_vals[] = {
  {   0, "may" },
  {   1, "must" },
  {   2, "must-not" },
  { 0, NULL }
};


static int
dissect_rnsap_DiversityControlField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_DiversityMode_vals[] = {
  {   0, "none" },
  {   1, "sTTD" },
  {   2, "closedLoopMode1" },
  {   3, "not-used-closedLoopMode2" },
  { 0, NULL }
};


static int
dissect_rnsap_DiversityMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_DL_DPCH_SlotFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_DL_DPCH_TimingAdjustment_vals[] = {
  {   0, "timing-advance" },
  {   1, "timing-delay" },
  { 0, NULL }
};


static int
dissect_rnsap_DL_DPCH_TimingAdjustment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_PowerAdjustmentType_vals[] = {
  {   0, "none" },
  {   1, "common" },
  {   2, "individual" },
  { 0, NULL }
};


static int
dissect_rnsap_PowerAdjustmentType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_RL_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DL_ReferencePowerInformationItem_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dl_Reference_Power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_ReferencePowerInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_ReferencePowerInformationItem, DL_ReferencePowerInformationItem_sequence);

  return offset;
}


static const per_sequence_t DL_ReferencePowerInformationList_sequence_of[1] = {
  { &hf_rnsap_DL_ReferencePowerInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_ReferencePowerInformationItem },
};

static int
dissect_rnsap_DL_ReferencePowerInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_ReferencePowerInformationList, DL_ReferencePowerInformationList_sequence_of,
                                                  1, maxNrOfRLs);

  return offset;
}



static int
dissect_rnsap_MaxAdjustmentStep(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 10U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_ScaledAdjustmentRatio(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DL_PowerBalancing_Information_sequence[] = {
  { &hf_rnsap_powerAdjustmentType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PowerAdjustmentType },
  { &hf_rnsap_dLReferencePower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_dLReferencePowerList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_ReferencePowerInformationList },
  { &hf_rnsap_maxAdjustmentStep, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MaxAdjustmentStep },
  { &hf_rnsap_adjustmentPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AdjustmentPeriod },
  { &hf_rnsap_adjustmentRatio, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ScaledAdjustmentRatio },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_PowerBalancing_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_PowerBalancing_Information, DL_PowerBalancing_Information_sequence);

  return offset;
}


static const value_string rnsap_DL_PowerBalancing_ActivationIndicator_vals[] = {
  {   0, "dL-PowerBalancing-Activated" },
  { 0, NULL }
};


static int
dissect_rnsap_DL_PowerBalancing_ActivationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_DL_PowerBalancing_UpdatedIndicator_vals[] = {
  {   0, "dL-PowerBalancing-Updated" },
  { 0, NULL }
};


static int
dissect_rnsap_DL_PowerBalancing_UpdatedIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DL_ReferencePowerInformation_sequence[] = {
  { &hf_rnsap_common_DL_ReferencePowerInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_individual_DL_ReferencePowerInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_ReferencePowerInformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_ReferencePowerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_ReferencePowerInformation, DL_ReferencePowerInformation_sequence);

  return offset;
}



static int
dissect_rnsap_D_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_D_RNTI_ReleaseIndication_vals[] = {
  {   0, "release-D-RNTI" },
  {   1, "not-release-D-RNTI" },
  { 0, NULL }
};


static int
dissect_rnsap_D_RNTI_ReleaseIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_DL_ScramblingCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_DL_FrameType_vals[] = {
  {   0, "typeA" },
  {   1, "typeB" },
  { 0, NULL }
};


static int
dissect_rnsap_DL_FrameType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_MidambleConfigurationBurstType1And3_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  {   2, "v16" },
  { 0, NULL }
};


static int
dissect_rnsap_MidambleConfigurationBurstType1And3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_MidambleShiftLong(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_MidambleAllocationMode1_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode1_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_commonMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   2, &hf_rnsap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleAllocationMode1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleAllocationMode1, MidambleAllocationMode1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type1_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType1And3 },
  { &hf_rnsap_midambleAllocationMode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleAllocationMode1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Type1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Type1, Type1_sequence);

  return offset;
}


static const value_string rnsap_MidambleConfigurationBurstType2_vals[] = {
  {   0, "v3" },
  {   1, "v6" },
  { 0, NULL }
};


static int
dissect_rnsap_MidambleConfigurationBurstType2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_MidambleShiftShort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_MidambleAllocationMode2_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode2_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_commonMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   2, &hf_rnsap_ueSpecificMidamble_01, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftShort },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleAllocationMode2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleAllocationMode2, MidambleAllocationMode2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type2_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType2 },
  { &hf_rnsap_midambleAllocationMode_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleAllocationMode2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Type2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Type2, Type2_sequence);

  return offset;
}


static const value_string rnsap_MidambleAllocationMode3_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode3_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleAllocationMode3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleAllocationMode3, MidambleAllocationMode3_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type3_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType1And3 },
  { &hf_rnsap_midambleAllocationMode_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleAllocationMode3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Type3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Type3, Type3_sequence);

  return offset;
}


static const value_string rnsap_MidambleShiftAndBurstType_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  {   2, "type3" },
  { 0, NULL }
};

static const per_choice_t MidambleShiftAndBurstType_choice[] = {
  {   0, &hf_rnsap_type1         , ASN1_EXTENSION_ROOT    , dissect_rnsap_Type1 },
  {   1, &hf_rnsap_type2         , ASN1_EXTENSION_ROOT    , dissect_rnsap_Type2 },
  {   2, &hf_rnsap_type3         , ASN1_EXTENSION_ROOT    , dissect_rnsap_Type3 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleShiftAndBurstType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleShiftAndBurstType, MidambleShiftAndBurstType_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_TFCI_Presence_vals[] = {
  {   0, "present" },
  {   1, "not-present" },
  { 0, NULL }
};


static int
dissect_rnsap_TFCI_Presence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_DPCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 239U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TDD_ChannelisationCode_vals[] = {
  {   0, "chCode1div1" },
  {   1, "chCode2div1" },
  {   2, "chCode2div2" },
  {   3, "chCode4div1" },
  {   4, "chCode4div2" },
  {   5, "chCode4div3" },
  {   6, "chCode4div4" },
  {   7, "chCode8div1" },
  {   8, "chCode8div2" },
  {   9, "chCode8div3" },
  {  10, "chCode8div4" },
  {  11, "chCode8div5" },
  {  12, "chCode8div6" },
  {  13, "chCode8div7" },
  {  14, "chCode8div8" },
  {  15, "chCode16div1" },
  {  16, "chCode16div2" },
  {  17, "chCode16div3" },
  {  18, "chCode16div4" },
  {  19, "chCode16div5" },
  {  20, "chCode16div6" },
  {  21, "chCode16div7" },
  {  22, "chCode16div8" },
  {  23, "chCode16div9" },
  {  24, "chCode16div10" },
  {  25, "chCode16div11" },
  {  26, "chCode16div12" },
  {  27, "chCode16div13" },
  {  28, "chCode16div14" },
  {  29, "chCode16div15" },
  {  30, "chCode16div16" },
  { 0, NULL }
};


static int
dissect_rnsap_TDD_ChannelisationCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_DL_Code_InformationItem_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DL_Code_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DL_Code_InformationItem, TDD_DL_Code_InformationItem_sequence);

  return offset;
}


static const per_sequence_t TDD_DL_Code_Information_sequence_of[1] = {
  { &hf_rnsap_TDD_DL_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_InformationItem },
};

static int
dissect_rnsap_TDD_DL_Code_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DL_Code_Information, TDD_DL_Code_Information_sequence_of,
                                                  1, maxNrOfDPCHs);

  return offset;
}


static const per_sequence_t DL_Timeslot_InformationItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_dL_Code_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_Timeslot_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_Timeslot_InformationItem, DL_Timeslot_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DL_Timeslot_Information_sequence_of[1] = {
  { &hf_rnsap_DL_Timeslot_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_InformationItem },
};

static int
dissect_rnsap_DL_Timeslot_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_Timeslot_Information, DL_Timeslot_Information_sequence_of,
                                                  1, maxNrOfTS);

  return offset;
}



static int
dissect_rnsap_TimeSlotLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 6U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_MidambleAllocationMode_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "uESpecificMidamble" },
  { 0, NULL }
};


static int
dissect_rnsap_MidambleAllocationMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_MidambleConfigurationLCR_vals[] = {
  {   0, "v2" },
  {   1, "v4" },
  {   2, "v6" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v12" },
  {   6, "v14" },
  {   7, "v16" },
  { 0, NULL }
};


static int
dissect_rnsap_MidambleConfigurationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MidambleShiftLCR_sequence[] = {
  { &hf_rnsap_midambleAllocationMode_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleAllocationMode },
  { &hf_rnsap_midambleShift , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftLong },
  { &hf_rnsap_midambleConfigurationLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationLCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MidambleShiftLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MidambleShiftLCR, MidambleShiftLCR_sequence);

  return offset;
}


static const value_string rnsap_Modulation_vals[] = {
  {   0, "qPSK" },
  {   1, "eightPSK" },
  { 0, NULL }
};


static int
dissect_rnsap_Modulation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_ChannelisationCodeLCR_sequence[] = {
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_modulation    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Modulation },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_ChannelisationCodeLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_ChannelisationCodeLCR, TDD_ChannelisationCodeLCR_sequence);

  return offset;
}



static int
dissect_rnsap_QPSK_DL_DPCH_TimeSlotFormatTDD_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 24U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_EightPSK_DL_DPCH_TimeSlotFormatTDD_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 24U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR_vals[] = {
  {   0, "qPSK" },
  {   1, "eightPSK" },
  { 0, NULL }
};

static const per_choice_t TDD_DL_DPCH_TimeSlotFormat_LCR_choice[] = {
  {   0, &hf_rnsap_qPSK          , ASN1_EXTENSION_ROOT    , dissect_rnsap_QPSK_DL_DPCH_TimeSlotFormatTDD_LCR },
  {   1, &hf_rnsap_eightPSK      , ASN1_EXTENSION_ROOT    , dissect_rnsap_EightPSK_DL_DPCH_TimeSlotFormatTDD_LCR },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR, TDD_DL_DPCH_TimeSlotFormat_LCR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TDD_DL_Code_LCR_InformationItem_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tdd_ChannelisationCodeLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCodeLCR },
  { &hf_rnsap_tdd_DL_DPCH_TimeSlotFormat_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DL_Code_LCR_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DL_Code_LCR_InformationItem, TDD_DL_Code_LCR_InformationItem_sequence);

  return offset;
}


static const per_sequence_t TDD_DL_Code_LCR_Information_sequence_of[1] = {
  { &hf_rnsap_TDD_DL_Code_LCR_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_LCR_InformationItem },
};

static int
dissect_rnsap_TDD_DL_Code_LCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DL_Code_LCR_Information, TDD_DL_Code_LCR_Information_sequence_of,
                                                  1, maxNrOfDPCHsLCR);

  return offset;
}


static const per_sequence_t DL_TimeslotLCR_InformationItem_sequence[] = {
  { &hf_rnsap_timeSlotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_dL_Code_LCR_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_LCR_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_TimeslotLCR_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_TimeslotLCR_InformationItem, DL_TimeslotLCR_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DL_TimeslotLCR_Information_sequence_of[1] = {
  { &hf_rnsap_DL_TimeslotLCR_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_TimeslotLCR_InformationItem },
};

static int
dissect_rnsap_DL_TimeslotLCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_TimeslotLCR_Information, DL_TimeslotLCR_Information_sequence_of,
                                                  1, maxNrOfDLTsLCR);

  return offset;
}


static const value_string rnsap_MidambleAllocationMode7681_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode7681_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_commonMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   2, &hf_rnsap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleAllocationMode7681(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleAllocationMode7681, MidambleAllocationMode7681_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type7681_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType1And3 },
  { &hf_rnsap_midambleAllocationMode_04, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleAllocationMode7681 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Type7681(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Type7681, Type7681_sequence);

  return offset;
}


static const value_string rnsap_MidambleConfigurationBurstType2_768_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  { 0, NULL }
};


static int
dissect_rnsap_MidambleConfigurationBurstType2_768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_MidambleShiftShort768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_MidambleAllocationMode7682_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode7682_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_commonMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   2, &hf_rnsap_ueSpecificMidamble_02, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftShort768 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleAllocationMode7682(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleAllocationMode7682, MidambleAllocationMode7682_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type7682_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType2_768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType2_768 },
  { &hf_rnsap_midambleAllocationMode_05, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleAllocationMode7682 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Type7682(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Type7682, Type7682_sequence);

  return offset;
}


static const value_string rnsap_MidambleAllocationMode7683_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode7683_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleAllocationMode7683(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleAllocationMode7683, MidambleAllocationMode7683_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type7683_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType1And3 },
  { &hf_rnsap_midambleAllocationMode_06, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleAllocationMode7683 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Type7683(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Type7683, Type7683_sequence);

  return offset;
}


static const value_string rnsap_MidambleShiftAndBurstType768_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  {   2, "type3" },
  { 0, NULL }
};

static const per_choice_t MidambleShiftAndBurstType768_choice[] = {
  {   0, &hf_rnsap_type1_01      , ASN1_EXTENSION_ROOT    , dissect_rnsap_Type7681 },
  {   1, &hf_rnsap_type2_01      , ASN1_EXTENSION_ROOT    , dissect_rnsap_Type7682 },
  {   2, &hf_rnsap_type3_01      , ASN1_EXTENSION_ROOT    , dissect_rnsap_Type7683 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleShiftAndBurstType768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleShiftAndBurstType768, MidambleShiftAndBurstType768_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_TDD_ChannelisationCode768_vals[] = {
  {   0, "chCode1div1" },
  {   1, "chCode2div1" },
  {   2, "chCode2div2" },
  {   3, "chCode4div1" },
  {   4, "chCode4div2" },
  {   5, "chCode4div3" },
  {   6, "chCode4div4" },
  {   7, "chCode8div1" },
  {   8, "chCode8div2" },
  {   9, "chCode8div3" },
  {  10, "chCode8div4" },
  {  11, "chCode8div5" },
  {  12, "chCode8div6" },
  {  13, "chCode8div7" },
  {  14, "chCode8div8" },
  {  15, "chCode16div1" },
  {  16, "chCode16div2" },
  {  17, "chCode16div3" },
  {  18, "chCode16div4" },
  {  19, "chCode16div5" },
  {  20, "chCode16div6" },
  {  21, "chCode16div7" },
  {  22, "chCode16div8" },
  {  23, "chCode16div9" },
  {  24, "chCode16div10" },
  {  25, "chCode16div11" },
  {  26, "chCode16div12" },
  {  27, "chCode16div13" },
  {  28, "chCode16div14" },
  {  29, "chCode16div15" },
  {  30, "chCode16div16" },
  {  31, "chCode32div1" },
  {  32, "chCode32div2" },
  {  33, "chCode32div3" },
  {  34, "chCode32div4" },
  {  35, "chCode32div5" },
  {  36, "chCode32div6" },
  {  37, "chCode32div7" },
  {  38, "chCode32div8" },
  {  39, "chCode32div9" },
  {  40, "chCode32div10" },
  {  41, "chCode32div11" },
  {  42, "chCode32div12" },
  {  43, "chCode32div13" },
  {  44, "chCode32div14" },
  {  45, "chCode32div15" },
  {  46, "chCode32div16" },
  {  47, "chCode32div17" },
  {  48, "chCode32div18" },
  {  49, "chCode32div19" },
  {  50, "chCode32div20" },
  {  51, "chCode32div21" },
  {  52, "chCode32div22" },
  {  53, "chCode32div23" },
  {  54, "chCode32div24" },
  {  55, "chCode32div25" },
  {  56, "chCode32div26" },
  {  57, "chCode32div27" },
  {  58, "chCode32div28" },
  {  59, "chCode32div29" },
  {  60, "chCode32div30" },
  {  61, "chCode32div31" },
  {  62, "chCode32div32" },
  { 0, NULL }
};


static int
dissect_rnsap_TDD_ChannelisationCode768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     63, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_DL_Code_InformationItem768_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DL_Code_InformationItem768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DL_Code_InformationItem768, TDD_DL_Code_InformationItem768_sequence);

  return offset;
}


static const per_sequence_t TDD_DL_Code_Information768_sequence_of[1] = {
  { &hf_rnsap_TDD_DL_Code_Information768_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_InformationItem768 },
};

static int
dissect_rnsap_TDD_DL_Code_Information768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DL_Code_Information768, TDD_DL_Code_Information768_sequence_of,
                                                  1, maxNrOfDPCHs768);

  return offset;
}


static const per_sequence_t DL_Timeslot_InformationItem768_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_dL_Code_Information768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_Information768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_Timeslot_InformationItem768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_Timeslot_InformationItem768, DL_Timeslot_InformationItem768_sequence);

  return offset;
}


static const per_sequence_t DL_Timeslot_Information768_sequence_of[1] = {
  { &hf_rnsap_DL_Timeslot_Information768_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_InformationItem768 },
};

static int
dissect_rnsap_DL_Timeslot_Information768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_Timeslot_Information768, DL_Timeslot_Information768_sequence_of,
                                                  1, maxNrOfTS);

  return offset;
}



static int
dissect_rnsap_DL_TimeslotISCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 91U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DL_TimeSlot_ISCP_InfoItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_dL_TimeslotISCP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_TimeslotISCP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_TimeSlot_ISCP_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_TimeSlot_ISCP_InfoItem, DL_TimeSlot_ISCP_InfoItem_sequence);

  return offset;
}


static const per_sequence_t DL_TimeSlot_ISCP_Info_sequence_of[1] = {
  { &hf_rnsap_DL_TimeSlot_ISCP_Info_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_TimeSlot_ISCP_InfoItem },
};

static int
dissect_rnsap_DL_TimeSlot_ISCP_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_TimeSlot_ISCP_Info, DL_TimeSlot_ISCP_Info_sequence_of,
                                                  1, maxNrOfDLTs);

  return offset;
}


static const per_sequence_t DL_TimeSlot_ISCP_LCR_InfoItem_sequence[] = {
  { &hf_rnsap_timeSlotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_dL_TimeslotISCP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_TimeslotISCP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_TimeSlot_ISCP_LCR_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_TimeSlot_ISCP_LCR_InfoItem, DL_TimeSlot_ISCP_LCR_InfoItem_sequence);

  return offset;
}


static const per_sequence_t DL_TimeSlot_ISCP_LCR_Information_sequence_of[1] = {
  { &hf_rnsap_DL_TimeSlot_ISCP_LCR_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_TimeSlot_ISCP_LCR_InfoItem },
};

static int
dissect_rnsap_DL_TimeSlot_ISCP_LCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_TimeSlot_ISCP_LCR_Information, DL_TimeSlot_ISCP_LCR_Information_sequence_of,
                                                  1, maxNrOfDLTsLCR);

  return offset;
}


static const value_string rnsap_Downlink_Compressed_Mode_Method_vals[] = {
  {   0, "not-Used-puncturing" },
  {   1, "sFdiv2" },
  {   2, "higher-layer-scheduling" },
  { 0, NULL }
};


static int
dissect_rnsap_Downlink_Compressed_Mode_Method(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_DPC_Mode_vals[] = {
  {   0, "mode0" },
  {   1, "mode1" },
  { 0, NULL }
};


static int
dissect_rnsap_DPC_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_DPC_Mode_Change_SupportIndicator_vals[] = {
  {   0, "dPC-ModeChangeSupported" },
  { 0, NULL }
};


static int
dissect_rnsap_DPC_Mode_Change_SupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_DPCH_ID768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 479U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_DPCHConstantValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -10, 10U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_DRXCycleLengthCoefficient(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            3U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_DSCH_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_SchedulingPriorityIndicator_vals[] = {
  {   0, "lowest" },
  {  15, "highest" },
  { 0, NULL }
};


static int
dissect_rnsap_SchedulingPriorityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MAC_c_sh_SDU_Length(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 5000U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MAC_c_sh_SDU_LengthList_sequence_of[1] = {
  { &hf_rnsap_MAC_c_sh_SDU_LengthList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_c_sh_SDU_Length },
};

static int
dissect_rnsap_MAC_c_sh_SDU_LengthList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_MAC_c_sh_SDU_LengthList, MAC_c_sh_SDU_LengthList_sequence_of,
                                                  1, maxNrOfMACcshSDU_Length);

  return offset;
}


static const per_sequence_t DSCH_FlowControlItem_sequence[] = {
  { &hf_rnsap_dSCH_SchedulingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_mAC_c_sh_SDU_Lengths, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_c_sh_SDU_LengthList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCH_FlowControlItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCH_FlowControlItem, DSCH_FlowControlItem_sequence);

  return offset;
}


static const per_sequence_t DSCH_FlowControlInformation_sequence_of[1] = {
  { &hf_rnsap_DSCH_FlowControlInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_FlowControlItem },
};

static int
dissect_rnsap_DSCH_FlowControlInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_FlowControlInformation, DSCH_FlowControlInformation_sequence_of,
                                                  1, 16);

  return offset;
}



static int
dissect_rnsap_DSCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_DSCH_InitialWindowSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DSCH_TDD_InformationItem_sequence[] = {
  { &hf_rnsap_dSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ID },
  { &hf_rnsap_dl_ccTrCHID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_trChSourceStatisticsDescriptor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_bLER          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCH_TDD_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCH_TDD_InformationItem, DSCH_TDD_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DSCH_TDD_Information_sequence_of[1] = {
  { &hf_rnsap_DSCH_TDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_TDD_InformationItem },
};

static int
dissect_rnsap_DSCH_TDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_TDD_Information, DSCH_TDD_Information_sequence_of,
                                                  1, maxNoOfDSCHs);

  return offset;
}



static int
dissect_rnsap_DsField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_EDCH_DDI_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 62U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_FDD_DL_ChannelisationCodeNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_E_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_ERGCH_SignatureSequence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSigSeqERGHICH_1, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_EHICH_SignatureSequence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSigSeqERGHICH_1, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_E_Serving_Grant_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 38U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_E_Primary_Secondary_Grant_Selector_vals[] = {
  {   0, "primary" },
  {   1, "secondary" },
  { 0, NULL }
};


static int
dissect_rnsap_E_Primary_Secondary_Grant_Selector(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_E_RGCH_Release_Indicator_vals[] = {
  {   0, "e-RGCHreleased" },
  { 0, NULL }
};


static int
dissect_rnsap_E_RGCH_Release_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EDCH_FDD_DL_ControlChannelInformation_sequence[] = {
  { &hf_rnsap_eAGCH_ERGCH_EHICH_FDD_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_ScramblingCode },
  { &hf_rnsap_eAGCH_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FDD_DL_ChannelisationCodeNumber },
  { &hf_rnsap_primary_e_RNTI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RNTI },
  { &hf_rnsap_secondary_e_RNTI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RNTI },
  { &hf_rnsap_eRGCH_EHICH_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_ChannelisationCodeNumber },
  { &hf_rnsap_eRGCH_SignatureSequence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ERGCH_SignatureSequence },
  { &hf_rnsap_eHICH_SignatureSequence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_EHICH_SignatureSequence },
  { &hf_rnsap_serving_Grant_Value, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_Serving_Grant_Value },
  { &hf_rnsap_primary_Secondary_Grant_Selector, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_Primary_Secondary_Grant_Selector },
  { &hf_rnsap_e_RGCH_Release_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RGCH_Release_Indicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_FDD_DL_ControlChannelInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_FDD_DL_ControlChannelInformation, EDCH_FDD_DL_ControlChannelInformation_sequence);

  return offset;
}


static const value_string rnsap_E_RGCH_E_HICH_ChannelisationCodeValidityIndicator_vals[] = {
  {   0, "e-RGCH-E-HICH-Channelisation-Code-response-not-valid" },
  { 0, NULL }
};


static int
dissect_rnsap_E_RGCH_E_HICH_ChannelisationCodeValidityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_EDCH_MACdFlow_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCHMACdFlows_1, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_GenericTrafficCategory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL);

  return offset;
}


static const value_string rnsap_TnlQos_vals[] = {
  {   0, "dsField" },
  {   1, "genericTrafficCategory" },
  { 0, NULL }
};

static const per_choice_t TnlQos_choice[] = {
  {   0, &hf_rnsap_dsField       , ASN1_EXTENSION_ROOT    , dissect_rnsap_DsField },
  {   1, &hf_rnsap_genericTrafficCategory, ASN1_EXTENSION_ROOT    , dissect_rnsap_GenericTrafficCategory },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TnlQos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TnlQos, TnlQos_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_MaxNr_Retransmissions_EDCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TrafficClass_vals[] = {
  {   0, "conversational" },
  {   1, "streaming" },
  {   2, "interactive" },
  {   3, "background" },
  { 0, NULL }
};


static int
dissect_rnsap_TrafficClass(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_E_DCH_HARQ_PO_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCH_HARQ_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_E_DCH_MACdFlow_Multiplexing_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     maxNrOfEDCHMACdFlows, maxNrOfEDCHMACdFlows, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_Max_Bits_MACe_PDU_non_scheduled(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfBits_MACe_PDU_non_scheduled, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     maxNrOfEDCHHARQProcesses2msEDCH, maxNrOfEDCHHARQProcesses2msEDCH, FALSE, NULL);

  return offset;
}


static const per_sequence_t E_DCH_Non_Scheduled_Transmission_Grant_Items_sequence[] = {
  { &hf_rnsap_maxBits_MACe_PDU_non_scheduled, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Max_Bits_MACe_PDU_non_scheduled },
  { &hf_rnsap_hARQ_Process_Allocation_NonSched_2ms, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Non_Scheduled_Transmission_Grant_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Non_Scheduled_Transmission_Grant_Items, E_DCH_Non_Scheduled_Transmission_Grant_Items_sequence);

  return offset;
}


static const value_string rnsap_E_DCH_Grant_Type_Information_vals[] = {
  {   0, "e-DCH-Non-Scheduled-Transmission-Grant" },
  {   1, "e-DCH-Scheduled-Transmission-Grant" },
  { 0, NULL }
};

static const per_choice_t E_DCH_Grant_Type_Information_choice[] = {
  {   0, &hf_rnsap_e_DCH_Non_Scheduled_Transmission_Grant, ASN1_EXTENSION_ROOT    , dissect_rnsap_E_DCH_Non_Scheduled_Transmission_Grant_Items },
  {   1, &hf_rnsap_e_DCH_Scheduled_Transmission_Grant, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Grant_Type_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_E_DCH_Grant_Type_Information, E_DCH_Grant_Type_Information_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_LogicalChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_SchedulingInformation_vals[] = {
  {   0, "included" },
  {   1, "not-included" },
  { 0, NULL }
};


static int
dissect_rnsap_SchedulingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_MACes_Guaranteed_Bitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_MACdPDU_Size(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 5000U, NULL, TRUE);

  return offset;
}


static const per_sequence_t E_DCH_MACdPDU_SizeListItem_sequence[] = {
  { &hf_rnsap_mACdPDU_Size  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_MACdPDU_SizeListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_MACdPDU_SizeListItem, E_DCH_MACdPDU_SizeListItem_sequence);

  return offset;
}


static const per_sequence_t E_DCH_MACdPDU_SizeList_sequence_of[1] = {
  { &hf_rnsap_E_DCH_MACdPDU_SizeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdPDU_SizeListItem },
};

static int
dissect_rnsap_E_DCH_MACdPDU_SizeList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_MACdPDU_SizeList, E_DCH_MACdPDU_SizeList_sequence_of,
                                                  1, maxNrOfMACdPDUSize);

  return offset;
}


static const per_sequence_t E_DCH_LogicalChannelInformationItem_sequence[] = {
  { &hf_rnsap_logicalChannelId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_LogicalChannelID },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_schedulingInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingInformation },
  { &hf_rnsap_mACes_GuaranteedBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MACes_Guaranteed_Bitrate },
  { &hf_rnsap_eDCH_DDI_Value, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_DDI_Value },
  { &hf_rnsap_mACd_PDU_Size_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdPDU_SizeList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_LogicalChannelInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_LogicalChannelInformationItem, E_DCH_LogicalChannelInformationItem_sequence);

  return offset;
}


static const per_sequence_t E_DCH_LogicalChannelInformation_sequence_of[1] = {
  { &hf_rnsap_E_DCH_LogicalChannelInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_LogicalChannelInformationItem },
};

static int
dissect_rnsap_E_DCH_LogicalChannelInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_LogicalChannelInformation, E_DCH_LogicalChannelInformation_sequence_of,
                                                  1, maxNoOfLogicalChannels);

  return offset;
}


static const per_sequence_t EDCH_MACdFlow_Specific_InfoItem_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_tnlQoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TnlQos },
  { &hf_rnsap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PayloadCRC_PresenceIndicator },
  { &hf_rnsap_maxNr_Retransmissions_EDCH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaxNr_Retransmissions_EDCH },
  { &hf_rnsap_trafficClass  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrafficClass },
  { &hf_rnsap_eDCH_HARQ_PO_FDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_HARQ_PO_FDD },
  { &hf_rnsap_eDCH_MACdFlow_Multiplexing_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlow_Multiplexing_List },
  { &hf_rnsap_eDCH_Grant_Type_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Grant_Type_Information },
  { &hf_rnsap_bundlingModeIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BundlingModeIndicator },
  { &hf_rnsap_eDCHLogicalChannelInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_LogicalChannelInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_MACdFlow_Specific_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_MACdFlow_Specific_InfoItem, EDCH_MACdFlow_Specific_InfoItem_sequence);

  return offset;
}


static const per_sequence_t EDCH_MACdFlow_Specific_InfoList_sequence_of[1] = {
  { &hf_rnsap_EDCH_MACdFlow_Specific_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_Specific_InfoItem },
};

static int
dissect_rnsap_EDCH_MACdFlow_Specific_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_EDCH_MACdFlow_Specific_InfoList, EDCH_MACdFlow_Specific_InfoList_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const per_sequence_t EDCH_MACdFlows_Information_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_Specific_Information_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_Specific_InfoList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_MACdFlows_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_MACdFlows_Information, EDCH_MACdFlows_Information_sequence);

  return offset;
}



static int
dissect_rnsap_E_DCH_Maximum_Bitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5742U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_E_DCH_Processing_Overload_Level(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_E_DCH_Reference_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCH_HARQ_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}


static const per_sequence_t EDCH_FDD_Information_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlows_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlows_Information },
  { &hf_rnsap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_rnsap_e_DCH_Maximum_Bitrate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Maximum_Bitrate },
  { &hf_rnsap_e_DCH_Processing_Overload_Level, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Processing_Overload_Level },
  { &hf_rnsap_e_DCH_Reference_Power_Offset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Reference_Power_Offset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_FDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_FDD_Information, EDCH_FDD_Information_sequence);

  return offset;
}


static const per_sequence_t EDCH_MACdFlow_Specific_InformationResponseItem_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_hARQ_Process_Allocation_NonSched_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_MACdFlow_Specific_InformationResponseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_MACdFlow_Specific_InformationResponseItem, EDCH_MACdFlow_Specific_InformationResponseItem_sequence);

  return offset;
}


static const per_sequence_t EDCH_MACdFlow_Specific_InformationResponse_sequence_of[1] = {
  { &hf_rnsap_EDCH_MACdFlow_Specific_InformationResponse_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_Specific_InformationResponseItem },
};

static int
dissect_rnsap_EDCH_MACdFlow_Specific_InformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_EDCH_MACdFlow_Specific_InformationResponse, EDCH_MACdFlow_Specific_InformationResponse_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const per_sequence_t EDCH_FDD_InformationResponse_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_Specific_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_Specific_InformationResponse },
  { &hf_rnsap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_FDD_InformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_FDD_InformationResponse, EDCH_FDD_InformationResponse_sequence);

  return offset;
}


static const value_string rnsap_TransportBearerRequestIndicator_vals[] = {
  {   0, "bearer-requested" },
  {   1, "bearer-not-requested" },
  { 0, NULL }
};


static int
dissect_rnsap_TransportBearerRequestIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t E_DCH_MACdPDU_SizeToModifyList_sequence_of[1] = {
  { &hf_rnsap_E_DCH_MACdPDU_SizeToModifyList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdPDU_SizeListItem },
};

static int
dissect_rnsap_E_DCH_MACdPDU_SizeToModifyList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_MACdPDU_SizeToModifyList, E_DCH_MACdPDU_SizeToModifyList_sequence_of,
                                                  0, maxNrOfMACdPDUSize);

  return offset;
}


static const per_sequence_t E_DCH_LogicalChannelToModifyItem_sequence[] = {
  { &hf_rnsap_logicalChannelId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_LogicalChannelID },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_schedulingInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SchedulingInformation },
  { &hf_rnsap_mACes_GuaranteedBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MACes_Guaranteed_Bitrate },
  { &hf_rnsap_eDCH_DDI_Value, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_EDCH_DDI_Value },
  { &hf_rnsap_mACd_PDU_Size_List_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdPDU_SizeToModifyList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_LogicalChannelToModifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_LogicalChannelToModifyItem, E_DCH_LogicalChannelToModifyItem_sequence);

  return offset;
}


static const per_sequence_t E_DCH_LogicalChannelToModify_sequence_of[1] = {
  { &hf_rnsap_E_DCH_LogicalChannelToModify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_LogicalChannelToModifyItem },
};

static int
dissect_rnsap_E_DCH_LogicalChannelToModify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_LogicalChannelToModify, E_DCH_LogicalChannelToModify_sequence_of,
                                                  1, maxNoOfLogicalChannels);

  return offset;
}


static const per_sequence_t E_DCH_LogicalChannelToDeleteItem_sequence[] = {
  { &hf_rnsap_logicalChannelId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_LogicalChannelID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_LogicalChannelToDeleteItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_LogicalChannelToDeleteItem, E_DCH_LogicalChannelToDeleteItem_sequence);

  return offset;
}


static const per_sequence_t E_DCH_LogicalChannelToDelete_sequence_of[1] = {
  { &hf_rnsap_E_DCH_LogicalChannelToDelete_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_LogicalChannelToDeleteItem },
};

static int
dissect_rnsap_E_DCH_LogicalChannelToDelete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_LogicalChannelToDelete, E_DCH_LogicalChannelToDelete_sequence_of,
                                                  1, maxNoOfLogicalChannels);

  return offset;
}


static const per_sequence_t EDCH_MACdFlow_Specific_InfoToModifyItem_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_tnlQoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TnlQos },
  { &hf_rnsap_maxNr_Retransmissions_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MaxNr_Retransmissions_EDCH },
  { &hf_rnsap_trafficClass  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TrafficClass },
  { &hf_rnsap_eDCH_HARQ_PO_FDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_HARQ_PO_FDD },
  { &hf_rnsap_eDCH_MACdFlow_Multiplexing_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlow_Multiplexing_List },
  { &hf_rnsap_eDCH_Grant_Type_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Grant_Type_Information },
  { &hf_rnsap_bundlingModeIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BundlingModeIndicator },
  { &hf_rnsap_eDCH_LogicalChannelToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_LogicalChannelInformation },
  { &hf_rnsap_eDCH_LogicalChannelToModify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_LogicalChannelToModify },
  { &hf_rnsap_eDCH_LogicalChannelToDelete, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_LogicalChannelToDelete },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_MACdFlow_Specific_InfoToModifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_MACdFlow_Specific_InfoToModifyItem, EDCH_MACdFlow_Specific_InfoToModifyItem_sequence);

  return offset;
}


static const per_sequence_t EDCH_MACdFlow_Specific_InfoToModifyList_sequence_of[1] = {
  { &hf_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_Specific_InfoToModifyItem },
};

static int
dissect_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList, EDCH_MACdFlow_Specific_InfoToModifyList_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const value_string rnsap_MACeReset_Indicator_vals[] = {
  {   0, "mACeReset" },
  { 0, NULL }
};


static int
dissect_rnsap_MACeReset_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EDCH_FDD_Information_To_Modify_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_Specific_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList },
  { &hf_rnsap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_rnsap_e_DCH_Maximum_Bitrate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Maximum_Bitrate },
  { &hf_rnsap_e_DCH_Processing_Overload_Level, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Processing_Overload_Level },
  { &hf_rnsap_e_DCH_Reference_Power_Offset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Reference_Power_Offset },
  { &hf_rnsap_mACeReset_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MACeReset_Indicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_FDD_Information_To_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_FDD_Information_To_Modify, EDCH_FDD_Information_To_Modify_sequence);

  return offset;
}


static const per_sequence_t E_DCH_MACdFlow_Specific_UpdateInformation_Item_sequence[] = {
  { &hf_rnsap_e_DCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_hARQ_Process_Allocation_NonSched_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation_Item, E_DCH_MACdFlow_Specific_UpdateInformation_Item_sequence);

  return offset;
}


static const per_sequence_t E_DCH_MACdFlow_Specific_UpdateInformation_sequence_of[1] = {
  { &hf_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation_Item },
};

static int
dissect_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation, E_DCH_MACdFlow_Specific_UpdateInformation_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const per_sequence_t E_DCH_FDD_Update_Information_sequence[] = {
  { &hf_rnsap_e_DCH_MACdFlow_Specific_UpdateInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlow_Specific_UpdateInformation },
  { &hf_rnsap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_FDD_Update_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_FDD_Update_Information, E_DCH_FDD_Update_Information_sequence);

  return offset;
}



static int
dissect_rnsap_E_DCH_PowerOffset_for_SchedulingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCH_HARQ_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}


static const per_sequence_t EDCH_MACdFlows_To_Delete_Item_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_MACdFlows_To_Delete_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_MACdFlows_To_Delete_Item, EDCH_MACdFlows_To_Delete_Item_sequence);

  return offset;
}


static const per_sequence_t EDCH_MACdFlows_To_Delete_sequence_of[1] = {
  { &hf_rnsap_EDCH_MACdFlows_To_Delete_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlows_To_Delete_Item },
};

static int
dissect_rnsap_EDCH_MACdFlows_To_Delete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_EDCH_MACdFlows_To_Delete, EDCH_MACdFlows_To_Delete_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const value_string rnsap_EDCH_RL_Indication_vals[] = {
  {   0, "eDCH" },
  {   1, "non-EDCH" },
  { 0, NULL }
};


static int
dissect_rnsap_EDCH_RL_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_E_DCH_TFCI_Table_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, TRUE);

  return offset;
}


static const per_sequence_t E_DCH_RL_InformationList_Rsp_Item_sequence[] = {
  { &hf_rnsap_e_DCH_reconfigured_RL_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_e_DCH_FDD_DL_Control_Channel_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_FDD_DL_ControlChannelInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_RL_InformationList_Rsp_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_RL_InformationList_Rsp_Item, E_DCH_RL_InformationList_Rsp_Item_sequence);

  return offset;
}


static const per_sequence_t E_DCH_RL_InformationList_Rsp_sequence_of[1] = {
  { &hf_rnsap_E_DCH_RL_InformationList_Rsp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_RL_InformationList_Rsp_Item },
};

static int
dissect_rnsap_E_DCH_RL_InformationList_Rsp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_RL_InformationList_Rsp, E_DCH_RL_InformationList_Rsp_sequence_of,
                                                  0, maxNrOfRLs);

  return offset;
}


static const per_sequence_t E_DCH_serving_cell_change_successful_sequence[] = {
  { &hf_rnsap_e_DCH_RL_InformationList_Rsp, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_RL_InformationList_Rsp },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_serving_cell_change_successful(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_serving_cell_change_successful, E_DCH_serving_cell_change_successful_sequence);

  return offset;
}


static const per_sequence_t E_DCH_serving_cell_change_unsuccessful_sequence[] = {
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_serving_cell_change_unsuccessful(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_serving_cell_change_unsuccessful, E_DCH_serving_cell_change_unsuccessful_sequence);

  return offset;
}


static const value_string rnsap_E_DCH_serving_cell_change_choice_vals[] = {
  {   0, "e-DCH-serving-cell-change-successful" },
  {   1, "e-DCH-serving-cell-change-unsuccessful" },
  { 0, NULL }
};

static const per_choice_t E_DCH_serving_cell_change_choice_choice[] = {
  {   0, &hf_rnsap_e_DCH_serving_cell_change_successful, ASN1_EXTENSION_ROOT    , dissect_rnsap_E_DCH_serving_cell_change_successful },
  {   1, &hf_rnsap_e_DCH_serving_cell_change_unsuccessful, ASN1_EXTENSION_ROOT    , dissect_rnsap_E_DCH_serving_cell_change_unsuccessful },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_E_DCH_serving_cell_change_choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_E_DCH_serving_cell_change_choice, E_DCH_serving_cell_change_choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_DCH_Serving_cell_change_informationResponse_sequence[] = {
  { &hf_rnsap_e_DCH_serving_cell_outcome_choice, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_serving_cell_change_choice },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Serving_cell_change_informationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Serving_cell_change_informationResponse, E_DCH_Serving_cell_change_informationResponse_sequence);

  return offset;
}


static const value_string rnsap_Max_Set_E_DPDCHs_vals[] = {
  {   0, "vN256" },
  {   1, "vN128" },
  {   2, "vN64" },
  {   3, "vN32" },
  {   4, "vN16" },
  {   5, "vN8" },
  {   6, "vN4" },
  {   7, "v2xN4" },
  {   8, "v2xN2" },
  {   9, "v2xN2plus2xN4" },
  {  10, "v2xM2plus2xM4" },
  { 0, NULL }
};


static int
dissect_rnsap_Max_Set_E_DPDCHs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_rnsap_PunctureLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_E_TFCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Reference_E_TFCI_PO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfRefETFCI_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}


static const per_sequence_t Reference_E_TFCI_Information_Item_sequence[] = {
  { &hf_rnsap_reference_E_TFCI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_TFCI },
  { &hf_rnsap_reference_E_TFCI_PO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Reference_E_TFCI_PO },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Reference_E_TFCI_Information_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Reference_E_TFCI_Information_Item, Reference_E_TFCI_Information_Item_sequence);

  return offset;
}


static const per_sequence_t Reference_E_TFCI_Information_sequence_of[1] = {
  { &hf_rnsap_Reference_E_TFCI_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Reference_E_TFCI_Information_Item },
};

static int
dissect_rnsap_Reference_E_TFCI_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Reference_E_TFCI_Information, Reference_E_TFCI_Information_sequence_of,
                                                  1, maxNrOfRefETFCIs);

  return offset;
}


static const per_sequence_t E_TFCS_Information_sequence[] = {
  { &hf_rnsap_e_DCH_TFCI_Table_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TFCI_Table_Index },
  { &hf_rnsap_e_DCH_Min_Set_E_TFCI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_TFCI },
  { &hf_rnsap_reference_E_TFCI_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Reference_E_TFCI_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_TFCS_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_TFCS_Information, E_TFCS_Information_sequence);

  return offset;
}


static const value_string rnsap_E_TTI_vals[] = {
  {   0, "tti10" },
  {   1, "tti2" },
  { 0, NULL }
};


static int
dissect_rnsap_E_TTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_E_DPCCH_PO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDPCCH_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_E_RGCH_2_IndexStepThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_E_RGCH_3_IndexStepThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_HARQ_Info_for_E_DCH_vals[] = {
  {   0, "rv0" },
  {   1, "rvtable" },
  { 0, NULL }
};


static int
dissect_rnsap_HARQ_Info_for_E_DCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_HSDSCH_Configured_Indicator_vals[] = {
  {   0, "configured-HS-DSCH" },
  {   1, "no-configured-HS-DSCH" },
  { 0, NULL }
};


static int
dissect_rnsap_HSDSCH_Configured_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EDPCH_Information_FDD_sequence[] = {
  { &hf_rnsap_maxSet_E_DPDCHs, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Max_Set_E_DPDCHs },
  { &hf_rnsap_punctureLimit , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PunctureLimit },
  { &hf_rnsap_e_TFCS_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_TFCS_Information },
  { &hf_rnsap_e_TTI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_TTI },
  { &hf_rnsap_e_DPCCH_PO    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DPCCH_PO },
  { &hf_rnsap_e_RGCH_2_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_RGCH_2_IndexStepThreshold },
  { &hf_rnsap_e_RGCH_3_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_RGCH_3_IndexStepThreshold },
  { &hf_rnsap_hARQ_Info_for_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HARQ_Info_for_E_DCH },
  { &hf_rnsap_hSDSCH_Configured_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_Configured_Indicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDPCH_Information_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDPCH_Information_FDD, EDPCH_Information_FDD_sequence);

  return offset;
}


static const per_sequence_t EDPCH_Information_RLReconfPrepare_FDD_sequence[] = {
  { &hf_rnsap_maxSet_E_DPDCHs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Max_Set_E_DPDCHs },
  { &hf_rnsap_punctureLimit , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PunctureLimit },
  { &hf_rnsap_e_TFCS_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_TFCS_Information },
  { &hf_rnsap_e_TTI         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_TTI },
  { &hf_rnsap_e_DPCCH_PO    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DPCCH_PO },
  { &hf_rnsap_e_RGCH_2_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RGCH_2_IndexStepThreshold },
  { &hf_rnsap_e_RGCH_3_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RGCH_3_IndexStepThreshold },
  { &hf_rnsap_hARQ_Info_for_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Info_for_E_DCH },
  { &hf_rnsap_hSDSCH_Configured_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_Configured_Indicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDPCH_Information_RLReconfPrepare_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDPCH_Information_RLReconfPrepare_FDD, EDPCH_Information_RLReconfPrepare_FDD_sequence);

  return offset;
}


static const per_sequence_t EDPCH_Information_RLReconfRequest_FDD_sequence[] = {
  { &hf_rnsap_maxSet_E_DPDCHs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Max_Set_E_DPDCHs },
  { &hf_rnsap_punctureLimit , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PunctureLimit },
  { &hf_rnsap_e_TFCS_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_TFCS_Information },
  { &hf_rnsap_e_TTI         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_TTI },
  { &hf_rnsap_e_DPCCH_PO    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DPCCH_PO },
  { &hf_rnsap_e_RGCH_2_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RGCH_2_IndexStepThreshold },
  { &hf_rnsap_e_RGCH_3_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RGCH_3_IndexStepThreshold },
  { &hf_rnsap_hARQ_Info_for_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_Info_for_E_DCH },
  { &hf_rnsap_hSDSCH_Configured_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_Configured_Indicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDPCH_Information_RLReconfRequest_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDPCH_Information_RLReconfRequest_FDD, EDPCH_Information_RLReconfRequest_FDD_sequence);

  return offset;
}


static const per_sequence_t EDCH_Serving_RL_in_this_DRNS_sequence[] = {
  { &hf_rnsap_e_DCH_Serving_RL_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EDCH_Serving_RL_in_this_DRNS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EDCH_Serving_RL_in_this_DRNS, EDCH_Serving_RL_in_this_DRNS_sequence);

  return offset;
}


static const value_string rnsap_EDCH_Serving_RL_vals[] = {
  {   0, "e-DCH-Serving-RL-in-this-DRNS" },
  {   1, "e-DCH-Serving-RL-not-in-this-DRNS" },
  { 0, NULL }
};

static const per_choice_t EDCH_Serving_RL_choice[] = {
  {   0, &hf_rnsap_e_DCH_Serving_RL_in_this_DRNS, ASN1_EXTENSION_ROOT    , dissect_rnsap_EDCH_Serving_RL_in_this_DRNS },
  {   1, &hf_rnsap_e_DCH_Serving_RL_not_in_this_DRNS, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_EDCH_Serving_RL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_EDCH_Serving_RL, EDCH_Serving_RL_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_PriorityQueue_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfPrioQueues_1, NULL, FALSE);

  return offset;
}


static const value_string rnsap_T1_vals[] = {
  {   0, "v10" },
  {   1, "v20" },
  {   2, "v30" },
  {   3, "v40" },
  {   4, "v50" },
  {   5, "v60" },
  {   6, "v70" },
  {   7, "v80" },
  {   8, "v90" },
  {   9, "v100" },
  {  10, "v120" },
  {  11, "v140" },
  {  12, "v160" },
  {  13, "v200" },
  {  14, "v300" },
  {  15, "v400" },
  { 0, NULL }
};


static int
dissect_rnsap_T1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_MAC_hsWindowSize_vals[] = {
  {   0, "v4" },
  {   1, "v6" },
  {   2, "v8" },
  {   3, "v12" },
  {   4, "v16" },
  {   5, "v24" },
  {   6, "v32" },
  { 0, NULL }
};


static int
dissect_rnsap_MAC_hsWindowSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_MAC_PDU_SizeExtended(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 12032U, NULL, TRUE);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoItem_EnhancedFACH_sequence[] = {
  { &hf_rnsap_priorityQueue_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_Id },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_t1            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T1 },
  { &hf_rnsap_discardTimer  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiscardTimer },
  { &hf_rnsap_mAC_hsWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_hsWindowSize },
  { &hf_rnsap_maximum_MACdPDU_Size_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_PDU_SizeExtended },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PriorityQueue_InfoItem_EnhancedFACH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PriorityQueue_InfoItem_EnhancedFACH, PriorityQueue_InfoItem_EnhancedFACH_sequence);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoList_EnhancedFACH_sequence_of[1] = {
  { &hf_rnsap_PriorityQueue_InfoList_EnhancedFACH_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_InfoItem_EnhancedFACH },
};

static int
dissect_rnsap_PriorityQueue_InfoList_EnhancedFACH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PriorityQueue_InfoList_EnhancedFACH, PriorityQueue_InfoList_EnhancedFACH_sequence_of,
                                                  1, maxNrOfPrioQueues);

  return offset;
}



static int
dissect_rnsap_HSDSCH_InitialWindowSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HSDSCH_Initial_Capacity_AllocationItem_sequence[] = {
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_maximum_MACdPDU_Size, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size },
  { &hf_rnsap_hSDSCH_InitialWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_InitialWindowSize },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_Initial_Capacity_AllocationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_Initial_Capacity_AllocationItem, HSDSCH_Initial_Capacity_AllocationItem_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_Initial_Capacity_Allocation_sequence_of[1] = {
  { &hf_rnsap_HSDSCH_Initial_Capacity_Allocation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_Initial_Capacity_AllocationItem },
};

static int
dissect_rnsap_HSDSCH_Initial_Capacity_Allocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSDSCH_Initial_Capacity_Allocation, HSDSCH_Initial_Capacity_Allocation_sequence_of,
                                                  1, maxNrOfPrioQueues);

  return offset;
}


static const per_sequence_t Enhanced_FACH_Information_ResponseFDD_sequence[] = {
  { &hf_rnsap_priorityQueueInfo_Common_HS_DSCH_RNTI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_InfoList_EnhancedFACH },
  { &hf_rnsap_priorityQueueInfo_Dedicated_HS_DSCH_RNTI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_InfoList_EnhancedFACH },
  { &hf_rnsap_hSDSCH_Initial_Capacity_Allocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_Initial_Capacity_Allocation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Enhanced_FACH_Information_ResponseFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Enhanced_FACH_Information_ResponseFDD, Enhanced_FACH_Information_ResponseFDD_sequence);

  return offset;
}



static int
dissect_rnsap_Enhanced_FACH_Support_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_rnsap_Enhanced_PCH_Support_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_rnsap_E_TFCI_BetaEC_Boost(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_E_TFCI_BetaED_Switch(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_E_DCH_Minimum_Set_E_TFCIValidityIndicator_vals[] = {
  {   0, "e-DCH-Minimum-Set-E-TFCI-response-not-valid" },
  { 0, NULL }
};


static int
dissect_rnsap_E_DCH_Minimum_Set_E_TFCIValidityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_E_AGCH_PowerOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_E_RGCH_PowerOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_E_HICH_PowerOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_Enhanced_PrimaryCPICH_EcNo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 49U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Extension_MeasurementThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_MeasurementThreshold_vals[] = {
  {   0, "sir" },
  {   1, "sir-error" },
  {   2, "transmitted-code-power" },
  {   3, "rscp" },
  {   4, "rx-timing-deviation" },
  {   5, "round-trip-time" },
  {   6, "extension-MeasurementThreshold" },
  { 0, NULL }
};

static const per_choice_t MeasurementThreshold_choice[] = {
  {   0, &hf_rnsap_sir_01        , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Value },
  {   1, &hf_rnsap_sir_error_01  , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Error_Value },
  {   2, &hf_rnsap_transmitted_code_power_01, ASN1_EXTENSION_ROOT    , dissect_rnsap_Transmitted_Code_Power_Value },
  {   3, &hf_rnsap_rscp_01       , ASN1_EXTENSION_ROOT    , dissect_rnsap_RSCP_Value },
  {   4, &hf_rnsap_rx_timing_deviation, ASN1_EXTENSION_ROOT    , dissect_rnsap_Rx_Timing_Deviation_Value },
  {   5, &hf_rnsap_round_trip_time_01, ASN1_EXTENSION_ROOT    , dissect_rnsap_Round_Trip_Time_Value },
  {   6, &hf_rnsap_extension_MeasurementThreshold, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_MeasurementThreshold },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MeasurementThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MeasurementThreshold, MeasurementThreshold_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_MeasurementHysteresisTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 6000U, NULL, TRUE);

  return offset;
}


static const per_sequence_t EventA_sequence[] = {
  { &hf_rnsap_measurementTreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventA, EventA_sequence);

  return offset;
}


static const per_sequence_t EventB_sequence[] = {
  { &hf_rnsap_measurementTreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventB, EventB_sequence);

  return offset;
}



static int
dissect_rnsap_SIR_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 62U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SIR_Error_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 124U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Transmitted_Code_Power_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 112U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_RSCP_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 126U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Round_Trip_Time_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32766U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Extension_MeasurementIncreaseDecreaseThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_MeasurementIncreaseDecreaseThreshold_vals[] = {
  {   0, "sir" },
  {   1, "sir-error" },
  {   2, "transmitted-code-power" },
  {   3, "rscp" },
  {   4, "round-trip-time" },
  {   5, "extension-MeasurementIncreaseDecreaseThreshold" },
  { 0, NULL }
};

static const per_choice_t MeasurementIncreaseDecreaseThreshold_choice[] = {
  {   0, &hf_rnsap_sir           , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Value_IncrDecrThres },
  {   1, &hf_rnsap_sir_error     , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Error_Value_IncrDecrThres },
  {   2, &hf_rnsap_transmitted_code_power, ASN1_EXTENSION_ROOT    , dissect_rnsap_Transmitted_Code_Power_Value_IncrDecrThres },
  {   3, &hf_rnsap_rscp          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RSCP_Value_IncrDecrThres },
  {   4, &hf_rnsap_round_trip_time, ASN1_EXTENSION_ROOT    , dissect_rnsap_Round_Trip_Time_IncrDecrThres },
  {   5, &hf_rnsap_extension_MeasurementIncreaseDecreaseThreshold, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_MeasurementIncreaseDecreaseThreshold },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MeasurementIncreaseDecreaseThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MeasurementIncreaseDecreaseThreshold, MeasurementIncreaseDecreaseThreshold_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_MeasurementChangeTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 6000U, NULL, TRUE);

  return offset;
}


static const per_sequence_t EventC_sequence[] = {
  { &hf_rnsap_measurementIncreaseDecreaseThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementIncreaseDecreaseThreshold },
  { &hf_rnsap_measurementChangeTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementChangeTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventC, EventC_sequence);

  return offset;
}


static const per_sequence_t EventD_sequence[] = {
  { &hf_rnsap_measurementIncreaseDecreaseThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementIncreaseDecreaseThreshold },
  { &hf_rnsap_measurementChangeTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementChangeTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventD, EventD_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_6000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 6000U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_60_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 60U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_ReportPeriodicity_vals[] = {
  {   0, "ten-msec" },
  {   1, "min" },
  { 0, NULL }
};

static const per_choice_t ReportPeriodicity_choice[] = {
  {   0, &hf_rnsap_ten_msec      , ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_1_6000_ },
  {   1, &hf_rnsap_min           , ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_1_60_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_ReportPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_ReportPeriodicity, ReportPeriodicity_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t EventE_sequence[] = {
  { &hf_rnsap_measurementThreshold1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementThreshold2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_reportPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ReportPeriodicity },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventE, EventE_sequence);

  return offset;
}


static const per_sequence_t EventF_sequence[] = {
  { &hf_rnsap_measurementThreshold1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementThreshold2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_reportPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ReportPeriodicity },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventF(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventF, EventF_sequence);

  return offset;
}



static int
dissect_rnsap_ExtendedGSMCellIndividualOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -50, 50U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_N_E_UCCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 12U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_PUCH_Information_sequence[] = {
  { &hf_rnsap_minCR         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CodeRate },
  { &hf_rnsap_maxCR         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CodeRate },
  { &hf_rnsap_harqInfo      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HARQ_Info_for_E_DCH },
  { &hf_rnsap_n_E_UCCH      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_N_E_UCCH },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_PUCH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_PUCH_Information, E_PUCH_Information_sequence);

  return offset;
}



static int
dissect_rnsap_RefBeta(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -15, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_DCH_RefBeta_Item_sequence[] = {
  { &hf_rnsap_refCodeRate   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_CodeRate_short },
  { &hf_rnsap_refBeta       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RefBeta },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_RefBeta_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_RefBeta_Item, E_DCH_RefBeta_Item_sequence);

  return offset;
}


static const per_sequence_t E_DCH_QPSK_RefBetaInfo_sequence_of[1] = {
  { &hf_rnsap_E_DCH_QPSK_RefBetaInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_RefBeta_Item },
};

static int
dissect_rnsap_E_DCH_QPSK_RefBetaInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_QPSK_RefBetaInfo, E_DCH_QPSK_RefBetaInfo_sequence_of,
                                                  1, maxNrOfRefBetas);

  return offset;
}


static const per_sequence_t E_DCH_sixteenQAM_RefBetaInfo_sequence_of[1] = {
  { &hf_rnsap_E_DCH_sixteenQAM_RefBetaInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_RefBeta_Item },
};

static int
dissect_rnsap_E_DCH_sixteenQAM_RefBetaInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_sixteenQAM_RefBetaInfo, E_DCH_sixteenQAM_RefBetaInfo_sequence_of,
                                                  1, maxNrOfRefBetas);

  return offset;
}


static const per_sequence_t E_TFCS_Information_TDD_sequence[] = {
  { &hf_rnsap_e_DCH_QPSK_RefBetaInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_QPSK_RefBetaInfo },
  { &hf_rnsap_e_DCH_sixteenQAM_RefBetaInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_sixteenQAM_RefBetaInfo },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_TFCS_Information_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_TFCS_Information_TDD, E_TFCS_Information_TDD_sequence);

  return offset;
}



static int
dissect_rnsap_E_DCH_HARQ_PO_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 6U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_E_DCH_Grant_TypeTDD_vals[] = {
  {   0, "scheduled" },
  {   1, "non-scheduled" },
  { 0, NULL }
};


static int
dissect_rnsap_E_DCH_Grant_TypeTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t E_DCH_MACdFlow_InfoTDDItem_sequence[] = {
  { &hf_rnsap_e_DCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_tnlQos        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TnlQos },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PayloadCRC_PresenceIndicator },
  { &hf_rnsap_maximum_Number_of_Retransmissions_For_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaxNr_Retransmissions_EDCH },
  { &hf_rnsap_eDCH_HARQ_PO_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_HARQ_PO_TDD },
  { &hf_rnsap_eDCH_MACdFlow_Multiplexing_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlow_Multiplexing_List },
  { &hf_rnsap_eDCH_Grant_TypeTDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_Grant_TypeTDD },
  { &hf_rnsap_eDCHLogicalChannelInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_LogicalChannelInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_MACdFlow_InfoTDDItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_MACdFlow_InfoTDDItem, E_DCH_MACdFlow_InfoTDDItem_sequence);

  return offset;
}


static const per_sequence_t E_DCH_MACdFlows_Information_TDD_sequence_of[1] = {
  { &hf_rnsap_E_DCH_MACdFlows_Information_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdFlow_InfoTDDItem },
};

static int
dissect_rnsap_E_DCH_MACdFlows_Information_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_MACdFlows_Information_TDD, E_DCH_MACdFlows_Information_TDD_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}



static int
dissect_rnsap_E_DCH_TDD_Maximum_Bitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9201U, NULL, TRUE);

  return offset;
}


static const per_sequence_t E_DCH_TDD_Information_sequence[] = {
  { &hf_rnsap_e_DCH_TDD_Maximum_Bitrate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Maximum_Bitrate },
  { &hf_rnsap_e_DCH_Processing_Overload_Level, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Processing_Overload_Level },
  { &hf_rnsap_e_DCH_PowerOffset_for_SchedulingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_PowerOffset_for_SchedulingInfo },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_TDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_TDD_Information, E_DCH_TDD_Information_sequence);

  return offset;
}


static const per_sequence_t E_DCH_Information_sequence[] = {
  { &hf_rnsap_e_PUCH_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_PUCH_Information },
  { &hf_rnsap_e_TFCS_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_TFCS_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdFlows_Information_TDD },
  { &hf_rnsap_e_DCH_TDD_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TDD_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Information, E_DCH_Information_sequence);

  return offset;
}


static const value_string rnsap_E_DCH_MACdFlow_Retransmission_Timer_LCR_vals[] = {
  {   0, "ms10" },
  {   1, "ms15" },
  {   2, "ms20" },
  {   3, "ms25" },
  {   4, "ms30" },
  {   5, "ms35" },
  {   6, "ms40" },
  {   7, "ms45" },
  {   8, "ms50" },
  {   9, "ms55" },
  {  10, "ms60" },
  {  11, "ms65" },
  {  12, "ms70" },
  {  13, "ms75" },
  {  14, "ms80" },
  {  15, "ms85" },
  {  16, "ms90" },
  {  17, "ms95" },
  {  18, "ms100" },
  {  19, "ms110" },
  {  20, "ms120" },
  {  21, "ms140" },
  {  22, "ms160" },
  {  23, "ms200" },
  {  24, "ms240" },
  {  25, "ms280" },
  {  26, "ms320" },
  {  27, "ms400" },
  {  28, "ms480" },
  {  29, "ms560" },
  { 0, NULL }
};


static int
dissect_rnsap_E_DCH_MACdFlow_Retransmission_Timer_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     30, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_E_DCH_TimeslotResource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     13, 13, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_E_DCH_PowerResource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TddE_PUCH_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_RepetitionPeriod_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  { 0, NULL }
};


static int
dissect_rnsap_RepetitionPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_RepetitionLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_DCH_Non_Scheduled_Grant_Info_sequence[] = {
  { &hf_rnsap_timeslotResource, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TimeslotResource },
  { &hf_rnsap_powerResource , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_PowerResource },
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tddE_PUCH_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TddE_PUCH_Offset },
  { &hf_rnsap_tdd_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Non_Scheduled_Grant_Info, E_DCH_Non_Scheduled_Grant_Info_sequence);

  return offset;
}


static const per_sequence_t E_DCH_MACdFlow_ModifyTDDItem_sequence[] = {
  { &hf_rnsap_e_DCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_tnlQos        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TnlQos },
  { &hf_rnsap_maximum_Number_of_Retransmissions_For_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MaxNr_Retransmissions_EDCH },
  { &hf_rnsap_eDCH_HARQ_PO_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_HARQ_PO_TDD },
  { &hf_rnsap_eDCH_MACdFlow_Multiplexing_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlow_Multiplexing_List },
  { &hf_rnsap_eDCH_Grant_TypeTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Grant_TypeTDD },
  { &hf_rnsap_e_DCH_LogicalChannelToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_LogicalChannelInformation },
  { &hf_rnsap_e_DCH_LogicalChannelToModify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_LogicalChannelToModify },
  { &hf_rnsap_e_DCH_LogicalChannelToDelete, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_LogicalChannelToDelete },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_MACdFlow_ModifyTDDItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_MACdFlow_ModifyTDDItem, E_DCH_MACdFlow_ModifyTDDItem_sequence);

  return offset;
}


static const per_sequence_t E_DCH_TDD_Information_to_Modify_List_sequence_of[1] = {
  { &hf_rnsap_E_DCH_TDD_Information_to_Modify_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdFlow_ModifyTDDItem },
};

static int
dissect_rnsap_E_DCH_TDD_Information_to_Modify_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_TDD_Information_to_Modify_List, E_DCH_TDD_Information_to_Modify_List_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const per_sequence_t E_DCH_TDD_Information_to_Modify_sequence[] = {
  { &hf_rnsap_e_DCH_TDD_Information_to_Modify_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Information_to_Modify_List },
  { &hf_rnsap_mACeReset_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MACeReset_Indicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_TDD_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_TDD_Information_to_Modify, E_DCH_TDD_Information_to_Modify_sequence);

  return offset;
}


static const per_sequence_t E_DCH_Information_Reconfig_sequence[] = {
  { &hf_rnsap_e_PUCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_PUCH_Information },
  { &hf_rnsap_e_TFCS_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_TFCS_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_to_Add, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlows_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_to_Delete, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_EDCH_MACdFlows_To_Delete },
  { &hf_rnsap_e_DCH_Non_Scheduled_Grant_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info },
  { &hf_rnsap_e_DCH_TDD_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Information },
  { &hf_rnsap_e_DCH_TDD_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Information_to_Modify },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Information_Reconfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Information_Reconfig, E_DCH_Information_Reconfig_sequence);

  return offset;
}


static const per_sequence_t E_DCH_TDD_MACdFlow_Specific_InformationResp_Item_sequence[] = {
  { &hf_rnsap_e_DCH_MacdFlow_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp_Item, E_DCH_TDD_MACdFlow_Specific_InformationResp_Item_sequence);

  return offset;
}


static const per_sequence_t E_DCH_TDD_MACdFlow_Specific_InformationResp_sequence_of[1] = {
  { &hf_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp_Item },
};

static int
dissect_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp, E_DCH_TDD_MACdFlow_Specific_InformationResp_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const per_sequence_t E_AGCH_Specific_InformationResp_ItemTDD_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_AGCH_Specific_InformationResp_ItemTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_AGCH_Specific_InformationResp_ItemTDD, E_AGCH_Specific_InformationResp_ItemTDD_sequence);

  return offset;
}


static const per_sequence_t E_AGCH_Specific_InformationRespListTDD_sequence_of[1] = {
  { &hf_rnsap_E_AGCH_Specific_InformationRespListTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_AGCH_Specific_InformationResp_ItemTDD },
};

static int
dissect_rnsap_E_AGCH_Specific_InformationRespListTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_AGCH_Specific_InformationRespListTDD, E_AGCH_Specific_InformationRespListTDD_sequence_of,
                                                  1, maxNrOfEAGCHCodes);

  return offset;
}



static int
dissect_rnsap_E_HICH_TimeOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            4U, 44U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_HICH_InformationResp_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_e_HICH_TimeOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_HICH_TimeOffset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_HICH_InformationResp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_HICH_InformationResp, E_HICH_InformationResp_sequence);

  return offset;
}


static const per_sequence_t E_DCH_Information_Response_sequence[] = {
  { &hf_rnsap_e_DCH_TDD_MACdFlow_Specific_InformationResp, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp },
  { &hf_rnsap_e_AGCH_Specific_Information_ResponseTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_AGCH_Specific_InformationRespListTDD },
  { &hf_rnsap_e_HICH_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_HICH_InformationResp },
  { &hf_rnsap_e_DCH_Non_Scheduled_Grant_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info },
  { &hf_rnsap_e_RNTI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_RNTI },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Information_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Information_Response, E_DCH_Information_Response_sequence);

  return offset;
}



static int
dissect_rnsap_E_DCH_TDD_Maximum_Bitrate768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 17713U, NULL, TRUE);

  return offset;
}


static const per_sequence_t E_DCH_TDD_Information768_sequence[] = {
  { &hf_rnsap_e_DCH_TDD_Maximum_Bitrate768, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Maximum_Bitrate768 },
  { &hf_rnsap_e_DCH_Processing_Overload_Level, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Processing_Overload_Level },
  { &hf_rnsap_e_DCH_PowerOffset_for_SchedulingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_PowerOffset_for_SchedulingInfo },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_TDD_Information768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_TDD_Information768, E_DCH_TDD_Information768_sequence);

  return offset;
}


static const per_sequence_t E_DCH_768_Information_sequence[] = {
  { &hf_rnsap_e_PUCH_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_PUCH_Information },
  { &hf_rnsap_e_TFCS_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_TFCS_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdFlows_Information_TDD },
  { &hf_rnsap_e_DCH_TDD_Information768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TDD_Information768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_768_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_768_Information, E_DCH_768_Information_sequence);

  return offset;
}


static const per_sequence_t E_DCH_Non_Scheduled_Grant_Info768_sequence[] = {
  { &hf_rnsap_timeslotResource, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TimeslotResource },
  { &hf_rnsap_powerResource , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_PowerResource },
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tddE_PUCH_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TddE_PUCH_Offset },
  { &hf_rnsap_tdd_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Non_Scheduled_Grant_Info768, E_DCH_Non_Scheduled_Grant_Info768_sequence);

  return offset;
}


static const per_sequence_t E_DCH_768_Information_Reconfig_sequence[] = {
  { &hf_rnsap_e_PUCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_PUCH_Information },
  { &hf_rnsap_e_TFCS_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_TFCS_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_to_Add, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlows_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_to_Delete, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_EDCH_MACdFlows_To_Delete },
  { &hf_rnsap_e_DCH_Non_Scheduled_Grant_Info768, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info768 },
  { &hf_rnsap_e_DCH_TDD_Information768, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Information768 },
  { &hf_rnsap_e_DCH_TDD_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Information_to_Modify },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_768_Information_Reconfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_768_Information_Reconfig, E_DCH_768_Information_Reconfig_sequence);

  return offset;
}


static const per_sequence_t E_AGCH_Specific_InformationResp_Item768TDD_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_tDD_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_AGCH_Specific_InformationResp_Item768TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_AGCH_Specific_InformationResp_Item768TDD, E_AGCH_Specific_InformationResp_Item768TDD_sequence);

  return offset;
}


static const per_sequence_t E_AGCH_Specific_InformationRespList768TDD_sequence_of[1] = {
  { &hf_rnsap_E_AGCH_Specific_InformationRespList768TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_AGCH_Specific_InformationResp_Item768TDD },
};

static int
dissect_rnsap_E_AGCH_Specific_InformationRespList768TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_AGCH_Specific_InformationRespList768TDD, E_AGCH_Specific_InformationRespList768TDD_sequence_of,
                                                  1, maxNrOfEAGCHCodes);

  return offset;
}


static const per_sequence_t E_HICH_InformationResp768_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_tDD_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_e_HICH_TimeOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_HICH_TimeOffset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_HICH_InformationResp768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_HICH_InformationResp768, E_HICH_InformationResp768_sequence);

  return offset;
}


static const per_sequence_t E_DCH_768_Information_Response_sequence[] = {
  { &hf_rnsap_e_DCH_TDD_MACdFlow_Specific_InformationResp, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp },
  { &hf_rnsap_e_AGCH_Specific_Information_Response768TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_AGCH_Specific_InformationRespList768TDD },
  { &hf_rnsap_e_HICH_Information_Response768, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_HICH_InformationResp768 },
  { &hf_rnsap_e_DCH_Non_Scheduled_Grant_Info768, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info768 },
  { &hf_rnsap_e_RNTI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_RNTI },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_768_Information_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_768_Information_Response, E_DCH_768_Information_Response_sequence);

  return offset;
}



static int
dissect_rnsap_E_PUCH_PRXdesBase(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -112, -50, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TDD_TPC_UplinkStepSize_LCR_vals[] = {
  {   0, "step-size1" },
  {   1, "step-size2" },
  {   2, "step-size3" },
  { 0, NULL }
};


static int
dissect_rnsap_TDD_TPC_UplinkStepSize_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_N_E_UCCH_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_PUCH_LCR_Information_sequence[] = {
  { &hf_rnsap_minCR         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CodeRate },
  { &hf_rnsap_maxCR         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CodeRate },
  { &hf_rnsap_harqInfo      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HARQ_Info_for_E_DCH },
  { &hf_rnsap_pRxdesBase    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_PUCH_PRXdesBase },
  { &hf_rnsap_e_PUCH_TPC_Step_Size, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_TPC_UplinkStepSize_LCR },
  { &hf_rnsap_n_E_UCCH_LCR  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_N_E_UCCH_LCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_PUCH_LCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_PUCH_LCR_Information, E_PUCH_LCR_Information_sequence);

  return offset;
}



static int
dissect_rnsap_E_DCH_Physical_Layer_Category_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 5U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_DCH_LCR_TDD_Information_sequence[] = {
  { &hf_rnsap_e_DCH_Physical_Layer_Category_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Physical_Layer_Category_LCR },
  { &hf_rnsap_e_DCH_Processing_Overload_Level, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Processing_Overload_Level },
  { &hf_rnsap_e_DCH_PowerOffset_for_SchedulingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_PowerOffset_for_SchedulingInfo },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_LCR_TDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_LCR_TDD_Information, E_DCH_LCR_TDD_Information_sequence);

  return offset;
}


static const per_sequence_t E_DCH_LCR_Information_sequence[] = {
  { &hf_rnsap_e_PUCH_LCR_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_PUCH_LCR_Information },
  { &hf_rnsap_e_TFCS_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_TFCS_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_MACdFlows_Information_TDD },
  { &hf_rnsap_e_DCH_LCR_TDD_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_LCR_TDD_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_LCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_LCR_Information, E_DCH_LCR_Information_sequence);

  return offset;
}


static const per_sequence_t E_DCH_LCR_Information_Reconfig_sequence[] = {
  { &hf_rnsap_e_PUCH_LCR_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_PUCH_LCR_Information },
  { &hf_rnsap_e_TFCS_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_TFCS_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_to_Add, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_MACdFlows_Information_TDD },
  { &hf_rnsap_e_DCH_MACdFlows_to_Delete, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_EDCH_MACdFlows_To_Delete },
  { &hf_rnsap_e_DCH_LCR_TDD_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_LCR_TDD_Information },
  { &hf_rnsap_e_DCH_TDD_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_Information_to_Modify },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_LCR_Information_Reconfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_LCR_Information_Reconfig, E_DCH_LCR_Information_Reconfig_sequence);

  return offset;
}


static const per_sequence_t E_AGCH_Specific_InformationResp_Item_LCR_TDD_sequence[] = {
  { &hf_rnsap_timeSlotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_AGCH_Specific_InformationResp_Item_LCR_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_AGCH_Specific_InformationResp_Item_LCR_TDD, E_AGCH_Specific_InformationResp_Item_LCR_TDD_sequence);

  return offset;
}


static const per_sequence_t E_AGCH_Specific_InformationRespList_LCR_TDD_sequence_of[1] = {
  { &hf_rnsap_E_AGCH_Specific_InformationRespList_LCR_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_AGCH_Specific_InformationResp_Item_LCR_TDD },
};

static int
dissect_rnsap_E_AGCH_Specific_InformationRespList_LCR_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_AGCH_Specific_InformationRespList_LCR_TDD, E_AGCH_Specific_InformationRespList_LCR_TDD_sequence_of,
                                                  1, maxNrOfEAGCHCodes);

  return offset;
}



static int
dissect_rnsap_E_HICH_EI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SignatureSequenceGroupIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_HICH_InformationResp_LCR_sequence[] = {
  { &hf_rnsap_timeSlotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_signatureSequenceGroupIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SignatureSequenceGroupIndex },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_HICH_InformationResp_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_HICH_InformationResp_LCR, E_HICH_InformationResp_LCR_sequence);

  return offset;
}


static const per_sequence_t E_HICH_Scheduled_InformationResp_Item_LCR_TDD_sequence[] = {
  { &hf_rnsap_e_HICH_EI     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_HICH_EI },
  { &hf_rnsap_e_HICH_Scheduled_InformationResp_LCR_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_HICH_InformationResp_LCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_HICH_Scheduled_InformationResp_Item_LCR_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_HICH_Scheduled_InformationResp_Item_LCR_TDD, E_HICH_Scheduled_InformationResp_Item_LCR_TDD_sequence);

  return offset;
}


static const per_sequence_t E_HICH_Scheduled_InformationRespList_LCR_TDD_sequence_of[1] = {
  { &hf_rnsap_E_HICH_Scheduled_InformationRespList_LCR_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_E_HICH_Scheduled_InformationResp_Item_LCR_TDD },
};

static int
dissect_rnsap_E_HICH_Scheduled_InformationRespList_LCR_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_E_HICH_Scheduled_InformationRespList_LCR_TDD, E_HICH_Scheduled_InformationRespList_LCR_TDD_sequence_of,
                                                  1, maxNrOfEHICHCodes);

  return offset;
}



static int
dissect_rnsap_E_HICH_TimeOffset_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            4U, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_HICH_Specific_InformationResp_LCR_sequence[] = {
  { &hf_rnsap_e_HICH_Scheduled_InformationResp_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_HICH_Scheduled_InformationRespList_LCR_TDD },
  { &hf_rnsap_e_HICH_non_Scheduled_InformationResp_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_HICH_InformationResp_LCR },
  { &hf_rnsap_e_HICH_TimeOffset_lcr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_HICH_TimeOffset_LCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_HICH_Specific_InformationResp_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_HICH_Specific_InformationResp_LCR, E_HICH_Specific_InformationResp_LCR_sequence);

  return offset;
}



static int
dissect_rnsap_E_DCH_TimeslotResource_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     5, 5, FALSE, NULL);

  return offset;
}


static const value_string rnsap_E_DCH_SubframeNumber_LCR_vals[] = {
  {   0, "s0" },
  {   1, "s1" },
  { 0, NULL }
};


static int
dissect_rnsap_E_DCH_SubframeNumber_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t E_DCH_Non_Scheduled_Grant_Info_LCR_sequence[] = {
  { &hf_rnsap_timeslotResource_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_TimeslotResource_LCR },
  { &hf_rnsap_powerResource , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_PowerResource },
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_subframenumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_E_DCH_SubframeNumber_LCR },
  { &hf_rnsap_tddE_PUCH_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TddE_PUCH_Offset },
  { &hf_rnsap_tdd_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_Non_Scheduled_Grant_Info_LCR, E_DCH_Non_Scheduled_Grant_Info_LCR_sequence);

  return offset;
}


static const per_sequence_t E_DCH_LCR_Information_Response_sequence[] = {
  { &hf_rnsap_e_DCH_TDD_MACdFlow_Specific_InformationResp, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_TDD_MACdFlow_Specific_InformationResp },
  { &hf_rnsap_e_AGCH_Specific_Information_Response_LCR_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_AGCH_Specific_InformationRespList_LCR_TDD },
  { &hf_rnsap_e_HICH_Specific_Information_Response_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_HICH_Specific_InformationResp_LCR },
  { &hf_rnsap_e_DCH_Non_Scheduled_Grant_Info_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_DCH_Non_Scheduled_Grant_Info_LCR },
  { &hf_rnsap_e_RNTI        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RNTI },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_E_DCH_LCR_Information_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_E_DCH_LCR_Information_Response, E_DCH_LCR_Information_Response_sequence);

  return offset;
}



static int
dissect_rnsap_ExtendedPropagationDelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            255U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Extended_RNC_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            4096U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Extended_Round_Trip_Time_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            32767U, 103041U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_FACH_InitialWindowSize_vals[] = {
  { 255, "unlimited" },
  { 0, NULL }
};


static int
dissect_rnsap_FACH_InitialWindowSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t FACH_FlowControlInformationItem_sequence[] = {
  { &hf_rnsap_fACH_SchedulingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_mAC_c_sh_SDU_Lengths, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_c_sh_SDU_LengthList },
  { &hf_rnsap_fACH_InitialWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InitialWindowSize },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FACH_FlowControlInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FACH_FlowControlInformationItem, FACH_FlowControlInformationItem_sequence);

  return offset;
}


static const per_sequence_t FACH_FlowControlInformation_sequence_of[1] = {
  { &hf_rnsap_FACH_FlowControlInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_FlowControlInformationItem },
};

static int
dissect_rnsap_FACH_FlowControlInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FACH_FlowControlInformation, FACH_FlowControlInformation_sequence_of,
                                                  1, 16);

  return offset;
}


static const per_sequence_t FACH_InformationItem_sequence[] = {
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FACH_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FACH_InformationItem, FACH_InformationItem_sequence);

  return offset;
}


static const per_sequence_t FACH_InformationList_sequence_of[1] = {
  { &hf_rnsap_FACH_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InformationItem },
};

static int
dissect_rnsap_FACH_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FACH_InformationList, FACH_InformationList_sequence_of,
                                                  0, maxNrOfFACHs);

  return offset;
}


static const value_string rnsap_Fast_Reconfiguration_Mode_vals[] = {
  {   0, "fast" },
  { 0, NULL }
};


static int
dissect_rnsap_Fast_Reconfiguration_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_Fast_Reconfiguration_Permission_vals[] = {
  {   0, "allowed" },
  { 0, NULL }
};


static int
dissect_rnsap_Fast_Reconfiguration_Permission(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t FDD_DCHs_to_ModifySpecificItem_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_ul_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_not_Used_dRACControl, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FDD_DCHs_to_ModifySpecificItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FDD_DCHs_to_ModifySpecificItem, FDD_DCHs_to_ModifySpecificItem_sequence);

  return offset;
}


static const per_sequence_t FDD_DCHs_to_ModifySpecificInformationList_sequence_of[1] = {
  { &hf_rnsap_FDD_DCHs_to_ModifySpecificInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DCHs_to_ModifySpecificItem },
};

static int
dissect_rnsap_FDD_DCHs_to_ModifySpecificInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FDD_DCHs_to_ModifySpecificInformationList, FDD_DCHs_to_ModifySpecificInformationList_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const per_sequence_t FDD_DCHs_to_ModifyItem_sequence[] = {
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWE },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_dCH_SpecificInformationList_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DCHs_to_ModifySpecificInformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FDD_DCHs_to_ModifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FDD_DCHs_to_ModifyItem, FDD_DCHs_to_ModifyItem_sequence);

  return offset;
}


static const per_sequence_t FDD_DCHs_to_Modify_sequence_of[1] = {
  { &hf_rnsap_FDD_DCHs_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DCHs_to_ModifyItem },
};

static int
dissect_rnsap_FDD_DCHs_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FDD_DCHs_to_Modify, FDD_DCHs_to_Modify_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const value_string rnsap_Transmission_Gap_Pattern_Sequence_ScramblingCode_Information_vals[] = {
  {   0, "code-change" },
  {   1, "nocode-change" },
  { 0, NULL }
};


static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_ScramblingCode_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t FDD_DL_CodeInformationItem_sequence[] = {
  { &hf_rnsap_dl_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_ScramblingCode },
  { &hf_rnsap_fDD_DL_ChannelisationCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_ChannelisationCodeNumber },
  { &hf_rnsap_transmission_Gap_Pattern_Sequence_ScramblingCode_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Transmission_Gap_Pattern_Sequence_ScramblingCode_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FDD_DL_CodeInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FDD_DL_CodeInformationItem, FDD_DL_CodeInformationItem_sequence);

  return offset;
}


static const per_sequence_t FDD_DL_CodeInformation_sequence_of[1] = {
  { &hf_rnsap_FDD_DL_CodeInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_CodeInformationItem },
};

static int
dissect_rnsap_FDD_DL_CodeInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FDD_DL_CodeInformation, FDD_DL_CodeInformation_sequence_of,
                                                  1, maxNrOfDL_Codes);

  return offset;
}


static const value_string rnsap_FDD_TPC_DownlinkStepSize_vals[] = {
  {   0, "step-size0-5" },
  {   1, "step-size1" },
  {   2, "step-size1-5" },
  {   3, "step-size2" },
  { 0, NULL }
};


static int
dissect_rnsap_FDD_TPC_DownlinkStepSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_F_DPCH_SlotFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_F_DPCH_SlotFormatSupportRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_FNReportingIndicator_vals[] = {
  {   0, "fN-reporting-required" },
  {   1, "fN-reporting-not-required" },
  { 0, NULL }
};


static int
dissect_rnsap_FNReportingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, FALSE);

  return offset;
}


static const per_sequence_t FPACH_Information_sequence[] = {
  { &hf_rnsap_timeSlotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_tDD_ChannelisationCodeLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCodeLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_wT            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FPACH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FPACH_Information, FPACH_Information_sequence);

  return offset;
}



static int
dissect_rnsap_FrameOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_FrequencyBandIndicator_vals[] = {
  {   0, "bandI" },
  {   1, "bandII" },
  {   2, "bandIII" },
  {   3, "bandIV" },
  {   4, "bandV" },
  {   5, "bandVI" },
  {   6, "bandVII" },
  {   7, "bandVIII" },
  {   8, "bandIX" },
  {   9, "bandX" },
  {  10, "bandXI" },
  {  11, "bandXII" },
  {  12, "bandXIII" },
  {  13, "bandXIV" },
  {  14, "bandXV" },
  {  15, "bandXVI" },
  {  16, "bandXVII" },
  {  17, "bandXVIII" },
  {  18, "bandXIX" },
  {  19, "bandXX" },
  {  20, "bandXXI" },
  {  21, "bandXXII" },
  { 0, NULL }
};


static int
dissect_rnsap_FrequencyBandIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     22, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_GapLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 14U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_GapDuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 144U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_T_latitudeSign_01_vals[] = {
  {   0, "north" },
  {   1, "south" },
  { 0, NULL }
};


static int
dissect_rnsap_T_latitudeSign_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8388607U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_M8388608_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8388608, 8388607U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GeographicalCoordinate_sequence[] = {
  { &hf_rnsap_latitudeSign_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_latitudeSign_01 },
  { &hf_rnsap_latitude      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_8388607 },
  { &hf_rnsap_longitude     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_M8388608_8388607 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GeographicalCoordinate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GeographicalCoordinate, GeographicalCoordinate_sequence);

  return offset;
}


static const per_sequence_t GA_Cell_item_sequence[] = {
  { &hf_rnsap_cell_GAIgeographicalCoordinate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_Cell_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_Cell_item, GA_Cell_item_sequence);

  return offset;
}


static const per_sequence_t GA_Cell_sequence_of[1] = {
  { &hf_rnsap_GA_Cell_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_Cell_item },
};

static int
dissect_rnsap_GA_Cell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GA_Cell, GA_Cell_sequence_of,
                                                  1, maxNrOfPoints);

  return offset;
}


static const per_sequence_t GA_PointWithUnCertainty_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_uncertaintyCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithUnCertainty(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithUnCertainty, GA_PointWithUnCertainty_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_179(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 179U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GA_UncertaintyEllipse_sequence[] = {
  { &hf_rnsap_uncertaintySemi_major, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_uncertaintySemi_minor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_orientationOfMajorAxis, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_179 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_UncertaintyEllipse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_UncertaintyEllipse, GA_UncertaintyEllipse_sequence);

  return offset;
}


static const per_sequence_t GA_PointWithUnCertaintyEllipse_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_uncertaintyEllipse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_UncertaintyEllipse },
  { &hf_rnsap_confidence    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithUnCertaintyEllipse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithUnCertaintyEllipse, GA_PointWithUnCertaintyEllipse_sequence);

  return offset;
}


static const value_string rnsap_T_directionOfAltitude_vals[] = {
  {   0, "height" },
  {   1, "depth" },
  { 0, NULL }
};


static int
dissect_rnsap_T_directionOfAltitude(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GA_AltitudeAndDirection_sequence[] = {
  { &hf_rnsap_directionOfAltitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_directionOfAltitude },
  { &hf_rnsap_altitude      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_32767 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_AltitudeAndDirection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_AltitudeAndDirection, GA_AltitudeAndDirection_sequence);

  return offset;
}


static const per_sequence_t GA_PointWithAltitude_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_altitudeAndDirection, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_AltitudeAndDirection },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithAltitude(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithAltitude, GA_PointWithAltitude_sequence);

  return offset;
}


static const per_sequence_t GA_PointWithAltitudeAndUncertaintyEllipsoid_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_altitudeAndDirection, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_AltitudeAndDirection },
  { &hf_rnsap_uncertaintyEllipse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_UncertaintyEllipse },
  { &hf_rnsap_uncertaintyAltitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_confidence    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid, GA_PointWithAltitudeAndUncertaintyEllipsoid_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GA_EllipsoidArc_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_innerRadius   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_65535 },
  { &hf_rnsap_uncertaintyRadius, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_offsetAngle   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_179 },
  { &hf_rnsap_includedAngle , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_179 },
  { &hf_rnsap_confidence    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_EllipsoidArc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_EllipsoidArc, GA_EllipsoidArc_sequence);

  return offset;
}


static const value_string rnsap_GA_CellAdditionalShapes_vals[] = {
  {   0, "pointWithUncertainty" },
  {   1, "pointWithUncertaintyEllipse" },
  {   2, "pointWithAltitude" },
  {   3, "pointWithAltitudeAndUncertaintyEllipsoid" },
  {   4, "ellipsoidArc" },
  { 0, NULL }
};

static const per_choice_t GA_CellAdditionalShapes_choice[] = {
  {   0, &hf_rnsap_pointWithUncertainty, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithUnCertainty },
  {   1, &hf_rnsap_pointWithUncertaintyEllipse, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithUnCertaintyEllipse },
  {   2, &hf_rnsap_pointWithAltitude, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithAltitude },
  {   3, &hf_rnsap_pointWithAltitudeAndUncertaintyEllipsoid, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid },
  {   4, &hf_rnsap_ellipsoidArc  , ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_EllipsoidArc },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_GA_CellAdditionalShapes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_GA_CellAdditionalShapes, GA_CellAdditionalShapes_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_36(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     11, 11, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     17, 17, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     14, 14, FALSE, NULL);

  return offset;
}


static const per_sequence_t GANSS_SatelliteInformationKP_item_sequence[] = {
  { &hf_rnsap_ganss_e_alm   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_ganss_delta_I_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_ganss_omegadot_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_ganss_svhealth_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_4 },
  { &hf_rnsap_ganss_delta_a_sqrt_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_17 },
  { &hf_rnsap_ganss_omegazero_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_ganss_m_zero_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_ganss_omega_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_ganss_af_zero_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_14 },
  { &hf_rnsap_ganss_af_one_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_SatelliteInformationKP_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_SatelliteInformationKP_item, GANSS_SatelliteInformationKP_item_sequence);

  return offset;
}


static const per_sequence_t GANSS_SatelliteInformationKP_sequence_of[1] = {
  { &hf_rnsap_GANSS_SatelliteInformationKP_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_SatelliteInformationKP_item },
};

static int
dissect_rnsap_GANSS_SatelliteInformationKP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GANSS_SatelliteInformationKP, GANSS_SatelliteInformationKP_sequence_of,
                                                  1, maxGANSSSat);

  return offset;
}


static const per_sequence_t T_gANSS_keplerianParameters_sequence[] = {
  { &hf_rnsap_t_oa          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_255 },
  { &hf_rnsap_iod_a         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_3 },
  { &hf_rnsap_gANSS_SatelliteInformationKP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_SatelliteInformationKP },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_gANSS_keplerianParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_gANSS_keplerianParameters, T_gANSS_keplerianParameters_sequence);

  return offset;
}


static const value_string rnsap_T_gANSS_AlmanacModel_vals[] = {
  {   0, "gANSS-keplerianParameters" },
  { 0, NULL }
};

static const per_choice_t T_gANSS_AlmanacModel_choice[] = {
  {   0, &hf_rnsap_gANSS_keplerianParameters, ASN1_EXTENSION_ROOT    , dissect_rnsap_T_gANSS_keplerianParameters },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_T_gANSS_AlmanacModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_T_gANSS_AlmanacModel, T_gANSS_AlmanacModel_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GANSS_Almanac_sequence[] = {
  { &hf_rnsap_ganss_wk_number, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_255 },
  { &hf_rnsap_ganss_sat_id  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_36 },
  { &hf_rnsap_gANSS_AlmanacModel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_gANSS_AlmanacModel },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Almanac(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Almanac, GANSS_Almanac_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 12, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     18, 18, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GANSS_Clock_Model_item_sequence[] = {
  { &hf_rnsap_t_oc_lsb      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_511 },
  { &hf_rnsap_a_i2          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_12 },
  { &hf_rnsap_a_i1          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_18 },
  { &hf_rnsap_a_i0          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_28 },
  { &hf_rnsap_t_gd          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_10 },
  { &hf_rnsap_model_id      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_1 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Clock_Model_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Clock_Model_item, GANSS_Clock_Model_item_sequence);

  return offset;
}


static const per_sequence_t GANSS_Clock_Model_sequence_of[1] = {
  { &hf_rnsap_GANSS_Clock_Model_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Clock_Model_item },
};

static int
dissect_rnsap_GANSS_Clock_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GANSS_Clock_Model, GANSS_Clock_Model_sequence_of,
                                                  1, 4);

  return offset;
}



static int
dissect_rnsap_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t GANSS_IonosphereRegionalStormFlags_sequence[] = {
  { &hf_rnsap_storm_flag_one, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BOOLEAN },
  { &hf_rnsap_storm_flag_two, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BOOLEAN },
  { &hf_rnsap_storm_flag_three, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BOOLEAN },
  { &hf_rnsap_storm_flag_four, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BOOLEAN },
  { &hf_rnsap_storm_flag_five, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BOOLEAN },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_IonosphereRegionalStormFlags(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_IonosphereRegionalStormFlags, GANSS_IonosphereRegionalStormFlags_sequence);

  return offset;
}


static const per_sequence_t GANSS_Ionospheric_Model_sequence[] = {
  { &hf_rnsap_alpha_zero_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_12 },
  { &hf_rnsap_alpha_one_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_12 },
  { &hf_rnsap_alpha_two_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_12 },
  { &hf_rnsap_gANSS_IonosphereRegionalStormFlags, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_IonosphereRegionalStormFlags },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Ionospheric_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Ionospheric_Model, GANSS_Ionospheric_Model_sequence);

  return offset;
}


static const value_string rnsap_T_latitudeSign_vals[] = {
  {   0, "north" },
  {   1, "south" },
  { 0, NULL }
};


static int
dissect_rnsap_T_latitudeSign(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_2147483647(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2147483647U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_M2147483648_2147483647(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2147483648, 2147483647U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_T_directionOfAltitude_01_vals[] = {
  {   0, "height" },
  {   1, "depth" },
  { 0, NULL }
};


static int
dissect_rnsap_T_directionOfAltitude_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GANSS_RX_Pos_sequence[] = {
  { &hf_rnsap_latitudeSign  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_latitudeSign },
  { &hf_rnsap_degreesOfLatitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_2147483647 },
  { &hf_rnsap_degreesOfLongitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_M2147483648_2147483647 },
  { &hf_rnsap_directionOfAltitude_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_directionOfAltitude_01 },
  { &hf_rnsap_altitude      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_32767 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_RX_Pos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_RX_Pos, GANSS_RX_Pos_sequence);

  return offset;
}


static const per_sequence_t GANSS_Common_Data_sequence[] = {
  { &hf_rnsap_ganss_Ionospheric_Model, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_Ionospheric_Model },
  { &hf_rnsap_ganss_Rx_Pos  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_RX_Pos },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Common_Data(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Common_Data, GANSS_Common_Data_sequence);

  return offset;
}


static const per_sequence_t GANSS_CommonDataInfoReq_sequence[] = {
  { &hf_rnsap_ionospheric_Model, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BOOLEAN },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_CommonDataInfoReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_CommonDataInfoReq, GANSS_CommonDataInfoReq_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GANSS_GenericDataInfoReqItem_sequence[] = {
  { &hf_rnsap_ganss_Id      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_7 },
  { &hf_rnsap_ganss_Navigation_Model, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BOOLEAN },
  { &hf_rnsap_ganss_Time_Model, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_ganss_UTC_Model, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BOOLEAN },
  { &hf_rnsap_ganss_Almanac , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BOOLEAN },
  { &hf_rnsap_ganss_Real_Time_Integrity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BOOLEAN },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_GenericDataInfoReqItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_GenericDataInfoReqItem, GANSS_GenericDataInfoReqItem_sequence);

  return offset;
}


static const per_sequence_t GANSS_GenericDataInfoReqList_sequence_of[1] = {
  { &hf_rnsap_GANSS_GenericDataInfoReqList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_GenericDataInfoReqItem },
};

static int
dissect_rnsap_GANSS_GenericDataInfoReqList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GANSS_GenericDataInfoReqList, GANSS_GenericDataInfoReqList_sequence_of,
                                                  1, maxNoGANSS);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_8191(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8191U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_86399(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 86399U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GANSS_Reference_Time_sequence[] = {
  { &hf_rnsap_ganssDay      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_8191 },
  { &hf_rnsap_ganssTod      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_86399 },
  { &hf_rnsap_ganssTodUncertainty, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Reference_Time(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Reference_Time, GANSS_Reference_Time_sequence);

  return offset;
}


static const value_string rnsap_T_non_broadcastIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_rnsap_T_non_broadcastIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     5, 5, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_33554431(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 33554431U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_67108863(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 67108863U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_gANSS_keplerianParameters_01_sequence[] = {
  { &hf_rnsap_toe_lsb_nav   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_511 },
  { &hf_rnsap_ganss_omega_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_delta_n_nav   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_m_zero_nav    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_omegadot_nav  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_ganss_e_lsb_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_33554431 },
  { &hf_rnsap_idot_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_14 },
  { &hf_rnsap_a_sqrt_lsb_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_67108863 },
  { &hf_rnsap_i_zero_nav    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_omega_zero_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_c_rs_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_c_is_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_c_us_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_c_rc_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_c_ic_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_c_uc_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_gANSS_keplerianParameters_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_gANSS_keplerianParameters_01, T_gANSS_keplerianParameters_01_sequence);

  return offset;
}


static const value_string rnsap_GANSS_Orbit_Model_vals[] = {
  {   0, "gANSS-keplerianParameters" },
  { 0, NULL }
};

static const per_choice_t GANSS_Orbit_Model_choice[] = {
  {   0, &hf_rnsap_gANSS_keplerianParameters_01, ASN1_EXTENSION_ROOT    , dissect_rnsap_T_gANSS_keplerianParameters_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_GANSS_Orbit_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_GANSS_Orbit_Model, GANSS_Orbit_Model_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GANSS_Sat_Info_Nav_item_sequence[] = {
  { &hf_rnsap_satId         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_63 },
  { &hf_rnsap_svHealth      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_5 },
  { &hf_rnsap_iod           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_10 },
  { &hf_rnsap_ganssClockModel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Clock_Model },
  { &hf_rnsap_ganssOrbitModel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Orbit_Model },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Sat_Info_Nav_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Sat_Info_Nav_item, GANSS_Sat_Info_Nav_item_sequence);

  return offset;
}


static const per_sequence_t GANSS_Sat_Info_Nav_sequence_of[1] = {
  { &hf_rnsap_GANSS_Sat_Info_Nav_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Sat_Info_Nav_item },
};

static int
dissect_rnsap_GANSS_Sat_Info_Nav(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GANSS_Sat_Info_Nav, GANSS_Sat_Info_Nav_sequence_of,
                                                  1, maxGANSSSat);

  return offset;
}


static const per_sequence_t GANSS_Navigation_Model_sequence[] = {
  { &hf_rnsap_ganss_Ref_Time, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Reference_Time },
  { &hf_rnsap_non_broadcastIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_T_non_broadcastIndication },
  { &hf_rnsap_toe_c_msb     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_31 },
  { &hf_rnsap_e_msb         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_sqrtA_msb     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_63 },
  { &hf_rnsap_ganssSatInfoNav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Sat_Info_Nav },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Navigation_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Navigation_Model, GANSS_Navigation_Model_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_M64_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -64, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GANSS_Time_Model_sequence[] = {
  { &hf_rnsap_ganss_time_model, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_65535 },
  { &hf_rnsap_ganss_t_a0    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_M2147483648_2147483647 },
  { &hf_rnsap_ganss_t_a1    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_M8388608_8388607 },
  { &hf_rnsap_ganss_t_a2    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_M64_63 },
  { &hf_rnsap_ganss_to_id   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_7 },
  { &hf_rnsap_ganss_wk_number_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_8191 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Time_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Time_Model, GANSS_Time_Model_sequence);

  return offset;
}


static const per_sequence_t GANSS_UTC_Model_sequence[] = {
  { &hf_rnsap_a_one_utc     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_a_zero_utc    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_t_ot_utc      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_w_n_t_utc     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_delta_t_ls_utc, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_w_n_lsf_utc   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_dn_utc        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_delta_t_lsf_utc, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_UTC_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_UTC_Model, GANSS_UTC_Model_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_4_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, TRUE);

  return offset;
}


static const per_sequence_t GANSS_Real_Time_Integrity_item_sequence[] = {
  { &hf_rnsap_bad_ganss_satId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_63 },
  { &hf_rnsap_bad_ganss_signalId, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_4_ },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Real_Time_Integrity_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Real_Time_Integrity_item, GANSS_Real_Time_Integrity_item_sequence);

  return offset;
}


static const per_sequence_t GANSS_Real_Time_Integrity_sequence_of[1] = {
  { &hf_rnsap_GANSS_Real_Time_Integrity_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Real_Time_Integrity_item },
};

static int
dissect_rnsap_GANSS_Real_Time_Integrity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GANSS_Real_Time_Integrity, GANSS_Real_Time_Integrity_sequence_of,
                                                  1, maxGANSSSat);

  return offset;
}


static const per_sequence_t GANSS_Generic_DataItem_sequence[] = {
  { &hf_rnsap_ganss_Id      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_0_7 },
  { &hf_rnsap_dganss_Correction, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DGANSSCorrections },
  { &hf_rnsap_ganss_Navigation_Model_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_Navigation_Model },
  { &hf_rnsap_ganss_Time_Model_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_Time_Model },
  { &hf_rnsap_ganss_UTC_TIME, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_UTC_Model },
  { &hf_rnsap_ganss_Almanac_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_Almanac },
  { &hf_rnsap_ganss_Real_Time_Integrity_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_Real_Time_Integrity },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Generic_DataItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Generic_DataItem, GANSS_Generic_DataItem_sequence);

  return offset;
}


static const per_sequence_t GANSS_Generic_Data_sequence_of[1] = {
  { &hf_rnsap_GANSS_Generic_Data_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GANSS_Generic_DataItem },
};

static int
dissect_rnsap_GANSS_Generic_Data(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GANSS_Generic_Data, GANSS_Generic_Data_sequence_of,
                                                  1, maxNoGANSS);

  return offset;
}


static const per_sequence_t GANSS_Information_sequence[] = {
  { &hf_rnsap_gANSS_CommonDataInfoReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_CommonDataInfoReq },
  { &hf_rnsap_gANSS_GenericDataInfoReqList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GANSS_GenericDataInfoReqList },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GANSS_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GANSS_Information, GANSS_Information_sequence);

  return offset;
}


static const per_sequence_t GA_AccessPointPosition_sequence[] = {
  { &hf_rnsap_geographicalCoordinate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_AccessPointPosition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_AccessPointPosition, GA_AccessPointPosition_sequence);

  return offset;
}



static int
dissect_rnsap_GERAN_Cell_Capability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_GERAN_Classmark(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_OCTET_STRING_SIZE_1_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 23, FALSE, NULL);

  return offset;
}


static const per_sequence_t GERAN_SystemInfo_item_sequence[] = {
  { &hf_rnsap_gERAN_SI_block, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_OCTET_STRING_SIZE_1_23 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GERAN_SystemInfo_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GERAN_SystemInfo_item, GERAN_SystemInfo_item_sequence);

  return offset;
}


static const per_sequence_t GERAN_SystemInfo_sequence_of[1] = {
  { &hf_rnsap_GERAN_SystemInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GERAN_SystemInfo_item },
};

static int
dissect_rnsap_GERAN_SystemInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GERAN_SystemInfo, GERAN_SystemInfo_sequence_of,
                                                  1, maxNrOfGERANSI);

  return offset;
}


static const value_string rnsap_GERAN_SI_Type_vals[] = {
  {   0, "sI" },
  {   1, "pSI" },
  { 0, NULL }
};

static const per_choice_t GERAN_SI_Type_choice[] = {
  {   0, &hf_rnsap_sI            , ASN1_EXTENSION_ROOT    , dissect_rnsap_GERAN_SystemInfo },
  {   1, &hf_rnsap_pSI           , ASN1_EXTENSION_ROOT    , dissect_rnsap_GERAN_SystemInfo },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_GERAN_SI_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_GERAN_SI_Type, GERAN_SI_Type_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_satellite_Almanac_Information_item_sequence[] = {
  { &hf_rnsap_dATA_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DATA_ID },
  { &hf_rnsap_sAT_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAT_ID },
  { &hf_rnsap_gps_e_alm     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_gps_toa_alm   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_gps_delta_I_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_omegadot_alm  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_svhealth_alm  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_gps_a_sqrt_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_omegazero_alm , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_m_zero_alm    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_gps_omega_alm , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_gps_af_zero_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_gps_af_one_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_satellite_Almanac_Information_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_satellite_Almanac_Information_item, T_satellite_Almanac_Information_item_sequence);

  return offset;
}


static const per_sequence_t T_satellite_Almanac_Information_sequence_of[1] = {
  { &hf_rnsap_satellite_Almanac_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_satellite_Almanac_Information_item },
};

static int
dissect_rnsap_T_satellite_Almanac_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_T_satellite_Almanac_Information, T_satellite_Almanac_Information_sequence_of,
                                                  1, maxNoSat);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_364(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     364, 364, FALSE, NULL);

  return offset;
}


static const per_sequence_t GPS_Almanac_sequence[] = {
  { &hf_rnsap_wna_alm       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_satellite_Almanac_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_satellite_Almanac_Information },
  { &hf_rnsap_sVGlobalHealth_alm, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BIT_STRING_SIZE_364 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GPS_Almanac(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GPS_Almanac, GPS_Almanac_sequence);

  return offset;
}


static const per_sequence_t Satellite_Almanac_Information_ExtItem_item_sequence[] = {
  { &hf_rnsap_dATA_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DATA_ID },
  { &hf_rnsap_sAT_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAT_ID },
  { &hf_rnsap_gps_e_alm     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_gps_toa_alm   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_gps_delta_I_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_omegadot_alm  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_svhealth_alm  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_gps_a_sqrt_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_omegazero_alm , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_m_zero_alm    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_gps_omega_alm , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_gps_af_zero_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_gps_af_one_alm, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_11 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Satellite_Almanac_Information_ExtItem_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Satellite_Almanac_Information_ExtItem_item, Satellite_Almanac_Information_ExtItem_item_sequence);

  return offset;
}


static const per_sequence_t Satellite_Almanac_Information_ExtItem_sequence_of[1] = {
  { &hf_rnsap_Satellite_Almanac_Information_ExtItem_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Satellite_Almanac_Information_ExtItem_item },
};

static int
dissect_rnsap_Satellite_Almanac_Information_ExtItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Satellite_Almanac_Information_ExtItem, Satellite_Almanac_Information_ExtItem_sequence_of,
                                                  1, maxNrOfSatAlmanac_maxNoSat);

  return offset;
}


static const value_string rnsap_T_gPSInformationItem_vals[] = {
  {   0, "gPS-NavigationModel-and-TimeRecovery" },
  {   1, "gPS-Ionospheric-Model" },
  {   2, "gPS-UTC-Model" },
  {   3, "gPS-Almanac" },
  {   4, "gPS-RealTime-Integrity" },
  { 0, NULL }
};


static int
dissect_rnsap_T_gPSInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t GPSInformation_item_sequence[] = {
  { &hf_rnsap_gPSInformationItem, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_gPSInformationItem },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GPSInformation_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GPSInformation_item, GPSInformation_item_sequence);

  return offset;
}


static const per_sequence_t GPSInformation_sequence_of[1] = {
  { &hf_rnsap_GPSInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GPSInformation_item },
};

static int
dissect_rnsap_GPSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GPSInformation, GPSInformation_sequence_of,
                                                  1, maxNoGPSTypes);

  return offset;
}


static const per_sequence_t GPS_Ionospheric_Model_sequence[] = {
  { &hf_rnsap_alpha_zero_ionos_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_alpha_one_ionos_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_alpha_two_ionos_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_alpha_three_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_beta_zero_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_beta_one_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_beta_two_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_beta_three_ionos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GPS_Ionospheric_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GPS_Ionospheric_Model, GPS_Ionospheric_Model_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_1048575(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 22, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 1, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_87(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     87, 87, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, FALSE, NULL);

  return offset;
}


static const per_sequence_t GPS_NavigationModel_and_TimeRecovery_item_sequence[] = {
  { &hf_rnsap_tx_tow_nav    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_1048575 },
  { &hf_rnsap_sAT_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAT_ID },
  { &hf_rnsap_tlm_message_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_14 },
  { &hf_rnsap_tlm_revd_c_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_2 },
  { &hf_rnsap_ho_word_nav   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_22 },
  { &hf_rnsap_w_n_nav       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_10 },
  { &hf_rnsap_ca_or_p_on_l2_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_2 },
  { &hf_rnsap_user_range_accuracy_index_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_4 },
  { &hf_rnsap_sv_health_nav , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_6 },
  { &hf_rnsap_iodc_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_10 },
  { &hf_rnsap_l2_p_dataflag_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_1 },
  { &hf_rnsap_sf1_reserved_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_87 },
  { &hf_rnsap_t_gd_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_t_oc_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_a_f_2_nav     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_a_f_1_nav     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_a_f_zero_nav  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_22 },
  { &hf_rnsap_c_rs_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_delta_n_nav   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_m_zero_nav    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_c_uc_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_gps_e_nav     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_c_us_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_a_sqrt_nav    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_t_oe_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_fit_interval_flag_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_1 },
  { &hf_rnsap_aodo_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_5 },
  { &hf_rnsap_c_ic_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_omega_zero_nav, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_c_is_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_i_zero_nav    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_c_rc_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_16 },
  { &hf_rnsap_gps_omega_nav , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_omegadot_nav  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_idot_nav      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_14 },
  { &hf_rnsap_spare_zero_fill, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_20 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GPS_NavigationModel_and_TimeRecovery_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GPS_NavigationModel_and_TimeRecovery_item, GPS_NavigationModel_and_TimeRecovery_item_sequence);

  return offset;
}


static const per_sequence_t GPS_NavigationModel_and_TimeRecovery_sequence_of[1] = {
  { &hf_rnsap_GPS_NavigationModel_and_TimeRecovery_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GPS_NavigationModel_and_TimeRecovery_item },
};

static int
dissect_rnsap_GPS_NavigationModel_and_TimeRecovery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GPS_NavigationModel_and_TimeRecovery, GPS_NavigationModel_and_TimeRecovery_sequence_of,
                                                  1, maxNoSat);

  return offset;
}


static const value_string rnsap_GPS_RealTime_Integrity_vals[] = {
  {   0, "badSatellites" },
  {   1, "noBadSatellite" },
  { 0, NULL }
};

static const per_choice_t GPS_RealTime_Integrity_choice[] = {
  {   0, &hf_rnsap_badSatellites , ASN1_NO_EXTENSIONS     , dissect_rnsap_BadSatellites },
  {   1, &hf_rnsap_noBadSatellite, ASN1_NO_EXTENSIONS     , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_GPS_RealTime_Integrity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_GPS_RealTime_Integrity, GPS_RealTime_Integrity_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GPS_RX_POS_sequence[] = {
  { &hf_rnsap_geographicalCoordinate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_altitudeAndDirection, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_AltitudeAndDirection },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GPS_RX_POS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GPS_RX_POS, GPS_RX_POS_sequence);

  return offset;
}


static const per_sequence_t GPS_UTC_Model_sequence[] = {
  { &hf_rnsap_a_one_utc     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_24 },
  { &hf_rnsap_a_zero_utc    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_32 },
  { &hf_rnsap_t_ot_utc      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_delta_t_ls_utc, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_w_n_t_utc     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_w_n_lsf_utc   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_dn_utc        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_delta_t_lsf_utc, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BIT_STRING_SIZE_8 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GPS_UTC_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GPS_UTC_Model, GPS_UTC_Model_sequence);

  return offset;
}



static int
dissect_rnsap_Guaranteed_Rate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfTFs, NULL, FALSE);

  return offset;
}


static const per_sequence_t Guaranteed_Rate_Information_sequence[] = {
  { &hf_rnsap_guaranteed_UL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Guaranteed_Rate },
  { &hf_rnsap_guaranteed_DL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Guaranteed_Rate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Guaranteed_Rate_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Guaranteed_Rate_Information, Guaranteed_Rate_Information_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t HARQ_MemoryPartitioning_Implicit_sequence[] = {
  { &hf_rnsap_number_of_Processes, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_8_ },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HARQ_MemoryPartitioning_Implicit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HARQ_MemoryPartitioning_Implicit, HARQ_MemoryPartitioning_Implicit_sequence);

  return offset;
}


static const value_string rnsap_T_process_Memory_Size_vals[] = {
  {   0, "hms800" },
  {   1, "hms1600" },
  {   2, "hms2400" },
  {   3, "hms3200" },
  {   4, "hms4000" },
  {   5, "hms4800" },
  {   6, "hms5600" },
  {   7, "hms6400" },
  {   8, "hms7200" },
  {   9, "hms8000" },
  {  10, "hms8800" },
  {  11, "hms9600" },
  {  12, "hms10400" },
  {  13, "hms11200" },
  {  14, "hms12000" },
  {  15, "hms12800" },
  {  16, "hms13600" },
  {  17, "hms14400" },
  {  18, "hms15200" },
  {  19, "hms16000" },
  {  20, "hms17600" },
  {  21, "hms19200" },
  {  22, "hms20800" },
  {  23, "hms22400" },
  {  24, "hms24000" },
  {  25, "hms25600" },
  {  26, "hms27200" },
  {  27, "hms28800" },
  {  28, "hms30400" },
  {  29, "hms32000" },
  {  30, "hms36000" },
  {  31, "hms40000" },
  {  32, "hms44000" },
  {  33, "hms48000" },
  {  34, "hms52000" },
  {  35, "hms56000" },
  {  36, "hms60000" },
  {  37, "hms64000" },
  {  38, "hms68000" },
  {  39, "hms72000" },
  {  40, "hms76000" },
  {  41, "hms80000" },
  {  42, "hms88000" },
  {  43, "hms96000" },
  {  44, "hms104000" },
  {  45, "hms112000" },
  {  46, "hms120000" },
  {  47, "hms128000" },
  {  48, "hms136000" },
  {  49, "hms144000" },
  {  50, "hms152000" },
  {  51, "hms160000" },
  {  52, "hms176000" },
  {  53, "hms192000" },
  {  54, "hms208000" },
  {  55, "hms224000" },
  {  56, "hms240000" },
  {  57, "hms256000" },
  {  58, "hms272000" },
  {  59, "hms288000" },
  {  60, "hms304000" },
  { 0, NULL }
};


static int
dissect_rnsap_T_process_Memory_Size(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     61, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t HARQ_MemoryPartitioningItem_sequence[] = {
  { &hf_rnsap_process_Memory_Size, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_process_Memory_Size },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HARQ_MemoryPartitioningItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HARQ_MemoryPartitioningItem, HARQ_MemoryPartitioningItem_sequence);

  return offset;
}


static const per_sequence_t HARQ_MemoryPartitioningList_sequence_of[1] = {
  { &hf_rnsap_HARQ_MemoryPartitioningList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HARQ_MemoryPartitioningItem },
};

static int
dissect_rnsap_HARQ_MemoryPartitioningList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HARQ_MemoryPartitioningList, HARQ_MemoryPartitioningList_sequence_of,
                                                  1, maxNrOfHARQProc);

  return offset;
}


static const per_sequence_t HARQ_MemoryPartitioning_Explicit_sequence[] = {
  { &hf_rnsap_hARQ_MemoryPartitioningList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HARQ_MemoryPartitioningList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HARQ_MemoryPartitioning_Explicit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HARQ_MemoryPartitioning_Explicit, HARQ_MemoryPartitioning_Explicit_sequence);

  return offset;
}


static const value_string rnsap_HARQ_MemoryPartitioning_vals[] = {
  {   0, "implicit" },
  {   1, "explicit" },
  { 0, NULL }
};

static const per_choice_t HARQ_MemoryPartitioning_choice[] = {
  {   0, &hf_rnsap_implicit      , ASN1_EXTENSION_ROOT    , dissect_rnsap_HARQ_MemoryPartitioning_Implicit },
  {   1, &hf_rnsap_explicit      , ASN1_EXTENSION_ROOT    , dissect_rnsap_HARQ_MemoryPartitioning_Explicit },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_HARQ_MemoryPartitioning(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_HARQ_MemoryPartitioning, HARQ_MemoryPartitioning_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_HARQ_Preamble_Mode_vals[] = {
  {   0, "mode0" },
  {   1, "mode1" },
  { 0, NULL }
};


static int
dissect_rnsap_HARQ_Preamble_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_HARQ_Preamble_Mode_Activation_Indicator_vals[] = {
  {   0, "harqPreambleModeSupported" },
  { 0, NULL }
};


static int
dissect_rnsap_HARQ_Preamble_Mode_Activation_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_HCS_Prio(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_HSDSCH_MACdFlow_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfMACdFlows_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlow_Specific_InfoItem_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_ID },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_trafficClass  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrafficClass },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem, HSDSCH_MACdFlow_Specific_InfoItem_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlow_Specific_InfoList_sequence_of[1] = {
  { &hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoItem },
};

static int
dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList, HSDSCH_MACdFlow_Specific_InfoList_sequence_of,
                                                  1, maxNrOfMACdFlows);

  return offset;
}



static int
dissect_rnsap_MAChsGuaranteedBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_SID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfPDUIndexes_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t MACdPDU_Size_IndexItem_sequence[] = {
  { &hf_rnsap_sID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SID },
  { &hf_rnsap_mACdPDU_Size  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MACdPDU_Size_IndexItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MACdPDU_Size_IndexItem, MACdPDU_Size_IndexItem_sequence);

  return offset;
}


static const per_sequence_t MACdPDU_Size_IndexList_sequence_of[1] = {
  { &hf_rnsap_MACdPDU_Size_IndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size_IndexItem },
};

static int
dissect_rnsap_MACdPDU_Size_IndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_MACdPDU_Size_IndexList, MACdPDU_Size_IndexList_sequence_of,
                                                  1, maxNrOfPDUIndexes);

  return offset;
}


static const value_string rnsap_RLC_Mode_vals[] = {
  {   0, "rLC-AM" },
  {   1, "rLC-UM" },
  { 0, NULL }
};


static int
dissect_rnsap_RLC_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoItem_sequence[] = {
  { &hf_rnsap_priorityQueue_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_Id },
  { &hf_rnsap_associatedHSDSCH_MACdFlow, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_ID },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_t1            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T1 },
  { &hf_rnsap_discardTimer  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiscardTimer },
  { &hf_rnsap_mAC_hsWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_hsWindowSize },
  { &hf_rnsap_mAChsGuaranteedBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAChsGuaranteedBitRate },
  { &hf_rnsap_mACdPDU_Size_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size_IndexList },
  { &hf_rnsap_rLC_Mode      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RLC_Mode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PriorityQueue_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PriorityQueue_InfoItem, PriorityQueue_InfoItem_sequence);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoList_sequence_of[1] = {
  { &hf_rnsap_PriorityQueue_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_InfoItem },
};

static int
dissect_rnsap_PriorityQueue_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PriorityQueue_InfoList, PriorityQueue_InfoList_sequence_of,
                                                  1, maxNrOfPrioQueues);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlows_Information_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_Specific_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList },
  { &hf_rnsap_priorityQueue_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_InfoList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_MACdFlows_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_MACdFlows_Information, HSDSCH_MACdFlows_Information_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_64_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, TRUE);

  return offset;
}


static const per_sequence_t UE_Capabilities_Info_sequence[] = {
  { &hf_rnsap_hSDSCH_Physical_Layer_Category, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_64_ },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UE_Capabilities_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UE_Capabilities_Info, UE_Capabilities_Info_sequence);

  return offset;
}



static int
dissect_rnsap_MAChsReorderingBufferSize_for_RLC_UM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 300U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_Nack_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_HSSCCH_PowerOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HSDSCH_FDD_Information_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlows_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlows_Information },
  { &hf_rnsap_uE_Capabilities_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_Capabilities_Info },
  { &hf_rnsap_mAChs_Reordering_Buffer_Size_for_RLC_UM, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAChsReorderingBufferSize_for_RLC_UM },
  { &hf_rnsap_cqiFeedback_CycleK, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CQI_Feedback_Cycle },
  { &hf_rnsap_cqiRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_RepetitionFactor },
  { &hf_rnsap_ackNackRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AckNack_RepetitionFactor },
  { &hf_rnsap_cqiPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CQI_Power_Offset },
  { &hf_rnsap_ackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Ack_Power_Offset },
  { &hf_rnsap_nackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Nack_Power_Offset },
  { &hf_rnsap_hsscch_PowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_PowerOffset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_FDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_FDD_Information, HSDSCH_FDD_Information_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlow_Specific_InfoItem_Response_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_hSDSCH_Initial_Capacity_Allocation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_Initial_Capacity_Allocation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_Response, HSDSCH_MACdFlow_Specific_InfoItem_Response_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlow_Specific_InfoList_Response_sequence_of[1] = {
  { &hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_Response },
};

static int
dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response, HSDSCH_MACdFlow_Specific_InfoList_Response_sequence_of,
                                                  0, maxNrOfMACdFlows);

  return offset;
}


static const per_sequence_t HSSCCH_FDD_Specific_InfoItem_Response_sequence[] = {
  { &hf_rnsap_code_Number   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSSCCH_FDD_Specific_InfoItem_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSSCCH_FDD_Specific_InfoItem_Response, HSSCCH_FDD_Specific_InfoItem_Response_sequence);

  return offset;
}


static const per_sequence_t HSSCCH_FDD_Specific_InfoList_Response_sequence_of[1] = {
  { &hf_rnsap_HSSCCH_FDD_Specific_InfoList_Response_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSSCCH_FDD_Specific_InfoItem_Response },
};

static int
dissect_rnsap_HSSCCH_FDD_Specific_InfoList_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSSCCH_FDD_Specific_InfoList_Response, HSSCCH_FDD_Specific_InfoList_Response_sequence_of,
                                                  0, maxNrOfHSSCCHCodes);

  return offset;
}



static int
dissect_rnsap_Measurement_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -12, 26U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HSDSCH_FDD_Information_Response_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response },
  { &hf_rnsap_hSSCCH_Specific_InfoList_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_FDD_Specific_InfoList_Response },
  { &hf_rnsap_hSPDSCH_and_HSSCCH_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_ScramblingCode },
  { &hf_rnsap_measurement_Power_Offset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Measurement_Power_Offset },
  { &hf_rnsap_hARQ_MemoryPartitioning, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_MemoryPartitioning },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_FDD_Information_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_FDD_Information_Response, HSDSCH_FDD_Information_Response_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlow_Specific_InfoItem_to_Modify_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_ID },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_trafficClass  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TrafficClass },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_to_Modify, HSDSCH_MACdFlow_Specific_InfoItem_to_Modify_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlow_Specific_InfoList_to_Modify_sequence_of[1] = {
  { &hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_to_Modify },
};

static int
dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify, HSDSCH_MACdFlow_Specific_InfoList_to_Modify_sequence_of,
                                                  1, maxNrOfMACdFlows);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoItem_to_Add_sequence[] = {
  { &hf_rnsap_priorityQueue_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_Id },
  { &hf_rnsap_associatedHSDSCH_MACdFlow, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_ID },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_t1            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T1 },
  { &hf_rnsap_discardTimer  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiscardTimer },
  { &hf_rnsap_mAC_hsWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_hsWindowSize },
  { &hf_rnsap_mAChsGuaranteedBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAChsGuaranteedBitRate },
  { &hf_rnsap_mACdPDU_Size_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size_IndexList },
  { &hf_rnsap_rLC_Mode      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RLC_Mode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PriorityQueue_InfoItem_to_Add(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PriorityQueue_InfoItem_to_Add, PriorityQueue_InfoItem_to_Add_sequence);

  return offset;
}


static const per_sequence_t MACdPDU_Size_IndexItem_to_Modify_sequence[] = {
  { &hf_rnsap_sID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SID },
  { &hf_rnsap_mACdPDU_Size  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MACdPDU_Size_IndexItem_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MACdPDU_Size_IndexItem_to_Modify, MACdPDU_Size_IndexItem_to_Modify_sequence);

  return offset;
}


static const per_sequence_t MACdPDU_Size_IndexList_to_Modify_sequence_of[1] = {
  { &hf_rnsap_MACdPDU_Size_IndexList_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MACdPDU_Size_IndexItem_to_Modify },
};

static int
dissect_rnsap_MACdPDU_Size_IndexList_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_MACdPDU_Size_IndexList_to_Modify, MACdPDU_Size_IndexList_to_Modify_sequence_of,
                                                  1, maxNrOfPDUIndexes);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoItem_to_Modify_sequence[] = {
  { &hf_rnsap_priorityQueue_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_Id },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_t1            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_T1 },
  { &hf_rnsap_discardTimer  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiscardTimer },
  { &hf_rnsap_mAC_hsWindowSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAC_hsWindowSize },
  { &hf_rnsap_mAChsGuaranteedBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAChsGuaranteedBitRate },
  { &hf_rnsap_mACdPDU_Size_Index_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MACdPDU_Size_IndexList_to_Modify },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PriorityQueue_InfoItem_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PriorityQueue_InfoItem_to_Modify, PriorityQueue_InfoItem_to_Modify_sequence);

  return offset;
}


static const value_string rnsap_ModifyPriorityQueue_vals[] = {
  {   0, "addPriorityQueue" },
  {   1, "modifyPriorityQueue" },
  {   2, "deletePriorityQueue" },
  { 0, NULL }
};

static const per_choice_t ModifyPriorityQueue_choice[] = {
  {   0, &hf_rnsap_addPriorityQueue, ASN1_EXTENSION_ROOT    , dissect_rnsap_PriorityQueue_InfoItem_to_Add },
  {   1, &hf_rnsap_modifyPriorityQueue, ASN1_EXTENSION_ROOT    , dissect_rnsap_PriorityQueue_InfoItem_to_Modify },
  {   2, &hf_rnsap_deletePriorityQueue, ASN1_EXTENSION_ROOT    , dissect_rnsap_PriorityQueue_Id },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_ModifyPriorityQueue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_ModifyPriorityQueue, ModifyPriorityQueue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoList_to_Modify_sequence_of[1] = {
  { &hf_rnsap_PriorityQueue_InfoList_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ModifyPriorityQueue },
};

static int
dissect_rnsap_PriorityQueue_InfoList_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PriorityQueue_InfoList_to_Modify, PriorityQueue_InfoList_to_Modify_sequence_of,
                                                  1, maxNrOfPrioQueues);

  return offset;
}


static const value_string rnsap_HSSCCH_Code_Change_Grant_vals[] = {
  {   0, "changeGranted" },
  { 0, NULL }
};


static int
dissect_rnsap_HSSCCH_Code_Change_Grant(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_TDD_AckNack_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -7, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t HSDSCH_Information_to_Modify_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify },
  { &hf_rnsap_priorityQueue_Info_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PriorityQueue_InfoList_to_Modify },
  { &hf_rnsap_mAChs_Reordering_Buffer_Size_for_RLC_UM, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAChsReorderingBufferSize_for_RLC_UM },
  { &hf_rnsap_cqiFeedback_CycleK, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_Feedback_Cycle },
  { &hf_rnsap_cqiRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_RepetitionFactor },
  { &hf_rnsap_ackNackRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AckNack_RepetitionFactor },
  { &hf_rnsap_cqiPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_Power_Offset },
  { &hf_rnsap_ackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Ack_Power_Offset },
  { &hf_rnsap_nackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Nack_Power_Offset },
  { &hf_rnsap_hsscch_PowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_PowerOffset },
  { &hf_rnsap_hSSCCH_CodeChangeGrant, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_Code_Change_Grant },
  { &hf_rnsap_tDDAckNackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_AckNack_Power_Offset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_Information_to_Modify, HSDSCH_Information_to_Modify_sequence);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoItem_to_Modify_Unsynchronised_sequence[] = {
  { &hf_rnsap_priorityQueueId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_Id },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_discardTimer  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiscardTimer },
  { &hf_rnsap_mAChsGuaranteedBitRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MAChsGuaranteedBitRate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PriorityQueue_InfoItem_to_Modify_Unsynchronised(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PriorityQueue_InfoItem_to_Modify_Unsynchronised, PriorityQueue_InfoItem_to_Modify_Unsynchronised_sequence);

  return offset;
}


static const per_sequence_t PriorityQueue_InfoList_to_Modify_Unsynchronised_sequence_of[1] = {
  { &hf_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityQueue_InfoItem_to_Modify_Unsynchronised },
};

static int
dissect_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised, PriorityQueue_InfoList_to_Modify_Unsynchronised_sequence_of,
                                                  0, maxNrOfPrioQueues);

  return offset;
}


static const per_sequence_t HSDSCH_Information_to_Modify_Unsynchronised_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify },
  { &hf_rnsap_priorityQueueInfotoModifyUnsynchronised, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised },
  { &hf_rnsap_cqiPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_Power_Offset },
  { &hf_rnsap_ackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Ack_Power_Offset },
  { &hf_rnsap_nackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Nack_Power_Offset },
  { &hf_rnsap_hsscch_PowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_PowerOffset },
  { &hf_rnsap_tDDAckNackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_AckNack_Power_Offset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_Information_to_Modify_Unsynchronised(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_Information_to_Modify_Unsynchronised, HSDSCH_Information_to_Modify_Unsynchronised_sequence);

  return offset;
}


static const value_string rnsap_HSDSCH_MACdPDUSizeFormat_vals[] = {
  {   0, "indexedMACdPDU-Size" },
  {   1, "flexibleMACdPDU-Size" },
  { 0, NULL }
};


static int
dissect_rnsap_HSDSCH_MACdPDUSizeFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlows_to_Delete_Item_sequence[] = {
  { &hf_rnsap_hsDSCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlow_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_MACdFlows_to_Delete_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_MACdFlows_to_Delete_Item, HSDSCH_MACdFlows_to_Delete_Item_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_MACdFlows_to_Delete_sequence_of[1] = {
  { &hf_rnsap_HSDSCH_MACdFlows_to_Delete_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlows_to_Delete_Item },
};

static int
dissect_rnsap_HSDSCH_MACdFlows_to_Delete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSDSCH_MACdFlows_to_Delete, HSDSCH_MACdFlows_to_Delete_sequence_of,
                                                  1, maxNrOfMACdFlows);

  return offset;
}



static int
dissect_rnsap_HSDSCH_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HS_DSCH_serving_cell_change_information_sequence[] = {
  { &hf_rnsap_hS_PDSCH_RLID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_hSDSCH_FDD_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_FDD_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HS_DSCH_serving_cell_change_information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HS_DSCH_serving_cell_change_information, HS_DSCH_serving_cell_change_information_sequence);

  return offset;
}


static const per_sequence_t HS_serving_cell_change_successful_sequence[] = {
  { &hf_rnsap_hSDSCH_FDD_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_FDD_Information_Response },
  { &hf_rnsap_hSDSCH_RNTI   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_RNTI },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HS_serving_cell_change_successful(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HS_serving_cell_change_successful, HS_serving_cell_change_successful_sequence);

  return offset;
}


static const per_sequence_t HS_serving_cell_change_unsuccessful_sequence[] = {
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HS_serving_cell_change_unsuccessful(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HS_serving_cell_change_unsuccessful, HS_serving_cell_change_unsuccessful_sequence);

  return offset;
}


static const value_string rnsap_HS_DSCH_serving_cell_change_choice_vals[] = {
  {   0, "hS-serving-cell-change-successful" },
  {   1, "hS-serving-cell-change-unsuccessful" },
  { 0, NULL }
};

static const per_choice_t HS_DSCH_serving_cell_change_choice_choice[] = {
  {   0, &hf_rnsap_hS_serving_cell_change_successful, ASN1_EXTENSION_ROOT    , dissect_rnsap_HS_serving_cell_change_successful },
  {   1, &hf_rnsap_hS_serving_cell_change_unsuccessful, ASN1_EXTENSION_ROOT    , dissect_rnsap_HS_serving_cell_change_unsuccessful },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_HS_DSCH_serving_cell_change_choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_HS_DSCH_serving_cell_change_choice, HS_DSCH_serving_cell_change_choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HS_DSCH_serving_cell_change_informationResponse_sequence[] = {
  { &hf_rnsap_hS_DSCH_serving_cell_choice, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HS_DSCH_serving_cell_change_choice },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HS_DSCH_serving_cell_change_informationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HS_DSCH_serving_cell_change_informationResponse, HS_DSCH_serving_cell_change_informationResponse_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_TDD_Information_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlows_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSDSCH_MACdFlows_Information },
  { &hf_rnsap_uE_Capabilities_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UE_Capabilities_Info },
  { &hf_rnsap_mAChs_Reordering_Buffer_Size_for_RLC_UM, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAChsReorderingBufferSize_for_RLC_UM },
  { &hf_rnsap_tDD_AckNack_Power_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_AckNack_Power_Offset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_TDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_TDD_Information, HSDSCH_TDD_Information_sequence);

  return offset;
}



static int
dissect_rnsap_HS_SICH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HSSICH_Info_sequence[] = {
  { &hf_rnsap_hsSICH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HS_SICH_ID },
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSSICH_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSSICH_Info, HSSICH_Info_sequence);

  return offset;
}


static const per_sequence_t HSSCCH_TDD_Specific_InfoItem_Response_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_hSSICH_Info   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSSICH_Info },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSSCCH_TDD_Specific_InfoItem_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response, HSSCCH_TDD_Specific_InfoItem_Response_sequence);

  return offset;
}


static const per_sequence_t HSSCCH_TDD_Specific_InfoList_Response_sequence_of[1] = {
  { &hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSSCCH_TDD_Specific_InfoItem_Response },
};

static int
dissect_rnsap_HSSCCH_TDD_Specific_InfoList_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response, HSSCCH_TDD_Specific_InfoList_Response_sequence_of,
                                                  0, maxNrOfHSSCCHCodes);

  return offset;
}


static const per_sequence_t HSSICH_InfoLCR_sequence[] = {
  { &hf_rnsap_hsSICH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HS_SICH_ID },
  { &hf_rnsap_timeslotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSSICH_InfoLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSSICH_InfoLCR, HSSICH_InfoLCR_sequence);

  return offset;
}


static const per_sequence_t HSSCCH_TDD_Specific_InfoItem_Response_LCR_sequence[] = {
  { &hf_rnsap_timeslotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_first_TDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_second_TDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_hSSICH_InfoLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSSICH_InfoLCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSSCCH_TDD_Specific_InfoItem_Response_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response_LCR, HSSCCH_TDD_Specific_InfoItem_Response_LCR_sequence);

  return offset;
}


static const per_sequence_t HSSCCH_TDD_Specific_InfoList_Response_LCR_sequence_of[1] = {
  { &hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSSCCH_TDD_Specific_InfoItem_Response_LCR },
};

static int
dissect_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR, HSSCCH_TDD_Specific_InfoList_Response_LCR_sequence_of,
                                                  0, maxNrOfHSSCCHCodes);

  return offset;
}


static const per_sequence_t HSPDSCH_TDD_Specific_InfoItem_Response_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response, HSPDSCH_TDD_Specific_InfoItem_Response_sequence);

  return offset;
}


static const per_sequence_t HSPDSCH_TDD_Specific_InfoList_Response_sequence_of[1] = {
  { &hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response },
};

static int
dissect_rnsap_HSPDSCH_TDD_Specific_InfoList_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response, HSPDSCH_TDD_Specific_InfoList_Response_sequence_of,
                                                  0, maxNrOfDLTs);

  return offset;
}


static const per_sequence_t HSPDSCH_TDD_Specific_InfoItem_Response_LCR_sequence[] = {
  { &hf_rnsap_timeslotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response_LCR, HSPDSCH_TDD_Specific_InfoItem_Response_LCR_sequence);

  return offset;
}


static const per_sequence_t HSPDSCH_TDD_Specific_InfoList_Response_LCR_sequence_of[1] = {
  { &hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response_LCR },
};

static int
dissect_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR, HSPDSCH_TDD_Specific_InfoList_Response_LCR_sequence_of,
                                                  1, maxNrOfDLTsLCR);

  return offset;
}


static const per_sequence_t HSDSCH_TDD_Information_Response_sequence[] = {
  { &hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response },
  { &hf_rnsap_hSSCCH_TDD_Specific_InfoList_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_TDD_Specific_InfoList_Response },
  { &hf_rnsap_hSSCCH_TDD_Specific_InfoList_Response_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR },
  { &hf_rnsap_hSPDSCH_TDD_Specific_InfoList_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSPDSCH_TDD_Specific_InfoList_Response },
  { &hf_rnsap_hSPDSCH_TDD_Specific_InfoList_Response_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR },
  { &hf_rnsap_hARQ_MemoryPartitioning, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HARQ_MemoryPartitioning },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_TDD_Information_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_TDD_Information_Response, HSDSCH_TDD_Information_Response_sequence);

  return offset;
}


static const per_sequence_t HSPDSCH_TDD_Specific_InfoItem_Response768_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response768, HSPDSCH_TDD_Specific_InfoItem_Response768_sequence);

  return offset;
}


static const per_sequence_t HSPDSCH_TDD_Specific_InfoList_Response768_sequence_of[1] = {
  { &hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response768_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response768 },
};

static int
dissect_rnsap_HSPDSCH_TDD_Specific_InfoList_Response768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response768, HSPDSCH_TDD_Specific_InfoList_Response768_sequence_of,
                                                  0, maxNrOfDLTs);

  return offset;
}


static const per_sequence_t HSSICH_Info768_sequence[] = {
  { &hf_rnsap_hsSICH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HS_SICH_ID },
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_tDD_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSSICH_Info768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSSICH_Info768, HSSICH_Info768_sequence);

  return offset;
}


static const per_sequence_t HSSCCH_TDD_Specific_InfoItem_Response768_sequence[] = {
  { &hf_rnsap_timeslot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_tDD_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_hSSICH_Info768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HSSICH_Info768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSSCCH_TDD_Specific_InfoItem_Response768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response768, HSSCCH_TDD_Specific_InfoItem_Response768_sequence);

  return offset;
}


static const per_sequence_t HSSCCH_TDD_Specific_InfoList_Response768_sequence_of[1] = {
  { &hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response768_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_HSSCCH_TDD_Specific_InfoItem_Response768 },
};

static int
dissect_rnsap_HSSCCH_TDD_Specific_InfoList_Response768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response768, HSSCCH_TDD_Specific_InfoList_Response768_sequence_of,
                                                  0, maxNrOfHSSCCHCodes);

  return offset;
}



static int
dissect_rnsap_HS_SICH_failed(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 20U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_HS_SICH_missed(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 20U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_HS_SICH_total(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 20U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HS_SICH_Reception_Quality_Value_sequence[] = {
  { &hf_rnsap_failed_HS_SICH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HS_SICH_failed },
  { &hf_rnsap_missed_HS_SICH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HS_SICH_missed },
  { &hf_rnsap_total_HS_SICH , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_HS_SICH_total },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HS_SICH_Reception_Quality_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HS_SICH_Reception_Quality_Value, HS_SICH_Reception_Quality_Value_sequence);

  return offset;
}



static int
dissect_rnsap_HS_SICH_Reception_Quality_Measurement_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 20U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_HSSCCH_CodeChangeIndicator_vals[] = {
  {   0, "hsSCCHCodeChangeNeeded" },
  { 0, NULL }
};


static int
dissect_rnsap_HSSCCH_CodeChangeIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_HS_PDSCH_Code_Change_Indicator_vals[] = {
  {   0, "hsPDSCHCodeChangeNeeded" },
  { 0, NULL }
};


static int
dissect_rnsap_HS_PDSCH_Code_Change_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_HS_PDSCH_Code_Change_Grant_vals[] = {
  {   0, "changeGranted" },
  { 0, NULL }
};


static int
dissect_rnsap_HS_PDSCH_Code_Change_Grant(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t HSDSCH_FDD_Update_Information_sequence[] = {
  { &hf_rnsap_hsSCCHCodeChangeIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_CodeChangeIndicator },
  { &hf_rnsap_cqiFeedback_CycleK, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_Feedback_Cycle },
  { &hf_rnsap_cqiRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_RepetitionFactor },
  { &hf_rnsap_ackNackRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AckNack_RepetitionFactor },
  { &hf_rnsap_cqiPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CQI_Power_Offset },
  { &hf_rnsap_ackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Ack_Power_Offset },
  { &hf_rnsap_nackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Nack_Power_Offset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_FDD_Update_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_FDD_Update_Information, HSDSCH_FDD_Update_Information_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_TDD_Update_Information_sequence[] = {
  { &hf_rnsap_hsSCCHCodeChangeIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_HSSCCH_CodeChangeIndicator },
  { &hf_rnsap_tDDAckNackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_AckNack_Power_Offset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_HSDSCH_TDD_Update_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_HSDSCH_TDD_Update_Information, HSDSCH_TDD_Update_Information_sequence);

  return offset;
}



static int
dissect_rnsap_IMEI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_IMEISV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_IMSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 8, FALSE, NULL);

  return offset;
}


static const per_sequence_t GA_AccessPointPositionwithOptionalAltitude_sequence[] = {
  { &hf_rnsap_geographicalCoordinate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_altitudeAndDirection, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AltitudeAndDirection },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_AccessPointPositionwithOptionalAltitude(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_AccessPointPositionwithOptionalAltitude, GA_AccessPointPositionwithOptionalAltitude_sequence);

  return offset;
}


static const value_string rnsap_IPSpacingFDD_vals[] = {
  {   0, "ipsF5" },
  {   1, "ipsF7" },
  {   2, "ipsF10" },
  {   3, "ipsF15" },
  {   4, "ipsF20" },
  {   5, "ipsF30" },
  {   6, "ipsF40" },
  {   7, "ipsF50" },
  { 0, NULL }
};


static int
dissect_rnsap_IPSpacingFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_IPLength_vals[] = {
  {   0, "ipl5" },
  {   1, "ipl10" },
  { 0, NULL }
};


static int
dissect_rnsap_IPLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_IPOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Seed(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t IPDL_FDD_Parameters_sequence[] = {
  { &hf_rnsap_iPSpacingFDD  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPSpacingFDD },
  { &hf_rnsap_iPLength      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPLength },
  { &hf_rnsap_iPOffset      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPOffset },
  { &hf_rnsap_seed          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Seed },
  { &hf_rnsap_burstModeParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BurstModeParameters },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_IPDL_FDD_Parameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_IPDL_FDD_Parameters, IPDL_FDD_Parameters_sequence);

  return offset;
}


static const value_string rnsap_IPSpacingTDD_vals[] = {
  {   0, "ipsT30" },
  {   1, "ipsT40" },
  {   2, "ipsT50" },
  {   3, "ipsT70" },
  {   4, "ipsT100" },
  { 0, NULL }
};


static int
dissect_rnsap_IPSpacingTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_IPStart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_IPSlot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_IP_P_CCPCH_vals[] = {
  {   0, "switchOff-1-Frame" },
  {   1, "switchOff-2-Frames" },
  { 0, NULL }
};


static int
dissect_rnsap_IP_P_CCPCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t IPDL_TDD_Parameters_sequence[] = {
  { &hf_rnsap_iPSpacingTDD  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPSpacingTDD },
  { &hf_rnsap_iPStart       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPStart },
  { &hf_rnsap_iPSlot        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPSlot },
  { &hf_rnsap_iP_P_CCPCH    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IP_P_CCPCH },
  { &hf_rnsap_burstModeParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BurstModeParameters },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_IPDL_TDD_Parameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_IPDL_TDD_Parameters, IPDL_TDD_Parameters_sequence);

  return offset;
}



static int
dissect_rnsap_Extension_IPDLParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_IPDLParameters_vals[] = {
  {   0, "iPDL-FDD-Parameters" },
  {   1, "iPDL-TDD-Parameters" },
  {   2, "extension-IPDLParameters" },
  { 0, NULL }
};

static const per_choice_t IPDLParameters_choice[] = {
  {   0, &hf_rnsap_iPDL_FDD_Parameters, ASN1_EXTENSION_ROOT    , dissect_rnsap_IPDL_FDD_Parameters },
  {   1, &hf_rnsap_iPDL_TDD_Parameters, ASN1_EXTENSION_ROOT    , dissect_rnsap_IPDL_TDD_Parameters },
  {   2, &hf_rnsap_extension_IPDLParameters, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_IPDLParameters },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_IPDLParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_IPDLParameters, IPDLParameters_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RequestedDataValue_sequence[] = {
  { &hf_rnsap_gA_AccessPointPositionwithAltitude, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPositionwithOptionalAltitude },
  { &hf_rnsap_iPDLParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_IPDLParameters },
  { &hf_rnsap_dGPSCorrections, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DGPSCorrections },
  { &hf_rnsap_gPS_NavigationModel_and_TimeRecovery, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GPS_NavigationModel_and_TimeRecovery },
  { &hf_rnsap_gPS_Ionospheric_Model, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GPS_Ionospheric_Model },
  { &hf_rnsap_gPS_UTC_Model , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GPS_UTC_Model },
  { &hf_rnsap_gPS_Almanac   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GPS_Almanac },
  { &hf_rnsap_gPS_RealTime_Integrity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GPS_RealTime_Integrity },
  { &hf_rnsap_gPS_RX_POS    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GPS_RX_POS },
  { &hf_rnsap_sFNSFN_GA_AccessPointPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPositionwithOptionalAltitude },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RequestedDataValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RequestedDataValue, RequestedDataValue_sequence);

  return offset;
}


static const per_sequence_t InformationAvailable_sequence[] = {
  { &hf_rnsap_requestedDataValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RequestedDataValue },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationAvailable, InformationAvailable_sequence);

  return offset;
}



static int
dissect_rnsap_InformationExchangeID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_InformationNotAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_24_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 24U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_InformationReportPeriodicity_vals[] = {
  {   0, "min" },
  {   1, "hour" },
  { 0, NULL }
};

static const per_choice_t InformationReportPeriodicity_choice[] = {
  {   0, &hf_rnsap_min           , ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_1_60_ },
  {   1, &hf_rnsap_hour          , ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_1_24_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_InformationReportPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_InformationReportPeriodicity, InformationReportPeriodicity_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PeriodicInformation_sequence[] = {
  { &hf_rnsap_informationReportPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_InformationReportPeriodicity },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PeriodicInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PeriodicInformation, PeriodicInformation_sequence);

  return offset;
}


static const value_string rnsap_InformationThreshold_vals[] = {
  {   0, "dGPSThreshold" },
  {   1, "dGANSSThreshold" },
  { 0, NULL }
};

static const per_choice_t InformationThreshold_choice[] = {
  {   0, &hf_rnsap_dGPSThreshold , ASN1_EXTENSION_ROOT    , dissect_rnsap_DGPSThreshold },
  {   1, &hf_rnsap_dGANSSThreshold, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_DGANSSThreshold },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_InformationThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_InformationThreshold, InformationThreshold_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t OnModificationInformation_sequence[] = {
  { &hf_rnsap_informationThreshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_InformationThreshold },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_OnModificationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_OnModificationInformation, OnModificationInformation_sequence);

  return offset;
}


static const value_string rnsap_InformationReportCharacteristics_vals[] = {
  {   0, "onDemand" },
  {   1, "periodic" },
  {   2, "onModification" },
  { 0, NULL }
};

static const per_choice_t InformationReportCharacteristics_choice[] = {
  {   0, &hf_rnsap_onDemand      , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_periodic      , ASN1_EXTENSION_ROOT    , dissect_rnsap_PeriodicInformation },
  {   2, &hf_rnsap_onModification, ASN1_EXTENSION_ROOT    , dissect_rnsap_OnModificationInformation },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_InformationReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_InformationReportCharacteristics, InformationReportCharacteristics_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_T_informationTypeItem_vals[] = {
  {   0, "gA-AccessPointPositionwithAltitude" },
  {   1, "gA-AccessPointPosition" },
  {   2, "iPDLParameters" },
  {   3, "gPSInformation" },
  {   4, "dGPSCorrections" },
  {   5, "gPS-RX-POS" },
  {   6, "sFNSFN-GA-AccessPointPosition" },
  {   7, "cell-Capacity-Class" },
  {   8, "nACC-Related-Data" },
  {   9, "mBMSBearerServiceFullAddress" },
  {  10, "interFrequencyCellInformation" },
  {  11, "gANSSInformation" },
  {  12, "dGANSSCorrections" },
  {  13, "gANSS-RX-Pos" },
  { 0, NULL }
};


static int
dissect_rnsap_T_informationTypeItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 7, NULL);

  return offset;
}


static const per_sequence_t InformationType_sequence[] = {
  { &hf_rnsap_informationTypeItem, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_informationTypeItem },
  { &hf_rnsap_gPSInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GPSInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationType, InformationType_sequence);

  return offset;
}


static const value_string rnsap_Initial_DL_DPCH_TimingAdjustment_Allowed_vals[] = {
  {   0, "initial-DL-DPCH-TimingAdjustment-Allowed" },
  { 0, NULL }
};


static int
dissect_rnsap_Initial_DL_DPCH_TimingAdjustment_Allowed(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_InnerLoopDLPCStatus_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_rnsap_InnerLoopDLPCStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_PrimaryScramblingCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cell_sequence[] = {
  { &hf_rnsap_dL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_uL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_primaryScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryScramblingCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Inter_Frequency_Cell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Inter_Frequency_Cell, Inter_Frequency_Cell_sequence);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cell_List_sequence_of[1] = {
  { &hf_rnsap_Inter_Frequency_Cell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell },
};

static int
dissect_rnsap_Inter_Frequency_Cell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Inter_Frequency_Cell_List, Inter_Frequency_Cell_List_sequence_of,
                                                  0, maxCellsMeas);

  return offset;
}



static int
dissect_rnsap_Inter_Frequency_Cell_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_InterFrequencyCellID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cell_SIB11_or_SIB12_sequence[] = {
  { &hf_rnsap_interFrequencyCellID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_InterFrequencyCellID },
  { &hf_rnsap_dL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_uL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_primaryScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryScramblingCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12, Inter_Frequency_Cell_SIB11_or_SIB12_sequence);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cell_SIB11_or_SIB12_List_sequence_of[1] = {
  { &hf_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12 },
};

static int
dissect_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12_List, Inter_Frequency_Cell_SIB11_or_SIB12_List_sequence_of,
                                                  0, maxCellSIB11OrSIB12);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cells_Information_SIB11_Per_Indication_sequence[] = {
  { &hf_rnsap_inter_Frequency_Cell_Indication_SIB11, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell_Indication },
  { &hf_rnsap_inter_Frequency_Cell_List_SIB11, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12_List },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Inter_Frequency_Cells_Information_SIB11_Per_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Inter_Frequency_Cells_Information_SIB11_Per_Indication, Inter_Frequency_Cells_Information_SIB11_Per_Indication_sequence);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cell_Information_SIB11_sequence_of[1] = {
  { &hf_rnsap_Inter_Frequency_Cell_Information_SIB11_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cells_Information_SIB11_Per_Indication },
};

static int
dissect_rnsap_Inter_Frequency_Cell_Information_SIB11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Inter_Frequency_Cell_Information_SIB11, Inter_Frequency_Cell_Information_SIB11_sequence_of,
                                                  0, 2);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cells_Information_SIB12_Per_Indication_sequence[] = {
  { &hf_rnsap_inter_Frequency_Cell_Indication_SIB12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell_Indication },
  { &hf_rnsap_inter_Frequency_Cell_List_SIB12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell_SIB11_or_SIB12_List },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Inter_Frequency_Cells_Information_SIB12_Per_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Inter_Frequency_Cells_Information_SIB12_Per_Indication, Inter_Frequency_Cells_Information_SIB12_Per_Indication_sequence);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cell_Information_SIB12_sequence_of[1] = {
  { &hf_rnsap_Inter_Frequency_Cell_Information_SIB12_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cells_Information_SIB12_Per_Indication },
};

static int
dissect_rnsap_Inter_Frequency_Cell_Information_SIB12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Inter_Frequency_Cell_Information_SIB12, Inter_Frequency_Cell_Information_SIB12_sequence_of,
                                                  0, 2);

  return offset;
}


static const per_sequence_t Inter_Frequency_Cell_Information_sequence[] = {
  { &hf_rnsap_inter_Frequency_Cell_Information_SIB11, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell_Information_SIB11 },
  { &hf_rnsap_inter_Frequency_Cell_Information_SIB12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Inter_Frequency_Cell_Information_SIB12 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Inter_Frequency_Cell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Inter_Frequency_Cell_Information, Inter_Frequency_Cell_Information_sequence);

  return offset;
}


static const value_string rnsap_IPSub_vals[] = {
  {   0, "first" },
  {   1, "second" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_rnsap_IPSub(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t IPDL_TDD_ParametersLCR_sequence[] = {
  { &hf_rnsap_iPSpacingTDD  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPSpacingTDD },
  { &hf_rnsap_iPStart       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPStart },
  { &hf_rnsap_iPSub         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPSub },
  { &hf_rnsap_burstModeParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BurstModeParameters },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_IPDL_TDD_ParametersLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_IPDL_TDD_ParametersLCR, IPDL_TDD_ParametersLCR_sequence);

  return offset;
}



static int
dissect_rnsap_IPMulticastAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 16, FALSE, NULL);

  return offset;
}


static const value_string rnsap_LimitedPowerIncrease_vals[] = {
  {   0, "used" },
  {   1, "not-used" },
  { 0, NULL }
};


static int
dissect_rnsap_LimitedPowerIncrease(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_L3_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 92 "rnsap.cnf"
	tvbuff_t *parameter_tvb;
	dissector_handle_t parameter_handle = NULL;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);


	if (!parameter_tvb)
		return offset;

	switch (ProcedureCode) {

	case RNSAP_ID_DOWNLINKSIGNALLINGTRANSFER:
		parameter_handle = rrc_dl_dcch_handle;
		break;
	case RNSAP_ID_UPLINKSIGNALLINGTRANSFER:
	default:
		break;
	}

    if (parameter_handle)
      call_dissector(parameter_handle, parameter_tvb, actx->pinfo, tree);



  return offset;
}



static int
dissect_rnsap_Load_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Load_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaxNrOfUL_DPCHs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 6U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaximumAllowedULTxPower(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -50, 33U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaxNrDLPhysicalchannels(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 224U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaxNrDLPhysicalchannels768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 448U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaxNrDLPhysicalchannelsTS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaxNrDLPhysicalchannelsTS768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaxNrTimeslots(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 14U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MaxNrULPhysicalchannels(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 2U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_Max_UE_DTX_Cycle_vals[] = {
  {   0, "v5" },
  {   1, "v10" },
  {   2, "v20" },
  {   3, "v40" },
  {   4, "v64" },
  {   5, "v80" },
  {   6, "v128" },
  {   7, "v160" },
  { 0, NULL }
};


static int
dissect_rnsap_Max_UE_DTX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MBMS_Bearer_Service_Full_Address_sequence[] = {
  { &hf_rnsap_accessPointName, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AccessPointName },
  { &hf_rnsap_iPMulticastAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_IPMulticastAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMS_Bearer_Service_Full_Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMS_Bearer_Service_Full_Address, MBMS_Bearer_Service_Full_Address_sequence);

  return offset;
}


static const per_sequence_t MBMS_Bearer_Service_List_sequence_of[1] = {
  { &hf_rnsap_MBMS_Bearer_Service_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TMGI },
};

static int
dissect_rnsap_MBMS_Bearer_Service_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_MBMS_Bearer_Service_List, MBMS_Bearer_Service_List_sequence_of,
                                                  1, maxNrOfMBMSServices);

  return offset;
}


static const per_sequence_t MBMSChannelTypeCellList_sequence[] = {
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_affectedUEInformationForMBMS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AffectedUEInformationForMBMS },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMSChannelTypeCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMSChannelTypeCellList, MBMSChannelTypeCellList_sequence);

  return offset;
}


static const per_sequence_t PTMCellList_sequence_of[1] = {
  { &hf_rnsap_PTMCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MBMSChannelTypeCellList },
};

static int
dissect_rnsap_PTMCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PTMCellList, PTMCellList_sequence_of,
                                                  1, maxNrOfCells);

  return offset;
}


static const per_sequence_t PTPCellList_sequence_of[1] = {
  { &hf_rnsap_PTPCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MBMSChannelTypeCellList },
};

static int
dissect_rnsap_PTPCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PTPCellList, PTPCellList_sequence_of,
                                                  1, maxNrOfCells);

  return offset;
}


static const per_sequence_t NotProvidedCellList_sequence_of[1] = {
  { &hf_rnsap_NotProvidedCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MBMSChannelTypeCellList },
};

static int
dissect_rnsap_NotProvidedCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_NotProvidedCellList, NotProvidedCellList_sequence_of,
                                                  1, maxNrOfCells);

  return offset;
}


static const per_sequence_t MBMSChannelTypeInfo_sequence[] = {
  { &hf_rnsap_tMGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TMGI },
  { &hf_rnsap_pTM_Cell_List , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PTMCellList },
  { &hf_rnsap_pTP_Cell_List , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PTPCellList },
  { &hf_rnsap_not_Provided_Cell_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NotProvidedCellList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMSChannelTypeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMSChannelTypeInfo, MBMSChannelTypeInfo_sequence);

  return offset;
}


static const per_sequence_t PreferredFrequencyLayerInfo_sequence[] = {
  { &hf_rnsap_defaultPreferredFrequency, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_additionalPreferredFrequency, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AdditionalPreferredFrequency },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PreferredFrequencyLayerInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PreferredFrequencyLayerInfo, PreferredFrequencyLayerInfo_sequence);

  return offset;
}


static const per_sequence_t MBMSPreferredFreqLayerInfo_sequence[] = {
  { &hf_rnsap_tMGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TMGI },
  { &hf_rnsap_preferredFrequencyLayerInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PreferredFrequencyLayerInfo },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMSPreferredFreqLayerInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMSPreferredFreqLayerInfo, MBMSPreferredFreqLayerInfo_sequence);

  return offset;
}


static const value_string rnsap_MeasurementFilterCoefficient_vals[] = {
  {   0, "k0" },
  {   1, "k1" },
  {   2, "k2" },
  {   3, "k3" },
  {   4, "k4" },
  {   5, "k5" },
  {   6, "k6" },
  {   7, "k7" },
  {   8, "k8" },
  {   9, "k9" },
  {  10, "k11" },
  {  11, "k13" },
  {  12, "k15" },
  {  13, "k17" },
  {  14, "k19" },
  { 0, NULL }
};


static int
dissect_rnsap_MeasurementFilterCoefficient(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     15, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_MeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MinimumSpreadingFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_MinimumSpreadingFactor768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_MultipleURAsIndicator_vals[] = {
  {   0, "multiple-URAs-exist" },
  {   1, "single-URA-exists" },
  { 0, NULL }
};


static int
dissect_rnsap_MultipleURAsIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_MeasurementRecoveryBehavior(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_rnsap_MeasurementRecoveryReportingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_rnsap_MeasurementRecoverySupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_MIMO_N_M_Ratio_vals[] = {
  {   0, "v1-2" },
  {   1, "v2-3" },
  {   2, "v3-4" },
  {   3, "v4-5" },
  {   4, "v5-6" },
  {   5, "v6-7" },
  {   6, "v7-8" },
  {   7, "v8-9" },
  {   8, "v9-10" },
  {   9, "v1-1" },
  { 0, NULL }
};


static int
dissect_rnsap_MIMO_N_M_Ratio(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MIMO_Information_sequence[] = {
  { &hf_rnsap_mIMO_N_M_Ratio, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MIMO_N_M_Ratio },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MIMO_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MIMO_Information, MIMO_Information_sequence);

  return offset;
}


static const value_string rnsap_MIMO_PilotConfiguration_vals[] = {
  {   0, "primary-and-secondary-CPICH" },
  {   1, "normal-and-diversity-primary-CPICH" },
  { 0, NULL }
};

static const per_choice_t MIMO_PilotConfiguration_choice[] = {
  {   0, &hf_rnsap_primary_and_secondary_CPICH, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonPhysicalChannelID },
  {   1, &hf_rnsap_normal_and_diversity_primary_CPICH, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MIMO_PilotConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MIMO_PilotConfiguration, MIMO_PilotConfiguration_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MIMO_InformationResponse_sequence[] = {
  { &hf_rnsap_mIMO_PilotConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MIMO_PilotConfiguration },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MIMO_InformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MIMO_InformationResponse, MIMO_InformationResponse_sequence);

  return offset;
}


static const value_string rnsap_MIMO_Mode_Indicator_vals[] = {
  {   0, "activate" },
  {   1, "deactivate" },
  { 0, NULL }
};


static int
dissect_rnsap_MIMO_Mode_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t MIMO_InformationToModify_sequence[] = {
  { &hf_rnsap_mIMO_Mode_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MIMO_Mode_Indicator },
  { &hf_rnsap_mIMO_N_M_Ratio, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MIMO_N_M_Ratio },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MIMO_InformationToModify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MIMO_InformationToModify, MIMO_InformationToModify_sequence);

  return offset;
}


static const value_string rnsap_MinUL_ChannelisationCodeLength_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  {   2, "v16" },
  {   3, "v32" },
  {   4, "v64" },
  {   5, "v128" },
  {   6, "v256" },
  { 0, NULL }
};


static int
dissect_rnsap_MinUL_ChannelisationCodeLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_MultiplexingPosition_vals[] = {
  {   0, "fixed" },
  {   1, "flexible" },
  { 0, NULL }
};


static int
dissect_rnsap_MultiplexingPosition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_MAChs_ResetIndicator_vals[] = {
  {   0, "mAChs-NotReset" },
  { 0, NULL }
};


static int
dissect_rnsap_MAChs_ResetIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NACC_Related_Data_sequence[] = {
  { &hf_rnsap_gERAN_SI_Type , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GERAN_SI_Type },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NACC_Related_Data(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NACC_Related_Data, NACC_Related_Data_sequence);

  return offset;
}


static const per_sequence_t Neighbouring_UMTS_CellInformation_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_UMTS_CellInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_Neighbouring_UMTS_CellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_UMTS_CellInformation, Neighbouring_UMTS_CellInformation_sequence_of,
                                                  1, maxNrOfNeighbouringRNCs);

  return offset;
}



static int
dissect_rnsap_PrimaryCPICH_Power(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100, 500U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TxDiversityIndicator_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_rnsap_TxDiversityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_STTD_SupportIndicator_vals[] = {
  {   0, "sTTD-Supported" },
  {   1, "sTTD-not-Supported" },
  { 0, NULL }
};


static int
dissect_rnsap_STTD_SupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Neighbouring_FDD_CellInformationItem_sequence[] = {
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_uARFCNforNu   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_uARFCNforNd   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameOffset },
  { &hf_rnsap_primaryScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryScramblingCode },
  { &hf_rnsap_primaryCPICH_Power, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryCPICH_Power },
  { &hf_rnsap_cellIndividualOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CellIndividualOffset },
  { &hf_rnsap_txDiversityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TxDiversityIndicator },
  { &hf_rnsap_sTTD_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_STTD_SupportIndicator },
  { &hf_rnsap_closedLoopMode1_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ClosedLoopMode1_SupportIndicator },
  { &hf_rnsap_not_used_closedLoopMode2_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_FDD_CellInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_FDD_CellInformationItem, Neighbouring_FDD_CellInformationItem_sequence);

  return offset;
}


static const per_sequence_t Neighbouring_FDD_CellInformation_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_FDD_CellInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Neighbouring_FDD_CellInformationItem },
};

static int
dissect_rnsap_Neighbouring_FDD_CellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_FDD_CellInformation, Neighbouring_FDD_CellInformation_sequence_of,
                                                  1, maxNrOfFDDNeighboursPerRNC);

  return offset;
}



static int
dissect_rnsap_SyncCase(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 2U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_SCH_TimeSlot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 6U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_PCCPCH_Power(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -150, 400U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Neighbouring_TDD_CellInformationItem_sequence[] = {
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_uARFCNforNt   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameOffset },
  { &hf_rnsap_cellParameterID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CellParameterID },
  { &hf_rnsap_syncCase      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SyncCase },
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TimeSlot },
  { &hf_rnsap_sCH_TimeSlot  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SCH_TimeSlot },
  { &hf_rnsap_sCTD_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SCTD_Indicator },
  { &hf_rnsap_cellIndividualOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CellIndividualOffset },
  { &hf_rnsap_dPCHConstantValue, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DPCHConstantValue },
  { &hf_rnsap_pCCPCH_Power  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PCCPCH_Power },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_TDD_CellInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_TDD_CellInformationItem, Neighbouring_TDD_CellInformationItem_sequence);

  return offset;
}


static const per_sequence_t Neighbouring_TDD_CellInformation_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_TDD_CellInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Neighbouring_TDD_CellInformationItem },
};

static int
dissect_rnsap_Neighbouring_TDD_CellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_TDD_CellInformation, Neighbouring_TDD_CellInformation_sequence_of,
                                                  1, maxNrOfTDDNeighboursPerRNC);

  return offset;
}


static const per_sequence_t Neighbouring_UMTS_CellInformationItem_sequence[] = {
  { &hf_rnsap_rNC_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RNC_ID },
  { &hf_rnsap_cN_PS_DomainIdentifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CN_PS_DomainIdentifier },
  { &hf_rnsap_cN_CS_DomainIdentifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CN_CS_DomainIdentifier },
  { &hf_rnsap_neighbouring_FDD_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_FDD_CellInformation },
  { &hf_rnsap_neighbouring_TDD_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_TDD_CellInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_UMTS_CellInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_UMTS_CellInformationItem, Neighbouring_UMTS_CellInformationItem_sequence);

  return offset;
}


static const per_sequence_t NeighbouringFDDCellMeasurementInformation_sequence[] = {
  { &hf_rnsap_uC_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UC_ID },
  { &hf_rnsap_uARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_primaryScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryScramblingCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NeighbouringFDDCellMeasurementInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NeighbouringFDDCellMeasurementInformation, NeighbouringFDDCellMeasurementInformation_sequence);

  return offset;
}



static int
dissect_rnsap_Neighbouring_GSM_CellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t Neighbouring_GSM_CellInformationItem_sequence[] = {
  { &hf_rnsap_cGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CGI },
  { &hf_rnsap_cellIndividualOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CellIndividualOffset },
  { &hf_rnsap_bSIC          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BSIC },
  { &hf_rnsap_band_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Band_Indicator },
  { &hf_rnsap_bCCH_ARFCN    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BCCH_ARFCN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_GSM_CellInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_GSM_CellInformationItem, Neighbouring_GSM_CellInformationItem_sequence);

  return offset;
}


static const per_sequence_t Neighbouring_GSM_CellInformationIEs_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_GSM_CellInformationIEs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Neighbouring_GSM_CellInformationItem },
};

static int
dissect_rnsap_Neighbouring_GSM_CellInformationIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_GSM_CellInformationIEs, Neighbouring_GSM_CellInformationIEs_sequence_of,
                                                  1, maxNrOfGSMNeighboursPerRNC);

  return offset;
}


static const per_sequence_t NeighbouringTDDCellMeasurementInformation_sequence[] = {
  { &hf_rnsap_uC_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UC_ID },
  { &hf_rnsap_uARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_cellParameterID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CellParameterID },
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NeighbouringTDDCellMeasurementInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NeighbouringTDDCellMeasurementInformation, NeighbouringTDDCellMeasurementInformation_sequence);

  return offset;
}


static const per_sequence_t NeighbouringTDDCellMeasurementInformationLCR_sequence[] = {
  { &hf_rnsap_uC_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UC_ID },
  { &hf_rnsap_uARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_cellParameterID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CellParameterID },
  { &hf_rnsap_timeSlotLCR   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NeighbouringTDDCellMeasurementInformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NeighbouringTDDCellMeasurementInformationLCR, NeighbouringTDDCellMeasurementInformationLCR_sequence);

  return offset;
}


static const per_sequence_t NeighbouringTDDCellMeasurementInformation768_sequence[] = {
  { &hf_rnsap_uC_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UC_ID },
  { &hf_rnsap_uARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_cellParameterID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CellParameterID },
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NeighbouringTDDCellMeasurementInformation768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NeighbouringTDDCellMeasurementInformation768, NeighbouringTDDCellMeasurementInformation768_sequence);

  return offset;
}


static const value_string rnsap_RestrictionStateIndicator_vals[] = {
  {   0, "cellNotResevedForOperatorUse" },
  {   1, "cellResevedForOperatorUse" },
  { 0, NULL }
};


static int
dissect_rnsap_RestrictionStateIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Neighbouring_LCR_TDD_CellInformationItem_sequence[] = {
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_uARFCNforNt   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameOffset },
  { &hf_rnsap_cellParameterID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CellParameterID },
  { &hf_rnsap_sCTD_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SCTD_Indicator },
  { &hf_rnsap_cellIndividualOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CellIndividualOffset },
  { &hf_rnsap_dPCHConstantValue, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DPCHConstantValue },
  { &hf_rnsap_pCCPCH_Power  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PCCPCH_Power },
  { &hf_rnsap_restrictionStateIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RestrictionStateIndicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_LCR_TDD_CellInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_LCR_TDD_CellInformationItem, Neighbouring_LCR_TDD_CellInformationItem_sequence);

  return offset;
}


static const per_sequence_t Neighbouring_LCR_TDD_CellInformation_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_LCR_TDD_CellInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Neighbouring_LCR_TDD_CellInformationItem },
};

static int
dissect_rnsap_Neighbouring_LCR_TDD_CellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_LCR_TDD_CellInformation, Neighbouring_LCR_TDD_CellInformation_sequence_of,
                                                  1, maxNrOfLCRTDDNeighboursPerRNC);

  return offset;
}



static int
dissect_rnsap_NrOfDLchannelisationcodes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_NRT_Load_Information_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_NRT_Load_Information_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NRTLoadInformationValue_sequence[] = {
  { &hf_rnsap_uplinkNRTLoadInformationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_3 },
  { &hf_rnsap_downlinkNRTLoadInformationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NRTLoadInformationValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NRTLoadInformationValue, NRTLoadInformationValue_sequence);

  return offset;
}


static const per_sequence_t OnModification_sequence[] = {
  { &hf_rnsap_measurementThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_OnModification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_OnModification, OnModification_sequence);

  return offset;
}


static const value_string rnsap_PagingCause_vals[] = {
  {   0, "terminating-conversational-call" },
  {   1, "terminating-streaming-call" },
  {   2, "terminating-interactive-call" },
  {   3, "terminating-background-call" },
  {   4, "terminating-low-priority-signalling" },
  {   5, "terminating-high-priority-signalling" },
  {   6, "terminating-cause-unknown" },
  { 0, NULL }
};


static int
dissect_rnsap_PagingCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 2, NULL);

  return offset;
}


static const value_string rnsap_PagingRecordType_vals[] = {
  {   0, "imsi-gsm-map" },
  {   1, "tmsi-gsm-map" },
  {   2, "p-tmsi-gsm-map" },
  {   3, "imsi-ds-41" },
  {   4, "tmsi-ds-41" },
  { 0, NULL }
};


static int
dissect_rnsap_PagingRecordType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_PartialReportingIndicator_vals[] = {
  {   0, "partial-reporting-allowed" },
  { 0, NULL }
};


static int
dissect_rnsap_PartialReportingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PCH_InformationItem_sequence[] = {
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PCH_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PCH_InformationItem, PCH_InformationItem_sequence);

  return offset;
}


static const per_sequence_t PCH_InformationList_sequence_of[1] = {
  { &hf_rnsap_PCH_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PCH_InformationItem },
};

static int
dissect_rnsap_PCH_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PCH_InformationList, PCH_InformationList_sequence_of,
                                                  0, 1);

  return offset;
}



static int
dissect_rnsap_PC_Preamble(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Periodic_sequence[] = {
  { &hf_rnsap_reportPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ReportPeriodicity },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Periodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Periodic, Periodic_sequence);

  return offset;
}


static const value_string rnsap_Permanent_NAS_UE_Identity_vals[] = {
  {   0, "imsi" },
  { 0, NULL }
};

static const per_choice_t Permanent_NAS_UE_Identity_choice[] = {
  {   0, &hf_rnsap_imsi          , ASN1_EXTENSION_ROOT    , dissect_rnsap_IMSI },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Permanent_NAS_UE_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Permanent_NAS_UE_Identity, Permanent_NAS_UE_Identity_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_Phase_Reference_Update_Indicator_vals[] = {
  {   0, "phase-reference-needs-to-be-changed" },
  { 0, NULL }
};


static int
dissect_rnsap_Phase_Reference_Update_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_PLCCHsequenceNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_PowerOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 24U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_PredictedSFNSFNDeviationLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_PredictedTUTRANGPSDeviationLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_PrimaryCPICH_EcNo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30, 30U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_Primary_CPICH_Usage_For_Channel_Estimation_vals[] = {
  {   0, "primary-CPICH-may-be-used" },
  {   1, "primary-CPICH-shall-not-be-used" },
  { 0, NULL }
};


static int
dissect_rnsap_Primary_CPICH_Usage_For_Channel_Estimation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_PrimaryCCPCH_RSCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 91U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_PrimaryCCPCH_RSCP_Delta(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -5, -1, NULL, TRUE);

  return offset;
}


static const per_sequence_t ProvidedInformation_sequence[] = {
  { &hf_rnsap_mBMSChannelTypeInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MBMSChannelTypeInfo },
  { &hf_rnsap_mBMSPreferredFreqLayerInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MBMSPreferredFreqLayerInfo },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ProvidedInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ProvidedInformation, ProvidedInformation_sequence);

  return offset;
}



static int
dissect_rnsap_RANAP_RelocationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_rnsap_RB_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t RB_Info_sequence_of[1] = {
  { &hf_rnsap_RB_Info_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RB_Identity },
};

static int
dissect_rnsap_RB_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RB_Info, RB_Info_sequence_of,
                                                  1, maxNoOfRB);

  return offset;
}



static int
dissect_rnsap_Received_total_wide_band_power(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 621U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Received_Total_Wideband_Power_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_Received_total_wide_band_power(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_rnsap_Received_Total_Wideband_Power_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 620U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_RefTFCNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Extension_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string rnsap_ReportCharacteristics_vals[] = {
  {   0, "onDemand" },
  {   1, "periodic" },
  {   2, "eventA" },
  {   3, "eventB" },
  {   4, "eventC" },
  {   5, "eventD" },
  {   6, "eventE" },
  {   7, "eventF" },
  {   8, "extension-ReportCharacteristics" },
  { 0, NULL }
};

static const per_choice_t ReportCharacteristics_choice[] = {
  {   0, &hf_rnsap_onDemand      , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_periodic_01   , ASN1_EXTENSION_ROOT    , dissect_rnsap_Periodic },
  {   2, &hf_rnsap_eventA        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventA },
  {   3, &hf_rnsap_eventB        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventB },
  {   4, &hf_rnsap_eventC        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventC },
  {   5, &hf_rnsap_eventD        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventD },
  {   6, &hf_rnsap_eventE        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventE },
  {   7, &hf_rnsap_eventF        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventF },
  {   8, &hf_rnsap_extension_ReportCharacteristics, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_ReportCharacteristics },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_ReportCharacteristics, ReportCharacteristics_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_RequestedDataValueInformation_vals[] = {
  {   0, "informationAvailable" },
  {   1, "informationNotAvailable" },
  { 0, NULL }
};

static const per_choice_t RequestedDataValueInformation_choice[] = {
  {   0, &hf_rnsap_informationAvailable, ASN1_NO_EXTENSIONS     , dissect_rnsap_InformationAvailable },
  {   1, &hf_rnsap_informationNotAvailable, ASN1_NO_EXTENSIONS     , dissect_rnsap_InformationNotAvailable },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_RequestedDataValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_RequestedDataValueInformation, RequestedDataValueInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_RL_Set_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t RL_Specific_DCH_Info_Item_sequence[] = {
  { &hf_rnsap_dCH_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Specific_DCH_Info_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Specific_DCH_Info_Item, RL_Specific_DCH_Info_Item_sequence);

  return offset;
}


static const per_sequence_t RL_Specific_DCH_Info_sequence_of[1] = {
  { &hf_rnsap_RL_Specific_DCH_Info_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Specific_DCH_Info_Item },
};

static int
dissect_rnsap_RL_Specific_DCH_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Specific_DCH_Info, RL_Specific_DCH_Info_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const per_sequence_t RL_Specific_EDCH_InfoItem_sequence[] = {
  { &hf_rnsap_eDCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_EDCH_MACdFlow_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Specific_EDCH_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Specific_EDCH_InfoItem, RL_Specific_EDCH_InfoItem_sequence);

  return offset;
}


static const per_sequence_t RL_Specific_EDCH_Info_sequence_of[1] = {
  { &hf_rnsap_RL_Specific_EDCH_Info_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Specific_EDCH_InfoItem },
};

static int
dissect_rnsap_RL_Specific_EDCH_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Specific_EDCH_Info, RL_Specific_EDCH_Info_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows);

  return offset;
}


static const per_sequence_t RL_Specific_EDCH_Information_sequence[] = {
  { &hf_rnsap_rL_Specific_EDCH_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Specific_EDCH_Info },
  { &hf_rnsap_e_AGCH_PowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_AGCH_PowerOffset },
  { &hf_rnsap_e_RGCH_PowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_RGCH_PowerOffset },
  { &hf_rnsap_e_HICH_PowerOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_E_HICH_PowerOffset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Specific_EDCH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Specific_EDCH_Information, RL_Specific_EDCH_Information_sequence);

  return offset;
}



static int
dissect_rnsap_RT_Load_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_RT_Load_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t RTLoadValue_sequence[] = {
  { &hf_rnsap_uplinkRTLoadValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_100 },
  { &hf_rnsap_downlinkRTLoadValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RTLoadValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RTLoadValue, RTLoadValue_sequence);

  return offset;
}



static int
dissect_rnsap_RxTimingDeviationForTA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_RxTimingDeviationForTAext(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_RxTimingDeviationForTA768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Rx_Timing_Deviation_Value_ext(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Rx_Timing_Deviation_Value_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Rx_Timing_Deviation_Value_768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_SAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, FALSE, NULL);

  return offset;
}


static const per_sequence_t SAI_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_lAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_LAC },
  { &hf_rnsap_sAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_SAC },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SAI, SAI_sequence);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_INTEGER_0_maxCTFC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxCTFC, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TFCS_CTFC_vals[] = {
  {   0, "ctfc2bit" },
  {   1, "ctfc4bit" },
  {   2, "ctfc6bit" },
  {   3, "ctfc8bit" },
  {   4, "ctfc12bit" },
  {   5, "ctfc16bit" },
  {   6, "ctfcmaxbit" },
  { 0, NULL }
};

static const per_choice_t TFCS_CTFC_choice[] = {
  {   0, &hf_rnsap_ctfc2bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_3 },
  {   1, &hf_rnsap_ctfc4bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_15 },
  {   2, &hf_rnsap_ctfc6bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_63 },
  {   3, &hf_rnsap_ctfc8bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_255 },
  {   4, &hf_rnsap_ctfc12bit     , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_4095 },
  {   5, &hf_rnsap_ctfc16bit     , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_65535 },
  {   6, &hf_rnsap_ctfcmaxbit    , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_maxCTFC },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TFCS_CTFC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TFCS_CTFC, TFCS_CTFC_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_signalledGainFactors_sequence[] = {
  { &hf_rnsap_betaC         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BetaCD },
  { &hf_rnsap_betaD         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BetaCD },
  { &hf_rnsap_refTFCNumber  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RefTFCNumber },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_signalledGainFactors(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_signalledGainFactors, T_signalledGainFactors_sequence);

  return offset;
}


static const value_string rnsap_TransportFormatCombination_Beta_vals[] = {
  {   0, "signalledGainFactors" },
  {   1, "refTFCNumber" },
  { 0, NULL }
};

static const per_choice_t TransportFormatCombination_Beta_choice[] = {
  {   0, &hf_rnsap_signalledGainFactors, ASN1_EXTENSION_ROOT    , dissect_rnsap_T_signalledGainFactors },
  {   1, &hf_rnsap_refTFCNumber  , ASN1_EXTENSION_ROOT    , dissect_rnsap_RefTFCNumber },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransportFormatCombination_Beta(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransportFormatCombination_Beta, TransportFormatCombination_Beta_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TFCS_TFCSList_item_sequence[] = {
  { &hf_rnsap_cTFC          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS_CTFC },
  { &hf_rnsap_tFC_Beta      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatCombination_Beta },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TFCS_TFCSList_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TFCS_TFCSList_item, TFCS_TFCSList_item_sequence);

  return offset;
}


static const per_sequence_t TFCS_TFCSList_sequence_of[1] = {
  { &hf_rnsap_TFCS_TFCSList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS_TFCSList_item },
};

static int
dissect_rnsap_TFCS_TFCSList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TFCS_TFCSList, TFCS_TFCSList_sequence_of,
                                                  1, maxNrOfTFCs);

  return offset;
}


static const value_string rnsap_T_tFCSvalues_vals[] = {
  {   0, "no-Split-in-TFCI" },
  {   1, "not-Used-split-in-TFCI" },
  { 0, NULL }
};

static const per_choice_t T_tFCSvalues_choice[] = {
  {   0, &hf_rnsap_no_Split_in_TFCI, ASN1_EXTENSION_ROOT    , dissect_rnsap_TFCS_TFCSList },
  {   1, &hf_rnsap_not_Used_split_in_TFCI, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_T_tFCSvalues(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_T_tFCSvalues, T_tFCSvalues_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TFCS_sequence[] = {
  { &hf_rnsap_tFCSvalues    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_tFCSvalues },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TFCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TFCS, TFCS_sequence);

  return offset;
}


static const value_string rnsap_TFCI_Coding_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  {   2, "v16" },
  {   3, "v32" },
  { 0, NULL }
};


static int
dissect_rnsap_TFCI_Coding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_Code_InformationItem_sequence[] = {
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_Code_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_TDD_Code_InformationItem, Secondary_CCPCH_TDD_Code_InformationItem_sequence);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_Code_Information_sequence_of[1] = {
  { &hf_rnsap_Secondary_CCPCH_TDD_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_Code_InformationItem },
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_Code_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_CCPCH_TDD_Code_Information, Secondary_CCPCH_TDD_Code_Information_sequence_of,
                                                  1, maxNrOfSCCPCHs);

  return offset;
}



static int
dissect_rnsap_TDD_PhysicalChannelOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_InformationItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_secondary_CCPCH_TDD_Code_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_Code_Information },
  { &hf_rnsap_tDD_PhysicalChannelOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_PhysicalChannelOffset },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_TDD_InformationItem, Secondary_CCPCH_TDD_InformationItem_sequence);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_InformationList_sequence_of[1] = {
  { &hf_rnsap_Secondary_CCPCH_TDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_InformationItem },
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_CCPCH_TDD_InformationList, Secondary_CCPCH_TDD_InformationList_sequence_of,
                                                  0, maxNrOfSCCPCHs);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_Info_TDD_sequence[] = {
  { &hf_rnsap_dl_TFCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_secondary_CCPCH_TDD_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_InformationList },
  { &hf_rnsap_fACH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InformationList },
  { &hf_rnsap_pCH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PCH_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_Info_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_Info_TDD, Secondary_CCPCH_Info_TDD_sequence);

  return offset;
}


static const per_sequence_t Secondary_CPICH_Information_sequence[] = {
  { &hf_rnsap_dl_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_ScramblingCode },
  { &hf_rnsap_fDD_DL_ChannelisationCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_ChannelisationCodeNumber },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CPICH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CPICH_Information, Secondary_CPICH_Information_sequence);

  return offset;
}


static const value_string rnsap_Secondary_CPICH_Information_Change_vals[] = {
  {   0, "new-secondary-CPICH" },
  {   1, "secondary-CPICH-shall-not-be-used" },
  { 0, NULL }
};

static const per_choice_t Secondary_CPICH_Information_Change_choice[] = {
  {   0, &hf_rnsap_new_secondary_CPICH, ASN1_EXTENSION_ROOT    , dissect_rnsap_Secondary_CPICH_Information },
  {   1, &hf_rnsap_secondary_CPICH_shall_not_be_used, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Secondary_CPICH_Information_Change(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Secondary_CPICH_Information_Change, Secondary_CPICH_Information_Change_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Secondary_LCR_CCPCH_TDD_Code_InformationItem_sequence[] = {
  { &hf_rnsap_tDD_ChannelisationCodeLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCodeLCR },
  { &hf_rnsap_s_CCPCH_TimeSlotFormat_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_LCR_CCPCH_TDD_Code_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_LCR_CCPCH_TDD_Code_InformationItem, Secondary_LCR_CCPCH_TDD_Code_InformationItem_sequence);

  return offset;
}


static const per_sequence_t Secondary_LCR_CCPCH_TDD_Code_Information_sequence_of[1] = {
  { &hf_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_LCR_CCPCH_TDD_Code_InformationItem },
};

static int
dissect_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information, Secondary_LCR_CCPCH_TDD_Code_Information_sequence_of,
                                                  1, maxNrOfSCCPCHs);

  return offset;
}


static const per_sequence_t Secondary_LCR_CCPCH_TDD_InformationItem_sequence[] = {
  { &hf_rnsap_timeSlotLCR   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlotLCR },
  { &hf_rnsap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftLCR },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_secondary_LCR_CCPCH_TDD_Code_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information },
  { &hf_rnsap_tDD_PhysicalChannelOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_PhysicalChannelOffset },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_LCR_CCPCH_TDD_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_LCR_CCPCH_TDD_InformationItem, Secondary_LCR_CCPCH_TDD_InformationItem_sequence);

  return offset;
}


static const per_sequence_t Secondary_LCR_CCPCH_TDD_InformationList_sequence_of[1] = {
  { &hf_rnsap_Secondary_LCR_CCPCH_TDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_LCR_CCPCH_TDD_InformationItem },
};

static int
dissect_rnsap_Secondary_LCR_CCPCH_TDD_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_LCR_CCPCH_TDD_InformationList, Secondary_LCR_CCPCH_TDD_InformationList_sequence_of,
                                                  0, maxNrOfSCCPCHs);

  return offset;
}


static const per_sequence_t Secondary_LCR_CCPCH_Info_TDD_sequence[] = {
  { &hf_rnsap_dl_TFCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_secondary_LCR_CCPCH_TDD_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_LCR_CCPCH_TDD_InformationList },
  { &hf_rnsap_fACH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InformationList },
  { &hf_rnsap_pCH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PCH_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_LCR_CCPCH_Info_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_LCR_CCPCH_Info_TDD, Secondary_LCR_CCPCH_Info_TDD_sequence);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_Code_InformationItem768_sequence[] = {
  { &hf_rnsap_tDD_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_Code_InformationItem768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_TDD_Code_InformationItem768, Secondary_CCPCH_TDD_Code_InformationItem768_sequence);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_Code_Information768_sequence_of[1] = {
  { &hf_rnsap_Secondary_CCPCH_TDD_Code_Information768_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_Code_InformationItem768 },
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_Code_Information768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_CCPCH_TDD_Code_Information768, Secondary_CCPCH_TDD_Code_Information768_sequence_of,
                                                  1, maxNrOfSCCPCHs768);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_InformationItem768_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType768 },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_secondary_CCPCH_TDD_Code_Information768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_Code_Information768 },
  { &hf_rnsap_tDD_PhysicalChannelOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_PhysicalChannelOffset },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_InformationItem768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_TDD_InformationItem768, Secondary_CCPCH_TDD_InformationItem768_sequence);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_TDD_InformationList768_sequence_of[1] = {
  { &hf_rnsap_Secondary_CCPCH_TDD_InformationList768_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_InformationItem768 },
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_InformationList768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_CCPCH_TDD_InformationList768, Secondary_CCPCH_TDD_InformationList768_sequence_of,
                                                  0, maxNrOfSCCPCHs768);

  return offset;
}


static const per_sequence_t Secondary_CCPCH_Info_TDD768_sequence[] = {
  { &hf_rnsap_dl_TFCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_secondary_CCPCH_TDD_InformationList768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_InformationList768 },
  { &hf_rnsap_fACH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InformationList },
  { &hf_rnsap_pCH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PCH_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_Info_TDD768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_Info_TDD768, Secondary_CCPCH_Info_TDD768_sequence);

  return offset;
}



static int
dissect_rnsap_SFNSFNChangeLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SFNSFNMeasurementThresholdInformation_sequence[] = {
  { &hf_rnsap_sFNSFNChangeLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SFNSFNChangeLimit },
  { &hf_rnsap_predictedSFNSFNDeviationLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PredictedSFNSFNDeviationLimit },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SFNSFNMeasurementThresholdInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SFNSFNMeasurementThresholdInformation, SFNSFNMeasurementThresholdInformation_sequence);

  return offset;
}



static int
dissect_rnsap_SixteenQAM_UL_Delta_T2TP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 6U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_SixteenQAM_UL_Operation_Indicator_vals[] = {
  {   0, "activate" },
  {   1, "deactivate" },
  { 0, NULL }
};


static int
dissect_rnsap_SixteenQAM_UL_Operation_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SixteenQAM_UL_Information_sequence[] = {
  { &hf_rnsap_sixteenQAM_UL_Operation_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SixteenQAM_UL_Operation_Indicator },
  { &hf_rnsap_sixteenQAM_UL_Delta_T2TP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SixteenQAM_UL_Delta_T2TP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SixteenQAM_UL_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SixteenQAM_UL_Information, SixteenQAM_UL_Information_sequence);

  return offset;
}


static const per_sequence_t SixteenQAM_UL_Information_to_Modify_sequence[] = {
  { &hf_rnsap_sixteenQAM_UL_Operation_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SixteenQAM_UL_Operation_Indicator },
  { &hf_rnsap_sixteenQAM_UL_Delta_T2TP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SixteenQAM_UL_Delta_T2TP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SixteenQAM_UL_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SixteenQAM_UL_Information_to_Modify, SixteenQAM_UL_Information_to_Modify_sequence);

  return offset;
}


static const value_string rnsap_SixtyfourQAM_DL_SupportIndicator_vals[] = {
  {   0, "sixteenQAM-DL-supported" },
  {   1, "sixteenQAM-DL-not-supported" },
  { 0, NULL }
};


static int
dissect_rnsap_SixtyfourQAM_DL_SupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_SNACode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ListOfSNAs_sequence_of[1] = {
  { &hf_rnsap_ListOfSNAs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_SNACode },
};

static int
dissect_rnsap_ListOfSNAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_ListOfSNAs, ListOfSNAs_sequence_of,
                                                  1, maxNrOfSNAs);

  return offset;
}


static const per_sequence_t SNA_Information_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_listOfSNAs    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ListOfSNAs },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SNA_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SNA_Information, SNA_Information_sequence);

  return offset;
}



static int
dissect_rnsap_SpecialBurstScheduling(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_T_sRNTI_BitMaskIndex_vals[] = {
  {   0, "b1" },
  {   1, "b2" },
  {   2, "b3" },
  {   3, "b4" },
  {   4, "b5" },
  {   5, "b6" },
  {   6, "b7" },
  {   7, "b8" },
  {   8, "b9" },
  {   9, "b10" },
  {  10, "b11" },
  {  11, "b12" },
  {  12, "b13" },
  {  13, "b14" },
  {  14, "b15" },
  {  15, "b16" },
  {  16, "b17" },
  {  17, "b18" },
  {  18, "b19" },
  { 0, NULL }
};


static int
dissect_rnsap_T_sRNTI_BitMaskIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     19, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t S_RNTI_Group_sequence[] = {
  { &hf_rnsap_sRNTI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_S_RNTI },
  { &hf_rnsap_sRNTI_BitMaskIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_sRNTI_BitMaskIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_S_RNTI_Group(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_S_RNTI_Group, S_RNTI_Group_sequence);

  return offset;
}



static int
dissect_rnsap_SRB_Delay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_SSDT_SupportIndicator_vals[] = {
  {   0, "not-Used-sSDT-supported" },
  {   1, "sSDT-not-supported" },
  { 0, NULL }
};


static int
dissect_rnsap_SSDT_SupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_Support_8PSK_vals[] = {
  {   0, "v8PSK-Supported" },
  { 0, NULL }
};


static int
dissect_rnsap_Support_8PSK(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_Support_PLCCH_vals[] = {
  {   0, "vPLCCH-Supported" },
  { 0, NULL }
};


static int
dissect_rnsap_Support_PLCCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_INTEGER_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SynchronisationConfiguration_sequence[] = {
  { &hf_rnsap_n_INSYNC_IND  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_256 },
  { &hf_rnsap_n_OUTSYNC_IND , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_256 },
  { &hf_rnsap_t_RLFAILURE   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_255 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SynchronisationConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SynchronisationConfiguration, SynchronisationConfiguration_sequence);

  return offset;
}


static const value_string rnsap_T_maxSYNC_UL_transmissions_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  { 0, NULL }
};


static int
dissect_rnsap_T_maxSYNC_UL_transmissions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SYNC_UL_ProcParameters_sequence[] = {
  { &hf_rnsap_maxSYNC_UL_transmissions, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_maxSYNC_UL_transmissions },
  { &hf_rnsap_powerRampStep , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_3_ },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SYNC_UL_ProcParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SYNC_UL_ProcParameters, SYNC_UL_ProcParameters_sequence);

  return offset;
}


static const per_sequence_t TDD_DCHs_to_ModifySpecificItem_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_ul_CCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_CCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_ul_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DCHs_to_ModifySpecificItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DCHs_to_ModifySpecificItem, TDD_DCHs_to_ModifySpecificItem_sequence);

  return offset;
}


static const per_sequence_t TDD_DCHs_to_ModifySpecificInformationList_sequence_of[1] = {
  { &hf_rnsap_TDD_DCHs_to_ModifySpecificInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DCHs_to_ModifySpecificItem },
};

static int
dissect_rnsap_TDD_DCHs_to_ModifySpecificInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DCHs_to_ModifySpecificInformationList, TDD_DCHs_to_ModifySpecificInformationList_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const per_sequence_t TDD_DCHs_to_ModifyItem_sequence[] = {
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWE },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_dCH_SpecificInformationList_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DCHs_to_ModifySpecificInformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DCHs_to_ModifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DCHs_to_ModifyItem, TDD_DCHs_to_ModifyItem_sequence);

  return offset;
}


static const per_sequence_t TDD_DCHs_to_Modify_sequence_of[1] = {
  { &hf_rnsap_TDD_DCHs_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DCHs_to_ModifyItem },
};

static int
dissect_rnsap_TDD_DCHs_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DCHs_to_Modify, TDD_DCHs_to_Modify_sequence_of,
                                                  1, maxNrOfDCHs);

  return offset;
}


static const value_string rnsap_TDD_DPCHOffset_vals[] = {
  {   0, "initialOffset" },
  {   1, "noinitialOffset" },
  { 0, NULL }
};

static const per_choice_t TDD_DPCHOffset_choice[] = {
  {   0, &hf_rnsap_initialOffset , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_255 },
  {   1, &hf_rnsap_noinitialOffset, ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_63 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TDD_DPCHOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TDD_DPCHOffset, TDD_DPCHOffset_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_TDD_TPC_DownlinkStepSize_vals[] = {
  {   0, "step-size1" },
  {   1, "step-size2" },
  {   2, "step-size3" },
  { 0, NULL }
};


static int
dissect_rnsap_TDD_TPC_DownlinkStepSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_UL_Code_InformationItem_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_UL_Code_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_UL_Code_InformationItem, TDD_UL_Code_InformationItem_sequence);

  return offset;
}


static const per_sequence_t TDD_UL_Code_Information_sequence_of[1] = {
  { &hf_rnsap_TDD_UL_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_UL_Code_InformationItem },
};

static int
dissect_rnsap_TDD_UL_Code_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_UL_Code_Information, TDD_UL_Code_Information_sequence_of,
                                                  1, maxNrOfDPCHs);

  return offset;
}



static int
dissect_rnsap_QPSK_UL_DPCH_TimeSlotFormatTDD_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 69U, NULL, TRUE);

  return offset;
}



static int
dissect_rnsap_EightPSK_UL_DPCH_TimeSlotFormatTDD_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 24U, NULL, TRUE);

  return offset;
}


static const value_string rnsap_TDD_UL_DPCH_TimeSlotFormat_LCR_vals[] = {
  {   0, "qPSK" },
  {   1, "eightPSK" },
  { 0, NULL }
};

static const per_choice_t TDD_UL_DPCH_TimeSlotFormat_LCR_choice[] = {
  {   0, &hf_rnsap_qPSK_01       , ASN1_EXTENSION_ROOT    , dissect_rnsap_QPSK_UL_DPCH_TimeSlotFormatTDD_LCR },
  {   1, &hf_rnsap_eightPSK_01   , ASN1_EXTENSION_ROOT    , dissect_rnsap_EightPSK_UL_DPCH_TimeSlotFormatTDD_LCR },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TDD_UL_DPCH_TimeSlotFormat_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TDD_UL_DPCH_TimeSlotFormat_LCR, TDD_UL_DPCH_TimeSlotFormat_LCR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TDD_UL_Code_LCR_InformationItem_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tdd_ChannelisationCodeLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCodeLCR },
  { &hf_rnsap_tdd_UL_DPCH_TimeSlotFormat_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_UL_DPCH_TimeSlotFormat_LCR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_UL_Code_LCR_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_UL_Code_LCR_InformationItem, TDD_UL_Code_LCR_InformationItem_sequence);

  return offset;
}


static const per_sequence_t TDD_UL_Code_LCR_Information_sequence_of[1] = {
  { &hf_rnsap_TDD_UL_Code_LCR_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_UL_Code_LCR_InformationItem },
};

static int
dissect_rnsap_TDD_UL_Code_LCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_UL_Code_LCR_Information, TDD_UL_Code_LCR_Information_sequence_of,
                                                  1, maxNrOfDPCHsLCR);

  return offset;
}


static const per_sequence_t TDD_UL_Code_InformationItem768_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode768 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_UL_Code_InformationItem768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_UL_Code_InformationItem768, TDD_UL_Code_InformationItem768_sequence);

  return offset;
}


static const per_sequence_t TDD_UL_Code_Information768_sequence_of[1] = {
  { &hf_rnsap_TDD_UL_Code_Information768_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_UL_Code_InformationItem768 },
};

static int
dissect_rnsap_TDD_UL_Code_Information768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_UL_Code_Information768, TDD_UL_Code_Information768_sequence_of,
                                                  1, maxNrOfDPCHs768);

  return offset;
}


static const value_string rnsap_TFCI_SignallingMode_vals[] = {
  {   0, "normal" },
  {   1, "not-Used-split" },
  { 0, NULL }
};


static int
dissect_rnsap_TFCI_SignallingMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_TGD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 269U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TGSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TimingAdvanceApplied_vals[] = {
  {   0, "yes" },
  {   1, "no" },
  { 0, NULL }
};


static int
dissect_rnsap_TimingAdvanceApplied(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_SynchronisationIndicator_vals[] = {
  {   0, "timingMaintainedSynchronisation" },
  { 0, NULL }
};


static int
dissect_rnsap_SynchronisationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_TraceDepth_vals[] = {
  {   0, "minimum" },
  {   1, "medium" },
  {   2, "maximum" },
  { 0, NULL }
};


static int
dissect_rnsap_TraceDepth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_TraceRecordingSessionReference(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_TraceReference(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 3, FALSE, NULL);

  return offset;
}


static const value_string rnsap_UL_DL_mode_vals[] = {
  {   0, "ul-only" },
  {   1, "dl-only" },
  {   2, "both-ul-and-dl" },
  { 0, NULL }
};


static int
dissect_rnsap_UL_DL_mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_Uplink_Compressed_Mode_Method_vals[] = {
  {   0, "sFdiv2" },
  {   1, "higher-layer-scheduling" },
  { 0, NULL }
};


static int
dissect_rnsap_Uplink_Compressed_Mode_Method(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Information_item_sequence[] = {
  { &hf_rnsap_tGPSID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGPSID },
  { &hf_rnsap_tGSN          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGSN },
  { &hf_rnsap_tGL1          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GapLength },
  { &hf_rnsap_tGL2          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GapLength },
  { &hf_rnsap_tGD           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGD },
  { &hf_rnsap_tGPL1         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GapDuration },
  { &hf_rnsap_not_to_be_used_1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GapDuration },
  { &hf_rnsap_uL_DL_mode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_DL_mode },
  { &hf_rnsap_downlink_Compressed_Mode_Method, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Downlink_Compressed_Mode_Method },
  { &hf_rnsap_uplink_Compressed_Mode_Method, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Uplink_Compressed_Mode_Method },
  { &hf_rnsap_dL_FrameType  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_FrameType },
  { &hf_rnsap_delta_SIR1    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DeltaSIR },
  { &hf_rnsap_delta_SIR_after1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DeltaSIR },
  { &hf_rnsap_delta_SIR2    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DeltaSIR },
  { &hf_rnsap_delta_SIR_after2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DeltaSIR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Transmission_Gap_Pattern_Sequence_Information_item, Transmission_Gap_Pattern_Sequence_Information_item_sequence);

  return offset;
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Information_sequence_of[1] = {
  { &hf_rnsap_Transmission_Gap_Pattern_Sequence_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information_item },
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Transmission_Gap_Pattern_Sequence_Information, Transmission_Gap_Pattern_Sequence_Information_sequence_of,
                                                  1, maxTGPS);

  return offset;
}


static const value_string rnsap_TransmitDiversityIndicator_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_rnsap_TransmitDiversityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_rnsap_Transmitted_Carrier_Power_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_rnsap_Transmitted_Carrier_Power_Value_IncrDecrThres(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t TUTRANGANSSMeasurementThresholdInformation_sequence[] = {
  { &hf_rnsap_tUTRANGANSSChangeLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_1_256 },
  { &hf_rnsap_predictedTUTRANGANSSDeviationLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_INTEGER_1_256 },
  { &hf_rnsap_ie_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TUTRANGANSSMeasurementThresholdInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TUTRANGANSSMeasurementThresholdInformation, TUTRANGANSSMeasurementThresholdInformation_sequence);

  return offset;
}



static int
dissect_rnsap_TUTRANGPSChangeLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const per_sequence_t TUTRANGPSMeasurementThresholdInformation_sequence[] = {
  { &hf_rnsap_tUTRANGPSChangeLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TUTRANGPSChangeLimit },
  { &hf_rnsap_predictedTUTRANGPSDeviationLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PredictedTUTRANGPSDeviationLimit },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TUTRANGPSMeasurementThresholdInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TUTRANGPSMeasurementThresholdInformation, TUTRANGPSMeasurementThresholdInformation_sequence);

  return offset;
}



static int
dissect_rnsap_TransportBearerID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_TransportFormatManagement_vals[] = {
  {   0, "cell-based" },
  {   1, "ue-based" },
  { 0, NULL }
};


static int
dissect_rnsap_TransportFormatManagement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_TSTD_Indicator_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_rnsap_TSTD_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_TSTD_Support_Indicator_vals[] = {
  {   0, "tSTD-supported" },
  {   1, "tSTD-not-supported" },
  { 0, NULL }
};


static int
dissect_rnsap_TSTD_Support_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_rnsap_TypeOfError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_UEIdentity_vals[] = {
  {   0, "imsi" },
  {   1, "imei" },
  {   2, "imeisv" },
  { 0, NULL }
};

static const per_choice_t UEIdentity_choice[] = {
  {   0, &hf_rnsap_imsi          , ASN1_EXTENSION_ROOT    , dissect_rnsap_IMSI },
  {   1, &hf_rnsap_imei          , ASN1_EXTENSION_ROOT    , dissect_rnsap_IMEI },
  {   2, &hf_rnsap_imeisv        , ASN1_EXTENSION_ROOT    , dissect_rnsap_IMEISV },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_UEIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_UEIdentity, UEIdentity_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_UEMeasurementHysteresisTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string rnsap_UEMeasurementParameterModAllow_vals[] = {
  {   0, "parameterModificationAllowed" },
  { 0, NULL }
};


static int
dissect_rnsap_UEMeasurementParameterModAllow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string rnsap_UEMeasurementReportCharacteristicsPeriodicAmountofReporting_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "rInfinity" },
  { 0, NULL }
};


static int
dissect_rnsap_UEMeasurementReportCharacteristicsPeriodicAmountofReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string rnsap_UEMeasurementReportCharacteristicsPeriodicReportingInterval_vals[] = {
  {   0, "r250" },
  {   1, "r500" },
  {   2, "r1000" },
  {   3, "r2000" },
  {   4, "r3000" },
  {   5, "r4000" },
  {   6, "r6000" },
  {   7, "r8000" },
  {   8, "r12000" },
  {   9, "r16000" },
  {  10, "r20000" },
  {  11, "r24000" },
  {  12, "r28000" },
  {  13, "r32000" },
  {  14, "r64000" },
  { 0, NULL }
};


static int
dissect_rnsap_UEMeasurementReportCharacteristicsPeriodicReportingInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     15, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UEMeasurementReportCharacteristicsPeriodic_sequence[] = {
  { &hf_rnsap_amountofReporting, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UEMeasurementReportCharacteristicsPeriodicAmountofReporting },
  { &hf_rnsap_reportingInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UEMeasurementReportCharacteristicsPeriodicReportingInterval },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UEMeasurementReportCharacteristicsPeriodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UEMeasurementReportCharacteristicsPeriodic, UEMeasurementReportCharacteristicsPeriodic_sequence);

  return offset;
}



static int
dissect_rnsap_