/******************************************************************************
** $Id: opcua_serviceparser.c 21885 2007-05-22 13:17:24Z jmayer $
**
** Copyright (C) 2006-2007 ascolab GmbH. All Rights Reserved.
** Web: http://www.ascolab.com
** 
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
** 
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
** 
** Project: OpcUa Wireshark Plugin
**
** Description: OpcUa Service Type Parser
**
** This file was autogenerated on 8.5.2007 18:53:26.
** DON'T MODIFY THIS FILE!
**
******************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include "opcua_serviceparser.h"
#include "opcua_complextypeparser.h"
#include "opcua_enumparser.h"
#include "opcua_simpletypes.h"
#include "opcua_hfindeces.h"


gint ett_opcua_TestStackRequest = -1;
void parseTestStackRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TestStackRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TestId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_Iteration);
  parseVariant(subtree, tvb, pOffset, "Input");
}

gint ett_opcua_TestStackResponse = -1;
void parseTestStackResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TestStackResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseVariant(subtree, tvb, pOffset, "Output");
}

gint ett_opcua_TestStackExRequest = -1;
void parseTestStackExRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TestStackExRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackExRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TestId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_Iteration);
  parseExtensionObject(subtree, tvb, pOffset, "Input");
}

gint ett_opcua_TestStackExResponse = -1;
void parseTestStackExResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TestStackExResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TestStackExResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseExtensionObject(subtree, tvb, pOffset, "Output");
}

gint ett_opcua_FindServersRequest = -1;
void parseFindServersRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "FindServersRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_FindServersRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "LocaleIds", parseLocalizedText);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ServerUris, parseString);
}

gint ett_opcua_FindServersResponse = -1;
void parseFindServersResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "FindServersResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_FindServersResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Servers", parseServerDescription);
}

gint ett_opcua_GetEndpointsRequest = -1;
void parseGetEndpointsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "GetEndpointsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_GetEndpointsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "LocaleIds", parseLocalizedText);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ProfileUris, parseString);
}

gint ett_opcua_GetEndpointsResponse = -1;
void parseGetEndpointsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "GetEndpointsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_GetEndpointsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Endpoints", parseEndpointDescription);
}

gint ett_opcua_RegisterServerRequest = -1;
void parseRegisterServerRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "RegisterServerRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RegisterServerRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseRegisteredServer(subtree, tvb, pOffset, "Server");
}

gint ett_opcua_RegisterServerResponse = -1;
void parseRegisterServerResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "RegisterServerResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RegisterServerResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
}

gint ett_opcua_OpenSecureChannelRequest = -1;
void parseOpenSecureChannelRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "OpenSecureChannelRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_OpenSecureChannelRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ClientCertificate);
  parseSecurityTokenRequestType(subtree, tvb, pOffset);
  parseGuid(subtree, tvb, pOffset, hf_opcua_SecureChannelId);
  parseMessageSecurityMode(subtree, tvb, pOffset);
  parseString(subtree, tvb, pOffset, hf_opcua_SecurityPolicyUri);
  parseSecurityPolicy(subtree, tvb, pOffset, "SecurityPolicy");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ClientNonce);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RequestedLifetime);
}

gint ett_opcua_OpenSecureChannelResponse = -1;
void parseOpenSecureChannelResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "OpenSecureChannelResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_OpenSecureChannelResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerCertificate);
  parseChannelSecurityToken(subtree, tvb, pOffset, "SecurityToken");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerNonce);
}

gint ett_opcua_CloseSecureChannelRequest = -1;
void parseCloseSecureChannelRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CloseSecureChannelRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSecureChannelRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseGuid(subtree, tvb, pOffset, hf_opcua_SecureChannelId);
}

gint ett_opcua_CloseSecureChannelResponse = -1;
void parseCloseSecureChannelResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CloseSecureChannelResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSecureChannelResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
}

gint ett_opcua_CreateSessionRequest = -1;
void parseCreateSessionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CreateSessionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSessionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseString(subtree, tvb, pOffset, hf_opcua_ClientName);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ClientNonce);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ClientCertificate);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RequestedSessionTimeout);
}

gint ett_opcua_CreateSessionResponse = -1;
void parseCreateSessionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CreateSessionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSessionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RevisedSessionTimeout);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerNonce);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerCertificate);
  parseArrayComplex(subtree, tvb, pOffset, "ServerSoftwareCertificates", parseSignedSoftwareCertificate);
  parseSignatureData(subtree, tvb, pOffset, "ServerSignature");
}

gint ett_opcua_ActivateSessionRequest = -1;
void parseActivateSessionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ActivateSessionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ActivateSessionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseSignatureData(subtree, tvb, pOffset, "ClientSignature");
  parseArrayComplex(subtree, tvb, pOffset, "ClientSoftwareCertificates", parseSignedSoftwareCertificate);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LocaleIds, parseString);
  parseExtensionObject(subtree, tvb, pOffset, "UserIdentityToken");
  parseSignatureData(subtree, tvb, pOffset, "UserTokenSignature");
}

gint ett_opcua_ActivateSessionResponse = -1;
void parseActivateSessionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ActivateSessionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ActivateSessionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerNonce);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_CertificateResults, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "CertificateDiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_CloseSessionRequest = -1;
void parseCloseSessionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CloseSessionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSessionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
}

gint ett_opcua_CloseSessionResponse = -1;
void parseCloseSessionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CloseSessionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CloseSessionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
}

gint ett_opcua_CancelRequest = -1;
void parseCancelRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CancelRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CancelRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SequenceNumber);
}

gint ett_opcua_CancelResponse = -1;
void parseCancelResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CancelResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CancelResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
}

gint ett_opcua_AddNodesRequest = -1;
void parseAddNodesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "AddNodesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddNodesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "NodesToAdd", parseAddNodesItem);
}

gint ett_opcua_AddNodesResponse = -1;
void parseAddNodesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "AddNodesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddNodesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseAddNodesResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_AddReferencesRequest = -1;
void parseAddReferencesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "AddReferencesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddReferencesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "ReferencesToAdd", parseAddReferencesItem);
}

gint ett_opcua_AddReferencesResponse = -1;
void parseAddReferencesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "AddReferencesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddReferencesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_DeleteNodesRequest = -1;
void parseDeleteNodesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteNodesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteNodesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "NodesToDelete", parseDeleteNodesItem);
}

gint ett_opcua_DeleteNodesResponse = -1;
void parseDeleteNodesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteNodesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteNodesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "Diagnostics", parseDiagnosticInfo);
}

gint ett_opcua_DeleteReferencesRequest = -1;
void parseDeleteReferencesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteReferencesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteReferencesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "ReferencesToDelete", parseDeleteReferencesItem);
}

gint ett_opcua_DeleteReferencesResponse = -1;
void parseDeleteReferencesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteReferencesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteReferencesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_BrowsePropertiesRequest = -1;
void parseBrowsePropertiesRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "BrowsePropertiesRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowsePropertiesRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "NodesToAccess", parseNodeId);
  parseArrayComplex(subtree, tvb, pOffset, "Properties", parseQualifiedName);
}

gint ett_opcua_BrowsePropertiesResponse = -1;
void parseBrowsePropertiesResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "BrowsePropertiesResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowsePropertiesResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "NodeResults", parseBrowsePropertiesResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_BrowseRequest = -1;
void parseBrowseRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "BrowseRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseViewDescription(subtree, tvb, pOffset, "View");
  parseNodeId(subtree, tvb, pOffset, "NodeToBrowse");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxResultsToReturn);
  parseBrowseDirection(subtree, tvb, pOffset);
  parseNodeId(subtree, tvb, pOffset, "ReferenceTypeId");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IncludeSubtypes);
  parseInt32(subtree, tvb, pOffset, hf_opcua_NodeClassMask);
}

gint ett_opcua_BrowseResponse = -1;
void parseBrowseResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "BrowseResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
  parseArrayComplex(subtree, tvb, pOffset, "References", parseReferenceDescription);
}

gint ett_opcua_BrowseNextRequest = -1;
void parseBrowseNextRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "BrowseNextRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseNextRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ReleaseContinuationPoint);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
}

gint ett_opcua_BrowseNextResponse = -1;
void parseBrowseNextResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "BrowseNextResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowseNextResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseByteString(subtree, tvb, pOffset, hf_opcua_RevisedContinuationPoint);
  parseArrayComplex(subtree, tvb, pOffset, "References", parseReferenceDescription);
}

gint ett_opcua_TranslateBrowsePathsToNodeIdsRequest = -1;
void parseTranslateBrowsePathsToNodeIdsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TranslateBrowsePathsToNodeIdsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TranslateBrowsePathsToNodeIdsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "BrowsePaths", parseBrowsePath);
}

gint ett_opcua_TranslateBrowsePathsToNodeIdsResponse = -1;
void parseTranslateBrowsePathsToNodeIdsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TranslateBrowsePathsToNodeIdsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TranslateBrowsePathsToNodeIdsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseTranslateBrowsePathResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_QueryFirstRequest = -1;
void parseQueryFirstRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "QueryFirstRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryFirstRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseViewDescription(subtree, tvb, pOffset, "View");
  parseArrayComplex(subtree, tvb, pOffset, "NodeTypes", parseNodeTypeDescription);
  parseContentFilter(subtree, tvb, pOffset, "Filter");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxDescriptionsToReturn);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxReferencesToReturn);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxReferencedNodesToReturn);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxTime);
}

gint ett_opcua_QueryFirstResponse = -1;
void parseQueryFirstResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "QueryFirstResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryFirstResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "QueryDataSets", parseQueryDataSet);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseQueryResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfo", parseDiagnosticInfo);
  parseContentFilterResult(subtree, tvb, pOffset, "ContentFilterResult");
}

gint ett_opcua_QueryNextRequest = -1;
void parseQueryNextRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "QueryNextRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryNextRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ReleaseContinuationPoint);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
}

gint ett_opcua_QueryNextResponse = -1;
void parseQueryNextResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "QueryNextResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryNextResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "QueryDataSets", parseQueryDataSet);
  parseByteString(subtree, tvb, pOffset, hf_opcua_RevisedContinuationPoint);
}

gint ett_opcua_ReadRequest = -1;
void parseReadRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ReadRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseInt32(subtree, tvb, pOffset, hf_opcua_MaxAge);
  parseTimestampsToReturn(subtree, tvb, pOffset);
  parseArrayComplex(subtree, tvb, pOffset, "NodesToRead", parseReadValueId);
}

gint ett_opcua_ReadResponse = -1;
void parseReadResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ReadResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseDataValue);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_HistoryReadRequest = -1;
void parseHistoryReadRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "HistoryReadRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryReadRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseExtensionObject(subtree, tvb, pOffset, "HistoryReadDetails");
  parseTimestampsToReturn(subtree, tvb, pOffset);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ReleaseContinuationPoints);
  parseArrayComplex(subtree, tvb, pOffset, "NodesToRead", parseHistoryReadValueId);
}

gint ett_opcua_HistoryReadResponse = -1;
void parseHistoryReadResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "HistoryReadResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryReadResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseHistoryReadResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_WriteRequest = -1;
void parseWriteRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "WriteRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_WriteRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "NodesToWrite", parseWriteValue);
}

gint ett_opcua_WriteResponse = -1;
void parseWriteResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "WriteResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_WriteResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_HistoryUpdateRequest = -1;
void parseHistoryUpdateRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "HistoryUpdateRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryUpdateRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "HistoryUpdateDetails", parseExtensionObject);
}

gint ett_opcua_HistoryUpdateResponse = -1;
void parseHistoryUpdateResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "HistoryUpdateResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryUpdateResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseHistoryUpdateResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_CallRequest = -1;
void parseCallRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CallRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CallRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "MethodsToCall", parseCallRequestItem);
}

gint ett_opcua_CallResponse = -1;
void parseCallResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CallResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CallResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseCallResultItem);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_CreateMonitoredItemsRequest = -1;
void parseCreateMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CreateMonitoredItemsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateMonitoredItemsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseTimestampsToReturn(subtree, tvb, pOffset);
  parseArrayComplex(subtree, tvb, pOffset, "ItemsToCreate", parseMonitoredItemCreateRequest);
}

gint ett_opcua_CreateMonitoredItemsResponse = -1;
void parseCreateMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CreateMonitoredItemsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateMonitoredItemsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseMonitoredItemCreateResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_ModifyMonitoredItemsRequest = -1;
void parseModifyMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ModifyMonitoredItemsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifyMonitoredItemsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseTimestampsToReturn(subtree, tvb, pOffset);
  parseArrayComplex(subtree, tvb, pOffset, "ItemsToModify", parseMonitoredItemModifyRequest);
}

gint ett_opcua_ModifyMonitoredItemsResponse = -1;
void parseModifyMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ModifyMonitoredItemsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifyMonitoredItemsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseMonitoredItemModifyResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_SetMonitoringModeRequest = -1;
void parseSetMonitoringModeRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "SetMonitoringModeRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetMonitoringModeRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseMonitoringMode(subtree, tvb, pOffset);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_MonitoredItemIds, parseUInt32);
}

gint ett_opcua_SetMonitoringModeResponse = -1;
void parseSetMonitoringModeResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "SetMonitoringModeResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetMonitoringModeResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_SetTriggeringRequest = -1;
void parseSetTriggeringRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "SetTriggeringRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetTriggeringRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TriggeringItemId);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LinksToAdd, parseUInt32);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LinksToRemove, parseUInt32);
}

gint ett_opcua_SetTriggeringResponse = -1;
void parseSetTriggeringResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "SetTriggeringResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetTriggeringResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_AddResults, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "AddDiagnosticInfos", parseDiagnosticInfo);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_RemoveResults, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "RemoveDiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_DeleteMonitoredItemsRequest = -1;
void parseDeleteMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteMonitoredItemsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteMonitoredItemsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_MonitoredItemIds, parseUInt32);
}

gint ett_opcua_DeleteMonitoredItemsResponse = -1;
void parseDeleteMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteMonitoredItemsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteMonitoredItemsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_CreateSubscriptionRequest = -1;
void parseCreateSubscriptionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CreateSubscriptionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSubscriptionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseInt32(subtree, tvb, pOffset, hf_opcua_RequestedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedLifetimeCounter);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedMaxKeepAliveCount);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_PublishingEnabled);
  parseByte(subtree, tvb, pOffset, hf_opcua_Priority);
}

gint ett_opcua_CreateSubscriptionResponse = -1;
void parseCreateSubscriptionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "CreateSubscriptionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CreateSubscriptionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RevisedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedLifetimeCounter);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedMaxKeepAliveCount);
}

gint ett_opcua_ModifySubscriptionRequest = -1;
void parseModifySubscriptionRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ModifySubscriptionRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifySubscriptionRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RequestedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedLifetimeCounter);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestedMaxKeepAliveCount);
  parseByte(subtree, tvb, pOffset, hf_opcua_Priority);
}

gint ett_opcua_ModifySubscriptionResponse = -1;
void parseModifySubscriptionResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "ModifySubscriptionResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ModifySubscriptionResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseInt32(subtree, tvb, pOffset, hf_opcua_RevisedPublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedLifetimeCounter);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedMaxKeepAliveCount);
}

gint ett_opcua_SetPublishingModeRequest = -1;
void parseSetPublishingModeRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "SetPublishingModeRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetPublishingModeRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_PublishingEnabled);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SubscriptionIds, parseUInt32);
}

gint ett_opcua_SetPublishingModeResponse = -1;
void parseSetPublishingModeResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "SetPublishingModeResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SetPublishingModeResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_PublishRequest = -1;
void parsePublishRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "PublishRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_PublishRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArrayComplex(subtree, tvb, pOffset, "SubscriptionAcknowledgements", parseSubscriptionAcknowledgement);
}

gint ett_opcua_PublishResponse = -1;
void parsePublishResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "PublishResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_PublishResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_AvailableSequenceNumbers, parseUInt32);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_MoreNotifications);
  parseNotificationMessage(subtree, tvb, pOffset, "NotificationMessage");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_RepublishRequest = -1;
void parseRepublishRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "RepublishRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RepublishRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RetransmitSequenceNumber);
}

gint ett_opcua_RepublishResponse = -1;
void parseRepublishResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "RepublishResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RepublishResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseNotificationMessage(subtree, tvb, pOffset, "NotificationMessage");
}

gint ett_opcua_TransferSubscriptionsRequest = -1;
void parseTransferSubscriptionsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TransferSubscriptionsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TransferSubscriptionsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SubscriptionIds, parseUInt32);
}

gint ett_opcua_TransferSubscriptionsResponse = -1;
void parseTransferSubscriptionsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "TransferSubscriptionsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TransferSubscriptionsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArrayComplex(subtree, tvb, pOffset, "Results", parseTransferResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_DeleteSubscriptionsRequest = -1;
void parseDeleteSubscriptionsRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteSubscriptionsRequest");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteSubscriptionsRequest);

  parseRequestHeader(subtree, tvb, pOffset, "RequestHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SubscriptionIds, parseUInt32);
}

gint ett_opcua_DeleteSubscriptionsResponse = -1;
void parseDeleteSubscriptionsResponse(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "DeleteSubscriptionsResponse");
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteSubscriptionsResponse);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Results, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

/** Setup protocol subtree array */
static gint *ett[] =
{
  &ett_opcua_TestStackRequest,
  &ett_opcua_TestStackResponse,
  &ett_opcua_TestStackExRequest,
  &ett_opcua_TestStackExResponse,
  &ett_opcua_FindServersRequest,
  &ett_opcua_FindServersResponse,
  &ett_opcua_GetEndpointsRequest,
  &ett_opcua_GetEndpointsResponse,
  &ett_opcua_RegisterServerRequest,
  &ett_opcua_RegisterServerResponse,
  &ett_opcua_OpenSecureChannelRequest,
  &ett_opcua_OpenSecureChannelResponse,
  &ett_opcua_CloseSecureChannelRequest,
  &ett_opcua_CloseSecureChannelResponse,
  &ett_opcua_CreateSessionRequest,
  &ett_opcua_CreateSessionResponse,
  &ett_opcua_ActivateSessionRequest,
  &ett_opcua_ActivateSessionResponse,
  &ett_opcua_CloseSessionRequest,
  &ett_opcua_CloseSessionResponse,
  &ett_opcua_CancelRequest,
  &ett_opcua_CancelResponse,
  &ett_opcua_AddNodesRequest,
  &ett_opcua_AddNodesResponse,
  &ett_opcua_AddReferencesRequest,
  &ett_opcua_AddReferencesResponse,
  &ett_opcua_DeleteNodesRequest,
  &ett_opcua_DeleteNodesResponse,
  &ett_opcua_DeleteReferencesRequest,
  &ett_opcua_DeleteReferencesResponse,
  &ett_opcua_BrowsePropertiesRequest,
  &ett_opcua_BrowsePropertiesResponse,
  &ett_opcua_BrowseRequest,
  &ett_opcua_BrowseResponse,
  &ett_opcua_BrowseNextRequest,
  &ett_opcua_BrowseNextResponse,
  &ett_opcua_TranslateBrowsePathsToNodeIdsRequest,
  &ett_opcua_TranslateBrowsePathsToNodeIdsResponse,
  &ett_opcua_QueryFirstRequest,
  &ett_opcua_QueryFirstResponse,
  &ett_opcua_QueryNextRequest,
  &ett_opcua_QueryNextResponse,
  &ett_opcua_ReadRequest,
  &ett_opcua_ReadResponse,
  &ett_opcua_HistoryReadRequest,
  &ett_opcua_HistoryReadResponse,
  &ett_opcua_WriteRequest,
  &ett_opcua_WriteResponse,
  &ett_opcua_HistoryUpdateRequest,
  &ett_opcua_HistoryUpdateResponse,
  &ett_opcua_CallRequest,
  &ett_opcua_CallResponse,
  &ett_opcua_CreateMonitoredItemsRequest,
  &ett_opcua_CreateMonitoredItemsResponse,
  &ett_opcua_ModifyMonitoredItemsRequest,
  &ett_opcua_ModifyMonitoredItemsResponse,
  &ett_opcua_SetMonitoringModeRequest,
  &ett_opcua_SetMonitoringModeResponse,
  &ett_opcua_SetTriggeringRequest,
  &ett_opcua_SetTriggeringResponse,
  &ett_opcua_DeleteMonitoredItemsRequest,
  &ett_opcua_DeleteMonitoredItemsResponse,
  &ett_opcua_CreateSubscriptionRequest,
  &ett_opcua_CreateSubscriptionResponse,
  &ett_opcua_ModifySubscriptionRequest,
  &ett_opcua_ModifySubscriptionResponse,
  &ett_opcua_SetPublishingModeRequest,
  &ett_opcua_SetPublishingModeResponse,
  &ett_opcua_PublishRequest,
  &ett_opcua_PublishResponse,
  &ett_opcua_RepublishRequest,
  &ett_opcua_RepublishResponse,
  &ett_opcua_TransferSubscriptionsRequest,
  &ett_opcua_TransferSubscriptionsResponse,
  &ett_opcua_DeleteSubscriptionsRequest,
  &ett_opcua_DeleteSubscriptionsResponse,
};

void registerServiceTypes(void)
{
  proto_register_subtree_array(ett, array_length(ett));
}

