/* Do not modify this file.                                                   */
/* It is created automatically by the ASN.1 to Wireshark dissector compiler   */
/* .\packet-ftbp.c                                                            */
/* ../../tools/asn2wrs.py -b -X -T -e -p ftbp -c ftbp.cnf -s packet-ftbp-template ftbp.asn */

/* Input file: packet-ftbp-template.c */

#line 1 "packet-ftbp-template.c"
/* packet-ftbp.c
 * Routines for File Transfer Body Part (FTBP) dissection (used in X.420 content)
 * Graeme Lunt 2005
 *
 * $Id: packet-ftbp.c 22103 2007-06-14 19:05:20Z etxrab $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include <epan/conversation.h>
#include <epan/asn1.h>

#include <stdio.h>
#include <string.h>

#include "packet-ber.h"

#include "packet-acse.h"
#include "packet-ftam.h"
#include "packet-x411.h" 
#include "packet-x420.h" 

#include "packet-ftbp.h"

#define PNAME  "X.420 File Transfer Body Part"
#define PSNAME "FTBP"
#define PFNAME "ftbp"

/* Initialize the protocol and registered fields */
int proto_ftbp = -1;


/*--- Included file: packet-ftbp-hf.c ---*/
#line 1 "packet-ftbp-hf.c"
static int hf_ftbp_FileTransferParameters_PDU = -1;  /* FileTransferParameters */
static int hf_ftbp_FileTransferData_PDU = -1;     /* FileTransferData */
static int hf_ftbp_related_stored_file = -1;      /* RelatedStoredFile */
static int hf_ftbp_contents_type = -1;            /* ContentsTypeParameter */
static int hf_ftbp_environment = -1;              /* EnvironmentParameter */
static int hf_ftbp_compression = -1;              /* CompressionParameter */
static int hf_ftbp_file_attributes = -1;          /* FileAttributes */
static int hf_ftbp_extensions = -1;               /* ExtensionsField */
static int hf_ftbp_FileTransferData_item = -1;    /* EXTERNALt */
static int hf_ftbp_RelatedStoredFile_item = -1;   /* RelatedStoredFile_item */
static int hf_ftbp_file_identifier = -1;          /* FileIdentifier */
static int hf_ftbp_relationship = -1;             /* Relationship */
static int hf_ftbp_pathname_and_version = -1;     /* PathnameandVersion */
static int hf_ftbp_cross_reference = -1;          /* CrossReference */
static int hf_ftbp_pathname = -1;                 /* Pathname_Attribute */
static int hf_ftbp_file_version = -1;             /* GraphicString */
static int hf_ftbp_application_cross_reference = -1;  /* OCTET_STRING */
static int hf_ftbp_message_reference = -1;        /* MessageReference */
static int hf_ftbp_body_part_reference = -1;      /* INTEGER */
static int hf_ftbp_user = -1;                     /* ORName */
static int hf_ftbp_user_relative_identifier = -1;  /* PrintableString */
static int hf_ftbp_explicit_relationship = -1;    /* ExplicitRelationship */
static int hf_ftbp_descriptive_relationship = -1;  /* GraphicString */
static int hf_ftbp_document_type = -1;            /* T_document_type */
static int hf_ftbp_document_type_name = -1;       /* Document_Type_Name */
static int hf_ftbp_parameter = -1;                /* T_parameter */
static int hf_ftbp_constraint_set_and_abstract_syntax = -1;  /* T_constraint_set_and_abstract_syntax */
static int hf_ftbp_constraint_set_name = -1;      /* Constraint_Set_Name */
static int hf_ftbp_abstract_syntax_name = -1;     /* Abstract_Syntax_Name */
static int hf_ftbp_application_reference = -1;    /* GeneralIdentifier */
static int hf_ftbp_machine = -1;                  /* GeneralIdentifier */
static int hf_ftbp_operating_system = -1;         /* OBJECT_IDENTIFIER */
static int hf_ftbp_user_visible_string = -1;      /* T_user_visible_string */
static int hf_ftbp_user_visible_string_item = -1;  /* GraphicString */
static int hf_ftbp_registered_identifier = -1;    /* OBJECT_IDENTIFIER */
static int hf_ftbp_descriptive_identifier = -1;   /* T_descriptive_identifier */
static int hf_ftbp_descriptive_identifier_item = -1;  /* GraphicString */
static int hf_ftbp_compression_algorithm_id = -1;  /* OBJECT_IDENTIFIER */
static int hf_ftbp_compression_algorithm_param = -1;  /* T_compression_algorithm_param */
static int hf_ftbp_permitted_actions = -1;        /* Permitted_Actions_Attribute */
static int hf_ftbp_storage_account = -1;          /* Account_Attribute */
static int hf_ftbp_date_and_time_of_creation = -1;  /* Date_and_Time_Attribute */
static int hf_ftbp_date_and_time_of_last_modification = -1;  /* Date_and_Time_Attribute */
static int hf_ftbp_date_and_time_of_last_read_access = -1;  /* Date_and_Time_Attribute */
static int hf_ftbp_date_and_time_of_last_attribute_modification = -1;  /* Date_and_Time_Attribute */
static int hf_ftbp_identity_of_creator = -1;      /* User_Identity_Attribute */
static int hf_ftbp_identity_of_last_modifier = -1;  /* User_Identity_Attribute */
static int hf_ftbp_identity_of_last_reader = -1;  /* User_Identity_Attribute */
static int hf_ftbp_identity_of_last_attribute_modifier = -1;  /* User_Identity_Attribute */
static int hf_ftbp_object_availability = -1;      /* Object_Availability_Attribute */
static int hf_ftbp_object_size = -1;              /* Object_Size_Attribute */
static int hf_ftbp_future_object_size = -1;       /* Object_Size_Attribute */
static int hf_ftbp_access_control = -1;           /* Access_Control_Attribute */
static int hf_ftbp_legal_qualifications = -1;     /* Legal_Qualification_Attribute */
static int hf_ftbp_private_use = -1;              /* Private_Use_Attribute */
static int hf_ftbp_attribute_extensions = -1;     /* Attribute_Extensions */
static int hf_ftbp_incomplete_pathname = -1;      /* Pathname */
static int hf_ftbp_complete_pathname = -1;        /* Pathname */
static int hf_ftbp_no_value_available = -1;       /* NULL */
static int hf_ftbp_account_actual_values = -1;    /* Account */
static int hf_ftbp_identity_actual_values = -1;   /* User_Identity */
static int hf_ftbp_actual_values = -1;            /* SET_OF_Access_Control_Element */
static int hf_ftbp_actual_values_item = -1;       /* Access_Control_Element */
static int hf_ftbp_action_list = -1;              /* Access_Request */
static int hf_ftbp_concurrency_access = -1;       /* Concurrency_Access */
static int hf_ftbp_identity = -1;                 /* User_Identity */
static int hf_ftbp_passwords = -1;                /* Access_Passwords */
static int hf_ftbp_location = -1;                 /* Application_Entity_Title */
static int hf_ftbp_read_password = -1;            /* Password */
static int hf_ftbp_insert_password = -1;          /* Password */
static int hf_ftbp_replace_password = -1;         /* Password */
static int hf_ftbp_extend_password = -1;          /* Password */
static int hf_ftbp_erase_password = -1;           /* Password */
static int hf_ftbp_read_attribute_password = -1;  /* Password */
static int hf_ftbp_change_attribute_password = -1;  /* Password */
static int hf_ftbp_delete_password = -1;          /* Password */
static int hf_ftbp_pass_passwords = -1;           /* Pass_Passwords */
static int hf_ftbp_link_password = -1;            /* Password */
static int hf_ftbp_graphic_string = -1;           /* GraphicString */
static int hf_ftbp_octet_string = -1;             /* OCTET_STRING */
static int hf_ftbp_Pass_Passwords_item = -1;      /* Password */
static int hf_ftbp_ap_title = -1;                 /* AP_title */
static int hf_ftbp_ae_qualifier = -1;             /* AE_qualifier */
/* named bits */
static int hf_ftbp_Access_Request_read = -1;
static int hf_ftbp_Access_Request_insert = -1;
static int hf_ftbp_Access_Request_replace = -1;
static int hf_ftbp_Access_Request_extend = -1;
static int hf_ftbp_Access_Request_erase = -1;
static int hf_ftbp_Access_Request_read_attribute = -1;
static int hf_ftbp_Access_Request_change_attribute = -1;
static int hf_ftbp_Access_Request_delete_object = -1;

/*--- End of included file: packet-ftbp-hf.c ---*/
#line 55 "packet-ftbp-template.c"

/* Initialize the subtree pointers */
static gint ett_ftbp = -1;

/*--- Included file: packet-ftbp-ett.c ---*/
#line 1 "packet-ftbp-ett.c"
static gint ett_ftbp_FileTransferParameters = -1;
static gint ett_ftbp_FileTransferData = -1;
static gint ett_ftbp_RelatedStoredFile = -1;
static gint ett_ftbp_RelatedStoredFile_item = -1;
static gint ett_ftbp_FileIdentifier = -1;
static gint ett_ftbp_PathnameandVersion = -1;
static gint ett_ftbp_CrossReference = -1;
static gint ett_ftbp_MessageReference = -1;
static gint ett_ftbp_Relationship = -1;
static gint ett_ftbp_Contents_Type_Attribute = -1;
static gint ett_ftbp_T_document_type = -1;
static gint ett_ftbp_T_constraint_set_and_abstract_syntax = -1;
static gint ett_ftbp_EnvironmentParameter = -1;
static gint ett_ftbp_T_user_visible_string = -1;
static gint ett_ftbp_GeneralIdentifier = -1;
static gint ett_ftbp_T_descriptive_identifier = -1;
static gint ett_ftbp_CompressionParameter = -1;
static gint ett_ftbp_FileAttributes = -1;
static gint ett_ftbp_Pathname_Attribute = -1;
static gint ett_ftbp_Account_Attribute = -1;
static gint ett_ftbp_User_Identity_Attribute = -1;
static gint ett_ftbp_Access_Control_Attribute = -1;
static gint ett_ftbp_SET_OF_Access_Control_Element = -1;
static gint ett_ftbp_Access_Control_Element = -1;
static gint ett_ftbp_Access_Request = -1;
static gint ett_ftbp_Access_Passwords = -1;
static gint ett_ftbp_Password = -1;
static gint ett_ftbp_Pass_Passwords = -1;
static gint ett_ftbp_Application_Entity_Title = -1;

/*--- End of included file: packet-ftbp-ett.c ---*/
#line 59 "packet-ftbp-template.c"


/*--- Included file: packet-ftbp-fn.c ---*/
#line 1 "packet-ftbp-fn.c"

static const value_string ftbp_Pathname_Attribute_vals[] = {
  {   0, "incomplete-pathname" },
  {  23, "complete-pathname" },
  { 0, NULL }
};

static const ber_choice_t Pathname_Attribute_choice[] = {
  {   0, &hf_ftbp_incomplete_pathname, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftam_Pathname },
  {  23, &hf_ftbp_complete_pathname, BER_CLASS_CON, 23, BER_FLAGS_IMPLTAG, dissect_ftam_Pathname },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Pathname_Attribute(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 Pathname_Attribute_choice, hf_index, ett_ftbp_Pathname_Attribute,
                                 NULL);

  return offset;
}



static int
dissect_ftbp_GraphicString(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_GraphicString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t PathnameandVersion_sequence[] = {
  { &hf_ftbp_pathname       , BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Pathname_Attribute },
  { &hf_ftbp_file_version   , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_GraphicString },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_PathnameandVersion(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PathnameandVersion_sequence, hf_index, ett_ftbp_PathnameandVersion);

  return offset;
}



static int
dissect_ftbp_OCTET_STRING(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_ftbp_PrintableString(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_PrintableString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t MessageReference_set[] = {
  { &hf_ftbp_user           , BER_CLASS_CON, 0, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_x411_ORName },
  { &hf_ftbp_user_relative_identifier, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_ftbp_PrintableString },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_MessageReference(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set(implicit_tag, actx, tree, tvb, offset,
                              MessageReference_set, hf_index, ett_ftbp_MessageReference);

  return offset;
}



static int
dissect_ftbp_INTEGER(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t CrossReference_sequence[] = {
  { &hf_ftbp_application_cross_reference, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_OCTET_STRING },
  { &hf_ftbp_message_reference, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_MessageReference },
  { &hf_ftbp_body_part_reference, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_INTEGER },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_CrossReference(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CrossReference_sequence, hf_index, ett_ftbp_CrossReference);

  return offset;
}


static const value_string ftbp_FileIdentifier_vals[] = {
  {   0, "pathname-and-version" },
  {   1, "cross-reference" },
  { 0, NULL }
};

static const ber_choice_t FileIdentifier_choice[] = {
  {   0, &hf_ftbp_pathname_and_version, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_PathnameandVersion },
  {   1, &hf_ftbp_cross_reference, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_ftbp_CrossReference },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_FileIdentifier(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 FileIdentifier_choice, hf_index, ett_ftbp_FileIdentifier,
                                 NULL);

  return offset;
}


static const value_string ftbp_ExplicitRelationship_vals[] = {
  {   0, "unspecified" },
  {   1, "new-file" },
  {   2, "replacement" },
  {   3, "extension" },
  { 0, NULL }
};


static int
dissect_ftbp_ExplicitRelationship(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string ftbp_Relationship_vals[] = {
  {   0, "explicit-relationship" },
  {   1, "descriptive-relationship" },
  { 0, NULL }
};

static const ber_choice_t Relationship_choice[] = {
  {   0, &hf_ftbp_explicit_relationship, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_ExplicitRelationship },
  {   1, &hf_ftbp_descriptive_relationship, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_ftbp_GraphicString },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Relationship(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 Relationship_choice, hf_index, ett_ftbp_Relationship,
                                 NULL);

  return offset;
}


static const ber_sequence_t RelatedStoredFile_item_sequence[] = {
  { &hf_ftbp_file_identifier, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_FileIdentifier },
  { &hf_ftbp_relationship   , BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_OPTIONAL|BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Relationship },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_RelatedStoredFile_item(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RelatedStoredFile_item_sequence, hf_index, ett_ftbp_RelatedStoredFile_item);

  return offset;
}


static const ber_sequence_t RelatedStoredFile_set_of[1] = {
  { &hf_ftbp_RelatedStoredFile_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_ftbp_RelatedStoredFile_item },
};

static int
dissect_ftbp_RelatedStoredFile(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 RelatedStoredFile_set_of, hf_index, ett_ftbp_RelatedStoredFile);

  return offset;
}



static int
dissect_ftbp_Document_Type_Name(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_object_identifier(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_ftbp_T_parameter(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 23 "ftbp.cnf"
/* XXX: Not implemented yet */



  return offset;
}


static const ber_sequence_t T_document_type_sequence[] = {
  { &hf_ftbp_document_type_name, BER_CLASS_UNI, BER_UNI_TAG_OID, BER_FLAGS_NOOWNTAG, dissect_ftbp_Document_Type_Name },
  { &hf_ftbp_parameter      , BER_CLASS_CON, 0, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_T_parameter },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_T_document_type(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   T_document_type_sequence, hf_index, ett_ftbp_T_document_type);

  return offset;
}



static int
dissect_ftbp_Constraint_Set_Name(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_object_identifier(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_ftbp_Abstract_Syntax_Name(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_object_identifier(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const ber_sequence_t T_constraint_set_and_abstract_syntax_sequence[] = {
  { &hf_ftbp_constraint_set_name, BER_CLASS_UNI, BER_UNI_TAG_OID, BER_FLAGS_NOOWNTAG, dissect_ftbp_Constraint_Set_Name },
  { &hf_ftbp_abstract_syntax_name, BER_CLASS_UNI, BER_UNI_TAG_OID, BER_FLAGS_NOOWNTAG, dissect_ftbp_Abstract_Syntax_Name },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_T_constraint_set_and_abstract_syntax(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   T_constraint_set_and_abstract_syntax_sequence, hf_index, ett_ftbp_T_constraint_set_and_abstract_syntax);

  return offset;
}


static const value_string ftbp_Contents_Type_Attribute_vals[] = {
  {   0, "document-type" },
  {   1, "constraint-set-and-abstract-syntax" },
  { 0, NULL }
};

static const ber_choice_t Contents_Type_Attribute_choice[] = {
  {   0, &hf_ftbp_document_type  , BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_T_document_type },
  {   1, &hf_ftbp_constraint_set_and_abstract_syntax, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_ftbp_T_constraint_set_and_abstract_syntax },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Contents_Type_Attribute(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 Contents_Type_Attribute_choice, hf_index, ett_ftbp_Contents_Type_Attribute,
                                 NULL);

  return offset;
}



static int
dissect_ftbp_ContentsTypeParameter(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ftbp_Contents_Type_Attribute(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_ftbp_OBJECT_IDENTIFIER(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_object_identifier(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const ber_sequence_t T_descriptive_identifier_sequence_of[1] = {
  { &hf_ftbp_descriptive_identifier_item, BER_CLASS_UNI, BER_UNI_TAG_GraphicString, BER_FLAGS_NOOWNTAG, dissect_ftbp_GraphicString },
};

static int
dissect_ftbp_T_descriptive_identifier(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_descriptive_identifier_sequence_of, hf_index, ett_ftbp_T_descriptive_identifier);

  return offset;
}


static const value_string ftbp_GeneralIdentifier_vals[] = {
  {   0, "registered-identifier" },
  {   1, "descriptive-identifier" },
  { 0, NULL }
};

static const ber_choice_t GeneralIdentifier_choice[] = {
  {   0, &hf_ftbp_registered_identifier, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_OBJECT_IDENTIFIER },
  {   1, &hf_ftbp_descriptive_identifier, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_ftbp_T_descriptive_identifier },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_GeneralIdentifier(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 GeneralIdentifier_choice, hf_index, ett_ftbp_GeneralIdentifier,
                                 NULL);

  return offset;
}


static const ber_sequence_t T_user_visible_string_sequence_of[1] = {
  { &hf_ftbp_user_visible_string_item, BER_CLASS_UNI, BER_UNI_TAG_GraphicString, BER_FLAGS_NOOWNTAG, dissect_ftbp_GraphicString },
};

static int
dissect_ftbp_T_user_visible_string(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_user_visible_string_sequence_of, hf_index, ett_ftbp_T_user_visible_string);

  return offset;
}


static const ber_sequence_t EnvironmentParameter_sequence[] = {
  { &hf_ftbp_application_reference, BER_CLASS_CON, 0, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_GeneralIdentifier },
  { &hf_ftbp_machine        , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_GeneralIdentifier },
  { &hf_ftbp_operating_system, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_OBJECT_IDENTIFIER },
  { &hf_ftbp_user_visible_string, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_T_user_visible_string },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_EnvironmentParameter(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EnvironmentParameter_sequence, hf_index, ett_ftbp_EnvironmentParameter);

  return offset;
}



static int
dissect_ftbp_T_compression_algorithm_param(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 26 "ftbp.cnf"
/* XXX: Not implemented yet */

  return offset;
}


static const ber_sequence_t CompressionParameter_sequence[] = {
  { &hf_ftbp_compression_algorithm_id, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_OBJECT_IDENTIFIER },
  { &hf_ftbp_compression_algorithm_param, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_ftbp_T_compression_algorithm_param },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_CompressionParameter(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CompressionParameter_sequence, hf_index, ett_ftbp_CompressionParameter);

  return offset;
}



static int
dissect_ftbp_NULL(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_null(implicit_tag, actx, tree, tvb, offset, hf_index);

  return offset;
}



static int
dissect_ftbp_Account(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_GraphicString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string ftbp_Account_Attribute_vals[] = {
  {   0, "no-value-available" },
  {   1, "actual-values" },
  { 0, NULL }
};

static const ber_choice_t Account_Attribute_choice[] = {
  {   0, &hf_ftbp_no_value_available, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_NULL },
  {   1, &hf_ftbp_account_actual_values, BER_CLASS_UNI, BER_UNI_TAG_GraphicString, BER_FLAGS_NOOWNTAG, dissect_ftbp_Account },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Account_Attribute(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 Account_Attribute_choice, hf_index, ett_ftbp_Account_Attribute,
                                 NULL);

  return offset;
}



static int
dissect_ftbp_User_Identity(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_GraphicString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string ftbp_User_Identity_Attribute_vals[] = {
  {   0, "no-value-available" },
  {   1, "actual-values" },
  { 0, NULL }
};

static const ber_choice_t User_Identity_Attribute_choice[] = {
  {   0, &hf_ftbp_no_value_available, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_NULL },
  {   1, &hf_ftbp_identity_actual_values, BER_CLASS_UNI, BER_UNI_TAG_GraphicString, BER_FLAGS_NOOWNTAG, dissect_ftbp_User_Identity },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_User_Identity_Attribute(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 User_Identity_Attribute_choice, hf_index, ett_ftbp_User_Identity_Attribute,
                                 NULL);

  return offset;
}


static const asn_namedbit Access_Request_bits[] = {
  {  0, &hf_ftbp_Access_Request_read, -1, -1, "read", NULL },
  {  1, &hf_ftbp_Access_Request_insert, -1, -1, "insert", NULL },
  {  2, &hf_ftbp_Access_Request_replace, -1, -1, "replace", NULL },
  {  3, &hf_ftbp_Access_Request_extend, -1, -1, "extend", NULL },
  {  4, &hf_ftbp_Access_Request_erase, -1, -1, "erase", NULL },
  {  5, &hf_ftbp_Access_Request_read_attribute, -1, -1, "read-attribute", NULL },
  {  6, &hf_ftbp_Access_Request_change_attribute, -1, -1, "change-attribute", NULL },
  {  7, &hf_ftbp_Access_Request_delete_object, -1, -1, "delete-object", NULL },
  { 0, NULL, 0, 0, NULL, NULL }
};

static int
dissect_ftbp_Access_Request(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    Access_Request_bits, hf_index, ett_ftbp_Access_Request,
                                    NULL);

  return offset;
}


static const value_string ftbp_Password_vals[] = {
  {   0, "graphic-string" },
  {   1, "octet-string" },
  { 0, NULL }
};

static const ber_choice_t Password_choice[] = {
  {   0, &hf_ftbp_graphic_string , BER_CLASS_UNI, BER_UNI_TAG_GraphicString, BER_FLAGS_NOOWNTAG, dissect_ftbp_GraphicString },
  {   1, &hf_ftbp_octet_string   , BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_ftbp_OCTET_STRING },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Password(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 Password_choice, hf_index, ett_ftbp_Password,
                                 NULL);

  return offset;
}


static const ber_sequence_t Pass_Passwords_sequence_of[1] = {
  { &hf_ftbp_Pass_Passwords_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
};

static int
dissect_ftbp_Pass_Passwords(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      Pass_Passwords_sequence_of, hf_index, ett_ftbp_Pass_Passwords);

  return offset;
}


static const ber_sequence_t Access_Passwords_sequence[] = {
  { &hf_ftbp_read_password  , BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_insert_password, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_replace_password, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_extend_password, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_erase_password , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_read_attribute_password, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_change_attribute_password, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_delete_password, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { &hf_ftbp_pass_passwords , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_ftbp_Pass_Passwords },
  { &hf_ftbp_link_password  , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Password },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Access_Passwords(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Access_Passwords_sequence, hf_index, ett_ftbp_Access_Passwords);

  return offset;
}


static const ber_sequence_t Application_Entity_Title_sequence[] = {
  { &hf_ftbp_ap_title       , BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG, dissect_acse_AP_title },
  { &hf_ftbp_ae_qualifier   , BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG, dissect_acse_AE_qualifier },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Application_Entity_Title(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Application_Entity_Title_sequence, hf_index, ett_ftbp_Application_Entity_Title);

  return offset;
}


static const ber_sequence_t Access_Control_Element_sequence[] = {
  { &hf_ftbp_action_list    , BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_Access_Request },
  { &hf_ftbp_concurrency_access, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Concurrency_Access },
  { &hf_ftbp_identity       , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_User_Identity },
  { &hf_ftbp_passwords      , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_Access_Passwords },
  { &hf_ftbp_location       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_Application_Entity_Title },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Access_Control_Element(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Access_Control_Element_sequence, hf_index, ett_ftbp_Access_Control_Element);

  return offset;
}


static const ber_sequence_t SET_OF_Access_Control_Element_set_of[1] = {
  { &hf_ftbp_actual_values_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_ftbp_Access_Control_Element },
};

static int
dissect_ftbp_SET_OF_Access_Control_Element(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_Access_Control_Element_set_of, hf_index, ett_ftbp_SET_OF_Access_Control_Element);

  return offset;
}


static const value_string ftbp_Access_Control_Attribute_vals[] = {
  {   0, "no-value-available" },
  {   1, "actual-values" },
  { 0, NULL }
};

static const ber_choice_t Access_Control_Attribute_choice[] = {
  {   0, &hf_ftbp_no_value_available, BER_CLASS_CON, 0, BER_FLAGS_IMPLTAG, dissect_ftbp_NULL },
  {   1, &hf_ftbp_actual_values  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_ftbp_SET_OF_Access_Control_Element },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_Access_Control_Attribute(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 Access_Control_Attribute_choice, hf_index, ett_ftbp_Access_Control_Attribute,
                                 NULL);

  return offset;
}


static const ber_sequence_t FileAttributes_sequence[] = {
  { &hf_ftbp_pathname       , BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_OPTIONAL|BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Pathname_Attribute },
  { &hf_ftbp_permitted_actions, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Permitted_Actions_Attribute },
  { &hf_ftbp_storage_account, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Account_Attribute },
  { &hf_ftbp_date_and_time_of_creation, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Date_and_Time_Attribute },
  { &hf_ftbp_date_and_time_of_last_modification, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Date_and_Time_Attribute },
  { &hf_ftbp_date_and_time_of_last_read_access, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Date_and_Time_Attribute },
  { &hf_ftbp_date_and_time_of_last_attribute_modification, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Date_and_Time_Attribute },
  { &hf_ftbp_identity_of_creator, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_User_Identity_Attribute },
  { &hf_ftbp_identity_of_last_modifier, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_User_Identity_Attribute },
  { &hf_ftbp_identity_of_last_reader, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_User_Identity_Attribute },
  { &hf_ftbp_identity_of_last_attribute_modifier, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_User_Identity_Attribute },
  { &hf_ftbp_object_availability, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Object_Availability_Attribute },
  { &hf_ftbp_object_size    , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Object_Size_Attribute },
  { &hf_ftbp_future_object_size, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Object_Size_Attribute },
  { &hf_ftbp_access_control , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_Access_Control_Attribute },
  { &hf_ftbp_legal_qualifications, BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Legal_Qualification_Attribute },
  { &hf_ftbp_private_use    , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Private_Use_Attribute },
  { &hf_ftbp_attribute_extensions, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftam_Attribute_Extensions },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_FileAttributes(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FileAttributes_sequence, hf_index, ett_ftbp_FileAttributes);

  return offset;
}


static const ber_sequence_t FileTransferParameters_sequence[] = {
  { &hf_ftbp_related_stored_file, BER_CLASS_CON, 0, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_RelatedStoredFile },
  { &hf_ftbp_contents_type  , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_ftbp_ContentsTypeParameter },
  { &hf_ftbp_environment    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_EnvironmentParameter },
  { &hf_ftbp_compression    , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_CompressionParameter },
  { &hf_ftbp_file_attributes, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_ftbp_FileAttributes },
  { &hf_ftbp_extensions     , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_x420_ExtensionsField },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_ftbp_FileTransferParameters(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FileTransferParameters_sequence, hf_index, ett_ftbp_FileTransferParameters);

  return offset;
}


static const ber_sequence_t FileTransferData_sequence_of[1] = {
  { &hf_ftbp_FileTransferData_item, BER_CLASS_UNI, 8, BER_FLAGS_NOOWNTAG, dissect_acse_EXTERNALt },
};

static int
dissect_ftbp_FileTransferData(gboolean implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      FileTransferData_sequence_of, hf_index, ett_ftbp_FileTransferData);

  return offset;
}

/*--- PDUs ---*/

static void dissect_FileTransferParameters_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_) {
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_BER, TRUE, pinfo);
  dissect_ftbp_FileTransferParameters(FALSE, tvb, 0, &asn1_ctx, tree, hf_ftbp_FileTransferParameters_PDU);
}
static void dissect_FileTransferData_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_) {
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_BER, TRUE, pinfo);
  dissect_ftbp_FileTransferData(FALSE, tvb, 0, &asn1_ctx, tree, hf_ftbp_FileTransferData_PDU);
}


/*--- End of included file: packet-ftbp-fn.c ---*/
#line 61 "packet-ftbp-template.c"


/*--- proto_register_ftbp -------------------------------------------*/
void proto_register_ftbp(void) {

  /* List of fields */
  static hf_register_info hf[] =
  {

/*--- Included file: packet-ftbp-hfarr.c ---*/
#line 1 "packet-ftbp-hfarr.c"
    { &hf_ftbp_FileTransferParameters_PDU,
      { "FileTransferParameters", "ftbp.FileTransferParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.FileTransferParameters", HFILL }},
    { &hf_ftbp_FileTransferData_PDU,
      { "FileTransferData", "ftbp.FileTransferData",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftbp.FileTransferData", HFILL }},
    { &hf_ftbp_related_stored_file,
      { "related-stored-file", "ftbp.related_stored_file",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftbp.RelatedStoredFile", HFILL }},
    { &hf_ftbp_contents_type,
      { "contents-type", "ftbp.contents_type",
        FT_UINT32, BASE_DEC, VALS(ftbp_Contents_Type_Attribute_vals), 0,
        "ftbp.ContentsTypeParameter", HFILL }},
    { &hf_ftbp_environment,
      { "environment", "ftbp.environment",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.EnvironmentParameter", HFILL }},
    { &hf_ftbp_compression,
      { "compression", "ftbp.compression",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.CompressionParameter", HFILL }},
    { &hf_ftbp_file_attributes,
      { "file-attributes", "ftbp.file_attributes",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.FileAttributes", HFILL }},
    { &hf_ftbp_extensions,
      { "extensions", "ftbp.extensions",
        FT_UINT32, BASE_DEC, NULL, 0,
        "x420.ExtensionsField", HFILL }},
    { &hf_ftbp_FileTransferData_item,
      { "Item", "ftbp.FileTransferData_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "acse.EXTERNALt", HFILL }},
    { &hf_ftbp_RelatedStoredFile_item,
      { "Item", "ftbp.RelatedStoredFile_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.RelatedStoredFile_item", HFILL }},
    { &hf_ftbp_file_identifier,
      { "file-identifier", "ftbp.file_identifier",
        FT_UINT32, BASE_DEC, VALS(ftbp_FileIdentifier_vals), 0,
        "ftbp.FileIdentifier", HFILL }},
    { &hf_ftbp_relationship,
      { "relationship", "ftbp.relationship",
        FT_UINT32, BASE_DEC, VALS(ftbp_Relationship_vals), 0,
        "ftbp.Relationship", HFILL }},
    { &hf_ftbp_pathname_and_version,
      { "pathname-and-version", "ftbp.pathname_and_version",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.PathnameandVersion", HFILL }},
    { &hf_ftbp_cross_reference,
      { "cross-reference", "ftbp.cross_reference",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.CrossReference", HFILL }},
    { &hf_ftbp_pathname,
      { "pathname", "ftbp.pathname",
        FT_UINT32, BASE_DEC, VALS(ftbp_Pathname_Attribute_vals), 0,
        "ftbp.Pathname_Attribute", HFILL }},
    { &hf_ftbp_file_version,
      { "file-version", "ftbp.file_version",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.GraphicString", HFILL }},
    { &hf_ftbp_application_cross_reference,
      { "application-cross-reference", "ftbp.application_cross_reference",
        FT_BYTES, BASE_HEX, NULL, 0,
        "ftbp.OCTET_STRING", HFILL }},
    { &hf_ftbp_message_reference,
      { "message-reference", "ftbp.message_reference",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.MessageReference", HFILL }},
    { &hf_ftbp_body_part_reference,
      { "body-part-reference", "ftbp.body_part_reference",
        FT_INT32, BASE_DEC, NULL, 0,
        "ftbp.INTEGER", HFILL }},
    { &hf_ftbp_user,
      { "user", "ftbp.user",
        FT_NONE, BASE_NONE, NULL, 0,
        "x411.ORName", HFILL }},
    { &hf_ftbp_user_relative_identifier,
      { "user-relative-identifier", "ftbp.user_relative_identifier",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.PrintableString", HFILL }},
    { &hf_ftbp_explicit_relationship,
      { "explicit-relationship", "ftbp.explicit_relationship",
        FT_INT32, BASE_DEC, VALS(ftbp_ExplicitRelationship_vals), 0,
        "ftbp.ExplicitRelationship", HFILL }},
    { &hf_ftbp_descriptive_relationship,
      { "descriptive-relationship", "ftbp.descriptive_relationship",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.GraphicString", HFILL }},
    { &hf_ftbp_document_type,
      { "document-type", "ftbp.document_type",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.T_document_type", HFILL }},
    { &hf_ftbp_document_type_name,
      { "document-type-name", "ftbp.document_type_name",
        FT_OID, BASE_NONE, NULL, 0,
        "ftbp.Document_Type_Name", HFILL }},
    { &hf_ftbp_parameter,
      { "parameter", "ftbp.parameter",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.T_parameter", HFILL }},
    { &hf_ftbp_constraint_set_and_abstract_syntax,
      { "constraint-set-and-abstract-syntax", "ftbp.constraint_set_and_abstract_syntax",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.T_constraint_set_and_abstract_syntax", HFILL }},
    { &hf_ftbp_constraint_set_name,
      { "constraint-set-name", "ftbp.constraint_set_name",
        FT_OID, BASE_NONE, NULL, 0,
        "ftbp.Constraint_Set_Name", HFILL }},
    { &hf_ftbp_abstract_syntax_name,
      { "abstract-syntax-name", "ftbp.abstract_syntax_name",
        FT_OID, BASE_NONE, NULL, 0,
        "ftbp.Abstract_Syntax_Name", HFILL }},
    { &hf_ftbp_application_reference,
      { "application-reference", "ftbp.application_reference",
        FT_UINT32, BASE_DEC, VALS(ftbp_GeneralIdentifier_vals), 0,
        "ftbp.GeneralIdentifier", HFILL }},
    { &hf_ftbp_machine,
      { "machine", "ftbp.machine",
        FT_UINT32, BASE_DEC, VALS(ftbp_GeneralIdentifier_vals), 0,
        "ftbp.GeneralIdentifier", HFILL }},
    { &hf_ftbp_operating_system,
      { "operating-system", "ftbp.operating_system",
        FT_OID, BASE_NONE, NULL, 0,
        "ftbp.OBJECT_IDENTIFIER", HFILL }},
    { &hf_ftbp_user_visible_string,
      { "user-visible-string", "ftbp.user_visible_string",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftbp.T_user_visible_string", HFILL }},
    { &hf_ftbp_user_visible_string_item,
      { "Item", "ftbp.user_visible_string_item",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.GraphicString", HFILL }},
    { &hf_ftbp_registered_identifier,
      { "registered-identifier", "ftbp.registered_identifier",
        FT_OID, BASE_NONE, NULL, 0,
        "ftbp.OBJECT_IDENTIFIER", HFILL }},
    { &hf_ftbp_descriptive_identifier,
      { "descriptive-identifier", "ftbp.descriptive_identifier",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftbp.T_descriptive_identifier", HFILL }},
    { &hf_ftbp_descriptive_identifier_item,
      { "Item", "ftbp.descriptive_identifier_item",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.GraphicString", HFILL }},
    { &hf_ftbp_compression_algorithm_id,
      { "compression-algorithm-id", "ftbp.compression_algorithm_id",
        FT_OID, BASE_NONE, NULL, 0,
        "ftbp.OBJECT_IDENTIFIER", HFILL }},
    { &hf_ftbp_compression_algorithm_param,
      { "compression-algorithm-param", "ftbp.compression_algorithm_param",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.T_compression_algorithm_param", HFILL }},
    { &hf_ftbp_permitted_actions,
      { "permitted-actions", "ftbp.permitted_actions",
        FT_BYTES, BASE_HEX, NULL, 0,
        "ftam.Permitted_Actions_Attribute", HFILL }},
    { &hf_ftbp_storage_account,
      { "storage-account", "ftbp.storage_account",
        FT_UINT32, BASE_DEC, VALS(ftbp_Account_Attribute_vals), 0,
        "ftbp.Account_Attribute", HFILL }},
    { &hf_ftbp_date_and_time_of_creation,
      { "date-and-time-of-creation", "ftbp.date_and_time_of_creation",
        FT_UINT32, BASE_DEC, VALS(ftam_Date_and_Time_Attribute_vals), 0,
        "ftam.Date_and_Time_Attribute", HFILL }},
    { &hf_ftbp_date_and_time_of_last_modification,
      { "date-and-time-of-last-modification", "ftbp.date_and_time_of_last_modification",
        FT_UINT32, BASE_DEC, VALS(ftam_Date_and_Time_Attribute_vals), 0,
        "ftam.Date_and_Time_Attribute", HFILL }},
    { &hf_ftbp_date_and_time_of_last_read_access,
      { "date-and-time-of-last-read-access", "ftbp.date_and_time_of_last_read_access",
        FT_UINT32, BASE_DEC, VALS(ftam_Date_and_Time_Attribute_vals), 0,
        "ftam.Date_and_Time_Attribute", HFILL }},
    { &hf_ftbp_date_and_time_of_last_attribute_modification,
      { "date-and-time-of-last-attribute-modification", "ftbp.date_and_time_of_last_attribute_modification",
        FT_UINT32, BASE_DEC, VALS(ftam_Date_and_Time_Attribute_vals), 0,
        "ftam.Date_and_Time_Attribute", HFILL }},
    { &hf_ftbp_identity_of_creator,
      { "identity-of-creator", "ftbp.identity_of_creator",
        FT_UINT32, BASE_DEC, VALS(ftbp_User_Identity_Attribute_vals), 0,
        "ftbp.User_Identity_Attribute", HFILL }},
    { &hf_ftbp_identity_of_last_modifier,
      { "identity-of-last-modifier", "ftbp.identity_of_last_modifier",
        FT_UINT32, BASE_DEC, VALS(ftbp_User_Identity_Attribute_vals), 0,
        "ftbp.User_Identity_Attribute", HFILL }},
    { &hf_ftbp_identity_of_last_reader,
      { "identity-of-last-reader", "ftbp.identity_of_last_reader",
        FT_UINT32, BASE_DEC, VALS(ftbp_User_Identity_Attribute_vals), 0,
        "ftbp.User_Identity_Attribute", HFILL }},
    { &hf_ftbp_identity_of_last_attribute_modifier,
      { "identity-of-last-attribute-modifier", "ftbp.identity_of_last_attribute_modifier",
        FT_UINT32, BASE_DEC, VALS(ftbp_User_Identity_Attribute_vals), 0,
        "ftbp.User_Identity_Attribute", HFILL }},
    { &hf_ftbp_object_availability,
      { "object-availability", "ftbp.object_availability",
        FT_UINT32, BASE_DEC, VALS(ftam_Object_Availability_Attribute_vals), 0,
        "ftam.Object_Availability_Attribute", HFILL }},
    { &hf_ftbp_object_size,
      { "object-size", "ftbp.object_size",
        FT_UINT32, BASE_DEC, VALS(ftam_Object_Size_Attribute_vals), 0,
        "ftam.Object_Size_Attribute", HFILL }},
    { &hf_ftbp_future_object_size,
      { "future-object-size", "ftbp.future_object_size",
        FT_UINT32, BASE_DEC, VALS(ftam_Object_Size_Attribute_vals), 0,
        "ftam.Object_Size_Attribute", HFILL }},
    { &hf_ftbp_access_control,
      { "access-control", "ftbp.access_control",
        FT_UINT32, BASE_DEC, VALS(ftbp_Access_Control_Attribute_vals), 0,
        "ftbp.Access_Control_Attribute", HFILL }},
    { &hf_ftbp_legal_qualifications,
      { "legal-qualifications", "ftbp.legal_qualifications",
        FT_UINT32, BASE_DEC, VALS(ftam_Legal_Qualification_Attribute_vals), 0,
        "ftam.Legal_Qualification_Attribute", HFILL }},
    { &hf_ftbp_private_use,
      { "private-use", "ftbp.private_use",
        FT_UINT32, BASE_DEC, VALS(ftam_Private_Use_Attribute_vals), 0,
        "ftam.Private_Use_Attribute", HFILL }},
    { &hf_ftbp_attribute_extensions,
      { "attribute-extensions", "ftbp.attribute_extensions",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftam.Attribute_Extensions", HFILL }},
    { &hf_ftbp_incomplete_pathname,
      { "incomplete-pathname", "ftbp.incomplete_pathname",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftam.Pathname", HFILL }},
    { &hf_ftbp_complete_pathname,
      { "complete-pathname", "ftbp.complete_pathname",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftam.Pathname", HFILL }},
    { &hf_ftbp_no_value_available,
      { "no-value-available", "ftbp.no_value_available",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.NULL", HFILL }},
    { &hf_ftbp_account_actual_values,
      { "actual-values", "ftbp.actual_values",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.Account", HFILL }},
    { &hf_ftbp_identity_actual_values,
      { "actual-values", "ftbp.actual_values",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.User_Identity", HFILL }},
    { &hf_ftbp_actual_values,
      { "actual-values", "ftbp.actual_values",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftbp.SET_OF_Access_Control_Element", HFILL }},
    { &hf_ftbp_actual_values_item,
      { "Item", "ftbp.actual_values_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.Access_Control_Element", HFILL }},
    { &hf_ftbp_action_list,
      { "action-list", "ftbp.action_list",
        FT_BYTES, BASE_HEX, NULL, 0,
        "ftbp.Access_Request", HFILL }},
    { &hf_ftbp_concurrency_access,
      { "concurrency-access", "ftbp.concurrency_access",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftam.Concurrency_Access", HFILL }},
    { &hf_ftbp_identity,
      { "identity", "ftbp.identity",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.User_Identity", HFILL }},
    { &hf_ftbp_passwords,
      { "passwords", "ftbp.passwords",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.Access_Passwords", HFILL }},
    { &hf_ftbp_location,
      { "location", "ftbp.location",
        FT_NONE, BASE_NONE, NULL, 0,
        "ftbp.Application_Entity_Title", HFILL }},
    { &hf_ftbp_read_password,
      { "read-password", "ftbp.read_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_insert_password,
      { "insert-password", "ftbp.insert_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_replace_password,
      { "replace-password", "ftbp.replace_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_extend_password,
      { "extend-password", "ftbp.extend_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_erase_password,
      { "erase-password", "ftbp.erase_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_read_attribute_password,
      { "read-attribute-password", "ftbp.read_attribute_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_change_attribute_password,
      { "change-attribute-password", "ftbp.change_attribute_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_delete_password,
      { "delete-password", "ftbp.delete_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_pass_passwords,
      { "pass-passwords", "ftbp.pass_passwords",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ftbp.Pass_Passwords", HFILL }},
    { &hf_ftbp_link_password,
      { "link-password", "ftbp.link_password",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_graphic_string,
      { "graphic-string", "ftbp.graphic_string",
        FT_STRING, BASE_NONE, NULL, 0,
        "ftbp.GraphicString", HFILL }},
    { &hf_ftbp_octet_string,
      { "octet-string", "ftbp.octet_string",
        FT_BYTES, BASE_HEX, NULL, 0,
        "ftbp.OCTET_STRING", HFILL }},
    { &hf_ftbp_Pass_Passwords_item,
      { "Item", "ftbp.Pass_Passwords_item",
        FT_UINT32, BASE_DEC, VALS(ftbp_Password_vals), 0,
        "ftbp.Password", HFILL }},
    { &hf_ftbp_ap_title,
      { "ap-title", "ftbp.ap_title",
        FT_UINT32, BASE_DEC, VALS(acse_AP_title_vals), 0,
        "acse.AP_title", HFILL }},
    { &hf_ftbp_ae_qualifier,
      { "ae-qualifier", "ftbp.ae_qualifier",
        FT_UINT32, BASE_DEC, VALS(acse_ASO_qualifier_vals), 0,
        "acse.AE_qualifier", HFILL }},
    { &hf_ftbp_Access_Request_read,
      { "read", "ftbp.read",
        FT_BOOLEAN, 8, NULL, 0x80,
        "", HFILL }},
    { &hf_ftbp_Access_Request_insert,
      { "insert", "ftbp.insert",
        FT_BOOLEAN, 8, NULL, 0x40,
        "", HFILL }},
    { &hf_ftbp_Access_Request_replace,
      { "replace", "ftbp.replace",
        FT_BOOLEAN, 8, NULL, 0x20,
        "", HFILL }},
    { &hf_ftbp_Access_Request_extend,
      { "extend", "ftbp.extend",
        FT_BOOLEAN, 8, NULL, 0x10,
        "", HFILL }},
    { &hf_ftbp_Access_Request_erase,
      { "erase", "ftbp.erase",
        FT_BOOLEAN, 8, NULL, 0x08,
        "", HFILL }},
    { &hf_ftbp_Access_Request_read_attribute,
      { "read-attribute", "ftbp.read-attribute",
        FT_BOOLEAN, 8, NULL, 0x04,
        "", HFILL }},
    { &hf_ftbp_Access_Request_change_attribute,
      { "change-attribute", "ftbp.change-attribute",
        FT_BOOLEAN, 8, NULL, 0x02,
        "", HFILL }},
    { &hf_ftbp_Access_Request_delete_object,
      { "delete-object", "ftbp.delete-object",
        FT_BOOLEAN, 8, NULL, 0x01,
        "", HFILL }},

/*--- End of included file: packet-ftbp-hfarr.c ---*/
#line 70 "packet-ftbp-template.c"
  };

  /* List of subtrees */
  static gint *ett[] = {
    &ett_ftbp,

/*--- Included file: packet-ftbp-ettarr.c ---*/
#line 1 "packet-ftbp-ettarr.c"
    &ett_ftbp_FileTransferParameters,
    &ett_ftbp_FileTransferData,
    &ett_ftbp_RelatedStoredFile,
    &ett_ftbp_RelatedStoredFile_item,
    &ett_ftbp_FileIdentifier,
    &ett_ftbp_PathnameandVersion,
    &ett_ftbp_CrossReference,
    &ett_ftbp_MessageReference,
    &ett_ftbp_Relationship,
    &ett_ftbp_Contents_Type_Attribute,
    &ett_ftbp_T_document_type,
    &ett_ftbp_T_constraint_set_and_abstract_syntax,
    &ett_ftbp_EnvironmentParameter,
    &ett_ftbp_T_user_visible_string,
    &ett_ftbp_GeneralIdentifier,
    &ett_ftbp_T_descriptive_identifier,
    &ett_ftbp_CompressionParameter,
    &ett_ftbp_FileAttributes,
    &ett_ftbp_Pathname_Attribute,
    &ett_ftbp_Account_Attribute,
    &ett_ftbp_User_Identity_Attribute,
    &ett_ftbp_Access_Control_Attribute,
    &ett_ftbp_SET_OF_Access_Control_Element,
    &ett_ftbp_Access_Control_Element,
    &ett_ftbp_Access_Request,
    &ett_ftbp_Access_Passwords,
    &ett_ftbp_Password,
    &ett_ftbp_Pass_Passwords,
    &ett_ftbp_Application_Entity_Title,

/*--- End of included file: packet-ftbp-ettarr.c ---*/
#line 76 "packet-ftbp-template.c"
  };

  /* Register protocol */
  proto_ftbp = proto_register_protocol(PNAME, PSNAME, PFNAME);

  /* Register fields and subtrees */
  proto_register_field_array(proto_ftbp, hf, array_length(hf));
  proto_register_subtree_array(ett, array_length(ett));

}


/*--- proto_reg_handoff_ftbp --- */
void proto_reg_handoff_ftbp(void) {

/*--- Included file: packet-ftbp-dis-tab.c ---*/
#line 1 "packet-ftbp-dis-tab.c"
  register_ber_oid_dissector("2.6.1.11.12", dissect_FileTransferParameters_PDU, proto_ftbp, "id-ep-file-transfer");
  register_ber_oid_dissector("2.6.1.4.12", dissect_FileTransferData_PDU, proto_ftbp, "id-et-file-transfer");


/*--- End of included file: packet-ftbp-dis-tab.c ---*/
#line 91 "packet-ftbp-template.c"

}
